#############################################################################
##
#A   tbl/cmp16_22.g               CHEVIE library                   Jean MICHEL
##
#Y  Copyright (C) 1998 - 2001 The CHEVIE Team
##
##  This file contains data about the complex reflection group
##  of type G16..G22 in the Shephard-Todd classification.
##
## The data comes from the paper of G.Malle ``Degres relatifs des algebres
##  de Hecke cyclotomiques associees aux groupes de reflexions complexes
##  de dimension 2'',  in ``Finite reductive groups'', Progress in
##  mathematics n0 141, Birkhauser 1997, to which should be added
## the following info:
## -- the subalgebra H' is generated by:
## G16: T3, T1 T3 T1^{-1}
## G17: T1, T3
## G18: T2, T3
## G19, T1, T2, T3
## G20: T2, T1 T2 T1^{-1}
## G21: T1, T2
## G22: T1, T2 T1 T2^{-1}, T2^{-1} T1 T2
## -- there is a misprint in the relative degrees of the 3-dimensional
##    characters of G19:
##    The numerator should read x1^10x2^15y1^7z1^3z4^12
##
CHEVIE.Revision("tbl/cmp16_22.g",
   "$Id: cmp16_22.g,v 1.5 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("PrintDiagram","G16_22",function(arg)local ST,indices,title,s,f;
  ST:=arg[1];indices:=arg[2];title:=arg[3];
  Print(title," ");s:=String("",Length(title)-1);
  f:=function(arg)return IntListToString(indices{arg});end;
  if ST=16 then Print(indices[1],"(5)--",indices[2],"(5)\n");
  elif ST=17 then Print(indices[1],"--6--",indices[2],"(5)\n");
  elif ST=18 then Print(indices[1],"(3)==",indices[2],"(5)\n");
  elif ST=19 then Print(indices[2],"(3)\n", s," /3\\\n",
    s,indices[1],"---",indices[3],"(5) ",
    f(1,2,3),"=",f(2,3,1),"=",f(3,1,2),"\n");
  elif ST=20 then Print(indices[1],"(3)--5--",indices[2],"(3)\n");
  elif ST=21 then Print(indices[1],"--10--",indices[2],"(3)\n");
  elif ST=22 then Print(indices[2],"\n",s," /5\\\n",
    s,indices[1],"---",indices[3]," ",
    f(1,2,3,1,2),"=",f(2,3,1,2,3),"=",f(3,1,2,3,1),"\n");
  fi;
end);

CHEVIE.AddData("ReflectionName","G16_22",function(arg)local n,option;
  option:=arg[Length(arg)];n:=arg[1];
  if IsBound(option.TeX) then n:=SPrint("G_{",n,"}");else n:=SPrint("G",n);fi;
  if Length(arg)=3 then PrintToString(n,"(",Format(arg[2],option),")");fi;
  return n;end);

CHEVIE.AddData("BraidRelations","G16_22",function(ST)
  if ST=16 then return [[[1,2,1],[2,1,2]]];
  elif ST=17 then return [[[1,2,1,2,1,2],[2,1,2,1,2,1]]];
  elif ST=18 then return [[[1,2,1,2],[2,1,2,1]]];
  elif ST=19 then return [[[1,2,3],[2,3,1]],[[1,2,3],[3,1,2]]];
  elif ST=20 then return [[[1,2,1,2,1],[2,1,2,1,2]]];
  elif ST=21 then return [[[1,2,1,2,1,2,1,2,1,2],[2,1,2,1,2,1,2,1,2,1]]];
  elif ST=22 then return [[[1,2,3,1,2],[2,3,1,2,3]],[[1,2,3,1,2],[3,1,2,3,1]]];
  fi;
end);

CHEVIE.AddData("Size","G16_22", function(n) local s;
  s := [ 600, 1200, 1800, 3600, 360, 720, 240 ];
  return s[n-15]; end);

CHEVIE.AddData("NrConjugacyClasses","G16_22", function(n) local l;
  l:=[45,90,135,270,27,54,18]; return l[n-15];
  end);

CHEVIE.AddData("paramclasses","G16_22",Concatenation(
      List([[1,60],[2,30],[3,60],[4,60],[5,60]],
	i->List([1..i[2]]-1,j->[i[1],j]))));

CHEVIE.AddData("paramchars","G16_22",
               Concatenation(Cartesian([1],[1..2],[1..3],[1..5]),
			     Cartesian([2],[1..2],[1..3],[1..10]),
			     Cartesian([3],[1..3],[1..2],[1..10]),
			     Cartesian([4],[1..4],[1..3],[1..5]),
			     Cartesian([5],[1..5],[1..2],[1..3]),
			     Cartesian([6],[1..6],[1..5])));

CHEVIE.AddData("GeneratingRoots","G16_22",function(n)local l;
  l:=[[[0,1],[(2*E(5)^4+3*E(5))/ER(5)-1,(E(5)-E(5)^3)/ER(5)]],
#     [[1, E(20)-E(20)^8-E(20)^9-E(20)^12 ],[0,1]],
      [[(E(20)^17-E(20)^13)/ER(5),
        (E(20)^16-E(20)^12-E(20)^9-E(20)^8+E(20)^4+E(20))/ER(5)],[0,1]],
      [[1,E(15)^14+E(15)^13+E(15)^11+E(15)],[0,E(5)^4-E(5)]],
      [[1, E(20)-E(20)^8-E(20)^9-E(20)^12 ],
       [1,E(15)+E(15)^11+E(15)^13+E(15)^14 ], [ 0, -E(20)+E(20)^9 ]],
      [[0,(-1+ER(5))/2],(3-ER(-3))*[(-5+3*ER(5))/2,1]/6],
#     [[1,E(20)-E(20)^8-E(20)^9-E(20)^12],[1,E(15)+E(15)^11+E(15)^13+E(15)^14]],
[ [ -3*E(60)^7-2*E(60)^19-2*E(60)^31-3*E(60)^43, 
      E(60)^4+2*E(60)^8+E(60)^16-E(60)^19+E(60)^28-E(60)^31+2*E(60)^32
         +2*E(60)^44+E(60)^52+2*E(60)^56 ], [ 0, -2*E(3)-E(3)^2 ] ],
#      [[1,-E(20)^4-E(20)^13-E(20)^16+E(20)^17 ],[E(20),1],[-E(20)^9,1]]];
 [[1,E(20)^17-E(20)^16-E(20)^13-E(20)^4],[E(20)^16+E(20)^13+E(20)^12+E(20)^8
  +E(20)^4+E(20),-E(20)^16+E(20)^9-E(20)^8-E(20)^4],[E(20)^17-E(20)^16
  -E(20)^12+E(20)^9-E(20)^8-E(20)^4,E(20)^16+E(20)^12+E(20)^4+E(20)]]];
  return l[n-15];
end);

CHEVIE.AddData("GeneratingCoRoots","G16_22",function(n)local l;
  l:=[[[0,-E(5)^4-E(5)^3-E(5)^2-2*E(5)],[(1-ER(5))/2,-E(5)]],
# [[ER(-5)+(E(5)^4-E(5)),(E(5)^2-E(5)^3)]/ER(-5),[0,ER(5)-2*E(5)^4-3*E(5)]],
  [[E(20)^12-E(20)^9+E(20)^8+E(20),1],[0,-E(5)^4-E(5)^3-E(5)^2-2*E(5)]],
 [[(5*E(15)^14+E(15)^13+5*E(15)^11+5*E(15)^8+4*E(15)^7+3*E(15)^4+5*E(15)^2
  +2*E(15))/5,(-2*E(15)^13-3*E(15)^7-E(15)^4+E(15))/5],[0,-E(5)^4-E(5)^2]],
 [[(-2*E(20)^17-5*E(20)^16+2*E(20)^13-5*E(20)^12+E(20)^9-5*E(20)^8-5*E(20)^4
  -E(20))/5,(-E(20)^17+E(20)^13-2*E(20)^9+2*E(20))/5],
  [(5*E(15)^14+E(15)^13+5*E(15)^11+5*E(15)^8+4*E(15)^7+3*E(15)^4+5*E(15)^2
  +2*E(15))/5,(-2*E(15)^13-3*E(15)^7-E(15)^4+E(15))/5],[0,-E(20)^13-E(20)]],
 [[0,(1+ER(5))*(3-ER(-3))/4],[ER(5)/5,(3+ER(5))/2]],
 [[-8/15*E(60)^4-1/15*E(60)^8+3/5*E(60)^11-8/15*E(60)^16+2/5*E(60)^23
         -2/15*E(60)^28-1/15*E(60)^32-4/15*E(60)^44+2/5*E(60)^47-2/15*E(60)^52
         -4/15*E(60)^56+3/5*E(60)^59, -1/3*E(3)-2/3*E(3)^2 ], [ 0, 1 ] ],
[[(-2*E(5)^4+E(5)^3-E(5)^2+2*E(5))/5/E(4)+1,
 (-E(5)^4-2*E(5)^3+2*E(5)^2+E(5))/5/E(4)],
 [(-4*E(20)^17-E(20)^16
 -E(20)^13+3*E(20)^12-3*E(20)^9+2*E(20)^8+E(20)^4-2*E(20))/5,(-2*E(20)^17
 -3*E(20)^16+2*E(20)^13-E(20)^12+E(20)^9+E(20)^8-2*E(20)^4-E(20))/5],
 [(-E(20)^17-E(20)^16-4*E(20)^13-2*E(20)^12-2*E(20)^9-3*E(20)^8+E(20)^4
 -3*E(20))/5,(2*E(20)^17+2*E(20)^16-2*E(20)^13-E(20)^12-E(20)^9
 +E(20)^8+3*E(20)^4+E(20))/5]]];
  return l[n-15];
end);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G16_22",function(n)local l;
  l:=[[1/5,1/5], [1/2,1/5], [1/3,1/5],  [1/2,1/3,1/5], [1/3,1/3],
  [1/2,1/3], [1/2,1/2,1/2]];
  return l[n-15];
end);

CHEVIE.AddData("CartanMat", "G16_22",function(n)
  return CHEVIE.RawData("GeneratingCoRoots","G16_22")(n)*
  TransposedMat(CHEVIE.RawData("GeneratingRoots","G16_22")(n));
  end);

CHEVIE.AddData("ReflectionCoDegrees","G16_22",function(n)local l;
  l:=[[0,10], [0,40], [0,30], [0,60], [0,18], [0,48], [0,28]];
  return l[n-15];
end);

CHEVIE.AddData("ReflectionDegrees","G16_22",function(n)local l;
  l:=[[20,30], [20,60], [30,60], [60,60], [12,30], [12,60], [12,20]];
  return l[n-15];
end);

CHEVIE.AddData("ParabolicRepresentatives","G16_22",# repr. of conj. classes
  function(n) local l;l:=[[]];
    Append(l,Filtered(CHEVIE.RawData("ClassInfo","G16_22")(n).classtext,
      x->Length(x)=1));
    Add(l,[1..Length(CHEVIE.RawData("GeneratingRoots","G16_22")(n))]);
    return l;
end);

CHEVIE.AddData("ClassInfo","G16_22",function(n)local res,p,g,m,f,digits;
  p:=CHEVIE.RawData("paramclasses","G16_22");
  res:=rec();
  g:=function(c,a,b)return c[2] mod a=b[c[1]];end;
  f:=function(class,z)local res,i;
    res:=[[],[1],[2],[3],[3,3]];res:=res[class[1]];
    for i in [1..class[2]] do Append(res,z);od;
    return res;
  end;
  if n=16 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],6,[0,3,2,0,0]));
    res.classtext:=List(p{res.indexclasses},
      c->Replace(f(c,[3,1]),[2],[],[1,3,1],[2],[3],[1]));
    m:="121212";
  elif n=17 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],3,[0,0,2,0,0]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[3,1]),[2],[],[3],[2]));
    m:="212121";
  elif n=18 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],2,[0,1,0,0,0]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[2,3]),[1],[],[2],[1],[3],[2]));
    m:="1212";
  elif n=19 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],1,[0,0,0,0,0]));
    res.classtext:=List(p{res.indexclasses},
      x->f(x,[1,2,3]));
    m:="123";
  elif n=20 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],10,[0,5,0,4,8]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[1,2]),[3],[],[1,1],[],
                                      [1,2,1],[3],[2],[1],[3],[2]));
    m:="2121212121";
  elif n=21 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],5,[0,0,0,4,3]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[1,2]),[3],[]));
    m:="1212121212";
  elif n=22 then 
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],15,[0,0,5,9,3]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[1,2]),[3],[],[2,1,2,1,2],[2,3]));
    m:="123123123123123";
  fi;
  digits:="123"; 
  res.classnames:=List(res.classtext,function(x)local res;
    res := String(Replace(digits{x},m,"z"));
    if Length(res) = 0 then res := "."; fi;
    return res;
  end);
  m:=[1,30,20,12,12];res.classes:=List(p{res.indexclasses},x->m[x[1]]);
  m:=[1,60,30,20,15,12,10,60,15,20,6,60,5,60,30,4,15,60,10,60,3,20,30,60,5,12,
    30,20,15,60,2,60,15,20,30,12,5,60,30,20,3,60,10,60,15,4,30,60,5,60,6,20,15,
    60,10,12,15,20,30,60,2,60,30,20,30,12,10,60,30,20,6,60,10,60,30,4,30,60,10,
    60,6,20,30,60,10,12,30,20,30,60,3,60,30,60,15,12,30,60,15,60,6,60,15,60,30,
    12,15,60,30,60,3,60,30,60,15,12,30,60,15,60,6,60,15,60,30,12,15,60,30,60,3,
    60,30,60,15,12,30,60,15,60,6,60,15,60,30,12,15,60,30,60,5,60,30,20,15,
    60,10,60,15,20,30,60,5,60,30,20,15,60,10,60,15,20,30,60,5,60,30,20,15,60,10,
    60,15,20,30,60,5,60,30,20,15,60,10,60,15,20,30,60,5,60,30,20,15,60,10,60,15,
    20,30,60,5,60,30,20,15,60,10,60,15,20,30,60,5,60,30,20,15,60,10,60,15,
    20,30,60,5,60,30,20,15,60,10,60,15,20,30,60,5,60,30,20,15,60,10,60,15,20,30,
    60,5,60,30,20,15,60,10,60,15,20,30,60];
  res.orders:=m{res.indexclasses};
  res.classparams:=res.classnames;
  return res;
end);

CHEVIE.AddData("PowerMaps","G16_22",function(n)local l,res,i;
  l:=CHEVIE.RawData("ClassInfo","G16_22")(n).indexclasses;
  res:=
[ , [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37,
      39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 1, 3, 5, 7, 9, 11, 13, 15,
      17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51,
      53, 55, 57, 59, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29,
      31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 131, 133,
      135, 137, 139, 141, 143, 145, 147, 149, 91, 93, 95, 97, 99, 101, 103,
      105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131,
      133, 135, 137, 139, 141, 143, 145, 147, 149, 91, 93, 95, 97, 99, 101,
      103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129,
      211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 231, 233, 235, 237,
      239, 241, 243, 245, 247, 249, 251, 253, 255, 257, 259, 261, 263, 265,
      267, 269, 211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 231, 233,
      235, 237, 239, 241, 243, 245, 247, 249, 251, 253, 255, 257, 259, 261,
      263, 265, 267, 269, 199, 201, 203, 205, 207, 209, 151, 153, 155, 157,
      159, 161, 163, 165, 167, 169, 171, 173, 175, 177, 179, 181, 183, 185,
      187, 189, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 151, 153,
      155, 157, 159, 161, 163, 165, 167, 169, 171, 173, 175, 177, 179, 181,
      183, 185, 187, 189, 191, 193, 195, 197 ],
  [ 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55,
      58, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49,
      52, 55, 58, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43,
      46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88, 61, 64, 67,
      70, 73, 76, 79, 82, 85, 88, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88, 1,
      4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55,
      58, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49,
      52, 55, 58, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43,
      46, 49, 52, 55, 58, 247, 250, 253, 256, 259, 262, 265, 268, 211, 214,
      217, 220, 223, 226, 229, 232, 235, 238, 241, 244, 247, 250, 253, 256,
      259, 262, 265, 268, 211, 214, 217, 220, 223, 226, 229, 232, 235, 238,
      241, 244, 247, 250, 253, 256, 259, 262, 265, 268, 211, 214, 217, 220,
      223, 226, 229, 232, 235, 238, 241, 244, 151, 154, 157, 160, 163, 166,
      169, 172, 175, 178, 181, 184, 187, 190, 193, 196, 199, 202, 205, 208,
      151, 154, 157, 160, 163, 166, 169, 172, 175, 178, 181, 184, 187, 190,
      193, 196, 199, 202, 205, 208, 151, 154, 157, 160, 163, 166, 169, 172,
      175, 178, 181, 184, 187, 190, 193, 196, 199, 202, 205, 208 ],,
  [ 1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51, 56, 1, 6, 11, 16, 21, 26, 31,
      36, 41, 46, 51, 56, 1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51, 56, 1, 6,
      11, 16, 21, 26, 31, 36, 41, 46, 51, 56, 1, 6, 11, 16, 21, 26, 31, 36,
      41, 46, 51, 56, 61, 66, 71, 76, 81, 86, 61, 66, 71, 76, 81, 86, 61, 66,
      71, 76, 81, 86, 61, 66, 71, 76, 81, 86, 61, 66, 71, 76, 81, 86, 131,
      136, 141, 146, 91, 96, 101, 106, 111, 116, 121, 126, 131, 136, 141,
      146, 91, 96, 101, 106, 111, 116, 121, 126, 131, 136, 141, 146, 91, 96,
      101, 106, 111, 116, 121, 126, 131, 136, 141, 146, 91, 96, 101, 106,
      111, 116, 121, 126, 131, 136, 141, 146, 91, 96, 101, 106, 111, 116,
      121, 126, 1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51, 56, 1, 6, 11, 16,
      21, 26, 31, 36, 41, 46, 51, 56, 1, 6, 11, 16, 21, 26, 31, 36, 41, 46,
      51, 56, 1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51, 56, 1, 6, 11, 16, 21,
      26, 31, 36, 41, 46, 51, 56, 1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51,
      56, 1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51, 56, 1, 6, 11, 16, 21, 26,
      31, 36, 41, 46, 51, 56, 1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51, 56,
      1, 6, 11, 16, 21, 26, 31, 36, 41, 46, 51, 56 ],,
  [ 1, 8, 15, 22, 29, 36, 43, 50, 57, 4, 11, 18, 25, 32, 39, 46, 53, 60, 7,
      14, 21, 28, 35, 42, 49, 56, 3, 10, 17, 24, 31, 38, 45, 52, 59, 6, 13,
      20, 27, 34, 41, 48, 55, 2, 9, 16, 23, 30, 37, 44, 51, 58, 5, 12, 19,
      26, 33, 40, 47, 54, 61, 68, 75, 82, 89, 66, 73, 80, 87, 64, 71, 78, 85,
      62, 69, 76, 83, 90, 67, 74, 81, 88, 65, 72, 79, 86, 63, 70, 77, 84, 91,
      98, 105, 112, 119, 126, 133, 140, 147, 94, 101, 108, 115, 122, 129,
      136, 143, 150, 97, 104, 111, 118, 125, 132, 139, 146, 93, 100, 107,
      114, 121, 128, 135, 142, 149, 96, 103, 110, 117, 124, 131, 138, 145,
      92, 99, 106, 113, 120, 127, 134, 141, 148, 95, 102, 109, 116, 123, 130,
      137, 144, 211, 218, 225, 232, 239, 246, 253, 260, 267, 214, 221, 228,
      235, 242, 249, 256, 263, 270, 217, 224, 231, 238, 245, 252, 259, 266,
      213, 220, 227, 234, 241, 248, 255, 262, 269, 216, 223, 230, 237, 244,
      251, 258, 265, 212, 219, 226, 233, 240, 247, 254, 261, 268, 215, 222,
      229, 236, 243, 250, 257, 264, 199, 206, 153, 160, 167, 174, 181, 188,
      195, 202, 209, 156, 163, 170, 177, 184, 191, 198, 205, 152, 159, 166,
      173, 180, 187, 194, 201, 208, 155, 162, 169, 176, 183, 190, 197, 204,
      151, 158, 165, 172, 179, 186, 193, 200, 207, 154, 161, 168, 175, 182,
      189, 196, 203, 210, 157, 164, 171, 178, 185, 192 ],,,,
  [ 1, 12, 23, 34, 45, 56, 7, 18, 29, 40, 51, 2, 13, 24, 35, 46, 57, 8, 19,
      30, 41, 52, 3, 14, 25, 36, 47, 58, 9, 20, 31, 42, 53, 4, 15, 26, 37,
      48, 59, 10, 21, 32, 43, 54, 5, 16, 27, 38, 49, 60, 11, 22, 33, 44, 55,
      6, 17, 28, 39, 50, 61, 72, 83, 64, 75, 86, 67, 78, 89, 70, 81, 62, 73,
      84, 65, 76, 87, 68, 79, 90, 71, 82, 63, 74, 85, 66, 77, 88, 69, 80,
      131, 142, 93, 104, 115, 126, 137, 148, 99, 110, 121, 132, 143, 94, 105,
      116, 127, 138, 149, 100, 111, 122, 133, 144, 95, 106, 117, 128, 139,
      150, 101, 112, 123, 134, 145, 96, 107, 118, 129, 140, 91, 102, 113,
      124, 135, 146, 97, 108, 119, 130, 141, 92, 103, 114, 125, 136, 147, 98,
      109, 120, 151, 162, 173, 184, 195, 206, 157, 168, 179, 190, 201, 152,
      163, 174, 185, 196, 207, 158, 169, 180, 191, 202, 153, 164, 175, 186,
      197, 208, 159, 170, 181, 192, 203, 154, 165, 176, 187, 198, 209, 160,
      171, 182, 193, 204, 155, 166, 177, 188, 199, 210, 161, 172, 183, 194,
      205, 156, 167, 178, 189, 200, 211, 222, 233, 244, 255, 266, 217, 228,
      239, 250, 261, 212, 223, 234, 245, 256, 267, 218, 229, 240, 251, 262,
      213, 224, 235, 246, 257, 268, 219, 230, 241, 252, 263, 214, 225, 236,
      247, 258, 269, 220, 231, 242, 253, 264, 215, 226, 237, 248, 259, 270,
      221, 232, 243, 254, 265, 216, 227, 238, 249, 260 ],,
  [ 1, 14, 27, 40, 53, 6, 19, 32, 45, 58, 11, 24, 37, 50, 3, 16, 29, 42, 55,
      8, 21, 34, 47, 60, 13, 26, 39, 52, 5, 18, 31, 44, 57, 10, 23, 36, 49,
      2, 15, 28, 41, 54, 7, 20, 33, 46, 59, 12, 25, 38, 51, 4, 17, 30, 43,
      56, 9, 22, 35, 48, 61, 74, 87, 70, 83, 66, 79, 62, 75, 88, 71, 84, 67,
      80, 63, 76, 89, 72, 85, 68, 81, 64, 77, 90, 73, 86, 69, 82, 65, 78, 91,
      104, 117, 130, 143, 96, 109, 122, 135, 148, 101, 114, 127, 140, 93,
      106, 119, 132, 145, 98, 111, 124, 137, 150, 103, 116, 129, 142, 95,
      108, 121, 134, 147, 100, 113, 126, 139, 92, 105, 118, 131, 144, 97,
      110, 123, 136, 149, 102, 115, 128, 141, 94, 107, 120, 133, 146, 99,
      112, 125, 138, 247, 260, 213, 226, 239, 252, 265, 218, 231, 244, 257,
      270, 223, 236, 249, 262, 215, 228, 241, 254, 267, 220, 233, 246, 259,
      212, 225, 238, 251, 264, 217, 230, 243, 256, 269, 222, 235, 248, 261,
      214, 227, 240, 253, 266, 219, 232, 245, 258, 211, 224, 237, 250, 263,
      216, 229, 242, 255, 268, 221, 234, 151, 164, 177, 190, 203, 156, 169,
      182, 195, 208, 161, 174, 187, 200, 153, 166, 179, 192, 205, 158, 171,
      184, 197, 210, 163, 176, 189, 202, 155, 168, 181, 194, 207, 160, 173,
      186, 199, 152, 165, 178, 191, 204, 157, 170, 183, 196, 209, 162, 175,
      188, 201, 154, 167, 180, 193, 206, 159, 172, 185, 198 ],,,,
  [ 1, 18, 35, 52, 9, 26, 43, 60, 17, 34, 51, 8, 25, 42, 59, 16, 33, 50, 7,
      24, 41, 58, 15, 32, 49, 6, 23, 40, 57, 14, 31, 48, 5, 22, 39, 56, 13,
      30, 47, 4, 21, 38, 55, 12, 29, 46, 3, 20, 37, 54, 11, 28, 45, 2, 19,
      36, 53, 10, 27, 44, 61, 78, 65, 82, 69, 86, 73, 90, 77, 64, 81, 68, 85,
      72, 89, 76, 63, 80, 67, 84, 71, 88, 75, 62, 79, 66, 83, 70, 87, 74,
      131, 148, 105, 122, 139, 96, 113, 130, 147, 104, 121, 138, 95, 112,
      129, 146, 103, 120, 137, 94, 111, 128, 145, 102, 119, 136, 93, 110,
      127, 144, 101, 118, 135, 92, 109, 126, 143, 100, 117, 134, 91, 108,
      125, 142, 99, 116, 133, 150, 107, 124, 141, 98, 115, 132, 149, 106,
      123, 140, 97, 114, 211, 228, 245, 262, 219, 236, 253, 270, 227, 244,
      261, 218, 235, 252, 269, 226, 243, 260, 217, 234, 251, 268, 225, 242,
      259, 216, 233, 250, 267, 224, 241, 258, 215, 232, 249, 266, 223, 240,
      257, 214, 231, 248, 265, 222, 239, 256, 213, 230, 247, 264, 221, 238,
      255, 212, 229, 246, 263, 220, 237, 254, 199, 156, 173, 190, 207, 164,
      181, 198, 155, 172, 189, 206, 163, 180, 197, 154, 171, 188, 205, 162,
      179, 196, 153, 170, 187, 204, 161, 178, 195, 152, 169, 186, 203, 160,
      177, 194, 151, 168, 185, 202, 159, 176, 193, 210, 167, 184, 201, 158,
      175, 192, 209, 166, 183, 200, 157, 174, 191, 208, 165, 182 ],,
  [ 1, 20, 39, 58, 17, 36, 55, 14, 33, 52, 11, 30, 49, 8, 27, 46, 5, 24, 43,
      2, 21, 40, 59, 18, 37, 56, 15, 34, 53, 12, 31, 50, 9, 28, 47, 6, 25,
      44, 3, 22, 41, 60, 19, 38, 57, 16, 35, 54, 13, 32, 51, 10, 29, 48, 7,
      26, 45, 4, 23, 42, 61, 80, 69, 88, 77, 66, 85, 74, 63, 82, 71, 90, 79,
      68, 87, 76, 65, 84, 73, 62, 81, 70, 89, 78, 67, 86, 75, 64, 83, 72, 91,
      110, 129, 148, 107, 126, 145, 104, 123, 142, 101, 120, 139, 98, 117,
      136, 95, 114, 133, 92, 111, 130, 149, 108, 127, 146, 105, 124, 143,
      102, 121, 140, 99, 118, 137, 96, 115, 134, 93, 112, 131, 150, 109, 128,
      147, 106, 125, 144, 103, 122, 141, 100, 119, 138, 97, 116, 135, 94,
      113, 132, 199, 158, 177, 196, 155, 174, 193, 152, 171, 190, 209, 168,
      187, 206, 165, 184, 203, 162, 181, 200, 159, 178, 197, 156, 175, 194,
      153, 172, 191, 210, 169, 188, 207, 166, 185, 204, 163, 182, 201, 160,
      179, 198, 157, 176, 195, 154, 173, 192, 151, 170, 189, 208, 167, 186,
      205, 164, 183, 202, 161, 180, 247, 266, 225, 244, 263, 222, 241, 260,
      219, 238, 257, 216, 235, 254, 213, 232, 251, 270, 229, 248, 267, 226,
      245, 264, 223, 242, 261, 220, 239, 258, 217, 236, 255, 214, 233, 252,
      211, 230, 249, 268, 227, 246, 265, 224, 243, 262, 221, 240, 259, 218,
      237, 256, 215, 234, 253, 212, 231, 250, 269, 228 ],,,,
  [ 1, 24, 47, 10, 33, 56, 19, 42, 5, 28, 51, 14, 37, 60, 23, 46, 9, 32, 55,
      18, 41, 4, 27, 50, 13, 36, 59, 22, 45, 8, 31, 54, 17, 40, 3, 26, 49,
      12, 35, 58, 21, 44, 7, 30, 53, 16, 39, 2, 25, 48, 11, 34, 57, 20, 43,
      6, 29, 52, 15, 38, 61, 84, 77, 70, 63, 86, 79, 72, 65, 88, 81, 74, 67,
      90, 83, 76, 69, 62, 85, 78, 71, 64, 87, 80, 73, 66, 89, 82, 75, 68,
      131, 94, 117, 140, 103, 126, 149, 112, 135, 98, 121, 144, 107, 130, 93,
      116, 139, 102, 125, 148, 111, 134, 97, 120, 143, 106, 129, 92, 115,
      138, 101, 124, 147, 110, 133, 96, 119, 142, 105, 128, 91, 114, 137,
      100, 123, 146, 109, 132, 95, 118, 141, 104, 127, 150, 113, 136, 99,
      122, 145, 108, 247, 270, 233, 256, 219, 242, 265, 228, 251, 214, 237,
      260, 223, 246, 269, 232, 255, 218, 241, 264, 227, 250, 213, 236, 259,
      222, 245, 268, 231, 254, 217, 240, 263, 226, 249, 212, 235, 258, 221,
      244, 267, 230, 253, 216, 239, 262, 225, 248, 211, 234, 257, 220, 243,
      266, 229, 252, 215, 238, 261, 224, 151, 174, 197, 160, 183, 206, 169,
      192, 155, 178, 201, 164, 187, 210, 173, 196, 159, 182, 205, 168, 191,
      154, 177, 200, 163, 186, 209, 172, 195, 158, 181, 204, 167, 190, 153,
      176, 199, 162, 185, 208, 171, 194, 157, 180, 203, 166, 189, 152, 175,
      198, 161, 184, 207, 170, 193, 156, 179, 202, 165, 188 ],,,,,,
  [ 1, 30, 59, 28, 57, 26, 55, 24, 53, 22, 51, 20, 49, 18, 47, 16, 45, 14,
      43, 12, 41, 10, 39, 8, 37, 6, 35, 4, 33, 2, 31, 60, 29, 58, 27, 56, 25,
      54, 23, 52, 21, 50, 19, 48, 17, 46, 15, 44, 13, 42, 11, 40, 9, 38, 7,
      36, 5, 34, 3, 32, 61, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79,
      78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62,
      131, 100, 129, 98, 127, 96, 125, 94, 123, 92, 121, 150, 119, 148, 117,
      146, 115, 144, 113, 142, 111, 140, 109, 138, 107, 136, 105, 134, 103,
      132, 101, 130, 99, 128, 97, 126, 95, 124, 93, 122, 91, 120, 149, 118,
      147, 116, 145, 114, 143, 112, 141, 110, 139, 108, 137, 106, 135, 104,
      133, 102, 199, 168, 197, 166, 195, 164, 193, 162, 191, 160, 189, 158,
      187, 156, 185, 154, 183, 152, 181, 210, 179, 208, 177, 206, 175, 204,
      173, 202, 171, 200, 169, 198, 167, 196, 165, 194, 163, 192, 161, 190,
      159, 188, 157, 186, 155, 184, 153, 182, 151, 180, 209, 178, 207, 176,
      205, 174, 203, 172, 201, 170, 247, 216, 245, 214, 243, 212, 241, 270,
      239, 268, 237, 266, 235, 264, 233, 262, 231, 260, 229, 258, 227, 256,
      225, 254, 223, 252, 221, 250, 219, 248, 217, 246, 215, 244, 213, 242,
      211, 240, 269, 238, 267, 236, 265, 234, 263, 232, 261, 230, 259, 228,
      257, 226, 255, 224, 253, 222, 251, 220, 249, 218 ],,
  [ 1, 32, 3, 34, 5, 36, 7, 38, 9, 40, 11, 42, 13, 44, 15, 46, 17, 48, 19,
      50, 21, 52, 23, 54, 25, 56, 27, 58, 29, 60, 31, 2, 33, 4, 35, 6, 37, 8,
      39, 10, 41, 12, 43, 14, 45, 16, 47, 18, 49, 20, 51, 22, 53, 24, 55, 26,
      57, 28, 59, 30, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
      122, 93, 124, 95, 126, 97, 128, 99, 130, 101, 132, 103, 134, 105, 136,
      107, 138, 109, 140, 111, 142, 113, 144, 115, 146, 117, 148, 119, 150,
      121, 92, 123, 94, 125, 96, 127, 98, 129, 100, 131, 102, 133, 104, 135,
      106, 137, 108, 139, 110, 141, 112, 143, 114, 145, 116, 147, 118, 149,
      120, 151, 182, 153, 184, 155, 186, 157, 188, 159, 190, 161, 192, 163,
      194, 165, 196, 167, 198, 169, 200, 171, 202, 173, 204, 175, 206, 177,
      208, 179, 210, 181, 152, 183, 154, 185, 156, 187, 158, 189, 160, 191,
      162, 193, 164, 195, 166, 197, 168, 199, 170, 201, 172, 203, 174, 205,
      176, 207, 178, 209, 180, 211, 242, 213, 244, 215, 246, 217, 248, 219,
      250, 221, 252, 223, 254, 225, 256, 227, 258, 229, 260, 231, 262, 233,
      264, 235, 266, 237, 268, 239, 270, 241, 212, 243, 214, 245, 216, 247,
      218, 249, 220, 251, 222, 253, 224, 255, 226, 257, 228, 259, 230, 261,
      232, 263, 234, 265, 236, 267, 238, 269, 240 ],,,,,,
  [ 1, 38, 15, 52, 29, 6, 43, 20, 57, 34, 11, 48, 25, 2, 39, 16, 53, 30, 7,
      44, 21, 58, 35, 12, 49, 26, 3, 40, 17, 54, 31, 8, 45, 22, 59, 36, 13,
      50, 27, 4, 41, 18, 55, 32, 9, 46, 23, 60, 37, 14, 51, 28, 5, 42, 19,
      56, 33, 10, 47, 24, 61, 68, 75, 82, 89, 66, 73, 80, 87, 64, 71, 78, 85,
      62, 69, 76, 83, 90, 67, 74, 81, 88, 65, 72, 79, 86, 63, 70, 77, 84, 91,
      128, 105, 142, 119, 96, 133, 110, 147, 124, 101, 138, 115, 92, 129,
      106, 143, 120, 97, 134, 111, 148, 125, 102, 139, 116, 93, 130, 107,
      144, 121, 98, 135, 112, 149, 126, 103, 140, 117, 94, 131, 108, 145,
      122, 99, 136, 113, 150, 127, 104, 141, 118, 95, 132, 109, 146, 123,
      100, 137, 114, 211, 248, 225, 262, 239, 216, 253, 230, 267, 244, 221,
      258, 235, 212, 249, 226, 263, 240, 217, 254, 231, 268, 245, 222, 259,
      236, 213, 250, 227, 264, 241, 218, 255, 232, 269, 246, 223, 260, 237,
      214, 251, 228, 265, 242, 219, 256, 233, 270, 247, 224, 261, 238, 215,
      252, 229, 266, 243, 220, 257, 234, 199, 176, 153, 190, 167, 204, 181,
      158, 195, 172, 209, 186, 163, 200, 177, 154, 191, 168, 205, 182, 159,
      196, 173, 210, 187, 164, 201, 178, 155, 192, 169, 206, 183, 160, 197,
      174, 151, 188, 165, 202, 179, 156, 193, 170, 207, 184, 161, 198, 175,
      152, 189, 166, 203, 180, 157, 194, 171, 208, 185, 162 ],,,,
  [ 1, 42, 23, 4, 45, 26, 7, 48, 29, 10, 51, 32, 13, 54, 35, 16, 57, 38, 19,
      60, 41, 22, 3, 44, 25, 6, 47, 28, 9, 50, 31, 12, 53, 34, 15, 56, 37,
      18, 59, 40, 21, 2, 43, 24, 5, 46, 27, 8, 49, 30, 11, 52, 33, 14, 55,
      36, 17, 58, 39, 20, 61, 72, 83, 64, 75, 86, 67, 78, 89, 70, 81, 62, 73,
      84, 65, 76, 87, 68, 79, 90, 71, 82, 63, 74, 85, 66, 77, 88, 69, 80,
      131, 112, 93, 134, 115, 96, 137, 118, 99, 140, 121, 102, 143, 124, 105,
      146, 127, 108, 149, 130, 111, 92, 133, 114, 95, 136, 117, 98, 139, 120,
      101, 142, 123, 104, 145, 126, 107, 148, 129, 110, 91, 132, 113, 94,
      135, 116, 97, 138, 119, 100, 141, 122, 103, 144, 125, 106, 147, 128,
      109, 150, 151, 192, 173, 154, 195, 176, 157, 198, 179, 160, 201, 182,
      163, 204, 185, 166, 207, 188, 169, 210, 191, 172, 153, 194, 175, 156,
      197, 178, 159, 200, 181, 162, 203, 184, 165, 206, 187, 168, 209, 190,
      171, 152, 193, 174, 155, 196, 177, 158, 199, 180, 161, 202, 183, 164,
      205, 186, 167, 208, 189, 170, 211, 252, 233, 214, 255, 236, 217, 258,
      239, 220, 261, 242, 223, 264, 245, 226, 267, 248, 229, 270, 251, 232,
      213, 254, 235, 216, 257, 238, 219, 260, 241, 222, 263, 244, 225, 266,
      247, 228, 269, 250, 231, 212, 253, 234, 215, 256, 237, 218, 259, 240,
      221, 262, 243, 224, 265, 246, 227, 268, 249, 230 ],,
  [ 1, 44, 27, 10, 53, 36, 19, 2, 45, 28, 11, 54, 37, 20, 3, 46, 29, 12, 55,
      38, 21, 4, 47, 30, 13, 56, 39, 22, 5, 48, 31, 14, 57, 40, 23, 6, 49,
      32, 15, 58, 41, 24, 7, 50, 33, 16, 59, 42, 25, 8, 51, 34, 17, 60, 43,
      26, 9, 52, 35, 18, 61, 74, 87, 70, 83, 66, 79, 62, 75, 88, 71, 84, 67,
      80, 63, 76, 89, 72, 85, 68, 81, 64, 77, 90, 73, 86, 69, 82, 65, 78, 91,
      134, 117, 100, 143, 126, 109, 92, 135, 118, 101, 144, 127, 110, 93,
      136, 119, 102, 145, 128, 111, 94, 137, 120, 103, 146, 129, 112, 95,
      138, 121, 104, 147, 130, 113, 96, 139, 122, 105, 148, 131, 114, 97,
      140, 123, 106, 149, 132, 115, 98, 141, 124, 107, 150, 133, 116, 99,
      142, 125, 108, 247, 230, 213, 256, 239, 222, 265, 248, 231, 214, 257,
      240, 223, 266, 249, 232, 215, 258, 241, 224, 267, 250, 233, 216, 259,
      242, 225, 268, 251, 234, 217, 260, 243, 226, 269, 252, 235, 218, 261,
      244, 227, 270, 253, 236, 219, 262, 245, 228, 211, 254, 237, 220, 263,
      246, 229, 212, 255, 238, 221, 264, 151, 194, 177, 160, 203, 186, 169,
      152, 195, 178, 161, 204, 187, 170, 153, 196, 179, 162, 205, 188, 171,
      154, 197, 180, 163, 206, 189, 172, 155, 198, 181, 164, 207, 190, 173,
      156, 199, 182, 165, 208, 191, 174, 157, 200, 183, 166, 209, 192, 175,
      158, 201, 184, 167, 210, 193, 176, 159, 202, 185, 168 ],,,,
  [ 1, 48, 35, 22, 9, 56, 43, 30, 17, 4, 51, 38, 25, 12, 59, 46, 33, 20, 7,
      54, 41, 28, 15, 2, 49, 36, 23, 10, 57, 44, 31, 18, 5, 52, 39, 26, 13,
      60, 47, 34, 21, 8, 55, 42, 29, 16, 3, 50, 37, 24, 11, 58, 45, 32, 19,
      6, 53, 40, 27, 14, 61, 78, 65, 82, 69, 86, 73, 90, 77, 64, 81, 68, 85,
      72, 89, 76, 63, 80, 67, 84, 71, 88, 75, 62, 79, 66, 83, 70, 87, 74,
      131, 118, 105, 92, 139, 126, 113, 100, 147, 134, 121, 108, 95, 142,
      129, 116, 103, 150, 137, 124, 111, 98, 145, 132, 119, 106, 93, 140,
      127, 114, 101, 148, 135, 122, 109, 96, 143, 130, 117, 104, 91, 138,
      125, 112, 99, 146, 133, 120, 107, 94, 141, 128, 115, 102, 149, 136,
      123, 110, 97, 144, 211, 258, 245, 232, 219, 266, 253, 240, 227, 214,
      261, 248, 235, 222, 269, 256, 243, 230, 217, 264, 251, 238, 225, 212,
      259, 246, 233, 220, 267, 254, 241, 228, 215, 262, 249, 236, 223, 270,
      257, 244, 231, 218, 265, 252, 239, 226, 213, 260, 247, 234, 221, 268,
      255, 242, 229, 216, 263, 250, 237, 224, 199, 186, 173, 160, 207, 194,
      181, 168, 155, 202, 189, 176, 163, 210, 197, 184, 171, 158, 205, 192,
      179, 166, 153, 200, 187, 174, 161, 208, 195, 182, 169, 156, 203, 190,
      177, 164, 151, 198, 185, 172, 159, 206, 193, 180, 167, 154, 201, 188,
      175, 162, 209, 196, 183, 170, 157, 204, 191, 178, 165, 152 ],,,,,,
  [ 1, 54, 47, 40, 33, 26, 19, 12, 5, 58, 51, 44, 37, 30, 23, 16, 9, 2, 55,
      48, 41, 34, 27, 20, 13, 6, 59, 52, 45, 38, 31, 24, 17, 10, 3, 56, 49,
      42, 35, 28, 21, 14, 7, 60, 53, 46, 39, 32, 25, 18, 11, 4, 57, 50, 43,
      36, 29, 22, 15, 8, 61, 84, 77, 70, 63, 86, 79, 72, 65, 88, 81, 74, 67,
      90, 83, 76, 69, 62, 85, 78, 71, 64, 87, 80, 73, 66, 89, 82, 75, 68,
      131, 124, 117, 110, 103, 96, 149, 142, 135, 128, 121, 114, 107, 100,
      93, 146, 139, 132, 125, 118, 111, 104, 97, 150, 143, 136, 129, 122,
      115, 108, 101, 94, 147, 140, 133, 126, 119, 112, 105, 98, 91, 144, 137,
      130, 123, 116, 109, 102, 95, 148, 141, 134, 127, 120, 113, 106, 99, 92,
      145, 138, 247, 240, 233, 226, 219, 212, 265, 258, 251, 244, 237, 230,
      223, 216, 269, 262, 255, 248, 241, 234, 227, 220, 213, 266, 259, 252,
      245, 238, 231, 224, 217, 270, 263, 256, 249, 242, 235, 228, 221, 214,
      267, 260, 253, 246, 239, 232, 225, 218, 211, 264, 257, 250, 243, 236,
      229, 222, 215, 268, 261, 254, 151, 204, 197, 190, 183, 176, 169, 162,
      155, 208, 201, 194, 187, 180, 173, 166, 159, 152, 205, 198, 191, 184,
      177, 170, 163, 156, 209, 202, 195, 188, 181, 174, 167, 160, 153, 206,
      199, 192, 185, 178, 171, 164, 157, 210, 203, 196, 189, 182, 175, 168,
      161, 154, 207, 200, 193, 186, 179, 172, 165, 158 ],,,,,,
  [ 1, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44,
      43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26,
      25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8,
      7, 6, 5, 4, 3, 2, 61, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79,
      78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62,
      131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118,
      117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104,
      103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 150, 149, 148,
      147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134,
      133, 132, 199, 198, 197, 196, 195, 194, 193, 192, 191, 190, 189, 188,
      187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 176, 175, 174,
      173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160,
      159, 158, 157, 156, 155, 154, 153, 152, 151, 210, 209, 208, 207, 206,
      205, 204, 203, 202, 201, 200, 247, 246, 245, 244, 243, 242, 241, 240,
      239, 238, 237, 236, 235, 234, 233, 232, 231, 230, 229, 228, 227, 226,
      225, 224, 223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212,
      211, 270, 269, 268, 267, 266, 265, 264, 263, 262, 261, 260, 259, 258,
      257, 256, 255, 254, 253, 252, 251, 250, 249, 248 ] ];
  for i in [1..Length(res)] do
    if IsBound(res[i]) then
      res[i]:=List(res[i]{l},x->Position(l,x));
      if res[i]=[1..Length(l)] or res[i] in SublistUnbnd(res,[1..i-1]) then
         Unbind(res[i]);fi;
    fi;
  od;
  return res;
end);

CHEVIE.AddData("CharInfo","G16_22",function(n)local res;
  res:=rec();
  if n=16 then res.indexchars:=Concatenation([1..5],[81..100],[151..155],
      [166..170],[211,217,228,229],[240..245]);
      res.extRefl:=[1,6,2];
      res.charparams:=
  [[1,0],[1,12],[1,24],[1,36],[1,48],[2,1],[2,7],[2,13,1],[2,19,1],[2,13,2],[2,
19,2],[2,25,2],[2,25,1],[2,31],[2,37],[3,2],[3,6],[3,10,2],[3,10,1],[3,14,1],
[3,18,1],[3,14,2],[3,18,2],[3,22],[3,26],[4,15],[4,17],[4,9],[4,11],[4,3],[4,
20],[4,12],[4,14],[4,6],[4,8],[5,12],[5,4],[5,16],[5,8],[5,10],[6,5],[6,7],[6,
9],[6,11],[6,13]];
  elif n=17 then res.indexchars:=Concatenation([11..20],
      [71,32,33,84,35,86,37,38,79,40,41,62,67,68,49,70],[63,54,65,56],[91..110],
      [151..155],[171..175],[181..185],[206..211],
      [214,219,220,223,226,229,232,235,238],[241..250]);
      res.extRefl:=[1,21,7];
      res.charparams:=
[[1,0],[1,12],[1,24],[1,36],[1,48],[1,30],[1,42],[1,54],[1,66],[1,78],[2,11],
[2,17],[2,13,1],[2,19,1],[2,13,2],[2,19,2],[2,25,2],[2,25,1],[2,31],[2,37],[2,
1],[2,7],[2,35,2],[2,35,1],[2,41],[2,47],[2,23,1],[2,29,1],[2,23,2],[2,29,2],
[3,2],[3,6],[3,10,2],[3,10,1],[3,14,1],[3,18,1],[3,14,2],[3,18,2],[3,22],[3,
26],[3,12],[3,16],[3,20,2],[3,20,1],[3,24,1],[3,28,1],[3,24,2],[3,28,2],[3,32],
[3,36],[4,15],[4,27],[4,19],[4,11],[4,3],[4,30],[4,22],[4,14],[4,6],[4,18],[4,
25],[4,17],[4,9],[4,21],[4,13],[4,20],[4,12],[4,24],[4,16],[4,8],[5,12],[5,22],
[5,4],[5,14],[5,16],[5,26],[5,8],[5,18],[5,20],[5,10],[6,15],[6,17],[6,19],[6,
11],[6,13],[6,5],[6,7],[6,9],[6,21],[6,23]];
  elif n=18 then res.indexchars:=Concatenation([1..15],[61..100],
      [111..120],[131..134],[135..140],[181..211],
      [215..219],[223..225],[229,230,231,235],[239..255]);
      res.extRefl:=[1,36,7];
      res.charparams:=
[[1,0],[1,12],[1,24],[1,36],[1,48],[1,20],[1,32],[1,44],[1,56],[1,68],[1,40],
[1,52],[1,64],[1,76],[1,88],[2,21],[2,27],[2,33,1],[2,39,1],[2,33,2],[2,39,2],
[2,45,2],[2,45,1],[2,51],[2,57],[2,11],[2,17],[2,23,1],[2,29,1],[2,23,2],[2,29,
2],[2,35,2],[2,35,1],[2,41],[2,47],[2,1],[2,7],[2,13,1],[2,19,1],[2,13,2],[2,
19,2],[2,25,2],[2,25,1],[2,31],[2,37],[3,2],[3,26,1],[3,20,2],[3,20,1],[3,14,
1],[3,38,1],[3,14,2],[3,38,2],[3,32],[3,26,2],[3,22,1],[3,16],[3,10,2],[3,10,
1],[3,34,1],[3,28,1],[3,34,2],[3,28,2],[3,22,2],[3,46],[3,12],[3,6],[3,30,2],
[3,30,1],[3,24,1],[3,18,1],[3,24,2],[3,18,2],[3,42],[3,36],[4,15],[4,27],[4,9],
[4,21],[4,3],[4,35],[4,17],[4,29],[4,11],[4,23],[4,25],[4,37],[4,19],[4,31],[4,
13],[4,30],[4,12],[4,24],[4,6],[4,18],[4,20],[4,32],[4,14],[4,26],[4,8],[4,40],
[4,22],[4,34],[4,16],[4,28],[5,12],[5,32],[5,22],[5,24],[5,14],[5,4],[5,36],[5,
26],[5,16],[5,18],[5,8],[5,28],[5,30],[5,20],[5,10],[6,25],[6,7],[6,19],[6,31],
[6,13],[6,5],[6,17],[6,29],[6,11],[6,23],[6,15],[6,27],[6,9],[6,21],[6,33]];
  elif n=19 then res.indexchars:=[1..270];
      res.extRefl:=[1,81,22];
      res.charparams:=
[[1,0],[1,12],[1,24],[1,36],[1,48],[1,20],[1,32],[1,44],[1,56],[1,68],[1,40],
[1,52],[1,64],[1,76],[1,88],[1,30],[1,42],[1,54],[1,66],[1,78],[1,50],[1,62],
[1,74],[1,86],[1,98],[1,70],[1,82],[1,94],[1,106],[1,118],[2,51,1],[2,57,1],[2,
33,1],[2,39,1],[2,33,2],[2,39,2],[2,45,2],[2,45,1],[2,51,2],[2,57,2],[2,41,1],
[2,47,1],[2,53,1],[2,59,1],[2,53,2],[2,59,2],[2,35,2],[2,35,1],[2,41,2],[2,47,
2],[2,31,1],[2,37,1],[2,43,1],[2,49,1],[2,43,2],[2,49,2],[2,55,2],[2,55,1],[2,
31,2],[2,37,2],[2,21],[2,27],[2,63,1],[2,69,1],[2,63,2],[2,69,2],[2,75,1],[2,
75,2],[2,81],[2,87],[2,11],[2,17],[2,23,1],[2,29,1],[2,23,2],[2,29,2],[2,65,2],
[2,65,1],[2,71],[2,77],[2,1],[2,7],[2,13,1],[2,19,1],[2,13,2],[2,19,2],[2,25,
2],[2,25,1],[2,61],[2,67],[3,2],[3,26,1],[3,50,2],[3,50,1],[3,14,1],[3,38,1],
[3,14,2],[3,38,2],[3,62],[3,26,2],[3,32,1],[3,56,1],[3,20,2],[3,20,1],[3,44,1],
[3,68,1],[3,44,2],[3,68,2],[3,32,2],[3,56,2],[3,22,1],[3,46,1],[3,10,2],[3,10,
1],[3,34,1],[3,58,1],[3,34,2],[3,58,2],[3,22,2],[3,46,2],[3,52,1],[3,16],[3,40,
2],[3,40,1],[3,64,1],[3,28,1],[3,64,2],[3,28,2],[3,52,2],[3,76],[3,42,1],[3,6],
[3,30,2],[3,30,1],[3,54,1],[3,18,1],[3,54,2],[3,18,2],[3,42,2],[3,66],[3,12],
[3,36,1],[3,60,2],[3,60,1],[3,24,1],[3,48,1],[3,24,2],[3,48,2],[3,72],[3,36,2],
[4,15],[4,27],[4,39],[4,51],[4,3],[4,35],[4,47],[4,59],[4,11],[4,23],[4,55],[4,
67],[4,19],[4,31],[4,43],[4,30],[4,42],[4,54],[4,6],[4,18],[4,50],[4,62],[4,
14],[4,26],[4,38],[4,70],[4,22],[4,34],[4,46],[4,58],[4,45],[4,57],[4,9],[4,
21],[4,33],[4,65],[4,17],[4,29],[4,41],[4,53],[4,25],[4,37],[4,49],[4,61],[4,
13],[4,60],[4,12],[4,24],[4,36],[4,48],[4,20],[4,32],[4,44],[4,56],[4,8],[4,
40],[4,52],[4,64],[4,16],[4,28],[5,12],[5,32],[5,52],[5,42],[5,62],[5,22],[5,
24],[5,44],[5,4],[5,54],[5,14],[5,34],[5,36],[5,56],[5,16],[5,66],[5,26],[5,
46],[5,48],[5,8],[5,28],[5,18],[5,38],[5,58],[5,60],[5,20],[5,40],[5,30],[5,
50],[5,10],[6,25],[6,7],[6,49],[6,61],[6,43],[6,35],[6,17],[6,59],[6,11],[6,
53],[6,45],[6,27],[6,9],[6,21],[6,63],[6,55],[6,37],[6,19],[6,31],[6,13],[6,5],
[6,47],[6,29],[6,41],[6,23],[6,15],[6,57],[6,39],[6,51],[6,33]];
  elif n=20 then res.indexchars:=Concatenation([1,6,11,31,32,41,42,51,52],
      [103,104,111,112,131,132],[152,156,161,167,172,176],[238..240],
      [241,251,246]);
      res.extRefl:=[1,8,2];
      res.charparams:=
 [[1,0],[1,20],[1,40],[2,21],[2,27],[2,11],[2,17],[2,1],[2,7],[3,2],[3,14],[3,
10,1],[3,10,2],[3,12],[3,6],[4,3],[4,11],[4,13],[4,6],[4,8],[4,16],[5,12],[5,
8],[5,4],[6,7],[6,9],[6,5]];
  elif n=21 then res.indexchars:=Concatenation([1,6..26],
      [65,32,35,62,41,73,43,71,84,52,82,54,91,92,101],
  [102,111,112,121,122,131,132,141,142,151,160,161,170,171,180,181,190,191,200],
      [201],[210..216],[241,242,246,261,251,266]);
      res.extRefl:=[1,18,5];
      res.charparams:=
[[1,0],[1,20],[1,40],[1,30],[1,50],[1,70],[2,39],[2,33],[2,21],[2,27],[2,29],
[2,23],[2,17],[2,11],[2,19],[2,13],[2,7],[2,1],[3,2],[3,14],[3,20,2],[3,20,1],
[3,10,2],[3,10,1],[3,28],[3,16],[3,18],[3,6],[3,12],[3,24],[4,3],[4,11],[4,19],
[4,6],[4,14],[4,22],[4,9],[4,17],[4,13],[4,12],[4,8],[4,16],[5,12],[5,8],[5,4],
[5,18],[5,14],[5,10],[6,13],[6,7],[6,11],[6,5],[6,9],[6,15]];
  elif n=22 then res.indexchars:=
      [1,16,65,32,35,62,91,92,101,102,151,166,181,196,211,240,241,246];
      res.extRefl:=[1,5,2];
      res.charparams:=[[1,0],[1,30],[2,11],[2,13],[2,1],[2,7],[3,2],[3,6],
       [3,12],[3,16],[4,3],[4,6],[4,9],[4,8],[5,4],[5,10],[6,7],[6,5]];
  fi;
  res.charnames:=List(res.charparams,
     x->CHEVIE.RawData("CharName","G16_22")(n,x,rec()));
  res.b:=List(res.charparams,x->x[2]);
  return res;
end);

CHEVIE.AddData("factors","G16_22",function(n)local f;f:=
  [[[1,0],[1,12],[1,24],[1,36],[1,48],[1,1,1,11],[1,7,1,17],[1,13,1,23],[1,19,1,
29],[1,13,1,23],[1,19,1,29],[1,25,1,35],[1,25,1,35],[1,31,1,41],[1,37,1,47],
[1,2,1,12,1,22],[1,6,1,16,1,26],[1,10,1,20,1,30],[1,10,1,20,1,30],[1,14,1,24,
1,34],[1,18,1,28,1,38],[1,14,1,24,1,34],[1,18,1,28,1,38],[1,22,1,32,1,42],[1,
26,1,36,1,46],[1,15,1,25,1,35,1,45],[1,17,2,27,1,37],[1,9,1,19,1,29,1,39],[1,
11,2,21,1,31],[1,3,1,13,1,23,1,33],[1,20,2,30,1,40],[1,12,1,22,1,32,1,42],[1,
14,2,24,1,34],[1,6,1,16,1,26,1,36],[1,8,2,18,1,28],[1,12,2,22,2,32],[1,4,1,14,
1,24,1,34,1,44],[2,16,2,26,1,36],[1,8,1,18,2,28,1,38],[1,10,2,20,1,30,1,40],
[1,5,2,15,2,25,1,35],[1,7,2,17,2,27,1,37],[1,9,2,19,2,29,1,39],[1,11,2,21,2,
31,1,41],[1,13,2,23,2,33,1,43]],[[1,0],[1,12],[1,24],[1,36],[1,48],[1,30],[1,
42],[1,54],[1,66],[1,78],[1,11,1,31],[1,17,1,37],[1,13,1,53],[1,19,1,59],[1,
13,1,53],[1,19,1,59],[1,25,1,65],[1,25,1,65],[1,31,1,71],[1,37,1,77],[1,1,1,
41],[1,7,1,47],[1,35,1,55],[1,35,1,55],[1,41,1,61],[1,47,1,67],[1,23,1,43],[1,
29,1,49],[1,23,1,43],[1,29,1,49],[1,2,1,22,1,42],[1,6,1,26,1,46],[1,10,1,30,1,
50],[1,10,1,30,1,50],[1,14,1,34,1,54],[1,18,1,38,1,58],[1,14,1,34,1,54],[1,18,
1,38,1,58],[1,22,1,42,1,62],[1,26,1,46,1,66],[1,12,1,32,1,52],[1,16,1,36,1,
56],[1,20,1,40,1,60],[1,20,1,40,1,60],[1,24,1,44,1,64],[1,28,1,48,1,68],[1,24,
1,44,1,64],[1,28,1,48,1,68],[1,32,1,52,1,72],[1,36,1,56,1,76],[1,15,1,35,1,55,
1,75],[2,27,1,47,1,67],[1,19,2,39,1,59],[1,11,1,31,2,51],[1,3,1,23,1,43,1,63],
[2,30,1,50,1,70],[1,22,2,42,1,62],[1,14,1,34,2,54],[1,6,1,26,1,46,1,66],[2,18,
1,38,1,58],[1,25,2,45,1,65],[1,17,1,37,2,57],[1,9,1,29,1,49,1,69],[2,21,1,41,
1,61],[1,13,2,33,1,53],[1,20,1,40,2,60],[1,12,1,32,1,52,1,72],[2,24,1,44,1,
64],[1,16,2,36,1,56],[1,8,1,28,2,48],[1,12,2,32,2,52],[2,22,1,42,2,62],[1,4,1,
24,2,44,1,64],[1,14,2,34,1,54,1,74],[2,16,1,36,2,56],[2,26,2,46,1,66],[1,8,2,
28,1,48,1,68],[1,18,2,38,2,58],[2,20,2,40,1,60],[1,10,1,30,2,50,1,70],[2,15,2,
35,2,55],[2,17,2,37,2,57],[2,19,2,39,2,59],[1,11,2,31,2,51,1,71],[1,13,2,33,2,
53,1,73],[1,5,2,25,2,45,1,65],[1,7,2,27,2,47,1,67],[1,9,2,29,2,49,1,69],[2,21,
2,41,2,61],[2,23,2,43,2,63]],[[1,0],[1,12],[1,24],[1,36],[1,48],[1,20],[1,32],
[1,44],[1,56],[1,68],[1,40],[1,52],[1,64],[1,76],[1,88],[1,21,1,51],[1,27,1,
57],[1,33,1,63],[1,39,1,69],[1,33,1,63],[1,39,1,69],[1,45,1,75],[1,45,1,75],
[1,51,1,81],[1,57,1,87],[1,11,1,41],[1,17,1,47],[1,23,1,53],[1,29,1,59],[1,23,
1,53],[1,29,1,59],[1,35,1,65],[1,35,1,65],[1,41,1,71],[1,47,1,77],[1,1,1,31],
[1,7,1,37],[1,13,1,43],[1,19,1,49],[1,13,1,43],[1,19,1,49],[1,25,1,55],[1,25,
1,55],[1,31,1,61],[1,37,1,67],[1,2,1,32,1,62],[2,26,1,56],[1,20,2,50],[1,20,2,
50],[1,14,1,44,1,74],[2,38,1,68],[1,14,1,44,1,74],[2,38,1,68],[1,32,2,62],[1,
26,1,56,1,86],[2,22,1,52],[1,16,2,46],[1,10,1,40,1,70],[1,10,1,40,1,70],[2,34,
1,64],[1,28,2,58],[2,34,1,64],[1,28,2,58],[1,22,1,52,1,82],[2,46,1,76],[1,12,
2,42],[1,6,1,36,1,66],[2,30,1,60],[2,30,1,60],[1,24,2,54],[1,18,1,48,1,78],[1,
24,2,54],[1,18,1,48,1,78],[2,42,1,72],[1,36,2,66],[1,15,2,45,1,75],[2,27,2,
57],[1,9,2,39,1,69],[2,21,2,51],[1,3,2,33,1,63],[2,35,2,65],[1,17,2,47,1,77],
[2,29,2,59],[1,11,2,41,1,71],[2,23,2,53],[1,25,2,55,1,85],[2,37,2,67],[1,19,2,
49,1,79],[2,31,2,61],[1,13,2,43,1,73],[2,30,2,60],[1,12,2,42,1,72],[2,24,2,
54],[1,6,2,36,1,66],[2,18,2,48],[1,20,2,50,1,80],[2,32,2,62],[1,14,2,44,1,74],
[2,26,2,56],[1,8,2,38,1,68],[2,40,2,70],[1,22,2,52,1,82],[2,34,2,64],[1,16,2,
46,1,76],[2,28,2,58],[1,12,2,42,2,72],[3,32,2,62],[2,22,3,52],[2,24,2,54,1,
84],[1,14,3,44,1,74],[1,4,2,34,2,64],[3,36,2,66],[2,26,3,56],[2,16,2,46,1,76],
[1,18,3,48,1,78],[1,8,2,38,2,68],[3,28,2,58],[2,30,3,60],[2,20,2,50,1,80],[1,
10,3,40,1,70],[3,25,3,55],[1,7,3,37,2,67],[2,19,3,49,1,79],[3,31,3,61],[1,13,
3,43,2,73],[1,5,3,35,2,65],[2,17,3,47,1,77],[3,29,3,59],[1,11,3,41,2,71],[2,
23,3,53,1,83],[2,15,3,45,1,75],[3,27,3,57],[1,9,3,39,2,69],[2,21,3,51,1,81],
[3,33,3,63]],[[1,0],[1,12],[1,24],[1,36],[1,48],[1,20],[1,32],[1,44],[1,56],
[1,68],[1,40],[1,52],[1,64],[1,76],[1,88],[1,30],[1,42],[1,54],[1,66],[1,78],
[1,50],[1,62],[1,74],[1,86],[1,98],[1,70],[1,82],[1,94],[1,106],[1,118],[2,
51],[2,57],[1,33,1,93],[1,39,1,99],[1,33,1,93],[1,39,1,99],[1,45,1,105],[1,45,
1,105],[1,51,1,111],[1,57,1,117],[2,41],[2,47],[2,53],[2,59],[2,53],[2,59],[1,
35,1,95],[1,35,1,95],[1,41,1,101],[1,47,1,107],[2,31],[2,37],[2,43],[2,49],[2,
43],[2,49],[2,55],[2,55],[1,31,1,91],[1,37,1,97],[1,21,1,81],[1,27,1,87],[2,
63],[2,69],[2,63],[2,69],[2,75],[2,75],[2,81],[2,87],[1,11,1,71],[1,17,1,77],
[1,23,1,83],[1,29,1,89],[1,23,1,83],[1,29,1,89],[2,65],[2,65],[2,71],[2,77],
[1,1,1,61],[1,7,1,67],[1,13,1,73],[1,19,1,79],[1,13,1,73],[1,19,1,79],[1,25,1,
85],[1,25,1,85],[2,61],[2,67],[1,2,2,62],[2,26,1,86],[3,50],[3,50],[1,14,2,
74],[2,38,1,98],[1,14,2,74],[2,38,1,98],[3,62],[1,26,2,86],[2,32,1,92],[3,56],
[1,20,2,80],[1,20,2,80],[2,44,1,104],[3,68],[2,44,1,104],[3,68],[1,32,2,92],
[2,56,1,116],[2,22,1,82],[3,46],[1,10,2,70],[1,10,2,70],[2,34,1,94],[3,58],[2,
34,1,94],[3,58],[1,22,2,82],[2,46,1,106],[3,52],[1,16,2,76],[2,40,1,100],[2,
40,1,100],[3,64],[1,28,2,88],[3,64],[1,28,2,88],[2,52,1,112],[3,76],[3,42],[1,
6,2,66],[2,30,1,90],[2,30,1,90],[3,54],[1,18,2,78],[3,54],[1,18,2,78],[2,42,1,
102],[3,66],[1,12,2,72],[2,36,1,96],[3,60],[3,60],[1,24,2,84],[2,48,1,108],[1,
24,2,84],[2,48,1,108],[3,72],[1,36,2,96],[1,15,3,75],[2,27,2,87],[3,39,1,99],
[4,51],[1,3,3,63],[2,35,2,95],[3,47,1,107],[4,59],[1,11,3,71],[2,23,2,83],[3,
55,1,115],[4,67],[1,19,3,79],[2,31,2,91],[3,43,1,103],[2,30,2,90],[3,42,1,
102],[4,54],[1,6,3,66],[2,18,2,78],[3,50,1,110],[4,62],[1,14,3,74],[2,26,2,
86],[3,38,1,98],[4,70],[1,22,3,82],[2,34,2,94],[3,46,1,106],[4,58],[3,45,1,
105],[4,57],[1,9,3,69],[2,21,2,81],[3,33,1,93],[4,65],[1,17,3,77],[2,29,2,89],
[3,41,1,101],[4,53],[1,25,3,85],[2,37,2,97],[3,49,1,109],[4,61],[1,13,3,73],
[4,60],[1,12,3,72],[2,24,2,84],[3,36,1,96],[4,48],[1,20,3,80],[2,32,2,92],[3,
44,1,104],[4,56],[1,8,3,68],[2,40,2,100],[3,52,1,112],[4,64],[1,16,3,76],[2,
28,2,88],[1,12,4,72],[3,32,2,92],[5,52],[3,42,2,102],[5,62],[2,22,3,82],[2,24,
3,84],[4,44,1,104],[1,4,4,64],[4,54,1,114],[1,14,4,74],[3,34,2,94],[3,36,2,
96],[5,56],[2,16,3,76],[5,66],[2,26,3,86],[4,46,1,106],[4,48,1,108],[1,8,4,
68],[3,28,2,88],[1,18,4,78],[3,38,2,98],[5,58],[5,60],[2,20,3,80],[4,40,1,
100],[2,30,3,90],[4,50,1,110],[1,10,4,70],[3,25,3,85],[1,7,5,67],[5,49,1,109],
[6,61],[4,43,2,103],[4,35,2,95],[2,17,4,77],[6,59],[1,11,5,71],[5,53,1,113],
[5,45,1,105],[3,27,3,87],[1,9,5,69],[2,21,4,81],[6,63],[6,55],[4,37,2,97],[2,
19,4,79],[3,31,3,91],[1,13,5,73],[1,5,5,65],[5,47,1,107],[3,29,3,89],[4,41,2,
101],[2,23,4,83],[2,15,4,75],[6,57],[4,39,2,99],[5,51,1,111],[3,33,3,93]],[[1,
0],[1,20],[1,40],[1,21,1,39],[1,27,1,33],[1,11,1,29],[1,17,1,23],[1,1,1,19],
[1,7,1,13],[1,2,1,20,1,38],[1,14,1,20,1,26],[1,10,1,22,1,28],[1,10,1,16,1,34],
[1,12,1,18,1,30],[1,6,1,24,1,30],[1,3,1,9,1,21,1,27],[1,11,1,17,1,23,1,29],[1,
13,1,19,1,31,1,37],[1,6,1,12,1,18,1,24],[1,8,1,14,1,26,1,32],[1,16,1,22,1,28,
1,34],[1,12,1,18,1,24,1,30,1,36],[1,8,1,14,1,20,1,26,1,32],[1,4,1,10,1,16,1,
22,1,28],[1,7,1,13,1,19,2,25,1,31],[1,9,2,15,1,21,1,27,1,33],[1,5,1,11,1,17,1,
23,1,29,1,35]],[[1,0],[1,20],[1,40],[1,30],[1,50],[1,70],[1,39,1,51],[1,33,1,
57],[1,21,1,69],[1,27,1,63],[1,29,1,41],[1,23,1,47],[1,17,1,53],[1,11,1,59],
[1,19,1,31],[1,13,1,37],[1,7,1,43],[1,1,1,49],[1,2,1,38,1,50],[1,14,1,26,1,
50],[1,20,1,32,1,68],[1,20,1,44,1,56],[1,10,1,22,1,58],[1,10,1,34,1,46],[1,28,
1,40,1,52],[1,16,1,40,1,64],[1,18,1,30,1,42],[1,6,1,30,1,54],[1,12,1,48,1,60],
[1,24,1,36,1,60],[1,3,1,27,1,39,1,51],[1,11,1,23,1,47,1,59],[1,19,1,31,1,43,1,
67],[1,6,1,18,1,42,1,54],[1,14,1,26,1,38,1,62],[1,22,1,34,1,46,1,58],[1,9,1,
21,1,33,1,57],[1,17,1,29,1,41,1,53],[1,13,1,37,1,49,1,61],[1,12,1,24,1,36,1,
48],[1,8,1,32,1,44,1,56],[1,16,1,28,1,52,1,64],[1,12,1,24,1,36,1,48,1,60],[1,
8,1,20,1,32,1,44,1,56],[1,4,1,16,1,28,1,40,1,52],[1,18,1,30,1,42,1,54,1,66],
[1,14,1,26,1,38,1,50,1,62],[1,10,1,22,1,34,1,46,1,58],[1,13,2,25,1,37,1,49,1,
61],[1,7,1,19,1,31,1,43,2,55],[1,11,1,23,2,35,1,47,1,59],[1,5,1,17,1,29,1,41,
1,53,1,65],[1,9,1,21,1,33,2,45,1,57],[2,15,1,27,1,39,1,51,1,63]],[[1,0],[1,
30],[1,11,1,19],[1,13,1,17],[1,1,1,29],[1,7,1,23],[1,2,1,10,1,18],[1,6,1,10,1,
14],[1,12,1,20,1,28],[1,16,1,20,1,24],[1,3,1,11,1,19,1,27],[1,6,1,14,1,18,1,
22],[1,9,1,13,1,17,1,21],[1,8,1,12,1,16,1,24],[1,4,1,8,1,12,1,16,1,20],[1,10,
1,14,1,18,1,22,1,26],[1,7,1,11,2,15,1,19,1,23],[1,5,1,9,1,13,1,17,1,21,1,25]]];
  return f[n-15];
end);

# The data below was computed by Maria Chlouveraki
CHEVIE.AddData("SchurModels","G16_22",rec(
f1:=rec(
 vcyc:=[[[1,-1,0,0,0,0,0,0,0,0],1],[[0,0,1,-1,0,0,0,0,0,0],1],
  [[0,0,1,0,-1,0,0,0,0,0],1],[[0,0,0,0,0,1,-1,0,0,0],1],
  [[0,0,0,0,0,1,0,-1,0,0],1],[[0,0,0,0,0,1,0,0,-1,0],1],
  [[0,0,0,0,0,1,0,0,0,-1],1],[[1,-1,1,-1,0,1,-1,0,0,0],1],
  [[1,-1,1,-1,0,1,0,-1,0,0],1],[[1,-1,1,-1,0,1,0,0,-1,0],1],
  [[1,-1,1,-1,0,1,0,0,0,-1],1],[[1,-1,1,0,-1,1,-1,0,0,0],1],
  [[1,-1,1,0,-1,1,0,-1,0,0],1],[[1,-1,1,0,-1,1,0,0,-1,0],1],
  [[1,-1,1,0,-1,1,0,0,0,-1],1],[[1,-1,2,-1,-1,2,-1,-1,0,0],1],
  [[1,-1,2,-1,-1,2,-1,0,-1,0],1],[[1,-1,2,-1,-1,2,-1,0,0,-1],1],
  [[1,-1,2,-1,-1,2,0,-1,-1,0],1],[[1,-1,2,-1,-1,2,0,-1,0,-1],1],
  [[1,-1,2,-1,-1,2,0,0,-1,-1],1],[[2,-2,2,-1,-1,3,-1,-1,-1,0],1],
  [[2,-2,2,-1,-1,3,-1,-1,0,-1],1],[[2,-2,2,-1,-1,3,-1,0,-1,-1],1],
  [[2,-2,2,-1,-1,3,0,-1,-1,-1],1],[[2,-2,3,-2,-1,4,-1,-1,-1,-1],1],
  [[2,-2,3,-1,-2,4,-1,-1,-1,-1],1],[[3,-3,4,-2,-2,4,-1,-1,-1,-1],1]]),
f2:=rec(coeff:=-2,root:=[1,1,1,1,0,1,1,0,0,0]/2,
 vcyc:=[[[0,0,1,0,-1,0,0,0,0,0],1],[[0,0,0,1,-1,0,0,0,0,0],1],
 [[0,0,0,0,0,1,0,-1,0,0],1],[[0,0,0,0,0,1,0,0,-1,0],1],
 [[0,0,0,0,0,1,0,0,0,-1],1],[[0,0,0,0,0,0,1,-1,0,0],1],
 [[0,0,0,0,0,0,1,0,-1,0],1],[[0,0,0,0,0,0,1,0,0,-1],1],
 [[0,0,1,0,-1,1,1,-1,-1,0],1],[[0,0,1,0,-1,1,1,-1,0,-1],1],
 [[0,0,1,0,-1,1,1,0,-1,-1],1],[[0,0,0,1,-1,1,1,-1,-1,0],1],
 [[0,0,0,1,-1,1,1,-1,0,-1],1],[[0,0,0,1,-1,1,1,0,-1,-1],1],
 [[0,0,1,1,-2,1,2,-1,-1,-1],1],[[0,0,1,1,-2,2,1,-1,-1,-1],1],
 [[-1,0,-1,0,0,-1,0,0,0,0,1],1],[[1,0,1,0,0,0,1,0,0,0,-1],1],
 [[0,1,1,0,0,1,0,0,0,0,-1],1],[[0,-1,-1,0,0,0,-1,0,0,0,1],1],
 [[0,-1,0,0,-1,0,0,-1,0,0,1],1],[[0,-1,0,0,-1,0,0,0,-1,0,1],1],
 [[0,-1,0,0,-1,0,0,0,0,-1,1],1],[[-1,0,0,0,-1,0,0,-1,0,0,1],1],
 [[-1,0,0,0,-1,0,0,0,-1,0,1],1],[[-1,0,0,0,-1,0,0,0,0,-1,1],1],
 [[-1,0,0,0,-1,1,1,-1,-1,-1,1],1],[[0,-1,0,0,-1,1,1,-1,-1,-1,1],1]]),
f3:=rec(coeff:=3,root:=[2,1,1,1,1,1,1,1,0,0]/3,
 vcyc:=[[[-1,1,0,0,0,0,0,0,0,0],1],[[0,0,0,0,0,1,0,0,-1,0],1],
 [[0,0,0,0,0,1,0,0,0,-1],1],[[0,0,0,0,0,0,1,0,-1,0],1],
 [[0,0,0,0,0,0,1,0,0,-1],1],[[0,0,0,0,0,0,0,1,-1,0],1],
 [[0,0,0,0,0,0,0,1,0,-1],1],[[1,-1,0,0,0,1,1,0,-1,-1],1],
 [[1,-1,0,0,0,1,0,1,-1,-1],1],[[1,-1,0,0,0,0,1,1,-1,-1],1],
 [[0,-1,-1,0,0,0,0,0,-1,0,1],1],[[0,-1,-1,0,0,0,0,0,0,-1,1],1],
 [[0,-1,0,-1,0,0,0,0,-1,0,1],1],[[0,-1,0,-1,0,0,0,0,0,-1,1],1],
 [[0,-1,0,0,-1,0,0,0,-1,0,1],1],[[0,-1,0,0,-1,0,0,0,0,-1,1],1],
 [[1,0,1,0,0,1,0,0,0,0,-1],1],[[1,0,1,0,0,0,1,0,0,0,-1],1],
 [[1,0,1,0,0,0,0,1,0,0,-1],1],[[1,0,0,1,0,1,0,0,0,0,-1],1],
 [[1,0,0,1,0,0,1,0,0,0,-1],1],[[1,0,0,1,0,0,0,1,0,0,-1],1],
 [[1,0,0,0,1,1,0,0,0,0,-1],1],[[1,0,0,0,1,0,1,0,0,0,-1],1],
 [[1,0,0,0,1,0,0,1,0,0,-1],1],[[-1,-1,-1,-1,0,0,0,0,-1,-1,2],1],
 [[-1,-1,-1,0,-1,0,0,0,-1,-1,2],1],[[-1,-1,0,-1,-1,0,0,0,-1,-1,2],1]]),
f4:=rec(coeff:=-4, root:=[2,2,2,1,1,1,1,1,1,0]/4,
 vcyc:=[[[0,0,-1,1,0,0,0,0,0,0],1],[[0,0,1,0,-1,0,0,0,0,0],1],
 [[0,0,0,0,0,1,0,0,0,-1],1],[[0,0,0,0,0,0,1,0,0,-1],1],
 [[0,0,0,0,0,0,0,1,0,-1],1],[[0,0,0,0,0,0,0,0,1,-1],1],
 [[1,0,1,0,0,1,0,0,0,0,-1],1],[[1,0,1,0,0,0,1,0,0,0,-1],1],
 [[1,0,1,0,0,0,0,1,0,0,-1],1],[[1,0,1,0,0,0,0,0,1,0,-1],1],
 [[0,1,1,0,0,1,0,0,0,0,-1],1],[[0,1,1,0,0,0,1,0,0,0,-1],1],
 [[0,1,1,0,0,0,0,1,0,0,-1],1],[[0,1,1,0,0,0,0,0,1,0,-1],1],
 [[-1,0,0,-1,0,0,0,0,0,-1,1],1], [[0,-1,0,-1,0,0,0,0,0,-1,1],1],
 [[-1,0,0,0,-1,0,0,0,0,-1,1],1], [[0,-1,0,0,-1,0,0,0,0,-1,1],1],
 [[-1,-1,-1,-1,0,-1,-1,0,0,0,2],1], [[-1,-1,-1,-1,0,-1,0,-1,0,0,2],1],
 [[1,1,1,1,0,1,0,0,1,0,-2],1], [[1,1,1,1,0,0,1,1,0,0,-2],1],
 [[-1,-1,-1,-1,0,0,-1,0,-1,0,2],1], [[-1,-1,-1,-1,0,0,0,-1,-1,0,2],1],
 [[-1,-1,0,-1,-1,-1,0,0,0,-1,2],1], [[-1,-1,0,-1,-1,0,-1,0,0,-1,2],1],
 [[-1,-1,0,-1,-1,0,0,-1,0,-1,2],1], [[-1,-1,0,-1,-1,0,0,0,-1,-1,2],1]]),
f5:=rec(coeff:=5,root:=[3,2,2,2,1,1,1,1,1,1]/5,
 vcyc:=[[[1,-1,0,0,0,0,0,0,0,0],1],[[0,0,-1,0,1,0,0,0,0,0],1],
 [[0,0,0,-1,1,0,0,0,0,0],1],[[1,0,1,0,0,1,0,0,0,0,-1],1],
 [[1,0,1,0,0,0,1,0,0,0,-1],1],[[1,0,1,0,0,0,0,1,0,0,-1],1],
 [[1,0,1,0,0,0,0,0,1,0,-1],1],[[1,0,1,0,0,0,0,0,0,1,-1],1],
 [[1,0,0,1,0,1,0,0,0,0,-1],1],[[1,0,0,1,0,0,1,0,0,0,-1],1],
 [[1,0,0,1,0,0,0,1,0,0,-1],1],[[1,0,0,1,0,0,0,0,1,0,-1],1],
 [[1,0,0,1,0,0,0,0,0,1,-1],1],[[0,-1,0,0,-1,-1,0,0,0,0,1],1],
 [[0,-1,0,0,-1,0,-1,0,0,0,1],1],[[0,-1,0,0,-1,0,0,-1,0,0,1],1],
 [[0,-1,0,0,-1,0,0,0,-1,0,1],1],[[0,-1,0,0,-1,0,0,0,0,-1,1],1],
 [[1,1,1,1,0,1,1,0,0,0,-2],1],[[1,1,1,1,0,1,0,1,0,0,-2],1],
 [[1,1,1,1,0,1,0,0,1,0,-2],1],[[1,1,1,1,0,1,0,0,0,1,-2],1],
 [[1,1,1,1,0,0,1,1,0,0,-2],1],[[1,1,1,1,0,0,1,0,1,0,-2],1],
 [[1,1,1,1,0,0,1,0,0,1,-2],1],[[1,1,1,1,0,0,0,1,1,0,-2],1],
 [[1,1,1,1,0,0,0,1,0,1,-2],1],[[1,1,1,1,0,0,0,0,1,1,-2],1]]),
f6:=rec(coeff:=-6,root:=[3,3,2,2,2,2,1,1,1,1]/6,
 vcyc:=[[[0,0,0,0,0,1,-1,0,0,0],1], [[0,0,0,0,0,1,0,-1,0,0],1],
 [[0,0,0,0,0,1,0,0,-1,0],1], [[0,0,0,0,0,1,0,0,0,-1],1],
 [[-1,0,-1,0,0,-1,0,0,0,0,1],1], [[-1,0,0,-1,0,-1,0,0,0,0,1],1], 
 [[-1,0,0,0,-1,-1,0,0,0,0,1],1],
 [[0,1,1,0,0,1,0,0,0,0,-1],1], [[0,1,0,1,0,1,0,0,0,0,-1],1], 
 [[0,1,0,0,1,1,0,0,0,0,-1],1],
 [[1,1,1,1,0,1,1,0,0,0,-2],1], [[1,1,1,1,0,1,0,1,0,0,-2],1],
 [[1,1,1,1,0,1,0,0,1,0,-2],1], [[1,1,1,1,0,1,0,0,0,1,-2],1],
 [[1,1,1,0,1,1,1,0,0,0,-2],1], [[1,1,1,0,1,1,0,1,0,0,-2],1],
 [[1,1,1,0,1,1,0,0,1,0,-2],1], [[1,1,1,0,1,1,0,0,0,1,-2],1],
 [[1,1,0,1,1,1,1,0,0,0,-2],1], [[1,1,0,1,1,1,0,1,0,0,-2],1],
 [[1,1,0,1,1,1,0,0,1,0,-2],1], [[1,1,0,1,1,1,0,0,0,1,-2],1],
 [[2,1,1,1,1,1,1,1,0,0,-3],1],[[2,1,1,1,1,1,1,0,1,0,-3],1],
 [[2,1,1,1,1,1,1,0,0,1,-3],1],[[2,1,1,1,1,1,0,1,1,0,-3],1],
 [[2,1,1,1,1,1,0,1,0,1,-3],1],[[2,1,1,1,1,1,0,0,1,1,-3],1]])));

CHEVIE.AddData("SchurData","G16_22",function(arg)
  return List(CHEVIE.RawData("paramchars","G16_22"),function(char)
  if char[1]=1 then return rec(name:="f1",
    order:=Concatenation([char[2],3-char[2],2+char[3]],
    2+Difference([1..3],[char[3]]),[5+char[4]],5+Difference([1..5],[char[4]])));
  elif char[1]=2 then return rec(name:="f2",order:=Concatenation([1,2],
    2+Difference([1..3],[char[3]]),[2+char[3]],
    5+Combinations([1..5],2)[char[4]],
    5+Difference([1..5],Combinations([1..5],2)[char[4]])),
    rootPower:=(-1)^char[2]);
  elif char[1]=3 then return rec(name:="f3",
    order:=Concatenation([char[3],3-char[3],3,4,5],
    5+Combinations([1..5],3)[char[4]],
    5+Difference([1..5],Combinations([1..5],3)[char[4]])),
    rootPower:=E(3)^char[2]);
  elif char[1]=4 then return rec(name:="f4",
    order:=Concatenation([1,2,2+char[3]],
    2+Difference([1..3],[char[3]]),5+Difference([1..5],[char[4]]),
    [5+char[4]]),
    rootPower:=E(4)^char[2]);
  elif char[1]=5 then return rec(name:="f5",
    order:=Concatenation([char[3],3-char[3]],
    2+Difference([1..3],[char[4]]),[2+char[4]],[6..10]),
    rootPower:=E(5)^char[2]);
  elif char[1]=6 then return rec(name:="f6",
    order:=Concatenation([1,2,3,4,5,5+char[3]],
    5+Difference([1..5],[char[3]])),
    rootPower:=E(6)^char[2]);
  fi;
  end);
end);

CHEVIE.AddData("Generic","G16_22",19);

CHEVIE.AddData("GetParams","G16_22",function(n,para)
  if   n=16 then return [[1,-1],[1,E(3),E(3)^2],para[1]];
  elif n=17 then return [para[1],[1,E(3),E(3)^2],para[2]];
  elif n=18 then return [[1,-1],para[1],para[2]];
  elif n=19 then return para;
  elif n=20 then return [[1,-1],para[1],[1,E(5),E(5)^2,E(5)^3,E(5)^4]];
  elif n=21 then return [para[1],para[2],[1,E(5),E(5)^2,E(5)^3,E(5)^4]];
  elif n=22 then return [para[1],[1,E(3),E(3)^2],[1,E(5),E(5)^2,E(5)^3,E(5)^4]];
  fi;
end);

CHEVIE.AddData("HeckeCharTable","G16_22",function(n,para,root)
  local X,Y,Z,c25,c35,c23,classes,GenericRow,res,ci,rows;
  X:=CHEVIE.RawData("GetParams","G16_22")(n,para);Z:=X[3];Y:=X[2];X:=X[1];
  c25:=Combinations([1..5],2); #precompute to save time
  c35:=Combinations([1..5],3);
  c23:=[[2,3],[1,3],[1,2]];
  GenericRow:=function(char)local l,r;
#   Print("char=",char,"\n");
    if char[1]=1 then l:=[1,X[char[2]],Y[char[3]],Z[char[4]],Z[char[4]]^2];
      return List(classes,class->l[class[1]]*Product(l{[2..4]})^class[2]);
    fi;
    if char[1]=2 then l:=[[2],X,Y{c23[char[3]]},Z{c25[char[4]]}];
    elif char[1]=3 then l:=[[3],X{[1,2,char[3]]},Y,Z{c35[char[4]]}];
    elif char[1]=4 then
      l:=[[4],X{[1,2,1,2]},Y{[1,2,3,char[3]]},Z{Difference([1..5],[char[4]])}];
    elif char[1]=5 then
      l:=[[5],X{[1,2,1,2,char[3]]},Concatenation(Y,Y{c23[char[4]]}),Z];
    elif char[1]=6 then 
      l:=[[6],X{[1,2,1,2,1,2]},Y{[1,2,3,1,2,3]},Z{[1,2,3,4,5,char[3]]}];
    fi;
    Add(l,List(l[4],x->x^2));
    return G4_22Helper(List(classes,class->Sum(l[class[1]])),
      List(classes,c->c[2]),Product(l{[2..4]},Product),char[1],char[2]);
  end;
  res:=rec(name:=SPrint("H(G",n,")"),ST:=n,
    parameter:=para,
    degrees:=CHEVIE.RawData("ReflectionDegrees","G16_22")(n),
    dim:=2,
    reflclasses:=[3],
    powermap:=CHEVIE.RawData("PowerMaps","G16_22")(n));
  Inherit(res,CHEVIE.RawData("ClassInfo","G16_22")(n));
  classes:=CHEVIE.RawData("paramclasses","G16_22"){res.indexclasses};
  res.size:=Product(res.degrees);res.order:=res.size;
  res.identifier:=res.name;
  res.centralizers:=List(res.classes,x->res.size/x);
  ci:=CHEVIE.RawData("CharInfo","G16_22")(n);
  res.irredinfo:=List([1..Length(res.classes)],i->
     rec(charparam:=ci.charparams[i],charname:=ci.charnames[i]));
  rows:=List(CHEVIE.RawData("paramchars","G16_22"),GenericRow);
  res.irreducibles:=rows{ci.indexchars};
  ci:=G4_22Test(res,rows,ci.indexchars);
  if ci<>true then res.indexchars:=ci;fi;
  return CHEVIE.compat.MakeCharacterTable(res);
end);

CHEVIE.AddData("CharTable","G16_22",function(n)local para;
  para:=CHEVIE.RawData("EigenvaluesGeneratingReflections","G16_22")(n);
  para:=List(para,x->List([0..1/x-1],j->E(1/x)^j));
  return CHEVIE.RawData("HeckeCharTable","G16_22")(n,para,[]);
end);

CHEVIE.AddData("HeckeRepresentation","G16_22",function(n,para,root,i)
  local X,Y,Z,m,rep,ci;
  X:=CHEVIE.RawData("GetParams","G16_22")(n,para);Z:=X[3];Y:=X[2];X:=X[1];
  rep:=function(char)local x1,x2,z1,z2,z3,z4,z5,y1,y2,y3,r,a,b;
    if char[1]=1 then return [[[X[char[2]]]],[[Y[char[3]]]],[[Z[char[4]]]]];
    elif char[1]=2 then
      return CHEVIE.RawData("Rep2","G4_7")(X,Y{Difference([1..3],[char[3]])},
        Z{Combinations([1..5],2)[char[4]]},char[2]);
    elif char[1]=3 then return CHEVIE.RawData("Rep3","G4_7")
       (X{[char[3],3-char[3]]},Y,Z{Combinations([1..5],3)[char[4]]},char[2]);
    elif char[1]=4 then return CHEVIE.RawData("Rep4","G8_15")(X,
       Y{Concatenation(Difference([1..3],[char[3]]),[char[3]])},
       Z{Difference([1..5],[char[4]])},char[2]);
    elif char[1]=5 then
      x1:=X[char[3]];x2:=X[3-char[3]];
      y1:=Y[char[4]];Y:=Difference(Y,[y1]);y2:=Y[1];y3:=Y[2];
      z1:=Z[1]; z2:=Z[2]; z3:=Z[3]; z4:=Z[4]; z5:=Z[5];
      r:=GetRoot(x1^3*x2^2*y1*y2^2*y3^2*z1*z2*z3*z4*z5,5)*E(5)^char[2];
      return 
 [[[x2+x1,0,0,0,x1],[0,x2+x1,0,x2,0],[0,0,x1,0,0],[0,-x1,0,0,0],[-x2,0,0,0,0]],
  [[0,0,0,0,-r/(z5*x2)],[0,0,0,-r/z4/x1,x2],
   [0,0,r/z3/x1,(x2*y2*y3*z2)/r-r/(x1*z4),x2],
   [0, r/z2/x2,x1*x2*y1*y2*y3*z1*z4*z5*(x1*(y3+y2)/r-1/z3)/r^2
	  -r/(z2*x2), y2+y3-r/(z3*x1)+x1*x2*z1*z5*y1*y2*y3/r^2,
	  -x1^2*x2^2*y1*y2*y3*z4*z5*z1/r^3],
   [r/z1/x1,r^2*(1/(z4*z2)+1/(z1*z5))/(x1*x2^2)-(y2*y3)/x2
    -(x1*y1*y2*y3*z3)/(r*x2), (-r^3/(x1*x2*z2*z4)+z3*x1*y1*y2*y3)*
    (1/(r*x2)+r/(x1^2*x2*z3^2*y2*y3)-(1/y3+1/y2)/(x1*x2*z3)),
    y1*y2*y3*(z2+z1*z5/z4)/r-r*(r+y1*z3*x1)/(z3*x1^2*z4*x2),
    y1+y2+y3-z1*z5*x1*x2*y1*y2*y3/r^2]],
  [[z1,(x1*y2*y3*z1*z2)/(r*x2)+r^3/x1/z4/x2^3/y3/z5/y2-r*(z2/z5+z1/z4)/x2^2,
    -r*z3/x2^2/z5-z1/x2*(y3+y2)+x1/x2*z3*z1*y2*y3/r-x1*y1*y2*y3*z1*z2*z4/r^2
    +x1^2*y1*y2*y3*z1*z2*z3*z4*(y3+y2)/r^3+r*z1/(x1*x2*z3),
    y2*y3*(x2*z1*z2+x1*z1*(z2+z3)+x1*z2*z3*z4/z5)/x2/r
    +y1*y2*y3*z1*z2*z3*x1*(x2+x1)/x2/r^2-y2^2*y3^2*z1*z2*z3*x1^2*z4/r^3
    -r*((z2+z3)/(z5*x2)+z1/(z4*x2)+z2/(z5*x1)+z1/(z4*x1))/x2,
    z1*(x2+x1)/x2+x1^2*z2*z3*z4*y2*y3/r^2-r*(1/y1+1/y2+1/y3)/x2],
   [0,z2,z3+x1*x2^2*y1*y2*y3*z1*z2*z4*z5/r^3-r*(1/y3+1/y2)/x1,
    x2*z2/x1+z3+z2-x1*x2*z2*z3*z4*y2*y3/r^2-r*(1/y3+1/y2)/x1,
    -r^2/(x1*z1*y1*y2*y3)],
   [0,0,z3,-r^3/(x1^2*x2*z1*z5*y1*y2*y3)+z3,-r^2/(x1*z1*y1*y2*y3)],
   [0,0,0,z4,z4*x1*x2*z5/r],[0,0,0,0,z5]]];
    elif char[1]=6 then
    # computed by Gunter on 30-8-2006
    r:=GetRoot(Product(Concatenation(X{[1,2,1,2,1,2]},Y{[1,2,3,1,2,3]},
        Z{[1,2,3,4,5,char[3]]})),6)*E(6)^char[2];
      x1:=X[1];x2:=X[2];y1:=Y[1];y2:=Y[2];y3:=Y[3];
      z5:=Z[char[3]];Z:=Z{Difference([1..5],[char[3]])};
      z1:=Z[1]; z2:=Z[2]; z3:=Z[3]; z4:=Z[4]; 
      a:=1;
      return r^0*[[[x1+x2,0,0,0,0,x2*x1],[0,x1+x2,0,0,x2*x1,0],
  [0,0,x1+x2,x2*x1,0,0],[0,0,-1,0,0,0],[0,-1,0,0,0,0],[-1,0,0,0,0,0]],
  [[0, 0, 0, 0, 0, -1/z5*r], [0, 0, 0, 0, -1/z4*r,-1/a/r^2/z4],
  [0, 0, 0, -1/z5*r, z4-z5, -1/a/r^3*z5],
  [0,0,r/z3/x2/x1,(x1*x2*y1*y2*y3*(z2*z5+z4*z1)-a/(z4*z5^2))/r^2,
  (-x1*x2*y1*y2*y3*z1*z4*z5*(z4-z5)+a/z5)/r^3,1/y1/y2/y3/x1^2/x2^2/z2/z3/a],
  [0,1/z2*r/x2/x1,-(y1*y3+y2*y3+y1*y2)*x1*x2*z1*z5^2*z4*y1*y2*y3/a
   +z5/x2/x1*(y3+y2+y1)*r^4/z3/a+r^2*y1*y2*y3*z5*(z4*z3*z1-z2^2*z5)/a/z2/z3
   +r^2*(-z3+z2)/z4/z5/x1/x2/z2/z3,-z5*(y1*y3+y2*y3+y1*y2)*r^3/a
   +r*(z2*z4*x2*x1*z5^3*y3*y2*y1-a)*(y3+y2+y1)/a/z4/z5
  +(x1*x2)^2*(y1*y2*y3)^2*z5^2*(z1*z4*z3-z5*z2^2)/r/a
  +x1*x2*y1*y2*y3*(z4*z1+2*z5*z2)/r/z4/z5-a/r/z4^2/z5^3,
  y3+y2+y1-x1*x2*y1*y2*y3*(z4*z1+z2*z5-z1*z5)/r^2+a/r^2/z4/z5^2,
  r/y1/y2/y3/x1^2/x2^2/z2/z3/a/z4/z5],
  [r/z1/x2/x1,
  -(x1*x2)^2*(y1*y2*y3)^2*z3*z4*z5*(-z2*z5+z2*z4-z4*z1+z1*z5)*a/r^2
  -x1*y1*y2*y3*x2*z3*a^2/r^2/z5,
  -(y1*y3+y2*y3+y1*y2)*(x1*x2*y1*y2*y3*z1*z4*z5^2*(z4-z5)-a)*r^3/z5
  +(z4-z5)*x1^2*x2^2*y1^2*y2^2*y3^2*z5^2*z2*z1*z4*(y3+y2+y1)*r
  -x1*x2*y1*y2*y3*((x1*x2)^2*(y1*y2*y3)^2*z1*z4^2*z5^4*(z5*z2^2*z4+(z5-z4)*z1*z3*z4-z5^2*z2^2)
  +x1*x2*y1*y2*y3*z4*z5^2*a*(2*z4*z1*z3-z5*z1*z3+z5*z2*z1+z5*z2*z3)-z3*a^2)/r/z5^2/z4,
  -(z4-z5)*(y1*y3+y2*y3+y1*y2)*x1^3*x2^3*z1*z5^2*z4*z3*z2*y1^2*y2^2*y3^2
  +(y3+y2+y1)*(x1*x2*y1*y2*y3*z2*z4*z5^2*(z4-z5)+a)*r^4/z5/z4
  -r^2*(x1*x2)^2*(y1*y2*y3)^2*z5*(-z1*z3*z4^2+z4*z2^2*z5+z5*z1*z4*z3-z5^2*z2^2)
  -r^2*a*x1*x2*y1*y2*y3*(z4*z3+z4*z1-z2*z4+2*z5*z2)/z4/z5+r^2*a^2/z4^2/z5^3,
  -x1*x2*y1*y2*y3*(z2-z1)*(z4-z5)*a*r-a^2*r/z5^2/z4,
  -1/z3/z4/z2/y1/y2/y3/z5/x1^2/x2^2*r^4+y1+y3+y2]],
  [[z1,(z2-z1)*(z4-z5)*a*r^3/z5+a^2*r^3/x1/y1/y2/y3/x2/z5^3/z4,
  x2^2*x1^2*y2*y3*z5*y1*(z4-z5)*(y1*y3+y2*y3+y1*y2)*z1*z4*z3*z2*r^2
  -(y3+y2+y1)*x1^2*x2^2*y1*y2*y3*z2*z3*(x1*x2*y1*y2*y3*z2*z4*z5^2*(-z5+z4)+a)*z1
  +x1*x2*y1*y2*y3*(z4-z5)*(z2^2*z5-z1*z4*z3)*r^4
  +a*(z3+z1-z2+2*z5*z2/z4)*r^4/z5^2-a^2*r^4/x1/x2/y1/y2/y3/z4^2/z5^4,
  -(y3+y2+y1)*(x1+x2)*x1^2*x2^2*y1*y2*y3*z2*z3*(x1*x2*y1*y2*y3*z2*z4*z5^2*(-z5+z4)+a)*z1
  -(y1*y3+y2*y3+y1*y2)*(x1*x2*z1*z4*(z4-z5)-a/y1/y2/y3/z5^2)*r^5
  +(x1*x2*y1*y2*y3*(z5-z4)*(z1*z4*z3-z5*z2^2)+a*(z4*z3+z4*z1-z2*z4+2*z5*z2)/z4/z5^2
  -a^2/x1/x2/y1/y2/y3/z4^2/z5^4)*(x1+x2)*r^4
  +x2^2*x1^2*y1*y2*y3*z5*z2*z1*z4*(z4-z5)*(y3+y2+y1)*r^3
  +x2^2*x1^2*y1*y2*y3*z5*z2*z1*z4*z3*(z4-z5)*(y1*y3+y2*y3+y1*y2)*(x1+x2)*r^2
  -r*x1*x2*((x1*x2*y1*y2*y3)^2*z1*z4^2*z5^4*(z1*z3*z4-z5*z2^2)*(z5-z4)
  +a*x1*x2*y1*y2*y3*z4*z5^2*(2*z4*z1*z3-z5*z1*z3+z5*z2*z1+z5*z2*z3)-z3*a^2)/z4/z5^3,
  (x1+x2)*((z1-z2)*(z5-z4)/z5+a/x1/y1/y2/y3/x2/z5^3/z4)*r^3*a
  -x1*x2*z3*(x1*x2*y1*y2*y3*z4*z5^2*(z1-z2)*(z5-z4)+a)*a/z5^2,
 -(y1*y3+y2*y3+y1*y2)*r/y1/y2/y3+z1*(x1+x2)+x1^2*x2^2*y1*y2*y3*z2*z5*z4*z3/r^3],
  [0, z2,
  (y1*y3+y2*y3+y1*y2)/x2/x1*r^5/y1/y2/y3/a-z5*z2*(y3+y2+y1)*r^3/a+
  r*(x1*x2*y1*y2*y3*z5*(-z4*z3*z1+z2^2*z5)/a+(z3-z2)/z5/z4),
  -z2*z5*(y3+y2+y1)*(x1+x2)*r^3/a-r^2*(z4*x1*x2*z5*z1/a-1/y1/y2/y3/z4/z5)*(y1*y3+y2*y3+y1*y2)
  +r*(x1*x2*y1*y2*y3*z4*z5^2*(-z4*z3*z1+z2^2*z5)+a*z3-a*z2)*(x1+x2)/a/z5/z4
  +x2^2*x1^2*z2*y1*y2*y3*z5^2*z1*z4*(y3+y2+y1)/a
  +x2^2*x1^2*z2*z3*y1*y2*y3*z5^2*z1*z4*(y1*y3+y2*y3+y1*y2)*(x1+x2)/a/r
  -x1*x2*((x1*x2*y1*y2*y3)^2*z1*z4*z5^2*(-z1*z3*z4+z5*z2^2)/a
  +x1*x2*y1*y2*y3*z3*(2*z4*z1+z5*z2)/z4-z3*a/z4^2/z5^2)/r^2,
  -(y1*y3+y2*y3+y1*y2)*r/y1/y2/y3+z2*(x1+x2)
  -x1*x2*z3*(x1*x2*y1*y2*y3*z4*z5^2*(-z4*z1+z2*z4-z2*z5)+a)/r^3/z4/z5,
  1/x1/x2/y1/y2/y3/a/z1/z4],
 [0,0,z3,z3*(x1+x2)-x1*x2*z3*(x1*x2*y1*y2*y3*z4*z5^2*(z2*z5+z4*z1)-a)/r^3/z4/z5,
 -x1*x2*z3*(x1*x2*y1*y2*y3*z2*z4*z5^2*(-z5+z4)+a)/r^4,z5/z1/r/x2/x1/y1/y2/y3/a],
  [0, 0, 0, z5, (z4-z5)*z4/r*z5,-z5^2/r^4/a*z4],
  [0, 0, 0, 0, z4, -1/a/r^3*z5],[0, 0, 0, 0, 0, z5]]];
  fi;
  end;
  ci:=G4_22FetchIndexChars(n,para)[i];
  m:=rep(CHEVIE.RawData("paramchars","G16_22")[ci])+0*Product(para,Product);
  m:=m+0*Product(para,Product);
  if n=16 then return [m[3],m[1]*m[3]*m[1]^-1];
  elif n=17 then return m{[1,3]};
  elif n=18 then return m{[2,3]};
  elif n=19 then return m;
  elif n=20 then return [m[2],m[1]*m[2]*m[1]^-1];
  elif n=21 then return m{[1,2]};
  elif n=22 then return [m[1],m[2]*m[1]*m[2]^-1,m[1]^m[2]];
  fi;
end);

CHEVIE.AddData("Representation","G16_22",function(ST,i)local para;
  para:=CHEVIE.RawData("EigenvaluesGeneratingReflections","G16_22")(ST);
  para:=List(para,x->List([0..1/x-1],j->E(1/x)^j));
  return CHEVIE.RawData("HeckeRepresentation","G16_22")(ST,para,i);
end);

CHEVIE.AddData("Invariants","G16_22",function(n)local i;
 i:=[ [function(x,y) return
     228*x^5*y^15+494*x^10*y^10-228*x^15*y^5+x^20+y^20;end,
    function(x,y) return -522*x^5*y^25-10005*x^10*y^20
     -10005*x^20*y^10+522*x^25*y^5+x^30+y^30;end],
   [function(x,y) return 228*x^5*y^15+494*x^10*y^10-228*x^15*y^5+x^20+y^20;end,
    function(x,y) return -6*x^5*y^55+330*x^10*y^50-7230*x^15*y^45
    +78540*x^20*y^40-417510*x^25*y^35+808566*x^30*y^30+417510*x^35*y^25
    +78540*x^40*y^20+7230*x^45*y^15+330*x^50*y^10+6*x^55*y^5;end],
   [function(x,y) return  -522*x^5*y^25-10005*x^10*y^20-10005*x^20*y^10
    +522*x^25*y^5+x^30+y^30;end,
   function(x,y) return  6*x^5*y^55-330*x^10*y^50+7230*x^15*y^45
   -78540*x^20*y^40+417510*x^25*y^35-808566*x^30*y^30-417510*x^35*y^25
   -78540*x^40*y^20-7230*x^45*y^15-330*x^50*y^10-6*x^55*y^5;end],
   [function(x,y) return -x^5*y^55+55*x^10*y^50-1205*x^15*y^45
    +13090*x^20*y^40-69585*x^25*y^35+134761*x^30*y^30+69585*x^35*y^25
    +13090*x^40*y^20+1205*x^45*y^15+55*x^50*y^10+x^55*y^5;end,
    function(x,y) return -180*x^5*y^55+204954*x^10*y^50+11486340*x^15*y^45
     +88770255*x^20*y^40+70567704*x^25*y^35+83221580*x^30*y^30
     -70567704*x^35*y^25+88770255*x^40*y^20-11486340*x^45*y^15+204954*x^50*y^10
     +180*x^55*y^5+x^60+y^60;end],
   [function(x,y) return 
    34375*x^3*y^9-4125*x^6*y^6-275*x^9*y^3+x^12+15625*y^12;end,
    function(x,y) return -3540039062500*x^3*y^27+955810546875*x^6*y^24
     -977050781250*x^9*y^21-371279296875*x^12*y^18-2970234375*x^18*y^12
     +62531250*x^21*y^9+489375*x^24*y^6+14500*x^27*y^3+8*x^30
     +244140625000*y^30;end],
   [function(x,y) return -x*y^11+11*x^6*y^6+x^11*y;end,
    function(x,y) return 684*x^5*y^55+157434*x^10*y^50+12527460*x^15*y^45
     +77460495*x^20*y^40+130689144*x^25*y^35-33211924*x^30*y^30
     -130689144*x^35*y^25+77460495*x^40*y^20-12527460*x^45*y^15
     +157434*x^50*y^10-684*x^55*y^5+x^60+y^60;end],
    [function(x,y) return -x*y^11+11*x^6*y^6+x^11*y;end,
     function(x,y) return 228*x^5*y^15+494*x^10*y^10-228*x^15*y^5+x^20+y^20;end]
   ];
  return i[n-15];
end);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","G16_22",function(n)local d;
  d:=[ function(t1,t2) return t2^2-t1^3;end,
       function(t1,t2) return 288*t2^2+t1^3*t2;end,
       function(t1,t2) return 288*t2^2+t1^2*t2;end,
       function(t1,t2) return t1*t2^2-746496*t1^3;end,
       function(t1,t2) return t2^2-64*t1^5;end,
       function(t1,t2) return t2^2+1728*t1^5*t2;end,
       function(t1,t2) return t2^3+1728*t1^5;end];
  return d[n-15];
end);
