#############################################################################
##
#W  fixes_matrix.g	   	Matrix Packages                  Frank Celler
##
#H  @(#)$Id: matrix.g,v 1.1 1997/03/10 13:51:58 gap Exp $
##
#Y  Copyright (C)  1996,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file  fixes functions from  the  matrix  packages  of GAP 3.4  which
##  should been done slightly differently.
##
RevisionMatrix.fixes_matrix_g :=
    "@(#)$Id: matrix.g,v 1.1 1997/03/10 13:51:58 gap Exp $";


# read in the files to patch
ReadLib("matrix");


#############################################################################
##

#F  IsAbsolutelyIrreducible( <obj> )  . . . . . .  check if <obj> is abs irrd
##
IsAbsolutelyIrreducible := function( obj )
    local R, r;

    # group module from smash
    if IsGModule(obj)  then
        if not IsBound(obj.isAbsolutelyIrreducible)  then
            obj.isAbsolutelyIrreducible :=
                MatrixMTX.isAbsolutelyIrreducible(obj);
        fi;
        return obj.isAbsolutelyIrreducible;

    # gap records
    elif IsRec(obj) then
        if not IsBound(obj.isAbsolutelyIrreducible)  then
            if not IsBound(obj.operations)  then
                Error( "<struct> must have 'operations' entry" );
            fi;
            obj.isAbsolutelyIrreducible:=
                obj.operations.IsAbsolutelyIrreducible(obj);
        fi;
        return obj.isAbsolutelyIrreducible;

    # anything else
    else
        Error( "do not know how to test absolutely irreducible" );
    fi;

end;


#############################################################################
##
#F  OrderMat( <mat> ) . . . . . . . . . . . . . . . . . . . order of a matrix
##
OrderMat := function ( mat )
    local   m,  id,  ord,  i,  vec,  v,  o;

    # check that the argument is an invertible square matrix
    m := Length(mat);
    if m <> Length(mat[1])  then
        Error("OrderMat: <mat> must be a square matrix");
    fi;
    if IsFFE(mat[1][1])  then
        return Order( FiniteFieldMatrices, mat );
    fi;
    if RankMat(mat) <> m  then
        Error("OrderMat: <mat> must be invertible");
    fi;
    id := mat ^ 0;

    # loop over the standard basis vectors
    ord := 1;
    for i  in [1..m]  do

        # compute the length of the orbit of the <i>th standard basis vector
        vec := mat[i];
        v   := vec * mat;
        o   := 1;
        while v <> vec  do
            v := v * mat;
            o := o + 1;
            if OrderMatLimit = o  then
                Print("#W  OrderMat: warning, order might be infinite\n");
            fi;
        od;

        # raise the matrix to this length (new mat will fix basis vector)
        mat := mat ^ o;
        ord := ord * o;
    od;

    # return the order
    return ord;
end;


#############################################################################
##
#F  ProjectiveOrderMat( <mat> )	. . . . . . . . . . . . . . order of a matrix
##
ProjectiveOrderMat := function ( mat )
    local   m,  id,  ord,  i,  vec,  v,  o;

    # check that the argument is an invertible square matrix
    m := Length(mat);
    if m <> Length(mat[1])  then
        Error("OrderMat: <mat> must be a square matrix");
    fi;
    if IsFFE(mat[1][1])  then
        return FiniteFieldMatricesOps.ProjectiveOrder(
            FiniteFieldMatrices, mat );
    fi;
    Error( "<mat> has to be a matrix over a finite field" );
end;


#############################################################################
##

#E  fixes_matrix.g  . . . . . . . . . . . . . . . . . . . . . . . . ends here
##
