if not IsBound(CHEVIE.families) then CHEVIE.families:=rec();fi;

FamilyOps:=OperationsRecord("FamilyOps");

FamilyOps.String:=function(f)local res;
  res:=SPrint("Family(",FormatGAP(TeXStrip(f.name)));
  if IsBound(f.charNumbers) then
    PrintToString(res,",",FormatGAP(f.charNumbers));
  fi;
  return SPrint(res,")");
end;

FamilyOps.Print:=function(f)Print(String(f));end;

FamilyOps.Format:=function(f,opt)local t,collab,rowlab;
  opt:=ShallowCopy(opt);
  if IsBound(f.charLabels) then opt.rowLabels:=f.charLabels;
    if not IsBound(opt.TeX) then opt.rowLabels:=List(opt.rowLabels,TeXStrip);fi;
  else  opt.rowLabels:=List([1..Length(f.eigenvalues)],x->Format(x,opt));
  fi;
  t:=[List(f.eigenvalues,x->Format(x,opt))];
  if IsBound(opt.TeX)then collab:=["\\Omega"];else collab:=["eigen"];fi;
  if IsBound(f.deltas) then Add(t,f.deltas);Add(collab,"delta"); fi;
  if IsBound(f.delta1) then Add(t,f.delta1);Add(collab,"delta1"); fi;
  Append(t,List(f.fourierMat,x->List(x,y->Format(y,opt))));
  if Maximum(List(opt.rowLabels,Length))<=4 then Append(collab,opt.rowLabels);
  else Append(collab,List(opt.rowLabels,x->" "));
  fi;
  if IsBound(opt.TeX) then opt.rowsLabel:="\\hbox{label}";
  else opt.rowsLabel:="label";fi;
  return FormatTable(TransposedMat(t),Inherit(opt,rec(columnLabels:=collab)));
end;

FamilyOps.Fourier:=f->f.fourierMat;
FamilyOps.Eigenvalues:=f->f.eigenvalues;
FamilyOps.Frobenius:=f->f.eigenvalues;

FamilyOps.Display:=function(x,opt)Print(Format(x,opt));end;

# Family(family[,charNumbers[,rec()]])
# rec can specify: Lusztig's delta (if any)
#                  delta1 (for complex groups)
#                  which character is special
#                  which character is cospecial
Family:=function(arg)local f,extra,ind;
  f:=arg[1];
  if IsString(f) then ind:=f;f:=ShallowCopy(CHEVIE.families.(f));f.name:=ind;
  else f:=ShallowCopy(f);
  fi;
  f.operations:=FamilyOps;
  f.size:=Length(f.eigenvalues);
  ind:=[1..f.size];
  if not IsBound(f.charLabels) then f.charLabels:=List(ind,String);fi;
  if not IsBound(f.name) then f.name:=SPrint("?",f.size);fi;
  if not IsBound(f.special) then f.special:=1;fi;
  if Length(arg)=1 then return f;fi;
  f.charNumbers:=arg[2];
  if Length(arg)=2 then return f;fi;
  extra:=arg[3];
  Inherit(f,extra);
  if IsBound(f.delta1) then
    f.fourierMat:=List(ind,i->f.delta1[i]*List(ind,
     j->f.delta1[j]*f.fourierMat[i][j]));
    if IsBound(f.perm) and ForAny(Flat(f.fourierMat^2),x->x=-1) then
     Unbind(f.perm);
    fi;
  fi;
  if IsBound(f.deltas) then
    f.fourierMat:=List(ind,i->List(ind,j->f.deltas[j]*f.fourierMat[i][j]));
  fi;
  return f;
end;

FamilyOps.ComplexConjugate:=function(f)local res;
  res:=ShallowCopy(f);
  res.eigenvalues:=ComplexConjugate(res.eigenvalues);
  res.fourierMat:=ComplexConjugate(res.fourierMat);
  res.name:=Concatenation("\\overline ",res.name);
  return res;
end;

FamilyOps.\*:=function(arg)local res,a;
  arg:=List(arg,Family);
  res:=rec(
    charLabels:=List(Cartesian(List(arg,x->x.charLabels)),
      v->Join(v,"\\otimes ")),
    fourierMat:=ApplyFunc(KroneckerMatrix,List(arg,x->x.fourierMat)),
    eigenvalues:=List(Cartesian(List(arg,x->x.eigenvalues)),Product),
    name:=Join(List(arg,f->f.name),"\\otimes "));
  if Length(arg)=1 then Inherit(res,arg[1]);fi;
  if ForAll(arg,f->IsBound(f.charNumbers)) then 
    res.charNumbers:=Cartesian(List(arg,x->x.charNumbers));
  fi;
  if ForAll(arg,f->IsBound(f.charLabels)) then 
    res.charLabels:=List(Cartesian(List(arg,x->x.charLabels)),Join);
  fi;
  if ForAll(arg,f->IsBound(f.special)) then 
    res.special:=PositionCartesian(List(arg,f->Length(f.fourierMat)),
      List(arg,f->f.special));
    res.cospecial:=PositionCartesian(List(arg,f->Length(f.fourierMat)),
      List(arg,function(f)if IsBound(f.cospecial) then return f.cospecial;
                                          else return f.special;fi;end));
    if res.cospecial=res.special then Unbind(res.cospecial);fi;
  fi;
  if ForAny(arg,f->IsBound(f.qEigen)) then
    res.qEigen:=List(Cartesian(List(arg,function(f) 
      if IsBound(f.qEigen) then return f.qEigen;else return f.eigenvalues*0;fi;
      end)),Sum);
  fi;
  res.operations:=FamilyOps;
  return res;
end;

# family for singletons
CHEVIE.families.C1:=Family(rec(group:="C1", name:="C_1",
  charLabels:=[""], fourierMat:=[[1]], eigenvalues:=[1],
  mellin:=[[1]],mellinLabels:=[""]));
# variants occuring e.g. in unitary groups
CHEVIE.families.("C'1"):=rec(group:="C1", name:="C'_1",
  charLabels:=[""],
  fourierMat:=[[-1]],
  deltas:=[-1],
  eigenvalues:=[-1],
  sh:=[1]);
# the usual family for C2
CHEVIE.families.C2:=rec(group:="C2", name:="C_2",
  charLabels:=["(1,1)", "(g_2,1)", "(1,\\varepsilon)", "(g_2,\\varepsilon)"],
  fourierMat:=1/2*[[1,1,1,1],[1,1,-1,-1],[1,-1,1,-1],[1,-1,-1,1]],
  eigenvalues:=[1,1,1,-1],
  perm:=(),
  mellin:=[[1,1,0,0],[1,-1,0,0],[0,0,1,1],[0,0,1,-1]],
  mellinLabels:=["(1,1)","(1,g2)","(g2,1)","(g2,g2)"]);
# variation occuring in E7 and E8
CHEVIE.families.("C'2"):=rec(group:="C2",name:="C'_2",
  charLabels:=["(1,1)",  "(1,\\varepsilon)", "(g_2,1)","(g_2,\\varepsilon)"],
  fourierMat:=1/2*[[1,1,-1,-1],[1,1,1,1],[1,-1,-1,1],[1,-1,1,-1]],
  deltas:=[1,1,-1,-1],
  eigenvalues:=[1,1,E(4),-E(4)],
  qEigen:=[0,0,1/2,1/2],
  perm:=(3,4),
  lusztig:=true, # does not satisfy (ST)^3=1 but (SPT)^3=1
  cospecial:=2);
# new family introduced by Gunter for H3 and H4. Previous was C'2
CHEVIE.families.("C'\"2"):=rec(group:="C2", name:="C'''_2",
  charLabels:=["(1,1)", "(g2,1)", "(1,eps)", "(g2,eps)"],
  fourierMat:=1/2*[[1,1,-1,-1],[1,1,1,1],[-1,1,-1,1],[-1,1,1,-1]],
  eigenvalues:=[1,1,E(4),-E(4)],
  qEigen:=[0,0,1/2,1/2],
  perm:=(3,4),
  comment:="explain the Frobenius eigenvalues",
  cospecial:=2);
## new family introduced by Gunter for H3. 
CHEVIE.families.("C'#2"):=rec(group:="C2",name:="C^{\\prime\\sharp}_2",
  charLabels:=["(1,1)", "(g_2,1)", "(1,\\varepsilon)", "(g_2,\\varepsilon)"],
  fourierMat:=[[5-ER(5),  5+ER(5), 2*ER(5),  2*ER(5)],
               [5+ER(5),  5-ER(5),-2*ER(5), -2*ER(5)],
               [2*ER(5), -2*ER(5),-5+ER(5),  5+ER(5)],
               [2*ER(5), -2*ER(5), 5+ER(5), -5+ER(5)]]/10,
  eigenvalues:=[1,1,E(5)^3,E(5)^2],
  comment:="everything to explain",
  perm:=(3,4),
  cospecial:=2);
CHEVIE.families.S3:=rec(group:="S3", name:="Q(S_3)",
  charLabels:=[ "(1,1)", "(g_2,1)", "(g_3,1)", "(1,\\rho)", "(1,\\varepsilon)",
		"(g_2,\\varepsilon)", "(g_3,\\zeta_3)", "(g_3,\\zeta_3^2)"],
  fourierMat:=[[1, 3, 2, 2,1, 3, 2, 2],[3, 3, 0, 0,-3,-3, 0, 0],
		[2, 0, 4,-2,2, 0,-2,-2],[2, 0,-2, 4, 2, 0,-2,-2],
		[1,-3, 2, 2,1,-3, 2, 2],[3,-3, 0, 0,-3, 3, 0, 0],
		[2, 0,-2,-2,2, 0, 4,-2],[2, 0,-2,-2, 2, 0,-2, 4]]/6,
  eigenvalues:=[1,1,1,1,1,-1,E(3),E(3)^2],
  perm:=(7,8),
  lusztig:=true, # does not satisfy (ST)^3=1 but (SPT)^3=1
  mellin:=[[1,0,0,2,1,0,0,0],[0,1,0,0,0,1,0,0],[0,0,1,0,0,0,1,1],[1,0,0,-1,1,0,
   0,0],[1,0,0,0,-1,0,0,0],[0,1,0,0,0,-1,0,0],[0,0,1,0,0,0,E(3),E(3)^2],
   [0,0,1,0,0,0,E(3)^2,E(3)]],
  mellinLabels:=["(1,1)","(g2,1)","(1,g3)","(g3,1)","(1,g2)","(g2,g2)",
    "(g3,g3)","(g3,g3^2)"]);

# n-th exterior power of the character ring of the cyclic group
# of order n, according to Michael Cuntz.
CHEVIE.families.ExtPowCyclic:=function(e,n)local g;
  g:=rec();
# S and T matrices for the cyclic group of order e
  if e mod 2 = 0 then
    g.eigenvalues:=E(24)^(e-1)*List([0..e-1],i->E(2*e)^(i*i+e*i));
  else
    g.eigenvalues:=E(24)^(e-1)*List([0..e-1],i->E(e)^QuoInt((i*i+e*i),2));
  fi;
  g.eigenvalues:=DiagonalOfMat(ExteriorPower(DiagonalMat(g.eigenvalues),n));
  g.fourierMat:=ExteriorPower(
    List([0..e-1],i->List([0..e-1],j->E(e)^(i*j)))/ER(e),n);
  g.charSymbols:=Combinations([0..e-1],n);
  g.charLabels:=List(g.charSymbols,
    s->Join(List(s,x->Format(E(e)^x,rec(TeX:=true))),"\\!\\wedge\\!"));
  if n>1 then g.name:=SPrint("R(\\BZ/",e,")^{\\wedge ",n,"}");
  else g.name:=SPrint("R(\\BZ/",e,")");
  fi;
  g.eigenvalues:=g.eigenvalues/g.eigenvalues[1];
  g.special:=1;
  g.operations:=FamilyOps;
  return g;
end;

# The families for cyclic groups (big family in Z_n is X(n(n-1)/2))
# It is  the exterior square of the character ring for Z/pZ,
# However for a different normalisation than the above: the Fourier
# matrix is the opposite, and the eigenvalues are different if e<>3
CHEVIE.families.X:=function(p)local ss;
  ss:=Combinations([0..p-1],2);
  return rec(
    name:=SPrint("R_{\\BZ/",p,"}^{\\wedge 2}"),
    charSymbols:=ss,
    charLabels:=List(ss,s->SPrint(Format(E(p)^s[1],rec(TeX:=true)),
      "\\!\\wedge\\!",Format(E(p)^s[2],rec(TeX:=true)))),
    eigenvalues:=List(ss,s->E(p)^Product(s)),
    fourierMat:=List(ss,i->List(ss,j->(E(p)^(i*Reversed(j))-E(p)^(i*j))/p)),
    special:=1,cospecial:=p-1,operations:=FamilyOps);
end;

# Subring of family f determined by ind and the scaling factor f
# ind is function(f,i) returns true if i in subring
SubFamily:=function(f,ind,scal,label)local res;
  ind:=Filtered([1..Length(f.eigenvalues)],i->ind(f,i));
  res:=rec(fourierMat:=f.fourierMat{ind}{ind}*scal,
   eigenvalues:=f.eigenvalues{ind},
   charLabels:=f.charLabels{ind},
   operations:=FamilyOps);
  res.name:=SPrint(f.name,"_{[",label,"]}");
  if IsBound(f.charSymbols) then res.charSymbols:=f.charSymbols{ind};fi;
  if IsBound(f.group) then res.group:=f.group;fi;
  if f.special in ind then res.special:=Position(ind,f.special);fi;
  return res;
end;

SubFamilyij:=function(f,i,j,scal) return SubFamily(f,
  function(f,k)return Sum(f.charSymbols[k]) mod j=i;end,scal,Join([i,j]));
end;

CHEVIE.families.X5:=SubFamilyij(CHEVIE.families.X(6),1,3,1-E(3));
CHEVIE.families.X5.cospecial:=5;

#  family made from QZ(3) by Gunter 22/9/99:
CHEVIE.families.Z9:=CHEVIE.families.ExtPowCyclic(9,1);
if CHEVIE.families.Z9.eigenvalues<>List([0..8],i->E(9)^(5*i^2))then Error();fi;
CHEVIE.families.Z9.perm:=(2,9)(3,8)(4,7)(5,6);
CHEVIE.families.Z9.qEigen:=[0,2/3,1/3,0,2/3,1/3,0,2/3,1/3];

CHEVIE.families.Z4:=CHEVIE.families.ExtPowCyclic(4,1);
CHEVIE.families.Z4.fourierMat:=CHEVIE.families.Z4.fourierMat/E(4);
CHEVIE.families.Z4.eigenvalues:=CHEVIE.families.Z4.eigenvalues/CHEVIE.families.Z4.eigenvalues[2];
CHEVIE.families.Z4.special:=2;
CHEVIE.families.Z4.qEigen:=[1/2,0,1/2,0];

CHEVIE.families.Z2:=CHEVIE.families.ExtPowCyclic(2,1);
CHEVIE.families.Z2.eigenvalues:=CHEVIE.families.Z2.eigenvalues*E(8)^3;
# the commonest families for complex groups... (also appearing as conjugates
# or in tensor products)

# Quantum double of Z/eZ
CHEVIE.families.QZ:=function(e)local c,p;
  c:=Product([e-1,e-2..1],i->(i,i+1));
  p:=Concatenation(List([0..e-1],i->List([0..e-1],j->[i,j])));
  return rec(
   name:=SPrint("Q(\\BZ/",e,")"),
   x:=List(p,i->c^i[1]), y:=List(p,i->c^i[2]),
   yLabels:=List(p,function(i)local res;
      res:=List([0..e-1],i->'.');res[i[2]+1]:='1';return String(res);end),
   chi:=List(p,i->List([0..e-1],k->E(e)^(i[2]*k))),
   charLabels:=List(p,i->SPrint("(",FormatMonomial(SPrint("g_",e),i[1],
     rec(TeX:=1)),",",FormatTeX(E(e)^i[2]),")")),
   eigenvalues:=List(p,i->E(e)^Product(i)),
   group:=ComplexReflectionGroup(e,1,1),
   special:=1,
   Mellin:=List(p,i->List(p,function(j)if i[1]<>j[1] then return 0;
      else return E(e)^(-i[2]*j[2]);fi;end))/e,
   fourierMat:=List(p,i->List(p,j->E(e)^(i*Reversed(j))))/e,
   operations:=FamilyOps);
end;

# for types B and D
# make list of families from list sym of symbols [S,T] with |S|>=|T|.
FamiliesClassical:=function(sym) local t,f,res,c,Z1,l;
# As in Lusztig Book chap. 4 we define
# Z2=Intersection(S,T), Z1=SymmetricDifference(S,T) 
# M0=elements in positions in Z1 different(mod 2) from |Z1|
# Msharp=SymmetricDifference(T-Z2,M0)
  t:=List(sym,function(ST)local f,D;ST:=FullSymbol(ST);
    f:=rec(Z1:=ApplyFunc(SymmetricDifference,ST));D:=Length(f.Z1) mod 2;
    f.Msharp:=SymmetricDifference(Difference(f.Z1,ST[2]),
				     f.Z1{[1+D,3+D..Length(f.Z1)-1]});
    if D=1 and Length(f.Msharp) mod 2<>0 then 
      f.Msharp:=Difference(f.Z1,f.Msharp);
    fi;
    f.content:=Concatenation(ST);Sort(f.content);return f;
  end);

  res:=[];
  for l in CollectBy([1..Length(t)],i->t[i].content) do
    f:=rec(content:=t[l[1]].content,charNumbers:=l);
    f.Msharp:=List(t{l},x->x.Msharp);
    if Length(l)=2 then # separate (S,S) gathered together in type D
      Add(res,rec(content:=f.content,charNumbers:=[l[2]],Msharp:=[f.Msharp[2]]));
      f:=rec(content:=f.content,charNumbers:=[l[1]],Msharp:=[f.Msharp[1]]);
    fi;
    Add(res,f);
  od;
  for f in res do
    Z1:=Filtered(f.content,x->Number(f.content,y->y=x)=1);
    f.fourierMat:=2^(-QuoInt(Length(Z1)-1,2))*
            List(f.Msharp,x->List(f.Msharp,y->(-1)^Length(Intersection(x,y))));
    f.eigenvalues:=List(f.charNumbers,x->(-1)^QuoInt(DefectSymbol(sym[x])+1,4));
# Now convert Msharp to a pair (x, \chi). Lusztig's recipe: express in the
# basis e_i=z_i+z_{i+1}, identify e1,e3,.. to elts and e2,e4,.. to chars.
# But this is not an isom to (Z/2Z)^r. Needed e.g. to replace elts with
# basis e1,e1+e3,e1+e3+e5... to get a dual basis to e2,e4,...
# In case Dn we work modulo the vector e1+e3+e5+...
    if Length(f.eigenvalues)=1 then f.charLabels:=[""];f.special:=1;
    else f.charLabels:=List(f.Msharp,function(M)local v,D,v1,v2,s;
      v:=List(Z1,z->Number(M,y->y>=z)mod 2);
      D:=Length(v);
      v1:=v{[2,4..D-(D mod 2)]};
      v2:=v{[3,5..D-1+(D mod 2)]};
      if D mod 2=1 then Add(v1,0);fi;
      # v1, v2 is coordinates in (e1,e3,e5,..) and in (e2,e4,..) basis
      v1:=List([1..Length(v2)],i->Sum(v1{[i,i+1]})mod 2);
      # coordinates in e1, e1+e3, e1+e3+e5, ...
      s:="+-";
      return ConcatenationString(s{v2+1},",",s{v1+1});end);
      f.special:=PositionProperty(f.charLabels,x->ForAll(x,y->y in "+,"));
    fi;
 #  if Length(f.eigenvalues)>1 and not 
 #    f.eigenvalues=List(f.charLabels,function(s)local s1,s2;
 #    s1:=Position(s,',');s2:=s{[s1+1..Length(s)]};s1:=s{[1..s1-1]};
 #    return (-1)^Number([1..Length(s1)],i->s1[i]='-' and s2[i]='-');end)
 #  then Error();
 #  fi;
    f.name:=IntListToString(f.content);
    f.perm:=();
    f.size:=Length(f.charNumbers);
    f.operations:=FamilyOps;
  od;
  return res;
end;

# how many lines in the non abelian fourier matrix of g
Nrfourier:=g->Sum(ConjugacyClasses(g),c->
    Length(ConjugacyClasses(Centralizer(g,Representative(c)))));

# compute the non abelian fourier matrix of g
# The result is a record with fields:
#   .x and .chi: together they label lines of the fourier matrix by
# pairs (x,chi): x element of g , and chi character of C_g(x) given
# by its values.
#   .group is the group 
#   .special is the position of the special line (here 1 where (x,chi)=(1,1) is)
#   .eigenvalues are the eigenvalues chi(x)/chi(1)
#   .fourierMat is the Fourier matrix
#   .mellin is such that ApplyFunc(DiagonalMat,M) is the Mellin transform mat
#   then fourierMat^ApplyFunc(DiagonalMat,M)  is a permutation
# fourier(G) computes the matrix T
# fourier(G,1) computes the matrix S=\Delta T (see conv.tex)
fourier:=function(arg)local M,c,classinfo,r,i,res,S,pospair;
  res:=rec(group:=arg[1],lusztig:=IsBound(arg[2]) and arg[2]=1);
  classinfo:=List(ConjugacyClasses(res.group),function(c)local r,t;
    r:=rec(elt:=Representative(c));
    r.centralizer:=Centralizer(res.group,r.elt);
    r.centelms:=List(ConjugacyClasses(r.centralizer),Representative);
    r.ncl:=Length(r.centelms);
    t:=CharTable(r.centralizer);
    r.charNames:=CharNames(r.centralizer);
    r.names:=ClassNamesCharTable(t);
    r.chars:=t.irreducibles;
    r.positionid:=PositionClass(r.centralizer,res.group.identity);
    r.positionself:=PositionClass(r.centralizer,r.elt);
    r.centralizers:=t.centralizers;
    return r;end);
  c:=ClassNamesCharTable(CharTable(res.group));
  for i in [1..Length(c)] do classinfo[i].name:=c[i];od;
  res.classinfo:=classinfo;
  res.xchi:=Concatenation(List([1..Length(classinfo)],i->List(
    [1..classinfo[i].ncl],j->[i,j])));
  res.charLabels:=List(res.xchi,p->SPrint("(",res.classinfo[p[1]].name,",",
    res.classinfo[p[1]].charNames[p[2]],")"));
  res.eigenvalues:=Concatenation(List(res.classinfo,r->List([1..r.ncl],i->
    r.chars[i][r.positionself]/r.chars[i][r.positionid])));
# InfoChevie("#Fourier permutation of the ",n," Mellin basis elements:\n",
#             res.fourierperm,"\n");
  pospair:=function(x,y)local p; # find commuting couple (x,y) in classinfo
    p:=PositionClass(res.group,x);
    return Sum([1..p-1],i->res.classinfo[i].ncl)+PositionClass(
      res.classinfo[p].centralizer,
      y^RepresentativeOperation(res.group,x,res.classinfo[p].elt));
  end;
  res.operations:=FamilyOps;
  res.operations.Print:=function(x)
     if res.lusztig then Print("Lusztig's variant of ");fi;
     Print("fourier(",res.group,")\n");Display(x);end;
  S:=IdentityMat(Length(res.xchi)){Concatenation(List(classinfo,
   r->List(r.centelms,
    function(c)if not res.lusztig then return pospair(c^-1,r.elt);
			    else return pospair(c^-1,r.elt^-1);
	       fi;end)))};
  res.mellin:=ApplyFunc(DiagonalMat,List(res.classinfo,r->
     ComplexConjugate(List(r.chars,
       x->List([1..r.ncl],y->x[y]/r.centralizers[y])))^-1));
  res.mellinLabels:=Concatenation(List(res.classinfo,
    x->List(x.names,y->SPrint("(",x.name,",",y,")"))));
  res.fourierMat:=res.mellin^-1*S*res.mellin;
  res.operations.x:=function() 
    return List(res.xchi,p->res.classinfo[p[1]].elt);end;
  res.operations.chi:=function()
    return Concatenation(List(res.classinfo,x->x.chars));end;
  res.operations.y:=function()
    return Concatenation(List(res.classinfo,x->x.centelms));end;
  res.operations.yLabels:=function()
    return Concatenation(List(res.classinfo,x->x.names));end;
  res.special:=PositionProperty(res.xchi,
    p->res.classinfo[p[1]].elt=res.group.identity and
    ForAll(res.classinfo[p[1]].chars[p[2]],y->y=1));
  return res;
end;

# permutes a family x by permutation p
OnFamily:=function(x,p)local f;
  x:=ShallowCopy(x);
  for f in ["x","chi","charNumbers","eigenvalues","unpdeg","fakdeg",
    "mellinLabels","charLabels"] do
    if IsBound(x.(f)) then x.(f):=Permuted(x.(f),p);fi;
  od;
  for f in ["fourierMat","mellin"] do
    if IsBound(x.(f)) then x.(f):=OnMatrices(x.(f),p);fi;
  od;
  if IsBound(x.fourierperm) then x.fourierperm:=x.fourierperm^(p^-1);fi;
  return x;
end;

GaloisFamily:=function(f,i)
  f:=ShallowCopy(f);
  f.fourierMat:=List(f.fourierMat,x->List(x,y->GaloisCyc(y,i)));
  f.eigenvalues:=List(f.eigenvalues,x->GaloisCyc(x,i));
  return f;
end;

# Michael Cuntz's formula
MQF:=function(g,N)local f,L,Y,Y1,W,S;
  f:=fourier(g);
  L:=[1..Length(f.xchi)];
  Y:=Filtered(L,function(i)local r;r:=f.classinfo[f.xchi[i][1]];
    return ForAll([1..r.ncl],j->r.chars[f.xchi[i][2]][j]=1 or
      not r.centelms[j] in N);end);
  Y1:=Filtered(L,function(i)local e;e:=f.classinfo[f.xchi[i][1]].elt;
    return e=g.identity or not e in N;end);
  W:=List(L,i->ER(Size(Intersection(N,Centralizer(g,f.classinfo[f.xchi[i][1]].elt))))*List(Y,function(j)local p,r;
    r:=f.classinfo[f.xchi[i][1]]; 
    if r.elt in N then
      if i=j then return 1; else return 0;fi;
    else
      if i=j then return -(r.ncl-2)/(r.ncl-1);
      elif r.elt=f.classinfo[f.xchi[j][1]].elt then return 1/(r.ncl-1);
      else return 0;
      fi;
    fi;end));
  S:=List(L,i->List(L,function(j)local p,q,r,s;
   p:=f.xchi[i];q:=f.xchi[j];
   r:=f.classinfo[p[1]]; s:=f.classinfo[q[1]];
   return Sum(Filtered(Elements(g),x->Comm(r.elt,s.elt^(x^-1))=g.identity),
     x->r.chars[p[2]][PositionClass(r.centralizer,s.elt^(x^-1))]*
        s.chars[q[2]][PositionClass(s.centralizer,r.elt^x)]/Size(r.centralizer)
	/Size(s.centralizer));end));
  if S=f.fourierMat then Print("michael's formula for fourierMat agrees\n");fi;
  return f.fourierMat{Y1}{L}*W;
end;
