#############################################################################
##
#A  tbl/weylf4.g              CHEVIE library          Meinolf Geck, Jean Michel
##
#Y  Copyright (C) 1994 - 2012  The CHEVIE Team
##
##  This file contains the irreducible representations of the Hecke algebra
##  H of F_4 (in terms of W-graphs). They have been determined by H. Naruse 
##  in the equal parameter case (private communication, January 1998), 
##  and by M. Geck in  the 2-parameter case (August 1997).
##
##  It also contains information about invariants, unipotent characters, 
##  unipotent classes and the Springer correspondence.
##
CHEVIE.AddData("CartanMat","F4",function(arg)local a,type;
  if Length(arg)=1 then type:=arg[1];else type:=1;fi;
  a:=CHEVIE.RawData("CartanMat","A")(4);a[2][3]:=-type;a[3][2]:=2/a[2][3];
  return a;
end);

CHEVIE.AddData("PrintDiagram","F4",function(indices,title,type)
  Print(title," ",indices[1]," - ",indices[2]);
  if type=1 then Print(" >=> ");
  elif type=ER(2) then Print(" = ");
  else Print(" ?=? ");
  fi;
  Print(indices[3]," - ",indices[4],"\n");
end);

CHEVIE.AddData("ReflectionName","F4",function(arg)local i,opt,type;
  if Length(arg)=1 then return "F(?)4"; fi;
  type:=arg[1]; opt:=arg[2];
  if type=1 then 
    if IsBound(opt.TeX) then return "F_4";
    elif IsBound(opt.arg) then return "\"F\",4";
    else return "F4";fi;
  elif type=ER(2) then 
    if IsBound(opt.TeX) then return "F_{\\hbox{sym}4}";
    elif IsBound(opt.arg) then return "\"Fsym\",4";
    else return "Fsym4";fi;
  elif IsBound(opt.TeX) then return SPrint("F(",Format(type^2/2,opt),")_4");
  elif IsBound(opt.arg) then return SPrint("\"F\",",4,",",Format(type^2/2,opt));
  else return SPrint("F(",Format(type^2/2),")4");
  fi;
end);

# as given in Bourbaki
CHEVIE.AddData("GeneratingRoots", "F4",
   [[0,1,-1,0],[0,0,1,-1],[0,0,0,1],[1,-1,-1,-1]/2]);

CHEVIE.AddData("HyperplaneRepresentatives","F4",[1,3]);

CHEVIE.AddData("ParabolicRepresentatives", "F4", 
[[],[1],[1,2],[1,2,3],[1,2,3,4],[1,2,4],[1,3],[1,3,4],[2,3],[2,3,4],[3],[3,4]]);

CHEVIE.AddData("FundamentalGroup","F4",[]);
CHEVIE.AddData("CenterSimplyConnected","F4",[]);

CHEVIE.AddData("Size", "F4", 1152);

CHEVIE.AddData("ReflectionDegrees","F4",[2,6,8,12]);

CHEVIE.AddData("NrConjugacyClasses", "F4", 25);

CHEVIE.AddData("ClassInfo","F4",function()local res;
# representatives are "very good" see Geck-Michel
  res:=rec(classtext:=List([[],[0,0,0,0,0,0],[2,3,2,3],[2,1],[0,2,3,2,3,4,3],
  [0,0,0],[4,3],[1,2,1,3,2,3,0],[0,0,0,0],[0,0],[0],[1],[2,3,2,3,4,3,2,3,4],
  [1,4,3],[4,3,2],[2,3,2,1,3],[3],[1,2,1,3,2,1,3,2,3],[2,1,4],[3,2,1],
  [2,4,3,2,3],[1,3],[3,2],[0,0,0,2,3],[0,2,3]],x->Replace(x,[0],[1..4])),
  classnames:=
  ["A_0","4A_1","2A_1","A_2","D_4","D_4(a_1)","\\tilde A_2","C_3+A_1",
  "A_2+\\tilde A_2", "F_4(a_1)", "F_4", "A_1", "3A_1", "\\tilde A_2+A_1", "C_3",
  "A_3", "\\tilde A_1", "2A_1+\\tilde A_1", "A_2+\\tilde A_1", "B_3", "B_2+A_1",
  "A_1+\\tilde A_1", "B_2", "A_3+\\tilde A_1", "B_4"],
  classes:=[1,1,18,32,32,12,32,32,16,16,96,12,12,96,96,72,12,12,96,96,72,72,36,
    36,144],
  orders:=[1,2,2,3,6,4,3,6,3,6,12,2,2,6,6,4,2,2,6,6,4,2,4,4,8]);
  res.classparams:=res.classnames;
  return res;
end);

CHEVIE.AddData("CharInfo","F4",function()local res;
  res:=rec(charparams:=
  [[1,0],[1,12,2],[1,12,1],[1,24],[2,4,2],[2,16,1],[2,4,1],[2,16,2],[4,8],
   [9,2],[9,6,2],[9,6,1],[9,10],[6,6,1],[6,6,2],[12,4],[4,1],[4,7,2],[4,7,1],
   [4,13],[8,3,2],[8,9,1],[8,3,1],[8,9,2],[16,5]],
# indices for the names of the characters in Kondo's table,
# see [Carter-book,p.413]:
  kondo:=[ "1_1","1_2","1_3","1_4","2_1",
  "2_2","2_3","2_4","4","9_1","9_2","9_3","9_4","6_1","6_2","12","4_1",
  "4_2","4_3","4_4","8_1", "8_2","8_3","8_4","16"],
  extRefl:=[1,17,15,20,4],
  a:=[0,4,4,24,1,13,1,13,4,2,4,4,10,4,4,4,1,4,4,13,3,9,3,9,4],
  A:=[0,20,20,24,11,23,11,23,20,14,20,20,22,20,20,20,11,20,20,23,15,21,15,21,20]);
  res.b:=List(res.charparams,x->x[2]);
  return res;
  end
);

CHEVIE.AddData("cyclestructure","F4",[[[],[]],[[12],[12]],
  [[10],[10]],[[,8],[,6]],[[,,,,4],[3,,,,3]],[[,,6],[,,6]],
  [[,6],[,8]],[[3,,,,3],[,,,,4]],[[,8],[,8]],
  [[,,,,4],[,,,,4]],[[,,,,,,,,,,2],[,,,,,,,,,,2]],
  [[9],[6]],[[11],[12]],[[3,2,,,2],[,4,,,2]],
  [[2,,,,3],[,,,,4]],[[2,,5],[1,,5]],[[6],[9]],
  [[12],[11]],[[,4,,,2],[3,2,,,2]],
  [[,,,,4],[2,,,,3]],[[1,,5],[2,,5]],[[11],[11]],
  [[,,5],[,,5]],[[2,,5],[2,,5]], [[,,,,,,3],[,,,,,,3]]]);

CHEVIE.AddData("generators","F4",
  [(1,25)(2,5)(6,8)(9,11)(10,12)(13,15)(16,18)(23,24)(26,29)(30,32)
  (33,35)(34,36)(37,39)(40,42)(47,48),(1,5)(2,26)(3,6)(7,10)(11,14)
  (15,17)(18,20)(22,23)(25,29)(27,30)(31,34)(35,38)(39,41)(42,44)(46,47),
  (2,9)(3,27)(4,7)(5,11)(10,13)(12,15)(17,19)(20,22)(26,33)(28,31)
  (29,35)(34,37)(36,39)(41,43)(44,46),(3,7)(4,28)(6,10)(8,12)(9,16)
  (11,18)(14,20)(19,21)(27,31)(30,34)(32,36)(33,40)(35,42)(38,44)(43,45)]);

CHEVIE.AddData("orbits","F4",[ [ 1, 25, 5, 29, 2, 11, 26, 35,
  9, 14, 18, 33, 38, 42, 16, 20, 40, 44, 22, 46, 23, 47, 24, 48 ],
  [ 3, 6, 27, 7, 8, 10, 30, 31, 4, 12, 13, 32, 34, 28, 15, 36, 37, 17, 39,
  19, 41, 21, 43, 45 ] ]);

CHEVIE.AddData("PowerMaps","F4",[,
  [1,1,1,4,4,2,7,7,9,9,10,1,1,7,7,3,1,1,4,4,3,1,3,3,6],
  [1,2,3,1,2,6,1,2,1,2,6,12,13,12,13,16,17,18,17,18,21,22,23,24,25]]);

# description of fake degrees by powers of q
CHEVIE.AddData("factors","F4",
[[1,0],[1,12],[1,12],[1,24],[1,4,1,8],[1,16,1,20],[1,4,1,8],[1,16,1,20],[1,8,
2,12,1,16],[1,2,1,4,2,6,1,8,2,10,1,12,1,14],[1,6,1,8,2,10,1,12,2,14,1,16,1,
18],[1,6,1,8,2,10,1,12,2,14,1,16,1,18],[1,10,1,12,2,14,1,16,2,18,1,20,1,22],
[1,6,1,8,2,12,1,16,1,18],[1,6,1,8,2,12,1,16,1,18],[1,4,2,8,2,10,2,12,2,14,2,
16,1,20],[1,1,1,5,1,7,1,11],[1,7,1,11,1,13,1,17],[1,7,1,11,1,13,1,17],[1,13,1,
17,1,19,1,23],[1,3,1,5,1,7,2,9,1,11,1,13,1,15],[1,9,1,11,1,13,2,15,1,17,1,19,
1,21],[1,3,1,5,1,7,2,9,1,11,1,13,1,15],[1,9,1,11,1,13,2,15,1,17,1,19,1,21],[1,
5,2,7,2,9,3,11,3,13,2,15,2,17,1,19]]);

#############################################################################
##
#F  ClassParameter( <w> )  . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type F_4  as word in  standard
##  generators, ClassParameter returns the classparam of its conjugacy class.
##
CHEVIE.AddData("ClassParameter","F4",function(w)local x;
  if w=[] then return " ";fi;
  x:=Product(CHEVIE.RawData("generators","F4"){w});
  return CHEVIE.RawData("classparams","F4")[
                              Position(CHEVIE.RawData("cyclestructure","F4"),
    [CycleStructurePerm(RestrictedPerm(x,CHEVIE.RawData("orbits","F4")[1])),
     CycleStructurePerm(RestrictedPerm(x,CHEVIE.RawData("orbits","F4")[2]))])];
end);

###########################################################################
##
#F  HeckeCharTable( <para> )  . . . . . . . . . . . . . . . . . . .
##  . . . . . . . . . . . . character table of the Hecke algebra of type F4
##
##  HeckeCharTable returns the character table of the Hecke algebra
##  of type F4 with  parameters  given  by  a  list  <para>.
##
CHEVIE.AddData("HeckeCharTable","F4",function(param,sqrtparam)
  local u,v,c,tbl,f2,f4,f6,f8,f11,f13,f18,f20,f22,f24,dual;
  u:=-param[1][1]/param[1][2];v:=-param[3][1]/param[3][2];
  tbl:=rec(
  identifier := "H(F4)",
  text := "origin: Meinolf Geck, April 1992",
  parameter := [ u ,u ,v ,v ],
  size := 1152,
  powermap:=CHEVIE.RawData("PowerMaps","F4"));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","F4")());
  tbl.centralizers:=List(tbl.classes,x->tbl.size/x);
  dual:=f->Zip(f(u^-1,v^-1),tbl.classtext,function(a,w)
    return a*(-u)^Number(w,j->j in [1,2])*(-v)^Number(w,j->j in [3,4]);end);
  f4:=function(u,v)
    return [1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1];end;
  f2:=function(u,v)return [1,u^12,u^2,u^2,u^4,u^6,1,u^6,u^8,u^4,u^2,u,u^3,
   u,u,u^3,-1,-u^6,-u^2,-u^2,-u^2,-u,-u,-u^7,-u^3];end;
  f6:=function(u,v)return [2,2*v^6,v^2+1,2,2*v^3,2*v^3,-v,-v^2,-v^4,-v^2,-v,
    -2,-2*v^3,v,v,-1-v^2,v-1,-1+v^3,v-1,v-1,0,1-v,1-v,v^3-v^4,0];end;
  f8:=function(u,v)return [2,2*u^6,u^2+1,-u,-u^2,2*u^3,2,2*u^3,-u^4,-u^2,-u,
    -1+u,u^3-1,-1+u,-1+u,0,-2,-2*u^3,u,u,-u^2-1,-u+1,-u+1,-u^4+u^3,0];end;
  f11:=function(u,v)return [9,9*v^4*u^8,v^2*u^2+1-4*u*v+3*u^2,-3*u+3*u^2,0,
   -3*v^2*u^4,3-3*v,0,0,0,0,6*u-3,-3*v^2*u^2+2*v^3*u^3+3*u*v^2+u^3,
   2*u-2*u*v-1+v,-u*v+u,u^3-2*u^2*v,-6+3*v,3*u^4*v-3*v^2*u^4-u^6-2*u^3,
   u^2*v-2*u^2-u*v+2*u,u-u^2,-u^2+2*u*v,-4*u+2*u*v+2-v,-3*u+u*v+1,
   -v^3*u^5+v^2*u^5-v^2*u^4,u^2*v];end;
  f13:=function(u,v) return [9,9*v^4*u^4,3-4*u*v+u^2+v^2,-3*u+3,0,-3*v^2*u^2,
    3-3*v,0,0,0,0,-6+3*u,-1+3*u*v^2-3*v^2*u^2-2*v^3,-u*v+u-2+2*v,v-1,-1+2*u*v,
    -6+3*v,-1+3*u^2*v-2*u^3-3*v^2*u^2,-u*v+2*u+v-2,-1+u,-1+2*u*v,4-2*v+u*v-2*u,
    3-v-u,v^3*u^2-v^2*u^2+v^2*u^3,-u*v];end;
  f18:=function(u,v)return [4,-4*v^3*u^9,2*u^2-2*u*v,2*u^2-u,u^3*v-2*v^2*u^3,
    0,-v+2,-2*u^4*v+u^5*v,-2*v^2*u^6,2*u^3*v,0,3*u-1,u^3-3*v^2*u^2,-u*v+u-1,u,
    u^3-u^2*v,-3+v,-u^6+3*u^4*v,u^2*v-u^2+u,-u^2,-u^2+u*v,u*v-2*u+1,-2*u,
    2*v^2*u^5,0];end;
  f20:=function(u,v)return [4,-4*v^3*u^3,2-2*u*v,2-u,-2*u*v^2+u*v,0,-v+2,
    u*v-2*u^2*v,-2*v^2*u^2,2*u*v,0,-3+u,3*u*v^2-1,v-1+u,-1,-1+u*v,-3+v,
    -1+3*u^2*v,v-1+u,-1,-1+u*v,2-v-u,2,-2*v^2*u^2,0];end;
  f22:=function(u,v)return [8,-8*v^6*u^3,2*v^2-4*u*v+2,4-2*u,-v^4*u-u*v^2,0,
   -3*v+1+v^2,2*v^2*u^2-u*v^2,2*v^4*u^2,-2*u*v^2,0,-6+2*u,
   -2*v^3+3*u*v^2+3*v^4*u,-u*v-1-v^2+2*v,v,2*u*v-1-v^2,4*v-4,
   v^3-3*v^2*u^2+3*u^2*v-1,-u*v+u-2+2*v,v-1,-u*v^2+u*v,u*v-u-3*v+3,2-2*v,0,0];
   end;
  f24:=function(u,v)return [8,-8*v^3*u^6,2*u^2-4*u*v+2,-3*u+1+u^2,
   -u^2*v+2*v^2*u^2,0,-2*v+4,-u^4*v-u^2*v,2*v^2*u^4,-2*u^2*v,0,-4+4*u,
   u^3-3*v^2*u^2+3*u*v^2-1,-u*v+2*u+v-2,-1+u,u*v-u^2*v,-6+2*v,
   -2*u^3+3*u^2*v+3*u^4*v,-u^2-u*v+2*u-1,u,-u^2+2*u*v-1,-3*u+u*v-v+3,
   -2*u+2,0,0];end;
  tbl.irreducibles := [dual(f4),f2(u,v),dual(f2),f4(u,v),
    dual(f6),f6(u,v),dual(f8),f8(u,v),
  [4,4*u^6*v^6,v^2+v^2*u^2+u^2+1,-2*u,-2*v^3*u^2,4*v^3*u^3,-2*v,-2*v^2*u^3,
   v^4*u^4,v^2*u^2,u*v,2*u-2,-2*v^3+2*v^3*u^3,v-u*v,v-u*v,0,2*v-2,
   2*v^3*u^3-2*u^3,-u*v+u,-u*v+u,0,u*v-v+1-u,u*v-v+1-u,
   -v^4*u^3+v^4*u^4-v^3*u^4+v^3*u^3,0],
  dual(f13),f11(u,v),dual(f11),f13(u,v),
  [6,6*u^6*v^6,u^2-4*u*v+v^2,1-2*u+u^2,v^2*u^2+v^4*u^2-2*v^3*u^2,2*v^3*u^3,
   1+v^2-2*v,v^2*u^2-2*v^2*u^3+v^2*u^4,3*v^4*u^4,3*v^2*u^2,-u*v,-3+3*u,
   -3*v^2*u^2+3*v^4*u,u*v^2-u*v+v-1,0,u*v-u^2*v,-3+3*v,-3*v^2*u^2+3*u^4*v,
   u^2*v-u*v+u-1,0,-u*v^2+u*v,-u+2*u*v-v+2,-v-u,-v^4*u^3-v^3*u^4,0],
  [6,6*u^6*v^6,-4*u*v+v^2*u^2+1,1-2*u+u^2,v^2*u^2+v^4*u^2-2*v^3*u^2,2*v^3*u^3,
   1+v^2-2*v,v^2*u^2-2*v^2*u^3+v^2*u^4,3*v^4*u^4,3*v^2*u^2,-u*v,-3+3*u,
   3*u*v^2-3*v^4*u^2,-v^2+v-u*v+u,0,u*v-u^2*v,-3+3*v,-3*v^2*u^4+3*u^2*v,
   -u^2-u*v+u+v,0,-u*v^2+u*v,-2*u+u*v-2*v+1,u*v+1,v^4*u^4+v^3*u^3,0],
  [12,12*u^6*v^6,1+v^2*u^2-8*u*v+u^2+v^2,2*u^2-4*u+2,2*v^3*u^2-v^4*u^2-v^2*u^2,
   4*v^3*u^3,2-4*v+2*v^2,2*v^2*u^3-v^2*u^4-v^2*u^2,-3*v^4*u^4,-3*v^2*u^2,u*v,
   -6+6*u,-3*v^2*u^2+3*u*v^2-3*v^4*u^2+3*v^4*u,-2*u*v+u+u*v^2-v^2+2*v-1,0,
   2*u*v-2*u^2*v,-6+6*v,-3*v^2*u^2+3*u^2*v-3*v^2*u^4+3*u^4*v,
   u^2*v-u^2-2*u*v+2*u+v-1,0,-2*u*v^2+2*u*v,3-3*u-3*v+3*u*v,u*v-v+1-u,
   -v^4*u^3+v^4*u^4-v^3*u^4+v^3*u^3,0],
  dual(f20),f18(u,v),dual(f18),f20(u,v),dual(f22),f22(u,v),dual(f24),f24(u,v),
  [16,-16*u^6*v^6,2+2*v^2*u^2-8*u*v+2*v^2+2*u^2,-6*u+2*u^2+2,v^4*u^2+v^2*u^2,0,
   2*v^2-6*v+2,v^2*u^4+v^2*u^2,-2*v^4*u^4,2*v^2*u^2,0,-8+8*u,
   v^2*(u-1)*(2*u^2*v-3*u-3*u*v^2+2*u*v+2*v),u*v^2-3*u*v-v^2+3*v-1+u,v-u*v,
   2*u*v-2*u^2*v,-8+8*v,-u^2*(v-1)*(-2*u*v^2+3*u^2*v+3*v-2*u*v-2*u),
   (u^2-3*u+1)*(v-1),-u*v+u,-2*u*v*(v-1),4*(v-1)*(u-1),2*(v-1)*(u-1),0,0]]*u^0*v^0;
  tbl.irredinfo:=List(CHEVIE.RawData("CharInfo","F4")().charparams,x->
    rec(charparam:=x,charname:=CHEVIE.RawData("CharName","F4")(x,rec())));
  tbl:=CHEVIE.compat.MakeCharacterTable(tbl);
  CHEVIE.compat.AdjustHeckeCharTable(tbl,param);
  return tbl;
end);

#############################################################################
##
#F  PoincarePolynomial(u,v) . . . . Poincare Polynomial for F4
##
##  Same as Schur element for the identity character.
##
CHEVIE.AddData("PoincarePolynomial","F4",function(param)
  return CHEVIE.RawData("SchurElement","F4")([1,0],param,false);
end);

# The data below was computed by Maria Chlouveraki
CHEVIE.AddData("SchurModels","F4",rec(
f1_0:=rec(
 vcyc:=[[[0,0,1,-1],1],[[0,0,1,-1],6],[[1,-1,0,0],1],[[1,-1,0,0],6],
  [[1,-1,2,-2],1],[[1,-1,1,-1],6],[[2,-2,1,-1],1],[[1,-1,1,-1],4],
  [[1,-1,1,-1],2],[[1,-1,1,-1],2]]),
f2_4s:=rec(coeff:=-1,factor:=[0,0,-1,1],
 vcyc:=[[[0,0,1,-1],6],[[1,-1,0,0],3],[[1,-1,0,0],6],[[1,-1,0,0],1],
  [[1,-1,0,0],1],[[2,-2,1,-1],1],[[1,-1,1,-1],2],[[1,-1,-1,1],2],
  [[2,-2,-1,1],1]]),
f4_8:=rec(coeff:=2,
 vcyc:=[[[0,0,1,-1],6],[[-1,1,0,0],6],[[1,-1,-1,1],2],[[1,-1,-1,1],2],
  [[-1,1,-1,1],2],[[1,-1,1,-1],2]]),
f9_2:=rec(
 vcyc:=[[[0,0,1,-1],1],[[1,-1,0,0],1],[[1,-1,-2,2],1],[[1,-1,1,-1],4],
  [[-2,2,1,-1],1],[[1,-1,1,-1],2],[[1,-1,1,-1],2]]),
f6_6s:=rec(coeff:=3,
 vcyc:=[[[0,0,-1,1],1],[[0,0,-1,1],1],[[-1,1,0,0],1],[[-1,1,0,0],1],
  [[1,-1,1,-1],6],[[1,-1,-1,1],2],[[-1,1,1,-1],2]]),
f12_4:=rec(coeff:=6,
 vcyc:=[[[0,0,1,-1],3],[[-1,1,0,0],3],[[1,-1,-1,1],2],[[1,-1,-1,1],2],
  [[1,-1,1,-1],2],[[-1,1,-1,1],2]]),
f4_1:=rec(
 vcyc:=[[[0,0,1,-1],1],[[0,0,1,-1],6],[[-1,1,0,0],1],[[1,-1,0,0],6],
  [[1,-1,-1,1],2],[[1,-1,1,-1],6],[[1,-1,1,-1],2],[[1,-1,1,-1],2]]),
f8_3s:=rec(coeff:=-1,factor:=[0,0,-1,1],
 vcyc:=[[[0,0,1,-1],6],[[1,-1,0,0],6],[[1,-1,0,0],1],[[-1,1,0,0],1],
  [[1,-1,0,0],3],[[1,-1,-2,2],1],[[1,-1,2,-2],1]]),
f16_5:=rec(coeff:=2,factor:=[-1,1,-1,1],
 vcyc:=[[[0,0,1,-1],6],[[-1,1,0,0],6],[[1,-1,-1,1],4],[[1,-1,1,-1],4]])));

CHEVIE.AddData("SchurData","F4",[
  rec(name:="f1_0",order:=[1,2,3,4]),  rec(name:="f1_0",order:=[1,2,4,3]), 
  rec(name:="f1_0",order:=[2,1,3,4]),  rec(name:="f1_0",order:=[2,1,4,3]), #4
  rec(name:="f2_4s",order:=[1,2,3,4]), rec(name:="f2_4s",order:=[2,1,3,4]), 
  rec(name:="f2_4s",order:=[3,4,1,2]), rec(name:="f2_4s",order:=[4,3,1,2]), #8 
  rec(name:="f4_8",order:=[1,2,3,4]),  #9
  rec(name:="f9_2",order:=[1,2,3,4]),  rec(name:="f9_2",order:=[1,2,4,3]), 
  rec(name:="f9_2",order:=[2,1,3,4]),  rec(name:="f9_2",order:=[2,1,4,3]), #13
  rec(name:="f6_6s",order:=[1,2,4,3]), rec(name:="f6_6s",order:=[1,2,3,4]),  #15
  rec(name:="f12_4",order:=[1,2,3,4]),
  rec(name:="f4_1",order:=[1,2,3,4]),  rec(name:="f4_1",order:=[1,2,4,3]), 
  rec(name:="f4_1",order:=[2,1,3,4]),  rec(name:="f4_1",order:=[2,1,4,3]), #20
  rec(name:="f8_3s",order:=[1,2,3,4]), rec(name:="f8_3s",order:=[2,1,3,4]), 
  rec(name:="f8_3s",order:=[3,4,1,2]), rec(name:="f8_3s",order:=[4,3,1,2]), #24
  rec(name:="f16_5",order:=[1,2,3,4])]); 

CHEVIE.AddData("Representation","F4",function(i)return CHEVIE.RawData(
  "HeckeRepresentation","F4")(List([1..4],x->[1,-1]),[1,1,1,1],i);end);

# The following W-graphs have been computed by Naruse 
# (private communication, Jan 1998). They are F-equivariant for 2F4
# for F-invariant representations.
CHEVIE.AddData("WGraphs","F4",
[[[[]],[]],[[[3,4]],[]],2,1,[[[3],[4]],[[1,[[1,2]]]]],5,
[[[1],[2]],[[1,[[1,2]]]]],7,[[[1,3],[1,4],[2,3],[2,4]],[[1,[[1,2,3],[2,4],[3,
4]]]]],[[[1],[1,3],[1,4],[2],1,[2,4],[3],1,[4]],[[1,[[1,2,5],[2,3,4,8],[3,6],
[4,6,7],[5,8],[6,8,9],[7,9]]]]],[[[1,3],[1,3,4],[1,4],[2,3],[2,4],1,[3],[3,4],
1],[[[2,1],[[5,8]]],[-2,[[2,9]]],[1,[[1,3,4],[2,3,6,8],[3,5],[4,5],[6,7],[7,8,
9]]],[2,[[4,7]]]]],11,10,[[[1,2,4],[1,3],[1,3,4],[2],[2,4],[3]],
[[1,[[1,2,5],[2,3,4,6],[3,5],[4,5],[5,6]]]]],[[[1,2],[1,3],[1,4],[2,3],[2,4],
[3,4]],[[[2,1],[[1,2],[5,6]]],[1,[[2,3,4],[3,5],[4,5]]]]],
[[[1,2],[1,2,4],[1,3],1,[1,3,4],[1,4],[2],[2,3],[2,4],1,[3],[3,4]],
[[[1,2],[[1,4]]],[[2,1],[[9,12]]],[1,[[1,7],[2,3],[3,7],[4,6,8],[5,10],[6,9],
[8,9],[10,11],[11,12]]],[2,[[2,10],[3,5,11],[7,8,10],[8,11]]],[3,[[1,2],[2,6],
[5,6,12]]]]],[[[1],[2],[3],[4]],[[[-1,-2],[[2,3]]],[-1,[[1,2],[3,4]]]]],[[[1,
3,4],[2,4],[3],[3,4]],[[-1,[[3,4]]],[1,[[1,2,4],[2,3]]]]],18,17,
[[[1,3],[1,4],[2],[2,4],[3],1,[3,4],[4]],[[1,[[1,2,3,5],[2,4],[3,4,6],[4,5,7],
[6,7,8]]]]],21,[[[1],[1,2],[1,3],[1,4],[2],1,[2,4],[3]],[[1,[[1,6],[2,3,6],[3,4,
5,8],[4,7],[5,7],[6,8],[7,8]]]]],23,[[[1,2],[1,2,
4],[1,3],2,[1,3,4],[1,4],1,[2],[2,3],1,[2,4],2,[3],[3,4]],[[[1,2],[[13,16]]],
[1,[[1,2,4,5,9],[2,3,7,8,14],[3,9,15],[4,7,10],[5,8,11],[6,14,16],[7,12],[8,
13],[9,10,11],[10,12],[11,13,15],[14,15],[15,16]]],[2,[[3,6],[6,8],[9,14]]]]]]);

CHEVIE.AddData("WGraph","F4",function(i)local gr;
 gr:=CHEVIE.RawData("WGraphs","F4");
 if IsInt(gr[i]) then return DualWGraph(4,gr[gr[i]]); else return gr[i]; fi;
end);

CHEVIE.AddData("HeckeRepresentation","F4",function(param,sqrtparam,i)
  local u,v,r;
  u:=-param[1][1]/param[1][2];v:=-param[3][1]/param[3][2];
  if not IsBound(sqrtparam[1]) then 
       u:=GetRoot(u,2,"Representation(Hecke(F4),[",i,"])");
  else u:=sqrtparam[1];
  fi;
  if not IsBound(sqrtparam[3]) then 
       v:=GetRoot(v,2,"Representation(Hecke(F4),[",i,"])");
  else v:=sqrtparam[3];
  fi;
  if u=v then 
    return -param[1][2]*WGraphToRepresentation(4,
      CHEVIE.RawData("WGraph","F4")(i),v);
  else
r:=[
[[[u^2]], [[u^2]], [[v^2]], [[v^2]]],
[[[u^2]], [[u^2]], [[-1]], [[-1]]],
[[[-1]], [[-1]], [[v^2]], [[v^2]]],
[[[-1]], [[-1]], [[-1]], [[-1]]],
[[[u^2, 0], [0, u^2]], [[u^2, 0], [0, u^2]],
 [[-1, 0], [v, v^2]], [[v^2, v], [0, -1]]],
[[[-1, 0], [0, -1]], [[-1, 0], [0, -1]],
 [[-1, 0], [v, v^2]], [[v^2, v], [0, -1]]],
[[[-1, 0], [u, u^2]], [[u^2, u], [0, -1]],
 [[v^2, 0], [0, v^2]], [[v^2, 0], [0, v^2]]],
[[[-1, 0], [u, u^2]], [[u^2, u], [0, -1]],
 [[-1, 0], [0, -1]], [[-1, 0], [0, -1]]],
[[[-1, 0, 0, 0], [u, u^2, 0, 0], [0, 0, -1, 0], [0, 0, u, u^2]],
 [[u^2, u, 0, 0], [0, -1, 0, 0], [0, 0, u^2, u], [0, 0, 0, -1]],
 [[-1, 0, 0, 0], [0, -1, 0, 0], [v, 0, v^2, 0], [0, v, 0, v^2]],
 [[v^2, 0, v, 0], [0, v^2, 0, v], [0, 0, -1, 0], [0, 0, 0, -1]]],
[[[u^2, 0, u, 0, 0, 0, 0, 0, 0], [ 0, u^2, 0, 0, u, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0], [0, 0, u, u^2, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0], [0, 0, 0, 0, u, u^2, 0, 0, 0],
  [0, 0, u, 0, 0, 0, u^2, 0, 0], [0, 0, 0, 0, 0, 0, 0, u^2, u],
  [0, 0, 0, 0, 0, 0, 0, 0, -1]],
 [[u^2, 0, 0, 0, 0, 0, 0, 0, 0], [0, u^2, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, u^2, u, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, u^2, u, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, u^2, u, 0], [0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 0, 0, 0, 0, 0, 0, u, u^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [v, v^2, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0],
  [1/u^2*v^2 +u^2, 0, 1/u*v^2+u, v^2, 0, 0, 0, 0, 0],
  [0, 0, v, 0, v^2, 0, 0, 0, 0], [0, 0, 0, 0, 0, v^2, v, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0], [0, 0, 0, 0, 0, 0, 1/u*v^2+u, v^2, 0],
  [0, 0, 1/u*v^2+u, 0, 0, 0, 0, 0, v^2]],
 [[v^2, v, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, v^2, 0, v, 0, 0, 0, 0], [0, 0, 0, v^2, 0, v, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, v, v^2, 0, 0], [0, 0, 0, 0, 0, (-u-1/u)*v, 0, v^2, 0],
  [0, 0, 0, 0, (-u-1/u)*v, 0, 0, 0, v^2]]],
[[[u^2, u, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, u, u^2, 0, 0, 0, 0, 0, 0], [0, 0, 0, u^2, 0, 0, 0, 0, 0],
  [0, u, 0, 0, u^2, 0, 0, 0, 0], [0, 0, 0, 0, 0, u^2, 0, u, 0],
  [0, 0, 0, 0, 0, 0, u^2, 0, u], [0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, -1 ]],
 [[u^2, 0, 0, 0, 0, 0, 0, 0, 0], [0, u^2, u, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0], [0, 0, 0, u^2, 0, u, 0, 0, 0],
  [0, 0, 0, 0, u^2, 0, u, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0], [0, 0, 0, 0, 0, u, 0, u^2, 0],
  [0, 0, 0, 0, 0, 0, u, 0, u^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [1/u^2*v^2+u^2, 1/u*v^2+u, v^2, v, 0, 0, 0, 0, 0 ],
  [0, 0, 0, -1, 0, 0, 0, 0, 0], [0, 0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 0, 0, 1/u*v^2+u, v, v^2, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, -1, 0], [0, 1/u*v^2+u, 0, 0, 0, 0, 0, v, v^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0],
  [(u^2+1/u^2)*v, (u+1/u)*v, v, v^2, v, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0], [0, 0, 0, 0, 0, v^2, v, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0], [0, 0, 0, 0, 0, 0, 0, v^2, v],
  [0, 0 , 0, 0, 0, 0, 0, 0, -1]]],
[[[u^2, 0, u, 0, 0, 0, 0, 0, 0], [0, u^2, 0, 0, u, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, 0 , 0, 0, -1, 0, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0], [0, 0, 0, u, 0, 0, u, u^2, u],
  [0, 0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [u, 0, u^2, u, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, u, 0, 0, u^2, u, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, u^2, u, 0], [0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [v, v^2, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0], [0, 0, 1/u*v^2+u, v^2, 0, 0, 0, 0, 0],
  [0, 0, v, 0, v^2, 0, 0, 0, 0], [0, 0, 0, 0, 0, v^2, v, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0], [1/u*v^2+u, 0, 0, 0, 0, 0, 1/u*v^2+u, v^2, 0],
  [0, 0, 0, 0, 0, 0, -1/u^2*v^2-u^2, 0, v^2]],
 [[v^2, v, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, v^2, 0, v, 0, 0, 0, 0], [0, 0, 0, v^2, 0, v, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, v, v^2, 0, 0], [0, 0, 0, 0, 0, (-u-1/u)*v, 0, v^2, 0],
  [0, 0, 0, 0, 0, (u^2+1/u^2)*v, 0, 0, v^2]]],
[[[u^2, u, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, 0, 0, u, u^2, 0, 0, u, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, u, 0, 0, u, u^2, 0, u], [0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [u, u^2, u, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0], [0, 0, 0, u^2, u, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0], [0, 0, 0, 0, 0, u^2, u, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0], [0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 1/u*v^2+u, v^2, v, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [1/u*v^2+u, 0, 0, 0, v, 1/u*v^2+u, v^2, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, -1, 0], [0, 0, 0, 0, 0, -1/u^2*v^2-u^2, 0, v, v^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0], [0, (u+1/u)*v, v, v^2, 0, v, 0, 0, 0],
  [(u+1/u)*v, 0, 0, 0, v^2, 0, v, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0], [0, 0, 0, 0, 0, 0, 0, v^2, v],
  [0, 0, 0, 0, 0, 0, 0, 0, -1]]],
[[[-1, 0, 0, 0, 0, 0], [u, u^2, 0, u, 0, 0], [0, 0, u^2, 0, u, 0],
  [0, 0, 0, -1, 0, 0], [0, 0, 0, 0, -1, 0], [0, 0, 0, 0, u, u^2]],
 [[u^2, u, 0, 0, 0, 0], [ 0, -1, 0, 0, 0, 0], [0, 0, u^2, 0, 0, 0],
  [0, 0, 0, -1, 0, 0], [0, 0, 0, 0, u^2, u], [0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0], [1/u*v^2+u, v^2, v, 0, 0, 0], [0, 0, -1, 0, 0, 0],
  [-1/u^2*v^2-u^2, 0, 0, v^2, v, 0], [0, 0, 0, 0, -1, 0],
  [0, 0, 1/u^2*v^2+u^2, 0, 1/u*v^2+u, v^2]],
 [[-1, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0], [(u+1/u)*v, v, v^2, 0, 0, 0],
  [0, 0, 0, -1, 0, 0], [(-u^2-1-1/u^2)*v, 0, 0, v, v^2, 0],
  [0, (-u^2-1-1/u^2)*v, 0, (-u-1/u)*v, 0, v^2]]],
[[[u^2, 0, 0, 0, 0, 0], [0, u^2, u, 0, 0, 0], [0, 0, -1, 0, 0, 0],
  [0, 0, 0, u^2, u, 0], [0, 0, 0, 0, -1, 0], [0, 0, 0, 0, 0, -1]],
 [[u^2, 0, 0, -u, 0, 0], [0, -1, 0, 0, 0, 0], [0, u, u^2, 0, 0, u],
  [0, 0, 0, -1, 0, 0], [0, 0, 0, u, u^2, 0], [0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0], [0, 0, -1, 0, 0, 0],
  [-1/u*v^2-u, v, 0, v^2, 0, 0], [0, 0, v, 0, v^2, 0],
  [0, 0, 1/u*v^2+u, 0, 0, v^2]],
 [[-1, 0, 0, 0, 0, 0], [0, v^2, 0, v, 0, 0], [0, 0, v^2, 0, v, 0],
  [0, 0, 0, -1, 0, 0], [0, 0, 0, 0, -1, 0], [0, 0, 0, 0, 0, v^2]]],
[[[u^2, 0, 0, u, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, u^2, 0, 0, u, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, u^2, 0, 0, 0, 0, u, 0, 0, 0, 0],
  [0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, u, 0, u^2, 0, 0, 0, u, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, u^2, 0, u, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 0, 0, 0, 0, 0, 3*u, 0, 0, 0, u, u^2]],
 [[u^2, 0, u, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, u^2, 0, u, 0, 0, 0, 0, 0, 0],
  [0, u, 0, 0, u^2, 0, u, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, 0, u, 0, 0, 0, 0, u^2, 0, u, 0, 0],
  [0, 3*u, 0, 0, 0, 0, 0, 0, u^2, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u^2, u],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [1/u*v^2+u, v, v^2, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 1/u*v^2+u, 0, v^2, 0, 0, v, 0, 0, 0],
  [0, 0, 0, 0, 1/u*v^2+u, 0, v^2, 0, 0, 0, 0, 0],
  [0, 0, 0, 1/u*v^2+u, v, 0, 0, v^2, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, -1/u^2*v^2-u^2, 0, 0, 0, 0, 0, v^2, v, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 3/u*v^2+3*u, 0, 0, 0, 0, 0, 0, 1/u^2*v^2+u^2, 0, 1/u*v^2+u, v^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, v^2, v, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, v^2, 0, 0, v, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, v^2, 0, 0, v, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0],
  [3*v, 0, 0, (u+1/u)*v, 0, v, 0, 0, v^2, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, (-u^2+2-1/u^2)*v, 0, 0, 0, 0, 0, v, v^2, 0],
  [0, 0, 0, 0, 0, (-u^2+2-1/u^2)*v, 0, 0, 0, (-u-1/u)*v, 0, v^2]]],
[[[u^2, 0, 0, 0], [0, u^2, 0, 0], [0, 0, u^2, u], [0, 0, 0, -1]],
 [[u^2, 0, u, 0], [0, u^2, 0, 0], [0, 0, -1, 0], [0, 0, u, u^2]],
 [[-1, 0, 0, 0], [v, v^2, 0, 0], [1/u*v^2+u, 0, v^2, 0], [0, 0, 0, v^2]],
 [[v^2, v, 0, 0], [0, -1, 0, 0], [0, 0, v^2, 0], [0, 0, 0, v^2]]],
[[[u^2, u, 0, 0], [0, -1, 0, 0], [0, u, u^2, 0], [0, 0, 0, u^2]],
 [[u^2, 0, 0, 0], [0, u^2, u, 0], [0, 0, -1, 0], [0, 0, 0, u^2]],
 [[-1, 0, 0, 0], [0, -1, 0, 0], [1/u^2*v^2+u^2, 1/u*v^2+u, v^2, v],
  [0, 0, 0, -1]],
 [[-1, 0, 0, 0], [0, -1, 0, 0], [0, 0, -1, 0],
  [(u^2+1+1/u^2)*v, (u+1/u)*v, v, v^2]]],
[[[-1, 0, 0, 0], [0, -1, 0, 0], [0, u, u^2, u], [0, 0, 0, -1]],
 [[-1, 0, 0, 0], [0, u^2, u, 0], [0, 0, -1, 0], [0, 0, 0, -1]],
 [[v^2, v, 0, 0], [0, -1, 0, 0], [0, 1/u*v^2+u, v^2, 0],
  [0, -1/u^2*v^2-u^2, 0, v^2]],
 [[-1, 0, 0, 0], [v, v^2, 0, 0], [(-u-1/u)*v, 0, v^2, 0],
  [(u^2+1+1/u^2)*v, 0, 0, v^2]]],
[[[u^2, 0, u, 0], [0, -1, 0, 0], [0, 0, -1, 0], [0, 0, 0, -1]],
 [[-1, 0, 0, 0], [0, -1, 0, 0], [u, 0, u^2, u], [0, 0, 0, -1]],
 [[-1, 0, 0, 0], [0, -1, 0, 0], [0, 0, -1, 0], [0, v, 1/u*v^2+u, v^2]],
 [[-1, 0, 0, 0], [0, v^2, 0, v], [0, 0, -1, 0], [0, 0, 0, -1]]],
[[[u^2, 0, 0, 0, 0, 0, 0, 0], [0, u^2, 0, u, 0, 0, 0, 0],
  [0, 0, u^2, 0, u, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 0, 0, u, u^2, 0, 0],
  [0, 0, 0, 0, 0, 0, u^2, 0], [0, 0, 0, 0, 0, 0, 0, u^2]],
 [[u^2, u, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, u^2, 0, 0, 0, 0, 0], [0, u, 0, u^2, 0, 0, 0, 0],
  [0, 0, 0, 0, u^2, u, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 0, 0, u^2, 0], [0, 0, 0, 0, 0, 0, 0, u^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [1/u*v^2+u, v^2, v, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [0, 0, 0, v^2, v, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 1/u^2*v^2+u^2, 0, 1/u*v^2+u, v^2, v, 0],
  [0, 0, 0, 0, 0, 0, -1, 0], [(u^3+1/u^3)*v, 0, 0, 0, 0, 0, v, v^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [(u+1/u)*v, v, v^2, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, v, v^2, 0, 0, 0], [0, v, 0, 0, 0, v^2, 0, 0],
  [0, 0, 0, 0, 0, 0, v^2, v], [0, 0, 0, 0, 0, 0, 0, -1]]],
[[[-1, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [0, 0, u, u^2, 0, u, 0, 0],
  [0, 0, 0, 0, u^2, 0, u, 0], [0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0], [0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, u^2, u, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, u, 0, u^2, u], [0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [v, v^2, v, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [0, 0, 1/u*v^2+u, v^2, v, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, -1/u^2*v^2-u^2, 0, 0, v^2, v, 0],
  [0, 0, 0, 0, 0, 0, -1, 0], [(-u^3-1/u^3)*v, 0, 0, 0, 0, 0, 1/u*v^2+u, v^2]],
 [[v^2, v, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, v, v^2, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, v, 0, 0, v, v^2, 0], [0, 0, 0, 0, 0, (-u-1/u)*v, 0, v^2]]],
[[[u^2, 0, u, 0, 0, 0, 0, 0], [0, u^2, 0, 0, u, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [0, 0, 0, u^2, 0, 0, u, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 0, 0, u, u^2, 0, u],
  [0, 0, 0, 0, 0, 0, -1, 0], [0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [0, u^2, 0, u, 0, 0, 0, 0],
  [u, 0, u^2, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, u^2, u, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, u, 0, 0, u^2, u], [0, 0, 0, 0, 0, 0, 0, -1]],
 [[v^2, v, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, v^2, 0, v, 0, 0, 0], [0, 1/u*v^2+u, 0, v^2, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 0, 0, 1/u*v^2+u, v^2, 0, 0],
  [0, 0, 0, 0, 1/u*v^2+u, 0, v^2, 0], [0, 0, 0, 0, -1/u^2*v^2-u^2, 0, 0, v^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [v, v^2, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [(-u-1/u)*v, 0, 0, v^2, 0, 0, 0, 0],
  [0, 0, v, 0, v^2, 0, 0, 0], [v, 0, 0, 0, 0, v^2, 0, 0],
  [0, 0, (-u-1/u)*v, 0, 0, 0, v^2, 0], [0, 0, 0, 0, 0, 0, 0, v^2]]],
[[[u^2, 0, u, 0, 0, 0, 0, 0], [0, u^2, 0, 0, u, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [0, 0, u, u^2, 0, 0, u, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 0, 0, 0, u^2, 0, u],
  [0, 0, 0, 0, 0, 0, -1, 0], [0, 0, 0, 0, 0, 0, 0, -1]],
 [[u^2, u, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, u^2, u, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0],
  [0, u, 0, 0, u^2, 0, u, 0], [0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0], [0, 0, 0, 0, 0, u, 0, u^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0],
  [1/u^2*v^2+u^2, 1/u*v^2+u, 1/u*v^2+u, v^2, 0, v, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 1/u*v^2+u, 0, v^2, v], [0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0], [0, -1, 0, 0, 0, 0 , 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0], [0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0], [0, (u+1/u)*v, 0, v, 0, v^2, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0], [0, 0, v, 0, (u+1/u)*v, 0, v, v^2]]],
[[[u^2, 0, u, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, u^2, 0, 0, u, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, u^2, 0, 0, u, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, u^2, 0, 0, 0, u, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, u, u^2, 0, 0, 0, u, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, u^2, 0, 0, 0, u, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u^2, 0, 0, 0, u, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u, u, u^2]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [u, 0, u^2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, u^2, 0, u, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, u, 0, 0, u^2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, u^2, u, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, u, 0, 0, 0, u^2, 0, u, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, u, 0, u^2, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, u, 0, 0, 0, u^2, u, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u^2, u],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1]],
 [[-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [v, v^2, 0, 2*v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, v, 0, v^2, 0, 2*v, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 1/u*v^2+u, 0, v^2, 0, 0, v, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 1/u*v^2+u, v^2, 0, 0, v, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 1/u*v^2+u, 0, 0, v^2, 0, 0, v, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1/u^2*v^2-u^2, 0, 0, 0, 0, v^2, 0, 0, v, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0],
  [0, 0, -v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/u*v^2+u, v^2, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0],
  [-v, 0, 0, 0, 0, 0, 0, 0, 1/u*v^2+u, 0,1/u^2*v^2+u^2,0,0,0,1/u*v^2+u,v^2]],
 [[v^2, v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, v^2, 0, v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, v, 0, 0, v^2, 0, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0],
  [0, 0, 0, v, 0, 0, (u+1/u)*v, v, 0, 0, v^2, 0, 0, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0 ],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, v, 0, 0, v^2, 0, 0, 0],
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, v, 0, v^2, 0, 0],
  [0, 0, 0, 0, 0, 0, (-u^2-1/u^2)*v, 0, 0, 0, 0, v, 0, 0, v^2, 0],
  [0, 0, 0, 0, 0, 0, 0, (-u^2-1/u^2)*v,0,0,0,(-u-1/u)*v,0,0,0,v^2]]]];
  return r[i]*u^0*v^0;
fi;
end);

if not IsBound(CHEVIE.families) then ReadChv("unip/families");fi;
CHEVIE.families.S4:=rec(group:="S4",name:="S_4",
  charLabels:=["(1,1)", "(1,\\lambda)", "(1,\\lambda^{\\wedge2})",
  "(1,\\lambda^{\\wedge3})","(1,\\sigma)", "(g_2,1)", "(g_2,\\varepsilon'')",
  "(g_2,\\varepsilon')", "(g_2,\\varepsilon)", "(g'_2,1)",
  "(g'_2,\\varepsilon'')", "(g'_2,\\varepsilon')", "(g'_2,\\varepsilon)",
  "(g'_2,r)", "(g_3,1)", "(g_3,\\zeta_3)", "(g_3,\\zeta_3^2)", "(g_4,1)",
  "(g_4,-1)", "(g_4,-i)", "(g_4,i)"],
  fourierMat:=1/24*
[[1,3,3,1,2,6,6,6,6,3,3,3,3,6,8,8,8,6,6,6,6],
[3,9,9,3,6,6,6,6,6,-3,-3,-3,-3,-6,0,0,0,-6,-6,-6,-6],
[3,9,9,3,6,-6,-6,-6,-6,-3,-3,-3,-3,-6,0,0,0,6,6,6,6],
[1,3,3,1,2,-6,-6,-6,-6,3,3,3,3,6,8,8,8,-6,-6,-6,-6],
[2,6,6,2,4,0,0,0,0,6,6,6,6,12,-8,-8,-8,0,0,0,0],
[6,6,-6,-6,0,12,0,0,-12,6,6,-6,-6,0,0,0,0,0,0,0,0],
[6,6,-6,-6,0,0,12,-12,0,-6,-6,6,6,0,0,0,0,0,0,0,0],
[6,6,-6,-6,0,0,-12,12,0,-6,-6,6,6,0,0,0,0,0,0,0,0],
[6,6,-6,-6,0,-12,0,0,12,6,6,-6,-6,0,0,0,0,0,0,0,0],
[3,-3,-3,3,6,6,-6,-6,6,9,-3,9,-3,-6,0,0,0,6,6,-6,-6],
[3,-3,-3,3,6,6,-6,-6,6,-3,9,-3,9,-6,0,0,0,-6,-6,6,6],
[3,-3,-3,3,6,-6,6,6,-6,9,-3,9,-3,-6,0,0,0,-6,-6,6,6],
[3,-3,-3,3,6,-6,6,6,-6,-3,9,-3,9,-6,0,0,0,6,6,-6,-6],
[6,-6,-6,6,12,0,0,0,0,-6,-6,-6,-6,12,0,0,0,0,0,0,0],
[8,0,0,8,-8,0,0,0,0,0,0,0,0,0,16,-8,-8,0,0,0,0],
[8,0,0,8,-8,0,0,0,0,0,0,0,0,0,-8,16,-8,0,0,0,0],
[8,0,0,8,-8,0,0,0,0,0,0,0,0,0,-8,-8,16,0,0,0,0],
[6,-6,6,-6,0,0,0,0,0,6,-6,-6,6,0,0,0,0,12,-12,0,0],
[6,-6,6,-6,0,0,0,0,0,6,-6,-6,6,0,0,0,0,-12,12,0,0],
[6,-6,6,-6,0,0,0,0,0,-6,6,6,-6,0,0,0,0,0,0,12,-12],
[6,-6,6,-6,0,0,0,0,0,-6,6,6,-6,0,0,0,0,0,0,-12,12]],
  eigenvalues:=[1,1,1,1,1,1,1,-1,-1,1,1,1,1,-1,1,E(3),E(3)^2,1,-1,E(4),E(4)^3],
  perm:=(17,16)(20,21),
  mellin:=[[1,3,3,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
  [1,-1,1,-1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0],[1,0,0,1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[1,1,-1,-1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[1,-1,-1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,1,1,-1,-1,0,0,0,0,0,0,0,0,0,
0,0,0],[0,0,0,0,0,1,-1,1,-1,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,1,-1,-1,1,0,0,
0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,1,1,1,1,2,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,1,-1,1,-1,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,1,1,1,1,-2,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,1,1,-1,-1,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,1,-1,-1,1,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,E(3),E(3)^2,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,E(3)^2,E(3),0,
0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,-1,E(4),-E(4)],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,-1,-1],[0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-E(4),E(4)]],
mellinLabels:=["(1,1)","(1,g4)","(1,g3)","(1,g2)","(1,g'2)","(g2,1)","(g2,g2)",
  "(g2,g'2)","(g2,2c)","(g'2,1)","(g'2,2c)","(g'2,g'2)","(g'2,g2)","(g'2,g4)",
  "(g3,1)","(g3,g3)","(g3,g3^2)","(g4,1)","(g4,g4)","(g4,g2)","(g4,g4^-1)"],
  lusztig:=true, # does not satisfy (ST)^3=1 but (SPT)^3=1
  special:=1);

CHEVIE.AddData("UnipotentCharacters","F4",function()
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="F",indices:=[ 1 .. 4 ],rank:=4),
 levi:=[  ], eigenvalue:=1,
      parameterExponents:=[ 1, 1, 1, 1 ], cuspidalName:="",
      charNumbers:=[ 1 .. 25 ]),
    rec(relativeType:=rec(series:="B",cartanType:=2,indices:=[4, 1],rank:=2),
 levi:=[ 2 .. 3 ], eigenvalue:=-1,
      parameterExponents:=[ 3, 3 ], cuspidalName:="B_2",
      charNumbers:=[ 29, 27, 26, 30, 28 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 4 ], eigenvalue:=-1,
      parameterExponents:=[  ], cuspidalName:="F_4[-1]",
      charNumbers:=[ 31 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 4 ], eigenvalue:=-E(4),
      parameterExponents:=[  ], cuspidalName:="F_4[-i]",
      charNumbers:=[ 32 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 4 ], eigenvalue:=E(4),
      parameterExponents:=[  ], cuspidalName:="F_4[i]",
      charNumbers:=[ 33 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 4 ], eigenvalue:=E(3),
      parameterExponents:=[  ], cuspidalName:="F_4[\\zeta_3]",
      charNumbers:=[ 34 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 4 ], eigenvalue:=E(3)^2,
      parameterExponents:=[  ], cuspidalName:="F_4[\\zeta_3^2]",
      charNumbers:=[ 35 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 4 ], eigenvalue:=1,
      parameterExponents:=[  ], cuspidalName:="F_4[1]",
      charNumbers:=[ 36 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 4 ], eigenvalue:=1,
      parameterExponents:=[  ], cuspidalName:="F_4^2[1]",
      charNumbers:=[ 37 ])],
  families:=[
    Family("C1",[ 1 ]),
    Family("C1",[ 4 ]),
    Family("C1",[ 10 ]),
    Family("C1",[ 13 ]),
    Family("C1",[ 21 ]),
    Family("C1",[ 22 ]),
    Family("C1",[ 23 ]),
    Family("C1",[ 24 ]),
    Family("C2",[ 17, 5, 7, 30 ]),
    Family("C2",[ 20, 8, 6, 26 ]),
    Family("S4",[16,12,3,37,15,25,19,29,31,11,9,2,36,27,14,34,35,18,28,33,32])],
  a:=[0,4,4,24,1,13,1,13,4,2,4,4,10,4,4,4,1,4,4,13,3,9,3,9,4,13,4,4,4,1,4,4,
      4,4,4,4,4],
  A:=[0,20,20,24,11,23,11,23,20,14,20,20,22,20,20,20,11,20,20,23,15,21,15,21,
      20,23,20,20,20,11,20,20,20,20,20,20,20]);
end);

CHEVIE.AddData("Invariants","F4",
[function(x,y,z,t)return -t*z-2*x*y-2*y*z+t^2+2*x^2+2*y^2+z^2;end,

 function(x,y,z,t)return 16*t*x*y*z^3-12*t*x*y^2*z^2-8*t*x*y^3*z-
4*t*y*z^4-8*x*y*z^4+12*t*x^2*y*z^2+12*t*x^2*y^2*z-16*t*x^2*z^3+8*t*y^2*z^3+
32*x*y^2*z^3-8*t*x^3*y*z-8*t*y^3*z^2-64*x*y^3*z^2+4*t*x^4*z+4*t*y^4*z+
64*x*y^4*z-24*x*y^5-24*t^2*x*y*z^2+12*t^2*x*y^2*z+8*t^2*x*y^3-4*t^2*y*z^3-
32*x^2*y*z^3-12*t^2*x^2*y*z-12*t^2*x^2*y^2+24*t^2*x^2*z^2+60*x^2*y^2*z^2+
8*t^2*x^3*y+8*t^2*y^3*z-56*x^2*y^3*z-4*t^2*x^4-4*t^2*y^4+3*t^2*z^4+24*x^2*y^4+
8*x^2*z^4+4*y^2*z^4+16*t^3*x*y*z+16*t^3*y*z^2+8*x^3*y*z^2-16*t^3*x^2*z-
16*t^3*y^2*z-16*x^3*y^2*z-6*t^3*z^3-8*x^3*y^3-16*y^3*z^3-8*t^4*x*y-8*t^4*y*z+
8*x^4*y*z+8*t^4*x^2+8*t^4*y^2+3*t^4*z^2+24*x^4*y^2-4*x^4*z^2+28*y^4*z^2-
24*x^5*y-24*y^5*z+8*x^6+8*y^6;end,

function(x,y,z,t)return-24*t*x*y*z^5+180*t*x*y^2*z^4-416*t*x*y^3*z^3+
360*t*x*y^4*z^2-96*t*x*y^5*z+4*t*y*z^6+8*x*y*z^6-180*t*x^2*y*z^4+
408*t*x^2*y^2*z^3-288*t*x^2*y^3*z^2+24*t*x^2*y^4*z+24*t*x^2*z^5-12*t*y^2*z^5-
48*x*y^2*z^5+16*t*x^3*y*z^3-144*t*x^3*y^2*z^2+112*t*x^3*y^3*z-16*t*y^3*z^4+
88*x*y^3*z^4+72*t*x^4*y*z^2+24*t*x^4*y^2*z-8*t*x^4*z^3+88*t*y^4*z^3-
32*x*y^4*z^3-96*t*x^5*y*z-96*t*y^5*z^2-48*x*y^5*z^2+32*t*x^6*z+32*t*y^6*z+
32*x*y^6*z+6*t^2*x*y*z^4-144*t^2*x*y^2*z^3+408*t^2*x*y^3*z^2-360*t^2*x*y^4*z+
96*t^2*x*y^5+6*t^2*y*z^5+48*x^2*y*z^5+144*t^2*x^2*y*z^3-396*t^2*x^2*y^2*z^2+
288*t^2*x^2*y^3*z-24*t^2*x^2*y^4-6*t^2*x^2*z^4+6*t^2*y^2*z^4-84*x^2*y^2*z^4-
24*t^2*x^3*y*z^2+144*t^2*x^3*y^2*z-112*t^2*x^3*y^3+8*t^2*y^3*z^3+
16*x^2*y^3*z^3-72*t^2*x^4*y*z-24*t^2*x^4*y^2+12*t^2*x^4*z^2-84*t^2*y^4*z^2+
24*x^2*y^4*z^2+96*t^2*x^5*y+96*t^2*y^5*z+48*x^2*y^5*z-32*t^2*x^6-32*t^2*y^6-
3*t^2*z^6-48*x^2*y^6-8*x^2*z^6-4*y^2*z^6+28*t^3*x*y*z^3-72*t^3*x*y^2*z^2+
16*t^3*x*y^3*z-28*t^3*y*z^4-8*x^3*y*z^4+72*t^3*x^2*y*z^2-24*t^3*x^2*y^2*z-
28*t^3*x^2*z^3+20*t^3*y^2*z^3+32*x^3*y^2*z^3+16*t^3*x^3*y*z+16*t^3*y^3*z^2+
80*x^3*y^3*z^2-8*t^3*x^4*z-8*t^3*y^4*z-224*x^3*y^4*z+9*t^3*z^5+144*x^3*y^5+
24*y^3*z^5+6*t^4*x*y*z^2+36*t^4*x*y^2*z-8*t^4*x*y^3+34*t^4*y*z^3-16*x^4*y*z^3-
36*t^4*x^2*y*z+12*t^4*x^2*y^2-6*t^4*x^2*z^2-30*t^4*y^2*z^2-120*x^4*y^2*z^2-
8*t^4*x^3*y-8*t^4*y^3*z+272*x^4*y^3*z+4*t^4*x^4+4*t^4*y^4-12*t^4*z^4-
192*x^4*y^4+4*x^4*z^4-52*y^4*z^4-24*t^5*x*y*z-24*t^5*y*z^2+96*x^5*y*z^2+
24*t^5*x^2*z+24*t^5*y^2*z-192*x^5*y^2*z+9*t^5*z^3+144*x^5*y^3+48*y^5*z^3+
8*t^6*x*y+8*t^6*y*z+64*x^6*y*z-8*t^6*x^2-8*t^6*y^2-3*t^6*z^2-48*x^6*y^2-
32*x^6*z^2-16*y^6*z^2;end,

function(x,y,z,t)return 200*t*x*y*z^9+4812*t*x*y^2*z^8-46976*t*x*y^3*z^7+
172024*t*x*y^4*z^6-338160*t*x*y^5*z^5+383248*t*x*y^6*z^4-235264*t*x*y^7*z^3+
60096*t*x*y^8*z^2-20*t*y*z^10-40*x*y*z^10-4812*t*x^2*y*z^8+
75984*t*x^2*y^2*z^7-369808*t*x^2*y^3*z^6+891240*t*x^2*y^4*z^5-
1178544*t*x^2*y^5*z^4+815104*t*x^2*y^6*z^3-225024*t*x^2*y^7*z^2-
3840*t*x^2*y^8*z-200*t*x^2*z^9+100*t*y^2*z^9+400*x*y^2*z^9-58016*t*x^3*y*z^7+
395568*t*x^3*y^2*z^6-1063008*t*x^3*y^3*z^5+1483824*t*x^3*y^4*z^4-
1110112*t*x^3*y^5*z^3+336544*t*x^3*y^6*z^2+15360*t*x^3*y^7*z+160*t*y^3*z^8-
1480*x*y^3*z^8-197784*t*x^4*y*z^6+423624*t*x^4*y^2*z^5-474992*t*x^4*y^3*z^4+
486112*t*x^4*y^4*z^3-237408*t*x^4*y^5*z^2-30720*t*x^4*y^6*z+29008*t*x^4*z^7-
2160*t*y^4*z^7+2240*x*y^4*z^7+129456*t*x^5*y*z^5-320304*t*x^5*y^2*z^4-
71200*t*x^5*y^3*z^3+229728*t*x^5*y^4*z^2+38400*t*x^5*y^5*z+6080*t*y^5*z^6-
160*x*y^5*z^6+106768*t*x^6*y*z^4+280288*t*x^6*y^2*z^3-321184*t*x^6*y^3*z^2-
30720*t*x^6*y^4*z-43152*t*x^6*z^5-8000*t*y^6*z^5-3520*x*y^6*z^5-
219904*t*x^7*y*z^3+209664*t*x^7*y^2*z^2+15360*t*x^7*y^3*z+5120*t*y^7*z^4+
3840*x*y^7*z^4-52416*t*x^8*y*z^2-3840*t*x^8*y^2*z+54976*t*x^8*z^3-
1280*t*y^8*z^3-1280*x*y^8*z^3-210*t^2*x*y*z^8-24768*t^2*x*y^2*z^7+
179696*t^2*x*y^3*z^6-530472*t^2*x*y^4*z^5+839160*t^2*x*y^5*z^4-
748576*t^2*x*y^6*z^3+345216*t^2*x*y^7*z^2-60096*t^2*x*y^8*z-50*t^2*y*z^9-
400*x^2*y*z^9+24768*t^2*x^2*y*z^7-218172*t^2*x^2*y^2*z^6+
745512*t^2*x^2*y^3*z^5-1404624*t^2*x^2*y^4*z^4+1592304*t^2*x^2*y^5*z^3-
972528*t^2*x^2*y^6*z^2+225024*t^2*x^2*y^7*z+3840*t^2*x^2*y^8+210*t^2*x^2*z^8-
3666*t^2*y^2*z^8-5772*x^2*y^2*z^8+76952*t^2*x^3*y*z^6-430080*t^2*x^3*y^2*z^5+
1027368*t^2*x^3*y^3*z^4-1491200*t^2*x^3*y^4*z^3+1197552*t^2*x^3*y^5*z^2-
336544*t^2*x^3*y^6*z-15360*t^2*x^3*y^7+28688*t^2*y^3*z^7+55776*x^2*y^3*z^7+
215040*t^2*x^4*y*z^5-254784*t^2*x^4*y^2*z^4+254960*t^2*x^4*y^3*z^3-
538560*t^2*x^4*y^4*z^2+237408*t^2*x^4*y^5*z+30720*t^2*x^4*y^6-
38476*t^2*x^4*z^6-93692*t^2*y^4*z^6-194744*x^2*y^4*z^6-310680*t^2*x^5*y*z^4+
588768*t^2*x^5*y^2*z^3+158640*t^2*x^5*y^3*z^2-229728*t^2*x^5*y^4*z-
38400*t^2*x^5*y^5+168600*t^2*y^5*z^5+360720*x^2*y^5*z^5-196256*t^2*x^6*y*z^3-
437712*t^2*x^6*y^2*z^2+321184*t^2*x^6*y^3*z+30720*t^2*x^6*y^4+
103560*t^2*x^6*z^4-178504*t^2*y^6*z^4-383728*x^2*y^6*z^4+329856*t^2*x^7*y*z^2-
209664*t^2*x^7*y^2*z-15360*t^2*x^7*y^3+104832*t^2*y^7*z^3+222464*x^2*y^7*z^3+
52416*t^2*x^8*y*z+3840*t^2*x^8*y^2-82464*t^2*x^8*z^2-26208*t^2*y^8*z^2-
54336*x^2*y^8*z^2+15*t^2*z^10+40*x^2*z^10+20*y^2*z^10-360*t^3*x*y*z^7+
45388*t^3*x*y^2*z^6-261608*t^3*x*y^3*z^5+668712*t^3*x*y^4*z^4-
958848*t^3*x*y^5*z^3+730656*t^3*x*y^6*z^2-219904*t^3*x*y^7*z+4036*t^3*y*z^8+
14504*x^3*y*z^8-45388*t^3*x^2*y*z^6+275508*t^3*x^2*y^2*z^5-
648800*t^3*x^2*y^3*z^4+915768*t^3*x^2*y^4*z^3-827520*t^3*x^2*y^5*z^2+
314848*t^3*x^2*y^6*z+360*t^3*x^2*z^7-15224*t^3*y^2*z^7-116032*x^3*y^2*z^7-
27800*t^3*x^3*y*z^5-39824*t^3*x^3*y^2*z^4+221360*t^3*x^3*y^3*z^3+
14752*t^3*x^3*y^4*z^2-174880*t^3*x^3*y^5*z-6392*t^3*y^3*z^6+
375424*x^3*y^3*z^6+19912*t^3*x^4*y*z^4-448680*t^3*x^4*y^2*z^3+
440064*t^3*x^4*y^3*z^2+104896*t^3*x^4*y^4*z+13900*t^3*x^4*z^5+
130092*t^3*y^4*z^5-628096*x^3*y^4*z^5+405600*t^3*x^5*y*z^3-
536928*t^3*x^5*y^2*z^2-174880*t^3*x^5*y^3*z-306208*t^3*y^5*z^4+
517008*x^3*y^5*z^4+178976*t^3*x^6*y*z^2+314848*t^3*x^6*y^2*z-
135200*t^3*x^6*z^3+358624*t^3*y^6*z^3-46656*x^3*y^6*z^3-219904*t^3*x^7*y*z-
219904*t^3*y^7*z^2-227584*x^3*y^7*z^2+54976*t^3*x^8*z+54976*t^3*y^8*z+
111232*x^3*y^8*z-75*t^3*z^9-200*y^3*z^9+1320*t^4*x*y*z^6-43956*t^4*x*y^2*z^5+
135728*t^4*x*y^3*z^4-213896*t^4*x*y^4*z^3+371544*t^4*x*y^5*z^2-
365328*t^4*x*y^6*z+109952*t^4*x*y^7-4636*t^4*y*z^7+58016*x^4*y*z^7+
43956*t^4*x^2*y*z^5-137340*t^4*x^2*y^2*z^4+67880*t^4*x^2*y^3*z^3-
180384*t^4*x^2*y^4*z^2+413760*t^4*x^2*y^5*z-157424*t^4*x^2*y^6-
1320*t^4*x^2*z^6+49128*t^4*y^2*z^6-151752*x^4*y^2*z^6+3224*t^4*x^3*y*z^4+
292032*t^4*x^3*y^2*z^3-485880*t^4*x^3*y^3*z^2-7376*t^4*x^3*y^4*z+
87440*t^4*x^3*y^5-110560*t^4*y^3*z^5+98288*x^4*y^3*z^5-146016*t^4*x^4*y*z^3+
501840*t^4*x^4*y^2*z^2-220032*t^4*x^4*y^3*z-52448*t^4*x^4*y^4-
1612*t^4*x^4*z^4+81732*t^4*y^4*z^4+320928*x^4*y^4*z^4-310680*t^4*x^5*y*z^2+
268464*t^4*x^5*y^2*z+87440*t^4*x^5*y^3+45224*t^4*y^5*z^3-856000*x^4*y^5*z^3-
89488*t^4*x^6*y*z-157424*t^4*x^6*y^2+103560*t^4*x^6*z^2-143352*t^4*y^6*z^2+
733248*x^4*y^6*z^2+109952*t^4*x^7*y+109952*t^4*y^7*z-111232*x^4*y^7*z-
27488*t^4*x^8-27488*t^4*y^8-1176*t^4*z^8-83424*x^4*y^8-7252*x^4*z^8+
820*y^4*z^8-1860*t^5*x*y*z^5+46716*t^5*x*y^2*z^4-46520*t^5*x*y^3*z^3-
144552*t^5*x*y^4*z^2+129456*t^5*x*y^5*z-16760*t^5*y*z^6-43152*x^5*y*z^6-
46716*t^5*x^2*y*z^4+60420*t^5*x^2*y^2*z^3+307824*t^5*x^2*y^3*z^2-
333000*t^5*x^2*y^4*z+1860*t^5*x^2*z^5-9612*t^5*y^2*z^5+258912*x^5*y^2*z^5-
27800*t^5*x^3*y*z^3-326544*t^5*x^3*y^2*z^2+450240*t^5*x^3*y^3*z+
95896*t^5*y^3*z^4-618352*x^5*y^3*z^4+163272*t^5*x^4*y*z^2-
333000*t^5*x^4*y^2*z+13900*t^5*x^4*z^3-155828*t^5*y^4*z^3+747328*x^5*y^4*z^3+
129456*t^5*x^5*y*z+129456*t^5*y^5*z^2-124032*x^5*y^5*z^2-43152*t^5*x^6*z-
43152*t^5*y^6*z-556160*x^5*y^6*z+5154*t^5*z^7+333696*x^5*y^7-1760*y^5*z^7+
1320*t^6*x*y*z^4-50908*t^6*x*y^2*z^3+83192*t^6*x*y^3*z^2+48184*t^6*x*y^4*z-
43152*t^6*x*y^5+38636*t^6*y*z^5-86304*x^6*y*z^5+50908*t^6*x^2*y*z^3-
121668*t^6*x^2*y^2*z^2-102608*t^6*x^2*y^3*z+111000*t^6*x^2*y^4-
1320*t^6*x^2*z^4-63688*t^6*y^2*z^4+77840*x^6*y^2*z^4+76952*t^6*x^3*y*z^2+
108848*t^6*x^3*y^2*z-150080*t^6*x^3*y^3+35720*t^6*y^3*z^3+264000*x^6*y^3*z^3-
54424*t^6*x^4*y*z+111000*t^6*x^4*y^2-38476*t^6*x^4*z^2+18100*t^6*y^4*z^2-
990848*x^6*y^4*z^2-43152*t^6*x^5*y-43152*t^6*y^5*z+1223552*x^6*y^5*z+
14384*t^6*x^6+14384*t^6*y^6-7836*t^6*z^6-500544*x^6*y^6+14384*x^6*z^6+
2080*y^6*z^6-360*t^7*x*y*z^3+30288*t^7*x*y^2*z^2-58016*t^7*x*y^3*z-
28088*t^7*y*z^4+109952*x^7*y*z^4-30288*t^7*x^2*y*z^2+87024*t^7*x^2*y^2*z+
360*t^7*x^2*z^3+57096*t^7*y^2*z^3-439808*x^7*y^2*z^3-58016*t^7*x^3*y*z-
58016*t^7*y^3*z^2+884736*x^7*y^3*z^2+29008*t^7*x^4*z+29008*t^7*y^4*z-
889856*x^7*y^4*z+5154*t^7*z^5+333696*x^7*y^5-1280*y^7*z^5-210*t^8*x*y*z^2-
7572*t^8*x*y^2*z+14504*t^8*x*y^3+6722*t^8*y*z^3+109952*x^8*y*z^3+
7572*t^8*x^2*y*z-21756*t^8*x^2*y^2+210*t^8*x^2*z^2-13974*t^8*y^2*z^2-
221184*x^8*y^2*z^2+14504*t^8*x^3*y+14504*t^8*y^3*z+222464*x^8*y^3*z-
7252*t^8*x^4-7252*t^8*y^4-1176*t^8*z^4-83424*x^8*y^4-27488*x^8*z^4+
320*y^8*z^4+200*t^9*x*y*z+200*t^9*y*z^2-200*t^9*x^2*z-200*t^9*y^2*z-
75*t^9*z^3-40*t^10*x*y-40*t^10*y*z+40*t^10*x^2+40*t^10*y^2+15*t^10*z^2;end]);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","F4",function()return function(x1,x2,x3,x4)
return 364500*x1*x2^3*x3^2*x4+54158625*x1*x2^5*x3^2-189324*x1^2*x3*x4^3-
84457998*x1^2*x2^2*x3*x4^2+702196650*x1^2*x2^2*x3^4+192564*x2^2*x4^3-
4814100*x2^2*x3^3*x4+4733100*x1^2*x3^4*x4-12556317582*x1^2*x2^4*x3*x4-
622114976971*x1^2*x2^6*x3-186084*x1^3*x2*x4^3+5016600*x1^3*x2*x3^3*x4-
16200*x3^3*x4^2-82928718*x1^3*x2^3*x4^2+692591400*x1^3*x2^3*x3^3-
12316379112*x1^3*x2^5*x4-609597781711*x1^3*x2^7+324*x4^4+42908589*x2^4*x4^2+
41452209*x1^4*x3^2*x4^2+12337192062*x1^4*x2^2*x3^2*x4-357875325*x2^4*x3^3+
917712897954*x1^4*x2^4*x3^2-345333825*x1^4*x3^5+81618138*x1^5*x2*x3*x4^2-
731778525*x1^5*x2*x3^4+24268541184*x1^5*x2^3*x3*x4+1803617805378*x1^5*x2^5*x3+
202500*x3^6+4248528834*x2^6*x4+38588049*x1^6*x2^2*x4^2-
600612059326*x1^6*x2^2*x3^3-3240*x1^6*x4^3-4030577814*x1^6*x3^3*x4+
11676178602*x1^6*x2^4*x4+872143520439*x1^6*x2^6-11922426972*x1^7*x2*x3^2*x4-
1773880309848*x1^7*x2^3*x3^2+157714619689*x2^8+1383480*x1^8*x3*x4^2-
11304558162*x1^8*x2^2*x3*x4+146854662829*x1^8*x3^4-1710859325763*x1^8*x2^4*x3+
1432080*x1^9*x2*x4^2+580036214806*x1^9*x2*x3^3-3397335204*x1^9*x2^3*x4-
535990067941*x1^9*x2^5-196915320*x1^10*x3^2*x4+827101062789*x1^10*x2^2*x3^2-
407665440*x1^11*x2*x3*x4+499325143276*x1^11*x2^3*x3-210993120*x1^12*x2^2*x4+
9342537960*x1^12*x3^3+105367602964*x1^12*x2^4+29012190480*x1^13*x2*x3^2+
30031354080*x1^14*x2^2*x3+10362106560*x1^15*x2^3;
end;end);

CHEVIE.AddData("UnipotentClasses","F4",function(c,p)local uc,Z;
  if p=0 then p:=1;fi; Z:=n->ComplexReflectionGroup(n,1,1);
  uc:=rec(orderPicture:=Concatenation(
# Partial order on unipotent classes --- courtesy of Hyohe Miyachi
"      	F_4\n",
"        |\n",
"      F_4(a_1)\n",
"        |\n",
"      F_4(a_2)\n",
"      /      \\\n",
"   B_3       C_3\n",
"      \\     /\n",
"      F_4(a_3)\n",
"	 |\n",
"      C_3(a_1)\n",
"     /       |\n",
"~A_2+A_1     B_2\n",
"    |   \\    |\n",
"    |     A_2+~A_1\n",
"    |        |\n",
"  ~A_2      A_2\n",
"     \\       |\n",
"      A_1+~A_1\n",
"	 |\n",
"       ~A_1\n",
"	 |\n",
"	A_1\n",
"	 |\n",
"	 1"),
classes:=[
rec(name:="1",succ:=["A1"],dynkin:=[0,0,0,0],Au:=Z(1)),
rec(name:="A_1",succ:=["~A1"],dynkin:=[1,0,0,0],Au:=Z(1)),
rec(name:="\\tilde A_1",succ:=["A1+~A1"],dynkin:=[0,0,0,1],Au:=Z(Gcd(2,p-1))),
rec(name:="A_1{+}\\tilde A_1",succ:=["A2","~A2"],dynkin:=[0,1,0,0],Au:=Z(1)),
rec(name:="\\tilde A_2",succ:=["~A2+A1"],dynkin:=[0,0,0,2],Au:=Z(Gcd(2,p))),
rec(name:="A_2",succ:=["A2+~A1"],dynkin:=[2,0,0,0],Au:=Z(2)),
rec(name:="A_2{+}\\tilde A_1",succ:=["~A2+A1","B2"],dynkin:=[0,0,1,0],Au:=Z(1)),
rec(name:="\\tilde A_2{+}A_1",succ:=["C3(a1)"],dynkin:=[0,1,0,1],Au:=Z(1)),
rec(name:="B_2",succ:=["C3(a1)"],dynkin:=[2,0,0,1],Au:=Z(Gcd(p-1,2))),
rec(name:="C_3(a_1)",shoji:="A_1{+}B_2",succ:=["F4(a3)"],dynkin:=[1,0,1,0],Au:=Z(Gcd(p-1,2))),
rec(name:="F_4(a_3)",shoji:="A_3{+}\\tilde A_1",succ:=["C3","B3"],dynkin:=[0,2,0,0],
  Au:=CoxeterGroup("A",4-Gcd(p,2))),
rec(name:="C_3",succ:=["F4(a2)"],dynkin:=[1,0,1,2],Au:=Z(Gcd(p,2))),
rec(name:="B_3",succ:=["F4(a2)"],dynkin:=[2,2,0,0],Au:=Z(Gcd(p,2))),
rec(name:="F_4(a_2)",shoji:="C_3{+}A_1",succ:=["F4(a1)"],dynkin:=[0,2,0,2],
  Au:=CoxeterGroup("B",Gcd(p,2))),
rec(name:="F_4(a_1)",shoji:="B_4",succ:=["F4"],dynkin:=[2,2,0,2],Au:=Z(2)),
rec(name:="F_4",succ:=[],dynkin:=[2,2,2,2],Au:=Z(Gcd(12,p^2)))],
springerSeries:=[
rec(relgroup:=CoxeterGroup("F",4),levi:=[],Z:=[],
 locsys:=[[16,1],[6,1],[11,2],[1,1],
 [14,1],[3,1],[15,1],[2,1],[9,1],[14,2],[9,2],[11,4],[4,1],[8,1],[11,3],[11,5],
 [15,2],[7,1],[10,1],[3,2],[13,1],[5,1],[12,1],[6,2],[10,2]]),
rec(relgroup:=Z(1),levi:=[1,2,3,4],Z:=[],locsys:=[[11,1]],
   parameter:=37) # Fourier transform of 37th unip. character
   ]);
  if p=2 then Append(uc.classes,
[rec(name:="(\\tilde A_1)_2",succ:=["~A1"],dimBu:=16,Au:=Z(1)),
 rec(name:="(B_2)_2",succ:=["B2","C3(a1)2"],dimBu:=8,Au:=Z(2)),
 rec(name:="(\\tilde A_2{+}A_1)_2",succ:=["~A2+A1","C3(a1)2"],dimBu:=7,Au:=Z(1)),
 rec(name:="C_3(a_1)_2",succ:=["C3(a1)"],dimBu:=6,Au:=Z(1))]);
  Add(uc.classes[1].succ,"(~A1)2");Add(uc.classes[4].succ,"(B2)2");
  uc.classes[5].succ:=["(~A2+A1)2"];
  uc.springerSeries:=[rec(relgroup:=CoxeterGroup("F",4),levi:=[],Z:=[],
      locsys:=[[16,1],[6,1],[5,1],[1,1],[14,1],[17,1],[14,5],[2,1],[18,2],#9
       [14,4],[9,1],[20,1],[4,1],[8,1],[11,2],[11,3],[15,2],[7,1],[19,1],#19
       [3,1],[13,2],[5,2],[12,2],[6,2],[10,1]]),
      rec(relgroup:=CoxeterGroup("B",2),levi:=[2,3],Z:=[],
      locsys:=[[12,1],[14,2],[18,1],[16,3],[13,1]])];
   for c in [[11,1],[16,2],[16,4],[15,1],[14,3]] do Add(uc.springerSeries,
    rec(relgroup:=Z(1),levi:=[1,2,3,4],Z:=[],locsys:=[c]));od;
  elif p=3 then Append(uc.springerSeries,
    [rec(relgroup:=Z(1),levi:=[1,2,3,4],Z:=[],locsys:=[[16,2]]),
    rec(relgroup:=Z(1),levi:=[1,2,3,4],Z:=[],locsys:=[[16,3]])]);
  fi;
  uc.operations:=UnipotentClassesOps;
  uc.orderClasses:=List(uc.classes,c->
    List(c.succ,n->PositionProperty([1..Length(uc.classes)],
      c->ClassName(uc,c)=n)));
  for c in uc.classes do Unbind(c.succ);od;
  return uc;end);

CHEVIE.AddData("KLeftCellRepresentatives","F4",
[rec(character:=[1], duflo:=[1,2,3,4], reps:=""),
 rec(character:=[4], duflo:=[25,26,27,28], reps:=""),
 rec(character:=[10], duflo:=[2,1,13,45], reps:=""),
 rec(character:=[13], duflo:=[1,29,31,4], reps:=""),
 rec(character:=[17,5], duflo:=[1,2,7,28], reps:=[[18,40,10,3]]),
 rec(character:=[17,7], duflo:=[5,26,6,4], reps:=[[5,9,4,34]]),
 rec(character:=[20,6], duflo:=[35,26,6,37], reps:=[[11,25,30,31]]),
 rec(character:=[20,8], duflo:=[14,26,27,36], reps:=[[26,35,8,36]]),
 rec(character:=[21], duflo:=[1,2,3,43], reps:=""),
 rec(character:=[22], duflo:=[20,26,39,8], reps:=""),
 rec(character:=[23], duflo:=[1,23,45,4], reps:=""),
 rec(character:=[24], duflo:=[2,1,32,28], reps:=""),
 rec(character:=[25,19,16,14,11], duflo:=[16,14,43,15],
    reps:=[[1,16,31,41],[1,16,45,17],[2,1,36,4],[2,44,4,8],[14,18,39,34],[14,
    18,45,10],[14,35,15,45],[14,47,10,15],[16,14,30,39],[18,2,41,8],[18,48,8,
    10],[38,40,10,15],[42,38,8,10]]),
 rec(character:=[25,19,16,15,11,11,2], duflo:=[22,2,30,28],
    reps:=[[1,9,27,41],[1,9,43,17],[1,23,43,28],[1,35,19,45],[2,18,28,43],[2,
    18,45,19],[9,20,34,39],[9,20,45,15],[11,2,41,12],[11,48,12,6],[20,11,43,
    6],[20,42,15,43],[20,47,6,15],[33,42,15,10],[35,44,12,6],[44,33,6,15]]),
 rec(character:=[25,20,16,14,12], duflo:=[20,47,13,8],
    reps:=[[1,42,4,3],[11,16,37,36],[11,16,45,12],[11,33,13,45],[11,48,12,13],
    [16,1,39,3],[16,46,3,12],[20,11,32,37],[20,11,43,13],[22,48,8,4],[29,40,4,
    19],[35,44,12,13],[40,35,3,12]]),
 rec(character:=[25,20,16,15,12,12,3], duflo:=[25,33,3,17],
    reps:=[[9,18,39,34],[9,18,45,10],[9,35,15,45],[9,47,10,15],[11,20,36,30],
    [18,46,3,10],[20,9,30,39],[20,9,43,15],[20,26,6,43],[20,48,15,6],[22,47,6,
    4],[23,48,12,3],[25,47,19,4],[26,42,4,19],[33,44,10,15],[42,33,3,10]]),
 rec(character:=[25,25,16,15,12,11,17], duflo:=[14,26,27,13],
    reps:=[[1,23,41,27],[5,16,34,39],[5,16,45,15],[5,48,15,10],[11,20,41,31],
    [11,20,45,7],[11,46,7,17],[14,16,34,27],[16,11,27,41],[16,11,43,17],[20,
    48,8,7],[22,5,41,10],[22,35,8,41],[22,47,10,8],[26,35,8,13],[26,46,19,4],
    [29,46,15,10],[35,40,7,17],[44,35,8,7]])]);
