#############################################################################
##
#A  tbl/exceptio.g             CHEVIE library                     Jean Michel
##
#Y  Copyright (C) 1999 - 2001  The CHEVIE Team
##
##  This file contains various code which is common to several (but not all)
##  types of reflection groups.
##
CHEVIE.Revision("tbl/exceptio.g",
   "$Id: exceptio.g,v 1.5 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.IndirectAddData("CharName",["2E6","E6","E7","E8","2F4","F4","G2",
  "H3","H4","2G5","G24","G25","G26","G27","G29","G31","G32","G33","G34"],
  t->function(x,option)local s,f;
    for f in ["frame","kondo","spaltenstein","gp"] do
      if IsBound(option.(f)) then s:=CHEVIE.RawData("CharInfo",t)();
        if IsBound(s.(f)) then return s.(f)[Position(s.charparams,x)];fi;
      fi;
    od;
    if IsBound(option.TeX) then s:=SPrint("\\phi_{",x[1],",",x[2],"}");
      if Length(x)=3 then Append(s,List([1..x[3]],y->'\''));fi;
    else s:=SPrint("phi{",x[1],",",x[2],"}");
#   f:=["'","\"","\"'","\"\""]; if Length(x)=3 then Append(s,f[x[3]]);fi;
      if Length(x)=3 then Append(s,List([1..x[3]],y->'\''));fi;
    fi;
    return String(s);
end);

CHEVIE.AddData("CharName",["G4_7","G8_15","G16_22"],
function(n,x,option)local s,f;
  if IsBound(option.TeX) then s:=SPrint("\\phi_{",x[1],",",x[2],"}");
    if Length(x)=3 then Append(s,List([1..x[3]],y->'\''));fi;
  else s:=SPrint("phi{",x[1],",",x[2],"}");
#   f:=["'","\"","\"'","\"\""]; if Length(x)=3 then Append(s,f[x[3]]);fi;
    if Length(x)=3 then Append(s,List([1..x[3]],y->'\''));fi;
  fi;
  return String(s);
end);

CHEVIE.AddData("ClassName",["H3","H4","G4_7","G8_15","G16_22",
  "G24","G25","G26","G27","G29","G31","G32","G33","G34"],x->x);

CHEVIE.IndirectAddData("CartanMat",["G25","G26","G29","G31","G32","G34"],
  function(t)local r,rbar,e;
  r:=CHEVIE.RawData("GeneratingRoots",t);
  rbar:=ComplexConjugate(r);
  e:=CHEVIE.RawData("EigenvaluesGeneratingReflections",t);
  e:=1-List(e,x->E(Denominator(x))^Numerator(x));
  e:=List([1..Length(e)],i->e[i]*rbar[i]/(rbar[i]*r[i]));
  return List(e,x->List(r,y->x*y));
  end);

CHEVIE.IndirectAddData("ReflectionName",
  ["G24","G25","G26","G27","G29","G31","G32","G33","G34","E6","E7","E8","2E6",
   "2F4","3D4","H3","H4"],
  t->function(option)local i,o;
  i:=["G24","G25","G26","G27","G29","G31","G32","G33","G34","E6","E7","E8",
   "2E6","2F4","3D4","H3","H4"];
  o:=["G_{24}","G_{25}","G_{26}","G_{27}","G_{29}","G_{31}","G_{32}","G_{33}",
   "G_{34}","E_6","E_7","E_8","{}^2E_6","{}^2F_4","{}^3D_4","H_3","H_4"];
  if IsBound(option.TeX) then return o[Position(i,t)];else return t;fi;end);

CHEVIE.IndirectAddData("ReflectionName",["A","D","2A","2D"],
t->function(r,option)local i,o;
  i:=["A","D","2A","2D"];o:=["A","D","{}^2A","{}^2D"];
  if IsBound(option.arg) then return SPrint(FormatGAP(t),",",r);
  elif IsBound(option.TeX) then 
       return SPrint(o[Position(i,t)],"_",TeXBracket(r));
  else return SPrint(t,r);fi;
  end);

CHEVIE.IndirectAddData("CharTable",["3D4","E6","2E6","E7","E8",
 "F4","2F4","G2","H3","H4"],
 t->function()local res,rank;
  rank:=Position("12345678",t[Length(t)]);
  res:=CHEVIE.RawData("HeckeCharTable",t)(List([1..rank],x->[1,-1]),
                                          List([1,rank],x->1));
  CHEVIE.compat.ChangeIdentifier(res, String(Concatenation("W(",t,")")));
  return res;
end);

CHEVIE.IndirectAddData("PoincarePolynomial",["G24","G27","G29","G33","G34",
  "H3","H4","E6","E7","E8"],
t->function(q)return Product(CHEVIE.RawData("ReflectionDegrees",t),
  x->Sum([0..x-1],y->(-q[1][1]/q[1][2])^y));
end);

CHEVIE.IndirectAddData("FakeDegree",["G4_7","G8_15","G16_22"],
t->function(n,phi,q)local f;f:=CHEVIE.RawData("factors",t)(n)
   [Position(CHEVIE.RawData("CharInfo",t)(n).charparams,phi)];
   return Sum([1,3..Length(f)-1],i->f[i]*q^f[i+1]);
end);

CHEVIE.IndirectAddData("FakeDegree",
["G2","F4","H3","E6","G24","G25","G26","G27","G29","G32","G33","G34"], 
  t->function(phi,q)local f;f:=CHEVIE.RawData("factors",t)
   [Position(CHEVIE.RawData("CharInfo",t)().charparams,phi)];
   return Sum([1,3..Length(f)-1],i->f[i]*q^f[i+1]);
end);

CHEVIE.IndirectAddData("FakeDegree",["H4","E7","E8","G31"],
  t->function(phi,q)local f,res;f:=CHEVIE.RawData("cycpolfakedegrees",t)
   [Position(CHEVIE.RawData("CharInfo",t)().charparams,phi)];
   if IsList(f[1]) then res:=ValuePol(f[1],q^2);else res:=f[1];fi;
   f:=ShallowCopy(f);f[1]:=1;
   return res*Value(CycPol(f),q);
end);
  
CHEVIE.IndirectAddData("HighestPowerFakeDegrees",["H4","E7","E8","G31"],
t->function()return List(CHEVIE.RawData("cycpolfakedegrees",t),
  function(f)local res;
  if IsList(f[1])then res:=2*Length(f[1])+f[2]-2;else res:=f[2];fi;
  return res+Sum(f{[3..Length(f)]},Phi);end);
end);

CHEVIE.IndirectAddData("HighestPowerFakeDegrees",
["E6","G32","G33","G34","G2","F4","H3","G24","G25","G26","G27","G29"],
t->function()return List(CHEVIE.RawData("factors",t),x->x[Length(x)]);end);

CHEVIE.IndirectAddData("HighestPowerFakeDegrees",["G4_7","G8_15","G16_22"],
t->function(n)return List(CHEVIE.RawData("factors",t)(n),x->x[Length(x)]);end);

CHEVIE.IndirectAddData("LowestPowerFakeDegrees",["G4_7","G8_15","G16_22"],
t->function(n)return List(CHEVIE.RawData("factors",t)(n),x->x[2]);end);

CHEVIE.IndirectAddData("LowestPowerFakeDegrees",
["G2","F4","H3","H4","G24","G25","G26","G27","G29","E6","E7","E8",
 "G31","G32","G33","G34"], 
t->function()return List(CHEVIE.RawData("factors",t),x->x[2]);end);

CHEVIE.IndirectAddData("PrintDiagram",["E6","E7","E8"],
  t->function(indices,title)local i,r,digits,l;digits:="678";
  Print(title," ");
  r:=Position(digits,t[2])+5;
  l:=Length(String(indices[1]))+Length(String(indices[3]))+4;
  Print(String("",l-1),indices[2],"\n");
  Print(String("",Length(title)+l),"|\n");
  Print(String("",Length(title)-2),indices[1]);
  for i in [3..r] do Print(" - ",indices[i]);od;
  Print("\n");
end);

CHEVIE.IndirectAddData("PrintDiagram",["H3","H4"],t->function(indices,title)
  local i;
  Print(title," ");
  Print(String("",Length(String(indices[1]))-1),"5 \n");
  Print(String("",Length(title)-1),indices[1]," - ",indices[2]," - ",indices[3]);
  if t="H4" then Print(" - ",indices[4]);fi;
  Print("\n");
end);

CHEVIE.IndirectAddData("HighestPowerGenericDegrees",
 ["G24","G27","G29","G33","G34","H3","H4","E6","E7","E8"],
 t->function()local N;
  N:=Sum(CHEVIE.RawData("ReflectionDegrees",t),x->x-1);
  return List(CHEVIE.RawData("CycPolSchurElements",t),
                          x->N-Degree(CycPol(x)));end);

CHEVIE.IndirectAddData("LowestPowerGenericDegrees",
["G24","G27","G29","G33","G34","H3","H4","E6","E7","E8"],
 t->function()return List(CHEVIE.RawData("CycPolSchurElements",t),x->-x[2]);
end);

CHEVIE.IndirectAddData("DecompositionMatrix",
  ["F4","G2","G25","G26"],
  t->function(p)local T, m; 
  T:=CHEVIE.RawData("CharTable",t)(); T.name:=T.identifier; 
  m:=DecompositionMatrix(T mod p);
  return List(BlocksMat(m),c->[c[1],m{c[1]}{c[2]}]);
  end);

CHEVIE.IndirectAddData("DecompositionMatrix",
  ["I","G4_7","G8_15"],
  t->function(n,p)local T, m; 
  T:=CHEVIE.RawData("CharTable",t)(n); T.name:=T.identifier; 
  m:=DecompositionMatrix(T mod p);
  return List(BlocksMat(m),c->[c[1],m{c[1]}{c[2]}]);
  end);

############################################################################
#  G4_22Helper:=function(c,e,x,n,p)
#
#  This function is a helper for char. tables of Hecke algebras G4--G22
#  c is a vector, e an integer vector same length
#  return vector c[i]*(E(n)^p*x^(1/n))^e[i]
#
#  The point of this routine is to avoid unnecessary root extractions
#  during evaluation (i.e., only get n/Gcd(n,e[i])th roots where c[i]<>0)
#
G4_22Helper:=function(c,e,x,n,p)local nz,r,res,root;
  nz:=Filtered([1..Length(c)],i->c[i]<>0*c[i]);
  r:=Gcd(Concatenation(e{nz},[n]));
  root:=GetRoot(x,n/r)*E(n)^(p*r);
# if root<>(GetRoot(x,n)*E(n)^p)^r then Error("roots");fi;
# Print("root=",x,"\n");
  res:=c*root^0;
  res{nz}:=List(nz,i->c[i]*root^(e[i]/r));
  return res;
end;

if not IsBound(CHEVIE.CheckIndexChars) then CHEVIE.CheckIndexChars:=false;fi;

G4_22FetchIndexChars:=function(n,para)local p,T;
  T:=[,,,"G4_7","G4_7","G4_7","G4_7","G8_15","G8_15","G8_15","G8_15","G8_15",
   "G8_15","G8_15","G8_15","G16_22","G16_22","G16_22","G16_22","G16_22",
   "G16_22","G16_22"];
  if not CHEVIE.CheckIndexChars then
     return CHEVIE.RawData("CharInfo",T[n])(n).indexchars;
  fi;
  if not IsBound(CHEVIE.G4_22CachedIndexChars) then
    CHEVIE.G4_22CachedIndexChars:=[];
    CHEVIE.G4_22CachedIndexChars{[4..22]}:=List([4..22],i->[]);
    InfoChevie2("Creating G4_22CachedIndexChars\n");
  fi;
  # test if specialization requires changing indexchars
  p:=PositionProperty(CHEVIE.G4_22CachedIndexChars[n],x->x[1]=para);
  if p<>false then return CHEVIE.G4_22CachedIndexChars[n][p][2];
    InfoChevie2("Using G4_22CachedIndexChars(",para,")\n");
  else return CHEVIE.RawData("HeckeCharTable",T[n])(n,para,[]).indexchars;
  fi;
end;

# res:=partial chartable of Hecke algebra
# rows:= chartable of Hecke algebra for "generic" group G7, G11 or G19
# i:= indexchars to test
# Cheks that indexchars picks different rows. Otherwise picks
# differe,t rows and sets indexchars appropriately.
G4_22Test:=function(res,rows,i)local l,o,p,ic,T;
 T:=[,,,7,7,7,7,11,11,11,11,11,11,11,11,19,19,19,19,19,19,19];
 T:=SPrint("G",T[res.ST]);
 if not IsBound(CHEVIE.G4_22CachedIndexChars) then
    CHEVIE.G4_22CachedIndexChars:=[];
    CHEVIE.G4_22CachedIndexChars{[4..22]}:=List([4..22],i->[]);
    InfoChevie2("Creating G4_22CachedIndexChars\n");
  fi;
  p:=PositionProperty(CHEVIE.G4_22CachedIndexChars[res.ST],
                        x->x[1]=res.parameter);
  if p<>false then 
    InfoChevie2("Using G4_22CachedIndexChars(",res.parameter,")\n");
    ic:=CHEVIE.G4_22CachedIndexChars[res.ST][p][2];
    res.irreducibles:=rows{ic};
    if ic<>i then
      Print("*** WARNING: choice of character restrictions from ",T,
        " for this specialization does not agree with group CharTable\n");
      if not CHEVIE.CheckIndexChars then
        Print("Try again with CHEVIE.CheckIndexChars:=true\n");fi;
    fi;
    return ic;
  fi;
  ic:=i;
  res.irreducibles:=rows{ic};
  if Length(Set(res.irreducibles))=Length(res.classes) then l:=i;
  else
  l:=List(rows,x->Position(rows,x));
  if Length(Set(l))<>Length(res.classes) then
     Error("specialization not semi-simple");fi;
  l:=List(Set(l),x->Filtered([1..Length(l)],i->l[i]=x));
  Print("*** WARNING: bad choice of character restrictions from ",T,
    " for this specialization\n");
  if not CHEVIE.CheckIndexChars then
    Print("Try again with CHEVIE.CheckIndexChars:=true\n");fi;
  o:=Filtered(l,x->Number(i,j->j in x)>1);
  Print(" over-represented by ",Intersection(Union(o),i)," : ",o,"\n");
  Print(" absent : ",Filtered(l,x->Number(i,j->j in x)=0),"\n");
  Print(" Choosing ",List(l,x->x[1]),"\n");
  l:=List(l,x->x[1]);
  res.irreducibles:=rows{l};
  fi;
  Add(CHEVIE.G4_22CachedIndexChars[res.ST],[res.parameter,l]);
  return l;
end;

############################################################################
#  VcycSchurElement(Y,model[,data])
#
#  This function computes the Schur elements for G4-22,  G25-26, G28, G32
#  according to the data computed by M. Chlouveraki.
#  Y is the list of parameters to take in account.
#  model describes the shape of the Schur element: it has the fields
#   .factor=(possibly fractional) vecmonomial
#   .coeff= a constant
#   [nothing] or [.root=vecmonomial] or [.rootUnity]  
#   vcyc= a list of pairs [vecmonomial, cyclotomic polynomial index]
#   rootCoeff=  a constant by which multiply .root before taking root
#  vecmonomial=vector of powers for elts of Y (plus possibly
#     the power to which to raise root or rootUnity)
#  data describes the Galois specifics of the Schur element: it has fields
#   order: in which order to take the variables
#   rootPower: by which E(root)^i multiply .root
VcycSchurElement:=function(arg)local Y,r,data,i,vars,res,n,monomial,nr,root;
  Y:=arg[1];r:=arg[2];n:=Length(Y);
  if Length(arg)=3 then data:=arg[3];vars:=Y{data.order};else vars:=Y;fi;
  monomial:=v->Product([1..Length(v)],i->vars[i]^v[i]);
  if IsBound(r.coeff) then res:=r.coeff;else res:=1;fi;
  if IsBound(r.factor) then res:=res*monomial(r.factor);fi;
  if IsBound(r.root) then
    vars:=vars+0*Product(vars);vars[n+1]:=ChevieIndeterminate(vars);
  elif IsBound(r.rootUnity) then vars[n+1]:=r.rootUnity^data.rootUnityPower;fi;
  res:=res*Product(r.vcyc,
    x->Value(CyclotomicPolynomial(Cyclotomics,x[2]),monomial(x[1])));
  if IsBound(r.root) then
    nr:=Lcm(List(r.root,Denominator));root:=monomial(nr*r.root);
    if IsBound(r.rootCoeff) then root:=root*r.rootCoeff;fi;
    return EvalPolRoot(res,root,nr,data.rootPower);
  else return res;
  fi;
end;

FactorizedSchurElementsOps:=OperationsRecord("FactorizedSchurElementsOps");

FactorizedSchurElementsOps.Format:=function(x,options)local v,res;
  v:=List(x.vcyc,function(l)
    if IsBound(l.cyc) then 
      if IsBound(options.Maple) then
        return SPrint("(",Format(Value(l.cyc,l.monomial),options),")");
      else return SPrint("P",l.cyc,"(",Format(l.monomial,options),")");
      fi;
    else 
      if IsBound(options.Maple) then
        return SPrint("(",Format(Value(l.pol,l.monomial),options),")");
      else
      return SPrint(Format(l.pol,options),
       "(",Format(l.monomial,options),")");
      fi;
    fi;
  end);
  if IsBound(options.GAP) or IsBound(options.Maple) then v:=Join(v,"*");
  else v:=Join(v,""); fi;
  return FormatCoefficient(x.factor,v,options);
end;

FactorizedSchurElementsOps.String:=x->Format(x,rec());
FactorizedSchurElementsOps.Print:=function(x)Print(String(x));end;
FactorizedSchurElementsOps.Value:=function(x,y)return 
  Value(x.factor,y)*Product(x.vcyc,v->Value(v.pol,Value(v.monomial,y)));end;
FactorizedSchurElementsOps.\/:=function(a,b)a:=ShallowCopy(a);
  a.factor:=a.factor/b;return a;end;

CHEVIE.IndirectAddData("SchurElement",["G24","G27","G29","G33","G34",
 "E6","E7","E8","H3","H4"],
t->function(arg)return Value(CycPol(CHEVIE.RawData("CycPolSchurElements",t)
  [Position(CHEVIE.RawData("CharInfo",t)().charparams,arg[1])]),
   -arg[2][1][1]/arg[2][1][2]);
end);

CHEVIE.IndirectAddData("FactorizedSchurElement",["G24","G27","G29","G33",
 "G34","E6","E7","E8","H3","H4"], t->function(arg)local c,q,res,v,e;
#arg= [phi,q] for G24-G34, [phi,q,rootparam] for E6-H4
  c:=CHEVIE.RawData("CycPolSchurElements",t)
      [Position(CHEVIE.RawData("CharInfo",t)().charparams,arg[1])];
  q:=-arg[2][1][1]/arg[2][1][2];
  res:=rec(factor:=c[1]*q^c[2],vcyc:=[],
           operations:=FactorizedSchurElementsOps);
  for v in c{[3..Length(c)]} do
    if IsInt(v) then Add(res.vcyc,rec(monomial:=q,cyc:=v));
    else e:=E(Denominator(v))^Numerator(v);
      Add(res.vcyc,rec(monomial:=q/e,cyc:=1));
      res.factor:=res.factor*e;
    fi;
  od;
  return SimplifyCycDecomposition(res);
end);

CHEVIE.IndirectAddData("FactorizedSchurElement",["G4_7","G8_15","G16_22"],
  t->function(n,p,para,rootpara)local Y,index,ci;
  ci:=CHEVIE.RawData("ReflectionDegrees",t);
  index:=Product(ci(CHEVIE.RawData("Generic",t)))/Product(ci(n));
  Y:=Concatenation(CHEVIE.RawData("GetParams",t)(n,para));
  ci:=CHEVIE.RawData("CharInfo",t)(n);
  ci:=G4_22FetchIndexChars(n,para)[Position(ci.charparams,p)];
  ci:=CHEVIE.RawData("SchurData",t)()[ci];
  ci:=VFactorSchurElement(Y,CHEVIE.RawData("SchurModels",t).(ci.name),ci);
  return ci/index;
end);

CHEVIE.IndirectAddData("FactorizedSchurElement",["G2","F4","G25","G26","G32"],
  t->function(arg)local Y,ci;
  Y:=Concatenation(arg[2]{CHEVIE.RawData("HyperplaneRepresentatives",t)});
  ci:=CHEVIE.RawData("SchurData",t)[
    Position(CHEVIE.RawData("CharInfo",t)().charparams,arg[1])];
  return ApplyFunc(VFactorSchurElement,
    Concatenation([Y,CHEVIE.RawData("SchurModels",t).(ci.name),ci],
    arg{[3..Length(arg)]}));
end);

CHEVIE.IndirectAddData("SchurElement",["G4_7","G8_15","G16_22"],
  t->function(n,p,para,rootpara)local Y,index,ci;
  Y:=Concatenation(CHEVIE.RawData("GetParams",t)(n,para));
  ci:=CHEVIE.RawData("ReflectionDegrees",t);
  index:=Product(ci(CHEVIE.RawData("Generic",t)))/Product(ci(n));
  ci:=CHEVIE.RawData("CharInfo",t)(n);
  ci:=G4_22FetchIndexChars(n,para)[Position(ci.charparams,p)];
  ci:=CHEVIE.RawData("SchurData",t)()[ci];
  ci:=VcycSchurElement(Y,CHEVIE.RawData("SchurModels",t).(ci.name),ci);
  return ci/index;
end);

CHEVIE.IndirectAddData("SchurElement",["F4","G25","G26","G32"],
  t->function(arg)local Y,ci;
  Y:=Concatenation(arg[2]{CHEVIE.RawData("HyperplaneRepresentatives",t)});
  ci:=CHEVIE.RawData("SchurData",t)[
    Position(CHEVIE.RawData("CharInfo",t)().charparams,arg[1])];
  return VcycSchurElement(Y,CHEVIE.RawData("SchurModels",t).(ci.name),ci);
end);

SimplifyCycDecompositionJ:=function(r)local i,p,p1,v,drop,sterm,pre;
  sterm:=v->SPrint("P",v.cyc,"(",v.monomial,")");
  pre:=function(arg)local i;
#   for i in arg do Print(sterm(r.vcyc[i]));od;
#   Print("=>");
    i:=arg;
  end;
  drop:=function(arg)
 #  Print(sterm(r.vcyc[i]),"\n");
    r.vcyc:=r.vcyc{Difference([1..Length(r.vcyc)],arg)};
    i:=1;
  end;
  i:=1;
#   SortBy(r.vcyc,v->[v.cyc,v.monomial.elm[1]]);
  while i<=Length(r.vcyc) do
    v:=r.vcyc[i];
    p:=Position(r.vcyc,rec(monomial:=E(3)*v.monomial,cyc:=v.cyc));
    if p<>false then
      p1:=Position(r.vcyc,rec(monomial:=E(3)^2*v.monomial,cyc:=v.cyc));
      if p1<>false and Gcd(v.cyc,3)=1 then 
        # phi_d(x)phi_d(E3x)phi_d(E3^2x)=phi_d(x^3) if Gcd(d,3)=1
        pre(i,p,p1);
        v.monomial:=v.monomial^3;
        drop(p,p1);
      elif v.cyc in [1,2] then
        pre(i,p);
        # phi_d(x)phi_d(E3x)=phi_3d(x) if d in [1,2]
        v.monomial:=v.monomial*E(3)^2;v.cyc:=3*v.cyc;
        drop(p);
      fi;
    fi;
    p:=Position(r.vcyc,rec(monomial:=-v.monomial,cyc:=v.cyc));
    if p<>false and Gcd(v.cyc,2)=1  then
      pre(i,p); # phi_d(x)phi_d(-x)=(-1)^phi(d)phi_d(x^2) if d odd
      v.monomial:=v.monomial^2;r.factor:=(-1)^Phi(v.cyc)*r.factor;
      drop(p); 
    elif p<>false and v.cyc=2 then
      pre(i,p); # phi_2(x)phi_2(-x)=-phi_1(x^2)
      v.monomial:=v.monomial^2;v.cyc:=1;r.factor:=-r.factor;
      drop(p);
    fi;
    p:=Position(r.vcyc,rec(monomial:=v.monomial,cyc:=2*v.cyc));
    if p<>false and Gcd(v.cyc,2)=1 then
      pre(i,p); # phi_d(x)phi_2d(x)=phi_d(x^2)
      v.monomial:=v.monomial^2;
      drop(p);
    fi;
    p:=Position(r.vcyc,rec(monomial:=E(3)/v.monomial,cyc:=v.cyc));
    if p<>false and v.cyc=1 then
      pre(i,p);
      r.factor:=r.factor*-E(3)/v.monomial;
      v.monomial:=E(3)*v.monomial;v.cyc:=3;
      drop(p);
    fi;
    if IsMvp(v.monomial) and v.monomial.coeff[1]=-1 then
      pre(i);
      if Gcd(v.cyc,2)=1 then
        if v.cyc=1 then r.factor:=-r.factor;fi;
        v.monomial:=-v.monomial;v.cyc:=2*v.cyc;
      elif Gcd(v.cyc,4)=2 then
        if v.cyc=2 then r.factor:=-r.factor;fi;
        v.monomial:=-v.monomial;v.cyc:=v.cyc/2;
      else  v.monomial:=-v.monomial;
      fi;
      drop();
    fi;
    i:=i+1;
  od;
  return r;
end;

SimplifyCycDecompositionM:=function(res)local simplify,l;
  res.vcyc:=List(res.vcyc,function(r)local nr,k,pow;
      nr:=r.monomial; k:=nr.elm[1].coeff;
# We find the unique power of the Puiseux r.monomial such that
# - Each variable appears to an integral power.
# - The gcd of these powers is 1.
# - The first variable appears to a positive power.
      pow:=SignInt(Numerator(k[1]))*AbsInt(Gcd(List(k,Numerator)))/
         Lcm(List(k,Denominator));
      return rec(coeff:=nr.coeff[1],pol:=r.pol,
          monomial:=(nr/nr.coeff[1])^(1/pow),power:=pow);end);
# the following function uses CycPol in order to obtain the factorization
# of the product of cyclotomic polynomials evaluated on different powers of the
# same monomial. The argument is a list of records with fields
#  coeff, pol, monomial and power representing pol(coeff*(monomial)^power)
simplify:=function(fil)local Prod,C,coef,P,a,f,D,m;
# Print("fil=",fil,"\n");
  D:=Lcm(List(fil,x->Denominator(x.power)));m:=fil[1].monomial;
# We use an indeterminate representing m^(1/D)
  Prod:=Product(List(fil,x->Value(x.pol,x.coeff*X(Cyclotomics)^(D*x.power))));
# If all the terms appearing in Prod (shifted to have valuation 0) are integral
# powers of some x^a, where a|D, then we change the indeterminate to m^(a/D)
  f:=Filtered([1..Length(Prod.coefficients)],i->Prod.coefficients[i]<>0);
  a:=Gcd(Gcd(f-1),D);
  if a>1 then
    f:=Filtered([1..Length(Prod.coefficients)],i->(i-1)mod a=0);
    Prod.coefficients:=Prod.coefficients{f};
    Prod.valuation:=(Prod.valuation+f[1]-1)/a;
    D:=D/a;
  fi;
  C:=CycPol(Prod); 
  P:=Copy(C);P.coeff:=1;P.valuation:=0;
  return rec(factor:=C.coeff*m^(C.valuation/D),pol:=P,monomial:=m^(1/D));
end;
  l:=List(CollectBy(res.vcyc,x->x.monomial),simplify);
  res.factor:=res.factor*Product(List(l,x->x.factor));
  res.vcyc:=List(l,x->rec(monomial:=x.monomial,pol:=x.pol));
  res.operations:=FactorizedSchurElementsOps;
  return res;
end;

SimplifyCycDecomposition:=function(res)local resM,resJ,v,IsMon;
  IsMon:=x->IsMvp(x) and Length(x.coeff)<=1;
#We are going to create two sublists of res:
#resM which works with SimplifyCycDecompositionM
#resJ which works with SimplifyCycDecompositionJ
# In resM we are going to have the same factor as res, if
# res.factor is a monomial, and resJ.factor=res.factor/resM.factor
# resJ is only used for non-Mvp algebras
  resM:=rec(factor:=1,vcyc:=[],operations:=FactorizedSchurElementsOps);
  resJ:=rec(factor:=1,vcyc:=[],operations:=rec());
  if IsMon(res.factor) then resM.factor:=res.factor;
  elif IsCyc(res.factor) then resM.factor:=Mvp(res.factor);
  else resJ.factor:=res.factor;
  fi;
#Now, in resM.vcyc, we are going to put the elements v of res.vcyc
#such that v.monomial is a monomial multiplied by a root of unity 
  for v in res.vcyc do
    if IsMon(v.monomial) and AsRootOfUnity(v.monomial.coeff[1])<>false 
    then Add(resM.vcyc,v);
    else Add(resJ.vcyc,v);fi;
  od;
  for v in resM.vcyc do 
    v.pol:=CycPol(CyclotomicPolynomial(Cyclotomics,v.cyc));
  od;
  if not IsBound(CHEVIE.nosimplify) then
    resM:=SimplifyCycDecompositionM(resM);
  fi;
  if resJ.vcyc<>[] or resJ.factor<>1 then
    resJ:=SimplifyCycDecompositionJ(resJ);
    v:=ScalMvp(resM.factor);
    if v<>false then resM.factor:=v;fi;
    resM.factor:=resM.factor*resJ.factor;
    Append(resM.vcyc,resJ.vcyc);
  fi;
  return resM;
end;

############################################################################
#  FactorizedSchurElement(Y,data,model)
#
#  This function computes the Schur elements for G4-22,  G25-26, G28, G32
#  according to the data computed by M. Chlouveraki.
#  Y is the list of parameters to take in account.
#

# arguments: (parameters Y, schurModel r [,schur data])
VFactorSchurElement:=function(arg)
  local Y,r,data,vars,res,n,monomial,den,f,v,m,resM,resJ;
  Y:=arg[1];r:=arg[2];
  n:=Length(Y);
  if Length(arg)>=3 then data:=arg[3];vars:=Y{data.order};else vars:=Y;fi;
  monomial:=v->Product([1..Length(v)],i->vars[i]^v[i]);
  res:=rec(factor:=1,vcyc:=[],operations:=rec());
  if IsBound(r.coeff) then res.factor:=r.coeff;fi;
  if IsBound(r.factor) then res.factor:=res.factor*monomial(r.factor);fi;
  if IsBound(r.root) then
    den:=Lcm(List(r.root,Denominator));
    f:=monomial(r.root*den);
    if IsBound(r.rootCoeff) then f:=f*r.rootCoeff;fi;
    if IsBound(arg[4]) and r.root=[1,-1,1,-1]/2 then
         vars[n+1]:=Product(arg[4]);
    else vars[n+1]:=GetRoot(f,den);
    fi;
    if IsBound(data) then vars[n+1]:=vars[n+1]*data.rootPower;fi;
#   Print("root=",r.root,"\n");
#   Print(den,"-th root.",data[n+2]," of ","f=",f,"=>",vars[n+1],"\n");
  elif IsBound(r.rootUnity) then vars[n+1]:=r.rootUnity^data.rootUnityPower;
  fi;
  for v in r.vcyc do
    m:=monomial(v[1]);f:=ScalMvp(m);
    if f<>false and (IsCyc(f) or Degree(f)=0) then
      res.factor:=res.factor*Value(CyclotomicPolynomial(Cyclotomics,v[2]),f);
    else Add(res.vcyc,rec(monomial:=m,cyc:=v[2]));
    fi;
  od;
  if res.factor=0 or res.vcyc=[] then return res.factor;fi;
  return SimplifyCycDecomposition(res);
end;

############################################################################
# How to interpret W-graphs for complex reflection groups with one orbit of
# reflections, for Hecke(W,[vars]).

WGraph2Representation:=function(a,vars)local pos,nodes,n,dim,R,j,r,k;
  nodes:=a[1];
  pos:=function(n,j)local p;
    if IsList(n[1]) then p:=PositionProperty(n,x->j in x);
      if p=false then p:=Length(vars);fi;
    elif j in n then p:=1; else p:=2; fi;
    return p;
  end;
  n:=Maximum(Flat(nodes));# number of generators
  dim:=Length(nodes);
  R:=List([1..n],j->DiagonalMat(List([1..dim],k->vars[pos(nodes[k],j)])));
  for r in a[2] do for k in [3,4] do
    if IsList(r[k]) then
      for j in [2,4..Length(r[k])] do R[r[k][j-1]][r[k-2]][r[5-k]]:=r[k][j];od;
    else
      j:=Filtered([1..n],i->pos(nodes[r[k-2]],i)<pos(nodes[r[5-k]],i));
      R{j}[r[k-2]][r[5-k]]:=List(j,x->r[k]);
    fi;
  od;od;
  return R;
end;
