#############################################################################
##
#A  hastype.g  CHEVIE library    Jean Michel  5-1999
##
#Y  Copyright (C) 1999 Lehrstuhl D fur Mathematik, RWTH Aachen,
#Y   and   University Paris VII.
##
##  This  file contains  operations  for reflexion  groups or  reflexion
##  cosets  which are  classified  (whose  decomposition in  irreducible
##  components is known). It builds answers by combining the answers for
##  irreducible types fetched from the CHEVIE tables. Here 'irreducible'
##  includes descents of  scalars. The code for irreducible  types is in
##  refltype.g .
##
##  A group or coset is classified  when its field .type has been filled
##  This field is accessed by the function 'ReflectionType' .

# ReflectionGroup from a ReflectionType
ReflectionGroup:=function(arg)local t,g,res,o,i,r;
  if Length(arg)=0 then return CoxeterGroup();fi;
  for t in arg do
    if t.series<>"ST" then g:=CoxeterGroup(t);
    elif IsBound(t.ST) then g:=ComplexReflectionGroup(t.ST);
    else g:=ComplexReflectionGroup(t.p,t.q,t.rank);
    fi;
    if t.series="ST" and IsBound(t.cartanType)then
      g.roots:=ShallowCopy(g.roots);
      g.simpleCoroots:=ShallowCopy(g.simpleCoroots);
      o:=Set(g.orbitRepresentative);
      if Length(o)=2 then
        o:=Filtered([1..Length(g.roots)],i->g.orbitRepresentative[i]=o[2]);
	g.roots{o}:=g.roots{o}*t.cartanType;
	o:=Intersection(o,[1..Length(g.simpleCoroots)]);
	g.simpleCoroots{o}:=g.simpleCoroots{o}/t.cartanType;
      else for i in [2..Length(o)] do
        r:=Filtered([1..Length(g.roots)],j->g.orbitRepresentative[j]=o[i]);
	g.roots{r}:=g.roots{r}*t.cartanType[i-1];od;
	r:=Intersection(r,[1..Length(g.simpleCoroots)]);
	g.simpleCoroots{r}:=g.simpleCoroots{r}/t.cartanType[i-1];
      fi;
      g.matgens:=List(g.generatingReflections,
                  j->Reflection(g.roots[j],g.simpleCoroots[j]));
    fi;
    if IsBound(res) then res:=res*g;
    else res:=g;
    fi;
  od;
  return res;
end;

HasTypeOps:=OperationsRecord("HasTypeOps");

###########################################################################
##
#F  CharName(W,p[,option]) . . . . . . . . Name of character with .charparam p
#    option may be "TeX"
##
HasTypeOps.CharName:=function(W,p,option)local t;
  t:=ReflectionType(W);
  return Join(List([1..Length(t)],i->CharName(t[i],p[i],option)));
end;

HasTypeOps.CharNames:=function(W,option)
  return List(ChevieCharInfo(W).charparams,x->CharName(W,x,option));
end;

HasTypeOps.NrConjugacyClasses:=W->Product(List(ReflectionType(W),
  NrConjugacyClasses));

#############################################################################
##
#F  HasTypeOps.ConjugacyClasses( <W> ) . . . . . . . ConjugacyClasses,
#F  using the classification
##  
HasTypeOps.ConjugacyClasses:=function(W)local t,cl;
  t:=ChevieClassInfo(W);
  if IsSpets(W) then
    if t=false then return SpetsOps.ConjugacyClasses(W);
    else cl:=List(t.classtext,x->ConjugacyClass(Group(W),
                                            EltWord(Group(W),x)*W.phi));
    fi;
  else
    if t=false then return PermGroupOps.ConjugacyClasses(W);
    else cl:=List(t.classtext,w->ConjugacyClass(W,EltWord(W,w)));
    fi;
  fi;
  if IsBound(t.classes) then 
    return Zip(cl,t.classes,function(a,n)a.size:=n;return a;end);
  else return cl;
  fi;
end;

HasTypeOps.ClassName:=function(W,i,opt)local n;
  n:=ChevieClassInfo(W).classnames[i];
  if IsBound(opt.TeX) then return n;fi;
  return String(Replace(n,"_","","\\tilde ","~","{","","}","","\\zeta","E"));
end;

#############################################################################
##
#F  HasTypeOps.ChevieClassInfo( <W> ) . . . info on conjugacy classes
##
HasTypeOps.ChevieClassInfo:=function(W) local tmp,res,inc,get;
  if IsSpets(W) then inc:=Group(W).rootInclusion;else inc:=W.rootInclusion;fi;
  tmp:=List(ReflectionType(W),ChevieClassInfo);

  get:=f->Cartesian(List(tmp,x->x.(f)));
  
  if ForAny(tmp,x->x=false) then return false;fi;
  if Length(tmp)=1 then res:=tmp[1];# keep extra fields for irreducible type
  else res:=rec();
  fi; 
  res.classtext:=List(get("classtext"),x->inc{Concatenation(x)});
  res.classnames:=List(get("classnames"),Join);
  if Length(tmp)=0 then
     res.classparams:=[[]];res.orders:=[1];res.classes:=[1];
  else
    if ForAll(tmp,x->IsBound(x.classparams)) then 
       res.classparams:=get("classparams");
    fi;
    if ForAll(tmp,x->IsBound(x.orders)) then 
      res.orders:=List(get("orders"),Lcm);
    fi;
    if ForAll(tmp,x->IsBound(x.classes)) then 
      res.classes:=List(get("classes"),Product);
    fi;
  fi;
  return res;
end;

#############################################################################
##
#F  WordsClassRepresentatives( <W> ) . . . . representatives of conjugacy 
#F  classes of <W> as Words.
##  
WordsClassRepresentatives:=W->ChevieClassInfo(W).classtext;

#############################################################################
##
#F  HasTypeOps.BraidRelations( <W> ) . . . see corresponding dispatcher 
#F  function
##
HasTypeOps.BraidRelations:=W->Concatenation(List(ReflectionType(W),
  t->List(BraidRelations(t),x->List(x,y->W.rootInclusion{y}))));
  
#############################################################################
##
#F  HasTypeOps.CharTable( <W> ) . . . . . . . . . . . 'CharTable', using
#F  the classification
##
HasTypeOps.CharTable:=function(W)local t, l, tbl, cl, d;

  l:=List(ReflectionType(W),ReflTypeOps.CharTable);
  if ForAny(l,tbl->tbl=false) then 
    if IsSpets(W) then tbl:=SpetsOps.CharTable(W);
    else tbl:=PermGroupOps.CharTable(W);
    fi;
  else
    if Length(l)=0 then 
      tbl:=rec(size:=1,order:=1,centralizers:=[1],orders:=[1],
        irreducibles:=[[1]],powermap:=[],operations:=CharTableOps);
    else tbl:=l[1];
      for t in l{[2..Length(l)]} do
	tbl:=CharTableDirectProduct(tbl,t); 
	Unbind(tbl.fusionsource); Unbind(tbl.fusions);
      od;
    fi;
  fi;
  
  tbl.irredinfo:=List(ChevieCharInfo(W).charparams,
                      x->rec(charparam:=x,charname:=CharName(W,x)));

  # for a coset, InitClassesCharTable which is called from
  # CharTableDirectProduct uses a wrong value of size (centralizers[1])
  # so we must fix the classes
  tbl.classes:=List(tbl.centralizers,x->tbl.size/x);

  t:=ChevieClassInfo(W);
  if t<>false then Inherit(tbl,t);
   tbl.classnames:=List(tbl.classnames,
     n->String(Replace(n,"_","","\\tilde ","~")));
  fi;

  if not IsSpets(W) and not IsBound(tbl.powermap) then
    Print("warning: powermap not bound\n");
    tbl.powermap:=[];
    cl:=List(ConjugacyClasses(W),Representative);
    for d in Reversed(Set(Factors(tbl.size))) do
    tbl.powermap[d]:=List(cl,x->PositionClass(W,x^d));
    od;
  fi;

  tbl.operations.StringEntry := function(x)
    if x=0*x then return ".";else return Format(x);fi;end;

  tbl.name:=ReflectionName(W);
  tbl.identifier:=tbl.name;
  return tbl;
end;

#############################################################################
##
#F  HasTypeOps.Representation(<W>, i) . .  'Representation', using
#F  the classification
##
HasTypeOps.Representation:=function(W,i)local l,t,reps,tensorat,dims,ind,res;
  t:=ReflectionType(W); l:=List(t,NrConjugacyClasses);
  if Length(t)=1 then return ReflTypeOps.Representation(t[1],i);fi;
  ind:=CartesianAt(l,i);
  if ind=false then Error(W," has ",Product(l)," conjugacy classes\n");fi;
  reps:=List([1..Length(t)],i->ReflTypeOps.Representation(t[i],ind[i]));
  if ForAny(reps,r->r=false) then return false;fi;
  tensorat:=function(i,m,dims) # id(d1)tensor id(d2)..tensor(m) at i tensor..
    return List([1..Product(dims)],k->List([1..Product(dims)],
    function(l)local r,c; r:=CartesianAt(dims,k); c:=CartesianAt(dims,l);
      if ForAny([1..Length(dims)],j->r[j]<>c[j] and j<>i) then return 0;
      else return m[r[i]][c[i]];fi;end));
  end;
  if IsSpets(W) then
    dims:=List(reps,x->Length(x.F[1]));
    res:=rec(gens:=[],
      F:=List([1..Product(dims)],k->List([1..Product(dims)],
	function(l)local r,c; r:=CartesianAt(dims,k); c:=CartesianAt(dims,l);
	 return Product([1..Length(reps)],i->reps[i].F[r[i]][c[i]]);end)));
    for i in [1..Length(t)] do
      res.gens{t[i].indices}:=List(reps[i].gens,m->tensorat(i,m,dims));
    od;
  else
    dims:=List(reps,x->Length(x[1]));res:=[];
    for i in [1..Length(t)] do
      res{t[i].indices}:=List(reps[i],m->tensorat(i,m,dims));
    od;
    return res;
  fi;
end;

#############################################################################
##
#F  HasTypeOps.Representations( <W> ) . .  'Representations', using
#F  the classification
##
HasTypeOps.Representations:=function(arg)local W,inds;
  W:=arg[1]; 
  if Length(arg)=2 then inds:=arg[2];else inds:=[1..NrConjugacyClasses(W)];fi;
  if IsList(inds) then return List(inds,i->Representation(W,i));
  else return Representation(W,inds);
  fi;
end;

#############################################################################
##
#F  HasTypeOps.WGraph(<W>, i) . .  using the classification
##
HasTypeOps.WGraph:=function(W,i)local t;
  t:=ReflectionType(W); 
  if Length(t)=1 then return ReflTypeOps.WGraph(t[1],i);fi;
  Error("not implemented for non-irreducible types");
end;

############################################################################
##
#F  FakeDegree( <W>, <p>, <q> ) . . .Fake Degree of char with charparam <p>
##  
##  This   returns the   polynomial  describing the   multiplicity of  the
##  character chi with .charparam  p in the graded  version of the regular
##  representation  given  by the quotient  S/I  where S  is the symmetric
##  algebra of the reflection representation and  I is the ideal generated
##  by the homogenous invariants of positive degree in S.
##  
FakeDegree:=function(W,p,q)local t;
  t:=ReflectionType(W);
  t:=List([1..Length(t)],i->ReflTypeOps.FakeDegree(t[i],p[i],q));
  if ForAny(t,x->x=false) then return false;
  else return Product(t)*q^0;
  fi;
end;

############################################################################
##
#F  FakeDegrees( <W>, <q> ) . . . . . .  Fake Degrees of group <W>
##
##  This returns the list of polynomials describing the multiplicity of
##  each character in the graded version of the regular representation given
##  by the quotient S/I where S is the symmetric algebra of the reflection
##  representation and I is the ideal generated by the homogenous invariants
##  of positive degree in S.
##  The ordering of the result corresponds to the ordering of the characters 
##  in the  CharTable.
##
#
HasTypeOps.FakeDegrees:=function(W,q)local P,p,f;
  P:=[];
  for p in CharParams(W) do
    f:=FakeDegree(W,p,q);
    if f=false then 
      if IsSpets(W) then return SpetsOps.FakeDegrees(W,q);
      else return PermRootOps.FakeDegrees(W,q);
      fi;
    fi;
    Add(P,f);
  od;
  return P;
end;

#############################################################################
##
#F  ReflectionDegrees( <W>)  . . . . . . . degrees as a reflection group
##
##  Returns the degrees of the  reflection group W.
##  
HasTypeOps.ReflectionDegrees:=function(W)local d,ir,M,WF;
  d:=Concatenation(List(ReflectionType(W),ReflectionDegrees));
  if not IsSpets(W) then 
    return Concatenation([W.semisimpleRank+1..W.rank]*0+1,d);
  fi;
  WF:=W;W:=Group(WF);
  if W.rank=W.semisimpleRank then return d;fi;
  # prepend the (factors=eigenvalues of phi) where W acts trivially
  ir:=PermRootOps.IndependentRoots(W);
  M:=W.operations.BaseX(W);
  M:=M*WF.F0Mat*M^-1;
  ir:=[W.semisimpleRank+1..W.rank];
  return Concatenation(List(EigenvaluesMat(M{ir}{ir}),x->[1,x]),d);
end;

HasTypeOps.ReflectionCoDegrees:=function(W)local WF,ir,M,d;
  d:=Concatenation(List(ReflectionType(W),ReflectionCoDegrees));
  if not IsSpets(W) then 
    return Concatenation([W.semisimpleRank+1..W.rank]*0-1,d);
  fi;
  WF:=W;W:=Group(WF);
  if W.rank=W.semisimpleRank then return d;fi;
  # prepend the (cofactors=eigenvalues of phi^-1) where W acts trivially
  ir:=PermRootOps.IndependentRoots(W);
  M:=W.operations.BaseX(W);
  M:=M*WF.F0Mat*M^-1;
  ir:=[W.semisimpleRank+1..W.rank];
  return Concatenation(List(ComplexConjugate(EigenvaluesMat(M{ir}{ir})),
     x->[-1,x]),d);
end;

#############################################################################
##
#F  HasTypeOps.PrintDiagram( <W> )  
##  
##  For a Spets information 
##  about the action of <WF>.phi on the Dynkin diagram is additionally printed.
##  
HasTypeOps.PrintDiagram:=function(W)
  PrintDiagram(List(ReflectionType(W),function(t)
    t:=ShallowCopy(t);
    if IsSpets(W) then
      t.orbit:=List(t.orbit,function(a)local H;
	a:=ShallowCopy(a); H:=Group(W);
	a.indices:=H.reflectionsLabels{a.indices};
	return a;end);
      if t.twist<>() then
	t.twist:=RestrictedPerm(W.phi^Length(t.orbit),t.orbit[1].indices);
      fi;
    else
      t.indices:=W.reflectionsLabels{t.indices};
    fi;
    return t;end));
end;

#############################################################################
##
#F  HasTypeOps.ReflectionName(<W>)  see dispatcher function
##  Gives a string which describes the isomorphism type of W.  
##  
##  For a Spets, An orbit of
##  phi on the  components is put in brackets  if of length x greater than
##  1, and  is  preceded by  the  order of  phi^x on it,  e.g. 2(A2xA2xA2)
##  denotes 3 components A2  permuted by phi,  and such that phi^3 induces
##  the non-trivial diagram automorphism on any of them, while 3D4 denotes
##  an orbit of  length 1 on  which phi is of order  3.  
##    If the coset is not semi-simple, its toral part is added as a
##  product of cyclotomic factors over the minimum possible field.
##  
HasTypeOps.ReflectionName:=function(W,option)local res,t,i,total,l;
  t:=ReflectionType(W); res:="";total:=0;
  for i in [1..Length(t)] do
    Append(res,ReflectionName(t[i],option));
    if IsSpets(W) then
      l:=Group(W).rootInclusion{Concatenation(List(t[i].orbit,T->T.indices))};
    else l:=W.rootInclusion{t[i].indices};
    fi;
    if l<>total+[1..Length(l)] then
 # added JM 3 oct. 2000 so that different reflection subgroups have
 # different reflection names: this is necessary in 'storefusion'
      if IsBound(option.TeX) then 
           PrintToString(res,"\\langle ",Join(l),"\\rangle ");
      else PrintToString(res,"<",Join(l),">");fi;
    fi;
    if i<Length(t) then 
      if IsBound(option.TeX) then Append(res,"\\times ");
      else Append(res,"x");fi;
    fi;
    total:=total+Length(l);
  od;
  if IsSpets(W) then 
    t:=Group(W).rank-Group(W).semisimpleRank ;
    if t>0 then
      i:=Copy(option);
      if not IsBound(i.Cyc) then i.expand:=true;fi;
      if res<>"" then Append(res,".");fi;
      l:=CycPol(Concatenation([1,0],List(
        Filtered(ReflectionDegrees(W),x->x[1]=1),x->AsRootOfUnity(x[2]))));
      l.vname:="q";
      Append(res,Format(l,i));
    fi;
  else
    t:=W.rank-W.semisimpleRank ;
    if t>0 then
      if res<>"" then Append(res,".");fi;
      Append(res,"(q-1)"); 
      if t>1 then 
        if IsBound(option.TeX) then PrintToString(res,"^{",t,"}");
        else PrintToString(res,"^",t);fi;
      fi;
    fi;
  fi;
  if res="" then res:=".";fi;
  return String(res);
end;

HasTypeOps.ChevieCharInfo:=function(W)local res,t,p,f;
  t:=ReflectionType(W);
  p:=List(t,ChevieCharInfo);
  if Length(t)=1 then res:=ShallowCopy(p[1]);
    # keep extra fields when irreducible
  else res:=rec();
  fi; 
  if ForAll(p,x->IsBound(x.charparams)) then 
    res.charparams:=Cartesian(List(p,x->x.charparams));
  fi;
  if Length(t)=1 then return res;fi;
  if ForAll(p,x->IsBound(x.charnames)) then 
    res.charnames:=List(Cartesian(List(p,x->x.charnames)),Join);
  fi;
  for f in ["positionId","positionDet"] do
    if ForAll(p,x->IsBound(x.(f))) then 
      res.(f):=PositionCartesian(List(p,x->Length(x.charparams)),
                                 List(p,x->x.(f)));
    fi;
  od;
  for f in ["b","B","a","A"] do
    if ForAll(p,x->IsBound(x.(f))) then 
      res.(f):=List(Cartesian(List(p,x->x.(f))),Sum);
    fi;
  od;
  return res;
end;

HasTypeOps.LowestPowerGenericDegrees:=function(W)local ci;
  ci:=ChevieCharInfo(W);
  if not IsBound(ci.a) then Error("no LowestPowerGenericDegrees for ",W);fi;
  return ci.a;
end;

HasTypeOps.HighestPowerGenericDegrees:=function(W)local ci;
  ci:=ChevieCharInfo(W);
  if not IsBound(ci.A) then Error("no HighestPowerGenericDegrees for ",W);fi;
  return ci.A;
end;

HasTypeOps.Invariants:=function(W)local V,i,N;
  V:=Parent(W);
  i:=List(ReflectionType(W),function(t)local H,ir,i;
    H:=ReflectionGroup(t);
    if CartanMat(V,t.indices)<>CartanMat(H) then
      Error("not standard Cartan matrix: invariants not implemented");
    fi;
    ir:=PermRootOps.IndependentRoots(H);
    i:=Invariants(t);
    if i=false then return false;fi;
    return List(Invariants(t),f->function(arg)
#     Print("t=",t," H=",H,"\n");
      return ApplyFunc(f,H.simpleCoroots{ir}^-1*List(ir,i->
       PermRootOps.Coroot(V,W.rootInclusion[t.indices[i]]))*arg);end);
      end);
  if false in i then return false;fi;
  i:=Concatenation(i);
  if IsCoxeterGroup(W) then N:=W.simpleRoots;
  else N:=W.roots{PermRootOps.IndependentRoots(W)};
  fi;
  N:=NullspaceMat(TransposedMat(N));
  Append(i,List(N,v->function(arg)return v*arg;end));
  return i;
end;

# Fo an irreducible type, reps contain:
# .duflo,  .reps: elements of W represented as images of simple roots
# .character: decomposition of left cell in irreducibles
HasTypeOps.KLeftCellRepresentatives:=function(W)local n,res;
  n:=[];
  res:=List(ReflectionType(W),function(t)local R,rr,f;
    R:=ReflectionGroup(t);
    Add(n, NrConjugacyClasses(R));
    rr:=KLeftCellRepresentatives(t);
    if rr=false then return false;fi;
    return List(rr,function(r)local f;r:=ShallowCopy(r);
      f:=l->W.rootInclusion{t.indices{CoxeterWord(R,
	PermListList(R.roots,R.roots*R.roots{l}))}};
      r.duflo:=f(r.duflo);r.reps:=List(r.reps,f);Add(r.reps,r.duflo);
    return r;end);end);
  if Length(res)=0 then return;fi;
  if false in res then return false;fi;
  return List(Cartesian(res), function(l)local r;
    r:=rec(operations:=LeftCellOps,isDomain:=true,group:=W);
    r.duflo:=EltWord(W,Concatenation(List(l,x->x.duflo)));
    r.reps:=List(Cartesian(List(l,x->x.reps)),v->EltWord(W,Concatenation(v)));
    r.reps:=Difference(r.reps,[r.duflo]);
    r.character:=List(Cartesian(List(l,x->x.character)),
      p->PositionCartesian(n,p));
    return r;end);
end;
  
HasTypeOps.DecompositionMatrix:=function(W,p)local t;
  t:=List(ReflectionType(W),t->ReflTypeOps.DecompositionMatrix(t,p));
  if ForAny(t,x->x=false) then
    Error("DecompositionMatrix not implemented for ",W,"\n");
    return false;
  else return List(Cartesian(t),x->List(Cartesian(x),Product));
  fi;
end;

HasTypeOps.AdjointFundamentalGroup:=function(W)
  return Concatenation(List(ReflectionType(W),function(t)local s,f,b,c;
    s:=Concatenation([1..t.rank],[Maximum(t.degrees)*t.rank]);
    f:=Filtered([1..Length(W.roots)],i->ForAll([1..W.semisimpleRank],j->
      j in t.indices or W.roots[i][j]=0));
    b:=Minimum(List(W.roots{f},Sum));
    b:=MappingPermListList(s,
      Concatenation(t.indices,[First(f,i->Sum(W.roots[i])=b)]));
    c:=MappingPermListList([1..2*W.N],W.rootInclusion);
    return List(AdjointFundamentalGroup(t),x->(x^b)^c);
    end));
end;

HasTypeOps.ParabolicRepresentatives:=function(W)local t,res;
  if IsCoxeterGroup(W) then return AbsCoxOps.ParabolicRepresentatives(W);fi;
  res:=List(ReflectionType(W),function(t)local r,R;
     r:=ReflTypeOps.ParabolicRepresentatives(t);
     if r=false then
       R:=ReflectionSubgroup(W,W.rootInclusion{t.indices});
       return PermRootOps.ParabolicRepresentatives(R);
     elif ForAll(r,x->ForAll(x,y->y in [1..t.rank])) then
       return List(r,x->W.rootInclusion{t.indices{x}});
     else R:=ReflectionSubgroup(W,W.rootInclusion{t.indices});
       return List(r,x->R.rootInclusion{x});
     fi;end);
  return List(Cartesian(res),Concatenation);
end;
