Cycling:=function(b) local M,w,l,res;
  M:=b.monoid;l:=Length(b.elm);
  if l=0 then return [b,M.identity];fi;
  w:=M.DeltaAction(b.elm[1],-b.pd);
  if Length(b.elm)=1 then return [M.Elt([w],b.pd),w];fi;
  return
    [GarsideEltOps.Normalize(M.Elt(M.AddToNormal(b.elm{[2..l]},w),b.pd)),w];
end;

DeCycling:=function(b) local M,w;
  M:=b.monoid;
  if Length(b.elm)=0 then return [b,M.Elt([])];fi;
  w:=M.Elt([b.elm[Length(b.elm)]])^-1;
  return [b^w,w];
end;

# returns [sliding(b),r] such that b^r=sliding(b)
Sliding:=function(b)local r;
  r:=PreferredPrefix(b);
  return [PositiveSimpleConjugation(b,r),r];
end;

RandomBraid:=function(M,l)
  return M.B(List([1..l],x->Random([1..M.nrAtoms])));end;

revPrefix:=b->PreferredPrefix(ReversedWord(b))^-1;

test:=function(arg)local b,v,n; b:=arg[1];v:=[];
  if Length(arg)=1 then n:=10;else n:=arg[2];fi;
  Add(v,Sum([1..n],i->[Length(ConjugacySet(b,"SS")),Dtime()])/n);
  Add(v,Sum([1..n],i->[Length(ConjugacySet(b,"USS")),Dtime()])/n);
  Add(v,Sum([1..n],i->[Length(ConjugacySet(b,"SC")),Dtime()])/n);
  Print("\n",FormatTable(v,rec(rowLabels:=["SS","USS","SC"],
    columnLabels:=["Size","Time"])));
end;

STransport:=function(x,s)local p,M;M:=x.monoid;
  if IsList(s) then return List(s,y->STransport(x,y));fi;
  p:=PreferredPrefix(x);
  return M.Elt([p^-1*GarsideAlpha(s)*PreferredPrefix(x^s)]);
end;

STransportN:=function(N,x,s)local i,p,M;M:=x.monoid;
  s:=GarsideAlpha(s);
  for i in [1..N] do
    p:=PreferredPrefix(x);
    s:=p^-1*s*PreferredPrefix(PositiveSimpleConjugation(x,s));
    x:=PositiveSimpleConjugation(x,p);
  od;
  return M.Elt(s);
end;

History:=function(b,f)local h;
  h:=[[b,b^0]];
  while true do
    b:=f(b);
    if b[1] in List(h,x->x[1]) then return Concatenation(h,[b]);fi;
    Add(h,b);b:=b[1];
  od;
end;

canl:=b->Length(b.elm);

foo:=function(x)local h;h:=History(x,Sliding);
# return canl(h[Length(h)][1])<canl(x) and canl(h[2][1])= canl(x);
  return h[Length(h)][1].pd>x.pd and canl(h[2][1])= canl(x);
end;

maxss:=function(x)local h;h:=History(x,Sliding);
  return PositionProperty(h,x->canl(x[1])=canl(h[Length(h)][1]));
end;

iota:=function(b)local M;
 if Length(b.elm)=0 then return b^0;fi;
 M:=b.monoid; return M.Elt([M.DeltaAction(b.elm[1],-b.pd)]);
end;

# element minimal conjugant x dans son sss
minimaltoSSS:=function(b)local sb,sinf,ssup,min,delta,star,M;M:=b.monoid;
  star:=x->delta/x;
  sb:=RepresentativeSC(b)[2];delta:=b.monoid.Elt([],1);
  sinf:=sb.pd;ssup:=sb.pd+Length(sb.elm);
  min:=b^0;
  while sinf>b.pd or ssup<b.pd+Length(b.elm) do
  if sinf>b.pd and ssup<b.pd+Length(b.elm) then
    b:=Sliding(b);min:=star(M.Elt([b[2]]))*min;b:=b[1]^delta;
  elif sinf>b.pd then min:=star(iota(b))*min;b:=(b^iota(b))^delta;
  else min:=star(iota(b^-1))*min;b:=(b^iota(b^-1))^delta;
  fi;
  od;
  return min;
end;

minimal2:=function(b)local sb,sinf,ssup,min,delta,star;
  star:=x->delta/x;
  sb:=RepresentativeSC(b)[2];delta:=b.monoid.Elt([],1);
  sinf:=sb.pd;ssup:=sb.pd+Length(sb.elm);
  min:=b^0;
  while sinf>b.pd do min:=star(iota(b))*min;b:=(b^iota(b))^delta;od;
  while ssup<b.pd+Length(b.elm) do
     min:=star(iota(b^-1))*min;b:=(b^iota(b^-1))^delta;od;
  return min;
end;

minimal3:=function(b)local sb,sinf,ssup,min,delta,star,M;M:=b.monoid;
  star:=x->delta/x;
  sb:=RepresentativeSC(b)[2];delta:=b.monoid.Elt([],1);
  sinf:=sb.pd;ssup:=sb.pd+Length(sb.elm);
  min:=b^0;
  while sinf>b.pd or ssup<b.pd+Length(b.elm) do
    b:=Sliding(b);min:=star(M.Elt([b[2]]))*min;b:=b[1]^delta;od;
  return min;
end;

minimalr:=function(b)local sb,sinf,ssup,min,delta,star;
  star:=x->delta/x;
  sb:=RepresentativeSC(b)[2];delta:=b.monoid.Elt([],1);
  sinf:=sb.pd;ssup:=sb.pd+Length(sb.elm);
  min:=b^0;b:=ReversedWord(b);
  while sinf>b.pd do min:=star(iota(b))*min;b:=(b^iota(b))^delta;od;
  while ssup<b.pd+Length(b.elm) do
     min:=star(iota(b^-1))*min;b:=(b^iota(b^-1))^delta;od;
  return ReversedWord(min);
end;

# History(b,x->Cycling(x)^Delta)
CSHistory:=function(b)local h;
  h:=[[b,b^0]];
  while true do
    b:=Cycling(b);
    b[1].elm:=List(b[1].elm,x->b[1].monoid.DeltaAction(x,1));
    b[2]:=b[1].monoid.Elt([b[1].monoid.delta/h[Length(h)][1].elm[1]]);
    if b[1] in List(h,x->x[1]) then return Concatenation(h,[b]);fi;
    Add(h,b);b:=b[1];
  od;
end;

# pullback starting at z of s starting a sliding(z)
# assumes z is in SSS
SPullback:=function(z,s)local y,M;
  y:=Sliding(z);M:=z.monoid;
  return RightGcd(y[2]*s,ReversedWord(Sliding(ReversedWord(y[1]^s))[2]))[2];
end;

SPullback2:=function(z,s)local y,M;
  y:=Sliding(z);M:=z.monoid;
  return RightGcd(y[2]*s,ReversedWord(Sliding(ReversedWord(y[1]^s))[2])){[2,3]};
end;

Hom:=function(x,y)local M,s;
  M:=x.monoid;
  s:=LeftDivisorsSimple(M,M.delta);
  s:=List(Concatenation(s),x->M.B(x));
  return Filtered(s,z->x^z=y);
end;

PreimageSliding:=function(b)local d,M;M:=b.monoid;
  d:=List(Concatenation(LeftDivisorsSimple(M,GarsideAlpha(ReversedWord(b)))),
    x->x^-1);
  d:=List(d,function(x)local y;y:=b.monoid.Elt([x]);return y*b*y^-1;end);
  return Set(Filtered(d,x->Sliding(x)[1]=b));
end;

PreimageSlidingSSS:=b->Filtered(PreimageSliding(b),
  x->Length(x.elm)=Length(b.elm) and x.pd=b.pd);

PreimageCategory:=function(b)local c,f,m,l,d,i,j;
  c:=PreimageSliding(b);l:=[1..Length(c)];
  if l=[] then Print(b," is not in the image of the sliding\n");return;fi;
  f:=function(a,b)a:=Sliding(a)[2]*Sliding(b)[2]^-1;
    if a.pd>=0 then return a;else return "-";fi;
  end;
  d:=PreimageSlidingSSS(b);
  d:=List(l,function(i)
    if c[i]in d then return SPrint(i,"*");else return i;fi;end);
  m:=List(c,a->List(c,b->f(a,b)));
  SortBy(l,x->[-Number(l,i->m[i][x]="-"),Number(m[x],y->y="-")]);
  Print("b=",b,"\n",FormatTable(m{l}{l},d,l,rec()));
  ShowMaps(Concatenation(List(l,i->List(Filtered(l,j->j<>i and m[i][j]<>"-"),
    j->[i,m[i][j],j]))));
end;

SimpleEndomorphisms:=function(b)local M,s;
  M:=b.monoid;
  s:=List(Elements(Centralizer(M.group,EltBraid(b))),M.B);
  s:=Filtered(s,x->EltBraid(x)<>M.group.identity);
  return Filtered(s,x->b=b^x);
end;

SimpleMorphisms:=function(b)local M,s;
  M:=b.monoid;
  s:=Concatenation(SimpleLeftDivisors(M,M.delta));
  s:=Filtered(s,x->x<>M.group.identity);
  s:=List(s,M.B);
  return Filtered(s,function(x)x:=b^x;return x.pd>=0;end);
end;

imtrans:=function(b)local l,s;
  l:=PreimageSliding(b);
  l:=List(l,x->[x,SimpleEndomorphisms(x)]);
  for s in l do s[2]:=List(s[2],y->[y,STransport(s[1],y)]);od;
  return [SimpleEndomorphisms(b),
    Set(Concatenation(List(l,x->List(x[2],y->y[2]))))];
end;

# preimages de f partant de a
PreimageSTransport:=function(a,f)local b,c,cp;
  b:=a^f;
  if b.pd<0 then Error(f," not a morphism from ",a);fi;
  c:=Cartesian(PreimageSliding(a),PreimageSliding(b));
  for cp in c do Add(cp,Sliding(cp[1])[2]*f*Sliding(cp[2])[2]^-1);od;
  return Filtered(c,x->x[3].pd>=0);
end;

PreimageSTransportSSS:=function(a,f)local b,c,cp;
  b:=a^f;
  if b.pd<0 then Error(f," not a morphism from ",a);fi;
  c:=Cartesian(PreimageSlidingSSS(a),PreimageSlidingSSS(b));
  for cp in c do Add(cp,Sliding(cp[1])[2]*f*Sliding(cp[2])[2]^-1);od;
  return List(Filtered(c,x->x[3].pd>=0),x->x{[1,3]});
end;
  
# preimages de f partant de a
PreimageSTransportSSS2:=function(a,f)local c;
  c:=a^f;
  if c.pd<0 then Error(f," not a morphism from ",a);fi;
  c:=PreimageSlidingSSS(a);
  return List(c,function(z)local s; s:=SPullback(z,f);
     return [z,s,STransport(z,s)];end);
end;

PreimageSTransportSSS3:=function(a,f)local c;
  c:=a^f;
  if c.pd<0 then Error(f," not a morphism from ",a);fi;
  c:=PreimageSlidingSSS(a);
  return List(c,function(z)local s; s:=SPullback2(z,f);
     return [z,s[1],STransport(z,s[1]),s[2]];end);
end;

IsInSSS:=function(b)local l;
  l:=RepresentativeSC(b)[2];
  return  b.pd=l.pd and Length(b.elm)=Length(l.elm);
end;

IsInSC:=function(b)local l;l:=RepresentativeSC(b);
  return  b in l{[2..Length(l)]};
end;

test3:=function(b)local l;
  if not IsInSSS(b) then return true;fi;
  l:=RepresentativeSC(b);l:=l{[2..Length(l)]};
  if b in l then return true;fi;
  if Sliding(b)[1] in l then return true;fi;
  return false;
end;

RSliding:=function(y) y:=Sliding(ReversedWord(y));
  return [ReversedWord(y[1]),y[2]^-1];
end;

sr:=function(y)local z; y:=RSliding(y);z:=Sliding(y[1]);
  return [z[1],y[2]^-1*z[2]];
end;

test2:=b->IsInSSS(b) and  Length(PreimageSlidingSSS(b))>0 and b<>sr(b);

rs:=function(y)local z; y:=Sliding(y); z:=RSliding(y[1]);
  return [z[1],y[2]/z[2]];
end;

srcat:=function(b)local cat,arr,i,c;
  cat:=[b];arr:=[];i:=1;
  repeat
    c:=sr(cat[i])[1];p:=Position(cat,c);
    if p=false then Add(cat,c);Add(arr,[i,2,Length(cat)]);
    else Add(arr,[i,2,p]);
    fi;
    c:=rs(cat[i])[1];p:=Position(cat,c);
    if p=false then Add(cat,c);Add(arr,[i,3,Length(cat)]);
    else Add(arr,[i,3,p]);
    fi;
    i:=i+1;
  until i>Length(cat);
# ShowMaps(Filtered(arr,x->x[1]<>x[3]));
  return [cat,arr];
end;

# n braids of length l such that f
braidssuch:=function(n,f)local res,b,c;
  res:=[];c:=0;
  repeat b:=RandomBraid(M,Random([5..15]));
    if f(b) then Add(res,b);Print("#\c");
    else Print(".\c");c:=c+1;
    fi;
  until Length(res)=n;
  Print("after trying ",c," braids...\n");
  return res;
end;

tt:=function(b,f)local sb,sf;
  sb:=List(Sliding(ReversedWord(b)),ReversedWord);
  sf:=sb[2]*f*ReversedWord(Sliding(ReversedWord(b^f))[2])^-1;
  return STransport(sb[1],sf);
end;

imtrans2:=function(b)local l;
  l:=SimpleMorphisms(b);
  return [l,Filtered(l,f->Length(PreimageSTransport(b,f))>0)];
end;

imtrans2SSS:=function(b)local l;
  l:=SimpleMorphisms(b);
  return [l,Filtered(l,f->Length(PreimageSTransportSSS(b,f))>0)];
end;

imtrans3SSS:=function(b)local l,c;
  l:=SimpleMorphisms(b); c:=PreimageSlidingSSS(b);
  return [l,Filtered(l,f->ForAny(c,z->STransport(z,SPullback(z,f))=f))];
end;

comp:=function(b)local l0,l;
  l0:=imtrans2(b)[2];
  l:=List(l0,x->x*imtrans2(b^x)[2]);
  l:=Set(Concatenation(l));
  l:=Filtered(l,x->(x.pd=0 and Length(x.elm)=1)or(x.pd=1 and Length(x.elm)=0));
  return [Difference(l0,l),Difference(l,l0)];
end;

compSSS:=function(b)local l0,l;
  l0:=imtrans2SSS(b)[2];
  l:=List(l0,x->x*imtrans2SSS(b^x)[2]);
  l:=Set(Concatenation(l));
  l:=Filtered(l,x->(x.pd=0 and Length(x.elm)=1)or(x.pd=1 and Length(x.elm)=0));
  return [Difference(l0,l),Difference(l,l0)];
end;

compSSS2:=function(b)local l0,l;
  l0:=imtrans3SSS(b)[2];
  l:=List(l0,x->x*imtrans3SSS(b^x)[2]);
  l:=Set(Concatenation(l));
  l:=Filtered(l,x->(x.pd=0 and Length(x.elm)=1)or(x.pd=1 and Length(x.elm)=0));
  return [Difference(l0,l),Difference(l,l0)];
end;

PreimageCategorySSS:=function(b)local c,f,m,l;
  c:=PreimageSlidingSSS(b);
  if Length(c)=0 then Print(b," not image of sliding in SSS\n");return;fi;
  f:=function(a,b)a:=Sliding(a)[2]*Sliding(b)[2]^-1;
    if a.pd>=0 then return a;else return "-";fi;end;
  m:=List(c,a->List(c,b->f(a,b)));l:=[1..Length(c)];
  Sortby(l,x->Number(m[x],y->y="-")));
  Print("b=",b,"\n");
  Print(FormatTable(m{l}{l},l,l,rec()));
  ShowMaps(Concatenation(List(l,i->List(Filtered(l,j->j<>i and m[i][j]<>"-"),
    j->[i,m[i][j],j]))));
end;

findcl:=function(l,cat)local res,l,cl;
  res:=[];
  while Length(l)>0 do
  cl:=ConjugacySet(l[1],"Pos");
  Add(res,[Length(cl),Length(cat(cl[1]))]);
  l:=Difference(l,cl);
  od;
  Sort(res);
  return res;
end;

########################################################################
# Until the end algos for USS
########################################################################
# returns the iterated transports of s along the cycling orbit of b
# (returns only the looping part)
CTransportOrbit:=function(b,s)local t,tl,b0,p,CTransport0,CTransport,
InitialFactor;
# CTransport(x,s)
# Given x in SSS(x), s simple  such that x^s in SSS(x) and c(x) the 
# element such that Cycling(x)=x^c(x), CTransport returns c(x)^-1*s*c(x^s)
CTransport0:=function(x,s) local M,R,b;
  M:=x.monoid;
  if Length(x.elm)=0 then return s;fi;
  b:=M.alpha2(M.RightComplementToDelta(x.elm[1]),M.DeltaAction(s,-1))[1];
  R:=M.LeftGcdSimples(M.AddToNormal(x.elm{[2..Length(x.elm)]},s)[1],b)[1];
  if R=M.identity then return M.delta;
  else return M.DeltaAction(R,-x.pd);
  fi;
end;

InitialFactor:=function(b)local M;M:=b.monoid;
 if Length(b.elm)=0 then return M.identity;fi;
 return M.DeltaAction(b.elm[1],-b.pd);
end;

# CTransport0 is fast but buggy...
CTransport:=function(x,s)
  return InitialFactor(x)^-1*s*InitialFactor(x^x.monoid.Elt([s]));
end;

  t:=s;tl:=[s];b0:=b;
  while true do
    repeat
#     if CTransport0(b,t)<>CTransport(b,t) then Error();fi;
      t:=CTransport(b,t);
      b:=Cycling(b)[1]; until b=b0;
    p:=Position(tl,t);
    if p<>false then return tl{[p..Length(tl)]};
    else Add(tl,t);
    fi;
  od;
end;

MainPullback:=function(y,s)local co,po,cycle,i,l,k,CPullback,CyclingOrbit;
# pullback is an almost-inverse of the transport
CPullback:=function(y,s)local M,b0,br,i,b;
  M:=y.monoid;
  if Length(y.elm)=0 then return s;fi;
  b0:=M.DeltaAction(M.RightLcmSimples(M.DeltaAction(
     M.RightComplementToDelta(y.elm[1]),-y.pd),s)[2],-1);
  br:=M.DeltaAction(s,y.pd);
  for i in [2..Length(y.elm)] do
    br:=M.RightLcmSimples(br,y.elm[i])[3];
  od;
  b:=M.RightLcmSimples(b0,br)[1];
  return MinConjugating.SS(y,b,function(arg)return arg[1];end);
end;

# Assumes b in SSS(b), otherwise may loop infinitely
CyclingOrbit:=function(b)local l;
  l:=[b];
  while true do b:=Cycling(b)[1];
    if b=l[1] then return l;else Add(l,b);fi;
  od;
end;

  co:=CyclingOrbit(y);
  po:=[];
  cycle:=function(s)
    for i in [Length(co),Length(co)-1..1] do s:=CPullback(co[i],s);od;
    return s;
  end;
  repeat Add(po,s); s:=cycle(s); until s in po;
  k:=Position(po,s)-1;l:=Length(po)-k;
  return po[1+k+((l-k) mod l)];
end;

########################################################################
# MinConjugating.USS(a,x)                                                #
#   This  program finds the minimal right multiple  m of the simple x  #
#   such that  a^m is in USS(a).                                        #
#   This m is a simple.                                                #
########################################################################
MinConjugating.USS:=function(y,b,F)local a,to,p,M;
  a:=MinConjugating.SS(y,b,F);
  to:=CTransportOrbit(y,a);
  M:=y.monoid;
  p:=PositionProperty(to,x->M.RightLcmSimples(b,x)[3]=M.identity);
  if p<>false then return to[p];fi;
  a:=MainPullback(y,b);
  to:=CTransportOrbit(y,a);
  p:=PositionProperty(to,x->M.RightLcmSimples(b,x)[3]=M.identity);
  if p<>false then return to[p];
  else Error("theory");
  fi;
end;
