###########################################################################
# Contribution to the Chevie Package
#
#  This file contains some supplementary programs for working with braids
#    (C) Jean MICHEL 1995-2007
###########################################################################
##
#F  LeftDivisors(b)   returns all divisors of b
##
LeftDivisors:=function(b)local s,M,w;
  M:=b.monoid;if b=M.Elt([]) then return [b];fi;
  w:=GarsideAlpha(b);
  s:=Filtered([1..M.nrAtoms],i->M.IsLeftDescending(w,i));
  s:=List(s,x->M.Elt([M.atoms[x]]));
  return Union([M.Elt([])],s,Union(List(s,x->x*LeftDivisors(x^-1*b))));
end;

RightDivisors:=b->List(LeftDivisors(b.monoid.Reverse(b)),b.monoid.Reverse);

########################################################################
##
#F  PiRoots(wF,d) this function returns all d-th roots of pi in the
##              Coxeter coset WF using a very bestial algorithm
##
PiRoots:=function(WF,d)local W,e,pi,F,p,phiorder;
  phiorder:=function(w,p)
    return First(DivisorsInt(OrderPerm(w*p)),i->(w*p)^i=p^i);
  end;
  if IsBound(WF.phi) then W:=CoxeterGroup(WF);p:=WF.phi;F:=Frobenius(WF);
		     else W:=WF;p:=();F:=x->x;
  fi;
  e:=CoxeterElements(W,2*W.N/d);
  e:=List(Filtered(e,x->phiorder(x,p)=d),Braid(W));
  pi:=Braid(W)(LongestCoxeterElement(W))^2;
  e:=Filtered(e,x->TwistedPower(d,x,F)=pi);
  return e;
end;

CheckGeckKimPfeiffer:=function(WF)local F,r,d,rr,n,pi,b,r,W,red,bad,rbad;
  if IsBound(WF.phi) then W:=CoxeterGroup(WF);F:=Frobenius(WF);
  else W:=WF;F:=x->x;fi;
  r:=RegularEigenvalues(WF);
  r:=r{[2..Length(r)]};
  pi:=Braid(W)(LongestCoxeterElement(W))^2;
  for d in r do
    rr:=PiRoots(WF,d);
    Print("d=",d," reduced roots:",Length(rr));
    rr:=ConjugacySet(rr[1],F,"Cyc");
    Print(" cycclass:", Length(rr));
    bad:=0;
    rbad:=0;
    red:=0;
    for b in rr do
      if Length(b.elm)<2 then red:=red+1;fi;
      if TwistedPower(d,b,F)<>pi then 
          if Length(b.elm)<2 then rbad:=rbad+1;fi;
	  bad:=bad+1;
      fi;
    od;
    Print(" reduced:",red," bad:",bad," rbad:",rbad,"\n");
  od;
end;

AlphaI:=function(b,I)local M,res,i,s;
  M:=b.monoid;
  res:=M.Elt([]);
  i:=1;
  while i<=Length(I)  do
    if M.IsLeftDescending(GarsideAlpha(b),I[i]) then
      s:=M.Elt([M.atoms[I[i]]]);res:=res*s; b:=s^-1*b; i:=1;
    else i:=i+1;
    fi;
  od;
  return res;
end;

# all words representing b
AllWords:=function(b)local M,s;
  M:=b.monoid;
  if b=M.Elt([]) then return [[]];fi;
  s:=GarsideAlpha(b);
  return Concatenation(List(Filtered([1..M.nrAtoms],i->M.IsLeftDescending(s,i)),
    i->List(AllWords(M.Elt([M.LeftQuotient(s,i)])*
    GarsideOmega(b)),d->Concatenation([i],d))));
end;

#############################################################################
# Returns
# [set of all elements which appear as an item in one of
# the lists in the Hurwitz orbit of the list l, lists in the Hurwitz orbit]
# to find the dual monoid apply it to an expression for a Coxeter element
HurwitzOrbitItems:=function(l)local orbit,new,totest,r,refs;
  orbit:=[]; totest:=[l];r:=Length(l);
  refs:=Set(l);
  repeat
    new:=Set(Concatenation(List([1..r-1],i->List(totest,
      e->Concatenation(e{[1..i-1]},[e[i+1],e[i]^e[i+1]],e{[i+2..r]})))));
    UniteSet(orbit,totest);totest:=Difference(new,orbit);
    UniteSet(refs,Set(Concatenation(totest)));
    InfoChevie("#I Hurwitz orbit: ",Length(orbit)," items=",Length(refs),"\n");
  until Length(totest)=0;
  return [refs,orbit];
#  return refs;
end;

#############################################################################
##
#F  DualRelations
##  The relations of the dual braid monoid M
##
DualRelations:=function(M)local res,i,j,w,p,l,rels;
  res:=[];
  for i in [1..M.nrAtoms] do
    w:=M.atoms[i]^-1*M.delta;
    for j in [1..M.nrAtoms] do
      if M.IsLeftDescending(w,j) then Add(res,[i,j]);fi;
    od;
  od;
  p:=List(res,x->Product(M.atoms{x}));
  l:=Set(p);
  rels:=List(l,x->[]);
  for i in [1..Length(res)] do Add(rels[Position(l,p[i])],res[i]);od;
  return rels;
end;

PoincareDualSimples:=function(W,w)local d,M;
  d:=ReflectionDegrees(W);
  InfoChevie("#  predicted=",Product(d+Maximum(d))/Product(d),"\n");
  M:=DualBraidMonoid(W,w);
  d:=LeftDivisorsSimple(M,M.delta);
  return Sum([1..Length(d)],i->X(Rationals)^(i-1)*Length(d[i]));
end;
