###########################################################################
##
#A  setup.gap                autag package                 Michael J Smith
##
##  November 1996
##
##  This file is part of the autag package, which contains GAP code for
##  computing automorphism groups of finite soluble groups given by
##  special soluble group presentations.
## 
###########################################################################


Cat := Concatenation;
Read(Cat(LOCALNAMEautag, "misc.g"));

LOCALNAMEmod := Cat(LOCALNAMEautag,"mod/");
Read(Cat(LOCALNAMEmod, "init.gap"));
ReadLocalDir(LOCALNAMEmod, "initial");

LOCALNAMEaut := Cat(LOCALNAMEautag,"aut/");
Read(Cat(LOCALNAMEaut, "init.gap"));
ReadLocalDir(LOCALNAMEaut, "initial");


if IsBound(USERISMJS) then
    InfoOrbit := Print;
    InfoOrbit2 := Ignore;
    InfoAutgroup := Print;
    
    InfoIntertwine := Ignore;
    InfoDecompose := Ignore;
    InfoModuleHom := Ignore;
    InfoModuleHomTiming := Ignore;

    QUIET := function ()
        InfoOrbit := Ignore;
        InfoOrbit2 := Ignore;
        InfoAutgroup := Ignore;
    end;

    LOUD := function ()
        InfoOrbit := Print;
        InfoOrbit2 := Ignore;
        InfoAutgroup := Print;
    end;

fi;

