#############################################################################
##
#A  init.g       ALGEBRA package         C'edric Bonnaf'e
##
#Y  Copyright (C) 2005 - 2010  University of Franche-Comt'e
##
##  This is the init file of the ALGEBRA package.
## 
#############################################################################

if not IsBound(ALGEBRAPATH) then 
  ALGEBRAPATH:=LOADED_PACKAGES.algebra;
fi;

ReadAlgebra:= function(name)
  if not ReadPath(ALGEBRAPATH, name, ".g", "ReadAlgebra") then
     Error("Algebra library file '", name, "' must exist and be readable");
  fi;
end;

ReadAlgebra("algebra");

AUTO(ReadAlgebra("algebra"), AdamsOperation, AlgebraElement, AlgebraEltOps,
AlgebraHomomorphismByLinearity, FDAlgebraOps, Augmentation, ByDigits,
CartanMatrix, CentralIdempotents, CentralizerAlgebra, CharacterDecomposition,
CyclotomicModP, Digits, GeneralizedSolomonAlgebra, GeneralizedSolomonAlgebraOps,
GrothendieckRing, GrothendieckRingOps, GroupAlgebra, GroupAlgebraCentre,
GroupAlgebraCentreOps, GroupAlgebraOps, Idempotents, IsCentralElement,
IsCommutative, IsDominated, LeftIdeal, LeftIndecomposableProjectives,
LeftTrace, LeftTraces, LoewyLength, PBlocks, PiComponent, PiPart,
PiPrimeSections, PiSections, PolynomialQuotientAlgebra, PRank,
ProjectionMatrix, QuaternionAlgebra, QuotientAlgebra, RadicalPower,
RestrictionHomomorphism, RightIdeal, RightTrace, RightTraces, SolomonAlgebra,
SolomonAlgebraOps, SolomonHomomorphism, SubAlgebra, TablePrint, TwoSidedIdeal,
VectorSpaceProjection, ZeroHeckeAlgebra, ZeroHeckeAlgebraOps);

ALGEBRA:=rec(version:="october 2010");

if BANNER then
Print(
"-----------------------------------------------------\n",
"Loading the ALGEBRA package,  Version of ",ALGEBRA.version,"\n",
"(C) C'edric Bonnaf'e, University of Montpellier\n");
fi;
