#############################################################################
##
#A  init.g       VKCURVE package         David Bessis and Jean Michel
##
#Y  Copyright (C) 2001 - 2002  University Paris VII, France.
##
##  This is the init file of the VKCURVE package.
## 
#############################################################################

if not IsBound(VKCURVEPATH) then 
  VKCURVEPATH:=LOADED_PACKAGES.vkcurve;
fi;

ReadVK:= function(name)
  if not ReadPath(VKCURVEPATH, name, ".g", "ReadVK") then
     Error("VKCURVE library file '", name, "' must exist and be readable");
  fi;
end;

RequirePackage("chevie");

AUTO(ReadVK("action"),VKQuotient,DBVKQuotient,BnActsOnFn);
AUTO(ReadVK("loops"),LoopsAroundPunctures);
AUTO(ReadVK("plbraid"),LBraidToWord);
AUTO(ReadVK("polyroot"),NewtonRoot,SeparateRoots,SeparateRootsInitialGuess,
  FindRoots);
AUTO(ReadVK("pres"),ShrinkPresentation,DisplayPresentation,
 TryConjugatePresentation,ConjugatePresentation);
AUTO(ReadVK("global"),PrepareFundamentalGroup,FinishFundamentalGroup,
  FundamentalGroup);
AUTO(ReadVK("util"), BigNorm, ComplexRatToGaussian, ComplexRational,
  Cut, DecimalLog, Discy, Dispersal, DistSeg,
  MinPos, ResultantMat, Rho, SmallNorm);
AUTO(ReadVK("truemono"),FollowMonodromy);
AUTO(ReadVK("segtobrd"),ApproxFollowMonodromy);
AUTO(ReadVK("mvp"),MvpOps,Mvp,IsMvp,ScalMvp,quadratMvp,Jacobian,Hessian,
  MonomialGcd);
AUTO(ReadVK("mvrf"),RatFrac,IsRatFrac,MvpGcd,MvpLcm,LaurentDenominator);

PresentationFpGroup;; # fudge to read PresentationOps
PresentationOps.Display:=DisplayPresentation; # so as to be able to do this

Horner:=function(arg)
  Print("#W Horner is in the GAP library under the name ValuePol\n");
  return ApplyFunc(ValuePol,arg);
end;

Deriv:=function(arg)
  Print("#W Deriv is obsolete, use Derivative\n");
  return ApplyFunc(Derivative,arg);
end;

VKCURVE:=rec( 
  version:="1.2 Mar2009",
  monodromyApprox:=false,
  showSingularProj:=false, 
  showBraiding:=false,
  showLoops:=false,
  showAction:=false,
  showSegments:=false,
  showInsideSegments:=false,
  showWorst:=false,
  showZeros:=false,
  showNewton:=false,
  showgetbraid:=false,
  showRoots:=false,
  showallnewton:=false,# for NewtonRoot
  NewtonLim:=800,      # for NewtonRoot
  AdaptivityFactor:=10, # for ApproxFollowMonodromy
  shrinkBraid:=false,
  mvp2:=false
);

if BANNER then
  PrintPkgInit("vkcurve",VKCURVE.version);
# Print("    see http://webusers.imj-prg.fr/~jmichel/vkcurve.html\n");
  Print("(C) David Bessis,  Jean Michel\n");
fi;
x:=Mvp("x");
