ReadVK("contrib/common");
W:=ComplexReflectionGroup(34);
res:=init(W);

renorm:=[1944,3888,1944,1596575714976,1944,1944];

res.hessmat:=function(z)local hess;
  hess:=function(i,j,z)
    return Sum(W.roots,x->30*(x*z)^4*x[i]*x[j])/renorm[1];
  end;
  return List([1..res.rank],i->List([1..res.rank],j->hess(i,j,z)));
end;

res.invar:=function(i,p) local mu;
  mu:=function(i,p)return Sum(W.roots,x->(x*p)^res.degs[i])/renorm[i];end;
  if i<>4 then return mu(i,p);
  else return applyMvp(
# (1/23328000000)det(hessian) en fonction de mu_1..mu_4; can be obtained by:
# hominterpol(z->DeterminantMat(res.hessmat(z)),24,List([1..4],i->(z->mu(i,z))),
#  res.degs{[1..4]},6,vars);
    -t+69197/258156875724*x*z+809249/754856437500*y^2
    -1862993908/19773045015625*x^2*y+1937160963/1797549546875*x^4,
     List([1..4],i->mu(i,p)),varnames{[1..4]});
  fi;
end;

res.jacobmat:=function(p)local jacob;
  jacob:=function(i,j,p)local jacobmu;
   # computes d/dj of invar(i) at z
   jacobmu:=function(i,j,z)
      return Sum(W.roots,x->res.degs[i]*(x*z)^(res.degs[i]-1)*x[j])/renorm[i];
   end;

   if i<>4 then return jacobmu(i,j,p);
   else return  applyMvp(  # total derivative of (1/23328000000)det(hessian)
      -Mvp("dt")
      +69197/258156875724*(x*Mvp("dz")+Mvp("dx")*z)
      +809249/754856437500*2*y*Mvp("dy")
     -1862993908/19773045015625*(2*x*Mvp("dx")*y+x^2*Mvp("dy"))
     +1937160963/1797549546875*(4*x^3*Mvp("dx")),
   Concatenation(List([1..3],i->res.invar(i,p)),List([1..4],i->jacobmu(i,j,p))),
     ["x","y","z","dx","dy","dz","dt"]);
   fi;
  end;

  return List([1..res.rank],i->List([1..res.rank],j->jacob(i,j,p)));
end;

# the next 2 assignments can be done (and checked) by getC(res)
res.C:=[[1,0,0,0,0,0],
[0,t,-25623/175*x,29/437500*x^2-2/984375*y,-18958101273/28700*x^3+
     4383422469/315700*x*y-1197907/6314*z,
    -78307327099903642416708516/12141111960078125*x^5
    +566404141998190388920389/1184498727812500*x^3*y
    -1197786870889112467288053/267104463121718750*x*y^2
    -4578546012088741561134/2428222392015625*x^2*z
    +1729346695224875667163/106841785248687500*y*z
    -2079266672313/8239991150*u],
  [0,0,1,0,0,0],
  [0,0,0,1,0,0],
  [0,0,0,0,1,0],
  [0,0,0,0,0,1]]*x^0;

res.c:=z->ScalMvp(Value(res.C,Concatenation(List([1..res.rank],
   i->[varnames[i],res.invar(i,z)]))));

# find all g34 root bases starting with vector below
getbasic:=function()local basicroots,complete,i,ca;
  ca:=CartanMat(ComplexReflectionGroup(34));

  basicroots:=[[[E(3)-E(3)^2,E(3)^2-E(3),0,0,0,0]]];

  # assumes <r_i,r_j>=c_i,j already
  complete:=function(r)local j,new,t,i;
    j:=Length(r)+1;
    new:=W.roots;
    for i in [1..Length(r)] do
      t:=new*ComplexConjugate(r[i])-3*ComplexConjugate(ca[i][j]);
      new:=ListBlist(new,List(t,x->x=0));
#     Print(Length(new)," ",Stime(),"\n");
    od;
    return List(new,x->Concatenation(r,[x]));
  end;

  for i in [1..5] do
    basicroots:=Concatenation(List(basicroots,complete));
    Print(Length(basicroots)," ",Stime(),"\n");
  od;
  return basicroots;
end;

res.twoplane:=["x",0,"y",0,"z",0,"t",1,"u",y,"v",x];

ReadVK("work/sym");
S:=function(arg)return Sym(arg,6);end;

# composition des invariants comme fonctions symetriques
ISymm:=[180*S(1,1,1,1,1,1)+10*S(3,3)-S(6),

17*S(12)+3234*S(6,6)-715*S(9,3)+2310*S(6,3,3)+46200*S(3,3,3,3)
+935550*S(2,2,2,2,2,2)+103950*S(4,4,1,1,1,1)+11880*S(7,1,1,1,1,1),

-911*S(18)-3378648*S(12,6)+148920*S(15,3)+92820*S(12,3,3)
+18378360*S(10,4,1,1,1,1)+257040*S(13,1,1,1,1,1)+8873150*S(9,9)
+4288284*S(6,6,6)+1021020*S(9,6,3)+85765680*S(6,6,3,3)+20420400*S(9,3,3,3)
+1715313600*S(6,3,3,3,3)+34306272000*S(3,3,3,3,3,3)+4824319500*S(4,4,4,4,1,1)
+6947020080*S(5,5,2,2,2,2)+551350800*S(7,4,4,1,1,1)+63011520*S(7,7,1,1,1,1)
+1240539300*S(8,2,2,2,2,2),

6151*S(24)+3326787919*S(12,12)-1608393358*S(15,9)+
165586729*S(18,6)-2489773*S(21,3)+156165009*S(12,6,6)+
37182145*S(12,9,3)+6864396*S(15,6,3)+168245*S(18,3,3)+
3123300180*S(12,6,3,3)+137287920*S(15,3,3,3)+
62466003600*S(12,3,3,3,3)+2944825884*S(10,10,1,1,1,1)+
773016794550*S(10,4,4,4,1,1)+88344776520*S(10,7,4,1,1,1)+
505974629160*S(11,5,2,2,2,2)+10811423700*S(13,4,4,1,1,1)+
1235591280*S(13,7,1,1,1,1)+13900401900*S(14,2,2,2,2,2)+
77224455*S(16,4,1,1,1,1)+318780*S(19,1,1,1,1,1)+409003595*S(9,9,6)+
144296468316*S(6,6,6,6)+34356301980*S(9,6,6,3)+8180071900*S(9,9,3,3)+
2885929366320*S(6,6,6,3,3)+687126039600*S(9,6,3,3,3)+
202916908569375*S(4,4,4,4,4,4)+46752055734384*S(5,5,5,5,2,2)+
57718587326400*S(6,6,3,3,3,3)+23190503836500*S(7,4,4,4,4,1)+
2650343295600*S(7,7,4,4,1,1)+302896376640*S(7,7,7,1,1,1)+
8348581381140*S(8,5,5,2,2,2)+1490818103775*S(8,8,2,2,2,2)+
13742520792000*S(9,3,3,3,3,3),

-664301*S(30)+20608991265960*S(15,15)-11491489873500*S(18,12)+
1900855102575*S(21,9)-78888946500*S(24,6)+539413630*S(27,3)+
401415057225*S(12,12,6)+1051325149875*S(12,9,9)+17644617900*S(15,12,3)+
194090796900*S(15,9,6)+19979934975*S(18,6,6)+4757127375*S(18,9,3)+
300450150*S(21,6,3)+2968875*S(24,3,3)+8028301144500*S(12,12,3,3)+
370907512875900*S(12,6,6,6)+88311312589500*S(12,9,6,3)+
16303626939600*S(15,6,6,3)+3881815938000*S(15,9,3,3)+399598699500*S(18,6,3,3)+
6009003000*S(21,3,3,3)+7418150257518000*S(12,6,6,3,3)+
1766226251790000*S(12,9,3,3,3)+326072538792000*S(15,6,3,3,3)+
7991973990000*S(18,3,3,3,3)+8742819946360500*S(10,10,4,4,1,1)+
999179422441200*S(10,10,7,1,1,1)+2294990235919631250*S(10,4,4,4,4,4)+
262284598390815000*S(10,7,4,4,4,1)+29975382673236000*S(10,7,7,4,1,1)+
2601169570818000*S(11,11,2,2,2,2)+240348068343583200*S(11,5,5,5,2,2)+
42919297918497000*S(11,8,5,2,2,2)+148363005150360000*S(12,6,3,3,3,3)+
122277202047000*S(13,10,4,1,1,1)+1710170658000*S(13,13,1,1,1,1)+
32097765537337500*S(13,4,4,4,4,1)+3668316061410000*S(13,7,4,4,1,1)+
419236121304000*S(13,7,7,1,1,1)+6602968910538000*S(14,5,5,2,2,2)+
1179101591167500*S(14,8,2,2,2,2)+6521450775840000*S(15,3,3,3,3,3)+
873408586050*S(16,10,1,1,1,1)+229269753838125*S(16,4,4,4,1,1)+
26202257581500*S(16,7,4,1,1,1)+97102483978500*S(17,5,2,2,2,2)+
946417972500*S(19,4,4,1,1,1)+108162054000*S(19,7,1,1,1,1)+
851776175250*S(20,2,2,2,2,2)+2458228500*S(22,4,1,1,1,1)+
4275180*S(25,1,1,1,1,1)+971424438484500*S(9,9,6,6)+231291532972500*S(9,9,9,3)+
342718541897331600*S(6,6,6,6,6)+81599652832698000*S(9,6,6,6,3)+
19428488769690000*S(9,9,6,3,3)+22208161514947087680*S(5,5,5,5,5,5)+
6854370837946632000*S(6,6,6,6,3,3)+7868537951724450000*S(7,7,4,4,4,4)+
899261480197080000*S(7,7,7,4,4,1)+102772740593952000*S(7,7,7,7,1,1)+
3965743127669122800*S(8,5,5,5,5,2)+708168415655200500*S(8,8,5,5,2,2)+
126458645652714375*S(8,8,8,2,2,2)+1631993056653960000*S(9,6,6,3,3,3)+
388569775393800000*S(9,9,3,3,3,3),

4275611*S(42)+52133032365475818900*S(21,21)-34257377810346518100*S(24,18)+
9556930064120062960*S(27,15)-1071035260277500336*S(30,12)+
43186905879296725*S(33,9)-508081243015892*S(36,6)+1111896806300*S(39,3)+
428826916884169440*S(15,15,12)+239113048017520950*S(18,12,12)+
115615100140339800*S(18,15,9)+11901554426211450*S(18,18,6)+
39552534258537300*S(21,12,9)+7302006324653040*S(21,15,6)+
178970743251300*S(21,18,3)+1641508338793050*S(24,12,6)+
72154212694200*S(24,15,3)+
4299188506362750*S(24,9,9)+11223988641320*S(27,12,3)+123463875054520*S(27,9,6)+
2554425001128*S(30,6,6)+608196428840*S(30,9,3)+9363728010*S(33,6,3)+
26228930*S(36,3,3)+4438894623397258915800*S(12,12,12,6)+
11625676394611868589000*S(12,12,9,9)+195116247182297095200*S(15,12,12,3)+
2146278719005268047200*S(15,12,9,6)+396236071200972562560*S(15,15,6,6)+
94341921714517276800*S(15,15,9,3)+5621206168823321076000*S(15,9,9,9)+
220940456368189357800*S(18,12,6,6)+52604870563854609000*S(18,12,9,3)+
9711668411788543200*S(18,15,6,3)+238031088524229000*S(18,18,3,3)+
578653576202400699000*S(18,9,9,6)+3322412877717133200*S(21,12,6,3)+
146040126493060800*S(21,15,3,3)+36546541654888465200*S(21,9,6,6)+
8701557536878206000*S(21,9,9,3)+32830166775861000*S(24,12,3,3)+
1516753705044778200*S(24,6,6,6)+361131834534471000*S(24,9,6,3)+
10370965504579680*S(27,6,6,3)+2469277501090400*S(27,9,3,3)+
51088500022560*S(30,6,3,3)+187274560200*S(33,3,3,3)+
88777892467945178316000*S(12,12,12,3,3)+
4101538632019067238199200*S(12,12,6,6,6)+
976556817147396961476000*S(12,12,9,6,3)+
10742124988621366576236000*S(12,9,9,6,6)+
2557648806814611089580000*S(12,9,9,9,3)+180287412396442515964800*S(15,12,6,6,3)+
42925574380105360944000*S(15,12,9,3,3)+7924721424019451251200*S(15,15,6,3,3)+
1983161536360867675612800*S(15,9,6,6,6)+472181318181158970384000*S(15,9,9,6,3)+
4418809127363787156000*S(18,12,6,3,3)+194233368235770864000*S(18,15,3,3,3)+
204148981684206966607200*S(18,6,6,6,6)+48606900401001658716000*S(18,9,6,6,3)+
11573071524048013980000*S(18,9,9,3,3)+66448257554342664000*S(21,12,3,3,3)+
3069909499010631076800*S(21,6,6,6,3)+730930833097769304000*S(21,9,6,3,3)+
30335074100895564000*S(24,6,6,3,3)+7222636690689420000*S(24,9,3,3,3)+
207419310091593600*S(27,6,3,3,3)+1021770000451200*S(30,3,3,3,3)+
2025657854997171982947360*S(10,10,10,10,1,1)+
531735186936757645523682000*S(10,10,10,4,4,4)+
60769735649915159488420800*S(10,10,10,7,4,1)+
1823092069497454784652624000*S(10,10,7,7,4,4)+
208353379371137689674585600*S(10,10,7,7,7,1)+
6250601381134130690237568000*S(10,7,7,7,7,4)+
11505614863845695109753600*S(11,11,11,5,2,2)+
1063118813419342228141232640*S(11,11,5,5,5,5)+
189842645253453969310934400*S(11,11,8,5,5,2)+
33900472366688208805524000*S(11,11,8,8,2,2)+
3132403646681990493630417600*S(11,8,8,5,5,5)+
559357794050355445291146000*S(11,8,8,8,5,2)+
82030772640381344763984000*S(12,12,6,6,3,3)+
19531136342947939229520000*S(12,12,9,3,3,3)+
3789821695985618128096060800*S(12,6,6,6,6,6)+
902338499044194792403824000*S(12,9,6,6,6,3)+
214842499772427331524720000*S(12,9,9,6,3,3)+
7436855761353253783548000*S(13,10,10,4,4,1)+
849926372726086146691200*S(13,10,10,7,1,1)+
223105672840597613506440000*S(13,10,7,4,4,4)+
25497791181782584400736000*S(13,10,7,7,4,1)+
104011968690255297672000*S(13,13,10,4,1,1)+
1454712848814759408000*S(13,13,13,1,1,1)+
27303141781192015638900000*S(13,13,4,4,4,4)+
3120359060707658930160000*S(13,13,7,4,4,1)+
356612464080875306304000*S(13,13,7,7,1,1)+
764933735453477532022080000*S(13,7,7,7,4,4)+
87420998337540289373952000*S(13,7,7,7,7,1)+
316088320435321294224000*S(14,11,11,2,2,2)+
29206560808223687586297600*S(14,11,5,5,5,2)+
5215457287182801354696000*S(14,11,8,5,2,2)+
802378044181969439184000*S(14,14,5,5,2,2)+
143281793603923114140000*S(14,14,8,2,2,2)+
481908253335690845173910400*S(14,8,5,5,5,5)+
86055045238516222352484000*S(14,8,8,5,5,2)+
15366972364020753991515000*S(14,8,8,8,2,2)+
3605748247928850319296000*S(15,12,6,3,3,3)+
158494428480389025024000*S(15,15,3,3,3,3)+
166585569054312884751475200*S(15,6,6,6,6,3)+
39663230727217353512256000*S(15,9,6,6,3,3)+
9443626363623179407680000*S(15,9,9,3,3,3)+
53120398295380384168200*S(16,10,10,4,1,1)+
13944104552537350844152500*S(16,10,4,4,4,4)+
1593611948861411525046000*S(16,10,7,4,4,1)+
182127079869875602862400*S(16,10,7,7,1,1)+
742942633501823554800*S(16,13,10,1,1,1)+
195022441294228683135000*S(16,13,4,4,4,1)+
22288279005054706644000*S(16,13,7,4,1,1)+
1393017437815919165250*S(16,16,4,4,1,1)+
159201992893247904600*S(16,16,7,1,1,1)+
47808358465842345751380000*S(16,7,7,4,4,4)+
5463812396096268085872000*S(16,7,7,7,4,1)+
429508247179760111563200*S(17,11,5,5,2,2)+
76697901282100019922000*S(17,11,8,2,2,2)+
11799677120323079988000*S(17,14,5,2,2,2)+
173524663534162941000*S(17,17,2,2,2,2)+
39686562039409834308439680*S(17,5,5,5,5,5)+
7086886078466041840792800*S(17,8,5,5,5,2)+
1265515371154650328713000*S(17,8,8,5,2,2)+
88376182547275743120000*S(18,12,3,3,3,3)+
4082979633684139332144000*S(18,6,6,6,3,3)+
972138008020033174320000*S(18,9,6,3,3,3)+
219279249929330791200*S(19,10,10,1,1,1)+
57560803106449332690000*S(19,10,4,4,4,1)+
6578377497879923736000*S(19,10,7,4,1,1)+
805046197292997660000*S(19,13,4,4,1,1)+ 92005279690628304000*S(19,13,7,1,1,1)+
5750329980664269000*S(19,16,4,1,1,1)+ 23737172262804000*S(19,19,1,1,1,1)+
1726824093193479980700000*S(19,7,4,4,4,4)+
197351324936397712080000*S(19,7,7,4,4,1)+
22554437135588309952000*S(19,7,7,7,1,1)+3767616203331229048800*S(20,11,5,2,2,2)+
103505939651956842000*S(20,14,2,2,2,2)+348127737187805564109120*S(20,5,5,5,5,2)+
62165667354965279305200*S(20,8,5,5,2,2)+11101012027672371304500*S(20,8,8,2,2,2)+
61398189980212621536000*S(21,6,6,3,3,3)+14618616661955386080000*S(21,9,3,3,3,3)+
149508579497270994000*S(22,10,4,4,1,1)+ 17086694799688113600*S(22,10,7,1,1,1)+
2091029083877916000*S(22,13,4,1,1,1)+ 14935922027699400*S(22,16,1,1,1,1)+
39246002118033635925000*S(22,4,4,4,4,4)+ 4485257384918129820000*S(22,7,4,4,4,1)+
512600843990643408000*S(22,7,7,4,1,1)+ 21273948070757928000*S(23,11,2,2,2,2)+
1965712801738032547200*S(23,5,5,5,2,2)+ 351020143167505812000*S(23,8,5,2,2,2)+
606701482017911280000*S(24,6,3,3,3,3)+ 260014920864819120*S(25,10,4,1,1,1)+
3636572319787680*S(25,13,1,1,1,1)+ 68253916727015019000*S(25,4,4,4,4,1)+
7800447625944573600*S(25,7,4,4,1,1)+ 891479728679379840*S(25,7,7,1,1,1)+
7560433852838586720*S(26,5,5,2,2,2)+ 1350077473721176200*S(26,8,2,2,2,2)+
4148386201831872000*S(27,3,3,3,3,3)+ 317478535854480*S(28,10,1,1,1,1)+
83338115661801000*S(28,4,4,4,1,1)+ 9524356075634400*S(28,7,4,1,1,1)+
20690842509136800*S(29,5,2,2,2,2)+ 74160725839200*S(31,4,4,1,1,1)+
8475511524480*S(31,7,1,1,1,1)+ 41715408284550*S(32,2,2,2,2,2)+
49572677700*S(34,4,1,1,1,1)+ 25520040*S(37,1,1,1,1,1)+
28134136874960721985380000*S(9,9,9,9,6)+
21430633306745590937957376000*S(7,7,7,7,7,7)+
9229403601830864847303909000*S(8,8,8,8,5,5)+
1648107786041225865589983750*S(8,8,8,8,8,2)+
9925723489486142716442064000*S(9,9,6,6,6,6)+
2363267497496700646771920000*S(9,9,9,6,6,3)+
562682737499214439707600000*S(9,9,9,9,3,3)];
#
#
# 1: da=ad
# 2: bd=db
# 3: ca=ac
# 4: ae=ea
# 5: bf=fb
# 6: ec=ce
# 7: bc=cb
# 8: eb=be
# 9: ded=ede
# 10: dfd=fdf
# 11: bab=aba
# 12: fcf=cfc
# 13: afa=faf
# 14: fef=efe
# 15: cdc=dcd
# 16: cdefcd=defcde
#
#  (acbdef)^7 is central
#
# c->Ece then d->cdC gives length 84
# 
# 1: df=fd
# 2: de=ed
# 3: bd=db
# 4: eb=be
# 5: ca=ac
# 6: da=ad
# 7: bf=fb
# 8: ae=ea
# 9: bc=cb
# 10: fcf=cfc
# 11: dcd=cdc
# 12: bab=aba
# 13: afa=faf
# 14: efe=fef
# 15: cec=ece
# 16: cfecfe=fecfec
#
#  (abdcfe)^7 is central
