#############################################################################
##
#A  tbl/weyle8.g                  CHEVIE library                  Jean Michel
##
#Y  Copyright (C) 1994 - 2001  The CHEVIE Team
##
##  This file contains the character table of the Hecke algebras of type E8.
##
CHEVIE.Revision("tbl/weyle8.g",
   "$Id: weyle8.g,v 1.3 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("ReflectionDegrees","E8",[2,8,12,14,18,20,24,30]);

CHEVIE.AddData("Size", "E8", function(arg) return 696729600; end);

CHEVIE.AddData("GeneratingRoots", "E8", function(arg) return
[ [1,-1,-1,-1,-1,-1,-1,1]/2,
  [1,1,0,0,0,0,0,0],
  [-1,1,0,0,0,0,0,0],
  [0,-1,1,0,0,0,0,0],
  [0,0,-1,1,0,0,0,0],
  [0,0,0,-1,1,0,0,0],
  [0,0,0,0,-1,1,0,0],
  [0,0,0,0,0,-1,1,0] ];
end);

CHEVIE.AddData("FundamentalGroup","E8",[]);
CHEVIE.AddData("CenterSimplyConnected","E8",[]);

CHEVIE.AddData("NrConjugacyClasses", "E8", 112);

CHEVIE.AddData("WordsClassRepresentatives","E8",List(
[[],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[2,3,4,2,3,4,5,4,2,3,4,5],[1,6],[2,3,4,2,
3,4,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,4,2,3,4,5,6,7],[2,3,1,4,2,3,1,4,5,4,2,3,
4,5,6,5,4,2,3,4,5,7,6,5,4,8,7,6,0,0,0,0],[2,3,5,7],[6,7],[1,2,3,1,4,2,3,1,4,3,
5,4,2,3,1,4,3,5,4,2,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,1,7,6,5,4,2,3,1,4,3,5,4,2,6,
5,4,3,7,6,5,4,0],[0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0],[1,2,3,4,3,1,5,4,2,3,4,5,6,
5,4,2,3,1,4,3,5,4,6,5],[3,1,4,3,1,5,4,2,3,1,4,3,5,4,6,5,7,6,0,0,0],[2,4,7,8],
[1,2,3,1,4,3,1,5,4,3,1,6,5,4,3,1,7,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,7,6,5,4,0],
[2,4,2,3,4,5],[1,2,3,1,4,2,3,1,4,3,5,4,2,3,1,4,3,5,4,2,6,5,4,2,3,1,4,3,5,4,6,
7,6,5,4,2,3,1,4,3,5,4,2,6,5,4,8,7,6,5,0,0],[2,3,4,2,3,4,6,5,7,6,5,4,2,3,4,5],
[3,7,6,8],[1,2,3,4,2,3,4,5,4,2,3,4,5,7],[1,2,3,4,5,6,0,0,0],[1,4,3,7,6,8],[3,
5,4,6],[2,3,4,2,3,4,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,4,0],[0,0,0,0,0,0],[0,0,
0],[2,3,4,2,3,4,5,4,2,3,4,5,8,7],[5,4,2,3],[2,3,1,4,2,3,1,5,4,3,1,6,5,4,2,3,1,
4,3,5,4,2,6,5,4,7,6,5,0,0],[1,4,5,7],[2,3,4,2,3,4,5,4,2,3,4,5,6,7],[2,3,4,5,0,
0],[3,4,2,3,5,4,2,3,1,4,5,6],[4,3,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,4,2,3,4,5,
6,7,8,7,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,1,7,8],[2,3,4,2,3,4,5,4,2,3,1,4,5,6],[2,
5,4,3,8,7],[2,3,1,5,7,8],[2,5,4,6,5,4,2,3,4,7],[5,4,6,5,4,2,3,7,6,5,4,2,3,8,7,
6,5,4,2,3,1,4],[1,4,2,6,5,7],[2,5,4,6,8,7],[3,4,2,3,5,4,3,6,5,4,0],[2,3,5,4,6,
8],[2,4,2,3,4,5,6,7],[3,4,3,5,4,2,3,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,7,6,5,4,0],
[3,1,4,2,5,4,2,6],[2,3,4,2,3,4,5,4,0],[1,3,4,2,3,1,4,3,5,4,6,5,0,0],[2,3,4,3,
5,4,0],[1,2,6,5,7,8],[2,3,5,4,7,6],[4,3,5,4,0],[3,4,2,3,4,5,7,8],[1,3,1,4,5,4,
3,6,5,4,2,3,1,4,3,5,4,2,7,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,7,6,5,4,0],[1,2,3,4,2,
3,1,4,3,5,4,2,3,4,5,6,5,4,0],[1,2,3,1,4,2,5,4,2,3,4,6,5,4,0],[1,4,2,3,6,5],[1,
2,3,1,4,2,3,1,4,3,5,4,3,6,5,4,0],[1,2,3,5,7,6],[1,2,3,4,2,5,4,8],[3,4,0],[3,1,
8,7,6,5],[2,4,2,3,5,4,2,3,4,6,5,4,2,3,7,6,5,4,0],[0,0],[0],[3],[1,2,3,1,4,2,3,
1,4,3,5,4,2,3,1,4,3,5,4,2,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,1,7,6,5,4,2,3,1,4,3,5,
4,2,6,5,4,3,1,7,6,5,4,2,3,4,5,6,7],[1,6,8],[2,3,4,2,3,4,5,4,2,3,4,5,7],[1,4,
3],[2,3,4,2,3,4,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,4,2,3,4,5,6,7,8],[2,3,4,2,3,
4,5,4,2,3,4,5,6],[3,5,4,2,3,4,8],[2,4,2,3,4,5,4,2,3,1,4,3,5,6,5,4,2,3,4,5,6,7,
6,5,4,2,3,1,4,3,5,6,7],[2,3,4,5,4,2,3,4,5,7,6,8,7,6,5,4,2,3,4,5,6],[1,2,5,4,
8],[1,4,2],[2,3,4,2,3,4,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,4,2,3,1,4,5,6,7],[3,
1,4,3,1,5,4,2,3,1,4,5,6,5,4,2,3,1,4,3,5,4,2,6,8],[1,2,3,4,2,3,5,4,2,3,1,4,6,5,
4,2,3,4,5,6,7],[2,3,1,5,8],[5,4,2,3,7],[3,1,6,5,8],[2,3,4,2,3,1,4,5,4,2,6,5,4,
2,3,1,4,3,5,4,6,5,7],[1,2,3,1,4,2,3,5,4,2,3,1,4,3,5,4,6,5,4,2,3,4,5,6,7],[1,2,
3,4,2,6,5,4,2,3,4,5,8],[2,5,4,7,6],[2,3,4,2,3,4,5,4,2,3,1,4,5,6,8],[2,3,1,5,
4],[2,3,4,2,3,4,5,4,2,3,4,5,7,6,8],[2,3,5,6,5,4,2,3,4,7,6,5,4,2,3,1,4],[1,4,3,
6,5,8,7],[1,2,5,4,6],[1,2,3,4,2,3,4,6,5,4,2,3,4,5,7],[2,3,4,2,3,4,5,4,2,3,1,4,
5,8,7],[4,2,5,4,2,3,1],[4,2,3,7,6],[2,3,4,2,3,4,5,7,6,5,4,2,3,4,5,6,8],[1,4,2,
5,4,2,3,7,8],[6,5,4,2,3,7,8],[1,4,2,3,6,5,8],[4,2,5,4,3,1,6,5,7,6,5],[1,2,4,6,
5,8,7],[3,1,4,2,5,4,2,6,7],[3,1,5,4,2,3,4,6,8],[2,6,5,4,3,1,7],[1,4,2,3,6,8,
7],[2,5,4,2,3,4,7,6,8],[4,2,3,1,5,7,8],[4,3,5,4,2,3,4,5,6,8,7],[2,3,1,6,5,8,
7],[2,4,2,3,1,6,5,4,2,3,4,5,7]],x->Replace(x,[0],[1..8])));

CHEVIE.AddData("ClassNames","E8",
  [ "A_0", "8A_1", "4A_1'", "2A_1", "6A_1", "2D_4(a_1)",
  "4A_1''", "A_2", "D_4+4A_1", "4A_2", "E_8(a_8)", "3A_2", "E_7(a_4)+A_1",
  "2A_2", "2D_4", "D_4(a_1)", "2A_3+2A_1", "2A_3'", "A_3+A_1",
  "A_3+3A_1", "D_8(a_3)", "2A_3''", "A_4", "D_6+2A_1", "2A_4",
  "E_8(a_6)", "A_2+4A_1", "D_4", "E_6(a_2)+A_2", "A_2+2A_1",
  "D_4+2A_1", "E_8(a_3)", "E_6(a_2)", "A_5+A_2+A_1", "A_5+A_1'",
  "D_4+A_2", "2A_2+2A_1", "D_6(a_2)",
  "D_8(a_1)", "A_5+A_1''", "A_6", "D_8", "D_5+A_1", "D_6(a_1)",
  "A_7+A_1", "E_6(a_1)", "E_7+A_1", "A_8", "E_8(a_4)", "A_4+2A_1",
  "D_6", "E_8(a_2)", "D_4(a_1)+A_2", "D_5(a_1)+A_3", "E_6+A_2",
  "E_8(a_7)", "E_6", "E_7(a_2)+A_1", "A_3+A_2+A_1", "D_5(a_1)+A_1",
  "E_8(a_1)", "A_4+A_2", "D_8(a_2)", "E_8(a_5)", "E_8", "A_1", "7A_1",
  "3A_1", "5A_1", "A_3", "A_3+4A_1", "A_3+2A_1'", "D_4(a_1)+A_1",
  "2A_3+A_1", "D_4(a_1)+A_3", "A_3+2A_1''", "A_2+A_1", "D_4+3A_1",
  "3A_2+A_1", "E_7(a_4)", "A_2+3A_1", "D_4+A_1", "2A_2+A_1",
  "D_6(a_2)+A_1", "A_5+A_2", "E_6(a_2)+A_1", "A_5", "A_5+2A_1",
  "D_5", "D_5+2A_1", "A_7'", "A_7''", "A_4+A_1", "D_6+A_1",
  "A_3+A_2+2A_1", "D_5(a_1)", "A_3+A_2", "D_4+A_3", "D_5(a_1)+A_2",
  "D_7", "E_6+A_1", "E_7(a_2)", "A_6+A_1", "E_7(a_1)", "E_6(a_1)+A_1",
  "E_7", "A_4+A_3", "D_7(a_1)", "D_5+A_2", "D_7(a_2)", "A_4+A_2+A_1",
  "E_7(a_3)" ]);

CHEVIE.AddData("ClassInfo","E8",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","E8"),
    classnames:=CHEVIE.RawData("ClassNames","E8"),
    classparams:=CHEVIE.RawData("ClassNames","E8"),
    orders:=[1,2,2,2,2,4,2,3,6,3,6,3,6,3,6,4,4,4,4,4,8,4,5,10,5,10,6,6,6,6,6,
      12,6,6,6,6,6,6,12,6,7,14,8,8,8,9,18,9,18,10,10,20,12,12,12,12,12,12,12,
      12,24,15,30,15,30,2,2,2,2,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,8,8,8,8,
      10,10,12,12,12,12,12,12,12,12,14,14,18,18,20,20,24,24,30,30],
    classes:=[1,1,3150,3780,3780, 15120, 113400, 2240, 2240, 4480, 4480, 89600,
  89600, 268800, 268800, 37800, 37800, 680400, 907200, 907200, 3628800,
  5443200, 580608, 580608, 1161216, 1161216, 100800, 100800, 403200, 604800,
  604800, 2419200, 806400, 806400, 1612800, 3225600, 2419200, 2419200,
  9676800, 14515200, 24883200, 24883200, 10886400, 5443200, 5443200, 6451200,
  6451200, 12902400, 12902400, 8709120, 8709120, 34836480, 1209600, 1209600,
  2419200, 2419200, 4838400, 4838400, 7257600, 7257600, 29030400, 11612160,
  11612160, 23224320, 23224320, 120, 120, 37800, 37800, 45360, 45360, 151200,
  453600, 453600, 907200, 2721600, 80640, 80640, 268800, 268800, 1209600,
  1209600, 1612800, 1612800, 2419200, 2419200, 4838400, 4838400, 1814400,
  1814400, 10886400, 43545600, 5806080, 5806080, 1209600, 1209600, 3628800,
  3628800, 9676800, 29030400, 14515200, 14515200, 24883200, 24883200,
  19353600, 19353600, 17418240, 17418240, 14515200, 14515200, 11612160,
  11612160 ]));

CHEVIE.AddData("ParabolicRepresentatives", "E8", 
[[],[1],[1,2],[1..3],[1..4],[1..5],[1..6],[1..7],[1..8],[1,2,3,4,5,6,8],
[1,2,3,4,5,7],[1,2,3,4,5,7,8],[1,2,3,4,6],[1,2,3,4,6,7],[1,2,3,4,6,7,8],
[1,2,3,4,6,8],[1,2,3,5],[1,2,3,5,6],[1,2,3,5,6,7],[1,2,3,5,6,7,8],[1,2,3,5,6,8],
[1,2,3,5,7],[1,2,4,5],[1,2,4,5,6,7],[1,2,4,5,6,7,8],[1,2,4,5,7],[1,2,5],[1,2,5,7],
[1,3],[1,3,4],[1,3,4,5,6],[1,3,4,5,6,7],[1,3,4,5,6,7,8],[1,3,4,6,7],
[1,3,4,6,7,8],[1,3,5,6],[2..5],[2..7],[2..8],[2,3,4,5,7],[2,3,4,5,7,8]]);

CHEVIE.AddData("CharInfo","E8",function()local res;
  res:=rec(charparams:=[[1, 0], [1, 120], [28, 8], [28, 68], [35, 2],
     [35, 74], [70, 32], [50, 8], [50, 56], [84, 4], [84, 64],
     [168, 24], [175, 12], [175, 36], [210, 4], [210, 52], [420, 20],
     [300, 8], [300, 44], [350, 14], [350, 38], [525, 12], [525, 36],
     [567, 6], [567, 46], [1134, 20], [700, 16], [700, 28], [700, 6],
     [700, 42], [1400, 20], [840, 14], [840, 26], [1680, 22], [972, 12],
     [972, 32], [1050, 10], [1050, 34], [2100, 20], [1344, 8], [1344, 38],
     [2688, 20], [1400, 8], [1400, 32], [1575, 10], [1575, 34], [3150, 18],
     [2100, 16], [2100, 28], [4200, 18], [2240, 10], [2240, 28], [4480, 16],
     [2268, 10], [2268, 30], [4536, 18], [2835, 14], [2835, 22], [5670, 18],
     [3200, 16], [3200, 22], [4096, 12], [4096, 26], [4200, 12], [4200, 24],
     [6075, 14], [6075, 22], [8, 1], [8, 91], [56, 19], [56, 49],
     [112, 3], [112, 63], [160, 7], [160, 55], [448, 25], [400, 7],
     [400, 43], [448, 9], [448, 39], [560, 5], [560, 47], [1344, 19],
     [840, 13], [840, 31], [1008, 9], [1008, 39], [2016, 19], [1296, 13],
     [1296, 33], [1400, 11], [1400, 29], [1400, 7], [1400, 37], [2400, 17],
     [2400, 23], [2800, 13], [2800, 25], [5600, 19], [3240, 9], [3240, 31],
     [3360, 13], [3360, 25], [7168, 17], [4096, 11], [4096, 27], [4200, 15],
     [4200, 21], [4536, 13], [4536, 23], [5600, 15], [5600, 21]],
  frame:=["1_x","1_x'","28_x","28_x'","35_x", "35_x'", "70_y", "50_x", "50_x'",
  "84_x", "84_x'", "168_y", "175_x", "175_x'", "210_x", "210_x'", "420_y",
  "300_x", "300_x'", "350_x", "350_x'", "525_x", "525_x'", "567_x", "567_x'",
  "1134_y", "700_xx", "700_xx'", "700_x", "700_x'", "1400_y", "840_x",
  "840_x'", "1680_y", "972_x", "972_x'", "1050_x", "1050_x'", "2100_y",
  "1344_x", "1344_x'", "2688_y", "1400_x", "1400_x'", "1575_x", "1575_x'",
  "3150_y", "2100_x", "2100_x'", "4200_y", "2240_x", "2240_x'", "4480_y",
  "2268_x", "2268_x'", "4536_y", "2835_x", "2835_x'", "5670_y", "3200_x",
  "3200_x'", "4096_x", "4096_x'", "4200_x", "4200_x'", "6075_x", "6075_x'",
  "8_z", "8_z'", "56_z", "56_z'", "112_z", "112_z'", "160_z", "160_z'",
  "448_w", "400_z", "400_z'", "448_z", "448_z'", "560_z", "560_z'", "1344_w",
  "840_z", "840_z'", "1008_z", "1008_z'", "2016_w", "1296_z", "1296_z'",
  "1400_zz", "1400_zz'", "1400_z", "1400_z'", "2400_z", "2400_z'", "2800_z",
  "2800_z'", "5600_w", "3240_z", "3240_z'", "3360_z", "3360_z'", "7168_w",
  "4096_z", "4096_z'", "4200_z", "4200_z'", "4536_z", "4536_z'", "5600_z",
  "5600_z'" ],
  extRefl:=[1,68,3,70,7,71,4,69,2]);
  res.b:=List(res.charparams,x->x[2]);
  return res;
end);

CHEVIE.AddData("cyclestructure","E8",
  [ [  ], [ 120 ], [ 108 ], [ 90 ], [ 118 ], [ ,, 60 ], [ 116 ], [ , 56 ],
  [ 36,,,, 28 ], [ , 80 ], [ ,,,, 40 ], [ , 78 ], [ 3,,,, 39 ], [ , 76 ],
  [ 6,,,, 38 ], [ ,, 54 ], [ 12,, 54 ], [ 10,, 54 ], [ 23,, 45 ],
  [ 29,, 45 ], [ ,,,,,, 30 ], [ 4,, 58 ], [ ,,, 44 ], [ 10,,,,,,,, 22 ],
  [ ,,, 48 ], [ ,,,,,,,, 24 ], [ 36, 8,,, 24 ], [ 24,,,, 28 ], [ , 8,,, 36 ],
  [ 30, 16,,, 20 ], [ 34,,,, 28 ], [ ,,,,,,,,,, 20 ], [ , 6,,, 36 ],
  [ 3, 8,,, 35 ], [ 3, 6,,, 35 ], [ 6, 8,,, 34 ], [ 6, 20,,, 28 ],
  [ 4,,,, 38 ], [ ,, 3,,,,,,,, 19 ], [ 5, 2,,, 37 ], [ ,,,,, 34 ],
  [ 1,,,,,,,,,,,, 17 ], [ 11,,,,,, 27 ], [ ,, 5,,,, 27 ], [ 2,, 5,,,, 27 ],
  [ ,,,,,,, 26 ], [ 3,,,,,,,,,,,,,,,, 13 ], [ , 2,,,,,, 26 ],
  [ ,,,, 1,,,,,,,,,,,, 13 ], [ 10,,, 12,,,,, 16 ], [ 8,,,,,,,, 22 ],
  [ ,,,,,,,,,,,,,,,,,, 12 ], [ , 8, 18,,,,,,,, 12 ], [ ,, 18,, 4,,,,,, 12 ],
  [ , 8,,,,,,,,, 18 ], [ ,,,, 4,,,,,, 18 ], [ , 6,,,,,,,,, 18 ],
  [ 3,,,, 3,,,,,, 18 ], [ 5, 4, 15,, 6,,,,,, 10 ], [ 5,, 15,, 8,,,,,, 10 ],
  [ ,,,,,,,,,,,,,,,,,,,,,, 10 ], [ , 6,, 14,,,,,,,,,, 10 ],
  [ 1,,,, 3,,,, 7,,,,,,,,,,,,,,,,,,,, 5 ], [ ,,,,,,,,,,,,, 16 ],
  [ ,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8 ], [ 57 ], [ 119 ], [ 107 ], [ 117 ],
  [ 10,, 45 ], [ 30,, 45 ], [ 24,, 45 ], [ 9,, 54 ], [ 11,, 54 ], [ 2,, 59 ],
  [ 28,, 45 ], [ 21, 32,,, 12 ], [ 35,,,, 28 ], [ 3, 42,,, 18 ],
  [ 2,,,, 39 ], [ 35, 8,,, 24 ], [ 33,,,, 28 ], [ 3, 40,,, 18 ],
  [ 5,,,, 38 ], [ 2, 8,,, 35 ], [ 3, 2,,, 38 ], [ 2, 6,,, 35 ],
  [ 6, 2,,, 37 ], [ 6,,,,,, 27 ], [ 12,,,,,, 27 ], [ 1,, 5,,,, 27 ],
  [ ,, 2,,,, 29 ], [ 7,,, 24,,,,, 10 ], [ 9,,,,,,,, 22 ],
  [ 6, 4, 15,, 6,,,,,, 10 ], [ ,, 15,, 8,,,,,, 10 ],
  [ 4, 12, 15,, 2,,,,,, 10 ], [ 6,, 15,, 8,,,,,, 10 ],
  [ , 4, 3,, 8,,,,,, 14 ], [ 2,, 2,,,,,,,, 19 ], [ 3, 2,,, 2,,,,,, 18 ],
  [ 2,,,, 3,,,,,, 18 ], [ 1,,,,, 18,,,,,,, 8 ], [ ,,,,,,,,,,,, 17 ],
  [ 3,,,,,,, 14,,,,,,,,, 6 ], [ 2,,,,,,,,,,,,,,,, 13 ],
  [ ,, 5, 8,,,,, 2,,,,,,,,,, 8 ], [ ,, 5,,,,,, 6,,,,,,,,,, 8 ],
  [ , 4,,, 2,, 9,,,,,,,,,,,,,,,, 6 ], [ ,,,, 4,, 9,,,,,,,,,,,,,,,, 6 ],
  [ 1, 2,, 6, 2,,,, 4,,,,, 6,,,,,,,,,,,,,,, 2 ],
  [ ,,,, 3,,,, 7,,,,,,,,,,,,,,,,,,,, 5 ] ]);

CHEVIE.AddData("generators","E8",[ (  1,121)(  3,  9)( 11, 16)
        ( 17, 23)( 19, 24)( 25, 30)( 27, 31)( 32, 37)
    ( 33, 38)( 35, 39)( 40, 45)( 41, 46)( 43, 47)( 48, 52)( 49, 53)( 50, 54)
    ( 55, 59)( 56, 60)( 61, 66)( 62, 67)( 68, 73)( 74, 79)( 93, 97)( 98,101)
    (102,104)(105,107)(108,109)(110,111)(112,113)(123,129)(131,136)(137,143)
    (139,144)(145,150)(147,151)(152,157)(153,158)(155,159)(160,165)(161,166)
    (163,167)(168,172)(169,173)(170,174)(175,179)(176,180)(181,186)(182,187)
    (188,193)(194,199)(213,217)(218,221)(222,224)(225,227)(228,229)(230,231)
    (232,233), (  2,122)(  4, 10)( 11, 17)( 12, 18)( 16, 23)( 19, 25)( 20, 26)
    ( 24, 30)( 27, 33)( 28, 34)( 31, 38)( 35, 41)( 36, 42)( 39, 46)( 43, 50)
    ( 47, 54)( 63, 69)( 70, 75)( 76, 80)( 77, 81)( 82, 85)( 83, 86)( 87, 90)
    ( 88, 91)( 92, 95)( 96,100)(110,112)(111,113)(114,115)(124,130)(131,137)
    (132,138)(136,143)(139,145)(140,146)(144,150)(147,153)(148,154)(151,158)
    (155,161)(156,162)(159,166)(163,170)(167,174)(183,189)(190,195)(196,200)
    (197,201)(202,205)(203,206)(207,210)(208,211)(212,215)(216,220)(230,232)
    (231,233)(234,235), (  1,  9)(  3,123)(  4, 11)( 10, 17)( 12, 19)( 18, 25)
    ( 20, 27)( 26, 33)( 28, 35)( 34, 41)( 36, 43)( 37, 44)( 42, 50)( 45, 51)
    ( 52, 57)( 53, 58)( 59, 64)( 60, 65)( 66, 71)( 67, 72)( 73, 78)( 79, 84)
    ( 89, 93)( 94, 98)( 99,102)(103,105)(106,108)(111,114)(113,115)(121,129)
    (124,131)(130,137)(132,139)(138,145)(140,147)(146,153)(148,155)(154,161)
    (156,163)(157,164)(162,170)(165,171)(172,177)(173,178)(179,184)(180,185)
    (186,191)(187,192)(193,198)(199,204)(209,213)(214,218)(219,222)(223,225)
    (226,228)(231,234)(233,235), (  2, 10)(  3, 11)(  4,124)(  5, 12)(  9, 16)
    ( 13, 20)( 21, 28)( 25, 32)( 29, 36)( 30, 37)( 33, 40)( 38, 45)( 41, 49)
    ( 46, 53)( 50, 56)( 54, 60)( 57, 63)( 64, 70)( 71, 76)( 72, 77)( 78, 83)
    ( 84, 88)( 85, 89)( 90, 94)( 95, 99)(100,103)(108,110)(109,111)(115,116)
    (122,130)(123,131)(125,132)(129,136)(133,140)(141,148)(145,152)(149,156)
    (150,157)(153,160)(158,165)(161,169)(166,173)(170,176)(174,180)(177,183)
    (184,190)(191,196)(192,197)(198,203)(204,208)(205,209)(210,214)(215,219)
    (220,223)(228,230)(229,231)(235,236), (  4, 12)(  5,125)(  6, 13)( 10, 18)
    ( 11, 19)( 14, 21)( 16, 24)( 17, 25)( 22, 29)( 23, 30)( 40, 48)( 45, 52)
    ( 49, 55)( 51, 57)( 53, 59)( 56, 62)( 58, 64)( 60, 67)( 65, 72)( 76, 82)
    ( 80, 85)( 83, 87)( 86, 90)( 88, 92)( 91, 95)(103,106)(105,108)(107,109)
    (116,117)(124,132)(126,133)(130,138)(131,139)(134,141)(136,144)(137,145)
    (142,149)(143,150)(160,168)(165,172)(169,175)(171,177)(173,179)(176,182)
    (178,184)(180,187)(185,192)(196,202)(200,205)(203,207)(206,210)(208,212)
    (211,215)(223,226)(225,228)(227,229)(236,237),
  (  5, 13)(  6,126)(  7, 14)( 12, 20)( 15, 22)( 18, 26)( 19, 27)( 24, 31)
    ( 25, 33)( 30, 38)( 32, 40)( 37, 45)( 44, 51)( 55, 61)( 59, 66)( 62, 68)
    ( 64, 71)( 67, 73)( 70, 76)( 72, 78)( 75, 80)( 77, 83)( 81, 86)( 92, 96)
    ( 95,100)( 99,103)(102,105)(104,107)(117,118)(125,133)(127,134)(132,140)
    (135,142)(138,146)(139,147)(144,151)(145,153)(150,158)(152,160)(157,165)
    (164,171)(175,181)(179,186)(182,188)(184,191)(187,193)(190,196)(192,198)
    (195,200)(197,203)(201,206)(212,216)(215,220)(219,223)(222,225)(224,227)
    (237,238), (  6, 14)(  7,127)(  8, 15)( 13, 21)( 20, 28)( 26, 34)( 27, 35)
    ( 31, 39)( 33, 41)( 38, 46)( 40, 49)( 45, 53)( 48, 55)( 51, 58)( 52, 59)
    ( 57, 64)( 63, 70)( 68, 74)( 69, 75)( 73, 79)( 78, 84)( 83, 88)( 86, 91)
    ( 87, 92)( 90, 95)( 94, 99)( 98,102)(101,104)(118,119)(126,134)(128,135)
    (133,141)(140,148)(146,154)(147,155)(151,159)(153,161)(158,166)(160,169)
    (165,173)(168,175)(171,178)(172,179)(177,184)(183,190)(188,194)(189,195)
    (193,199)(198,204)(203,208)(206,211)(207,212)(210,215)(214,219)(218,222)
    (221,224)(238,239), (  7, 15)(  8,128)( 14, 22)( 21, 29)( 28, 36)( 34, 42)
    ( 35, 43)( 39, 47)( 41, 50)( 46, 54)( 49, 56)( 53, 60)( 55, 62)( 58, 65)
    ( 59, 67)( 61, 68)( 64, 72)( 66, 73)( 70, 77)( 71, 78)( 75, 81)( 76, 83)
    ( 80, 86)( 82, 87)( 85, 90)( 89, 94)( 93, 98)( 97,101)(119,120)(127,135)
    (134,142)(141,149)(148,156)(154,162)(155,163)(159,167)(161,170)(166,174)
    (169,176)(173,180)(175,182)(178,185)(179,187)(181,188)(184,192)(186,193)
    (190,197)(191,198)(195,201)(196,203)(200,206)(202,207)(205,210)(209,214)
    (213,218)(217,221)(239,240) ]);

CHEVIE.AddData("CartanMat","E8",
  [ [ 2, 0, -1, 0, 0, 0, 0, 0 ], [ 0, 2, 0, -1, 0, 0, 0, 0 ],
      [ -1, 0, 2, -1, 0, 0, 0, 0 ], [ 0, -1, -1, 2, -1, 0, 0, 0 ],
      [ 0, 0, 0, -1, 2, -1, 0, 0 ], [ 0, 0, 0, 0, -1, 2, -1, 0 ],
      [ 0, 0, 0, 0, 0, -1, 2, -1 ], [ 0, 0, 0, 0, 0, 0, -1, 2 ] ]);

CHEVIE.AddData("PowerMaps","E8",
  [ , [ 1, 1, 1, 1, 1, 2, 1, 8, 8, 10, 10, 12, 12, 14, 14, 3, 3, 3, 4, 4, 6, 7,
      23, 23, 25, 25, 8, 8, 10, 8, 8, 11, 12, 12, 14, 14, 14, 14, 15, 14, 41,
      41, 16, 18, 18, 46, 46, 48, 48, 23, 23, 26, 27, 27, 29, 29, 33, 33, 30,
      30, 32, 62, 62, 64, 64, 1, 1, 1, 1, 4, 4, 4, 3, 3, 5, 4, 8, 8, 12, 12,
      8, 8, 14, 14, 12, 12, 14, 14, 16, 16, 18, 22, 23, 23, 30, 30, 30, 30,
      37, 38, 33, 33, 41, 41, 46, 46, 50, 50, 53, 53, 62, 62 ],
  [ 1, 2, 3, 4, 5, 6, 7, 1, 2, 1, 2, 1, 2, 1, 2, 16, 17, 18, 19, 20, 21, 22,
      23, 24, 25, 26, 3, 3, 3, 4, 5, 6, 3, 3, 3, 3, 4, 5, 6, 7, 41, 42, 43,
      44, 45, 12, 13, 12, 13, 50, 51, 52, 16, 17, 16, 17, 16, 17, 19, 20, 21,
      23, 24, 25, 26, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 66, 67, 66,
      67, 68, 69, 66, 67, 68, 69, 68, 69, 89, 90, 91, 92, 93, 94, 72, 72, 70,
      71, 72, 75, 73, 74, 103, 104, 79, 80, 107, 108, 89, 90, 93, 94 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 1, 2, 1, 2, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 4, 5, 6, 53, 54, 55, 56, 57,
      58, 59, 60, 61, 8, 9, 10, 11, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75,
      76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 66,
      67, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 70, 71, 109,
      110, 77, 78 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 1, 2, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 66, 67, 105, 106, 107, 108,
      109, 110, 111, 112 ] ]);

CHEVIE.AddData("vpolheckeirreducibles","E8",
[[[[1],0],[[1],120],[[1],12],[[1],2],[[1],30],[[1],60],[[1],4],[[1],2],[[1],
64],[[1],80],[[1],40],[[1],24],[[1],42],[[1],4],[[1],44],[[1],6],[[1],66],
[[1],16],[[1],4],[[1],14],[[1],30],[[1],6],[[1],4],[[1],32],[[1],48],[[1],24],
[[1],14],[[1],4],[[1],44],[[1],4],[[1],14],[[1],20],[[1],12],[[1],46],[[1],
14],[[1],6],[[1],6],[[1],10],[[1],22],[[1],6],[[1],6],[[1],18],[[1],6],[[1],
8],[[1],34],[[1],8],[[1],16],[[1],28],[[1],14],[[1],6],[[1],6],[[1],12],[[1],
8],[[1],46],[[1],26],[[1],22],[[1],6],[[1],24],[[1],6],[[1],8],[[1],10],[[1],
6],[[1],26],[[1],16],[[1],8],[[1],1],[[1],63],[[1],3],[[1],13],[[1],3],[[1],
31],[[1],13],[[1],7],[[1],33],[[1],21],[[1],5],[[1],3],[[1],31],[[1],25],[[1],
21],[[1],5],[[1],5],[[1],5],[[1],23],[[1],25],[[1],13],[[1],5],[[1],15],[[1],
5],[[1],15],[[1],17],[[1],7],[[1],5],[[1],15],[[1],15],[[1],7],[[1],5],[[1],
17],[[1],9],[[1],7],[[1],7],[[1],11],[[1],7],[[1],9],[[1],9],[[1],7],[[1],7],
[[1],9],[[1],7],[[1],11],[[1],7],[[1],13]],,
[[[28],0],[[28],90],[[6,0,0,-16,0,0,6],6],[[1,-12,15],0],[[15,0,0,0,0,-12,0,0,
0,0,1],20],[[4],45],[[6,-16,6],2],[[1,-6,15],0],[[15,0,0,0,-6,0,0,0,1],46],
[[10],60],[[10],30],[[6,0,0,0,-6,0,0,0,1],16],[[1,-6,6],30],[[3,-8,6],2],[[6,
-8,3],32],[[2,0,0,6],3],[[6,0,0,2],48],[[1,2,0,-4,0,0,1],10],[[2,-8,6],2],[[3,
0,4,-6,0,-2,1],8],[[],0],[[3,-4,1],4],[[1,-4,6],2],[[6,0,-4,0,1],22],[[3],36],
[[3],18],[[6,0,4,-8,1,-2,1],8],[[-4,6],3],[[3,-4,3],32],[[4,-12,6],2],[[3,0,0,
-6,0,0,1],8],[[-2],15],[[2,0,2,0,1],8],[[8,-4,1],34],[[1,0,1,-4,0,0,1],8],[[2,
-4,1],4],[[8,-8,1],4],[[1],10],[[2,-1],16],[[2,-4,1],4],[[1,-2,1],4],[[],0],
[[1,-4,1],4],[[1,0,0,1],5],[[1,1],24],[[1],8],[[1],10],[[1],20],[[1],10],[[4,
-6,1],4],[[-2,1],5],[[-1],9],[[2,1,-2,1],5],[[3,-2,1],34],[[3,0,0,-1],18],[[3,
-1],16],[[-2,1],5],[[1,-2,1,-1],16],[[5,-6,1],4],[[1,0,-2,1],5],[[],0],[[3,-4,
1],4],[[-1,1],19],[[],0],[[],0],[[-7,21],0],[[21,0,0,0,0,0,0,0,0,-7],45],[[3,
-15,10],1],[[6,0,4,-12,0,-3,3],7],[[1,-5,10],1],[[10,0,0,0,1,-5],21],[[3,0,1,
-9,0,0,3],7],[[2,0,-3,3],4],[[3,2,0,0,0,-3],23],[[3,0,0,-1],15],[[4,-9,3],3],
[[2,-10,10],1],[[10,0,-5,0,1,-5,0,1],21],[[6,0,0,3,-3,0,0,-1],17],[[3,0,0,2],
15],[[7,-12,3],3],[[1,-6,3],3],[[5,-9,3],3],[[1,-2,1,0,-2,1],15],[[3,0,0,0,
-2],17],[[2,-1,1,-1],9],[[1,-3,3],3],[[1,0,3,-2,0,-1],9],[[-3,3],4],[[3,0,0,
-3],9],[[1,0,-1],12],[[1,-1],5],[[2,-6,3],3],[[1,0,0,-2],9],[[3,0,4,-3,1,-1],
9],[[1,0,0,3],4],[[3,-6,3],3],[[1,1,0,-2],11],[[1,1,-1],6],[[-1],6],[[1,-2],
5],[[-1],8],[[2,-2],5],[[],0],[[-1],8],[[-1],6],[[3,-2],5],[[1],6],[[2,-2],5],
[[],0],[[5,-3],5],[[1,0,1],9]],,[[[35],0],[[35],
96],[[9,-16,0,0,10],8],[[1,-12,22],0],[[15,0,5,-12,0,0,0,0,3],22],[[-5],48],
[[6,-16,13],2],[[-7,21],1],[[20,0,-6],50],[[5],64],[[5],32],[[2,0,-6,0,0,0,3],
18],[[-4,3],33],[[1,-10,11],2],[[4,-4,2],34],[[-3,0,10],4],[[9,0,-2],52],[[-4,
0,0,3],13],[[1,-9,11],2],[[8,-7,0,-2,4],10],[[-1],24],[[1,-6,4],4],[[-5,10],
3],[[5],24],[[],0],[[],0],[[13,-8,0,-3,4],10],[[-4,10],3],[[-4,1],35],[[3,-13,
12],2],[[5,-6,0,0,3],10],[[1],16],[[-2,2,0,3],9],[[4,-2,1],36],[[2,-5,0,0,3],
10],[[1,-5,4],4],[[6,-10,6],4],[[-1,0,3],8],[[-2],17],[[1,-5,4],4],[[-3,3],5],
[[],0],[[1,-4,4],4],[[-2,0,3],6],[[1],26],[[-1,0,3],6],[[2],12],[[-1],22],
[[-1],11],[[3,-7,5],4],[[-2,3],5],[[],0],[[-3,-3,4],6],[[-2],37],[[1],22],
[[1],18],[[-2,3],5],[[1],20],[[3,-8,5],4],[[-2,-2,4],6],[[-1],8],[[1,-6,4],4],
[[-1],20],[[],0],[[],0],[[-7,28],0],[[27,0,0,0,0,-7,0,0,0,0,0,0,0,0,1],49],
[[3,-15,17],1],[[13,-12,0,-3,7],9],[[-6,15],2],[[10,0,4,-6,0,0,0,0,1],23],[[5,
-10,0,0,6],9],[[-3,-3,7],5],[[3,0,0,-3,0,0,0,0,1],25],[[-3,0,-1,0,0,1],16],
[[3,-10,8],3],[[1,-11,16],1],[[9,0,0,-5,0,1,0,0,1],23],[[2,3,-3,0,0,-1,2],19],
[[2,0,0,1],18],[[6,-13,9],3],[[1,-6,7],3],[[3,-11,8],3],[[-2,1,0,0,1],19],
[[-2,0,0,0,1],21],[[-3,1,-1,2],10],[[-4,6],4],[[4,-3,0,-1,2],11],[[-3,6],4],
[[5,-3,0,0,1],11],[[-1,-1,0,0,1],13],[[-2,1],6],[[1,-7,7],3],[[2,-2,0,0,1],
11],[[8,-4,0,-2,2],11],[[-2,0,6],5],[[1,-8,7],3],[[1,-2,0,0,1],13],[[-2,-2,2],
7],[[-1,1],6],[[1,-2,2],5],[[1],11],[[1,-3,2],5],[[-1,0,1],7],[[-1,-1,2],7],
[[-1,1],6],[[1,-4,2],5],[[-2,0,1],7],[[1,-3,2],5],[[-1,0,1],9],[[3,-5,3],5],
[[-1,1,0,1],10]],,[[[70],0],[[70],60],[[1,0,0,-16,0,0,36,0,0,-16,
0,0,1],0],[[15,-40,15],0],[[15,0,0,0,0,-40,0,0,0,0,15],10],[[6],30],[[1,-16,
36,-16,1],0],[[15,-20,15],0],[[15,0,0,0,-20,0,0,0,15],28],[[19],40],[[19],20],
[[6,0,0,0,-14,0,0,0,6],8],[[6,-14,6],20],[[1,-8,18,-8,1],0],[[1,-8,18,-8,1],
20],[[1,0,0,12,0,0,1],0],[[1,0,0,12,0,0,1],30],[[2,1,0,-8,0,1,2],5],[[1,-8,12,
-8,1],0],[[4,-2,3,-12,3,-2,4],4],[[2],15],[[3,-8,3],2],[[1,-4,6,-4,1],0],[[1,
0,-4,0,6,0,-4,0,1],12],[[5],24],[[5],12],[[1,0,4,-8,6,-12,6,-8,4,0,1],2],[[1,
-4,0,-4,1],0],[[1,-4,9,-4,1],20],[[1,-12,24,-12,1],0],[[-2,3,0,3,-2],5],[[3],
10],[[2,0,2,0,2],4],[[8,-10,8],22],[[1,0,1,-4,1,0,1],4],[[2,-4,2],2],[[8,-20,
8],2],[[-4],5],[[1,-2,1],10],[[2,-4,2],2],[[1,-2,1],2],[[],0],[[1,0,1],2],[[1,
0,1],3],[[1,0,0,0,1],15],[[-2],4],[[-2],8],[[1],14],[[1],7],[[4,-8,4],2],[[],
0],[[1],6],[[1,2,-4,2,1],2],[[3,-4,3],22],[[1,0,0,-3,0,0,1],10],[[1,-3,1],10],
[[2],3],[[1,-1,2,-1,1],10],[[5,-12,5],2],[[1,-4,1],3],[[-1],5],[[3,-6,3],2],
[[1,-2,1],12],[[-1],8],[[-1],4],[[-35,35],0],[[35,0,0,0,0,0,0,0,0,-35],27],
[[-5,30,-30,5],0],[[1,0,4,-12,0,-18,18,0,12,-4,0,-1],1],[[-5,10,-10,5],0],[[5,
0,0,0,10,-10,0,0,0,-5],11],[[3,-3,0,-9,9,0,3,-3],3],[[1,0,-6,6,0,-1],1],[[6,1,
0,0,-1,-6],14],[[3,0,0,-3],9],[[3,-12,12,-3],1],[[-5,20,-20,5],0],[[5,0,-10,0,
10,-10,0,10,0,-5],11],[[6,0,0,7,-7,0,0,-6],9],[[-1,0,0,1],9],[[4,-21,21,-4],
1],[[2,-3,3,-2],1],[[3,-15,15,-3],1],[[1,2,-1,1,-2,-1],9],[[1,0,0,2,-2,0,0,
-1],9],[[2,-1,1,-2],5],[[1,-3,3,-1],1],[[1,0,3,-3,0,-1],5],[[1,0,0,-1],1],
[[-1,0,0,1],6],[[1,-1],8],[[1,-1],3],[[2,-6,6,-2],1],[[],0],[[4,-1,6,-6,1,-4],
5],[[-3,3],3],[[2,-9,9,-2],1],[[1,0,2,-2,0,-1],6],[[2,-2],4],[[],0],[[-1,1],
3],[[1,-1],5],[[2,-2],3],[[],0],[[1,-1],4],[[-1,1],3],[[4,-4],3],[[],0],[[1,
-1],3],[[1,-1],5],[[6,-6],3],[[],0]],[[[50],0],[[50],84],[[4,0,27,-16,0,0,3],
6],[[5,-20,25],0],[[5,0,9,-20,15,0,0,0,0,0,0,0,1],18],[[10],42],[[1,-4,12,-20,
13],0],[[-15,20],1],[[-15,0,20],44],[[5],56],[[5],28],[[-6,0,2],16],[[-6,2],
29],[[5,-10,10],2],[[8,-4,1],30],[[4,-9,0,3],3],[[4,-9,0,3],45],[[2,-2,6,-1,0,
0,0,1],9],[[3,-9,8],2],[[-4,10,-5,0,0,1],9],[[2],21],[[2,-4,4],4],[[-5,5],3],
[[],0],[[],0],[[],0],[[-2,0,-9,13,-8,0,0,3],7],[[-2,-4,3],2],[[1,-4],30],[[-2,
7,-15,11],1],[[-2,0,4,-2,0,0,1],8],[[1],14],[[2,-2],8],[[-2,4,-2],31],[[4,-1],
10],[[1,1,-2,3],3],[[1,-2,7,-10,5],2],[[2,-2,0,0,1],6],[[1],16],[[-3,2],5],
[[-1,2],5],[[1],12],[[1,-1,-1,1],3],[[-1,0,1],6],[[-1,0,1],23],[[-1],6],[[-1],
12],[[-1],20],[[-1],10],[[2,-5,3],4],[[-1,0,1],4],[[],0],[[-2,3,-3,0,3],4],
[[1],32],[[1],17],[[1],15],[[-2],4],[[-2],16],[[-1,3,-7,4],3],[[-1,2,-3,0,1],
4],[[-1],7],[[1,-4,3],4],[[],0],[[],0],[[],0],[[-15,35],0],[[-15,0,0,35],42],
[[-2,9,-21,18],0],[[-2,2,-9,22,-12,0,0,3],6],[[-10,10],2],[[4,-10,5,0,0,0,0,0,
0,0,1],21],[[13,-6,0,0,1],9],[[-2,5,-6,0,3],3],[[-2,3,-3,2],21],[[3,0,0,0,0,0,
1],15],[[-1,4,-9,6],2],[[5,-15,15],1],[[5,0,-5,5],20],[[3,-3,0,2],16],[[3,-1],
14],[[1,-3,9,-14,8],1],[[1,0,-3,3],2],[[-2,5,-11,7],2],[[-4,3],15],[[1,-3],
16],[[-1,1,-2],8],[[-2,3],4],[[-1,3,-1],10],[[-2,-1,1],3],[[-2,0,0,-1,0,0,1],
9],[[1,1],11],[[-1,1],6],[[1,-5,4],3],[[],0],[[-4,6,-4,0,0,1],10],[[2,-4,0,1],
4],[[3,-6,6],3],[[1,-1,3,-1,0,0,0,1],10],[[-1,1,-2,0,1],5],[[1],7],[[1,-1],4],
[[1,-1],7],[[-2,1],6],[[-1],6],[[-1],7],[[-1],5],[[1,-3,2],5],[[-1,0,0,1],6],
[[1,0,-1,1],4],[[1,-1,0,0,1],7],[[2,-4,2],5],[[],0]],,[[[84],0],
[[84],90],[[2,0,36,-32,0,0,14],6],[[5,-32,47],0],[[9,-20,30,0,10,-12,0,0,0,0,
3],20],[[4],45],[[-4,18,-36,26],1],[[-21,42],1],[[15,0,0,0,6],46],[[-6],60],
[[-6],30],[[-3,0,6,0,-3,0,0,0,3],16],[[6,-3],31],[[5,-22,20],2],[[-4,8,-1],
32],[[2,-12,0,14],3],[[2,0,0,2],48],[[-1,6,0,-4,0,0,3],10],[[4,-19,19],2],
[[-5,18,-12,0,-2,5],9],[[],0],[[3,-10,7],4],[[-11,15],3],[[4],24],[[-1],36],
[[-1],18],[[2,-9,26,-16,0,-4,6],8],[[-1,-8,14],2],[[-1,4,-1],32],[[-1,11,-28,
23],1],[[10,-8,0,0,3],10],[[-2],15],[[1,-6,1,0,3],8],[[-5,4],34],[[7,-5,0,0,
3],10],[[1,-8,6],4],[[-4,12,-20,11],3],[[-2,-2,0,3],7],[[2,-1],16],[[2,-7,6],
4],[[-4,4],5],[[],0],[[-5,5],5],[[1,-4,0,3],5],[[-1,1],24],[[-3,0,3],6],[[],
0],[[],0],[[],0],[[-1,5,-12,8],3],[[-1,-2,3],4],[[-1],9],[[5,-6,-4,6],5],[[-1,
2],34],[[-1,0,0,-1],18],[[-1,-1],16],[[-1,-1,3],4],[[2,0,-1],17],[[-1,7,-14,
9],3],[[3,-5,-2,5],5],[[],0],[[3,-9,7],4],[[1],19],[[-1],12],[[-1],6],[[-21,
63],0],[[35,0,0,-21,27,0,0,0,0,0,0,0,0,0,0,0,0,0,1],45],[[-1,12,-36,35],0],
[[2,-9,35,-24,0,-4,10],7],[[-16,26],2],[[5,-10,15,0,5,-6,0,0,0,0,1],21],[[19,
-16,0,0,7],9],[[5,-9,-4,10],4],[[-3,1,3,0,0,0,0,0,0,0,1],23],[[5,-3,0,-1,0,0,
1],15],[[-1,8,-19,14],2],[[5,-27,31],1],[[-5,14,0,0,-1,0,0,0,0,1],22],[[-3,-2,
4,0,-3,0,0,-1,2],17],[[-1,-3,0,0,0,0,1],15],[[-4,15,-27,17],2],[[1,-10,10],3],
[[-1,10,-21,15],2],[[2,2,-2,0,0,0,0,1],16],[[-1,0,2,-1,0,0,0,0,1],17],[[3,-4,
1,-1,2],9],[[-7,8],4],[[-2,6,-4,0,-1,2],10],[[-1,-4,7],3],[[5,-4,0,0,1],11],
[[2,-1,0,0,0,1],12],[[-2,2],6],[[3,-12,11],3],[[2,-1,0,0,1],11],[[-5,13,-8,0,
-2,3],10],[[1,-7,0,7],4],[[4,-15,12],3],[[-1,3,0,-2,0,0,1],11],[[3,-3,-2,3],
6],[[-1,-1,1],5],[[-1,-2,2],5],[[-2,0,0,1],8],[[1,-4,3],5],[[-1,0,1],7],[[1,
-2,-1,2],6],[[-1,0,1],5],[[2,-6,4],5],[[1,-2,0,1],6],[[-4,3],6],[[-1,-1,0,1],
8],[[-1,4,-9,5],4],[[-2,0,0,1],10]],,[[[168],0],[[168],60],
[[1,0,0,0,27,0,-16,0,27,0,0,0,1],0],[[44,-80,44],0],[[9,0,5,0,30,-80,30,0,5,0,
9],10],[[24],30],[[14,-40,60,-40,14],0],[[24,-60,24],0],[[24,0,-60,0,24],30],
[[15],40],[[15],20],[[6,0,-6,0,6],10],[[6,-6,6],20],[[6,-16,26,-16,6],0],[[3,
-4,8,-4,3],20],[[1,0,-9,24,-9,0,1],0],[[1,0,-9,24,-9,0,1],30],[[2,-2,2,4,2,-2,
2],5],[[3,-12,18,-12,3],0],[[3,-1,-7,10,-7,-1,3],4],[[4],15],[[1,-2,3,-4,3,-2,
1],0],[[-4,6,-4],1],[[-4,0,6,0,-4],14],[[3],24],[[3],12],[[1,0,0,0,9,-9,-2,6,
-2,-9,9,0,0,0,1],0],[[1,0,2,0,1],0],[[1,0,5,0,1],20],[[8,-28,36,-28,8],0],[[1,
0,-5,4,-5,0,1],4],[[3],10],[[2,-6,2],5],[[1,0,1,-6,1,0,1],20],[[1,-4,4,-4,1],
5],[[1,0,1,0,1,0,1],0],[[2,-8,16,-18,16,-8,2],0],[[2,-2,2],4],[[1,-2,1],10],
[[1,0,1],2],[[],0],[[],0],[[-1,2,-1],2],[[],0],[[1,0,-2,0,1],15],[[],0],[[],
0],[[],0],[[],0],[[-2,3,-4,3,-2],1],[[-1,0,-1],2],[[-1],6],[[1,0,-3,5,-10,5,
-3,0,1],0],[[-4],23],[[1,0,0,-3,0,0,1],10],[[1,-3,1],10],[[2],3],[[1,-1,2,-1,
1],10],[[1,-4,7,-8,7,-4,1],0],[[-1,3,-4,3,-1],2],[[1],5],[[-2,2,-2,2,-2],1],
[[-2],13],[[],0],[[],0],[[-84,84],0],[[-84,0,0,84],30],[[-24,60,-60,24],0],
[[-1,0,0,0,-18,9,8,-8,-9,18,0,0,0,1],0],[[-4,20,-20,4],0],[[-4,0,0,0,0,20,-20,
0,0,0,0,4],10],[[-4,0,12,-12,0,4],4],[[-1,0,6,-15,15,-6,0,1],0],[[-4,0,0,4],
15],[[],0],[[-2,8,-14,14,-8,2],0],[[-14,40,-40,14],0],[[26,-26],15],[[-6,0,3,
-3,0,6],10],[[-3,3],10],[[-5,18,-31,31,-18,5],0],[[-1,0,-1,1,0,1],0],[[-3,13,
-19,19,-13,3],0],[[-2,1,-1,2],10],[[-1,0,2,-2,0,1],10],[[-2,3,-3,2],5],[[-1,
1],2],[[-1,3,-3,3,-3,1],5],[[2,-2],2],[[2,0,0,-2],6],[[],0],[[],0],[[3,-4,4,
-3],1],[[1,0,0,-1],6],[[-2,1,2,-5,5,-2,-1,2],4],[[1,-5,5,-1],2],[[-2,5,-9,9,
-5,2],0],[[-1,1,-1,-1,1,1,-1,1],5],[[1,-1,2,-2,1,-1],2],[[],0],[[-1,1],3],
[[-1,1],5],[[],0],[[],0],[[],0],[[],0],[[1,-1,1,-1,1,-1],1],[[1,0,0,-1],3],
[[-1,1],3],[[-1,0,0,1],4],[[1,-2,2,-2,2,-1],1],[[1,-1],6]],[[[175],0],[[175],
72],[[-40,0,54,-32,0,0,1],6],[[30,-80,65],0],[[30,-60,50,0,0,-20,15],16],
[[15],36],[[7,-28,54,-60,26],0],[[10,-60,45],0],[[10,0,-60,0,45],36],[[-5],
48],[[-5],24],[[1,0,12],12],[[1,12],24],[[1,-8,23,-28,16],0],[[1,4,-10,8,1],
24],[[16,-18,0,1],3],[[16,-18,0,1],39],[[2,-4,-2,4,-1],8],[[-5,16,-23,11],1],
[[-6,14,-11,-4,12,-6],6],[[-1],18],[[1,-2,6,-6,4],2],[[5,-10,5],2],[[],0],[[],
0],[[],0],[[-6,14,-6,-18,26,-16,0,0,1],6],[[2,-8,1],2],[[-10,4,1],26],[[3,-15,
36,-41,20],0],[[6,-5,0,4,-2],7],[[3],12],[[-3,4],6],[[-3,8,-7,2,1],26],[[-1,4,
-6,0,1],6],[[-1,2,-4,1],3],[[1,-2,8,-16,22,-20,7],0],[[2,-2],6],[[1,-2,1],12],
[[2,-2,2],4],[[-1,1],5],[[],0],[[-1],5],[[-1],6],[[-1],22],[[1],4],[[1],8],
[[1],16],[[1],8],[[1,-3,6,-7,3],2],[[],0],[[],0],[[2,-6,8,-6,0,1],3],[[2,-3],
27],[[-2,0,0,1],15],[[-2,1],13],[[-1],3],[[-1,0,-1,1],13],[[-1,2,-7,11,-11,5],
1],[[-2,4,-3],4],[[-1],6],[[-2,4,-5,3],3],[[],0],[[],0],[[],0],[[-70,105],0],
[[-70,0,0,105],36],[[-14,48,-72,41],0],[[20,-20,-18,44,-24,0,0,1],6],[[10,-30,
15],1],[[10,-20,10,0,0,-10,5],17],[[9,-22,0,15,-7],6],[[-8,14,-12,0,1],3],
[[-2,0,0,-3],18],[[3],15],[[3,-8,18,-18,8],1],[[-5,30,-50,30],0],[[-5,16,-21,
15,0,0,-1,1],16],[[-1,0,-6,6],12],[[-7,6],12],[[-2,8,-23,35,-34,13],0],[[-1,3,
-6,1],2],[[-1,4,-13,24,-23,11],0],[[-2,6,-5,3],12],[[-1,3,0,1],14],[[3,-2,2],
6],[[1,-3,2],3],[[1,-3,4,-3,0,1],6],[[-1],4],[[-1],12],[[-1],11],[[1],7],[[-2,
6,-8,4],2],[[],0],[[3,-6,8,-3,-4,8,-5],6],[[5,-4],4],[[1,-5,11,-13,7],1],[[1,
-1,0,2,-1],9],[[-2,2,-2],5],[[],0],[[1],3],[[1],6],[[-1,1],6],[[],0],[[-1],4],
[[-1],4],[[-1,2,-3,2],4],[[],0],[[-1],6],[[-1],8],[[1,-2,4,-5,2],3],[[],0]],
,[[[210],0],[[210],84],[[-20,0,63,-80,0,0,23],6],[[17,-92,101],0],
[[45,0,-33,-20,45,0,10,-24,0,0,0,0,3],18],[[10],42],[[1,-12,60,-92,45],0],[[6,
-57,90],0],[[64,-30,0,0,0,6,0,0,0,-1],43],[[-15],56],[[-15],28],[[-8,6,0,6,0,
-12,0,0,0,2],15],[[-3,6,-9],28],[[-2,23,-52,34],1],[[4,-4,8,-5],29],[[4,-21,0,
23],3],[[12,-9,0,3],45],[[-2,0,6,-1,-8,0,0,3],9],[[-1,17,-46,32],1],[[3,-5,-8,
33,-22,0,-4,5],7],[[-2],21],[[-2,14,-18,8],3],[[5,-25,25],2],[[5],20],[[],0],
[[],0],[[8,-4,-22,51,-28,2,-7,7],7],[[4,-20,23],2],[[1,4,-4],30],[[-6,37,-71,
39],1],[[-3,0,13,-14,0,0,3],8],[[1],14],[[-2,-6,4,0,2],8],[[-2,-2,4,-2],31],
[[-2,0,6,-11,0,0,2],8],[[-2,10,-14,7],3],[[1,-16,41,-40,13],2],[[-2,-2,0,3],
7],[[1],16],[[-1,8,-14,6],3],[[3,-7,4],4],[[],0],[[-1,6,-10,5],3],[[2,-5,0,3],
5],[[1,0,-1],23],[[1,-3,0,2],5],[[],0],[[],0],[[],0],[[-4,19,-23,9],3],[[2,-4,
3],4],[[],0],[[10,-7,-7,7],5],[[2,2,-1],32],[[-3],17],[[-3],15],[[2,-4,2],4],
[[-1,2,-1],15],[[-7,24,-28,10],3],[[5,-7,-4,5],5],[[1],7],[[-2,12,-18,7],3],
[[-1],18],[[],0],[[],0],[[-63,147],0],[[120,0,0,-56,0,0,0,27,0,0,0,0,-7],42],
[[-4,39,-99,68],0],[[8,-12,-18,73,-52,0,-9,14],6],[[6,-40,50],1],[[20,0,-9,
-10,15,0,5,-6,0,0,0,0,1],19],[[-8,0,27,-36,0,0,9],7],[[10,-15,-9,14],4],[[3,0,
0,-3],25],[[7,-3,0,-1,0,0,1],15],[[-5,28,-43,20],2],[[-1,21,-71,60],0],[[16,
-5,-10,5,9,-1,-1,-5,0,1],19],[[-11,3,-2,4,6,-6,0,0,-1,1],16],[[-6,-2,0,0,2],
14],[[1,-14,51,-62,25],1],[[-1,10,-22,14],2],[[-8,33,-49,21],2],[[-1,3,-3,-1,
0,-2,1],14],[[-3,4,-1,0,0,-2],16],[[1,1,-6,2,-1,1],8],[[4,-14,11],3],[[1,-1,
-2,9,-6,0,-1,1],8],[[3,-10,9],3],[[5,-4,0,0,1],11],[[-1,-1],13],[[2,-3,1],5],
[[-1,12,-27,15],2],[[-1,0,2,-2],9],[[3,-2,-11,22,-11,1,-3,2],8],[[2,-10,0,9],
4],[[-2,18,-32,17],2],[[-1,0,3,0,-2,0,0,1],10],[[5,-3,-3,2],6],[[1,-1,1],5],
[[-1,3,-3,1],4],[[],0],[[-1,5,-6,2],4],[[1,-1],6],[[2,-2,-1,1],6],[[1,-1],5],
[[-2,9,-9,3],4],[[2,-2,0,1],6],[[-2,5,-6,2],4],[[-1,-1,0,1],8],[[-6,15,-14,4],
4],[[-1,-1,1],9]],,
[[[420],0],[[420],60],[[-16,54,0,-104,0,54,-16],3],[[110,-200,110],0],[[50,
-60,60,-80,60,-60,50],12],[[36],30],[[34,-104,144,-104,34],0],[[60,-150,60],
0],[[60,0,-150,0,60],30],[[24],40],[[24],20],[[6,0,-24,0,6],10],[[6,-24,6],
20],[[14,-42,62,-42,14],0],[[2,-12,26,-12,2],20],[[-18,48,-18],2],[[-18,48,
-18],32],[[-2,-4,8,-4,-2],6],[[7,-31,44,-31,7],0],[[-1,5,-1,-24,38,-24,-1,5,
-1],3],[[],0],[[2,-4,8,-8,8,-4,2],0],[[1,-9,16,-9,1],0],[[1,0,-4,0,6,0,-4,0,
1],12],[[5],24],[[5],12],[[-8,22,-18,-14,38,-14,-18,22,-8],3],[[-4,10,-4],1],
[[-4,16,-4],21],[[21,-67,94,-67,21],0],[[1,0,-8,16,-8,0,1],4],[[],0],[[2,-8,
2],5],[[-2,8,-16,8,-2],21],[[-4,10,-4],6],[[-2,2,-4,2,-2],1],[[6,-20,38,-46,
38,-20,6],0],[[2,-2,2],4],[[],0],[[-1,1,-2,1,-1],1],[[],0],[[],0],[[],0],[[],
0],[[],0],[[],0],[[],0],[[],0],[[],0],[[1,-4,8,-10,8,-4,1],0],[[],0],[[1],6],
[[-6,12,-18,12,-6],2],[[-6],23],[[],0],[[],0],[[],0],[[],0],[[3,-9,17,-20,17,
-9,3],0],[[-1,5,-6,5,-1],2],[[],0],[[1,-3,5,-6,5,-3,1],0],[[1,-2,1],12],[[-1],
8],[[-1],4],[[-210,210],0],[[-210,0,0,210],30],[[-60,150,-150,60],0],[[12,-40,
18,52,-52,-18,40,-12],3],[[-10,50,-50,10],0],[[-10,20,-10,20,-20,10,-20,10],
12],[[1,-6,0,43,-43,0,6,-1],3],[[12,-30,30,-12],2],[[-6,6],16],[[],0],[[-5,20,
-35,35,-20,5],0],[[-35,100,-100,35],0],[[-5,0,15,-5,5,-15,0,5],12],[[-6,0,12,
-12,0,6],10],[[6,-6],10],[[-13,45,-77,77,-45,13],0],[[3,-6,6,-3],1],[[-9,29,
-49,49,-29,9],0],[[1,-8,8,-1],10],[[6,-6],12],[[-2,4,-4,2],5],[[1,-2,2,-1],1],
[[3,-6,6,-3],6],[[],0],[[],0],[[],0],[[],0],[[-1,6,-11,11,-6,1],0],[[],0],[[1,
-4,1,8,-19,19,-8,-1,4,-1],3],[[1,-8,8,-1],2],[[-4,13,-22,22,-13,4],0],[[1,-2,
2,-1],7],[[1,-2,3,-3,2,-1],2],[[],0],[[],0],[[],0],[[],0],[[],0],[[],0],[[],
0],[[-1,1,-2,2,-2,2,-1,1],0],[[],0],[[],0],[[],0],[[-1,2,-4,5,-5,4,-2,1],0],
[[],0]],[[[300],0],[[300],78],[[-18,0,90,-80,0,0,20],6],[[35,-140,125],0],
[[30,0,-35,0,-24,0,45,0,15,-12,0,0,0,0,1],16],[[20],39],[[2,-32,102,-112,52],
0],[[15,-90,105],0],[[84,-64,15,0,0,0,-6,0,0,0,1],40],[[30],52],[[30],26],
[[12,-16,6,0,6,0,-6,0,0,0,1],14],[[6,-18,15],26],[[1,-8,38,-68,31],0],[[1,-8,
14,-20,7],26],[[18,-30,0,20],3],[[22,-18,0,4],42],[[2,-2,-1,4,0,-4,0,0,1],8],
[[-5,30,-55,30],1],[[2,-12,-12,36,-16,0,-2,4],7],[[],0],[[1,-6,16,-16,5],2],
[[10,-30,20],2],[[],0],[[],0],[[],0],[[6,4,-16,-35,64,-16,1,-7,5],6],[[6,-20,
20],2],[[9,-8,5],28],[[1,-17,64,-87,41],0],[[-10,0,17,-6,0,0,1],8],[[2],13],
[[4,2,-6,2,0,1],7],[[3,-4,10,-8,2],28],[[1,-3,1,7,-7,0,0,1],7],[[-4,10,-11,5],
3],[[9,-34,51,-38,14],2],[[4,0,-3,0,1],6],[[1,0,1],13],[[-3,9,-10,4],3],[[3,
-5,1],4],[[-1],12],[[-1,5,-6,4],3],[[3,-6,0,1],5],[[-1,-1],21],[[2,-3,0,1],5],
[[],0],[[],0],[[],0],[[1,-11,21,-19,8],2],[[1,-2,1],4],[[],0],[[2,-4,17,-11,
-7,5],3],[[3,-2,1],30],[[1,0,0,1],16],[[1,1],14],[[-2,1],5],[[-2,0,1],15],[[3,
-16,29,-25,9],2],[[-3,9,-8,-2,4],4],[[],0],[[1,-5,14,-15,5],2],[[],0],[[],0],
[[],0],[[-105,195],0],[[168,0,0,-105,0,0,0,0,0,0,27],39],[[-10,75,-135,80],0],
[[-2,-20,-27,99,-44,0,-8,12],6],[[15,-55,50],1],[[10,10,-10,0,-14,0,10,0,5,
-1],17],[[3,-11,0,34,-30,0,0,6],6],[[-6,21,-21,-8,12],3],[[-2,-3,0,0,3],21],
[[6,0,0,3,-3],12],[[1,-15,41,-44,19],1],[[-5,40,-100,65],0],[[5,0,-11,0,-5,0,
10,1],17],[[20,-14,0,-2,4,3,-3,0,0,0,1],15],[[6,3],13],[[5,-36,75,-67,27],1],
[[-2,13,-19,12],2],[[3,-20,50,-53,20],1],[[1,-5,2,2],13],[[4,-4,0,1],15],[[2,
2,-5,1,0,1],8],[[6,-14,6],3],[[-4,-2,7,-4,0,0,1],9],[[2,-8,6],3],[[-5,0,5],9],
[[1,0,-1],11],[[1,-1],5],[[-4,18,-26,12],2],[[-2,0,2],9],[[3,5,-9,-14,22,-5,0,
-2,2],7],[[8,-12,0,6],4],[[1,-7,26,-35,13],1],[[1,-4,-2,2,1],9],[[1,-2,7,-4,
-2,2],4],[[],0],[[1,-1,1],5],[[1],7],[[-2,3,-3,1],4],[[-1],7],[[-1,2,-2,0,1],
5],[[],0],[[1,-4,7,-6,2],3],[[2,-2],6],[[-2,3,-3,2],4],[[1,0,-1],7],[[3,-10,
13,-10,4],3],[[1,0,-1],8]],,[[[350],0],[[350],72],
[[-16,9,0,32,0,54,-96,0,0,15],3],[[50,-180,120],0],[[45,-40,45,0,-80,0,12,0,
15,0,5,-12],14],[[-10],36],[[3,-48,138,-128,33],0],[[35,-105,105],0],[[70,0,0,
-64,15,0,20,0,-6],36],[[35],48],[[35],24],[[-5,0,0,-16,24,0,2,0,-6],12],[[8,
-24,15],24],[[1,-18,63,-68,21],0],[[1,-12,24,-20,6],24],[[-3,32,-18,0,15],2],
[[9,0,18,0,-1],38],[[-6,0,4,8,0,-4],8],[[1,-13,47,-58,21],0],[[1,-2,3,-8,5,
-14,27,-13,0,-2,1],4],[[-2],18],[[3,-16,24,-10,1],2],[[-5,20,-30,15],1],[[],
0],[[],0],[[],0],[[4,-8,15,-14,7,-34,41,-16,4,-5,1],4],[[-4,8,-24,15],1],[[-4,
8,-12,3],25],[[2,-29,93,-94,27],0],[[-2,0,0,2,-2,7,-6],5],[[-1],12],[[-1,0,8,
-2,2],6],[[7,-8,13,-6,1],26],[[-1,-2,3,0,6,-5],6],[[1,-8,16,-9,1],2],[[16,-56,
66,-30,3],2],[[-4,4,0,-1],5],[[-1],12],[[1,-8,14,-7,1],2],[[-3,6,-3],3],[[],
0],[[-2,7,-6,1],3],[[-2,4,-2],4],[[1,0,-1],20],[[-2,2,-1],4],[[-1],8],[[-1],
16],[[-1],8],[[4,-20,29,-15,2],2],[[2,-2],4],[[],0],[[2,-16,16,1,-5,1],3],
[[-2,3,-2],27],[[-1],18],[[-1],14],[[1,0,-2],3],[[-1],16],[[7,-30,40,-18,2],
2],[[1,-8,11,-2,-2,1],3],[[1],6],[[2,-14,21,-10,1],2],[[],0],[[],0],[[],0],
[[-140,210],0],[[189,-35,0,0,0,0,0,-105,0,0,21],35],[[-15,105,-165,65],0],[[4,
-12,9,-20,12,-27,75,-48,0,-9,6],3],[[-5,30,-60,45],0],[[15,-10,20,10,-20,-1,
-5,0,0,0,1],15],[[-3,0,-4,12,0,24,-30,0,0,3],4],[[-15,29,-9,-9,6],3],[[5,-3,0,
-2,-3,3,2],18],[[-3,-3,0,0,4],11],[[4,-27,58,-42,9],1],[[-10,65,-115,55],0],
[[9,-10,0,10,-16,-5,10,0,-5,1,1],15],[[7,2,0,8,-20,12,-2,0,3,-3],12],[[1,0,3,
3],12],[[9,-57,101,-66,12],1],[[1,-5,18,-21,6],1],[[5,-37,72,-48,9],1],[[1,-2,
0,1,0,1],12],[[-2,0,0,-3,3,1],13],[[-1,-2,-4,6,-1,1],6],[[-4,12,-12,3],2],[[1,
-2,1,-4,5,-2],7],[[-1,3,-9,3],2],[[-1,0,0,-2,-1],6],[[-1,-1,1,1],9],[[-2,2],
4],[[1,-11,28,-24,6],1],[[-1,0,1],7],[[1,-1,6,-2,7,-15,12,-3,1,-1],5],[[-4,12,
-6,0,3],3],[[2,-18,41,-30,6],1],[[-1,0,0,2],9],[[2,-8,5,1,-1],4],[[1],5],[[-1,
0,1,-1],3],[[-1,1,-1],6],[[1,-5,5,-1],3],[[],0],[[1,-2,2],4],[[1],4],[[3,-11,
10,-2],3],[[-1,1],5],[[-4,5,-2],4],[[-2,1],6],[[7,-19,17,-5],3],[[-1,0,1],7]],
,[[[525],0],[[525],72],[[1,0,0,0,36,0,-32,0,135,-112,0,
0,17],0],[[80,-260,185],0],[[10,0,0,-80,90,0,30,0,-18,-40,15,0,10,-12],12],
[[5],36],[[9,-80,186,-192,58],0],[[45,-165,150],0],[[24,0,0,0,24,-64,45,0,0,0,
0,0,0,0,1],34],[[30],48],[[30],24],[[6,0,0,0,6,-16,9,0,6,0,0,0,0,0,1],10],[[9,
-12,15],24],[[2,-26,86,-96,37],0],[[2,-8,14,-12,7],24],[[1,0,-12,32,-45,0,17],
0],[[1,0,0,0,-9,0,1],36],[[-2,0,2,-4,-4,12,1,-4],6],[[1,-18,63,-81,32],0],
[[-3,0,12,-5,-24,36,-17,0,-3,1],5],[[-3],18],[[4,-18,29,-18,4],2],[[-5,25,-40,
20],1],[[],0],[[],0],[[],0],[[1,0,0,-9,16,10,8,-53,63,-32,5,-5,2],2],[[1,0,16,
-28,17],0],[[1,0,4,-4,5],24],[[5,-44,129,-135,47],0],[[2,4,-3,0,9,-10],6],
[[2],12],[[2,0,2,1,-6,0,0,1],5],[[2,-4,4,-4,2],26],[[1,-2,0,-2,1,7,-3,0,0,1],
5],[[2,-7,19,-13,2],2],[[-4,25,-68,89,-52,9],1],[[1,-2,6,-4,-2],4],[[-2,1],
13],[[1,-8,15,-11,2],2],[[-3,6,-4,1],3],[[],0],[[-2,7,-7,1],3],[[-2,4,-3],4],
[[-1,0,1,0,-1],18],[[2,-3,0,1],5],[[],0],[[],0],[[],0],[[6,-21,35,-24,4],2],
[[2,-2],4],[[],0],[[1,5,-22,25,-4,-5,2],2],[[1,0,1],28],[[1,0,0,0,0,0,1],12],
[[1,0,1],12],[[1,0,1],4],[[1,0,0,0,1],12],[[-1,10,-35,51,-31,6],1],[[2,-8,15,
-7,-3,1],3],[[],0],[[2,-16,25,-15,4],2],[[],0],[[],0],[[],0],[[-210,315],0],
[[105,0,0,0,0,-189,210,0,0,0,0,0,0,0,0,-21],33],[[-29,153,-237,106],0],[[1,0,
0,-9,27,12,-20,-63,116,-68,0,-10,7],1],[[-5,40,-90,60],0],[[4,0,0,-20,20,-4,
11,4,-5,-10,5,-1,1],13],[[-2,3,8,-12,-3,45,-30,0,0,4],4],[[1,3,-21,41,-24,-10,
7],1],[[-3,0,0,3,-2,0,0,-1],17],[[-3,-3,7],13],[[7,-36,73,-63,16],1],[[-15,95,
-165,85],0],[[5,-25,20,0,5,0,1,-5,0,0,0,-1],15],[[6,0,0,-6,8,-8,9,-4,2,0,0,0,
0,-1],11],[[6,0,3,0,0,-3],11],[[-1,20,-78,134,-103,24],0],[[1,-6,21,-27,7],1],
[[-1,9,-50,96,-71,20],0],[[3,-2,2,-2,2,0,2,-2],11],[[1,0,1,0,0,-2,1,0,2,-1],
11],[[2,-2,0,5,-2,0,-1],6],[[-4,13,-15,5],2],[[1,-2,2,-1,-4,5,-1,0,-1],6],[[6,
-7,4],3],[[1,2,0,0,1,-1],7],[[-1,-1,0,1],9],[[-2,2,-1],4],[[1,-13,34,-32,10],
1],[[1,0,-1],10],[[-3,-3,8,6,-20,17,-8,2,-1],6],[[1,-4,12,-15,0,4],2],[[3,-23,
52,-43,13],1],[[-1,0,1,0,0,3,-1],7],[[3,-9,8,0,-1],4],[[1],5],[[1,-1],5],[[1,
-1],7],[[1,-4,6,-3],3],[[],0],[[-1,3,-1,-1],5],[[],0],[[3,-11,13,-6,1],3],
[[-1,1],5],[[-3,6,-3],4],[[-1,2,-1],6],[[-1,7,-19,23,-11,1],2],[[1,0,-1],8]],
,[[[567],0],[[567],80],[[9,0,
-24,0,153,-192,0,0,45],4],[[57,-264,246],0],[[45,0,20,0,-36,-40,75,0,20,-48,0,
0,0,0,3],16],[[-9],40],[[3,-48,180,-240,96],0],[[27,-162,216],0],[[81],40],
[[],0],[[],0],[[-24,27,0,12,0,-18,0,0,0,3],15],[[],0],[[-12,75,-132,69],1],
[[],0],[[-3,24,-51,0,45],2],[[9,0,9,0,-3],42],[[1,-4,0,16,-1,-16,0,0,3],8],
[[-7,56,-115,65],1],[[1,4,-6,-26,71,-44,0,-8,7],6],[[3],20],[[-12,38,-38,11],
3],[[-1,20,-61,49],1],[[4,0,0,0,4,0,-1],18],[[-3],32],[[-3],16],[[9,6,-3,-57,
114,-60,6,-15,9],6],[[12,-48,45],2],[[],0],[[1,-24,118,-180,82],0],[[1,0,-4,0,
25,-28,0,0,3],6],[[],0],[[3,-12,6,0,3],8],[[],0],[[15,-18,0,0,3],10],[[-6,27,
-30,9],3],[[9,-56,113,-88,22],2],[[5,-4,-4,0,3],6],[[],0],[[-5,23,-27,9],3],
[[-1,9,-13,5],3],[[],0],[[-2,14,-20,7],3],[[-1,6,-9,0,3],4],[[-2,0,1],22],[[3,
-6,0,3],5],[[],0],[[],0],[[],0],[[1,-17,50,-49,14],2],[[4,-8,3],4],[[1],8],
[[-12,27,-12,-15,9],4],[[-3],30],[[],0],[[],0],[[3,-6,3],4],[[],0],[[2,-27,67,
-59,16],2],[[-4,17,-13,-8,7],4],[[],0],[[-10,35,-35,11],3],[[2,-1],17],[[],0],
[[],0],[[-189,378],0],[[210,0,0,15,0,0,-35,0,0,-21,27,0,0,0,0,-7],39],[[-15,
126,-270,156],0],[[9,6,-18,-54,171,-120,0,-21,24],5],[[-1,26,-106,110],0],
[[20,0,11,4,-14,-10,25,-1,6,-12],17],[[1,2,-8,-1,64,-76,0,0,15],5],[[-9,36,
-33,-21,24],3],[[-4,-3,3,1,3,0,0,-3],21],[[-3,-3,11,-6,0,-2],13],[[1,-22,82,
-101,37],1],[[-6,72,-192,135],0],[[10,0,5,-5,0,0,4,0,0,-6,0,1],17],[[8,-25,18,
-6,6,9,-9,0,0,-2,1],15],[[3,-3,1,-3,0,2],13],[[6,-54,147,-150,48],1],[[-3,27,
-51,24],2],[[2,-31,102,-113,40],1],[[-2,6,-3,2,-2,-2,1],14],[[-7,8,0,2,-1,-2],
16],[[-1,8,-9,3,-2,1],8],[[-1,14,-31,18],2],[[-7,17,-9,0,-2,1],10],[[7,-21,
15],3],[[1,0,-2,0,9,-7],7],[[1,2,-1,-1],11],[[-1,5,-4,1],4],[[-6,38,-60,27],
2],[[2,-3],11],[[1,4,1,-28,44,-19,3,-5,2],7],[[-1,11,-22,0,15],3],[[-12,55,
-74,30],2],[[-2,0,5,0,-4],10],[[-6,12,-3,-5,2],5],[[2,-2],5],[[-1,5,-5,1],4],
[[2,-2],7],[[-4,12,-10,2],4],[[1,-1],6],[[-1,5,-3,-2,1],5],[[1,-1],5],[[-10,
22,-16,3],4],[[-1,3,-3],5],[[-4,13,-10,2],4],[[3,-1,-1],7],[[2,-20,38,-26,5],
3],[[-2,1],10]],,[[[1134],0],[[1134],60],[[6,0,0,-96,135,0,-108,0,135,
-96,0,0,6],0],[[279,-576,279],0],[[-24,0,-35,-60,210,-200,210,-60,-35,0,-24],
10],[[30],30],[[63,-288,432,-288,63],0],[[189,-378,189],0],[[15,-64,84,0,-70,
0,84,-64,15],28],[[81],40],[[81],20],[[6,-16,12,0,-4,0,12,-16,6],8],[[27,-54,
27],20],[[27,-126,198,-126,27],0],[[9,-36,54,-36,9],20],[[6,0,-45,108,-45,0,
6],0],[[2,0,-9,44,-9,0,2],30],[[4,-1,-6,4,-6,-1,4],5],[[21,-93,150,-93,21],0],
[[-7,16,-16,-16,52,-16,-16,16,-7],3],[[2],15],[[1,-10,30,-44,30,-10,1],0],[[6,
-39,60,-39,6],0],[[1,0,-4,0,0,0,-4,0,1],12],[[4],24],[[4],12],[[1,-2,1,-16,41,
-61,18,36,18,-61,41,-16,1,-2,1],0],[[6,-24,36,-24,6],0],[[3,-12,27,-12,3],20],
[[42,-189,294,-189,42],0],[[2,-2,-10,20,-10,-2,2],4],[[-3],10],[[2,4,-12,4,2],
4],[[1,-6,18,-26,18,-6,1],20],[[1,1,-7,10,-7,1,1],4],[[1,-6,15,-20,15,-6,1],
0],[[4,-44,122,-164,122,-44,4],0],[[4,-8,4],4],[[-1,2,-1],10],[[-3,12,-18,12,
-3],1],[[3,-6,3],2],[[],0],[[-2,4,-6,4,-2],1],[[3,-8,3],3],[[-2],17],[[2,-4,
2],3],[[],0],[[],0],[[],0],[[1,-12,37,-50,37,-12,1],0],[[1,0,1],2],[[],0],[[1,
-2,-2,33,-60,33,-2,-2,1],0],[[3,-6,3],22],[[-1,0,0,-1,0,0,-1],10],[[-1,-1,-1],
10],[[],0],[[-1,0,2,0,-1],10],[[2,-21,61,-84,61,-21,2],0],[[-2,15,-26,15,-2],
2],[[-1],5],[[1,-7,24,-36,24,-7,1],0],[[1,-2,1],12],[[1],8],[[1],4],[[-567,
567],0],[[-189,378,0,0,0,0,-378,189],28],[[-135,432,-432,135],0],[[-3,3,0,48,
-102,81,54,-54,-81,102,-48,0,-3,3],0],[[-45,144,-144,45],0],[[5,-4,0,0,-35,35,
-35,35,0,0,4,-5],10],[[12,-27,0,42,-42,0,27,-12],3],[[-3,3,18,-81,81,-18,-3,
3],0],[[-3,0,0,0,0,3],14],[[3,0,0,0,0,-3],8],[[-9,57,-123,123,-57,9],0],[[-90,
288,-288,90],0],[[-9,0,9,-9,0,9],13],[[-6,8,-8,12,2,-2,-12,8,-8,6],8],[[],0],
[[-18,117,-243,243,-117,18],0],[[-3,15,-30,30,-15,3],0],[[-12,75,-165,165,-75,
12],0],[[],0],[[],0],[[-2,0,10,-10,0,2],4],[[6,-18,18,-6],1],[[-1,0,2,-11,11,
-2,0,1],4],[[3,-6,6,-3],1],[[1,0,-8,8,0,-1],5],[[1,0,0,-1],7],[[1,-1],3],[[-3,
21,-51,51,-21,3],0],[[-3,3],7],[[3,-6,10,-5,-26,26,5,-10,6,-3],3],[[6,-24,24,
-6],2],[[-6,36,-84,84,-36,6],0],[[-2,2],8],[[-5,15,-15,5],3],[[],0],[[],0],
[[],0],[[-2,4,-4,2],2],[[],0],[[-1,3,-3,1],3],[[],0],[[2,-8,15,-15,8,-2],1],
[[1,-1],4],[[1,-2,3,-3,2,-1],1],[[2,-2],5],[[4,-17,29,-29,17,-4],1],[[2,-2],
6]],[[[700],0],[[700],66],[[2,0,0,0,72,0,-66,0,162,-80,0,0,2],0],[[145,-340,
215],0],[[9,0,10,0,60,-128,120,-60,25,0,9,-40,15],10],[[20],33],[[36,-136,246,
-216,66],0],[[75,-240,145],0],[[-24,0,0,0,-60,64],32],[[-20],44],[[-20],22],
[[12,0,-9,0,12,-8,-9],10],[[-6,12,-8],22],[[8,-54,109,-94,38],0],[[-1,12,-8,8,
-4],22],[[2,0,-24,74,-54,0,2],0],[[2,0,0,14,-18,0,2],33],[[2,-3,0,8,-2,-6,10,
-1],5],[[5,-35,80,-75,25],0],[[4,-4,-15,34,-18,-20,27,-8],4],[[],0],[[-2,8,
-18,23,-16,5],1],[[-10,30,-30,10],1],[[],0],[[],0],[[],0],[[-1,0,0,9,-27,5,26,
8,-58,60,-28,0,0,2],1],[[2,0,12,-20,2],0],[[-1,0,-6,4,-1],22],[[18,-86,162,
-146,48],0],[[-2,-6,14,-12,-2,8,-4],5],[[-4],11],[[4,-9,4,3],5],[[2,-4,4,-1,2,
-1],23],[[2,-7,8,-7,0,3],5],[[-1,-1,-5,11,-7,2],1],[[3,-18,46,-82,92,-52,10],
0],[[1,-8,10,-4],4],[[-1,2,-2],11],[[2,-5,8,-7,1],2],[[-1,2,-2,1],3],[[],0],
[[-2,4,1,-1],2],[[1,-2,0,-1],3],[[-1,-1],18],[[1],5],[[1],10],[[1],16],[[1],
8],[[-3,9,-20,28,-17,3],1],[[-1,2,-1],2],[[],0],[[-1,-3,21,-35,28,-12,0,2],1],
[[],0],[[-1,0,0,2,0,0,-1],11],[[-1,2,-1],11],[[3,-3],3],[[-1,1,0,1,-1],11],
[[1,-6,20,-38,46,-29,6],0],[[-1,7,-15,15,-6],2],[[],0],[[-1,6,-13,18,-13,3],
1],[[],0],[[],0],[[],0],[[-315,385],0],[[-84,0,0,105,0,-216,280,0,0,0,0,0,
-15],30],[[-70,225,-285,120],0],[[-1,1,0,0,-36,36,30,-36,-72,118,-52,0,0,2],
0],[[-10,65,-105,40],0],[[10,-34,25,-15,5,0,4,-10,5],15],[[-7,3,31,-39,-3,41,
-12],4],[[-1,1,12,-50,60,-30,0,2],0],[[-4,0,-3,0,0,0,-2,3],15],[[-1,0,0,3,-3,
0,3],9],[[-3,19,-52,76,-56,14],0],[[-35,150,-190,85],0],[[30,-41,26,-5,0,5,1,
-6],15],[[-6,6,6,-3,-6,6,-2,-3],10],[[-3,6,-8,0,3],10],[[-10,50,-113,155,-106,
26],0],[[-1,1,-3,16,-13,2],0],[[-5,29,-75,100,-74,20],0],[[-2,3,-5,6,-4,-4,1],
10],[[-1,1,2,1,-1,2,0,-2],10],[[-2,8,-5,0,1],5],[[-5,8,-7,3],2],[[-1,5,-8,7,
-3,-2,1],5],[[3,-2,-1],2],[[-3,2,2,-1,1,-1],7],[[-1,0,1],9],[[1,-1],5],[[5,
-17,29,-23,6],1],[[1,-1],6],[[-1,3,4,-16,17,2,-15,13,-5],4],[[2,-11,21,-10],
2],[[-1,11,-34,50,-37,13],0],[[1,0,-1,3,-2,-1,3,-1],6],[[-3,7,-9,7,-3],3],
[[-1],3],[[-2,3,-1],3],[[-1,0,1],5],[[-1,3,-2],4],[[1,-1],5],[[1],6],[[1],4],
[[-1,3,-7,10,-6,1],2],[[1,-1],5],[[1,-3,1,2,-1],2],[[1,-2,2,-1],5],[[1,-3,7,
-15,18,-9,1],1],[[1,-1],6]],,[[[700],0],[[700],78],[[-82,0,234,-192,0,0,36],6],[[85,
-320,295],0],[[30,-60,105,0,-54,-60,105,0,15,-24,0,0,0,0,3],16],[[-20],39],
[[10,-76,222,-268,124],0],[[30,-215,240],0],[[24,0,30,0,0,0,0,0,0,0,1],40],
[[10],52],[[10],26],[[24,-24,3,0,12,0,-9,0,0,0,1],14],[[3,-2,6],26],[[1,-18,
88,-148,81],0],[[1,0,4,-4,3],26],[[38,-78,0,36],3],[[-18,18,0,-4],42],[[2,-10,
-7,20,-4,-8,0,0,3],8],[[-10,66,-123,71],1],[[-3,22,-28,-30,81,-42,0,-3,7],6],
[[],0],[[1,-12,34,-40,17],2],[[20,-65,45],2],[[],0],[[],0],[[],0],[[-8,24,-17,
-84,141,-60,1,-11,13],6],[[11,-48,36],2],[[-1,0,3],28],[[3,-40,141,-201,100],
0],[[6,-18,0,30,-18,0,0,3],7],[[-2],13],[[8,-1,-12,3,0,1],7],[[-2,0,2,-2,1],
28],[[3,-12,1,15,-12,0,0,1],7],[[1,-6,20,-26,13],2],[[-2,19,-68,115,-98,34],
1],[[6,-6,-3,0,3],6],[[-1,0,-1],13],[[-4,17,-24,11],3],[[5,-11,6],4],[[],0],
[[-2,8,-13,7],3],[[7,-10,0,3],5],[[1,-1],21],[[3,-6,0,1],5],[[-2],10],[[1],
18],[[1],9],[[2,-18,44,-47,19],2],[[1,-4,3],4],[[],0],[[-15,38,-26,-11,13],4],
[[-2,0,1],30],[[3,0,0,-1],16],[[3,-1],14],[[1,-3,1],4],[[1,-2,1,-1],14],[[6,
-30,64,-63,24],2],[[-5,21,-19,-3,7],4],[[],0],[[1,-9,29,-36,15],2],[[],0],[[],
0],[[],0],[[-245,455],0],[[273,-189,0,120,0,0,-21,0,0,0,27],39],[[-29,168,
-312,191],0],[[32,-50,-81,225,-120,0,-12,24],6],[[30,-130,110],1],[[-15,35,0,
-19,-20,30,0,5,-7,0,0,0,0,1],18],[[9,-44,0,86,-67,0,0,10],6],[[-12,53,-51,-12,
24],3],[[3,-3,0,-3,2,3],20],[[-3,-6,0,9,-6,0,-1,0,0,1],12],[[3,-30,87,-104,
46],1],[[-10,95,-225,155],0],[[5,-16,36,-14,-15,5,16,-1,-1],17],[[-6,26,-19,0,
-4,8,3,-6,0,0,0,1],14],[[12,-6,-3],13],[[-1,15,-76,164,-164,65],0],[[-4,25,
-42,24],2],[[7,-43,109,-125,52],1],[[3,-9,8,-1,-1],13],[[5,-5,4,-1],15],[[-2,
7,4,-9,2,0,1],7],[[11,-28,17],3],[[-1,6,-8,-4,14,-8,0,0,1],7],[[4,-16,10],3],
[[3,-10,0,9,-5,0,0,1],8],[[-1,-1,1,-1],10],[[2,-4,2],5],[[-7,36,-58,29],2],
[[1,-3,0,2],8],[[-6,16,-12,-31,50,-21,0,-3,4],7],[[16,-29,0,10],4],[[1,-15,56,
-78,37],1],[[1,-1,-4,7,-1,-2,0,0,1],9],[[-6,15,-10,-3,4],5],[[-1,1],6],[[-1,1,
-2,1],4],[[-1],8],[[-2,7,-9,4],4],[[1,-1],6],[[-1,4,-4,0,1],5],[[],0],[[1,-7,
17,-18,7],3],[[2,-3,0,1],6],[[1,-2,6,-8,4],3],[[3,-2,-1,0,1],7],[[4,-17,31,
-28,10],3],[[2,-1,-1],8]],,[[[1400],0],[[1400],60],[[7,0,0,-128,189,0,-144,0,189,-128,0,
0,7],0],[[340,-720,340],0],[[15,0,-33,0,65,0,165,-464,165,0,65,0,-33,0,15],8],
[[40],30],[[74,-344,564,-344,74],0],[[240,-460,240],0],[[45,-64,24,0,10,0,24,
-64,45],28],[[65],40],[[65],20],[[9,-16,6,0,16,0,6,-16,9],8],[[24,-34,24],20],
[[32,-156,256,-156,32],0],[[8,-24,40,-24,8],20],[[7,0,-63,104,-63,0,7],0],[[3,
0,-27,40,-27,0,3],30],[[-1,2,-4,-6,10,-6,-4,2,-1],4],[[25,-120,190,-120,25],
0],[[-5,27,-23,-19,40,-19,-23,27,-5],3],[[4],15],[[1,-10,41,-64,41,-10,1],0],
[[10,-50,80,-50,10],0],[[],0],[[],0],[[],0],[[1,-2,2,-8,67,-103,18,54,18,-103,
67,-8,2,-2,1],0],[[7,-32,54,-32,7],0],[[4,-8,9,-8,4],20],[[48,-236,372,-236,
48],0],[[5,-4,-9,12,-9,-4,5],4],[[1],10],[[1,2,-8,2,1],4],[[1,-4,9,-14,9,-4,
1],20],[[1,1,-4,8,-4,1,1],4],[[1,-4,21,-38,21,-4,1],0],[[5,-46,152,-226,152,
-46,5],0],[[5,-14,5],4],[[-2],11],[[-4,18,-28,18,-4],1],[[-1,6,-10,6,-1],1],
[[],0],[[-1,8,-14,8,-1],1],[[-1,4,-6,4,-1],2],[[1,0,-2,0,1],15],[[2,-2,2],3],
[[2],8],[[-1],14],[[-1],7],[[1,-13,49,-74,49,-13,1],0],[[2,-4,2],2],[[],0],
[[1,-2,-7,39,-58,39,-7,-2,1],0],[[1,2,1],22],[[1],13],[[1],11],[[1,-4,1],2],
[[-2],12],[[2,-22,79,-118,79,-22,2],0],[[-4,17,-26,17,-4],2],[[1],5],[[-9,34,
-50,34,-9],1],[[],0],[[],0],[[],0],[[-700,700],0],[[280,0,0,-420,0,0,420,0,0,
-280],27],[[-160,540,-540,160],0],[[-3,4,0,48,-170,99,72,-72,-99,170,-48,0,-4,
3],0],[[-60,180,-180,60],0],[[4,0,-20,0,0,96,-96,0,0,20,0,-4],10],[[18,-34,6,
42,-42,-6,34,-18],3],[[-3,4,30,-85,85,-30,-4,3],0],[[4,0,0,-4],15],[[1,-3,3,
-1],9],[[-10,68,-162,162,-68,10],0],[[-110,360,-360,110],0],[[1,0,-5,0,20,-11,
15,-15,11,-20,0,5,0,-1],9],[[17,-14,0,-8,8,0,14,-17],9],[[10,3,-3,-10],9],
[[-21,134,-315,315,-134,21],0],[[-3,16,-47,47,-16,3],0],[[-12,92,-212,212,-92,
12],0],[[4,-5,-1,1,5,-4],9],[[1,-2,-1,-1,1,1,2,-1],9],[[-1,4,-4,1],5],[[-1,9,
-26,26,-9,1],0],[[3,-5,5,-3],6],[[4,-12,12,-4],1],[[1,-1,-2,2,1,-1],5],[[],0],
[[-1,3,-3,1],2],[[-3,29,-68,68,-29,3],0],[[],0],[[-8,20,-5,-19,19,5,-20,8],4],
[[9,-25,25,-9],2],[[-6,45,-111,111,-45,6],0],[[2,1,-3,3,-1,-2],6],[[1,-7,15,
-15,7,-1],2],[[1,-1],3],[[3,-3],3],[[1,-1],5],[[-3,9,-9,3],2],[[],0],[[-1,2,
-2,1],3],[[1,-1],3],[[1,-10,25,-25,10,-1],1],[[-1,1,-1,1],3],[[-2,9,-9,2],2],
[[3,-3],5],[[3,-19,46,-46,19,-3],1],[[],0]],[[[840],0],[[840],66],[[-16,54,0,
-140,0,180,-80,0,0,10],3],[[174,-408,258],0],[[5,-60,75,-160,165,-60,60,0,-21,
0,15,0,5],12],[[-40],33],[[36,-176,300,-240,88],0],[[90,-288,174],0],[[20,0,0,
-64,0,0,20],34],[[30],44],[[30],22],[[-19,0,36,-16,0,0,2],12],[[9,-18,12],22],
[[15,-60,129,-120,39],0],[[3,-12,18,-12,6],22],[[-18,84,-60,0,10],2],[[18,-36,
36,0,-2],35],[[-1,-2,12,-8,-7,6],6],[[6,-43,96,-89,30],0],[[2,-2,-18,54,-43,
-14,30,-10,0,0,1],4],[[],0],[[1,-4,12,-22,24,-16,5],0],[[-10,35,-40,10],1],
[[-5],18],[[],0],[[],0],[[-8,13,-18,1,52,-19,-71,73,-16,0,-3,4],3],[[-4,22,
-20,10],1],[[-4,1,-8,1],23],[[21,-107,196,-169,59],0],[[1,0,-5,20,-24,0,8],4],
[[2],11],[[-11,12,0,-2],6],[[-2,5,-4,3,-4,1],23],[[-3,13,-15,3,2,-1],6],[[-2,
5,-10,9,-7,4],1],[[2,-22,67,-102,97,-56,17],0],[[2,-4,6,0,-1],4],[[1,-2],11],
[[3,-7,8,-6,1],2],[[-1,2,-1],3],[[],0],[[1,-1,1,-2,1],2],[[-1,-2,5,-2],3],[[],
0],[[-1,2,-1],4],[[],0],[[],0],[[],0],[[-3,15,-27,27,-18,5],1],[[-1],4],[[],
0],[[-3,14,-34,41,-15,-3,4],2],[[4],25],[[-3,0,0,1],14],[[-3,1],12],[[1],3],
[[-1,2,-1,1],12],[[1,-9,29,-48,48,-30,9],0],[[5,-15,17,-8,0,1],3],[[],0],[[-3,
9,-16,19,-12,4],1],[[1],14],[[],0],[[],0],[[-378,462],0],[[294,-378,0,0,0,0,
168],33],[[-80,282,-330,148],0],[[12,-31,27,60,-80,-72,144,-44,0,-3,7],3],
[[-10,80,-124,50],0],[[15,-25,20,-40,10,-5,20,0,0,0,0,0,1],13],[[-4,0,45,-70,
0,39,-15,0,0,1],4],[[9,-45,72,-36,-3,7],2],[[6,-2],17],[[-3,-3,0,3,-3,0,2],9],
[[-3,24,-69,87,-62,19],0],[[-45,174,-234,99],0],[[5,-16,-10,9,10,0,-5,0,1],
15],[[4,-15,-12,32,-8,0,0,2],12],[[-3,0,6],11],[[-9,63,-149,177,-117,37],0],
[[3,-13,19,-14,7],1],[[-6,39,-92,119,-82,25],0],[[-1,6,2,-6,2],11],[[2,-6,0,5,
-2],12],[[4,-11,8,0,-2],6],[[-4,11,-9,1],2],[[1,-7,13,-11,2,2,-1],6],[[2,-3,
1],3],[[-3,0,8,-5],6],[[],0],[[],0],[[6,-22,34,-26,7],1],[[2,-3],8],[[-1,1,1,
-18,36,-17,-13,17,-5,0,0,1],4],[[-10,23,-12,0,1],3],[[-3,15,-40,60,-43,13],0],
[[2,-1,4,-2,-3,2],7],[[-2,5,-10,9,-4,0,1],3],[[-1],5],[[1],4],[[1],6],[[1,-1,
1,-1],3],[[],0],[[1,-1,1,-1],4],[[],0],[[1,-3,6,-7,7,-5,2],1],[[1],6],[[-1,1,
0,0,-1,1],2],[[-1,1],6],[[1,-7,13,-16,14,-9,3],1],[[-2,1],7]],,[[[1680],0],[[1680],60],[[10,0,0,-192,198,0,-16,0,198,-192,0,0,
10],0],[[400,-880,400],0],[[15,0,12,0,-60,0,225,-464,225,0,-60,0,12,0,15],8],
[[-16],30],[[76,-416,696,-416,76],0],[[300,-540,300],0],[[30,0,0,0,0,0,0,0,
30],28],[[6],40],[[6],20],[[21,-24,0,0,12,0,0,-24,21],8],[[3,0,3],20],[[34,
-192,322,-192,34],0],[[1,0,4,0,1],20],[[10,0,-66,144,-66,0,10],0],[[-2,0,18,0,
18,0,-2],30],[[-1,8,0,-4,-6,-4,0,8,-1],4],[[30,-150,240,-150,30],0],[[-8,37,
-34,1,8,1,-34,37,-8],3],[[],0],[[-10,54,-88,54,-10],1],[[14,-66,104,-66,14],
0],[[-1,0,4,0,-6,0,4,0,-1],12],[[-5],24],[[-5],12],[[-3,4,-12,78,-123,46,0,46,
-123,78,-12,4,-3],1],[[10,-48,56,-48,10],0],[[1,0,-4,0,1],20],[[52,-284,468,
-284,52],0],[[7,-8,-1,8,-1,-8,7],4],[[2],10],[[5,0,-12,0,5],4],[[-1,0,-1],22],
[[3,0,-4,0,-4,0,3],4],[[-6,29,-48,29,-6],1],[[3,-48,190,-292,190,-48,3],0],
[[9,-20,9],4],[[1,0,1],10],[[-5,25,-42,25,-5],1],[[-1,9,-16,9,-1],1],[[],0],
[[-2,10,-16,10,-2],1],[[-1,6,-10,6,-1],2],[[],0],[[3,-6,3],3],[[],0],[[],0],
[[],0],[[1,-15,65,-102,65,-15,1],0],[[2,-4,2],2],[[-1],6],[[-3,-2,45,-84,45,
-2,-3],1],[[-2,0,-2],22],[[1,0,0,0,0,0,1],10],[[1,0,1],10],[[1,0,1],2],[[1,0,
0,0,1],10],[[1,-23,101,-158,101,-23,1],0],[[-3,23,-40,23,-3],2],[[],0],[[-9,
45,-72,45,-9],1],[[-1,2,-1],12],[[1],8],[[1],4],[[-840,840],0],[[315,-189,0,
336,0,0,-336,0,189,-315],27],[[-180,660,-660,180],0],[[-3,7,0,72,-201,117,8,
-8,-117,201,-72,0,-7,3],0],[[-80,220,-220,80],0],[[1,20,-10,-20,101,-101,20,
10,-20,-1],11],[[28,-48,6,6,-6,-6,48,-28],3],[[-3,7,27,-111,111,-27,-7,3],0],
[[3,-5,0,0,5,-3],14],[[4,0,0,-4],9],[[-10,82,-208,208,-82,10],0],[[-130,440,
-440,130],0],[[1,0,0,0,0,-21,60,-60,21,0,0,0,0,-1],9],[[-6,23,-16,0,-6,6,0,16,
-23,6],8],[[9,-6,6,-9],9],[[-19,156,-395,395,-156,19],0],[[-3,25,-58,58,-25,
3],0],[[-11,105,-271,271,-105,11],0],[[5,-7,7,-7,7,-5],9],[[2,-3,3,-3,3,-3,3,
-2],9],[[-2,3,6,-6,-3,2],4],[[-1,13,-37,37,-13,1],0],[[-1,2,2,-2,2,-2,-2,1],
4],[[7,-13,13,-7],1],[[2,0,-2,2,0,-2],5],[[1,1,-1,-1],7],[[-1,5,-5,1],2],[[-4,
36,-92,92,-36,4],0],[[1,-1,1,-1],6],[[-10,28,-17,-3,3,17,-28,10],4],[[10,-36,
36,-10],2],[[-5,54,-145,145,-54,5],0],[[-1,2,0,-1,1,0,-2,1],5],[[-7,24,-24,7],
3],[[1,-1],3],[[1,-1],3],[[1,-1],5],[[-4,14,-14,4],2],[[],0],[[-1,5,-5,1],3],
[[],0],[[-12,36,-36,12],2],[[2,-2],4],[[-3,11,-11,3],2],[[-1,5,-5,1],4],[[2,
-24,64,-64,24,-2],1],[[2,-2],6]],[[[972],0],[[972],70],[[54,0,-90,0,270,-144,
0,0,18],4],[[171,-468,333],0],[[5,0,30,-128,135,-60,35,0,3,-40,45,0,10,0,0,0,
0,0,1],12],[[36],35],[[30,-168,342,-312,120],0],[[81,-324,243],0],[[],0],[[],
0],[[],0],[[-9,0,36,-24,-9,0,6],12],[[],0],[[9,-54,144,-162,63],0],[[],0],
[[-18,90,-90,0,18],2],[[-18,30,-18,0,6],37],[[-1,2,9,-10,-10,18,-1,0,0,0,1],
6],[[3,-36,108,-126,51],0],[[1,-4,-11,39,-34,-31,60,-21,0,-1,2],4],[[],0],
[[-2,9,-24,36,-28,9],1],[[-6,39,-60,24],1],[[4,0,-6,0,0,0,-1],16],[[-3],28],
[[-3],14],[[9,-18,3,30,-6,-102,120,-36,0,-6,6],4],[[18,-36,18],2],[[],0],[[15,
-99,222,-225,87],0],[[1,-2,-4,14,-22,-2,18,-4,0,0,1],4],[[],0],[[-9,12,3,-6],
6],[[],0],[[-3,9,-15,3,9,-3],6],[[3,-9,15,-15,6],2],[[1,-14,59,-116,131,-86,
25],0],[[2,-8,11,-4,-2,0,1],4],[[],0],[[2,-8,15,-13,4],2],[[-1,4,-5,1],3],
[[-1],10],[[-1,1,1,-5,2],2],[[-1,-1,8,-5,0,1],3],[[1,1],19],[[3,-3],5],[[],0],
[[],0],[[],0],[[-1,12,-31,43,-32,10],1],[[2,-2,0,1],3],[[1],7],[[-3,12,-39,54,
-24,-6,6],2],[[],0],[[],0],[[],0],[[3,-3],3],[[],0],[[-5,24,-54,69,-49,15],1],
[[4,-17,27,-15,-1,2],3],[[],0],[[-1,7,-18,29,-24,7],1],[[1,-1],15],[[],0],[[],
0],[[-405,567],0],[[84,0,-216,280,0,-189,168,0,0,0,0,0,35],33],[[-72,297,-405,
198],0],[[-27,27,36,-54,-108,222,-84,0,-6,12],4],[[-6,75,-159,84],0],[[14,-30,
10,-5,5,0,0,-10,5,0,5],15],[[-3,3,30,-57,-3,78,-33,0,0,3],4],[[9,-45,90,-54,
-6,12],2],[[4,0,3,0,0,-3,2],18],[[3,0,4,-6,0,5],10],[[-1,18,-67,113,-93,32],
0],[[-36,180,-288,144],0],[[19,-40,21,-5,5,0,-5,-1,6],15],[[3,-6,-12,32,-13,
-6,-2,4],12],[[3,-8,6,0,-1],11],[[-6,51,-153,219,-165,54],0],[[-9,24,-27,12],
2],[[-3,30,-93,147,-120,39],0],[[1,-2,7,-10,2,2],11],[[-2,-1,7,-3,-1],13],[[3,
-10,7,4,-4],6],[[-3,15,-18,6],2],[[1,-5,11,-11,-1,7,-2],6],[[3,0,-6,3],2],[[1,
-1,0,5,-7,0,3,-1],5],[[-1,0,1],10],[[1,-1],5],[[3,-21,45,-45,15],1],[[-1,0,-3,
1],7],[[2,0,-12,26,-12,-27,33,-10,0,-1,1],5],[[-9,30,-24,0,3],3],[[-1,10,-39,
75,-68,23],0],[[-2,4,-3,-4,5],8],[[-1,5,-13,16,-7,-1,1],3],[[1,-1],4],[[-1,3,
-2],3],[[1,0,-1],6],[[1,-2,4,-3,1],3],[[1],5],[[-1,3,-2],5],[[1,-1],4],[[-2,5,
-10,13,-10,3],2],[[-1,0,1,-1],4],[[1,1,-3,1],4],[[1,-2,3,-1,-1],5],[[-4,13,
-22,25,-17,5],2],[[-2,2],7]],,[[[1050],0],[[1050],72],[[45,0,-104,0,306,-208,0,0,19],4],
[[170,-500,380],0],[[30,-48,120,-120,90,0,-6,-80,75,0,0,-12,0,0,0,0,1],14],
[[-30],36],[[31,-160,354,-368,137],0],[[75,-345,285],0],[[-60,0,60,0,15],36],
[[15],48],[[15],24],[[-6,0,24,-24,-3,0,6],12],[[3,-12,6],24],[[4,-52,152,-182,
84],0],[[1,-4,14,-8,3],24],[[-15,88,-102,0,19],2],[[9,-32,18,0,-5],38],[[6,
-12,-12,24,-5,-4,0,0,1],8],[[2,-31,113,-148,66],0],[[1,-2,-11,43,-31,-41,76,
-34,0,-1,2],4],[[-2],18],[[6,-24,43,-40,13],2],[[-5,40,-70,35],1],[[],0],[[],
0],[[],0],[[-18,-3,34,3,-111,145,-68,0,-6,7],5],[[16,-52,19],2],[[10,-4,1],
26],[[13,-92,233,-261,106],0],[[-2,-2,16,-20,-2,22,-14,0,0,1],5],[[3],12],
[[-6,8,5,-6],6],[[3,-8,7,-2,1],26],[[-2,8,-12,0,13,-3],6],[[-8,22,-23,7],3],
[[1,-12,49,-114,159,-110,29],0],[[-6,15,-8,0,0,1],5],[[1,-2,1],12],[[1,-7,19,
-20,7],2],[[-1,5,-8,4],3],[[],0],[[-1,2,5,-8,2],2],[[-2,6,-5,0,1],4],[[1,0,
-1],20],[[3,-3],5],[[],0],[[],0],[[],0],[[-1,8,-29,54,-45,13],1],[[2,-1,-2,1],
3],[[],0],[[14,-42,53,-27,-6,7],3],[[-4,3],27],[[-2,0,0,1],15],[[-2,1],13],
[[2,-3],3],[[-1,0,-1,1],13],[[-3,18,-53,84,-66,19],1],[[3,-17,29,-17,-1,2],3],
[[1],6],[[4,-18,36,-33,11],2],[[],0],[[],0],[[],0],[[-420,630],0],[[-216,280,
0,0,315,-189,0,-15,0,0,35],35],[[-71,297,-453,229],0],[[-18,27,46,-58,-126,
256,-132,0,-6,13],4],[[-5,70,-180,105],0],[[-5,-9,25,-30,20,0,-5,-20,20,0,0,
-6],15],[[-2,3,28,-60,-3,97,-52,0,0,3],4],[[6,-47,92,-60,-6,13],2],[[3,-7,3,
-3,2],20],[[1,-9,0,6,-3,0,-1],12],[[-1,14,-62,125,-118,40],0],[[-30,185,-315,
175],0],[[9,-15,26,-21,20,-4,0,-6,6],15],[[3,-3,-12,20,-10,3,-2,4],12],[[-8,9,
3,-1],12],[[-6,46,-144,243,-203,63],0],[[-5,30,-39,13],2],[[-2,24,-89,163,
-146,50],0],[[-2,6,-8,1,3],12],[[-1,3,-2,-1],14],[[3,-7,2,5,-4],6],[[-3,16,
-23,12],2],[[1,-5,10,-6,-5,9,-2],6],[[2,1,-10,3],2],[[-1,-3,5,-4,-1,5,-5],6],
[[-1,0,1],10],[[2,-3,1],5],[[2,-18,51,-57,22],1],[[-1,1],7],[[1,2,-17,25,-3,
-34,43,-18,0,-1,1],5],[[-7,31,-28,0,3],3],[[6,-38,82,-84,33],1],[[3,-3,-3,6,
-2,-2],9],[[6,-13,17,-8,-1,1],4],[[1,0,-1],4],[[-1,3,-1],3],[[2,-1],7],[[-2,7,
-7,2],4],[[1,-1],5],[[-1,3,-2],5],[[1,-1],4],[[3,-11,20,-16,4],3],[[1,0,-1],
5],[[-2,0,5,-5,1],3],[[-3,4,-2],6],[[-2,8,-24,37,-25,6],2],[[-1,1],7]],
,[[[2100],0],[[2100],60],[[12,0,0,-176,306,0,-168,0,
306,-176,0,0,12],0],[[510,-1080,510],0],[[5,0,0,-20,-18,0,60,0,255,-624,255,0,
60,0,-18,-20,0,0,5],6],[[20],30],[[108,-528,828,-528,108],0],[[360,-690,360],
0],[[20,0,0,0,0,0,-10,0,0,0,0,0,20],26],[[30],40],[[30],20],[[2,0,0,-24,18,0,
2,0,18,-24,0,0,2],6],[[9,-24,9],20],[[48,-234,384,-234,48],0],[[3,-12,30,-12,
3],20],[[12,0,-102,160,-102,0,12],0],[[-18,16,-18],32],[[1,8,-10,-8,14,-8,-10,
8,1],4],[[37,-181,284,-181,37],0],[[-1,0,-7,38,-42,-19,58,-19,-42,38,-7,0,-1],
1],[[],0],[[1,-16,61,-96,61,-16,1],0],[[15,-75,120,-75,15],0],[[],0],[[],0],
[[],0],[[-3,6,-20,92,-143,46,58,46,-143,92,-20,6,-3],1],[[12,-44,78,-44,12],
0],[[-8,6,-8],21],[[73,-351,562,-351,73],0],[[-2,6,-4,-7,20,-7,-4,6,-2],3],
[[2],10],[[-2,0,6,-6,6,0,-2],3],[[-2,9,-12,9,-2],21],[[-1,2,3,-8,4,-8,3,2,-1],
3],[[-8,33,-48,33,-8],1],[[7,-72,230,-330,230,-72,7],0],[[-1,-2,12,-18,12,-2,
-1],2],[[1,0,1],10],[[-6,27,-42,27,-6],1],[[-1,9,-16,9,-1],1],[[],0],[[-2,10,
-16,10,-2],1],[[-1,6,-10,6,-1],2],[[],0],[[-1,3,-4,3,-1],2],[[],0],[[],0],[[],
0],[[1,-21,74,-108,74,-21,1],0],[[2,-4,2],2],[[],0],[[-3,-6,59,-102,59,-6,-3],
1],[[-2],23],[[-2],13],[[-2],11],[[-2],3],[[-1,0,-1],11],[[3,-34,119,-174,119,
-34,3],0],[[-1,-6,29,-42,29,-6,-1],1],[[],0],[[1,-12,50,-78,50,-12,1],0],[[],
0],[[],0],[[],0],[[-1050,1050],0],[[189,0,0,0,0,-189,0,0,189,0,0,0,0,-189],
25],[[-240,810,-810,240],0],[[-3,9,0,76,-235,171,84,-84,-171,235,-76,0,-9,3],
0],[[-90,270,-270,90],0],[[1,0,0,0,-4,-11,8,-20,116,-116,20,-8,11,4,0,0,0,-1],
7],[[-1,0,0,22,-59,12,54,-54,-12,59,-22,0,0,1],0],[[-3,9,45,-137,137,-45,-9,
3],0],[[-3,0,4,3,-3,-4,0,3],13],[[3,3,1,-3,3,-1,-3,-3],7],[[-14,105,-241,241,
-105,14],0],[[-165,540,-540,165],0],[[-1,0,0,0,-10,56,-56,10,0,0,0,1],10],[[2,
0,8,-22,12,-1,1,-12,22,-8,0,-2],7],[[-9,9],10],[[-30,207,-468,468,-207,30],0],
[[-3,28,-64,64,-28,3],0],[[-20,134,-320,320,-134,20],0],[[-4,6,-6,4],10],[[-1,
1,-3,3,-1,1],10],[[-2,-2,7,-7,2,2],4],[[-1,14,-39,39,-14,1],0],[[-1,1,5,-7,7,
-5,-1,1],4],[[-1,4,-15,15,-4,1],0],[[-1,1,-1,-3,3,1,-1,1],4],[[1,1,-1,-1],7],
[[-1,5,-5,1],2],[[-5,42,-103,103,-42,5],0],[[-1,1,0,0,-1,1],5],[[-1,1,-11,29,
-16,-27,27,16,-29,11,-1,1],2],[[-1,0,17,-39,39,-17,0,1],0],[[-9,67,-167,167,
-67,9],0],[[2,-1,-4,4,1,-2],6],[[-10,27,-27,10],3],[[1,-1],3],[[1,-1],3],[[1,
-1],5],[[-5,13,-13,5],2],[[],0],[[-2,4,-4,2],3],[[],0],[[2,-15,37,-37,15,-2],
1],[[2,-2],4],[[-4,10,-10,4],2],[[-2,4,-4,2],4],[[5,-31,66,-66,31,-5],1],[[-1,
1,-1,1],5]],[[[1344],0],[[1344],75],[[36,0,-104,0,396,-320,0,0,56],4],[[184,
-640,520],0],[[-64,150,-60,50,0,-48,-80,120,0,30,-36,0,0,0,0,2],15],[[],0],
[[20,-176,456,-496,196],0],[[84,-420,420],0],[[60,0,-24,64,-15,0,0,0,0,0,0,0,
-1],37],[[-24],50],[[-24],25],[[-3,0,30,-56,12,0,18,0,-9,0,0,0,2],12],[[-6,12,
-12],25],[[4,-50,190,-270,120],0],[[-2,4,-14,12,-6],25],[[-12,88,-132,0,56],
2],[[],0],[[6,-16,-10,32,-2,-12,0,0,2],8],[[1,-31,144,-221,107],0],[[-2,-3,33,
-37,-58,124,-59,0,-6,8],5],[[],0],[[6,-32,68,-60,18],2],[[-4,51,-114,66],1],
[[-4,0,6,0,-4,0,1],17],[[4],30],[[4],15],[[-9,14,30,-13,-150,221,-88,5,-19,
13],5],[[28,-80,56],2],[[-8,4,-4],27],[[9,-95,300,-365,155],0],[[-1,2,10,-24,
-1,42,-26,0,0,2],5],[[],0],[[-3,10,4,-18,3,0,2],6],[[-1,6,-9,4,-2],27],[[-1,5,
-12,2,23,-15,0,0,2],6],[[2,-15,39,-41,13],2],[[-6,52,-154,220,-158,44],1],
[[-4,14,-8,-6,0,2],5],[[],0],[[1,-13,35,-35,12],2],[[-2,12,-15,5],3],[[],0],
[[-3,15,-20,8],3],[[-2,14,-14,0,2],4],[[],0],[[7,-9,0,2],5],[[],0],[[],0],[[],
0],[[9,-45,85,-73,23],2],[[1,2,-6,2],3],[[],0],[[7,-41,74,-34,-19,13],3],[[4,
-3,0,-1],28],[[],0],[[],0],[[1,0,-3,2],3],[[],0],[[-1,19,-73,124,-98,29],1],
[[1,-17,41,-27,-6,8],3],[[],0],[[4,-27,58,-53,17],2],[[-2,1],16],[[1],10],
[[1],5],[[-504,840],0],[[280,0,-189,378,-189,0,15,0,0,35,0,0,-21,27],36],
[[-64,360,-600,320],0],[[-9,27,34,-70,-153,371,-192,0,-24,32],4],[[-4,80,-240,
180],0],[[-15,30,-5,16,4,-23,-20,30,-1,7,-7],16],[[-1,3,20,-56,-3,139,-100,0,
0,14],4],[[3,-39,109,-81,-24,32],2],[[6,-4,-3,-3,1,3],20],[[4,-9,-3,15,-6,0,
-1],12],[[11,-75,177,-177,64],1],[[-29,210,-430,255],0],[[-24,31,-5,10,-14,-5,
-1,15,0,0,-1],16],[[-3,-12,42,-38,6,-8,10,3,-6,0,0,-1,1],13],[[-8,9,-3,-1,-3],
12],[[-2,39,-176,328,-285,94],0],[[-11,49,-72,32],2],[[-1,19,-105,225,-211,
73],0],[[-2,5,-12,8,1,2,-2],12],[[-1,6,-10,2,0,2,-1],14],[[-7,4,10,-11,2,-1,
1],7],[[-3,27,-46,20],2],[[-2,8,-9,-9,19,-9,0,-1,1],7],[[1,9,-24,14],2],[[-1,
1,5,-10,0,10,-5],6],[[-2,1,2,-1],10],[[-1,4,-4,1],4],[[1,-22,78,-95,39],1],
[[1,-2,1,2,-1],8],[[-2,-6,26,-10,-54,71,-26,1,-5,3],6],[[-5,35,-46,0,14],3],
[[5,-42,118,-131,48],1],[[3,-6,-5,9,-1,-2],9],[[3,-18,26,-11,-5,3],4],[[1,0,
-1],4],[[1,1,-3,1],4],[[2,-2],7],[[1,-6,13,-11,3],3],[[1,-1],6],[[-3,8,-5,-1,
1],5],[[1,-1],4],[[5,-18,31,-23,6],3],[[-1,5,-3],5],[[1,-4,11,-11,3],3],[[-2,
5,-2,-1],6],[[-1,14,-39,56,-39,10],2],[[3,0,-2],8]],,[[[2688],
0],[[2688],60],[[4,0,0,-192,396,0,-288,0,396,-192,0,0,4],0],[[672,-1344,672],
0],[[15,-20,24,0,0,-120,345,-488,345,-120,0,0,24,-20,15],8],[[64],30],[[168,
-672,1008,-672,168],0],[[432,-912,432],0],[[-15,-64,60,0,-10,0,60,-64,-15],
28],[[60],40],[[60],20],[[-6,-16,24,0,-16,0,24,-16,-6],8],[[18,-48,18],20],
[[68,-296,444,-296,68],0],[[5,-32,42,-32,5],20],[[4,0,-132,256,-132,0,4],0],
[[4,0,-36,64,-36,0,4],30],[[-1,8,-8,-16,34,-16,-8,8,-1],4],[[48,-216,336,-216,
48],0],[[-10,46,-42,-54,120,-54,-42,46,-10],3],[[],0],[[2,-24,66,-88,66,-24,
2],0],[[16,-80,136,-80,16],0],[[1,0,0,0,6,0,0,0,1],12],[[3],24],[[3],12],[[-2,
0,-28,131,-163,9,90,9,-163,131,-28,0,-2],1],[[4,-48,72,-48,4],0],[[1,-12,18,
-12,1],20],[[108,-444,672,-444,108],0],[[-2,10,-8,-22,44,-22,-8,10,-2],3],
[[4],10],[[2,8,-24,8,2],4],[[-6,14,-20,14,-6],21],[[2,0,-16,24,-16,0,2],4],
[[-9,29,-38,29,-9],1],[[17,-108,276,-370,276,-108,17],0],[[-2,15,-26,15,-2],
3],[[1,-4,1],10],[[1,-8,24,-34,24,-8,1],0],[[-2,6,-8,6,-2],1],[[],0],[[-1,4,
-6,4,-1],1],[[-1,6,-10,6,-1],2],[[],0],[[2,-4,2],3],[[],0],[[],0],[[],0],[[4,
-28,78,-108,78,-28,4],0],[[-1,2,-1],2],[[-1],6],[[-2,-21,87,-128,87,-21,-2],
1],[[1,-2,1],22],[[1,0,0,-2,0,0,1],10],[[1,-2,1],10],[[-2,4,-2],2],[[1,-1,0,
-1,1],10],[[7,-51,135,-182,135,-51,7],0],[[-8,36,-56,36,-8],2],[[],0],[[2,-18,
52,-70,52,-18,2],0],[[1,0,1],12],[[],0],[[],0],[[-1344,1344],0],[[-280,216,0,
336,0,0,-336,0,-216,280],27],[[-336,1008,-1008,336],0],[[-2,2,0,96,-294,198,
144,-144,-198,294,-96,0,-2,2],0],[[-96,336,-336,96],0],[[15,-5,-25,75,-75,25,
5,-15],12],[[20,-72,12,120,-120,-12,72,-20],3],[[-2,2,66,-194,194,-66,-2,2],
0],[[],0],[[3,-4,-3,3,4,-3],8],[[-24,132,-276,276,-132,24],0],[[-216,672,-672,
216],0],[[1,0,0,0,0,-21,50,-50,21,0,0,0,0,-1],9],[[3,5,-20,12,8,-8,-12,20,-5,
-3],8],[[8,-6,6,-8],9],[[-54,276,-558,558,-276,54],0],[[-2,26,-60,60,-26,2],
0],[[-34,182,-370,370,-182,34],0],[[4,-7,7,-7,7,-4],9],[[1,-3,3,-3,3,-3,3,-1],
9],[[-1,-3,16,-16,3,1],4],[[-2,14,-34,34,-14,2],0],[[-1,1,8,-20,20,-8,-1,1],
4],[[2,-6,6,-2],1],[[-1,2,4,-7,7,-4,-2,1],4],[[],0],[[-1,1,-1,1],2],[[-8,48,
-108,108,-48,8],0],[[1,-1,1,-1],6],[[2,-18,30,8,-58,58,-8,-30,18,-2],3],[[16,
-56,56,-16],2],[[-14,88,-182,182,-88,14],0],[[-1,1,3,-11,11,-3,-1,1],5],[[2,
-15,30,-30,15,-2],2],[[-1,1],3],[[1,-3,3,-1],2],[[],0],[[1,-4,7,-7,4,-1],1],
[[-1,1],4],[[-1,3,-3,1],3],[[-1,1],3],[[4,-17,29,-29,17,-4],1],[[],0],[[-2,3,
-3,2],2],[[-2,5,-5,2],4],[[-1,10,-35,61,-61,35,-10,1],0],[[2,-2],6]],[[[1400],
0],[[1400],72],[[-16,54,0,-200,0,360,-304,0,0,34],3],[[220,-680,500],0],[[75,
-152,165,-120,170,0,-90,-80,90,0,5,-24,0,0,0,0,1],14],[[40],36],[[34,-208,492,
-496,170],0],[[110,-450,390],0],[[10,0,60,-64,30,0,20,0,-6],36],[[50],48],
[[50],24],[[-11,0,24,-40,21,0,8,0,-6],12],[[11,-36,21],24],[[5,-70,215,-250,
105],0],[[2,-16,38,-28,9],24],[[-18,88,-120,0,34],2],[[-18,32,-36,0,6],38],
[[16,-20,-8,24,-5,-8,0,0,1],8],[[3,-44,160,-206,87],0],[[-2,-14,59,-44,-49,97,
-47,0,-3,3],5],[[],0],[[9,-40,67,-50,14],2],[[-10,60,-100,50],1],[[],0],[[],
0],[[],0],[[4,-26,-4,68,-6,-145,186,-84,4,-11,8],4],[[-4,40,-76,34],1],[[-4,
10,-16,4],25],[[15,-121,326,-355,133],0],[[-2,16,-22,0,25,-20,0,0,1],6],[[-2],
12],[[1,8,-3,-8,2],6],[[6,-16,16,-8,2],26],[[1,6,-13,0,11,-8],6],[[3,-22,40,
-32,8],2],[[1,-12,65,-170,225,-140,32],0],[[-2,11,-8,-1,0,1],5],[[2,-1],13],
[[2,-15,33,-27,8],2],[[-4,11,-11,4],3],[[],0],[[1,-8,18,-14,3],2],[[-4,10,-7,
0,1],4],[[],0],[[-2,5,-4],4],[[-1],8],[[-1],16],[[-1],8],[[-1,12,-49,83,-60,
15],1],[[-2,5,-4,1],3],[[],0],[[12,-46,65,-26,-11,8],3],[[2,2,-2],27],[[2],
15],[[2],13],[[-1,5,-2],3],[[1,0,1],13],[[-3,25,-83,124,-84,21],1],[[2,-17,34,
-19,-3,3],3],[[],0],[[6,-32,57,-43,12],2],[[],0],[[],0],[[],0],[[-560,840],0],
[[405,-315,0,0,315,-189,0,120,0,0,-56],35],[[-86,402,-618,294],0],[[4,-30,36,
90,-110,-153,331,-180,0,-15,19],3],[[-10,100,-240,150],0],[[10,-41,45,-40,40,
9,-18,-20,20,0,1,-6],15],[[-1,3,36,-84,-3,109,-82,0,0,6],4],[[6,-46,105,-69,
-15,19],2],[[-7,9,3,-5],18],[[9,2,-9,0,10,-3,0,-1],11],[[-1,18,-89,183,-160,
49],0],[[-40,250,-430,230],0],[[5,-6,-1,36,-19,-10,6,1,-1,-1],16],[[10,-1,-12,
28,-30,15,-4,4,3,-3],12],[[9,9,-6,-2],12],[[-6,55,-201,344,-269,75],0],[[1,
-18,56,-60,19],1],[[-2,29,-126,235,-194,59],0],[[3,-4,-2,8,-3,-1],12],[[-2,1,
-1,-5,6,-1],13],[[-2,-5,6,3,-5,1],6],[[-7,28,-35,15],2],[[-1,-2,10,-7,-5,10,
-4],6],[[-3,16,-19,6],2],[[-3,5,-2,0,5,-5],7],[[1,0,-1],9],[[-2,4,-3,1],4],
[[3,-29,79,-81,28],1],[[1,-1],8],[[1,-23,35,-4,-45,53,-21,1,-2,1],6],[[-7,31,
-34,0,6],3],[[8,-56,123,-114,39],1],[[4,-5,-1,6,-2,-2],9],[[4,-17,20,-7,-2,1],
4],[[-1,1,-1],4],[[-3,4,-1],4],[[-1,1],6],[[1,-7,12,-8,2],3],[[-1,1],5],[[1,
-3,5,-2],4],[[1],5],[[6,-22,30,-18,4],3],[[-2,3,-1],5],[[2,-8,12,-7,1],3],
[[-1,3,-2],6],[[-2,15,-43,54,-30,6],2],[[1,-1],8]],,[[[1575],0],[[1575],72],[[-32,63,0,-128,0,360,-368,0,0,48],3],[[240,
-780,555],0],[[120,-192,180,-60,40,0,-78,-60,90,0,10,-36,0,0,0,0,1],14],[[15],
36],[[30,-228,576,-564,177],0],[[135,-495,450],0],[[100,0,-60,64,0,0,-20,0,6],
36],[[-45],48],[[-45],24],[[10,0,12,-56,45,0,10,0,-12],12],[[-9,36,-18],24],
[[5,-80,255,-290,110],0],[[-1,16,-36,28,-7],24],[[-21,104,-120,0,48],2],[[-9,
16,0,0,4],38],[[8,-16,-2,28,-4,-12,0,0,1],8],[[4,-52,191,-241,97],0],[[1,-4,
-5,37,-28,-59,112,-54,0,-5,4],4],[[-1],18],[[11,-54,85,-54,11],2],[[-15,75,
-120,60],1],[[],0],[[],0],[[],0],[[8,-34,17,40,7,-161,201,-84,8,-16,8],4],
[[-8,46,-92,48],1],[[4,-14,16,-3],25],[[14,-135,383,-408,140],0],[[-2,-2,10,
-15,-2,28,-24,0,0,1],5],[[3],12],[[-6,4,5,-10,4],6],[[-8,16,-18,8,-1],26],
[[-2,6,-7,0,16,-13],6],[[4,-29,54,-37,8],2],[[-10,73,-210,269,-150,28],1],
[[-6,13,-6,-2,0,1],5],[[1,-2,1],12],[[3,-23,45,-32,7],2],[[-7,17,-13,3],3],
[[],0],[[1,-10,25,-19,4],2],[[-6,14,-8,0,1],4],[[1],20],[[-2,7,-5],4],[[],0],
[[],0],[[],0],[[-1,15,-66,106,-68,14],1],[[-2,7,-6,1],3],[[],0],[[12,-56,73,
-19,-16,8],3],[[4,-4,2],27],[[-2,0,0,1],15],[[-2,1],13],[[-2,5,-4],3],[[-1,0,
-1,1],13],[[-2,30,-106,153,-91,18],1],[[3,-23,41,-18,-5,4],3],[[-1],6],[[8,
-44,74,-48,10],2],[[],0],[[],0],[[],0],[[-630,945],0],[[594,-280,0,0,210,-189,
0,15,0,0,-35],35],[[-87,459,-711,318],0],[[8,-42,45,50,-78,-162,362,-204,0,
-24,24],3],[[-15,120,-270,180],0],[[25,-51,55,-10,10,8,-23,-10,15,0,2,-6],15],
[[-4,3,23,-50,-3,118,-105,0,0,9],4],[[6,-53,120,-66,-24,24],2],[[6,3,-4,-3,3,
2],19],[[6,-1,-9,0,11,-3,0,-1],11],[[-1,19,-108,223,-184,50],0],[[-45,285,
-495,255],0],[[9,-15,26,-15,5,-9,0,4,-5],15],[[-9,1,-6,30,-50,27,-6,4,6,-6],
12],[[-10,3,-3,1],12],[[-4,56,-235,410,-301,74],0],[[2,-22,71,-75,24],1],[[-1,
30,-150,283,-219,57],0],[[-3,6,-6,6,-3],12],[[2,-1,2,-8,8],13],[[3,-5,0,9,-6,
2],6],[[-11,39,-44,16],2],[[1,-4,7,-3,-9,14,-6],6],[[-4,19,-27,9],2],[[-1,-3,
5,-4,-1,5,-4],6],[[-1,1,1],10],[[-4,6,-3],4],[[4,-38,101,-97,30],1],[[-1,1],
7],[[1,-3,-11,25,6,-56,57,-19,2,-3,1],5],[[-11,38,-36,0,9],3],[[9,-69,153,
-131,38],1],[[2,-4,-1,6,-1,-2],9],[[6,-23,23,-4,-3,1],4],[[-1,2,-1],4],[[1,-3,
5,-2],3],[[2,-1],7],[[2,-12,17,-8,1],3],[[-1,1],5],[[-5,7,-2],5],[[-1,1],4],
[[9,-32,38,-17,2],3],[[-3,4,-1],5],[[2,-12,17,-8,1],3],[[-3,4,-1],6],[[-2,21,
-60,67,-30,4],2],[[-1,1],7]],,[[[3150],0],[[3150],60],[[6,0,0,-208,423,0,-556,0,423,
-208,0,0,6],0],[[795,-1560,795],0],[[-20,-24,0,115,-240,480,-592,480,-240,115,
0,-24,-20],9],[[30],30],[[207,-792,1152,-792,207],0],[[495,-1080,495],0],[[30,
-64,24,0,-70,0,24,-64,30],28],[[45],40],[[45],20],[[3,-16,42,0,-40,0,42,-16,
3],8],[[18,-18,18],20],[[85,-340,510,-340,85],0],[[7,-16,18,-16,7],20],[[6,0,
-141,292,-141,0,6],0],[[2,0,-9,36,-9,0,2],30],[[8,-7,-26,56,-26,-7,8],5],[[56,
-248,382,-248,56],0],[[-13,43,-33,-100,204,-100,-33,43,-13],3],[[-2],15],[[5,
-30,72,-96,72,-30,5],0],[[15,-90,150,-90,15],0],[[],0],[[],0],[[],0],[[1,-2,1,
-44,144,-164,-27,188,-27,-164,144,-44,1,-2,1],0],[[6,-52,98,-52,6],0],[[3,-4,
-1,-4,3],20],[[133,-516,772,-516,133],0],[[-2,5,-2,-34,72,-34,-2,5,-2],3],
[[-3],10],[[-1,14,-32,14,-1],4],[[1,-4,1,-2,1,-4,1],20],[[1,-23,44,-23,1],5],
[[1,-13,34,-44,34,-13,1],0],[[24,-134,316,-412,316,-134,24],0],[[-2,10,-16,10,
-2],3],[[-1,2,-1],10],[[1,-8,24,-34,24,-8,1],0],[[-1,5,-8,5,-1],1],[[],0],
[[-2,9,-12,9,-2],1],[[7,-12,7],3],[[2],17],[[2,-4,2],3],[[],0],[[],0],[[],0],
[[5,-33,85,-114,85,-33,5],0],[[1,-2,1],2],[[],0],[[1,-2,-23,94,-142,94,-23,-2,
1],0],[[-2,2,-2],22],[[-1,0,0,3,0,0,-1],10],[[-1,3,-1],10],[[1,-4,1],2],[[-1,
1,-2,1,-1],10],[[11,-63,151,-200,151,-63,11],0],[[-8,36,-58,36,-8],2],[[1],5],
[[4,-21,55,-76,55,-21,4],0],[[],0],[[],0],[[],0],[[-1575,1575],0],[[70,-405,
378,-210,0,0,210,-378,405,-70],27],[[-405,1170,-1170,405],0],[[-3,3,0,116,
-308,207,278,-278,-207,308,-116,0,-3,3],0],[[-105,390,-390,105],0],[[5,-4,-15,
35,-70,96,-96,70,-35,15,4,-5],10],[[21,-65,6,205,-205,-6,65,-21],3],[[-3,3,72,
-215,215,-72,-3,3],0],[[-3,14,-6,6,-14,3],14],[[6,-3,-12,12,3,-6],8],[[-30,
155,-310,310,-155,30],0],[[-255,780,-780,255],0],[[1,0,0,-5,-4,-1,0,0,1,4,5,0,
0,-1],9],[[-3,8,-26,24,20,-20,-24,26,-8,3],8],[[7,6,-6,-7],9],[[-69,330,-636,
636,-330,69],0],[[-3,32,-72,72,-32,3],0],[[-46,213,-421,421,-213,46],0],[[3,
-3,-6,6,3,-3],9],[[-2,1,6,-6,-1,2],10],[[1,-6,24,-24,6,-1],4],[[-1,14,-35,35,
-14,1],0],[[12,-34,34,-12],6],[[3,-14,14,-3],1],[[-1,0,3,-13,13,-3,0,1],4],
[[-1,0,0,1],7],[[1,-1],3],[[-9,53,-118,118,-53,9],0],[[-2,2],7],[[6,-20,24,24,
-101,101,-24,-24,20,-6],3],[[15,-58,58,-15],2],[[-20,101,-204,204,-101,20],0],
[[4,-11,11,-4],7],[[3,-14,31,-31,14,-3],2],[[],0],[[-1,2,-2,1],2],[[-1,1],5],
[[1,-3,6,-6,3,-1],1],[[1,-1],4],[[-1,3,-3,1],3],[[1,-1],3],[[-1,7,-18,30,-30,
18,-7,1],0],[[2,-2],4],[[1,-4,6,-6,4,-1],1],[[-1,2,-2,1],4],[[-2,14,-39,63,
-63,39,-14,2],0],[[1,-1],6]],[[[2100],0],[[2100],66],[[2,0,0,-112,180,0,-94,0,
378,-336,0,0,34],0],[[405,-1080,615],0],[[15,0,20,0,180,-504,300,0,-55,0,-39,
-20,45,0,10,-12],10],[[20],33],[[60,-412,834,-636,158],0],[[270,-675,480],0],
[[64,0,0,10,0,-24,64,-45,0,0,0,6],31],[[-60],44],[[-60],22],[[-8,0,0,7,0,12,
-56,36,0,6,0,-3],9],[[-18,36,-24],22],[[22,-166,381,-316,82],0],[[-5,20,-36,
32,-8],22],[[2,0,-60,162,-126,0,34],0],[[2,0,0,26,-18,0,2],33],[[2,-3,-4,4,
-10,-6,18,-1,-4],5],[[16,-123,284,-254,73],0],[[-1,14,-23,-1,30,-19,-63,90,
-29,0,-3,1],3],[[],0],[[-4,38,-96,93,-34,3],1],[[5,-45,120,-120,40],0],[[],0],
[[],0],[[],0],[[2,-4,41,-98,67,28,21,-194,175,-44,10,-11,2],2],[[2,-28,71,-84,
34],0],[[-1,8,-10,12,-5],22],[[37,-262,561,-449,116],0],[[2,-6,3,12,-15,-6,21,
-8],4],[[-4],11],[[-9,4,8,-6,1],6],[[2,-7,12,-16,8,-1],23],[[-4,2,-5,2,11,-5],
6],[[-1,17,-51,56,-22,2],1],[[1,-30,166,-334,302,-118,16],0],[[5,-18,20,-2,
-2],4],[[-1,2,-2],11],[[-1,15,-44,47,-18,2],1],[[4,-16,18,-6],2],[[],0],[[4,
-17,22,-10,1],2],[[3,-10,12,-5],3],[[1,-1],18],[[1,-5,7,-3],3],[[],0],[[],0],
[[],0],[[-6,47,-113,112,-46,6],1],[[-4,6,-2],3],[[],0],[[-1,38,-94,80,-11,-11,
2],2],[[2,-1,2],25],[[-1,0,0,2,0,0,-1],11],[[-1,2,-1],11],[[-1,2,-1],3],[[-1,
1,0,1,-1],11],[[-12,79,-178,167,-65,8],1],[[-1,15,-43,43,-13,-3,1],2],[[],0],
[[-3,30,-79,79,-30,3],1],[[],0],[[],0],[[],0],[[-945,1155],0],[[336,0,0,84,0,
189,-315,0,-189,210,0,0,-105],30],[[-163,726,-894,317],0],[[2,0,36,-139,117,
24,-70,-189,369,-156,0,-21,13],1],[[-50,220,-320,160],0],[[5,0,4,0,76,-121,50,
16,-19,8,-9,0,0,-1,1],11],[[7,-27,9,26,-33,-9,105,-72,0,0,4],3],[[2,21,-111,
153,-63,-21,13],1],[[1,-3,3,-4,-3],18],[[3,-3,0,4,-3,-3,4],9],[[-4,57,-204,
287,-166,32],0],[[-105,465,-615,240],0],[[-5,35,-60,26,0,-11,0,0,-1,0,1],14],
[[-8,0,-4,3,-6,38,-45,15,-4,2,3],10],[[-6,3,-9,3,3],10],[[-11,127,-411,532,
-290,54],0],[[11,-49,86,-60,13],1],[[-6,78,-273,370,-203,37],0],[[-3,5,-3,6,
-6,2,2],10],[[-1,2,-3,2,-1,3,-6,1,1],10],[[4,-7,-3,7,-3],6],[[5,-29,53,-34,6],
1],[[2,-2,4,-4,-6,8,-1],6],[[1,-10,21,-18,4],1],[[1,-2,-1,4,-3,-2,1],5],[[-1,
-2,1],9],[[3,-7,4],3],[[-1,19,-83,130,-81,16],0],[[1,-1,0,-1,1],6],[[-2,13,
-16,-5,22,13,-56,36,-5,2,-1],4],[[5,-29,51,-30,0,4],2],[[-2,34,-137,201,-115,
20],0],[[1,-1,0,5,-4,-3,3],6],[[-3,20,-33,19,-1,-1],3],[[-2,1],4],[[-2,2],4],
[[-2,2],6],[[-1,10,-19,12,-2],2],[[],0],[[3,-7,5,-1],4],[[],0],[[-5,29,-48,30,
-6],2],[[1,-3,2],4],[[7,-16,12,-2],3],[[3,-6,4],5],[[-13,55,-85,56,-14,1],2],
[[1,-2,1],6]],,[[[4200],0],[[4200],60],[[9,0,0,-256,603,0,-608,0,603,-256,0,0,9],
0],[[1060,-2080,1060],0],[[15,-20,-21,0,145,-240,585,-888,585,-240,145,0,-21,
-20,15],8],[[-40],30],[[278,-1048,1548,-1048,278],0],[[660,-1440,660],0],
[[-15,0,0,0,-90,0,0,0,-15],28],[[15],40],[[15],20],[[-6,-24,54,0,-60,0,54,-24,
-6],8],[[3,-18,3],20],[[114,-452,682,-452,114],0],[[-8,22,-8],21],[[9,0,-201,
408,-201,0,9],0],[[-3,0,27,-24,27,0,-3],30],[[-1,10,-16,-26,58,-26,-16,10,-1],
4],[[75,-330,510,-330,75],0],[[-15,64,-51,-118,240,-118,-51,64,-15],3],[[-4],
15],[[7,-40,97,-128,97,-40,7],0],[[20,-120,200,-120,20],0],[[],0],[[],0],[[],
0],[[3,-3,0,-48,196,-239,-11,212,-11,-239,196,-48,0,-3,3],0],[[9,-64,118,-64,
9],0],[[-4,7,-4],21],[[176,-692,1024,-692,176],0],[[-2,12,-8,-50,88,-50,-8,12,
-2],3],[[-1],10],[[2,18,-44,18,2],4],[[5,-14,5],22],[[2,3,-30,52,-30,3,2],4],
[[3,-15,41,-56,41,-15,3],0],[[31,-178,422,-552,422,-178,31],0],[[-2,19,-36,19,
-2],3],[[2],11],[[1,-11,33,-44,33,-11,1],0],[[-2,7,-10,7,-2],1],[[],0],[[-2,6,
-8,6,-2],1],[[-1,8,-14,8,-1],2],[[-1,0,2,0,-1],15],[[3,-6,3],3],[[],0],[[],0],
[[],0],[[6,-44,114,-152,114,-44,6],0],[[-1,2,-1],2],[[],0],[[3,-3,-36,133,
-194,133,-36,-3,3],0],[[1,-2,1],22],[[3],13],[[3],11],[[-2,4,-2],2],[[1,-2,1],
11],[[14,-84,203,-266,203,-84,14],0],[[-13,54,-82,54,-13],2],[[-1],5],[[4,-30,
75,-98,75,-30,4],0],[[],0],[[],0],[[],0],[[-2100,2100],0],[[-280,216,378,-714,
0,0,714,-378,-216,280],27],[[-540,1560,-1560,540],0],[[-6,3,0,136,-435,288,
304,-304,-288,435,-136,0,-3,6],0],[[-140,520,-520,140],0],[[5,0,-35,25,-50,
155,-155,50,-25,35,0,-5],10],[[26,-98,12,244,-244,-12,98,-26],3],[[-6,3,105,
-300,300,-105,-3,6],0],[[6,-6,6,-6],15],[[6,-4,-6,6,4,-6],8],[[-40,206,-414,
414,-206,40],0],[[-340,1040,-1040,340],0],[[1,0,0,-5,1,4,45,-45,-4,-1,5,0,0,
-1],9],[[3,13,-38,24,30,-30,-24,38,-13,-3],8],[[8,6,-6,-8],9],[[-92,438,-850,
850,-438,92],0],[[-6,37,-89,89,-37,6],0],[[-59,289,-559,559,-289,59],0],[[4,
-4,-9,9,4,-4],9],[[1,-3,-1,9,-9,1,3,-1],9],[[-1,-9,30,-30,9,1],4],[[-2,18,-47,
47,-18,2],0],[[-1,-1,17,-40,40,-17,1,1],4],[[3,-9,9,-3],1],[[-1,2,4,-15,15,-4,
-2,1],4],[[],0],[[-1,1,-1,1],2],[[-11,73,-156,156,-73,11],0],[[1,-3,3,-1],6],
[[6,-28,38,24,-118,118,-24,-38,28,-6],3],[[23,-85,85,-23],2],[[-27,135,-272,
272,-135,27],0],[[-1,3,4,-16,16,-4,-3,1],5],[[5,-23,43,-43,23,-5],2],[[-1,1],
3],[[1,-3,3,-1],2],[[],0],[[1,-5,8,-8,5,-1],1],[[-1,1],4],[[-2,4,-4,2],3],
[[-1,1],3],[[-1,9,-26,40,-40,26,-9,1],0],[[],0],[[1,-3,4,-4,3,-1],1],[[-2,6,
-6,2],4],[[-2,18,-53,85,-85,53,-18,2],0],[[3,-3],6]],[[[2240],0],[[2240],69],
[[-32,108,0,-360,0,540,-352,0,0,32],3],[[408,-1088,744],0],[[-60,150,-296,360,
-240,220,0,-78,-80,90,0,10,-12],13],[[],0],[[76,-400,792,-720,252],0],[[204,
-748,540],0],[[-20,0,-24,64,-30,0,0,0,6],35],[[-40],46],[[-40],23],[[-29,0,66,
-56,6,0,6,0,-3],12],[[-12,20,-18],23],[[20,-138,342,-358,136],0],[[-4,12,-18,
20,-8],23],[[-36,184,-180,0,32],2],[[],0],[[-4,30,-32,-14,28,-4,-4],7],[[9,
-91,256,-281,107],0],[[2,-4,-38,124,-93,-59,114,-48,0,-1,3],4],[[],0],[[-4,22,
-60,84,-60,18],1],[[-20,95,-130,50],1],[[-5],17],[[],0],[[],0],[[-4,21,-40,
-17,118,-35,-208,251,-92,2,-10,10],3],[[-8,60,-88,32],1],[[4,0,8,-4],24],[[39,
-237,524,-507,185],0],[[-1,-6,42,-46,-1,30,-14],5],[[],0],[[-13,22,-2,-6,1],
6],[[2,1,2,-7,6,-2],24],[[-3,23,-30,2,9,-5],6],[[-1,10,-28,44,-33,10],1],[[4,
-36,138,-274,306,-188,48],0],[[-8,16,-8,-2],5],[[],0],[[5,-21,35,-27,8],2],
[[-4,10,-9,3],3],[[],0],[[2,-8,14,-11,3],2],[[-6,14,-8],4],[[],0],[[-2,7,-3],
4],[[2],9],[[-1],16],[[-1],8],[[-4,28,-75,100,-69,19],1],[[-1,2,-2],3],[[],0],
[[-3,28,-86,104,-43,-10,10],2],[[-4,2,2],26],[[],0],[[],0],[[-1,2,-1],3],[[],
0],[[1,-12,57,-130,161,-106,29],0],[[7,-34,50,-25,-1,3],3],[[],0],[[-2,16,-47,
68,-49,15],1],[[1],15],[[],0],[[],0],[[-952,1288],0],[[210,-378,405,-105,0,0,
273,-189,0,120],33],[[-176,696,-936,432],0],[[16,-61,63,162,-198,-225,459,
-208,0,-12,20],3],[[-20,184,-360,180],0],[[-15,30,-66,55,-50,50,4,-24,-20,20,
0,1,-1],14],[[-5,3,90,-168,-3,141,-78,0,0,4],4],[[15,-99,181,-105,-12,20],2],
[[6,-15,9,3,-3],17],[[-3,9,0,-12,0,9,-3],10],[[-4,45,-161,263,-207,64],0],
[[-89,434,-654,315],0],[[-5,-15,6,-2,41,-19,-5,4,2,-1],15],[[13,-16,-30,60,
-35,3,-2,4,0,-3],12],[[-6,-6,12,-6],11],[[-17,125,-359,511,-371,109],0],[[4,
-31,69,-64,20],1],[[-9,71,-225,345,-263,81],0],[[-2,5,4,-13,9,-3],11],[[2,-6,
-1,7,-6,3,-1],12],[[5,-18,13,1,-4,1],6],[[-11,35,-38,12],2],[[1,-12,26,-18,-2,
7,-4],6],[[-3,15,-16,4],2],[[-3,13,-13,0,5,-2],7],[[1,0,-1],9],[[-1,2,-2,1],
4],[[9,-52,108,-95,31],1],[[3,-2],8],[[2,9,-46,77,-27,-53,62,-23,0,-1,2],5],
[[-17,57,-42,0,4],3],[[-2,25,-98,176,-147,48],0],[[-3,9,-5,-4,7,-2],8],[[-1,
11,-26,28,-11,-1,2],3],[[],0],[[1,-1,1,-1],3],[[],0],[[2,-6,9,-7,2],3],[[-1,
1],5],[[1,-4,5,-2],4],[[],0],[[-3,12,-26,31,-21,6],2],[[-2,2,-1],5],[[-1,3,-6,
8,-6,2],2],[[-2,4,-2],6],[[1,-8,30,-54,59,-36,9],1],[[-1,2],7]],,[[[4480],0],
[[4480],60],[[12,0,0,-320,612,0,-736,0,612,-320,0,0,12],0],[[1120,-2240,1120],
0],[[15,-20,-72,0,180,-240,645,-1016,645,-240,180,0,-72,-20,15],8],[[64],30],
[[280,-1120,1680,-1120,280],0],[[720,-1520,720],0],[[-30,64,-24,0,-100,0,-24,
64,-30],28],[[-44],40],[[-44],20],[[6,-32,48,0,-64,0,48,-32,6],8],[[-18,16,
-18],20],[[116,-488,748,-488,116],0],[[-7,16,-14,16,-7],20],[[12,0,-204,384,
-204,0,12],0],[[4,0,-36,64,-36,0,4],30],[[-1,8,-12,-32,74,-32,-12,8,-1],4],
[[80,-360,560,-360,80],0],[[-18,66,-54,-122,256,-122,-54,66,-18],3],[[],0],
[[6,-40,110,-152,110,-40,6],0],[[24,-136,224,-136,24],0],[[-1,0,4,0,-6,0,4,0,
-1],12],[[-5],24],[[-5],12],[[2,-4,2,-52,207,-259,-15,254,-15,-259,207,-52,2,
-4,2],0],[[12,-80,152,-80,12],0],[[-3,4,2,4,-3],20],[[180,-740,1120,-740,180],
0],[[-2,10,-4,-46,84,-46,-4,10,-2],3],[[4],10],[[-2,16,-24,16,-2],4],[[-1,4,
-1,0,-1,4,-1],20],[[2,-22,44,-22,2],5],[[2,-17,53,-78,53,-17,2],0],[[29,-180,
460,-618,460,-180,29],0],[[-2,15,-26,15,-2],3],[[1,-4,1],10],[[1,-12,40,-58,
40,-12,1],0],[[-2,10,-16,10,-2],1],[[],0],[[-3,16,-26,16,-3],1],[[-1,10,-18,
10,-1],2],[[],0],[[4,-10,4],3],[[-2],8],[[1],14],[[1],7],[[6,-46,130,-180,130,
-46,6],0],[[3,-6,3],2],[[-1],6],[[2,-4,-31,131,-196,131,-31,-4,2],0],[[2,-4,
2],22],[[1,0,0,-2,0,0,1],10],[[1,-2,1],10],[[2,-4,2],2],[[1,-1,0,-1,1],10],
[[13,-85,225,-306,225,-85,13],0],[[-12,52,-80,52,-12],2],[[],0],[[4,-30,86,
-120,86,-30,4],0],[[-1,2,-1],12],[[1],8],[[1],4],[[-2240,2240],0],[[315,-405,
378,-630,0,0,630,-378,405,-315],27],[[-560,1680,-1680,560],0],[[-6,6,0,160,
-466,306,368,-368,-306,466,-160,0,-6,6],0],[[-160,560,-560,160],0],[[9,-9,-35,
35,-70,182,-182,70,-35,35,9,-9],10],[[36,-96,12,256,-256,-12,96,-36],3],[[-6,
6,102,-294,294,-102,-6,6],0],[[-9,17,-6,6,-17,9],14],[[6,-5,-15,15,5,-6],8],
[[-40,220,-460,460,-220,40],0],[[-360,1120,-1120,360],0],[[-1,0,5,-5,-19,36,
-10,10,-36,19,5,-5,0,1],9],[[-3,19,-40,24,32,-32,-24,40,-19,3],8],[[-9,9,-9,
9],9],[[-90,460,-930,930,-460,90],0],[[-6,46,-116,116,-46,6],0],[[-58,302,
-618,618,-302,58],0],[[-3,8,-15,15,-8,3],9],[[2,-3,9,-9,3,-2],10],[[1,-9,20,
-20,9,-1],4],[[-2,22,-58,58,-22,2],0],[[-1,12,-33,33,-12,1],5],[[6,-26,26,-6],
1],[[-1,1,3,-15,15,-3,-1,1],4],[[-1,-1,1,1],7],[[-1,3,-3,1],2],[[-12,80,-180,
180,-80,12],0],[[-2,2],7],[[6,-28,40,20,-126,126,-20,-40,28,-6],3],[[24,-80,
80,-24],2],[[-26,144,-306,306,-144,26],0],[[1,5,-16,16,-5,-1],6],[[4,-21,44,
-44,21,-4],2],[[1,-1],3],[[-1,3,-3,1],2],[[2,-2],5],[[1,-6,13,-13,6,-1],1],
[[1,-1],4],[[-2,7,-7,2],3],[[],0],[[-1,8,-28,51,-51,28,-8,1],0],[[-1,3,-3,1],
3],[[1,-6,14,-14,6,-1],1],[[-1,4,-4,1],4],[[-2,17,-58,103,-103,58,-17,2],0],
[[1,-1],6]],[[[2268],0],[[2268],70],[[-48,126,0,-258,0,522,-432,0,0,54],3],
[[381,-1128,759],0],[[45,0,120,-424,315,-60,115,0,-141,-60,105,0,20,-24,0,0,0,
0,1],12],[[-36],35],[[54,-372,846,-756,240],0],[[216,-729,594],0],[[81],34],
[[],0],[[],0],[[-3,0,36,-72,36,0,12,0,-9],12],[[],0],[[15,-132,372,-390,135],
0],[[],0],[[-42,150,-174,0,54],2],[[18,-42,18,0,-6],37],[[-1,-2,23,-22,-10,26,
-3,-8,0,0,1],6],[[8,-91,278,-316,117],0],[[2,-9,-15,71,-61,-73,137,-55,0,-5,
4],4],[[],0],[[-2,23,-80,108,-62,13],1],[[1,-25,110,-154,66],0],[[1,0,0,0,0,0,
-4,0,1],14],[[3],28],[[3],14],[[21,-60,33,84,-24,-231,270,-84,9,-18,9],4],
[[-12,75,-108,54],1],[[],0],[[28,-225,559,-546,181],0],[[-2,0,18,-37,-2,37,
-18,0,0,1],5],[[],0],[[-3,12,0,-12,3],6],[[],0],[[9,-15,3,15,-12],7],[[9,-45,
66,-39,9],2],[[1,-22,131,-314,351,-186,39],0],[[-10,19,-6,-4,0,1],5],[[],0],
[[7,-34,54,-34,7],2],[[1,-10,20,-13,2],2],[[],0],[[2,-17,29,-18,4],2],[[1,-7,
16,-11,0,1],3],[[-1,1],19],[[-3,9,-6],4],[[],0],[[],0],[[],0],[[-2,30,-98,132,
-77,17],1],[[-4,9,-4,1],3],[[-1],7],[[-3,24,-81,99,-33,-18,9],2],[[-3],26],
[[],0],[[],0],[[-3,6,-3],3],[[],0],[[-7,56,-159,195,-109,23],1],[[7,-33,52,
-26,-5,4],3],[[],0],[[-1,18,-64,92,-55,11],1],[[1,-1,1],14],[[],0],[[],0],
[[-945,1323],0],[[420,0,405,-595,0,-189,378,0,0,15,0,0,-56],33],[[-147,702,
-990,429],0],[[12,-81,81,96,-162,-225,501,-228,0,-27,27],3],[[-26,190,-374,
220],0],[[10,0,51,-116,50,-5,36,13,-37,-10,15,-1,5,-1],13],[[1,-7,7,53,-101,
-7,150,-111,0,0,9],3],[[15,-87,165,-99,-27,27],2],[[-11,9,3,-4,-3],18],[[-6,3,
4,-9,-3,8,-3],10],[[-2,38,-173,306,-229,62],0],[[-81,435,-693,330],0],[[5,0,0,
-19,10,0,10,-5,-15,5,1,0,-1],13],[[1,-2,-12,56,-61,15,-6,6,6,-3],12],[[-3,-1,
9,-3,-2],11],[[-9,102,-372,570,-387,99],0],[[3,-39,96,-84,27],1],[[-4,59,-237,
391,-281,72],0],[[4,0,-9,7,-1,-1],12],[[-1,2,4,-10,5],13],[[1,-6,7,5,-8,1],6],
[[1,-17,52,-51,15],1],[[-3,11,-11,-6,14,-5],7],[[-7,27,-27,9],2],[[-1,1,7,-10,
-1,7,-1],6],[[1,0,1],9],[[1,-5,6,-2],3],[[9,-62,135,-117,33],1],[[-3,1],9],
[[3,-5,-19,49,-10,-71,68,-18,2,-3,1],5],[[1,-17,52,-48,0,9],2],[[-1,21,-109,
210,-164,44],0],[[-1,8,-7,-4,5],8],[[-1,11,-29,29,-8,-3,1],3],[[-2,2],4],[[1,
-5,5,-1],3],[[-2,2],6],[[5,-16,17,-7,1],3],[[-1,1],5],[[1,-6,8,-3],4],[[-1,1],
4],[[-2,18,-43,42,-18,3],2],[[1,-3,4,-2],4],[[5,-17,17,-7,1],3],[[-4,5,-1,-1],
6],[[-6,39,-81,76,-33,6],2],[[2,-1],8]],,[[[4536],0],
[[4536],60],[[15,0,0,-384,621,0,-576,0,621,-384,0,0,15],0],[[1116,-2304,1116],
0],[[30,-20,-51,0,105,-120,600,-1160,600,-120,105,0,-51,-20,30],8],[[-24],30],
[[258,-1128,1764,-1128,258],0],[[756,-1512,756],0],[[15,-64,84,0,-70,0,84,-64,
15],28],[[81],40],[[81],20],[[15,-40,30,0,-10,0,30,-40,15],8],[[27,-54,27],
20],[[108,-504,792,-504,108],0],[[9,-36,54,-36,9],20],[[15,0,-207,360,-207,0,
15],0],[[-1,0,9,-40,9,0,-1],30],[[-2,10,-10,-26,64,-26,-10,10,-2],4],[[81,
-378,594,-378,81],0],[[-18,78,-69,-84,186,-84,-69,78,-18],3],[[-4],15],[[3,
-36,123,-180,123,-36,3],0],[[30,-150,246,-150,30],0],[[6],16],[[1],24],[[1],
12],[[1,-5,4,-40,218,-295,21,192,21,-295,218,-40,4,-5,1],0],[[15,-96,162,-96,
15],0],[[3,-12,27,-12,3],20],[[168,-756,1176,-756,168],0],[[-2,14,-8,-32,56,
-32,-8,14,-2],3],[[-3],10],[[-1,10,-18,10,-1],4],[[1,-6,18,-26,18,-6,1],20],
[[1,1,-16,28,-16,1,1],4],[[1,-15,63,-98,63,-15,1],0],[[22,-164,482,-680,482,
-164,22],0],[[-2,18,-32,18,-2],3],[[-1,2,-1],10],[[1,-13,50,-76,50,-13,1],0],
[[-3,15,-24,15,-3],1],[[],0],[[-3,21,-36,21,-3],1],[[-2,12,-20,12,-2],2],[[-1,
0,2,0,-1],15],[[5,-10,5],3],[[],0],[[],0],[[],0],[[5,-45,146,-214,146,-45,5],
0],[[4,-10,4],2],[[1],6],[[1,-5,-26,129,-198,129,-26,-5,1],0],[[3,-6,3],22],
[[-1,0,0,-1,0,0,-1],10],[[-1,-1,-1],10],[[3,-6,3],2],[[-1,0,2,0,-1],10],[[9,
-78,243,-348,243,-78,9],0],[[-12,54,-84,54,-12],2],[[-1],5],[[2,-29,99,-144,
99,-29,2],0],[[],0],[[1],8],[[1],4],[[-2268,2268],0],[[595,-405,0,-84,0,0,84,
0,405,-595],27],[[-540,1728,-1728,540],0],[[-6,9,0,168,-513,324,288,-288,-324,
513,-168,0,-9,6],0],[[-180,576,-576,180],0],[[4,-9,-5,5,-45,218,-218,45,-5,5,
9,-4],10],[[48,-108,18,186,-186,-18,108,-48],3],[[-6,9,99,-288,288,-99,-9,6],
0],[[-9,11,0,0,-11,9],14],[[3,-4,-15,15,4,-3],8],[[-36,222,-498,498,-222,36],
0],[[-360,1152,-1152,360],0],[[36,-36],15],[[-3,28,-42,12,5,-5,-12,42,-28,3],
8],[[1,-3,3,-1],9],[[-78,450,-984,984,-450,78],0],[[-6,51,-135,135,-51,6],0],
[[-48,300,-660,660,-300,48],0],[[1,-2,1,-1,2,-1],9],[[1,-1,0,-2,2,0,1,-1],9],
[[1,-6,13,-13,6,-1],4],[[-3,27,-72,72,-27,3],0],[[9,-21,21,-9],6],[[9,-33,33,
-9],1],[[-1,2,4,-9,9,-4,-2,1],4],[[-1,-1,1,1],7],[[-2,6,-6,2],2],[[-12,87,
-204,204,-87,12],0],[[1,0,0,-1],6],[[2,-28,53,1,-90,90,-1,-53,28,-2],3],[[27,
-81,81,-27],2],[[-21,147,-336,336,-147,21],0],[[-1,2,4,-15,15,-4,-2,1],5],[[3,
-21,48,-48,21,-3],2],[[2,-2],3],[[-1,5,-5,1],2],[[2,-2],5],[[1,-8,21,-21,8,
-1],1],[[1,-1],4],[[-2,8,-8,2],3],[[1,-1],3],[[5,-30,66,-66,30,-5],1],[[-1,4,
-4,1],3],[[-7,21,-21,7],2],[[-2,6,-6,2],4],[[-1,13,-61,127,-127,61,-13,1],0],
[[1,-1],6]],[[[2835],0],[[2835],64],[[-96,279,0,-480,0,531,-288,0,0,9],3],
[[627,-1392,816],0],[[60,-120,315,-480,435,-300,180,0,-24,-60,45],12],[[-45],
32],[[150,-612,1026,-804,243],0],[[351,-972,540],0],[[-81],32],[[],0],[[],0],
[[18,0,-48,0,54,-24],10],[[],0],[[48,-246,447,-366,117],0],[[],0],[[-93,264,
-177,0,9],2],[[27,-48,27,0,-3],34],[[-4,-12,50,-32,-12,16,-3],6],[[28,-170,
334,-278,81],0],[[-3,18,-17,-79,175,-103,-49,79,-26],3],[[3],16],[[1,-14,45,
-80,82,-46,11],0],[[5,-50,130,-110,30],0],[[5],16],[[],0],[[],0],[[-12,81,
-111,-36,162,-30,-204,213,-72,0,-3,3],3],[[-24,78,-72,9],1],[[],0],[[86,-387,
680,-543,167],0],[[3,-4,-24,62,-42,-4,18,-6],4],[[],0],[[6,-24,18],5],[[],0],
[[-12,36,-27,0,3],6],[[-3,18,-36,39,-21,3],1],[[15,-82,228,-360,332,-170,37],
0],[[6,-18,18,-6],4],[[],0],[[-3,12,-27,30,-16,4],1],[[2,-5,7,-5,1],2],[[],0],
[[2,-8,9,-4],2],[[2,-8,8,-3],3],[[-2,0,1],18],[[-3,3],4],[[],0],[[],0],[[],0],
[[2,-15,53,-97,97,-50,11],0],[[1],4],[[],0],[[-15,69,-120,108,-39,-3,3],2],
[[3],24],[[],0],[[],0],[[],0],[[],0],[[5,-34,102,-171,166,-87,20],0],[[-3,22,
-49,47,-16],2],[[],0],[[1,-9,33,-62,64,-36,8],0],[[-1],14],[[],0],[[],0],
[[-1323,1512],0],[[-210,0,0,210,0,189,-105,0,0,105],30],[[-303,972,-1116,444],
0],[[48,-192,135,234,-246,-234,417,-168,0,-3,6],3],[[-55,296,-400,140],0],[[5,
-25,65,-85,60,-55,30,0,-9,-10,5],13],[[5,-29,8,160,-205,-8,108,-42],3],[[48,
-171,216,-99,-3,6],2],[[-6,6,-9,9,0,-3],16],[[-3,-6,9,3,-9,0,3],9],[[-15,97,
-240,304,-188,47],0],[[-171,636,-756,300],0],[[-5,0,15,4,-10,1,-11,20,-5,0,-1,
1],12],[[-12,6,28,-20,-24,38,-16],10],[[6,-6,-6,6],10],[[-45,228,-516,609,
-372,93],0],[[12,-48,72,-45,6],1],[[-26,142,-333,404,-253,66],0],[[1,-8,7,3,
-6,3],10],[[6,-8,-1,3,-1,1],12],[[-4,14,-20,10],5],[[5,-22,35,-24,6],1],[[7,
-23,30,-15,-1,2],6],[[-5,12,-6],2],[[1,3,-8,10,-5,-1,2,-1],5],[[1,1,-1],9],
[[-1,1,-1],4],[[-3,27,-85,117,-75,18],0],[[-1],7],[[1,-7,12,24,-82,91,-26,-39,
41,-12],3],[[5,-40,65,-27],2],[[-8,60,-155,198,-130,34],0],[[2,-10,13,-7,-1,3,
-1],7],[[1,-8,21,-30,23,-7],2],[[],0],[[],0],[[],0],[[-1,3,-6,6,-3,1],2],[[],
0],[[1,-3,2],4],[[],0],[[2,-8,20,-29,26,-13,3],1],[[1],6],[[3,-5,5,-2],3],[[2,
-3,3,-1],5],[[-1,5,-20,45,-62,51,-24,5],0],[[-1],7]],,[[[5670],0],[[5670],60],[[21,0,0,-480,756,0,-684,0,756,-480,0,0,21],0],
[[1395,-2880,1395],0],[[30,-20,-75,0,70,-180,810,-1360,810,-180,70,0,-75,-20,
30],8],[[6],30],[[321,-1416,2196,-1416,321],0],[[945,-1890,945],0],[[-15,64,
-84,0,70,0,-84,64,-15],28],[[-81],40],[[-81],20],[[21,-56,42,0,-14,0,42,-56,
21],8],[[-27,54,-27],20],[[135,-630,990,-630,135],0],[[-9,36,-54,36,-9],20],
[[21,0,-252,468,-252,0,21],0],[[1,0,0,4,0,0,1],30],[[-2,14,-11,-32,68,-32,-11,
14,-2],4],[[102,-471,744,-471,102],0],[[-25,94,-85,-100,238,-100,-85,94,-25],
3],[[-2],15],[[4,-46,153,-224,153,-46,4],0],[[36,-189,306,-189,36],0],[[1,0,
-4,0,6,0,-4,0,1],12],[[5],24],[[5],12],[[2,-7,5,-56,259,-356,39,228,39,-356,
259,-56,5,-7,2],0],[[21,-120,198,-120,21],0],[[-3,12,-27,12,-3],20],[[210,
-945,1470,-945,210],0],[[-2,16,-10,-42,76,-42,-10,16,-2],3],[[3],10],[[1,14,
-30,14,1],4],[[-1,6,-18,26,-18,6,-1],20],[[2,2,-23,38,-23,2,2],4],[[2,-21,78,
-118,78,-21,2],0],[[26,-208,604,-844,604,-208,26],0],[[-2,22,-40,22,-2],3],
[[1,-2,1],10],[[1,-16,62,-94,62,-16,1],0],[[-3,18,-30,18,-3],1],[[],0],[[-5,
25,-42,25,-5],1],[[-2,15,-28,15,-2],2],[[-1,0,0,0,-1],15],[[7,-14,7],3],[[],
0],[[],0],[[],0],[[6,-57,183,-264,183,-57,6],0],[[5,-10,5],2],[[1],6],[[2,-7,
-28,162,-258,162,-28,-7,2],0],[[-3,6,-3],22],[[1,0,0,1,0,0,1],10],[[1,1,1],
10],[[3,-6,3],2],[[1,0,-2,0,1],10],[[11,-99,304,-432,304,-99,11],0],[[-14,69,
-110,69,-14],2],[[1],5],[[3,-36,123,-180,123,-36,3],0],[[1,-2,1],12],[[-1],8],
[[-1],4],[[-2835,2835],0],[[595,-594,378,-84,0,0,84,-378,594,-595],27],[[-675,
2160,-2160,675],0],[[-9,12,0,216,-615,405,342,-342,-405,615,-216,0,-12,9],0],
[[-225,720,-720,225],0],[[9,-13,-5,5,-80,253,-253,80,-5,5,13,-9],10],[[60,
-135,18,228,-228,-18,135,-60],3],[[-9,12,117,-369,369,-117,-12,9],0],[[-12,11,
0,0,-11,12],14],[[6,-4,-15,15,4,-6],8],[[-45,279,-621,621,-279,45],0],[[-450,
1440,-1440,450],0],[[-9,0,45,-45,0,9],13],[[-9,36,-50,24,7,-7,-24,50,-36,9],
8],[[1,-3,3,-1],9],[[-96,567,-1227,1227,-567,96],0],[[-9,66,-165,165,-66,9],
0],[[-60,375,-825,825,-375,60],0],[[1,-2,1,-1,2,-1],9],[[1,-1,0,-2,2,0,1,-1],
9],[[-1,-6,23,-23,6,1],4],[[-3,33,-90,90,-33,3],0],[[-1,0,11,-32,32,-11,0,1],
4],[[12,-39,39,-12],1],[[-1,3,4,-17,17,-4,-3,1],4],[[-1,1],8],[[-2,7,-7,2],2],
[[-15,108,-255,255,-108,15],0],[[1,-3,3,-1],6],[[5,-34,63,-4,-116,116,4,-63,
34,-5],3],[[33,-105,105,-33],2],[[-27,183,-420,420,-183,27],0],[[-1,2,4,-17,
17,-4,-2,1],5],[[3,-26,63,-63,26,-3],2],[[2,-2],3],[[-1,5,-5,1],2],[[2,-2],5],
[[1,-10,25,-25,10,-1],1],[[1,-1],4],[[-3,11,-11,3],3],[[1,-1],3],[[7,-38,81,
-81,38,-7],1],[[-1,5,-5,1],3],[[1,-9,24,-24,9,-1],1],[[-2,8,-8,2],4],[[-1,17,
-78,156,-156,78,-17,1],0],[[3,-3],6]],[[[3200],0],[[3200],63],[[-160,360,0,
-384,0,576,-288,0,0,24],3],[[720,-1600,880],0],[[-20,0,0,30,-120,330,-680,510,
-120,80,0,-30,-20,30,0,10],9],[[],0],[[152,-736,1200,-864,248],0],[[440,-1080,
600],0],[[15,0,0,0,10,0,-60,0,15,0,-20],29],[[-40],42],[[-40],21],[[-3,0,18,0,
-20,0,66,-48,-3,0,4],8],[[-10,36,-12],21],[[64,-292,532,-412,104],0],[[-2,20,
-38,20,-4],21],[[-120,288,-192,0,24],2],[[],0],[[4,-6,-12,40,-24,-18,16],5],
[[38,-214,400,-306,82],0],[[-4,28,-36,-49,149,-88,-61,84,-23,0,-1,1],3],[[],
0],[[2,-20,66,-108,94,-40,6],0],[[10,-70,160,-130,30],0],[[],0],[[],0],[[],0],
[[-28,97,-145,41,132,-8,-242,208,-44,3,-9,3],3],[[-40,96,-72,24],1],[[8,-12,
12],22],[[96,-468,800,-592,164],0],[[-2,6,-6,-14,52,-46,-6,18,-2],3],[[],0],
[[1,6,-24,22,1,-4],4],[[2,-12,18,-10,4],22],[[1,0,-13,28,-29,6,5,-2],4],[[-7,
30,-51,41,-20,3],1],[[10,-96,300,-442,360,-164,32],0],[[-2,12,-26,20,-2,-2],
3],[[],0],[[-5,23,-42,37,-15,2],1],[[-1,5,-11,11,-3],1],[[1],9],[[6,-11,9,-5,
1],2],[[2,-12,14,-4],3],[[],0],[[-5,6,-2],4],[[-1],7],[[-1],14],[[-1],7],[[1,
-21,81,-130,109,-49,9],0],[[],0],[[],0],[[-15,75,-147,126,-33,-9,3],2],[[-1,2,
-1],23],[[],0],[[],0],[[-1,2,-1],2],[[],0],[[4,-43,142,-219,183,-82,15],0],
[[-4,30,-63,55,-18,-1,1],2],[[],0],[[1,-14,52,-86,74,-32,5],0],[[],0],[[],0],
[[],0],[[-1520,1680],0],[[216,0,-105,0,0,168,-378,0,280,0,-189,168],28],
[[-336,1152,-1248,464],0],[[80,-242,198,172,-212,-270,450,-144,0,-12,12],3],
[[-80,360,-440,160],0],[[-5,15,-40,105,-131,40,0,11,9,-4,0,0,-1,1],12],[[10,
-52,12,132,-166,-12,118,-44,0,0,2],3],[[54,-198,246,-102,-12,12],2],[[3,0,-6,
0,3],16],[[3,-3,-6,3,10,-6,-3,2],8],[[-16,124,-308,352,-196,44],0],[[-210,740,
-860,310],0],[[-1,0,0,0,-10,36,-70,21,4,5,0,-5,-1,1],10],[[-3,-6,12,6,-14,-30,
60,-24,-3,-2,2],9],[[-6,6,-8,6],10],[[-41,276,-637,693,-384,89],0],[[20,-70,
82,-48,12],1],[[-27,175,-415,469,-261,57],0],[[-2,4,-5,9,-10,2],10],[[-1,0,-2,
8,-3],12],[[-1,14,-24,12,3,-2],5],[[-1,9,-33,51,-27,3],0],[[1,5,-19,30,-19,1,
4,-1],5],[[-8,14,-8,2],2],[[-1,2,-5,-3,15,-8,-1,1],4],[[1,0,-1],8],[[-1,2,-2,
1],2],[[-4,40,-116,144,-80,16],0],[[3,-4,1],8],[[1,-9,21,-7,-57,88,-19,-48,38,
-7,0,-1],3],[[10,-52,74,-34,0,2],2],[[-12,78,-198,240,-134,26],0],[[3,-8,14,
-6,-5,2],7],[[1,-10,30,-40,26,-6,-1],2],[[1,-1],4],[[-1,2,-1],3],[[],0],[[-4,
9,-10,6,-2],2],[[-1],4],[[3,-5,4,-1],4],[[1],4],[[3,-17,35,-38,25,-9,1],1],
[[-2,2],5],[[-3,7,-5,3,-2],2],[[-1,4,-6,3],4],[[6,-35,72,-77,51,-20,3],1],[[1,
-3,2],6]],,[[[4096],0],[[4096],
135,false],[[-128,288,0,-448,0,864,-640,0,0,64],3],[[768,-2048,1280],0],[[10,
-60,330,-744,630,-180,110,0,-132,-80,120,0,20,-24],12],[[],0],[[128,-768,1536,
-1280,384],0],[[448,-1344,960],0],[[60,0,0,0,-10,0,0,0,84,0,-64,0,0,0,0,0,0,0,
0,0,-6],65,false],[[64],45],[[64],45,false],[[6,0,-10,0,66,-112,36,0,12,0,-6],
10],[[16,0,-48,0,24],45,false],[[40,-288,680,-640,200],0],[[4,0,-24,0,44,0,
-40,0,8],45,false],[[-96,320,-288,0,64],2],[[],0],[[-2,-8,40,-40,-18,40,-4,
-8],6],[[24,-200,512,-504,168],0],[[-1,12,-24,-36,152,-104,-116,188,-71,0,-4,
4],3],[[],0],[[-8,56,-144,168,-88,16],1],[[4,-60,204,-236,84],0],[[-1,0,0,0,0,
0,0,0,-6,0,0,0,4,0,0,0,-1],27,false],[[-4],27],[[-4],27,false],[[-8,58,-130,
50,144,-12,-376,396,-120,10,-22,10],3],[[-32,128,-160,64],1],[[-8,0,20,0,-16,
0,4],47,false],[[72,-472,1024,-904,280],0],[[2,-6,-6,48,-58,-6,46,-20],4],[[],
0],[[2,-18,22,4,-12,2],5],[[-2,0,9,0,-20,0,22,0,-10,0,1],47,false],[[-7,24,
-29,4,18,-10],6],[[-2,24,-74,94,-52,10],1],[[4,-64,288,-572,576,-288,56],0],
[[4,-24,32,-8,-4],4],[[],0],[[-1,18,-60,78,-43,8],1],[[3,-17,27,-14,2],2],
[[1],21,false],[[5,-24,35,-20,4],2],[[2,-16,26,-12],3],[[],0],[[-7,14,-6],4],
[[1],15,false],[[1],15],[[1],15,false],[[-10,70,-176,202,-108,22],1],[[-4,8,
-4],3],[[],0],[[-6,62,-170,176,-50,-22,10],2],[[-2,0,4,0,-2],51,false],[[],0],
[[],0],[[-2,4,-2],3],[[],0],[[1,-23,129,-288,311,-161,31],0],[[-1,20,-72,88,
-35,-4,4],2],[[],0],[[-5,43,-117,139,-75,14],1],[[-1,0,1,0,-1],27,false],
[[-1],9],[[-1],9,false],[[-1792,2304],0],[[512,0,0,84,0,-378,0,594,0,-315,0,0,
0,-189,0,378,0,-189,0,0,0,15],63,false],[[-320,1344,-1728,704],0],[[48,-188,
180,184,-264,-396,772,-336,0,-32,32],3],[[-64,384,-640,320],0],[[-15,96,-172,
95,-10,21,17,-37,-10,15,-1,2,-1],14],[[4,-28,12,116,-188,-12,228,-140,0,0,8],
3],[[36,-196,316,-156,-32,32],2],[[-11,12,6,-4,-3],18],[[-6,9,8,-15,-3,10,-3],
10],[[-8,96,-344,520,-352,88],0],[[-184,848,-1200,520],0],[[-5,0,0,0,5,19,-16,
-50,5,31,0,4,-5,10,0,-14,0,-5,0,4,0,1],25,false],[[6,3,-7,-30,92,-74,18,-6,6,
3,-3],11],[[8,3,0,-9,0,9,0,-3],21,false],[[-26,240,-726,986,-624,150],0],[[12,
-76,148,-116,32],1],[[-14,142,-470,674,-442,106],0],[[2,1,-8,-2,2,7,0,-13,0,8,
0,-1],21,false],[[-2,0,4,2,-2,-1,0,7,0,-11,0,3],23,false],[[9,-21,10,8,-7,1],
6],[[4,-36,84,-68,16],1],[[2,-14,28,-18,-7,14,-5],6],[[-12,36,-32,8],2],[[1,
-2,-4,17,-15,-2,6,-1],5],[[1,-2,1],9],[[2,-6,6,-2],3],[[-1,26,-126,226,-166,
43],0],[[-1,2,3,0,-3,0,1],14,false],[[-2,11,-8,-51,97,-12,-101,90,-23,1,-3,1],
4],[[4,-44,100,-68,0,8],2],[[-4,56,-220,356,-248,60],0],[[-5,15,-10,-6,7,-1],
8],[[-4,28,-56,45,-11,-3,1],3],[[-1,1],4],[[1,-3,3,-1],3],[[-2,2],6],[[-1,10,
-22,21,-8,1],2],[[1,-1,0,1],9,false],[[3,-11,10,-3],4],[[-1],7,false],[[-8,37,
-67,59,-24,3],2],[[1,-5,5,-1],4],[[-1,9,-20,19,-8,1],2],[[2,-8,7,-1],5],[[1,
-21,78,-130,110,-46,7],1],[[-1,-3,0,3],13,false]],,[[[4200],0],[[4200],66],[[-128,342,0,
-596,0,864,-544,0,0,38],3],[[850,-2080,1270],0],[[55,-120,375,-752,645,-300,
230,0,-111,-80,105,0,5,-12],12],[[40],33],[[172,-840,1548,-1256,384],0],[[480,
-1410,900],0],[[-60,0,90,0,-60],32],[[-30],44],[[-30],22],[[12,0,-33,0,84,-72,
18,0,6],10],[[-6,30,-9],22],[[53,-324,679,-604,193],0],[[-1,12,-32,20,-2],22],
[[-114,356,-288,0,38],2],[[-18,44,-36,0,2],35],[[-3,-14,56,-44,-23,30,-6,-4],
6],[[31,-223,510,-467,149],0],[[-2,17,-23,-71,210,-136,-98,158,-56,0,-1,2],3],
[[],0],[[1,-12,62,-132,146,-82,17],0],[[5,-65,200,-205,65],0],[[],0],[[],0],
[[],0],[[-12,80,-145,2,196,-35,-352,373,-112,3,-13,9],3],[[-32,124,-136,38],
1],[[4,-17,8,-1],23],[[96,-524,1026,-872,272],0],[[2,-6,-17,70,-69,-6,38,-14],
4],[[-2],11],[[4,-25,28,2,-6],5],[[-8,20,-13,4],24],[[-10,39,-38,3,12,-3],6],
[[-3,25,-64,77,-41,9],1],[[10,-92,313,-558,545,-276,59],0],[[4,-26,32,-8,-1],
4],[[-1,2],11],[[-2,18,-50,61,-35,7],1],[[3,-12,18,-11,2],2],[[],0],[[4,-18,
24,-12,2],2],[[3,-14,19,-8],3],[[],0],[[-6,9,-3],4],[[],0],[[],0],[[],0],[[1,
-15,74,-161,175,-94,20],0],[[-2,4,-2],3],[[],0],[[-12,81,-177,170,-60,-13,9],
2],[[2,-4],25],[[-1,0,0,-1],14],[[-1,-1],12],[[-1,2],3],[[2,0,-1],13],[[3,-35,
140,-273,283,-150,32],0],[[-2,26,-73,80,-32,-1,2],2],[[],0],[[-9,46,-104,119,
-66,14],1],[[],0],[[],0],[[],0],[[-1890,2310],0],[[630,-378,189,-315,0,0,483,
-189],33],[[-382,1404,-1716,698],0],[[56,-225,189,266,-330,-387,725,-296,0,
-16,22],3],[[-70,410,-630,270],0],[[-10,5,-15,96,-161,80,-40,45,9,-33,-10,15,
0,0,-1],12],[[5,-32,12,174,-255,-12,203,-102,0,0,3],3],[[51,-225,323,-159,-16,
22],2],[[6,-17,9,3,-5],17],[[3,-6,12,9,-15,0,4,-3],9],[[-14,116,-354,490,-324,
82],0],[[-215,900,-1180,495],0],[[5,0,4,-25,11,-12,30,-9,-5,-1,2],13],[[-6,6,
12,-21,-36,80,-49,9,-2,4],10],[[-9,-9,15],11],[[-43,288,-750,959,-600,150],0],
[[14,-73,131,-90,22],1],[[-23,176,-483,646,-419,106],0],[[-2,8,5,-15,7],11],
[[2,-5,1,7,-6,2],12],[[-2,14,-25,15,3,-4],5],[[5,-34,69,-52,13],1],[[5,-23,38,
-22,-3,8,-2],6],[[-10,27,-20,3],2],[[1,2,-8,17,-15,-2,6,-1],5],[[1,0,-1],9],
[[1,-3,4,-2],3],[[-2,32,-126,202,-142,36],0],[[-1,3,-2],7],[[-4,14,10,-85,121,
-30,-82,79,-21,0,-1,1],4],[[5,-50,101,-57,0,3],2],[[-7,70,-226,329,-226,58],
0],[[-1,-9,19,-10,-5,5,-1],7],[[-8,30,-50,40,-13,-1,1],3],[[1],5],[[-2,1],4],
[[-2,1],6],[[-1,7,-15,15,-7,1],2],[[],0],[[3,-7,6,-2],4],[[],0],[[1,-10,33,
-55,50,-23,4],1],[[1,-2,2,-1],4],[[-1,6,-14,13,-5,1],2],[[2,-7,6,-1],5],[[4,
-25,72,-112,95,-42,8],1],[[-2,2],7]],,[[[6075],0],[[6075],64],[[9,
0,0,-288,621,0,-720,0,1080,-720,0,0,45],0],[[1305,-3060,1710],0],[[-24,0,60,
-120,705,-1296,900,-300,170,0,-108,-100,75,0,5,-12],10],[[-45],32],[[267,
-1308,2304,-1740,456],0],[[810,-2025,1215],0],[[],0],[[],0],[[],0],[[-24,36,0,
-21,0,72,-96,27,0,6],9],[[],0],[[90,-540,1035,-810,225],0],[[],0],[[9,0,-207,
504,-360,0,45],0],[[-3,0,9,-48,36,0,-3],32],[[4,-12,-20,69,-52,-22,40,-4,-4],
5],[[63,-384,777,-627,174],0],[[-8,46,-58,-90,260,-130,-136,179,-59,0,-2,1],
3],[[3],16],[[1,-24,115,-222,209,-90,14],0],[[15,-135,315,-270,75],0],[[],0],
[[],0],[[],0],[[-3,3,-24,159,-279,42,240,42,-468,420,-132,9,-15,6],1],[[9,-72,
198,-180,45],0],[[],0],[[159,-837,1545,-1188,321],0],[[6,-10,-32,86,-58,-10,
34,-16],4],[[],0],[[12,-33,24,3,-6],5],[[],0],[[3,-21,42,-36,3,12,-3],5],[[-9,
51,-111,111,-48,6],1],[[16,-152,515,-866,767,-332,52],0],[[15,-42,38,-10,-1],
4],[[],0],[[-6,40,-91,90,-38,5],1],[[9,-28,28,-11,1],2],[[-1],10],[[-1,12,-34,
37,-14,1],1],[[8,-27,26,-6],3],[[1,0,-1,0,1],16],[[3,-12,12,-3],3],[[],0],[[],
0],[[],0],[[2,-32,137,-264,250,-109,16],0],[[1,-6,7,-2],2],[[],0],[[-3,-18,
135,-276,222,-51,-15,6],1],[[],0],[[],0],[[],0],[[-3,3],3],[[],0],[[5,-63,243,
-438,400,-174,27],0],[[-7,50,-116,105,-31,-2,1],2],[[],0],[[1,-17,88,-180,170,
-73,11],0],[[],0],[[],0],[[],0],[[-2835,3240],0],[[378,-84,0,0,189,-378,783,
-315,0,-189,210,-189],29],[[-594,2133,-2457,891],0],[[-3,6,0,120,-438,351,342,
-378,-540,888,-372,0,-24,21],0],[[-150,660,-870,345],0],[[-9,0,-1,-45,197,
-263,125,-39,30,17,-23,-10,5,0,1],11],[[21,-81,21,222,-279,-21,243,-120,0,0,
3],3],[[-3,6,90,-351,450,-180,-24,21],0],[[10,0,-3,-17,15,6,-2],15],[[-6,-9,
18,5,-18,0,7],9],[[-26,207,-572,721,-414,85],0],[[-360,1395,-1665,630],0],
[[-9,0,49,-76,36,4,5,-9,1,-1],13],[[8,-28,24,11,-10,-42,78,-57,18,-4,2],9],
[[-3,9,-9,3],10],[[-69,468,-1173,1398,-783,159],0],[[-3,36,-132,195,-117,21],
0],[[-39,291,-777,948,-534,111],0],[[-2,4,-5,8,-7,2],10],[[-1,1,-2,3,-1,3,-4,
1],10],[[-4,23,-32,9,6,-2],5],[[15,-72,108,-63,12],1],[[-1,10,-33,42,-18,-6,7,
-1],5],[[3,-24,45,-24,3],1],[[2,1,-15,21,-6,-3,4,-1],5],[[-1],10],[[4,-8,6,
-1],3],[[-6,66,-222,303,-177,36],0],[[1,-4,3,-1,1],6],[[1,-13,36,-1,-116,137,
4,-106,77,-19,1,-1],3],[[18,-90,135,-66,0,3],2],[[-13,127,-381,489,-281,59],
0],[[1,1,-15,20,-8,-3,5,-1],6],[[1,-15,55,-79,47,-8,-1],2],[[-1,1],4],[[1,-3,
2],3],[[1,-2,1],5],[[-4,17,-29,21,-6],2],[[-1],5],[[-1,7,-13,8,-1],3],[[],0],
[[2,-21,64,-93,67,-21,2],1],[[3,-6,3],4],[[-3,14,-25,19,-5],2],[[6,-11,6,-1],
5],[[8,-49,130,-179,128,-42,4],1],[[2,-4,2],6]],,[[[8],0],[[-8],105],[[-4,0,0,4],9],
[[-2,6],1],[[-6,0,0,0,0,2],25],[[],0],[[-4,4],3],[[-1,6],1],[[-6,0,0,0,1],55],
[[-4],70],[[4],35],[[-3,0,0,0,2],20],[[-2,3],36],[[-2,4],3],[[-4,2],38],[[4],
6],[[-4],57],[[-2,0,0,2],13],[[-2,4],3],[[-3,0,-1,2],11],[[],0],[[-2,2],5],
[[-1,4],3],[[-4,0,1],27],[[-2],42],[[2],21],[[-4,0,-1,2],11],[[-1,4],3],[[-2,
2],38],[[-3,4],3],[[-3,0,0,2],11],[[],0],[[1,0,2],10],[[-4,1],40],[[-2,0,0,2],
11],[[-2,2],5],[[-4,2],5],[[2],10],[[],0],[[-2,2],5],[[-1,2],5],[[-1],15],
[[-2,2],5],[[2],8],[[-2],29],[[2],8],[[-2],13],[[-1],24],[[1],12],[[-3,2],5],
[[-1,2],5],[[],0],[[-1,2],7],[[-2,1],40],[[-2],22],[[2],19],[[-1,2],5],[[-2,
1],20],[[-3,2],5],[[-1,2],7],[[],0],[[-2,2],5],[[-1,1],22],[[1],14],[[-1],7],
[[-1,7],0],[[-7,0,0,0,0,0,0,0,0,1],54],[[-3,5],2],[[-4,0,-1,3],10],[[-1,5],2],
[[-5,0,0,0,0,1],26],[[-3,0,0,3],10],[[-1,3],6],[[-3,0,0,0,0,1],28],[[-1,0,0,
1],18],[[-3,3],4],[[-2,5],2],[[-5,0,1,0,0,1],26],[[-3,0,0,-1,1],21],[[2,0,0,
1],18],[[-4,3],4],[[-2,3],4],[[-3,3],4],[[-2,1,0,0,1],19],[[-2,0,0,0,1],21],
[[1,-1,1],11],[[-1,3],4],[[-2,0,-1,1],12],[[-1,3],4],[[-3,0,0,1],12],[[-1,0,0,
1],14],[[-1,1],6],[[-2,3],4],[[-2,0,0,1],12],[[-3,0,-1,1],12],[[3],7],[[-2,3],
4],[[-2,0,0,1],14],[[-1,1],8],[[-1,1],6],[[-2,1],6],[[1],11],[[-2,1],6],[[1],
9],[[-1,1],8],[[-1,1],6],[[-2,1],6],[[1],9],[[-2,1],6],[[1],11],[[-3,1],6],
[[1,0,1],11]],,[[[56],0],[[-56],75],[[-4,0,0,24,0,0,-24,0,0,4],3],[[6,
-30,20],0],[[-20,0,0,0,0,30,0,0,0,0,-6],15],[[],0],[[-4,24,-24,4],1],[[6,-15,
20],0],[[-20,0,0,0,15,0,0,0,-6],37],[[-16],50],[[16],25],[[-7,0,0,0,12,0,0,0,
-3],12],[[3,-12,7],25],[[-2,12,-12,4],1],[[-4,12,-12,2],26],[[8,0,0,4],3],
[[-4,0,0,-8],39],[[-4,0,2,4,0,-2],8],[[-2,8,-12,4],1],[[-1,0,-6,6,-1,8,-3,0,
-1],5],[[],0],[[-4,6,-2],3],[[-1,4,-6,4],1],[[-4,0,6,0,-4,0,1],17],[[-4],30],
[[4],15],[[-4,0,-6,12,-4,8,-4,2,-1],5],[[-1,0,-6,4],1],[[-2,6,-6,2],26],[[-3,
16,-18,4],1],[[-1,0,0,6,-1,0,-3],5],[[],0],[[1,0,4,0,1],6],[[-10,8,-4],28],
[[-2,2,0,2,-2],7],[[-2,4,-2],3],[[-10,16,-4],3],[[-2],5],[[],0],[[-2,4,-2],3],
[[-1,2,-1],3],[[],0],[[2,-2],4],[[2],5],[[-2],20],[[-1],4],[[1],11],[[-1],18],
[[1],9],[[-4,8,-3],3],[[-1],5],[[],0],[[-2,4,2,-1],4],[[-4,3,-2],28],[[-2,0,0,
2],14],[[2,-2],13],[[1,0,-1],3],[[1,-2,2,-1],13],[[-6,10,-3],3],[[-2,2,0,-1],
4],[[],0],[[-3,6,-2],3],[[-2,1],16],[[-1],10],[[1],5],[[-21,35],0],[[-35,0,0,
0,0,0,0,0,0,21],36],[[-1,15,-30,10],0],[[-4,0,-6,18,0,12,-12,0,-3,1],4],[[-1,
5,-10,10],0],[[-10,0,0,0,-5,10,0,0,0,1],16],[[-1,0,-3,9,0,3,-9,0,0,1],4],[[-2,
6,0,-3,1],3],[[-1,-6,0,0,0,3,2],18],[[-3,0,0,3],12],[[-4,12,-9,1],2],[[-1,10,
-20,10],0],[[-10,0,10,0,-5,10,0,-5,0,1],16],[[-7,0,0,-6,6,0,0,3],13],[[1,0,0,
3],12],[[-7,21,-12,1],2],[[-1,3,-6,1],2],[[-5,15,-9,1],2],[[1,-2,-1,1,-2,1],
12],[[-2,0,0,-1,3],13],[[1,-2,2,-1],7],[[-1,3,-3,1],2],[[-3,1,-1,3],8],[[-3,
1],4],[[-1,0,0,3],6],[[-1,0,0,1],9],[[-1,1],4],[[-2,6,-6,1],2],[[1],9],[[-1,0,
-6,3,-4,4,0,1],6],[[-1,3,0,0,1],3],[[-3,9,-6,1],2],[[-2,0,0,1],9],[[-2,1,1],
5],[[],0],[[1,1],4],[[-1,0,-1],6],[[-2,2],4],[[],0],[[-1],5],[[1],4],[[-4,3],
4],[[1],6],[[-1,2],4],[[-1],6],[[-6,5],4],[[1],9]],,[[[112],0],
[[-112],90],[[-8,0,36,-48,0,0,20],6],[[6,-44,62],0],[[-24,-20,30,0,10,-24,0,0,
0,0,4],20],[[],0],[[-4,24,-52,32],1],[[1,-27,57],0],[[-30,0,0,0,0,0,0,0,-1],
46],[[4],60],[[-4],30],[[3,0,6,0,-9,0,0,0,4],16],[[-1,0,-3],30],[[8,-30,26],
2],[[-2,0,-2],32],[[-12,0,20],4],[[-8],48],[[4,0,-8,0,0,4],11],[[6,-27,25],2],
[[-3,-5,20,-18,0,-4,6],8],[[],0],[[6,-14,8],4],[[1,-15,21],2],[[-6,0,0,0,-1],
22],[[2],36],[[-2],18],[[-8,-9,30,-24,1,-6,7],8],[[1,-12,20],2],[[2,0,-2],32],
[[-1,15,-40,29],1],[[-3,0,10,-14,0,0,4],8],[[],0],[[-1,-6,3,0,4],8],[[1,0,-1],
34],[[-1,0,6,-9,0,0,4],8],[[5,-12,7],4],[[-4,20,-28,12],3],[[-2,-2,0,4],7],
[[],0],[[4,-11,7],4],[[1,-6,5],4],[[],0],[[3,-9,6],4],[[-4,0,4],6],[[],0],
[[-3,0,4],6],[[-1],10],[[1],20],[[-1],10],[[-1,9,-18,9],3],[[1,-4,4],4],[[],
0],[[3,-5,-6,7],5],[[2,0,-1],34],[[2],18],[[-2],16],[[1,-3,4],4],[[-1,0,-1],
16],[[-1,12,-20,10],3],[[2,-5,-4,6],5],[[],0],[[6,-13,8],4],[[-1],20],[[-1],
12],[[1],6],[[-28,84],0],[[-56,0,0,-21,27,0,0,0,0,-7,0,0,0,0,0,0,0,0,1],45],
[[-1,15,-51,45],0],[[-8,-9,39,-36,0,-7,13],7],[[1,-21,36],1],[[-15,-10,15,0,4,
-11,0,0,0,0,1],21],[[-3,0,18,-25,0,0,10],7],[[3,-9,-7,13],4],[[-1,3,0,0,-3,0,
0,0,0,1],24],[[4,-3,0,-2,0,0,1],15],[[-1,12,-28,17],2],[[7,-37,41],1],[[-10,
-5,9,0,-1,-6,0,1,0,0,1],21],[[3,-2,4,3,-6,0,0,-2,2],17],[[-2,-3,0,2,0,0,1],
15],[[-4,22,-39,20],2],[[4,-16,13],3],[[-1,15,-30,18],2],[[-1,0,1,-2,-2,1,0,0,
1],15],[[2,0,2,-1,-2,0,0,0,1],17],[[1,-5,2,-2,2],9],[[1,-10,11],3],[[-1,-2,7,
-6,0,-2,2],9],[[1,-7,10],3],[[-3,0,5,-7,0,0,1],9],[[1,-1,-1,0,0,1],12],[[1,-3,
2],5],[[5,-18,14],3],[[-1,0,2,-3,0,0,1],9],[[-3,-5,15,-11,1,-3,3],9],[[-7,0,
10],5],[[7,-21,15],3],[[2,0,-4,0,0,1],12],[[2,-2,-3,3],6],[[1,-2,1],5],[[2,-4,
2],5],[[-1,0,0,1],8],[[3,-6,3],5],[[-1,0,1],7],[[1,-2,-2,2],6],[[1,-1,1],5],
[[5,-8,4],5],[[-2,0,1],7],[[4,-6,3],5],[[-1,-1,0,1],8],[[-1,9,-12,5],4],[[-1,
-2,1,0,1],9]],,[[[160],0],[[-160],84],[[8,0,36,-64,0,0,20],6],
[[12,-72,76],0],[[-40,0,6,0,30,0,10,-24,0,0,0,0,2],18],[[],0],[[-8,48,-72,32],
1],[[6,-42,70],0],[[-64,15,0,20,0,-6,0,0,0,1],43],[[-20],56],[[20],28],[[-8,
12,0,4,0,-12,0,0,0,2],15],[[3,-12,11],28],[[-2,18,-42,24],1],[[-4,12,-12,6],
29],[[8,-12,0,20],3],[[-16],45],[[2,4,0,-8,0,0,2],10],[[-1,14,-37,24],1],[[-3,
1,-6,25,-17,0,-4,4],7],[[],0],[[-2,12,-14,4],3],[[5,-20,20],2],[[-5],20],[[],
0],[[],0],[[-6,-4,-13,38,-20,2,-7,4],7],[[2,-16,20],2],[[4,-8,4],30],[[-4,30,
-56,28],1],[[1,0,11,-12,0,0,2],8],[[],0],[[4,-4,4,0,2],8],[[-8,6,-6,2],31],
[[2,0,6,-10,0,0,2],8],[[-1,9,-12,4],3],[[-14,34,-30,8],3],[[2,0,-2,0,2],6],
[[],0],[[-1,8,-11,4],3],[[3,-6,2],4],[[1],12],[[5,-9,4],4],[[2,-4,0,2],5],[[],
0],[[1,-2,0,2],5],[[-1],12],[[1],20],[[-1],10],[[-4,17,-18,6],3],[[1,-4,2],4],
[[],0],[[-2,7,-4,-7,4],4],[[3,-2,1],32],[[-2],17],[[2],15],[[-4,2],5],[[1,0,
1],15],[[-6,21,-21,6],3],[[-1,5,-4,-4,4],4],[[],0],[[-2,11,-14,4],3],[[1],18],
[[],0],[[],0],[[-48,112],0],[[-105,0,0,21,0,0,0,27,0,0,0,0,-7],42],[[-2,30,
-78,50],0],[[-6,2,-9,51,-40,0,-9,11],6],[[6,-30,40],1],[[-20,0,-5,0,10,0,5,
-6],19],[[4,0,18,-30,0,0,8],7],[[-2,9,-9,-9,11],3],[[-2,-3,3,2,3,0,0,-3],21],
[[4,-3,0,-1],15],[[-4,24,-34,14],2],[[-1,16,-56,45],0],[[-16,0,10,0,4,1,1,-5,
0,1],19],[[-14,6,-2,2,6,-6,0,0,-1,1],16],[[3,3,0,0,2],14],[[-11,42,-48,17],2],
[[8,-19,11],3],[[-6,28,-38,14],2],[[1,1,0,1,0,-2,1],14],[[-2,3,1,0,0,-2],16],
[[-2,4,-4,2,-1,1],8],[[4,-12,8],3],[[-1,1,-3,8,-5,0,-1,1],8],[[1,-9,8],3],
[[-2,0,5,-3],9],[[1,1,-1,-1],11],[[2,-2],5],[[-1,11,-22,11],2],[[1,0,2,-2],9],
[[-3,-2,-9,16,-7,1,-3,1],8],[[4,-6,0,8],4],[[-2,15,-26,11],2],[[1,2,1,-2],11],
[[-1,4,-1,-3,1],5],[[1,-1],5],[[2,-3,1],5],[[1,-1],7],[[-1,5,-4,1],4],[[-1],
7],[[2,-1,-1,1],6],[[-1],6],[[-2,8,-6,1],4],[[1,-2],6],[[-1,5,-5,1],4],[[1,0,
-1],7],[[-6,13,-10,2],4],[[1,-1,1],9]],,[[[448],0],[[-448],60],[[4,0,0,-64,36,0,48,0,36,
-64,0,0,4],0],[[104,-240,104],0],[[6,0,-40,0,90,-80,90,0,-40,0,6],10],[[],0],
[[16,-112,192,-112,16],0],[[84,-140,84],0],[[15,-64,0,0,70,0,0,-64,15],28],
[[-44],40],[[44],20],[[12,-8,0,0,-10,0,0,-8,12],8],[[15,-28,15],20],[[8,-52,
92,-52,8],0],[[4,-20,28,-20,4],20],[[4,0,-12,48,-12,0,4],0],[[-32],33],[[4,2,
0,-12,0,2,4],5],[[8,-42,68,-42,8],0],[[-3,11,-10,7,-10,7,-10,11,-3],3],[[],0],
[[-2,16,-28,16,-2],1],[[4,-20,30,-20,4],0],[[1,0,0,0,0,0,0,0,1],12],[[-2],24],
[[2],12],[[-1,2,-4,20,-29,26,-16,26,-29,20,-4,2,-1],1],[[4,-16,12,-16,4],0],
[[2,-8,12,-8,2],20],[[12,-76,132,-76,12],0],[[1,-4,1,0,1,-4,1],4],[[],0],[[4,
0,-2,0,4],4],[[-4,9,-16,9,-4],21],[[2,0,0,-4,0,0,2],4],[[-2,9,-14,9,-2],1],
[[-10,54,-84,54,-10],1],[[2,-8,2],4],[[],0],[[-1,8,-14,8,-1],1],[[3,-6,3],2],
[[],0],[[-1,3,-4,3,-1],1],[[2,-4,2],3],[[],0],[[1,-4,1],3],[[2],8],[[1],14],
[[-1],7],[[-4,19,-32,19,-4],1],[[1,0,1],2],[[],0],[[-1,2,11,-28,11,2,-1],1],
[[3,-2,3],22],[[2],13],[[-2],11],[[2],3],[[-1,0,-1],11],[[-5,29,-48,29,-5],1],
[[7,-14,7],3],[[],0],[[-2,13,-24,13,-2],1],[[1,0,1],12],[[1],8],[[-1],4],
[[-224,224],0],[[35,-189,0,0,0,0,0,0,189,-35],27],[[-44,180,-180,44],0],[[-1,
3,0,24,-49,27,-24,24,-27,49,-24,0,-3,1],0],[[-24,60,-60,24],0],[[1,0,-10,-20,
25,-25,20,10,0,-1],11],[[10,-14,0,-12,12,0,14,-10],3],[[-1,3,3,-33,33,-3,-3,
1],0],[[3,-5,0,0,5,-3],14],[[3,3,-3,-3],9],[[-2,22,-60,60,-22,2],0],[[-34,120,
-120,34],0],[[5,0,-10,0,19,-19,0,10,0,-5],11],[[-6,6,-8,0,5,-5,0,8,-6,6],8],
[[-1,0,0,1],9],[[-3,40,-111,111,-40,3],0],[[-1,9,-16,16,-9,1],0],[[-2,26,-78,
78,-26,2],0],[[1,2,-1,1,-2,-1],9],[[1,0,0,2,-2,0,0,-1],9],[[-2,2,1,-1,-2,2],
4],[[4,-12,12,-4],1],[[-1,1,0,2,-2,0,-1,1],4],[[3,-3,3,-3],1],[[1,-1,0,0,1,
-1],5],[[1,1,-1,-1],7],[[2,-2],3],[[-1,10,-28,28,-10,1],0],[[-1,1],7],[[-4,7,
-10,5,-5,10,-7,4],4],[[2,-12,12,-2],2],[[-1,14,-43,43,-14,1],0],[[1,0,1,-1,0,
-1],6],[[-1,9,-9,1],3],[[],0],[[-1,1],3],[[1,-1],5],[[-1,5,-5,1],2],[[],0],
[[3,-3],4],[[-1,1],3],[[-3,12,-12,3],2],[[1,-1],4],[[-1,3,-3,1],2],[[2,-2],5],
[[-7,20,-20,7],2],[[1,-1],6]],[[[400],0],[[-400],78],[[-48,0,144,-112,0,0,16],
6],[[50,-180,170],0],[[-60,60,0,-30,-60,60,0,0,-12,0,0,0,0,2],17],[[],0],[[8,
-44,120,-156,72],0],[[15,-125,135],0],[[60,-64,-15,0,0,0,-6],40],[[-20],52],
[[20],26],[[12,-8,-3,0,6,0,-3],14],[[3,-16,9],26],[[-10,50,-80,50],1],[[-8,10,
-16,4],27],[[24,-48,0,16],3],[[8],42],[[-4,-6,16,-4,-4,0,0,2],9],[[-5,36,-68,
41],1],[[-3,14,-16,-20,45,-26,0,-1,3],6],[[],0],[[-6,18,-24,12],3],[[10,-35,
25],2],[[],0],[[],0],[[],0],[[2,20,-1,-49,77,-44,0,-4,8],6],[[3,-28,16],2],
[[6,-8,2],28],[[2,-23,77,-114,59],0],[[6,-12,0,15,-12,0,0,2],7],[[],0],[[4,1,
-6,1],7],[[1,-4,8,-6,1],28],[[2,-7,0,10,-5],7],[[-1,-2,10,-15,8],2],[[-2,10,
-34,64,-60,20],1],[[6,-6,0,0,2],6],[[],0],[[-1,8,-14,7],3],[[2,-6,5],4],[[-1],
12],[[1,3,-7,3],3],[[2,-4,0,2],5],[[],0],[[1,-3],5],[[2],10],[[1],18],[[-1],
9],[[1,-7,23,-28,11],2],[[-2,2],5],[[],0],[[2,-11,21,-15,-4,8],3],[[1,-2],30],
[[-2],16],[[2],14],[[-1,-1],4],[[1,0,1],14],[[3,-14,35,-38,15],2],[[-4,12,-11,
-1,3],4],[[],0],[[-4,15,-21,10],3],[[],0],[[],0],[[],0],[[-140,260],0],[[105,
-189,0,-15,0,0,-21],39],[[-19,93,-177,111],0],[[18,-30,-54,126,-76,0,-4,12],
6],[[15,-75,60],1],[[10,-25,25,0,-5,-20,20,0,0,-6,0,0,0,0,1],17],[[6,-27,0,54,
-37,0,0,4],6],[[-10,32,-30,-4,12],3],[[3,-5,3,-3,2],20],[[3,-6,0,6,-3,0,-1,0,
0,1],12],[[2,-15,46,-60,27],1],[[-5,55,-125,90],0],[[-16,15,-4,-10,-5,6,0,-1],
18],[[-6,6,-5,0,-2,4,0,-3],14],[[6,3,-3],13],[[-1,10,-40,89,-97,38],0],[[12,
-23,12],3],[[4,-23,59,-72,32],1],[[2,-2,-2,3,-1],13],[[1,1],15],[[-2,1,2,-4,
1],7],[[5,-14,11],3],[[-1,4,-4,-4,7,-4],7],[[-8,4],4],[[3,1,0,4,-5,0,0,1],8],
[[-1,0,1],10],[[1,-3,2],5],[[-3,18,-32,17],2],[[1,-1],8],[[-3,11,-1,-17,28,
-16,0,-1,2],7],[[10,-17,0,4],4],[[-8,30,-43,24],2],[[-3,-2,5,-2,-2,0,0,1],10],
[[1,-4,8,-6,-1,2],4],[[-1,1],6],[[1,0,-1],4],[[1,-1],7],[[4,-6,3],5],[[-1],6],
[[2,-2],6],[[],0],[[-3,10,-12,5],4],[[-1,0,1],7],[[-1,0,3,-5,2],3],[[2,-2,0,0,
1],7],[[1,-7,18,-18,6],3],[[1,-1],8]],,[[[448],0],[[-448],75],[[-64,0,144,
-96,0,0,16],6],[[64,-208,176],0],[[60,-60,10,0,-30,-40,30,0,10,-12],16],[[],
0],[[8,-64,144,-160,72],0],[[24,-144,136],0],[[-10,0,-24,64,-45,0,0,0,0,0,0,0,
-1],37],[[16],50],[[-16],25],[[1,0,24,-16,0,0,6,0,0,0,0,0,1],12],[[-6,0,-10],
25],[[2,-16,58,-88,42],0],[[-2,4,2,4,-6],25],[[32,-48,0,16],3],[[],0],[[4,-8,
-4,12,0,-4],8],[[-10,44,-70,36],1],[[-3,21,-24,-17,40,-19,0,-1,3],6],[[],0],
[[2,-8,18,-20,8],2],[[14,-36,20],2],[[6,0,-4],19],[[-2],30],[[2],15],[[-2,18,
-17,-45,77,-32,1,-5,5],6],[[8,-24,16],2],[[4,0,-4],27],[[4,-32,96,-116,56],0],
[[6,-16,0,12,-10],7],[[],0],[[-3,8,0,-6,0,0,1],6],[[-1,-6,5,4,-2],27],[[-1,5,
-10,1,7,-3,0,0,1],6],[[1,-3,10,-13,5],2],[[-4,18,-46,66,-52,20],1],[[4,-4,-2],
6],[[],0],[[-3,8,-10,5],3],[[2,-4,2],4],[[],0],[[-1,3,-5,3],3],[[4,-4],5],[[],
0],[[1,2,-3,0,1],4],[[-1],11],[[1],18],[[-1],9],[[3,-12,23,-22,10],2],[[-2],
5],[[],0],[[2,-13,25,-14,-5,5],3],[[-2,3,0,-1],28],[[],0],[[],0],[[-1,0,0,1],
3],[[],0],[[-1,6,-21,35,-32,13],1],[[-5,13,-10,-1,3],4],[[],0],[[1,-7,15,-16,
8],2],[[-1],16],[[1],10],[[-1],5],[[-168,280],0],[[-70,0,0,168,-189,0,0,0,0,0,
0,0,-21],36],[[-24,120,-192,112],0],[[20,-44,-54,122,-64,0,-6,10],6],[[24,-80,
56],1],[[10,-5,5,0,-15,-10,15,0,1,-1],17],[[12,-36,0,48,-28,0,0,4],6],[[-12,
38,-30,-6,10],3],[[-2,0,3,0,0,0,-1],18],[[3,-6,0,6,-3],12],[[4,-24,52,-56,24],
1],[[-10,68,-140,86],0],[[-5,21,-5,5,-9,-5,-6,1,0,0,-1],16],[[1,-12,20,-8,0,
-2,4,0,0,0,0,0,1],13],[[-7,6,0,0,-3],12],[[-1,16,-57,101,-92,37],0],[[-4,12,
-22,10],2],[[-1,7,-33,69,-67,29],0],[[-2,5,-9,2,0,2,-2],12],[[-1,6,-2,0,0,2,
-1],14],[[-7,4,2,-4,0,0,1],7],[[6,-14,6],3],[[-2,8,-7,-2,6,-2,0,0,1],7],[[2,
-6,4],3],[[3,-6,0,4,-1],8],[[-1,0,1],10],[[-1,1],6],[[-6,22,-28,14],2],[[1,-2,
0,0,-1],8],[[-5,16,-12,-15,25,-10,0,-1,2],7],[[12,-16,0,4],4],[[2,-12,34,-42,
18],1],[[2,-3,-1,3,-1],9],[[1,-5,8,-5,-1,2],4],[[],0],[[-1,0,0,1],4],[[1,0,
-1],6],[[-1,2,-3,2],4],[[],0],[[2,-2,0,1],6],[[-1],4],[[1,-4,7,-8,4],3],[[1,
-1],6],[[-1,2,-3,2],4],[[1,-1],7],[[-1,3,-10,14,-13,6],2],[[2,0,-1],8]],
,[[[560],0],[[-560],81],[[-40,0,180,-184,0,0,44],6],[[56,-252,252],0],
[[-30,10,0,-48,-60,90,0,20,-42,0,0,0,0,4],17],[[],0],[[4,-48,168,-232,108],0],
[[20,-162,216],0],[[-60,0,0,0,-20,0,6],41],[[20],54],[[-20],27],[[6,-24,9,0,
14,0,-15,0,0,0,3],14],[[-2,18,-9],27],[[-10,66,-130,76],1],[[4,-18,16,-4],28],
[[24,-60,0,44],3],[[-8],45],[[-6,-2,20,-2,-14,0,0,4],9],[[-5,50,-111,70],1],
[[8,-15,-28,74,-46,0,-6,9],7],[[],0],[[-8,32,-40,16],3],[[15,-60,50],2],[[-5],
21],[[],0],[[],0],[[10,-11,-62,119,-64,3,-14,13],7],[[8,-46,44],2],[[-8,10,
-2],29],[[1,-23,108,-175,91],0],[[3,-10,0,28,-27,0,0,4],7],[[],0],[[2,1,-14,5,
0,3],7],[[10,-12,6,-1],30],[[1,-4,0,17,-17,0,0,3],7],[[-4,21,-30,13],3],[[10,
-48,102,-92,30],2],[[4,-6,-4,0,4],6],[[],0],[[-3,18,-27,12],3],[[6,-13,7],4],
[[],0],[[-1,10,-18,9],3],[[6,-10,0,4],5],[[],0],[[3,-7,0,3],5],[[1],9],[[-1],
18],[[1],9],[[1,-13,43,-49,19],2],[[2,-7,4],4],[[],0],[[-9,30,-18,-14,13],4],
[[-4,2],31],[[2],18],[[-2],15],[[1,-5,3],4],[[2,-1],16],[[2,-22,58,-62,22],2],
[[-3,18,-16,-6,9],4],[[],0],[[-7,28,-37,15],3],[[1],17],[[],0],[[],0],[[-182,
378],0],[[-189,0,15,0,0,-21,0,0,-21,27,0,0,0,0,-7],40],[[-16,120,-258,166],0],
[[10,-30,-63,181,-120,0,-17,27],6],[[20,-106,110],1],[[-10,5,0,-24,-20,30,0,6,
-12,0,0,0,0,1],18],[[3,-20,0,75,-73,0,0,15],6],[[-6,39,-39,-17,27],3],[[3,-2,
-3,-3,1,3,0,0,-3],20],[[-6,0,13,-6,0,-2,0,0,1],13],[[1,-19,73,-99,44],1],[[-5,
66,-186,141],0],[[-14,-10,0,14,0,-1,-6,0,1],20],[[14,-16,9,-6,8,6,-9,0,0,-1,
2],15],[[-3,-3,-3,0,2],14],[[7,-50,134,-149,58],1],[[-2,22,-47,27],2],[[2,-28,
90,-114,48],1],[[3,1,1,-2,-2,1],15],[[-5,3,0,2,-1,-2],16],[[2,7,-10,3,-1,2],
8],[[10,-30,20],3],[[2,-3,-7,17,-10,0,-1,2],8],[[4,-19,15],3],[[3,-5,0,9,-8,0,
0,1],8],[[-1,1,2,-1,-1],10],[[3,-5,2],5],[[-4,32,-58,31],2],[[1,-1,0,2,-3],8],
[[8,-5,-27,47,-23,1,-5,4],8],[[11,-26,0,15],4],[[-9,47,-74,36],2],[[-2,-1,7,
-1,-4,0,0,1],10],[[-5,13,-7,-5,4],5],[[1,-2,1],5],[[3,-4,2],5],[[1,-2],7],
[[-2,9,-11,4],4],[[1,-1],6],[[-1,5,-4,-1,2],5],[[-1],6],[[-6,18,-19,6],4],[[3,
-3,0,1],6],[[-2,9,-11,4],4],[[2,-2,-1,0,1],7],[[2,-14,33,-29,9],3],[[1,-1,-2,
1],8]],,
[[[1344],0],[[-1344],60],[[4,0,0,-64,180,0,-240,0,180,-64,0,0,4],0],[[344,
-656,344],0],[[-6,0,60,-120,210,-320,210,-120,60,0,-6],10],[[],0],[[96,-336,
480,-336,96],0],[[204,-468,204],0],[[-64,84,0,20,0,84,-64],29],[[-60],40],
[[60],20],[[-8,24,0,-38,0,24,-8],9],[[21,-36,21],20],[[40,-140,212,-140,40],
0],[[8,-28,28,-28,8],20],[[4,0,-60,144,-60,0,4],0],[[-32],33],[[4,-6,-8,20,-8,
-6,4],5],[[24,-102,156,-102,24],0],[[-5,17,-10,-51,98,-51,-10,17,-5],3],[[],
0],[[4,-14,28,-36,28,-14,4],0],[[4,-36,58,-36,4],0],[[1,0,-4,0,12,0,-4,0,1],
12],[[-6],24],[[6],12],[[2,-1,0,-20,56,-67,-18,84,-18,-67,56,-20,0,-1,2],0],
[[4,-16,36,-16,4],0],[[2,-8,12,-8,2],20],[[60,-220,316,-220,60],0],[[3,0,-21,
40,-21,0,3],4],[[],0],[[8,-22,8],5],[[1,-6,10,-4,10,-6,1],20],[[2,-14,24,-14,
2],5],[[2,-6,11,-14,11,-6,2],0],[[12,-62,130,-164,130,-62,12],0],[[6,-8,6],4],
[[],0],[[-3,8,-10,8,-3],1],[[1,-2,1],2],[[],0],[[-1,1,0,1,-1],1],[[2,-4,2],3],
[[],0],[[1,-2,1],3],[[],0],[[],0],[[],0],[[2,-14,33,-40,33,-14,2],0],[[-1,0,
-1],2],[[],0],[[2,-1,-12,41,-64,41,-12,-1,2],0],[[4],23],[[2],13],[[-2],11],
[[2],3],[[-1,0,-1],11],[[6,-29,61,-76,61,-29,6],0],[[-4,17,-26,17,-4],2],[[],
0],[[2,-10,21,-26,21,-10,2],0],[[1,-2,1],12],[[],0],[[],0],[[-672,672],0],
[[378,-294,0,0,294,-378],29],[[-180,492,-492,180],0],[[-3,1,0,40,-123,81,120,
-120,-81,123,-40,0,-1,3],0],[[-40,164,-164,40],0],[[1,0,-10,30,-25,60,-60,25,
-30,10,0,-1],10],[[6,-26,0,100,-100,0,26,-6],3],[[-3,1,33,-99,99,-33,-1,3],0],
[[2,-6,6,-2],15],[[3,0,-3,3,0,-3],8],[[-14,66,-124,124,-66,14],0],[[-110,328,
-328,110],0],[[-5,-9,15,21,-21,-15,9,5],12],[[8,-12,12,19,-19,-12,12,-8],9],
[[3,-3],10],[[-33,144,-261,261,-144,33],0],[[-3,11,-24,24,-11,3],0],[[-22,94,
-170,170,-94,22],0],[[-1,-7,7,1],10],[[-1,0,8,-8,0,1],10],[[-4,15,-15,4],5],
[[4,-12,12,-4],1],[[-1,8,-19,19,-8,1],5],[[1,-1,1,-1],1],[[2,-8,8,-2],6],[[],
0],[[],0],[[-3,22,-44,44,-22,3],0],[[1,-2,2,-1],6],[[4,-8,9,14,-49,49,-14,-9,
8,-4],3],[[6,-28,28,-6],2],[[-11,42,-81,81,-42,11],0],[[-1,1,0,-4,4,0,-1,1],
5],[[2,-7,13,-13,7,-2],2],[[],0],[[-1,1],3],[[-1,1],5],[[-1,1,-1,1],2],[[],0],
[[-1,1,-1,1],3],[[],0],[[-1,4,-8,10,-10,8,-4,1],0],[[1,0,0,-1],3],[[1,-1,0,0,
1,-1],1],[[-1,1,-1,1],4],[[-1,7,-16,22,-22,16,-7,1],0],[[2,-2],6]],[[[840],0],
[[-840],69],[[-24,36,0,-72,0,180,-140,0,0,20],3],[[148,-418,274],0],[[-30,90,
-100,150,-30,-70,0,-48,0,30,0,10,-6],13],[[],0],[[20,-152,312,-268,88],0],
[[84,-273,210],0],[[-70,0,84,-64,15,0,20,0,-6],35],[[-60],46],[[60],23],[[-2,
0,24,-32,12,0,4,0,-3],12],[[15,-42,24],23],[[8,-52,136,-142,44],0],[[4,-20,44,
-32,10],23],[[-12,72,-60,0,20],2],[[-8,0,0,-12],36],[[-2,4,-6,-2,8,0,-2],7],
[[4,-36,104,-110,40],0],[[2,-2,-2,28,-26,-26,42,-19,0,-1,2],4],[[],0],[[-2,10,
-28,36,-20,4],1],[[-10,40,-55,20],1],[[5],17],[[],0],[[],0],[[-4,8,-13,26,22,
-18,-83,84,-24,2,-7,4],3],[[-6,24,-35,20],1],[[-6,18,-16,4],24],[[12,-90,208,
-193,64],0],[[-1,0,10,-20,-1,14,-3],5],[[],0],[[-6,8,4,-4,1],6],[[-2,8,-22,19,
-8,2],24],[[-2,6,-8,2,6,-4],6],[[-1,4,-14,20,-13,4],1],[[-10,58,-116,118,-66,
14],1],[[-4,8,0,-2],5],[[],0],[[3,-12,17,-10,2],2],[[-3,6,-3],3],[[],0],[[1,
-4,7,-6,2],2],[[-4,6,-4],4],[[2],20],[[-2,4,-2],4],[[],0],[[],0],[[],0],[[-1,
14,-36,42,-26,6],1],[[2,-1],4],[[],0],[[11,-34,41,-10,-7,4],3],[[-6,3,-2],26],
[[2],13],[[-2],12],[[-1],5],[[-1,2],12],[[-4,25,-58,65,-37,8],1],[[3,-16,21,
-8,-1,2],3],[[],0],[[-1,8,-23,30,-17,4],1],[[-1],15],[[],0],[[],0],[[-357,
483],0],[[-378,189,0,0,0,168,0,0,-105],34],[[-58,270,-357,155],0],[[12,-21,27,
14,-58,-81,167,-72,0,-9,11],3],[[-10,74,-135,75],0],[[-15,15,-20,30,10,-10,4,
-19,0,0,0,1],14],[[-4,0,20,-36,0,52,-35,0,0,3],4],[[3,-39,69,-33,-9,11],2],
[[3,0,-2,-3],19],[[-3,-3,6,-3,0,3],10],[[-1,17,-68,108,-78,22],0],[[-34,164,
-254,115],0],[[9,0,5,9,-11,0,-5,0,1,1],15],[[-2,-4,-12,28,-22,6,-2,2,0,-3],
12],[[6,3],13],[[-3,44,-147,201,-136,36],0],[[3,-13,31,-27,11],1],[[-2,26,-92,
140,-97,25],0],[[1,-5,2,2],13],[[4,-4,0,1],15],[[2,-8,2,4,-2,1],6],[[-6,18,
-17,3],2],[[1,-2,9,-5,-2,4,-3],6],[[-2,6,-9,3],2],[[8,-5,-1],8],[[-1,1],10],
[[-1,1],4],[[4,-24,48,-38,11],1],[[-1,2,-2],7],[[-1,1,-4,-4,24,-8,-23,19,-7,0,
-1,1],4],[[-8,24,-16,0,3],3],[[-1,10,-41,75,-56,14],0],[[3,-4,-2,2],9],[[-1,5,
-13,11,-2,-1,1],3],[[],0],[[-1],6],[[1],7],[[2,-4,4,-2],3],[[],0],[[1,-3,3,
-1],4],[[],0],[[-2,7,-13,12,-6,1],2],[[-1,2],5],[[2,-3,4,-3,1],3],[[-2,1],6],
[[-4,17,-25,23,-12,2],2],[[-2,1],7]],,
[[[1008],0],[[-1008],75],[[-8,36,0,-56,0,252,-272,0,0,48],3],[[132,-492,384],
0],[[-136,90,0,40,0,-54,-40,90,0,20,-36,0,0,0,0,2],15],[[],0],[[12,-120,360,
-384,132],0],[[72,-306,324],0],[[-90,0,-24,64,-45,0,0,0,6,0,0,0,-1],37],[[36],
50],[[-36],25],[[9,0,6,-40,36,0,12,0,-15,0,0,0,1],12],[[-9,18,-18],25],[[2,
-38,156,-206,86],0],[[-2,8,-18,20,-8],25],[[-12,56,-84,0,48],2],[[-8],39],[[2,
-8,-2,20,-2,-12,0,0,2],8],[[1,-25,116,-175,79],0],[[-2,0,12,-13,-41,96,-46,0,
-7,5],5],[[],0],[[4,-32,62,-44,10],2],[[-6,45,-90,54],1],[[-4,0,0,0,0,0,1],
17],[[-2],30],[[2],15],[[-17,16,16,-4,-113,160,-64,8,-16,8],5],[[-2,28,-68,
48],1],[[2,-4,8,-6],26],[[5,-69,236,-285,107],0],[[-1,2,4,-8,-1,30,-22,0,0,2],
5],[[],0],[[-3,2,4,-12,5,0,1],6],[[-1,6,-8,8,-2],27],[[-1,2,-3,1,16,-16,0,0,
1],6],[[1,-18,41,-32,8],2],[[-2,34,-128,186,-114,24],1],[[-4,10,-4,-4,0,2],5],
[[],0],[[1,-14,35,-29,7],2],[[-4,14,-13,3],3],[[],0],[[-6,20,-19,5],3],[[-2,
10,-10,0,2],4],[[],0],[[5,-6,0,1],5],[[],0],[[],0],[[],0],[[6,-41,78,-57,13],
2],[[-1,6,-6,2],3],[[],0],[[5,-28,49,-16,-16,8],3],[[-2,-1,2,-1],28],[[2],14],
[[-2],13],[[-1,4,-5,1],3],[[-1,2],13],[[13,-64,109,-72,16],2],[[1,-12,28,-17,
-7,5],3],[[],0],[[3,-26,55,-41,9],2],[[-1,1],16],[[1],10],[[-1],5],[[-378,
630],0],[[-280,0,-189,210,0,0,15,0,0,-35,0,0,0,27],36],[[-42,270,-468,228],0],
[[-17,27,18,-38,-99,273,-152,0,-24,24],4],[[-6,66,-180,144],0],[[-45,20,0,11,
4,-18,-10,15,-1,6,-6],16],[[-1,3,8,-20,-3,91,-90,0,0,12],4],[[3,-27,71,-51,
-24,24],2],[[3,-4,-3,3,2,3],20],[[-1,-3,-3,11,-3,0,-1],12],[[7,-59,149,-139,
42],1],[[-21,162,-330,189],0],[[-24,26,-15,5,0,0,4,4],16],[[9,0,22,-42,18,-6,
6,9,-6,0,0,-1],13],[[-10,3,-3,1],12],[[-1,23,-133,269,-217,59],0],[[-11,49,
-62,24],2],[[12,-82,186,-162,46],1],[[-3,6,-6,6,-3],12],[[2,-1,2,-8,8],13],
[[-3,0,8,-9,2,-1],7],[[-5,27,-38,16],2],[[-1,2,-3,-7,17,-7,0,-1],7],[[-1,13,
-24,12],2],[[-1,1,2,-4,0,6,-4],6],[[-1,1,1,-1],10],[[-3,6,-3],4],[[1,-20,68,
-79,27],1],[[1,2],10],[[-2,-1,10,2,-45,52,-16,3,-4,1],6],[[-5,23,-30,0,12],3],
[[3,-36,102,-101,32],1],[[1,-3,-2,6,0,-2],9],[[2,-13,18,-4,-4,1],4],[[-1,2,
-1],4],[[-3,5,-3],4],[[2,-1],7],[[1,-9,15,-8,1],3],[[1,-1],6],[[-2,6,-3,-1],
5],[[-1,1],4],[[4,-22,30,-15,2],3],[[-1,4,-2],5],[[1,-9,15,-8,1],3],[[-2,4,-1,
-1],6],[[11,-41,52,-26,4],3],[[1,0,-1],8]],,[[[2016],
0],[[-2016],60],[[-112,288,0,-352,0,288,-112],3],[[516,-984,516],0],[[-20,0,0,
70,-180,270,-328,270,-180,70,0,0,-20],9],[[],0],[[144,-504,720,-504,144],0],
[[306,-702,306],0],[[-15,0,60,0,0,0,60,0,-15],28],[[-36],40],[[36],20],[[-3,0,
30,0,-36,0,30,0,-3],8],[[9,-36,9],20],[[58,-214,312,-214,58],0],[[2,-20,36,
-20,2],20],[[-96,208,-96],2],[[-16],33],[[4,-6,-16,36,-16,-6,4],5],[[35,-155,
232,-155,35],0],[[-6,31,-19,-72,140,-72,-19,31,-6],3],[[],0],[[4,-20,42,-52,
42,-20,4],0],[[9,-51,90,-51,9],0],[[1,0,-4,0,0,0,-4,0,1],12],[[-4],24],[[4],
12],[[-28,103,-103,-29,120,-29,-103,103,-28],3],[[-28,50,-28],1],[[-8,16,-8],
21],[[91,-327,478,-327,91],0],[[-2,5,-4,-28,52,-28,-4,5,-2],3],[[],0],[[1,10,
-28,10,1],4],[[-2,13,-16,13,-2],21],[[1,0,-18,34,-18,0,1],4],[[-7,17,-20,17,
-7],1],[[20,-90,194,-248,194,-90,20],0],[[-2,10,-16,10,-2],3],[[],0],[[1,-5,
12,-16,12,-5,1],0],[[-1,2,-2,2,-1],1],[[],0],[[1,-2,1],2],[[2,-4,2],3],[[],0],
[[],0],[[],0],[[],0],[[],0],[[4,-21,48,-64,48,-21,4],0],[[2],3],[[],0],[[-21,
65,-90,65,-21],2],[[1,0,1],22],[[-2],13],[[2],11],[[-1,0,-1],2],[[1,0,1],11],
[[9,-42,90,-116,90,-42,9],0],[[-6,25,-36,25,-6],2],[[],0],[[3,-14,31,-40,31,
-14,3],0],[[1,-2,1],12],[[-1],8],[[1],4],[[-1008,1008],0],[[70,216,0,-210,0,0,
210,0,-216,-70],27],[[-270,738,-738,270],0],[[68,-206,126,176,-176,-126,206,
-68],3],[[-60,246,-246,60],0],[[-15,15,-35,49,-49,35,-15,15],12],[[9,-44,6,
145,-145,-6,44,-9],3],[[54,-146,146,-54],2],[[2,-6,6,-2],15],[[3,-3,0,0,3,-3],
8],[[-21,98,-187,187,-98,21],0],[[-165,492,-492,165],0],[[1,0,0,-5,5,-1,9,-9,
1,-5,5,0,0,-1],9],[[3,0,-18,12,18,-18,-12,18,0,-3],8],[[7,6,-6,-7],9],[[-51,
213,-393,393,-213,51],0],[[17,-36,36,-17],1],[[-34,138,-256,256,-138,34],0],
[[3,-3,-6,6,3,-3],9],[[-2,1,6,-6,-1,2],10],[[-1,-6,18,-18,6,1],4],[[-1,8,-17,
17,-8,1],0],[[-1,0,10,-25,25,-10,0,1],4],[[-2,2],2],[[-1,1,3,-5,5,-3,-1,1],4],
[[],0],[[],0],[[-6,32,-67,67,-32,6],0],[[-1,1],7],[[3,-16,16,23,-69,69,-23,
-16,16,-3],3],[[9,-40,40,-9],2],[[-14,65,-120,120,-65,14],0],[[4,-11,11,-4],
7],[[3,-11,18,-18,11,-3],2],[[],0],[[1,0,0,-1],2],[[-1,1],5],[[1,-1,2,-2,1,
-1],1],[[-1,1],4],[[],0],[[1,-1],3],[[-1,5,-10,15,-15,10,-5,1],0],[[-1,1],4],
[[1,-1],3],[[-1,2,-2,1],4],[[-2,10,-22,34,-34,22,-10,2],0],[[1,-1],6]],
[[[1296],0],[[-1296],70],[[-48,72,0,-24,0,252,-288,0,0,36],3],[[210,-660,426],
0],[[-40,0,90,-232,180,0,0,0,0,-20,60,0,10,-24],12],[[],0],[[24,-204,504,-444,
120],0],[[135,-405,351],0],[[-81],34],[[],0],[[],0],[[6,0,0,-48,45,0,6,0,-9],
12],[[],0],[[6,-78,228,-228,72],0],[[],0],[[-24,96,-84,0,36],2],[[-24],38],
[[-2,-8,0,20,-2,-8],8],[[5,-55,170,-190,66],0],[[3,-9,2,8,-3,-46,85,-34,0,-4,
2],4],[[],0],[[14,-56,72,-34,4],2],[[1,-19,71,-94,42],0],[[-1,0,4,0,-6,0,4,0,
-2],14],[[6],28],[[-6],14],[[12,-42,30,6,30,-129,150,-48,9,-12,3],4],[[-12,39,
-72,36],1],[[],0],[[13,-126,337,-321,94],0],[[1,-4,0,4,-1,-4,21,-14],4],[[],
0],[[-6,0,9,-6,3],6],[[],0],[[-3,0,0,0,12,-9],6],[[6,-30,45,-24,3],2],[[-8,72,
-198,220,-100,14],1],[[2,-10,12,-2,-2],4],[[],0],[[5,-26,39,-21,3],2],[[1,-9,
16,-8,1],2],[[-1],10],[[1,-10,20,-13,2],2],[[-6,12,-6],4],[[],0],[[-3,6,-3],
4],[[],0],[[],0],[[],0],[[-1,18,-67,89,-45,7],1],[[-2,5,-4],3],[[],0],[[12,
-54,57,-9,-12,3],3],[[3],26],[[],0],[[],0],[[3,-3],4],[[],0],[[-2,32,-105,126,
-60,8],1],[[5,-24,33,-11,-4,2],3],[[],0],[[11,-46,63,-31,4],2],[[-1,2,-2],14],
[[],0],[[],0],[[-540,756],0],[[-336,0,189,-315,0,0,210,0,0,15,0,0,21],33],
[[-75,405,-585,231],0],[[12,-54,54,12,-12,-117,279,-144,0,-21,15],3],[[-20,
115,-215,136],0],[[-10,0,25,-76,40,0,-9,3,1,0,10,-1,2,-1],13],[[1,-10,4,5,-8,
-4,84,-78,0,0,6],3],[[6,-54,99,-45,-21,15],2],[[5,-3,0,-4,-3,3,2],18],[[3,3,
-4,-3,-3,7,-3],10],[[-1,20,-106,193,-136,30],0],[[-45,255,-405,186],0],[[-5,0,
19,-41,31,-5,5,-5,10,4,-5,0,1],13],[[-2,4,0,24,-48,21,-4,2,6,-3],12],[[6,-9,3,
-3,3],11],[[-3,51,-219,351,-222,45],0],[[3,-24,60,-57,15],1],[[-1,29,-144,244,
-161,33],0],[[1,-6,7,-7,7,-3,1],11],[[3,-3,3,-9,6],13],[[2,-4,-4,9,-4,1],6],
[[1,-14,37,-33,9],1],[[1,-2,0,0,-7,11,-3],6],[[-4,15,-21,6],2],[[1,-2,1,2,-1,
-1,4],5],[[-1,-1,1,1],9],[[1,-5,5,-1],3],[[6,-41,90,-72,18],1],[[-1],7],[[3,
-7,-1,5,14,-48,39,-8,2,-2],5],[[1,-14,34,-24,0,6],2],[[11,-70,135,-96,21],1],
[[-1,0,-2,-2,4],8],[[8,-22,17,-1,-2],4],[[-1,1],4],[[-2,3,-1],4],[[-1,2,-1],
6],[[4,-14,13,-4],3],[[1],6],[[1,-5,5,-1],4],[[],0],[[13,-33,29,-8],3],[[-3,3,
-1],5],[[3,-12,12,-4],3],[[1,-4,4],5],[[-2,26,-59,51,-16,1],2],[[-2,0,1],7]],,
[[[1400],0],[[-1400],69],[[-8,72,0,-224,0,360,-212,0,0,12],3],[[260,-670,470],
0],[[-30,60,-164,210,-210,130,0,-30,-80,60,0,0,-6],13],[[],0],[[56,-248,480,
-452,164],0],[[120,-475,330],0],[[90,0,-60,0,15,0,-20],35],[[20],46],[[-20],
23],[[-27,0,42,-24,-6,0,2],12],[[-3,22,-6],23],[[12,-86,206,-216,92],0],[[8,
-26,12,-2],24],[[-24,128,-120,0,12],2],[[-8,0,0,12],36],[[-2,18,-18,-12,20,-4,
-2],7],[[5,-55,152,-171,67],0],[[2,-2,-30,84,-61,-37,74,-29,0,0,1],4],[[],0],
[[-2,12,-32,48,-40,14],1],[[-10,55,-75,30],1],[[],0],[[],0],[[],0],[[13,-27,
-11,80,-17,-125,167,-68,0,-3,6],4],[[-2,28,-53,12],1],[[2,-10,8],24],[[27,
-147,316,-314,121],0],[[-2,-6,32,-34,-2,20,-11],5],[[],0],[[-11,14,2,-2],6],
[[-5,12,-12,2],25],[[-3,17,-20,0,7,-1],6],[[2,-12,24,-20,6],2],[[4,-26,80,
-158,188,-122,34],0],[[-8,16,-8],5],[[],0],[[2,-9,18,-17,6],2],[[-1,4,-6,3],
3],[[],0],[[-1,0,5,-5,1],2],[[-2,4,-4],4],[[2],20],[[3,-1],5],[[-2],9],[[-1],
16],[[1],8],[[-3,14,-39,58,-43,13],1],[[1,0,-1],3],[[],0],[[-3,25,-56,63,-33,
-3,6],2],[[2,-1],26],[[2],13],[[-2],12],[[1,-2],3],[[-1,2],12],[[1,-8,32,-72,
96,-69,21],0],[[6,-22,31,-17,0,1],3],[[],0],[[-1,8,-24,38,-32,11],1],[[],0],
[[],0],[[],0],[[-595,805],0],[[210,0,-216,-105,0,0,105,-189,0,-15],33],[[-118,
426,-579,277],0],[[4,-40,36,100,-124,-144,292,-136,0,-3,9],3],[[-10,110,-225,
105],0],[[15,-34,45,-40,40,0,-5,-20,20,0,0,-1],15],[[-3,3,64,-114,-3,95,-43,0,
0,1],4],[[12,-72,116,-72,-3,9],2],[[6,-3,6,3,-5,3],17],[[6,-9,0,6,-3],12],
[[-3,28,-93,155,-129,42],0],[[-55,270,-400,200],0],[[4,-15,1,-11,20,-9,0,-6,
1],15],[[15,-12,-18,32,-13,-3,0,2],12],[[-6,-6,6,3],11],[[-14,81,-212,310,
-235,73],0],[[1,-12,36,-37,9],1],[[-7,45,-133,205,-166,56],0],[[-2,5,3,-6,-1,
1],11],[[2,-6,-1,3,0,-1],12],[[7,-10,7,1,-2],6],[[-5,17,-21,9],2],[[2,-10,17,
-11,-2,5,-1],6],[[1,3,-7,1],2],[[-3,5,-2,-1,5,-2],7],[[1,-1],9],[[1,-2,1],5],
[[5,-28,60,-57,20],1],[[-1,1],7],[[-1,1,7,-36,47,-17,-32,43,-16,0,0,1],4],
[[-11,39,-26,0,1],3],[[-1,15,-57,101,-91,34],0],[[-3,8,-7,-2,5,-2],8],[[-2,8,
-15,17,-9,0,1],3],[[],0],[[-1,1,-1],3],[[1],7],[[-2,5,-5,2],4],[[1,-1],5],
[[-1,2,-1],5],[[],0],[[-1,5,-13,19,-15,5],2],[[1,0,-1],5],[[1,-1,-1,4,-3,1],
2],[[-2,3,-2],6],[[1,-4,13,-29,36,-24,7],1],[[-1,1],7]],,[[[1400],0],[[-1400],75],[[-4,36,0,-144,0,396,-344,0,0,60],3],
[[190,-670,540],0],[[-116,150,-60,50,0,-114,-80,120,0,30,-42,0,0,0,0,2],15],
[[],0],[[20,-180,480,-520,200],0],[[90,-435,440],0],[[-80,0,24,-64,30,0,0,0,
-6,0,0,0,1],37],[[-40],50],[[40],25],[[-10,0,30,-56,24,0,18,0,-12,0,0,0,2],
12],[[9,-24,19],25],[[4,-52,202,-282,124],0],[[2,-8,26,-24,8],25],[[-12,80,
-132,0,60],2],[[-4,0,0,8],39],[[10,-16,-8,28,-2,-14,0,0,2],8],[[1,-33,152,
-233,111],0],[[-1,-3,39,-43,-57,128,-62,0,-7,8],5],[[],0],[[6,-36,74,-62,18],
2],[[-5,55,-120,70],1],[[],0],[[],0],[[],0],[[-13,14,40,-33,-154,229,-92,7,
-20,13],5],[[-1,36,-86,60],1],[[-2,6,-10,6],26],[[9,-98,316,-383,159],0],[[2,
10,-30,0,42,-29,0,0,2],6],[[],0],[[2,10,0,-18,4,0,2],6],[[1,-8,13,-8,2],27],
[[1,3,-12,2,21,-17,0,0,2],6],[[2,-19,47,-43,13],2],[[-6,52,-164,236,-162,44],
1],[[-2,14,-8,-6,0,2],5],[[],0],[[1,-15,39,-37,12],2],[[-3,14,-16,5],3],[[],
0],[[-7,21,-22,8],3],[[-2,12,-14,0,2],4],[[2],20],[[-1,7,-9,0,2],4],[[1],11],
[[-1],18],[[1],9],[[9,-49,93,-76,23],2],[[-1,6,-7,2],3],[[],0],[[7,-39,70,-32,
-20,13],3],[[2,-2,1],29],[[-2,0,0,-2],14],[[2,2],13],[[4,-4,2],4],[[1,-2,-2,
1],13],[[-1,19,-79,134,-101,29],1],[[1,-15,39,-27,-7,8],3],[[],0],[[4,-30,64,
-55,17],2],[[],0],[[],0],[[],0],[[-525,875],0],[[-315,0,-189,378,-189,0,15,0,
0,-56,0,0,-21,27],36],[[-65,375,-630,330],0],[[-13,27,44,-100,-153,383,-204,0,
-27,33],4],[[-5,85,-250,190],0],[[-35,30,-5,16,9,-43,-20,30,-1,6,-7],16],[[3,
23,-65,-3,136,-109,0,0,15],5],[[3,-37,103,-81,-27,33],2],[[-1,6,6,-4,-3,0,-1,
3],18],[[5,-9,-3,14,-6,0,-1],12],[[11,-79,189,-186,65],1],[[-30,220,-450,265],
0],[[-4,-1,15,10,-19,-15,1,10,0,-1,-1],16],[[-10,-12,42,-44,12,-8,10,6,-6,0,0,
-1,1],13],[[9,9,-3,-2,-3],12],[[-2,39,-183,349,-297,95],0],[[-14,58,-78,33],
2],[[-1,19,-110,240,-220,74],0],[[3,-5,-5,7,-1,1,-2],12],[[-2,1,2,-9,5,0,2,
-1],13],[[-2,6,8,-12,2,-1,1],7],[[-4,30,-49,21],2],[[7,-8,-8,20,-9,0,-1,1],8],
[[-1,15,-27,15],2],[[1,5,-13,0,10,-5],7],[[1,-2,1,1,-1],9],[[-2,5,-4,1],4],
[[1,-24,84,-101,40],1],[[1,-3,1,2,-1],8],[[-1,-6,32,-13,-56,73,-26,2,-5,3],6],
[[-4,32,-46,0,15],3],[[5,-45,127,-137,49],1],[[5,-6,-3,8,-1,-2],9],[[3,-16,25,
-10,-5,3],4],[[-1,2,-1],4],[[-2,4,-3,1],4],[[-1,2,-1],6],[[1,-8,15,-11,3],3],
[[1,-1],6],[[-4,8,-5,-1,1],5],[[1],5],[[5,-22,34,-23,6],3],[[-1,4,-3],5],[[1,
-9,15,-11,3],3],[[-1,5,-2,-1],6],[[-1,14,-45,61,-39,10],2],[[3,-1,-2],8]],
,[[[2400],0],[[-2400],63],[[8,0,0,-176,252,0,
-144,0,360,-320,0,0,20],0],[[520,-1240,640],0],[[-18,0,-50,0,330,-560,360,-30,
50,0,-6,-20,30,0,0,-6],10],[[],0],[[96,-528,960,-672,144],0],[[360,-780,480],
0],[[-15,0,-24,0,10,0,-60,64,-15,0,-20],29],[[60],42],[[-60],21],[[6,-24,6,0,
8,0,6,-40,33,0,2],8],[[-18,42,-21],21],[[34,-232,442,-312,74],0],[[-4,28,-46,
24,-8],21],[[8,0,-84,192,-120,0,20],0],[[-16],36],[[4,-4,-4,10,-14,-4,16,-2,
-2],5],[[29,-172,330,-248,61],0],[[-5,28,-34,-16,50,-14,-57,70,-21,0,-1],3],
[[],0],[[-8,56,-112,90,-28,2],1],[[10,-70,140,-110,30],0],[[],0],[[],0],[[],
0],[[-2,4,-8,74,-137,38,50,71,-189,149,-40,7,-6,1],1],[[8,-44,84,-80,20],0],
[[-2,8,-18,14,-2],21],[[60,-348,648,-460,104],0],[[4,-7,-12,15,-4,-7,12,-5],
4],[[],0],[[2,2,-12,2,5,-2],4],[[4,-14,24,-14,4,-1],22],[[1,1,-6,5,-6,0,6,-1],
4],[[-4,29,-60,50,-16,1],1],[[4,-54,220,-388,312,-106,10],0],[[10,-20,14,-2],
4],[[],0],[[-3,23,-51,43,-13,1],1],[[7,-19,15,-4],2],[[1],9],[[-1,9,-21,19,
-6],1],[[4,-14,12,-2],3],[[],0],[[3,-7,5,-1],3],[[],0],[[],0],[[],0],[[1,-13,
67,-130,109,-37,3],0],[[2,-5,4,-1],2],[[],0],[[-2,-2,53,-113,81,-8,-6,1],1],
[[-3,2,-3],23],[[-2],15],[[2],12],[[-2,3],3],[[-2,1],13],[[1,-23,110,-206,168,
-55,5],0],[[-3,23,-51,40,-8,-1],2],[[],0],[[-7,44,-92,76,-23,2],1],[[],0],[[],
0],[[],0],[[-1140,1260],0],[[-189,0,-84,0,0,-336,0,594,-315,0,0,210],28],
[[-228,876,-984,312],0],[[-2,6,0,64,-211,153,84,-60,-198,338,-144,0,-13,7],0],
[[-80,280,-340,140],0],[[-4,10,-16,-30,101,-127,55,-4,5,3,6,0,0,0,1],11],[[18,
-45,9,41,-48,-9,88,-55,0,0,1],3],[[-2,6,33,-139,170,-54,-13,7],0],[[-3,-2,0,0,
-1,0,0,-2],14],[[-5,0,9,-4,-3,0,3],9],[[-10,88,-256,308,-154,24],0],[[-150,
580,-660,230],0],[[-5,0,35,-60,31,-5,5,0,0,-1],13],[[14,-16,6,-3,5,-6,24,-34,
15,-2],9],[[-3,6,-9,3],10],[[-23,184,-503,583,-284,43],0],[[-2,22,-67,89,-49,
7],0],[[-12,118,-340,402,-192,30],0],[[-2,1,-7,7,-7,2],10],[[-1,0,-2,3,-3,3,
-4,1],10],[[2,7,-9,-2,5],5],[[10,-41,53,-26,4],1],[[1,3,-7,6,-2,-4,3],5],[[4,
-15,23,-13,1],1],[[2,-2,-5,4,2,-2,1],5],[[1,0,-1],7],[[4,-7,3],3],[[-3,33,
-108,136,-69,11],0],[[1,-1,1,-1],6],[[-6,23,-12,-26,21,25,-47,25,-4,1],4],
[[10,-41,52,-22,0,1],2],[[-4,55,-177,213,-103,16],0],[[1,2,-4,2,-1,-2,2],6],
[[-6,26,-36,16],3],[[1,-1],3],[[1,-3,1],3],[[1,-1,1],5],[[-2,13,-19,10,-1],2],
[[-1],5],[[-1,5,-7,3],3],[[],0],[[-9,37,-51,27,-4],2],[[2,-4,2],4],[[-2,11,
-16,8,-1],2],[[4,-6,2],5],[[2,-21,69,-91,51,-10],1],[[2,-2],6]],,[[[2800],0],[[-2800],66],[[4,0,0,-112,252,0,-304,0,540,
-416,0,0,36],0],[[550,-1420,830],0],[[-24,0,30,0,240,-696,420,-60,210,0,-78,
-60,60,0,10,-12],10],[[],0],[[96,-548,1080,-852,224],0],[[345,-915,625],0],
[[-64,24,0,-10,0,84,-128,45,0,0,0,-6],31],[[-80],44],[[80],22],[[-8,12,0,-2,0,
24,-64,27,0,6,0,-3],9],[[24,-48,32],22],[[30,-220,490,-410,120],0],[[6,-32,44,
-40,12],22],[[4,0,-84,200,-180,0,36],0],[[24],36],[[-6,-4,28,-24,-12,24,-2,
-4],6],[[21,-158,364,-329,98],0],[[-1,14,-25,-28,94,-49,-75,113,-37,0,-3,1],
3],[[],0],[[-6,46,-114,116,-50,8],1],[[5,-55,150,-150,50],0],[[],0],[[],0],
[[],0],[[-1,2,-4,50,-125,24,102,29,-252,235,-72,10,-11,4],1],[[4,-28,101,-104,
36],0],[[2,-8,16,-16,6],22],[[55,-348,723,-595,164],0],[[2,-4,-9,26,-21,-4,23,
-12],4],[[],0],[[4,-6,8,-1,-6,1],5],[[-4,11,-16,17,-10,2],23],[[2,-5,10,-12,2,
8,-5],5],[[-2,22,-62,67,-29,4],1],[[4,-48,212,-416,394,-170,26],0],[[6,-18,18,
-6,-2],4],[[],0],[[-1,17,-49,55,-25,3],1],[[4,-17,20,-8,1],2],[[],0],[[6,-23,
27,-11,1],2],[[2,-12,16,-6],3],[[],0],[[1,-5,8,-3],3],[[-1],10],[[1],16],
[[-1],8],[[-9,56,-133,140,-63,9],1],[[1,-6,7,-2],2],[[],0],[[-1,-4,47,-117,
108,-23,-11,4],1],[[-2,1,-2],25],[[],0],[[],0],[[-4,5,-1],3],[[],0],[[1,-18,
99,-216,213,-94,14],0],[[-2,18,-48,54,-19,-3,1],2],[[],0],[[-4,36,-92,97,-43,
6],1],[[],0],[[],0],[[],0],[[-1260,1540],0],[[-420,0,0,189,0,405,-595,0,-189,
210,0,0,120],30],[[-233,951,-1179,437],0],[[-1,3,0,36,-175,153,150,-154,-261,
487,-208,0,-21,15],0],[[-60,285,-425,200],0],[[-5,0,4,0,96,-167,55,-19,46,8,
-13,-10,5,-1,1],11],[[7,-28,12,75,-108,-12,134,-84,0,0,4],3],[[-1,3,33,-137,
201,-93,-21,15],0],[[4,0,-3,-11,9,3,-2],15],[[-2,-3,12,-5,-6,-3,7],9],[[-7,76,
-256,363,-222,46],0],[[-140,615,-805,325],0],[[5,15,-51,20,-5,21,-5,1,5,0,-1],
14],[[-14,6,2,0,-12,44,-47,12,-4,2,3],10],[[3,9,-1,3,-6],10],[[-21,177,-524,
687,-396,80],0],[[-1,12,-64,108,-73,15],0],[[-11,107,-348,470,-277,57],0],[[1,
0,-2,4,-4,6,-3],10],[[-1,1,3,0,1,-6,3,-1],11],[[-2,4,-8,5,4,-3],5],[[5,-34,61,
-41,9],1],[[-1,3,-8,11,-7,-4,7,-1],5],[[1,-13,31,-19,4],1],[[1,-2,-4,6,-5,-1,
2,-1],5],[[],0],[[3,-7,5,-1],3],[[-1,24,-100,159,-104,22],0],[[-1,1],9],[[-1,
14,-6,-39,51,11,-67,49,-10,2,-1],4],[[7,-34,60,-40,0,4],2],[[-3,45,-171,251,
-152,33],0],[[-1,-5,6,-2,-4,4,-1],7],[[-4,21,-38,26,-4,-1],3],[[1,-2,1],3],
[[2,-5,3],3],[[1,-2,1],5],[[-1,10,-20,15,-4],2],[[-1,1],5],[[3,-7,6,-1],4],
[[-1],4],[[-6,32,-55,40,-12,1],2],[[1,-4,3],4],[[-1,10,-19,14,-3],2],[[2,-6,4,
-1],5],[[1,-16,62,-100,74,-23,2],1],[[-1,1],7]],,[[[5600],0],
[[-5600],60],[[20,0,0,-464,756,0,-624,0,756,-464,0,0,20],0],[[1380,-2840,
1380],0],[[30,-20,-42,0,70,-180,810,-1256,810,-180,70,0,-42,-20,30],8],[[],0],
[[320,-1400,2160,-1400,320],0],[[930,-1870,930],0],[[30,-64,84,0,-90,0,84,-64,
30],28],[[-100],40],[[100],20],[[15,-56,42,0,0,0,42,-56,15],8],[[33,-68,33],
20],[[134,-622,972,-622,134],0],[[10,-44,72,-44,10],20],[[20,0,-252,480,-252,
0,20],0],[[-16],33],[[-2,16,-12,-32,60,-32,-12,16,-2],4],[[101,-463,732,-463,
101],0],[[-25,92,-87,-97,226,-97,-87,92,-25],3],[[],0],[[4,-46,150,-216,150,
-46,4],0],[[35,-185,300,-185,35],0],[[],0],[[],0],[[],0],[[2,-7,4,-56,255,
-348,49,208,49,-348,255,-56,4,-7,2],0],[[20,-116,186,-116,20],0],[[4,-16,24,
-16,4],20],[[209,-933,1446,-933,209],0],[[-2,16,-12,-39,76,-39,-12,16,-2],3],
[[],0],[[3,14,-40,14,3],4],[[1,-6,22,-28,22,-6,1],20],[[3,2,-26,42,-26,2,3],
4],[[2,-21,74,-110,74,-21,2],0],[[26,-208,596,-824,596,-208,26],0],[[-2,22,
-44,22,-2],3],[[],0],[[1,-16,60,-90,60,-16,1],0],[[-3,17,-28,17,-3],1],[[],0],
[[-5,22,-34,22,-5],1],[[-2,16,-28,16,-2],2],[[],0],[[7,-12,7],3],[[-2],8],
[[-1],14],[[1],7],[[6,-57,179,-256,179,-57,6],0],[[3,-6,3],2],[[],0],[[2,-7,
-29,164,-262,164,-29,-7,2],0],[[2,-2,2],22],[[-2],13],[[2],11],[[1,-4,1],2],
[[1,0,1],11],[[11,-99,299,-420,299,-99,11],0],[[-14,70,-114,70,-14],2],[[],0],
[[3,-36,120,-174,120,-36,3],0],[[],0],[[],0],[[],0],[[-2800,2800],0],[[-594,
378,-84,0,0,84,-378,594],28],[[-670,2130,-2130,670],0],[[-9,11,0,212,-603,405,
312,-312,-405,603,-212,0,-11,9],0],[[-220,710,-710,220],0],[[9,-8,-5,5,-80,
233,-233,80,-5,5,8,-9],10],[[57,-138,18,219,-219,-18,138,-57],3],[[-9,11,117,
-375,375,-117,-11,9],0],[[-6,10,0,0,-10,6],14],[[6,-3,-15,15,3,-6],8],[[-45,
276,-609,609,-276,45],0],[[-445,1420,-1420,445],0],[[2,0,-5,0,11,-32,65,-65,
32,-11,0,5,0,-2],9],[[-9,30,-50,24,0,0,-24,50,-30,9],8],[[18,-3,3,-18],9],
[[-96,563,-1206,1206,-563,96],0],[[-9,64,-156,156,-64,9],0],[[-60,372,-810,
810,-372,60],0],[[8,-12,6,-6,12,-8],9],[[2,-5,2,-4,4,-2,5,-2],9],[[-1,-4,28,
-28,4,1],4],[[-3,32,-87,87,-32,3],0],[[-1,1,13,-35,35,-13,-1,1],4],[[11,-33,
33,-11],1],[[-1,3,3,-17,17,-3,-3,1],4],[[],0],[[-2,6,-6,2],2],[[-15,106,-249,
249,-106,15],0],[[1,-3,3,-1],6],[[5,-34,61,-5,-110,110,5,-61,34,-5],3],[[33,
-108,108,-33],2],[[-27,181,-411,411,-181,27],0],[[-1,3,4,-15,15,-4,-3,1],5],
[[3,-26,65,-65,26,-3],2],[[],0],[[-1,2,-2,1],2],[[1,-1],5],[[1,-10,23,-23,10,
-1],1],[[1,-1],4],[[-3,10,-10,3],3],[[],0],[[7,-38,77,-77,38,-7],1],[[-1,5,-5,
1],3],[[1,-9,19,-19,9,-1],1],[[-2,9,-9,2],4],[[-1,17,-78,150,-150,78,-17,1],
0],[[3,-3],6]],[[[3240],0],[[-3240],71],[[-36,144,0,-384,0,828,-624,0,0,72],
3],[[534,-1578,1128],0],[[-30,150,-416,390,-240,180,0,-144,-140,180,0,20,-36,
0,0,0,0,2],13],[[],0],[[84,-516,1152,-1104,384],0],[[270,-1053,864],0],[[-81],
37],[[],0],[[],0],[[-12,0,72,-96,27,0,18,0,-9],12],[[],0],[[18,-174,498,-564,
222],0],[[],0],[[-48,240,-276,0,72],2],[[12],37],[[-2,28,-40,-20,52,-8,-12,0,
0,2],7],[[9,-112,374,-454,185],0],[[2,-7,-29,127,-102,-111,208,-92,0,-5,7],4],
[[],0],[[-2,26,-92,144,-104,28],1],[[-25,140,-220,100],1],[[5],19],[[],0],[[],
0],[[21,-57,15,126,-21,-330,411,-156,6,-24,18],4],[[-9,84,-156,72],1],[[],0],
[[40,-303,760,-792,292],0],[[-3,-4,43,-58,-3,58,-32,0,0,2],5],[[],0],[[-12,24,
3,-18,3],6],[[],0],[[-3,21,-33,3,27,-15],6],[[9,-45,81,-63,18],2],[[2,-34,172,
-402,492,-302,72],0],[[-14,30,-14,-4,0,2],5],[[],0],[[6,-35,68,-54,15],2],
[[-8,22,-21,6],3],[[1],11],[[1,-12,30,-26,7],2],[[-8,24,-16,0,2],4],[[-2],19],
[[-3,12,-9],4],[[],0],[[],0],[[],0],[[-3,34,-116,176,-124,32],1],[[-1,6,-6,2],
3],[[],0],[[-3,33,-120,156,-63,-24,18],2],[[3],27],[[],0],[[],0],[[3,-3],4],
[[],0],[[-10,69,-195,268,-178,45],1],[[8,-48,82,-43,-5,7],3],[[],0],[[-1,19,
-73,121,-89,24],1],[[-1],15],[[],0],[[],0],[[-1323,1917],0],[[-378,189,-315,0,
-189,483,-378,0,15,0,0,-21],34],[[-213,963,-1404,660],0],[[12,-78,90,156,-228,
-351,741,-360,0,-30,42],3],[[-25,245,-544,320],0],[[45,-96,75,-45,50,13,-42,
-30,35,0,6,-7],15],[[-6,7,86,-179,-7,247,-160,0,0,12],4],[[18,-126,261,-159,
-30,42],2],[[-13,9,9,-7,-3,-3,2],18],[[6,6,-21,0,16,-6,0,-1],11],[[-3,49,-220,
412,-344,106],0],[[-105,594,-984,504],0],[[9,-34,31,-12,25,-23,-15,4,7,0,-1],
15],[[4,-8,-30,82,-65,18,-8,10,3,-6],12],[[-9,15,-3,-3],12],[[-15,144,-492,
780,-588,168],0],[[3,-39,117,-120,42],1],[[-6,80,-307,531,-425,127],0],[[-2,7,
-15,10,1,-1],12],[[-1,7,-11,5],14],[[4,-18,13,10,-11,2],6],[[-16,62,-73,27],
2],[[1,-10,27,-20,-10,21,-9],6],[[-3,25,-36,12],2],[[-1,-3,15,-14,-1,12,-6],
6],[[1,-2,0,1],9],[[-3,7,-5,1],4],[[9,-72,176,-171,57],1],[[-1,4,-3,1],7],[[3,
1,-41,83,-18,-98,112,-39,1,-4,3],5],[[-22,83,-76,0,12],3],[[-1,25,-135,277,
-247,80],0],[[-3,12,-10,-6,12,-2,-2],8],[[-1,14,-42,47,-17,-4,3],3],[[1,-1],
5],[[-1,3,-2],4],[[-1,2,-1],6],[[3,-14,22,-15,3],3],[[1],6],[[1,-7,11,-5],4],
[[],0],[[-2,17,-46,60,-36,8],2],[[-3,5,-3],5],[[3,-12,20,-13,3],3],[[-5,8,-3,
-1],6],[[-8,41,-94,109,-62,13],2],[[-2,4,-1],7]],,[[[3360],0],[[-3360],66],[[-112,288,0,-424,0,684,-464,0,0,28],3],
[[676,-1672,1012],0],[[-30,-60,300,-592,480,-240,170,0,-42,-80,90,0,0,-12],
12],[[],0],[[136,-664,1248,-1016,296],0],[[390,-1122,726],0],[[60,0,-70,0,60,
-64,0,0,20],32],[[-60],44],[[60],22],[[12,0,-14,0,48,-56,18,0,4],10],[[15,-48,
21],22],[[38,-264,550,-484,154],0],[[4,-24,50,-32,8],22],[[-96,280,-228,0,28],
2],[[16],36],[[-2,-8,44,-36,-16,28,-6,-4],6],[[25,-180,414,-378,119],0],[[-2,
15,-23,-53,150,-87,-84,130,-46,0,-1,1],3],[[],0],[[-8,50,-110,122,-66,12],1],
[[5,-55,165,-165,55],0],[[-5],18],[[],0],[[],0],[[-4,67,-127,1,144,16,-281,
300,-96,3,-10,5],3],[[-28,98,-116,28],1],[[-8,22,-16,2],23],[[75,-417,830,
-703,213],0],[[3,-6,-16,50,-39,-6,30,-14],4],[[],0],[[4,-18,16,2,-4],5],[[-2,
13,-24,20,-8,1],23],[[-9,26,-25,0,10,-2],6],[[-1,20,-54,64,-34,5],1],[[8,-70,
246,-456,448,-220,42],0],[[6,-22,26,-8],4],[[],0],[[-2,15,-43,53,-29,6],1],
[[3,-11,16,-10,2],2],[[],0],[[3,-15,21,-10,1],2],[[2,-12,16,-6],3],[[],0],
[[-5,7,-2],4],[[],0],[[],0],[[],0],[[1,-12,59,-134,148,-76,15],0],[[-2,3,-2],
3],[[],0],[[-9,67,-143,137,-45,-10,5],2],[[-6,4],25],[[2],14],[[-2],12],[[2],
4],[[-1,0,-1],12],[[2,-26,111,-225,235,-120,23],0],[[-2,21,-60,65,-24,-1,1],
2],[[],0],[[-6,37,-88,100,-54,10],1],[[1],14],[[],0],[[],0],[[-1512,1848],0],
[[-336,0,189,-315,0,0,315,-189],33],[[-302,1122,-1386,550],0],[[44,-194,162,
206,-218,-315,581,-252,0,-13,15],3],[[-60,330,-506,220],0],[[10,-10,-10,76,
-121,70,-35,25,9,-3,-10,15,0,1,-1],12],[[5,-30,12,123,-179,-12,166,-87,0,0,2],
3],[[42,-180,259,-123,-13,15],2],[[-7,9,3,-5],18],[[-6,-3,12,6,-12,0,6,-3],9],
[[-11,92,-285,403,-262,63],0],[[-170,726,-946,396],0],[[-5,0,19,-41,31,-21,20,
-9,0,-1,1],13],[[-6,6,8,-6,-24,48,-41,9,-2,2],10],[[6,-9,9],11],[[-34,225,
-601,782,-483,113],0],[[11,-60,108,-76,15],1],[[-17,137,-391,527,-337,81],0],
[[1,-6,9,-9,5],11],[[3,-3,4,-4,2],13],[[-2,10,-18,7,3,-2],5],[[5,-30,58,-43,
12],1],[[4,-18,25,-13,-5,6,-1],6],[[-8,23,-17,2],2],[[1,-1,-8,9,-4,-2,6,-1],
5],[[1,0,-1],9],[[1,-3,4,-2],3],[[-2,26,-104,168,-116,29],0],[[-1,1,-1],7],
[[-3,13,7,-67,79,-7,-69,64,-16,0,-1],4],[[5,-42,80,-45,0,2],2],[[-4,55,-186,
269,-183,45],0],[[3,-8,15,-8,-2,5,-1],7],[[-6,25,-42,33,-9,-1],3],[[],0],[[-1,
1],4],[[-1,1],6],[[-1,6,-14,14,-6,1],2],[[],0],[[2,-6,5,-1],4],[[],0],[[-7,27,
-48,43,-18,2],2],[[1,-2,3,-1],4],[[5,-12,11,-4],3],[[2,-6,5,-1],5],[[3,-18,59,
-96,81,-33,5],1],[[-2,1],7]],,[[[7168],0],[[-7168],60],[[16,0,0,
-512,1008,0,-1024,0,1008,-512,0,0,16],0],[[1792,-3584,1792],0],[[30,-40,-48,0,
180,-360,990,-1504,990,-360,180,0,-48,-40,30],8],[[],0],[[448,-1792,2688,
-1792,448],0],[[1152,-2432,1152],0],[[45,0,-36,0,110,0,-36,0,45],28],[[16],
40],[[-16],20],[[-48,72,0,-80,0,72,-48],9],[[32],21],[[184,-784,1192,-784,
184],0],[[2,16,-28,16,2],20],[[16,0,-336,640,-336,0,16],0],[[],0],[[-2,16,-20,
-48,108,-48,-20,16,-2],4],[[128,-576,896,-576,128],0],[[-28,112,-96,-176,376,
-176,-96,112,-28],3],[[],0],[[8,-64,176,-240,176,-64,8],0],[[40,-216,360,-216,
40],0],[[-4,0,0,0,-4],14],[[-2],24],[[2],12],[[2,-6,2,-80,338,-422,-6,344,-6,
-422,338,-80,2,-6,2],0],[[16,-128,224,-128,16],0],[[2,8,-20,8,2],20],[[288,
-1184,1792,-1184,288],0],[[-4,20,-12,-68,128,-68,-12,20,-4],3],[[],0],[[24,
-48,24],5],[[1,2,-13,20,-13,2,1],20],[[2,2,-38,68,-38,2,2],4],[[2,-26,82,-116,
82,-26,2],0],[[46,-288,736,-988,736,-288,46],0],[[-4,30,-52,30,-4],3],[[],0],
[[2,-20,64,-92,64,-20,2],0],[[-4,16,-24,16,-4],1],[[],0],[[-4,20,-32,20,-4],
1],[[-2,16,-28,16,-2],2],[[],0],[[6,-14,6],3],[[2],8],[[1],14],[[-1],7],[[10,
-74,208,-288,208,-74,10],0],[[2,-4,2],2],[[],0],[[2,-6,-52,218,-324,218,-52,
-6,2],0],[[-3,6,-3],22],[[],0],[[],0],[[],0],[[],0],[[20,-136,360,-488,360,
-136,20],0],[[-20,88,-136,88,-20],2],[[],0],[[6,-48,138,-190,138,-48,6],0],
[[-2],13],[[1],8],[[-1],4],[[-3584,3584],0],[[35,-189,378,-294,0,0,294,-378,
189,-35],27],[[-896,2688,-2688,896],0],[[-8,8,0,256,-760,504,512,-512,-504,
760,-256,0,-8,8],0],[[-256,896,-896,256],0],[[9,-9,-20,30,-95,257,-257,95,-30,
20,9,-9],10],[[56,-168,24,376,-376,-24,168,-56],3],[[-8,8,168,-488,488,-168,
-8,8],0],[[-9,17,-6,6,-17,9],14],[[9,-9,-18,18,9,-9],8],[[-64,352,-736,736,
-352,64],0],[[-576,1792,-1792,576],0],[[5,-5,-19,15,40,-40,-15,19,5,-5],11],
[[24,-60,36,40,-40,-36,60,-24],9],[[-1,3,-3,1],9],[[-144,736,-1488,1488,-736,
144],0],[[-8,72,-176,176,-72,8],0],[[-92,484,-988,988,-484,92],0],[[1,1,-8,8,
-1,-1],9],[[1,-1,0,6,-6,0,1,-1],9],[[-12,36,-36,12],5],[[-4,36,-92,92,-36,4],
0],[[-1,0,20,-53,53,-20,0,1],4],[[8,-32,32,-8],1],[[-2,3,7,-22,22,-7,-3,2],4],
[[-1,-1,1,1],7],[[-2,4,-4,2],2],[[-20,128,-288,288,-128,20],0],[[1,-3,3,-1],
6],[[8,-46,70,28,-184,184,-28,-70,46,-8],3],[[40,-136,136,-40],2],[[-40,232,
-488,488,-232,40],0],[[-1,2,8,-27,27,-8,-2,1],5],[[6,-36,74,-74,36,-6],2],[[],
0],[[],0],[[2,-2],5],[[2,-10,20,-20,10,-2],1],[[],0],[[-3,10,-10,3],3],[[-1,
1],3],[[-1,12,-45,80,-80,45,-12,1],0],[[-1,3,-3,1],3],[[1,-8,17,-17,8,-1],1],
[[-3,9,-9,3],4],[[-3,27,-93,164,-164,93,-27,3],0],[[3,-3],6]],[[[4096],0],
[[-4096],135,false],[[-128,288,0,-448,0,864,-640,0,0,64],3],[[768,-2048,1280],
0],[[10,-60,330,-744,630,-180,110,0,-132,-80,120,0,20,-24],12],[[],0],[[128,
-768,1536,-1280,384],0],[[448,-1344,960],0],[[-60,0,0,0,10,0,0,0,-84,0,64,0,0,
0,0,0,0,0,0,0,6],65,false],[[64],45],[[-64],45,false],[[6,0,-10,0,66,-112,36,
0,12,0,-6],10],[[-16,0,48,0,-24],45,false],[[40,-288,680,-640,200],0],[[-4,0,
24,0,-44,0,40,0,-8],45,false],[[-96,320,-288,0,64],2],[[],0],[[-2,-8,40,-40,
-18,40,-4,-8],6],[[24,-200,512,-504,168],0],[[-1,12,-24,-36,152,-104,-116,188,
-71,0,-4,4],3],[[],0],[[-8,56,-144,168,-88,16],1],[[4,-60,204,-236,84],0],[[1,
0,0,0,0,0,0,0,6,0,0,0,-4,0,0,0,1],27,false],[[-4],27],[[4],27,false],[[-8,58,
-130,50,144,-12,-376,396,-120,10,-22,10],3],[[-32,128,-160,64],1],[[8,0,-20,0,
16,0,-4],47,false],[[72,-472,1024,-904,280],0],[[2,-6,-6,48,-58,-6,46,-20],4],
[[],0],[[2,-18,22,4,-12,2],5],[[2,0,-9,0,20,0,-22,0,10,0,-1],47,false],[[-7,
24,-29,4,18,-10],6],[[-2,24,-74,94,-52,10],1],[[4,-64,288,-572,576,-288,56],
0],[[4,-24,32,-8,-4],4],[[],0],[[-1,18,-60,78,-43,8],1],[[3,-17,27,-14,2],2],
[[-1],21,false],[[5,-24,35,-20,4],2],[[2,-16,26,-12],3],[[],0],[[-7,14,-6],4],
[[-1],15,false],[[1],15],[[-1],15,false],[[-10,70,-176,202,-108,22],1],[[-4,8,
-4],3],[[],0],[[-6,62,-170,176,-50,-22,10],2],[[2,0,-4,0,2],51,false],[[],0],
[[],0],[[-2,4,-2],3],[[],0],[[1,-23,129,-288,311,-161,31],0],[[-1,20,-72,88,
-35,-4,4],2],[[],0],[[-5,43,-117,139,-75,14],1],[[1,0,-1,0,1],27,false],[[-1],
9],[[1],9,false],[[-1792,2304],0],[[-512,0,0,84,0,-378,0,594,0,-315,0,0,0,
-189,0,378,0,-189,0,0,0,15],63,false],[[-320,1344,-1728,704],0],[[48,-188,180,
184,-264,-396,772,-336,0,-32,32],3],[[-64,384,-640,320],0],[[-15,96,-172,95,
-10,21,17,-37,-10,15,-1,2,-1],14],[[4,-28,12,116,-188,-12,228,-140,0,0,8],3],
[[36,-196,316,-156,-32,32],2],[[-11,12,6,-4,-3],18],[[-6,9,8,-15,-3,10,-3],
10],[[-8,96,-344,520,-352,88],0],[[-184,848,-1200,520],0],[[5,0,0,0,-5,19,16,
-50,-5,31,0,4,5,10,0,-14,0,-5,0,4,0,1],25,false],[[6,3,-7,-30,92,-74,18,-6,6,
3,-3],11],[[-8,3,0,-9,0,9,0,-3],21,false],[[-26,240,-726,986,-624,150],0],
[[12,-76,148,-116,32],1],[[-14,142,-470,674,-442,106],0],[[-2,1,8,-2,-2,7,0,
-13,0,8,0,-1],21,false],[[2,0,-4,2,2,-1,0,7,0,-11,0,3],23,false],[[9,-21,10,8,
-7,1],6],[[4,-36,84,-68,16],1],[[2,-14,28,-18,-7,14,-5],6],[[-12,36,-32,8],2],
[[1,-2,-4,17,-15,-2,6,-1],5],[[1,-2,1],9],[[2,-6,6,-2],3],[[-1,26,-126,226,
-166,43],0],[[-1,-2,3,0,-3,0,1],14,false],[[-2,11,-8,-51,97,-12,-101,90,-23,1,
-3,1],4],[[4,-44,100,-68,0,8],2],[[-4,56,-220,356,-248,60],0],[[-5,15,-10,-6,
7,-1],8],[[-4,28,-56,45,-11,-3,1],3],[[-1,1],4],[[1,-3,3,-1],3],[[-2,2],6],
[[-1,10,-22,21,-8,1],2],[[-1,-1,0,1],9,false],[[3,-11,10,-3],4],[[1],7,false],
[[-8,37,-67,59,-24,3],2],[[1,-5,5,-1],4],[[-1,9,-20,19,-8,1],2],[[2,-8,7,-1],
5],[[1,-21,78,-130,110,-46,7],1],[[1,-3,0,3],13,false]],,[[[4200],0],[[-4200],
63],[[8,0,0,-180,468,0,-616,0,720,-416,0,0,16],0],[[950,-2090,1160],0],[[-30,
0,40,-150,510,-912,630,-300,240,0,-48,-60,60],10],[[],0],[[224,-932,1560,
-1168,316],0],[[570,-1425,780],0],[[64,-24,0,40,0,-24,64,-45],30],[[60],42],
[[-60],21],[[-16,42,0,-40,0,60,-40,9],9],[[-21,30,-24],21],[[74,-392,692,-522,
154],0],[[-8,20,-32,24,-10],21],[[8,0,-156,376,-240,0,16],0],[[-4],33],[[4,
-10,-18,60,-36,-16,20,-4],5],[[50,-275,518,-399,108],0],[[-7,36,-35,-101,227,
-115,-76,102,-33],3],[[],0],[[2,-22,78,-136,126,-60,12],0],[[10,-95,205,-160,
40],0],[[],0],[[],0],[[],0],[[1,-3,1,-20,127,-194,-21,212,9,-299,271,-88,1,-5,
5],0],[[8,-45,128,-104,16],0],[[-2,6,-8,8,-4],21],[[131,-604,1036,-787,217],
0],[[4,-6,-38,81,-46,-6,24,-6],4],[[],0],[[14,-32,20,1],5],[[-1,2,-8,8,-8,6,
-2],21],[[4,-22,44,-31,1,4],5],[[1,-8,32,-65,62,-27,5],0],[[20,-126,362,-564,
498,-226,38],0],[[10,-30,24,-6],4],[[],0],[[-5,25,-50,49,-22,3],1],[[5,-13,13,
-6,1],2],[[],0],[[-1,6,-16,17,-6],1],[[6,-16,12,-4],3],[[2],17],[[2,-7,5],3],
[[],0],[[],0],[[],0],[[3,-26,92,-161,150,-68,10],0],[[-2,2],3],[[],0],[[1,-3,
-20,108,-188,147,-44,-5,5],0],[[-1],25],[[-2],12],[[2],11],[[1],4],[[1,-2],
11],[[7,-54,168,-277,251,-116,20],0],[[-7,39,-78,66,-19],2],[[],0],[[1,-16,59,
-106,101,-47,8],0],[[],0],[[],0],[[],0],[[-1995,2205],0],[[378,-504,0,0,315,
-378,189,-315,0,0,105],29],[[-457,1479,-1656,608],0],[[-4,4,0,84,-321,243,314,
-302,-342,570,-224,0,-6,10],0],[[-105,465,-580,200],0],[[5,-5,0,5,-25,146,
-171,85,-60,50,4,-9,-10,5],10],[[14,-59,12,208,-247,-12,144,-60],3],[[-4,4,75,
-263,308,-126,-6,10],0],[[6,0,3,-13,9,0,-3],15],[[3,-6,-6,15,0,-9,0,3],8],
[[-25,156,-385,463,-265,56],0],[[-270,980,-1110,415],0],[[-9,5,25,-51,11,-17,
20,0,1,-1,1],13],[[8,-32,18,24,-16,-30,46,-24,9],9],[[-9,6],12],[[-66,353,
-801,921,-523,111],0],[[-4,25,-82,118,-62,10],0],[[-37,225,-526,614,-354,78],
0],[[-1,-3,1,7,-7,3],10],[[-1,-1,5,-3,-1,3,-2,1],10],[[-8,22,-26,10,1],5],
[[10,-45,59,-33,7],1],[[-2,14,-33,37,-15,-1,2],5],[[2,-12,22,-10],1],[[1,3,
-16,14,-3,-2,2,-1],5],[[1,-1],10],[[1,-3,3,-1],3],[[-5,50,-144,184,-106,21],
0],[[1,-3,2],6],[[1,-14,23,23,-111,112,-10,-59,46,-14],3],[[14,-67,92,-36],2],
[[-13,98,-255,307,-178,42],0],[[1,2,-14,15,-5,-3,4,-1],6],[[2,-14,37,-48,30,
-7],2],[[],0],[[1],5],[[-1],6],[[-2,8,-13,11,-4],2],[[],0],[[-1,4,-6,3],3],
[[],0],[[3,-15,37,-52,41,-16,2],1],[[1,-2,1],4],[[-2,6,-11,9,-3],2],[[4,-6,4,
-1],5],[[-1,8,-35,79,-104,79,-29,3],0],[[2,-2],6]],,[[[4536],0],[[-4536],65],[[-144,396,0,
-696,0,900,-492,0,0,36],3],[[960,-2238,1338],0],[[110,-180,450,-856,720,-360,
180,0,-108,-80,60,0,10,-6],12],[[],0],[[204,-960,1656,-1308,408],0],[[540,
-1539,918],0],[[81],35],[[],0],[[],0],[[18,0,-60,0,108,-72,0,0,6],10],[[],0],
[[72,-366,726,-624,192],0],[[],0],[[-132,408,-300,0,36],2],[[-12],37],[[-6,
-16,66,-48,-24,32,-2,-2],6],[[39,-257,544,-473,145],0],[[-3,22,-26,-91,257,
-165,-90,146,-49,0,-1,2],3],[[],0],[[2,-20,72,-136,142,-78,18],0],[[6,-74,211,
-203,56],0],[[-1,0,4,0,-6,0,8,0,-1],13],[[6],26],[[-6],13],[[-24,102,-159,0,
234,-57,-354,357,-108,3,-12,9],3],[[-36,132,-123,36],1],[[],0],[[119,-597,
1100,-900,281],0],[[4,-5,-24,90,-82,-5,30,-11],4],[[],0],[[6,-36,36,0,-6],5],
[[],0],[[-15,51,-48,6,9,-3],6],[[-6,30,-63,69,-39,9],1],[[14,-118,364,-590,
548,-282,64],0],[[8,-28,30,-8,-2],4],[[],0],[[-3,21,-49,55,-30,6],1],[[3,-11,
15,-8,1],2],[[],0],[[5,-15,18,-10,2],2],[[2,-14,20,-6],3],[[-2],19],[[-6,9,
-3],4],[[],0],[[],0],[[],0],[[1,-21,87,-165,167,-89,20],0],[[-1,2,-1],3],[[],
0],[[-18,93,-195,186,-60,-12,9],2],[[-3],25],[[],0],[[],0],[[],0],[[],0],[[5,
-48,164,-285,279,-148,34],0],[[-3,31,-81,83,-32,-1,2],2],[[],0],[[1,-13,54,
-107,112,-62,14],0],[[-1,3,-1],13],[[],0],[[],0],[[-2079,2457],0],[[-210,0,0,
714,-756,189,-105,0,-189,168,-189],30],[[-444,1548,-1809,735],0],[[72,-261,
207,306,-390,-405,711,-276,0,-15,21],3],[[-80,460,-659,259],0],[[-10,30,-40,
125,-161,90,-35,45,9,-29,-10,5,0,1],12],[[6,-39,11,220,-304,-11,197,-83,0,0,
3],3],[[63,-255,357,-165,-15,21],2],[[-6,6,-21,9,6],16],[[-9,9,12,-18,0,6],
10],[[-18,143,-389,503,-322,83],0],[[-255,990,-1248,504],0],[[-5,5,15,14,-35,
1,23,10,-14,-5,-1,1],12],[[-6,12,24,-36,-48,92,-40,0,-2,4],10],[[6,-6,-6,6],
10],[[-54,345,-828,996,-615,159],0],[[18,-81,123,-84,21],1],[[-33,211,-533,
669,-424,110],0],[[1,-7,11,3,-10,2],10],[[6,-11,1,7,-3],12],[[-2,20,-36,20,2,
-4],5],[[6,-35,67,-47,9],1],[[6,-31,50,-30,0,7,-2],6],[[-9,23,-15,3],2],[[1,
-1,-10,23,-16,-1,3,-1],5],[[1,-1],9],[[1,-2,2,-1],3],[[-3,39,-138,202,-135,
33],0],[[-1,5,-3,1],7],[[1,-8,16,11,-104,150,-47,-74,73,-21,0,-1,1],3],[[6,
-59,109,-56,0,3],2],[[-12,87,-246,338,-223,57],0],[[1,-11,21,-11,-5,5,-1],7],
[[1,-10,34,-53,41,-13,-1,1],2],[[],0],[[],0],[[],0],[[-2,7,-12,11,-5,1],2],
[[],0],[[3,-7,6,-2],4],[[],0],[[3,-15,36,-51,44,-22,5],1],[[-2,2],5],[[-2,6,
-10,9,-5,1],2],[[3,-6,5,-1],5],[[7,-34,79,-106,87,-41,9],1],[[-4,3],7]],
,[[[5600],0],[[-5600],63],[[8,0,0,-336,612,0,-656,0,936,
-608,0,0,44],0],[[1240,-2840,1520],0],[[-20,-18,0,140,-120,660,-1304,870,-150,
130,0,-132,-40,60,0,10,-6],9],[[],0],[[248,-1264,2160,-1536,392],0],[[800,
-1860,1080],0],[[-30,0,-24,0,0,0,0,64,-30],29],[[20],42],[[-20],21],[[3,-24,
24,0,-12,0,72,-88,30,0,6],8],[[-8,6,-9],21],[[98,-524,974,-724,178],0],[[-2,8,
-8,4,-4],21],[[8,0,-204,448,-312,0,44],0],[[16],36],[[8,-10,-24,66,-38,-22,24,
-2,-2],5],[[67,-386,730,-554,143],0],[[-9,54,-64,-71,223,-120,-116,148,-44,0,
-2,1],3],[[],0],[[2,-28,122,-220,184,-68,8],0],[[20,-140,300,-240,60],0],[[],
0],[[],0],[[],0],[[-2,4,-36,171,-282,79,214,-1,-431,357,-84,10,-15,4],1],[[8,
-84,196,-152,44],0],[[-2,0,2,2,-2],21],[[156,-816,1448,-1052,268],0],[[-2,6,
-9,-18,67,-62,-9,30,-7],3],[[],0],[[-1,8,-24,24,2,-6],4],[[2,-2,-2,0,0,-1],
22],[[1,-15,33,-31,6,9,-3],5],[[-11,59,-115,99,-36,4],1],[[14,-150,520,-830,
672,-270,42],0],[[-2,14,-38,34,-4,-2],3],[[],0],[[-8,46,-93,80,-28,3],1],[[-1,
12,-30,26,-7],1],[[],0],[[-1,17,-40,34,-11,1],1],[[10,-26,22,-6],3],[[],0],
[[3,-12,11,-3],3],[[1],7],[[-1],14],[[1],7],[[2,-34,148,-260,218,-86,12],0],
[[2,-9,8,-1],2],[[],0],[[-2,-17,128,-252,191,-41,-15,4],1],[[2,0,2],23],[[2],
15],[[-2],12],[[1,-6,4],2],[[2,-1],13],[[5,-66,252,-425,351,-137,20],0],[[-7,
51,-106,89,-26,-2,1],2],[[],0],[[1,-21,96,-178,150,-55,7],0],[[],0],[[],0],
[[],0],[[-2660,2940],0],[[-405,0,-189,0,0,504,-378,594,-595,0,-189,378],28],
[[-564,2028,-2232,776],0],[[-2,6,0,144,-453,351,288,-368,-468,788,-288,0,-25,
19],0],[[-160,640,-780,300],0],[[-4,-15,19,-50,218,-268,95,-4,16,22,-28,0,0,
-1],11],[[28,-89,21,197,-238,-21,198,-99,0,0,3],3],[[-2,6,87,-329,392,-156,
-25,19],0],[[-3,10,3,0,-15,12,3,-2],14],[[3,4,-18,12,10,-9,-3,1],8],[[-26,212,
-564,660,-350,68],0],[[-360,1320,-1520,540],0],[[-1,0,0,5,-10,51,-50,10,9,10,
0,-5,0,1],10],[[11,-22,18,3,-9,-36,84,-58,12,-4,2],9],[[-9,0,-1,9],10],[[-64,
460,-1140,1276,-668,132],0],[[-2,42,-141,183,-97,19],0],[[-39,293,-755,871,
-453,87],0],[[-4,3,0,2,-9,4],10],[[-1,0,-3,1,1,5,-5,1],10],[[-3,17,-25,10,4,
-2],5],[[-1,19,-74,104,-53,7],0],[[6,-24,34,-19,-3,5,-1],6],[[4,-31,45,-21,3],
1],[[-1,2,1,-8,19,-12,-3,2],4],[[-1,1,1,-1],7],[[-1,6,-9,4],2],[[-7,73,-224,
280,-149,27],0],[[1,-1,2,-3,1],6],[[1,-15,42,-15,-89,127,-6,-93,59,-11,1,-1],
3],[[20,-85,118,-56,0,3],2],[[-16,133,-375,453,-237,42],0],[[1,-1,-10,20,-7,
-5,2],6],[[1,-16,54,-70,38,-6,-1],2],[[1,-2,1],3],[[4,-5,2],3],[[1,-3,1],5],
[[-6,22,-29,16,-3],2],[[1,-1],4],[[-1,8,-12,7,-1],3],[[-1],4],[[3,-26,72,-89,
52,-13,1],1],[[4,-6,2],4],[[-5,20,-27,15,-3],2],[[-1,6,-10,5],4],[[8,-56,141,
-168,102,-30,3],1],[[1,-3,2],6]],]);

CHEVIE.AddData("CycPolSchurElements","E8",
 [ [1,0,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,6,6,6,6,7,8,8,9,10,10,12,12,14,15,
18,20,24,30],
  [1,-120,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,6,6,6,6,7,8,8,9,10,10,12,12,14,
15,18,20,24,30],
  [2,-3,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,8,9,10,10,12,30],
  [2,-63,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,8,9,10,10,12,30],
  [1,-2,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,6,6,8,8,9,10,12,12,18,24],
  [1,-74,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,6,6,8,8,9,10,12,12,18,24],
  [30,-16,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,30],
  [2,-4,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,7,9,10,12,12],
  [2,-52,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,7,9,10,12,12],
  [2,-3,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,8,10,10,12,15,18],
  [2,-63,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,8,10,10,12,15,18],
  [8,-16,2,2,2,2,2,2,2,2,3,3,3,3,5,5,6,6,6,6],
  [3,-8,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,8,8],
  [3,-32,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,8,8],
  [2,-4,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,6,6,12,12,14,18],
  [2,-52,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,6,6,12,12,14,18],
  [5,-16,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6],
  [2,-6,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,7,8,12,18],
  [2,-42,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,7,8,12,18],
  [6,-8,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,24],
  [6,-32,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,24],
  [1,-12,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,8,8,12,12],
  [1,-36,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,8,8,12,12],
  [1,-6,2,2,2,2,2,2,2,2,3,4,4,4,4,5,5,6,8,8,10,10,20],
  [1,-46,2,2,2,2,2,2,2,2,3,4,4,4,4,5,5,6,8,8,10,10,20],
  [6,-16,2,2,2,2,2,2,2,2,4,4,4,4,5,5,6,18],
  [2,-13,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,9],
  [2,-25,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,9],
  [2,-6,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,9,12,14],
  [2,-42,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,9,12,14],
  [24,-16,2,2,2,2,2,2,2,2,3,3,3,3,10,10,12,12],
  [2,-12,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,6,6,6,6,12],
  [2,-24,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,6,6,6,6,12],
  [20,-16,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,20],
  [2,-10,2,2,2,2,2,2,2,2,4,4,5,5,6,7,8,10,10],
  [2,-30,2,2,2,2,2,2,2,2,4,4,5,5,6,7,8,10,10],
  [2,-8,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,12,12],
  [2,-32,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,12,12],
  [1,-20,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,6,6,6,6,12,12],
  [2,-7,2,2,2,2,3,3,3,3,4,4,5,5,6,6,8,12,15],
  [2,-37,2,2,2,2,3,3,3,3,4,4,5,5,6,6,8,12,15],
  [8,-16,3,3,3,3,4,4,4,4,5,5,12,12],
  [6,-8,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,8,8,12,12],
  [6,-32,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,8,8,12,12],
  [3,-8,2,2,2,2,2,2,2,2,3,4,4,4,4,6,8,8,9,18],
  [3,-32,2,2,2,2,2,2,2,2,3,4,4,4,4,6,8,8,9,18],
  [6,-16,2,2,2,2,2,2,2,2,3,4,4,4,4,9,10,10],
  [2,-13,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,18],
  [2,-25,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,18],
  [8,-16,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,10,10],
  [2,-10,2,2,2,2,3,3,3,3,4,4,5,6,6,8,9,12],
  [2,-28,2,2,2,2,3,3,3,3,4,4,5,6,6,8,9,12],
  [120,-16,3,3,3,3,4,4,4,4,6,6,6,6,10,10],
  [2,-10,2,2,2,2,2,2,2,2,3,4,4,5,5,8,10,10,14],
  [2,-30,2,2,2,2,2,2,2,2,3,4,4,5,5,8,10,10,14],
  [24,-16,2,2,2,2,2,2,2,2,5,5,6,6,6,6,12,12],
  [1,-14,2,2,2,2,2,2,2,2,3,4,4,4,4,5,6,8,8,10],
   [1,-22,2,2,2,2,2,2,2,2,3,4,4,4,4,5,6,8,8,10],
  [30,-16,2,2,2,2,2,2,2,2,4,4,4,4,6,6,6,6,15],
  [2,-15,2,2,2,2,3,3,3,3,4,4,6,6,7,9,12],
  [2,-21,2,2,2,2,3,3,3,3,4,4,6,6,7,9,12], [2,-11,2,3,3,3,3,5,5,7,9,15],
  [2,-26,2,3,3,3,3,5,5,7,9,15],
  [2,-12,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,10,12],
  [2,-24,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,10,12],
  [1,-14,2,2,2,2,2,2,2,2,4,4,4,4,7,8,8,14],
  [1,-22,2,2,2,2,2,2,2,2,4,4,4,4,7,8,8,14],
  [1,-1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,7,8,9,10,10,12,14,15,18,30],
  [1,-91,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,7,8,9,10,10,12,14,15,18,30]
    , [6,-7,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,30],
  [6,-37,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,6,6,30],
  [2,-3,2,2,2,2,3,3,3,3,4,4,4,4,5,5,6,6,8,9,12,12,15,20],
  [2,-63,2,2,2,2,3,3,3,3,4,4,4,4,5,5,6,6,8,9,12,12,15,20],
  [2,-4,2,2,2,2,3,3,3,3,4,4,5,6,6,7,8,8,9,12,24],
  [2,-52,2,2,2,2,3,3,3,3,4,4,5,6,6,7,8,8,9,12,24],
  [12,-16,2,2,2,2,3,3,3,3,4,4,5,5,24],
  [2,-6,2,2,2,2,3,3,3,3,4,4,4,4,6,6,7,8,9,12,12],
  [2,-42,2,2,2,2,3,3,3,3,4,4,4,4,6,6,7,8,9,12,12],
  [3,-7,2,2,2,2,2,2,2,2,3,3,3,3,5,5,6,6,6,6,10,10,12],
  [3,-37,2,2,2,2,2,2,2,2,3,3,3,3,5,5,6,6,6,6,10,10,12],
  [1,-5,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,6,6,6,6,9,10,12,18],
  [1,-47,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,6,6,6,6,9,10,12,18],
  [4,-16,2,2,2,2,3,3,3,3,4,4,5,5,6,6,12],
  [2,-10,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,6,6,6,6,18],
  [2,-28,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,6,6,6,6,18],
  [3,-7,2,2,2,2,2,2,2,2,3,4,4,5,5,6,9,10,10,18],
  [3,-37,2,2,2,2,2,2,2,2,3,4,4,5,5,6,9,10,10,18],
  [6,-16,2,2,2,2,3,4,4,5,5,8,8,9], [2,-10,2,2,2,2,3,4,4,4,4,5,5,7,8,20],
  [2,-30,2,2,2,2,3,4,4,4,4,5,5,7,8,20],
  [2,-10,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,9,10],
  [2,-28,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,9,10],
  [6,-7,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,10,10,15],
  [6,-37,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,10,10,15],
  [2,-15,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,7,18],
  [2,-21,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,7,18],
  [2,-13,2,2,2,2,3,3,3,3,4,4,4,4,8,9,12,12],
  [2,-25,2,2,2,2,3,3,3,3,4,4,4,4,8,9,12,12],
  [6,-16,2,2,2,2,3,3,3,3,4,4,8,8,15],
  [1,-9,2,2,2,2,2,2,2,2,3,4,4,5,6,7,8,10,14],
  [1,-31,2,2,2,2,2,2,2,2,3,4,4,5,6,7,8,10,14],
  [2,-12,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,12,12],
  [2,-24,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,12,12],
  [12,-16,3,3,3,3,5,5,6,6,8,8,12], [2,-11,2,3,3,3,3,5,5,7,9,15],
  [2,-26,2,3,3,3,3,5,5,7,9,15],
  [1,-15,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,12],
  [1,-21,2,2,2,2,2,2,2,2,3,3,3,3,4,4,6,6,6,6,8,12],
  [1,-13,2,2,2,2,2,2,2,2,3,4,4,5,5,6,8,10,10],
  [1,-23,2,2,2,2,2,2,2,2,3,4,4,5,5,6,8,10,10],
  [2,-15,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,9,14],
  [2,-21,2,2,2,2,2,2,2,2,3,3,3,3,6,6,6,6,9,14] ]);

CHEVIE.AddData("cycpolfakedegrees","E8",
[[1,0],[1,120],[1,8,7,8,8,14,15,24,30],[1,68,7,8,8,14,15,24,30],[1,2,5,7,10,
14,15,20,30],[1,74,5,7,10,14,15,20,30],[[1,-1,1,1,-1,1,1,-2,4,0,-2,4,-2,0,4,
-2,1,1,-1,1,1,-1,1],32,7,14],[1,8,5,5,10,10,15,20,30,32],[1,56,5,5,10,10,15,
20,30,32],[1,4,7,8,9,14,18,24,32],[1,64,7,8,9,14,18,24,32],[[1,0,1,-1,2,-2,2,
-1,4,-1,2,-2,2,-1,1,0,1],24,7,9,14,15,18,30],[[1,-1,0,0,0,1,0,0,0,-1,1],12,5,
5,7,10,10,14,15,20,30],[[1,-1,0,0,0,1,0,0,0,-1,1],36,5,5,7,10,10,14,15,20,30],
[1,4,5,7,9,10,14,15,16,18,20,30],[1,52,5,7,9,10,14,15,16,18,20,30],[[1,1,-1,
-3,0,5,5,-2,-7,-2,5,5,0,-3,-1,1,1],20,7,8,8,9,12,12,14,18,24],[1,8,5,5,8,8,9,
10,10,15,18,20,24,30],[1,44,5,5,8,8,9,10,10,15,18,20,24,30],[[1,-1,1,1,-2,1,1,
-1,1],14,5,5,7,10,10,14,15,20,30],[[1,-1,1,1,-2,1,1,-1,1],38,5,5,7,10,10,14,
15,20,30],[1,12,5,5,7,9,10,10,14,15,18,20,24,30],[1,36,5,5,7,9,10,10,14,15,18,
20,24,30],[1,6,3,3,3,6,6,6,7,9,12,12,14,15,18,24,30],[1,46,3,3,3,6,6,6,7,9,12,
12,14,15,18,24,30],[[1,0,1,2,1,2,5,0,1,6,2,2,8,2,2,6,1,0,5,2,1,2,1,0,1],20,7,
9,14,18,20],[1,16,5,5,7,8,8,10,10,14,15,20,24,24,30],[1,28,5,5,7,8,8,10,10,14,
15,20,24,24,30],[1,6,5,5,7,8,10,10,14,15,16,20,24,30],[1,42,5,5,7,8,10,10,14,
15,16,20,24,30],[[1,-1,2,0,-1,2,2,-2,2,2,-1,0,2,-1,1],20,5,5,7,10,10,14,15,20,
30],[1,14,5,7,8,8,9,10,14,15,16,18,20,24,30],[1,26,5,7,8,8,9,10,14,15,16,18,
20,24,30],[[1,1,1,-1,2,2,1,0,1,4,1,0,1,2,2,-1,1,1,1],22,7,8,8,9,14,18,24],[1,
12,3,3,3,3,6,6,6,6,8,8,9,12,12,15,18,24,24,30],[1,32,3,3,3,3,6,6,6,6,8,8,9,12,
12,15,18,24,24,30],[[1,0,1,-2,1,0,1],10,5,5,7,9,10,10,14,15,18,20,30],[[1,0,1,
-2,1,0,1],34,5,5,7,9,10,10,14,15,18,20,30],[1,20,5,5,7,8,8,9,10,10,14,15,18,
20,24,30],[[1,1,0,-2,0,1,1],8,4,4,4,7,8,8,9,12,12,14,18,20,24],[[1,1,0,-2,0,1,
1],38,4,4,4,7,8,8,9,12,12,14,18,20,24],[[2,1,3,2,5,1,4,1,5,2,3,1,2],20,7,8,8,
9,14,15,18,24,30],[[1,-1,0,2,0,-1,1],8,5,5,7,8,8,10,10,14,15,20,24,30],[[1,-1,
0,2,0,-1,1],32,5,5,7,8,8,10,10,14,15,20,24,30],[[1,1,-1,1,-1,1,1],10,5,5,7,9,
10,10,14,15,18,20,30],[[1,1,-1,1,-1,1,1],34,5,5,7,9,10,10,14,15,18,20,30],[[1,
1,-1,1,-1,1,1],18,5,5,7,9,10,10,14,15,16,18,20,30],[2,16,5,5,7,8,9,10,10,14,
15,18,20,24,30],[2,28,5,5,7,8,9,10,10,14,15,18,20,24,30],[[1,1,1,-1,2,0,2,-1,
1,1,1],18,5,5,7,9,10,10,14,15,18,20,30],[1,10,4,4,4,5,7,8,8,10,12,12,14,15,16,
20,24,30],[1,28,4,4,4,5,7,8,8,10,12,12,14,15,16,20,24,30],[[1,-1,1,3,2,1,5,5,
6,6,8,8,12,7,9,14,9,7,12,8,8,6,6,5,5,1,2,3,1,-1,1],16,7,8,8,14,24],[1,10,3,3,
3,6,6,6,7,8,9,12,12,14,15,16,18,24,30],[1,30,3,3,3,6,6,6,7,8,9,12,12,14,15,16,
18,24,30],[[1,1,1,2,5,2,8,5,7,10,11,8,16,12,11,16,11,12,16,8,11,10,7,5,8,2,5,
2,1,1,1],18,7,9,14,18],[1,14,3,3,3,5,6,6,6,7,9,10,12,12,14,15,18,20,24,30],[1,
22,3,3,3,5,6,6,6,7,9,10,12,12,14,15,18,20,24,30],[[1,1,3,2,3,8,4,9,11,10,13,
16,12,16,19,14,19,16,12,16,13,10,11,9,4,8,3,2,3,1,1],18,7,9,14,18],[1,16,4,4,
4,4,4,5,5,8,8,10,10,12,12,15,20,20,24,30],[1,22,4,4,4,4,4,5,5,8,8,10,10,12,12,
15,20,20,24,30],[[1,2,1,2,3,3,4,5,3,5,4,4,5,5,2,4,3,3,2,2,0,1],12,4,4,4,4,8,8,
12,12,20,24],[[1,0,2,2,3,3,4,2,5,5,4,4,5,3,5,4,3,3,2,1,2,1],26,4,4,4,4,8,8,12,
12,20,24],[1,12,5,5,7,8,8,8,9,10,10,14,15,18,20,24,30],[1,24,5,5,7,8,8,8,9,10,
10,14,15,18,20,24,30],[1,14,3,3,3,3,5,5,6,6,6,6,9,10,10,12,12,15,18,20,24,30],
[1,22,3,3,3,3,5,5,6,6,6,6,9,10,10,12,12,15,18,20,24,30],[1,1,4,4,8,12,20,24],
[1,91,4,4,8,12,20,24],[[1,0,-1,1,-1,0,1],19,4,4,7,8,12,14,20,24],[[1,0,-1,1,
-1,0,1],49,4,4,7,8,12,14,20,24],[1,3,4,4,4,7,8,12,14,20,24,28],[1,63,4,4,4,7,
8,12,14,20,24,28],[1,7,4,4,4,5,8,8,10,12,15,20,24,30],[1,55,4,4,4,5,8,8,10,12,
15,20,24,30],[[1,-1,0,2,-2,0,2,0,-2,2,0,-1,1],25,4,4,4,7,8,8,12,14,20,24],[1,
7,4,4,4,5,5,8,10,10,12,15,20,20,24,30],[1,43,4,4,4,5,5,8,10,10,12,15,20,20,24,
30],[1,9,4,4,4,4,7,8,8,12,12,14,20,24,24,28],[1,39,4,4,4,4,7,8,8,12,12,14,20,
24,24,28],[1,5,4,4,5,7,8,8,10,12,14,15,20,24,30],[1,47,4,4,5,7,8,8,10,12,14,
15,20,24,30],[1,19,4,4,4,7,8,8,9,12,14,15,16,18,20,24,30],[1,13,4,4,5,7,8,9,
10,12,14,15,18,20,24,30],[1,31,4,4,5,7,8,9,10,12,14,15,18,20,24,30],[[1,1,-1,
0,1,0,-1,1,1],9,4,4,7,8,8,9,12,14,18,20,24],[[1,1,-1,0,1,0,-1,1,1],39,4,4,7,8,
8,9,12,14,18,20,24],[[1,1,-1,0,1,0,-1,1,1],19,4,4,4,7,8,8,9,12,14,18,20,20,
24],[1,13,3,3,3,4,4,4,6,6,6,8,9,12,12,15,18,20,24,30],[1,33,3,3,3,4,4,4,6,6,6,
8,9,12,12,15,18,20,24,30],[1,11,4,4,5,5,7,8,10,10,12,14,15,20,20,24,30],[1,29,
4,4,5,5,7,8,10,10,12,14,15,20,20,24,30],[1,7,4,4,5,5,7,8,10,10,12,12,14,15,20,
24,30],[1,37,4,4,5,5,7,8,10,10,12,12,14,15,20,24,30],[1,17,4,4,5,5,8,8,8,9,10,
10,12,15,18,20,24,30],[1,23,4,4,5,5,8,8,8,9,10,10,12,15,18,20,24,30],[1,13,4,
4,4,5,5,7,8,10,10,12,12,12,14,15,20,24,30],[1,25,4,4,4,5,5,7,8,10,10,12,12,12,
14,15,20,24,30],[[2,-3,2],19,4,4,4,5,5,7,8,8,10,10,12,14,15,20,24,30],[1,9,3,
3,3,4,4,5,6,6,6,8,9,10,12,12,15,18,20,24,30],[1,31,3,3,3,4,4,5,6,6,6,8,9,10,
12,12,15,18,20,24,30],[1,13,4,4,4,5,7,8,8,9,10,12,14,15,18,20,24,30],[1,25,4,
4,4,5,7,8,8,9,10,12,14,15,18,20,24,30],[[1,0,1,0,1,-1,2,0,2,-1,1,0,1,0,1],17,
4,4,4,4,4,7,8,8,12,12,12,14,20,24],[[1,0,2,2,3,3,4,2,5,5,4,4,5,3,5,4,3,3,2,1,
2,1],11,4,4,4,4,8,8,12,12,20,24],[[1,2,1,2,3,3,4,5,3,5,4,4,5,5,2,4,3,3,2,2,0,
1],27,4,4,4,4,8,8,12,12,20,24],[1,15,4,4,5,5,7,8,9,10,10,12,14,15,18,20,24,
30],[1,21,4,4,5,5,7,8,9,10,10,12,14,15,18,20,24,30],[1,13,3,3,3,4,4,6,6,6,7,8,
9,12,12,14,15,18,20,24,30],[1,23,3,3,3,4,4,6,6,6,7,8,9,12,12,14,15,18,20,24,
30],[1,15,4,4,5,5,7,8,8,10,10,12,14,15,16,20,24,30],[1,21,4,4,5,5,7,8,8,10,10,
12,14,15,16,20,24,30]]);

#############################################################################
##
#F  CHEVIE.RawData("classparams","E8")( <w> )  . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type E_8  as word in  standard
##  generators, returns the classparam of its conjugacy class.
##
CHEVIE.AddData("ClassParameter","E8",function(w)
  if w=[] then return " ";fi;
  return CHEVIE.RawData("ClassNames","E8")[
                        Position(CHEVIE.RawData("cyclestructure","E8"),
    CycleStructurePerm(Product(CHEVIE.RawData("generators","E8"){w})))];
end);

###########################################################################
##
#F  CHEVIE.RawData("HeckeCharTable","E8")( <v> ) . . . . . . character table
#F  of the Hecke algebra of type E8
##
##  Note: the parameter for the Hecke algebra is <v>^2.
##       the labelling is consistent with v -> 1.
##
CHEVIE.AddData("HeckeCharTable","E8",function(param,sqrtparam)local q,v,tbl,p;
  q:=-param[1][1]/param[1][2];
  if not IsBound(sqrtparam[1]) then v:=GetRoot(q,2,"CharTable(Hecke(E8))");
  else v:=sqrtparam[1];
  fi;
  tbl:=rec(
  identifier:= "H(E8)",
  text := "origin: Jean Michel, March 1995",
  cartan:=CHEVIE.RawData("CartanMat","E8"),
  parameter:=param,rootparameter:=sqrtparam, size := 696729600,
  powermap:=CHEVIE.RawData("PowerMaps","E8"),
  irredinfo:=List(CHEVIE.RawData("CharInfo","E8")().charparams,x->
    rec(charparam:=x,charname:=CHEVIE.RawData("CharName","E8")(x,rec()))));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","E8"));
  p:=CHEVIE.RawData("vpolheckeirreducibles","E8");
  tbl.irreducibles:=List([1..Length(tbl.irredinfo)],function(i)
    if IsBound(p[i]) then return List(p[i],function(j)
        if Length(j)=3 then return ValuePol(j[1],v)*v^j[2];
        else return ValuePol(j[1],q)*q^j[2];fi;end);
    else return List([1..Length(tbl.classes)],
      function(k)local j,l;j:=p[i-1][k];l:=Length(tbl.classtext[k]);
        if Length(j)=3 then return ValuePol(j[1],v^-1)*v^-j[2]*(-q)^l;
        else return ValuePol(j[1],q^-1)*q^-j[2]*(-q)^l;fi;end);
    fi;end);
  tbl.centralizers:=List(tbl.classes,x->tbl.size/x);
  tbl := CHEVIE.compat.MakeCharacterTable(tbl);
  CHEVIE.compat.AdjustHeckeCharTable(tbl,param);
  return tbl;
end);

CHEVIE.AddData("WGraphs","E8", [[[[]],[]],,
[[[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8],[2,3],[2,4],[2,5],[2,6],[2,7],[2,
8],[3,4],[3,5],[3,6],[3,7],[3,8],[4,5],[4,6],[4,7],[4,8],[5,6],[5,7],[5,8],[6,
7],[6,8],[7,8]],[[-1,[[4,5],[15,16,19]]],[1,[[1,3,8],[2,3],[3,4,14],[4,15],[5,
6,16],[6,7,17],[7,18],[8,9,14],[9,10],[10,11,19],[11,12,20],[12,13,21],[13,
22],[14,15],[16,17,20],[17,18,21],[18,22],[19,20],[20,21,23],[21,22,24],[22,
25],[23,24],[24,25,26],[25,27],[26,27],[27,28]]]]],,
[[[1],[2],[3],1,[4],2,[5],1,[6],1,[7],1,[8],[1,2],[1,4],[1,5],[1,6],[1,7],[1,
8],[2,3],[2,5],[2,6],[2,7],[2,8],[3,5],[3,6],[3,7],[3,8],[4,6],[4,7],[4,8],[5,
7],[5,8],[6,8]],[[1,[[1,4,18],[2,6,15,23],[3,16,21,26],[4,5,27],[5,22,30],[6,
16,26,30],[7,9,16,21],[8,22,26,30,33],[9,10,17],[10,13,18],[11,30,33,35],[12,
33,35],[13,14,19],[14,20],[15,16,21],[16,17],[17,18,26],[18,19,27],[19,20,28],
[20,29],[22,23],[23,24,30],[24,25,31],[25,32],[26,27],[27,28,30],[28,29,31],
[29,32],[30,31],[31,32,33],[32,34],[33,34],[34,35]]]]],,
[[[1,2,3,4],[1,2,3,5],[1,2,3,6],[1,2,3,7],[1,2,3,8],[1,2,4,5],[1,2,4,6],[1,2,
4,7],[1,2,4,8],[1,2,5,6],[1,2,5,7],[1,2,5,8],[1,2,6,7],[1,2,6,8],[1,2,7,8],[1,
3,4,5],[1,3,4,6],[1,3,4,7],[1,3,4,8],[1,3,5,6],[1,3,5,7],[1,3,5,8],[1,3,6,7],
[1,3,6,8],[1,3,7,8],[1,4,5,6],[1,4,5,7],[1,4,5,8],[1,4,6,7],[1,4,6,8],[1,4,7,
8],[1,5,6,7],[1,5,6,8],[1,5,7,8],[1,6,7,8],[2,3,4,5],[2,3,4,6],[2,3,4,7],[2,3,
4,8],[2,3,5,6],[2,3,5,7],[2,3,5,8],[2,3,6,7],[2,3,6,8],[2,3,7,8],[2,4,5,6],[2,
4,5,7],[2,4,5,8],[2,4,6,7],[2,4,6,8],[2,4,7,8],[2,5,6,7],[2,5,6,8],[2,5,7,8],
[2,6,7,8],[3,4,5,6],[3,4,5,7],[3,4,5,8],[3,4,6,7],[3,4,6,8],[3,4,7,8],[3,5,6,
7],[3,5,6,8],[3,5,7,8],[3,6,7,8],[4,5,6,7],[4,5,6,8],[4,5,7,8],[4,6,7,8],[5,6,
7,8]],[[-1,[[2,3,16],[6,7],[10,26],[11,27],[12,28],[13,29],[14,30],[15,31],
[36,37],[40,56],[41,57],[42,58],[43,59],[44,60],[45,61]]],[1,[[1,2],[2,6],[3,
4,7,17],[4,5,8,18],[5,9,19],[6,36],[7,8,10,37],[8,9,11,38],[9,12,39],[10,11,
40],[11,12,13,41],[12,14,42],[13,14,43],[14,15,44],[15,45],[16,17],[17,18,20],
[18,19,21],[19,22],[20,21,26],[21,22,23,27],[22,24,28],[23,24,29],[24,25,30],
[25,31],[26,27,56],[27,28,29,57],[28,30,58],[29,30,32,59],[30,31,33,60],[31,
34,61],[32,33,62],[33,34,63],[34,35,64],[35,65],[37,38,40],[38,39,41],[39,42],
[40,41,46],[41,42,43,47],[42,44,48],[43,44,49],[44,45,50],[45,51],[46,47],[47,
48,49],[48,50],[49,50,52],[50,51,53],[51,54],[52,53,66],[53,54,67],[54,55,68],
[55,69],[56,57],[57,58,59],[58,60],[59,60,62],[60,61,63],[61,64],[62,63,66],
[63,64,67],[64,65,68],[65,69],[66,67],[67,68],[68,69],[69,70]]]]],  
[[[1],[2],[3],[4],1,[5],1,[6],[1,5],[1,6],[2,5],[2,6],[2,7],[2,8],[3,5],[3,6],
1,[3,7],1,[3,8],[4,6],1,[4,7],2,[4,8],1,[5,7],[5,8],[1,2,6],[1,2,7],[1,4,6],
[1,4,7],1,[1,4,8],[1,5,7],[1,5,8],[2,3,6],[2,3,7],[3,5,7],[3,5,8],[3,6,8],[4,
6,8],[1,2,5,7],[1,2,5,8],[1,2,6,8],[1,4,6,8],[2,3,5,7],[2,3,5,8],[2,3,6,8]],
[[1,[[1,3,10,35,44],[2,4,14,30,48],[3,5,17,20,48],[4,15,24,26,32],[5,11,21,24,
35],[6,9,22,29,48],[7,11,21,37,40],[8,10,28,38,43],[9,15,32,37,44],[10,17,30,
36,47],[11,12,45,48],[12,13,21,38,46],[13,14,23,31,48],[14,26,46,49],[15,16,
41,48],[16,18,32,38,42],[17,21,38,40,42],[18,20,34,48],[19,33,39,40,42],[20,
35,42,49],[21,23,47],[22,24,32,38,43],[23,26,33,40],[24,27,34,48],[25,28,33,
39,43],[26,41,47],[27,35,43,49],[28,29,36,48],[29,37,43,49],[30,32,38,44,46],
[31,33,39,44,46],[32,34,47],[33,36,47],[34,35,44],[35,45,47],[36,37,40,44],
[37,41,45,47],[38,48,50],[39,48,50],[40,41,48],[41,42,49],[42,47,50],[43,47,
50],[44,45,48],[45,46,49],[46,47,50],[48,49],[49,50]]]]],,
"84a",, "168", "175a",, "210a",, "420", "300a",, "350a",, "525a",, "567a",,
"1134",  "700b",,  "700a",,  "1400d",  "840b",,  "1680", "972a",, "1050a",,
"2100b",  "1344a",, "2688", "1400b",,  "1575a",, "3150", "2100a",, "4200c",
"2240a",,  "4480", "2268a",, "4536b", "2835a",, "5670", "3200a",, "4096b",,
"4200a",,  "6075a",, 
[[[1],[2],[3],[4],[5],[6],[7],[8]],[[1,[[1,3],[2,4],[3,4],[4,5],[5,6],[6,7],
[7,8]]]]],,
[[[1,2,3],[1,2,4],[1,2,5],[1,2,6],[1,2,7],[1,2,8],[1,3,4],[1,3,5],[1,3,6],[1,
3,7],[1,3,8],[1,4,5],[1,4,6],[1,4,7],[1,4,8],[1,5,6],[1,5,7],[1,5,8],[1,6,7],
[1,6,8],[1,7,8],[2,3,4],[2,3,5],[2,3,6],[2,3,7],[2,3,8],[2,4,5],[2,4,6],[2,4,
7],[2,4,8],[2,5,6],[2,5,7],[2,5,8],[2,6,7],[2,6,8],[2,7,8],[3,4,5],[3,4,6],[3,
4,7],[3,4,8],[3,5,6],[3,5,7],[3,5,8],[3,6,7],[3,6,8],[3,7,8],[4,5,6],[4,5,7],
[4,5,8],[4,6,7],[4,6,8],[4,7,8],[5,6,7],[5,6,8],[5,7,8],[6,7,8]],[[-1,[[2,3],
[3,23],[4,24],[5,25],[6,26],[12,37],[13,16,38],[14,17,39],[15,18,40],[28,31],
[29,32],[30,33]]],[1,[[1,2,7],[2,22],[3,4,12],[4,5,13],[5,6,14],[6,15],[7,8],
[8,9,12],[9,10,13],[10,11,14],[11,15],[12,13],[13,14],[14,15],[16,17,41],[17,
18,19,42],[18,20,43],[19,20,44],[20,21,45],[21,46],[22,23],[23,24,27,37],[24,
25,28,38],[25,26,29,39],[26,30,40],[27,28],[28,29],[29,30],[31,32,47],[32,33,
34,48],[33,35,49],[34,35,50],[35,36,51],[36,52],[37,38],[38,39,41],[39,40,42],
[40,43],[41,42,47],[42,43,44,48],[43,45,49],[44,45,50],[45,46,51],[46,52],[47,
48],[48,49,50],[49,51],[50,51,53],[51,52,54],[52,55],[53,54],[54,55],[55,
56]]]]],,  "112a",,  "160a",,  "448b", "400a",,
"448a",,  "560a",, "1344b", "840a",,  "1008a",, "2016", "1296a",, "1400c",,
"1400a",,   "2400a",,  "2800a",,   "5600b",  "3240a",,   "3360a",,  "7168",
"4096a",, "4200b",, "4536a",, "5600a",]);

CHEVIE.AddData("WGraph","E8",function(i)local gr;
 gr:=CHEVIE.RawData("WGraphs","E8");
 if not IsBound(gr[i]) then 
   gr[i]:=DualWGraph(8,CHEVIE.RawData("WGraph","E8")(i-1));return gr[i];
 elif IsString(gr[i]) then 
   ReadChv(Concatenation("tbl/e8wgraph/rep",gr[i]));return gr[i];
 else return gr[i];
 fi;
end);

CHEVIE.AddData("HeckeRepresentation","E8",function(param,sqrtparam,i)local v,gr;
 if not IsBound(sqrtparam[1]) then 
     v:=GetRoot(-param[1][1]/param[1][2],2,"Representation(Hecke(E8),[",i,"])");
 else v:=sqrtparam[1];
 fi;
 gr:=CHEVIE.RawData("WGraph","E8")(i);
 if gr=false then return false;
 else return -param[1][2]*WGraphToRepresentation(8,gr,v); 
 fi;
end);

CHEVIE.AddData("Representation","E8",function(i)
  return CHEVIE.RawData("HeckeRepresentation","E8")
  (List([1..8],i->[1,-1]),[1..8]*0+1,i);end);

if not IsBound(CHEVIE.families) then ReadChv("unip/families");fi;
CHEVIE.families.S5:=rec(group:=Group((1,5),(2,5),(3,5),(4,5)),
lusztig:=true,
charLabels:=["(1,1)","(1,\\lambda^4)","(1,\\lambda^3)","(1,\\lambda)",
  "(1,\\nu)","(1,\\nu')","(1,\\lambda^2)","(g_2,1)","(g_2,-\\varepsilon)",
  "(g_2,-1)","(g_2,\\varepsilon)","(g_2,-\\rho)","(g_2,\\rho)",
  "(g'_2,1)","(g'_2,\\varepsilon)","(g'_2,\\varepsilon')",
  "(g'_2,\\varepsilon'')","(g'_2,\\rho)","(g_3,1)","(g_3,\\varepsilon)",
  "(g_3,\\zeta_3)","(g_3,\\varepsilon\\zeta_3)","(g_3,\\zeta_3^2)",
  "(g_3,\\varepsilon\\zeta_3^2)","(g_6,1)","(g_6,-1)",
  "(g_6,\\zeta_3)","(g_6,-\\zeta_3)","(g_6,\\zeta_3^2)","(g_6,-\\zeta_3^2)",
  "(g_4,1)","(g_4,-1)","(g_4,i)","(g_4,-i)","(g_5,1)","(g_5,\\zeta_5)",
  "(g_5,\\zeta_5^2)","(g_5,\\zeta_5^3)","(g_5,\\zeta_5^4)"],
size:=39,
eigenvalues:=[1,1,1,1,1,1,1,1,-1,-1,1,-1,1,1,1,1,1,-1,1,1,E(3),E(3),E(3)^2,
E(3)^2,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(4),-E(4),1,E(5),E(5)^2,E(5)^3,
E(5)^4],
name:="D(S_5)",
mellin:=ApplyFunc(DiagonalMat,
[[[1,1,4,4,5,5,6],[1,-1,-2,2,1,-1,0],[1,1,0,0,1,1,-2],[1,1,1,1,-1,-1,0],[1,
-1,1,-1,1,-1,0],[1,-1,0,0,-1,1,0],[1,1,-1,-1,0,0,1]],[[1,1,1,1,2,2],[1,-1,1,
-1,0,0],[1,1,1,1,-1,-1],[1,-1,-1,1,-2,2],[1,1,-1,-1,0,0],[1,-1,-1,1,1,-1]],
[[1,1,1,1,2],[1,-1,-1,1,0],[1,1,1,1,-2],[1,-1,1,-1,0],[1,1,-1,-1,0]],[[1,1,
1,1,1,1],[1,-1,1,-1,1,-1],[1,1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,E(3),-E(3),
E(3)^2,-E(3)^2],[1,1,E(3)^2,E(3)^2,E(3),E(3)],[1,-1,E(3)^2,-E(3)^2,E(3),
-E(3)]],[[1,1,1,1,1,1],[1,-1,1,-1,1,-1],[1,1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,
E(3),-E(3),E(3)^2,-E(3)^2],[1,1,E(3)^2,E(3)^2,E(3),E(3)],[1,-1,E(3)^2,
-E(3)^2,E(3),-E(3)]],[[1,1,1,1],[1,-1,E(4),-E(4)],[1,1,-1,-1],[1,-1,-E(4),
E(4)]],[[1,1,1,1,1],[1,E(5),E(5)^2,E(5)^3,E(5)^4],[1,E(5)^2,E(5)^4,E(5),
E(5)^3],[1,E(5)^3,E(5),E(5)^4,E(5)^2],[1,E(5)^4,E(5)^3,E(5)^2,E(5)]]]),
mellinLabels:=["(1,1)","(1,g_2)","(1,g'_2)","(1,g_3)","(1,g_6)","(1,g_4)",
"(1,g_5)","(g_2,1)","(g_2,g''_2)","(g_2,g'_3)","(g_2,g_2)","(g_2,g'''_2)",
"(g_2,g'_6)","(g'_2,1)","(g'_2,g''''_2)","(g'_2,g'_2)","(g'_2,g'''''_2)",
"(g'_2,g'_4)","(g_3,1)","(g_3,g''_2)","(g_3,g_3)","(g_3,g_6)","(g_3,g_3^2)",
"(g_3,g_6^5)","(g_6,1)","(g_6,g''_2)","(g_6,g_3)","(g_6,g_6)",
"(g_6,g_3^2)","(g_6,g_6^5)","(g_4,1)","(g_4,g_4)","(g_4,g'''''_2)",
"(g_4,g_4^-1)","(g_5,1)","(g_5,g_5)","(g_5,g_5^2)","(g_5,g_5^3)","(g_5,g_5^4)"],
fourierMat:=[[1/10,1/10,2/5,2/5,1/2,1/2,3/5,1,1,1,1,2,2,3/2,3/2,3/2,3/2,3,2,2,2,
2,2,2,2,2,2,2,2,2,3,3,3,3,12/5,12/5,12/5,12/5,12/5],[1/10,1/10,2/5,2/5,1/2,
1/2,3/5,-1,-1,-1,-1,-2,-2,3/2,3/2,3/2,3/2,3,2,2,2,2,2,2,-2,-2,-2,-2,-2,-2,-3,
-3,-3,-3,12/5,12/5,12/5,12/5,12/5],[2/5,2/5,8/5,8/5,2,2,12/5,-2,-2,-2,-2,-4,-4,
0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,-12/5,-12/5,-12/5,-12/5,-12/5],[2/5,
2/5,8/5,8/5,2,2,12/5,2,2,2,2,4,4,0,0,0,0,0,2,2,2,2,2,2,-2,-2,-2,-2,-2,-2,0,
0,0,0,-12/5,-12/5,-12/5,-12/5,-12/5],[1/2,1/2,2,2,5/2,5/2,3,1,1,1,1,2,2,3/2,
3/2,3/2,3/2,3,-2,-2,-2,-2,-2,-2,2,2,2,2,2,2,-3,-3,-3,-3,0,0,0,0,0],[1/2,1/2,
2,2,5/2,5/2,3,-1,-1,-1,-1,-2,-2,3/2,3/2,3/2,3/2,3,-2,-2,-2,-2,-2,-2,-2,-2,
-2,-2,-2,-2,3,3,3,3,0,0,0,0,0],[3/5,3/5,12/5,12/5,3,3,18/5,0,0,0,0,0,0,-3,
-3,-3,-3,-6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12/5,12/5,12/5,12/5,12/5],[1,-1,
-2,2,1,-1,0,4,-4,2,-2,-2,2,3,-3,-3,3,0,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,0,0,0,
0,0,0,0,0,0],[1,-1,-2,2,1,-1,0,-4,4,-2,2,2,-2,3,-3,-3,3,0,2,-2,2,-2,2,-2,-2,
2,-2,2,-2,2,0,0,0,0,0,0,0,0,0],[1,-1,-2,2,1,-1,0,2,-2,4,-4,2,-2,-3,3,3,-3,0,
2,-2,2,-2,2,-2,-2,2,-2,2,-2,2,0,0,0,0,0,0,0,0,0],[1,-1,-2,2,1,-1,0,-2,2,-4,
4,-2,2,-3,3,3,-3,0,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,0,0,0,0,0,0,0,0,0],[2,-2,
-4,4,2,-2,0,-2,2,2,-2,4,-4,0,0,0,0,0,-2,2,-2,2,-2,2,2,-2,2,-2,2,-2,0,0,0,0,
0,0,0,0,0],[2,-2,-4,4,2,-2,0,2,-2,-2,2,-4,4,0,0,0,0,0,-2,2,-2,2,-2,2,-2,2,
-2,2,-2,2,0,0,0,0,0,0,0,0,0],[3/2,3/2,0,0,3/2,3/2,-3,3,3,-3,-3,0,0,9/2,-3/2,
9/2,-3/2,-3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,-3,-3,0,0,0,0,0],[3/2,3/2,0,0,3/2,
3/2,-3,-3,-3,3,3,0,0,-3/2,9/2,-3/2,9/2,-3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,-3,-3,
0,0,0,0,0],[3/2,3/2,0,0,3/2,3/2,-3,-3,-3,3,3,0,0,9/2,-3/2,9/2,-3/2,-3,0,0,0,
0,0,0,0,0,0,0,0,0,-3,-3,3,3,0,0,0,0,0],[3/2,3/2,0,0,3/2,3/2,-3,3,3,-3,-3,0,
0,-3/2,9/2,-3/2,9/2,-3,0,0,0,0,0,0,0,0,0,0,0,0,-3,-3,3,3,0,0,0,0,0],[3,3,0,
0,3,3,-6,0,0,0,0,0,0,-3,-3,-3,-3,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[2,2,2,2,-2,-2,0,2,2,2,2,-2,-2,0,0,0,0,0,4,4,-2,-2,-2,-2,4,4,-2,-2,-2,-2,
0,0,0,0,0,0,0,0,0],[2,2,2,2,-2,-2,0,-2,-2,-2,-2,2,2,0,0,0,0,0,4,4,-2,-2,-2,
-2,-4,-4,2,2,2,2,0,0,0,0,0,0,0,0,0],[2,2,2,2,-2,-2,0,2,2,2,2,-2,-2,0,0,0,0,
0,-2,-2,4,4,-2,-2,-2,-2,4,4,-2,-2,0,0,0,0,0,0,0,0,0],[2,2,2,2,-2,-2,0,-2,-2,
-2,-2,2,2,0,0,0,0,0,-2,-2,4,4,-2,-2,2,2,-4,-4,2,2,0,0,0,0,0,0,0,0,0],[2,2,2,
2,-2,-2,0,2,2,2,2,-2,-2,0,0,0,0,0,-2,-2,-2,-2,4,4,-2,-2,-2,-2,4,4,0,0,0,0,0,
0,0,0,0],[2,2,2,2,-2,-2,0,-2,-2,-2,-2,2,2,0,0,0,0,0,-2,-2,-2,-2,4,4,2,2,2,2,
-4,-4,0,0,0,0,0,0,0,0,0],[2,-2,2,-2,2,-2,0,2,-2,-2,2,2,-2,0,0,0,0,0,4,-4,-2,
2,-2,2,4,-4,-2,2,-2,2,0,0,0,0,0,0,0,0,0],[2,-2,2,-2,2,-2,0,-2,2,2,-2,-2,2,0,
0,0,0,0,4,-4,-2,2,-2,2,-4,4,2,-2,2,-2,0,0,0,0,0,0,0,0,0],[2,-2,2,-2,2,-2,0,
2,-2,-2,2,2,-2,0,0,0,0,0,-2,2,4,-4,-2,2,-2,2,4,-4,-2,2,0,0,0,0,0,0,0,0,0],
[2,-2,2,-2,2,-2,0,-2,2,2,-2,-2,2,0,0,0,0,0,-2,2,4,-4,-2,2,2,-2,-4,4,2,-2,0,
0,0,0,0,0,0,0,0],[2,-2,2,-2,2,-2,0,2,-2,-2,2,2,-2,0,0,0,0,0,-2,2,-2,2,4,-4,
-2,2,-2,2,4,-4,0,0,0,0,0,0,0,0,0],[2,-2,2,-2,2,-2,0,-2,2,2,-2,-2,2,0,0,0,0,
0,-2,2,-2,2,4,-4,2,-2,2,-2,-4,4,0,0,0,0,0,0,0,0,0],[3,-3,0,0,-3,3,0,0,0,0,0,
0,0,3,3,-3,-3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,-6,0,0,0,0,0,0,0],[3,-3,0,0,-3,3,
0,0,0,0,0,0,0,3,3,-3,-3,0,0,0,0,0,0,0,0,0,0,0,0,0,-6,6,0,0,0,0,0,0,0],[3,-3,
0,0,-3,3,0,0,0,0,0,0,0,-3,-3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,-6,0,0,0,0,
0],[3,-3,0,0,-3,3,0,0,0,0,0,0,0,-3,-3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-6,
6,0,0,0,0,0],[12/5,12/5,-12/5,-12/5,0,0,12/5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,48/5,-12/5,-12/5,-12/5,-12/5],[12/5,12/5,-12/5,
-12/5,0,0,12/5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-12/5,
(18+6*ER(5))/5,(-12+12*ER(5))/5,(-12-12*ER(5))/5,(18-6*ER(5))/5],[12/5,12/5,
-12/5,-12/5,0,0,12/5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-12/5,(-12+12*ER(5))/5,(18-6*ER(5))/5,(18+6*ER(5))/5,(-12-12*ER(5))/5],
[12/5,12/5,-12/5,-12/5,0,0,12/5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,-12/5,(-12-12*ER(5))/5,(18+6*ER(5))/5,(18-6*ER(5))/5,
(-12+12*ER(5))/5],[12/5,12/5,-12/5,-12/5,0,0,12/5,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,-12/5,(18-6*ER(5))/5,(-12-12*ER(5))/5,
(-12+12*ER(5))/5,(18+6*ER(5))/5]]/12,
perm:=(21,23)(22,24)(27,29)(28,30)(33,34)(36,39)(37,38),
x:=[(),(),(),(),(),(),(),(1,2),(1,2),(1,2),(1,2),(1,2),(1,2),(1,2)(3,4),(1,
2)(3,4),(1,2)(3,4),(1,2)(3,4),(1,2)(3,4),(1,2,3),(1,2,3),(1,2,3),(1,2,3),(1,
2,3),(1,2,3),(1,2,3)(4,5),(1,2,3)(4,5),(1,2,3)(4,5),(1,2,3)(4,5),(1,2,3)(4,
5),(1,2,3)(4,5),(1,2,3,4),(1,2,3,4),(1,2,3,4),(1,2,3,4),(1,2,3,4,5),(1,2,3,
4,5),(1,2,3,4,5),(1,2,3,4,5),(1,2,3,4,5)],
y:=[(),(1,2),(1,2)(3,4),(1,2,3),(1,2,3)(4,5),(1,2,3,4),(1,2,3,4,5),(),(4,5),
(3,4,5),(1,2),(1,2)(4,5),(1,2)(3,4,5),(),(3,4),(1,2)(3,4),(1,3)(2,4),(1,3,2,
4),(),(4,5),(1,2,3),(1,2,3)(4,5),(1,3,2),(1,3,2)(4,5),(),(4,5),(1,2,3),(1,2,
3)(4,5),(1,3,2),(1,3,2)(4,5),(),(1,2,3,4),(1,3)(2,4),(1,4,3,2),(),(1,2,3,4,
5),(1,3,5,2,4),(1,4,2,5,3),(1,5,4,3,2)],
special:=1);

CHEVIE.AddData("DecompositionMatrix","E8",function(p)
  if p=2 then return  [
[Concatenation([1..61],[64..104],[107..112]),
[[1,0,0,0,0,0,0,0,0,0,0],[1,0,0,0,0,0,0,0,0,0,0],[2,0,0,1,0,0,0,0,0,0,0],
[2,0,0,1,0,0,0,0,0,0,0], [1,1,0,1,0,0,0,0,0,0,0], [1,1,0,1,0,0,0,0,0,0,0],
[2,0,1,2,0,0,0,0,0,0,0], [0,1,1,1,0,0,0,0,0,0,0], [0,1,1,1,0,0,0,0,0,0,0],
[2,1,0,1,1,0,0,0,0,0,0], [2,1,0,1,1,0,0,0,0,0,0], [4,0,1,2,0,1,0,0,0,0,0],
[5,0,0,1,1,1,0,0,0,0,0], [5,0,0,1,1,1,0,0,0,0,0], [0,1,1,1,0,0,1,0,0,0,0],
[0,1,1,1,0,0,1,0,0,0,0], [0,2,2,2,0,0,0,1,0,0,0], [2,0,0,2,0,0,0,0,1,0,0],
[2,0,0,2,0,0,0,0,1,0,0], [2,1,1,3,0,0,0,0,1,0,0], [2,1,1,3,0,0,0,0,1,0,0],
[7,1,1,4,1,1,0,0,1,0,0], [7,1,1,4,1,1,0,0,1,0,0], [3,2,1,3,1,0,1,0,1,0,0],
[3,2,1,3,1,0,1,0,1,0,0], [6,2,3,6,0,1,0,1,2,0,0], [2,2,2,1,1,1,1,1,0,0,0],
[2,2,2,1,1,1,1,1,0,0,0], [6,1,2,4,1,1,1,0,1,0,0], [6,1,2,4,1,1,1,0,1,0,0],
[12,4,3,8,2,2,0,1,2,0,0], [4,2,2,3,1,1,0,1,1,0,0], [4,2,2,3,1,1,0,1,1,0,0],
[8,4,4,6,2,2,2,1,2,0,0], [2,2,2,2,1,1,1,1,1,0,0], [2,2,2,2,1,1,1,1,1,0,0],
[4,3,3,4,1,1,1,1,1,0,0], [4,3,3,4,1,1,1,1,1,0,0], [8,6,6,8,2,2,2,2,2,0,0],
[2,2,2,4,0,0,1,0,1,1,0], [2,2,2,4,0,0,1,0,1,1,0], [4,4,4,8,0,0,0,1,2,0,1],
[6,4,4,7,1,1,1,1,2,0,0], [6,4,4,7,1,1,1,1,2,0,0], [7,3,2,5,2,1,1,0,1,1,0],
[7,3,2,5,2,1,1,0,1,1,0], [14,4,5,10,2,3,0,1,2,0,1], [4,5,4,5,2,1,2,1,1,1,0],
[4,5,4,5,2,1,2,1,1,1,0], [8,8,9,10,2,3,2,3,2,0,1], [2,6,4,4,2,1,1,2,1,1,0],
[2,6,4,4,2,1,1,2,1,1,0], [4,8,10,8,2,3,4,3,2,0,1], [8,5,4,8,2,1,1,1,2,1,0],
[8,5,4,8,2,1,1,1,2,1,0], [16,8,9,16,2,3,2,2,4,0,1], [7,4,5,7,1,2,1,1,1,0,1],
[7,4,5,7,1,2,1,1,1,0,1], [14,10,9,14,4,3,2,2,2,2,1], [10,4,4,8,2,2,0,0,1,1,1],
[10,4,4,8,2,2,0,0,1,1,1], [14,6,6,11,3,3,1,1,2,1,1], [14,6,6,11,3,3,1,1,2,1,1],
[17,11,11,17,4,4,3,3,4,1,1], [17,11,11,17,4,4,3,3,4,1,1], [0,1,0,0,0,0,0,0,0,0,0],
[0,1,0,0,0,0,0,0,0,0,0], [0,1,0,0,1,0,0,0,0,0,0], [0,1,0,0,1,0,0,0,0,0,0],
[4,1,0,2,1,0,0,0,0,0,0], [4,1,0,2,1,0,0,0,0,0,0], [0,0,0,0,0,0,1,0,0,0,0],
[0,0,0,0,0,0,1,0,0,0,0], [0,0,2,0,0,1,2,0,0,0,0], [4,1,2,2,1,1,1,0,0,0,0],
[4,1,2,2,1,1,1,0,0,0,0], [6,0,0,2,1,1,0,0,1,0,0], [6,0,0,2,1,1,0,0,1,0,0],
[2,2,2,4,0,0,1,0,1,0,0], [2,2,2,4,0,0,1,0,1,0,0], [0,4,4,0,2,2,2,2,0,0,0],
[0,1,0,0,1,0,0,0,0,1,0], [0,1,0,0,1,0,0,0,0,1,0], [8,2,2,6,1,1,1,0,2,0,0],
[8,2,2,6,1,1,1,0,2,0,0], [8,2,2,4,2,2,0,0,0,0,1], [6,3,2,6,1,0,0,0,1,1,0],
[6,3,2,6,1,0,0,0,1,1,0], [2,5,4,4,1,1,1,2,1,0,0], [2,5,4,4,1,1,1,2,1,0,0],
[2,3,2,4,1,0,1,0,1,1,0], [2,3,2,4,1,0,1,0,1,1,0], [10,6,6,10,2,2,2,2,3,0,0],
[10,6,6,10,2,2,2,2,3,0,0], [6,7,6,6,3,2,3,2,1,1,0], [6,7,6,6,3,2,3,2,1,1,0],
[12,10,8,12,4,3,2,2,2,2,1], [10,7,6,10,3,2,2,2,3,1,0], [10,7,6,10,3,2,2,2,3,1,0],
[10,4,4,8,2,2,1,0,1,1,1], [10,4,4,8,2,2,1,0,1,1,1], [8,12,14,16,2,3,4,4,4,0,2],
[18,7,8,14,3,4,1,2,3,0,1], [18,7,8,14,3,4,1,2,3,0,1], [12,7,8,12,2,3,1,2,2,1,1],
[12,7,8,12,2,3,1,2,2,1,1], [20,10,10,18,4,4,2,2,4,1,1],
[20,10,10,18,4,4,2,2,4,1,1]]],
[[62,63,105,106],[[1],[1],[1],[1]]]];
  elif p=3 then return [
  [Concatenation([1..23],[27..34],[37..53],[60..65]),
[[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0],
[1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],
[1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0],
[1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],
[0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0],
[1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0],
[0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],
[0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0],
[0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0],
[0,0,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0],
[0,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0],
[0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0],
[0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
[0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],
[0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0],
[1,1,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0],
[1,1,0,0,1,0,1,1,1,0,0,0,0,0,1,0,0,0,0,0],
[0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0],
[0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0],
[0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,1,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0],
[0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0],
[0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0],
[0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,1,0,0],
[1,0,1,0,1,0,1,1,0,1,0,0,0,1,0,1,0,0,0,0],
[0,1,0,1,0,1,1,0,1,0,1,0,0,0,1,0,1,0,0,0],
[1,1,1,1,1,1,2,1,1,1,1,0,0,1,1,0,0,1,0,0],
[0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0],
[0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1],
[0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0],
[0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1],
[0,0,2,2,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1],
[0,0,1,0,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,0],
[0,0,0,1,0,0,1,0,0,0,1,0,1,0,1,0,0,1,0,0],
[0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0],
[0,0,0,2,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0],
[0,0,2,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1],
[0,0,2,2,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1],
[1,1,0,1,1,0,1,1,0,1,0,0,1,1,1,1,0,1,0,0],
[1,1,1,0,0,1,1,0,1,0,1,1,0,1,1,0,1,1,0,0],
[1,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,0,1,1,0],
[0,1,1,1,0,0,0,0,0,0,1,1,1,0,1,0,1,1,0,1],
[0,0,1,2,0,1,1,0,0,2,1,0,1,1,0,1,0,1,1,0],
[0,0,2,1,1,0,1,0,0,1,2,1,0,0,1,0,1,1,0,1]]],
[Concatenation([68..88],[91..99],[102..108],[111,112]),
[[1,0,0,0,0,0,0,0,0,0,0,0,0],[0,1,0,0,0,0,0,0,0,0,0,0,0],
[0,0,1,0,0,0,0,0,0,0,0,0,0], [0,0,0,1,0,0,0,0,0,0,0,0,0],
[1,0,0,0,1,0,0,0,0,0,0,0,0], [0,1,0,0,0,1,0,0,0,0,0,0,0],
[0,0,1,0,1,0,0,0,0,0,0,0,0], [0,0,0,1,0,1,0,0,0,0,0,0,0],
[0,0,0,0,0,0,1,0,0,0,0,0,0], [1,1,0,0,0,0,0,1,0,0,0,0,0],
[1,1,0,0,0,0,0,0,1,0,0,0,0], [1,0,0,1,0,0,0,1,0,0,0,0,0],
[0,1,1,0,0,0,0,0,1,0,0,0,0], [2,0,1,0,1,0,0,1,0,0,0,0,0],
[0,2,0,1,0,1,0,0,1,0,0,0,0], [1,1,1,1,0,0,1,1,1,0,0,0,0],
[1,0,0,0,0,0,1,1,0,0,0,0,0], [0,1,0,0,0,0,1,0,1,0,0,0,0],
[0,0,2,0,1,0,0,0,0,1,0,0,0], [0,0,0,2,0,1,0,0,0,0,1,0,0],
[0,0,2,2,1,1,0,0,0,1,1,0,0], [0,1,0,2,0,1,0,1,0,1,0,0,0],
[1,0,2,0,1,0,0,0,1,0,1,0,0], [1,0,1,1,1,0,0,1,0,1,0,0,0],
[0,1,1,1,0,1,0,0,1,0,1,0,0], [0,0,1,0,0,0,1,0,0,0,0,1,0],
[0,0,0,1,0,0,1,0,0,0,0,0,1], [0,0,1,1,0,0,0,0,0,1,0,1,0],
[0,0,1,1,0,0,0,0,0,0,1,0,1], [2,2,1,1,0,0,2,1,1,0,0,1,1],
[1,1,1,2,0,1,0,1,0,1,0,1,0], [1,1,2,1,1,0,0,0,1,0,1,0,1],
[2,2,3,3,1,1,1,1,1,1,1,1,1], [2,1,1,2,0,0,1,2,0,1,0,1,0],
[1,2,2,1,0,0,1,0,2,0,1,0,1], [1,2,1,2,0,1,1,1,1,1,0,1,0],
[2,1,2,1,1,0,1,1,1,0,1,0,1], [1,1,1,2,0,0,1,1,0,1,0,1,1],
[1,1,2,1,0,0,1,0,1,0,1,1,1]]],
[[24,58,55],[[1,0],[1,1],[0,1]]],
[[54,57,25],[[1,0],[1,1],[0,1]]],
[[100,109,90],[[1,0],[1,1],[0,1]]],
[[89,110,101],[[1,0],[1,1],[0,1]]],
[[26,59,56],[[1,0],[1,1],[0,1]]]];
  elif p=5 then return [
 [[1,2,3,4,10,11,12,24,25,26,35,36,40,41,42,54,55,56,62,63],
[[1,0,0,0,0,0,0,0,0,0,0,0,0,0], [0,1,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,1,0,0,0,0,0,0,0,0,0,0,0], [0,0,0,1,0,0,0,0,0,0,0,0,0,0],
[1,0,0,0,1,0,0,0,0,0,0,0,0,0], [0,1,0,0,0,1,0,0,0,0,0,0,0,0],
[1,1,0,0,0,0,1,0,0,0,0,0,0,0], [0,0,1,0,0,0,0,1,0,0,0,0,0,0],
[0,0,0,1,0,0,0,0,1,0,0,0,0,0], [0,0,1,1,0,0,0,0,0,1,0,0,0,0],
[1,0,0,0,1,0,1,0,0,0,1,0,0,0], [0,1,0,0,0,1,1,0,0,0,0,1,0,0],
[0,0,0,0,1,0,0,1,0,0,1,0,0,0], [0,0,0,0,0,1,0,0,1,0,0,1,0,0],
[0,0,0,0,0,0,1,0,0,1,1,1,0,0], [0,0,0,0,0,0,0,1,0,0,0,0,1,0],
[0,0,0,0,0,0,0,0,1,0,0,0,0,1], [0,0,0,0,0,0,0,0,0,1,0,0,1,1],
[0,0,1,0,0,0,0,1,0,1,1,0,1,0], [0,0,0,1,0,0,0,0,1,1,0,1,0,1]]],
[[68,69,70,71,72,73,76,79,80,83,86,87,88,89,90,104,105,106,109,110],
[[1,0,0,0,0,0,0,0,0,0,0,0,0,0], [0,1,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,1,0,0,0,0,0,0,0,0,0,0,0], [0,0,0,1,0,0,0,0,0,0,0,0,0,0],
[1,0,0,0,1,0,0,0,0,0,0,0,0,0], [0,1,0,0,0,1,0,0,0,0,0,0,0,0],
[0,0,1,1,0,0,1,0,0,0,0,0,0,0], [0,0,0,0,1,0,0,1,0,0,0,0,0,0],
[0,0,0,0,0,1,0,0,1,0,0,0,0,0], [1,1,0,0,0,0,0,0,0,1,0,0,0,0],
[0,0,0,0,1,0,0,0,0,0,1,0,0,0], [0,0,0,0,0,1,0,0,0,0,0,1,0,0],
[0,0,0,0,0,0,0,1,1,1,0,0,0,0], [0,0,1,0,0,0,1,0,0,0,1,0,0,0],
[0,0,0,1,0,0,1,0,0,0,0,1,0,0], [0,0,0,0,0,0,1,0,0,1,0,0,1,1],
[0,0,0,0,1,0,1,0,0,0,1,0,1,0], [0,0,0,0,0,1,1,0,0,0,0,1,0,1],
[1,0,0,0,1,0,0,1,0,1,0,0,1,0], [0,1,0,0,0,1,0,0,1,1,0,0,0,1]]],
[[5,32,58,52,16],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[74,84,103,101,82],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[15,51,57,33,6],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[81,100,102,85,75],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[7,34,59,53,17],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]]];
  elif p=7 then return [
[[1,18,62,66,61,36,9],[[1,0,0,0,0,0],[1,1,0,0,0,0],[0,1,1,0,0,0],
[0,0,1,1,0,0],[0,0,0,1,1,0],[0,0,0,0,1,1],[0,0,0,0,0,1]]],
[[68,74,89,95,106,101,78],[[1,0,0,0,0,0],[1,1,0,0,0,0],[0,1,1,0,0,0],
[0,0,1,1,0,0],[0,0,0,1,1,0],[0,0,0,0,1,1],[0,0,0,0,0,1]]],
[[8,35,60,67,63,19,2],[[1,0,0,0,0,0],[1,1,0,0,0,0],[0,1,1,0,0,0],
[0,0,1,1,0,0],[0,0,0,1,1,0],[0,0,0,0,1,1],[0,0,0,0,0,1]]],
[[77,100,105,96,90,75,69],[[1,0,0,0,0,0],[1,1,0,0,0,0],[0,1,1,0,0,0],
[0,0,1,1,0,0],[0,0,0,1,1,0],[0,0,0,0,1,1],[0,0,0,0,0,1]]]];
  else return [];
  fi;
end);

CHEVIE.AddData("UnipotentCharacters","E8",function()
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="E",indices:=[ 1 .. 8 ],rank:=8),
 levi:=[  ],eigenvalue:=1,
      parameterExponents:=[ 1, 1, 1, 1, 1, 1, 1, 1 ], cuspidalName:="",
      charNumbers:=[ 1 .. 112 ]),
    rec(relativeType:=rec(series:="A",indices:=[ 8 ],rank:=1),
 levi:=[ 1 .. 7 ],eigenvalue:=-E(4),
      parameterExponents:=[ 15 ], cuspidalName:="E_7[-i]",qEigen:=1/2,
      charNumbers:=[ 114, 113 ]),
    rec(relativeType:=rec(series:="A",indices:=[ 8 ],rank:=1),
 levi:=[ 1 .. 7 ],eigenvalue:=E(4),
      parameterExponents:=[ 15 ], cuspidalName:="E_7[i]",qEigen:=1/2,
      charNumbers:=[ 116, 115 ]),
    rec(relativeType:=rec(series:="F",indices:=[ 8, 7, 6, 1 ],rank:=4),
 levi:=[ 2 .. 5 ],eigenvalue:=-1,
      parameterExponents:=[ 1, 1, 4, 4 ], cuspidalName:="D_4",
      charNumbers:=[ 117, 119, 118, 120, 126, 123, 125, 124, 131, 139, 141,
  140, 138, 132, 133, 121, 128, 130, 129, 127, 135, 136, 134, 137, 122 ]),
    rec(relativeType:=rec(series:="G",indices:=[ 8, 7 ],rank:=2),
 levi:=[ 1 .. 6 ],eigenvalue:=E(3),
      parameterExponents:=[ 1, 9 ], cuspidalName:="E_6[\\zeta_3]",
      charNumbers:=[ 142, 145, 143, 144, 152, 153 ]),
    rec(relativeType:=rec(series:="G",indices:=[ 8, 7 ],rank:=2),
 levi:=[ 1 .. 6 ],eigenvalue:=E(3)^2,
      parameterExponents:=[ 1, 9 ], cuspidalName:="E_6[\\zeta_3^2]",
      charNumbers:=[ 148, 151, 149, 150, 146, 147 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=-1,
      parameterExponents:=[  ], cuspidalName:="E_8[-1]",
      charNumbers:=[ 154 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=-E(3)^2,
      parameterExponents:=[  ], cuspidalName:="E_8[-\\zeta_3^2]",
      charNumbers:=[ 155 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=-E(3),
      parameterExponents:=[  ], cuspidalName:="E_8[-\\zeta_3]",
      charNumbers:=[ 156 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=-E(4),
      parameterExponents:=[  ], cuspidalName:="E_8[-i]",
      charNumbers:=[ 157 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=E(3)^2,
      parameterExponents:=[  ], cuspidalName:="E_8[\\zeta_3^2]",
      charNumbers:=[ 158 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=E(3),
      parameterExponents:=[  ], cuspidalName:="E_8[\\zeta_3]",
      charNumbers:=[ 159 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=E(5)^4,
      parameterExponents:=[  ], cuspidalName:="E_8[\\zeta_5^4]",
      charNumbers:=[ 160 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=E(5)^3,
      parameterExponents:=[  ], cuspidalName:="E_8[\\zeta_5^3]",
      charNumbers:=[ 161 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=E(5)^2,
      parameterExponents:=[  ], cuspidalName:="E_8[\\zeta_5^2]",
      charNumbers:=[ 162 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=E(5),
      parameterExponents:=[  ], cuspidalName:="E_8[\\zeta_5]",
      charNumbers:=[ 163 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=E(4),
      parameterExponents:=[  ], cuspidalName:="E_8[i]",
      charNumbers:=[ 164 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=1,
      parameterExponents:=[  ], cuspidalName:="E_8[1]",
      charNumbers:=[ 165 ]),
    rec(relativeType:=rec(series:="A",indices:=[  ],rank:=0),
 levi:=[ 1 .. 8 ],eigenvalue:=1,
      parameterExponents:=[  ], cuspidalName:="E_8^2[1]",
      charNumbers:=[ 166 ])],
  families:=[
    Family("C1",[ 1 ]),
    Family("C1",[ 2 ]),
    Family("C1",[ 5 ]),
    Family("C1",[ 6 ]),
    Family("C1",[ 22 ]),
    Family("C1",[ 23 ]),
    Family("C1",[ 24 ]),
    Family("C1",[ 25 ]),
    Family("C1",[ 39 ]),
    Family("C1",[ 57 ]),
    Family("C1",[ 58 ]),
    Family("C1",[ 66 ]),
    Family("C1",[ 67 ]),
    Family("C1",[ 68 ]),
    Family("C1",[ 69 ]),
    Family("C1",[ 81 ]),
    Family("C1",[ 82 ]),
    Family("C1",[ 100 ]),
    Family("C1",[ 101 ]),
    Family("C1",[ 107 ]),
    Family("C1",[ 108 ]),
    Family("C1",[ 109 ]),
    Family("C1",[ 110 ]),
    Family("C2",[ 72, 10, 3, 117 ]),
    Family("C2",[ 15, 8, 74, 125 ]),
    Family("C2",[ 29, 77, 18, 118 ]),
    Family("C2",[ 54, 35, 89, 139 ]),
    Family("C2",[ 51, 91, 84, 129 ]),
    Family("C2",[ 64, 32, 102, 126 ]),
    Family("C2",[ 97, 27, 48, 140 ]),
    Family("C2",[ 111, 60, 95, 135 ]),
    Family("C2",[ 112, 61, 96, 136 ]),
    Family("C2",[ 65, 33, 103, 123 ]),
    Family("C2",[ 98, 28, 49, 141 ]),
    Family("C2",[ 52, 92, 85, 130 ]),
    Family("C2",[ 55, 36, 90, 138 ]),
    Family("C2",[ 30, 78, 19, 119 ]),
    Family("C2",[ 16, 9, 75, 124 ]),
    Family("C2",[ 73, 11, 4, 120 ]),
    Family("C'2",[ 105, 62, 115, 113 ]),
    Family("C'2",[ 63, 106, 116, 114 ]),
    Family("S3",[ 93, 40, 79, 86, 70, 128, 142, 148 ]),
    Family("S3",[ 43, 37, 13, 45, 20, 134, 143, 149 ]),
    Family("S3",[ 44, 38, 14, 46, 21, 137, 144, 150 ]),
    Family("S3",[ 94, 41, 80, 87, 71, 127, 145, 151 ]),
    Family("S5",[53,165,7,59,56,31,34,104,154,121,76,133,99,50,166,12,42,
      122,47,26,152,159,146,158,88,132,153,156,147,155,83,131,164,157,17,163,
      162,161,160])],
  a:=[ 0, 120, 3, 63, 2, 74, 16, 4, 52, 3, 63, 16, 8, 32, 4, 52, 16, 6, 42,
  8, 32, 12, 36, 6, 46, 16, 13, 25, 6, 42, 16, 12, 24, 16, 10, 30, 8, 32, 20,
  7, 37, 16, 8, 32, 8, 32, 16, 13, 25, 16, 10, 28, 16, 10, 30, 16, 14, 22,
  16, 15, 21, 11, 26, 12, 24, 14, 22, 1, 91, 7, 37, 3, 63, 4, 52, 16, 6, 42,
  7, 37, 5, 47, 16, 10, 28, 7, 37, 16, 10, 30, 10, 28, 7, 37, 15, 21, 13, 25,
  16, 9, 31, 12, 24, 16, 11, 26, 15, 21, 13, 23, 15, 21, 11, 26, 11, 26, 3,
  6, 42, 63, 16, 16, 24, 52, 4, 12, 37, 7, 10, 28, 16, 16, 16, 8, 15, 21, 32,
  30, 10, 13, 25, 7, 8, 32, 37, 16, 16, 7, 8, 32, 37, 16, 16, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 16 ],
  A:=[ 0, 120, 57, 117, 46, 118, 104, 68, 116, 57, 117, 104, 88, 112, 68,
  116, 104, 78, 114, 88, 112, 84, 108, 74, 114, 104, 95, 107, 78, 114, 104,
  96, 108, 104, 90, 110, 88, 112, 100, 83, 113, 104, 88, 112, 88, 112, 104,
  95, 107, 104, 92, 110, 104, 90, 110, 104, 98, 106, 104, 99, 105, 94, 109,
  96, 108, 98, 106, 29, 119, 83, 113, 57, 117, 68, 116, 104, 78, 114, 83,
  113, 73, 115, 104, 92, 110, 83, 113, 104, 90, 110, 92, 110, 83, 113, 99,
  105, 95, 107, 104, 89, 111, 96, 108, 104, 94, 109, 99, 105, 97, 107, 99,
  105, 94, 109, 94, 109, 57, 78, 114, 117, 104, 104, 108, 116, 68, 96, 113,
  83, 92, 110, 104, 104, 104, 88, 99, 105, 112, 110, 90, 95, 107, 83, 88,
  112, 113, 104, 104, 83, 88, 112, 113, 104, 104, 104, 104, 104, 104, 104,
  104, 104, 104, 104, 104, 104, 104, 104 ]);
end);

CHEVIE.AddData("Invariants","E8",function()local r;
 r:=CoxeterGroup("E",8).roots{[1..120]}*CartanMat("E",8); 
 return List(CHEVIE.RawData("ReflectionDegrees","E8"),
   d-> function(arg) return Sum(r,a->(arg*a)^d);end);
end);

CHEVIE.AddData("UnipotentClasses","E8",function(p)local uc,Z,l,l1,i,s,c;
  if p=0 then p:=1;fi;Z:=n->ComplexReflectionGroup(n,1,1);
 uc:=rec(classes:=[
rec(name:="E_8",succ:="",dynkin:=[2,2,2,2,2,2,2,2],Au:=Z(Gcd(60,p^2))),
rec(name:="E_8(a_1)",succ:=["E8"],dynkin:=[2,2,2,0,2,2,2,2],Au:=Z(Gcd(12,p^2))),
rec(name:="E_8(a_2)",succ:=["E8(a1)"],dynkin:=[2,2,2,0,2,0,2,2],
  Au:=Z(Gcd(2,p))),
rec(name:="E_8(a_3)",mizuno:="E_7{+}A_1",succ:=["E8(a2)"],
  dynkin:=[2,0,0,2,0,2,2,2],Au:=Z(2)*Z(Gcd(6,p))),
rec(name:="E_7",succ:=["E8(a3)"],dynkin:=[2,1,1,0,1,2,2,2],Au:=Z(Gcd(12,p^2))),
rec(name:="E_8(a_4)",mizuno:="D_8",succ:=["E8(a3)"],
  dynkin:=[2,0,0,2,0,2,0,2],Au:=Z(2)),
rec(name:="E_8(b_4)",mizuno:="E_7(a_1){+}A_1",succ:=["E7","E8(a4)"],
  dynkin:=[2,0,0,2,0,0,2,2],Au:=Z(2)),
rec(name:="E_7(a_1)",succ:=["E8(b4)"],dynkin:=[2,1,1,0,1,0,2,2],
  Au:=Z(Gcd(2,p))),
rec(name:="E_8(a_5)",mizuno:="D_8(a_1)",succ:=["E8(b4)"],
  dynkin:=[2,0,0,2,0,0,2,0],Au:=CoxeterGroup("B",Gcd(2,p))),
rec(name:="E_8(b_5)",mizuno:="E_7(a_2){+}A_1",succ:=["E7(a1)","E8(a5)"],
  dynkin:=[0,0,0,2,0,0,2,2],Au:=CoxeterGroup("A",2)*Z(Gcd(2,p))),
rec(name:="D_7",succ:=["E8(a5)"],dynkin:=[2,1,1,0,1,1,0,1],Au:=Z(Gcd(2,p))),
rec(name:="E_7(a_2)",succ:=["E8(b5)"],dynkin:=[0,1,1,0,1,0,2,2],
  Au:=Z(Gcd(2,p))),
rec(name:="E_8(a_6)",mizuno:="A_8",succ:=["E8(b5)","D7"],
  dynkin:=[0,0,0,2,0,0,2,0],Au:=CoxeterGroup("A",2)),
rec(name:="E_6{+}A_1",succ:=["E7(a2)"],dynkin:=[1,0,0,1,0,1,2,2],Au:=Z(Gcd(6,p))),
rec(name:="D_7(a_1)",succ:=["E7(a2)","E8(a6)"],dynkin:=[2,0,0,0,2,0,0,2],
  Au:=Z(Gcd(2,p-1))),
rec(name:="E_6",succ:=["E6+A1"],dynkin:=[2,0,0,0,0,2,2,2],Au:=Z(Gcd(6,p))),
rec(name:="E_7(a_3)",mizuno:="D_6{+}A_1",succ:=["D7(a1)"],
  dynkin:=[2,0,0,1,0,1,0,2],Au:=Z(2)),
rec(name:="E_8(b_6)",mizuno:="D_8(a_3)",succ:=["D7(a1)","E6+A1"],
  dynkin:=[0,0,0,2,0,0,0,2],Au:=CoxeterGroup("A",2-(Gcd(3,p)-1)/2)),
rec(name:="D_6",succ:=["E7(a3)"],dynkin:=[2,1,1,0,0,0,1,2],Au:=Z(Gcd(2,p))),
rec(name:="E_6(a_1){+}A_1",succ:=["E7(a3)","E8(b6)"],dynkin:=[1,0,0,1,0,1,0,2],
  Au:=Z(2)),
rec(name:="A_7",succ:=["E8(b6)"],dynkin:=[1,0,0,1,0,1,1,0],Au:=Z(1)),
rec(name:="D_7(a_2)",succ:=["E6(a1)+A1","A7"],dynkin:=[1,0,0,1,0,1,0,1],
  Au:=Z(2)),
rec(name:="E_6(a_1)",succ:=["E6","E6(a1)+A1"],dynkin:=[2,0,0,0,0,2,0,2],
  Au:=Z(2)),
rec(name:="D_5{+}A_2",succ:=["D6","D7(a2)"],dynkin:=[0,0,0,0,2,0,0,2],
  Au:=Z(Gcd(2,p-1))),
rec(name:="E_7(a_4)",mizuno:="D_6(a_1){+}A_1",succ:=["E6(a1)","D5+A2"],
  dynkin:=[0,0,0,1,0,1,0,2],Au:=Z(Gcd(2,p-1))),
rec(name:="A_6{+}A_1",succ:=["D5+A2"],dynkin:=[1,0,0,1,0,1,0,0],Au:=Z(1)),
rec(name:="D_6(a_1)",succ:=["E7(a4)"],dynkin:=[0,1,1,0,0,0,1,2],
  Au:=Z(2)*Z(Gcd(2,p))),
rec(name:="A_6",succ:=["E7(a4)","A6+A1"],dynkin:=[2,0,0,0,0,2,0,0],
  Au:=Z(Gcd(2,p))),
rec(name:="E_8(a_7)",mizuno:="2A_4",succ:=["D6(a1)","A6"],
  dynkin:=[0,0,0,0,2,0,0,0],Au:=CoxeterGroup("A",4)),
rec(name:="D_5{+}A_1",succ:=["D6(a1)"],dynkin:=[1,0,0,0,1,0,1,2],Au:=Z(Gcd(2,p))),
rec(name:="E_7(a_5)",mizuno:="A_5{+}A_2",succ:=["E8(a7)","D5+A1"],
  dynkin:=[0,0,0,1,0,1,0,0],Au:=CoxeterGroup("A",2)),
rec(name:="D_5",succ:=["D5+A1"],dynkin:=[2,0,0,0,0,0,2,2],Au:=Z(Gcd(2,p))),
rec(name:="E_6(a_3){+}A_1",mizuno:="A_5{+}2A_1",succ:=["E7(a5)"],
  dynkin:=[1,0,0,0,1,0,1,0],Au:=Z(2)),
rec(name:="D_6(a_2)",succ:=["E7(a5)"],dynkin:=[0,1,1,0,0,0,1,0],Au:=Z(2)),
rec(name:="E_6(a_3)",mizuno:="(A_5{+}A_1)''",succ:=["D5","E6(a3)+A1"],
  dynkin:=[2,0,0,0,0,0,2,0],Au:=Z(2)),
rec(name:="A_5{+}A_1",mizuno:="(A_5{+}A_1)'",succ:=["E6(a3)+A1","D6(a2)"],
  dynkin:=[1,0,0,1,0,0,0,1],Au:=Z(1)),
rec(name:="D_5(a_1){+}A_2",succ:=["E6(a3)+A1","D6(a2)"],
  dynkin:=[0,0,1,0,0,1,0,1],Au:=Z(1)),
rec(name:="A_4{+}A_3",succ:=["A5+A1","D5(a1)+A2"],dynkin:=[0,0,0,1,0,0,1,0],
  Au:=Z(1)),
rec(name:="D_4{+}A_2",succ:=["D5(a1)+A2"],dynkin:=[0,2,0,0,0,0,0,2],
  Au:=Z(Gcd(2,p-1))),
rec(name:="A_5",succ:=["E6(a3)","A5+A1"],dynkin:=[2,0,0,0,0,1,0,1],Au:=Z(1)),
rec(name:="A_4{+}A_2{+}A_1",succ:=["A4+A3","D4+A2"],dynkin:=[0,0,1,0,0,1,0,0],
  Au:=Z(1)),
rec(name:="D_5(a_1){+}A_1",succ:=["E6(a3)","D4+A2"],dynkin:=[0,0,0,1,0,0,0,2],
  Au:=Z(1)),
rec(name:="D_5(a_1)",succ:=["D5(a1)+A1"],dynkin:=[1,0,0,0,0,1,0,2],Au:=Z(2)),
rec(name:="A_4{+}A_2",succ:=["A5","A4+A2+A1","D5(a1)+A1"],
  dynkin:=[0,0,0,0,0,2,0,0],Au:=Z(1)),
rec(name:="A_4{+}2A_1",succ:=["A4+A2"],dynkin:=[0,0,0,1,0,0,0,1],Au:=Z(2)),
rec(name:="D_4{+}A_1",succ:=["D5(a1)"],dynkin:=[0,1,0,0,0,0,1,2],Au:=Z(Gcd(2,p))),
rec(name:="A_4{+}A_1",succ:=["A4+2A1","D5(a1)"],dynkin:=[1,0,0,0,0,1,0,1],
  Au:=Z(2)),
rec(name:="2A_3",succ:=["A4+2A1"],dynkin:=[1,0,0,0,1,0,0,0],Au:=Z(1)),
rec(name:="D_4",succ:=["D4+A1"],dynkin:=[0,0,0,0,0,0,2,2],Au:=Z(Gcd(2,p))),
rec(name:="A_4",succ:=["A4+A1"],dynkin:=[2,0,0,0,0,0,0,2],Au:=Z(2)),
rec(name:="D_4(a_1){+}A_2",succ:=["A4+A1","2A3"],dynkin:=[0,2,0,0,0,0,0,0],
  Au:=Z(2)),
rec(name:="A_3{+}A_2{+}A_1",succ:=["D4+A1","D4(a1)+A2"],dynkin:=[0,0,0,1,0,0,0,0],
  Au:=Z(1)),
rec(name:="A_3{+}A_2",succ:=["A4","A3+A2+A1"],dynkin:=[1,0,0,0,0,1,0,0],
  Au:=Z(Gcd(2,p-1))),
rec(name:="D_4(a_1){+}A_1",succ:=["A3+A2"],dynkin:=[0,1,0,0,0,0,1,0],
  Au:=CoxeterGroup("A",2)),
rec(name:="A_3{+}2A_1",succ:=["D4(a1)+A1"],dynkin:=[0,0,1,0,0,0,0,1],Au:=Z(1)),
rec(name:="D_4(a_1)",succ:=["D4","D4(a1)+A1"],dynkin:=[0,0,0,0,0,0,2,0],
  Au:=CoxeterGroup("A",2)),
rec(name:="2A_2{+}2A_1",succ:=["A3+2A1"],dynkin:=[0,0,0,0,1,0,0,0],Au:=Z(1)),
rec(name:="A_3{+}A_1",succ:=["A3+2A1","D4(a1)"],dynkin:=[0,0,0,0,0,1,0,1],
  Au:=Z(1)),
rec(name:="2A_2{+}A_1",succ:=["2A2+2A1","A3+A1"],dynkin:=[1,0,0,0,0,0,1,0],
  Au:=Z(1)),
rec(name:="A_3",succ:=["D4(a1)","A3+A1"],dynkin:=[1,0,0,0,0,0,0,2],Au:=Z(1)),
rec(name:="2A_2",succ:=["2A2+A1"],dynkin:=[2,0,0,0,0,0,0,0],Au:=Z(2)),
rec(name:="A_2{+}3A_1",succ:=["2A2"],dynkin:=[0,0,1,0,0,0,0,0],Au:=Z(1)),
rec(name:="A_2{+}2A_1",succ:=["A3","A2+3A1"],dynkin:=[0,0,0,0,0,1,0,0],Au:=Z(1)),
rec(name:="A_2{+}A_1",succ:=["A2+2A1"],dynkin:=[1,0,0,0,0,0,0,1],Au:=Z(2)),
rec(name:="4A_1",succ:=["A2+A1"],dynkin:=[0,1,0,0,0,0,0,0],Au:=Z(1)),
rec(name:="A_2",succ:=["A2+A1"],dynkin:=[0,0,0,0,0,0,0,2],Au:=Z(2)),
rec(name:="3A_1",succ:=["4A1","A2"],dynkin:=[0,0,0,0,0,0,1,0],Au:=Z(1)),
rec(name:="2A_1",succ:=["3A1"],dynkin:=[1,0,0,0,0,0,0,0],Au:=Z(1)),
rec(name:="A_1",succ:=["2A1"],dynkin:=[0,0,0,0,0,0,0,1],Au:=Z(1)),
rec(name:="1",succ:=["A1"],dynkin:=[0,0,0,0,0,0,0,0],Au:=Z(1))],
springerSeries:=[rec(relgroup:=CoxeterGroup("E",8),levi:="",Z:=[],
  locsys:=[[1,1],[70,1],[4,1],[66,1],[3,1],[68,1],[29,2],[7,1],[65,1],[5,1],
    [67,1],[39,1],[18,2],[57,1],[6,2],[64,2],[38,1],[9,1],[61,1],[13,1],[54,1],
    [16,1],[49,1],[8,1],[60,1],[33,1],[25,1],[46,1],[9,2],[61,2],[29,3],[24,1],
    [48,1],[29,4],[19,1],[53,1],[15,1],[55,1],[32,1],[12,1],[58,1],[34,1],
    [13,3],[54,3],[13,2],[54,2],[33,2],[23,1],[43,1],[34,2],[18,3],[51,2],
    [29,7],[17,2],[50,2],[29,5],[26,1],[41,1],[29,6],[30,1],[40,1],[20,1],
    [47,2],[22,2],[45,2],[25,2],[42,1],[2,1],[69,1],[10,1],[56,1],[4,2],[66,2],
    [6,1],[64,1],[31,1],[11,1],[62,1],[14,1],[59,1],[7,2],[63,1],[37,1],[18,1],
    [51,1],[10,2],[56,2],[36,1],[17,1],[50,1],[21,1],[52,1],[10,3],[56,3],
    [27,1],[35,1],[23,2],[43,2],[31,2],[15,2],[53,2],[22,1],[45,1],[31,3],
    [20,2],[47,1],[28,1],[39,2],[24,2],[44,1],[27,2],[35,2]]),
   rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[29,1]],
     parameter:=165)],# Fourier transform of 165th unip. character
  operations:=UnipotentClassesOps); 
  if p=2 then Append(uc.classes,[
    rec(name:="(D_7(a_1))_2",succ:=["D7(a1)"],dimBu:=10,Au:=Z(2)),
    rec(name:="(D_5{+}A_2)_2",succ:=["D5+A2"],dimBu:=14,Au:=Z(2)),
    rec(name:="(D_4{+}A_2)_2",succ:=["D4+A2"],dimBu:=24,Au:=Z(2)),
    rec(name:="(A_3{+}A_2)_2",succ:=["A3+A2"],dimBu:=32,Au:=Z(1))]);
    for i in [19,21] do Add(uc.classes[i].succ,"(D7(a1))2");od;
    for i in [29,30] do Add(uc.classes[i].succ,"(D5+A2)2");od;
    for i in [46,48] do Add(uc.classes[i].succ,"(D4+A2)2");od;
    Add(uc.classes[55].succ,"(A3+A2)2");
l:=
[["E8",3,"1_1"],["E8(a1)",3,"2_1"],["E8(a2)",1,"4_1"],["E7+A1",2,"8_1"],
 ["E7+A1",3,"1_2"],["E7",3,"9_1"],["E7(a1)+A1",1,"4_2"],["E7(a1)",1,"9_2"],
 ["D8(a1)",3,"8_3"],["D7",1,"2_3"],["E7(a2)+A1",5,"12"],
 ["E7(a2)+A1",3,"6_2"],["E7(a2)",1,"16"],["E6+A1",1,"6_1"],
 ["(D7(a1))_2",1,"4"],["E6",1,"8_4"],["D6",1,"9_3"],["(D5+A2)_2",1,"4_3"],
 ["D6(a1)",2,"9_4"],["D6(a1)",3,"2_4"],["D5+A1",1,"8_2"],["D_5",1,"4_4"],
 ["(D4+A2)2",1,"1_3"],["D4+A1",1,"2_2"],["D_4",1,"1_4"]];
  l1:=[];
  for i in [1..Length(l)] do
    s:=PositionProperty(l,x->x[3]=CHEVIE.RawData("CharInfo","F4")().kondo[i]);
    l1[i]:=[PositionProperty([1..Length(uc.classes)],
      i->ClassName(uc,i,rec(mizuno:=true))=Replace(l[s][1],"_","")),l[s][2]];
  od;
  uc.springerSeries[1].locsys:=[[1,1],[70,1],[4,1],[66,1],[3,2],[68,1],[29,2],
   [9,1],[65,1],[5,1],[67,1],[73,2],[18,2],[57,1],[6,2],[64,2],[38,1],[9,2],
   [61,1],[13,1],[54,1],[16,2],[49,2],[8,2],[60,1],[33,1],[28,1],[46,2],[9,4],
   [61,2],[29,3],[72,2],[48,1],[29,4],[19,2],[74,1],[71,2],[55,1],[32,2],[12,2],
   [58,1],[34,1],[13,3],[54,3],[13,2],[54,2],[33,2],[23,1],[43,1],[34,2],[18,3],
   [51,2],[29,7],[17,2],[50,2],[29,5],[26,1],[41,1],[29,6],[30,2],[40,1],[20,1],
   [47,2],[22,2],[45,2],[25,1],[42,1],[2,1],[69,1],[10,2],[56,1],[4,4],[66,2],
   [6,1],[64,1],[31,1],[11,2],[62,1],[14,2],[59,1],[7,2],[63,1],[37,1],[18,1],
   [51,1],[10,4],[56,2],[36,1],[17,1],[50,1],[21,1],[52,1],[10,6],[56,3],[27,1],
   [35,1],[23,2],[43,2],[31,2],[15,1],[53,1],[22,1],[45,1],[31,3],[20,2],[47,1],
   [28,2],[39,1],[24,1],[44,1],[27,4],[35,2]];
  Append(uc.springerSeries,[
    rec(relgroup:=CoxeterGroup("F",4),levi:=[2..5],Z:=[],locsys:=l1),
    rec(relgroup:=CoxeterGroup("A",1),levi:=[1..7],Z:=[],locsys:=[[5,2],[1,2]]),
    rec(relgroup:=CoxeterGroup("A",1),levi:=[1..7],Z:=[],locsys:=[[5,4],[1,4]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[2,2]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[2,4]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[9,5]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[10,1]])]);
  elif p=3 then Add(uc.classes,
    rec(name:="(A_7)_3",succ:=["A7"],dimBu:=12,Au:=Z(1)));
    Add(uc.classes[26].succ,"(A7)3");
    Append(uc.springerSeries,[
      rec(relgroup:=CoxeterGroup("G",2),levi:=[1..6],Z:=[],locsys:=[
       [1,2],[16,2],[14,2],[2,2],[4,5],[5,2]],
warning:="The Springer correspondents of 2-dim reps of G2 could be exchanged"),
#      [1,2],[16,2],[14,2],[2,2],[5,2],[4,5]],
      rec(relgroup:=CoxeterGroup("G",2),levi:=[1..6],Z:=[],locsys:=[
       [1,3],[16,3],[14,3],[2,3],[4,6],[5,3]],
warning:="The Springer correspondents of 2-dim reps of G2 could be exchanged"),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[4,2]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[4,3]])]);
    uc.springerSeries[1].locsys[72][2]:=4;
    uc.springerSeries[1].locsys{[13,51]}:=[[71,1],[18,2]];
  elif p=5 then Append(uc.springerSeries,[
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[1,2]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[1,3]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[1,4]]),
    rec(relgroup:=CoxeterGroup(),levi:=[1..8],Z:=[],locsys:=[[1,5]])]);
  fi;
  uc.orderClasses:=List(uc.classes,c->List(c.succ,
    n->PositionProperty([1..Length(uc.classes)],c->ClassName(uc,c)=n)));
  for c in uc.classes do Unbind(c.succ);od;
  return uc;
end);

CHEVIE.AddData("KLeftCellRepresentatives","E8",
[rec(character:=[1],
reps:=[],
duflo:=[1,2,3,4,5,6,7,8]),rec(character:=[68],
reps:=[],
duflo:=[1,2,3,4,5,6,15,128]),rec(character:=[5],
reps:=[],
duflo:=[47,3,2,4,5,6,7,194]),rec(character:=[72,3],
reps:=[[43,174,156,60,136,24,6,7]],
duflo:=[163,54,3,4,5,6,7,159]),rec(character:=[72,10],
reps:=[[6,2,5,4,84,199,218,101],[1,2,3,4,5,6,7,239]],
duflo:=[6,2,5,4,3,1,74,240]),rec(character:=[74,15],
reps:=[[23,176,136,77,192,78,193,79]],
duflo:=[163,9,50,4,5,6,7,199]),rec(character:=[15,8],
reps:=[[152,5,121,16,2,28,127,15],[152,2,44,150,5,53,127,15]],
duflo:=[121,5,37,138,2,28,127,15]),rec(character:=[81],
reps:=[[96,211,212,95,210,94,9,121]],
duflo:=[194,81,7,6,5,4,3,234]),rec(character:=[24],
reps:=[],
duflo:=[121,2,9,4,5,6,7,239]),rec(character:=[29,18],
reps:=[[143,197,30,83,198,84,159,162],[107,212,211,95,210,94,157,44]],
duflo:=[182,2,5,4,3,73,7,224]),rec(character:=[77,29],
reps:=[[190,5,174,107,191,156,43,34],[70,187,184,72,185,91,194,96],[102,220,
219,103,203,87,202,97],[222,100,3,4,5,23,221,8]],
duflo:=[190,67,4,3,34,31,227,23]),rec(character:=[93,79,40],
reps:=[[5,162,4,100,186,163,195,104],[107,67,185,179,188,108,4,2],[107,187,
185,181,108,184,70,2],[47,3,2,4,5,6,238,97],[6,2,5,4,3,1,221,8]],
duflo:=[66,5,3,4,2,47,240,68]),rec(character:=[93,86,40],
reps:=[[163,4,172,90,162,171,107,224],[107,92,211,144,188,90,4,3],[211,212,
151,109,150,188,94,3],[222,5,3,4,2,39,68,238],[164,5,3,4,2,31,7,239]],
duflo:=[189,3,2,4,5,6,104,240]),rec(character:=[43,37,13],
reps:=[[159,44,46,150,67,135,165,175],[81,166,164,156,47,49,52,165],[81,166,
164,156,88,169,89,165],[217,14,116,223,20,95,212,47],[223,8,107,221,52,102,
215,2]],
duflo:=[201,11,91,208,36,97,209,55]),rec(character:=[45,43,37],
reps:=[[77,138,144,142,29,23,28,127],[130,136,163,77,132,174,79,127],[144,138,
176,81,143,149,79,127],[197,9,81,150,5,53,127,193],[144,23,72,185,11,79,127,
214]],
duflo:=[176,18,77,157,23,28,127,193]),rec(character:=[100],
reps:=[[71,55,166,139,146,69,137,50],[71,175,166,75,164,146,90,170],[166,175,
147,93,164,146,90,170]],
duflo:=[46,175,191,93,189,26,24,50]),rec(character:=[91,51],
reps:=[[34,160,31,121,155,70,132,36],[34,160,31,121,155,88,142,132],[151,160,
154,89,157,155,88,156],[151,79,83,223,89,157,155,58],[99,183,179,142,47,61,
155,58],[179,183,176,110,181,167,107,178]],
duflo:=[131,39,49,173,45,126,132,36]),rec(character:=[89,54],
reps:=[[109,136,166,188,103,148,201,102]],
duflo:=[155,46,3,4,5,6,151,232]),rec(character:=[105,62],
reps:=[[144,215,169,119,191,156,143,65],[100,150,149,196,111,180,175,102]],
duflo:=[217,2,71,4,5,65,240,73]),rec(character:=[93,86,86,70],
reps:=[[163,148,84,129,162,60,5,6],[84,148,166,128,60,136,24,6],[166,148,163,
88,136,162,67,6],[204,143,88,148,128,42,24,6]],
duflo:=[204,2,74,16,5,6,186,128]),rec(character:=[102,64],
reps:=[[164,174,154,113,172,176,159,92],[65,169,142,150,113,165,182,159],[193,
185,103,154,183,117,182,159]],
duflo:=[221,22,116,223,20,95,182,159]),rec(character:=[45,45,43,20],
reps:=[[166,136,91,170,148,92,187,73],[91,136,176,141,92,192,78,193],[176,53,
129,154,95,212,96,193],[176,136,166,104,192,148,96,193]],
duflo:=[144,46,5,4,3,73,216,201]),rec(character:=[22],
reps:=[],
duflo:=[6,2,5,4,3,1,217,128]),rec(character:=[64,32],
reps:=[[70,187,184,109,151,154,163,143],[221,2,8,70,6,5,228,3],[220,187,103,
169,151,114,163,143]],
duflo:=[235,43,41,37,6,5,226,42]),rec(character:=[97,27],
reps:=[[111,143,144,188,127,84,18,11],[152,2,44,150,5,53,127,238]],
duflo:=[121,5,37,138,2,28,127,238]),rec(character:=[109],
reps:=[[99,165,179,170,115,164,134,207],[201,220,148,119,184,165,163,87]],
duflo:=[225,21,3,4,38,62,207,195]),rec(character:=[84,51],
reps:=[[149,150,92,155,180,107,151,154],[38,149,150,95,161,180,202,114],[194,
195,158,113,187,196,114,185]],
duflo:=[233,41,38,4,29,44,234,82]),rec(character:=[57],
reps:=[[213,132,98,198,130,113,150,208]],
duflo:=[229,75,71,213,48,146,86,28]),rec(character:=[100],
reps:=[[4,179,72,128,178,107,151,194],[109,203,220,103,173,182,102,155],[220,
203,144,111,173,182,102,155]],
duflo:=[222,100,3,4,5,23,217,128]),rec(character:=[111,60],
reps:=[[114,153,183,127,193,103,30,143],[168,2,5,4,3,164,194,120]],
duflo:=[164,2,3,4,5,168,127,119]),rec(character:=[107],
reps:=[[108,46,175,129,146,135,81,137],[86,147,128,154,164,102,204,109]],
duflo:=[55,220,184,115,218,43,52,187]),rec(character:=[81],
reps:=[[32,144,138,59,148,143,45,15]],
duflo:=[190,9,75,166,14,52,165,60]),rec(character:=[104,88,83,53,50,47,17],
reps:=[[65,126,131,150,156,111,159,130],[132,73,77,128,159,130,147,150],[107,
131,126,179,128,94,130,177],[186,104,131,150,142,132,94,130],[66,174,126,132,
178,88,69,130],[65,159,89,152,126,150,156,87],[185,159,116,152,126,150,156,
87],[66,174,126,132,178,116,130,177],[116,146,152,159,128,87,147,150],[233,40,
66,196,70,132,87,177],[89,86,152,126,150,156,178,114],[152,65,159,128,200,118,
147,150],[152,113,126,179,128,178,114,177],[186,160,113,150,142,132,178,114],
[81,179,174,131,146,80,36,57],[113,126,174,152,159,114,177,156],[81,179,174,
131,146,80,87,177],[218,82,32,209,80,178,104,150],[81,179,174,131,146,118,177,
156],[237,78,81,206,40,131,88,156],[98,132,128,191,130,113,150,208],[32,147,
109,179,128,178,146,103],[152,147,117,179,128,178,146,103],[229,81,78,218,48,
146,103,156],[82,152,179,126,192,90,58,36],[117,174,179,147,130,103,156,178],
[82,152,179,126,192,90,88,156],[82,152,179,126,192,120,156,178],[230,79,82,
229,78,126,80,178],[225,75,56,219,79,174,90,146]],
duflo:=[227,70,65,197,67,150,69,130]),rec(character:=[104,104,99,88,59,56,53,
50,47,42],
reps:=[[83,178,142,132,158,66,81,130],[46,151,94,138,142,164,148,92],[203,132,
127,158,113,130,149,164],[83,178,142,132,158,113,130,192],[113,176,138,151,
127,92,149,164],[63,138,91,178,128,148,158,109],[138,166,151,176,86,92,149,
164],[183,138,116,178,128,148,158,109],[142,127,132,171,116,130,192,186],[116,
142,178,138,151,109,192,148],[178,183,138,142,56,38,28,72],[138,166,151,176,
120,149,164,148],[2,171,88,127,128,186,152,117],[87,95,163,138,129,148,206,
116],[178,183,138,142,56,38,92,192],[95,172,166,163,130,86,28,44],[163,109,
138,151,127,206,116,164],[95,172,166,163,130,86,70,164],[178,183,138,142,56,
109,192,148],[109,138,166,163,165,116,164,148],[91,156,127,171,138,117,192,
186],[58,186,129,152,142,83,95,212],[95,172,166,163,130,116,164,148],[75,132,
127,171,162,120,192,186],[95,132,127,198,130,116,164,186],[178,183,138,142,
120,192,148,158],[240,64,91,195,18,76,148,158],[18,149,114,183,127,158,176,
103],[11,182,109,151,127,189,142,103],[87,138,183,142,184,102,38,28],[117,178,
183,149,130,103,148,158],[166,151,163,138,117,164,148,206],[237,58,95,204,43,
66,148,206],[87,138,183,142,184,102,66,148],[234,46,102,215,29,89,148,206],
[87,189,132,142,184,95,76,186],[87,138,183,142,184,119,148,158],[106,169,186,
128,184,84,63,2],[114,166,151,152,149,106,148,206],[106,169,186,128,184,114,
183,69],[183,138,149,178,119,148,158,176],[239,20,114,207,29,69,158,176],[63,
163,151,138,178,119,148,206],[103,202,200,128,127,84,18,11],[106,196,154,128,
184,115,158,152],[238,2,106,215,72,49,152,142],[96,183,163,154,129,58,90,206],
[230,31,89,186,14,90,206,184],[238,2,89,154,14,62,176,184],[232,11,80,196,28,
78,142,184],[218,5,93,205,2,96,194,129]],
duflo:=[240,5,94,138,2,70,164,186]),rec(character:=[97,48],
reps:=[[100,150,149,169,151,111,180,65]],
duflo:=[185,29,3,4,30,6,238,112]),rec(character:=[105,62],
reps:=[[24,185,2,88,127,165,149,152],[121,5,101,210,2,96,204,209]],
duflo:=[188,2,106,215,72,49,152,227]),rec(character:=[66],
reps:=[[115,190,191,128,154,103,165,52]],
duflo:=[202,38,5,4,3,34,195,188]),rec(character:=[104,99,83,59,53,50,47,26],
reps:=[[131,126,166,132,111,167,130,177],[193,104,131,150,134,132,89,130],[73,
166,126,132,185,88,69,130],[58,167,94,152,126,150,148,82],[178,167,116,152,
126,150,148,82],[107,131,126,150,156,94,130,202],[116,146,152,129,156,87,147,
179],[126,166,187,131,116,130,177,148],[94,80,152,126,150,148,185,114],[193,
160,113,150,134,132,185,114],[195,94,126,132,174,131,88,57],[75,187,166,131,
146,86,28,57],[113,126,166,152,167,114,177,148],[152,178,167,146,118,147,150,
148],[195,94,126,132,174,131,114,177],[193,80,94,130,147,150,148,185],[75,187,
166,131,146,86,82,177],[99,150,199,131,146,80,87,202],[237,71,75,200,40,131,
65,28],[166,187,152,126,118,177,148,185],[237,96,99,223,40,131,58,8],[93,109,
147,166,132,185,146,103],[99,134,156,150,160,118,202,185],[147,117,166,152,
167,146,103,148],[195,191,117,132,174,131,146,103],[147,117,199,152,129,146,
80,8],[87,152,187,126,184,85,65,28],[117,166,187,147,130,103,148,185],[229,99,
96,230,48,146,80,8],[87,152,187,126,184,85,88,148],[57,152,150,126,212,106,58,
8],[96,169,156,129,168,117,179,206],[230,79,87,229,71,126,26,65],[187,152,147,
166,119,148,185,146],[119,187,195,147,98,176,129,146],[93,46,169,150,126,212,
120,185],[235,56,93,230,96,134,7,26],[225,81,49,219,79,166,64,26],[198,85,68,
232,81,187,79,19]],
duflo:=[233,40,73,203,77,132,28,57]),rec(character:=[39],
reps:=[],
duflo:=[201,3,2,4,5,168,127,74]),rec(character:=[54,35],
reps:=[[71,75,141,143,139,146,52,50],[32,200,164,97,202,27,7,90]],
duflo:=[1,202,157,89,200,51,7,90]),rec(character:=[108],
reps:=[[134,131,80,122,140,129,175,108],[114,166,164,140,170,112,169,125]],
duflo:=[69,131,200,76,140,184,55,78]),rec(character:=[112,61],
reps:=[[112,92,211,125,124,123,193,101],[44,122,123,124,125,48,7,239]],
duflo:=[48,122,125,124,123,44,74,240]),rec(character:=[58],
reps:=[[163,140,114,164,134,125,206,112]],
duflo:=[97,140,234,96,134,210,86,55]),rec(character:=[107],
reps:=[[80,152,146,129,148,111,180,147],[191,207,152,110,148,185,146,113]],
duflo:=[191,88,61,230,87,193,86,59]),rec(character:=[100],
reps:=[[77,138,144,142,79,148,143,45],[99,159,154,128,22,30,143,45],[154,159,
197,104,150,142,73,165]],
duflo:=[219,2,104,166,14,52,165,149]),rec(character:=[110],
reps:=[[122,128,112,169,125,126,157,123],[112,82,200,125,124,123,193,101]],
duflo:=[62,122,125,124,123,193,118,181]),rec(character:=[104,104,99,99,59,59,
56,56,53,50,42,34,31],
reps:=[[156,136,103,146,127,147,174,109],[103,161,146,136,149,109,179,147],
[165,105,127,153,156,129,109,202],[45,156,146,129,169,119,179,147],[161,173,
105,147,135,146,129,109],[83,153,163,121,169,58,42,82],[83,153,163,121,169,58,
106,202],[105,127,163,146,136,111,202,174],[146,156,136,161,119,179,147,174],
[223,85,111,172,127,147,143,149],[83,153,163,121,169,119,202,162],[83,170,147,
121,169,119,212,146],[184,111,146,136,149,169,105,147],[163,51,146,136,161,
119,202,174],[163,153,165,127,119,202,162,129],[92,136,156,161,172,89,78,147],
[165,179,118,153,156,129,169,91],[111,146,156,129,175,108,147,211],[147,86,
135,146,136,161,119,229],[65,162,143,147,127,41,111,229],[92,136,156,161,172,
118,147,174],[163,16,3,42,82,238,127,49],[105,177,203,127,146,89,29,23],[85,
165,153,127,207,110,9,42],[205,111,163,121,160,127,91,162],[85,165,153,127,
207,110,54,162],[156,70,129,175,165,118,147,211],[114,153,203,127,172,113,143,
149],[108,203,153,127,172,113,162,129],[118,163,153,121,175,95,162,178],[156,
136,184,146,118,147,174,169],[105,207,171,127,146,85,60,174],[97,146,171,127,
207,108,60,174],[85,165,153,127,207,120,162,129],[184,153,114,136,149,169,172,
113],[153,209,121,163,83,95,162,178],[114,156,136,153,179,113,174,169],[153,
165,179,163,120,162,129,169],[225,156,108,177,127,146,113,174],[153,114,156,
129,175,165,113,211],[86,205,165,135,147,87,49,9],[221,42,127,146,163,105,5,
4],[93,129,190,146,163,83,95,211],[51,184,136,146,163,120,174,169],[86,205,
165,135,147,87,58,129],[82,163,42,146,127,221,115,4],[205,170,113,121,160,127,
207,114],[143,3,2,4,109,238,135,8],[153,55,40,9,42,233,163,87],[113,153,165,
135,202,114,129,169],[180,95,153,127,172,163,114,129],[171,64,33,4,54,233,163,
87],[110,149,175,136,153,115,211,172],[115,136,184,162,147,110,169,172],[95,
153,184,156,143,65,89,169],[221,58,86,5,4,219,147,43],[54,153,129,156,195,102,
45,5],[99,160,175,121,170,115,178,207],[165,8,52,49,9,224,153,2],[215,33,42,
24,49,230,143,65],[174,33,42,16,5,207,195,102],[184,15,3,52,49,232,136,23],
[160,42,4,3,52,221,175,75]],
duflo:=[185,2,3,36,97,238,127,49]),rec(character:=[91,51],
reps:=[[157,184,149,109,158,148,185,91],[71,190,36,149,165,113,154,185],[191,
190,96,149,165,113,154,185],[156,190,191,114,192,165,113,211],[198,197,195,
116,196,162,106,172],[238,5,78,4,2,35,222,44]],
duflo:=[240,34,36,44,6,5,202,35]),rec(character:=[111,95],
reps:=[[4,162,115,171,127,172,163,96]],
duflo:=[213,2,3,4,5,14,127,188]),rec(character:=[100],
reps:=[[81,166,164,156,88,52,165,175],[113,183,186,135,36,58,169,55],[113,183,
186,135,88,178,64,175]],
duflo:=[222,42,110,226,5,107,221,69]),rec(character:=[104,99,99,76,59,59,56,
53,47,34,26],
reps:=[[136,103,153,148,128,166,109,172],[60,148,162,129,160,118,172,163],
[162,148,136,153,118,172,163,166],[42,143,128,148,153,118,172,204],[16,177,
106,148,128,166,160,105],[136,177,111,148,128,166,160,105],[177,111,162,136,
141,160,80,43],[177,111,162,136,141,160,105,163],[5,153,103,148,128,166,183,
114],[82,136,148,153,187,94,46,43],[180,172,120,170,148,129,160,80],[106,180,
148,153,144,114,163,166],[111,162,148,129,168,108,163,200],[82,136,148,153,
187,120,163,166],[113,156,173,177,114,185,141,160],[148,183,129,162,60,108,
163,200],[148,136,177,162,120,163,166,160],[148,113,128,166,168,136,114,225],
[57,170,88,136,141,160,187,113],[177,170,114,136,141,160,187,113],[143,205,
148,128,42,114,204,160],[185,108,148,153,144,162,94,46],[65,177,136,162,155,
92,40,46],[114,148,136,170,172,113,166,160],[185,108,148,153,144,162,113,166],
[170,114,148,129,168,180,113,200],[65,177,136,162,155,119,166,160],[194,114,
143,147,179,128,90,4],[128,113,178,146,144,194,108,4],[74,202,154,128,178,104,
33,4],[104,200,179,128,155,74,57,4],[185,57,50,4,46,239,92,187],[110,141,168,
136,170,115,200,187],[136,177,170,148,119,166,160,187],[84,148,166,128,213,
112,16,5],[115,173,205,128,155,110,160,144],[63,176,168,129,148,119,200,187],
[179,146,128,178,115,177,194,110],[115,136,177,154,163,110,160,187],[85,170,
177,148,143,116,160,187],[228,2,74,24,40,236,65,128],[204,28,43,23,5,237,112,
162],[205,50,34,24,40,236,58,155],[166,50,34,16,5,237,93,155],[176,34,4,3,67,
237,69,143],[144,46,5,4,3,222,81,189]],
duflo:=[217,2,57,28,65,240,94,160]),rec(character:=[102,64],
reps:=[[144,185,30,88,127,165,149,152],[91,150,185,148,111,165,149,152],[222,
34,110,226,29,97,159,206]],
duflo:=[207,30,106,215,50,70,152,227]),rec(character:=[77,29],
reps:=[[159,154,152,75,150,52,165,60],[189,20,159,46,11,67,180,175],[69,186,
183,76,178,104,180,175],[213,2,102,215,5,103,214,101]],
duflo:=[189,11,80,196,20,64,175,99]),rec(character:=[92,52],
reps:=[[131,128,125,134,189,118,140,129],[73,125,128,134,183,122,115,129],
[109,140,234,110,175,206,80,134],[213,122,118,140,129,176,125,134],[184,107,
128,134,172,131,122,112],[120,175,176,129,140,122,80,134]],
duflo:=[93,125,218,90,122,216,84,129]),rec(character:=[112,96],
reps:=[[93,122,123,124,125,134,74,188]],
duflo:=[93,122,123,124,125,134,7,68]),rec(character:=[55,36],
reps:=[[72,152,170,121,147,127,58,106],[152,80,44,217,82,147,127,210]],
duflo:=[121,82,37,209,80,171,127,210]),rec(character:=[104,99,83,59,56,53,50,
50,31,12],
reps:=[[66,142,77,144,130,147,127,58],[186,142,111,144,130,147,127,58],[130,
110,37,231,107,171,135,8],[77,89,144,130,147,127,193,107],[181,114,80,236,99,
179,142,73],[130,181,163,121,111,132,171,127],[144,186,142,152,116,143,147,
127],[197,130,110,147,127,172,142,107],[176,89,77,132,143,147,127,193],[130,
74,147,135,186,111,132,178],[144,79,126,135,209,116,143,155],[82,194,147,121,
152,77,26,58],[82,194,147,121,152,77,80,178],[82,163,181,121,152,116,171,127],
[132,116,191,130,163,121,79,127],[147,92,154,144,142,152,94,58],[147,92,154,
144,142,152,116,178],[143,114,181,144,142,152,99,127],[24,65,80,143,147,127,
193,152],[181,163,144,130,116,171,127,193],[92,147,194,121,152,89,65,178],[65,
144,163,130,191,93,79,127],[23,179,74,142,152,191,114,26],[91,121,142,175,171,
114,197,94],[132,116,204,130,147,121,66,8],[143,114,194,144,126,152,89,8],
[202,171,119,154,163,121,152,94],[135,114,91,239,106,188,157,32],[74,179,135,
147,130,116,178,193],[163,104,74,239,118,206,132,32],[187,118,104,239,74,163,
130,32],[91,179,135,126,164,114,155,214],[65,144,163,130,191,119,127,193],[92,
185,144,154,147,71,94,193],[185,130,132,191,119,127,188,121],[163,144,143,181,
119,127,193,152],[154,104,163,143,132,191,118,193],[119,185,200,132,94,162,
147,121],[202,113,87,240,105,126,164,9],[144,113,87,240,102,175,171,71],[51,
144,147,130,204,102,66,8],[97,61,179,147,130,204,120,193],[154,202,171,135,84,
94,188,121],[179,200,147,135,74,101,193,152],[206,43,127,147,187,106,9,32],
[132,109,37,233,112,218,127,15],[34,188,101,143,132,191,135,102],[143,112,44,
237,109,198,127,15]],
duflo:=[144,107,44,236,110,147,135,8]),rec(character:=[98,49],
reps:=[[125,101,126,157,123,156,122,112]],
duflo:=[101,126,185,125,124,122,112,213]),rec(character:=[108],
reps:=[[127,93,146,123,124,125,143,81],[115,173,171,125,176,110,155,146]],
duflo:=[63,179,124,123,146,80,143,81]),rec(character:=[109],
reps:=[[143,95,163,154,144,111,193,152],[106,150,154,203,116,152,159,170]],
duflo:=[164,2,98,210,5,107,204,209]),rec(character:=[106,63],
reps:=[[200,110,125,124,123,162,151,101],[200,150,116,124,123,162,151,175]],
duflo:=[105,124,163,122,151,175,117,164]),rec(character:=[103,65],
reps:=[[218,122,118,140,129,169,125,142],[134,149,172,131,122,115,129,175],
[186,129,119,169,125,142,183,122]],
duflo:=[109,140,234,110,182,200,69,22]),rec(character:=[67],
reps:=[[97,140,159,122,131,125,55,78]],
duflo:=[70,129,195,46,134,172,45,108]),rec(character:=[103,65],
reps:=[[69,170,96,140,129,154,131,125],[164,163,140,122,159,119,169,125],[87,
150,226,95,170,190,32,107]],
duflo:=[102,154,230,106,149,217,39,86]),rec(character:=[23],
reps:=[],
duflo:=[126,122,125,124,123,121,97,8]),rec(character:=[67],
reps:=[[163,94,122,124,125,126,164,93]],
duflo:=[87,158,125,124,123,162,112,181]),rec(character:=[66],
reps:=[[87,148,144,170,165,113,138,32]],
duflo:=[190,9,75,166,14,52,165,228]),rec(character:=[91,51],
reps:=[[164,166,162,113,172,169,167,92],[66,162,166,91,169,167,189,117],[66,
178,56,162,183,117,175,167],[186,178,103,162,183,117,175,167],[109,65,193,178,
182,110,183,69],[213,5,98,210,2,96,204,9]],
duflo:=[229,20,114,230,55,86,200,14]),rec(character:=[94,80,41],
reps:=[[81,125,122,124,123,121,188,118],[167,123,122,124,125,126,118,217],
[114,174,123,124,125,126,195,112],[107,187,186,123,124,122,75,68],[186,125,
123,124,122,167,120,188]],
duflo:=[126,122,125,124,123,121,101,128]),rec(character:=[101],
reps:=[[117,149,172,131,122,148,129,107],[134,120,125,176,129,140,122,190],
[140,154,150,131,149,62,39,86]],
duflo:=[99,122,224,46,134,172,45,29]),rec(character:=[98,28],
reps:=[[134,131,144,122,140,45,55,78],[1,125,157,18,122,148,7,118]],
duflo:=[32,122,164,30,125,173,7,118]),rec(character:=[109],
reps:=[[162,4,144,109,186,163,143,175],[197,198,161,115,150,196,162,106]],
duflo:=[182,2,5,4,3,73,238,61]),rec(character:=[78,30],
reps:=[[93,212,131,122,140,129,107,134],[131,135,122,140,129,175,119,134],
[134,116,187,131,122,140,129,175],[69,131,200,76,140,184,55,219]],
duflo:=[93,122,222,95,125,223,94,221]),rec(character:=[104,99,99,76,59,59,59,
56,56,56,53,34,34,34,31,31,7],
reps:=[[20,136,91,154,128,155,158,109],[140,136,103,154,128,155,158,109],[136,
103,170,140,127,158,71,67],[136,103,170,140,127,158,109,187],[2,165,88,127,
128,181,129,109],[103,170,154,136,133,109,187,155],[53,140,154,129,176,86,92,
187],[173,105,128,161,140,129,109,212],[53,140,154,129,176,120,187,155],[91,
163,127,146,136,111,187,191],[76,161,147,121,176,65,106,212],[105,162,181,136,
111,207,127,158],[154,140,136,170,120,187,155,158],[154,105,128,155,143,140,
111,229],[34,143,127,140,170,120,187,191],[16,192,106,140,127,158,176,105],
[136,192,111,140,127,158,176,105],[192,111,154,136,133,176,86,35],[192,111,
154,136,133,176,105,155],[5,170,103,140,127,158,197,114],[147,178,154,128,50,
111,212,158],[80,35,171,127,140,170,120,229],[87,136,140,170,179,99,71,155],
[173,187,119,161,140,129,176,86],[106,173,140,170,144,114,155,158],[111,154,
140,129,182,108,155,206],[87,136,140,170,179,119,155,158],[5,128,105,161,140,
129,219,113],[72,105,128,161,136,133,219,113],[215,111,147,121,169,128,65,26],
[101,146,143,163,179,95,76,191],[113,148,165,192,114,178,133,176],[140,77,129,
182,173,119,155,206],[108,196,161,128,179,113,146,129],[114,161,196,128,179,
113,143,133],[140,136,192,154,119,155,158,176],[140,113,127,158,182,136,114,
225],[105,202,178,128,154,95,45,158],[104,154,178,128,202,108,45,158],[192,
161,114,136,133,176,179,113],[207,16,72,26,35,191,176,179],[225,140,108,184,
128,154,99,38],[143,90,140,192,154,119,191,176],[114,140,136,161,187,113,158,
176],[20,158,81,182,136,154,119,225],[225,140,108,184,128,154,113,158],[207,
76,108,155,146,129,176,179],[225,64,50,20,23,158,197,154],[102,129,197,154,
147,76,90,206],[58,192,136,154,147,118,158,176],[225,143,114,202,128,127,95,
4],[211,171,113,179,128,181,108,4],[161,62,49,9,26,206,179,147],[110,133,182,
136,161,115,206,179],[108,140,210,127,171,80,77,176],[115,165,210,127,147,110,
176,144],[234,23,105,5,4,209,128,127],[115,136,192,146,155,110,176,179],[217,
86,58,5,4,197,154,147],[228,2,61,24,56,214,127,171],[191,20,35,23,5,144,154,
218]],
duflo:=[171,2,3,20,104,229,169,128]),rec(character:=[110],
reps:=[[122,134,131,125,165,118,188,129],[114,134,131,150,140,170,86,55]],
duflo:=[44,122,218,90,125,227,84,89]),rec(character:=[58],
reps:=[[127,162,102,123,124,125,143,181]],
duflo:=[97,211,171,125,124,94,146,61]),rec(character:=[90,55],
reps:=[[97,126,143,125,124,123,154,112]],
duflo:=[58,124,155,122,144,126,66,98]),rec(character:=[106,63],
reps:=[[134,131,144,122,140,45,108,198],[68,122,226,95,192,169,32,107]],
duflo:=[1,125,221,90,122,216,84,89]),rec(character:=[92,52],
reps:=[[163,118,122,140,129,152,134,125],[217,152,119,134,125,185,140,122],
[129,119,152,134,125,165,163,122],[74,140,163,122,159,152,117,125],[172,95,
163,122,148,129,152,116],[91,163,215,72,129,214,73,70]],
duflo:=[106,134,229,84,163,195,70,86]),rec(character:=[110],
reps:=[[172,149,123,124,122,112,175,126],[163,161,110,124,125,126,164,162]],
duflo:=[105,149,123,124,158,175,117,201]),rec(character:=[57],
reps:=[[185,150,154,113,165,149,152,159]],
duflo:=[217,20,114,216,14,90,206,175]),rec(character:=[94,87,41],
reps:=[[126,123,125,124,122,159,119,194],[102,125,123,124,122,159,188,118],
[199,122,123,124,125,126,118,217],[211,158,125,124,123,44,68,39],[69,123,122,
124,125,126,224,120]],
duflo:=[44,125,123,124,122,151,127,119]),rec(character:=[101],
reps:=[[118,167,140,122,131,125,134,74],[109,128,125,134,164,140,122,112],[64,
186,125,131,122,167,101,74]],
duflo:=[102,162,230,106,125,227,101,189]),rec(character:=[65,33],
reps:=[[110,85,169,125,126,157,123,162],[101,122,128,190,126,125,108,123],
[207,175,118,126,150,124,123,162]],
duflo:=[115,163,161,157,126,125,106,162]),rec(character:=[107],
reps:=[[106,150,154,163,165,116,152,159],[117,169,164,149,165,83,46,159]],
duflo:=[189,11,80,196,20,64,175,198]),rec(character:=[85,52],
reps:=[[169,118,125,126,157,123,156,122],[120,123,194,157,126,125,85,122],
[221,123,120,156,122,190,126,125]],
duflo:=[100,169,126,150,156,123,114,202]),rec(character:=[92,52],
reps:=[[144,120,146,135,147,143,141,152],[147,144,135,146,178,119,141,152],
[147,119,143,141,152,142,144,146],[59,135,144,146,155,143,116,152],[111,142,
151,152,141,143,80,146],[11,159,169,53,165,6,12,156]],
duflo:=[31,199,203,103,209,37,35,178]),rec(character:=[25],
reps:=[],
duflo:=[1,122,129,124,125,126,127,119]),rec(character:=[73,11],
reps:=[[96,211,126,125,124,123,121,101],[126,122,125,124,123,121,194,120]],
duflo:=[121,122,123,124,125,126,127,119]),rec(character:=[101],
reps:=[[118,81,188,143,125,124,123,154],[188,117,143,125,124,123,154,151],
[170,126,124,125,178,119,154,221]],
duflo:=[102,220,123,124,125,143,97,8]),rec(character:=[78,30],
reps:=[[118,143,126,125,124,123,154,128],[123,126,124,125,143,194,120,128],
[120,151,128,154,123,124,125,143],[70,187,124,123,154,151,107,143]],
duflo:=[102,220,123,124,125,143,101,128]),rec(character:=[46,44,38],
reps:=[[125,120,165,163,122,148,129,152],[53,144,148,122,131,193,94,84],[143,
120,140,170,144,134,138,131],[24,143,192,65,131,199,7,94],[77,129,201,30,125,
173,7,73]],
duflo:=[56,138,197,37,143,148,7,73]),rec(character:=[108],
reps:=[[143,119,147,154,144,142,152,94],[143,154,104,144,142,152,191,118]],
duflo:=[175,100,64,235,98,163,172,67]),rec(character:=[101],
reps:=[[119,144,127,146,131,149,143,81],[154,118,144,126,152,149,143,155],[78,
166,149,131,146,144,82,81]],
duflo:=[166,55,71,213,69,146,144,170]),rec(character:=[30,19],
reps:=[[117,123,125,124,122,151,127,188],[107,212,151,122,124,123,98,188]],
duflo:=[62,122,125,124,123,193,127,104]),rec(character:=[44,38,14],
reps:=[[120,125,128,169,129,140,122,69],[103,128,227,101,172,222,95,122],[97,
134,236,103,140,215,92,167],[119,125,186,131,122,156,129,101],[66,162,140,129,
169,125,92,69]],
duflo:=[81,131,211,88,156,217,89,175]),rec(character:=[82],
reps:=[[135,159,140,122,131,125,55,101]],
duflo:=[70,129,195,46,134,172,45,180]),rec(character:=[46,46,44,21],
reps:=[[116,155,124,122,144,126,182,106],[119,123,166,124,125,126,201,101],
[124,119,123,154,144,126,182,143],[119,193,154,123,124,125,143,81]],
duflo:=[24,166,125,124,123,193,96,81]),rec(character:=[82],
reps:=[[113,129,122,124,125,126,127,218]],
duflo:=[74,201,127,126,125,124,123,114]),rec(character:=[75,16],
reps:=[[120,127,182,126,144,122,124,123]],
duflo:=[31,143,126,125,124,123,199,120]),rec(character:=[94,87,87,71],
reps:=[[170,126,124,125,143,155,114,34],[170,126,124,125,143,155,119,154],
[123,126,124,125,143,194,119,8],[188,134,143,125,124,123,102,31]],
duflo:=[84,122,194,136,125,126,66,8]),rec(character:=[16,9],
reps:=[[134,131,144,122,140,135,60,55],[32,122,164,30,125,173,7,135]],
duflo:=[1,125,157,18,122,148,7,135]),rec(character:=[73,4],
reps:=[[127,143,126,125,124,123,162,120]],
duflo:=[65,124,163,122,144,126,127,79]),rec(character:=[6],
reps:=[],
duflo:=[167,123,122,124,125,126,127,74]),rec(character:=[69],
reps:=[],
duflo:=[121,122,123,124,125,126,135,8]),rec(character:=[2],
reps:=[],
duflo:=[121,122,123,124,125,126,127,128])]);
