#############################################################################
##
#A  tbl/coxh4.g               CHEVIE library                     Meinolf Geck
##
#Y  Copyright (C) 1992 - 2001  The CHEVIE Team
##
##  This file contains the character table of the Hecke algebras of type H4.
##
CHEVIE.Revision("tbl/coxh4.g",
   "$Id: coxh4.g,v 1.5 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("ReflectionDegrees","H4",[2,12,20,30]);

CHEVIE.AddData("Size", "H4", function(arg) return 14400; end);

# from Humphreys, "Reflection Groups and Coxeter Groups", 2.13
CHEVIE.AddData("GeneratingRoots", "H4", function(arg)
  local a, b;
  a:=(1+ER(5))/4; b:=(-1+ER(5))/4;
  return [[a,-1/2,b,0],[-a,1/2,b,0],[1/2,b,-a,0],[-1/2,-a,0,b]];
end);

CHEVIE.AddData("NrConjugacyClasses","H4", 34);

CHEVIE.AddData("CartanMat","H4",
[[2,-(1+ER(5))/2,0,0],[ -(1+ER(5))/2, 2, -1, 0 ],
[ 0, -1, 2, -1 ], [ 0, 0, -1, 2 ] ]);

CHEVIE.AddData("WordsClassRepresentatives","H4",
  [[],[1],[1,2],[1,3],[2,3],[1,2,3],[1,2,4],
  [1,3,4],[2,4,3],[1,2,1,2],[1,2,3,4],[1,2,1,2,3],[1,2,1,2,4],[1,2,1,2,3,4],
  [1,2,3,2,1,2,3,4],[1,2,1,2,3,2,1,2,3],[1,2,1,2,3,2,1,2,3,4],
  [1,3,2,1,2,1,3,2,1,2,3,4],[1,2,1,3,2,1,2,1,3,2,1,2,3,4],
  [1,2,1,2,1,3,2,1,2,1,3,2,1,2,3],[1,2,1,2,1,3,2,1,2,1,3,2,1,2,3,4],
  [1,2,1,2,3,2,1,2,3,4,3,2,1,2,3,4],[1,2,1,2,1,3,2,1,2,1,3,4,3,2,1,2,3,4],
  [1,2,1,2,1,3,2,1,2,1,3,2,1,4,3,2,1,2,3,4],
  [1,2,1,2,1,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,3,4],
  [1,2,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4],
  [2,1,2,1,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4],
  [1,2,1,2,3,2,1,2,1,3,2,1,4,3,2,1,2,1,3,2,1,4,3,2,1,2,3,4],
  [1,2,1,2,1,3,2,1,2,1,3,2,1,2,4,3,2,1,2,1,3,2,1,4,3,2,1,2,3,4],
  [1,2,1,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4],
  [1,2,1,2,1,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4],
  [1,2,1,2,1,3,2,1,2,1,3,2,1,2,4,3,2,1,2,1,3,2,1,2,4,3,2,1,2,1,3,2,1,4,3,2,1,
   2,3,4],
  [1,2,1,2,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4,3,
   2,1,2,1,3,2,1,2,3,4],
  [1,2,1,2,1,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4,
   3,2,1,2,1,3,2,1,2,3,4,3,2,1,2,1,3,2,1,2,3,4]]);

CHEVIE.AddData("ParabolicRepresentatives","H4",
[[],[1],[1,2],[1,2,3],[1,2,3,4],[1,2,4],[1,3],[1,3,4],[2,3],[2,3,4]]);

CHEVIE.AddData("ClassParameter","H4",CHEVIE.H4.WordsClassRepresentatives);

CHEVIE.AddData("PowerMaps","H4",
[,[1,1,10,1,5,3,10,5,4,3,15,5,3,18,22,10,24,26,27, 1, 3,
      15, 30, 32, 5, 33, 27, 22, 34, 33, 10, 32, 26, 1 ],
  [ 1, 2, 10, 4, 1, 16, 13, 2, 9, 3, 18, 20, 7, 23, 26, 6, 29, 30, 19, 20,
      31, 33, 14, 34, 34, 33, 27, 30, 29, 18, 21, 1, 26, 34 ],,
  [ 1, 2, 1, 4, 5, 20, 2, 8, 9, 1, 24, 12, 2, 29, 32, 20, 17, 34, 34, 20, 34,
      32, 29, 24, 25, 1, 1, 24, 29, 34, 34, 32, 1, 34 ],,
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20,
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],,,,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ],,
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20,
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],,,,
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20,
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ],,,,
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20,
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],,,,,,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ] ]);

CHEVIE.AddData("ClassInfo","H4",function()local res;
  res:=rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","H4"),
    orders:=[1,2,5,2,3,10,10,6,4,5,30,6,
 10,20,15,10,12,10,10,2,10,15,20,6,6,5,5,30,4,10,10,3,5,2],
    classes:=[1,60,144,450,400,720,720, 1200,1800,144, 480,
  1200, 720, 720, 480, 720, 1200, 24, 288, 60, 144, 480, 720, 40, 400, 24,
  288, 480, 60, 24, 144, 40, 24, 1 ]);
  res.classnames:=List(res.classtext,IntListToString);res.classnames[1]:=".";
  res.classparams:=res.classnames;
  return res;
end);

CHEVIE.AddData("CharInfo","H4",function()local res;
  res:=rec(charparams:=[[1,0],[1,60],[4,1],[4,31],[4,7],[4,37],[6,12],[6,20],
    [8,12],[8,13],[9,2],[9,22],[9,6],[9,26],[10,12],[16,11],[16,13],[16,3],
    [16,21],[16,6],[16,18],[18,10],[24,11],[24,7],[24,12],[24,6],[25,4],
    [25,16],[30,10,1],[30,10,2],[36,5],[36,15],[40,8],[48,9]],
  GeckPfeiffer:=["1_r", "1_r'", "4_t", "4_t'", "overline{4}_t", 
  "overline{4}_t'", "6_s", "overline{6}_s", "8_r", "8_{rr}", "9_s", "9_s'", 
  "overline{9}_s", "overline{9}_s'", "10_r", "16_t", "overline{16}_t", 
  "16_{rr}", "16_{rr}'", "16_r", "16_r'", "18_r", "24_t", "overline{24}_t", 
  "24_s", "overline{24}_s", "25_r", "25_r'", "30_s", "overline{30}_s", 
  "36_{rr}", "36_{rr}'", "40_r", "48_{rr}"],
  extRefl:=[1,3,7,4,2]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=
    [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1];
  return res;
end);

CHEVIE.AddData("vpolheckeirreducibles","H4",
[[[[1],0],[[1],2],[[1],4],[[1],4],[[1],4],[[1],6],[[1],6],[[1],6],[[1],
6],[[1],8],[[1],8],[[1],10],[[1],10],[[1],12],[[1],16],[[1],18],[[1],
20],[[1],24],[[1],28],[[1],30],[[1],32],[[1],32],[[1],36],[[1],40],[[1],
44],[[1],48],[[1],52],[[1],56],[[1],60],[[1],72],[[1],76],[[1],80],[[1],
96],[[1],120]],[[[1],0],[[-1],0],[[1],0],[[1],0],[[1],0],[[-1],0],[[-1],
0],[[-1],0],[[-1],0],[[1],0],[[1],0],[[-1],0],[[-1],0],[[1],0],[[1],0],
[[-1],0],[[1],0],[[1],0],[[1],0],[[-1],0],[[1],0],[[1],0],[[1],0],[[1],
0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],[[1],
0],[[1],0]],[[[4],0],[[-1,0,3],0],[[(-1+ER(5))/2,0,2],2],[[-2,0,2],2],
[[-1,0,2],2],[[(-1+ER(5))/2,0,1],4],[[(-3+ER(5))/2,0,1],4],[[-2,0,1],4],
[[-1,0,1],4],[[(-1-ER(5))/2,0,0,0,2],4],[[(-1+ER(5))/2],6],[[1],10],
[[(-1-ER(5))/2,0,-1,0,1],6],[[],0],[[(1+ER(5))/2],12],[[(-1-ER(5))/2,0,
0,0,0,0,1],12],[[],0],[[1+ER(5)],18],[[(1-ER(5))/2,0,(1+ER(5))/2],20],
[[-3,0,0,0,0,0,0,0,0,0,1],20],[[-2,0,0,0,(1+ER(5))/2],22],
[[(1-ER(5))/2],24],[[],0],[[2],30],[[-2,0,1],32],[[-1+ER(5)],36],
[[(-1-ER(5))/2,0,(-1+ER(5))/2],38],[[(-1-ER(5))/2],42],[[],0],
[[1-ER(5)],54],[[-2,0,(1-ER(5))/2],56],[[-2],60],[[-1-ER(5)],72],[[-4],
90]],[[[4],0],[[-3,0,1],0],[[2,0,(-1+ER(5))/2],0],[[2,0,-2],0],[[2,0,
-1],0],[[-1,0,(1-ER(5))/2],0],[[-1,0,(3-ER(5))/2],0],[[-1,0,2],0],[[-1,
0,1],0],[[2,0,0,0,(-1-ER(5))/2],0],[[(-1+ER(5))/2],2],[[-1],0],[[-1,0,1,
0,(1+ER(5))/2],0],[[],0],[[(1+ER(5))/2],4],[[-1,0,0,0,0,0,(1+ER(5))/2],
0],[[],0],[[1+ER(5)],6],[[(1+ER(5))/2,0,(1-ER(5))/2],6],[[-1,0,0,0,0,0,
0,0,0,0,3],0],[[(1+ER(5))/2,0,0,0,-2],6],[[(1-ER(5))/2],8],[[],0],[[2],
10],[[1,0,-2],10],[[-1+ER(5)],12],[[(-1+ER(5))/2,0,(-1-ER(5))/2],12],
[[(-1-ER(5))/2],14],[[],0],[[1-ER(5)],18],[[(1-ER(5))/2,0,-2],18],[[-2],
20],[[-1-ER(5)],24],[[-4],30]],[[[4],0],[[-1,0,3],0],[[(-1-ER(5))/2,0,
2],2],[[-2,0,2],2],[[-1,0,2],2],[[(-1-ER(5))/2,0,1],4],[[(-3-ER(5))/2,0,
1],4],[[-2,0,1],4],[[-1,0,1],4],[[(-1+ER(5))/2,0,0,0,2],4],
[[(-1-ER(5))/2],6],[[1],10],[[(-1+ER(5))/2,0,-1,0,1],6],[[],0],
[[(1-ER(5))/2],12],[[(-1+ER(5))/2,0,0,0,0,0,1],12],[[],0],[[1-ER(5)],
18],[[(1+ER(5))/2,0,(1-ER(5))/2],20],[[-3,0,0,0,0,0,0,0,0,0,1],20],[[-2,
0,0,0,(1-ER(5))/2],22],[[(1+ER(5))/2],24],[[],0],[[2],30],[[-2,0,1],32],
[[-1-ER(5)],36],[[(-1+ER(5))/2,0,(-1-ER(5))/2],38],[[(-1+ER(5))/2],42],
[[],0],[[1+ER(5)],54],[[-2,0,(1+ER(5))/2],56],[[-2],60],[[-1+ER(5)],72],
[[-4],90]],[[[4],0],[[-3,0,1],0],[[2,0,(-1-ER(5))/2],0],[[2,0,-2],0],
[[2,0,-1],0],[[-1,0,(1+ER(5))/2],0],[[-1,0,(3+ER(5))/2],0],[[-1,0,2],0],
[[-1,0,1],0],[[2,0,0,0,(-1+ER(5))/2],0],[[(-1-ER(5))/2],2],[[-1],0],
[[-1,0,1,0,(1-ER(5))/2],0],[[],0],[[(1-ER(5))/2],4],[[-1,0,0,0,0,0,
(1-ER(5))/2],0],[[],0],[[1-ER(5)],6],[[(1-ER(5))/2,0,(1+ER(5))/2],6],
[[-1,0,0,0,0,0,0,0,0,0,3],0],[[(1-ER(5))/2,0,0,0,-2],6],[[(1+ER(5))/2],
8],[[],0],[[2],10],[[1,0,-2],10],[[-1-ER(5)],12],[[(-1-ER(5))/2,0,
(-1+ER(5))/2],12],[[(-1+ER(5))/2],14],[[],0],[[1+ER(5)],18],
[[(1+ER(5))/2,0,-2],18],[[-2],20],[[-1+ER(5)],24],[[-4],30]],[[[6],0],
[[-3,0,3],0],[[1,0,-1+ER(5),0,1],0],[[1,0,-4,0,1],0],[[1,0,-2,0,1],0],
[[(1-ER(5))/2,0,(-1+ER(5))/2],2],[[(3-ER(5))/2,0,(-3+ER(5))/2],2],[[2,0,
-2],2],[[1,0,-1],2],[[1,0,0,0,-1-ER(5),0,0,0,1],0],[[(1-ER(5))/2],4],
[[],0],[[1,0,(1+ER(5))/2,0,(-1-ER(5))/2,0,-1],2],[[(-1-ER(5))/2],6],
[[(1+ER(5))/2],8],[[(1+ER(5))/2,0,0,0,0,0,(-1-ER(5))/2],6],[[-1],10],
[[(7+ER(5))/2],12],[[1,0,-1,0,1],12],[[3,0,0,0,0,0,0,0,0,0,-3],10],[[1,
0,0,0,-1-ER(5),0,0,0,1],12],[[(1-ER(5))/2],16],[[(-1+ER(5))/2],18],[[3],
20],[[1,0,-2,0,1],20],[[(7-ER(5))/2],24],[[1,0,-1,0,1],24],
[[(1+ER(5))/2],28],[[2],30],[[(7-ER(5))/2],36],[[1,0,-1+ER(5),0,1],36],
[[3],40],[[(7+ER(5))/2],48],[[6],60]],[[[6],0],[[-3,0,3],0],[[1,0,
-1-ER(5),0,1],0],[[1,0,-4,0,1],0],[[1,0,-2,0,1],0],[[(1+ER(5))/2,0,
(-1-ER(5))/2],2],[[(3+ER(5))/2,0,(-3-ER(5))/2],2],[[2,0,-2],2],[[1,0,
-1],2],[[1,0,0,0,-1+ER(5),0,0,0,1],0],[[(1+ER(5))/2],4],[[],0],[[1,0,
(1-ER(5))/2,0,(-1+ER(5))/2,0,-1],2],[[(-1+ER(5))/2],6],[[(1-ER(5))/2],
8],[[(1-ER(5))/2,0,0,0,0,0,(-1+ER(5))/2],6],[[-1],10],[[(7-ER(5))/2],
12],[[1,0,-1,0,1],12],[[3,0,0,0,0,0,0,0,0,0,-3],10],[[1,0,0,0,-1+ER(5),
0,0,0,1],12],[[(1+ER(5))/2],16],[[(-1-ER(5))/2],18],[[3],20],[[1,0,-2,0,
1],20],[[(7+ER(5))/2],24],[[1,0,-1,0,1],24],[[(1-ER(5))/2],28],[[2],30],
[[(7+ER(5))/2],36],[[1,0,-1-ER(5),0,1],36],[[3],40],[[(7-ER(5))/2],48],
[[6],60]],[[[8],0],[[-4,0,4],0],[[-2],2],[[2,0,-4,0,2],0],[[2,0,-2,0,2],
0],[[],0],[[1,0,-1],2],[[-1,0,2,0,-2,0,1],0],[[-1,0,1,0,-1,0,1],0],
[[-2],4],[[],0],[[],0],[[1,0,-1],4],[[-1],6],[[],0],[[],0],[[1],10],
[[3],12],[[-2],14],[[],0],[[-2],16],[[],0],[[-1],18],[[5],20],[[2,0,-2,
0,2],20],[[3],24],[[-2],26],[[],0],[[4],30],[[3],36],[[-2],38],[[5],40],
[[3],48],[[8],60]],[[[8],0],[[-4,0,4],0],[[-2],2],[[2,0,-4,0,2],0],[[2,
0,-2,0,2],0],[[],0],[[1,0,-1],2],[[-1,0,2,0,-2,0,1],0],[[-1,0,1,0,-1,0,
1],0],[[-2],4],[[-1],4],[[],0],[[1,0,-1],4],[[],0],[[1],8],[[],0],[[],
0],[[2],12],[[-3],14],[[],0],[[2],16],[[1],16],[[],0],[[4],20],[[1,0,-4,
0,1],20],[[-2],24],[[3],26],[[-1],28],[[],0],[[2],36],[[2],38],[[-4],
40],[[-2],48],[[-8],60]],[[[9],0],[[-3,0,6],0],[[(-3+ER(5))/2,0,3],2],
[[1,0,-4,0,4],0],[[-3,0,3],2],[[(-1+ER(5))/2,0,1],4],[[(1-ER(5))/2,0,-2,
0,2],2],[[1,0,-3,0,2],2],[[-2,0,1],4],[[(-3-ER(5))/2,0,0,0,3],4],[[],0],
[[-1,0,0,0,1],6],[[(1+ER(5))/2,0,-1,0,-1,0,2],4],[[(-1+ER(5))/2],8],[[],
0],[[(-1-ER(5))/2,0,0,0,0,0,1],12],[[],0],[[(3+3*ER(5))/2],16],
[[(-3-ER(5))/2,0,(1+ER(5))/2],18],[[5,0,-3,0,0,0,0,0,0,0,0,0,1],18],
[[1-ER(5),0,0,0,(1+ER(5))/2],20],[[],0],[[(-1-ER(5))/2],24],[[],0],[[],
0],[[(3-3*ER(5))/2],32],[[(-3+ER(5))/2,0,(1-ER(5))/2],34],[[],0],[[-3],
40],[[(3-3*ER(5))/2],48],[[1+ER(5),0,(1-ER(5))/2],50],[[],0],
[[(3+3*ER(5))/2],64],[[9],80]],[[[9],0],[[-6,0,3],0],[[3,0,
(-3+ER(5))/2],0],[[4,0,-4,0,1],0],[[3,0,-3],0],[[-1,0,(1-ER(5))/2],0],
[[-2,0,2,0,(-1+ER(5))/2],0],[[-2,0,3,0,-1],0],[[-1,0,2],0],[[3,0,0,0,
(-3-ER(5))/2],0],[[],0],[[-1,0,0,0,1],0],[[-2,0,1,0,1,0,(-1-ER(5))/2],
0],[[(-1+ER(5))/2],4],[[],0],[[-1,0,0,0,0,0,(1+ER(5))/2],0],[[],0],
[[(3+3*ER(5))/2],8],[[(1+ER(5))/2,0,(-3-ER(5))/2],8],[[-1,0,0,0,0,0,0,0,
0,0,3,0,-5],0],[[(1+ER(5))/2,0,0,0,1-ER(5)],8],[[],0],[[(-1-ER(5))/2],
12],[[],0],[[],0],[[(3-3*ER(5))/2],16],[[(1-ER(5))/2,0,(-3+ER(5))/2],
16],[[],0],[[-3],20],[[(3-3*ER(5))/2],24],[[(1-ER(5))/2,0,1+ER(5)],24],
[[],0],[[(3+3*ER(5))/2],32],[[9],40]],[[[9],0],[[-3,0,6],0],
[[(-3-ER(5))/2,0,3],2],[[1,0,-4,0,4],0],[[-3,0,3],2],[[(-1-ER(5))/2,0,
1],4],[[(1+ER(5))/2,0,-2,0,2],2],[[1,0,-3,0,2],2],[[-2,0,1],4],
[[(-3+ER(5))/2,0,0,0,3],4],[[],0],[[-1,0,0,0,1],6],[[(1-ER(5))/2,0,-1,0,
-1,0,2],4],[[(-1-ER(5))/2],8],[[],0],[[(-1+ER(5))/2,0,0,0,0,0,1],12],
[[],0],[[(3-3*ER(5))/2],16],[[(-3+ER(5))/2,0,(1-ER(5))/2],18],[[5,0,-3,
0,0,0,0,0,0,0,0,0,1],18],[[1+ER(5),0,0,0,(1-ER(5))/2],20],[[],0],
[[(-1+ER(5))/2],24],[[],0],[[],0],[[(3+3*ER(5))/2],32],[[(-3-ER(5))/2,0,
(1+ER(5))/2],34],[[],0],[[-3],40],[[(3+3*ER(5))/2],48],[[1-ER(5),0,
(1+ER(5))/2],50],[[],0],[[(3-3*ER(5))/2],64],[[9],80]],[[[9],0],[[-6,0,
3],0],[[3,0,(-3-ER(5))/2],0],[[4,0,-4,0,1],0],[[3,0,-3],0],[[-1,0,
(1+ER(5))/2],0],[[-2,0,2,0,(-1-ER(5))/2],0],[[-2,0,3,0,-1],0],[[-1,0,2],
0],[[3,0,0,0,(-3+ER(5))/2],0],[[],0],[[-1,0,0,0,1],0],[[-2,0,1,0,1,0,
(-1+ER(5))/2],0],[[(-1-ER(5))/2],4],[[],0],[[-1,0,0,0,0,0,(1-ER(5))/2],
0],[[],0],[[(3-3*ER(5))/2],8],[[(1-ER(5))/2,0,(-3+ER(5))/2],8],[[-1,0,0,
0,0,0,0,0,0,0,3,0,-5],0],[[(1-ER(5))/2,0,0,0,1+ER(5)],8],[[],0],
[[(-1+ER(5))/2],12],[[],0],[[],0],[[(3+3*ER(5))/2],16],[[(1+ER(5))/2,0,
(-3-ER(5))/2],16],[[],0],[[-3],20],[[(3+3*ER(5))/2],24],[[(1+ER(5))/2,0,
1-ER(5)],24],[[],0],[[(3-3*ER(5))/2],32],[[9],40]],[[[10],0],[[-5,0,5],
0],[[1,0,-2,0,1],0],[[3,0,-4,0,3],0],[[1,0,-4,0,1],0],[[],0],[[-1,0,1,0,
-1,0,1],0],[[-1,0,2,0,-2,0,1],0],[[1,0,-1],2],[[1,0,0,0,-2,0,0,0,1],0],
[[-1],4],[[1,0,-1],4],[[-1,0,0,0,1,0,-1,0,0,0,1],0],[[1],6],[[-1],8],
[[],0],[[],0],[[5],12],[[1,0,-2,0,1],12],[[-5,0,0,0,0,0,5],12],[[1,0,0,
0,-2,0,0,0,1],12],[[-1],16],[[1],18],[[4],20],[[1,0,-4,0,1],20],[[5],
24],[[1,0,-2,0,1],24],[[-1],28],[[6],30],[[5],36],[[1,0,-2,0,1],36],
[[4],40],[[5],48],[[10],60]],[[[16],0],[[-8,0,8],0],[[2,0,-3+ER(5),0,2],
0],[[4,0,-8,0,4],0],[[2,0,-6,0,2],0],[[(1-ER(5))/2,0,(-1+ER(5))/2],2],
[[-1,0,(5-ER(5))/2,0,(-5+ER(5))/2,0,1],0],[[-1,0,4,0,-4,0,1],0],[[2,0,
-2],2],[[2,0,0,0,-3-ER(5),0,0,0,2],0],[[(-1-ER(5))/2],4],[[1,0,-1],4],
[[-1,0,1,0,(3+ER(5))/2,0,(-3-ER(5))/2,0,-1,0,1],0],[[],0],
[[(1-ER(5))/2],8],[[(1+ER(5))/2,0,0,0,0,0,(-1-ER(5))/2],6],[[],0],
[[4+2*ER(5)],12],[[(1+ER(5))/2,0,-2-ER(5),0,(1+ER(5))/2],12],[[3,0,-5,0,
0,0,0,0,5,0,-3],10],[[(1+ER(5))/2,0,0,0,-2,0,0,0,(1+ER(5))/2],12],
[[(1+ER(5))/2],16],[[],0],[[2],20],[[1,0,0,0,1],20],[[-4+2*ER(5)],24],
[[(-1+ER(5))/2,0,2-ER(5),0,(-1+ER(5))/2],24],[[(-1+ER(5))/2],28],[[],0],
[[4-2*ER(5)],36],[[(1-ER(5))/2,0,-2,0,(1-ER(5))/2],36],[[-2],40],
[[-4-2*ER(5)],48],[[-16],60]],[[[16],0],[[-8,0,8],0],[[2,0,-3-ER(5),0,
2],0],[[4,0,-8,0,4],0],[[2,0,-6,0,2],0],[[(1+ER(5))/2,0,(-1-ER(5))/2],
2],[[-1,0,(5+ER(5))/2,0,(-5-ER(5))/2,0,1],0],[[-1,0,4,0,-4,0,1],0],[[2,
0,-2],2],[[2,0,0,0,-3+ER(5),0,0,0,2],0],[[(-1+ER(5))/2],4],[[1,0,-1],4],
[[-1,0,1,0,(3-ER(5))/2,0,(-3+ER(5))/2,0,-1,0,1],0],[[],0],
[[(1+ER(5))/2],8],[[(1-ER(5))/2,0,0,0,0,0,(-1+ER(5))/2],6],[[],0],
[[4-2*ER(5)],12],[[(1-ER(5))/2,0,-2+ER(5),0,(1-ER(5))/2],12],[[3,0,-5,0,
0,0,0,0,5,0,-3],10],[[(1-ER(5))/2,0,0,0,-2,0,0,0,(1-ER(5))/2],12],
[[(1-ER(5))/2],16],[[],0],[[2],20],[[1,0,0,0,1],20],[[-4-2*ER(5)],24],
[[(-1-ER(5))/2,0,2+ER(5),0,(-1-ER(5))/2],24],[[(-1-ER(5))/2],28],[[],0],
[[4+2*ER(5)],36],[[(1+ER(5))/2,0,-2,0,(1+ER(5))/2],36],[[-2],40],
[[-4+2*ER(5)],48],[[-16],60]],[[[16],0],[[-6,0,10],0],[[-3,0,4],2],[[2,
0,-8,0,6],0],[[1,0,-5,0,5],0],[[1,-1,0,1],3],[[1,0,-4,0,2],2],[[3,0,-5,
0,3],2],[[1,0,-3,0,2],2],[[-3,0,0,0,4],4],[[1],5],[[-1,-1,0,0,0,1],5],
[[1,0,-2,0,-2,0,2],4],[[],0],[[-1],10],[[1,0,0,-1,0,0,0,0,0,1],9],[[],
0],[[4],15],[[-2,0,1],17],[[-4,0,0,5,0,-6,0,0,0,0,0,0,0,0,0,1],15],[[-2,
0,0,0,1],19],[[-1],20],[[],0],[[-4],25],[[-1,0,2,0,-2],25],[[-4],30],
[[2,0,-1],32],[[1],35],[[],0],[[4],45],[[-2,0,1],47],[[4],50],[[-4],60],
[[-16],75]],[[[16],0],[[-10,0,6],0],[[4,0,-3],0],[[6,0,-8,0,2],0],[[5,0,
-5,0,1],0],[[-1,0,1,-1],0],[[-2,0,4,0,-1],0],[[-3,0,5,0,-3],0],[[-2,0,3,
0,-1],0],[[4,0,0,0,-3],0],[[1],3],[[-1,0,0,0,1,1],0],[[-2,0,2,0,2,0,-1],
0],[[],0],[[-1],6],[[-1,0,0,0,0,0,1,0,0,-1],0],[[],0],[[4],9],[[1,0,-2],
9],[[-1,0,0,0,0,0,0,0,0,0,6,0,-5,0,0,4],0],[[1,0,0,0,-2],9],[[-1],12],
[[],0],[[-4],15],[[-2,0,2,0,-1],15],[[-4],18],[[-1,0,2],18],[[1],21],
[[],0],[[4],27],[[1,0,-2],27],[[4],30],[[-4],36],[[-16],45]],[[[16],0],
[[-6,0,10],0],[[-3,0,4],2],[[2,0,-8,0,6],0],[[1,0,-5,0,5],0],[[-1,-1,0,
1],3],[[1,0,-4,0,2],2],[[3,0,-5,0,3],2],[[1,0,-3,0,2],2],[[-3,0,0,0,4],
4],[[-1],5],[[1,-1,0,0,0,1],5],[[1,0,-2,0,-2,0,2],4],[[],0],[[-1],10],
[[-1,0,0,-1,0,0,0,0,0,1],9],[[],0],[[-4],15],[[2,0,-1],17],[[4,0,0,5,0,
-6,0,0,0,0,0,0,0,0,0,1],15],[[2,0,0,0,-1],19],[[-1],20],[[],0],[[4],25],
[[1,0,-2,0,2],25],[[-4],30],[[2,0,-1],32],[[-1],35],[[],0],[[-4],45],
[[2,0,-1],47],[[4],50],[[-4],60],[[16],75]],[[[16],0],[[-10,0,6],0],[[4,
0,-3],0],[[6,0,-8,0,2],0],[[5,0,-5,0,1],0],[[-1,0,1,1],0],[[-2,0,4,0,
-1],0],[[-3,0,5,0,-3],0],[[-2,0,3,0,-1],0],[[4,0,0,0,-3],0],[[-1],3],
[[-1,0,0,0,1,-1],0],[[-2,0,2,0,2,0,-1],0],[[],0],[[-1],6],[[-1,0,0,0,0,
0,1,0,0,1],0],[[],0],[[-4],9],[[-1,0,2],9],[[-1,0,0,0,0,0,0,0,0,0,6,0,
-5,0,0,-4],0],[[-1,0,0,0,2],9],[[-1],12],[[],0],[[4],15],[[2,0,-2,0,1],
15],[[-4],18],[[-1,0,2],18],[[-1],21],[[],0],[[-4],27],[[-1,0,2],27],
[[4],30],[[-4],36],[[16],45]],[[[18],0],[[-9,0,9],0],[[1,0,-4,0,1],0],
[[5,0,-8,0,5],0],[[3,0,-6,0,3],0],[[],0],[[-1,0,2,0,-2,0,1],0],[[-2,0,4,
0,-4,0,2],0],[[-1,0,2,0,-2,0,1],0],[[1,0,0,0,-4,0,0,0,1],0],[[],0],[[1,
0,-1],4],[[-1,0,0,0,2,0,-2,0,0,0,1],0],[[-1],6],[[],0],[[],0],[[],0],
[[3],12],[[1,0,1,0,1],12],[[-5,0,0,0,0,0,5],12],[[1,0,0,0,-4,0,0,0,1],
12],[[],0],[[-1],18],[[],0],[[],0],[[3],24],[[1,0,1,0,1],24],[[],0],
[[-6],30],[[3],36],[[1,0,-4,0,1],36],[[],0],[[3],48],[[18],60]],[[[24],
0],[[-12,0,12],0],[[2,0,-5-ER(5),0,2],0],[[6,0,-12,0,6],0],[[4,0,-8,0,
4],0],[[(1+ER(5))/2,0,(-1-ER(5))/2],2],[[-1,0,(7+ER(5))/2,0,
(-7-ER(5))/2,0,1],0],[[-2,0,6,0,-6,0,2],0],[[-1,0,3,0,-3,0,1],0],[[2,0,
0,0,-5+ER(5),0,0,0,2],0],[[1],4],[[1,0,-1],4],[[-1,0,1,0,(5-ER(5))/2,0,
(-5+ER(5))/2,0,-1,0,1],0],[[],0],[[-1],8],[[(1-ER(5))/2,0,0,0,0,0,
(-1+ER(5))/2],6],[[],0],[[1+3*ER(5)],12],[[(1+ER(5))/2,0,-ER(5),0,
(1+ER(5))/2],12],[[3,0,-5,0,0,0,0,0,5,0,-3],10],[[(1+ER(5))/2,0,0,0,
-2*ER(5),0,0,0,(1+ER(5))/2],12],[[-1],16],[[],0],[[6],20],[[2,0,-4,0,2],
20],[[-1+3*ER(5)],24],[[(-1+ER(5))/2,0,-ER(5),0,(-1+ER(5))/2],24],[[1],
28],[[],0],[[1-3*ER(5)],36],[[(1-ER(5))/2,0,2*ER(5),0,(1-ER(5))/2],36],
[[-6],40],[[-1-3*ER(5)],48],[[-24],60]],[[[24],0],[[-12,0,12],0],[[2,0,
-5+ER(5),0,2],0],[[6,0,-12,0,6],0],[[4,0,-8,0,4],0],[[(1-ER(5))/2,0,
(-1+ER(5))/2],2],[[-1,0,(7-ER(5))/2,0,(-7+ER(5))/2,0,1],0],[[-2,0,6,0,
-6,0,2],0],[[-1,0,3,0,-3,0,1],0],[[2,0,0,0,-5-ER(5),0,0,0,2],0],[[1],4],
[[1,0,-1],4],[[-1,0,1,0,(5+ER(5))/2,0,(-5-ER(5))/2,0,-1,0,1],0],[[],0],
[[-1],8],[[(1+ER(5))/2,0,0,0,0,0,(-1-ER(5))/2],6],[[],0],[[1-3*ER(5)],
12],[[(1-ER(5))/2,0,ER(5),0,(1-ER(5))/2],12],[[3,0,-5,0,0,0,0,0,5,0,-3],
10],[[(1-ER(5))/2,0,0,0,2*ER(5),0,0,0,(1-ER(5))/2],12],[[-1],16],[[],0],
[[6],20],[[2,0,-4,0,2],20],[[-1-3*ER(5)],24],[[(-1-ER(5))/2,0,ER(5),0,
(-1-ER(5))/2],24],[[1],28],[[],0],[[1+3*ER(5)],36],[[(1+ER(5))/2,0,
-2*ER(5),0,(1+ER(5))/2],36],[[-6],40],[[-1+3*ER(5)],48],[[-24],60]],
[[[24],0],[[-12,0,12],0],[[2,0,-5-ER(5),0,2],0],[[6,0,-12,0,6],0],[[4,0,
-8,0,4],0],[[(1+ER(5))/2,0,(-1-ER(5))/2],2],[[-1,0,(7+ER(5))/2,0,
(-7-ER(5))/2,0,1],0],[[-2,0,6,0,-6,0,2],0],[[-1,0,3,0,-3,0,1],0],[[2,0,
0,0,-5+ER(5),0,0,0,2],0],[[(1-ER(5))/2],4],[[1,0,-1],4],[[-1,0,1,0,
(5-ER(5))/2,0,(-5+ER(5))/2,0,-1,0,1],0],[[1],6],[[(1+ER(5))/2],8],
[[(1-ER(5))/2,0,0,0,0,0,(-1+ER(5))/2],6],[[-1],10],[[-1+2*ER(5)],12],
[[(-1+ER(5))/2,0,-ER(5),0,(-1+ER(5))/2],12],[[3,0,-5,0,0,0,0,0,5,0,-3],
10],[[(-1+ER(5))/2,0,0,0,0,0,0,0,(-1+ER(5))/2],12],[[(1-ER(5))/2],16],
[[1],18],[[3],20],[[1,0,-2,0,1],20],[[-1-2*ER(5)],24],[[(-1-ER(5))/2,0,
ER(5),0,(-1-ER(5))/2],24],[[(1+ER(5))/2],28],[[-4],30],[[-1-2*ER(5)],
36],[[(-1-ER(5))/2,0,0,0,(-1-ER(5))/2],36],[[3],40],[[-1+2*ER(5)],48],
[[24],60]],[[[24],0],[[-12,0,12],0],[[2,0,-5+ER(5),0,2],0],[[6,0,-12,0,
6],0],[[4,0,-8,0,4],0],[[(1-ER(5))/2,0,(-1+ER(5))/2],2],[[-1,0,
(7-ER(5))/2,0,(-7+ER(5))/2,0,1],0],[[-2,0,6,0,-6,0,2],0],[[-1,0,3,0,-3,
0,1],0],[[2,0,0,0,-5-ER(5),0,0,0,2],0],[[(1+ER(5))/2],4],[[1,0,-1],4],
[[-1,0,1,0,(5+ER(5))/2,0,(-5-ER(5))/2,0,-1,0,1],0],[[1],6],
[[(1-ER(5))/2],8],[[(1+ER(5))/2,0,0,0,0,0,(-1-ER(5))/2],6],[[-1],10],
[[-1-2*ER(5)],12],[[(-1-ER(5))/2,0,ER(5),0,(-1-ER(5))/2],12],[[3,0,-5,0,
0,0,0,0,5,0,-3],10],[[(-1-ER(5))/2,0,0,0,0,0,0,0,(-1-ER(5))/2],12],
[[(1+ER(5))/2],16],[[1],18],[[3],20],[[1,0,-2,0,1],20],[[-1+2*ER(5)],
24],[[(-1+ER(5))/2,0,-ER(5),0,(-1+ER(5))/2],24],[[(1-ER(5))/2],28],
[[-4],30],[[-1+2*ER(5)],36],[[(-1+ER(5))/2,0,0,0,(-1+ER(5))/2],36],[[3],
40],[[-1-2*ER(5)],48],[[24],60]],[[[25],0],[[-10,0,15],0],[[-5,0,5],2],
[[4,0,-12,0,9],0],[[2,0,-8,0,7],0],[[-1,0,1],4],[[2,0,-5,0,3],2],[[-1,0,
4,0,-8,0,4],0],[[2,0,-4,0,3],2],[[-5,0,0,0,5],4],[[],0],[[-2,0,0,0,1],
6],[[2,0,-3,0,-2,0,3],4],[[],0],[[],0],[[-1,0,0,0,0,0,1],12],[[-1],12],
[[],0],[[],0],[[10,0,-6,0,0,0,0,0,0,0,0,0,1],18],[[],0],[[],0],[[],0],
[[-5],24],[[-1,0,4,0,-2],24],[[],0],[[],0],[[],0],[[5],36],[[],0],[[],
0],[[-5],48],[[],0],[[25],72]],[[[25],0],[[-15,0,10],0],[[5,0,-5],0],
[[9,0,-12,0,4],0],[[7,0,-8,0,2],0],[[-1,0,1],0],[[-3,0,5,0,-2],0],[[-4,
0,8,0,-4,0,1],0],[[-3,0,4,0,-2],0],[[5,0,0,0,-5],0],[[],0],[[-1,0,0,0,
2],0],[[-3,0,2,0,3,0,-2],0],[[],0],[[],0],[[-1,0,0,0,0,0,1],0],[[-1],8],
[[],0],[[],0],[[-1,0,0,0,0,0,0,0,0,0,6,0,-10],0],[[],0],[[],0],[[],0],
[[-5],16],[[-2,0,4,0,-1],16],[[],0],[[],0],[[],0],[[5],24],[[],0],[[],
0],[[-5],32],[[],0],[[25],48]],[[[30],0],[[-15,0,15],0],[[3,0,-6,0,3],
0],[[7,0,-16,0,7],0],[[5,0,-10,0,5],0],[[1,0,-1],2],[[-1,0,5,0,-5,0,1],
0],[[-2,0,8,0,-8,0,2],0],[[-1,0,4,0,-4,0,1],0],[[3,0,0,0,-6,0,0,0,3],0],
[[(-1+ER(5))/2],4],[[1,0,-1],4],[[-1,0,2,0,3,0,-3,0,-2,0,1],0],
[[(1-ER(5))/2],6],[[(-1-ER(5))/2],8],[[1,0,0,0,0,0,-1],6],[[1],10],
[[(5+5*ER(5))/2],12],[[(1+ER(5))/2,0,-1-ER(5),0,(1+ER(5))/2],12],[[6,0,
-5,0,0,0,0,0,5,0,-6],10],[[(1+ER(5))/2,0,0,0,-1-ER(5),0,0,0,
(1+ER(5))/2],12],[[(-1+ER(5))/2],16],[[(1+ER(5))/2],18],[[-3],20],[[-1,
0,2,0,-1],20],[[(5-5*ER(5))/2],24],[[(1-ER(5))/2,0,-1+ER(5),0,
(1-ER(5))/2],24],[[(-1-ER(5))/2],28],[[-2],30],[[(5-5*ER(5))/2],36],
[[(1-ER(5))/2,0,-1+ER(5),0,(1-ER(5))/2],36],[[-3],40],[[(5+5*ER(5))/2],
48],[[30],60]],[[[30],0],[[-15,0,15],0],[[3,0,-6,0,3],0],[[7,0,-16,0,7],
0],[[5,0,-10,0,5],0],[[1,0,-1],2],[[-1,0,5,0,-5,0,1],0],[[-2,0,8,0,-8,0,
2],0],[[-1,0,4,0,-4,0,1],0],[[3,0,0,0,-6,0,0,0,3],0],[[(-1-ER(5))/2],4],
[[1,0,-1],4],[[-1,0,2,0,3,0,-3,0,-2,0,1],0],[[(1+ER(5))/2],6],
[[(-1+ER(5))/2],8],[[1,0,0,0,0,0,-1],6],[[1],10],[[(5-5*ER(5))/2],12],
[[(1-ER(5))/2,0,-1+ER(5),0,(1-ER(5))/2],12],[[6,0,-5,0,0,0,0,0,5,0,-6],
10],[[(1-ER(5))/2,0,0,0,-1+ER(5),0,0,0,(1-ER(5))/2],12],[[(-1-ER(5))/2],
16],[[(1-ER(5))/2],18],[[-3],20],[[-1,0,2,0,-1],20],[[(5+5*ER(5))/2],
24],[[(1+ER(5))/2,0,-1-ER(5),0,(1+ER(5))/2],24],[[(-1+ER(5))/2],28],
[[-2],30],[[(5+5*ER(5))/2],36],[[(1+ER(5))/2,0,-1-ER(5),0,(1+ER(5))/2],
36],[[-3],40],[[(5-5*ER(5))/2],48],[[30],60]],[[[36],0],[[-15,0,21],0],
[[1,0,-7,0,7],0],[[6,0,-18,0,12],0],[[3,0,-12,0,9],0],[[-2,0,1],4],[[4,
0,-7,0,4],2],[[-1,0,7,0,-11,0,5],0],[[3,0,-6,0,3],2],[[1,0,0,0,-7,0,0,0,
7],0],[[],0],[[1,0,-2,0,0,0,1],4],[[1,0,3,0,-4,0,-3,0,4],2],[[],0],[[],
0],[[-2,0,0,0,0,0,1],12],[[],0],[[-6],14],[[-1,0,2,0,-2],14],[[-5,0,0,0,
0,0,10,0,-12,0,0,0,0,0,0,0,0,0,1],12],[[-1,0,0,0,2,0,0,0,-2],14],[[],0],
[[],0],[[],0],[[],0],[[6],28],[[1,0,-2,0,2],28],[[],0],[[],0],[[-6],42],
[[-1,0,2,0,-2],42],[[],0],[[6],56],[[-36],70]],[[[36],0],[[-21,0,15],0],
[[7,0,-7,0,1],0],[[12,0,-18,0,6],0],[[9,0,-12,0,3],0],[[-1,0,2],0],[[-4,
0,7,0,-4],0],[[-5,0,11,0,-7,0,1],0],[[-3,0,6,0,-3],0],[[7,0,0,0,-7,0,0,
0,1],0],[[],0],[[-1,0,0,0,2,0,-1],0],[[-4,0,3,0,4,0,-3,0,-1],0],[[],0],
[[],0],[[-1,0,0,0,0,0,2],0],[[],0],[[-6],10],[[-2,0,2,0,-1],10],[[-1,0,
0,0,0,0,0,0,0,0,12,0,-10,0,0,0,0,0,5],0],[[-2,0,0,0,2,0,0,0,-1],10],[[],
0],[[],0],[[],0],[[],0],[[6],20],[[2,0,-2,0,1],20],[[],0],[[],0],[[-6],
30],[[-2,0,2,0,-1],30],[[],0],[[6],40],[[-36],50]],[[[40],0],[[-20,0,
20],0],[[4,0,-8,0,4],0],[[10,0,-20,0,10],0],[[6,0,-14,0,6],0],[[1,0,-1],
2],[[-2,0,6,0,-6,0,2],0],[[-3,0,10,0,-10,0,3],0],[[-1,0,5,0,-5,0,1],0],
[[4,0,0,0,-8,0,0,0,4],0],[[1],4],[[2,0,-2],4],[[-2,0,2,0,4,0,-4,0,-2,0,
2],0],[[-1],6],[[1],8],[[1,0,0,0,0,0,-1],6],[[1],10],[[-5],12],[[-1,0,2,
0,-1],12],[[6,0,-10,0,0,0,0,0,10,0,-6],10],[[-1,0,0,0,2,0,0,0,-1],12],
[[1],16],[[-1],18],[[1],20],[[-2],22],[[-5],24],[[-1,0,2,0,-1],24],[[1],
28],[[4],30],[[-5],36],[[-1,0,2,0,-1],36],[[1],40],[[-5],48],[[40],60]],
[[[48],0],[[-24,0,24],0],[[4,0,-10,0,4],0],[[12,0,-24,0,12],0],[[8,0,
-16,0,8],0],[[1,0,-1],2],[[-2,0,7,0,-7,0,2],0],[[-4,0,12,0,-12,0,4],0],
[[-2,0,6,0,-6,0,2],0],[[4,0,0,0,-10,0,0,0,4],0],[[-1],4],[[2,0,-2],4],
[[-2,0,2,0,5,0,-5,0,-2,0,2],0],[[],0],[[1],8],[[1,0,0,0,0,0,-1],6],[[],
0],[[2],12],[[1,0,0,0,1],12],[[6,0,-10,0,0,0,0,0,10,0,-6],10],[[1,0,0,0,
0,0,0,0,1],12],[[1],16],[[],0],[[-6],20],[[-2,0,4,0,-2],20],[[-2],24],
[[-1,0,0,0,-1],24],[[-1],28],[[],0],[[2],36],[[1,0,0,0,1],36],[[6],40],
[[-2],48],[[-48],60]]]);

CHEVIE.AddData("CycPolSchurElements","H4",
[ [1,0,2,2,2,2,3,3,4,4,5,5,6,6,10,10,12,15,20,30],
  [1,-60,2,2,2,2,3,3,4,4,5,5,6,6,10,10,12,15,20,30],
  [(5+ER(5))/2,-1,2,2,2,2,3,3,5,1/5,4/5,6,6,10,3/10,7/10,2/15,7/15,8/15,13/15,
   1/30,11/30,19/30,29/30],
  [(5+ER(5))/2,-31,2,2,2,2,3,3,5,1/5,4/5,6,6,10,3/10,7/10,2/15,7/15,8/15,13/15,
    1/30,11/30,19/30,29/30],
  [(5-ER(5))/2,-1,2,2,2,2,3,3,5,2/5,3/5,6,6,10,1/10,9/10,1/15,4/15,11/15,14/15,
   7/30,13/30,17/30,23/30],
  [(5-ER(5))/2,-31,2,2,2,2,3,3,5,2/5,3/5,6,6,10,1/10,9/10,1/15,4/15,11/15,
   14/15,7/30,13/30,17/30,23/30],
  [45+15*ER(5),-6,2,2,2,2,2/5,2/5,3/5,3/5,1/30,11/30,19/30,29/30],
  [45-15*ER(5),-6,2,2,2,2,1/5,1/5,4/5,4/5,7/30,13/30,17/30,23/30],
  [8,-6,3,3,5,5], [10,-6,3,3,4,4,5],
  [(5+ER(5))/2,-2,2,2,2,2,4,4,5,1/5,4/5,10,3/10,7/10,1/20,9/20,11/20,19/20],
  [(5+ER(5))/2,-22,2,2,2,2,4,4,5,1/5,4/5,10,3/10,7/10,1/20,9/20,11/20,19/20]
    ,
  [(5-ER(5))/2,-2,2,2,2,2,4,4,5,2/5,3/5,10,1/10,9/10,3/20,7/20,13/20,17/20],
  [(5-ER(5))/2,-22,2,2,2,2,4,4,5,2/5,3/5,10,1/10,9/10,3/20,7/20,13/20,17/20]
    , [10,-6,2,2,2,2,3,3,10],
  [20,-6,3,3,2/5,2/5,3/5,3/5,1/20,9/20,11/20,19/20],
  [20,-6,3,3,1/5,1/5,4/5,4/5,3/20,7/20,13/20,17/20], [2,-3,2,3,3,5,5,15],
  [2,-18,2,3,3,5,5,15], [2,-3,2,3,3,5,5,15], [2,-18,2,3,3,5,5,15],
  [10,-6,2,2,2,2,5,6,6],
  [105-45*ER(5),-6,4,4,2/5,2/5,3/5,3/5,2/15,7/15,8/15,13/15],
  [105+45*ER(5),-6,4,4,1/5,1/5,4/5,4/5,1/15,4/15,11/15,14/15],
  [1080-480*ER(5),-6,2/5,2/5,3/5,3/5,6,6,3/10,3/10,7/10,7/10],
  [1080+480*ER(5),-6,1/5,1/5,4/5,4/5,6,6,1/10,1/10,9/10,9/10],
  [1,-4,2,2,2,2,3,3,4,4,6,6,12], [1,-16,2,2,2,2,3,3,4,4,6,6,12],
  [45-15*ER(5),-6,2,2,2,2,3/10,3/10,7/10,7/10,1/15,4/15,11/15,14/15],
  [45+15*ER(5),-6,2,2,2,2,1/10,1/10,9/10,9/10,2/15,7/15,8/15,13/15],
  [1,-5,2,2,2,2,5,5,10,10], [1,-15,2,2,2,2,5,5,10,10],
  [40,-6,3,3,10,10], [12,-6,5,5,12]]);

# description of fake degrees by powers of q
CHEVIE.AddData("cycpolfakedegrees","H4",
[[1,0],[1,60],[1,1,4,4,12,20,36],[1,31,4,4,12,20,36],[1,7,4,4,12,20],[1,37,4,
4,12,20],[[1,0,0,0,1,0,0,0,0,2,0,0,0,0,1,0,0,0,1],12],[[1,0,1,0,0,2,0,0,1,0,
1],20],[[1,1,1,0,1,0,1,0,1,1,1],12,15,30],[1,13,4,4,4,12,12,20,36],[1,2,3,3,6,
6,12,15,24,30],[1,22,3,3,6,6,12,15,24,30],[1,6,3,3,6,6,12,15,30],[1,26,3,3,6,
6,12,15,30],[[1,1,0,-1,1,2,2,0,-2,0,2,2,1,-1,0,1,1],12,12],[1,11,4,4,4,12,16,
20,36],[1,13,4,4,4,8,12,20,28],[[1,0,0,0,1,0,0,0,0,1,1],3,4,4,12,20],[[1,1,0,
0,0,0,1,0,0,0,1],21,4,4,12,20],[[1,1,0,0,0,0,1,0,0,0,1],6,4,4,12,20],[[1,0,0,
0,1,0,0,0,0,1,1],18,4,4,12,20],[1,10,3,3,6,6,8,12,15,24,30],[[1,0,0,-1,2,-1,2,
-1,0,0,1],11,4,4,4,12,20],[[1,-1,1,-1,1,0,1,-1,1,0,1,-1,1,-1,1],7,4,4,4,12,
20],[[1,1,0,2,1,2,1,1,2,2,2,1,1,2,1,2,0,1,1],12],[[1,0,0,0,1,1,1,1,1,2,2,1,2,
1,2,2,1,1,1,1,1,0,0,0,1],6],[1,4,5,5,10,10,15,20,30],[1,16,5,5,10,10,15,20,
30],[[1,1,1,0,1,2,3,1,1,3,2,3,1,1,3,2,1,0,1,1,1],10],[[1,0,1,2,1,2,1,2,3,1,2,
1,3,2,1,2,1,2,1,0,1],10],[1,5,3,3,4,4,6,6,12,15,20,30],[1,15,3,3,4,4,6,6,12,
15,20,30],[[1,0,1,1,2,2,1,2,3,3,3,2,3,3,3,2,1,2,2,1,1,0,1],8],[[1,0,0,0,1,-1,
1,0,0,0,1],9,4,4,4,8,12,20]]);

###########################################################################
##
#F HeckeCharTable( <v> ) character table of the Hecke algebra of type H4
##
CHEVIE.AddData("HeckeCharTable","H4",function(param,sqrtparam)
 local a,v,q,tbl; a:=(1+ER(5))/2;
 q:=-param[1][1]/param[1][2];
 if not IsBound(sqrtparam[1]) then v:=GetRoot(q,2,"CharTable(Hecke(H4))");
 else v:=sqrtparam[1];
 fi;
 tbl:=rec(
  identifier:="H(H4)",
  text := "the ordering of the characters is that of Alvis-Lusztig (1982)",
  parameter := [ v^2, v^2, v^2, v^2 ],
  cartan:=CHEVIE.RawData("CartanMat","H4"),
  size := 14400,
  powermap:=CHEVIE.RawData("PowerMaps","H4"),
  irreducibles:=List(CHEVIE.RawData("vpolheckeirreducibles","H4"),
                     i->List(i,j->ValuePol(j[1],v)*v^j[2])),
  irredinfo:=List(CHEVIE.RawData("CharInfo","H4")().charparams,x->
    rec(charparam:=x,charname:=CHEVIE.RawData("CharName","H4")(x,rec()))));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","H4")());
  tbl.centralizers:=List(tbl.classes,x->tbl.size/x);
  tbl := CHEVIE.compat.MakeCharacterTable(tbl);
  CHEVIE.compat.AdjustHeckeCharTable(tbl,param);
  return tbl;
end);

# W-graphs given by Ivan Marin who got them from Alvis.
# see the comments before WGraphToRepresentation for the format.
# An integer instead of a graph says that the graph is dual to that
# of index specified by the integer.
CHEVIE.AddData("WGraphs","H4", [[[[]],[]],1,
[[[1],[2],[3],[4]],[[1,[[1,1],[2,3],[3,4]]],[(1+ER(5))/2,[[1,2]]]]],3,
[[[1],[2],[3],[4]],[[1,[[1,1],[2,3],[3,4]]],[(1-ER(5))/2,[[1,2]]]]],5,
[[[1,2],[1,3],[1,4],[2,3],[2,4],[3,4]],[[1,[[1,2],[2,3],[4,5],[5,6]]],
[(1+ER(5))/2,[[2,4],[3,5]]]]],
[[[1,2],[1,3],[1,4],[2,3],[2,4],[3,4]],[[1,[[1,2],[2,3],[4,5],[5,6]]],
[(1-ER(5))/2,[[2,4],[3,5]]]]],
[[[1],[2],[1,3],[1,4],[2,3],[2,4],[1,3,4],[2,3,4]],[[1,[[1,2,7],[2,3,6,8],[3,
4,5,7],[4,6],[5,6],[6,7],[7,8]]]]],
[[[1],[2],[1,3],[1,4],[2,3],[2,4],[1,3,4],[2,3,4]],[[-1,[[1,4],[5,8]]],[1,[[1,
2,7],[2,3,8],[3,4,5],[4,6],[5,6],[6,7],[7,8]]]]],
[[[1],[2],1,[3],1,[4],[1,3],[1,4],[2,4]],[[1,[[1,2,3],[2,4,9],[3,7],[4,6],[5,
9],[6,9],[7,8]]],[(1+ER(5))/2,[[1,8],[3,9],[5,7],[8,9]]]]],11,
[[[1],[2],1,[3],1,[4],[1,3],[1,4],[2,4]],[[1,[[1,2,3],[2,4,9],[3,7],[4,6],[5,
9],[6,9],[7,8]]],[(1-ER(5))/2,[[1,8],[3,9],[5,7],[8,9]]]]],13,
[[[2],[3],[1,3],1,[1,4],[2,3],[2,4],1,[1,2,4],[1,3,4]],[[1,[[1,3,7],[2,3,7],
[3,5,6],[4,6,9,10],[5,7,8],[6,8],[8,9,10]]]]],
[[[2],[3],[1,2],[1,3],2,[1,4],1,[2,3],1,[2,4],2,[3,4],[1,2,4],[1,3,4]],[[1,
[[1,6,11],[2,6,11],[3,4,15],[4,8],[5,9,15,16],[6,7,9],[7,11,12],[8,15,16],[9,
12],[10,13],[12,15,16],[13,14]]],[(3-ER(5))/2,[[1,10],[2,10,14]]],
[(1+ER(5))/2,[[4,10],[8,13],[14,16]]],[(-1+ER(5))/2,[[1,3],[2,5],[11,15]]]]],
[[[2],[3],[1,2],[1,3],2,[1,4],1,[2,3],1,[2,4],2,[3,4],[1,2,4],[1,3,4]],[[1,
[[1,6,11],[2,6,11],[3,4,15],[4,8],[5,9,15,16],[6,7,9],[7,11,12],[8,15,16],[9,
12],[10,13],[12,15,16],[13,14]]],[(3+ER(5))/2,[[1,10],[2,10,14]]],
[(1-ER(5))/2,[[4,10],[8,13],[14,16]]],[(-1-ER(5))/2,[[1,3],[2,5],[11,15]]]]],
[[[1],1,[2],2,[3],1,[4],[1,3],1,[1,4],1,[2,3],[2,4],1,[3,4]],[[1,[[1,3,4,10,
12],[2,5,10,11],[3,9,13,15],[4,6,14],[5,10,13,15],[6,8,10,13,16],[7,9,10,13,
15,16],[8,12,14],[9,11],[10,12,13],[11,15],[12,14,15],[13,14],[14,16]]]]],18,
[[[1],1,[2],2,[3],1,[4],[1,3],1,[1,4],1,[2,3],[2,4],1,[3,4]],[[-1,[[1,10],[2,
10],[3,13],[5,13],[6,10],[7,13,16],[8,12]]],[1,[[1,3,4,12],[2,5,11],[3,9,15],
[4,6,14],[5,10,15],[6,8,13,16],[7,9,10,15],[8,14],[9,11],[10,12,13],[11,15],
[12,14,15],[13,14],[14,16]]]]],20,
[[[1],[2],1,[3],[1,3],2,[1,4],1,[2,3],1,[2,4],2,[1,2,4],[1,3,4],1,[2,3,4]],
[[1,[[1,3,7,9,16],[2,7,13],[3,6,10,15,18],[4,7,13],[5,10,15,17],[6,9,11],[7,8,
10],[8,12,13],[9,14,15],[10,12],[11,14,18],[12,15,17],[14,16],[16,18]]],[2,
[[3,14],[4,11,16],[6,16],[8,16],[12,18]]]]],
[[[1],[2],1,[3],[1,2],[1,3],3,[1,4],2,[2,3],2,[2,4],3,[3,4],[1,2,4],[1,3,4],1,
[2,3,4]],[[1,[[1,3,22],[2,9,16],[3,8,24],[4,9,16],[5,6],[6,11],[7,13,21,23],
[8,12,14],[9,10,13],[10,16,17],[12,19],[13,17],[14,19],[15,18],[17,21,23],[18,
20],[19,22],[22,24]]],[(5-ER(5))/2,[[1,5,9],[3,13,19,21],[8,22],[12,21]]],
[2-ER(5),[[4,7],[16,21]]],[(3-ER(5))/2,[[1,12],[2,5],[4,14,22],[10,22],[14,
24],[17,24],[20,23,24]]],[(1-ER(5))/2,[[2,15],[4,15,20],[5,21],[6,15],[11,18,
21,23]]]]],
[[[1],[2],1,[3],[1,2],[1,3],3,[1,4],2,[2,3],2,[2,4],3,[3,4],[1,2,4],[1,3,4],1,
[2,3,4]],[[1,[[1,3,22],[2,9,16],[3,8,24],[4,9,16],[5,6],[6,11],[7,13,21,23],
[8,12,14],[9,10,13],[10,16,17],[12,19],[13,17],[14,19],[15,18],[17,21,23],[18,
20],[19,22],[22,24]]],[(5+ER(5))/2,[[1,5,9],[3,13,19,21],[8,22],[12,21]]],
[2+ER(5),[[4,7],[16,21]]],[(3+ER(5))/2,[[1,12],[2,5],[4,14,22],[10,22],[14,
24],[17,24],[20,23,24]]],[(1+ER(5))/2,[[2,15],[4,15,20],[5,21],[6,15],[11,18,
21,23]]]]],
[[[1],[2],1,[3],[1,2],[1,3],3,[1,4],2,[2,3],2,[2,4],3,[3,4],[1,2,4],[1,3,4],1,
[2,3,4]],[[1,[[1,3,22],[2,9,16],[3,8,24],[4,9,16],[5,6],[6,11],[7,13,21,23],
[8,12,14],[9,10,13],[10,16,17],[12,19],[13,17],[14,19],[15,18],[17,21,23],[18,
20],[19,22],[22,24]]],[(5-3*ER(5))/2,[[1,5],[4,7],[16,21]]],[(5-ER(5))/2,[[2,
5]]],[2-ER(5),[[1,9],[3,13,19,21],[8,22],[12,21]]],[(3-ER(5))/2,[[20,23]]],
[1-ER(5),[[1,12],[4,14,22],[10,22],[14,24],[17,24],[20,24]]],[(1-ER(5))/2,[[5,
21],[6,15],[11,18,21,23]]],[-ER(5),[[2,15],[4,15,20]]]]],
[[[1],[2],1,[3],[1,2],[1,3],3,[1,4],2,[2,3],2,[2,4],3,[3,4],[1,2,4],[1,3,4],1,
[2,3,4]],[[1,[[1,3,22],[2,9,16],[3,8,24],[4,9,16],[5,6],[6,11],[7,13,21,23],
[8,12,14],[9,10,13],[10,16,17],[12,19],[13,17],[14,19],[15,18],[17,21,23],[18,
20],[19,22],[22,24]]],[(5+ER(5))/2,[[2,5]]],[(5+3*ER(5))/2,[[1,5],[4,7],[16,
21]]],[2+ER(5),[[1,9],[3,13,19,21],[8,22],[12,21]]],[(3+ER(5))/2,[[20,23]]],
[1+ER(5),[[1,12],[4,14,22],[10,22],[14,24],[17,24],[20,24]]],[(1+ER(5))/2,[[5,
21],[6,15],[11,18,21,23]]],[ER(5),[[2,15],[4,15,20]]]]],
[[[1],2,[2],3,[3],2,[4],[1,3],2,[1,4],2,[2,3],1,[2,4],3,[3,4],[1,3,4]],[[1,
[[1,4,13,17],[2,5,6,14,16],[3,7,14,15],[4,14,19,20,22],[5,8,21],[6,12,18,23],
[7,13,18,23],[8,11,14,19,24],[9,14,19,22,24],[10,12,13,23],[11,17,21],[12,15],
[13,16,19],[14,17,18,25],[15,23,25],[16,21,23,25],[17,20,22],[18,20],[19,21],
[20,25],[21,24],[24,25]]],[2,[[10,18,25]]]]],27,
[[[1],[2],1,[3],[1,2],1,[1,3],4,[1,4],3,[2,3],3,[2,4],4,[3,4],1,[1,2,4],[1,3,
4],1,[2,3,4]],[[-1,[[1,6]]],[1,[[1,3,5,11,29],[2,5,11,16,20],[3,9,18,27,30],
[4,10,11,16,17,20,25,29],[5,7,27],[6,8],[7,13,16,19],[8,14,19],[9,12,17],[10,
18,27,28],[11,15,18],[12,24,27],[13,21,22,27,28],[14,22],[15,20,23,29],[16,
21],[17,24],[18,23],[19,22],[20,27],[21,25],[22,26],[23,27,28,30],[24,29],[25,
28],[29,30]]],[(7-ER(5))/2,[[26,28]]],[(5-ER(5))/2,[[6,27],[14,27,28],[26,
30]]],[(1+ER(5))/2,[[3,24],[9,29]]],[(-1+ER(5))/2,[[1,12],[17,30]]],
[(-3+ER(5))/2,[[25,30]]]]],
[[[1],[2],1,[3],[1,2],1,[1,3],4,[1,4],3,[2,3],3,[2,4],4,[3,4],1,[1,2,4],[1,3,
4],1,[2,3,4]],[[-1,[[1,6]]],[1,[[1,3,5,11,29],[2,5,11,16,20],[3,9,18,27,30],
[4,10,11,16,17,20,25,29],[5,7,27],[6,8],[7,13,16,19],[8,14,19],[9,12,17],[10,
18,27,28],[11,15,18],[12,24,27],[13,21,22,27,28],[14,22],[15,20,23,29],[16,
21],[17,24],[18,23],[19,22],[20,27],[21,25],[22,26],[23,27,28,30],[24,29],[25,
28],[29,30]]],[(7+ER(5))/2,[[26,28]]],[(5+ER(5))/2,[[6,27],[14,27,28],[26,
30]]],[(1-ER(5))/2,[[3,24],[9,29]]],[(-1-ER(5))/2,[[1,12],[17,30]]],
[(-3-ER(5))/2,[[25,30]]]]],
[[[1],2,[2],4,[3],3,[4],[1,2],[1,3],4,[1,4],4,[2,3],2,[2,4],5,[3,4],1,[1,3,
4]],[[1,[[1,4,16,19,22],[2,5,6,23],[3,8,14,15,20],[4,14,15,25,27,32,33],[5,10,
28],[6,17,29],[7,16,31],[8,19,26,29],[9,15,25,27,33,34,35],[10,13,35],[11,17,
19,26,29,36],[12,16,26,31,36],[14,18],[15,22,26,36],[16,24,27],[17,20],[18,21,
27],[19,23,25],[20,29,36],[21,30],[22,32,33],[23,28,29],[24,30,31,36],[25,28],
[26,32],[27,30],[28,35],[30,34],[32,36],[34,36]]]]],31,
[[[1],[2],2,[3],1,[1,2],1,[1,3],6,[1,4],4,[2,3],4,[2,4],6,[3,4],1,[1,2,4],1,
[1,3,4],2,[2,3,4]],[[-1,[[3,8,25],[5,14,25,34],[30,35]]],[1,[[1,4,37],[2,8,12,
22,25,27],[3,15,30],[4,13,40],[5,15,30],[6,12,14,22,25,27,33,34],[7,9,36],[8,
10,35],[9,18,22,25],[10,19,25],[11,21,36,38],[12,17,21],[13,16,23],[14,24,35,
39],[15,20,24],[16,28],[17,26,27],[18,31,32,36,38],[19,32,35,39],[20,29,30],
[21,26],[22,31],[23,28],[24,29],[25,32],[26,36,38],[27,35],[28,37],[29,35,39],
[31,33],[32,34],[33,38,40],[34,38,39],[37,40]]],[2,[[1,7,12,16],[2,7],[4,21,
36],[5,23,37],[6,11],[16,36],[20,37],[23,40],[27,36],[29,40],[34,40]]],[3,[[3,
7],[4,28],[5,11],[6,23,37],[13,37],[17,37],[26,40],[30,36]]],[4,[[3,22],[5,22,
33]]]]],
[[[1],1,[2],3,[3],1,[1,2],1,[1,3],7,[1,4],5,[2,3],5,[2,4],7,[3,4],1,[1,2,4],1,
[1,3,4],3,[2,3,4],1],[[-1,[[2,10,23],[28,48],[40,48]]],[1,[[1,4,9,20,43],[2,5,
15,45],[3,15,33],[4,11,47],[5,12,25,42,48],[6,14,32],[7,14,27,32,43],[8,15,28,
33,45],[9,18,41],[10,13,42],[11,20,27],[12,23,28],[13,21,29],[14,24,26],[15,
19,25],[16,25,42,46],[17,26,41,44],[18,22,29,30],[19,33,37,45],[20,31],[21,34,
42,46],[22,34,35,41,44],[23,38,42],[24,32,36,43],[25,37],[26,36],[27,31,47],
[28,38],[29,34],[30,35],[31,43],[34,39],[35,40],[36,41,44,47],[37,42,46,48],
[38,45],[39,44,46,48],[40,44,47],[43,47],[45,48]]],[2,[[4,31],[11,43]]],[3,
[[1,14],[4,26,41],[20,41]]],[(3-ER(5))/2,[[1,10,15,23],[4,25,38,42],[6,9,10,
29],[7,16,17,29,39],[11,45],[20,42],[27,48],[32,41,42]]],[(3+ER(5))/2,[[2,9,
14,20],[3,30],[5,26,31,41],[8,30,40],[12,43],[23,41],[28,47]]],[1+ER(5),[[3,
9],[8,17],[33,41]]],[(-1+ER(5))/2,[[3,10,29],[8,16,29,39],[33,42]]]]]]);

CHEVIE.AddData("WGraph","H4",function(i)local gr;
 gr:=CHEVIE.RawData("WGraphs","H4");
 if IsInt(gr[i]) then return DualWGraph(4,gr[gr[i]]); else return gr[i]; fi;
end);

CHEVIE.AddData("HeckeRepresentation","H4",function(param,sqrtparam,i)local v;
 if not IsBound(sqrtparam[1]) then 
     v:=GetRoot(-param[1][1]/param[1][2],2,"Representation(Hecke(H4),[",i,"])");
 else v:=sqrtparam[1];
 fi;
 return -param[1][2]*WGraphToRepresentation(4,CHEVIE.RawData("WGraph","H4")(i),v);
end);

CHEVIE.AddData("Representation","H4",function(i)
  return CHEVIE.RawData("HeckeRepresentation","H4")
  ([[1,-1],[1,-1],[1,-1],[1,-1]],[1,1,1,1],i);end);

if not IsBound(CHEVIE.families) then ReadChv("unip/families");fi;

CHEVIE.families.HS4:=rec(group:="SL2(5)",name:="H4",
charLabels:=List([1..74],i->"?"),  #[],
fourierMat:=1/60*
[[18,0,-18,-6,-6,18,6,6,6,6,-6,-6,-6,-6,12,0,6,6,-6,-6,-6,-6,6,6,0,-18,
6,6,6,6,-6,-6,12,0,6,6,-6,-6,-6,-6,6,6,0,0,0,0,0,0,-6,-6,6,6,-6,-6,6,6,
0,0,0,0,-6,-6,-6,-6,0,0,0,0,-6,-6,-6,-6,12,12],[0,45/2,0,0,0,0,-15,-15,
15/2,15/2,0,0,0,0,-15/2,15,0,0,0,0,0,0,0,0,45/2,0,-15,-15,15/2,15/2,0,0,
-15/2,15,0,0,0,0,0,0,0,0,-15,-15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,15,15],[-18,0,18,-6,-6,18,-6,-6,6,6,6,6,6,6,-12,0,6,6,
-6,-6,6,6,-6,-6,0,-18,6,6,-6,-6,-6,-6,12,0,-6,-6,6,6,-6,-6,6,6,0,0,0,0,
0,0,6,6,-6,-6,-6,-6,6,6,0,0,0,0,-6,-6,-6,-6,0,0,0,0,6,6,6,6,12,-12],[-6,
0,-6,12-2*ER(5),12+2*ER(5),-6,-3-3*ER(5),-3+3*ER(5),3-ER(5),3+ER(5),-2,
-2,12+2*ER(5),12-2*ER(5),6,-10,3+3*ER(5),3+3*ER(5),-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),0,-6,-3-3*ER(5),
-3+3*ER(5),3-ER(5),3+ER(5),-2,-2,6,-10,3+3*ER(5),3+3*ER(5),-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),0,0,10,10,10,10,
3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),-2*ER(5),-2*ER(5),-2*ER(5),-2*ER(5),-3+ER(5),
-3+ER(5),-3-ER(5),-3-ER(5),-4*ER(5),-4*ER(5),-4*ER(5),-4*ER(5),-3-ER(5),
-3-ER(5),-3+ER(5),-3+ER(5),4,4],[-6,0,-6,12+2*ER(5),12-2*ER(5),-6,
-3+3*ER(5),-3-3*ER(5),3+ER(5),3-ER(5),-2,-2,12-2*ER(5),12+2*ER(5),6,-10,
3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),0,-6,-3+3*ER(5),-3-3*ER(5),3+ER(5),3-ER(5),-2,-2,
6,-10,3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),0,0,10,10,10,10,3+3*ER(5),3+3*ER(5),-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),2*ER(5),2*ER(5),
2*ER(5),2*ER(5),-3-ER(5),-3-ER(5),-3+ER(5),-3+ER(5),4*ER(5),4*ER(5),
4*ER(5),4*ER(5),-3+ER(5),-3+ER(5),-3-ER(5),-3-ER(5),4,4],[18,0,18,-6,-6,
18,-6,-6,6,6,6,6,-6,-6,12,0,6,6,-6,-6,6,6,-6,-6,0,18,-6,-6,6,6,6,6,12,0,
6,6,-6,-6,6,6,-6,-6,0,0,0,0,0,0,6,6,-6,-6,6,6,-6,-6,0,0,0,0,-6,-6,-6,-6,
0,0,0,0,-6,-6,-6,-6,-12,-12],[6,-15,-6,-3-3*ER(5),-3+3*ER(5),-6,12,12,3,
3,3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),9,0,3+3*ER(5),3+3*ER(5),
-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),15,6,
-12,-12,-3,-3,-3+3*ER(5),-3-3*ER(5),-9,0,-3-3*ER(5),-3-3*ER(5),
3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),0,0,0,0,0,
0,3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),
3-3*ER(5),3-3*ER(5),0,0,0,0,-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),
0,0,0,0,3+3*ER(5),3+3*ER(5),3-3*ER(5),3-3*ER(5),6,-6],[6,-15,-6,
-3+3*ER(5),-3-3*ER(5),-6,12,12,3,3,3+3*ER(5),3-3*ER(5),3+3*ER(5),
3-3*ER(5),9,0,3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),
3-3*ER(5),-3-3*ER(5),-3-3*ER(5),15,6,-12,-12,-3,-3,-3-3*ER(5),
-3+3*ER(5),-9,0,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),0,0,0,0,0,0,3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),0,0,0,0,
-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),0,0,0,0,3-3*ER(5),3-3*ER(5),
3+3*ER(5),3+3*ER(5),6,-6],[6,15/2,6,3-ER(5),3+ER(5),6,3,3,(9-4*ER(5))/2,
(9+4*ER(5))/2,7-3*ER(5),7+3*ER(5),3+ER(5),3-ER(5),3/2,5,-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),3+3*ER(5),
3+3*ER(5),15/2,6,3,3,(9-4*ER(5))/2,(9+4*ER(5))/2,7-3*ER(5),7+3*ER(5),
3/2,5,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),
3+3*ER(5),3+3*ER(5),15,15,10,10,10,10,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),
3+3*ER(5),-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),2*ER(5),2*ER(5),
2*ER(5),2*ER(5),3-ER(5),3-ER(5),3+ER(5),3+ER(5),4*ER(5),4*ER(5),4*ER(5),
4*ER(5),3+ER(5),3+ER(5),3-ER(5),3-ER(5),1,1],[6,15/2,6,3+ER(5),3-ER(5),
6,3,3,(9+4*ER(5))/2,(9-4*ER(5))/2,7+3*ER(5),7-3*ER(5),3-ER(5),3+ER(5),
3/2,5,-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),
3-3*ER(5),3-3*ER(5),15/2,6,3,3,(9+4*ER(5))/2,(9-4*ER(5))/2,7+3*ER(5),
7-3*ER(5),3/2,5,-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),-3-3*ER(5),
-3-3*ER(5),3-3*ER(5),3-3*ER(5),15,15,10,10,10,10,-3-3*ER(5),-3-3*ER(5),
3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),-2*ER(5),
-2*ER(5),-2*ER(5),-2*ER(5),3+ER(5),3+ER(5),3-ER(5),3-ER(5),-4*ER(5),
-4*ER(5),-4*ER(5),-4*ER(5),3-ER(5),3-ER(5),3+ER(5),3+ER(5),1,1],[-6,0,6,
-2,-2,6,3-3*ER(5),3+3*ER(5),7-3*ER(5),7+3*ER(5),2,2,2,2,6,10,-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),3+3*ER(5),
3+3*ER(5),0,-6,-3+3*ER(5),-3-3*ER(5),-7+3*ER(5),-7-3*ER(5),-2,-2,-6,-10,
3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),0,0,-10,-10,10,10,-3-3*ER(5),-3-3*ER(5),3-3*ER(5),
3-3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),-10,-10,10,10,
3-3*ER(5),3-3*ER(5),3+3*ER(5),3+3*ER(5),0,0,0,0,-3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3+3*ER(5),4,-4],[-6,0,6,-2,-2,6,3+3*ER(5),3-3*ER(5),
7+3*ER(5),7-3*ER(5),2,2,2,2,6,10,-3-3*ER(5),-3-3*ER(5),3-3*ER(5),
3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),0,-6,-3-3*ER(5),
-3+3*ER(5),-7-3*ER(5),-7+3*ER(5),-2,-2,-6,-10,3+3*ER(5),3+3*ER(5),
-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),0,0,-10,
-10,10,10,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),-10,-10,10,10,3+3*ER(5),3+3*ER(5),3-3*ER(5),
3-3*ER(5),0,0,0,0,-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),4,-4],[-6,
0,6,12+2*ER(5),12-2*ER(5),-6,3-3*ER(5),3+3*ER(5),3+ER(5),3-ER(5),2,2,
12-2*ER(5),12+2*ER(5),6,10,3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),0,6,3-3*ER(5),3+3*ER(5),
3+ER(5),3-ER(5),2,2,6,10,3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),0,0,-10,-10,-10,-10,
-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),
3-3*ER(5),3-3*ER(5),2*ER(5),2*ER(5),2*ER(5),2*ER(5),-3-ER(5),-3-ER(5),
-3+ER(5),-3+ER(5),4*ER(5),4*ER(5),4*ER(5),4*ER(5),-3+ER(5),-3+ER(5),
-3-ER(5),-3-ER(5),-4,-4],[-6,0,6,12-2*ER(5),12+2*ER(5),-6,3+3*ER(5),
3-3*ER(5),3-ER(5),3+ER(5),2,2,12+2*ER(5),12-2*ER(5),6,10,3+3*ER(5),
3+3*ER(5),-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),
3-3*ER(5),0,6,3+3*ER(5),3-3*ER(5),3-ER(5),3+ER(5),2,2,6,10,3+3*ER(5),
3+3*ER(5),-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),
3-3*ER(5),0,0,-10,-10,-10,-10,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),
-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),-2*ER(5),-2*ER(5),-2*ER(5),
-2*ER(5),-3+ER(5),-3+ER(5),-3-ER(5),-3-ER(5),-4*ER(5),-4*ER(5),-4*ER(5),
-4*ER(5),-3-ER(5),-3-ER(5),-3+ER(5),-3+ER(5),-4,-4],[12,-15/2,-12,6,6,
12,9,9,3/2,3/2,6,6,6,6,21/2,15,-6,-6,6,6,6,6,-6,-6,-15/2,-12,9,9,3/2,
3/2,6,6,21/2,15,-6,-6,6,6,6,6,-6,-6,-15,-15,0,0,0,0,6,6,-6,-6,6,6,-6,-6,
0,0,0,0,6,6,6,6,0,0,0,0,6,6,6,6,3,3],[0,15,0,-10,-10,0,0,0,5,5,10,10,10,
10,15,20,0,0,0,0,0,0,0,0,-15,0,0,0,-5,-5,-10,-10,-15,-20,0,0,0,0,0,0,0,
0,0,0,10,10,-10,-10,0,0,0,0,0,0,0,0,10,10,-10,-10,0,0,0,0,0,0,0,0,0,0,0,
0,-10,10],[6,0,6,3+3*ER(5),3-3*ER(5),6,3+3*ER(5),3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,-3+3*ER(5),12,
-12,3+3*ER(5),-3+3*ER(5),12,-12,3+3*ER(5),0,6,3+3*ER(5),3-3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-6,0,-3+3*ER(5),12,-12,
3+3*ER(5),-3+3*ER(5),12,-12,3+3*ER(5),0,0,0,0,0,0,-3-3*ER(5),-3+3*ER(5),
3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,
3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,3+3*ER(5),3-3*ER(5),
3+3*ER(5),3-3*ER(5),6,6],[6,0,6,3+3*ER(5),3-3*ER(5),6,3+3*ER(5),
3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),
3+3*ER(5),-6,0,12,-3+3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),3+3*ER(5),-12,
0,6,3+3*ER(5),3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-6,
0,12,-3+3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),3+3*ER(5),-12,0,0,0,0,0,0,
-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),0,0,0,0,3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),0,0,
0,0,3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),6,6],[-6,0,-6,-3+3*ER(5),
-3-3*ER(5),-6,-3+3*ER(5),-3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),
3-3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,-12,3+3*ER(5),-3+3*ER(5),12,-12,
3+3*ER(5),-3+3*ER(5),12,0,-6,-3+3*ER(5),-3-3*ER(5),3+3*ER(5),3-3*ER(5),
3+3*ER(5),3-3*ER(5),6,0,-12,3+3*ER(5),-3+3*ER(5),12,-12,3+3*ER(5),
-3+3*ER(5),12,0,0,0,0,0,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),
3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,0,0,0,-3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),0,0,0,0,-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
-3+3*ER(5),-6,-6],[-6,0,-6,-3+3*ER(5),-3-3*ER(5),-6,-3+3*ER(5),
-3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),6,0,3+3*ER(5),-12,12,-3+3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),
0,-6,-3+3*ER(5),-3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),6,0,
3+3*ER(5),-12,12,-3+3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),0,0,0,0,0,0,
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),0,0,0,0,-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),0,0,0,0,-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-6,-6],
[-6,0,6,3+3*ER(5),3-3*ER(5),6,3+3*ER(5),3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),6,0,-3+3*ER(5),12,-12,
3+3*ER(5),-3+3*ER(5),12,-12,3+3*ER(5),0,-6,-3-3*ER(5),-3+3*ER(5),
3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,3-3*ER(5),-12,12,
-3-3*ER(5),3-3*ER(5),-12,12,-3-3*ER(5),0,0,0,0,0,0,-3-3*ER(5),
-3+3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),0,0,0,0,3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-6,6],[-6,0,6,3+3*ER(5),
3-3*ER(5),6,3+3*ER(5),3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),6,0,12,-3+3*ER(5),3+3*ER(5),-12,12,
-3+3*ER(5),3+3*ER(5),-12,0,-6,-3-3*ER(5),-3+3*ER(5),3-3*ER(5),3+3*ER(5),
3-3*ER(5),3+3*ER(5),-6,0,-12,3-3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),
-3-3*ER(5),12,0,0,0,0,0,0,-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),0,0,0,0,3-3*ER(5),3+3*ER(5),
3-3*ER(5),3+3*ER(5),0,0,0,0,-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
-6,6],[6,0,-6,-3+3*ER(5),-3-3*ER(5),-6,-3+3*ER(5),-3-3*ER(5),3+3*ER(5),
3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),-6,0,-12,3+3*ER(5),
-3+3*ER(5),12,-12,3+3*ER(5),-3+3*ER(5),12,0,6,3-3*ER(5),3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,12,-3-3*ER(5),3-3*ER(5),
-12,12,-3-3*ER(5),3-3*ER(5),-12,0,0,0,0,0,0,3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),0,0,0,0,3+3*ER(5),3-3*ER(5),
3+3*ER(5),3-3*ER(5),6,-6],[6,0,-6,-3+3*ER(5),-3-3*ER(5),-6,-3+3*ER(5),
-3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),
-6,0,3+3*ER(5),-12,12,-3+3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),0,6,
3-3*ER(5),3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,
-3-3*ER(5),12,-12,3-3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),0,0,0,0,0,0,
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),0,0,0,0,-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
0,0,0,0,3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),6,-6],[0,45/2,0,0,0,0,
15,15,15/2,15/2,0,0,0,0,-15/2,-15,0,0,0,0,0,0,0,0,45/2,0,15,15,15/2,
15/2,0,0,-15/2,-15,0,0,0,0,0,0,0,0,-15,-15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,-15,-15],[-18,0,-18,-6,-6,18,6,6,6,6,-6,-6,
6,6,-12,0,6,6,-6,-6,-6,-6,6,6,0,18,-6,-6,-6,-6,6,6,12,0,-6,-6,6,6,6,6,
-6,-6,0,0,0,0,0,0,-6,-6,6,6,6,6,-6,-6,0,0,0,0,-6,-6,-6,-6,0,0,0,0,6,6,6,
6,-12,12],[6,-15,6,-3-3*ER(5),-3+3*ER(5),-6,-12,-12,3,3,-3+3*ER(5),
-3-3*ER(5),3-3*ER(5),3+3*ER(5),9,0,3+3*ER(5),3+3*ER(5),-3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),15,-6,12,12,-3,-3,
3-3*ER(5),3+3*ER(5),-9,0,-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),
3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),0,0,0,0,0,0,-3-3*ER(5),
-3-3*ER(5),3-3*ER(5),3-3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),
-3+3*ER(5),0,0,0,0,-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),0,0,0,0,
3+3*ER(5),3+3*ER(5),3-3*ER(5),3-3*ER(5),-6,6],[6,-15,6,-3+3*ER(5),
-3-3*ER(5),-6,-12,-12,3,3,-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),9,0,
3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),
3+3*ER(5),3+3*ER(5),15,-6,12,12,-3,-3,3+3*ER(5),3-3*ER(5),-9,0,
-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),0,0,0,0,0,0,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),
3+3*ER(5),3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),0,0,0,0,-3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),0,0,0,0,3-3*ER(5),3-3*ER(5),3+3*ER(5),
3+3*ER(5),-6,6],[6,15/2,-6,3-ER(5),3+ER(5),6,-3,-3,(9-4*ER(5))/2,
(9+4*ER(5))/2,-7+3*ER(5),-7-3*ER(5),3+ER(5),3-ER(5),3/2,-5,-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),3-3*ER(5),-3-3*ER(5),
-3-3*ER(5),15/2,-6,-3,-3,(9-4*ER(5))/2,(9+4*ER(5))/2,-7+3*ER(5),
-7-3*ER(5),3/2,-5,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),
3-3*ER(5),-3-3*ER(5),-3-3*ER(5),15,15,-10,-10,-10,-10,3-3*ER(5),
3-3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),-3-3*ER(5),
-3-3*ER(5),2*ER(5),2*ER(5),2*ER(5),2*ER(5),3-ER(5),3-ER(5),3+ER(5),
3+ER(5),4*ER(5),4*ER(5),4*ER(5),4*ER(5),3+ER(5),3+ER(5),3-ER(5),3-ER(5),
-1,-1],[6,15/2,-6,3+ER(5),3-ER(5),6,-3,-3,(9+4*ER(5))/2,(9-4*ER(5))/2,
-7-3*ER(5),-7+3*ER(5),3-ER(5),3+ER(5),3/2,-5,-3-3*ER(5),-3-3*ER(5),
3-3*ER(5),3-3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),15/2,-6,
-3,-3,(9+4*ER(5))/2,(9-4*ER(5))/2,-7-3*ER(5),-7+3*ER(5),3/2,-5,
-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),3+3*ER(5),3+3*ER(5),
-3+3*ER(5),-3+3*ER(5),15,15,-10,-10,-10,-10,3+3*ER(5),3+3*ER(5),
-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),
-2*ER(5),-2*ER(5),-2*ER(5),-2*ER(5),3+ER(5),3+ER(5),3-ER(5),3-ER(5),
-4*ER(5),-4*ER(5),-4*ER(5),-4*ER(5),3-ER(5),3-ER(5),3+ER(5),3+ER(5),-1,
-1],[-6,0,-6,-2,-2,6,-3+3*ER(5),-3-3*ER(5),7-3*ER(5),7+3*ER(5),-2,-2,2,
2,6,-10,-3+3*ER(5),-3+3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),3-3*ER(5),
-3-3*ER(5),-3-3*ER(5),0,6,3-3*ER(5),3+3*ER(5),-7+3*ER(5),-7-3*ER(5),2,2,
-6,10,3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),
3+3*ER(5),3+3*ER(5),0,0,10,10,-10,-10,3+3*ER(5),3+3*ER(5),-3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),-10,-10,10,10,
3-3*ER(5),3-3*ER(5),3+3*ER(5),3+3*ER(5),0,0,0,0,-3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3+3*ER(5),-4,4],[-6,0,-6,-2,-2,6,-3-3*ER(5),-3+3*ER(5),
7+3*ER(5),7-3*ER(5),-2,-2,2,2,6,-10,-3-3*ER(5),-3-3*ER(5),3-3*ER(5),
3-3*ER(5),3+3*ER(5),3+3*ER(5),-3+3*ER(5),-3+3*ER(5),0,6,3+3*ER(5),
3-3*ER(5),-7-3*ER(5),-7+3*ER(5),2,2,-6,10,3+3*ER(5),3+3*ER(5),
-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),3-3*ER(5),3-3*ER(5),0,0,10,
10,-10,-10,3-3*ER(5),3-3*ER(5),-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),
-3+3*ER(5),3+3*ER(5),3+3*ER(5),-10,-10,10,10,3+3*ER(5),3+3*ER(5),
3-3*ER(5),3-3*ER(5),0,0,0,0,-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),
-4,4],[12,-15/2,12,6,6,12,-9,-9,3/2,3/2,-6,-6,6,6,21/2,-15,-6,-6,6,6,-6,
-6,6,6,-15/2,12,-9,-9,3/2,3/2,-6,-6,21/2,-15,-6,-6,6,6,-6,-6,6,6,-15,
-15,0,0,0,0,-6,-6,6,6,-6,-6,6,6,0,0,0,0,6,6,6,6,0,0,0,0,6,6,6,6,-3,-3],
[0,15,0,-10,-10,0,0,0,5,5,-10,-10,10,10,15,-20,0,0,0,0,0,0,0,0,-15,0,0,
0,-5,-5,10,10,-15,20,0,0,0,0,0,0,0,0,0,0,-10,-10,10,10,0,0,0,0,0,0,0,0,
10,10,-10,-10,0,0,0,0,0,0,0,0,0,0,0,0,10,-10],[6,0,-6,3+3*ER(5),
3-3*ER(5),6,-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),
3+3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,-3+3*ER(5),12,-12,3+3*ER(5),
3-3*ER(5),-12,12,-3-3*ER(5),0,-6,-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),
-3-3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,-3+3*ER(5),12,-12,3+3*ER(5),
3-3*ER(5),-12,12,-3-3*ER(5),0,0,0,0,0,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,0,0,0,3+3*ER(5),
3-3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,3+3*ER(5),3-3*ER(5),3+3*ER(5),
3-3*ER(5),-6,-6],[6,0,-6,3+3*ER(5),3-3*ER(5),6,-3-3*ER(5),-3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,12,
-3+3*ER(5),3+3*ER(5),-12,-12,3-3*ER(5),-3-3*ER(5),12,0,-6,-3-3*ER(5),
-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,12,-3+3*ER(5),
3+3*ER(5),-12,-12,3-3*ER(5),-3-3*ER(5),12,0,0,0,0,0,0,3-3*ER(5),
3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),
-3-3*ER(5),0,0,0,0,3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),0,0,0,0,
3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),-6,-6],[-6,0,6,-3+3*ER(5),
-3-3*ER(5),-6,3-3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,-12,3+3*ER(5),-3+3*ER(5),12,12,
-3-3*ER(5),3-3*ER(5),-12,0,6,3-3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),6,0,-12,3+3*ER(5),-3+3*ER(5),12,12,-3-3*ER(5),
3-3*ER(5),-12,0,0,0,0,0,0,-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,-3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),0,0,0,0,-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
-3+3*ER(5),6,6],[-6,0,6,-3+3*ER(5),-3-3*ER(5),-6,3-3*ER(5),3+3*ER(5),
3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,
3+3*ER(5),-12,12,-3+3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),0,6,3-3*ER(5),
3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,3+3*ER(5),-12,
12,-3+3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),0,0,0,0,0,0,-3+3*ER(5),
-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),
3+3*ER(5),0,0,0,0,-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),0,0,0,0,
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),6,6],[-6,0,-6,3+3*ER(5),
3-3*ER(5),6,-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),
3+3*ER(5),-3+3*ER(5),-3-3*ER(5),6,0,-3+3*ER(5),12,-12,3+3*ER(5),
3-3*ER(5),-12,12,-3-3*ER(5),0,6,3+3*ER(5),3-3*ER(5),3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),-6,0,3-3*ER(5),-12,12,-3-3*ER(5),-3+3*ER(5),12,
-12,3+3*ER(5),0,0,0,0,0,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,3+3*ER(5),3-3*ER(5),
3+3*ER(5),3-3*ER(5),0,0,0,0,-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),
6,-6],[-6,0,-6,3+3*ER(5),3-3*ER(5),6,-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),
-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),6,0,12,-3+3*ER(5),
3+3*ER(5),-12,-12,3-3*ER(5),-3-3*ER(5),12,0,6,3+3*ER(5),3-3*ER(5),
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-6,0,-12,3-3*ER(5),-3-3*ER(5),
12,12,-3+3*ER(5),3+3*ER(5),-12,0,0,0,0,0,0,3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),0,0,0,0,
3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),0,0,0,0,-3+3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3-3*ER(5),6,-6],[6,0,6,-3+3*ER(5),-3-3*ER(5),-6,3-3*ER(5),
3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),
-6,0,-12,3+3*ER(5),-3+3*ER(5),12,12,-3-3*ER(5),3-3*ER(5),-12,0,-6,
-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),6,0,12,
-3-3*ER(5),3-3*ER(5),-12,-12,3+3*ER(5),-3+3*ER(5),12,0,0,0,0,0,0,
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),0,0,0,0,-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
-3+3*ER(5),0,0,0,0,3+3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),-6,6],[6,0,6,
-3+3*ER(5),-3-3*ER(5),-6,3-3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),-6,0,3+3*ER(5),-12,12,
-3+3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),0,-6,-3+3*ER(5),-3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),6,0,-3-3*ER(5),12,-12,
3-3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),0,0,0,0,0,0,-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),0,0,0,0,
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),0,0,0,0,3-3*ER(5),3+3*ER(5),
3-3*ER(5),3+3*ER(5),-6,6],[0,-15,0,0,0,0,0,0,15,15,0,0,0,0,-15,0,0,0,0,
0,0,0,0,0,-15,0,0,0,15,15,0,0,-15,0,0,0,0,0,0,0,0,0,-30,30,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,-15,0,0,0,0,0,0,15,
15,0,0,0,0,-15,0,0,0,0,0,0,0,0,0,-15,0,0,0,15,15,0,0,-15,0,0,0,0,0,0,0,
0,0,30,-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,10,10,0,0,0,10,10,-10,-10,-10,-10,0,10,0,0,0,0,0,0,0,0,0,0,0,0,
-10,-10,10,10,0,-10,0,0,0,0,0,0,0,0,0,0,-10,20,-20,10,0,0,0,0,0,0,0,0,
-10,20,10,-20,0,0,0,0,0,0,0,0,0,0,0,0,10,-10],[0,0,0,10,10,0,0,0,10,10,
-10,-10,-10,-10,0,10,0,0,0,0,0,0,0,0,0,0,0,0,-10,-10,10,10,0,-10,0,0,0,
0,0,0,0,0,0,0,20,-10,10,-20,0,0,0,0,0,0,0,0,20,-10,-20,10,0,0,0,0,0,0,0,
0,0,0,0,0,10,-10],[0,0,0,10,10,0,0,0,10,10,10,10,-10,-10,0,-10,0,0,0,0,
0,0,0,0,0,0,0,0,-10,-10,-10,-10,0,10,0,0,0,0,0,0,0,0,0,0,-20,10,-10,20,
0,0,0,0,0,0,0,0,20,-10,-20,10,0,0,0,0,0,0,0,0,0,0,0,0,-10,10],[0,0,0,10,
10,0,0,0,10,10,10,10,-10,-10,0,-10,0,0,0,0,0,0,0,0,0,0,0,0,-10,-10,-10,
-10,0,10,0,0,0,0,0,0,0,0,0,0,10,-20,20,-10,0,0,0,0,0,0,0,0,-10,20,10,
-20,0,0,0,0,0,0,0,0,0,0,0,0,-10,10],[-6,0,6,3-3*ER(5),3+3*ER(5),6,
3+3*ER(5),3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),6,0,-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,-6,-3-3*ER(5),-3+3*ER(5),
3-3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),-6,0,3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,0,0,0,
0,0,-3-3*ER(5),12,-12,3-3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),0,0,0,0,-12,
3-3*ER(5),3+3*ER(5),-12,0,0,0,0,-3-3*ER(5),12,12,-3+3*ER(5),-6,6],[-6,0,
6,3-3*ER(5),3+3*ER(5),6,3+3*ER(5),3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),0,-6,
-3-3*ER(5),-3+3*ER(5),3-3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),-6,0,
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),0,0,0,0,0,0,12,-3-3*ER(5),3-3*ER(5),-12,-12,
3+3*ER(5),-3+3*ER(5),12,0,0,0,0,3-3*ER(5),-12,-12,3+3*ER(5),0,0,0,0,12,
-3-3*ER(5),-3+3*ER(5),12,-6,6],[6,0,-6,-3-3*ER(5),-3+3*ER(5),-6,
-3+3*ER(5),-3-3*ER(5),3+3*ER(5),3-3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),
3+3*ER(5),-6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),
3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,6,3-3*ER(5),3+3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),6,0,-3-3*ER(5),-3+3*ER(5),3+3*ER(5),
3-3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,0,0,-12,
3-3*ER(5),-3-3*ER(5),12,12,-3+3*ER(5),3+3*ER(5),-12,0,0,0,0,-3-3*ER(5),
12,12,-3+3*ER(5),0,0,0,0,-12,3-3*ER(5),3+3*ER(5),-12,6,-6],[6,0,-6,
-3-3*ER(5),-3+3*ER(5),-6,-3+3*ER(5),-3-3*ER(5),3+3*ER(5),3-3*ER(5),
3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),0,6,
3-3*ER(5),3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),6,0,
-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),0,0,0,0,0,0,3-3*ER(5),-12,12,-3-3*ER(5),-3+3*ER(5),
12,-12,3+3*ER(5),0,0,0,0,12,-3-3*ER(5),-3+3*ER(5),12,0,0,0,0,3-3*ER(5),
-12,-12,3+3*ER(5),6,-6],[-6,0,-6,3-3*ER(5),3+3*ER(5),6,-3-3*ER(5),
-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),6,0,-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),
3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,6,3+3*ER(5),3-3*ER(5),3-3*ER(5),
3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,0,0,
3+3*ER(5),-12,12,-3+3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),0,0,0,0,-12,
3-3*ER(5),3+3*ER(5),-12,0,0,0,0,-3-3*ER(5),12,12,-3+3*ER(5),6,-6],[-6,0,
-6,3-3*ER(5),3+3*ER(5),6,-3-3*ER(5),-3+3*ER(5),-3+3*ER(5),-3-3*ER(5),
3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),6,0,-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),0,6,
3+3*ER(5),3-3*ER(5),3-3*ER(5),3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-6,0,
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),0,0,0,0,0,0,-12,3+3*ER(5),-3+3*ER(5),12,12,
-3-3*ER(5),3-3*ER(5),-12,0,0,0,0,3-3*ER(5),-12,-12,3+3*ER(5),0,0,0,0,12,
-3-3*ER(5),-3+3*ER(5),12,6,-6],[6,0,6,-3-3*ER(5),-3+3*ER(5),-6,
3-3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),
3+3*ER(5),-6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,-6,-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),3-3*ER(5),3+3*ER(5),6,0,-3-3*ER(5),-3+3*ER(5),3+3*ER(5),
3-3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,0,0,0,0,0,12,
-3+3*ER(5),3+3*ER(5),-12,-12,3-3*ER(5),-3-3*ER(5),12,0,0,0,0,-3-3*ER(5),
12,12,-3+3*ER(5),0,0,0,0,-12,3-3*ER(5),3+3*ER(5),-12,-6,6],[6,0,6,
-3-3*ER(5),-3+3*ER(5),-6,3-3*ER(5),3+3*ER(5),3+3*ER(5),3-3*ER(5),
-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-6,0,3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),0,-6,
-3+3*ER(5),-3-3*ER(5),-3-3*ER(5),-3+3*ER(5),3-3*ER(5),3+3*ER(5),6,0,
-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),0,0,0,0,0,0,-3+3*ER(5),12,-12,3+3*ER(5),3-3*ER(5),
-12,12,-3-3*ER(5),0,0,0,0,12,-3-3*ER(5),-3+3*ER(5),12,0,0,0,0,3-3*ER(5),
-12,-12,3+3*ER(5),-6,6],[0,0,0,-2*ER(5),2*ER(5),0,0,0,2*ER(5),-2*ER(5),
-10,-10,2*ER(5),-2*ER(5),0,10,0,0,0,0,0,0,0,0,0,0,0,0,2*ER(5),-2*ER(5),
-10,-10,0,10,0,0,0,0,0,0,0,0,0,0,-10,20,20,-10,0,0,0,0,0,0,0,0,-2*ER(5),
4*ER(5),-2*ER(5),4*ER(5),4*ER(5),4*ER(5),-4*ER(5),-4*ER(5),-4*ER(5),
8*ER(5),-4*ER(5),8*ER(5),-4*ER(5),-4*ER(5),4*ER(5),4*ER(5),-10,-10],[0,
0,0,-2*ER(5),2*ER(5),0,0,0,2*ER(5),-2*ER(5),-10,-10,2*ER(5),-2*ER(5),0,
10,0,0,0,0,0,0,0,0,0,0,0,0,2*ER(5),-2*ER(5),-10,-10,0,10,0,0,0,0,0,0,0,
0,0,0,20,-10,-10,20,0,0,0,0,0,0,0,0,4*ER(5),-2*ER(5),4*ER(5),-2*ER(5),
4*ER(5),4*ER(5),-4*ER(5),-4*ER(5),8*ER(5),-4*ER(5),8*ER(5),-4*ER(5),
-4*ER(5),-4*ER(5),4*ER(5),4*ER(5),-10,-10],[0,0,0,-2*ER(5),2*ER(5),0,0,
0,2*ER(5),-2*ER(5),10,10,2*ER(5),-2*ER(5),0,-10,0,0,0,0,0,0,0,0,0,0,0,0,
2*ER(5),-2*ER(5),10,10,0,-10,0,0,0,0,0,0,0,0,0,0,10,-20,-20,10,0,0,0,0,
0,0,0,0,-2*ER(5),4*ER(5),-2*ER(5),4*ER(5),4*ER(5),4*ER(5),-4*ER(5),
-4*ER(5),-4*ER(5),8*ER(5),-4*ER(5),8*ER(5),-4*ER(5),-4*ER(5),4*ER(5),
4*ER(5),10,10],[0,0,0,-2*ER(5),2*ER(5),0,0,0,2*ER(5),-2*ER(5),10,10,
2*ER(5),-2*ER(5),0,-10,0,0,0,0,0,0,0,0,0,0,0,0,2*ER(5),-2*ER(5),10,10,0,
-10,0,0,0,0,0,0,0,0,0,0,-20,10,10,-20,0,0,0,0,0,0,0,0,4*ER(5),-2*ER(5),
4*ER(5),-2*ER(5),4*ER(5),4*ER(5),-4*ER(5),-4*ER(5),8*ER(5),-4*ER(5),
8*ER(5),-4*ER(5),-4*ER(5),-4*ER(5),4*ER(5),4*ER(5),10,10],[-6,0,-6,
-3+ER(5),-3-ER(5),-6,-3+3*ER(5),-3-3*ER(5),3-ER(5),3+ER(5),3-3*ER(5),
3+3*ER(5),-3-ER(5),-3+ER(5),6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,-6,-3+3*ER(5),
-3-3*ER(5),3-ER(5),3+ER(5),3-3*ER(5),3+3*ER(5),6,0,3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,0,0,0,
0,0,-12,3-3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),-3-3*ER(5),12,4*ER(5),
4*ER(5),4*ER(5),4*ER(5),7-ER(5),2+2*ER(5),2-2*ER(5),7+ER(5),-10-2*ER(5),
10-2*ER(5),10-2*ER(5),-10-2*ER(5),2-2*ER(5),7+ER(5),7-ER(5),2+2*ER(5),
-6,-6],[-6,0,-6,-3+ER(5),-3-ER(5),-6,-3+3*ER(5),-3-3*ER(5),3-ER(5),
3+ER(5),3-3*ER(5),3+3*ER(5),-3-ER(5),-3+ER(5),6,0,3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),0,-6,
-3+3*ER(5),-3-3*ER(5),3-ER(5),3+ER(5),3-3*ER(5),3+3*ER(5),6,0,3-3*ER(5),
3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),-3+3*ER(5),
-3-3*ER(5),0,0,0,0,0,0,3-3*ER(5),-12,12,-3-3*ER(5),3-3*ER(5),-12,12,
-3-3*ER(5),4*ER(5),4*ER(5),4*ER(5),4*ER(5),2+2*ER(5),7-ER(5),7+ER(5),
2-2*ER(5),10-2*ER(5),-10-2*ER(5),-10-2*ER(5),10-2*ER(5),7+ER(5),
2-2*ER(5),2+2*ER(5),7-ER(5),-6,-6],[-6,0,-6,-3-ER(5),-3+ER(5),-6,
-3-3*ER(5),-3+3*ER(5),3+ER(5),3-ER(5),3+3*ER(5),3-3*ER(5),-3+ER(5),
-3-ER(5),6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),
3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,-6,-3-3*ER(5),-3+3*ER(5),3+ER(5),
3-ER(5),3+3*ER(5),3-3*ER(5),6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),0,0,0,0,0,0,
3+3*ER(5),-12,12,-3+3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),-4*ER(5),
-4*ER(5),-4*ER(5),-4*ER(5),2-2*ER(5),7+ER(5),7-ER(5),2+2*ER(5),
10+2*ER(5),-10+2*ER(5),-10+2*ER(5),10+2*ER(5),7-ER(5),2+2*ER(5),
2-2*ER(5),7+ER(5),-6,-6],[-6,0,-6,-3-ER(5),-3+ER(5),-6,-3-3*ER(5),
-3+3*ER(5),3+ER(5),3-ER(5),3+3*ER(5),3-3*ER(5),-3+ER(5),-3-ER(5),6,0,
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),0,-6,-3-3*ER(5),-3+3*ER(5),3+ER(5),3-ER(5),
3+3*ER(5),3-3*ER(5),6,0,3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),0,0,0,0,0,0,-12,3+3*ER(5),
-3+3*ER(5),12,-12,3+3*ER(5),-3+3*ER(5),12,-4*ER(5),-4*ER(5),-4*ER(5),
-4*ER(5),7+ER(5),2-2*ER(5),2+2*ER(5),7-ER(5),-10+2*ER(5),10+2*ER(5),
10+2*ER(5),-10+2*ER(5),2+2*ER(5),7-ER(5),7+ER(5),2-2*ER(5),-6,-6],[0,0,
0,-4*ER(5),4*ER(5),0,0,0,4*ER(5),-4*ER(5),0,0,4*ER(5),-4*ER(5),0,0,0,0,
0,0,0,0,0,0,0,0,0,0,4*ER(5),-4*ER(5),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,-4*ER(5),8*ER(5),-4*ER(5),8*ER(5),-10-2*ER(5),
10-2*ER(5),10+2*ER(5),-10+2*ER(5),10+2*ER(5),20-4*ER(5),-10+2*ER(5),
-20-4*ER(5),10+2*ER(5),-10+2*ER(5),-10-2*ER(5),10-2*ER(5),0,0],[0,0,0,
-4*ER(5),4*ER(5),0,0,0,4*ER(5),-4*ER(5),0,0,4*ER(5),-4*ER(5),0,0,0,0,0,
0,0,0,0,0,0,0,0,0,4*ER(5),-4*ER(5),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,8*ER(5),-4*ER(5),8*ER(5),-4*ER(5),10-2*ER(5),
-10-2*ER(5),-10+2*ER(5),10+2*ER(5),20-4*ER(5),10+2*ER(5),-20-4*ER(5),
-10+2*ER(5),-10+2*ER(5),10+2*ER(5),10-2*ER(5),-10-2*ER(5),0,0],[0,0,0,
-4*ER(5),4*ER(5),0,0,0,4*ER(5),-4*ER(5),0,0,4*ER(5),-4*ER(5),0,0,0,0,0,
0,0,0,0,0,0,0,0,0,4*ER(5),-4*ER(5),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,-4*ER(5),8*ER(5),-4*ER(5),8*ER(5),10-2*ER(5),
-10-2*ER(5),-10+2*ER(5),10+2*ER(5),-10+2*ER(5),-20-4*ER(5),10+2*ER(5),
20-4*ER(5),-10+2*ER(5),10+2*ER(5),10-2*ER(5),-10-2*ER(5),0,0],[0,0,0,
-4*ER(5),4*ER(5),0,0,0,4*ER(5),-4*ER(5),0,0,4*ER(5),-4*ER(5),0,0,0,0,0,
0,0,0,0,0,0,0,0,0,4*ER(5),-4*ER(5),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,8*ER(5),-4*ER(5),8*ER(5),-4*ER(5),-10-2*ER(5),
10-2*ER(5),10+2*ER(5),-10+2*ER(5),-20-4*ER(5),-10+2*ER(5),20-4*ER(5),
10+2*ER(5),10+2*ER(5),-10+2*ER(5),-10-2*ER(5),10-2*ER(5),0,0],[-6,0,6,
-3-ER(5),-3+ER(5),-6,3+3*ER(5),3-3*ER(5),3+ER(5),3-ER(5),-3-3*ER(5),
-3+3*ER(5),-3+ER(5),-3-ER(5),6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,6,3+3*ER(5),
3-3*ER(5),3+ER(5),3-ER(5),-3-3*ER(5),-3+3*ER(5),6,0,3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,
0,0,-3-3*ER(5),12,-12,3-3*ER(5),-3-3*ER(5),12,-12,3-3*ER(5),-4*ER(5),
-4*ER(5),-4*ER(5),-4*ER(5),2-2*ER(5),7+ER(5),7-ER(5),2+2*ER(5),
10+2*ER(5),-10+2*ER(5),-10+2*ER(5),10+2*ER(5),7-ER(5),2+2*ER(5),
2-2*ER(5),7+ER(5),6,6],[-6,0,6,-3-ER(5),-3+ER(5),-6,3+3*ER(5),3-3*ER(5),
3+ER(5),3-ER(5),-3-3*ER(5),-3+3*ER(5),-3+ER(5),-3-ER(5),6,0,3-3*ER(5),
3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),
3+3*ER(5),0,6,3+3*ER(5),3-3*ER(5),3+ER(5),3-ER(5),-3-3*ER(5),-3+3*ER(5),
6,0,3-3*ER(5),3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),
3-3*ER(5),3+3*ER(5),0,0,0,0,0,0,12,-3-3*ER(5),3-3*ER(5),-12,12,
-3-3*ER(5),3-3*ER(5),-12,-4*ER(5),-4*ER(5),-4*ER(5),-4*ER(5),7+ER(5),
2-2*ER(5),2+2*ER(5),7-ER(5),-10+2*ER(5),10+2*ER(5),10+2*ER(5),
-10+2*ER(5),2+2*ER(5),7-ER(5),7+ER(5),2-2*ER(5),6,6],[-6,0,6,-3+ER(5),
-3-ER(5),-6,3-3*ER(5),3+3*ER(5),3-ER(5),3+ER(5),-3+3*ER(5),-3-3*ER(5),
-3-ER(5),-3+ER(5),6,0,3+3*ER(5),3-3*ER(5),-3-3*ER(5),-3+3*ER(5),
-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,6,3-3*ER(5),3+3*ER(5),
3-ER(5),3+ER(5),-3+3*ER(5),-3-3*ER(5),6,0,3+3*ER(5),3-3*ER(5),
-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),3+3*ER(5),3-3*ER(5),0,0,0,0,
0,0,12,-3+3*ER(5),3+3*ER(5),-12,12,-3+3*ER(5),3+3*ER(5),-12,4*ER(5),
4*ER(5),4*ER(5),4*ER(5),7-ER(5),2+2*ER(5),2-2*ER(5),7+ER(5),-10-2*ER(5),
10-2*ER(5),10-2*ER(5),-10-2*ER(5),2-2*ER(5),7+ER(5),7-ER(5),2+2*ER(5),6,
6],[-6,0,6,-3+ER(5),-3-ER(5),-6,3-3*ER(5),3+3*ER(5),3-ER(5),3+ER(5),
-3+3*ER(5),-3-3*ER(5),-3-ER(5),-3+ER(5),6,0,3-3*ER(5),3+3*ER(5),
-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),3+3*ER(5),0,6,
3-3*ER(5),3+3*ER(5),3-ER(5),3+ER(5),-3+3*ER(5),-3-3*ER(5),6,0,3-3*ER(5),
3+3*ER(5),-3+3*ER(5),-3-3*ER(5),-3+3*ER(5),-3-3*ER(5),3-3*ER(5),
3+3*ER(5),0,0,0,0,0,0,-3+3*ER(5),12,-12,3+3*ER(5),-3+3*ER(5),12,-12,
3+3*ER(5),4*ER(5),4*ER(5),4*ER(5),4*ER(5),2+2*ER(5),7-ER(5),7+ER(5),
2-2*ER(5),10-2*ER(5),-10-2*ER(5),-10-2*ER(5),10-2*ER(5),7+ER(5),
2-2*ER(5),2+2*ER(5),7-ER(5),6,6],[12,15,12,4,4,-12,6,6,1,1,4,4,-4,-4,3,
-10,6,6,-6,-6,-6,-6,6,6,-15,-12,-6,-6,-1,-1,-4,-4,-3,10,-6,-6,6,6,6,6,
-6,-6,0,0,10,10,-10,-10,-6,-6,6,6,6,6,-6,-6,-10,-10,10,10,-6,-6,-6,-6,0,
0,0,0,6,6,6,6,8,-8],[12,15,-12,4,4,-12,-6,-6,1,1,-4,-4,-4,-4,3,10,6,6,
-6,-6,6,6,-6,-6,-15,12,6,6,-1,-1,4,4,-3,-10,-6,-6,6,6,-6,-6,6,6,0,0,-10,
-10,10,10,6,6,-6,-6,-6,-6,6,6,-10,-10,10,10,-6,-6,-6,-6,0,0,0,0,6,6,6,6,
-8,8]],
eigenvalues:= [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, E(5)^3, E(5)^2,
E(5)^3, E(5)^2, E(5)^3, E(5)^2, E(5)^3, E(5)^2, 1, -1, -1, -1, 1, 1, -1, -1,
1, -1, E(5)^3, E(5)^2, E(5)^3, E(5)^2, -E(5)^3, -E(5)^2, -E(5)^3, -E(5)^2,
E(4), -E(4), E(3), E(3)^2, -E(3)^2, -E(3), E(5)^4, E(5), E(5)^4, E(5),
-E(5)^4, -E(5), -E(5)^4, -E(5), E(3), E(3)^2, E(3), E(3)^2, E(5)^4, E(5),
E(5)^4, E(5), E(15)^2, E(15)^13, E(15)^8, E(15)^7, E(5)^4, E(5),
	  E(5)^4, E(5), -1, 1 ],
perm:=(17,18)(19,20)(21,22)(23,24)(35,36)(37,38)(39,40)(41,42)(43,44)(45,46)
(47,48)(49,50)(51,52)(53,54)(55,56)(57,58)(59,60)(61,62)(63,64)(65,66)(67,68)
(69,70)(71,72),
special:=9
);

CHEVIE.AddData("UnipotentCharacters","H4",function()local cuspidal;
  cuspidal:=function(arg)local res,n; n:="H_4";
    if Length(arg)>2 then PrintToString(n,"^",arg[3]);fi;
    PrintToString(n,"[",FormatTeX(arg[2]),"]");
    res:=rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..4], parameterExponents:=[],
        charNumbers:=[arg[1]], eigenvalue:=arg[2], cuspidalName:=n);
    return res;
  end;
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="H",indices:=[ 1 .. 4 ],rank:=4),
      levi:=[], eigenvalue:=1, parameterExponents:=[1,1,1,1], cuspidalName:="",
      charNumbers:=[ 1 .. 34 ]),
    rec(relativeType:=rec(series:="I",indices:=[ 4, 3 ],rank:=2, bond:=10 ),
      levi:=[ 1 .. 2 ], eigenvalue:=E(5)^3,
      parameterExponents:=[ 1, 5 ], cuspidalName:="I_2(5)[1,2]",
      charNumbers:=[ 35, 44, 37, 45, 47, 53, 49, 51 ]),
    rec(relativeType:=rec(series:="I",indices:=[ 4, 3 ],rank:=2, bond:=10 ),
      levi:=[ 1 .. 2 ], eigenvalue:=E(5)^2,
      parameterExponents:=[ 1, 5 ], cuspidalName:="I_2(5)[1,3]",
      charNumbers:=[ 36, 43, 38, 46, 48, 54, 50, 52 ]),
    rec(relativeType:=rec(series:="A",indices:=[ 4 ],rank:=1),
      levi:=[ 1 .. 3 ], eigenvalue:=E(4),
      parameterExponents:=[ 15 ], cuspidalName:="H_3[i]",
      charNumbers:=[ 41, 39 ],qEigen:=1/2),
    rec(relativeType:=rec(series:="A",indices:=[ 4 ],rank:=1),
      levi:=[ 1 .. 3 ], eigenvalue:=-E(4),
      parameterExponents:=[ 15 ], cuspidalName:="H_3[-i]",
      charNumbers:=[ 42, 40 ],qEigen:=1/2),
    cuspidal(55,1), cuspidal(56,-1), cuspidal(57,-1,2), cuspidal(58,-1,3),
    cuspidal(59,1,2), cuspidal(60,1,3), cuspidal(61,-1,4), cuspidal(62,-1,5),
    cuspidal(63,1,4), cuspidal(64,-1,6), cuspidal(65,E(5)^3),
    cuspidal(66,E(5)^2), cuspidal(67,E(5)^3,2), cuspidal(68,E(5)^2,2),
    cuspidal(69,-E(5)^3), cuspidal(70,-E(5)^2), cuspidal(71,-E(5)^3,2),
    cuspidal(72,-E(5)^2,2), cuspidal(73,E(4)), cuspidal(74,-E(4)),
    cuspidal(75,E(3)), cuspidal(76,E(3)^2), cuspidal(77,-E(3)^2),
    cuspidal(78,-E(3)), cuspidal(79,E(5)^4), cuspidal(80,E(5)),
    cuspidal(81,E(5)^4,2), cuspidal(82,E(5),2), cuspidal(83,-E(5)^4),
    cuspidal(84,-E(5)), cuspidal(85,-E(5)^4,2), cuspidal(86,-E(5),2),
    cuspidal(87,E(3),2), cuspidal(88,E(3)^2,2), cuspidal(89,E(3),3) , 
    cuspidal(90,E(3)^2,3), cuspidal(91,E(5)^4,3), cuspidal(92,E(5),3),
    cuspidal(93,E(5)^4,4), cuspidal(94,E(5),4), cuspidal(95,E(15)^2),
    cuspidal(96,E(15)^13), cuspidal(97,E(15)^8), cuspidal(98,E(15)^7),
    cuspidal(99,E(5)^4,5), cuspidal(100,E(5),5), cuspidal(101,E(5)^4,6),
    cuspidal(102,E(5),6), cuspidal(103,-1,7), cuspidal(104,1,5)],
  families:=[
    Family("C1",[ 1 ]),
    Family("C1",[ 2 ]),
    Family("C1",[ 27 ]),
    Family("C1",[ 28 ]),
    Family("C1",[ 31 ]),
    Family("C1",[ 32 ]),
    Family("C'#2",[ 3, 5, 35, 36 ]),
    Family("C'#2",[ 11, 13, 37, 38 ]),
    Family("C'#2",[ 12, 14, 44, 43 ]),
    Family("C'#2",[ 4, 6, 45, 46 ]),
    Family("C'\"2",[ 18, 20, 39, 40 ]),
    Family("C'\"2",[ 21, 19, 41, 42 ]),
    Family("HS4",
[ 15, 9, 10, 7, 8, 22, 16, 17, 26, 25, 24, 23, 29, 30, 33, 34, 47, 48, 49,
  50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
  69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
  88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104 ])],
  a:=[ 0, 60, 1, 31, 1, 31, 6, 6, 6, 6, 2, 22, 2, 22, 6, 6, 6, 3, 18, 3, 18,
  6, 6, 6, 6, 6, 4, 16, 6, 6, 5, 15, 6, 6, 1, 1, 2, 2, 3, 3, 18, 18, 22, 22,
  31, 31, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 ],
  A:=[ 0, 60, 29, 59, 29, 59, 54, 54, 54, 54, 38, 58, 38, 58, 54, 54, 54, 42,
  57, 42, 57, 54, 54, 54, 54, 54, 44, 56, 54, 54, 45, 55, 54, 54, 29, 29, 38,
  38, 42, 42, 57, 57, 58, 58, 59, 59, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
  54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
  54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
  54, 54, 54, 54, 54, 54, 54, 54, 54, 54 ]);
end);

CHEVIE.AddData("Invariants","H4",function()local r;
 r:=CoxeterGroup("H",4).roots{[1..60]}*CartanMat("H",4); 
 return List(CHEVIE.RawData("ReflectionDegrees","H4"),
   d-> function(arg) return Sum(r,a->(arg*a)^d);end);
end);

CHEVIE.AddData("KLeftCellRepresentatives","H4",
[rec(character:=[1], duflo:=[1,2,3,4], reps:=""),
 rec(character:=[2], duflo:=[61,62,63,64], reps:=""),
 rec(character:=[5,3], duflo:=[1,2,8,64], reps:=[[16,2,3,87]]),
 rec(character:=[6,4], duflo:=[1,66,63,64], reps:=[[9,65,71,64]]),
 rec(character:=[13,11], duflo:=[2,1,27,103], reps:=[[3,20,1,110]]),
 rec(character:=[14,12], duflo:=[1,66,68,4], reps:=[[9,65,76,4]]),
 rec(character:=[20,18], duflo:=[1,2,32,120], 
  reps:=[[23,3,2,116],[24,23,112,2],[33,1,110,32]]),rec(character:=[20,18],
duflo:=[19,85,10,20],
reps:=[[12,6,10,109],[13,20,97,6],[19,12,80,70]]),rec(character:=[21,19],
duflo:=[10,63,62,94],
reps:=[[15,62,73,83],[15,77,13,94],[21,85,5,83]]),rec(character:=[21,19],
duflo:=[19,85,10,88],
reps:=[[13,81,6,76],[17,67,69,88],[19,69,70,76]]),rec(character:=[27],
duflo:=[2,1,24,119],
reps:=[[1,35,120,39],[38,2,116,24]]),rec(character:=[27],
duflo:=[12,21,102,30],
reps:=[[1,12,25,119],[35,1,107,25]]),rec(character:=[27],
duflo:=[33,11,115,18],
reps:=[[2,30,74,100],[2,30,114,40]]),rec(character:=[28],
duflo:=[1,76,4,3],
reps:=[[27,72,73,86],[28,92,14,86]]),rec(character:=[28],
duflo:=[36,117,54,74],
reps:=[[24,102,21,18],[46,110,34,100]]),rec(character:=[28],
duflo:=[40,102,30,96],
reps:=[[19,94,16,10],[32,68,77,96]]),rec(character:=[31],
duflo:=[1,2,3,100],
reps:=[[2,28,119,44],[3,39,117,1],[31,1,107,3]]),rec(character:=[31],
duflo:=[1,31,119,46],
reps:=[[1,31,85,106],[15,30,114,12],[34,12,116,15]]),rec(character:=[31],
duflo:=[1,35,106,4],
reps:=[[4,17,1,117],[17,16,115,48],[40,4,110,1]]),rec(character:=[31],
duflo:=[34,107,3,52],
reps:=[[3,39,116,12],[6,24,73,112],[6,24,119,52]]),rec(character:=[32],
duflo:=[2,1,79,64],
reps:=[[25,97,20,1],[26,64,71,101],[34,96,29,101]]),rec(character:=[32],
duflo:=[27,106,26,13],
reps:=[[4,13,92,66],[34,66,70,103],[42,107,36,103]]),rec(character:=[32],
duflo:=[31,62,63,113],
reps:=[[23,10,107,62],[38,117,39,10],[42,105,41,113]]),rec(character:=[32],
duflo:=[45,109,44,110],
reps:=[[16,17,102,69],[32,115,36,17],[37,69,67,110]]),rec(character:=[34,34,
33,30,29,26,25,24,23,22,10,9],
duflo:=[14,64,63,62],
reps:=[[5,28,100,86],[5,28,117,26],[5,32,105,64],[10,26,90,101],[10,26,120,
41],[13,29,110,75],[13,29,118,15],[15,30,102,89],[15,30,120,29],[16,15,111,
13],[16,31,112,63],[17,16,88,99],[17,16,117,39],[17,18,92,80],[17,18,108,20],
[18,15,80,102],[18,15,116,42],[20,13,77,110],[20,13,119,50],[24,63,62,78],[24,
63,82,18],[26,17,101,88],[26,17,119,28],[28,20,103,77],[28,20,116,17],[29,10,
91,90],[29,10,114,30],[30,5,89,100],[30,5,118,40],[33,62,78,70],[33,62,92,10],
[36,104,5,13],[37,75,98,13],[37,111,13,26],[41,75,64,102],[41,75,106,42],[42,
63,113,16],[42,115,16,41],[43,64,109,5],[43,112,5,42],[45,70,80,90],[45,70,
103,30],[46,78,70,80],[46,78,91,20],[47,88,99,26],[47,117,26,15],[49,77,110,
28],[49,119,28,29],[50,86,63,101],[50,86,105,41],[52,80,102,17],[53,89,100,
15],[53,118,15,28],[55,90,101,29]]),rec(character:=[34,34,33,30,29,26,25,24,
23,22,10,9],
duflo:=[31,62,92,14],
reps:=[[4,21,104,5],[4,40,115,62],[5,30,103,81],[5,30,117,21],[11,20,97,78],
[11,20,113,18],[11,33,109,68],[14,21,88,101],[14,21,119,41],[15,18,82,107],
[15,18,120,47],[18,25,107,80],[18,25,118,20],[20,28,106,85],[20,28,119,25],
[21,22,101,90],[21,22,120,30],[22,11,90,97],[22,11,117,37],[25,4,80,98],[25,4,
113,38],[25,14,93,88],[25,14,114,28],[26,96,11,5],[27,68,62,73],[28,5,85,103],
[28,5,118,43],[30,15,100,82],[30,15,116,22],[31,62,73,74],[34,81,89,5],[34,
104,5,18],[39,80,98,18],[39,113,18,21],[41,62,110,4],[41,112,4,47],[42,73,74,
75],[42,73,93,15],[43,78,62,107],[43,78,109,47],[46,68,111,11],[46,115,11,41],
[47,81,68,101],[47,81,108,41],[48,74,75,88],[48,74,100,28],[49,75,88,82],[49,
75,106,22],[50,90,97,21],[50,117,21,20],[51,85,103,20],[51,118,20,30],[52,82,
107,30],[55,88,101,25]]),rec(character:=[34,34,33,33,30,29,26,25,24,23,22,17,
16,15],
duflo:=[19,97,52,86],
reps:=[[1,12,64,102],[1,12,106,42],[1,35,106,85],[1,35,119,25],[7,1,88,8],[7,
36,111,74],[7,36,120,14],[8,25,107,1],[12,21,77,110],[12,21,119,50],[14,25,91,
96],[14,25,118,36],[16,7,87,81],[16,7,102,21],[16,31,108,79],[16,31,118,19],
[17,16,94,87],[17,16,115,27],[17,26,104,72],[18,17,95,94],[18,17,119,34],[19,
8,76,105],[19,8,115,45],[19,14,86,91],[21,14,114,7],[25,18,96,95],[25,18,120,
35],[26,7,72,111],[26,7,116,51],[27,19,109,76],[27,19,117,16],[31,1,79,106],
[31,1,117,46],[32,102,17,1],[34,12,103,77],[35,1,107,64],[38,76,105,27],[38,
115,27,25],[40,85,90,1],[40,107,1,27],[41,75,74,66],[43,74,66,91],[43,74,97,
31],[44,66,91,78],[44,66,108,18],[45,77,74,94],[45,77,110,34],[45,119,34,14],
[46,74,100,7],[46,114,7,34],[48,72,111,17],[48,116,17,36],[49,85,72,96],[49,
85,103,36],[50,78,79,95],[50,78,109,35],[51,79,106,16],[51,117,16,35],[54,95,
94,25],[56,91,96,19],[57,96,95,14]]),rec(character:=[34,34,33,33,30,30,29,29,
26,25,24,23,17,16,8,7],
duflo:=[1,35,102,64],
reps:=[[1,7,63,97],[1,7,100,37],[1,31,100,89],[1,31,118,29],[2,16,64,111],[2,
16,113,51],[2,38,113,70],[2,38,119,10],[7,23,80,107],[7,23,118,47],[10,29,93,
98],[10,29,120,38],[11,2,77,83],[11,2,97,23],[11,33,105,86],[11,33,120,26],
[13,20,91,96],[13,20,118,36],[13,22,95,76],[16,17,73,112],[16,17,119,52],[17,
26,112,71],[17,26,117,11],[20,11,96,77],[20,11,111,17],[20,28,110,67],[22,11,
76,105],[22,11,115,45],[23,10,109,2],[26,10,88,93],[26,10,114,33],[28,2,67,
113],[28,2,116,53],[29,13,98,91],[29,13,119,31],[31,1,104,63],[31,16,103,73],
[33,1,86,100],[33,1,117,40],[34,71,101,17],[34,111,17,29],[36,7,102,80],[38,2,
109,64],[38,71,64,105],[38,71,108,45],[39,104,1,17],[40,70,99,2],[40,109,2,
36],[41,80,70,96],[41,80,107,36],[41,118,36,10],[42,70,76,93],[42,70,103,33],
[43,64,107,1],[43,110,1,45],[45,67,113,20],[45,116,20,38],[47,73,86,91],[47,
73,112,31],[47,119,31,26],[48,82,70,76],[49,91,96,29],[50,76,105,13],[52,89,
67,98],[52,89,102,38],[53,86,100,11],[53,117,11,31],[56,93,98,26],[57,98,91,
10]])]);
