#############################################################################
##
#A  tbl/cmplxg34.g       CHEVIE library          Gunter Malle and Jean Michel
##
#Y  Copyright (C) 1998 - 2001  The CHEVIE Team
##
##  This file contains data about the complex reflection group
##  of type G34 in the Shephard-Todd classification.
##
CHEVIE.Revision("tbl/cmplxg34.g",
   "$Id: cmplxg34.g,v 1.3 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("PrintDiagram","G34",function(indices,title)local s;
  Print(title," ");s:=String("",Length(title)-5);
  Print(s,"  ",indices[3],"\n       /^\\\n",
	s,indices[1],"---",indices[2],"---",indices[4],
	"---",indices[5],"---",indices[6]," ",
	IntListToString(indices{[4,2,3,4,2,3]}),"=",
	IntListToString(indices{[3,4,2,3,4,2]}),"\n");
end);

CHEVIE.AddData("BraidRelations","G34",
  [[[1,2,1],[2,1,2]],[[3,2,3],[2,3,2]],[[4,2,4],[2,4,2]],[[4,3,4],[3,4,3]],
   [[4,5,4],[5,4,5]],[[1,3],[3,1]],[[1,4],[4,1]],[[1,5],[5,1]],[[2,5],[5,2]],
   [[3,5],[5,3]],[[5,6,5],[6,5,6]],[[1,6],[6,1]],[[2,6],[6,2]],[[3,6],[6,3]],
   [[4,6],[6,4]],[[4,2,3,4,2,3],[3,4,2,3,4,2]]]);

# with the following choice of simple roots (of norm 6)
# the set of all 756 roots are the short vectors of the Coxeter-Todd lattice
# See Conway & Sloane Math.Proc.Camb.Phil.Soc. 93(1983) 421--440
CHEVIE.AddData("GeneratingRoots","G34",
  [[ER(-3),-ER(-3),0,0,0,0],[0,ER(-3),0,0,0,-ER(-3)],[0,0,0,0,-ER(-3),ER(-3)],
  [0,0,0,0,(3+ER(-3))/2,(3-ER(-3))/2],[-1,-1,-E(3),-E(3)^2,-1,-1],
  [0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,0,0]]);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G34",
  [1/2,1/2,1/2,1/2,1/2,1/2]);

CHEVIE.AddData("Size","G34", 39191040);

CHEVIE.AddData("ReflectionDegrees","G34",[6,12,18,24,30,42]);

CHEVIE.AddData("NrConjugacyClasses","G34", 169);

CHEVIE.AddData("ParabolicRepresentatives","G34",# repr. of conj. classes
[[],[1],[1,2],[1,3],[1..3],[1,3,4],[1,3,5],[1..4],[2..4],[1,2,3,348],[1,3,5,6],
[1,2,3,5],[2,3,4,6],[2,4,5,6],[1,2,5,6],[1..5],[1,3,4,5,6],[1,2,4,5,107],
[1,2,3,4,6],[1,2,3,5,6],[1,2,4,5,6],[1,2,3,481,180],[2..6],[1..6]]);

CHEVIE.AddData("ClassNames","G34",
[".","1","21","31","521","321","342","531","432","6432","6521","5421","3421",
"4321","5321","6342","6431","65431","64321","65342","54321","65432","53421",
"65321","65421","63421","342342","c","532421","423121","ccccc","432432",
"6532421","5423121","6342342","6345242","6432432","6452432","6423121",
"3423421","6542321","4324321","5423421","4524321","65432432","65342342",
"1245zzzzz","1245z","63423421","63452421","53423421","64324321","54324321",
"65423121","64534321","13456z","4534321zz","453423121","5645432432","cc",
"4523423121","3245324121","cccc","5645342342","4524123121","52431243z",
"5432412zzzz","13456zz","56454324321","4534321z","12356zzz","56453423421",
"5432412z","423124123121","ccc","1243zzzzz","12356zzzzz","4321cc",
"542135421354213","1243z","34523412zz","1235zz","54213zz","54321z","1326cccc",
"1245zz","345243124532412zz","z","1234z","31z","5342312432z","321z","531z",
"6521z","23452412345241","6342z","6431z","64321z","342342z","432432z",
"3423421z","6342342z","6432432z","3245124324524","63423421z","65342342z",
"5645342342z","1z","423124123121z","234z","12z","54321zzzz","156z",
"542135421354213z","34523412zzz","54321zz","1245zzz","34523412z","cccccc",
"1235z","345243124532412","zz","5342312432zz","31zz","321zz","531zz","6432zz",
"64321zz","5432412zz","342342zz","6342342zz","3423421zz","65342342zz","1zz",
"12zz","156zz","542135421354213zz","1243zz","1245zzzz","345243124532412z",
"zzz","1542135421354213542135421354213542135421354213","5342312432zzz",
"321zzz","32451243245124","5432412zzz","342342zzz","512431245431243",
"3423421zzz","65342342zzz","542135421354213542135421354213542135421354213",
"12zzz","53242312454231241","1243zzz","zzzz","5342312432zzzz","31zzzz",
"12356z","1zzzz","12zzzz","53242312454231241z","123zzzz","zzzzz",
"5342312432zzzzz","31zzzzz","1zzzzz","12zzzzz","53242312454231241zz",
"123zzzzz"]);

CHEVIE.AddData("WordsClassRepresentatives","G34",
 List(CHEVIE.RawData("ClassNames","G34"),x->Replace(x,".",[],"1",[1],
   "2",[2],"3",[3],"4",[4],"5",[5],"6",[6],"z","ccccccc","c",[6,5,3,4,2,1])));

CHEVIE.AddData("PowerMaps","G34",
  [,[1,1,3,1,3,4,27,1,32,32,11,12,14,13,4,27,3,12,
      13,64,14,59,13,17,11, 14, 32, 60, 3, 74, 63, 27, 65, 12, 32, 45, 27, 46,
      74, 74, 11, 74, 95, 145, 46, 45, 139, 86, 74, 164, 95, 74, 145, 78, 91,
      86, 139, 74, 160, 63, 74, 74, 60, 135, 142, 96, 96, 139, 156, 86, 17,
      123, 96, 74, 119, 133, 64, 78, 27, 46, 96, 157, 133, 138, 143, 139, 90,
      122, 138, 122, 165, 124, 122, 11, 27, 130, 135, 46, 27, 130, 74, 27,
      130, 74, 74, 14, 160, 122, 74, 130, 135, 138, 135, 130, 95, 45, 12,
      145, 119, 124, 142, 155, 90, 155, 157, 155, 130, 133, 95, 130, 130, 74,
      138, 155, 160, 160, 32, 133, 86, 165, 1, 1, 142, 4, 32, 145, 32, 32,
      74, 45, 1, 3, 3, 13, 122, 165, 122, 59, 122, 135, 135, 124, 155, 90,
      155, 155, 160, 160, 157 ],
  [ 1, 2, 1, 4, 2, 6, 2, 8, 2, 4, 1, 12, 27, 32, 15, 4, 4, 18, 37, 6, 148, 6,
      79, 6, 8, 35, 1, 75, 142, 4, 75, 1, 33, 34, 2, 35, 2, 37, 8, 2, 8, 2,
      121, 121, 32, 27, 117, 117, 4, 85, 65, 4, 65, 100, 85, 34, 34, 151, 4,
      119, 142, 142, 119, 4, 65, 143, 121, 18, 33, 18, 144, 33, 121, 1, 75,
      99, 144, 130, 151, 99, 65, 15, 79, 35, 85, 12, 121, 141, 147, 142, 143,
      144, 8, 141, 142, 142, 142, 79, 141, 141, 151, 151, 151, 8, 142, 147,
      142, 151, 141, 151, 141, 148, 151, 2, 143, 148, 117, 143, 119, 15, 121,
      1, 65, 4, 6, 8, 4, 37, 121, 1, 2, 2, 27, 2, 1, 2, 151, 32, 12, 121,
      141, 142, 143, 144, 142, 121, 141, 151, 151, 147, 151, 141, 151, 99, 1,
      65, 4, 144, 2, 1, 2, 6, 141, 143, 142, 151, 141, 151, 144 ],,
  [ 1, 2, 3, 4, 5, 6, 9, 8, 7, 16, 11, 1, 14, 13, 15, 10, 17, 2, 26, 22, 23,
      20, 21, 24, 25, 19, 32, 31, 29, 30, 28, 27, 33, 151, 37, 38, 35, 36,
      39, 42, 41, 40, 44, 43, 46, 45, 88, 163, 52, 55, 53, 49, 51, 54, 50,
      166, 108, 58, 64, 63, 62, 61, 60, 59, 65, 66, 73, 159, 72, 134, 71, 69,
      67, 74, 75, 89, 158, 78, 148, 150, 81, 120, 112, 128, 85, 155, 140,
      163, 76, 165, 164, 169, 126, 94, 145, 96, 107, 116, 147, 100, 149, 137,
      110, 104, 105, 154, 97, 166, 109, 103, 167, 83, 168, 131, 118, 98, 141,
      115, 119, 82, 121, 155, 156, 157, 162, 93, 127, 84, 146, 130, 114, 132,
      138, 159, 160, 161, 102, 133, 122, 87, 141, 142, 143, 144, 95, 129, 99,
      79, 101, 80, 151, 152, 153, 106, 122, 123, 124, 77, 134, 135, 136, 125,
      88, 91, 90, 108, 111, 113, 92 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 88, 29, 30, 163, 32, 33, 34, 35, 36, 37,
      38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
      56, 57, 58, 59, 122, 61, 62, 155, 64, 65, 66, 67, 68, 69, 70, 71, 72,
      73, 74, 141, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
      90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105,
      106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 1,
      120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133,
      134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147,
      148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161,
      162, 163, 164, 165, 166, 167, 168, 169 ],,,,
  [ 1, 2, 3, 4, 5, 6, 9, 8, 7, 16, 11, 12, 14, 13, 15, 10, 17, 18, 26, 22,
      23, 20, 21, 24, 25, 19, 32, 31, 29, 30, 28, 27, 33, 34, 37, 38, 35, 36,
      39, 42, 41, 40, 44, 43, 46, 45, 48, 47, 52, 55, 53, 49, 51, 54, 50, 57,
      56, 58, 64, 63, 62, 61, 60, 59, 65, 66, 73, 70, 72, 68, 71, 69, 67, 74,
      75, 89, 158, 78, 148, 150, 81, 120, 112, 128, 85, 139, 140, 163, 76,
      165, 164, 169, 126, 94, 145, 96, 107, 116, 147, 100, 149, 137, 110,
      104, 105, 154, 97, 166, 109, 103, 167, 83, 168, 131, 118, 98, 117, 115,
      119, 82, 121, 155, 156, 157, 162, 93, 127, 84, 146, 130, 114, 132, 138,
      159, 160, 161, 102, 133, 86, 87, 141, 142, 143, 144, 95, 129, 99, 79,
      101, 80, 151, 152, 153, 106, 122, 123, 124, 77, 134, 135, 136, 125, 88,
      91, 90, 108, 111, 113, 92 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135,
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
      150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
      164, 165, 166, 167, 168, 169 ],,,,
  [ 1, 2, 3, 4, 5, 6, 9, 8, 7, 16, 11, 12, 14, 13, 15, 10, 17, 18, 26, 22,
      23, 20, 21, 24, 25, 19, 32, 31, 29, 30, 28, 27, 33, 34, 37, 38, 35, 36,
      39, 42, 41, 40, 44, 43, 46, 45, 48, 47, 52, 55, 53, 49, 51, 54, 50, 57,
      56, 58, 64, 63, 62, 61, 60, 59, 65, 66, 73, 70, 72, 68, 71, 69, 67, 74,
      75, 89, 158, 78, 148, 150, 81, 120, 112, 128, 85, 139, 140, 163, 76,
      165, 164, 169, 126, 94, 145, 96, 107, 116, 147, 100, 149, 137, 110,
      104, 105, 154, 97, 166, 109, 103, 167, 83, 168, 131, 118, 98, 117, 115,
      119, 82, 121, 155, 156, 157, 162, 93, 127, 84, 146, 130, 114, 132, 138,
      159, 160, 161, 102, 133, 86, 87, 141, 142, 143, 144, 95, 129, 99, 79,
      101, 80, 151, 152, 153, 106, 122, 123, 124, 77, 134, 135, 136, 125, 88,
      91, 90, 108, 111, 113, 92 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135,
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
      150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
      164, 165, 166, 167, 168, 169 ],,,,
  [ 1, 2, 3, 4, 5, 6, 9, 8, 7, 16, 11, 12, 14, 13, 15, 10, 17, 18, 26, 22,
      23, 20, 21, 24, 25, 19, 32, 31, 29, 30, 28, 27, 33, 34, 37, 38, 35, 36,
      39, 42, 41, 40, 44, 43, 46, 45, 48, 47, 52, 55, 53, 49, 51, 54, 50, 57,
      56, 58, 64, 63, 62, 61, 60, 59, 65, 66, 73, 70, 72, 68, 71, 69, 67, 74,
      75, 89, 158, 78, 148, 150, 81, 120, 112, 128, 85, 139, 140, 163, 76,
      165, 164, 169, 126, 94, 145, 96, 107, 116, 147, 100, 149, 137, 110,
      104, 105, 154, 97, 166, 109, 103, 167, 83, 168, 131, 118, 98, 117, 115,
      119, 82, 121, 155, 156, 157, 162, 93, 127, 84, 146, 130, 114, 132, 138,
      159, 160, 161, 102, 133, 86, 87, 141, 142, 143, 144, 95, 129, 99, 79,
      101, 80, 151, 152, 153, 106, 122, 123, 124, 77, 134, 135, 136, 125, 88,
      91, 90, 108, 111, 113, 92 ],,,,,,
  [ 1, 2, 3, 4, 5, 6, 9, 8, 7, 16, 11, 12, 14, 13, 15, 10, 17, 18, 26, 22,
      23, 20, 21, 24, 25, 19, 32, 31, 29, 30, 28, 27, 33, 34, 37, 38, 35, 36,
      39, 42, 41, 40, 44, 43, 46, 45, 48, 47, 52, 55, 53, 49, 51, 54, 50, 57,
      56, 58, 64, 63, 62, 61, 60, 59, 65, 66, 73, 70, 72, 68, 71, 69, 67, 74,
      75, 89, 158, 78, 148, 150, 81, 120, 112, 128, 85, 139, 140, 163, 76,
      165, 164, 169, 126, 94, 145, 96, 107, 116, 147, 100, 149, 137, 110,
      104, 105, 154, 97, 166, 109, 103, 167, 83, 168, 131, 118, 98, 117, 115,
      119, 82, 121, 155, 156, 157, 162, 93, 127, 84, 146, 130, 114, 132, 138,
      159, 160, 161, 102, 133, 86, 87, 141, 142, 143, 144, 95, 129, 99, 79,
      101, 80, 151, 152, 153, 106, 122, 123, 124, 77, 134, 135, 136, 125, 88,
      91, 90, 108, 111, 113, 92 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135,
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
      150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
      164, 165, 166, 167, 168, 169 ],,,,,,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135,
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
      150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
      164, 165, 166, 167, 168, 169 ],,,,
  [ 1, 2, 3, 4, 5, 6, 9, 8, 7, 16, 11, 12, 14, 13, 15, 10, 17, 18, 26, 22,
      23, 20, 21, 24, 25, 19, 32, 31, 29, 30, 28, 27, 33, 34, 37, 38, 35, 36,
      39, 42, 41, 40, 44, 43, 46, 45, 48, 47, 52, 55, 53, 49, 51, 54, 50, 57,
      56, 58, 64, 63, 62, 61, 60, 59, 65, 66, 73, 70, 72, 68, 71, 69, 67, 74,
      75, 89, 158, 78, 148, 150, 81, 120, 112, 128, 85, 139, 140, 163, 76,
      165, 164, 169, 126, 94, 145, 96, 107, 116, 147, 100, 149, 137, 110,
      104, 105, 154, 97, 166, 109, 103, 167, 83, 168, 131, 118, 98, 117, 115,
      119, 82, 121, 155, 156, 157, 162, 93, 127, 84, 146, 130, 114, 132, 138,
      159, 160, 161, 102, 133, 86, 87, 141, 142, 143, 144, 95, 129, 99, 79,
      101, 80, 151, 152, 153, 106, 122, 123, 124, 77, 134, 135, 136, 125, 88,
      91, 90, 108, 111, 113, 92 ] ]);

CHEVIE.AddData("ClassInfo","G34",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G34"),
    classnames:=CHEVIE.RawData("ClassNames","G34"),
    classparams:=CHEVIE.RawData("ClassNames","G34"),
    orders:=[1,2,3,2,6,4,6,2,6,6,3,5,9,9,4,6,6,10,18,12,18,
  12, 18, 12, 6, 18, 3, 42, 6, 6, 42, 3, 8, 10, 6, 18, 6, 18, 6, 6, 6, 6, 12,
  12, 9, 9, 30, 30, 6, 24, 12, 6, 12, 18, 24, 30, 30, 6, 6, 21, 6, 6, 21, 6,
  4, 12, 12, 30, 24, 30, 12, 24, 12, 3, 14, 18, 12, 9, 6, 18, 12, 12, 18, 18,
  8, 15, 12, 6, 18, 6, 12, 12, 6, 6, 6, 6, 6, 18, 6, 6, 6, 6, 6, 6, 6, 18, 6,
  6, 6, 6, 6, 18, 6, 6, 12, 18, 10, 12, 7, 12, 4, 3, 12, 6, 12, 6, 6, 18, 12,
  3, 6, 6, 9, 6, 3, 6, 6, 9, 15, 12, 2, 2, 4, 4, 6, 12, 6, 6, 6, 18, 2, 6, 6,
  18, 3, 12, 6, 12, 6, 3, 6, 12, 6, 12, 6, 6, 6, 6, 12 ],
    classes:=
  [ 1, 126, 3360, 2835, 60480, 68040, 5040, 11340, 5040, 45360, 120960, 653184,
  120960, 120960, 408240, 45360, 90720, 653184, 362880, 544320, 362880,
  544320, 362880, 544320, 1088640, 362880, 560, 933120, 90720, 90720, 933120,
  560, 816480, 653184, 5040, 362880, 5040, 362880, 272160, 30240, 1088640,
  30240, 272160, 272160, 120960, 120960, 653184, 653184, 90720, 816480,
  272160, 90720, 272160, 725760, 816480, 653184, 653184, 30240, 90720,
  933120, 90720, 90720, 933120, 90720, 34020, 272160, 272160, 653184, 816480,
  653184, 544320, 816480, 272160, 10080, 933120, 120960, 544320, 725760,
  5040, 120960, 272160, 408240, 362880, 362880, 816480, 653184, 68040, 1,
  120960, 2835, 34020, 68040, 11340, 120960, 45360, 45360, 90720, 362880,
  560, 560, 30240, 5040, 5040, 272160, 90720, 120960, 90720, 126, 10080,
  5040, 3360, 362880, 60480, 5040, 272160, 362880, 653184, 272160, 933120,
  408240, 68040, 1, 34020, 2835, 68040, 11340, 45360, 362880, 272160, 560,
  5040, 30240, 120960, 126, 3360, 60480, 5040, 120960, 653184, 68040, 1,
  2835, 34020, 68040, 45360, 272160, 560, 5040, 30240, 120960, 126, 3360,
  60480, 120960, 1, 34020, 2835, 544320, 126, 3360, 60480, 68040, 1, 34020,
  2835, 126, 3360, 60480, 68040 ]));

CHEVIE.AddData("CharInfo","G34",function()local res;
  res:=rec(charparams:=
[[1,0],[1,126],[6,5],[6,89],[6,1],[6,85],[15,58],[15,16],[15,56],[15,14],
 [20,33,1],[20,33,2],[21,60],[21,6],[21,4],[21,70],[21,2],[21,68],[35,60],
 [35,6],[35,36],[35,18],[56,57],[56,3],[56,45],[56,9],[70,45,1],[70,9,1],
 [70,45,3],[70,45,2],[70,9,2],[70,9,3],[84,17],[84,37],[84,13],[84,41],[90,6],
 [90,48],[105,10],[105,46],[105,40],[105,4],[105,50],[105,38],[105,8,2],
 [105,8,1],[105,22],[105,28],[105,20],[105,26],[120,21,1],[120,21,2],[120,5],
 [120,47],[120,7],[120,49],[126,5],[126,41],[126,7],[126,43],[140,21],[140,30],
 [140,12],[189,24],[189,18],[210,30],[210,12],[210,10],[210,40],[210,38],
 [210,8],[210,17],[210,29],[210,13],[210,25],[280,30,2],[280,30,1],[280,12,2],
 [280,12,1],[315,36],[315,6],[315,24],[315,18],[315,10],[315,28],[315,14],
 [315,32],[336,34],[336,10],[336,32],[336,8],[336,17],[336,25],[336,19],
 [336,23],[384,11],[384,29],[384,13],[384,31],[384,34],[384,10],[384,32],
 [384,8],[420,30],[420,12],[420,21],[420,11],[420,31],[420,7],[420,35],
 [420,16],[420,22],[420,14],[420,20],[504,33],[504,9],[504,21],[504,15],
 [540,17],[540,19],[540,21,1],[540,21,2],[560,27],[560,9],[560,18,1],
 [560,18,3],[560,18,2],[630,27],[630,15],[630,16],[630,22],[630,14],
 [630,20],[630,11],[630,25],[630,13],[630,23],[720,16],[720,20],[729,24],
 [729,12],[729,28],[729,10],[729,26],[729,14],[756,16],[756,22],[756,14],
 [756,20],[840,17],[840,19],[840,13,2],[840,23,1],[840,11],[840,25],
 [840,13,1],[840,23,2],[896,24],[896,12],[896,21],[896,15],[945,16],
 [945,22],[945,14],[945,20],[1260,17],[1260,19],[1280,18],[1280,15]],
# here the labelling is as follows:
# phi{105,8}' is the conjugate of phi{105,4}, phi{840,13}'  of phi{840,11}
# and phi{840,23}' of phi{840,19}.
# phi{70,9}', phi{70,45}' and phi{560,18}' are real.
# phi{20,33}' and phi{70,9}'' occur in phi{6,1} tensor phi{15,14}
# [this differs from Malle 'on the generic degrees...']
# phi{70,9}'' tensor sign is phi{70,45}''
# phi{120,21}' occurs in the permutation character induced from A_5
# phi{280,12}',phi{280,30}'',phi{560,18}''' are in phi_{6,1}tensor phi_{336,17}
# phi_{540,21}' occurs in phi{6,1} tensor phi{105,20}
  extRefl:=[1,5,10,11,7,4,2]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,
    2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1];
  return res;
end);

CHEVIE.AddData("CycPolSchurElements","G34",
[ [1,0,2,2,2,2,2,2,3,3,3,3,3,3,4,4,5,6,6,6,6,6,6,7,8,9,10,12,12,14,15,18,21,24,
   30,42],
  [1,-126,2,2,2,2,2,2,3,3,3,3,3,3,4,4,5,6,6,6,6,6,6,7,8,9,10,12,12,14,15,18,21,
     24,30,42],
  [(3+ER(-3))/2,-1,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,5,6,6,6,5/6,5/6,5/6,7,9,
     10,12,1/12,7/12,14,2/15,8/15,11/15,14/15,18,1/21,4/21,10/21,13/21,16/21,
        19/21,1/30,7/30,13/30,19/30,5/42,11/42,17/42,23/42,29/42,41/42],
  [(3-ER(-3))/2,-85,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,5,6,6,6,1/6,1/6,1/6,7,9,
     10,12,5/12,11/12,14,1/15,4/15,7/15,13/15,18,2/21,5/21,8/21,11/21,17/21,
        20/21,11/30,17/30,23/30,29/30,1/42,13/42,19/42,25/42,31/42,37/42],
  [(3-ER(-3))/2,-1,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,5,6,6,6,1/6,1/6,1/6,7,9,
     10,12,5/12,11/12,14,1/15,4/15,7/15,13/15,18,2/21,5/21,8/21,11/21,17/21,
        20/21,11/30,17/30,23/30,29/30,1/42,13/42,19/42,25/42,31/42,37/42],
  [(3+ER(-3))/2,-85,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,5,6,6,6,5/6,5/6,5/6,7,9,
     10,12,1/12,7/12,14,2/15,8/15,11/15,14/15,18,1/21,4/21,10/21,13/21,16/21,
        19/21,1/30,7/30,13/30,19/30,5/42,11/42,17/42,23/42,29/42,41/42],
  [6*E(3)^2,-46,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,7,2/9,5/9,
     8/9,5/12,5/12,11/12,11/12,5/18,11/18,17/18,1/42,13/42,19/42,25/42,31/42,
        37/42],
  [6*E(3),-4,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,7,1/9,4/9,7/9,
     1/12,1/12,7/12,7/12,1/18,7/18,13/18,5/42,11/42,17/42,23/42,29/42,41/42],
  [6*E(3),-46,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,7,1/9,4/9,
  7/9,1/12,1/12,7/12,7/12,1/18,7/18,13/18,5/42,11/42,17/42,23/42,29/42,41/42],
  [6*E(3)^2,-4,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,7,2/9,5/9,
    8/9,5/12,5/12,11/12,11/12,5/18,11/18,17/18,1/42,13/42,19/42,25/42,31/42,
      37/42],
  [42,-15,2,2,2,2,2,2,3,3,3,3,3,3,5/6,5/6,5/6,5/6,5/6,5/6,1/42,13/42,19/42,
    25/42,31/42,37/42],
  [42,-15,2,2,2,2,2,2,3,3,3,3,3,3,1/6,1/6,1/6,1/6,1/6,1/6,5/42,11/42,17/42,
    23/42,29/42,41/42],
  [2,-57,2,2,2,2,2,2,3,3,3,3,3,3,4,4,5,6,6,6,6,6,6,12,12,15,18],
  [2,-3,2,2,2,2,2,2,3,3,3,3,3,3,4,4,5,6,6,6,6,6,6,12,12,15,18],
  [(3+ER(-3))/2,-2,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,5,6,6,6,1/6,1/6,1/6,8,9,
    10,12,5/12,11/12,1/15,4/15,7/15,13/15,18,1/24,7/24,13/24,19/24,11/30,17/30,
      23/30,29/30],
  [(3-ER(-3))/2,-68,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,5,6,6,6,5/6,5/6,5/6,8,9,
    10,12,1/12,7/12,2/15,8/15,11/15,14/15,18,5/24,11/24,17/24,23/24,1/30,7/30,
      13/30,19/30],
  [(3-ER(-3))/2,-2,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,5,6,6,6,5/6,5/6,5/6,8,9,
    10,12,1/12,7/12,2/15,8/15,11/15,14/15,18,5/24,11/24,17/24,23/24,1/30,7/30,
      13/30,19/30],
  [(3+ER(-3))/2,-68,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,5,6,6,6,1/6,1/6,1/6,8,9,
    10,12,5/12,11/12,1/15,4/15,7/15,13/15,18,1/24,7/24,13/24,19/24,11/30,17/30,
      23/30,29/30],
  [2,-57,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,9,10,12,12,30],
  [2,-3,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,9,10,12,12,30],
  [3,-28,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,8],
  [3,-10,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,8],
  [2,-57,2,2,3,3,3,3,3,3,4,4,5,6,6,8,9,12,12,15,24],
  [2,-3,2,2,3,3,3,3,3,3,4,4,5,6,6,8,9,12,12,15,24],
  [3,-41,2,2,2,2,2,2,3,3,3,3,3,3,5,6,6,6,6,6,6,10,12,12],
  [3,-5,2,2,2,2,2,2,3,3,3,3,3,3,5,6,6,6,6,6,6,10,12,12],
  [1,-45,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,9,12,12,18],
  [1,-9,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,9,12,12,18],
  [-3*E(3),-41,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,5/12,5/12,11/12,11/12,
2/15,8/15,11/15,14/15,1/30,7/30,13/30,19/30],
  [-3*E(3)^2,-41,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,1/12,1/12,7/12,7/12,
1/15,4/15,7/15,13/15,11/30,17/30,23/30,29/30],
  [-3*E(3),-5,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,5/12,5/12,11/12,11/12,
   2/15,8/15,11/15,14/15,1/30,7/30,13/30,19/30],
  [-3*E(3)^2,-5,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,1/12,1/12,7/12,7/12,
   1/15,4/15,7/15,13/15,11/30,17/30,23/30,29/30],
  [-6*E(3)^2,-7,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,5,6,6,6,1/6,1/6,1/6,1/9,4/9,7/9,
   1/18,7/18,13/18,11/30,17/30,23/30,29/30],
  [-6*E(3)^2,-31,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,5,6,6,6,1/6,1/6,1/6,1/9,4/9,7/9,
   1/18,7/18,13/18,11/30,17/30,23/30,29/30],
  [-6*E(3),-7,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,5,6,6,6,5/6,5/6,5/6,2/9,5/9,8/9,
   5/18,11/18,17/18,1/30,7/30,13/30,19/30],
  [-6*E(3),-31,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,5,6,6,6,5/6,5/6,5/6,2/9,5/9,8/9,
   5/18,11/18,17/18,1/30,7/30,13/30,19/30],
  [3,-4,2,2,2,2,2,2,3,3,3,4,4,6,6,6,7,9,12,14,18],
  [3,-46,2,2,2,2,2,2,3,3,3,4,4,6,6,6,7,9,12,14,18],
  [3,-6,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,8,2/9,5/9,8/9,5/12,
   5/12,11/12,11/12,1/18,7/18,13/18],
  [-6*E(3)^2,-46,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/9,4/9,
   7/9,5/12,5/12,11/12,11/12,14,1/18,7/18,13/18,2/21,5/21,8/21,11/21,17/21,
    20/21],
  [3,-36,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,8,1/9,4/9,7/9,
   1/12,1/12,7/12,7/12,5/18,11/18,17/18],
  [-6*E(3),-4,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/9,5/9,8/9,
   1/12,1/12,7/12,7/12,14,5/18,11/18,17/18,1/21,4/21,10/21,13/21,16/21,19/21],
  [-6*E(3),-46,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/9,5/9,8/9,
   1/12,1/12,7/12,7/12,14,5/18,11/18,17/18,1/21,4/21,10/21,13/21,16/21,19/21],
  [3,-36,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,8,2/9,5/9,8/9,
   5/12,5/12,11/12,11/12,1/18,7/18,13/18],
  [3,-6,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,8,1/9,4/9,7/9,1/12,
   1/12,7/12,7/12,5/18,11/18,17/18],
  [-6*E(3)^2,-4,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/9,4/9,
   7/9,5/12,5/12,11/12,11/12,14,1/18,7/18,13/18,2/21,5/21,8/21,11/21,17/21,
    20/21],
  [-6,-13,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,5/6,5/6,5/6,5/6,5/6,5/6,2/9,5/9,
   8/9,1/30,7/30,13/30,19/30],
  [-6,-19,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,1/6,1/6,1/6,1/6,1/6,1/6,1/9,4/9,
   7/9,11/30,17/30,23/30,29/30],
  [-6,-13,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,1/6,1/6,1/6,1/6,1/6,1/6,1/9,4/9,
   7/9,11/30,17/30,23/30,29/30],
  [-6,-19,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,5/6,5/6,5/6,5/6,5/6,5/6,2/9,5/9,
   8/9,1/30,7/30,13/30,19/30], [7,-15,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6],
  [7,-15,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6],
  [3-ER(-3),-4,2,2,3,3,3,2/3,2/3,2/3,4,4,6,1/6,7,8,9,12,5/12,11/12,2/21,5/21,
   8/21,11/21,17/21,20/21,1/24,7/24,13/24,19/24],
  [3+ER(-3),-46,2,2,3,3,3,1/3,1/3,1/3,4,4,6,5/6,7,8,9,12,1/12,7/12,1/21,4/21,
   10/21,13/21,16/21,19/21,5/24,11/24,17/24,23/24],
  [3+ER(-3),-4,2,2,3,3,3,1/3,1/3,1/3,4,4,6,5/6,7,8,9,12,1/12,7/12,1/21,4/21,
   10/21,13/21,16/21,19/21,5/24,11/24,17/24,23/24],
  [3-ER(-3),-46,2,2,3,3,3,2/3,2/3,2/3,4,4,6,1/6,7,8,9,12,5/12,11/12,2/21,5/21
,8/21,11/21,17/21,20/21,1/24,7/24,13/24,19/24],
  [3,-5,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [3,-41,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [3,-5,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [3,-41,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [2,-18,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,9],
  [2,-27,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,9],
  [2,-9,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,9],
  [6,-19,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,18],
  [6,-13,2,2,2,2,2,2,3,3,3,4,4,5,6,6,6,18],
  [1,-30,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,12,12],
  [1,-12,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,6,6,6,6,6,12,12],
  [3,-6,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/9,4/9,7/9,5/12,
5/12,11/12,11/12,5/18,11/18,17/18,1/24,7/24,13/24,19/24],
  [3,-36,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/9,5/9,8/9,1/12
,1/12,7/12,7/12,1/18,7/18,13/18,5/24,11/24,17/24,23/24],
  [3,-36,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/9,4/9,7/9,5/12
,5/12,11/12,11/12,5/18,11/18,17/18,1/24,7/24,13/24,19/24],
  [3,-6,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/9,5/9,8/9,1/12,
1/12,7/12,7/12,1/18,7/18,13/18,5/24,11/24,17/24,23/24],
  [-3*E(3),-11,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/9,5/9,8/
9,1/18,7/18,13/18],
  [-3*E(3)^2,-23,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/9,4/9,
7/9,5/18,11/18,17/18],
  [-3*E(3)^2,-11,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/9,4/9,
7/9,5/18,11/18,17/18],
  [-3*E(3),-23,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/9,5/9,8/
9,1/18,7/18,13/18],
  [-3*E(3),-28,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,5/12,5/12,11/12,11/12,1/24
,7/24,13/24,19/24],
  [-3*E(3)^2,-28,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,1/12,1/12,7/12,7/12,5/24
,11/24,17/24,23/24],
  [-3*E(3)^2,-10,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,1/12,1/12,7/12,7/12,5/24
,11/24,17/24,23/24],
  [-3*E(3),-10,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,5/12,5/12,11/12,11/12,1/24
,7/24,13/24,19/24], [3,-36,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8,9,12,18],
  [3,-6,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8,9,12,18],
  [6,-19,2,2,2,2,2,2,3,3,3,4,4,6,6,6,9,10],
  [6,-13,2,2,2,2,2,2,3,3,3,4,4,6,6,6,9,10],
  [3,-10,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8,9,18],
  [3,-28,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8,9,18],
  [3,-10,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8,9,18],
  [3,-28,2,2,2,2,2,2,3,3,3,4,4,6,6,6,8,9,18],
  [3-ER(-3),-31,2,2,3,3,3,2/3,2/3,2/3,4,4,5,6,1/6,9,12,5/12,11/12,1/15,4/15,7
/15,13/15],
  [3+ER(-3),-7,2,2,3,3,3,1/3,1/3,1/3,4,4,5,6,5/6,9,12,1/12,7/12,2/15,8/15,11/
15,14/15],
  [3+ER(-3),-31,2,2,3,3,3,1/3,1/3,1/3,4,4,5,6,5/6,9,12,1/12,7/12,2/15,8/15,11
/15,14/15],
  [3-ER(-3),-7,2,2,3,3,3,2/3,2/3,2/3,4,4,5,6,1/6,9,12,5/12,11/12,1/15,4/15,7/
15,13/15],
  [-6*E(3),-13,2,2,3,3,3,2/3,2/3,2/3,4,4,5,1/6,1/6,2/9,5/9,8/9,5/12,5/12,11/12,
   11/12,1/24,7/24,13/24,19/24],
  [-6*E(3),-19,2,2,3,3,3,2/3,2/3,2/3,4,4,5,1/6,1/6,2/9,5/9,8/9,5/12,5/12,11/12,
   11/12,1/24,7/24,13/24,19/24],
  [-6*E(3)^2,-13,2,2,3,3,3,1/3,1/3,1/3,4,4,5,5/6,5/6,1/9,4/9,7/9,1/12,1/12,7/
12,7/12,5/24,11/24,17/24,23/24],
  [-6*E(3)^2,-19,2,2,3,3,3,1/3,1/3,1/3,4,4,5,5/6,5/6,1/9,4/9,7/9,1/12,1/12,7/
12,7/12,5/24,11/24,17/24,23/24],
  [3-ER(-3),-8,2,3,3,3,1/3,1/3,1/3,5,5/6,7,9,2/15,8/15,11/15,14/15,1/21,4/21,
10/21,13/21,16/21,19/21],
  [3+ER(-3),-29,2,3,3,3,2/3,2/3,2/3,5,1/6,7,9,1/15,4/15,7/15,13/15,2/21,5/21,
8/21,11/21,17/21,20/21],
  [3+ER(-3),-8,2,3,3,3,2/3,2/3,2/3,5,1/6,7,9,1/15,4/15,7/15,13/15,2/21,5/21,8
/21,11/21,17/21,20/21],
  [3-ER(-3),-29,2,3,3,3,1/3,1/3,1/3,5,5/6,7,9,2/15,8/15,11/15,14/15,1/21,4/21
,10/21,13/21,16/21,19/21],
  [3-ER(-3),-29,2,3,3,3,1/3,1/3,1/3,5,5/6,7,9,2/15,8/15,11/15,14/15,1/21,4/21
,10/21,13/21,16/21,19/21],
  [3+ER(-3),-8,2,3,3,3,2/3,2/3,2/3,5,1/6,7,9,1/15,4/15,7/15,13/15,2/21,5/21,8
/21,11/21,17/21,20/21],
  [3+ER(-3),-29,2,3,3,3,2/3,2/3,2/3,5,1/6,7,9,1/15,4/15,7/15,13/15,2/21,5/21,
8/21,11/21,17/21,20/21],
  [3-ER(-3),-8,2,3,3,3,1/3,1/3,1/3,5,5/6,7,9,2/15,8/15,11/15,14/15,1/21,4/21,
10/21,13/21,16/21,19/21], [2,-27,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,18],
  [2,-9,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,18],
  [2,-18,2,2,2,2,2,2,3,3,3,3,3,3,6,6,6,6,6,6,18],
  [-6*E(3)^2,-7,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,6,6,6,1/6,1/6,1/6,2/9,5/9,8/9,10,
   1/15,4/15,7/15,13/15,5/18,11/18,17/18],
  [-6*E(3)^2,-31,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,6,6,6,1/6,1/6,1/6,2/9,5/9,8/9,
10,1/15,4/15,7/15,13/15,5/18,11/18,17/18],
  [-6*E(3),-7,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,6,6,6,5/6,5/6,5/6,1/9,4/9,7/9,10,
2/15,8/15,11/15,14/15,1/18,7/18,13/18],
  [-6*E(3),-31,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,6,6,6,5/6,5/6,5/6,1/9,4/9,7/9,10
,2/15,8/15,11/15,14/15,1/18,7/18,13/18],
  [6*E(3)^2,-13,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,5/6,5/6,5/6,5/6,5/6,5/6,1/9,4/9
,7/9,10,1/12,1/12,7/12,7/12],
  [6*E(3),-19,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,1/6,1/6,1/6,1/6,1/6,1/6,2/9,5/9,8
/9,10,5/12,5/12,11/12,11/12],
  [6*E(3),-13,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,1/6,1/6,1/6,1/6,1/6,1/6,2/9,5/9,8
/9,10,5/12,5/12,11/12,11/12],
  [6*E(3)^2,-19,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,5/6,5/6,5/6,5/6,5/6,5/6,1/9,4/9
,7/9,10,1/12,1/12,7/12,7/12], [3,-31,2,2,2,2,2,2,3,3,3,5,6,6,6,9,10,18],
  [3,-7,2,2,2,2,2,2,3,3,3,5,6,6,6,9,10,18],
  [6,-19,2,2,3,3,3,4,4,5,6,8,9,12], [6,-13,2,2,3,3,3,4,4,5,6,8,9,12],
  [6,-15,2,2,2,2,2,2,3,3,3,6,6,6,7,18],
  [6,-15,2,2,2,2,2,2,3,3,3,6,6,6,7,18],
  [-42,-15,2,2,2,2,2,2,1/3,1/3,1/3,1/3,1/3,1/3,6,6,6,6,6,6,2/21,5/21,8/21,11/
21,17/21,20/21],
  [-42,-15,2,2,2,2,2,2,2/3,2/3,2/3,2/3,2/3,2/3,6,6,6,6,6,6,1/21,4/21,10/21,13
/21,16/21,19/21], [2,-27,2,2,3,3,3,3,3,3,4,4,6,6,9,12,12],
  [2,-9,2,2,3,3,3,3,3,3,4,4,6,6,9,12,12],
  [2,-18,2,2,3,3,3,3,3,3,4,4,6,6,9,12,12],
  [6,-15,2,2,3,3,3,3,3,3,4,4,1/6,1/6,5/12,5/12,11/12,11/12,1/21,4/21,10/21,13
/21,16/21,19/21],
  [6,-15,2,2,3,3,3,3,3,3,4,4,5/6,5/6,1/12,1/12,7/12,7/12,2/21,5/21,8/21,11/21
,17/21,20/21], [3,-23,2,2,2,2,2,2,3,3,3,4,4,6,6,6,9,18],
  [3,-11,2,2,2,2,2,2,3,3,3,4,4,6,6,6,9,18],
  [(3-ER(-3))/2,-14,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,12,1/
12,7/12],
  [(3+ER(-3))/2,-20,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,12,5/
12,11/12],
  [(3+ER(-3))/2,-14,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,12,5/
12,11/12],
  [(3-ER(-3))/2,-20,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,12,1/
12,7/12],
  [(3-ER(-3))/2,-11,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,12,1/
12,7/12],
  [(3-ER(-3))/2,-23,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,12,1/
12,7/12],
  [(3+ER(-3))/2,-11,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,12,5/
12,11/12],
  [(3+ER(-3))/2,-23,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,12,5/
12,11/12], [6,-15,2,2,3,3,3,4,4,6,7,9,12], [6,-15,2,2,3,3,3,4,4,6,7,9,12]
    , [3,-24,2,2,2,2,2,2,4,4,5,7,8,10,14],
  [3,-10,2,2,2,2,2,2,4,4,5,7,8,10,14], [3,-24,2,2,2,2,2,2,4,4,5,7,8,10,14]
    , [3,-10,2,2,2,2,2,2,4,4,5,7,8,10,14],
  [3,-24,2,2,2,2,2,2,4,4,5,7,8,10,14], [3,-10,2,2,2,2,2,2,4,4,5,7,8,10,14]
    ,
  [-6*E(3)^2,-13,2,2,2,2,2,2,1/3,1/3,1/3,1/3,1/3,1/3,5,6,6,6,5/6,5/6,5/6,1/12
,1/12,7/12,7/12,5/18,11/18,17/18],
  [-6*E(3),-19,2,2,2,2,2,2,2/3,2/3,2/3,2/3,2/3,2/3,5,6,6,6,1/6,1/6,1/6,5/12,5
/12,11/12,11/12,1/18,7/18,13/18],
  [-6*E(3),-13,2,2,2,2,2,2,2/3,2/3,2/3,2/3,2/3,2/3,5,6,6,6,1/6,1/6,1/6,5/12,5
/12,11/12,11/12,1/18,7/18,13/18],
  [-6*E(3)^2,-19,2,2,2,2,2,2,1/3,1/3,1/3,1/3,1/3,1/3,5,6,6,6,5/6,5/6,5/6,1/12
,1/12,7/12,7/12,5/18,11/18,17/18],
  [6,-13,2,2,3,3,3,2/3,2/3,2/3,4,4,1/6,1/6,8,1/9,4/9,7/9,5/12,5/12,11/12,11/12,
   1/15,4/15,7/15,13/15],
  [6,-19,2,2,3,3,3,2/3,2/3,2/3,4,4,1/6,1/6,8,1/9,4/9,7/9,5/12,5/12,11/12,11/12,
   1/15,4/15,7/15,13/15],
  [6,-13,2,2,3,3,3,1/3,1/3,1/3,4,4,5/6,5/6,8,2/9,5/9,8/9,1/12,1/12,7/12,7/12,
2/15,8/15,11/15,14/15],
  [6,-19,2,2,3,3,3,1/3,1/3,1/3,4,4,5/6,5/6,8,2/9,5/9,8/9,1/12,1/12,7/12,7/12,
2/15,8/15,11/15,14/15],
  [3,-11,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,6,6,6,5/6,5/6,5/6,1/9,4/9,7/9,1/12,1/12,
   7/12,7/12,5/18,11/18,17/18],
  [3,-23,2,2,2,2,2,2,3,3,3,1/3,1/3,1/3,6,6,6,5/6,5/6,5/6,1/9,4/9,7/9,1/12,1/12,
   7/12,7/12,5/18,11/18,17/18],
  [3,-11,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,6,6,6,1/6,1/6,1/6,2/9,5/9,8/9,5/12,5/12,
   11/12,11/12,1/18,7/18,13/18],
  [3,-23,2,2,2,2,2,2,3,3,3,2/3,2/3,2/3,6,6,6,1/6,1/6,1/6,2/9,5/9,8/9,5/12,5/12,
   11/12,11/12,1/18,7/18,13/18], [2,-21,2,3,3,3,3,3,3,5,6,9,15],
  [2,-12,2,3,3,3,3,3,3,5,6,9,15], [2,-21,2,3,3,3,3,3,3,5,6,9,15],
  [2,-12,2,3,3,3,3,3,3,5,6,9,15],
  [6,-13,2,2,2,2,2,2,1/3,1/3,1/3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/15,8/15,
11/15,14/15,1/18,7/18,13/18],
  [6,-19,2,2,2,2,2,2,2/3,2/3,2/3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/15,4/15,
7/15,13/15,5/18,11/18,17/18],
  [6,-13,2,2,2,2,2,2,2/3,2/3,2/3,2/3,2/3,2/3,4,4,6,6,6,1/6,1/6,1/6,1/15,4/15,
7/15,13/15,5/18,11/18,17/18],
  [6,-19,2,2,2,2,2,2,1/3,1/3,1/3,1/3,1/3,1/3,4,4,6,6,6,5/6,5/6,5/6,2/15,8/15,
11/15,14/15,1/18,7/18,13/18], [6,-15,2,2,2,2,2,2,3,3,3,6,6,6,9,14],
  [6,-15,2,2,2,2,2,2,3,3,3,6,6,6,9,14], [6,-15,3,3,3,3,3,3,6,6,7,12,12],
  [42,-15,3,3,3,3,3,3,6,6,6,6,6,6,14] ]);

CHEVIE.AddData("Irr","G34",
[[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,-1,1,1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,
1,1,1,1,1,1,1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,1,1,1,-1,1,-1,1,1,
1,-1,-1,1,1,-1,1,1,1,1,-1,-1,1,1,1,1,-1,1,1,-1,-1,-1,-1,1,1,1,-1,1,-1,1,-1,-1,
-1,1,-1,1,1,1,1,-1,1,1,1,-1,-1,1,-1,-1,1,-1,-1,1,-1,1,-1,-1,1,1,-1,1,1,1,-1,1,
-1,1,-1,-1,1,-1,1,-1,1,1,1,1,-1,-1,1,-1,-1,1,1,1,-1,1,-1,-1],[6,4,3,2,1,2,
(5+ER(-3))/2,0,(5-ER(-3))/2,-E(3),0,1,(3+ER(-3))/2,(3-ER(-3))/2,0,-E(3)^2,-1,
-1,E(3)^2,-E(3)^2,-E(3),-E(3),-E(3)^2,-1,0,E(3),-3*E(3),E(3),1,2,E(3)^2,
-3*E(3)^2,0,1,(-1-3*ER(-3))/2,1,(-1+3*ER(-3))/2,1,0,-2*E(3),0,-2*E(3)^2,
(3+ER(-3))/2,(3-ER(-3))/2,ER(-3),-ER(-3),-E(3)^2,-E(3),2*E(3)^2,0,-E(3),
2*E(3),-E(3)^2,0,0,E(3),E(3)^2,2,-E(3)^2,-E(3)^2,-2*E(3),-2*E(3)^2,-E(3),
-E(3),2,1,ER(-3),-E(3)^2,0,-E(3),1,0,-ER(-3),0,1,(3+ER(-3))/2,E(3)^2,0,
(1-3*ER(-3))/2,-ER(-3),-1,0,-E(3),E(3)^2,0,E(3)^2,0,-6*E(3),(3-ER(-3))/2,
-2*E(3),-2*E(3),-2*E(3),0,0,E(3)^2,1,E(3),-1,3*E(3)^2,3,2*E(3)^2,
(-5-ER(-3))/2,2+ER(-3),0,-2,(-3-ER(-3))/2,E(3)^2,-4*E(3),0,2-ER(-3),-3*E(3),
-E(3)^2,-E(3),-2-ER(-3),E(3),-1,-1,E(3)^2,-1,0,0,6*E(3)^2,2*E(3)^2,2*E(3)^2,
2*E(3)^2,0,-1,E(3),(-3-ER(-3))/2,-3,-2+ER(-3),-2,(-3+ER(-3))/2,4*E(3)^2,
3*E(3)^2,E(3)^2,(-5+ER(-3))/2,(-3-ER(-3))/2,E(3),0,-6,-2,-2,-2,E(3),
(-3+ER(-3))/2,3*E(3),(1+3*ER(-3))/2,2*E(3),ER(-3),-4,-3,-1,(-3+ER(-3))/2,
6*E(3),2*E(3),2*E(3),E(3),4*E(3),3*E(3),E(3),2*E(3),-6*E(3)^2,-2*E(3)^2,
-2*E(3)^2,-4*E(3)^2,-3*E(3)^2,-E(3)^2,-2*E(3)^2],[6,-4,3,2,-1,-2,
(-5-ER(-3))/2,0,(-5+ER(-3))/2,-E(3),0,1,(3+ER(-3))/2,(3-ER(-3))/2,0,-E(3)^2,
-1,1,-E(3)^2,E(3)^2,E(3),E(3),E(3)^2,1,0,-E(3),-3*E(3),E(3),1,2,E(3)^2,
-3*E(3)^2,0,-1,(1+3*ER(-3))/2,-1,(1-3*ER(-3))/2,-1,0,2*E(3),0,2*E(3)^2,
(-3-ER(-3))/2,(-3+ER(-3))/2,ER(-3),-ER(-3),-E(3)^2,-E(3),2*E(3)^2,0,-E(3),
2*E(3),-E(3)^2,0,0,-E(3),-E(3)^2,-2,-E(3)^2,-E(3)^2,-2*E(3),-2*E(3)^2,-E(3),
-E(3),2,1,-ER(-3),E(3)^2,0,E(3),-1,0,ER(-3),0,1,(3+ER(-3))/2,-E(3)^2,0,
(-1+3*ER(-3))/2,-ER(-3),-1,0,E(3),-E(3)^2,0,E(3)^2,0,-6*E(3),(3-ER(-3))/2,
-2*E(3),-2*E(3),2*E(3),0,0,E(3)^2,1,E(3),1,3*E(3)^2,3,-2*E(3)^2,(5+ER(-3))/2,
-2-ER(-3),0,-2,(-3-ER(-3))/2,E(3)^2,4*E(3),0,-2+ER(-3),-3*E(3),E(3)^2,E(3),
2+ER(-3),E(3),1,-1,E(3)^2,-1,0,0,6*E(3)^2,2*E(3)^2,2*E(3)^2,-2*E(3)^2,0,-1,
-E(3),(3+ER(-3))/2,-3,2-ER(-3),2,(-3+ER(-3))/2,-4*E(3)^2,3*E(3)^2,-E(3)^2,
(5-ER(-3))/2,(-3-ER(-3))/2,E(3),0,-6,-2,-2,2,E(3),(3-ER(-3))/2,3*E(3),
(-1-3*ER(-3))/2,-2*E(3),ER(-3),4,-3,1,(-3+ER(-3))/2,6*E(3),2*E(3),2*E(3),
-E(3),-4*E(3),3*E(3),-E(3),-2*E(3),-6*E(3)^2,-2*E(3)^2,-2*E(3)^2,4*E(3)^2,
-3*E(3)^2,E(3)^2,2*E(3)^2],[6,4,3,2,1,2,(5-ER(-3))/2,0,(5+ER(-3))/2,-E(3)^2,0,
1,(3-ER(-3))/2,(3+ER(-3))/2,0,-E(3),-1,-1,E(3),-E(3),-E(3)^2,-E(3)^2,-E(3),-1,
0,E(3)^2,-3*E(3)^2,E(3)^2,1,2,E(3),-3*E(3),0,1,(-1+3*ER(-3))/2,1,
(-1-3*ER(-3))/2,1,0,-2*E(3)^2,0,-2*E(3),(3-ER(-3))/2,(3+ER(-3))/2,-ER(-3),
ER(-3),-E(3),-E(3)^2,2*E(3),0,-E(3)^2,2*E(3)^2,-E(3),0,0,E(3)^2,E(3),2,-E(3),
-E(3),-2*E(3)^2,-2*E(3),-E(3)^2,-E(3)^2,2,1,-ER(-3),-E(3),0,-E(3)^2,1,0,
ER(-3),0,1,(3-ER(-3))/2,E(3),0,(1+3*ER(-3))/2,ER(-3),-1,0,-E(3)^2,E(3),0,E(3),
0,-6*E(3)^2,(3+ER(-3))/2,-2*E(3)^2,-2*E(3)^2,-2*E(3)^2,0,0,E(3),1,E(3)^2,-1,
3*E(3),3,2*E(3),(-5+ER(-3))/2,2-ER(-3),0,-2,(-3+ER(-3))/2,E(3),-4*E(3)^2,0,
2+ER(-3),-3*E(3)^2,-E(3),-E(3)^2,-2+ER(-3),E(3)^2,-1,-1,E(3),-1,0,0,6*E(3),
2*E(3),2*E(3),2*E(3),0,-1,E(3)^2,(-3+ER(-3))/2,-3,-2-ER(-3),-2,(-3-ER(-3))/2,
4*E(3),3*E(3),E(3),(-5-ER(-3))/2,(-3+ER(-3))/2,E(3)^2,0,-6,-2,-2,-2,E(3)^2,
(-3-ER(-3))/2,3*E(3)^2,(1-3*ER(-3))/2,2*E(3)^2,-ER(-3),-4,-3,-1,(-3-ER(-3))/2,
6*E(3)^2,2*E(3)^2,2*E(3)^2,E(3)^2,4*E(3)^2,3*E(3)^2,E(3)^2,2*E(3)^2,-6*E(3),
-2*E(3),-2*E(3),-4*E(3),-3*E(3),-E(3),-2*E(3)],[6,-4,3,2,-1,-2,(-5+ER(-3))/2,
0,(-5-ER(-3))/2,-E(3)^2,0,1,(3-ER(-3))/2,(3+ER(-3))/2,0,-E(3),-1,1,-E(3),E(3),
E(3)^2,E(3)^2,E(3),1,0,-E(3)^2,-3*E(3)^2,E(3)^2,1,2,E(3),-3*E(3),0,-1,
(1-3*ER(-3))/2,-1,(1+3*ER(-3))/2,-1,0,2*E(3)^2,0,2*E(3),(-3+ER(-3))/2,
(-3-ER(-3))/2,-ER(-3),ER(-3),-E(3),-E(3)^2,2*E(3),0,-E(3)^2,2*E(3)^2,-E(3),0,
0,-E(3)^2,-E(3),-2,-E(3),-E(3),-2*E(3)^2,-2*E(3),-E(3)^2,-E(3)^2,2,1,ER(-3),
E(3),0,E(3)^2,-1,0,-ER(-3),0,1,(3-ER(-3))/2,-E(3),0,(-1-3*ER(-3))/2,ER(-3),-1,
0,E(3)^2,-E(3),0,E(3),0,-6*E(3)^2,(3+ER(-3))/2,-2*E(3)^2,-2*E(3)^2,2*E(3)^2,0,
0,E(3),1,E(3)^2,1,3*E(3),3,-2*E(3),(5-ER(-3))/2,-2+ER(-3),0,-2,(-3+ER(-3))/2,
E(3),4*E(3)^2,0,-2-ER(-3),-3*E(3)^2,E(3),E(3)^2,2-ER(-3),E(3)^2,1,-1,E(3),-1,
0,0,6*E(3),2*E(3),2*E(3),-2*E(3),0,-1,-E(3)^2,(3-ER(-3))/2,-3,2+ER(-3),2,
(-3-ER(-3))/2,-4*E(3),3*E(3),-E(3),(5+ER(-3))/2,(-3+ER(-3))/2,E(3)^2,0,-6,-2,
-2,2,E(3)^2,(3+ER(-3))/2,3*E(3)^2,(-1+3*ER(-3))/2,-2*E(3)^2,-ER(-3),4,-3,1,
(-3-ER(-3))/2,6*E(3)^2,2*E(3)^2,2*E(3)^2,-E(3)^2,-4*E(3)^2,3*E(3)^2,-E(3)^2,
-2*E(3)^2,-6*E(3),-2*E(3),-2*E(3),4*E(3),-3*E(3),E(3),2*E(3)],[15,-5,3,-1,1,
-1,4*E(3)^2,3,4*E(3),2*E(3)^2,0,0,ER(-3),-ER(-3),-1,2*E(3),-1,0,1,-E(3),1,
-E(3)^2,1,-1,0,1,6*E(3)^2,E(3)^2,-1,2,E(3),6*E(3),1,0,4,E(3),4,E(3)^2,0,
-2*E(3)^2,0,-2*E(3),2*E(3)^2,2*E(3),(-3+ER(-3))/2,(-3-ER(-3))/2,0,0,2*E(3),
E(3)^2,0,2*E(3)^2,0,0,E(3),0,0,-2,-E(3),E(3),2*E(3)^2,2*E(3),E(3)^2,-E(3)^2,3,
0,2,0,E(3),0,-1,E(3)^2,2,0,1,(3+ER(-3))/2,-E(3),0,4,(-3+ER(-3))/2,0,-E(3),
E(3),E(3)^2,1,0,-E(3),15*E(3)^2,(3-ER(-3))/2,-E(3)^2,3*E(3)^2,-E(3)^2,
3*E(3)^2,0,2*E(3),2,-E(3)^2,E(3)^2,6*E(3),6,-2*E(3),4*E(3)^2,4*E(3)^2,0,2,
ER(-3),-E(3),-5*E(3)^2,0,4*E(3),3*E(3)^2,E(3)^2,E(3)^2,4*E(3)^2,0,E(3),0,0,1,
-E(3)^2,-1,15*E(3),3*E(3),-E(3),-E(3),3*E(3),2,E(3),2*E(3)^2,6,4*E(3),-2,
(3-ER(-3))/2,-5*E(3),3*E(3),E(3),4*E(3),(3+ER(-3))/2,0,-E(3)^2,15,-1,3,-1,
2*E(3)^2,2*E(3),6*E(3)^2,4,-2*E(3)^2,(-3-ER(-3))/2,-5,3,1,-ER(-3),15*E(3)^2,
3*E(3)^2,-E(3)^2,-E(3)^2,-5*E(3)^2,3*E(3)^2,E(3)^2,-E(3)^2,15*E(3),3*E(3),
-E(3),-5*E(3),3*E(3),E(3),-E(3)],[15,5,3,-1,-1,1,-4*E(3)^2,-3,-4*E(3),
2*E(3)^2,0,0,ER(-3),-ER(-3),-1,2*E(3),-1,0,-1,E(3),-1,E(3)^2,-1,1,0,-1,
6*E(3)^2,E(3)^2,-1,2,E(3),6*E(3),-1,0,-4,-E(3),-4,-E(3)^2,0,2*E(3)^2,0,2*E(3),
-2*E(3)^2,-2*E(3),(-3+ER(-3))/2,(-3-ER(-3))/2,0,0,2*E(3),E(3)^2,0,2*E(3)^2,0,
0,E(3),0,0,2,-E(3),E(3),2*E(3)^2,2*E(3),E(3)^2,-E(3)^2,3,0,-2,0,-E(3),0,1,
-E(3)^2,-2,0,1,(3+ER(-3))/2,E(3),0,-4,(-3+ER(-3))/2,0,-E(3),-E(3),-E(3)^2,1,0,
E(3),15*E(3)^2,(3-ER(-3))/2,-E(3)^2,3*E(3)^2,E(3)^2,-3*E(3)^2,0,2*E(3),2,
-E(3)^2,-E(3)^2,6*E(3),6,2*E(3),-4*E(3)^2,-4*E(3)^2,0,2,ER(-3),-E(3),5*E(3)^2,
0,-4*E(3),3*E(3)^2,-E(3)^2,-E(3)^2,-4*E(3)^2,0,-E(3),0,0,1,-E(3)^2,1,15*E(3),
3*E(3),-E(3),E(3),-3*E(3),2,-E(3),-2*E(3)^2,6,-4*E(3),2,(3-ER(-3))/2,5*E(3),
3*E(3),-E(3),-4*E(3),(3+ER(-3))/2,0,E(3)^2,15,-1,3,1,2*E(3)^2,-2*E(3),
6*E(3)^2,-4,2*E(3)^2,(-3-ER(-3))/2,5,3,-1,-ER(-3),15*E(3)^2,3*E(3)^2,-E(3)^2,
E(3)^2,5*E(3)^2,3*E(3)^2,-E(3)^2,E(3)^2,15*E(3),3*E(3),-E(3),5*E(3),3*E(3),
-E(3),E(3)],[15,-5,3,-1,1,-1,4*E(3),3,4*E(3)^2,2*E(3),0,0,-ER(-3),ER(-3),-1,
2*E(3)^2,-1,0,1,-E(3)^2,1,-E(3),1,-1,0,1,6*E(3),E(3),-1,2,E(3)^2,6*E(3)^2,1,0,
4,E(3)^2,4,E(3),0,-2*E(3),0,-2*E(3)^2,2*E(3),2*E(3)^2,(-3-ER(-3))/2,
(-3+ER(-3))/2,0,0,2*E(3)^2,E(3),0,2*E(3),0,0,E(3)^2,0,0,-2,-E(3)^2,E(3)^2,
2*E(3),2*E(3)^2,E(3),-E(3),3,0,2,0,E(3)^2,0,-1,E(3),2,0,1,(3-ER(-3))/2,
-E(3)^2,0,4,(-3-ER(-3))/2,0,-E(3)^2,E(3)^2,E(3),1,0,-E(3)^2,15*E(3),
(3+ER(-3))/2,-E(3),3*E(3),-E(3),3*E(3),0,2*E(3)^2,2,-E(3),E(3),6*E(3)^2,6,
-2*E(3)^2,4*E(3),4*E(3),0,2,-ER(-3),-E(3)^2,-5*E(3),0,4*E(3)^2,3*E(3),E(3),
E(3),4*E(3),0,E(3)^2,0,0,1,-E(3),-1,15*E(3)^2,3*E(3)^2,-E(3)^2,-E(3)^2,
3*E(3)^2,2,E(3)^2,2*E(3),6,4*E(3)^2,-2,(3+ER(-3))/2,-5*E(3)^2,3*E(3)^2,E(3)^2,
4*E(3)^2,(3-ER(-3))/2,0,-E(3),15,-1,3,-1,2*E(3),2*E(3)^2,6*E(3),4,-2*E(3),
(-3+ER(-3))/2,-5,3,1,ER(-3),15*E(3),3*E(3),-E(3),-E(3),-5*E(3),3*E(3),E(3),
-E(3),15*E(3)^2,3*E(3)^2,-E(3)^2,-5*E(3)^2,3*E(3)^2,E(3)^2,-E(3)^2],[15,5,3,
-1,-1,1,-4*E(3),-3,-4*E(3)^2,2*E(3),0,0,-ER(-3),ER(-3),-1,2*E(3)^2,-1,0,-1,
E(3)^2,-1,E(3),-1,1,0,-1,6*E(3),E(3),-1,2,E(3)^2,6*E(3)^2,-1,0,-4,-E(3)^2,-4,
-E(3),0,2*E(3),0,2*E(3)^2,-2*E(3),-2*E(3)^2,(-3-ER(-3))/2,(-3+ER(-3))/2,0,0,
2*E(3)^2,E(3),0,2*E(3),0,0,E(3)^2,0,0,2,-E(3)^2,E(3)^2,2*E(3),2*E(3)^2,E(3),
-E(3),3,0,-2,0,-E(3)^2,0,1,-E(3),-2,0,1,(3-ER(-3))/2,E(3)^2,0,-4,
(-3-ER(-3))/2,0,-E(3)^2,-E(3)^2,-E(3),1,0,E(3)^2,15*E(3),(3+ER(-3))/2,-E(3),
3*E(3),E(3),-3*E(3),0,2*E(3)^2,2,-E(3),-E(3),6*E(3)^2,6,2*E(3)^2,-4*E(3),
-4*E(3),0,2,-ER(-3),-E(3)^2,5*E(3),0,-4*E(3)^2,3*E(3),-E(3),-E(3),-4*E(3),0,
-E(3)^2,0,0,1,-E(3),1,15*E(3)^2,3*E(3)^2,-E(3)^2,E(3)^2,-3*E(3)^2,2,-E(3)^2,
-2*E(3),6,-4*E(3)^2,2,(3+ER(-3))/2,5*E(3)^2,3*E(3)^2,-E(3)^2,-4*E(3)^2,
(3-ER(-3))/2,0,E(3),15,-1,3,1,2*E(3),-2*E(3)^2,6*E(3),-4,2*E(3),(-3+ER(-3))/2,
5,3,-1,ER(-3),15*E(3),3*E(3),-E(3),E(3),5*E(3),3*E(3),-E(3),E(3),15*E(3)^2,
3*E(3)^2,-E(3)^2,5*E(3)^2,3*E(3)^2,-E(3)^2,E(3)^2],[20,0,2,-4,0,0,-3*ER(-3),0,
3*ER(-3),-1,2,0,-1,-1,0,-1,2,0,-ER(-3),0,-ER(-3),0,ER(-3),0,0,ER(-3),-7,1,-2,
2,1,-7,0,0,-3*ER(-3),ER(-3),3*ER(-3),-ER(-3),0,0,0,0,-ER(-3),ER(-3),-1,-1,0,0,
2,0,1,2,1,1,0,0,0,0,2,-1,-2,-2,-1,2,4,-1,ER(-3),0,0,0,0,0,-ER(-3),2,1,1,0,-1,
-3*ER(-3),1,1,0,ER(-3),ER(-3),0,0,0,-20,1,4,-4,0,0,-2,1,1,-2,ER(-3),7,7,0,
3*ER(-3),-3*ER(-3),0,-2,1,-2,0,-2,3*ER(-3),-2,-ER(-3),0,3*ER(-3),-1,-ER(-3),0,
-1,-1,0,0,20,4,-4,0,0,-1,-ER(-3),ER(-3),-7,-3*ER(-3),0,-1,0,2,0,-3*ER(-3),-1,
0,0,-20,4,-4,0,1,-ER(-3),7,3*ER(-3),0,1,0,-2,0,1,20,4,-4,0,0,2,0,0,-20,-4,4,0,
-2,0,0],[20,0,2,-4,0,0,3*ER(-3),0,-3*ER(-3),-1,2,0,-1,-1,0,-1,2,0,ER(-3),0,
ER(-3),0,-ER(-3),0,0,-ER(-3),-7,1,-2,2,1,-7,0,0,3*ER(-3),-ER(-3),-3*ER(-3),
ER(-3),0,0,0,0,ER(-3),-ER(-3),-1,-1,0,0,2,0,1,2,1,1,0,0,0,0,2,-1,-2,-2,-1,2,4,
-1,-ER(-3),0,0,0,0,0,ER(-3),2,1,1,0,-1,3*ER(-3),1,1,0,-ER(-3),-ER(-3),0,0,0,
-20,1,4,-4,0,0,-2,1,1,-2,-ER(-3),7,7,0,-3*ER(-3),3*ER(-3),0,-2,1,-2,0,-2,
-3*ER(-3),-2,ER(-3),0,-3*ER(-3),-1,ER(-3),0,-1,-1,0,0,20,4,-4,0,0,-1,ER(-3),
-ER(-3),-7,3*ER(-3),0,-1,0,2,0,3*ER(-3),-1,0,0,-20,4,-4,0,1,ER(-3),7,
-3*ER(-3),0,1,0,-2,0,1,20,4,-4,0,0,2,0,0,-20,-4,4,0,-2,0,0],[21,-9,3,5,-3,-1,
0,-1,0,2,3,1,0,0,1,2,-1,1,0,-1,0,-1,0,-1,-1,0,-6,0,-1,-1,0,-6,1,1,0,0,0,0,-1,
3,-1,3,0,0,0,0,1,1,-1,-1,-2,-1,-2,0,-1,1,1,3,-1,0,-1,-1,0,-1,1,-2,0,1,1,1,-1,
1,0,3,0,0,-1,0,0,0,-2,1,0,0,-1,1,3,21,0,5,1,-1,-1,3,2,2,-1,0,-6,-6,3,0,0,-1,
-1,0,-1,-9,3,0,3,0,-3,0,-2,0,1,-2,0,1,3,21,1,5,-1,-1,2,0,0,-6,0,3,0,-9,3,-3,0,
0,1,3,21,5,1,-1,2,0,-6,0,3,0,-9,3,-3,0,21,1,5,-1,-9,3,-3,-1,21,1,5,-9,3,-3,
-1],[21,9,3,5,3,1,0,1,0,2,3,1,0,0,1,2,-1,-1,0,1,0,1,0,1,1,0,-6,0,-1,-1,0,-6,
-1,-1,0,0,0,0,1,-3,1,-3,0,0,0,0,1,1,-1,-1,-2,-1,-2,0,-1,-1,-1,-3,-1,0,-1,-1,0,
-1,1,-2,0,-1,-1,-1,1,-1,0,3,0,0,1,0,0,0,-2,1,0,0,-1,1,-3,21,0,5,1,1,1,3,2,2,
-1,0,-6,-6,-3,0,0,1,-1,0,-1,9,3,0,3,0,3,0,-2,0,1,-2,0,1,-3,21,1,5,1,1,2,0,0,
-6,0,-3,0,9,3,3,0,0,1,-3,21,5,1,1,2,0,-6,0,-3,0,9,3,3,0,21,1,5,1,9,3,3,1,21,1,
5,9,3,3,1],[21,11,6,5,2,3,(7+ER(-3))/2,3,(7-ER(-3))/2,-E(3)^2,0,1,
(3+ER(-3))/2,(3-ER(-3))/2,1,-E(3),2,1,-E(3)^2,0,-E(3),0,-E(3)^2,0,0,-E(3),
3*E(3)^2,0,2,2,0,3*E(3),1,1,(-5+3*ER(-3))/2,-E(3)^2,(-5-3*ER(-3))/2,-E(3),0,
2*E(3)^2,0,2*E(3),-E(3)^2,-E(3),(-3-ER(-3))/2,(-3+ER(-3))/2,E(3),E(3)^2,
2*E(3),-E(3)^2,E(3)^2,2*E(3)^2,E(3),0,-E(3),E(3)^2,E(3),2,2*E(3),0,2*E(3)^2,
2*E(3),0,2*E(3)^2,1,1,-1,E(3),E(3),E(3)^2,0,E(3)^2,-1,0,0,ER(-3),0,0,
(-5-3*ER(-3))/2,(-3-ER(-3))/2,1,E(3),-1,-1,-1,E(3),-E(3),21*E(3)^2,-ER(-3),
5*E(3)^2,E(3)^2,3*E(3)^2,3*E(3)^2,0,-E(3),-1,2*E(3)^2,-E(3),3*E(3),3,2*E(3),
(7+ER(-3))/2,-1+2*ER(-3),0,2,(3+ER(-3))/2,2*E(3),11*E(3)^2,0,-1-2*ER(-3),
6*E(3)^2,-1,2*E(3)^2,-1+2*ER(-3),E(3)^2,-E(3)^2,1,E(3),0,E(3)^2,-1,21*E(3),
E(3),5*E(3),3*E(3),3*E(3),-1,-1,-E(3)^2,3,-1-2*ER(-3),2,-ER(-3),11*E(3),
6*E(3),2*E(3),(7-ER(-3))/2,ER(-3),E(3)^2,-E(3)^2,21,5,1,3,-E(3)^2,-E(3),
3*E(3)^2,(-5+3*ER(-3))/2,2*E(3)^2,(-3+ER(-3))/2,11,6,2,(3-ER(-3))/2,21*E(3)^2,
E(3)^2,5*E(3)^2,0,11*E(3)^2,6*E(3)^2,2*E(3)^2,3*E(3)^2,21*E(3),E(3),5*E(3),
11*E(3),6*E(3),2*E(3),3*E(3)],[21,-11,6,5,-2,-3,(-7-ER(-3))/2,-3,
(-7+ER(-3))/2,-E(3)^2,0,1,(3+ER(-3))/2,(3-ER(-3))/2,1,-E(3),2,-1,E(3)^2,0,
E(3),0,E(3)^2,0,0,E(3),3*E(3)^2,0,2,2,0,3*E(3),-1,-1,(5-3*ER(-3))/2,E(3)^2,
(5+3*ER(-3))/2,E(3),0,-2*E(3)^2,0,-2*E(3),E(3)^2,E(3),(-3-ER(-3))/2,
(-3+ER(-3))/2,E(3),E(3)^2,2*E(3),-E(3)^2,E(3)^2,2*E(3)^2,E(3),0,-E(3),-E(3)^2,
-E(3),-2,2*E(3),0,2*E(3)^2,2*E(3),0,2*E(3)^2,1,1,1,-E(3),-E(3),-E(3)^2,0,
-E(3)^2,1,0,0,ER(-3),0,0,(5+3*ER(-3))/2,(-3-ER(-3))/2,1,E(3),1,1,-1,E(3),E(3),
21*E(3)^2,-ER(-3),5*E(3)^2,E(3)^2,-3*E(3)^2,-3*E(3)^2,0,-E(3),-1,2*E(3)^2,
E(3),3*E(3),3,-2*E(3),(-7-ER(-3))/2,1-2*ER(-3),0,2,(3+ER(-3))/2,2*E(3),
-11*E(3)^2,0,1+2*ER(-3),6*E(3)^2,1,-2*E(3)^2,1-2*ER(-3),E(3)^2,E(3)^2,1,E(3),
0,E(3)^2,1,21*E(3),E(3),5*E(3),-3*E(3),-3*E(3),-1,1,E(3)^2,3,1+2*ER(-3),-2,
-ER(-3),-11*E(3),6*E(3),-2*E(3),(-7+ER(-3))/2,ER(-3),E(3)^2,E(3)^2,21,5,1,-3,
-E(3)^2,E(3),3*E(3)^2,(5-3*ER(-3))/2,-2*E(3)^2,(-3+ER(-3))/2,-11,6,-2,
(3-ER(-3))/2,21*E(3)^2,E(3)^2,5*E(3)^2,0,-11*E(3)^2,6*E(3)^2,-2*E(3)^2,
-3*E(3)^2,21*E(3),E(3),5*E(3),-11*E(3),6*E(3),-2*E(3),-3*E(3)],[21,11,6,5,2,3,
(7-ER(-3))/2,3,(7+ER(-3))/2,-E(3),0,1,(3-ER(-3))/2,(3+ER(-3))/2,1,-E(3)^2,2,1,
-E(3),0,-E(3)^2,0,-E(3),0,0,-E(3)^2,3*E(3),0,2,2,0,3*E(3)^2,1,1,
(-5-3*ER(-3))/2,-E(3),(-5+3*ER(-3))/2,-E(3)^2,0,2*E(3),0,2*E(3)^2,-E(3),
-E(3)^2,(-3+ER(-3))/2,(-3-ER(-3))/2,E(3)^2,E(3),2*E(3)^2,-E(3),E(3),2*E(3),
E(3)^2,0,-E(3)^2,E(3),E(3)^2,2,2*E(3)^2,0,2*E(3),2*E(3)^2,0,2*E(3),1,1,-1,
E(3)^2,E(3)^2,E(3),0,E(3),-1,0,0,-ER(-3),0,0,(-5+3*ER(-3))/2,(-3+ER(-3))/2,1,
E(3)^2,-1,-1,-1,E(3)^2,-E(3)^2,21*E(3),ER(-3),5*E(3),E(3),3*E(3),3*E(3),0,
-E(3)^2,-1,2*E(3),-E(3)^2,3*E(3)^2,3,2*E(3)^2,(7-ER(-3))/2,-1-2*ER(-3),0,2,
(3-ER(-3))/2,2*E(3)^2,11*E(3),0,-1+2*ER(-3),6*E(3),-1,2*E(3),-1-2*ER(-3),E(3),
-E(3),1,E(3)^2,0,E(3),-1,21*E(3)^2,E(3)^2,5*E(3)^2,3*E(3)^2,3*E(3)^2,-1,-1,
-E(3),3,-1+2*ER(-3),2,ER(-3),11*E(3)^2,6*E(3)^2,2*E(3)^2,(7+ER(-3))/2,-ER(-3),
E(3),-E(3),21,5,1,3,-E(3),-E(3)^2,3*E(3),(-5-3*ER(-3))/2,2*E(3),(-3-ER(-3))/2,
11,6,2,(3+ER(-3))/2,21*E(3),E(3),5*E(3),0,11*E(3),6*E(3),2*E(3),3*E(3),
21*E(3)^2,E(3)^2,5*E(3)^2,11*E(3)^2,6*E(3)^2,2*E(3)^2,3*E(3)^2],[21,-11,6,5,
-2,-3,(-7+ER(-3))/2,-3,(-7-ER(-3))/2,-E(3),0,1,(3-ER(-3))/2,(3+ER(-3))/2,1,
-E(3)^2,2,-1,E(3),0,E(3)^2,0,E(3),0,0,E(3)^2,3*E(3),0,2,2,0,3*E(3)^2,-1,-1,
(5+3*ER(-3))/2,E(3),(5-3*ER(-3))/2,E(3)^2,0,-2*E(3),0,-2*E(3)^2,E(3),E(3)^2,
(-3+ER(-3))/2,(-3-ER(-3))/2,E(3)^2,E(3),2*E(3)^2,-E(3),E(3),2*E(3),E(3)^2,0,
-E(3)^2,-E(3),-E(3)^2,-2,2*E(3)^2,0,2*E(3),2*E(3)^2,0,2*E(3),1,1,1,-E(3)^2,
-E(3)^2,-E(3),0,-E(3),1,0,0,-ER(-3),0,0,(5-3*ER(-3))/2,(-3+ER(-3))/2,1,E(3)^2,
1,1,-1,E(3)^2,E(3)^2,21*E(3),ER(-3),5*E(3),E(3),-3*E(3),-3*E(3),0,-E(3)^2,-1,
2*E(3),E(3)^2,3*E(3)^2,3,-2*E(3)^2,(-7+ER(-3))/2,1+2*ER(-3),0,2,(3-ER(-3))/2,
2*E(3)^2,-11*E(3),0,1-2*ER(-3),6*E(3),1,-2*E(3),1+2*ER(-3),E(3),E(3),1,E(3)^2,
0,E(3),1,21*E(3)^2,E(3)^2,5*E(3)^2,-3*E(3)^2,-3*E(3)^2,-1,1,E(3),3,1-2*ER(-3),
-2,ER(-3),-11*E(3)^2,6*E(3)^2,-2*E(3)^2,(-7-ER(-3))/2,-ER(-3),E(3),E(3),21,5,
1,-3,-E(3),E(3)^2,3*E(3),(5+3*ER(-3))/2,-2*E(3),(-3-ER(-3))/2,-11,6,-2,
(3+ER(-3))/2,21*E(3),E(3),5*E(3),0,-11*E(3),6*E(3),-2*E(3),-3*E(3),21*E(3)^2,
E(3)^2,5*E(3)^2,-11*E(3)^2,6*E(3)^2,-2*E(3)^2,-3*E(3)^2],[35,-15,8,3,0,-3,-6,
1,-6,0,-1,0,2,2,-1,0,0,0,0,0,0,0,0,0,1,0,8,0,0,3,0,8,1,0,-6,0,-6,0,1,-3,1,-3,
-2,-2,2,2,0,0,3,-1,0,3,0,-1,-1,0,0,-3,0,0,3,3,0,0,3,0,-2,0,1,0,0,1,-2,-1,0,2,
0,-1,-6,2,0,-1,0,0,-1,0,1,35,2,3,3,-3,1,-1,0,0,0,0,8,8,-3,-6,-6,1,3,2,0,-15,
-1,-6,8,0,0,-6,0,0,0,0,0,-1,1,35,3,3,-3,1,0,0,-2,8,-6,-3,2,-15,8,0,-6,2,0,1,
35,3,3,-3,0,-2,8,-6,-3,2,-15,8,0,2,35,3,3,0,-15,8,0,-3,35,3,3,-15,8,0,-3],[35,
15,8,3,0,3,6,-1,6,0,-1,0,2,2,-1,0,0,0,0,0,0,0,0,0,-1,0,8,0,0,3,0,8,-1,0,6,0,6,
0,-1,3,-1,3,2,2,2,2,0,0,3,-1,0,3,0,-1,-1,0,0,3,0,0,3,3,0,0,3,0,2,0,-1,0,0,-1,
2,-1,0,2,0,-1,6,2,0,-1,0,0,-1,0,-1,35,2,3,3,3,-1,-1,0,0,0,0,8,8,3,6,6,-1,3,2,
0,15,-1,6,8,0,0,6,0,0,0,0,0,-1,-1,35,3,3,3,-1,0,0,2,8,6,3,2,15,8,0,6,2,0,-1,
35,3,3,3,0,2,8,6,3,2,15,8,0,2,35,3,3,0,15,8,0,3,35,3,3,15,8,0,3],[35,-5,-1,3,
1,-1,4,-5,4,0,-1,0,-1,-1,-1,0,3,0,1,-1,1,-1,1,-1,1,1,8,0,3,0,0,8,-1,0,4,1,4,1,
-2,-2,1,-2,0,0,-1,-1,0,0,0,-1,0,0,0,2,-1,0,0,-2,3,0,0,0,0,3,3,0,0,0,-1,0,-1,
-1,0,8,0,-1,-1,2,4,-1,0,-1,1,1,-1,0,3,35,-1,3,3,-1,-5,-1,0,0,3,1,8,8,-2,4,4,
-2,0,-1,3,-5,8,4,-1,1,1,4,0,1,0,0,0,-1,3,35,3,3,-1,-5,0,1,0,8,4,-2,-1,-5,-1,1,
4,-1,0,3,35,3,3,-1,0,0,8,4,-2,-1,-5,-1,1,-1,35,3,3,-1,-5,-1,1,-1,35,3,3,-5,-1,
1,-1],[35,5,-1,3,-1,1,-4,5,-4,0,-1,0,-1,-1,-1,0,3,0,-1,1,-1,1,-1,1,-1,-1,8,0,
3,0,0,8,1,0,-4,-1,-4,-1,2,2,-1,2,0,0,-1,-1,0,0,0,-1,0,0,0,2,-1,0,0,2,3,0,0,0,
0,3,3,0,0,0,1,0,1,1,0,8,0,-1,1,2,-4,-1,0,-1,-1,-1,-1,0,-3,35,-1,3,3,1,5,-1,0,
0,3,-1,8,8,2,-4,-4,2,0,-1,3,5,8,-4,-1,-1,-1,-4,0,-1,0,0,0,-1,-3,35,3,3,1,5,0,
-1,0,8,-4,2,-1,5,-1,-1,-4,-1,0,-3,35,3,3,1,0,0,8,-4,2,-1,5,-1,-1,-1,35,3,3,1,
5,-1,-1,1,35,3,3,5,-1,-1,1],[56,-24,11,8,-3,-4,-6,0,-6,2,2,1,2,2,0,2,-1,1,0,
-1,0,-1,0,-1,0,0,2,0,1,2,0,2,0,-1,-6,0,-6,0,0,0,0,0,0,0,2,2,-1,-1,2,0,0,2,0,1,
0,-1,-1,0,-1,0,-2,-2,0,-1,0,0,0,1,0,1,1,0,0,2,0,-2,1,-1,6,-2,0,0,0,0,0,1,0,
-56,-2,-8,0,4,0,-2,-2,-2,1,0,-2,-2,0,6,6,0,-2,-2,1,24,-2,6,-11,0,3,-6,0,0,-1,
0,0,0,0,56,0,8,-4,0,2,0,0,2,-6,0,2,-24,11,-3,6,2,1,0,-56,-8,0,4,-2,0,-2,6,0,
-2,24,-11,3,-2,56,0,8,1,-24,11,-3,-4,-56,0,-8,24,-11,3,4],[56,24,11,8,3,4,6,0,
6,2,2,1,2,2,0,2,-1,-1,0,1,0,1,0,1,0,0,2,0,1,2,0,2,0,1,6,0,6,0,0,0,0,0,0,0,2,2,
-1,-1,2,0,0,2,0,1,0,1,1,0,-1,0,-2,-2,0,-1,0,0,0,-1,0,-1,-1,0,0,2,0,-2,-1,-1,
-6,-2,0,0,0,0,0,1,0,-56,-2,-8,0,-4,0,-2,-2,-2,1,0,-2,-2,0,-6,-6,0,-2,-2,1,-24,
-2,-6,-11,0,-3,6,0,0,-1,0,0,0,0,56,0,8,4,0,2,0,0,2,6,0,2,24,11,3,-6,2,1,0,-56,
-8,0,-4,-2,0,-2,-6,0,-2,-24,-11,-3,-2,56,0,8,-1,24,11,3,4,-56,0,-8,-24,-11,-3,
-4],[56,-16,2,8,-4,0,2,0,2,2,2,1,-1,-1,0,2,2,-1,-1,0,1,0,1,0,0,-1,2,0,-2,-1,0,
2,0,1,2,-1,2,-1,3,-1,0,-1,0,0,-1,-1,-1,-1,-1,0,0,-1,0,-2,0,1,1,1,2,0,1,1,0,2,
0,0,0,-1,0,-1,0,0,0,11,0,1,0,2,-2,1,0,0,1,-1,0,1,0,-56,1,-8,0,0,0,-2,-2,-2,-2,
1,-2,-2,1,-2,-2,-3,1,1,-2,16,-11,-2,-2,1,4,2,0,1,-1,0,0,0,0,56,0,8,0,0,2,-1,0,
2,2,-1,-1,-16,2,-4,-2,-1,1,0,-56,-8,0,0,-2,0,-2,-2,1,1,16,-2,4,1,56,0,8,0,-16,
2,-4,0,-56,0,-8,16,-2,4,0],[56,16,2,8,4,0,-2,0,-2,2,2,1,-1,-1,0,2,2,1,1,0,-1,
0,-1,0,0,1,2,0,-2,-1,0,2,0,-1,-2,1,-2,1,-3,1,0,1,0,0,-1,-1,-1,-1,-1,0,0,-1,0,
-2,0,-1,-1,-1,2,0,1,1,0,2,0,0,0,1,0,1,0,0,0,11,0,1,0,2,2,1,0,0,-1,1,0,1,0,-56,
1,-8,0,0,0,-2,-2,-2,-2,-1,-2,-2,-1,2,2,3,1,1,-2,-16,-11,2,-2,-1,-4,-2,0,-1,-1,
0,0,0,0,56,0,8,0,0,2,1,0,2,-2,1,-1,16,2,4,2,-1,1,0,-56,-8,0,0,-2,0,-2,2,-1,1,
-16,-2,-4,1,56,0,8,0,16,2,4,0,-56,0,-8,-16,-2,-4,0],[70,-20,7,2,1,-2,-2,0,-2,
-4,-2,0,1,1,0,-4,-1,0,1,1,-1,1,-1,1,0,1,16,0,1,-1,0,16,0,0,-2,1,-2,1,3,-5,0,
-5,0,0,1,1,0,0,-1,0,2,-1,2,-1,0,0,0,5,-1,0,1,1,0,-1,2,-2,0,0,0,0,-1,0,0,7,0,
-1,-1,1,2,-1,2,0,-1,1,0,0,0,-70,-1,-2,-2,2,0,2,4,4,1,-1,-16,-16,5,2,2,-3,1,-1,
1,20,-7,2,-7,-1,-1,-2,-2,-1,0,-2,0,0,0,70,2,2,-2,0,-4,1,0,16,-2,-5,1,-20,7,1,
2,1,0,0,-70,-2,-2,2,4,0,-16,2,5,-1,20,-7,-1,-1,70,2,2,-1,-20,7,1,-2,-70,-2,-2,
20,-7,-1,2],[70,20,7,2,-1,2,2,0,2,-4,-2,0,1,1,0,-4,-1,0,-1,-1,1,-1,1,-1,0,-1,
16,0,1,-1,0,16,0,0,2,-1,2,-1,-3,5,0,5,0,0,1,1,0,0,-1,0,2,-1,2,-1,0,0,0,-5,-1,
0,1,1,0,-1,2,-2,0,0,0,0,1,0,0,7,0,-1,1,1,-2,-1,2,0,1,-1,0,0,0,-70,-1,-2,-2,-2,
0,2,4,4,1,1,-16,-16,-5,-2,-2,3,1,-1,1,-20,-7,-2,-7,1,1,2,-2,1,0,-2,0,0,0,70,2,
2,2,0,-4,-1,0,16,2,5,1,20,7,-1,-2,1,0,0,-70,-2,-2,-2,4,0,-16,-2,-5,-1,-20,-7,
1,-1,70,2,2,1,20,7,-1,2,-70,-2,-2,-20,-7,1,-2],[70,-20,7,2,1,-2,-2-3*ER(-3),0,
-2+3*ER(-3),-1,-2,0,(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,-1,-1,0,E(3),1,-E(3)^2,
1,-E(3),1,0,E(3)^2,-11,0,1,2,0,-11,0,0,-2-3*ER(-3),E(3)^2,-2+3*ER(-3),E(3),0,
4,0,4,-ER(-3),ER(-3),(-1-3*ER(-3))/2,(-1+3*ER(-3))/2,0,0,2,0,-1,2,-1,-1,0,0,0,
-4,-1,0,-2,-2,0,-1,2,1,ER(-3),0,0,0,-1,0,-ER(-3),-2,0,(1+3*ER(-3))/2,-1,1,
2-3*ER(-3),(1+3*ER(-3))/2,-1,0,-E(3),E(3)^2,0,0,0,-70,(1-3*ER(-3))/2,-2,-2,2,
0,2,1,1,1,-E(3),11,11,-4,2+3*ER(-3),2-3*ER(-3),0,-2,(1-3*ER(-3))/2,1,20,2,
2+3*ER(-3),-7,-E(3)^2,-1,-2+3*ER(-3),1,-E(3)^2,0,1,0,0,0,70,2,2,-2,0,-1,E(3),
ER(-3),-11,-2-3*ER(-3),4,(-1+3*ER(-3))/2,-20,7,1,2-3*ER(-3),(-1-3*ER(-3))/2,0,
0,-70,-2,-2,2,1,-ER(-3),11,2+3*ER(-3),-4,(1-3*ER(-3))/2,20,-7,-1,
(1+3*ER(-3))/2,70,2,2,-1,-20,7,1,-2,-70,-2,-2,20,-7,-1,2],[70,-20,7,2,1,-2,
-2+3*ER(-3),0,-2-3*ER(-3),-1,-2,0,(-1-3*ER(-3))/2,(-1+3*ER(-3))/2,0,-1,-1,0,
E(3)^2,1,-E(3),1,-E(3)^2,1,0,E(3),-11,0,1,2,0,-11,0,0,-2+3*ER(-3),E(3),
-2-3*ER(-3),E(3)^2,0,4,0,4,ER(-3),-ER(-3),(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,0,
2,0,-1,2,-1,-1,0,0,0,-4,-1,0,-2,-2,0,-1,2,1,-ER(-3),0,0,0,-1,0,ER(-3),-2,0,
(1-3*ER(-3))/2,-1,1,2+3*ER(-3),(1-3*ER(-3))/2,-1,0,-E(3)^2,E(3),0,0,0,-70,
(1+3*ER(-3))/2,-2,-2,2,0,2,1,1,1,-E(3)^2,11,11,-4,2-3*ER(-3),2+3*ER(-3),0,-2,
(1+3*ER(-3))/2,1,20,2,2-3*ER(-3),-7,-E(3),-1,-2-3*ER(-3),1,-E(3),0,1,0,0,0,70,
2,2,-2,0,-1,E(3)^2,-ER(-3),-11,-2+3*ER(-3),4,(-1-3*ER(-3))/2,-20,7,1,
2+3*ER(-3),(-1+3*ER(-3))/2,0,0,-70,-2,-2,2,1,ER(-3),11,2-3*ER(-3),-4,
(1+3*ER(-3))/2,20,-7,-1,(1-3*ER(-3))/2,70,2,2,-1,-20,7,1,-2,-70,-2,-2,20,-7,
-1,2],[70,20,7,2,-1,2,2-3*ER(-3),0,2+3*ER(-3),-1,-2,0,(-1-3*ER(-3))/2,
(-1+3*ER(-3))/2,0,-1,-1,0,-E(3)^2,-1,E(3),-1,E(3)^2,-1,0,-E(3),-11,0,1,2,0,
-11,0,0,2-3*ER(-3),-E(3),2+3*ER(-3),-E(3)^2,0,-4,0,-4,-ER(-3),ER(-3),
(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,0,2,0,-1,2,-1,-1,0,0,0,4,-1,0,-2,-2,0,-1,2,
1,ER(-3),0,0,0,1,0,-ER(-3),-2,0,(1-3*ER(-3))/2,1,1,-2-3*ER(-3),(1-3*ER(-3))/2,
-1,0,E(3)^2,-E(3),0,0,0,-70,(1+3*ER(-3))/2,-2,-2,-2,0,2,1,1,1,E(3)^2,11,11,4,
-2+3*ER(-3),-2-3*ER(-3),0,-2,(1+3*ER(-3))/2,1,-20,2,-2+3*ER(-3),-7,E(3),1,
2+3*ER(-3),1,E(3),0,1,0,0,0,70,2,2,2,0,-1,-E(3)^2,ER(-3),-11,2-3*ER(-3),-4,
(-1-3*ER(-3))/2,20,7,-1,-2-3*ER(-3),(-1+3*ER(-3))/2,0,0,-70,-2,-2,-2,1,
-ER(-3),11,-2+3*ER(-3),4,(1+3*ER(-3))/2,-20,-7,1,(1-3*ER(-3))/2,70,2,2,1,20,7,
-1,2,-70,-2,-2,-20,-7,1,-2],[70,20,7,2,-1,2,2+3*ER(-3),0,2-3*ER(-3),-1,-2,0,
(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,-1,-1,0,-E(3),-1,E(3)^2,-1,E(3),-1,0,
-E(3)^2,-11,0,1,2,0,-11,0,0,2+3*ER(-3),-E(3)^2,2-3*ER(-3),-E(3),0,-4,0,-4,
ER(-3),-ER(-3),(-1-3*ER(-3))/2,(-1+3*ER(-3))/2,0,0,2,0,-1,2,-1,-1,0,0,0,4,-1,
0,-2,-2,0,-1,2,1,-ER(-3),0,0,0,1,0,ER(-3),-2,0,(1+3*ER(-3))/2,1,1,-2+3*ER(-3),
(1+3*ER(-3))/2,-1,0,E(3),-E(3)^2,0,0,0,-70,(1-3*ER(-3))/2,-2,-2,-2,0,2,1,1,1,
E(3),11,11,4,-2-3*ER(-3),-2+3*ER(-3),0,-2,(1-3*ER(-3))/2,1,-20,2,-2-3*ER(-3),
-7,E(3)^2,1,2-3*ER(-3),1,E(3)^2,0,1,0,0,0,70,2,2,2,0,-1,-E(3),-ER(-3),-11,
2+3*ER(-3),-4,(-1+3*ER(-3))/2,20,7,-1,-2+3*ER(-3),(-1-3*ER(-3))/2,0,0,-70,-2,
-2,-2,1,ER(-3),11,-2-3*ER(-3),4,(1-3*ER(-3))/2,-20,-7,1,(1+3*ER(-3))/2,70,2,2,
1,20,7,-1,2,-70,-2,-2,-20,-7,1,-2],[84,16,6,-4,-2,0,(11+7*ER(-3))/2,0,
(11-7*ER(-3))/2,-E(3),0,-1,ER(-3),-ER(-3),0,-E(3)^2,2,1,1,0,-1,0,-1,0,0,1,
-15*E(3),0,-2,2,0,-15*E(3)^2,0,-1,(5-9*ER(-3))/2,E(3)^2,(5+9*ER(-3))/2,E(3),0,
-2*E(3),0,-2*E(3)^2,(3+ER(-3))/2,(3-ER(-3))/2,(3+ER(-3))/2,(3-ER(-3))/2,
E(3)^2,E(3),2*E(3)^2,0,E(3),2*E(3),E(3)^2,0,0,-E(3),-E(3)^2,2,2*E(3)^2,0,
-2*E(3),-2*E(3)^2,0,2*E(3),4,-1,ER(-3),E(3)^2,0,E(3),0,0,-ER(-3),0,0,
(3-ER(-3))/2,0,0,(-5-9*ER(-3))/2,(-3-ER(-3))/2,1,0,-E(3)^2,E(3),0,-E(3)^2,0,
-84*E(3),(3+ER(-3))/2,4*E(3),-4*E(3),0,0,0,E(3)^2,1,-2*E(3),-E(3),15*E(3)^2,
15,2*E(3)^2,(-11-7*ER(-3))/2,8+ER(-3),0,-2,-ER(-3),-2*E(3)^2,-16*E(3),0,
8-ER(-3),-6*E(3),-E(3),2*E(3),-8-ER(-3),-E(3),-E(3)^2,1,-E(3)^2,0,0,0,
84*E(3)^2,4*E(3)^2,-4*E(3)^2,0,0,-1,E(3)^2,(-3-ER(-3))/2,-15,-8+ER(-3),-2,
(-3-ER(-3))/2,16*E(3)^2,6*E(3)^2,-2*E(3)^2,(-11+7*ER(-3))/2,(-3+ER(-3))/2,
-E(3),0,-84,4,-4,0,E(3),(-3+ER(-3))/2,15*E(3),(-5+9*ER(-3))/2,2*E(3),
(-3+ER(-3))/2,-16,-6,2,ER(-3),84*E(3),4*E(3),-4*E(3),0,16*E(3),6*E(3),-2*E(3),
0,-84*E(3)^2,-4*E(3)^2,4*E(3)^2,-16*E(3)^2,-6*E(3)^2,2*E(3)^2,0],[84,-16,6,-4,
2,0,(-11+7*ER(-3))/2,0,(-11-7*ER(-3))/2,-E(3)^2,0,-1,-ER(-3),ER(-3),0,-E(3),2,
-1,-1,0,1,0,1,0,0,-1,-15*E(3)^2,0,-2,2,0,-15*E(3),0,1,(-5-9*ER(-3))/2,-E(3),
(-5+9*ER(-3))/2,-E(3)^2,0,2*E(3)^2,0,2*E(3),(-3+ER(-3))/2,(-3-ER(-3))/2,
(3-ER(-3))/2,(3+ER(-3))/2,E(3),E(3)^2,2*E(3),0,E(3)^2,2*E(3)^2,E(3),0,0,
E(3)^2,E(3),-2,2*E(3),0,-2*E(3)^2,-2*E(3),0,2*E(3)^2,4,-1,ER(-3),-E(3),0,
-E(3)^2,0,0,-ER(-3),0,0,(3+ER(-3))/2,0,0,(5-9*ER(-3))/2,(-3+ER(-3))/2,1,0,
E(3),-E(3)^2,0,-E(3),0,-84*E(3)^2,(3-ER(-3))/2,4*E(3)^2,-4*E(3)^2,0,0,0,E(3),
1,-2*E(3)^2,E(3)^2,15*E(3),15,-2*E(3),(11-7*ER(-3))/2,-8+ER(-3),0,-2,ER(-3),
-2*E(3),16*E(3)^2,0,-8-ER(-3),-6*E(3)^2,E(3)^2,-2*E(3)^2,8-ER(-3),-E(3)^2,
E(3),1,-E(3),0,0,0,84*E(3),4*E(3),-4*E(3),0,0,-1,-E(3),(3-ER(-3))/2,-15,
8+ER(-3),2,(-3+ER(-3))/2,-16*E(3),6*E(3),2*E(3),(11+7*ER(-3))/2,(-3-ER(-3))/2,
-E(3)^2,0,-84,4,-4,0,E(3)^2,(3+ER(-3))/2,15*E(3)^2,(5+9*ER(-3))/2,-2*E(3)^2,
(-3-ER(-3))/2,16,-6,-2,-ER(-3),84*E(3)^2,4*E(3)^2,-4*E(3)^2,0,-16*E(3)^2,
6*E(3)^2,2*E(3)^2,0,-84*E(3),-4*E(3),4*E(3),16*E(3),-6*E(3),-2*E(3),0],[84,16,
6,-4,-2,0,(11-7*ER(-3))/2,0,(11+7*ER(-3))/2,-E(3)^2,0,-1,-ER(-3),ER(-3),0,
-E(3),2,1,1,0,-1,0,-1,0,0,1,-15*E(3)^2,0,-2,2,0,-15*E(3),0,-1,(5+9*ER(-3))/2,
E(3),(5-9*ER(-3))/2,E(3)^2,0,-2*E(3)^2,0,-2*E(3),(3-ER(-3))/2,(3+ER(-3))/2,
(3-ER(-3))/2,(3+ER(-3))/2,E(3),E(3)^2,2*E(3),0,E(3)^2,2*E(3)^2,E(3),0,0,
-E(3)^2,-E(3),2,2*E(3),0,-2*E(3)^2,-2*E(3),0,2*E(3)^2,4,-1,-ER(-3),E(3),0,
E(3)^2,0,0,ER(-3),0,0,(3+ER(-3))/2,0,0,(-5+9*ER(-3))/2,(-3+ER(-3))/2,1,0,
-E(3),E(3)^2,0,-E(3),0,-84*E(3)^2,(3-ER(-3))/2,4*E(3)^2,-4*E(3)^2,0,0,0,E(3),
1,-2*E(3)^2,-E(3)^2,15*E(3),15,2*E(3),(-11+7*ER(-3))/2,8-ER(-3),0,-2,ER(-3),
-2*E(3),-16*E(3)^2,0,8+ER(-3),-6*E(3)^2,-E(3)^2,2*E(3)^2,-8+ER(-3),-E(3)^2,
-E(3),1,-E(3),0,0,0,84*E(3),4*E(3),-4*E(3),0,0,-1,E(3),(-3+ER(-3))/2,-15,
-8-ER(-3),-2,(-3+ER(-3))/2,16*E(3),6*E(3),-2*E(3),(-11-7*ER(-3))/2,
(-3-ER(-3))/2,-E(3)^2,0,-84,4,-4,0,E(3)^2,(-3-ER(-3))/2,15*E(3)^2,
(-5-9*ER(-3))/2,2*E(3)^2,(-3-ER(-3))/2,-16,-6,2,-ER(-3),84*E(3)^2,4*E(3)^2,
-4*E(3)^2,0,16*E(3)^2,6*E(3)^2,-2*E(3)^2,0,-84*E(3),-4*E(3),4*E(3),-16*E(3),
-6*E(3),2*E(3),0],[84,-16,6,-4,2,0,(-11-7*ER(-3))/2,0,(-11+7*ER(-3))/2,-E(3),
0,-1,ER(-3),-ER(-3),0,-E(3)^2,2,-1,-1,0,1,0,1,0,0,-1,-15*E(3),0,-2,2,0,
-15*E(3)^2,0,1,(-5+9*ER(-3))/2,-E(3)^2,(-5-9*ER(-3))/2,-E(3),0,2*E(3),0,
2*E(3)^2,(-3-ER(-3))/2,(-3+ER(-3))/2,(3+ER(-3))/2,(3-ER(-3))/2,E(3)^2,E(3),
2*E(3)^2,0,E(3),2*E(3),E(3)^2,0,0,E(3),E(3)^2,-2,2*E(3)^2,0,-2*E(3),-2*E(3)^2,
0,2*E(3),4,-1,-ER(-3),-E(3)^2,0,-E(3),0,0,ER(-3),0,0,(3-ER(-3))/2,0,0,
(5+9*ER(-3))/2,(-3-ER(-3))/2,1,0,E(3)^2,-E(3),0,-E(3)^2,0,-84*E(3),
(3+ER(-3))/2,4*E(3),-4*E(3),0,0,0,E(3)^2,1,-2*E(3),E(3),15*E(3)^2,15,
-2*E(3)^2,(11+7*ER(-3))/2,-8-ER(-3),0,-2,-ER(-3),-2*E(3)^2,16*E(3),0,
-8+ER(-3),-6*E(3),E(3),-2*E(3),8+ER(-3),-E(3),E(3)^2,1,-E(3)^2,0,0,0,
84*E(3)^2,4*E(3)^2,-4*E(3)^2,0,0,-1,-E(3)^2,(3+ER(-3))/2,-15,8-ER(-3),2,
(-3-ER(-3))/2,-16*E(3)^2,6*E(3)^2,2*E(3)^2,(11-7*ER(-3))/2,(-3+ER(-3))/2,
-E(3),0,-84,4,-4,0,E(3),(3-ER(-3))/2,15*E(3),(5-9*ER(-3))/2,-2*E(3),
(-3+ER(-3))/2,16,-6,-2,ER(-3),84*E(3),4*E(3),-4*E(3),0,-16*E(3),6*E(3),2*E(3),
0,-84*E(3)^2,-4*E(3)^2,4*E(3)^2,16*E(3)^2,-6*E(3)^2,-2*E(3)^2,0],[90,30,9,10,
3,2,3,6,3,1,0,0,0,0,2,1,1,0,0,-1,0,-1,0,-1,0,0,9,-1,1,1,-1,9,0,0,3,0,3,0,3,3,
0,3,-1,-1,0,0,0,0,1,0,1,1,1,0,0,0,0,3,1,-1,1,1,-1,1,-2,1,-1,0,0,0,-1,0,-1,9,
-1,0,-1,0,3,0,1,2,0,0,0,0,2,90,0,10,-2,2,6,0,1,1,1,0,9,9,3,3,3,3,1,0,1,30,9,3,
9,0,3,3,1,0,0,1,-1,2,2,90,-2,10,2,6,1,0,-1,9,3,3,0,30,9,3,3,0,0,2,90,10,-2,2,
1,-1,9,3,3,0,30,9,3,0,90,-2,10,-1,30,9,3,2,90,-2,10,30,9,3,2],[90,-30,9,10,-3,
-2,-3,-6,-3,1,0,0,0,0,2,1,1,0,0,1,0,1,0,1,0,0,9,-1,1,1,-1,9,0,0,-3,0,-3,0,-3,
-3,0,-3,1,1,0,0,0,0,1,0,1,1,1,0,0,0,0,-3,1,-1,1,1,-1,1,-2,1,1,0,0,0,1,0,1,9,
-1,0,1,0,-3,0,1,2,0,0,0,0,-2,90,0,10,-2,-2,-6,0,1,1,1,0,9,9,-3,-3,-3,-3,1,0,1,
-30,9,-3,9,0,-3,-3,1,0,0,1,-1,2,-2,90,-2,10,-2,-6,1,0,1,9,-3,-3,0,-30,9,-3,-3,
0,0,-2,90,10,-2,-2,1,1,9,-3,-3,0,-30,9,-3,0,90,-2,10,1,-30,9,-3,-2,90,-2,10,
-30,9,-3,-2],[105,25,3,9,1,1,(-7-ER(-3))/2,9,(-7+ER(-3))/2,3*E(3)^2,0,0,
(-3-ER(-3))/2,(-3+ER(-3))/2,1,3*E(3),3,0,E(3)^2,E(3),E(3),E(3)^2,E(3)^2,1,0,
E(3),15*E(3)^2,0,3,0,0,15*E(3),1,0,(5-3*ER(-3))/2,E(3)^2,(5+3*ER(-3))/2,E(3),
0,4*E(3)^2,0,4*E(3),E(3)^2,E(3),(3+ER(-3))/2,(3-ER(-3))/2,0,0,0,E(3)^2,E(3)^2,
0,E(3),0,E(3),0,0,4,3*E(3),0,0,0,0,3*E(3)^2,1,1,1,0,E(3),0,1,E(3)^2,1,0,0,
-ER(-3),E(3),0,(5+3*ER(-3))/2,(3+ER(-3))/2,1,E(3),1,1,1,0,E(3),105*E(3)^2,
ER(-3),9*E(3)^2,E(3)^2,E(3)^2,9*E(3)^2,0,3*E(3),3,3*E(3)^2,E(3),15*E(3),15,
4*E(3),(-7-ER(-3))/2,1-2*ER(-3),0,0,(-3-ER(-3))/2,3*E(3),25*E(3)^2,0,
1+2*ER(-3),3*E(3)^2,1,E(3)^2,1-2*ER(-3),E(3)^2,E(3)^2,0,E(3),0,E(3)^2,1,
105*E(3),E(3),9*E(3),E(3),9*E(3),3,1,E(3)^2,15,1+2*ER(-3),4,ER(-3),25*E(3),
3*E(3),E(3),(-7+ER(-3))/2,-ER(-3),0,E(3)^2,105,9,1,1,3*E(3)^2,E(3),15*E(3)^2,
(5-3*ER(-3))/2,4*E(3)^2,(3-ER(-3))/2,25,3,1,(-3+ER(-3))/2,105*E(3)^2,E(3)^2,
9*E(3)^2,E(3)^2,25*E(3)^2,3*E(3)^2,E(3)^2,E(3)^2,105*E(3),E(3),9*E(3),25*E(3),
3*E(3),E(3),E(3)],[105,-35,12,9,-2,-3,-5+ER(-3),-3,-5-ER(-3),0,0,0,
(3-ER(-3))/2,(3+ER(-3))/2,1,0,0,0,E(3),0,E(3)^2,0,E(3),0,0,E(3)^2,-12*E(3)^2,
0,0,0,0,-12*E(3),1,0,1-3*ER(-3),1,1+3*ER(-3),1,0,4*E(3)^2,0,4*E(3),0,0,
-ER(-3),ER(-3),0,0,0,E(3)^2,-2*E(3)^2,0,-2*E(3),0,E(3),0,0,4,0,0,0,0,0,0,1,-2,
0,0,E(3),0,0,E(3)^2,0,0,0,(-3+ER(-3))/2,0,0,1+3*ER(-3),-ER(-3),-2,E(3),E(3)^2,
E(3),1,0,-3*E(3),105*E(3)^2,(-3-ER(-3))/2,9*E(3)^2,E(3)^2,-3*E(3)^2,-3*E(3)^2,
0,0,0,0,1,-12*E(3),-12,4*E(3),-5+ER(-3),4-2*ER(-3),0,0,(3-ER(-3))/2,0,
-35*E(3)^2,0,4+2*ER(-3),12*E(3)^2,E(3),-2*E(3)^2,4-2*ER(-3),-2*E(3)^2,1,0,
-2*E(3),0,E(3)^2,-3,105*E(3),E(3),9*E(3),-3*E(3),-3*E(3),0,E(3)^2,0,-12,
4+2*ER(-3),4,(-3-ER(-3))/2,-35*E(3),12*E(3),-2*E(3),-5-ER(-3),(-3+ER(-3))/2,0,
-3*E(3)^2,105,9,1,-3,0,0,-12*E(3)^2,1-3*ER(-3),4*E(3)^2,ER(-3),-35,12,-2,
(3+ER(-3))/2,105*E(3)^2,E(3)^2,9*E(3)^2,0,-35*E(3)^2,12*E(3)^2,-2*E(3)^2,
-3*E(3)^2,105*E(3),E(3),9*E(3),-35*E(3),12*E(3),-2*E(3),-3*E(3)],[105,-25,3,9,
-1,-1,(7+ER(-3))/2,-9,(7-ER(-3))/2,3*E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,1,
3*E(3),3,0,-E(3)^2,-E(3),-E(3),-E(3)^2,-E(3)^2,-1,0,-E(3),15*E(3)^2,0,3,0,0,
15*E(3),-1,0,(-5+3*ER(-3))/2,-E(3)^2,(-5-3*ER(-3))/2,-E(3),0,-4*E(3)^2,0,
-4*E(3),-E(3)^2,-E(3),(3+ER(-3))/2,(3-ER(-3))/2,0,0,0,E(3)^2,E(3)^2,0,E(3),0,
E(3),0,0,-4,3*E(3),0,0,0,0,3*E(3)^2,1,1,-1,0,-E(3),0,-1,-E(3)^2,-1,0,0,
-ER(-3),-E(3),0,(-5-3*ER(-3))/2,(3+ER(-3))/2,1,E(3),-1,-1,1,0,-E(3),
105*E(3)^2,ER(-3),9*E(3)^2,E(3)^2,-E(3)^2,-9*E(3)^2,0,3*E(3),3,3*E(3)^2,-E(3),
15*E(3),15,-4*E(3),(7+ER(-3))/2,-1+2*ER(-3),0,0,(-3-ER(-3))/2,3*E(3),
-25*E(3)^2,0,-1-2*ER(-3),3*E(3)^2,-1,-E(3)^2,-1+2*ER(-3),E(3)^2,-E(3)^2,0,
E(3),0,E(3)^2,-1,105*E(3),E(3),9*E(3),-E(3),-9*E(3),3,-1,-E(3)^2,15,
-1-2*ER(-3),-4,ER(-3),-25*E(3),3*E(3),-E(3),(7-ER(-3))/2,-ER(-3),0,-E(3)^2,
105,9,1,-1,3*E(3)^2,-E(3),15*E(3)^2,(-5+3*ER(-3))/2,-4*E(3)^2,(3-ER(-3))/2,
-25,3,-1,(-3+ER(-3))/2,105*E(3)^2,E(3)^2,9*E(3)^2,-E(3)^2,-25*E(3)^2,3*E(3)^2,
-E(3)^2,-E(3)^2,105*E(3),E(3),9*E(3),-25*E(3),3*E(3),-E(3),-E(3)],[105,35,12,
9,2,3,5-ER(-3),3,5+ER(-3),0,0,0,(3-ER(-3))/2,(3+ER(-3))/2,1,0,0,0,-E(3),0,
-E(3)^2,0,-E(3),0,0,-E(3)^2,-12*E(3)^2,0,0,0,0,-12*E(3),-1,0,-1+3*ER(-3),-1,
-1-3*ER(-3),-1,0,-4*E(3)^2,0,-4*E(3),0,0,-ER(-3),ER(-3),0,0,0,E(3)^2,
-2*E(3)^2,0,-2*E(3),0,E(3),0,0,-4,0,0,0,0,0,0,1,-2,0,0,-E(3),0,0,-E(3)^2,0,0,
0,(-3+ER(-3))/2,0,0,-1-3*ER(-3),-ER(-3),-2,E(3),-E(3)^2,-E(3),1,0,3*E(3),
105*E(3)^2,(-3-ER(-3))/2,9*E(3)^2,E(3)^2,3*E(3)^2,3*E(3)^2,0,0,0,0,-1,
-12*E(3),-12,-4*E(3),5-ER(-3),-4+2*ER(-3),0,0,(3-ER(-3))/2,0,35*E(3)^2,0,
-4-2*ER(-3),12*E(3)^2,-E(3),2*E(3)^2,-4+2*ER(-3),-2*E(3)^2,-1,0,-2*E(3),0,
E(3)^2,3,105*E(3),E(3),9*E(3),3*E(3),3*E(3),0,-E(3)^2,0,-12,-4-2*ER(-3),-4,
(-3-ER(-3))/2,35*E(3),12*E(3),2*E(3),5+ER(-3),(-3+ER(-3))/2,0,3*E(3)^2,105,9,
1,3,0,0,-12*E(3)^2,-1+3*ER(-3),-4*E(3)^2,ER(-3),35,12,2,(3+ER(-3))/2,
105*E(3)^2,E(3)^2,9*E(3)^2,0,35*E(3)^2,12*E(3)^2,2*E(3)^2,3*E(3)^2,105*E(3),
E(3),9*E(3),35*E(3),12*E(3),2*E(3),3*E(3)],[105,-35,12,9,-2,-3,-5-ER(-3),-3,
-5+ER(-3),0,0,0,(3+ER(-3))/2,(3-ER(-3))/2,1,0,0,0,E(3)^2,0,E(3),0,E(3)^2,0,0,
E(3),-12*E(3),0,0,0,0,-12*E(3)^2,1,0,1+3*ER(-3),1,1-3*ER(-3),1,0,4*E(3),0,
4*E(3)^2,0,0,ER(-3),-ER(-3),0,0,0,E(3),-2*E(3),0,-2*E(3)^2,0,E(3)^2,0,0,4,0,0,
0,0,0,0,1,-2,0,0,E(3)^2,0,0,E(3),0,0,0,(-3-ER(-3))/2,0,0,1-3*ER(-3),ER(-3),-2,
E(3)^2,E(3),E(3)^2,1,0,-3*E(3)^2,105*E(3),(-3+ER(-3))/2,9*E(3),E(3),-3*E(3),
-3*E(3),0,0,0,0,1,-12*E(3)^2,-12,4*E(3)^2,-5-ER(-3),4+2*ER(-3),0,0,
(3+ER(-3))/2,0,-35*E(3),0,4-2*ER(-3),12*E(3),E(3)^2,-2*E(3),4+2*ER(-3),
-2*E(3),1,0,-2*E(3)^2,0,E(3),-3,105*E(3)^2,E(3)^2,9*E(3)^2,-3*E(3)^2,
-3*E(3)^2,0,E(3),0,-12,4-2*ER(-3),4,(-3+ER(-3))/2,-35*E(3)^2,12*E(3)^2,
-2*E(3)^2,-5+ER(-3),(-3-ER(-3))/2,0,-3*E(3),105,9,1,-3,0,0,-12*E(3),
1+3*ER(-3),4*E(3),-ER(-3),-35,12,-2,(3-ER(-3))/2,105*E(3),E(3),9*E(3),0,
-35*E(3),12*E(3),-2*E(3),-3*E(3),105*E(3)^2,E(3)^2,9*E(3)^2,-35*E(3)^2,
12*E(3)^2,-2*E(3)^2,-3*E(3)^2],[105,-25,3,9,-1,-1,(7-ER(-3))/2,-9,
(7+ER(-3))/2,3*E(3),0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,1,3*E(3)^2,3,0,-E(3),
-E(3)^2,-E(3)^2,-E(3),-E(3),-1,0,-E(3)^2,15*E(3),0,3,0,0,15*E(3)^2,-1,0,
(-5-3*ER(-3))/2,-E(3),(-5+3*ER(-3))/2,-E(3)^2,0,-4*E(3),0,-4*E(3)^2,-E(3),
-E(3)^2,(3-ER(-3))/2,(3+ER(-3))/2,0,0,0,E(3),E(3),0,E(3)^2,0,E(3)^2,0,0,-4,
3*E(3)^2,0,0,0,0,3*E(3),1,1,-1,0,-E(3)^2,0,-1,-E(3),-1,0,0,ER(-3),-E(3)^2,0,
(-5+3*ER(-3))/2,(3-ER(-3))/2,1,E(3)^2,-1,-1,1,0,-E(3)^2,105*E(3),-ER(-3),
9*E(3),E(3),-E(3),-9*E(3),0,3*E(3)^2,3,3*E(3),-E(3)^2,15*E(3)^2,15,-4*E(3)^2,
(7-ER(-3))/2,-1-2*ER(-3),0,0,(-3+ER(-3))/2,3*E(3)^2,-25*E(3),0,-1+2*ER(-3),
3*E(3),-1,-E(3),-1-2*ER(-3),E(3),-E(3),0,E(3)^2,0,E(3),-1,105*E(3)^2,E(3)^2,
9*E(3)^2,-E(3)^2,-9*E(3)^2,3,-1,-E(3),15,-1+2*ER(-3),-4,-ER(-3),-25*E(3)^2,
3*E(3)^2,-E(3)^2,(7+ER(-3))/2,ER(-3),0,-E(3),105,9,1,-1,3*E(3),-E(3)^2,
15*E(3),(-5-3*ER(-3))/2,-4*E(3),(3+ER(-3))/2,-25,3,-1,(-3-ER(-3))/2,105*E(3),
E(3),9*E(3),-E(3),-25*E(3),3*E(3),-E(3),-E(3),105*E(3)^2,E(3)^2,9*E(3)^2,
-25*E(3)^2,3*E(3)^2,-E(3)^2,-E(3)^2],[105,25,3,9,1,1,(-7+ER(-3))/2,9,
(-7-ER(-3))/2,3*E(3),0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,1,3*E(3)^2,3,0,E(3),
E(3)^2,E(3)^2,E(3),E(3),1,0,E(3)^2,15*E(3),0,3,0,0,15*E(3)^2,1,0,
(5+3*ER(-3))/2,E(3),(5-3*ER(-3))/2,E(3)^2,0,4*E(3),0,4*E(3)^2,E(3),E(3)^2,
(3-ER(-3))/2,(3+ER(-3))/2,0,0,0,E(3),E(3),0,E(3)^2,0,E(3)^2,0,0,4,3*E(3)^2,0,
0,0,0,3*E(3),1,1,1,0,E(3)^2,0,1,E(3),1,0,0,ER(-3),E(3)^2,0,(5-3*ER(-3))/2,
(3-ER(-3))/2,1,E(3)^2,1,1,1,0,E(3)^2,105*E(3),-ER(-3),9*E(3),E(3),E(3),9*E(3),
0,3*E(3)^2,3,3*E(3),E(3)^2,15*E(3)^2,15,4*E(3)^2,(-7+ER(-3))/2,1+2*ER(-3),0,0,
(-3+ER(-3))/2,3*E(3)^2,25*E(3),0,1-2*ER(-3),3*E(3),1,E(3),1+2*ER(-3),E(3),
E(3),0,E(3)^2,0,E(3),1,105*E(3)^2,E(3)^2,9*E(3)^2,E(3)^2,9*E(3)^2,3,1,E(3),15,
1-2*ER(-3),4,-ER(-3),25*E(3)^2,3*E(3)^2,E(3)^2,(-7-ER(-3))/2,ER(-3),0,E(3),
105,9,1,1,3*E(3),E(3)^2,15*E(3),(5+3*ER(-3))/2,4*E(3),(3+ER(-3))/2,25,3,1,
(-3-ER(-3))/2,105*E(3),E(3),9*E(3),E(3),25*E(3),3*E(3),E(3),E(3),105*E(3)^2,
E(3)^2,9*E(3)^2,25*E(3)^2,3*E(3)^2,E(3)^2,E(3)^2],[105,35,12,9,2,3,5+ER(-3),3,
5-ER(-3),0,0,0,(3+ER(-3))/2,(3-ER(-3))/2,1,0,0,0,-E(3)^2,0,-E(3),0,-E(3)^2,0,
0,-E(3),-12*E(3),0,0,0,0,-12*E(3)^2,-1,0,-1-3*ER(-3),-1,-1+3*ER(-3),-1,0,
-4*E(3),0,-4*E(3)^2,0,0,ER(-3),-ER(-3),0,0,0,E(3),-2*E(3),0,-2*E(3)^2,0,
E(3)^2,0,0,-4,0,0,0,0,0,0,1,-2,0,0,-E(3)^2,0,0,-E(3),0,0,0,(-3-ER(-3))/2,0,0,
-1+3*ER(-3),ER(-3),-2,E(3)^2,-E(3),-E(3)^2,1,0,3*E(3)^2,105*E(3),
(-3+ER(-3))/2,9*E(3),E(3),3*E(3),3*E(3),0,0,0,0,-1,-12*E(3)^2,-12,-4*E(3)^2,
5+ER(-3),-4-2*ER(-3),0,0,(3+ER(-3))/2,0,35*E(3),0,-4+2*ER(-3),12*E(3),-E(3)^2,
2*E(3),-4-2*ER(-3),-2*E(3),-1,0,-2*E(3)^2,0,E(3),3,105*E(3)^2,E(3)^2,9*E(3)^2,
3*E(3)^2,3*E(3)^2,0,-E(3),0,-12,-4+2*ER(-3),-4,(-3+ER(-3))/2,35*E(3)^2,
12*E(3)^2,2*E(3)^2,5-ER(-3),(-3-ER(-3))/2,0,3*E(3),105,9,1,3,0,0,-12*E(3),
-1-3*ER(-3),-4*E(3),-ER(-3),35,12,2,(3-ER(-3))/2,105*E(3),E(3),9*E(3),0,
35*E(3),12*E(3),2*E(3),3*E(3),105*E(3)^2,E(3)^2,9*E(3)^2,35*E(3)^2,12*E(3)^2,
2*E(3)^2,3*E(3)^2],[105,5,3,-7,-1,1,(-5-11*ER(-3))/2,-3,(-5+11*ER(-3))/2,
-E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,1,-E(3),-1,0,-E(3)^2,E(3),-E(3),
E(3)^2,-E(3)^2,1,0,-E(3),15*E(3)^2,0,-1,2,0,15*E(3),-1,0,(19+3*ER(-3))/2,
-E(3)^2,(19-3*ER(-3))/2,-E(3),0,2*E(3)^2,0,2*E(3),E(3)^2,E(3),(3+ER(-3))/2,
(3-ER(-3))/2,0,0,2*E(3),-E(3)^2,-E(3)^2,2*E(3)^2,-E(3),0,-E(3),0,0,2,-E(3),0,
2*E(3)^2,2*E(3),0,-E(3)^2,5,-1,1,0,-E(3),0,1,-E(3)^2,1,0,0,-ER(-3),E(3),0,
(19-3*ER(-3))/2,(3+ER(-3))/2,-1,E(3),-1,-1,-1,0,E(3),105*E(3)^2,ER(-3),
-7*E(3)^2,5*E(3)^2,E(3)^2,-3*E(3)^2,0,-E(3),-1,-E(3)^2,-E(3),15*E(3),15,
2*E(3),(-5-11*ER(-3))/2,-7-4*ER(-3),0,2,(-3-ER(-3))/2,-E(3),5*E(3)^2,0,
-7+4*ER(-3),3*E(3)^2,-1,-E(3)^2,-7-4*ER(-3),-E(3)^2,-E(3)^2,0,-E(3),0,E(3)^2,
1,105*E(3),5*E(3),-7*E(3),E(3),-3*E(3),-1,-1,E(3)^2,15,-7+4*ER(-3),2,ER(-3),
5*E(3),3*E(3),-E(3),(-5+11*ER(-3))/2,-ER(-3),0,E(3)^2,105,-7,5,1,-E(3)^2,E(3),
15*E(3)^2,(19+3*ER(-3))/2,2*E(3)^2,(3-ER(-3))/2,5,3,-1,(-3+ER(-3))/2,
105*E(3)^2,5*E(3)^2,-7*E(3)^2,E(3)^2,5*E(3)^2,3*E(3)^2,-E(3)^2,E(3)^2,
105*E(3),5*E(3),-7*E(3),5*E(3),3*E(3),-E(3),E(3)],[105,-5,3,-7,1,-1,
(5+11*ER(-3))/2,3,(5-11*ER(-3))/2,-E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,1,
-E(3),-1,0,E(3)^2,-E(3),E(3),-E(3)^2,E(3)^2,-1,0,E(3),15*E(3)^2,0,-1,2,0,
15*E(3),1,0,(-19-3*ER(-3))/2,E(3)^2,(-19+3*ER(-3))/2,E(3),0,-2*E(3)^2,0,
-2*E(3),-E(3)^2,-E(3),(3+ER(-3))/2,(3-ER(-3))/2,0,0,2*E(3),-E(3)^2,-E(3)^2,
2*E(3)^2,-E(3),0,-E(3),0,0,-2,-E(3),0,2*E(3)^2,2*E(3),0,-E(3)^2,5,-1,-1,0,
E(3),0,-1,E(3)^2,-1,0,0,-ER(-3),-E(3),0,(-19+3*ER(-3))/2,(3+ER(-3))/2,-1,E(3),
1,1,-1,0,-E(3),105*E(3)^2,ER(-3),-7*E(3)^2,5*E(3)^2,-E(3)^2,3*E(3)^2,0,-E(3),
-1,-E(3)^2,E(3),15*E(3),15,-2*E(3),(5+11*ER(-3))/2,7+4*ER(-3),0,2,
(-3-ER(-3))/2,-E(3),-5*E(3)^2,0,7-4*ER(-3),3*E(3)^2,1,E(3)^2,7+4*ER(-3),
-E(3)^2,E(3)^2,0,-E(3),0,E(3)^2,-1,105*E(3),5*E(3),-7*E(3),-E(3),3*E(3),-1,1,
-E(3)^2,15,7-4*ER(-3),-2,ER(-3),-5*E(3),3*E(3),E(3),(5-11*ER(-3))/2,-ER(-3),0,
-E(3)^2,105,-7,5,-1,-E(3)^2,-E(3),15*E(3)^2,(-19-3*ER(-3))/2,-2*E(3)^2,
(3-ER(-3))/2,-5,3,1,(-3+ER(-3))/2,105*E(3)^2,5*E(3)^2,-7*E(3)^2,-E(3)^2,
-5*E(3)^2,3*E(3)^2,E(3)^2,-E(3)^2,105*E(3),5*E(3),-7*E(3),-5*E(3),3*E(3),E(3),
-E(3)],[105,5,3,-7,-1,1,(-5+11*ER(-3))/2,-3,(-5-11*ER(-3))/2,-E(3),0,0,
(-3+ER(-3))/2,(-3-ER(-3))/2,1,-E(3)^2,-1,0,-E(3),E(3)^2,-E(3)^2,E(3),-E(3),1,
0,-E(3)^2,15*E(3),0,-1,2,0,15*E(3)^2,-1,0,(19-3*ER(-3))/2,-E(3),
(19+3*ER(-3))/2,-E(3)^2,0,2*E(3),0,2*E(3)^2,E(3),E(3)^2,(3-ER(-3))/2,
(3+ER(-3))/2,0,0,2*E(3)^2,-E(3),-E(3),2*E(3),-E(3)^2,0,-E(3)^2,0,0,2,-E(3)^2,
0,2*E(3),2*E(3)^2,0,-E(3),5,-1,1,0,-E(3)^2,0,1,-E(3),1,0,0,ER(-3),E(3)^2,0,
(19+3*ER(-3))/2,(3-ER(-3))/2,-1,E(3)^2,-1,-1,-1,0,E(3)^2,105*E(3),-ER(-3),
-7*E(3),5*E(3),E(3),-3*E(3),0,-E(3)^2,-1,-E(3),-E(3)^2,15*E(3)^2,15,2*E(3)^2,
(-5+11*ER(-3))/2,-7+4*ER(-3),0,2,(-3+ER(-3))/2,-E(3)^2,5*E(3),0,-7-4*ER(-3),
3*E(3),-1,-E(3),-7+4*ER(-3),-E(3),-E(3),0,-E(3)^2,0,E(3),1,105*E(3)^2,
5*E(3)^2,-7*E(3)^2,E(3)^2,-3*E(3)^2,-1,-1,E(3),15,-7-4*ER(-3),2,-ER(-3),
5*E(3)^2,3*E(3)^2,-E(3)^2,(-5-11*ER(-3))/2,ER(-3),0,E(3),105,-7,5,1,-E(3),
E(3)^2,15*E(3),(19-3*ER(-3))/2,2*E(3),(3+ER(-3))/2,5,3,-1,(-3-ER(-3))/2,
105*E(3),5*E(3),-7*E(3),E(3),5*E(3),3*E(3),-E(3),E(3),105*E(3)^2,5*E(3)^2,
-7*E(3)^2,5*E(3)^2,3*E(3)^2,-E(3)^2,E(3)^2],[105,-5,3,-7,1,-1,(5-11*ER(-3))/2,
3,(5+11*ER(-3))/2,-E(3),0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,1,-E(3)^2,-1,0,E(3),
-E(3)^2,E(3)^2,-E(3),E(3),-1,0,E(3)^2,15*E(3),0,-1,2,0,15*E(3)^2,1,0,
(-19+3*ER(-3))/2,E(3),(-19-3*ER(-3))/2,E(3)^2,0,-2*E(3),0,-2*E(3)^2,-E(3),
-E(3)^2,(3-ER(-3))/2,(3+ER(-3))/2,0,0,2*E(3)^2,-E(3),-E(3),2*E(3),-E(3)^2,0,
-E(3)^2,0,0,-2,-E(3)^2,0,2*E(3),2*E(3)^2,0,-E(3),5,-1,-1,0,E(3)^2,0,-1,E(3),
-1,0,0,ER(-3),-E(3)^2,0,(-19-3*ER(-3))/2,(3-ER(-3))/2,-1,E(3)^2,1,1,-1,0,
-E(3)^2,105*E(3),-ER(-3),-7*E(3),5*E(3),-E(3),3*E(3),0,-E(3)^2,-1,-E(3),
E(3)^2,15*E(3)^2,15,-2*E(3)^2,(5-11*ER(-3))/2,7-4*ER(-3),0,2,(-3+ER(-3))/2,
-E(3)^2,-5*E(3),0,7+4*ER(-3),3*E(3),1,E(3),7-4*ER(-3),-E(3),E(3),0,-E(3)^2,0,
E(3),-1,105*E(3)^2,5*E(3)^2,-7*E(3)^2,-E(3)^2,3*E(3)^2,-1,1,-E(3),15,
7+4*ER(-3),-2,-ER(-3),-5*E(3)^2,3*E(3)^2,E(3)^2,(5+11*ER(-3))/2,ER(-3),0,
-E(3),105,-7,5,-1,-E(3),-E(3)^2,15*E(3),(-19+3*ER(-3))/2,-2*E(3),(3+ER(-3))/2,
-5,3,1,(-3-ER(-3))/2,105*E(3),5*E(3),-7*E(3),-E(3),-5*E(3),3*E(3),E(3),-E(3),
105*E(3)^2,5*E(3)^2,-7*E(3)^2,-5*E(3)^2,3*E(3)^2,E(3)^2,-E(3)^2],[120,0,-6,8,
0,0,0,0,0,-4,3,0,0,0,0,-4,2,0,0,0,0,0,0,0,3,0,12,-1,-2,2,-1,12,0,0,0,0,0,0,0,
0,-3,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,2,1,-2,-2,1,2,0,0,0,0,0,0,0,0,0,-6,-1,
0,0,0,0,0,0,0,0,0,0,0,0,-120,0,-8,0,0,0,-3,4,4,-2,0,-12,-12,0,0,0,0,-2,0,-2,0,
6,0,6,0,0,0,0,0,0,0,1,0,0,120,0,8,0,0,-4,0,0,12,0,0,0,0,-6,0,0,0,0,0,-120,-8,
0,0,4,0,-12,0,0,0,0,6,0,0,120,0,8,0,0,-6,0,0,-120,0,-8,0,6,0,0],[120,0,-6,8,0,
0,0,0,0,-4,3,0,0,0,0,-4,2,0,0,0,0,0,0,0,-3,0,12,-1,-2,2,-1,12,0,0,0,0,0,0,0,0,
3,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,2,1,-2,-2,1,2,0,0,0,0,0,0,0,0,0,-6,-1,0,0,
0,0,0,0,0,0,0,0,0,0,-120,0,-8,0,0,0,-3,4,4,-2,0,-12,-12,0,0,0,0,-2,0,-2,0,6,0,
6,0,0,0,0,0,0,0,1,0,0,120,0,8,0,0,-4,0,0,12,0,0,0,0,-6,0,0,0,0,0,-120,-8,0,0,
4,0,-12,0,0,0,0,6,0,0,120,0,8,0,0,-6,0,0,-120,0,-8,0,6,0,0],[120,40,15,8,1,4,
7-ER(-3),0,7+ER(-3),2*E(3),0,0,(3-ER(-3))/2,(3+ER(-3))/2,0,2*E(3)^2,-1,0,E(3),
E(3)^2,-E(3)^2,E(3),-E(3),1,0,E(3)^2,-6*E(3),-E(3),1,2,-E(3)^2,-6*E(3)^2,0,0,
-5-3*ER(-3),E(3),-5+3*ER(-3),E(3)^2,0,-2*E(3),0,-2*E(3)^2,0,0,(-3+ER(-3))/2,
(-3-ER(-3))/2,0,0,2*E(3)^2,0,0,2*E(3),0,0,0,0,0,2,-E(3)^2,E(3)^2,-2*E(3),
-2*E(3)^2,E(3),-E(3),0,0,0,0,0,0,-1,0,0,0,-1,ER(-3),-E(3)^2,0,5-3*ER(-3),
(3-ER(-3))/2,0,0,-1,1,0,0,0,-120*E(3),-ER(-3),-8*E(3),0,-4*E(3),0,0,-2*E(3)^2,
-2,E(3),-E(3)^2,6*E(3)^2,6,2*E(3)^2,-7+ER(-3),2+4*ER(-3),0,-2,(-3+ER(-3))/2,
E(3)^2,-40*E(3),0,2-4*ER(-3),-15*E(3),-1,-E(3),-2-4*ER(-3),0,-E(3),0,0,1,0,0,
120*E(3)^2,0,8*E(3)^2,4*E(3)^2,0,2,1,0,-6,-2+4*ER(-3),-2,ER(-3),40*E(3)^2,
15*E(3)^2,E(3)^2,-7-ER(-3),-ER(-3),0,0,-120,-8,0,-4,-2*E(3),0,6*E(3),
5+3*ER(-3),2*E(3),(3+ER(-3))/2,-40,-15,-1,(-3-ER(-3))/2,120*E(3),0,8*E(3),
-E(3),40*E(3),15*E(3),E(3),4*E(3),-120*E(3)^2,0,-8*E(3)^2,-40*E(3)^2,
-15*E(3)^2,-E(3)^2,-4*E(3)^2],[120,-40,15,8,-1,-4,-7+ER(-3),0,-7-ER(-3),
2*E(3),0,0,(3-ER(-3))/2,(3+ER(-3))/2,0,2*E(3)^2,-1,0,-E(3),-E(3)^2,E(3)^2,
-E(3),E(3),-1,0,-E(3)^2,-6*E(3),-E(3),1,2,-E(3)^2,-6*E(3)^2,0,0,5+3*ER(-3),
-E(3),5-3*ER(-3),-E(3)^2,0,2*E(3),0,2*E(3)^2,0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,
0,0,2*E(3)^2,0,0,2*E(3),0,0,0,0,0,-2,-E(3)^2,E(3)^2,-2*E(3),-2*E(3)^2,E(3),
-E(3),0,0,0,0,0,0,1,0,0,0,-1,ER(-3),E(3)^2,0,-5+3*ER(-3),(3-ER(-3))/2,0,0,1,
-1,0,0,0,-120*E(3),-ER(-3),-8*E(3),0,4*E(3),0,0,-2*E(3)^2,-2,E(3),E(3)^2,
6*E(3)^2,6,-2*E(3)^2,7-ER(-3),-2-4*ER(-3),0,-2,(-3+ER(-3))/2,E(3)^2,40*E(3),0,
-2+4*ER(-3),-15*E(3),1,E(3),2+4*ER(-3),0,E(3),0,0,1,0,0,120*E(3)^2,0,8*E(3)^2,
-4*E(3)^2,0,2,-1,0,-6,2-4*ER(-3),2,ER(-3),-40*E(3)^2,15*E(3)^2,-E(3)^2,
7+ER(-3),-ER(-3),0,0,-120,-8,0,4,-2*E(3),0,6*E(3),-5-3*ER(-3),-2*E(3),
(3+ER(-3))/2,40,-15,1,(-3-ER(-3))/2,120*E(3),0,8*E(3),E(3),-40*E(3),15*E(3),
-E(3),-4*E(3),-120*E(3)^2,0,-8*E(3)^2,40*E(3)^2,-15*E(3)^2,E(3)^2,4*E(3)^2],
[120,40,15,8,1,4,7+ER(-3),0,7-ER(-3),2*E(3)^2,0,0,(3+ER(-3))/2,(3-ER(-3))/2,0,
2*E(3),-1,0,E(3)^2,E(3),-E(3),E(3)^2,-E(3)^2,1,0,E(3),-6*E(3)^2,-E(3)^2,1,2,
-E(3),-6*E(3),0,0,-5+3*ER(-3),E(3)^2,-5-3*ER(-3),E(3),0,-2*E(3)^2,0,-2*E(3),0,
0,(-3-ER(-3))/2,(-3+ER(-3))/2,0,0,2*E(3),0,0,2*E(3)^2,0,0,0,0,0,2,-E(3),E(3),
-2*E(3)^2,-2*E(3),E(3)^2,-E(3)^2,0,0,0,0,0,0,-1,0,0,0,-1,-ER(-3),-E(3),0,
5+3*ER(-3),(3+ER(-3))/2,0,0,-1,1,0,0,0,-120*E(3)^2,ER(-3),-8*E(3)^2,0,
-4*E(3)^2,0,0,-2*E(3),-2,E(3)^2,-E(3),6*E(3),6,2*E(3),-7-ER(-3),2-4*ER(-3),0,
-2,(-3-ER(-3))/2,E(3),-40*E(3)^2,0,2+4*ER(-3),-15*E(3)^2,-1,-E(3)^2,
-2+4*ER(-3),0,-E(3)^2,0,0,1,0,0,120*E(3),0,8*E(3),4*E(3),0,2,1,0,-6,
-2-4*ER(-3),-2,-ER(-3),40*E(3),15*E(3),E(3),-7+ER(-3),ER(-3),0,0,-120,-8,0,-4,
-2*E(3)^2,0,6*E(3)^2,5-3*ER(-3),2*E(3)^2,(3-ER(-3))/2,-40,-15,-1,
(-3+ER(-3))/2,120*E(3)^2,0,8*E(3)^2,-E(3)^2,40*E(3)^2,15*E(3)^2,E(3)^2,
4*E(3)^2,-120*E(3),0,-8*E(3),-40*E(3),-15*E(3),-E(3),-4*E(3)],[120,-40,15,8,
-1,-4,-7-ER(-3),0,-7+ER(-3),2*E(3)^2,0,0,(3+ER(-3))/2,(3-ER(-3))/2,0,2*E(3),
-1,0,-E(3)^2,-E(3),E(3),-E(3)^2,E(3)^2,-1,0,-E(3),-6*E(3)^2,-E(3)^2,1,2,-E(3),
-6*E(3),0,0,5-3*ER(-3),-E(3)^2,5+3*ER(-3),-E(3),0,2*E(3)^2,0,2*E(3),0,0,
(-3-ER(-3))/2,(-3+ER(-3))/2,0,0,2*E(3),0,0,2*E(3)^2,0,0,0,0,0,-2,-E(3),E(3),
-2*E(3)^2,-2*E(3),E(3)^2,-E(3)^2,0,0,0,0,0,0,1,0,0,0,-1,-ER(-3),E(3),0,
-5-3*ER(-3),(3+ER(-3))/2,0,0,1,-1,0,0,0,-120*E(3)^2,ER(-3),-8*E(3)^2,0,
4*E(3)^2,0,0,-2*E(3),-2,E(3)^2,E(3),6*E(3),6,-2*E(3),7+ER(-3),-2+4*ER(-3),0,
-2,(-3-ER(-3))/2,E(3),40*E(3)^2,0,-2-4*ER(-3),-15*E(3)^2,1,E(3)^2,2-4*ER(-3),
0,E(3)^2,0,0,1,0,0,120*E(3),0,8*E(3),-4*E(3),0,2,-1,0,-6,2+4*ER(-3),2,-ER(-3),
-40*E(3),15*E(3),-E(3),7-ER(-3),ER(-3),0,0,-120,-8,0,4,-2*E(3)^2,0,6*E(3)^2,
-5+3*ER(-3),-2*E(3)^2,(3-ER(-3))/2,40,-15,1,(-3+ER(-3))/2,120*E(3)^2,0,
8*E(3)^2,E(3)^2,-40*E(3)^2,15*E(3)^2,-E(3)^2,-4*E(3)^2,-120*E(3),0,-8*E(3),
40*E(3),-15*E(3),E(3),4*E(3)],[126,36,9,10,3,2,0,0,0,-2*E(3),0,1,0,0,0,
-2*E(3)^2,1,1,0,-E(3)^2,0,-E(3),0,-1,0,0,18*E(3),0,-1,-2,0,18*E(3)^2,0,-1,0,0,
0,0,0,6*E(3),0,6*E(3)^2,0,0,0,0,-E(3)^2,-E(3),-2*E(3)^2,0,2*E(3),-2*E(3),
2*E(3)^2,0,0,-E(3),-E(3)^2,-6,E(3)^2,0,2*E(3),2*E(3)^2,0,E(3),2,-2,0,E(3)^2,0,
E(3),1,0,0,0,0,0,E(3)^2,0,0,0,2,0,0,0,0,E(3)^2,0,-126*E(3),0,-10*E(3),-2*E(3),
-2*E(3),0,0,2*E(3)^2,2,-E(3),0,-18*E(3)^2,-18,-6*E(3)^2,0,0,0,2,0,-E(3)^2,
-36*E(3),0,0,-9*E(3),0,-3*E(3),0,-2*E(3),0,-1,-2*E(3)^2,0,0,0,126*E(3)^2,
2*E(3)^2,10*E(3)^2,2*E(3)^2,0,-2,0,0,18,0,6,0,36*E(3)^2,9*E(3)^2,3*E(3)^2,0,0,
E(3),0,-126,-10,-2,-2,2*E(3),0,-18*E(3),0,-6*E(3),0,-36,-9,-3,0,126*E(3),
2*E(3),10*E(3),E(3),36*E(3),9*E(3),3*E(3),2*E(3),-126*E(3)^2,-2*E(3)^2,
-10*E(3)^2,-36*E(3)^2,-9*E(3)^2,-3*E(3)^2,-2*E(3)^2],[126,-36,9,10,-3,-2,0,0,
0,-2*E(3),0,1,0,0,0,-2*E(3)^2,1,-1,0,E(3)^2,0,E(3),0,1,0,0,18*E(3),0,-1,-2,0,
18*E(3)^2,0,1,0,0,0,0,0,-6*E(3),0,-6*E(3)^2,0,0,0,0,-E(3)^2,-E(3),-2*E(3)^2,0,
2*E(3),-2*E(3),2*E(3)^2,0,0,E(3),E(3)^2,6,E(3)^2,0,2*E(3),2*E(3)^2,0,E(3),2,
-2,0,-E(3)^2,0,-E(3),-1,0,0,0,0,0,-E(3)^2,0,0,0,2,0,0,0,0,E(3)^2,0,-126*E(3),
0,-10*E(3),-2*E(3),2*E(3),0,0,2*E(3)^2,2,-E(3),0,-18*E(3)^2,-18,6*E(3)^2,0,0,
0,2,0,-E(3)^2,36*E(3),0,0,-9*E(3),0,3*E(3),0,-2*E(3),0,-1,-2*E(3)^2,0,0,0,
126*E(3)^2,2*E(3)^2,10*E(3)^2,-2*E(3)^2,0,-2,0,0,18,0,-6,0,-36*E(3)^2,
9*E(3)^2,-3*E(3)^2,0,0,E(3),0,-126,-10,-2,2,2*E(3),0,-18*E(3),0,6*E(3),0,36,
-9,3,0,126*E(3),2*E(3),10*E(3),-E(3),-36*E(3),9*E(3),-3*E(3),-2*E(3),
-126*E(3)^2,-2*E(3)^2,-10*E(3)^2,36*E(3)^2,-9*E(3)^2,3*E(3)^2,2*E(3)^2],[126,
36,9,10,3,2,0,0,0,-2*E(3)^2,0,1,0,0,0,-2*E(3),1,1,0,-E(3),0,-E(3)^2,0,-1,0,0,
18*E(3)^2,0,-1,-2,0,18*E(3),0,-1,0,0,0,0,0,6*E(3)^2,0,6*E(3),0,0,0,0,-E(3),
-E(3)^2,-2*E(3),0,2*E(3)^2,-2*E(3)^2,2*E(3),0,0,-E(3)^2,-E(3),-6,E(3),0,
2*E(3)^2,2*E(3),0,E(3)^2,2,-2,0,E(3),0,E(3)^2,1,0,0,0,0,0,E(3),0,0,0,2,0,0,0,
0,E(3),0,-126*E(3)^2,0,-10*E(3)^2,-2*E(3)^2,-2*E(3)^2,0,0,2*E(3),2,-E(3)^2,0,
-18*E(3),-18,-6*E(3),0,0,0,2,0,-E(3),-36*E(3)^2,0,0,-9*E(3)^2,0,-3*E(3)^2,0,
-2*E(3)^2,0,-1,-2*E(3),0,0,0,126*E(3),2*E(3),10*E(3),2*E(3),0,-2,0,0,18,0,6,0,
36*E(3),9*E(3),3*E(3),0,0,E(3)^2,0,-126,-10,-2,-2,2*E(3)^2,0,-18*E(3)^2,0,
-6*E(3)^2,0,-36,-9,-3,0,126*E(3)^2,2*E(3)^2,10*E(3)^2,E(3)^2,36*E(3)^2,
9*E(3)^2,3*E(3)^2,2*E(3)^2,-126*E(3),-2*E(3),-10*E(3),-36*E(3),-9*E(3),
-3*E(3),-2*E(3)],[126,-36,9,10,-3,-2,0,0,0,-2*E(3)^2,0,1,0,0,0,-2*E(3),1,-1,0,
E(3),0,E(3)^2,0,1,0,0,18*E(3)^2,0,-1,-2,0,18*E(3),0,1,0,0,0,0,0,-6*E(3)^2,0,
-6*E(3),0,0,0,0,-E(3),-E(3)^2,-2*E(3),0,2*E(3)^2,-2*E(3)^2,2*E(3),0,0,E(3)^2,
E(3),6,E(3),0,2*E(3)^2,2*E(3),0,E(3)^2,2,-2,0,-E(3),0,-E(3)^2,-1,0,0,0,0,0,
-E(3),0,0,0,2,0,0,0,0,E(3),0,-126*E(3)^2,0,-10*E(3)^2,-2*E(3)^2,2*E(3)^2,0,0,
2*E(3),2,-E(3)^2,0,-18*E(3),-18,6*E(3),0,0,0,2,0,-E(3),36*E(3)^2,0,0,
-9*E(3)^2,0,3*E(3)^2,0,-2*E(3)^2,0,-1,-2*E(3),0,0,0,126*E(3),2*E(3),10*E(3),
-2*E(3),0,-2,0,0,18,0,-6,0,-36*E(3),9*E(3),-3*E(3),0,0,E(3)^2,0,-126,-10,-2,2,
2*E(3)^2,0,-18*E(3)^2,0,6*E(3)^2,0,36,-9,3,0,126*E(3)^2,2*E(3)^2,10*E(3)^2,
-E(3)^2,-36*E(3)^2,9*E(3)^2,-3*E(3)^2,-2*E(3)^2,-126*E(3),-2*E(3),-10*E(3),
36*E(3),-9*E(3),3*E(3),2*E(3)],[140,0,-4,4,0,0,0,0,0,-2,-4,0,2,2,0,-2,4,0,0,0,
0,0,0,0,0,0,-22,0,-4,-2,0,-22,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,-2,0,-2,-2,-2,1,
0,0,0,0,4,0,2,2,0,4,4,2,0,0,0,0,0,0,0,14,0,-2,0,-1,0,-2,-2,0,0,0,0,0,0,-140,
-2,-4,-4,0,0,4,2,2,-4,0,22,22,0,0,0,0,2,-2,-4,0,-14,0,4,0,0,0,2,0,0,2,0,0,0,
140,4,4,0,0,-2,0,0,-22,0,0,2,0,-4,0,0,2,0,0,-140,-4,-4,0,2,0,22,0,0,-2,0,4,0,
-2,140,4,4,0,0,-4,0,0,-140,-4,-4,0,4,0,0],[140,-20,-4,12,-2,0,7,-4,7,-3,5,0,
-1,-1,0,-3,0,0,1,0,1,0,1,0,-1,1,5,0,0,0,0,5,0,0,7,1,7,1,2,-2,-1,-2,-1,-1,-1,
-1,0,0,0,0,1,0,1,-1,0,0,0,-2,0,0,0,0,0,0,4,1,-1,0,0,0,0,0,-1,-4,0,-1,0,-1,7,
-1,1,0,1,1,0,0,-4,140,-1,12,4,0,-4,5,-3,-3,0,1,5,5,-2,7,7,2,0,-1,0,-20,-4,7,
-4,1,-2,7,1,1,0,1,0,0,-4,140,4,12,0,-4,-3,1,-1,5,7,-2,-1,-20,-4,-2,7,-1,0,-4,
140,12,4,0,-3,-1,5,7,-2,-1,-20,-4,-2,-1,140,4,12,0,-20,-4,-2,0,140,4,12,-20,
-4,-2,0],[140,20,-4,12,2,0,-7,4,-7,-3,5,0,-1,-1,0,-3,0,0,-1,0,-1,0,-1,0,1,-1,
5,0,0,0,0,5,0,0,-7,-1,-7,-1,-2,2,1,2,1,1,-1,-1,0,0,0,0,1,0,1,-1,0,0,0,2,0,0,0,
0,0,0,4,1,1,0,0,0,0,0,1,-4,0,-1,0,-1,-7,-1,1,0,-1,-1,0,0,4,140,-1,12,4,0,4,5,
-3,-3,0,-1,5,5,2,-7,-7,-2,0,-1,0,20,-4,-7,-4,-1,2,-7,1,-1,0,1,0,0,4,140,4,12,
0,4,-3,-1,1,5,-7,2,-1,20,-4,2,-7,-1,0,4,140,12,4,0,-3,1,5,-7,2,-1,20,-4,2,-1,
140,4,12,0,20,-4,2,0,140,4,12,20,-4,2,0],[189,-9,0,-3,0,3,-9,-9,-9,3,0,-1,0,0,
1,3,0,1,0,0,0,0,0,0,0,0,27,0,0,0,0,27,-1,1,-9,0,-9,0,0,0,0,0,-1,-1,0,0,-1,-1,
0,1,-1,0,-1,0,1,1,1,0,0,0,0,0,0,0,5,-1,-1,1,-1,1,0,-1,-1,0,0,0,0,0,-9,0,-1,1,
0,0,1,-1,-1,189,0,-3,5,3,-9,0,3,3,0,0,27,27,0,-9,-9,0,0,0,0,-9,0,-9,0,0,0,-9,
-1,0,-1,-1,0,1,-1,189,5,-3,3,-9,3,0,-1,27,-9,0,0,-9,0,0,-9,0,-1,-1,189,-3,5,3,
3,-1,27,-9,0,0,-9,0,0,0,189,5,-3,0,-9,0,0,3,189,5,-3,-9,0,0,3],[189,9,0,-3,0,
-3,9,9,9,3,0,-1,0,0,1,3,0,-1,0,0,0,0,0,0,0,0,27,0,0,0,0,27,1,-1,9,0,9,0,0,0,0,
0,1,1,0,0,-1,-1,0,1,-1,0,-1,0,1,-1,-1,0,0,0,0,0,0,0,5,-1,1,-1,1,-1,0,1,1,0,0,
0,0,0,9,0,-1,1,0,0,1,-1,1,189,0,-3,5,-3,9,0,3,3,0,0,27,27,0,9,9,0,0,0,0,9,0,9,
0,0,0,9,-1,0,-1,-1,0,1,1,189,5,-3,-3,9,3,0,1,27,9,0,0,9,0,0,9,0,-1,1,189,-3,5,
-3,3,1,27,9,0,0,9,0,0,0,189,5,-3,0,9,0,0,-3,189,5,-3,9,0,0,-3],[210,-30,3,2,
-3,2,-3,10,-3,5,3,0,0,0,-2,5,-1,0,0,-1,0,-1,0,-1,1,0,21,0,-1,-1,0,21,0,0,-3,0,
-3,0,1,-3,1,-3,1,1,0,0,0,0,-1,0,1,-1,1,0,0,0,0,-3,-1,0,-1,-1,0,-1,-2,1,1,0,0,
0,-1,0,1,3,0,0,-1,0,-3,0,1,-2,0,0,0,0,-2,210,0,2,-2,2,10,3,5,5,-1,0,21,21,-3,
-3,-3,1,-1,0,-1,-30,3,-3,3,0,-3,-3,1,0,0,1,0,-2,-2,210,-2,2,2,10,5,0,1,21,-3,
-3,0,-30,3,-3,-3,0,0,-2,210,2,-2,2,5,1,21,-3,-3,0,-30,3,-3,0,210,-2,2,-1,-30,
3,-3,2,210,-2,2,-30,3,-3,2],[210,30,3,2,3,-2,3,-10,3,5,3,0,0,0,-2,5,-1,0,0,1,
0,1,0,1,-1,0,21,0,-1,-1,0,21,0,0,3,0,3,0,-1,3,-1,3,-1,-1,0,0,0,0,-1,0,1,-1,1,
0,0,0,0,3,-1,0,-1,-1,0,-1,-2,1,-1,0,0,0,1,0,-1,3,0,0,1,0,3,0,1,-2,0,0,0,0,2,
210,0,2,-2,-2,-10,3,5,5,-1,0,21,21,3,3,3,-1,-1,0,-1,30,3,3,3,0,3,3,1,0,0,1,0,
-2,2,210,-2,2,-2,-10,5,0,-1,21,3,3,0,30,3,3,3,0,0,2,210,2,-2,-2,5,-1,21,3,3,0,
30,3,3,0,210,-2,2,1,30,3,3,-2,210,-2,2,30,3,3,-2],[210,50,15,2,-1,2,
(13-5*ER(-3))/2,-6,(13+5*ER(-3))/2,-E(3)^2,0,0,-ER(-3),ER(-3),-2,-E(3),-1,0,
-1,-E(3),-1,-E(3)^2,-1,-1,0,-1,3*E(3)^2,0,-1,2,0,3*E(3),0,0,(1+9*ER(-3))/2,
-E(3),(1-9*ER(-3))/2,-E(3)^2,0,2*E(3)^2,0,2*E(3),E(3)^2,E(3),(3-ER(-3))/2,
(3+ER(-3))/2,0,0,2*E(3),0,E(3)^2,2*E(3)^2,E(3),0,0,0,0,2,-E(3),0,2*E(3)^2,
2*E(3),0,-E(3)^2,-2,1,1,0,0,0,-1,0,1,0,0,(-3-ER(-3))/2,-E(3),0,(1-9*ER(-3))/2,
(3-ER(-3))/2,1,-2*E(3),-E(3),-E(3)^2,0,0,-2*E(3),210*E(3)^2,(-3+ER(-3))/2,
2*E(3)^2,-2*E(3)^2,2*E(3)^2,-6*E(3)^2,0,-E(3),-1,-E(3)^2,-E(3)^2,3*E(3),3,
2*E(3),(13-5*ER(-3))/2,-7+2*ER(-3),0,2,-ER(-3),-E(3),50*E(3)^2,0,-7-2*ER(-3),
15*E(3)^2,-E(3)^2,-E(3)^2,-7+2*ER(-3),E(3)^2,-E(3),0,E(3),0,-2*E(3)^2,-2,
210*E(3),-2*E(3),2*E(3),2*E(3),-6*E(3),-1,-E(3),E(3)^2,3,-7-2*ER(-3),2,
(-3+ER(-3))/2,50*E(3),15*E(3),-E(3),(13+5*ER(-3))/2,(-3-ER(-3))/2,0,-2*E(3)^2,
210,2,-2,2,-E(3)^2,E(3),3*E(3)^2,(1+9*ER(-3))/2,2*E(3)^2,(3+ER(-3))/2,50,15,
-1,ER(-3),210*E(3)^2,-2*E(3)^2,2*E(3)^2,-E(3)^2,50*E(3)^2,15*E(3)^2,-E(3)^2,
2*E(3)^2,210*E(3),-2*E(3),2*E(3),50*E(3),15*E(3),-E(3),2*E(3)],[210,-50,15,2,
1,-2,(-13+5*ER(-3))/2,6,(-13-5*ER(-3))/2,-E(3)^2,0,0,-ER(-3),ER(-3),-2,-E(3),
-1,0,1,E(3),1,E(3)^2,1,1,0,1,3*E(3)^2,0,-1,2,0,3*E(3),0,0,(-1-9*ER(-3))/2,
E(3),(-1+9*ER(-3))/2,E(3)^2,0,-2*E(3)^2,0,-2*E(3),-E(3)^2,-E(3),(3-ER(-3))/2,
(3+ER(-3))/2,0,0,2*E(3),0,E(3)^2,2*E(3)^2,E(3),0,0,0,0,-2,-E(3),0,2*E(3)^2,
2*E(3),0,-E(3)^2,-2,1,-1,0,0,0,1,0,-1,0,0,(-3-ER(-3))/2,E(3),0,
(-1+9*ER(-3))/2,(3-ER(-3))/2,1,-2*E(3),E(3),E(3)^2,0,0,2*E(3),210*E(3)^2,
(-3+ER(-3))/2,2*E(3)^2,-2*E(3)^2,-2*E(3)^2,6*E(3)^2,0,-E(3),-1,-E(3)^2,E(3)^2,
3*E(3),3,-2*E(3),(-13+5*ER(-3))/2,7-2*ER(-3),0,2,-ER(-3),-E(3),-50*E(3)^2,0,
7+2*ER(-3),15*E(3)^2,E(3)^2,E(3)^2,7-2*ER(-3),E(3)^2,E(3),0,E(3),0,-2*E(3)^2,
2,210*E(3),-2*E(3),2*E(3),-2*E(3),6*E(3),-1,E(3),-E(3)^2,3,7+2*ER(-3),-2,
(-3+ER(-3))/2,-50*E(3),15*E(3),E(3),(-13-5*ER(-3))/2,(-3-ER(-3))/2,0,2*E(3)^2,
210,2,-2,-2,-E(3)^2,-E(3),3*E(3)^2,(-1-9*ER(-3))/2,-2*E(3)^2,(3+ER(-3))/2,-50,
15,1,ER(-3),210*E(3)^2,-2*E(3)^2,2*E(3)^2,E(3)^2,-50*E(3)^2,15*E(3)^2,E(3)^2,
-2*E(3)^2,210*E(3),-2*E(3),2*E(3),-50*E(3),15*E(3),E(3),-2*E(3)],[210,-50,15,
2,1,-2,(-13-5*ER(-3))/2,6,(-13+5*ER(-3))/2,-E(3),0,0,ER(-3),-ER(-3),-2,
-E(3)^2,-1,0,1,E(3)^2,1,E(3),1,1,0,1,3*E(3),0,-1,2,0,3*E(3)^2,0,0,
(-1+9*ER(-3))/2,E(3)^2,(-1-9*ER(-3))/2,E(3),0,-2*E(3),0,-2*E(3)^2,-E(3),
-E(3)^2,(3+ER(-3))/2,(3-ER(-3))/2,0,0,2*E(3)^2,0,E(3),2*E(3),E(3)^2,0,0,0,0,
-2,-E(3)^2,0,2*E(3),2*E(3)^2,0,-E(3),-2,1,-1,0,0,0,1,0,-1,0,0,(-3+ER(-3))/2,
E(3)^2,0,(-1-9*ER(-3))/2,(3+ER(-3))/2,1,-2*E(3)^2,E(3)^2,E(3),0,0,2*E(3)^2,
210*E(3),(-3-ER(-3))/2,2*E(3),-2*E(3),-2*E(3),6*E(3),0,-E(3)^2,-1,-E(3),E(3),
3*E(3)^2,3,-2*E(3)^2,(-13-5*ER(-3))/2,7+2*ER(-3),0,2,ER(-3),-E(3)^2,-50*E(3),
0,7-2*ER(-3),15*E(3),E(3),E(3),7+2*ER(-3),E(3),E(3)^2,0,E(3)^2,0,-2*E(3),2,
210*E(3)^2,-2*E(3)^2,2*E(3)^2,-2*E(3)^2,6*E(3)^2,-1,E(3)^2,-E(3),3,7-2*ER(-3),
-2,(-3-ER(-3))/2,-50*E(3)^2,15*E(3)^2,E(3)^2,(-13+5*ER(-3))/2,(-3+ER(-3))/2,0,
2*E(3),210,2,-2,-2,-E(3),-E(3)^2,3*E(3),(-1+9*ER(-3))/2,-2*E(3),(3-ER(-3))/2,
-50,15,1,-ER(-3),210*E(3),-2*E(3),2*E(3),E(3),-50*E(3),15*E(3),E(3),-2*E(3),
210*E(3)^2,-2*E(3)^2,2*E(3)^2,-50*E(3)^2,15*E(3)^2,E(3)^2,-2*E(3)^2],[210,50,
15,2,-1,2,(13+5*ER(-3))/2,-6,(13-5*ER(-3))/2,-E(3),0,0,ER(-3),-ER(-3),-2,
-E(3)^2,-1,0,-1,-E(3)^2,-1,-E(3),-1,-1,0,-1,3*E(3),0,-1,2,0,3*E(3)^2,0,0,
(1-9*ER(-3))/2,-E(3)^2,(1+9*ER(-3))/2,-E(3),0,2*E(3),0,2*E(3)^2,E(3),E(3)^2,
(3+ER(-3))/2,(3-ER(-3))/2,0,0,2*E(3)^2,0,E(3),2*E(3),E(3)^2,0,0,0,0,2,-E(3)^2,
0,2*E(3),2*E(3)^2,0,-E(3),-2,1,1,0,0,0,-1,0,1,0,0,(-3+ER(-3))/2,-E(3)^2,0,
(1+9*ER(-3))/2,(3+ER(-3))/2,1,-2*E(3)^2,-E(3)^2,-E(3),0,0,-2*E(3)^2,210*E(3),
(-3-ER(-3))/2,2*E(3),-2*E(3),2*E(3),-6*E(3),0,-E(3)^2,-1,-E(3),-E(3),3*E(3)^2,
3,2*E(3)^2,(13+5*ER(-3))/2,-7-2*ER(-3),0,2,ER(-3),-E(3)^2,50*E(3),0,
-7+2*ER(-3),15*E(3),-E(3),-E(3),-7-2*ER(-3),E(3),-E(3)^2,0,E(3)^2,0,-2*E(3),
-2,210*E(3)^2,-2*E(3)^2,2*E(3)^2,2*E(3)^2,-6*E(3)^2,-1,-E(3)^2,E(3),3,
-7+2*ER(-3),2,(-3-ER(-3))/2,50*E(3)^2,15*E(3)^2,-E(3)^2,(13-5*ER(-3))/2,
(-3+ER(-3))/2,0,-2*E(3),210,2,-2,2,-E(3),E(3)^2,3*E(3),(1-9*ER(-3))/2,2*E(3),
(3-ER(-3))/2,50,15,-1,-ER(-3),210*E(3),-2*E(3),2*E(3),-E(3),50*E(3),15*E(3),
-E(3),2*E(3),210*E(3)^2,-2*E(3)^2,2*E(3)^2,50*E(3)^2,15*E(3)^2,-E(3)^2,
2*E(3)^2],[210,20,-3,6,-1,2,-10-2*ER(-3),0,-10+2*ER(-3),0,0,0,(-3-ER(-3))/2,
(-3+ER(-3))/2,0,0,-3,0,-E(3)^2,-E(3)^2,E(3),-E(3),E(3)^2,-1,0,-E(3),-24*E(3),
0,3,0,0,-24*E(3)^2,0,0,2+6*ER(-3),-1,2-6*ER(-3),-1,0,-4*E(3),0,-4*E(3)^2,0,0,
-ER(-3),ER(-3),0,0,0,0,0,0,0,0,0,0,0,4,-3*E(3)^2,0,0,0,0,-3*E(3),6,0,0,0,0,0,
1,0,0,0,0,(-3-ER(-3))/2,E(3)^2,0,-2+6*ER(-3),ER(-3),0,0,E(3),-E(3)^2,0,0,0,
-210*E(3),(-3+ER(-3))/2,-6*E(3),-6*E(3),-2*E(3),0,0,0,0,3*E(3),1,24*E(3)^2,24,
4*E(3)^2,10+2*ER(-3),-8-4*ER(-3),0,0,(3+ER(-3))/2,3*E(3)^2,-20*E(3),0,
-8+4*ER(-3),3*E(3),E(3)^2,E(3),8+4*ER(-3),0,1,0,0,0,0,0,210*E(3)^2,6*E(3)^2,
6*E(3)^2,2*E(3)^2,0,0,-E(3),0,-24,8-4*ER(-3),-4,(3-ER(-3))/2,20*E(3)^2,
-3*E(3)^2,-E(3)^2,10-2*ER(-3),(3+ER(-3))/2,0,0,-210,-6,-6,-2,0,0,24*E(3),
-2-6*ER(-3),4*E(3),-ER(-3),-20,3,1,(3-ER(-3))/2,210*E(3),6*E(3),6*E(3),E(3),
20*E(3),-3*E(3),-E(3),2*E(3),-210*E(3)^2,-6*E(3)^2,-6*E(3)^2,-20*E(3)^2,
3*E(3)^2,E(3)^2,-2*E(3)^2],[210,-20,-3,6,1,-2,10+2*ER(-3),0,10-2*ER(-3),0,0,0,
(-3-ER(-3))/2,(-3+ER(-3))/2,0,0,-3,0,E(3)^2,E(3)^2,-E(3),E(3),-E(3)^2,1,0,
E(3),-24*E(3),0,3,0,0,-24*E(3)^2,0,0,-2-6*ER(-3),1,-2+6*ER(-3),1,0,4*E(3),0,
4*E(3)^2,0,0,-ER(-3),ER(-3),0,0,0,0,0,0,0,0,0,0,0,-4,-3*E(3)^2,0,0,0,0,
-3*E(3),6,0,0,0,0,0,-1,0,0,0,0,(-3-ER(-3))/2,-E(3)^2,0,2-6*ER(-3),ER(-3),0,0,
-E(3),E(3)^2,0,0,0,-210*E(3),(-3+ER(-3))/2,-6*E(3),-6*E(3),2*E(3),0,0,0,0,
3*E(3),-1,24*E(3)^2,24,-4*E(3)^2,-10-2*ER(-3),8+4*ER(-3),0,0,(3+ER(-3))/2,
3*E(3)^2,20*E(3),0,8-4*ER(-3),3*E(3),-E(3)^2,-E(3),-8-4*ER(-3),0,-1,0,0,0,0,0,
210*E(3)^2,6*E(3)^2,6*E(3)^2,-2*E(3)^2,0,0,E(3),0,-24,-8+4*ER(-3),4,
(3-ER(-3))/2,-20*E(3)^2,-3*E(3)^2,E(3)^2,-10+2*ER(-3),(3+ER(-3))/2,0,0,-210,
-6,-6,2,0,0,24*E(3),2+6*ER(-3),-4*E(3),-ER(-3),20,3,-1,(3-ER(-3))/2,210*E(3),
6*E(3),6*E(3),-E(3),-20*E(3),-3*E(3),E(3),-2*E(3),-210*E(3)^2,-6*E(3)^2,
-6*E(3)^2,20*E(3)^2,3*E(3)^2,-E(3)^2,2*E(3)^2],[210,20,-3,6,-1,2,-10+2*ER(-3),
0,-10-2*ER(-3),0,0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,0,0,-3,0,-E(3),-E(3),E(3)^2,
-E(3)^2,E(3),-1,0,-E(3)^2,-24*E(3)^2,0,3,0,0,-24*E(3),0,0,2-6*ER(-3),-1,
2+6*ER(-3),-1,0,-4*E(3)^2,0,-4*E(3),0,0,ER(-3),-ER(-3),0,0,0,0,0,0,0,0,0,0,0,
4,-3*E(3),0,0,0,0,-3*E(3)^2,6,0,0,0,0,0,1,0,0,0,0,(-3+ER(-3))/2,E(3),0,
-2-6*ER(-3),-ER(-3),0,0,E(3)^2,-E(3),0,0,0,-210*E(3)^2,(-3-ER(-3))/2,
-6*E(3)^2,-6*E(3)^2,-2*E(3)^2,0,0,0,0,3*E(3)^2,1,24*E(3),24,4*E(3),
10-2*ER(-3),-8+4*ER(-3),0,0,(3-ER(-3))/2,3*E(3),-20*E(3)^2,0,-8-4*ER(-3),
3*E(3)^2,E(3),E(3)^2,8-4*ER(-3),0,1,0,0,0,0,0,210*E(3),6*E(3),6*E(3),2*E(3),0,
0,-E(3)^2,0,-24,8+4*ER(-3),-4,(3+ER(-3))/2,20*E(3),-3*E(3),-E(3),10+2*ER(-3),
(3-ER(-3))/2,0,0,-210,-6,-6,-2,0,0,24*E(3)^2,-2+6*ER(-3),4*E(3)^2,ER(-3),-20,
3,1,(3+ER(-3))/2,210*E(3)^2,6*E(3)^2,6*E(3)^2,E(3)^2,20*E(3)^2,-3*E(3)^2,
-E(3)^2,2*E(3)^2,-210*E(3),-6*E(3),-6*E(3),-20*E(3),3*E(3),E(3),-2*E(3)],[210,
-20,-3,6,1,-2,10-2*ER(-3),0,10+2*ER(-3),0,0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,0,0,
-3,0,E(3),E(3),-E(3)^2,E(3)^2,-E(3),1,0,E(3)^2,-24*E(3)^2,0,3,0,0,-24*E(3),0,
0,-2+6*ER(-3),1,-2-6*ER(-3),1,0,4*E(3)^2,0,4*E(3),0,0,ER(-3),-ER(-3),0,0,0,0,
0,0,0,0,0,0,0,-4,-3*E(3),0,0,0,0,-3*E(3)^2,6,0,0,0,0,0,-1,0,0,0,0,
(-3+ER(-3))/2,-E(3),0,2+6*ER(-3),-ER(-3),0,0,-E(3)^2,E(3),0,0,0,-210*E(3)^2,
(-3-ER(-3))/2,-6*E(3)^2,-6*E(3)^2,2*E(3)^2,0,0,0,0,3*E(3)^2,-1,24*E(3),24,
-4*E(3),-10+2*ER(-3),8-4*ER(-3),0,0,(3-ER(-3))/2,3*E(3),20*E(3)^2,0,
8+4*ER(-3),3*E(3)^2,-E(3),-E(3)^2,-8+4*ER(-3),0,-1,0,0,0,0,0,210*E(3),6*E(3),
6*E(3),-2*E(3),0,0,E(3)^2,0,-24,-8-4*ER(-3),4,(3+ER(-3))/2,-20*E(3),-3*E(3),
E(3),-10-2*ER(-3),(3-ER(-3))/2,0,0,-210,-6,-6,2,0,0,24*E(3)^2,2-6*ER(-3),
-4*E(3)^2,ER(-3),20,3,-1,(3+ER(-3))/2,210*E(3)^2,6*E(3)^2,6*E(3)^2,-E(3)^2,
-20*E(3)^2,-3*E(3)^2,E(3)^2,-2*E(3)^2,-210*E(3),-6*E(3),-6*E(3),20*E(3),
3*E(3),-E(3),2*E(3)],[280,-40,10,-8,2,0,-4-6*ER(-3),8,-4+6*ER(-3),-2,1,0,
(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,-2,-2,0,-E(3),0,-E(3)^2,0,-E(3),0,-1,
-E(3)^2,10,0,-2,1,0,10,0,0,-4-6*ER(-3),-E(3)^2,-4+6*ER(-3),-E(3),-1,-1,-1,-1,
0,0,(-1-3*ER(-3))/2,(-1+3*ER(-3))/2,0,0,1,0,0,1,0,1,0,0,0,-1,-2,0,1,1,0,-2,0,
0,0,0,0,0,0,0,0,1,0,(-1-3*ER(-3))/2,0,1,-4+6*ER(-3),(-1-3*ER(-3))/2,0,0,-E(3),
-E(3)^2,0,0,0,280,(-1+3*ER(-3))/2,-8,0,0,8,1,-2,-2,-2,-E(3),10,10,-1,
-4-6*ER(-3),-4+6*ER(-3),-1,1,(-1+3*ER(-3))/2,-2,-40,1,-4-6*ER(-3),10,-E(3)^2,
2,-4+6*ER(-3),0,-E(3)^2,0,0,0,0,0,280,0,-8,0,8,-2,-E(3),0,10,-4-6*ER(-3),-1,
(-1+3*ER(-3))/2,-40,10,2,-4+6*ER(-3),(-1-3*ER(-3))/2,0,0,280,-8,0,0,-2,0,10,
-4-6*ER(-3),-1,(-1+3*ER(-3))/2,-40,10,2,(-1-3*ER(-3))/2,280,0,-8,0,-40,10,2,0,
280,0,-8,-40,10,2,0],[280,-40,10,-8,2,0,-4+6*ER(-3),8,-4-6*ER(-3),-2,1,0,
(-1-3*ER(-3))/2,(-1+3*ER(-3))/2,0,-2,-2,0,-E(3)^2,0,-E(3),0,-E(3)^2,0,-1,
-E(3),10,0,-2,1,0,10,0,0,-4+6*ER(-3),-E(3),-4-6*ER(-3),-E(3)^2,-1,-1,-1,-1,0,
0,(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,0,1,0,0,1,0,1,0,0,0,-1,-2,0,1,1,0,-2,0,0,
0,0,0,0,0,0,0,1,0,(-1+3*ER(-3))/2,0,1,-4-6*ER(-3),(-1+3*ER(-3))/2,0,0,-E(3)^2,
-E(3),0,0,0,280,(-1-3*ER(-3))/2,-8,0,0,8,1,-2,-2,-2,-E(3)^2,10,10,-1,
-4+6*ER(-3),-4-6*ER(-3),-1,1,(-1-3*ER(-3))/2,-2,-40,1,-4+6*ER(-3),10,-E(3),2,
-4-6*ER(-3),0,-E(3),0,0,0,0,0,280,0,-8,0,8,-2,-E(3)^2,0,10,-4+6*ER(-3),-1,
(-1-3*ER(-3))/2,-40,10,2,-4-6*ER(-3),(-1+3*ER(-3))/2,0,0,280,-8,0,0,-2,0,10,
-4+6*ER(-3),-1,(-1-3*ER(-3))/2,-40,10,2,(-1+3*ER(-3))/2,280,0,-8,0,-40,10,2,0,
280,0,-8,-40,10,2,0],[280,40,10,-8,-2,0,4+6*ER(-3),-8,4-6*ER(-3),-2,1,0,
(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,-2,-2,0,E(3),0,E(3)^2,0,E(3),0,1,E(3)^2,10,
0,-2,1,0,10,0,0,4+6*ER(-3),E(3)^2,4-6*ER(-3),E(3),1,1,1,1,0,0,(-1-3*ER(-3))/2,
(-1+3*ER(-3))/2,0,0,1,0,0,1,0,1,0,0,0,1,-2,0,1,1,0,-2,0,0,0,0,0,0,0,0,0,1,0,
(-1-3*ER(-3))/2,0,1,4-6*ER(-3),(-1-3*ER(-3))/2,0,0,E(3),E(3)^2,0,0,0,280,
(-1+3*ER(-3))/2,-8,0,0,-8,1,-2,-2,-2,E(3),10,10,1,4+6*ER(-3),4-6*ER(-3),1,1,
(-1+3*ER(-3))/2,-2,40,1,4+6*ER(-3),10,E(3)^2,-2,4-6*ER(-3),0,E(3)^2,0,0,0,0,0,
280,0,-8,0,-8,-2,E(3),0,10,4+6*ER(-3),1,(-1+3*ER(-3))/2,40,10,-2,4-6*ER(-3),
(-1-3*ER(-3))/2,0,0,280,-8,0,0,-2,0,10,4+6*ER(-3),1,(-1+3*ER(-3))/2,40,10,-2,
(-1-3*ER(-3))/2,280,0,-8,0,40,10,-2,0,280,0,-8,40,10,-2,0],[280,40,10,-8,-2,0,
4-6*ER(-3),-8,4+6*ER(-3),-2,1,0,(-1-3*ER(-3))/2,(-1+3*ER(-3))/2,0,-2,-2,0,
E(3)^2,0,E(3),0,E(3)^2,0,1,E(3),10,0,-2,1,0,10,0,0,4-6*ER(-3),E(3),4+6*ER(-3),
E(3)^2,1,1,1,1,0,0,(-1+3*ER(-3))/2,(-1-3*ER(-3))/2,0,0,1,0,0,1,0,1,0,0,0,1,-2,
0,1,1,0,-2,0,0,0,0,0,0,0,0,0,1,0,(-1+3*ER(-3))/2,0,1,4+6*ER(-3),
(-1+3*ER(-3))/2,0,0,E(3)^2,E(3),0,0,0,280,(-1-3*ER(-3))/2,-8,0,0,-8,1,-2,-2,
-2,E(3)^2,10,10,1,4-6*ER(-3),4+6*ER(-3),1,1,(-1-3*ER(-3))/2,-2,40,1,
4-6*ER(-3),10,E(3),-2,4+6*ER(-3),0,E(3),0,0,0,0,0,280,0,-8,0,-8,-2,E(3)^2,0,
10,4-6*ER(-3),1,(-1-3*ER(-3))/2,40,10,-2,4+6*ER(-3),(-1+3*ER(-3))/2,0,0,280,
-8,0,0,-2,0,10,4-6*ER(-3),1,(-1-3*ER(-3))/2,40,10,-2,(-1+3*ER(-3))/2,280,0,-8,
0,40,10,-2,0,280,0,-8,40,10,-2,0],[315,-75,18,11,0,-3,-3,-3,-3,-1,0,0,0,0,-1,
-1,2,0,0,0,0,0,0,0,0,0,-9,0,2,-1,0,-9,-1,0,-3,0,-3,0,3,3,0,3,1,1,0,0,0,0,-1,1,
-1,-1,-1,0,1,0,0,3,2,0,-1,-1,0,2,-1,-1,1,0,-1,0,0,-1,1,-9,0,0,0,0,-3,0,-1,-1,
0,0,1,0,1,315,0,11,-1,-3,-3,0,-1,-1,2,0,-9,-9,3,-3,-3,3,-1,0,2,-75,-9,-3,18,0,
0,-3,-1,0,0,-1,0,-1,1,315,-1,11,-3,-3,-1,0,1,-9,-3,3,0,-75,18,0,-3,0,0,1,315,
11,-1,-3,-1,1,-9,-3,3,0,-75,18,0,0,315,-1,11,0,-75,18,0,-3,315,-1,11,-75,18,0,
-3],[315,75,18,11,0,3,3,3,3,-1,0,0,0,0,-1,-1,2,0,0,0,0,0,0,0,0,0,-9,0,2,-1,0,
-9,1,0,3,0,3,0,-3,-3,0,-3,-1,-1,0,0,0,0,-1,1,-1,-1,-1,0,1,0,0,-3,2,0,-1,-1,0,
2,-1,-1,-1,0,1,0,0,1,-1,-9,0,0,0,0,3,0,-1,-1,0,0,1,0,-1,315,0,11,-1,3,3,0,-1,
-1,2,0,-9,-9,-3,3,3,-3,-1,0,2,75,-9,3,18,0,0,3,-1,0,0,-1,0,-1,-1,315,-1,11,3,
3,-1,0,-1,-9,3,-3,0,75,18,0,3,0,0,-1,315,11,-1,3,-1,-1,-9,3,-3,0,75,18,0,0,
315,-1,11,0,75,18,0,3,315,-1,11,75,18,0,3],[315,-15,-9,11,-3,1,3,9,3,-1,0,0,0,
0,-1,-1,-1,0,0,1,0,1,0,1,0,0,-9,0,-1,2,0,-9,-1,0,3,0,3,0,0,0,0,0,-1,-1,0,0,0,
0,2,1,-1,2,-1,0,1,0,0,0,-1,0,2,2,0,-1,-1,-1,-1,0,-1,0,1,-1,-1,18,0,0,1,0,3,0,
-1,-1,0,0,1,0,5,315,0,11,-1,1,9,0,-1,-1,-1,0,-9,-9,0,3,3,0,2,0,-1,-15,18,3,-9,
0,-3,3,-1,0,0,-1,0,-1,5,315,-1,11,1,9,-1,0,-1,-9,3,0,0,-15,-9,-3,3,0,0,5,315,
11,-1,1,-1,-1,-9,3,0,0,-15,-9,-3,0,315,-1,11,1,-15,-9,-3,1,315,-1,11,-15,-9,
-3,1],[315,15,-9,11,3,-1,-3,-9,-3,-1,0,0,0,0,-1,-1,-1,0,0,-1,0,-1,0,-1,0,0,-9,
0,-1,2,0,-9,1,0,-3,0,-3,0,0,0,0,0,1,1,0,0,0,0,2,1,-1,2,-1,0,1,0,0,0,-1,0,2,2,
0,-1,-1,-1,1,0,1,0,-1,1,1,18,0,0,-1,0,-3,0,-1,-1,0,0,1,0,-5,315,0,11,-1,-1,-9,
0,-1,-1,-1,0,-9,-9,0,-3,-3,0,2,0,-1,15,18,-3,-9,0,3,-3,-1,0,0,-1,0,-1,-5,315,
-1,11,-1,-9,-1,0,1,-9,-3,0,0,15,-9,3,-3,0,0,-5,315,11,-1,-1,-1,1,-9,-3,0,0,15,
-9,3,0,315,-1,11,-1,15,-9,3,-1,315,-1,11,15,-9,3,-1],[315,45,9,-5,-3,1,0,-3,0,
4*E(3)^2,0,0,0,0,-1,4*E(3),1,0,0,E(3),0,E(3)^2,0,1,0,0,-36*E(3)^2,0,1,-2,0,
-36*E(3),1,0,0,0,0,0,0,-6*E(3)^2,0,-6*E(3),0,0,0,0,0,0,-2*E(3),-E(3)^2,0,
-2*E(3)^2,0,0,-E(3),0,0,-6,E(3),0,-2*E(3)^2,-2*E(3),0,E(3)^2,3,0,0,0,E(3),0,1,
E(3)^2,0,0,0,0,E(3),0,0,0,0,-E(3),0,0,-1,0,-3*E(3),315*E(3)^2,0,-5*E(3)^2,
3*E(3)^2,E(3)^2,-3*E(3)^2,0,4*E(3),4,E(3)^2,0,-36*E(3),-36,-6*E(3),0,0,0,-2,0,
E(3),45*E(3)^2,0,0,9*E(3)^2,0,-3*E(3)^2,0,0,0,0,0,0,-E(3)^2,-3,315*E(3),
3*E(3),-5*E(3),E(3),-3*E(3),4,0,0,-36,0,-6,0,45*E(3),9*E(3),-3*E(3),0,0,0,
-3*E(3)^2,315,-5,3,1,4*E(3)^2,0,-36*E(3)^2,0,-6*E(3)^2,0,45,9,-3,0,315*E(3)^2,
3*E(3)^2,-5*E(3)^2,E(3)^2,45*E(3)^2,9*E(3)^2,-3*E(3)^2,E(3)^2,315*E(3),3*E(3),
-5*E(3),45*E(3),9*E(3),-3*E(3),E(3)],[315,-45,9,-5,3,-1,0,3,0,4*E(3)^2,0,0,0,
0,-1,4*E(3),1,0,0,-E(3),0,-E(3)^2,0,-1,0,0,-36*E(3)^2,0,1,-2,0,-36*E(3),-1,0,
0,0,0,0,0,6*E(3)^2,0,6*E(3),0,0,0,0,0,0,-2*E(3),-E(3)^2,0,-2*E(3)^2,0,0,-E(3),
0,0,6,E(3),0,-2*E(3)^2,-2*E(3),0,E(3)^2,3,0,0,0,-E(3),0,-1,-E(3)^2,0,0,0,0,
-E(3),0,0,0,0,-E(3),0,0,-1,0,3*E(3),315*E(3)^2,0,-5*E(3)^2,3*E(3)^2,-E(3)^2,
3*E(3)^2,0,4*E(3),4,E(3)^2,0,-36*E(3),-36,6*E(3),0,0,0,-2,0,E(3),-45*E(3)^2,0,
0,9*E(3)^2,0,3*E(3)^2,0,0,0,0,0,0,-E(3)^2,3,315*E(3),3*E(3),-5*E(3),-E(3),
3*E(3),4,0,0,-36,0,6,0,-45*E(3),9*E(3),3*E(3),0,0,0,3*E(3)^2,315,-5,3,-1,
4*E(3)^2,0,-36*E(3)^2,0,6*E(3)^2,0,-45,9,3,0,315*E(3)^2,3*E(3)^2,-5*E(3)^2,
-E(3)^2,-45*E(3)^2,9*E(3)^2,3*E(3)^2,-E(3)^2,315*E(3),3*E(3),-5*E(3),-45*E(3),
9*E(3),3*E(3),-E(3)],[315,45,9,-5,-3,1,0,-3,0,4*E(3),0,0,0,0,-1,4*E(3)^2,1,0,
0,E(3)^2,0,E(3),0,1,0,0,-36*E(3),0,1,-2,0,-36*E(3)^2,1,0,0,0,0,0,0,-6*E(3),0,
-6*E(3)^2,0,0,0,0,0,0,-2*E(3)^2,-E(3),0,-2*E(3),0,0,-E(3)^2,0,0,-6,E(3)^2,0,
-2*E(3),-2*E(3)^2,0,E(3),3,0,0,0,E(3)^2,0,1,E(3),0,0,0,0,E(3)^2,0,0,0,0,
-E(3)^2,0,0,-1,0,-3*E(3)^2,315*E(3),0,-5*E(3),3*E(3),E(3),-3*E(3),0,4*E(3)^2,
4,E(3),0,-36*E(3)^2,-36,-6*E(3)^2,0,0,0,-2,0,E(3)^2,45*E(3),0,0,9*E(3),0,
-3*E(3),0,0,0,0,0,0,-E(3),-3,315*E(3)^2,3*E(3)^2,-5*E(3)^2,E(3)^2,-3*E(3)^2,4,
0,0,-36,0,-6,0,45*E(3)^2,9*E(3)^2,-3*E(3)^2,0,0,0,-3*E(3),315,-5,3,1,4*E(3),0,
-36*E(3),0,-6*E(3),0,45,9,-3,0,315*E(3),3*E(3),-5*E(3),E(3),45*E(3),9*E(3),
-3*E(3),E(3),315*E(3)^2,3*E(3)^2,-5*E(3)^2,45*E(3)^2,9*E(3)^2,-3*E(3)^2,
E(3)^2],[315,-45,9,-5,3,-1,0,3,0,4*E(3),0,0,0,0,-1,4*E(3)^2,1,0,0,-E(3)^2,0,
-E(3),0,-1,0,0,-36*E(3),0,1,-2,0,-36*E(3)^2,-1,0,0,0,0,0,0,6*E(3),0,6*E(3)^2,
0,0,0,0,0,0,-2*E(3)^2,-E(3),0,-2*E(3),0,0,-E(3)^2,0,0,6,E(3)^2,0,-2*E(3),
-2*E(3)^2,0,E(3),3,0,0,0,-E(3)^2,0,-1,-E(3),0,0,0,0,-E(3)^2,0,0,0,0,-E(3)^2,0,
0,-1,0,3*E(3)^2,315*E(3),0,-5*E(3),3*E(3),-E(3),3*E(3),0,4*E(3)^2,4,E(3),0,
-36*E(3)^2,-36,6*E(3)^2,0,0,0,-2,0,E(3)^2,-45*E(3),0,0,9*E(3),0,3*E(3),0,0,0,
0,0,0,-E(3),3,315*E(3)^2,3*E(3)^2,-5*E(3)^2,-E(3)^2,3*E(3)^2,4,0,0,-36,0,6,0,
-45*E(3)^2,9*E(3)^2,3*E(3)^2,0,0,0,3*E(3),315,-5,3,-1,4*E(3),0,-36*E(3),0,
6*E(3),0,-45,9,3,0,315*E(3),3*E(3),-5*E(3),-E(3),-45*E(3),9*E(3),3*E(3),-E(3),
315*E(3)^2,3*E(3)^2,-5*E(3)^2,-45*E(3)^2,9*E(3)^2,3*E(3)^2,-E(3)^2],[336,-64,
6,16,-4,0,5-ER(-3),0,5+ER(-3),-2*E(3)^2,0,1,(-3+ER(-3))/2,(-3-ER(-3))/2,0,
-2*E(3),-2,1,-E(3),0,-E(3)^2,0,-E(3),0,0,-E(3)^2,-6*E(3)^2,0,-2,-2,0,-6*E(3),
0,1,-1+3*ER(-3),-1,-1-3*ER(-3),-1,0,2*E(3)^2,0,2*E(3),0,0,ER(-3),-ER(-3),E(3),
E(3)^2,-2*E(3),0,0,-2*E(3)^2,0,0,0,E(3)^2,E(3),2,-2*E(3),0,-2*E(3)^2,-2*E(3),
0,-2*E(3)^2,0,0,0,E(3),0,E(3)^2,0,0,0,0,0,(3-ER(-3))/2,0,0,-1-3*ER(-3),ER(-3),
0,0,-E(3)^2,-E(3),0,E(3),0,336*E(3)^2,(3+ER(-3))/2,16*E(3)^2,0,0,0,0,-2*E(3),
-2,-2*E(3)^2,-1,-6*E(3),-6,2*E(3),5-ER(-3),-4+2*ER(-3),0,-2,(-3+ER(-3))/2,
-2*E(3),-64*E(3)^2,0,-4-2*ER(-3),6*E(3)^2,-E(3),-4*E(3)^2,-4+2*ER(-3),0,-1,1,
0,0,0,0,336*E(3),0,16*E(3),0,0,-2,-E(3)^2,0,-6,-4-2*ER(-3),2,(3+ER(-3))/2,
-64*E(3),6*E(3),-4*E(3),5+ER(-3),(3-ER(-3))/2,E(3)^2,0,336,16,0,0,-2*E(3)^2,0,
-6*E(3)^2,-1+3*ER(-3),2*E(3)^2,-ER(-3),-64,6,-4,(-3-ER(-3))/2,336*E(3)^2,0,
16*E(3)^2,0,-64*E(3)^2,6*E(3)^2,-4*E(3)^2,0,336*E(3),0,16*E(3),-64*E(3),
6*E(3),-4*E(3),0],[336,64,6,16,4,0,-5+ER(-3),0,-5-ER(-3),-2*E(3)^2,0,1,
(-3+ER(-3))/2,(-3-ER(-3))/2,0,-2*E(3),-2,-1,E(3),0,E(3)^2,0,E(3),0,0,E(3)^2,
-6*E(3)^2,0,-2,-2,0,-6*E(3),0,-1,1-3*ER(-3),1,1+3*ER(-3),1,0,-2*E(3)^2,0,
-2*E(3),0,0,ER(-3),-ER(-3),E(3),E(3)^2,-2*E(3),0,0,-2*E(3)^2,0,0,0,-E(3)^2,
-E(3),-2,-2*E(3),0,-2*E(3)^2,-2*E(3),0,-2*E(3)^2,0,0,0,-E(3),0,-E(3)^2,0,0,0,
0,0,(3-ER(-3))/2,0,0,1+3*ER(-3),ER(-3),0,0,E(3)^2,E(3),0,E(3),0,336*E(3)^2,
(3+ER(-3))/2,16*E(3)^2,0,0,0,0,-2*E(3),-2,-2*E(3)^2,1,-6*E(3),-6,-2*E(3),
-5+ER(-3),4-2*ER(-3),0,-2,(-3+ER(-3))/2,-2*E(3),64*E(3)^2,0,4+2*ER(-3),
6*E(3)^2,E(3),4*E(3)^2,4-2*ER(-3),0,1,1,0,0,0,0,336*E(3),0,16*E(3),0,0,-2,
E(3)^2,0,-6,4+2*ER(-3),-2,(3+ER(-3))/2,64*E(3),6*E(3),4*E(3),-5-ER(-3),
(3-ER(-3))/2,E(3)^2,0,336,16,0,0,-2*E(3)^2,0,-6*E(3)^2,1-3*ER(-3),-2*E(3)^2,
-ER(-3),64,6,4,(-3-ER(-3))/2,336*E(3)^2,0,16*E(3)^2,0,64*E(3)^2,6*E(3)^2,
4*E(3)^2,0,336*E(3),0,16*E(3),64*E(3),6*E(3),4*E(3),0],[336,-64,6,16,-4,0,
5+ER(-3),0,5-ER(-3),-2*E(3),0,1,(-3-ER(-3))/2,(-3+ER(-3))/2,0,-2*E(3)^2,-2,1,
-E(3)^2,0,-E(3),0,-E(3)^2,0,0,-E(3),-6*E(3),0,-2,-2,0,-6*E(3)^2,0,1,
-1-3*ER(-3),-1,-1+3*ER(-3),-1,0,2*E(3),0,2*E(3)^2,0,0,-ER(-3),ER(-3),E(3)^2,
E(3),-2*E(3)^2,0,0,-2*E(3),0,0,0,E(3),E(3)^2,2,-2*E(3)^2,0,-2*E(3),-2*E(3)^2,
0,-2*E(3),0,0,0,E(3)^2,0,E(3),0,0,0,0,0,(3+ER(-3))/2,0,0,-1+3*ER(-3),-ER(-3),
0,0,-E(3),-E(3)^2,0,E(3)^2,0,336*E(3),(3-ER(-3))/2,16*E(3),0,0,0,0,-2*E(3)^2,
-2,-2*E(3),-1,-6*E(3)^2,-6,2*E(3)^2,5+ER(-3),-4-2*ER(-3),0,-2,(-3-ER(-3))/2,
-2*E(3)^2,-64*E(3),0,-4+2*ER(-3),6*E(3),-E(3)^2,-4*E(3),-4-2*ER(-3),0,-1,1,0,
0,0,0,336*E(3)^2,0,16*E(3)^2,0,0,-2,-E(3),0,-6,-4+2*ER(-3),2,(3-ER(-3))/2,
-64*E(3)^2,6*E(3)^2,-4*E(3)^2,5-ER(-3),(3+ER(-3))/2,E(3),0,336,16,0,0,-2*E(3),
0,-6*E(3),-1-3*ER(-3),2*E(3),ER(-3),-64,6,-4,(-3+ER(-3))/2,336*E(3),0,16*E(3),
0,-64*E(3),6*E(3),-4*E(3),0,336*E(3)^2,0,16*E(3)^2,-64*E(3)^2,6*E(3)^2,
-4*E(3)^2,0],[336,64,6,16,4,0,-5-ER(-3),0,-5+ER(-3),-2*E(3),0,1,(-3-ER(-3))/2,
(-3+ER(-3))/2,0,-2*E(3)^2,-2,-1,E(3)^2,0,E(3),0,E(3)^2,0,0,E(3),-6*E(3),0,-2,
-2,0,-6*E(3)^2,0,-1,1+3*ER(-3),1,1-3*ER(-3),1,0,-2*E(3),0,-2*E(3)^2,0,0,
-ER(-3),ER(-3),E(3)^2,E(3),-2*E(3)^2,0,0,-2*E(3),0,0,0,-E(3),-E(3)^2,-2,
-2*E(3)^2,0,-2*E(3),-2*E(3)^2,0,-2*E(3),0,0,0,-E(3)^2,0,-E(3),0,0,0,0,0,
(3+ER(-3))/2,0,0,1-3*ER(-3),-ER(-3),0,0,E(3),E(3)^2,0,E(3)^2,0,336*E(3),
(3-ER(-3))/2,16*E(3),0,0,0,0,-2*E(3)^2,-2,-2*E(3),1,-6*E(3)^2,-6,-2*E(3)^2,
-5-ER(-3),4+2*ER(-3),0,-2,(-3-ER(-3))/2,-2*E(3)^2,64*E(3),0,4-2*ER(-3),6*E(3),
E(3)^2,4*E(3),4+2*ER(-3),0,1,1,0,0,0,0,336*E(3)^2,0,16*E(3)^2,0,0,-2,E(3),0,
-6,4-2*ER(-3),-2,(3-ER(-3))/2,64*E(3)^2,6*E(3)^2,4*E(3)^2,-5+ER(-3),
(3+ER(-3))/2,E(3),0,336,16,0,0,-2*E(3),0,-6*E(3),1+3*ER(-3),-2*E(3),ER(-3),64,
6,4,(-3+ER(-3))/2,336*E(3),0,16*E(3),0,64*E(3),6*E(3),4*E(3),0,336*E(3)^2,0,
16*E(3)^2,64*E(3)^2,6*E(3)^2,4*E(3)^2,0],[336,16,6,-16,-2,0,1-7*ER(-3),0,
1+7*ER(-3),2*E(3),0,1,(-3-ER(-3))/2,(-3+ER(-3))/2,0,2*E(3)^2,2,1,E(3)^2,0,
-E(3),0,-E(3)^2,0,0,E(3),-6*E(3),0,-2,2,0,-6*E(3)^2,0,-1,-11+3*ER(-3),1,
-11-3*ER(-3),1,0,-2*E(3),0,-2*E(3)^2,0,0,-ER(-3),ER(-3),-E(3)^2,-E(3),
2*E(3)^2,0,0,2*E(3),0,0,0,-E(3),-E(3)^2,2,2*E(3)^2,0,-2*E(3),-2*E(3)^2,0,
2*E(3),0,0,0,E(3)^2,0,E(3),0,0,0,0,0,(-3-ER(-3))/2,0,0,11+3*ER(-3),ER(-3),0,0,
-E(3),E(3)^2,0,E(3)^2,0,-336*E(3),(-3+ER(-3))/2,16*E(3),0,0,0,0,-2*E(3)^2,-2,
-2*E(3),-1,6*E(3)^2,6,2*E(3)^2,-1+7*ER(-3),-10+4*ER(-3),0,-2,(3+ER(-3))/2,
-2*E(3)^2,-16*E(3),0,-10-4*ER(-3),-6*E(3),-E(3)^2,2*E(3),10-4*ER(-3),0,-1,-1,
0,0,0,0,336*E(3)^2,0,-16*E(3)^2,0,0,2,E(3),0,-6,10+4*ER(-3),-2,(3-ER(-3))/2,
16*E(3)^2,6*E(3)^2,-2*E(3)^2,-1-7*ER(-3),(3+ER(-3))/2,E(3),0,-336,16,0,0,
-2*E(3),0,6*E(3),11-3*ER(-3),2*E(3),-ER(-3),-16,-6,2,(3-ER(-3))/2,336*E(3),0,
-16*E(3),0,16*E(3),6*E(3),-2*E(3),0,-336*E(3)^2,0,16*E(3)^2,-16*E(3)^2,
-6*E(3)^2,2*E(3)^2,0],[336,-16,6,-16,2,0,-1-7*ER(-3),0,-1+7*ER(-3),2*E(3)^2,0,
1,(-3+ER(-3))/2,(-3-ER(-3))/2,0,2*E(3),2,-1,-E(3),0,E(3)^2,0,E(3),0,0,-E(3)^2,
-6*E(3)^2,0,-2,2,0,-6*E(3),0,1,11+3*ER(-3),-1,11-3*ER(-3),-1,0,2*E(3)^2,0,
2*E(3),0,0,ER(-3),-ER(-3),-E(3),-E(3)^2,2*E(3),0,0,2*E(3)^2,0,0,0,E(3)^2,E(3),
-2,2*E(3),0,-2*E(3)^2,-2*E(3),0,2*E(3)^2,0,0,0,-E(3),0,-E(3)^2,0,0,0,0,0,
(-3+ER(-3))/2,0,0,-11+3*ER(-3),-ER(-3),0,0,E(3)^2,-E(3),0,E(3),0,-336*E(3)^2,
(-3-ER(-3))/2,16*E(3)^2,0,0,0,0,-2*E(3),-2,-2*E(3)^2,1,6*E(3),6,-2*E(3),
1+7*ER(-3),10+4*ER(-3),0,-2,(3-ER(-3))/2,-2*E(3),16*E(3)^2,0,10-4*ER(-3),
-6*E(3)^2,E(3),-2*E(3)^2,-10-4*ER(-3),0,1,-1,0,0,0,0,336*E(3),0,-16*E(3),0,0,
2,-E(3)^2,0,-6,-10+4*ER(-3),2,(3+ER(-3))/2,-16*E(3),6*E(3),2*E(3),1-7*ER(-3),
(3-ER(-3))/2,E(3)^2,0,-336,16,0,0,-2*E(3)^2,0,6*E(3)^2,-11-3*ER(-3),-2*E(3)^2,
ER(-3),16,-6,-2,(3+ER(-3))/2,336*E(3)^2,0,-16*E(3)^2,0,-16*E(3)^2,6*E(3)^2,
2*E(3)^2,0,-336*E(3),0,16*E(3),16*E(3),-6*E(3),-2*E(3),0],[336,16,6,-16,-2,0,
1+7*ER(-3),0,1-7*ER(-3),2*E(3)^2,0,1,(-3+ER(-3))/2,(-3-ER(-3))/2,0,2*E(3),2,1,
E(3),0,-E(3)^2,0,-E(3),0,0,E(3)^2,-6*E(3)^2,0,-2,2,0,-6*E(3),0,-1,
-11-3*ER(-3),1,-11+3*ER(-3),1,0,-2*E(3)^2,0,-2*E(3),0,0,ER(-3),-ER(-3),-E(3),
-E(3)^2,2*E(3),0,0,2*E(3)^2,0,0,0,-E(3)^2,-E(3),2,2*E(3),0,-2*E(3)^2,-2*E(3),
0,2*E(3)^2,0,0,0,E(3),0,E(3)^2,0,0,0,0,0,(-3+ER(-3))/2,0,0,11-3*ER(-3),
-ER(-3),0,0,-E(3)^2,E(3),0,E(3),0,-336*E(3)^2,(-3-ER(-3))/2,16*E(3)^2,0,0,0,0,
-2*E(3),-2,-2*E(3)^2,-1,6*E(3),6,2*E(3),-1-7*ER(-3),-10-4*ER(-3),0,-2,
(3-ER(-3))/2,-2*E(3),-16*E(3)^2,0,-10+4*ER(-3),-6*E(3)^2,-E(3),2*E(3)^2,
10+4*ER(-3),0,-1,-1,0,0,0,0,336*E(3),0,-16*E(3),0,0,2,E(3)^2,0,-6,10-4*ER(-3),
-2,(3+ER(-3))/2,16*E(3),6*E(3),-2*E(3),-1+7*ER(-3),(3-ER(-3))/2,E(3)^2,0,-336,
16,0,0,-2*E(3)^2,0,6*E(3)^2,11+3*ER(-3),2*E(3)^2,ER(-3),-16,-6,2,(3+ER(-3))/2,
336*E(3)^2,0,-16*E(3)^2,0,16*E(3)^2,6*E(3)^2,-2*E(3)^2,0,-336*E(3),0,16*E(3),
-16*E(3),-6*E(3),2*E(3),0],[336,-16,6,-16,2,0,-1+7*ER(-3),0,-1-7*ER(-3),
2*E(3),0,1,(-3-ER(-3))/2,(-3+ER(-3))/2,0,2*E(3)^2,2,-1,-E(3)^2,0,E(3),0,
E(3)^2,0,0,-E(3),-6*E(3),0,-2,2,0,-6*E(3)^2,0,1,11-3*ER(-3),-1,11+3*ER(-3),-1,
0,2*E(3),0,2*E(3)^2,0,0,-ER(-3),ER(-3),-E(3)^2,-E(3),2*E(3)^2,0,0,2*E(3),0,0,
0,E(3),E(3)^2,-2,2*E(3)^2,0,-2*E(3),-2*E(3)^2,0,2*E(3),0,0,0,-E(3)^2,0,-E(3),
0,0,0,0,0,(-3-ER(-3))/2,0,0,-11-3*ER(-3),ER(-3),0,0,E(3),-E(3)^2,0,E(3)^2,0,
-336*E(3),(-3+ER(-3))/2,16*E(3),0,0,0,0,-2*E(3)^2,-2,-2*E(3),1,6*E(3)^2,6,
-2*E(3)^2,1-7*ER(-3),10-4*ER(-3),0,-2,(3+ER(-3))/2,-2*E(3)^2,16*E(3),0,
10+4*ER(-3),-6*E(3),E(3)^2,-2*E(3),-10+4*ER(-3),0,1,-1,0,0,0,0,336*E(3)^2,0,
-16*E(3)^2,0,0,2,-E(3),0,-6,-10-4*ER(-3),2,(3-ER(-3))/2,-16*E(3)^2,6*E(3)^2,
2*E(3)^2,1+7*ER(-3),(3+ER(-3))/2,E(3),0,-336,16,0,0,-2*E(3),0,6*E(3),
-11+3*ER(-3),-2*E(3),-ER(-3),16,-6,-2,(3-ER(-3))/2,336*E(3),0,-16*E(3),0,
-16*E(3),6*E(3),2*E(3),0,-336*E(3)^2,0,16*E(3)^2,16*E(3)^2,-6*E(3)^2,
-2*E(3)^2,0],[384,64,12,0,-2,0,-8*E(3),0,-8*E(3)^2,0,0,-1,-ER(-3),ER(-3),0,0,
0,-1,1,0,-1,0,-1,0,0,1,24*E(3),E(3),0,0,E(3)^2,24*E(3)^2,0,1,-8,E(3)^2,-8,
E(3),0,4*E(3),0,4*E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,E(3)^2,E(3),0,0,0,0,
0,0,0,E(3),E(3)^2,-4,0,-E(3)^2,0,0,-E(3),0,0,0,0,-E(3)^2,0,-E(3),0,0,0,0,1,
(-3+ER(-3))/2,0,0,8,(3+ER(-3))/2,0,0,-E(3)^2,E(3),0,-E(3)^2,0,-384*E(3),
(-3-ER(-3))/2,0,0,0,0,0,0,0,0,-E(3),-24*E(3)^2,-24,-4*E(3)^2,8*E(3),8*E(3),0,
0,ER(-3),0,-64*E(3),0,8*E(3)^2,-12*E(3),-E(3),2*E(3),-8*E(3),0,-E(3)^2,1,0,-1,
0,0,384*E(3)^2,0,0,0,0,0,E(3)^2,0,24,-8*E(3)^2,4,(3+ER(-3))/2,64*E(3)^2,
12*E(3)^2,-2*E(3)^2,8*E(3)^2,(3-ER(-3))/2,-E(3),0,-384,0,0,0,0,0,-24*E(3),8,
-4*E(3),(3-ER(-3))/2,-64,-12,2,-ER(-3),384*E(3),0,0,0,64*E(3),12*E(3),-2*E(3),
0,-384*E(3)^2,0,0,-64*E(3)^2,-12*E(3)^2,2*E(3)^2,0],[384,-64,12,0,2,0,8*E(3),
0,8*E(3)^2,0,0,-1,-ER(-3),ER(-3),0,0,0,1,-1,0,1,0,1,0,0,-1,24*E(3),E(3),0,0,
E(3)^2,24*E(3)^2,0,-1,8,-E(3)^2,8,-E(3),0,-4*E(3),0,-4*E(3)^2,0,0,
(-3-ER(-3))/2,(-3+ER(-3))/2,E(3)^2,E(3),0,0,0,0,0,0,0,-E(3),-E(3)^2,4,0,
-E(3)^2,0,0,-E(3),0,0,0,0,E(3)^2,0,E(3),0,0,0,0,1,(-3+ER(-3))/2,0,0,-8,
(3+ER(-3))/2,0,0,E(3)^2,-E(3),0,-E(3)^2,0,-384*E(3),(-3-ER(-3))/2,0,0,0,0,0,0,
0,0,E(3),-24*E(3)^2,-24,4*E(3)^2,-8*E(3),-8*E(3),0,0,ER(-3),0,64*E(3),0,
-8*E(3)^2,-12*E(3),E(3),-2*E(3),8*E(3),0,E(3)^2,1,0,-1,0,0,384*E(3)^2,0,0,0,0,
0,-E(3)^2,0,24,8*E(3)^2,-4,(3+ER(-3))/2,-64*E(3)^2,12*E(3)^2,2*E(3)^2,
-8*E(3)^2,(3-ER(-3))/2,-E(3),0,-384,0,0,0,0,0,-24*E(3),-8,4*E(3),(3-ER(-3))/2,
64,-12,-2,-ER(-3),384*E(3),0,0,0,-64*E(3),12*E(3),2*E(3),0,-384*E(3)^2,0,0,
64*E(3)^2,-12*E(3)^2,-2*E(3)^2,0],[384,64,12,0,-2,0,-8*E(3)^2,0,-8*E(3),0,0,
-1,ER(-3),-ER(-3),0,0,0,-1,1,0,-1,0,-1,0,0,1,24*E(3)^2,E(3)^2,0,0,E(3),
24*E(3),0,1,-8,E(3),-8,E(3)^2,0,4*E(3)^2,0,4*E(3),0,0,(-3+ER(-3))/2,
(-3-ER(-3))/2,E(3),E(3)^2,0,0,0,0,0,0,0,E(3)^2,E(3),-4,0,-E(3),0,0,-E(3)^2,0,
0,0,0,-E(3),0,-E(3)^2,0,0,0,0,1,(-3-ER(-3))/2,0,0,8,(3-ER(-3))/2,0,0,-E(3),
E(3)^2,0,-E(3),0,-384*E(3)^2,(-3+ER(-3))/2,0,0,0,0,0,0,0,0,-E(3)^2,-24*E(3),
-24,-4*E(3),8*E(3)^2,8*E(3)^2,0,0,-ER(-3),0,-64*E(3)^2,0,8*E(3),-12*E(3)^2,
-E(3)^2,2*E(3)^2,-8*E(3)^2,0,-E(3),1,0,-1,0,0,384*E(3),0,0,0,0,0,E(3),0,24,
-8*E(3),4,(3-ER(-3))/2,64*E(3),12*E(3),-2*E(3),8*E(3),(3+ER(-3))/2,-E(3)^2,0,
-384,0,0,0,0,0,-24*E(3)^2,8,-4*E(3)^2,(3+ER(-3))/2,-64,-12,2,ER(-3),
384*E(3)^2,0,0,0,64*E(3)^2,12*E(3)^2,-2*E(3)^2,0,-384*E(3),0,0,-64*E(3),
-12*E(3),2*E(3),0],[384,-64,12,0,2,0,8*E(3)^2,0,8*E(3),0,0,-1,ER(-3),-ER(-3),
0,0,0,1,-1,0,1,0,1,0,0,-1,24*E(3)^2,E(3)^2,0,0,E(3),24*E(3),0,-1,8,-E(3),8,
-E(3)^2,0,-4*E(3)^2,0,-4*E(3),0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,E(3),E(3)^2,0,0,
0,0,0,0,0,-E(3)^2,-E(3),4,0,-E(3),0,0,-E(3)^2,0,0,0,0,E(3),0,E(3)^2,0,0,0,0,1,
(-3-ER(-3))/2,0,0,-8,(3-ER(-3))/2,0,0,E(3),-E(3)^2,0,-E(3),0,-384*E(3)^2,
(-3+ER(-3))/2,0,0,0,0,0,0,0,0,E(3)^2,-24*E(3),-24,4*E(3),-8*E(3)^2,-8*E(3)^2,
0,0,-ER(-3),0,64*E(3)^2,0,-8*E(3),-12*E(3)^2,E(3)^2,-2*E(3)^2,8*E(3)^2,0,E(3),
1,0,-1,0,0,384*E(3),0,0,0,0,0,-E(3),0,24,8*E(3),-4,(3-ER(-3))/2,-64*E(3),
12*E(3),2*E(3),-8*E(3),(3+ER(-3))/2,-E(3)^2,0,-384,0,0,0,0,0,-24*E(3)^2,-8,
4*E(3)^2,(3+ER(-3))/2,64,-12,-2,ER(-3),384*E(3)^2,0,0,0,-64*E(3)^2,12*E(3)^2,
2*E(3)^2,0,-384*E(3),0,0,64*E(3),-12*E(3),-2*E(3),0],[384,-64,12,0,2,0,
8*E(3)^2,0,8*E(3),0,0,-1,ER(-3),-ER(-3),0,0,0,1,-1,0,-1,0,-1,0,0,-1,24*E(3)^2,
-E(3)^2,0,0,-E(3),24*E(3),0,1,8,-E(3),8,-E(3)^2,0,-4*E(3)^2,0,-4*E(3),0,0,
(-3+ER(-3))/2,(-3-ER(-3))/2,-E(3),-E(3)^2,0,0,0,0,0,0,0,E(3)^2,E(3),-4,0,
-E(3),0,0,-E(3)^2,0,0,0,0,E(3),0,E(3)^2,0,0,0,0,-1,(3+ER(-3))/2,0,0,8,
(-3+ER(-3))/2,0,0,-E(3),-E(3)^2,0,-E(3),0,384*E(3)^2,(3-ER(-3))/2,0,0,0,0,0,0,
0,0,-E(3)^2,24*E(3),24,-4*E(3),8*E(3)^2,8*E(3)^2,0,0,ER(-3),0,-64*E(3)^2,0,
8*E(3),12*E(3)^2,-E(3)^2,2*E(3)^2,8*E(3)^2,0,-E(3),-1,0,-1,0,0,384*E(3),0,0,0,
0,0,-E(3),0,24,8*E(3),-4,(3-ER(-3))/2,-64*E(3),12*E(3),2*E(3),8*E(3),
(3+ER(-3))/2,-E(3)^2,0,384,0,0,0,0,0,24*E(3)^2,8,-4*E(3)^2,(-3-ER(-3))/2,-64,
12,2,-ER(-3),384*E(3)^2,0,0,0,-64*E(3)^2,12*E(3)^2,2*E(3)^2,0,384*E(3),0,0,
-64*E(3),12*E(3),2*E(3),0],[384,64,12,0,-2,0,-8*E(3)^2,0,-8*E(3),0,0,-1,
ER(-3),-ER(-3),0,0,0,-1,1,0,1,0,1,0,0,1,24*E(3)^2,-E(3)^2,0,0,-E(3),24*E(3),0,
-1,-8,E(3),-8,E(3)^2,0,4*E(3)^2,0,4*E(3),0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,
-E(3),-E(3)^2,0,0,0,0,0,0,0,-E(3)^2,-E(3),4,0,-E(3),0,0,-E(3)^2,0,0,0,0,-E(3),
0,-E(3)^2,0,0,0,0,-1,(3+ER(-3))/2,0,0,-8,(-3+ER(-3))/2,0,0,E(3),E(3)^2,0,
-E(3),0,384*E(3)^2,(3-ER(-3))/2,0,0,0,0,0,0,0,0,E(3)^2,24*E(3),24,4*E(3),
-8*E(3)^2,-8*E(3)^2,0,0,ER(-3),0,64*E(3)^2,0,-8*E(3),12*E(3)^2,E(3)^2,
-2*E(3)^2,-8*E(3)^2,0,E(3),-1,0,-1,0,0,384*E(3),0,0,0,0,0,E(3),0,24,-8*E(3),4,
(3-ER(-3))/2,64*E(3),12*E(3),-2*E(3),-8*E(3),(3+ER(-3))/2,-E(3)^2,0,384,0,0,0,
0,0,24*E(3)^2,-8,4*E(3)^2,(-3-ER(-3))/2,64,12,-2,-ER(-3),384*E(3)^2,0,0,0,
64*E(3)^2,12*E(3)^2,-2*E(3)^2,0,384*E(3),0,0,64*E(3),12*E(3),-2*E(3),0],[384,
-64,12,0,2,0,8*E(3),0,8*E(3)^2,0,0,-1,-ER(-3),ER(-3),0,0,0,1,-1,0,-1,0,-1,0,0,
-1,24*E(3),-E(3),0,0,-E(3)^2,24*E(3)^2,0,1,8,-E(3)^2,8,-E(3),0,-4*E(3),0,
-4*E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,-E(3)^2,-E(3),0,0,0,0,0,0,0,E(3),
E(3)^2,-4,0,-E(3)^2,0,0,-E(3),0,0,0,0,E(3)^2,0,E(3),0,0,0,0,-1,(3-ER(-3))/2,0,
0,8,(-3-ER(-3))/2,0,0,-E(3)^2,-E(3),0,-E(3)^2,0,384*E(3),(3+ER(-3))/2,0,0,0,0,
0,0,0,0,-E(3),24*E(3)^2,24,-4*E(3)^2,8*E(3),8*E(3),0,0,-ER(-3),0,-64*E(3),0,
8*E(3)^2,12*E(3),-E(3),2*E(3),8*E(3),0,-E(3)^2,-1,0,-1,0,0,384*E(3)^2,0,0,0,0,
0,-E(3)^2,0,24,8*E(3)^2,-4,(3+ER(-3))/2,-64*E(3)^2,12*E(3)^2,2*E(3)^2,
8*E(3)^2,(3-ER(-3))/2,-E(3),0,384,0,0,0,0,0,24*E(3),8,-4*E(3),(-3+ER(-3))/2,
-64,12,2,ER(-3),384*E(3),0,0,0,-64*E(3),12*E(3),2*E(3),0,384*E(3)^2,0,0,
-64*E(3)^2,12*E(3)^2,2*E(3)^2,0],[384,64,12,0,-2,0,-8*E(3),0,-8*E(3)^2,0,0,-1,
-ER(-3),ER(-3),0,0,0,-1,1,0,1,0,1,0,0,1,24*E(3),-E(3),0,0,-E(3)^2,24*E(3)^2,0,
-1,-8,E(3)^2,-8,E(3),0,4*E(3),0,4*E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,
-E(3)^2,-E(3),0,0,0,0,0,0,0,-E(3),-E(3)^2,4,0,-E(3)^2,0,0,-E(3),0,0,0,0,
-E(3)^2,0,-E(3),0,0,0,0,-1,(3-ER(-3))/2,0,0,-8,(-3-ER(-3))/2,0,0,E(3)^2,E(3),
0,-E(3)^2,0,384*E(3),(3+ER(-3))/2,0,0,0,0,0,0,0,0,E(3),24*E(3)^2,24,4*E(3)^2,
-8*E(3),-8*E(3),0,0,-ER(-3),0,64*E(3),0,-8*E(3)^2,12*E(3),E(3),-2*E(3),
-8*E(3),0,E(3)^2,-1,0,-1,0,0,384*E(3)^2,0,0,0,0,0,E(3)^2,0,24,-8*E(3)^2,4,
(3+ER(-3))/2,64*E(3)^2,12*E(3)^2,-2*E(3)^2,-8*E(3)^2,(3-ER(-3))/2,-E(3),0,384,
0,0,0,0,0,24*E(3),-8,4*E(3),(-3+ER(-3))/2,64,12,-2,ER(-3),384*E(3),0,0,0,
64*E(3),12*E(3),-2*E(3),0,384*E(3)^2,0,0,64*E(3)^2,12*E(3)^2,-2*E(3)^2,0],
[420,-60,6,4,0,0,3,4,3,1,-3,0,0,0,0,1,-2,0,0,0,0,0,0,0,1,0,-39,0,-2,-2,0,-39,
0,0,3,0,3,0,-2,6,1,6,-1,-1,0,0,0,0,-2,0,1,-2,1,0,0,0,0,6,-2,0,-2,-2,0,-2,4,1,
-1,0,0,0,0,0,-1,6,0,0,0,0,3,0,1,0,0,0,0,0,-4,420,0,4,4,0,4,-3,1,1,-2,0,-39,
-39,6,3,3,-2,-2,0,-2,-60,6,3,6,0,0,3,1,0,0,1,0,0,-4,420,4,4,0,4,1,0,-1,-39,3,
6,0,-60,6,0,3,0,0,-4,420,4,4,0,1,-1,-39,3,6,0,-60,6,0,0,420,4,4,0,-60,6,0,0,
420,4,4,-60,6,0,0],[420,60,6,4,0,0,-3,-4,-3,1,-3,0,0,0,0,1,-2,0,0,0,0,0,0,0,
-1,0,-39,0,-2,-2,0,-39,0,0,-3,0,-3,0,2,-6,-1,-6,1,1,0,0,0,0,-2,0,1,-2,1,0,0,0,
0,-6,-2,0,-2,-2,0,-2,4,1,1,0,0,0,0,0,1,6,0,0,0,0,-3,0,1,0,0,0,0,0,4,420,0,4,4,
0,-4,-3,1,1,-2,0,-39,-39,-6,-3,-3,2,-2,0,-2,60,6,-3,6,0,0,-3,1,0,0,1,0,0,4,
420,4,4,0,-4,1,0,1,-39,-3,-6,0,60,6,0,-3,0,0,4,420,4,4,0,1,1,-39,-3,-6,0,60,6,
0,0,420,4,4,0,60,6,0,0,420,4,4,60,6,0,0],[420,0,6,-20,0,0,0,0,0,-2,6,0,0,0,0,
-2,-2,0,0,0,0,0,0,0,0,0,42,0,2,-2,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-2,0,
-2,-2,-2,0,0,0,0,0,-2,0,2,2,0,-2,4,2,0,0,0,0,0,0,0,6,0,0,0,0,0,0,-2,0,0,0,0,0,
0,-420,0,20,-4,0,0,-6,2,2,2,0,-42,-42,0,0,0,0,2,0,2,0,-6,0,-6,0,0,0,2,0,0,2,0,
0,0,420,4,-20,0,0,-2,0,0,42,0,0,0,0,6,0,0,0,0,0,-420,20,-4,0,2,0,-42,0,0,0,0,
-6,0,0,420,4,-20,0,0,6,0,0,-420,-4,20,0,-6,0,0],[420,80,12,12,2,0,
(1+5*ER(-3))/2,0,(1-5*ER(-3))/2,-3*E(3),0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,0,
-3*E(3)^2,0,0,-E(3),0,E(3)^2,0,E(3),0,0,-E(3)^2,-21*E(3),0,0,0,0,-21*E(3)^2,0,
0,(7-3*ER(-3))/2,-E(3),(7+3*ER(-3))/2,-E(3)^2,0,-4*E(3),0,-4*E(3)^2,
(-3-ER(-3))/2,(-3+ER(-3))/2,(3-ER(-3))/2,(3+ER(-3))/2,0,0,0,0,-E(3),0,-E(3)^2,
0,0,0,0,4,0,0,0,0,0,0,-4,1,-ER(-3),0,0,0,0,0,ER(-3),0,0,-ER(-3),0,0,
(-7-3*ER(-3))/2,(-3+ER(-3))/2,-1,0,1,-1,0,0,0,-420*E(3),ER(-3),-12*E(3),
4*E(3),0,0,0,3*E(3)^2,3,0,E(3)^2,21*E(3)^2,21,4*E(3)^2,(-1-5*ER(-3))/2,
4-ER(-3),0,0,(3-ER(-3))/2,0,-80*E(3),0,4+ER(-3),-12*E(3),1,-2*E(3),-4+ER(-3),
E(3),E(3),0,E(3)^2,0,0,0,420*E(3)^2,-4*E(3)^2,12*E(3)^2,0,0,-3,-1,
(3+ER(-3))/2,-21,-4-ER(-3),-4,-ER(-3),80*E(3)^2,12*E(3)^2,2*E(3)^2,
(-1+5*ER(-3))/2,ER(-3),0,0,-420,-12,4,0,3*E(3),(3-ER(-3))/2,21*E(3),
(-7+3*ER(-3))/2,4*E(3),(-3-ER(-3))/2,-80,-12,-2,(3+ER(-3))/2,420*E(3),-4*E(3),
12*E(3),0,80*E(3),12*E(3),2*E(3),0,-420*E(3)^2,4*E(3)^2,-12*E(3)^2,-80*E(3)^2,
-12*E(3)^2,-2*E(3)^2,0],[420,-80,12,12,-2,0,(-1+5*ER(-3))/2,0,(-1-5*ER(-3))/2,
-3*E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,0,-3*E(3),0,0,E(3)^2,0,-E(3),0,
-E(3)^2,0,0,E(3),-21*E(3)^2,0,0,0,0,-21*E(3),0,0,(-7-3*ER(-3))/2,E(3)^2,
(-7+3*ER(-3))/2,E(3),0,4*E(3)^2,0,4*E(3),(3-ER(-3))/2,(3+ER(-3))/2,
(3+ER(-3))/2,(3-ER(-3))/2,0,0,0,0,-E(3)^2,0,-E(3),0,0,0,0,-4,0,0,0,0,0,0,-4,1,
-ER(-3),0,0,0,0,0,ER(-3),0,0,ER(-3),0,0,(7-3*ER(-3))/2,(-3-ER(-3))/2,-1,0,-1,
1,0,0,0,-420*E(3)^2,-ER(-3),-12*E(3)^2,4*E(3)^2,0,0,0,3*E(3),3,0,-E(3),
21*E(3),21,-4*E(3),(1-5*ER(-3))/2,-4-ER(-3),0,0,(3+ER(-3))/2,0,80*E(3)^2,0,
-4+ER(-3),-12*E(3)^2,-1,2*E(3)^2,4+ER(-3),E(3)^2,-E(3)^2,0,E(3),0,0,0,
420*E(3),-4*E(3),12*E(3),0,0,-3,1,(-3+ER(-3))/2,-21,4-ER(-3),4,ER(-3),
-80*E(3),12*E(3),-2*E(3),(1+5*ER(-3))/2,-ER(-3),0,0,-420,-12,4,0,3*E(3)^2,
(-3-ER(-3))/2,21*E(3)^2,(7+3*ER(-3))/2,-4*E(3)^2,(-3+ER(-3))/2,80,-12,2,
(3-ER(-3))/2,420*E(3)^2,-4*E(3)^2,12*E(3)^2,0,-80*E(3)^2,12*E(3)^2,-2*E(3)^2,
0,-420*E(3),4*E(3),-12*E(3),80*E(3),-12*E(3),2*E(3),0],[420,80,12,12,2,0,
(1-5*ER(-3))/2,0,(1+5*ER(-3))/2,-3*E(3)^2,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,0,
-3*E(3),0,0,-E(3)^2,0,E(3),0,E(3)^2,0,0,-E(3),-21*E(3)^2,0,0,0,0,-21*E(3),0,0,
(7+3*ER(-3))/2,-E(3)^2,(7-3*ER(-3))/2,-E(3),0,-4*E(3)^2,0,-4*E(3),
(-3+ER(-3))/2,(-3-ER(-3))/2,(3+ER(-3))/2,(3-ER(-3))/2,0,0,0,0,-E(3)^2,0,-E(3),
0,0,0,0,4,0,0,0,0,0,0,-4,1,ER(-3),0,0,0,0,0,-ER(-3),0,0,ER(-3),0,0,
(-7+3*ER(-3))/2,(-3-ER(-3))/2,-1,0,1,-1,0,0,0,-420*E(3)^2,-ER(-3),-12*E(3)^2,
4*E(3)^2,0,0,0,3*E(3),3,0,E(3),21*E(3),21,4*E(3),(-1+5*ER(-3))/2,4+ER(-3),0,0,
(3+ER(-3))/2,0,-80*E(3)^2,0,4-ER(-3),-12*E(3)^2,1,-2*E(3)^2,-4-ER(-3),E(3)^2,
E(3)^2,0,E(3),0,0,0,420*E(3),-4*E(3),12*E(3),0,0,-3,-1,(3-ER(-3))/2,-21,
-4+ER(-3),-4,ER(-3),80*E(3),12*E(3),2*E(3),(-1-5*ER(-3))/2,-ER(-3),0,0,-420,
-12,4,0,3*E(3)^2,(3+ER(-3))/2,21*E(3)^2,(-7-3*ER(-3))/2,4*E(3)^2,
(-3+ER(-3))/2,-80,-12,-2,(3-ER(-3))/2,420*E(3)^2,-4*E(3)^2,12*E(3)^2,0,
80*E(3)^2,12*E(3)^2,2*E(3)^2,0,-420*E(3),4*E(3),-12*E(3),-80*E(3),-12*E(3),
-2*E(3),0],[420,-80,12,12,-2,0,(-1-5*ER(-3))/2,0,(-1+5*ER(-3))/2,-3*E(3),0,0,
(-3+ER(-3))/2,(-3-ER(-3))/2,0,-3*E(3)^2,0,0,E(3),0,-E(3)^2,0,-E(3),0,0,E(3)^2,
-21*E(3),0,0,0,0,-21*E(3)^2,0,0,(-7+3*ER(-3))/2,E(3),(-7-3*ER(-3))/2,E(3)^2,0,
4*E(3),0,4*E(3)^2,(3+ER(-3))/2,(3-ER(-3))/2,(3-ER(-3))/2,(3+ER(-3))/2,0,0,0,0,
-E(3),0,-E(3)^2,0,0,0,0,-4,0,0,0,0,0,0,-4,1,ER(-3),0,0,0,0,0,-ER(-3),0,0,
-ER(-3),0,0,(7+3*ER(-3))/2,(-3+ER(-3))/2,-1,0,-1,1,0,0,0,-420*E(3),ER(-3),
-12*E(3),4*E(3),0,0,0,3*E(3)^2,3,0,-E(3)^2,21*E(3)^2,21,-4*E(3)^2,
(1+5*ER(-3))/2,-4+ER(-3),0,0,(3-ER(-3))/2,0,80*E(3),0,-4-ER(-3),-12*E(3),-1,
2*E(3),4-ER(-3),E(3),-E(3),0,E(3)^2,0,0,0,420*E(3)^2,-4*E(3)^2,12*E(3)^2,0,0,
-3,1,(-3-ER(-3))/2,-21,4+ER(-3),4,-ER(-3),-80*E(3)^2,12*E(3)^2,-2*E(3)^2,
(1-5*ER(-3))/2,ER(-3),0,0,-420,-12,4,0,3*E(3),(-3+ER(-3))/2,21*E(3),
(7-3*ER(-3))/2,-4*E(3),(-3-ER(-3))/2,80,-12,2,(3+ER(-3))/2,420*E(3),-4*E(3),
12*E(3),0,-80*E(3),12*E(3),-2*E(3),0,-420*E(3)^2,4*E(3)^2,-12*E(3)^2,
80*E(3)^2,-12*E(3)^2,2*E(3)^2,0],[420,20,-6,4,2,0,(-11-5*ER(-3))/2,-12,
(-11+5*ER(-3))/2,E(3)^2,0,0,(3-ER(-3))/2,(3+ER(-3))/2,0,E(3),-2,0,-E(3),0,
-E(3)^2,0,-E(3),0,0,-E(3)^2,33*E(3)^2,0,-2,-2,0,33*E(3),0,0,(13-3*ER(-3))/2,
-1,(13+3*ER(-3))/2,-1,0,2*E(3)^2,0,2*E(3),-E(3)^2,-E(3),-ER(-3),ER(-3),0,0,
-2*E(3),0,E(3)^2,-2*E(3)^2,E(3),0,0,0,0,2,-2*E(3),0,-2*E(3)^2,-2*E(3),0,
-2*E(3)^2,4,1,-1,0,0,0,0,0,-1,0,0,(-3+ER(-3))/2,0,0,(13+3*ER(-3))/2,-ER(-3),1,
0,-E(3)^2,-E(3),0,0,-4*E(3),420*E(3)^2,(-3-ER(-3))/2,4*E(3)^2,4*E(3)^2,0,
-12*E(3)^2,0,E(3),1,-2*E(3)^2,-1,33*E(3),33,2*E(3),(-11-5*ER(-3))/2,
-1-4*ER(-3),0,-2,(3-ER(-3))/2,-2*E(3),20*E(3)^2,0,-1+4*ER(-3),-6*E(3)^2,-E(3),
2*E(3)^2,-1-4*ER(-3),E(3)^2,-1,0,E(3),0,0,-4,420*E(3),4*E(3),4*E(3),0,
-12*E(3),1,-E(3)^2,-E(3)^2,33,-1+4*ER(-3),2,(-3-ER(-3))/2,20*E(3),-6*E(3),
2*E(3),(-11+5*ER(-3))/2,(-3+ER(-3))/2,0,-4*E(3)^2,420,4,4,0,E(3)^2,-E(3),
33*E(3)^2,(13-3*ER(-3))/2,2*E(3)^2,ER(-3),20,-6,2,(3+ER(-3))/2,420*E(3)^2,
4*E(3)^2,4*E(3)^2,0,20*E(3)^2,-6*E(3)^2,2*E(3)^2,0,420*E(3),4*E(3),4*E(3),
20*E(3),-6*E(3),2*E(3),0],[420,-20,-6,4,-2,0,(11+5*ER(-3))/2,12,
(11-5*ER(-3))/2,E(3)^2,0,0,(3-ER(-3))/2,(3+ER(-3))/2,0,E(3),-2,0,E(3),0,
E(3)^2,0,E(3),0,0,E(3)^2,33*E(3)^2,0,-2,-2,0,33*E(3),0,0,(-13+3*ER(-3))/2,1,
(-13-3*ER(-3))/2,1,0,-2*E(3)^2,0,-2*E(3),E(3)^2,E(3),-ER(-3),ER(-3),0,0,
-2*E(3),0,E(3)^2,-2*E(3)^2,E(3),0,0,0,0,-2,-2*E(3),0,-2*E(3)^2,-2*E(3),0,
-2*E(3)^2,4,1,1,0,0,0,0,0,1,0,0,(-3+ER(-3))/2,0,0,(-13-3*ER(-3))/2,-ER(-3),1,
0,E(3)^2,E(3),0,0,4*E(3),420*E(3)^2,(-3-ER(-3))/2,4*E(3)^2,4*E(3)^2,0,
12*E(3)^2,0,E(3),1,-2*E(3)^2,1,33*E(3),33,-2*E(3),(11+5*ER(-3))/2,1+4*ER(-3),
0,-2,(3-ER(-3))/2,-2*E(3),-20*E(3)^2,0,1-4*ER(-3),-6*E(3)^2,E(3),-2*E(3)^2,
1+4*ER(-3),E(3)^2,1,0,E(3),0,0,4,420*E(3),4*E(3),4*E(3),0,12*E(3),1,E(3)^2,
E(3)^2,33,1-4*ER(-3),-2,(-3-ER(-3))/2,-20*E(3),-6*E(3),-2*E(3),
(11-5*ER(-3))/2,(-3+ER(-3))/2,0,4*E(3)^2,420,4,4,0,E(3)^2,E(3),33*E(3)^2,
(-13+3*ER(-3))/2,-2*E(3)^2,ER(-3),-20,-6,-2,(3+ER(-3))/2,420*E(3)^2,4*E(3)^2,
4*E(3)^2,0,-20*E(3)^2,-6*E(3)^2,-2*E(3)^2,0,420*E(3),4*E(3),4*E(3),-20*E(3),
-6*E(3),-2*E(3),0],[420,20,-6,4,2,0,(-11+5*ER(-3))/2,-12,(-11-5*ER(-3))/2,
E(3),0,0,(3+ER(-3))/2,(3-ER(-3))/2,0,E(3)^2,-2,0,-E(3)^2,0,-E(3),0,-E(3)^2,0,
0,-E(3),33*E(3),0,-2,-2,0,33*E(3)^2,0,0,(13+3*ER(-3))/2,-1,(13-3*ER(-3))/2,-1,
0,2*E(3),0,2*E(3)^2,-E(3),-E(3)^2,ER(-3),-ER(-3),0,0,-2*E(3)^2,0,E(3),-2*E(3),
E(3)^2,0,0,0,0,2,-2*E(3)^2,0,-2*E(3),-2*E(3)^2,0,-2*E(3),4,1,-1,0,0,0,0,0,-1,
0,0,(-3-ER(-3))/2,0,0,(13-3*ER(-3))/2,ER(-3),1,0,-E(3),-E(3)^2,0,0,-4*E(3)^2,
420*E(3),(-3+ER(-3))/2,4*E(3),4*E(3),0,-12*E(3),0,E(3)^2,1,-2*E(3),-1,
33*E(3)^2,33,2*E(3)^2,(-11+5*ER(-3))/2,-1+4*ER(-3),0,-2,(3+ER(-3))/2,
-2*E(3)^2,20*E(3),0,-1-4*ER(-3),-6*E(3),-E(3)^2,2*E(3),-1+4*ER(-3),E(3),-1,0,
E(3)^2,0,0,-4,420*E(3)^2,4*E(3)^2,4*E(3)^2,0,-12*E(3)^2,1,-E(3),-E(3),33,
-1-4*ER(-3),2,(-3+ER(-3))/2,20*E(3)^2,-6*E(3)^2,2*E(3)^2,(-11-5*ER(-3))/2,
(-3-ER(-3))/2,0,-4*E(3),420,4,4,0,E(3),-E(3)^2,33*E(3),(13+3*ER(-3))/2,2*E(3),
-ER(-3),20,-6,2,(3-ER(-3))/2,420*E(3),4*E(3),4*E(3),0,20*E(3),-6*E(3),2*E(3),
0,420*E(3)^2,4*E(3)^2,4*E(3)^2,20*E(3)^2,-6*E(3)^2,2*E(3)^2,0],[420,-20,-6,4,
-2,0,(11-5*ER(-3))/2,12,(11+5*ER(-3))/2,E(3),0,0,(3+ER(-3))/2,(3-ER(-3))/2,0,
E(3)^2,-2,0,E(3)^2,0,E(3),0,E(3)^2,0,0,E(3),33*E(3),0,-2,-2,0,33*E(3)^2,0,0,
(-13-3*ER(-3))/2,1,(-13+3*ER(-3))/2,1,0,-2*E(3),0,-2*E(3)^2,E(3),E(3)^2,
ER(-3),-ER(-3),0,0,-2*E(3)^2,0,E(3),-2*E(3),E(3)^2,0,0,0,0,-2,-2*E(3)^2,0,
-2*E(3),-2*E(3)^2,0,-2*E(3),4,1,1,0,0,0,0,0,1,0,0,(-3-ER(-3))/2,0,0,
(-13+3*ER(-3))/2,ER(-3),1,0,E(3),E(3)^2,0,0,4*E(3)^2,420*E(3),(-3+ER(-3))/2,
4*E(3),4*E(3),0,12*E(3),0,E(3)^2,1,-2*E(3),1,33*E(3)^2,33,-2*E(3)^2,
(11-5*ER(-3))/2,1-4*ER(-3),0,-2,(3+ER(-3))/2,-2*E(3)^2,-20*E(3),0,1+4*ER(-3),
-6*E(3),E(3)^2,-2*E(3),1-4*ER(-3),E(3),1,0,E(3)^2,0,0,4,420*E(3)^2,4*E(3)^2,
4*E(3)^2,0,12*E(3)^2,1,E(3),E(3),33,1+4*ER(-3),-2,(-3+ER(-3))/2,-20*E(3)^2,
-6*E(3)^2,-2*E(3)^2,(11+5*ER(-3))/2,(-3-ER(-3))/2,0,4*E(3),420,4,4,0,E(3),
E(3)^2,33*E(3),(-13-3*ER(-3))/2,-2*E(3),-ER(-3),-20,-6,-2,(3-ER(-3))/2,
420*E(3),4*E(3),4*E(3),0,-20*E(3),-6*E(3),-2*E(3),0,420*E(3)^2,4*E(3)^2,
4*E(3)^2,-20*E(3)^2,-6*E(3)^2,-2*E(3)^2,0],[504,-96,18,8,0,0,-6,0,-6,2,0,-1,0,
0,0,2,2,-1,0,0,0,0,0,0,0,0,18,0,-2,-1,0,18,0,1,-6,0,-6,0,-3,-3,0,-3,0,0,0,0,1,
1,-1,0,0,-1,0,0,0,1,1,3,2,0,1,1,0,2,0,0,0,-1,0,-1,0,0,0,-9,0,0,0,0,6,0,0,0,0,
0,0,-1,0,-504,0,-8,0,0,0,0,-2,-2,-2,0,-18,-18,3,6,6,3,1,0,-2,96,9,6,-18,0,0,
-6,0,0,1,0,0,0,0,504,0,8,0,0,2,0,0,18,-6,-3,0,-96,18,0,6,0,-1,0,-504,-8,0,0,
-2,0,-18,6,3,0,96,-18,0,0,504,0,8,0,-96,18,0,0,-504,0,-8,96,-18,0,0],[504,96,
18,8,0,0,6,0,6,2,0,-1,0,0,0,2,2,1,0,0,0,0,0,0,0,0,18,0,-2,-1,0,18,0,-1,6,0,6,
0,3,3,0,3,0,0,0,0,1,1,-1,0,0,-1,0,0,0,-1,-1,-3,2,0,1,1,0,2,0,0,0,1,0,1,0,0,0,
-9,0,0,0,0,-6,0,0,0,0,0,0,-1,0,-504,0,-8,0,0,0,0,-2,-2,-2,0,-18,-18,-3,-6,-6,
-3,1,0,-2,-96,9,-6,-18,0,0,6,0,0,1,0,0,0,0,504,0,8,0,0,2,0,0,18,6,3,0,96,18,0,
-6,0,-1,0,-504,-8,0,0,-2,0,-18,-6,-3,0,-96,-18,0,0,504,0,8,0,96,18,0,0,-504,0,
-8,-96,-18,0,0],[504,-24,-9,8,-3,4,-6,0,-6,2,0,-1,0,0,0,2,-1,1,0,1,0,1,0,1,0,
0,18,0,1,2,0,18,0,-1,-6,0,-6,0,0,0,0,0,0,0,0,0,1,1,2,0,0,2,0,0,0,-1,-1,0,-1,0,
-2,-2,0,-1,0,0,0,1,0,1,-1,0,0,18,0,0,-1,0,6,0,0,0,0,0,0,-1,0,-504,0,-8,0,-4,0,
0,-2,-2,1,0,-18,-18,0,6,6,0,-2,0,1,24,-18,6,9,0,3,-6,0,0,1,0,0,0,0,504,0,8,4,
0,2,0,0,18,-6,0,0,-24,-9,-3,6,0,-1,0,-504,-8,0,-4,-2,0,-18,6,0,0,24,9,3,0,504,
0,8,-1,-24,-9,-3,4,-504,0,-8,24,9,3,-4],[504,24,-9,8,3,-4,6,0,6,2,0,-1,0,0,0,
2,-1,-1,0,-1,0,-1,0,-1,0,0,18,0,1,2,0,18,0,1,6,0,6,0,0,0,0,0,0,0,0,0,1,1,2,0,
0,2,0,0,0,1,1,0,-1,0,-2,-2,0,-1,0,0,0,-1,0,-1,1,0,0,18,0,0,1,0,-6,0,0,0,0,0,0,
-1,0,-504,0,-8,0,4,0,0,-2,-2,1,0,-18,-18,0,-6,-6,0,-2,0,1,-24,-18,-6,9,0,-3,6,
0,0,1,0,0,0,0,504,0,8,-4,0,2,0,0,18,6,0,0,24,-9,3,-6,0,-1,0,-504,-8,0,4,-2,0,
-18,-6,0,0,-24,9,-3,0,504,0,8,1,24,-9,3,-4,-504,0,-8,-24,9,-3,4],[540,0,0,-12,
0,0,0,0,0,-6*E(3),0,0,0,0,0,-6*E(3)^2,0,0,0,0,0,0,0,0,0,0,54*E(3),-E(3),0,0,
-E(3)^2,54*E(3)^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-2*E(3),0,-2*E(3)^2,0,0,
0,0,0,0,E(3)^2,0,0,E(3),0,4,2,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,-2,0,0,0,0,0,0,
-540*E(3),0,12*E(3),-4*E(3),0,0,0,6*E(3)^2,6,0,0,-54*E(3)^2,-54,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,2*E(3),0,0,2*E(3)^2,1,0,0,540*E(3)^2,4*E(3)^2,-12*E(3)^2,0,0,-6,
0,0,54,0,0,0,0,0,0,0,0,0,0,-540,12,-4,0,6*E(3),0,-54*E(3),0,0,0,0,0,0,0,
540*E(3),4*E(3),-12*E(3),0,0,0,0,0,-540*E(3)^2,-4*E(3)^2,12*E(3)^2,0,0,0,0],
[540,0,0,-12,0,0,0,0,0,-6*E(3)^2,0,0,0,0,0,-6*E(3),0,0,0,0,0,0,0,0,0,0,
54*E(3)^2,-E(3)^2,0,0,-E(3),54*E(3),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-2*E(3)^2,0,-2*E(3),0,0,0,0,0,0,E(3),0,0,E(3)^2,0,4,2,0,0,0,0,0,0,0,0,-1,0,0,
0,0,0,-2,0,0,0,0,0,0,-540*E(3)^2,0,12*E(3)^2,-4*E(3)^2,0,0,0,6*E(3),6,0,0,
-54*E(3),-54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2*E(3)^2,0,0,2*E(3),1,0,0,540*E(3),
4*E(3),-12*E(3),0,0,-6,0,0,54,0,0,0,0,0,0,0,0,0,0,-540,12,-4,0,6*E(3)^2,0,
-54*E(3)^2,0,0,0,0,0,0,0,540*E(3)^2,4*E(3)^2,-12*E(3)^2,0,0,0,0,0,-540*E(3),
-4*E(3),12*E(3),0,0,0,0],[540,0,0,-12,0,0,9*ER(-3),0,-9*ER(-3),3,0,0,0,0,0,3,
0,0,0,0,0,0,0,0,0,0,-27,-1,0,0,-1,-27,0,0,9*ER(-3),0,-9*ER(-3),0,0,0,0,0,
-ER(-3),ER(-3),0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,0,4,-1,ER(-3),0,0,0,0,0,
-ER(-3),0,-1,0,0,0,9*ER(-3),0,1,0,0,0,0,0,0,-540,0,12,-4,0,0,0,-3,-3,0,0,27,
27,0,-9*ER(-3),9*ER(-3),0,0,0,0,0,0,-9*ER(-3),0,0,0,-9*ER(-3),-1,0,0,-1,1,0,0,
540,4,-12,0,0,3,0,ER(-3),-27,9*ER(-3),0,0,0,0,0,9*ER(-3),0,0,0,-540,12,-4,0,
-3,-ER(-3),27,-9*ER(-3),0,0,0,0,0,0,540,4,-12,0,0,0,0,0,-540,-4,12,0,0,0,0],
[540,0,0,-12,0,0,-9*ER(-3),0,9*ER(-3),3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,-27,
-1,0,0,-1,-27,0,0,-9*ER(-3),0,9*ER(-3),0,0,0,0,0,ER(-3),-ER(-3),0,0,0,0,0,0,1,
0,1,0,0,0,0,0,0,1,0,0,1,0,4,-1,-ER(-3),0,0,0,0,0,ER(-3),0,-1,0,0,0,-9*ER(-3),
0,1,0,0,0,0,0,0,-540,0,12,-4,0,0,0,-3,-3,0,0,27,27,0,9*ER(-3),-9*ER(-3),0,0,0,
0,0,0,9*ER(-3),0,0,0,9*ER(-3),-1,0,0,-1,1,0,0,540,4,-12,0,0,3,0,-ER(-3),-27,
-9*ER(-3),0,0,0,0,0,-9*ER(-3),0,0,0,-540,12,-4,0,-3,ER(-3),27,9*ER(-3),0,0,0,
0,0,0,540,4,-12,0,0,0,0,0,-540,-4,12,0,0,0,0],[560,-80,2,16,-2,0,10,0,10,-2,2,
0,-1,-1,0,-2,-2,0,1,0,-1,0,-1,0,0,1,-34,0,2,-2,0,-34,0,0,10,1,10,1,0,4,0,4,0,
0,-1,-1,0,0,-2,0,0,-2,0,1,0,0,0,-4,-2,0,2,2,0,-2,0,0,0,0,0,0,0,0,0,2,0,1,0,-1,
-10,1,0,0,-1,1,0,0,0,-560,1,-16,0,0,0,-2,2,2,2,-1,34,34,-4,-10,-10,0,2,1,2,80,
-2,-10,-2,-1,2,10,0,-1,0,0,0,0,0,560,0,16,0,0,-2,1,0,-34,10,4,-1,-80,2,-2,-10,
-1,0,0,-560,-16,0,0,2,0,34,-10,-4,1,80,-2,2,1,560,0,16,0,-80,2,-2,0,-560,0,
-16,80,-2,2,0],[560,80,2,16,2,0,-10,0,-10,-2,2,0,-1,-1,0,-2,-2,0,-1,0,1,0,1,0,
0,-1,-34,0,2,-2,0,-34,0,0,-10,-1,-10,-1,0,-4,0,-4,0,0,-1,-1,0,0,-2,0,0,-2,0,1,
0,0,0,4,-2,0,2,2,0,-2,0,0,0,0,0,0,0,0,0,2,0,1,0,-1,10,1,0,0,1,-1,0,0,0,-560,1,
-16,0,0,0,-2,2,2,2,1,34,34,4,10,10,0,2,1,2,-80,-2,10,-2,1,-2,-10,0,1,0,0,0,0,
0,560,0,16,0,0,-2,-1,0,-34,-10,-4,-1,80,2,2,10,-1,0,0,-560,-16,0,0,2,0,34,10,
4,1,-80,-2,-2,1,560,0,16,0,80,2,2,0,-560,0,-16,-80,-2,-2,0],[560,0,2,-16,0,0,
0,0,0,-4,2,0,2,2,0,-4,2,0,0,0,0,0,0,0,0,0,20,0,2,-4,0,20,0,0,0,0,0,0,0,0,0,0,
0,0,2,2,0,0,-4,0,0,-4,0,-1,0,0,0,0,2,0,-4,-4,0,2,0,0,0,0,0,0,0,0,0,20,0,2,0,
-1,0,2,0,0,0,0,0,0,0,560,2,-16,0,0,0,2,-4,-4,2,0,20,20,0,0,0,0,-4,2,2,0,20,0,
2,0,0,0,0,0,0,0,0,0,0,560,0,-16,0,0,-4,0,0,20,0,0,2,0,2,0,0,2,0,0,560,-16,0,0,
-4,0,20,0,0,2,0,2,0,2,560,0,-16,0,0,2,0,0,560,0,-16,0,2,0,0],[560,0,2,-16,0,0,
-6*ER(-3),0,6*ER(-3),2,2,0,-1,-1,0,2,2,0,ER(-3),0,-ER(-3),0,ER(-3),0,0,
-ER(-3),-34,0,2,2,0,-34,0,0,-6*ER(-3),-ER(-3),6*ER(-3),ER(-3),0,0,0,0,0,0,-1,
-1,0,0,2,0,0,2,0,-1,0,0,0,0,2,0,2,2,0,2,0,0,0,0,0,0,0,0,0,2,0,-1,0,-1,
6*ER(-3),-1,0,0,ER(-3),-ER(-3),0,0,0,560,-1,-16,0,0,0,2,2,2,2,ER(-3),-34,-34,
0,-6*ER(-3),6*ER(-3),0,2,-1,2,0,2,-6*ER(-3),2,-ER(-3),0,6*ER(-3),0,-ER(-3),0,
0,0,0,0,560,0,-16,0,0,2,ER(-3),0,-34,-6*ER(-3),0,-1,0,2,0,6*ER(-3),-1,0,0,560,
-16,0,0,2,0,-34,-6*ER(-3),0,-1,0,2,0,-1,560,0,-16,0,0,2,0,0,560,0,-16,0,2,0,
0],[560,0,2,-16,0,0,6*ER(-3),0,-6*ER(-3),2,2,0,-1,-1,0,2,2,0,-ER(-3),0,ER(-3),
0,-ER(-3),0,0,ER(-3),-34,0,2,2,0,-34,0,0,6*ER(-3),ER(-3),-6*ER(-3),-ER(-3),0,
0,0,0,0,0,-1,-1,0,0,2,0,0,2,0,-1,0,0,0,0,2,0,2,2,0,2,0,0,0,0,0,0,0,0,0,2,0,-1,
0,-1,-6*ER(-3),-1,0,0,-ER(-3),ER(-3),0,0,0,560,-1,-16,0,0,0,2,2,2,2,-ER(-3),
-34,-34,0,6*ER(-3),-6*ER(-3),0,2,-1,2,0,2,6*ER(-3),2,ER(-3),0,-6*ER(-3),0,
ER(-3),0,0,0,0,0,560,0,-16,0,0,2,-ER(-3),0,-34,6*ER(-3),0,-1,0,2,0,-6*ER(-3),
-1,0,0,560,-16,0,0,2,0,-34,6*ER(-3),0,-1,0,2,0,-1,560,0,-16,0,0,2,0,0,560,0,
-16,0,2,0,0],[630,-60,9,-14,3,2,-6,0,-6,-2,0,0,0,0,0,-2,1,0,0,-1,0,-1,0,-1,0,
0,-18,0,-1,1,0,-18,0,0,-6,0,-6,0,3,3,0,3,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,-3,1,0,
-1,-1,0,1,-6,0,0,0,0,0,1,0,0,9,0,0,1,0,6,0,0,0,0,0,0,0,0,-630,0,14,6,-2,0,0,2,
2,-1,0,18,18,-3,6,6,-3,-1,0,-1,60,-9,6,-9,0,-3,-6,0,0,0,0,0,0,0,630,-6,-14,2,
0,-2,0,0,-18,-6,3,0,-60,9,3,6,0,0,0,-630,14,6,-2,2,0,18,6,-3,0,60,-9,-3,0,630,
-6,-14,1,-60,9,3,2,-630,6,14,60,-9,-3,-2],[630,60,9,-14,-3,-2,6,0,6,-2,0,0,0,
0,0,-2,1,0,0,1,0,1,0,1,0,0,-18,0,-1,1,0,-18,0,0,6,0,6,0,-3,-3,0,-3,0,0,0,0,0,
0,1,0,0,1,0,0,0,0,0,3,1,0,-1,-1,0,1,-6,0,0,0,0,0,-1,0,0,9,0,0,-1,0,-6,0,0,0,0,
0,0,0,0,-630,0,14,6,2,0,0,2,2,-1,0,18,18,3,-6,-6,3,-1,0,-1,-60,-9,-6,-9,0,3,6,
0,0,0,0,0,0,0,630,-6,-14,-2,0,-2,0,0,-18,6,-3,0,60,9,-3,-6,0,0,0,-630,14,6,2,
2,0,18,-6,3,0,-60,-9,3,0,630,-6,-14,-1,60,9,-3,-2,-630,6,14,-60,-9,3,2],[630,
30,-9,6,-3,2,(-21-3*ER(-3))/2,6,(-21+3*ER(-3))/2,-3*E(3)^2,0,0,0,0,-2,-3*E(3),
3,0,0,-E(3),0,-E(3)^2,0,-1,0,0,9*E(3)^2,0,3,0,0,9*E(3),0,0,(15-9*ER(-3))/2,0,
(15+9*ER(-3))/2,0,0,0,0,0,-E(3)^2,-E(3),0,0,0,0,0,0,-E(3)^2,0,-E(3),0,0,0,0,0,
3*E(3),0,0,0,0,3*E(3)^2,2,-1,-1,0,0,0,-1,0,-1,0,0,0,-E(3),0,(15+9*ER(-3))/2,0,
-1,-2*E(3),0,0,0,0,2*E(3),630*E(3)^2,0,6*E(3)^2,2*E(3)^2,2*E(3)^2,6*E(3)^2,0,
-3*E(3),-3,3*E(3)^2,0,9*E(3),9,0,(-21-3*ER(-3))/2,3-6*ER(-3),0,0,0,3*E(3),
30*E(3)^2,0,3+6*ER(-3),-9*E(3)^2,0,-3*E(3)^2,3-6*ER(-3),-E(3)^2,0,0,-E(3),0,
-2*E(3)^2,2,630*E(3),2*E(3),6*E(3),2*E(3),6*E(3),-3,0,-E(3)^2,9,3+6*ER(-3),0,
0,30*E(3),-9*E(3),-3*E(3),(-21+3*ER(-3))/2,0,0,2*E(3)^2,630,6,2,2,-3*E(3)^2,
-E(3),9*E(3)^2,(15-9*ER(-3))/2,0,0,30,-9,-3,0,630*E(3)^2,2*E(3)^2,6*E(3)^2,
-E(3)^2,30*E(3)^2,-9*E(3)^2,-3*E(3)^2,2*E(3)^2,630*E(3),2*E(3),6*E(3),30*E(3),
-9*E(3),-3*E(3),2*E(3)],[630,-30,-9,6,3,-2,(21+3*ER(-3))/2,-6,(21-3*ER(-3))/2,
-3*E(3)^2,0,0,0,0,-2,-3*E(3),3,0,0,E(3),0,E(3)^2,0,1,0,0,9*E(3)^2,0,3,0,0,
9*E(3),0,0,(-15+9*ER(-3))/2,0,(-15-9*ER(-3))/2,0,0,0,0,0,E(3)^2,E(3),0,0,0,0,
0,0,-E(3)^2,0,-E(3),0,0,0,0,0,3*E(3),0,0,0,0,3*E(3)^2,2,-1,1,0,0,0,1,0,1,0,0,
0,E(3),0,(-15-9*ER(-3))/2,0,-1,-2*E(3),0,0,0,0,-2*E(3),630*E(3)^2,0,6*E(3)^2,
2*E(3)^2,-2*E(3)^2,-6*E(3)^2,0,-3*E(3),-3,3*E(3)^2,0,9*E(3),9,0,
(21+3*ER(-3))/2,-3+6*ER(-3),0,0,0,3*E(3),-30*E(3)^2,0,-3-6*ER(-3),-9*E(3)^2,0,
3*E(3)^2,-3+6*ER(-3),-E(3)^2,0,0,-E(3),0,-2*E(3)^2,-2,630*E(3),2*E(3),6*E(3),
-2*E(3),-6*E(3),-3,0,E(3)^2,9,-3-6*ER(-3),0,0,-30*E(3),-9*E(3),3*E(3),
(21-3*ER(-3))/2,0,0,-2*E(3)^2,630,6,2,-2,-3*E(3)^2,E(3),9*E(3)^2,
(-15+9*ER(-3))/2,0,0,-30,-9,3,0,630*E(3)^2,2*E(3)^2,6*E(3)^2,E(3)^2,
-30*E(3)^2,-9*E(3)^2,3*E(3)^2,-2*E(3)^2,630*E(3),2*E(3),6*E(3),-30*E(3),
-9*E(3),3*E(3),-2*E(3)],[630,30,-9,6,-3,2,(-21+3*ER(-3))/2,6,(-21-3*ER(-3))/2,
-3*E(3),0,0,0,0,-2,-3*E(3)^2,3,0,0,-E(3)^2,0,-E(3),0,-1,0,0,9*E(3),0,3,0,0,
9*E(3)^2,0,0,(15+9*ER(-3))/2,0,(15-9*ER(-3))/2,0,0,0,0,0,-E(3),-E(3)^2,0,0,0,
0,0,0,-E(3),0,-E(3)^2,0,0,0,0,0,3*E(3)^2,0,0,0,0,3*E(3),2,-1,-1,0,0,0,-1,0,-1,
0,0,0,-E(3)^2,0,(15-9*ER(-3))/2,0,-1,-2*E(3)^2,0,0,0,0,2*E(3)^2,630*E(3),0,
6*E(3),2*E(3),2*E(3),6*E(3),0,-3*E(3)^2,-3,3*E(3),0,9*E(3)^2,9,0,
(-21+3*ER(-3))/2,3+6*ER(-3),0,0,0,3*E(3)^2,30*E(3),0,3-6*ER(-3),-9*E(3),0,
-3*E(3),3+6*ER(-3),-E(3),0,0,-E(3)^2,0,-2*E(3),2,630*E(3)^2,2*E(3)^2,6*E(3)^2,
2*E(3)^2,6*E(3)^2,-3,0,-E(3),9,3-6*ER(-3),0,0,30*E(3)^2,-9*E(3)^2,-3*E(3)^2,
(-21-3*ER(-3))/2,0,0,2*E(3),630,6,2,2,-3*E(3),-E(3)^2,9*E(3),(15+9*ER(-3))/2,
0,0,30,-9,-3,0,630*E(3),2*E(3),6*E(3),-E(3),30*E(3),-9*E(3),-3*E(3),2*E(3),
630*E(3)^2,2*E(3)^2,6*E(3)^2,30*E(3)^2,-9*E(3)^2,-3*E(3)^2,2*E(3)^2],[630,-30,
-9,6,3,-2,(21-3*ER(-3))/2,-6,(21+3*ER(-3))/2,-3*E(3),0,0,0,0,-2,-3*E(3)^2,3,0,
0,E(3)^2,0,E(3),0,1,0,0,9*E(3),0,3,0,0,9*E(3)^2,0,0,(-15-9*ER(-3))/2,0,
(-15+9*ER(-3))/2,0,0,0,0,0,E(3),E(3)^2,0,0,0,0,0,0,-E(3),0,-E(3)^2,0,0,0,0,0,
3*E(3)^2,0,0,0,0,3*E(3),2,-1,1,0,0,0,1,0,1,0,0,0,E(3)^2,0,(-15+9*ER(-3))/2,0,
-1,-2*E(3)^2,0,0,0,0,-2*E(3)^2,630*E(3),0,6*E(3),2*E(3),-2*E(3),-6*E(3),0,
-3*E(3)^2,-3,3*E(3),0,9*E(3)^2,9,0,(21-3*ER(-3))/2,-3-6*ER(-3),0,0,0,3*E(3)^2,
-30*E(3),0,-3+6*ER(-3),-9*E(3),0,3*E(3),-3-6*ER(-3),-E(3),0,0,-E(3)^2,0,
-2*E(3),-2,630*E(3)^2,2*E(3)^2,6*E(3)^2,-2*E(3)^2,-6*E(3)^2,-3,0,E(3),9,
-3+6*ER(-3),0,0,-30*E(3)^2,-9*E(3)^2,3*E(3)^2,(21+3*ER(-3))/2,0,0,-2*E(3),630,
6,2,-2,-3*E(3),E(3)^2,9*E(3),(-15-9*ER(-3))/2,0,0,-30,-9,3,0,630*E(3),2*E(3),
6*E(3),E(3),-30*E(3),-9*E(3),3*E(3),-2*E(3),630*E(3)^2,2*E(3)^2,6*E(3)^2,
-30*E(3)^2,-9*E(3)^2,3*E(3)^2,-2*E(3)^2],[630,60,-9,18,3,-2,(-15-3*ER(-3))/2,
0,(-15+3*ER(-3))/2,3*E(3),0,0,0,0,0,3*E(3)^2,3,0,0,E(3)^2,0,E(3),0,1,0,0,
9*E(3),0,-3,0,0,9*E(3)^2,0,0,(3+9*ER(-3))/2,0,(3-9*ER(-3))/2,0,0,0,0,0,
(3+ER(-3))/2,(3-ER(-3))/2,0,0,0,0,0,0,-E(3),0,-E(3)^2,0,0,0,0,0,3*E(3)^2,0,0,
0,0,3*E(3),2,1,ER(-3),0,0,0,-1,0,-ER(-3),0,0,0,-E(3)^2,0,(-3+9*ER(-3))/2,0,-1,
0,0,0,0,0,0,-630*E(3),0,-18*E(3),-2*E(3),2*E(3),0,0,-3*E(3)^2,-3,-3*E(3),0,
-9*E(3)^2,-9,0,(15+3*ER(-3))/2,-6-3*ER(-3),0,0,0,-3*E(3)^2,-60*E(3),0,
-6+3*ER(-3),9*E(3),0,-3*E(3),6+3*ER(-3),E(3),0,0,E(3)^2,0,0,0,630*E(3)^2,
2*E(3)^2,18*E(3)^2,-2*E(3)^2,0,3,0,(-3-ER(-3))/2,9,6-3*ER(-3),0,0,60*E(3)^2,
-9*E(3)^2,3*E(3)^2,(15-3*ER(-3))/2,0,0,0,-630,-18,-2,2,-3*E(3),(-3+ER(-3))/2,
-9*E(3),(-3-9*ER(-3))/2,0,0,-60,9,-3,0,630*E(3),2*E(3),18*E(3),-E(3),60*E(3),
-9*E(3),3*E(3),-2*E(3),-630*E(3)^2,-2*E(3)^2,-18*E(3)^2,-60*E(3)^2,9*E(3)^2,
-3*E(3)^2,2*E(3)^2],[630,-60,-9,18,-3,2,(15-3*ER(-3))/2,0,(15+3*ER(-3))/2,
3*E(3)^2,0,0,0,0,0,3*E(3),3,0,0,-E(3),0,-E(3)^2,0,-1,0,0,9*E(3)^2,0,-3,0,0,
9*E(3),0,0,(-3+9*ER(-3))/2,0,(-3-9*ER(-3))/2,0,0,0,0,0,(-3+ER(-3))/2,
(-3-ER(-3))/2,0,0,0,0,0,0,-E(3)^2,0,-E(3),0,0,0,0,0,3*E(3),0,0,0,0,3*E(3)^2,2,
1,ER(-3),0,0,0,1,0,-ER(-3),0,0,0,E(3),0,(3+9*ER(-3))/2,0,-1,0,0,0,0,0,0,
-630*E(3)^2,0,-18*E(3)^2,-2*E(3)^2,-2*E(3)^2,0,0,-3*E(3),-3,-3*E(3)^2,0,
-9*E(3),-9,0,(-15+3*ER(-3))/2,6-3*ER(-3),0,0,0,-3*E(3),60*E(3)^2,0,6+3*ER(-3),
9*E(3)^2,0,3*E(3)^2,-6+3*ER(-3),E(3)^2,0,0,E(3),0,0,0,630*E(3),2*E(3),18*E(3),
2*E(3),0,3,0,(3-ER(-3))/2,9,-6-3*ER(-3),0,0,-60*E(3),-9*E(3),-3*E(3),
(-15-3*ER(-3))/2,0,0,0,-630,-18,-2,-2,-3*E(3)^2,(3+ER(-3))/2,-9*E(3)^2,
(3-9*ER(-3))/2,0,0,60,9,3,0,630*E(3)^2,2*E(3)^2,18*E(3)^2,E(3)^2,-60*E(3)^2,
-9*E(3)^2,-3*E(3)^2,2*E(3)^2,-630*E(3),-2*E(3),-18*E(3),60*E(3),9*E(3),3*E(3),
-2*E(3)],[630,60,-9,18,3,-2,(-15+3*ER(-3))/2,0,(-15-3*ER(-3))/2,3*E(3)^2,0,0,
0,0,0,3*E(3),3,0,0,E(3),0,E(3)^2,0,1,0,0,9*E(3)^2,0,-3,0,0,9*E(3),0,0,
(3-9*ER(-3))/2,0,(3+9*ER(-3))/2,0,0,0,0,0,(3-ER(-3))/2,(3+ER(-3))/2,0,0,0,0,0,
0,-E(3)^2,0,-E(3),0,0,0,0,0,3*E(3),0,0,0,0,3*E(3)^2,2,1,-ER(-3),0,0,0,-1,0,
ER(-3),0,0,0,-E(3),0,(-3-9*ER(-3))/2,0,-1,0,0,0,0,0,0,-630*E(3)^2,0,
-18*E(3)^2,-2*E(3)^2,2*E(3)^2,0,0,-3*E(3),-3,-3*E(3)^2,0,-9*E(3),-9,0,
(15-3*ER(-3))/2,-6+3*ER(-3),0,0,0,-3*E(3),-60*E(3)^2,0,-6-3*ER(-3),9*E(3)^2,0,
-3*E(3)^2,6-3*ER(-3),E(3)^2,0,0,E(3),0,0,0,630*E(3),2*E(3),18*E(3),-2*E(3),0,
3,0,(-3+ER(-3))/2,9,6+3*ER(-3),0,0,60*E(3),-9*E(3),3*E(3),(15+3*ER(-3))/2,0,0,
0,-630,-18,-2,2,-3*E(3)^2,(-3-ER(-3))/2,-9*E(3)^2,(-3+9*ER(-3))/2,0,0,-60,9,
-3,0,630*E(3)^2,2*E(3)^2,18*E(3)^2,-E(3)^2,60*E(3)^2,-9*E(3)^2,3*E(3)^2,
-2*E(3)^2,-630*E(3),-2*E(3),-18*E(3),-60*E(3),9*E(3),-3*E(3),2*E(3)],[630,-60,
-9,18,-3,2,(15+3*ER(-3))/2,0,(15-3*ER(-3))/2,3*E(3),0,0,0,0,0,3*E(3)^2,3,0,0,
-E(3)^2,0,-E(3),0,-1,0,0,9*E(3),0,-3,0,0,9*E(3)^2,0,0,(-3-9*ER(-3))/2,0,
(-3+9*ER(-3))/2,0,0,0,0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,0,0,0,0,0,0,-E(3),0,
-E(3)^2,0,0,0,0,0,3*E(3)^2,0,0,0,0,3*E(3),2,1,-ER(-3),0,0,0,1,0,ER(-3),0,0,0,
E(3)^2,0,(3-9*ER(-3))/2,0,-1,0,0,0,0,0,0,-630*E(3),0,-18*E(3),-2*E(3),-2*E(3),
0,0,-3*E(3)^2,-3,-3*E(3),0,-9*E(3)^2,-9,0,(-15-3*ER(-3))/2,6+3*ER(-3),0,0,0,
-3*E(3)^2,60*E(3),0,6-3*ER(-3),9*E(3),0,3*E(3),-6-3*ER(-3),E(3),0,0,E(3)^2,0,
0,0,630*E(3)^2,2*E(3)^2,18*E(3)^2,2*E(3)^2,0,3,0,(3+ER(-3))/2,9,-6+3*ER(-3),0,
0,-60*E(3)^2,-9*E(3)^2,-3*E(3)^2,(-15+3*ER(-3))/2,0,0,0,-630,-18,-2,-2,
-3*E(3),(3-ER(-3))/2,-9*E(3),(3+9*ER(-3))/2,0,0,60,9,3,0,630*E(3),2*E(3),
18*E(3),E(3),-60*E(3),-9*E(3),-3*E(3),2*E(3),-630*E(3)^2,-2*E(3)^2,-18*E(3)^2,
60*E(3)^2,9*E(3)^2,3*E(3)^2,-2*E(3)^2],[720,0,-18,16,0,0,0,0,0,4*E(3)^2,0,0,0,
0,0,4*E(3),-2,0,0,0,0,0,0,0,0,0,-36*E(3)^2,-E(3)^2,-2,4,-E(3),-36*E(3),0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,4*E(3),0,0,4*E(3)^2,0,0,0,0,0,0,-2*E(3),-E(3),
4*E(3)^2,4*E(3),-E(3)^2,-2*E(3)^2,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,
0,0,720*E(3)^2,0,16*E(3)^2,0,0,0,0,4*E(3),4,-2*E(3)^2,0,-36*E(3),-36,0,0,0,0,
4,0,-2*E(3),0,0,0,-18*E(3)^2,0,0,0,0,0,0,0,-1,0,0,720*E(3),0,16*E(3),0,0,4,0,
0,-36,0,0,0,0,-18*E(3),0,0,0,0,0,720,16,0,0,4*E(3)^2,0,-36*E(3)^2,0,0,0,0,-18,
0,0,720*E(3)^2,0,16*E(3)^2,0,0,-18*E(3)^2,0,0,720*E(3),0,16*E(3),0,-18*E(3),0,
0],[720,0,-18,16,0,0,0,0,0,4*E(3),0,0,0,0,0,4*E(3)^2,-2,0,0,0,0,0,0,0,0,0,
-36*E(3),-E(3),-2,4,-E(3)^2,-36*E(3)^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
4*E(3)^2,0,0,4*E(3),0,0,0,0,0,0,-2*E(3)^2,-E(3)^2,4*E(3),4*E(3)^2,-E(3),
-2*E(3),0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,720*E(3),0,16*E(3),0,0,
0,0,4*E(3)^2,4,-2*E(3),0,-36*E(3)^2,-36,0,0,0,0,4,0,-2*E(3)^2,0,0,0,-18*E(3),
0,0,0,0,0,0,0,-1,0,0,720*E(3)^2,0,16*E(3)^2,0,0,4,0,0,-36,0,0,0,0,-18*E(3)^2,
0,0,0,0,0,720,16,0,0,4*E(3),0,-36*E(3),0,0,0,0,-18,0,0,720*E(3),0,16*E(3),0,0,
-18*E(3),0,0,720*E(3)^2,0,16*E(3)^2,0,-18*E(3)^2,0,0],[729,-81,0,9,0,3,0,-9,0,
0,0,-1,0,0,1,0,0,-1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,-1,0,0,0,0,0,0,0,0,0,0,0,0,
-1,-1,0,-1,0,0,0,0,-1,-1,-1,0,0,1,0,0,1,0,-3,0,0,-1,1,-1,0,1,0,0,1,0,0,0,0,0,
0,1,0,0,-1,-1,3,729,0,9,-3,3,-9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-81,0,0,0,0,0,0,0,
0,-1,0,1,1,3,729,-3,9,3,-9,0,0,0,0,0,0,0,-81,0,0,0,0,-1,3,729,9,-3,3,0,0,0,0,
0,0,-81,0,0,0,729,-3,9,0,-81,0,0,3,729,-3,9,-81,0,0,3],[729,81,0,9,0,-3,0,9,0,
0,0,-1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,
-1,-1,0,-1,0,0,0,0,-1,1,1,0,0,1,0,0,1,0,-3,0,0,1,-1,1,0,-1,0,0,1,0,0,0,0,0,0,
1,0,0,-1,-1,-3,729,0,9,-3,-3,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,0,0,0,0,0,0,0,0,
-1,0,1,1,-3,729,-3,9,-3,9,0,0,0,0,0,0,0,81,0,0,0,0,-1,-3,729,9,-3,-3,0,0,0,0,
0,0,81,0,0,0,729,-3,9,0,81,0,0,-3,729,-3,9,81,0,0,-3],[729,-81,0,9,0,3,0,-9,0,
0,0,-1,0,0,1,0,0,-1,0,0,0,0,0,0,0,0,0,E(3)^2,0,0,E(3),0,1,-1,0,0,0,0,0,0,0,0,
0,0,0,0,-E(3),-E(3)^2,0,-E(3)^2,0,0,0,0,-E(3),-E(3)^2,-E(3),0,0,E(3),0,0,
E(3)^2,0,-3,0,0,-E(3),E(3),-E(3)^2,0,E(3)^2,0,0,1,0,0,0,0,0,0,E(3),0,0,-1,
-E(3),3*E(3),729*E(3)^2,0,9*E(3)^2,-3*E(3)^2,3*E(3)^2,-9*E(3)^2,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-81*E(3)^2,0,0,0,0,0,0,0,0,-1,0,1,E(3)^2,3,729*E(3),-3*E(3),
9*E(3),3*E(3),-9*E(3),0,0,0,0,0,0,0,-81*E(3),0,0,0,0,-E(3)^2,3*E(3)^2,729,9,
-3,3,0,0,0,0,0,0,-81,0,0,0,729*E(3)^2,-3*E(3)^2,9*E(3)^2,0,-81*E(3)^2,0,0,
3*E(3)^2,729*E(3),-3*E(3),9*E(3),-81*E(3),0,0,3*E(3)],[729,81,0,9,0,-3,0,9,0,
0,0,-1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,E(3)^2,0,0,E(3),0,-1,1,0,0,0,0,0,0,0,0,0,
0,0,0,-E(3),-E(3)^2,0,-E(3)^2,0,0,0,0,-E(3),E(3)^2,E(3),0,0,E(3),0,0,E(3)^2,0,
-3,0,0,E(3),-E(3),E(3)^2,0,-E(3)^2,0,0,1,0,0,0,0,0,0,E(3),0,0,-1,-E(3),
-3*E(3),729*E(3)^2,0,9*E(3)^2,-3*E(3)^2,-3*E(3)^2,9*E(3)^2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,81*E(3)^2,0,0,0,0,0,0,0,0,-1,0,1,E(3)^2,-3,729*E(3),-3*E(3),9*E(3),
-3*E(3),9*E(3),0,0,0,0,0,0,0,81*E(3),0,0,0,0,-E(3)^2,-3*E(3)^2,729,9,-3,-3,0,
0,0,0,0,0,81,0,0,0,729*E(3)^2,-3*E(3)^2,9*E(3)^2,0,81*E(3)^2,0,0,-3*E(3)^2,
729*E(3),-3*E(3),9*E(3),81*E(3),0,0,-3*E(3)],[729,-81,0,9,0,3,0,-9,0,0,0,-1,0,
0,1,0,0,-1,0,0,0,0,0,0,0,0,0,E(3),0,0,E(3)^2,0,1,-1,0,0,0,0,0,0,0,0,0,0,0,0,
-E(3)^2,-E(3),0,-E(3),0,0,0,0,-E(3)^2,-E(3),-E(3)^2,0,0,E(3)^2,0,0,E(3),0,-3,
0,0,-E(3)^2,E(3)^2,-E(3),0,E(3),0,0,1,0,0,0,0,0,0,E(3)^2,0,0,-1,-E(3)^2,
3*E(3)^2,729*E(3),0,9*E(3),-3*E(3),3*E(3),-9*E(3),0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-81*E(3),0,0,0,0,0,0,0,0,-1,0,1,E(3),3,729*E(3)^2,-3*E(3)^2,9*E(3)^2,3*E(3)^2,
-9*E(3)^2,0,0,0,0,0,0,0,-81*E(3)^2,0,0,0,0,-E(3),3*E(3),729,9,-3,3,0,0,0,0,0,
0,-81,0,0,0,729*E(3),-3*E(3),9*E(3),0,-81*E(3),0,0,3*E(3),729*E(3)^2,
-3*E(3)^2,9*E(3)^2,-81*E(3)^2,0,0,3*E(3)^2],[729,81,0,9,0,-3,0,9,0,0,0,-1,0,0,
1,0,0,1,0,0,0,0,0,0,0,0,0,E(3),0,0,E(3)^2,0,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,
-E(3)^2,-E(3),0,-E(3),0,0,0,0,-E(3)^2,E(3),E(3)^2,0,0,E(3)^2,0,0,E(3),0,-3,0,
0,E(3)^2,-E(3)^2,E(3),0,-E(3),0,0,1,0,0,0,0,0,0,E(3)^2,0,0,-1,-E(3)^2,
-3*E(3)^2,729*E(3),0,9*E(3),-3*E(3),-3*E(3),9*E(3),0,0,0,0,0,0,0,0,0,0,0,0,0,
0,81*E(3),0,0,0,0,0,0,0,0,-1,0,1,E(3),-3,729*E(3)^2,-3*E(3)^2,9*E(3)^2,
-3*E(3)^2,9*E(3)^2,0,0,0,0,0,0,0,81*E(3)^2,0,0,0,0,-E(3),-3*E(3),729,9,-3,-3,
0,0,0,0,0,0,81,0,0,0,729*E(3),-3*E(3),9*E(3),0,81*E(3),0,0,-3*E(3),729*E(3)^2,
-3*E(3)^2,9*E(3)^2,81*E(3)^2,0,0,-3*E(3)^2],[756,36,0,-12,0,0,9*E(3),-12,
9*E(3)^2,3*E(3)^2,0,1,0,0,0,3*E(3),0,1,0,0,0,0,0,0,0,0,27*E(3)^2,0,0,0,0,
27*E(3),0,1,9*E(3)^2,0,9*E(3),0,0,0,0,0,E(3)^2,E(3),0,0,E(3),E(3)^2,0,0,
-E(3)^2,0,-E(3),0,0,E(3)^2,E(3),0,0,0,0,0,0,0,-4,-1,1,E(3),0,E(3)^2,0,0,1,0,0,
0,0,0,9*E(3),0,-1,0,0,0,0,E(3),4*E(3),756*E(3)^2,0,-12*E(3)^2,-4*E(3)^2,0,
-12*E(3)^2,0,3*E(3),3,0,0,27*E(3),27,0,9*E(3),9,0,0,0,0,36*E(3)^2,0,9,0,0,0,9,
-E(3)^2,0,1,-E(3),0,0,4,756*E(3),-4*E(3),-12*E(3),0,-12*E(3),3,0,E(3)^2,27,9,
0,0,36*E(3),0,0,9*E(3)^2,0,E(3)^2,4*E(3)^2,756,-12,-4,0,3*E(3)^2,E(3),
27*E(3)^2,9*E(3)^2,0,0,36,0,0,0,756*E(3)^2,-4*E(3)^2,-12*E(3)^2,0,36*E(3)^2,0,
0,0,756*E(3),-4*E(3),-12*E(3),36*E(3),0,0,0],[756,-36,0,-12,0,0,-9*E(3),12,
-9*E(3)^2,3*E(3)^2,0,1,0,0,0,3*E(3),0,-1,0,0,0,0,0,0,0,0,27*E(3)^2,0,0,0,0,
27*E(3),0,-1,-9*E(3)^2,0,-9*E(3),0,0,0,0,0,-E(3)^2,-E(3),0,0,E(3),E(3)^2,0,0,
-E(3)^2,0,-E(3),0,0,-E(3)^2,-E(3),0,0,0,0,0,0,0,-4,-1,-1,-E(3),0,-E(3)^2,0,0,
-1,0,0,0,0,0,-9*E(3),0,-1,0,0,0,0,E(3),-4*E(3),756*E(3)^2,0,-12*E(3)^2,
-4*E(3)^2,0,12*E(3)^2,0,3*E(3),3,0,0,27*E(3),27,0,-9*E(3),-9,0,0,0,0,
-36*E(3)^2,0,-9,0,0,0,-9,-E(3)^2,0,1,-E(3),0,0,-4,756*E(3),-4*E(3),-12*E(3),0,
12*E(3),3,0,-E(3)^2,27,-9,0,0,-36*E(3),0,0,-9*E(3)^2,0,E(3)^2,-4*E(3)^2,756,
-12,-4,0,3*E(3)^2,-E(3),27*E(3)^2,-9*E(3)^2,0,0,-36,0,0,0,756*E(3)^2,
-4*E(3)^2,-12*E(3)^2,0,-36*E(3)^2,0,0,0,756*E(3),-4*E(3),-12*E(3),-36*E(3),0,
0,0],[756,36,0,-12,0,0,9*E(3)^2,-12,9*E(3),3*E(3),0,1,0,0,0,3*E(3)^2,0,1,0,0,
0,0,0,0,0,0,27*E(3),0,0,0,0,27*E(3)^2,0,1,9*E(3),0,9*E(3)^2,0,0,0,0,0,E(3),
E(3)^2,0,0,E(3)^2,E(3),0,0,-E(3),0,-E(3)^2,0,0,E(3),E(3)^2,0,0,0,0,0,0,0,-4,
-1,1,E(3)^2,0,E(3),0,0,1,0,0,0,0,0,9*E(3)^2,0,-1,0,0,0,0,E(3)^2,4*E(3)^2,
756*E(3),0,-12*E(3),-4*E(3),0,-12*E(3),0,3*E(3)^2,3,0,0,27*E(3)^2,27,0,
9*E(3)^2,9,0,0,0,0,36*E(3),0,9,0,0,0,9,-E(3),0,1,-E(3)^2,0,0,4,756*E(3)^2,
-4*E(3)^2,-12*E(3)^2,0,-12*E(3)^2,3,0,E(3),27,9,0,0,36*E(3)^2,0,0,9*E(3),0,
E(3),4*E(3),756,-12,-4,0,3*E(3),E(3)^2,27*E(3),9*E(3),0,0,36,0,0,0,756*E(3),
-4*E(3),-12*E(3),0,36*E(3),0,0,0,756*E(3)^2,-4*E(3)^2,-12*E(3)^2,36*E(3)^2,0,
0,0],[756,-36,0,-12,0,0,-9*E(3)^2,12,-9*E(3),3*E(3),0,1,0,0,0,3*E(3)^2,0,-1,0,
0,0,0,0,0,0,0,27*E(3),0,0,0,0,27*E(3)^2,0,-1,-9*E(3),0,-9*E(3)^2,0,0,0,0,0,
-E(3),-E(3)^2,0,0,E(3)^2,E(3),0,0,-E(3),0,-E(3)^2,0,0,-E(3),-E(3)^2,0,0,0,0,0,
0,0,-4,-1,-1,-E(3)^2,0,-E(3),0,0,-1,0,0,0,0,0,-9*E(3)^2,0,-1,0,0,0,0,E(3)^2,
-4*E(3)^2,756*E(3),0,-12*E(3),-4*E(3),0,12*E(3),0,3*E(3)^2,3,0,0,27*E(3)^2,27,
0,-9*E(3)^2,-9,0,0,0,0,-36*E(3),0,-9,0,0,0,-9,-E(3),0,1,-E(3)^2,0,0,-4,
756*E(3)^2,-4*E(3)^2,-12*E(3)^2,0,12*E(3)^2,3,0,-E(3),27,-9,0,0,-36*E(3)^2,0,
0,-9*E(3),0,E(3),-4*E(3),756,-12,-4,0,3*E(3),-E(3)^2,27*E(3),-9*E(3),0,0,-36,
0,0,0,756*E(3),-4*E(3),-12*E(3),0,-36*E(3),0,0,0,756*E(3)^2,-4*E(3)^2,
-12*E(3)^2,-36*E(3)^2,0,0,0],[840,40,-3,-8,1,-4,7-ER(-3),0,7+ER(-3),-2*E(3),0,
0,(3-ER(-3))/2,(3+ER(-3))/2,0,-2*E(3)^2,1,0,E(3),-E(3)^2,-E(3)^2,-E(3),-E(3),
-1,0,E(3)^2,-42*E(3),0,-1,-2,0,-42*E(3)^2,0,0,-5-3*ER(-3),E(3),-5+3*ER(-3),
E(3)^2,0,-2*E(3),0,-2*E(3)^2,0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,0,0,-2*E(3)^2,0,
0,-2*E(3),0,0,0,0,0,2,E(3)^2,0,2*E(3),2*E(3)^2,0,E(3),0,0,0,0,0,0,1,0,0,0,0,
ER(-3),E(3)^2,0,5-3*ER(-3),(3-ER(-3))/2,0,0,-1,1,0,0,0,-840*E(3),-ER(-3),
8*E(3),0,4*E(3),0,0,2*E(3)^2,2,-E(3),-E(3)^2,42*E(3)^2,42,2*E(3)^2,-7+ER(-3),
2+4*ER(-3),0,2,(-3+ER(-3))/2,-E(3)^2,-40*E(3),0,2-4*ER(-3),3*E(3),-1,-E(3),
-2-4*ER(-3),0,-E(3),0,0,0,0,0,840*E(3)^2,0,-8*E(3)^2,-4*E(3)^2,0,-2,1,0,-42,
-2+4*ER(-3),-2,ER(-3),40*E(3)^2,-3*E(3)^2,E(3)^2,-7-ER(-3),-ER(-3),0,0,-840,8,
0,4,2*E(3),0,42*E(3),5+3*ER(-3),2*E(3),(3+ER(-3))/2,-40,3,-1,(-3-ER(-3))/2,
840*E(3),0,-8*E(3),E(3),40*E(3),-3*E(3),E(3),-4*E(3),-840*E(3)^2,0,8*E(3)^2,
-40*E(3)^2,3*E(3)^2,-E(3)^2,4*E(3)^2],[840,-40,-3,-8,-1,4,-7-ER(-3),0,
-7+ER(-3),-2*E(3)^2,0,0,(3+ER(-3))/2,(3-ER(-3))/2,0,-2*E(3),1,0,-E(3)^2,E(3),
E(3),E(3)^2,E(3)^2,1,0,-E(3),-42*E(3)^2,0,-1,-2,0,-42*E(3),0,0,5-3*ER(-3),
-E(3)^2,5+3*ER(-3),-E(3),0,2*E(3)^2,0,2*E(3),0,0,(-3-ER(-3))/2,(-3+ER(-3))/2,
0,0,-2*E(3),0,0,-2*E(3)^2,0,0,0,0,0,-2,E(3),0,2*E(3)^2,2*E(3),0,E(3)^2,0,0,0,
0,0,0,-1,0,0,0,0,-ER(-3),-E(3),0,-5-3*ER(-3),(3+ER(-3))/2,0,0,1,-1,0,0,0,
-840*E(3)^2,ER(-3),8*E(3)^2,0,-4*E(3)^2,0,0,2*E(3),2,-E(3)^2,E(3),42*E(3),42,
-2*E(3),7+ER(-3),-2+4*ER(-3),0,2,(-3-ER(-3))/2,-E(3),40*E(3)^2,0,-2-4*ER(-3),
3*E(3)^2,1,E(3)^2,2-4*ER(-3),0,E(3)^2,0,0,0,0,0,840*E(3),0,-8*E(3),4*E(3),0,
-2,-1,0,-42,2+4*ER(-3),2,-ER(-3),-40*E(3),-3*E(3),-E(3),7-ER(-3),ER(-3),0,0,
-840,8,0,-4,2*E(3)^2,0,42*E(3)^2,-5+3*ER(-3),-2*E(3)^2,(3-ER(-3))/2,40,3,1,
(-3+ER(-3))/2,840*E(3)^2,0,-8*E(3)^2,-E(3)^2,-40*E(3)^2,-3*E(3)^2,-E(3)^2,
4*E(3)^2,-840*E(3),0,8*E(3),40*E(3),3*E(3),E(3),-4*E(3)],[840,40,-3,-8,1,-4,
7+ER(-3),0,7-ER(-3),-2*E(3)^2,0,0,(3+ER(-3))/2,(3-ER(-3))/2,0,-2*E(3),1,0,
E(3)^2,-E(3),-E(3),-E(3)^2,-E(3)^2,-1,0,E(3),-42*E(3)^2,0,-1,-2,0,-42*E(3),0,
0,-5+3*ER(-3),E(3)^2,-5-3*ER(-3),E(3),0,-2*E(3)^2,0,-2*E(3),0,0,(-3-ER(-3))/2,
(-3+ER(-3))/2,0,0,-2*E(3),0,0,-2*E(3)^2,0,0,0,0,0,2,E(3),0,2*E(3)^2,2*E(3),0,
E(3)^2,0,0,0,0,0,0,1,0,0,0,0,-ER(-3),E(3),0,5+3*ER(-3),(3+ER(-3))/2,0,0,-1,1,
0,0,0,-840*E(3)^2,ER(-3),8*E(3)^2,0,4*E(3)^2,0,0,2*E(3),2,-E(3)^2,-E(3),
42*E(3),42,2*E(3),-7-ER(-3),2-4*ER(-3),0,2,(-3-ER(-3))/2,-E(3),-40*E(3)^2,0,
2+4*ER(-3),3*E(3)^2,-1,-E(3)^2,-2+4*ER(-3),0,-E(3)^2,0,0,0,0,0,840*E(3),0,
-8*E(3),-4*E(3),0,-2,1,0,-42,-2-4*ER(-3),-2,-ER(-3),40*E(3),-3*E(3),E(3),
-7+ER(-3),ER(-3),0,0,-840,8,0,4,2*E(3)^2,0,42*E(3)^2,5-3*ER(-3),2*E(3)^2,
(3-ER(-3))/2,-40,3,-1,(-3+ER(-3))/2,840*E(3)^2,0,-8*E(3)^2,E(3)^2,40*E(3)^2,
-3*E(3)^2,E(3)^2,-4*E(3)^2,-840*E(3),0,8*E(3),-40*E(3),3*E(3),-E(3),4*E(3)],
[840,-40,-3,-8,-1,4,-7+ER(-3),0,-7-ER(-3),-2*E(3),0,0,(3-ER(-3))/2,
(3+ER(-3))/2,0,-2*E(3)^2,1,0,-E(3),E(3)^2,E(3)^2,E(3),E(3),1,0,-E(3)^2,
-42*E(3),0,-1,-2,0,-42*E(3)^2,0,0,5+3*ER(-3),-E(3),5-3*ER(-3),-E(3)^2,0,
2*E(3),0,2*E(3)^2,0,0,(-3+ER(-3))/2,(-3-ER(-3))/2,0,0,-2*E(3)^2,0,0,-2*E(3),0,
0,0,0,0,-2,E(3)^2,0,2*E(3),2*E(3)^2,0,E(3),0,0,0,0,0,0,-1,0,0,0,0,ER(-3),
-E(3)^2,0,-5+3*ER(-3),(3-ER(-3))/2,0,0,1,-1,0,0,0,-840*E(3),-ER(-3),8*E(3),0,
-4*E(3),0,0,2*E(3)^2,2,-E(3),E(3)^2,42*E(3)^2,42,-2*E(3)^2,7-ER(-3),
-2-4*ER(-3),0,2,(-3+ER(-3))/2,-E(3)^2,40*E(3),0,-2+4*ER(-3),3*E(3),1,E(3),
2+4*ER(-3),0,E(3),0,0,0,0,0,840*E(3)^2,0,-8*E(3)^2,4*E(3)^2,0,-2,-1,0,-42,
2-4*ER(-3),2,ER(-3),-40*E(3)^2,-3*E(3)^2,-E(3)^2,7+ER(-3),-ER(-3),0,0,-840,8,
0,-4,2*E(3),0,42*E(3),-5-3*ER(-3),-2*E(3),(3+ER(-3))/2,40,3,1,(-3-ER(-3))/2,
840*E(3),0,-8*E(3),-E(3),-40*E(3),-3*E(3),-E(3),4*E(3),-840*E(3)^2,0,8*E(3)^2,
40*E(3)^2,3*E(3)^2,E(3)^2,-4*E(3)^2],[840,80,6,-8,-4,0,8*E(3),0,8*E(3)^2,
4*E(3),0,0,ER(-3),-ER(-3),0,4*E(3)^2,-2,0,-1,0,1,0,1,0,0,-1,12*E(3),0,2,-2,0,
12*E(3)^2,0,0,8,-E(3)^2,8,-E(3),0,2*E(3),0,2*E(3)^2,0,0,(3+ER(-3))/2,
(3-ER(-3))/2,0,0,-2*E(3)^2,0,0,-2*E(3),0,0,0,0,0,-2,-2*E(3)^2,0,2*E(3),
2*E(3)^2,0,-2*E(3),0,0,0,0,0,0,0,0,0,0,0,(3-ER(-3))/2,0,0,-8,(-3-ER(-3))/2,0,
0,E(3)^2,-E(3),0,0,0,-840*E(3),(3+ER(-3))/2,8*E(3),0,0,0,0,-4*E(3)^2,-4,
2*E(3),E(3),-12*E(3)^2,-12,-2*E(3)^2,-8*E(3),-8*E(3),0,2,-ER(-3),2*E(3)^2,
-80*E(3),0,-8*E(3)^2,-6*E(3),E(3),4*E(3),8*E(3),0,E(3)^2,0,0,0,0,0,840*E(3)^2,
0,-8*E(3)^2,0,0,4,-E(3)^2,0,12,8*E(3)^2,2,(-3-ER(-3))/2,80*E(3)^2,6*E(3)^2,
-4*E(3)^2,-8*E(3)^2,(-3+ER(-3))/2,0,0,-840,8,0,0,-4*E(3),0,-12*E(3),-8,
-2*E(3),(-3+ER(-3))/2,-80,-6,4,ER(-3),840*E(3),0,-8*E(3),0,80*E(3),6*E(3),
-4*E(3),0,-840*E(3)^2,0,8*E(3)^2,-80*E(3)^2,-6*E(3)^2,4*E(3)^2,0],[840,-80,6,
-8,4,0,-8*E(3)^2,0,-8*E(3),4*E(3)^2,0,0,-ER(-3),ER(-3),0,4*E(3),-2,0,1,0,-1,0,
-1,0,0,1,12*E(3)^2,0,2,-2,0,12*E(3),0,0,-8,E(3),-8,E(3)^2,0,-2*E(3)^2,0,
-2*E(3),0,0,(3-ER(-3))/2,(3+ER(-3))/2,0,0,-2*E(3),0,0,-2*E(3)^2,0,0,0,0,0,2,
-2*E(3),0,2*E(3)^2,2*E(3),0,-2*E(3)^2,0,0,0,0,0,0,0,0,0,0,0,(3+ER(-3))/2,0,0,
8,(-3+ER(-3))/2,0,0,-E(3),E(3)^2,0,0,0,-840*E(3)^2,(3-ER(-3))/2,8*E(3)^2,0,0,
0,0,-4*E(3),-4,2*E(3)^2,-E(3)^2,-12*E(3),-12,2*E(3),8*E(3)^2,8*E(3)^2,0,2,
ER(-3),2*E(3),80*E(3)^2,0,8*E(3),-6*E(3)^2,-E(3)^2,-4*E(3)^2,-8*E(3)^2,0,
-E(3),0,0,0,0,0,840*E(3),0,-8*E(3),0,0,4,E(3),0,12,-8*E(3),-2,(-3+ER(-3))/2,
-80*E(3),6*E(3),4*E(3),8*E(3),(-3-ER(-3))/2,0,0,-840,8,0,0,-4*E(3)^2,0,
-12*E(3)^2,8,2*E(3)^2,(-3-ER(-3))/2,80,-6,-4,-ER(-3),840*E(3)^2,0,-8*E(3)^2,0,
-80*E(3)^2,6*E(3)^2,4*E(3)^2,0,-840*E(3),0,8*E(3),80*E(3),-6*E(3),-4*E(3),0],
[840,80,6,-8,-4,0,8*E(3)^2,0,8*E(3),4*E(3)^2,0,0,-ER(-3),ER(-3),0,4*E(3),-2,0,
-1,0,1,0,1,0,0,-1,12*E(3)^2,0,2,-2,0,12*E(3),0,0,8,-E(3),8,-E(3)^2,0,2*E(3)^2,
0,2*E(3),0,0,(3-ER(-3))/2,(3+ER(-3))/2,0,0,-2*E(3),0,0,-2*E(3)^2,0,0,0,0,0,-2,
-2*E(3),0,2*E(3)^2,2*E(3),0,-2*E(3)^2,0,0,0,0,0,0,0,0,0,0,0,(3+ER(-3))/2,0,0,
-8,(-3+ER(-3))/2,0,0,E(3),-E(3)^2,0,0,0,-840*E(3)^2,(3-ER(-3))/2,8*E(3)^2,0,0,
0,0,-4*E(3),-4,2*E(3)^2,E(3)^2,-12*E(3),-12,-2*E(3),-8*E(3)^2,-8*E(3)^2,0,2,
ER(-3),2*E(3),-80*E(3)^2,0,-8*E(3),-6*E(3)^2,E(3)^2,4*E(3)^2,8*E(3)^2,0,E(3),
0,0,0,0,0,840*E(3),0,-8*E(3),0,0,4,-E(3),0,12,8*E(3),2,(-3+ER(-3))/2,80*E(3),
6*E(3),-4*E(3),-8*E(3),(-3-ER(-3))/2,0,0,-840,8,0,0,-4*E(3)^2,0,-12*E(3)^2,-8,
-2*E(3)^2,(-3-ER(-3))/2,-80,-6,4,-ER(-3),840*E(3)^2,0,-8*E(3)^2,0,80*E(3)^2,
6*E(3)^2,-4*E(3)^2,0,-840*E(3),0,8*E(3),-80*E(3),-6*E(3),4*E(3),0],[840,-80,6,
-8,4,0,-8*E(3),0,-8*E(3)^2,4*E(3),0,0,ER(-3),-ER(-3),0,4*E(3)^2,-2,0,1,0,-1,0,
-1,0,0,1,12*E(3),0,2,-2,0,12*E(3)^2,0,0,-8,E(3)^2,-8,E(3),0,-2*E(3),0,
-2*E(3)^2,0,0,(3+ER(-3))/2,(3-ER(-3))/2,0,0,-2*E(3)^2,0,0,-2*E(3),0,0,0,0,0,2,
-2*E(3)^2,0,2*E(3),2*E(3)^2,0,-2*E(3),0,0,0,0,0,0,0,0,0,0,0,(3-ER(-3))/2,0,0,
8,(-3-ER(-3))/2,0,0,-E(3)^2,E(3),0,0,0,-840*E(3),(3+ER(-3))/2,8*E(3),0,0,0,0,
-4*E(3)^2,-4,2*E(3),-E(3),-12*E(3)^2,-12,2*E(3)^2,8*E(3),8*E(3),0,2,-ER(-3),
2*E(3)^2,80*E(3),0,8*E(3)^2,-6*E(3),-E(3),-4*E(3),-8*E(3),0,-E(3)^2,0,0,0,0,0,
840*E(3)^2,0,-8*E(3)^2,0,0,4,E(3)^2,0,12,-8*E(3)^2,-2,(-3-ER(-3))/2,
-80*E(3)^2,6*E(3)^2,4*E(3)^2,8*E(3)^2,(-3+ER(-3))/2,0,0,-840,8,0,0,-4*E(3),0,
-12*E(3),8,2*E(3),(-3+ER(-3))/2,80,-6,-4,ER(-3),840*E(3),0,-8*E(3),0,-80*E(3),
6*E(3),4*E(3),0,-840*E(3)^2,0,8*E(3)^2,80*E(3)^2,-6*E(3)^2,-4*E(3)^2,0],[896,
-64,-4,0,2,0,8,0,8,0,-4,1,-1,-1,0,0,0,1,-1,0,-1,0,-1,0,0,-1,32,0,0,0,0,32,0,1,
8,-1,8,-1,0,-4,0,-4,0,0,-1,-1,1,1,0,0,0,0,0,-1,0,1,1,-4,0,0,0,0,0,0,0,0,0,1,0,
1,0,0,0,-4,0,-1,0,-1,8,-1,0,0,-1,-1,0,1,0,896,-1,0,0,0,0,-4,0,0,0,-1,32,32,-4,
8,8,0,0,-1,0,-64,-4,8,-4,-1,2,8,0,-1,1,0,0,0,0,896,0,0,0,0,0,-1,0,32,8,-4,-1,
-64,-4,2,8,-1,1,0,896,0,0,0,0,0,32,8,-4,-1,-64,-4,2,-1,896,0,0,0,-64,-4,2,0,
896,0,0,-64,-4,2,0],[896,64,-4,0,-2,0,-8,0,-8,0,-4,1,-1,-1,0,0,0,-1,1,0,1,0,1,
0,0,1,32,0,0,0,0,32,0,-1,-8,1,-8,1,0,4,0,4,0,0,-1,-1,1,1,0,0,0,0,0,-1,0,-1,-1,
4,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,-4,0,-1,0,-1,-8,-1,0,0,1,1,0,1,0,896,-1,0,0,
0,0,-4,0,0,0,1,32,32,4,-8,-8,0,0,-1,0,64,-4,-8,-4,1,-2,-8,0,1,1,0,0,0,0,896,0,
0,0,0,0,1,0,32,-8,4,-1,64,-4,-2,-8,-1,1,0,896,0,0,0,0,0,32,-8,4,-1,64,-4,-2,
-1,896,0,0,0,64,-4,-2,0,896,0,0,64,-4,-2,0],[896,-64,-4,0,2,0,8,0,8,0,-4,1,-1,
-1,0,0,0,1,-1,0,1,0,1,0,0,-1,32,0,0,0,0,32,0,-1,8,-1,8,-1,0,-4,0,-4,0,0,-1,-1,
-1,-1,0,0,0,0,0,1,0,-1,-1,4,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,-4,0,1,0,-1,-8,1,0,
0,1,-1,0,1,0,-896,1,0,0,0,0,4,0,0,0,1,-32,-32,4,-8,-8,0,0,1,0,64,4,-8,4,1,-2,
8,0,1,-1,0,0,0,0,896,0,0,0,0,0,-1,0,32,8,-4,-1,-64,-4,2,-8,-1,1,0,-896,0,0,0,
0,0,-32,-8,4,1,64,4,-2,1,896,0,0,0,-64,-4,2,0,-896,0,0,64,4,-2,0],[896,64,-4,
0,-2,0,-8,0,-8,0,-4,1,-1,-1,0,0,0,-1,1,0,-1,0,-1,0,0,1,32,0,0,0,0,32,0,1,-8,1,
-8,1,0,4,0,4,0,0,-1,-1,-1,-1,0,0,0,0,0,1,0,1,1,-4,0,0,0,0,0,0,0,0,0,-1,0,-1,0,
0,0,-4,0,1,0,-1,8,1,0,0,-1,1,0,1,0,-896,1,0,0,0,0,4,0,0,0,-1,-32,-32,-4,8,8,0,
0,1,0,-64,4,8,4,-1,2,-8,0,-1,-1,0,0,0,0,896,0,0,0,0,0,1,0,32,-8,4,-1,64,-4,-2,
8,-1,1,0,-896,0,0,0,0,0,-32,8,-4,1,-64,4,2,1,896,0,0,0,64,-4,-2,0,-896,0,0,
-64,4,2,0],[945,45,0,-15,0,-3,-9*E(3),-3,-9*E(3)^2,-3*E(3)^2,0,0,0,0,1,
-3*E(3),0,0,0,0,0,0,0,0,0,0,-27*E(3)^2,0,0,0,0,-27*E(3),1,0,-9*E(3)^2,0,
-9*E(3),0,0,0,0,0,-E(3)^2,-E(3),0,0,0,0,0,E(3)^2,E(3)^2,0,E(3),0,E(3),0,0,0,0,
0,0,0,0,0,1,1,-1,0,E(3),0,0,E(3)^2,-1,0,0,0,0,0,-9*E(3),0,1,E(3),0,0,1,0,
5*E(3),945*E(3)^2,0,-15*E(3)^2,E(3)^2,-3*E(3)^2,-3*E(3)^2,0,-3*E(3),-3,0,0,
-27*E(3),-27,0,-9*E(3),-9,0,0,0,0,45*E(3)^2,0,-9,0,0,0,-9,E(3)^2,0,0,E(3),0,
E(3)^2,5,945*E(3),E(3),-15*E(3),-3*E(3),-3*E(3),-3,0,-E(3)^2,-27,-9,0,0,
45*E(3),0,0,-9*E(3)^2,0,0,5*E(3)^2,945,-15,1,-3,-3*E(3)^2,-E(3),-27*E(3)^2,
-9*E(3)^2,0,0,45,0,0,0,945*E(3)^2,E(3)^2,-15*E(3)^2,0,45*E(3)^2,0,0,-3*E(3)^2,
945*E(3),E(3),-15*E(3),45*E(3),0,0,-3*E(3)],[945,-45,0,-15,0,3,9*E(3),3,
9*E(3)^2,-3*E(3)^2,0,0,0,0,1,-3*E(3),0,0,0,0,0,0,0,0,0,0,-27*E(3)^2,0,0,0,0,
-27*E(3),-1,0,9*E(3)^2,0,9*E(3),0,0,0,0,0,E(3)^2,E(3),0,0,0,0,0,E(3)^2,E(3)^2,
0,E(3),0,E(3),0,0,0,0,0,0,0,0,0,1,1,1,0,-E(3),0,0,-E(3)^2,1,0,0,0,0,0,9*E(3),
0,1,E(3),0,0,1,0,-5*E(3),945*E(3)^2,0,-15*E(3)^2,E(3)^2,3*E(3)^2,3*E(3)^2,0,
-3*E(3),-3,0,0,-27*E(3),-27,0,9*E(3),9,0,0,0,0,-45*E(3)^2,0,9,0,0,0,9,E(3)^2,
0,0,E(3),0,E(3)^2,-5,945*E(3),E(3),-15*E(3),3*E(3),3*E(3),-3,0,E(3)^2,-27,9,0,
0,-45*E(3),0,0,9*E(3)^2,0,0,-5*E(3)^2,945,-15,1,3,-3*E(3)^2,E(3),-27*E(3)^2,
9*E(3)^2,0,0,-45,0,0,0,945*E(3)^2,E(3)^2,-15*E(3)^2,0,-45*E(3)^2,0,0,3*E(3)^2,
945*E(3),E(3),-15*E(3),-45*E(3),0,0,3*E(3)],[945,45,0,-15,0,-3,-9*E(3)^2,-3,
-9*E(3),-3*E(3),0,0,0,0,1,-3*E(3)^2,0,0,0,0,0,0,0,0,0,0,-27*E(3),0,0,0,0,
-27*E(3)^2,1,0,-9*E(3),0,-9*E(3)^2,0,0,0,0,0,-E(3),-E(3)^2,0,0,0,0,0,E(3),
E(3),0,E(3)^2,0,E(3)^2,0,0,0,0,0,0,0,0,0,1,1,-1,0,E(3)^2,0,0,E(3),-1,0,0,0,0,
0,-9*E(3)^2,0,1,E(3)^2,0,0,1,0,5*E(3)^2,945*E(3),0,-15*E(3),E(3),-3*E(3),
-3*E(3),0,-3*E(3)^2,-3,0,0,-27*E(3)^2,-27,0,-9*E(3)^2,-9,0,0,0,0,45*E(3),0,-9,
0,0,0,-9,E(3),0,0,E(3)^2,0,E(3),5,945*E(3)^2,E(3)^2,-15*E(3)^2,-3*E(3)^2,
-3*E(3)^2,-3,0,-E(3),-27,-9,0,0,45*E(3)^2,0,0,-9*E(3),0,0,5*E(3),945,-15,1,-3,
-3*E(3),-E(3)^2,-27*E(3),-9*E(3),0,0,45,0,0,0,945*E(3),E(3),-15*E(3),0,
45*E(3),0,0,-3*E(3),945*E(3)^2,E(3)^2,-15*E(3)^2,45*E(3)^2,0,0,-3*E(3)^2],
[945,-45,0,-15,0,3,9*E(3)^2,3,9*E(3),-3*E(3),0,0,0,0,1,-3*E(3)^2,0,0,0,0,0,0,
0,0,0,0,-27*E(3),0,0,0,0,-27*E(3)^2,-1,0,9*E(3),0,9*E(3)^2,0,0,0,0,0,E(3),
E(3)^2,0,0,0,0,0,E(3),E(3),0,E(3)^2,0,E(3)^2,0,0,0,0,0,0,0,0,0,1,1,1,0,
-E(3)^2,0,0,-E(3),1,0,0,0,0,0,9*E(3)^2,0,1,E(3)^2,0,0,1,0,-5*E(3)^2,945*E(3),
0,-15*E(3),E(3),3*E(3),3*E(3),0,-3*E(3)^2,-3,0,0,-27*E(3)^2,-27,0,9*E(3)^2,9,
0,0,0,0,-45*E(3),0,9,0,0,0,9,E(3),0,0,E(3)^2,0,E(3),-5,945*E(3)^2,E(3)^2,
-15*E(3)^2,3*E(3)^2,3*E(3)^2,-3,0,E(3),-27,9,0,0,-45*E(3)^2,0,0,9*E(3),0,0,
-5*E(3),945,-15,1,3,-3*E(3),E(3)^2,-27*E(3),9*E(3),0,0,-45,0,0,0,945*E(3),
E(3),-15*E(3),0,-45*E(3),0,0,3*E(3),945*E(3)^2,E(3)^2,-15*E(3)^2,-45*E(3)^2,0,
0,3*E(3)^2],[1260,0,-18,4,0,0,0,0,0,-2*E(3),0,0,0,0,0,-2*E(3)^2,-2,0,0,0,0,0,
0,0,0,0,18*E(3),0,2,4,0,18*E(3)^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4*E(3)^2,0,
2*E(3),4*E(3),2*E(3)^2,0,0,0,0,0,-2*E(3)^2,0,-4*E(3),-4*E(3)^2,0,-2*E(3),-4,
-2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,-1260*E(3),0,-4*E(3),4*E(3),0,0,
0,2*E(3)^2,2,2*E(3),0,-18*E(3)^2,-18,0,0,0,0,-4,0,2*E(3)^2,0,0,0,18*E(3),0,0,
0,-2*E(3),0,0,-2*E(3)^2,0,0,0,1260*E(3)^2,-4*E(3)^2,4*E(3)^2,0,0,-2,0,0,18,0,
0,0,0,-18*E(3)^2,0,0,0,0,0,-1260,-4,4,0,2*E(3),0,-18*E(3),0,0,0,0,18,0,0,
1260*E(3),-4*E(3),4*E(3),0,0,-18*E(3),0,0,-1260*E(3)^2,4*E(3)^2,-4*E(3)^2,0,
18*E(3)^2,0,0],[1260,0,-18,4,0,0,0,0,0,-2*E(3)^2,0,0,0,0,0,-2*E(3),-2,0,0,0,0,
0,0,0,0,0,18*E(3)^2,0,2,4,0,18*E(3),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4*E(3),0,
2*E(3)^2,4*E(3)^2,2*E(3),0,0,0,0,0,-2*E(3),0,-4*E(3)^2,-4*E(3),0,-2*E(3)^2,-4,
-2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,-1260*E(3)^2,0,-4*E(3)^2,
4*E(3)^2,0,0,0,2*E(3),2,2*E(3)^2,0,-18*E(3),-18,0,0,0,0,-4,0,2*E(3),0,0,0,
18*E(3)^2,0,0,0,-2*E(3)^2,0,0,-2*E(3),0,0,0,1260*E(3),-4*E(3),4*E(3),0,0,-2,0,
0,18,0,0,0,0,-18*E(3),0,0,0,0,0,-1260,-4,4,0,2*E(3)^2,0,-18*E(3)^2,0,0,0,0,18,
0,0,1260*E(3)^2,-4*E(3)^2,4*E(3)^2,0,0,-18*E(3)^2,0,0,-1260*E(3),4*E(3),
-4*E(3),0,18*E(3),0,0],[1280,0,-16,0,0,0,0,0,0,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,
0,0,-16,-1,0,0,-1,-16,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,2,0,0,0,0,0,
-1,0,0,-1,0,0,0,0,0,0,0,0,0,0,-16,-1,2,0,2,0,2,0,0,0,0,0,0,0,1280,2,0,0,0,0,2,
0,0,0,0,-16,-16,0,0,0,0,0,2,0,0,-16,0,-16,0,0,0,0,0,0,0,-1,0,0,1280,0,0,0,0,0,
0,0,-16,0,0,2,0,-16,0,0,2,0,0,1280,0,0,0,0,0,-16,0,0,2,0,-16,0,2,1280,0,0,0,0,
-16,0,0,1280,0,0,0,-16,0,0],[1280,0,-16,0,0,0,0,0,0,0,2,0,2,2,0,0,0,0,0,0,0,0,
0,0,0,0,-16,1,0,0,1,-16,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,-2,0,0,0,0,
0,-1,0,0,-1,0,0,0,0,0,0,0,0,0,0,-16,1,-2,0,2,0,-2,0,0,0,0,0,0,0,-1280,-2,0,0,
0,0,-2,0,0,0,0,16,16,0,0,0,0,0,-2,0,0,16,0,16,0,0,0,0,0,0,0,-1,0,0,1280,0,0,0,
0,0,0,0,-16,0,0,2,0,-16,0,0,2,0,0,-1280,0,0,0,0,0,16,0,0,-2,0,16,0,-2,1280,0,
0,0,0,-16,0,0,-1280,0,0,0,16,0,0]]);

CHEVIE.AddData("CharTable","G34",function()local res;
  res:= rec(size:=39191040, order:=39191040,
  identifier:="G34", name:="G34",
  powermap:=CHEVIE.RawData("PowerMaps","G34"),
  irreducibles:=CHEVIE.RawData("Irr","G34"),
  irredinfo:=List(CHEVIE.RawData("CharInfo","G34")().charparams,x->
    rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G34")(x,rec()))),
  galomorphisms:=Group( (  7,  9)( 10, 16)( 13, 14)( 19, 26)( 20, 22)( 21, 23)
  ( 27, 32)( 28, 31)( 35, 37)( 36, 38)( 40, 42)( 43, 44)( 45, 46)( 47, 48)
  ( 49, 52)( 50, 55)( 51, 53)( 56, 57)( 59, 64)( 60, 63)( 61, 62)( 67, 73)
  ( 68, 70)( 69, 72)( 76, 89)( 77,158)( 79,148)( 80,150)( 82,120)( 83,112)
  ( 84,128)( 86,139)( 87,140)( 88,163)( 90,165)( 91,164)( 92,169)( 93,126)
  ( 95,145)( 97,107)( 98,116)( 99,147)(101,149)(102,137)(103,110)(106,154)
  (108,166)(111,167)(113,168)(114,131)(115,118)(122,155)(123,156)(124,157)
  (125,162)(129,146)(133,138)(134,159)(135,160)(136,161) ),
  text:="origin: Dixon's Algorithm");
  Inherit(res,CHEVIE.RawData("ClassInfo","G34"));
  res.centralizers:=List(res.classes,x->res.order/x);
  return CHEVIE.compat.MakeCharacterTable(res);
end);

# Computed JM june 2010
# Some columns contain only unknown entries
CHEVIE.AddData("HeckeCharTable","G34",function(para,root)local x,y,q,adj,l,tbl,
  j,f3,f7,f11,f13,f15,f19,f21,f23,f25,f27,f29,f33,f37,f39,f40,f47,f51,f53,f57,
  f61,f62,f64,f66,f68,f72,f76,f80,f82,f84,f88,f92,f96,f100,f104,f106,f107,f111,
  f115,f117,f119,f121,f123,f125,f126,f128,f130,f134,f138,f140,f146,f150,f154,
  f158,f162,f166,f168,f169;
  x:=para[1][1]; y:=para[1][2];q:=-x/y;j:=E(3);
  tbl:=rec(
  identifier:="H(G34)",
  size:=39191040, order:=39191040,
  powermap:=CHEVIE.RawData("PowerMaps","G34"));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","G34"));
  l:=List(tbl.classtext,Length);
  adj:=function(arg)local
  f,x,y;f:=arg[1];x:=arg[2];y:=arg[3];arg:=arg{[4..Length(arg)]};
    return Zip(ApplyFunc(f,Concatenation([-x/y],arg)),l,
      function(a,b)return a*(-y)^b;end);end;
  f3:=function(q,j)return [6,-1+5*q,-q+4*q^2,-2*q+4*q^2,-2*q^2+3*q^3,
-q^2+3*q^3,j*q^2+3*q^3,-3*q^2+3*q^3,j^2*q+3*q^3,j^2*q^2-q^3+2*q^4,-2*q^3+2*q^4,
-q^3+2*q^4,j*q^3+2*q^4,j^2*q^2+2*q^4,-2*q^3+2*q^4,(j^2+2*j)*q^3+2*q^4,
-3*q^3+2*q^4,-2*q^4+q^5,j^2*q^3-q^4+q^5,j*q^4+q^5,j^2*q^3+q^5,j^2*q^3+q^5,
j*q^4+q^5,-2*q^4+q^5,-q^4+q^5,(j^2+2*j)*q^4+q^5,3*j^2*q^4+3*q^6,j*q^5,
j^2*q^4-j^2*q^5+q^6,j^2*q^4-j^2*q^5+2*q^6,j^2*q^25,j*q^2+2*j*q^5+3*q^6,
j^2*q^5-j^2*q^6,j^2*q^5-j^2*q^6+q^7,3*j^2*q^5-q^6+2*q^7,j^2*q^5-j^2*q^6+q^7,
j*q^3+(j^2+3*j)*q^6+2*q^7,j^2*q^5-j^2*q^6+q^7,j^2*q^5+j*q^6+q^7,
2*j^2*q^5+2*q^7,j^2*q^5-j^2*q^6,j*q^3+j^2*q^4+q^5+2*j*q^6+2*q^7,-j^2*q^6+q^7,
j^2*q^4-j*q^5-j^2*q^6+q^7,j*q^4+j^2*q^5+q^6+2*j*q^7+q^8,2*j^2*q^6+q^8,
j^2*q^178-2*j^2*q^179,j*q^38-2*j*q^39,2*j^2*q^6-q^7+q^8,j^2*q^6-j^2*q^7,
j^2*q^6+q^8,j*q^4+j^2*q^5+q^6+(j^2+3*j)*q^7+q^8,
j*q^4+2*j^2*q^5+2*q^6+2*j*q^7+q^8,j^2*q^6-j^2*q^7,j^2*q^6-j^2*q^7,
2*j*q^39-j*q^40,j*q^75-j*q^76+j^2*q^77,-j*q^6-j^2*q^8+q^9,
j*q^6+2*j^2*q^7+2*q^8+2*j*q^9+q^10,-j^2*q^10,(j^2-j)*q^7+q^10,
j*q^6+(j^2-j)*q^7-2*j^2*q^8+j*q^9+q^10,-j*q^20,j^2*q^8+q^10,
j^2*q^7+q^8-j^2*q^9+q^10,-j^2*q^39-2*q^40-2*j*q^41-2*j^2*q^42-j*q^43,
q^144-j^2*q^145-q^146+j*q^147,-2*j^2*q^74+j^2*q^75,
j*q^7+3*j^2*q^8+3*q^9+2*j*q^10,-q^40+q^41-j*q^42,2*q^109-q^110,0,
-q^39+j^2*q^40+q^41-j*q^42,j*q^8+2*j^2*q^9+j*q^10+2*q^12,q^15,
-j*q^177-2*j^2*q^179,2*j^2*q^179-j^2*q^180,
j*q^12+(2*j^2-2*j)*q^13+(-2*j^2+j)*q^14,(2*j^2-j)*q^12+q^15,-q^37-2*j*q^39,
j*q^76+j^2*q^78,-2*j^2*q^73+2*j^2*q^74,q^74+j^2*q^75,-q^38-j*q^40,
j^2*q^23-j^2*q^24,-j^2*q^73+2*j^2*q^74,
q^80+(j^2+2*j)*q^81+(2*j^2+j)*q^82+(-3*j^2-2*j)*q^83+j^2*q^85,-6*j*q^35,
-j^2*q^38-2*j*q^39,2*j*q^36-4*j*q^37,
-j^2*q^41+(2*j^2+j)*q^42+(-j^2-2*j)*q^43-j*q^45,
j*q^37-3*j*q^38,3*j*q^37-3*j*q^38,2*j*q^38-2*j*q^39,2*j^2*q^11+j*q^12+q^14,
(-j^2+j)*q^38-2*j*q^39,3*j*q^38-2*j*q^39,-q^38+j*q^39-j*q^40,-3*q^39-3*j*q^41,
-j^2*q^37-2*j^2*q^40-3*j*q^41,-2*q^40-2*j*q^42,-3*q^40+j*q^41-2*j*q^42,
-j^2*q^38+(-2*j^2+j)*q^41-2*j*q^42,
j*q^8+j^2*q^9+(j^2-j)*q^10+(-j^2+j)*q^11+q^13,-2*q^41+j*q^42-j*q^43,
-2*q^41-j*q^43,-q^43-j*q^45,j*q^35-5*j*q^36,-j^2*q^43-2*q^44-j^2*q^45-2*j*q^47,
-j^2*q^37-3*j*q^38,j*q^36-4*j*q^37,q^143+j*q^145,2*j*q^37-3*j*q^38,
(3*j^2+2*j)*q^47-j*q^50,-j^2*q^111-q^113,j*q^73+j^2*q^75,q^108-2*q^109,
-q^41-j*q^43,-q^30,2*j*q^38-2*j*q^39,
j*q^10+(j^2-j)*q^11+(-j^2-2*j)*q^12+(j^2+3*j)*q^13+q^15,6*j^2*q^70,
q^76+(j^2+2*j)*q^77+(j^2-j)*q^78+j^2*q^80,-2*j^2*q^71+4*j^2*q^72,
-j^2*q^72+3*j^2*q^73,-3*j^2*q^72+3*j^2*q^73,j*q^72-j^2*q^73+2*j^2*q^74,
j*q^73-j^2*q^74+j^2*q^75,j*q^74-q^75-j*q^76+j^2*q^77,3*j*q^74+3*j^2*q^76,
3*j*q^75-j^2*q^76+2*j^2*q^77,2*j*q^75+2*j^2*q^77,2*j*q^76+j^2*q^78,
-j^2*q^70+5*j^2*q^71,-j^2*q^71+4*j^2*q^72,-2*j^2*q^72+3*j^2*q^73,
(j^2+3*j)*q^82+j^2*q^85,j*q^72+2*j^2*q^74,-j*q^143+2*j*q^144,
-j^2*q^45+(2*j^2+j)*q^46+(j^2-j)*q^47+(-2*j^2+j)*q^48-j*q^50,-6*q^105,
q^36-4*q^37+q^46,-j*q^111+(-j^2+j)*q^112+(2*j^2+j)*q^113-q^115,q^107-3*q^108,
j*q^8-2*q^9+(j^2-2*j)*q^10+2*q^11+3*j*q^12+q^14,
-j^2*q^109+j*q^110+j^2*q^111-q^112,-3*j^2*q^109-3*q^111,
q^9+6*j*q^10+9*j^2*q^11+9*q^12+6*j*q^13+q^15,-2*j^2*q^110-2*q^112,
-2*j^2*q^111-q^113,-5*q^36+q^45,q^106-4*q^107,
q^11+(2*j^2+6*j)*q^12+(6*j^2-2*j)*q^13+(-6*j^2-4*j)*q^14+(j^2+3*j)*q^15+q^17,
-j^2*q^107-2*q^109,6*j*q^140,j^2*q^146+(-2*j^2-j)*q^147+(j^2+2*j)*q^148+j*q^150,
-2*j*q^141+4*j*q^142, 2*j*q^39-j*q^40,-j*q^140+5*j*q^141,-j*q^141+4*j*q^142,
-j*q^46+(-4*j^2+2*j)*q^47+(8*j^2+6*j)*q^48+(-2*j^2-6*j)*q^49+(-2*j^2+j)*q^50
-j*q^52,-j*q^142+3*j*q^143,-6*j^2*q^175,
-q^181+(-j^2-2*j)*q^182+(-j^2+j)*q^183-j^2*q^185,2*j^2*q^176-4*j^2*q^177,
j^2*q^175-5*j^2*q^176,j^2*q^176-4*j^2*q^177, j^2*q^81+(-6*j^2-4*j)*q^82
+(2*j^2+8*j)*q^83+(4*j^2-2*j)*q^84+(-3*j^2-2*j)*q^85+j^2*q^87,
j^2*q^177-3*j^2*q^178];end;
  f7:=function(q,j)return [15,-10+5*q,6-4*q+q^2,6-8*q+q^2,
-3+6*q-2*q^2,-3+3*q-q^2,-3-3*j*q+j^2*q^2,-3+9*q-3*q^2,-3+j*q-
3*j^2*q^2,1+(2*j^2+j)*q+2*j^2*q^2-j^2*q^3,1-4*q+3*q^2,1-2*q+
q^2,1+2*j*q,1-j*q+(3*j^2+j)*q^2-j^2*q^3,1-4*q+2*q^2,1+
(2*j^2+4*j)*q+q^2,1-6*q+4*q^2,2*q-2*q^2,-j^2*q+(-2*j^2-j)*q^2+
2*j^2*q^3,-j*q,j*q+(-3*j^2-2*j)*q^2+2*j^2*q^3,j*q+(-
2*j^2-j)*q^2+j^2*q^3,-j*q-j^2*q^2,2*q-3*q^2,q-q^2,(-j^2-
2*j)*q+j*q^2,3+9*j^2*q^2+3*j*q^4,j^2*q^2,-j^2*q+(3*j^2+
j)*q^2-j^2*q^3,1-2*j^2*q+2*j^2*q^2+q^3,j*q^10,3+6*j*q+
j^2*q^2+3*j*q^4+2*j^2*q^5,(-2*j^2-j)*q^2+j^2*q^3,j^2*q-
2*j^2*q^2+j^2*q^3,-1+2*q-6*j^2*q^2+3*j^2*q^3-3*j*q^4,j^2*q-
j^2*q^2+j*q^3,-1+(-2*j^2-6*j)*q+(-j^2+2*j)*q^2-2*j*q^4+(-
2*j^2+j)*q^5,j^2*q-j^2*q^2+j^2*q^4,-j*q-2*j^2*q^2+
(2*j^2+j)*q^3,-1-4*j^2*q^2+j^2*q^3-j*q^4,(-2*j^2-j)*q^2+
(2*j^2+j)*q^3,-1-4*j*q+(j^2+3*j)*q^2+(-3*j^2-2*j)*q^3+
(2*j^2-j)*q^4+(-j^2+j)*q^5,j^2*q+j^2*q^3,j^2*q+
2*j*q^2-j^2*q^3,2*j*q-2*j*q^2-3*q^3-3*j^2*q^4+(j^2-
j)*q^5,2*j^2*q^2+j*q^4,j*q^70-2*j*q^71+j*q^72,j^2*q^14-
2*j^2*q^15+j^2*q^16,-q+2*j^2*q^2-3*j^2*q^3+j*q^4,j^2*q^2,
j^2*q^2-j^2*q^3,(j^2+3*j)*q-4*j*q^2-3*q^3-3*j^2*q^4+(j^2-
2*j)*q^5,2*j*q+(-j^2-4*j)*q^2-5*q^3+(-5*j^2-j)*q^4+(j^2-
2*j)*q^5,j^2*q^2-j^2*q^3,j^2*q^2+j*q^3-j^2*q^4,
2*j^2*q^15-2*j^2*q^16,q^29-2*q^30+q^31,j^2*q+j*q^3-q^4,2*j*q+(-
j^2-2*j)*q^2+2*j^2*q^3-j^2*q^4-j*q^6,j*q^4,(j^2-
2*j)*q^3+j*q^4-q^6,j*q-2*j^2*q^2+(3*j^2-j)*q^3+3*j*q^4+
q^5,j^2*q^8,j^2*q^2-2*j^2*q^4,-j^2*q+q^2-q^3+2*q^4-j*q^5,
2*q^15+(4*j^2+3*j)*q^16-5*j^2*q^17+(j^2-4*j)*q^18+(2*j^2+
3*j)*q^19,j*q^57+2*q^58-j*q^59,2*j*q^29-2*j*q^30,(-j^2+
j)*q^2+2*q^3+2*j^2*q^4-q^5+j*q^6,j*q^15-2*j*q^16+j*q^17,
2*q^43-3*q^44,j^2*q^4,j*q^15+2*q^16-j*q^17,1+2*j*q^2+4*j^2*q^3+
2*j*q^4+2*q^5-q^6+2*q^7,q^6,j*q^70-j^2*q^71+(-2*j^2-3*j)*q^72-
q^73,2*j*q^71-3*j*q^72,-j*q^4-2*j*q^5+(2*j^2+5*j)*q^6+2*q^7,
(-2*j^2+j)*q^3+(-2*j^2-5*j)*q^6,j^2*q^14-q^15+(-j^2+
2*j)*q^16-j*q^17,q^30-q^31,j*q^28-4*j*q^29+2*j*q^30,-
j^2*q^29-q^30,q^15+(2*j^2-j)*q^16+2*j*q^17,q^8+j^2*q^9-
j^2*q^10,j*q^28-2*j*q^29+j*q^30,(-2*j^2+j)*q^30+(j^2-
j)*q^31+(4*j^2+j)*q^32+(-2*j^2-j)*q^33-2*j^2*q^34-q^35-
2*j*q^36,15*j^2*q^14,j^2*q^14+2*q^15,6*j^2*q^14-8*j^2*q^15+
j^2*q^16,(j^2-j)*q^16+(2*j^2+3*j)*q^17+(-2*j^2-3*j)*q^18+
(2*j^2+j)*q^19,-3*j^2*q^14+3*j^2*q^15-j^2*q^16,-3*j^2*q^14+
9*j^2*q^15-3*j^2*q^16,j^2*q^14-4*j^2*q^15+3*j^2*q^16,j*q^2+
2*j^2*q^3+2*q^5+3*j*q^6,j^2*q^14+(-4*j^2-2*j)*q^15+j^2*q^16,
j^2*q^14-6*j^2*q^15+4*j^2*q^16,-j*q^15+(j^2-j)*q^16+
2*j*q^17,3*j^2*q^14+9*j*q^16+3*q^18,3*j^2*q^14+6*q^15+j*q^16+
3*q^18+2*j*q^19,-j^2*q^14-4*j*q^16+j*q^17-q^18,-j^2*q^14+
2*j^2*q^15-6*j*q^16+3*j*q^17-3*q^18,-j^2*q^14+(6*j^2+
4*j)*q^15+(-2*j^2-3*j)*q^16-2*q^18+(-j^2-3*j)*q^19,(j^2-
j)*q^2+2*j*q^3+(-3*j^2-j)*q^4-q^5-2*j*q^6-q^8,-j^2*q^15+
2*j*q^16-3*j*q^17+q^18,2*j*q^16+q^18,j*q^16-2*j*q^18,-
10*j^2*q^14+5*j^2*q^15,j^2*q^14+2*q^16+4*j*q^17+2*q^18+
2*j^2*q^19-j^2*q^20+2*j^2*q^21,-3*j^2*q^14-3*q^15+j*q^16,
6*j^2*q^14-4*j^2*q^15+j^2*q^16,q^57+(2*j^2-j)*q^58+2*j*q^59,
-3*j^2*q^14+6*j^2*q^15-2*j^2*q^16,(-j^2-3*j)*q^17+(5*j^2+
3*j)*q^20,j^2*q^44-j^2*q^45,j^2*q^29+(j^2+3*j)*q^30+2*q^31,
q^42-2*q^43+q^44,j*q^16-j*q^17,q^12,j^2*q^14-4*j^2*q^15+
2*j^2*q^16,(-j^2-3*j)*q^2+(j^2+2*j)*q^3+(-j^2+3*j)*q^4+
(j^2-j)*q^5-2*j*q^6-j^2*q^7-2*q^8,15*j*q^28,(j^2+
2*j)*q^30+(-3*j^2-j)*q^31+(3*j^2+j)*q^32+(-j^2+j)*q^33,
6*j*q^28-8*j*q^29+j*q^30,-3*j*q^28+3*j*q^29-j*q^30,-
3*j*q^28+9*j*q^29-3*j*q^30,j*q^28+(-j^2-2*j)*q^29+2*q^30-
q^31,-q^29+(j^2+2*j)*q^30+2*q^31,q^29+2*j^2*q^30-q^31,3*j*q^28+
9*q^30+3*j^2*q^32,-j*q^28+2*j*q^29-6*q^30+3*q^31-3*j^2*q^32,-
j*q^28-4*q^30+q^31-j^2*q^32,2*q^30+j^2*q^32,-10*j*q^28+
5*j*q^29,6*j*q^28-4*j*q^29+j*q^30,-3*j*q^28+6*j*q^29-
2*j*q^30,(3*j^2+2*j)*q^31+(-3*j^2+2*j)*q^34,j*q^28-
j^2*q^29+(-2*j^2-3*j)*q^30-q^31,j^2*q^56-2*j^2*q^57+
j^2*q^58,(3*j^2+2*j)*q^16+(-2*j^2-j)*q^17+(-3*j^2-
4*j)*q^18+(j^2+2*j)*q^19-2*q^20-j*q^21-2*j^2*q^22,15*q^42,-
4*q^9+q^10+6*q^18-4*q^19,(-2*j^2-j)*q^44+(j^2-2*j)*q^45+(-j^2+
2*j)*q^46+(-j^2-2*j)*q^47,-3*q^42+3*q^43-q^44,3*j*q^2+2*q^3+
(2*j^2-4*j)*q^4+(4*j^2+2*j)*q^5+5*j*q^6+2*q^7-2*j*q^8,
j^2*q^43+2*j*q^44-j^2*q^45,3*q^42+9*j^2*q^44+3*j*q^46,-
6*j*q^2-8*q^3-12*j^2*q^4-12*j*q^5-5*q^6-3*j^2*q^7+3*j*q^8+
2*q^9,-q^42-4*j^2*q^44+j^2*q^45-j*q^46,2*j^2*q^44+j*q^46,5*q^9-
10*q^18,6*q^42-4*q^43+q^44,(-j^2-3*j)*q^2+(6*j^2+4*j)*q^3+(-
6*j^2+2*j)*q^4+(2*j^2-4*j)*q^5+(-5*j^2+7*j)*q^6+(-8*j^2-
16*j)*q^7+(13*j^2+7*j)*q^8+(-2*j^2+2*j)*q^9,q^42-j*q^43+
(3*j^2+j)*q^44-j^2*q^45,15*j^2*q^56,(j^2-j)*q^58+(2*j^2+
3*j)*q^59+(-2*j^2-3*j)*q^60+(2*j^2+j)*q^61,6*j^2*q^56-
8*j^2*q^57+j^2*q^58,2*j^2*q^15-3*j^2*q^16,-10*j^2*q^56+
5*j^2*q^57,6*j^2*q^56-4*j^2*q^57+j^2*q^58,(3*j^2+2*j)*q^16+
(-4*j^2+2*j)*q^17+(-2*j^2-8*j)*q^18+(4*j^2+6*j)*q^19+(-
7*j^2-12*j)*q^20+(16*j^2+8*j)*q^21+(-7*j^2+6*j)*q^22+(-
2*j^2-4*j)*q^23,-3*j^2*q^56+3*j^2*q^57-j^2*q^58,15*j*q^70,
(j^2+2*j)*q^72+(-3*j^2-j)*q^73+(3*j^2+j)*q^74+(-j^2+
j)*q^75,6*j*q^70-8*j*q^71+j*q^72,-10*j*q^70+5*j*q^71,
6*j*q^70-4*j*q^71+j*q^72,(-2*j^2+j)*q^30+(-2*j^2-
6*j)*q^31+(8*j^2+6*j)*q^32+(-6*j^2-2*j)*q^33+(12*j^2+
5*j)*q^34+(-8*j^2+8*j)*q^35+(-6*j^2-13*j)*q^36+(4*j^2+
2*j)*q^37,-3*j*q^70+3*j*q^71-j*q^72];end;
  f11:=function(q,j)return [20,-10+10*q,4-6*q+4*q^2,4-12*q+
4*q^2,-1+6*q-6*q^2+q^3,-1+3*q-3*q^2+q^3,-1-3*j*q+3*j^2*q^2+q^3,-1+9*q-
9*q^2+q^3,-1+3*j*q-3*j^2*q^2+q^3,(j^2-j)*q-q^2+(-j^2+j)*q^3,
-2*q+6*q^2-2*q^3,-q+2*q^2-q^3,j*q+j^2*q^3,-2*j*q-3*q^2-2*j^2*q^3,-
2*q+4*q^2-2*q^3,(j^2+2*j)*q+2*q^2+(2*j^2+j)*q^3,-3*q+8*q^2-3*q^3,-
2*q^2+2*q^3,j*q+(-j^2-3*j)*q^2+(3*j^2+j)*q^3-j^2*q^4,0,
j*q+(-2*j^2-4*j)*q^2+(4*j^2+2*j)*q^3-j^2*q^4,j*q+(-
j^2-2*j)*q^2+(2*j^2+j)*q^3-j^2*q^4,-j^2*q^2+j*q^3,-3*q^2+
3*q^3,-q^2+q^3,j*q^2-j^2*q^3,1+9*j^2*q^2+9*j*q^4+q^6,q^3,
(2*j^2+j)*q^2+q^3+(j^2+2*j)*q^4,-j^2*q+j^2*q^2+2*q^3+
j*q^4-j*q^5,q^15,1+6*j*q+3*j^2*q^2+3*j*q^4+6*j^2*q^5+q^6,-
q^3+q^4,-j^2*q^2+j^2*q^3-j*q^4+j*q^5,q-3*j^2*q^2+6*j^2*q^3-
6*j*q^4+3*j*q^5-q^6,j*q^3-j^2*q^4,(-j^2-3*j)*q+(-2*j^2+
4*j)*q^2+j^2*q^3-j*q^4+(-4*j^2+2*j)*q^5+(3*j^2+j)*q^6,-
j*q^3+j^2*q^4,-j^2*q^2+(2*j^2+j)*q^3+(-j^2-2*j)*q^4+
j*q^5,-2*j^2*q^2+2*j^2*q^3-2*j*q^4+2*j*q^5,-2*q^3+2*q^4,-
2*j*q+(-j^2+3*j)*q^2+(-2*j^2-4*j)*q^3+(4*j^2+2*j)*q^4+(-
3*j^2+j)*q^5+2*j^2*q^6,j^2*q^3-j*q^4,j*q^2-j^2*q^5,
(j^2-j)*q^2+(j^2+4*j)*q^3+4*q^4+(4*j^2+j)*q^5+(-j^2+
j)*q^6,-q^4,q^106-2*q^107+q^108,q^22-2*q^23+q^24,-3*j^2*q^3-q^4-
3*j*q^5,0,-j^2*q^3-j*q^5,(j^2-3*j)*q^2+4*j*q^3+4*q^4+
4*j^2*q^5+(-3*j^2+j)*q^6,(j^2-2*j)*q^2+(j^2+6*j)*q^3+
7*q^4+(6*j^2+j)*q^5+(-2*j^2+j)*q^6,-j^2*q^3-j*q^5,j*q^3+
q^4+j^2*q^5,2*q^23-2*q^24,-j^2*q^44+j^2*q^45-j*q^46+j*q^47,-
q^4+q^5,j^2*q^2+(-2*j^2-j)*q^4+(-j^2-2*j)*q^6+j*q^8,-q^6,-
j*q^3+(j^2+2*j)*q^4+(2*j^2+j)*q^6-j^2*q^7,2*j^2*q^3+
2*j*q^4+2*q^5+2*j^2*q^6+2*j*q^7,-q^12,-2*j^2*q^4-2*j*q^6,
j*q^3+2*q^4+q^5+2*q^6+j^2*q^7,(-j^2+2*j)*q^23+(-j^2-
6*j)*q^24-7*q^25+(-6*j^2-j)*q^26+(2*j^2-j)*q^27,j*q^86-
j^2*q^89,-2*q^44+2*q^45,j^2*q^3-q^4+j*q^5-j^2*q^6+q^7-j*q^8,
j^2*q^23-j^2*q^24+j*q^25-j*q^26,3*q^65-3*q^66,0,-j*q^23+
j^2*q^26,j*q^2+2*j^2*q^3+j*q^4+4*q^5-2*q^6+4*q^7+j^2*q^8+
2*j*q^9+j^2*q^10,q^9,2*j*q^106+3*q^107+2*j^2*q^108,3*q^107-
3*q^108,j*q^6+j^2*q^10,(-2*j^2-5*j)*q^6+(5*j^2+2*j)*q^9,
2*j*q^22+3*q^23+2*j^2*q^24,-j^2*q^45-j*q^47,-2*q^43+4*q^44-2*q^45,
-j^2*q^44+j*q^45,-j*q^22+(2*j^2+4*j)*q^23+(-4*j^2-
2*j)*q^24+j^2*q^25,-j^2*q^13-q^14-j*q^15,-q^43+2*q^44-q^45,
2*j*q^46+j^2*q^47-2*j*q^48+(-3*j^2-2*j)*q^49+(2*j^2+
3*j)*q^50+2*j^2*q^51-j*q^52-2*j^2*q^53,-20*q^21,-j*q^22-
j^2*q^24,-4*q^21+12*q^22-4*q^23,j*q^24+(j^2-j)*q^25-3*q^26+(-
j^2+j)*q^27+j^2*q^28,q^21-3*q^22+3*q^23-q^24,q^21-9*q^22+9*q^23-q^24,
2*q^22-6*q^23+2*q^24,2*q^5+3*j*q^6+3*j^2*q^8+2*q^9,(-j^2-
2*j)*q^22-2*q^23+(-2*j^2-j)*q^24,3*q^22-8*q^23+3*q^24,-j*q^22+
(j^2+3*j)*q^23+(-3*j^2-j)*q^24+j^2*q^25,-q^21-9*j^2*q^23-
9*j*q^25-q^27,-q^21-6*j*q^22-3*j^2*q^23-3*j*q^25-6*j^2*q^26-
q^27,2*j^2*q^23-2*j^2*q^24+2*j*q^25-2*j*q^26,-q^22+3*j^2*q^23-
6*j^2*q^24+6*j*q^25-3*j*q^26+q^27,(j^2+3*j)*q^22+(2*j^2-
4*j)*q^23-j^2*q^24+j*q^25+(4*j^2-2*j)*q^26+(-3*j^2-
j)*q^27,-q^3+(-2*j^2-j)*q^4+j*q^5-2*j*q^6+2*j^2*q^7-
j^2*q^8+(j^2+2*j)*q^9+q^10,3*j^2*q^24+q^25+3*j*q^26,q^25,
2*j^2*q^25+2*j*q^27,10*q^21-10*q^22,-j*q^23-2*j^2*q^24-j*q^25-
4*q^26+2*q^27-4*q^28-j^2*q^29-2*j*q^30-j^2*q^31,q^21+3*j*q^22-
3*j^2*q^23-q^24,-4*q^21+6*q^22-4*q^23,j*q^85+(-2*j^2-4*j)*q^86+
(4*j^2+2*j)*q^87-j^2*q^88,q^21-6*q^22+6*q^23-q^24,(2*j^2+
5*j)*q^27+(-5*j^2-2*j)*q^30,j^2*q^66+j*q^68,j*q^43+(-
2*j^2-4*j)*q^44+(4*j^2+2*j)*q^45-j^2*q^46,q^64-2*q^65+q^66,
j^2*q^24+j*q^26,-q^18,2*q^22-4*q^23+2*q^24,2*j*q^4+j^2*q^5-
2*j*q^6+(-3*j^2-2*j)*q^7+(2*j^2+3*j)*q^8+2*j^2*q^9-
j*q^10-2*j^2*q^11,20*q^42,-j*q^45+(-j^2+j)*q^46+3*q^47+(j^2-
j)*q^48-j^2*q^49,4*q^42-12*q^43+4*q^44,-q^42+3*q^43-3*q^44+q^45,-q^42+
9*q^43-9*q^44+q^45,(j^2-j)*q^43-q^44+(-j^2+j)*q^45,j*q^43+(-
j^2-3*j)*q^44+(3*j^2+j)*q^45-j^2*q^46,j*q^44-j^2*q^47,
q^42+9*j^2*q^44+9*j*q^46+q^48,q^43-3*j^2*q^44+6*j^2*q^45-
6*j*q^46+3*j*q^47-q^48,-2*j^2*q^44+2*j^2*q^45-2*j*q^46+
2*j*q^47,-q^46,-10*q^42+10*q^43,4*q^42-6*q^43+4*q^44,-q^42+6*q^43-6*q^44+
q^45,(-2*j^2-5*j)*q^48+(5*j^2+2*j)*q^51,-2*j*q^43-3*q^44-
2*j^2*q^45,-q^85+2*q^86-q^87,-2*j*q^25-j^2*q^26+2*j*q^27+
(3*j^2+2*j)*q^28+(-2*j^2-3*j)*q^29-2*j^2*q^30+j*q^31+
2*j^2*q^32,-20*q^63,6*q^18-4*q^19-4*q^27+6*q^28,j*q^66+(j^2-
j)*q^67-3*q^68+(-j^2+j)*q^69+j^2*q^70,q^63-3*q^64+3*q^65-q^66,
(j^2-2*j)*q^4+2*j^2*q^5+(-2*j^2+4*j)*q^6+4*q^7+(4*j^2-
2*j)*q^8+2*j*q^9+(-2*j^2+j)*q^10,-j*q^65+j^2*q^68,-q^63-
9*j^2*q^65-9*j*q^67-q^69,q^3-3*j^2*q^4-6*j*q^5-6*q^6-6*j^2*q^7+
6*j*q^8+6*q^9+6*j^2*q^10+3*j*q^11-q^12,2*j^2*q^65-2*j^2*q^66+
2*j*q^67-2*j*q^68,q^67,-10*q^18+10*q^27,-4*q^63+6*q^64-4*q^65,(4*j^2+
2*j)*q^5+(-6*j^2+6*j)*q^6+(-8*j^2-16*j)*q^7+(11*j^2+
9*j)*q^8+(-9*j^2-11*j)*q^9+(16*j^2+8*j)*q^10+(-6*j^2+
6*j)*q^11+(-2*j^2-4*j)*q^12,2*j*q^64+3*q^65+2*j^2*q^66,20*q^84,
-j*q^87+(-j^2+j)*q^88+3*q^89+(j^2-j)*q^90-j^2*q^91,4*q^84-
12*q^85+4*q^86,3*q^23-3*q^24,-10*q^84+10*q^85,4*q^84-6*q^85+4*q^86,(-4*j^2-
2*j)*q^26+(6*j^2-6*j)*q^27+(8*j^2+16*j)*q^28+(-11*j^2-
9*j)*q^29+(9*j^2+11*j)*q^30+(-16*j^2-8*j)*q^31+(6*j^2-
6*j)*q^32+(2*j^2+4*j)*q^33,-q^84+3*q^85-3*q^86+q^87,-20*q^105,
j*q^108+(j^2-j)*q^109-3*q^110+(-j^2+j)*q^111+j^2*q^112,-
4*q^105+12*q^106-4*q^107,10*q^105-10*q^106,-4*q^105+6*q^106-4*q^107,(4*j^2+
2*j)*q^47+(-6*j^2+6*j)*q^48+(-8*j^2-16*j)*q^49+(11*j^2+
9*j)*q^50+(-9*j^2-11*j)*q^51+(16*j^2+8*j)*q^52+(-6*j^2+
6*j)*q^53+(-2*j^2-4*j)*q^54,q^105-3*q^106+3*q^107-q^108];end;
  f13:=q->[21,-15+6*q,9-6*q,11-8*q+2*q^2,-7+
6*q-2*q^2,-5+4*q,-3+3*q,-8+9*q-3*q^2+q^3,-3+3*q^2,3-2*q^2+q^3,5-4*q+2*q^2,3-
2*q,1-q,1+2*q-3*q^2,4-4*q+q^2,3-2*q+q^2,5-7*q+2*q^2-q^3,-2+3*q,-1-q+3*q^2-q^3,
-1,-3*q+3*q^2,-1-2*q+2*q^2,0,-3+3*q-q^2,-2+q,-1+q,3-9*q^2,0,2*q-2*q^2-q^3,1+q-
3*q^2,0,3-6*q-3*q^4,-q+q^2+q^3,-q+q^2+q^3,-3+6*q^2-3*q^3,-1+q^2,-3+4*q-2*q^2+
2*q^4-q^5,-1+q^3,-1-q+2*q^2-q^3,-1+4*q^2,-2*q+q^2,-1+6*q-6*q^2+3*q^3+3*q^4-
2*q^5,0,-2*q^2+2*q^3+q^4-q^5,1-4*q+6*q^2-3*q^3-2*q^4+2*q^5,1-q^2,3*q^60-
2*q^61,3*q^12-2*q^13,1-3*q^2+q^3,-q^3,-q^2-q^3,1-4*q+6*q^2-4*q^3-q^4+2*q^5-
q^6,-6*q+10*q^2-6*q^3-3*q^4+3*q^5,q-q^3,q^2-2*q^3,-2*q^12+3*q^13,-q^25+q^26+
q^27,q-q^2+2*q^3+q^4,1-4*q+4*q^2-4*q^4+2*q^5,0,-2*q^4+q^5,-3*q+3*q^2-4*q^4+
3*q^5,0,1-2*q^3,3*q^2-3*q^3+q^5,-6*q^13+10*q^14-6*q^15-3*q^16+3*q^17,-2*q^50+
2*q^51+q^52-q^53,-2*q^24+3*q^25,4*q-5*q^2-q^3+6*q^4-2*q^5-q^6,-q^13+q^14+q^15,
-3*q^36+3*q^37-q^38,q^3,-2*q^14+2*q^15+q^16-q^17,1-q^2+2*q^3-3*q^4+4*q^5,0,
q^60+2*q^61-3*q^62,-3*q^60+3*q^61-q^62,-q^2+2*q^3-2*q^5+q^6,3*q^4-3*q^5,q^12+
2*q^13-3*q^14,-q^26-q^27,4*q^24-4*q^25+q^26,0,-3*q^13+3*q^14,-q^8,3*q^24-
2*q^25,2*q^26-3*q^27+q^28+6*q^29-4*q^30+q^31,21*q^12,q^12-q^13,11*q^12-8*q^13+
2*q^14,3*q^14-q^15-4*q^16+3*q^17,-5*q^12+4*q^13,-8*q^12+9*q^13-3*q^14+q^15,
5*q^12-4*q^13+2*q^14,2*q^3-2*q^4+2*q^5,3*q^12-2*q^13+q^14,5*q^12-7*q^13+
2*q^14-q^15,-q^12-q^13+3*q^14-q^15,3*q^12-9*q^14,3*q^12-6*q^13-3*q^16,-q^12+
4*q^14,-3*q^12+6*q^14-3*q^15,-3*q^12+4*q^13-2*q^14+2*q^16-q^17,2*q^2-6*q^3+
4*q^4+q^5-3*q^6+q^7,q^12-3*q^14+q^15,q^12-q^14,q^12-2*q^15,-15*q^12+6*q^13,
q^12-q^14+2*q^15-3*q^16+4*q^17,-3*q^12+3*q^13,9*q^12-6*q^13,-3*q^49+3*q^50,-
7*q^12+6*q^13-2*q^14,3*q^16-3*q^17,-q^38-q^39,-3*q^25+3*q^26,3*q^36-2*q^37,-
q^14-q^15,0,4*q^12-4*q^13+q^14,2*q^2-3*q^3+q^4+6*q^5-4*q^6+q^7,21*q^24,3*q^26-
q^27-4*q^28+3*q^29,11*q^24-8*q^25+2*q^26,-5*q^24+4*q^25,-8*q^24+9*q^25-3*q^26+
q^27,3*q^24-2*q^26+q^27,-q^24-q^25+3*q^26-q^27,-2*q^26+2*q^27+q^28-q^29,
3*q^24-9*q^26,-3*q^24+6*q^26-3*q^27,-q^24+4*q^26,q^24-q^26,-15*q^24+6*q^25,
9*q^24-6*q^25,-7*q^24+6*q^25-2*q^26,3*q^28-3*q^29,q^24+2*q^25-3*q^26,3*q^48-
2*q^49,2*q^14-3*q^15+q^16+6*q^17-4*q^18+q^19,21*q^36,11*q^12-4*q^13-4*q^15+
2*q^16,3*q^38-q^39-4*q^40+3*q^41,-5*q^36+4*q^37,-4*q^2+6*q^3+2*q^4-6*q^5+
2*q^6+2*q^7-q^8+q^10,-2*q^38+2*q^39+q^40-q^41,3*q^36-9*q^38,15*q^2-24*q^3+
27*q^5-24*q^6+9*q^7-3*q^8,-q^36+4*q^38,q^36-q^38,-15*q^12+6*q^15,9*q^36-
6*q^37,4*q^2-7*q^3-9*q^4+25*q^5-17*q^6+2*q^7+q^8-2*q^9,q^36+2*q^37-3*q^38,
21*q^48,3*q^50-q^51-4*q^52+3*q^53,11*q^48-8*q^49+2*q^50,-3*q^12+3*q^13-q^14,-
15*q^48+6*q^49,9*q^48-6*q^49,4*q^14-7*q^15-9*q^16+25*q^17-17*q^18+2*q^19+q^20-
2*q^21,-5*q^48+4*q^49,21*q^60,3*q^62-q^63-4*q^64+3*q^65,11*q^60-8*q^61+2*q^62,
-15*q^60+6*q^61,9*q^60-6*q^61,4*q^26-7*q^27-9*q^28+25*q^29-17*q^30+2*q^31+
q^32-2*q^33,-5*q^60+4*q^61];
  f15:=function(q,j) return [21,-5+16*q,-5*q+
11*q^2,1-8*q+12*q^2,q-7*q^2+8*q^3,-4*q^2+7*q^3,(2*j^2+3*j)*q^2+6*q^3,
3*q-9*q^2+9*q^3,(3*j^2+2*j)*q+6*q^3,-j^2*q-2*q^2-2*q^3+4*q^4,q^2-
6*q^3+5*q^4,-3*q^3+4*q^4,(j^2+2*j)*q^3+3*q^4,(3*j^2+2*j)*q^2+q^3+
3*q^4,q^2-5*q^3+5*q^4,-j*q^2-4*q^3+4*q^4,3*q^2-7*q^3+6*q^4,q^3-3*q^4+3*q^5,
-j^2*q^2-2*q^3+2*q^5,-q^4+q^5,(3*j^2+2*j)*q^3+2*q^4+q^5,-2*q^3+q^4+
q^5,j*q^4+q^5,q^3-4*q^4+3*q^5,-2*q^4+2*q^5,-j*q^3-2*q^4+2*q^5,(9*j^2+
6*j)*q^4+6*q^6,0,(2*j^2+j)*q^4+(-3*j^2-2*j)*q^5+q^6,(3*j^2+
2*j)*q^4+(-2*j^2-j)*q^5+3*q^6,0,(2*j^2+3*j)*q^2+(4*j^2+
6*j)*q^5+6*q^6,-q^5+2*q^6,(2*j^2+j)*q^5+(-2*j^2-j)*q^6+q^7,-
3*j^2*q^4-6*q^5-2*q^6+4*q^7,(j^2+2*j)*q^5+q^6+q^7,-j*q^2-2*q^3-
2*j*q^5-6*q^6+4*q^7,j^2*q^4-q^5+q^6+q^7,-j^2*q^4+(3*j^2+
2*j)*q^5+2*q^7,(5*j^2+3*j)*q^5+3*q^7,-2*q^5+2*q^6,q^2+(2*j^2+
3*j)*q^3+(3*j^2+2*j)*q^4+5*q^5+(4*j^2+6*j)*q^6+3*q^7,-q^5-
j^2*q^6+q^7,-q^3+(2*j^2+j)*q^4+(-j^2-2*j)*q^5-j^2*q^6+q^7,
q^3-2*q^4+(3*j^2+2*j)*q^5+5*q^6-4*q^7+q^8,(2*j^2+3*j)*q^6+q^8,-
3*j*q^163+4*j*q^164,-3*j^2*q^35+4*j^2*q^36,-2*j^2*q^5-3*q^6-
q^7+2*q^8,j*q^6+q^7,(2*j^2+j)*q^6+q^8,(-j^2-2*j)*q^3+(j^2+
2*j)*q^4-3*q^5+(-4*j^2-6*j)*q^6-5*q^7+2*q^8,q^3+(2*j^2+
3*j)*q^4+(5*j^2+3*j)*q^5+9*q^6+(4*j^2+6*j)*q^7+q^8,-q^6+q^7,
j^2*q^5+q^7,j^2*q^35-3*j^2*q^36+3*j^2*q^37,(-j^2-2*j)*q^69+
(j^2+2*j)*q^70+j*q^71,-q^5-j*q^6+q^7-j^2*q^8+q^9,-2*j^2*q^5+
(4*j^2+2*j)*q^6-2*q^7+(-7*j^2-5*j)*q^8-4*q^9+q^10,0,-2*q^6+
(j^2-j)*q^7+q^10,q^5+(3*j^2+4*j)*q^6+(j^2-j)*q^7+(-4*j^2-
2*j)*q^8+(2*j^2+3*j)*q^9+q^10,0,2*j^2*q^7-q^8+q^10,-q^6+(3*j^2+
2*j)*q^7+3*q^8-j^2*q^9+q^10,j^2*q^35+(-3*j^2-j)*q^36+(-
3*j^2+2*j)*q^37+9*j^2*q^38+(-6*j^2-2*j)*q^39+j^2*q^40,-
j^2*q^131+(-j^2+j)*q^132+(2*j^2+j)*q^133-j*q^134+
j^2*q^135,j*q^67-3*j*q^68+3*j*q^69,-2*j^2*q^6+(6*j^2+
3*j)*q^7-q^8+(-9*j^2-7*j)*q^9-4*q^10,(-j^2+j)*q^37+(j^2-
j)*q^38+j^2*q^39,q^99-4*q^100+3*q^101,j^2*q^8,-j^2*q^35+(-j^2+
j)*q^36+(2*j^2+j)*q^37-j*q^38+j^2*q^39,2*q^7+(2*j^2+
3*j)*q^8+2*j^2*q^9+(j^2+2*j)*q^10+3*q^12,0,(-j^2-3*j)*q^162+
j*q^163+3*j*q^164,j*q^163-4*j*q^164+3*j*q^165,(3*j^2+
j)*q^12+(-4*j^2-2*j)*q^13-q^14,-3*q^11+(2*j^2-j)*q^12+q^15,(-
2*j^2+j)*q^34+j^2*q^35+3*j^2*q^36,(-j^2-2*j)*q^70+j*q^72,
j*q^66-5*j*q^67+5*j*q^68,j^2*q^68+j*q^69,(-2*j^2+j)*q^35+
2*j^2*q^36+j^2*q^37,-q^21+q^22-q^23,-3*j*q^67+4*j*q^68,j*q^73+
(j^2-3*j)*q^74+(-2*j^2-j)*q^75+(-j^2+4*j)*q^76+(2*j^2-
3*j)*q^77+j*q^79,21*j^2*q^32,(-2*j^2-j)*q^35+3*j^2*q^36,
j^2*q^32-8*j^2*q^33+12*j^2*q^34,j^2*q^37+(-4*j^2-j)*q^38+
2*j*q^39+(3*j^2-j)*q^40+j^2*q^42,-4*j^2*q^34+7*j^2*q^35,
3*j^2*q^33-9*j^2*q^34+9*j^2*q^35,j^2*q^34-6*j^2*q^35+
5*j^2*q^36,-q^10-2*j*q^11+j*q^12+q^14,-q^34-4*j^2*q^35+
4*j^2*q^36,3*j^2*q^34-7*j^2*q^35+6*j^2*q^36,-j*q^34-
2*j^2*q^35+2*j^2*q^37,(-6*j^2+3*j)*q^36+6*j^2*q^38,(-3*j^2-
j)*q^34+(-6*j^2-2*j)*q^37+6*j^2*q^38,(-3*j^2+2*j)*q^37+
3*j^2*q^39,-3*j*q^36-6*j^2*q^37-2*j^2*q^38+4*j^2*q^39,-q^34-
2*j^2*q^35-2*q^37-6*j^2*q^38+4*j^2*q^39,2*q^7+(2*j^2+3*j)*q^8+
(3*j^2+2*j)*q^9+(-3*j^2-5*j)*q^10+(j^2+3*j)*q^11+q^13,-
2*j*q^37-3*j^2*q^38-j^2*q^39+2*j^2*q^40,(-3*j^2-j)*q^38+
j^2*q^40,2*j*q^39-j^2*q^40+j^2*q^42,-5*j^2*q^32+16*j^2*q^33,
2*j^2*q^39+(-3*j^2-j)*q^40+2*j*q^41+(-2*j^2-j)*q^42+
3*j^2*q^44,(-3*j^2-j)*q^34+6*j^2*q^35,-5*j^2*q^33+
11*j^2*q^34,(-2*j^2+j)*q^131+2*j^2*q^132+j^2*q^133,j^2*q^33-
7*j^2*q^34+8*j^2*q^35,-3*j^2*q^43+(j^2+3*j)*q^44+j^2*q^47,
(2*j^2+j)*q^102+q^104,(-j^2-3*j)*q^67+2*j*q^68+j*q^69,-
3*q^99+4*q^100,(-j^2+j)*q^38+j^2*q^40,0,j^2*q^34-5*j^2*q^35+
5*j^2*q^36,q^9+(3*j^2+4*j)*q^10+(j^2-j)*q^11+(-4*j^2-
5*j)*q^12+(3*j^2+5*j)*q^13+q^15,21*j*q^64,j*q^69+(j^2-
3*j)*q^70+2*q^71+(j^2+4*j)*q^72+j*q^74,j*q^64-8*j*q^65+
12*j*q^66,-4*j*q^66+7*j*q^67,3*j*q^65-9*j*q^66+9*j*q^67,-
q^65-2*j*q^66-2*j*q^67+4*j*q^68,-q^66-2*j*q^67+2*j*q^69,-
j*q^67+(-j^2-2*j)*q^68+(-j^2+j)*q^69-q^70+j*q^71,(-3*j^2-
9*j)*q^68+6*j*q^70,-3*q^68-6*j*q^69-2*j*q^70+4*j*q^71,(-
2*j^2-5*j)*q^69+3*j*q^71,(j^2-2*j)*q^70+j*q^72,-5*j*q^64+
16*j*q^65,-5*j*q^65+11*j*q^66,j*q^65-7*j*q^66+8*j*q^67,-
3*j*q^75+(-3*j^2-2*j)*q^76+j*q^79,(-j^2-3*j)*q^66+j*q^67+
3*j*q^68,-3*j^2*q^131+4*j^2*q^132,j^2*q^41+(-4*j^2-j)*q^42+
(j^2+2*j)*q^43+(5*j^2+j)*q^44+(-5*j^2-2*j)*q^45+j^2*q^47,
21*q^96,-4*q^33+11*q^34+q^36-4*q^37+q^46,q^101+(3*j^2+4*j)*q^102+
2*j^2*q^103+(-4*j^2-3*j)*q^104+q^106,-4*q^98+7*q^99,q^6+2*q^7+
(j^2+2*j)*q^8-6*q^9+(-2*j^2-5*j)*q^10+6*q^11+(4*j^2+
7*j)*q^12+q^14,-q^99+(2*j^2+j)*q^100+(-j^2-2*j)*q^101-
j^2*q^102+q^103,(9*j^2+6*j)*q^100+6*q^102,11*q^9+(18*j^2+
24*j)*q^10+9*j^2*q^11+26*q^12+(12*j^2+18*j)*q^13+q^15,(5*j^2+
3*j)*q^101+3*q^103,(2*j^2+3*j)*q^102+q^104,15*q^33-5*q^36+q^45,-
5*q^97+11*q^98,3*q^10+7*q^11+(17*j^2+21*j)*q^12+(-j^2-9*j)*q^13+(-
12*j^2-10*j)*q^14+(5*j^2+7*j)*q^15+q^17,(3*j^2+2*j)*q^98+
q^99+3*q^100,21*j^2*q^128,j^2*q^133+(-4*j^2-j)*q^134+2*j*q^135+
(3*j^2-j)*q^136+j^2*q^138,j^2*q^128-8*j^2*q^129+
12*j^2*q^130,j^2*q^35-4*j^2*q^36+3*j^2*q^37,-5*j^2*q^128+
16*j^2*q^129,-5*j^2*q^129+11*j^2*q^130,3*j^2*q^42+7*j^2*q^43+(-
21*j^2-4*j)*q^44+(9*j^2+8*j)*q^45+(10*j^2-2*j)*q^46+(-
7*j^2-2*j)*q^47+j^2*q^49,-4*j^2*q^130+7*j^2*q^131,
21*j*q^160,j*q^165+(j^2-3*j)*q^166+2*q^167+(j^2+4*j)*q^168+
j*q^170,j*q^160-8*j*q^161+12*j*q^162,-5*j*q^160+16*j*q^161,-
5*j*q^161+11*j*q^162,3*j*q^74+7*j*q^75+(4*j^2-17*j)*q^76+(-
8*j^2+j)*q^77+(2*j^2+12*j)*q^78+(2*j^2-5*j)*q^79+j*q^81,-
4*j*q^162+7*j*q^163];end;
  f19:=function(x,y) return
  [35,10*x+25*y,9*x*y+x^2+16*y^2,16*x*y+2*x^2+17*y^2,13*x*y^2+3*x^2*y+10*y^3,
7*x*y^2+x^2*y+9*y^3,3*x*y^2+9*y^3,18*x*y^2+6*x^2*y+11*y^3,-3*x^2*y-x^3+8*y^3,
4*x*y^3-2*x^2*y^2-2*x^3*y+4*y^4,10*x*y^3+4*x^2*y^2+5*y^4,5*x*y^3+x^2*y^2+
4*y^4,2*x*y^3+4*y^4,-x*y^3-3*x^2*y^2-x^3*y+3*y^4,9*x*y^3+3*x^2*y^2+5*y^4,
6*x*y^3+x^2*y^2+5*y^4,13*x*y^3+7*x^2*y^2+6*y^4,5*x*y^4+3*x^2*y^3+2*y^5,x*y^4-
2*x^2*y^3-2*x^3*y^2+y^5,x*y^4+y^5,-2*x*y^4-3*x^2*y^3-x^3*y^2,-x*y^4-2*x^2*y^3-
x^3*y^2,x*y^4+y^5,6*x*y^4+4*x^2*y^3+2*y^5,3*x*y^4+x^2*y^3+y^5,3*x*y^4+x^2*y^3+
2*y^5,-9*x^2*y^4-8*x^3*y^3+9*y^6,0,-2*x*y^5-3*x^2*y^4+y^6,-2*x*y^5-4*x^2*y^4-
x^3*y^3+4*y^6,0,6*x*y^5-6*x^3*y^3-3*x^4*y^2+x^6+10*y^6,-x*y^6-2*x^2*y^5,-
x*y^6-2*x^2*y^5+y^7,4*x*y^6-6*x^2*y^5-11*x^3*y^4+5*y^7,-x*y^6-3*x^2*y^5-
x^3*y^4+y^7,8*x*y^6+2*x^2*y^5-6*x^3*y^4-2*x^4*y^3-x^5*y^2+x^6*y+6*y^7,-x*y^6-
2*x^2*y^5+y^7,x*y^6-4*x^2*y^5-2*x^3*y^4+2*y^7,-4*x^2*y^5-3*x^3*y^4+4*y^7,-
x*y^6-3*x^2*y^5-x^3*y^4,6*x*y^6+7*x^2*y^5+x^3*y^4-3*x^4*y^3-x^5*y^2+5*y^7,-
x*y^6+y^7,2*x^2*y^5+2*x^3*y^4-x^5*y^2+y^7,4*x*y^7+6*x^2*y^6+x^3*y^5-2*x^4*y^4-
x^5*y^3+2*y^8,-2*x^2*y^6-3*x^3*y^5+y^8,4*x^60*y^154+5*x^61*y^153+x^62*y^152,
4*x^12*y^34+5*x^13*y^33+x^14*y^32,2*x*y^7-2*x^2*y^6-5*x^3*y^5+2*y^8,-x^2*y^6,-
x^2*y^6+y^8,6*x*y^7+7*x^2*y^6+2*x^3*y^5-x^4*y^4-2*x^5*y^3+3*y^8,6*x*y^7+
11*x^2*y^6+6*x^3*y^5-3*x^4*y^4-2*x^5*y^3+2*y^8,-x^2*y^6,x^3*y^5,2*x^12*y^35+
5*x^13*y^34+3*x^14*y^33,x^24*y^67-x^25*y^66-2*x^26*y^65,-x*y^8-x^5*y^4+y^9,
4*x*y^9+5*x^2*y^8-4*x^4*y^6+x^6*y^4+2*y^10,0,-x^2*y^8-x^3*y^7-2*x^5*y^5+y^10,
x*y^9+3*x^2*y^8-2*x^3*y^7-4*x^4*y^6-3*x^5*y^5-x^6*y^4+y^10,0,-x^2*y^8+y^10,-
x*y^9+4*x^2*y^8+4*x^3*y^7-x^5*y^5+y^10,2*x^12*y^38+6*x^13*y^37+11*x^14*y^36+
6*x^15*y^35-3*x^16*y^34-2*x^17*y^33,x^48*y^127+2*x^50*y^125+2*x^51*y^124-
x^53*y^122,2*x^24*y^65+5*x^25*y^64+3*x^26*y^63,4*x*y^10+5*x^2*y^9-6*x^4*y^7-
2*x^5*y^6+x^6*y^5+y^11,x^12*y^37-x^13*y^36-2*x^14*y^35,2*x^36*y^95+
6*x^37*y^94+4*x^38*y^93,x^3*y^8,x^12*y^37+2*x^14*y^35+2*x^15*y^34-x^17*y^32,-
2*x^2*y^10+4*x^3*y^9-2*x^5*y^7-x^6*y^6+4*y^12,0,3*x^60*y^154-x^61*y^153-
3*x^62*y^152-x^63*y^151,2*x^60*y^155+6*x^61*y^154+4*x^62*y^153,-x^4*y^12,
x^3*y^12-6*x^5*y^10+y^15,3*x^12*y^34-x^13*y^33-3*x^14*y^32-x^15*y^31,
x^24*y^68-x^26*y^66,5*x^24*y^64+9*x^25*y^63+3*x^26*y^62,x^24*y^65+x^25*y^64,-
2*x^13*y^34-3*x^14*y^33-x^15*y^32,-x^8*y^20,4*x^24*y^64+5*x^25*y^63+x^26*y^62,
x^24*y^75-3*x^26*y^73-x^27*y^72+x^28*y^71+2*x^29*y^70+2*x^30*y^69+x^31*y^68,
35*x^12*y^30,4*x^12*y^34+2*x^13*y^33,17*x^12*y^32+16*x^13*y^31+2*x^14*y^30,
x^12*y^40+3*x^14*y^38-x^15*y^37-4*x^16*y^36-3*x^17*y^35-x^18*y^34,9*x^12*y^33+
7*x^13*y^32+x^14*y^31,11*x^12*y^33+18*x^13*y^32+6*x^14*y^31,5*x^12*y^34+
10*x^13*y^33+4*x^14*y^32,-x^2*y^12+2*x^3*y^11-2*x^4*y^10-4*x^5*y^9+y^14,
5*x^12*y^34+6*x^13*y^33+x^14*y^32,6*x^12*y^34+13*x^13*y^33+7*x^14*y^32,
x^12*y^35+x^13*y^34-2*x^14*y^33-2*x^15*y^32,9*x^12*y^36-9*x^14*y^34-
8*x^15*y^33,10*x^12*y^36+6*x^13*y^35-6*x^15*y^33-3*x^16*y^32+x^18*y^30,
4*x^12*y^37-4*x^14*y^35-3*x^15*y^34,5*x^12*y^37+4*x^13*y^36-6*x^14*y^35-
11*x^15*y^34,6*x^12*y^37+8*x^13*y^36+2*x^14*y^35-6*x^15*y^34-2*x^16*y^33-
x^17*y^32+x^18*y^31,-x^2*y^11-3*x^3*y^10-5*x^4*y^9+2*x^6*y^7+x^7*y^6+y^13,
2*x^12*y^38+2*x^13*y^37-2*x^14*y^36-5*x^15*y^35,x^12*y^38-2*x^14*y^36-
3*x^15*y^35,x^12*y^40-x^14*y^38,25*x^12*y^31+10*x^13*y^30,4*x^12*y^42-
2*x^14*y^40+4*x^15*y^39-2*x^17*y^37-x^18*y^36,9*x^12*y^33+3*x^13*y^32,
16*x^12*y^32+9*x^13*y^31+x^14*y^30,-2*x^49*y^124-3*x^50*y^123-x^51*y^122,
10*x^12*y^33+13*x^13*y^32+3*x^14*y^31,x^12*y^45+x^15*y^42-6*x^17*y^40,
x^36*y^98-x^38*y^96,-2*x^25*y^64-3*x^26*y^63-x^27*y^62,4*x^36*y^94+
5*x^37*y^93+x^38*y^92,x^12*y^38-x^14*y^36,0,5*x^12*y^34+9*x^13*y^33+
3*x^14*y^32,-3*x^2*y^13-x^3*y^12+x^4*y^11+2*x^5*y^10+2*x^6*y^9+x^7*y^8+y^15,
35*x^24*y^60,x^24*y^70+3*x^26*y^68-x^27*y^67-4*x^28*y^66-3*x^29*y^65-
x^30*y^64,17*x^24*y^62+16*x^25*y^61+2*x^26*y^60,9*x^24*y^63+7*x^25*y^62+
x^26*y^61,11*x^24*y^63+18*x^25*y^62+6*x^26*y^61,4*x^24*y^64+4*x^25*y^63-
2*x^26*y^62-2*x^27*y^61,x^24*y^65+x^25*y^64-2*x^26*y^63-2*x^27*y^62,x^24*y^67+
2*x^26*y^65+2*x^27*y^64-x^29*y^62,9*x^24*y^66-9*x^26*y^64-8*x^27*y^63,
5*x^24*y^67+4*x^25*y^66-6*x^26*y^65-11*x^27*y^64,4*x^24*y^67-4*x^26*y^65-
3*x^27*y^64,x^24*y^68-2*x^26*y^66-3*x^27*y^65,25*x^24*y^61+10*x^25*y^60,
16*x^24*y^62+9*x^25*y^61+x^26*y^60,10*x^24*y^63+13*x^25*y^62+3*x^26*y^61,
x^24*y^75+x^27*y^72-6*x^29*y^70,3*x^24*y^64-x^25*y^63-3*x^26*y^62-x^27*y^61,
4*x^48*y^124+5*x^49*y^123+x^50*y^122,x^12*y^45-3*x^14*y^43-x^15*y^42+
x^16*y^41+2*x^17*y^40+2*x^18*y^39+x^19*y^38,35*x^36*y^90,8*x^9*y^37+
2*x^10*y^36-16*x^15*y^31-8*x^16*y^30+y^46,x^36*y^100+3*x^38*y^98-x^39*y^97-
4*x^40*y^96-3*x^41*y^95-x^42*y^94,9*x^36*y^93+7*x^37*y^92+x^38*y^91,-
2*x^2*y^12-4*x^3*y^11+2*x^4*y^10+8*x^5*y^9-2*x^7*y^7+x^10*y^4+y^14,x^36*y^97+
2*x^38*y^95+2*x^39*y^94-x^41*y^92,9*x^36*y^96-9*x^38*y^94-8*x^39*y^93,-
6*x*y^14-15*x^2*y^13-29*x^3*y^12-6*x^4*y^11+21*x^5*y^10+15*x^6*y^9+6*x^7*y^8-
4*x^9*y^6,4*x^36*y^97-4*x^38*y^95-3*x^39*y^94,x^36*y^98-2*x^38*y^96-
3*x^39*y^95,10*x^9*y^36-24*x^15*y^30+y^45,16*x^36*y^92+9*x^37*y^91+x^38*y^90,-
5*x^2*y^15-11*x^3*y^14+3*x^4*y^13+24*x^5*y^12+9*x^6*y^11-3*x^7*y^10-x^8*y^9-
3*x^9*y^8+y^17,3*x^36*y^94-x^37*y^93-3*x^38*y^92-x^39*y^91,35*x^48*y^120,
x^48*y^130+3*x^50*y^128-x^51*y^127-4*x^52*y^126-3*x^53*y^125-x^54*y^124,
17*x^48*y^122+16*x^49*y^121+2*x^50*y^120,2*x^12*y^35+6*x^13*y^34+4*x^14*y^33,
25*x^48*y^121+10*x^49*y^120,16*x^48*y^122+9*x^49*y^121+x^50*y^120,x^12*y^47-
5*x^14*y^45-11*x^15*y^44+3*x^16*y^43+24*x^17*y^42+9*x^18*y^41-3*x^19*y^40-
x^20*y^39-3*x^21*y^38,9*x^48*y^123+7*x^49*y^122+x^50*y^121,35*x^60*y^150,
x^60*y^160+3*x^62*y^158-x^63*y^157-4*x^64*y^156-3*x^65*y^155-x^66*y^154,
17*x^60*y^152+16*x^61*y^151+2*x^62*y^150,25*x^60*y^151+10*x^61*y^150,
16*x^60*y^152+9*x^61*y^151+x^62*y^150,x^24*y^77-5*x^26*y^75-11*x^27*y^74+
3*x^28*y^73+24*x^29*y^72+9*x^30*y^71-3*x^31*y^70-x^32*y^69-3*x^33*y^68,
9*x^60*y^153+7*x^61*y^152+x^62*y^151]*x^0*y^0;end;
  f21:=function(x,y) return
[35,15*x+20*y,12*x*y+3*x^2+8*y^2,16*x*y+7*x^2+12*y^2,10*x*y^2+6*x^2*y+2*x^3+
5*y^3,5*x*y^2+3*x^2*y+3*y^3,3*x*y^2+x^3,12*x*y^2+12*x^2*y+3*x^3+8*y^3,-
3*x^2*y-x^3-2*y^3,-x*y^3-2*x^2*y^2-2*x^3*y-y^4,6*x*y^3+4*x^2*y^2+2*x^3*y+x^4+
2*y^4,2*x*y^3+x^2*y^2+y^4,-x^2*y^2,-3*x*y^3-4*x^2*y^2-2*x^3*y-2*y^4,4*x*y^3+
3*x^2*y^2+2*x^3*y+2*y^4,2*x*y^3+x^2*y^2+x^4,6*x*y^3+8*x^2*y^2+4*x^3*y+x^4+
4*y^4,x*y^4+x^2*y^3+x^3*y^2+y^5,-3*x*y^4-4*x^2*y^3-2*x^3*y^2-x^4*y-y^5,-
x^3*y^2,-3*x*y^4-4*x^2*y^3-2*x^3*y^2-2*y^5,-2*x*y^4-2*x^2*y^3-2*x^3*y^2-y^5,-
x^2*y^3,2*x*y^4+2*x^2*y^3+x^3*y^2+x^4*y+y^5,x*y^4,-x^2*y^3,-9*x^2*y^4-
16*x^3*y^3+x^6,0,-2*x*y^5-x^2*y^4-2*x^3*y^3,-3*x^2*y^4-4*x^3*y^3-x^4*y^2,0,
6*x*y^5-12*x^3*y^3-3*x^4*y^2+3*x^6+2*y^6,-x*y^6,0,-6*x^2*y^5-11*x^3*y^4-
8*x^4*y^3+x^7,-x^4*y^3,5*x*y^6+2*x^2*y^5-6*x^3*y^4-8*x^4*y^3-x^5*y^2+x^6*y+
2*x^7+y^7,x*y^6+x^2*y^5+x^3*y^4,-2*x^2*y^5-4*x^3*y^4-x^4*y^3-x^5*y^2,-x^2*y^5-
5*x^3*y^4-2*x^4*y^3,-x^2*y^5,6*x*y^6+8*x^2*y^5-5*x^4*y^3-3*x^5*y^2+2*y^7,0,
2*x*y^6+3*x^2*y^5+2*x^3*y^4+x^4*y^3,4*x*y^7+6*x^2*y^6+3*x^3*y^5-3*x^4*y^4-
3*x^5*y^3-x^6*y^2+y^8,-x^4*y^4,x^90*y^124+2*x^91*y^123+x^92*y^122,x^18*y^28+
2*x^19*y^27+x^20*y^26,-x^2*y^6-3*x^3*y^5-3*x^4*y^4-x^5*y^3,x^3*y^5,0,5*x*y^7+
7*x^2*y^6+3*x^3*y^5-3*x^4*y^4-4*x^5*y^3-x^6*y^2+y^8,6*x*y^7+9*x^2*y^6+
5*x^3*y^5-3*x^4*y^4-5*x^5*y^3-2*x^6*y^2+2*y^8,x^2*y^6+x^4*y^4,x*y^7+x^2*y^6+
2*x^3*y^5+x^4*y^4,x^18*y^29+x^19*y^28+x^20*y^27+x^21*y^26,0,2*x^2*y^7+x^3*y^6+
2*x^4*y^5+x^5*y^4+x^6*y^3+x^7*y^2,2*x*y^9+2*x^2*y^8-2*x^3*y^7-4*x^4*y^6-
4*x^5*y^5+y^10,0,-x^3*y^7-x^4*y^6+x^6*y^4+x^7*y^3,x^2*y^8-x^3*y^7-5*x^4*y^6-
3*x^5*y^5+x^6*y^4+2*x^7*y^3+x^8*y^2,0,2*x^4*y^6+x^6*y^4,2*x^2*y^8+x^3*y^7-
x^4*y^6-3*x^5*y^5,2*x^18*y^32+6*x^19*y^31+9*x^20*y^30+5*x^21*y^29-3*x^22*y^28-
5*x^23*y^27-2*x^24*y^26,2*x^73*y^102+3*x^74*y^101+2*x^75*y^100+x^76*y^99,
x^36*y^53+x^37*y^52+x^38*y^51+x^39*y^50,2*x*y^10+2*x^2*y^9-2*x^3*y^8-
6*x^4*y^7-5*x^5*y^6+2*x^7*y^4+x^8*y^3+y^11,0,x^54*y^77+2*x^55*y^76+
2*x^56*y^75+x^57*y^74+x^58*y^73,-x^5*y^6,2*x^19*y^30+3*x^20*y^29+2*x^21*y^28+
x^22*y^27,-2*x^3*y^9-3*x^4*y^8-6*x^5*y^7+3*x^8*y^4,0,-2*x^90*y^124-
3*x^91*y^123-4*x^92*y^122-2*x^93*y^121,x^90*y^125+2*x^91*y^124+2*x^92*y^123+
x^93*y^122+x^94*y^121,x^4*y^12+2*x^5*y^11+4*x^6*y^10+4*x^7*y^9+3*x^8*y^8,
2*x^6*y^9+6*x^7*y^8,-2*x^18*y^28-3*x^19*y^27-4*x^20*y^26-2*x^21*y^25,0,
2*x^36*y^52+4*x^37*y^51+3*x^38*y^50+2*x^39*y^49,-x^38*y^51,-2*x^18*y^29-
3*x^19*y^28-4*x^20*y^27-2*x^21*y^26,x^11*y^17+x^12*y^16+x^13*y^15,x^36*y^52+
2*x^37*y^51+x^38*y^50,x^40*y^59+6*x^41*y^58+8*x^42*y^57+5*x^43*y^56-
4*x^44*y^55-4*x^45*y^54-x^46*y^53,35*x^18*y^24,-x^20*y^26,12*x^18*y^26+
16*x^19*y^25+7*x^20*y^24,2*x^20*y^32+x^21*y^31-x^22*y^30-3*x^23*y^29+
x^24*y^28+2*x^25*y^27+x^26*y^26,3*x^18*y^27+5*x^19*y^26+3*x^20*y^25,
8*x^18*y^27+12*x^19*y^26+12*x^20*y^25+3*x^21*y^24,2*x^18*y^28+6*x^19*y^27+
4*x^20*y^26+2*x^21*y^25+x^22*y^24,2*x^5*y^9+4*x^6*y^8+2*x^7*y^7,2*x^19*y^27+
x^20*y^26+x^22*y^24,4*x^18*y^28+6*x^19*y^27+8*x^20*y^26+4*x^21*y^25+x^22*y^24,
-x^18*y^29-3*x^19*y^28-4*x^20*y^27-2*x^21*y^26-x^22*y^25,-9*x^20*y^28-
16*x^21*y^27+x^24*y^24,2*x^18*y^30+6*x^19*y^29-12*x^21*y^27-3*x^22*y^26+
3*x^24*y^24,-x^20*y^29-5*x^21*y^28-2*x^22*y^27,-6*x^20*y^29-11*x^21*y^28-
8*x^22*y^27+x^25*y^24,x^18*y^31+5*x^19*y^30+2*x^20*y^29-6*x^21*y^28-
8*x^22*y^27-x^23*y^26+x^24*y^25+2*x^25*y^24,3*x^4*y^9+7*x^5*y^8+10*x^6*y^7+
5*x^7*y^6+x^8*y^5,-x^20*y^30-3*x^21*y^29-3*x^22*y^28-x^23*y^27,-x^22*y^28,
2*x^22*y^30+x^24*y^28,20*x^18*y^25+15*x^19*y^24,-2*x^21*y^33-3*x^22*y^32-
6*x^23*y^31+3*x^26*y^28,3*x^19*y^26+x^21*y^24,8*x^18*y^26+12*x^19*y^25+
3*x^20*y^24,-2*x^72*y^101-3*x^73*y^100-4*x^74*y^99-2*x^75*y^98,5*x^18*y^27+
10*x^19*y^26+6*x^20*y^25+2*x^21*y^24,2*x^24*y^33+6*x^25*y^32,0,-2*x^36*y^53-
3*x^37*y^52-4*x^38*y^51-2*x^39*y^50,x^54*y^76+2*x^55*y^75+x^56*y^74,0,0,
2*x^18*y^28+4*x^19*y^27+3*x^20*y^26+2*x^21*y^25,x^4*y^11+6*x^5*y^10+8*x^6*y^9+
5*x^7*y^8-4*x^8*y^7-4*x^9*y^6-x^10*y^5,35*x^36*y^48,2*x^38*y^56+x^39*y^55-
x^40*y^54-3*x^41*y^53+x^42*y^52+2*x^43*y^51+x^44*y^50,12*x^36*y^50+
16*x^37*y^49+7*x^38*y^48,3*x^36*y^51+5*x^37*y^50+3*x^38*y^49,8*x^36*y^51+
12*x^37*y^50+12*x^38*y^49+3*x^39*y^48,-x^36*y^52-x^37*y^51-2*x^38*y^50-
2*x^39*y^49,-x^36*y^53-3*x^37*y^52-4*x^38*y^51-2*x^39*y^50-x^40*y^49,
2*x^37*y^54+3*x^38*y^53+2*x^39*y^52+x^40*y^51,-9*x^38*y^52-16*x^39*y^51+
x^42*y^48,-6*x^38*y^53-11*x^39*y^52-8*x^40*y^51+x^43*y^48,-x^38*y^53-
5*x^39*y^52-2*x^40*y^51,-x^40*y^52,20*x^36*y^49+15*x^37*y^48,8*x^36*y^50+
12*x^37*y^49+3*x^38*y^48,5*x^36*y^51+10*x^37*y^50+6*x^38*y^49+2*x^39*y^48,
2*x^42*y^57+6*x^43*y^56,-2*x^36*y^52-3*x^37*y^51-4*x^38*y^50-2*x^39*y^49,
x^72*y^100+2*x^73*y^99+x^74*y^98,x^22*y^35+6*x^23*y^34+8*x^24*y^33+
5*x^25*y^32-4*x^26*y^31-4*x^27*y^30-x^28*y^29,35*x^54*y^72,12*x^18*y^28+
8*x^19*y^27+8*x^21*y^25+7*x^22*y^24,2*x^56*y^80+x^57*y^79-x^58*y^78-
3*x^59*y^77+x^60*y^76+2*x^61*y^75+x^62*y^74,3*x^54*y^75+5*x^55*y^74+
3*x^56*y^73,2*x^2*y^12+6*x^3*y^11+9*x^4*y^10+14*x^5*y^9+14*x^6*y^8+4*x^7*y^7-
3*x^8*y^6-2*x^9*y^5,2*x^55*y^78+3*x^56*y^77+2*x^57*y^76+x^58*y^75,-
9*x^56*y^76-16*x^57*y^75+x^60*y^72,-9*x*y^14-15*x^2*y^13-12*x^3*y^12-
3*x^4*y^11+9*x^5*y^10+14*x^6*y^9+3*x^7*y^8-21*x^8*y^7-26*x^9*y^6-15*x^10*y^5-
3*x^11*y^4-2*y^15,-x^56*y^77-5*x^57*y^76-2*x^58*y^75,-x^58*y^76,20*x^18*y^27+
15*x^21*y^24,8*x^54*y^74+12*x^55*y^73+3*x^56*y^72,-2*x^2*y^15-2*x^3*y^14+
2*x^4*y^13+6*x^5*y^12-x^6*y^11-17*x^7*y^10-26*x^8*y^9-23*x^9*y^8-14*x^10*y^7-
4*x^11*y^6,-2*x^54*y^76-3*x^55*y^75-4*x^56*y^74-2*x^57*y^73,35*x^72*y^96,
2*x^74*y^104+x^75*y^103-x^76*y^102-3*x^77*y^101+x^78*y^100+2*x^79*y^99+
x^80*y^98,12*x^72*y^98+16*x^73*y^97+7*x^74*y^96,x^18*y^29+2*x^19*y^28+
2*x^20*y^27+x^21*y^26+x^22*y^25,20*x^72*y^97+15*x^73*y^96,8*x^72*y^98+
12*x^73*y^97+3*x^74*y^96,-2*x^20*y^39-2*x^21*y^38+2*x^22*y^37+6*x^23*y^36-
x^24*y^35-17*x^25*y^34-26*x^26*y^33-23*x^27*y^32-14*x^28*y^31-4*x^29*y^30,
3*x^72*y^99+5*x^73*y^98+3*x^74*y^97,35*x^90*y^120,2*x^92*y^128+x^93*y^127-
x^94*y^126-3*x^95*y^125+x^96*y^124+2*x^97*y^123+x^98*y^122,12*x^90*y^122+
16*x^91*y^121+7*x^92*y^120,20*x^90*y^121+15*x^91*y^120,8*x^90*y^122+
12*x^91*y^121+3*x^92*y^120,-2*x^38*y^63-2*x^39*y^62+2*x^40*y^61+6*x^41*y^60-
x^42*y^59-17*x^43*y^58-26*x^44*y^57-23*x^45*y^56-14*x^46*y^55-4*x^47*y^54,
3*x^90*y^123+5*x^91*y^122+3*x^92*y^121]*x^0*y^0;end;
  f23:=q->[56,-40+16*q,25-15*q+q^2,28-24*q+
4*q^2,-17+19*q-5*q^2,-14+11*q-q^2,-12+6*q,-19+27*q-9*q^2+q^3,-11+6*q^2-q^3,7-
4*q-4*q^2+3*q^3,10-14*q+6*q^2,7-7*q+q^2,5-3*q,4+3*q-6*q^2+q^3,9-13*q+4*q^2,8-
8*q+2*q^2,11-20*q+9*q^2-q^3,-4+8*q-3*q^2,-2+5*q^2-3*q^3,-2+q,Unknown(),-1-3*q+
4*q^2-q^3,Unknown(),-5+9*q-5*q^2,-3+4*q-q^2,-3+4*q-q^2,12-18*q^2+8*q^3,0,
Unknown(),5+3*q-7*q^2+q^3,0,13-12*q+6*q^3-6*q^4+q^6,Unknown(),Unknown(),-8+
4*q+12*q^2-14*q^3,-2-q+4*q^2-q^3,-9+12*q-4*q^2-6*q^3+4*q^4-2*q^5-q^6,-2-q+
2*q^2+q^3,-3+6*q^2-3*q^3,-5+8*q^2-3*q^3,Unknown(),-6+12*q-13*q^2+4*q^3+6*q^4-
3*q^5,Unknown(),Unknown(),3-8*q+12*q^2-4*q^3-4*q^4+3*q^5,2-3*q^2+3*q^3,-
7*q^60+7*q^61-q^62,-7*q^12+7*q^13-q^14,3-2*q-5*q^2+6*q^3,Unknown(),Unknown(),
4-10*q+13*q^2-6*q^3-2*q^4+4*q^5-q^6,Unknown(),Unknown(),Unknown(),4*q^12-
8*q^13+3*q^14,Unknown(),Unknown(),3-8*q+9*q^2-8*q^4+2*q^5+q^6,0,Unknown(),
Unknown(),0,2-q^2-2*q^3,Unknown(),Unknown(),Unknown(),-4*q^24+8*q^25-3*q^26,
Unknown(),Unknown(),5*q^36-9*q^37+5*q^38,Unknown(),Unknown(),5-3*q^2-2*q^3-
3*q^4+6*q^5-q^6,0,-4*q^60-3*q^61+6*q^62-q^63,5*q^60-9*q^61+5*q^62,Unknown(),-
1+q^3+3*q^4+3*q^5,-4*q^12-3*q^13+6*q^14-q^15,Unknown(),9*q^24-13*q^25+4*q^26,-
q^24+q^25,Unknown(),Unknown(),7*q^24-7*q^25+q^26,Unknown(),-56*q^12,-5*q^12+
3*q^13,-28*q^12+24*q^13-4*q^14,Unknown(),14*q^12-11*q^13+q^14,19*q^12-27*q^13+
9*q^14-q^15,-10*q^12+14*q^13-6*q^14,Unknown(),-8*q^12+8*q^13-2*q^14,-11*q^12+
20*q^13-9*q^14+q^15,2*q^12-5*q^14+3*q^15,-12*q^12+18*q^14-8*q^15,-13*q^12+
12*q^13-6*q^15+6*q^16-q^18,5*q^12-8*q^14+3*q^15,8*q^12-4*q^13-12*q^14+14*q^15,
9*q^12-12*q^13+4*q^14+6*q^15-4*q^16+2*q^17+q^18,Unknown(),-3*q^12+2*q^13+
5*q^14-6*q^15,-2*q^12+3*q^14-3*q^15,-2*q^12+q^14+2*q^15,40*q^12-16*q^13,-
5*q^12+3*q^14+2*q^15+3*q^16-6*q^17+q^18,12*q^12-6*q^13,-25*q^12+15*q^13-q^14,
Unknown(),17*q^12-19*q^13+5*q^14,q^12-q^15-3*q^16-3*q^17,Unknown(),Unknown(),-
7*q^36+7*q^37-q^38,Unknown(),0,-9*q^12+13*q^13-4*q^14,Unknown(),56*q^24,
Unknown(),28*q^24-24*q^25+4*q^26,-14*q^24+11*q^25-q^26,-19*q^24+27*q^25-
9*q^26+q^27,7*q^24-4*q^25-4*q^26+3*q^27,-2*q^24+5*q^26-3*q^27,Unknown(),
12*q^24-18*q^26+8*q^27,-8*q^24+4*q^25+12*q^26-14*q^27,-5*q^24+8*q^26-3*q^27,
2*q^24-3*q^26+3*q^27,-40*q^24+16*q^25,25*q^24-15*q^25+q^26,-17*q^24+19*q^25-
5*q^26,-q^24+q^27+3*q^28+3*q^29,4*q^24+3*q^25-6*q^26+q^27,7*q^48-7*q^49+q^50,
Unknown(),-56*q^36,1-8*q^9+2*q^10+11*q^12-4*q^13-20*q^15+10*q^16,Unknown(),
14*q^36-11*q^37+q^38,Unknown(),Unknown(),-12*q^36+18*q^38-8*q^39,Unknown(),
5*q^36-8*q^38+3*q^39,-2*q^36+3*q^38-3*q^39,-1+10*q^9-15*q^12+30*q^15,-25*q^36+
15*q^37-q^38,Unknown(),-4*q^36-3*q^37+6*q^38-q^39,56*q^48,Unknown(),28*q^48-
24*q^49+4*q^50,5*q^12-9*q^13+5*q^14,-40*q^48+16*q^49,25*q^48-15*q^49+q^50,
Unknown(),-14*q^48+11*q^49-q^50,-56*q^60,Unknown(),-28*q^60+24*q^61-4*q^62,
40*q^60-16*q^61,-25*q^60+15*q^61-q^62,Unknown(),14*q^60-11*q^61+q^62];
  f25:=q->[56,-36+20*q,18-18*q+2*q^2,24-
24*q+8*q^2,-13+16*q-8*q^2+q^3,-8+10*q-2*q^2,-4+6*q,-16+24*q-12*q^2+4*q^3,-2+
6*q^2-2*q^3,3+q-4*q^2+3*q^3-q^4,8-10*q+6*q^2-2*q^3,4-4*q+q^2,1-q-q^2,-1+5*q-
7*q^2+2*q^3,6-9*q+4*q^2-q^3,4-4*q+2*q^2,9-15*q+10*q^2-3*q^3+q^4,-3+4*q-2*q^2,-
4*q+6*q^2-4*q^3+q^4,-1+q^2,Unknown(),-4*q+5*q^2-q^3,Unknown(),-4+6*q-3*q^2+
q^3,-2+2*q,-1+q-q^3,4-18*q^2+16*q^3,0,Unknown(),1+q-7*q^2+4*q^3,0,6-12*q+
12*q^3-6*q^4+2*q^6,Unknown(),Unknown(),-4+12*q^2-14*q^3+8*q^4,-1+q^2-q^3,-5+
9*q-4*q^2-6*q^3+10*q^4-2*q^5-q^6+q^7,-1+q-q^2+q^3-q^4,-1-q+5*q^2-3*q^3+3*q^4,-
1+5*q^2-6*q^3+q^4,Unknown(),-3+12*q-14*q^2+2*q^3+7*q^4-5*q^5,Unknown(),
Unknown(),2-8*q+12*q^2-6*q^3-5*q^4+5*q^5-q^6,1-q^2-q^4,-4*q^75+4*q^76-q^77,-
4*q^15+4*q^16-q^17,1-4*q^2+4*q^3-3*q^4+q^5,Unknown(),Unknown(),2-9*q+13*q^2-
7*q^3-4*q^4+6*q^5-2*q^6,Unknown(),Unknown(),Unknown(),3*q^15-4*q^16+2*q^17,
Unknown(),Unknown(),2-6*q+6*q^2+2*q^3-7*q^4+6*q^5-q^6,0,Unknown(),Unknown(),0,
1-2*q^3+3*q^4,Unknown(),Unknown(),Unknown(),-3*q^30+4*q^31-2*q^32,Unknown(),
Unknown(),4*q^45-6*q^46+3*q^47-q^48,Unknown(),Unknown(),1-q^2+4*q^3-3*q^4+
10*q^5,0,q^75-5*q^76+7*q^77-2*q^78,4*q^75-6*q^76+3*q^77-q^78,Unknown(),-2*q^6,
q^15-5*q^16+7*q^17-2*q^18,Unknown(),6*q^30-9*q^31+4*q^32-q^33,q^32,Unknown(),
Unknown(),4*q^30-4*q^31+q^32,Unknown(),-56*q^15,-q^15+q^16+q^17,-24*q^15+
24*q^16-8*q^17,Unknown(),8*q^15-10*q^16+2*q^17,16*q^15-24*q^16+12*q^17-4*q^18,
-8*q^15+10*q^16-6*q^17+2*q^18,Unknown(),-4*q^15+4*q^16-2*q^17,-9*q^15+15*q^16-
10*q^17+3*q^18-q^19,4*q^16-6*q^17+4*q^18-q^19,-4*q^15+18*q^17-16*q^18,-6*q^15+
12*q^16-12*q^18+6*q^19-2*q^21,q^15-5*q^17+6*q^18-q^19,4*q^15-12*q^17+14*q^18-
8*q^19,5*q^15-9*q^16+4*q^17+6*q^18-10*q^19+2*q^20+q^21-q^22,Unknown(),-q^15+
4*q^17-4*q^18+3*q^19-q^20,-q^15+q^17+q^19,-q^15+2*q^18-3*q^19,36*q^15-20*q^16,
-q^15+q^17-4*q^18+3*q^19-10*q^20,4*q^15-6*q^16,-18*q^15+18*q^16-2*q^17,
Unknown(),13*q^15-16*q^16+8*q^17-q^18,2*q^21,Unknown(),Unknown(),-4*q^45+
4*q^46-q^47,Unknown(),0,-6*q^15+9*q^16-4*q^17+q^18,Unknown(),56*q^30,
Unknown(),24*q^30-24*q^31+8*q^32,-8*q^30+10*q^31-2*q^32,-16*q^30+24*q^31-
12*q^32+4*q^33,3*q^30+q^31-4*q^32+3*q^33-q^34,-4*q^31+6*q^32-4*q^33+q^34,
Unknown(),4*q^30-18*q^32+16*q^33,-4*q^30+12*q^32-14*q^33+8*q^34,-q^30+5*q^32-
6*q^33+q^34,q^30-q^32-q^34,-36*q^30+20*q^31,18*q^30-18*q^31+2*q^32,-13*q^30+
16*q^31-8*q^32+q^33,-2*q^36,-q^30+5*q^31-7*q^32+2*q^33,4*q^60-4*q^61+q^62,
Unknown(),-56*q^45,-24*q^15+12*q^16+12*q^18-8*q^19,Unknown(),8*q^45-10*q^46+
2*q^47,Unknown(),Unknown(),-4*q^45+18*q^47-16*q^48,Unknown(),q^45-5*q^47+
6*q^48-q^49,-q^45+q^47+q^49,36*q^15-20*q^18,-18*q^45+18*q^46-2*q^47,Unknown(),
q^45-5*q^46+7*q^47-2*q^48,56*q^60,Unknown(),24*q^60-24*q^61+8*q^62,4*q^15-
6*q^16+3*q^17-q^18,-36*q^60+20*q^61,18*q^60-18*q^61+2*q^62,Unknown(),-8*q^60+
10*q^61-2*q^62,-56*q^75,Unknown(),-24*q^75+24*q^76-8*q^77,36*q^75-20*q^76,-
18*q^75+18*q^76-2*q^77,Unknown(),8*q^75-10*q^76+2*q^77];
  f27:=q->[70,-45+25*q,24-21*q+4*q^2,28-34*q+8*q^2,-14+24*q-
10*q^2+q^3,-11+13*q-4*q^2,-9+6*q+q^3,-17+33*q-18*q^2+2*q^3,-6+6*q^2-2*q^3,2-
4*q-4*q^2+3*q^3-q^4,6-16*q+10*q^2-2*q^3,4-7*q+3*q^2,3-2*q,4*q-6*q^2+3*q^3,6-
13*q+8*q^2-q^3,4-9*q+2*q^2-q^3,8-21*q+16*q^2-4*q^3,-2+6*q-5*q^2+q^3,1-2*q+
5*q^2-4*q^3+q^4,q,Unknown(),2-3*q+4*q^2-2*q^3,Unknown(),-2+8*q-7*q^2+2*q^3,-1+
3*q-2*q^2,-1+3*q-q^2,9-18*q^2+24*q^3+q^6,0,Unknown(),3+2*q-8*q^2+3*q^3-q^4,0,
12-12*q+18*q^3-6*q^4+4*q^6,Unknown(),Unknown(),-4+5*q+12*q^2-22*q^3+8*q^4-q^6,
-q+3*q^2-q^3,-6+14*q-4*q^2-12*q^3+10*q^4-2*q^5-3*q^6+q^7,q^2+q^3-q^4,-1+q+
6*q^2-5*q^3+2*q^4,-3+5*q^2-8*q^3+q^4,Unknown(),-6+12*q-15*q^2+q^3+7*q^4-4*q^5,
Unknown(),Unknown(),2-8*q+12*q^2-4*q^3-4*q^4+4*q^5-q^6,-2*q^2+3*q^3,-4*q^75+
7*q^76-3*q^77,-4*q^15+7*q^16-3*q^17,1-2*q-3*q^2+7*q^3-4*q^4,Unknown(),
Unknown(),3-11*q+14*q^2-6*q^3-5*q^4+5*q^5-q^6,Unknown(),Unknown(),Unknown(),
2*q^15-6*q^16+5*q^17-q^18,Unknown(),Unknown(),2-6*q+7*q^2+2*q^3-8*q^4+2*q^5,0,
Unknown(),Unknown(),0,-q^2+2*q^4-2*q^5,Unknown(),Unknown(),Unknown(),-2*q^30+
6*q^31-5*q^32+q^33,Unknown(),Unknown(),2*q^45-8*q^46+7*q^47-2*q^48,Unknown(),
Unknown(),3-2*q^2-2*q^3+8*q^5-3*q^6+3*q^8,0,-4*q^76+6*q^77-3*q^78,2*q^75-
8*q^76+7*q^77-2*q^78,Unknown(),-1-3*q^5+6*q^7,-4*q^16+6*q^17-3*q^18,Unknown(),
6*q^30-13*q^31+8*q^32-q^33,-q^30,Unknown(),Unknown(),4*q^30-7*q^31+3*q^32,
Unknown(),-70*q^15,-3*q^15+2*q^16,-28*q^15+34*q^16-8*q^17,Unknown(),11*q^15-
13*q^16+4*q^17,17*q^15-33*q^16+18*q^17-2*q^18,-6*q^15+16*q^16-10*q^17+2*q^18,
Unknown(),-4*q^15+9*q^16-2*q^17+q^18,-8*q^15+21*q^16-16*q^17+4*q^18,-q^15+
2*q^16-5*q^17+4*q^18-q^19,-9*q^15+18*q^17-24*q^18-q^21,-12*q^15+12*q^16-
18*q^18+6*q^19-4*q^21,3*q^15-5*q^17+8*q^18-q^19,4*q^15-5*q^16-12*q^17+22*q^18-
8*q^19+q^21,6*q^15-14*q^16+4*q^17+12*q^18-10*q^19+2*q^20+3*q^21-q^22,
Unknown(),-q^15+2*q^16+3*q^17-7*q^18+4*q^19,2*q^17-3*q^18,q^17-2*q^19+2*q^20,
45*q^15-25*q^16,-3*q^15+2*q^17+2*q^18-8*q^20+3*q^21-3*q^23,9*q^15-6*q^16-q^18,
-24*q^15+21*q^16-4*q^17,Unknown(),14*q^15-24*q^16+10*q^17-q^18,q^15+3*q^20-
6*q^22,Unknown(),Unknown(),-4*q^45+7*q^46-3*q^47,Unknown(),0,-6*q^15+13*q^16-
8*q^17+q^18,Unknown(),70*q^30,Unknown(),28*q^30-34*q^31+8*q^32,-11*q^30+
13*q^31-4*q^32,-17*q^30+33*q^31-18*q^32+2*q^33,2*q^30-4*q^31-4*q^32+3*q^33-
q^34,q^30-2*q^31+5*q^32-4*q^33+q^34,Unknown(),9*q^30-18*q^32+24*q^33+q^36,-
4*q^30+5*q^31+12*q^32-22*q^33+8*q^34-q^36,-3*q^30+5*q^32-8*q^33+q^34,-2*q^32+
3*q^33,-45*q^30+25*q^31,24*q^30-21*q^31+4*q^32,-14*q^30+24*q^31-10*q^32+q^33,-
q^30-3*q^35+6*q^37,4*q^31-6*q^32+3*q^33,4*q^60-7*q^61+3*q^62,Unknown(),-
70*q^45,1-4*q^15+2*q^16-8*q^21+7*q^22,Unknown(),11*q^45-13*q^46+4*q^47,
Unknown(),Unknown(),-9*q^45+18*q^47-24*q^48-q^51,Unknown(),3*q^45-5*q^47+
8*q^48-q^49,2*q^47-3*q^48,-1+6*q^15+15*q^21,-24*q^45+21*q^46-4*q^47,Unknown(),
-4*q^46+6*q^47-3*q^48,70*q^60,Unknown(),28*q^60-34*q^61+8*q^62,2*q^15-8*q^16+
7*q^17-2*q^18,-45*q^60+25*q^61,24*q^60-21*q^61+4*q^62,Unknown(),-11*q^60+
13*q^61-4*q^62,-70*q^75,Unknown(),-28*q^75+34*q^76-8*q^77,45*q^75-25*q^76,-
24*q^75+21*q^76-4*q^77,Unknown(),11*q^75-13*q^76+4*q^77];
  f29:=function(q,j) return [70,
-45+25*q,24-21*q+4*q^2,28-34*q+8*q^2,-14+24*q-10*q^2+q^3,-11+13*q-4*q^2,-8+(-
6*j^2-9*j)*q+3*j^2*q^2,-17+33*q-18*q^2+2*q^3,-7+3*j*q+(-9*j^2-
6*j)*q^2-q^3,3+(4*j^2+2*j)*q-5*q^2+(-5*j^2-3*j)*q^3,6-16*q+
10*q^2-2*q^3,4-7*q+3*q^2,2+(2*j^2+4*j)*q-j^2*q^2,1+(-3*j^2-
6*j)*q+(9*j^2+8*j)*q^2+(-3*j^2-2*j)*q^3,6-13*q+8*q^2-q^3,4+
(8*j^2+9*j)*q+4*q^2+j^2*q^3,8-21*q+16*q^2-4*q^3,-2+6*q-5*q^2+q^3,
(j^2+3*j)*q+(-6*j^2-7*j)*q^2+(6*j^2+5*j)*q^3-j^2*q^4,q,
Unknown(),1+(2*j^2+4*j)*q+(-5*j^2-6*j)*q^2+(3*j^2+2*j)*q^3,
Unknown(),-2+8*q-7*q^2+2*q^3,-1+3*q-2*q^2,-1+(-2*j^2-3*j)*q-2*q^2,8+
(27*j^2+18*j)*q^2+8*q^3+9*j*q^4,0,Unknown(),2+(-4*j^2-2*j)*q+
(7*j^2+5*j)*q^2+3*q^3,0,9+(12*j^2+18*j)*q+3*j^2*q^2+6*q^3+
(6*j^2+9*j)*q^4+6*j^2*q^5+q^6,Unknown(),Unknown(),-4+4*q+(-15*j^2-
12*j)*q^2+(20*j^2+14*j)*q^3-6*j*q^4+3*j*q^5,-q+(-2*j^2-
3*j)*q^2-2*q^3,-5+(-12*j^2-14*j)*q+(2*j^2+8*j)*q^2+(7*j^2+
6*j)*q^3+(-4*j^2-5*j)*q^4+(-2*j^2+4*j)*q^5+(3*j^2+j)*q^6,
-q-j^2*q^2+q^3-q^4,-1+j^2*q+(-6*j^2-4*j)*q^2+(5*j^2+
4*j)*q^3+q^4,-2+(-10*j^2-6*j)*q^2+(4*j^2+2*j)*q^3-2*j*q^4,
Unknown(),-3+(-10*j^2-14*j)*q+(10*j^2+16*j)*q^2+(-5*j^2-
9*j)*q^3+4*q^4+(2*j^2+4*j)*q^5,Unknown(),Unknown(),1-6*q+(-7*j^2-
12*j)*q^2+(4*j^2+8*j)*q^3+(2*j^2+j)*q^4+(-3*j^2-4*j)*q^5-
q^6,(2*j^2+3*j)*q^2+(-3*j^2-2*j)*q^3+j*q^4,-4*q^75+7*q^76-
3*q^77,-4*q^15+7*q^16-3*q^17,1-q+(5*j^2+3*j)*q^2+(-8*j^2-5*j)*q^3-
q^4-j*q^5,Unknown(),Unknown(),2+(7*j^2+9*j)*q+(-10*j^2-
16*j)*q^2+(5*j^2+11*j)*q^3-2*j*q^4+(-2*j^2-4*j)*q^5+
2*j*q^6,Unknown(),Unknown(),Unknown(),2*q^15-6*q^16+5*q^17-q^18,Unknown(),
Unknown(),1-6*q+6*q^2+2*q^3+(8*j^2+9*j)*q^4+4*q^5-j*q^6,0,Unknown(),
Unknown(),0,-q^2+2*j^2*q^3-2*j^2*q^4,Unknown(),Unknown(),Unknown(),-
2*q^30+6*q^31-5*q^32+q^33,Unknown(),Unknown(),2*q^45-8*q^46+7*q^47-2*q^48,
Unknown(),Unknown(),2+(2*j^2+4*j)*q^2+4*j^2*q^3+(5*j^2+
7*j)*q^4+(-8*j^2-10*j)*q^5+(3*j^2+7*j)*q^6+(-2*j^2-
4*j)*q^7,0,-q^75+(3*j^2+6*j)*q^76+(-9*j^2-8*j)*q^77+(3*j^2+
2*j)*q^78,2*q^75-8*q^76+7*q^77-2*q^78,Unknown(),(-2*j^2+j)*q^3+3*q^4+
(6*j^2-3*j)*q^6,-q^15+(3*j^2+6*j)*q^16+(-9*j^2-8*j)*q^17+
(3*j^2+2*j)*q^18,Unknown(),6*q^30-13*q^31+8*q^32-q^33,-j*q^31,
Unknown(),Unknown(),4*q^30-7*q^31+3*q^32,Unknown(),-70*q^15,-2*q^15+(-
2*j^2-4*j)*q^16+j^2*q^17,-28*q^15+34*q^16-8*q^17,Unknown(),11*q^15-
13*q^16+4*q^17,17*q^15-33*q^16+18*q^17-2*q^18,-6*q^15+16*q^16-10*q^17+2*q^18,
Unknown(),-4*q^15+(-8*j^2-9*j)*q^16-4*q^17-j^2*q^18,-8*q^15+21*q^16-
16*q^17+4*q^18,(-j^2-3*j)*q^16+(6*j^2+7*j)*q^17+(-6*j^2-
5*j)*q^18+j^2*q^19,-8*q^15+(-27*j^2-18*j)*q^17-8*q^18-9*j*q^19,
-9*q^15+(-12*j^2-18*j)*q^16-3*j^2*q^17-6*q^18+(-6*j^2-
9*j)*q^19-6*j^2*q^20-q^21,2*q^15+(10*j^2+6*j)*q^17+(-4*j^2-
2*j)*q^18+2*j*q^19,4*q^15-4*q^16+(15*j^2+12*j)*q^17+(-20*j^2-
14*j)*q^18+6*j*q^19-3*j*q^20,5*q^15+(12*j^2+14*j)*q^16+(-
2*j^2-8*j)*q^17+(-7*j^2-6*j)*q^18+(4*j^2+5*j)*q^19+
(2*j^2-4*j)*q^20+(-3*j^2-j)*q^21,Unknown(),-q^15+q^16+(-5*j^2-
3*j)*q^17+(8*j^2+5*j)*q^18+q^19+j*q^20,(-2*j^2-3*j)*q^17+
(3*j^2+2*j)*q^18-j*q^19,q^17-2*j^2*q^18+2*j^2*q^19,45*q^15-
25*q^16,-2*q^15+(-2*j^2-4*j)*q^17-4*j^2*q^18+(-5*j^2-7*j)*q^19+
(8*j^2+10*j)*q^20+(-3*j^2-7*j)*q^21+(2*j^2+4*j)*q^22,8*q^15+
(6*j^2+9*j)*q^16-3*j^2*q^17,-24*q^15+21*q^16-4*q^17,Unknown(),
14*q^15-24*q^16+10*q^17-q^18,(2*j^2-j)*q^18-3*q^19+(-6*j^2+
3*j)*q^21,Unknown(),Unknown(),-4*q^45+7*q^46-3*q^47,Unknown(),0,-6*q^15+
13*q^16-8*q^17+q^18,Unknown(),70*q^30,Unknown(),28*q^30-34*q^31+8*q^32,-
11*q^30+13*q^31-4*q^32,-17*q^30+33*q^31-18*q^32+2*q^33,3*q^30+(4*j^2+
2*j)*q^31-5*q^32+(-5*j^2-3*j)*q^33,(j^2+3*j)*q^31+(-6*j^2-
7*j)*q^32+(6*j^2+5*j)*q^33-j^2*q^34,Unknown(),8*q^30+(27*j^2+
18*j)*q^32+8*q^33+9*j*q^34,-4*q^30+4*q^31+(-15*j^2-12*j)*q^32+
(20*j^2+14*j)*q^33-6*j*q^34+3*j*q^35,-2*q^30+(-10*j^2-
6*j)*q^32+(4*j^2+2*j)*q^33-2*j*q^34,(2*j^2+3*j)*q^32+(-
3*j^2-2*j)*q^33+j*q^34,-45*q^30+25*q^31,24*q^30-21*q^31+4*q^32,-
14*q^30+24*q^31-10*q^32+q^33,(-2*j^2+j)*q^33+3*q^34+(6*j^2-
3*j)*q^36,q^30+(-3*j^2-6*j)*q^31+(9*j^2+8*j)*q^32+(-3*j^2-
2*j)*q^33,4*q^60-7*q^61+3*q^62,Unknown(),-70*q^45,-4*q^9+q^10+11*q^12-
4*q^13-18*q^18+12*q^19,Unknown(),11*q^45-13*q^46+4*q^47,Unknown(),Unknown(),-
8*q^45+(-27*j^2-18*j)*q^47-8*q^48-9*j*q^49,Unknown(),2*q^45+
(10*j^2+6*j)*q^47+(-4*j^2-2*j)*q^48+2*j*q^49,(-2*j^2-
3*j)*q^47+(3*j^2+2*j)*q^48-j*q^49,5*q^9-15*q^12+30*q^18,-24*q^45+
21*q^46-4*q^47,Unknown(),-q^45+(3*j^2+6*j)*q^46+(-9*j^2-8*j)*q^47+
(3*j^2+2*j)*q^48,70*q^60,Unknown(),28*q^60-34*q^61+8*q^62,2*q^15-8*q^16+
7*q^17-2*q^18,-45*q^60+25*q^61,24*q^60-21*q^61+4*q^62,Unknown(),-11*q^60+
13*q^61-4*q^62,-70*q^75,Unknown(),-28*q^75+34*q^76-8*q^77,45*q^75-25*q^76,-
24*q^75+21*q^76-4*q^77,Unknown(),11*q^75-13*q^76+4*q^77];end;
  f33:=function(q,j) return [84,-34+50*q,8-26*q+24*q^2,12-44*q+28*q^2,-2+16*q-
28*q^2+12*q^3,-1+7*q-15*q^2+9*q^3,(-3*j^2-2*j)*q+(3*j^2+9*j)*q^2+
9*q^3,-3+27*q-39*q^2+15*q^3,3+(9*j^2+3*j)*q+(-2*j^2-3*j)*q^2+
6*q^3,-1+(-6*j^2-4*j)*q+(5*j^2+2*j)*q^2-2*q^3+2*q^4,-4*q+16*q^2-
16*q^3+4*q^4,-q+5*q^2-7*q^3+2*q^4,-j*q^2+(j^2+4*j)*q^3+2*q^4,-1+(-
6*j^2-3*j)*q+(10*j^2+6*j)*q^2+(-4*j^2-5*j)*q^3,-3*q+12*q^2-
13*q^3+4*q^4,j^2*q+(-4*j^2-6*j)*q^2+(6*j^2+10*j)*q^3+4*q^4,-
7*q+24*q^2-21*q^3+6*q^4,-3*q^2+7*q^3-4*q^4+q^5,(3*j^2+2*j)*q+(-8*j^2-
5*j)*q^2+(7*j^2+5*j)*q^3+3*q^4,-j*q^3+j*q^4,Unknown(),-q+(-
5*j^2-3*j)*q^2+(6*j^2+4*j)*q^3+3*q^4-q^5,Unknown(),-5*q^2+10*q^3-
6*q^4+q^5,-q^2+3*q^3-2*q^4,(-j^2-3*j)*q^3+(j^2+3*j)*q^4+q^5,
(6*j^2+9*j)*q^2+24*q^3+(27*j^2+9*j)*q^4+9*q^6,0,Unknown(),-q^2+
5*q^3+(8*j^2+5*j)*q^4+(-4*j^2-j)*q^5+2*q^6,0,3+(6*j^2+
4*j)*q+(3*j^2+9*j)*q^2+18*q^3+(3*j^2+2*j)*q^4+(6*j^2+
18*j)*q^5+12*q^6,Unknown(),Unknown(),-3*j*q^2-14*q^3+(-28*j^2-
22*j)*q^4+(15*j^2+3*j)*q^5-5*q^6+4*q^7,(-j^2-2*j)*q^4+
(3*j^2+2*j)*q^5-j^2*q^6,-1+(-4*j^2-2*j)*q+2*j^2*q^2+
(7*j^2+11*j)*q^3+(-13*j^2-12*j)*q^4+(-2*j^2-6*j)*q^5+
(8*j^2+16*j)*q^6+6*q^7,-q^2+(-3*j^2-j)*q^3+(2*j^2+j)*q^4+
j^2*q^5-j^2*q^6,-3*q^3+(-7*j^2-6*j)*q^4+(6*j^2+3*j)*q^5+(-
j^2+j)*q^6+q^7,(2*j^2+4*j)*q^3+(-8*j^2-6*j)*q^4+(8*j^2+
2*j)*q^5+2*q^7,Unknown(),-1+2*q+(4*j^2-2*j)*q^2+(-2*j^2+
7*j)*q^3+(4*j^2-j)*q^4+(-9*j^2-11*j)*q^5+(6*j^2+
12*j)*q^6+4*q^7,Unknown(),Unknown(),-j*q^2+(3*j^2-j)*q^3+(-
7*j^2+j)*q^4+(7*j^2+2*j)*q^5+(-6*j^2-5*j)*q^6+(2*j^2+
4*j)*q^7+q^8,j*q^4+3*q^5+2*j^2*q^6,j^2*q^126-5*j^2*q^127+
7*j^2*q^128-2*j^2*q^129,j*q^26-5*j*q^27+7*j*q^28-2*j*q^29,-
j*q^3-6*q^4+(-8*j^2-5*j)*q^5+4*j^2*q^6-q^7+q^8,Unknown(),
Unknown(),-q-2*j^2*q^2+(4*j^2-2*j)*q^3+(-4*j^2+3*j)*q^4+
(7*j^2+4*j)*q^5+(-8*j^2-10*j)*q^6+(4*j^2+8*j)*q^7+2*q^8,
Unknown(),Unknown(),Unknown(),3*j*q^27-7*j*q^28+4*j*q^29-j*q^30,
Unknown(),Unknown(),-q^2-2*j^2*q^3+(j^2-3*j)*q^4+(4*j^2+
8*j)*q^6+(-2*j^2-8*j)*q^7+q^8+(2*j^2+4*j)*q^9+q^10,0,Unknown(),
Unknown(),0,-2*q^5-3*j^2*q^6+j^2*q^8,Unknown(),Unknown(),Unknown(),-
3*j^2*q^52+7*j^2*q^53-4*j^2*q^54+j^2*q^55,Unknown(),Unknown(),
5*q^77-10*q^78+6*q^79-q^80,Unknown(),Unknown(),-q^4+(-6*j^2-4*j)*q^5+
(9*j^2+5*j)*q^6+(-8*j^2-6*j)*q^7-3*j^2*q^8+(8*j^2+
2*j)*q^9+(j^2+4*j)*q^10+2*q^12,0,j^2*q^125+(-3*j^2+
3*j)*q^126+(6*j^2-4*j)*q^127+(-5*j^2-j)*q^128,5*j^2*q^127-
10*j^2*q^128+6*j^2*q^129-j^2*q^130,Unknown(),9*j^2*q^8+(2*j^2+
5*j)*q^9+6*q^10+(2*j^2-j)*q^12,j*q^25+(-3*j^2-6*j)*q^26+
(4*j^2+10*j)*q^27+(j^2-4*j)*q^28,Unknown(),-3*j^2*q^51+
12*j^2*q^52-13*j^2*q^53+4*j^2*q^54,j*q^53+q^54,Unknown(),
Unknown(),-j^2*q^51+5*j^2*q^52-7*j^2*q^53+2*j^2*q^54,Unknown(),-
84*j*q^25,j^2*q^27+(-3*j^2+j)*q^28-2*j*q^29,-12*j*q^25+
44*j*q^26-28*j*q^27,Unknown(),j*q^25-7*j*q^26+15*j*q^27-
9*j*q^28,3*j*q^25-27*j*q^26+39*j*q^27-15*j*q^28,4*j*q^26-
16*j*q^27+16*j*q^28-4*j*q^29,Unknown(),-q^26+(2*j^2-4*j)*q^27+
(-4*j^2+6*j)*q^28-4*j*q^29,7*j*q^26-24*j*q^27+21*j*q^28-
6*j*q^29,(j^2+3*j)*q^26+(-3*j^2-8*j)*q^27+(2*j^2+
7*j)*q^28-3*j*q^29,(-3*j^2+6*j)*q^27-24*j*q^28+(18*j^2+
27*j)*q^29-9*j*q^31,-3*j*q^25+(2*j^2+6*j)*q^26+(-6*j^2+
3*j)*q^27-18*j*q^28+(j^2+3*j)*q^29+(-12*j^2+6*j)*q^30-
12*j*q^31,(-2*j^2+2*j)*q^28+(-2*j^2-8*j)*q^29+(6*j^2+
8*j)*q^30-2*j*q^32,3*j^2*q^27+14*j*q^28+(-6*j^2-28*j)*q^29+
(12*j^2+15*j)*q^30+5*j*q^31-4*j*q^32,j*q^25+(-2*j^2-
4*j)*q^26-2*q^27+(-4*j^2+7*j)*q^28+(-j^2-13*j)*q^29+(4*j^2-
2*j)*q^30+(-8*j^2+8*j)*q^31-6*j*q^32,Unknown(),j^2*q^28+
6*j*q^29+(-3*j^2-8*j)*q^30-4*q^31+j*q^32-j*q^33,-j^2*q^29-
3*j*q^30-2*q^31,2*j*q^30+3*q^31-q^33,34*j*q^25-50*j*q^26,
j*q^29+(-2*j^2-6*j)*q^30+(4*j^2+9*j)*q^31+(-2*j^2-
8*j)*q^32+3*q^33+(6*j^2+8*j)*q^34+(-3*j^2+j)*q^35-2*j*q^37,
(-j^2-3*j)*q^26+(-6*j^2+3*j)*q^27-9*j*q^28,-8*j*q^25+
26*j*q^26-24*j*q^27,Unknown(),2*j*q^25-16*j*q^26+28*j*q^27-
12*j*q^28,-9*q^33+(-3*j^2+2*j)*q^34-6*j*q^35+(3*j^2+
2*j)*q^37,Unknown(),Unknown(),q^76-5*q^77+7*q^78-2*q^79,Unknown(),0,
3*j*q^26-12*j*q^27+13*j*q^28-4*j*q^29,Unknown(),84*j^2*q^50,
Unknown(),12*j^2*q^50-44*j^2*q^51+28*j^2*q^52,-j^2*q^50+
7*j^2*q^51-15*j^2*q^52+9*j^2*q^53,-3*j^2*q^50+27*j^2*q^51-
39*j^2*q^52+15*j^2*q^53,-j^2*q^50+(4*j^2-2*j)*q^51+(-2*j^2+
3*j)*q^52-2*j^2*q^53+2*j^2*q^54,(-2*j^2+j)*q^51+(5*j^2-
3*j)*q^52+(-5*j^2+2*j)*q^53+3*j^2*q^54,Unknown(),(-9*j^2-
3*j)*q^52+24*j^2*q^53+(-9*j^2+18*j)*q^54+9*j^2*q^56,-3*q^52-
14*j^2*q^53+(22*j^2-6*j)*q^54+(-3*j^2+12*j)*q^55-5*j^2*q^56+
4*j^2*q^57,(-4*j^2-2*j)*q^53+(6*j^2-2*j)*q^54+(-2*j^2+
6*j)*q^55+2*j^2*q^57,q^54+3*j^2*q^55+2*j*q^56,-34*j^2*q^50+
50*j^2*q^51,8*j^2*q^50-26*j^2*q^51+24*j^2*q^52,-2*j^2*q^50+
16*j^2*q^51-28*j^2*q^52+12*j^2*q^53,9*j*q^58+(-5*j^2-
3*j)*q^59+6*j^2*q^60+(j^2+3*j)*q^62,-j^2*q^50+(3*j^2-
3*j)*q^51+(-6*j^2+4*j)*q^52+(5*j^2+j)*q^53,-j*q^101+
5*j*q^102-7*j*q^103+2*j*q^104,Unknown(),-84*q^75,21*q^24-24*q^25-
4*q^27+6*q^28-8*q^30+16*q^31+q^36-4*q^37,Unknown(),q^75-7*q^76+15*q^77-9*q^78,
Unknown(),Unknown(),(-6*j^2-9*j)*q^77-24*q^78+(-27*j^2-9*j)*q^79-
9*q^81,Unknown(),(-2*j^2-4*j)*q^78+(8*j^2+6*j)*q^79+(-8*j^2-
2*j)*q^80-2*q^82,-j*q^79-3*q^80-2*j^2*q^81,-45*q^24+10*q^27+24*q^30-
5*q^36,-8*q^75+26*q^76-24*q^77,Unknown(),q^75+(6*j^2+3*j)*q^76+(-
10*j^2-6*j)*q^77+(4*j^2+5*j)*q^78,84*j*q^100,Unknown(),
12*j*q^100-44*j*q^101+28*j*q^102,5*j*q^27-10*j*q^28+
6*j*q^29-j*q^30,-34*j*q^100+50*j*q^101,8*j*q^100-26*j*q^101+
24*j*q^102,Unknown(),-j*q^100+7*j*q^101-15*j*q^102+9*j*q^103,-
84*j^2*q^125,Unknown(),-12*j^2*q^125+44*j^2*q^126-28*j^2*q^127,
34*j^2*q^125-50*j^2*q^126,-8*j^2*q^125+26*j^2*q^126-
24*j^2*q^127,Unknown(),j^2*q^125-7*j^2*q^126+15*j^2*q^127-
9*j^2*q^128];end;
  f37:=q->[90,-30+60*q,3-27*q+33*q^2,10-40*q+
40*q^2,-1+11*q-29*q^2+22*q^3,3*q-17*q^2+16*q^3,-9*q^2+12*q^3,-3+21*q-39*q^2+
27*q^3,3-9*q+9*q^3,-1+5*q-6*q^2-3*q^3+6*q^4,-2*q+10*q^2-20*q^3+12*q^4,2*q^2-
9*q^3+7*q^4,-q^2-3*q^3+4*q^4,3*q-10*q^2+6*q^3+q^4,-q+8*q^2-16*q^3+11*q^4,
3*q^2-10*q^3+8*q^4,-5*q+17*q^2-26*q^3+15*q^4,-q^2+4*q^3-8*q^4+5*q^5,-q+5*q^2-
9*q^3+4*q^4+q^5,-q^3-q^4+q^5,Unknown(),2*q^2-7*q^3+5*q^4-q^5,Unknown(),-2*q^2+
6*q^3-11*q^4+6*q^5,q^3-4*q^4+3*q^5,-3*q^4+3*q^5,24*q^3-27*q^4+12*q^6,-q^4,
Unknown(),5*q^3-11*q^4+3*q^5+4*q^6,-q^20,3-9*q^2+18*q^3-18*q^5+15*q^6,
Unknown(),Unknown(),-8*q^3+25*q^4-18*q^5-4*q^6+8*q^7,2*q^4-4*q^5+q^6+q^7,-1+
2*q+3*q^2-12*q^3+12*q^4+6*q^5-17*q^6+10*q^7,q^3-q^4-q^5+q^7,-q^3+8*q^4-8*q^5+
q^6+3*q^7,-q^3+9*q^4-9*q^5+4*q^7,Unknown(),6*q^2-10*q^3-3*q^4+21*q^5-18*q^6+
7*q^7,Unknown(),Unknown(),-q^2+6*q^3-7*q^4-7*q^5+18*q^6-12*q^7+3*q^8,-q^4+
3*q^5-3*q^6+q^8,2*q^142-9*q^143+7*q^144,2*q^30-9*q^31+7*q^32,-4*q^4+9*q^5-
6*q^6-q^7+3*q^8,Unknown(),Unknown(),-2*q^2+7*q^3-6*q^4-9*q^5+20*q^6-14*q^7+
5*q^8,Unknown(),Unknown(),Unknown(),-q^30+4*q^31-8*q^32+5*q^33,Unknown(),
Unknown(),6*q^5-11*q^6+2*q^7+11*q^8-10*q^9+3*q^10,-q^8,Unknown(),Unknown(),-
q^16,3*q^6-2*q^7-q^8+q^10,Unknown(),Unknown(),Unknown(),-q^58+4*q^59-8*q^60+
5*q^61,Unknown(),Unknown(),-2*q^86+6*q^87-11*q^88+6*q^89,Unknown(),Unknown(),-
q^6+12*q^7-3*q^8-3*q^10+4*q^12,-q^12,3*q^141-10*q^142+6*q^143+q^144,-2*q^142+
6*q^143-11*q^144+6*q^145,Unknown(),2*q^9+3*q^10-3*q^11+q^15,3*q^29-10*q^30+
6*q^31+q^32,Unknown(),-q^57+8*q^58-16*q^59+11*q^60,-q^59+q^61,Unknown(),
Unknown(),2*q^58-9*q^59+7*q^60,Unknown(),90*q^28,-q^30-3*q^31+4*q^32,10*q^28-
40*q^29+40*q^30,Unknown(),3*q^29-17*q^30+16*q^31,-3*q^28+21*q^29-39*q^30+
27*q^31,-2*q^29+10*q^30-20*q^31+12*q^32,Unknown(),3*q^30-10*q^31+8*q^32,-
5*q^29+17*q^30-26*q^31+15*q^32,-q^29+5*q^30-9*q^31+4*q^32+q^33,24*q^31-
27*q^32+12*q^34,3*q^28-9*q^30+18*q^31-18*q^33+15*q^34,-q^31+9*q^32-9*q^33+
4*q^35,-8*q^31+25*q^32-18*q^33-4*q^34+8*q^35,-q^28+2*q^29+3*q^30-12*q^31+
12*q^32+6*q^33-17*q^34+10*q^35,Unknown(),-4*q^32+9*q^33-6*q^34-q^35+3*q^36,-
q^32+3*q^33-3*q^34+q^36,3*q^34-2*q^35-q^36+q^38,-30*q^28+60*q^29,-q^34+
12*q^35-3*q^36-3*q^38+4*q^40,-9*q^30+12*q^31,3*q^28-27*q^29+33*q^30,Unknown(),
-q^28+11*q^29-29*q^30+22*q^31,2*q^37+3*q^38-3*q^39+q^43,Unknown(),Unknown(),
2*q^86-9*q^87+7*q^88,Unknown(),-q^24,-q^29+8*q^30-16*q^31+11*q^32,Unknown(),
90*q^56,Unknown(),10*q^56-40*q^57+40*q^58,3*q^57-17*q^58+16*q^59,-3*q^56+
21*q^57-39*q^58+27*q^59,-q^56+5*q^57-6*q^58-3*q^59+6*q^60,-q^57+5*q^58-9*q^59+
4*q^60+q^61,Unknown(),24*q^59-27*q^60+12*q^62,-8*q^59+25*q^60-18*q^61-4*q^62+
8*q^63,-q^59+9*q^60-9*q^61+4*q^63,-q^60+3*q^61-3*q^62+q^64,-30*q^56+60*q^57,
3*q^56-27*q^57+33*q^58,-q^56+11*q^57-29*q^58+22*q^59,2*q^65+3*q^66-3*q^67+
q^71,3*q^57-10*q^58+6*q^59+q^60,2*q^114-9*q^115+7*q^116,Unknown(),90*q^84,-
8*q^27+12*q^28+2*q^30-4*q^31-4*q^33+11*q^34+q^46,Unknown(),3*q^85-17*q^86+
16*q^87,Unknown(),Unknown(),24*q^87-27*q^88+12*q^90,Unknown(),-q^87+9*q^88-
9*q^89+4*q^91,-q^88+3*q^89-3*q^90+q^92,20*q^27-6*q^30+15*q^33+q^45,3*q^84-
27*q^85+33*q^86,Unknown(),3*q^85-10*q^86+6*q^87+q^88,90*q^112,Unknown(),
10*q^112-40*q^113+40*q^114,-2*q^30+6*q^31-11*q^32+6*q^33,-30*q^112+60*q^113,
3*q^112-27*q^113+33*q^114,Unknown(),3*q^113-17*q^114+16*q^115,90*q^140,
Unknown(),10*q^140-40*q^141+40*q^142,-30*q^140+60*q^141,3*q^140-27*q^141+
33*q^142,Unknown(),3*q^141-17*q^142+16*q^143];
  f39:=function(q,j) return [105,-40+65*q,6-34*q+31*q^2,16-48*q+
41*q^2,-3+16*q-32*q^2+20*q^3,6*q-18*q^2+13*q^3,-3*j*q+(10*j^2+
12*j)*q^2+6*q^3,-6+30*q-42*q^2+27*q^3,3+(12*j^2+10*j)*q-3*j^2*q^2+
3*q^3,-1+6*q+(10*j^2+6*j)*q^2+j*q^3+2*q^4,1-4*q+13*q^2-20*q^3+10*q^4,
3*q^2-8*q^3+5*q^4,(j^2-j)*q^2+(2*j^2+3*j)*q^3+q^4,(-5*j^2-
4*j)*q+(14*j^2+11*j)*q^2+(-10*j^2-7*j)*q^3-2*q^4,-3*q+10*q^2-
15*q^3+9*q^4,2*j*q+(-4*j^2-5*j)*q^2+(8*j^2+10*j)*q^3+4*q^4,1-
9*q+22*q^2-25*q^3+14*q^4,-2*q^2+4*q^3-6*q^4+4*q^5,-2*q+(-8*j^2-6*j)*q^2+
(13*j^2+9*j)*q^3+(-7*j^2-6*j)*q^4-q^5,j*q^4,Unknown(),(-
4*j^2-3*j)*q^2+(9*j^2+6*j)*q^3+(-6*j^2-5*j)*q^4-2*q^5,
Unknown(),q-3*q^2+7*q^3-9*q^4+5*q^5,q^3-3*q^4+2*q^5,j*q^2-j*q^3+(j^2+
2*j)*q^4+q^5,9*j^2*q^2+24*q^3+(36*j^2+30*j)*q^4+6*q^6,0,Unknown(),
6*q^3+(10*j^2+9*j)*q^4+(-3*j^2-2*j)*q^5+q^6,0,3+6*j*q+
(10*j^2+12*j)*q^2+18*q^3+3*j*q^4+(20*j^2+24*j)*q^5+9*q^6,
Unknown(),Unknown(),-6*j^2*q^2+(11*j^2+8*j)*q^3+28*q^4+(24*j^2+
18*j)*q^5-2*q^6+4*q^7,-j^2*q^3-2*j*q^4+(3*j^2+2*j)*q^5-
j^2*q^6,-1+(-2*j^2-6*j)*q+(-4*j^2-2*j)*q^2+(12*j^2+
14*j)*q^3+(-12*j^2-14*j)*q^4+(-8*j^2-7*j)*q^5+(15*j^2+
19*j)*q^6+6*q^7,j^2*q^2+(-3*j^2-j)*q^3+(4*j^2+2*j)*q^4+(-
2*j^2-j)*q^5+j*q^6,-2*q^3+7*q^4+(8*j^2+7*j)*q^5+(-2*j^2-
j)*q^6+q^7,(2*j^2+j)*q^3+(-7*j^2-8*j)*q^4+(10*j^2+
8*j)*q^5+q^7,Unknown(),(-6*j^2-8*j)*q^2+(7*j^2+15*j)*q^3+
10*j^2*q^4+(-25*j^2-19*j)*q^5+(18*j^2+20*j)*q^6+4*q^7,
Unknown(),Unknown(),(j^2+2*j)*q^2+(-6*j^2-11*j)*q^3+(4*j^2+
12*j)*q^4+(11*j^2+2*j)*q^5+(-20*j^2-16*j)*q^6+(10*j^2+
12*j)*q^7+2*q^8,-2*j^2*q^4+(-2*j^2-3*j)*q^5+(3*j^2+j)*q^6,
3*j*q^132-8*j*q^133+5*j*q^134,3*j^2*q^28-8*j^2*q^29+
5*j^2*q^30,-j^2*q^3+(3*j^2+4*j)*q^4+8*q^5+(7*j^2+5*j)*q^6+
q^8,Unknown(),Unknown(),-2*q^2+(-5*j^2-10*j)*q^3+(j^2+11*j)*q^4+
(14*j^2+5*j)*q^5+(-22*j^2-20*j)*q^6+(13*j^2+15*j)*q^7+3*q^8,
Unknown(),Unknown(),Unknown(),-2*j^2*q^28+4*j^2*q^29-6*j^2*q^30+
4*j^2*q^31,Unknown(),Unknown(),(3*j^2+4*j)*q^4+(-14*j^2-
12*j)*q^5+(18*j^2+17*j)*q^6+(-4*j^2-6*j)*q^7+(-9*j^2-
8*j)*q^8+(8*j^2+10*j)*q^9+2*q^10,0,Unknown(),Unknown(),0,
2*j^2*q^5+2*q^6-2*q^7+j^2*q^8,Unknown(),Unknown(),Unknown(),-
2*j*q^54+4*j*q^55-6*j*q^56+4*j*q^57,Unknown(),Unknown(),q^79-
3*q^80+7*q^81-9*q^82+5*q^83,Unknown(),Unknown(),(-2*j^2+2*j)*q^5+
(10*j^2+2*j)*q^6+(-16*j^2-12*j)*q^7+(9*j^2+10*j)*q^8+(-
2*j^2-4*j)*q^9+(2*j^2+3*j)*q^10+q^12,0,(j^2+5*j)*q^131+(-
3*j^2-14*j)*q^132+(3*j^2+10*j)*q^133-2*j*q^134,j*q^131-
3*j*q^132+7*j*q^133-9*j*q^134+5*j*q^135,Unknown(),(-7*j^2-
4*j)*q^9-3*q^11,(4*j^2-j)*q^27+(-11*j^2+3*j)*q^28+(7*j^2-
3*j)*q^29-2*j^2*q^30,Unknown(),-3*j*q^53+10*j*q^54-15*j*q^55+
9*j*q^56,q^55,Unknown(),Unknown(),3*j*q^54-8*j*q^55+5*j*q^56,
Unknown(),105*j^2*q^26,(j^2+2*j)*q^28+(-3*j^2-j)*q^29+
j^2*q^30,16*j^2*q^26-48*j^2*q^27+41*j^2*q^28,Unknown(),
6*j^2*q^27-18*j^2*q^28+13*j^2*q^29,-6*j^2*q^26+30*j^2*q^27-
42*j^2*q^28+27*j^2*q^29,j^2*q^26-4*j^2*q^27+13*j^2*q^28-
20*j^2*q^29+10*j^2*q^30,Unknown(),2*q^27+(5*j^2+j)*q^28+(-
10*j^2-2*j)*q^29+4*j^2*q^30,j^2*q^26-9*j^2*q^27+22*j^2*q^28-
25*j^2*q^29+14*j^2*q^30,-2*j^2*q^27+(6*j^2-2*j)*q^28+(-
9*j^2+4*j)*q^29+(6*j^2-j)*q^30-j^2*q^31,9*j*q^28+
24*j^2*q^29+(-30*j^2+6*j)*q^30+6*j^2*q^32,3*j^2*q^26+6*q^27+(-
12*j^2-2*j)*q^28+18*j^2*q^29+3*q^30+(-24*j^2-4*j)*q^31+
9*j^2*q^32,(-j^2+j)*q^29+(8*j^2+j)*q^30+(-8*j^2+
2*j)*q^31+j^2*q^33,-6*j*q^28+(-8*j^2+3*j)*q^29+28*j^2*q^30+
(-18*j^2+6*j)*q^31-2*j^2*q^32+4*j^2*q^33,-j^2*q^26+(6*j^2+
4*j)*q^27+(2*j^2-2*j)*q^28+(-14*j^2-2*j)*q^29+(14*j^2+
2*j)*q^30+(7*j^2-j)*q^31+(-19*j^2-4*j)*q^32+6*j^2*q^33,
Unknown(),-j*q^29+(-4*j^2-j)*q^30+8*j^2*q^31+(-5*j^2+
2*j)*q^32+j^2*q^34,-2*j*q^30+(3*j^2+j)*q^31+(-j^2+
2*j)*q^32,2*j*q^31+2*j^2*q^32-2*j^2*q^33+j*q^34,-
40*j^2*q^26+65*j^2*q^27,(-2*j^2-4*j)*q^31+(-2*j^2+8*j)*q^32+
(12*j^2-4*j)*q^33+(-10*j^2-j)*q^34+(4*j^2+2*j)*q^35+(-
3*j^2-j)*q^36+j^2*q^38,-3*q^27+(-12*j^2-2*j)*q^28+
6*j^2*q^29,6*j^2*q^26-34*j^2*q^27+31*j^2*q^28,Unknown(),-
3*j^2*q^26+16*j^2*q^27-32*j^2*q^28+20*j^2*q^29,(4*j^2-
3*j)*q^35-3*j^2*q^37,Unknown(),Unknown(),3*q^80-8*q^81+5*q^82,Unknown(),
0,-3*j^2*q^27+10*j^2*q^28-15*j^2*q^29+9*j^2*q^30,Unknown(),
105*j*q^52,Unknown(),16*j*q^52-48*j*q^53+41*j*q^54,6*j*q^53-
18*j*q^54+13*j*q^55,-6*j*q^52+30*j*q^53-42*j*q^54+27*j*q^55,
-j*q^52+6*j*q^53+(-4*j^2-10*j)*q^54+j^2*q^55+2*j*q^56,-
2*j*q^53+(2*j^2+8*j)*q^54+(-4*j^2-13*j)*q^55+(j^2+
7*j)*q^56-j*q^57,Unknown(),9*q^54+24*j*q^55+(-6*j^2-36*j)*q^56+
6*j*q^58,-6*q^54+(-3*j^2-11*j)*q^55+28*j*q^56+(-6*j^2-
24*j)*q^57-2*j*q^58+4*j*q^59,(-j^2-2*j)*q^55+(-j^2+
7*j)*q^56+(-2*j^2-10*j)*q^57+j*q^59,-2*q^56+(-j^2+2*j)*q^57+
(-2*j^2-3*j)*q^58,-40*j*q^52+65*j*q^53,6*j*q^52-34*j*q^53+
31*j*q^54,-3*j*q^52+16*j*q^53-32*j*q^54+20*j*q^55,(3*j^2+
7*j)*q^61-3*j*q^63,(j^2+5*j)*q^53+(-3*j^2-14*j)*q^54+
(3*j^2+10*j)*q^55-2*j*q^56,3*j^2*q^106-8*j^2*q^107+
5*j^2*q^108,Unknown(),105*q^78,-4*q^27+6*q^28-4*q^33+11*q^34,Unknown(),
6*q^79-18*q^80+13*q^81,Unknown(),Unknown(),9*j^2*q^80+24*q^81+(36*j^2+
30*j)*q^82+6*q^84,Unknown(),(2*j^2+j)*q^81+(-7*j^2-8*j)*q^82+
(10*j^2+8*j)*q^83+q^85,-2*j^2*q^82+(-2*j^2-3*j)*q^83+(3*j^2+
j)*q^84,10*q^27+15*q^33,6*q^78-34*q^79+31*q^80,Unknown(),(-5*j^2-
4*j)*q^79+(14*j^2+11*j)*q^80+(-10*j^2-7*j)*q^81-2*q^82,
105*j^2*q^104,Unknown(),16*j^2*q^104-48*j^2*q^105+41*j^2*q^106,
j^2*q^27-3*j^2*q^28+7*j^2*q^29-9*j^2*q^30+5*j^2*q^31,-
40*j^2*q^104+65*j^2*q^105,6*j^2*q^104-34*j^2*q^105+
31*j^2*q^106,Unknown(),6*j^2*q^105-18*j^2*q^106+13*j^2*q^107,
105*j*q^130,Unknown(),16*j*q^130-48*j*q^131+41*j*q^132,-
40*j*q^130+65*j*q^131,6*j*q^130-34*j*q^131+31*j*q^132,
Unknown(),6*j*q^131-18*j*q^132+13*j*q^133];end;
  f40:=function(q,j) return [105,-70+35*q,39-31*q+
4*q^2,46-48*q+11*q^2,-25+35*q-13*q^2+q^3,-19+20*q-4*q^2,-15+(-12*j^2-
9*j)*q+j^2*q^2,-30+48*q-24*q^2+3*q^3,-12+j*q+(-9*j^2-12*j)*q^2-
3*q^3,7+(5*j^2+4*j)*q+(6*j^2+8*j)*q^2+(-5*j^2-6*j)*q^3-q^4,
13-24*q+13*q^2-2*q^3,8-11*q+3*q^2,5+(5*j^2+3*j)*q-j^2*q^2,2+(-
6*j^2-7*j)*q+(9*j^2+12*j)*q^2+(-3*j^2-4*j)*q^3,12-20*q+
10*q^2-q^3,9+(14*j^2+12*j)*q+(-5*j^2-3*j)*q^2,16-32*q+21*q^2-
5*q^3,-5+10*q-6*q^2+q^3,-1+(3*j^2+4*j)*q+(-8*j^2-10*j)*q^2+
(5*j^2+7*j)*q^3+q^4,-1+(-2*j^2-j)*q+j^2*q^2,Unknown(),1+
(5*j^2+6*j)*q+(-6*j^2-8*j)*q^2+(2*j^2+3*j)*q^3,Unknown(),-6+
13*q-9*q^2+2*q^3,-3+5*q-2*q^2,-3+(-5*j^2-4*j)*q+(3*j^2+j)*q^2,15+
(27*j^2+36*j)*q^2+24*q^3+3*j*q^4,0,Unknown(),5+(-3*j^2-5*j)*q+
(11*j^2+13*j)*q^2+3*q^3,0,18+(24*j^2+18*j)*q+j^2*q^2+18*q^3+
(12*j^2+9*j)*q^4+2*j^2*q^5+3*q^6,Unknown(),Unknown(),-9+6*q+(-
18*j^2-24*j)*q^2+(25*j^2+28*j)*q^3+(-8*j^2-11*j)*q^4,-1+
(j^2+2*j)*q+(-4*j^2-5*j)*q^2-q^3,-11+(-23*j^2-19*j)*q+
(7*j^2+6*j)*q^2-12*q^3+(-14*j^2-12*j)*q^4+(2*j^2+3*j)*q^5-
2*q^6+q^7,-1+j*q+(-j^2-2*j)*q^2+(-2*j^2-3*j)*q^3+(j^2+
2*j)*q^4,-3+j*q+(-8*j^2-10*j)*q^2+(6*j^2+7*j)*q^3+q^4,-5+(-
9*j^2-13*j)*q^2-8*q^3,Unknown(),-8+(-22*j^2-18*j)*q+(22*j^2+
24*j)*q^2+(-j^2-7*j)*q^3+(-14*j^2-8*j)*q^4+(7*j^2+
5*j)*q^5,Unknown(),Unknown(),3+(14*j^2+12*j)*q+(-18*j^2-
20*j)*q^2+(4*j^2+10*j)*q^3+(10*j^2+4*j)*q^4+(-7*j^2-
5*j)*q^5-q^6,1+(3*j^2+5*j)*q^2+3*q^3,8*j*q^70-11*j*q^71+
3*j*q^72,8*j^2*q^14-11*j^2*q^15+3*j^2*q^16,3-2*q+(6*j^2+
8*j)*q^2+(-8*j^2-10*j)*q^3-3*q^4,Unknown(),Unknown(),5+(17*j^2+
15*j)*q+22*q^2+(8*j^2+13*j)*q^3+(9*j^2+3*j)*q^4+(-9*j^2-
6*j)*q^5-2*q^6,Unknown(),Unknown(),Unknown(),-5*j^2*q^14+10*j^2*q^15-
6*j^2*q^16+j^2*q^17,Unknown(),Unknown(),3+(12*j^2+10*j)*q+(-
12*j^2-13*j)*q^2+(-6*j^2-2*j)*q^3+(16*j^2+14*j)*q^4+6*q^5-
j^2*q^6,0,Unknown(),Unknown(),0,1+(j^2+2*j)*q^2-2*q^3+(-2*j^2-
3*j)*q^4,Unknown(),Unknown(),Unknown(),-5*j*q^28+10*j*q^29-
6*j*q^30+j*q^31,Unknown(),Unknown(),-6*q^42+13*q^43-9*q^44+2*q^45,
Unknown(),Unknown(),5+(5*j^2+3*j)*q^2+4*j*q^3+(5*j^2+3*j)*q^4+
(-10*j^2-12*j)*q^5+(3*j^2+7*j)*q^6+2*j^2*q^7,0,2*j*q^70+(-
j^2+6*j)*q^71+(3*j^2-9*j)*q^72+(-j^2+3*j)*q^73,-6*j*q^70+
13*j*q^71-9*j*q^72+2*j*q^73,Unknown(),-1+(j^2-2*j)*q^3+3*q^4-
3*q^5+(-6*j^2+3*j)*q^6,2*j^2*q^14+(7*j^2+j)*q^15+(-12*j^2-
3*j)*q^16+(4*j^2+j)*q^17,Unknown(),12*j*q^28-20*j*q^29+
10*j*q^30-j*q^31,-j*q^28-q^29,Unknown(),Unknown(),8*j*q^28-
11*j*q^29+3*j*q^30,Unknown(),105*j^2*q^14,5*j^2*q^14+(-3*j^2+
2*j)*q^15-j*q^16,46*j^2*q^14-48*j^2*q^15+11*j^2*q^16,Unknown(),
-19*j^2*q^14+20*j^2*q^15-4*j^2*q^16,-30*j^2*q^14+48*j^2*q^15-
24*j^2*q^16+3*j^2*q^17,13*j^2*q^14-24*j^2*q^15+13*j^2*q^16-
2*j^2*q^17,Unknown(),9*j^2*q^14+(-12*j^2+2*j)*q^15+(3*j^2-
2*j)*q^16,16*j^2*q^14-32*j^2*q^15+21*j^2*q^16-5*j^2*q^17,-
j^2*q^14+(-4*j^2-j)*q^15+(10*j^2+2*j)*q^16+(-7*j^2-
2*j)*q^17+j^2*q^18,15*j^2*q^14+(-36*j^2-9*j)*q^16+
24*j^2*q^17+3*q^18,18*j^2*q^14+(-18*j^2+6*j)*q^15+j*q^16+
18*j^2*q^17+(-9*j^2+3*j)*q^18+2*j*q^19+3*j^2*q^20,-
5*j^2*q^14+(13*j^2+4*j)*q^16-8*j^2*q^17,-9*j^2*q^14+
6*j^2*q^15+(24*j^2+6*j)*q^16+(-28*j^2-3*j)*q^17+(11*j^2+
3*j)*q^18,-11*j^2*q^14+(19*j^2-4*j)*q^15+(-6*j^2+j)*q^16-
12*j^2*q^17+(12*j^2-2*j)*q^18+(-3*j^2-j)*q^19-2*j^2*q^20+
j^2*q^21,Unknown(),3*j^2*q^14-2*j^2*q^15+(-8*j^2-2*j)*q^16+
(10*j^2+2*j)*q^17-3*j^2*q^18,j^2*q^14+(-5*j^2-2*j)*q^16+
3*j^2*q^17,j^2*q^14+(-2*j^2-j)*q^16-2*j^2*q^17+(3*j^2+
j)*q^18,-70*j^2*q^14+35*j^2*q^15,5*j^2*q^14+(-3*j^2+
2*j)*q^16+4*q^17+(-3*j^2+2*j)*q^18+(12*j^2+2*j)*q^19+(-
7*j^2-4*j)*q^20+2*j*q^21,-15*j^2*q^14+(9*j^2-3*j)*q^15+
j*q^16,39*j^2*q^14-31*j^2*q^15+4*j^2*q^16,Unknown(),-
25*j^2*q^14+35*j^2*q^15-13*j^2*q^16+j^2*q^17,-j^2*q^14+
(2*j^2+3*j)*q^17+3*j^2*q^18-3*j^2*q^19+(-3*j^2-9*j)*q^20,
Unknown(),Unknown(),8*q^42-11*q^43+3*q^44,Unknown(),0,12*j^2*q^14-
20*j^2*q^15+10*j^2*q^16-j^2*q^17,Unknown(),105*j*q^28,Unknown(),
46*j*q^28-48*j*q^29+11*j*q^30,-19*j*q^28+20*j*q^29-4*j*q^30,
-30*j*q^28+48*j*q^29-24*j*q^30+3*j*q^31,7*j*q^28+(-j^2-
5*j)*q^29+(2*j^2-6*j)*q^30+(-j^2+5*j)*q^31-j*q^32,-
j*q^28+(j^2-3*j)*q^29+(-2*j^2+8*j)*q^30+(2*j^2-5*j)*q^31+
j*q^32,Unknown(),15*j*q^28+(9*j^2-27*j)*q^30+24*j*q^31+
3*j^2*q^32,-9*j*q^28+6*j*q^29+(-6*j^2+18*j)*q^30+(3*j^2-
25*j)*q^31+(-3*j^2+8*j)*q^32,-5*j*q^28+(-4*j^2+9*j)*q^30-
8*j*q^31,j*q^28+(2*j^2-3*j)*q^30+3*j*q^31,-70*j*q^28+
35*j*q^29,39*j*q^28-31*j*q^29+4*j*q^30,-25*j*q^28+35*j*q^29-
13*j*q^30+j*q^31,-j*q^28+(-3*j^2-j)*q^31+3*j*q^32-
3*j*q^33+(9*j^2+6*j)*q^34,2*j*q^28+(-j^2+6*j)*q^29+
(3*j^2-9*j)*q^30+(-j^2+3*j)*q^31,8*j^2*q^56-11*j^2*q^57+
3*j^2*q^58,Unknown(),105*q^42,1-4*q^9+q^10+11*q^12-4*q^13-4*q^15+2*q^16+
18*q^18-12*q^19,Unknown(),-19*q^42+20*q^43-4*q^44,Unknown(),Unknown(),15*q^42+
(27*j^2+36*j)*q^44+24*q^45+3*j*q^46,Unknown(),-5*q^42+(-9*j^2-
13*j)*q^44-8*q^45,q^42+(3*j^2+5*j)*q^44+3*q^45,-1+5*q^9-15*q^12+
6*q^15-30*q^18,39*q^42-31*q^43+4*q^44,Unknown(),2*q^42+(-6*j^2-
7*j)*q^43+(9*j^2+12*j)*q^44+(-3*j^2-4*j)*q^45,105*j^2*q^56,
Unknown(),46*j^2*q^56-48*j^2*q^57+11*j^2*q^58,-6*j^2*q^14+
13*j^2*q^15-9*j^2*q^16+2*j^2*q^17,-70*j^2*q^56+35*j^2*q^57,
39*j^2*q^56-31*j^2*q^57+4*j^2*q^58,Unknown(),-19*j^2*q^56+
20*j^2*q^57-4*j^2*q^58,105*j*q^70,Unknown(),46*j*q^70-
48*j*q^71+11*j*q^72,-70*j*q^70+35*j*q^71,39*j*q^70-
31*j*q^71+4*j*q^72,Unknown(),-19*j*q^70+20*j*q^71-4*j*q^72];end;
  f47:=function(q,j) return [105,-50+55*q,16-34*q+21*q^2,
22-56*q+27*q^2,-6+26*q-30*q^2+9*q^3,-3+13*q-15*q^2+6*q^3,-3+(-j^2-
9*j)*q+(9*j^2+6*j)*q^2+3*q^3,-9+39*q-45*q^2+12*q^3,(6*j^2+
9*j)*q+(-9*j^2-j)*q^2,(-4*j^2-5*j)*q+(6*j^2+4*j)*q^2-
4*j^2*q^3-q^4,1-10*q+21*q^2-14*q^3+2*q^4,-3*q+7*q^2-5*q^3+q^4,2*j*q-
2*j*q^2+(2*j^2+j)*q^3,-1+(-5*j^2-7*j)*q+(13*j^2+
10*j)*q^2+(-10*j^2-4*j)*q^3-2*q^4,1-7*q+16*q^2-11*q^3+2*q^4,1+
(2*j^2+6*j)*q+(-6*j^2-9*j)*q^2+(6*j^2+4*j)*q^3+q^4,2-15*q+
30*q^2-21*q^3+3*q^4,q-5*q^2+7*q^3-3*q^4,(3*j^2+4*j)*q+(-10*j^2-
9*j)*q^2+(11*j^2+7*j)*q^3+(-6*j^2-3*j)*q^4-q^5,j*q^2,
Unknown(),-2*q+6*q^2+(8*j^2+5*j)*q^3+(-4*j^2-2*j)*q^4-q^5,
Unknown(),2*q-8*q^2+11*q^3-4*q^4,-2*q^2+3*q^3-q^4,-j*q+2*j*q^2+(-j^2-
2*j)*q^3+j^2*q^4,3+(27*j^2+3*j)*q^2+24*q^3+(18*j^2+
27*j)*q^4+3*q^6,0,Unknown(),-2*j^2*q+(4*j^2+2*j)*q^2+7*q^3+
(4*j^2+5*j)*q^4+(-j^2-2*j)*q^5,0,6+(2*j^2+18*j)*q+(9*j^2+
6*j)*q^2+18*q^3+(j^2+9*j)*q^4+(18*j^2+12*j)*q^5+6*q^6,
Unknown(),Unknown(),-1+2*q-12*j^2*q^2+(23*j^2+11*j)*q^3+(-28*j^2-
31*j)*q^4+(6*j^2+12*j)*q^5-2*q^6+q^7,j*q^3+2*q^4-q^5,-2+(-
4*j^2-12*j)*q+(-3*j^2+6*j)*q^2+(10*j^2+8*j)*q^3+(-12*j^2-
16*j)*q^4+(-9*j^2-3*j)*q^5+(11*j^2+7*j)*q^6+3*q^7,-q^2+(-
3*j^2-2*j)*q^3+(4*j^2+j)*q^4+(-2*j^2-j)*q^5,j^2*q-
2*j^2*q^2+(6*j^2+5*j)*q^3+7*q^4+(2*j^2+3*j)*q^5-j*q^6,-
4*j^2*q^2+(7*j^2+3*j)*q^3+(-4*j^2-8*j)*q^4+(3*j^2+
5*j)*q^5,Unknown(),-1+(-2*j^2-6*j)*q+4*j*q^2+(-2*j^2+
3*j)*q^3+(11*j^2-2*j)*q^4+(-16*j^2-4*j)*q^5+(10*j^2+
8*j)*q^6+2*q^7,Unknown(),Unknown(),j*q^2+3*j^2*q^3+(-9*j^2-
j)*q^4+(10*j^2+j)*q^5+(-7*j^2-3*j)*q^6-2*q^7+q^8,-q^4+(-
2*j^2-3*j)*q^5,-3*j*q^111+7*j*q^112-5*j*q^113+j*q^114,-
3*j^2*q^23+7*j^2*q^24-5*j^2*q^25+j^2*q^26,2*j^2*q^2-
4*j^2*q^3-7*q^4+(-5*j^2-7*j)*q^5+2*j*q^6,Unknown(),Unknown(),
(j^2+3*j)*q-4*j*q^2+(3*j^2+2*j)*q^3+(-8*j^2+j)*q^4+
(14*j^2+2*j)*q^5+(-12*j^2-6*j)*q^6+(5*j^2+3*j)*q^7+q^8,
Unknown(),Unknown(),Unknown(),j^2*q^23-5*j^2*q^24+7*j^2*q^25-
3*j^2*q^26,Unknown(),Unknown(),-2*q^2+(-2*j^2-6*j)*q^3+4*j*q^4+(-
4*j^2-2*j)*q^5+(9*j^2+2*j)*q^6+(-6*j^2-4*j)*q^7+2*j*q^8-
2*q^9+q^10,0,Unknown(),Unknown(),0,-3*j^2*q^4-2*q^5-2*j*q^6,Unknown(),
Unknown(),Unknown(),j*q^45-5*j*q^46+7*j*q^47-3*j*q^48,Unknown(),
Unknown(),2*q^67-8*q^68+11*q^69-4*q^70,Unknown(),Unknown(),2*j*q^2+
4*j^2*q^3-2*j^2*q^4+(-10*j^2-6*j)*q^5+(15*j^2+7*j)*q^6+(-
14*j^2-10*j)*q^7+(5*j^2+4*j)*q^8+2*j*q^9+(2*j^2+j)*q^10,
0,-j*q^110+(-2*j^2+5*j)*q^111+(-3*j^2-13*j)*q^112+(6*j^2+
10*j)*q^113-2*j*q^114,2*j*q^111-8*j*q^112+11*j*q^113-
4*j*q^114,Unknown(),(-2*j^2-5*j)*q^6-9*j^2*q^7+(3*j^2-
6*j)*q^9,-j^2*q^22+(7*j^2+2*j)*q^23+(-10*j^2+3*j)*q^24+
(4*j^2-6*j)*q^25-2*j^2*q^26,Unknown(),j*q^44-7*j*q^45+
16*j*q^46-11*j*q^47+2*j*q^48,-q^46,Unknown(),Unknown(),-3*j*q^45+
7*j*q^46-5*j*q^47+j*q^48,Unknown(),105*j^2*q^22,2*q^23-2*q^24+(-
j^2+j)*q^25,22*j^2*q^22-56*j^2*q^23+27*j^2*q^24,Unknown(),-
3*j^2*q^22+13*j^2*q^23-15*j^2*q^24+6*j^2*q^25,-9*j^2*q^22+
39*j^2*q^23-45*j^2*q^24+12*j^2*q^25,j^2*q^22-10*j^2*q^23+
21*j^2*q^24-14*j^2*q^25+2*j^2*q^26,Unknown(),j^2*q^22+(-6*j^2-
4*j)*q^23+(9*j^2+3*j)*q^24+(-4*j^2+2*j)*q^25+j^2*q^26,
2*j^2*q^22-15*j^2*q^23+30*j^2*q^24-21*j^2*q^25+3*j^2*q^26,(-
4*j^2-j)*q^23+(9*j^2-j)*q^24+(-7*j^2+4*j)*q^25+(3*j^2-
3*j)*q^26-j^2*q^27,3*j^2*q^22+(-3*j^2+24*j)*q^24+
24*j^2*q^25+(-27*j^2-9*j)*q^26+3*j^2*q^28,6*j^2*q^22+(-
18*j^2-16*j)*q^23+(-6*j^2+3*j)*q^24+18*j^2*q^25+(-9*j^2-
8*j)*q^26+(-12*j^2+6*j)*q^27+6*j^2*q^28,-4*j*q^24+(-3*j^2+
4*j)*q^25+(8*j^2+4*j)*q^26+(-5*j^2-2*j)*q^27,-j^2*q^22+
2*j^2*q^23-12*j*q^24+(-11*j^2+12*j)*q^25+(31*j^2+3*j)*q^26+
(-12*j^2-6*j)*q^27-2*j^2*q^28+j^2*q^29,-2*j^2*q^22+(12*j^2+
8*j)*q^23+(-6*j^2-9*j)*q^24+(-8*j^2+2*j)*q^25+(16*j^2+
4*j)*q^26+(3*j^2-6*j)*q^27+(-7*j^2+4*j)*q^28+3*j^2*q^29,
Unknown(),2*j*q^24-4*j*q^25-7*j^2*q^26+(7*j^2+2*j)*q^27+2*q^28,
-j^2*q^26+(3*j^2+j)*q^27,-3*j*q^26-2*j^2*q^27-2*q^28,-
50*j^2*q^22+55*j^2*q^23,2*q^24+4*j*q^25-2*j*q^26+(6*j^2-
4*j)*q^27+(-7*j^2+8*j)*q^28+(10*j^2-4*j)*q^29+(-4*j^2+
j)*q^30+2*q^31+(-j^2+j)*q^32,-3*j^2*q^22+(9*j^2+8*j)*q^23+(-
6*j^2+3*j)*q^24+3*j^2*q^25,16*j^2*q^22-34*j^2*q^23+
21*j^2*q^24,Unknown(),-6*j^2*q^22+26*j^2*q^23-30*j^2*q^24+
9*j^2*q^25,(5*j^2+3*j)*q^28-9*j*q^29+(6*j^2+9*j)*q^31,
Unknown(),Unknown(),-3*q^67+7*q^68-5*q^69+q^70,Unknown(),0,j^2*q^22-
7*j^2*q^23+16*j^2*q^24-11*j^2*q^25+2*j^2*q^26,Unknown(),
105*j*q^44,Unknown(),22*j*q^44-56*j*q^45+27*j*q^46,-3*j*q^44+
13*j*q^45-15*j*q^46+6*j*q^47,-9*j*q^44+39*j*q^45-45*j*q^46+
12*j*q^47,(-j^2+4*j)*q^45+(-2*j^2-6*j)*q^46-4*q^47-j*q^48,
(j^2-3*j)*q^45+(j^2+10*j)*q^46+(-4*j^2-11*j)*q^47+(3*j^2+
6*j)*q^48-j*q^49,Unknown(),3*j*q^44+(-24*j^2-27*j)*q^46+
24*j*q^47+(9*j^2-18*j)*q^48+3*j*q^50,-j*q^44+2*j*q^45-
12*q^46+(-12*j^2-23*j)*q^47+(-3*j^2+28*j)*q^48+(6*j^2-
6*j)*q^49-2*j*q^50+j*q^51,-4*q^46+(-4*j^2-7*j)*q^47+(-4*j^2+
4*j)*q^48+(2*j^2-3*j)*q^49,-j*q^48+(-j^2+2*j)*q^49,-
50*j*q^44+55*j*q^45,16*j*q^44-34*j*q^45+21*j*q^46,-6*j*q^44+
26*j*q^45-30*j*q^46+9*j*q^47,(-3*j^2+2*j)*q^50-9*q^51+(-
9*j^2-3*j)*q^53,-j*q^44+(-2*j^2+5*j)*q^45+(-3*j^2-
13*j)*q^46+(6*j^2+10*j)*q^47-2*j*q^48,-3*j^2*q^89+
7*j^2*q^90-5*j^2*q^91+j^2*q^92,Unknown(),105*q^66,6*q^18-4*q^19-
24*q^21+21*q^22+12*q^27-18*q^28,Unknown(),-3*q^66+13*q^67-15*q^68+6*q^69,
Unknown(),Unknown(),3*q^66+(27*j^2+3*j)*q^68+24*q^69+(18*j^2+
27*j)*q^70+3*q^72,Unknown(),-4*j^2*q^68+(7*j^2+3*j)*q^69+(-
4*j^2-8*j)*q^70+(3*j^2+5*j)*q^71,-q^70+(-2*j^2-3*j)*q^71,-
10*q^18+45*q^21-30*q^27,16*q^66-34*q^67+21*q^68,Unknown(),-q^66+(-5*j^2-
7*j)*q^67+(13*j^2+10*j)*q^68+(-10*j^2-4*j)*q^69-2*q^70,
105*j^2*q^88,Unknown(),22*j^2*q^88-56*j^2*q^89+27*j^2*q^90,
2*j^2*q^23-8*j^2*q^24+11*j^2*q^25-4*j^2*q^26,-50*j^2*q^88+
55*j^2*q^89,16*j^2*q^88-34*j^2*q^89+21*j^2*q^90,Unknown(),-
3*j^2*q^88+13*j^2*q^89-15*j^2*q^90+6*j^2*q^91,105*j*q^110,
Unknown(),22*j*q^110-56*j*q^111+27*j*q^112,-50*j*q^110+
55*j*q^111,16*j*q^110-34*j*q^111+21*j*q^112,Unknown(),-
3*j*q^110+13*j*q^111-15*j*q^112+6*j*q^113];end;
  f51:=q->[120,-60+60*q,
18-42*q+18*q^2,32-56*q+32*q^2,-11+28*q-28*q^2+11*q^3,-4+14*q-14*q^2+4*q^3,6*q-
6*q^2,-18+42*q-42*q^2+18*q^3,6-6*q+6*q^2-6*q^3,-3+5*q-8*q^2+5*q^3-3*q^4,5-
12*q+17*q^2-12*q^3+5*q^4,1-3*q+4*q^2-3*q^3+q^4,0,-3+9*q-12*q^2+9*q^3-3*q^4,3-
9*q+12*q^2-9*q^3+3*q^4,-4*q+4*q^2-4*q^3,7-19*q+26*q^2-19*q^3+7*q^4,-1+2*q-
3*q^2+3*q^3-2*q^4+q^5,2-6*q+10*q^2-10*q^3+6*q^4-2*q^5,0,Unknown(),1-3*q+5*q^2-
5*q^3+3*q^4-q^5,Unknown(),-2+4*q-6*q^2+6*q^3-4*q^4+2*q^5,q+q^3+q^5,0,-18*q^2+
48*q^3-18*q^4,-q^3,Unknown(),-4*q^2+10*q^3-4*q^4,-q^15,6-12*q-6*q^2+36*q^3-
6*q^4-12*q^5+6*q^6,Unknown(),Unknown(),12*q^2-30*q^3+30*q^4-12*q^5,0,-3+11*q-
2*q^2-22*q^3+22*q^4+2*q^5-11*q^6+3*q^7,q-2*q^2+3*q^3-3*q^4+2*q^5-q^6,3*q^2-
6*q^3+6*q^4-3*q^5,q^2-8*q^3+8*q^4-q^5,Unknown(),-3+8*q-7*q^2-9*q^3+9*q^4+
7*q^5-8*q^6+3*q^7,Unknown(),Unknown(),1-4*q+4*q^2+7*q^3-16*q^4+7*q^5+4*q^6-
4*q^7+q^8,0,-q^105+3*q^106-4*q^107+3*q^108-q^109,-q^21+3*q^22-4*q^23+3*q^24-
q^25,-q^2+5*q^3-6*q^4+5*q^5-q^6,Unknown(),Unknown(),2-7*q+9*q^2+3*q^3-12*q^4+
3*q^5+9*q^6-7*q^7+2*q^8,Unknown(),Unknown(),Unknown(),q^21-2*q^22+3*q^23-
3*q^24+2*q^25-q^26,Unknown(),Unknown(),1-2*q+q^2+6*q^3-15*q^4+20*q^5-15*q^6+
6*q^7+q^8-2*q^9+q^10,q^6,Unknown(),Unknown(),q^12,2*q^4-2*q^5+2*q^6,Unknown(),
Unknown(),Unknown(),-q^42+2*q^43-3*q^44+3*q^45-2*q^46+q^47,Unknown(),
Unknown(),2*q^63-4*q^64+6*q^65-6*q^66+4*q^67-2*q^68,Unknown(),Unknown(),2*q^3-
4*q^4+4*q^5-10*q^6+4*q^7-4*q^8+2*q^9,-q^9,3*q^105-9*q^106+12*q^107-9*q^108+
3*q^109,2*q^105-4*q^106+6*q^107-6*q^108+4*q^109-2*q^110,Unknown(),6*q^7-6*q^8,
3*q^21-9*q^22+12*q^23-9*q^24+3*q^25,Unknown(),3*q^42-9*q^43+12*q^44-9*q^45+
3*q^46,0,Unknown(),Unknown(),q^42-3*q^43+4*q^44-3*q^45+q^46,Unknown(),-
120*q^21,0,-32*q^21+56*q^22-32*q^23,Unknown(),4*q^21-14*q^22+14*q^23-4*q^24,
18*q^21-42*q^22+42*q^23-18*q^24,-5*q^21+12*q^22-17*q^23+12*q^24-5*q^25,
Unknown(),4*q^22-4*q^23+4*q^24,-7*q^21+19*q^22-26*q^23+19*q^24-7*q^25,-2*q^21+
6*q^22-10*q^23+10*q^24-6*q^25+2*q^26,18*q^23-48*q^24+18*q^25,-6*q^21+12*q^22+
6*q^23-36*q^24+6*q^25+12*q^26-6*q^27,-q^23+8*q^24-8*q^25+q^26,-12*q^23+
30*q^24-30*q^25+12*q^26,3*q^21-11*q^22+2*q^23+22*q^24-22*q^25-2*q^26+11*q^27-
3*q^28,Unknown(),q^23-5*q^24+6*q^25-5*q^26+q^27,0,-2*q^25+2*q^26-2*q^27,
60*q^21-60*q^22,-2*q^24+4*q^25-4*q^26+10*q^27-4*q^28+4*q^29-2*q^30,-6*q^22+
6*q^23,-18*q^21+42*q^22-18*q^23,Unknown(),11*q^21-28*q^22+28*q^23-11*q^24,-
6*q^28+6*q^29,Unknown(),Unknown(),-q^63+3*q^64-4*q^65+3*q^66-q^67,Unknown(),
q^18,-3*q^21+9*q^22-12*q^23+9*q^24-3*q^25,Unknown(),120*q^42,Unknown(),
32*q^42-56*q^43+32*q^44,-4*q^42+14*q^43-14*q^44+4*q^45,-18*q^42+42*q^43-
42*q^44+18*q^45,-3*q^42+5*q^43-8*q^44+5*q^45-3*q^46,2*q^42-6*q^43+10*q^44-
10*q^45+6*q^46-2*q^47,Unknown(),-18*q^44+48*q^45-18*q^46,12*q^44-30*q^45+
30*q^46-12*q^47,q^44-8*q^45+8*q^46-q^47,0,-60*q^42+60*q^43,18*q^42-42*q^43+
18*q^44,-11*q^42+28*q^43-28*q^44+11*q^45,6*q^49-6*q^50,-3*q^42+9*q^43-12*q^44+
9*q^45-3*q^46,q^84-3*q^85+4*q^86-3*q^87+q^88,Unknown(),-120*q^63,-32*q^21+
28*q^22+28*q^24-32*q^25,Unknown(),4*q^63-14*q^64+14*q^65-4*q^66,Unknown(),
Unknown(),18*q^65-48*q^66+18*q^67,Unknown(),-q^65+8*q^66-8*q^67+q^68,0,
60*q^21-60*q^24,-18*q^63+42*q^64-18*q^65,Unknown(),3*q^63-9*q^64+12*q^65-
9*q^66+3*q^67,120*q^84,Unknown(),32*q^84-56*q^85+32*q^86,2*q^21-4*q^22+6*q^23-
6*q^24+4*q^25-2*q^26,-60*q^84+60*q^85,18*q^84-42*q^85+18*q^86,Unknown(),-
4*q^84+14*q^85-14*q^86+4*q^87,-120*q^105,Unknown(),-32*q^105+56*q^106-
32*q^107,60*q^105-60*q^106,-18*q^105+42*q^106-18*q^107,Unknown(),4*q^105-
14*q^106+14*q^107-4*q^108];
  f53:=function(q,j)return [120,-40+80*q,5-35*q+45*q^2,12-56*q+52*q^2,-1+15*q-41*q^2+28*q^3,5*q-
23*q^2+22*q^3,-2*j*q-12*q^2+18*q^3,-3+27*q-57*q^2+33*q^3,3-12*q-
2*j^2*q^2+15*q^3,-1+6*q-8*q^2+(5*j^2+7*j)*q^3+8*q^4,-2*q+16*q^2-
28*q^3+14*q^4,4*q^2-13*q^3+9*q^4,-j*q^2-5*q^3+6*q^4,4*q+(13*j^2+
12*j)*q^2+(-8*j^2-6*j)*q^3+3*q^4,-q+12*q^2-24*q^3+13*q^4,(-4*j^2-
6*j)*q^2-16*q^3+10*q^4,-5*q+25*q^2-38*q^3+17*q^4,-q^2+8*q^3-12*q^4+5*q^5,-
q+7*q^2+(11*j^2+10*j)*q^3+(-4*j^2-2*j)*q^4+q^5,-j*q^3-2*q^4+
q^5,Unknown(),3*q^2+(9*j^2+8*j)*q^3+(-7*j^2-5*j)*q^4-q^5,
Unknown(),-2*q^2+12*q^3-15*q^4+6*q^5,3*q^3-6*q^4+3*q^5,(-2*j^2-3*j)*q^3-
6*q^4+3*q^5,6*j^2*q^2+24*q^3-36*q^4+18*q^6,-j*q^4,Unknown(),4*q^3-
13*q^4+5*q^5+6*q^6,-j^2*q^20,3+4*j*q-12*q^2+18*q^3+2*j*q^4-24*q^5+
21*q^6,Unknown(),Unknown(),(14*j^2+8*j)*q^3+28*q^4-24*q^5-8*q^6+10*q^7,
(-2*j^2-j)*q^4-5*q^5+2*q^6+q^7,-1+2*q-4*j^2*q^2-14*q^3+12*q^4+(-
8*j^2-6*j)*q^5-25*q^6+12*q^7,2*q^3+(3*j^2+2*j)*q^4-2*q^5+q^6+q^7,-
q^3+8*q^4-10*q^5+3*q^7,j^2*q^3+(-8*j^2-9*j)*q^4-13*q^5+6*q^7,
Unknown(),6*q^2+(9*j^2+12*j)*q^3+(9*j^2+4*j)*q^4+(-27*j^2-
23*j)*q^5-22*q^6+9*q^7,Unknown(),Unknown(),-q^2+6*q^3+(4*j^2+
7*j)*q^4+(13*j^2+7*j)*q^5+(-22*j^2-18*j)*q^6-14*q^7+3*q^8,
j^2*q^4+3*q^5-5*q^6+q^8,-4*j^2*q^142+13*j^2*q^143-9*j^2*q^144,-
4*j*q^30+13*j*q^31-9*j*q^32,(4*j^2+3*j)*q^4+(-10*j^2-
11*j)*q^5-8*q^6-3*q^7+3*q^8,Unknown(),Unknown(),-2*q^2+8*q^3+(3*j^2+
6*j)*q^4+(16*j^2+11*j)*q^5+(-26*j^2-22*j)*q^6-18*q^7+5*q^8,
Unknown(),Unknown(),Unknown(),j*q^30-8*j*q^31+12*j*q^32-5*j*q^33,
Unknown(),Unknown(),q^4+6*q^5+(14*j^2+15*j)*q^6+(-2*j^2-4*j)*q^7+
(-15*j^2-13*j)*q^8-12*q^9+3*q^10,j^2*q^8,Unknown(),Unknown(),
j*q^16,(-3*j^2-4*j)*q^6-2*q^7-2*q^8+q^10,Unknown(),Unknown(),
Unknown(),-j^2*q^58+8*j^2*q^59-12*j^2*q^60+5*j^2*q^61,Unknown(),
Unknown(),2*q^86-12*q^87+15*q^88-6*q^89,Unknown(),Unknown(),-2*j^2*q^5+
(8*j^2+4*j)*q^6+(-14*j^2-12*j)*q^7-5*q^8-4*q^9-5*q^10+6*q^12,-
q^12,-4*j^2*q^141+(12*j^2-j)*q^142+(-6*j^2+2*j)*q^143-
3*j^2*q^144,2*j^2*q^142-12*j^2*q^143+15*j^2*q^144-6*j^2*q^145,
Unknown(),(-2*j^2-8*j)*q^9+3*q^10-3*q^11-q^12+q^15,-4*j*q^29+(j^2+
13*j)*q^30+(-2*j^2-8*j)*q^31-3*j*q^32,Unknown(),-j^2*q^57+
12*j^2*q^58-24*j^2*q^59+13*j^2*q^60,-q^59-j^2*q^60+j^2*q^61,
Unknown(),Unknown(),4*j^2*q^58-13*j^2*q^59+9*j^2*q^60,Unknown(),-
120*j*q^28,j^2*q^30+5*j*q^31-6*j*q^32,-12*j*q^28+56*j*q^29-
52*j*q^30,Unknown(),-5*j*q^29+23*j*q^30-22*j*q^31,3*j*q^28-
27*j*q^29+57*j*q^30-33*j*q^31,2*j*q^29-16*j*q^30+28*j*q^31-
14*j*q^32,Unknown(),(2*j^2-4*j)*q^30+16*j*q^31-10*j*q^32,
5*j*q^29-25*j*q^30+38*j*q^31-17*j*q^32,j*q^29-7*j*q^30+
(j^2+11*j)*q^31+(-2*j^2-4*j)*q^32-j*q^33,-6*q^30-24*j*q^31+
36*j*q^32-18*j*q^34,-3*j*q^28-4*j^2*q^29+12*j*q^30-
18*j*q^31-2*j^2*q^32+24*j*q^33-21*j*q^34,-q^31+(j^2-
8*j)*q^32+13*j*q^33-6*j*q^35,(6*j^2+14*j)*q^31-28*j*q^32+
24*j*q^33+8*j*q^34-10*j*q^35,j*q^28-2*j*q^29+4*q^30+
14*j*q^31-12*j*q^32+(-2*j^2-8*j)*q^33+25*j*q^34-12*j*q^35,
Unknown(),(j^2+4*j)*q^32+(j^2-10*j)*q^33+8*j*q^34+3*j*q^35-
3*j*q^36,-q^32-3*j*q^33+5*j*q^34-j*q^36,(j^2-3*j)*q^34+
2*j*q^35+2*j*q^36-j*q^38,40*j*q^28-80*j*q^29,2*q^33+(4*j^2+
8*j)*q^34+(-2*j^2-14*j)*q^35+5*j*q^36+4*j*q^37+5*j*q^38-
6*j*q^40,2*j^2*q^29+12*j*q^30-18*j*q^31,-5*j*q^28+35*j*q^29-
45*j*q^30,Unknown(),j*q^28-15*j*q^29+41*j*q^30-28*j*q^31,
(6*j^2-2*j)*q^37-3*j*q^38+3*j*q^39+j*q^40-j*q^43,Unknown(),
Unknown(),-4*q^86+13*q^87-9*q^88,Unknown(),q^24,j*q^29-12*j*q^30+
24*j*q^31-13*j*q^32,Unknown(),120*j^2*q^56,Unknown(),12*j^2*q^56-
56*j^2*q^57+52*j^2*q^58,5*j^2*q^57-23*j^2*q^58+22*j^2*q^59,-
3*j^2*q^56+27*j^2*q^57-57*j^2*q^58+33*j^2*q^59,-j^2*q^56+
6*j^2*q^57-8*j^2*q^58+(-7*j^2-2*j)*q^59+8*j^2*q^60,-
j^2*q^57+7*j^2*q^58+(-10*j^2+j)*q^59+(2*j^2-2*j)*q^60+
j^2*q^61,Unknown(),6*j*q^58+24*j^2*q^59-36*j^2*q^60+
18*j^2*q^62,(-8*j^2+6*j)*q^59+28*j^2*q^60-24*j^2*q^61-
8*j^2*q^62+10*j^2*q^63,j*q^59+(9*j^2+j)*q^60-13*j^2*q^61+
6*j^2*q^63,j*q^60+3*j^2*q^61-5*j^2*q^62+j^2*q^64,-
40*j^2*q^56+80*j^2*q^57,5*j^2*q^56-35*j^2*q^57+45*j^2*q^58,-
j^2*q^56+15*j^2*q^57-41*j^2*q^58+28*j^2*q^59,(8*j^2+
6*j)*q^65+3*j^2*q^66-3*j^2*q^67-j^2*q^68+j^2*q^71,
4*j^2*q^57+(-12*j^2+j)*q^58+(6*j^2-2*j)*q^59+3*j^2*q^60,
4*j*q^114-13*j*q^115+9*j*q^116,Unknown(),-120*q^84,16*q^27-24*q^28+
2*q^30-4*q^31-4*q^33+11*q^34+2*q^36-8*q^37+q^46,Unknown(),-5*q^85+23*q^86-
22*q^87,Unknown(),Unknown(),-6*j^2*q^86-24*q^87+36*q^88-18*q^90,Unknown(),-
j^2*q^87+(8*j^2+9*j)*q^88+13*q^89-6*q^91,-j^2*q^88-3*q^89+5*q^90-
q^92,-40*q^27-6*q^30+15*q^33-10*q^36+q^45,-5*q^84+35*q^85-45*q^86,Unknown(),-
4*q^85+(-13*j^2-12*j)*q^86+(8*j^2+6*j)*q^87-3*q^88,120*j*q^112,
Unknown(),12*j*q^112-56*j*q^113+52*j*q^114,2*j*q^30-12*j*q^31+
15*j*q^32-6*j*q^33,-40*j*q^112+80*j*q^113,5*j*q^112-
35*j*q^113+45*j*q^114,Unknown(),5*j*q^113-23*j*q^114+
22*j*q^115,-120*j^2*q^140,Unknown(),-12*j^2*q^140+56*j^2*q^141-
52*j^2*q^142,40*j^2*q^140-80*j^2*q^141,-5*j^2*q^140+
35*j^2*q^141-45*j^2*q^142,Unknown(),-5*j^2*q^141+23*j^2*q^142-
22*j^2*q^143];end;
  f57:=function(q,j)return [126,-45+81*q,6-39*q+42*q^2,16-58*q+52*q^2,-2+18*q-40*q^2+27*q^3,
6*q-23*q^2+19*q^3,-3*j^2*q+(15*j^2+12*j)*q^2+12*q^3,-6+30*q-57*q^2+
33*q^3,3+(12*j^2+15*j)*q-3*j*q^2+9*q^3,-1+(-6*j^2-8*j)*q+
(8*j^2+10*j)*q^2+(3*j^2+j)*q^3+6*q^4,-4*q+16*q^2-26*q^3+14*q^4,
4*q^2-11*q^3+8*q^4,-2*j^2*q^2+(5*j^2+3*j)*q^3+3*q^4,(-4*j^2-
5*j)*q+(12*j^2+16*j)*q^2+(-8*j^2-11*j)*q^3,-2*q+12*q^2-22*q^3+
12*q^4,j^2*q+(-8*j^2-4*j)*q^2+(13*j^2+12*j)*q^3+8*q^4,1-7*q+
26*q^2-36*q^3+17*q^4,-q^2+7*q^3-10*q^4+5*q^5,(j^2+2*j)*q+(-7*j^2-
9*j)*q^2+(11*j^2+14*j)*q^3+(-5*j^2-7*j)*q^4,-j^2*q^3-q^4+
q^5,Unknown(),(-3*j^2-4*j)*q^2+(8*j^2+10*j)*q^3+(-6*j^2-
8*j)*q^4-q^5,Unknown(),-3*q^2+10*q^3-14*q^4+6*q^5,2*q^3-5*q^4+3*q^5,
j^2*q^2+(-3*j^2-j)*q^3+(4*j^2+3*j)*q^4+2*q^5,9*j*q^2+24*q^3+
(36*j^2+45*j)*q^4+12*q^6,0,Unknown(),4*q^3+(12*j^2+14*j)*q^4+(-
3*j^2-5*j)*q^5+3*q^6,0,3+6*j^2*q+(15*j^2+12*j)*q^2+18*q^3+
3*j^2*q^4+(30*j^2+24*j)*q^5+15*q^6,Unknown(),Unknown(),-3*j*q^2+
(8*j^2+14*j)*q^3+(-28*j^2-34*j)*q^4+(24*j^2+27*j)*q^5-4*q^6+
8*q^7,(-2*j^2-j)*q^4+(4*j^2+3*j)*q^5+q^6+q^7,-1+(-4*j^2-
2*j)*q+(-2*j^2-4*j)*q^2+(15*j^2+14*j)*q^3+(-13*j^2-
12*j)*q^4+(-10*j^2-8*j)*q^5+(23*j^2+21*j)*q^6+10*q^7,(-j^2-
3*j)*q^3+(2*j^2+5*j)*q^4-j*q^5+q^7,-q^3+(-7*j^2-8*j)*q^4+
(9*j^2+11*j)*q^5+(-j^2-2*j)*q^6+2*q^7,j*q^3+(-8*j^2-
7*j)*q^4+(11*j^2+15*j)*q^5+3*q^7,Unknown(),(-9*j^2-7*j)*q^2+
(17*j^2+8*j)*q^3+(2*j^2+13*j)*q^4+(-24*j^2-30*j)*q^5+
(26*j^2+22*j)*q^6+6*q^7,Unknown(),Unknown(),-2*q^2+(-10*j^2-
7*j)*q^3+(12*j^2+4*j)*q^4+(4*j^2+14*j)*q^5+(-19*j^2-
24*j)*q^6-14*q^7+3*q^8,(-3*j^2-2*j)*q^5+(4*j^2+3*j)*q^6+q^8,-
4*j^2*q^137+11*j^2*q^138-8*j^2*q^139,-4*j*q^29+11*j*q^30-
8*j*q^31,(2*j^2+3*j)*q^4+(-10*j^2-11*j)*q^5+(7*j^2+
9*j)*q^6-q^7+2*q^8,Unknown(),Unknown(),(4*j^2+2*j)*q^2+(-13*j^2-
8*j)*q^3+9*j^2*q^4+(11*j^2+19*j)*q^5+(-25*j^2-27*j)*q^6+
(18*j^2+16*j)*q^7+4*q^8,Unknown(),Unknown(),Unknown(),j*q^29-
7*j*q^30+10*j*q^31-5*j*q^32,Unknown(),Unknown(),j*q^4+(-8*j^2-
12*j)*q^5+(18*j^2+22*j)*q^6+(-8*j^2-6*j)*q^7+(-10*j^2-
14*j)*q^8-12*q^9+3*q^10,0,Unknown(),Unknown(),0,(-2*j^2-3*j)*q^6+
(2*j^2+4*j)*q^7-q^8+q^10,Unknown(),Unknown(),Unknown(),-j^2*q^56+
7*j^2*q^57-10*j^2*q^58+5*j^2*q^59,Unknown(),Unknown(),3*q^83-10*q^84+
14*q^85-6*q^86,Unknown(),Unknown(),(2*j^2-2*j)*q^5+(4*j^2+
12*j)*q^6+(-14*j^2-18*j)*q^7+(10*j^2+8*j)*q^8-4*j^2*q^9+
(5*j^2+3*j)*q^10+3*q^12,0,(-5*j^2-j)*q^136+(16*j^2+
4*j)*q^137+(-11*j^2-3*j)*q^138,3*j^2*q^137-10*j^2*q^138+
14*j^2*q^139-6*j^2*q^140,Unknown(),(-2*j^2-5*j)*q^9-3*q^11+(-
j^2+2*j)*q^12,(j^2-4*j)*q^28+(-4*j^2+12*j)*q^29+(3*j^2-
8*j)*q^30,Unknown(),-2*j^2*q^55+12*j^2*q^56-22*j^2*q^57+
12*j^2*q^58,-j*q^57+j*q^58,Unknown(),Unknown(),4*j^2*q^56-
11*j^2*q^57+8*j^2*q^58,Unknown(),-126*j*q^27,2*q^29+(2*j^2+
5*j)*q^30-3*j*q^31,-16*j*q^27+58*j*q^28-52*j*q^29,Unknown(),-
6*j*q^28+23*j*q^29-19*j*q^30,6*j*q^27-30*j*q^28+57*j*q^29-
33*j*q^30,4*j*q^28-16*j*q^29+26*j*q^30-14*j*q^31,Unknown(),-
q^28+(-4*j^2-8*j)*q^29+(j^2+13*j)*q^30-8*j*q^31,-j*q^27+
7*j*q^28-26*j*q^29+36*j*q^30-17*j*q^31,(-j^2+j)*q^28+
(2*j^2-7*j)*q^29+(-3*j^2+11*j)*q^30+(2*j^2-5*j)*q^31,-
9*j^2*q^29-24*j*q^30+(-9*j^2+36*j)*q^31-12*j*q^33,-3*j*q^27-
6*q^28+(3*j^2+15*j)*q^29-18*j*q^30-3*q^31+(6*j^2+30*j)*q^32-
15*j*q^33,-j^2*q^30+(-j^2-8*j)*q^31+(-4*j^2+11*j)*q^32-
3*j*q^34,3*j^2*q^29+(-6*j^2+8*j)*q^30+(6*j^2-28*j)*q^31+(-
3*j^2+24*j)*q^32+4*j*q^33-8*j*q^34,j*q^27+(-2*j^2-
4*j)*q^28+(2*j^2-2*j)*q^29+(j^2+15*j)*q^30+(-j^2-
13*j)*q^31+(-2*j^2-10*j)*q^32+(2*j^2+23*j)*q^33-10*j*q^34,
Unknown(),(-j^2+2*j)*q^31+(j^2-10*j)*q^32+(-2*j^2+7*j)*q^33+
j*q^34-2*j*q^35,(-j^2-3*j)*q^32+(j^2+4*j)*q^33-j*q^35,
(j^2-2*j)*q^33+(-2*j^2+2*j)*q^34+j*q^35-j*q^37,45*j*q^27-
81*j*q^28,(4*j^2+2*j)*q^32+(-8*j^2+4*j)*q^33+(4*j^2-
14*j)*q^34+(2*j^2+10*j)*q^35+4*q^36+(2*j^2+5*j)*q^37-
3*j*q^39,3*q^28+(3*j^2+15*j)*q^29-12*j*q^30,-6*j*q^27+
39*j*q^28-42*j*q^29,Unknown(),2*j*q^27-18*j*q^28+40*j*q^29-
27*j*q^30,(3*j^2-2*j)*q^36+3*j*q^38+(-3*j^2-j)*q^39,
Unknown(),Unknown(),-4*q^83+11*q^84-8*q^85,Unknown(),0,2*j*q^28-
12*j*q^29+22*j*q^30-12*j*q^31,Unknown(),126*j^2*q^54,Unknown(),
16*j^2*q^54-58*j^2*q^55+52*j^2*q^56,6*j^2*q^55-23*j^2*q^56+
19*j^2*q^57,-6*j^2*q^54+30*j^2*q^55-57*j^2*q^56+33*j^2*q^57,-
j^2*q^54+(8*j^2+2*j)*q^55+(-10*j^2-2*j)*q^56+(-j^2+
2*j)*q^57+6*j^2*q^58,(-2*j^2-j)*q^55+(9*j^2+2*j)*q^56+(-
14*j^2-3*j)*q^57+(7*j^2+2*j)*q^58,Unknown(),9*q^56+24*j^2*q^57+
(-45*j^2-9*j)*q^58+12*j^2*q^60,-3*q^56+(-14*j^2-6*j)*q^57+
(34*j^2+6*j)*q^58+(-27*j^2-3*j)*q^59-4*j^2*q^60+8*j^2*q^61,
q^57+(7*j^2-j)*q^58+(-15*j^2-4*j)*q^59+3*j^2*q^61,(2*j^2-
j)*q^59+(-3*j^2+j)*q^60+j^2*q^62,-45*j^2*q^54+81*j^2*q^55,
6*j^2*q^54-39*j^2*q^55+42*j^2*q^56,-2*j^2*q^54+18*j^2*q^55-
40*j^2*q^56+27*j^2*q^57,(5*j^2+3*j)*q^63-3*j^2*q^65+(-2*j^2-
3*j)*q^66,(5*j^2+j)*q^55+(-16*j^2-4*j)*q^56+(11*j^2+
3*j)*q^57,4*j*q^110-11*j*q^111+8*j*q^112,Unknown(),-126*q^81,
4*q^27-6*q^28+12*q^30-24*q^31-4*q^33+11*q^34+q^36-4*q^37,Unknown(),-6*q^82+
23*q^83-19*q^84,Unknown(),Unknown(),-9*j*q^83-24*q^84+(-36*j^2-
45*j)*q^85-12*q^87,Unknown(),-j*q^84+(8*j^2+7*j)*q^85+(-11*j^2-
15*j)*q^86-3*q^88,(3*j^2+2*j)*q^86+(-4*j^2-3*j)*q^87-q^89,-
10*q^27-36*q^30+15*q^33-5*q^36,-6*q^81+39*q^82-42*q^83,Unknown(),(4*j^2+
5*j)*q^82+(-12*j^2-16*j)*q^83+(8*j^2+11*j)*q^84,126*j*q^108,
Unknown(),16*j*q^108-58*j*q^109+52*j*q^110,3*j*q^29-10*j*q^30+
14*j*q^31-6*j*q^32,-45*j*q^108+81*j*q^109,6*j*q^108-
39*j*q^109+42*j*q^110,Unknown(),6*j*q^109-23*j*q^110+
19*j*q^111,-126*j^2*q^135,Unknown(),-16*j^2*q^135+58*j^2*q^136-
52*j^2*q^137,45*j^2*q^135-81*j^2*q^136,-6*j^2*q^135+
39*j^2*q^136-42*j^2*q^137,Unknown(),-6*j^2*q^136+23*j^2*q^137-
19*j^2*q^138];end;
  f61:=q->[140,-70+70*q,22-48*q+22*q^2,36-68*q+36*q^2,-12+
34*q-34*q^2+12*q^3,-5+17*q-17*q^2+5*q^3,9*q-9*q^2,-19+51*q-51*q^2+19*q^3,4-
9*q+9*q^2-4*q^3,-2+6*q-10*q^2+6*q^3-2*q^4,4-16*q+20*q^2-16*q^3+4*q^4,1-4*q+
6*q^2-4*q^3+q^4,2*q^2,-2+11*q-16*q^2+11*q^3-2*q^4,3-11*q+16*q^2-11*q^3+3*q^4,-
5*q+8*q^2-5*q^3,7-22*q+34*q^2-22*q^3+7*q^4,-1+2*q-5*q^2+5*q^3-2*q^4+q^5,1-7*q+
13*q^2-13*q^3+7*q^4-q^5,0,Unknown(),1-3*q+8*q^2-8*q^3+3*q^4-q^5,Unknown(),-1+
5*q-8*q^2+8*q^3-5*q^4+q^5,q-q^2+q^3-q^4,-q^2+q^3,-27*q^2+32*q^3-27*q^4,0,
Unknown(),-5*q^2+8*q^3-5*q^4,0,4-18*q-9*q^2+24*q^3-9*q^4-18*q^5+4*q^6,
Unknown(),Unknown(),15*q^2-28*q^3+28*q^4-15*q^5,-q^3+q^4,-2+12*q-4*q^2-17*q^3+
17*q^4+4*q^5-12*q^6+2*q^7,q-2*q^2+4*q^3-4*q^4+2*q^5-q^6,3*q^2-6*q^3+6*q^4-
3*q^5,3*q^2-6*q^3+6*q^4-3*q^5,Unknown(),-2+10*q-7*q^2+7*q^5-10*q^6+2*q^7,
Unknown(),Unknown(),1-4*q+4*q^2+3*q^3-6*q^4+3*q^5+4*q^6-4*q^7+q^8,q^3+q^5,-
q^105+4*q^106-6*q^107+4*q^108-q^109,-q^21+4*q^22-6*q^23+4*q^24-q^25,-2*q^2+
4*q^3-6*q^4+4*q^5-2*q^6,Unknown(),Unknown(),1-7*q+9*q^2-3*q^3-2*q^4-3*q^5+
9*q^6-7*q^7+q^8,Unknown(),Unknown(),Unknown(),q^21-2*q^22+5*q^23-5*q^24+
2*q^25-q^26,Unknown(),Unknown(),1-2*q+q^2+6*q^3-14*q^4+20*q^5-14*q^6+6*q^7+
q^8-2*q^9+q^10,0,Unknown(),Unknown(),0,2*q^4+2*q^6,Unknown(),Unknown(),
Unknown(),-q^42+2*q^43-5*q^44+5*q^45-2*q^46+q^47,Unknown(),Unknown(),q^63-
5*q^64+8*q^65-8*q^66+5*q^67-q^68,Unknown(),Unknown(),6*q^3-5*q^4+14*q^5-
16*q^6+14*q^7-5*q^8+6*q^9,0,2*q^105-11*q^106+16*q^107-11*q^108+2*q^109,q^105-
5*q^106+8*q^107-8*q^108+5*q^109-q^110,Unknown(),-3*q^5+3*q^10,2*q^21-11*q^22+
16*q^23-11*q^24+2*q^25,Unknown(),3*q^42-11*q^43+16*q^44-11*q^45+3*q^46,0,
Unknown(),Unknown(),q^42-4*q^43+6*q^44-4*q^45+q^46,Unknown(),-140*q^21,-
2*q^23,-36*q^21+68*q^22-36*q^23,Unknown(),5*q^21-17*q^22+17*q^23-5*q^24,
19*q^21-51*q^22+51*q^23-19*q^24,-4*q^21+16*q^22-20*q^23+16*q^24-4*q^25,
Unknown(),5*q^22-8*q^23+5*q^24,-7*q^21+22*q^22-34*q^23+22*q^24-7*q^25,-q^21+
7*q^22-13*q^23+13*q^24-7*q^25+q^26,27*q^23-32*q^24+27*q^25,-4*q^21+18*q^22+
9*q^23-24*q^24+9*q^25+18*q^26-4*q^27,-3*q^23+6*q^24-6*q^25+3*q^26,-15*q^23+
28*q^24-28*q^25+15*q^26,2*q^21-12*q^22+4*q^23+17*q^24-17*q^25-4*q^26+12*q^27-
2*q^28,Unknown(),2*q^23-4*q^24+6*q^25-4*q^26+2*q^27,-q^24-q^26,-2*q^25-2*q^27,
70*q^21-70*q^22,-6*q^24+5*q^25-14*q^26+16*q^27-14*q^28+5*q^29-6*q^30,-9*q^22+
9*q^23,-22*q^21+48*q^22-22*q^23,Unknown(),12*q^21-34*q^22+34*q^23-12*q^24,
3*q^26-3*q^31,Unknown(),Unknown(),-q^63+4*q^64-6*q^65+4*q^66-q^67,Unknown(),0,
-3*q^21+11*q^22-16*q^23+11*q^24-3*q^25,Unknown(),140*q^42,Unknown(),36*q^42-
68*q^43+36*q^44,-5*q^42+17*q^43-17*q^44+5*q^45,-19*q^42+51*q^43-51*q^44+
19*q^45,-2*q^42+6*q^43-10*q^44+6*q^45-2*q^46,q^42-7*q^43+13*q^44-13*q^45+
7*q^46-q^47,Unknown(),-27*q^44+32*q^45-27*q^46,15*q^44-28*q^45+28*q^46-
15*q^47,3*q^44-6*q^45+6*q^46-3*q^47,q^45+q^47,-70*q^42+70*q^43,22*q^42-
48*q^43+22*q^44,-12*q^42+34*q^43-34*q^44+12*q^45,-3*q^47+3*q^52,-2*q^42+
11*q^43-16*q^44+11*q^45-2*q^46,q^84-4*q^85+6*q^86-4*q^87+q^88,Unknown(),-
140*q^63,-4*q^15+2*q^16+2*q^30-4*q^31,Unknown(),5*q^63-17*q^64+17*q^65-5*q^66,
Unknown(),Unknown(),27*q^65-32*q^66+27*q^67,Unknown(),-3*q^65+6*q^66-6*q^67+
3*q^68,-q^66-q^68,6*q^15-6*q^30,-22*q^63+48*q^64-22*q^65,Unknown(),2*q^63-
11*q^64+16*q^65-11*q^66+2*q^67,140*q^84,Unknown(),36*q^84-68*q^85+36*q^86,
q^21-5*q^22+8*q^23-8*q^24+5*q^25-q^26,-70*q^84+70*q^85,22*q^84-48*q^85+
22*q^86,Unknown(),-5*q^84+17*q^85-17*q^86+5*q^87,-140*q^105,Unknown(),-
36*q^105+68*q^106-36*q^107,70*q^105-70*q^106,-22*q^105+48*q^106-22*q^107,
Unknown(),5*q^105-17*q^106+17*q^107-5*q^108];
  f62:=q->[140,-80+60*q,32-48*q+12*q^2,48-
64*q+28*q^2,-21+38*q-26*q^2+7*q^3,-11+21*q-11*q^2+q^3,-2+12*q-3*q^2,-30+54*q-
42*q^2+14*q^3,4-3*q+12*q^2-6*q^3,-1+4*q-10*q^2+7*q^3-3*q^4,11-20*q+19*q^2-
8*q^3+3*q^4,4-7*q+4*q^2-q^3,-q,-5+12*q-15*q^2+8*q^3-q^4,8-16*q+13*q^2-6*q^3+
q^4,2-8*q+5*q^2-2*q^3,14-30*q+28*q^2-16*q^3+4*q^4,-3+6*q-4*q^2+2*q^3-q^4,3-
9*q+14*q^2-10*q^3+4*q^4-q^5,0,Unknown(),2-7*q+8*q^2-4*q^3+q^4,Unknown(),-5+
9*q-8*q^2+5*q^3-2*q^4+q^5,-2+2*q-q^2,q,2-36*q^2+48*q^3-9*q^4,0,Unknown(),q-
10*q^2+10*q^3-q^4,0,8-24*q-3*q^2+36*q^3-12*q^4-6*q^5+6*q^6,Unknown(),
Unknown(),-2+24*q^2-36*q^3+27*q^4-6*q^5,q^2,-5+19*q-7*q^2-20*q^3+26*q^4-2*q^5-
7*q^6+3*q^7,2*q-3*q^2+4*q^3-3*q^4+q^5,-q+7*q^2-8*q^3+5*q^4-q^5,6*q^2-12*q^3+
4*q^4,Unknown(),-5+20*q-24*q^2-2*q^3+16*q^4-6*q^5-2*q^6+q^7,Unknown(),
Unknown(),2-12*q+17*q^2-2*q^3-18*q^4+15*q^5-3*q^6,-q^2,4*q^90-7*q^91+4*q^92-
q^93,4*q^18-7*q^19+4*q^20-q^21,-5*q^2+8*q^3-6*q^4+3*q^5,Unknown(),Unknown(),3-
16*q+23*q^2-8*q^3-13*q^4+12*q^5-2*q^7+q^8,Unknown(),Unknown(),Unknown(),-
3*q^18+6*q^19-4*q^20+2*q^21-q^22,Unknown(),Unknown(),2-8*q+7*q^2+8*q^3-22*q^4+
22*q^5-12*q^6+4*q^7-q^8,0,Unknown(),Unknown(),0,-2*q^3+4*q^4-2*q^5,Unknown(),
Unknown(),Unknown(),-3*q^36+6*q^37-4*q^38+2*q^39-q^40,Unknown(),Unknown(),-
5*q^54+9*q^55-8*q^56+5*q^57-2*q^58+q^59,Unknown(),Unknown(),-q^2+6*q^3-10*q^4+
14*q^5-10*q^6-2*q^7-q^8,0,-5*q^90+12*q^91-15*q^92+8*q^93-q^94,-5*q^90+9*q^91-
8*q^92+5*q^93-2*q^94+q^95,Unknown(),q^6+6*q^7,-5*q^18+12*q^19-15*q^20+8*q^21-
q^22,Unknown(),8*q^36-16*q^37+13*q^38-6*q^39+q^40,q^38,Unknown(),Unknown(),
4*q^36-7*q^37+4*q^38-q^39,Unknown(),140*q^18,-q^19,48*q^18-64*q^19+28*q^20,
Unknown(),-11*q^18+21*q^19-11*q^20+q^21,-30*q^18+54*q^19-42*q^20+14*q^21,
11*q^18-20*q^19+19*q^20-8*q^21+3*q^22,Unknown(),2*q^18-8*q^19+5*q^20-2*q^21,
14*q^18-30*q^19+28*q^20-16*q^21+4*q^22,3*q^18-9*q^19+14*q^20-10*q^21+4*q^22-
q^23,2*q^18-36*q^20+48*q^21-9*q^22,8*q^18-24*q^19-3*q^20+36*q^21-12*q^22-
6*q^23+6*q^24,6*q^20-12*q^21+4*q^22,-2*q^18+24*q^20-36*q^21+27*q^22-6*q^23,-
5*q^18+19*q^19-7*q^20-20*q^21+26*q^22-2*q^23-7*q^24+3*q^25,Unknown(),-5*q^20+
8*q^21-6*q^22+3*q^23,-q^20,-2*q^21+4*q^22-2*q^23,-80*q^18+60*q^19,-q^20+
6*q^21-10*q^22+14*q^23-10*q^24-2*q^25-q^26,-2*q^18+12*q^19-3*q^20,32*q^18-
48*q^19+12*q^20,Unknown(),-21*q^18+38*q^19-26*q^20+7*q^21,q^24+6*q^25,
Unknown(),Unknown(),4*q^54-7*q^55+4*q^56-q^57,Unknown(),0,8*q^18-16*q^19+
13*q^20-6*q^21+q^22,Unknown(),140*q^36,Unknown(),48*q^36-64*q^37+28*q^38,-
11*q^36+21*q^37-11*q^38+q^39,-30*q^36+54*q^37-42*q^38+14*q^39,-q^36+4*q^37-
10*q^38+7*q^39-3*q^40,3*q^36-9*q^37+14*q^38-10*q^39+4*q^40-q^41,Unknown(),
2*q^36-36*q^38+48*q^39-9*q^40,-2*q^36+24*q^38-36*q^39+27*q^40-6*q^41,6*q^38-
12*q^39+4*q^40,-q^38,-80*q^36+60*q^37,32*q^36-48*q^37+12*q^38,-21*q^36+
38*q^37-26*q^38+7*q^39,q^42+6*q^43,-5*q^36+12*q^37-15*q^38+8*q^39-q^40,4*q^72-
7*q^73+4*q^74-q^75,Unknown(),140*q^54,48*q^18-32*q^19-32*q^21+28*q^22,
Unknown(),-11*q^54+21*q^55-11*q^56+q^57,Unknown(),Unknown(),2*q^54-36*q^56+
48*q^57-9*q^58,Unknown(),6*q^56-12*q^57+4*q^58,-q^56,-80*q^18+60*q^21,32*q^54-
48*q^55+12*q^56,Unknown(),-5*q^54+12*q^55-15*q^56+8*q^57-q^58,140*q^72,
Unknown(),48*q^72-64*q^73+28*q^74,-5*q^18+9*q^19-8*q^20+5*q^21-2*q^22+q^23,-
80*q^72+60*q^73,32*q^72-48*q^73+12*q^74,Unknown(),-11*q^72+21*q^73-11*q^74+
q^75,140*q^90,Unknown(),48*q^90-64*q^91+28*q^92,-80*q^90+60*q^91,32*q^90-
48*q^91+12*q^92,Unknown(),-11*q^90+21*q^91-11*q^92+q^93];
  f64:=q->[189,-99+90*q,36-63*q+27*q^2,51-96*q+42*q^2,-18+51*q-
45*q^2+12*q^3,-9+27*q-21*q^2+6*q^3,-9+9*q-9*q^2,-27+72*q-72*q^2+18*q^3,-9*q+
9*q^2-9*q^3,5*q-8*q^2+10*q^3-4*q^4,6-24*q+33*q^2-18*q^3+3*q^4,1-8*q+10*q^2-
5*q^3+q^4,1-2*q+q^2,-3+12*q-17*q^2+13*q^3-5*q^4,5-17*q+25*q^2-14*q^3+2*q^4,5-
8*q+10*q^2-4*q^3,10-33*q+49*q^2-30*q^3+4*q^4,-1+4*q-8*q^2+9*q^3-3*q^4,1-8*q+
15*q^2-15*q^3+9*q^4-2*q^5,0,Unknown(),1-5*q+9*q^2-9*q^3+5*q^4-q^5,Unknown(),-
2+7*q-14*q^2+14*q^3-5*q^4,q-3*q^2+3*q^3-q^4,-1+q-q^2+q^3,9-27*q^2+72*q^3-
27*q^4,0,Unknown(),1+2*q-10*q^2+13*q^3-6*q^4,0,18-18*q-9*q^2+54*q^3-9*q^4-
18*q^5+9*q^6,Unknown(),Unknown(),-5+4*q+12*q^2-55*q^3+47*q^4-12*q^5,2*q^2-
3*q^3+q^4,-10+16*q-5*q^2-34*q^3+28*q^4+5*q^5-13*q^6+4*q^7,-q^2+3*q^3-4*q^4+
3*q^5-q^6,-1-q+6*q^2-12*q^3+10*q^4-2*q^5,-1+4*q^2-14*q^3+12*q^4-q^5,Unknown(),
-5+12*q-10*q^2-10*q^3+7*q^4+13*q^5-12*q^6+5*q^7,Unknown(),Unknown(),1-2*q+
2*q^2+5*q^3-7*q^4-q^5+5*q^6-4*q^7+q^8,3*q^3-3*q^4,q^100-8*q^101+10*q^102-
5*q^103+q^104,q^20-8*q^21+10*q^22-5*q^23+q^24,1-2*q^2+9*q^3-14*q^4+6*q^5,
Unknown(),Unknown(),3-8*q+10*q^2+2*q^3-7*q^4-7*q^5+12*q^6-7*q^7+2*q^8,
Unknown(),Unknown(),Unknown(),-q^20+4*q^21-8*q^22+9*q^23-3*q^24,Unknown(),
Unknown(),1-2*q-3*q^2+14*q^3-15*q^4+8*q^5-9*q^6+8*q^7-q^8-2*q^9+q^10,0,
Unknown(),Unknown(),0,2*q^4-4*q^5+2*q^6,Unknown(),Unknown(),Unknown(),-q^40+
4*q^41-8*q^42+9*q^43-3*q^44,Unknown(),Unknown(),-2*q^60+7*q^61-14*q^62+
14*q^63-5*q^64,Unknown(),Unknown(),1-2*q^2-4*q^3+6*q^4+8*q^5-17*q^6+12*q^7-
6*q^8+2*q^9,0,-3*q^100+12*q^101-17*q^102+13*q^103-5*q^104,-2*q^100+7*q^101-
14*q^102+14*q^103-5*q^104,Unknown(),-6*q^5+9*q^7-12*q^8,-3*q^20+12*q^21-
17*q^22+13*q^23-5*q^24,Unknown(),5*q^40-17*q^41+25*q^42-14*q^43+2*q^44,0,
Unknown(),Unknown(),q^40-8*q^41+10*q^42-5*q^43+q^44,Unknown(),189*q^20,q^20-
2*q^21+q^22,51*q^20-96*q^21+42*q^22,Unknown(),-9*q^20+27*q^21-21*q^22+6*q^23,-
27*q^20+72*q^21-72*q^22+18*q^23,6*q^20-24*q^21+33*q^22-18*q^23+3*q^24,
Unknown(),5*q^20-8*q^21+10*q^22-4*q^23,10*q^20-33*q^21+49*q^22-30*q^23+4*q^24,
q^20-8*q^21+15*q^22-15*q^23+9*q^24-2*q^25,9*q^20-27*q^22+72*q^23-27*q^24,
18*q^20-18*q^21-9*q^22+54*q^23-9*q^24-18*q^25+9*q^26,-q^20+4*q^22-14*q^23+
12*q^24-q^25,-5*q^20+4*q^21+12*q^22-55*q^23+47*q^24-12*q^25,-10*q^20+16*q^21-
5*q^22-34*q^23+28*q^24+5*q^25-13*q^26+4*q^27,Unknown(),q^20-2*q^22+9*q^23-
14*q^24+6*q^25,3*q^23-3*q^24,2*q^24-4*q^25+2*q^26,-99*q^20+90*q^21,q^20-
2*q^22-4*q^23+6*q^24+8*q^25-17*q^26+12*q^27-6*q^28+2*q^29,-9*q^20+9*q^21-
9*q^22,36*q^20-63*q^21+27*q^22,Unknown(),-18*q^20+51*q^21-45*q^22+12*q^23,-
6*q^25+9*q^27-12*q^28,Unknown(),Unknown(),q^60-8*q^61+10*q^62-5*q^63+q^64,
Unknown(),0,5*q^20-17*q^21+25*q^22-14*q^23+2*q^24,Unknown(),189*q^40,
Unknown(),51*q^40-96*q^41+42*q^42,-9*q^40+27*q^41-21*q^42+6*q^43,-27*q^40+
72*q^41-72*q^42+18*q^43,5*q^41-8*q^42+10*q^43-4*q^44,q^40-8*q^41+15*q^42-
15*q^43+9*q^44-2*q^45,Unknown(),9*q^40-27*q^42+72*q^43-27*q^44,-5*q^40+4*q^41+
12*q^42-55*q^43+47*q^44-12*q^45,-q^40+4*q^42-14*q^43+12*q^44-q^45,3*q^43-
3*q^44,-99*q^40+90*q^41,36*q^40-63*q^41+27*q^42,-18*q^40+51*q^41-45*q^42+
12*q^43,-6*q^45+9*q^47-12*q^48,-3*q^40+12*q^41-17*q^42+13*q^43-5*q^44,q^80-
8*q^81+10*q^82-5*q^83+q^84,Unknown(),189*q^60,16*q^15-8*q^16-48*q^21+42*q^22+
35*q^24-40*q^25,Unknown(),-9*q^60+27*q^61-21*q^62+6*q^63,Unknown(),Unknown(),
9*q^60-27*q^62+72*q^63-27*q^64,Unknown(),-q^60+4*q^62-14*q^63+12*q^64-q^65,
3*q^63-3*q^64,-24*q^15+90*q^21-75*q^24,36*q^60-63*q^61+27*q^62,Unknown(),-
3*q^60+12*q^61-17*q^62+13*q^63-5*q^64,189*q^80,Unknown(),51*q^80-96*q^81+
42*q^82,-2*q^20+7*q^21-14*q^22+14*q^23-5*q^24,-99*q^80+90*q^81,36*q^80-
63*q^81+27*q^82,Unknown(),-9*q^80+27*q^81-21*q^82+6*q^83,189*q^100,Unknown(),
51*q^100-96*q^101+42*q^102,-99*q^100+90*q^101,36*q^100-63*q^101+27*q^102,
Unknown(),-9*q^100+27*q^101-21*q^102+6*q^103];
  f66:=q->[210,-120+90*q,51-69*q+
21*q^2,68-104*q+38*q^2,-29+61*q-43*q^2+8*q^3,-17+34*q-18*q^2+3*q^3,-12+15*q-
6*q^2,-37+93*q-63*q^2+17*q^3,-3-6*q+15*q^2-9*q^3,3+4*q-10*q^2+12*q^3-4*q^4,13-
32*q+35*q^2-14*q^3+q^4,5-12*q+10*q^2-3*q^3,2-3*q+q^2,-4+15*q-20*q^2+12*q^3-
3*q^4,9-28*q+25*q^2-9*q^3+q^4,8-12*q+11*q^2-2*q^3,15-50*q+51*q^2-21*q^3+4*q^4,
-2+10*q-12*q^2+5*q^3-q^4,2-10*q+18*q^2-16*q^3+7*q^4-q^5,-1,Unknown(),1-9*q+
12*q^2-8*q^3+3*q^4,Unknown(),-4+14*q-19*q^2+10*q^3-2*q^4,-1+4*q-4*q^2+2*q^3,-
1+3*q-2*q^2,12-45*q^2+72*q^3-18*q^4,0,Unknown(),2+3*q-16*q^2+13*q^3-3*q^4,0,
21-30*q-6*q^2+54*q^3-15*q^4-12*q^5+9*q^6,Unknown(),Unknown(),-8+4*q+24*q^2-
61*q^3+44*q^4-6*q^5,-1+3*q^2-3*q^3+q^4,-13+24*q-10*q^2-32*q^3+32*q^4+q^5-
9*q^6+4*q^7,-1+q-2*q^2+4*q^3-4*q^4+2*q^5,-1-q+10*q^2-14*q^3+8*q^4-q^5,-2+
9*q^2-18*q^3+8*q^4,Unknown(),-8+24*q-27*q^2-3*q^3+14*q^4-6*q^6+3*q^7,
Unknown(),Unknown(),3-10*q+15*q^2-4*q^3-9*q^4+7*q^5-2*q^6,1-q^2+3*q^3-3*q^4,
5*q^90-12*q^91+10*q^92-3*q^93,5*q^18-12*q^19+10*q^20-3*q^21,1-q-5*q^2+14*q^3-
13*q^4+3*q^5,Unknown(),Unknown(),4-16*q+25*q^2-13*q^3-7*q^4+7*q^5+2*q^6-4*q^7+
q^8,Unknown(),Unknown(),Unknown(),-2*q^18+10*q^19-12*q^20+5*q^21-q^22,
Unknown(),Unknown(),3-8*q+3*q^2+16*q^3-22*q^4+10*q^5-6*q^6+6*q^7-3*q^8,0,
Unknown(),Unknown(),0,1-2*q^3+4*q^4-4*q^5,Unknown(),Unknown(),Unknown(),-
2*q^36+10*q^37-12*q^38+5*q^39-q^40,Unknown(),Unknown(),-4*q^54+14*q^55-
19*q^56+10*q^57-2*q^58,Unknown(),Unknown(),2-3*q^2+18*q^5-17*q^6+6*q^7-3*q^8,
0,-4*q^90+15*q^91-20*q^92+12*q^93-3*q^94,-4*q^90+14*q^91-19*q^92+10*q^93-
2*q^94,Unknown(),-3*q^5+6*q^7-6*q^8,-4*q^18+15*q^19-20*q^20+12*q^21-3*q^22,
Unknown(),9*q^36-28*q^37+25*q^38-9*q^39+q^40,0,Unknown(),Unknown(),5*q^36-
12*q^37+10*q^38-3*q^39,Unknown(),210*q^18,2*q^18-3*q^19+q^20,68*q^18-104*q^19+
38*q^20,Unknown(),-17*q^18+34*q^19-18*q^20+3*q^21,-37*q^18+93*q^19-63*q^20+
17*q^21,13*q^18-32*q^19+35*q^20-14*q^21+q^22,Unknown(),8*q^18-12*q^19+11*q^20-
2*q^21,15*q^18-50*q^19+51*q^20-21*q^21+4*q^22,2*q^18-10*q^19+18*q^20-16*q^21+
7*q^22-q^23,12*q^18-45*q^20+72*q^21-18*q^22,21*q^18-30*q^19-6*q^20+54*q^21-
15*q^22-12*q^23+9*q^24,-2*q^18+9*q^20-18*q^21+8*q^22,-8*q^18+4*q^19+24*q^20-
61*q^21+44*q^22-6*q^23,-13*q^18+24*q^19-10*q^20-32*q^21+32*q^22+q^23-9*q^24+
4*q^25,Unknown(),q^18-q^19-5*q^20+14*q^21-13*q^22+3*q^23,q^18-q^20+3*q^21-
3*q^22,q^18-2*q^21+4*q^22-4*q^23,-120*q^18+90*q^19,2*q^18-3*q^20+18*q^23-
17*q^24+6*q^25-3*q^26,-12*q^18+15*q^19-6*q^20,51*q^18-69*q^19+21*q^20,
Unknown(),-29*q^18+61*q^19-43*q^20+8*q^21,-3*q^23+6*q^25-6*q^26,Unknown(),
Unknown(),5*q^54-12*q^55+10*q^56-3*q^57,Unknown(),0,9*q^18-28*q^19+25*q^20-
9*q^21+q^22,Unknown(),210*q^36,Unknown(),68*q^36-104*q^37+38*q^38,-17*q^36+
34*q^37-18*q^38+3*q^39,-37*q^36+93*q^37-63*q^38+17*q^39,3*q^36+4*q^37-10*q^38+
12*q^39-4*q^40,2*q^36-10*q^37+18*q^38-16*q^39+7*q^40-q^41,Unknown(),12*q^36-
45*q^38+72*q^39-18*q^40,-8*q^36+4*q^37+24*q^38-61*q^39+44*q^40-6*q^41,-2*q^36+
9*q^38-18*q^39+8*q^40,q^36-q^38+3*q^39-3*q^40,-120*q^36+90*q^37,51*q^36-
69*q^37+21*q^38,-29*q^36+61*q^37-43*q^38+8*q^39,-3*q^41+6*q^43-6*q^44,-4*q^36+
15*q^37-20*q^38+12*q^39-3*q^40,5*q^72-12*q^73+10*q^74-3*q^75,Unknown(),
210*q^54,-4*q^15+2*q^16+45*q^20-68*q^21+28*q^22+7*q^24-8*q^25,Unknown(),-
17*q^54+34*q^55-18*q^56+3*q^57,Unknown(),Unknown(),12*q^54-45*q^56+72*q^57-
18*q^58,Unknown(),-2*q^54+9*q^56-18*q^57+8*q^58,q^54-q^56+3*q^57-3*q^58,
6*q^15-81*q^20+60*q^21-15*q^24,51*q^54-69*q^55+21*q^56,Unknown(),-4*q^54+
15*q^55-20*q^56+12*q^57-3*q^58,210*q^72,Unknown(),68*q^72-104*q^73+38*q^74,-
4*q^18+14*q^19-19*q^20+10*q^21-2*q^22,-120*q^72+90*q^73,51*q^72-69*q^73+
21*q^74,Unknown(),-17*q^72+34*q^73-18*q^74+3*q^75,210*q^90,Unknown(),68*q^90-
104*q^91+38*q^92,-120*q^90+90*q^91,51*q^90-69*q^91+21*q^92,Unknown(),-17*q^90+
34*q^91-18*q^92+3*q^93];
  f68:=function(q,j) return [210,-80+130*q,15-65*q+65*q^2,28-104*q+78*q^2,
  -4+35*q-69*q^2+37*q^3,-1+14*q-38*q^2+
27*q^3,(-3*j^2-6*j)*q+(20*j^2+18*j)*q^2+21*q^3,-9+57*q-99*q^2+
45*q^3,6+(18*j^2+20*j)*q+(-6*j^2-3*j)*q^2+15*q^3,-2+12*q-12*q^2+
(4*j^2+5*j)*q^3+7*q^4,-8*q+34*q^2-42*q^3+16*q^4,-q+10*q^2-18*q^3+9*q^4,
(-j^2-2*j)*q^2+(7*j^2+6*j)*q^3+5*q^4,-1+(-9*j^2-10*j)*q-
22*q^2+(-15*j^2-12*j)*q^3,-5*q+25*q^2-36*q^3+14*q^4,2*j*q+(-
11*j^2-12*j)*q^2+(22*j^2+20*j)*q^3+11*q^4,1-14*q+51*q^2-59*q^3+
20*q^4,-4*q^2+15*q^3-15*q^4+4*q^5,-4*q+15*q^2+(19*j^2+18*j)*q^3+(-
8*j^2-7*j)*q^4-q^5,q^3+(2*j^2+j)*q^4+q^5,Unknown(),-q+8*q^2-
14*q^3+(-10*j^2-9*j)*q^4-2*q^5,Unknown(),-8*q^2+22*q^3-20*q^4+5*q^5,-
q^2+6*q^3-7*q^4+2*q^5,j*q^2+4*q^3+(7*j^2+6*j)*q^4+2*q^5,(18*j^2+
9*j)*q^2+48*q^3+(54*j^2+60*j)*q^4+21*q^6,0,Unknown(),-q^2+10*q^3+
(18*j^2+19*j)*q^4+(-6*j^2-7*j)*q^5+5*q^6,0,6+(6*j^2+12*j)*q+
(20*j^2+18*j)*q^2+36*q^3+(3*j^2+6*j)*q^4+(40*j^2+36*j)*q^5+
27*q^6,Unknown(),Unknown(),-6*j^2*q^2+(28*j^2+25*j)*q^3+56*q^4+
(30*j^2+36*j)*q^5-10*q^6+11*q^7,(-3*j^2-4*j)*q^4+(5*j^2+
6*j)*q^5+(-j^2-2*j)*q^6+q^7,-2+(-4*j^2-8*j)*q-2*j^2*q^2+
(24*j^2+22*j)*q^3+(-24*j^2-26*j)*q^4+(-13*j^2-12*j)*q^5+
(36*j^2+32*j)*q^6+15*q^7,-q^2+(-5*j^2-4*j)*q^3+(5*j^2+
4*j)*q^4+(-j^2+j)*q^5-j*q^6+q^7,-4*q^3+15*q^4+(13*j^2+
14*j)*q^5-j*q^6+2*q^7,(5*j^2+3*j)*q^3+(-14*j^2-16*j)*q^4+
(16*j^2+18*j)*q^5+5*q^7,Unknown(),-1+2*q+(-7*j^2-5*j)*q^2+
(12*j^2+13*j)*q^3+(12*j^2+7*j)*q^4+(-38*j^2-32*j)*q^5+
(32*j^2+30*j)*q^6+10*q^7,Unknown(),Unknown(),(j^2+2*j)*q^2+(-
6*j^2-7*j)*q^3+(j^2+3*j)*q^4+(16*j^2+13*j)*q^5+(-25*j^2-
23*j)*q^6+(16*j^2+14*j)*q^7+4*q^8,-q^4+(-5*j^2-6*j)*q^5+
(3*j^2+5*j)*q^6+q^8,-j*q^131+10*j*q^132-18*j*q^133+
9*j*q^134,-j^2*q^27+10*j^2*q^28-18*j^2*q^29+9*j^2*q^30,-
j^2*q^3-9*q^4+(-17*j^2-18*j)*q^5+(8*j^2+10*j)*q^6-3*q^7+2*q^8,
Unknown(),Unknown(),-q-2*q^2+(-8*j^2-9*j)*q^3+3*j*q^4+(23*j^2+
19*j)*q^5+(-34*j^2-32*j)*q^6+(23*j^2+21*j)*q^7+5*q^8,Unknown(),
Unknown(),Unknown(),-4*j^2*q^28+15*j^2*q^29-15*j^2*q^30+
4*j^2*q^31,Unknown(),Unknown(),-q^2-2*j*q^3-2*j^2*q^4+(-10*j^2-
8*j)*q^5+(26*j^2+20*j)*q^6+(-14*j^2-10*j)*q^7+(-11*j^2-
10*j)*q^8+(14*j^2+12*j)*q^9+4*q^10,0,Unknown(),Unknown(),0,-2*q^5+
5*q^6-2*q^7+(j^2+2*j)*q^8+q^10,Unknown(),Unknown(),Unknown(),-
4*j*q^54+15*j*q^55-15*j*q^56+4*j*q^57,Unknown(),Unknown(),-8*q^80+
22*q^81-20*q^82+5*q^83,Unknown(),Unknown(),-q^4+(-8*j^2-6*j)*q^5+
(18*j^2+14*j)*q^6+(-24*j^2-22*j)*q^7+(7*j^2+6*j)*q^8+
(4*j^2+6*j)*q^9+(7*j^2+6*j)*q^10+5*q^12,0,-j*q^130+(-j^2+
9*j)*q^131-22*j*q^132+(3*j^2+15*j)*q^133,-8*j*q^132+
22*j*q^133-20*j*q^134+5*j*q^135,Unknown(),(3*j^2-6*j)*q^9+
3*q^10-3*q^11-q^12,-j^2*q^26+(10*j^2+j)*q^27-22*j^2*q^28+
(12*j^2-3*j)*q^29,Unknown(),-5*j*q^53+25*j*q^54-36*j*q^55+
14*j*q^56,-j*q^56,Unknown(),Unknown(),-j*q^53+10*j*q^54-
18*j*q^55+9*j*q^56,Unknown(),210*j^2*q^26,(2*j^2+j)*q^28+(-
6*j^2+j)*q^29+5*j^2*q^30,28*j^2*q^26-104*j^2*q^27+
78*j^2*q^28,Unknown(),-j^2*q^26+14*j^2*q^27-38*j^2*q^28+
27*j^2*q^29,-9*j^2*q^26+57*j^2*q^27-99*j^2*q^28+45*j^2*q^29,-
8*j^2*q^27+34*j^2*q^28-42*j^2*q^29+16*j^2*q^30,Unknown(),2*q^27+
(12*j^2+j)*q^28+(-20*j^2+2*j)*q^29+11*j^2*q^30,j^2*q^26-
14*j^2*q^27+51*j^2*q^28-59*j^2*q^29+20*j^2*q^30,-4*j^2*q^27+
15*j^2*q^28+(-18*j^2+j)*q^29+(7*j^2-j)*q^30-j^2*q^31,(-
9*j^2+9*j)*q^28+48*j^2*q^29+(-60*j^2-6*j)*q^30+21*j^2*q^32,
6*j^2*q^26+(-12*j^2-6*j)*q^27+(-18*j^2+2*j)*q^28+
36*j^2*q^29+(-6*j^2-3*j)*q^30+(-36*j^2+4*j)*q^31+
27*j^2*q^32,(-3*j^2+2*j)*q^29+(16*j^2+2*j)*q^30+(-18*j^2-
2*j)*q^31+5*j^2*q^33,-6*j*q^28+(-25*j^2+3*j)*q^29+
56*j^2*q^30+(-36*j^2-6*j)*q^31-10*j^2*q^32+11*j^2*q^33,-
2*j^2*q^26+(8*j^2+4*j)*q^27-2*j*q^28+(-22*j^2+2*j)*q^29+
(26*j^2+2*j)*q^30+(12*j^2-j)*q^31+(-32*j^2+4*j)*q^32+
15*j^2*q^33,Unknown(),-j*q^29-9*j^2*q^30+(18*j^2+j)*q^31+(-
10*j^2-2*j)*q^32-3*j^2*q^33+2*j^2*q^34,-j^2*q^30+(6*j^2+
j)*q^31+(-5*j^2-2*j)*q^32+j^2*q^34,-2*j^2*q^31+5*j^2*q^32-
2*j^2*q^33+(-2*j^2-j)*q^34+j^2*q^36,-80*j^2*q^26+
130*j^2*q^27,-j^2*q^30+(6*j^2-2*j)*q^31+(-14*j^2+4*j)*q^32+
(22*j^2-2*j)*q^33+(-6*j^2+j)*q^34+(-6*j^2-2*j)*q^35+(-
6*j^2+j)*q^36+5*j^2*q^38,(6*j^2+3*j)*q^27+(-18*j^2+
2*j)*q^28+21*j^2*q^29,15*j^2*q^26-65*j^2*q^27+65*j^2*q^28,
Unknown(),-4*j^2*q^26+35*j^2*q^27-69*j^2*q^28+37*j^2*q^29,
(6*j^2+9*j)*q^35+3*j^2*q^36-3*j^2*q^37-j^2*q^38,Unknown(),
Unknown(),-q^79+10*q^80-18*q^81+9*q^82,Unknown(),0,-5*j^2*q^27+
25*j^2*q^28-36*j^2*q^29+14*j^2*q^30,Unknown(),210*j*q^52,
Unknown(),28*j*q^52-104*j*q^53+78*j*q^54,-j*q^52+14*j*q^53-
38*j*q^54+27*j*q^55,-9*j*q^52+57*j*q^53-99*j*q^54+45*j*q^55,
-2*j*q^52+12*j*q^53-12*j*q^54+(j^2-4*j)*q^55+7*j*q^56,-
4*j*q^53+15*j*q^54+(-j^2-19*j)*q^55+(j^2+8*j)*q^56-
j*q^57,Unknown(),(-9*j^2-18*j)*q^54+48*j*q^55+(6*j^2-
54*j)*q^56+21*j*q^58,-6*q^54+(-3*j^2-28*j)*q^55+56*j*q^56+
(6*j^2-30*j)*q^57-10*j*q^58+11*j*q^59,(-2*j^2-5*j)*q^55+(-
2*j^2+14*j)*q^56+(2*j^2-16*j)*q^57+5*j*q^59,-j*q^56+(-
j^2+5*j)*q^57+(2*j^2-3*j)*q^58+j*q^60,-80*j*q^52+
130*j*q^53,15*j*q^52-65*j*q^53+65*j*q^54,-4*j*q^52+
35*j*q^53-69*j*q^54+37*j*q^55,(-9*j^2-3*j)*q^61+3*j*q^62-
3*j*q^63-j*q^64,-j*q^52+(-j^2+9*j)*q^53-22*j*q^54+(3*j^2+
15*j)*q^55,-j^2*q^105+10*j^2*q^106-18*j^2*q^107+9*j^2*q^108,
Unknown(),210*q^78,-36*q^25+45*q^26+12*q^27-18*q^28+2*q^30-4*q^31-4*q^33+
11*q^34+2*q^36-8*q^37,Unknown(),-q^78+14*q^79-38*q^80+27*q^81,Unknown(),
Unknown(),(18*j^2+9*j)*q^80+48*q^81+(54*j^2+60*j)*q^82+21*q^84,
Unknown(),(5*j^2+3*j)*q^81+(-14*j^2-16*j)*q^82+(16*j^2+
18*j)*q^83+5*q^85,-q^82+(-5*j^2-6*j)*q^83+(3*j^2+5*j)*q^84+
q^86,81*q^25-30*q^27-6*q^30+15*q^33-10*q^36,15*q^78-65*q^79+65*q^80,Unknown(),
-q^78+(-9*j^2-10*j)*q^79-22*q^80+(-15*j^2-12*j)*q^81,
210*j^2*q^104,Unknown(),28*j^2*q^104-104*j^2*q^105+78*j^2*q^106,-
8*j^2*q^28+22*j^2*q^29-20*j^2*q^30+5*j^2*q^31,-80*j^2*q^104+
130*j^2*q^105,15*j^2*q^104-65*j^2*q^105+65*j^2*q^106,Unknown(),-
j^2*q^104+14*j^2*q^105-38*j^2*q^106+27*j^2*q^107,210*j*q^130,
Unknown(),28*j*q^130-104*j*q^131+78*j*q^132,-80*j*q^130+
130*j*q^131,15*j*q^130-65*j*q^131+65*j*q^132,Unknown(),-
j*q^130+14*j*q^131-38*j*q^132+27*j*q^133];end;
  f72:=function(q,j) return [210,-95+115*q,24-71*q+44*q^2,44-102*q+64*q^2,-12+44*q-
58*q^2+25*q^3,-3+21*q-30*q^2+14*q^3,-3+(-3*j^2-9*j)*q+(15*j^2+
17*j)*q^2+3*q^3,-21+69*q-84*q^2+36*q^3,6+(17*j^2+15*j)*q+(-9*j^2-
3*j)*q^2-6*q^3,-2+(-12*j^2-10*j)*q+(14*j^2+10*j)*q^2+(-
7*j^2-5*j)*q^3-3*q^4,4-16*q+32*q^2-30*q^3+10*q^4,-3*q+9*q^2-10*q^3+
4*q^4,j*q+(j^2-2*j)*q^2+(j^2+2*j)*q^3,-2+(-13*j^2-
12*j)*q+(24*j^2+19*j)*q^2+(-19*j^2-14*j)*q^3-7*q^4,2-11*q+
24*q^2-23*q^3+8*q^4,2+(2*j^2+6*j)*q+(-8*j^2-12*j)*q^2-10*q^3+
2*q^4,6-27*q+48*q^2-44*q^3+14*q^4,2*q-5*q^2+9*q^3-8*q^4+2*q^5,1+(7*j^2+
6*j)*q+(-19*j^2-15*j)*q^2+(21*j^2+17*j)*q^3+(-13*j^2-
11*j)*q^4-4*q^5,-j^2*q^2,Unknown(),(3*j^2+2*j)*q+(-10*j^2-
8*j)*q^2+(13*j^2+10*j)*q^3+(-9*j^2-8*j)*q^4-3*q^5,Unknown(),-1+
4*q-10*q^2+15*q^3-12*q^4+3*q^5,-q^2+3*q^3-3*q^4+q^5,-j*q+(-j^2+
j)*q^2-2*j*q^3-q^4,3+(27*j^2+9*j)*q^2+72*q^3+(51*j^2+
45*j)*q^4+3*q^6,0,Unknown(),-j^2*q+(5*j^2+4*j)*q^2+15*q^3+
(13*j^2+12*j)*q^4+(-2*j^2-j)*q^5,0,12+(6*j^2+18*j)*q+
(15*j^2+17*j)*q^2+54*q^3+(3*j^2+9*j)*q^4+(30*j^2+34*j)*q^5+
12*q^6,Unknown(),Unknown(),-2+q+(-15*j^2-3*j)*q^2+(44*j^2+
38*j)*q^3+(-64*j^2-58*j)*q^4-27*q^5-q^6+2*q^7,(j^2+2*j)*q^3+(-
j^2-3*j)*q^4+(j^2+2*j)*q^5,-6+(-8*j^2-16*j)*q-2*j^2*q^2-
33*q^3+(-31*j^2-35*j)*q^4+(-10*j^2-12*j)*q^5-23*q^6+7*q^7,
(2*j^2+j)*q^2+(-5*j^2-2*j)*q^3+(7*j^2+3*j)*q^4+(-5*j^2-
3*j)*q^5-2*q^6,j^2*q+(-3*j^2-2*j)*q^2-9*q^3+(-14*j^2-
13*j)*q^4+(8*j^2+7*j)*q^5+q^6,-2*j^2*q^2+(10*j^2+8*j)*q^3+(-
16*j^2-18*j)*q^4+(8*j^2+6*j)*q^5,Unknown(),-2+(-4*j^2-
6*j)*q+(-3*j^2-5*j)*q^2+(12*j^2+24*j)*q^3+(7*j^2-
9*j)*q^4+(-35*j^2-25*j)*q^5+(24*j^2+26*j)*q^6+7*q^7,Unknown(),
Unknown(),(2*j^2+6*j)*q^2+(-9*j^2-19*j)*q^3+(9*j^2+
21*j)*q^4+(10*j^2-j)*q^5+(-20*j^2-17*j)*q^6-12*q^7+3*q^8,
(j^2+3*j)*q^4+(-2*j^2-3*j)*q^5+j*q^6,3*j^2*q^116-
9*j^2*q^117+10*j^2*q^118-4*j^2*q^119,3*j*q^24-9*j*q^25+
10*j*q^26-4*j*q^27,2*j^2*q^2+(-5*j^2-4*j)*q^3-12*q^4+(-
13*j^2-12*j)*q^5-4*q^6,Unknown(),Unknown(),1+(3*j^2+5*j)*q-
2*j^2*q^2+(-6*j^2-15*j)*q^3+(4*j^2+18*j)*q^4+(18*j^2+
7*j)*q^5+(-29*j^2-27*j)*q^6-17*q^7+4*q^8,Unknown(),Unknown(),
Unknown(),-2*j*q^24+5*j*q^25-9*j*q^26+8*j*q^27-2*j*q^28,
Unknown(),Unknown(),(2*j^2+3*j)*q^2+(-6*j^2-10*j)*q^3+(10*j^2+
14*j)*q^4+(-22*j^2-18*j)*q^5+(28*j^2+21*j)*q^6+(-14*j^2-
12*j)*q^7+(-6*j^2-3*j)*q^8-8*q^9+3*q^10,0,Unknown(),Unknown(),0,(-
2*j^2-j)*q^4+(4*j^2+2*j)*q^5+4*q^6+2*j^2*q^7,Unknown(),
Unknown(),Unknown(),2*j^2*q^47-5*j^2*q^48+9*j^2*q^49-8*j^2*q^50+
2*j^2*q^51,Unknown(),Unknown(),q^69-4*q^70+10*q^71-15*q^72+12*q^73-3*q^74,
Unknown(),Unknown(),j*q^2+2*j^2*q^3+(-4*j^2-3*j)*q^4-6*j^2*q^5+
(23*j^2+11*j)*q^6+(-24*j^2-18*j)*q^7+(12*j^2+13*j)*q^8+(-
4*j^2-6*j)*q^9+(j^2+2*j)*q^10,0,2*j^2*q^115+(-12*j^2+
j)*q^116+(19*j^2-5*j)*q^117+(-14*j^2+5*j)*q^118+7*j^2*q^119,
j^2*q^115-4*j^2*q^116+10*j^2*q^117-15*j^2*q^118+12*j^2*q^119-
3*j^2*q^120,Unknown(),-9*j^2*q^7-12*q^8+(-7*j^2-4*j)*q^9,
2*j*q^23+(-j^2-13*j)*q^24+(5*j^2+24*j)*q^25+(-5*j^2-
19*j)*q^26+7*j*q^27,Unknown(),2*j^2*q^46-11*j^2*q^47+
24*j^2*q^48-23*j^2*q^49+8*j^2*q^50,j*q^49,Unknown(),Unknown(),-
3*j^2*q^47+9*j^2*q^48-10*j^2*q^49+4*j^2*q^50,Unknown(),-
210*j*q^23,-j^2*q^24+(3*j^2+j)*q^25+(-j^2+j)*q^26,-
44*j*q^23+102*j*q^24-64*j*q^25,Unknown(),3*j*q^23-21*j*q^24+
30*j*q^25-14*j*q^26,21*j*q^23-69*j*q^24+84*j*q^25-36*j*q^26,
-4*j*q^23+16*j*q^24-32*j*q^25+30*j*q^26-10*j*q^27,Unknown(),-
2*j*q^23+(-4*j^2+2*j)*q^24+(4*j^2-8*j)*q^25+10*j*q^26-
2*j*q^27,-6*j*q^23+27*j*q^24-48*j*q^25+44*j*q^26-14*j*q^27,-
j*q^23+(j^2+7*j)*q^24+(-4*j^2-19*j)*q^25+(4*j^2+
21*j)*q^26+(-2*j^2-13*j)*q^27+4*j*q^28,-3*j*q^23+(18*j^2+
27*j)*q^25-72*j*q^26+(6*j^2+51*j)*q^27-3*j*q^29,-12*j*q^23+
(-12*j^2+6*j)*q^24+(-2*j^2+15*j)*q^25-54*j*q^26+(-6*j^2+
3*j)*q^27+(-4*j^2+30*j)*q^28-12*j*q^29,2*q^25+(2*j^2+
10*j)*q^26+(2*j^2-16*j)*q^27+(2*j^2+8*j)*q^28,2*j*q^23-
j*q^24+(-12*j^2-15*j)*q^25+(6*j^2+44*j)*q^26+(-6*j^2-
64*j)*q^27+27*j*q^28+j*q^29-2*j*q^30,6*j*q^23+(8*j^2-
8*j)*q^24+2*q^25+33*j*q^26+(4*j^2-31*j)*q^27+(2*j^2-
10*j)*q^28+23*j*q^29-7*j*q^30,Unknown(),-2*q^25+(-j^2-
5*j)*q^26+12*j*q^27+(-j^2-13*j)*q^28+4*j*q^29,(-2*j^2+
j)*q^27+(j^2-2*j)*q^28-j^2*q^29,(-j^2-2*j)*q^27+(2*j^2+
4*j)*q^28-4*j*q^29-2*q^30,95*j*q^23-115*j*q^24,-j^2*q^25-
2*q^26+(-j^2-4*j)*q^27+6*q^28+(12*j^2+23*j)*q^29+(-6*j^2-
24*j)*q^30+(-j^2+12*j)*q^31+(2*j^2-4*j)*q^32+(-j^2+
j)*q^33,3*j*q^23+(6*j^2-3*j)*q^24+(-2*j^2+15*j)*q^25-
3*j*q^26,-24*j*q^23+71*j*q^24-44*j*q^25,Unknown(),12*j*q^23-
44*j*q^24+58*j*q^25-25*j*q^26,9*q^30+12*j*q^31+(-3*j^2-
7*j)*q^32,Unknown(),Unknown(),3*q^70-9*q^71+10*q^72-4*q^73,Unknown(),0,-
2*j*q^23+11*j*q^24-24*j*q^25+23*j*q^26-8*j*q^27,Unknown(),
210*j^2*q^46,Unknown(),44*j^2*q^46-102*j^2*q^47+64*j^2*q^48,-
3*j^2*q^46+21*j^2*q^47-30*j^2*q^48+14*j^2*q^49,-21*j^2*q^46+
69*j^2*q^47-84*j^2*q^48+36*j^2*q^49,-2*j^2*q^46+(10*j^2-
2*j)*q^47+(-10*j^2+4*j)*q^48+(5*j^2-2*j)*q^49-3*j^2*q^50,
j^2*q^46+(-6*j^2+j)*q^47+(15*j^2-4*j)*q^48+(-17*j^2+
4*j)*q^49+(11*j^2-2*j)*q^50-4*j^2*q^51,Unknown(),3*j^2*q^46+(-
9*j^2+18*j)*q^48+72*j^2*q^49+(-45*j^2+6*j)*q^50+3*j^2*q^52,-
2*j^2*q^46+j^2*q^47+(3*j^2-12*j)*q^48+(-38*j^2+6*j)*q^49+
(58*j^2-6*j)*q^50-27*j^2*q^51-j^2*q^52+2*j^2*q^53,-2*j*q^48+
(-8*j^2+2*j)*q^49+(18*j^2+2*j)*q^50+(-6*j^2+2*j)*q^51,(-
3*j^2-2*j)*q^50+(3*j^2+j)*q^51+q^52,-95*j^2*q^46+
115*j^2*q^47,24*j^2*q^46-71*j^2*q^47+44*j^2*q^48,-12*j^2*q^46+
44*j^2*q^47-58*j^2*q^48+25*j^2*q^49,-9*j*q^53-12*j^2*q^54+
(4*j^2-3*j)*q^55,-2*j^2*q^46+(12*j^2-j)*q^47+(-19*j^2+
5*j)*q^48+(14*j^2-5*j)*q^49-7*j^2*q^50,-3*j*q^93+9*j*q^94-
10*j*q^95+4*j*q^96,Unknown(),-210*q^69,-24*q^21+21*q^22+35*q^24-40*q^25-
4*q^27+6*q^28,Unknown(),3*q^69-21*q^70+30*q^71-14*q^72,Unknown(),Unknown(),-
3*q^69+(-27*j^2-9*j)*q^71-72*q^72+(-51*j^2-45*j)*q^73-3*q^75,
Unknown(),2*j^2*q^71+(-10*j^2-8*j)*q^72+(16*j^2+18*j)*q^73+(-
8*j^2-6*j)*q^74,(-j^2-3*j)*q^73+(2*j^2+3*j)*q^74-j*q^75,
45*q^21-75*q^24+10*q^27,-24*q^69+71*q^70-44*q^71,Unknown(),2*q^69+(13*j^2+
12*j)*q^70+(-24*j^2-19*j)*q^71+(19*j^2+14*j)*q^72+7*q^73,
210*j*q^92,Unknown(),44*j*q^92-102*j*q^93+64*j*q^94,j*q^23-
4*j*q^24+10*j*q^25-15*j*q^26+12*j*q^27-3*j*q^28,-95*j*q^92+
115*j*q^93,24*j*q^92-71*j*q^93+44*j*q^94,Unknown(),-3*j*q^92+
21*j*q^93-30*j*q^94+14*j*q^95,-210*j^2*q^115,Unknown(),-
44*j^2*q^115+102*j^2*q^116-64*j^2*q^117,95*j^2*q^115-
115*j^2*q^116,-24*j^2*q^115+71*j^2*q^116-44*j^2*q^117,Unknown(),
3*j^2*q^115-21*j^2*q^116+30*j^2*q^117-14*j^2*q^118];end;
  f76:=function(q,j) return [280,-160+120*q,70-90*q+30*q^2,88-144*q+48*q^2,
 -36+86*q-58*q^2+10*q^3,-24+
46*q-26*q^2+4*q^3,-18+(-18*j^2-24*j)*q+(12*j^2+6*j)*q^2+2*q^3,-46+
126*q-90*q^2+18*q^3,-8+(6*j^2+12*j)*q+(-24*j^2-18*j)*q^2-8*q^3,2+
(2*j^2-2*j)*q-14*q^2+(-16*j^2-12*j)*q^3-4*q^4,13-46*q+51*q^2-
18*q^3+q^4,6-18*q+16*q^2-4*q^3,3+(4*j^2+7*j)*q+(-3*j^2-2*j)*q^2+
j^2*q^3,-4+(-16*j^2-21*j)*q+(28*j^2+27*j)*q^2+(-17*j^2-
14*j)*q^3-3*q^4,11-38*q+38*q^2-12*q^3+q^4,8+(20*j^2+22*j)*q+16*q^2+
(6*j^2+4*j)*q^3,17-67*q+74*q^2-29*q^3+3*q^4,-2+13*q-19*q^2+9*q^3-q^4,3+
(10*j^2+13*j)*q+(-22*j^2-25*j)*q^2+(23*j^2+20*j)*q^3+(-
9*j^2-7*j)*q^4-q^5,q-q^2,Unknown(),3+(9*j^2+12*j)*q+(-15*j^2-
17*j)*q^2+(13*j^2+11*j)*q^3+(-4*j^2-3*j)*q^4,Unknown(),-3+18*q-
29*q^2+16*q^3-2*q^4,-1+5*q-8*q^2+3*q^3,-1+(-4*j^2-5*j)*q+(4*j^2+
5*j)*q^2+(-2*j^2-j)*q^3,18+(72*j^2+54*j)*q^2+80*q^3+(18*j^2+
36*j)*q^4+2*q^6,0,Unknown(),3+(-7*j^2-4*j)*q+(21*j^2+18*j)*q^2+
16*q^3+(4*j^2+5*j)*q^4-j*q^5,0,28+(36*j^2+48*j)*q+(12*j^2+
6*j)*q^2+60*q^3+(18*j^2+24*j)*q^4+(24*j^2+12*j)*q^5+12*q^6,
Unknown(),Unknown(),-8+10*q+(-36*j^2-30*j)*q^2+(84*j^2+72*j)*q^3+
(-44*j^2-56*j)*q^4+(6*j^2+12*j)*q^5-2*q^6,-q+(-4*j^2-
5*j)*q^2+(4*j^2+5*j)*q^3+(-2*j^2-j)*q^4,-14+(-34*j^2-
38*j)*q+(8*j^2+20*j)*q^2+(40*j^2+38*j)*q^3+(-34*j^2-
36*j)*q^4+(-8*j^2+4*j)*q^5+(16*j^2+12*j)*q^6+4*q^7,(j^2+
2*j)*q^2+(-5*j^2-6*j)*q^3+(6*j^2+5*j)*q^4+2*q^5,-1+j^2*q+(-
14*j^2-11*j)*q^2+(21*j^2+19*j)*q^3+(-9*j^2-10*j)*q^4+
(j^2+2*j)*q^5,-3+(-17*j^2-11*j)*q^2+(23*j^2+19*j)*q^3+(-
8*j^2-12*j)*q^4+2*j*q^5,Unknown(),-10+(-28*j^2-34*j)*q+
(30*j^2+40*j)*q^2+(-2*j^2-8*j)*q^3+(-11*j^2-13*j)*q^4+(-
3*j^2+3*j)*q^5+(8*j^2+6*j)*q^6+3*q^7,Unknown(),Unknown(),3-12*q+(-
15*j^2-22*j)*q^2+(6*j^2+13*j)*q^3+(4*j^2+3*j)*q^4+(-
4*j^2-8*j)*q^5+(2*j^2+4*j)*q^6,(2*j^2+3*j)*q^2+(-6*j^2-
5*j)*q^3+(3*j^2+4*j)*q^4,6*q^90-18*q^91+16*q^92-4*q^93,6*q^18-
18*q^19+16*q^20-4*q^21,1-2*q+(7*j^2+5*j)*q^2+(-23*j^2-17*j)*q^3-
16*q^4+(-2*j^2-6*j)*q^5,Unknown(),Unknown(),5+(19*j^2+21*j)*q+(-
28*j^2-38*j)*q^2+(15*j^2+25*j)*q^3+(3*j^2+j)*q^4+(-2*j^2-
8*j)*q^5-6*j^2*q^6-4*q^7+q^8,Unknown(),Unknown(),Unknown(),-2*q^18+
13*q^19-19*q^20+9*q^21-q^22,Unknown(),Unknown(),3-10*q+(-4*j^2-5*j)*q^2+
18*q^3+(25*j^2+27*j)*q^4+10*q^5+(5*j^2+3*j)*q^6+6*q^7+(3*j^2+
4*j)*q^8,0,Unknown(),Unknown(),0,-q^2+2*j^2*q^3+(-7*j^2-3*j)*q^4-
6*q^5-2*j*q^6,Unknown(),Unknown(),Unknown(),-2*q^36+13*q^37-19*q^38+9*q^39-
q^40,Unknown(),Unknown(),-3*q^54+18*q^55-29*q^56+16*q^57-2*q^58,Unknown(),
Unknown(),3+(4*j^2+7*j)*q^2+(8*j^2+2*j)*q^3+(2*j^2+5*j)*q^4+
(-26*j^2-28*j)*q^5+(24*j^2+28*j)*q^6+(-12*j^2-14*j)*q^7+
j^2*q^8+2*j*q^9+j^2*q^10,0,-4*q^90+(-16*j^2-21*j)*q^91+
(28*j^2+27*j)*q^92+(-17*j^2-14*j)*q^93-3*q^94,-3*q^90+18*q^91-
29*q^92+16*q^93-2*q^94,Unknown(),(-2*j^2+j)*q^3-3*q^5+(6*j^2-
3*j)*q^6-9*j^2*q^7+9*j*q^8,-4*q^18+(-16*j^2-21*j)*q^19+
(28*j^2+27*j)*q^20+(-17*j^2-14*j)*q^21-3*q^22,Unknown(),11*q^36-
38*q^37+38*q^38-12*q^39+q^40,-j*q^37,Unknown(),Unknown(),6*q^36-18*q^37+
16*q^38-4*q^39,Unknown(),280*q^18,3*q^18+(4*j^2+7*j)*q^19+(-3*j^2-
2*j)*q^20+j^2*q^21,88*q^18-144*q^19+48*q^20,Unknown(),-24*q^18+46*q^19-
26*q^20+4*q^21,-46*q^18+126*q^19-90*q^20+18*q^21,13*q^18-46*q^19+51*q^20-
18*q^21+q^22,Unknown(),8*q^18+(20*j^2+22*j)*q^19+16*q^20+(6*j^2+
4*j)*q^21,17*q^18-67*q^19+74*q^20-29*q^21+3*q^22,3*q^18+(10*j^2+
13*j)*q^19+(-22*j^2-25*j)*q^20+(23*j^2+20*j)*q^21+(-9*j^2-
7*j)*q^22-q^23,18*q^18+(72*j^2+54*j)*q^20+80*q^21+(18*j^2+
36*j)*q^22+2*q^24,28*q^18+(36*j^2+48*j)*q^19+(12*j^2+6*j)*q^20+
60*q^21+(18*j^2+24*j)*q^22+(24*j^2+12*j)*q^23+12*q^24,-3*q^18+(-
17*j^2-11*j)*q^20+(23*j^2+19*j)*q^21+(-8*j^2-12*j)*q^22+
2*j*q^23,-8*q^18+10*q^19+(-36*j^2-30*j)*q^20+(84*j^2+
72*j)*q^21+(-44*j^2-56*j)*q^22+(6*j^2+12*j)*q^23-2*q^24,-
14*q^18+(-34*j^2-38*j)*q^19+(8*j^2+20*j)*q^20+(40*j^2+
38*j)*q^21+(-34*j^2-36*j)*q^22+(-8*j^2+4*j)*q^23+(16*j^2+
12*j)*q^24+4*q^25,Unknown(),q^18-2*q^19+(7*j^2+5*j)*q^20+(-23*j^2-
17*j)*q^21-16*q^22+(-2*j^2-6*j)*q^23,(2*j^2+3*j)*q^20+(-
6*j^2-5*j)*q^21+(3*j^2+4*j)*q^22,-q^20+2*j^2*q^21+(-7*j^2-
3*j)*q^22-6*q^23-2*j*q^24,-160*q^18+120*q^19,3*q^18+(4*j^2+
7*j)*q^20+(8*j^2+2*j)*q^21+(2*j^2+5*j)*q^22+(-26*j^2-
28*j)*q^23+(24*j^2+28*j)*q^24+(-12*j^2-14*j)*q^25+j^2*q^26+
2*j*q^27+j^2*q^28,-18*q^18+(-18*j^2-24*j)*q^19+(12*j^2+
6*j)*q^20+2*q^21,70*q^18-90*q^19+30*q^20,Unknown(),-36*q^18+86*q^19-
58*q^20+10*q^21,(-2*j^2+j)*q^21-3*q^23+(6*j^2-3*j)*q^24-
9*j^2*q^25+9*j*q^26,Unknown(),Unknown(),6*q^54-18*q^55+16*q^56-4*q^57,
Unknown(),0,11*q^18-38*q^19+38*q^20-12*q^21+q^22,Unknown(),280*q^36,Unknown(),
88*q^36-144*q^37+48*q^38,-24*q^36+46*q^37-26*q^38+4*q^39,-46*q^36+126*q^37-
90*q^38+18*q^39,2*q^36+(2*j^2-2*j)*q^37-14*q^38+(-16*j^2-
12*j)*q^39-4*q^40,3*q^36+(10*j^2+13*j)*q^37+(-22*j^2-
25*j)*q^38+(23*j^2+20*j)*q^39+(-9*j^2-7*j)*q^40-q^41,Unknown(),
18*q^36+(72*j^2+54*j)*q^38+80*q^39+(18*j^2+36*j)*q^40+2*q^42,-
8*q^36+10*q^37+(-36*j^2-30*j)*q^38+(84*j^2+72*j)*q^39+(-44*j^2-
56*j)*q^40+(6*j^2+12*j)*q^41-2*q^42,-3*q^36+(-17*j^2-
11*j)*q^38+(23*j^2+19*j)*q^39+(-8*j^2-12*j)*q^40+2*j*q^41,
(2*j^2+3*j)*q^38+(-6*j^2-5*j)*q^39+(3*j^2+4*j)*q^40,-
160*q^36+120*q^37,70*q^36-90*q^37+30*q^38,-36*q^36+86*q^37-58*q^38+10*q^39,(-
2*j^2+j)*q^39-3*q^41+(6*j^2-3*j)*q^42-9*j^2*q^43+9*j*q^44,-
4*q^36+(-16*j^2-21*j)*q^37+(28*j^2+27*j)*q^38+(-17*j^2-
14*j)*q^39-3*q^40,6*q^72-18*q^73+16*q^74-4*q^75,Unknown(),280*q^54,-4*q^9+
q^10-4*q^15+2*q^16-18*q^18+12*q^19+45*q^20-60*q^21+21*q^22+21*q^24-24*q^25,
Unknown(),-24*q^54+46*q^55-26*q^56+4*q^57,Unknown(),Unknown(),18*q^54+
(72*j^2+54*j)*q^56+80*q^57+(18*j^2+36*j)*q^58+2*q^60,Unknown(),-
3*q^54+(-17*j^2-11*j)*q^56+(23*j^2+19*j)*q^57+(-8*j^2-
12*j)*q^58+2*j*q^59,(2*j^2+3*j)*q^56+(-6*j^2-5*j)*q^57+
(3*j^2+4*j)*q^58,5*q^9+6*q^15+30*q^18-81*q^20+45*q^21-45*q^24,70*q^54-
90*q^55+30*q^56,Unknown(),-4*q^54+(-16*j^2-21*j)*q^55+(28*j^2+
27*j)*q^56+(-17*j^2-14*j)*q^57-3*q^58,280*q^72,Unknown(),88*q^72-
144*q^73+48*q^74,-3*q^18+18*q^19-29*q^20+16*q^21-2*q^22,-160*q^72+120*q^73,
70*q^72-90*q^73+30*q^74,Unknown(),-24*q^72+46*q^73-26*q^74+4*q^75,280*q^90,
Unknown(),88*q^90-144*q^91+48*q^92,-160*q^90+120*q^91,70*q^90-90*q^91+30*q^92,
Unknown(),-24*q^90+46*q^91-26*q^92+4*q^93];end;
  f80:=q->[315,-195+120*q,96-99*q+21*q^2,119-152*q+
44*q^2,-57+101*q-51*q^2+7*q^3,-40+56*q-20*q^2+q^3,-27+30*q-6*q^2,-72+141*q-
87*q^2+15*q^3,-18-6*q+30*q^2-9*q^3,9-5*q-20*q^2+18*q^3-3*q^4,26-62*q+47*q^2-
12*q^3+q^4,14-26*q+13*q^2-q^3,6-9*q+3*q^2,-2+22*q-33*q^2+14*q^3-q^4,23-51*q+
35*q^2-8*q^3,15-30*q+16*q^2-2*q^3,34-84*q+73*q^2-23*q^3+2*q^4,-8+21*q-19*q^2+
6*q^3,2-14*q+28*q^2-22*q^3+6*q^4,-1+2*q-q^2,Unknown(),4-15*q+20*q^2-10*q^3+
q^4,Unknown(),-10+29*q-29*q^2+11*q^3-q^4,-4+10*q-7*q^2+q^3,-3+8*q-6*q^2+q^3,
27-90*q^2+72*q^3-18*q^4,0,Unknown(),6+9*q-28*q^2+13*q^3-q^4,0,36-60*q-6*q^2+
54*q^3-30*q^4-12*q^5+9*q^6,Unknown(),Unknown(),-15+12*q+54*q^2-84*q^3+36*q^4-
6*q^5,-1-2*q+8*q^2-6*q^3+q^4,-21+51*q-20*q^2-38*q^3+36*q^4-4*q^5-10*q^6+3*q^7,
-1+6*q^3-5*q^4,-3-2*q+21*q^2-19*q^3+6*q^4,-6+26*q^2-21*q^3+4*q^4,Unknown(),-
14+50*q-57*q^2+13*q^3+25*q^4-13*q^5-2*q^6+q^7,Unknown(),Unknown(),6-26*q+
39*q^2-15*q^3-19*q^4+21*q^5-6*q^6,1-6*q^2+8*q^3-3*q^4,14*q^80-26*q^81+13*q^82-
q^83,14*q^16-26*q^17+13*q^18-q^19,3-3*q-15*q^2+24*q^3-11*q^4+q^5,Unknown(),
Unknown(),8-36*q+54*q^2-29*q^3-9*q^4+16*q^5-4*q^6-q^7,Unknown(),Unknown(),
Unknown(),-8*q^16+21*q^17-19*q^18+6*q^19,Unknown(),Unknown(),6-22*q+19*q^2+
20*q^3-42*q^4+22*q^5-4*q^6+4*q^7-q^8,0,Unknown(),Unknown(),0,1-2*q^2-4*q^3+
7*q^4,Unknown(),Unknown(),Unknown(),-8*q^32+21*q^33-19*q^34+6*q^35,Unknown(),
Unknown(),-10*q^48+29*q^49-29*q^50+11*q^51-q^52,Unknown(),Unknown(),6-9*q^2-
2*q^3-16*q^4+34*q^5-25*q^6+4*q^7-q^8,0,-2*q^80+22*q^81-33*q^82+14*q^83-q^84,-
10*q^80+29*q^81-29*q^82+11*q^83-q^84,Unknown(),q^3+6*q^4-3*q^5-7*q^6,-2*q^16+
22*q^17-33*q^18+14*q^19-q^20,Unknown(),23*q^32-51*q^33+35*q^34-8*q^35,q^33-
q^34,Unknown(),Unknown(),14*q^32-26*q^33+13*q^34-q^35,Unknown(),315*q^16,
6*q^16-9*q^17+3*q^18,119*q^16-152*q^17+44*q^18,Unknown(),-40*q^16+56*q^17-
20*q^18+q^19,-72*q^16+141*q^17-87*q^18+15*q^19,26*q^16-62*q^17+47*q^18-
12*q^19+q^20,Unknown(),15*q^16-30*q^17+16*q^18-2*q^19,34*q^16-84*q^17+73*q^18-
23*q^19+2*q^20,2*q^16-14*q^17+28*q^18-22*q^19+6*q^20,27*q^16-90*q^18+72*q^19-
18*q^20,36*q^16-60*q^17-6*q^18+54*q^19-30*q^20-12*q^21+9*q^22,-6*q^16+26*q^18-
21*q^19+4*q^20,-15*q^16+12*q^17+54*q^18-84*q^19+36*q^20-6*q^21,-21*q^16+
51*q^17-20*q^18-38*q^19+36*q^20-4*q^21-10*q^22+3*q^23,Unknown(),3*q^16-3*q^17-
15*q^18+24*q^19-11*q^20+q^21,q^16-6*q^18+8*q^19-3*q^20,q^16-2*q^18-4*q^19+
7*q^20,-195*q^16+120*q^17,6*q^16-9*q^18-2*q^19-16*q^20+34*q^21-25*q^22+4*q^23-
q^24,-27*q^16+30*q^17-6*q^18,96*q^16-99*q^17+21*q^18,Unknown(),-57*q^16+
101*q^17-51*q^18+7*q^19,q^19+6*q^20-3*q^21-7*q^22,Unknown(),Unknown(),14*q^48-
26*q^49+13*q^50-q^51,Unknown(),0,23*q^16-51*q^17+35*q^18-8*q^19,Unknown(),
315*q^32,Unknown(),119*q^32-152*q^33+44*q^34,-40*q^32+56*q^33-20*q^34+q^35,-
72*q^32+141*q^33-87*q^34+15*q^35,9*q^32-5*q^33-20*q^34+18*q^35-3*q^36,2*q^32-
14*q^33+28*q^34-22*q^35+6*q^36,Unknown(),27*q^32-90*q^34+72*q^35-18*q^36,-
15*q^32+12*q^33+54*q^34-84*q^35+36*q^36-6*q^37,-6*q^32+26*q^34-21*q^35+4*q^36,
q^32-6*q^34+8*q^35-3*q^36,-195*q^32+120*q^33,96*q^32-99*q^33+21*q^34,-57*q^32+
101*q^33-51*q^34+7*q^35,q^35+6*q^36-3*q^37-7*q^38,-2*q^32+22*q^33-33*q^34+
14*q^35-q^36,14*q^64-26*q^65+13*q^66-q^67,Unknown(),315*q^48,-8*q^9+2*q^10+
22*q^12-8*q^13-4*q^15+2*q^16-12*q^18+8*q^19+45*q^20-36*q^21,Unknown(),-
40*q^48+56*q^49-20*q^50+q^51,Unknown(),Unknown(),27*q^48-90*q^50+72*q^51-
18*q^52,Unknown(),-6*q^48+26*q^50-21*q^51+4*q^52,q^48-6*q^50+8*q^51-3*q^52,
10*q^9-30*q^12+6*q^15+20*q^18-81*q^20,96*q^48-99*q^49+21*q^50,Unknown(),-
2*q^48+22*q^49-33*q^50+14*q^51-q^52,315*q^64,Unknown(),119*q^64-152*q^65+
44*q^66,-10*q^16+29*q^17-29*q^18+11*q^19-q^20,-195*q^64+120*q^65,96*q^64-
99*q^65+21*q^66,Unknown(),-40*q^64+56*q^65-20*q^66+q^67,315*q^80,Unknown(),
119*q^80-152*q^81+44*q^82,-195*q^80+120*q^81,96*q^80-99*q^81+21*q^82,
Unknown(),-40*q^80+56*q^81-20*q^82+q^83];
  f82:=q->[315,-165+150*q,57-108*q+42*q^2,89-152*q+
74*q^2,-33+80*q-72*q^2+22*q^3,-15+42*q-34*q^2+8*q^3,-3+21*q-15*q^2,-48+123*q-
105*q^2+39*q^3,9-15*q+21*q^2-12*q^3,-3+13*q-20*q^2+15*q^3-6*q^4,14-38*q+
47*q^2-30*q^3+7*q^4,4-11*q+13*q^2-7*q^3+q^4,-q+q^2,-7+25*q-35*q^2+22*q^3-
5*q^4,9-30*q+35*q^2-20*q^3+5*q^4,3-12*q+16*q^2-8*q^3,18-60*q+72*q^2-44*q^3+
13*q^4,-2+9*q-12*q^2+8*q^3-4*q^4+q^5,4-16*q+30*q^2-28*q^3+13*q^4-3*q^5,q^2,
Unknown(),2-10*q+19*q^2-15*q^3+6*q^4-q^5,Unknown(),-4+15*q-20*q^2+16*q^3-
8*q^4+2*q^5,-1+3*q-3*q^2+2*q^3-q^4,q-q^2,3-63*q^2+96*q^3-45*q^4,0,Unknown(),q-
15*q^2+24*q^3-8*q^4,0,15-42*q-15*q^2+72*q^3-21*q^4-30*q^5+12*q^6,Unknown(),
Unknown(),-3+36*q^2-75*q^3+69*q^4-24*q^5,q^2-2*q^3+q^4,-9+30*q-11*q^2-44*q^3+
48*q^4+5*q^5-22*q^6+6*q^7,2*q-6*q^2+8*q^3-8*q^4+5*q^5-q^6,-q+9*q^2-18*q^3+
15*q^4-5*q^5,8*q^2-21*q^3+16*q^4-3*q^5,Unknown(),-7+28*q-27*q^2-4*q^3+13*q^4+
8*q^5-16*q^6+5*q^7,Unknown(),Unknown(),2-12*q+16*q^2-17*q^4+11*q^5+3*q^6-
4*q^7+q^8,-q^2+q^3-q^4+q^5,4*q^100-11*q^101+13*q^102-7*q^103+q^104,4*q^20-
11*q^21+13*q^22-7*q^23+q^24,-5*q^2+15*q^3-16*q^4+10*q^5-2*q^6,Unknown(),
Unknown(),4-19*q+29*q^2-11*q^3-11*q^4+6*q^5+13*q^6-12*q^7+3*q^8,Unknown(),
Unknown(),Unknown(),-2*q^20+9*q^21-12*q^22+8*q^23-4*q^24+q^25,Unknown(),
Unknown(),2-8*q+4*q^2+14*q^3-33*q^4+38*q^5-27*q^6+12*q^7-2*q^8-2*q^9+q^10,0,
Unknown(),Unknown(),0,-2*q^3+5*q^4-6*q^5+2*q^6,Unknown(),Unknown(),Unknown(),-
2*q^40+9*q^41-12*q^42+8*q^43-4*q^44+q^45,Unknown(),Unknown(),-4*q^60+15*q^61-
20*q^62+16*q^63-8*q^64+2*q^65,Unknown(),Unknown(),-q^2+10*q^3-11*q^4+30*q^5-
28*q^6+20*q^7-8*q^8+6*q^9,0,-7*q^100+25*q^101-35*q^102+22*q^103-5*q^104,-
4*q^100+15*q^101-20*q^102+16*q^103-8*q^104+2*q^105,Unknown(),-3*q^5-2*q^6+
6*q^7+2*q^9,-7*q^20+25*q^21-35*q^22+22*q^23-5*q^24,Unknown(),9*q^40-30*q^41+
35*q^42-20*q^43+5*q^44,q^42-q^43,Unknown(),Unknown(),4*q^40-11*q^41+13*q^42-
7*q^43+q^44,Unknown(),315*q^20,-q^21+q^22,89*q^20-152*q^21+74*q^22,Unknown(),-
15*q^20+42*q^21-34*q^22+8*q^23,-48*q^20+123*q^21-105*q^22+39*q^23,14*q^20-
38*q^21+47*q^22-30*q^23+7*q^24,Unknown(),3*q^20-12*q^21+16*q^22-8*q^23,
18*q^20-60*q^21+72*q^22-44*q^23+13*q^24,4*q^20-16*q^21+30*q^22-28*q^23+
13*q^24-3*q^25,3*q^20-63*q^22+96*q^23-45*q^24,15*q^20-42*q^21-15*q^22+72*q^23-
21*q^24-30*q^25+12*q^26,8*q^22-21*q^23+16*q^24-3*q^25,-3*q^20+36*q^22-75*q^23+
69*q^24-24*q^25,-9*q^20+30*q^21-11*q^22-44*q^23+48*q^24+5*q^25-22*q^26+6*q^27,
Unknown(),-5*q^22+15*q^23-16*q^24+10*q^25-2*q^26,-q^22+q^23-q^24+q^25,-2*q^23+
5*q^24-6*q^25+2*q^26,-165*q^20+150*q^21,-q^22+10*q^23-11*q^24+30*q^25-28*q^26+
20*q^27-8*q^28+6*q^29,-3*q^20+21*q^21-15*q^22,57*q^20-108*q^21+42*q^22,
Unknown(),-33*q^20+80*q^21-72*q^22+22*q^23,-3*q^25-2*q^26+6*q^27+2*q^29,
Unknown(),Unknown(),4*q^60-11*q^61+13*q^62-7*q^63+q^64,Unknown(),0,9*q^20-
30*q^21+35*q^22-20*q^23+5*q^24,Unknown(),315*q^40,Unknown(),89*q^40-152*q^41+
74*q^42,-15*q^40+42*q^41-34*q^42+8*q^43,-48*q^40+123*q^41-105*q^42+39*q^43,-
3*q^40+13*q^41-20*q^42+15*q^43-6*q^44,4*q^40-16*q^41+30*q^42-28*q^43+13*q^44-
3*q^45,Unknown(),3*q^40-63*q^42+96*q^43-45*q^44,-3*q^40+36*q^42-75*q^43+
69*q^44-24*q^45,8*q^42-21*q^43+16*q^44-3*q^45,-q^42+q^43-q^44+q^45,-165*q^40+
150*q^41,57*q^40-108*q^41+42*q^42,-33*q^40+80*q^41-72*q^42+22*q^43,-3*q^45-
2*q^46+6*q^47+2*q^49,-7*q^40+25*q^41-35*q^42+22*q^43-5*q^44,4*q^80-11*q^81+
13*q^82-7*q^83+q^84,Unknown(),315*q^60,-4*q^15+2*q^16+12*q^18-8*q^19+45*q^20-
68*q^21+28*q^22-8*q^27+12*q^28,Unknown(),-15*q^60+42*q^61-34*q^62+8*q^63,
Unknown(),Unknown(),3*q^60-63*q^62+96*q^63-45*q^64,Unknown(),8*q^62-21*q^63+
16*q^64-3*q^65,-q^62+q^63-q^64+q^65,6*q^15-20*q^18-81*q^20+60*q^21+20*q^27,
57*q^60-108*q^61+42*q^62,Unknown(),-7*q^60+25*q^61-35*q^62+22*q^63-5*q^64,
315*q^80,Unknown(),89*q^80-152*q^81+74*q^82,-4*q^20+15*q^21-20*q^22+16*q^23-
8*q^24+2*q^25,-165*q^80+150*q^81,57*q^80-108*q^81+42*q^82,Unknown(),-15*q^80+
42*q^81-34*q^82+8*q^83,315*q^100,Unknown(),89*q^100-152*q^101+74*q^102,-
165*q^100+150*q^101,57*q^100-108*q^101+42*q^102,Unknown(),-15*q^100+42*q^101-
34*q^102+8*q^103];
  f84:=function(q,j) return [315,-135+180*q,33-102*q+
78*q^2,55-160*q+100*q^2,-12+64*q-96*q^2+41*q^3,-4+29*q-51*q^2+27*q^3,-3+(-
12*j^2-6*j)*q+(27*j^2+21*j)*q^2+18*q^3,-21+102*q-138*q^2+54*q^3,9+
(21*j^2+27*j)*q+(-6*j^2-12*j)*q^2+6*q^3,-4+(-14*j^2-18*j)*q+
(14*j^2+18*j)*q^2+(j^2-3*j)*q^3+q^4,2-20*q+55*q^2-52*q^3+15*q^4,-
4*q+17*q^2-20*q^3+7*q^4,j^2*q+(-5*j^2-j)*q^2+(7*j^2+4*j)*q^3+
3*q^4,-3+(-16*j^2-19*j)*q+(26*j^2+34*j)*q^2+(-19*j^2-
24*j)*q^3-6*q^4,1-14*q+41*q^2-42*q^3+13*q^4,1+(6*j^2+4*j)*q+(-
21*j^2-13*j)*q^2+(24*j^2+22*j)*q^3+8*q^4,4-33*q+82*q^2-73*q^3+
21*q^4,q-10*q^2+20*q^3-14*q^4+3*q^5,1+(8*j^2+10*j)*q+(-21*j^2-
26*j)*q^2+(23*j^2+29*j)*q^3+(-13*j^2-16*j)*q^4-4*q^5,
j^2*q^2-2*j^2*q^3-q^4,Unknown(),(3*j^2+4*j)*q+(-11*j^2-
14*j)*q^2+(16*j^2+20*j)*q^3+(-11*j^2-14*j)*q^4-4*q^5,Unknown(),
3*q-17*q^2+31*q^3-20*q^4+4*q^5,-3*q^2+8*q^3-6*q^4+q^5,3*j^2*q^2+(-7*j^2-
3*j)*q^3+(5*j^2+4*j)*q^4+q^5,3+(18*j^2+36*j)*q^2+96*q^3+
(63*j^2+81*j)*q^4+18*q^6,0,Unknown(),-j*q+(5*j^2+6*j)*q^2+
17*q^3+(21*j^2+24*j)*q^4+(-4*j^2-7*j)*q^5+3*q^6,0,15+(24*j^2+
12*j)*q+(27*j^2+21*j)*q^2+72*q^3+(12*j^2+6*j)*q^4+(54*j^2+
42*j)*q^5+30*q^6,Unknown(),Unknown(),-1+2*q+(-6*j^2-12*j)*q^2+
(52*j^2+64*j)*q^3+(-83*j^2-95*j)*q^4+(36*j^2+42*j)*q^5-
10*q^6+8*q^7,-q^3+(-5*j^2-4*j)*q^4+(5*j^2+4*j)*q^5+q^6,-6+(-
17*j^2-13*j)*q+(3*j^2-j)*q^2+(44*j^2+42*j)*q^3+(-46*j^2-
44*j)*q^4+(-18*j^2-14*j)*q^5+(43*j^2+39*j)*q^6+15*q^7,-2*q^2+(-
5*j^2-9*j)*q^3+(4*j^2+9*j)*q^4+(-2*j^2-3*j)*q^5-q^6,(-
2*j^2-3*j)*q^2+(10*j^2+11*j)*q^3+(-20*j^2-22*j)*q^4+
(13*j^2+16*j)*q^5-j*q^6+q^7,-2*j*q^2+(10*j^2+11*j)*q^3+(-
25*j^2-24*j)*q^4+(12*j^2+18*j)*q^5+3*q^7,Unknown(),-3+(-8*j^2-
6*j)*q-6*j^2*q^2+(28*j^2+9*j)*q^3+(-7*j^2+14*j)*q^4+(-
38*j^2-48*j)*q^5+(40*j^2+34*j)*q^6+12*q^7,Unknown(),Unknown(),
(5*j^2+3*j)*q^2+(-17*j^2-7*j)*q^3+(17*j^2-j)*q^4+(4*j^2+
21*j)*q^5+(-21*j^2-28*j)*q^6-16*q^7+4*q^8,-3*q^4+(-6*j^2-
5*j)*q^5+(3*j^2+2*j)*q^6,-4*j*q^121+17*j*q^122-20*j*q^123+
7*j*q^124,-4*j^2*q^25+17*j^2*q^26-20*j^2*q^27+7*j^2*q^28,(-
4*j^2-6*j)*q^3+(17*j^2+18*j)*q^4+(-20*j^2-23*j)*q^5+
(6*j^2+8*j)*q^6-2*q^7+q^8,Unknown(),Unknown(),1-4*q+(-j^2-
3*j)*q^2+(-15*j^2-3*j)*q^3+(16*j^2-3*j)*q^4+(14*j^2+
29*j)*q^5+(-39*j^2-41*j)*q^6+(26*j^2+24*j)*q^7+6*q^8,Unknown(),
Unknown(),Unknown(),j^2*q^25-10*j^2*q^26+20*j^2*q^27-14*j^2*q^28+
3*j^2*q^29,Unknown(),Unknown(),(4*j^2+3*j)*q^2+(-10*j^2-
8*j)*q^3+(8*j^2+9*j)*q^4+(-12*j^2-16*j)*q^5+(28*j^2+
32*j)*q^6+(-22*j^2-18*j)*q^7+(-4*j^2-9*j)*q^8-12*q^9+4*q^10,0,
Unknown(),Unknown(),0,-j*q^4-6*q^5+(-6*j^2-8*j)*q^6+2*j*q^7-q^8,
Unknown(),Unknown(),Unknown(),j*q^49-10*j*q^50+20*j*q^51-
14*j*q^52+3*j*q^53,Unknown(),Unknown(),3*q^73-17*q^74+31*q^75-20*q^76+
4*q^77,Unknown(),Unknown(),j^2*q^2+2*j*q^3+(-2*j^2-3*j)*q^4+(-
6*j^2-14*j)*q^5+(21*j^2+37*j)*q^6+(-26*j^2-34*j)*q^7+
(8*j^2+5*j)*q^8+6*j*q^9+(7*j^2+4*j)*q^10+3*q^12,0,-
3*j*q^120+(-3*j^2+16*j)*q^121+(8*j^2-26*j)*q^122+(-5*j^2+
19*j)*q^123-6*j*q^124,3*j*q^121-17*j*q^122+31*j*q^123-
20*j*q^124+4*j*q^125,Unknown(),-9*j*q^7+(6*j^2+15*j)*q^8+(-
2*j^2-5*j)*q^9+3*q^10+(-j^2+2*j)*q^12,-3*j^2*q^24+(19*j^2+
3*j)*q^25+(-34*j^2-8*j)*q^26+(24*j^2+5*j)*q^27-6*j^2*q^28,
Unknown(),j*q^48-14*j*q^49+41*j*q^50-42*j*q^51+13*j*q^52,-q^51+
q^52,Unknown(),Unknown(),-4*j*q^49+17*j*q^50-20*j*q^51+7*j*q^52,
Unknown(),315*j^2*q^24,j*q^25+(j^2-4*j)*q^26+(-4*j^2+
3*j)*q^27+3*j^2*q^28,55*j^2*q^24-160*j^2*q^25+100*j^2*q^26,
Unknown(),-4*j^2*q^24+29*j^2*q^25-51*j^2*q^26+27*j^2*q^27,-
21*j^2*q^24+102*j^2*q^25-138*j^2*q^26+54*j^2*q^27,2*j^2*q^24-
20*j^2*q^25+55*j^2*q^26-52*j^2*q^27+15*j^2*q^28,Unknown(),
j^2*q^24+(-4*j^2+2*j)*q^25+(13*j^2-8*j)*q^26+(-22*j^2+
2*j)*q^27+8*j^2*q^28,4*j^2*q^24-33*j^2*q^25+82*j^2*q^26-
73*j^2*q^27+21*j^2*q^28,j^2*q^24+(-10*j^2-2*j)*q^25+(26*j^2+
5*j)*q^26+(-29*j^2-6*j)*q^27+(16*j^2+3*j)*q^28-4*j^2*q^29,
3*j^2*q^24+(-36*j^2-18*j)*q^26+96*j^2*q^27+(-81*j^2-
18*j)*q^28+18*j^2*q^30,15*j^2*q^24+(-12*j^2+12*j)*q^25+(-
21*j^2+6*j)*q^26+72*j^2*q^27+(-6*j^2+6*j)*q^28+(-42*j^2+
12*j)*q^29+30*j^2*q^30,-2*q^26+(-11*j^2-j)*q^27+(24*j^2-
j)*q^28+(-18*j^2-6*j)*q^29+3*j^2*q^31,-j^2*q^24+2*j^2*q^25+
(12*j^2+6*j)*q^26+(-64*j^2-12*j)*q^27+(95*j^2+12*j)*q^28+(-
42*j^2-6*j)*q^29-10*j^2*q^30+8*j^2*q^31,-6*j^2*q^24+(13*j^2-
4*j)*q^25+(j^2+4*j)*q^26+(-42*j^2+2*j)*q^27+(44*j^2-
2*j)*q^28+(14*j^2-4*j)*q^29+(-39*j^2+4*j)*q^30+15*j^2*q^31,
Unknown(),(6*j^2+2*j)*q^27+(-18*j^2-j)*q^28+(23*j^2+
3*j)*q^29+(-8*j^2-2*j)*q^30-2*j^2*q^31+j^2*q^32,-3*j^2*q^28+
(5*j^2-j)*q^29+(-2*j^2+j)*q^30,-q^28-6*j^2*q^29+(8*j^2+
2*j)*q^30+2*q^31-j^2*q^32,-135*j^2*q^24+180*j^2*q^25,j*q^26+
2*q^27+(3*j^2+j)*q^28+(14*j^2+8*j)*q^29+(-37*j^2-16*j)*q^30+
(34*j^2+8*j)*q^31+(-5*j^2+3*j)*q^32+6*q^33+(-4*j^2+
3*j)*q^34+3*j^2*q^36,-3*j^2*q^24+(6*j^2-6*j)*q^25+(-21*j^2+
6*j)*q^26+18*j^2*q^27,33*j^2*q^24-102*j^2*q^25+78*j^2*q^26,
Unknown(),-12*j^2*q^24+64*j^2*q^25-96*j^2*q^26+41*j^2*q^27,-
9*q^31+(-15*j^2-9*j)*q^32+(5*j^2+3*j)*q^33+3*j^2*q^34+(-
2*j^2-3*j)*q^36,Unknown(),Unknown(),-4*q^73+17*q^74-20*q^75+7*q^76,
Unknown(),0,j^2*q^24-14*j^2*q^25+41*j^2*q^26-42*j^2*q^27+
13*j^2*q^28,Unknown(),315*j*q^48,Unknown(),55*j*q^48-160*j*q^49+
100*j*q^50,-4*j*q^48+29*j*q^49-51*j*q^50+27*j*q^51,-
21*j*q^48+102*j*q^49-138*j*q^50+54*j*q^51,-4*j*q^48+(-4*j^2+
14*j)*q^49+(4*j^2-14*j)*q^50+(-4*j^2-j)*q^51+j*q^52,
j*q^48+(2*j^2-8*j)*q^49+(-5*j^2+21*j)*q^50+(6*j^2-
23*j)*q^51+(-3*j^2+13*j)*q^52-4*j*q^53,Unknown(),3*j*q^48+
(18*j^2-18*j)*q^50+96*j*q^51+(18*j^2-63*j)*q^52+18*j*q^54,-
j*q^48+2*j*q^49+(-6*j^2+6*j)*q^50+(12*j^2-52*j)*q^51+(-
12*j^2+83*j)*q^52+(6*j^2-36*j)*q^53-10*j*q^54+8*j*q^55,-
2*j^2*q^50+(j^2-10*j)*q^51+(j^2+25*j)*q^52+(6*j^2-
12*j)*q^53+3*j*q^55,-3*j*q^52+(j^2+6*j)*q^53+(-j^2-
3*j)*q^54,-135*j*q^48+180*j*q^49,33*j*q^48-102*j*q^49+
78*j*q^50,-12*j*q^48+64*j*q^49-96*j*q^50+41*j*q^51,-
9*j^2*q^55+(9*j^2-6*j)*q^56+(-3*j^2+2*j)*q^57+3*j*q^58+
(3*j^2+j)*q^60,-3*j*q^48+(-3*j^2+16*j)*q^49+(8*j^2-
26*j)*q^50+(-5*j^2+19*j)*q^51-6*j*q^52,-4*j^2*q^97+
17*j^2*q^98-20*j^2*q^99+7*j^2*q^100,Unknown(),315*q^72,-24*q^21+
21*q^22+28*q^24-68*q^25+45*q^26+4*q^27-6*q^28+2*q^30-4*q^31+q^36-4*q^37,
Unknown(),-4*q^72+29*q^73-51*q^74+27*q^75,Unknown(),Unknown(),3*q^72+
(18*j^2+36*j)*q^74+96*q^75+(63*j^2+81*j)*q^76+18*q^78,Unknown(),-
2*j*q^74+(10*j^2+11*j)*q^75+(-25*j^2-24*j)*q^76+(12*j^2+
18*j)*q^77+3*q^79,-3*q^76+(-6*j^2-5*j)*q^77+(3*j^2+2*j)*q^78,
45*q^21-60*q^24+81*q^25-10*q^27-6*q^30-5*q^36,33*q^72-102*q^73+78*q^74,
Unknown(),-3*q^72+(-16*j^2-19*j)*q^73+(26*j^2+34*j)*q^74+(-
19*j^2-24*j)*q^75-6*q^76,315*j^2*q^96,Unknown(),55*j^2*q^96-
160*j^2*q^97+100*j^2*q^98,3*j^2*q^25-17*j^2*q^26+31*j^2*q^27-
20*j^2*q^28+4*j^2*q^29,-135*j^2*q^96+180*j^2*q^97,33*j^2*q^96-
102*j^2*q^97+78*j^2*q^98,Unknown(),-4*j^2*q^96+29*j^2*q^97-
51*j^2*q^98+27*j^2*q^99,315*j*q^120,Unknown(),55*j*q^120-
160*j*q^121+100*j*q^122,-135*j*q^120+180*j*q^121,33*j*q^120-
102*j*q^121+78*j*q^122,Unknown(),-4*j*q^120+29*j*q^121-
51*j*q^122+27*j*q^123];end;
  f88:=function(q,j) return [336,-200+136*q,90-110*q+26*q^2,
120-160*q+56*q^2,-55+100*q-60*q^2+11*q^3,-34+56*q-24*q^2+2*q^3,-18+30*q+
(8*j^2+6*j)*q^2,-72+144*q-96*q^2+24*q^3,-6+(6*j^2+8*j)*q+30*q^2-
12*q^3,5+3*q+(20*j^2+22*j)*q^2+19*q^3-5*q^4,26-58*q+48*q^2-18*q^3+2*q^4,
12-22*q+13*q^2-2*q^3,3-6*q+(-2*j^2-j)*q^2,-7+(-25*j^2-27*j)*q+
(35*j^2+36*j)*q^2+17*q^3-2*q^4,21-47*q+36*q^2-11*q^3+q^4,12-24*q+16*q^2+
(4*j^2+2*j)*q^3,33-83*q+74*q^2-31*q^3+5*q^4,-7+19*q-16*q^2+6*q^3-q^4,4-
18*q+(-31*j^2-33*j)*q^2+(24*j^2+25*j)*q^3+8*q^4-q^5,-1+q,
Unknown(),4-16*q+(-21*j^2-22*j)*q^2+(11*j^2+12*j)*q^3+2*q^4,
Unknown(),-10+27*q-26*q^2+12*q^3-3*q^4,-4+8*q-5*q^2+q^3,-2+5*q-3*q^2-
j^2*q^3,18-90*q^2+96*q^3+(18*j^2+24*j)*q^4,0,Unknown(),3+6*q-28*q^2+
19*q^3-2*q^4,0,30-60*q+(8*j^2+6*j)*q^2+72*q^3-30*q^4+(16*j^2+
12*j)*q^5+12*q^6,Unknown(),Unknown(),-12+6*q+54*q^2-92*q^3+52*q^4+
(6*j^2+12*j)*q^5,-1-q+5*q^2+(5*j^2+4*j)*q^3-j^2*q^4,-19+47*q-
20*q^2+(46*j^2+44*j)*q^3+48*q^4-4*q^5+(15*j^2+11*j)*q^6+5*q^7,-1+
2*q+(4*j^2+5*j)*q^2+(-7*j^2-8*j)*q^3+(6*j^2+7*j)*q^4+(-
j^2-2*j)*q^5,-2-3*q+19*q^2-22*q^3+9*q^4-q^5,-3+21*q^2+(27*j^2+
26*j)*q^3+(-7*j^2-8*j)*q^4,Unknown(),-13+50*q+(56*j^2+
60*j)*q^2+(-3*j^2-8*j)*q^3+(-31*j^2-28*j)*q^4-13*q^5-4*q^6+
2*q^7,Unknown(),Unknown(),6-26*q+40*q^2+(11*j^2+15*j)*q^3+(25*j^2+
21*j)*q^4+(-24*j^2-20*j)*q^5+(7*j^2+5*j)*q^6,1-4*q^2+5*q^3+
(3*j^2+j)*q^4,12*j*q^85-22*j*q^86+13*j*q^87-2*j*q^88,
12*j^2*q^17-22*j^2*q^18+13*j^2*q^19-2*j^2*q^20,2-q-13*q^2+24*q^3+
(15*j^2+14*j)*q^4+(-3*j^2-4*j)*q^5,Unknown(),Unknown(),8-35*q+
55*q^2+(25*j^2+29*j)*q^3+(18*j^2+13*j)*q^4+(-22*j^2-
19*j)*q^5-3*q^6-3*q^7+q^8,Unknown(),Unknown(),Unknown(),-7*j^2*q^17+
19*j^2*q^18-16*j^2*q^19+6*j^2*q^20-j^2*q^21,Unknown(),Unknown(),6-
20*q+16*q^2+(-22*j^2-24*j)*q^3+(46*j^2+47*j)*q^4+30*q^5+
(12*j^2+9*j)*q^6+(-6*j^2-4*j)*q^7-2*q^8,0,Unknown(),Unknown(),0,1-
q^2-4*q^3+8*q^4+(2*j^2+4*j)*q^5,Unknown(),Unknown(),Unknown(),-
7*j*q^34+19*j*q^35-16*j*q^36+6*j*q^37-j*q^38,Unknown(),
Unknown(),-10*q^51+27*q^52-26*q^53+12*q^54-3*q^55,Unknown(),Unknown(),3-6*q^2+
6*q^3-16*q^4+(-36*j^2-38*j)*q^5+(23*j^2+27*j)*q^6+(-2*j^2-
4*j)*q^7-2*q^8,0,-7*j*q^85+(-2*j^2+25*j)*q^86+(j^2-
35*j)*q^87+17*j*q^88-2*j*q^89,-10*j*q^85+27*j*q^86-
26*j*q^87+12*j*q^88-3*j*q^89,Unknown(),3*q^4-6*q^5+(7*j^2+
j)*q^6+6*q^7,-7*j^2*q^17+(27*j^2+2*j)*q^18+(-36*j^2-j)*q^19+
17*j^2*q^20-2*j^2*q^21,Unknown(),21*j*q^34-47*j*q^35+36*j*q^36-
11*j*q^37+j*q^38,-j^2*q^36,Unknown(),Unknown(),12*j*q^34-
22*j*q^35+13*j*q^36-2*j*q^37,Unknown(),336*j^2*q^17,3*j^2*q^17-
6*j^2*q^18+(j^2-j)*q^19,120*j^2*q^17-160*j^2*q^18+
56*j^2*q^19,Unknown(),-34*j^2*q^17+56*j^2*q^18-24*j^2*q^19+
2*j^2*q^20,-72*j^2*q^17+144*j^2*q^18-96*j^2*q^19+24*j^2*q^20,
26*j^2*q^17-58*j^2*q^18+48*j^2*q^19-18*j^2*q^20+2*j^2*q^21,
Unknown(),12*j^2*q^17-24*j^2*q^18+16*j^2*q^19+(-2*j^2+
2*j)*q^20,33*j^2*q^17-83*j^2*q^18+74*j^2*q^19-31*j^2*q^20+
5*j^2*q^21,4*j^2*q^17-18*j^2*q^18+(33*j^2+2*j)*q^19+(-
25*j^2-j)*q^20+8*j^2*q^21-j^2*q^22,18*j^2*q^17-90*j^2*q^19+
96*j^2*q^20+(-24*j^2-6*j)*q^21,30*j^2*q^17-60*j^2*q^18+(-
6*j^2+2*j)*q^19+72*j^2*q^20-30*j^2*q^21+(-12*j^2+4*j)*q^22+
12*j^2*q^23,-3*j^2*q^17+21*j^2*q^19+(-26*j^2+j)*q^20+(8*j^2+
j)*q^21,-12*j^2*q^17+6*j^2*q^18+54*j^2*q^19-92*j^2*q^20+
52*j^2*q^21+(-12*j^2-6*j)*q^22,-19*j^2*q^17+47*j^2*q^18-
20*j^2*q^19+(-44*j^2+2*j)*q^20+48*j^2*q^21-4*j^2*q^22+(-
11*j^2+4*j)*q^23+5*j^2*q^24,Unknown(),2*j^2*q^17-j^2*q^18-
13*j^2*q^19+24*j^2*q^20+(-14*j^2+j)*q^21+(4*j^2+j)*q^22,
j^2*q^17-4*j^2*q^19+5*j^2*q^20+(-j^2+2*j)*q^21,j^2*q^17-
j^2*q^19-4*j^2*q^20+8*j^2*q^21+(-4*j^2-2*j)*q^22,-
200*j^2*q^17+136*j^2*q^18,3*j^2*q^17-6*j^2*q^19+6*j^2*q^20-
16*j^2*q^21+(38*j^2+2*j)*q^22+(-27*j^2-4*j)*q^23+(4*j^2+
2*j)*q^24-2*j^2*q^25,-18*j^2*q^17+30*j^2*q^18+(-6*j^2+
2*j)*q^19,90*j^2*q^17-110*j^2*q^18+26*j^2*q^19,Unknown(),-
55*j^2*q^17+100*j^2*q^18-60*j^2*q^19+11*j^2*q^20,3*j^2*q^21-
6*j^2*q^22+(-j^2+6*j)*q^23+6*j^2*q^24,Unknown(),Unknown(),12*q^51-
22*q^52+13*q^53-2*q^54,Unknown(),0,21*j^2*q^17-47*j^2*q^18+
36*j^2*q^19-11*j^2*q^20+j^2*q^21,Unknown(),336*j*q^34,Unknown(),
120*j*q^34-160*j*q^35+56*j*q^36,-34*j*q^34+56*j*q^35-
24*j*q^36+2*j*q^37,-72*j*q^34+144*j*q^35-96*j*q^36+
24*j*q^37,5*j*q^34+3*j*q^35+(2*j^2-20*j)*q^36+19*j*q^37-
5*j*q^38,4*j*q^34-18*j*q^35+(-2*j^2+31*j)*q^36+(j^2-
24*j)*q^37+8*j*q^38-j*q^39,Unknown(),18*j*q^34-90*j*q^36+
96*j*q^37+(6*j^2-18*j)*q^38,-12*j*q^34+6*j*q^35+54*j*q^36-
92*j*q^37+52*j*q^38+(6*j^2-6*j)*q^39,-3*j*q^34+21*j*q^36+(-
j^2-27*j)*q^37+(-j^2+7*j)*q^38,j*q^34-4*j*q^36+5*j*q^37+
(-2*j^2-3*j)*q^38,-200*j*q^34+136*j*q^35,90*j*q^34-
110*j*q^35+26*j*q^36,-55*j*q^34+100*j*q^35-60*j*q^36+
11*j*q^37,3*j*q^38-6*j*q^39+(-6*j^2-7*j)*q^40+6*j*q^41,-
7*j*q^34+(-2*j^2+25*j)*q^35+(j^2-35*j)*q^36+17*j*q^37-
2*j*q^38,12*j^2*q^68-22*j^2*q^69+13*j^2*q^70-2*j^2*q^71,
Unknown(),336*q^51,11*q^12-4*q^13-8*q^15+4*q^16+24*q^18-16*q^19+45*q^20-
68*q^21+28*q^22,Unknown(),-34*q^51+56*q^52-24*q^53+2*q^54,Unknown(),Unknown(),
18*q^51-90*q^53+96*q^54+(18*j^2+24*j)*q^55,Unknown(),-3*q^51+21*q^53+
(27*j^2+26*j)*q^54+(-7*j^2-8*j)*q^55,q^51-4*q^53+5*q^54+(3*j^2+
j)*q^55,-15*q^12+12*q^15-40*q^18-81*q^20+60*q^21,90*q^51-110*q^52+26*q^53,
Unknown(),-7*q^51+(-25*j^2-27*j)*q^52+(35*j^2+36*j)*q^53+17*q^54-
2*q^55,336*j^2*q^68,Unknown(),120*j^2*q^68-160*j^2*q^69+
56*j^2*q^70,-10*j^2*q^17+27*j^2*q^18-26*j^2*q^19+12*j^2*q^20-
3*j^2*q^21,-200*j^2*q^68+136*j^2*q^69,90*j^2*q^68-110*j^2*q^69+
26*j^2*q^70,Unknown(),-34*j^2*q^68+56*j^2*q^69-24*j^2*q^70+
2*j^2*q^71,336*j*q^85,Unknown(),120*j*q^85-160*j*q^86+
56*j*q^87,-200*j*q^85+136*j*q^86,90*j*q^85-110*j*q^86+
26*j*q^87,Unknown(),-34*j*q^85+56*j*q^86-24*j*q^87+2*j*q^88];end;
  f92:=function(q,j)return [336,-160+176*q,50-110*q+66*q^2,72-176*q+
88*q^2,-20+82*q-94*q^2+30*q^3,-10+40*q-48*q^2+18*q^3,-6+(-12*j^2-
20*j)*q+(24*j^2+18*j)*q^2+12*q^3,-30+126*q-138*q^2+42*q^3,6+
(18*j^2+24*j)*q+(-20*j^2-12*j)*q^2,-4+(-12*j^2-14*j)*q-
16*q^2+(-10*j^2-6*j)*q^3-2*q^4,4-32*q+64*q^2-44*q^3+8*q^4,1-9*q+21*q^2-
15*q^3+3*q^4,(j^2+3*j)*q+(-3*j^2-4*j)*q^2+(5*j^2+3*j)*q^3+
q^4,-5+(-19*j^2-23*j)*q+(34*j^2+33*j)*q^2+(-25*j^2-
19*j)*q^3-6*q^4,3-24*q+48*q^2-34*q^3+7*q^4,2+(8*j^2+12*j)*q+(-
20*j^2-22*j)*q^2+(20*j^2+16*j)*q^3+4*q^4,7-49*q+94*q^2-63*q^3+
13*q^4,4*q-16*q^2+20*q^3-8*q^4+q^5,2+(12*j^2+13*j)*q+(-26*j^2-
28*j)*q^2+(30*j^2+27*j)*q^3+(-16*j^2-13*j)*q^4-3*q^5,j*q^2+
q^3+j^2*q^4,Unknown(),1+(6*j^2+7*j)*q+(-16*j^2-17*j)*q^2+
(20*j^2+18*j)*q^3+(-11*j^2-9*j)*q^4-2*q^5,Unknown(),7*q-26*q^2+
31*q^3-13*q^4+q^5,q-6*q^2+8*q^3-3*q^4,-j*q+(2*j^2+4*j)*q^2+(-
5*j^2-4*j)*q^3+(3*j^2+2*j)*q^4,6+(60*j^2+36*j)*q^2+96*q^3+
(54*j^2+72*j)*q^4+12*q^6,0,Unknown(),(-3*j^2-j)*q+(11*j^2+
9*j)*q^2+21*q^3+(15*j^2+17*j)*q^4+(-3*j^2-5*j)*q^5+q^6,0,18+
(24*j^2+40*j)*q+(24*j^2+18*j)*q^2+72*q^3+(12*j^2+20*j)*q^4+
(48*j^2+36*j)*q^5+24*q^6,Unknown(),Unknown(),-2+4*q+(-24*j^2-
12*j)*q^2+(84*j^2+72*j)*q^3+(-78*j^2-84*j)*q^4+(24*j^2+
36*j)*q^5-8*q^6+4*q^7,q^2-3*q^3+4*q^4+(j^2+2*j)*q^5-j*q^6,-8+(-
18*j^2-26*j)*q+(4*j^2+14*j)*q^2+(48*j^2+44*j)*q^3+(-
40*j^2-44*j)*q^4+(-16*j^2-8*j)*q^5+(38*j^2+30*j)*q^6+10*q^7,
(3*j^2+4*j)*q^2+8*q^3+(8*j^2+6*j)*q^4+(-5*j^2-3*j)*q^5+
j^2*q^6,j^2*q+(-6*j^2-4*j)*q^2+(17*j^2+16*j)*q^3+(-
20*j^2-21*j)*q^4+(8*j^2+10*j)*q^5-j*q^6,(-7*j^2-3*j)*q^2+
(19*j^2+14*j)*q^3+(-19*j^2-24*j)*q^4+(8*j^2+12*j)*q^5+q^7,
Unknown(),-5+(-14*j^2-18*j)*q+(8*j^2+16*j)*q^2+(6*j^2+
5*j)*q^3+(6*j^2-3*j)*q^4+(-33*j^2-21*j)*q^5+(28*j^2+
24*j)*q^6+8*q^7,Unknown(),Unknown(),1-2*q+(-j^2-3*j)*q^2+(-2*j^2-
j)*q^3-4*j^2*q^4+(13*j^2+6*j)*q^5+(-12*j^2-8*j)*q^6+
(8*j^2+6*j)*q^7+2*q^8,(-3*j^2-2*j)*q^3-4*q^4+(-2*j^2-
3*j)*q^5+2*j*q^6,-j^2*q^110+9*j^2*q^111-21*j^2*q^112+
15*j^2*q^113-3*j^2*q^114,-j*q^22+9*j*q^23-21*j*q^24+
15*j*q^25-3*j*q^26,2*j^2*q^2+(-13*j^2-9*j)*q^3+(22*j^2+
21*j)*q^4+(-13*j^2-18*j)*q^5+(3*j^2+5*j)*q^6-q^7,Unknown(),
Unknown(),2+(7*j^2+9*j)*q+(-11*j^2-15*j)*q^2+(3*j^2+
7*j)*q^3-3*j^2*q^4+(21*j^2+12*j)*q^5+(-29*j^2-21*j)*q^6+
(17*j^2+15*j)*q^7+3*q^8,Unknown(),Unknown(),Unknown(),-4*j*q^23+
16*j*q^24-20*j*q^25+8*j*q^26-j*q^27,Unknown(),Unknown(),1-2*q+
(5*j^2+4*j)*q^2+(-12*j^2-16*j)*q^3+(11*j^2+18*j)*q^4+12*q^5+
(24*j^2+16*j)*q^6+(-20*j^2-16*j)*q^7+(j^2+3*j)*q^8+
(6*j^2+4*j)*q^9+2*q^10,0,Unknown(),Unknown(),0,-3*j^2*q^4-8*q^5+(-
5*j^2-7*j)*q^6+j*q^8,Unknown(),Unknown(),Unknown(),4*j^2*q^45-
16*j^2*q^46+20*j^2*q^47-8*j^2*q^48+j^2*q^49,Unknown(),Unknown(),-
7*q^67+26*q^68-31*q^69+13*q^70-q^71,Unknown(),Unknown(),(j^2+3*j)*q^2+
4*j^2*q^3+(j^2+3*j)*q^4+(-24*j^2-22*j)*q^5+(37*j^2+
33*j)*q^6+(-30*j^2-28*j)*q^7+(5*j^2+3*j)*q^8+(2*j^2+
6*j)*q^9+(5*j^2+3*j)*q^10+q^12,0,5*j^2*q^110+(-23*j^2-
4*j)*q^111+(33*j^2-j)*q^112+(-19*j^2+6*j)*q^113+6*j^2*q^114,
-7*j^2*q^111+26*j^2*q^112-31*j^2*q^113+13*j^2*q^114-j^2*q^115,
Unknown(),(-2*j^2-5*j)*q^6-9*j^2*q^7+9*j*q^8+(3*j^2-
6*j)*q^9+6*q^10,5*j*q^22+(4*j^2-19*j)*q^23+(j^2+34*j)*q^24+
(-6*j^2-25*j)*q^25+6*j*q^26,Unknown(),3*j^2*q^44-24*j^2*q^45+
48*j^2*q^46-34*j^2*q^47+7*j^2*q^48,-j*q^46,Unknown(),Unknown(),
j^2*q^44-9*j^2*q^45+21*j^2*q^46-15*j^2*q^47+3*j^2*q^48,
Unknown(),-336*j*q^22,(-2*j^2+j)*q^23+(j^2-3*j)*q^24+(2*j^2+
5*j)*q^25-j*q^26,-72*j*q^22+176*j*q^23-88*j*q^24,Unknown(),
10*j*q^22-40*j*q^23+48*j*q^24-18*j*q^25,30*j*q^22-
126*j*q^23+138*j*q^24-42*j*q^25,-4*j*q^22+32*j*q^23-
64*j*q^24+44*j*q^25-8*j*q^26,Unknown(),-2*j*q^22+(-4*j^2+
8*j)*q^23+(2*j^2-20*j)*q^24+(4*j^2+20*j)*q^25-4*j*q^26,-
7*j*q^22+49*j*q^23-94*j*q^24+63*j*q^25-13*j*q^26,-2*j*q^22+
(-j^2+12*j)*q^23+(2*j^2-26*j)*q^24+(3*j^2+30*j)*q^25+(-
3*j^2-16*j)*q^26+3*j*q^27,-6*j*q^22+(24*j^2+60*j)*q^24-
96*j*q^25+(-18*j^2+54*j)*q^26-12*j*q^28,-18*j*q^22+(-16*j^2+
24*j)*q^23+(6*j^2+24*j)*q^24-72*j*q^25+(-8*j^2+12*j)*q^26+
(12*j^2+48*j)*q^27-24*j*q^28,(-4*j^2-7*j)*q^24+(5*j^2+
19*j)*q^25+(5*j^2-19*j)*q^26+(-4*j^2+8*j)*q^27-j*q^29,
2*j*q^22-4*j*q^23+(-12*j^2-24*j)*q^24+(12*j^2+84*j)*q^25+
(6*j^2-78*j)*q^26+(-12*j^2+24*j)*q^27+8*j*q^28-4*j*q^29,
8*j*q^22+(8*j^2-18*j)*q^23+(-10*j^2+4*j)*q^24+(4*j^2+
48*j)*q^25+(4*j^2-40*j)*q^26+(-8*j^2-16*j)*q^27+(8*j^2+
38*j)*q^28-10*j*q^29,Unknown(),-2*q^24+(-4*j^2-13*j)*q^25+(j^2+
22*j)*q^26+(5*j^2-13*j)*q^27+(-2*j^2+3*j)*q^28+j*q^29,(-
j^2-3*j)*q^25+4*j*q^26+(j^2-2*j)*q^27-2*j^2*q^28,3*q^26+
8*j*q^27+(2*j^2-5*j)*q^28-j^2*q^30,160*j*q^22-176*j*q^23,(-
2*j^2+j)*q^24-4*q^25+(-2*j^2+j)*q^26+(-2*j^2-24*j)*q^27+
(4*j^2+37*j)*q^28+(-2*j^2-30*j)*q^29+(2*j^2+5*j)*q^30+(-
4*j^2+2*j)*q^31+(2*j^2+5*j)*q^32-j*q^34,6*j*q^22+(8*j^2-
12*j)*q^23+(6*j^2+24*j)*q^24-12*j*q^25,-50*j*q^22+
110*j*q^23-66*j*q^24,Unknown(),20*j*q^22-82*j*q^23+94*j*q^24-
30*j*q^25,(3*j^2-2*j)*q^28+9*q^29-9*j^2*q^30+(9*j^2+
3*j)*q^31-6*j*q^32,Unknown(),Unknown(),-q^66+9*q^67-21*q^68+15*q^69-
3*q^70,Unknown(),0,-3*j*q^22+24*j*q^23-48*j*q^24+34*j*q^25-
7*j*q^26,Unknown(),336*j^2*q^44,Unknown(),72*j^2*q^44-
176*j^2*q^45+88*j^2*q^46,-10*j^2*q^44+40*j^2*q^45-48*j^2*q^46+
18*j^2*q^47,-30*j^2*q^44+126*j^2*q^45-138*j^2*q^46+42*j^2*q^47,
-4*j^2*q^44+(14*j^2+2*j)*q^45-16*j^2*q^46+(6*j^2-4*j)*q^47-
2*j^2*q^48,2*j^2*q^44+(-13*j^2-j)*q^45+(28*j^2+2*j)*q^46+(-
27*j^2+3*j)*q^47+(13*j^2-3*j)*q^48-3*j^2*q^49,Unknown(),
6*j^2*q^44+(-36*j^2+24*j)*q^46+96*j^2*q^47+(-72*j^2-
18*j)*q^48+12*j^2*q^50,-2*j^2*q^44+4*j^2*q^45+(12*j^2-
12*j)*q^46+(-72*j^2+12*j)*q^47+(84*j^2+6*j)*q^48+(-36*j^2-
12*j)*q^49-8*j^2*q^50+4*j^2*q^51,(3*j^2-4*j)*q^46+(-14*j^2+
5*j)*q^47+(24*j^2+5*j)*q^48+(-12*j^2-4*j)*q^49+j^2*q^51,
(2*j^2-j)*q^47-4*j^2*q^48+(3*j^2+j)*q^49+2*q^50,-
160*j^2*q^44+176*j^2*q^45,50*j^2*q^44-110*j^2*q^45+66*j^2*q^46,
-20*j^2*q^44+82*j^2*q^45-94*j^2*q^46+30*j^2*q^47,(5*j^2+
3*j)*q^50-9*j*q^51+9*q^52+(6*j^2+9*j)*q^53+6*j^2*q^54,-
5*j^2*q^44+(23*j^2+4*j)*q^45+(-33*j^2+j)*q^46+(19*j^2-
6*j)*q^47-6*j^2*q^48,j*q^88-9*j*q^89+21*j*q^90-15*j*q^91+
3*j*q^92,Unknown(),-336*q^66,6*q^18-4*q^19+45*q^20-60*q^21+21*q^22+21*q^24-
60*q^25+45*q^26+12*q^27-18*q^28-8*q^30+16*q^31,Unknown(),10*q^66-40*q^67+
48*q^68-18*q^69,Unknown(),Unknown(),-6*q^66+(-60*j^2-36*j)*q^68-96*q^69+
(-54*j^2-72*j)*q^70-12*q^72,Unknown(),(7*j^2+3*j)*q^68+(-
19*j^2-14*j)*q^69+(19*j^2+24*j)*q^70+(-8*j^2-12*j)*q^71-
q^73,(3*j^2+2*j)*q^69+4*q^70+(2*j^2+3*j)*q^71-2*j*q^72,-
10*q^18-81*q^20+45*q^21-45*q^24+81*q^25-30*q^27+24*q^30,-50*q^66+110*q^67-
66*q^68,Unknown(),5*q^66+(19*j^2+23*j)*q^67+(-34*j^2-33*j)*q^68+
(25*j^2+19*j)*q^69+6*q^70,336*j*q^88,Unknown(),72*j*q^88-
176*j*q^89+88*j*q^90,-7*j*q^23+26*j*q^24-31*j*q^25+
13*j*q^26-j*q^27,-160*j*q^88+176*j*q^89,50*j*q^88-
110*j*q^89+66*j*q^90,Unknown(),-10*j*q^88+40*j*q^89-48*j*q^90+
18*j*q^91,-336*j^2*q^110,Unknown(),-72*j^2*q^110+176*j^2*q^111-
88*j^2*q^112,160*j^2*q^110-176*j^2*q^111,-50*j^2*q^110+
110*j^2*q^111-66*j^2*q^112,Unknown(),10*j^2*q^110-40*j^2*q^111+
48*j^2*q^112-18*j^2*q^113];end;
  f96:=function(q,j,e)local v;v:=GetRoot(q,2)*e; return 
  [384,-160+224*q,36-124*q+100*q^2,64-192*q+128*q^2,-13+74*q-
118*q^2+55*q^3,-4+32*q-64*q^2+36*q^3,12*q+(36*j^2+28*j)*q^2+24*q^3,-24+
120*q-168*q^2+72*q^3,12+(28*j^2+36*j)*q+12*q^2+12*q^3,-5+(-19*j^2-
23*j)*q+(20*j^2+24*j)*q^2+q^3+5*q^4,2-22*q+64*q^2-66*q^3+22*q^4,-4*q+
19*q^2-26*q^3+10*q^4,(-5*j^2-3*j)*q^2+(10*j^2+6*j)*q^3+4*q^4,-3+(-
19*j^2-23*j)*q+(37*j^2+43*j)*q^2+27*q^3-5*q^4,1-15*q+48*q^2-
53*q^3+19*q^4,-4*q+(-24*j^2-20*j)*q^2+(32*j^2+28*j)*q^3+12*q^4,4-
38*q+96*q^2-92*q^3+30*q^4,q-11*q^2+23*q^3-19*q^4+5*q^5,1+(9*j^2+11*j)*q+
(-27*j^2-32*j)*q^2+(33*j^2+36*j)*q^3+18*q^4-3*q^5,(-2*j^2-
j)*q^3+(2*j^2+j)*q^4,Unknown(),(3*j^2+4*j)*q+(-14*j^2-
17*j)*q^2+(23*j^2+25*j)*q^3+16*q^4-4*q^5,Unknown(),3*q-19*q^2+36*q^3-
27*q^4+7*q^5,-3*q^2+9*q^3-8*q^4+2*q^5,(2*j^2+j)*q^2+(-8*j^2-
5*j)*q^3+(7*j^2+5*j)*q^4+2*q^5,-36*q^2+96*q^3+(84*j^2+
108*j)*q^4+24*q^6,j*v^7,Unknown(),-4*q^2+20*q^3+(26*j^2+
30*j)*q^4+(-6*j^2-10*j)*q^5+4*q^6,j^2*v^35,12-24*q+(36*j^2+
28*j)*q^2+72*q^3-12*q^4+(72*j^2+56*j)*q^5+36*q^6,Unknown(),Unknown(),
12*q^2-64*q^3+(-92*j^2-104*j)*q^4+(48*j^2+60*j)*q^5-12*q^6+12*q^7,
(2*j^2+j)*q^3+(-6*j^2-5*j)*q^4-6*q^5+(-j^2-2*j)*q^6,-5+15*q+
4*j*q^2+(50*j^2+46*j)*q^3+46*q^4+(-24*j^2-16*j)*q^5+(57*j^2+
49*j)*q^6+19*q^7,(2*j^2+3*j)*q^2+(-7*j^2-10*j)*q^3+(7*j^2+
10*j)*q^4+(-3*j^2-2*j)*q^5+j^2*q^6,q^2-11*q^3+(-24*j^2-
26*j)*q^4+(17*j^2+21*j)*q^5+(-j^2-3*j)*q^6+2*q^7,q^2+
(11*j^2+9*j)*q^3+(-25*j^2-27*j)*q^4+(19*j^2+27*j)*q^5+4*q^7,
Unknown(),-3+8*q+(-9*j^2-j)*q^2+(26*j^2+12*j)*q^3+(6*j^2+
16*j)*q^4+53*q^5+(52*j^2+44*j)*q^6+13*q^7,Unknown(),Unknown(),
(6*j^2+3*j)*q^2+(-19*j^2-11*j)*q^3+(15*j^2+4*j)*q^4+
(13*j^2+20*j)*q^5+31*q^6+(22*j^2+20*j)*q^7+4*q^8,-j^2*q^3+
(4*j^2+3*j)*q^4+6*q^5+(4*j^2+5*j)*q^6,4*j^2*v^247-
19*j^2*v^249+26*j^2*v^251-10*j^2*v^253,4*j*v^51-
19*j*v^53+26*j*v^55-10*j*v^57,(-5*j^2-4*j)*q^3-
18*q^4+(-23*j^2-28*j)*q^5+(10*j^2+14*j)*q^6-2*q^7+2*q^8,Unknown(),
Unknown(),1-4*q-4*j*q^2+(-16*j^2-5*j)*q^3+(10*j^2-2*j)*q^4+
(28*j^2+33*j)*q^5+(-52*j^2-48*j)*q^6+(34*j^2+30*j)*q^7+
7*q^8,Unknown(),Unknown(),Unknown(),-j*v^51+11*j*v^53-
23*j*v^55+19*j*v^57-5*j*v^59,Unknown(),Unknown(),
(4*j^2+3*j)*q^2+8*q^3+(7*j^2+12*j)*q^4+(-22*j^2-26*j)*q^5-
41*q^6+(-26*j^2-22*j)*q^7+(-10*j^2-12*j)*q^8+(18*j^2+
16*j)*q^9+4*q^10,-j^2*q^7,Unknown(),Unknown(),-j*q^14,-4*q^5+(-
7*j^2-10*j)*q^6+(2*j^2+4*j)*q^7+(j^2+2*j)*q^8,Unknown(),
Unknown(),Unknown(),j^2*q^50-11*j^2*q^51+23*j^2*q^52-19*j^2*q^53+
5*j^2*q^54,Unknown(),Unknown(),-3*v^149+19*v^151-36*v^153+
27*v^155-7*v^157,Unknown(),Unknown(),2*q^3-4*q^4+(-14*j^2-
18*j)*q^5+(32*j^2+40*j)*q^6+(-38*j^2-42*j)*q^7+(14*j^2+
10*j)*q^8+(-2*j^2+6*j)*q^9+(10*j^2+6*j)*q^10+4*q^12,v^21,
3*j^2*v^245+(-23*j^2-4*j)*v^247+(43*j^2+6*j)*v^249-
27*j^2*v^251+5*j^2*v^253,-3*j^2*v^247+
19*j^2*v^249-36*j^2*v^251+27*j^2*v^253-
7*j^2*v^255,Unknown(),8*v^15+9*j*q^8+(j^2-11*j)*q^9+
3*q^10-3*q^11+(-j^2+2*j)*q^12,3*j*v^49+(4*j^2-
19*j)*v^51+(-6*j^2+37*j)*v^53-27*j*v^55+
5*j*v^57,Unknown(),j^2*q^49-15*j^2*q^50+48*j^2*q^51-
53*j^2*q^52+19*j^2*q^53,-j^2*v^103-j*q^52+j*q^53,Unknown(),
Unknown(),-4*j^2*q^50+19*j^2*q^51-26*j^2*q^52+10*j^2*q^53,
Unknown(),-384*j*v^49,(-2*j^2-5*j)*v^53+(4*j^2+
10*j)*v^55-4*j*v^57,-64*j*v^49+192*j*v^51-
128*j*v^53,Unknown(),4*j*v^49-32*j*v^51+64*j*v^53-
36*j*v^55,24*j*v^49-120*j*v^51+168*j*v^53-
72*j*v^55,-2*j*v^49+22*j*v^51-64*j*v^53+
66*j*v^55-22*j*v^57,Unknown(),4*j*v^51+(-4*j^2-
24*j)*v^53+(4*j^2+32*j)*v^55-12*j*v^57,-
4*j*v^49+38*j*v^51-96*j*v^53+92*j*v^55-
30*j*v^57,-j*v^49+(-2*j^2+9*j)*v^51+(5*j^2-
27*j)*v^53+(-3*j^2+33*j)*v^55-18*j*v^57+
3*j*v^59,36*j*v^53-96*j*v^55+(-24*j^2+
84*j)*v^57-24*j*v^61,-12*j*v^49+24*j*v^51+
(8*j^2+36*j)*v^53-72*j*v^55+12*j*v^57+(16*j^2+
72*j)*v^59-36*j*v^61,-j*v^53+(2*j^2+11*j)*v^55+
(2*j^2-25*j)*v^57+(-8*j^2+19*j)*v^59-4*j*v^63,-
12*j*v^53+64*j*v^55+(12*j^2-92*j)*v^57+(-12*j^2+
48*j)*v^59+12*j*v^61-12*j*v^63,5*j*v^49-
15*j*v^51-4*j^2*v^53+(4*j^2+50*j)*v^55-
46*j*v^57+(-8*j^2-24*j)*v^59+(8*j^2+57*j)*v^61-
19*j*v^63,Unknown(),(-j^2-5*j)*v^55+18*j*v^57+
(5*j^2-23*j)*v^59+(-4*j^2+10*j)*v^61+2*j*v^63-
2*j*v^65,v^55+(j^2+4*j)*v^57-6*j*v^59+(-j^2+
4*j)*v^61,4*j*v^59+(3*j^2-7*j)*v^61+(-2*j^2+
2*j)*v^63+(-j^2+j)*v^65,160*j*v^49-224*j*v^51,-
2*j*v^55+4*j*v^57+(4*j^2-14*j)*v^59+(-8*j^2+
32*j)*v^61+(4*j^2-38*j)*v^63+(4*j^2+14*j)*v^65+(-
8*j^2-2*j)*v^67+(4*j^2+10*j)*v^69-4*j*v^73,-
12*j*v^51+(8*j^2+36*j)*v^53-24*j*v^55,-
36*j*v^49+124*j*v^51-100*j*v^53,Unknown(),
13*j*v^49-74*j*v^51+118*j*v^53-55*j*v^55,
-8*j*q^32-9*j^2*v^65+(12*j^2+j)*v^67-3*j*v^69+
3*j*v^71+(-3*j^2-j)*v^73,Unknown(),Unknown(),4*v^149-
19*v^151+26*v^153-10*v^155,Unknown(),-q^21,-j*v^49+
15*j*v^51-48*j*v^53+53*j*v^55-19*j*v^57,Unknown(),
384*j^2*q^49,Unknown(),64*j^2*q^49-192*j^2*q^50+128*j^2*q^51,-
4*j^2*q^49+32*j^2*q^50-64*j^2*q^51+36*j^2*q^52,-24*j^2*q^49+
120*j^2*q^50-168*j^2*q^51+72*j^2*q^52,-5*j^2*q^49+(23*j^2+
4*j)*q^50+(-24*j^2-4*j)*q^51+j^2*q^52+5*j^2*q^53,j^2*q^49+(-
11*j^2-2*j)*q^50+(32*j^2+5*j)*q^51+(-36*j^2-3*j)*q^52+
18*j^2*q^53-3*j^2*q^54,Unknown(),-36*j^2*q^51+96*j^2*q^52+(-
108*j^2-24*j)*q^53+24*j^2*q^55,12*j^2*q^51-64*j^2*q^52+
(104*j^2+12*j)*q^53+(-60*j^2-12*j)*q^54-12*j^2*q^55+
12*j^2*q^56,j^2*q^51+(-9*j^2+2*j)*q^52+(27*j^2+2*j)*q^53+(-
27*j^2-8*j)*q^54+4*j^2*q^56,-j*q^52+(-3*j^2+j)*q^53+
6*j^2*q^54+(-5*j^2-j)*q^55,-160*j^2*q^49+224*j^2*q^50,
36*j^2*q^49-124*j^2*q^50+100*j^2*q^51,-13*j^2*q^49+74*j^2*q^50-
118*j^2*q^51+55*j^2*q^52,8*j^2*v^113+9*q^57+(11*j^2+
12*j)*q^58+3*j^2*q^59-3*j^2*q^60+(-2*j^2-3*j)*q^61,-
3*j^2*q^49+(23*j^2+4*j)*q^50+(-43*j^2-6*j)*q^51+27*j^2*q^52-
5*j^2*q^53,-4*j*q^99+19*j*q^100-26*j*q^101+10*j*q^102,
Unknown(),-384*v^147,-32*v^45+32*v^47+21*q^24-60*q^25+45*q^26+
16*q^27-24*q^28+2*q^30-4*q^31-4*q^33+11*q^34+q^36-4*q^37,Unknown(),
4*v^147-32*v^149+64*v^151-36*v^153,Unknown(),Unknown(),
36*v^151-96*v^153+(-84*j^2-108*j)*v^155-24*v^159,
Unknown(),-v^151+(-11*j^2-9*j)*v^153+(25*j^2+
27*j)*v^155+(-19*j^2-27*j)*v^157-4*v^161,
j^2*v^153+(-4*j^2-3*j)*v^155-6*v^157+(-4*j^2-
5*j)*v^159,-64*v^45-45*q^24+81*q^25-40*q^27-6*q^30+15*q^33-5*q^36,-
36*v^147+124*v^149-100*v^151,Unknown(),3*v^147+(19*j^2+
23*j)*v^149+(-37*j^2-43*j)*v^151-27*v^153+5*v^155,
384*j*q^98,Unknown(),64*j*q^98-192*j*q^99+128*j*q^100,-
3*j*v^51+19*j*v^53-36*j*v^55+27*j*v^57-
7*j*v^59,-160*j*q^98+224*j*q^99,36*j*q^98-124*j*q^99+
100*j*q^100,Unknown(),-4*j*q^98+32*j*q^99-64*j*q^100+
36*j*q^101,-384*j^2*v^245,Unknown(),-64*j^2*v^245+
192*j^2*v^247-128*j^2*v^249,160*j^2*v^245-
224*j^2*v^247,-36*j^2*v^245+124*j^2*v^247-
100*j^2*v^249,Unknown(),4*j^2*v^245-32*j^2*v^247+
64*j^2*v^249-36*j^2*v^251];end;
  f104:=q->[420,-240+180*q,102-138*q+42*q^2,136-
208*q+76*q^2,-57+124*q-84*q^2+17*q^3,-35+67*q-37*q^2+5*q^3,-18+36*q-15*q^2,-
76+180*q-132*q^2+32*q^3,-6-15*q+36*q^2-12*q^3,3+6*q-26*q^2+23*q^3-5*q^4,23-
68*q+67*q^2-28*q^3+3*q^4,10-25*q+20*q^2-5*q^3,2-7*q+5*q^2,-7+32*q-46*q^2+
24*q^3-3*q^4,19-54*q+51*q^2-18*q^3+2*q^4,10-28*q+25*q^2-6*q^3,31-97*q+102*q^2-
45*q^3+7*q^4,-5+19*q-23*q^2+11*q^3-2*q^4,4-21*q+40*q^2-34*q^3+12*q^4-q^5,q-
q^2,Unknown(),4-17*q+27*q^2-18*q^3+4*q^4,Unknown(),-7+28*q-36*q^2+20*q^3-
5*q^4,-2+8*q-8*q^2+3*q^3,-1+5*q-6*q^2+2*q^3,18-108*q^2+96*q^3-45*q^4,0,
Unknown(),2+7*q-28*q^2+22*q^3-5*q^4,0,30-72*q-15*q^2+72*q^3-36*q^4-30*q^5+
12*q^6,Unknown(),Unknown(),-10+8*q+60*q^2-104*q^3+67*q^4-18*q^5,-q+5*q^2-
6*q^3+2*q^4,-17+53*q-23*q^2-48*q^3+50*q^4+2*q^5-19*q^6+5*q^7,q-5*q^2+10*q^3-
9*q^4+3*q^5,-1-3*q+18*q^2-26*q^3+12*q^4-2*q^5,-2+24*q^2-25*q^3+11*q^4-2*q^5,
Unknown(),-11+52*q-56*q^2+15*q^3+19*q^4-6*q^5-10*q^6+3*q^7,Unknown(),
Unknown(),4-22*q+33*q^2-15*q^3-13*q^4+19*q^5-6*q^6,-4*q^2+6*q^3-3*q^4+q^5,
10*q^90-25*q^91+20*q^92-5*q^93,10*q^18-25*q^19+20*q^20-5*q^21,1-q-13*q^2+
25*q^3-18*q^4+5*q^5-q^6,Unknown(),Unknown(),6-33*q+54*q^2-34*q^3-3*q^4+11*q^5+
2*q^6-6*q^7+q^8,Unknown(),Unknown(),Unknown(),-5*q^18+19*q^19-23*q^20+11*q^21-
2*q^22,Unknown(),Unknown(),4-18*q+11*q^2+26*q^3-49*q^4+34*q^5-16*q^6+10*q^7-
4*q^8,0,Unknown(),Unknown(),0,-q^2-4*q^3+7*q^4-4*q^5,Unknown(),Unknown(),
Unknown(),-5*q^36+19*q^37-23*q^38+11*q^39-2*q^40,Unknown(),Unknown(),-7*q^54+
28*q^55-36*q^56+20*q^57-5*q^58,Unknown(),Unknown(),2-7*q^2+6*q^3-20*q^4+
48*q^5-42*q^6+20*q^7-5*q^8+4*q^9,0,-7*q^90+32*q^91-46*q^92+24*q^93-3*q^94,-
7*q^90+28*q^91-36*q^92+20*q^93-5*q^94,Unknown(),3*q^4,-7*q^18+32*q^19-46*q^20+
24*q^21-3*q^22,Unknown(),19*q^36-54*q^37+51*q^38-18*q^39+2*q^40,0,Unknown(),
Unknown(),10*q^36-25*q^37+20*q^38-5*q^39,Unknown(),420*q^18,2*q^18-7*q^19+
5*q^20,136*q^18-208*q^19+76*q^20,Unknown(),-35*q^18+67*q^19-37*q^20+5*q^21,-
76*q^18+180*q^19-132*q^20+32*q^21,23*q^18-68*q^19+67*q^20-28*q^21+3*q^22,
Unknown(),10*q^18-28*q^19+25*q^20-6*q^21,31*q^18-97*q^19+102*q^20-45*q^21+
7*q^22,4*q^18-21*q^19+40*q^20-34*q^21+12*q^22-q^23,18*q^18-108*q^20+96*q^21-
45*q^22,30*q^18-72*q^19-15*q^20+72*q^21-36*q^22-30*q^23+12*q^24,-2*q^18+
24*q^20-25*q^21+11*q^22-2*q^23,-10*q^18+8*q^19+60*q^20-104*q^21+67*q^22-
18*q^23,-17*q^18+53*q^19-23*q^20-48*q^21+50*q^22+2*q^23-19*q^24+5*q^25,
Unknown(),q^18-q^19-13*q^20+25*q^21-18*q^22+5*q^23-q^24,-4*q^20+6*q^21-3*q^22+
q^23,-q^20-4*q^21+7*q^22-4*q^23,-240*q^18+180*q^19,2*q^18-7*q^20+6*q^21-
20*q^22+48*q^23-42*q^24+20*q^25-5*q^26+4*q^27,-18*q^18+36*q^19-15*q^20,
102*q^18-138*q^19+42*q^20,Unknown(),-57*q^18+124*q^19-84*q^20+17*q^21,3*q^22,
Unknown(),Unknown(),10*q^54-25*q^55+20*q^56-5*q^57,Unknown(),0,19*q^18-
54*q^19+51*q^20-18*q^21+2*q^22,Unknown(),420*q^36,Unknown(),136*q^36-208*q^37+
76*q^38,-35*q^36+67*q^37-37*q^38+5*q^39,-76*q^36+180*q^37-132*q^38+32*q^39,
3*q^36+6*q^37-26*q^38+23*q^39-5*q^40,4*q^36-21*q^37+40*q^38-34*q^39+12*q^40-
q^41,Unknown(),18*q^36-108*q^38+96*q^39-45*q^40,-10*q^36+8*q^37+60*q^38-
104*q^39+67*q^40-18*q^41,-2*q^36+24*q^38-25*q^39+11*q^40-2*q^41,-4*q^38+
6*q^39-3*q^40+q^41,-240*q^36+180*q^37,102*q^36-138*q^37+42*q^38,-57*q^36+
124*q^37-84*q^38+17*q^39,3*q^40,-7*q^36+32*q^37-46*q^38+24*q^39-3*q^40,
10*q^72-25*q^73+20*q^74-5*q^75,Unknown(),420*q^54,11*q^12-4*q^13-24*q^15+
12*q^16+45*q^20-36*q^21,Unknown(),-35*q^54+67*q^55-37*q^56+5*q^57,Unknown(),
Unknown(),18*q^54-108*q^56+96*q^57-45*q^58,Unknown(),-2*q^54+24*q^56-25*q^57+
11*q^58-2*q^59,-4*q^56+6*q^57-3*q^58+q^59,-15*q^12+36*q^15-81*q^20,102*q^54-
138*q^55+42*q^56,Unknown(),-7*q^54+32*q^55-46*q^56+24*q^57-3*q^58,420*q^72,
Unknown(),136*q^72-208*q^73+76*q^74,-7*q^18+28*q^19-36*q^20+20*q^21-5*q^22,-
240*q^72+180*q^73,102*q^72-138*q^73+42*q^74,Unknown(),-35*q^72+67*q^73-
37*q^74+5*q^75,420*q^90,Unknown(),136*q^90-208*q^91+76*q^92,-240*q^90+
180*q^91,102*q^90-138*q^91+42*q^92,Unknown(),-35*q^90+67*q^91-37*q^92+5*q^93];
  f106:=q->[420,-210+210*q,72-138*q+72*q^2,100-220*q+100*q^2,-31+110*q-110*q^2+31*q^3,-
17+55*q-55*q^2+17*q^3,-12+21*q-21*q^2+12*q^3,-45+165*q-165*q^2+45*q^3,6-21*q+
21*q^2-6*q^3,-5+13*q-18*q^2+13*q^3-5*q^4,8-46*q+82*q^2-46*q^3+8*q^4,2-15*q+
26*q^2-15*q^3+2*q^4,1-3*q+4*q^2-3*q^3+q^4,-8+27*q-38*q^2+27*q^3-8*q^4,6-36*q+
60*q^2-36*q^3+6*q^4,4-17*q+24*q^2-17*q^3+4*q^4,12-71*q+116*q^2-71*q^3+12*q^4,
8*q-22*q^2+22*q^3-8*q^4,4-17*q+33*q^2-33*q^3+17*q^4-4*q^5,-q^2+q^3,Unknown(),
2-11*q+20*q^2-20*q^3+11*q^4-2*q^5,Unknown(),-1+12*q-36*q^2+36*q^3-12*q^4+q^5,
2*q-9*q^2+9*q^3-2*q^4,2*q-4*q^2+4*q^3-2*q^4,12-63*q^2+144*q^3-63*q^4+12*q^6,0,
Unknown(),1+3*q-18*q^2+26*q^3-18*q^4+3*q^5+q^6,0,30-42*q-21*q^2+108*q^3-
21*q^4-42*q^5+30*q^6,Unknown(),Unknown(),-4+8*q+27*q^2-108*q^3+108*q^4-27*q^5-
8*q^6+4*q^7,2*q^2-4*q^3+4*q^4-2*q^5,-13+35*q-12*q^2-63*q^3+63*q^4+12*q^5-
35*q^6+13*q^7,q-4*q^2+9*q^3-9*q^4+4*q^5-q^6,9*q^2-24*q^3+24*q^4-9*q^5,-1+
7*q^2-27*q^3+27*q^4-7*q^5+q^7,Unknown(),-10+26*q-25*q^2-10*q^3+10*q^4+25*q^5-
26*q^6+10*q^7,Unknown(),Unknown(),2-6*q+7*q^2-q^3-4*q^4-q^5+7*q^6-6*q^7+2*q^8,
3*q^3-6*q^4+3*q^5,-2*q^105+15*q^106-26*q^107+15*q^108-2*q^109,-2*q^21+15*q^22-
26*q^23+15*q^24-2*q^25,-q-2*q^2+17*q^3-30*q^4+17*q^5-2*q^6-q^7,Unknown(),
Unknown(),4-16*q+24*q^2-10*q^3-6*q^4-10*q^5+24*q^6-16*q^7+4*q^8,Unknown(),
Unknown(),Unknown(),-8*q^22+22*q^23-22*q^24+8*q^25,Unknown(),Unknown(),2-4*q-
5*q^2+22*q^3-22*q^4+12*q^5-22*q^6+22*q^7-5*q^8-4*q^9+2*q^10,0,Unknown(),
Unknown(),0,5*q^4-12*q^5+5*q^6,Unknown(),Unknown(),Unknown(),8*q^43-22*q^44+
22*q^45-8*q^46,Unknown(),Unknown(),q^63-12*q^64+36*q^65-36*q^66+12*q^67-q^68,
Unknown(),Unknown(),1-3*q^2-4*q^3+2*q^4+28*q^5-42*q^6+28*q^7+2*q^8-4*q^9-
3*q^10+q^12,0,8*q^105-27*q^106+38*q^107-27*q^108+8*q^109,q^105-12*q^106+
36*q^107-36*q^108+12*q^109-q^110,Unknown(),-6*q^5+15*q^7-15*q^8+6*q^10,8*q^21-
27*q^22+38*q^23-27*q^24+8*q^25,Unknown(),6*q^42-36*q^43+60*q^44-36*q^45+
6*q^46,0,Unknown(),Unknown(),2*q^42-15*q^43+26*q^44-15*q^45+2*q^46,Unknown(),-
420*q^21,-q^21+3*q^22-4*q^23+3*q^24-q^25,-100*q^21+220*q^22-100*q^23,
Unknown(),17*q^21-55*q^22+55*q^23-17*q^24,45*q^21-165*q^22+165*q^23-45*q^24,-
8*q^21+46*q^22-82*q^23+46*q^24-8*q^25,Unknown(),-4*q^21+17*q^22-24*q^23+
17*q^24-4*q^25,-12*q^21+71*q^22-116*q^23+71*q^24-12*q^25,-4*q^21+17*q^22-
33*q^23+33*q^24-17*q^25+4*q^26,-12*q^21+63*q^23-144*q^24+63*q^25-12*q^27,-
30*q^21+42*q^22+21*q^23-108*q^24+21*q^25+42*q^26-30*q^27,q^21-7*q^23+27*q^24-
27*q^25+7*q^26-q^28,4*q^21-8*q^22-27*q^23+108*q^24-108*q^25+27*q^26+8*q^27-
4*q^28,13*q^21-35*q^22+12*q^23+63*q^24-63*q^25-12*q^26+35*q^27-13*q^28,
Unknown(),q^22+2*q^23-17*q^24+30*q^25-17*q^26+2*q^27+q^28,-3*q^24+6*q^25-
3*q^26,-5*q^25+12*q^26-5*q^27,210*q^21-210*q^22,-q^21+3*q^23+4*q^24-2*q^25-
28*q^26+42*q^27-28*q^28-2*q^29+4*q^30+3*q^31-q^33,12*q^21-21*q^22+21*q^23-
12*q^24,-72*q^21+138*q^22-72*q^23,Unknown(),31*q^21-110*q^22+110*q^23-31*q^24,
6*q^26-15*q^28+15*q^29-6*q^31,Unknown(),Unknown(),-2*q^63+15*q^64-26*q^65+
15*q^66-2*q^67,Unknown(),0,-6*q^21+36*q^22-60*q^23+36*q^24-6*q^25,Unknown(),
420*q^42,Unknown(),100*q^42-220*q^43+100*q^44,-17*q^42+55*q^43-55*q^44+
17*q^45,-45*q^42+165*q^43-165*q^44+45*q^45,-5*q^42+13*q^43-18*q^44+13*q^45-
5*q^46,4*q^42-17*q^43+33*q^44-33*q^45+17*q^46-4*q^47,Unknown(),12*q^42-
63*q^44+144*q^45-63*q^46+12*q^48,-4*q^42+8*q^43+27*q^44-108*q^45+108*q^46-
27*q^47-8*q^48+4*q^49,-q^42+7*q^44-27*q^45+27*q^46-7*q^47+q^49,3*q^45-6*q^46+
3*q^47,-210*q^42+210*q^43,72*q^42-138*q^43+72*q^44,-31*q^42+110*q^43-110*q^44+
31*q^45,-6*q^47+15*q^49-15*q^50+6*q^52,-8*q^42+27*q^43-38*q^44+27*q^45-8*q^46,
2*q^84-15*q^85+26*q^86-15*q^87+2*q^88,Unknown(),-420*q^63,16*q^15-8*q^16+
45*q^20-92*q^21+49*q^22+49*q^24-92*q^25+45*q^26-8*q^30+16*q^31,Unknown(),
17*q^63-55*q^64+55*q^65-17*q^66,Unknown(),Unknown(),-12*q^63+63*q^65-144*q^66+
63*q^67-12*q^69,Unknown(),q^63-7*q^65+27*q^66-27*q^67+7*q^68-q^70,-3*q^66+
6*q^67-3*q^68,-24*q^15-81*q^20+105*q^21-105*q^24+81*q^25+24*q^30,-72*q^63+
138*q^64-72*q^65,Unknown(),8*q^63-27*q^64+38*q^65-27*q^66+8*q^67,420*q^84,
Unknown(),100*q^84-220*q^85+100*q^86,q^21-12*q^22+36*q^23-36*q^24+12*q^25-
q^26,-210*q^84+210*q^85,72*q^84-138*q^85+72*q^86,Unknown(),-17*q^84+55*q^85-
55*q^86+17*q^87,-420*q^105,Unknown(),-100*q^105+220*q^106-100*q^107,210*q^105-
210*q^106,-72*q^105+138*q^106-72*q^107,Unknown(),17*q^105-55*q^106+55*q^107-
17*q^108];
  f107:=function(q,j)return [420,-170+250*q,34-136*q+114*q^2,68-204*q+148*q^2,
  -13+76*q-128*q^2+67*q^3,-3+31*q-71*q^2+43*q^3,(-9*j^2-10*j)*q+(33*j^2+39*j)*q^2+
27*q^3,-27+123*q-183*q^2+87*q^3,15+(39*j^2+33*j)*q+(-10*j^2-
9*j)*q^2+12*q^3,-6+(-25*j^2-23*j)*q+(27*j^2+22*j)*q^2+q^3+
7*q^4,2-22*q+64*q^2-74*q^3+30*q^4,-3*q+18*q^2-29*q^3+14*q^4,(-j^2-
3*j)*q^2+(7*j^2+10*j)*q^3+5*q^4,-3+(-23*j^2-20*j)*q+(46*j^2+
41*j)*q^2+(-31*j^2-30*j)*q^3-7*q^4,1-14*q+48*q^2-60*q^3+25*q^4,
(3*j^2+4*j)*q+(-20*j^2-22*j)*q^2+(30*j^2+34*j)*q^3+16*q^4,5-
38*q+98*q^2-104*q^3+39*q^4,q-9*q^2+23*q^3-23*q^4+8*q^5,1+(11*j^2+
10*j)*q+(-33*j^2-29*j)*q^2+(40*j^2+36*j)*q^3+21*q^4-4*q^5,-
j*q^3+(j^2+2*j)*q^4+q^5,Unknown(),-3*q+(-17*j^2-14*j)*q^2+
(28*j^2+25*j)*q^3+19*q^4-5*q^5,Unknown(),3*q-17*q^2+36*q^3-33*q^4+
11*q^5,-2*q^2+8*q^3-10*q^4+4*q^5,j*q^2+(-4*j^2-6*j)*q^3+(6*j^2+
8*j)*q^4+3*q^5,(30*j^2+27*j)*q^2+120*q^3+(117*j^2+99*j)*q^4+
27*q^6,0,Unknown(),-3*q^2+24*q^3+(36*j^2+33*j)*q^4+(-10*j^2-
7*j)*q^5+5*q^6,0,15+(18*j^2+20*j)*q+(33*j^2+39*j)*q^2+90*q^3+
(9*j^2+10*j)*q^4+(66*j^2+78*j)*q^5+42*q^6,Unknown(),Unknown(),(-
12*j^2-9*j)*q^2-66*q^3+(-120*j^2-114*j)*q^4+(69*j^2+
57*j)*q^5-11*q^6+16*q^7,j*q^3+(-5*j^2-7*j)*q^4+(8*j^2+
7*j)*q^5+(-2*j^2-j)*q^6+q^7,-6+(-15*j^2-17*j)*q+(-2*j^2-
4*j)*q^2+(55*j^2+59*j)*q^3+(-57*j^2-58*j)*q^4+(-22*j^2-
26*j)*q^5+(55*j^2+63*j)*q^6+25*q^7,(3*j^2+2*j)*q^2+(-10*j^2-
7*j)*q^3+(10*j^2+8*j)*q^4+4*q^5+(j^2+2*j)*q^6+q^7,q^2-12*q^3+(-
29*j^2-28*j)*q^4+(25*j^2+22*j)*q^5+(-4*j^2-2*j)*q^6+3*q^7,
(10*j^2+11*j)*q^3+(-34*j^2-33*j)*q^4+(29*j^2+23*j)*q^5+
5*q^7,Unknown(),-3+6*q+(-9*j^2-15*j)*q^2+(26*j^2+38*j)*q^3+
(12*j^2+2*j)*q^4+(-69*j^2-67*j)*q^5+(56*j^2+62*j)*q^6+
17*q^7,Unknown(),Unknown(),(5*j^2+6*j)*q^2+(-17*j^2-25*j)*q^3+
(14*j^2+26*j)*q^4+(22*j^2+13*j)*q^5+(-46*j^2-45*j)*q^6+
(28*j^2+30*j)*q^7+7*q^8,(j^2+4*j)*q^4+8*q^5+(6*j^2+4*j)*q^6+
q^8,3*j^2*q^126-18*j^2*q^127+29*j^2*q^128-14*j^2*q^129,
3*j*q^26-18*j*q^27+29*j*q^28-14*j*q^29,4*q^3+(20*j^2+
21*j)*q^4+(-32*j^2-29*j)*q^5+(17*j^2+13*j)*q^6-2*q^7+3*q^8,
Unknown(),Unknown(),1-4*q+(j^2+3*j)*q^2+(-15*j^2-24*j)*q^3+
(9*j^2+21*j)*q^4+(36*j^2+29*j)*q^5+(-63*j^2-65*j)*q^6+
(39*j^2+43*j)*q^7+10*q^8,Unknown(),Unknown(),Unknown(),-j*q^26+
9*j*q^27-23*j*q^28+23*j*q^29-8*j*q^30,Unknown(),Unknown(),-3*q^2+
6*q^3+(10*j^2+9*j)*q^4+30*q^5+(51*j^2+54*j)*q^6+(-26*j^2-
30*j)*q^7+17*q^8+(22*j^2+24*j)*q^9+7*q^10,0,Unknown(),Unknown(),0,
(6*j^2+4*j)*q^5+(-11*j^2-8*j)*q^6-4*q^7+(2*j^2+j)*q^8+q^10,
Unknown(),Unknown(),Unknown(),j^2*q^51-9*j^2*q^52+23*j^2*q^53-
23*j^2*q^54+8*j^2*q^55,Unknown(),Unknown(),-3*q^76+17*q^77-36*q^78+
33*q^79-11*q^80,Unknown(),Unknown(),-3*q^4+(-10*j^2-6*j)*q^5+(36*j^2+
28*j)*q^6+(-46*j^2-42*j)*q^7+(13*j^2+16*j)*q^8+(2*j^2-
4*j)*q^9+(7*j^2+10*j)*q^10+5*q^12,0,3*j^2*q^125+(-20*j^2+
3*j)*q^126+(41*j^2-5*j)*q^127+(-30*j^2+j)*q^128+7*j^2*q^129,
-3*j^2*q^126+17*j^2*q^127-36*j^2*q^128+33*j^2*q^129-
11*j^2*q^130,Unknown(),(15*j^2+6*j)*q^8+(-15*j^2-6*j)*q^9-
3*q^11+(2*j^2-j)*q^12,3*j*q^25+(-3*j^2-23*j)*q^26+(5*j^2+
46*j)*q^27+(-j^2-31*j)*q^28+7*j*q^29,Unknown(),j^2*q^50-
14*j^2*q^51+48*j^2*q^52-60*j^2*q^53+25*j^2*q^54,q^54,Unknown(),
Unknown(),-3*j^2*q^51+18*j^2*q^52-29*j^2*q^53+14*j^2*q^54,
Unknown(),-420*j*q^25,(2*j^2-j)*q^27+(-3*j^2+7*j)*q^28-
5*j*q^29,-68*j*q^25+204*j*q^26-148*j*q^27,Unknown(),3*j*q^25-
31*j*q^26+71*j*q^27-43*j*q^28,27*j*q^25-123*j*q^26+
183*j*q^27-87*j*q^28,-2*j*q^25+22*j*q^26-64*j*q^27+
74*j*q^28-30*j*q^29,Unknown(),(-j^2+3*j)*q^26+(2*j^2-
20*j)*q^27+(-4*j^2+30*j)*q^28-16*j*q^29,-5*j*q^25+38*j*q^26-
98*j*q^27+104*j*q^28-39*j*q^29,-j*q^25+(j^2+11*j)*q^26+(-
4*j^2-33*j)*q^27+(4*j^2+40*j)*q^28-21*j*q^29+4*j*q^30,
(3*j^2+30*j)*q^27-120*j*q^28+(18*j^2+117*j)*q^29-27*j*q^31,-
15*j*q^25+(-2*j^2+18*j)*q^26+(-6*j^2+33*j)*q^27-90*j*q^28+(-
j^2+9*j)*q^29+(-12*j^2+66*j)*q^30-42*j*q^31,(-j^2+
10*j)*q^28+(-j^2-34*j)*q^29+(6*j^2+29*j)*q^30-5*j*q^32,(-
3*j^2-12*j)*q^27+66*j*q^28+(-6*j^2-120*j)*q^29+(12*j^2+
69*j)*q^30+11*j*q^31-16*j*q^32,6*j*q^25+(2*j^2-15*j)*q^26+
(2*j^2-2*j)*q^27+(-4*j^2+55*j)*q^28+(j^2-57*j)*q^29+
(4*j^2-22*j)*q^30+(-8*j^2+55*j)*q^31-25*j*q^32,Unknown(),-
4*j*q^28+(-j^2+20*j)*q^29+(-3*j^2-32*j)*q^30+(4*j^2+
17*j)*q^31+2*j*q^32-3*j*q^33,(-3*j^2+j)*q^29-8*j*q^30+
(2*j^2+6*j)*q^31-j*q^33,(2*j^2+6*j)*q^30+(-3*j^2-
11*j)*q^31+4*j*q^32+(j^2+2*j)*q^33-j*q^35,170*j*q^25-
250*j*q^26,3*j*q^29+(-4*j^2-10*j)*q^30+(8*j^2+36*j)*q^31+(-
4*j^2-46*j)*q^32+(-3*j^2+13*j)*q^33+(6*j^2+2*j)*q^34+(-
3*j^2+7*j)*q^35-5*j*q^37,(j^2-9*j)*q^26+(-6*j^2+
33*j)*q^27-27*j*q^28,-34*j*q^25+136*j*q^26-114*j*q^27,
Unknown(),13*j*q^25-76*j*q^26+128*j*q^27-67*j*q^28,(9*j^2+
15*j)*q^33+(-9*j^2-15*j)*q^34+3*j*q^36+(3*j^2+2*j)*q^37,
Unknown(),Unknown(),3*q^76-18*q^77+29*q^78-14*q^79,Unknown(),0,-j*q^25+
14*j*q^26-48*j*q^27+60*j*q^28-25*j*q^29,Unknown(),420*j^2*q^50,
Unknown(),68*j^2*q^50-204*j^2*q^51+148*j^2*q^52,-3*j^2*q^50+
31*j^2*q^51-71*j^2*q^52+43*j^2*q^53,-27*j^2*q^50+123*j^2*q^51-
183*j^2*q^52+87*j^2*q^53,-6*j^2*q^50+(23*j^2-2*j)*q^51+(-
22*j^2+5*j)*q^52+j^2*q^53+7*j^2*q^54,j^2*q^50+(-10*j^2+
j)*q^51+(29*j^2-4*j)*q^52+(-36*j^2+4*j)*q^53+21*j^2*q^54-
4*j^2*q^55,Unknown(),(-27*j^2+3*j)*q^52+120*j^2*q^53+(-99*j^2+
18*j)*q^54+27*j^2*q^56,(9*j^2-3*j)*q^52-66*j^2*q^53+
(114*j^2-6*j)*q^54+(-57*j^2+12*j)*q^55-11*j^2*q^56+
16*j^2*q^57,(-11*j^2-j)*q^53+(33*j^2-j)*q^54+(-23*j^2+
6*j)*q^55+5*j^2*q^57,(-4*j^2-3*j)*q^54+8*j^2*q^55+(-4*j^2+
2*j)*q^56+j^2*q^58,-170*j^2*q^50+250*j^2*q^51,34*j^2*q^50-
136*j^2*q^51+114*j^2*q^52,-13*j^2*q^50+76*j^2*q^51-
128*j^2*q^52+67*j^2*q^53,(-6*j^2+9*j)*q^58+(6*j^2-9*j)*q^59-
3*j^2*q^61+(j^2+3*j)*q^62,-3*j^2*q^50+(20*j^2-3*j)*q^51+(-
41*j^2+5*j)*q^52+(30*j^2-j)*q^53-7*j^2*q^54,-3*j*q^101+
18*j*q^102-29*j*q^103+14*j*q^104,Unknown(),-420*q^75,49*q^24-92*q^25+
45*q^26+12*q^27-18*q^28+12*q^30-24*q^31-4*q^33+11*q^34+q^36-4*q^37,Unknown(),
3*q^75-31*q^76+71*q^77-43*q^78,Unknown(),Unknown(),(-30*j^2-27*j)*q^77-
120*q^78+(-117*j^2-99*j)*q^79-27*q^81,Unknown(),(-10*j^2-
11*j)*q^78+(34*j^2+33*j)*q^79+(-29*j^2-23*j)*q^80-5*q^82,(-
j^2-4*j)*q^79-8*q^80+(-6*j^2-4*j)*q^81-q^83,-105*q^24+81*q^25-
30*q^27-36*q^30+15*q^33-5*q^36,-34*q^75+136*q^76-114*q^77,Unknown(),3*q^75+
(23*j^2+20*j)*q^76+(-46*j^2-41*j)*q^77+(31*j^2+30*j)*q^78+
7*q^79,420*j*q^100,Unknown(),68*j*q^100-204*j*q^101+148*j*q^102,-
3*j*q^26+17*j*q^27-36*j*q^28+33*j*q^29-11*j*q^30,-
170*j*q^100+250*j*q^101,34*j*q^100-136*j*q^101+114*j*q^102,
Unknown(),-3*j*q^100+31*j*q^101-71*j*q^102+43*j*q^103,-
420*j^2*q^125,Unknown(),-68*j^2*q^125+204*j^2*q^126-148*j^2*q^127,
170*j^2*q^125-250*j^2*q^126,-34*j^2*q^125+136*j^2*q^126-
114*j^2*q^127,Unknown(),3*j^2*q^125-31*j^2*q^126+71*j^2*q^127-
43*j^2*q^128];end;
  f111:=function(q,j)return [420,-200+220*q,58-142*q+78*q^2,
96-208*q+116*q^2,-28+98*q-110*q^2+42*q^3,-11+47*q-57*q^2+21*q^3,-3+(-
16*j^2-24*j)*q+(27*j^2+30*j)*q^2+6*q^3,-48+144*q-168*q^2+60*q^3,
12+(30*j^2+27*j)*q+(-24*j^2-16*j)*q^2-9*q^3,-6+(-20*j^2-
19*j)*q+(28*j^2+22*j)*q^2+(-17*j^2-13*j)*q^3-4*q^4,8-40*q+
68*q^2-52*q^3+16*q^4,1-10*q+20*q^2-16*q^3+5*q^4,2*j*q+(-3*j^2-
7*j)*q^2+(2*j^2+3*j)*q^3,-6+(-29*j^2-27*j)*q+(47*j^2+
40*j)*q^2+(-35*j^2-29*j)*q^3-9*q^4,6-27*q+51*q^2-41*q^3+11*q^4,1+
(10*j^2+14*j)*q+(-21*j^2-26*j)*q^2+(16*j^2+18*j)*q^3+4*q^4,
15-59*q+102*q^2-81*q^3+21*q^4,-1+5*q-13*q^2+19*q^3-12*q^4+2*q^5,3+(17*j^2+
16*j)*q+(-38*j^2-34*j)*q^2+(41*j^2+34*j)*q^3+(-22*j^2-
19*j)*q^4-5*q^5,j*q^2-j*q^3,Unknown(),1-8*q+(-21*j^2-18*j)*q^2+
(25*j^2+20*j)*q^3+(-14*j^2-12*j)*q^4-3*q^5,Unknown(),-2+10*q-
24*q^2+31*q^3-19*q^4+4*q^5,q-4*q^2+6*q^3-4*q^4+q^5,-j*q+(j^2+
4*j)*q^2+(-3*j^2-5*j)*q^3+(j^2+2*j)*q^4,3+(72*j^2+
48*j)*q^2+120*q^3+(90*j^2+81*j)*q^4+6*q^6,0,Unknown(),-2*j^2*q+
(12*j^2+10*j)*q^2+25*q^3+(20*j^2+19*j)*q^4+(-3*j^2-2*j)*q^5,
0,18+(32*j^2+48*j)*q+(27*j^2+30*j)*q^2+90*q^3+(16*j^2+
24*j)*q^4+(54*j^2+60*j)*q^5+21*q^6,Unknown(),Unknown(),-1+2*q+(-
36*j^2-24*j)*q^2+(92*j^2+80*j)*q^3+(-106*j^2-103*j)*q^4+
(48*j^2+42*j)*q^5-2*q^6+4*q^7,(2*j^2+4*j)*q^3+(-3*j^2-
5*j)*q^4-2*q^5,-8+(-26*j^2-34*j)*q+(3*j^2+10*j)*q^2+(56*j^2+
58*j)*q^3+(-56*j^2-60*j)*q^4+(-18*j^2-16*j)*q^5+(37*j^2+
41*j)*q^6+12*q^7,q+(5*j^2+4*j)*q^2+(-11*j^2-7*j)*q^3+
(13*j^2+8*j)*q^4+(-7*j^2-5*j)*q^5-2*q^6,j^2*q+(-7*j^2-
5*j)*q^2+(18*j^2+17*j)*q^3+22*q^4+(12*j^2+11*j)*q^5+(-2*j^2-
j)*q^6,(-7*j^2-3*j)*q^2+(19*j^2+17*j)*q^3+(-23*j^2-
25*j)*q^4+(13*j^2+11*j)*q^5,Unknown(),-6+(-18*j^2-22*j)*q+
(12*j^2+8*j)*q^2+(8*j^2+25*j)*q^3+(8*j^2-13*j)*q^4+(-
43*j^2-31*j)*q^5+(36*j^2+38*j)*q^6+9*q^7,Unknown(),Unknown(),1-
4*q+j*q^2+(-10*j^2-21*j)*q^3+(13*j^2+32*j)*q^4+(5*j^2-
12*j)*q^5+(-21*j^2-15*j)*q^6-14*q^7+3*q^8,q^3+(2*j^2+5*j)*q^4+
(-3*j^2-4*j)*q^5-q^6,j*q^110-10*j*q^111+20*j*q^112-
16*j*q^113+5*j*q^114,j^2*q^22-10*j^2*q^23+20*j^2*q^24-
16*j^2*q^25+5*j^2*q^26,(4*j^2+2*j)*q^2+(-12*j^2-9*j)*q^3-
20*q^4+(-19*j^2-20*j)*q^5+(7*j^2+5*j)*q^6,Unknown(),Unknown(),3+
(13*j^2+15*j)*q+15*q^2-10*j*q^3+(j^2+20*j)*q^4+(26*j^2+
9*j)*q^5+(-41*j^2-35*j)*q^6+(22*j^2+24*j)*q^7+5*q^8,Unknown(),
Unknown(),Unknown(),-j^2*q^22+5*j^2*q^23-13*j^2*q^24+19*j^2*q^25-
12*j^2*q^26+2*j^2*q^27,Unknown(),Unknown(),1-2*q-4*q^2+(-18*j^2-
20*j)*q^3+(30*j^2+31*j)*q^4+(-42*j^2-40*j)*q^5+(46*j^2+
43*j)*q^6+(-24*j^2-26*j)*q^7+(-4*j^2-2*j)*q^8-10*q^9+3*q^10,0,
Unknown(),Unknown(),0,(-5*j^2-2*j)*q^4+(6*j^2+4*j)*q^5+(-5*j^2-
4*j)*q^6-2*q^7,Unknown(),Unknown(),Unknown(),-j*q^44+5*j*q^45-
13*j*q^46+19*j*q^47-12*j*q^48+2*j*q^49,Unknown(),Unknown(),-
2*q^66+10*q^67-24*q^68+31*q^69-19*q^70+4*q^71,Unknown(),Unknown(),2*j*q^2+
(-2*j^2-6*j)*q^3+(6*j^2+8*j)*q^4+(-26*j^2-18*j)*q^5+
(53*j^2+37*j)*q^6+(-40*j^2-32*j)*q^7+(15*j^2+16*j)*q^8+(-
8*j^2-10*j)*q^9+(2*j^2+3*j)*q^10,0,-6*j*q^110+(2*j^2+
29*j)*q^111+(-7*j^2-47*j)*q^112+(6*j^2+35*j)*q^113-
9*j*q^114,-2*j*q^110+10*j*q^111-24*j*q^112+31*j*q^113-
19*j*q^114+4*j*q^115,Unknown(),(3*j^2-6*j)*q^6-9*j^2*q^7-6*q^8+
(-5*j^2-2*j)*q^9+3*q^10,-6*j^2*q^22+(27*j^2-2*j)*q^23+(-
40*j^2+7*j)*q^24+(29*j^2-6*j)*q^25-9*j^2*q^26,Unknown(),
6*j*q^44-27*j*q^45+51*j*q^46-41*j*q^47+11*j*q^48,-j^2*q^47,
Unknown(),Unknown(),j*q^44-10*j*q^45+20*j*q^46-16*j*q^47+
5*j*q^48,Unknown(),420*j^2*q^22,2*q^23+(7*j^2+4*j)*q^24+(-
3*j^2-j)*q^25,96*j^2*q^22-208*j^2*q^23+116*j^2*q^24,Unknown(),-
11*j^2*q^22+47*j^2*q^23-57*j^2*q^24+21*j^2*q^25,-48*j^2*q^22+
144*j^2*q^23-168*j^2*q^24+60*j^2*q^25,8*j^2*q^22-40*j^2*q^23+
68*j^2*q^24-52*j^2*q^25+16*j^2*q^26,Unknown(),j^2*q^22+(-
14*j^2-4*j)*q^23+(26*j^2+5*j)*q^24+(-18*j^2-2*j)*q^25+
4*j^2*q^26,15*j^2*q^22-59*j^2*q^23+102*j^2*q^24-81*j^2*q^25+
21*j^2*q^26,3*j^2*q^22+(-16*j^2+j)*q^23+(34*j^2-4*j)*q^24+(-
34*j^2+7*j)*q^25+(19*j^2-3*j)*q^26-5*j^2*q^27,3*j^2*q^22+(-
48*j^2+24*j)*q^24+120*j^2*q^25+(-81*j^2+9*j)*q^26+
6*j^2*q^28,18*j^2*q^22+(-48*j^2-16*j)*q^23+(-30*j^2-
3*j)*q^24+90*j^2*q^25+(-24*j^2-8*j)*q^26+(-60*j^2-6*j)*q^27+
21*j^2*q^28,(3*j^2-4*j)*q^24+(-17*j^2+2*j)*q^25+(25*j^2+
2*j)*q^26+(-11*j^2+2*j)*q^27,-j^2*q^22+2*j^2*q^23+(24*j^2-
12*j)*q^24+(-80*j^2+12*j)*q^25+(103*j^2-3*j)*q^26+(-42*j^2+
6*j)*q^27-2*j^2*q^28+4*j^2*q^29,-8*j^2*q^22+(34*j^2+
8*j)*q^23+(-10*j^2-7*j)*q^24+(-58*j^2-2*j)*q^25+(60*j^2+
4*j)*q^26+(16*j^2-2*j)*q^27+(-41*j^2-4*j)*q^28+12*j^2*q^29,
Unknown(),(-2*j^2+2*j)*q^24+(9*j^2-3*j)*q^25-20*j^2*q^26+
(20*j^2+j)*q^27+(-5*j^2+2*j)*q^28,j^2*q^25+(-5*j^2-
3*j)*q^26+(4*j^2+j)*q^27-j^2*q^28,(2*j^2-3*j)*q^26+(-
4*j^2+2*j)*q^27+(4*j^2-j)*q^28-2*j^2*q^29,-200*j^2*q^22+
220*j^2*q^23,2*q^24+(6*j^2+4*j)*q^25+(-8*j^2-2*j)*q^26+
(18*j^2-8*j)*q^27+(-37*j^2+16*j)*q^28+(32*j^2-8*j)*q^29+(-
16*j^2-j)*q^30+(10*j^2+2*j)*q^31+(-3*j^2-j)*q^32,-
3*j^2*q^22+(24*j^2+8*j)*q^23+(-30*j^2-3*j)*q^24+6*j^2*q^25,
58*j^2*q^22-142*j^2*q^23+78*j^2*q^24,Unknown(),-28*j^2*q^22+
98*j^2*q^23-110*j^2*q^24+42*j^2*q^25,(6*j^2+9*j)*q^28-
9*j*q^29-6*j^2*q^30+(2*j^2-3*j)*q^31+3*j^2*q^32,Unknown(),
Unknown(),q^66-10*q^67+20*q^68-16*q^69+5*q^70,Unknown(),0,6*j^2*q^22-
27*j^2*q^23+51*j^2*q^24-41*j^2*q^25+11*j^2*q^26,Unknown(),
420*j*q^44,Unknown(),96*j*q^44-208*j*q^45+116*j*q^46,-
11*j*q^44+47*j*q^45-57*j*q^46+21*j*q^47,-48*j*q^44+
144*j*q^45-168*j*q^46+60*j*q^47,-6*j*q^44+(j^2+20*j)*q^45+(-
6*j^2-28*j)*q^46+(4*j^2+17*j)*q^47-4*j*q^48,3*j*q^44+(-
j^2-17*j)*q^45+(4*j^2+38*j)*q^46+(-7*j^2-41*j)*q^47+
(3*j^2+22*j)*q^48-5*j*q^49,Unknown(),3*j*q^44+(-24*j^2-
72*j)*q^46+120*j*q^47+(-9*j^2-90*j)*q^48+6*j*q^50,-j*q^44+
2*j*q^45+(12*j^2+36*j)*q^46+(-12*j^2-92*j)*q^47+(3*j^2+
106*j)*q^48+(-6*j^2-48*j)*q^49-2*j*q^50+4*j*q^51,(4*j^2+
7*j)*q^46+(-2*j^2-19*j)*q^47+(-2*j^2+23*j)*q^48+(-2*j^2-
13*j)*q^49,j*q^47+(3*j^2-2*j)*q^48+(-j^2+3*j)*q^49-
j*q^50,-200*j*q^44+220*j*q^45,58*j*q^44-142*j*q^45+
78*j*q^46,-28*j*q^44+98*j*q^45-110*j*q^46+42*j*q^47,(-9*j^2-
3*j)*q^50-9*q^51-6*j*q^52+(3*j^2+5*j)*q^53+3*j*q^54,-
6*j*q^44+(2*j^2+29*j)*q^45+(-7*j^2-47*j)*q^46+(6*j^2+
35*j)*q^47-9*j*q^48,j^2*q^88-10*j^2*q^89+20*j^2*q^90-
16*j^2*q^91+5*j^2*q^92,Unknown(),420*q^66,18*q^18-12*q^19-24*q^21+
21*q^22+28*q^24-68*q^25+45*q^26+4*q^27-6*q^28+2*q^30-4*q^31,Unknown(),-
11*q^66+47*q^67-57*q^68+21*q^69,Unknown(),Unknown(),3*q^66+(72*j^2+
48*j)*q^68+120*q^69+(90*j^2+81*j)*q^70+6*q^72,Unknown(),(-7*j^2-
3*j)*q^68+(19*j^2+17*j)*q^69+(-23*j^2-25*j)*q^70+(13*j^2+
11*j)*q^71,q^69+(2*j^2+5*j)*q^70+(-3*j^2-4*j)*q^71-q^72,-
30*q^18+45*q^21-60*q^24+81*q^25-10*q^27-6*q^30,58*q^66-142*q^67+78*q^68,
Unknown(),-6*q^66+(-29*j^2-27*j)*q^67+(47*j^2+40*j)*q^68+(-
35*j^2-29*j)*q^69-9*q^70,420*j^2*q^88,Unknown(),96*j^2*q^88-
208*j^2*q^89+116*j^2*q^90,-2*j^2*q^22+10*j^2*q^23-24*j^2*q^24+
31*j^2*q^25-19*j^2*q^26+4*j^2*q^27,-200*j^2*q^88+220*j^2*q^89,
58*j^2*q^88-142*j^2*q^89+78*j^2*q^90,Unknown(),-11*j^2*q^88+
47*j^2*q^89-57*j^2*q^90+21*j^2*q^91,420*j*q^110,Unknown(),
96*j*q^110-208*j*q^111+116*j*q^112,-200*j*q^110+220*j*q^111,
58*j*q^110-142*j*q^111+78*j*q^112,Unknown(),-11*j*q^110+
47*j*q^111-57*j*q^112+21*j*q^113];end;
  f115:=q->[504,-300+204*q,138-162*q+42*q^2,176-248*q+80*q^2,-79+156*q-92*q^2+15*q^3,-52+86*q-
38*q^2+4*q^3,-36+42*q-12*q^2,-102+222*q-150*q^2+30*q^3,-18-12*q+42*q^2-18*q^3,
9-q-28*q^2+29*q^3-7*q^4,34-90*q+80*q^2-26*q^3+2*q^4,16-36*q+23*q^2-4*q^3,7-
11*q+4*q^2,-7+35*q-50*q^2+26*q^3-4*q^4,29-73*q+60*q^2-17*q^3+q^4,20-40*q+
26*q^2-4*q^3,45-125*q+122*q^2-45*q^3+5*q^4,-9+27*q-30*q^2+12*q^3-q^4,4-24*q+
44*q^2-36*q^3+13*q^4-q^5,-1+2*q-q^2,Unknown(),6-22*q+30*q^2-18*q^3+4*q^4,
Unknown(),-12+39*q-46*q^2+22*q^3-3*q^4,-4+12*q-11*q^2+3*q^3,-4+9*q-7*q^2+
2*q^3,36-126*q^2+144*q^3-36*q^4,0,Unknown(),7+11*q-41*q^2+26*q^3-4*q^4,0,54-
84*q-12*q^2+108*q^3-42*q^4-24*q^5+18*q^6,Unknown(),Unknown(),-20+16*q+72*q^2-
142*q^3+80*q^4-12*q^5,-1-2*q+10*q^2-9*q^3+2*q^4,-31+71*q-28*q^2-70*q^3+66*q^4-
2*q^5-19*q^6+7*q^7,-1+q-2*q^2+9*q^3-9*q^4+2*q^5,-4-3*q+28*q^2-35*q^3+12*q^4-
q^5,-7+31*q^2-39*q^3+12*q^4,Unknown(),-21+68*q-78*q^2+7*q^3+36*q^4-11*q^5-
8*q^6+4*q^7,Unknown(),Unknown(),8-32*q+48*q^2-16*q^3-26*q^4+26*q^5-8*q^6,1-
6*q^2+11*q^3-6*q^4,-16*q^85+36*q^86-23*q^87+4*q^88,-16*q^17+36*q^18-23*q^19+
4*q^20,4-3*q-17*q^2+37*q^3-25*q^4+3*q^5,Unknown(),Unknown(),12-47*q+73*q^2-
38*q^3-16*q^4+20*q^5-q^6-5*q^7+q^8,Unknown(),Unknown(),Unknown(),9*q^17-
27*q^18+30*q^19-12*q^20+q^21,Unknown(),Unknown(),8-26*q+18*q^2+36*q^3-60*q^4+
30*q^5-10*q^6+10*q^7-4*q^8,0,Unknown(),Unknown(),0,1-2*q^2-4*q^3+11*q^4-4*q^5,
Unknown(),Unknown(),Unknown(),-9*q^34+27*q^35-30*q^36+12*q^37-q^38,Unknown(),
Unknown(),12*q^51-39*q^52+46*q^53-22*q^54+3*q^55,Unknown(),Unknown(),7-11*q^2-
4*q^3-13*q^4+48*q^5-42*q^6+10*q^7-4*q^8,0,7*q^85-35*q^86+50*q^87-26*q^88+
4*q^89,12*q^85-39*q^86+46*q^87-22*q^88+3*q^89,Unknown(),q^3+3*q^4-6*q^5-7*q^6+
15*q^7,7*q^17-35*q^18+50*q^19-26*q^20+4*q^21,Unknown(),29*q^34-73*q^35+
60*q^36-17*q^37+q^38,q^35-q^36,Unknown(),Unknown(),16*q^34-36*q^35+23*q^36-
4*q^37,Unknown(),-504*q^17,-7*q^17+11*q^18-4*q^19,-176*q^17+248*q^18-80*q^19,
Unknown(),52*q^17-86*q^18+38*q^19-4*q^20,102*q^17-222*q^18+150*q^19-30*q^20,-
34*q^17+90*q^18-80*q^19+26*q^20-2*q^21,Unknown(),-20*q^17+40*q^18-26*q^19+
4*q^20,-45*q^17+125*q^18-122*q^19+45*q^20-5*q^21,-4*q^17+24*q^18-44*q^19+
36*q^20-13*q^21+q^22,-36*q^17+126*q^19-144*q^20+36*q^21,-54*q^17+84*q^18+
12*q^19-108*q^20+42*q^21+24*q^22-18*q^23,7*q^17-31*q^19+39*q^20-12*q^21,
20*q^17-16*q^18-72*q^19+142*q^20-80*q^21+12*q^22,31*q^17-71*q^18+28*q^19+
70*q^20-66*q^21+2*q^22+19*q^23-7*q^24,Unknown(),-4*q^17+3*q^18+17*q^19-
37*q^20+25*q^21-3*q^22,-q^17+6*q^19-11*q^20+6*q^21,-q^17+2*q^19+4*q^20-
11*q^21+4*q^22,300*q^17-204*q^18,-7*q^17+11*q^19+4*q^20+13*q^21-48*q^22+
42*q^23-10*q^24+4*q^25,36*q^17-42*q^18+12*q^19,-138*q^17+162*q^18-42*q^19,
Unknown(),79*q^17-156*q^18+92*q^19-15*q^20,-q^20-3*q^21+6*q^22+7*q^23-15*q^24,
Unknown(),Unknown(),-16*q^51+36*q^52-23*q^53+4*q^54,Unknown(),0,-29*q^17+
73*q^18-60*q^19+17*q^20-q^21,Unknown(),504*q^34,Unknown(),176*q^34-248*q^35+
80*q^36,-52*q^34+86*q^35-38*q^36+4*q^37,-102*q^34+222*q^35-150*q^36+30*q^37,
9*q^34-q^35-28*q^36+29*q^37-7*q^38,4*q^34-24*q^35+44*q^36-36*q^37+13*q^38-
q^39,Unknown(),36*q^34-126*q^36+144*q^37-36*q^38,-20*q^34+16*q^35+72*q^36-
142*q^37+80*q^38-12*q^39,-7*q^34+31*q^36-39*q^37+12*q^38,q^34-6*q^36+11*q^37-
6*q^38,-300*q^34+204*q^35,138*q^34-162*q^35+42*q^36,-79*q^34+156*q^35-92*q^36+
15*q^37,q^37+3*q^38-6*q^39-7*q^40+15*q^41,-7*q^34+35*q^35-50*q^36+26*q^37-
4*q^38,16*q^68-36*q^69+23*q^70-4*q^71,Unknown(),-504*q^51,-8*q^9+2*q^10+
11*q^12-4*q^13-8*q^15+4*q^16-12*q^18+8*q^19+45*q^20-116*q^21+70*q^22,
Unknown(),52*q^51-86*q^52+38*q^53-4*q^54,Unknown(),Unknown(),-36*q^51+
126*q^53-144*q^54+36*q^55,Unknown(),7*q^51-31*q^53+39*q^54-12*q^55,-q^51+
6*q^53-11*q^54+6*q^55,10*q^9-15*q^12+12*q^15+20*q^18-81*q^20+150*q^21,-
138*q^51+162*q^52-42*q^53,Unknown(),7*q^51-35*q^52+50*q^53-26*q^54+4*q^55,
504*q^68,Unknown(),176*q^68-248*q^69+80*q^70,12*q^17-39*q^18+46*q^19-22*q^20+
3*q^21,-300*q^68+204*q^69,138*q^68-162*q^69+42*q^70,Unknown(),-52*q^68+
86*q^69-38*q^70+4*q^71,-504*q^85,Unknown(),-176*q^85+248*q^86-80*q^87,
300*q^85-204*q^86,-138*q^85+162*q^86-42*q^87,Unknown(),52*q^85-86*q^86+
38*q^87-4*q^88];
  f117:=q->[504,-264+240*q,93-171*q+69*q^2,140-248*q+116*q^2,
-51+131*q-117*q^2+34*q^3,-24+69*q-55*q^2+14*q^3,-12+30*q-24*q^2,-75+195*q-
177*q^2+57*q^3,9-24*q+30*q^2-21*q^3,-3+18*q-28*q^2+25*q^3-10*q^4,20-62*q+
80*q^2-48*q^3+10*q^4,5-19*q+23*q^2-12*q^3+2*q^4,1-3*q+2*q^2,-10+37*q-52*q^2+
35*q^3-10*q^4,14-47*q+60*q^2-34*q^3+7*q^4,8-20*q+26*q^2-12*q^3,28-93*q+
121*q^2-74*q^3+17*q^4,-3+13*q-20*q^2+17*q^3-7*q^4+q^5,5-24*q+45*q^2-43*q^3+
22*q^4-5*q^5,q^2,Unknown(),3-15*q+28*q^2-24*q^3+11*q^4-2*q^5,Unknown(),-6+
22*q-34*q^2+30*q^3-13*q^4+2*q^5,-1+4*q-6*q^2+5*q^3-2*q^4,-1+2*q-2*q^2+q^3,12-
90*q^2+168*q^3-72*q^4,0,Unknown(),1+3*q-25*q^2+37*q^3-14*q^4,0,33-60*q-24*q^2+
126*q^3-30*q^4-48*q^5+21*q^6,Unknown(),Unknown(),-8+4*q+48*q^2-130*q^3+
116*q^4-36*q^5,3*q^2-5*q^3+2*q^4,-19+46*q-16*q^2-78*q^3+76*q^4+10*q^5-35*q^6+
10*q^7,2*q-7*q^2+11*q^3-12*q^4+8*q^5-2*q^6,-1-2*q+15*q^2-30*q^3+25*q^4-7*q^5,-
1+12*q^2-35*q^3+28*q^4-4*q^5,Unknown(),-12+40*q-37*q^2-14*q^3+20*q^4+21*q^5-
28*q^6+10*q^7,Unknown(),Unknown(),3-14*q+18*q^2+5*q^3-24*q^4+10*q^5+8*q^6-
8*q^7+2*q^8,-q^2+4*q^3-4*q^4+q^5,-5*q^100+19*q^101-23*q^102+12*q^103-2*q^104,-
5*q^20+19*q^21-23*q^22+12*q^23-2*q^24,1-7*q^2+24*q^3-30*q^4+16*q^5-2*q^6,
Unknown(),Unknown(),7-27*q+39*q^2-9*q^3-18*q^4-q^5+25*q^6-19*q^7+5*q^8,
Unknown(),Unknown(),Unknown(),3*q^20-13*q^21+20*q^22-17*q^23+7*q^24-q^25,
Unknown(),Unknown(),3-10*q+q^2+28*q^3-48*q^4+46*q^5-36*q^6+20*q^7-3*q^8-4*q^9+
2*q^10,0,Unknown(),Unknown(),0,-2*q^3+7*q^4-10*q^5+4*q^6,Unknown(),Unknown(),
Unknown(),-3*q^40+13*q^41-20*q^42+17*q^43-7*q^44+q^45,Unknown(),Unknown(),
6*q^60-22*q^61+34*q^62-30*q^63+13*q^64-2*q^65,Unknown(),Unknown(),1-3*q^2+
6*q^3-5*q^4+38*q^5-45*q^6+32*q^7-14*q^8+8*q^9,0,10*q^100-37*q^101+52*q^102-
35*q^103+10*q^104,6*q^100-22*q^101+34*q^102-30*q^103+13*q^104-2*q^105,
Unknown(),3*q^5-2*q^6+15*q^7-12*q^8+2*q^9,10*q^20-37*q^21+52*q^22-35*q^23+
10*q^24,Unknown(),14*q^40-47*q^41+60*q^42-34*q^43+7*q^44,q^42-q^43,Unknown(),
Unknown(),5*q^40-19*q^41+23*q^42-12*q^43+2*q^44,Unknown(),-504*q^20,-q^20+
3*q^21-2*q^22,-140*q^20+248*q^21-116*q^22,Unknown(),24*q^20-69*q^21+55*q^22-
14*q^23,75*q^20-195*q^21+177*q^22-57*q^23,-20*q^20+62*q^21-80*q^22+48*q^23-
10*q^24,Unknown(),-8*q^20+20*q^21-26*q^22+12*q^23,-28*q^20+93*q^21-121*q^22+
74*q^23-17*q^24,-5*q^20+24*q^21-45*q^22+43*q^23-22*q^24+5*q^25,-12*q^20+
90*q^22-168*q^23+72*q^24,-33*q^20+60*q^21+24*q^22-126*q^23+30*q^24+48*q^25-
21*q^26,q^20-12*q^22+35*q^23-28*q^24+4*q^25,8*q^20-4*q^21-48*q^22+130*q^23-
116*q^24+36*q^25,19*q^20-46*q^21+16*q^22+78*q^23-76*q^24-10*q^25+35*q^26-
10*q^27,Unknown(),-q^20+7*q^22-24*q^23+30*q^24-16*q^25+2*q^26,q^22-4*q^23+
4*q^24-q^25,2*q^23-7*q^24+10*q^25-4*q^26,264*q^20-240*q^21,-q^20+3*q^22-
6*q^23+5*q^24-38*q^25+45*q^26-32*q^27+14*q^28-8*q^29,12*q^20-30*q^21+24*q^22,-
93*q^20+171*q^21-69*q^22,Unknown(),51*q^20-131*q^21+117*q^22-34*q^23,-3*q^25+
2*q^26-15*q^27+12*q^28-2*q^29,Unknown(),Unknown(),-5*q^60+19*q^61-23*q^62+
12*q^63-2*q^64,Unknown(),0,-14*q^20+47*q^21-60*q^22+34*q^23-7*q^24,Unknown(),
504*q^40,Unknown(),140*q^40-248*q^41+116*q^42,-24*q^40+69*q^41-55*q^42+
14*q^43,-75*q^40+195*q^41-177*q^42+57*q^43,-3*q^40+18*q^41-28*q^42+25*q^43-
10*q^44,5*q^40-24*q^41+45*q^42-43*q^43+22*q^44-5*q^45,Unknown(),12*q^40-
90*q^42+168*q^43-72*q^44,-8*q^40+4*q^41+48*q^42-130*q^43+116*q^44-36*q^45,-
q^40+12*q^42-35*q^43+28*q^44-4*q^45,-q^42+4*q^43-4*q^44+q^45,-264*q^40+
240*q^41,93*q^40-171*q^41+69*q^42,-51*q^40+131*q^41-117*q^42+34*q^43,3*q^45-
2*q^46+15*q^47-12*q^48+2*q^49,-10*q^40+37*q^41-52*q^42+35*q^43-10*q^44,5*q^80-
19*q^81+23*q^82-12*q^83+2*q^84,Unknown(),-504*q^60,-20*q^15+10*q^16+12*q^18-
8*q^19+45*q^20-116*q^21+70*q^22+35*q^24-40*q^25-8*q^27+12*q^28,Unknown(),
24*q^60-69*q^61+55*q^62-14*q^63,Unknown(),Unknown(),-12*q^60+90*q^62-168*q^63+
72*q^64,Unknown(),q^60-12*q^62+35*q^63-28*q^64+4*q^65,q^62-4*q^63+4*q^64-q^65,
30*q^15-20*q^18-81*q^20+150*q^21-75*q^24+20*q^27,-93*q^60+171*q^61-69*q^62,
Unknown(),10*q^60-37*q^61+52*q^62-35*q^63+10*q^64,504*q^80,Unknown(),140*q^80-
248*q^81+116*q^82,6*q^20-22*q^21+34*q^22-30*q^23+13*q^24-2*q^25,-264*q^80+
240*q^81,93*q^80-171*q^81+69*q^82,Unknown(),-24*q^80+69*q^81-55*q^82+14*q^83,-
504*q^100,Unknown(),-140*q^100+248*q^101-116*q^102,264*q^100-240*q^101,-
93*q^100+171*q^101-69*q^102,Unknown(),24*q^100-69*q^101+55*q^102-14*q^103];
  f119:=function(q,j) return [540,-270+
270*q,90-180*q+90*q^2,132-276*q+132*q^2,-42+138*q-138*q^2+42*q^3,-21+69*q-
69*q^2+21*q^3,-9+(-36*j^2-27*j)*q+(36*j^2+27*j)*q^2+9*q^3,-63+
207*q-207*q^2+63*q^3,9+(27*j^2+36*j)*q+(-27*j^2-36*j)*q^2-9*q^3,-
5+(-18*j^2-24*j)*q+(26*j^2+32*j)*q^2+(-18*j^2-24*j)*q^3-
5*q^4,12-60*q+96*q^2-60*q^3+12*q^4,3-18*q+30*q^2-18*q^3+3*q^4,(5*j^2+
2*j)*q+(-10*j^2-4*j)*q^2+(5*j^2+2*j)*q^3,-9+(-34*j^2-
40*j)*q+(50*j^2+62*j)*q^2+(-34*j^2-40*j)*q^3-9*q^4,9-45*q+
72*q^2-45*q^3+9*q^4,4+(21*j^2+18*j)*q+(-40*j^2-28*j)*q^2+
(21*j^2+18*j)*q^3+4*q^4,19-90*q+142*q^2-90*q^3+19*q^4,-1+10*q-25*q^2+
25*q^3-10*q^4+q^5,4+(21*j^2+25*j)*q+(-43*j^2-51*j)*q^2+(43*j^2+
51*j)*q^3+(-21*j^2-25*j)*q^4-4*q^5,2*j^2*q^2-2*j^2*q^3,
Unknown(),2+(12*j^2+15*j)*q+(-26*j^2-31*j)*q^2+(26*j^2+
31*j)*q^3+(-12*j^2-15*j)*q^4-2*q^5,Unknown(),-2+17*q-41*q^2+41*q^3-
17*q^4+2*q^5,3*q-9*q^2+9*q^3-3*q^4,(-2*j^2-j)*q+(8*j^2+3*j)*q^2+(-
8*j^2-3*j)*q^3+(2*j^2+j)*q^4,9+(81*j^2+108*j)*q^2+144*q^3+
(81*j^2+108*j)*q^4+9*q^6,-j*q^3,Unknown(),(-2*j^2-5*j)*q+
(18*j^2+21*j)*q^2+32*q^3+(18*j^2+21*j)*q^4+(-2*j^2-5*j)*q^5,
-j^2*q^15,27+(72*j^2+54*j)*q+(36*j^2+27*j)*q^2+108*q^3+
(36*j^2+27*j)*q^4+(72*j^2+54*j)*q^5+27*q^6,Unknown(),Unknown(),-4+
5*q+(-39*j^2-48*j)*q^2+(114*j^2+132*j)*q^3+(-114*j^2-
132*j)*q^4+(39*j^2+48*j)*q^5-5*q^6+4*q^7,(-2*j^2-j)*q^2+
(6*j^2+5*j)*q^3+(-6*j^2-5*j)*q^4+(2*j^2+j)*q^5,-13+(-
46*j^2-40*j)*q+(20*j^2+14*j)*q^2+(70*j^2+67*j)*q^3+(-
70*j^2-67*j)*q^4+(-20*j^2-14*j)*q^5+(46*j^2+40*j)*q^6+
13*q^7,q+(6*j^2+7*j)*q^2+(-9*j^2-16*j)*q^3+(9*j^2+16*j)*q^4+
(-6*j^2-7*j)*q^5-q^6,(j^2+2*j)*q+(-9*j^2-12*j)*q^2+
(26*j^2+28*j)*q^3+(-26*j^2-28*j)*q^4+(9*j^2+12*j)*q^5+(-
j^2-2*j)*q^6,(-9*j^2-15*j)*q^2-27*q^3+27*q^4+(9*j^2+
15*j)*q^5,Unknown(),-9+(-38*j^2-32*j)*q+(24*j^2+36*j)*q^2+
(19*j^2-11*j)*q^3+(-19*j^2+11*j)*q^4+(-24*j^2-36*j)*q^5+
(38*j^2+32*j)*q^6+9*q^7,Unknown(),Unknown(),2-8*q+(-5*j^2-
12*j)*q^2+(-12*j^2+8*j)*q^3+(22*j^2-4*j)*q^4+(-12*j^2+
8*j)*q^5+(-5*j^2-12*j)*q^6-8*q^7+2*q^8,j^2*q^2+(-4*j^2-
3*j)*q^3-6*q^4+(-4*j^2-3*j)*q^5+j^2*q^6,-3*j^2*q^105+
18*j^2*q^106-30*j^2*q^107+18*j^2*q^108-3*j^2*q^109,-3*j*q^21+
18*j*q^22-30*j*q^23+18*j*q^24-3*j*q^25,(4*j^2+6*j)*q^2+(-
18*j^2-21*j)*q^3+(28*j^2+30*j)*q^4+(-18*j^2-21*j)*q^5+
(4*j^2+6*j)*q^6,Unknown(),Unknown(),4+(21*j^2+19*j)*q+(-29*j^2-
33*j)*q^2+(5*j^2+25*j)*q^3+(14*j^2-14*j)*q^4+(5*j^2+
25*j)*q^5+(-29*j^2-33*j)*q^6+(21*j^2+19*j)*q^7+4*q^8,Unknown(),
Unknown(),Unknown(),j*q^21-10*j*q^22+25*j*q^23-25*j*q^24+
10*j*q^25-j*q^26,Unknown(),Unknown(),2-6*q+(7*j^2+2*j)*q^2+(-
30*j^2-26*j)*q^3+(35*j^2+40*j)*q^4+(-32*j^2-40*j)*q^5+
(35*j^2+40*j)*q^6+(-30*j^2-26*j)*q^7+(7*j^2+2*j)*q^8-6*q^9+
2*q^10,j^2*q^6,Unknown(),Unknown(),j*q^12,2*j*q^3+(-4*j^2-
6*j)*q^4-8*q^5+(-4*j^2-6*j)*q^6+2*j*q^7,Unknown(),Unknown(),
Unknown(),-j^2*q^42+10*j^2*q^43-25*j^2*q^44+25*j^2*q^45-
10*j^2*q^46+j^2*q^47,Unknown(),Unknown(),2*q^63-17*q^64+41*q^65-41*q^66+
17*q^67-2*q^68,Unknown(),Unknown(),(5*j^2+2*j)*q^2-6*j^2*q^3+
(13*j^2+10*j)*q^4+(-36*j^2-48*j)*q^5+(48*j^2+72*j)*q^6+(-
36*j^2-48*j)*q^7+(13*j^2+10*j)*q^8-6*j^2*q^9+(5*j^2+
2*j)*q^10,-q^9,9*j^2*q^105+(-40*j^2-6*j)*q^106+(62*j^2+
12*j)*q^107+(-40*j^2-6*j)*q^108+9*j^2*q^109,2*j^2*q^105-
17*j^2*q^106+41*j^2*q^107-41*j^2*q^108+17*j^2*q^109-
2*j^2*q^110,Unknown(),(-3*j^2+3*j)*q^6-9*j*q^7+9*j*q^8+
(3*j^2-3*j)*q^9,9*j*q^21+(6*j^2-34*j)*q^22+(-12*j^2+
50*j)*q^23+(6*j^2-34*j)*q^24+9*j*q^25,Unknown(),9*j^2*q^42-
45*j^2*q^43+72*j^2*q^44-45*j^2*q^45+9*j^2*q^46,(j^2+
2*j)*q^44+(-j^2-2*j)*q^45,Unknown(),Unknown(),3*j^2*q^42-
18*j^2*q^43+30*j^2*q^44-18*j^2*q^45+3*j^2*q^46,Unknown(),-
540*j*q^21,(3*j^2+5*j)*q^22+(-6*j^2-10*j)*q^23+(3*j^2+
5*j)*q^24,-132*j*q^21+276*j*q^22-132*j*q^23,Unknown(),
21*j*q^21-69*j*q^22+69*j*q^23-21*j*q^24,63*j*q^21-
207*j*q^22+207*j*q^23-63*j*q^24,-12*j*q^21+60*j*q^22-
96*j*q^23+60*j*q^24-12*j*q^25,Unknown(),-4*j*q^21+(3*j^2+
21*j)*q^22+(-12*j^2-40*j)*q^23+(3*j^2+21*j)*q^24-4*j*q^25,-
19*j*q^21+90*j*q^22-142*j*q^23+90*j*q^24-19*j*q^25,-
4*j*q^21+(-4*j^2+21*j)*q^22+(8*j^2-43*j)*q^23+(-8*j^2+
43*j)*q^24+(4*j^2-21*j)*q^25+4*j*q^26,-9*j*q^21+(-27*j^2+
81*j)*q^23-144*j*q^24+(-27*j^2+81*j)*q^25-9*j*q^27,-
27*j*q^21+(18*j^2+72*j)*q^22+(9*j^2+36*j)*q^23-108*j*q^24+
(9*j^2+36*j)*q^25+(18*j^2+72*j)*q^26-27*j*q^27,(6*j^2-
9*j)*q^23+27*j*q^24-27*j*q^25+(-6*j^2+9*j)*q^26,4*j*q^21-
5*j*q^22+(9*j^2-39*j)*q^23+(-18*j^2+114*j)*q^24+(18*j^2-
114*j)*q^25+(-9*j^2+39*j)*q^26+5*j*q^27-4*j*q^28,13*j*q^21+
(-6*j^2-46*j)*q^22+(6*j^2+20*j)*q^23+(3*j^2+70*j)*q^24+(-
3*j^2-70*j)*q^25+(-6*j^2-20*j)*q^26+(6*j^2+46*j)*q^27-
13*j*q^28,Unknown(),(-2*j^2+4*j)*q^23+(3*j^2-18*j)*q^24+(-
2*j^2+28*j)*q^25+(3*j^2-18*j)*q^26+(-2*j^2+4*j)*q^27,-q^23+
(-j^2-4*j)*q^24+6*j*q^25+(-j^2-4*j)*q^26-q^27,-2*j^2*q^24+
(2*j^2-4*j)*q^25+8*j*q^26+(2*j^2-4*j)*q^27-2*j^2*q^28,
270*j*q^21-270*j*q^22,(3*j^2+5*j)*q^23+6*q^24+(3*j^2+
13*j)*q^25+(12*j^2-36*j)*q^26+(-24*j^2+48*j)*q^27+(12*j^2-
36*j)*q^28+(3*j^2+13*j)*q^29+6*q^30+(3*j^2+5*j)*q^31,
9*j*q^21+(-9*j^2-36*j)*q^22+(9*j^2+36*j)*q^23-9*j*q^24,-
90*j*q^21+180*j*q^22-90*j*q^23,Unknown(),42*j*q^21-138*j*q^22+
138*j*q^23-42*j*q^24,(-6*j^2-3*j)*q^27+9*j^2*q^28-
9*j^2*q^29+(6*j^2+3*j)*q^30,Unknown(),Unknown(),-3*q^63+18*q^64-
30*q^65+18*q^66-3*q^67,Unknown(),q^18,-9*j*q^21+45*j*q^22-72*j*q^23+
45*j*q^24-9*j*q^25,Unknown(),540*j^2*q^42,Unknown(),132*j^2*q^42-
276*j^2*q^43+132*j^2*q^44,-21*j^2*q^42+69*j^2*q^43-69*j^2*q^44+
21*j^2*q^45,-63*j^2*q^42+207*j^2*q^43-207*j^2*q^44+63*j^2*q^45,
-5*j^2*q^42+(24*j^2+6*j)*q^43+(-32*j^2-6*j)*q^44+(24*j^2+
6*j)*q^45-5*j^2*q^46,4*j^2*q^42+(-25*j^2-4*j)*q^43+(51*j^2+
8*j)*q^44+(-51*j^2-8*j)*q^45+(25*j^2+4*j)*q^46-4*j^2*q^47,
Unknown(),9*j^2*q^42+(-108*j^2-27*j)*q^44+144*j^2*q^45+(-
108*j^2-27*j)*q^46+9*j^2*q^48,-4*j^2*q^42+5*j^2*q^43+
(48*j^2+9*j)*q^44+(-132*j^2-18*j)*q^45+(132*j^2+18*j)*q^46+
(-48*j^2-9*j)*q^47-5*j^2*q^48+4*j^2*q^49,(15*j^2+6*j)*q^44-
27*j^2*q^45+27*j^2*q^46+(-15*j^2-6*j)*q^47,j*q^44+(3*j^2-
j)*q^45-6*j^2*q^46+(3*j^2-j)*q^47+j*q^48,-270*j^2*q^42+
270*j^2*q^43,90*j^2*q^42-180*j^2*q^43+90*j^2*q^44,-42*j^2*q^42+
138*j^2*q^43-138*j^2*q^44+42*j^2*q^45,(-3*j^2-6*j)*q^48-9*q^49+
9*q^50+(3*j^2+6*j)*q^51,-9*j^2*q^42+(40*j^2+6*j)*q^43+(-
62*j^2-12*j)*q^44+(40*j^2+6*j)*q^45-9*j^2*q^46,3*j*q^84-
18*j*q^85+30*j*q^86-18*j*q^87+3*j*q^88,Unknown(),-540*q^63,
45*q^20-60*q^21+21*q^22+21*q^24-60*q^25+45*q^26,Unknown(),21*q^63-69*q^64+
69*q^65-21*q^66,Unknown(),Unknown(),-9*q^63+(-81*j^2-108*j)*q^65-
144*q^66+(-81*j^2-108*j)*q^67-9*q^69,Unknown(),(9*j^2+15*j)*q^65+
27*q^66-27*q^67+(-9*j^2-15*j)*q^68,-j^2*q^65+(4*j^2+3*j)*q^66+
6*q^67+(4*j^2+3*j)*q^68-j^2*q^69,-81*q^20+45*q^21-45*q^24+81*q^25,-
90*q^63+180*q^64-90*q^65,Unknown(),9*q^63+(34*j^2+40*j)*q^64+(-
50*j^2-62*j)*q^65+(34*j^2+40*j)*q^66+9*q^67,540*j*q^84,
Unknown(),132*j*q^84-276*j*q^85+132*j*q^86,2*j*q^21-17*j*q^22+
41*j*q^23-41*j*q^24+17*j*q^25-2*j*q^26,-270*j*q^84+
270*j*q^85,90*j*q^84-180*j*q^85+90*j*q^86,Unknown(),-21*j*q^84+
69*j*q^85-69*j*q^86+21*j*q^87,-540*j^2*q^105,Unknown(),-
132*j^2*q^105+276*j^2*q^106-132*j^2*q^107,270*j^2*q^105-
270*j^2*q^106,-90*j^2*q^105+180*j^2*q^106-90*j^2*q^107,Unknown(),
21*j^2*q^105-69*j^2*q^106+69*j^2*q^107-21*j^2*q^108];end;
  f121:=function(q,j)return [540,-270+270*q,90-180*q+90*q^2,132-276*q+
132*q^2,-42+138*q-138*q^2+42*q^3,-21+69*q-69*q^2+21*q^3,-9+(-36*j^2-
27*j)*q+(27*j^2+36*j)*q^2+9*q^3,-63+207*q-207*q^2+63*q^3,9+
(36*j^2+27*j)*q+(-27*j^2-36*j)*q^2-9*q^3,-5+(-24*j^2-
18*j)*q-29*q^2+(-18*j^2-24*j)*q^3-5*q^4,12-60*q+96*q^2-60*q^3+12*q^4,
3-18*q+30*q^2-18*q^3+3*q^4,(5*j^2+2*j)*q+7*q^2+(2*j^2+5*j)*q^3,-9+
(-40*j^2-34*j)*q-56*q^2+(-34*j^2-40*j)*q^3-9*q^4,9-45*q+72*q^2-
45*q^3+9*q^4,4+(21*j^2+18*j)*q+34*q^2+(18*j^2+21*j)*q^3+4*q^4,19-
90*q+142*q^2-90*q^3+19*q^4,-1+10*q-25*q^2+25*q^3-10*q^4+q^5,4+(25*j^2+
21*j)*q+(-49*j^2-45*j)*q^2+(45*j^2+49*j)*q^3+(-21*j^2-
25*j)*q^4-4*q^5,-q^2+q^3,Unknown(),2+(15*j^2+12*j)*q+(-30*j^2-
27*j)*q^2+(27*j^2+30*j)*q^3+(-12*j^2-15*j)*q^4-2*q^5,Unknown(),
-2+17*q-41*q^2+41*q^3-17*q^4+2*q^5,3*q-9*q^2+9*q^3-3*q^4,(-2*j^2-j)*q+
(6*j^2+5*j)*q^2+(-5*j^2-6*j)*q^3+(j^2+2*j)*q^4,9+(81*j^2+
108*j)*q^2+144*q^3+(108*j^2+81*j)*q^4+9*q^6,-q^3,Unknown(),(-
2*j^2-5*j)*q+(18*j^2+21*j)*q^2+32*q^3+(21*j^2+18*j)*q^4+(-
5*j^2-2*j)*q^5,-q^15,27+(72*j^2+54*j)*q+(27*j^2+36*j)*q^2+
108*q^3+(36*j^2+27*j)*q^4+(54*j^2+72*j)*q^5+27*q^6,Unknown(),
Unknown(),-4+5*q+(-39*j^2-48*j)*q^2+(114*j^2+132*j)*q^3+(-
132*j^2-114*j)*q^4+(48*j^2+39*j)*q^5-5*q^6+4*q^7,(-2*j^2-
j)*q^2+(6*j^2+5*j)*q^3+(-5*j^2-6*j)*q^4+(j^2+2*j)*q^5,-
13+(-46*j^2-40*j)*q+(26*j^2+8*j)*q^2+(67*j^2+70*j)*q^3+(-
70*j^2-67*j)*q^4+(-8*j^2-26*j)*q^5+(40*j^2+46*j)*q^6+13*q^7,
q+(7*j^2+6*j)*q^2+(-13*j^2-12*j)*q^3+(12*j^2+13*j)*q^4+(-
6*j^2-7*j)*q^5-q^6,(j^2+2*j)*q+(-9*j^2-12*j)*q^2+(26*j^2+
28*j)*q^3+(-28*j^2-26*j)*q^4+(12*j^2+9*j)*q^5+(-2*j^2-
j)*q^6,(-9*j^2-15*j)*q^2+(24*j^2+30*j)*q^3+(-30*j^2-
24*j)*q^4+(15*j^2+9*j)*q^5,Unknown(),-9+(-38*j^2-32*j)*q+
(36*j^2+24*j)*q^2+(j^2+7*j)*q^3+(-7*j^2-j)*q^4+(-24*j^2-
36*j)*q^5+(32*j^2+38*j)*q^6+9*q^7,Unknown(),Unknown(),2-8*q+(-
12*j^2-5*j)*q^2+(2*j^2-6*j)*q^3-9*q^4+(-6*j^2+2*j)*q^5+(-
5*j^2-12*j)*q^6-8*q^7+2*q^8,j^2*q^2+(-3*j^2-4*j)*q^3-6*q^4+(-
4*j^2-3*j)*q^5+j*q^6,-3*q^105+18*q^106-30*q^107+18*q^108-3*q^109,-
3*q^21+18*q^22-30*q^23+18*q^24-3*q^25,(4*j^2+6*j)*q^2+(-16*j^2-
23*j)*q^3-29*q^4+(-23*j^2-16*j)*q^5+(6*j^2+4*j)*q^6,Unknown(),
Unknown(),4+(21*j^2+19*j)*q+(-37*j^2-25*j)*q^2+(21*j^2+
9*j)*q^3+(9*j^2+21*j)*q^5+(-25*j^2-37*j)*q^6+(19*j^2+
21*j)*q^7+4*q^8,Unknown(),Unknown(),Unknown(),q^21-10*q^22+25*q^23-25*q^24+
10*q^25-q^26,Unknown(),Unknown(),2-6*q+(4*j^2+5*j)*q^2+28*q^3+
(39*j^2+36*j)*q^4+36*q^5+(36*j^2+39*j)*q^6+28*q^7+(5*j^2+
4*j)*q^8-6*q^9+2*q^10,q^6,Unknown(),Unknown(),q^12,2*j*q^3+(-3*j^2-
7*j)*q^4-8*q^5+(-7*j^2-3*j)*q^6+2*j^2*q^7,Unknown(),Unknown(),
Unknown(),-q^42+10*q^43-25*q^44+25*q^45-10*q^46+q^47,Unknown(),Unknown(),
2*q^63-17*q^64+41*q^65-41*q^66+17*q^67-2*q^68,Unknown(),Unknown(),(5*j^2+
2*j)*q^2-6*j^2*q^3+(13*j^2+10*j)*q^4+42*q^5-60*q^6+42*q^7+
(10*j^2+13*j)*q^8-6*j*q^9+(2*j^2+5*j)*q^10,-q^9,9*q^105+
(40*j^2+34*j)*q^106+56*q^107+(34*j^2+40*j)*q^108+9*q^109,2*q^105-
17*q^106+41*q^107-41*q^108+17*q^109-2*q^110,Unknown(),(-9*j^2+9*j)*q^6-
9*j*q^7+9*j^2*q^8+(-9*j^2+9*j)*q^9,9*q^21+(40*j^2+
34*j)*q^22+56*q^23+(34*j^2+40*j)*q^24+9*q^25,Unknown(),9*q^42-
45*q^43+72*q^44-45*q^45+9*q^46,0,Unknown(),Unknown(),3*q^42-18*q^43+30*q^44-
18*q^45+3*q^46,Unknown(),-540*q^21,(-5*j^2-2*j)*q^22-7*q^23+(-2*j^2-
5*j)*q^24,-132*q^21+276*q^22-132*q^23,Unknown(),21*q^21-69*q^22+69*q^23-
21*q^24,63*q^21-207*q^22+207*q^23-63*q^24,-12*q^21+60*q^22-96*q^23+60*q^24-
12*q^25,Unknown(),-4*q^21+(-21*j^2-18*j)*q^22-34*q^23+(-18*j^2-
21*j)*q^24-4*q^25,-19*q^21+90*q^22-142*q^23+90*q^24-19*q^25,-4*q^21+(-
25*j^2-21*j)*q^22+(49*j^2+45*j)*q^23+(-45*j^2-49*j)*q^24+
(21*j^2+25*j)*q^25+4*q^26,-9*q^21+(-81*j^2-108*j)*q^23-144*q^24+(-
108*j^2-81*j)*q^25-9*q^27,-27*q^21+(-72*j^2-54*j)*q^22+(-
27*j^2-36*j)*q^23-108*q^24+(-36*j^2-27*j)*q^25+(-54*j^2-
72*j)*q^26-27*q^27,(9*j^2+15*j)*q^23+(-24*j^2-30*j)*q^24+
(30*j^2+24*j)*q^25+(-15*j^2-9*j)*q^26,4*q^21-5*q^22+(39*j^2+
48*j)*q^23+(-114*j^2-132*j)*q^24+(132*j^2+114*j)*q^25+(-
48*j^2-39*j)*q^26+5*q^27-4*q^28,13*q^21+(46*j^2+40*j)*q^22+(-
26*j^2-8*j)*q^23+(-67*j^2-70*j)*q^24+(70*j^2+67*j)*q^25+
(8*j^2+26*j)*q^26+(-40*j^2-46*j)*q^27-13*q^28,Unknown(),(-
4*j^2-6*j)*q^23+(16*j^2+23*j)*q^24+29*q^25+(23*j^2+
16*j)*q^26+(-6*j^2-4*j)*q^27,-j^2*q^23+(3*j^2+4*j)*q^24+
6*q^25+(4*j^2+3*j)*q^26-j*q^27,-2*j*q^24+(3*j^2+7*j)*q^25+
8*q^26+(7*j^2+3*j)*q^27-2*j^2*q^28,270*q^21-270*q^22,(-5*j^2-
2*j)*q^23+6*j^2*q^24+(-13*j^2-10*j)*q^25-42*q^26+60*q^27-42*q^28+
(-10*j^2-13*j)*q^29+6*j*q^30+(-2*j^2-5*j)*q^31,9*q^21+
(36*j^2+27*j)*q^22+(-27*j^2-36*j)*q^23-9*q^24,-90*q^21+180*q^22-
90*q^23,Unknown(),42*q^21-138*q^22+138*q^23-42*q^24,(9*j^2-9*j)*q^27+
9*j*q^28-9*j^2*q^29+(9*j^2-9*j)*q^30,Unknown(),Unknown(),-3*q^63+
18*q^64-30*q^65+18*q^66-3*q^67,Unknown(),q^18,-9*q^21+45*q^22-72*q^23+45*q^24-
9*q^25,Unknown(),540*q^42,Unknown(),132*q^42-276*q^43+132*q^44,-21*q^42+
69*q^43-69*q^44+21*q^45,-63*q^42+207*q^43-207*q^44+63*q^45,-5*q^42+(-
24*j^2-18*j)*q^43-29*q^44+(-18*j^2-24*j)*q^45-5*q^46,4*q^42+
(25*j^2+21*j)*q^43+(-49*j^2-45*j)*q^44+(45*j^2+49*j)*q^45+(-
21*j^2-25*j)*q^46-4*q^47,Unknown(),9*q^42+(81*j^2+108*j)*q^44+
144*q^45+(108*j^2+81*j)*q^46+9*q^48,-4*q^42+5*q^43+(-39*j^2-
48*j)*q^44+(114*j^2+132*j)*q^45+(-132*j^2-114*j)*q^46+
(48*j^2+39*j)*q^47-5*q^48+4*q^49,(-9*j^2-15*j)*q^44+(24*j^2+
30*j)*q^45+(-30*j^2-24*j)*q^46+(15*j^2+9*j)*q^47,j^2*q^44+(-
3*j^2-4*j)*q^45-6*q^46+(-4*j^2-3*j)*q^47+j*q^48,-270*q^42+
270*q^43,90*q^42-180*q^43+90*q^44,-42*q^42+138*q^43-138*q^44+42*q^45,(-
9*j^2+9*j)*q^48-9*j*q^49+9*j^2*q^50+(-9*j^2+9*j)*q^51,-
9*q^42+(-40*j^2-34*j)*q^43-56*q^44+(-34*j^2-40*j)*q^45-9*q^46,
3*q^84-18*q^85+30*q^86-18*q^87+3*q^88,Unknown(),-540*q^63,45*q^20-60*q^21+
21*q^22+21*q^24-60*q^25+45*q^26,Unknown(),21*q^63-69*q^64+69*q^65-21*q^66,
Unknown(),Unknown(),-9*q^63+(-81*j^2-108*j)*q^65-144*q^66+(-108*j^2-
81*j)*q^67-9*q^69,Unknown(),(9*j^2+15*j)*q^65+(-24*j^2-
30*j)*q^66+(30*j^2+24*j)*q^67+(-15*j^2-9*j)*q^68,-j^2*q^65+
(3*j^2+4*j)*q^66+6*q^67+(4*j^2+3*j)*q^68-j*q^69,-81*q^20+
45*q^21-45*q^24+81*q^25,-90*q^63+180*q^64-90*q^65,Unknown(),9*q^63+(40*j^2+
34*j)*q^64+56*q^65+(34*j^2+40*j)*q^66+9*q^67,540*q^84,Unknown(),
132*q^84-276*q^85+132*q^86,2*q^21-17*q^22+41*q^23-41*q^24+17*q^25-2*q^26,-
270*q^84+270*q^85,90*q^84-180*q^85+90*q^86,Unknown(),-21*q^84+69*q^85-69*q^86+
21*q^87,-540*q^105,Unknown(),-132*q^105+276*q^106-132*q^107,270*q^105-
270*q^106,-90*q^105+180*q^106-90*q^107,Unknown(),21*q^105-69*q^106+69*q^107-
21*q^108];end;
  f123:=q->[560,-320+240*q,134-186*q+54*q^2,184-272*q+
104*q^2,-78+162*q-110*q^2+24*q^3,-46+88*q-48*q^2+6*q^3,-20+48*q-18*q^2,-106+
234*q-174*q^2+46*q^3,-2-18*q+48*q^2-18*q^3,2+10*q-36*q^2+30*q^3-8*q^4,34-88*q+
86*q^2-36*q^3+6*q^4,14-32*q+24*q^2-6*q^3,2-8*q+5*q^2,-12+44*q-61*q^2+32*q^3-
4*q^4,27-70*q+64*q^2-24*q^3+3*q^4,12-36*q+30*q^2-8*q^3,45-127*q+130*q^2-
61*q^3+11*q^4,-8+25*q-27*q^2+13*q^3-3*q^4,7-30*q+54*q^2-44*q^3+16*q^4-2*q^5,q-
q^2,Unknown(),6-24*q+35*q^2-22*q^3+5*q^4,Unknown(),-12+37*q-44*q^2+25*q^3-
7*q^4+q^5,-4+10*q-9*q^2+3*q^3,-1+6*q-6*q^2+2*q^3,20-144*q^2+144*q^3-54*q^4,0,
Unknown(),2+8*q-38*q^2+32*q^3-6*q^4,0,38-96*q-18*q^2+108*q^3-48*q^4-36*q^5+
18*q^6,Unknown(),Unknown(),-12+8*q+84*q^2-140*q^3+94*q^4-24*q^5,-q+6*q^2-
6*q^3+2*q^4,-22+72*q-30*q^2-68*q^3+76*q^4-26*q^6+8*q^7,3*q-8*q^2+14*q^3-
12*q^4+4*q^5,-1-4*q+25*q^2-34*q^3+17*q^4-3*q^5,-2+30*q^2-37*q^3+15*q^4-2*q^5,
Unknown(),-16+72*q-80*q^2+13*q^3+35*q^4-12*q^5-12*q^6+4*q^7,Unknown(),
Unknown(),6-34*q+50*q^2-17*q^3-31*q^4+34*q^5-9*q^6,-5*q^2+6*q^3-3*q^4+q^5,-
14*q^90+32*q^91-24*q^92+6*q^93,-14*q^18+32*q^19-24*q^20+6*q^21,1-q-18*q^2+
33*q^3-24*q^4+8*q^5-q^6,Unknown(),Unknown(),9-49*q+77*q^2-42*q^3-16*q^4+
23*q^5+2*q^6-8*q^7+2*q^8,Unknown(),Unknown(),Unknown(),8*q^18-25*q^19+27*q^20-
13*q^21+3*q^22,Unknown(),Unknown(),6-26*q+18*q^2+34*q^3-71*q^4+56*q^5-28*q^6+
14*q^7-5*q^8,0,Unknown(),Unknown(),0,-q^2-6*q^3+11*q^4-6*q^5,Unknown(),
Unknown(),Unknown(),-8*q^36+25*q^37-27*q^38+13*q^39-3*q^40,Unknown(),
Unknown(),12*q^54-37*q^55+44*q^56-25*q^57+7*q^58-q^59,Unknown(),Unknown(),2-
8*q^2+12*q^3-30*q^4+62*q^5-52*q^6+18*q^7-6*q^8+4*q^9,0,12*q^90-44*q^91+
61*q^92-32*q^93+4*q^94,12*q^90-37*q^91+44*q^92-25*q^93+7*q^94-q^95,Unknown(),
3*q^4-19*q^6+6*q^7,12*q^18-44*q^19+61*q^20-32*q^21+4*q^22,Unknown(),27*q^36-
70*q^37+64*q^38-24*q^39+3*q^40,-q^38,Unknown(),Unknown(),14*q^36-32*q^37+
24*q^38-6*q^39,Unknown(),-560*q^18,-2*q^18+8*q^19-5*q^20,-184*q^18+272*q^19-
104*q^20,Unknown(),46*q^18-88*q^19+48*q^20-6*q^21,106*q^18-234*q^19+174*q^20-
46*q^21,-34*q^18+88*q^19-86*q^20+36*q^21-6*q^22,Unknown(),-12*q^18+36*q^19-
30*q^20+8*q^21,-45*q^18+127*q^19-130*q^20+61*q^21-11*q^22,-7*q^18+30*q^19-
54*q^20+44*q^21-16*q^22+2*q^23,-20*q^18+144*q^20-144*q^21+54*q^22,-38*q^18+
96*q^19+18*q^20-108*q^21+48*q^22+36*q^23-18*q^24,2*q^18-30*q^20+37*q^21-
15*q^22+2*q^23,12*q^18-8*q^19-84*q^20+140*q^21-94*q^22+24*q^23,22*q^18-
72*q^19+30*q^20+68*q^21-76*q^22+26*q^24-8*q^25,Unknown(),-q^18+q^19+18*q^20-
33*q^21+24*q^22-8*q^23+q^24,5*q^20-6*q^21+3*q^22-q^23,q^20+6*q^21-11*q^22+
6*q^23,320*q^18-240*q^19,-2*q^18+8*q^20-12*q^21+30*q^22-62*q^23+52*q^24-
18*q^25+6*q^26-4*q^27,20*q^18-48*q^19+18*q^20,-134*q^18+186*q^19-54*q^20,
Unknown(),78*q^18-162*q^19+110*q^20-24*q^21,-3*q^22+19*q^24-6*q^25,Unknown(),
Unknown(),-14*q^54+32*q^55-24*q^56+6*q^57,Unknown(),0,-27*q^18+70*q^19-
64*q^20+24*q^21-3*q^22,Unknown(),560*q^36,Unknown(),184*q^36-272*q^37+
104*q^38,-46*q^36+88*q^37-48*q^38+6*q^39,-106*q^36+234*q^37-174*q^38+46*q^39,
2*q^36+10*q^37-36*q^38+30*q^39-8*q^40,7*q^36-30*q^37+54*q^38-44*q^39+16*q^40-
2*q^41,Unknown(),20*q^36-144*q^38+144*q^39-54*q^40,-12*q^36+8*q^37+84*q^38-
140*q^39+94*q^40-24*q^41,-2*q^36+30*q^38-37*q^39+15*q^40-2*q^41,-5*q^38+
6*q^39-3*q^40+q^41,-320*q^36+240*q^37,134*q^36-186*q^37+54*q^38,-78*q^36+
162*q^37-110*q^38+24*q^39,3*q^40-19*q^42+6*q^43,-12*q^36+44*q^37-61*q^38+
32*q^39-4*q^40,14*q^72-32*q^73+24*q^74-6*q^75,Unknown(),-560*q^54,11*q^12-
4*q^13-24*q^15+12*q^16-48*q^18+32*q^19+45*q^20-68*q^21+28*q^22,Unknown(),
46*q^54-88*q^55+48*q^56-6*q^57,Unknown(),Unknown(),-20*q^54+144*q^56-144*q^57+
54*q^58,Unknown(),2*q^54-30*q^56+37*q^57-15*q^58+2*q^59,5*q^56-6*q^57+3*q^58-
q^59,-15*q^12+36*q^15+80*q^18-81*q^20+60*q^21,-134*q^54+186*q^55-54*q^56,
Unknown(),12*q^54-44*q^55+61*q^56-32*q^57+4*q^58,560*q^72,Unknown(),184*q^72-
272*q^73+104*q^74,12*q^18-37*q^19+44*q^20-25*q^21+7*q^22-q^23,-320*q^72+
240*q^73,134*q^72-186*q^73+54*q^74,Unknown(),-46*q^72+88*q^73-48*q^74+6*q^75,-
560*q^90,Unknown(),-184*q^90+272*q^91-104*q^92,320*q^90-240*q^91,-134*q^90+
186*q^91-54*q^92,Unknown(),46*q^90-88*q^91+48*q^92-6*q^93];
  f125:=q->[560,-280+280*q,94-186*q+94*q^2,136-288*q+136*q^2,-43+144*q-144*q^2+43*q^3,-
22+72*q-72*q^2+22*q^3,-12+30*q-30*q^2+12*q^3,-64+216*q-216*q^2+64*q^3,10-30*q+
30*q^2-10*q^3,-7+19*q-28*q^2+19*q^3-7*q^4,12-62*q+102*q^2-62*q^3+12*q^4,3-
19*q+32*q^2-19*q^3+3*q^4,1-3*q+6*q^2-3*q^3+q^4,-10+38*q-54*q^2+38*q^3-10*q^4,
9-47*q+76*q^2-47*q^3+9*q^4,4-22*q+32*q^2-22*q^3+4*q^4,19-93*q+150*q^2-93*q^3+
19*q^4,-1+10*q-27*q^2+27*q^3-10*q^4+q^5,5-24*q+46*q^2-46*q^3+24*q^4-5*q^5,-
q^2+q^3,Unknown(),3-14*q+28*q^2-28*q^3+14*q^4-3*q^5,Unknown(),-2+17*q-44*q^2+
44*q^3-17*q^4+2*q^5,3*q-10*q^2+10*q^3-3*q^4,2*q-5*q^2+5*q^3-2*q^4,12-90*q^2+
176*q^3-90*q^4+12*q^6,0,Unknown(),1+3*q-23*q^2+34*q^3-23*q^4+3*q^5+q^6,0,34-
60*q-30*q^2+132*q^3-30*q^4-60*q^5+34*q^6,Unknown(),Unknown(),-4+8*q+42*q^2-
136*q^3+136*q^4-42*q^5-8*q^6+4*q^7,2*q^2-5*q^3+5*q^4-2*q^5,-15+47*q-16*q^2-
80*q^3+80*q^4+16*q^5-47*q^6+15*q^7,2*q-6*q^2+13*q^3-13*q^4+6*q^5-2*q^6,12*q^2-
30*q^3+30*q^4-12*q^5,-1+10*q^2-33*q^3+33*q^4-10*q^5+q^7,Unknown(),-12+36*q-
32*q^2-10*q^3+10*q^4+32*q^5-36*q^6+12*q^7,Unknown(),Unknown(),3-10*q+11*q^2+
2*q^3-10*q^4+2*q^5+11*q^6-10*q^7+3*q^8,4*q^3-6*q^4+4*q^5,3*q^105-19*q^106+
32*q^107-19*q^108+3*q^109,3*q^21-19*q^22+32*q^23-19*q^24+3*q^25,-q-4*q^2+
21*q^3-36*q^4+21*q^5-4*q^6-q^7,Unknown(),Unknown(),5-23*q+33*q^2-13*q^3-8*q^4-
13*q^5+33*q^6-23*q^7+5*q^8,Unknown(),Unknown(),Unknown(),-q^21+10*q^22-
27*q^23+27*q^24-10*q^25+q^26,Unknown(),Unknown(),3-6*q-4*q^2+28*q^3-36*q^4+
32*q^5-36*q^6+28*q^7-4*q^8-6*q^9+3*q^10,0,Unknown(),Unknown(),0,7*q^4-12*q^5+
7*q^6,Unknown(),Unknown(),Unknown(),-q^42+10*q^43-27*q^44+27*q^45-10*q^46+
q^47,Unknown(),Unknown(),-2*q^63+17*q^64-44*q^65+44*q^66-17*q^67+2*q^68,
Unknown(),Unknown(),1-3*q^2+2*q^3-3*q^4+42*q^5-58*q^6+42*q^7-3*q^8+2*q^9-
3*q^10+q^12,0,-10*q^105+38*q^106-54*q^107+38*q^108-10*q^109,-2*q^105+17*q^106-
44*q^107+44*q^108-17*q^109+2*q^110,Unknown(),3*q^5+15*q^7-15*q^8-3*q^10,-
10*q^21+38*q^22-54*q^23+38*q^24-10*q^25,Unknown(),9*q^42-47*q^43+76*q^44-
47*q^45+9*q^46,0,Unknown(),Unknown(),3*q^42-19*q^43+32*q^44-19*q^45+3*q^46,
Unknown(),560*q^21,q^21-3*q^22+6*q^23-3*q^24+q^25,136*q^21-288*q^22+136*q^23,
Unknown(),-22*q^21+72*q^22-72*q^23+22*q^24,-64*q^21+216*q^22-216*q^23+64*q^24,
12*q^21-62*q^22+102*q^23-62*q^24+12*q^25,Unknown(),4*q^21-22*q^22+32*q^23-
22*q^24+4*q^25,19*q^21-93*q^22+150*q^23-93*q^24+19*q^25,5*q^21-24*q^22+
46*q^23-46*q^24+24*q^25-5*q^26,12*q^21-90*q^23+176*q^24-90*q^25+12*q^27,
34*q^21-60*q^22-30*q^23+132*q^24-30*q^25-60*q^26+34*q^27,-q^21+10*q^23-
33*q^24+33*q^25-10*q^26+q^28,-4*q^21+8*q^22+42*q^23-136*q^24+136*q^25-42*q^26-
8*q^27+4*q^28,-15*q^21+47*q^22-16*q^23-80*q^24+80*q^25+16*q^26-47*q^27+
15*q^28,Unknown(),-q^22-4*q^23+21*q^24-36*q^25+21*q^26-4*q^27-q^28,4*q^24-
6*q^25+4*q^26,7*q^25-12*q^26+7*q^27,-280*q^21+280*q^22,q^21-3*q^23+2*q^24-
3*q^25+42*q^26-58*q^27+42*q^28-3*q^29+2*q^30-3*q^31+q^33,-12*q^21+30*q^22-
30*q^23+12*q^24,94*q^21-186*q^22+94*q^23,Unknown(),-43*q^21+144*q^22-144*q^23+
43*q^24,3*q^26+15*q^28-15*q^29-3*q^31,Unknown(),Unknown(),3*q^63-19*q^64+
32*q^65-19*q^66+3*q^67,Unknown(),0,9*q^21-47*q^22+76*q^23-47*q^24+9*q^25,
Unknown(),560*q^42,Unknown(),136*q^42-288*q^43+136*q^44,-22*q^42+72*q^43-
72*q^44+22*q^45,-64*q^42+216*q^43-216*q^44+64*q^45,-7*q^42+19*q^43-28*q^44+
19*q^45-7*q^46,5*q^42-24*q^43+46*q^44-46*q^45+24*q^46-5*q^47,Unknown(),
12*q^42-90*q^44+176*q^45-90*q^46+12*q^48,-4*q^42+8*q^43+42*q^44-136*q^45+
136*q^46-42*q^47-8*q^48+4*q^49,-q^42+10*q^44-33*q^45+33*q^46-10*q^47+q^49,
4*q^45-6*q^46+4*q^47,-280*q^42+280*q^43,94*q^42-186*q^43+94*q^44,-43*q^42+
144*q^43-144*q^44+43*q^45,3*q^47+15*q^49-15*q^50-3*q^52,-10*q^42+38*q^43-
54*q^44+38*q^45-10*q^46,3*q^84-19*q^85+32*q^86-19*q^87+3*q^88,Unknown(),
560*q^63,-20*q^15+10*q^16+45*q^20-92*q^21+49*q^22+49*q^24-92*q^25+45*q^26+
10*q^30-20*q^31,Unknown(),-22*q^63+72*q^64-72*q^65+22*q^66,Unknown(),
Unknown(),12*q^63-90*q^65+176*q^66-90*q^67+12*q^69,Unknown(),-q^63+10*q^65-
33*q^66+33*q^67-10*q^68+q^70,4*q^66-6*q^67+4*q^68,30*q^15-81*q^20+105*q^21-
105*q^24+81*q^25-30*q^30,94*q^63-186*q^64+94*q^65,Unknown(),-10*q^63+38*q^64-
54*q^65+38*q^66-10*q^67,560*q^84,Unknown(),136*q^84-288*q^85+136*q^86,-2*q^21+
17*q^22-44*q^23+44*q^24-17*q^25+2*q^26,-280*q^84+280*q^85,94*q^84-186*q^85+
94*q^86,Unknown(),-22*q^84+72*q^85-72*q^86+22*q^87,560*q^105,Unknown(),
136*q^105-288*q^106+136*q^107,-280*q^105+280*q^106,94*q^105-186*q^106+
94*q^107,Unknown(),-22*q^105+72*q^106-72*q^107+22*q^108];
  f126:=function(q,j) return [560,-280+280*q,94-
186*q+94*q^2,136-288*q+136*q^2,-43+144*q-144*q^2+43*q^3,-22+72*q-72*q^2+
22*q^3,-10+(-30*j^2-36*j)*q+(36*j^2+30*j)*q^2+10*q^3,-64+216*q-
216*q^2+64*q^3,8+(30*j^2+36*j)*q+(-36*j^2-30*j)*q^2-8*q^3,-5+(-
19*j^2-23*j)*q-30*q^2+(-23*j^2-19*j)*q^3-5*q^4,12-62*q+102*q^2-
62*q^3+12*q^4,3-19*q+32*q^2-19*q^3+3*q^4,(3*j^2+5*j)*q+7*q^2+(5*j^2+
3*j)*q^3,-9+(-36*j^2-40*j)*q-59*q^2+(-40*j^2-36*j)*q^3-9*q^4,9-
47*q+76*q^2-47*q^3+9*q^4,4+(20*j^2+22*j)*q+36*q^2+(22*j^2+
20*j)*q^3+4*q^4,19-93*q+150*q^2-93*q^3+19*q^4,-1+10*q-27*q^2+27*q^3-10*q^4+
q^5,4+(22*j^2+25*j)*q+(-48*j^2-50*j)*q^2+(50*j^2+48*j)*q^3+
(-25*j^2-22*j)*q^4-4*q^5,-q^2+q^3,Unknown(),2+(13*j^2+15*j)*q+(-
29*j^2-31*j)*q^2+(31*j^2+29*j)*q^3+(-15*j^2-13*j)*q^4-2*q^5,
Unknown(),-2+17*q-44*q^2+44*q^3-17*q^4+2*q^5,3*q-10*q^2+10*q^3-3*q^4,(-j^2-
2*j)*q-6*q^2+6*q^3+(2*j^2+j)*q^4,10+(108*j^2+90*j)*q^2+144*q^3+
(90*j^2+108*j)*q^4+10*q^6,0,Unknown(),(-5*j^2-3*j)*q+(21*j^2+
19*j)*q^2+34*q^3+(19*j^2+21*j)*q^4+(-3*j^2-5*j)*q^5,0,28+
(60*j^2+72*j)*q+(36*j^2+30*j)*q^2+108*q^3+(30*j^2+36*j)*q^4+
(72*j^2+60*j)*q^5+28*q^6,Unknown(),Unknown(),-4+6*q+(-48*j^2-
42*j)*q^2+(132*j^2+120*j)*q^3+(-120*j^2-132*j)*q^4+(42*j^2+
48*j)*q^5-6*q^6+4*q^7,(-j^2-2*j)*q^2-6*q^3+6*q^4+(2*j^2+j)*q^5,
-13+(-43*j^2-47*j)*q+(12*j^2+24*j)*q^2+(70*j^2+68*j)*q^3+(-
68*j^2-70*j)*q^4+(-24*j^2-12*j)*q^5+(47*j^2+43*j)*q^6+
13*q^7,q+(6*j^2+7*j)*q^2+13*q^3-13*q^4+(-7*j^2-6*j)*q^5-q^6,
(2*j^2+j)*q+(-12*j^2-10*j)*q^2+(29*j^2+28*j)*q^3+(-
28*j^2-29*j)*q^4+(10*j^2+12*j)*q^5+(-j^2-2*j)*q^6,(-
15*j^2-11*j)*q^2+(30*j^2+26*j)*q^3+(-26*j^2-30*j)*q^4+
(11*j^2+15*j)*q^5,Unknown(),-9+(-34*j^2-38*j)*q+(27*j^2+
35*j)*q^2+(3*j^2-j)*q^3+(j^2-3*j)*q^4+(-35*j^2-27*j)*q^5+
(38*j^2+34*j)*q^6+9*q^7,Unknown(),Unknown(),2-8*q+(-6*j^2-
11*j)*q^2+(-2*j^2+3*j)*q^3-5*q^4+(3*j^2-2*j)*q^5+(-11*j^2-
6*j)*q^6-8*q^7+2*q^8,j*q^2+(-4*j^2-3*j)*q^3-7*q^4+(-3*j^2-
4*j)*q^5+j^2*q^6,3*q^105-19*q^106+32*q^107-19*q^108+3*q^109,3*q^21-
19*q^22+32*q^23-19*q^24+3*q^25,(6*j^2+4*j)*q^2+(-23*j^2-19*j)*q^3-
30*q^4+(-19*j^2-23*j)*q^5+(4*j^2+6*j)*q^6,Unknown(),Unknown(),4+
(19*j^2+21*j)*q+(-28*j^2-36*j)*q^2+(13*j^2+21*j)*q^3+4*q^4+
(21*j^2+13*j)*q^5+(-36*j^2-28*j)*q^6+(21*j^2+19*j)*q^7+
4*q^8,Unknown(),Unknown(),Unknown(),-q^21+10*q^22-27*q^23+27*q^24-10*q^25+
q^26,Unknown(),Unknown(),2-6*q-5*q^2+28*q^3+(35*j^2+37*j)*q^4+36*q^5+
(37*j^2+35*j)*q^6+28*q^7-5*q^8-6*q^9+2*q^10,0,Unknown(),Unknown(),0,
2*j^2*q^3+(-7*j^2-5*j)*q^4-8*q^5+(-5*j^2-7*j)*q^6+2*j*q^7,
Unknown(),Unknown(),Unknown(),-q^42+10*q^43-27*q^44+27*q^45-10*q^46+q^47,
Unknown(),Unknown(),-2*q^63+17*q^64-44*q^65+44*q^66-17*q^67+2*q^68,Unknown(),
Unknown(),(3*j^2+5*j)*q^2-4*j*q^3+(11*j^2+13*j)*q^4+46*q^5-
62*q^6+46*q^7+(13*j^2+11*j)*q^8-4*j^2*q^9+(5*j^2+3*j)*q^10,0,-
9*q^105+(-36*j^2-40*j)*q^106-59*q^107+(-40*j^2-36*j)*q^108-
9*q^109,-2*q^105+17*q^106-44*q^107+44*q^108-17*q^109+2*q^110,Unknown(),
(8*j^2+5*j)*q^6-9*j^2*q^7+9*j*q^8+(-5*j^2-8*j)*q^9,-9*q^21+
(-36*j^2-40*j)*q^22-59*q^23+(-40*j^2-36*j)*q^24-9*q^25,Unknown(),
9*q^42-47*q^43+76*q^44-47*q^45+9*q^46,j*q^44-j^2*q^45,Unknown(),
Unknown(),3*q^42-19*q^43+32*q^44-19*q^45+3*q^46,Unknown(),560*q^21,(3*j^2+
5*j)*q^22+7*q^23+(5*j^2+3*j)*q^24,136*q^21-288*q^22+136*q^23,
Unknown(),-22*q^21+72*q^22-72*q^23+22*q^24,-64*q^21+216*q^22-216*q^23+64*q^24,
12*q^21-62*q^22+102*q^23-62*q^24+12*q^25,Unknown(),4*q^21+(20*j^2+
22*j)*q^22+36*q^23+(22*j^2+20*j)*q^24+4*q^25,19*q^21-93*q^22+
150*q^23-93*q^24+19*q^25,4*q^21+(22*j^2+25*j)*q^22+(-48*j^2-
50*j)*q^23+(50*j^2+48*j)*q^24+(-25*j^2-22*j)*q^25-4*q^26,
10*q^21+(108*j^2+90*j)*q^23+144*q^24+(90*j^2+108*j)*q^25+10*q^27,
28*q^21+(60*j^2+72*j)*q^22+(36*j^2+30*j)*q^23+108*q^24+(30*j^2+
36*j)*q^25+(72*j^2+60*j)*q^26+28*q^27,(-15*j^2-11*j)*q^23+
(30*j^2+26*j)*q^24+(-26*j^2-30*j)*q^25+(11*j^2+15*j)*q^26,-
4*q^21+6*q^22+(-48*j^2-42*j)*q^23+(132*j^2+120*j)*q^24+(-
120*j^2-132*j)*q^25+(42*j^2+48*j)*q^26-6*q^27+4*q^28,-13*q^21+(-
43*j^2-47*j)*q^22+(12*j^2+24*j)*q^23+(70*j^2+68*j)*q^24+(-
68*j^2-70*j)*q^25+(-24*j^2-12*j)*q^26+(47*j^2+43*j)*q^27+
13*q^28,Unknown(),(6*j^2+4*j)*q^23+(-23*j^2-19*j)*q^24-30*q^25+(-
19*j^2-23*j)*q^26+(4*j^2+6*j)*q^27,j*q^23+(-4*j^2-
3*j)*q^24-7*q^25+(-3*j^2-4*j)*q^26+j^2*q^27,2*j^2*q^24+(-
7*j^2-5*j)*q^25-8*q^26+(-5*j^2-7*j)*q^27+2*j*q^28,-280*q^21+
280*q^22,(3*j^2+5*j)*q^23-4*j*q^24+(11*j^2+13*j)*q^25+46*q^26-
62*q^27+46*q^28+(13*j^2+11*j)*q^29-4*j^2*q^30+(5*j^2+3*j)*q^31,
-10*q^21+(-30*j^2-36*j)*q^22+(36*j^2+30*j)*q^23+10*q^24,94*q^21-
186*q^22+94*q^23,Unknown(),-43*q^21+144*q^22-144*q^23+43*q^24,(8*j^2+
5*j)*q^27-9*j^2*q^28+9*j*q^29+(-5*j^2-8*j)*q^30,Unknown(),
Unknown(),3*q^63-19*q^64+32*q^65-19*q^66+3*q^67,Unknown(),0,9*q^21-47*q^22+
76*q^23-47*q^24+9*q^25,Unknown(),560*q^42,Unknown(),136*q^42-288*q^43+
136*q^44,-22*q^42+72*q^43-72*q^44+22*q^45,-64*q^42+216*q^43-216*q^44+64*q^45,-
5*q^42+(-19*j^2-23*j)*q^43-30*q^44+(-23*j^2-19*j)*q^45-5*q^46,
4*q^42+(22*j^2+25*j)*q^43+(-48*j^2-50*j)*q^44+(50*j^2+
48*j)*q^45+(-25*j^2-22*j)*q^46-4*q^47,Unknown(),10*q^42+(108*j^2+
90*j)*q^44+144*q^45+(90*j^2+108*j)*q^46+10*q^48,-4*q^42+6*q^43+(-
48*j^2-42*j)*q^44+(132*j^2+120*j)*q^45+(-120*j^2-
132*j)*q^46+(42*j^2+48*j)*q^47-6*q^48+4*q^49,(-15*j^2-
11*j)*q^44+(30*j^2+26*j)*q^45+(-26*j^2-30*j)*q^46+(11*j^2+
15*j)*q^47,j*q^44+(-4*j^2-3*j)*q^45-7*q^46+(-3*j^2-
4*j)*q^47+j^2*q^48,-280*q^42+280*q^43,94*q^42-186*q^43+94*q^44,-43*q^42+
144*q^43-144*q^44+43*q^45,(8*j^2+5*j)*q^48-9*j^2*q^49+9*j*q^50+(-
5*j^2-8*j)*q^51,-9*q^42+(-36*j^2-40*j)*q^43-59*q^44+(-40*j^2-
36*j)*q^45-9*q^46,3*q^84-19*q^85+32*q^86-19*q^87+3*q^88,Unknown(),560*q^63,
-42*q^18+28*q^19+45*q^20-60*q^21+21*q^22+21*q^24-60*q^25+45*q^26+28*q^27-
42*q^28,Unknown(),-22*q^63+72*q^64-72*q^65+22*q^66,Unknown(),Unknown(),
10*q^63+(108*j^2+90*j)*q^65+144*q^66+(90*j^2+108*j)*q^67+10*q^69,
Unknown(),(-15*j^2-11*j)*q^65+(30*j^2+26*j)*q^66+(-26*j^2-
30*j)*q^67+(11*j^2+15*j)*q^68,j*q^65+(-4*j^2-3*j)*q^66-
7*q^67+(-3*j^2-4*j)*q^68+j^2*q^69,70*q^18-81*q^20+45*q^21-45*q^24+
81*q^25-70*q^27,94*q^63-186*q^64+94*q^65,Unknown(),-9*q^63+(-36*j^2-
40*j)*q^64-59*q^65+(-40*j^2-36*j)*q^66-9*q^67,560*q^84,Unknown(),
136*q^84-288*q^85+136*q^86,-2*q^21+17*q^22-44*q^23+44*q^24-17*q^25+2*q^26,-
280*q^84+280*q^85,94*q^84-186*q^85+94*q^86,Unknown(),-22*q^84+72*q^85-72*q^86+
22*q^87,560*q^105,Unknown(),136*q^105-288*q^106+136*q^107,-280*q^105+
280*q^106,94*q^105-186*q^106+94*q^107,Unknown(),-22*q^105+72*q^106-72*q^107+
22*q^108];end;
  f128:=q->[630,-345+
285*q,138-207*q+78*q^2,184-322*q+124*q^2,-70+182*q-140*q^2+31*q^3,-42+96*q-
65*q^2+13*q^3,-27+45*q-27*q^2+3*q^3,-96+264*q-219*q^2+51*q^3,-6-27*q+45*q^2-
18*q^3,10*q-34*q^2+31*q^3-9*q^4,24-92*q+112*q^2-50*q^3+6*q^4,9-33*q+35*q^2-
12*q^3+q^4,3-9*q+7*q^2-q^3,-10+44*q-65*q^2+39*q^3-8*q^4,20-72*q+84*q^2-36*q^3+
4*q^4,12-38*q+38*q^2-14*q^3,35-131*q+166*q^2-80*q^3+11*q^4,-4+21*q-36*q^2+
24*q^3-5*q^4,6-28*q+55*q^2-52*q^3+22*q^4-3*q^5,q-2*q^2,Unknown(),5-21*q+
36*q^2-30*q^3+10*q^4-q^5,Unknown(),-6+32*q-57*q^2+40*q^3-10*q^4,-1+8*q-14*q^2+
8*q^3-q^4,-1+6*q-9*q^2+4*q^3,27-135*q^2+168*q^3-81*q^4+3*q^6,0,Unknown(),3+
9*q-36*q^2+37*q^3-13*q^4+q^5,0,48-90*q-27*q^2+126*q^3-45*q^4-54*q^5+24*q^6,
Unknown(),Unknown(),-12+15*q+69*q^2-162*q^3+120*q^4-33*q^5-3*q^6,-q+6*q^2-
9*q^3+4*q^4,-24+70*q-28*q^2-83*q^3+77*q^4+10*q^5-37*q^6+9*q^7,q-6*q^2+14*q^3-
14*q^4+6*q^5-q^6,-1-2*q+23*q^2-38*q^3+26*q^4-5*q^5,-3+26*q^2-40*q^3+25*q^4-
5*q^5,Unknown(),-16+60*q-62*q^2+9*q^3+17*q^4+11*q^5-24*q^6+8*q^7,Unknown(),
Unknown(),5-20*q+29*q^2-12*q^3-9*q^4+11*q^5-q^6-4*q^7+q^8,-3*q^2+9*q^3-7*q^4+
q^5,-9*q^95+33*q^96-35*q^97+12*q^98-q^99,-9*q^19+33*q^20-35*q^21+12*q^22-q^23,
1-2*q-12*q^2+35*q^3-34*q^4+14*q^5-q^6,Unknown(),Unknown(),8-38*q+60*q^2-
33*q^3-q^4-2*q^5+17*q^6-13*q^7+3*q^8,Unknown(),Unknown(),Unknown(),4*q^19-
21*q^20+36*q^21-24*q^22+5*q^23,Unknown(),Unknown(),5-16*q+3*q^2+40*q^3-58*q^4+
38*q^5-22*q^6+18*q^7-6*q^8-2*q^9+q^10,0,Unknown(),Unknown(),0,-q^2-2*q^3+
10*q^4-10*q^5+4*q^6,Unknown(),Unknown(),Unknown(),-4*q^38+21*q^39-36*q^40+
24*q^41-5*q^42,Unknown(),Unknown(),6*q^57-32*q^58+57*q^59-40*q^60+10*q^61,
Unknown(),Unknown(),3-9*q^2-2*q^3-12*q^4+60*q^5-65*q^6+40*q^7-9*q^8+4*q^9-
q^10,0,10*q^95-44*q^96+65*q^97-39*q^98+8*q^99,6*q^95-32*q^96+57*q^97-40*q^98+
10*q^99,Unknown(),3*q^4-3*q^5-3*q^6+9*q^7,10*q^19-44*q^20+65*q^21-39*q^22+
8*q^23,Unknown(),20*q^38-72*q^39+84*q^40-36*q^41+4*q^42,0,Unknown(),Unknown(),
9*q^38-33*q^39+35*q^40-12*q^41+q^42,Unknown(),-630*q^19,-3*q^19+9*q^20-7*q^21+
q^22,-184*q^19+322*q^20-124*q^21,Unknown(),42*q^19-96*q^20+65*q^21-13*q^22,
96*q^19-264*q^20+219*q^21-51*q^22,-24*q^19+92*q^20-112*q^21+50*q^22-6*q^23,
Unknown(),-12*q^19+38*q^20-38*q^21+14*q^22,-35*q^19+131*q^20-166*q^21+80*q^22-
11*q^23,-6*q^19+28*q^20-55*q^21+52*q^22-22*q^23+3*q^24,-27*q^19+135*q^21-
168*q^22+81*q^23-3*q^25,-48*q^19+90*q^20+27*q^21-126*q^22+45*q^23+54*q^24-
24*q^25,3*q^19-26*q^21+40*q^22-25*q^23+5*q^24,12*q^19-15*q^20-69*q^21+
162*q^22-120*q^23+33*q^24+3*q^25,24*q^19-70*q^20+28*q^21+83*q^22-77*q^23-
10*q^24+37*q^25-9*q^26,Unknown(),-q^19+2*q^20+12*q^21-35*q^22+34*q^23-14*q^24+
q^25,3*q^21-9*q^22+7*q^23-q^24,q^21+2*q^22-10*q^23+10*q^24-4*q^25,345*q^19-
285*q^20,-3*q^19+9*q^21+2*q^22+12*q^23-60*q^24+65*q^25-40*q^26+9*q^27-4*q^28+
q^29,27*q^19-45*q^20+27*q^21-3*q^22,-138*q^19+207*q^20-78*q^21,Unknown(),
70*q^19-182*q^20+140*q^21-31*q^22,-3*q^23+3*q^24+3*q^25-9*q^26,Unknown(),
Unknown(),-9*q^57+33*q^58-35*q^59+12*q^60-q^61,Unknown(),0,-20*q^19+72*q^20-
84*q^21+36*q^22-4*q^23,Unknown(),630*q^38,Unknown(),184*q^38-322*q^39+
124*q^40,-42*q^38+96*q^39-65*q^40+13*q^41,-96*q^38+264*q^39-219*q^40+51*q^41,
10*q^39-34*q^40+31*q^41-9*q^42,6*q^38-28*q^39+55*q^40-52*q^41+22*q^42-3*q^43,
Unknown(),27*q^38-135*q^40+168*q^41-81*q^42+3*q^44,-12*q^38+15*q^39+69*q^40-
162*q^41+120*q^42-33*q^43-3*q^44,-3*q^38+26*q^40-40*q^41+25*q^42-5*q^43,-
3*q^40+9*q^41-7*q^42+q^43,-345*q^38+285*q^39,138*q^38-207*q^39+78*q^40,-
70*q^38+182*q^39-140*q^40+31*q^41,3*q^42-3*q^43-3*q^44+9*q^45,-10*q^38+
44*q^39-65*q^40+39*q^41-8*q^42,9*q^76-33*q^77+35*q^78-12*q^79+q^80,Unknown(),-
630*q^57,11*q^12-4*q^13-4*q^15+2*q^16-36*q^18+24*q^19+90*q^20-120*q^21+
42*q^22-36*q^25+45*q^26,Unknown(),42*q^57-96*q^58+65*q^59-13*q^60,Unknown(),
Unknown(),-27*q^57+135*q^59-168*q^60+81*q^61-3*q^63,Unknown(),3*q^57-26*q^59+
40*q^60-25*q^61+5*q^62,3*q^59-9*q^60+7*q^61-q^62,-15*q^12+6*q^15+60*q^18-
162*q^20+90*q^21+81*q^25,-138*q^57+207*q^58-78*q^59,Unknown(),10*q^57-44*q^58+
65*q^59-39*q^60+8*q^61,630*q^76,Unknown(),184*q^76-322*q^77+124*q^78,6*q^19-
32*q^20+57*q^21-40*q^22+10*q^23,-345*q^76+285*q^77,138*q^76-207*q^77+78*q^78,
Unknown(),-42*q^76+96*q^77-65*q^78+13*q^79,-630*q^95,Unknown(),-184*q^95+
322*q^96-124*q^97,345*q^95-285*q^96,-138*q^95+207*q^96-78*q^97,Unknown(),
42*q^95-96*q^96+65*q^97-13*q^98];
  f130:=function(q,j) return [630,-300+330*q,87-213*q+117*q^2,144-312*q+174*q^2,-43+145*q-167*q^2+62*q^3,-
16+71*q-85*q^2+32*q^3,-6+(-27*j^2-30*j)*q-42*q^2+9*q^3,-69+225*q-
243*q^2+93*q^3,18-42*q+(-30*j^2-27*j)*q^2-15*q^3,-7+31*q-36*q^2+(-
23*j^2-20*j)*q^3-8*q^4,14-58*q+102*q^2-80*q^3+22*q^4,2-14*q+30*q^2-
25*q^3+7*q^4,(j^2+2*j)*q+(-5*j^2-6*j)*q^2-4*q^3,-9+42*q+
(66*j^2+64*j)*q^2+(-48*j^2-46*j)*q^3-15*q^4,8-43*q+76*q^2-60*q^3+
17*q^4,4-16*q+(-33*j^2-36*j)*q^2-26*q^3+5*q^4,21-92*q+155*q^2-115*q^3+
34*q^4,-1+8*q-22*q^2+27*q^3-16*q^4+4*q^5,4-25*q+53*q^2+(57*j^2+
55*j)*q^3+(-33*j^2-31*j)*q^4-8*q^5,-j*q^3,Unknown(),1-12*q+30*q^2+
(34*j^2+33*j)*q^3+(-21*j^2-19*j)*q^4-5*q^5,Unknown(),-3+16*q-
38*q^2+45*q^3-27*q^4+6*q^5,2*q-6*q^2+9*q^3-6*q^4+q^5,q+(3*j^2+4*j)*q^2+
(-4*j^2-5*j)*q^3-2*q^4,6+(90*j^2+81*j)*q^2+192*q^3-126*q^4+9*q^6,
0,Unknown(),(-2*j^2-j)*q+(18*j^2+17*j)*q^2+41*q^3-29*q^4+4*q^5,0,
30+(54*j^2+60*j)*q-42*q^2+144*q^3+(27*j^2+30*j)*q^4-84*q^5+33*q^6,
Unknown(),Unknown(),-4+2*q+42*q^2+(136*j^2+127*j)*q^3+164*q^4-66*q^5-
4*q^6+5*q^7,-j*q^2-4*q^3+(-7*j^2-6*j)*q^4-3*q^5,-15+43*q+(6*j^2+
12*j)*q^2-88*q^3+92*q^4+(-27*j^2-24*j)*q^5-59*q^6+18*q^7,q-7*q^2+(-
14*j^2-13*j)*q^3+(15*j^2+14*j)*q^4+10*q^5-3*q^6,-q+(-10*j^2-
9*j)*q^2+(28*j^2+27*j)*q^3+35*q^4-18*q^5+2*q^6,(-8*j^2-
6*j)*q^2+(30*j^2+29*j)*q^3+(-39*j^2-40*j)*q^4-17*q^5,Unknown(),
-9+(-28*j^2-30*j)*q-14*q^2+(27*j^2+31*j)*q^3+(-3*j^2-
9*j)*q^4+(-60*j^2-56*j)*q^5-56*q^6+15*q^7,Unknown(),Unknown(),1-6*q+
(-24*j^2-25*j)*q^3+(31*j^2+34*j)*q^4+(3*j^2-3*j)*q^5+(-
30*j^2-26*j)*q^6-20*q^7+5*q^8,j*q^2+q^3+(6*j^2+5*j)*q^4+6*q^5-
q^6,2*j*q^110-14*j*q^111+30*j*q^112-25*j*q^113+7*j*q^114,
2*j^2*q^22-14*j^2*q^23+30*j^2*q^24-25*j^2*q^25+7*j^2*q^26,-
4*q^2+(-18*j^2-16*j)*q^3+(34*j^2+33*j)*q^4+(-29*j^2-
30*j)*q^5-9*q^6,Unknown(),Unknown(),4-19*q+(-21*j^2-23*j)*q^2+5*q^3+
(16*j^2+20*j)*q^4+(25*j^2+19*j)*q^5+(-59*j^2-55*j)*q^6-
37*q^7+8*q^8,Unknown(),Unknown(),Unknown(),-j^2*q^22+8*j^2*q^23-
22*j^2*q^24+27*j^2*q^25-16*j^2*q^26+4*j^2*q^27,Unknown(),
Unknown(),1-4*q+(4*j^2+6*j)*q^2+28*q^3+(46*j^2+44*j)*q^4+(-
58*j^2-56*j)*q^5+(63*j^2+64*j)*q^6+(-36*j^2-38*j)*q^7+(-
3*j^2-j)*q^8-14*q^9+5*q^10,0,Unknown(),Unknown(),0,2*j^2*q^3+4*q^4-
10*q^5+(-7*j^2-8*j)*q^6-2*q^7,Unknown(),Unknown(),Unknown(),-j*q^44+
8*j*q^45-22*j*q^46+27*j*q^47-16*j*q^48+4*j*q^49,Unknown(),
Unknown(),-3*q^66+16*q^67-38*q^68+45*q^69-27*q^70+6*q^71,Unknown(),Unknown(),
(j^2+2*j)*q^2+(-4*j^2-6*j)*q^3+(5*j^2+6*j)*q^4+(-32*j^2-
30*j)*q^5+(65*j^2+61*j)*q^6+(-54*j^2-52*j)*q^7-25*q^8+10*q^9-
4*q^10,0,-9*j*q^110+42*j*q^111+(-2*j^2-66*j)*q^112+(2*j^2+
48*j)*q^113-15*j*q^114,-3*j*q^110+16*j*q^111-38*j*q^112+
45*j*q^113-27*j*q^114+6*j*q^115,Unknown(),(-15*j^2-6*j)*q^7-
12*q^8+9*q^9,-9*j^2*q^22+42*j^2*q^23+(-64*j^2+2*j)*q^24+
(46*j^2-2*j)*q^25-15*j^2*q^26,Unknown(),8*j*q^44-43*j*q^45+
76*j*q^46-60*j*q^47+17*j*q^48,0,Unknown(),Unknown(),2*j*q^44-
14*j*q^45+30*j*q^46-25*j*q^47+7*j*q^48,Unknown(),630*j^2*q^22,
(-2*j^2-j)*q^23+(6*j^2+j)*q^24-4*j^2*q^25,144*j^2*q^22-
312*j^2*q^23+174*j^2*q^24,Unknown(),-16*j^2*q^22+71*j^2*q^23-
85*j^2*q^24+32*j^2*q^25,-69*j^2*q^22+225*j^2*q^23-243*j^2*q^24+
93*j^2*q^25,14*j^2*q^22-58*j^2*q^23+102*j^2*q^24-80*j^2*q^25+
22*j^2*q^26,Unknown(),4*j^2*q^22-16*j^2*q^23+(36*j^2+3*j)*q^24-
26*j^2*q^25+5*j^2*q^26,21*j^2*q^22-92*j^2*q^23+155*j^2*q^24-
115*j^2*q^25+34*j^2*q^26,4*j^2*q^22-25*j^2*q^23+53*j^2*q^24+(-
55*j^2+2*j)*q^25+(31*j^2-2*j)*q^26-8*j^2*q^27,6*j^2*q^22+(-
81*j^2+9*j)*q^24+192*j^2*q^25-126*j^2*q^26+9*j^2*q^28,
30*j^2*q^22+(-60*j^2-6*j)*q^23-42*j^2*q^24+144*j^2*q^25+(-
30*j^2-3*j)*q^26-84*j^2*q^27+33*j^2*q^28,(6*j^2-2*j)*q^24+(-
29*j^2+j)*q^25+(40*j^2+j)*q^26-17*j^2*q^27,-4*j^2*q^22+
2*j^2*q^23+42*j^2*q^24+(-127*j^2+9*j)*q^25+164*j^2*q^26-
66*j^2*q^27-4*j^2*q^28+5*j^2*q^29,-15*j^2*q^22+43*j^2*q^23+(-
12*j^2-6*j)*q^24-88*j^2*q^25+92*j^2*q^26+(24*j^2-3*j)*q^27-
59*j^2*q^28+18*j^2*q^29,Unknown(),-4*j^2*q^24+(16*j^2-
2*j)*q^25+(-33*j^2+j)*q^26+(30*j^2+j)*q^27-9*j^2*q^28,q^24+
j^2*q^25+(-5*j^2+j)*q^26+6*j^2*q^27-j^2*q^28,2*j*q^25+
4*j^2*q^26-10*j^2*q^27+(8*j^2+j)*q^28-2*j^2*q^29,-
300*j^2*q^22+330*j^2*q^23,(-2*j^2-j)*q^24+(6*j^2+2*j)*q^25+
(-6*j^2-j)*q^26+(30*j^2-2*j)*q^27+(-61*j^2+4*j)*q^28+
(52*j^2-2*j)*q^29-25*j^2*q^30+10*j^2*q^31-4*j^2*q^32,-
6*j^2*q^22+(30*j^2+3*j)*q^23-42*j^2*q^24+9*j^2*q^25,
87*j^2*q^22-213*j^2*q^23+117*j^2*q^24,Unknown(),-43*j^2*q^22+
145*j^2*q^23-167*j^2*q^24+62*j^2*q^25,(6*j^2-9*j)*q^29-
12*j^2*q^30+9*j^2*q^31,Unknown(),Unknown(),2*q^66-14*q^67+30*q^68-
25*q^69+7*q^70,Unknown(),0,8*j^2*q^22-43*j^2*q^23+76*j^2*q^24-
60*j^2*q^25+17*j^2*q^26,Unknown(),630*j*q^44,Unknown(),144*j*q^44-
312*j*q^45+174*j*q^46,-16*j*q^44+71*j*q^45-85*j*q^46+
32*j*q^47,-69*j*q^44+225*j*q^45-243*j*q^46+93*j*q^47,-
7*j*q^44+31*j*q^45-36*j*q^46+(3*j^2+23*j)*q^47-8*j*q^48,
4*j*q^44-25*j*q^45+53*j*q^46+(-2*j^2-57*j)*q^47+(2*j^2+
33*j)*q^48-8*j*q^49,Unknown(),6*j*q^44+(-9*j^2-90*j)*q^46+
192*j*q^47-126*j*q^48+9*j*q^50,-4*j*q^44+2*j*q^45+42*j*q^46+
(-9*j^2-136*j)*q^47+164*j*q^48-66*j*q^49-4*j*q^50+5*j*q^51,
(2*j^2+8*j)*q^46+(-j^2-30*j)*q^47+(-j^2+39*j)*q^48-
17*j*q^49,j^2*q^46+j*q^47+(-j^2-6*j)*q^48+6*j*q^49-
j*q^50,-300*j*q^44+330*j*q^45,87*j*q^44-213*j*q^45+
117*j*q^46,-43*j*q^44+145*j*q^45-167*j*q^46+62*j*q^47,
(9*j^2+15*j)*q^51-12*j*q^52+9*j*q^53,-9*j*q^44+42*j*q^45+(-
2*j^2-66*j)*q^46+(2*j^2+48*j)*q^47-15*j*q^48,2*j^2*q^88-
14*j^2*q^89+30*j^2*q^90-25*j^2*q^91+7*j^2*q^92,Unknown(),630*q^66,
45*q^20-92*q^21+49*q^22+35*q^24-76*q^25+45*q^26,Unknown(),-16*q^66+71*q^67-
85*q^68+32*q^69,Unknown(),Unknown(),6*q^66+(90*j^2+81*j)*q^68+192*q^69-
126*q^70+9*q^72,Unknown(),(-8*j^2-6*j)*q^68+(30*j^2+29*j)*q^69+(-
39*j^2-40*j)*q^70-17*q^71,j*q^68+q^69+(6*j^2+5*j)*q^70+6*q^71-
q^72,-81*q^20+105*q^21-75*q^24+81*q^25,87*q^66-213*q^67+117*q^68,Unknown(),-
9*q^66+42*q^67+(66*j^2+64*j)*q^68+(-48*j^2-46*j)*q^69-15*q^70,
630*j^2*q^88,Unknown(),144*j^2*q^88-312*j^2*q^89+174*j^2*q^90,-
3*j^2*q^22+16*j^2*q^23-38*j^2*q^24+45*j^2*q^25-27*j^2*q^26+
6*j^2*q^27,-300*j^2*q^88+330*j^2*q^89,87*j^2*q^88-213*j^2*q^89+
117*j^2*q^90,Unknown(),-16*j^2*q^88+71*j^2*q^89-85*j^2*q^90+
32*j^2*q^91,630*j*q^110,Unknown(),144*j*q^110-312*j*q^111+
174*j*q^112,-300*j*q^110+330*j*q^111,87*j*q^110-213*j*q^111+
117*j*q^112,Unknown(),-16*j*q^110+71*j*q^111-85*j*q^112+
32*j*q^113];end;
  f134:=function(q,j) return [630,-285+345*q,72-213*q+132*q^2,132-306*q+192*q^2,-35+134*q-
172*q^2+76*q^3,-11+61*q-92*q^2+40*q^3,24*q+(48*j^2+45*j)*q^2+15*q^3,-63+
207*q-252*q^2+108*q^3,24+(45*j^2+48*j)*q+24*q^2-9*q^3,-11+33*q+
(37*j^2+40*j)*q^2+18*q^3-3*q^4,10-50*q+96*q^2-88*q^3+32*q^4,1-10*q+
27*q^2-29*q^3+11*q^4,(-5*j^2-4*j)*q^2+(6*j^2+5*j)*q^3+q^4,-8+(-
39*j^2-41*j)*q+(65*j^2+67*j)*q^2+49*q^3-15*q^4,6-34*q+72*q^2-
68*q^3+24*q^4,-12*q+32*q^2+(33*j^2+30*j)*q^3+10*q^4,18-79*q+148*q^2-
128*q^3+44*q^4,-1+5*q-17*q^2+27*q^3-21*q^4+7*q^5,4-23*q+(-50*j^2-
52*j)*q^2+(57*j^2+59*j)*q^3+34*q^4-8*q^5,j^2*q^4,Unknown(),1-9*q+
(-26*j^2-27*j)*q^2+(35*j^2+37*j)*q^3+23*q^4-6*q^5,Unknown(),-2+
12*q-31*q^2+45*q^3-34*q^4+11*q^5,q-4*q^2+8*q^3-8*q^4+3*q^5,-2*q^2+(-5*j^2-
4*j)*q^3+(4*j^2+3*j)*q^4+q^5,-72*q^2+192*q^3+(135*j^2+
144*j)*q^4+15*q^6,0,Unknown(),-11*q^2+41*q^3+(36*j^2+37*j)*q^4+(-
5*j^2-6*j)*q^5+q^6,0,24-48*q+(48*j^2+45*j)*q^2+144*q^3-24*q^4+
(96*j^2+90*j)*q^5+39*q^6,Unknown(),Unknown(),36*q^2-124*q^3+164*q^4+
(75*j^2+84*j)*q^5-5*q^6+10*q^7,(3*j^2+2*j)*q^3+(-7*j^2-
6*j)*q^4+(4*j^2+5*j)*q^5-j*q^6,-11+37*q-4*q^2+(94*j^2+
91*j)*q^3+90*q^4+28*q^5+(72*j^2+66*j)*q^6+23*q^7,q+(6*j^2+
7*j)*q^2+(-13*j^2-14*j)*q^3+(14*j^2+15*j)*q^4+10*q^5+(4*j^2+
3*j)*q^6,6*q^2-24*q^3+37*q^4+(23*j^2+24*j)*q^5+(-3*j^2-
4*j)*q^6+q^7,3*q^2+(25*j^2+24*j)*q^3+(-43*j^2-44*j)*q^4+
(22*j^2+24*j)*q^5+q^7,Unknown(),-8+22*q+4*j*q^2+(41*j^2+
35*j)*q^3+(-6*j^2-2*j)*q^4+72*q^5+(68*j^2+66*j)*q^6+17*q^7,
Unknown(),Unknown(),1-4*q-4*q^2+(-35*j^2-31*j)*q^3+(45*j^2+
40*j)*q^4+(-j^2+4*j)*q^5+(-40*j^2-42*j)*q^6+(30*j^2+
28*j)*q^7+6*q^8,q^3+(5*j^2+3*j)*q^4+6*q^5+(2*j^2+4*j)*q^6,-
j^2*q^115+10*j^2*q^116-27*j^2*q^117+29*j^2*q^118-11*j^2*q^119,-
j*q^23+10*j*q^24-27*j*q^25+29*j*q^26-11*j*q^27,-2*q^2+13*q^3+
(32*j^2+31*j)*q^4+(-33*j^2-34*j)*q^5+(13*j^2+15*j)*q^6+q^8,
Unknown(),Unknown(),4-16*q+14*q^2+(-20*j^2-16*j)*q^3+(29*j^2+
23*j)*q^4+(27*j^2+31*j)*q^5+71*q^6+(47*j^2+45*j)*q^7+10*q^8,
Unknown(),Unknown(),Unknown(),j*q^23-5*j*q^24+17*j*q^25-27*j*q^26+
21*j*q^27-7*j*q^28,Unknown(),Unknown(),1-2*q-5*q^2+(-20*j^2-
22*j)*q^3+(41*j^2+42*j)*q^4+66*q^5+(79*j^2+75*j)*q^6+(-
42*j^2-38*j)*q^7+11*q^8+(22*j^2+20*j)*q^9+6*q^10,0,Unknown(),
Unknown(),0,2*q^4+(8*j^2+10*j)*q^5+10*q^6-4*q^7+j*q^8,Unknown(),
Unknown(),Unknown(),-j^2*q^46+5*j^2*q^47-17*j^2*q^48+27*j^2*q^49-
21*j^2*q^50+7*j^2*q^51,Unknown(),Unknown(),2*q^69-12*q^70+31*q^71-
45*q^72+34*q^73-11*q^74,Unknown(),Unknown(),6*q^3-11*q^4+(-22*j^2-
24*j)*q^5+(57*j^2+61*j)*q^6+(-56*j^2-58*j)*q^7+(25*j^2+
24*j)*q^8+(-14*j^2-12*j)*q^9+(6*j^2+5*j)*q^10+q^12,0,
8*j^2*q^115+(-41*j^2-2*j)*q^116+(67*j^2+2*j)*q^117-
49*j^2*q^118+15*j^2*q^119,2*j^2*q^115-12*j^2*q^116+
31*j^2*q^117-45*j^2*q^118+34*j^2*q^119-11*j^2*q^120,Unknown(),
6*q^7+(12*j^2+21*j)*q^8+9*q^9,8*j*q^23+(2*j^2-39*j)*q^24+(-
2*j^2+65*j)*q^25-49*j*q^26+15*j*q^27,Unknown(),6*j^2*q^46-
34*j^2*q^47+72*j^2*q^48-68*j^2*q^49+24*j^2*q^50,0,Unknown(),
Unknown(),j^2*q^46-10*j^2*q^47+27*j^2*q^48-29*j^2*q^49+
11*j^2*q^50,Unknown(),-630*j*q^23,(-j^2-5*j)*q^25+(j^2+
6*j)*q^26-j*q^27,-132*j*q^23+306*j*q^24-192*j*q^25,Unknown(),
11*j*q^23-61*j*q^24+92*j*q^25-40*j*q^26,63*j*q^23-
207*j*q^24+252*j*q^25-108*j*q^26,-10*j*q^23+50*j*q^24-
96*j*q^25+88*j*q^26-32*j*q^27,Unknown(),12*j*q^24-32*j*q^25+
(3*j^2+33*j)*q^26-10*j*q^27,-18*j*q^23+79*j*q^24-148*j*q^25+
128*j*q^26-44*j*q^27,-4*j*q^23+23*j*q^24+(2*j^2-50*j)*q^25+
(-2*j^2+57*j)*q^26-34*j*q^27+8*j*q^28,72*j*q^25-192*j*q^26+
(-9*j^2+135*j)*q^27-15*j*q^29,-24*j*q^23+48*j*q^24+(3*j^2+
48*j)*q^25-144*j*q^26+24*j*q^27+(6*j^2+96*j)*q^28-39*j*q^29,
-3*j*q^25+(j^2+25*j)*q^26+(j^2-43*j)*q^27+(-2*j^2+
22*j)*q^28-j*q^30,-36*j*q^25+124*j*q^26-164*j*q^27+(-9*j^2+
75*j)*q^28+5*j*q^29-10*j*q^30,11*j*q^23-37*j*q^24+4*j*q^25+
(3*j^2+94*j)*q^26-90*j*q^27-28*j*q^28+(6*j^2+72*j)*q^29-
23*j*q^30,Unknown(),2*j*q^25-13*j*q^26+(j^2+32*j)*q^27+(j^2-
33*j)*q^28+(-2*j^2+13*j)*q^29-j*q^31,-j*q^26+(2*j^2+
5*j)*q^27-6*j*q^28+(-2*j^2+2*j)*q^29,-2*j*q^27+(-2*j^2+
8*j)*q^28-10*j*q^29+4*j*q^30-j^2*q^31,285*j*q^23-345*j*q^24,
-6*j*q^26+11*j*q^27+(2*j^2-22*j)*q^28+(-4*j^2+57*j)*q^29+
(2*j^2-56*j)*q^30+(j^2+25*j)*q^31+(-2*j^2-14*j)*q^32+
(j^2+6*j)*q^33-j*q^35,-24*j*q^24+(3*j^2+48*j)*q^25-
15*j*q^26,-72*j*q^23+213*j*q^24-132*j*q^25,Unknown(),35*j*q^23-
134*j*q^24+172*j*q^25-76*j*q^26,-6*j*q^30+(-9*j^2+
12*j)*q^31-9*j*q^32,Unknown(),Unknown(),-q^69+10*q^70-27*q^71+29*q^72-
11*q^73,Unknown(),0,-6*j*q^23+34*j*q^24-72*j*q^25+68*j*q^26-
24*j*q^27,Unknown(),630*j^2*q^46,Unknown(),132*j^2*q^46-
306*j^2*q^47+192*j^2*q^48,-11*j^2*q^46+61*j^2*q^47-92*j^2*q^48+
40*j^2*q^49,-63*j^2*q^46+207*j^2*q^47-252*j^2*q^48+
108*j^2*q^49,-11*j^2*q^46+33*j^2*q^47+(-40*j^2-3*j)*q^48+
18*j^2*q^49-3*j^2*q^50,4*j^2*q^46-23*j^2*q^47+(52*j^2+
2*j)*q^48+(-59*j^2-2*j)*q^49+34*j^2*q^50-8*j^2*q^51,Unknown(),-
72*j^2*q^48+192*j^2*q^49+(-144*j^2-9*j)*q^50+15*j^2*q^52,
36*j^2*q^48-124*j^2*q^49+164*j^2*q^50+(-84*j^2-9*j)*q^51-
5*j^2*q^52+10*j^2*q^53,3*j^2*q^48+(-24*j^2+j)*q^49+(44*j^2+
j)*q^50+(-24*j^2-2*j)*q^51+j^2*q^53,j^2*q^49+(-3*j^2+
2*j)*q^50+6*j^2*q^51+(-4*j^2-2*j)*q^52,-285*j^2*q^46+
345*j^2*q^47,72*j^2*q^46-213*j^2*q^47+132*j^2*q^48,-
35*j^2*q^46+134*j^2*q^47-172*j^2*q^48+76*j^2*q^49,6*j^2*q^53+(-
21*j^2-9*j)*q^54+9*j^2*q^55,-8*j^2*q^46+(41*j^2+2*j)*q^47+(-
67*j^2-2*j)*q^48+49*j^2*q^49-15*j^2*q^50,j*q^92-10*j*q^93+
27*j*q^94-29*j*q^95+11*j*q^96,Unknown(),-630*q^69,-32*q^21+28*q^22+
77*q^24-124*q^25+45*q^26+12*q^30-24*q^31,Unknown(),11*q^69-61*q^70+92*q^71-
40*q^72,Unknown(),Unknown(),72*q^71-192*q^72+(-135*j^2-144*j)*q^73-
15*q^75,Unknown(),-3*q^71+(-25*j^2-24*j)*q^72+(43*j^2+44*j)*q^73+
(-22*j^2-24*j)*q^74-q^76,-q^72+(-5*j^2-3*j)*q^73-6*q^74+(-
2*j^2-4*j)*q^75,60*q^21-165*q^24+81*q^25-36*q^30,-72*q^69+213*q^70-
132*q^71,Unknown(),8*q^69+(39*j^2+41*j)*q^70+(-65*j^2-67*j)*q^71-
49*q^72+15*q^73,630*j*q^92,Unknown(),132*j*q^92-306*j*q^93+
192*j*q^94,2*j*q^23-12*j*q^24+31*j*q^25-45*j*q^26+34*j*q^27-
11*j*q^28,-285*j*q^92+345*j*q^93,72*j*q^92-213*j*q^93+
132*j*q^94,Unknown(),-11*j*q^92+61*j*q^93-92*j*q^94+40*j*q^95,-
630*j^2*q^115,Unknown(),-132*j^2*q^115+306*j^2*q^116-
192*j^2*q^117,285*j^2*q^115-345*j^2*q^116,-72*j^2*q^115+
213*j^2*q^116-132*j^2*q^117,Unknown(),11*j^2*q^115-61*j^2*q^116+
92*j^2*q^117-40*j^2*q^118];end;
  f138:=function(q,j) return [720,-360+360*q,
114-246*q+114*q^2,184-352*q+184*q^2,-61+176*q-176*q^2+61*q^3,-26+88*q-88*q^2+
26*q^3,-6+(-42*j^2-36*j)*q+(42*j^2+36*j)*q^2+6*q^3,-96+264*q-
264*q^2+96*q^3,24+(36*j^2+42*j)*q+(-36*j^2-42*j)*q^2-24*q^3,-11+(-
29*j^2-33*j)*q+(40*j^2+44*j)*q^2+(-29*j^2-33*j)*q^3-11*q^4,
22-78*q+112*q^2-78*q^3+22*q^4,5-21*q+32*q^2-21*q^3+5*q^4,(3*j^2+j)*q+(-
6*j^2-2*j)*q^2+(3*j^2+j)*q^3,-15+(-50*j^2-54*j)*q+
(70*j^2+78*j)*q^2+(-50*j^2-54*j)*q^3-15*q^4,15-57*q+84*q^2-57*q^3+
15*q^4,4+(24*j^2+22*j)*q+(-40*j^2-32*j)*q^2+(24*j^2+
22*j)*q^3+4*q^4,33-119*q+170*q^2-119*q^3+33*q^4,-3+14*q-25*q^2+25*q^3-
14*q^4+3*q^5,8+(32*j^2+35*j)*q+(-60*j^2-65*j)*q^2+(60*j^2+
65*j)*q^3+(-32*j^2-35*j)*q^4-8*q^5,-j*q^2+j*q^3,Unknown(),4+
(17*j^2+19*j)*q+(-34*j^2-37*j)*q^2+(34*j^2+37*j)*q^3+(-
17*j^2-19*j)*q^4-4*q^5,Unknown(),-6+25*q-44*q^2+44*q^3-25*q^4+6*q^5,-1+
4*q-7*q^2+7*q^3-4*q^4+q^5,(-2*j^2-j)*q+(4*j^2+j)*q^2+(-4*j^2-
j)*q^3+(2*j^2+j)*q^4,6+(108*j^2+126*j)*q^2+240*q^3+(108*j^2+
126*j)*q^4+6*q^6,-j^2*q^3,Unknown(),(-j^2-3*j)*q+(25*j^2+
27*j)*q^2+52*q^3+(25*j^2+27*j)*q^4+(-j^2-3*j)*q^5,-j*q^15,
36+(84*j^2+72*j)*q+(42*j^2+36*j)*q^2+180*q^3+(42*j^2+
36*j)*q^4+(84*j^2+72*j)*q^5+36*q^6,Unknown(),Unknown(),-4+2*q+(-
60*j^2-66*j)*q^2+(168*j^2+180*j)*q^3+(-168*j^2-180*j)*q^4+
(60*j^2+66*j)*q^5-2*q^6+4*q^7,(-2*j^2-j)*q^2+(6*j^2+
5*j)*q^3+(-6*j^2-5*j)*q^4+(2*j^2+j)*q^5,-19+(-61*j^2-
57*j)*q+(20*j^2+16*j)*q^2+(112*j^2+110*j)*q^3+(-112*j^2-
110*j)*q^4+(-20*j^2-16*j)*q^5+(61*j^2+57*j)*q^6+19*q^7,3*q+
(10*j^2+11*j)*q^2+(-13*j^2-18*j)*q^3+(13*j^2+18*j)*q^4+(-
10*j^2-11*j)*q^5-3*q^6,(j^2+2*j)*q+(-14*j^2-16*j)*q^2+
(37*j^2+38*j)*q^3+(-37*j^2-38*j)*q^4+(14*j^2+16*j)*q^5+(-
j^2-2*j)*q^6,(-9*j^2-13*j)*q^2-43*q^3+43*q^4+(9*j^2+
13*j)*q^5,Unknown(),-15+(-50*j^2-46*j)*q+(37*j^2+45*j)*q^2+
(38*j^2+18*j)*q^3+(-38*j^2-18*j)*q^4+(-37*j^2-45*j)*q^5+
(50*j^2+46*j)*q^6+15*q^7,Unknown(),Unknown(),4-16*q+(-14*j^2-
19*j)*q^2+(-27*j^2-14*j)*q^3+(58*j^2+42*j)*q^4+(-27*j^2-
14*j)*q^5+(-14*j^2-19*j)*q^6-16*q^7+4*q^8,j^2*q^2+(-4*j^2-
3*j)*q^3-6*q^4+(-4*j^2-3*j)*q^5+j^2*q^6,5*j*q^105-
21*j*q^106+32*j*q^107-21*j*q^108+5*j*q^109,5*j^2*q^21-
21*j^2*q^22+32*j^2*q^23-21*j^2*q^24+5*j^2*q^25,(6*j^2+
8*j)*q^2+(-26*j^2-27*j)*q^3+(40*j^2+42*j)*q^4+(-26*j^2-
27*j)*q^5+(6*j^2+8*j)*q^6,Unknown(),Unknown(),8+(35*j^2+
33*j)*q+(-44*j^2-48*j)*q^2+(-2*j^2+11*j)*q^3+(42*j^2+
24*j)*q^4+(-2*j^2+11*j)*q^5+(-44*j^2-48*j)*q^6+(35*j^2+
33*j)*q^7+8*q^8,Unknown(),Unknown(),Unknown(),-3*j^2*q^21+
14*j^2*q^22-25*j^2*q^23+25*j^2*q^24-14*j^2*q^25+3*j^2*q^26,
Unknown(),Unknown(),4-10*q+(3*j^2-j)*q^2+(-38*j^2-36*j)*q^3+
(65*j^2+70*j)*q^4+(-72*j^2-80*j)*q^5+(65*j^2+70*j)*q^6+(-
38*j^2-36*j)*q^7+(3*j^2-j)*q^8-10*q^9+4*q^10,-j*q^6,Unknown(),
Unknown(),-j^2*q^12,2*j*q^3+(-7*j^2-8*j)*q^4-12*q^5+(-7*j^2-
8*j)*q^6+2*j*q^7,Unknown(),Unknown(),Unknown(),-3*j*q^42+
14*j*q^43-25*j*q^44+25*j*q^45-14*j*q^46+3*j*q^47,Unknown(),
Unknown(),-6*q^63+25*q^64-44*q^65+44*q^66-25*q^67+6*q^68,Unknown(),Unknown(),
(3*j^2+j)*q^2+(-12*j^2-8*j)*q^3+(19*j^2+17*j)*q^4+(-
40*j^2-48*j)*q^5+(60*j^2+76*j)*q^6+(-40*j^2-48*j)*q^7+
(19*j^2+17*j)*q^8+(-12*j^2-8*j)*q^9+(3*j^2+j)*q^10,-q^9,-
15*j*q^105+(-4*j^2+50*j)*q^106+(8*j^2-70*j)*q^107+(-4*j^2+
50*j)*q^108-15*j*q^109,-6*j*q^105+25*j*q^106-44*j*q^107+
44*j*q^108-25*j*q^109+6*j*q^110,Unknown(),(-4*j^2+5*j)*q^6+(-
12*j^2-21*j)*q^7+(12*j^2+21*j)*q^8+(4*j^2-5*j)*q^9,-
15*j^2*q^21+(54*j^2+4*j)*q^22+(-78*j^2-8*j)*q^23+(54*j^2+
4*j)*q^24-15*j^2*q^25,Unknown(),15*j*q^42-57*j*q^43+84*j*q^44-
57*j*q^45+15*j*q^46,j*q^44-j*q^45,Unknown(),Unknown(),5*j*q^42-
21*j*q^43+32*j*q^44-21*j*q^45+5*j*q^46,Unknown(),720*j^2*q^21,
(-j^2+2*j)*q^22+(2*j^2-4*j)*q^23+(-j^2+2*j)*q^24,
184*j^2*q^21-352*j^2*q^22+184*j^2*q^23,Unknown(),-26*j^2*q^21+
88*j^2*q^22-88*j^2*q^23+26*j^2*q^24,-96*j^2*q^21+264*j^2*q^22-
264*j^2*q^23+96*j^2*q^24,22*j^2*q^21-78*j^2*q^22+112*j^2*q^23-
78*j^2*q^24+22*j^2*q^25,Unknown(),4*j^2*q^21+(-22*j^2+
2*j)*q^22+(32*j^2-8*j)*q^23+(-22*j^2+2*j)*q^24+4*j^2*q^25,
33*j^2*q^21-119*j^2*q^22+170*j^2*q^23-119*j^2*q^24+33*j^2*q^25,
8*j^2*q^21+(-35*j^2-3*j)*q^22+(65*j^2+5*j)*q^23+(-65*j^2-
5*j)*q^24+(35*j^2+3*j)*q^25-8*j^2*q^26,6*j^2*q^21+(-126*j^2-
18*j)*q^23+240*j^2*q^24+(-126*j^2-18*j)*q^25+6*j^2*q^27,
36*j^2*q^21+(-72*j^2+12*j)*q^22+(-36*j^2+6*j)*q^23+
180*j^2*q^24+(-36*j^2+6*j)*q^25+(-72*j^2+12*j)*q^26+
36*j^2*q^27,(13*j^2+4*j)*q^23-43*j^2*q^24+43*j^2*q^25+(-
13*j^2-4*j)*q^26,-4*j^2*q^21+2*j^2*q^22+(66*j^2+6*j)*q^23+(-
180*j^2-12*j)*q^24+(180*j^2+12*j)*q^25+(-66*j^2-6*j)*q^26-
2*j^2*q^27+4*j^2*q^28,-19*j^2*q^21+(57*j^2-4*j)*q^22+(-
16*j^2+4*j)*q^23+(-110*j^2+2*j)*q^24+(110*j^2-2*j)*q^25+
(16*j^2-4*j)*q^26+(-57*j^2+4*j)*q^27+19*j^2*q^28,Unknown(),(-
8*j^2-2*j)*q^23+(27*j^2+j)*q^24+(-42*j^2-2*j)*q^25+
(27*j^2+j)*q^26+(-8*j^2-2*j)*q^27,j*q^23+(3*j^2-j)*q^24-
6*j^2*q^25+(3*j^2-j)*q^26+j*q^27,2*q^24+(8*j^2+j)*q^25-
12*j^2*q^26+(8*j^2+j)*q^27+2*q^28,-360*j^2*q^21+360*j^2*q^22,(-
j^2+2*j)*q^23+(8*j^2-4*j)*q^24+(-17*j^2+2*j)*q^25+
(48*j^2+8*j)*q^26+(-76*j^2-16*j)*q^27+(48*j^2+8*j)*q^28+(-
17*j^2+2*j)*q^29+(8*j^2-4*j)*q^30+(-j^2+2*j)*q^31,-
6*j^2*q^21+(36*j^2-6*j)*q^22+(-36*j^2+6*j)*q^23+6*j^2*q^24,
114*j^2*q^21-246*j^2*q^22+114*j^2*q^23,Unknown(),-61*j^2*q^21+
176*j^2*q^22-176*j^2*q^23+61*j^2*q^24,(-5*j^2-9*j)*q^27+
(21*j^2+9*j)*q^28+(-21*j^2-9*j)*q^29+(5*j^2+9*j)*q^30,
Unknown(),Unknown(),5*q^63-21*q^64+32*q^65-21*q^66+5*q^67,Unknown(),-q^18,
15*j^2*q^21-57*j^2*q^22+84*j^2*q^23-57*j^2*q^24+15*j^2*q^25,
Unknown(),720*j*q^42,Unknown(),184*j*q^42-352*j*q^43+184*j*q^44,-
26*j*q^42+88*j*q^43-88*j*q^44+26*j*q^45,-96*j*q^42+
264*j*q^43-264*j*q^44+96*j*q^45,-11*j*q^42+(-4*j^2+
29*j)*q^43+(4*j^2-40*j)*q^44+(-4*j^2+29*j)*q^45-11*j*q^46,
8*j*q^42+(3*j^2-32*j)*q^43+(-5*j^2+60*j)*q^44+(5*j^2-
60*j)*q^45+(-3*j^2+32*j)*q^46-8*j*q^47,Unknown(),6*j*q^42+
(18*j^2-108*j)*q^44+240*j*q^45+(18*j^2-108*j)*q^46+6*j*q^48,
-4*j*q^42+2*j*q^43+(-6*j^2+60*j)*q^44+(12*j^2-168*j)*q^45+(-
12*j^2+168*j)*q^46+(6*j^2-60*j)*q^47-2*j*q^48+4*j*q^49,(-
4*j^2+9*j)*q^44-43*j*q^45+43*j*q^46+(4*j^2-9*j)*q^47,q^44+
(j^2+4*j)*q^45-6*j*q^46+(j^2+4*j)*q^47+q^48,-360*j*q^42+
360*j*q^43,114*j*q^42-246*j*q^43+114*j*q^44,-61*j*q^42+
176*j*q^43-176*j*q^44+61*j*q^45,(9*j^2+4*j)*q^48+(-9*j^2+
12*j)*q^49+(9*j^2-12*j)*q^50+(-9*j^2-4*j)*q^51,-15*j*q^42+(-
4*j^2+50*j)*q^43+(8*j^2-70*j)*q^44+(-4*j^2+50*j)*q^45-
15*j*q^46,5*j^2*q^84-21*j^2*q^85+32*j^2*q^86-21*j^2*q^87+
5*j^2*q^88,Unknown(),720*q^63,30*q^18-20*q^19+45*q^20-124*q^21+77*q^22+
77*q^24-124*q^25+45*q^26-20*q^27+30*q^28,Unknown(),-26*q^63+88*q^64-88*q^65+
26*q^66,Unknown(),Unknown(),6*q^63+(108*j^2+126*j)*q^65+240*q^66+
(108*j^2+126*j)*q^67+6*q^69,Unknown(),(-9*j^2-13*j)*q^65-43*q^66+
43*q^67+(9*j^2+13*j)*q^68,j^2*q^65+(-4*j^2-3*j)*q^66-6*q^67+(-
4*j^2-3*j)*q^68+j^2*q^69,-50*q^18-81*q^20+165*q^21-165*q^24+81*q^25+
50*q^27,114*q^63-246*q^64+114*q^65,Unknown(),-15*q^63+(-50*j^2-
54*j)*q^64+(70*j^2+78*j)*q^65+(-50*j^2-54*j)*q^66-15*q^67,
720*j^2*q^84,Unknown(),184*j^2*q^84-352*j^2*q^85+184*j^2*q^86,-
6*j^2*q^21+25*j^2*q^22-44*j^2*q^23+44*j^2*q^24-25*j^2*q^25+
6*j^2*q^26,-360*j^2*q^84+360*j^2*q^85,114*j^2*q^84-
246*j^2*q^85+114*j^2*q^86,Unknown(),-26*j^2*q^84+88*j^2*q^85-
88*j^2*q^86+26*j^2*q^87,720*j*q^105,Unknown(),184*j*q^105-
352*j*q^106+184*j*q^107,-360*j*q^105+360*j*q^106,114*j*q^105-
246*j*q^106+114*j*q^107,Unknown(),-26*j*q^105+88*j*q^106-
88*j*q^107+26*j*q^108];end;
  f140:=function(q,j)local v;v:=GetRoot(q,3)*j;return
  [729,-405+324*q,162-243*q+81*q^2,225-360*q+144*q^2,-90+207*q-
153*q^2+36*q^3,-51+111*q-69*q^2+12*q^3,-27+54*q-27*q^2,-126+297*q-243*q^2+
63*q^3,-27*q+54*q^2-27*q^3,15*q-42*q^2+39*q^3-12*q^4,36-108*q+117*q^2-54*q^3+
9*q^4,13-38*q+34*q^2-11*q^3+q^4,3-9*q+6*q^2,-15+54*q-75*q^2+45*q^3-9*q^4,29-
83*q+88*q^2-38*q^3+5*q^4,15-42*q+39*q^2-12*q^3,51-153*q+177*q^2-90*q^3+15*q^4,
-8+26*q-35*q^2+22*q^3-6*q^4,8-37*q+66*q^2-58*q^3+25*q^4-4*q^5,q-q^2,Unknown(),
7-27*q+42*q^2-31*q^3+10*q^4-q^5,Unknown(),-12+41*q-57*q^2+39*q^3-12*q^4+q^5,-
3+10*q-12*q^2+6*q^3-q^4,-2+6*q-7*q^2+3*q^3,27-162*q^2+216*q^3-81*q^4,v^8,
Unknown(),3+9*q-45*q^2+45*q^3-12*q^4,v^40,54-108*q-27*q^2+162*q^3-54*q^4-
54*q^5+27*q^6,Unknown(),Unknown(),-15+12*q+90*q^2-192*q^3+141*q^4-36*q^5,-q+
7*q^2-9*q^3+3*q^4,-30+84*q-33*q^2-102*q^3+102*q^4+6*q^5-39*q^6+12*q^7,3*q-
9*q^2+16*q^3-16*q^4+7*q^5-q^6,-2-4*q+29*q^2-45*q^3+27*q^4-5*q^5,-3+30*q^2-
51*q^3+27*q^4-3*q^5,Unknown(),-21+78*q-84*q^2+39*q^4+3*q^5-24*q^6+9*q^7,
Unknown(),Unknown(),7-32*q+46*q^2-9*q^3-36*q^4+31*q^5-4*q^6-4*q^7+q^8,-4*q^2+
9*q^3-6*q^4+q^5,13*v^280-38*v^283+34*v^286-11*v^289+v^292,
13*v^56-38*v^59+34*v^62-11*v^65+v^68,2-q-17*q^2+41*q^3-
38*q^4+14*q^5-q^6,Unknown(),Unknown(),12-53*q+81*q^2-36*q^3-22*q^4+14*q^5+
15*q^6-15*q^7+4*q^8,Unknown(),Unknown(),Unknown(),-8*v^56+26*v^59-
35*v^62+22*v^65-6*v^68,Unknown(),Unknown(),7-24*q+11*q^2+48*q^3-
82*q^4+62*q^5-37*q^6+22*q^7-6*q^8-2*q^9+q^10,v^16,Unknown(),Unknown(),
v^32,-q^2-4*q^3+13*q^4-10*q^5+2*q^6,Unknown(),Unknown(),Unknown(),-
8*v^112+26*v^115-35*v^118+22*v^121-6*v^124,Unknown(),
Unknown(),-12*q^56+41*q^57-57*q^58+39*q^59-12*q^60+q^61,Unknown(),Unknown(),3-
9*q^2+6*q^3-21*q^4+66*q^5-69*q^6+30*q^7-12*q^8+6*q^9,q^8,-15*v^280+
54*v^283-75*v^286+45*v^289-9*v^292,-12*v^280+41*v^283-
57*v^286+39*v^289-12*v^292+v^295,Unknown(),3*q^4-3*q^5-9*q^6+
15*q^7-6*q^8,-15*v^56+54*v^59-75*v^62+45*v^65-9*v^68,
Unknown(),29*v^112-83*v^115+88*v^118-38*v^121+5*v^124,0,
Unknown(),Unknown(),13*v^112-38*v^115+34*v^118-11*v^121+
v^124,Unknown(),729*v^56,3*v^56-9*v^59+6*v^62,
225*v^56-360*v^59+144*v^62,Unknown(),-51*v^56+111*v^59-
69*v^62+12*v^65,-126*v^56+297*v^59-243*v^62+63*v^65,
36*v^56-108*v^59+117*v^62-54*v^65+9*v^68,Unknown(),
15*v^56-42*v^59+39*v^62-12*v^65,51*v^56-153*v^59+
177*v^62-90*v^65+15*v^68,8*v^56-37*v^59+66*v^62-
58*v^65+25*v^68-4*v^71,27*v^56-162*v^62+216*v^65-
81*v^68,54*v^56-108*v^59-27*v^62+162*v^65-54*v^68-
54*v^71+27*v^74,-3*v^56+30*v^62-51*v^65+27*v^68-
3*v^71,-15*v^56+12*v^59+90*v^62-192*v^65+141*v^68-
36*v^71,-30*v^56+84*v^59-33*v^62-102*v^65+102*v^68+
6*v^71-39*v^74+12*v^77,Unknown(),2*v^56-v^59-17*v^62+
41*v^65-38*v^68+14*v^71-v^74,-4*v^62+9*v^65-
6*v^68+v^71,-v^62-4*v^65+13*v^68-10*v^71+2*v^74,-
405*v^56+324*v^59,3*v^56-9*v^62+6*v^65-21*v^68+
66*v^71-69*v^74+30*v^77-12*v^80+6*v^83,-27*v^56+
54*v^59-27*v^62,162*v^56-243*v^59+81*v^62,Unknown(),-
90*v^56+207*v^59-153*v^62+36*v^65,3*v^68-3*v^71-
9*v^74+15*v^77-6*v^80,Unknown(),Unknown(),13*q^56-38*q^57+34*q^58-
11*q^59+q^60,Unknown(),q^16,29*v^56-83*v^59+88*v^62-38*v^65+
5*v^68,Unknown(),729*v^112,Unknown(),225*v^112-360*v^115+
144*v^118,-51*v^112+111*v^115-69*v^118+12*v^121,-
126*v^112+297*v^115-243*v^118+63*v^121,15*v^115-
42*v^118+39*v^121-12*v^124,8*v^112-37*v^115+66*v^118-
58*v^121+25*v^124-4*v^127,Unknown(),27*v^112-162*v^118+
216*v^121-81*v^124,-15*v^112+12*v^115+90*v^118-
192*v^121+141*v^124-36*v^127,-3*v^112+30*v^118-
51*v^121+27*v^124-3*v^127,-4*v^118+9*v^121-6*v^124+
v^127,-405*v^112+324*v^115,162*v^112-243*v^115+
81*v^118,-90*v^112+207*v^115-153*v^118+36*v^121,
3*v^124-3*v^127-9*v^130+15*v^133-6*v^136,-15*v^112+
54*v^115-75*v^118+45*v^121-9*v^124,13*v^224-38*v^227+
34*v^230-11*v^233+v^236,Unknown(),729*q^56,11*q^12-4*q^13-4*q^15+
2*q^16+90*q^20-152*q^21+70*q^22+28*q^24-32*q^25,Unknown(),-51*q^56+111*q^57-
69*q^58+12*q^59,Unknown(),Unknown(),27*q^56-162*q^58+216*q^59-81*q^60,
Unknown(),-3*q^56+30*q^58-51*q^59+27*q^60-3*q^61,-4*q^58+9*q^59-6*q^60+q^61,-
15*q^12+6*q^15-162*q^20+150*q^21-60*q^24,162*q^56-243*q^57+81*q^58,Unknown(),-
15*q^56+54*q^57-75*q^58+45*q^59-9*q^60,729*v^224,Unknown(),225*v^224-
360*v^227+144*v^230,-12*v^56+41*v^59-57*v^62+39*v^65-
12*v^68+v^71,-405*v^224+324*v^227,162*v^224-243*v^227+
81*v^230,Unknown(),-51*v^224+111*v^227-69*v^230+12*v^233,
729*v^280,Unknown(),225*v^280-360*v^283+144*v^286,-
405*v^280+324*v^283,162*v^280-243*v^283+81*v^286,
Unknown(),-51*v^280+111*v^283-69*v^286+12*v^289];end;
  f146:=function(q,j)return [756,-360+396*q,108-252*q+144*q^2,
168-384*q+204*q^2,-48+180*q-204*q^2+72*q^3,-21+87*q-105*q^2+39*q^3,-9+36*q+
(45*j^2+54*j)*q^2+18*q^3,-78+270*q-306*q^2+102*q^3,18+(54*j^2+
45*j)*q+36*q^2-9*q^3,-10+(-34*j^2-31*j)*q+(44*j^2+38*j)*q^2+
23*q^3-6*q^4,12-72*q+132*q^2-96*q^3+24*q^4,2-19*q+41*q^2-31*q^3+8*q^4,-3*q+(-
7*j^2-10*j)*q^2+(5*j^2+8*j)*q^3+q^4,-11+(-52*j^2-46*j)*q+
(80*j^2+74*j)*q^2+54*q^3-15*q^4,9-51*q+99*q^2-75*q^3+18*q^4,3-22*q+(-
43*j^2-46*j)*q^2+(32*j^2+38*j)*q^3+8*q^4,22-108*q+196*q^2-144*q^3+
34*q^4,-1+9*q-29*q^2+39*q^3-20*q^4+3*q^5,5+(30*j^2+28*j)*q+(-66*j^2-
60*j)*q^2+(68*j^2+64*j)*q^3+35*q^4-8*q^5,-q^2+(-j^2-2*j)*q^3+
j*q^4,Unknown(),2+(15*j^2+14*j)*q+(-38*j^2-34*j)*q^2+
(43*j^2+40*j)*q^3+23*q^4-5*q^5,Unknown(),-2+17*q-50*q^2+62*q^3-32*q^4+
5*q^5,2*q-10*q^2+14*q^3-7*q^4+q^5,q+(5*j^2+6*j)*q^2+(-7*j^2-
10*j)*q^3+(3*j^2+5*j)*q^4,9-108*q^2+216*q^3+(162*j^2+
135*j)*q^4+18*q^6,0,Unknown(),3*q-21*q^2+46*q^3+(37*j^2+34*j)*q^4+(-
8*j^2-5*j)*q^5+q^6,0,36-72*q+(45*j^2+54*j)*q^2+162*q^3-36*q^4+
(90*j^2+108*j)*q^5+45*q^6,Unknown(),Unknown(),-3+6*q+48*q^2-164*q^3+(-
190*j^2-181*j)*q^4+(84*j^2+66*j)*q^5-10*q^6+8*q^7,q^2+(5*j^2+
7*j)*q^3+(-7*j^2-9*j)*q^4+(4*j^2+3*j)*q^5-j^2*q^6,-16+52*q+
(17*j^2+14*j)*q^2+(100*j^2+106*j)*q^3+100*q^4+(-26*j^2-
32*j)*q^5+(67*j^2+79*j)*q^6+22*q^7,q+(9*j^2+7*j)*q^2+(-
19*j^2-15*j)*q^3+(19*j^2+16*j)*q^4+10*q^5+(2*j^2+3*j)*q^6,-
q+11*q^2-34*q^3+(-43*j^2-42*j)*q^4+(22*j^2+19*j)*q^5+(-3*j^2-
j)*q^6,10*q^2+(33*j^2+36*j)*q^3+(-47*j^2-44*j)*q^4+(25*j^2+
19*j)*q^5+q^7,Unknown(),-11+36*q+(28*j^2+16*j)*q^2+(13*j^2+
31*j)*q^3+(5*j^2-7*j)*q^4+64*q^5+(60*j^2+66*j)*q^6+17*q^7,
Unknown(),Unknown(),2-6*q-3*j^2*q^2+(-11*j^2-23*j)*q^3+(13*j^2+
28*j)*q^4+(11*j^2+j)*q^5+(-29*j^2-27*j)*q^6+(20*j^2+
22*j)*q^7+5*q^8,(-3*j^2-4*j)*q^3+(6*j^2+9*j)*q^4+6*q^5+
(3*j^2+j)*q^6,2*j*q^110-19*j*q^111+41*j*q^112-31*j*q^113+
8*j*q^114,2*j^2*q^22-19*j^2*q^23+41*j^2*q^24-31*j^2*q^25+
8*j^2*q^26,-4*q^2+(-21*j^2-22*j)*q^3+(41*j^2+42*j)*q^4+(-
37*j^2-33*j)*q^5+(12*j^2+8*j)*q^6-q^7,Unknown(),Unknown(),5-22*q+
(-30*j^2-26*j)*q^2+(7*j^2-7*j)*q^3+(j^2+17*j)*q^4+
(38*j^2+30*j)*q^5+(-62*j^2-64*j)*q^6+(37*j^2+41*j)*q^7+
8*q^8,Unknown(),Unknown(),Unknown(),-j^2*q^22+9*j^2*q^23-29*j^2*q^24+
39*j^2*q^25-20*j^2*q^26+3*j^2*q^27,Unknown(),Unknown(),2-4*q+
(8*j^2+9*j)*q^2+(-34*j^2-32*j)*q^3+(48*j^2+42*j)*q^4+(-
54*j^2-52*j)*q^5+(62*j^2+67*j)*q^6+(-40*j^2-46*j)*q^7+q^8+
(14*j^2+16*j)*q^9+5*q^10,0,Unknown(),Unknown(),0,5*q^4+(14*j^2+
12*j)*q^5+(-12*j^2-9*j)*q^6-2*q^7+j^2*q^8,Unknown(),Unknown(),
Unknown(),-j*q^44+9*j*q^45-29*j*q^46+39*j*q^47-20*j*q^48+
3*j*q^49,Unknown(),Unknown(),-2*q^66+17*q^67-50*q^68+62*q^69-32*q^70+
5*q^71,Unknown(),Unknown(),-3*q^2+2*q^3-9*q^4+(-48*j^2-42*j)*q^5+
(86*j^2+74*j)*q^6+(-68*j^2-62*j)*q^7+(18*j^2+21*j)*q^8+(-
2*j^2-8*j)*q^9+(5*j^2+8*j)*q^10+q^12,0,-11*j*q^110+(6*j^2+
52*j)*q^111+(-6*j^2-80*j)*q^112+54*j*q^113-15*j*q^114,-
2*j*q^110+17*j*q^111-50*j*q^112+62*j*q^113-32*j*q^114+
5*j*q^115,Unknown(),(2*j^2+8*j)*q^6+9*q^7+(15*j^2+6*j)*q^8+(-
11*j^2+j)*q^9-3*q^10,-11*j^2*q^22+(46*j^2-6*j)*q^23+(-
74*j^2+6*j)*q^24+54*j^2*q^25-15*j^2*q^26,Unknown(),9*j*q^44-
51*j*q^45+99*j*q^46-75*j*q^47+18*j*q^48,j^2*q^46-j^2*q^47,
Unknown(),Unknown(),2*j*q^44-19*j*q^45+41*j*q^46-31*j*q^47+
8*j*q^48,Unknown(),756*j^2*q^22,-3*j^2*q^23+(10*j^2+3*j)*q^24+
(-8*j^2-3*j)*q^25+j^2*q^26,168*j^2*q^22-384*j^2*q^23+
204*j^2*q^24,Unknown(),-21*j^2*q^22+87*j^2*q^23-105*j^2*q^24+
39*j^2*q^25,-78*j^2*q^22+270*j^2*q^23-306*j^2*q^24+
102*j^2*q^25,12*j^2*q^22-72*j^2*q^23+132*j^2*q^24-96*j^2*q^25+
24*j^2*q^26,Unknown(),3*j^2*q^22-22*j^2*q^23+(46*j^2+3*j)*q^24+
(-38*j^2-6*j)*q^25+8*j^2*q^26,22*j^2*q^22-108*j^2*q^23+
196*j^2*q^24-144*j^2*q^25+34*j^2*q^26,5*j^2*q^22+(-28*j^2+
2*j)*q^23+(60*j^2-6*j)*q^24+(-64*j^2+4*j)*q^25+35*j^2*q^26-
8*j^2*q^27,9*j^2*q^22-108*j^2*q^24+216*j^2*q^25+(-135*j^2+
27*j)*q^26+18*j^2*q^28,36*j^2*q^22-72*j^2*q^23+(-54*j^2-
9*j)*q^24+162*j^2*q^25-36*j^2*q^26+(-108*j^2-18*j)*q^27+
45*j^2*q^28,10*j^2*q^24+(-36*j^2-3*j)*q^25+(44*j^2-
3*j)*q^26+(-19*j^2+6*j)*q^27+j^2*q^29,-3*j^2*q^22+
6*j^2*q^23+48*j^2*q^24-164*j^2*q^25+(181*j^2-9*j)*q^26+(-
66*j^2+18*j)*q^27-10*j^2*q^28+8*j^2*q^29,-16*j^2*q^22+
52*j^2*q^23+(-14*j^2+3*j)*q^24+(-106*j^2-6*j)*q^25+
100*j^2*q^26+(32*j^2+6*j)*q^27+(-79*j^2-12*j)*q^28+
22*j^2*q^29,Unknown(),-4*j^2*q^24+(22*j^2+j)*q^25+(-42*j^2-
j)*q^26+(33*j^2-4*j)*q^27+(-8*j^2+4*j)*q^28-j^2*q^29,
(4*j^2+j)*q^25+(-9*j^2-3*j)*q^26+6*j^2*q^27+(-j^2+
2*j)*q^28,5*j^2*q^26+(-12*j^2+2*j)*q^27+(9*j^2-3*j)*q^28-
2*j^2*q^29+j*q^30,-360*j^2*q^22+396*j^2*q^23,-3*j^2*q^24+
2*j^2*q^25-9*j^2*q^26+(42*j^2-6*j)*q^27+(-74*j^2+12*j)*q^28+
(62*j^2-6*j)*q^29+(-21*j^2-3*j)*q^30+(8*j^2+6*j)*q^31+(-
8*j^2-3*j)*q^32+j^2*q^34,-9*j^2*q^22+36*j^2*q^23+(-54*j^2-
9*j)*q^24+18*j^2*q^25,108*j^2*q^22-252*j^2*q^23+144*j^2*q^24,
Unknown(),-48*j^2*q^22+180*j^2*q^23-204*j^2*q^24+72*j^2*q^25,(-
8*j^2-6*j)*q^28+9*j^2*q^29+(-6*j^2+9*j)*q^30+(-j^2-
12*j)*q^31-3*j^2*q^32,Unknown(),Unknown(),2*q^66-19*q^67+41*q^68-
31*q^69+8*q^70,Unknown(),0,9*j^2*q^22-51*j^2*q^23+99*j^2*q^24-
75*j^2*q^25+18*j^2*q^26,Unknown(),756*j*q^44,Unknown(),168*j*q^44-
384*j*q^45+204*j*q^46,-21*j*q^44+87*j*q^45-105*j*q^46+
39*j*q^47,-78*j*q^44+270*j*q^45-306*j*q^46+102*j*q^47,-
10*j*q^44+(3*j^2+34*j)*q^45+(-6*j^2-44*j)*q^46+23*j*q^47-
6*j*q^48,5*j*q^44+(-2*j^2-30*j)*q^45+(6*j^2+66*j)*q^46+(-
4*j^2-68*j)*q^47+35*j*q^48-8*j*q^49,Unknown(),9*j*q^44-
108*j*q^46+216*j*q^47+(-27*j^2-162*j)*q^48+18*j*q^50,-
3*j*q^44+6*j*q^45+48*j*q^46-164*j*q^47+(9*j^2+190*j)*q^48+(-
18*j^2-84*j)*q^49-10*j*q^50+8*j*q^51,10*j*q^46+(3*j^2-
33*j)*q^47+(3*j^2+47*j)*q^48+(-6*j^2-25*j)*q^49+j*q^51,(-
j^2+3*j)*q^47+(3*j^2-6*j)*q^48+6*j*q^49+(-2*j^2-
3*j)*q^50,-360*j*q^44+396*j*q^45,108*j*q^44-252*j*q^45+
144*j*q^46,-48*j*q^44+180*j*q^45-204*j*q^46+72*j*q^47,
(6*j^2-2*j)*q^50+9*j*q^51+(-9*j^2-15*j)*q^52+(12*j^2+
11*j)*q^53-3*j*q^54,-11*j*q^44+(6*j^2+52*j)*q^45+(-6*j^2-
80*j)*q^46+54*j*q^47-15*j*q^48,2*j^2*q^88-19*j^2*q^89+
41*j^2*q^90-31*j^2*q^91+8*j^2*q^92,Unknown(),756*q^66,-24*q^18+
16*q^19+45*q^20-84*q^21+42*q^22+49*q^24-128*q^25+90*q^26+16*q^27-24*q^28+
10*q^30-20*q^31,Unknown(),-21*q^66+87*q^67-105*q^68+39*q^69,Unknown(),
Unknown(),9*q^66-108*q^68+216*q^69+(162*j^2+135*j)*q^70+18*q^72,
Unknown(),10*q^68+(33*j^2+36*j)*q^69+(-47*j^2-44*j)*q^70+
(25*j^2+19*j)*q^71+q^73,(-3*j^2-4*j)*q^69+(6*j^2+9*j)*q^70+
6*q^71+(3*j^2+j)*q^72,40*q^18-81*q^20+90*q^21-105*q^24+162*q^25-40*q^27-
30*q^30,108*q^66-252*q^67+144*q^68,Unknown(),-11*q^66+(-52*j^2-
46*j)*q^67+(80*j^2+74*j)*q^68+54*q^69-15*q^70,756*j^2*q^88,
Unknown(),168*j^2*q^88-384*j^2*q^89+204*j^2*q^90,-2*j^2*q^22+
17*j^2*q^23-50*j^2*q^24+62*j^2*q^25-32*j^2*q^26+5*j^2*q^27,-
360*j^2*q^88+396*j^2*q^89,108*j^2*q^88-252*j^2*q^89+
144*j^2*q^90,Unknown(),-21*j^2*q^88+87*j^2*q^89-105*j^2*q^90+
39*j^2*q^91,756*j*q^110,Unknown(),168*j*q^110-384*j*q^111+
204*j*q^112,-360*j*q^110+396*j*q^111,108*j*q^110-252*j*q^111+
144*j*q^112,Unknown(),-21*j*q^110+87*j*q^111-105*j*q^112+39*j*q^113];end;
  f150:=function(q,j)return [840,-400+440*q,119-281*q+159*q^2,188-424*q+228*q^2,
  -54+199*q-225*q^2+81*q^3,-24+95*q-117*q^2+42*q^3,-6+(-36*j^2-44*j)*q+
(48*j^2+54*j)*q^2+24*q^3,-87+303*q-333*q^2+117*q^3,27+(54*j^2+
48*j)*q+(-44*j^2-36*j)*q^2-9*q^3,-14+(-39*j^2-37*j)*q+
(48*j^2+40*j)*q^2+(-28*j^2-24*j)*q^3-5*q^4,14-80*q+144*q^2-
106*q^3+28*q^4,3-21*q+44*q^2-34*q^3+8*q^4,(j^2+3*j)*q+(-6*j^2-
11*j)*q^2+(6*j^2+8*j)*q^3+2*q^4,-15+(-58*j^2-54*j)*q+
(87*j^2+78*j)*q^2+(-62*j^2-56*j)*q^3-16*q^4,10-58*q+108*q^2-
81*q^3+21*q^4,2+(20*j^2+24*j)*q+(-44*j^2-50*j)*q^2+(36*j^2+
40*j)*q^3+12*q^4,24-123*q+215*q^2-156*q^3+41*q^4,-1+11*q-33*q^2+40*q^3-
21*q^4+4*q^5,7+(35*j^2+34*j)*q+(-72*j^2-65*j)*q^2+(76*j^2+
68*j)*q^3+(-40*j^2-37*j)*q^4-8*q^5,j*q^2+(-j^2-2*j)*q^3+
j*q^4,Unknown(),3+(18*j^2+17*j)*q+(-41*j^2-37*j)*q^2+
(47*j^2+41*j)*q^3+(-26*j^2-24*j)*q^4-5*q^5,Unknown(),-2+20*q-
56*q^2+65*q^3-35*q^4+7*q^5,3*q-11*q^2+14*q^3-7*q^4+q^5,-j*q+(4*j^2+
7*j)*q^2+(-6*j^2-10*j)*q^3+(4*j^2+5*j)*q^4+q^5,6+(132*j^2+
108*j)*q^2+264*q^3+(162*j^2+144*j)*q^4+24*q^6,0,Unknown(),(-3*j^2-
j)*q+(25*j^2+23*j)*q^2+52*q^3+(42*j^2+40*j)*q^4+(-8*j^2-
6*j)*q^5+2*q^6,0,39+(72*j^2+88*j)*q+(48*j^2+54*j)*q^2+198*q^3+
(36*j^2+44*j)*q^4+(96*j^2+108*j)*q^5+57*q^6,Unknown(),Unknown(),-
2+4*q+(-60*j^2-48*j)*q^2+(200*j^2+188*j)*q^3+(-214*j^2-
208*j)*q^4+(84*j^2+72*j)*q^5-12*q^6+12*q^7,q^2+(5*j^2+8*j)*q^3+
(-8*j^2-10*j)*q^4+(5*j^2+4*j)*q^5-j^2*q^6,-18+(-53*j^2-
61*j)*q+(16*j^2+22*j)*q^2+(120*j^2+124*j)*q^3+(-118*j^2-
122*j)*q^4+28*q^5+(76*j^2+84*j)*q^6+29*q^7,2*q+(11*j^2+
9*j)*q^2+(-21*j^2-16*j)*q^3+(21*j^2+15*j)*q^4+(-10*j^2-
9*j)*q^5+(2*j^2+3*j)*q^6,j^2*q+(-13*j^2-11*j)*q^2+
(39*j^2+38*j)*q^3+(-48*j^2-47*j)*q^4+(25*j^2+23*j)*q^5+(-
3*j^2-2*j)*q^6+q^7,(-11*j^2-7*j)*q^2+(42*j^2+41*j)*q^3+(-
53*j^2-54*j)*q^4+(24*j^2+20*j)*q^5+2*q^7,Unknown(),-15+(-
42*j^2-46*j)*q+(37*j^2+29*j)*q^2+(17*j^2+40*j)*q^3+(-
3*j^2-28*j)*q^4+(-70*j^2-58*j)*q^5+(64*j^2+68*j)*q^6+20*q^7,
Unknown(),Unknown(),3-10*q+(-9*j^2-5*j)*q^2+(-10*j^2-25*j)*q^3+
(21*j^2+44*j)*q^4+(5*j^2-14*j)*q^5+(-28*j^2-22*j)*q^6+
(20*j^2+22*j)*q^7+5*q^8,(-3*j^2-4*j)*q^3+(8*j^2+11*j)*q^4+(-
6*j^2-7*j)*q^5+(3*j^2+j)*q^6,-3*j^2*q^110+21*j^2*q^111-
44*j^2*q^112+34*j^2*q^113-8*j^2*q^114,-3*j*q^22+21*j*q^23-
44*j*q^24+34*j*q^25-8*j*q^26,(4*j^2+2*j)*q^2+(-27*j^2-
24*j)*q^3+(48*j^2+49*j)*q^4+(-39*j^2-37*j)*q^5+(12*j^2+
10*j)*q^6-q^7+q^8,Unknown(),Unknown(),7+(26*j^2+28*j)*q+38*q^2+
(12*j^2-3*j)*q^3+(7*j^2+32*j)*q^4+(34*j^2+14*j)*q^5+(-
66*j^2-62*j)*q^6+(42*j^2+44*j)*q^7+10*q^8,Unknown(),Unknown(),
Unknown(),j*q^22-11*j*q^23+33*j*q^24-40*j*q^25+21*j*q^26-
4*j*q^27,Unknown(),Unknown(),3-6*q+(7*j^2+8*j)*q^2+(-36*j^2-
38*j)*q^3+(53*j^2+51*j)*q^4+(-60*j^2-56*j)*q^5+(75*j^2+
73*j)*q^6+(-50*j^2-54*j)*q^7+2*j*q^8+(14*j^2+16*j)*q^9+
5*q^10,0,Unknown(),Unknown(),0,(-7*j^2-4*j)*q^4+(16*j^2+14*j)*q^5+
(-12*j^2-11*j)*q^6-2*q^7+j^2*q^8,Unknown(),Unknown(),Unknown(),-
j^2*q^44+11*j^2*q^45-33*j^2*q^46+40*j^2*q^47-21*j^2*q^48+
4*j^2*q^49,Unknown(),Unknown(),2*q^66-20*q^67+56*q^68-65*q^69+35*q^70-
7*q^71,Unknown(),Unknown(),(j^2+3*j)*q^2+(-4*j^2-8*j)*q^3+
(15*j^2+17*j)*q^4+(-54*j^2-44*j)*q^5+(96*j^2+76*j)*q^6+(-
66*j^2-56*j)*q^7+(8*j^2+10*j)*q^8-4*j*q^9+(6*j^2+
8*j)*q^10+2*q^12,0,15*j^2*q^110+(-54*j^2+4*j)*q^111+(78*j^2-
9*j)*q^112+(-56*j^2+6*j)*q^113+16*j^2*q^114,2*j^2*q^110-
20*j^2*q^111+56*j^2*q^112-65*j^2*q^113+35*j^2*q^114-
7*j^2*q^115,Unknown(),(3*j^2-6*j)*q^6+(-21*j^2-12*j)*q^7+
(24*j^2+15*j)*q^8+(-5*j^2-2*j)*q^9+3*q^10,15*j*q^22+(-4*j^2-
58*j)*q^23+(9*j^2+87*j)*q^24+(-6*j^2-62*j)*q^25+16*j*q^26,
Unknown(),10*j^2*q^44-58*j^2*q^45+108*j^2*q^46-81*j^2*q^47+
21*j^2*q^48,-q^47,Unknown(),Unknown(),3*j^2*q^44-21*j^2*q^45+
44*j^2*q^46-34*j^2*q^47+8*j^2*q^48,Unknown(),-840*j*q^22,(-
2*j^2+j)*q^23+(5*j^2-6*j)*q^24+(-2*j^2+6*j)*q^25-
2*j*q^26,-188*j*q^22+424*j*q^23-228*j*q^24,Unknown(),24*j*q^22-
95*j*q^23+117*j*q^24-42*j*q^25,87*j*q^22-303*j*q^23+
333*j*q^24-117*j*q^25,-14*j*q^22+80*j*q^23-144*j*q^24+
106*j*q^25-28*j*q^26,Unknown(),-2*j*q^22+(-4*j^2+20*j)*q^23+
(6*j^2-44*j)*q^24+(-4*j^2+36*j)*q^25-12*j*q^26,-24*j*q^22+
123*j*q^23-215*j*q^24+156*j*q^25-41*j*q^26,-7*j*q^22+(j^2+
35*j)*q^23+(-7*j^2-72*j)*q^24+(8*j^2+76*j)*q^25+(-3*j^2-
40*j)*q^26+8*j*q^27,-6*j*q^22+(24*j^2+132*j)*q^24-
264*j*q^25+(18*j^2+162*j)*q^26-24*j*q^28,-39*j*q^22+(-
16*j^2+72*j)*q^23+(-6*j^2+48*j)*q^24-198*j*q^25+(-8*j^2+
36*j)*q^26+(-12*j^2+96*j)*q^27-57*j*q^28,(-4*j^2-11*j)*q^24+
(j^2+42*j)*q^25+(j^2-53*j)*q^26+(4*j^2+24*j)*q^27-
2*j*q^29,2*j*q^22-4*j*q^23+(-12*j^2-60*j)*q^24+(12*j^2+
200*j)*q^25+(-6*j^2-214*j)*q^26+(12*j^2+84*j)*q^27+
12*j*q^28-12*j*q^29,18*j*q^22+(8*j^2-53*j)*q^23+(-6*j^2+
16*j)*q^24+(-4*j^2+120*j)*q^25+(4*j^2-118*j)*q^26-28*j*q^27+
(-8*j^2+76*j)*q^28-29*j*q^29,Unknown(),(2*j^2+4*j)*q^24+(-
3*j^2-27*j)*q^25+(-j^2+48*j)*q^26+(-2*j^2-39*j)*q^27+
(2*j^2+12*j)*q^28+j*q^29-j*q^30,(j^2-3*j)*q^25+(-3*j^2+
8*j)*q^26+(j^2-6*j)*q^27+(2*j^2+3*j)*q^28,(-3*j^2-
7*j)*q^26+(2*j^2+16*j)*q^27+(-j^2-12*j)*q^28+2*j*q^29-q^30,
400*j*q^22-440*j*q^23,(-2*j^2+j)*q^24+(4*j^2-4*j)*q^25+(-
2*j^2+15*j)*q^26+(-10*j^2-54*j)*q^27+(20*j^2+96*j)*q^28+(-
10*j^2-66*j)*q^29+(-2*j^2+8*j)*q^30+4*j^2*q^31+(-2*j^2+
6*j)*q^32-2*j*q^34,6*j*q^22+(8*j^2-36*j)*q^23+(-6*j^2+
48*j)*q^24-24*j*q^25,-119*j*q^22+281*j*q^23-159*j*q^24,
Unknown(),54*j*q^22-199*j*q^23+225*j*q^24-81*j*q^25,(9*j^2+
3*j)*q^28+(-9*j^2-21*j)*q^29+(9*j^2+24*j)*q^30+(-3*j^2-
5*j)*q^31-3*j*q^32,Unknown(),Unknown(),-3*q^66+21*q^67-44*q^68+34*q^69-
8*q^70,Unknown(),0,-10*j*q^22+58*j*q^23-108*j*q^24+81*j*q^25-
21*j*q^26,Unknown(),840*j^2*q^44,Unknown(),188*j^2*q^44-
424*j^2*q^45+228*j^2*q^46,-24*j^2*q^44+95*j^2*q^45-
117*j^2*q^46+42*j^2*q^47,-87*j^2*q^44+303*j^2*q^45-
333*j^2*q^46+117*j^2*q^47,-14*j^2*q^44+(37*j^2-2*j)*q^45+(-
40*j^2+8*j)*q^46+(24*j^2-4*j)*q^47-5*j^2*q^48,7*j^2*q^44+(-
34*j^2+j)*q^45+(65*j^2-7*j)*q^46+(-68*j^2+8*j)*q^47+
(37*j^2-3*j)*q^48-8*j^2*q^49,Unknown(),6*j^2*q^44+(-108*j^2+
24*j)*q^46+264*j^2*q^47+(-144*j^2+18*j)*q^48+24*j^2*q^50,-
2*j^2*q^44+4*j^2*q^45+(48*j^2-12*j)*q^46+(-188*j^2+
12*j)*q^47+(208*j^2-6*j)*q^48+(-72*j^2+12*j)*q^49-
12*j^2*q^50+12*j^2*q^51,(7*j^2-4*j)*q^46+(-41*j^2+j)*q^47+
(54*j^2+j)*q^48+(-20*j^2+4*j)*q^49+2*j^2*q^51,(4*j^2+
j)*q^47+(-11*j^2-3*j)*q^48+(7*j^2+j)*q^49+(-j^2+
2*j)*q^50,-400*j^2*q^44+440*j^2*q^45,119*j^2*q^44-281*j^2*q^45+
159*j^2*q^46,-54*j^2*q^44+199*j^2*q^45-225*j^2*q^46+
81*j^2*q^47,(6*j^2+9*j)*q^50+(12*j^2-9*j)*q^51+(-15*j^2+
9*j)*q^52+(2*j^2-3*j)*q^53+3*j^2*q^54,-15*j^2*q^44+(54*j^2-
4*j)*q^45+(-78*j^2+9*j)*q^46+(56*j^2-6*j)*q^47-16*j^2*q^48,
3*j*q^88-21*j*q^89+44*j*q^90-34*j*q^91+8*j*q^92,Unknown(),-
840*q^66,18*q^18-12*q^19+45*q^20-100*q^21+56*q^22+91*q^24-176*q^25+90*q^26+
4*q^27-6*q^28+2*q^30-4*q^31,Unknown(),24*q^66-95*q^67+117*q^68-42*q^69,
Unknown(),Unknown(),-6*q^66+(-132*j^2-108*j)*q^68-264*q^69+(-162*j^2-
144*j)*q^70-24*q^72,Unknown(),(11*j^2+7*j)*q^68+(-42*j^2-
41*j)*q^69+(53*j^2+54*j)*q^70+(-24*j^2-20*j)*q^71-2*q^73,
(3*j^2+4*j)*q^69+(-8*j^2-11*j)*q^70+(6*j^2+7*j)*q^71+(-
3*j^2-j)*q^72,-30*q^18-81*q^20+120*q^21-195*q^24+162*q^25-10*q^27-
6*q^30,-119*q^66+281*q^67-159*q^68,Unknown(),15*q^66+(58*j^2+54*j)*q^67+
(-87*j^2-78*j)*q^68+(62*j^2+56*j)*q^69+16*q^70,840*j*q^88,
Unknown(),188*j*q^88-424*j*q^89+228*j*q^90,2*j*q^22-20*j*q^23+
56*j*q^24-65*j*q^25+35*j*q^26-7*j*q^27,-400*j*q^88+
440*j*q^89,119*j*q^88-281*j*q^89+159*j*q^90,Unknown(),-
24*j*q^88+95*j*q^89-117*j*q^90+42*j*q^91,-840*j^2*q^110,
Unknown(),-188*j^2*q^110+424*j^2*q^111-228*j^2*q^112,
400*j^2*q^110-440*j^2*q^111,-119*j^2*q^110+281*j^2*q^111-159*j^2*q^112,
Unknown(),24*j^2*q^110-95*j^2*q^111+117*j^2*q^112-42*j^2*q^113];end;
 f154:=function(q,j) return [840,-380+460*q,102-278*q+182*q^2,168-424*q+248*q^2,
 -43+184*q-240*q^2+95*q^3,-16+86*q-126*q^2+56*q^3,-6+(-36*j^2-30*j)*q+
(60*j^2+62*j)*q^2+30*q^3,-72+288*q-348*q^2+132*q^3,24+(62*j^2+
60*j)*q+(-30*j^2-36*j)*q^2,-11+(-43*j^2-41*j)*q+(44*j^2+
48*j)*q^2+(-15*j^2-17*j)*q^3-3*q^4,10-66*q+144*q^2-122*q^3+34*q^4,1-
15*q+44*q^2-43*q^3+13*q^4,(2*j^2+j)*q+(-10*j^2-8*j)*q^2+
(10*j^2+11*j)*q^3+3*q^4,-10+(-52*j^2-51*j)*q+(84*j^2+
86*j)*q^2+(-58*j^2-63*j)*q^3-17*q^4,6-47*q+108*q^2-95*q^3+28*q^4,2+
(20*j^2+16*j)*q+48*q^2-48*q^3+14*q^4,17-107*q+214*q^2-175*q^3+49*q^4,
7*q-29*q^2+45*q^3-29*q^4+6*q^5,4+(29*j^2+28*j)*q+(-67*j^2-
68*j)*q^2+(72*j^2+76*j)*q^3+(-39*j^2-41*j)*q^4-10*q^5,-q^2+
2*q^3-q^4,Unknown(),1+(13*j^2+12*j)*q+(-37*j^2-38*j)*q^2+
(46*j^2+49*j)*q^3+(-29*j^2-30*j)*q^4-8*q^5,Unknown(),-1+14*q-
50*q^2+72*q^3-44*q^4+9*q^5,q-9*q^2+17*q^3-11*q^4+2*q^5,-j^2*q+(6*j^2+
5*j)*q^2+10*q^3-7*q^4+q^5,6+(90*j^2+108*j)*q^2+240*q^3+(186*j^2+
180*j)*q^4+30*q^6,0,Unknown(),(-j^2-2*j)*q+(17*j^2+18*j)*q^2+
49*q^3+(49*j^2+48*j)*q^4+(-11*j^2-10*j)*q^5+3*q^6,0,36+(72*j^2+
60*j)*q+(60*j^2+62*j)*q^2+180*q^3+(36*j^2+30*j)*q^4+
(120*j^2+124*j)*q^5+60*q^6,Unknown(),Unknown(),-2+4*q+(-36*j^2-
48*j)*q^2+(158*j^2+164*j)*q^3+(-226*j^2-220*j)*q^4-96*q^5-
16*q^6+14*q^7,(5*j^2+3*j)*q^3+(-12*j^2-10*j)*q^4+(7*j^2+
8*j)*q^5+q^6,-15+(-53*j^2-45*j)*q+(12*j^2+6*j)*q^2-110*q^3+(-
118*j^2-114*j)*q^4+(-36*j^2-42*j)*q^5-93*q^6+31*q^7,q+(7*j^2+
8*j)*q^2+(-18*j^2-20*j)*q^3+(18*j^2+20*j)*q^4+(-9*j^2-
11*j)*q^5-3*q^6,j*q+(-7*j^2-8*j)*q^2-32*q^3+(-52*j^2-
51*j)*q^4+(31*j^2+30*j)*q^5+3*q^6+q^7,(-5*j^2-7*j)*q^2+
(31*j^2+34*j)*q^3+(-57*j^2-54*j)*q^4+(34*j^2+32*j)*q^5+
3*q^7,Unknown(),-10+(-30*j^2-28*j)*q+(8*j^2+6*j)*q^2+(39*j^2+
34*j)*q^3+(j^2+12*j)*q^4+(-87*j^2-97*j)*q^5+(84*j^2+
86*j)*q^6+23*q^7,Unknown(),Unknown(),1-4*q-5*q^2+(-30*j^2-26*j)*q^3+
(30*j^2+21*j)*q^4+(12*j^2+21*j)*q^5+(-46*j^2-49*j)*q^6-
32*q^7+8*q^8,q^3+(9*j^2+6*j)*q^4+(-12*j^2-11*j)*q^5+(3*j^2+
4*j)*q^6,-j^2*q^115+15*j^2*q^116-44*j^2*q^117+43*j^2*q^118-
13*j^2*q^119,-j*q^23+15*j*q^24-44*j*q^25+43*j*q^26-
13*j*q^27,(j^2+3*j)*q^2+(-16*j^2-18*j)*q^3+(45*j^2+
44*j)*q^4+(-49*j^2-46*j)*q^5-16*q^6-2*q^7+q^8,Unknown(),Unknown(),4+
(18*j^2+16*j)*q+(-19*j^2-17*j)*q^2+(-11*j^2-9*j)*q^3+
(18*j^2+9*j)*q^4+(40*j^2+51*j)*q^5+(-85*j^2-91*j)*q^6-
55*q^7+12*q^8,Unknown(),Unknown(),Unknown(),-7*j*q^24+29*j*q^25-
45*j*q^26+29*j*q^27-6*j*q^28,Unknown(),Unknown(),1-2*q+(8*j^2+
9*j)*q^2+(-30*j^2-28*j)*q^3+(40*j^2+37*j)*q^4+58*q^5+
(81*j^2+84*j)*q^6+(-52*j^2-54*j)*q^7+(-8*j^2-7*j)*q^8-
24*q^9+8*q^10,0,Unknown(),Unknown(),0,(-3*j^2-5*j)*q^4+(12*j^2+
14*j)*q^5+14*q^6+(4*j^2+2*j)*q^7-q^8,Unknown(),Unknown(),Unknown(),
7*j^2*q^47-29*j^2*q^48+45*j^2*q^49-29*j^2*q^50+6*j^2*q^51,
Unknown(),Unknown(),q^69-14*q^70+50*q^71-72*q^72+44*q^73-9*q^74,Unknown(),
Unknown(),(2*j^2+j)*q^2+(-4*j^2-2*j)*q^3+(6*j^2+5*j)*q^4+(-
38*j^2-42*j)*q^5+(81*j^2+89*j)*q^6+(-76*j^2-80*j)*q^7+
(24*j^2+25*j)*q^8+(-2*j^2-4*j)*q^9+(10*j^2+11*j)*q^10+
3*q^12,0,10*j^2*q^115+(-51*j^2+j)*q^116+(86*j^2+2*j)*q^117+(-
63*j^2-5*j)*q^118+17*j^2*q^119,j^2*q^115-14*j^2*q^116+
50*j^2*q^117-72*j^2*q^118+44*j^2*q^119-9*j^2*q^120,Unknown(),-
9*j*q^7-21*q^8+(-13*j^2-4*j)*q^9+3*q^10-3*q^11,10*j*q^23+(-j^2-
52*j)*q^24+(-2*j^2+84*j)*q^25+(5*j^2-58*j)*q^26+17*j*q^27,
Unknown(),6*j^2*q^46-47*j^2*q^47+108*j^2*q^48-95*j^2*q^49+
28*j^2*q^50,j^2*q^49,Unknown(),Unknown(),j^2*q^46-15*j^2*q^47+
44*j^2*q^48-43*j^2*q^49+13*j^2*q^50,Unknown(),-840*j*q^23,(j^2+
2*j)*q^24+(-2*j^2-10*j)*q^25+(-j^2+10*j)*q^26-3*j*q^27,-
168*j*q^23+424*j*q^24-248*j*q^25,Unknown(),16*j*q^23-86*j*q^24+
126*j*q^25-56*j*q^26,72*j*q^23-288*j*q^24+348*j*q^25-
132*j*q^26,-10*j*q^23+66*j*q^24-144*j*q^25+122*j*q^26-
34*j*q^27,Unknown(),-2*j*q^23+(4*j^2+20*j)*q^24-48*j*q^25+
48*j*q^26-14*j*q^27,-17*j*q^23+107*j*q^24-214*j*q^25+
175*j*q^26-49*j*q^27,-4*j*q^23+(j^2+29*j)*q^24+(j^2-
67*j)*q^25+(-4*j^2+72*j)*q^26+(2*j^2-39*j)*q^27+10*j*q^28,-
6*j*q^23+(-18*j^2+90*j)*q^25-240*j*q^26+(6*j^2+186*j)*q^27-
30*j*q^29,-36*j*q^23+(12*j^2+72*j)*q^24+(-2*j^2+60*j)*q^25-
180*j*q^26+(6*j^2+36*j)*q^27+(-4*j^2+120*j)*q^28-60*j*q^29,
(2*j^2-5*j)*q^25+(-3*j^2+31*j)*q^26+(-3*j^2-57*j)*q^27+
(2*j^2+34*j)*q^28-3*j*q^30,2*j*q^23-4*j*q^24+(12*j^2-
36*j)*q^25+(-6*j^2+158*j)*q^26+(-6*j^2-226*j)*q^27+
96*j*q^28+16*j*q^29-14*j*q^30,15*j*q^23+(-8*j^2-53*j)*q^24+
(6*j^2+12*j)*q^25+110*j*q^26+(-4*j^2-118*j)*q^27+(6*j^2-
36*j)*q^28+93*j*q^29-31*j*q^30,Unknown(),(-2*j^2+j)*q^25+
(2*j^2-16*j)*q^26+(j^2+45*j)*q^27+(-3*j^2-49*j)*q^28+
16*j*q^29+2*j*q^30-j*q^31,-j*q^26+(3*j^2+9*j)*q^27+(-j^2-
12*j)*q^28+(-j^2+3*j)*q^29,(2*j^2-3*j)*q^27+(-2*j^2+
12*j)*q^28-14*j*q^29+(2*j^2+4*j)*q^30+j*q^31,380*j*q^23-
460*j*q^24,(j^2+2*j)*q^25+(-2*j^2-4*j)*q^26+(j^2+
6*j)*q^27+(4*j^2-38*j)*q^28+(-8*j^2+81*j)*q^29+(4*j^2-
76*j)*q^30+(-j^2+24*j)*q^31+(2*j^2-2*j)*q^32+(-j^2+
10*j)*q^33-3*j*q^35,6*j*q^23+(-6*j^2-36*j)*q^24+(-2*j^2+
60*j)*q^25-30*j*q^26,-102*j*q^23+278*j*q^24-182*j*q^25,
Unknown(),43*j*q^23-184*j*q^24+240*j*q^25-95*j*q^26,9*j^2*q^30+
21*j*q^31+(-9*j^2-13*j)*q^32-3*j*q^33+3*j*q^34,Unknown(),
Unknown(),-q^69+15*q^70-44*q^71+43*q^72-13*q^73,Unknown(),0,-6*j*q^23+
47*j*q^24-108*j*q^25+95*j*q^26-28*j*q^27,Unknown(),
840*j^2*q^46,Unknown(),168*j^2*q^46-424*j^2*q^47+248*j^2*q^48,-
16*j^2*q^46+86*j^2*q^47-126*j^2*q^48+56*j^2*q^49,-72*j^2*q^46+
288*j^2*q^47-348*j^2*q^48+132*j^2*q^49,-11*j^2*q^46+(41*j^2-
2*j)*q^47+(-48*j^2-4*j)*q^48+(17*j^2+2*j)*q^49-3*j^2*q^50,
4*j^2*q^46+(-28*j^2+j)*q^47+(68*j^2+j)*q^48+(-76*j^2-
4*j)*q^49+(41*j^2+2*j)*q^50-10*j^2*q^51,Unknown(),6*j^2*q^46+(-
108*j^2-18*j)*q^48+240*j^2*q^49+(-180*j^2+6*j)*q^50+
30*j^2*q^52,-2*j^2*q^46+4*j^2*q^47+(48*j^2+12*j)*q^48+(-
164*j^2-6*j)*q^49+(220*j^2-6*j)*q^50-96*j^2*q^51-
16*j^2*q^52+14*j^2*q^53,(7*j^2+2*j)*q^48+(-34*j^2-3*j)*q^49+
(54*j^2-3*j)*q^50+(-32*j^2+2*j)*q^51+3*j^2*q^53,j^2*q^49+(-
6*j^2+3*j)*q^50+(11*j^2-j)*q^51+(-4*j^2-j)*q^52,-
380*j^2*q^46+460*j^2*q^47,102*j^2*q^46-278*j^2*q^47+
182*j^2*q^48,-43*j^2*q^46+184*j^2*q^47-240*j^2*q^48+
95*j^2*q^49,-9*q^53-21*j^2*q^54+(4*j^2-9*j)*q^55+3*j^2*q^56-
3*j^2*q^57,-10*j^2*q^46+(51*j^2-j)*q^47+(-86*j^2-2*j)*q^48+
(63*j^2+5*j)*q^49-17*j^2*q^50,j*q^92-15*j*q^93+44*j*q^94-
43*j*q^95+13*j*q^96,Unknown(),-840*q^69,45*q^20-60*q^21+21*q^22+77*q^24-
160*q^25+90*q^26+20*q^27-30*q^28+2*q^30-4*q^31-4*q^33+11*q^34,Unknown(),
16*q^69-86*q^70+126*q^71-56*q^72,Unknown(),Unknown(),-6*q^69+(-90*j^2-
108*j)*q^71-240*q^72+(-186*j^2-180*j)*q^73-30*q^75,Unknown(),
(5*j^2+7*j)*q^71+(-31*j^2-34*j)*q^72+(57*j^2+54*j)*q^73+(-
34*j^2-32*j)*q^74-3*q^76,-q^72+(-9*j^2-6*j)*q^73+(12*j^2+
11*j)*q^74+(-3*j^2-4*j)*q^75,-81*q^20+45*q^21-165*q^24+162*q^25-
50*q^27-6*q^30+15*q^33,-102*q^69+278*q^70-182*q^71,Unknown(),10*q^69+
(52*j^2+51*j)*q^70+(-84*j^2-86*j)*q^71+(58*j^2+63*j)*q^72+
17*q^73,840*j*q^92,Unknown(),168*j*q^92-424*j*q^93+248*j*q^94,
j*q^23-14*j*q^24+50*j*q^25-72*j*q^26+44*j*q^27-9*j*q^28,-
380*j*q^92+460*j*q^93,102*j*q^92-278*j*q^93+182*j*q^94,
Unknown(),-16*j*q^92+86*j*q^93-126*j*q^94+56*j*q^95,-
840*j^2*q^115,Unknown(),-168*j^2*q^115+424*j^2*q^116-
248*j^2*q^117,380*j^2*q^115-460*j^2*q^116,-102*j^2*q^115+
278*j^2*q^116-182*j^2*q^117,Unknown(),16*j^2*q^115-86*j^2*q^116+
126*j^2*q^117-56*j^2*q^118];end;
  f158:=function(q,e)local v;v:=GetRoot(q,2)*e;return [896,-480+416*q,
180-300*q+116*q^2,256-448*q+192*q^2,-95+246*q-202*q^2+53*q^3,-52+128*q-96*q^2+
20*q^3,-24+60*q-36*q^2+8*q^3,-136+360*q-312*q^2+88*q^3,12-36*q+60*q^2-28*q^3,-
7+25*q-48*q^2+43*q^3-13*q^4,34-122*q+148*q^2-78*q^3+14*q^4,12-40*q+45*q^2-
18*q^3+2*q^4,2-8*q+7*q^2-2*q^3,-21+65*q-89*q^2+57*q^3-13*q^4,27-93*q+112*q^2-
55*q^3+9*q^4,12-44*q+48*q^2-20*q^3+4*q^4,50-176*q+224*q^2-122*q^3+24*q^4,-6+
27*q-43*q^2+31*q^3-9*q^4+q^5,11-45*q+78*q^2-72*q^3+33*q^4-6*q^5,q-q^2,
Unknown(),8-30*q+49*q^2-40*q^3+15*q^4-2*q^5,Unknown(),-9+43*q-70*q^2+53*q^3-
19*q^4+2*q^5,-2+10*q-15*q^2+9*q^3-2*q^4,-1+5*q-8*q^2+4*q^3-q^4,24-180*q^2+
288*q^3-108*q^4+8*q^6,0,Unknown(),2+8*q-48*q^2+58*q^3-22*q^4+2*q^5,0,60-120*q-
36*q^2+216*q^3-60*q^4-72*q^5+44*q^6,Unknown(),Unknown(),-12+12*q+96*q^2-
236*q^3+196*q^4-48*q^5-4*q^6+4*q^7,-q+5*q^2-10*q^3+6*q^4-q^5,-31+93*q-36*q^2-
130*q^3+134*q^4+12*q^5-55*q^6+21*q^7,4*q-13*q^2+19*q^3-19*q^4+9*q^5-q^6,-1-
3*q+29*q^2-54*q^3+39*q^4-11*q^5+q^6,-2+27*q^2-63*q^3+41*q^4-7*q^5,Unknown(),-
25+84*q-91*q^2-10*q^3+46*q^4+15*q^5-36*q^6+13*q^7,Unknown(),Unknown(),8-32*q+
45*q^2-8*q^3-41*q^4+33*q^5-2*q^6-6*q^7+2*q^8,-3*q^2+8*q^3-9*q^4+3*q^5,
12*v^195-40*v^197+45*v^199-18*v^201+2*v^203,12*v^39-
40*v^41+45*v^43-18*v^45+2*v^47,1-q-14*q^2+46*q^3-52*q^4+
23*q^5-3*q^6,Unknown(),Unknown(),13-56*q+87*q^2-39*q^3-28*q^4+14*q^5+26*q^6-
23*q^7+6*q^8,Unknown(),Unknown(),Unknown(),-6*v^39+27*v^41-
43*v^43+31*v^45-9*v^47+v^49,Unknown(),Unknown(),8-22*q+6*q^2+
56*q^3-87*q^4+66*q^5-52*q^6+36*q^7-9*q^8-4*q^9+2*q^10,0,Unknown(),Unknown(),0,
-q^2-2*q^3+15*q^4-16*q^5+4*q^6,Unknown(),Unknown(),Unknown(),-6*q^39+27*q^40-
43*q^41+31*q^42-9*q^43+q^44,Unknown(),Unknown(),-9*v^117+43*v^119-
70*v^121+53*v^123-19*v^125+2*v^127,Unknown(),Unknown(),2-
8*q^2+6*q^3-24*q^4+74*q^5-86*q^6+38*q^7-6*q^8+2*q^9-2*q^10,0,-21*v^195+
65*v^197-89*v^199+57*v^201-13*v^203,-9*v^195+43*v^197-
70*v^199+53*v^201-19*v^203+2*v^205,Unknown(),-3*q^5-9*q^6+
27*q^7+8*v^15-15*q^8,-21*v^39+65*v^41-89*v^43+57*v^45-
13*v^47,Unknown(),27*q^39-93*q^40+112*q^41-55*q^42+9*q^43,-v^83,
Unknown(),Unknown(),12*q^39-40*q^40+45*q^41-18*q^42+2*q^43,Unknown(),
896*v^39,2*v^39-8*v^41+7*v^43-2*v^45,256*v^39-
448*v^41+192*v^43,Unknown(),-52*v^39+128*v^41-96*v^43+
20*v^45,-136*v^39+360*v^41-312*v^43+88*v^45,34*v^39-
122*v^41+148*v^43-78*v^45+14*v^47,Unknown(),12*v^39-
44*v^41+48*v^43-20*v^45+4*v^47,50*v^39-176*v^41+
224*v^43-122*v^45+24*v^47,11*v^39-45*v^41+78*v^43-
72*v^45+33*v^47-6*v^49,24*v^39-180*v^43+288*v^45-
108*v^47+8*v^51,60*v^39-120*v^41-36*v^43+216*v^45-
60*v^47-72*v^49+44*v^51,-2*v^39+27*v^43-63*v^45+
41*v^47-7*v^49,-12*v^39+12*v^41+96*v^43-236*v^45+
196*v^47-48*v^49-4*v^51+4*v^53,-31*v^39+93*v^41-
36*v^43-130*v^45+134*v^47+12*v^49-55*v^51+21*v^53,
Unknown(),v^39-v^41-14*v^43+46*v^45-52*v^47+23*v^49-
3*v^51,-3*v^43+8*v^45-9*v^47+3*v^49,-v^43-2*v^45+
15*v^47-16*v^49+4*v^51,-480*v^39+416*v^41,2*v^39-
8*v^43+6*v^45-24*v^47+74*v^49-86*v^51+38*v^53-
6*v^55+2*v^57-2*v^59,-24*v^39+60*v^41-36*v^43+
8*v^45,180*v^39-300*v^41+116*v^43,Unknown(),-95*v^39+
246*v^41-202*v^43+53*v^45,-3*v^49-9*v^51+27*v^53+
8*q^27-15*v^55,Unknown(),Unknown(),12*v^117-40*v^119+45*v^121-
18*v^123+2*v^125,Unknown(),0,27*v^39-93*v^41+112*v^43-
55*v^45+9*v^47,Unknown(),896*q^39,Unknown(),256*q^39-448*q^40+
192*q^41,-52*q^39+128*q^40-96*q^41+20*q^42,-136*q^39+360*q^40-312*q^41+
88*q^42,-7*q^39+25*q^40-48*q^41+43*q^42-13*q^43,11*q^39-45*q^40+78*q^41-
72*q^42+33*q^43-6*q^44,Unknown(),24*q^39-180*q^41+288*q^42-108*q^43+8*q^45,-
12*q^39+12*q^40+96*q^41-236*q^42+196*q^43-48*q^44-4*q^45+4*q^46,-2*q^39+
27*q^41-63*q^42+41*q^43-7*q^44,-3*q^41+8*q^42-9*q^43+3*q^44,-480*q^39+
416*q^40,180*q^39-300*q^40+116*q^41,-95*q^39+246*q^40-202*q^41+53*q^42,-
3*q^44-9*q^45+27*q^46+8*v^93-15*q^47,-21*q^39+65*q^40-89*q^41+57*q^42-
13*q^43,12*q^78-40*q^79+45*q^80-18*q^81+2*q^82,Unknown(),896*v^117,-
4*q^15+2*q^16+90*q^20-192*q^21+105*q^22-32*v^45+32*v^47+70*q^24-
116*q^25+45*q^26,Unknown(),-52*v^117+128*v^119-96*v^121+
20*v^123,Unknown(),Unknown(),24*v^117-180*v^121+288*v^123-
108*v^125+8*v^129,Unknown(),-2*v^117+27*v^121-63*v^123+
41*v^125-7*v^127,-3*v^121+8*v^123-9*v^125+3*v^127,
6*q^15-162*q^20+225*q^21-64*v^45-150*q^24+81*q^25,180*v^117-
300*v^119+116*v^121,Unknown(),-21*v^117+65*v^119-89*v^121+
57*v^123-13*v^125,896*q^78,Unknown(),256*q^78-448*q^79+192*q^80,-
9*v^39+43*v^41-70*v^43+53*v^45-19*v^47+2*v^49,-
480*q^78+416*q^79,180*q^78-300*q^79+116*q^80,Unknown(),-52*q^78+128*q^79-
96*q^80+20*q^81,896*v^195,Unknown(),256*v^195-448*v^197+
192*v^199,-480*v^195+416*v^197,180*v^195-300*v^197+
116*v^199,Unknown(),-52*v^195+128*v^197-96*v^199+
20*v^201];end;
  f162:=function(q,j)return [945,-450+495*q,135-315*q+180*q^2,210-480*q+255*q^2,
  -60+225*q-255*q^2+90*q^3,-27+108*q-132*q^2+48*q^3,-9+45*q+(63*j^2+54*j)*q^2+
27*q^3,-96+342*q-378*q^2+129*q^3,27+(54*j^2+63*j)*q+45*q^2-9*q^3,-14+(-
41*j^2-44*j)*q+(46*j^2+52*j)*q^2+28*q^3-6*q^4,15-90*q+165*q^2-
120*q^3+30*q^4,3-24*q+51*q^2-39*q^3+9*q^4,-3*q+(-11*j^2-8*j)*q^2+
(10*j^2+7*j)*q^3+2*q^4,-16+(-59*j^2-65*j)*q+(91*j^2+
97*j)*q^2+66*q^3-18*q^4,11-65*q+124*q^2-92*q^3+23*q^4,3-26*q+(-56*j^2-
53*j)*q^2+(46*j^2+40*j)*q^3+13*q^4,26-138*q+245*q^2-177*q^3+44*q^4,-
1+12*q-38*q^2+47*q^3-24*q^4+4*q^5,7+(37*j^2+39*j)*q+(-75*j^2-
81*j)*q^2+(79*j^2+83*j)*q^3+43*q^4-9*q^5,-q^2+(-2*j^2-j)*q^3+
j^2*q^4,Unknown(),3+(19*j^2+20*j)*q+(-43*j^2-47*j)*q^2+
(49*j^2+52*j)*q^3+28*q^4-6*q^5,Unknown(),-2+22*q-64*q^2+76*q^3-39*q^4+
7*q^5,3*q-13*q^2+17*q^3-8*q^4+q^5,q+(7*j^2+6*j)*q^2+(-11*j^2-
8*j)*q^3+(6*j^2+4*j)*q^4+q^5,9-135*q^2+288*q^3+(162*j^2+
189*j)*q^4+27*q^6,0,Unknown(),3*q-27*q^2+59*q^3+(44*j^2+47*j)*q^4+(-
7*j^2-10*j)*q^5+2*q^6,0,45-90*q+(63*j^2+54*j)*q^2+216*q^3-45*q^4+
(126*j^2+108*j)*q^5+63*q^6,Unknown(),Unknown(),-3+6*q+60*q^2-211*q^3+(-
236*j^2-245*j)*q^4+(78*j^2+96*j)*q^5-14*q^6+13*q^7,q^2+(8*j^2+
6*j)*q^3+(-12*j^2-10*j)*q^4+(5*j^2+6*j)*q^5-j*q^6,-20+65*q+
(19*j^2+22*j)*q^2+(134*j^2+128*j)*q^3+134*q^4+(-37*j^2-
31*j)*q^5+(95*j^2+83*j)*q^6+32*q^7,2*q+(10*j^2+12*j)*q^2+(-
19*j^2-23*j)*q^3+(19*j^2+22*j)*q^4+11*q^5+(3*j^2+2*j)*q^6,-
q+13*q^2-44*q^3+(-54*j^2-55*j)*q^4+(25*j^2+28*j)*q^5+(-2*j^2-
4*j)*q^6+q^7,11*q^2+(48*j^2+45*j)*q^3+(-58*j^2-61*j)*q^4+
(23*j^2+29*j)*q^5+2*q^7,Unknown(),-16+48*q+(29*j^2+41*j)*q^2+
(38*j^2+20*j)*q^3+(-17*j^2-5*j)*q^4+74*q^5+(78*j^2+
72*j)*q^6+22*q^7,Unknown(),Unknown(),3-10*q+(-5*j^2-8*j)*q^2+(-
22*j^2-10*j)*q^3+(35*j^2+20*j)*q^4+(-4*j^2+6*j)*q^5+(-
29*j^2-31*j)*q^6+(24*j^2+22*j)*q^7+6*q^8,(-4*j^2-3*j)*q^3+
(12*j^2+9*j)*q^4+9*q^5+(j^2+3*j)*q^6,3*j*q^110-24*j*q^111+
51*j*q^112-39*j*q^113+9*j*q^114,3*j^2*q^22-24*j^2*q^23+
51*j^2*q^24-39*j^2*q^25+9*j^2*q^26,-4*q^2+(-28*j^2-27*j)*q^3+
(56*j^2+55*j)*q^4+(-42*j^2-46*j)*q^5+(10*j^2+14*j)*q^6-q^7+
q^8,Unknown(),Unknown(),7-29*q+(-38*j^2-42*j)*q^2+14*j*q^3+
(24*j^2+8*j)*q^4+(28*j^2+36*j)*q^5+(-74*j^2-72*j)*q^6+
(49*j^2+45*j)*q^7+11*q^8,Unknown(),Unknown(),Unknown(),-j^2*q^22+
12*j^2*q^23-38*j^2*q^24+47*j^2*q^25-24*j^2*q^26+4*j^2*q^27,
Unknown(),Unknown(),3-6*q+(10*j^2+9*j)*q^2+(-40*j^2-42*j)*q^3+
(51*j^2+57*j)*q^4+(-60*j^2-62*j)*q^5+(82*j^2+77*j)*q^6+(-
60*j^2-54*j)*q^7-2*q^8+(18*j^2+16*j)*q^9+6*q^10,0,Unknown(),
Unknown(),0,7*q^4+(16*j^2+18*j)*q^5+(-11*j^2-14*j)*q^6-2*q^7+
j*q^8,Unknown(),Unknown(),Unknown(),-j*q^44+12*j*q^45-38*j*q^46+
47*j*q^47-24*j*q^48+4*j*q^49,Unknown(),Unknown(),-2*q^66+22*q^67-
64*q^68+76*q^69-39*q^70+7*q^71,Unknown(),Unknown(),-3*q^2+4*q^3-15*q^4+(-
54*j^2-60*j)*q^5+(91*j^2+103*j)*q^6+(-70*j^2-76*j)*q^7+
(15*j^2+12*j)*q^8+(-4*j^2+2*j)*q^9+(10*j^2+7*j)*q^10+2*q^12,
0,-16*j*q^110+(-6*j^2+59*j)*q^111+(6*j^2-91*j)*q^112+
66*j*q^113-18*j*q^114,-2*j*q^110+22*j*q^111-64*j*q^112+
76*j*q^113-39*j*q^114+7*j*q^115,Unknown(),(8*j^2+2*j)*q^6+
21*q^7+(15*j^2+24*j)*q^8+(j^2-11*j)*q^9+3*q^10,-16*j^2*q^22+
(65*j^2+6*j)*q^23+(-97*j^2-6*j)*q^24+66*j^2*q^25-
18*j^2*q^26,Unknown(),11*j*q^44-65*j*q^45+124*j*q^46-92*j*q^47+
23*j*q^48,q^46-q^47,Unknown(),Unknown(),3*j*q^44-24*j*q^45+
51*j*q^46-39*j*q^47+9*j*q^48,Unknown(),945*j^2*q^22,-
3*j^2*q^23+(8*j^2-3*j)*q^24+(-7*j^2+3*j)*q^25+2*j^2*q^26,
210*j^2*q^22-480*j^2*q^23+255*j^2*q^24,Unknown(),-27*j^2*q^22+
108*j^2*q^23-132*j^2*q^24+48*j^2*q^25,-96*j^2*q^22+
342*j^2*q^23-378*j^2*q^24+129*j^2*q^25,15*j^2*q^22-90*j^2*q^23+
165*j^2*q^24-120*j^2*q^25+30*j^2*q^26,Unknown(),3*j^2*q^22-
26*j^2*q^23+(53*j^2-3*j)*q^24+(-40*j^2+6*j)*q^25+
13*j^2*q^26,26*j^2*q^22-138*j^2*q^23+245*j^2*q^24-177*j^2*q^25+
44*j^2*q^26,7*j^2*q^22+(-39*j^2-2*j)*q^23+(81*j^2+6*j)*q^24+
(-83*j^2-4*j)*q^25+43*j^2*q^26-9*j^2*q^27,9*j^2*q^22-
135*j^2*q^24+288*j^2*q^25+(-189*j^2-27*j)*q^26+27*j^2*q^28,
45*j^2*q^22-90*j^2*q^23+(-54*j^2+9*j)*q^24+216*j^2*q^25-
45*j^2*q^26+(-108*j^2+18*j)*q^27+63*j^2*q^28,11*j^2*q^24+(-
45*j^2+3*j)*q^25+(61*j^2+3*j)*q^26+(-29*j^2-6*j)*q^27+
2*j^2*q^29,-3*j^2*q^22+6*j^2*q^23+60*j^2*q^24-211*j^2*q^25+
(245*j^2+9*j)*q^26+(-96*j^2-18*j)*q^27-14*j^2*q^28+
13*j^2*q^29,-20*j^2*q^22+65*j^2*q^23+(-22*j^2-3*j)*q^24+(-
128*j^2+6*j)*q^25+134*j^2*q^26+(31*j^2-6*j)*q^27+(-83*j^2+
12*j)*q^28+32*j^2*q^29,Unknown(),-4*j^2*q^24+(27*j^2-j)*q^25+(-
55*j^2+j)*q^26+(46*j^2+4*j)*q^27+(-14*j^2-4*j)*q^28-
j^2*q^29+j^2*q^30,(3*j^2-j)*q^25+(-9*j^2+3*j)*q^26+
9*j^2*q^27+(-3*j^2-2*j)*q^28,7*j^2*q^26+(-18*j^2-2*j)*q^27+
(14*j^2+3*j)*q^28-2*j^2*q^29+q^30,-450*j^2*q^22+495*j^2*q^23,-
3*j^2*q^24+4*j^2*q^25-15*j^2*q^26+(60*j^2+6*j)*q^27+(-
103*j^2-12*j)*q^28+(76*j^2+6*j)*q^29+(-12*j^2+3*j)*q^30+(-
2*j^2-6*j)*q^31+(-7*j^2+3*j)*q^32+2*j^2*q^34,-9*j^2*q^22+
45*j^2*q^23+(-54*j^2+9*j)*q^24+27*j^2*q^25,135*j^2*q^22-
315*j^2*q^23+180*j^2*q^24,Unknown(),-60*j^2*q^22+225*j^2*q^23-
255*j^2*q^24+90*j^2*q^25,(-2*j^2+6*j)*q^28+21*j^2*q^29+(-
24*j^2-9*j)*q^30+(11*j^2+12*j)*q^31+3*j^2*q^32,Unknown(),
Unknown(),3*q^66-24*q^67+51*q^68-39*q^69+9*q^70,Unknown(),0,11*j^2*q^22-
65*j^2*q^23+124*j^2*q^24-92*j^2*q^25+23*j^2*q^26,Unknown(),
945*j*q^44,Unknown(),210*j*q^44-480*j*q^45+255*j*q^46,-
27*j*q^44+108*j*q^45-132*j*q^46+48*j*q^47,-96*j*q^44+
342*j*q^45-378*j*q^46+129*j*q^47,-14*j*q^44+(-3*j^2+
41*j)*q^45+(6*j^2-46*j)*q^46+28*j*q^47-6*j*q^48,7*j*q^44+
(2*j^2-37*j)*q^45+(-6*j^2+75*j)*q^46+(4*j^2-79*j)*q^47+
43*j*q^48-9*j*q^49,Unknown(),9*j*q^44-135*j*q^46+288*j*q^47+
(27*j^2-162*j)*q^48+27*j*q^50,-3*j*q^44+6*j*q^45+60*j*q^46-
211*j*q^47+(-9*j^2+236*j)*q^48+(18*j^2-78*j)*q^49-14*j*q^50+
13*j*q^51,11*j*q^46+(-3*j^2-48*j)*q^47+(-3*j^2+58*j)*q^48+
(6*j^2-23*j)*q^49+2*j*q^51,(j^2+4*j)*q^47+(-3*j^2-
12*j)*q^48+9*j*q^49+(2*j^2-j)*q^50,-450*j*q^44+495*j*q^45,
135*j*q^44-315*j*q^45+180*j*q^46,-60*j*q^44+225*j*q^45-
255*j*q^46+90*j*q^47,(-6*j^2-8*j)*q^50+21*j*q^51+(9*j^2-
15*j)*q^52+(-12*j^2-j)*q^53+3*j*q^54,-16*j*q^44+(-6*j^2+
59*j)*q^45+(6*j^2-91*j)*q^46+66*j*q^47-18*j*q^48,3*j^2*q^88-
24*j^2*q^89+51*j^2*q^90-39*j^2*q^91+9*j^2*q^92,Unknown(),945*q^66,
-24*q^18+16*q^19+45*q^20-124*q^21+77*q^22+91*q^24-176*q^25+90*q^26+16*q^27-
24*q^28+2*q^30-4*q^31,Unknown(),-27*q^66+108*q^67-132*q^68+48*q^69,Unknown(),
Unknown(),9*q^66-135*q^68+288*q^69+(162*j^2+189*j)*q^70+27*q^72,
Unknown(),11*q^68+(48*j^2+45*j)*q^69+(-58*j^2-61*j)*q^70+
(23*j^2+29*j)*q^71+2*q^73,(-4*j^2-3*j)*q^69+(12*j^2+
9*j)*q^70+9*q^71+(j^2+3*j)*q^72,40*q^18-81*q^20+165*q^21-195*q^24+
162*q^25-40*q^27-6*q^30,135*q^66-315*q^67+180*q^68,Unknown(),-16*q^66+(-
59*j^2-65*j)*q^67+(91*j^2+97*j)*q^68+66*q^69-18*q^70,
945*j^2*q^88,Unknown(),210*j^2*q^88-480*j^2*q^89+255*j^2*q^90,-
2*j^2*q^22+22*j^2*q^23-64*j^2*q^24+76*j^2*q^25-39*j^2*q^26+
7*j^2*q^27,-450*j^2*q^88+495*j^2*q^89,135*j^2*q^88-
315*j^2*q^89+180*j^2*q^90,Unknown(),-27*j^2*q^88+108*j^2*q^89-
132*j^2*q^90+48*j^2*q^91,945*j*q^110,Unknown(),210*j*q^110-
480*j*q^111+255*j*q^112,-450*j*q^110+495*j*q^111,135*j*q^110-
315*j*q^111+180*j*q^112,Unknown(),-27*j*q^110+108*j*q^111-
132*j*q^112+48*j*q^113];end;
  f166:=function(q,j) return [1260,-630+630*q,204-426*q+204*q^2,
  316-628*q+316*q^2,-103+314*q-314*q^2+103*q^3,-47+157*q-157*q^2+47*q^3,
  -15+(-72*j^2-69*j)*q+(72*j^2+69*j)*q^2+15*q^3,-159+471*q-471*q^2+159*q^3,
  33+(69*j^2+72*j)*q+(-69*j^2-72*j)*q^2-33*q^3,-16+(-51*j^2-53*j)*q+
(70*j^2+72*j)*q^2+(-51*j^2-53*j)*q^3-16*q^4,34-138*q+208*q^2-
138*q^3+34*q^4,8-39*q+62*q^2-39*q^3+8*q^4,(6*j^2+5*j)*q+(-12*j^2-
10*j)*q^2+(6*j^2+5*j)*q^3,-24+(-88*j^2-90*j)*q+(128*j^2+
132*j)*q^2+(-88*j^2-90*j)*q^3-24*q^4,24-102*q+156*q^2-102*q^3+24*q^4,
8+(43*j^2+42*j)*q+(-72*j^2-68*j)*q^2+(43*j^2+42*j)*q^3+
8*q^4,52-209*q+312*q^2-209*q^3+52*q^4,-4+24*q-50*q^2+50*q^3-24*q^4+4*q^5,12+
(56*j^2+57*j)*q+(-108*j^2-111*j)*q^2+(108*j^2+111*j)*q^3+(-
56*j^2-57*j)*q^4-12*q^5,j^2*q^2-j^2*q^3,Unknown(),6+(31*j^2+
32*j)*q+(-63*j^2-65*j)*q^2+(63*j^2+65*j)*q^3+(-31*j^2-
32*j)*q^4-6*q^5,Unknown(),-8+42*q-85*q^2+85*q^3-42*q^4+8*q^5,-1+7*q-16*q^2+
16*q^3-7*q^4+q^5,3*q+(9*j^2+7*j)*q^2+(-9*j^2-7*j)*q^3-3*q^4,15+
(207*j^2+216*j)*q^2+384*q^3+(207*j^2+216*j)*q^4+15*q^6,0,
Unknown(),(-5*j^2-6*j)*q+(45*j^2+46*j)*q^2+84*q^3+(45*j^2+
46*j)*q^4+(-5*j^2-6*j)*q^5,0,63+(144*j^2+138*j)*q+(72*j^2+
69*j)*q^2+288*q^3+(72*j^2+69*j)*q^4+(144*j^2+138*j)*q^5+63*q^6,
Unknown(),Unknown(),-8+7*q+(-105*j^2-108*j)*q^2+(294*j^2+
300*j)*q^3+(-294*j^2-300*j)*q^4+(105*j^2+108*j)*q^5-7*q^6+
8*q^7,3*q^2-11*q^3+11*q^4-3*q^5,-32+(-103*j^2-101*j)*q+(36*j^2+
34*j)*q^2+(180*j^2+179*j)*q^3+(-180*j^2-179*j)*q^4+(-36*j^2-
34*j)*q^5+(103*j^2+101*j)*q^6+32*q^7,4*q-17*q^2+(-27*j^2-
29*j)*q^3+(27*j^2+29*j)*q^4+17*q^5-4*q^6,-3*q+(-25*j^2-
26*j)*q^2+(64*j^2+65*j)*q^3+(-64*j^2-65*j)*q^4+(25*j^2+
26*j)*q^5+3*q^6,(-22*j^2-24*j)*q^2-70*q^3+70*q^4+(22*j^2+
24*j)*q^5,Unknown(),-24+(-84*j^2-82*j)*q+(69*j^2+73*j)*q^2+
(37*j^2+27*j)*q^3+(-37*j^2-27*j)*q^4+(-69*j^2-73*j)*q^5+
(84*j^2+82*j)*q^6+24*q^7,Unknown(),Unknown(),6-24*q+(-24*j^2-
26*j)*q^2+(-26*j^2-19*j)*q^3+(64*j^2+54*j)*q^4+(-26*j^2-
19*j)*q^5+(-24*j^2-26*j)*q^6-24*q^7+6*q^8,-q^2+7*q^3-12*q^4+7*q^5-
q^6,-8*j^2*q^105+39*j^2*q^106-62*j^2*q^107+39*j^2*q^108-
8*j^2*q^109,-8*j*q^21+39*j*q^22-62*j*q^23+39*j*q^24-
8*j*q^25,-12*q^2+(-45*j^2-47*j)*q^3-70*q^4+(-45*j^2-47*j)*q^5-
12*q^6,Unknown(),Unknown(),12-54*q+77*q^2+(16*j^2+23*j)*q^3+(38*j^2+
28*j)*q^4+(16*j^2+23*j)*q^5+77*q^6-54*q^7+12*q^8,Unknown(),Unknown(),
Unknown(),4*j*q^21-24*j*q^22+50*j*q^23-50*j*q^24+24*j*q^25-
4*j*q^26,Unknown(),Unknown(),6-16*q+(6*j^2+5*j)*q^2+(-66*j^2-
64*j)*q^3-105*q^4+112*q^5-105*q^6+(-66*j^2-64*j)*q^7+(6*j^2+
5*j)*q^8-16*q^9+6*q^10,0,Unknown(),Unknown(),0,-2*q^3+(-12*j^2-
13*j)*q^4-20*q^5+(-12*j^2-13*j)*q^6-2*q^7,Unknown(),Unknown(),
Unknown(),-4*j^2*q^42+24*j^2*q^43-50*j^2*q^44+50*j^2*q^45-
24*j^2*q^46+4*j^2*q^47,Unknown(),Unknown(),8*q^63-42*q^64+85*q^65-
85*q^66+42*q^67-8*q^68,Unknown(),Unknown(),(6*j^2+5*j)*q^2+(-14*j^2-
12*j)*q^3+(30*j^2+29*j)*q^4+(-84*j^2-88*j)*q^5+(124*j^2+
132*j)*q^6+(-84*j^2-88*j)*q^7+(30*j^2+29*j)*q^8+(-14*j^2-
12*j)*q^9+(6*j^2+5*j)*q^10,0,24*j^2*q^105+(-90*j^2-
2*j)*q^106+(132*j^2+4*j)*q^107+(-90*j^2-2*j)*q^108+
24*j^2*q^109,8*j^2*q^105-42*j^2*q^106+85*j^2*q^107-
85*j^2*q^108+42*j^2*q^109-8*j^2*q^110,Unknown(),(6*j^2+
15*j)*q^6+21*q^7-21*q^8+(-6*j^2-15*j)*q^9,24*j*q^21+(2*j^2-
88*j)*q^22+(-4*j^2+128*j)*q^23+(2*j^2-88*j)*q^24+24*j*q^25,
Unknown(),24*j^2*q^42-102*j^2*q^43+156*j^2*q^44-102*j^2*q^45+
24*j^2*q^46,0,Unknown(),Unknown(),8*j^2*q^42-39*j^2*q^43+
62*j^2*q^44-39*j^2*q^45+8*j^2*q^46,Unknown(),-1260*j*q^21,(j^2+
6*j)*q^22+(-2*j^2-12*j)*q^23+(j^2+6*j)*q^24,-316*j*q^21+
628*j*q^22-316*j*q^23,Unknown(),47*j*q^21-157*j*q^22+
157*j*q^23-47*j*q^24,159*j*q^21-471*j*q^22+471*j*q^23-
159*j*q^24,-34*j*q^21+138*j*q^22-208*j*q^23+138*j*q^24-
34*j*q^25,Unknown(),-8*j*q^21+(j^2+43*j)*q^22+(-4*j^2-
72*j)*q^23+(j^2+43*j)*q^24-8*j*q^25,-52*j*q^21+209*j*q^22-
312*j*q^23+209*j*q^24-52*j*q^25,-12*j*q^21+(-j^2+56*j)*q^22+
(3*j^2-108*j)*q^23+(-3*j^2+108*j)*q^24+(j^2-56*j)*q^25+
12*j*q^26,-15*j*q^21+(-9*j^2+207*j)*q^23-384*j*q^24+(-9*j^2+
207*j)*q^25-15*j*q^27,-63*j*q^21+(6*j^2+144*j)*q^22+(3*j^2+
72*j)*q^23-288*j*q^24+(3*j^2+72*j)*q^25+(6*j^2+144*j)*q^26-
63*j*q^27,(2*j^2-22*j)*q^23+70*j*q^24-70*j*q^25+(-2*j^2+
22*j)*q^26,8*j*q^21-7*j*q^22+(3*j^2-105*j)*q^23+(-6*j^2+
294*j)*q^24+(6*j^2-294*j)*q^25+(-3*j^2+105*j)*q^26+7*j*q^27-
8*j*q^28,32*j*q^21+(-2*j^2-103*j)*q^22+(2*j^2+36*j)*q^23+
(j^2+180*j)*q^24+(-j^2-180*j)*q^25+(-2*j^2-36*j)*q^26+
(2*j^2+103*j)*q^27-32*j*q^28,Unknown(),12*j*q^23+(2*j^2-
45*j)*q^24+70*j*q^25+(2*j^2-45*j)*q^26+12*j*q^27,j*q^23-
7*j*q^24+12*j*q^25-7*j*q^26+j*q^27,2*j*q^24+(j^2-
12*j)*q^25+20*j*q^26+(j^2-12*j)*q^27+2*j*q^28,630*j*q^21-
630*j*q^22,(j^2+6*j)*q^23+(-2*j^2-14*j)*q^24+(j^2+
30*j)*q^25+(4*j^2-84*j)*q^26+(-8*j^2+124*j)*q^27+(4*j^2-
84*j)*q^28+(j^2+30*j)*q^29+(-2*j^2-14*j)*q^30+(j^2+
6*j)*q^31,15*j*q^21+(-3*j^2-72*j)*q^22+(3*j^2+72*j)*q^23-
15*j*q^24,-204*j*q^21+426*j*q^22-204*j*q^23,Unknown(),
103*j*q^21-314*j*q^22+314*j*q^23-103*j*q^24,(-9*j^2+
6*j)*q^27-21*j*q^28+21*j*q^29+(9*j^2-6*j)*q^30,Unknown(),
Unknown(),-8*q^63+39*q^64-62*q^65+39*q^66-8*q^67,Unknown(),0,-24*j*q^21+
102*j*q^22-156*j*q^23+102*j*q^24-24*j*q^25,Unknown(),
1260*j^2*q^42,Unknown(),316*j^2*q^42-628*j^2*q^43+316*j^2*q^44,-
47*j^2*q^42+157*j^2*q^43-157*j^2*q^44+47*j^2*q^45,-
159*j^2*q^42+471*j^2*q^43-471*j^2*q^44+159*j^2*q^45,-
16*j^2*q^42+(53*j^2+2*j)*q^43+(-72*j^2-2*j)*q^44+(53*j^2+
2*j)*q^45-16*j^2*q^46,12*j^2*q^42+(-57*j^2-j)*q^43+(111*j^2+
3*j)*q^44+(-111*j^2-3*j)*q^45+(57*j^2+j)*q^46-12*j^2*q^47,
Unknown(),15*j^2*q^42+(-216*j^2-9*j)*q^44+384*j^2*q^45+(-
216*j^2-9*j)*q^46+15*j^2*q^48,-8*j^2*q^42+7*j^2*q^43+
(108*j^2+3*j)*q^44+(-300*j^2-6*j)*q^45+(300*j^2+6*j)*q^46+(-
108*j^2-3*j)*q^47-7*j^2*q^48+8*j^2*q^49,(24*j^2+2*j)*q^44-
70*j^2*q^45+70*j^2*q^46+(-24*j^2-2*j)*q^47,-j^2*q^44+
7*j^2*q^45-12*j^2*q^46+7*j^2*q^47-j^2*q^48,-630*j^2*q^42+
630*j^2*q^43,204*j^2*q^42-426*j^2*q^43+204*j^2*q^44,-
103*j^2*q^42+314*j^2*q^43-314*j^2*q^44+103*j^2*q^45,(-15*j^2-
9*j)*q^48+21*j^2*q^49-21*j^2*q^50+(15*j^2+9*j)*q^51,-
24*j^2*q^42+(90*j^2+2*j)*q^43+(-132*j^2-4*j)*q^44+(90*j^2+
2*j)*q^45-24*j^2*q^46,8*j*q^84-39*j*q^85+62*j*q^86-
39*j*q^87+8*j*q^88,Unknown(),-1260*q^63,-18*q^18+12*q^19+90*q^20-
184*q^21+98*q^22+98*q^24-184*q^25+90*q^26+12*q^27-18*q^28,Unknown(),47*q^63-
157*q^64+157*q^65-47*q^66,Unknown(),Unknown(),-15*q^63+(-207*j^2-
216*j)*q^65-384*q^66+(-207*j^2-216*j)*q^67-15*q^69,Unknown(),
(22*j^2+24*j)*q^65+70*q^66-70*q^67+(-22*j^2-24*j)*q^68,q^65-
7*q^66+12*q^67-7*q^68+q^69,30*q^18-162*q^20+210*q^21-210*q^24+162*q^25-
30*q^27,-204*q^63+426*q^64-204*q^65,Unknown(),24*q^63+(88*j^2+
90*j)*q^64+(-128*j^2-132*j)*q^65+(88*j^2+90*j)*q^66+24*q^67,
1260*j*q^84,Unknown(),316*j*q^84-628*j*q^85+316*j*q^86,
8*j*q^21-42*j*q^22+85*j*q^23-85*j*q^24+42*j*q^25-8*j*q^26,-
630*j*q^84+630*j*q^85,204*j*q^84-426*j*q^85+204*j*q^86,
Unknown(),-47*j*q^84+157*j*q^85-157*j*q^86+47*j*q^87,-
1260*j^2*q^105,Unknown(),-316*j^2*q^105+628*j^2*q^106-
316*j^2*q^107,630*j^2*q^105-630*j^2*q^106,-204*j^2*q^105+
426*j^2*q^106-204*j^2*q^107,Unknown(),47*j^2*q^105-157*j^2*q^106+
157*j^2*q^107-47*j^2*q^108];end;
  f168:=q->[1280,-640+640*q,208-432*q+
208*q^2,320-640*q+320*q^2,-104+320*q-320*q^2+104*q^3,-48+160*q-160*q^2+48*q^3,
-16+72*q-72*q^2+16*q^3,-160+480*q-480*q^2+160*q^3,32-72*q+72*q^2-32*q^3,-16+
52*q-72*q^2+52*q^3-16*q^4,34-140*q+214*q^2-140*q^3+34*q^4,8-40*q+64*q^2-
40*q^3+8*q^4,-6*q+14*q^2-6*q^3,-24+90*q-130*q^2+90*q^3-24*q^4,24-104*q+
160*q^2-104*q^3+24*q^4,8-44*q+72*q^2-44*q^3+8*q^4,52-212*q+320*q^2-212*q^3+
52*q^4,-4+24*q-52*q^2+52*q^3-24*q^4+4*q^5,12-57*q+110*q^2-110*q^3+57*q^4-
12*q^5,-2*q^2+2*q^3,Unknown(),6-32*q+64*q^2-64*q^3+32*q^4-6*q^5,Unknown(),-8+
42*q-88*q^2+88*q^3-42*q^4+8*q^5,-1+7*q-17*q^2+17*q^3-7*q^4+q^5,3*q-10*q^2+
10*q^3-3*q^4,16-216*q^2+384*q^3-216*q^4+16*q^6,-q^3,Unknown(),6*q-46*q^2+
80*q^3-46*q^4+6*q^5,-q^15,64-144*q-72*q^2+288*q^3-72*q^4-144*q^5+64*q^6,
Unknown(),Unknown(),-8+8*q+108*q^2-300*q^3+300*q^4-108*q^5-8*q^6+8*q^7,3*q^2-
10*q^3+10*q^4-3*q^5,-32+104*q-36*q^2-180*q^3+180*q^4+36*q^5-104*q^6+32*q^7,
4*q-17*q^2+30*q^3-30*q^4+17*q^5-4*q^6,-3*q+26*q^2-63*q^3+63*q^4-26*q^5+3*q^6,
24*q^2-68*q^3+68*q^4-24*q^5,Unknown(),-24+84*q-72*q^2-32*q^3+32*q^4+72*q^5-
84*q^6+24*q^7,Unknown(),Unknown(),6-24*q+25*q^2+23*q^3-58*q^4+23*q^5+25*q^6-
24*q^7+6*q^8,-q^2+7*q^3-10*q^4+7*q^5-q^6,8*q^105-40*q^106+64*q^107-40*q^108+
8*q^109,8*q^21-40*q^22+64*q^23-40*q^24+8*q^25,-12*q^2+46*q^3-68*q^4+46*q^5-
12*q^6,Unknown(),Unknown(),12-54*q+78*q^2-20*q^3-32*q^4-20*q^5+78*q^6-54*q^7+
12*q^8,Unknown(),Unknown(),Unknown(),-4*q^21+24*q^22-52*q^23+52*q^24-24*q^25+
4*q^26,Unknown(),Unknown(),6-16*q-6*q^2+68*q^3-108*q^4+112*q^5-108*q^6+68*q^7-
6*q^8-16*q^9+6*q^10,-q^6,Unknown(),Unknown(),-q^12,-2*q^3+12*q^4-20*q^5+
12*q^6-2*q^7,Unknown(),Unknown(),Unknown(),-4*q^42+24*q^43-52*q^44+52*q^45-
24*q^46+4*q^47,Unknown(),Unknown(),-8*q^63+42*q^64-88*q^65+88*q^66-42*q^67+
8*q^68,Unknown(),Unknown(),-6*q^2+12*q^3-30*q^4+84*q^5-136*q^6+84*q^7-30*q^8+
12*q^9-6*q^10,-q^9,-24*q^105+90*q^106-130*q^107+90*q^108-24*q^109,-8*q^105+
42*q^106-88*q^107+88*q^108-42*q^109+8*q^110,Unknown(),-7*q^6+21*q^7-21*q^8+
7*q^9,-24*q^21+90*q^22-130*q^23+90*q^24-24*q^25,Unknown(),24*q^42-104*q^43+
160*q^44-104*q^45+24*q^46,-q^44+q^45,Unknown(),Unknown(),8*q^42-40*q^43+
64*q^44-40*q^45+8*q^46,Unknown(),1280*q^21,-6*q^22+14*q^23-6*q^24,320*q^21-
640*q^22+320*q^23,Unknown(),-48*q^21+160*q^22-160*q^23+48*q^24,-160*q^21+
480*q^22-480*q^23+160*q^24,34*q^21-140*q^22+214*q^23-140*q^24+34*q^25,
Unknown(),8*q^21-44*q^22+72*q^23-44*q^24+8*q^25,52*q^21-212*q^22+320*q^23-
212*q^24+52*q^25,12*q^21-57*q^22+110*q^23-110*q^24+57*q^25-12*q^26,16*q^21-
216*q^23+384*q^24-216*q^25+16*q^27,64*q^21-144*q^22-72*q^23+288*q^24-72*q^25-
144*q^26+64*q^27,24*q^23-68*q^24+68*q^25-24*q^26,-8*q^21+8*q^22+108*q^23-
300*q^24+300*q^25-108*q^26-8*q^27+8*q^28,-32*q^21+104*q^22-36*q^23-180*q^24+
180*q^25+36*q^26-104*q^27+32*q^28,Unknown(),-12*q^23+46*q^24-68*q^25+46*q^26-
12*q^27,-q^23+7*q^24-10*q^25+7*q^26-q^27,-2*q^24+12*q^25-20*q^26+12*q^27-
2*q^28,-640*q^21+640*q^22,-6*q^23+12*q^24-30*q^25+84*q^26-136*q^27+84*q^28-
30*q^29+12*q^30-6*q^31,-16*q^21+72*q^22-72*q^23+16*q^24,208*q^21-432*q^22+
208*q^23,Unknown(),-104*q^21+320*q^22-320*q^23+104*q^24,-7*q^27+21*q^28-
21*q^29+7*q^30,Unknown(),Unknown(),8*q^63-40*q^64+64*q^65-40*q^66+8*q^67,
Unknown(),-q^18,24*q^21-104*q^22+160*q^23-104*q^24+24*q^25,Unknown(),
1280*q^42,Unknown(),320*q^42-640*q^43+320*q^44,-48*q^42+160*q^43-160*q^44+
48*q^45,-160*q^42+480*q^43-480*q^44+160*q^45,-16*q^42+52*q^43-72*q^44+52*q^45-
16*q^46,12*q^42-57*q^43+110*q^44-110*q^45+57*q^46-12*q^47,Unknown(),16*q^42-
216*q^44+384*q^45-216*q^46+16*q^48,-8*q^42+8*q^43+108*q^44-300*q^45+300*q^46-
108*q^47-8*q^48+8*q^49,24*q^44-68*q^45+68*q^46-24*q^47,-q^44+7*q^45-10*q^46+
7*q^47-q^48,-640*q^42+640*q^43,208*q^42-432*q^43+208*q^44,-104*q^42+320*q^43-
320*q^44+104*q^45,-7*q^48+21*q^49-21*q^50+7*q^51,-24*q^42+90*q^43-130*q^44+
90*q^45-24*q^46,8*q^84-40*q^85+64*q^86-40*q^87+8*q^88,Unknown(),1280*q^63,-
12*q^18+8*q^19+90*q^20-184*q^21+98*q^22+98*q^24-184*q^25+90*q^26+8*q^27-
12*q^28,Unknown(),-48*q^63+160*q^64-160*q^65+48*q^66,Unknown(),Unknown(),
16*q^63-216*q^65+384*q^66-216*q^67+16*q^69,Unknown(),24*q^65-68*q^66+68*q^67-
24*q^68,-q^65+7*q^66-10*q^67+7*q^68-q^69,20*q^18-162*q^20+210*q^21-210*q^24+
162*q^25-20*q^27,208*q^63-432*q^64+208*q^65,Unknown(),-24*q^63+90*q^64-
130*q^65+90*q^66-24*q^67,1280*q^84,Unknown(),320*q^84-640*q^85+320*q^86,-
8*q^21+42*q^22-88*q^23+88*q^24-42*q^25+8*q^26,-640*q^84+640*q^85,208*q^84-
432*q^85+208*q^86,Unknown(),-48*q^84+160*q^85-160*q^86+48*q^87,1280*q^105,
Unknown(),320*q^105-640*q^106+320*q^107,-640*q^105+640*q^106,208*q^105-
432*q^106+208*q^107,Unknown(),-48*q^105+160*q^106-160*q^107+48*q^108];
  f169:=q->[1280,-
640+640*q,208-432*q+208*q^2,320-640*q+320*q^2,-104+320*q-320*q^2+104*q^3,-48+
160*q-160*q^2+48*q^3,-16+72*q-72*q^2+16*q^3,-160+480*q-480*q^2+160*q^3,32-
72*q+72*q^2-32*q^3,-16+52*q-72*q^2+52*q^3-16*q^4,34-140*q+214*q^2-140*q^3+
34*q^4,8-40*q+64*q^2-40*q^3+8*q^4,-6*q+14*q^2-6*q^3,-24+90*q-130*q^2+90*q^3-
24*q^4,24-104*q+160*q^2-104*q^3+24*q^4,8-44*q+72*q^2-44*q^3+8*q^4,52-212*q+
320*q^2-212*q^3+52*q^4,-4+24*q-52*q^2+52*q^3-24*q^4+4*q^5,12-57*q+110*q^2-
110*q^3+57*q^4-12*q^5,-2*q^2+2*q^3,Unknown(),6-32*q+64*q^2-64*q^3+32*q^4-
6*q^5,Unknown(),-8+42*q-88*q^2+88*q^3-42*q^4+8*q^5,-1+7*q-17*q^2+17*q^3-7*q^4+
q^5,3*q-10*q^2+10*q^3-3*q^4,16-216*q^2+384*q^3-216*q^4+16*q^6,q^3,Unknown(),
6*q-46*q^2+80*q^3-46*q^4+6*q^5,q^15,64-144*q-72*q^2+288*q^3-72*q^4-144*q^5+
64*q^6,Unknown(),Unknown(),-8+8*q+108*q^2-300*q^3+300*q^4-108*q^5-8*q^6+8*q^7,
3*q^2-10*q^3+10*q^4-3*q^5,-32+104*q-36*q^2-180*q^3+180*q^4+36*q^5-104*q^6+
32*q^7,4*q-17*q^2+30*q^3-30*q^4+17*q^5-4*q^6,-3*q+26*q^2-63*q^3+63*q^4-26*q^5+
3*q^6,24*q^2-68*q^3+68*q^4-24*q^5,Unknown(),-24+84*q-72*q^2-32*q^3+32*q^4+
72*q^5-84*q^6+24*q^7,Unknown(),Unknown(),6-24*q+25*q^2+23*q^3-58*q^4+23*q^5+
25*q^6-24*q^7+6*q^8,-q^2+7*q^3-10*q^4+7*q^5-q^6,-8*q^105+40*q^106-64*q^107+
40*q^108-8*q^109,-8*q^21+40*q^22-64*q^23+40*q^24-8*q^25,-12*q^2+46*q^3-68*q^4+
46*q^5-12*q^6,Unknown(),Unknown(),12-54*q+78*q^2-20*q^3-32*q^4-20*q^5+78*q^6-
54*q^7+12*q^8,Unknown(),Unknown(),Unknown(),4*q^21-24*q^22+52*q^23-52*q^24+
24*q^25-4*q^26,Unknown(),Unknown(),6-16*q-6*q^2+68*q^3-108*q^4+112*q^5-
108*q^6+68*q^7-6*q^8-16*q^9+6*q^10,-q^6,Unknown(),Unknown(),-q^12,-2*q^3+
12*q^4-20*q^5+12*q^6-2*q^7,Unknown(),Unknown(),Unknown(),-4*q^42+24*q^43-
52*q^44+52*q^45-24*q^46+4*q^47,Unknown(),Unknown(),8*q^63-42*q^64+88*q^65-
88*q^66+42*q^67-8*q^68,Unknown(),Unknown(),-6*q^2+12*q^3-30*q^4+84*q^5-
136*q^6+84*q^7-30*q^8+12*q^9-6*q^10,q^9,24*q^105-90*q^106+130*q^107-90*q^108+
24*q^109,8*q^105-42*q^106+88*q^107-88*q^108+42*q^109-8*q^110,Unknown(),-7*q^6+
21*q^7-21*q^8+7*q^9,24*q^21-90*q^22+130*q^23-90*q^24+24*q^25,Unknown(),
24*q^42-104*q^43+160*q^44-104*q^45+24*q^46,-q^44+q^45,Unknown(),Unknown(),
8*q^42-40*q^43+64*q^44-40*q^45+8*q^46,Unknown(),-1280*q^21,6*q^22-14*q^23+
6*q^24,-320*q^21+640*q^22-320*q^23,Unknown(),48*q^21-160*q^22+160*q^23-
48*q^24,160*q^21-480*q^22+480*q^23-160*q^24,-34*q^21+140*q^22-214*q^23+
140*q^24-34*q^25,Unknown(),-8*q^21+44*q^22-72*q^23+44*q^24-8*q^25,-52*q^21+
212*q^22-320*q^23+212*q^24-52*q^25,-12*q^21+57*q^22-110*q^23+110*q^24-57*q^25+
12*q^26,-16*q^21+216*q^23-384*q^24+216*q^25-16*q^27,-64*q^21+144*q^22+72*q^23-
288*q^24+72*q^25+144*q^26-64*q^27,-24*q^23+68*q^24-68*q^25+24*q^26,8*q^21-
8*q^22-108*q^23+300*q^24-300*q^25+108*q^26+8*q^27-8*q^28,32*q^21-104*q^22+
36*q^23+180*q^24-180*q^25-36*q^26+104*q^27-32*q^28,Unknown(),12*q^23-46*q^24+
68*q^25-46*q^26+12*q^27,q^23-7*q^24+10*q^25-7*q^26+q^27,2*q^24-12*q^25+
20*q^26-12*q^27+2*q^28,640*q^21-640*q^22,6*q^23-12*q^24+30*q^25-84*q^26+
136*q^27-84*q^28+30*q^29-12*q^30+6*q^31,16*q^21-72*q^22+72*q^23-16*q^24,-
208*q^21+432*q^22-208*q^23,Unknown(),104*q^21-320*q^22+320*q^23-104*q^24,
7*q^27-21*q^28+21*q^29-7*q^30,Unknown(),Unknown(),-8*q^63+40*q^64-64*q^65+
40*q^66-8*q^67,Unknown(),-q^18,-24*q^21+104*q^22-160*q^23+104*q^24-24*q^25,
Unknown(),1280*q^42,Unknown(),320*q^42-640*q^43+320*q^44,-48*q^42+160*q^43-
160*q^44+48*q^45,-160*q^42+480*q^43-480*q^44+160*q^45,-16*q^42+52*q^43-
72*q^44+52*q^45-16*q^46,12*q^42-57*q^43+110*q^44-110*q^45+57*q^46-12*q^47,
Unknown(),16*q^42-216*q^44+384*q^45-216*q^46+16*q^48,-8*q^42+8*q^43+108*q^44-
300*q^45+300*q^46-108*q^47-8*q^48+8*q^49,24*q^44-68*q^45+68*q^46-24*q^47,-
q^44+7*q^45-10*q^46+7*q^47-q^48,-640*q^42+640*q^43,208*q^42-432*q^43+208*q^44,
-104*q^42+320*q^43-320*q^44+104*q^45,-7*q^48+21*q^49-21*q^50+7*q^51,-24*q^42+
90*q^43-130*q^44+90*q^45-24*q^46,8*q^84-40*q^85+64*q^86-40*q^87+8*q^88,
Unknown(),-1280*q^63,-12*q^18+8*q^19+90*q^20-184*q^21+98*q^22+98*q^24-
184*q^25+90*q^26+8*q^27-12*q^28,Unknown(),48*q^63-160*q^64+160*q^65-48*q^66,
Unknown(),Unknown(),-16*q^63+216*q^65-384*q^66+216*q^67-16*q^69,Unknown(),-
24*q^65+68*q^66-68*q^67+24*q^68,q^65-7*q^66+10*q^67-7*q^68+q^69,20*q^18-
162*q^20+210*q^21-210*q^24+162*q^25-20*q^27,-208*q^63+432*q^64-208*q^65,
Unknown(),24*q^63-90*q^64+130*q^65-90*q^66+24*q^67,1280*q^84,Unknown(),
320*q^84-640*q^85+320*q^86,8*q^21-42*q^22+88*q^23-88*q^24+42*q^25-8*q^26,-
640*q^84+640*q^85,208*q^84-432*q^85+208*q^86,Unknown(),-48*q^84+160*q^85-
160*q^86+48*q^87,-1280*q^105,Unknown(),-320*q^105+640*q^106-320*q^107,
640*q^105-640*q^106,-208*q^105+432*q^106-208*q^107,Unknown(),48*q^105-
160*q^106+160*q^107-48*q^108];
  tbl.irreducibles:=[List(l,i->x^i),List(l,i->y^i),
 adj(f3,x,y,E(3)),adj(f3,y,x,E(3)),adj(f3,x,y,E(3)^2),adj(f3,y,x,E(3)^2),
 adj(f7,x,y,E(3)),adj(f7,y,x,E(3)),adj(f7,x,y,E(3)^2),adj(f7,y,x,E(3)^2),
 adj(f11,x,y,E(3)),adj(f11,y,x,E(3)),adj(f13,x,y),adj(f13,y,x),      
 adj(f15,x,y,E(3)),adj(f15,y,x,E(3)),adj(f15,x,y,E(3)^2),adj(f15,y,x,E(3)^2),
 f19(x,y),f19(y,x),f21(x,y),f21(y,x),
 adj(f23,x,y),adj(f23,y,x),adj(f25,x,y),adj(f25,y,x),
 adj(f27,x,y),adj(f27,y,x),                                         
 adj(f29,x,y,E(3)),adj(f29,x,y,E(3)^2),adj(f29,y,x,E(3)^2),adj(f29,y,x,E(3)),
 adj(f33,x,y,E(3)),adj(f33,y,x,E(3)^2),adj(f33,x,y,E(3)^2),adj(f33,y,x,E(3)),
 adj(f37,x,y),adj(f37,y,x),
 adj(f39,x,y,E(3)),adj(f40,x,y,E(3)),adj(f39,y,x,E(3)),adj(f40,y,x,E(3)),
 adj(f40,x,y,E(3)^2),adj(f39,y,x,E(3)^2),adj(f39,x,y,E(3)^2),
 adj(f40,y,x,E(3)^2),
 adj(f47,x,y,E(3)),adj(f47,y,x,E(3)),adj(f47,x,y,E(3)^2),adj(f47,y,x,E(3)^2),
 adj(f51,x,y),adj(f51,y,x),
 adj(f53,x,y,E(3)),adj(f53,y,x,E(3)),adj(f53,x,y,E(3)^2),adj(f53,y,x,E(3)^2),
 adj(f57,x,y,E(3)),adj(f57,y,x,E(3)),adj(f57,x,y,E(3)^2),adj(f57,y,x,E(3)^2),
 adj(f61,x,y), adj(f62,x,y),adj(f62,y,x), adj(f64,x,y),adj(f64,y,x),
 adj(f66,x,y),adj(f66,y,x),
 adj(f68,x,y,E(3)),adj(f68,y,x,E(3)),adj(f68,y,x,E(3)^2),adj(f68,x,y,E(3)^2),
 adj(f72,x,y,E(3)),adj(f72,y,x,E(3)),adj(f72,x,y,E(3)^2),adj(f72,y,x,E(3)^2),
 adj(f76,x,y,E(3)),adj(f76,x,y,E(3)^2),adj(f76,y,x,E(3)),adj(f76,y,x,E(3)^2),
 adj(f80,x,y),adj(f80,y,x), adj(f82,x,y),adj(f82,y,x),
 adj(f84,x,y,E(3)),adj(f84,y,x,E(3)),adj(f84,x,y,E(3)^2),adj(f84,y,x,E(3)^2),
 adj(f88,x,y,E(3)),adj(f88,y,x,E(3)),adj(f88,x,y,E(3)^2),adj(f88,y,x,E(3)^2),
 adj(f92,x,y,E(3)),adj(f92,y,x,E(3)^2),adj(f92,x,y,E(3)^2),adj(f92,y,x,E(3)),
 adj(f96,x,y,E(3),1),adj(f96,y,x,E(3),1),adj(f96,x,y,E(3)^2,1),adj(f96,y,x,E(3)^2,1),
 adj(f96,y,x,E(3)^2,-1),adj(f96,x,y,E(3)^2,-1),adj(f96,y,x,E(3),-1),adj(f96,x,y,E(3),-1),
 adj(f104,x,y),adj(f104,y,x),adj(f106,x,y),
 adj(f107,x,y,E(3)),adj(f107,y,x,E(3)^2),adj(f107,x,y,E(3)^2),adj(f107,y,x,E(3)),
 adj(f111,x,y,E(3)),adj(f111,y,x,E(3)),adj(f111,x,y,E(3)^2),adj(f111,y,x,E(3)^2),
 adj(f115,x,y),adj(f115,y,x),adj(f117,x,y),adj(f117,y,x),
 adj(f119,x,y,E(3)),adj(f119,x,y,E(3)^2),adj(f121,x,y,E(3)),adj(f121,x,y,E(3)^2),
 adj(f123,x,y),adj(f123,y,x),adj(f125,x,y),adj(f126,x,y,E(3)),adj(f126,y,x,E(3)),
 adj(f128,x,y),adj(f128,y,x),
 adj(f130,x,y,E(3)),adj(f130,y,x,E(3)),adj(f130,x,y,E(3)^2),adj(f130,y,x,E(3)^2),
 adj(f134,x,y,E(3)),adj(f134,y,x,E(3)^2),adj(f134,x,y,E(3)^2),adj(f134,y,x,E(3)),
 adj(f138,x,y,E(3)),adj(f138,x,y,E(3)^2),
 adj(f140,x,y,1),adj(f140,y,x,1),adj(f140,x,y,E(3)),adj(f140,y,x,E(3)),
 adj(f140,x,y,E(3)^2),adj(f140,y,x,E(3)^2),
 adj(f146,x,y,E(3)),adj(f146,y,x,E(3)),adj(f146,x,y,E(3)^2),adj(f146,y,x,E(3)^2),
 adj(f150,x,y,E(3)),adj(f150,y,x,E(3)^2),adj(f150,x,y,E(3)^2),adj(f150,y,x,E(3)),
 adj(f154,x,y,E(3)),adj(f154,y,x,E(3)^2),adj(f154,x,y,E(3)^2),adj(f154,y,x,E(3)),
 adj(f158,x,y,1),adj(f158,y,x,1),adj(f158,x,y,-1),adj(f158,y,x,-1),
 adj(f162,x,y,E(3)),adj(f162,y,x,E(3)),adj(f162,x,y,E(3)^2),adj(f162,y,x,E(3)^2),
 adj(f166,x,y,E(3)),adj(f166,x,y,E(3)^2),adj(f168,x,y),adj(f169,x,y)];
  tbl.centralizers:=List(tbl.classes,x->tbl.order/x);
  tbl.irredinfo:=List(CHEVIE.RawData("CharInfo","G33")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G33")(x,rec())));
  return CHEVIE.compat.MakeCharacterTable(tbl);
end);

CHEVIE.AddData("HeckeRepresentation","G34",function(para,root,i)
  local r,p,f1,f3,f7,f11,f13,f15,f19,f21,rep; r:=para[1][1];p:=para[1][2];
  f1:=function(p)return List([1..6],x->[[p]]);end;
  f3:=function(x,y,a)return WGraph2Representation(
  [[[1,2,3,4,5],[1,2,3,4,6],[1,2,3,5,6],[1,2,4,5,6],[1,3,4,5,6],[2,3,4,5,6]],
   [[1,2,-y,x],[2,3,-y,x],[3,4,a*x^-1*y^2,-a^2*x^2*y^-1],[3,5,-y,x],
   [4,5,x,-y],[5,6,x,-y]]],[x,y])*x^0*y^0;
  end;
  f7:=function(p,r,a)return List(f3(p,r,a),x->ExteriorPower(x,2)/p);end;
  f11:=function(p,r,a)return List(f3(p,r,a),x->ExteriorPower(x,3)/p^2);end;
  f13:=function(x,y)return
[[[0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x+y,0,0,0,0,0,0,0,0,x,0,0,0,
0,0,0,0,0,0,0],[x,0,y,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,0,0,x+y,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,y,x,0,0,0,0,0,x,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,
0,0],[0,0,0,0,-x,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,0,-x,y,0,0,0,
0,0,0,0,0,0,0,0,0],[0,x,0,0,0,0,0,0,0,y,x,0,0,0,0,0,0,0,0,0,0],[0,-y,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,y,0,y,0,0,0,0,0,0,y,y,0,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,x,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,0,0,0,0,0,y,x,0,
-x,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,y,0,0,0,0],[0,0,0,0,y,0,y,-y,0,0,
0,0,y,0,0,y,0,0,0,0,0],[0,0,0,0,0,0,-x,0,0,0,0,0,0,0,-x,0,x+y,0,0,0,0],[-x,-x,
0,-x,-x,0,-x,x,0,0,-x,0,0,0,-x,0,x,y,0,0,0],[x+y,x+y,y,x+y,0,0,x,0,0,y,x+y,y,
0,y,x,0,-x,0,0,0,y],[x+y,y,y,x+y,0,0,0,0,0,y,y,y,0,y,0,0,0,0,-y,y,y],[0,0,x,0,
0,0,0,0,0,x,0,x,0,x,0,0,0,0,-x,0,x+y]],[[y,0,-y,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,
0,0,0,0],[0,y,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,x,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,0,y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,y,0,y,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
0,0,0,0,y,0,0,y,0,0,0,0,0,0,0,0,0,0,0],[0,0,y,0,0,0,0,y,y,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,x,0,0,0,0,
0,0,0,0,0,0,0],[0,0,0,0,0,-y,0,0,0,-y,y,0,0,0,0,0,0,0,0,0,0],[0,0,y,0,0,0,0,0,
0,y,0,y,0,y,0,0,0,0,0,0,0],[0,0,0,0,0,-y,0,0,0,-y,0,0,y,0,0,0,0,0,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0],[0,0,y,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0],[0,0,y,0,0,0,0,0,0,y,0,0,0,
y,0,0,y,0,0,0,0],[0,0,y,0,0,0,0,0,0,y,0,0,0,y,0,0,0,y,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,x,0,0,x+y,0,0],[0,0,y,0,0,0,0,0,0,y,0,0,0,y,0,0,0,0,0,y,0],[0,0,
y,0,0,y,0,0,y,y,0,0,0,0,0,0,0,0,0,0,y]],[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,0,y,x,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x,0,0,0,y,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,-x,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,y,0,0,0,-x,0,0,0,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,y,0,0,0,0,0,0,0,0,0,
0,0,0,0],[0,0,0,-x,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,0,0,0,0,0,y,x,
0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,x,0,0,0,0,0,0,0,0,0],[0,-x,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0],
[-x,-x,0,-x,0,0,0,0,0,0,-x,-x,0,y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,x,0,0,
y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,-x,0,0,0,y,0,0,0,0,0],[x,x,0,x,0,0,0,0,
0,0,x,x,0,0,0,0,y,0,0,0,0],[0,0,x,0,0,0,0,0,0,x,0,x,0,x,0,0,0,y,-x,x,0],[0,0,
y,0,0,0,0,0,0,y,0,0,0,y,0,0,0,0,0,y,0],[0,0,x,0,0,0,0,0,0,x,0,x,0,x,0,0,0,0,
-x,x+y,0],[x+y,y,y,x+y,0,0,0,0,0,y,y,y,0,y,0,0,0,0,-y,y,y]],[[y,0,0,0,y,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0],[0,0,y,
0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,y,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,y,x,0,0,0,0,0,x,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,x,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,0,-x,y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,0,-x,0,0,y,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,y,0,0,0,y,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,x,0,
0,0,0,0,0,0,0],[0,0,-y,0,x,0,x,0,0,-y,0,0,0,0,0,0,0,-y,0,0,0],[0,0,0,0,0,0,-x,
0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,y,0,0,0,y,0,0,0,0],[0,0,x,0,0,0,0,0,0,x,0,0,0,x,0,0,0,x+y,
0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,y,0,0,0,y,0],[0,0,y,0,-x,0,0,x,0,y,0,0,0,y,0,0,0,y,0,0,y]],[[0,0,0,-y,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,y,0,y,0,0,0,0,0,0,y,y,0,0,0,0,0,0,0,0,0],[0,
0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[0,0,y,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,y,0,0,0,0,0,0,0],[0,0,0,0,0,0,y,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[x,0,y,x,0,0,0,
y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,-x,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,y,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,
0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,x+y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,-y,0,0,0,0],[0,0,0,0,0,-x,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,-x,-x,0,0,-y,y,0,0,0,
0,0],[0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,x+y,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,x,
0,0,0,x,y,0,0,0],[0,0,x+y,0,0,-x,0,0,0,0,x,x,0,x,y,0,0,0,y,0,0],[x,0,y,x,0,0,
0,0,0,0,x,x,0,0,y,0,0,0,0,y,0],[x,0,y,x,0,0,0,0,0,0,0,0,y,0,0,0,y,0,0,0,y]],
[[0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0],[0,x+y,0,x,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0],[0,-y,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
0,0,0,x+y,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0],[0,0,0,0,0,-y,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0],[0,0,x,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0],[x,0,0,0,0,
0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0],[y,y,0,y,0,0,0,0,0,0,y,y,0,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,0,-x,0,0,0,0,x+y,0,0,0,0,0,0,0,0],[0,0,-x,0,0,0,0,0,0,-x,0,0,
0,y,0,0,0,0,0,0,0],[0,0,y,0,-x,0,-x,0,0,y,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,y,0,
y,-y,0,0,0,0,y,0,0,y,0,0,0,0,0],[x,x,y,x,0,0,0,0,0,y,x,0,0,0,0,0,y,0,0,0,0],
[0,0,y,0,-x,0,-x,0,0,y,0,0,0,0,0,0,0,y,0,0,0],[0,0,0,0,-y,y,-y,y,y,0,0,0,-y,0,
0,0,0,0,y,0,0],[x,0,y,0,-y,y,-y,y,y,y,x,0,-y,0,0,0,0,0,0,y,0],[0,0,y,0,0,y,0,
0,y,y,0,0,0,0,0,0,0,0,0,0,y]]];end;
  f15:=function(x,y,a)return
[[[0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,x+y,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[0,0,x,-x,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,-x,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,x,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
0,y,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,x,0,x,0,x,x,0,x,0,0,0,0,0,x,0,0,0,
0,0,0],[x,x,0,x,0,x,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,-x,0,0,0,0,0,0],[x,x,0,0,0,0,0,0,0,x,0,x,-x,0,0,0,0,x,0,0,0],[0,0,0,x,0,x,0,
0,0,0,x,0,0,0,0,0,0,0,0,0,0],[x,x,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0],[x,x,
0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,x,0,0,0],[x,x,0,x,0,x,0,0,x,0,0,0,0,x,x,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,y,0,0,0,0,0,x+y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,x*y^-1,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y^2,x+y,0,0,0,0],[0,0,0,
0,0,0,0,0,0,0,0,y,-y,0,0,0,0,x+y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,
x*y^-1,0,x,0,0],[x,x,0,x,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0],[x,x,0,0,0,0,0,0,
x,0,0,0,0,0,x,0,0,0,0,0,x]],[[0,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,
x,x,-y,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,0,0,-x,0,
0,0,0,0,0,0,0,0,0,0,0],[y,0,y,x+y,0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,0,x,
0,0,0,x,0,x,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,y,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,y,0,0,0,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,-x,0,x,0,0,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,x,0,-x,0,0,x,0,0,0,0,0,0,0,0],[0,0,
0,0,0,0,0,0,x,0,0,0,0,x,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,x,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,x+y,0,0,0,0,0],[-y^2,0,-y^2,-y^2,0,0,0,
-y^2,0,0,0,0,0,0,0,0,x,0,0,0,0],[0,0,0,x+y,0,0,0,x+y,0,-y,0,0,0,0,0,0,0,x,0,0,
0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,0,0,0,0,a^2*x,a*x,-x,
0,0,0,0,-x,0,0,0,x,0],[x-a^2*y,0,x-a^2*y,0,0,0,0,0,
(3/2)*x+(1/2)*a*x+(-1/2)*a^2*x-a^2*y,a^2*x,x,0,0,0,0,x,0,0,0,0,x]],[[y,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[x,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,0,0,x,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0],[0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,0,x,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[-y,0,0,0,-y,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,
0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,y,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,x,0,y,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,0,0,0,0,x,0,0,0,0,
0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,y,x,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,-y,0,0,y,0,0],[-y,-y,0,
0,-y,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x*y,x,0,x*y,0,0],[x,x,0,0,0,0,0,0,0,0,0,
x,0,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,x+y,0,0],[0,0,0,0,
0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,x,0],[0,0,0,0,0,0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0,
x]],[[0,0,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,-x,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[0,-x,x,0,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,0,0,x+y,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0,0,0],
[0,y,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-y,0,0,-y,0,0,x,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[x,x,0,x,0,x,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,-x,0,0,0,0,0,0,0],[0,0,0,0,a^2*y,0,0,0,-x,x,a^2*y,0,0,-x,0,0,0,0,0,
-a^2*y,0],[0,0,0,0,y,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,x,0,0,0,0,0,0,0,-x,0],[x,0,0,x,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,0,y,0,0,0,0,x+y,0,0,0,0,0,0,0],[x,x,0,x,0,x,0,0,x,0,0,0,0,x,x,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,x,0,0,0,0,x,0,x,0,0,0,0,0],[x*y,x*y,0,x*y,0,x*y,0,0,x*y,0,
0,0,0,x*y,0,0,x,0,0,0,0],[x,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,x,0],[0,0,0,0,
x,0,0,0,0,0,x,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x]],[[0,0,0,0,-x,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[x,x,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,0,0,
-x,0,0,0,0,0,0,0,0,0,0,0,0],[x,0,0,x,x,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,0,
0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-2*x,-x,0,-x,-x,0,-x,0,-x,0,0,0,0,0,
-x,0,0,0,0,0,0],[0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x,0,0,0,-x,0,-x,
x,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,0,y,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-x,0,0,0,x,0,0,0,0,0,0,
0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
x,0,0,0,0,0,0,0,0],[x,x,0,x,0,x,0,0,x,0,0,0,0,x,x,0,0,0,0,0,0],[0,y,-y,y,0,y,
0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0],[x,0,x,0,0,0,x,0,x,0,0,0,0,0,0,x,0,0,0,0,0],
[x*y,0,x*y,0,0,0,x*y,0,x*y,0,0,0,0,0,0,0,x,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,x,0,0,0],[x,0,x,0,0,0,x,0,x,0,0,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,0,0,0,
0,0,0,0,x,0,0,0,0,0,0,0,0,-x],[0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,y,x+y]],
[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0],[0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x,0,0,-x,0,0,0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,0,0,0,0,-y,x+y,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,-x,0,0,0,0,0,0,0,x,0],[0,0,0,0,-y,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0],[y,0,
0,y,0,0,y,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0],[0,0,0,0,-a^2*y,0,0,0,x,-x,-a^2*y,0,
0,x,0,0,0,0,0,a^2*y,0],[-x,-x,0,0,0,0,0,0,0,-x,0,-x,x,0,0,0,0,-x,0,0,0],[0,0,
0,0,0,0,0,0,-a^2*x,a^2*x,x,x,0,0,0,x,0,0,0,-x,0],[a^2*x*y,a^2*x*y,0,0,0,0,0,0,
0,a^2*x*y,x*y,-a*x*y,-a^2*x*y,0,a^2*x*y,0,x,a^2*x*y,0,-x*y,0],[2*y,y,0,y,y,0,
y,0,y,0,0,0,0,0,y,0,0,x+y,0,0,0],[0,0,0,0,x-a^2*y,0,0,0,-a^2*x,a^2*x,x,a^2*y,
0,0,0,0,0,0,x,-x,0],[0,0,0,0,-y,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,x+y,0],[-x,0,0,
-x,0,0,-x,0,0,0,0,0,-x,0,0,0,0,0,0,0,x]]]*x^0*y^0;
  end;
  f19:=function(x,y)return
[[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,x,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,y^2,0,y,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x+y,0,x,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x+y,-x,0,
0,0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,-y,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x*y+x^2,0,0,x,0,x,y,0,0,
0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y^2,x*y^2,-x*y,0,0,0,0,
0,y,0,0,-x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y,x*y,0,0,0,0,
0,0,0,y,0,0,0,-x,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,0,-y,0,0,0,0,
0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y-2*y^2,-y^2,y,0,y,0,y,
0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,y,y,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y,-x*y,x,0,x,x,0,0,0,0,0,0,0,0,x,-x,0,0,y,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,x*y+2*y^2,-y,0,0,0,0,0,0,0,0,-y,0,0,-y,0,0,
0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,x*y+2*y^2,-y,0,0,0,0,0,0,0,0,-y,0,0,
0,0,y,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y-x^2,0,0,0,0,0,0,0,0,0,0,0,0,
0,-x,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y+y^2,x*y+y^2,-x-y,0,0,0,0,0,
0,0,0,-y,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[-x^2*y,0,0,0,0,0,0,0,
0,0,0,0,0,x^2,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0],[-y^2,-y^2,y,0,0,0,0,
0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0],[-x*y-x^2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0],[y^2,y^2,-y,0,0,0,0,0,0,
0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0],[y^3,y^3,0,0,-y^2,-y^2,
0,0,0,0,0,0,0,-y^2,-y^2,y^2,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0],[x*y^3+x^2*y^2,
x*y^3,-x*y^2-x^2*y,0,0,0,0,0,0,0,0,-x*y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
y,0,0,0,0],[0,0,-x*y-y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,y^2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,-y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
x+y,0],[-x*y^2-y^3,-x*y^2-y^3,0,0,x*y+y^2,x*y+y^2,0,0,0,0,0,0,0,0,x*y+y^2,
-x*y-y^2,y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y]],[[x,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,-1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x*y,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y,x*y,0,x,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[0,-x*y,0,-x-y,-y,0,0,0,0,0,-y,0,-y,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y+y^2,0,-y,-y,-y,0,-y,y,0,0,0,0,-y,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y^2,0,-x*y,0,0,0,0,0,y,0,x*y,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y,x*y,0,x,0,0,0,0,0,y,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,-x,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y-y^2,-x*y-y^2,x+y,-x-y,0,0,0,0,0,0,
-x-y,y,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y,-x*y,x,0,x,0,x,0,
0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y-y^2,0,0,0,0,0,
0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0],[x*y+y^2,0,0,0,
0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y+2*y^2,
x*y+y^2,-y,x+y,0,0,0,0,0,0,y,0,0,0,0,y,0,y,y,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],
[-x*y-y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[-x*y,0,x,0,0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0,y,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0],
[-x*y,0,x,0,0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0,0,y,0,x,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0],
[-x*y^2-x^2*y,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0],[-y^2,0,y,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,-y,-y,0,0,0,0,0,y,0,0,0,0,0,0,0,
0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,
0],[-x*y^2-x^2*y,0,x*y,0,0,0,0,0,0,0,-x*y,0,0,x^2,0,0,0,0,0,0,0,0,0,-x,0,0,y,
0,0,0,0,0,0,0,0],[-x*y,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,-1,0,0,0,y,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,
0,0,0,0],[-x*y^2-x^2*y,0,x*y+x^2,0,0,0,0,0,0,0,-x*y-x^2,0,0,0,0,0,0,0,0,0,0,
-x*y,0,0,0,0,0,0,0,y,0,0,0,0,0],[2*x*y^3+x^2*y^2+2*y^4,x*y^3+2*y^4,
-x*y^2-2*y^3,x*y^2,-y^3,-y^3,0,0,0,0,0,-y^3,0,0,-y^3,y^3,0,x*y^2+y^3,y^3,0,0,
0,-x*y^2,0,0,0,0,0,0,0,0,0,-y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,y,0,0,0],[-2*x*y^3-x^2*y^2,-2*x*y^3,2*x*y^2+x^2*y,0,x*y^2,
x*y^2,0,0,0,0,0,x*y^2,0,0,x*y^2,-x*y^2,0,-x*y^2-x^2*y,-x*y^2,0,0,0,0,0,0,0,0,
0,0,0,x,0,x+y,0,0],[x*y^3+x^2*y^2+x^3*y,x*y^3,0,x*y^2,0,0,0,0,0,0,0,0,0,0,0,0,
0,y^3,y^3,0,0,0,-x*y^2,0,0,0,0,0,0,0,0,0,0,y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y]],[[0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y,x*y,0,x,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,0,-x,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[2*x*y+x^2,x*y,-x,0,-x,0,-x,x+y,0,0,0,0,-x,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[x*y,x*y,0,x,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[y^2,y^2,-y,0,0,0,0,0,-1,0,y,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,x,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[0,-x*y-y^2,0,0,-y,0,-y,y,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,-y,0,0,0,0,0,0,0,0,-y,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[-y^2,-y^2,y,0,0,0,0,0,0,0,0,y,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[y^2,y^2,-y,0,0,0,0,0,0,0,0,-y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[x*y+x^2,-x*y-x^2,0,0,-x,0,-x,x,1,0,0,x,-x,0,x,0,0,y,0,-x,0,x,0,0,x,
0,0,0,0,0,0,0,0,0,0],[-x*y-x^2,x*y+x^2,0,0,x,0,x,-x,0,0,0,-x,x,0,-x,0,0,0,y,x,
0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y-x^2,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,0,0,
0,x+y,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y-x^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x,0,0,0,x+y,0,0,0,0,-x,0,0,0,0,0,0,0,0,0],[y^2,x*y+2*y^2,-y,0,0,0,0,0,0,0,0,
-y,0,0,-y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y+y^2,x*y+y^2,-y,x,0,0,
0,0,-1,0,0,-y,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[x*y^2,x*y^2,
-x*y,0,0,0,0,0,0,0,0,-x*y,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,x*y,0,0,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0],[y^2,
x*y+2*y^2,-y,0,0,0,0,0,0,0,0,-y,0,0,0,0,y,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[-x^2*y-x^3,x^2*y+x^3,0,0,x^2,0,x^2,-x^2,-x,0,0,-x^2,x^2,0,0,0,x^2,0,0,0,
x^2,0,0,0,0,-x^2,y,x^2,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x^2,0,-x^2,0,0,
x^2,-x^2,-x^2,0,0,-x*y-x^2,x^2,0,-x*y-x^2,y,0,0,0,0,0,0],[x^2*y-y^3,
2*x*y^2+3*x^2*y+x^3,x*y+y^2,x*y+x^2,x*y+x^2+y^2,0,x*y+x^2,-x*y-x^2,x+y,0,
-2*x*y-y^2,-x*y-x^2,x^2,0,0,0,0,0,0,0,0,0,x*y,0,x*y+y^2,0,0,0,0,0,y/x,0,0,0,
0],[-x^2*y^2-x^3*y,x^3*y+x^4,x^2*y+x^3,0,x^2*y+x^3,0,x^3,-x^3,0,0,
-x^2*y-2*x^3,-x^3,0,0,0,0,0,0,0,0,0,0,x^3,0,x*y^2+x^2*y,0,0,0,0,-x^2,x+y,0,0,
0,0],[x^2*y-y^3,3*x*y^2+3*x^2*y+x^3+y^3,0,x*y+x^2,x*y+x^2+y^2,0,x*y+x^2,
-x*y-x^2,0,0,-2*x*y-y^2,-2*x*y-x^2-y^2,x^2,0,0,0,y^2,0,0,0,y^2,0,x*y,0,y^2,
-y^2,0,-x*y,0,-y,y/x,y,0,0,0],[-2*x*y^3-x^2*y^2-y^4,
-2*x*y^3-2*x^2*y^2-x^3*y-y^4,x*y^2+y^3,-x*y^2-x^2*y,-x^2*y,0,-x^2*y,x^2*y,
x*y+y^2,0,0,x*y^2+x^2*y+y^3,-x^2*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,
0],[x*y^3,x*y^3+x^2*y^2+x^3*y,x^2*y,x*y^2+x^2*y,x^2*y,0,x^2*y,-x^2*y,-x*y-y^2,
0,0,0,x^2*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0],
[x*y^2+3*x^2*y+x^3-y^3,2*x*y^2+x^2*y+y^3,0,x*y+x^2,y^2,0,0,0,y,0,-2*x*y-y^2,
-x*y-y^2,-x*y,0,x*y+x^2,0,y^2,0,0,-x*y-x^2,y^2,x*y+x^2,x*y,0,x*y+y^2,-y^2,0,
-x*y,0,-y,y/x,0,0,0,y]],[[0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[y,y,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[-x*y,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[0,0,0,y,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,-x,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[x*y+y^2,x*y+y^2,-x-y,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,
0,0,0,0,0],[x*y^2,0,-x*y,0,0,0,0,0,y,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[0,0,0,0,-y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,-y,0,-y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,y,0,0,0,0,0,y,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,y,
0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y,0,x,0,0,0,0,0,0,0,-x,0,0,0,
0,0,0,y,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y,2*x*y+x^2+y^2,x,0,x+y,0,x+y,
-x-y,0,0,-x,-x-y,0,0,0,0,0,y,0,y,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y,
2*x*y+x^2+y^2,x,0,x+y,0,x+y,-x-y,0,0,-x,-x-y,0,0,0,0,0,0,0,0,y,0,x+y,0,0,0,
-y/x,0,0,0,0,0,0,0,0],[x*y+y^2,0,-x-y,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,y,
0,0,0,0,0,0,0,1,0,0,0,0,0],[0,x*y+x^2,0,0,x,0,x,-x,0,0,0,-x,0,0,0,0,0,0,0,0,0,
0,x+y,0,0,0,0,0,0,0,0,0,0,0,0],[x*y^2+y^3,0,-x*y-y^2,0,0,0,0,0,0,0,y^2,0,0,0,
0,0,0,0,0,0,0,0,0,y,0,0,y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,-1/x,0,0,0,0],[0,0,-x-y,0,0,0,0,0,0,0,0,0,0,0,0,0,y,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,x,0,0,0,0,0,0,0,0],[-x*y-y^2,0,0,0,0,0,0,0,0,0,-x-y,0,0,0,0,0,y,0,
0,0,0,0,0,0,y,-y,0,y,0,-1,1/x,1,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,x,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x^2*y,0,0,0,0,0,x+y,0,0,0,0],[-x*y^2-x^2*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,
0,0,0,0,0,0,0,0,-x*y,0,0,0,0,0,x+y,0,0,0],[0,-x^2*y^2-x^3*y,0,0,-x*y^2-x^2*y,
0,-x^2*y,x^2*y,0,0,-x*y^2,x^2*y,0,0,0,0,0,0,0,0,0,0,-x^2*y,0,0,0,0,0,0,0,0,0,
y,0,0],[x*y^3+x^2*y^2+x^3*y,x^2*y^2+x^3*y,-x*y^2-x^2*y-x^3,0,x*y^2+x^2*y,0,
x^2*y,-x^2*y,0,0,x*y^2,-x^2*y,0,0,0,0,0,0,0,0,0,0,x^2*y,0,0,0,0,0,0,0,0,0,0,y,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y]],
[[y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,y^2,0,
0,-y,-y,0,0,0,0,0,0,0,0,-y,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,y,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,y,y,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,x*y+2*y^2,-y,0,0,0,0,0,0,0,
0,-y,0,0,-y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,-x*y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,y,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,y^2,-y,0,-y,-y,0,0,0,0,y,0,
0,0,-y,y,0,y,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-y^2,-y^2,y,0,y,y,0,0,0,0,0,
y,0,0,y,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y+y^2,0,0,0,0,0,0,0,0,0,
0,0,0,0,y,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y,-x*y,x,0,x,0,x,0,0,0,0,0,0,
0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,
x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,x*y+x^2,0,0,x,0,x,-x,0,0,0,-x,0,0,0,0,0,0,0,x+y,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[2*x*y+x^2,x*y,-x,0,-x,0,-x,0,0,0,0,0,-x,0,0,0,0,0,0,0,
0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,y,0,0,0,
y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,
0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,
0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,
0,0,0,0,0],[-x*y^2-2*y^3,-y^3,y^2,0,y^2,y^2,0,0,0,0,-y^2,0,0,x*y+y^2,y^2,-y^2,
0,-y^2,-y^2,0,0,0,0,-y,0,0,0,0,-y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0],[x*y^2+x^2*y,0,0,0,0,0,0,0,0,0,x*y,0,
0,-x*y-x^2,0,0,0,0,0,0,0,0,0,x,0,0,x,0,x+y,0,0,0,0,0,0],[-2*x*y^2-x^2*y,
-x*y^2,x*y,0,x*y,x*y+y^2,0,0,0,0,0,0,x*y,0,0,-x*y,0,0,-x*y,0,0,-x*y,0,0,0,0,0,
0,0,y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y^2+x^2*y,x*y^2,0,0,0,0,
0,0,0,0,0,0,0,y,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,y],[-y^4,-y^4,y^3,0,y^3,y^3,0,0,0,0,0,0,0,0,y^3,-y^3,0,
-x*y^2-y^3,-y^3,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,x*y^2+y^3,y^3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,0,x+y]],[[y,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,-y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0],[0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,-x,-x,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y,-x*y,0,0,
x,x,0,0,0,0,0,0,0,x+y,x,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-y^2,-y^2,0,0,
0,0,0,0,0,y,0,0,0,y,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,0,0,0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y/x,0,0,0,0,0,0,0,0],[-x*y-y^2,0,y,0,0,0,
0,0,0,0,-y,0,0,x,0,0,0,0,0,0,0,0,0,-1,0,0,y/x,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,-x,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[x*y^2,-x^2*y,-x*y,0,x^2,x^2,0,0,0,
0,x*y,0,0,0,x^2,-x^2,0,x*y,x*y,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,0,0,x+y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,x^2,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,x+y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0],[-x*y^2-y^3,0,0,0,0,0,0,0,0,
0,-x*y-y^2,0,0,0,0,0,y^2,0,0,0,0,0,0,0,0,-y^2,0,0,0,0,0,y,0,0,0],
[-x*y^3-x^2*y^2,0,0,0,0,0,0,0,0,0,-x*y^2-x^2*y,0,0,0,0,0,x*y^2,0,0,0,0,0,0,0,
x*y^2,-x*y^2,0,x*y^2,0,-x*y,y,x*y,0,0,0],[-x*y^2-x^2*y,0,0,0,0,0,0,0,0,0,
-x*y-x^2,0,0,0,-x*y,0,0,0,0,0,0,-x*y,0,0,0,0,0,0,0,-x,0,x+y,0,0,0],
[x*y^3+2*x^2*y^2-2*y^4,-y^4,-x*y^2+y^3,0,y^3,y^3,0,0,0,0,2*x*y^2+x^2*y-y^3,0,
0,x*y^2-x^2*y+y^3,y^3,-y^3,-x*y^2,-y^3,x*y^2-y^3,0,0,-x^2*y,0,x*y-y^2,-x*y^2,
x*y^2+x^2*y,-y^2,-x*y^2,0,x*y,0,-x*y,y,0,0],[-x*y^3-x^2*y^2+y^4,x^2*y^2,
x*y^2-y^3,0,-x^2*y,-x^2*y,0,0,0,0,-2*x*y^2-x^2*y+y^3,0,0,-x*y^2,-x^2*y-x^3,
x^2*y,x*y^2-x^3,y^3,-x*y^2+y^3,0,0,x^2*y,0,-x*y+y^2,x*y^2,-x*y^2-x^2*y,y^2,
x*y^2,0,-x*y,0,x*y,0,y,0],[0,0,0,0,-y^2,-y^2,0,0,0,y^2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,y,0,0,0,0,0,y]]]*x^0*y^0;end;
  f21:=function(x,y)return
[[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,x^-1*y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,-x^2*y^-1,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0],[-y,-x-y-x^2*y^-1,x^-1*y^2+x+y,y,-x-y,x,-x-y-x^2*y^-1,0,-x-y-x^2*y^-1,0,
0,0,0,-x-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-y,x,-y,0,0,x+y,x+y,y,x+y,y,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[y,0,0,0,x+y,-x,0,0,0,0,0,y,0,x+y,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[y,0,0,0,0,-x-y,0,0,0,0,y,0,y,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0],[-y,-x-x^2*y^-1,x+y,0,-x,0,-x,-x-y,-x,0,-y,0,0,-x,y,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,x+y,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,x,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[x,-x^2*y^-1,x,0,0,0,0,0,0,0,0,0,0,0,0,x+y,x+y,x+y,0,0,y,y,0,0,0,0,0,
0,0,0,0,0,0,0,0],[-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,0,x+y,x+y,0,0,y,0,0,0,0,
0,0,0,0,0,0,0,0],[-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x-y,0,0,0,0,0,0,0,y,0,0,y,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,
0,0,0,0],[x,x^2*y^-1+x^3*y^-2,-x-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,-x,-x,
-x,-x-y,0,0,0,0,y,-y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,x,0,x,0,0,0,0,0,0,x+y,x+y,x+y,0,
0,0,0,0,0,-x^-1*y^2,0,0,y,0,0,0,0,0,0,0],[x,x+x^2*y^-1+x^3*y^-2,-x-y-x^2*y^-1,
0,0,0,0,0,0,0,0,0,0,0,0,x,-x-y-x^2*y^-1,-x-y-x^2*y^-1,-x-y,-x-y,0,0,0,0,0,0,0,
0,y,0,0,0,0,0,0],[0,x,-y,0,x,-x^2*y^-1,x+x^2*y^-1+x^3*y^-2,0,
x+x^2*y^-1+x^3*y^-2,0,0,0,0,x,0,0,x+x^2*y^-1,x+x^2*y^-1,x,x,0,0,0,0,-x-y,0,0,
0,0,y,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,
0,0],[0,0,0,0,0,-x,0,0,0,0,0,0,0,0,0,-x-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,y,0,
0],[y,-x-y,x^-1*y^2+y,0,0,-x,-x-y,0,-x-y,0,0,0,0,0,0,-x,-x-y,-x-y,0,0,0,0,0,0,
0,0,0,0,0,0,-y,0,0,y,0],[0,-x,y,0,0,0,-x,x,-x,0,0,0,0,0,0,0,-x,-x,0,0,x+y,0,0,
0,0,0,0,0,0,0,-x,0,0,0,y]],[[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[-y,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0],[0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[-y,x,x,y,0,x,x,0,-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,x^-2*y^3,0,y,0,0,0,-x^-1*y^2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,0,0,0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0],[0,0,-x-y,0,x+x^2*y^-1,x,x,x+y,x,x+y,y,x,0,x,x,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[0,0,0,0,x+x^2*y^-1,0,0,0,0,0,0,x+y,0,x,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,x,0,-x-x^2*y^-1,-x,-x,-x,0,-x,0,-x,y,-x,-x,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,-x^-2*y^3-x^-1*y^2,0,-x-y,0,0,0,
x^-1*y^2+y,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,x,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,y,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,x+y,
0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,x+y,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,0,0,-x,-x,0,0,-x,-x,
-x,-x,y,0,-x,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,x,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x,0,0,0,0,0,0,0,0,0],[0,0,x+x^2*y^-1,0,0,0,0,0,0,0,0,0,0,0,0,x,x,x,0,x,x+y,
x+y,x,0,0,x,y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,-y,0,0,x+y,0,0,0,0,0,0,0],[x,-x^2*y^-1,-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,0,0,x,
x,-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0],[y,-x-y,y,0,0,-x,-x-y,0,-x,0,0,0,0,0,
0,-x,-x-y,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0],[y,-x,0,0,x+y,-x,-x,0,
x+x^2*y^-1,0,0,y,0,y,0,0,0,x,0,y,0,0,y,0,-x^-1*y^2-y,0,0,x+y,0,-y,0,y,0,0,0],
[-y,x,0,0,-x-y,x,x,0,-x^2*y^-1,0,0,-y,0,-y,0,0,0,0,0,-y,0,0,-y,0,y,0,0,-x,0,y,
0,0,y,0,0],[0,-x,y,0,0,0,-x,0,-x,0,0,0,0,0,0,0,-x,-x,0,0,0,0,0,0,0,0,0,0,0,0,
-x,0,0,x+y,0],[0,0,y,0,-x-y,-y,-y,-y,0,-y,0,-y,0,-y,0,-x^-1*y^2-y,-x^-1*y^2-y,
0,0,-y,-x^-1*y^2-y,-x^-1*y^2-y,-y,0,-x^-1*y^2,x^-1*y^2,0,y,0,0,0,0,0,0,y]],
[[y,x^2*y^-1,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
x+y,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
x^-2*y^3,0,y,0,0,0,-x^-1*y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,0,y,-x,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,x,
0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,-y,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,x,0,0,
x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,-x^-2*y^3-x^-1*y^2,0,0,
0,y,0,x^-1*y^2+y,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,-y,x,
y,0,0,0,0,0,y,0,y,y,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,y,-x,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,y,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,y,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
y,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,-y,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,-y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,x+y,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,x,0,0,0],[0,x,-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,y,y,0,y,
0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,x+y,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,-y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,x+y,0,0,0,
0,0,0],[0,y,-x,-y,0,0,x+y,0,x^2*y^-1+x^3*y^-2,0,0,-y,0,0,0,0,y,x^2*y^-1,0,0,0,
0,-y,0,0,0,0,-x,-y,y,0,0,-x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,x,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-y,0,0,0,0,0,0,x+y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,x,0,0,0,0,x+y,0,0],[0,-y,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,
0,0,0,0,0,-y,0,0,y,0],[0,-2*x,-x+y,-y,0,0,-x,-y,-2*x,-y,-y,-y,-y,0,0,0,-x,
-2*x-y,0,0,-x^-1*y^2-y,-x^-1*y^2-y,-x^-1*y^2-y,-x^-1*y^2-y,0,0,-x^-1*y^2-y,0,
-x^-1*y^2-y,0,-x,0,0,0,y]],[[y,x^2*y^-1,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,-y,x,y,0,0,0,0,0,y,0,y,y,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0],[0,0,0,0,x+y,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0],[0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[0,0,0,0,-x-y,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0],[0,0,0,0,0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,-y,
0,x,0,x,0,x,0,y,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,x+y,
0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,
x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,
x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,x+y,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,
0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,x+y,0,0,0,
0,0,0,0,0,0],[0,-x^2*y^-1,x,0,0,0,0,0,0,0,0,0,0,0,0,0,x,x,x,x,0,0,0,0,0,0,y,0,
0,0,0,0,0,0,0],[0,0,y,0,-x-y,-y,-y,-y,0,-y,0,-y,0,-y,0,-x^-1*y^2-y,
-x^-1*y^2-y,0,0,-x^-1*y^2-y,-x^-1*y^2-y,-x^-1*y^2-y,-x^-1*y^2-y,0,-x^-1*y^2,0,
0,y,0,0,0,0,0,0,0],[0,x,-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,y,y,0,
y,0,0,y,0,0,0,0,0,0],[0,x,x,0,x+x^2*y^-1+x^3*y^-2,0,x,0,-x^2*y^-1,0,0,0,0,x,0,
-x-y,0,0,0,0,-x-y,0,0,y,-x-y,y,0,0,0,y,0,0,-x,0,x],[0,y,-x^-1*y^2,0,y,0,x+y,0,
x+y,0,0,0,0,y,0,0,x+y,x+y,y,y,0,0,0,0,0,0,0,0,0,0,x+y,y,0,0,0],[0,-x,y,0,0,0,
-x,0,-x,0,0,0,0,0,0,0,-x,-x,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y],[0,0,-x^-1*y^2+y,0,
-x,0,0,0,y,0,0,0,0,0,0,0,x^-1*y^2,y,y,x^-1*y^2,0,x^-1*y^2,x^-1*y^2,x^-1*y^2,0,
x^-1*y^2,0,0,0,0,0,0,-y,y,y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,-x,0,x+y]],[[0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0],[0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[-y,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,x,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,-x,0,0,y,0,0,0,0,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
-y,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,-y,
0,-x^2*y^-1,0,0,0,x,y,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
x,-y,0,x,0,x,0,x,0,y,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,x+y,-x,
x^2*y^-1,0,0,0,-x-x^2*y^-1,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,
0,0,0,x+y,0,0,0,0,0,0,y,0,y,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,-x^-1*y^2,0,-x,0,0,
0,y,0,0,0,0,0,0,0,0,y,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,x+y,0,y,0,0,
0,0,0,0,y,0,0,y,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0],[y,-x-y,0,0,0,-x,-x-y,0,0,0,0,y,0,
0,0,-x,-x-y,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,x,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,
0,0,0,0,x+y,0,0,0,0,0,0,0],[-y,x,x,y,0,x,x,0,-x^2*y^-1,0,0,0,0,0,0,x,x,
-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,x,0,0,0,x+y,0,0,0,0,0],[0,-x,y,0,0,0,-x,0,-x,0,0,0,0,0,0,0,
-x,-x,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,-y,0,0,0,0,x+y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,-y,0,0,0,0,0,0,0,0,x+y,0,0],[y,-x-y,y,0,0,-x,-x-y,0,-x,0,0,0,0,0,0,-x,
-x-y,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0],[0,y,y,0,x+y+x^2*y^-1,0,y,0,-x,0,0,
0,0,y,0,-x^-1*y^2-y,0,0,0,0,-x^-1*y^2-y,0,0,x^-1*y^2,-x^-1*y^2-y,x^-1*y^2,0,0,
0,x^-1*y^2,0,0,-y,0,y]],[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0],[0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x^-1*y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,-x^-1*y^2-y,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,0,0,0,0,0,0,0,
0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,
0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,
x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,-x^2*y^-1,0,0,0,0,0,0,0,0,0,0,
0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x+x^2*y^-1,0,0,0,0,0,0,0,
0,x,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,x,0,0,0,0,0,0,
0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,
0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,
0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,
0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0],[0,x,-y,0,x,0,x,0,x,0,0,0,0,x,0,0,x,x,x,x,0,
0,0,0,y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,
0,x+y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x+y,0,0,0,0,0,0,0,0],[-y,x+y,-x^-1*y^2,0,-x,x,x+y,0,x+y,0,0,-y,0,0,0,x,x+y,
x+y,y,0,0,0,-y,0,0,0,0,y,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0],[-y,x,0,0,-x-y,x,x,0,0,0,0,-y,0,-y,0,x,x,
0,0,-y,0,0,-y,0,0,0,0,0,0,y,0,0,0,0,0],[0,-x,y,0,0,0,-x,0,-x,0,0,0,0,0,0,0,-x,
-x,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0],[0,y,-x^-1*y^2,0,y,0,x+y,0,x+y,0,0,0,0,
y,0,0,x+y,x+y,y,y,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0],[y,-x,x^-1*y^2-x,-y,x,-x,-x,
0,-x-y,0,0,0,0,0,0,-x,-x,-x-y,-y,0,0,0,0,0,0,0,0,0,-y,0,0,0,y,0,0],[y,-x-y,y,
0,0,-x,-x-y,0,-x,0,0,0,0,0,0,-x,-x-y,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0],[y,
-x+y,-2*x+y,-y,x+x^2*y^-1,0,0,x,-x,-y,0,-y,-y,x,-y,0,0,-x,0,x,x,-y,-y,-y,0,-y,
0,0,-y,0,0,0,0,0,y]]]*x^0*y^0;end;
  rep:=[[f1,r],[f1,p],
        [f3,r,p,E(3)^2],[f3,p,r,E(3)^2],[f3,r,p,E(3)],[f3,p,r,E(3)],
        [f7,p,r,E(3)^2],[f7,r,p,E(3)^2],[f7,p,r,E(3)],[f7,r,p,E(3)],
        [f11,r,p,E(3)],[f11,p,r,E(3)],[f13,r,p],[f13,p,r],
	[f15,r,p,E(3)],[f15,p,r,E(3)],[f15,r,p,E(3)^2],[f15,p,r,E(3)^2],
	[f19,r,p],[f19,p,r],[f21,r,p],[f21,p,r]];
  if IsBound(rep[i]) then 
    return ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]});
  else return false;fi;
end);

CHEVIE.AddData("Representation","G34",function(i)local r,f,v,i,j,l,r1;
  r:=CHEVIE.RawData("HeckeRepresentation","G34")(List([1..6],x->[1,-1]),[],i);
  if r<>false then return r;fi;
  f:=function(i)
#   Print("calling f(",i,")\n");
    return CHEVIE.RawData("Representation","G34")(i);
  end;
  if i<=80 then
  if i=23 then return List(f(4),x->SymmetricPower(x,3));
  elif i=24 then return -f(23);
  elif i=25 then 
  r1:=
[[-6,[,[,,,,,,49],[,,,,,,,,,,,,,,,,,,,,,,,,,,,,[48,53]],[,,,,,,,,,,,,,,,,,,,,,
,,,,,,,,,,51]]],[-5,[,,[,,,,,,,,,,,,50]]],[-3,[[,,,,,,[53,54],,,,,,,,,,,,,,,,,
,,,,,,,,,,,,,,,,,,,53,,56],[,,56,,49,,,,,49,,,56,56,,56,,,,,49,,47,,56,,49,,,,
,[50,56],,,,,,49,,,[50,53,56],,49],[[48,51,53],,,,51,,[51,53],,,[51,53],[54,
55],[51,55],[48,53],55,51,,[48,53],[48,51,53],,,,51,,,,[48,53],[51,54,55],,
[50,51],[48,51,53],,54,,,,,53,,,[48,51,53],54,,53,,[49,55],[48,53]],[,,,,,,
[49,51],,,,56,,,56,,,,,,,,,51,,,,56,,,,56,[48,55,56],,,,51,,,,,[48,56]],[,,54,
54,,,,,,,,[50,54],,,,54,,,,,,47,,,,,,,,,,,55,,53,54,,53,54],[56,,[47,56],47,
[50,53],56,[49,50,53,54],,,[50,53,54],[52,56],47,,56,56,47,[48,52],56,,,53,56,
,54,47,[48,52],[50,52,53],56,,,52,,,,,54,,53,56,,,,[49,56],56]]],[-2,[[,,,,,,,
,,,56,56,,56,,,,,56,,,,,,,,,,,,,,,53,,,,,,,,54,,56],[,,,,,,,,,54],[50,,,,,,,
50,,50,49,49,,49,,,,50,49,,,50,,,,50,,,,50,,,,,,,,,,,,,,49],[,,,,,,,51,,[47,
51],,,,,,,,,51,,,,,,,,,,,,55,,,,,,,,,,,[49,55],51],[,,,,,,,,,,,,,,,,,,,,,,,,,,
,,,,,,,,,,,,,,,,,,,,54]]],[-1,[[,18,56,56,56,,[27,37],28,[30,32,56],54,[41,
46],,54,[29,45],15,16,,2,[32,40],,21,22,,24,25,,[7,41,46],[8,56],,9,[41,43],
32,,[39,54],35,36,,38,[34,56],19,,[44,53],[31,37,54],42,46,45,47,55,[52,53,54,
56],50,51,49,53,54,48,56],[1,,[3,7],2,,6,,,,[2,21],11,8,[7,13],,,7,,18,,,[2,
10],,,24,,,27,28,29,,31,,,,,36,,8,,,,,,,45,,54,[50,56],49,50,51,,49,54,55,56],
[[2,17,24,39],[1,24,45,50],[17,24,34,36,39,44,49],[20,29,49],[20,27,49],[8,26,
36,44,50],[29,45],[6,36,45],[9,20,49],29,[14,23,26,42],[29,33],[24,34,36,44],
[11,33,37],[15,17,24,50],[16,24,34,39],[39,50],[17,24],[19,33],,[20,21],[22,
26,36],45,20,[25,36,42,44,50],44,[5,14,23],[26,36,49,50],,30,[14,42,43,50],
[32,37],,,35,33,41,[33,38],[17,49],[40,50],37,,[26,31,44,45],26,23,,47,48,49,
50,,[50,53,56],53,54,55,[49,52]],[1,51,,4,,6,27,,51,[17,49,55],43,12,[20,49,
55],,20,[16,20],,,,,21,33,,17,[25,33],,7,,32,,33,,,[20,34,49,55],,26,[32,45,
46],38,39,,,[33,42],[11,46,49],44,45,46,47,48,49,,51,54,53,[47,48,49,51,52,
55],55,56],[[3,31],,[1,25,45],[5,25],4,35,,[35,46],30,10,28,[25,38,41,43],[13,
31,45],14,16,[15,25],39,31,41,42,21,35,,24,25,,28,35,31,[9,40],35,41,42,42,,,
37,,[17,44],40,41,42,35,44,28,8,50,,49,50,54,52,53,54,,56],[,23,[27,35],,,,23,
23,[32,37],43,[29,45],,[27,35],[7,41,46],,35,,29,[32,37],,,,23,,35,,[29,45],
29,29,41,29,32,,,35,,37,,,41,41,,[10,23],,45,46,47,48,49,50,51,52,53,54,55,
56]]],[-1/3,[,[,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,23,,,,,,41],,,[,,
,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,[22,25,38],,,,,,,,33]]],[1/3,[,[,,
,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,32,,,,37],,[,,,,,,,,,,,,,,,,,,,,,
,,,,,,,,,,,,,,,,,,,,,,,,,,,,35],[,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
,,[26,44],,,36,,,,42]]],[1,[[[4,46,54],[29,54],[5,54],[1,45,54],[3,54],[12,46,
56],[29,45],29,[41,53,54],[13,45],[14,23],[6,45],[10,46],[11,37],,,[20,53,56],
[23,56],41,[17,53,56],,,29,,,33,23,[23,54],23,[32,37,56],[23,54],,26,56,,,41,,
54,[32,37,53,54],37,,[29,56],53,,,,,,,,[53,54,56]],[[2,54],2,,15,[7,16,54],8,
7,8,[17,49],7,,22,[2,54],25,[2,4],[5,54],[9,49],[2,54],26,[34,49],7,[8,12],,,
14,19,7,8,,[39,54],8,,42,[20,49],46,,,43,[30,54],[44,49],,33,[8,38],[40,49],,
35,,,,,,[49,50,54,56],[50,56]],[[20,23],20,[7,14],[17,18,24,34],[11,24,34,36,
39,42,50],[23,33,49],[3,11,24,34,36,37,42],33,[24,39],[11,13,17,24,36,37,39,
42],[41,46],[26,28,36,42],[10,14,20,23],[29,44,45],20,50,49,[4,46,49],[36,44],
[34,49],[17,34,39],33,,[17,24,34,39],,,[24,36,39,41,44,46],[12,46],46,[17,24,
34,49],[33,44,46],41,42,[20,49],,[26,36,42,44],,[26,42,44],50,[26,36,42],,33,
[11,37,42,49,50],,,29,,,,,[48,50,51,53,55],49,,,,[50,53]],[[17,47,49,51,55],
[9,49,55],[10,17,49,55],[20,49,55],[13,20,45,47,49,51,55],26,,19,[2,49,55],3,
[26,46],33,[5,45,47,51],[31,33],[17,24],[17,47,51],17,[30,47],8,20,,[26,36,
51],[32,37],[15,20],26,26,,[40,49,55],41,[18,47],[14,49],[32,45,46],33,,,[22,
33],23,,[17,47,49,51,55],[28,49,55],[29,32,45,46],,26,26,,,,,,,,[47,48,49,51,
55]],[[25,28],[7,14,25],,,25,[25,28,38],[2,14,25],[14,25,38,43],40,,[6,29,45],
[23,35],28,,25,,44,[6,25,27],[32,40],34,,25,[12,14,43],,,44,[6,18,25,45],[6,
25,38],[6,11],,[6,25,38,45],[19,40],,20,38,,,35,,,,,[14,25,38,41,43],,31,[41,
43],,53,,,50],[[6,45],8,11,[12,46],[7,14,35],[1,45],[7,35,41,46],2,19,[7,35,
46],[3,27,37],[4,46],[31,45],[5,23],[22,35],25,26,28,9,33,38,[15,35],,36,16,
17,[27,35,37],18,,[32,40],[13,27,37],,20,42,,24,,21,44,[30,32],,34,[7,41],
39]]],[2,[[56,56,,,,54,,54,,,,54,,,,,54,54,[53,54],54,,,,,,[53,56],,,,[53,54],
56,,[53,56],,,,,,53,56,,56,,54],[,54,,,,54,,,54,,,,,54,54,,54,,49,,,,,,54,49,,
54,,49,54,,49,,,,,,49,54,,49,,54],[49,49,,,,,,,50,,,,,50,,,,,,,24,,,,,49,,,,,
49,,49,,,,,36,,49,,49,,50],[,47,,,,[47,49,51,55],,[49,55],47,,55,[49,55],,[47,
51,55],[47,51],,[47,49,51,55],[49,55],[49,55],[49,55],,,,,[47,51],,,[47,51],,
[49,55],[47,51],,,,,,,,,[47,51],,,55,[47,49,51,55]],[,,,,,,,,,,,,,,,,,,,,,,,,,
,,,,,,,,,,,,,,,,,,,,,,54]]],[3,[[,,,,,,,,,,,,,53,,,,,,,,,[54,56],,,,54,,[54,
56],,,,,,,,[53,54],,,,[53,54],,,,,56],[,,49,,56,,,,,,,,49,49,,49,,,,55,,,54,,
49,,56,,,,,48,55,55,,,[49,50,52,54,56],[50,56],,,49,55,[50,56]],[55,55,51,,,
55,55,51,[48,51,53],,,,55,53,,51,,,[48,51,53],55,,,[49,51],,51,,,,49,,,[48,50,
55],55,55,[48,50,53,55],50,54,50,[48,53],,53,55,51,[48,53],[48,50,51,53],[49,
51,55]],[,,56,,,,56,,,56,,,,,,,,,,,,,[47,49,55],,,,[49,51],,[49,55],,,,,,50,,
[47,48,49,51,56],,,,49,,56],[54,54,,,54,50,54,50,,,,,,,54,,54,,,,,[50,53],54,,
,[48,53],,50,,,50,,,,,[50,51],,,,,,,50],[[47,54],47,[50,53,54],56,47,[47,54],
[47,56],47,,,54,56,[50,53],[49,54],[47,54],[50,53,54],54,47,,[49,55],56,[47,
54],,[50,56],[50,53,54],54,47,47,,56,47,,[49,55],55,,[50,56],,56,[48,53,54],
56,,55,47,[48,53,54]]]],[4,[[,,,,,,,56,,56,,,,,,,,,,,,,,,,54,,,,,,,54],[,,,,,,
,54,,,,,,,,,,,54,,,54,,,,54,,,,,,,,,,,,,,,,,54],[,,,,,,,49,,49,,,,,,,,,50],[,,
,,,,,47,,,,,,,,,,51,47,,,47,,,,[47,49,51,55],,,,51,,,[49,55],,,,,,,,,,47]]],
[5,[[,,,,,,,,,,54,,,54],,,[,,,,,,,,,,49,,,49]]],[6,[,[,,,,,,56,,,56],[,,,,,,,
55,,,,,,,,,,,,,,,55,,,,,,,,,[51,53],,,51,,,,,,,,55],[,,,,,,,,,,51,,,,,,,,,,,,,
,,,,,51,,,,,,,,55],[,,,,,54,,54,,,54,,,,,,,54,,,,54,,,,54,54,54,54,,54,,,,,,,,
,,,,54],[,,,,,,,,,56]]],[7,[[,,,,,,,,,,,,56],,[,,,,,,,,,,,,49]]]];
    r:=List([1..6],i->List([1..56],i->[1..56]*0));
    for v in r1 do for i in [1..6] do
      if IsBound(v[2][i]) then for j in [1..56] do
	  if IsBound(v[2][i][j]) then l:=v[2][i][j];
	    if IsInt(l) then r[i][j][l]:=v[1];else r[i][j]{l}:=l*0+v[1];fi;
	  fi;
	od;
      fi;
    od;od;
    return r;
  elif i=26 then return -f(25);
# elif i=27 then #missing#
# elif i=28 then return -f(27);
  elif i=29 then return List(f(4),x->SchurFunctor(x,[2,1]));
  elif i=30 then return ComplexConjugate(f(29));
  elif i=31 then return -f(30);
  elif i=32 then return -f(29);
  elif i=33 then return -f(36);
  elif i=34 then return List(f(3),x->SchurFunctor(x,[2,1,1,1]));
  elif i=35 then return -f(34);
  elif i=36 then return ComplexConjugate(f(34));
# elif i=37 then #missing#
# elif i=38 then return -f(37);
  elif i=39 then return List(f(5),x->SchurFunctor(x,[2,2]));
# elif i=40 then #missing#
  elif i=41 then return -f(39);
# elif i=42 then return -f(40);
# elif i=43 then return ComplexConjugate(f(40));
  elif i=44 then return -f(45);
  elif i=45 then return ComplexConjugate(f(39));
# elif i=46 then return -f(43);
  elif i=47 then return List(f(10),x->ExteriorPower(x,2));
  elif i=48 then return -f(47);
  elif i=49 then return ComplexConjugate(f(47));
  elif i=50 then return -f(49);
# elif i=51 then #missing#
# elif i=52 then return -f(51);
# elif i=53 then #missing#
# elif i=54 then return -f(53);
# elif i=55 then return ComplexConjugate(f(53));
# elif i=56 then return -f(55);
  elif i=57 then return Zip(f(3),f(14),KroneckerMatrix);
  elif i=58 then return -f(57);
  elif i=59 then return ComplexConjugate(f(57));
  elif i=60 then return -f(59);
# elif i=61 then #missing#
# elif i=62 then #missing#
# elif i=63 then return -f(62);
# elif i=64 then #missing#
# elif i=65 then return -f(64);
  elif i=66 then return -f(67);
  elif i=67 then return List(f(13),x->ExteriorPower(x,2));
  elif i=68 then return List(f(17),x->ExteriorPower(x,2));
  elif i=69 then return -f(68);
  elif i=70 then return -f(71);
  elif i=71 then return ComplexConjugate(f(68));
  elif i=72 then return Zip(f(3),f(22),KroneckerMatrix);
  elif i=73 then return -f(72);
  elif i=74 then return ComplexConjugate(f(72));
  elif i=75 then return -f(74);
# elif i=76 then #missing#
# elif i=77 then return ComplexConjugate(f(76));
# elif i=78 then return -f(76);
# elif i=79 then return -f(77);
# elif i=80 then #missing#
# elif i=81 then return -f(80);
  else return false;
  fi;
  fi;
  if i>81 then
# if i=82 then #missing#
# elif i=83 then return -f(82);
    if i=84 then return Zip(f(7),f(13),KroneckerMatrix);
    elif i=85 then return -f(84);
    elif i=86 then return ComplexConjugate(f(84));
    elif i=87 then return -f(86);
    elif i=88 then return Zip(f(5),f(25),KroneckerMatrix);
    elif i=89 then return -f(88);
    elif i=90 then return ComplexConjugate(f(88));
    elif i=91 then return -f(90);
    elif i=92 then return List(f(5),x->SchurFunctor(x,[3,1,1]));
    elif i=93 then return -f(94);
    elif i=94 then return ComplexConjugate(f(92));
    elif i=95 then return -f(92);
#   elif i=96 then #missing#
#   elif i=97 then return -f(96);
#   elif i=98 then return ComplexConjugate(f(96));
#   elif i=99 then return -f(98);
#   elif i=100 then #missing#
#   elif i=101 then return -f(100);
#   elif i=102 then return ComplexConjugate(f(100));
#   elif i=103 then return -f(102);
#   elif i=104 then #missing#
#   elif i=105 then return -f(104);
    elif i=106 then return Zip(f(11),f(13),KroneckerMatrix);
    elif i=107 then return List(f(5),x->SchurFunctor(x,[3,2]));
    elif i=108 then return ComplexConjugate(f(110));
    elif i=109 then return -f(108);
    elif i=110 then return -f(107);
#   elif i=138 then return Zip(f(5),f(51),KroneckerMatrix);
#   elif i=139 then return ComplexConjugate(f(138));
    elif i=154 then return Zip(f(9),f(25),KroneckerMatrix);
    elif i=155 then return -f(156);
    elif i=156 then return ComplexConjugate(f(154));
    elif i=157 then return -f(154);
    else return false;
    fi;
  fi;
end);

CHEVIE.AddData("factors","G34",
[[1,0],[1,126],[1,5,1,11,1,17,1,23,1,29,1,41],[1,89,1,95,1,101,1,107,1,113,1,
125],[1,1,1,13,1,19,1,25,1,31,1,37],[1,85,1,97,1,103,1,109,1,115,1,121],[1,58,
1,64,2,70,2,76,2,82,2,88,2,94,1,100,1,106,1,112],[1,16,1,22,2,28,2,34,2,40,2,
46,2,52,1,58,1,64,1,70],[1,56,1,62,1,68,2,74,2,80,2,86,2,92,2,98,1,104,1,110],
[1,14,1,20,1,26,2,32,2,38,2,44,2,50,2,56,1,62,1,68],[1,33,1,39,2,45,2,51,3,57,
2,63,3,69,2,75,2,81,1,87,1,93],[1,33,1,39,2,45,2,51,3,57,2,63,3,69,2,75,2,81,
1,87,1,93],[1,60,1,66,2,72,2,78,3,84,3,90,3,96,2,102,2,108,1,114,1,120],[1,6,
1,12,2,18,2,24,3,30,3,36,3,42,2,48,2,54,1,60,1,66],[1,4,2,10,2,16,3,22,3,28,3,
34,3,40,2,46,1,52,1,58],[1,70,2,76,2,82,3,88,3,94,3,100,3,106,2,112,1,118,1,
124],[1,2,1,8,2,14,3,20,3,26,3,32,3,38,2,44,2,50,1,56],[1,68,1,74,2,80,3,86,3,
92,3,98,3,104,2,110,2,116,1,122],[1,60,2,66,3,72,4,78,5,84,5,90,5,96,4,102,3,
108,2,114,1,120],[1,6,2,12,3,18,4,24,5,30,5,36,5,42,4,48,3,54,2,60,1,66],[1,
36,1,42,2,48,3,54,4,60,4,66,5,72,4,78,4,84,3,90,2,96,1,102,1,108],[1,18,1,24,
2,30,3,36,4,42,4,48,5,54,4,60,4,66,3,72,2,78,1,84,1,90],[1,57,2,63,4,69,6,75,
7,81,8,87,8,93,7,99,6,105,4,111,2,117,1,123],[1,3,2,9,4,15,6,21,7,27,8,33,8,
39,7,45,6,51,4,57,2,63,1,69],[1,45,2,51,3,57,5,63,6,69,7,75,8,81,7,87,6,93,5,
99,3,105,2,111,1,117],[1,9,2,15,3,21,5,27,6,33,7,39,8,45,7,51,6,57,5,63,3,69,
2,75,1,81],[1,45,2,51,4,57,6,63,8,69,9,75,10,81,9,87,8,93,6,99,4,105,2,111,1,
117],[1,9,2,15,4,21,6,27,8,33,9,39,10,45,9,51,8,57,6,63,4,69,2,75,1,81],[1,45,
2,51,4,57,6,63,8,69,9,75,10,81,9,87,8,93,6,99,4,105,2,111,1,117],[1,45,2,51,4,
57,6,63,8,69,9,75,10,81,9,87,8,93,6,99,4,105,2,111,1,117],[1,9,2,15,4,21,6,27,
8,33,9,39,10,45,9,51,8,57,6,63,4,69,2,75,1,81],[1,9,2,15,4,21,6,27,8,33,9,39,
10,45,9,51,8,57,6,63,4,69,2,75,1,81],[2,17,3,23,6,29,8,35,10,41,11,47,12,53,
10,59,9,65,6,71,4,77,2,83,1,89],[1,37,2,43,4,49,6,55,9,61,10,67,12,73,11,79,
10,85,8,91,6,97,3,103,2,109],[1,13,2,19,4,25,6,31,9,37,10,43,12,49,11,55,10,
61,8,67,6,73,3,79,2,85],[2,41,3,47,6,53,8,59,10,65,11,71,12,77,10,83,9,89,6,
95,4,101,2,107,1,113],[1,6,3,12,5,18,8,24,10,30,12,36,12,42,12,48,10,54,8,60,
5,66,3,72,1,78],[1,48,3,54,5,60,8,66,10,72,12,78,12,84,12,90,10,96,8,102,5,
108,3,114,1,120],[1,10,3,16,5,22,8,28,11,34,13,40,14,46,14,52,12,58,10,64,7,
70,4,76,2,82,1,88],[1,46,2,52,5,58,8,64,11,70,13,76,15,82,14,88,13,94,10,100,
7,106,4,112,2,118],[1,40,3,46,5,52,8,58,11,64,13,70,14,76,14,82,12,88,10,94,7,
100,4,106,2,112,1,118],[1,4,2,10,5,16,8,22,11,28,13,34,15,40,14,46,13,52,10,
58,7,64,4,70,2,76],[2,50,4,56,7,62,10,68,13,74,14,80,15,86,13,92,11,98,8,104,
5,110,2,116,1,122],[1,38,2,44,4,50,7,56,10,62,12,68,14,74,14,80,13,86,11,92,8,
98,5,104,3,110,1,116],[1,8,2,14,4,20,7,26,10,32,12,38,14,44,14,50,13,56,11,62,
8,68,5,74,3,80,1,86],[2,8,4,14,7,20,10,26,13,32,14,38,15,44,13,50,11,56,8,62,
5,68,2,74,1,80],[1,22,3,28,5,34,8,40,11,46,13,52,14,58,14,64,12,70,10,76,7,82,
4,88,2,94,1,100],[1,28,3,34,5,40,8,46,11,52,13,58,14,64,14,70,12,76,10,82,7,
88,4,94,2,100,1,106],[1,20,2,26,4,32,7,38,10,44,12,50,14,56,14,62,13,68,11,74,
8,80,5,86,3,92,1,98],[1,26,2,32,4,38,7,44,10,50,12,56,14,62,14,68,13,74,11,80,
8,86,5,92,3,98,1,104],[1,21,2,27,4,33,7,39,10,45,13,51,15,57,16,63,15,69,13,
75,10,81,7,87,4,93,2,99,1,105],[1,21,2,27,4,33,7,39,10,45,13,51,15,57,16,63,
15,69,13,75,10,81,7,87,4,93,2,99,1,105],[1,5,3,11,6,17,10,23,13,29,16,35,17,
41,16,47,14,53,11,59,7,65,4,71,2,77],[1,47,3,53,6,59,10,65,13,71,16,77,17,83,
16,89,14,95,11,101,7,107,4,113,2,119],[2,7,4,13,7,19,11,25,14,31,16,37,17,43,
16,49,13,55,10,61,6,67,3,73,1,79],[2,49,4,55,7,61,11,67,14,73,16,79,17,85,16,
91,13,97,10,103,6,109,3,115,1,121],[1,5,2,11,5,17,8,23,12,29,15,35,17,41,17,
47,16,53,13,59,10,65,6,71,3,77,1,83],[1,41,2,47,5,53,8,59,12,65,15,71,17,77,
17,83,16,89,13,95,10,101,6,107,3,113,1,119],[1,7,3,13,6,19,10,25,13,31,16,37,
17,43,17,49,15,55,12,61,8,67,5,73,2,79,1,85],[1,43,3,49,6,55,10,61,13,67,16,
73,17,79,17,85,15,91,12,97,8,103,5,109,2,115,1,121],[1,21,2,27,5,33,8,39,12,
45,15,51,18,57,18,63,18,69,15,75,12,81,8,87,5,93,2,99,1,105],[1,30,2,36,5,42,
8,48,12,54,15,60,18,66,18,72,18,78,15,84,12,90,8,96,5,102,2,108,1,114],[1,12,
2,18,5,24,8,30,12,36,15,42,18,48,18,54,18,60,15,66,12,72,8,78,5,84,2,90,1,96],
[1,24,3,30,6,36,11,42,16,48,21,54,24,60,25,66,24,72,21,78,16,84,11,90,6,96,3,
102,1,108],[1,18,3,24,6,30,11,36,16,42,21,48,24,54,25,60,24,66,21,72,16,78,11,
84,6,90,3,96,1,102],[1,30,3,36,7,42,12,48,18,54,23,60,27,66,28,72,27,78,23,84,
18,90,12,96,7,102,3,108,1,114],[1,12,3,18,7,24,12,30,18,36,23,42,27,48,28,54,
27,60,23,66,18,72,12,78,7,84,3,90,1,96],[2,10,5,16,10,22,16,28,22,34,26,40,29,
46,28,52,25,58,20,64,14,70,8,76,4,82,1,88],[2,40,5,46,10,52,16,58,22,64,26,70,
29,76,28,82,25,88,20,94,14,100,8,106,4,112,1,118],[1,38,4,44,8,50,14,56,20,62,
25,68,28,74,29,80,26,86,22,92,16,98,10,104,5,110,2,116],[1,8,4,14,8,20,14,26,
20,32,25,38,28,44,29,50,26,56,22,62,16,68,10,74,5,80,2,86],[2,17,4,23,9,29,14,
35,20,41,24,47,28,53,27,59,26,65,21,71,16,77,10,83,6,89,2,95,1,101],[2,29,4,
35,9,41,14,47,20,53,24,59,28,65,27,71,26,77,21,83,16,89,10,95,6,101,2,107,1,
113],[1,13,2,19,6,25,10,31,16,37,21,43,26,49,27,55,28,61,24,67,20,73,14,79,9,
85,4,91,2,97],[1,25,2,31,6,37,10,43,16,49,21,55,26,61,27,67,28,73,24,79,20,85,
14,91,9,97,4,103,2,109],[1,30,4,36,9,42,16,48,24,54,31,60,36,66,38,72,36,78,
31,84,24,90,16,96,9,102,4,108,1,114],[1,30,4,36,9,42,16,48,24,54,31,60,36,66,
38,72,36,78,31,84,24,90,16,96,9,102,4,108,1,114],[1,12,4,18,9,24,16,30,24,36,
31,42,36,48,38,54,36,60,31,66,24,72,16,78,9,84,4,90,1,96],[1,12,4,18,9,24,16,
30,24,36,31,42,36,48,38,54,36,60,31,66,24,72,16,78,9,84,4,90,1,96],[1,36,4,42,
10,48,18,54,27,60,35,66,41,72,43,78,41,84,35,90,27,96,18,102,10,108,4,114,1,
120],[1,6,4,12,10,18,18,24,27,30,35,36,41,42,43,48,41,54,35,60,27,66,18,72,10,
78,4,84,1,90],[2,24,5,30,11,36,18,42,27,48,34,54,40,60,41,66,40,72,34,78,27,
84,18,90,11,96,5,102,2,108],[2,18,5,24,11,30,18,36,27,42,34,48,40,54,41,60,40,
66,34,72,27,78,18,84,11,90,5,96,2,102],[1,10,3,16,8,22,15,28,24,34,32,40,39,
46,42,52,42,58,37,64,30,70,21,76,13,82,6,88,2,94],[1,28,3,34,8,40,15,46,24,52,
32,58,39,64,42,70,42,76,37,82,30,88,21,94,13,100,6,106,2,112],[2,14,6,20,13,
26,21,32,30,38,37,44,42,50,42,56,39,62,32,68,24,74,15,80,8,86,3,92,1,98],[2,
32,6,38,13,44,21,50,30,56,37,62,42,68,42,74,39,80,32,86,24,92,15,98,8,104,3,
110,1,116],[2,34,6,40,12,46,21,52,30,58,38,64,44,70,45,76,42,82,36,88,27,94,
18,100,10,106,4,112,1,118],[2,10,6,16,12,22,21,28,30,34,38,40,44,46,45,52,42,
58,36,64,27,70,18,76,10,82,4,88,1,94],[1,32,4,38,10,44,18,50,27,56,36,62,42,
68,45,74,44,80,38,86,30,92,21,98,12,104,6,110,2,116],[1,8,4,14,10,20,18,26,27,
32,36,38,42,44,45,50,44,56,38,62,30,68,21,74,12,80,6,86,2,92],[1,17,4,23,10,
29,18,35,27,41,36,47,42,53,45,59,44,65,38,71,30,77,21,83,12,89,6,95,2,101],[2,
25,6,31,12,37,21,43,30,49,38,55,44,61,45,67,42,73,36,79,27,85,18,91,10,97,4,
103,1,109],[2,19,6,25,12,31,21,37,30,43,38,49,44,55,45,61,42,67,36,73,27,79,
18,85,10,91,4,97,1,103],[1,23,4,29,10,35,18,41,27,47,36,53,42,59,45,65,44,71,
38,77,30,83,21,89,12,95,6,101,2,107],[2,11,6,17,13,23,23,29,33,35,43,41,50,47,
52,53,49,59,42,65,32,71,21,77,12,83,5,89,1,95],[1,29,3,35,9,41,18,47,28,53,39,
59,47,65,51,71,51,77,46,83,37,89,27,95,16,101,8,107,3,113],[3,13,8,19,16,25,
27,31,37,37,46,43,51,49,51,55,47,61,39,67,28,73,18,79,9,85,3,91,1,97],[1,31,5,
37,12,43,21,49,32,55,42,61,49,67,52,73,50,79,43,85,33,91,23,97,13,103,6,109,2,
115],[3,34,8,40,16,46,27,52,37,58,46,64,51,70,51,76,47,82,39,88,28,94,18,100,
9,106,3,112,1,118],[1,10,5,16,12,22,21,28,32,34,42,40,49,46,52,52,50,58,43,64,
33,70,23,76,13,82,6,88,2,94],[2,32,6,38,13,44,23,50,33,56,43,62,50,68,52,74,
49,80,42,86,32,92,21,98,12,104,5,110,1,116],[1,8,3,14,9,20,18,26,28,32,39,38,
47,44,51,50,51,56,46,62,37,68,27,74,16,80,8,86,3,92],[2,30,6,36,14,42,24,48,
36,54,46,60,54,66,56,72,54,78,46,84,36,90,24,96,14,102,6,108,2,114],[2,12,6,
18,14,24,24,30,36,36,46,42,54,48,56,54,54,60,46,66,36,72,24,78,14,84,6,90,2,
96],[2,21,6,27,14,33,24,39,36,45,46,51,54,57,56,63,54,69,46,75,36,81,24,87,14,
93,6,99,2,105],[3,11,8,17,17,23,28,29,40,35,49,41,56,47,56,53,52,59,43,65,32,
71,20,77,11,83,4,89,1,95],[1,31,4,37,11,43,20,49,32,55,43,61,52,67,56,73,56,
79,49,85,40,91,28,97,17,103,8,109,3,115],[1,7,4,13,11,19,20,25,32,31,43,37,52,
43,56,49,56,55,49,61,40,67,28,73,17,79,8,85,3,91],[3,35,8,41,17,47,28,53,40,
59,49,65,56,71,56,77,52,83,43,89,32,95,20,101,11,107,4,113,1,119],[1,16,5,22,
11,28,21,34,32,40,43,46,51,52,56,58,54,64,49,70,39,76,28,82,17,88,9,94,3,100,
1,106],[1,22,5,28,11,34,21,40,32,46,43,52,51,58,56,64,54,70,49,76,39,82,28,88,
17,94,9,100,3,106,1,112],[1,14,3,20,9,26,17,32,28,38,39,44,49,50,54,56,56,62,
51,68,43,74,32,80,21,86,11,92,5,98,1,104],[1,20,3,26,9,32,17,38,28,44,39,50,
49,56,54,62,56,68,51,74,43,80,32,86,21,92,11,98,5,104,1,110],[2,33,7,39,16,45,
29,51,43,57,56,63,65,69,68,75,65,81,56,87,43,93,29,99,16,105,7,111,2,117],[2,
9,7,15,16,21,29,27,43,33,56,39,65,45,68,51,65,57,56,63,43,69,29,75,16,81,7,87,
2,93],[1,21,5,27,12,33,23,39,36,45,49,51,60,57,66,63,66,69,60,75,49,81,36,87,
23,93,12,99,5,105,1,111],[1,15,5,21,12,27,23,33,36,39,49,45,60,51,66,57,66,63,
60,69,49,75,36,81,23,87,12,93,5,99,1,105],[1,17,4,23,11,29,22,35,36,41,50,47,
63,53,70,59,72,65,66,71,56,77,41,83,27,89,14,95,6,101,1,107],[1,19,6,25,14,31,
27,37,41,43,56,49,66,55,72,61,70,67,63,73,50,79,36,85,22,91,11,97,4,103,1,
109],[3,21,8,27,18,33,31,39,46,45,59,51,69,57,72,63,69,69,59,75,46,81,31,87,
18,93,8,99,3,105],[3,21,8,27,18,33,31,39,46,45,59,51,69,57,72,63,69,69,59,75,
46,81,31,87,18,93,8,99,3,105],[1,27,5,33,13,39,25,45,40,51,55,57,67,63,74,69,
74,75,67,81,55,87,40,93,25,99,13,105,5,111,1,117],[1,9,5,15,13,21,25,27,40,33,
55,39,67,45,74,51,74,57,67,63,55,69,40,75,25,81,13,87,5,93,1,99],[1,18,5,24,
13,30,25,36,40,42,55,48,67,54,74,60,74,66,67,72,55,78,40,84,25,90,13,96,5,102,
1,108],[1,18,5,24,13,30,25,36,40,42,55,48,67,54,74,60,74,66,67,72,55,78,40,84,
25,90,13,96,5,102,1,108],[1,18,5,24,13,30,25,36,40,42,55,48,67,54,74,60,74,66,
67,72,55,78,40,84,25,90,13,96,5,102,1,108],[3,27,9,33,21,39,36,45,54,51,69,57,
81,63,84,69,81,75,69,81,54,87,36,93,21,99,9,105,3,111],[3,15,9,21,21,27,36,33,
54,39,69,45,81,51,84,57,81,63,69,69,54,75,36,81,21,87,9,93,3,99],[2,16,7,22,
17,28,31,34,48,40,64,46,77,52,83,58,82,64,73,70,59,76,42,82,26,88,13,94,5,100,
1,106],[2,22,7,28,17,34,31,40,48,46,64,52,77,58,83,64,82,70,73,76,59,82,42,88,
26,94,13,100,5,106,1,112],[1,14,5,20,13,26,26,32,42,38,59,44,73,50,82,56,83,
62,77,68,64,74,48,80,31,86,17,92,7,98,2,104],[1,20,5,26,13,32,26,38,42,44,59,
50,73,56,82,62,83,68,77,74,64,80,48,86,31,92,17,98,7,104,2,110],[1,11,5,17,13,
23,26,29,42,35,59,41,73,47,82,53,83,59,77,65,64,71,48,77,31,83,17,89,7,95,2,
101],[2,25,7,31,17,37,31,43,48,49,64,55,77,61,83,67,82,73,73,79,59,85,42,91,
26,97,13,103,5,109,1,115],[2,13,7,19,17,25,31,31,48,37,64,43,77,49,83,55,82,
61,73,67,59,73,42,79,26,85,13,91,5,97,1,103],[1,23,5,29,13,35,26,41,42,47,59,
53,73,59,82,65,83,71,77,77,64,83,48,89,31,95,17,101,7,107,2,113],[1,16,5,22,
13,28,27,34,45,40,64,46,81,52,92,58,95,64,89,70,76,76,58,82,39,88,22,94,10,
100,3,106],[3,20,10,26,22,32,39,38,58,44,76,50,89,56,95,62,92,68,81,74,64,80,
45,86,27,92,13,98,5,104,1,110],[1,24,5,30,15,36,30,42,49,48,68,54,85,60,95,66,
97,72,89,78,75,84,55,90,36,96,19,102,8,108,2,114],[2,12,8,18,19,24,36,30,55,
36,75,42,89,48,97,54,95,60,85,66,68,72,49,78,30,84,15,90,5,96,1,102],[4,28,11,
34,24,40,42,46,62,52,80,58,93,64,97,70,93,76,80,82,62,88,42,94,24,100,11,106,
4,112],[1,10,5,16,15,22,30,28,49,34,68,40,85,46,95,52,97,58,89,64,75,70,55,76,
36,82,19,88,8,94,2,100],[2,26,8,32,19,38,36,44,55,50,75,56,89,62,97,68,95,74,
85,80,68,86,49,92,30,98,15,104,5,110,1,116],[4,14,11,20,24,26,42,32,62,38,80,
44,93,50,97,56,93,62,80,68,62,74,42,80,24,86,11,92,4,98],[2,16,8,22,20,28,37,
34,58,40,77,46,93,52,100,58,99,64,88,70,71,76,50,82,31,88,15,94,6,100,1,106],
[2,22,8,28,20,34,37,40,58,46,77,52,93,58,100,64,99,70,88,76,71,82,50,88,31,94,
15,100,6,106,1,112],[1,14,6,20,15,26,31,32,50,38,71,44,88,50,99,56,100,62,93,
68,77,74,58,80,37,86,20,92,8,98,2,104],[1,20,6,26,15,32,31,38,50,44,71,50,88,
56,99,62,100,68,93,74,77,80,58,86,37,92,20,98,8,104,2,110],[3,17,11,23,25,29,
45,35,68,41,89,47,105,53,112,59,108,65,95,71,75,77,52,83,31,89,15,95,5,101,1,
107],[1,19,5,25,15,31,31,37,52,43,75,49,95,55,108,61,112,67,105,73,89,79,68,
85,45,91,25,97,11,103,3,109],[1,13,5,19,15,25,31,31,52,37,75,43,95,49,108,55,
112,61,105,67,89,73,68,79,45,85,25,91,11,97,3,103],[3,23,11,29,25,35,45,41,68,
47,89,53,105,59,112,65,108,71,95,77,75,83,52,89,31,95,15,101,5,107,1,113],[1,
11,6,17,17,23,34,29,56,35,79,41,98,47,110,53,112,59,103,65,86,71,64,77,41,83,
22,89,9,95,2,101],[2,25,9,31,22,37,41,43,64,49,86,55,103,61,112,67,110,73,98,
79,79,85,56,91,34,97,17,103,6,109,1,115],[2,13,9,19,22,25,41,31,64,37,86,43,
103,49,112,55,110,61,98,67,79,73,56,79,34,85,17,91,6,97,1,103],[1,23,6,29,17,
35,34,41,56,47,79,53,98,59,110,65,112,71,103,77,86,83,64,89,41,95,22,101,9,
107,2,113],[3,24,11,30,25,36,46,42,70,48,93,54,111,60,119,66,116,72,103,78,82,
84,58,90,35,96,17,102,6,108,1,114],[1,12,6,18,17,24,35,30,58,36,82,42,103,48,
116,54,119,60,111,66,93,72,70,78,46,84,25,90,11,96,3,102],[1,21,6,27,17,33,35,
39,58,45,82,51,103,57,116,63,119,69,111,75,93,81,70,87,46,93,25,99,11,105,3,
111],[3,15,11,21,25,27,46,33,70,39,93,45,111,51,119,57,116,63,103,69,82,75,58,
81,35,87,17,93,6,99,1,105],[3,16,10,22,25,28,46,34,72,40,96,46,116,52,125,58,
124,64,110,70,89,76,63,82,39,88,19,94,7,100,1,106],[3,22,10,28,25,34,46,40,72,
46,96,52,116,58,125,64,124,70,110,76,89,82,63,88,39,94,19,100,7,106,1,112],[1,
14,7,20,19,26,39,32,63,38,89,44,110,50,124,56,125,62,116,68,96,74,72,80,46,86,
25,92,10,98,3,104],[1,20,7,26,19,32,39,38,63,44,89,50,110,56,124,62,125,68,
116,74,96,80,72,86,46,92,25,98,10,104,3,110],[2,17,10,23,26,29,52,35,84,41,
118,47,146,53,164,59,166,65,154,71,128,77,96,83,62,89,34,95,14,101,4,107],[4,
19,14,25,34,31,62,37,96,43,128,49,154,55,166,61,164,67,146,73,118,79,84,85,52,
91,26,97,10,103,2,109],[3,18,12,24,30,30,58,36,91,42,125,48,153,54,168,60,168,
66,153,72,125,78,91,84,58,90,30,96,12,102,3,108],[1,15,6,21,20,27,43,33,74,39,
109,45,140,51,162,57,170,63,162,69,140,75,109,81,74,87,43,93,20,99,6,105,1,
111]]);

if not IsBound(CHEVIE.families) then ReadChv("unip/families");fi;

# the group <a^7, b^6, bab^-1a^-3>
# a:=AbstractGenerator("a");b:=AbstractGenerator("b");
# f42:=Group(a,b)/[a^7, b^6, b*a*b^-1*a^-3];
# F42:= OperationCosetsFpGroup(f42,Subgroup(f42,[f42.2]));
CHEVIE.families.F42:=rec( # DrinfeldDouble(F42)
name:="Q(F_{42})",
x:=[ (), (), (), (), (), (), (), (2,3,7)(4,5,6), (2,3,7)(4,5,6),
  (2,3,7)(4,5,6), (2,3,7)(4,5,6), (2,3,7)(4,5,6), (2,3,7)(4,5,6),
  (2,4,7,6,3,5), (2,4,7,6,3,5), (2,4,7,6,3,5), (2,4,7,6,3,5), (2,4,7,6,3,5),
  (2,4,7,6,3,5), (2,5,3,6,7,4), (2,5,3,6,7,4), (2,5,3,6,7,4), (2,5,3,6,7,4),
  (2,5,3,6,7,4), (2,5,3,6,7,4), (2,6)(3,4)(5,7), (2,6)(3,4)(5,7),
  (2,6)(3,4)(5,7), (2,6)(3,4)(5,7), (2,6)(3,4)(5,7), (2,6)(3,4)(5,7),
  (2,7,3)(4,6,5), (2,7,3)(4,6,5), (2,7,3)(4,6,5), (2,7,3)(4,6,5),
  (2,7,3)(4,6,5), (2,7,3)(4,6,5), (1,2,3,5,7,4,6), (1,2,3,5,7,4,6),
  (1,2,3,5,7,4,6), (1,2,3,5,7,4,6), (1,2,3,5,7,4,6), (1,2,3,5,7,4,6),
  (1,2,3,5,7,4,6) ],
y:=[ (), (2,3,7)(4,5,6), (2,4,7,6,3,5), (2,5,3,6,7,4), (2,6)(3,4)(5,7),
  (2,7,3)(4,6,5), (1,2,3,5,7,4,6), (), (2,3,7)(4,5,6), (2,4,7,6,3,5),
  (2,5,3,6,7,4), (2,6)(3,4)(5,7), (2,7,3)(4,6,5), (), (2,3,7)(4,5,6),
  (2,4,7,6,3,5), (2,5,3,6,7,4), (2,6)(3,4)(5,7), (2,7,3)(4,6,5), (),
  (2,3,7)(4,5,6), (2,4,7,6,3,5), (2,5,3,6,7,4), (2,6)(3,4)(5,7),
  (2,7,3)(4,6,5), (), (2,3,7)(4,5,6), (2,4,7,6,3,5), (2,5,3,6,7,4),
  (2,6)(3,4)(5,7), (2,7,3)(4,6,5), (), (2,3,7)(4,5,6), (2,4,7,6,3,5),
  (2,5,3,6,7,4), (2,6)(3,4)(5,7), (2,7,3)(4,6,5), (), (1,2,3,5,7,4,6),
  (1,3,7,6,2,5,4), (1,4,5,2,6,7,3), (1,5,6,3,4,2,7), (1,6,4,7,5,3,2),
  (1,7,2,4,3,6,5) ],
charLabels:=["(1,1)","(1,-1)","(1,-\\zeta_3^2)","(1,-\\zeta_3)",
"(1,\\zeta_3^2)","(1,\\zeta_3)","(1,r)","(g_6^4,1)","(g_6^4,-1)",
"(g_6^4,\\zeta_3)","(g_6^4,-\\zeta_3)","(g_6^4,\\zeta_3^2)",
"(g_6^4,-\\zeta_3^2)","(g_6,1)","(g_6,-1)","(g_6,\\zeta_3)","(g_6,-\\zeta_3)",
"(g_6,\\zeta_3^2)","(g_6,-\\zeta_3^2)","(g_6^3,1)","(g_6^3,-1)",
"(g_6^3,\\zeta_3)","(g_6^3,-\\zeta_3)","(g_6^3,\\zeta_3^2)",
"(g_6^3,-\\zeta_3^2)","(g_6^2,1)","(g_6^2,-1)","(g_6^2,\\zeta_3)",
"(g_6^2,-\\zeta_3)","(g_6^2,\\zeta_3^2)","(g_6^2,-\\zeta_3^2)","(g_6^5,1)",
"(g_6^5,-1)","(g_6^5,\\zeta_3)","(g_6^5,-\\zeta_3)","(g_6^5,\\zeta_3^2)",
"(g_6^5,-\\zeta_3^2)","(g_7,1)","(g_7,\\zeta_7)","(g_7,\\zeta_7^2)",
"(g_7,\\zeta_7^3)","(g_7,\\zeta_7^4)","(g_7,\\zeta_7^5)","(g_7,\\zeta_7^6)"],
eigenvalues:=[ 1, 1, 1, 1, 1, 1, 1, 1, 1, E(3), E(3), E(3)^2, E(3)^2, 1, -1,
  E(3), -E(3), E(3)^2, -E(3)^2, 1, -1, E(3)^2, -E(3)^2, E(3), -E(3), 1, -1,
  1, -1, 1, -1, 1, 1, E(3)^2, E(3)^2, E(3), E(3), 1, E(7), E(7)^2, E(7)^3,
  E(7)^4, E(7)^5, E(7)^6 ],
mellin:=ApplyFunc(DiagonalMat,
[[[1,1,1,1,1,1,6],[1,1,E(3)^2,E(3),E(3)^2,E(3),0],[1,-1,-E(3)^2,-E(3),
E(3)^2,E(3),0],[1,-1,-E(3),-E(3)^2,E(3),E(3)^2,0],[1,-1,-1,-1,1,1,0],[1,1,
E(3),E(3)^2,E(3),E(3)^2,0],[1,1,1,1,1,1,-1]],[[1,1,1,1,1,1],[1,1,E(3),E(3),
E(3)^2,E(3)^2],[1,-1,E(3),-E(3),E(3)^2,-E(3)^2],[1,-1,E(3)^2,-E(3)^2,E(3),
-E(3)],[1,-1,1,-1,1,-1],[1,1,E(3)^2,E(3)^2,E(3),E(3)]],[[1,1,1,1,1,1],[1,1,
E(3),E(3),E(3)^2,E(3)^2],[1,-1,E(3),-E(3),E(3)^2,-E(3)^2],[1,-1,E(3)^2,
-E(3)^2,E(3),-E(3)],[1,-1,1,-1,1,-1],[1,1,E(3)^2,E(3)^2,E(3),E(3)]],[[1,1,1,
1,1,1],[1,1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,E(3),-E(3),E(3)^2,-E(3)^2],[1,-1,
E(3)^2,-E(3)^2,E(3),-E(3)],[1,-1,1,-1,1,-1],[1,1,E(3)^2,E(3)^2,E(3),E(3)]],
[[1,1,1,1,1,1],[1,1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,E(3),-E(3),E(3)^2,
-E(3)^2],[1,-1,E(3)^2,-E(3)^2,E(3),-E(3)],[1,-1,1,-1,1,-1],[1,1,E(3)^2,
E(3)^2,E(3),E(3)]],[[1,1,1,1,1,1],[1,1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,E(3),
-E(3),E(3)^2,-E(3)^2],[1,-1,E(3)^2,-E(3)^2,E(3),-E(3)],[1,-1,1,-1,1,-1],[1,
1,E(3)^2,E(3)^2,E(3),E(3)]],[[1,1,1,1,1,1,1],[1,E(7),E(7)^2,E(7)^3,E(7)^4,
E(7)^5,E(7)^6],[1,E(7)^2,E(7)^4,E(7)^6,E(7),E(7)^3,E(7)^5],[1,E(7)^5,E(7)^3,
E(7),E(7)^6,E(7)^4,E(7)^2],[1,E(7)^3,E(7)^6,E(7)^2,E(7)^5,E(7),E(7)^4],[1,
E(7)^6,E(7)^5,E(7)^4,E(7)^3,E(7)^2,E(7)],[1,E(7)^4,E(7),E(7)^5,E(7)^2,
E(7)^6,E(7)^3]]]),
group:=Group( (1,2,3,5,7,4,6), (2,4,7,6,3,5) ),
fourierMat:=
[[1/7,1/7,1/7,1/7,1/7,1/7,6/7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,6/7,6/7,6/7,6/7,6/7,6/7,6/7],[1/7,1/7,1/7,1/7,1/7,1/7,6/7,1,1,
1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,
6/7,6/7,6/7,6/7,6/7,6/7,6/7],[1/7,1/7,1/7,1/7,1/7,1/7,6/7,E(3)^2,E(3)^2,
E(3)^2,E(3)^2,E(3)^2,E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,
-E(3),-E(3),-E(3),-E(3),-E(3),-E(3),-1,-1,-1,-1,-1,-1,E(3),E(3),E(3),E(3),
E(3),E(3),6/7,6/7,6/7,6/7,6/7,6/7,6/7],[1/7,1/7,1/7,1/7,1/7,1/7,6/7,E(3),
E(3),E(3),E(3),E(3),E(3),-E(3),-E(3),-E(3),-E(3),-E(3),-E(3),-E(3)^2,
-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-1,-1,-1,-1,-1,-1,E(3)^2,E(3)^2,
E(3)^2,E(3)^2,E(3)^2,E(3)^2,6/7,6/7,6/7,6/7,6/7,6/7,6/7],[1/7,1/7,1/7,1/7,
1/7,1/7,6/7,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,
E(3)^2,E(3)^2,E(3)^2,E(3),E(3),E(3),E(3),E(3),E(3),1,1,1,1,1,1,E(3),E(3),
E(3),E(3),E(3),E(3),6/7,6/7,6/7,6/7,6/7,6/7,6/7],[1/7,1/7,1/7,1/7,1/7,1/7,
6/7,E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3)^2,
E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,1,1,1,1,1,1,E(3)^2,E(3)^2,E(3)^2,E(3)^2,
E(3)^2,E(3)^2,6/7,6/7,6/7,6/7,6/7,6/7,6/7],[6/7,6/7,6/7,6/7,6/7,6/7,36/7,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-6/7,-6/7,-6/7,
-6/7,-6/7,-6/7,-6/7],[1,1,E(3)^2,E(3),E(3)^2,E(3),0,1,1,E(3),E(3),E(3)^2,
E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),
E(3),E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,0,0,0,0,0,0,0],[1,1,E(3)^2,
E(3),E(3)^2,E(3),0,1,1,E(3),E(3),E(3)^2,E(3)^2,-1,-1,-E(3),-E(3),-E(3)^2,
-E(3)^2,-1,-1,-E(3),-E(3),-E(3)^2,-E(3)^2,-1,-1,-E(3),-E(3),-E(3)^2,-E(3)^2,
1,1,E(3),E(3),E(3)^2,E(3)^2,0,0,0,0,0,0,0],[1,1,E(3)^2,E(3),E(3)^2,E(3),0,
E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3)^2,E(3)^2,1,1,
E(3),E(3),1,1,E(3),E(3),E(3)^2,E(3)^2,E(3)^2,E(3)^2,1,1,E(3),E(3),0,0,0,0,0,
0,0],[1,1,E(3)^2,E(3),E(3)^2,E(3),0,E(3),E(3),E(3)^2,E(3)^2,1,1,-E(3),-E(3),
-E(3)^2,-E(3)^2,-1,-1,-E(3)^2,-E(3)^2,-1,-1,-E(3),-E(3),-1,-1,-E(3),-E(3),
-E(3)^2,-E(3)^2,E(3)^2,E(3)^2,1,1,E(3),E(3),0,0,0,0,0,0,0],[1,1,E(3)^2,E(3),
E(3)^2,E(3),0,E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),E(3),E(3),
E(3),E(3)^2,E(3)^2,1,1,1,1,E(3),E(3),E(3)^2,E(3)^2,E(3),E(3),E(3)^2,E(3)^2,
1,1,0,0,0,0,0,0,0],[1,1,E(3)^2,E(3),E(3)^2,E(3),0,E(3)^2,E(3)^2,1,1,E(3),
E(3),-E(3)^2,-E(3)^2,-1,-1,-E(3),-E(3),-E(3),-E(3),-E(3)^2,-E(3)^2,-1,-1,-1,
-1,-E(3),-E(3),-E(3)^2,-E(3)^2,E(3),E(3),E(3)^2,E(3)^2,1,1,0,0,0,0,0,0,0],
[1,-1,-E(3)^2,-E(3),E(3)^2,E(3),0,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3),
-E(3),E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,
-E(3)^2,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,0,0,0,0,0,0,0],[1,-1,-E(3)^2,-E(3),
E(3)^2,E(3),0,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,-1,1,-E(3),E(3),-E(3)^2,E(3)^2,
-1,1,-E(3),E(3),-E(3)^2,E(3)^2,-1,1,-E(3),E(3),-E(3)^2,E(3)^2,1,-1,E(3),
-E(3),E(3)^2,-E(3)^2,0,0,0,0,0,0,0],[1,-1,-E(3)^2,-E(3),E(3)^2,E(3),0,E(3),
-E(3),E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3)^2,-E(3)^2,1,
-1,E(3),-E(3),1,-1,E(3),-E(3),E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,1,-1,E(3),-E(3),
0,0,0,0,0,0,0],[1,-1,-E(3)^2,-E(3),E(3)^2,E(3),0,E(3),-E(3),E(3)^2,-E(3)^2,
1,-1,-E(3),E(3),-E(3)^2,E(3)^2,-1,1,-E(3)^2,E(3)^2,-1,1,-E(3),E(3),-1,1,
-E(3),E(3),-E(3)^2,E(3)^2,E(3)^2,-E(3)^2,1,-1,E(3),-E(3),0,0,0,0,0,0,0],[1,
-1,-E(3)^2,-E(3),E(3)^2,E(3),0,E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,
-E(3)^2,1,-1,E(3),-E(3),E(3),-E(3),E(3)^2,-E(3)^2,1,-1,1,-1,E(3),-E(3),
E(3)^2,-E(3)^2,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,0,0,0,0,0,0,0],[1,-1,-E(3)^2,
-E(3),E(3)^2,E(3),0,E(3)^2,-E(3)^2,1,-1,E(3),-E(3),-E(3)^2,E(3)^2,-1,1,
-E(3),E(3),-E(3),E(3),-E(3)^2,E(3)^2,-1,1,-1,1,-E(3),E(3),-E(3)^2,E(3)^2,
E(3),-E(3),E(3)^2,-E(3)^2,1,-1,0,0,0,0,0,0,0],[1,-1,-E(3),-E(3)^2,E(3),
E(3)^2,0,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,
E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,
-E(3)^2,E(3),-E(3),0,0,0,0,0,0,0],[1,-1,-E(3),-E(3)^2,E(3),E(3)^2,0,1,-1,
E(3)^2,-E(3)^2,E(3),-E(3),-1,1,-E(3)^2,E(3)^2,-E(3),E(3),-1,1,-E(3)^2,
E(3)^2,-E(3),E(3),-1,1,-E(3)^2,E(3)^2,-E(3),E(3),1,-1,E(3)^2,-E(3)^2,E(3),
-E(3),0,0,0,0,0,0,0],[1,-1,-E(3),-E(3)^2,E(3),E(3)^2,0,E(3),-E(3),1,-1,
E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3),-E(3),1,
-1,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),E(3)^2,-E(3)^2,E(3),-E(3),1,-1,0,0,0,0,0,
0,0],[1,-1,-E(3),-E(3)^2,E(3),E(3)^2,0,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,-E(3),
E(3),-1,1,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3),E(3),-1,1,-1,1,-E(3)^2,E(3)^2,
-E(3),E(3),E(3)^2,-E(3)^2,E(3),-E(3),1,-1,0,0,0,0,0,0,0],[1,-1,-E(3),
-E(3)^2,E(3),E(3)^2,0,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),
-E(3),1,-1,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),
E(3),-E(3),1,-1,E(3)^2,-E(3)^2,0,0,0,0,0,0,0],[1,-1,-E(3),-E(3)^2,E(3),
E(3)^2,0,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,-E(3)^2,E(3)^2,-E(3),E(3),-1,1,
-E(3),E(3),-1,1,-E(3)^2,E(3)^2,-1,1,-E(3)^2,E(3)^2,-E(3),E(3),E(3),-E(3),1,
-1,E(3)^2,-E(3)^2,0,0,0,0,0,0,0],[1,-1,-1,-1,1,1,0,1,-1,1,-1,1,-1,1,-1,1,-1,
1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,0,0,0,0,0,0,0],[1,-1,-1,
-1,1,1,0,1,-1,1,-1,1,-1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,1,-1,1,
-1,1,-1,0,0,0,0,0,0,0],[1,-1,-1,-1,1,1,0,E(3),-E(3),E(3),-E(3),E(3),-E(3),
E(3),-E(3),E(3),-E(3),E(3),-E(3),E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,
-E(3)^2,1,-1,1,-1,1,-1,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,0,0,0,0,
0,0,0],[1,-1,-1,-1,1,1,0,E(3),-E(3),E(3),-E(3),E(3),-E(3),-E(3),E(3),-E(3),
E(3),-E(3),E(3),-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-1,1,-1,1,-1,1,
E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,0,0,0,0,0,0,0],[1,-1,-1,-1,1,1,
0,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,
-E(3)^2,E(3)^2,-E(3)^2,E(3),-E(3),E(3),-E(3),E(3),-E(3),1,-1,1,-1,1,-1,E(3),
-E(3),E(3),-E(3),E(3),-E(3),0,0,0,0,0,0,0],[1,-1,-1,-1,1,1,0,E(3)^2,-E(3)^2,
E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,
-E(3),E(3),-E(3),E(3),-E(3),E(3),-1,1,-1,1,-1,1,E(3),-E(3),E(3),-E(3),E(3),
-E(3),0,0,0,0,0,0,0],[1,1,E(3),E(3)^2,E(3),E(3)^2,0,1,1,E(3)^2,E(3)^2,E(3),
E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,
E(3)^2,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),0,0,0,0,0,0,0],[1,1,E(3),
E(3)^2,E(3),E(3)^2,0,1,1,E(3)^2,E(3)^2,E(3),E(3),-1,-1,-E(3)^2,-E(3)^2,
-E(3),-E(3),-1,-1,-E(3)^2,-E(3)^2,-E(3),-E(3),-1,-1,-E(3)^2,-E(3)^2,-E(3),
-E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),0,0,0,0,0,0,0],[1,1,E(3),E(3)^2,E(3),
E(3)^2,0,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3)^2,
E(3)^2,E(3),E(3),1,1,1,1,E(3)^2,E(3)^2,E(3),E(3),E(3)^2,E(3)^2,E(3),E(3),1,
1,0,0,0,0,0,0,0],[1,1,E(3),E(3)^2,E(3),E(3)^2,0,E(3),E(3),1,1,E(3)^2,E(3)^2,
-E(3),-E(3),-1,-1,-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3),-E(3),-1,-1,-1,-1,
-E(3)^2,-E(3)^2,-E(3),-E(3),E(3)^2,E(3)^2,E(3),E(3),1,1,0,0,0,0,0,0,0],[1,1,
E(3),E(3)^2,E(3),E(3)^2,0,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),
E(3),1,1,E(3),E(3),1,1,E(3)^2,E(3)^2,1,1,E(3)^2,E(3)^2,E(3),E(3),E(3),E(3),
1,1,E(3)^2,E(3)^2,0,0,0,0,0,0,0],[1,1,E(3),E(3)^2,E(3),E(3)^2,0,E(3)^2,
E(3)^2,E(3),E(3),1,1,-E(3)^2,-E(3)^2,-E(3),-E(3),-1,-1,-E(3),-E(3),-1,-1,
-E(3)^2,-E(3)^2,-1,-1,-E(3)^2,-E(3)^2,-E(3),-E(3),E(3),E(3),1,1,E(3)^2,
E(3)^2,0,0,0,0,0,0,0],[6/7,6/7,6/7,6/7,6/7,6/7,-6/7,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36/7,-6/7,-6/7,-6/7,-6/7,-6/7,-6/7],
[6/7,6/7,6/7,6/7,6/7,6/7,-6/7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-6/7,(12*E(7)^6+6*E(7)^5+6*E(7)^2+12*E(7))/7,
(6*E(7)^6+12*E(7)^4+12*E(7)^3+6*E(7))/7,
(-12*E(7)^6-12*E(7)^5-12*E(7)^2-12*E(7))/7,
(12*E(7)^5+6*E(7)^4+6*E(7)^3+12*E(7)^2)/7,
(-12*E(7)^5-12*E(7)^4-12*E(7)^3-12*E(7)^2)/7,
(-12*E(7)^6-12*E(7)^4-12*E(7)^3-12*E(7))/7],[6/7,6/7,6/7,6/7,6/7,6/7,-6/7,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-6/7,
(6*E(7)^6+12*E(7)^4+12*E(7)^3+6*E(7))/7,
(12*E(7)^5+6*E(7)^4+6*E(7)^3+12*E(7)^2)/7,
(-12*E(7)^6-12*E(7)^4-12*E(7)^3-12*E(7))/7,
(12*E(7)^6+6*E(7)^5+6*E(7)^2+12*E(7))/7,
(-12*E(7)^6-12*E(7)^5-12*E(7)^2-12*E(7))/7,
(-12*E(7)^5-12*E(7)^4-12*E(7)^3-12*E(7)^2)/7],[6/7,6/7,6/7,6/7,6/7,6/7,-6/7,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-6/7,
(-12*E(7)^6-12*E(7)^5-12*E(7)^2-12*E(7))/7,
(-12*E(7)^6-12*E(7)^4-12*E(7)^3-12*E(7))/7,
(6*E(7)^6+12*E(7)^4+12*E(7)^3+6*E(7))/7,
(-12*E(7)^5-12*E(7)^4-12*E(7)^3-12*E(7)^2)/7,
(12*E(7)^6+6*E(7)^5+6*E(7)^2+12*E(7))/7,
(12*E(7)^5+6*E(7)^4+6*E(7)^3+12*E(7)^2)/7],[6/7,6/7,6/7,6/7,6/7,6/7,-6/7,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-6/7,
(12*E(7)^5+6*E(7)^4+6*E(7)^3+12*E(7)^2)/7,
(12*E(7)^6+6*E(7)^5+6*E(7)^2+12*E(7))/7,
(-12*E(7)^5-12*E(7)^4-12*E(7)^3-12*E(7)^2)/7,
(6*E(7)^6+12*E(7)^4+12*E(7)^3+6*E(7))/7,
(-12*E(7)^6-12*E(7)^4-12*E(7)^3-12*E(7))/7,
(-12*E(7)^6-12*E(7)^5-12*E(7)^2-12*E(7))/7],[6/7,6/7,6/7,6/7,6/7,6/7,-6/7,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-6/7,
(-12*E(7)^5-12*E(7)^4-12*E(7)^3-12*E(7)^2)/7,
(-12*E(7)^6-12*E(7)^5-12*E(7)^2-12*E(7))/7,
(12*E(7)^6+6*E(7)^5+6*E(7)^2+12*E(7))/7,
(-12*E(7)^6-12*E(7)^4-12*E(7)^3-12*E(7))/7,
(12*E(7)^5+6*E(7)^4+6*E(7)^3+12*E(7)^2)/7,
(6*E(7)^6+12*E(7)^4+12*E(7)^3+6*E(7))/7],[6/7,6/7,6/7,6/7,6/7,6/7,-6/7,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-6/7,
(-12*E(7)^6-12*E(7)^4-12*E(7)^3-12*E(7))/7,
(-12*E(7)^5-12*E(7)^4-12*E(7)^3-12*E(7)^2)/7,
(12*E(7)^5+6*E(7)^4+6*E(7)^3+12*E(7)^2)/7,
(-12*E(7)^6-12*E(7)^5-12*E(7)^2-12*E(7))/7,
(6*E(7)^6+12*E(7)^4+12*E(7)^3+6*E(7))/7,
(12*E(7)^6+6*E(7)^5+6*E(7)^2+12*E(7))/7]]/6,
special:=1);

CHEVIE.AddData("UnipotentCharacters","G34",
 function()local J,r,cuspidal;J:=E(3);r:=ER(-3);
  cuspidal:=function(arg)local res,n;
    n:="G_{34}";
    if Length(arg)>2 and IsInt(arg[3]) then PrintToString(n,"^",arg[3]);fi;
    PrintToString(n,"[",FormatTeX(arg[2]),"]");
    res:=rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..6], parameterExponents:=[],
        charNumbers:=[arg[1]], eigenvalue:=arg[2], cuspidalName:=n);
    if Length(arg)>2 and not IsInt(arg[Length(arg)]) then
      res.qEigen:=arg[Length(arg)];fi;
    return res;
  end;
  return rec(
    harishChandra:=[
    rec(relativeType:=rec(series:="ST",indices:=[1..6],rank:=6,ST:=34),
        levi:=[],parameterExponents:=[1,1,1,1,1,1],
         charNumbers:=[1..169],
	eigenvalue:=1, cuspidalName:=""),
    rec(relativeType:=rec(series:="ST",indices:=[6,5,1],rank:=3,ST:=26),
        levi:=[2..4],
        parameterExponents:=[1,3,3],
        charNumbers:=[170,171,340,341,325,324,342,326,220,185,219,186,216,274,
          249,226,184,173,334,332,251,225,183,174,335,333,232,253,299,310,
          189,208,231,255,298,309,190,209,197,198,280,
          281,282,279,245,224,247,223],  ## (197,198) allowed !!
        ## charNumbers changed 26.2.2003 by Gunter
	eigenvalue:=J, cuspidalName:="G_{3,3,3}[\\zeta_3]"),
    rec(relativeType:=rec(series:="ST",indices:=[6,5,1],rank:=3,ST:=26),
        levi:=[2..4],
        parameterExponents:=[1,[3,3,0],[3,3,0]],
       charNumbers:=[176,191,348,192,347,175,331,300,193,177,330,301,244,302,
         187,181,278,252,338,337,339,336,188,182,277,250,311,322,256,284,207,
	 218,206,217,312,323,254,283,227,230,314,315,228,229,276,248,275,246], 
        ## (314,315) allowed !!
        ## charNumbers changed 26.2.2003 by Gunter
        ## and 5.8.2011 by Jean to fit with new parameterExponent of G3,3,4
	eigenvalue:=J^2, cuspidalName:="G_{3,3,3}[\\zeta_3^2]"),
    rec(relativeType:=rec(series:="ST",indices:=[4,6],rank:=2,p:=6,q:=1),
        levi:=[1,2,3,348],
        parameterExponents:=[[5,4,1,0,1,4],4],
        charNumbers:=[235,194,236,273,237,195,286,259,289,257,205,343,328,313,
	  258,346,327,288,344,260,285,172,179,233,287,234,178],
	eigenvalue:=-1, cuspidalName:="D_4"),
    rec(relativeType:=rec(series:="ST",indices:=[6],rank:=1,p:=6,q:=1),
        levi:=[1..5],
        parameterExponents:=[[ 5, 0, 7, 2, 7, 0 ]],
        charNumbers:=[ 221, 317, 199, 296, 200, 316 ],
	eigenvalue:=E(4), 
	cuspidalName:="G_{33}[i]", qEigen:=1/2),
    rec(relativeType:=rec(series:="ST",indices:=[6],rank:=1,p:=6,q:=1),
        levi:=[1..5],
        parameterExponents:=[[ 5, 0, 7, 2, 7, 0 ]],
        charNumbers:=[ 222, 319, 201, 297, 202, 318 ],
	eigenvalue:=-E(4), qEigen:=1/2,
	cuspidalName:="G_{33}[-i]"),
    rec(relativeType:=rec(series:="ST",indices:=[6],rank:=1,p:=6,q:=1),
        levi:=[1..5],
        parameterExponents:=[[ 3, 8, 7, 0, 7, 8 ]],
        charNumbers:=[ 329, 238, 261, 345, 263, 239 ],
	eigenvalue:=-J, cuspidalName:="G_{33}[-\\zeta_3]"),
    rec(relativeType:=rec(series:="ST",indices:=[6],rank:=1,p:=6,q:=1),
        levi:=[1..5],
        parameterExponents:=[[8,1,0,5,0,1]],
        charNumbers:=[180,262,291,196,290,264],
	eigenvalue:=-J^2, cuspidalName:="G_{33}[-\\zeta_3^2]"),
    cuspidal(265,1), cuspidal(266,-1), cuspidal(294,J), cuspidal(295,J, 2),
    cuspidal(242,J^2), cuspidal(243,J^2,2), cuspidal(292,-J),
    cuspidal(293,-J,2), cuspidal(240,-J^2), cuspidal(241,-J^2,2),
    cuspidal(267,E(7)), cuspidal(268,E(7)^2), cuspidal(269,E(7)^3),
    cuspidal(270,E(7)^4), cuspidal(271,E(7)^5), cuspidal(272,E(7)^6),
    cuspidal(212,E(9),1/3), cuspidal(214,E(9),2,2/3), cuspidal(307,E(9)^2,2/3),
    cuspidal(303,E(9)^2,2,1/3), cuspidal(210,E(9)^4,1/3),
    cuspidal(215,E(9)^4,2,2/3), cuspidal(304,E(9)^5,2/3),
    cuspidal(305,E(9)^5,2,1/3), cuspidal(211,E(9)^7,2/3),
    cuspidal(213,E(9)^7,2,1/3), cuspidal(306,E(9)^8,1/3),
    cuspidal(308,E(9)^8,2,2/3), cuspidal(203,E(12)^7,1/2),
    cuspidal(320,E(12)^11,1/2), cuspidal(204,E(12),1/2),
    cuspidal(321,E(12)^5,1/2)],
 families:=[
   Family("C1",[1]),
   Family(ComplexConjugate(CHEVIE.families.X(3)),[5,3,170],rec(signs:=[1,1,-1])),   #I3^3
   Family(ComplexConjugate(CHEVIE.families.X(3)),[17,15,171],rec(signs:=[1,1,-1])),   #I3^3
   Family("C2",[24,14,20,172]),  #D4
  Family(CHEVIE.families.X(3)*ComplexConjugate(Family("X5")),
     [42,55,178,174,8,10,53,179,173,46,176,177,180,37,175],
     rec(signs:=[1,1,-1,-1,1,1,1,-1,-1,1,-1,-1,1,1,-1])),  #G_33
   Family(CHEVIE.families.QZ(3),[26,59,57,31,183,181,32,182,184],
     rec(signs:=[1,1,1,-1,-1,1,-1,-1,1],special:=3,cospecial:=2)),  #I4^3
   Family(CHEVIE.families.QZ(3),[81,68,71,45,185,188,39,187,186],
     rec(signs:=[1,1,1,1,1,1,1,-1,-1])), #I5^3
  Family(CHEVIE.families.X(3)*ComplexConjugate(Family("X5")),
     [109,89,194,190,35,33,91,195,189,107,192,193,196,116,191],
     rec(signs:=[1,1,1,-1,-1,-1,1,1,-1,1,-1,-1,1,1,-1])),
   # C2 changed to C'\"2 Gunter 22/9/99
   Family(ComplexConjugate(CHEVIE.families.X(3))*Family("C'\"2"),
     [ 103, 96, 199, 201, 101, 98, 200, 202, 198, 197, 203, 204 ],
     rec(signs:=[ 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1 ])),
   Family("C1",[28]),
   Family("C2",[124,63,105,205]),  #D4
   Family(CHEVIE.families.QZ(3),[22,86,84,79,208,206,78,207,209],
     rec(signs:=[1,1,1,-1,-1,1,-1,-1,1],special:=3,cospecial:=2)),  #I4^3
   Family(ComplexConjugate(Family("Z9")),[141,215,213,145,214,212,143,211,210],
     rec(special:=7,cospecial:=1)),
   Family(ComplexConjugate(CHEVIE.families.X(3)),[134,136,216],
     rec(signs:=[1,1,-1])),  #I3^3
   Family(CHEVIE.families.QZ(3),[129,156,154,72,219,217,74,218,220],
     rec(signs:=[1,1,1,-1,1,1,-1,-1,-1],special:=3,cospecial:=2)),
   Family("C1",[67]),
   # C2 changed to C'\"2 Gunter 22/9/99
   Family("C'\"2",[159, 161,221,222]),  #G_33
   Family(CHEVIE.families.QZ(6),[65,94,148,118,146,92,49,241,225,234,227,238,
     162,232,243,152,224,229,83,237,113,235,111,236,164,230,223,150,242,231,47,
     239,228,233,226,240],
     rec(signs:=[1,-1,-1,1,-1,-1,1,1,-1,1,1,-1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,
       1,-1,-1,1,-1,-1,1,1,-1,1,1,-1],special:=16,cospecial:=28)),
   Family(CHEVIE.families.X(3),[132,130,244],rec(signs:=[1,1,-1])), #\bar I3^3
   Family("F42",[169,265,122,121,12,11,52,166,119,249,245,252,248,139,
    257,253,261,256,264,138,258,254,262,255,263,168,266,127,259,126,260,167,
    120,250,246,251,247,51,267,268,269,270,271,272],
    rec(signs:=[1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,1,1,1,-1,
      1,-1,1,-1,1,1,-1,-1,-1,-1,1,1,1,1,1,1,1])),
   Family("C2",[125,61,106,273]),  #D4
   Family(ComplexConjugate(CHEVIE.families.X(3)),[133,131,274],
     rec(signs:=[1,1,-1])),  #I3^3
   Family(CHEVIE.families.QZ(6),[117,149,93,64,95,147,50,290,279,286,277,293,151,295,
    284,163,281,276,82,288,112,287,114,289,153,275,282,165,283,294,48,292,278,
    285,280,291],
    rec(signs:=[1,-1,-1,1,-1,-1,-1,1,-1,-1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,
      -1,1,-1,-1,-1,1,-1,-1,1,-1],special:=13,cospecial:=25)),
   # C2 changed to C'\"2 Gunter 22/9/99, the to C2h on 26.2.2003:
   Family("C'\"2",[160, 158,296,297]),  #G_33
   Family("C1",[66]),
   Family(CHEVIE.families.QZ(3),[128,73,75,157,298,301,155,300,299],
     rec(signs:=[1,-1,-1,1,1,-1,1,1,-1],special:=4,cospecial:=7)),
   Family(CHEVIE.families.X(3),[137,135,302],rec(signs:=[1,1,-1])),
# order changed by JM 22/10/99 from [144,142,140,303,307,305,304,306,308]
   Family("Z9",[140,304,303,144,308,306,142,307,305],rec(special:=1,cospecial:=4)),
   Family(CHEVIE.families.QZ(3),[21,77,76,85,309,312,87,311,310],
     rec(signs:=[1,-1,-1,1,1,1,1,-1,-1],special:=4,cospecial:=7)), #\bar I4^3
   Family("C2",[123,62,104,313]),  #D4
   Family("C1",[27]),
   # C2 changed to C'\"2 Gunter 22/9/99, then to C2h on 26.2.2003:
   Family(CHEVIE.families.X(3)*Family("C'\"2"),
    [ 97, 102, 316, 318, 99, 100, 317, 319, 315, 314, 320, 321 ],
     rec(signs:=[ 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1 ])),
   Family(ComplexConjugate(CHEVIE.families.X(3))*Family("X5"),
     [108,88,327,323,34,36,90,328,322,110,325,326,329,115,324],
     rec(signs:=[1,1,1,-1,-1,-1,1,1,-1,1,-1,-1,1,1,-1])),
   Family(CHEVIE.families.QZ(3),[80,69,70,41,332,331,44,330,333],
                         rec(signs:=[1,1,1,1,-1,-1,1,1,1])),  #\bar I3^5
   Family(CHEVIE.families.QZ(3),[25,30,29,58,334,337,60,336,335],
     rec(signs:=[1,-1,-1,1,1,1,1,-1,-1],special:=4,cospecial:=7)), #\bar I3^4
   Family(ComplexConjugate(CHEVIE.families.X(3))*Family("X5"),
     [40,56,343,339,7,9,54,344,338,43,341,342,345,38,340],
     rec(signs:=[1,1,-1,-1,1,1,1,-1,-1,1,-1,-1,1,1,-1])),
   Family("C2",[23,13,19,346]),  #D4
   Family(CHEVIE.families.X(3),[18,16,347],rec(signs:=[1,1,-1])), #\bar I3^3
   Family(CHEVIE.families.X(3),[6,4,348],rec(signs:=[1,1,-1])), #\bar I3^3
   Family("C1",[2])],
 a:=[0,126,1,85,1,85,46,4,46,4,15,15,57,3,2,68,2,68,57,3,28,10,57,3,41,5,45,9,
  41,41,5,5,7,31,7,31,4,46,6,46,36,4,46,36,6,4,13,19,13,19,15,15,4,46,4,46,5,41,
  5,41,18,27,9,19,13,30,12,6,36,36,6,11,23,11,23,28,28,10,10,36,6,19,13,10,28,
  10,28,31,7,31,7,13,19,13,19,8,29,8,29,29,8,29,8,27,9,18,7,31,7,31,13,19,13,19,
  31,7,19,13,15,15,15,15,27,9,18,15,15,23,11,14,20,14,20,11,23,11,23,15,15,24,
  10,24,10,24,10,13,19,13,19,13,19,13,19,11,23,11,23,21,12,21,12,13,19,13,19,15,
  15,15,15,1,2,3,4,4,4,4,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,
  8,9,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,12,12,13,13,13,13,13,13,13,
  13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,15,15,15,15,15,15,15,15,15,15,15,
  15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,18,20,19,19,19,19,19,19,
  19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,21,21,23,23,23,23,23,24,24,24,
  24,24,24,28,28,28,28,27,29,29,29,29,29,29,29,29,31,31,31,31,31,31,31,31,36,
  36,36,36,41,41,41,41,46,46,46,46,46,46,46,46,57,68,85],
 A:=[0,126,41,125,41,125,122,80,122,80,111,111,123,69,58,124,58,124,123,69,116,
  98,123,69,121,85,117,81,121,121,85,85,95,119,95,119,80,122,90,122,120,80,122,
  120,90,80,107,113,107,113,111,111,80,122,80,122,85,121,85,121,108,117,99,113,
  107,114,96,90,120,120,90,103,115,103,115,116,116,98,98,120,90,113,107,98,116,
  98,116,119,95,119,95,107,113,107,113,97,118,97,118,118,97,118,97,117,99,108,
  95,119,95,119,107,113,107,113,119,95,113,107,111,111,111,111,117,99,108,111,
  111,115,103,106,112,106,112,103,115,103,115,111,111,116,102,116,102,116,102,
  107,113,107,113,107,113,107,113,103,115,103,115,114,105,114,105,107,113,107,
  113,111,111,111,111,41,58,69,80,80,80,80,80,80,80,80,85,85,85,85,90,90,90,90,
  95,95,95,95,95,95,95,95,97,97,97,97,97,97,97,97,99,98,98,98,98,102,102,102,
  102,102,102,103,103,103,103,103,105,105,107,107,107,107,107,107,107,107,107,
  107,107,107,107,107,107,107,107,107,107,107,107,106,111,111,111,111,111,111,
  111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,
  111,111,111,108,112,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
  113,113,113,113,113,113,113,114,114,115,115,115,115,115,116,116,116,116,116,
  116,116,116,116,116,117,118,118,118,118,118,118,118,118,119,119,119,119,119,
  119,119,119,120,120,120,120,121,121,121,121,122,122,122,122,122,122,122,122,
  123,124,125]);
end);

# for the next function see
# Conway & Sloane Math.Proc.Camb.Phil.Soc. 93(1983) p.437
# and Orlik, Contemporary Math. vol. 90 (1989) p. 226
CHEVIE.AddData("Invariants","G34",function()local r;
 r:=ComplexReflectionGroup(34).roots; return [
 function(x,y,z,t,u,v) return Sum(r,a->([x,y,z,t,u,v]*a)^6)/1944;end,
 function(x,y,z,t,u,v) return Sum(r,a->([x,y,z,t,u,v]*a)^12)/3888;end,
 function(x,y,z,t,u,v) return Sum(r,a->([x,y,z,t,u,v]*a)^18)/1944;end,
 function(x,y,z,t,u,v) return Sum(r,a->([x,y,z,t,u,v]*a)^24)/7776;end,
 function(x,y,z,t,u,v) return Sum(r,a->([x,y,z,t,u,v]*a)^30)/1944;end,
 function(x,y,z,t,u,v) return Sum(r,a->([x,y,z,t,u,v]*a)^42)/1944;end];
end);
