#############################################################################
##
#A  tbl/cmplxg32.g              CHEVIE library                   Gunter Malle
##
#Y  Copyright (C) 1998 - 2010  The CHEVIE Team
##
##  This file contains  data about the complex reflection group  of type G32
##  in the Shephard-Todd classification.
##
CHEVIE.AddData("PrintDiagram","G32",function(indices,title)
  Print(title," ",indices[1],"(3)--(3)",indices[2],"--(3)",
		  indices[3],"--(3)",indices[4],"\n");
end);

CHEVIE.AddData("GeneratingRoots","G32",
 [[0,0,-1,0],E(4)/ER(3)*[1,1,1,0],[0,1,0,0],E(4)/ER(3)*[1,-1,0,-1]]);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G32",[1/3,1/3,1/3,1/3]);

CHEVIE.AddData("HyperplaneRepresentatives","G32",[1]);

CHEVIE.AddData("BraidRelations","G32",[[[1,2,1],[2,1,2]],[[2,3,2],[3,2,3]],
  [[3,4,3],[4,3,4]],[[1,3],[3,1]],[[1,4],[4,1]],[[2,4],[4,2]]]);

CHEVIE.AddData("Size","G32", 155520);

CHEVIE.AddData("ReflectionDegrees","G32",[12,18,24,30]);

CHEVIE.AddData("NrConjugacyClasses","G32", 102);

CHEVIE.AddData("ParabolicRepresentatives","G32",# repr. of conj. classes
 [[],[1],[1,2],[1,3],[1..3],[1,3,4],[1..4]]);

# in BW, classes 34,62,84 are (z^5)^(1/4), (z^5)^(1/2), (z^3)^(1/2)
# classes 30,41,58 are (z1414)^(1/2), (z14)^(1/2), z(z14)^(1/2)
# this gives the monomial part of the eigenvalues. Vanishing due to 
# rationality of characters and Schur relations of Spetsial algebra conclude.
CHEVIE.AddData("ClassNames","G32",
 [".","1","12","31","11","121","421","123","131","1232",#10
  "aa1211211","4311","c","3131","1211211",              #15
  "4211","42211","cc","a32","d",                        #20
  "aaaa12","44211","1232z","aa123","a32zzzzz",          #25
  "aa121121","a","ccc","442211","dd14",                 #30
  "211211","121zzzzz","aaaa1211211","zd", "cccc",       #35
  "4211211","a32z","11434z","a32zzz","aa13",            #40
  "dd1","zzc","121z","aa12","1434zzzzz",                #45
  "1232zzzzz","44211211","1zzzzz","1434z","1232zzzz",   #50
  "ddd","11434zzzzz","3131z", "11z","1232zzz",          #55
  "131zzzzz","aa1","zdd1","a32zzzz","dd",               #60
  "131z","zzdd","1434zz","1232zz","aa",                 #65
  "1211214z","zc","12112114zz","aaaa","131zzz",         #70
  "1134z","a32zz","12112144z","1434zzz","121zz",        #75
  "11434zzzz","121zzzz", "11434zzz","az","1211214zz",   #80
  "121121z", "124z","12zz","zdd","11zzzz",              #85
  "12z","121121zz","13z","124zz", "121zzz",             #90
  "11zzzzz","13zz","1z", "z","13zzz",                   #95
  "11zzz", "1zz", "1zzz", "zzzzz", "zzz", "zz", "zzzz"]);

CHEVIE.AddData("WordsClassRepresentatives","G32",
 List(CHEVIE.RawData("ClassNames","G32"),x->Replace(x,".",[],"1",[1],
   "2",[2],"3",[3],"4",[4],"z","ccccc","c",[4,3,2,1],"d",[1,2,4,3,2],
   "a",[1,2,1,3,2,1])));

CHEVIE.AddData("PowerMaps","G32",
 [ , [ 1, 5, 2, 14, 2, 31, 9, 27, 9, 19, 40, 4, 18, 4, 5, 47, 14, 35, 10, 60,
      57, 36, 72, 26, 50, 69, 65, 67, 9, 53, 1, 81, 4, 62, 18, 5, 64, 80, 10,
      57, 88, 35, 87, 14, 86, 59, 2, 85, 26, 72, 84, 27, 92, 97, 19, 40, 40,
      95, 64, 94, 57, 99, 86, 59, 69, 65, 67, 92, 65, 9, 92, 50, 97, 47, 81,
      80, 87, 36, 85, 85, 101, 57, 69, 100, 97, 97, 102, 4, 40, 31, 69, 92,
      65, 101, 14, 2, 85, 5, 102, 1, 102, 101 ],
  [ 1, 1, 31, 1, 1, 6, 31, 6, 1, 65, 31, 31, 28, 1, 31, 6, 31, 67, 69, 51,
      31, 6, 91, 6, 93, 31, 31, 28, 31, 84, 31, 90, 31, 51, 67, 31, 93, 90,
      93, 1, 84, 28, 90, 31, 90, 91, 31, 100, 90, 65, 51, 90, 100, 100, 91,
      100, 1, 84, 69, 84, 100, 84, 6, 65, 1, 31, 67, 31, 1, 100, 31, 69, 31,
      90, 6, 6, 6, 90, 31, 31, 31, 31, 31, 84, 1, 31, 31, 100, 31, 90, 100,
      1, 100, 100, 100, 100, 1, 100, 100, 100, 1, 1 ],,
  [ 1, 5, 15, 14, 2, 6, 29, 24, 9, 19, 21, 17, 94, 4, 3, 22, 12, 101, 10, 34,
      11, 16, 25, 8, 23, 27, 26, 100, 7, 30, 31, 43, 44, 20, 102, 47, 46, 45,
      55, 57, 58, 99, 32, 33, 38, 37, 36, 54, 52, 72, 51, 49, 53, 48, 39, 61,
      40, 41, 64, 62, 56, 60, 76, 59, 69, 83, 1, 71, 65, 70, 68, 50, 79, 78,
      77, 63, 75, 74, 73, 86, 87, 89, 66, 84, 97, 80, 81, 95, 82, 90, 93, 92,
      91, 99, 88, 98, 85, 96, 94, 100, 102, 101 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102 ],,,,
  [ 1, 5, 15, 14, 2, 6, 29, 24, 9, 19, 21, 17, 42, 4, 3, 22, 12, 35, 10, 34,
      11, 16, 25, 8, 23, 27, 26, 28, 7, 30, 31, 43, 44, 20, 18, 47, 46, 45,
      55, 57, 58, 13, 32, 33, 38, 37, 36, 54, 52, 72, 51, 49, 53, 48, 39, 61,
      40, 41, 64, 62, 56, 60, 76, 59, 69, 83, 67, 71, 65, 70, 68, 50, 79, 78,
      77, 63, 75, 74, 73, 86, 87, 89, 66, 84, 97, 80, 81, 95, 82, 90, 93, 92,
      91, 99, 88, 98, 85, 96, 94, 100, 102, 101 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102 ],,,,
  [ 1, 5, 15, 14, 2, 6, 29, 24, 9, 19, 21, 17, 42, 4, 3, 22, 12, 35, 10, 34,
      11, 16, 25, 8, 23, 27, 26, 28, 7, 30, 31, 43, 44, 20, 18, 47, 46, 45,
      55, 57, 58, 13, 32, 33, 38, 37, 36, 54, 52, 72, 51, 49, 53, 48, 39, 61,
      40, 41, 64, 62, 56, 60, 76, 59, 69, 83, 67, 71, 65, 70, 68, 50, 79, 78,
      77, 63, 75, 74, 73, 86, 87, 89, 66, 84, 97, 80, 81, 95, 82, 90, 93, 92,
      91, 99, 88, 98, 85, 96, 94, 100, 102, 101 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102 ],,,,
  [ 1, 5, 15, 14, 2, 6, 29, 24, 9, 19, 21, 17, 42, 4, 3, 22, 12, 35, 10, 34,
      11, 16, 25, 8, 23, 27, 26, 28, 7, 30, 31, 43, 44, 20, 18, 47, 46, 45,
      55, 57, 58, 13, 32, 33, 38, 37, 36, 54, 52, 72, 51, 49, 53, 48, 39, 61,
      40, 41, 64, 62, 56, 60, 76, 59, 69, 83, 67, 71, 65, 70, 68, 50, 79, 78,
      77, 63, 75, 74, 73, 86, 87, 89, 66, 84, 97, 80, 81, 95, 82, 90, 93, 92,
      91, 99, 88, 98, 85, 96, 94, 100, 102, 101 ],,,,,,
  [ 1, 5, 15, 14, 2, 6, 29, 24, 9, 19, 21, 17, 42, 4, 3, 22, 12, 35, 10, 34,
      11, 16, 25, 8, 23, 27, 26, 28, 7, 30, 31, 43, 44, 20, 18, 47, 46, 45,
      55, 57, 58, 13, 32, 33, 38, 37, 36, 54, 52, 72, 51, 49, 53, 48, 39, 61,
      40, 41, 64, 62, 56, 60, 76, 59, 69, 83, 67, 71, 65, 70, 68, 50, 79, 78,
      77, 63, 75, 74, 73, 86, 87, 89, 66, 84, 97, 80, 81, 95, 82, 90, 93, 92,
      91, 99, 88, 98, 85, 96, 94, 100, 102, 101 ] ]);

CHEVIE.AddData("ClassInfo","G32",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G32"),
    classnames:=CHEVIE.RawData("ClassNames","G32"),
    classparams:=CHEVIE.RawData("ClassNames","G32"),
    orders:=[1,3,6,3,3,4,6,12,3,9,6,6,30,3,6,12,6,15,9,24,6,12,18,12,18,
  6,6,10,6,12,2,12,6,24,15,6,18,12,18,3,12,30,12,6,12,18,6,6,12,9,8,12,6,6,18,
  6,3,12,9,12,6,12,12,9,3,6,5,6,3,6,6,9,6,12,12,12,12,12,6,6,6,6,6,4,3,6,6,6,6,
  4,6,3,6,6,6,6,3,6,6,2,3,3],
    classes:=[1,40,360,240,40,540,1440,2160,480,2880,1440,1440,5184,240,360,
  2160,1440,5184,2880,6480,1440,2160,2880,2160,2880,360,360,5184,1440,4320,90,
  540,1440,6480,5184,360,2880,2160,2880,480,4320,5184,540,1440,2160,2880,360,
  40,2160,2880,6480,2160,240,40,2880,480,480,4320,2880,540,480,540,2160,2880,
  40,360,5184,1440,40,480,1440,2880,360,2160,540,2160,540,2160,360,360,90,1440,
  360,540,40,360,90,240,1440,540,40,240,40,1,240,40,40,40,1,1,1,1]));

CHEVIE.AddData("CharInfo","G32",function()local res;
  res:=rec(charparams:=
# The labelling is determined as follows:
# phi{30,12}'' and phi{60,15}'' are real
# The complex conjugate of phi{20,9}' is phi{20,3}
# The complex conjugate of phi{20,29}' is phi{20,13}
# The complex conjugate of phi{30,12}' is phi{30,24}
# The complex conjugate of phi{30,20}' is phi{30,16}
# The complex conjugate of phi{60,11}' is phi{60,7}
# The complex conjugate of phi{60,15}' is phi{60,9}
 [[1,0],[1,80],[1,40],[4,61],[4,21],[4,11],[4,41],[4,51],
 [4,1],[5,36],[5,44],[5,4],[5,12],[5,52],[5,20],[6,48],[6,8],[6,28],[10,30],
 [10,2],[10,34],[10,42],[10,10],[10,14],[15,24],[15,6],[15,8],[15,16],[15,38],
 [15,22],[20,33],[20,12],[20,13],[20,9,1],[20,35],[20,29,1],[20,3],[20,25],
 [20,31],[20,9,2],[20,17],[20,29,2],[20,21],[20,7],[20,19],[20,5],[20,20],
 [20,16],[24,6],[24,26],[24,16],[30,12,2],[30,12,1],[30,8],[30,28],[30,24],
 [30,4],[30,20,2],[30,20,1],[30,16],[36,7],[36,27],[36,17],[36,5],[36,15],
 [36,25],[40,24],[40,14],[40,10],[40,18],[40,22],[40,8],[45,6],[45,14],[45,22],
 [45,18],[45,10],[45,26],[60,15,2],[60,12],[60,7],[60,15,1],[60,17],[60,11,1],
 [60,9],[60,19],[60,13],[60,11,2],[60,20],[60,16],[64,18],[64,21],[64,8],
 [64,16],[64,13],[64,11],[80,9],[80,13],[80,17],[81,12],[81,14],[81,10]],
  extRefl:=[1,9,17,5,3]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,3,3,3];
  return res;
end);

# Irrationality of chars:
# f36,f45 use E(3); f64 uses GetRoot(v*w); f81 uses GetRoot(u*v*w,3)
CHEVIE.AddData("HeckeCharTable","G32",function(para,root)
  local u,v,w,f1,f4,f5,f6,f10,f15,f15b,f20a,f20b,f20c,f20d,f24,f30a,f30b,f36,
  f40,f45,f60a,f60b,f60c,f64,f80,f81,res,c;
  u:=para[1][1];  v:=para[1][2];  w:=para[1][3];c:=(u*v*w)^0;
  f1:=u->List(CHEVIE.G32.WordsClassRepresentatives,i->u^Length(i));
  f4:=function(v,w)return[4,v+3*w,w*(2*w+v),2*w*(w+v),v^2+3*w^2,2*w^3,
w^2*(w+2*v),w^2*(w+v),w*(v*w+v^2+2*w^2),w^4,
-w^11*(-w+v)*(w^7+v*w^6+w^5*v^2+v^3*w^4+2*v^4*w^3+2*w^2*v^5+2*w*v^6+v^7),
w^2*(v*w+v^2+w^2),v*w^3,2*w^2*(v^2+w^2),-w^3*(-w+v)*(2*w^3+2*v*w^2+2*v^2*w+v^3),
w^3*(w+v),-w^2*(-w+v)*(v*w+v^2+w^2),-v^2*w^6,w^8,0,w^17*(v^8*w+v^9+w^9),
w^3*(v^2+w^2),-v^5*w^19,w^10*(w+v)*(v^4-w*v^3+v^2*w^2-v*w^3+w^4),-v^25*w^83,
-w^11*(-w+v)*(w^6+v*w^5+v^2*w^4+v^3*w^3+2*w^2*v^4+2*w*v^5+2*v^6),
-w^4*(-w+v)*(w+v),v^3*w^9,-w^3*(-w+v)*(v^2+w^2),0,
-2*w^3*(-w+v)*(v*w+v^2+w^2),-2*v^25*w^78,
-w^19*(-w+v)*(v*w+v^2+w^2)*(w^9+w^6*v^3+w^3*v^6+v^8*w+v^9),0,-v^4*w^12,
-w^4*(-w+v)*(w^2+2*v*w+2*v^2),-v^5*w^23,-v^5*w^18*(v^2+w^2),-v^15*w^53,
w^9*(w+v)*(w^4-v*w^3+v^2*w^2-w*v^3+2*v^4),0,v^11*w^33,-2*v^5*w^18,
w^9*(v*w+v^2+w^2)*(w^3-v*w^2+v^3),-v^25*w^78*(w+v),-v^25*w^79,
-w^5*(-w+v)*(w^2+v*w+2*v^2),-v^25*w^75*(v+3*w),-v^5*w^18*(w+v),v^20*w^64,0,
-v^25*w^78*(v^2+w^2),-2*v^5*w^17*(v^2+w^2),-v^5*w^15*(v^2+3*w^2),-v^15*w^49,
-v^25*w^76*(v*w+v^2+2*w^2),w^8*(2*v^4*w+v^5+w^5),0,
v^20*w^68,0,-v^5*w^16*(v*w+v^2+2*w^2),0,v^10*w^33*(w+v),v^10*w^34,
w^8*(3*v^4+w^4),v^5*w^19*(-w+v)*(w^2+2*v*w+2*v^2),-v^6*w^18,
-v^10*w^34*(-w+v)*(w+v)*(v*w+v^2+w^2),w^16*(3*v^8+w^8),
-v^15*w^46*(v*w+v^2+2*w^2),-v^5*w^17*(v*w+v^2+w^2),v^10*w^38,
v^5*w^20*(-w+v)*(w^2+v*w+2*v^2),-v^15*w^48*(w+v),2*v^10*w^33,
v^20*w^63*(v^2+w^2),2*v^20*w^63,-v^15*w^48*(v^2+w^2),
v^5*w^19*(-w+v)*(w+v),-v^10*w^34*(-w+v)*(w^2+2*v*w+2*v^2),
2*v^5*w^18*(-w+v)*(v*w+v^2+w^2),-v^5*w^17*(w+2*v),v^10*w^31*(2*w+v),0,
v^20*w^60*(v^2+3*w^2),-v^5*w^16*(2*w+v),-2*v^10*w^33*(-w+v)*(v*w+v^2+w^2),
-2*v^5*w^16*(w+v),v^10*w^32*(w+2*v),-2*v^15*w^48,-v^25*w^75*(v^2+3*w^2),
2*v^10*w^31*(w+v),-v^5*w^15*(v+3*w),-4*v^5*w^15,-2*v^15*w^46*(w+v),
-v^15*w^45*(v^2+3*w^2),v^10*w^30*(v+3*w),-v^15*w^45*(v+3*w),
-4*v^25*w^75,-4*v^15*w^45,4*v^10*w^30,4*v^20*w^60];end;
f5:=function(u,v,w)return[5,2*u+3*w,w*(2*u+w),2*u*w+u^2+2*w^2,2*u^2+3*w^2,w^3,
w*(u*w+u^2+w^2),u*w^2,u*w^2+u^2*w+u^3+2*w^3,-u^2*w^2,
u^4*w^9*(u*w+u^2+w^2)*(-u^4-u*w^3+w^4),w*(u*w^2+u^3+w^3),0,2*u^2*w^2+u^4+2*w^4,
w^3*(-2*u^3*w-2*u^4+w^4),w^4,w*(-u*w^3-u^2*w^2-u^3*w-u^4+w^4),0,-u^4*w^4,
-u^2*w^3,u^8*w^13*(u*w+u^2+w^2)*(u^3-u^2*w+w^3),w^5,-u^10*w^14,u^5*w^10,
-u^44*w^64,u^4*w^9*(w^5-2*u^3*w^2-2*u^5),-w^3*u^2*(2*u+w),0,
w*(u*w+u^2+w^2)*(-u^3+u^2*w-2*u*w^2+w^3),u^6*w^6,
w^3*(-4*u^3+w^3),u^40*w^63,u^8*w^15*(-u^3-u^2*w+w^3)*(u^5+u^2*w^3+w^5),
-u^10*w^15,0,w^3*(-2*u^3*w-2*u^4+w^4),-u^12*w^16,u^8*w^17,-u^28*w^40,
u^4*w^6*(w^4+2*u*w^3+u^2*w^2+u^4),u^5*w^6,0,u^8*w^15,w^7*u^4*(u*w^2+u^3+w^3)
,u^40*w^64,-u^42*w^62,w^3*(w^5-2*u^3*w^2-2*u^5),w^60*u^40*(2*u+3*w),u^8*w^
16,-u^34*w^50,-u^6*w^9,u^40*w^65,u^8*w^12*(2*u^2*w^2+u^4+2*w^4),u^8*w^12*(2
*u^2+3*w^2),-u^26*w^38,u^40*w^60*(u*w^2+u^2*w+u^3+2*w^3),u^4*w^6*(u*w^2+u^2*w
+u^3+2*w^3),u^13*w^18,-u^36*w^52,u^4*w^6,u^8*w^12*(u*w^2+u^2*w+u^3+2*w^3),
u^20*w^30,u^16*w^28,-u^18*w^26,u^4*w^6*(2*u^2+3*w^2),
u^8*w^15*(-2*u^3*w-2*u^4+w^4),0,u^16*w^27*(w^5-u^3*w^2-2*u^4*w-u^5),
u^8*w^12*(3*w^4+2*u^4),u^24*w^36*(u*w^2+u^2*w+u^3+2*w^3),u^8*w^13*(u*w^2+
u^3+w^3),-u^20*w^28,u^8*w^15*(w^5-2*u^3*w^2-2*u^5),u^24*w^40,u^16*w^27,u^32
*w^53,u^32*w^51,u^24*w^41,-w^15*u^10*(2*u+w),u^16*w^27*(-2*u^3*w-2*u^4+w^4),
u^8*w^15*(-4*u^3+w^3),u^8*w^13*(u*w+u^2+w^2),w^25*u^16*(2*u+w),u^12*w^18,u^
32*w^48*(2*u^2+3*w^2),w^13*u^8*(2*u+w),u^16*w^27*(-4*u^3+w^3),u^8*w^12*(2*u*w
+u^2+2*w^2),u^16*w^25*(u*w+u^2+w^2),u^24*w^39,u^40*w^60*(2*u^2+3*w^2),u^16*w
^24*(2*u*w+u^2+2*w^2),w^12*u^8*(2*u+3*w),5*u^8*w^12,u^24*w^36*(2*u*w+u^2+2*w^
2),u^24*w^36*(2*u^2+3*w^2),w^24*u^16*(2*u+3*w),w^36*u^24*(2*u+3*w),5*u^40*w^
60,5*u^24*w^36,5*u^16*w^24,5*u^32*w^48];end;
  f6:=function(v,w)return [6,3*v+3*w,(w+v)^2,4*v*w+v^2+w^2,3*v^2+3*w^2,
(w+v)*(v^2-v*w+w^2),2*v*w*(w+v),v*w*(w+v),(w+v)*(v*w+v^2+w^2), 0,
w^4*v^4*(w+v)*(w^10-v*w^9+v^2*w^8-2*v^3*w^7+v^4*w^6-v^5*w^5+v^6*w^4-2*v^7*w^3+v^8*w^2-v^9*w+v^10), v*w*(w+v)^2, v^2*w^2,
4*v^2*w^2+v^4+w^4, (w+v)*(-w^3+v*w^2+v^3)*(-w^3-v^2*w+v^3), v*w*(v^2+w^2), -v^2*
w^2*(w+v), w^4*v^4, 0, 0, v^8*w^8*(v^2-v*w+w^2)*(w^6-v^3*w^3+v^6)*(w+v)^2, v^2*w
^2*(w+v), 0, v^5*w^5*(w+v)*(v^4-w*v^3+v^2*w^2-v*w^3+w^4), 0, w^4*v^4*(w^10-2*v^3
*w^7-2*v^7*w^3+v^10), -v^2*w^2*(v^2+w^2), v^6*w^6, -v*w*(v^2+w^2)*(v^2-v*w+w^2),
v^5*w^7+v^7*w^5, -4*v^3*w^3+v^6+w^6, v^50*w^50*(w+v)*(v^2-v*w+w^2), v^8*w^8*(w+
v)*(w^14-w^13*v+w^12*v^2-2*v^3*w^11+v^4*w^10-v^5*w^9+w^8*v^6-v^7*w^7+w^6*v^8-v^9
*w^5+v^10*w^4-2*w^3*v^11+w^2*v^12-w*v^13+v^14), 0, v^8*w^8, v*w*(w+v)*(w^4-v*w^3
-v^2*w^2-w*v^3+v^4), 0, v^12*w^12*(w+v), 0, w^4*v^4*(v*w+v^2+w^2)*(w^4+v*w^3-2*v
^2*w^2+w*v^3+v^4), v^5*w^5*(v+w), v^22*w^22, v^10*w^10*(w+v)*(v^2-v*w+w^2),
w^4*v^4*(v^4-w*v^3+v^2*w^2-v*w^3+w^4)*(w+v)^2, v^51*w^51*(v^2+w^2), 0, v^2*w^2*(
w^4-2*v*w^3-2*w*v^3+v^4), 3*v^50*w^50*(w+v), v^11*w^11*(v^2+w^2), 0, 0, v^52*w^
52*(w+v), v^10*w^10*(4*v^2*w^2+v^4+w^4), 3*v^10*w^10*(v^2+w^2), 0, v^50*w^50*(w+
v)*(v*w+v^2+w^2), w^4*v^4*(w+v)*(v*w+v^2+w^2)*(2*w^2-3*v*w+2*v^2),
v^15*w^15*(v+w), 0, 2*v^5*w^5, v^10*w^10*(w+v)*(v*w+v^2+w^2), 2*v^25*w^25, 
v^21*w^21*(v^2+w^2), 0, 3*w^4*v^4*(w^4+v^4), v^11*w^11*(w+v)*(w^
4-v*w^3-v^2*w^2-w*v^3+v^4), v^12*w^12, v^21*w^21*(w^6-v^2*w^4-2*v^3*w^3-w^2*v^4+
v^6), 3*v^8*w^8*(w^8+v^8), v^30*w^30*(w+v)*(v*w+v^2+w^2), v^11*w^11*(w+v)^2, 0,
v^12*w^12*(w^4-2*v*w^3-2*w*v^3+v^4), v^31*w^31*(v^2+w^2), v^20*w^20*(w+v)*(v^2-v
*w+w^2), v^42*w^42*(w+v), v^40*w^40*(w+v)*(v^2-v*w+w^2), v^32*w^32*(w+v), -v^12*
w^12*(v^2+w^2), v^21*w^21*(w+v)*(w^4-v*w^3-v^2*w^2-w*v^3+v^4), v^10*w^10*(-4*v^3
*w^3+v^6+w^6), 2*v^11*w^11*(w+v), v^20*w^20*(w+v)^2, 2*v^15*w^15, 3*v^40*w^40*(v
^2+w^2), v^10*w^10*(w+v)^2, v^20*w^20*(-4*v^3*w^3+v^6+w^6), v^10*w^10*(4*v*w+v^2
+w^2), 2*v^21*w^21*(w+v), v^30*w^30*(w+v)*(v^2-v*w+w^2), 3*v^50*w^50*(v^2+w^2),
v^20*w^20*(4*v*w+v^2+w^2), 3*v^10*w^10*(w+v), 6*v^10*w^10, v^30*w^30*(4*v*w+v^2+
w^2), 3*v^30*w^30*(v^2+w^2), 3*v^20*w^20*(w+v), 3*v^30*w^30*(w+v), 6*v^50*w^50,
6*v^30*w^30, 6*v^20*w^20, 6*v^40*w^40];end;
  f10:=function(u,v,w)return [10, u+6*v+3*w, v*(2*w+3*v), 2*u*v+4*v*w+3*v^2+w^2, u^2+6*v^2+3*w^2, v*(-u*w+3*v
^2), v*(u*v+w^2+2*v*w+v^2), v^2*(w+v), u*v^2+2*v*w^2+u^2*v+2*v^2*w+3*v^3+w^3, v^
4, v^8*(-v*u^2*w^8-v^2*u^2*w^7+v^5*u^2*w^4+u^4*w^7+v*u^4*w^6+u^5*w^6-v^3*w^8-v^4
*w^7+v^7*w^4+v^11), v*(w^3+u^2*v+v*w^2+v^2*w+v^3), 0, 2*u^2*v^2+4*v^2*w^2+3*v^4+
w^4, v^2*(u^2*w^3+u^2*v*w^2+u^3*w^2-2*v*w^4-2*v^2*w^3+3*v^5), v^2*(-u*w+u*v+v*w+
v^2), v*(u*v^3-w^4+u^2*w^2+u^2*v^2-v*w^3+v^4), 0, v^8, 0, v^13*(u^4*w^9+v*u^4*w^
8+v^4*w^9+v^5*w^8+v^13), v^3*(-u*w+u^2+w^2+v^2), u^2*v^16*w^6, v^10*(w+v)*(v^4-w
*v^3+v^2*w^2-v*w^3+w^4), u^10*v^68*w^30, v^8*(-2*v*u^2*w^7+v^4*u^2*w^4+3*u^4*w^6
-2*v^3*w^7+v^6*w^4+v^10), v^3*(2*u*w^2-v*w^2+v^3), 0, v*(-w^5+u^2*v*w^2+2*u^2*v^
3-2*v^2*w^3+2*v^3*w^2-v^4*w+v^5), 
-u*v^6*w^3*(w^2+v^2), v^2*(3*u^2*w^2-4*v*w^3+3*v^4), v^61
*w^30*u^10*(-u*w+3*v^2), v^14*(-v*u^4*w^12-v^2*u^4*w^11+v^5*u^4*w^8+u^6*w^11+v*u
^6*w^10+u^7*w^10-v^5*w^12-v^6*w^11+v^9*w^8+v^17), 0, 0, v^3*(u*v^3+3*u^2
*w^2-2*w^4-2*v*w^3+w*v^3+v^4), u^2*v^20*w^6, u^2*v^15*w^6*(-u*w+u^2+w^2+v^2), u^
6*v^44*w^18, v^6*(u^2*w^6+2*v*u^2*w^5+v^2*u^2*w^4+2*v*u^3*w^4+2*v^3*w^5+w^4*v^4+
v^8),-u*v^6*w^3*(v+w),0,v^13*w^6*u^2*(-u*w+3*v^2), v^7*(u^2*w^5+v*u^2*w^4+w^5*v^2+v^
3*w^4+v^7), v^62*w^30*u^10*(-u*w+u*v+v*w+v^2), u^10*v^64*w^30, v^3*(3*u^2*v*w^2+
u^2*v^3-2*w^5-2*v^2*w^3+v^3*w^2+v^5), v^60*u^10*w^30*(u+6*v+3*w), v^14*w^6*u^2*(
-u*w+u*v+v*w+v^2), u^8*v^52*w^24, 0, u^10*v^63*w^30*(-u*w+u^2+w^2+v^2), u^2*v^12
*w^6*(2*u^2*v^2+4*v^2*w^2+3*v^4+w^4), u^2*v^12*w^6*(u^2+6*v^2+3*w^2), u^6*v^40*w
^18, u^10*v^60*w^30*(u*v^2+2*v*w^2+u^2*v+2*v^2*w+3*v^3+w^3), v^6*(2*u^2*w^5+3*v*
u^2*w^4+u^3*w^4+w^5*v^2+2*v^3*w^4+v^7), -u^3*v^18*w^9*(v+w), u^8*v^56*w^24, 
-2*u*v^6*w^3, u^2*v^12*w^6*(u*v^2+2*v*w^2+u^2*v+2*v^2*w+3*v^3+w^3), 
-2*u^5*v^30*w^15, v^26*w^12*u^4*(-u*w+u*v+v*w+v^2), 
u^4*v^28*w^12, v^6*(6*u^2*w^4+3*v^2*w^4+v^6), u^2*v^15*w^6*(u
*v^3+3*u^2*w^2-2*w^4-2*v*w^3+w*v^3+v^4), 0, u^4*v^27*w^12*(-w^5-2*v*w^4-v^2*w^3+
v^4*w+v^5+u*v^4+u^2*w^3+u^2*v*w^2+u^3*w^2), v^12*(6*u^4*w^8+3*v^4*w^8+v^12), u^6
*v^36*w^18*(u*v^2+2*v*w^2+u^2*v+2*v^2*w+3*v^3+w^3), u^2*v^13*w^6*(w^3+u^2*v+v*w^
2+v^2*w+v^3), u^4*v^32*w^12, u^2*v^15*w^6*(3*u^2*v*w^2+u^2*v^3-2*w^5-2*v^2*w^3+v
^3*w^2+v^5), v^38*w^18*u^6*(-u*w+u*v+v*w+v^2), v^25*w^12*u^4*(-u*w+3*v^2), u^8*v
^51*w^24*(-u*w+u^2+w^2+v^2), v^49*w^24*u^8*(-u*w+3*v^2), u^6*v^39*w^18*(-u*w+u^2
+w^2+v^2), u^2*v^15*w^6*(2*u*w^2-v*w^2+v^3), u^4*v^27*w^12*(u*v^3+3*u^2*w^2-2*w^
4-2*v*w^3+w*v^3+v^4), u^2*v^14*w^6*(3*u^2*w^2-4*v*w^3+3*v^4), u^2*v^13*w^6*(u*v+
w^2+2*v*w+v^2), v^25*u^4*w^12*(2*w+3*v),-2*u^3*v^18*w^9, u^8*v^48*w^24*(u^2+6*v^2+3*w
^2), v^13*u^2*w^6*(2*w+3*v), u^4*v^26*w^12*(3*u^2*w^2-4*v*w^3+3*v^4), u^2*v^12*w
^6*(2*u*v+4*v*w+3*v^2+w^2), u^4*v^25*w^12*(u*v+w^2+2*v*w+v^2), v^37*w^18*u^6*(-u
*w+3*v^2), u^10*v^60*w^30*(u^2+6*v^2+3*w^2), u^4*v^24*w^12*(2*u*v+4*v*w+3*v^2+w^
2), v^12*u^2*w^6*(u+6*v+3*w), 10*u^2*v^12*w^6, u^6*v^36*w^18*(2*u*v+4*v*w+3*v^2+
w^2), u^6*v^36*w^18*(u^2+6*v^2+3*w^2), v^24*u^4*w^12*(u+6*v+3*w), v^36*u^6*w^18*
(u+6*v+3*w), 10*u^10*v^60*w^30, 10*u^6*v^36*w^18, 10*u^4*v^24*w^12, 10*u^8*v^48*
w^24];end;
  f15:=function(u,v,w)return[15, 3*u+6*v+6*w, (v+w)^2, 
  2*u*v+2*u*w+4*v*w+u^2+3*v^2+3*w^2, 3*u^2+6*v^2+6*w^2,
-3*u*v*w+v^3+w^3, (v+w)*(v^2+w^2), -u*v*w, u*v^2+u*w^2+2*v*w^2+u^2*v+u^2*w+2*v^2
*w+u^3+3*v^3+3*w^3, 0, u^2*v^4*w^4*(w^9-w^6*v^3-w^5*v^4-w^4*v^5-w^3*v^6+v^9+w^5*
v^2*u^2+w^4*v^3*u^2+w^3*u^2*v^4+w^2*u^2*v^5+w^4*v^2*u^3+w^2*u^3*v^4+w^3*v^2*u^4+
w^2*v^3*u^4+w^2*v^2*u^5), (v^2-v*w+w^2)*(v+w)^2, 0, 2*u^2*v^2+2*u^2*w^2+4*v^2*w^
2+u^4+3*v^4+3*w^4, 3*u^2*v^2*w^3+3*u^2*v^3*w^2+3*u^3*v^2*w^2-2*v^3*w^4-2*v^4*w^3
+v^7+w^7, -u*v*w^2-u*v^2*w-u^2*v*w+v^4+w^4, u*v^2*w^2-v*w^4+u^2*v*w^2+u^2*v^2*w+
u^2*v^3+u^2*w^3+u^3*v^2+u^3*w^2-v^4*w+v^5+w^5, 0, 0, u*v^2*w^2, u^4*v^8*w^8*(v^4
-v^3*w+v^2*w^2-v*w^3+w^4)*(v+w)^2, -u*v*w^3-u*v^3*w-u^3*v*w+v^5+w^5, 0, -u^5*v^5
*w^5, 0, u^2*v^4*w^4*(3*u^2*v^2*w^4+3*u^2*v^4*w^2-2*v^3*w^5+3*u^4*v^2*w^2-2*v^5*
w^3+v^8+w^8), u*v^2*w^2*(2*v+2*w+3*u), 0, -v*w^5+3*u^2*v^2*w^2+u^2*v^4+u^2*w^4+v
^2*w^4-2*v^3*w^3+u^4*v^2+u^4*w^2+v^4*w^2-v^5*w+v^6+w^6,
u^2*v^4*w^4*(w^2+v^2+u^2),9*u^2*v^2*w^2
-4*v^3*w^3+v^6+w^6, -u^20*v^40*w^40*(3*u*v*w-v^3-w^3), u^4*v^8*w^8*(w^11-w^8*v^3
-w^7*v^4-w^4*v^7-w^3*v^8+v^11+w^7*v^2*u^2+w^6*v^3*u^2+w^3*v^6*u^2+w^2*u^2*v^7+w^
6*v^2*u^3+w^2*v^6*u^3+w^3*v^2*u^6+w^2*v^3*u^6+u^7*v^2*w^2),  u^5*v^10*w^10, 0,
3*u^2*
v^2*w^3+3*u^2*v^3*w^2+3*u^3*v^2*w^2-2*v^3*w^4-2*v^4*w^3+v^7+w^7, 0, -u^4*v^8*w^8
*(u*v*w^3+u*v^3*w+u^3*v*w-v^5-w^5), 0, u^2*v^4*w^4*(w^4+2*v*w^3+2*v^2*w^2+2*v^3*
w+v^4+2*w^3*u+2*v^3*u+u^2*w^2+u^2*v^2+u^4), u^2*v^4*w^4*(u+v+w), 0,
-u^4*v^8*w^8*(3*u*v*w-
v^3-w^3), u^2*v^4*w^4*(v^2-v*w+w^2)*(v+w)^2, -u^20*v^40*w^40*(u*v*w^2+u*v^2*w+u^
2*v*w-v^4-w^4), 0, 3*u^2*v^2*w^4+3*u^2*v^4*w^2-2*v^3*w^5+3*u^4*v^2*w^2-2*v^5*w^3
+v^8+w^8, 3*u^20*v^40*w^40*(2*v+2*w+u), -u^4*v^8*w^8*(u*v*w^2+u*v^2*w+u^2*v*w-v^
4-w^4), 0, u^3*v^6*w^6, -u^20*v^40*w^40*(u*v*w^3+u*v^3*w+u^3*v*w-v^5-w^5), u^4*v
^8*w^8*(2*u^2*v^2+2*u^2*w^2+4*v^2*w^2+u^4+3*v^4+3*w^4), 3*u^4*v^8*w^8*(u^2+2*v^2
+2*w^2), 0, u^20*v^40*w^40*(u*v^2+u*w^2+2*v*w^2+u^2*v+u^2*w+2*v^2*w+u^3+3*v^3+3*
w^3), u^2*v^4*w^4*(u*v^2+u*w^2+2*v*w^2+u^2*v+u^2*w+2*v^2*w+u^3+3*v^3+3*w^3), 
u^6*v^12*w^12*(v+w+u), 0, 3*u^2*v^4*w^4,
u^4*v^8*w^8*(u*v^2+u*w^2+2*v*w^2+u^2*v+u^2*w+2*v^2*w+u^3+3*v^3+3*w^3),
3*u^10*v^20*w^20, -u^8*v^16*w^16*(u*v*w^2+u*v^2*w+u^2*v*w-v^4-w^4),
0, 3*u^2*v^4*w^4*(u^2+2*v^2+2*w^2), u^4*v^8*w^8*(3*u^2*v^2*w^3+3*u^2*v^3*w^2+3*u
^3*v^2*w^2-2*v^3*w^4-2*v^4*w^3+v^7+w^7), 0, u^8*v^16*w^16*(w^8-v^3*w^5-2*v^4*w^4
-v^5*w^3+v^8+u^2*v^2*w^4+2*w^3*v^3*u^2+u^2*v^4*w^2+2*w^3*v^2*u^3+2*w^2*v^3*u^3+u
^4*v^2*w^2), 3*u^4*v^8*w^8*(2*w^4+2*v^4+u^4), u^12*v^24*w^24*(u*v^2+u*w^2+2*v*w^
2+u^2*v+u^2*w+2*v^2*w+u^3+3*v^3+3*w^3), u^4*v^8*w^8*(v^2-v*w+w^2)*(v+w)^2, 0, u^
4*v^8*w^8*(3*u^2*v^2*w^4+3*u^2*v^4*w^2-2*v^3*w^5+3*u^4*v^2*w^2-2*v^5*w^3+v^8+w^8
), -u^12*v^24*w^24*(u*v*w^2+u*v^2*w+u^2*v*w-v^4-w^4), -u^8*v^16*w^16*(3*u*v*w-v^
3-w^3), -u^16*v^32*w^32*(u*v*w^3+u*v^3*w+u^3*v*w-v^5-w^5), -u^16*v^32*w^32*(3*u*
v*w-v^3-w^3), -u^12*v^24*w^24*(u*v*w^3+u*v^3*w+u^3*v*w-v^5-w^5), u^5*v^10*w^10*(
2*v+2*w+3*u), u^8*v^16*w^16*(3*u^2*v^2*w^3+3*u^2*v^3*w^2+3*u^3*v^2*w^2-2*v^3*w^4
-2*v^4*w^3+v^7+w^7), u^4*v^8*w^8*(9*u^2*v^2*w^2-4*v^3*w^3+v^6+w^6), u^4*v^8*w^8*
(v+w)*(v^2+w^2), u^8*v^16*w^16*(v+w)^2, 3*u^6*v^12*w^12, 
3*u^16*v^32*w^32*(u^2+2*v^2+2*w^2), 
u^4*v^8*w^8*(v+w)^2, u^8*v^16*w^16*(9*u^2*v^2*w^2-4*v^3*w^3+v^6+w^6), u^4
*v^8*w^8*(2*u*v+2*u*w+4*v*w+u^2+3*v^2+3*w^2), u^8*v^16*w^16*(v+w)*(v^2+w^2), -u^
12*v^24*w^24*(3*u*v*w-v^3-w^3), 3*u^20*v^40*w^40*(u^2+2*v^2+2*w^2), u^8*v^16*w^
16*(2*u*v+2*u*w+4*v*w+u^2+3*v^2+3*w^2), 3*u^4*v^8*w^8*(2*v+2*w+u), 15*u^4*v^8*w^
8, u^12*v^24*w^24*(2*u*v+2*u*w+4*v*w+u^2+3*v^2+3*w^2), 3*u^12*v^24*w^24*(u^2+2*v
^2+2*w^2), 3*u^8*v^16*w^16*(2*v+2*w+u), 3*u^12*v^24*w^24*(2*v+2*w+u), 15*u^20*v^
40*w^40, 15*u^12*v^24*w^24, 15*u^8*v^16*w^16, 15*u^16*v^32*w^32];end;
  f15b:=function(u,v,w)return[15, 9*u+3*v+3*w, 2*u*(v+w+2*u), 
  4*u*v+4*u*w+2*v*w+5*u^2, 9*u^2+3*v^2+3*w^2, u*(-v*w+4*u^2), 2*u*(w+u)*(u+v), 
u^2*(v+w+u), 2*u*v^2+2*u*w^2+v*w^2+2*u^2*v+2*u^2*w+v^2*w+5*u^3, u^2*(-v*w+u^2), 
u^8*(v^5*w^6+v^6*w^5-u*v^3*w^7+u*v^5*w^5-u*v^7*w^3
-w^6*v^3*u^2-w^3*v^6*u^2-u^3*v^8-u^3*w^8-u^4*v^7-u^4*w^7+u^5*v^3*w^3+u^7*v^4+u^7
*w^4+u^11), u*(v*w^2+v^2*w+u*v^2+u*w^2+u^2*v+u^2*w+2*u^3), 0, 4*u^2*v^2+4*u^2*w^
2+2*v^2*w^2+5*u^4, u^2*(w^3*v^2+v^3*w^2+u*v^2*w^2-2*u*v^4-2*u*w^4-2*u^2*v^3-2*u^
2*w^3+4*u^5), u^2*(-v*w+u*v+u*w+2*u^2), u*(-v*w^3+v^2*w^2-v^3*w-v^3*u-w^3*u-2*u^
2*v*w+u^2*v^2+u^2*w^2+2*u^4), 0, u^4*(-v*w+u^2)*(u^2+v*w), -u^3*v*w, u^13*(v^6*w
^7+v^7*w^6+u*v^6*w^6+u^4*v^9+u^4*w^9+u^5*v^8+u^5*w^8+u^13), u^3*(-v*w+v^2+w^2+2*
u^2), u^14*v^4*w^4*(-v*w+u^2), u^10*(v^5+w^5+u^5), u^64*v^20*w^20*(-v*w+u^2)*(u^
2+v*w), u^8*(3*v^5*w^5-2*u*w^6*v^3-2*u*w^3*v^6-2*u^3*v^7-2*u^3*w^7+u^4*v^3*w^3+u
^6*v^4+u^6*w^4+u^10), u^4*(-v^2-w^2+u^2), 0, u*(-w^3*v^2-v^3*w^2+u*v^2*w^2-u^2*v
*w^2-u^2*v^2*w-u^2*v^3-u^2*w^3+2*u^3*v^2+2*u^3*w^2-u^4*v-u^4*w+2*u^5), 
-u^8*v^2*w^2,
u^2*(3*v^2*w^2-4*v^3*u-4*w^3*u+4*u^4), u^61*v^20*w^20*(-v*w+4*u^2), u^14*(v^8*
w^9+v^9*w^8-u*v^6*w^10+u*v^8*w^8-u*v^10*w^6-u^2*v^6*w^9-u^2*v^9*w^6+u^5*v^6*w^6-
u^5*v^12-u^5*w^12-u^6*v^11-u^6*w^11+u^9*v^8+u^9*w^8+u^17), -u^15*v^5*w^5, 0,
u^3*(-2
*v*w^3+3*v^2*w^2-2*v^3*w-2*v^3*u-2*w^3*u+u^3*v+u^3*w+2*u^4), u^16*v^4*w^4*(-v*w+
u^2)*(u^2+v*w), u^15*v^4*w^4*(-v*w+v^2+w^2+2*u^2), u^40*v^12*w^12*(-v*w+u^2)*(u^
2+v*w), u^6*(2*v^4*w^4+2*u*v^3*w^4+2*u*v^4*w^3+2*w^3*v^3*u^2+2*u^3*v^5+2*u^3*w^5
+u^4*v^4+u^4*w^4+u^8), -u^7*v^2*w^2, 0, u^13*v^4*w^4*(-v*w+4*u^2), u^7*(v^3*w^4+v^4
*w^3+u*w^3*v^3+u^2*v^5+u^2*w^5+u^3*v^4+u^3*w^4+u^7), u^62*v^20*w^20*(-v*w+u*v+u*
w+2*u^2), u^62*v^20*w^20*(-v*w+u^2), u^3*(-2*w^3*v^2-2*v^3*w^2+3*u*v^2*w^2-2*u^2
*v^3-2*u^2*w^3+u^3*v^2+u^3*w^2+2*u^5), 3*u^60*v^20*w^20*(v+w+3*u), u^14*v^4*w^4*
(-v*w+u*v+u*w+2*u^2), u^50*v^16*w^16*(-v*w+u^2), -u^9*v^3*w^3, u^63*v^20*w^20*(-
v*w+v^2+w^2+2*u^2), u^12*v^4*w^4*(4*u^2*v^2+4*u^2*w^2+2*v^2*w^2+5*u^4), 3*u^12*v
^4*w^4*(w^2+v^2+3*u^2), u^38*v^12*w^12*(-v*w+u^2), 
u^60*v^20*w^20*(2*u*v^2+2*u*w^2+v*w^2+2*u^2*v+2*u^2*w+v^2*w+5*u^3), 
u^6*(2*v^3*w^4+2*v^4*w^3+4*u*w^3*v^3+u^2*v^5+u^2*w^5+2*u^3*v^4+2*u^3*w^4+u^7),
-u^19*v^6*w^6, u^52*v^16*w^16*(-v*w+u^2)*(u^2+v*w),-u^6*v^2*w^2, 
u^12*v^4*w^4*(2*u*v^2+2*u*w^2+v*w^2+2*u^2*v+2*u^2*w+v^2*w+5*u^3),
-u^30*v^10*w^10,u^26*v^8*w^8*(-v*w+u*v+u*w+2*u^2),u^26*v^8*w^8*(-v*w+u^2),u^6
*(8*v^3*w^3+3*u^2*v^4+3*u^2*w^4+u^6), u^15*v^4*w^4*(-2*v*w^3+3*v^2*w^2-2*v^3*w-2
*v^3*u-2*w^3*u+u^3*v+u^3*w+2*u^4), 0, u^27*v^8*w^8*(-v*w^4+w^3*v^2+v^3*w^2-v^4*w
-u*w^4-u*v*w^3+u*v^2*w^2-u*v^3*w-u*v^4-u^2*w^3-u^2*v^3+u^4*w+u^4*v+2*u^5), u^12*
(8*v^6*w^6+3*u^4*v^8+3*u^4*w^8+u^12), u^36*v^12*w^12*(2*u*v^2+2*u*w^2+v*w^2+2*u^
2*v+2*u^2*w+v^2*w+5*u^3), u^13*v^4*w^4*(v*w^2+v^2*w+u*v^2+u*w^2+u^2*v+u^2*w+2*u^
3), u^28*v^8*w^8*(-v*w+u^2)*(u^2+v*w), u^15*v^4*w^4*(-2*w^3*v^2-2*v^3*w^2+3*u*v^
2*w^2-2*u^2*v^3-2*u^2*w^3+u^3*v^2+u^3*w^2+2*u^5), u^38*v^12*w^12*(-v*w+u*v+u*w+2
*u^2), u^25*v^8*w^8*(-v*w+4*u^2), u^51*v^16*w^16*(-v*w+v^2+w^2+2*u^2), u^49*v^16
*w^16*(-v*w+4*u^2), u^39*v^12*w^12*(-v*w+v^2+w^2+2*u^2), u^16*v^4*w^4*(-v^2-w^2+
u^2), u^27*v^8*w^8*(-2*v*w^3+3*v^2*w^2-2*v^3*w-2*v^3*u-2*w^3*u+u^3*v+u^3*w+2*u^4
), u^14*v^4*w^4*(3*v^2*w^2-4*v^3*u-4*w^3*u+4*u^4), 2*u^13*v^4*w^4*(w+u)*(u+v), 2
*u^25*v^8*w^8*(v+w+2*u),-u^18*v^6*w^6,3*u^48*v^16*w^16*(w^2+v^2+3*u^2), 2*u^13*v^4
*w^4*(v+w+2*u), u^26*v^8*w^8*(3*v^2*w^2-4*v^3*u-4*w^3*u+4*u^4), u^12*v^4*w^4*(4*
u*v+4*u*w+2*v*w+5*u^2), 2*u^25*v^8*w^8*(w+u)*(u+v), u^37*v^12*w^12*(-v*w+4*u^2),
3*u^60*v^20*w^20*(w^2+v^2+3*u^2), u^24*v^8*w^8*(4*u*v+4*u*w+2*v*w+5*u^2), 3*u^12
*v^4*w^4*(v+w+3*u), 15*u^12*v^4*w^4, u^36*v^12*w^12*(4*u*v+4*u*w+2*v*w+5*u^2), 3
*u^36*v^12*w^12*(w^2+v^2+3*u^2), 3*u^24*v^8*w^8*(v+w+3*u), 3*u^36*v^12*w^12*(v+w
+3*u), 15*u^60*v^20*w^20, 15*u^36*v^12*w^12, 15*u^24*v^8*w^8,15*u^48*v^16*w^16];
end;
  f20a:=function(u,v,w)return[20, 2*u+9*v+9*w, (v+2*w)*(2*v+w),
  2*(v+w)*(2*v+2*w+u), 2*u^2+9*v^2+9*w^2, -2*u*
v*w+2*v^3+2*w^3, u*v*w+3*v*w^2+3*v^2*w+v^3+w^3, v*w*(v+w), u*v^2+u*w^2+4*v*w^2+u
^2*v+u^2*w+4*v^2*w+4*v^3+4*w^3, -v^2*w^2, v^4*w^4*(w^9*u^2-w^6*v^3*u^2-u^2*v^4*w
^5-u^2*v^5*w^4-w^3*v^6*u^2+v^9*u^2+w^5*v^2*u^4+w^4*v^3*u^4+w^3*v^4*u^4+w^2*v^5*u
^4+w^11+w^4*v^2*u^5+w^2*v^4*u^5-w^8*v^3-w^7*v^4-v^5*w^6-v^6*w^5-w^4*v^7-w^3*v^8+
v^11), 2*v*w^3+u^2*v*w+2*v^2*w^2+2*v^3*w+v^4+w^4, 0, 2*(v^2+w^2)*(u^2+2*v^2+2*w^
2), 2*u^2*v^2*w^3+2*u^2*v^3*w^2+2*u^3*v^2*w^2-5*v^3*w^4-5*v^4*w^3+2*v^7+2*w^7, -
(v+w)*(u*v*w-v^3-w^3), -u*v*w^3-u*v^3*w-v*w^4+u^2*v*w^2+u^2*v^2*w+u^2*v^3+u^2*w^
3-w^3*v^2-v^3*w^2-v^4*w+v^5+w^5, 0, -v^4*w^4, 0, v^8*w^8*(w^6*u^4+w^5*v*u^4+w*v^
5*u^4+u^4*v^6+w^10+v*w^9+v^5*w^5+w*v^9+v^10), -(v^2+w^2)*(u*v*w-v^3-w^3), u^2*v^
11*w^11, v^5*w^5*(v+w)*(v^4-v^3*w+v^2*w^2-v*w^3+w^4), u^10*v^49*w^49, v^4*w^4*(u
^2*w^8-2*w^5*v^3*u^2-2*w^3*u^2*v^5+u^2*v^8+3*w^4*v^2*u^4+3*w^2*u^4*v^4+w^10-2*w^
7*v^3-2*v^5*w^5-2*w^3*v^7+v^10), v^2*w^2*(v+w)*(-v-w+2*u), 0, (v^2+w^2)*(v^4-2*v
^3*w+u^2*v^2+v^2*w^2-u^2*v*w-2*v*w^3+u^2*w^2+w^4), 0, 6*u^2*v^2*w^2-10*v
^3*w^3+2*v^6+2*w^6, 2*u^10*v^45*w^45*(u*v*w-v^3-w^3), w^8*v^8*(w^11*u^4-w^8*v^3*
u^4-w^7*v^4*u^4-w^4*v^7*u^4-w^3*v^8*u^4+v^11*u^4+w^7*v^2*u^6+w^6*v^3*u^6+w^3*v^6
*u^6+w^2*v^7*u^6+w^6*v^2*u^7+w^2*v^6*u^7+w^15-w^12*v^3-w^11*v^4-w^8*v^7-w^7*v^8-
w^4*v^11-w^3*v^12+v^15), 0, 0, -2*u*w^3*v^3+v*w^6+3*u^2*v^2*w^3+3*u^2*v^
3*w^2-4*v^3*w^4-4*v^4*w^3+v^6*w+v^7+w^7, u^2*v^13*w^13, u^2*(v^2+w^2)*v^9*w^9*(u
*v*w-v^3-w^3), u^6*v^31*w^31, v^4*w^4*(v+w)*(v^5+v^4*w+u^2*v^3+2*u^3*v^2+u^2*v^2
*w+u^2*v*w^2+v*w^4-2*u^3*v*w+w^5+u^2*w^3+2*u^3*w^2), 0, 0, 2*u^2*v^9*w^9
*(u*v*w-v^3-w^3), v^4*w^4*(u^2*w^4+u^2*v*w^3+u^2*v^3*w+u^2*v^4+w^6+v*w^5+v^3*w^3
+v^5*w+v^6), u^10*(v+w)*v^45*w^45*(u*v*w-v^3-w^3), u^10*v^47*w^47, 3*u^2*v^2*w^4
-2*w^3*v^3*u^2+3*u^2*v^4*w^2+w^6*v^2-4*v^3*w^5-4*v^5*w^3+v^6*w^2+v^8+w^8, -u^10*
v^45*w^45*(2*u+9*v+9*w), u^2*(v+w)*v^9*w^9*(u*v*w-v^3-w^3), -u^8*v^38*w^38, 0, u
^10*(v^2+w^2)*v^45*w^45*(u*v*w-v^3-w^3), -2*u^2*v^9*w^9*(v^2+w^2)*(u^2+2*v^2+2*w
^2), -u^2*v^9*w^9*(2*u^2+9*v^2+9*w^2), u^6*v^29*w^29, -u^10*v^45*w^45*(u*v^2+u*w
^2+4*v*w^2+u^2*v+u^2*w+4*v^2*w+4*v^3+4*w^3), v^4*w^4*(3*u^2*w^3+2*u^2*v*w^2+2*u^
2*v^2*w+3*u^2*v^3+u^3*w^2+u^3*v^2+2*w^5+v*w^4+w^3*v^2+v^3*w^2+v^4*w+2*v^5), 
0, -u^8*v^40*w^40, 0, -u^2*v^9*w^9*(u*v^2+u*w^2+4*v*w^2+u^2*v+u^2*w+4*v^
2*w+4*v^3+4*w^3), 0, -u^4*(v+w)*v^18*w^18*(u*v*w-v^3-w^3), -u^4*v^20*w^
20, v^4*w^4*(6*u^2*w^2+6*u^2*v^2+3*w^4+2*v^2*w^2+3*v^4), -u^2*v^9*w^9*(-2*u*w^3*
v^3+v*w^6+3*u^2*v^2*w^3+3*u^2*v^3*w^2-4*v^3*w^4-4*v^4*w^3+v^6*w+v^7+w^7), 0, u^4
*v^18*w^18*(v+w)*(v^7-2*v^4*w^3-2*v^3*w^4-u*w^3*v^3+u^2*v^3*w^2+u^2*v^2*w^3+u^3*
v^2*w^2+w^7), v^8*w^8*(6*u^4*w^4+6*u^4*v^4+3*w^8+2*v^4*w^4+3*v^8), -u^6*v^27*w^
27*(u*v^2+u*w^2+4*v*w^2+u^2*v+u^2*w+4*v^2*w+4*v^3+4*w^3), -u^2*v^9*w^9*(2*v*w^3+
u^2*v*w+2*v^2*w^2+2*v^3*w+v^4+w^4), -u^4*v^22*w^22, -u^2*v^9*w^9*(3*u^2*v^2*w^4
-2*w^3*v^3*u^2+3*u^2*v^4*w^2+w^6*v^2-4*v^3*w^5-4*v^5*w^3+v^6*w^2+v^8+w^8),
u^6*(v
+w)*v^27*w^27*(u*v*w-v^3-w^3), -2*u^4*v^18*w^18*(u*v*w-v^3-w^3), -u^8*(v^2+w^2)*
v^36*w^36*(u*v*w-v^3-w^3), -2*u^8*v^36*w^36*(u*v*w-v^3-w^3), u^6*(v^2+w^2)*v^27*
w^27*(u*v*w-v^3-w^3), -u^2*v^11*w^11*(v+w)*(-v-w+2*u), u^4*v^18*w^18*(-2*u*w^3*v
^3+v*w^6+3*u^2*v^2*w^3+3*u^2*v^3*w^2-4*v^3*w^4-4*v^4*w^3+v^6*w+v^7+w^7), -2*u^2*
v^9*w^9*(w^6-5*v^3*w^3+v^6+3*u^2*v^2*w^2), -u^2*v^9*w^9*(u*v*w+3*v*w^2+3*v^2*w+v
^3+w^3), u^4*v^18*w^18*(v+2*w)*(2*v+w), 0, u^8*v^36*w^36*(2*u^2+9*v^2+9*
w^2), -u^2*v^9*w^9*(v+2*w)*(2*v+w), 2*u^4*v^18*w^18*(w^6-5*v^3*w^3+v^6+3*u^2*v^2
*w^2), -2*u^2*(v+w)*v^9*w^9*(2*v+2*w+u), u^4*v^18*w^18*(u*v*w+3*v*w^2+3*v^2*w+v^
3+w^3), 2*u^6*v^27*w^27*(u*v*w-v^3-w^3), -u^10*v^45*w^45*(2*u^2+9*v^2+9*w^2), 2*
u^4*(v+w)*v^18*w^18*(2*v+2*w+u), -u^2*v^9*w^9*(2*u+9*v+9*w), -20*u^2*v^9*w^9, -2
*u^6*(v+w)*v^27*w^27*(2*v+2*w+u), -u^6*v^27*w^27*(2*u^2+9*v^2+9*w^2), u^4*v^18*w
^18*(2*u+9*v+9*w), -u^6*v^27*w^27*(2*u+9*v+9*w), -20*u^10*v^45*w^45, -20*u^6*v^
27*w^27, 20*u^4*v^18*w^18, 20*u^8*v^36*w^36];end;
  f20b:=function(u,v,w)return[20, 8*u+6*v+6*w, 2*u*v+2*u*w+u^2+v^2+w^2, 
4*u*v+4*u*w+6*v*w+4*u^2+v^2+w^2, 8*u^2+6*v^2+6*w^2, 
(v+w+u)*(v^2-v*w-u*v+w^2-u*w+u^2), 2*u*v*w+v*w^2+u^2*v+u^2*w+v^2*
w+u^3, 0, 2*u*v^2+2*u*w^2+3*v*w^2+2*u^2*v+2*u^2*w+3*v^2*w+4*u^3+v^3+w^3, -u^2*v*
w, u^4*v^2*w^2*(w^11+v^11+w^7*v^2*u^2+w^6*v^3*u^2+w^3*v^6*u^2+w^2*u^2*v^7-u^3*w^
8+w^6*v^2*u^3+w^2*u^3*v^6-u^3*v^8-u^4*w^7+w^4*v^3*u^4+w^3*v^4*u^4-u^4*v^7-w^5*v*
u^5+u^5*v^3*w^3-w*v^5*u^5-w^4*v*u^6-w*u^6*v^4+w*v*u^9), u*v*w^2+u*v^2*w+2*v^2*w^
2+u^3*v+u^3*w+u^4, 0, 4*u^2*v^2+4*u^2*w^2+6*v^2*w^2+4*u^4+v^4+w^4, 3*u^2*v^2*w^3
+3*u^2*v^3*w^2+3*u^3*v^2*w^2-2*u^3*v^4-2*u^3*w^4-2*u^4*v^3-2*u^4*w^3+u^7+v^7+w^7
, -u*v*w^2-u*v^2*w+v*w^3-u^2*v*w+v^3*w+u^4, -u*v*w^3+u*v^2*w^2-u*v^3*w+v*w^4+u^2
*v*w^2+u^2*v^2*w+w^3*v^2-2*u^3*v*w+u^3*v^2+u^3*w^2+v^3*w^2-u^4*v-u^4*w+v^4*w+u^5
, 0, -u^4*v^2*w^2, 0, u^8*v^4*w^4*(w^10+v^10+u*w^9+v^9*u+u^5*w^3*v^2+u^5*v^3*w^2
+u^6*v^2*w^2), -u*v*w^3-u*v^3*w+w^3*v^2-u^3*v*w+v^3*w^2+u^5, -u^10*v^7*w^7, 0, -
u^44*v^32*w^32, u^4*v^2*w^2*(w^10+v^10+3*v^2*u^2*w^6+3*w^2*u^2*v^6-2*u^3*w^7-2*u
^3*v^7+3*u^4*v^3*w^3-2*u^5*v*w^4-2*u^5*v^4*w+w*v*u^8), 2*u^2*v*w*(v^2+w^2), 0, -
u*v^2*w^3-u*v^3*w^2+3*u^2*v^2*w^2+u^2*v^4+u^2*w^4+2*v^2*w^4-u^3*v*w^2-u^3*v^2*w-
u^3*v^3-u^3*w^3+u^4*v^2+u^4*w^2+2*v^4*w^2-u^5*v-u^5*w+u^6, 
u^4*v^3*w^5+u^4*v^5*w^3+2*u^6*v^3*w^3,
9*u^2*v^2*w^2-4*u^3*v^3-4*u^3*w^3+u^6+v^6+w^6, 
u^40*v^30*w^30*(v+w+u)*(v^2-v*w-u*v+w^2-u*w+u^2), 
u^8*v^4*w^4*(w^15+v^15+w^11*v^2*u^2+w^10*v^3*u^2+w^3*u^2*v^10+w^2*v^11*u^
2-w^12*u^3+w^10*v^2*u^3+w^2*v^10*u^3-v^12*u^3-w^11*u^4-v^11*u^4+w^5*u^6*v^4+w^4*
u^6*v^5-w^6*v^2*u^7+w^4*u^7*v^4-w^2*v^6*u^7-w^5*u^8*v^2-w^2*u^8*v^5+w^2*v^2*u^11
), 0, 0, v*w^6+3*u^2*v^2*w^3+3*u^2*v^3*w^2-2*u^3*v*w^3+3*u^3*v^2*w^2-2*u
^3*v^3*w-2*u^4*v^3-2*u^4*w^3+v^6*w+u^7, -u^12*v^8*w^8, u^8*v^6*w^6*(-u*v*w^3-u*v
^3*w+w^3*v^2-u^3*v*w+v^3*w^2+u^5), -u^28*v^20*w^20, u^4*v^2*w^2*(w^6+2*v*w^5+2*v
^5*w+v^6+2*w^5*u+2*v^5*u+u^2*w^4+2*u^2*v^2*w^2+u^2*v^4+2*u^3*v*w^2+2*u^3*v^2*w+2
*w*v*u^4), 
# a=+-1
u^4*v^3*w^3*(Mvp("a")*(u+v+w)+u), 0,
u^8*v^6*w^6*(v+w+u)*(v^2-v*w-u*v+w^2-u*w+u^2), u^4*v^2*
w^2*(w^6+v^6+w^5*u+v^5*u+u^3*v*w^2+u^3*v^2*w+w*v*u^4), u^40*v^30*w^30*(-u*v*w^2-
u*v^2*w+v*w^3-u^2*v*w+v^3*w+u^4), -u^42*v^31*w^31, 3*u^2*v^2*w^4+3*u^2*v^4*w^2+w
^6*v^2-2*w^3*v^2*u^3-2*w^2*v^3*u^3+3*u^4*v^2*w^2-2*u^5*v^3-2*u^5*w^3+v^6*w^2+u^8
, 2*u^40*v^30*w^30*(3*v+3*w+4*u), u^8*v^6*w^6*(-u*v*w^2-u*v^2*w+v*w^3-u^2*v*w+v^
3*w+u^4), -u^34*v^25*w^25, 0, u^40*v^30*w^30*(-u*v*w^3-u*v^3*w+w^3*v^2-u^3*v*w+v
^3*w^2+u^5), u^8*v^6*w^6*(4*u^2*v^2+4*u^2*w^2+6*v^2*w^2+4*u^4+v^4+w^4), 2*u^8*v^
6*w^6*(3*w^2+3*v^2+4*u^2), -u^26*v^19*w^19, u^40*v^30*w^30*(2*u*v^2+2*u*w^2+3*v*
w^2+2*u^2*v+2*u^2*w+3*v^2*w+4*u^3+v^3+w^3), u^4*v^2*w^2*(3*w^5+v*w^4+v^4*w+3*v^5
+2*w^4*u+2*v^4*u+2*u^2*v*w^2+2*u^2*v^2*w+4*u^3*v*w), 
u^12*v^9*w^9*(Mvp("a")*(u+v+w)+u), -u^36*v^26*w^26,
4*u^4*v^3*w^3, u^8*v^6*w^6*(2*u*v^2+2*u*w^2+3*v*w^2+2*u^2*v+2*u^2*w+3*v^2*w+4*u^
3+v^3+w^3), 4*u^20*v^15*w^15, u^16*v^12*w^12*(-u*v*w^2-u*v^2*w+v*w^3-u^2*v*w+v^3*w+u^4)
, -u^18*v^13*w^13, 2*u^4*v^2*w^2*(3*w^4+3*v^4+4*u^2*v*w), u^8*v^6*w^6*(v*w^6+3*u
^2*v^2*w^3+3*u^2*v^3*w^2-2*u^3*v*w^3+3*u^3*v^2*w^2-2*u^3*v^3*w-2*u^4*v^3-2*u^4*w
^3+v^6*w+u^7), 0, u^16*v^12*w^12*(v*w^7+w*v^7+u^2*v^2*w^4+2*w^3*v^3*u^2+u^2*v^4*
w^2-v*u^3*w^4+2*w^3*v^2*u^3+2*w^2*v^3*u^3-w*v^4*u^3-u^4*w^4-v*u^4*w^3+u^4*v^2*w^
2-u^4*v^3*w-u^4*v^4-u^5*w^3-u^5*v^3+u^8), 2*u^8*v^4*w^4*(3*w^8+3*v^8+4*u^4*v^2*w
^2), u^24*v^18*w^18*(2*u*v^2+2*u*w^2+3*v*w^2+2*u^2*v+2*u^2*w+3*v^2*w+4*u^3+v^3+w
^3), u^8*v^6*w^6*(u*v*w^2+u*v^2*w+2*v^2*w^2+u^3*v+u^3*w+u^4), -u^20*v^14*w^14, u
^8*v^6*w^6*(3*u^2*v^2*w^4+3*u^2*v^4*w^2+w^6*v^2-2*w^3*v^2*u^3-2*w^2*v^3*u^3+3*u^
4*v^2*w^2-2*u^5*v^3-2*u^5*w^3+v^6*w^2+u^8), u^24*v^18*w^18*(-u*v*w^2-u*v^2*w+v*w
^3-u^2*v*w+v^3*w+u^4), u^16*v^12*w^12*(v+w+u)*(v^2-v*w-u*v+w^2-u*w+u^2), u^32*v^
24*w^24*(-u*v*w^3-u*v^3*w+w^3*v^2-u^3*v*w+v^3*w^2+u^5), u^32*v^24*w^24*(v+w+u)*(
v^2-v*w-u*v+w^2-u*w+u^2), u^24*v^18*w^18*(-u*v*w^3-u*v^3*w+w^3*v^2-u^3*v*w+v^3*w
^2+u^5), 2*u^10*v^7*w^7*(v^2+w^2), u^16*v^12*w^12*(v*w^6+3*u^2*v^2*w^3+3*u^2*v^3
*w^2-2*u^3*v*w^3+3*u^3*v^2*w^2-2*u^3*v^3*w-2*u^4*v^3-2*u^4*w^3+v^6*w+u^7), u^8*v
^6*w^6*(9*u^2*v^2*w^2-4*u^3*v^3-4*u^3*w^3+u^6+v^6+w^6), u^8*v^6*w^6*(2*u*v*w+v*w
^2+u^2*v+u^2*w+v^2*w+u^3), u^16*v^12*w^12*(2*u*v+2*u*w+u^2+v^2+w^2), 4*u^12*v^9*w^9,
2*u^32*v^24*w^24*(3*w^2+3*v^2+4*u^2), u^8*v^6*w^6*(2*u*v+2*u*w+u^2+v^2+w^2), u^
16*v^12*w^12*(9*u^2*v^2*w^2-4*u^3*v^3-4*u^3*w^3+u^6+v^6+w^6), u^8*v^6*w^6*(4*u*v
+4*u*w+6*v*w+4*u^2+v^2+w^2), u^16*v^12*w^12*(2*u*v*w+v*w^2+u^2*v+u^2*w+v^2*w+u^3
), u^24*v^18*w^18*(v+w+u)*(v^2-v*w-u*v+w^2-u*w+u^2), 2*u^40*v^30*w^30*(3*w^2+3*v
^2+4*u^2), u^16*v^12*w^12*(4*u*v+4*u*w+6*v*w+4*u^2+v^2+w^2), 2*u^8*v^6*w^6*(3*v+
3*w+4*u), 20*u^8*v^6*w^6, u^24*v^18*w^18*(4*u*v+4*u*w+6*v*w+4*u^2+v^2+w^2), 2*u^
24*v^18*w^18*(3*w^2+3*v^2+4*u^2), 2*u^16*v^12*w^12*(3*v+3*w+4*u), 2*u^24*v^18*w^
18*(3*v+3*w+4*u), 20*u^40*v^30*w^30, 20*u^24*v^18*w^18, 20*u^16*v^12*w^12, 20*u^
32*v^24*w^24];end;
  f20c:=function(u,v,w)return[20, 6*u+11*v+3*w, v*(4*v+4*u+w), 6*u*v+2*u*w+4*v*w+2*u^2+6*v^2, 6*u^2+11*v^2+3*
w^2, -2*v*(-2*v^2+u*w), v*(u+2*v)*(v+w+u), v^2*(u+v), 3*u*v^2+u*w^2+2*v*w^2+3*u^
2*v+u^2*w+2*v^2*w+2*u^3+6*v^3, -v^2*(u*w+u^2-v^2), -v^8*(v*u^3*w^7+w^6*v^2*u^3-v
^5*u^3*w^3-w^2*v^5*u^4-u^4*v^7-u^5*w^6-w^5*v*u^5-2*u^6*w^5-w^4*v*u^6+u^6*v^2*w^3
-u^7*w^4+u^7*v*w^3+u^7*v^2*w^2+v^4*u^7+v*u^8*w^2+u^8*v^3+v^2*u^9+v*u^10-v^11), v
*(u*w^2+2*u*v^2+u^2*v+v*w^2+u^3+v^2*w+2*v^3), 0, 6*u^2*v^2+2*u^2*w^2+4*v^2*w^2+2
*u^4+6*v^4, -v^2*(-2*u^2*w^3-2*u^2*v*w^2-2*u^3*w^2+4*u^3*v^2+v*w^4+4*u^4*v+w^3*v
^2-4*v^5), -v*(u*v*w-u*v^2+u^2*w-v^2*w-2*v^3), u*v^2*w^2-u*v^3*w-v^4*u+u^2*v*w^2
-w^3*v^2-u^3*v*w-u^3*v^2+u^3*w^2+v^3*w^2-u^4*v+2*v^5, 0, -v^4*(u^2*w^2+u^4-v^4),
0, v^13*(u^6*w^7+v*u^6*w^6+u^7*w^6+u^8*v*w^4+v^5*u^8+u^9*w^4+v^4*u^9+u^13+v^13),
-v*(u*v^2*w-u^2*v^2+u^3*w-v^2*w^2-2*v^4), u^6*v^13*w^3*(u*w+u^2-v^2), v^10*(u+v)
*(u^4-u^3*v+u^2*v^2-u*v^3+v^4), u^30*v^59*w^15*(u^2*w^2+u^4-v^4), -v^8*(2*v*u^3*
w^6-u^3*v^4*w^3-w^2*u^4*v^4-u^4*v^6-3*u^5*w^5-3*u^6*w^4+2*v*u^6*w^3+2*v*u^7*w^2+
2*u^7*v^3+2*v*u^9-v^10), -v^3*(-2*u^2*w+u^2*v+2*u^3-v^3), 0, -u*v^3*w^2-2*v^5*u+
2*u^2*v^2*w^2+2*u^2*v^4-u^3*v*w^2-3*u^3*v^3-v^3*w^3+u^4*v^2+u^4*w^2+2*v^4*w^2-u^
5*v-v^5*w+2*v^6, 0, -2*v^2*(-3*u^2*w^2+4*u^3*v+v*w^3-2*v^4), 2*u^30*v^56
*w^15*(-2*v^2+u*w), -v^14*(v*u^6*w^10+v^2*u^6*w^9-v^5*u^6*w^6-u^8*w^9-v*u^8*w^8-
v^5*u^8*w^4-v^9*u^8-u^9*w^8+v^2*u^9*w^6-u^10*w^7-u^11*w^6+v^2*u^11*w^4+v^6*u^11+
v*u^12*w^4+v^5*u^12+v^2*u^15+v*u^16-v^17), 0, 0, -v^2*(-v^4*u-3*u^2*v*w^
2-3*u^3*w^2+2*u^3*v*w+4*u^3*v^2+2*u^4*v+2*w^3*v^2-v^4*w-2*v^5), u^6*v^15*w^3*(u^
2*w^2+u^4-v^4), u^6*v^12*w^3*(u*v^2*w-u^2*v^2+u^3*w-v^2*w^2-2*v^4), u^18*v^37*w^
9*(u^2*w^2+u^4-v^4), v^6*(2*v*u^3*w^4+2*w^3*v^2*u^3+2*u^4*w^4+4*v*u^4*w^3+u^4*v^
2*w^2+u^4*v^4+2*u^5*v*w^2+2*u^5*v^3+u^6*w^2+u^6*v^2+u^8+v^8), 0, 0, 2*u^
6*w^3*v^12*(-2*v^2+u*w), v^7*(u^3*w^4+u^3*v*w^3+u^4*w^3+u^4*v*w^2+u^4*v^3+u^5*w^
2+u^5*v^2+u^7+v^7), u^30*v^56*w^15*(u*v*w-u*v^2+u^2*w-v^2*w-2*v^3), u^30*v^57*w^
15*(u*w+u^2-v^2), -v^2*(-3*u^2*v^2*w^2-u^2*v^4+2*u^3*v*w^2+4*u^3*v^3-3*u^4*w^2+2
*u^5*v+2*v^3*w^3-v^4*w^2-2*v^6), -u^30*v^55*w^15*(6*u+11*v+3*w), u^6*v^12*w^3*(u
*v*w-u*v^2+u^2*w-v^2*w-2*v^3), -u^24*v^46*w^12*(u*w+u^2-v^2), 0, u^30*v^56*w^15*
(u*v^2*w-u^2*v^2+u^3*w-v^2*w^2-2*v^4), -2*u^6*v^11*w^3*(2*v^2*w^2+3*v^4+u^2*w^2+
3*u^2*v^2+u^4), -u^6*v^11*w^3*(6*u^2+11*v^2+3*w^2), u^18*v^35*w^9*(u*w+u^2-v^2),
-u^30*v^55*w^15*(3*u*v^2+u*w^2+2*v*w^2+3*u^2*v+u^2*w+2*v^2*w+2*u^3+6*v^3), v^6*(
2*u^3*w^4+4*u^3*v*w^3+3*u^4*w^3+3*u^4*v*w^2+2*u^4*v^3+2*u^5*w^2+u^5*v^2+u^6*v+u^
7+v^7), 0, -u^24*v^48*w^12*(u^2*w^2+u^4-v^4), 0, -u^6*v^11*w^3*(3*u*v^2+
u*w^2+2*v*w^2+3*u^2*v+u^2*w+2*v^2*w+2*u^3+6*v^3), 0, -u^12*v^23*w^6*(u*v
*w-u*v^2+u^2*w-v^2*w-2*v^3), -u^12*v^24*w^6*(u*w+u^2-v^2), v^6*(8*u^3*w^3+6*u^4*
w^2+3*u^4*v^2+2*u^6+v^6), u^6*v^13*w^3*(-v^4*u-3*u^2*v*w^2-3*u^3*w^2+2*u^3*v*w+4
*u^3*v^2+2*u^4*v+2*w^3*v^2-v^4*w-2*v^5), 0, -u^12*v^24*w^6*(v^2*w^4+v^3*w^3-v^5*
w-2*v^6-v^5*u-u^2*v*w^3-u^2*v^2*w^2-u^3*w^3-2*u^3*v*w^2+u^3*v^2*w+2*u^3*v^3-u^4*
w^2+w*v*u^4+3*u^4*v^2+u^5*v), v^12*(8*u^6*w^6+6*u^8*w^4+3*v^4*u^8+2*u^12+v^12),
-u^18*v^33*w^9*(3*u*v^2+u*w^2+2*v*w^2+3*u^2*v+u^2*w+2*v^2*w+2*u^3+6*v^3), -u^6*v
^12*w^3*(u*w^2+2*u*v^2+u^2*v+v*w^2+u^3+v^2*w+2*v^3), -u^12*v^26*w^6*(u^2*w^2+u^4
-v^4), u^6*v^13*w^3*(-3*u^2*v^2*w^2-u^2*v^4+2*u^3*v*w^2+4*u^3*v^3-3*u^4*w^2+2*u^
5*v+2*v^3*w^3-v^4*w^2-2*v^6), u^18*v^34*w^9*(u*v*w-u*v^2+u^2*w-v^2*w-2*v^3), -2*
u^12*v^23*w^6*(-2*v^2+u*w), -u^24*v^45*w^12*(u*v^2*w-u^2*v^2+u^3*w-v^2*w^2-2*v^4
), -2*u^24*v^45*w^12*(-2*v^2+u*w), u^18*v^34*w^9*(u*v^2*w-u^2*v^2+u^3*w-v^2*w^2-\
2*v^4), u^6*v^14*w^3*(-2*u^2*w+u^2*v+2*u^3-v^3), -u^12*v^24*w^6*(-v^4*u-3*u^2*v*
w^2-3*u^3*w^2+2*u^3*v*w+4*u^3*v^2+2*u^4*v+2*w^3*v^2-v^4*w-2*v^5), 2*u^6*v^13*w^3
*(-3*u^2*w^2+4*u^3*v+v*w^3-2*v^4), -u^6*v^12*w^3*(u+2*v)*(v+w+u), u^12*v^23*w^6*
(4*v+4*u+w), 0, u^24*v^44*w^12*(6*u^2+11*v^2+3*w^2), -u^6*v^12*w^3*(4*v+
4*u+w), -2*u^12*v^24*w^6*(-3*u^2*w^2+4*u^3*v+v*w^3-2*v^4), -2*u^6*v^11*w^3*(2*v*
w+3*v^2+u*w+3*u*v+u^2), u^12*v^23*w^6*(u+2*v)*(v+w+u), 2*u^18*v^34*w^9*(-2*v^2+u
*w), -u^30*v^55*w^15*(6*u^2+11*v^2+3*w^2), 2*u^12*v^22*w^6*(2*v*w+3*v^2+u*w+3*u*
v+u^2), -u^6*v^11*w^3*(6*u+11*v+3*w), -20*u^6*v^11*w^3, -2*u^18*v^33*w^9*(2*v*w+
3*v^2+u*w+3*u*v+u^2), -u^18*v^33*w^9*(6*u^2+11*v^2+3*w^2), u^12*v^22*w^6*(6*u+11
*v+3*w), -u^18*v^33*w^9*(6*u+11*v+3*w), -20*u^30*v^55*w^15, -20*u^18*v^33*w^9, 
20*u^12*v^22*w^6, 20*u^24*v^44*w^12];end;
  f20d:=function(u,v,w)return [20, 3*u+8*v+9*w, u*w+4*v*w+2*v^2+2*w^2, 4*u*v+2*u*w+8*v*w+2*v^2+4*w^2, 3*u^2+8*
v^2+9*w^2, -2*u*v*w+2*v^3+2*w^3, 2*u*v*w+u*v^2+3*v*w^2+2*v^2*w+w^3, v*w*(w+v), 2
*u*v^2+u*w^2+4*v*w^2+2*u^2*v+u^2*w+4*v^2*w+2*v^3+4*w^3, -u*v*w^2, -v^3*w^4*(u^2*
v^6*w^4+w^3*v^7*u^2-v^10*u^2-u^3*w^9+v^3*u^3*w^6+w^5*v^4*u^3-w^3*v^5*u^4-u^4*v^6
*w^2-v*w^11-w^5*v^2*u^5-w^4*v^3*u^5-w^2*v^5*u^5+u^6*w^6-u^6*v^2*w^4+w^5*u^7+v^4*
w^8+v^5*w^7+v^8*w^4+w^3*v^9-v^12), u*v^2*w+2*v*w^3+u^2*v*w+u^2*v^2+2*v^2*w^2+v^3
*w+w^4, 0, 4*u^2*v^2+2*u^2*w^2+8*v^2*w^2+2*v^4+4*w^4, 2*u^2*v^2*w^3+2*u^2*v^3*w^
2+2*u^3*v^2*w^2-u^3*w^4-4*v^3*w^4-u^4*w^3-4*v^4*w^3+2*v^7+2*w^7, -u*v*w^2-u*v^2*
w+u*v^3+v*w^3+v^3*w+w^4, -2*u*v*w^3-u*v^3*w+v^4*u-v*w^4+u^2*v*w^2+u^2*v^2*w+u^2*
v^3+u^2*w^3-u^3*v*w-v^3*w^2+w^5, 0, -u^2*v^2*w^4, 0, v^6*w^8*(w*v^7*u^4+u^4*v^8+
u^6*w^6+w^5*v*u^6+w^5*u^7+v^2*w^10+v^3*w^9+w*v^11+v^12), -u*v*w^3-u*v^3*w+u^2*v^
3+w^3*v^2+v^3*w^2+w^5, u^4*v^9*w^11, v^5*w^5*(w+v)*(w^4-v*w^3+v^2*w^2-v^3*w+v^4)
, u^17*v^42*w^49, -v^3*w^4*(2*w^3*v^6*u^2-v^9*u^2-u^3*w^8+2*w^5*v^3*u^3-3*w^2*v^
5*u^4-v*w^10-3*w^4*v^2*u^5+2*u^6*w^5+2*v^4*w^7+2*w^3*v^8-v^11), v^2*w^2*(-v^2+2*
u*v-w^2), 0, -u*v^2*w^3-2*v*w^5-u^2*v*w^3+2*u^2*v^2*w^2-u^2*v^3*w+2*u^2*v^4+u^2*
w^4+2*v^2*w^4-u^3*v^2*w-3*v^3*w^3+2*v^4*w^2-v^5*w+w^6, 0, 6*u^2*v^2*w^2-\
2*u^3*w^3-8*v^3*w^3+2*v^6+2*w^6, 2*u^15*v^40*w^45*(-v^3+u*v*w-w^3), -v^6*w^8*(w^
4*u^4*v^9+w^3*v^10*u^4-v^13*u^4-w^11*u^6+w^8*v^3*u^6+w^7*v^4*u^6-w^3*v^8*u^6-w^2
*v^9*u^6-w^2*v^8*u^7-w^7*v^2*u^8-w^6*v^3*u^8-v^2*w^15+u^9*w^8-v^2*u^9*w^6+u^10*w
^7+w^12*v^5+w^11*v^6+v^13*w^4+v^14*w^3-v^17), 0, 0, -2*u*v^3*w^3+u*v^6+v
*w^6+3*u^2*v^2*w^3+3*u^2*v^3*w^2-2*u^3*v*w^3-4*v^3*w^4-2*v^4*w^3+v^6*w+w^7, u^5*
v^10*w^13, -u^3*v^8*w^9*(-u*v*w^3-u*v^3*w+u^2*v^3+w^3*v^2+v^3*w^2+w^5), u^11*v^
26*w^31, v^3*w^4*(u^2*v^3*w^2+2*w*v^4*u^2+v^5*u^2+2*u^3*w^4+2*u^3*v*w^3+2*u^3*v^
4+2*u^4*w^3+2*u^4*v*w^2+v*w^6+2*v^2*w^5+2*v^6*w+v^7), 0, 0, 2*u^3*v^8*w^
9*(-v^3+u*v*w-w^3), v^3*w^4*(w*v^4*u^2+v^5*u^2+u^3*w^4+u^3*v*w^3+u^4*w^3+v*w^6+v
^2*w^5+v^6*w+v^7), -u^15*v^40*w^45*(-u*v*w^2-u*v^2*w+u*v^3+v*w^3+v^3*w+w^4), u^
16*v^41*w^47, 3*u^2*v^2*w^4-2*w^3*v^3*u^2+3*u^2*v^4*w^2+u^2*v^6+w^6*v^2-2*w^3*v^
2*u^3-4*v^3*w^5-2*v^5*w^3+v^6*w^2+w^8, -u^15*v^40*w^45*(3*u+8*v+9*w), -u^3*v^8*w
^9*(-u*v*w^2-u*v^2*w+u*v^3+v*w^3+v^3*w+w^4), -u^13*v^33*w^38, 0, -u^15*v^40*w^45
*(-u*v*w^3-u*v^3*w+u^2*v^3+w^3*v^2+v^3*w^2+w^5), -2*u^3*v^8*w^9*(2*w^4+4*v^2*w^2
+v^4+u^2*w^2+2*u^2*v^2), -u^3*v^8*w^9*(3*u^2+8*v^2+9*w^2), u^10*v^25*w^29, -u^15
*v^40*w^45*(2*u*v^2+u*w^2+4*v*w^2+2*u^2*v+u^2*w+4*v^2*w+2*v^3+4*w^3), v^3*w^4*(2
*u^2*v^3*w+3*u^2*v^4+4*u^3*w^3+2*u^3*v*w^2+u^3*v^3+2*u^4*w^2+2*v*w^5+v^2*w^4+v^5
*w+2*v^6), 0, -u^14*v^34*w^40, 0, -u^3*v^8*w^9*(2*u*v^2+u*w^2+4*v*w^2+2*
u^2*v+u^2*w+4*v^2*w+2*v^3+4*w^3), 0, u^6*v^16*w^18*(-u*v*w^2-u*v^2*w+u*v
^3+v*w^3+v^3*w+w^4), -u^7*v^17*w^20, v^3*w^4*(6*u^2*v^3+8*u^3*w^2+3*v*w^4+3*v^5)
, u^3*v^8*w^9*(-w^7-v*w^6+4*v^3*w^4+2*v^4*w^3-v^6*w+2*u*v^3*w^3-u*v^6-3*u^2*v^2*
w^3-3*u^2*v^3*w^2+2*u^3*v*w^3), 0, -u^6*v^16*w^18*(-w^8-w^7*v+2*v^3*w^5+3*w^4*v^
4+v^5*w^3-w*v^7+w^4*v^3*u+w^3*v^4*u-v^7*u-u^2*v^2*w^4-2*w^3*v^3*u^2-u^2*v^4*w^2+
v*u^3*w^4-w^3*v^2*u^3-w^2*v^3*u^3+v*u^4*w^3), v^6*w^8*(6*u^4*v^6+8*u^6*w^4+3*v^2
*w^8+3*v^10), -u^9*v^24*w^27*(2*u*v^2+u*w^2+4*v*w^2+2*u^2*v+u^2*w+4*v^2*w+2*v^3+
4*w^3), -u^3*v^8*w^9*(u*v^2*w+2*v*w^3+u^2*v*w+u^2*v^2+2*v^2*w^2+v^3*w+w^4), -u^8
*v^18*w^22, u^3*v^8*w^9*(-w^8-w^6*v^2+4*v^3*w^5+2*v^5*w^3-v^6*w^2-3*u^2*v^2*w^4+
2*w^3*v^3*u^2-3*u^2*v^4*w^2-u^2*v^6+2*w^3*v^2*u^3), -u^9*v^24*w^27*(-u*v*w^2-u*v
^2*w+u*v^3+v*w^3+v^3*w+w^4), -2*u^6*v^16*w^18*(-v^3+u*v*w-w^3), u^12*v^32*w^36*(
-u*v*w^3-u*v^3*w+u^2*v^3+w^3*v^2+v^3*w^2+w^5), -2*u^12*v^32*w^36*(-v^3+u*v*w-w^3
), -u^9*v^24*w^27*(-u*v*w^3-u*v^3*w+u^2*v^3+w^3*v^2+v^3*w^2+w^5), -u^3*v^10*w^11
*(-v^2+2*u*v-w^2), -u^6*v^16*w^18*(-w^7-v*w^6+4*v^3*w^4+2*v^4*w^3-v^6*w+2*u*v^3*
w^3-u*v^6-3*u^2*v^2*w^3-3*u^2*v^3*w^2+2*u^3*v*w^3), 2*u^3*v^8*w^9*(-w^6+4*v^3*w^
3-v^6-3*u^2*v^2*w^2+u^3*w^3), -u^3*v^8*w^9*(2*u*v*w+u*v^2+3*v*w^2+2*v^2*w+w^3),
u^6*v^16*w^18*(u*w+4*v*w+2*v^2+2*w^2), 0, u^12*v^32*w^36*(3*u^2+8*v^2+9*
w^2), -u^3*v^8*w^9*(u*w+4*v*w+2*v^2+2*w^2), -2*u^6*v^16*w^18*(-w^6+4*v^3*w^3-v^6
-3*u^2*v^2*w^2+u^3*w^3), -2*u^3*v^8*w^9*(v^2+4*v*w+2*u*v+2*w^2+u*w), u^6*v^16*w^
18*(2*u*v*w+u*v^2+3*v*w^2+2*v^2*w+w^3), 2*u^9*v^24*w^27*(-v^3+u*v*w-w^3), -u^15*
v^40*w^45*(3*u^2+8*v^2+9*w^2), 2*u^6*v^16*w^18*(v^2+4*v*w+2*u*v+2*w^2+u*w), -u^3
*v^8*w^9*(3*u+8*v+9*w), -20*u^3*v^8*w^9, -2*u^9*v^24*w^27*(v^2+4*v*w+2*u*v+2*w^2
+u*w), -u^9*v^24*w^27*(3*u^2+8*v^2+9*w^2), u^6*v^16*w^18*(3*u+8*v+9*w), -u^9*v^
24*w^27*(3*u+8*v+9*w), -20*u^15*v^40*w^45, -20*u^9*v^24*w^27, 20*u^6*v^16*w^18,
20*u^12*v^32*w^36];end;
  f24:=function(u,v,w)return[24, 12*u+6*v+6*w, 2*u*(v+w+2*u), 6*u*v+6*u*w+2*v*w+6*u^2+2*v^2+2*w^2, 12*u^2+6*
v^2+6*w^2, 4*u*(-v*w+u^2), u*(v^2+w^2+2*u*v+2*u*w+2*u^2), u*(-v*w+u^2), 3*u*v^2+
3*u*w^2+v*w^2+3*u^2*v+3*u^2*w+v^2*w+6*u^3+2*v^3+2*w^3, u^2*(-v*w+u^2), u^6*(v^6*
w^7+v^7*w^6+u*v^6*w^6+u^2*v^4*w^7+2*u^2*v^5*w^6+2*u^2*v^6*w^5+u^2*v^7*w^4-u^3*v^
2*w^8-u^3*v^3*w^7+u^3*v^4*w^6+u^3*v^5*w^5+u^3*v^6*w^4-u^3*v^7*w^3-u^3*v^8*w^2-u^
4*v^2*w^7-u^4*v^3*w^6-u^4*v^6*w^3-u^4*v^7*w^2+u^7*v^2*w^4+u^7*v^3*w^3+u^7*v^4*w^
2+u^13), u*(v^3+w^3+u*v^2+u*w^2+u^2*v+u^2*w+2*u^3), -u^2*v*w, 6*u^2*v^2+6*u^2*w^
2+2*v^2*w^2+6*u^4+2*v^4+2*w^4, 2*u^2*(2*w^3*v^2+2*v^3*w^2+2*u*v^2*w^2-v^4*u-w^4*
u-u^2*v^3-u^2*w^3+2*u^5), u*(v+w+2*u)*(-v*w+u^2), 2*u*v^2*w^2-v^4*u-w^4*u+u^2*v*
w^2+u^2*v^2*w+w^3*v^2+u^3*v^2+u^3*w^2+v^3*w^2+2*u^5, -u^4*v^2*w^2, u^4*(-v*w+u^2
)*(v*w+u^2), 0, u^13*(v^4*w^9+v^6*w^7+v^7*w^6+v^9*w^4+u*v^4*w^8+u*v^6*w^6+u*v^8*
w^4+u^13), u*(-v*w+u^2)*(2*u^2+v^2+w^2), v^5*u^12*w^5*(-v*w+u^2), u^5*(-v*w+u^2)
*(u^8+u^6*w*v+u^4*v^2*w^2+w^3*v^3*u^2+w^4*v^4), u^54*v^25*w^25*(-v*w+u^2)*(v*w+u
^2), u^6*(3*v^6*w^6+3*u^2*v^4*w^6+3*u^2*v^5*w^5+3*u^2*v^6*w^4-2*u^3*v^2*w^7-2*v^
3*u^3*w^6-2*u^3*v^6*w^3-2*u^3*v^7*w^2+u^6*v^2*w^4+u^6*v^3*w^3+u^6*v^4*w^2+u^12),
u^2*(3*v^2*w^2+2*u*v*w^2+2*u*v^2*w+u^4), -u^6*v^3*w^3, -v^5*u-u*w^5+4*u^2*v^2*w^
2+u^2*v^4+u^2*w^4+v^2*w^4-2*u^3*v^3-2*u^3*w^3+3*u^4*v^2+3*u^4*w^2+v^4*w^2-u^5*v-
u^5*w+2*u^6, 0, 4*u^2*(3*v^2*w^2-u*v^3-u*w^3+u^4), 4*u^51*v^25*w^25*(-v*
w+u^2), u^10*(v^10*w^11+v^11*w^10+u*v^10*w^10+u^4*v^6*w^11+u^4*v^7*w^10+u^4*v^8*
w^9+u^4*v^9*w^8+u^4*v^10*w^7+u^4*v^11*w^6-u^5*v^4*w^12+u^5*v^8*w^8-u^5*v^12*w^4-
u^6*v^4*w^11-u^6*v^6*w^9-u^6*v^9*w^6-u^6*v^11*w^4+u^9*v^4*w^8+u^9*v^6*w^6+u^9*v^
8*w^4+u^21), 0, -u^8*w^4*v^4, u^2*(3*w^3*v^2+3*v^3*w^2+6*u*v^2*w^2-2*v^4
*u-2*w^4*u-2*u^2*v^3-2*u^2*w^3+u^4*v+u^4*w+2*u^5), u^14*v^5*w^5*(-v*w+u^2)*(v*w+
u^2), u^11*v^5*w^5*(-v*w+u^2)*(2*u^2+v^2+w^2), u^34*v^15*w^15*(-v*w+u^2)*(v*w+u^
2), u^4*(v^4*w^6+v^6*w^4+u^2*v^2*w^6+3*u^2*v^4*w^4+u^2*v^6*w^2+2*u^3*v^2*w^5+4*u
^3*v^3*w^4+4*u^3*v^4*w^3+2*u^3*v^5*w^2+u^4*v^2*w^4+2*u^4*w^3*v^3+u^4*v^4*w^2+u^
10), 0, -u^22*v^11*w^11, 4*u^11*v^5*w^5*(-v*w+u^2), u^7*(v^2*w^5+v^3*w^4
+v^4*w^3+v^5*w^2+u*v^2*w^4+u*v^3*w^3+u*v^4*w^2+u^7), u^51*v^25*w^25*(v+w+2*u)*(-
v*w+u^2), u^52*v^25*w^25*(-v*w+u^2), u^2*(3*v^2*w^4+3*v^4*w^2-2*v^5*u-2*u*w^5+6*
u^2*v^2*w^2-2*u^3*v^3-2*u^3*w^3+u^4*v^2+u^4*w^2+2*u^6), 6*u^50*v^25*w^25*(v+w+2*
u), u^11*v^5*w^5*(v+w+2*u)*(-v*w+u^2), u^42*v^20*w^20*(-v*w+u^2), 0, u^51*v^25*w
^25*(-v*w+u^2)*(2*u^2+v^2+w^2), 2*u^10*v^5*w^5*(w^4+v^2*w^2+v^4+3*u^2*w^2+3*u^2*
v^2+3*u^4), 6*u^10*v^5*w^5*(2*u^2+v^2+w^2), u^32*v^15*w^15*(-v*w+u^2), u^50*v^25
*w^25*(3*u*v^2+3*u*w^2+v*w^2+3*u^2*v+3*u^2*w+v^2*w+6*u^3+2*v^3+2*w^3), u^4*(v^4*
w^5+v^5*w^4+u*v^4*w^4+2*v^2*u^2*w^5+3*u^2*v^3*w^4+3*u^2*v^4*w^3+2*u^2*v^5*w^2+3*
u^3*v^2*w^4+4*u^3*w^3*v^3+3*u^3*v^4*w^2+u^9), 0, u^44*v^20*w^20*(-v*w+u^
2)*(v*w+u^2), 0, u^10*v^5*w^5*(3*u*v^2+3*u*w^2+v*w^2+3*u^2*v+3*u^2*w+v^2*w+6*u^3
+2*v^3+2*w^3), 0, u^21*v^10*w^10*(v+w+2*u)*(-v*w+u^2), u^22*v^10*w^10*(-
v*w+u^2), u^4*(3*w^4*v^4+6*u^2*v^2*w^4+8*w^3*v^3*u^2+6*u^2*v^4*w^2+u^8), u^12*v^
5*w^5*(3*w^3*v^2+3*v^3*w^2+6*u*v^2*w^2-2*v^4*u-2*w^4*u-2*u^2*v^3-2*u^2*w^3+u^4*v
+u^4*w+2*u^5), -u^12*v^6*w^6, u^22*v^10*w^10*(v^2*w^4+2*v^3*w^3+v^4*w^2-u*w^5+3*
u*v^2*w^3+3*u*v^3*w^2-v^5*u-2*u^2*w^4+2*u^2*v^2*w^2-2*u^2*v^4-u^3*w^3-u^3*v^3+u^
5*w+u^5*v+2*u^6), u^8*(3*v^8*w^8+6*u^4*v^4*w^8+8*u^4*v^6*w^6+6*u^4*v^8*w^4+u^16)
, u^30*v^15*w^15*(3*u*v^2+3*u*w^2+v*w^2+3*u^2*v+3*u^2*w+v^2*w+6*u^3+2*v^3+2*w^3)
, u^11*v^5*w^5*(v^3+w^3+u*v^2+u*w^2+u^2*v+u^2*w+2*u^3), u^24*v^10*w^10*(-v*w+u^2
)*(v*w+u^2), u^12*v^5*w^5*(3*v^2*w^4+3*v^4*w^2-2*v^5*u-2*u*w^5+6*u^2*v^2*w^2-2*u
^3*v^3-2*u^3*w^3+u^4*v^2+u^4*w^2+2*u^6), u^31*v^15*w^15*(v+w+2*u)*(-v*w+u^2), 4*
u^21*v^10*w^10*(-v*w+u^2), u^41*v^20*w^20*(-v*w+u^2)*(2*u^2+v^2+w^2), 4*u^41*v^
20*w^20*(-v*w+u^2), u^31*v^15*w^15*(-v*w+u^2)*(2*u^2+v^2+w^2), u^12*v^5*w^5*(3*v
^2*w^2+2*u*v*w^2+2*u*v^2*w+u^4), u^22*v^10*w^10*(3*w^3*v^2+3*v^3*w^2+6*u*v^2*w^2
-2*v^4*u-2*w^4*u-2*u^2*v^3-2*u^2*w^3+u^4*v+u^4*w+2*u^5), 4*u^12*v^5*w^5*(3*v^2*w
^2-u*v^3-u*w^3+u^4), u^11*v^5*w^5*(v^2+w^2+2*u*v+2*u*w+2*u^2), 2*u^21*v^10*w^10*
(v+w+2*u), 0, 6*u^40*v^20*w^20*(2*u^2+v^2+w^2), 2*u^11*v^5*w^5*(v+w+2*u)
, 4*u^22*v^10*w^10*(3*v^2*w^2-u*v^3-u*w^3+u^4), 2*u^10*v^5*w^5*(w^2+v*w+v^2+3*u*
w+3*u*v+3*u^2), u^21*v^10*w^10*(v^2+w^2+2*u*v+2*u*w+2*u^2), 4*u^31*v^15*w^15*(-v
*w+u^2), 6*u^50*v^25*w^25*(2*u^2+v^2+w^2), 2*u^20*v^10*w^10*(w^2+v*w+v^2+3*u*w+3
*u*v+3*u^2), 6*u^10*v^5*w^5*(v+w+2*u), 24*u^10*v^5*w^5, 2*u^30*v^15*w^15*(w^2+v*
w+v^2+3*u*w+3*u*v+3*u^2), 6*u^30*v^15*w^15*(2*u^2+v^2+w^2), 6*u^20*v^10*w^10*(v+
w+2*u), 6*u^30*v^15*w^15*(v+w+2*u), 24*u^50*v^25*w^25, 24*u^30*v^15*w^15, 24*u^
20*v^10*w^10, 24*u^40*v^20*w^20];end;
  f30a:=function(u,v,w)return[30, 12*u+9*v+9*w, 4*u*v+4*u*w+2*v*w+u^2, 6*u*v+6*u*w+6*v*w+6*u^2+3*v^2+3*w^2, 
12*u^2+9*v^2+9*w^2, u*(-3*v*w+u^2), 2*u*v*w+u*v^2+u*w^2+v*w^2+2*u^2*v+2*u^2*w+v^
2*w+u^3, u*v*w, 3*u*v^2+3*u*w^2+3*v*w^2+3*u^2*v+3*u^2*w+3*v^2*w+6*u^3+3*v^3+3*w^
3, -u^2*(w^2+v*w+v^2), u^4*(v^7*w^8+v^8*w^7-u^2*v^6*w^7-u^2*v^7*w^6+u^3*v^4*w^8-
u^3*v^6*w^6+u^3*v^8*w^4+u^4*v^4*w^7+u^4*v^5*w^6+u^4*v^6*w^5+u^4*v^7*w^4-u^5*v^3*
w^7+u^5*v^5*w^5-u^5*v^7*w^3-u^5*v^10-u^5*w^10-u^6*v^3*w^6-u^6*v^6*w^3-u^6*v^9-u^
6*w^9+u^9*w^3*v^3), u*v*w^2+u*v^2*w+u*v^3+u*w^3+v*w^3+2*u^3*v+2*u^3*w+v^3*w+u^4,
0, 6*u^2*v^2+6*u^2*w^2+6*v^2*w^2+6*u^4+3*v^4+3*w^4, 3*u^2*v^2*w^3+3*u^2*v^3*w^2+
3*u^3*v^2*w^2-4*u^3*v^4-4*u^3*w^4-2*v^3*w^4-4*u^4*v^3-4*u^4*w^3-2*v^4*w^3+u^7, u
*(-v*w^2-v^2*w-u*v*w+u^3), -u*v*w^3+u*v^2*w^2-u*v^3*w-v^4*u-w^4*u-v*w^4+u^2*v*w^
2+u^2*v^2*w-u^2*v^3-u^2*w^3-2*u^3*v*w-2*u^4*v-2*u^4*w-v^4*w+u^5, 0, -u^4*(w^2-v*
w+v^2)*(w^2+v*w+v^2), 0, u^8*(-v^9*w^9-u*v^8*w^9-u*v^9*w^8+u^5*v^6*w^7+u^5*v^7*w
^6+u^5*v^13+u^5*w^13+u^6*v^6*w^6), u*(-v*w^3-v^3*w-u^2*v*w+u^4), -u^10*v^6*w^6*(
w^2+v*w+v^2), u^5*v^5*w^5, -u^44*v^30*w^30*(w^2-v*w+v^2)*(w^2+v*w+v^2), u^4*(2*v
^7*w^7-3*u^2*v^6*w^6+2*u^3*v^4*w^7+2*u^3*v^7*w^4+3*u^4*v^5*w^5-2*u^5*v^3*w^6-2*u
^5*v^6*w^3-2*u^5*v^9-2*u^5*w^9+u^8*w^3*v^3), -u^2*(-3*v^2*w^2+2*u*v^3+2*u*w^3),
0, -u*v^2*w^3-u*v^3*w^2-v^5*u-u*w^5-v*w^5+3*u^2*v^2*w^2+u^2*v^4+u^2*w^4+v^2*w^4-
u^3*v*w^2-u^3*v^2*w-3*u^3*v^3-3*u^3*w^3-2*v^3*w^3+u^4*v^2+u^4*w^2+v^4*w^2-2*u^5*
v-2*u^5*w-v^5*w+u^6, 
u^4*v^3*w^5+u^4*v^5*w^3, 
9*u^2*v^2*w^2-8*u^3*v^3-8*u^3*w^3-4*v^3*w^3+u^6,
u^41*v^30*w^30*(-3*v*w+u^2), u^8*(v^11*w^12+v^12*w^11-u^2*v^10*w^11-u^2*v^11*w^
10+u^3*v^8*w^12-u^3*v^10*w^10+u^3*v^12*w^8+u^4*v^8*w^11+u^4*v^11*w^8+u^6*v^8*w^9
+u^6*v^9*w^8-u^7*v^6*w^10+u^7*v^8*w^8-u^7*v^10*w^6-u^7*v^16-u^7*w^16-u^8*v^6*w^9
-u^8*v^9*w^6-u^8*v^15-u^8*w^15+u^11*v^6*w^6), 0, 0, 3*u^2*v^2*w^3+3*u^2*
v^3*w^2-2*u^3*v*w^3+3*u^3*v^2*w^2-2*u^3*v^3*w-2*u^3*v^4-2*u^3*w^4-2*v^3*w^4-4*u^
4*v^3-4*u^4*w^3-2*v^4*w^3+u^7, -u^12*v^6*w^6*(w^2+v*w+v^2)*(w^2-v*w+v^2), u^9*v^
6*w^6*(-v*w^3-v^3*w-u^2*v*w+u^4), -u^28*v^18*w^18*(w^2+v*w+v^2)*(w^2-v*w+v^2), u
^4*(-v^4*w^6-2*v^5*w^5-v^6*w^4-2*u*v^4*w^5-2*u*v^5*w^4+u^2*v^4*w^4+u^2*v^8+u^2*w
^8+2*u^3*v^3*w^4+2*u^3*v^4*w^3+2*u^4*w^3*v^3+u^4*v^6+u^4*w^6), 
# b in 1,-1,3,-3
u^4*v^3*w^3*(Mvp("b")*(u+v+w)-u), 0, u^9*v^6*w^6*(-3*v*w+u^2), 
u^4*(-v^5*w^5-u*v^4*w^5-u*v^5*w^4+u^3*v^3*w^4+u^3*v^4*w^3
+u^3*v^7+u^3*w^7+u^4*w^3*v^3), u^41*v^30*w^30*(-v*w^2-v^2*w-u*v*w+u^3), -u^42*v^
30*w^30*(w^2+v*w+v^2), 3*u^2*v^2*w^4+3*u^2*v^4*w^2-2*w^3*v^2*u^3-2*w^2*v^3*u^3-2
*u^3*v^5-2*u^3*w^5-2*v^3*w^5+3*u^4*v^2*w^2-4*u^5*v^3-4*u^5*w^3-2*v^5*w^3+u^8, 3*
u^40*v^30*w^30*(3*v+3*w+4*u), u^9*v^6*w^6*(-v*w^2-v^2*w-u*v*w+u^3), -u^34*v^24*w
^24*(w^2+v*w+v^2), 0, u^41*v^30*w^30*(-v*w^3-v^3*w-u^2*v*w+u^4), 3*u^8*v^6*w^6*(
w^4+2*v^2*w^2+v^4+2*u^2*w^2+2*u^2*v^2+2*u^4), 3*u^8*v^6*w^6*(3*w^2+3*v^2+4*u^2),
-u^26*v^18*w^18*(w^2+v*w+v^2), 3*u^40*v^30*w^30*(w^3+v*w^2+v^2*w+v^3+u*w^2+u*v^2
+u^2*w+u^2*v+2*u^3), u^4*(-3*v^4*w^5-3*v^5*w^4-3*u*v^4*w^4+2*u^2*v^3*w^4+2*u^2*v
^4*w^3+u^2*v^7+u^2*w^7+4*u^3*w^3*v^3+u^3*v^6+u^3*w^6), 
u^12*v^9*w^9*(Mvp("b")*(u+v+w)-u), 
-u^36*v^24*w^24*(w^2+v*w+v^2)*(w^2-v*w+v^2), 2*u^4*w^3*v^3, 
3*u^8*v^6*w^6*(w^3+v*w^2+v^2*w+v^3+u*w^2+u*v^2+u^2*w+u^2*v+2*u^3), 
2*u^20*v^15*w^15, u^17*v^12*w^12*(-v*w^2-v^2*w-u*v*w+u^3), 
-u^18*v^12*w^12*(w^2+v*w+v^2), u^4*(-9*w^4*v^4+8*w^3*v^3*u^2+2*u^2*v^6+2*u
^2*w^6), u^8*v^6*w^6*(3*u^2*v^2*w^3+3*u^2*v^3*w^2-2*u^3*v*w^3+3*u^3*v^2*w^2-2*u^
3*v^3*w-2*u^3*v^4-2*u^3*w^4-2*v^3*w^4-4*u^4*v^3-4*u^4*w^3-2*v^4*w^3+u^7), 0, u^
16*v^12*w^12*(-v^3*w^5-2*w^4*v^4-v^5*w^3+u^2*v^2*w^4+2*w^3*v^3*u^2+u^2*v^4*w^2-u
^3*w^5-w^4*v*u^3+2*w^3*v^2*u^3+2*w^2*v^3*u^3-w*v^4*u^3-u^3*v^5-3*u^4*w^4-u^4*v*w
^3+u^4*v^2*w^2-u^4*v^3*w-3*u^4*v^4-2*u^5*w^3-2*u^5*v^3+u^8), u^8*(-9*v^8*w^8+8*u
^4*v^6*w^6+2*u^4*v^12+2*u^4*w^12), 3*u^24*v^18*w^18*(w^3+v*w^2+v^2*w+v^3+u*w^2+u
*v^2+u^2*w+u^2*v+2*u^3), u^8*v^6*w^6*(u*v*w^2+u*v^2*w+u*v^3+u*w^3+v*w^3+2*u^3*v+
2*u^3*w+v^3*w+u^4), -u^20*v^12*w^12*(w^2+v*w+v^2)*(w^2-v*w+v^2), u^8*v^6*w^6*(3*
u^2*v^2*w^4+3*u^2*v^4*w^2-2*w^3*v^2*u^3-2*w^2*v^3*u^3-2*u^3*v^5-2*u^3*w^5-2*v^3*
w^5+3*u^4*v^2*w^2-4*u^5*v^3-4*u^5*w^3-2*v^5*w^3+u^8), u^25*v^18*w^18*(-v*w^2-v^2
*w-u*v*w+u^3), u^17*v^12*w^12*(-3*v*w+u^2), u^33*v^24*w^24*(-v*w^3-v^3*w-u^2*v*w
+u^4), u^33*v^24*w^24*(-3*v*w+u^2), u^25*v^18*w^18*(-v*w^3-v^3*w-u^2*v*w+u^4), -
u^10*v^6*w^6*(-3*v^2*w^2+2*u*v^3+2*u*w^3), u^16*v^12*w^12*(3*u^2*v^2*w^3+3*u^2*v
^3*w^2-2*u^3*v*w^3+3*u^3*v^2*w^2-2*u^3*v^3*w-2*u^3*v^4-2*u^3*w^4-2*v^3*w^4-4*u^4
*v^3-4*u^4*w^3-2*v^4*w^3+u^7), u^8*v^6*w^6*(9*u^2*v^2*w^2-8*u^3*v^3-8*u^3*w^3-4*
v^3*w^3+u^6), u^8*v^6*w^6*(2*u*v*w+u*v^2+u*w^2+v*w^2+2*u^2*v+2*u^2*w+v^2*w+u^3),
u^16*v^12*w^12*(4*u*v+4*u*w+2*v*w+u^2), 2*u^12*v^9*w^9, 3*u^32*v^24*w^24*(3*w^2+3*v^2
+4*u^2), u^8*v^6*w^6*(4*u*v+4*u*w+2*v*w+u^2), u^16*v^12*w^12*(9*u^2*v^2*w^2-8*u^
3*v^3-8*u^3*w^3-4*v^3*w^3+u^6), 3*u^8*v^6*w^6*(w^2+2*v*w+v^2+2*u*w+2*u*v+2*u^2),
u^16*v^12*w^12*(2*u*v*w+u*v^2+u*w^2+v*w^2+2*u^2*v+2*u^2*w+v^2*w+u^3), u^25*v^18*
w^18*(-3*v*w+u^2), 3*u^40*v^30*w^30*(3*w^2+3*v^2+4*u^2), 3*u^16*v^12*w^12*(w^2+2
*v*w+v^2+2*u*w+2*u*v+2*u^2), 3*u^8*v^6*w^6*(3*v+3*w+4*u), 30*u^8*v^6*w^6, 3*u^24
*v^18*w^18*(w^2+2*v*w+v^2+2*u*w+2*u*v+2*u^2), 3*u^24*v^18*w^18*(3*w^2+3*v^2+4*u^
2), 3*u^16*v^12*w^12*(3*v+3*w+4*u), 3*u^24*v^18*w^18*(3*v+3*w+4*u), 30*u^40*v^30
*w^30, 30*u^24*v^18*w^18, 30*u^16*v^12*w^12, 30*u^32*v^24*w^24];end;
  f30b:=function(u,v,w)return [30, 9*u+15*v+6*w, 4*u*v+2*v*w+u^2+5*v^2, 
10*u*v+4*u*w+6*v*w+2*u^2+7*v^2+w^2, 9*u^2+15*v^2+6*w^2, -4*u*v*w+u^3+5*v^3, 
2*v*(u+v)*(u+w+v), v^2*(u+v), 
5*u*v^2+2*u*w^2+3*v*w^2+5*u^2*v+2*u^2*w+3*v^2*w+2*u^3+7*v^3+w^3, -v^2*(-v^2+u*w), 
v^4*(-u^6*
v^6*w^3+u^4*v^5*w^6-v^6*u^7*w^2-v^5*u^8*w^2+v^9*u^3*w^3+v^9*u^4*w^2+v^4*u^7*w^4+
v^5*u^6*w^4-v^5*u^7*w^3+2*v^4*u^6*w^5+2*v^4*u^5*w^6+u^13*w^2-v^3*u^10*w^2+v^3*u^
8*w^4-v^4*u^9*w^2+v^2*u^9*w^4+v^2*u^8*w^5-u^2*v^6*w^7-u^3*v^6*w^6+u^4*v^4*w^7+u^
5*v^5*w^5+v^15+v^11*u^4-v^8*u^7-v^7*u^8+v^9*u^2*w^4-v^5*u^2*w^8-v^5*u^3*w^7), v*
(u*w^2+2*u*v^2+u^2*w+3*u^2*v+v*w^2+u^3+v^2*w+2*v^3), 0, 10*u^2*v^2+4*u^2*w^2+6*v
^2*w^2+2*u^4+7*v^4+w^4, 4*u^2*v^2*w^3+4*u^2*v^3*w^2+4*u^3*v^2*w^2-4*u^3*v^4-2*v^
3*w^4-4*u^4*v^3-2*v^4*w^3+u^7+5*v^7, v*(-u*w^2-2*u*v*w+2*u*v^2-u^2*w+u^3+v^2*w+2
*v^3), -u*v*w^3+u*v^2*w^2-2*u*v^3*w+2*u^2*v*w^2+u^2*v^2*w+u^2*v^3+u^2*w^3-u^3*v*
w-u^3*v^2+u^3*w^2+2*v^3*w^2+2*v^5, 0, -v^4*(-v^2+u*w)*(v^2+u*w), 0, v^8*(v^5*u^4
*w^9+v^6*u^4*w^8+v^5*u^6*w^7+u^6*v^6*w^6+v^5*u^7*w^6+u^8*v^6*w^4+v^10*u^8+u^9*v^
5*w^4+u^9*v^9+v*u^13*w^4+u^14*w^4+v^18), v*(-u*w^3-2*u*v^2*w+2*u^2*v^2-u^3*w+u^3
*v+v^2*w^2+2*v^4), -u^6*v^12*w^4*(-v^2+u*w), v^10*(u+v)*(u^4-u^3*v+u^2*v^2-u*v^3
+v^4), -u^30*v^54*w^20*(-v^2+u*w)*(v^2+u*w), v^4*(-2*v^5*u^2*w^7+u^2*v^8*w^4-2*v
^5*u^3*w^6+u^3*v^8*w^3+3*u^4*v^4*w^6+u^4*v^8*w^2+u^4*v^10+3*u^5*v^4*w^5+3*u^6*v^
4*w^4-2*v^5*u^6*w^3-2*u^7*v^5*w^2-2*u^7*v^7+3*u^8*v^2*w^4-2*v^3*u^9*w^2+u^12*w^2
+v^14), v^2*(2*u*v*w^2+2*u^2*v*w-u^2*v^2+2*u^3*w+v^4), 0, -(u^2+v^2)*(u^3*v-2*u^
2*v^2-u^2*w^2+u*v*w^2+2*u*v^3+v^3*w-3*v^2*w^2-2*v^4-w^4+v*w^3), 
u^3*v^5*w^4+u^3*v^7*w^2,
12*u^2*v^2*w^2-8*u^3*v^3-4*v^3*w^3+u^6+5*v^6, u^30*v^50*w^20*(-4*u*v*w+u^3+5*v^3), 
v^8*(u^8*v^11*w^4+u^6*v^11*w^6-u^9*v^8*w^6+u^8*v^7*w^8+u^8*v^6*w^9+u^9*v^6*w^8-u^4
*v^8*w^11-v^12*u^11-v^11*u^12+u^10*v^6*w^7+u^8*v^15+v^23+u^11*v^6*w^6+v^6*u^6*w^
11-v^7*u^4*w^12+v^2*u^15*w^6-v^7*u^12*w^4+v^3*u^14*w^6+u^19*w^4-v^3*u^16*w^4+v^2
*u^14*w^7-v^8*u^11*w^4+u^4*v^11*w^8-u^6*v^8*w^9+u^7*v^6*w^10-u^15*v^4*w^4), 
0, 0, v*(-2*u*v^2*w^3+2*v^5*u+3*u^2*v*w^3+6*u^2*v^2*w^2+3*u^3*v*w^2-2*u^
3*v^2*w-4*u^3*v^3-2*u^4*v^2-2*v^3*w^3+u^6+v^5*w+2*v^6), -u^6*v^14*w^4*(-v^2+u*w)
*(v^2+u*w), u^6*v^11*w^4*(-u*w^3-2*u*v^2*w+2*u^2*v^2-u^3*w+u^3*v+v^2*w^2+2*v^4),
-u^18*v^34*w^12*(-v^2+u*w)*(v^2+u*w), v^4*(v^2*u^2*w^6+2*v^3*u^2*w^5+u^2*v^4*w^4
+4*u^3*v^3*w^4+2*u^3*v^4*w^3+2*v^2*u^4*w^4+4*u^4*w^3*v^3+v^4*u^4*w^2+u^4*v^6+2*v
^3*u^5*w^2+2*v^5*u^5+2*u^6*v^2*w^2+2*u^7*w^3+2*v*u^7*w^2+u^8*w^2+v^10), 
# c=+-1
u^3*v^5*w^2*(Mvp("c")*(u+v+w)-u), 0, 
u^6*v^10*w^4*(-4*u*v*w+u^3+5*v^3), v^4*(v^3*u^2*w^5+u^2*v^4*w^4+u^3*v^3*w^
4+u^3*v^4*w^3+u^4*w^3*v^3+v^4*u^4*w^2+u^4*v^6+v^3*u^5*w^2+v^5*u^5+v*u^7*w^2+u^8*
w^2+v^10), u^30*v^51*w^20*(-u*w^2-2*u*v*w+2*u*v^2-u^2*w+u^3+v^2*w+2*v^3), -u^30*
v^52*w^20*(-v^2+u*w), v^2*(3*u^2*w^4-2*u^2*v*w^3+6*u^2*v^2*w^2+2*u^2*v^4-2*u^3*v
*w^2-4*u^3*v^3+3*u^4*w^2-2*u^5*v-2*v^3*w^3+u^6+v^4*w^2+2*v^6), 3*u^30*v^50*w^20*
(5*v+2*w+3*u), u^6*v^11*w^4*(-u*w^2-2*u*v*w+2*u*v^2-u^2*w+u^3+v^2*w+2*v^3), -u^
24*v^42*w^16*(-v^2+u*w), 0, u^30*v^51*w^20*(-u*w^3-2*u*v^2*w+2*u^2*v^2-u^3*w+u^3
*v+v^2*w^2+2*v^4), u^6*v^10*w^4*(10*u^2*v^2+4*u^2*w^2+6*v^2*w^2+2*u^4+7*v^4+w^4)
, 3*u^6*v^10*w^4*(2*w^2+5*v^2+3*u^2), -u^18*v^32*w^12*(-v^2+u*w), u^30*v^50*w^20
*(5*u*v^2+2*u*w^2+3*v*w^2+5*u^2*v+2*u^2*w+3*v^2*w+2*u^3+7*v^3+w^3), v^4*(2*v^2*u
^2*w^5+3*u^2*v^3*w^4+3*v^2*u^3*w^4+4*u^3*w^3*v^3+3*v^2*u^4*w^3+3*v^3*u^4*w^2+2*v
^5*u^4+2*v^2*u^5*w^2+v^4*u^5+u^6*w^3+2*u^6*v*w^2+3*u^7*w^2+v^9), 
u^9*v^15*w^6*(Mvp("c")*(u+v+w)-u), 
-u^24*v^44*w^16*(-v^2+u*w)*(v^2+u*w), 2*u^3*v^5*w^2, 
u^6*v^10*w^4*(5*u*v^2+2*u*w^2+3*v*w^2+5*u^2*v+2*u^2*w+3*v^2*w+2*u^3+7*v^3+w^3), 
2*u^15*v^25*w^10, u^12*v^21*w^8*(-u*w^2-2*u*v*w+2*u*v^2-u^2*w+u^3+v^2*w+2*v^3),
-u^12*v^22*w^8*(-v^2+u*w), v^4*(6*u^2
*v^2*w^4+8*w^3*v^2*u^3+6*u^4*v^2*w^2+3*u^4*v^4+6*u^6*w^2+v^8), u^6*v^11*w^4*(-2*
u*v^2*w^3+2*v^5*u+3*u^2*v*w^3+6*u^2*v^2*w^2+3*u^3*v*w^2-2*u^3*v^2*w-4*u^3*v^3-2*
u^4*v^2-2*v^3*w^3+u^6+v^5*w+2*v^6), 0, u^12*v^21*w^8*(-v^3*w^4-v^4*w^3+v^6*w+2*v
^7-v^2*u*w^4-u*v^3*w^3+2*u*v^6+v*u^2*w^4+3*u^2*v^2*w^3+2*u^2*v^3*w^2+2*u^3*v*w^3
+3*u^3*v^2*w^2-u^3*v^3*w-2*u^3*v^4+w^2*v*u^4-u^4*v^2*w-3*u^4*v^3-v^2*u^5+u^7), v
^8*(6*v^4*u^4*w^8+8*v^4*u^6*w^6+6*v^4*u^8*w^4+3*u^8*v^8+6*u^12*w^4+v^16), u^18*v
^30*w^12*(5*u*v^2+2*u*w^2+3*v*w^2+5*u^2*v+2*u^2*w+3*v^2*w+2*u^3+7*v^3+w^3), u^6*
v^11*w^4*(u*w^2+2*u*v^2+u^2*w+3*u^2*v+v*w^2+u^3+v^2*w+2*v^3), -u^12*v^24*w^8*(-v
^2+u*w)*(v^2+u*w), u^6*v^12*w^4*(3*u^2*w^4-2*u^2*v*w^3+6*u^2*v^2*w^2+2*u^2*v^4-2
*u^3*v*w^2-4*u^3*v^3+3*u^4*w^2-2*u^5*v-2*v^3*w^3+u^6+v^4*w^2+2*v^6), u^18*v^31*w
^12*(-u*w^2-2*u*v*w+2*u*v^2-u^2*w+u^3+v^2*w+2*v^3), u^12*v^20*w^8*(-4*u*v*w+u^3+
5*v^3), u^24*v^41*w^16*(-u*w^3-2*u*v^2*w+2*u^2*v^2-u^3*w+u^3*v+v^2*w^2+2*v^4), u
^24*v^40*w^16*(-4*u*v*w+u^3+5*v^3), u^18*v^31*w^12*(-u*w^3-2*u*v^2*w+2*u^2*v^2-u
^3*w+u^3*v+v^2*w^2+2*v^4), u^6*v^12*w^4*(2*u*v*w^2+2*u^2*v*w-u^2*v^2+2*u^3*w+v^4
), u^12*v^21*w^8*(-2*u*v^2*w^3+2*v^5*u+3*u^2*v*w^3+6*u^2*v^2*w^2+3*u^3*v*w^2-2*u
^3*v^2*w-4*u^3*v^3-2*u^4*v^2-2*v^3*w^3+u^6+v^5*w+2*v^6), u^6*v^10*w^4*(12*u^2*v^
2*w^2-8*u^3*v^3-4*v^3*w^3+u^6+5*v^6), 2*u^6*v^11*w^4*(u+v)*(u+w+v), u^12*v^20*w^
8*(4*u*v+2*v*w+u^2+5*v^2), 2*u^9*v^15*w^6, 3*u^24*v^40*w^16*(2*w^2+5*v^2+3*u^2), u^6*
v^10*w^4*(4*u*v+2*v*w+u^2+5*v^2), u^12*v^20*w^8*(12*u^2*v^2*w^2-8*u^3*v^3-4*v^3*
w^3+u^6+5*v^6), u^6*v^10*w^4*(10*u*v+4*u*w+6*v*w+2*u^2+7*v^2+w^2), 2*u^12*v^21*w
^8*(u+v)*(u+w+v), u^18*v^30*w^12*(-4*u*v*w+u^3+5*v^3), 3*u^30*v^50*w^20*(2*w^2+5
*v^2+3*u^2), u^12*v^20*w^8*(10*u*v+4*u*w+6*v*w+2*u^2+7*v^2+w^2), 3*u^6*v^10*w^4*
(5*v+2*w+3*u), 30*u^6*v^10*w^4, u^18*v^30*w^12*(10*u*v+4*u*w+6*v*w+2*u^2+7*v^2+w
^2), 3*u^18*v^30*w^12*(2*w^2+5*v^2+3*u^2), 3*u^12*v^20*w^8*(5*v+2*w+3*u), 3*u^18
*v^30*w^12*(5*v+2*w+3*u), 30*u^30*v^50*w^20, 30*u^18*v^30*w^12, 30*u^12*v^20*w^8
, 30*u^24*v^40*w^16];end;
  f36:=function(u,v,w,j)return[36,18*u+9*v+9*w,4*u*v+4*u*w+v*w+6*u^2,
10*u*v+10*u*w+4*v*w+8*u^2+2*v^2+2*w^2,18*u^2+9*v^2+9*w^2,-4*u*v*w+6*u^3,
3*u*v*w+u*v^2+u*w^2+4*u^2*v+4*u^2*w+2*u^3,-j*u*v*w+u^2*v+u^2*w+u^3,5*u*v^2+
5*u*w^2+2*v*w^2+5*u^2*v+5*u^2*w+2*v^2*w+8*u^3+2*v^3+2*w^3,-u^2*v*w+u^4,-
j*u^4*v^7*w^8-j*u^4*v^8*w^7+j*u^6*v^6*w^7+j*u^6*v^7*w^6-
j*u^7*v^4*w^8+j*u^7*v^6*w^6-j*u^7*v^8*w^4-(2*j+j^2)*u^8*v^4*w^7+
2*u^8*v^5*w^6+2*u^8*v^6*w^5-(2*j+j^2)*u^8*v^7*w^4-u^9*v^2*w^8-
u^9*v^3*w^7+u^9*v^4*w^6+u^9*v^5*w^5+u^9*v^6*w^4-u^9*v^7*w^3-u^9*v^8*w^2-
u^10*v^2*w^7-u^10*v^3*w^6-u^10*v^6*w^3-u^10*v^7*w^2-u^11*v^8-u^11*w^8-
u^12*v^7-u^12*w^7+u^13*v^2*w^4+u^13*v^3*w^3+u^13*v^4*w^2+u^15*v^4+u^15*w^4+
u^19,u*v*w^2+u*v^2*w+u*v^3+u*w^3+u^2*v*w+2*u^2*v^2+2*u^2*w^2+2*u^3*v+2*u^3*w+
2*u^4,-j*u^2*v*w,10*u^2*v^2+10*u^2*w^2+4*v^2*w^2+8*u^4+2*v^4+2*w^4,
4*u^2*v^2*w^3+4*u^2*v^3*w^2+4*u^3*v^2*w^2-4*u^3*v^4-4*u^3*w^4-v^3*w^4-
4*u^4*v^3-4*u^4*w^3-v^4*w^3+6*u^7,-u*v*w^2-u*v^2*w-2*u^2*v*w+2*u^3*v+2*u^3*w+
2*u^4,-2*u*v*w^3+2*u*v^2*w^2-2*u*v^3*w-u*v^4-u*w^4+u^2*v*w^2+u^2*v^2*w-
u^2*v^3-u^2*w^3+v^2*w^3-2*u^3*v*w+u^3*v^2+u^3*w^2+v^3*w^2+2*u^5,
j^2*u^4*v^2*w^2,-u^4*v^2*w^2+u^8,0,j^2*u^8*v^9*w^9+j^2*u^9*v^8*w^9+
j^2*u^9*v^9*w^8+u^13*v^4*w^9+u^13*v^6*w^7+u^13*v^7*w^6+u^13*v^9*w^4+
u^14*v^4*w^8+u^14*v^6*w^6+u^14*v^8*w^4+u^17*v^9+u^17*w^9+u^18*v^8+u^18*w^8+
u^26,-u*v*w^3-u*v^3*w-2*u^3*v*w+2*u^3*v^2+2*u^3*w^2+2*u^5,j^2*u^12*v^6*w^6-
j^2*u^14*v^5*w^5,-j^2*u^5*v^5*w^5+u^10*v^5+u^10*w^5+u^15,
j*u^54*v^27*w^27-j*u^58*v^25*w^25,-2*j*u^4*v^7*w^7+
3*j*u^6*v^6*w^6-2*j*u^7*v^4*w^7-2*j*u^7*v^7*w^4+3*u^8*v^4*w^6+
3*u^8*v^5*w^5+3*u^8*v^6*w^4-2*u^9*v^2*w^7-2*u^9*v^3*w^6-2*u^9*v^6*w^3-
2*u^9*v^7*w^2-2*u^11*v^7-2*u^11*w^7+u^12*v^2*w^4+u^12*v^3*w^3+u^12*v^4*w^2+
u^14*v^4+u^14*w^4+u^18,-3*j^2*u^2*v^2*w^2+2*u^3*v*w^2+2*u^3*v^2*w-u^4*v^2-
u^4*w^2+u^6,-u^6*v^3*w^3,-u*v^2*w^3-u*v^3*w^2-u*v^5-u*w^5-u^2*v*w^3+
4*u^2*v^2*w^2-u^2*v^3*w+u^2*v^4+u^2*w^4+v^2*w^4-u^3*v*w^2-u^3*v^2*w-3*u^3*v^3-
3*u^3*w^3+4*u^4*v^2+4*u^4*w^2+v^4*w^2-2*u^5*v-2*u^5*w+2*u^6,0,
12*u^2*v^2*w^2-8*u^3*v^3-8*u^3*w^3-2*v^3*w^3+6*u^6,4*j*u^51*v^26*w^26-
6*j*u^53*v^25*w^25,-j^2*u^8*v^11*w^12-j^2*u^8*v^12*w^11+
j^2*u^10*v^10*w^11+j^2*u^10*v^11*w^10-j^2*u^11*v^8*w^12+
j^2*u^11*v^10*w^10-j^2*u^11*v^12*w^8-j^2*u^12*v^8*w^11-
j^2*u^12*v^11*w^8+u^14*v^6*w^11+u^14*v^7*w^10+u^14*v^8*w^9+u^14*v^9*w^8+
u^14*v^10*w^7+u^14*v^11*w^6-u^15*v^4*w^12+u^15*v^8*w^8-u^15*v^12*w^4-
u^16*v^4*w^11-u^16*v^6*w^9-u^16*v^9*w^6-u^16*v^11*w^4+u^19*v^4*w^8+
u^19*v^6*w^6+u^19*v^8*w^4-u^19*v^12-u^19*w^12-u^20*v^11-u^20*w^11+u^23*v^8+
u^23*w^8+u^31,0,j*u^8*v^4*w^4,-2*u*v^3*w^3+3*u^2*v^2*w^3+
3*u^2*v^3*w^2-2*u^3*v*w^3+6*u^3*v^2*w^2-2*u^3*v^3*w-2*u^3*v^4-2*u^3*w^4-
4*u^4*v^3-4*u^4*w^3+2*u^6*v+2*u^6*w+2*u^7,j^2*u^14*v^7*w^7-
j^2*u^18*v^5*w^5,j^2*u^11*v^6*w^8+j^2*u^11*v^8*w^6-
2*j^2*u^13*v^5*w^7+2*j^2*u^13*v^6*w^6-2*j^2*u^13*v^7*w^5-
2*j^2*u^15*v^5*w^5,u^34*v^17*w^17-u^38*v^15*w^15,j*u^4*v^4*w^6+
2*j*u^4*v^5*w^5+j*u^4*v^6*w^4+2*j*u^5*v^4*w^5+2*j*u^5*v^5*w^4+
u^6*v^2*w^6+(-j-2*j^2)*u^6*v^4*w^4+u^6*v^6*w^2+2*u^7*v^2*w^5+
4*u^7*v^3*w^4+4*u^7*v^4*w^3+2*u^7*v^5*w^2+u^8*v^2*w^4+2*u^8*v^3*w^3+
u^8*v^4*w^2+2*u^9*v^5+2*u^9*w^5+u^10*v^4+u^10*w^4+u^14,0,-
j^2*u^22*v^11*w^11,4*j^2*u^11*v^6*w^6-6*j^2*u^13*v^5*w^5,
j*u^4*v^5*w^5+j*u^5*v^4*w^5+j*u^5*v^5*w^4+u^7*v^2*w^5+u^7*v^3*w^4+
u^7*v^4*w^3+u^7*v^5*w^2+u^8*v^2*w^4+u^8*v^3*w^3+u^8*v^4*w^2+u^9*v^5+u^9*w^5+
u^10*v^4+u^10*w^4+u^14,j*u^51*v^26*w^27+j*u^51*v^27*w^26+
2*j*u^52*v^26*w^26-2*j*u^53*v^25*w^26-2*j*u^53*v^26*w^25-
2*j*u^54*v^25*w^25,j*u^52*v^26*w^26-j*u^54*v^25*w^25,3*u^2*v^2*w^4-
2*u^2*v^3*w^3+3*u^2*v^4*w^2-2*u^3*v^2*w^3-2*u^3*v^3*w^2-2*u^3*v^5-2*u^3*w^5+
6*u^4*v^2*w^2-4*u^5*v^3-4*u^5*w^3+2*u^6*v^2+2*u^6*w^2+2*u^8,-
9*j*u^50*v^25*w^26-9*j*u^50*v^26*w^25-18*j*u^51*v^25*w^25,
j^2*u^11*v^6*w^7+j^2*u^11*v^7*w^6+2*j^2*u^12*v^6*w^6-
2*j^2*u^13*v^5*w^6-2*j^2*u^13*v^6*w^5-2*j^2*u^14*v^5*w^5,-
j^2*u^42*v^21*w^21+j^2*u^44*v^20*w^20,0,j*u^51*v^26*w^28+
j*u^51*v^28*w^26-2*j*u^53*v^25*w^27+2*j*u^53*v^26*w^26-
2*j*u^53*v^27*w^25-2*j*u^55*v^25*w^25,-2*j^2*u^10*v^5*w^9-
4*j^2*u^10*v^7*w^7-2*j^2*u^10*v^9*w^5-10*j^2*u^12*v^5*w^7-
10*j^2*u^12*v^7*w^5-8*j^2*u^14*v^5*w^5,-9*j^2*u^10*v^5*w^7-
9*j^2*u^10*v^7*w^5-18*j^2*u^12*v^5*w^5,u^32*v^16*w^16-u^34*v^15*w^15,-
2*j*u^50*v^25*w^28-2*j*u^50*v^26*w^27-2*j*u^50*v^27*w^26-
2*j*u^50*v^28*w^25-5*j*u^51*v^25*w^27-5*j*u^51*v^27*w^25-
5*j*u^52*v^25*w^26-5*j*u^52*v^26*w^25-8*j*u^53*v^25*w^25,
3*j*u^4*v^4*w^5+3*j*u^4*v^5*w^4+3*j*u^5*v^4*w^4+2*u^6*v^2*w^5+
3*u^6*v^3*w^4+3*u^6*v^4*w^3+2*u^6*v^5*w^2+3*u^7*v^2*w^4+4*u^7*v^3*w^3+
3*u^7*v^4*w^2+u^8*v^5+u^8*w^5+2*u^9*v^4+2*u^9*w^4+u^13,0,-
j^2*u^44*v^22*w^22+j^2*u^48*v^20*w^20,0,-2*j^2*u^10*v^5*w^8-
2*j^2*u^10*v^6*w^7-2*j^2*u^10*v^7*w^6-2*j^2*u^10*v^8*w^5-
5*j^2*u^11*v^5*w^7-5*j^2*u^11*v^7*w^5-5*j^2*u^12*v^5*w^6-
5*j^2*u^12*v^6*w^5-8*j^2*u^13*v^5*w^5,0,-j*u^21*v^11*w^12-
j*u^21*v^12*w^11-2*j*u^22*v^11*w^11+2*j*u^23*v^10*w^11+
2*j*u^23*v^11*w^10+2*j*u^24*v^10*w^10,-j*u^22*v^11*w^11+
j*u^24*v^10*w^10,9*j*u^4*v^4*w^4+6*u^6*v^2*w^4+8*u^6*v^3*w^3+
6*u^6*v^4*w^2+3*u^8*v^4+3*u^8*w^4+u^12,2*j^2*u^11*v^8*w^8-
3*j^2*u^12*v^7*w^8-3*j^2*u^12*v^8*w^7+2*j^2*u^13*v^5*w^9+
2*j^2*u^13*v^6*w^8-6*j^2*u^13*v^7*w^7+2*j^2*u^13*v^8*w^6+
2*j^2*u^13*v^9*w^5+4*j^2*u^14*v^5*w^8+4*j^2*u^14*v^8*w^5-
2*j^2*u^16*v^5*w^6-2*j^2*u^16*v^6*w^5-2*j^2*u^17*v^5*w^5,
u^12*v^6*w^6,-j*u^21*v^13*w^14-j*u^21*v^14*w^13+j*u^22*v^12*w^14+
2*j*u^22*v^13*w^13+j*u^22*v^14*w^12-j*u^23*v^10*w^15-
j*u^23*v^11*w^14+3*j*u^23*v^12*w^13+3*j*u^23*v^13*w^12-
j*u^23*v^14*w^11-j*u^23*v^15*w^10-3*j*u^24*v^10*w^14-
j*u^24*v^11*w^13+2*j*u^24*v^12*w^12-j*u^24*v^13*w^11-
3*j*u^24*v^14*w^10-2*j*u^25*v^10*w^13-2*j*u^25*v^13*w^10+
2*j*u^27*v^10*w^11+2*j*u^27*v^11*w^10+2*j*u^28*v^10*w^10,
9*j^2*u^8*v^8*w^8+6*u^12*v^4*w^8+8*u^12*v^6*w^6+6*u^12*v^8*w^4+3*u^16*v^8+
3*u^16*w^8+u^24,-2*u^30*v^15*w^18-2*u^30*v^16*w^17-2*u^30*v^17*w^16-
2*u^30*v^18*w^15-5*u^31*v^15*w^17-5*u^31*v^17*w^15-5*u^32*v^15*w^16-
5*u^32*v^16*w^15-8*u^33*v^15*w^15,-j^2*u^11*v^5*w^8-j^2*u^11*v^6*w^7-
j^2*u^11*v^7*w^6-j^2*u^11*v^8*w^5-2*j^2*u^12*v^5*w^7-
j^2*u^12*v^6*w^6-2*j^2*u^12*v^7*w^5-2*j^2*u^13*v^5*w^6-
2*j^2*u^13*v^6*w^5-2*j^2*u^14*v^5*w^5,-j*u^24*v^12*w^12+
j*u^28*v^10*w^10,-3*j^2*u^12*v^7*w^9+2*j^2*u^12*v^8*w^8-
3*j^2*u^12*v^9*w^7+2*j^2*u^13*v^5*w^10+2*j^2*u^13*v^7*w^8+
2*j^2*u^13*v^8*w^7+2*j^2*u^13*v^10*w^5-6*j^2*u^14*v^7*w^7+
4*j^2*u^15*v^5*w^8+4*j^2*u^15*v^8*w^5-2*j^2*u^16*v^5*w^7-
2*j^2*u^16*v^7*w^5-2*j^2*u^18*v^5*w^5,u^31*v^16*w^17+u^31*v^17*w^16+
2*u^32*v^16*w^16-2*u^33*v^15*w^16-2*u^33*v^16*w^15-2*u^34*v^15*w^15,-
4*j*u^21*v^11*w^11+6*j*u^23*v^10*w^10,-j^2*u^41*v^21*w^23-
j^2*u^41*v^23*w^21+2*j^2*u^43*v^20*w^22-2*j^2*u^43*v^21*w^21+
2*j^2*u^43*v^22*w^20+2*j^2*u^45*v^20*w^20,-4*j^2*u^41*v^21*w^21+
6*j^2*u^43*v^20*w^20,u^31*v^16*w^18+u^31*v^18*w^16-2*u^33*v^15*w^17+
2*u^33*v^16*w^16-2*u^33*v^17*w^15-2*u^35*v^15*w^15,3*j*u^12*v^7*w^7-
2*j^2*u^13*v^6*w^7-2*j^2*u^13*v^7*w^6+j^2*u^14*v^5*w^7+
j^2*u^14*v^7*w^5-j^2*u^16*v^5*w^5,-2*j*u^21*v^13*w^13+
3*j*u^22*v^12*w^13+3*j*u^22*v^13*w^12-2*j*u^23*v^10*w^14-
2*j*u^23*v^11*w^13+6*j*u^23*v^12*w^12-2*j*u^23*v^13*w^11-
2*j*u^23*v^14*w^10-4*j*u^24*v^10*w^13-4*j*u^24*v^13*w^10+
2*j*u^26*v^10*w^11+2*j*u^26*v^11*w^10+2*j*u^27*v^10*w^10,
2*j^2*u^10*v^8*w^8-12*j^2*u^12*v^7*w^7+8*j^2*u^13*v^5*w^8+
8*j^2*u^13*v^8*w^5-6*j^2*u^16*v^5*w^5,-j^2*u^11*v^5*w^7-
3*j^2*u^11*v^6*w^6-j^2*u^11*v^7*w^5-4*j^2*u^12*v^5*w^6-
4*j^2*u^12*v^6*w^5-2*j^2*u^13*v^5*w^5,j*u^20*v^11*w^11+
4*j*u^21*v^10*w^11+4*j*u^21*v^11*w^10+6*j*u^22*v^10*w^10,0,
9*j^2*u^40*v^20*w^22+9*j^2*u^40*v^22*w^20+18*j^2*u^42*v^20*w^20,-
j^2*u^10*v^6*w^6-4*j^2*u^11*v^5*w^6-4*j^2*u^11*v^6*w^5-
6*j^2*u^12*v^5*w^5,-2*j*u^20*v^13*w^13+12*j*u^22*v^12*w^12-
8*j*u^23*v^10*w^13-8*j*u^23*v^13*w^10+6*j*u^26*v^10*w^10,-
2*j^2*u^10*v^5*w^7-4*j^2*u^10*v^6*w^6-2*j^2*u^10*v^7*w^5-
10*j^2*u^11*v^5*w^6-10*j^2*u^11*v^6*w^5-8*j^2*u^12*v^5*w^5,
j*u^21*v^10*w^12+3*j*u^21*v^11*w^11+j*u^21*v^12*w^10+
4*j*u^22*v^10*w^11+4*j*u^22*v^11*w^10+2*j*u^23*v^10*w^10,
4*u^31*v^16*w^16-6*u^33*v^15*w^15,-9*j*u^50*v^25*w^27-
9*j*u^50*v^27*w^25-18*j*u^52*v^25*w^25,2*j*u^20*v^10*w^12+
4*j*u^20*v^11*w^11+2*j*u^20*v^12*w^10+10*j*u^21*v^10*w^11+
10*j*u^21*v^11*w^10+8*j*u^22*v^10*w^10,-9*j^2*u^10*v^5*w^6-
9*j^2*u^10*v^6*w^5-18*j^2*u^11*v^5*w^5,-36*j^2*u^10*v^5*w^5,-
2*u^30*v^15*w^17-4*u^30*v^16*w^16-2*u^30*v^17*w^15-10*u^31*v^15*w^16-
10*u^31*v^16*w^15-8*u^32*v^15*w^15,-9*u^30*v^15*w^17-9*u^30*v^17*w^15-
18*u^32*v^15*w^15,9*j*u^20*v^10*w^11+9*j*u^20*v^11*w^10+
18*j*u^21*v^10*w^10,-9*u^30*v^15*w^16-9*u^30*v^16*w^15-18*u^31*v^15*w^15,-
36*j*u^50*v^25*w^25,-36*u^30*v^15*w^15,36*j*u^20*v^10*w^10,
36*j^2*u^40*v^20*w^20];end;
  f40:=function(u,v,w)return [40,10*u+
12*v+18*w,2*u*v+4*u*w+6*v*w+4*w^2,6*u*v+10*u*w+10*v*w+2*u^2+4*v^2+8*w^2,
10*u^2+12*v^2+18*w^2,-4*u*v*w+4*w^3,4*u*v*w+u*v^2+3*u*w^2+3*v*w^2+u^2*w+
2*v^2*w+2*w^3,u*v*w+u*w^2+v*w^2,3*u*v^2+5*u*w^2+5*v*w^2+3*u^2*v+5*u^2*w+
5*v^2*w+2*u^3+4*v^3+8*w^3,-u*v*w^2-v^2*w^2,u^2*v^4*w^13-u^2*v^7*w^10-
u^2*v^8*w^9+u^3*v^3*w^13-u^3*v^6*w^10-u^3*v^7*w^9+u^4*v^6*w^9+2*u^4*v^7*w^8+
u^4*v^8*w^7+u^4*w^15+v^4*w^15+u^5*v^5*w^9+2*u^5*v^6*w^8-u^6*v^3*w^10+
u^6*v^5*w^8-u^6*v^6*w^7-u^6*v^7*w^6-u^7*v^3*w^9+u^7*v^4*w^8-u^7*v^6*w^6+
u^7*v^8*w^4-u^7*w^12-v^7*w^12+u^8*v^4*w^7+u^8*v^7*w^4-u^8*w^11-v^8*w^11-
v^9*w^10-v^10*w^9,u*v*w^2+u*v^2*w+u*v^3+2*u*w^3+2*v*w^3+2*u^2*v*w+u^2*w^2+
v^2*w^2+u^3*w+2*v^3*w+2*w^4,0,6*u^2*v^2+10*u^2*w^2+10*v^2*w^2+2*u^4+4*v^4+
8*w^4,4*u^2*v^2*w^3+4*u^2*v^3*w^2+4*u^3*v^2*w^2-2*u^3*v^4-4*u^3*w^4-6*v^3*w^4-
2*u^4*v^3-4*u^4*w^3-6*v^4*w^3+4*w^7,-2*u*v*w^2-u*v^2*w+u*w^3+v*w^3-u^2*v*w+
2*w^4,-3*u*v*w^3+u*v^2*w^2-3*u*v^3*w-u*v^4-u*w^4-v*w^4+u^2*v*w^2+2*u^2*v^2*w+
u^2*v^3+u^2*w^3-2*u^3*v*w-u^3*w^2-v^3*w^2-u^4*w-2*v^4*w+2*w^5,0,-u^2*v^2*w^4-
v^4*w^4,0,u^4*v^8*w^14+u^4*v^9*w^13+u^6*v^6*w^14+u^6*v^7*w^13+u^7*v^6*w^13-
u^8*v^9*w^9+u^8*w^18+v^8*w^18-u^9*v^8*w^9-u^9*v^9*w^8+u^9*w^17+v^9*w^17+
v^13*w^13,-2*u*v*w^3-u*v^3*w+u^2*w^3+v^2*w^3-u^3*v*w+2*w^5,-u^5*v^8*w^11-
u^6*v^7*w^11,u^5*v^5*w^5+u^5*w^10+v^5*w^10,-u^25*v^34*w^49-u^27*v^32*w^49,
u^2*v^4*w^12-2*u^2*v^7*w^9+u^3*v^3*w^12-2*u^3*v^6*w^9+3*u^4*v^6*w^8+
2*u^4*v^7*w^7+u^4*w^14+v^4*w^14+3*u^5*v^5*w^8-2*u^6*v^3*w^9-3*u^6*v^6*w^6+
2*u^7*v^4*w^7+2*u^7*v^7*w^4-2*u^7*w^11-2*v^7*w^11-2*v^9*w^9,2*u*v^2*w^3+
3*u^2*v^2*w^2-u^2*w^4-v^2*w^4-2*v^3*w^3,0,-u*v^2*w^3-u*v^3*w^2-u*v^5-2*u*w^5-
2*v*w^5-2*u^2*v*w^3+4*u^2*v^2*w^2-2*u^2*v^3*w+u^2*v^4+3*u^2*w^4+3*v^2*w^4-
u^3*v*w^2-u^3*v^2*w-u^3*v^3-3*u^3*w^3-4*v^3*w^3+u^4*v^2+u^4*w^2+v^4*w^2-u^5*w-
2*v^5*w+2*w^6,0,12*u^2*v^2*w^2-4*u^3*v^3-8*u^3*w^3-12*v^3*w^3+4*w^6,
4*u^25*v^30*w^48-4*u^26*v^31*w^46,u^4*v^8*w^19-u^4*v^11*w^16-u^4*v^12*w^15+
u^6*v^6*w^19-u^6*v^9*w^16+u^6*v^11*w^14+u^7*v^10*w^14+u^8*v^8*w^15+
u^8*v^9*w^14+u^8*v^11*w^12+u^8*v^12*w^11+u^8*w^23+v^8*w^23-u^9*v^6*w^16+
u^9*v^8*w^14-u^10*v^6*w^15-u^10*v^10*w^11-u^10*v^11*w^10+u^11*v^8*w^12-
u^11*v^10*w^10+u^11*v^12*w^8-u^11*w^20-v^11*w^20+u^12*v^8*w^11+u^12*v^11*w^8-
u^12*w^19-v^12*w^19-v^15*w^16-v^16*w^15,0,0,-4*u*v^3*w^3+u*w^6+v*w^6+
6*u^2*v^2*w^3+3*u^2*v^3*w^2-2*u^3*v*w^3+3*u^3*v^2*w^2-2*u^3*v^3*w-2*u^3*v^4-
4*u^3*w^4-4*v^3*w^4-2*u^4*w^3-4*v^4*w^3+2*w^7,-u^5*v^10*w^13-u^7*v^8*w^13,
2*u^5*v^6*w^14+u^5*v^8*w^12-2*u^6*v^7*w^12-u^6*v^9*w^10+u^7*v^6*w^12-
u^8*v^7*w^10,-u^15*v^22*w^31-u^17*v^20*w^31,u^2*v^4*w^8+2*u^2*v^5*w^7+
u^2*v^6*w^6+2*u^3*v^3*w^8+4*u^3*v^4*w^7+2*u^4*v^3*w^7+u^4*v^4*w^6-
2*u^4*v^5*w^5-u^4*v^6*w^4+u^4*w^10+v^4*w^10-2*u^5*v^4*w^5-2*u^5*v^5*w^4+
2*u^5*w^9+2*v^5*w^9-u^6*v^4*w^4+v^6*w^8+v^8*w^6,0,0,4*u^5*v^6*w^12-
4*u^6*v^7*w^10,u^2*v^4*w^8+u^2*v^5*w^7+u^3*v^3*w^8+u^3*v^4*w^7+u^4*v^3*w^7-
u^4*v^5*w^5+u^4*w^10+v^4*w^10-u^5*v^4*w^5-u^5*v^5*w^4+u^5*w^9+v^5*w^9+v^7*w^7,
2*u^25*v^30*w^49+u^25*v^31*w^48+u^26*v^30*w^48-2*u^26*v^31*w^47-
u^26*v^32*w^46-u^27*v^31*w^46,-u^25*v^32*w^47-u^26*v^31*w^47,6*u^2*v^2*w^4-
4*u^2*v^3*w^3+3*u^2*v^4*w^2+u^2*w^6+v^2*w^6-2*u^3*v^2*w^3-2*u^3*v^3*w^2-
2*u^3*v^5-4*u^3*w^5-4*v^3*w^5+3*u^4*v^2*w^2-2*u^5*w^3-4*v^5*w^3+2*w^8,
18*u^25*v^30*w^46+12*u^25*v^31*w^45+10*u^26*v^30*w^45,2*u^5*v^6*w^13+
u^5*v^7*w^12+u^6*v^6*w^12-2*u^6*v^7*w^11-u^6*v^8*w^10-u^7*v^7*w^10,-
u^20*v^26*w^38-u^21*v^25*w^38,0,2*u^25*v^30*w^50+u^25*v^32*w^48-
2*u^26*v^31*w^48-u^26*v^33*w^46+u^27*v^30*w^48-u^28*v^31*w^46,8*u^5*v^6*w^13+
10*u^5*v^8*w^11+4*u^5*v^10*w^9+10*u^7*v^6*w^11+6*u^7*v^8*w^9+2*u^9*v^6*w^9,
18*u^5*v^6*w^11+12*u^5*v^8*w^9+10*u^7*v^6*w^9,-u^15*v^20*w^29-u^16*v^19*w^29,
8*u^25*v^30*w^48+5*u^25*v^31*w^47+5*u^25*v^32*w^46+4*u^25*v^33*w^45+
5*u^26*v^30*w^47+3*u^26*v^32*w^45+5*u^27*v^30*w^46+3*u^27*v^31*w^45+
2*u^28*v^30*w^45,3*u^2*v^4*w^7+2*u^2*v^5*w^6+4*u^3*v^3*w^7+3*u^3*v^4*w^6+
2*u^4*v^3*w^6-3*u^4*v^4*w^5-3*u^4*v^5*w^4+2*u^4*w^9+2*v^4*w^9-3*u^5*v^4*w^4+
u^5*w^8+v^5*w^8+v^6*w^7+v^7*w^6,0,-u^20*v^28*w^40-u^22*v^26*w^40,0,
8*u^5*v^6*w^12+5*u^5*v^7*w^11+5*u^5*v^8*w^10+4*u^5*v^9*w^9+5*u^6*v^6*w^11+
3*u^6*v^8*w^9+5*u^7*v^6*w^10+3*u^7*v^7*w^9+2*u^8*v^6*w^9,0,
2*u^10*v^12*w^22+u^10*v^13*w^21+u^11*v^12*w^21-2*u^11*v^13*w^20-
u^11*v^14*w^19-u^12*v^13*w^19,-u^10*v^14*w^20-u^11*v^13*w^20,6*u^2*v^4*w^6+
8*u^3*v^3*w^6-9*u^4*v^4*w^4+3*u^4*w^8+3*v^4*w^8+2*v^6*w^6,2*u^5*v^6*w^16+
u^5*v^7*w^15-4*u^5*v^9*w^13-4*u^5*v^10*w^12+u^6*v^6*w^15-4*u^6*v^9*w^12+
6*u^7*v^8*w^12+3*u^7*v^9*w^11-4*u^8*v^6*w^13-2*u^8*v^7*w^12+3*u^8*v^8*w^11-
2*u^8*v^9*w^10-2*u^8*v^10*w^9-2*u^9*v^6*w^12,0,2*u^10*v^12*w^26+
u^10*v^13*w^25-2*u^10*v^15*w^23-4*u^10*v^16*w^22-2*u^10*v^17*w^21+
u^11*v^12*w^25-2*u^11*v^15*w^22-2*u^11*v^16*w^21+2*u^12*v^14*w^22+
3*u^12*v^15*w^21+u^12*v^16*w^20-2*u^13*v^12*w^23-u^13*v^13*w^22+
3*u^13*v^14*w^21+2*u^13*v^15*w^20-u^13*v^16*w^19-u^13*v^17*w^18-
3*u^14*v^12*w^22-u^14*v^13*w^21+u^14*v^14*w^20-u^14*v^15*w^19-u^14*v^16*w^18-
u^15*v^12*w^21,6*u^4*v^8*w^12+8*u^6*v^6*w^12-9*u^8*v^8*w^8+3*u^8*w^16+
3*v^8*w^16+2*v^12*w^12,8*u^15*v^18*w^30+5*u^15*v^19*w^29+5*u^15*v^20*w^28+
4*u^15*v^21*w^27+5*u^16*v^18*w^29+3*u^16*v^20*w^27+5*u^17*v^18*w^28+
3*u^17*v^19*w^27+2*u^18*v^18*w^27,2*u^5*v^6*w^13+2*u^5*v^7*w^12+u^5*v^8*w^11+
2*u^5*v^9*w^10+2*u^6*v^6*w^12+u^6*v^7*w^11+u^6*v^8*w^10+u^6*v^9*w^9+
u^7*v^6*w^11+2*u^7*v^7*w^10+u^8*v^6*w^10,-u^10*v^16*w^22-u^12*v^14*w^22,
2*u^5*v^6*w^17+u^5*v^8*w^15-4*u^5*v^9*w^14-4*u^5*v^11*w^12+u^7*v^6*w^15+
6*u^7*v^8*w^13-4*u^7*v^9*w^12+3*u^7*v^10*w^11-4*u^8*v^6*w^14-2*u^8*v^8*w^12-
2*u^8*v^9*w^11-2*u^8*v^11*w^9+3*u^9*v^8*w^11-2*u^10*v^6*w^12,2*u^15*v^18*w^31+
u^15*v^19*w^30+u^16*v^18*w^30-2*u^16*v^19*w^29-u^16*v^20*w^28-u^17*v^19*w^28,
4*u^10*v^12*w^21-4*u^11*v^13*w^19,2*u^20*v^24*w^41+u^20*v^26*w^39-
2*u^21*v^25*w^39-u^21*v^27*w^37+u^22*v^24*w^39-u^23*v^25*w^37,
4*u^20*v^24*w^39-4*u^21*v^25*w^37,2*u^15*v^18*w^32+u^15*v^20*w^30-
2*u^16*v^19*w^30-u^16*v^21*w^28+u^17*v^18*w^30-u^18*v^19*w^28,-u^5*v^8*w^13-
2*u^5*v^9*w^12+2*u^6*v^8*w^12-u^7*v^6*w^13+3*u^7*v^8*w^11,2*u^10*v^12*w^25+
u^10*v^13*w^24-4*u^10*v^15*w^22-4*u^10*v^16*w^21+u^11*v^12*w^24-
4*u^11*v^15*w^21+6*u^12*v^14*w^21+3*u^12*v^15*w^20-4*u^13*v^12*w^22-
2*u^13*v^13*w^21+3*u^13*v^14*w^20-2*u^13*v^15*w^19-2*u^13*v^16*w^18-
2*u^14*v^12*w^21,4*u^5*v^6*w^15-12*u^5*v^9*w^12+12*u^7*v^8*w^11-
8*u^8*v^6*w^12-4*u^8*v^9*w^9,2*u^5*v^6*w^12+3*u^5*v^7*w^11+2*u^5*v^8*w^10+
3*u^6*v^6*w^11+4*u^6*v^7*w^10+u^6*v^8*w^9+u^7*v^6*w^10,4*u^10*v^12*w^20+
6*u^10*v^13*w^19+4*u^11*v^12*w^19+2*u^11*v^13*w^18,0,
18*u^20*v^24*w^38+12*u^20*v^26*w^36+10*u^22*v^24*w^36,4*u^5*v^6*w^11+
6*u^5*v^7*w^10+4*u^6*v^6*w^10+2*u^6*v^7*w^9,4*u^10*v^12*w^24-
12*u^10*v^15*w^21+12*u^12*v^14*w^20-8*u^13*v^12*w^21-4*u^13*v^15*w^18,
8*u^5*v^6*w^11+10*u^5*v^7*w^10+4*u^5*v^8*w^9+10*u^6*v^6*w^10+6*u^6*v^7*w^9+
2*u^7*v^6*w^9,2*u^10*v^12*w^21+3*u^10*v^13*w^20+2*u^10*v^14*w^19+
3*u^11*v^12*w^20+4*u^11*v^13*w^19+u^11*v^14*w^18+u^12*v^12*w^19,
4*u^15*v^18*w^30-4*u^16*v^19*w^28,18*u^25*v^30*w^47+12*u^25*v^32*w^45+
10*u^27*v^30*w^45,8*u^10*v^12*w^20+10*u^10*v^13*w^19+4*u^10*v^14*w^18+
10*u^11*v^12*w^19+6*u^11*v^13*w^18+2*u^12*v^12*w^18,18*u^5*v^6*w^10+
12*u^5*v^7*w^9+10*u^6*v^6*w^9,40*u^5*v^6*w^9,8*u^15*v^18*w^29+
10*u^15*v^19*w^28+4*u^15*v^20*w^27+10*u^16*v^18*w^28+6*u^16*v^19*w^27+
2*u^17*v^18*w^27,18*u^15*v^18*w^29+12*u^15*v^20*w^27+10*u^17*v^18*w^27,
18*u^10*v^12*w^19+12*u^10*v^13*w^18+10*u^11*v^12*w^18,18*u^15*v^18*w^28+
12*u^15*v^19*w^27+10*u^16*v^18*w^27,40*u^25*v^30*w^45,40*u^15*v^18*w^27,
40*u^10*v^12*w^18,40*u^20*v^24*w^36];end;
  f45:=function(u,v,w,j)return[45,18*u+18*v+9*w,8*u*v+2*u*w+2*v*w+
3*u^2+3*v^2,14*u*v+8*u*w+8*v*w+7*u^2+7*v^2+w^2,18*u^2+18*v^2+9*w^2,-5*u*v*w+
3*u^3+3*v^3,4*u*v*w+4*u*v^2+4*u^2*v+2*u^2*w+2*v^2*w+u^3+v^3,-j^2*u*v*w+
u*v^2+u^2*v,7*u*v^2+4*u*w^2+4*v*w^2+7*u^2*v+4*u^2*w+4*v^2*w+7*u^3+7*v^3+w^3,-
u*v^2*w-u^2*v*w-u^2*v^2,-u^3*v^9*w^7-u^3*v^10*w^6+u^3*v^13*w^3-
j^2*u^4*v^7*w^8-j^2*u^4*v^8*w^7+u^4*v^13*w^2+u^4*v^15+u^5*v^8*w^6+
u^5*v^9*w^5+j^2*u^6*v^6*w^7+j^2*u^6*v^7*w^6+2*u^6*v^8*w^5+u^6*v^9*w^4-
u^6*v^10*w^3-j^2*u^7*v^4*w^8+j^2*u^7*v^6*w^6+(-j-2*j^2)*u^7*v^8*w^4-
u^7*v^9*w^3-u^7*v^10*w^2-u^7*v^12-j^2*u^8*v^4*w^7+u^8*v^5*w^6+
2*u^8*v^6*w^5+(-j-2*j^2)*u^8*v^7*w^4-u^8*v^9*w^2-u^8*v^11-u^9*v^3*w^7+
u^9*v^5*w^5+u^9*v^6*w^4-u^9*v^7*w^3-u^9*v^8*w^2-u^9*v^10-u^10*v^3*w^6-
u^10*v^6*w^3-u^10*v^7*w^2-u^10*v^9-u^11*v^8-u^12*v^7+u^13*v^3*w^3+
u^13*v^4*w^2+u^15*v^4,2*u*v*w^2+u*v^2*w+3*u*v^3+u^2*v*w+2*u^2*v^2+u^2*w^2+
v^2*w^2+3*u^3*v+u^3*w+v^3*w+u^4+v^4,0,14*u^2*v^2+8*u^2*w^2+8*v^2*w^2+7*u^4+
7*v^4+w^4,5*u^2*v^2*w^3+5*u^2*v^3*w^2+5*u^3*v^2*w^2-8*u^3*v^4-2*u^3*w^4-
2*v^3*w^4-8*u^4*v^3-2*u^4*w^3-2*v^4*w^3+3*u^7+3*v^7,-u*v*w^2-2*u*v^2*w+u*v^3-
2*u^2*v*w+u^3*v+u^3*w+v^3*w+u^4+v^4,-2*u*v*w^3+2*u*v^2*w^2-3*u*v^3*w-2*u*v^4+
2*u^2*v*w^2+u^2*v^2*w-u^2*v^3-3*u^3*v*w-u^3*v^2+2*u^3*w^2+2*v^3*w^2-2*u^4*v+
u^5+v^5,0,-u^2*v^4*w^2-u^4*v^2*w^2-u^4*v^4,j^2*u^2*v^2*w,u^6*v^13*w^7+
u^6*v^14*w^6+u^7*v^13*w^6+j*u^8*v^9*w^9+u^8*v^14*w^4+u^8*v^18+
j*u^9*v^8*w^9+j*u^9*v^9*w^8+u^9*v^13*w^4+u^9*v^17+u^13*v^6*w^7+
u^13*v^7*w^6+u^13*v^9*w^4+u^13*v^13+u^14*v^6*w^6+u^14*v^8*w^4+u^17*v^9+
u^18*v^8,-u*v*w^3-2*u*v^3*w+u^2*v^3-2*u^3*v*w+u^3*v^2+u^3*w^2+v^3*w^2+u^5+v^5,
-j^2*u^9*v^10*w^5-j^2*u^10*v^9*w^5-j^2*u^10*v^10*w^4,-
j*u^5*v^5*w^5+u^5*v^10+u^10*v^5,-j*u^42*v^44*w^22-j*u^44*v^42*w^22-
j*u^44*v^44*w^20,-2*u^3*v^9*w^6+u^3*v^12*w^3-2*j^2*u^4*v^7*w^7+
u^4*v^12*w^2+u^4*v^14+3*u^5*v^8*w^5+3*j^2*u^6*v^6*w^6+3*u^6*v^8*w^4-
2*u^6*v^9*w^3-2*j^2*u^7*v^4*w^7-2*j^2*u^7*v^7*w^4-2*u^7*v^9*w^2-
2*u^7*v^11+3*u^8*v^5*w^5+3*u^8*v^6*w^4-2*u^9*v^3*w^6-2*u^9*v^6*w^3-
2*u^9*v^7*w^2-2*u^9*v^9-2*u^11*v^7+u^12*v^3*w^3+u^12*v^4*w^2+u^14*v^4,-
3*j*u^2*v^2*w^2+2*u^2*v^3*w-u^2*v^4+2*u^3*v^2*w-2*u^3*v^3-u^4*v^2,0,-
u*v^2*w^3-2*u*v^3*w^2-3*u*v^5-u^2*v*w^3+5*u^2*v^2*w^2-u^2*v^3*w+3*u^2*v^4+
u^2*w^4+v^2*w^4-2*u^3*v*w^2-u^3*v^2*w-6*u^3*v^3-u^3*w^3-v^3*w^3+3*u^4*v^2+
3*u^4*w^2+3*v^4*w^2-3*u^5*v-u^5*w-v^5*w+u^6+v^6,
-j*u^4*v^4*w^4-j*u^4*v^6*w^2-j*u^6*v^4*w^2,
15*u^2*v^2*w^2-16*u^3*v^3-4*u^3*w^3-4*v^3*w^3+3*u^6+3*v^6,3*j*u^40*v^43*w^20-
5*j*u^41*v^41*w^21+3*j*u^43*v^40*w^20,-u^6*v^15*w^10-u^6*v^16*w^9+
u^6*v^19*w^6-j*u^8*v^11*w^12-j*u^8*v^12*w^11+u^8*v^14*w^9+u^8*v^15*w^8+
u^8*v^19*w^4+u^8*v^23+u^9*v^14*w^8-u^9*v^16*w^6+j*u^10*v^10*w^11+
j*u^10*v^11*w^10+u^10*v^14*w^7-j*u^11*v^8*w^12+j*u^11*v^10*w^10-
j*u^11*v^12*w^8+u^11*v^14*w^6-u^11*v^16*w^4-u^11*v^20-j*u^12*v^8*w^11-
j*u^12*v^11*w^8-u^12*v^15*w^4-u^12*v^19+u^14*v^8*w^9+u^14*v^9*w^8+
u^14*v^10*w^7+u^14*v^11*w^6-u^15*v^6*w^10+u^15*v^8*w^8-u^15*v^12*w^4-
u^15*v^16-u^16*v^6*w^9-u^16*v^9*w^6-u^16*v^11*w^4-u^16*v^15+u^19*v^6*w^6+
u^19*v^8*w^4-u^19*v^12-u^20*v^11+u^23*v^8,j*u^10*v^10*w^5,0,-2*u*v^3*w^3+u*v^6+
3*u^2*v^2*w^3+6*u^2*v^3*w^2-2*u^3*v*w^3+6*u^3*v^2*w^2-4*u^3*v^3*w-6*u^3*v^4-
6*u^4*v^3-2*u^4*w^3-2*v^4*w^3+u^6*v+u^6*w+v^6*w+u^7+v^7,-j^2*u^10*v^12*w^6-
j^2*u^12*v^10*w^6-j^2*u^12*v^12*w^4,j^2*u^8*v^11*w^6+
j^2*u^8*v^13*w^4-j^2*u^9*v^9*w^7-2*j^2*u^9*v^11*w^5+
j^2*u^10*v^11*w^4+j^2*u^11*v^8*w^6-2*j^2*u^11*v^9*w^5+
j^2*u^11*v^10*w^4+j^2*u^13*v^8*w^4,-u^26*v^28*w^14-u^28*v^26*w^14-
u^28*v^28*w^12,2*u^3*v^7*w^4+2*u^3*v^8*w^3+j^2*u^4*v^4*w^6+
2*j^2*u^4*v^5*w^5+(-2*j-j^2)*u^4*v^6*w^4+4*u^4*v^7*w^3+u^4*v^8*w^2+
u^4*v^10+2*j^2*u^5*v^4*w^5+2*j^2*u^5*v^5*w^4+2*u^5*v^7*w^2+2*u^5*v^9+
(-2*j-j^2)*u^6*v^4*w^4+2*u^6*v^6*w^2+u^6*v^8+2*u^7*v^3*w^4+4*u^7*v^4*w^3+
2*u^7*v^5*w^2+2*u^8*v^3*w^3+u^8*v^4*w^2+u^8*v^6+2*u^9*v^5+u^10*v^4,
# d=+-E(3)
u^4*v^4*w^2*Mvp("d")*(u+v+w),
0,3*j^2*u^8*v^11*w^4-5*j^2*u^9*v^9*w^5+3*j^2*u^11*v^8*w^4,
u^3*v^7*w^4+u^3*v^8*w^3+j^2*u^4*v^5*w^5+u^4*v^7*w^3+u^4*v^8*w^2+u^4*v^10+
j^2*u^5*v^4*w^5+j^2*u^5*v^5*w^4+u^5*v^7*w^2+u^5*v^9+u^7*v^3*w^4+
u^7*v^4*w^3+u^7*v^5*w^2+u^7*v^7+u^8*v^3*w^3+u^8*v^4*w^2+u^9*v^5+u^10*v^4,
j*u^40*v^43*w^21+j*u^40*v^44*w^20-j*u^41*v^41*w^22-
2*j*u^41*v^42*w^21+j*u^41*v^43*w^20-2*j*u^42*v^41*w^21+
j*u^43*v^40*w^21+j*u^43*v^41*w^20+j*u^44*v^40*w^20,-
j*u^41*v^42*w^21-j*u^42*v^41*w^21-j*u^42*v^42*w^20,3*u^2*v^2*w^4-
2*u^2*v^3*w^3+6*u^2*v^4*w^2+u^2*v^6-2*u^3*v^2*w^3-4*u^3*v^3*w^2-6*u^3*v^5+
6*u^4*v^2*w^2-6*u^5*v^3-2*u^5*w^3-2*v^5*w^3+u^6*v^2+u^6*w^2+v^6*w^2+u^8+v^8,
9*j*u^40*v^40*w^21+18*j*u^40*v^41*w^20+18*j*u^41*v^40*w^20,
j^2*u^8*v^11*w^5+j^2*u^8*v^12*w^4-j^2*u^9*v^9*w^6-
2*j^2*u^9*v^10*w^5+j^2*u^9*v^11*w^4-2*j^2*u^10*v^9*w^5+
j^2*u^11*v^8*w^5+j^2*u^11*v^9*w^4+j^2*u^12*v^8*w^4,-
j^2*u^33*v^34*w^17-j^2*u^34*v^33*w^17-j^2*u^34*v^34*w^16,u^6*v^6*w^3,
j*u^40*v^43*w^22+j*u^40*v^45*w^20-j*u^41*v^41*w^23-
2*j*u^41*v^43*w^21+j*u^42*v^43*w^20+j*u^43*v^40*w^22-
2*j*u^43*v^41*w^21+j*u^43*v^42*w^20+j*u^45*v^40*w^20,
j^2*u^8*v^8*w^8+8*j^2*u^8*v^10*w^6+7*j^2*u^8*v^12*w^4+
8*j^2*u^10*v^8*w^6+14*j^2*u^10*v^10*w^4+7*j^2*u^12*v^8*w^4,
9*j^2*u^8*v^8*w^6+18*j^2*u^8*v^10*w^4+18*j^2*u^10*v^8*w^4,-
u^25*v^26*w^13-u^26*v^25*w^13-u^26*v^26*w^12,j*u^40*v^40*w^23+
4*j*u^40*v^41*w^22+4*j*u^40*v^42*w^21+7*j*u^40*v^43*w^20+
4*j*u^41*v^40*w^22+7*j*u^41*v^42*w^20+4*j*u^42*v^40*w^21+
7*j*u^42*v^41*w^20+7*j*u^43*v^40*w^20,2*u^3*v^6*w^4+4*u^3*v^7*w^3+
3*j^2*u^4*v^4*w^5+3*j^2*u^4*v^5*w^4+3*u^4*v^6*w^3+3*u^4*v^7*w^2+
2*u^4*v^9+3*j^2*u^5*v^4*w^4+2*u^5*v^6*w^2+u^5*v^8+2*u^6*v^3*w^4+
3*u^6*v^4*w^3+2*u^6*v^5*w^2+u^6*v^7+4*u^7*v^3*w^3+3*u^7*v^4*w^2+u^7*v^6+
u^8*v^5+2*u^9*v^4,
j^2*Mvp("d")*u^12*v^12*w^6*(u+v+w),
-j^2*u^34*v^36*w^18-j^2*u^36*v^34*w^18-j^2*u^36*v^36*w^16,
-3*j*u^4*v^4*w^2,j^2*u^8*v^8*w^7+
4*j^2*u^8*v^9*w^6+4*j^2*u^8*v^10*w^5+7*j^2*u^8*v^11*w^4+
4*j^2*u^9*v^8*w^6+7*j^2*u^9*v^10*w^4+4*j^2*u^10*v^8*w^5+
7*j^2*u^10*v^9*w^4+7*j^2*u^11*v^8*w^4,-3*j^2*u^20*v^20*w^10,j*u^16*v^19*w^9+
j*u^16*v^20*w^8-j*u^17*v^17*w^10-2*j*u^17*v^18*w^9+
j*u^17*v^19*w^8-2*j*u^18*v^17*w^9+j*u^19*v^16*w^9+j*u^19*v^17*w^8+
j*u^20*v^16*w^8,-j*u^17*v^18*w^9-j*u^18*v^17*w^9-j*u^18*v^18*w^8,
8*u^3*v^6*w^3+9*j^2*u^4*v^4*w^4+6*u^4*v^6*w^2+3*u^4*v^8+8*u^6*v^3*w^3+
6*u^6*v^4*w^2+2*u^6*v^6+3*u^8*v^4,-2*j^2*u^8*v^12*w^7+j^2*u^8*v^14*w^5+
j^2*u^8*v^15*w^4-2*j^2*u^9*v^11*w^7+j^2*u^9*v^14*w^4+
3*j^2*u^10*v^10*w^7+6*j^2*u^10*v^11*w^6-2*j^2*u^11*v^9*w^7+
6*j^2*u^11*v^10*w^6-4*j^2*u^11*v^11*w^5-6*j^2*u^11*v^12*w^4-
2*j^2*u^12*v^8*w^7-6*j^2*u^12*v^11*w^4+j^2*u^14*v^8*w^5+
j^2*u^14*v^9*w^4+j^2*u^15*v^8*w^4,0,-j*u^16*v^20*w^12-
j*u^16*v^21*w^11+j*u^16*v^23*w^9+j*u^16*v^24*w^8-j*u^17*v^19*w^12-
j*u^17*v^20*w^11+j*u^17*v^23*w^8+j*u^18*v^18*w^12+
3*j*u^18*v^19*w^11+2*j*u^18*v^20*w^10-j*u^19*v^17*w^12+
3*j*u^19*v^18*w^11+4*j*u^19*v^19*w^10-2*j*u^19*v^20*w^9-
3*j*u^19*v^21*w^8-j*u^20*v^16*w^12-j*u^20*v^17*w^11+
2*j*u^20*v^18*w^10-2*j*u^20*v^19*w^9-6*j*u^20*v^20*w^8-
j*u^21*v^16*w^11-3*j*u^21*v^19*w^8+j*u^23*v^16*w^9+
j*u^23*v^17*w^8+j*u^24*v^16*w^8,8*u^6*v^12*w^6+9*j*u^8*v^8*w^8+
6*u^8*v^12*w^4+3*u^8*v^16+8*u^12*v^6*w^6+6*u^12*v^8*w^4+2*u^12*v^12+
3*u^16*v^8,u^24*v^24*w^15+4*u^24*v^25*w^14+4*u^24*v^26*w^13+7*u^24*v^27*w^12+
4*u^25*v^24*w^14+7*u^25*v^26*w^12+4*u^26*v^24*w^13+7*u^26*v^25*w^12+
7*u^27*v^24*w^12,j^2*u^8*v^10*w^6+j^2*u^8*v^11*w^5+j^2*u^8*v^12*w^4+
2*j^2*u^9*v^9*w^6+j^2*u^9*v^10*w^5+3*j^2*u^9*v^11*w^4+
j^2*u^10*v^8*w^6+j^2*u^10*v^9*w^5+2*j^2*u^10*v^10*w^4+
j^2*u^11*v^8*w^5+3*j^2*u^11*v^9*w^4+j^2*u^12*v^8*w^4,-
j*u^18*v^20*w^10-j*u^20*v^18*w^10-j*u^20*v^20*w^8,-
2*j^2*u^8*v^13*w^7+j^2*u^8*v^14*w^6+j^2*u^8*v^16*w^4+
3*j^2*u^10*v^10*w^8-2*j^2*u^10*v^11*w^7+6*j^2*u^10*v^12*w^6+
j^2*u^10*v^14*w^4-2*j^2*u^11*v^10*w^7-4*j^2*u^11*v^11*w^6-
6*j^2*u^11*v^13*w^4+6*j^2*u^12*v^10*w^6-2*j^2*u^13*v^8*w^7-
6*j^2*u^13*v^11*w^4+j^2*u^14*v^8*w^6+j^2*u^14*v^10*w^4+
j^2*u^16*v^8*w^4,u^24*v^27*w^13+u^24*v^28*w^12-u^25*v^25*w^14-
2*u^25*v^26*w^13+u^25*v^27*w^12-2*u^26*v^25*w^13+u^27*v^24*w^13+
u^27*v^25*w^12+u^28*v^24*w^12,3*j*u^16*v^19*w^8-5*j*u^17*v^17*w^9+
3*j*u^19*v^16*w^8,j^2*u^32*v^35*w^18+j^2*u^32*v^37*w^16-
j^2*u^33*v^33*w^19-2*j^2*u^33*v^35*w^17+j^2*u^34*v^35*w^16+
j^2*u^35*v^32*w^18-2*j^2*u^35*v^33*w^17+j^2*u^35*v^34*w^16+
j^2*u^37*v^32*w^16,3*j^2*u^32*v^35*w^16-5*j^2*u^33*v^33*w^17+
3*j^2*u^35*v^32*w^16,u^24*v^27*w^14+u^24*v^29*w^12-u^25*v^25*w^15-
2*u^25*v^27*w^13+u^26*v^27*w^12+u^27*v^24*w^14-2*u^27*v^25*w^13+
u^27*v^26*w^12+u^29*v^24*w^12,-3*u^10*v^10*w^6+2*j^2*u^10*v^11*w^5-
j^2*u^10*v^12*w^4+2*j^2*u^11*v^10*w^5-2*j^2*u^11*v^11*w^4-
j^2*u^12*v^10*w^4,-2*j*u^16*v^20*w^11+j*u^16*v^22*w^9+
j*u^16*v^23*w^8-2*j*u^17*v^19*w^11+j*u^17*v^22*w^8+
3*j*u^18*v^18*w^11+6*j*u^18*v^19*w^10-2*j*u^19*v^17*w^11+
6*j*u^19*v^18*w^10-4*j*u^19*v^19*w^9-6*j*u^19*v^20*w^8-
2*j*u^20*v^16*w^11-6*j*u^20*v^19*w^8+j*u^22*v^16*w^9+
j*u^22*v^17*w^8+j*u^23*v^16*w^8,-4*j^2*u^8*v^11*w^7+
3*j^2*u^8*v^14*w^4+15*j^2*u^10*v^10*w^6-4*j^2*u^11*v^8*w^7-
16*j^2*u^11*v^11*w^4+3*j^2*u^14*v^8*w^4,2*j^2*u^8*v^10*w^5+
j^2*u^8*v^11*w^4+4*j^2*u^9*v^9*w^5+4*j^2*u^9*v^10*w^4+
2*j^2*u^10*v^8*w^5+4*j^2*u^10*v^9*w^4+j^2*u^11*v^8*w^4,
2*j*u^16*v^17*w^9+3*j*u^16*v^18*w^8+2*j*u^17*v^16*w^9+
8*j*u^17*v^17*w^8+3*j*u^18*v^16*w^8,-3*u^12*v^12*w^6,9*j^2*u^32*v^32*w^18+
18*j^2*u^32*v^34*w^16+18*j^2*u^34*v^32*w^16,2*j^2*u^8*v^9*w^5+
3*j^2*u^8*v^10*w^4+2*j^2*u^9*v^8*w^5+8*j^2*u^9*v^9*w^4+
3*j^2*u^10*v^8*w^4,-4*j*u^16*v^19*w^11+3*j*u^16*v^22*w^8+
15*j*u^18*v^18*w^10-4*j*u^19*v^16*w^11-16*j*u^19*v^19*w^8+
3*j*u^22*v^16*w^8,j^2*u^8*v^8*w^6+8*j^2*u^8*v^9*w^5+
7*j^2*u^8*v^10*w^4+8*j^2*u^9*v^8*w^5+14*j^2*u^9*v^9*w^4+
7*j^2*u^10*v^8*w^4,2*j*u^16*v^18*w^9+j*u^16*v^19*w^8+
4*j*u^17*v^17*w^9+4*j*u^17*v^18*w^8+2*j*u^18*v^16*w^9+
4*j*u^18*v^17*w^8+j*u^19*v^16*w^8,3*u^24*v^27*w^12-5*u^25*v^25*w^13+
3*u^27*v^24*w^12,9*j*u^40*v^40*w^22+18*j*u^40*v^42*w^20+
18*j*u^42*v^40*w^20,j*u^16*v^16*w^10+8*j*u^16*v^17*w^9+
7*j*u^16*v^18*w^8+8*j*u^17*v^16*w^9+14*j*u^17*v^17*w^8+
7*j*u^18*v^16*w^8,9*j^2*u^8*v^8*w^5+18*j^2*u^8*v^9*w^4+
18*j^2*u^9*v^8*w^4,45*j^2*u^8*v^8*w^4,u^24*v^24*w^14+8*u^24*v^25*w^13+
7*u^24*v^26*w^12+8*u^25*v^24*w^13+14*u^25*v^25*w^12+7*u^26*v^24*w^12,
9*u^24*v^24*w^14+18*u^24*v^26*w^12+18*u^26*v^24*w^12,9*j*u^16*v^16*w^9+
18*j*u^16*v^17*w^8+18*j*u^17*v^16*w^8,9*u^24*v^24*w^13+
18*u^24*v^25*w^12+18*u^25*v^24*w^12,45*j*u^40*v^40*w^20,45*u^24*v^24*w^12,
45*j*u^16*v^16*w^8,45*j^2*u^32*v^32*w^16];end;
  f60a:=function(u,v,w)return [60,18*u+21*v+21*w,4*u*v+
4*u*w+7*v*w+2*u^2+2*v^2+2*w^2,14*u*v+14*u*w+12*v*w+4*u^2+8*v^2+8*w^2,18*u^2+
21*v^2+21*w^2,-8*u*v*w+2*u^3+2*v^3+2*w^3,5*u*v*w+3*u*v^2+3*u*w^2+2*v*w^2+
2*u^2*v+2*u^2*w+2*v^2*w+v^3+w^3,u*v*w,7*u*v^2+7*u*w^2+6*v*w^2+7*u^2*v+7*u^2*w+
6*v^2*w+4*u^3+8*v^3+8*w^3,-u*v*w^2-u*v^2*w-v^2*w^2,u^2*v^4*w^13-u^2*v^7*w^10-
u^2*v^8*w^9-u^2*v^9*w^8-u^2*v^10*w^7+u^2*v^13*w^4+u^3*v^3*w^13-u^3*v^6*w^10-
u^3*v^7*w^9-u^3*v^9*w^7-u^3*v^10*w^6+u^3*v^13*w^3+u^4*v^6*w^9+2*u^4*v^7*w^8+
2*u^4*v^8*w^7+u^4*v^9*w^6+u^5*v^5*w^9+2*u^5*v^6*w^8+2*u^5*v^8*w^6+u^5*v^9*w^5-
u^6*v^3*w^10+u^6*v^5*w^8-u^6*v^6*w^7-u^6*v^7*w^6+u^6*v^8*w^5-u^6*v^10*w^3-
u^7*v^3*w^9+u^7*v^4*w^8-u^7*v^6*w^6+u^7*v^8*w^4-u^7*v^9*w^3+2*u^8*v^4*w^7+
u^8*v^5*w^6+u^8*v^6*w^5+2*u^8*v^7*w^4-u^9*v^2*w^8+u^9*v^4*w^6+u^9*v^6*w^4-
u^9*v^8*w^2-v^9*w^10-u^10*v^2*w^7-u^10*v^7*w^2-v^10*w^9+u^13*v^2*w^4+
u^13*v^4*w^2,u*v*w^2+u*v^2*w+2*u*v^3+2*u*w^3+2*v*w^3+3*u^2*v*w+2*u^2*v^2+
2*u^2*w^2+u^3*v+u^3*w+2*v^3*w+v^4+w^4,0,14*u^2*v^2+14*u^2*w^2+12*v^2*w^2+
4*u^4+8*v^4+8*w^4,8*u^2*v^2*w^3+8*u^2*v^3*w^2+8*u^3*v^2*w^2-4*u^3*v^4-
4*u^3*w^4-7*v^3*w^4-4*u^4*v^3-4*u^4*w^3-7*v^4*w^3+2*u^7+2*v^7+2*w^7,-
3*u*v*w^2-3*u*v^2*w+u*v^3+u*w^3-2*u^2*v*w+u^3*v+u^3*w+v^4+w^4,-4*u*v*w^3+
2*u*v^2*w^2-4*u*v^3*w-u*v^4-u*w^4-2*v*w^4+3*u^2*v*w^2+3*u^2*v^2*w+2*u^2*v^3+
2*u^2*w^3+v^2*w^3-2*u^3*v*w+v^3*w^2-2*v^4*w+v^5+w^5,0,-u^2*v^2*w^4-
u^2*v^4*w^2-v^4*w^4,0,u^4*v^8*w^14+u^4*v^9*w^13+u^4*v^13*w^9+u^4*v^14*w^8+
u^6*v^6*w^14+u^6*v^7*w^13+u^6*v^13*w^7+u^6*v^14*w^6+u^7*v^6*w^13+u^7*v^13*w^6-
u^8*v^9*w^9-u^9*v^8*w^9-u^9*v^9*w^8+u^13*v^4*w^9+u^13*v^9*w^4+v^13*w^13+
u^14*v^4*w^8+u^14*v^8*w^4,-3*u*v*w^3-3*u*v^3*w+u^2*v^3+u^2*w^3-2*u^3*v*w+
u^3*v^2+u^3*w^2+v^5+w^5,u^6*v^9*w^9+u^7*v^8*w^9+u^7*v^9*w^8,u^5*v^5*w^5,
u^30*v^39*w^39+u^32*v^37*w^39+u^32*v^39*w^37,u^2*v^4*w^12-2*u^2*v^7*w^9-
2*u^2*v^9*w^7+u^2*v^12*w^4+u^3*v^3*w^12-2*u^3*v^6*w^9-2*u^3*v^9*w^6+
u^3*v^12*w^3+3*u^4*v^6*w^8+2*u^4*v^7*w^7+3*u^4*v^8*w^6+3*u^5*v^5*w^8+
3*u^5*v^8*w^5-2*u^6*v^3*w^9-3*u^6*v^6*w^6-2*u^6*v^9*w^3+2*u^7*v^4*w^7+
2*u^7*v^7*w^4+3*u^8*v^4*w^6+3*u^8*v^6*w^4-2*u^9*v^2*w^7-2*u^9*v^7*w^2-
2*v^9*w^9+u^12*v^2*w^4+u^12*v^4*w^2,2*u*v^2*w^3+2*u*v^3*w^2+3*u^2*v^2*w^2+
2*u^3*v*w^2+2*u^3*v^2*w-2*v^3*w^3,0,-u*v^2*w^3-u*v^3*w^2-2*u*v^5-2*u*w^5-
2*v*w^5-3*u^2*v*w^3+8*u^2*v^2*w^2-3*u^2*v^3*w+4*u^2*v^4+4*u^2*w^4+3*v^2*w^4-
u^3*v*w^2-u^3*v^2*w-3*u^3*v^3-3*u^3*w^3-4*v^3*w^3+3*u^4*v^2+3*u^4*w^2+
3*v^4*w^2-u^5*v-u^5*w-2*v^5*w+v^6+w^6,0,24*u^2*v^2*w^2-8*u^3*v^3-
8*u^3*w^3-14*v^3*w^3+2*u^6+2*v^6+2*w^6,-2*u^30*v^35*w^38-2*u^30*v^38*w^35+
8*u^31*v^36*w^36-2*u^33*v^35*w^35,u^4*v^8*w^19-u^4*v^11*w^16-u^4*v^12*w^15-
u^4*v^15*w^12-u^4*v^16*w^11+u^4*v^19*w^8+u^6*v^6*w^19-u^6*v^9*w^16+
u^6*v^11*w^14+u^6*v^14*w^11-u^6*v^16*w^9+u^6*v^19*w^6+u^7*v^10*w^14+
u^7*v^14*w^10+u^8*v^8*w^15+u^8*v^9*w^14+u^8*v^11*w^12+u^8*v^12*w^11+
u^8*v^14*w^9+u^8*v^15*w^8-u^9*v^6*w^16+u^9*v^8*w^14+u^9*v^14*w^8-u^9*v^16*w^6-
u^10*v^6*w^15-u^10*v^10*w^11-u^10*v^11*w^10-u^10*v^15*w^6+u^11*v^8*w^12-
u^11*v^10*w^10+u^11*v^12*w^8+u^12*v^8*w^11+u^12*v^11*w^8+u^14*v^6*w^11+
u^14*v^7*w^10+u^14*v^10*w^7+u^14*v^11*w^6-u^15*v^4*w^12+u^15*v^6*w^10+
u^15*v^10*w^6-u^15*v^12*w^4-v^15*w^16-u^16*v^4*w^11-u^16*v^11*w^4-v^16*w^15+
u^19*v^4*w^8+u^19*v^8*w^4,0,0,-6*u*v^3*w^3+u*v^6+u*w^6+9*u^2*v^2*w^3+
9*u^2*v^3*w^2-2*u^3*v*w^3+6*u^3*v^2*w^2-2*u^3*v^3*w-4*u^3*v^4-4*u^3*w^4-
4*v^3*w^4-2*u^4*v^3-2*u^4*w^3-4*v^4*w^3+u^6*v+u^6*w+v^7+w^7,u^6*v^11*w^11+
u^8*v^9*w^11+u^8*v^11*w^9,-u^6*v^7*w^12-u^6*v^12*w^7+3*u^7*v^8*w^10+
3*u^7*v^10*w^8-u^8*v^7*w^10-u^8*v^10*w^7-u^9*v^7*w^9+2*u^9*v^8*w^8-
u^9*v^9*w^7,u^18*v^25*w^25+u^20*v^23*w^25+u^20*v^25*w^23,u^2*v^4*w^8+
2*u^2*v^5*w^7+2*u^2*v^6*w^6+2*u^2*v^7*w^5+u^2*v^8*w^4+2*u^3*v^3*w^8+
4*u^3*v^4*w^7+4*u^3*v^7*w^4+2*u^3*v^8*w^3+2*u^4*v^3*w^7+u^4*v^4*w^6-
2*u^4*v^5*w^5+u^4*v^6*w^4+2*u^4*v^7*w^3-2*u^5*v^4*w^5-2*u^5*v^5*w^4+
u^6*v^2*w^6-u^6*v^4*w^4+u^6*v^6*w^2+v^6*w^8+2*u^7*v^2*w^5+2*u^7*v^3*w^4+
2*u^7*v^4*w^3+2*u^7*v^5*w^2+u^8*v^2*w^4+u^8*v^4*w^2+v^8*w^6,0,0,-
2*u^6*v^7*w^10-2*u^6*v^10*w^7+8*u^7*v^8*w^8-2*u^9*v^7*w^7,u^2*v^4*w^8+
u^2*v^5*w^7+u^2*v^7*w^5+u^2*v^8*w^4+u^3*v^3*w^8+u^3*v^4*w^7+u^3*v^7*w^4+
u^3*v^8*w^3+u^4*v^3*w^7-u^4*v^5*w^5+u^4*v^7*w^3-u^5*v^4*w^5-u^5*v^5*w^4+
u^7*v^2*w^5+u^7*v^5*w^2+v^7*w^7+u^8*v^2*w^4+u^8*v^4*w^2,-u^30*v^35*w^39-
u^30*v^39*w^35-u^31*v^35*w^38+3*u^31*v^36*w^37+3*u^31*v^37*w^36-
u^31*v^38*w^35+2*u^32*v^36*w^36-u^33*v^35*w^36-u^33*v^36*w^35,u^30*v^37*w^37+
u^31*v^36*w^37+u^31*v^37*w^36,9*u^2*v^2*w^4-6*u^2*v^3*w^3+9*u^2*v^4*w^2+
u^2*v^6+u^2*w^6-2*u^3*v^2*w^3-2*u^3*v^3*w^2-4*u^3*v^5-4*u^3*w^5-4*v^3*w^5+
6*u^4*v^2*w^2-2*u^5*v^3-2*u^5*w^3-4*v^5*w^3+u^6*v^2+u^6*w^2+v^8+w^8,-
21*u^30*v^35*w^36-21*u^30*v^36*w^35-18*u^31*v^35*w^35,-u^6*v^7*w^11-
u^6*v^11*w^7-u^7*v^7*w^10+3*u^7*v^8*w^9+3*u^7*v^9*w^8-u^7*v^10*w^7+
2*u^8*v^8*w^8-u^9*v^7*w^8-u^9*v^8*w^7,-u^24*v^30*w^30-u^25*v^29*w^30-
u^25*v^30*w^29,0,-u^30*v^35*w^40-u^30*v^40*w^35+3*u^31*v^36*w^38+
3*u^31*v^38*w^36-u^32*v^35*w^38-u^32*v^38*w^35-u^33*v^35*w^37+
2*u^33*v^36*w^36-u^33*v^37*w^35,-8*u^6*v^7*w^11-12*u^6*v^9*w^9-8*u^6*v^11*w^7-
14*u^8*v^7*w^9-14*u^8*v^9*w^7-4*u^10*v^7*w^7,-21*u^6*v^7*w^9-21*u^6*v^9*w^7-
18*u^8*v^7*w^7,u^18*v^23*w^23+u^19*v^22*w^23+u^19*v^23*w^22,-8*u^30*v^35*w^38-
6*u^30*v^36*w^37-6*u^30*v^37*w^36-8*u^30*v^38*w^35-7*u^31*v^35*w^37-
7*u^31*v^37*w^35-7*u^32*v^35*w^36-7*u^32*v^36*w^35-4*u^33*v^35*w^35,
3*u^2*v^4*w^7+2*u^2*v^5*w^6+2*u^2*v^6*w^5+3*u^2*v^7*w^4+4*u^3*v^3*w^7+
3*u^3*v^4*w^6+3*u^3*v^6*w^4+4*u^3*v^7*w^3+2*u^4*v^3*w^6-3*u^4*v^4*w^5-
3*u^4*v^5*w^4+2*u^4*v^6*w^3-3*u^5*v^4*w^4+2*u^6*v^2*w^5+u^6*v^3*w^4+
u^6*v^4*w^3+2*u^6*v^5*w^2+v^6*w^7+3*u^7*v^2*w^4+3*u^7*v^4*w^2+v^7*w^6,
0,-u^24*v^32*w^32-u^26*v^30*w^32-u^26*v^32*w^30,0,-8*u^6*v^7*w^10-
6*u^6*v^8*w^9-6*u^6*v^9*w^8-8*u^6*v^10*w^7-7*u^7*v^7*w^9-7*u^7*v^9*w^7-
7*u^8*v^7*w^8-7*u^8*v^8*w^7-4*u^9*v^7*w^7,0,u^12*v^14*w^18+
u^12*v^18*w^14+u^13*v^14*w^17-3*u^13*v^15*w^16-3*u^13*v^16*w^15+
u^13*v^17*w^14-2*u^14*v^15*w^15+u^15*v^14*w^15+u^15*v^15*w^14,-u^12*v^16*w^16-
u^13*v^15*w^16-u^13*v^16*w^15,6*u^2*v^4*w^6+6*u^2*v^6*w^4+8*u^3*v^3*w^6+
8*u^3*v^6*w^3-9*u^4*v^4*w^4+6*u^6*v^2*w^4+6*u^6*v^4*w^2+2*v^6*w^6,-
u^6*v^7*w^14+4*u^6*v^10*w^11+4*u^6*v^11*w^10-u^6*v^14*w^7-u^7*v^7*w^13+
6*u^7*v^10*w^10-u^7*v^13*w^7-9*u^8*v^9*w^10-9*u^8*v^10*w^9+4*u^9*v^7*w^11+
2*u^9*v^8*w^10-6*u^9*v^9*w^9+2*u^9*v^10*w^8+4*u^9*v^11*w^7+2*u^10*v^7*w^10+
2*u^10*v^10*w^7-u^12*v^7*w^8-u^12*v^8*w^7,0,u^12*v^14*w^22-2*u^12*v^17*w^19-
4*u^12*v^18*w^18-2*u^12*v^19*w^17+u^12*v^22*w^14+u^13*v^14*w^21-
3*u^13*v^17*w^18-3*u^13*v^18*w^17+u^13*v^21*w^14+3*u^14*v^16*w^18+
6*u^14*v^17*w^17+3*u^14*v^18*w^16-2*u^15*v^14*w^19-u^15*v^15*w^18+
5*u^15*v^16*w^17+5*u^15*v^17*w^16-u^15*v^18*w^15-2*u^15*v^19*w^14-
3*u^16*v^14*w^18-u^16*v^15*w^17+2*u^16*v^16*w^16-u^16*v^17*w^15-
3*u^16*v^18*w^14-u^17*v^14*w^17-u^17*v^17*w^14+u^19*v^14*w^15+u^19*v^15*w^14,
6*u^4*v^8*w^12+6*u^4*v^12*w^8+8*u^6*v^6*w^12+8*u^6*v^12*w^6-9*u^8*v^8*w^8+
6*u^12*v^4*w^8+6*u^12*v^8*w^4+2*v^12*w^12,-8*u^18*v^21*w^24-6*u^18*v^22*w^23-
6*u^18*v^23*w^22-8*u^18*v^24*w^21-7*u^19*v^21*w^23-7*u^19*v^23*w^21-
7*u^20*v^21*w^22-7*u^20*v^22*w^21-4*u^21*v^21*w^21,-u^6*v^7*w^11-
2*u^6*v^8*w^10-2*u^6*v^10*w^8-u^6*v^11*w^7-2*u^7*v^7*w^10-u^7*v^8*w^9-
u^7*v^9*w^8-2*u^7*v^10*w^7-2*u^8*v^7*w^9-3*u^8*v^8*w^8-2*u^8*v^9*w^7-
u^9*v^7*w^8-u^9*v^8*w^7,-u^12*v^18*w^18-u^14*v^16*w^18-u^14*v^18*w^16,-
u^6*v^7*w^15+4*u^6*v^10*w^12+4*u^6*v^12*w^10-u^6*v^15*w^7-u^8*v^7*w^13-
9*u^8*v^9*w^11+6*u^8*v^10*w^10-9*u^8*v^11*w^9-u^8*v^13*w^7+4*u^9*v^7*w^12+
2*u^9*v^9*w^10+2*u^9*v^10*w^9+4*u^9*v^12*w^7-6*u^10*v^9*w^9+2*u^11*v^7*w^10+
2*u^11*v^10*w^7-u^12*v^7*w^9-u^12*v^9*w^7,-u^18*v^21*w^25-u^18*v^25*w^21-
u^19*v^21*w^24+3*u^19*v^22*w^23+3*u^19*v^23*w^22-u^19*v^24*w^21+
2*u^20*v^22*w^22-u^21*v^21*w^22-u^21*v^22*w^21,2*u^12*v^14*w^17+
2*u^12*v^17*w^14-8*u^13*v^15*w^15+2*u^15*v^14*w^14,u^24*v^28*w^33+
u^24*v^33*w^28-3*u^25*v^29*w^31-3*u^25*v^31*w^29+u^26*v^28*w^31+
u^26*v^31*w^28+u^27*v^28*w^30-2*u^27*v^29*w^29+u^27*v^30*w^28,
2*u^24*v^28*w^31+2*u^24*v^31*w^28-8*u^25*v^29*w^29+2*u^27*v^28*w^28,-
u^18*v^21*w^26-u^18*v^26*w^21+3*u^19*v^22*w^24+3*u^19*v^24*w^22-
u^20*v^21*w^24-u^20*v^24*w^21-u^21*v^21*w^23+2*u^21*v^22*w^22-u^21*v^23*w^21,
2*u^6*v^10*w^10-2*u^7*v^9*w^10-2*u^7*v^10*w^9-3*u^8*v^9*w^9-2*u^9*v^8*w^9-
2*u^9*v^9*w^8,u^12*v^14*w^21-4*u^12*v^17*w^18-4*u^12*v^18*w^17+u^12*v^21*w^14+
u^13*v^14*w^20-6*u^13*v^17*w^17+u^13*v^20*w^14+9*u^14*v^16*w^17+
9*u^14*v^17*w^16-4*u^15*v^14*w^18-2*u^15*v^15*w^17+6*u^15*v^16*w^16-
2*u^15*v^17*w^15-4*u^15*v^18*w^14-2*u^16*v^14*w^17-2*u^16*v^17*w^14+
u^18*v^14*w^15+u^18*v^15*w^14,-2*u^6*v^7*w^13+14*u^6*v^10*w^10-2*u^6*v^13*w^7-
24*u^8*v^9*w^9+8*u^9*v^7*w^10+8*u^9*v^10*w^7-2*u^12*v^7*w^7,-u^6*v^7*w^10-
2*u^6*v^8*w^9-2*u^6*v^9*w^8-u^6*v^10*w^7-3*u^7*v^7*w^9-5*u^7*v^8*w^8-
3*u^7*v^9*w^7-2*u^8*v^7*w^8-2*u^8*v^8*w^7,2*u^12*v^14*w^16+7*u^12*v^15*w^15+
2*u^12*v^16*w^14+4*u^13*v^14*w^15+4*u^13*v^15*w^14+2*u^14*v^14*w^14,0,
21*u^24*v^28*w^30+21*u^24*v^30*w^28+18*u^26*v^28*w^28,-2*u^6*v^7*w^9-
7*u^6*v^8*w^8-2*u^6*v^9*w^7-4*u^7*v^7*w^8-4*u^7*v^8*w^7-2*u^8*v^7*w^7,
2*u^12*v^14*w^20-14*u^12*v^17*w^17+2*u^12*v^20*w^14+24*u^14*v^16*w^16-
8*u^15*v^14*w^17-8*u^15*v^17*w^14+2*u^18*v^14*w^14,-8*u^6*v^7*w^9-
12*u^6*v^8*w^8-8*u^6*v^9*w^7-14*u^7*v^7*w^8-14*u^7*v^8*w^7-4*u^8*v^7*w^7,
u^12*v^14*w^17+2*u^12*v^15*w^16+2*u^12*v^16*w^15+u^12*v^17*w^14+
3*u^13*v^14*w^16+5*u^13*v^15*w^15+3*u^13*v^16*w^14+2*u^14*v^14*w^15+
2*u^14*v^15*w^14,-2*u^18*v^21*w^24-2*u^18*v^24*w^21+8*u^19*v^22*w^22-
2*u^21*v^21*w^21,-21*u^30*v^35*w^37-21*u^30*v^37*w^35-18*u^32*v^35*w^35,
8*u^12*v^14*w^16+12*u^12*v^15*w^15+8*u^12*v^16*w^14+14*u^13*v^14*w^15+
14*u^13*v^15*w^14+4*u^14*v^14*w^14,-21*u^6*v^7*w^8-21*u^6*v^8*w^7-
18*u^7*v^7*w^7,-60*u^6*v^7*w^7,-8*u^18*v^21*w^23-12*u^18*v^22*w^22-
8*u^18*v^23*w^21-14*u^19*v^21*w^22-14*u^19*v^22*w^21-4*u^20*v^21*w^21,-
21*u^18*v^21*w^23-21*u^18*v^23*w^21-18*u^20*v^21*w^21,21*u^12*v^14*w^15+
21*u^12*v^15*w^14+18*u^13*v^14*w^14,-21*u^18*v^21*w^22-21*u^18*v^22*w^21-
18*u^19*v^21*w^21,-60*u^30*v^35*w^35,-60*u^18*v^21*w^21,60*u^12*v^14*w^14,
60*u^24*v^28*w^28];end;
  f60b:=function(u,v,w)return [60,24*u+18*v+18*w,6*u*v+6*u*w+4*v*w+5*u^2+v^2+w^2,
16*u*v+16*u*w+10*v*w+8*u^2+5*v^2+5*w^2,24*u^2+18*v^2+18*w^2,-7*u*v*w+5*u^3+v^3+w^3,
6*u*v*w+3*u*v^2+3*u*w^2+v*w^2+4*u^2*v+4*u^2*w+v^2*w+u^3,u*v*w+u^2*v+u^2*w,
8*u*v^2+8*u*w^2+5*v*w^2+8*u^2*v+8*u^2*w+5*v^2*w+8*u^3+5*v^3+5*w^3,-u*v*w^2-
u*v^2*w-u^2*v*w,u^3*v^3*w^13-u^3*v^6*w^10-u^3*v^7*w^9-u^3*v^9*w^7-
u^3*v^10*w^6+u^3*v^13*w^3+u^4*v^7*w^8+u^4*v^8*w^7+u^5*v^5*w^9+u^5*v^6*w^8+
u^5*v^8*w^6+u^5*v^9*w^5-u^6*v^3*w^10+u^6*v^5*w^8-u^6*v^6*w^7-u^6*v^7*w^6+
u^6*v^8*w^5-u^6*v^10*w^3-u^7*v^3*w^9+u^7*v^4*w^8-u^7*v^6*w^6+u^7*v^8*w^4-
u^7*v^9*w^3+2*u^8*v^4*w^7+2*u^8*v^5*w^6+2*u^8*v^6*w^5+2*u^8*v^7*w^4-
u^9*v^2*w^8-u^9*v^3*w^7+u^9*v^4*w^6+u^9*v^5*w^5+u^9*v^6*w^4-u^9*v^7*w^3-
u^9*v^8*w^2-u^10*v^2*w^7-u^10*v^3*w^6-u^10*v^6*w^3-u^10*v^7*w^2-u^11*v^8-
u^11*w^8-u^12*v^7-u^12*w^7+u^13*v^2*w^4+u^13*v^3*w^3+u^13*v^4*w^2+u^15*v^4+
u^15*w^4,2*u*v*w^2+2*u*v^2*w+2*u*v^3+2*u*w^3+v*w^3+2*u^2*v*w+3*u^2*v^2+
3*u^2*w^2+2*u^3*v+2*u^3*w+v^3*w+u^4,0,16*u^2*v^2+16*u^2*w^2+10*v^2*w^2+8*u^4+
5*v^4+5*w^4,7*u^2*v^2*w^3+7*u^2*v^3*w^2+7*u^3*v^2*w^2-6*u^3*v^4-6*u^3*w^4-
4*v^3*w^4-6*u^4*v^3-6*u^4*w^3-4*v^4*w^3+5*u^7+v^7+w^7,-2*u*v*w^2-2*u*v^2*w+
u*v^3+u*w^3-3*u^2*v*w+2*u^3*v+2*u^3*w+u^4,-4*u*v*w^3+3*u*v^2*w^2-4*u*v^3*w-
u*v^4-u*w^4-v*w^4+2*u^2*v*w^2+2*u^2*v^2*w+v^2*w^3-4*u^3*v*w+u^3*v^2+u^3*w^2+
v^3*w^2-v^4*w+u^5,0,-u^2*v^2*w^4-u^2*v^4*w^2-u^4*v^2*w^2,0,u^6*v^6*w^14+
u^6*v^7*w^13+u^6*v^13*w^7+u^6*v^14*w^6+u^7*v^6*w^13+u^7*v^13*w^6-u^8*v^9*w^9-
u^9*v^8*w^9-u^9*v^9*w^8+u^13*v^4*w^9+u^13*v^6*w^7+u^13*v^7*w^6+u^13*v^9*w^4+
u^14*v^4*w^8+u^14*v^6*w^6+u^14*v^8*w^4+u^17*v^9+u^17*w^9+u^18*v^8+u^18*w^8,-
2*u*v*w^3-2*u*v^3*w+u^2*v^3+u^2*w^3-3*u^3*v*w+2*u^3*v^2+2*u^3*w^2+u^5,-
u^9*v^7*w^8-u^9*v^8*w^7-u^10*v^7*w^7,u^5*v^5*w^5+u^10*v^5+u^10*w^5,-
u^42*v^32*w^34-u^42*v^34*w^32-u^44*v^32*w^32,u^3*v^3*w^12-2*u^3*v^6*w^9-
2*u^3*v^9*w^6+u^3*v^12*w^3+2*u^4*v^7*w^7+3*u^5*v^5*w^8+3*u^5*v^8*w^5-
2*u^6*v^3*w^9-3*u^6*v^6*w^6-2*u^6*v^9*w^3+2*u^7*v^4*w^7+2*u^7*v^7*w^4+
3*u^8*v^4*w^6+3*u^8*v^5*w^5+3*u^8*v^6*w^4-2*u^9*v^2*w^7-2*u^9*v^3*w^6-
2*u^9*v^6*w^3-2*u^9*v^7*w^2-2*u^11*v^7-2*u^11*w^7+u^12*v^2*w^4+u^12*v^3*w^3+
u^12*v^4*w^2+u^14*v^4+u^14*w^4,3*u^2*v^2*w^2+2*u^3*v*w^2+2*u^3*v^2*w-u^4*v^2-
u^4*w^2,0,-2*u*v^2*w^3-2*u*v^3*w^2-2*u*v^5-2*u*w^5-v*w^5-2*u^2*v*w^3+
7*u^2*v^2*w^2-2*u^2*v^3*w+3*u^2*v^4+3*u^2*w^4+2*v^2*w^4-2*u^3*v*w^2-
2*u^3*v^2*w-4*u^3*v^3-4*u^3*w^3-2*v^3*w^3+5*u^4*v^2+5*u^4*w^2+2*v^4*w^2-
2*u^5*v-2*u^5*w-v^5*w+u^6,
u^4*v^3*w^5+u^4*v^5*w^3+2*u^6*v^3*w^3,21*u^2*v^2*w^2-12*u^3*v^3-12*u^3*w^3-
8*v^3*w^3+5*u^6+v^6+w^6,u^40*v^30*w^33+u^40*v^33*w^30-7*u^41*v^31*w^31+
5*u^43*v^30*w^30,u^6*v^6*w^19-u^6*v^9*w^16-u^6*v^10*w^15-u^6*v^15*w^10-
u^6*v^16*w^9+u^6*v^19*w^6+u^8*v^8*w^15+u^8*v^9*w^14+u^8*v^11*w^12+
u^8*v^12*w^11+u^8*v^14*w^9+u^8*v^15*w^8-u^9*v^6*w^16+u^9*v^8*w^14+
u^9*v^14*w^8-u^9*v^16*w^6-u^10*v^6*w^15-u^10*v^10*w^11-u^10*v^11*w^10-
u^10*v^15*w^6+u^11*v^8*w^12-u^11*v^10*w^10+u^11*v^12*w^8+u^12*v^8*w^11+
u^12*v^11*w^8+u^14*v^6*w^11+u^14*v^7*w^10+u^14*v^8*w^9+u^14*v^9*w^8+
u^14*v^10*w^7+u^14*v^11*w^6-u^15*v^4*w^12+u^15*v^8*w^8-u^15*v^12*w^4-
u^16*v^4*w^11-u^16*v^6*w^9-u^16*v^9*w^6-u^16*v^11*w^4+u^19*v^4*w^8+
u^19*v^6*w^6+u^19*v^8*w^4-u^19*v^12-u^19*w^12-u^20*v^11-u^20*w^11+u^23*v^8+
u^23*w^8,0,0,-4*u*v^3*w^3+u*v^6+u*w^6+6*u^2*v^2*w^3+6*u^2*v^3*w^2-
4*u^3*v*w^3+9*u^3*v^2*w^2-4*u^3*v^3*w-4*u^3*v^4-4*u^3*w^4-2*v^3*w^4-4*u^4*v^3-
4*u^4*w^3-2*v^4*w^3+2*u^6*v+2*u^6*w+u^7,-u^10*v^8*w^10-u^10*v^10*w^8-
u^12*v^8*w^8,-2*u^9*v^7*w^9-2*u^9*v^9*w^7+u^10*v^6*w^9+u^10*v^9*w^6+
2*u^11*v^6*w^8-3*u^11*v^7*w^7+2*u^11*v^8*w^6+u^13*v^6*w^6,-u^26*v^20*w^22-
u^26*v^22*w^20-u^28*v^20*w^20,2*u^3*v^3*w^8+2*u^3*v^4*w^7+2*u^3*v^7*w^4+
2*u^3*v^8*w^3+2*u^4*v^3*w^7+u^4*v^4*w^6-2*u^4*v^5*w^5+u^4*v^6*w^4+
2*u^4*v^7*w^3-2*u^5*v^4*w^5-2*u^5*v^5*w^4+u^6*v^2*w^6+u^6*v^4*w^4+u^6*v^6*w^2+
2*u^7*v^2*w^5+4*u^7*v^3*w^4+4*u^7*v^4*w^3+2*u^7*v^5*w^2+u^8*v^2*w^4+
2*u^8*v^3*w^3+u^8*v^4*w^2+2*u^9*v^5+2*u^9*w^5+u^10*v^4+u^10*w^4,
# e in +-1,+-3,+-5
u^4*v^3*w^3*(Mvp("e")*(u+v+w)+u),0,
u^8*v^6*w^9+u^8*v^9*w^6-7*u^9*v^7*w^7+5*u^11*v^6*w^6,u^3*v^3*w^8+u^3*v^4*w^7+
u^3*v^7*w^4+u^3*v^8*w^3+u^4*v^3*w^7-u^4*v^5*w^5+u^4*v^7*w^3-u^5*v^4*w^5-
u^5*v^5*w^4+u^7*v^2*w^5+u^7*v^3*w^4+u^7*v^4*w^3+u^7*v^5*w^2+u^8*v^2*w^4+
u^8*v^3*w^3+u^8*v^4*w^2+u^9*v^5+u^9*w^5+u^10*v^4+u^10*w^4,u^41*v^30*w^33-
2*u^41*v^31*w^32-2*u^41*v^32*w^31+u^41*v^33*w^30-3*u^42*v^31*w^31+
2*u^43*v^30*w^31+2*u^43*v^31*w^30+u^44*v^30*w^30,-u^41*v^31*w^32-
u^41*v^32*w^31-u^42*v^31*w^31,6*u^2*v^2*w^4-4*u^2*v^3*w^3+6*u^2*v^4*w^2+
u^2*v^6+u^2*w^6-4*u^3*v^2*w^3-4*u^3*v^3*w^2-4*u^3*v^5-4*u^3*w^5-2*v^3*w^5+
9*u^4*v^2*w^2-4*u^5*v^3-4*u^5*w^3-2*v^5*w^3+2*u^6*v^2+2*u^6*w^2+u^8,
18*u^40*v^30*w^31+18*u^40*v^31*w^30+24*u^41*v^30*w^30,u^9*v^6*w^9-
2*u^9*v^7*w^8-2*u^9*v^8*w^7+u^9*v^9*w^6-3*u^10*v^7*w^7+2*u^11*v^6*w^7+
2*u^11*v^7*w^6+u^12*v^6*w^6,-u^33*v^25*w^26-u^33*v^26*w^25-u^34*v^25*w^25,0,-
2*u^41*v^31*w^33-2*u^41*v^33*w^31+u^42*v^30*w^33+u^42*v^33*w^30+
2*u^43*v^30*w^32-3*u^43*v^31*w^31+2*u^43*v^32*w^30+u^45*v^30*w^30,
5*u^8*v^6*w^10+10*u^8*v^8*w^8+5*u^8*v^10*w^6+16*u^10*v^6*w^8+16*u^10*v^8*w^6+
8*u^12*v^6*w^6,18*u^8*v^6*w^8+18*u^8*v^8*w^6+24*u^10*v^6*w^6,-u^25*v^19*w^20-
u^25*v^20*w^19-u^26*v^19*w^19,5*u^40*v^30*w^33+5*u^40*v^31*w^32+
5*u^40*v^32*w^31+5*u^40*v^33*w^30+8*u^41*v^30*w^32+8*u^41*v^32*w^30+
8*u^42*v^30*w^31+8*u^42*v^31*w^30+8*u^43*v^30*w^30,4*u^3*v^3*w^7+
2*u^3*v^4*w^6+2*u^3*v^6*w^4+4*u^3*v^7*w^3+2*u^4*v^3*w^6-3*u^4*v^4*w^5-
3*u^4*v^5*w^4+2*u^4*v^6*w^3-3*u^5*v^4*w^4+2*u^6*v^2*w^5+3*u^6*v^3*w^4+
3*u^6*v^4*w^3+2*u^6*v^5*w^2+3*u^7*v^2*w^4+4*u^7*v^3*w^3+3*u^7*v^4*w^2+u^8*v^5+
u^8*w^5+2*u^9*v^4+2*u^9*w^4,
u^12*v^9*w^9*(Mvp("e")*(u+v+w)+u),
-u^34*v^26*w^28-u^34*v^28*w^26-
u^36*v^26*w^26,4*u^4*v^3*w^3,5*u^8*v^6*w^9+5*u^8*v^7*w^8+5*u^8*v^8*w^7+
5*u^8*v^9*w^6+8*u^9*v^6*w^8+8*u^9*v^8*w^6+8*u^10*v^6*w^7+8*u^10*v^7*w^6+
8*u^11*v^6*w^6,4*u^20*v^15*w^15,u^17*v^12*w^15-2*u^17*v^13*w^14-2*u^17*v^14*w^13+
u^17*v^15*w^12-3*u^18*v^13*w^13+2*u^19*v^12*w^13+2*u^19*v^13*w^12+
u^20*v^12*w^12,-u^17*v^13*w^14-u^17*v^14*w^13-u^18*v^13*w^13,8*u^3*v^3*w^6+
8*u^3*v^6*w^3-9*u^4*v^4*w^4+6*u^6*v^2*w^4+8*u^6*v^3*w^3+6*u^6*v^4*w^2+
3*u^8*v^4+3*u^8*w^4,-2*u^8*v^9*w^10-2*u^8*v^10*w^9+u^9*v^6*w^12-4*u^9*v^9*w^9+
u^9*v^12*w^6+6*u^10*v^8*w^9+6*u^10*v^9*w^8-4*u^11*v^6*w^10-4*u^11*v^7*w^9+
9*u^11*v^8*w^8-4*u^11*v^9*w^7-4*u^11*v^10*w^6-4*u^12*v^6*w^9-4*u^12*v^9*w^6+
2*u^14*v^6*w^7+2*u^14*v^7*w^6+u^15*v^6*w^6,0,-u^16*v^15*w^17-2*u^16*v^16*w^16-
u^16*v^17*w^15+u^17*v^12*w^19-2*u^17*v^15*w^16-2*u^17*v^16*w^15+
u^17*v^19*w^12+2*u^18*v^14*w^16+4*u^18*v^15*w^15+2*u^18*v^16*w^14-
2*u^19*v^12*w^17-2*u^19*v^13*w^16+5*u^19*v^14*w^15+5*u^19*v^15*w^14-
2*u^19*v^16*w^13-2*u^19*v^17*w^12-4*u^20*v^12*w^16-2*u^20*v^13*w^15+
3*u^20*v^14*w^14-2*u^20*v^15*w^13-4*u^20*v^16*w^12-2*u^21*v^12*w^15-
2*u^21*v^15*w^12+2*u^23*v^12*w^13+2*u^23*v^13*w^12+u^24*v^12*w^12,
8*u^6*v^6*w^12+8*u^6*v^12*w^6-9*u^8*v^8*w^8+6*u^12*v^4*w^8+8*u^12*v^6*w^6+
6*u^12*v^8*w^4+3*u^16*v^8+3*u^16*w^8,5*u^24*v^18*w^21+5*u^24*v^19*w^20+
5*u^24*v^20*w^19+5*u^24*v^21*w^18+8*u^25*v^18*w^20+8*u^25*v^20*w^18+
8*u^26*v^18*w^19+8*u^26*v^19*w^18+8*u^27*v^18*w^18,u^8*v^7*w^9+u^8*v^9*w^7+
2*u^9*v^6*w^9+2*u^9*v^7*w^8+2*u^9*v^8*w^7+2*u^9*v^9*w^6+3*u^10*v^6*w^8+
2*u^10*v^7*w^7+3*u^10*v^8*w^6+2*u^11*v^6*w^7+2*u^11*v^7*w^6+u^12*v^6*w^6,-
u^18*v^14*w^16-u^18*v^16*w^14-u^20*v^14*w^14,-2*u^8*v^9*w^11-2*u^8*v^11*w^9+
u^10*v^6*w^12+6*u^10*v^8*w^10-4*u^10*v^9*w^9+6*u^10*v^10*w^8+u^10*v^12*w^6-
4*u^11*v^6*w^11-4*u^11*v^8*w^9-4*u^11*v^9*w^8-4*u^11*v^11*w^6+9*u^12*v^8*w^8-
4*u^13*v^6*w^9-4*u^13*v^9*w^6+2*u^14*v^6*w^8+2*u^14*v^8*w^6+u^16*v^6*w^6,
u^25*v^18*w^21-2*u^25*v^19*w^20-2*u^25*v^20*w^19+u^25*v^21*w^18-
3*u^26*v^19*w^19+2*u^27*v^18*w^19+2*u^27*v^19*w^18+u^28*v^18*w^18,
u^16*v^12*w^15+u^16*v^15*w^12-7*u^17*v^13*w^13+5*u^19*v^12*w^12,-
2*u^33*v^25*w^27-2*u^33*v^27*w^25+u^34*v^24*w^27+u^34*v^27*w^24+
2*u^35*v^24*w^26-3*u^35*v^25*w^25+2*u^35*v^26*w^24+u^37*v^24*w^24,
u^32*v^24*w^27+u^32*v^27*w^24-7*u^33*v^25*w^25+5*u^35*v^24*w^24,-
2*u^25*v^19*w^21-2*u^25*v^21*w^19+u^26*v^18*w^21+u^26*v^21*w^18+
2*u^27*v^18*w^20-3*u^27*v^19*w^19+2*u^27*v^20*w^18+u^29*v^18*w^18,
3*u^10*v^8*w^8+2*u^11*v^7*w^8+2*u^11*v^8*w^7-u^12*v^6*w^8-u^12*v^8*w^6,-
2*u^16*v^15*w^16-2*u^16*v^16*w^15+u^17*v^12*w^18-4*u^17*v^15*w^15+
u^17*v^18*w^12+6*u^18*v^14*w^15+6*u^18*v^15*w^14-4*u^19*v^12*w^16-
4*u^19*v^13*w^15+9*u^19*v^14*w^14-4*u^19*v^15*w^13-4*u^19*v^16*w^12-
4*u^20*v^12*w^15-4*u^20*v^15*w^12+2*u^22*v^12*w^13+2*u^22*v^13*w^12+
u^23*v^12*w^12,u^8*v^6*w^12-8*u^8*v^9*w^9+u^8*v^12*w^6+21*u^10*v^8*w^8-
12*u^11*v^6*w^9-12*u^11*v^9*w^6+5*u^14*v^6*w^6,u^8*v^7*w^8+u^8*v^8*w^7+
3*u^9*v^6*w^8+6*u^9*v^7*w^7+3*u^9*v^8*w^6+4*u^10*v^6*w^7+4*u^10*v^7*w^6+
u^11*v^6*w^6,u^16*v^12*w^14+4*u^16*v^13*w^13+u^16*v^14*w^12+6*u^17*v^12*w^13+
6*u^17*v^13*w^12+5*u^18*v^12*w^12,4*u^12*v^9*w^9,18*u^32*v^24*w^26+
18*u^32*v^26*w^24+24*u^34*v^24*w^24,u^8*v^6*w^8+4*u^8*v^7*w^7+u^8*v^8*w^6+
6*u^9*v^6*w^7+6*u^9*v^7*w^6+5*u^10*v^6*w^6,u^16*v^12*w^18-8*u^16*v^15*w^15+
u^16*v^18*w^12+21*u^18*v^14*w^14-12*u^19*v^12*w^15-12*u^19*v^15*w^12+
5*u^22*v^12*w^12,5*u^8*v^6*w^8+10*u^8*v^7*w^7+5*u^8*v^8*w^6+16*u^9*v^6*w^7+
16*u^9*v^7*w^6+8*u^10*v^6*w^6,u^16*v^13*w^14+u^16*v^14*w^13+3*u^17*v^12*w^14+
6*u^17*v^13*w^13+3*u^17*v^14*w^12+4*u^18*v^12*w^13+4*u^18*v^13*w^12+
u^19*v^12*w^12,u^24*v^18*w^21+u^24*v^21*w^18-7*u^25*v^19*w^19+
5*u^27*v^18*w^18,18*u^40*v^30*w^32+18*u^40*v^32*w^30+24*u^42*v^30*w^30,
5*u^16*v^12*w^14+10*u^16*v^13*w^13+5*u^16*v^14*w^12+16*u^17*v^12*w^13+
16*u^17*v^13*w^12+8*u^18*v^12*w^12,18*u^8*v^6*w^7+18*u^8*v^7*w^6+
24*u^9*v^6*w^6,60*u^8*v^6*w^6,5*u^24*v^18*w^20+10*u^24*v^19*w^19+
5*u^24*v^20*w^18+16*u^25*v^18*w^19+16*u^25*v^19*w^18+8*u^26*v^18*w^18,
18*u^24*v^18*w^20+18*u^24*v^20*w^18+24*u^26*v^18*w^18,18*u^16*v^12*w^13+
18*u^16*v^13*w^12+24*u^17*v^12*w^12,18*u^24*v^18*w^19+18*u^24*v^19*w^18+
24*u^25*v^18*w^18,60*u^40*v^30*w^30,60*u^24*v^18*w^18,60*u^16*v^12*w^12,
60*u^32*v^24*w^24];end;
  f60c:=function(u,v,w)return 
[60,24*u+21*v+15*w,8*u*v+4*u*w+3*v*w+4*u^2+2*v^2,16*u*v+
12*u*w+10*v*w+10*u^2+8*v^2+4*w^2,24*u^2+21*v^2+15*w^2,-8*u*v*w+4*u^3+2*v^3,
4*u*v*w+4*u*v^2+u*w^2+v*w^2+4*u^2*v+3*u^2*w+v^2*w+2*u^3+v^3,u^2*v,8*u*v^2+
6*u*w^2+5*v*w^2+8*u^2*v+6*u^2*w+5*v^2*w+10*u^3+8*v^3+4*w^3,-u*v^2*w-u^2*v*w-
u^2*v^2,-u^3*v^9*w^7-u^3*v^10*w^6+u^3*v^13*w^3+u^4*v^7*w^8+u^4*v^8*w^7+
u^4*v^13*w^2+u^5*v^8*w^6+u^5*v^9*w^5+2*u^6*v^8*w^5+u^6*v^9*w^4-u^6*v^10*w^3+
u^7*v^4*w^8+2*u^7*v^8*w^4-u^7*v^9*w^3-u^7*v^10*w^2+2*u^8*v^4*w^7+
2*u^8*v^5*w^6+2*u^8*v^6*w^5+2*u^8*v^7*w^4-u^8*v^9*w^2-u^9*v^2*w^8-u^9*v^3*w^7+
u^9*v^4*w^6+u^9*v^5*w^5+u^9*v^6*w^4-u^9*v^7*w^3-u^9*v^8*w^2-u^9*v^10-
u^10*v^2*w^7-u^10*v^3*w^6-u^10*v^6*w^3-u^10*v^7*w^2-u^10*v^9-u^11*v^8-
u^12*v^7+u^13*v^2*w^4+u^13*v^3*w^3+u^13*v^4*w^2+u^15*v^4,2*u*v*w^2+u*v^2*w+
3*u*v^3+u*w^3+v*w^3+u^2*v*w+2*u^2*v^2+u^2*w^2+3*u^3*v+2*u^3*w+v^3*w+2*u^4+v^4,
0,16*u^2*v^2+12*u^2*w^2+10*v^2*w^2+10*u^4+8*v^4+4*w^4,8*u^2*v^2*w^3+
8*u^2*v^3*w^2+8*u^3*v^2*w^2-8*u^3*v^4-4*u^3*w^4-3*v^3*w^4-8*u^4*v^3-4*u^4*w^3-
3*v^4*w^3+4*u^7+2*v^7,-2*u*v*w^2-3*u*v^2*w+u*v^3-3*u^2*v*w+u^3*v+u^3*w+2*u^4+
v^4,-2*u*v*w^3+3*u*v^2*w^2-3*u*v^3*w-2*u*v^4-u*w^4-v*w^4+3*u^2*v*w^2+
2*u^2*v^2*w+v^2*w^3-3*u^3*v*w+2*u^3*w^2+2*v^3*w^2-2*u^4*v-u^4*w-v^4*w+2*u^5+
v^5,0,-u^2*v^4*w^2-u^4*v^2*w^2-u^4*v^4,0,u^6*v^13*w^7+u^6*v^14*w^6+
u^7*v^13*w^6-u^8*v^9*w^9+u^8*v^14*w^4-u^9*v^8*w^9-u^9*v^9*w^8+u^9*v^13*w^4+
u^13*v^4*w^9+u^13*v^6*w^7+u^13*v^7*w^6+u^13*v^9*w^4+u^13*v^13+u^14*v^4*w^8+
u^14*v^6*w^6+u^14*v^8*w^4+u^17*v^9+u^18*v^8,-2*u*v*w^3-3*u*v^3*w+u^2*v^3-
3*u^3*v*w+u^3*v^2+u^3*w^2+2*u^5+v^5,u^9*v^9*w^6+u^10*v^8*w^6+u^10*v^9*w^5,
u^10*v^5,u^42*v^39*w^27+u^44*v^37*w^27+u^44*v^39*w^25,-2*u^3*v^9*w^6+
u^3*v^12*w^3+2*u^4*v^7*w^7+u^4*v^12*w^2+3*u^5*v^8*w^5+3*u^6*v^8*w^4-
2*u^6*v^9*w^3+2*u^7*v^4*w^7+2*u^7*v^7*w^4-2*u^7*v^9*w^2+3*u^8*v^4*w^6+
3*u^8*v^5*w^5+3*u^8*v^6*w^4-2*u^9*v^2*w^7-2*u^9*v^3*w^6-2*u^9*v^6*w^3-
2*u^9*v^7*w^2-2*u^9*v^9-2*u^11*v^7+u^12*v^2*w^4+u^12*v^3*w^3+u^12*v^4*w^2+
u^14*v^4,6*u^2*v^2*w^2+2*u^2*v^3*w+2*u^3*v*w^2+2*u^3*v^2*w-2*u^3*v^3-u^4*v^2,
0,-u*v^2*w^3-2*u*v^3*w^2-3*u*v^5-u*w^5-v*w^5-u^2*v*w^3+8*u^2*v^2*w^2-
u^2*v^3*w+4*u^2*v^4+2*u^2*w^4+2*v^2*w^4-2*u^3*v*w^2-u^3*v^2*w-6*u^3*v^3-
3*u^3*w^3-2*v^3*w^3+4*u^4*v^2+4*u^4*w^2+3*v^4*w^2-3*u^5*v-2*u^5*w-v^5*w+2*u^6+
v^6,0, 24*u^2*v^2*w^2-16*u^3*v^3-8*u^3*w^3-6*v^3*w^3+4*u^6+2*v^6,
-2*u^40*v^38*w^25+8*u^41*v^36*w^26-4*u^43*v^35*w^25,
-u^6*v^15*w^10-u^6*v^16*w^9+u^6*v^19*w^6+u^8*v^11*w^12+u^8*v^12*w^11+u^8*v^14*w^9+
u^8*v^15*w^8+u^8*v^19*w^4+u^9*v^14*w^8-u^9*v^16*w^6+u^10*v^14*w^7+
u^11*v^8*w^12+u^11*v^12*w^8+u^11*v^14*w^6-u^11*v^16*w^4+u^12*v^8*w^11+
u^12*v^11*w^8-u^12*v^15*w^4+u^14*v^6*w^11+u^14*v^7*w^10+u^14*v^8*w^9+
u^14*v^9*w^8+u^14*v^10*w^7+u^14*v^11*w^6-u^15*v^4*w^12+u^15*v^8*w^8-
u^15*v^12*w^4-u^15*v^16-u^16*v^4*w^11-u^16*v^6*w^9-u^16*v^9*w^6-u^16*v^11*w^4-
u^16*v^15+u^19*v^4*w^8+u^19*v^6*w^6+u^19*v^8*w^4-u^19*v^12-u^20*v^11+u^23*v^8,
0,0,-2*u*v^3*w^3+u*v^6+6*u^2*v^2*w^3+9*u^2*v^3*w^2-2*u^3*v*w^3+
9*u^3*v^2*w^2-4*u^3*v^3*w-6*u^3*v^4-2*u^3*w^4-2*v^3*w^4-6*u^4*v^3-4*u^4*w^3-
2*v^4*w^3+u^6*v+u^6*w+2*u^7+v^7, 
u^10*v^11*w^7+u^12*v^9*w^7+u^12*v^11*w^5,-
u^8*v^12*w^5+2*u^9*v^8*w^8+3*u^9*v^10*w^6-u^10*v^10*w^5-u^11*v^7*w^7+
3*u^11*v^8*w^6-u^11*v^9*w^5-2*u^13*v^7*w^5,u^26*v^25*w^17+u^28*v^23*w^17+
u^28*v^25*w^15,2*u^3*v^7*w^4+2*u^3*v^8*w^3-2*u^4*v^5*w^5+2*u^4*v^6*w^4+
4*u^4*v^7*w^3+u^4*v^8*w^2-2*u^5*v^4*w^5-2*u^5*v^5*w^4+2*u^5*v^7*w^2+
u^6*v^2*w^6+2*u^6*v^4*w^4+2*u^6*v^6*w^2+u^6*v^8+2*u^7*v^2*w^5+4*u^7*v^3*w^4+
4*u^7*v^4*w^3+2*u^7*v^5*w^2+u^8*v^2*w^4+2*u^8*v^3*w^3+u^8*v^4*w^2+u^8*v^6+
2*u^9*v^5+u^10*v^4,0,0,-2*u^8*v^10*w^5+8*u^9*v^8*w^6-4*u^11*v^7*w^5,
u^3*v^7*w^4+u^3*v^8*w^3-u^4*v^5*w^5+u^4*v^7*w^3+u^4*v^8*w^2-u^5*v^4*w^5-
u^5*v^5*w^4+u^5*v^7*w^2+u^7*v^2*w^5+u^7*v^3*w^4+u^7*v^4*w^3+u^7*v^5*w^2+
u^7*v^7+u^8*v^2*w^4+u^8*v^3*w^3+u^8*v^4*w^2+u^9*v^5+u^10*v^4,-u^40*v^39*w^25+
2*u^41*v^36*w^27+3*u^41*v^37*w^26-u^41*v^38*w^25+3*u^42*v^36*w^26-
u^43*v^35*w^26-u^43*v^36*w^25-2*u^44*v^35*w^25,u^41*v^37*w^26+u^42*v^36*w^26+
u^42*v^37*w^25,6*u^2*v^2*w^4-2*u^2*v^3*w^3+9*u^2*v^4*w^2+u^2*v^6-
2*u^3*v^2*w^3-4*u^3*v^3*w^2-6*u^3*v^5-2*u^3*w^5-2*v^3*w^5+9*u^4*v^2*w^2-
6*u^5*v^3-4*u^5*w^3-2*v^5*w^3+u^6*v^2+u^6*w^2+2*u^8+v^8,-15*u^40*v^35*w^26-
21*u^40*v^36*w^25-24*u^41*v^35*w^25,-u^8*v^11*w^5+2*u^9*v^8*w^7+3*u^9*v^9*w^6-
u^9*v^10*w^5+3*u^10*v^8*w^6-u^11*v^7*w^6-u^11*v^8*w^5-2*u^12*v^7*w^5,-
u^33*v^30*w^21-u^34*v^29*w^21-u^34*v^30*w^20,0,-u^40*v^40*w^25+
2*u^41*v^36*w^28+3*u^41*v^38*w^26-u^42*v^38*w^25-u^43*v^35*w^27+
3*u^43*v^36*w^26-u^43*v^37*w^25-2*u^45*v^35*w^25,-4*u^8*v^7*w^9-
10*u^8*v^9*w^7-8*u^8*v^11*w^5-12*u^10*v^7*w^7-16*u^10*v^9*w^5-10*u^12*v^7*w^5,
-15*u^8*v^7*w^7-21*u^8*v^9*w^5-24*u^10*v^7*w^5,u^25*v^23*w^16+u^26*v^22*w^16+
u^26*v^23*w^15,-4*u^40*v^35*w^28-5*u^40*v^36*w^27-5*u^40*v^37*w^26-
8*u^40*v^38*w^25-6*u^41*v^35*w^27-8*u^41*v^37*w^25-6*u^42*v^35*w^26-
8*u^42*v^36*w^25-10*u^43*v^35*w^25,2*u^3*v^6*w^4+4*u^3*v^7*w^3-2*u^4*v^4*w^5-
2*u^4*v^5*w^4+3*u^4*v^6*w^3+3*u^4*v^7*w^2-2*u^5*v^4*w^4+2*u^5*v^6*w^2+
2*u^6*v^2*w^5+3*u^6*v^3*w^4+3*u^6*v^4*w^3+2*u^6*v^5*w^2+u^6*v^7+3*u^7*v^2*w^4+
4*u^7*v^3*w^3+3*u^7*v^4*w^2+u^7*v^6+u^8*v^5+2*u^9*v^4,0,-
u^34*v^32*w^22-u^36*v^30*w^22-u^36*v^32*w^20,0,-4*u^8*v^7*w^8-5*u^8*v^8*w^7-
5*u^8*v^9*w^6-8*u^8*v^10*w^5-6*u^9*v^7*w^7-8*u^9*v^9*w^5-6*u^10*v^7*w^6-
8*u^10*v^8*w^5-10*u^11*v^7*w^5,0,u^16*v^18*w^10-2*u^17*v^15*w^12-
3*u^17*v^16*w^11+u^17*v^17*w^10-3*u^18*v^15*w^11+u^19*v^14*w^11+
u^19*v^15*w^10+2*u^20*v^14*w^10,-u^17*v^16*w^11-u^18*v^15*w^11-u^18*v^16*w^10,
8*u^3*v^6*w^3-6*u^4*v^4*w^4+6*u^4*v^6*w^2+6*u^6*v^2*w^4+8*u^6*v^3*w^3+
6*u^6*v^4*w^2+2*u^6*v^6+3*u^8*v^4,2*u^8*v^10*w^9+2*u^8*v^11*w^8-u^8*v^14*w^5+
2*u^9*v^10*w^8-u^9*v^13*w^5-6*u^10*v^9*w^8-9*u^10*v^10*w^7+2*u^11*v^7*w^9+
2*u^11*v^8*w^8-9*u^11*v^9*w^7+4*u^11*v^10*w^6+6*u^11*v^11*w^5+4*u^12*v^7*w^8+
6*u^12*v^10*w^5-u^14*v^7*w^6-u^14*v^8*w^5-2*u^15*v^7*w^5,0,-u^16*v^17*w^15-
2*u^16*v^18*w^14-u^16*v^19*w^13+u^16*v^22*w^10-u^17*v^17*w^14-u^17*v^18*w^13+
u^17*v^21*w^10+2*u^18*v^16*w^14+5*u^18*v^17*w^13+3*u^18*v^18*w^12-
u^19*v^14*w^15-u^19*v^15*w^14+5*u^19*v^16*w^13+6*u^19*v^17*w^12-
2*u^19*v^18*w^11-3*u^19*v^19*w^10-3*u^20*v^14*w^14-u^20*v^15*w^13+
3*u^20*v^16*w^12-2*u^20*v^17*w^11-6*u^20*v^18*w^10-2*u^21*v^14*w^13-
3*u^21*v^17*w^10+u^23*v^14*w^11+u^23*v^15*w^10+2*u^24*v^14*w^10,
8*u^6*v^12*w^6-6*u^8*v^8*w^8+6*u^8*v^12*w^4+6*u^12*v^4*w^8+8*u^12*v^6*w^6+
6*u^12*v^8*w^4+2*u^12*v^12+3*u^16*v^8,-4*u^24*v^21*w^18-5*u^24*v^22*w^17-
5*u^24*v^23*w^16-8*u^24*v^24*w^15-6*u^25*v^21*w^17-8*u^25*v^23*w^15-
6*u^26*v^21*w^16-8*u^26*v^22*w^15-10*u^27*v^21*w^15,-u^8*v^8*w^8-u^8*v^10*w^6-
u^8*v^11*w^5-u^9*v^7*w^8-2*u^9*v^8*w^7-u^9*v^9*w^6-3*u^9*v^10*w^5-
u^10*v^7*w^7-u^10*v^8*w^6-2*u^10*v^9*w^5-2*u^11*v^7*w^6-3*u^11*v^8*w^5-
2*u^12*v^7*w^5,-u^18*v^18*w^12-u^20*v^16*w^12-u^20*v^18*w^10,2*u^8*v^10*w^10+
2*u^8*v^12*w^8-u^8*v^15*w^5-6*u^10*v^9*w^9+2*u^10*v^10*w^8-9*u^10*v^11*w^7-
u^10*v^13*w^5+2*u^11*v^7*w^10+2*u^11*v^9*w^8+4*u^11*v^10*w^7+6*u^11*v^12*w^5-
9*u^12*v^9*w^7+4*u^13*v^7*w^8+6*u^13*v^10*w^5-u^14*v^7*w^7-u^14*v^9*w^5-
2*u^16*v^7*w^5,-u^24*v^25*w^15+2*u^25*v^22*w^17+3*u^25*v^23*w^16-
u^25*v^24*w^15+3*u^26*v^22*w^16-u^27*v^21*w^16-u^27*v^22*w^15-
2*u^28*v^21*w^15,2*u^16*v^17*w^10-8*u^17*v^15*w^11+4*u^19*v^14*w^10,
u^32*v^33*w^20-2*u^33*v^29*w^23-3*u^33*v^31*w^21+u^34*v^31*w^20+
u^35*v^28*w^22-3*u^35*v^29*w^21+u^35*v^30*w^20+2*u^37*v^28*w^20,
2*u^32*v^31*w^20-8*u^33*v^29*w^21+4*u^35*v^28*w^20,-u^24*v^26*w^15+
2*u^25*v^22*w^18+3*u^25*v^24*w^16-u^26*v^24*w^15-u^27*v^21*w^17+
3*u^27*v^22*w^16-u^27*v^23*w^15-2*u^29*v^21*w^15,-6*u^10*v^9*w^7-
2*u^10*v^10*w^6-2*u^11*v^8*w^7-2*u^11*v^9*w^6+2*u^11*v^10*w^5+u^12*v^9*w^5,-
2*u^16*v^17*w^14-2*u^16*v^18*w^13+u^16*v^21*w^10-2*u^17*v^17*w^13+
u^17*v^20*w^10+6*u^18*v^16*w^13+9*u^18*v^17*w^12-2*u^19*v^14*w^14-
2*u^19*v^15*w^13+9*u^19*v^16*w^12-4*u^19*v^17*w^11-6*u^19*v^18*w^10-
4*u^20*v^14*w^13-6*u^20*v^17*w^10+u^22*v^14*w^11+u^22*v^15*w^10+
2*u^23*v^14*w^10,6*u^8*v^10*w^8-2*u^8*v^13*w^5-24*u^10*v^9*w^7+8*u^11*v^7*w^8+
16*u^11*v^10*w^5-4*u^14*v^7*w^5,-u^8*v^8*w^7-u^8*v^9*w^6-u^8*v^10*w^5-
u^9*v^7*w^7-4*u^9*v^8*w^6-4*u^9*v^9*w^5-3*u^10*v^7*w^6-4*u^10*v^8*w^5-
2*u^11*v^7*w^5,3*u^16*v^15*w^11+2*u^16*v^16*w^10+4*u^17*v^14*w^11+
8*u^17*v^15*w^10+4*u^18*v^14*w^10,0,15*u^32*v^28*w^22+
21*u^32*v^30*w^20+24*u^34*v^28*w^20,-3*u^8*v^8*w^6-2*u^8*v^9*w^5-
4*u^9*v^7*w^6-8*u^9*v^8*w^5-4*u^10*v^7*w^5,-6*u^16*v^17*w^13+2*u^16*v^20*w^10+
24*u^18*v^16*w^12-8*u^19*v^14*w^13-16*u^19*v^17*w^10+4*u^22*v^14*w^10,-
4*u^8*v^7*w^7-10*u^8*v^8*w^6-8*u^8*v^9*w^5-12*u^9*v^7*w^6-16*u^9*v^8*w^5-
10*u^10*v^7*w^5,u^16*v^15*w^12+u^16*v^16*w^11+u^16*v^17*w^10+u^17*v^14*w^12+
4*u^17*v^15*w^11+4*u^17*v^16*w^10+3*u^18*v^14*w^11+4*u^18*v^15*w^10+
2*u^19*v^14*w^10,-2*u^24*v^24*w^15+8*u^25*v^22*w^16-4*u^27*v^21*w^15,-
15*u^40*v^35*w^27-21*u^40*v^37*w^25-24*u^42*v^35*w^25,4*u^16*v^14*w^12+
10*u^16*v^15*w^11+8*u^16*v^16*w^10+12*u^17*v^14*w^11+16*u^17*v^15*w^10+
10*u^18*v^14*w^10,-15*u^8*v^7*w^6-21*u^8*v^8*w^5-24*u^9*v^7*w^5,-
60*u^8*v^7*w^5,-4*u^24*v^21*w^17-10*u^24*v^22*w^16-8*u^24*v^23*w^15-
12*u^25*v^21*w^16-16*u^25*v^22*w^15-10*u^26*v^21*w^15,-15*u^24*v^21*w^17-
21*u^24*v^23*w^15-24*u^26*v^21*w^15,15*u^16*v^14*w^11+21*u^16*v^15*w^10+
24*u^17*v^14*w^10,-15*u^24*v^21*w^16-21*u^24*v^22*w^15-24*u^25*v^21*w^15,-
60*u^40*v^35*w^25,-60*u^24*v^21*w^15,60*u^16*v^14*w^10,60*u^32*v^28*w^20];end;
 f80:=function(u,v,w)return [80,32*u+24*v+24*w,
8*u*v+8*u*w+4*v*w+6*u^2+2*v^2+2*w^2,20*u*v+20*u*w+16*v*w+12*u^2+6*v^2+6*w^2,
32*u^2+24*v^2+24*w^2,-10*u*v*w+6*u^3+2*v^3+2*w^3,8*u*v*w+3*u*v^2+3*u*w^2+
2*v*w^2+5*u^2*v+5*u^2*w+2*v^2*w+2*u^3,u*v*w+u^2*v+u^2*w,10*u*v^2+10*u*w^2+
8*v*w^2+10*u^2*v+10*u^2*w+8*v^2*w+12*u^3+6*v^3+6*w^3,-u*v*w^2-u*v^2*w-
2*u^2*v*w,u^3*v^3*w^13-u^3*v^6*w^10-u^3*v^7*w^9-u^3*v^9*w^7-u^3*v^10*w^6+
u^3*v^13*w^3+u^4*v^2*w^13+u^4*v^7*w^8+u^4*v^8*w^7+u^4*v^13*w^2+u^5*v^5*w^9+
u^5*v^6*w^8+u^5*v^8*w^6+u^5*v^9*w^5-u^6*v^3*w^10+u^6*v^4*w^9+2*u^6*v^5*w^8-
u^6*v^6*w^7-u^6*v^7*w^6+2*u^6*v^8*w^5+u^6*v^9*w^4-u^6*v^10*w^3-u^7*v^2*w^10-
u^7*v^3*w^9+2*u^7*v^4*w^8-u^7*v^6*w^6+2*u^7*v^8*w^4-u^7*v^9*w^3-u^7*v^10*w^2-
u^8*v^2*w^9+2*u^8*v^4*w^7+3*u^8*v^5*w^6+3*u^8*v^6*w^5+2*u^8*v^7*w^4-
u^8*v^9*w^2-u^9*v^2*w^8-2*u^9*v^3*w^7+u^9*v^4*w^6+2*u^9*v^5*w^5+u^9*v^6*w^4-
2*u^9*v^7*w^3-u^9*v^8*w^2-u^10*v^2*w^7-2*u^10*v^3*w^6-2*u^10*v^6*w^3-
u^10*v^7*w^2-u^11*v^8-u^11*w^8-u^12*v^7-u^12*w^7+u^13*v^2*w^4+2*u^13*v^3*w^3+
u^13*v^4*w^2+u^15*v^4+u^15*w^4,3*u*v*w^2+3*u*v^2*w+2*u*v^3+2*u*w^3+v*w^3+
2*u^2*v*w+3*u^2*v^2+3*u^2*w^2+2*v^2*w^2+3*u^3*v+3*u^3*w+v^3*w+2*u^4,0,
20*u^2*v^2+20*u^2*w^2+16*v^2*w^2+12*u^4+6*v^4+6*w^4,10*u^2*v^2*w^3+
10*u^2*v^3*w^2+10*u^3*v^2*w^2-8*u^3*v^4-8*u^3*w^4-4*v^3*w^4-8*u^4*v^3-
8*u^4*w^3-4*v^4*w^3+6*u^7+2*v^7+2*w^7,-3*u*v*w^2-3*u*v^2*w+u*v^3+u*w^3+v*w^3-
4*u^2*v*w+2*u^3*v+2*u^3*w+v^3*w+2*u^4,-5*u*v*w^3+4*u*v^2*w^2-5*u*v^3*w-u*v^4-
u*w^4+3*u^2*v*w^2+3*u^2*v^2*w+2*v^2*w^3-6*u^3*v*w+2*u^3*v^2+2*u^3*w^2+
2*v^3*w^2-u^4*v-u^4*w+2*u^5,0,-u^2*v^2*w^4-u^2*v^4*w^2-2*u^4*v^2*w^2,0,
u^6*v^6*w^14+u^6*v^7*w^13+u^6*v^13*w^7+u^6*v^14*w^6+u^7*v^6*w^13+u^7*v^13*w^6+
u^8*v^4*w^14-u^8*v^9*w^9+u^8*v^14*w^4+u^9*v^4*w^13-u^9*v^8*w^9-u^9*v^9*w^8+
u^9*v^13*w^4+u^13*v^4*w^9+2*u^13*v^6*w^7+2*u^13*v^7*w^6+u^13*v^9*w^4+
u^14*v^4*w^8+2*u^14*v^6*w^6+u^14*v^8*w^4+u^17*v^9+u^17*w^9+u^18*v^8+u^18*w^8,-
3*u*v*w^3-3*u*v^3*w+u^2*v^3+u^2*w^3+v^2*w^3-4*u^3*v*w+2*u^3*v^2+2*u^3*w^2+
v^3*w^2+2*u^5,u^9*v^7*w^8+u^9*v^8*w^7+2*u^10*v^7*w^7,u^5*v^5*w^5+u^10*v^5+
u^10*w^5,u^42*v^32*w^34+u^42*v^34*w^32+2*u^44*v^32*w^32,u^3*v^3*w^12-
2*u^3*v^6*w^9-2*u^3*v^9*w^6+u^3*v^12*w^3+u^4*v^2*w^12+2*u^4*v^7*w^7+
u^4*v^12*w^2+3*u^5*v^5*w^8+3*u^5*v^8*w^5-2*u^6*v^3*w^9+3*u^6*v^4*w^8-
3*u^6*v^6*w^6+3*u^6*v^8*w^4-2*u^6*v^9*w^3-2*u^7*v^2*w^9+2*u^7*v^4*w^7+
2*u^7*v^7*w^4-2*u^7*v^9*w^2+3*u^8*v^4*w^6+6*u^8*v^5*w^5+3*u^8*v^6*w^4-
2*u^9*v^2*w^7-4*u^9*v^3*w^6-4*u^9*v^6*w^3-2*u^9*v^7*w^2-2*u^11*v^7-2*u^11*w^7+
u^12*v^2*w^4+2*u^12*v^3*w^3+u^12*v^4*w^2+u^14*v^4+u^14*w^4,2*u^2*v*w^3+
3*u^2*v^2*w^2+2*u^2*v^3*w+2*u^3*v*w^2+2*u^3*v^2*w-u^4*v^2-u^4*w^2,0,-
3*u*v^2*w^3-3*u*v^3*w^2-2*u*v^5-2*u*w^5-v*w^5-2*u^2*v*w^3+10*u^2*v^2*w^2-
2*u^2*v^3*w+4*u^2*v^4+4*u^2*w^4+4*v^2*w^4-3*u^3*v*w^2-3*u^3*v^2*w-5*u^3*v^3-
5*u^3*w^3-2*v^3*w^3+6*u^4*v^2+6*u^4*w^2+4*v^4*w^2-3*u^5*v-3*u^5*w-v^5*w+2*u^6,
0,30*u^2*v^2*w^2-16*u^3*v^3-16*u^3*w^3-8*v^3*w^3+6*u^6+2*v^6+2*w^6,-
2*u^40*v^30*w^33-2*u^40*v^33*w^30+10*u^41*v^31*w^31-6*u^43*v^30*w^30,
u^6*v^6*w^19-u^6*v^9*w^16-u^6*v^10*w^15-u^6*v^15*w^10-u^6*v^16*w^9+
u^6*v^19*w^6+u^8*v^4*w^19+u^8*v^8*w^15+u^8*v^9*w^14+u^8*v^11*w^12+
u^8*v^12*w^11+u^8*v^14*w^9+u^8*v^15*w^8+u^8*v^19*w^4-u^9*v^6*w^16+
u^9*v^8*w^14+u^9*v^14*w^8-u^9*v^16*w^6+u^10*v^7*w^14-u^10*v^10*w^11-
u^10*v^11*w^10+u^10*v^14*w^7-u^11*v^4*w^16+u^11*v^6*w^14+u^11*v^8*w^12-
u^11*v^10*w^10+u^11*v^12*w^8+u^11*v^14*w^6-u^11*v^16*w^4-u^12*v^4*w^15+
u^12*v^8*w^11+u^12*v^11*w^8-u^12*v^15*w^4+u^14*v^6*w^11+u^14*v^7*w^10+
2*u^14*v^8*w^9+2*u^14*v^9*w^8+u^14*v^10*w^7+u^14*v^11*w^6-u^15*v^4*w^12-
u^15*v^6*w^10+2*u^15*v^8*w^8-u^15*v^10*w^6-u^15*v^12*w^4-u^16*v^4*w^11-
2*u^16*v^6*w^9-2*u^16*v^9*w^6-u^16*v^11*w^4+u^19*v^4*w^8+2*u^19*v^6*w^6+
u^19*v^8*w^4-u^19*v^12-u^19*w^12-u^20*v^11-u^20*w^11+u^23*v^8+u^23*w^8,
0,0,-4*u*v^3*w^3+u*v^6+u*w^6+v*w^6+9*u^2*v^2*w^3+9*u^2*v^3*w^2-
6*u^3*v*w^3+12*u^3*v^2*w^2-6*u^3*v^3*w-4*u^3*v^4-4*u^3*w^4-2*v^3*w^4-
6*u^4*v^3-6*u^4*w^3-2*v^4*w^3+2*u^6*v+2*u^6*w+v^6*w+2*u^7,u^10*v^8*w^10+
u^10*v^10*w^8+2*u^12*v^8*w^8,-u^8*v^8*w^9-u^8*v^9*w^8+3*u^9*v^7*w^9+
3*u^9*v^9*w^7-u^10*v^6*w^9-u^10*v^9*w^6-2*u^11*v^6*w^8+4*u^11*v^7*w^7-
2*u^11*v^8*w^6-2*u^13*v^6*w^6,u^26*v^20*w^22+u^26*v^22*w^20+2*u^28*v^20*w^20,
2*u^3*v^3*w^8+2*u^3*v^4*w^7+2*u^3*v^7*w^4+2*u^3*v^8*w^3+u^4*v^2*w^8+
4*u^4*v^3*w^7+u^4*v^4*w^6-2*u^4*v^5*w^5+u^4*v^6*w^4+4*u^4*v^7*w^3+u^4*v^8*w^2+
2*u^5*v^2*w^7-2*u^5*v^4*w^5-2*u^5*v^5*w^4+2*u^5*v^7*w^2+2*u^6*v^2*w^6+
3*u^6*v^4*w^4+2*u^6*v^6*w^2+2*u^7*v^2*w^5+6*u^7*v^3*w^4+6*u^7*v^4*w^3+
2*u^7*v^5*w^2+u^8*v^2*w^4+4*u^8*v^3*w^3+u^8*v^4*w^2+2*u^9*v^5+2*u^9*w^5+
u^10*v^4+u^10*w^4,0,0,-2*u^8*v^6*w^9-2*u^8*v^9*w^6+10*u^9*v^7*w^7-
6*u^11*v^6*w^6,u^3*v^3*w^8+u^3*v^4*w^7+u^3*v^7*w^4+u^3*v^8*w^3+u^4*v^2*w^8+
u^4*v^3*w^7-u^4*v^5*w^5+u^4*v^7*w^3+u^4*v^8*w^2+u^5*v^2*w^7-u^5*v^4*w^5-
u^5*v^5*w^4+u^5*v^7*w^2+u^7*v^2*w^5+2*u^7*v^3*w^4+2*u^7*v^4*w^3+u^7*v^5*w^2+
u^8*v^2*w^4+2*u^8*v^3*w^3+u^8*v^4*w^2+u^9*v^5+u^9*w^5+u^10*v^4+u^10*w^4,-
u^40*v^31*w^33-u^40*v^33*w^31-u^41*v^30*w^33+3*u^41*v^31*w^32+
3*u^41*v^32*w^31-u^41*v^33*w^30+4*u^42*v^31*w^31-2*u^43*v^30*w^31-
2*u^43*v^31*w^30-2*u^44*v^30*w^30,u^41*v^31*w^32+u^41*v^32*w^31+
2*u^42*v^31*w^31,9*u^2*v^2*w^4-4*u^2*v^3*w^3+9*u^2*v^4*w^2+u^2*v^6+u^2*w^6+
v^2*w^6-6*u^3*v^2*w^3-6*u^3*v^3*w^2-4*u^3*v^5-4*u^3*w^5-2*v^3*w^5+
12*u^4*v^2*w^2-6*u^5*v^3-6*u^5*w^3-2*v^5*w^3+2*u^6*v^2+2*u^6*w^2+v^6*w^2+
2*u^8,-24*u^40*v^30*w^31-24*u^40*v^31*w^30-32*u^41*v^30*w^30,-u^8*v^7*w^9-
u^8*v^9*w^7-u^9*v^6*w^9+3*u^9*v^7*w^8+3*u^9*v^8*w^7-u^9*v^9*w^6+
4*u^10*v^7*w^7-2*u^11*v^6*w^7-2*u^11*v^7*w^6-2*u^12*v^6*w^6,-u^33*v^25*w^26-
u^33*v^26*w^25-2*u^34*v^25*w^25,0,-u^40*v^32*w^33-u^40*v^33*w^32+
3*u^41*v^31*w^33+3*u^41*v^33*w^31-u^42*v^30*w^33-u^42*v^33*w^30-
2*u^43*v^30*w^32+4*u^43*v^31*w^31-2*u^43*v^32*w^30-2*u^45*v^30*w^30,-
6*u^8*v^6*w^10-16*u^8*v^8*w^8-6*u^8*v^10*w^6-20*u^10*v^6*w^8-20*u^10*v^8*w^6-
12*u^12*v^6*w^6,-24*u^8*v^6*w^8-24*u^8*v^8*w^6-32*u^10*v^6*w^6,u^25*v^19*w^20+
u^25*v^20*w^19+2*u^26*v^19*w^19,-6*u^40*v^30*w^33-8*u^40*v^31*w^32-
8*u^40*v^32*w^31-6*u^40*v^33*w^30-10*u^41*v^30*w^32-10*u^41*v^32*w^30-
10*u^42*v^30*w^31-10*u^42*v^31*w^30-12*u^43*v^30*w^30,4*u^3*v^3*w^7+
2*u^3*v^4*w^6+2*u^3*v^6*w^4+4*u^3*v^7*w^3+3*u^4*v^2*w^7+3*u^4*v^3*w^6-
3*u^4*v^4*w^5-3*u^4*v^5*w^4+3*u^4*v^6*w^3+3*u^4*v^7*w^2+2*u^5*v^2*w^6-
3*u^5*v^4*w^4+2*u^5*v^6*w^2+2*u^6*v^2*w^5+5*u^6*v^3*w^4+5*u^6*v^4*w^3+
2*u^6*v^5*w^2+3*u^7*v^2*w^4+8*u^7*v^3*w^3+3*u^7*v^4*w^2+u^8*v^5+u^8*w^5+
2*u^9*v^4+2*u^9*w^4,0,-u^34*v^26*w^28-u^34*v^28*w^26-2*u^36*v^26*w^26,
0,-6*u^8*v^6*w^9-8*u^8*v^7*w^8-8*u^8*v^8*w^7-6*u^8*v^9*w^6-10*u^9*v^6*w^8-
10*u^9*v^8*w^6-10*u^10*v^6*w^7-10*u^10*v^7*w^6-12*u^11*v^6*w^6,0,
u^16*v^13*w^15+u^16*v^15*w^13+u^17*v^12*w^15-3*u^17*v^13*w^14-
3*u^17*v^14*w^13+u^17*v^15*w^12-4*u^18*v^13*w^13+2*u^19*v^12*w^13+
2*u^19*v^13*w^12+2*u^20*v^12*w^12,-u^17*v^13*w^14-u^17*v^14*w^13-
2*u^18*v^13*w^13,8*u^3*v^3*w^6+8*u^3*v^6*w^3+6*u^4*v^2*w^6-9*u^4*v^4*w^4+
6*u^4*v^6*w^2+6*u^6*v^2*w^4+16*u^6*v^3*w^3+6*u^6*v^4*w^2+3*u^8*v^4+3*u^8*w^4,-
u^8*v^7*w^12+2*u^8*v^9*w^10+2*u^8*v^10*w^9-u^8*v^12*w^7-u^9*v^6*w^12+
4*u^9*v^9*w^9-u^9*v^12*w^6-9*u^10*v^8*w^9-9*u^10*v^9*w^8+4*u^11*v^6*w^10+
6*u^11*v^7*w^9-12*u^11*v^8*w^8+6*u^11*v^9*w^7+4*u^11*v^10*w^6+6*u^12*v^6*w^9+
6*u^12*v^9*w^6-2*u^14*v^6*w^7-2*u^14*v^7*w^6-2*u^15*v^6*w^6,0,u^16*v^13*w^19-
u^16*v^15*w^17-2*u^16*v^16*w^16-u^16*v^17*w^15+u^16*v^19*w^13+u^17*v^12*w^19-
2*u^17*v^15*w^16-2*u^17*v^16*w^15+u^17*v^19*w^12+3*u^18*v^14*w^16+
6*u^18*v^15*w^15+3*u^18*v^16*w^14-2*u^19*v^12*w^17-3*u^19*v^13*w^16+
7*u^19*v^14*w^15+7*u^19*v^15*w^14-3*u^19*v^16*w^13-2*u^19*v^17*w^12-
5*u^20*v^12*w^16-3*u^20*v^13*w^15+4*u^20*v^14*w^14-3*u^20*v^15*w^13-
5*u^20*v^16*w^12-3*u^21*v^12*w^15-3*u^21*v^15*w^12+2*u^23*v^12*w^13+
2*u^23*v^13*w^12+2*u^24*v^12*w^12,8*u^6*v^6*w^12+8*u^6*v^12*w^6+
6*u^8*v^4*w^12-9*u^8*v^8*w^8+6*u^8*v^12*w^4+6*u^12*v^4*w^8+16*u^12*v^6*w^6+
6*u^12*v^8*w^4+3*u^16*v^8+3*u^16*w^8,-6*u^24*v^18*w^21-8*u^24*v^19*w^20-
8*u^24*v^20*w^19-6*u^24*v^21*w^18-10*u^25*v^18*w^20-10*u^25*v^20*w^18-
10*u^26*v^18*w^19-10*u^26*v^19*w^18-12*u^27*v^18*w^18,-u^8*v^7*w^9-
2*u^8*v^8*w^8-u^8*v^9*w^7-2*u^9*v^6*w^9-3*u^9*v^7*w^8-3*u^9*v^8*w^7-
2*u^9*v^9*w^6-3*u^10*v^6*w^8-2*u^10*v^7*w^7-3*u^10*v^8*w^6-3*u^11*v^6*w^7-
3*u^11*v^7*w^6-2*u^12*v^6*w^6,-u^18*v^14*w^16-u^18*v^16*w^14-2*u^20*v^14*w^14,
-u^8*v^8*w^12+2*u^8*v^9*w^11+2*u^8*v^11*w^9-u^8*v^12*w^8-u^10*v^6*w^12-
9*u^10*v^8*w^10+4*u^10*v^9*w^9-9*u^10*v^10*w^8-u^10*v^12*w^6+4*u^11*v^6*w^11+
6*u^11*v^8*w^9+6*u^11*v^9*w^8+4*u^11*v^11*w^6-12*u^12*v^8*w^8+6*u^13*v^6*w^9+
6*u^13*v^9*w^6-2*u^14*v^6*w^8-2*u^14*v^8*w^6-2*u^16*v^6*w^6,-u^24*v^19*w^21-
u^24*v^21*w^19-u^25*v^18*w^21+3*u^25*v^19*w^20+3*u^25*v^20*w^19-
u^25*v^21*w^18+4*u^26*v^19*w^19-2*u^27*v^18*w^19-2*u^27*v^19*w^18-
2*u^28*v^18*w^18,2*u^16*v^12*w^15+2*u^16*v^15*w^12-10*u^17*v^13*w^13+
6*u^19*v^12*w^12,u^32*v^26*w^27+u^32*v^27*w^26-3*u^33*v^25*w^27-
3*u^33*v^27*w^25+u^34*v^24*w^27+u^34*v^27*w^24+2*u^35*v^24*w^26-
4*u^35*v^25*w^25+2*u^35*v^26*w^24+2*u^37*v^24*w^24,2*u^32*v^24*w^27+
2*u^32*v^27*w^24-10*u^33*v^25*w^25+6*u^35*v^24*w^24,-u^24*v^20*w^21-
u^24*v^21*w^20+3*u^25*v^19*w^21+3*u^25*v^21*w^19-u^26*v^18*w^21-
u^26*v^21*w^18-2*u^27*v^18*w^20+4*u^27*v^19*w^19-2*u^27*v^20*w^18-
2*u^29*v^18*w^18,-2*u^10*v^7*w^9-3*u^10*v^8*w^8-2*u^10*v^9*w^7-2*u^11*v^7*w^8-
2*u^11*v^8*w^7+u^12*v^6*w^8+u^12*v^8*w^6,u^16*v^13*w^18-2*u^16*v^15*w^16-
2*u^16*v^16*w^15+u^16*v^18*w^13+u^17*v^12*w^18-4*u^17*v^15*w^15+
u^17*v^18*w^12+9*u^18*v^14*w^15+9*u^18*v^15*w^14-4*u^19*v^12*w^16-
6*u^19*v^13*w^15+12*u^19*v^14*w^14-6*u^19*v^15*w^13-4*u^19*v^16*w^12-
6*u^20*v^12*w^15-6*u^20*v^15*w^12+2*u^22*v^12*w^13+2*u^22*v^13*w^12+
2*u^23*v^12*w^12,-2*u^8*v^6*w^12+8*u^8*v^9*w^9-2*u^8*v^12*w^6-30*u^10*v^8*w^8+
16*u^11*v^6*w^9+16*u^11*v^9*w^6-6*u^14*v^6*w^6,-2*u^8*v^7*w^8-2*u^8*v^8*w^7-
3*u^9*v^6*w^8-8*u^9*v^7*w^7-3*u^9*v^8*w^6-5*u^10*v^6*w^7-5*u^10*v^7*w^6-
2*u^11*v^6*w^6,2*u^16*v^12*w^14+4*u^16*v^13*w^13+2*u^16*v^14*w^12+
8*u^17*v^12*w^13+8*u^17*v^13*w^12+6*u^18*v^12*w^12,0,
24*u^32*v^24*w^26+24*u^32*v^26*w^24+32*u^34*v^24*w^24,-2*u^8*v^6*w^8-
4*u^8*v^7*w^7-2*u^8*v^8*w^6-8*u^9*v^6*w^7-8*u^9*v^7*w^6-6*u^10*v^6*w^6,
2*u^16*v^12*w^18-8*u^16*v^15*w^15+2*u^16*v^18*w^12+30*u^18*v^14*w^14-
16*u^19*v^12*w^15-16*u^19*v^15*w^12+6*u^22*v^12*w^12,-6*u^8*v^6*w^8-
16*u^8*v^7*w^7-6*u^8*v^8*w^6-20*u^9*v^6*w^7-20*u^9*v^7*w^6-12*u^10*v^6*w^6,
2*u^16*v^13*w^14+2*u^16*v^14*w^13+3*u^17*v^12*w^14+8*u^17*v^13*w^13+
3*u^17*v^14*w^12+5*u^18*v^12*w^13+5*u^18*v^13*w^12+2*u^19*v^12*w^12,-
2*u^24*v^18*w^21-2*u^24*v^21*w^18+10*u^25*v^19*w^19-6*u^27*v^18*w^18,-
24*u^40*v^30*w^32-24*u^40*v^32*w^30-32*u^42*v^30*w^30,6*u^16*v^12*w^14+
16*u^16*v^13*w^13+6*u^16*v^14*w^12+20*u^17*v^12*w^13+20*u^17*v^13*w^12+
12*u^18*v^12*w^12,-24*u^8*v^6*w^7-24*u^8*v^7*w^6-32*u^9*v^6*w^6,-
80*u^8*v^6*w^6,-6*u^24*v^18*w^20-16*u^24*v^19*w^19-6*u^24*v^20*w^18-
20*u^25*v^18*w^19-20*u^25*v^19*w^18-12*u^26*v^18*w^18,-24*u^24*v^18*w^20-
24*u^24*v^20*w^18-32*u^26*v^18*w^18,24*u^16*v^12*w^13+24*u^16*v^13*w^12+
32*u^17*v^12*w^12,-24*u^24*v^18*w^19-24*u^24*v^19*w^18-32*u^25*v^18*w^18,-
80*u^40*v^30*w^30,-80*u^24*v^18*w^18,80*u^16*v^12*w^12,80*u^32*v^24*w^24];end;
 f64:=function(u,v,w,r)return 
[64, 16*u+24*v+24*w, 4*(v+w)*(v+w+u), 4*(v+u+2*w)*(2*v+u+w), 16*u^2+24*v^2+24*w^2,
-8*u*v*w+4*v^3+4*w^3, (v+w+u)*(v^2+u*v+4*v*w+w^2+u*w), v*w*(v+w+u), 6*u*v^2+6*u*w^2
+10*v*w^2+6*u^2*v+6*u^2*w+10*v^2*w+4*u^3+8*v^3+8*w^3, -u*v*w*(v+w), -v^2*w^2*(v^5*w
^10+v^10*w^5-w^7*v^3*u^5-w^3*v^7*u^5+w^8*v*u^6-w^7*v^2*u^6+w^5*v^4*u^6+w^4*v^5*u^6-
w^2*v^7*u^6+w*v^8*u^6+w^7*v*u^7+w^4*v^4*u^7+w*v^7*u^7+v^8*u^7-w^5*v^2*u^8-w^2*v^5*u
^8+v^7*u^8-2*w^2*v^6*u^7-2*w^6*v^2*u^7-2*w^6*v^3*u^6-2*w^3*v^6*u^6-2*w^4*v^6*u^5-2*
w^6*v^4*u^5-2*w^6*v^5*u^4-2*w^5*v^6*u^4-w^11*v^2*u^2+w^8*v^5*u^2+w^7*v^6*u^2+w^6*v^
7*u^2+w^5*v^8*u^2-w^2*v^11*u^2-w^11*v*u^3+w^8*v^4*u^3+w^7*v^5*u^3+w^5*v^7*u^3+w^4*v
^8*u^3-w*v^11*u^3-w^7*v^4*u^4-w^4*v^7*u^4-v^11*u^4+w^8*u^7+w^7*u^8-w^11*u^4-w^13*v^
2+w^9*v^6+w^6*v^9-w^2*v^13), (v+w)*(v+w+u)*(v^2+v*w+w^2+u^2), -r*u*v*w, 4*(v^2+u^2+
2*w^2)*(2*v^2+u^2+w^2), -4*(v+w)*(-v^6+v^5*w-v^4*w^2+u^3*v^3+3*v^3*w^3-2*u^2*v^2*w^
2-v^2*w^4+u^4*v^2-u^3*v^2*w-u^3*v*w^2+v*w^5-v*u^4*w+u^3*w^3-w^6+u^4*w^2), -3*u*v*w^
2-3*u*v^2*w+u*v^3+u*w^3+2*v*w^3-2*u^2*v*w+2*v^3*w+v^4+w^4, -4*u*v*w^3+2*u*v^2*w^2-4
*u*v^3*w-v*w^4+3*u^2*v*w^2+3*u^2*v^2*w+2*u^2*v^3+2*u^2*w^3-4*u^3*v*w+u^3*v^2+u^3*w^
2-u^4*v-u^4*w-v^4*w+v^5+w^5, -u^2*v^3*w^3,-u^2*v^2*w^4-u^2*v^4*w^2,0,
u^4*v^8*w^14+u^4*v^9*w^13+
u^4*v^13*w^9+u^4*v^14*w^8+u^6*v^6*w^14+u^6*v^7*w^13+u^6*v^13*w^7+u^6*v^14*w^6+
u^7*v^6*w^13+u^7*v^13*w^6+u^8*v^4*w^14-u^8*v^9*w^9+u^8*v^14*w^4+v^8*w^18+
u^9*v^4*w^13-u^9*v^8*w^9-u^9*v^9*w^8+u^9*v^13*w^4+v^9*w^17+v^17*w^9+v^18*w^8,
-3*u*v*w^3-3*u*v^3*w+u^2*v^3+u^2*w^3+2*v^2*w^3-2*u^3*v*w+2*v^3*w^2+v^5+w^5,
-r*u^6*v^8*w^9-r*u^6*v^9*w^8,u^5*v^5*w^5+v^5*w^10+v^10*w^5,-r*u^27*v^39*w^41-
r*u^27*v^41*w^39,u^2*v^4*w^12-2*u^2*v^7*w^9-2*u^2*v^9*w^7+u^2*v^12*w^4+
u^3*v^3*w^12-2*u^3*v^6*w^9-2*u^3*v^9*w^6+u^3*v^12*w^3+u^4*v^2*w^12+
3*u^4*v^6*w^8+2*u^4*v^7*w^7+3*u^4*v^8*w^6+u^4*v^12*w^2+v^4*w^14+3*u^5*v^5*w^8+
3*u^5*v^8*w^5-2*u^6*v^3*w^9+3*u^6*v^4*w^8-3*u^6*v^6*w^6+3*u^6*v^8*w^4-
2*u^6*v^9*w^3-2*u^7*v^2*w^9+2*u^7*v^4*w^7+2*u^7*v^7*w^4-2*u^7*v^9*w^2-
2*v^7*w^11-2*v^11*w^7+v^14*w^4,2*u*v^2*w^3+2*u*v^3*w^2+2*u^2*v*w^3+
3*u^2*v^2*w^2+2*u^2*v^3*w-v^2*w^4-v^4*w^2,-r*u^3*v^4*w^4,-2*u*v^2*w^3-
2*u*v^3*w^2-u*v^5-u*w^5-3*v*w^5-2*u^2*v*w^3+8*u^2*v^2*w^2-2*u^2*v^3*w+
4*u^2*v^4+4*u^2*w^4+5*v^2*w^4-2*u^3*v*w^2-2*u^3*v^2*w-2*u^3*v^3-2*u^3*w^3-
6*v^3*w^3+2*u^4*v^2+2*u^4*w^2+5*v^4*w^2-u^5*v-u^5*w-3*v^5*w+v^6+w^6,0,
24*u^2*v^2*w^2-8*u^3*v^3-8*u^3*w^3-16*v^3*w^3+4*v^6+4*w^6,4*r*u^25*v^37*w^40+
4*r*u^25*v^40*w^37-8*r*u^26*v^38*w^38,u^4*v^8*w^19-u^4*v^11*w^16-
u^4*v^12*w^15-u^4*v^15*w^12-u^4*v^16*w^11+u^4*v^19*w^8+u^6*v^6*w^19-
u^6*v^9*w^16+u^6*v^11*w^14+u^6*v^14*w^11-u^6*v^16*w^9+u^6*v^19*w^6+
u^7*v^10*w^14+u^7*v^14*w^10+u^8*v^4*w^19+u^8*v^8*w^15+u^8*v^9*w^14+
u^8*v^11*w^12+u^8*v^12*w^11+u^8*v^14*w^9+u^8*v^15*w^8+u^8*v^19*w^4+v^8*w^23-
u^9*v^6*w^16+u^9*v^8*w^14+u^9*v^14*w^8-u^9*v^16*w^6+u^10*v^7*w^14-
u^10*v^10*w^11-u^10*v^11*w^10+u^10*v^14*w^7-u^11*v^4*w^16+u^11*v^6*w^14+
u^11*v^8*w^12-u^11*v^10*w^10+u^11*v^12*w^8+u^11*v^14*w^6-u^11*v^16*w^4-
v^11*w^20-u^12*v^4*w^15+u^12*v^8*w^11+u^12*v^11*w^8-u^12*v^15*w^4-v^12*w^19-
v^19*w^12-v^20*w^11+v^23*w^8,0,-u^4*v^6*w^6,
-4*u*v^3*w^3+u*v^6+u*w^6+2*v*w^6+9*u^2*v^2*w^3+9*u^2*v^3*w^2-4*u^3*v*w^3+6*u^3*v^2
*w^2-4*u^3*v^3*w-2*u^3*v^4-2*u^3*w^4-6*v^3*w^4-2*u^4*v^3-2*u^4*w^3-6*v^4*w^3+2*v^6*
w+v^7+w^7, -r*u^7*v^9*w^9*(w^2+v^2), -r*u^5*v^7*w^7*(-w^5-2*v^2*w^3-2*v^3*w^2-v^5+3
*w^3*v*u+3*w*v^3*u-w^3*u^2-v^3*u^2+2*w*v*u^3), -r*u^17*v^24*w^24*(w^2+v^2), v^2*w^2
*(-u^6*v^2*w^2-2*u^5*v^2*w^3-2*u^5*v^3*w^2+u^6*v^4+u^6*w^4+2*u^5*w^5+2*u^5*v^5+w^6*
v^2*u^2+w^2*v^6*u^2+w^4*v^2*u^4+w^2*v^4*u^4+4*w*v^5*u^4+v^6*u^4+2*w^4*v^4*u^2+2*w^3
*v^5*u^2+4*w^5*v^2*u^3+4*w^2*v^5*u^3+2*w*v^6*u^3+4*w^5*v*u^4-2*w^3*v^3*u^4+2*w^5*v^
3*u^2+2*w^6*v*u^3+w^8*v^2+2*w^7*v^3+w^6*u^4+w^2*v^8+2*w^3*v^7), 0, -r*u^11*v^16*w^
16, -4*r*u^5*v^7*w^7*(-v^3+2*u*w*v-w^3), v^2*w^2*(w^6*v^2*u^2+w^5*v^3*u^2+w^3*v^5*u
^2+w^2*v^6*u^2+w^6*v*u^3+w^5*v^2*u^3+w^2*v^5*u^3+w*v^6*u^3+w^6*u^4+w^5*v*u^4-w^3*v^
3*u^4+w*v^5*u^4+v^6*u^4+w^8*v^2+u^5*w^5-u^5*v^2*w^3-u^5*v^3*w^2+u^5*v^5+w^7*v^3+w^3
*v^7+w^2*v^8), -r*u^25*v^37*w^37*(-w^4-2*v*w^3-2*v^3*w-v^4-w^3*u+3*w^2*v*u+3*w*v^2*
u-v^3*u+2*w*v*u^2), -r*u^26*v^38*w^38*(v+w),
9*u^2*v^2*w^4-4*u^2*v^3*w^3+9*u^2*v^4*w^2+u^2*v^6+u^2*w^6+2*v^2*w^6-
4*u^3*v^2*w^3-4*u^3*v^3*w^2-2*u^3*v^5-2*u^3*w^5-6*v^3*w^5+6*u^4*v^2*w^2-
2*u^5*v^3-2*u^5*w^3-6*v^5*w^3+2*v^6*w^2+v^8+w^8,24*r*u^25*v^37*w^38+
24*r*u^25*v^38*w^37+16*r*u^26*v^37*w^37,r*u^5*v^7*w^11+2*r*u^5*v^8*w^10+
2*r*u^5*v^10*w^8+r*u^5*v^11*w^7+r*u^6*v^7*w^10-3*r*u^6*v^8*w^9-
3*r*u^6*v^9*w^8+r*u^6*v^10*w^7-2*r*u^7*v^8*w^8,-u^21*v^31*w^32-u^21*v^32*w^31,
0,r*u^25*v^37*w^42+2*r*u^25*v^39*w^40+2*r*u^25*v^40*w^39+r*u^25*v^42*w^37-
3*r*u^26*v^38*w^40-3*r*u^26*v^40*w^38+r*u^27*v^37*w^40+r*u^27*v^40*w^37-
2*r*u^28*v^38*w^38,8*r*u^5*v^7*w^11+20*r*u^5*v^9*w^9+8*r*u^5*v^11*w^7+
12*r*u^7*v^7*w^9+12*r*u^7*v^9*w^7+4*r*u^9*v^7*w^7,24*r*u^5*v^7*w^9+
24*r*u^5*v^9*w^7+16*r*u^7*v^7*w^7,-r*u^16*v^23*w^24-r*u^16*v^24*w^23,
8*r*u^25*v^37*w^40+10*r*u^25*v^38*w^39+10*r*u^25*v^39*w^38+8*r*u^25*v^40*w^37+
6*r*u^26*v^37*w^39+6*r*u^26*v^39*w^37+6*r*u^27*v^37*w^38+6*r*u^27*v^38*w^37+
4*r*u^28*v^37*w^37,3*u^2*v^4*w^7+2*u^2*v^5*w^6+2*u^2*v^6*w^5+3*u^2*v^7*w^4+
4*u^3*v^3*w^7+3*u^3*v^4*w^6+3*u^3*v^6*w^4+4*u^3*v^7*w^3+3*u^4*v^2*w^7+
3*u^4*v^3*w^6-3*u^4*v^4*w^5-3*u^4*v^5*w^4+3*u^4*v^6*w^3+3*u^4*v^7*w^2+
2*v^4*w^9+2*u^5*v^2*w^6-3*u^5*v^4*w^4+2*u^5*v^6*w^2+v^5*w^8+v^8*w^5+2*v^9*w^4,
0,-u^22*v^32*w^34-u^22*v^34*w^32,0,8*r*u^5*v^7*w^10+10*r*u^5*v^8*w^9+
10*r*u^5*v^9*w^8+8*r*u^5*v^10*w^7+6*r*u^6*v^7*w^9+6*r*u^6*v^9*w^7+
6*r*u^7*v^7*w^8+6*r*u^7*v^8*w^7+4*r*u^8*v^7*w^7,0,u^10*v^15*w^19+
2*u^10*v^16*w^18+2*u^10*v^18*w^16+u^10*v^19*w^15+u^11*v^15*w^18-
3*u^11*v^16*w^17-3*u^11*v^17*w^16+u^11*v^18*w^15-2*u^12*v^16*w^16,-
u^11*v^16*w^17-u^11*v^17*w^16,6*u^2*v^4*w^6+6*u^2*v^6*w^4+8*u^3*v^3*w^6+
8*u^3*v^6*w^3+6*u^4*v^2*w^6-9*u^4*v^4*w^4+6*u^4*v^6*w^2+3*v^4*w^8+3*v^8*w^4,
r*u^5*v^7*w^14+2*r*u^5*v^8*w^13-6*r*u^5*v^10*w^11-6*r*u^5*v^11*w^10+
2*r*u^5*v^13*w^8+r*u^5*v^14*w^7+r*u^6*v^7*w^13-4*r*u^6*v^10*w^10+
r*u^6*v^13*w^7+9*r*u^7*v^9*w^10+9*r*u^7*v^10*w^9-2*r*u^8*v^7*w^11-
4*r*u^8*v^8*w^10+6*r*u^8*v^9*w^9-4*r*u^8*v^10*w^8-2*r*u^8*v^11*w^7-
2*r*u^9*v^7*w^10-2*r*u^9*v^10*w^7,-u^6*v^9*w^9,u^10*v^15*w^23+
2*u^10*v^16*w^22-3*u^10*v^18*w^20-6*u^10*v^19*w^19-3*u^10*v^20*w^18+
2*u^10*v^22*w^16+u^10*v^23*w^15+u^11*v^15*w^22-2*u^11*v^18*w^19-
2*u^11*v^19*w^18+u^11*v^22*w^15+3*u^12*v^17*w^19+6*u^12*v^18*w^18+
3*u^12*v^19*w^17-u^13*v^15*w^20-2*u^13*v^16*w^19+5*u^13*v^17*w^18+
5*u^13*v^18*w^17-2*u^13*v^19*w^16-u^13*v^20*w^15-2*u^14*v^15*w^19-
2*u^14*v^16*w^18+2*u^14*v^17*w^17-2*u^14*v^18*w^16-2*u^14*v^19*w^15-
u^15*v^15*w^18-u^15*v^18*w^15,6*u^4*v^8*w^12+6*u^4*v^12*w^8+8*u^6*v^6*w^12+
8*u^6*v^12*w^6+6*u^8*v^4*w^12-9*u^8*v^8*w^8+6*u^8*v^12*w^4+3*v^8*w^16+
3*v^16*w^8,8*r*u^15*v^22*w^25+10*r*u^15*v^23*w^24+10*r*u^15*v^24*w^23+
8*r*u^15*v^25*w^22+6*r*u^16*v^22*w^24+6*r*u^16*v^24*w^22+6*r*u^17*v^22*w^23+
6*r*u^17*v^23*w^22+4*r*u^18*v^22*w^22,r*u^5*v^7*w^11+3*r*u^5*v^8*w^10+
4*r*u^5*v^9*w^9+3*r*u^5*v^10*w^8+r*u^5*v^11*w^7+r*u^6*v^7*w^10+
2*r*u^6*v^8*w^9+2*r*u^6*v^9*w^8+r*u^6*v^10*w^7+r*u^7*v^7*w^9+2*r*u^7*v^8*w^8+
r*u^7*v^9*w^7+r*u^8*v^7*w^8+r*u^8*v^8*w^7,-u^12*v^17*w^19-u^12*v^19*w^17,
r*u^5*v^7*w^15+2*r*u^5*v^9*w^13-6*r*u^5*v^10*w^12-6*r*u^5*v^12*w^10+
2*r*u^5*v^13*w^9+r*u^5*v^15*w^7+r*u^7*v^7*w^13+9*r*u^7*v^9*w^11-
4*r*u^7*v^10*w^10+9*r*u^7*v^11*w^9+r*u^7*v^13*w^7-2*r*u^8*v^7*w^12-
4*r*u^8*v^9*w^10-4*r*u^8*v^10*w^9-2*r*u^8*v^12*w^7+6*r*u^9*v^9*w^9-
2*r*u^10*v^7*w^10-2*r*u^10*v^10*w^7,r*u^15*v^22*w^26+2*r*u^15*v^23*w^25+
2*r*u^15*v^25*w^23+r*u^15*v^26*w^22+r*u^16*v^22*w^25-3*r*u^16*v^23*w^24-
3*r*u^16*v^24*w^23+r*u^16*v^25*w^22-2*r*u^17*v^23*w^23,4*u^10*v^15*w^18+
4*u^10*v^18*w^15-8*u^11*v^16*w^16,u^20*v^30*w^35+2*u^20*v^32*w^33+
2*u^20*v^33*w^32+u^20*v^35*w^30-3*u^21*v^31*w^33-3*u^21*v^33*w^31+
u^22*v^30*w^33+u^22*v^33*w^30-2*u^23*v^31*w^31,4*u^20*v^30*w^33+
4*u^20*v^33*w^30-8*u^21*v^31*w^31,r*u^15*v^22*w^27+2*r*u^15*v^24*w^25+
2*r*u^15*v^25*w^24+r*u^15*v^27*w^22-3*r*u^16*v^23*w^25-3*r*u^16*v^25*w^23+
r*u^17*v^22*w^25+r*u^17*v^25*w^22-2*r*u^18*v^23*w^23,-r*u^5*v^9*w^11-
r*u^5*v^11*w^9+2*r*u^6*v^9*w^10+2*r*u^6*v^10*w^9+2*r*u^7*v^8*w^10+
3*r*u^7*v^9*w^9+2*r*u^7*v^10*w^8,u^10*v^15*w^22+2*u^10*v^16*w^21-
6*u^10*v^18*w^19-6*u^10*v^19*w^18+2*u^10*v^21*w^16+u^10*v^22*w^15+
u^11*v^15*w^21-4*u^11*v^18*w^18+u^11*v^21*w^15+9*u^12*v^17*w^18+
9*u^12*v^18*w^17-2*u^13*v^15*w^19-4*u^13*v^16*w^18+6*u^13*v^17*w^17-
4*u^13*v^18*w^16-2*u^13*v^19*w^15-2*u^14*v^15*w^18-2*u^14*v^18*w^15,
4*r*u^5*v^7*w^13-16*r*u^5*v^10*w^10+4*r*u^5*v^13*w^7+24*r*u^7*v^9*w^9-
8*r*u^8*v^7*w^10-8*r*u^8*v^10*w^7,r*u^5*v^7*w^10+5*r*u^5*v^8*w^9+
5*r*u^5*v^9*w^8+r*u^5*v^10*w^7+2*r*u^6*v^7*w^9+6*r*u^6*v^8*w^8+
2*r*u^6*v^9*w^7+r*u^7*v^7*w^8+r*u^7*v^8*w^7,4*u^10*v^15*w^17+8*u^10*v^16*w^16+
4*u^10*v^17*w^15+4*u^11*v^15*w^16+4*u^11*v^16*w^15,0,
24*u^20*v^30*w^32+24*u^20*v^32*w^30+16*u^22*v^30*w^30,4*r*u^5*v^7*w^9+
8*r*u^5*v^8*w^8+4*r*u^5*v^9*w^7+4*r*u^6*v^7*w^8+4*r*u^6*v^8*w^7,
4*u^10*v^15*w^21-16*u^10*v^18*w^18+4*u^10*v^21*w^15+24*u^12*v^17*w^17-
8*u^13*v^15*w^18-8*u^13*v^18*w^15,8*r*u^5*v^7*w^9+20*r*u^5*v^8*w^8+
8*r*u^5*v^9*w^7+12*r*u^6*v^7*w^8+12*r*u^6*v^8*w^7+4*r*u^7*v^7*w^7,
u^10*v^15*w^18+5*u^10*v^16*w^17+5*u^10*v^17*w^16+u^10*v^18*w^15+
2*u^11*v^15*w^17+6*u^11*v^16*w^16+2*u^11*v^17*w^15+u^12*v^15*w^16+
u^12*v^16*w^15,4*r*u^15*v^22*w^25+4*r*u^15*v^25*w^22-8*r*u^16*v^23*w^23,
24*r*u^25*v^37*w^39+24*r*u^25*v^39*w^37+16*r*u^27*v^37*w^37,8*u^10*v^15*w^17+
20*u^10*v^16*w^16+8*u^10*v^17*w^15+12*u^11*v^15*w^16+12*u^11*v^16*w^15+
4*u^12*v^15*w^15,24*r*u^5*v^7*w^8+24*r*u^5*v^8*w^7+16*r*u^6*v^7*w^7,
64*r*u^5*v^7*w^7,8*r*u^15*v^22*w^24+20*r*u^15*v^23*w^23+8*r*u^15*v^24*w^22+
12*r*u^16*v^22*w^23+12*r*u^16*v^23*w^22+4*r*u^17*v^22*w^22,
24*r*u^15*v^22*w^24+24*r*u^15*v^24*w^22+16*r*u^17*v^22*w^22,24*u^10*v^15*w^16+
24*u^10*v^16*w^15+16*u^11*v^15*w^15,24*r*u^15*v^22*w^23+24*r*u^15*v^23*w^22+
16*r*u^16*v^22*w^22,64*r*u^25*v^37*w^37,64*r*u^15*v^22*w^22,64*u^10*v^15*w^15,
64*u^20*v^30*w^30];end;
  f81:=function(u,v,w,r)return
[81, 27*u+27*v+27*w, 3*(v+u+w)^2, 9*(v+u+w)^2, 27*u^2+27*v^2+27*w^2, -12*w*v*u+3*u^
3+3*v^3+3*w^3, (v+u+w)^3, 0, 9*(v+u+w)*(w^2+v^2+u^2), -u*w*v*(v+u+w), w^2*v^2*u^2*(
u^7*w^3*v^3-u^8*w^4*v-u^8*w*v^4+v^3*u^3*w^7+2*v^4*u^3*w^6+2*v^3*u^4*w^6-u^6*w^7-u^7
*w^6-v^6*w^7-v^7*w^6-u^7*v^6-u^8*w^5-u^8*v^5-u^7*w^5*v-u^7*w*v^5-w^5*v^8+w^11*u^2+w
^11*v^2-w^8*v^5+w^2*v^11-w^8*u^5+w^2*u^11-w^4*u*v^8-w^5*u*v^7+w^11*v*u-w^8*v^4*u-w^
7*v^5*u+w*v^11*u+v^11*u^2-w^8*v*u^4-w*v^8*u^4-w^7*v*u^5-w*v^7*u^5-v^8*u^5-v^7*u^6+w
*v*u^11+v^2*u^11+2*u^6*v^4*w^3+2*u^6*v^3*w^4+u^7*v^2*w^4+2*u^6*v^5*w^2+u^7*v^4*w^2+
u^4*v^7*w^2+2*u^4*v^6*w^3+2*u^5*v^2*w^6+2*u^6*v^2*w^5+2*u^5*v^6*w^2+2*u^2*v^6*w^5+u
^2*v^7*w^4+2*u^3*v^6*w^4+u^3*v^7*w^3+u^4*v^2*w^7+u^2*v^4*w^7+2*u^2*v^5*w^6), (w^2+v
^2+u^2)*(v+u+w)^2, r*u*v*w, 9*(w^2+v^2+u^2)^2, 12*w^3*v^2*u^2+12*w^2*v^3*u^2+12*w^2
*v^2*u^3-6*v^4*u^3-6*w^4*u^3-6*w^4*v^3-6*u^4*v^3-6*u^4*w^3-6*w^3*v^4+3*u^7+3*v^7+3*
w^7, (v+u+w)*(v^3-4*w*v*u+u^3+w^3), (v+u+w)*(v^4-2*v^3*u-2*w*v^3+4*u^2*v^2+4*w^2*v^
2-2*v*u^3-2*w^3*v+u^4+4*u^2*w^2-2*w^3*u+w^4-2*w*u^3), r^2*u^2*v^2*w^2, -w^2*v^2*u^2
*(w^2+v^2+u^2), -r^2*u*v*w, u^4*v^4*w^4*(w^10*v^4+v^5*w^9+w^5*v^9+w^4*v^10+v^2*u^2*
w^10+v^3*u^2*w^9+w^3*u^2*v^9+w^2*v^10*u^2+v^2*u^3*w^9+w^2*u^3*v^9+w^10*u^4-u^4*v^5*
w^5+v^10*u^4+u^5*w^9-u^5*v^4*w^5-u^5*v^5*w^4+v^9*u^5+w^5*u^9+w^3*u^9*v^2+w^2*u^9*v^
3+v^5*u^9+w^4*u^10+w^2*v^2*u^10+v^4*u^10), (w^2+v^2+u^2)*(v^3-4*w*v*u+u^3+w^3), -r^
2*u^7*v^7*w^7*(v+u+w), 0, -r*u^35*v^35*w^35*(w^2+v^2+u^2), w^2*v^2*u^2*(3*u^6*v^2*w
^4+3*u^6*v^3*w^3+3*u^6*v^4*w^2+3*u^2*v^4*w^6+3*u^2*v^6*w^4+3*u^3*v^3*w^6+3*u^3*v^6*
w^3+3*u^4*v^2*w^6+3*u^4*v^6*w^2-2*w^7*u^5-2*v^7*u^5-2*u^7*w^4*v-2*u^7*w*v^4-2*u^7*w
^5-2*u^7*v^5+v^2*w^10+w^2*v^10+u^2*w^10+w^2*u^10+v^10*u^2+v^2*u^10+w^10*v*u+w*v^10*
u-2*w^7*v*u^4+w*v*u^10-2*w*u^4*v^7-2*v^5*w^7-2*v^7*w^5+2*u^5*v^2*w^5+2*u^2*v^5*w^5+
2*u^5*v^5*w^2-2*u*v^7*w^4-2*u*v^4*w^7),
2*w*v*u*(v+u+w)*(u*v+w*v+u*w), u^4*v^4*w^4, (w^2+v^2+u^2)*(v^4-2*v^3*u-2*w*v^3+4*u
^2*v^2+4*w^2*v^2-2*v*u^3-2*w^3*v+u^4+4*u^2*w^2-2*w^3*u+w^4-2*w*u^3), 0, 36*w^2*v^2*
u^2-12*u^3*v^3-12*u^3*w^3-12*w^3*v^3+3*u^6+3*v^6+3*w^6, 3*r*u^33*v^33*w^33*(v^3-4*w
*v*u+u^3+w^3), u^4*v^4*w^4*(-v^12*w^7+u^3*v^6*w^10+u^3*v^10*w^6-v^7*w^12+v^2*u^2*w^
15+u^2*v^7*w^10+u^8*v^7*w^4+u^8*v^4*w^7+u^7*v^4*w^8+u^7*v^8*w^4+u^2*v^10*w^7+u^4*v^
7*w^8+u^4*v^8*w^7+u^6*v^3*w^10+u^6*v^10*w^3+u^7*v^2*w^10+u^7*v^10*w^2+u^10*v^2*w^7+
u^10*v^3*w^6+u^10*v^6*w^3+u^10*v^7*w^2-u^12*w^7-u^12*v^7-u^12*v^2*w^5-u^12*v^5*w^2-
w^12*v^5*u^2-w^5*v^12*u^2+w^2*v^15*u^2+w^11*v^4*u^4+w^10*v^5*u^4+w^5*v^10*u^4+w^4*v
^11*u^4+v^15*u^4-w^12*v^2*u^5+w^10*v^4*u^5+w^4*v^10*u^5-w^2*v^12*u^5-v^12*u^7-v^11*
u^8+w^5*v^4*u^10+w^4*v^5*u^10+w^4*v^4*u^11-v^8*u^11+w^2*v^2*u^15+v^4*u^15+w^15*u^4-
w^12*u^7-w^11*u^8-w^8*u^11+w^4*u^15+w^15*v^4-w^11*v^8-w^8*v^11+w^4*v^15), -r*u^8*v^
8*w^8, r*u^5*v^5*w^5, (v+u+w)*(v^6-4*w^3*v^3-4*u^3*v^3+12*w^2*v^2*u^2-4*u^3*w^3+w^6
+u^6), -r^2*u^8*v^8*w^8*(w^2+v^2+u^2), r^2*u^6*v^6*w^6*(w^2+v^2+u^2)*(v^3-4*w*v*u+u
^3+w^3), -u^22*v^22*w^22*(w^2+v^2+u^2), w^2*v^2*u^2*(v+u+w)*(v^5*u^2+w^2*v^5+2*w*v^
5*u+w^3*v^4+w^2*v^4*u+w*v^4*u^2+v^4*u^3+u^4*v^3+w^4*v^3-2*w^3*v^3*u-2*w*v^3*u^3+u^5
*v^2+u^4*w*v^2+w^4*v^2*u+v^2*w^5-2*w^3*v*u^3+w^4*v*u^2+u^4*w^2*v+2*u^5*w*v+2*w^5*v*
u+u^5*w^2+w^5*u^2+u^4*w^3+w^4*u^3),
Mvp("f")*r*u^3*v^3*w^3*(u+v+w),
r^2*u^14*v^14*w^14, 3*r^2*u^6*v^6*w^6*(v^3-4*w*v*u+u^3+w^3), w^2*v^2*u^2*(v^2*w^6+
w^5*v^3+w^3*v^5+w^2*v^6+v*u*w^6+w^5*v^2*u+w^2*v^5*u+w*u*v^6+u^2*w^6+w^5*v*u^2-w^3*v
^3*u^2+w*v^5*u^2+v^6*u^2+w^5*u^3-w^3*v^2*u^3-w^2*v^3*u^3+v^5*u^3+w^3*u^5+w^2*v*u^5+
w*u^5*v^2+v^3*u^5+u^6*w^2+u^6*w*v+u^6*v^2), r*u^33*v^33*w^33*(v+u+w)*(v^3-4*w*v*u+u
^3+w^3), -r*u^34*v^34*w^34*(v+u+w), (v^6-4*w^3*v^3-4*u^3*v^3+12*w^2*v^2*u^2-4*u^3*w
^3+w^6+u^6)*(w^2+v^2+u^2), 27*r*u^33*v^33*w^33*(v+u+w), r^2*u^6*v^6*w^6*(v+u+w)*(v^
3-4*w*v*u+u^3+w^3), -r^2*u^27*v^27*w^27*(v+u+w), -u^5*v^5*w^5, r*u^33*v^33*w^33*(w^
2+v^2+u^2)*(v^3-4*w*v*u+u^3+w^3), 9*r^2*u^6*v^6*w^6*(w^2+v^2+u^2)^2, 27*r^2*u^6*v^6
*w^6*(w^2+v^2+u^2), -u^21*v^21*w^21*(v+u+w), 9*r*u^33*v^33*w^33*(v+u+w)*(w^2+v^2+u^
2), w^2*v^2*u^2*(3*v^2*w^5+2*w^4*v^3+2*w^3*v^4+3*w^2*v^5+4*w^5*v*u+3*w^4*v^2*u+3*w^
2*v^4*u+4*w*v^5*u+3*w^5*u^2+3*w^4*v*u^2-2*w^3*v^2*u^2-2*w^2*v^3*u^2+3*w*v^4*u^2+3*v
^5*u^2+2*w^4*u^3-2*w^2*v^2*u^3+2*v^4*u^3+2*u^4*w^3+3*u^4*w^2*v+3*u^4*w*v^2+2*u^4*v^
3+3*u^5*w^2+4*u^5*w*v+3*u^5*v^2),
Mvp("f")*r*u^10*v^10*w^10*(u+v+w),
-r^2*u^28*v^28*w^28*(w^2+v^2+u^2), -3*r*u^3*v^3*w^3, 9*r^2*u^6*v^6*w^6*(v+u+w)*(w^
2+v^2+u^2), -3*r^2*u^16*v^16*w^16, r*u^13*v^13*w^13*(v+u+w)*(v^3-4*w*v*u+u^3+w^3),
-r*u^14*v^14*w^14*(v+u+w), 2*w^2*v^2*u^2*(3*w^4*v^2+3*w^2*v^4+4*w^4*v*u+4*w*v^4*u+3
*w^4*u^2-3*w^2*v^2*u^2+3*v^4*u^2+3*w^2*u^4+4*u^4*w*v+3*v^2*u^4), r^2*u^6*v^6*w^6*(v
+u+w)*(v^6-4*w^3*v^3-4*u^3*v^3+12*w^2*v^2*u^2-4*u^3*w^3+w^6+u^6), u^8*v^8*w^8, r*u^
13*v^13*w^13*(v+u+w)*(v^7-2*v^4*u^3-2*w^3*v^4+4*w^2*v^3*u^2-2*w^4*v^3-2*u^4*v^3+4*w
^3*v^2*u^2+4*w^2*v^2*u^3-2*w^4*u^3-2*u^4*w^3+u^7+w^7), 2*u^4*v^4*w^4*(3*w^8*v^4+3*w
^4*v^8+4*w^8*v^2*u^2+4*w^2*v^8*u^2+3*w^8*u^4-3*u^4*v^4*w^4+3*v^8*u^4+3*u^8*w^4+4*u^
8*v^2*w^2+3*u^8*v^4), 9*u^20*v^20*w^20*(v+u+w)*(w^2+v^2+u^2), r^2*u^6*v^6*w^6*(w^2+
v^2+u^2)*(v+u+w)^2, -r*u^15*v^15*w^15*(w^2+v^2+u^2), r^2*u^6*v^6*w^6*(v^6-4*w^3*v^3
-4*u^3*v^3+12*w^2*v^2*u^2-4*u^3*w^3+w^6+u^6)*(w^2+v^2+u^2), u^20*v^20*w^20*(v+u+w)*
(v^3-4*w*v*u+u^3+w^3), 3*r*u^13*v^13*w^13*(v^3-4*w*v*u+u^3+w^3), r^2*u^26*v^26*w^26
*(w^2+v^2+u^2)*(v^3-4*w*v*u+u^3+w^3),
3*r^2*u^26*v^26*w^26*(v^3-4*w*v*u+u^3+w^3), u^20*v^20*w^20*(w^2+v^2+u^2)*(v^3-4*w*
v*u+u^3+w^3), 2*r^2*u^7*v^7*w^7*(v+u+w)*(u*v+w*v+u*w), r*u^13*v^13*w^13*(v+u+w)*(v^
6-4*w^3*v^3-4*u^3*v^3+12*w^2*v^2*u^2-4*u^3*w^3+w^6+u^6), 3*r^2*u^6*v^6*w^6*(v^6-4*w
^3*v^3-4*u^3*v^3+12*w^2*v^2*u^2-4*u^3*w^3+w^6+u^6), r^2*u^6*v^6*w^6*(v+u+w)^3, 3*r*
u^13*v^13*w^13*(v+u+w)^2, -3*u^10*v^10*w^10, 27*r^2*u^26*v^26*w^26*(w^2+v^2+u^2), 3
*r^2*u^6*v^6*w^6*(v+u+w)^2, 3*r*u^13*v^13*w^13*(v^6-4*w^3*v^3-4*u^3*v^3+12*w^2*v^2*
u^2-4*u^3*w^3+w^6+u^6), 9*r^2*u^6*v^6*w^6*(v+u+w)^2, r*u^13*v^13*w^13*(v+u+w)^3, 3*
u^20*v^20*w^20*(v^3-4*w*v*u+u^3+w^3), 27*r*u^33*v^33*w^33*(w^2+v^2+u^2), 9*r*u^13*v
^13*w^13*(v+u+w)^2, 27*r^2*u^6*v^6*w^6*(v+u+w), 81*r^2*u^6*v^6*w^6, 9*u^20*v^20*w^
20*(v+u+w)^2, 27*u^20*v^20*w^20*(w^2+v^2+u^2), 27*r*u^13*v^13*w^13*(v+u+w), 27*u^20
*v^20*w^20*(v+u+w), 81*r*u^33*v^33*w^33, 81*u^20*v^20*w^20, 81*r*u^13*v^13*w^13, 81
*r^2*u^26*v^26*w^26];end;
  res:=rec( name:="H(G32)", identifier:="H(G32)",
   parameter:=para, size:=155520,order:=155520,
  dim:=4, degrees:=[12,18,24,30], reflclasses:=[2],
  powermap:=CHEVIE.RawData("PowerMaps","G32"),
  irredinfo:=List(CHEVIE.RawData("CharInfo","G32")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G32")(x,rec()))),
  text:="origin: J.Michel, 2008/2012");
  Inherit(res,CHEVIE.RawData("ClassInfo","G32"));
  res.centralizers:=List(res.classes,x->res.order/x);
  res.irreducibles:=
[f1(u),f1(w), f1(v),f4(v,w),f4(u,v),f4(w,u),f4(w,v),f4(u,w),f4(v,u),#9
 f5(u,v,w),f5(w,u,v),f5(v,w,u),f5(u,w,v),f5(v,u,w),f5(w,v,u),#15
 f6(v,w),f6(u,v),f6(w,u),#18
 f10(u,v,w),f10(w,u,v),f10(v,w,u),f10(u,w,v),f10(v,u,w),f10(w,v,u),#24
 f15(u,v,w),f15b(u,v,w),f15(w,u,v),f15(v,u,w),f15b(w,u,v),f15b(v,u,w), #30
 f20a(u,v,w),f20b(u,v,w),f20c(u,v,w),f20c(w,u,v),f20c(v,w,u),f20c(u,w,v),#36
 f20c(v,u,w),f20c(w,v,u),f20d(u,v,w),f20d(w,u,v),f20d(v,w,u),f20d(u,w,v),#42
 f20d(v,u,w),f20d(w,v,u),f20a(v,u,w),f20a(w,u,v),f20b(w,u,v),f20b(v,u,w),#48
 f24(u,v,w),f24(w,u,v),f24(v,u,w),f30a(u,v,w),f30b(u,v,w),f30b(w,u,v),#54
 f30b(v,w,u),f30b(u,w,v),f30b(v,u,w),f30b(w,v,u),f30a(w,u,v),#59
 f30a(v,u,w),f36(u,v,w,E(3)),f36(w,u,v,E(3)),f36(v,u,w,E(3)),f36(u,v,w,E(3)^2),#64
 f36(v,u,w,E(3)^2),f36(w,u,v,E(3)^2),f40(u,v,w),f40(w,u,v),f40(v,w,u),#69
 f40(u,w,v),f40(v,u,w),f40(w,v,u),f45(u,v,w,E(3)),f45(u,w,v,E(3)),#74
 f45(v,w,u,E(3)),f45(u,w,v,E(3)^2),f45(u,v,w,E(3)^2),f45(v,w,u,E(3)^2),#78
 f60a(u,v,w),f60b(u,v,w),f60c(u,v,w),f60c(w,u,v),f60c(v,w,u),f60c(u,w,v),#84
 f60c(v,u,w),f60c(w,v,u),f60a(v,u,w),f60a(w,u,v),f60b(w,u,v),#89
 f60b(v,u,w),f64(u,v,w,GetRoot(v*w)),f64(u,v,w,-GetRoot(v*w)),#92
 f64(w,u,v,GetRoot(u*v)),f64(v,u,w,GetRoot(u*w)),f64(v,u,w,-GetRoot(u*w)),#95
 f64(w,u,v,-GetRoot(u*v)),f80(u,v,w),#97
 f80(v,u,w),f80(w,u,v),#99
 f81(u,v,w,GetRoot(u*v*w,3)),
 f81(u,v,w,E(3)^2*GetRoot(u*v*w,3)),f81(u,v,w,E(3)*GetRoot(u*v*w,3))];
  res := CHEVIE.compat.MakeCharacterTable(res);
  return res;
end);

CHEVIE.AddData("CharTable","G32",function()local res;
  res:=CHEVIE.RawData("HeckeCharTable","G32")([[1,E(3),E(3)^2]],[]);
  res.identifier:="G32"; res.name:="G32";
  res.irreducibles{[31..102]}{[41,58]}:=[[0,0],[1,1],[0,0],[0,0],[0,0],[0,0],
  [0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[E(3),E(3)^2],
  [E(3)^2,E(3)],[0,0],[0,0],[0,0],[-1,-1],[-1,-1],[-E(3),-E(3)^2],[-E(3)^2,-E(3)],
  [-1,-1],[-E(3)^2,-E(3)],[-E(3),-E(3)^2],[-E(3),-E(3)^2],[-E(3)^2,-E(3)],[0,0],
  [0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],
  [0,0],[0,0],[0,0],[0,0],[0,0],[1,1],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],
  [0,0],[E(3),E(3)^2],[E(3)^2,E(3)],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],[0,0],
  [0,0],[0,0],[0,0],[0,0],[0,0]];
  res.galomorphisms:=Group((2,3)(4,7)(5,8)(6,9)(10,13)(11,14)(12,15)(17,18)
    (19,22)(20,23)(21,24)(27,28)(29,30)(33,36)(34,37)(35,38)(39,42)(40,43)
    (41,44)(45,46)(47,48)(50,51)(53,56)(54,57)(55,58)(59,60)(61,64)(62,65)
    (63,66)(67,70)(68,71)(69,72)(73,76)(74,77)(75,78)(81,84)(82,85)(83,86)
    (87,88)(89,90)(93,94)(95,96)(98,99)(101,102));
  return CHEVIE.compat.MakeCharacterTable(res);
end);

# The data below was computed by Maria Chlouveraki
CHEVIE.AddData("SchurModels","G32",rec(
f1_0:=rec(
 vcyc:=[[[1,-1,0],1],[[1,-1,0],1],[[1,0,-1],1],[[1,0,-1],1],[[3,-2,-1],1],
[[3,-1,-2],1],[[5,-2,-3],1],[[5,-3,-2],1],[[4,-3,-1],2],[[4,-1,-3],2],
[[2,-1,-1],2],[[2,-1,-1],2],[[1,-1,0],6],[[1,0,-1],6],[[3,-2,-1],6],[[3,
-1,-2],6],[[2,-1,-1],6],[[2,-1,-1],4],[[1,-1,0],4],[[1,0,-1],4],[[2,-1,
-1],3],[[1,-1,0],10],[[1,0,-1],10],[[2,-1,-1],5]]),
f4_1:=rec(
 vcyc:=[[[4,-1,-3],1],[[3,-1,-2],1],[[3,-2,-1],1],[[2,1,-3],1],[[-1,1,0],
1],[[0,1,-1],1],[[1,0,-1],1],[[1,0,-1],1],[[5,-1,-4],2],[[3,1,-4],2],
[[3,-1,-2],2],[[2,-1,-1],2],[[1,0,-1],2],[[1,1,-2],2],[[1,0,-1],6],[[1,
-1,0],6],[[1,0,-1],4],[[2,-1,-1],3],[[1,-1,0],10],[[1,0,-1],15]]),
f5_4:=rec(
 vcyc:=[[[3,2,-5],1],[[2,1,-3],1],[[1,0,-1],1],[[1,0,-1],1],[[-1,1,0],1],
[[-1,1,0],1],[[0,1,-1],1],[[0,1,-1],1],[[3,-1,-2],2],[[1,2,-3],2],[[0,1,
-1],2],[[2,-1,-1],2],[[1,1,-2],2],[[4,1,-5],2],[[1,0,-1],2],[[1,0,-1],
2],[[1,0,-1],6],[[1,0,-1],6],[[1,-1,0],6],[[1,-1,0],4],[[1,1,-2],3],[[1,
0,-1],12]]),
f6_8:=rec(factor:=[2,-2,0],
 vcyc:=[[[-1,1,0],1],[[1,-1,0],1],[[0,1,-1],1],[[1,0,-1],1],[[0,1,-1],1],
[[1,0,-1],1],[[2,1,-3],1],[[1,2,-3],1],[[2,1,-3],2],[[1,2,-3],2],[[-1,2,
-1],2],[[2,-1,-1],2],[[1,1,-2],2],[[1,1,-2],2],[[1,0,-1],2],[[0,1,-1],
2],[[1,1,-2],6],[[0,1,-1],6],[[1,0,-1],6],[[-1,1,0],10],[[1,1,-2],5]]),
f10_2:=rec(
 vcyc:=[[[2,1,-3],1],[[3,-1,-2],1],[[0,1,-1],1],[[0,1,-1],1],[[-1,1,0],
1],[[-1,0,1],1],[[1,0,-1],1],[[1,0,-1],1],[[4,-3,-1],2],[[3,-1,-2],2],
[[1,1,-2],2],[[1,-2,1],2],[[1,0,-1],2],[[1,0,-1],2],[[0,1,-1],2],[[2,-1,
-1],2],[[2,1,-3],6],[[1,0,-1],6],[[1,-1,0],6],[[1,0,-1],4],[[2,-1,-1],3]]),
f15_6:=rec(
 vcyc:=[[[3,-2,-1],1],[[3,-1,-2],1],[[1,0,-1],1],[[1,0,-1],1],[[0,1,-1],
1],[[0,1,-1],1],[[-1,1,0],1],[[1,-1,0],1],[[3,1,-4],2],[[3,-4,1],2],
[[-1,-1,2],2],[[1,-2,1],2],[[1,-1,0],2],[[1,0,-1],2],[[2,-1,-1],2],[[2,
-1,-1],2],[[2,-1,-1],6],[[1,0,-1],6],[[1,-1,0],6],[[2,-1,-1],4]]),
f15_8:=rec(
 vcyc:=[[[2,-3,1],1],[[-3,2,1],1],[[0,1,-1],1],[[0,1,-1],1],[[1,0,-1],
1],[[1,0,-1],1],[[1,-1,0],1],[[-1,1,0],1],[[1,-2,1],2],[[-2,1,1],2],[[1,
1,-2],2],[[1,1,-2],2],[[1,0,-1],2],[[1,0,-1],2],[[0,1,-1],2],[[0,1,-1],
2],[[0,1,-1],6],[[1,0,-1],6],[[1,1,-2],4]]),
f20_3:=rec(
 vcyc:=[[[2,-3,1],1],[[1,-1,0],1],[[1,-1,0],1],[[-1,0,1],1],[[1,0,-1],
1],[[4,-1,-3],1],[[3,-1,-2],1],[[0,1,-1],1],[[1,2,-3],2],[[-1,2,-1],2],
[[2,-1,-1],2],[[1,1,-2],2],[[1,0,-1],2],[[-1,0,1],2],[[3,-2,-1],6],[[1,
0,-1],6],[[1,0,-1],4],[[1,1,-2],3]]),
f20_5:=rec(coeff:=-1,
 vcyc:=[[[3,-2,-1],1],[[-2,3,-1],1],[[2,1,-3],1],[[1,2,-3],1],[[-1,0,1],
1],[[-1,0,1],1],[[0,1,-1],1],[[0,1,-1],1],[[3,-1,-2],2],[[-1,3,-2],2],
[[1,1,-2],2],[[1,1,-2],2],[[1,1,-2],6],[[1,-1,0],6],[[1,0,-1],6],[[0,1,
-1],6],[[1,1,-2],3]]),
f20_7:=rec(
 vcyc:=[[[3,1,-4],1],[[1,2,-3],1],[[-1,1,0],1],[[-1,1,0],1],[[-1,0,1],
1],[[1,0,-1],1],[[0,1,-1],1],[[0,1,-1],1],[[1,0,-1],2],[[-1,0,1],2],[[3,
-4,1],2],[[1,2,-3],2],[[1,1,-2],2],[[-1,2,-1],2],[[1,0,-1],6],[[1,0,-1],
6],[[0,1,-1],6],[[2,-1,-1],3]]),
f20_12:=rec(coeff:=2,
 vcyc:=[[[0,1,-1],1],[[0,-1,1],1],[[-1,1,0],1],[[-1,0,1],1],[[-1,1,0],
1],[[-1,0,1],1],[[1,-1,0],1],[[1,0,-1],1],[[1,-3,2],2],[[1,2,-3],2],[[2,
-1,-1],2],[[-2,1,1],2],[[1,0,-1],2],[[1,-1,0],2],[[1,0,-1],2],[[1,-1,0],
2],[[0,1,-1],6],[[0,-1,1],6],[[2,-1,-1],3]]),
f24_6:=rec(
 vcyc:=[[[-2,-1,3],1],[[-2,3,-1],1],[[1,0,-1],1],[[1,-1,0],1],[[1,0,-1],
1],[[1,-1,0],1],[[0,1,-1],1],[[0,-1,1],1],[[1,0,-1],2],[[1,-1,0],2],[[1,
1,-2],2],[[1,-2,1],2],[[1,0,-1],6],[[1,-1,0],6],[[1,0,-1],4],[[1,-1,0],
4],[[2,-1,-1],5]]),
f30_4:=rec(
 vcyc:=[[[5,-3,-2],1],[[1,0,-1],1],[[-1,1,0],1],[[-1,1,0],1],[[0,1,-1],
1],[[0,1,-1],1],[[1,0,-1],1],[[1,0,-1],1],[[-1,1,0],2],[[0,1,-1],2],
[[-1,0,1],2],[[5,-1,-4],2],[[1,-3,2],2],[[1,0,-1],2],[[1,-2,1],2],[[2,
-1,-1],2],[[1,-1,0],6],[[0,1,-1],6],[[1,0,-1],6],[[1,0,-1],4]]),
f30_12p:=rec(
 vcyc:=[[[2,-3,1],1],[[2,1,-3],1],[[-1,1,0],1],[[-1,1,0],1],[[1,-1,0],
1],[[-1,0,1],1],[[-1,0,1],1],[[1,0,-1],1],[[0,1,-1],2],[[0,-1,1],2],
[[-1,2,-1],2],[[-1,-1,2],2],[[1,0,-1],2],[[1,0,-1],2],[[1,-1,0],2],[[1,
-1,0],2],[[0,1,-1],6],[[0,-1,1],6],[[1,-1,0],6],[[1,0,-1],6]]),
f36_5:=rec(rootUnity:=E(3),
 vcyc:=[[[0,0,0,-1],1],[[1,-1,0],1],[[-1,0,1],1],[[2,-1,-1,1],1],[[1,1,
-2,2],1],[[-1,2,-1,-2],1],[[-2,1,1],2],[[2,1,-3,-1],2],[[2,-3,1,2],2],
[[2,-1,-1],6],[[1,0,-1],6],[[1,-1,0],6],[[0,-1,1],6],[[1,-1,0,1],5],[[1,
0,-1,1],5]]),
f40_8:=rec(
 vcyc:=[[[3,2,-5],1],[[-1,1,0],1],[[1,-1,0],1],[[1,0,-1],1],[[-1,0,1],
1],[[1,0,-1],1],[[-3,2,1],1],[[0,-1,1],1],[[1,-1,0],2],[[1,1,-2],2],[[2,
-1,-1],2],[[1,0,-1],2],[[1,-1,0],6],[[0,1,-1],6],[[1,-1,0],4],[[1,0,-1],
4],[[1,-2,1],3]]),
f45_6:=rec(rootUnity:=E(3),
 vcyc:=[[[0,0,0,1],1],[[-1,2,-1,2],1],[[-2,1,1,1],1],[[1,1,-2,1],1],[[0,
-1,1],1],[[1,0,-1],1],[[-3,2,1,2],2],[[2,-3,1,2],2],[[0,1,-1,-2],2],[[1,
0,-1,1],2],[[1,1,-2],2],[[1,-1,0],6],[[1,0,-1],6],[[0,1,-1],6],[[1,1,
-2],6],[[0,1,-1,1],4],[[1,0,-1,1],4]]),
f60_7:=rec(
 vcyc:=[[[1,2,-3],1],[[1,-1,0],1],[[1,-1,0],1],[[0,1,-1],1],[[0,1,-1],
1],[[1,0,-1],1],[[1,0,-1],1],[[-3,1,2],1],[[1,-1,0],2],[[4,1,-5],2],
[[-1,2,-1],2],[[-2,1,1],2],[[0,1,-1],2],[[0,1,-1],2],[[1,-1,0],6],[[0,
-1,1],6],[[1,-1,0],4]]),
f60_11s:=rec(
 vcyc:=[[[1,-4,3],1],[[-1,1,0],1],[[-1,1,0],1],[[1,0,-1],1],[[1,0,-1],
1],[[0,-1,1],1],[[0,-1,1],1],[[-4,1,3],1],[[2,-1,-1],2],[[1,1,-2],2],
[[1,1,-2],2],[[-1,2,-1],2],[[-1,1,0],2],[[-1,1,0],2],[[1,1,-2],6],[[1,
-1,0],6]]),
f60_12:=rec(coeff:=2,
 vcyc:=[[[1,2,-3],1],[[1,-3,2],1],[[-1,0,1],1],[[-1,0,1],1],[[-1,0,1],
1],[[-1,1,0],1],[[-1,1,0],1],[[-1,1,0],1],[[0,1,-1],2],[[0,-1,1],2],[[2,
-1,-1],2],[[2,-1,-1],2],[[2,-1,-1],6],[[0,-1,1],6],[[0,1,-1],6],[[1,0,
-1],4],[[1,-1,0],4]]),
f64_8:=rec(coeff:=2,root:=[1,1,0]/2,
 vcyc:=[[[1,0,-2,1],1],[[0,-1,2,-1],1],[[0,1,-1],1],[[-1,0,1],1],[[-1,1,
0],1],[[1,-1,0],1],[[-1,3,-2],1],[[-3,1,2],1],[[-2,2,-1,1],2],[[2,-2,-1,
1],2],[[1,1,-2],3],[[0,0,-1,1],10],[[0,-1,0,1],15]]),
f80_9:=rec(coeff:=2,
 vcyc:=[[[1,2,-3],1],[[1,-3,2],1],[[1,0,-1],1],[[1,0,-1],1],[[-1,1,0],
1],[[-1,1,0],1],[[0,1,-1],1],[[0,1,-1],1],[[1,-1,0],2],[[1,0,-1],2],
[[-2,1,1],4],[[1,0,-1],4],[[1,-1,0],4],[[2,-1,-1],3],[[0,-1,1],12]]),
f81_10:=rec(coeff:=3,root:=[1,1,1]/3,
 vcyc:=[[[-2,0,1,1],2],[[0,-2,1,1],2],[[1,0,-2,1],2],[[1,-2,0,1],2],
[[-2,1,0,1],2],[[0,1,-2,1],2],[[1,1,-2],2],[[1,-2,1],2],[[-2,1,1],2],
[[0,0,-1,1],2],[[-1,0,0,1],2],[[0,-1,0,1],2],[[-1,-1,0,2],4],[[-1,0,-1,
2],4],[[0,-1,-1,2],4],[[-1,0,0,1],5],[[0,0,-1,1],5],[[0,-1,0,1],5]])));

CHEVIE.AddData("SchurData","G32",[
  rec(name:="f1_0",order:=[1,3,2]), rec(name:="f1_0",order:=[3,2,1]), 
  rec(name:="f1_0",order:=[2,1,3]), 
  rec(name:="f4_1",order:=[3,2,1]), rec(name:="f4_1",order:=[2,1,3]), 
  rec(name:="f4_1",order:=[1,3,2]), rec(name:="f4_1",order:=[2,3,1]), 
  rec(name:="f4_1",order:=[3,1,2]), rec(name:="f4_1",order:=[1,2,3]), #9
  rec(name:="f5_4",order:=[3,1,2]), rec(name:="f5_4",order:=[2,3,1]), 
  rec(name:="f5_4",order:=[1,2,3]), rec(name:="f5_4",order:=[2,1,3]), 
  rec(name:="f5_4",order:=[3,2,1]), rec(name:="f5_4",order:=[1,3,2]),
  rec(name:="f6_8",order:=[3,2,1]), rec(name:="f6_8",order:=[2,1,3]), 
  rec(name:="f6_8",order:=[1,3,2]),
  rec(name:="f10_2",order:=[2,3,1]), rec(name:="f10_2",order:=[1,2,3]), 
  rec(name:="f10_2",order:=[3,1,2]), rec(name:="f10_2",order:=[3,2,1]),
  rec(name:="f10_2",order:=[1,3,2]), rec(name:="f10_2",order:=[2,1,3]),
  rec(name:="f15_8",order:=[3,2,1]), rec(name:="f15_6",order:=[1,3,2]), # 26
  rec(name:="f15_8",order:=[2,1,3]), rec(name:="f15_8",order:=[1,3,2]),
  rec(name:="f15_6",order:=[3,2,1]), rec(name:="f15_6",order:=[2,1,3]), #30
  rec(name:="f20_5",order:=[3,2,1]), rec(name:="f20_12",order:=[1,3,2]),
  rec(name:="f20_3",order:=[2,1,3]), rec(name:="f20_3",order:=[1,3,2]), 
  rec(name:="f20_3",order:=[3,2,1]), rec(name:="f20_3",order:=[3,1,2]), 
  rec(name:="f20_3",order:=[1,2,3]), rec(name:="f20_3",order:=[2,3,1]),
  rec(name:="f20_7",order:=[3,2,1]), rec(name:="f20_7",order:=[2,1,3]), 
  rec(name:="f20_7",order:=[1,3,2]), rec(name:="f20_7",order:=[2,3,1]), 
  rec(name:="f20_7",order:=[3,1,2]), rec(name:="f20_7",order:=[1,2,3]), #44
  rec(name:="f20_5",order:=[1,3,2]), rec(name:="f20_5",order:=[2,1,3]), #46
  rec(name:="f20_12",order:=[3,2,1]), rec(name:="f20_12",order:=[2,1,3]),
  rec(name:="f24_6",order:=[1,3,2]), rec(name:="f24_6",order:=[3,2,1]),
  rec(name:="f24_6",order:=[2,1,3]), rec(name:="f30_12p",order:=[1,3,2]),
  rec(name:="f30_4",order:=[2,1,3]), rec(name:="f30_4",order:=[1,3,2]),
  rec(name:="f30_4",order:=[3,2,1]), rec(name:="f30_4",order:=[3,1,2]),
  rec(name:="f30_4",order:=[1,2,3]), rec(name:="f30_4",order:=[2,3,1]),
  rec(name:="f30_12p",order:=[3,2,1]), rec(name:="f30_12p",order:=[2,1,3]), #60
  rec(name:="f36_5",order:=[1,3,2],rootUnityPower:=2), 
  rec(name:="f36_5",order:=[3,2,1],rootUnityPower:=2),
  rec(name:="f36_5",order:=[2,1,3],rootUnityPower:=2),
  rec(name:="f36_5",order:=[1,3,2],rootUnityPower:=1), 
  rec(name:="f36_5",order:=[2,1,3],rootUnityPower:=1),
  rec(name:="f36_5",order:=[3,2,1],rootUnityPower:=1),
  rec(name:="f40_8",order:=[3,2,1]), rec(name:="f40_8",order:=[2,1,3]),
  rec(name:="f40_8",order:=[1,3,2]), rec(name:="f40_8",order:=[2,3,1]),
  rec(name:="f40_8",order:=[3,1,2]), rec(name:="f40_8",order:=[1,2,3]), #72
  rec(name:="f45_6",order:=[2,1,3],rootUnityPower:=1), 
  rec(name:="f45_6",order:=[1,3,2],rootUnityPower:=1),
  rec(name:="f45_6",order:=[3,2,1],rootUnityPower:=1), 
  rec(name:="f45_6",order:=[1,3,2],rootUnityPower:=2), 
  rec(name:="f45_6",order:=[2,1,3],rootUnityPower:=2),
  rec(name:="f45_6",order:=[3,2,1],rootUnityPower:=2),
  rec(name:="f60_11s",order:=[3,2,1]), rec(name:="f60_12",order:=[1,3,2]),
  rec(name:="f60_7",order:=[1,2,3]), rec(name:="f60_7",order:=[3,1,2]),
  rec(name:="f60_7",order:=[2,3,1]), rec(name:="f60_7",order:=[1,3,2]),
  rec(name:="f60_7",order:=[2,1,3]), rec(name:="f60_7",order:=[3,2,1]),
  rec(name:="f60_11s",order:=[1,3,2]), rec(name:="f60_11s",order:=[2,1,3]), # 88
  rec(name:="f60_12",order:=[3,2,1]), rec(name:="f60_12",order:=[2,1,3]),
  rec(name:="f64_8",order:=[3,2,1],rootPower:=-1), 
  rec(name:="f64_8",order:=[3,2,1],rootPower:=1), # 92
  rec(name:="f64_8",order:=[2,1,3],rootPower:=-1), 
  rec(name:="f64_8",order:=[1,3,2],rootPower:=-1),
  rec(name:="f64_8",order:=[1,3,2],rootPower:=1), 
  rec(name:="f64_8",order:=[2,1,3],rootPower:=1), # 96
  rec(name:="f80_9",order:=[1,3,2]), rec(name:="f80_9",order:=[2,1,3]),
  rec(name:="f80_9",order:=[3,2,1]), # 99
  rec(name:="f81_10",order:=[1,2,3],rootPower:=1), 
  rec(name:="f81_10",order:=[1,2,3],rootPower:=E(3)^2),
  rec(name:="f81_10",order:=[1,2,3],rootPower:=E(3))]);

# CHEVIE.G32.f36_7 is complex conjugate of phi36_5.
# CHEVIE.G32.f45_10 is complex conjugate of phi45_6.

CHEVIE.AddData("factors","G32",
[[1,0],[1,80],[1,40],[1,61,1,67,1,73,1,79],[1,21,1,27,1,33,1,39],[1,11,1,17,1,
23,1,29],[1,41,1,47,1,53,1,59],[1,51,1,57,1,63,1,69],[1,1,1,7,1,13,1,19],[1,
36,1,42,1,48,1,54,1,60],[1,44,1,50,1,56,1,62,1,68],[1,4,1,10,1,16,1,22,1,28],
[1,12,1,18,1,24,1,30,1,36],[1,52,1,58,1,64,1,70,1,76],[1,20,1,26,1,32,1,38,1,
44],[1,48,1,54,2,60,1,66,1,72],[1,8,1,14,2,20,1,26,1,32],[1,28,1,34,2,40,1,46,
1,52],[1,30,1,36,2,42,2,48,2,54,1,60,1,66],[1,2,1,8,2,14,2,20,2,26,1,32,1,38],
[1,34,1,40,2,46,2,52,2,58,1,64,1,70],[1,42,1,48,2,54,2,60,2,66,1,72,1,78],[1,
10,1,16,2,22,2,28,2,34,1,40,1,46],[1,14,1,20,2,26,2,32,2,38,1,44,1,50],[1,24,
1,30,2,36,2,42,3,48,2,54,2,60,1,66,1,72],[1,6,2,12,3,18,3,24,3,30,2,36,1,42],
[1,8,1,14,2,20,2,26,3,32,2,38,2,44,1,50,1,56],[1,16,1,22,2,28,2,34,3,40,2,46,
2,52,1,58,1,64],[1,38,2,44,3,50,3,56,3,62,2,68,1,74],[1,22,2,28,3,34,3,40,3,
46,2,52,1,58],[1,33,2,39,3,45,4,51,4,57,3,63,2,69,1,75],[1,12,1,18,3,24,3,30,
4,36,3,42,3,48,1,54,1,60],[1,13,2,19,3,25,4,31,4,37,3,43,2,49,1,55],[1,9,2,15,
3,21,4,27,4,33,3,39,2,45,1,51],[1,35,2,41,3,47,4,53,4,59,3,65,2,71,1,77],[1,
29,2,35,3,41,4,47,4,53,3,59,2,65,1,71],[1,3,2,9,3,15,4,21,4,27,3,33,2,39,1,
45],[1,25,2,31,3,37,4,43,4,49,3,55,2,61,1,67],[1,31,2,37,3,43,4,49,4,55,3,61,
2,67,1,73],[1,9,2,15,3,21,4,27,4,33,3,39,2,45,1,51],[1,17,2,23,3,29,4,35,4,41,
3,47,2,53,1,59],[1,29,2,35,3,41,4,47,4,53,3,59,2,65,1,71],[1,21,2,27,3,33,4,
39,4,45,3,51,2,57,1,63],[1,7,2,13,3,19,4,25,4,31,3,37,2,43,1,49],[1,19,2,25,3,
31,4,37,4,43,3,49,2,55,1,61],[1,5,2,11,3,17,4,23,4,29,3,35,2,41,1,47],[1,20,1,
26,3,32,3,38,4,44,3,50,3,56,1,62,1,68],[1,16,1,22,3,28,3,34,4,40,3,46,3,52,1,
58,1,64],[1,6,2,12,3,18,4,24,4,30,4,36,3,42,2,48,1,54],[1,26,2,32,3,38,4,44,4,
50,4,56,3,62,2,68,1,74],[1,16,2,22,3,28,4,34,4,40,4,46,3,52,2,58,1,64],[1,12,
2,18,4,24,5,30,6,36,5,42,4,48,2,54,1,60],[1,12,2,18,4,24,5,30,6,36,5,42,4,48,
2,54,1,60],[1,8,2,14,4,20,5,26,6,32,5,38,4,44,2,50,1,56],[1,28,2,34,4,40,5,46,
6,52,5,58,4,64,2,70,1,76],[1,24,2,30,4,36,5,42,6,48,5,54,4,60,2,66,1,72],[1,4,
2,10,4,16,5,22,6,28,5,34,4,40,2,46,1,52],[1,20,2,26,4,32,5,38,6,44,5,50,4,56,
2,62,1,68],[1,20,2,26,4,32,5,38,6,44,5,50,4,56,2,62,1,68],[1,16,2,22,4,28,5,
34,6,40,5,46,4,52,2,58,1,64],[1,7,3,13,5,19,7,25,7,31,6,37,4,43,2,49,1,55],[1,
27,3,33,5,39,7,45,7,51,6,57,4,63,2,69,1,75],[1,17,3,23,5,29,7,35,7,41,6,47,4,
53,2,59,1,65],[1,5,2,11,4,17,6,23,7,29,7,35,5,41,3,47,1,53],[1,15,2,21,4,27,6,
33,7,39,7,45,5,51,3,57,1,63],[1,25,2,31,4,37,6,43,7,49,7,55,5,61,3,67,1,73],
[1,24,3,30,5,36,7,42,8,48,7,54,5,60,3,66,1,72],[1,14,3,20,5,26,7,32,8,38,7,44,
5,50,3,56,1,62],[1,10,3,16,5,22,7,28,8,34,7,40,5,46,3,52,1,58],[1,18,3,24,5,
30,7,36,8,42,7,48,5,54,3,60,1,66],[1,22,3,28,5,34,7,40,8,46,7,52,5,58,3,64,1,
70],[1,8,3,14,5,20,7,26,8,32,7,38,5,44,3,50,1,56],[1,6,2,12,5,18,7,24,9,30,8,
36,7,42,4,48,2,54],[1,14,2,20,5,26,7,32,9,38,8,44,7,50,4,56,2,62],[1,22,2,28,
5,34,7,40,9,46,8,52,7,58,4,64,2,70],[2,18,4,24,7,30,8,36,9,42,7,48,5,54,2,60,
1,66],[2,10,4,16,7,22,8,28,9,34,7,40,5,46,2,52,1,58],[2,26,4,32,7,38,8,44,9,
50,7,56,5,62,2,68,1,74],[1,15,3,21,6,27,9,33,11,39,11,45,9,51,6,57,3,63,1,69],
[2,12,4,18,8,24,10,30,12,36,10,42,8,48,4,54,2,60],[1,7,3,13,6,19,9,25,11,31,
11,37,9,43,6,49,3,55,1,61],[1,15,3,21,6,27,9,33,11,39,11,45,9,51,6,57,3,63,1,
69],[1,17,3,23,6,29,9,35,11,41,11,47,9,53,6,59,3,65,1,71],[1,11,3,17,6,23,9,
29,11,35,11,41,9,47,6,53,3,59,1,65],[1,9,3,15,6,21,9,27,11,33,11,39,9,45,6,51,
3,57,1,63],[1,19,3,25,6,31,9,37,11,43,11,49,9,55,6,61,3,67,1,73],[1,13,3,19,6,
25,9,31,11,37,11,43,9,49,6,55,3,61,1,67],[1,11,3,17,6,23,9,29,11,35,11,41,9,
47,6,53,3,59,1,65],[2,20,4,26,8,32,10,38,12,44,10,50,8,56,4,62,2,68],[2,16,4,
22,8,28,10,34,12,40,10,46,8,52,4,58,2,64],[1,18,3,24,6,30,10,36,12,42,12,48,
10,54,6,60,3,66,1,72],[2,21,5,27,8,33,11,39,12,45,11,51,8,57,5,63,2,69],[1,8,
3,14,6,20,10,26,12,32,12,38,10,44,6,50,3,56,1,62],[2,16,5,22,8,28,11,34,12,40,
11,46,8,52,5,58,2,64],[1,13,3,19,6,25,10,31,12,37,12,43,10,49,6,55,3,61,1,67],
[2,11,5,17,8,23,11,29,12,35,11,41,8,47,5,53,2,59],[1,9,4,15,8,21,12,27,15,33,
15,39,12,45,8,51,4,57,1,63],[1,13,4,19,8,25,12,31,15,37,15,43,12,49,8,55,4,61,
1,67],[1,17,4,23,8,29,12,35,15,41,15,47,12,53,8,59,4,65,1,71],[1,12,4,18,7,24,
12,30,14,36,15,42,12,48,9,54,5,60,2,66],[2,14,5,20,9,26,12,32,15,38,14,44,12,
50,7,56,4,62,1,68],[1,10,2,16,6,22,10,28,14,34,15,40,14,46,10,52,6,58,2,64,1,
70]]);

CHEVIE.AddData("HeckeRepresentation","G32",function(para,root,i)
  local u,v,w,f1,f4,f5,f6,f10,f15a,f15b,rep;
  u:=para[1][1];v:=para[1][2];w:=para[1][3];
  f1:=u->[[[u]],[[u]],[[u]],[[u]]];
  f4:=function(w,v)return WGraph2Representation([[[1],[2],[3],[4]],
   [[1,2,w,-v],[2,3,w,-v],[3,4,w,-v]]],[w,v]);end;
  f5:=function(u,w,v)return u^0*v^0*w^0*WGraph2Representation(
    [[[1,3],[1,4],[2],[2,4],[3]],
    [[1,2,u,-w],[1,3,u,-w],[1,5,u,0],[2,4,u,-w],[3,4,0,-w],[4,5,-w,u]]],[u,w]);
  end;
  f6:=function(v,w)return List(f4(v,w)+0*v*w,x->ExteriorPower(x,2)/w);end;
  f10:=function(u,w,v)return
   WGraph2Representation([[[[2],[]],[[],[1,2]],[[1],[]],[[],[2,3]],[[3],[]],
    [[],[1,3]],[[],[2,4]],[[],[1,4]],[[],[3,4]],[[4],[]]],
    [[1,2,-1,u*v+w^2],[1,3,w,w],[1,4,1,-u*v-w^2],[1,5,w,w],[1,6,v,0],
    [2,3,-u*v-w^2,1],[2,6,-v*w,1],[4,5,u*v+w^2,-1],[4,6,v*w,-1],[4,7,-v*w,1],
    [5,7,v,0],[5,9,-1,u*v+w^2],[5,10,-w,-w],[6,8,v,-w],[7,8,-v,w],[7,9,1,-v*w],
    [9,10,u*v+w^2,-1]]],[u,w,v]);end;
   f15a:=function(v,u,w)return WGraph2Representation([[[[2,3],[]],[[3],[1,2]],
   [[1,3],[]],[[2],[1,3,4]],[[1],[2,3,4]],[[1,2,4],[]],
[[2],[3,4]],[[3],[1,2,4]],[[1,3],[4]],[[2,4],[1]],[[1,4],[2,3]],[[],[1,2,3,
4]],[[2,4],[]],[[4],[1,2,3]],[[1,3,4],[]]],[[1,2,-v,v^-1*w^2+u],[1,3,w,w],[1,
7,v,-v^-1*w^2-u],[1,13,w,w],[2,3,-v^-1*w^2-u,v],[2,4,v,[2,-w,4,-u]],[2,8,0,
-u],[2,10,w,[2,0,4,w]],[2,12,w,-w],[2,14,0,w],[3,4,0,[2,v^-1*w^2+u,4,0]],[3,5,
v,-v^-1*w^2-u],[3,6,w,w],[3,9,0,-v^-1*w^2-u],[3,11,0,[2,0,4,v^-1*w^2+u]],[3,
15,0,w],[4,5,-w,v],[4,7,u,0],[4,10,u,-v],[4,12,w-u*v*w^-1,0],[5,6,v^-1*w^2+u,
-v],[5,7,w,0],[5,11,0,-w],[5,12,w,0],[6,10,v,0],[6,13,w,0],[7,8,-v,[1,u,3,w]],
[7,9,w,[1,w,3,0]],[7,12,-w,w],[7,13,v^-1*w^2+u,-v],[8,9,-u,v],[8,12,
w-u*v*w^-1,0],[8,13,[1,0,3,v^-1*w^2+u],0],[8,14,w,-v],[9,10,[1,0,3,w],[2,w,4,
0]],[9,11,v,[2,-u,4,-w]],[9,12,w,-w],[9,15,0,-v],[10,11,-v,[1,w,3,u]],[10,12,
-w,w],[10,13,v^-1*w^2+u,0],[11,12,w-u*v*w^-1,0],[11,13,[1,v^-1*w^2+u,3,0],0],
[11,14,w,0],[12,14,0,-w],[13,14,-v,v^-1*w^2+u],[13,15,w,w],[14,15,-v^-1*w^2-u,
v]]],[v,w,u]);end;
   f15b:=function(v,w,u)return WGraph2Representation([[[[2],[]],[[],[1,2]],
   [[1],[]],[[2],[]],[[],[2,3]],[[3],[1]],[[3],[]],[[1],
[3]],[[],[3,4]],[[1],[4]],[[4],[1]],[[2],[4]],[[4],[2]],[[3],[]],[[4],[]]],
[[1,2,-1,u*v+w^2],[1,3,w,w],[1,5,-1,u*v+v*w],[1,6,0,[1,0,3,v*w-v^2]],[1,7,1,
v*w],[1,8,1,0],[2,3,-u*v-w^2,1],[2,4,u,0],[2,6,0,v],[2,8,-w,[1,0,3,u]],[3,8,0,
u*v-u*w],[4,5,v-w,w],[4,6,u,[1,0,3,-v]],[4,7,-v+w,w],[4,8,-v,[1,u,3,0]],[4,12,
0,-w],[5,6,-u,[1,w,3,0]],[5,7,-w-u*v*w^-1,w],[5,8,0,u],[5,12,u,[2,0,4,-w]],[5,
13,0,w],[5,14,-u*v*w^-1,0],[6,7,v-w,0],[6,11,-v,u],[6,14,v,0],[7,9,-v,u+w],[7,
12,u,0],[7,13,0,[2,0,4,v-w]],[7,15,v,w],[8,10,u,-w],[9,12,0,v],[9,13,u,[2,-w,
4,0]],[9,14,w,v-w],[9,15,-w-u*v*w^-1,w],[10,12,u,-v],[11,13,u,-w],[12,14,[2,v,
4,0],-u],[13,14,[2,0,4,v],-u],[13,15,-v+w,0],[14,15,-v+w,w]]],[v,w,u]);end;
  rep:=[[f1,u],[f1,w],[f1,v],
    [f4,v,w],[f4,u,v],[f4,w,u],[f4,w,v],[f4,u,w],[f4,v,u],
    [f5,u,w,v],[f5,w,v,u],[f5,v,u,w],[f5,u,v,w],[f5,v,w,u],[f5,w,u,v],
    [f6,v,w],[f6,u,v],[f6,w,u],
 [f10,u,w,v],[f10,w,v,u],[f10,v,u,w],[f10,u,v,w],[f10,v,w,u],[f10,w,u,v],
 [f15a,v,u,w],[f15b,v,w,u],[f15a,v,w,u],[f15a,u,v,w],[f15b,u,v,w],[f15b,w,u,v]];
  if IsBound(rep[i]) then
    return ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]})+0*Product(para[1]);
  else return false;fi;
end);

CHEVIE.G32.CachedRepresentations:=[];

CHEVIE.AddData("Representation","G32",function(i)local para,r,f,expand,J;
  J:=E(3);
  r:=CHEVIE.RawData("HeckeRepresentation","G32")
    (List([1..4],i->[1,J,J^2]),[],i);
  if r<>false then return r;fi;
  f:=function(i)InfoChevie("calling rep(",i,")\n");
    if not IsBound(CHEVIE.G32.CachedRepresentations[i]) then
      CHEVIE.G32.CachedRepresentations[i]:=
        CHEVIE.RawData("Representation","G32")(i);
    fi;
    return CHEVIE.G32.CachedRepresentations[i];end;
  expand:=function(l,n)local res;res:=[1..n]*0;
    res{l{[1..Length(l)/2]}}:=l{[Length(l)/2+1..Length(l)]};return res;end;
  if i<80 then
  if i=31 then r:=Zip(f(4),f(15),KroneckerMatrix);
  elif i=32 then r:=List(f(5),x->SchurFunctor(x,[2,2]));
  elif i=33 then r:=J*f(34);
  elif i=34 then r:=List(f(4),x->SymmetricPower(x,3));
  elif i=35 then r:=J^2*f(34);
  elif i=36 then r:=ComplexConjugate(f(33));
  elif i=37 then r:=J*f(36);
  elif i=38 then r:=J^2*f(36);
  elif i=39 then r:=List(f(6),x->SchurFunctor(x,[2,2,1]));
  elif i=40 then r:=J^2*f(39);
  elif i=41 then r:=J*f(39);
  elif i=42 then r:=ComplexConjugate(f(39));
  elif i=43 then r:=J*f(42);
  elif i=44 then r:=J^2*f(42);
  elif i=45 then r:=J*f(31);
  elif i=46 then r:=J^2*f(31);
  elif i=47 then r:=J^2*f(32);
  elif i=48 then r:=J*f(32);
  elif i=49 then r:=List(f(10),x->SchurFunctor(x,[2,1,1,1]));
  elif i=50 then r:=J^2*f(49);
  elif i=52 then r:=List(
[[[2,1],[5,1],[6,1],[7,1],[1,1],[8,-1],[14,1],[3,-1],[15,1],[17,1],[24,1],[8,
10,13,14,16,21,23,25,-1,-1,1,1,1,1,1,-1],[9,1],[4,1],[13,1],[30,-1],[20,1],
[18,1],[21,1],[10,1],[27,1],[12,1],[23,1],[28,1],[3,4,9,17,22,23,27,30,1,1,1,
-1,-1,1,1,-1],[25,1],[19,1],[11,1],[29,1],[6,7,12,15,19,20,23,26,1,1,-1,1,1,
-1,1,-1]],[[3,1],[9,1],[10,1],[11,1],[17,-1],[15,1],[7,1],[2,1],[8,1],[1,1],
[18,1],[19,-1],[5,-1],[4,6,8,9,17,22,25,26,27,29,30,-1,1,-1,-1,1,1,-1,-1,-1,1,
1],[20,-1],[1,2,4,5,7,9,13,14,15,18,19,21,23,27,29,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,-1],[13,1],[4,1],[23,1],[6,-1],[22,-1],[6,7,9,10,11,12,13,16,17,18,19,24,26,
28,29,30,1,1,-1,1,1,-1,-1,-1,1,1,1,1,-1,1,1,1],[12,-1],[14,1],[6,7,10,12,15,
16,17,18,19,26,30,1,1,1,-1,1,-1,1,1,1,-1,1],[26,1],[27,1],[28,1],[30,1],[2,8,
9,26,27,28,29,30,1,1,1,1,1,-1,-1,-1]],[[4,1],[7,1],[3,1],[6,7,12,15,19,20,23,
26,1,1,-1,1,1,-1,1,-1],[14,1],[6,1],[16,-1],[8,1],[3,5,6,7,11,12,20,23,25,26,
29,-1,1,-1,-1,-1,1,1,-1,1,1,-1],[27,1],[10,1],[13,1],[2,8,9,26,27,28,29,30,1,
1,1,1,1,-1,-1,-1],[30,1],[1,3,4,6,9,13,16,17,21,22,23,24,27,29,30,1,1,1,-1,1,
1,1,-1,1,-1,1,-1,1,-1,-1],[2,-1],[19,1],[18,1],[24,1],[21,1],[28,1],[15,1],
[29,1],[17,1],[26,1],[3,4,9,17,22,23,27,30,1,1,1,-1,-1,1,1,-1],[11,1],[20,1],
[4,6,8,9,17,22,25,26,27,29,30,1,-1,1,1,-1,-1,1,1,1,-1,-1],[5,1]],[[6,-1],[8,
1],[15,-1],[12,1],[3,-1],[13,-1],[8,10,13,14,16,21,23,25,-1,-1,1,1,1,1,1,-1],
[9,1],[2,1],[20,1],[19,-1],[5,8,14,18,20,21,28,30,1,-1,1,1,1,1,1,1],[1,1],[22,
1],[5,1],[16,1],[10,1],[23,-1],[25,1],[17,1],[3,4,9,17,22,23,27,30,1,1,1,-1,
-1,1,1,-1],[2,6,7,16,17,18,19,24,1,1,1,-1,1,1,1,1],[6,7,10,12,15,16,17,18,19,
26,30,1,1,1,-1,1,-1,1,1,1,-1,1],[21,-1],[11,-1],[28,-1],[26,1],[27,-1],[29,1],
[30,1]]],x->List(x,y->expand(y,30)));
  elif i=51 then r:=J*f(49);
  elif i=53 then r:=Zip(f(10),f(16),KroneckerMatrix);
  elif i=54 then r:=J^2*f(53);
  elif i=55 then r:=J*f(53);
  elif i=56 then r:=ComplexConjugate(f(53));
  elif i=57 then r:=J*f(56);
  elif i=58 then r:=J^2*f(56);
  elif i=59 then r:=J^2*f(52);
  elif i=60 then r:=J*f(52);
  elif i=61 then r:=List(f(7),x->SchurFunctor(x,[3,1,1]));
  elif i=62 then r:=J^2*f(61);
  elif i=63 then r:=J*f(61);
  elif i=64 then r:=ComplexConjugate(f(61));
  elif i=65 then r:=J*f(64);
  elif i=66 then r:=J^2*f(64);
  elif i=67 then r:=List(f(13),x->SchurFunctor(x,[2,1]));
  elif i=68 then r:=J^2*f(67);
  elif i=69 then r:=J*f(67);
  elif i=70 then r:=ComplexConjugate(f(67));
  elif i=71 then r:=J*f(70);
  elif i=72 then r:=J^2*f(70);
  elif i=73 then r:=List(f(22),x->ExteriorPower(x,2));
  elif i=74 then r:=J^2*f(73);
  elif i=75 then r:=J*f(73);
  elif i=76 then r:=ComplexConjugate(f(73));
  elif i=77 then r:=J*f(76);
  elif i=78 then r:=J^2*f(76);
  elif i=79 then r:=List(f(5),x->SchurFunctor(x,[3,2]));
  fi;
  else
  if i=80 then r:=List(
[[[1,8,11,14,25,57,1,1,1,-1,1,1],[1,14,30,42,51,57,60,-1,1,-1,1,1,1,2],[1,6,
11,14,16,25,30,33,39,52,59,1,-1,1,-1,-1,1,1,-1,1,1,1],[12,29,1,-1],[1,3,14,16,
25,31,33,59,60,1,-1,-1,1,2,-1,-1,-1,-1],[5,11,14,16,25,30,31,39,52,1,1,-1,1,1,
1,1,1,1],[1,7,30,46,51,1,-1,1,-1,-1],[11,14,25,57,-1,1,-2,-1],[1,14,25,30,31,
33,39,49,54,57,59,60,-1,2,-2,-1,1,1,-1,1,-1,1,1,2],[7,11,14,24,33,54,57,59,1,
1,-1,1,1,1,1,1],[1,25,34,59,60,-1,1,-1,-1,1],[12,1],[1,7,10,14,30,31,39,51,52,
54,59,1,-1,-1,-1,1,1,1,-1,1,-1,1],[14,25,1,-1],[59,-1],[16,25,50,59,-1,-1,-1,
1],[14,16,25,31,33,54,56,57,60,1,1,-1,1,1,-1,-1,1,2],[14,52,54,60,1,1,-1,1],
[7,11,33,39,45,57,59,60,1,1,1,-1,1,1,1,1],[54,55,-1,1],[14,25,30,31,33,35,51,
52,54,57,59,60,1,-1,-1,1,1,1,-1,1,-1,1,1,1],[4,12,14,31,52,53,54,60,1,-1,1,1,
1,1,-3,2],[37,1],[7,13,14,33,39,51,54,1,-1,-1,-1,1,1,1],[15,25,59,1,-1,1],[16,
17,30,39,54,-1,-1,1,1,1],[1,7,14,19,30,31,33,51,52,60,1,-1,-1,-1,1,1,1,-2,1,
-1],[21,39,51,54,-1,1,1,1],[22,53,59,-1,1,-1],[14,25,38,51,59,60,1,-1,-1,1,1,
1],[25,31,-1,1],[25,31,33,39,51,1,-1,-1,1,1],[14,30,33,36,39,51,57,1,-1,1,1,
-1,-1,1],[1,11,25,59,60,-1,-1,-1,-1,1],[14,28,33,39,51,54,60,1,-1,-1,1,1,-1,
1],[39,1],[57,58,60,1,-1,1],[14,25,30,51,59,60,1,-1,-1,1,1,1],[31,32,33,51,1,
1,1,-1],[20,31,54,-1,-1,1],[2,11,14,51,57,60,-1,1,1,1,1,2],[1,11,25,30,41,1,1,
1,1,-1],[12,47,53,-1,1,-1],[12,25,43,59,1,-1,1,1],[7,14,27,31,39,52,1,-1,-1,1,
1,1],[7,11,51,57,59,60,1,1,1,1,1,2],[14,25,31,44,52,53,54,60,1,-1,1,1,1,1,-3,
2],[9,11,31,33,54,57,59,-1,1,1,1,1,1,1],[1,11,14,25,30,31,39,48,52,54,59,1,1,
-1,1,1,1,1,-1,1,-1,1],[14,16,25,59,60,-1,1,1,-1,-1],[14,30,57,1,-1,1],[52,1],
[14,25,31,52,53,54,59,60,1,-1,1,1,1,-3,1,2],[18,25,31,54,59,60,1,-1,1,-1,1,1],
[14,25,40,52,54,59,60,1,-1,-1,1,-1,1,2],[14,16,25,26,30,33,39,52,54,57,59,60,
1,-1,-1,1,-1,1,-1,-1,1,1,1,1],[57,1],[23,57,60,-1,1,1],[25,59,-1,1],[60,1]],
[[8,13,14,49,-1,1,1,-1],[6,14,18,19,28,33,37,50,57,58,60,-1,-1,1,1,1,-1,-1,1,
1,1,1],[6,12,13,14,18,20,40,43,49,52,54,55,60,1,1,1,1,-1,1,-1,1,-1,-1,-1,1,
-1],[18,28,30,57,58,60,-1,-1,1,1,-1,1],[11,13,14,18,23,28,30,31,36,37,40,50,
53,54,57,58,1,1,1,-1,1,-2,1,1,-1,1,-1,-1,-1,-1,1,-2],[13,14,31,45,49,1,1,-1,1,
-1],[7,1],[13,14,18,28,37,40,46,49,54,58,-1,-1,1,1,-1,1,-1,1,1,1],[2,13,14,18,
28,31,37,40,50,53,54,57,58,60,-1,-1,-2,1,2,-1,-1,1,1,1,1,1,2,1],[5,7,13,14,18,
20,28,33,36,37,49,53,57,1,-1,1,1,-2,1,1,1,1,1,-1,1,-1],[6,10,18,20,23,28,33,
-1,1,1,-1,-1,-1,-1],[37,57,60,-1,1,1],[6,7,14,31,42,1,1,1,-1,-1],[14,18,28,37,
58,-1,1,1,-1,1],[17,18,20,22,53,54,58,-1,1,-1,1,-1,1,1],[20,23,26,28,36,1,-1,
-1,1,1],[12,14,17,18,20,28,29,31,37,40,50,54,57,58,60,-1,-1,-1,2,-1,1,1,-1,-1,
1,1,2,1,2,1],[14,18,37,51,57,58,-1,1,-1,-1,1,1],[7,9,13,18,20,28,33,49,50,52,
53,55,58,-1,-1,1,-1,1,1,1,-1,1,-1,1,1,1],[20,1],[14,28,31,37,40,50,53,57,58,
60,-1,1,-1,-1,1,1,1,1,1,1],[14,17,18,28,31,32,33,37,40,50,54,57,58,-1,-1,3,1,
-1,-1,-1,-1,1,1,1,1,2],[23,1],[7,13,14,40,44,52,53,55,-1,1,1,-1,-1,-1,-1,1],
[16,20,28,-1,1,1],[23,25,36,-1,1,1],[6,7,14,17,18,20,31,33,34,53,1,1,1,-1,-1,
-1,-1,1,1,1],[28,1],[17,18,20,54,58,-1,1,-1,1,1],[14,18,28,37,40,50,54,58,-1,
1,1,-1,1,1,1,1],[18,20,28,30,31,37,54,58,1,-1,1,-1,-1,-1,1,1],[15,17,20,28,31,
33,40,50,53,54,57,58,-1,1,1,-1,1,-1,-1,-1,-1,-1,1,-1],[14,18,21,33,53,57,60,
-1,-1,-1,1,1,1,1],[12,13,17,18,20,47,49,53,54,58,-1,-1,-1,1,-1,1,1,-1,1,1],
[14,18,33,37,53,54,57,58,-1,2,-1,-1,-1,1,1,1],[36,1],[12,57,60,-1,1,1],[14,20,
28,30,50,57,60,-1,1,1,1,1,1,1],[20,31,40,53,55,59,60,-1,-1,1,1,-1,1,1],[18,20,
31,40,52,54,55,-1,1,1,-1,-1,-1,1],[3,14,18,28,37,49,50,54,58,1,-1,1,1,-1,-1,1,
1,2],[13,49,1,-1],[30,41,57,60,-1,1,-1,-1],[6,18,30,33,48,1,-1,1,1,-1],[7,13,
14,20,31,-1,1,1,-1,-1],[1,7,13,20,28,37,49,50,52,55,58,1,-1,1,1,1,-1,-1,1,-1,
1,1],[13,14,17,18,27,28,31,33,37,40,50,54,57,58,-1,-1,-1,3,1,1,-1,-1,-2,1,1,2,
1,3],[13,18,24,28,31,33,49,50,53,60,1,-1,1,1,-1,1,-1,1,1,1],[6,13,14,31,49,1,
1,1,-1,-1],[4,12,14,20,28,37,50,52,55,58,1,-1,1,-1,-1,1,-1,1,-1,-1],[14,57,60,
-1,1,1],[52,1],[14,18,28,31,33,35,37,40,50,54,57,58,-1,3,1,-1,-1,-1,-2,1,1,1,
1,2],[18,28,31,37,40,50,54,58,1,1,-1,-1,1,1,1,1],[14,20,28,30,37,38,50,55,57,
58,-1,1,1,1,-1,-1,1,1,1,1],[14,18,20,28,33,39,50,52,53,58,60,-1,-1,1,2,1,-1,1,
-1,1,1,1],[57,1],[58,1],[18,20,28,30,33,37,56,-1,1,1,1,1,1,-1],[37,58,-1,1]],
[[23,30,37,41,42,1,1,1,-1,1],[1,8,23,30,37,42,51,1,1,1,-1,1,-1,1],[1,5,16,19,
25,30,36,42,50,59,-1,1,1,1,1,1,1,1,1,-1],[1,8,12,29,43,-1,-1,1,1,1],[1,6,8,16,
25,27,30,39,42,51,59,-1,-1,-1,1,-1,1,1,-1,1,-1,-1],[5,6,16,30,36,39,45,1,1,1,
1,1,1,-1],[16,23,42,1,-1,1],[1,2,8,23,30,37,59,1,1,1,-1,-1,-1,1],[1,6,8,23,25,
30,35,36,37,39,42,49,51,59,1,1,1,1,1,-2,1,-1,1,1,-1,-1,1,1],[1,8,16,23,25,30,
37,49,55,-2,-1,-1,2,1,1,1,1,-1],[1,23,25,42,1,-1,-1,-1],[12,1],[5,6,16,20,23,
25,30,36,39,42,49,1,1,1,1,-1,1,1,1,1,1,-1],[1,8,30,38,1,1,-1,1],[1,8,25,59,1,
1,-1,1],[7,16,25,-1,-1,1],[1,6,8,10,16,23,30,37,39,49,51,59,2,1,1,-1,1,1,-1,1,
1,-1,1,2],[1,5,6,8,9,16,30,49,1,1,1,1,1,1,-1,-1],[1,6,23,25,36,37,50,51,52,-1,
1,2,1,-1,1,1,1,-1],[6,26,49,1,-1,-1],[5,6,8,16,23,25,30,37,39,49,51,54,1,1,1,
1,1,1,-1,1,1,-1,1,1],[1,5,6,8,16,22,29,30,39,44,49,51,59,3,1,2,2,1,1,-1,-1,1,
1,-3,1,1],[23,1],[6,30,36,40,49,50,-1,1,1,1,1,1],[25,1],[13,23,36,49,-1,-1,1,
1],[1,5,6,16,23,30,39,42,-1,1,1,2,-1,1,1,1],[6,36,49,-1,1,1],[1,8,12,22,25,47,
59,1,1,1,1,-1,-1,1],[1,8,11,23,25,30,51,59,1,1,1,1,1,-1,1,1],[1,8,32,39,59,1,
1,1,1,1],[33,36,39,51,59,1,1,-1,-1,-1],[1,23,30,31,36,37,-1,1,-1,1,-1,1],[1,
14,23,25,42,59,1,1,-1,-1,-1,1],[1,8,18,30,36,49,59,2,1,1,-1,1,-1,1],[36,1],
[37,1],[23,25,30,34,51,1,1,-1,1,1],[39,1],[1,39,49,50,56,59,-1,-1,1,1,1,-1],
[1,8,23,30,37,51,59,1,1,1,-1,1,1,1],[42,1],[12,22,53,-1,-1,1],[1,8,25,29,-1,
-1,1,1],[5,16,30,36,39,1,1,1,1,1],[23,25,37,50,51,2,1,1,1,1],[1,5,6,8,12,16,
22,29,30,39,49,51,59,3,1,2,2,1,1,1,-1,-1,1,-3,1,2],[1,21,23,25,37,39,49,51,-1,
-1,1,1,1,1,1,1],[5,6,16,25,28,30,36,39,42,49,1,1,1,1,-1,1,1,1,1,-1],[8,25,30,
46,50,51,-1,-1,1,-1,-1,-1],[8,23,30,37,1,1,-1,1],[3,5,6,16,50,-1,1,1,1,-1],[1,
4,5,6,8,16,22,25,29,30,39,49,51,59,3,1,1,2,2,1,1,1,-1,-1,1,-3,1,1],[1,6,25,39,
48,49,51,59,1,1,1,1,-1,-1,1,1],[5,6,16,17,25,30,49,51,1,1,2,1,1,-1,-1,1],[1,5,
6,16,23,24,25,30,36,37,49,50,51,-1,-1,-1,-1,2,1,1,-1,-1,1,1,1,1],[23,37,58,1,
1,-1],[23,37,60,1,1,-1],[1,8,15,25,-1,-1,1,1],[57,1]],[[1,6,-1,1],[1,9,20,30,
32,39,46,55,57,59,1,-1,1,2,1,2,-1,1,-1,1],[1,6,24,28,37,39,50,51,55,57,-1,1,
-1,1,1,-1,-1,-1,-1,1],[12,20,22,29,40,55,59,-1,1,-1,1,-1,1,-1],[1,7,10,16,30,
32,37,39,40,57,59,-1,-1,1,-1,-1,-1,1,-2,-1,1,-2],[1,6,7,13,20,28,-1,1,1,-1,1,
1],[7,20,-1,-1],[1,6,31,32,39,57,59,1,-1,1,1,1,-1,1],[1,19,28,30,32,37,39,40,
46,55,57,59,2,-1,-1,2,1,-1,2,1,-1,1,-2,2],[1,6,7,11,20,25,32,37,39,40,57,-1,1,
1,1,1,1,-1,-1,-1,1,1],[5,16,25,30,39,1,1,-1,1,1],[4,20,22,29,32,39,40,55,57,
-1,1,-1,1,1,1,-1,1,-1],[1,28,-1,1],[1,8,32,39,57,59,1,1,1,1,-1,1],[15,32,39,
59,1,1,1,1],[7,16,1,1],[1,15,30,32,37,39,40,46,50,55,57,59,1,1,2,2,-1,3,1,-1,
1,1,-2,2],[1,30,32,39,46,57,59,60,1,1,1,1,-1,-1,1,1],[2,6,7,28,30,37,40,46,51,
59,1,1,1,-1,1,-1,1,-1,-1,1],[7,1],[1,30,32,37,39,46,55,57,59,1,1,1,-1,1,-1,1,
-2,1],[1,7,12,22,30,32,39,46,53,57,59,1,1,1,1,2,2,2,-1,-1,-2,2],[16,20,25,26,
-1,1,1,1],[1,15,20,28,34,37,51,57,-1,1,1,1,-1,1,-1,1],[25,1],[16,25,28,36,1,
-1,1,-1],[1,7,20,30,37,41,-1,-1,-1,-1,-1,1],[20,28,1,1],[29,32,39,57,59,1,1,1,
-1,1],[1,30,32,39,40,46,54,57,59,1,1,1,1,1,-1,1,-1,1],[14,32,39,57,59,1,1,1,
-1,1],[20,28,35,37,39,40,59,1,1,-1,1,-1,-1,-1],[1,7,20,28,37,46,55,57,58,1,-1,
-1,-1,-1,-1,1,-1,1],[3,6,15,30,32,39,50,59,1,-1,1,1,1,2,1,1],[1,20,28,30,32,
37,39,46,57,59,1,1,1,1,1,1,1,-1,-1,1],[20,23,28,1,-1,1],[15,17,30,39,50,55,1,
-1,1,1,1,1],[1,18,20,30,46,55,57,1,-1,1,1,-1,1,-1],[21,37,39,51,55,-1,-1,1,1,
1],[51,57,-1,1],[1,6,30,32,39,40,46,48,57,59,1,1,2,1,2,1,-1,-1,-1,2],[6,49,1,
-1],[20,22,29,40,44,55,57,-1,1,-1,1,1,-1,1],[12,22,47,-1,-1,1],[1,20,28,42,-1,
1,1,1],[6,7,20,30,32,39,40,46,51,59,1,1,1,2,1,1,1,-1,-1,1],[1,7,12,29,30,32,
39,43,46,57,59,1,1,1,1,2,3,3,1,-1,-3,3],[6,27,32,37,40,46,55,1,-1,-1,-1,1,-1,
1],[1,6,28,45,-1,1,1,-1],[1,30,32,39,46,50,51,59,-1,-1,-1,-1,1,1,1,-1],[1,7,
46,55,57,1,-1,-1,1,-1],[57,-1],[1,7,12,30,32,39,46,57,59,1,1,1,2,2,2,-1,-3,2],
[7,30,32,39,57,59,1,1,1,1,-1,1],[1,30,32,39,46,51,57,59,1,2,1,1,-1,-1,-1,1],
[1,28,30,33,37,39,40,46,55,59,1,-1,1,-1,-1,1,1,-1,1,1],[52,57,1,-1],[30,39,40,
56,59,1,1,1,-1,1],[32,39,-1,-1],[30,32,38,39,59,1,1,-1,1,1]]],
 x->List(x,y->expand(y,60)));
  elif i=81 then r:=Zip(f(4),f(25),KroneckerMatrix);
  elif i=82 then r:=J^2*f(81);
  elif i=83 then r:=J*f(81);
  elif i=84 then r:=ComplexConjugate(f(81));
  elif i=85 then r:=J*f(84);
  elif i=86 then r:=J^2*f(84);
  elif i=87 then r:=J*f(79);
  elif i=88 then r:=J^2*f(79);
  elif i=89 then r:=J^2*f(80);
  elif i=90 then r:=J*f(80);
  elif i=91 then r:=List(
[[[5,20,54,61,1,1,1,1],[1,10,11,20,38,39,42,46,49,51,54,55,57,58,1,-1,-1,-1,
-1,-1,-1,-1,1,-1,-1,1,-1,-1],[6,10,19,20,33,42,45,49,51,54,55,58,61,64,1,1,-1,
-1,-1,1,-1,1,1,-1,-1,-1,-1,1],[13,38,39,61,-1,1,1,-1],[2,18,45,64,1,-1,1,-1],
[3,6,10,38,39,41,42,49,64,-1,-1,-1,-1,-1,1,-1,1,1],[4,10,11,42,45,46,49,51,55,
57,58,-1,-1,-1,-1,1,-1,1,-1,1,-1,-1],[11,20,25,38,39,41,45,54,58,64,-1,-1,-1,
-1,-1,1,2,-1,1,-1],[19,38,45,54,1,-1,1,-1],[45,-1],[10,11,15,29,34,41,42,45,
46,51,54,57,-2,-1,1,1,1,1,-1,1,-1,-1,1,-1],[15,27,32,34,42,45,49,58,61,64,-1,
1,1,-1,-1,-1,1,-1,-1,2],[7,10,18,45,58,1,1,-1,1,1],[8,10,33,42,49,51,55,64,1,
1,-1,1,1,1,-1,1],[9,33,49,51,56,58,61,64,1,-1,1,1,-1,-1,-1,1],[11,12,14,18,20,
33,38,39,45,46,51,55,61,-1,-1,1,1,-1,-1,-2,-2,1,-1,1,1,1],[10,17,20,23,27,42,
49,54,58,64,1,-1,-1,-1,-1,1,-1,-1,1,-1],[10,11,38,39,42,45,46,49,51,55,57,61,
-1,-1,-1,-1,-1,1,-1,1,-1,1,-1,1],[10,19,42,45,49,58,61,64,-1,-1,-1,-1,1,-1,-1,
1],[33,49,58,1,-1,1],[19,45,54,61,1,1,-1,-1],[19,33,38,39,41,45,49,53,58,61,
64,1,1,-2,-1,1,2,-2,1,2,1,-1],[10,15,17,27,34,38,39,49,51,54,57,64,1,-1,1,1,
-1,-1,-1,1,1,-1,1,1],[33,39,51,54,61,1,1,-1,-1,-1],[10,11,14,15,29,33,34,38,
39,42,46,49,51,54,55,57,58,61,3,1,-1,-1,-1,-1,-1,-1,-1,2,1,1,2,-1,-1,1,1,1],
[11,15,19,30,33,38,39,45,49,55,58,61,64,-1,-1,1,-1,1,-1,-1,2,-1,1,1,1,-2],[10,
15,19,27,34,38,39,45,49,51,54,57,64,-1,1,1,-1,1,1,1,1,-1,-1,1,-1,-1],[10,20,
38,39,42,45,49,51,54,57,58,60,64,1,-1,-1,-1,1,1,-1,1,-1,1,1,-1,-1],[11,18,19,
20,29,33,38,39,45,49,51,55,58,61,64,-1,1,1,-1,-1,-1,-4,-4,2,-1,2,1,1,3,-2],
[10,11,15,19,29,34,38,39,42,45,46,49,51,57,58,59,61,64,2,1,-1,1,-1,-1,-2,-2,1,
1,1,-1,2,1,2,1,2,-1],[34,36,39,45,49,-1,1,1,1,-1],[10,16,25,42,45,46,51,56,57,
58,1,-1,-1,1,1,1,1,-1,1,1],[20,21,33,45,49,51,54,56,64,1,1,-1,1,1,1,1,-1,1],
[15,24,33,34,49,51,58,1,-1,1,1,-1,-1,1],[10,18,28,29,33,38,39,42,45,49,51,58,
61,64,1,1,1,-1,-1,-2,-2,1,1,1,1,1,2,-1],[31,33,34,36,45,61,64,-1,1,1,-1,-1,-1,
1],[10,15,34,49,63,-1,1,1,-1,-1],[10,34,42,49,56,64,1,1,1,1,-1,1],[15,33,45,1,
-1,1],[19,45,-1,-1],[10,20,33,42,49,51,54,55,61,64,1,-1,-1,1,1,1,-1,-1,-1,1],
[15,19,34,45,49,51,-1,1,-1,1,-1,1],[10,33,38,39,42,45,50,51,57,58,61,64,1,-1,
-2,-2,1,1,1,2,1,1,2,-1],[20,49,-1,-1],[20,54,61,1,1,1],[10,18,19,20,27,29,33,
38,39,42,45,49,51,54,58,61,64,2,1,1,-2,-1,-1,-2,-4,-4,2,2,-1,3,-1,1,3,-2],[11,
18,29,33,38,39,45,51,52,55,58,61,64,-1,1,-1,-1,-3,-3,2,1,-1,1,1,3,-2],[10,19,
29,33,38,39,42,45,47,51,58,61,1,1,-1,-1,-1,-1,1,1,1,1,1,1],[33,38,39,40,49,51,
56,64,-1,-1,-1,-1,1,1,-1,1],[20,27,43,50,51,54,57,64,-1,-1,-1,-1,-1,-1,-1,-1],
[10,15,33,34,42,44,45,51,54,56,58,64,1,1,-1,1,1,-1,1,1,1,-1,1,1],[10,42,45,48,
58,61,64,1,1,1,-1,1,1,-1],[10,22,34,38,41,42,53,55,56,1,-1,1,1,-1,1,-1,1,-1],
[10,15,34,42,45,56,58,-1,-1,-1,-1,-1,1,-1],[10,19,20,33,38,39,41,42,45,49,51,
54,55,58,1,1,-2,-1,-2,-2,1,1,2,-1,2,-1,-1,1],[19,20,38,39,45,49,51,1,-1,-1,-1,
1,-1,1],[15,19,20,27,33,34,38,39,42,45,49,51,54,58,61,64,-1,-1,1,1,1,-1,1,1,
-1,-2,2,-1,-1,-1,-2,2],[20,38,39,54,-1,-1,-1,-1],[26,33,38,41,49,51,55,64,-1,
1,1,-1,-1,-1,1,-1],[15,20,27,33,34,35,42,46,57,-1,1,1,1,-1,-1,-1,1,1],[15,33,
34,42,45,49,56,1,-1,1,1,1,1,-1],[11,15,18,19,29,34,37,38,39,45,49,51,55,58,61,
64,-1,-1,1,1,-1,-1,1,-2,-2,2,-1,1,1,1,2,-2],[15,29,33,34,38,39,42,45,49,51,56,
61,62,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1],[58,-1]],[[10,15,45,49,58,64,1,-1,-1,1,
-1,1],[11,15,17,23,33,37,40,45,52,58,64,1,1,1,1,-1,1,1,1,1,-1,1],[1,4,11,15,
17,37,45,49,60,-1,-1,1,1,1,-1,1,-1,1],[33,49,58,64,1,-1,1,-1],[20,1],[33,61,
-1,1],[17,29,37,40,41,45,46,52,64,1,1,1,1,1,1,-1,1,1],[15,33,34,42,45,56,58,1,
-1,1,1,1,-1,1],[2,4,14,17,37,40,45,60,1,1,1,1,1,1,1,1],[3,17,29,45,46,-1,-1,
-1,-1,1],[11,14,29,37,46,52,60,-1,1,1,1,-1,1,-1],[11,40,43,49,50,56,57,58,61,
1,1,1,-1,1,1,1,-1,1],[39,-1],[50,60,1,1],[6,17,49,60,61,1,1,-1,1,1],[11,14,15,
25,31,33,36,45,49,56,64,1,-1,1,1,1,-2,1,1,1,-1,1],[15,61,1,-1],[33,37,40,49,
52,58,64,-1,1,1,1,1,-1,1],[49,61,-1,1],[5,20,-1,-1],[4,7,14,17,37,40,45,58,60,
1,1,1,1,1,1,1,1,1],[4,8,11,31,33,36,46,49,56,57,1,-1,1,1,-1,1,1,1,-1,1],[9,11,
14,29,33,37,40,45,46,52,60,61,1,1,-1,-1,-1,-1,1,1,1,-1,1,1],[12,17,31,33,36,
37,49,1,1,-1,1,-1,1,-1],[11,14,16,25,29,31,33,36,37,46,49,52,56,60,1,-1,-1,-1,
-1,1,-1,1,-2,2,1,-1,-1,2],[4,26,31,33,36,37,45,49,56,58,62,1,-1,1,-1,1,1,1,1,
-1,1,1],[4,11,14,29,33,37,46,52,58,60,61,1,-1,1,1,1,1,-1,1,1,-1,-1],[11,14,15,
29,31,33,36,37,45,46,48,52,56,58,60,1,-1,1,-1,1,-1,1,-1,1,1,1,-1,-1,1,1],[4,
11,14,15,17,29,31,33,36,45,46,49,56,60,64,1,1,-1,1,-1,-1,3,-4,3,2,2,3,-3,1,1],
[4,11,14,17,29,31,33,36,37,46,49,52,55,56,60,1,1,-1,-1,-1,2,-2,2,-1,2,2,-1,-1,
-1,1],[11,17,33,40,49,54,56,57,63,1,1,1,1,-1,-1,1,1,-1],[17,34,37,52,54,60,61,
1,1,-1,-1,1,1,1],[15,17,19,60,61,-1,1,1,1,1],[14,53,54,1,1,1],[14,17,29,31,33,
36,40,46,49,56,57,60,61,64,-1,-1,-1,1,-2,1,-1,1,2,-2,-1,1,-1,1],[14,54,59,61,
1,1,1,1],[14,1],[17,54,60,61,1,1,1,1],[13,39,1,-1],[4,14,17,18,37,40,60,-1,-1,
-1,-1,-1,-1,-1],[11,15,17,21,37,40,45,49,58,60,1,1,1,1,-1,1,1,-1,1,1],[4,11,
17,22,29,31,36,40,45,53,54,57,1,1,1,-1,1,1,1,1,1,-1,-1,1],[14,17,24,29,31,33,
36,37,45,46,49,52,56,57,60,-1,-1,1,-1,1,-2,1,-1,1,1,2,-1,-1,-1,1],[11,15,30,
49,57,60,1,1,1,-1,1,-1],[15,45,49,58,-1,-1,1,-1],[4,11,14,15,29,31,33,36,37,
45,46,49,56,60,61,64,1,2,-1,2,-1,3,-4,3,-1,2,2,3,-3,2,-1,1],[14,17,29,31,33,
36,45,46,49,56,57,60,64,-1,-1,-1,2,-3,2,1,1,3,-2,-1,1,1],[4,28,31,33,36,46,48,
49,56,60,1,-1,1,-1,1,1,-1,1,-1,1],[33,60,61,-1,1,1],[15,37,52,61,1,1,1,-1],
[17,36,37,54,60,61,1,1,-1,1,1,1],[61,-1],[32,54,1,1],[17,38,54,60,-1,-1,-1,
-1],[4,11,15,17,31,33,36,37,40,44,45,46,56,57,58,60,1,2,2,1,2,-2,2,-1,1,-1,2,
1,-1,1,1,1],[4,11,14,15,17,31,33,36,40,45,47,57,1,1,1,1,1,1,-1,1,1,1,1,1],[4,
15,31,33,35,36,45,49,56,58,61,-1,-1,-2,1,-1,-2,-1,-1,1,-1,1],[15,33,45,1,-1,
1],[51,54,1,1],[15,52,61,-1,-1,1],[17,60,1,1],[4,11,14,26,31,33,36,45,46,49,
56,60,64,1,1,-1,-1,2,-2,2,1,1,2,-2,1,1],[14,17,29,31,33,36,46,49,51,54,56,57,
1,2,1,-1,1,-1,-1,-1,1,1,1,1],[11,17,27,58,1,1,-1,-1]],[[12,56,57,-1,1,1],[7,
13,16,17,20,25,27,30,43,50,51,54,57,59,61,64,-1,1,1,-1,1,1,2,-1,1,1,1,1,1,1,
-1,1],[17,20,27,31,33,38,43,49,50,51,54,56,64,-1,1,1,1,-1,1,1,1,1,1,2,-1,1],
[27,28,45,57,58,-1,-1,-1,-1,-1],[17,32,33,1,-1,1],[38,39,61,1,1,-1],[7,13,20,
23,27,30,33,35,50,51,54,59,61,64,-1,1,1,1,1,-1,1,1,1,1,1,1,-1,1],[2,7,17,27,
33,38,39,40,51,61,1,-1,1,1,2,1,1,1,-1,-1],[9,17,20,23,24,27,31,33,39,54,64,-1,
1,1,1,1,1,-1,1,1,1,1],[17,20,23,27,33,42,54,64,-1,-1,-1,-1,-1,1,-1,-1],[4,7,
30,33,37,38,45,54,56,58,59,61,63,-1,-1,-1,1,-1,-1,-1,-2,1,-1,1,-1,-1],[17,20,
25,27,30,33,38,43,51,54,61,64,-1,1,1,1,-1,-1,1,1,1,1,-1,1],[17,33,50,51,60,1,
1,-1,-1,-1],[5,13,20,38,39,54,1,-1,1,1,1,1],[15,17,20,34,38,39,50,51,54,-1,-1,
1,-1,1,1,1,1,1],[1,7,8,27,33,38,39,40,43,50,54,56,57,58,59,1,-1,1,2,1,1,1,1,1,
1,1,1,2,1,1],[6,17,38,50,51,53,61,1,1,-1,-1,-1,1,1],[7,13,27,30,33,46,57,59,
61,-1,1,1,-1,1,1,1,1,-1],[17,33,36,38,51,61,-1,-1,-1,1,1,-1],[50,51,54,-1,-1,
-1],[17,20,23,31,33,39,43,54,56,57,64,1,1,1,-1,1,1,-1,1,-1,-1,1],[17,27,31,33,
39,40,50,51,54,56,57,58,2,1,-1,2,1,1,-1,-2,-1,1,1,1],[3,22,27,38,39,45,54,56,
58,1,1,1,2,1,1,2,-1,1],[9,20,23,27,64,-1,1,1,1,1],[1,7,17,23,30,37,38,39,45,
49,51,54,56,58,59,61,63,-1,1,1,-1,1,1,2,1,1,1,-1,3,-1,1,-1,1,1],[7,17,18,27,
31,33,39,40,45,49,51,54,56,57,-1,1,1,1,-1,2,1,1,-1,-1,-1,-1,1,1],[17,23,27,31,
33,38,43,45,54,55,56,57,58,1,1,-1,-1,1,-2,-1,-1,-1,-1,1,-1,-1],[11,17,27,30,
33,38,39,40,51,54,57,58,61,1,1,1,1,1,1,1,1,-1,1,1,1,1],[7,13,17,20,23,27,31,
33,38,39,40,43,50,51,54,56,57,58,62,63,64,-1,1,1,-1,-1,2,-1,2,1,2,1,1,1,-1,1,
1,3,2,1,1,-1],[7,17,20,23,30,31,33,37,38,39,50,51,54,57,58,59,61,63,64,1,2,-1,
-1,1,-1,1,1,1,1,-1,-2,1,1,1,-1,1,1,-1],[17,20,23,27,31,33,54,64,1,1,1,1,-1,1,
1,1],[14,17,20,33,38,39,51,54,59,61,-1,1,1,1,1,1,-1,1,-1,1],[20,33,38,39,50,
54,1,1,1,1,1,1],[15,17,38,50,51,54,1,1,-1,-1,-1,-1],[20,23,30,33,37,38,39,50,
51,54,57,58,63,64,-1,-1,1,1,1,1,1,1,-1,1,1,1,1,-1],[19,33,36,50,54,1,-1,-1,-1,
-1],[37,38,52,54,-1,-1,-1,-1],[20,39,54,61,1,1,1,1],[17,33,54,1,1,1],[17,20,
31,33,39,45,54,58,64,-1,-1,1,-1,-1,1,-1,1,-1],[20,38,39,49,54,56,57,64,1,1,1,
1,2,-1,-1,1],[10,17,20,23,27,31,33,42,54,64,-1,1,1,1,1,-1,1,-1,1,1],[17,20,22,
23,33,38,39,51,54,57,58,61,64,1,-1,1,-1,1,1,1,-1,1,1,1,1,-1],[27,40,43,56,57,
1,1,1,1,1],[21,23,27,1,-1,-1],[17,23,26,27,30,31,33,37,38,39,40,43,49,50,51,
54,57,58,61,63,2,-1,1,2,1,-1,2,1,1,3,1,1,1,1,-1,3,3,2,1,1],[7,13,17,20,23,27,
29,33,38,39,50,51,54,57,58,63,64,-1,1,1,-1,-1,1,1,2,1,1,1,-1,1,2,1,1,-1],[17,
31,33,39,49,51,54,63,1,-1,1,1,1,-1,1,1],[38,39,54,1,1,1],[38,53,-1,1],[17,20,
33,39,49,51,54,61,1,1,1,1,1,-1,1,1],[17,33,37,51,1,1,1,-1],[38,61,-1,1],[17,
20,33,39,51,54,61,-1,-1,-1,-1,1,-1,-1],[17,20,27,31,33,38,39,40,43,49,51,54,
57,58,64,2,1,2,-1,2,1,2,1,1,1,-1,2,1,1,1],[17,20,27,31,33,39,43,45,54,57,64,1,
1,1,-1,1,1,1,-1,1,1,1],[17,31,33,38,39,41,45,51,56,57,61,64,-2,1,-2,1,-1,1,1,
1,-1,-1,-1,1],[27,43,44,57,1,1,1,1],[13,38,39,61,1,-1,-1,1],[38,49,59,1,-1,
-1],[20,33,39,50,54,1,1,1,1,1],[7,13,17,27,31,33,38,39,40,47,50,51,54,56,57,
58,63,-1,1,1,2,-1,2,1,1,1,1,1,-1,1,1,2,1,1],[17,20,23,27,33,38,48,61,63,64,1,
2,1,1,1,-1,-1,1,-1,1],[20,27,43,50,51,54,57,64,1,1,1,1,1,1,1,1]],[[4,1],[4,10,
18,29,36,41,46,50,1,1,1,-1,1,-1,1,-1],[3,27,50,-1,-1,1],[1,4,-1,-1],[13,-1],
[17,54,61,-1,-1,-1],[2,4,10,29,36,41,46,50,1,1,1,-1,1,-1,1,-1],[17,35,46,55,
-1,-1,1,-1],[3,10,40,41,1,1,-1,-1],[10,64,-1,-1],[17,29,36,46,-1,-1,1,1],[10,
19,29,41,47,54,55,61,1,1,-1,-1,1,-1,1,-1],[5,13,1,-1],[50,60,1,1],[49,51,54,
61,1,-1,-1,-1],[4,10,13,28,42,46,48,50,55,1,1,1,-1,1,1,-1,-1,-1],[19,54,61,-1,
1,1],[4,7,10,29,36,41,46,50,1,1,1,-1,1,-1,1,-1],[6,54,61,1,-1,-1],[39,1],[3,9,
10,41,1,1,1,-1],[3,10,17,39,42,55,57,1,1,-1,1,1,-1,-1],[19,36,41,54,61,1,-1,
-1,-1,-1],[42,56,-1,1],[28,29,36,42,46,50,55,1,1,-1,1,-1,1,-1],[3,10,16,25,39,
42,46,50,55,1,1,-1,-1,1,1,1,-1,-1],[3,19,36,54,61,1,-1,1,1,1],[29,36,42,55,62,
1,-1,1,-1,-1],[3,4,10,11,13,39,42,46,50,55,1,1,2,1,1,1,3,1,-1,-3],[3,10,12,29,
36,39,42,46,55,1,1,-1,1,-1,1,2,-1,-1],[10,22,41,55,1,-1,-1,1],[36,51,52,54,-1,
-1,-1,-1],[15,51,54,61,1,-1,-1,-1],[61,1],[4,13,29,41,42,54,55,63,1,1,1,1,1,1,
-2,1],[53,54,-1,-1],[14,1],[51,54,-1,-1],[20,39,-1,-1],[3,10,21,41,-1,-1,-1,
1],[23,41,50,1,-1,1],[3,10,39,41,42,1,2,1,-1,1],[36,42,55,-1,1,-1],[24,-1],
[45,58,-1,-1],[3,4,10,13,19,29,39,42,54,55,61,1,1,2,1,-1,1,1,3,1,-3,1],[4,10,
13,30,42,46,50,55,1,1,1,-1,2,1,-1,-2],[3,10,26,39,42,55,1,1,1,1,1,-1],[33,51,
54,61,1,-1,-1,-1],[19,36,54,61,-1,1,1,1],[34,51,54,-1,-1,-1],[54,59,61,1,1,1],
[17,50,51,61,1,-1,-1,1],[51,61,1,-1],[3,10,17,39,41,42,43,50,55,1,2,-1,1,-1,2,
1,1,-1],[3,10,39,41,42,44,1,2,1,-1,1,-1],[3,10,19,31,39,42,54,55,61,-1,-1,1,1,
-1,-2,-1,1,-1],[45,1],[17,32,50,61,1,-1,-1,1],[19,36,37,54,61,1,-1,1,-1,-1],
[38,51,1,-1],[3,4,10,13,25,39,42,46,50,55,1,1,2,1,-1,1,2,1,-1,-2],[8,42,51,55,
61,-1,-1,-1,1,1],[10,1]]],x->List(x,y->expand(y,64)));
  elif i=92 then r:=List(
[[[3,8,18,19,21,23,27,38,39,42,43,45,53,62,63,1,1,-J,1,J^2,-1,-1,1,1,-1,J^2,1,
-1,J^2,2],[1,6,8,18,21,23,38,45,53,62,63,1,-1,-J^2,2,-J,-1,1,1,-1,J^2,2],[2,8,
18,24,39,42,53,62,1,J,J^2,-J,1,1,-J,J],[6,8,18,19,21,24,39,42,63,-1,J^2,-J^2,
-1,1,1,-1,J,1],[7,42,45,63,-1,-1,-1,J],[21,24,27,39,42,45,62,63,J^2,1,-1,1,J,
1,-1,2],[5,7,8,21,53,62,63,1,-1,1,J^2,-1,-J,1],[8,18,63,J^2,-1,J^2],[8,15,18,
19,21,23,24,38,39,42,53,62,63,J-J^2,1,-2*J-J^2,1,-J,-1,-1,1,1,J^2,-1,J^2,J],
[8,18,19,24,39,42,43,45,46,56,62,63,J-J^2,-J,J^2,-1,J^2,1,-J^2,J^2,-1,J,-J^2,
-2],[8,9,18,19,21,23,24,38,39,53,63,J^2,-1,J,-1,J,1,J,-1,-1,-J^2,-1],[8,10,16,
18,19,23,38,39,42,53,63,-J,1,-J^2,J,J^2,-J^2,J^2,J^2,J,J,1],[8,15,21,24,28,39,
53,63,1,-1,J,-J^2,1,-1,-J^2,1],[14,18,24,53,62,J,1,J,J,J^2],[8,11,19,23,38,39,
42,45,53,62,63,1,-1,1,-1,1,1,J^2,1,-1,J^2,1],[8,17,18,23,38,42,43,45,56,63,
J+2*J^2,-J,J-J^2,1,-1,J,-1,1,J^2,-J],[8,18,19,35,39,40,42,43,45,62,63,
-2*J-J^2,J^2,J^2,1,J^2,J,1,1,-J,-J^2,-J+J^2],[18,J],[8,39,45,63,1,-1,1,1],[8,
18,24,36,39,53,-1,J,-J,-1,1,J^2],[8,18,24,42,53,62,J^2,J^2,1,J,1,J],[18,22,24,
53,62,1,J,J,J,J^2],[8,18,19,20,24,42,45,53,62,63,2,-J,1,1,J,J^2,1,J,J^2,1],[8,
45,63,1,1,-2*J-J^2],[8,18,21,24,32,45,53,62,63,-2*J-J^2,-1,-1,-J^2,-J^2,1,J,
J^2,2],[24,42,43,50,53,62,63,1,J,J,1,1,J,1],[4,18,19,21,23,38,42,1,-1,-1,-1,1,
-1,1],[8,11,18,19,24,37,39,53,63,-1,-1,J,1,J^2,1,1,J^2,-1],[8,18,42,43,61,63,
-J^2,-1,-J,-J^2,-J^2,J],[8,18,24,39,53,63,2*J+J^2,J,-J,1,J^2,J],[8,18,19,45,
63,J,1,-1,-1,J],[8,18,21,24,25,32,42,45,53,62,J,1,-J,J^2,J,-1,-J^2,J,J^2,1],
[8,19,39,42,55,63,J,-1,-1,1,-1,J],[19,39,45,56,63,J,J,-1,1,J],[8,16,18,21,23,
24,38,43,53,62,63,-J^2,-J^2,J^2,-1,-J^2,J,J^2,J,J-J^2,-1,J],[18,21,38,J,J,-1],
[13,19,1,-1],[8,20,24,30,42,53,62,-J,1,J,-1,J^2,J,J^2],[31,45,63,1,-1,-1],[8,
18,19,34,39,42,45,63,-1,-J,J,1,J,1,-1,J+2*J^2],[8,18,19,21,23,24,38,39,41,42,
53,62,63,2*J+J^2,-J-3*J^2,J,1,J^2,-J+J^2,-J^2,J^2,J^2,-J^2,J^2,-J^2,-J],[8,18,
58,63,-1,-1,J^2,-1],[8,18,42,-J^2,-J,-J],[18,24,44,53,62,1,J,J,J,J^2],[8,18,
24,45,63,J,1,-1,-1,-1],[8,12,18,21,23,24,35,38,40,42,43,45,53,62,63,J,-1,1,1,
J^2,J^2,1,-J^2,J,1,1,-1,-J+J^2,-J-2*J^2,-1],[18,19,39,42,48,63,-1,1,1,J^2,J^2,
-1],[19,39,60,J,J,-1],[8,18,19,24,26,42,43,45,53,60,62,63,-1,J,-1,J^2,1,1,1,
-1,J^2,J^2,1,-1],[18,19,24,42,43,48,49,53,62,63,-J,1,J,J^2,J^2,J^2,1,J,J^2,
-1],[8,18,23,33,38,39,43,52,J^2,2*J,1,-1,-1,1,-J^2,-J^2],[19,39,43,55,57,J,J,
J,J,J],[18,23,38,45,63,J^2,J,-J,-1,-1],[8,18,19,39,45,54,63,-J,-J,1,J,-J,J^2,
-J+J^2],[8,18,19,39,43,51,53,62,63,64,J,J^2,1,1,J,1,1,J,-1,1],[8,18,19,39,40,
43,45,-1,1,J,J,1,J^2,-1],[8,18,19,24,42,51,53,63,J^2,J-J^2,-1,-J,J,-1,J^2,1],
[18,43,J^2,-1],[8,18,21,23,24,38,42,53,59,62,63,2,2*J^2,-1,J,J-J^2,-J,J^2,
J-J^2,J^2,J^2,-J^2],[8,19,39,43,47,-J^2,-J,-J,-J^2,-J],[8,18,29,42,43,61,63,
J^2,1,J,J,J^2,-1,-J],[8,18,21,23,24,38,43,53,62,63,-J^2,2,-J,-1,-1,1,-J,-1,-J,
1],[63,J],[8,18,19,21,23,24,38,42,43,45,52,53,62,63,-J-2*J^2,-2*J,1,J^2,-1,J,
1,J^2,J^2,1,J^2,J,J^2,1]],[[1,6,20,23,36,55,57,-1,1,2,1,J^2,-1,-1],[9,20,36,
38,42,57,-1,2,J^2,-J-2*J^2,J^2,-1],[23,25,32,38,57,1,-1,J^2,J+2*J^2,1],[13,20,
23,38,57,1,1,-1,1,-1],[2,19,20,36,42,1,-1,J,1,1],[1,20,23,36,38,39,55,57,-1,2,
1,-1,J^2,-1,-1,-1],[4,20,38,57,1,1,-J^2,-1],[20,21,J^2,1],[5,19,20,23,36,42,
57,-1,-1,J,1,-J,-J,1],[20,23,35,36,38,39,40,42,55,57,-2,J^2,J,1,J,-J^2,J^2,
J^2,-J^2,1],[20,23,36,37,38,-1,-1,J,-1,1],[20,23,38,41,57,59,1,J^2,-J^2,1,-1,
1],[7,20,23,38,42,57,1,1,-1,1,-1,-1],[8,38,42,1,1,J^2],[20,23,27,36,1,1,1,
J^2],[12,20,35,36,39,40,42,55,57,-J^2,-J,J^2,J,-1,1,1,-1,-1],[17,19,20,23,39,
42,55,J^2,-J-2*J^2,-J+J^2,J^2,-J^2,2*J+J^2,1],[22,-1],[19,20,23,38,42,57,1,1,
-1,1,-1,-1],[23,38,42,1,-1,1],[14,38,1,J^2],[18,22,38,1,-1,1],[20,38,42,1,1,
-1],[20,36,42,55,57,62,-2*J-J^2,-1,-1,-1,-1,-1],[15,19,20,36,38,42,57,-1,1,2,
-1,1,-1,-1],[19,20,39,55,57,-1,1,-1,-1,-1],[19,25,36,1,-1,J],[3,20,23,38,42,
57,1,-1,1,-1,1,1],[20,38,47,50,55,57,J,J,-1,1,1,1],[20,23,38,42,43,J,1,-1,1,
J],[20,42,44,63,J,-J,-J^2,-1],[15,19,28,36,38,42,-J,J,J,-J,J,-J],[19,20,23,29,
38,39,42,55,1,J,-1,-1,-J^2,1,J^2,1],[20,23,38,39,40,55,J,J,1,-J,J,1],[20,36,
38,39,41,42,54,J,J,1,J^2,1,J^2,-J],[36,J],[11,36,37,1,-1,-1],[38,1],[20,55,57,
-1,1,1],[20,23,38,39,54,55,57,J+2*J^2,J,-J,-J,1,1,-J-2*J^2],[10,20,23,36,38,
39,42,57,J^2,-J,J^2,1,J,J,-J,-1],[20,38,-1,J^2],[44,-J^2],[20,30,38,42,1,-1,1,
-J],[19,20,31,42,43,57,-1,-1,-1,-J,1,1],[20,36,38,39,46,55,57,-1,-2*J-J^2,-1,
-J^2,J^2,1,1],[19,20,23,33,38,39,42,52,57,-1,-1,1,1,-1,-1,-J^2,J^2,1],[23,38,
39,49,J,1,-J,J],[20,38,39,42,48,49,55,57,-1,J,1,1,-J^2,-1,1,1],[20,52,57,-1,
J^2,1],[23,36,39,42,51,64,1,J,-1,1,-1,-1],[23,38,57,61,J,1,J,1],[20,39,53,55,
57,-1,-J,J,1,1],[20,23,34,38,39,42,55,57,-J+J^2,J,J^2,-J,-J^2,J,J,J-J^2],[19,
20,23,26,38,39,57,-1,-1,1,-1,J+2*J^2,-1,1],[19,23,38,39,55,56,-J+J^2,J,-J,-J,
J^2,J^2],[20,26,38,42,57,60,1,1,-J^2,1,-1,J^2],[58,J],[16,20,36,38,39,42,-J,
-J^2,-1,1,-J,-1],[19,23,38,39,42,55,J,-J,J,J,-J,J],[20,38,50,57,-J,-J,J,J],
[20,24,36,38,39,42,62,1,1,J^2,-J^2,1,J^2,-1],[19,20,45,1,-J^2,1],[20,36,42,51,
55,57,1,J^2,-1,1,-1,-1]],[[12,19,23,34,36,39,48,57,58,60,61,J^2,-J^2,-J,-J^2,
-1,J^2,-1,-J,-1,J,-1],[17,19,23,36,42,48,57,58,60,61,J^2,-J-2*J^2,-J,-1,-1,-2,
-J,-2,-1,2*J^2],[16,19,23,34,38,58,60,61,-J,-1,-J,-J,J,1,J^2,J],[19,34,36,38,
46,48,58,60,61,-J,1,-J,-1,J^2,-1,-1,1,-J],[5,34,36,48,J^2,-J^2,1,J^2],[12,23,
34,35,36,38,40,58,J^2,-J,1,-J^2,J^2,-1,-1,-1],[7,19,36,48,58,60,J^2,-J^2,-1,J,
-1,J],[8,42,47,48,58,60,61,-1,1,-J^2,-J^2,1,1,-J^2],[2,4,19,23,34,36,38,42,48,
57,60,61,J,-J,-J^2,-J,J,-J^2,1,-1,2*J^2,-J,J+2*J^2,J+2*J^2],[23,34,36,37,38,
39,42,48,58,60,61,-1,J^2,-J^2,-1,1,-J^2,-1,J+2*J^2,1,J+2*J^2,-1],[3,19,23,27,
36,38,48,57,60,61,-J,-J,J,J,1,-J,1,J,1,1],[15,19,23,34,48,57,58,60,61,1,1,-1,
1,J,-1,-1,-J^2,1],[4,19,23,36,38,42,48,58,60,J,-J,J,-1,J^2,J,J,-1,J],[19,38,
44,58,61,63,1,-J,J,J,J^2,J^2],[1,19,23,34,36,57,60,J,-J^2,-J,J,J,-J,J],[11,34,
36,37,39,42,48,57,58,60,61,J,1,J^2,-J,-1,-J,-2*J-J^2,J,-1,-2*J-J^2,-2*J-J^2],
[9,13,19,23,34,36,39,42,48,58,60,61,1,1,-J,-1,J^2,J,1,-J^2,J-J^2,-J^2,J-J^2,
J],[29,61,1,1],[36,48,58,60,-1,J,-1,J],[19,23,38,42,48,52,60,61,J,-J,J,-J,-J,
1,-J,1],[19,34,36,38,42,53,58,60,61,62,J^2,1,-J,-1,1,-1,1,1,J,-J],[14,19,38,
58,61,J,1,-J,J,J^2],[19,34,36,38,42,48,58,60,61,64,1,J,J,-J,J,J,J,2*J,-1,J],
[20,30,36,42,48,58,60,-1,1,-1,J,J,-1,J],[19,25,32,36,38,48,58,60,61,1,-1,J^2,
-1,J^2,J-J^2,-1,J-J^2,-J^2],[26,34,38,39,42,48,58,J,1,-1,J,J,-1,-1],[10,34,48,
57,61,-J^2,-J,-J^2,J,-J^2],[1,6,19,23,38,42,48,58,60,61,J,-J,J,-J,-J^2,-J,
-2*J-J^2,-2*J-J^2,-J,1],[19,34,39,58,60,61,63,J,-1,-J^2,-J,-1,-J^2,1],[19,23,
33,38,42,48,52,58,60,61,J,-J,J,J,-J+J^2,-2*J,1,-J,-J+J^2,1],[36,42,43,48,60,
61,1,-1,-1,J^2,J^2,J^2],[19,25,34,36,38,48,60,61,J,-J,-J,J^2,-J^2,-1,J^2,J^2],
[24,34,42,48,58,60,J^2,J^2,J^2,-1,-J,J^2],[36,48,1,J],[19,23,28,38,39,42,48,
57,60,61,1,-1,1,-J,J,-1,J,-1,-1,J],[48,55,61,1,-J,1],[27,36,J,1],[19,34,36,38,
51,58,60,64,1,J,-J^2,-J,J,J,-J^2,J],[36,58,1,1],[19,34,36,48,58,60,61,J^2,J^2,
1,-J^2,-J-2*J^2,-J,-1],[23,34,36,38,42,48,57,58,59,60,61,J^2,-J,J^2,J-J^2,J^2,
2*J^2,1,-1,1,-J+J^2,-2*J+J^2],[19,42,48,56,58,60,61,J^2,-J,1,J^2,1,-J,-J^2],
[31,34,42,43,60,61,1,-1,J,-1,-1,-1],[18,19,22,38,58,61,-J,1,J,-J,J,J^2],[21,
36,38,42,48,60,61,-J,1,1,-1,J^2,J^2,J^2],[13,19,34,38,39,48,57,58,60,61,1,-1,
J^2,-J^2,1,J^2,1,1,J^2,J^2],[8,19,34,42,48,58,61,J,J,J,1,-2*J-J^2,-J,-J^2],
[48,J],[19,34,36,38,39,42,48,49,58,60,61,J,J^2,1,-J^2,1,-J,1,J,1,-J,1],[34,38,
39,48,50,58,61,J,-J,J^2,-J,J,1,-1],[19,39,42,48,57,60,61,-J^2,-J^2,-J,2,J,1,
2],[39,48,53,58,J,J,-J,J],[20,36,48,57,58,61,-J^2,1,J,J^2,1,J],[19,36,42,48,
54,58,60,61,J^2,J,-J^2,-J^2,J,J-J^2,-J^2,-1],[19,39,48,58,60,61,-1,J,-J,1,J^2,
J],[19,36,39,42,60,61,J^2,1,J^2,-1,-J,J^2],[19,23,34,38,42,58,60,61,-J^2,-J,1,
J,-J,-1,1,-2*J-J^2],[39,40,48,61,-1,1,-1,J],[19,23,34,38,41,42,48,57,59,60,61,
1,J,J,-J+J^2,-1,J,2*J,J^2,-1,2*J,2*J],[19,39,48,60,-J^2,-J^2,J^2,-1],[19,34,
39,58,60,61,-J,1,J^2,J,1,J^2],[19,20,38,39,42,45,48,57,58,60,61,-J^2,J,1,-J,
-1,J,-2,-J,-1,-1,2*J^2],[18,1],[34,36,38,39,42,48,57,58,60,61,J,-1,-J,J^2,J,
-1,-J,-1,2*J+J^2,-2]],[[32,38,49,52,57,58,60,61,-1,-1,-J,1,J,-J,1,2],[20,25,
32,43,44,45,49,58,60,61,J,J,-1,1,J^2,J,-J,-2*J,1,2],[23,25,32,38,57,J,-J,1,1,
J],[20,25,32,38,52,57,58,61,J,J,-1,J,-1,-J,-J,1],[38,44,48,58,60,61,63,-1,1,
-1,1,-1,J,J],[32,36,38,48,57,60,61,64,-1,J,J,1,J,1,2,J],[25,32,58,61,J,-1,J^2,
1],[42,43,58,61,-1,-1,-1,J^2],[25,31,32,38,43,44,48,49,52,57,58,61,-J,J,1,J^2,
1,-J,-1,-J,1,J,2,J],[16,25,32,34,38,43,44,48,52,57,58,60,61,64,1,J^2,1,1,1,1,
J^2,-1,J^2,1,-2*J-J^2,J^2,-2,1],[39,48,49,52,57,58,61,-J,1,J,-1,-J,J,-1],[25,
32,38,40,48,49,52,57,58,61,J,-1,J,1,J,-1,J^2,1,J^2,1],[25,32,43,44,57,58,61,J,
-1,-J,-1,-J,J^2,1],[44,J^2],[19,38,49,52,57,60,61,-J,J^2,-J,1,J,1,1],[16,32,
38,43,44,48,49,58,60,61,64,J,-1,J,J,1,1,J,J-J^2,1,-J,J],[25,38,43,44,46,52,56,
57,58,60,61,64,J,1,J^2,2*J+J^2,J,J^2,1,1,J+2*J^2,-J,-J+J^2,1],[18,J^2],[25,32,
44,55,58,60,61,J,-1,-1,J,J^2,1,1],[43,44,50,57,58,J,1,J,J,-J^2],[38,43,J,-1],
[22,J^2],[26,38,43,44,52,58,60,61,J,J^2,-J,-1,1,J^2,1,1],[24,32,43,44,48,53,
58,60,61,62,-1,-1,-J,-1,1,J^2,J^2,1,-2*J-J^2,1],[25,32,44,48,58,60,61,J,-1,-1,
1,J+2*J^2,1,2],[27,32,38,43,58,61,64,J,-1,J,-J,-J,1,J],[23,38,48,49,52,58,J,1,
1,J,-1,-1],[25,32,43,44,52,57,58,61,-J,1,J,1,1,J,J-J^2,-1],[5,32,38,61,J,1,-J,
J],[8,43,44,50,57,58,61,1,J-J^2,1,J,J,-2*J^2,J],[21,33,43,44,58,60,61,J^2,J,1,
-J,1,-1,J],[38,44,48,58,60,-J^2,-J,J,-J,J],[9,25,38,43,44,52,57,58,61,64,J,J,
1,-J^2,J^2,-1,-J,-J,J,-J],[10,16,25,34,52,57,58,60,61,64,-1,J^2,J,-1,J,J^2,
J^2,-1,J,J^2],[35,43,44,49,58,61,64,J,1,J^2,-1,J^2,J,-1],[58,J],[48,52,1,-1],
[38,J^2],[32,51,60,61,64,1,-J,-1,-1,-J],[12,25,32,38,40,52,57,58,60,61,64,-1,
1,-J-2*J^2,1,-1,J,J^2,-1,-1,J+2*J^2,J^2],[25,32,38,43,44,48,49,52,54,57,58,59,
61,64,J,-1,-J^2,-J^2,-J,J^2,1,J,1,1,2,-J,-J,-J^2],[20,30,43,58,61,1,-1,J,J,
-1],[21,38,43,J^2,-J,-J],[14,44,-1,-J],[25,32,43,44,47,58,60,61,-J,1,1,-J,-J,
1,-1,-1],[32,38,46,48,49,58,60,61,64,1,1,J,-1,1,1,-1,-1,1],[2,4,25,32,38,43,
44,52,57,58,61,64,-J,J,-J,1,J^2,-1,-J^2,1,J,J-J^2,-1,J],[1,52,57,58,64,-J^2,J,
J^2,J^2,J^2],[1,6,32,38,43,44,52,60,61,64,J,-J,1,1,J,1,-1,-1,-1,-J],[4,25,32,
38,52,58,61,J,-J,1,J^2,1,-J^2,-1],[11,37,43,44,48,49,57,58,64,J,-J,J,1,1,J,J,
2*J,J],[13,25,32,52,57,58,J^2,-J^2,J,J,J^2,J^2],[32,48,49,53,58,60,61,64,1,-1,
J^2,J,J^2,-1,-1,J^2],[25,32,41,43,44,52,54,57,58,59,60,61,64,1,J-J^2,-1,J^2,J,
1,-1,J^2,-1,-1,-J,-J+J^2,1],[15,25,32,52,57,58,61,64,-J,-J,1,1,J,-J^2,-1,J],
[17,25,43,46,52,56,57,60,64,-1,1,1,1,J,-1,J^2,-1,J^2],[25,28,32,38,43,44,52,
61,J,J,-1,J,J,1,-1,1],[36,58,-J,-J],[38,43,44,49,58,59,61,64,J^2,-J,-1,J^2,
2*J^2,J,-J^2,J^2],[3,25,27,44,52,57,58,64,J^2,J^2,-J^2,-J,-J,-J^2,1,-J^2],[7,
25,32,38,61,J^2,-J^2,J,J,-J],[24,43,44,49,53,58,61,64,-1,1,J^2,-J,-1,-2*J,1,
-J],[29,61,J,J],[32,37,38,43,44,49,52,58,60,61,-1,J,J^2,-J,-1,-J,1,-J,1,1]]],
x->List(x,y->expand(y,64)));
  elif i=93 then r:=J^2*f(91);
  elif i=94 then r:=J*f(91);
  elif i=95 then r:=J*f(92);
  elif i=96 then r:=J^2*f(92);
  elif i=97 then r:=List(
[[[29,J],[1,-J],[3,J],[32,-J],[19,-J],[3,6,7,8,12,16,19,29,30,
31,33,34,35,36,38,39,42,43,50,71,J^2,-J,J,1,J,-J,-1,J,
J^2,J,J,J,J,-J^2,J,-J,-J,J,-J,J],[49,
J],[35,J^2],[9,J],[10,J],[11,J],[3,6,8,19,34,36,39,40,42,43,71,
J^2,-J,1,-1,J,-J^2,-J,J^2,-J,J,J],[3,4,7,9,10,13,
15,18,21,25,27,30,32,34,37,40,42,43,46,50,51,53,59,61,63,64,66,75,78,-J,-1,
-1,-1,1,1,-J^2,1,J,J,-J^2,-J,-J,J^2,1,1,1,J^2,1,1,
-J,J^2,1,1,-J,-1,J,1,-J],[14,J],[15,J],[2,19,37,38,47,52,
1,J,J,-J,J,1],[17,J],[14,18,36,46,61,75,-J^2,-J,J^2,
J^2,J^2,J^2],[31,-J^2],[33,J],[21,J],[3,6,7,8,12,16,18,19,
22,29,30,31,33,34,35,38,39,42,43,46,50,61,71,75,J,J,1,J^2,1,-1,-1,
-J^2,1,1,J,1,1,1,1,1,-1,-1,1,J,-1,-1,1,-1],[8,15,23,25,27,35,37,64,
J,-1,1,1,J^2,-1,-1,1],[3,5,19,24,25,31,36,39,46,69,74,78,1,1,-1,-J,
J,J,J,J^2,-1,J^2,-J^2,1],[25,J],[27,1],[37,64,J,
-J],[1,2,3,10,15,16,19,20,28,37,38,41,44,47,63,71,78,1,J^2,-1,-1,1,1,1,
1,-J,1,-1,-J^2,J^2,1,-J^2,-1,J^2],[2,-J],[1,2,3,11,15,25,26,
27,29,30,34,37,64,75,-1,1,-J,J^2,-J^2,-1,-1,-J^2,-1,-J,-1,
-J^2,J^2,1],[5,1],[1,2,3,4,9,15,25,26,27,29,32,37,64,78,1,-1,-1,J,
J,-J,-J^2,-J^2,-J,1,-J,-J,J,J^2],[37,-J^2],[30,
J^2],[8,15,20,21,25,26,27,33,35,37,39,64,75,-1,-J,J^2,-J^2,
-J^2,-J^2,-J,J^2,-J,J^2,J,J,J^2],[36,J],[20,-1],
[38,52,-J,1],[39,J],[42,-1],[28,1],[3,36,39,40,42,J^2,-J^2,-J,
J^2,-J],[50,-J],[51,-1],[1,5,9,10,11,16,20,29,31,33,36,38,44,45,46,
47,48,59,63,71,-J,1,J,J,J^2,1,-J,J^2,J,J^2,J,-1,
J^2,-J,-1,1,-J^2,J,-J^2,-1],[46,J],[1,20,31,44,63,71,
-J^2,-J^2,J^2,1,-1,-J],[45,1],[44,63,1,-1],[11,17,21,43,50,1,
-J,-J^2,J,-J],[7,10,14,17,25,39,49,51,59,63,-1,-J,-J,-1,
-J^2,-1,-1,-J,-J,J^2],[38,-J^2],[66,-J^2],[7,10,14,39,44,49,
51,54,57,62,-J^2,J^2,J^2,J,J^2,1,J^2,1,-1,-J],[9,46,53,
55,66,J,J^2,J,1,1],[11,21,43,50,56,1,J,-1,-J,1],[7,14,25,39,44,
49,57,59,62,63,J,1,1,-1,1,J,-J,-1,1,-1],[65,68,-J,-J^2],[59,
J],[1,2,4,9,11,15,25,26,27,30,32,34,37,60,64,75,J,1,J,-J^2,-1,1,
J,J,1,J^2,J^2,-1,1,1,-1,1],[18,-1],[57,-J^2],[7,51,-J^2,-1],
[20,26,-1,-J^2],[3,4,6,8,12,19,22,23,34,36,39,40,42,71,76,80,-1,-J^2,
-J,1,-1,-1,J^2,J^2,J,1,J^2,-1,J^2,1,J^2,-1],[9,10,46,53,
66,1,-1,-1,1,-J],[68,J^2],[3,8,19,34,36,39,40,42,43,71,72,-1,-J,J,
1,1,J^2,-1,J^2,1,1,1],[36,39,40,42,69,-1,1,1,1,1],[1,2,3,4,6,7,8,9,10,
11,12,14,17,19,20,22,23,25,27,30,32,33,34,35,39,43,49,50,51,56,59,60,63,65,66,
68,73,77,78,79,-1,-J^2,J^2,J,-J,1,-J^2,J,J,-1,-1,J,2,
J^2,-1,-1,-1,J^2,1,-ER(-3),J^2,J^2,-2,J^2,(3+ER(-3))/2,
(-3-ER(-3))/2,1,1,J,J,J,-J^2,-J^2,J,J^2,-J,J,-J,
-1,-1],[7,16,29,33,38,J,-J,J,J,J],[7,16,29,30,31,33,35,38,40,
50,67,-J,J,-J,-J^2,1,-J,1,-J,-J,J,J],[2,7,9,11,14,
15,16,17,19,21,29,33,37,38,43,47,49,50,56,71,73,77,-J,-1,1,J^2,1,1,1,-1,
1,1,-1,-1,-J^2,-1,-J^2,1,-1,-1,-J,-1,-J,J],[24,36,39,40,42,69,
1,-1,1,1,1,1],[75,J],[3,4,9,18,20,27,31,33,35,40,42,51,53,60,61,67,70,71,
73,75,1,1,1,-J^2,1,-1,-1,-J^2,J,-J^2,-J^2,1,1,J^2,-J^2,
J^2,1,J^2,1,1],[56,73,1,-J],[78,J],[80,-J],[4,7,9,15,16,18,19,
20,22,23,25,27,29,30,32,34,35,36,37,38,39,40,43,46,51,53,58,60,61,64,67,70,73,
J^2,J,J^2,-J^2,-J,1,1,J^2,J^2,J^2,J^2,ER(-3),J,
1,1,-J,1,-J,-J^2,J,J,-J^2,-J,1,J^2,J^2,J^2,J,
1,J^2,-1,J^2,J^2]],[[30,J^2],[11,1],[1,1],[4,J],[38,1],[6,
J],[5,16,29,33,38,1,1,J^2,J^2,-1],[8,J],[1,2,4,9,11,29,30,32,34,
75,78,-1,1,1,1,-1,-1,J^2,-1,J,-J,J],[70,J],[1,2,3,11,15,25,26,
27,29,30,34,37,64,75,J^2,-J^2,1,-J,J,J^2,J^2,J,J^2,1,
J^2,J,-J,-J^2],[19,-1],[13,28,-J,J],[6,14,18,22,36,46,61,-1,
1,J^2,J,J^2,J^2,J^2],[8,15,23,25,26,27,J^2,1,J,-1,-1,1],
[7,1],[1,2,3,5,8,12,15,17,19,20,25,26,27,29,30,33,34,35,37,39,42,43,47,49,50,
64,75,J,1,J^2,-1,1,J,-J^2,-J,J,-J^2,-1,-1,-J^2,J,
J^2,-J^2,J,J,-J^2,-J,-J,J,J,-J,-J,J^2,1],
[18,J],[43,-J^2],[35,-1],[8,15,20,21,25,26,27,33,35,37,39,64,75,-J^2,
-1,J,-J,-J,-J,-1,J,-1,J,1,1,J],[22,J],[23,J],[44,
1],[26,-1],[8,15,23,25,27,37,64,-J,1,-1,-1,-J^2,1,-1],[27,J],[13,
-J],[29,J],[3,J],[31,40,-J,J^2],[78,J],[33,J],[34,J],
[39,-J],[1,20,31,52,71,1,-J,-1,1,-1],[21,1],[7,16,29,33,38,1,-1,1,1,1],
[20,J^2],[31,-1],[1,3,9,10,18,35,40,41,42,44,46,51,53,60,61,63,66,67,70,73,
75,J^2,-J^2,1,J,J,-1,J,1,J,-1,J,-J^2,1,-J,J,1,
J^2,-J,-J^2,-J^2,-J^2],[52,-J],[12,J],[4,7,9,15,16,18,19,
20,22,23,25,27,29,30,32,34,35,36,37,38,39,40,43,46,51,53,58,60,61,64,67,70,73,
1,J^2,1,-1,-J^2,J,J,1,1,1,1,(-3-ER(-3))/2,J^2,J,J,
-J^2,J,-J^2,-1,J^2,J^2,-1,-J^2,J,1,1,1,J^2,J,1,
-J,1,1],[55,1],[1,20,31,52,61,71,-1,J,1,-1,-1,1],[56,J^2],[2,3,4,7,9,
11,15,16,18,19,20,23,25,27,29,30,32,34,35,36,37,38,39,40,43,44,46,48,51,53,58,
60,61,64,67,70,73,78,J^2,1,(3-ER(-3))/2,J^2,(3-ER(-3))/2,-J^2,-1,
-J^2,J,J,1,1,1,(-3-ER(-3))/2,-1,ER(-3),ER(-3),(3+ER(-3))/2,J,
-J^2,-1,J^2,J^2,-1,-J^2,-1,J,1,1,1,1,2*J^2,J,1,-J,1,1,
1],[11,17,43,50,56,J^2,J,1,J,J^2],[5,42,1,J],[53,J],[7,16,
29,33,38,50,J,-J,J,J,J,-J],[2,3,4,7,9,11,16,18,27,30,32,34,
38,42,50,51,52,53,60,78,-1,-J,J^2,-1,J^2,1,1,1,J,1,1,-J,-1,1,1,
-J,-1,-J,-1,-J],[6,22,27,33,47,54,56,66,73,J^2,J,J^2,-1,1,1,
-J^2,-1,1],[45,55,-J^2,-J],[1,3,8,11,12,17,19,20,29,30,33,34,35,39,
43,47,49,50,68,J,J^2,-J^2,J,J,1,-1,J,J,J^2,J,J,
-1,1,-1,-1,1,1,-J],[7,10,14,17,25,39,44,49,51,54,57,62,63,ER(-3),-J,
-ER(-3),J,-J,J,-J,-J^2,J^2,-J^2,J^2,-J,-1],[74,
-J],[1,2,4,7,9,14,16,17,19,20,23,25,26,27,29,30,32,33,34,35,38,39,43,47,49,
50,51,58,60,71,73,75,77,-1,-J^2,J,(3+ER(-3))/2,J,-1,-1,1,-1,J,
J,-1,-1,1,1,J^2,J^2,-J^2,-1,-1,1,1,-1,-1,1,-J,J,J,1,1,
J,-J^2,-J],[9,J^2],[6,18,22,36,46,61,75,-1,-J,J,J^2,
J^2,-J,-J],[1,2,4,5,7,9,10,11,15,16,18,20,23,25,27,30,32,33,34,37,38,
40,43,44,46,53,58,60,61,62,63,64,66,67,71,75,J,1,J,-J,-J^2,J,1,
-1,1,J^2,1,J,J,J,1,J^2,J^2,J,-1,1,-J^2,1,J^2,1,1,
-1,J,1,1,1,J^2,-1,J,J,-J,1],[3,4,6,7,8,9,12,15,16,18,20,22,23,
25,27,29,30,32,33,36,37,38,42,46,50,51,53,58,60,61,64,70,71,73,1,1,-J^2,
-ER(-3),J,1,J^2,-1,ER(-3),J,1,1,1,1,(-3-ER(-3))/2,-ER(-3),-J^2,
J,-J,J,-1,-ER(-3),-J^2,J,J,1,1,1,J^2,J,1,1,J^2,1],
[15,21,1,1],[7,10,14,17,25,39,51,59,63,1,J,J,1,J^2,1,J,J,
-J^2],[73,1],[69,-1],[49,-1],[1,20,44,52,63,71,1,1,J^2,-J^2,-J^2,
-1],[3,5,6,7,8,12,16,18,22,24,25,29,30,33,34,35,36,38,39,42,43,46,50,51,60,61,
69,71,74,75,78,79,ER(-3),-J^2,J,1,J^2,1,-1,-1,1,1,-1,1,J,1,1,1,-1,
1,J^2,-1,1,-1,-1,J,1,-1,-J,1,J,-1,-J^2,1],[3,6,8,12,19,34,36,
39,40,42,43,71,-J^2,J,-1,-J,1,-J,J^2,J,-J^2,J,-J,
-J],[3,8,19,34,36,39,40,42,43,71,72,-1,-J,J,1,1,J^2,-1,J^2,1,1,
1],[79,-1],[2,4,9,10,11,15,25,27,30,32,34,37,38,40,43,46,52,53,60,61,63,64,66,
75,J,J^2,J^2,J,-J,J,J^2,J,1,1,-J,J,J,J,1,
J,J,-J,J,J,-J^2,-J,J^2,J],[75,J],[3,4,6,8,12,19,
22,23,34,36,39,40,42,43,71,72,76,80,-J,J,1,ER(-3),J^2,-ER(-3),-J,
-J,-2,J,1,-J,1,-1,J,-1,-J,J^2],[65,-J],[1,2,4,9,11,15,25,
26,27,30,32,34,37,60,64,75,-1,1,J,-J^2,-1,1,J,J,1,J^2,J^2,
-1,1,1,-1,1],[66,-1],[72,76,J,-1]],[[1,J],[2,J],[9,J],[1,2,4,9,11,
29,30,32,34,75,78,-1,1,1,1,-1,-1,J^2,-1,J,-J,J],[5,16,29,33,38,1,
1,J^2,J^2,-1],[24,36,39,40,42,69,1,-1,1,1,1,1],[7,J],[1,2,3,10,15,16,
19,20,28,37,38,41,44,47,63,71,78,-1,-J^2,1,1,-1,-1,-1,-1,J,-1,1,J^2,
-J^2,-1,J^2,1,-J^2],[75,J],[14,J],[15,25,26,27,37,64,1,J,
J,1,1,-1],[5,16,28,29,32,33,38,53,64,74,J^2,J^2,-1,J,-J^2,J,
-J^2,-J^2,J^2,-J],[11,21,43,50,56,J,J^2,-J,-J^2,J],
[39,1],[15,21,-J,-J],[7,16,29,33,38,J,-J,J,J,J],[25,1],
[42,J],[47,-1],[1,20,44,52,63,71,-J,-J,-1,1,1,J],[15,J],[24,
J^2],[1,2,3,4,7,9,10,13,16,18,19,20,21,25,27,28,30,32,34,37,38,40,41,42,43,
44,46,47,50,51,53,59,61,63,64,66,71,75,J,1,J^2,-J^2,-J^2,-J^2,
-ER(-3),J^2,J,J^2,J,J,1,1,-J,-J^2,-1,-1,J,-1,-J,
J^2,-1,J^2,J,1,J^2,J,J^2,-1,J,J^2,J^2,-2,-J^2,1,
-J,J^2],[48,J],[59,1],[2,4,9,10,11,15,25,27,30,32,34,37,38,40,43,46,
52,53,60,61,63,64,66,75,1,J,J,1,-1,1,J,1,J^2,J^2,-1,1,1,1,
J^2,1,1,-1,1,1,-J,-1,J,1],[2,3,4,7,9,11,18,27,30,32,34,38,42,50,51,
52,53,60,78,1,J,-J^2,1,-J^2,-1,-1,-J,-1,-1,J,1,-1,-1,J,1,
J,1,J],[2,7,9,11,14,15,16,17,19,21,29,33,37,38,43,47,49,50,56,71,73,77,
J,1,-1,-J^2,-1,-1,-1,1,-1,-1,1,1,J^2,1,J^2,-1,1,1,J,1,J,
-J],[29,J],[4,J],[1,20,31,44,63,71,-1,-1,1,J,-J,-J^2],[4,34,
1,J],[16,-J],[1,2,3,4,9,15,25,26,27,29,32,37,64,78,-J,J,J,
-J^2,-J^2,J^2,1,1,J^2,-J,J^2,J^2,-J^2,-1],[41,-J],
[46,J],[2,19,37,38,47,52,J^2,1,1,-1,1,J^2],[38,J],[10,J^2],[9,
10,46,53,66,-J,J,J,-J,J^2],[73,-1],[53,-J^2],[26,-1],[44,
J],[3,6,7,8,12,16,18,19,22,29,30,31,33,34,35,38,39,42,43,46,50,61,71,75,
J,J,1,J^2,1,-1,-1,-J^2,1,1,J,1,1,1,1,1,-1,-1,1,J,-1,-1,1,
-1],[36,46,-J,-J],[2,19,38,47,49,52,-1,J^2,-J^2,-J,J,J],
[22,1],[49,J],[27,J^2],[51,J],[52,J],[18,-1],[57,-J],[6,18,22,
36,46,61,75,1,J,-J,-J^2,-J^2,J,J],[8,15,23,25,27,37,64,J,
-1,1,1,J^2,-1,1],[7,10,14,39,44,49,51,54,57,-1,1,1,J^2,1,J,1,J,
-J],[1,2,4,7,9,11,13,15,20,21,23,27,28,30,32,33,34,35,39,51,58,60,64,1,-1,
-J,J^2,J^2,1,-J^2,-1,1,-1,1,-1,J^2,-J^2,-J^2,1,1,-J^2,
J^2,-J,1,-1,-J],[17,1],[60,J],[40,J],[7,14,25,39,44,49,54,57,
59,62,63,J,1,1,-1,1,J,-1,-J,-1,1,-1],[63,J],[3,7,10,11,18,19,21,
25,37,38,40,42,43,46,47,50,51,59,60,61,63,64,66,75,J,1,J,J^2,-1,1,
-J,J^2,-J^2,J,J,-1,1,J,1,-1,J,J,-J^2,J,-J^2,
-J,J^2,J],[1,2,3,4,6,7,8,9,10,11,12,13,14,15,17,18,19,20,21,22,23,27,
30,32,33,34,37,39,40,41,42,43,44,46,50,51,53,60,61,63,64,65,66,68,75,78,79,
-J,-1,2+ER(-3),-ER(-3),-J^2,J^2,-1,-ER(-3),J,1,-J,J,J^2,
-1,-1,ER(-3),1,-J,J^2,-J,1,(-3+ER(-3))/2,2+ER(-3),(3+ER(-3))/2,1,
2-ER(-3),J,(-3+ER(-3))/2,ER(-3),1,ER(-3),(3-ER(-3))/2,-1,ER(-3),J,1,
(3-ER(-3))/2,J^2,ER(-3),1,-J,-J,J^2,J,ER(-3),1,-J],[14,18,
36,46,61,75,-1,-J^2,1,1,1,1],[1,3,9,10,18,35,40,41,42,44,46,51,53,60,61,63,
66,67,70,73,75,J^2,-J^2,1,J,J,-1,J,1,J,-1,J,-J^2,1,
-J,J,1,J^2,-J,-J^2,-J^2,-J^2],[2,3,4,6,8,9,11,12,14,15,
16,18,19,22,23,27,28,29,30,32,33,34,37,38,39,40,42,43,46,47,49,53,61,65,71,75,
78,79,J,-J^2,J^2,J,-1,J^2,1,1,J^2,-1,-1,J,J,1,1,-1,
J,-J^2,-J^2,1,-J^2,(3-ER(-3))/2,-1,1,-1,J,J,1,J,-1,1,1,
J,-J,1,J,1,1],[9,46,53,55,66,J,J^2,J,1,1],[67,1],[20,-J],
[76,-1],[35,J^2],[1,5,9,10,11,16,20,29,31,33,36,38,44,45,46,47,48,53,55,59,
63,66,71,-J^2,J,-1,J^2,1,J,-J^2,1,J^2,1,J^2,-J,1,
-J^2,-ER(-3),J,-1,J,1,J^2,-1,1,-J],[3,J],[72,76,J^2,
-J],[23,1],[11,J^2],[3,5,6,7,8,12,16,18,22,24,25,29,30,33,34,35,36,38,
39,42,43,46,50,51,60,61,69,71,74,75,78,79,ER(-3),-J^2,J,1,J^2,1,-1,
-1,1,1,-1,1,J,1,1,1,-1,1,J^2,-1,1,-1,-1,J,1,-1,-J,1,J,-1,
-J^2,1],[3,4,5,6,7,8,9,10,11,12,15,18,19,20,22,25,26,27,29,32,33,34,35,36,
37,42,43,46,47,50,51,59,60,61,63,64,69,74,80,J,-1,-J^2,J,1,J^2,
J,J,J^2,1,1,-1,1,-J,-J^2,-1,J,1,1,-J,-J,-J,1,-1,1,
-1,1,-1,1,-1,J,J,-J^2,-1,-J^2,-1,-J,J,1]],[[1,20,31,52,71,
-J,J^2,J,-J,J],[2,19,38,47,49,52,1,-J^2,J^2,J,-J,
-J],[36,-J],[22,-J],[5,J],[8,-1],[16,1],[34,J^2],[14,17,J,
1],[10,59,-J,-J],[17,-J^2],[12,J],[55,-J^2],[15,J],[9,11,
J,J^2],[5,16,29,33,38,1,1,J^2,J^2,-1],[21,J^2],[27,J^2],[19,
J],[1,-1],[11,-J^2],[23,J],[4,-J],[69,74,J,J^2],[3,78,1,1],
[2,4,9,11,15,25,26,27,30,32,34,37,60,64,75,-1,-J,J^2,1,-1,-J,-J,
-1,-J^2,-J^2,1,-1,-1,1,-1],[2,3,4,9,11,30,32,34,60,78,-1,-J,J^2,
J^2,1,1,1,-J,-1,-J],[45,1],[5,7,16,33,38,1,J,-J,-1,-1],[3,6,7,
8,12,16,19,29,30,31,33,34,35,36,38,39,42,43,50,71,-J,1,-1,-J^2,-1,1,
J^2,-1,-J,-1,-1,-1,-1,J,-1,1,1,-1,1,-1],[31,J],[3,6,7,8,12,16,18,
19,22,29,30,31,33,34,35,38,39,42,43,46,50,61,71,75,J,J,1,J^2,1,-1,-1,
-J^2,1,1,J,1,1,1,1,1,-1,-1,1,J,-1,-1,1,-1],[29,-1],[6,-J],[30,
J^2],[39,1],[2,-J^2],[38,J],[3,-J^2],[40,J],[48,1],[42,J],
[43,J],[1,2,4,9,10,11,15,20,25,27,30,32,34,37,38,40,43,44,46,53,60,61,63,
64,66,71,75,J,1,J,J,1,-1,1,J,J,1,J^2,J^2,-1,1,1,1,J^2,
1,1,-1,1,1,J^2,-1,J,-J,1],[57,J^2],[25,39,-J^2,-1],[49,1],[62,
-1],[2,19,37,38,47,52,J^2,1,1,-1,1,J^2],[50,J],[2,3,4,7,9,11,16,18,
27,30,32,34,38,42,50,51,52,53,60,78,-1,-J,J^2,-1,J^2,1,-J^2,1,
J,1,1,-J,-1,1,1,-J,-1,-J,-1,-J],[52,J],[7,51,1,J],[1,2,3,
4,7,9,10,13,15,16,18,19,20,21,25,27,28,30,32,34,38,40,41,42,43,44,46,47,50,51,
53,59,61,63,64,66,71,75,78,-1,-J^2,(3-ER(-3))/2,-1,-1,-1,2,1,J,-1,1,-1,
-1,J,J,-J^2,J,-J,-J,J^2,1,1,J^2,1,J^2,-J^2,1,-1,
1,-J,J^2,1,1,-ER(-3),-1,J,1,1,1],[7,10,14,17,25,39,44,49,51,54,57,62,
63,(3-ER(-3))/2,-1,(-3+ER(-3))/2,1,-1,1,-1,-J,J,-J,J,-1,-J^2],
[11,17,43,50,56,1,J^2,J,J^2,1],[28,J],[3,4,7,9,16,18,20,27,29,30,
31,38,42,50,51,53,60,61,70,71,73,75,J,J,1,J,-1,-1,J,-J,1,J,
1,1,-1,-1,J,J,1,-1,J,1,J,J],[10,J],[2,14,18,19,36,38,46,47,
49,52,61,75,-1,1,J^2,J^2,-1,-J^2,-1,-J,J,J,-1,-1],[26,
-J^2],[41,-1],[2,4,9,10,11,15,25,27,30,32,34,37,38,40,43,46,52,53,60,61,63,
64,66,75,1,J,J,1,-1,1,J,1,J^2,J^2,-1,1,1,1,J^2,1,1,-1,1,1,
-J,-1,J,1],[60,J^2],[2,3,4,5,6,8,9,11,12,14,15,18,19,22,23,27,30,32,
34,37,39,40,42,43,46,47,49,61,64,65,71,75,78,79,J,-J^2,J^2,1,J,-1,
J^2,1,1,J^2,-1,J,J,1,1,-1,-J^2,-J^2,(3-ER(-3))/2,-1,-1,J,
J,1,J,-1,1,J,-J,-J,1,J,1,1],[7,10,14,17,25,39,51,59,63,
J^2,1,1,J^2,J,J^2,1,1,-J],[7,16,29,30,31,33,35,38,40,50,67,-1,
1,-1,-J,J^2,-1,J^2,-1,-1,1,1],[1,2,3,5,8,17,19,20,21,29,30,33,34,35,
37,39,42,43,47,49,50,68,J^2,J,1,1,-1,-J^2,J^2,J^2,J,J^2,
1,J^2,J^2,-J,J^2,J,J,J^2,J^2,-J^2,-J^2,1],[3,39,
40,42,69,J^2,1,-J,-J,1],[1,2,4,7,9,14,16,17,19,20,23,25,26,27,29,30,
32,33,34,35,38,39,43,47,49,50,51,58,60,70,71,73,75,77,1,J^2,-J,
(-3-ER(-3))/2,-J,1,1,-1,1,-J,-J,1,1,-1,-1,-J^2,-J^2,J^2,1,1,
-1,-1,1,1,-1,J,-J,-J,-1,-J,-1,-J,J^2,J],[71,J],[3,6,
19,34,36,39,40,42,43,71,72,J,J,-J^2,1,-J,-1,J,-1,-J,-J,
1],[77,-J],[3,5,19,24,25,31,36,39,46,69,74,78,J^2,J^2,-J^2,-1,1,1,
1,J,-J^2,J,-J,J^2],[15,25,26,27,37,64,J,J^2,J^2,J,
J,-J],[80,-J^2],[2,7,9,11,14,15,16,17,19,21,29,33,37,38,43,47,49,50,
71,73,77,J,1,-1,1,-1,-1,-1,1,-1,J,1,1,J^2,1,-1,-1,1,-J,1,J,
-J],[46,-J],[65,-J^2],[3,4,6,8,12,19,22,23,34,36,39,40,42,71,76,80,
-J,-1,-J^2,J,-J,-J,1,1,J^2,J,1,-J,1,J,1,-J]]]
,x->List(x,y->expand(y,80)));
  elif i=98 then r:=J*f(97);
  elif i=99 then r:=J^2*f(97);
  elif i=100 then r:=List(
[[[2,1],[1,2,13,18,24,28,34,36,51,53,64,65,76,-1,-1,1,1,1,1,1,1,1,1,1,1,-1],
[6,1],[7,1],[8,1],[14,1],[4,7,9,42,43,45,50,59,60,62,63,69,70,72,74,78,80,-1,
-1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1],[5,8,25,35,41,44,52,58,61,68,71,73,75,-1,
-1,1,1,-1,1,1,1,1,1,1,1,1],[15,1],[16,1],[17,1],[30,35,77,-1,-1,1],[18,1],[3,
1],[26,1],[27,1],[46,72,81,-1,-1,1],[28,1],[29,1],[30,1],[31,1],[32,1],[33,1],
[34,1],[35,1],[9,1],[10,1],[13,1],[46,1],[47,1],[48,1],[49,1],[50,1],[51,1],
[52,1],[53,1],[54,1],[55,-1],[56,1],[57,1],[58,-1],[59,1],[60,-1],[61,1],[62,
1],[19,1],[20,1],[21,1],[22,1],[23,1],[24,1],[25,1],[76,-1],[10,16,19,27,29,
37,46,54,73,-1,-1,-1,-1,-1,-1,-1,-1,1],[38,55,64,1,-1,-1],[66,1],[67,1],[68,
1],[69,1],[70,1],[71,1],[72,1],[15,23,78,-1,-1,1],[64,1],[65,1],[39,1],[40,1],
[41,-1],[42,1],[43,-1],[44,1],[45,1],[73,1],[74,1],[75,1],[36,-1],[79,1],[80,
1],[12,20,25,1,1,1],[9,50,63,1,1,1],[11,19,45,1,1,1]],[[3,1],[9,1],[10,1],[11,
1],[12,1],[15,1],[19,1],[20,1],[21,1],[1,1],[22,1],[23,1],[76,-1],[38,-1],[6,
15,18,-1,-1,-1],[26,1],[29,1],[18,1],[39,1],[40,1],[2,1],[4,1],[5,1],[24,1],
[41,-1],[55,1],[48,1],[64,1],[17,29,62,-1,-1,-1],[77,-1],[14,26,28,-1,-1,-1],
[46,1],[47,1],[65,1],[35,1],[28,1],[39,48,57,-1,-1,-1],[16,31,36,1,1,1],[7,1],
[8,1],[25,35,41,44,52,58,61,68,71,73,75,1,1,-1,1,1,1,1,1,1,1,1],[42,1],[9,42,
43,45,50,59,60,62,63,69,70,72,74,78,80,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1],[44,1],
[43,-1],[80,-1],[10,19,27,29,37,54,73,1,1,1,1,1,1,-1],[27,48,53,-1,-1,-1],[66,
1],[67,1],[34,1],[73,1],[53,1],[1,17,29,33,57,58,62,-1,1,1,1,1,1,1],[16,1],
[81,-1],[79,-1],[52,1],[74,1],[72,1],[75,1],[62,1],[21,56,67,-1,-1,-1],[36,1],
[51,1],[49,66,70,-1,-1,-1],[50,67,68,-1,-1,-1],[68,1],[59,1],[70,1],[61,1],[9,
50,63,78,80,1,1,1,1,1],[58,1],[69,1],[71,1],[13,18,24,28,34,36,51,53,64,65,76,
1,1,1,1,1,1,1,1,1,1,-1],[30,35,77,1,1,-1],[32,56,60,1,1,1],[19,27,37,1,1,1],
[32,-1],[9,50,63,1,1,1]],[[4,1],[7,1],[13,1],[1,4,5,6,15,16,17,18,20,29,31,32,
33,34,36,37,38,49,55,56,57,58,59,60,61,62,63,64,77,-1,-1,-1,1,1,1,1,1,-1,1,1,
1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1],[5,1],[18,1],[2,7,8,14,15,22,23,26,27,
28,30,38,48,49,50,51,53,54,66,67,68,69,70,71,78,79,81,-1,-1,-1,1,-1,-1,-1,1,1,
1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[8,1],[3,1],[10,16,19,27,29,37,46,54,73,
-1,-1,-1,-1,-1,-1,-1,-1,1],[76,-1],[24,1],[9,1],[28,1],[6,1],[37,1],[36,1],
[15,1],[10,1],[42,1],[32,47,55,-1,-1,-1],[43,-1],[12,1],[23,1],[44,1],[14,1],
[54,1],[26,1],[16,1],[59,1],[20,38,49,55,64,-1,-1,-1,1,1],[60,1],[30,35,77,-1,
-1,1],[33,1],[61,1],[63,1],[29,1],[43,59,72,-1,1,1],[22,1],[20,1],[25,-1],[40,
1],[39,-1],[41,-1],[21,1],[27,1],[69,1],[22,30,38,-1,-1,1],[70,1],[47,52,79,
-1,-1,1],[50,1],[71,1],[15,23,78,-1,-1,1],[46,1],[45,60,69,-1,-1,-1],[32,1],
[30,1],[35,1],[57,1],[56,1],[58,1],[31,1],[17,1],[42,43,45,59,60,62,69,70,72,
1,-1,1,1,1,1,1,1,1],[74,1],[49,1],[47,1],[52,1],[67,1],[66,1],[68,1],[48,1],
[73,1],[65,74,75,-1,-1,-1],[75,1],[26,33,80,1,1,-1],[34,59,61,1,1,1],[6,12,46,
72,81,1,1,-1,-1,1],[51,69,71,1,1,1],[11,14,30,35,77,1,1,-1,-1,1],[27,48,53,1,
1,1]],[[5,1],[8,1],[12,1],[1,1],[4,1],[30,35,77,-1,-1,1],[2,1],[7,1],[20,1],
[23,1],[3,1],[11,1],[25,1],[47,52,79,-1,-1,1],[30,1],[33,1],[6,1],[35,1],[9,
1],[19,1],[40,1],[10,1],[22,1],[44,1],[45,1],[47,1],[50,1],[52,1],[15,1],[29,
1],[57,1],[16,1],[32,1],[61,1],[62,1],[58,1],[63,1],[10,29,54,1,1,1],[21,1],
[39,1],[43,1],[24,1],[76,1],[42,1],[13,1],[26,1],[46,1],[67,1],[27,1],[49,1],
[71,1],[72,1],[68,1],[15,23,78,-1,-1,1],[10,19,27,29,37,54,73,1,1,1,1,1,1,-1],
[31,1],[56,1],[60,1],[34,1],[36,1],[59,1],[18,1],[20,38,49,55,64,-1,-1,-1,1,
1],[73,1],[75,1],[48,1],[66,1],[70,1],[51,1],[53,1],[69,1],[28,1],[9,50,63,78,
80,1,1,1,1,1],[65,1],[74,1],[41,1],[17,29,62,1,1,1],[38,1],[81,1],[55,-1],[14,
26,28,1,1,1]]],x->List(x,y->expand(y,81)));
  elif i=101 then r:=J^2*f(100);
  elif i=102 then r:=J*f(100);
  fi;
  fi;
  CHEVIE.G32.CachedRepresentations[i]:=r;
  return r;
end);

CHEVIE.AddData("Invariants","G32",
[function(a,b,c,d)return 
220*a^3*b^3*c^6-220*a^3*b^3*d^6-220*a^3*c^3*d^6-220*b^3*c^3*d^6+
220*a^3*b^6*c^3-220*a^3*b^6*d^3+220*a^3*c^6*d^3-220*b^3*c^6*d^3+
220*a^6*b^3*c^3+220*a^6*b^3*d^3-220*a^6*c^3*d^3+220*b^6*c^3*d^3+22*a^6*b^6+
22*a^6*c^6+22*a^6*d^6+22*b^6*c^6+22*b^6*d^6+22*c^6*d^6+a^12+b^12+c^12+d^12;end,

function(a,b,c,d)return 
-170*a^3*b^3*c^12+170*a^3*b^3*d^12+170*a^3*c^3*d^12+170*b^3*c^3*d^12-
1870*a^3*b^6*c^9+1870*a^3*b^6*d^9-1870*a^3*c^6*d^9+1870*b^3*c^6*d^9-
1870*a^3*b^9*c^6+1870*a^3*b^9*d^6+1870*a^3*c^9*d^6+1870*b^3*c^9*d^6-
170*a^3*b^12*c^3+170*a^3*b^12*d^3-170*a^3*c^12*d^3+170*b^3*c^12*d^3-
1870*a^6*b^3*c^9-1870*a^6*b^3*d^9+1870*a^6*c^3*d^9-1870*b^6*c^3*d^9-
7854*a^6*b^6*c^6-7854*a^6*b^6*d^6-7854*a^6*c^6*d^6-7854*b^6*c^6*d^6-
1870*a^6*b^9*c^3-1870*a^6*b^9*d^3+1870*a^6*c^9*d^3-1870*b^6*c^9*d^3-
17*a^6*b^12-17*a^6*c^12-17*a^6*d^12-17*b^6*c^12-17*b^6*d^12-17*c^6*d^12-
1870*a^9*b^3*c^6+1870*a^9*b^3*d^6+1870*a^9*c^3*d^6+1870*b^9*c^3*d^6-
1870*a^9*b^6*c^3+1870*a^9*b^6*d^3-1870*a^9*c^6*d^3+1870*b^9*c^6*d^3-
170*a^12*b^3*c^3-170*a^12*b^3*d^3+170*a^12*c^3*d^3-170*b^12*c^3*d^3-
17*a^12*b^6-17*a^12*c^6-17*a^12*d^6-17*b^12*c^6-17*b^12*d^6-17*c^12*d^6+a^18+
b^18+c^18+d^18;end,

function(a,b,c,d)return 
-230*a^3*b^3*c^6*d^12+230*a^3*b^3*c^12*d^6-230*a^3*b^6*c^3*d^12+
230*a^3*b^6*c^12*d^3+46*a^3*b^6*c^15-46*a^3*b^6*d^15+46*a^3*c^6*d^15-
46*b^3*c^6*d^15+230*a^3*b^9*c^12-230*a^3*b^9*d^12-230*a^3*c^9*d^12-
230*b^3*c^9*d^12+230*a^3*b^12*c^3*d^6-230*a^3*b^12*c^6*d^3+230*a^3*b^12*c^9-
230*a^3*b^12*d^9+230*a^3*c^12*d^9-230*b^3*c^12*d^9+46*a^3*b^15*c^6-
46*a^3*b^15*d^6-46*a^3*c^15*d^6-46*b^3*c^15*d^6-230*a^6*b^3*c^3*d^12-
230*a^6*b^3*c^12*d^3+46*a^6*b^3*c^15+46*a^6*b^3*d^15-46*a^6*c^3*d^15+
46*b^6*c^3*d^15+1518*a^6*b^6*c^6*d^6+943*a^6*b^6*c^12+943*a^6*b^6*d^12+
943*a^6*c^6*d^12+943*b^6*c^6*d^12+2530*a^6*b^9*c^9+2530*a^6*b^9*d^9-
2530*a^6*c^9*d^9+2530*b^6*c^9*d^9+230*a^6*b^12*c^3*d^3+943*a^6*b^12*c^6+
943*a^6*b^12*d^6+943*a^6*c^12*d^6+943*b^6*c^12*d^6+46*a^6*b^15*c^3+
46*a^6*b^15*d^3-46*a^6*c^15*d^3+46*b^6*c^15*d^3+230*a^9*b^3*c^12-
230*a^9*b^3*d^12-230*a^9*c^3*d^12-230*b^9*c^3*d^12+2530*a^9*b^6*c^9-
2530*a^9*b^6*d^9+2530*a^9*c^6*d^9-2530*b^9*c^6*d^9+2530*a^9*b^9*c^6-
2530*a^9*b^9*d^6-2530*a^9*c^9*d^6-2530*b^9*c^9*d^6+230*a^9*b^12*c^3-
230*a^9*b^12*d^3+230*a^9*c^12*d^3-230*b^9*c^12*d^3+230*a^12*b^3*c^3*d^6+
230*a^12*b^3*c^6*d^3+230*a^12*b^3*c^9+230*a^12*b^3*d^9-230*a^12*c^3*d^9+
230*b^12*c^3*d^9-230*a^12*b^6*c^3*d^3+943*a^12*b^6*c^6+943*a^12*b^6*d^6+
943*a^12*c^6*d^6+943*b^12*c^6*d^6+230*a^12*b^9*c^3+230*a^12*b^9*d^3-
230*a^12*c^9*d^3+230*b^12*c^9*d^3+(23/22)*a^12*b^12+(23/22)*a^12*c^12+
(23/22)*a^12*d^12+(23/22)*b^12*c^12+(23/22)*b^12*d^12+(23/22)*c^12*d^12+
46*a^15*b^3*c^6-46*a^15*b^3*d^6-46*a^15*c^3*d^6-46*b^15*c^3*d^6+
46*a^15*b^6*c^3-46*a^15*b^6*d^3+46*a^15*c^6*d^3-46*b^15*c^6*d^3+(1/44)*a^24+
(1/44)*b^24+(1/44)*c^24+(1/44)*d^24;end,

function(a,b,c,d)return 
-8700*a^3*b^3*c^6*d^18+8700*a^3*b^3*c^18*d^6-8700*a^3*b^6*c^3*d^18+
73950*a^3*b^6*c^9*d^12-73950*a^3*b^6*c^12*d^9+8700*a^3*b^6*c^18*d^3-
870*a^3*b^6*c^21+870*a^3*b^6*d^21-870*a^3*c^6*d^21+870*b^3*c^6*d^21+
73950*a^3*b^9*c^6*d^12-73950*a^3*b^9*c^12*d^6-11600*a^3*b^9*c^18+
11600*a^3*b^9*d^18+11600*a^3*c^9*d^18+11600*b^3*c^9*d^18+
73950*a^3*b^12*c^6*d^9-73950*a^3*b^12*c^9*d^6-44370*a^3*b^12*c^15+
44370*a^3*b^12*d^15-44370*a^3*c^12*d^15+44370*b^3*c^12*d^15-
44370*a^3*b^15*c^12+44370*a^3*b^15*d^12+44370*a^3*c^15*d^12+
44370*b^3*c^15*d^12+8700*a^3*b^18*c^3*d^6-8700*a^3*b^18*c^6*d^3-
11600*a^3*b^18*c^9+11600*a^3*b^18*d^9-11600*a^3*c^18*d^9+11600*b^3*c^18*d^9-
870*a^3*b^21*c^6+870*a^3*b^21*d^6+870*a^3*c^21*d^6+870*b^3*c^21*d^6-
8700*a^6*b^3*c^3*d^18+73950*a^6*b^3*c^9*d^12+73950*a^6*b^3*c^12*d^9-
8700*a^6*b^3*c^18*d^3-870*a^6*b^3*c^21-870*a^6*b^3*d^21+870*a^6*c^3*d^21-
870*b^6*c^3*d^21+266220*a^6*b^6*c^6*d^12+266220*a^6*b^6*c^12*d^6-
49590*a^6*b^6*c^18-49590*a^6*b^6*d^18-49590*a^6*c^6*d^18-49590*b^6*c^6*d^18+
73950*a^6*b^9*c^3*d^12+73950*a^6*b^9*c^12*d^3-488070*a^6*b^9*c^15-
488070*a^6*b^9*d^15+488070*a^6*c^9*d^15-488070*b^6*c^9*d^15-
73950*a^6*b^12*c^3*d^9+266220*a^6*b^12*c^6*d^6-73950*a^6*b^12*c^9*d^3-
1005720*a^6*b^12*c^12-1005720*a^6*b^12*d^12-1005720*a^6*c^12*d^12-
1005720*b^6*c^12*d^12-488070*a^6*b^15*c^9-488070*a^6*b^15*d^9+
488070*a^6*c^15*d^9-488070*b^6*c^15*d^9+8700*a^6*b^18*c^3*d^3-
49590*a^6*b^18*c^6-49590*a^6*b^18*d^6-49590*a^6*c^18*d^6-49590*b^6*c^18*d^6-
870*a^6*b^21*c^3-870*a^6*b^21*d^3+870*a^6*c^21*d^3-870*b^6*c^21*d^3+
73950*a^9*b^3*c^6*d^12-73950*a^9*b^3*c^12*d^6-11600*a^9*b^3*c^18+
11600*a^9*b^3*d^18+11600*a^9*c^3*d^18+11600*b^9*c^3*d^18+
73950*a^9*b^6*c^3*d^12-73950*a^9*b^6*c^12*d^3-488070*a^9*b^6*c^15+
488070*a^9*b^6*d^15-488070*a^9*c^6*d^15+488070*b^9*c^6*d^15-
2637550*a^9*b^9*c^12+2637550*a^9*b^9*d^12+2637550*a^9*c^9*d^12+
2637550*b^9*c^9*d^12-73950*a^9*b^12*c^3*d^6+73950*a^9*b^12*c^6*d^3-
2637550*a^9*b^12*c^9+2637550*a^9*b^12*d^9-2637550*a^9*c^12*d^9+
2637550*b^9*c^12*d^9-488070*a^9*b^15*c^6+488070*a^9*b^15*d^6+
488070*a^9*c^15*d^6+488070*b^9*c^15*d^6-11600*a^9*b^18*c^3+11600*a^9*b^18*d^3-
11600*a^9*c^18*d^3+11600*b^9*c^18*d^3-73950*a^12*b^3*c^6*d^9-
73950*a^12*b^3*c^9*d^6-44370*a^12*b^3*c^15-44370*a^12*b^3*d^15+
44370*a^12*c^3*d^15-44370*b^12*c^3*d^15+73950*a^12*b^6*c^3*d^9+
266220*a^12*b^6*c^6*d^6+73950*a^12*b^6*c^9*d^3-1005720*a^12*b^6*c^12-
1005720*a^12*b^6*d^12-1005720*a^12*c^6*d^12-1005720*b^12*c^6*d^12-
73950*a^12*b^9*c^3*d^6-73950*a^12*b^9*c^6*d^3-2637550*a^12*b^9*c^9-
2637550*a^12*b^9*d^9+2637550*a^12*c^9*d^9-2637550*b^12*c^9*d^9-
1005720*a^12*b^12*c^6-1005720*a^12*b^12*d^6-1005720*a^12*c^12*d^6-
1005720*b^12*c^12*d^6-44370*a^12*b^15*c^3-44370*a^12*b^15*d^3+
44370*a^12*c^15*d^3-44370*b^12*c^15*d^3-145*a^12*b^18-145*a^12*c^18-
145*a^12*d^18-145*b^12*c^18-145*b^12*d^18-145*c^12*d^18-44370*a^15*b^3*c^12+
44370*a^15*b^3*d^12+44370*a^15*c^3*d^12+44370*b^15*c^3*d^12-
488070*a^15*b^6*c^9+488070*a^15*b^6*d^9-488070*a^15*c^6*d^9+
488070*b^15*c^6*d^9-488070*a^15*b^9*c^6+488070*a^15*b^9*d^6+
488070*a^15*c^9*d^6+488070*b^15*c^9*d^6-44370*a^15*b^12*c^3+
44370*a^15*b^12*d^3-44370*a^15*c^12*d^3+44370*b^15*c^12*d^3+
8700*a^18*b^3*c^3*d^6+8700*a^18*b^3*c^6*d^3-11600*a^18*b^3*c^9-
11600*a^18*b^3*d^9+11600*a^18*c^3*d^9-11600*b^18*c^3*d^9-
8700*a^18*b^6*c^3*d^3-49590*a^18*b^6*c^6-49590*a^18*b^6*d^6-
49590*a^18*c^6*d^6-49590*b^18*c^6*d^6-11600*a^18*b^9*c^3-11600*a^18*b^9*d^3+
11600*a^18*c^9*d^3-11600*b^18*c^9*d^3-145*a^18*b^12-145*a^18*c^12-
145*a^18*d^12-145*b^18*c^12-145*b^18*d^12-145*c^18*d^12-870*a^21*b^3*c^6+
870*a^21*b^3*d^6+870*a^21*c^3*d^6+870*b^21*c^3*d^6-870*a^21*b^6*c^3+
870*a^21*b^6*d^3-870*a^21*c^6*d^3+870*b^21*c^6*d^3+a^30+b^30+c^30+d^30;end]);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","G32",function()return function(a,b,c,d)
 return 6388800*a*b*d^3+2662000000*a*c^2*d^2+45919500000*a*b^2*c^3-
53240000000*b*c^3*d-95832000*a*b^3*c*d+(1401543/20)*a*b^6+59895000*b^2*c*d^2-
3690500000*a^2*b*c^2*d-5513970*a^2*b^2*d^2-544500000000*a^2*c^4+
(71628975/2)*a^2*b^4*c-21175000*a^3*c*d^2+1332966250*a^3*b^2*c^2+
2108788*a^3*b^3*d-2662000*d^4+26642000*a^4*b*c*d+22460625*b^4*c^2+
10139250000*a^4*c^3+(-26003571/80)*a^4*b^4+10648000000000*c^5-71874*b^5*d+
64570*a^5*d^2-9759475*a^5*b^2*c-62764*a^6*b*d-81614375*a^6*c^2+
(761263/40)*a^7*b^2+(5723475/22)*a^8*c+(-2706867/9680)*a^10;end;end);

if not IsBound(CHEVIE.families) then ReadChv("unip/families");fi;
CHEVIE.families.G4:=rec(name:="Q(G_4)",
x:=[ (), (), (), (), (), (), (), ( 1,24)( 2,12)( 3,22)( 4,20)( 5,23)
    ( 6,21)( 7,16)( 8,11)( 9,18)(10,13)(14,17)(15,19),
  ( 1,24)( 2,12)( 3,22)( 4,20)( 5,23)( 6,21)( 7,16)( 8,11)( 9,18)(10,13)
    (14,17)(15,19), ( 1,24)( 2,12)( 3,22)( 4,20)( 5,23)( 6,21)( 7,16)( 8,11)
    ( 9,18)(10,13)(14,17)(15,19), ( 1,24)( 2,12)( 3,22)( 4,20)( 5,23)( 6,21)
    ( 7,16)( 8,11)( 9,18)(10,13)(14,17)(15,19),
  ( 1,24)( 2,12)( 3,22)( 4,20)( 5,23)( 6,21)( 7,16)( 8,11)( 9,18)(10,13)
    (14,17)(15,19), ( 1,24)( 2,12)( 3,22)( 4,20)( 5,23)( 6,21)( 7,16)( 8,11)
    ( 9,18)(10,13)(14,17)(15,19), ( 1,24)( 2,12)( 3,22)( 4,20)( 5,23)( 6,21)
    ( 7,16)( 8,11)( 9,18)(10,13)(14,17)(15,19),
  ( 1,12,24, 2)( 3,16,22, 7)( 4, 6,20,21)( 5,10,23,13)( 8,18,11, 9)
    (14,19,17,15), ( 1,12,24, 2)( 3,16,22, 7)( 4, 6,20,21)( 5,10,23,13)
    ( 8,18,11, 9)(14,19,17,15), ( 1,12,24, 2)( 3,16,22, 7)( 4, 6,20,21)
    ( 5,10,23,13)( 8,18,11, 9)(14,19,17,15),
  ( 1,12,24, 2)( 3,16,22, 7)( 4, 6,20,21)( 5,10,23,13)( 8,18,11, 9)
    (14,19,17,15), ( 1, 8,16,24,11, 7)( 2, 5, 6,12,23,21)( 3,15,10,22,19,13)
    ( 4,14, 9,20,17,18), ( 1, 8,16,24,11, 7)( 2, 5, 6,12,23,21)
    ( 3,15,10,22,19,13)( 4,14, 9,20,17,18),
  ( 1, 8,16,24,11, 7)( 2, 5, 6,12,23,21)( 3,15,10,22,19,13)( 4,14, 9,20,17,18)
    , ( 1, 8,16,24,11, 7)( 2, 5, 6,12,23,21)( 3,15,10,22,19,13)
    ( 4,14, 9,20,17,18), ( 1, 8,16,24,11, 7)( 2, 5, 6,12,23,21)
    ( 3,15,10,22,19,13)( 4,14, 9,20,17,18),
  ( 1, 8,16,24,11, 7)( 2, 5, 6,12,23,21)( 3,15,10,22,19,13)( 4,14, 9,20,17,18)
    , ( 1,11,16)( 2,23, 6)( 3,19,10)( 4,17, 9)( 5,21,12)( 7,24, 8)(13,22,15)
    (14,18,20), ( 1,11,16)( 2,23, 6)( 3,19,10)( 4,17, 9)( 5,21,12)( 7,24, 8)
    (13,22,15)(14,18,20), ( 1,11,16)( 2,23, 6)( 3,19,10)( 4,17, 9)( 5,21,12)
    ( 7,24, 8)(13,22,15)(14,18,20), ( 1,11,16)( 2,23, 6)( 3,19,10)( 4,17, 9)
    ( 5,21,12)( 7,24, 8)(13,22,15)(14,18,20),
  ( 1,11,16)( 2,23, 6)( 3,19,10)( 4,17, 9)( 5,21,12)( 7,24, 8)(13,22,15)
    (14,18,20), ( 1,11,16)( 2,23, 6)( 3,19,10)( 4,17, 9)( 5,21,12)( 7,24, 8)
    (13,22,15)(14,18,20), ( 1, 3, 5)( 2, 4,11)( 6,10,14)( 7, 9,19)( 8,12,20)
    (13,17,21)(15,16,18)(22,23,24), ( 1, 3, 5)( 2, 4,11)( 6,10,14)( 7, 9,19)
    ( 8,12,20)(13,17,21)(15,16,18)(22,23,24),
  ( 1, 3, 5)( 2, 4,11)( 6,10,14)( 7, 9,19)( 8,12,20)(13,17,21)(15,16,18)
    (22,23,24), ( 1, 3, 5)( 2, 4,11)( 6,10,14)( 7, 9,19)( 8,12,20)(13,17,21)
    (15,16,18)(22,23,24), ( 1, 3, 5)( 2, 4,11)( 6,10,14)( 7, 9,19)( 8,12,20)
    (13,17,21)(15,16,18)(22,23,24), ( 1, 3, 5)( 2, 4,11)( 6,10,14)( 7, 9,19)
    ( 8,12,20)(13,17,21)(15,16,18)(22,23,24),
  ( 1,22, 5,24, 3,23)( 2,20,11,12, 4, 8)( 6,13,14,21,10,17)( 7,18,19,16, 9,15)
    , ( 1,22, 5,24, 3,23)( 2,20,11,12, 4, 8)( 6,13,14,21,10,17)
    ( 7,18,19,16, 9,15), ( 1,22, 5,24, 3,23)( 2,20,11,12, 4, 8)
    ( 6,13,14,21,10,17)( 7,18,19,16, 9,15),
  ( 1,22, 5,24, 3,23)( 2,20,11,12, 4, 8)( 6,13,14,21,10,17)( 7,18,19,16, 9,15)
    , ( 1,22, 5,24, 3,23)( 2,20,11,12, 4, 8)( 6,13,14,21,10,17)
    ( 7,18,19,16, 9,15), ( 1,22, 5,24, 3,23)( 2,20,11,12, 4, 8)
    ( 6,13,14,21,10,17)( 7,18,19,16, 9,15) ],
charLabels:=[
"(1,\\phi_{1,0})","(1,\\phi_{1,4})","(1,\\phi_{1,8})","(1,\\phi_{2,5})",
"(1,\\phi_{2,3})","(1,\\phi_{2,1})","(1,\\phi_{3,2})","(z,\\phi_{1,0})",
"(z,\\phi_{1,4})","(z,\\phi_{1,8})","(z,\\phi_{2,5})","(z,\\phi_{2,3})",
"(z,\\phi_{2,1})","(z,\\phi_{3,2})",
"(g_4,1)", "(g_4,-1)", "(g_4,i)", "(g_4,-i)","(g_6,1)", "(g_6,-1)",
"(g_6,\\zeta_3^2)", "(g_6,-\\zeta_3^2)","(g_6,\\zeta_3)", "(g_6,-\\zeta_3)",
"(g_6^4,1)","(g_6^4,-1)", "(g_6^4,\\zeta_3^2)", "(g_6^4,-\\zeta_3^2)",
"(g_6^4,\\zeta_3)", "(g_6^4,-\\zeta_3)","(g_6^2,1)","(g_6^2,-1)",
"(g_6^2,\\zeta_3)","(g_6^2,-\\zeta_3)","(g_6^2,\\zeta_3^2)",
"(g_6^2,-\\zeta_3^2)","(g_6^5,1)","(g_6^5,-1)","(g_6^5,\\zeta_3)",
"(g_6^5,-\\zeta_3)","(g_6^5,\\zeta_3^2)","(g_6^5,-\\zeta_3^2)"],
eigenvalues:=[ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, 1, 1, -1, -E(4),
  E(4), 1, -1, E(3), -E(3), E(3)^2, -E(3)^2, 1, 1, E(3), E(3), E(3)^2,
  E(3)^2, 1, 1, E(3), E(3), E(3)^2, E(3)^2, 1, -1, E(3), -E(3), E(3)^2,
  -E(3)^2 ],
mellin:=ApplyFunc(DiagonalMat,
[[[1,1,1,2,2,2,3],[1,1,1,-2,-2,-2,3],[1,1,1,0,0,0,-1],[1,E(3),E(3)^2,1,E(3),
E(3)^2,0],[1,E(3),E(3)^2,-1,-E(3),-E(3)^2,0],[1,E(3)^2,E(3),-1,-E(3)^2,
-E(3),0],[1,E(3)^2,E(3),1,E(3)^2,E(3),0]],[[1,1,1,2,2,2,3],[1,1,1,-2,-2,-2,
3],[1,1,1,0,0,0,-1],[1,E(3),E(3)^2,1,E(3),E(3)^2,0],[1,E(3),E(3)^2,-1,-E(3),
-E(3)^2,0],[1,E(3)^2,E(3),-1,-E(3)^2,-E(3),0],[1,E(3)^2,E(3),1,E(3)^2,E(3),
0]],[[1,1,1,1],[1,-1,-E(4),E(4)],[1,-1,E(4),-E(4)],[1,1,-1,-1]],[[1,1,1,1,1,
1],[1,-1,E(3),-E(3),E(3)^2,-E(3)^2],[1,-1,E(3)^2,-E(3)^2,E(3),-E(3)],[1,1,
E(3)^2,E(3)^2,E(3),E(3)],[1,1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,1,-1,1,-1]],
[[1,1,1,1,1,1],[1,-1,E(3),-E(3),E(3)^2,-E(3)^2],[1,-1,E(3)^2,-E(3)^2,E(3),
-E(3)],[1,1,E(3)^2,E(3)^2,E(3),E(3)],[1,1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,1,
-1,1,-1]],[[1,1,1,1,1,1],[1,1,E(3)^2,E(3)^2,E(3),E(3)],[1,1,E(3),E(3),
E(3)^2,E(3)^2],[1,-1,E(3)^2,-E(3)^2,E(3),-E(3)],[1,-1,E(3),-E(3),E(3)^2,
-E(3)^2],[1,-1,1,-1,1,-1]],[[1,1,1,1,1,1],[1,1,E(3)^2,E(3)^2,E(3),E(3)],[1,
1,E(3),E(3),E(3)^2,E(3)^2],[1,-1,E(3)^2,-E(3)^2,E(3),-E(3)],[1,-1,E(3),
-E(3),E(3)^2,-E(3)^2],[1,-1,1,-1,1,-1]]]),
group:=ComplexReflectionGroup(4),
fourierMat:=
[[1/4,1/4,1/4,1/2,1/2,1/2,3/4,1/4,1/4,1/4,1/2,1/2,1/2,3/4,
3/2,3/2,3/2,3/2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
[1/4,1/4,1/4,1/2,1/2,1/2,3/4,1/4,1/4,1/4,1/2,1/2,1/2,3/4,
3/2,3/2,3/2,3/2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,
E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3),E(3),E(3),E(3),
E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3)],
[1/4,1/4,1/4,1/2,1/2,1/2,3/4,1/4,1/4,1/4,1/2,1/2,1/2,3/4,
3/2,3/2,3/2,3/2,E(3),E(3),E(3),E(3),E(3),E(3),E(3),E(3),
E(3),E(3),E(3),E(3),E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,
E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2],
[1/2,1/2,1/2,1,1,1,3/2,-1/2,-1/2,-1/2,-1,-1,-1,-3/2,0,0,0,
0,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1],
[1/2,1/2,1/2,1,1,1,3/2,-1/2,-1/2,-1/2,-1,-1,-1,-3/2,0,0,0,
0,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,-E(3)^2,-E(3)^2,
-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3),-E(3),-E(3),-E(3),-E(3),
-E(3),E(3),E(3),E(3),E(3),E(3),E(3)],
[1/2,1/2,1/2,1,1,1,3/2,-1/2,-1/2,-1/2,-1,-1,-1,-3/2,0,0,0,
0,E(3),E(3),E(3),E(3),E(3),E(3),-E(3),-E(3),-E(3),-E(3),
-E(3),-E(3),-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,-E(3)^2,
E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2,E(3)^2],
[3/4,3/4,3/4,3/2,3/2,3/2,9/4,3/4,3/4,3/4,3/2,3/2,3/2,9/4,
-3/2,-3/2,-3/2,-3/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[1/4,1/4,1/4,-1/2,-1/2,-1/2,3/4,1/4,1/4,1/4,-1/2,-1/2,-1/2,
3/4,3/2,3/2,-3/2,-3/2,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,
-1,1,-1,1,-1,1,-1,1,-1,1,-1],
[1/4,1/4,1/4,-1/2,-1/2,-1/2,3/4,1/4,1/4,1/4,-1/2,-1/2,-1/2,
3/4,3/2,3/2,-3/2,-3/2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,
-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3),
-E(3),E(3),-E(3),E(3),-E(3),E(3),-E(3),E(3),-E(3),E(3),-E(3)]
,[1/4,1/4,1/4,-1/2,-1/2,-1/2,3/4,1/4,1/4,1/4,-1/2,-1/2,
-1/2,3/4,3/2,3/2,-3/2,-3/2,E(3),-E(3),E(3),-E(3),E(3),-E(3),
E(3),-E(3),E(3),-E(3),E(3),-E(3),E(3)^2,-E(3)^2,E(3)^2,
-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2],
[1/2,1/2,1/2,-1,-1,-1,3/2,-1/2,-1/2,-1/2,1,1,1,-3/2,0,0,0,
0,1,-1,1,-1,1,-1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,1,-1,1,-1,1,-1],
[1/2,1/2,1/2,-1,-1,-1,3/2,-1/2,-1/2,-1/2,1,1,1,-3/2,0,0,0,
0,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,-E(3)^2,E(3)^2,
-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3),E(3),-E(3),E(3),-E(3),
E(3),E(3),-E(3),E(3),-E(3),E(3),-E(3)],
[1/2,1/2,1/2,-1,-1,-1,3/2,-1/2,-1/2,-1/2,1,1,1,-3/2,0,0,0,
0,E(3),-E(3),E(3),-E(3),E(3),-E(3),-E(3),E(3),-E(3),E(3),
-E(3),E(3),-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,E(3)^2,
-E(3)^2,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2],
[3/4,3/4,3/4,-3/2,-3/2,-3/2,9/4,3/4,3/4,3/4,-3/2,-3/2,-3/2,
9/4,-3/2,-3/2,3/2,3/2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[3/2,3/2,3/2,0,0,0,-3/2,3/2,3/2,3/2,0,0,0,-3/2,3,-3,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
,[3/2,3/2,3/2,0,0,0,-3/2,3/2,3/2,3/2,0,0,0,-3/2,-3,3,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[3/2,3/2,3/2,0,0,0,-3/2,-3/2,-3/2,-3/2,0,0,0,3/2,0,
0,-3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[3/2,3/2,3/2,0,0,0,-3/2,-3/2,-3/2,-3/2,0,0,0,3/2,0,0,3,
-3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[1,E(3)^2,E(3),1,E(3)^2,E(3),0,1,E(3)^2,E(3),1,E(3)^2,E(3),0,
0,0,0,0,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3),-E(3),
E(3)^2,-E(3)^2,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),-E(3)],
[1,E(3)^2,E(3),1,E(3)^2,E(3),0,-1,-E(3)^2,-E(3),-1,-E(3)^2,
-E(3),0,0,0,0,0,-1,1,-E(3),E(3),-E(3)^2,E(3)^2,1,-1,E(3),
-E(3),E(3)^2,-E(3)^2,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),-1,1,
-E(3)^2,E(3)^2,-E(3),E(3)],
[1,E(3)^2,E(3),1,E(3)^2,E(3),0,1,E(3)^2,E(3),1,E(3)^2,E(3),0,
0,0,0,0,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,
-E(3)^2,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1],
[1,E(3)^2,E(3),1,E(3)^2,E(3),0,-1,-E(3)^2,-E(3),-1,-E(3)^2,
-E(3),0,0,0,0,0,-E(3),E(3),-E(3)^2,E(3)^2,-1,1,E(3),-E(3),
E(3)^2,-E(3)^2,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,-E(3)^2,
E(3)^2,-E(3),E(3),-1,1],
[1,E(3)^2,E(3),1,E(3)^2,E(3),0,1,E(3)^2,E(3),1,E(3)^2,E(3),0,
0,0,0,0,E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,
-1,E(3),-E(3),E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2],
[1,E(3)^2,E(3),1,E(3)^2,E(3),0,-1,-E(3)^2,-E(3),-1,-E(3)^2,
-E(3),0,0,0,0,0,-E(3)^2,E(3)^2,-1,1,-E(3),E(3),E(3)^2,
-E(3)^2,1,-1,E(3),-E(3),E(3),-E(3),1,-1,E(3)^2,-E(3)^2,
-E(3),E(3),-1,1,-E(3)^2,E(3)^2],
[1,E(3)^2,E(3),-1,-E(3)^2,-E(3),0,1,E(3)^2,E(3),-1,-E(3)^2,
-E(3),0,0,0,0,0,1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),
E(3),E(3)^2,E(3)^2,1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),E(3)],
[1,E(3)^2,E(3),-1,-E(3)^2,-E(3),0,-1,-E(3)^2,-E(3),1,E(3)^2,
E(3),0,0,0,0,0,-1,-1,-E(3),-E(3),-E(3)^2,-E(3)^2,1,1,
E(3),E(3),E(3)^2,E(3)^2,1,1,E(3)^2,E(3)^2,E(3),E(3),-1,-1,
-E(3)^2,-E(3)^2,-E(3),-E(3)],
[1,E(3)^2,E(3),-1,-E(3)^2,-E(3),0,1,E(3)^2,E(3),-1,-E(3)^2,
-E(3),0,0,0,0,0,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),E(3),
E(3)^2,E(3)^2,1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),1,1],
[1,E(3)^2,E(3),-1,-E(3)^2,-E(3),0,-1,-E(3)^2,-E(3),1,E(3)^2,
E(3),0,0,0,0,0,-E(3),-E(3),-E(3)^2,-E(3)^2,-1,-1,E(3),
E(3),E(3)^2,E(3)^2,1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,-E(3)^2,
-E(3)^2,-E(3),-E(3),-1,-1],
[1,E(3)^2,E(3),-1,-E(3)^2,-E(3),0,1,E(3)^2,E(3),-1,-E(3)^2,
-E(3),0,0,0,0,0,E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,
1,1,E(3),E(3),E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,E(3)^2],
[1,E(3)^2,E(3),-1,-E(3)^2,-E(3),0,-1,-E(3)^2,-E(3),1,E(3)^2,
E(3),0,0,0,0,0,-E(3)^2,-E(3)^2,-1,-1,-E(3),-E(3),E(3)^2,
E(3)^2,1,1,E(3),E(3),E(3),E(3),1,1,E(3)^2,E(3)^2,-E(3),
-E(3),-1,-1,-E(3)^2,-E(3)^2],
[1,E(3),E(3)^2,-1,-E(3),-E(3)^2,0,1,E(3),E(3)^2,-1,-E(3),
-E(3)^2,0,0,0,0,0,1,1,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,
E(3)^2,E(3),E(3),1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2],
[1,E(3),E(3)^2,-1,-E(3),-E(3)^2,0,-1,-E(3),-E(3)^2,1,E(3),
E(3)^2,0,0,0,0,0,-1,-1,-E(3)^2,-E(3)^2,-E(3),-E(3),1,1,
E(3)^2,E(3)^2,E(3),E(3),1,1,E(3),E(3),E(3)^2,E(3)^2,-1,-1,
-E(3),-E(3),-E(3)^2,-E(3)^2],
[1,E(3),E(3)^2,-1,-E(3),-E(3)^2,0,1,E(3),E(3)^2,-1,-E(3),
-E(3)^2,0,0,0,0,0,E(3)^2,E(3)^2,E(3),E(3),1,1,E(3)^2,
E(3)^2,E(3),E(3),1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,1,1],
[1,E(3),E(3)^2,-1,-E(3),-E(3)^2,0,-1,-E(3),-E(3)^2,1,E(3),
E(3)^2,0,0,0,0,0,-E(3)^2,-E(3)^2,-E(3),-E(3),-1,-1,E(3)^2,
E(3)^2,E(3),E(3),1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,-E(3),
-E(3),-E(3)^2,-E(3)^2,-1,-1],
[1,E(3),E(3)^2,-1,-E(3),-E(3)^2,0,1,E(3),E(3)^2,-1,-E(3),
-E(3)^2,0,0,0,0,0,E(3),E(3),1,1,E(3)^2,E(3)^2,E(3),E(3),
1,1,E(3)^2,E(3)^2,E(3)^2,E(3)^2,1,1,E(3),E(3),E(3)^2,E(3)^2,1,1,E(3),E(3)],
[1,E(3),E(3)^2,-1,-E(3),-E(3)^2,0,-1,-E(3),-E(3)^2,1,E(3),
E(3)^2,0,0,0,0,0,-E(3),-E(3),-1,-1,-E(3)^2,-E(3)^2,E(3),
E(3),1,1,E(3)^2,E(3)^2,E(3)^2,E(3)^2,1,1,E(3),E(3),-E(3)^2,
-E(3)^2,-1,-1,-E(3),-E(3)],
[1,E(3),E(3)^2,1,E(3),E(3)^2,0,1,E(3),E(3)^2,1,E(3),E(3)^2,0,
0,0,0,0,1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,
-E(3)^2,E(3),-E(3),1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3),
-E(3),E(3)^2,-E(3)^2],
[1,E(3),E(3)^2,1,E(3),E(3)^2,0,-1,-E(3),-E(3)^2,-1,-E(3),
-E(3)^2,0,0,0,0,0,-1,1,-E(3)^2,E(3)^2,-E(3),E(3),1,-1,
E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3),-E(3),E(3)^2,-E(3)^2,-1,
1,-E(3),E(3),-E(3)^2,E(3)^2],
[1,E(3),E(3)^2,1,E(3),E(3)^2,0,1,E(3),E(3)^2,1,E(3),E(3)^2,0,
0,0,0,0,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),
-E(3),1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1],
[1,E(3),E(3)^2,1,E(3),E(3)^2,0,-1,-E(3),-E(3)^2,-1,-E(3),
-E(3)^2,0,0,0,0,0,-E(3)^2,E(3)^2,-E(3),E(3),-1,1,E(3)^2,
-E(3)^2,E(3),-E(3),1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,
-E(3),E(3),-E(3)^2,E(3)^2,-1,1],
[1,E(3),E(3)^2,1,E(3),E(3)^2,0,1,E(3),E(3)^2,1,E(3),E(3)^2,0,
0,0,0,0,E(3),-E(3),1,-1,E(3)^2,-E(3)^2,E(3),-E(3),1,-1,
E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,1,-1,E(3),-E(3),E(3)^2,-E(3)^2,1,-1,E(3),-E(3)],
[1,E(3),E(3)^2,1,E(3),E(3)^2,0,-1,-E(3),-E(3)^2,-1,-E(3),
-E(3)^2,0,0,0,0,0,-E(3),E(3),-1,1,-E(3)^2,E(3)^2,E(3),
-E(3),1,-1,E(3)^2,-E(3)^2,E(3)^2,-E(3)^2,1,-1,E(3),-E(3),
-E(3)^2,E(3)^2,-1,1,-E(3),E(3)]]/6,
special:=1);

CHEVIE.AddData("UnipotentCharacters","G32",function()local i3,I,J,cuspidal;
 J:=E(3);i3:=J-J^2;I:=E(4);
  cuspidal:=function(arg)local res,n; n:="G_{32}";
    if Length(arg)>2 and IsInt(arg[3]) then PrintToString(n,"^",arg[3]);fi;
    PrintToString(n,"[",FormatTeX(arg[2]),"]");
    res:=rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..4], parameterExponents:=[],
        charNumbers:=[arg[1]], eigenvalue:=arg[2], cuspidalName:=n);
    if Length(arg)>2 and not IsInt(arg[Length(arg)]) then
      res.qEigen:=arg[Length(arg)];fi;
    return res;
  end;
 return rec(
 harishChandra:=[
   rec(relativeType:=rec(series:="ST",indices:=[1..4],rank:=4,ST:=32),
       levi:=[],parameterExponents:=[1,1,1,1], charNumbers:=[1..102],
       eigenvalue:=1, cuspidalName:=""),
   rec(relativeType:=rec(series:="ST",indices:=[2..4],rank:=3,ST:=26),
       levi:=[1], parameterExponents:=[3,1,1],
       charNumbers:=[103,171,240,241,121,120,242,117,234,105,233,104,108,238,
         199,126,162,109,235,173,200,127,163,110,236,172,130,203,161,226,119,
	 175,131,204,160,225,118,174,152,153,177,179,178,176,201,128,202,129],
       eigenvalue:=J^2,
       cuspidalName:=ImprimitiveCuspidalName([[],[0,1],[0,1]])),
   rec(relativeType:=rec(series:="ST",indices:=[4,3],rank:=2,ST:=5),
       levi:=[1..2], parameterExponents:=[1,[0,4,4]],
       charNumbers:=[239,113,114,246,135,132,245,133,134,136,230,229,124,208,
         206,123,205,207,182,181,180],
       eigenvalue:=-1,cuspidalName:="G_4"),
   rec(relativeType:=rec(series:="ST",indices:=[2,4],rank:=2,p:=6,q:=1),
       levi:=[1,3], parameterExponents:=[[3,3,2,0,0,2],3],
       charNumbers:=[188,122,137,184,190,140,187,139,189,183,138,227,212, 
         209,164,244,237,210,243,211,228,107,106,111,185,186,112],
       eigenvalue:=J,
       cuspidalName:=Concatenation(ImprimitiveCuspidalName([[],[0,1],[0,1]]),
          "\\otimes ",ImprimitiveCuspidalName([[],[0,1],[0,1]]))),
   rec(relativeType:=rec(series:="ST",indices:=[4],rank:=1,p:=6,q:=1),
       levi:=[1..3], parameterExponents:=[[6,4,1,0,1,4]],
       charNumbers:=[116,143,217,232,218,144], eigenvalue:=J,
       cuspidalName:="G_{25}[\\zeta_3]"),
   rec(relativeType:=rec(series:="ST",indices:=[4],rank:=1,p:=6,q:=1),
       levi:=[1..3], parameterExponents:=[[6,1,4,0,4,1]],
       charNumbers:=[115,216,145,231,146,215], eigenvalue:=-J,
       cuspidalName:="G_{25}[-\\zeta_3]"),
   rec(relativeType:=rec(series:="ST",indices:=[3],rank:=1,p:=6,q:=1),
       levi:=[1,2,4], parameterExponents:=[[9,8,5,0,5,8]],
       charNumbers:=[125,142,213,247,214,141], eigenvalue:=-J^2,
	cuspidalName:=Concatenation("G_4\\otimes ",
                     ImprimitiveCuspidalName([[],[0,1],[0,1]]))),
   cuspidal(147,1), cuspidal(148,1,2), cuspidal(219,1,3), cuspidal(149,-1),
   cuspidal(191,-1,2), cuspidal(192,-1,3), cuspidal(220,-1,4),
   cuspidal(151,E(4)), cuspidal(154,E(4),2,1/2), cuspidal(155,E(4),3,1/2),
   cuspidal(150,-E(4)), cuspidal(156,-E(4),2,1/2), cuspidal(157,-E(4),3,1/2),
   cuspidal(193,J^2), cuspidal(194,J^2,2), cuspidal(197,-J),
   cuspidal(198,-J,2), cuspidal(195,-J^2), cuspidal(196,-J^2,2),
   cuspidal(221,E(5)), cuspidal(222,E(5)^2), cuspidal(223,E(5)^3),
   cuspidal(224,E(5)^4), cuspidal(165,E(9)^5,2/3), cuspidal(170,E(9)^5,2,1/3),
   cuspidal(166,E(9)^2,1/3), cuspidal(168,E(9)^2,2,2/3),
   cuspidal(167,E(9)^8,2/3), cuspidal(169,E(9)^8,2,1/3),
   cuspidal(158,E(12)^11,1/2), cuspidal(159,E(12)^5,1/2)
 ],
# note (Jean):
# the characters [[52,53],[34,40],[36,42],[58,59],[84,88],[79,82]]
# have the same fakedegree. The repartition in families below is the only one
# such that the DeligneLusztigCharacterTable is integral.
 families:=[
 Family("C1",[1]),
 Family(CHEVIE.families.X(3),[9,6,103],rec(signs:=[1,1,-1])),
 Family(CHEVIE.families.QZ(3),[26,20,23,15,106,104,12,105,107],
   rec(signs:=[1,1,1,1,1,-1,1,1,1], special:=2,cospecial:=3)),
 Family(CHEVIE.families.X(3),[37,34,108],rec(signs:=[1,1,-1])),
 Family(CHEVIE.families.X(6),
   [57,64,49,61,54,111,113,109,115,17,116,110,18,114,112],
   rec(signs:=[1,1,1,1,1,1,-1,-1,1,-1,1,-1,1,1,-1])),
 Family(CHEVIE.families.X(3)*Family("X5"),
  [46,72,123,119,41,44,69,124,118,45,120,117,125,122,121],
  rec(signs:=[1,1,-1,-1,1,1,1,-1,-1,1,-1,-1,1,1,-1])),
 Family("G4",[32,13,10,97,43,40,148,147,73,76,149,133,132,80,52,136,
  150,151,74,135,144,145,128,141,27,84,138,139,126,130,28,81,137,140,127,131,
  77,134,143,146,129,142],
  rec(signs:=[1,1,1,-1,-1,-1,1,1,1,1,1,-1,-1,1,1,-1,-1,-1,-1,-1,1,1,1,-1,1,1,
    1,1,1,-1,1,1,1,1,-1,1,-1,-1,-1,-1,-1,1],
      special:=9,cospecial:=10)),
#  Changed by Gunter 22/9/99 from C2 to C'\"2, again on 27.2.2003:
 Family(CHEVIE.families.X(3)*Family("C'\"2"),
   [93,96,154,156,94,95,155,157,153,152,158,159],
   rec(signs:=[1,1,1,1,1,1,1,1,-1,-1,1,1])),
 Family(CHEVIE.families.X(3)*CHEVIE.families.X(3),
   [85,87,161,88,82,160,163,162,164],rec(signs:=[1,1,-1,1,1,-1,-1,-1,1])),
 Family("Z9",[ 100, 165,166,101,167,169,102,168,170], rec(special:=7)),
 Family(Family("X5")*CHEVIE.families.QZ(3),
[53,21,59,90,185,177,47,193,187,79,33,36,98,184,179,99,178,183,180,182,181,
 192,198,196,191,195,197,171,172,173,174,68,189,175,190,71,56,60,24,48,188,
 194,89,176,186],rec(signs:=[1,1,-1,1,-1,1,1,1,-1,1,-1,-1,1,-1,1,1,-1,-1,-1,
  -1,-1,1,-1,1,1,1,-1,-1,-1,-1,-1,-1,1,-1,-1,1,1,-1,1,1,-1,-1,1,-1,-1])),
 Family(rec(fourierMat:=
[[-1,-1,1,1,5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5,5,5,-1,-5*E(3),
5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,5,5,-5*E(3)^2,-5*E(3),5*E(3),
5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,1,
5,-6,-6,-6,-6],[-1,-1,1,1,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5,5,
5,-1,-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),5,5,-5*E(3),-5*E(3)^2,
5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,
-5*E(3),1,5,-6,-6,-6,-6],[1,1,-1,-1,-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),
5*E(3)^2,5*E(3),5,5,5,1,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,5,
5,-5*E(3)^2,-5*E(3),5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),
-5*E(3)^2,-5*E(3),5*E(3)^2,-1,5,6,6,6,6],[1,1,-1,-1,-5*E(3),-5*E(3)^2,-5*E(3),
-5*E(3)^2,5*E(3),5*E(3)^2,5,5,5,1,5*E(3)^2,-5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,
-5*E(3),5,5,-5*E(3),-5*E(3)^2,5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,
5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),-1,5,6,6,6,6],[5*E(3)^2,5*E(3),
-5*E(3)^2,-5*E(3),5,5,5,5,5,5,5*E(3),5*E(3)^2,5,5,-5*E(3),5*E(3)^2,-5*E(3),
5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,-5,-5,5*E(3)^2,5*E(3),5*E(3)^2,
5*E(3),-5*E(3),5*E(3)^2,5*E(3)^2,-5*E(3),5*E(3)^2,-5*E(3),-5,5,0,0,0,0],
[5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5,5,5,5,5,5,5*E(3)^2,5*E(3),5,5,-5*E(3)^2,
5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5,-5,5*E(3),
5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3)^2,5*E(3),5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,
-5,5,0,0,0,0],[5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5,5,5,5,-5,-5,-5*E(3),
-5*E(3)^2,-5,5,-5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,-5*E(3),
-5*E(3)^2,5,5,-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),5*E(3),-5*E(3)^2,-5*E(3)^2,
5*E(3),5*E(3)^2,-5*E(3),-5,-5,0,0,0,0],[5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5,5,
5,5,-5,-5,-5*E(3)^2,-5*E(3),-5,5,-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,
5*E(3),-5*E(3)^2,-5*E(3),5,5,-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,5*E(3)^2,
-5*E(3),-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5,-5,0,0,0,0],[5*E(3)^2,5*E(3),
5*E(3)^2,5*E(3),5,5,-5,-5,5,5,5*E(3),5*E(3)^2,5,5,-5*E(3),5*E(3)^2,5*E(3),
-5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,5,5,5*E(3)^2,5*E(3),5*E(3)^2,
5*E(3),5*E(3),-5*E(3)^2,-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),5,-5,0,0,0,0],
[5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5,5,-5,-5,5,5,5*E(3)^2,5*E(3),5,5,-5*E(3)^2,
5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),5,5,5*E(3),
5*E(3)^2,5*E(3),5*E(3)^2,5*E(3)^2,-5*E(3),-5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,5,
-5,0,0,0,0],[5,5,5,5,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,5,5,5,
5,-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,-5*E(3),-5,-5,5*E(3),5*E(3)^2,
5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,
5*E(3),5,-5,0,0,0,0],[5,5,5,5,5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,
5*E(3),5,5,5,5,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,-5,-5,
5*E(3)^2,5*E(3),5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),
5*E(3)^2,-5*E(3),5*E(3)^2,5,-5,0,0,0,0],[5,5,5,5,5,5,-5,-5,5,5,5,5,5,5,-5,5,5,
-5,5,-5,-5,-5,5,5,5,5,5,5,5,-5,-5,5,-5,5,5,-5,0,0,0,0],[-1,-1,1,1,5,5,5,5,5,5,
5,5,5,-1,-5,5,-5,5,5,-5,5,5,-5,-5,5,5,5,5,-5,5,5,-5,5,-5,1,5,-6,-6,-6,-6],
[-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,
-5*E(3),-5*E(3)^2,-5*E(3)^2,-5*E(3),-5,-5,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,
-5*E(3),5*E(3)^2,-5*E(3)^2,-5*E(3),5*E(3),5*E(3)^2,-5,-5,-5,-5,5*E(3),
-5*E(3)^2,-5,5,-5,5,5,-5,0,0,0,0],[5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,
5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3),5*E(3)^2,5,5,-5*E(3)^2,5*E(3),
-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),5*E(3),5*E(3)^2,-5*E(3)^2,-5*E(3),5,5,5,5,
-5*E(3)^2,5*E(3),5,-5,5,-5,-5,5,0,0,0,0],[-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,
-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,5*E(3)^2,5*E(3),5,-5,
5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3)^2,5*E(3),-5*E(3),
-5*E(3)^2,5,5,-5,-5,-5*E(3),5*E(3)^2,5,-5,-5,5,5,5,0,0,0,0],[5*E(3)^2,5*E(3),
-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3),
-5*E(3)^2,-5,5,-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),-5*E(3),
-5*E(3)^2,5*E(3)^2,5*E(3),-5,-5,5,5,5*E(3)^2,-5*E(3),-5,5,5,-5,-5,-5,0,0,0,0],
[5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),
5*E(3)^2,5*E(3)^2,5*E(3),5,5,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),
-5*E(3)^2,-5*E(3)^2,-5*E(3),5*E(3),5*E(3)^2,5,5,5,5,5*E(3),-5*E(3)^2,-5,5,-5,
5,5,-5,0,0,0,0],[-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),
5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3),-5*E(3)^2,-5,-5,5*E(3)^2,-5*E(3),
-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),5*E(3),5*E(3)^2,-5*E(3)^2,-5*E(3),-5,-5,-5,
-5,-5*E(3)^2,5*E(3),5,-5,5,-5,-5,5,0,0,0,0],[5,5,5,5,5*E(3),5*E(3)^2,-5*E(3),
-5*E(3)^2,-5*E(3),-5*E(3)^2,-5,-5,-5,5,-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),
-5*E(3)^2,5*E(3),5,5,-5*E(3),-5*E(3)^2,-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),
-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5,5,0,0,0,0],[5,5,5,5,
5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),-5,-5,-5,5,-5*E(3),
5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,5,5,-5*E(3)^2,-5*E(3),-5*E(3),
-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,
5,5,0,0,0,0],[-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),-5,-5,5,5,5,5,5*E(3),
5*E(3)^2,5,-5,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),
-5*E(3)^2,5,5,5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3),-5*E(3)^2,-5*E(3)^2,
5*E(3),5*E(3)^2,-5*E(3),-5,-5,0,0,0,0],[-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,
-5,-5,5,5,5,5,5*E(3)^2,5*E(3),5,-5,5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,
-5*E(3),-5*E(3)^2,-5*E(3),5,5,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3)^2,
-5*E(3),-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5,-5,0,0,0,0],[5*E(3),5*E(3)^2,
5*E(3),5*E(3)^2,5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,
5*E(3),5,5,-5,5,5,-5,5,-5,-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),
5*E(3)^2,5*E(3),5,-5,-5*E(3)^2,5*E(3),-5*E(3)^2,5*E(3),5,-5,0,0,0,0],
[5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),
5*E(3)^2,5*E(3),5*E(3)^2,5,5,-5,5,5,-5,5,-5,-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,
5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5,-5,-5*E(3),5*E(3)^2,-5*E(3),5*E(3)^2,5,-5,0,
0,0,0],[5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),
5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5,5,-5,5,-5,5,5,-5,5*E(3)^2,5*E(3),-5*E(3)^2,
-5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),-5,5,5*E(3)^2,-5*E(3),5*E(3)^2,
-5*E(3),-5,5,0,0,0,0],[5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3),5*E(3)^2,
5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5,5,-5,5,-5,5,5,-5,5*E(3),
5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,-5,5,5*E(3),
-5*E(3)^2,5*E(3),-5*E(3)^2,-5,5,0,0,0,0],[-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,
-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5*E(3)^2,5*E(3),5,-5,5*E(3),
-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3)^2,-5*E(3),5*E(3),5*E(3)^2,
5,5,-5,-5,5*E(3),-5*E(3)^2,-5,5,5,-5,-5,-5,0,0,0,0],[5*E(3)^2,5*E(3),5*E(3)^2,
5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3),-5*E(3)^2,
-5,5,-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5*E(3),5*E(3)^2,
-5*E(3)^2,-5*E(3),-5,-5,5,5,-5*E(3)^2,5*E(3),5,-5,-5,5,5,5,0,0,0,0],[5*E(3),
5*E(3)^2,5*E(3),5*E(3)^2,5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),
-5*E(3)^2,-5*E(3),-5,5,-5,5,5,-5,-5,5,5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),
-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5,5,5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5,5,
0,0,0,0],[-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3),-5*E(3)^2,5*E(3),
5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,5,-5,5,-5,-5,5,5,-5,-5*E(3),
-5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5,-5,-5*E(3),
5*E(3)^2,5*E(3),-5*E(3)^2,-5,-5,0,0,0,0],[5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,
5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,-5*E(3),-5,5,-5,5,
-5,5,-5,5,-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,5*E(3),
5,-5,-5*E(3)^2,5*E(3),5*E(3)^2,-5*E(3),-5,-5,0,0,0,0],[-5*E(3)^2,-5*E(3),
5*E(3)^2,5*E(3),-5*E(3),-5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),5*E(3)^2,5*E(3),
5*E(3)^2,5,-5,5,-5,5,-5,5,-5,5*E(3),5*E(3)^2,-5*E(3),-5*E(3)^2,5*E(3),
5*E(3)^2,-5*E(3),-5*E(3)^2,-5,5,5*E(3),-5*E(3)^2,-5*E(3),5*E(3)^2,5,5,0,0,0,
0],[1,1,-1,-1,-5,-5,-5,-5,5,5,5,5,5,1,5,-5,5,-5,5,-5,5,5,-5,-5,5,5,-5,-5,-5,5,
5,-5,-5,5,-1,5,6,6,6,6],[5,5,5,5,5,5,-5,-5,-5,-5,-5,-5,-5,5,-5,5,5,-5,-5,5,5,
5,-5,-5,-5,-5,5,5,-5,5,5,-5,-5,5,5,5,0,0,0,0],[-6,-6,6,6,0,0,0,0,0,0,0,0,0,-6,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9-3*ER(5),-6-6*ER(5),-6+6*ER(5),
9+3*ER(5)],[-6,-6,6,6,0,0,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,6,0,-6-6*ER(5),9+3*ER(5),9-3*ER(5),-6+6*ER(5)],[-6,-6,6,6,0,0,0,0,0,0,0,
0,0,-6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,-6+6*ER(5),9-3*ER(5),
9+3*ER(5),-6-6*ER(5)],[-6,-6,6,6,0,0,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,6,0,9+3*ER(5),-6+6*ER(5),-6-6*ER(5),9-3*ER(5)]]/30,
    eigenvalues:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,J^2,J^2,J^2,J^2,J^2,J^2,-1,-1,-1,-1,J,J,J,J,-J^2,-J^2,-J,-J,J,J,1,-1,E(5),E(5)^2,E(5)^3,E(5)^4],
       comment:="everything to explain",
    special:=3,cospecial:=4
    ),[8,5,65,62,86,83,66,63,51,50,67,70,91,92,199,200,201,202,
      203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
      217, 218, 219, 220, 221, 222, 223, 224 ],rec(signs:=[1,1,1,1,1,1,1,1,1,1,
     1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1])),
 Family(CHEVIE.families.X(6),
  [58,75,25,78,55,227,229,225,231,30,232,226,29,230,228],
  rec(signs:=[1,1,1,1,1,1,-1,-1,1,-1,1,-1,1,1,-1])),
 Family(CHEVIE.families.X(3)*CHEVIE.families.X(3),
   [38,42,234,39,35,233,236,235,237],rec(signs:=[1,1,-1,1,1,-1,-1,-1,1])),
 Family("X5",[19,31,239,238,22],rec(signs:=[1,1,-1,-1,1])),
 Family(ComplexConjugate(CHEVIE.families.X(6)),
  [14,7,16,4,11,240,246,244,247,2,242,243,3,245,241],
 rec(signs:=[1,1,1,1,1,1,1,-1,1,1,-1,1,-1,-1,1],special:=13,cospecial:=10))],
 a:=[0,40,40,40,15,1,40,15,1,6,40,2,6,40,2,40,4,4,30,2,12,30,2,12,20,2,6,6,20,
  20,30,6,12,3,25,12,3,25,25,6,5,25,6,5,5,5,12,12,4,15,15,6,12,4,20,12,4,20,12,
  12,4,15,15,4,15,15,15,12,5,15,12,5,6,6,20,6,6,20,12,6,6,9,15,6,9,15,9,9,12,
  12,15,15,8,8,8,8,6,12,12,10,10,10,1,2,2,2,2,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,
  5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8,8,8,8,8,8,8,8,9,9,9,9,
  9,10,10,10,10,10,10,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
  12,12,12,12,12,12,12,12,12,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
  15,15,15,15,15,15,15,15,15,20,20,20,20,20,20,20,20,25,25,25,25,25,30,30,40,40,
  40,40,40,40,40,40],
 A:=[0,80,80,80,75,29,80,75,29,66,80,46,66,80,46,80,56,56,78,46,72,78,46,72,76,
  46,66,66,76,76,78,66,72,51,77,72,51,77,77,66,61,77,66,61,61,61,72,72,56,75,75,
  66,72,56,76,72,56,76,72,72,56,75,75,56,75,75,75,72,61,75,72,61,66,66,76,66,66,
  76,72,66,66,69,75,66,69,75,69,69,72,72,75,75,67,67,67,67,66,72,72,70,70,70,29,
  46,46,46,46,51,56,56,56,56,56,56,56,56,61,61,61,61,61,61,61,61,61,66,66,66,66,
  66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,67,67,67,67,
  67,67,67,67,69,69,69,69,69,70,70,70,70,70,70,72,72,72,72,72,72,72,72,72,72,72,
  72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,75,75,75,75,75,75,75,75,75,
  75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,76,76,76,76,76,76,76,76,77,
  77,77,77,77,78,78,80,80,80,80,80,80,80,80]);
end);
