#############################################################################
##
#A  tbl/cmplxg29.g               CHEVIE library                  Gunter Malle
##
#Y  Copyright (C) 1998 - 2001  The CHEVIE Team
##
##  This file contains data about the complex reflection group
##  of type G29 in the Shephard-Todd classification.
##

## of interest is the alternate presentation of the braid group:
CHEVIE.AddData("AltPres","G29",[rec(gens:=[[1],[-4,2,4],[3],[4]],
  rels:=[[[1,2,1],[2,1,2]],[[2,4,2],[4,2,4]],
 [[3,4,3],[4,3,4]],[[2,3,2],[3,2,3]],[[1,3],[3,1]],[[1,4],[4,1]],
 [[4,2,3,4,2,3,4,2],[3,4,2,3,4,2,3,4]]])]);

CHEVIE.AddData("PrintDiagram","G29",function(indices,title)local s;
  Print(title," ");s:=String("",Length(title)-3);
  Print(s,"  ",indices[4],"\n","     /\"\\\n",
	s,indices[1],"---",indices[2],"===",indices[3]," ",
	IntListToString(indices{[4,3,2,4,3,2]}),"=",
	IntListToString(indices{[3,2,4,3,2,4]}),"\n");
end);

# Our G29 is equal to ReflectionSubgroup(G31,[234,13,3,5])
# This is also the subgroup which leaves invariant the Phi1 of Maschke

CHEVIE.AddData("GeneratingRoots","G29",
[[0,0,0,-2],[-E(4),E(4),1,1],[1-E(4),-1+E(4),0,0],[0,1-E(4),-1+E(4),0]]/2);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G29",[1/2,1/2,1/2,1/2]);

CHEVIE.AddData("BraidRelations","G29",[[[1,2,1],[2,1,2]],[[2,4,2],[4,2,4]],
 [[3,4,3],[4,3,4]],[[2,3,2,3],[3,2,3,2]],[[1,3],[3,1]],[[1,4],[4,1]],
 [[4,3,2,4,3,2],[3,2,4,3,2,4]]]);

CHEVIE.AddData("Size","G29", 7680);

CHEVIE.AddData("ReflectionDegrees","G29",[4,8,12,20]);

CHEVIE.AddData("NrConjugacyClasses","G29", 37);

CHEVIE.AddData("ParabolicRepresentatives","G29",# repr. of conj. classes
[[],[1],[1,2],[1,3],[2,3],[1..3],[1,2,4],[1,3,4],[1,3,9],[2..4],[1..4]]);

CHEVIE.AddData("ClassNames","G29",[".","1","12","23","31","234","341","123",
  "243","124","3232","c","ccc","124z","43232","32321","12zzz","3123cc",
  "cc","12z","342342","432432","123z","341z","323123121",
  "12zz","234zz","234z","cccc","31z",
  "3232z","1z","323123121z","432432z","z","zzz","zz"]);

CHEVIE.AddData("WordsClassRepresentatives","G29",
 List(CHEVIE.RawData("ClassNames","G29"),x->Replace(x,".",[],"1",[1],
   "2",[2],"3",[3],"4",[4],"z","ccccc","c",[1,2,4,3])));

CHEVIE.AddData("PowerMaps","G29",[,[1,1,3,11,1,21,3,3,22,5,1,19,19,5,11,
  11,26,31,29,26,11,11,26,26,1,3,21,22,29,37,37,37,37,11,37,37,1],
  [ 1, 2, 1, 4, 5, 9, 2, 25, 6, 10, 11, 13, 12, 14, 15, 16, 35, 18, 19, 36,
      22, 21, 32, 33, 25, 37, 28, 27, 29, 30, 31, 33, 32, 34, 36, 35, 37 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 35, 36, 14, 15, 16, 17, 18, 37, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 1, 30, 31, 32, 33, 34, 35, 36, 37 ],,
  [ 1, 2, 3, 4, 5, 9, 7, 8, 6, 10, 11, 13, 12, 14, 15, 16, 20, 18, 19, 17,
      22, 21, 24, 23, 25, 26, 28, 27, 29, 30, 31, 33, 32, 34, 36, 35, 37 ],,,
  , [ 1, 2, 3, 4, 5, 9, 7, 8, 6, 10, 11, 13, 12, 14, 15, 16, 20, 18, 19, 17,
      22, 21, 24, 23, 25, 26, 28, 27, 29, 30, 31, 33, 32, 34, 36, 35, 37 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 ],,,
  , [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 ],,
  [ 1, 2, 3, 4, 5, 9, 7, 8, 6, 10, 11, 13, 12, 14, 15, 16, 20, 18, 19, 17,
      22, 21, 24, 23, 25, 26, 28, 27, 29, 30, 31, 33, 32, 34, 36, 35, 37 ] ]);

CHEVIE.AddData("ClassInfo","G29",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G29"),
    classnames:=CHEVIE.RawData("ClassNames","G29"),
    classparams:=CHEVIE.RawData("ClassNames","G29"),
    orders:=[1,2,3,4,2,8,6,6,8,4,2,20,20,
  4,4,4,12,8,10,12,4,4,12,12,2,6,8,8,5,4,4,4,4,4,4,4,2],
    classes:=[1,40,320,60,120,240,320,320,240,480,30,384,384,480,240,240,
  320,480,384,320,60,60,320,320,40,320,240,240,384,120,30,40,40,60,1,1,1]));

CHEVIE.AddData("CharInfo","G29",function()local res;
  res:=rec(charparams:=[[1,0],[1,40],[4,4],[4,24],[4,1],[4,21],[4,3],
  [4,23],[5,8],[5,16],[6,12],[6,10,1],[6,10,2],[6,10,3],[6,10,4],
  [10,18],[10,2],[10,14],[10,6],[15,4,1],[15,4,2],[15,12,1],[15,12,2],
  [16,15],[16,5],[16,13],[16,3],[20,6],[20,10],[20,9],[20,5],[20,11],[20,7],
  [24,6],[24,9],[24,7],[30,8]],
# here the labelling is as follows: phi_15,4'' occurs in the tensor product
# of phi_{4,1} and phi_{4,3}.
# The tensor by sign of phi_{15,4}'' is phi_{15,12}''.
# phi_{6,10}' occurs in the permutation representation on the parabolic
# A_3=ReflectionSubgroup(W,[1,2,4])
# phi_{6,10}''' occurs in the tensor square of the phi_{4,1}, and
# phi_{6,10''''} is the complex conjugate.
  extRefl:=[1,5,14,8,2]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,
    2,2,1,1,1,1,1,1,1,1,1,1];
  return res;
end);

CHEVIE.AddData("CycPolSchurElements","G29",
[ [1,0,2,2,2,2,3,4,4,4,4,5,6,8,10,12,20],
  [1,-40,2,2,2,2,3,4,4,4,4,5,6,8,10,12,20],
  [2,-1,2,2,2,2,3,4,5,6,8,10],
  [2,-21,2,2,2,2,3,4,5,6,8,10],
  [-2*E(4)+2,-1,2,2,3,4,4,1/4,1/4,5,3/8,7/8,7/12,11/12,1/20,9/20,13/20,17/20],
  [2*E(4)+2,-21,2,2,3,4,4,3/4,3/4,5,1/8,5/8,1/12,5/12,3/20,7/20,11/20,19/20],
  [2*E(4)+2,-1,2,2,3,4,4,3/4,3/4,5,1/8,5/8,1/12,5/12,3/20,7/20,11/20,19/20],
  [-2*E(4)+2,-21,2,2,3,4,4,1/4,1/4,5,3/8,7/8,7/12,11/12,1/20,9/20,13/20,17/20],
  [2,-4,2,2,2,2,3,4,4,4,4,6],
  [2,-12,2,2,2,2,3,4,4,4,4,6],
  [4,-6,2,2,2,2,4,4,5], [5,-6,2,2,2,2,4,4,4,4], [5,-6,2,2,2,2,4,4,4,4],
  [-20,-6,2,2,2,2,3/4,3/4,3/4,3/4,1/20,9/20,13/20,17/20],
  [-20,-6,2,2,2,2,1/4,1/4,1/4,1/4,3/20,7/20,11/20,19/20],
  [1,-18,2,2,2,2,3,4,4,4,4,6,12], [1,-2,2,2,2,2,3,4,4,4,4,6,12],
  [2,-12,2,2,2,2,3,4,4,6,8], [2,-4,2,2,2,2,3,4,4,6,8],
  [1,-4,2,2,2,2,4,4,4,4,8], [2,-4,2,2,2,2,4,4,4,4,12],
  [1,-12,2,2,2,2,4,4,4,4,8], [2,-12,2,2,2,2,4,4,4,4,12],
  [2,-13,2,2,2,2,3,5,6,10], [2,-3,2,2,2,2,3,5,6,10],
  [2,-13,2,2,2,2,3,5,6,10], [2,-3,2,2,2,2,3,5,6,10],
  [2,-5,2,2,2,2,3,4,6,8], [2,-9,2,2,2,2,3,4,6,8],
  [-2*E(4)+2,-9,2,2,3,4,4,3/4,3/4,3/8,7/8,1/12,5/12],
  [2*E(4)+2,-5,2,2,3,4,4,1/4,1/4,1/8,5/8,7/12,11/12],
  [2*E(4)+2,-9,2,2,3,4,4,1/4,1/4,1/8,5/8,7/12,11/12],
  [-2*E(4)+2,-5,2,2,3,4,4,3/4,3/4,3/8,7/8,1/12,5/12], [20,-6,4,4,4,4,10], 
  [4,-6,2,2,4,5,8], [4,-6,2,2,4,5,8], [4,-6,2,2,2,2,4,4,10] ]);

# description of fake degrees by powers of q
CHEVIE.AddData("factors","G29",
[[1,0],[1,40],[1,4,1,8,1,12,1,16],[1,24,1,28,1,32,1,36],[1,1,1,9,1,13,1,17],
[1,21,1,29,1,33,1,37],[1,3,1,7,1,11,1,19],[1,23,1,27,1,31,1,39],[1,8,1,12,1,
16,1,20,1,24],[1,16,1,20,1,24,1,28,1,32],[1,12,1,16,2,20,1,24,1,28],[1,10,1,
14,1,18,1,22,1,26,1,30],[1,10,1,14,1,18,1,22,1,26,1,30],[1,10,1,14,1,18,1,22,
1,26,1,30],[1,10,1,14,1,18,1,22,1,26,1,30],[1,18,2,22,2,26,2,30,2,34,1,38],[1,
2,2,6,2,10,2,14,2,18,1,22],[1,14,2,18,2,22,2,26,2,30,1,34],[1,6,2,10,2,14,2,
18,2,22,1,26],[1,4,2,8,3,12,3,16,3,20,2,24,1,28],[1,4,2,8,3,12,3,16,3,20,2,24,
1,28],[1,12,2,16,3,20,3,24,3,28,2,32,1,36],[1,12,2,16,3,20,3,24,3,28,2,32,1,
36],[2,15,3,19,3,23,3,27,3,31,2,35],[2,5,3,9,3,13,3,17,3,21,2,25],[1,13,2,17,
3,21,4,25,3,29,2,33,1,37],[1,3,2,7,3,11,4,15,3,19,2,23,1,27],[1,6,3,10,4,14,4,
18,4,22,3,26,1,30],[1,10,3,14,4,18,4,22,4,26,3,30,1,34],[1,9,2,13,4,17,4,21,4,
25,3,29,2,33],[1,5,2,9,4,13,4,17,4,21,3,25,2,29],[2,11,3,15,4,19,4,23,4,27,2,
31,1,35],[2,7,3,11,4,15,4,19,4,23,2,27,1,31],[1,6,2,10,4,14,5,18,5,22,4,26,2,
30,1,34],[2,9,4,13,5,17,5,21,4,25,3,29,1,33],[1,7,3,11,4,15,5,19,5,23,4,27,2,
31],[2,8,4,12,6,16,6,20,6,24,4,28,2,32]]);

# Computed JM oct. 2005. Completed 18th column nov. 2012 using:
# The  representative  w=3123cc  of  18th  class satisfies w^2=z2323 in BW,
# which  can be  checked by  adding this  relation to the presentation then
# simplifying. The eigenvalues of w^2 for missing lines are
#28[ 6 x  -q^13,  8 x   q^13, 2 x  -q^11, 4 x  -q^15 ]
#30[ 4 x  Iq^11, 10 x -Iq^11, 4 x   Iq^9, 2 x  Iq^13 ]
#34[ 4 x  -q^12, 16 x   q^12, 2 x  -q^10, 2 x  -q^14 ]
#35[ 8 x  Iq^12, 12 x -Iq^12, 2 x  Iq^10, 2 x  Iq^14 ]
#37[ 8 x   q^12, 16 x  -q^12, 3 x   q^10, 3 x   q^14 ]
# For rationality reasons the character has to vanish on w for 28,30,35 and
# has to be an integral multiple of q^6 for 34 so by specialization is 0.
# It has to be aq^6+bq^5+cq^7 for 37. By specialization a+b+c=2.
# By Schur relations a=0 and b=1.
CHEVIE.AddData("HeckeCharTable","G29",function(para,root) local tbl,q,r,p,
    f1,f3,f5,f9,f11,f12,f14,f17,f18,f22,f23,f24,f28,f30,f34,f35,f37,adj;
  q:=-para[1][1]/para[1][2];r:=para[1][1];p:=para[1][2];
  tbl:=rec(identifier:="H(G29)", size:=7680, order:=7680,
  powermap:=CHEVIE.RawData("PowerMaps","G29"));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","G29"));
  adj:=function(p,x)return Zip(x,List(tbl.classtext,x->(-p)^Length(x)),
    function(x,y)return x*y;end);end;
  f1:=r->List(tbl.classtext,x->r^Length(x));
  f3:=function(r,p)local q;q:=-r/p;return adj(p,
[4,-1+3*q,-q+2*q^2,-2*q+2*q^2,-2*q+2*q^2,
-q^2+q^3,-2*q^2+q^3,-2*q^2+q^3,-q^2+q^3,-q^2+q^3,2*q^2+2*q^4,-q^3,-q^9,
-q^17+q^18,q^4+q^5,q^3+q^5,-q^46+2*q^47,0,-q^6,-q^16+2*q^17,-q^4+q^6,
-q^4+q^6,-2*q^17+q^18,-2*q^17+q^18,q^6+q^9,-q^31+2*q^32,-q^32+q^33,-q^17+
q^18,-q^12,-2*q^16+2*q^17,2*q^17+2*q^19,-q^15+3*q^16,q^21+q^24,-q^19+q^21,
4*q^15,4*q^45,4*q^30]);end;
  f5:=function(r,p,I)local q;q:=-r/p;return adj(p,
[4,-1+3*q,-q+2*q^2,2*q^2,-2*q+2*q^2,(I-1)*q+q^2+q^3,-2*q^2+q^3,q^3,
-I*q^2+q^3,-q^2+q^3,-2*q^2+2*q^4,-I*q^3,I*q^9,-I*q^17+I*q^18,
(I-1)*q^3-I*q^4+q^5,-q^3+q^5,I*q^46-2*I*q^47,0,q^6,-I*q^16+2*I*q^17,
-2*I*q^2+(2*I-2)*q^3+3*q^4+(-2*I-2)*q^5+q^6,(2*I-1)*q^4+q^6,I*q^18,
-2*I*q^17+I*q^18,-3*q^6+q^9,q^31-2*q^32,(-I+1)*q^31-q^32-q^33,
(-I-1)*q^16+I*q^17+I*q^18,-q^12,-2*I*q^16+2*I*q^17,-2*I*q^17+2*I*q^19,-I*q^15+
3*I*q^16,-3*I*q^21+I*q^24,(-I-2)*q^19+I*q^21,4*I*q^15,-4*I*q^45,-4*q^30]);end;
  f9:=function(r,p)local q;q:=-r/p;return adj(p,
[5,-2+3*q,-2*q+q^2,1-2*q+2*q^2,1-2*q+2*q^2,-q^2,q-q^2+
q^3,q-q^2+q^3,-q^2,-q^2,1+2*q^2+2*q^4,0,0,-q^14,q^2-q^3+q^4,q^5,-2*q^37+
q^38,q^6,0,-2*q^13+q^14,2*q^3-q^4,2*q^3-q^4,q^13-q^14+q^15,q^13-q^14+q^15,
-2*q^3+2*q^6+q^9,-2*q^25+q^26,-q^26,-q^14,0,q^12-2*q^13+2*q^14,
q^12+2*q^14+2*q^16,-2*q^12+3*q^13,-2*q^15+2*q^18+q^21,2*q^15-q^16,
5*q^12,5*q^36,5*q^24]);end;
  f11:=function(r,p)local q;q:=-r/p;return adj(p,[6,-3+3*q,1-2*q+q^2,
1-4*q+q^2,1-4*q+q^2,q-q^2,2*q-2*q^2,2*q-2*q^2,q-q^2,q-q^2,1+4*q^2+q^4,q^2,
q^6,q^11-q^12,-q+q^4,-q^2+q^3,q^30-2*q^31+q^32,-q^5-q^7,q^4,q^10-2*q^11+q^12,
-q^2-q^4,-q^2-q^4,2*q^11-2*q^12,2*q^11-2*q^12,-q^3+q^6,q^20-2*q^21+q^22,
q^21-q^22,q^11-q^12,q^8,q^10-4*q^11+q^12,q^10+4*q^12+q^14,-3*q^10+3*q^11,
-q^13+q^16,-q^12-q^14,6*q^10,6*q^30,6*q^20]);end;
  f12:=function(r,p)local q;q:=-r/p;return adj(p,
[6,-3+3*q,1-2*q+q^2,-2*q,2-2*q+
2*q^2,1-q+q^2-q^3,-1+q-q^2+q^3,0,0,q+q^3,-2*q^2,-q^2,-q^6,-q^11-q^13,
q^2-q^3,q^2-q^3,-q^30+2*q^31-q^32,0,q^4,-q^10+2*q^11-q^12,1-2*q+
3*q^2-2*q^3+3*q^4-2*q^5+q^6,2*q^3,0,q^10-q^11+q^12-q^13,-3*q^4+3*q^5,
q^20-2*q^21+q^22,q^20-q^21+q^22-q^23,-q^10+q^11-q^12+q^13,q^8,-2*q^10+
2*q^11-2*q^12,2*q^12,3*q^10-3*q^11,3*q^14-3*q^15,-2*q^13,-6*q^10,-6*q^30,
6*q^20]);end;
  f14:=function(r,p,I)local q;q:=-r/p;return adj(p,
 [6,-3+3*q,1-2*q+q^2,1+q^2,1-4*q+q^2,(I-2)*q+
(I+2)*q^2,2*q-2*q^2,0,-I*q-I*q^2,q-q^2,1-4*q^2+q^4,-q^2,-q^6,-q^11+
q^12,-I*q+(I+1)*q^2+(I-1)*q^3-I*q^4,q^2-q^3,-q^30+2*q^31-q^32,
-I*q^7+I*q^5,q^4,-q^10+2*q^11-q^12,(2*I-2)*q+(-2*I+3)*q^2-4*q^3+
(2*I+3)*q^4+(-2*I-2)*q^5,(-2*I-1)*q^2+(2*I-1)*q^4,0,-2*q^11+
2*q^12,3*q^3-3*q^6,q^20-2*q^21+q^22,(I-2)*q^21+(I+2)*q^22,(-I+
2)*q^11+(-I-2)*q^12,q^8,-q^10+4*q^11-q^12,-q^10+4*q^12-q^14,
3*q^10-3*q^11,-3*q^13+3*q^16,(2*I+1)*q^12+(-2*I+1)*q^14,-6*q^10,
-6*q^30,6*q^20]);end;
  f17:=function(r,p)local q;q:=-r/p;return adj(p,[10,
-7+3*q,4-3*q,4-2*q,5-4*q+q^2,-1-q+2*q^2,-3+3*q-q^2,-2+q,-1+q,-2+2*q,4-2*q^2,
0,0,2*q^6-2*q^7,-1-q+2*q^2,-2+2*q^2,-4*q^18+3*q^19,0,0,-4*q^6+3*q^7,1-4*q+
5*q^2-4*q^3,1-3*q^2,2*q^6-q^7,3*q^6-3*q^7+q^8,-2+q^3-3*q^4,4*q^12-3*q^13,
-q^12-q^13+2*q^14,q^6+q^7-2*q^8,0,-5*q^6+4*q^7-q^8,-4*q^6+2*q^8,7*q^6-3*q^7,
2*q^6-q^9+3*q^10,-q^6+3*q^8,-10*q^6,-10*q^18,10*q^12]);end;
  f18:=function(r,p)local q;q:=-r/p;return adj(p,[10,-6+4*q,3-3*q+
q^2,2-4*q,3-6*q+q^2,q^2-q^3,-1+4*q-2*q^2,2*q-q^2,-1+q,-1+2*q-q^2,2,0,0,
q^8-2*q^9+q^10,-1-q+q^2-q^3,q^2+q^3,-3*q^24+3*q^25-q^26,0,0,-3*q^8+
3*q^9-q^10,2-2*q+2*q^2-2*q^3+3*q^4-2*q^5+q^6,1-q^2+2*q^3,-2*q^9+q^10,
q^8-4*q^9+2*q^10,2*q^3-3*q^4-q^6,3*q^16-3*q^17+q^18,q^18-q^19,-q^10+q^11,0,
-3*q^8+6*q^9-q^10,-2*q^8,6*q^8-4*q^9,-2*q^11+3*q^12+q^14,-q^8+q^10-2*q^11,
-10*q^8,-10*q^24,10*q^16]);end;
  f22:=function(r,p)local q;q:=-r/p;return adj(p,
[15,-6+9*q,1-5*q+4*q^2,-4*q+3*q^2,3-6*q+6*q^2,
1-3*q+2*q^2-q^3,-1+2*q-4*q^2+3*q^3,-q^2+q^3,-q^2,q-2*q^2+2*q^3,-4*q^2+3*q^4,
0,0,q^13-2*q^14+2*q^15,q^2-3*q^3+q^4,q^2-3*q^3+q^5,q^36-5*q^37+4*q^38,-q^8,0,
q^12-5*q^13+4*q^14,1-2*q+3*q^2-6*q^3+8*q^4-6*q^5+q^6,2*q^3-3*q^4,-q^14+q^15,
-q^12+2*q^13-4*q^14+3*q^15,-3*q^4+6*q^5-q^6+q^9,q^24-5*q^25+4*q^26,
q^24-3*q^25+2*q^26-q^27,q^12-3*q^13+2*q^14-q^15,0,3*q^12-6*q^13+6*q^14,
-4*q^14+3*q^16,-6*q^12+9*q^13,-3*q^16+6*q^17-q^18+q^21,2*q^15-3*q^16,
15*q^12,15*q^36,15*q^24]);end;
  f23:=function(r,p)local q;q:=-r/p;return adj(p,
  [15,-6+9*q,1-5*q+4*q^2,1-2*q+4*q^2,2-8*q+5*q^2,
1-3*q+3*q^2,3*q-5*q^2+2*q^3,-q^2+q^3,q^3,q-3*q^2+q^3,1-6*q^2+4*q^4,0,0,
q^13-3*q^14+q^15,2*q^2-4*q^3+q^5,q^2-3*q^3+q^5,q^36-5*q^37+4*q^38,-q^6,0,
q^12-5*q^13+4*q^14,1-2*q+3*q^2-4*q^3+9*q^4-6*q^5+2*q^6,4*q^3-2*q^4+q^6,
-q^14+q^15,3*q^13-5*q^14+2*q^15,3*q^3+3*q^5-4*q^6+q^9,q^24-5*q^25+4*q^26,
q^24-3*q^25+3*q^26,q^12-3*q^13+3*q^14,0,2*q^12-8*q^13+5*q^14,q^12-6*q^14+
4*q^16,-6*q^12+9*q^13,3*q^15+3*q^17-4*q^18+q^21,4*q^15-2*q^16+q^18,15*q^12,
15*q^36,15*q^24]);end;
  f24:=function(x,y,sgn)local v;v:=sgn*GetRoot(x*y,2);return
  [16,6*x+10*y,5*x*y+x^2+5*y^2,4*x*y+4*y^2,8*x*y+2*x^2+6*y^2,
-2*x*y^2-3*x^2*y-x^3,5*x*y^2+3*x^2*y+3*y^3,2*x*y^2+y^3,x*y^2+y^3,
3*x*y^2+x^2*y+2*y^3,-4*x^2*y^2+4*y^4,-v*x*y^2,-v*x^4*y^7,
-2*v*x^7*y^15-3*v*x^8*y^14-v*x^9*y^13,-x*y^4-3*x^2*y^3-x^3*y^2+y^5,
-2*x^2*y^3-x^3*y^2+y^5,-5*v*x^22*y^39-5*v*x^23*y^38-v*x^24*y^37,
0,x^3*y^5,-5*v*x^7*y^14-5*v*x^8*y^13-v*x^9*y^12,
6*x*y^5+8*x^2*y^4+6*x^3*y^3+3*x^4*y^2+2*x^5*y+x^6+2*y^6,
-3*x^2*y^4-2*x^3*y^3+y^6,-v*x^7*y^15-2*v*x^8*y^14,
-3*v*x^7*y^15-5*v*x^8*y^14-3*v*x^9*y^13,5*x^3*y^6+3*x^4*y^5+3*x^5*y^4+y^9,
5*x^15*y^27+5*x^16*y^26+x^17*y^25,-2*x^16*y^27-3*x^17*y^26-x^18*y^25,
2*v*x^8*y^14+3*v*x^9*y^13+v*x^10*y^12,x^6*y^10,
-6*v*x^7*y^14-8*v*x^8*y^13-2*v*x^9*y^12,-4*v*x^7*y^16+4*v*x^9*y^14,
-10*v*x^7*y^13-6*v*x^8*y^12,
-v*x^7*y^21-5*v*x^10*y^18-3*v*x^11*y^17-3*v*x^12*y^16,
-v*x^7*y^18+3*v*x^9*y^16+2*v*x^10*y^15,-16*v*x^7*y^12,-16*v*x^22*y^37,
16*x^15*y^25];
  end;
  f28:=function(r,p)local q;q:=-r/p;return adj(p,[20,-9+
11*q,2-7*q+4*q^2,2-6*q+4*q^2,4-10*q+6*q^2,1-2*q+2*q^2-q^3,-1+4*q-6*q^2+
2*q^3,q-3*q^2+q^3,q-q^2,2*q-3*q^2+q^3,2-2*q^2+4*q^4,0,0,-2*q^12+3*q^13-q^14,
-q+2*q^2-4*q^3+q^4,2*q^2-q^3+q^5,-2*q^33+7*q^34-4*q^35,0,0,-2*q^11+
7*q^12-4*q^13,1-2*q+2*q^2-4*q^3+8*q^4-6*q^5+q^6,-q^2+4*q^3-3*q^4,-q^12+
3*q^13-q^14,q^11-4*q^12+6*q^13-2*q^14,q^3-3*q^4+3*q^5+q^9,2*q^22-7*q^23+
4*q^24,q^22-2*q^23+2*q^24-q^25,-q^11+2*q^12-2*q^13+q^14,0,-4*q^11+
10*q^12-6*q^13,-2*q^11+2*q^13-4*q^15,9*q^11-11*q^12,-q^14+
3*q^15-3*q^16-q^20,q^13-4*q^14+3*q^15,-20*q^11,-20*q^33,20*q^22]);end;
  f30:=function(r,p,I)local q;q:=-r/p;return adj(p,
[20,-11+9*q,4-7*q+2*q^2,4-4*q+2*q^2,6-10*q+
4*q^2,1+(I-3)*q+4*q^2-q^3,-2+6*q-4*q^2+q^3,-1+q-q^2,q-I*q^2,-1+
3*q-2*q^2,4-6*q^2+2*q^4,0,0,-I*q^9+3*I*q^10-2*I*q^11,-q+4*q^2+
(I-3)*q^3-I*q^4,-1+3*q^2-2*q^3,-4*I*q^27+7*I*q^28-2*I*q^29,
0,0,4*I*q^9-7*I*q^10+2*I*q^11,1-6*q+(-2*I+8)*q^2+
(2*I-6)*q^3+6*q^4+(-2*I-4)*q^5+q^6,-3*q^2+4*q^3+(2*I-1)*q^4,
-I*q^9+I*q^10-I*q^11,-2*I*q^9+6*I*q^10-4*I*q^11+I*q^12,
-1+4*q^3-3*q^4+3*q^5-q^6,-4*q^18+7*q^19-2*q^20,-q^18+(-I+3)*q^19-4*q^20+
q^21,I*q^9+(-3*I-1)*q^10+4*I*q^11-I*q^12,0,
6*I*q^9-10*I*q^10+4*I*q^11,4*I*q^9-6*I*q^11+2*I*q^13,
-11*I*q^9+9*I*q^10,-I*q^9+4*I*q^12-3*I*q^13+
3*I*q^14-I*q^15,-3*I*q^11+4*I*q^12+(-I-2)*q^13,20*I*q^9,-20*I*q^27,-20*q^18]);
 end;
  f34:=function(r,p)local q;q:=-r/p;return adj(p,
[24,-12+12*q,4-8*q+4*q^2,2-4*q+2*q^2,6-12*q+6*q^2,
2-6*q+6*q^2-2*q^3,-2+6*q-6*q^2+2*q^3,0,0,-1+3*q-3*q^2+q^3,2-12*q^2+2*q^4,
q^2,q^6,q^10-3*q^11+3*q^12-q^13,4*q^2-4*q^3,4*q^2-4*q^3,-4*q^30+
8*q^31-4*q^32,0,-q^4,-4*q^10+8*q^11-4*q^12,2-8*q+12*q^2-12*q^3+
12*q^4-8*q^5+2*q^6,-2*q^2+4*q^3-2*q^4,0,2*q^10-6*q^11+6*q^12-2*q^13,
6*q^3-6*q^4+6*q^5-6*q^6,4*q^20-8*q^21+4*q^22,2*q^20-6*q^21+6*q^22-2*q^23,
-2*q^10+6*q^11-6*q^12+2*q^13,-q^8,-6*q^10+12*q^11-6*q^12,-2*q^10+
12*q^12-2*q^14,12*q^10-12*q^11,-6*q^13+6*q^14-6*q^15+6*q^16,2*q^12-4*q^13+
2*q^14,-24*q^10,-24*q^30,24*q^20]);end;
  f35:=function(r,p,I)local q;q:=-r/p;return adj(p,
[24,-12+12*q,4-8*q+4*q^2,2-8*q+2*q^2,
6-12*q+6*q^2,2+(-I-3)*q+(I+3)*q^2-2*q^3,-2+6*q-6*q^2+2*q^3,2*q-2*q^2,
(-I+1)*q+(I-1)*q^2,-1+3*q-3*q^2+q^3,2-4*q^2+2*q^4,-I*q^2,I*q^6,
-I*q^10+3*I*q^11-3*I*q^12+I*q^13,(-I-1)*q+(I+3)*q^2+
(-I-3)*q^3+(I+1)*q^4,2*q^2-2*q^3,-4*I*q^30+8*I*q^31-4*I*q^32,
0,q^4,4*I*q^10-8*I*q^11+4*I*q^12,2+(2*I-6)*q+(2*I+8)*q^2+
(-4*I-8)*q^3+(2*I+8)*q^4+(2*I-6)*q^5+2*q^6,(-2*I-2)*q^2+4*q^3+
(-2*I-2)*q^4,2*I*q^11-2*I*q^12,-2*I*q^10+
6*I*q^11-6*I*q^12+2*I*q^13,2*q^3-6*q^4+6*q^5-2*q^6,-4*q^20+
8*q^21-4*q^22,-2*q^20+(I+3)*q^21+(-I-3)*q^22+2*q^23,2*I*q^10+
(-3*I+1)*q^11+(3*I-1)*q^12-2*I*q^13,-q^8,6*I*q^10-12*I*q^11+
6*I*q^12,2*I*q^10-4*I*q^12+2*I*q^14,-12*I*q^10+12*I*q^11,
2*I*q^13-6*I*q^14+6*I*q^15-2*I*q^16,(-2*I+2)*q^12+
4*I*q^13+(-2*I+2)*q^14,24*I*q^10,-24*I*q^30,-24*q^20]);end;
  f37:=function(r,p)local q;q:=-r/p;return adj(p,[30,-15+15*q,5-10*q+5*q^2,
3-8*q+3*q^2,7-16*q+7*q^2,2-5*q+5*q^2-2*q^3,-2+8*q-8*q^2+2*q^3,2*q-2*q^2,
q-q^2,-1+4*q-4*q^2+q^3,3-8*q^2+3*q^4,0,0,-q^10+4*q^11-4*q^12+q^13,-q+
4*q^2-4*q^3+q^4,3*q^2-3*q^3,5*q^30-10*q^31+5*q^32,q^5+q^7,0,5*q^10-10*q^11+
5*q^12,2-8*q+11*q^2-12*q^3+11*q^4-8*q^5+2*q^6,-3*q^2+4*q^3-3*q^4,
2*q^11-2*q^12,-2*q^10+8*q^11-8*q^12+2*q^13,5*q^3-6*q^4+6*q^5-5*q^6,
5*q^20-10*q^21+5*q^22,2*q^20-5*q^21+5*q^22-2*q^23,2*q^10-5*q^11+
5*q^12-2*q^13,0,7*q^10-16*q^11+7*q^12,3*q^10-8*q^12+3*q^14,-15*q^10+15*q^11,
5*q^13-6*q^14+6*q^15-5*q^16,-3*q^12+4*q^13-3*q^14,30*q^10,30*q^30,30*q^20]);end;
  tbl.irreducibles:=[f1(r),f1(p),f3(r,p),f3(p,r),
  f5(r,p,E(4)),f5(p,r,E(4)),f5(r,p,-E(4)),f5(p,r,-E(4)),
  f9(r,p),f9(p,r),f11(r,p),f12(r,p),f12(p,r),
  f14(r,p,E(4)),f14(r,p,-E(4)),f17(r,p),f17(p,r),
  f18(r,p),f18(p,r),f22(r,p),f23(r,p),f22(p,r),f23(p,r),
  f24(r,p,1),f24(p,r,1),f24(r,p,-1),f24(p,r,-1),
  f28(r,p),f28(p,r),
  f30(r,p,E(4)),f30(p,r,E(4)),f30(r,p,-E(4)),f30(p,r,-E(4)),
  f34(r,p),f35(r,p,E(4)),f35(r,p,-E(4)),f37(r,p)]*q^0;
  tbl.centralizers:=List(tbl.classes,x->tbl.order/x);
  tbl.irredinfo:=List(CHEVIE.RawData("CharInfo","G29")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G29")(x,rec())));
  return CHEVIE.compat.MakeCharacterTable(tbl);
end);

CHEVIE.AddData("CharTable","G29",function()local res;
  res:=CHEVIE.RawData("HeckeCharTable","G29")(List([1..4],x->[1,-1]),[]);
  res.identifier:="G29"; res.name:="G29";
  res.galomorphisms:=Group((6,9)(12,13)(17,20)(21,22)(23,24)(27,28)(32,33)(35,36));
  res.text:="origin: HeckeCharTable";
  return res;
end);

# Completed JM dec. 2014 using Marin-Pfeiffer
CHEVIE.AddData("HeckeRepresentation","G29",function(para,root,i)
  local x,y,rep,f1,f3,f5,f9,f11,f12,f14,f17,f18,f21,f22,f27,f28,f30,f34,f35,f37;
  x:=para[1][1];y:=para[1][2];
  f1:=x->[[[x]],[[x]],[[x]],[[x]]];
  f3:=function(x,y)return WGraph2Representation([[[1,2,3],[1,2,4],[1,3,4],
   [2,3,4]],[[1,2,-x,y],[1,3,-x,y],[3,4,-x,y]]],[x,y])*x^0*y^0;end;
  f5:=function(x,y,I)return WGraph2Representation([[[1,2,3],[1,2,4],[1,3,4],
    [2,3,4]],[[1,2,-x,y],[1,3,-x,y],[2,3,(-I-1)*x,(-I+1)*y],[3,4,-x,y]]],
    [x,y])*x^0*y^0;end;
  f9:=function(x,y)return WGraph2Representation([[[1,3],[4],[2],[2,3],[1,4]], 
    [[1,4,-y,x],[1,5,-y,x],[2,4,x,-y],[2,5,0,-y],[3,4,0,x],[3,5,-y,x]]],[y,x])
    *x^0*y^0;end;
  f11:=function(x,y)return List(f3(x,y),m->ExteriorPower(m,2)/x);end;
  f12:=function(x,y)local R;
    R:=WGraph2Representation([[[2],[1,3,4],[1,3],[1,2,4],[2,3],[4]], 
     [[1,2,x,-y],[1,4,0,-y],[1,5,0,-y],[2,3,x,0],[2,6,-y,0],[3,4,-y,x],
     [3,5,-y,x],[4,6,-y,0],[5,6,-y,x]]],[x,y])*x^0*y^0;
    return [R[1],R[2],R[3]^R[4],R[4]];
  end;
  f14:=function(x,y,I)return List(f5(x,y,I),m->ExteriorPower(m,2)/x);end;
  f17:=function(x,y)local R;
    R:=WGraph2Representation([[[1,2,3],[1,3,4],[1,2,4],[2,3],[1,3,4],[2,4],
      [2,3,4],[1,3,4],[1,2,4],[1,2,3]],[[1,2,y,-x],[1,3,y,-x],[1,4,-y,0],
      [2,6,y,-x],[3,5,-y,x],[3,6,y,0],[3,8,-y,0],[4,5,x,-y],[4,6,-y,x],
      [4,7,0,x-y],[4,10,0,x-y],[5,9,-y,0],[6,7,0,-x+y],[6,9,0,x-y],[7,8,x,-y],
      [8,9,y,-x],[8,10,-y,x],[9,10,x,-y]]],[x,y])*x^0*y^0;
    return [R[1],R[2],R[3]^R[4],R[4]];
  end;
  f18:=function(x,y)local R;R:=WGraph2Representation([[[1,3,4],[1,2,4],[1,2,3],
    [1,4],[1,3],[1,2],[2,3,4],[3,4],[2,4],[2,3]],[[1,4,-y,0],[1,5,-y,0],
    [1,6,-y,x],[1,7,-y,x],[1,8,-y,0],[2,4,x,0],[2,5,x,-y],[2,6,x,0],[2,9,-x,0],
    [3,4,-y,x],[3,5,-y,0],[3,6,-y,0],[3,10,-y,0],[4,9,-y,x],[5,10,-x,y],
    [7,8,-y+x,0],[7,9,-y-x,0],[8,9,x,-y],[8,10,-x,y],[9,10,x,-y]]],[x,y])
    *y^0*x^0;
    return [R[1],R[2],R[3]^R[4],R[4]];
  end;
  f21:=function(x,y)return
  [[[0,0,x+y,0,0,x,0,0,0,0,0,0,0,0,0],[0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0],[0,x*y,
x+y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,y^2,0,0,0,0,0,0,0],[0,
x*y^4+x^2*y^3,x*y^3+y^4,0,x,0,0,x*y^3,0,0,0,0,0,0,0],[-y,-x*y-y^2,0,0,0,x+y,0,
0,0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,0,0,-y,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,x,0,0,1,0,0,0],[x*y^3+y^4,2*x*y^4+x^2*y^3+y^5,0,0,0,
-x*y^3-y^4,0,0,0,x,x*y^2,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,y,0,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,x+y,-y,0],[0,0,0,0,0,0,0,0,0,0,
0,0,x,0,0],[x*y^2+y^3,x*y^3+y^4,-x*y^2-y^3,0,0,-x*y^2-y^3,0,0,0,0,0,x,0,0,x]],
[[x,-y^2,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,-x,0,0,0,0,0,0,0],[0,0,x*y+y^2,x+y,0,x*y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,x,0],[0,0,0,-1,0,0,0,x+y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
-x,0,0,0,0],[0,0,y,0,0,0,0,x+y,0,0,0,0,0,0,0],[0,0,x*y+x^2,x+y,0,x*y+x^2,x+y,
-x*y-y^2,-x^2*y^-1,0,x+y,0,0,0,x*y^-1],[0,-x*y^4-y^5,x*y^3+x^2*y^2,x*y^2+y^3,
-x-y,x*y^3+x^2*y^2,x*y^2+x^2*y,-x*y^3-y^4,-2*x*y^2-x^2*y-y^3,x,x*y^2+x^2*y,0,
0,x+y,x*y+y^2],[0,0,0,0,0,0,y,0,0,0,x+y,0,0,0,0],[0,-x*y^3-x^2*y^2,
x*y^2+x^2*y,x*y+y^2,0,x*y^2+x^2*y,0,-x*y^2-y^3,-x*y-x^2,0,0,x,0,0,x],[0,y^5,0,
0,0,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,-y,0,0,0,0,0,0,0,0,x+y,0],[0,0,
x*y^2+2*x^2*y+x^3,2*x*y+x^2+y^2,0,x*y^2+2*x^2*y+x^3,2*x*y+x^2+y^2,
-2*x*y^2-x^2*y-y^3,-x*y-x^2-y^2-x^3*y^-1,0,2*x*y+x^2+y^2,0,0,0,x+y+x^2*y^-1]],
[[x,-y^2,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,y,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,y^-1,0,0,0,0,0,0,0,0,0,0],[0,0,0,-x*y^2,x+y,0,
0,0,0,0,0,0,0,0,0],[0,0,x,0,0,x,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,-x,0,0,0,
0,0,0],[0,x*y+x^2,x+y,0,0,0,0,x,0,0,0,0,0,0,0],[0,0,0,0,0,0,y,0,x+y,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y],[0,0,0,0,0,0,0,0,0,0,0,x*y^-1,0,0,0],[0,
0,0,0,0,0,0,0,0,0,-y^2,x+y,0,0,0],[0,y^5,0,0,0,0,0,0,0,0,0,0,x,0,0],[0,
x*y^4+y^5,y^4,0,0,0,0,0,0,0,0,0,0,x,0],[0,0,0,0,0,0,0,0,0,-1,0,0,0,0,x+y]],
[[0,-x*y,0,0,0,0,0,0,0,0,0,0,0,0,0],[1,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,-x,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-x,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
x,0,0,0,0,0],[0,0,y,0,0,x+y,0,0,0,0,0,0,0,0,0],[0,0,0,y,0,0,x+y,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,x*y^-1,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],[0,0,
0,0,-y,0,0,0,0,x+y,0,0,0,0,0],[0,0,0,0,0,0,0,-y^2,0,0,x+y,0,0,0,0],[x*y^2+y^3,
x*y^3+y^4,-x*y^2-y^3,0,0,-x*y^2-y^3,0,0,0,0,0,x,0,0,0],[x*y^3+y^4,x*y^4+y^5,
x^2*y^2+x^3*y,x*y^2+y^3,0,x^2*y^2+x^3*y,x*y^2+y^3,0,-x^2*y-x^3,0,0,0,x,0,
x*y+x^2],[x*y^3+y^4,x*y^4+y^5,x^2*y^2+x^3*y,x*y^2+y^3,0,x^2*y^2+x^3*y,
x*y^2+y^3,-x*y^3-y^4,-x^2*y-x^3,0,x*y^2+y^3,0,0,x,x*y+x^2],[0,0,0,0,0,0,0,0,
-x*y,0,0,0,0,0,x+y]]]*x^0*y^0;end;
  f22:=function(x,y)local R;R:=WGraph2Representation(
  [[[1,3,4],[1,2,4],[1,2,3],[1,4],[1,3],[2],[1,2,3],[1,3,4],[1,2,4],[2,3],[1,3,
4],[2,4],[3,4],[2,4],[2,3]],[[1,4,-1,0],[1,5,-1,0],[1,6,-1,y*x],[1,13,-1,0],
[2,4,-x,0],[2,5,-x,y],[2,6,-x,0],[2,12,y,0],[2,14,-1,0],[3,4,-y,x],[3,5,-y,0],
[3,6,-y,0],[3,8,0,-x],[3,9,0,-x^2],[3,10,-y,0],[3,15,-x,0],[4,7,0,y],[4,8,0,
-y],[4,9,0,-2*y*x],[4,11,0,-y],[4,14,-1,y*x],[5,7,0,-y],[5,8,0,-x],[5,11,0,
-x],[5,15,x,-y],[6,9,0,-y*x],[6,10,0,x],[6,12,0,x],[6,14,0,y*x],[6,15,0,-y],
[7,8,y,-x],[7,9,y*x^-1,-x^2],[7,15,y,0],[8,12,y,-x],[8,13,-y,0],[9,11,-y*x,1],
[9,12,y^2,0],[9,14,-y+x,0],[10,11,x,-y],[10,12,-y,x],[10,14,0,y*x],[11,13,-x,
0],[12,15,0,y^2*x^-1],[13,14,-1,y*x],[13,15,x,-y],[14,15,x^2,-y*x^-1]]],[x,y])
*y^0*x^0;
    return [R[1],R[2],R[3]^R[4],R[4]];
  end;
  f27:=function(x,y,sgn)local v,R;v:=sgn*GetRoot(x*y,2);
    R:=WGraph2Representation([[[1,3,4],[1,2,4],[1,2,3],[1,4],[1,3],[1,2],
    [1,2,3],[1,3,4],[1,2,4],[2,3],[1,3,4],[2,4],[3,4],[2,4],[2,3],[2,3,4]],
    [[1,4,-y,0],[1,5,-y,0],[1,6,-y,x],[1,16,-v,v],[2,4,-v,0],[2,5,-v,v],
    [2,6,-v,0],[2,12,v,0],[2,14,v,0],[3,4,-y,x],[3,5,-y,0],[3,6,-y,0],
  [3,15,v,0],[4,8,0,-v+y],[4,9,0,v-x],[4,11,0,-v+y],[4,14,-v,v],[5,7,0,y^2/v-y],
    [5,8,0,-v+y],[5,10,-x,0],[5,11,0,-v+y],[5,15,x,-y],[7,8,v,-v],[7,9,y,-x],
    [7,10,-y,0],[7,15,-x+y,0],[8,12,v,-v],[8,13,-v+y,0],[9,11,-v,v],[9,12,y,0],
    [9,14,-x+y,0],[10,11,v,-v],[10,12,-y,x],[10,13,0,v],[10,16,0,-v],
    [11,13,-v+x,0],[11,15,0,v],[13,14,-v,v],[13,15,-v,v],[14,15,-x,y],
    [14,16,0,-y],[15,16,0,v]]],[x,y])*x^0*y^0;
    return [R[1],R[2],R[3]^R[4],R[4]];
  end;
  f28:=function(x,y)return
[[[0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x],[y,x+y,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,y],[0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,-x-y,0,0,0],[0,0,0,0,0,0,-y,0,0,
0,0,0,0,0,0,0,0,-x,0,0],[0,0,-x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,-x-y,0,0,0],[0,0,
0,0,0,0,0,y,0,0,0,-x-y,0,0,0,x,2*x+y+x^2*y^-1,3*x+y+x^2*y^-1,-x-y,x],[0,0,0,x,
0,0,x+y,0,0,0,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,0,-x,0,x+y,x+y,0,0,0,0,0,0,x,0,x,
0,-y],[0,0,0,0,0,0,0,0,0,0,0,-x,0,0,0,0,x+x^2*y^-1,x+x^2*y^-1,-x,x],[0,0,0,0,
0,0,0,0,0,y,0,0,0,0,0,0,-y,-x,0,0],[0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,x,0,0,0,0],
[0,0,0,0,0,0,0,0,y,0,0,x+y,0,0,0,0,-x-y,-x-y,y,-y],[0,0,0,0,0,0,0,0,0,0,0,0,0,
-y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,x,x+y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,y,-x,-x,-x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0],[0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,x]],[[x,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,x,x],[0,0,y,0,-y,0,0,0,0,0,-x-y,
0,0,0,0,x,0,0,-x-y,-x-y],[0,-x,x+y,0,0,0,0,0,0,0,-x,-x,0,0,0,x,0,0,-x,0],[0,0,
0,y,0,0,-x,0,0,0,0,0,0,y,0,0,0,0,x+y,0],[0,0,0,0,x+y,0,0,0,0,0,0,-x,0,0,0,0,0,
0,0,x],[-x,0,0,0,0,y,x,0,0,0,x^2*y^-1,0,0,-x^-1*y^2-y,y,-x-x^2*y^-1,y,0,
-3*x-2*y,-x],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,y,0,x,0,0,-y,
y,0,0,x,0,0,y,0,y,y],[-x,0,0,0,0,0,0,0,y,0,x^2*y^-1,0,0,-x-y,0,-x-x^2*y^-1,0,
0,-2*x-y,0],[0,0,0,0,0,0,-x,x,0,x+y,0,-x,0,0,x,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,-x,-x],[0,0,0,0,y,0,0,0,0,0,y,0,0,0,0,0,0,0,y,x+y],[0,0,0,0,
0,0,0,0,0,0,0,0,0,-x-y,0,0,0,y,-x-y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,0,-y,0,0,x],[0,0,0,0,0,0,0,0,0,0,-x,0,0,0,
0,x,0,0,-x,-x],[0,0,0,0,0,0,0,0,0,0,x,0,0,x,x,0,x+y,0,x,0],[0,0,0,0,0,0,0,0,0,
0,0,0,-x,-x-y,0,0,0,x+y,-x-y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0],[0,
0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,y,x+y]],[[y,0,0,0,0,0,x,0,0,0,0,0,0,y,0,0,x,
0,x^-1*y^2,0],[0,y,0,-x,0,0,-x-y,0,0,0,0,0,-y,-x^-1*y^2-y,0,0,-x-y,-x,
-x^-1*y^2-y,0],[0,0,0,-x-y,0,0,0,0,0,0,0,0,-y,0,y,y,-x,-x,0,0],[0,0,0,x+y,0,0,
y,0,0,0,0,0,y,y,0,0,0,x,0,0],[0,0,0,0,0,0,x+y,0,0,0,0,0,0,y,y,0,0,0,0,0],[0,0,
0,-x^-1*y^2-x-2*y,x,0,-x^-1*y^2-2*x-3*y,0,y,0,0,0,-x^-1*y^2-x-2*y,
-x^-1*y^2-x-3*y,-x-y,0,x^2*y^-1,-x-y,-x,0],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,
0,0,0],[0,0,0,0,x,0,-x-y,x+y,0,0,0,-x,0,-y,0,0,y,0,y,0],[0,0,0,-x-y,0,-x,-x-y,
0,x+y,0,0,0,-x-y,-x-y,-x,0,x^2*y^-1,0,-x,0],[0,0,0,0,0,0,y,0,0,0,y,0,0,y,y,0,
0,0,0,0],[0,0,0,0,x,0,-x,0,0,-x,x+y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,
0,0,0,y,0,y,0,y,0],[0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,x,0,0,0,0,0,0],[0,0,0,0,-x,0,x+y,0,0,0,0,0,0,y,x+y,0,0,0,0,0],[0,0,
-x,-x,x,0,-x,0,0,0,0,0,0,0,0,x+y,-x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
0,0,0],[0,0,0,-y,0,0,-y,0,0,0,0,0,-y,-y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,x,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,y,y]],[[y,0,0,0,0,0,0,0,
y,0,0,0,0,0,0,0,-y,-x-y,y,0],[0,y,0,0,0,0,0,0,0,0,0,y,0,0,0,0,-x-y,0,
-x^-1*y^2,0],[0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0,-x-y,-y,0,0],[0,0,x,x+y,0,0,0,
0,0,0,0,0,0,0,0,0,x+y,y,0,0],[0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,y,0,0,x,-x,0,0,0,y,y,0,-x^-1*y^2-2*x-2*y,-x^-1*y^2-y,-y,x+x^2*y^-1],[0,0,
0,0,-x,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,y,0,-x,0,-y,0,y,y,0,0,
0,x^-1*y^2,0],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,-x,0,-y,x^2*y^-1],[0,0,0,0,0,0,
0,0,0,x,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,-x-y,0,0,0],[0,
0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,y,0,x^-1*y^2,-x],[0,0,0,0,0,0,0,0,0,0,x,0,x+y,0,
0,-x,x^-1*y^2+y,0,0,0],[0,0,0,0,0,0,0,0,0,0,-x,0,0,x+y,0,0,-x-y,0,0,0],[0,0,0,
0,0,0,0,0,0,0,x,0,0,-y,x,0,x+y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,y,y,0,0,
x^-1*y^2-x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,x+y,-x^2*y^-1],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,x^-1*y^2,0]]];end;
f30:=function(x,y,i)return
[[[0,x*y,0,0,0,0,0,0,0,-i*x^4,0,0,0,0,x*y^3+x^2*y^2,0,0,0,i*x^3*y^2+i*x^4*y,
-i*x^3*y^2-x^5],[-1,x+y,0,0,0,0,0,0,0,-i*x*y^2-i*x^2*y-i*x^3,0,0,0,0,
x*y^2+x^2*y,0,0,0,i*x^2*y^2+i*x^3*y,-i*x^2*y^2-x^4],[0,0,y,0,0,0,0,0,0,
-i*x*y^2-2*i*x^2*y-i*x^3-i*y^3,0,0,0,0,0,0,0,0,-x^2*y^2,
x*y^3+x^2*y^2-x^3*y+i*y^4],[0,0,0,y,0,0,0,0,0,x^2*y,0,0,0,0,0,0,0,0,
-i*x*y^3+(-i-1)*x^2*y^2+(-2*i-1)*x^3*y-i*x^4,x^2*y^2+i*y^4],[0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,x*y^3+y^4,
-i*x*y^3-i*x^2*y^2-i*x^3*y,-i*x*y^3-x^3*y],[0,0,0,0,0,0,x*y^2,0,0,
0,0,0,0,0,0,0,0,0,0,-x^2*y],[0,0,0,0,0,-y^-1,x+y,0,0,0,0,0,0,0,0,0,0,0,0,-x],
[0,0,0,0,0,0,0,y,0,y^3,0,0,0,0,0,0,0,0,-y^4,(i+1)*y^4],[0,0,0,0,0,0,0,0,0,
0,y,0,0,0,0,0,0,0,0,y],[0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,
0,0,-x,0,x+y,0,0,0,0,0,0,0,0,y],[0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,-1,0,0,0],
[0,0,0,0,0,0,0,0,0,-i*x^3,0,0,0,x*y,0,0,0,0,i*x^3*y,-i*x^2*y^2-x^4],
[0,0,0,0,0,0,0,0,0,-i*x^2,0,0,-1,x+y,0,0,0,0,i*x^2*y,-i*x*y^2-x^3],
[0,0,0,0,0,0,0,0,0,i*x,0,0,0,0,y,0,0,0,0,0],[0,0,0,0,-1,0,0,0,0,0,0,0,0,0,
0,x+y,0,x*y^2+y^3,-i*x^2*y,-x^2*y-i*y^3],[0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,
0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,-i*x,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,x,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x]],[[0,
x*y+y^2,-x*y,0,0,0,0,0,0,0,
(i+1)*x^2*y^3+(3*i+1)*x^3*y^2+(i-1)*x^4*y+(-i+1)*x^5,0,x*y+y^2,
-x*y^2-y^3,0,0,0,-x^3*y^2+(i+1)*x^5,0,0],[0,y,0,0,0,0,0,0,0,0,
-x*y^3+i*x^2*y^2-x^3*y-i*x^4,0,0,-x*y-y^2,-x*y^2-x^2*y,0,0,x^3*y+x^4,0,
0],[1,-x-y,x+y,0,0,0,0,0,0,0,
(i-1)*x*y^3-2*x^2*y^2-2*i*x^3*y-i*x^4-y^4,0,-x-y,0,-x*y^2-x^2*y,0,0,
x^2*y^2+(i+2)*x^3*y+x^4,0,0],[0,0,0,0,0,0,0,0,0,x*y^2,i*x*y^3+x^3*y,0,0,
0,0,0,0,(-i+1)*x^2*y^2+2*x^3*y+x^4,0,0],[0,0,0,0,0,x*y,0,0,0,0,
-i*x^2*y^2+(-i+1)*x^3*y,0,0,0,0,0,0,x*y^3+2*x^2*y^2+(i+1)*x^3*y,0,0],
[0,0,0,0,-1,x+y,0,0,0,0,-i*x*y^2+(-i+1)*x^2*y,0,0,0,0,0,0,
2*x*y^2+(i+1)*x^2*y+y^3,0,0],[0,0,0,0,0,0,0,0,0,0,-i*x,-x*y,0,0,0,0,0,0,
0,0],[0,0,0,0,0,0,0,y,0,0,x*y^3+(-i-1)*y^4,0,0,0,0,0,0,
i*x*y^3+(-i+1)*y^4,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,-i*y,y,0],
[0,0,0,-y^-1,0,0,0,0,0,x+y,x^2+i*y^2,0,0,0,0,0,0,
(-i+1)*x*y+2*x^2+x^3*y^-1,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,1,0,0,0,i,x+y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
i*x^2*y^2-x^3*y+(-i+1)*x^4,0,y,0,0,0,0,(i+1)*x^4,0,0],[0,0,0,0,0,0,0,
0,0,0,-x^2*y-i*x^3,0,0,0,-x*y,0,0,x^3,0,0],[0,0,0,0,0,0,0,0,0,0,
x*y+i*x^2,0,0,1,x+y,0,0,-x^2,0,0],[0,0,0,0,0,0,0,0,0,0,
-i*x*y^2-i*x^2*y,0,0,0,0,0,-x*y^2,x*y^2+x^2*y,0,0],[0,0,0,0,0,0,0,0,0,0,
i*x+i*y,0,0,0,0,y^-1,x+y,-x-y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
0,0],[0,0,0,0,0,0,0,0,-x,0,x,0,0,0,0,0,0,-i*y,x+y,0],[0,0,0,0,0,0,0,0,0,0,
-x,0,0,0,0,0,0,-i*x,0,y]],[[0,0,0,0,-x*y,0,0,0,0,0,0,
-i*x^3*y^3+x^4*y^2+i*x^5*y-i*x^6+i*x^7*y^-1,x*y+y^2,0,0,0,
x^3*y^2+(i+1)*x^4*y+(i-1)*x^5-i*x^6*y^-1,x*y^4+x^2*y^3,0,0],[0,0,0,0,
0,0,0,0,0,0,0,(i+1)*x^3*y^2+(2*i-1)*x^4*y-x^5,0,x*y+y^2,0,-x*y,x^3*y,
x*y^3+x^2*y^2,0,0],[0,0,0,y,0,0,0,0,0,0,0,
-x*y^4+i*x^2*y^3+(2*i-1)*x^3*y^2-x^4*y+(i-1)*x^5,0,0,0,0,
i*x^2*y^2+(i-1)*x^3*y-i*x^4,0,0,-x*y^3-x^2*y^2],[0,0,-x,x+y,0,0,0,0,
0,0,0,-x*y^4+i*x^2*y^3+(3*i-2)*x^3*y^2-2*x^4*y-x^5,0,0,0,0,
x^2*y^2+i*x^3*y,0,0,-x^2*y^2-x^3*y],[1,0,0,0,x+y,0,0,0,0,0,0,
i*x*y^4+2*i*x^2*y^3+(i-1)*x^3*y^2-i*x^4*y+i*x^5,-x-y,0,
x*y^2+y^3,0,(i-1)*x^2*y^2+(i-2)*x^3*y-i*x^4,0,0,0],[0,0,0,0,0,0,0,0,
x*y^2,0,0,(-i+1)*x^3*y+i*x^4,0,0,0,0,
(i-1)*x*y^2+(i-2)*x^2*y-i*x^3,0,0,-x*y^2-y^3],[0,0,0,0,0,0,0,0,0,0,y,
(i-1)*x*y-x^2,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,
-2*x*y^4+(-2*i+1)*x^2*y^3,0,0,0,0,(i-1)*x*y^3+y^4,0,0,0],[0,0,0,0,0,
-y^-1,0,0,x+y,0,0,(i-1)*x*y-i*x^2,0,0,0,0,(i-1)*x,0,0,-x-y],[0,0,0,0,
0,0,0,0,0,0,0,-x^2*y-i*x^3,0,0,0,0,x*y+i*x^2,0,x*y,0],[0,0,0,0,0,0,-x,0,
0,0,x+y,(i-1)*x*y-x^2,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,
0,0,0],[0,0,0,0,0,0,0,0,0,0,0,x^3*y^2+i*x^4*y-i*x^5+i*x^6*y^-1,y,0,0,
0,i*x^3*y+(i-1)*x^4-i*x^5*y^-1,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
x^2*y^2+2*i*x^3*y-x^4,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
-i*x^2*y+x^3,0,0,0,0,0,-x*y,0,0],[0,1,0,0,0,0,0,0,0,0,0,
(i+1)*x*y^3+(2*i-1)*x^2*y^2-x^3*y,0,-x-y,x*y+y^2,x+y,-x^2*y,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,i*x*y-x^2,0,0,
1,0,0,x+y,0,0],[0,0,0,0,0,0,0,0,0,-1,0,-x*y-i*x^2,0,0,0,0,i*x+y,0,x+y,
0],[0,0,0,0,0,0,0,0,0,0,0,(i-1)*x^2-i*x^3*y^-1,0,0,0,0,
(-i+1)*x+i*x^2*y^-1,0,0,y]],[[0,0,0,0,0,0,i*x^3*y^2+x^5,0,0,0,0,
x^4*y^2+x^5*y+(-i+1)*x^6,x*y,0,0,0,(-i+1)*x^3*y^2+x^4*y+(i-1)*x^5,
x^5,-x^6*y^-1,0],[0,0,0,0,0,0,i*x^2*y^2+x^4,0,0,0,0,
-i*x*y^4+(-i+1)*x^2*y^3+(-i+3)*x^3*y^2+2*x^4*y+x^5,0,x*y,-x*y^2-y^3,
0,-x^2*y^2-x^3*y-x^4,x^2*y^2+x^3*y+x^4,0,0],[0,0,y,0,0,0,
-x*y^3-x^2*y^2+x^3*y-i*y^4,0,0,0,0,
(-i-1)*x*y^4+(-i-1)*x^2*y^3+(-i+1)*x^3*y^2+(-i+2)*x^4*y-i*y^5,
0,0,0,0,-i*x*y^3+(i-2)*x^3*y-x^4,i*x*y^3+x^2*y^2+2*x^3*y+x^4,-x^4,0],
[0,0,0,0,0,0,-x^2*y^2-i*y^4,y,x*y^3+x^2*y^2,x*y^2+y^3,-x*y^3-y^4,
-i*x*y^4+x^2*y^3+(i-1)*x^3*y^2,0,0,0,0,-x*y^3,
i*x*y^3+x^2*y^2+2*x^3*y+x^4,-x*y^3+x^3*y-y^4,0],[0,0,0,0,y,0,
i*x*y^3+x^3*y,0,0,0,0,(i+1)*x^2*y^3+x^3*y^2+(-i+1)*x^4*y,0,0,0,0,
(i-1)*x^3*y,x^2*y^2+x^3*y-y^4,-x^4,0],[0,0,0,0,0,0,x^2*y,0,0,0,0,
(-i+1)*x^3*y,0,0,0,0,(i-1)*x^2*y,0,-x^3,-x*y^2],[0,0,0,0,0,0,x,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,0,0,-x,0,0,(-i-1)*y^4,x+y,x^2*y^2+x^3*y,x*y^2+x^2*y,
-x*y^3-x^2*y^2,-2*x*y^4,0,0,0,0,y^4,i*x*y^3+x^2*y^2+2*x^3*y+x^4,
-x*y^3-2*x^2*y^2-x^3*y-y^4,0],[0,0,0,0,0,0,-y,0,y,0,0,(i-1)*x*y,0,0,0,0,0,
0,x,0],[0,0,0,0,0,0,0,0,0,y,0,x*y^2,0,0,0,0,-y^2,0,x^2,0],[0,0,0,0,0,0,-y,0,0,
0,y,(i-1)*x*y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0],
[-1,0,0,0,0,0,i*x^2*y^2+x^4,0,0,0,0,x^3*y^2+x^4*y+(-i+1)*x^5,x+y,0,0,0,
(-i+1)*x^2*y^2+x^3*y+(i-1)*x^4,x^4,-x^5*y^-1,0],[0,-1,0,0,0,0,
i*x*y^2+x^3,0,0,0,0,(-i+2)*x^2*y^2+2*x^3*y+x^4,0,x+y,-x*y-y^2,0,-x^3,
x^3,0,0],[0,0,0,0,0,0,0,0,0,0,0,i*x*y^2-x^2*y,0,0,y,0,x^2,-x^2,0,0],[0,0,0,
0,0,0,x^2*y+i*y^3,0,0,0,0,(i+1)*x*y^3+x^2*y^2+x^3*y,0,0,0,y,-x^2*y,
x^2*y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0],[0,0,0,0,0,y^-1,-x,
0,0,0,0,(i-1)*x^2,0,0,0,0,(-i+1)*x,0,x^2*y^-1,x+y]]];end;
f34:=function(x,y)return
[[[x,0,0,0,0,0,-x*y^3-x^2*y^2-x^3*y,0,0,0,0,0,0,0,0,0,0,x^2*y^3,0,
-x*y^3-3*x^2*y^2+2*y^4,-x*y^3-x^2*y^2-x^3*y,0,
-3*x*y^4-x^2*y^3+6*x^3*y^2+4*x^4*y,0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x^2*y^3-x^3*y^2-3*x^4*y,0,-3*x*y^3-2*x^2*y^2,0,0,
x*y^4+3*x^2*y^3+3*x^3*y^2+2*x^4*y,0],[0,0,x,0,0,0,-x^2*y^2-2*x^3*y-x^4,0,0,0,
0,0,0,0,0,0,0,x^4*y,0,-x*y^3,-x^2*y^2-2*x^3*y-x^4,0,-x*y^4+2*x^3*y^2,0],[0,0,
0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,x^2*y^2,0,x*y^2+2*y^3,-x*y^2-x^2*y,0,
-4*x*y^3-3*x^2*y^2,0],[0,0,0,-1,x+y,0,x*y+y^2,0,0,0,0,0,0,0,0,0,0,x^2*y,0,y^2,
0,0,-3*x*y^2-2*x^2*y,0],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,x^4,0,
x*y^2+x^2*y+y^3,-x^2*y-x^3,0,-x*y^3-x^2*y^2,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,y,-x,0,-x*y,0],[0,0,0,0,0,0,0,x+y,0,0,0,0,0,-y,0,0,0,0,0,y^2,0,0,
-x*y^2-x^2*y,0],[0,0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,-x*y^2,0,x*y+2*y^2,
-x*y-x^2,0,-2*x*y^2-x^2*y,0],[0,0,0,0,0,0,x+y,0,-1,x+y,0,0,0,0,0,0,0,-x*y,0,y,
0,0,-x*y,0],[0,0,0,0,0,0,x+y,0,0,0,x+y,0,-1,0,0,0,0,0,0,y,0,0,-x*y,0],[0,0,0,
0,0,-y,x*y^2+x^2*y,0,0,0,0,x+y,0,0,0,0,0,x^4,0,y^3,0,0,-x*y^3+x^3*y,0],[0,0,0,
0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,x*y+2*y^2,-x*y-x^2,0,-2*x*y^2-x^2*y,0],[0,0,
0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,y^2,0,0,-x*y^2-x^2*y,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,-x^2*y,y^3,0,0,x^2*y^2,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,-x*y,0,y,-x,x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y^2,x],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1/x,
0,0,0,x+y,-y^2/x,0,0,-x*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,
0],[0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,-y,x+y,0,x*y,0],[0,0,0,0,0,0,y,0,0,
0,0,0,0,0,0,-y,0,-x*y,0,0,0,x+y,x*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,y^2,x+y]],[[0,0,0,
x*y,0,0,-x*y^3-x^2*y^2,x*y^2+y^3,0,0,0,0,x*y^2+x^2*y+y^3,0,0,0,0,0,0,
-x*y^3-2*x^2*y^2-x^3*y,0,-x*y^3,-2*x*y^4-2*x^2*y^3,0],[0,x,0,0,0,0,0,
x^2*y+x^3,0,0,0,0,0,0,0,0,0,0,-x*y^3-x^2*y^2-x^3*y,-x*y^3,0,
-x*y^3+x^2*y^2+3*x^3*y,x*y^4+2*x^2*y^3+x^3*y^2,0],[0,0,0,0,0,x*y,
-x^2*y^2-x^3*y,y^3,0,0,0,0,x*y^2+2*x^2*y+x^3,0,0,0,0,0,-x*y^3-x^2*y^2,
-x*y^3-3*x^2*y^2-3*x^3*y-x^4,0,-x^3*y,-x*y^4-2*x^2*y^3-x^3*y^2,0],[-1,0,0,x+y,
0,0,-x*y^2,x*y+y^2,0,0,0,0,x*y+y^2,0,0,0,0,0,0,-x*y^2-x^2*y,0,-x*y^2,
-2*x*y^3-2*x^2*y^2,0],[0,0,0,0,x,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,-x*y,
-x*y^2+y^3,0],[0,0,-1,0,0,x+y,0,y^2,0,0,0,0,x*y+x^2,0,0,0,0,0,-x*y^2-x^2*y,
-x*y^2-2*x^2*y-x^3,0,-x^3,-x*y^3-2*x^2*y^2-x^3*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,-x-y,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,-x*y,0,0,0,0,0,x+y,0,0,x*y,0,0,0,-2*x*y-x^2-y^2,0,y^2,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x^2,0,0,0,y,y^2,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,x,0,0,0,0,0,y^2,0],[0,0,0,0,0,0,0,y^2,0,0,0,x,0,0,0,0,0,0,-x*y^2-x^2*y,
0,0,-x^3,0,0],[0,0,0,0,0,0,-x*y,0,0,0,0,0,x+y,0,0,0,0,0,0,-x*y-x^2,0,0,0,0],
[0,0,0,0,0,0,0,y,0,0,0,0,0,x,0,0,0,0,0,x*y+y^2,0,0,-x*y^2-2*x^2*y-x^3,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,-x*y^2,y^3,0,0,0,0],[0,0,0,0,0,0,0,0,-1,0,0,0,
1,0,0,x+y,0,0,0,-x-y,0,y,0,0],[0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,x+y,0,0,0,0,0,
y^2,0],[0,0,0,0,0,0,0,0,0,y/x,0,0,0,0,0,0,0,x+y,0,0,0,-y/x,-y^2/x,0],[0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,y,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,x+y]],[[x,0,0,0,0,0,0,
-x*y^2-3*x^2*y+2*y^3,0,0,0,0,0,0,0,0,-x*y^3-2*x^2*y^2-x^3*y,
x*y^4+x^2*y^3-x^3*y^2-x^4*y,0,0,0,-x*y^3-x^2*y^2-x^3*y,
x^2*y^3+2*x^3*y^2+x^4*y,-x*y^3-x^2*y^2],[0,0,x,0,0,0,0,-3*x*y^2-2*x^2*y,
-x^2*y-x^3,x^3*y+x^4,0,0,0,0,0,0,0,-x*y^4-x^2*y^3,0,0,0,0,
x*y^4+3*x^2*y^3+3*x^3*y^2+x^4*y,0],[0,-y,x+y,0,0,0,0,-x*y^2,-x*y^2-x^2*y,
x^2*y^2+x^3*y,0,0,0,0,0,0,-x*y^3-3*x^2*y^2-3*x^3*y-x^4,
x*y^4+2*x^2*y^3-2*x^4*y-x^5,0,0,0,-x^2*y^2-2*x^3*y-x^4,
2*x*y^4+4*x^2*y^3+4*x^3*y^2+3*x^4*y+x^5,0],[0,0,0,0,0,0,0,x*y+2*y^2,0,0,0,0,
x*y,0,0,0,-x*y^2-x^2*y,x*y^3-x^3*y,0,0,0,0,-x^2*y^2-x^3*y,-x*y^2],[0,0,0,0,0,
0,0,y,0,0,x*y,0,0,0,0,0,y^2,-y^3,0,0,0,x*y+y^2,-x^2*y,0],[0,0,0,0,0,0,
x^2*y+x^3,x*y+x^2+y^2,0,0,0,0,0,0,x,0,-x*y^2-2*x^2*y-x^3,-x^2*y^2-2*x^3*y-x^4,
0,0,0,0,(x*y^4+2*x^2*y^3+2*x^3*y^2+2*x^4*y+x^5)/y,0],[0,0,0,0,0,0,x+y,1,0,0,0,
0,0,0,0,-y,-x-y,-x*y-x^2,0,0,0,0,2*x*y+x^2+y^2,0],[0,0,0,0,0,0,0,y,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,x+2*y,x,0,0,0,0,0,0,0,-2*x*y-x^2-y^2,
-x*y^2-2*x^2*y-x^3,0,0,0,0,3*x*y^2+3*x^2*y+x^3+y^3,0],[0,0,0,0,0,0,0,1,0,x,0,
0,0,0,0,0,0,-x*y-y^2,0,0,0,x+y,x*y+y^2,0],[0,0,0,0,-1,0,0,1,0,0,x+y,0,0,0,0,0,
y,-x*y-y^2,0,0,0,x+y,0,0],[0,0,0,0,0,0,0,y^2,0,0,0,0,0,0,0,0,0,0,-x^2*y,0,0,
x*y^2+x^2*y,0,0],[0,0,0,-1,0,0,0,x+2*y,0,0,0,0,x+y,0,0,0,-x*y-x^2,
-x*y^2-2*x^2*y-x^3,0,0,0,0,x^2*y+x^3,-x*y],[0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,
0,0,x*y,0,0,-x^2*y-x^3,0],[0,0,0,0,0,-y,0,y^2,0,0,0,0,0,0,x+y,x*y^2+x^2*y,0,
-x*y^3-x^2*y^2+x^3*y+x^4,0,0,0,0,0,0],[0,0,0,0,0,0,x,1,0,0,0,0,0,0,0,0,-x-y,
-x*y-x^2,0,0,0,0,2*x*y+x^2+y^2,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,-y^2,0,0,
0,0,x*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0],[0,0,0,0,0,0,0,
-y/x,0,0,0,1/x,0,0,0,0,0,0,x+y,0,0,-x-y,0,0],[0,0,0,0,0,0,0,1,0,0,0,0,0,-1,0,
0,0,-x*y-x^2,0,x+y,0,0,0,0],[0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,x,y,0,
x+y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,-y,0,0,0,0,x+y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
y]],[[0,x,0,x*y+x^2,-x^2*y-x^3,0,0,0,0,0,0,0,0,0,0,0,0,2*x^2*y^3+2*x^3*y^2,
-x*y^3-x^2*y^2-x^3*y,0,x*y^3-2*x^2*y^2-3*x^3*y,-2*x*y^3+x^2*y^2+3*x^3*y,0,
-3*x*y^3-x^2*y^2+6*x^3*y+4*x^4],[-y,x+y,0,x*y+y^2,-x*y^2-x^2*y,0,0,0,0,0,0,0,
0,0,0,0,0,-x^2*y^3-2*x^3*y^2-x^4*y,0,0,-2*x^2*y^2-2*x^3*y,3*x^2*y^2+2*x^3*y,0,
x*y^3+3*x^2*y^2+3*x^3*y+2*x^4],[0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x^2*y^3+2*x^3*y^2+x^4*y,-x^2*y^2-2*x^3*y-x^4,0,-2*x^2*y^2-2*x^3*y-x^4,x^2*y^2,
0,-x*y^3+2*x^3*y],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,2*x^2*y^2+2*x^3*y,0,0,
2*x*y^2+x^2*y,-2*x*y^2-x^2*y,0,-4*x*y^2-3*x^2*y],[0,0,0,0,x,0,0,0,0,0,0,0,0,0,
0,0,0,-x*y^2+x^2*y,x*y+y^2,0,2*x*y+y^2,-x*y,0,-3*x*y-2*x^2],[0,0,0,0,0,0,0,0,
0,0,0,0,0,x*y,0,x*y^2+2*x^2*y+x^3,0,x^2*y^2+2*x^3*y+x^4,0,-x*y^2-x^2*y,
x*y^2+x^2*y+x^3,-x*y^2-x^2*y-x^3,0,-x*y^2-x^2*y],[0,0,0,0,0,0,x+y,0,0,0,0,0,0,
0,1/x,0,0,0,0,(-x*y-y^2)/x,x,-x,0,-x],[0,0,0,0,0,0,0,x+y,0,0,0,-1,0,0,0,0,0,0,
0,0,x*y,x^2,0,-x*y-x^2],[0,0,0,0,0,0,0,0,x+y,0,0,0,-y,0,0,0,0,0,0,0,2*x*y+x^2,
-2*x*y-x^2,0,-2*x*y-x^2],[0,0,0,0,0,0,0,0,0,x+y,-y,0,0,0,0,0,0,-x*y,x+y,0,
2*x+y,-x,0,-x],[0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,-x*y,x+y,0,2*x+y,-x,0,-x],
[0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0,0,x*y^2+x^2*y,0,x*y^2,2*x^2*y+x^3,0,
-x*y^2+x^3],[0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,2*x*y+x^2,-2*x*y-x^2,0,
-2*x*y-x^2],[0,0,0,0,0,-1,0,0,0,0,0,0,0,x+y,0,x*y+x^2,0,
(x^2*y^2+2*x^3*y+x^4)/y,0,0,x*y,-x*y,0,-x*y-x^2],[0,0,0,0,0,0,-x^2*y,0,0,0,0,
0,0,0,0,x*y^2+x^2*y,0,0,0,0,x*y^2,-x*y^2,0,x^2*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,x+y,0,0,0,-y,x,-x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x*y,0,0,0,0,
x*y,y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,-x,0,-x],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,x,-x,
0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,y,x,0,x],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,y,0,0,x+y,0,x],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-x,0,0,0,0,
x+y,1],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y]]];end;
f35:=function(x,y,I)return
[[[0,-1,0,0,0,0,0,0,0,x^2*y^3+2*x^3*y^2,0,-x*y-y^2,x+y,0,0,0,0,0,x*y^3+
2*x^2*y^2+(I+1)*x^3*y,0,0,0,0,-2*I*x^3*y^3-2*x^4*y^2],[x*y,x+y,0,0,0,0,
0,0,0,-x^2*y^4-3*x^3*y^3-2*x^4*y^2-I*x^5*y,0,x*y^2+x^2*y,-x*y-x^2,0,0,0,0,
0,-2*x^2*y^3-4*x^3*y^2+(-I-1)*x^4*y-I*x^5,0,0,0,0,
-2*I*x*y^6-2*I*x^2*y^5+4*I*x^3*y^4+2*I*x^4*y^3+2*x^6*y],[0,0,0,0,
0,0,0,0,0,x*y^4+x^2*y^3+(I-1)*x^3*y^2+I*x^4*y,x*y+y^2,0,0,0,0,0,0,0,
I*x^4,0,x*y,0,0,2*x^3*y^3-2*I*x^4*y^2-2*x^5*y],[0,0,0,0,0,x*y,0,0,0,
x*y^3+2*x^2*y^2+x^3*y,0,0,0,0,0,0,0,0,3*x*y^2+3*x^2*y+(I+1)*x^3+y^3,0,0,0,
0,2*x^2*y^3-2*I*x^3*y^2-2*x^4*y],[0,0,0,0,0,0,0,x*y,0,x*y^3+(-I+
2)*x^2*y^2+x^3*y,0,0,0,0,0,0,0,0,3*x*y^2+3*x^2*y+x^3+y^3,0,0,0,0,0],[0,0,0,-1,
0,x+y,0,0,0,-I*x^3,0,0,0,0,0,0,0,0,2*x*y+x^2+y^2,0,0,0,0,
2*x*y^3-2*I*x^2*y^2-2*x^3*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,1/2,0,0,
0,0,-x*y+(-I-1)*y^2],[0,0,0,0,-1,0,0,x+y,0,-I*x*y^2-I*x^2*y,0,0,0,0,
0,0,0,0,(-I+2)*x*y+x^2+y^2,0,0,0,0,0],[0,0,0,0,0,0,0,0,x,(I/2)*x,0,0,0,
0,0,0,0,0,I/2,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,x*y^3+x^2*y^2+I*x^3*y,y,0,0,0,0,0,0,0,x*y^2+x^2*y+
I*x^3,0,0,0,0,-2*I*x^3*y^2-2*x^4*y],[0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,
0,0,0,0,0,0,2*I*x^2*y^3+(-2*I-2)*x^3*y^2-2*I*y^5],[0,0,0,0,0,0,0,0,0,
-x^2*y^3-x^3*y^2-I*x^4*y,0,0,y,0,0,0,0,0,-x^2*y^2-x^3*y-I*x^4,0,0,0,0,
-2*I*x*y^5+2*I*x^2*y^4-2*x^3*y^3-2*x^4*y^2+2*x^5*y-2*I*y^6],[0,0,0,0,
0,0,x,0,0,(1/2)*x,0,0,0,x+y,0,0,0,0,0,0,0,0,0,x*y+(I+1)*y^2],[0,0,0,0,0,0,
0,0,0,(-I/2)*x^2,0,0,0,0,x+y,0,0,-1/2,0,0,0,0,0,-x^2*y],[0,0,0,0,0,0,0,0,0,
x*y^2+x^2*y,0,0,0,0,0,0,-x*y,0,2*x*y+(I+1)*x^2+y^2,0,0,0,0,
-2*I*x^2*y^2-2*x^3*y],[0,0,0,0,0,0,0,0,0,I*x^2,0,0,0,0,0,1,x+y,0,-x-y,0,
0,0,0,2*I*x*y^2+2*x^2*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,2*x*y,0,0,0,I*x^2,
0,0,0,0,-2*x^3*y],[0,0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(I/2)*x,0,0,0,-x*y^2,-x^2*y],[0,0,-1,0,0,0,
0,0,0,-x^2*y^2+(I-1)*x^3*y,x+y,0,0,0,0,0,0,0,-x*y^2-2*x^2*y,0,x+y,0,0,
(2*I+2)*x^2*y^3+2*x^3*y^2],[0,0,0,0,0,0,0,0,0,I*x,0,0,0,0,0,0,0,0,I,
0,0,x,0,0],[0,0,0,0,0,0,0,0,0,((I/2)*x)/y,0,0,0,0,0,0,0,0,0,1/y,0,0,x+y,x],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x]],[[x+y,0,0,0,0,0,0,0,0,0,0,
-x*y-y^2,y,0,0,0,0,0,0,0,0,x^4*y,-2*I*x^3*y^3-2*x^4*y^2,0],[-x*y-x^2,y,0,0,
0,0,0,0,0,0,0,2*x*y^2+x^2*y+y^3,-x*y-y^2,0,0,0,0,0,0,0,0,
I*x^4*y^2-x^5*y-x^6,-2*I*x*y^6-2*I*x^2*y^5+4*I*x^3*y^4+
2*I*x^4*y^3+2*x^6*y,0],[0,0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-x^2*y^2-x^3*y,0,0,x^5,2*x^3*y^3-2*I*x^4*y^2-2*x^5*y,0],[0,0,-1,x+y,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,-x*y^2-x^2*y,0,0,x^4,2*x^2*y^3-2*I*x^3*y^2-2*x^4*y,
0],[0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,2*x*y^2,0,0,-x*y-y^2,0,0,0,0,0,2*x*y^3-2*I*x^2*y^2-2*x^3*y,0],[0,0,0,0,0,
0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,(1/2)/(x*y),(-I/2)*x,-x*y+(-I-1)*y^2,0],
[0,0,0,0,0,0,0,0,-2*x*y^2,0,0,0,0,0,0,0,0,0,0,0,0,-x^2*y,0,0],[0,0,0,0,0,0,0,
(1/2)/y,x+y,0,0,0,0,0,0,0,0,0,0,0,0,(1/2)*x,0,0],[0,0,0,0,0,0,0,0,0,y,0,0,0,0,
0,0,0,0,0,0,0,I*x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,x^4,
-2*I*x^3*y^2-2*x^4*y,0],[0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,
2*I*x^2*y^3+(-2*I-2)*x^3*y^2-2*I*y^5,0],[-x,0,0,0,0,0,0,0,0,0,0,x*y+
y^2,0,0,0,0,0,0,0,0,0,-x^5,-2*I*x*y^5+2*I*x^2*y^4-2*x^3*y^3-2*x^4*y^2+
2*x^5*y-2*I*y^6,0],[0,0,0,0,0,(-1/2)/y,0,0,0,0,0,0,0,x+y,0,0,((-1/2)*x+
(-1/2)*y)/y,0,0,0,0,0,x*y+(I+1)*y^2,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,-x^2*y,-x*y^2],[0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,x+y,0,0,0,0,0,x^3,
-2*I*x^2*y^2-2*x^3*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,
2*I*x*y^2+2*x^2*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2*x*y,0,x^3,
-2*x^3*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,-1/2,0,x+y,0,(1/2)*x^2,-x^2*y,0],[0,0,0,0,0,0,-2*x^2*y^2,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,I*x^3*y,(2*I+2)*x^2*y^3+2*x^3*y^2,0],[0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,x,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1/y,0,0,0,0,0,0,0,x,x+y]],[[0,0,
-y,0,0,0,0,0,0,0,x*y+y^2,0,0,2*x^2*y^3+4*x^3*y^2,0,0,0,0,0,0,0,0,0,(2*I+
2)*x^2*y^4+(2*I+4)*x^3*y^3+2*x^4*y^2],[0,0,0,0,0,0,0,0,0,0,-x*y^2-x^2*y,
x^2*y+x^3,0,-2*x^2*y^4-6*x^3*y^3-4*x^4*y^2-2*I*x^5*y,0,0,0,0,0,0,x*y^2,0,0,
(-2*I-2)*x^2*y^5+(-4*I-6)*x^3*y^4+(-2*I-6)*x^4*y^3+(-2*I+
2)*x^6*y],[x,0,x+y,0,0,0,0,0,0,0,0,-2*x*y-x^2-y^2,x+y,2*x*y^4+2*x^2*y^3+
(2*I-2)*x^3*y^2+2*I*x^4*y,0,0,0,0,0,0,0,0,0,(2*I+2)*x*y^5+(2*I+
4)*x^2*y^4+(2*I-4)*x^4*y^2+(2*I-2)*x^5*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,
2*x*y^3+4*x^2*y^2+2*x^3*y,0,0,0,x*y,2*x*y^2+x^2*y+y^3,0,0,0,0,(2*I+
2)*x*y^4+(4*I+6)*x^2*y^3+(2*I+4)*x^3*y^2],[0,0,0,0,y,0,0,0,0,0,0,0,0,
2*x*y^3+(-2*I+4)*x^2*y^2+2*x^3*y,0,0,0,0,0,0,0,0,0,(2*I+2)*x*y^4+
(2*I+8)*x^2*y^3+6*x^3*y^2+2*x^4*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,-2*I*x^3,
2*x*y,0,0,0,0,0,0,0,0,-2*x^2*y^2-2*x^3*y-2*I*x^4],[0,0,0,0,0,0,0,0,0,
(-1/2)*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,0,0,
-2*I*x*y^2-2*I*x^2*y,0,0,0,0,0,0,0,0,0,(-2*I+2)*x*y^3+(-4*I+
2)*x^2*y^2-2*I*x^3*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,I*x,0,0,0,0,0,0,0,
(1/2)*y,0,(I-1)*x*y+I*x^2],[0,0,0,0,0,0,2*x,0,0,x+y,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x+y,-x-y,1,2*x*y^3+2*x^2*y^2+2*I*x^3*y,0,0,0,
0,0,0,0,0,0,(2*I+2)*x*y^4+(2*I+4)*x^2*y^3+(2*I-2)*x^4*y],[0,0,0,0,0,
0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,-x*y,x*y+x^2,0,
-2*x^2*y^3-2*x^3*y^2-2*I*x^4*y,0,0,0,0,0,0,0,0,0,(-2*I-2)*x^2*y^4+
(-2*I-4)*x^3*y^3+(-2*I+2)*x^5*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,0,-1/2,0,0,0,0,0,0,0,-I*x^2,x+y,0,0,0,0,0,0,0,0,
-x*y^2-x^2*y-I*x^3],[0,0,0,0,0,0,0,0,0,0,0,0,0,2*x*y^2+2*x^2*y,0,0,0,0,x*y+
y^2,2*x*y,0,0,0,(2*I+2)*x*y^3+(2*I+4)*x^2*y^2],[0,0,0,0,0,0,0,0,0,0,0,0,
0,2*I*x^2,0,0,0,0,0,0,0,0,2*x*y^2,2*I*x^3],[0,0,0,-1,0,0,0,0,0,0,0,0,0,
0,0,0,0,x+y,2*x*y+x^2+y^2,0,0,0,0,-2*x^2*y^2-2*x^3*y],[0,0,0,0,0,0,0,0,0,0,0,
0,0,2*x*y,0,0,0,0,y,0,0,0,0,(2*I+2)*x*y^2+2*x^2*y],[0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,-1/2,0,0,(1/2)*x+(1/2)*y,x+y,0,0,0,-x^2*y],[0,-1/y,0,0,0,0,0,0,0,0,0,
-x-y,(x+y)/y,-2*x^2*y^2+(2*I-2)*x^3*y,0,0,0,0,0,0,x+y,0,0,-2*x^3*y^2+
(2*I-2)*x^4*y],[0,0,0,0,0,0,0,0,-2*x,0,0,0,0,2*I*x,0,0,0,0,0,0,0,x+y,0,
(2*I-2)*x*y+2*I*x^2],[0,0,0,0,0,0,0,0,0,0,0,0,0,I*x/y,0,0,(-1/2)/y,0,
0,0,0,0,x+y,I*x^2/y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x]],
[[y,0,0,0,0,0,2*x^3*y^2+2*x^4*y,0,(I+1)*x*y^4+(2*I+2)*x^2*y^3+(I+
1)*x^3*y^2+2*I*x^4*y,I*x*y^4+2*I*x^2*y^3+(2*I+1)*x^3*y^2,0,0,0,
(4*I+2)*x^2*y^3+(6*I+4)*x^3*y^2+2*I*x^4*y,(I+1)*x*y^3+
4*I*x^2*y^2+(3*I-1)*x^3*y,0,-x*y^3-2*x^2*y^2+(-I-1)*x^3*y,
(-I-1)*x*y^2+((-I-1)/2)*x^2*y+((-I-1)/2)*y^3,0,(3*I+3)*x*y^3+
(3*I+3)*x^2*y^2+(I+1)*x^3*y+(I+1)*y^4,0,0,(I+1)*x*y^5+(5*I+
1)*x^2*y^4+(7*I-1)*x^3*y^3+(3*I-1)*x^4*y^2,(I+1)*x*y^5+(7*I+
1)*x^2*y^4+(13*I+1)*x^3*y^3+(11*I+1)*x^4*y^2+2*I*x^5*y],[0,y,0,0,0,0,
(-I+1)*x*y^5+2*x^2*y^4+(3*I-1)*x^3*y^3+(I-3)*x^4*y^2+(-I-3)*x^5*y+
(I-1)*x^6,0,(-I-1)*x^2*y^4+(-3*I-3)*x^3*y^3+
(-3*I-3)*x^4*y^2-2*I*x^5*y+(-I+1)*x^6,x*y^5+(-I+1)*x^2*y^4+
(-2*I-2)*x^3*y^3+(-2*I-1)*x^4*y^2-2*I*x^5*y,0,0,0,(I+1)*x*y^5+
(-I+1)*x^2*y^4+(-8*I-4)*x^3*y^3+(-8*I-6)*x^4*y^2-2*I*x^5*y+(-I+
1)*x^6,(-I-1)*x*y^4-4*I*x^2*y^3+(-5*I+3)*x^3*y^2+(-3*I+
1)*x^4*y-2*x^5,0,2*x^2*y^3+4*x^3*y^2+(I+1)*x^4*y+I*x^5,(((3*I+
1)/2)*x*y^4+(I+2)*x^2*y^3+((I+1)/2)*x^4*y+x^5+((I-1)/2)*y^5)/y,0,
(-4*I*x*y^5+(-5*I-5)*x^2*y^4+(-2*I-4)*x^3*y^3+(-I-1)*x^4*y^2+
(-I-3)*x^5*y-2*x^6+(-I+1)*y^6)/y,0,0,(-I-1)*x*y^6+
(-5*I-1)*x^2*y^5+(-9*I+3)*x^3*y^4+(-8*I+4)*x^4*y^3+
(-3*I-1)*x^5*y^2-2*x^6*y,(-3*I+1)*x^2*y^5+(-12*I+2)*x^3*y^4+
(-20*I-2)*x^4*y^3+(-13*I-5)*x^5*y^2+(-3*I+1)*x^6*y+(-I+1)*x^7],[0,
0,0,x*y+x^2,-x*y,0,(-I-1)*x*y^4+(-3*I-3)*x^2*y^3+(-I-1)*x^3*y^2+
(-I+1)*x^4*y+(-I+1)*x^5,0,(-I-1)*x*y^4+(-I-1)*x^2*y^3+(I+
1)*x^3*y^2+(I-1)*x^5,-I*x*y^4-2*I*x^2*y^3+I*x^3*y^2+(2*I+
1)*x^4*y,x*y+x^2,0,0,(I-1)*x*y^4-2*x^2*y^3+(-I-1)*x^3*y^2+(I-1)*x^5,
2*I*x*y^3+(3*I+1)*x^2*y^2+2*x^3*y,-x^2*y-x^3,-I*x^4,-x*y^2+
(-I-2)*x^2*y+((-I-3)/2)*x^3,0,(2*I+4)*x^2*y^2+(3*I+7)*x^3*y+(I+
3)*x^4,0,0,2*I*x*y^5+(5*I+1)*x^2*y^4+(3*I+3)*x^3*y^3+2*x^4*y^2,
(I-3)*x*y^5+(4*I-4)*x^2*y^4+(4*I+4)*x^3*y^3+(-I+5)*x^4*y^2+
(I-1)*x^5*y+(I-1)*x^6],[0,0,0,x,0,0,(-I-1)*x*y^3+(I+3)*x^3*y+
2*x^4,0,(I+1)*x*y^3+(2*I+2)*x^2*y^2+(2*I+2)*x^3*y+2*I*x^4,
2*I*x^2*y^2+(2*I+1)*x^3*y,0,0,0,(3*I+1)*x*y^3+(8*I+4)*x^2*y^2+
(6*I+4)*x^3*y+2*I*x^4,2*I*x*y^2+4*I*x^2*y+2*I*x^3,-x*y-x^2,
-3*x*y^2-3*x^2*y+(-I-1)*x^3-y^3,(-I-1)*x*y+((-I-3)/2)*x^2,x*y^2+
x^2*y,(2*I+2)*x*y^2+(3*I+5)*x^2*y+(I+3)*x^3,0,0,2*I*x*y^4+
6*I*x^2*y^3+6*I*x^3*y^2+2*I*x^4*y,(3*I-1)*x*y^4+
(13*I-1)*x^2*y^3+(18*I+2)*x^3*y^2+(10*I+2)*x^4*y+2*I*x^5],[0,0,1,
-x-y,x+y,0,(I+1)*x*y^3+(I+1)*x^2*y^2+(2*I+2)*x^3*y+(I+1)*x^4,0,
(I+1)*x*y^3+(I+1)*x^2*y^2+(2*I+2)*x^3*y+(I+1)*x^4,0,-x-y,0,0,
(4*I+2)*x*y^3+(8*I+6)*x^2*y^2+(5*I+3)*x^3*y+(I+1)*x^4,
(I-1)*x*y^2+(3*I-1)*x^2*y+(I-1)*x^3,0,-3*x*y^2-3*x^2*y-x^3-y^3,2*x*y+
x^2+y^2,x*y^2+x^2*y,-4*x*y^2-4*x^2*y-2*x^3-2*y^3,0,0,(I-1)*x*y^4+
(4*I-2)*x^2*y^3+(4*I-2)*x^3*y^2+(I-1)*x^4*y,(3*I-1)*x*y^4+
(12*I-2)*x^2*y^3+(15*I+1)*x^3*y^2+(7*I+1)*x^4*y+(I+1)*x^5],[0,0,0,
0,0,x,(I+1)*x*y^2+2*x^2*y,0,(I+1)*x*y^2+(I+1)*x^2*y,2*I*x*y^2+
(2*I+1)*x^2*y,0,0,0,(3*I+3)*x*y^2+(2*I+2)*x^2*y+(I+1)*x^3+(I+
1)*y^3,((2*I+2)*x*y^2+(I+1)*x^2*y+(I+1)*x^3+(I+1)*y^3)/y,0,
-x*y-y^2,((-I-3)/2)*x+(-I-1)*y,0,(3*I+5)*x*y+(I+3)*x^2+(2*I+
2)*y^2,0,0,(3*I+3)*x*y^3+(3*I+3)*x^2*y^2+(2*I+2)*x^3*y+(I+1)*x^4+
(I+1)*y^4,(7*I+3)*x*y^3+(8*I+6)*x^2*y^2+(5*I+3)*x^3*y+(2*I+
2)*x^4+2*I*y^4],[0,0,0,0,0,0,((-I+1)/2)*x+((-I+1)/2)*y,0,((I+
1)/2)*x,(1/2)*y,0,0,0,((I+1)/2)*x,0,0,-1/2,((I-1)/4)/x,0,(((-I+
1)/2)*x+((-I+1)/2)*y)/x,0,0,0,((I+1)/2)*x*y+((I+1)/2)*x^2],[0,0,0,0,
0,-x-y,(I+1)*x*y^2+(I+1)*x^2*y,x+y,(I+1)*x*y^2+(-I+1)*x^2*y,0,0,0,
0,(2*I+4)*x*y^2+4*x^2*y,(I+5)*x*y+(I+3)*x^2+2*y^2,0,
(I-2)*x*y-x^2-y^2,0,0,0,1,0,(I+5)*x*y^3+(2*I+6)*x^2*y^2+(I+
3)*x^3*y+2*y^4,(3*I+3)*x*y^3+(4*I+8)*x^2*y^2+(I+5)*x^3*y],[0,0,0,0,0,
0,((-I+1)/2)*x,0,((I+1)/2)*x,0,0,0,0,-x,(((-I-1)/2)*x)/y,0,-I/2,0,
0,0,0,0,((-I-1)/2)*x*y+((-I-1)/2)*x^2,((-I-1)/2)*x*y+
((-I-3)/2)*x^2],[0,0,0,0,0,0,2*I*x,0,(-I-1)*x,0,0,0,0,(-I-1)*x,0,
0,1,((-I+1)/2)/y,0,((I-1)*x+(I-1)*y)/y,0,0,0,(-I-1)*x*y+
(-I-1)*x^2],[0,0,0,0,0,0,2*x^3*y+(-I+1)*x^4,0,(I+1)*x^2*y^2+(I+
1)*x^3*y+(I-1)*x^4,I*x^2*y^2+(2*I+1)*x^3*y,x,0,0,2*I*x*y^3+
(4*I+2)*x^2*y^2+(I+1)*x^3*y+(I-1)*x^4,2*I*x*y^2+(3*I+1)*x^2*y,
0,-x*y^2-x^2*y-I*x^3,((-I-1)/2)*x*y+((-I-3)/2)*x^2,0,(I+1)*x*y^2+
(2*I+4)*x^2*y+(I+3)*x^3,0,0,2*I*x*y^4+(5*I+1)*x^2*y^3+(3*I+
1)*x^3*y^2,(2*I-2)*x*y^4+(9*I-1)*x^2*y^3+(8*I+4)*x^3*y^2+
2*I*x^4*y+(I-1)*x^5],[0,0,0,0,0,0,(I-1)*x^2*y^2-2*I*x^3*y+(-I+
1)*y^4,0,0,(I-1)*x^2*y^2+x^3*y+y^4,0,x+y,-1,0,(2*I+2)*x*y^2+(2*I+
2)*x^2*y-2*x^3,0,0,(((-3*I-1)/2)*x^2*y^2-x^3*y+x^4+((I-1)/2)*y^4)/(x*y),
0,((-I+1)*x*y^4+(3*I+1)*x^2*y^3+(3*I+3)*x^3*y^2-2*x^5+(-I+
1)*y^5)/(x*y),0,0,(2*I+2)*x*y^4+(4*I+4)*x^2*y^3+2*I*x^3*y^2-2*x^4*y,
2*I*x*y^4+(4*I+2)*x^2*y^3+(2*I+2)*x^3*y^2],[0,0,0,0,0,0,(-I+
1)*x*y^4+2*I*x^2*y^3+(-2*I-2)*x^4*y+(I-1)*x^5+(-I+1)*y^5,0,
(-I-1)*x^3*y^2+(-I-1)*x^4*y+(-I+1)*x^5,x*y^4+
(I-1)*x^2*y^3-2*I*x^4*y+y^5,0,x*y,0,(I+1)*x*y^4+(-I+1)*x^2*y^3+
(-4*I-2)*x^3*y^2+(-I-1)*x^4*y+(-I+1)*x^5,(I+1)*x*y^3+(I+
3)*x^2*y^2+(-I+1)*x^3*y-2*x^4,0,x^2*y^2+x^3*y+I*x^4,
(((I-1)/2)*x*y^4-I*x^2*y^3+((-I-1)/2)*x^3*y^2+((I+1)/2)*x^4*y+x^5+
((I-1)/2)*y^5)/(x*y),0,((-2*I+2)*x*y^5+(I+1)*x^2*y^4+(3*I+
1)*x^3*y^3+(-I-3)*x^5*y-2*x^6+(-I+1)*y^6)/(x*y),0,0,(I+1)*x*y^5+
(2*I+4)*x^2*y^4+4*x^3*y^3+(-I-1)*x^4*y^2-2*x^5*y,2*I*x*y^5+(4*I+
4)*x^2*y^4+(-3*I+5)*x^3*y^3+(-6*I-2)*x^4*y^2-2*I*x^5*y+(-I+
1)*x^6],[0,0,0,0,0,0,((I+1)/2)*x+I*y,0,0,(I/2)*x+((I-1)/2)*y,0,0,
0,(I+1)*x+((I+1)/2)*y,(I*x+((I+1)/2)*y)/y,0,0,(((-I-1)/4)*x+
(-I/2)*y)/(x*y),0,(((3*I+1)/2)*x*y+((I+1)/2)*x^2+I*y^2)/(x*y),0,0,
((3*I+1)/2)*x*y+I*x^2+((I+1)/2)*y^2,2*I*x*y+2*I*x^2+I*y^2],
[0,0,0,0,0,0,(I+1)*x*y+((I+1)/2)*y^2,0,((I+1)/2)*x*y+((I+
1)/2)*y^2,I*x*y+(I/2)*y^2,0,0,0,(I+1)*x*y+((I+1)/2)*x^2+(I+
1)*y^2,(((I+1)/2)*x*y+((I-1)/2)*x^2+((I+1)/2)*y^2)/y,0,0,(-I-1)/4,
0,((I+1)/2)*x+((I+1)/2)*y,0,0,I*x*y^2+I*x^2*y+((I-1)/2)*x^3+
((I-1)/2)*y^3,(3*I+1)*x*y^2+((5*I-1)/2)*x^2*y+I*x^3+((3*I+
1)/2)*y^3],[0,0,0,0,0,0,2*x^2*y+2*x^3,0,(I+1)*x*y^2+(I+1)*x^2*y+
2*I*x^3,I*x*y^2+(2*I+1)*x^2*y,0,0,0,(3*I+1)*x*y^2+(5*I+
3)*x^2*y+2*I*x^3,2*I*x*y+2*I*x^2,0,-2*x*y+(-I-1)*x^2-y^2,
((-I-3)/2)*x+((-I-1)/2)*y,x*y,(2*I+4)*x*y+(I+3)*x^2+(I+1)*y^2,
0,0,2*I*x*y^3+4*I*x^2*y^2+2*I*x^3*y,(3*I-1)*x*y^3+10*I*x^2*y^2+
(9*I+1)*x^3*y+2*I*x^4],[0,0,0,0,0,0,(I-1)*x*y,0,(-I-1)*x*y,
(-I-1)*x*y,0,0,0,(-I-1)*x*y+(-I-1)*x^2,((-I-1)*x^2)/y,0,x+y,1,0,
-2*x-2*y,0,0,(-I-1)*x^2*y+(-I-1)*x^3,(-I-1)*x*y^2+(-3*I-1)*x^2*y+
(-2*I-2)*x^3],[0,0,0,0,0,0,(I+1)*x*y^2+(I+1)*x^2*y+(-I+1)*x^3+
(I+1)*y^3,0,(I+1)*x*y^2+(I-1)*x^3+(I+1)*y^3,2*I*x*y^2+
2*I*x^2*y+I*y^3,0,0,0,(2*I+2)*x*y^2+(I+1)*x^2*y+(I-1)*x^3+
(I+1)*y^3,(I+1)*x*y+(I+1)*x^2,0,-I*x^2,(((-I-1)/2)*x*y-x^2)/y,
0,((I+3)*x*y^2+(I+3)*x^2*y+2*x^3+2*y^3)/y,0,0,(I+1)*x*y^3+(2*I+
2)*x^2*y^2+(I+1)*x^3*y,(4*I+2)*x*y^3+(5*I+1)*x^2*y^2+
(3*I-1)*x^3*y+(I-1)*x^4+(I+1)*y^4],[0,0,0,0,0,0,(I+1)*x^2,0,(I+
1)*x^2,0,0,0,0,(3*I+1)*x*y+(I+1)*x^2,(I-1)*x,-1,-x-y,0,x+y,0,0,0,
(I-1)*x*y^2+(I-1)*x^2*y,(2*I-2)*x*y^2+(5*I-1)*x^2*y+(I+1)*x^3],
[0,0,0,0,0,0,((I+1)/2)*x*y+((-I+1)/2)*x^2+((I+1)/2)*y^2,0,
((I-1)/2)*x^2+((I+1)/2)*y^2,I*x*y+(I/2)*y^2,0,0,0,((I+
1)/2)*x*y+((I-1)/2)*x^2+((I+1)/2)*y^2,((I+1)/2)*x,0,(-I/2)*x,
((-1/2)*x+((-I-1)/4)*y)/y,0,(((I+3)/2)*x*y+x^2+((I+3)/2)*y^2)/y,0,0,
((I+1)/2)*x*y^2+((I+1)/2)*x^2*y,((3*I+1)/2)*x*y^2+
((3*I-1)/2)*x^2*y+((I-1)/2)*x^3+((I+1)/2)*y^3],[0,0,0,0,0,x*y+x^2,
(-I-1)*x*y^3+(-I-3)*x^2*y^2+(I-1)*x^3*y,-x*y,(-I-1)*x*y^3+
(-2*I-2)*x^2*y^2+(-I-1)*x^3*y,-I*x*y^3+(-I-1)*x^2*y^2,0,0,0,
(-I-1)*x*y^3+(-3*I-3)*x^2*y^2+(-3*I-3)*x^3*y,-2*x*y^2+
(-I-1)*x^2*y-2*I*x^3,0,x*y^2+3*x^2*y+x^3,((-I+1)/2)*x*y,0,
(I-1)*x*y^2+(I-1)*x^2*y,0,0,(-I-1)*x^2*y^3+
(-3*I-1)*x^3*y^2-2*I*x^4*y,(-I-1)*x*y^4+(-3*I-1)*x^2*y^3+(-7*I+
1)*x^3*y^2+(-5*I-1)*x^4*y],[0,0,0,0,0,0,(I-1)*x-2*y,0,(I-1)*x-2*y,
-x-y,0,0,0,(2*I-4)*x-2*y,((-I-1)*x)/y,0,-I,0,0,0,0,y,(-I-1)*x*y+
(-I-1)*x^2,(-I-5)*x*y+(-I-5)*x^2-2*y^2],[0,0,0,0,0,0,(-I-1)/2,0,
(-I-1)/2,-I/2,0,0,0,(((-I-1)/2)*x+((-I-1)/2)*y)/y,(((-I+
1)/2)*x)/y^2,0,0,0,0,0,0,0,(((-I+1)/2)*x*y+((-I+1)/2)*x^2+y^2)/y,
(((-3*I+1)/2)*x*y-I*x^2+((-I-1)/2)*y^2)/y],[0,0,0,0,0,0,(-I-1)/2,
0,0,-I/2,0,0,0,(-I-1)/2,((-I-1)/2)/y,0,0,((I+1)/4)/(x*y),0,
(((-I-1)/2)*x+((-I-1)/2)*y)/(x*y),0,0,((-I-1)/2)*x+((-I-1)/2)*y,-I*x-I*y]]];end;
f37:=function(x,y)return
[[[0,0,x*y,x*y+x^2,0,0,0,0,-x*y^2-x^2*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-x^2*y^3-2*x^3*y^2-x^4*y,0,0,0,0,0,-x^2*y^3-x^3*y^2+x^4*y+x^5],[0,0,0,0,0,0,0,
0,0,-x*y,0,0,0,0,x*y^2+x^2*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x^2*y^2+x^3*y],[-1,0,
x+y,x+y,0,0,0,0,-x*y-y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-2*x*y^3-x^2*y^2-y^4,0,0,
0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x^2*y^2-x^3*y,0,0,0,
0,0,x^3*y+x^4],[0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,-1,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,
x*y,0,0,0,0,0,0,0,0,0,0,0,2*x*y+x^2+y^2,0,0,0,0,0,-x*y-x^2],[0,0,0,0,0,0,0,0,
x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-2*x*y^2-x^2*y-y^3,0,0,0,0,0,x*y^2+2*x^2*y+x^3],
[0,1,0,0,0,0,0,0,0,x+y,0,0,0,0,-x*y-y^2,0,0,0,0,0,0,0,0,-x*y^2-y^3,0,0,0,0,0,
0],[0,0,0,0,0,0,-1,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,
0,0,0,-1,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,
-x*y-y^2,0,0,0,0,0,x*y+x^2],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,-1,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,-x*y^2-x^2*y,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,-x*y^2-x^2*y,0,0,0,0,0,
x*y^2+x^2*y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0],
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,x+y,-1-x^-1*y,0,0,0,0,0,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x^2*y,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,-x],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,-y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,x+y,0,
0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,x+y,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,x+y,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,-x^-1,0,0,0,0,0,0,x+y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0]],[[0,0,0,x*y,0,0,0,0,0,0,0,-x^3*y^2-x^4*y,0,
0,x^2*y^2+x^3*y+x^4,0,0,0,0,0,0,x^3*y+x^4,0,2*x^2*y^3+4*x^3*y^2+2*x^4*y,0,0,0,
0,-2*x^4*y^2-3*x^5*y-x^6,0],[0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x*y^3+2*x^2*y^2+2*x^3*y+x^4,0,0,2*x*y^3+x^2*y^2-x^3*y+y^4,0,0,-x^3*y^2-x^4*y,
-2*x*y^3-2*x^2*y^2-x^3*y-y^4,-x*y^4-4*x^2*y^3-5*x^3*y^2-2*x^4*y,0],[0,0,x,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-1,0,0,x+y,0,0,0,0,0,0,0,
-x^2*y^2-x^3*y,0,0,x^2*y+x^3,0,0,0,0,0,0,x^3,0,x*y^3+3*x^2*y^2+2*x^3*y,0,0,0,
0,-x^3*y^2-2*x^4*y-x^5,0],[0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,2*x*y^2+x^2*y+y^3,0,
0,0,0,0,-x^2*y^2-2*x^3*y-x^4,x*y^2+x^2*y,0,2*x*y^3+2*x^2*y^2+x^3*y+y^4,0,0,0,
x*y^3+2*x^2*y^2+x^3*y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-x*y^2-2*x^2*y-x^3,0,x*y,0,0,0,0,x*y^2+x^2*y,x*y^3+2*x^2*y^2+x^3*y,0],[0,0,0,
0,-1,0,x+y,0,0,0,0,0,0,0,x*y+y^2,0,0,0,0,0,-x*y^2-2*x^2*y-x^3,0,0,x*y^2+x^2*y,
0,0,0,2*x*y^2+x^2*y+y^3,x*y^3+2*x^2*y^2+x^3*y,0],[0,0,0,0,0,0,0,x+y,1,0,0,0,0,
0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,-x*y,0,0,0,0,0,0,x*y+x^2,0,
0,0,0,0,0,x^2,0,x*y^2+x^2*y,0,0,0,0,-x^3*y-x^4,0],[0,0,0,0,0,0,0,0,0,0,0,0,-y,
0,0,0,0,0,0,0,-2*x*y^2-2*x^2*y-x^3-y^3,0,0,0,0,0,x^2*y^2+x^3*y,
x*y^2+x^2*y+y^3,3*x*y^3+4*x^2*y^2+2*x^3*y+y^4,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,x*y,0,0,0,0,-2*x*y-x^2-y^2,0,0,0,0,0,0,x*y+y^2,3*x*y^2+2*x^2*y+y^3,0],[0,0,
0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,x,
0,0,x+y,0,0,0,0,0,0,0,x*y^2+x^2*y+x^3,0,0,0,0,0,-x^2*y^2-x^3*y,0,
-x*y^3-2*x^2*y^2-x^3*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0,
x^2*y+x^3,0,0,0,0,0,-x^2*y^2-x^3*y,0,-x^2*y^2-2*x^3*y-x^4,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,x+y,0,0,0,0,0,0,x,0,x*y+y^2,0,0,0,0,-x^2*y-x^3,0],[0,0,0,0,0,0,0,
0,0,0,-1,0,0,0,0,x+y,0,0,0,0,-x-y,0,0,0,0,0,0,0,x*y+y^2,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,-1,0,0,x+y,0,0,0,0,0,0,0,0,0,-x*y^2-x^2*y,x*y+x^2,0,0],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,y,0,0,x*y+x^2,0,0,y^2,0,0,0,-x*y-y^2,-x*y^2-2*x^2*y-x^3,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,-2*x^2*y-2*x^3,0,0,
-2*x*y^2-x^2*y-y^3,0,0,x*y^3+x^4+y^4,2*x*y^2+2*x^2*y,2*x^2*y^2+4*x^3*y+2*x^4,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,x^2,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,-y,-x*y-y^2,0],[0,0,0,0,0,0,0,0,
0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,-x*y-y^2,0,0,0,0,x^2*y+x^3,0],[0,0,0,0,0,-1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,-x*y-x^2,0,x+y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,-x,0,0,0,0,0,0,0,x*y+x^2,-y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,x+y,0,y,-x*y-y^2,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,-x*y-x^2,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0],[0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,x,0,x+y]],[[y,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,x^2*y^2+x^3*y+x^4,0,x^2*y^3+x^3*y^2-x^4*y-x^5,0,
-x^2*y^3-x^3*y^2+x^4*y+x^5,0,0,x^3*y^3+x^4*y^2-x^5*y-x^6,0],[0,0,0,0,-y,0,0,0,
0,0,0,0,0,0,x*y^2+y^3,0,0,0,0,0,0,0,0,x*y^3-x^2*y^2-x^3*y+y^4,0,x^2*y^2+x^3*y,
0,0,-x^2*y^3-2*x^3*y^2-x^4*y,0],[0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,x^2*y^3+2*x^3*y^2,0],[0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,
x^2*y+x^3,0,x*y^3+x^2*y^2-x^3*y-x^4,0,x^3*y+x^4,0,0,-x^4*y-x^5,0],[0,x,0,0,
x+y,0,0,0,0,0,0,0,0,0,-x*y^2-x^2*y,0,0,0,0,0,0,2*x*y^2+x^2*y+y^3,0,
-x*y^3-x^2*y^2,0,0,0,0,0,0],[0,0,0,0,0,x+y,0,0,0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,x*y^3+2*x^2*y^2+x^3*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x*y,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,-x,0,
x*y+x^2,0,-x*y-x^2,0,0,0,0],[0,0,0,-1,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,
x*y+x^2,0,-x^2*y-x^3,0,x*y^2+2*x^2*y+x^3,0,0,-x^3*y-x^4,0],[0,0,0,0,0,y,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y^3+2*x^2*y^2+x^3*y,0],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,-x*y,0,0,0,0,0,0,0,x*y^2+x^2*y,0],[0,0,0,0,0,0,0,0,
0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x^2,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,y,
0,0,0,0,0,-x*y^2-x^2*y,0,0,0,0,0,0,x*y^3+x^2*y^2,0,0,0],[0,0,0,0,0,0,0,0,0,0,
0,0,-x,x+y,0,0,0,0,0,-x*y^2-x^2*y,0,0,0,0,0,0,x*y^3+x^2*y^2,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,x+y,0,-x*y-x^2,0,x*y+x^2,0,0,-x^2*y-x^3,0],[0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y+x^2,-y,0,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y],[0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
0,0,0,0,-x*y^2-y^3,0,x*y^2+x^2*y,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,x,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,x+y,0,0,0,
0,0,0,0,-x*y-y^2,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,
0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y+x^2,0,0,0,0,x*y,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,0,-x,0,0,0,0],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,-1,0,x+y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,
-x*y-x^2,x+y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,x+y]],[[0,-x*y,
0,x*y+y^2,0,0,x^2*y+x^3,0,0,0,-x^2*y^2-2*x^3*y-x^4,-x^2*y^3-2*x^3*y^2-x^4*y,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x^2*y^3+2*x^3*y^2+x^4*y],[1,x+y,0,-x-y,0,0,
x*y+y^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,x*y,
-x*y^2-x^2*y,-2*x*y^3-x^2*y^2-y^4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x*y^3+x^2*y^2],[0,0,0,y,0,0,x*y+x^2,0,0,0,-x^2*y-x^3,-x^2*y^2-x^3*y,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,x^2*y^2+x^3*y],[0,0,0,0,y,0,x^2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,y,0,0,0,0,x^2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,2*x*y+x^2+y^2,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,-x*y-x^2],
[0,0,0,0,0,0,0,0,0,0,0,-2*x*y^2-x^2*y-y^3,0,0,x*y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
x*y^2+x^2*y],[0,0,-1,0,0,0,0,0,0,x+y,-x*y-y^2,-x*y^2-y^3,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-x],[0,0,0,0,
0,0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,x*y+y^2,0,-y,0,0,0,0,0,-x^2*y-x^3,-x*y^2-y^3,0,-x*y^2-x^2*y,0,
-x*y^2-x^2*y],[0,0,0,0,0,0,0,0,-1,0,0,-x*y-y^2,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0],[0,0,
0,0,0,0,0,0,0,0,-x,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-x-y,0,0,0,x*y+y^2,
-x*y^2-x^2*y,0,x,0,0,-x*y-x^2,0,x+y,0,0,0,0,0,x^2*y+x^3,x*y^2+x^2*y,0,
x*y^2+x^2*y,0,x*y^2+2*x^2*y+x^3],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,0,
0,-1,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0,
0,-x*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,x+y,0,0,0,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,
-1,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0,x+y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0],[0,0,0,0,0,0,y^-1,0,0,0,-1-x*y^-1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,y,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,
0,0,0,0,0,x+y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,x,
0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,
0,0,0,0,0,0,y,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]]];end;
  rep:=[[f1,x],[f1,y],[f3,x,y],[f3,y,x],
  [f5,x,y,E(4)],[f5,y,x,E(4)],[f5,x,y,-E(4)],[f5,y,x,-E(4)],
  [f9,x,y],[f9,y,x],[f11,x,y],[f12,x,y],[f12,y,x],
  [f14,x,y,E(4)],[f14,x,y,-E(4)],[f17,y,x],[f17,x,y],
  [f18,y,x],[f18,x,y],[f22,x,y],[f21,x,y],[f22,y,x],[f21,y,x],
  [f27,y,x,1],[f27,x,y,1],[f27,y,x,-1],[f27,x,y,-1],[f28,x,y],[f28,y,x],
  [f30,x,y,E(4)],[f30,y,x,E(4)],[f30,x,y,-E(4)],[f30,y,x,-E(4)],[f34,x,y],
  [f35,x,y,E(4)],[f35,x,y,-E(4)],[f37,x,y]];
  return ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]})+0*Product(para[1]);
end);

if not IsBound(CHEVIE.families) then ReadChv("unip/families");fi;

# a:=AbstractGenerator("a");
# b:=AbstractGenerator("b");
# f20a:=Group(a,b);
# f20a.relators:=[a^5, b^4, b*a*b^3*a^3];
# F20:= OperationCosetsFpGroup(f20a,Subgroup(f20a,[b]));
CHEVIE.families.F20:=rec(name:="Q(F_{20})",
x:=[ (), (), (), (), (), (2,3,5,4), (2,3,5,4), (2,3,5,4), (2,3,5,4),
  (2,4,5,3), (2,4,5,3), (2,4,5,3), (2,4,5,3), (2,5)(3,4), (2,5)(3,4),
  (2,5)(3,4), (2,5)(3,4), (1,2,3,4,5), (1,2,3,4,5), (1,2,3,4,5), (1,2,3,4,5),
  (1,2,3,4,5) ],
charLabels:=["(1,1)","(1,-1)","(1,i)","(1,-i)","(1,\\rho)","(g_4^3,1)",
"(g_4^3,-1)","(g_4^3,-i)","(g_4^3,i)","(g_4,1)","(g_4,-1)","(g_4,-i)",
"(g_4,i)","(g_4^2,1)","(g_4^2,-1)","(g_4^2,-i)","(g_4^2,i)","(g_5,1)",
"(g_5,\\zeta_5)", "(g_5,\\zeta_5^2)", "(g_5,\\zeta_5^3)", "(g_5,\\zeta_5^4)"],
eigenvalues:=[1,1,1,1,1,1,-1,E(4),-E(4),1,-1,-E(4),E(4),1,1,-1,-1,1,
              E(5),E(5)^2,E(5)^3,E(5)^4],
mellin:=ApplyFunc(DiagonalMat,
 [[[1,1,1,1,4],[1,-1,-E(4),E(4),0],[1,-1,E(4),-E(4),0],[1,1,-1,-1,0],[1,1,1,
1,-1]],[[1,1,1,1],[1,-1,E(4),-E(4)],[1,-1,-E(4),E(4)],[1,1,-1,-1]],[[1,1,1,
1],[1,-1,E(4),-E(4)],[1,-1,-E(4),E(4)],[1,1,-1,-1]],[[1,1,1,1],[1,-1,E(4),
-E(4)],[1,-1,-E(4),E(4)],[1,1,-1,-1]],[[1,1,1,1,1],[1,E(5),E(5)^2,E(5)^3,
E(5)^4],[1,E(5)^2,E(5)^4,E(5),E(5)^3],[1,E(5)^3,E(5),E(5)^4,E(5)^2],[1,
E(5)^4,E(5)^3,E(5)^2,E(5)]]]),
group:=Group( (1,2,3,4,5), (2,4,5,3) ),
fourierMat:=
[[1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4],
 [1,1,1,1,4,-5,-5,-5,-5,-5,-5,-5,-5,5,5,5,5,4,4,4,4,4],
 [1,1,1,1,4,-5*E(4),-5*E(4),-5*E(4),-5*E(4),5*E(4),5*E(4),5*E(4),5*E(4),-5,-5,
  -5,-5,4,4,4,4,4],
 [1,1,1,1,4,5*E(4),5*E(4),5*E(4),5*E(4),-5*E(4),-5*E(4),-5*E(4),-5*E(4),-5,-5,
  -5,-5,4,4,4,4,4],
 [4,4,4,4,16,0,0,0,0,0,0,0,0,0,0,0,0,-4,-4,-4,-4,-4],
 [5,-5,-5*E(4),5*E(4),0,5,-5,5*E(4),-5*E(4),5,-5,5*E(4),-5*E(4),5,-5,5*E(4),
  -5*E(4),0,0,0,0,0],
 [5,-5,-5*E(4),5*E(4),0,-5,5,-5*E(4),5*E(4),-5,5,-5*E(4),5*E(4),5,-5,5*E(4),
  -5*E(4),0,0,0,0,0],
 [5,-5,-5*E(4),5*E(4),0,5*E(4),-5*E(4),-5,5,-5*E(4),5*E(4),5,-5,-5,5,-5*E(4),
  5*E(4),0,0,0,0,0],
 [5,-5,-5*E(4),5*E(4),0,-5*E(4),5*E(4),5,-5,5*E(4),-5*E(4),-5,5,-5,5,-5*E(4),
  5*E(4),0,0,0,0,0],
 [5,-5,5*E(4),-5*E(4),0,5,-5,-5*E(4),5*E(4),5,-5,-5*E(4),5*E(4),5,-5,-5*E(4),
  5*E(4),0,0,0,0,0],
 [5,-5,5*E(4),-5*E(4),0,-5,5,5*E(4),-5*E(4),-5,5,5*E(4),-5*E(4),5,-5,-5*E(4),
  5*E(4),0,0,0,0,0],
 [5,-5,5*E(4),-5*E(4),0,5*E(4),-5*E(4),5,-5,-5*E(4),5*E(4),-5,5,-5,5,5*E(4),
  -5*E(4),0,0,0,0,0],
 [5,-5,5*E(4),-5*E(4),0,-5*E(4),5*E(4),-5,5,5*E(4),-5*E(4),5,-5,-5,5,5*E(4),
  -5*E(4),0,0,0,0,0],
 [5,5,-5,-5,0,5,5,-5,-5,5,5,-5,-5,5,5,-5,-5,0,0,0,0,0],
 [5,5,-5,-5,0,-5,-5,5,5,-5,-5,5,5,5,5,-5,-5,0,0,0,0,0],
 [5,5,-5,-5,0,5*E(4),5*E(4),-5*E(4),-5*E(4),-5*E(4),-5*E(4),5*E(4),5*E(4),-5,
  -5,5,5,0,0,0,0,0],
 [5,5,-5,-5,0,-5*E(4),-5*E(4),5*E(4),5*E(4),5*E(4),5*E(4),-5*E(4),-5*E(4),-5,
  -5,5,5,0,0,0,0,0],
 [4,4,4,4,-4,0,0,0,0,0,0,0,0,0,0,0,0,16,-4,-4,-4,-4],
 [4,4,4,4,-4,0,0,0,0,0,0,0,0,0,0,0,0,-4,6-2*ER(5),-4-4*ER(5),-4+4*ER(5),
  6+2*ER(5)],
 [4,4,4,4,-4,0,0,0,0,0,0,0,0,0,0,0,0,-4,-4-4*ER(5),6+2*ER(5),6-2*ER(5),
  -4+4*ER(5)],
 [4,4,4,4,-4,0,0,0,0,0,0,0,0,0,0,0,0,-4,-4+4*ER(5),6-2*ER(5),6+2*ER(5),
  -4-4*ER(5)],
 [4,4,4,4,-4,0,0,0,0,0,0,0,0,0,0,0,0,-4,6+2*ER(5),-4+4*ER(5),-4-4*ER(5),
  6-2*ER(5)]]/20,
special:=1);

CHEVIE.AddData("UnipotentCharacters","G29",function()
 return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="ST",indices:=[1..4],rank:=4,ST:=29),
 levi:=[], parameterExponents:=[1,1,1,1],
        charNumbers:=OnTuples([1..37],()),
	eigenvalue:=1, cuspidalName:=""),
   rec(relativeType:=rec(series:="ST",indices:=[4,1],rank:=2,p:=4,q:=1),
levi:=[2..3],
       parameterExponents:=[[2,2,0,0],3],
#      charNumbers:=[61,43,48,49,60,50,47,67,63,66,39,38,45,44],
       charNumbers:=[60,43,47,50,61,49,48,66,63,67,38,39,44,45],
       eigenvalue:=-1, cuspidalName:="B_2"),
   rec(relativeType:=rec(series:="ST",indices:=[1],rank:=1,p:=4,q:=1),
levi:=[2..4],
       parameterExponents:=[[6,1,0,1]],charNumbers:=[40,53,62,52],
       eigenvalue:=E(4), cuspidalName:="G_{4,4,3}[i]"),
   rec(relativeType:=rec(series:="ST",indices:=[1],rank:=1,p:=4,q:=1),
levi:=[2..4],
       parameterExponents:=[[6,5,0,5]],charNumbers:=[46,51,68,54],
       eigenvalue:=-E(4), cuspidalName:="G_{4,4,3}[-i]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[55], eigenvalue:=1, cuspidalName:="G_{29}[1]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[56], eigenvalue:=E(5), cuspidalName:="G_{29}[\\zeta_5]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[57], eigenvalue:=E(5)^2, 
       cuspidalName:="G_{29}[\\zeta_5^2]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[58], eigenvalue:=E(5)^3, 
       cuspidalName:="G_{29}[\\zeta_5^3]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[59], eigenvalue:=E(5)^4, 
       cuspidalName:="G_{29}[\\zeta_5^4]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[41], eigenvalue:=E(8), 
       cuspidalName:="G_{29}[\\zeta_8]",qEigen:=1/2),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[64], eigenvalue:=E(8)^3, 
       cuspidalName:="G_{29}[\\zeta_8^3]",qEigen:=1/2),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[42], eigenvalue:=E(8)^5, 
       cuspidalName:="G_{29}[\\zeta_8^5]",qEigen:=1/2),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..4], parameterExponents:=[],
       charNumbers:=[65], eigenvalue:=E(8)^7, 
       cuspidalName:="G_{29}[\\zeta_8^7]",qEigen:=1/2)],
   families:=[
    Family("C1",[1]),
    Family(ComplexConjugate(CHEVIE.families.X(4)),[5,3,7,39,40,38],
      rec(signs:=[1,1,1,1,-1,-1])),
    #JM 24/2/2003 changed signs of 40 to fit with G443
    Family("C1",[17]),
    # change by gunter 22/9/99 leads to
    ComplexConjugate(Family("Z4",[42,27,41,25],rec(signs:=[1,-1,-1,1]))),
    Family("C2",[21,9,19,43]),
    Family("C1",[20]),
    Family(CHEVIE.families.X(4),[31,28,33,45,46,44],rec(signs:=[1,1,1,1,-1,-1])),
    #JM 24/2/2003 changed signs of 46 to fit with G443
    Family("F20",
     [34,55,15,14,13,35,48,52,51,36,47,54,53,37,11,49,50,12,56,57,58,59],
     rec(signs:=[1,1,-1,-1,1,1,1,-1,-1,1,1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,1])),
    #JM 24/2/2003 changed signs of 51..54 to fit with G443 and exchanged 14
    # and 15 to make generic degrees fit with Malle's "On degrees..."
    Family(ComplexConjugate(CHEVIE.families.X(4)),[30,29,32,61,62,60],
       rec(signs:=[1,1,1,1,-1,-1])),
    #JM 24/2/2003 changed signs of 62 to fit with G443
    Family("C1",[22]),
    Family("C2",[23,10,18,63]),
    Family("Z4",[64,26,65,24],rec(signs:=[-1,1,1,-1])),
    Family("C1",[16]),
    Family(CHEVIE.families.X(4),[6,4,8,67,68,66],rec(signs:=[1,1,1,1,-1,-1])),
    #JM 24/2/2003 changed signs of 68 to fit with G443
    Family("C1",[2])],
  a:=[0,40,1,21,1,21,1,21,4,12,6,6,6,6,6,18,2,12,4,4,4,12,12,13,3,13,3,5,9,9,5,
   9,5,6,6,6,6,1,1,1,3,3,4,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,9,9,9,12,13,13,21,21,
   21],
  A:=[0,40,19,39,19,39,19,39,28,36,34,34,34,34,34,38,22,36,28,28,28,36,36,37,27,
   37,27,31,35,35,31,35,31,34,34,34,34,19,19,19,27,27,28,31,31,31,34,34,34,34,
   34,34,34,34,34,34,34,34,34,35,35,35,36,37,37,39,39,39]);
end);

# The first invariant (cf. Orlik and Terao) is \Phi_1 of Maschke.
# Then we choose (-1/20736)det(Hessian(Phi_1))=(4*F8-Phi_1^2)/3.
# We do not choose F12 but the simpler ((Phi_1^3-3*Phi_1*F8)/2+F12)/108.
# As for G31 we do not choose F20 but the simpler (F20-F8*F12)/1296.

CHEVIE.AddData("Invariants","G29",
[function(x1,x2,x3,x4) return -6*x1^2*x2^2-6*x1^2*x3^2-6*x1^2*x4^2-6*x2^2*x3^2
  -6*x2^2*x4^2-6*x3^2*x4^2+x1^4+x2^4+x3^4+x4^4;end,

  function(x1,x2,x3,x4) return
  152*x1^2*x2^2*x3^2*x4^2-20*x1^2*x2^2*x3^4-20*x1^2*x2^2*x4^4-20*x1^2*x3^2*x4^4-
20*x2^2*x3^2*x4^4-20*x1^2*x2^4*x3^2-20*x1^2*x2^4*x4^2-20*x1^2*x3^4*x4^2-
20*x2^2*x3^4*x4^2+4*x1^2*x2^6+4*x1^2*x3^6+4*x1^2*x4^6+4*x2^2*x3^6+4*x2^2*x4^6+
4*x3^2*x4^6-20*x1^4*x2^2*x3^2-20*x1^4*x2^2*x4^2-20*x1^4*x3^2*x4^2-
20*x2^4*x3^2*x4^2+6*x1^4*x2^4+6*x1^4*x3^4+6*x1^4*x4^4+6*x2^4*x3^4+6*x2^4*x4^4+
6*x3^4*x4^4+4*x1^6*x2^2+4*x1^6*x3^2+4*x1^6*x4^2+4*x2^6*x3^2+4*x2^6*x4^2+
4*x3^6*x4^2+x1^8+x2^8+x3^8+x4^8;end,

  function(x1,x2,x3,x4) return
2*x1^2*x2^2*x3^2*x4^6+2*x1^2*x2^2*x3^4*x4^4+2*x1^2*x2^2*x3^6*x4^2+
x1^2*x2^2*x3^8+x1^2*x2^2*x4^8+x1^2*x3^2*x4^8+x2^2*x3^2*x4^8+
2*x1^2*x2^4*x3^2*x4^4+2*x1^2*x2^4*x3^4*x4^2-x1^2*x2^4*x3^6-x1^2*x2^4*x4^6-
x1^2*x3^4*x4^6-x2^2*x3^4*x4^6+2*x1^2*x2^6*x3^2*x4^2-x1^2*x2^6*x3^4-
x1^2*x2^6*x4^4-x1^2*x3^6*x4^4-x2^2*x3^6*x4^4+x1^2*x2^8*x3^2+x1^2*x2^8*x4^2+
x1^2*x3^8*x4^2+x2^2*x3^8*x4^2+2*x1^4*x2^2*x3^2*x4^4+2*x1^4*x2^2*x3^4*x4^2-
x1^4*x2^2*x3^6-x1^4*x2^2*x4^6-x1^4*x3^2*x4^6-x2^4*x3^2*x4^6+
2*x1^4*x2^4*x3^2*x4^2-2*x1^4*x2^4*x3^4-2*x1^4*x2^4*x4^4-2*x1^4*x3^4*x4^4-
2*x2^4*x3^4*x4^4-x1^4*x2^6*x3^2-x1^4*x2^6*x4^2-x1^4*x3^6*x4^2-x2^4*x3^6*x4^2+
2*x1^6*x2^2*x3^2*x4^2-x1^6*x2^2*x3^4-x1^6*x2^2*x4^4-x1^6*x3^2*x4^4-
x2^6*x3^2*x4^4-x1^6*x2^4*x3^2-x1^6*x2^4*x4^2-x1^6*x3^4*x4^2-x2^6*x3^4*x4^2+
x1^8*x2^2*x3^2+x1^8*x2^2*x4^2+x1^8*x3^2*x4^2+x2^8*x3^2*x4^2;end,

function(x1,x2,x3,x4) return
-x1^2*x2^2*x3^2*x4^14+x1^2*x2^2*x3^6*x4^10+x1^2*x2^2*x3^10*x4^6-
x1^2*x2^2*x3^14*x4^2+x1^2*x2^6*x3^2*x4^10+14*x1^2*x2^6*x3^6*x4^6+
x1^2*x2^6*x3^10*x4^2+x1^2*x2^10*x3^2*x4^6+x1^2*x2^10*x3^6*x4^2-
x1^2*x2^14*x3^2*x4^2-13*x1^4*x2^4*x3^4*x4^8-13*x1^4*x2^4*x3^8*x4^4+
x1^4*x2^4*x3^12+x1^4*x2^4*x4^12+x1^4*x3^4*x4^12+x2^4*x3^4*x4^12-
13*x1^4*x2^8*x3^4*x4^4-2*x1^4*x2^8*x3^8-2*x1^4*x2^8*x4^8-2*x1^4*x3^8*x4^8-
2*x2^4*x3^8*x4^8+x1^4*x2^12*x3^4+x1^4*x2^12*x4^4+x1^4*x3^12*x4^4+
x2^4*x3^12*x4^4+x1^6*x2^2*x3^2*x4^10+14*x1^6*x2^2*x3^6*x4^6+
x1^6*x2^2*x3^10*x4^2+14*x1^6*x2^6*x3^2*x4^6+14*x1^6*x2^6*x3^6*x4^2+
x1^6*x2^10*x3^2*x4^2-13*x1^8*x2^4*x3^4*x4^4-2*x1^8*x2^4*x3^8-2*x1^8*x2^4*x4^8-
2*x1^8*x3^4*x4^8-2*x2^8*x3^4*x4^8-2*x1^8*x2^8*x3^4-2*x1^8*x2^8*x4^4-
2*x1^8*x3^8*x4^4-2*x2^8*x3^8*x4^4+x1^10*x2^2*x3^2*x4^6+x1^10*x2^2*x3^6*x4^2+
x1^10*x2^6*x3^2*x4^2+x1^12*x2^4*x3^4+x1^12*x2^4*x4^4+x1^12*x3^4*x4^4+
x2^12*x3^4*x4^4-x1^14*x2^2*x3^2*x4^2;end]);

# the matrix of basic derivations (a matrix of polynomials in the invariants)
CHEVIE.AddData("BasicDerivations","G29",function()return function(x,y,z,t)return
[[4*x,8*y^2,12*z+(1/40)*x*y,20*t+(1/10)*y*z],[8*y,51200*t+2816*y*z+
16*x*y^2,(4/5)*x*z+(1/20)*x^2*y,-8*t*x+(1/5)*x*y*z+(96/5)*z^2],[12*z,-160*t*x-
8*x*y*z,(5/2)*t+(-1/16)*y*z+(3/80)*x^2*z,(-1/8)*t*y+(1/8)*t*x^2+(-
1/10)*x*z^2],[20*t,-640*t*z-8*t*x*y-16*y*z^2,(-1/8)*t*y+(1/10)*t*x^2+(-
1/20)*x*z^2,(9/10)*t*x*z+(-6/5)*z^3]];
end;end);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","G29",function()return function(x,y,z,t)
return -442368*t*x*y*z^4+4*t*x*y^4*z^2-4736*t*x^2*y^2*z^3+4608*x*y^2*z^5+
128*t*y^3*z^3-8*t*x^3*y^3*z^2-8192*t*x^3*z^4+512*t*x^4*y*z^3+7077888*t*z^5+
4*t*x^5*y^2*z^2+442368*y*z^6-7372800*t^2*x*z^3-1280*t^2*x*y^3*z+
110080*t^2*x^2*y*z^2-115200*t^2*y^2*z^2-3*t^2*x^2*y^4+1408*t^2*x^3*y^2*z+
8*x^2*y^3*z^4+8192*t^2*x^4*z^2+3*t^2*x^4*y^3+t^2*y^5-128*t^2*x^5*y*z-
t^2*x^6*y^2-5120000*t^3*y*z-32000*t^3*x*y^2-512*x^3*y*z^5+2048000*t^3*x^2*z+
6400*t^3*x^3*y-2048*t^3*x^5-51200000*t^4-4*x^4*y^2*z^4-4*y^4*z^4;
end;end);
