#############################################################################
##
#A  tbl/cmplxg27.g          CHEVIE library          Gunter Malle, Jean Michel
##
#Y  Copyright (C) 1998 - 2005  The CHEVIE Team
##
##  This file contains data about the complex reflection group
##  of type G27 in the Shephard-Todd classification.
##
CHEVIE.Revision("tbl/cmplxg27.g",
   "$Id: cmplxg27.g,v 1.6 2003/12/04 11:26:45 chevie Exp $");

## of interest are the alternate presentations of the braid group:
CHEVIE.AddData("AltPres","G27",[
rec(gens:=[[2],[2,3,-2],[1]],
  rels:=[[[1,3,1],[3,1,3]],
  [[1,2,1,2],[2,1,2,1]],[[2,3,2,3,2],[3,2,3,2,3]],
  [[3,2,1,3,2,1,2],[1,3,2,1,3,2,1]]]),
  rec(gens:=[[1],[-1,3,1],[2]],
  rels:=[[[1,2,1],[2,1,2]],[[2,3,2,3,2],[3,2,3,2,3]],[[1,3,1],[3,1,3]],
    [[2,3,2,3,1,2,3,1,2,3],[3,2,3,1,2,3,1,2,3,1]]]),
  rec(gens:=[[2],[3],[-3,-2,1,2,3]],
  rels:=[[[1,2,1,2],[2,1,2,1]],[[2,3,2,3,2],[3,2,3,2,3]],[[1,3,1,3,1],[3,1,3,1,3]],
   [[2,3,1,2,3,1,2],[1,2,3,1,2,3,1]],[[3,1,2,3,1,2,3,1],[1,2,3,1,2,3,1,3]]]),
  rec(gens:=[[3],[-3,2,3],[1]],
  rels:=[[[1,3,1],[3,1,3]],
  [[1,2,1,2],[2,1,2,1]],[[2,3,2,3,2],[3,2,3,2,3]],
  [[2,1,2,3,1,2,3],[1,2,3,1,2,3,1]]])]);

#[[1,3,-1],[1],[2]]
CHEVIE.AddData("BraidRelations","G27",
 [[[2,1,2],[1,2,1]],[[3,1,3],[1,3,1]],[[3,2,3,2],[2,3,2,3]],
  [[3,2,3,1,2,3,1,2,3,1,2,3],[2,3,1,2,3,1,2,3,1,2,3,2]]]);
# Third presentation of Bessis-Michel

CHEVIE.AddData("PrintDiagram","G27",function(indices,title)local s;
  Print(title," ",indices[1],"\n");s:=String("",Length(title)-1);
  Print(s," / \\\n",
	s,indices[2],"===",indices[3],"  ",
	IntListToString(indices{[3,2,3,1,2,3,1,2,3,1,2,3]}),"=",
	IntListToString(indices{[2,3,1,2,3,1,2,3,1,2,3,2]}),"\n");
end);

CHEVIE.AddData("GeneratingRoots","G27",
[[-ER(5)/5,
(-E(15)^14+E(15)^13+E(15)^11-E(15)^8-E(15)^7-E(15)^4+E(15)^2+E(15))/5,
(4*E(15)^14-4*E(15)^11+2*E(15)^4-2*E(15))/15],
[(5-ER(-15))*E(3)/10,(-E(15)^13-E(15)^8+E(15)^7+E(15)^4+E(15)^2-E(15))/5,
(-4*E(15)^14+4*E(15)^11-2*E(15)^4+2*E(15))/15],[2*ER(5)/5,0,0]]);

CHEVIE.AddData("GeneratingCoRoots","G27",
[[-ER(5)/2,
(E(15)^14+E(15)^13-E(15)^11-E(15)^8-E(15)^7+E(15)^4+E(15)^2-E(15))/2,
(-E(15)^14+E(15)^11-2*E(15)^4+2*E(15))/2],
[(5+ER(-15))*E(3)^2/4,
(-E(15)^14+E(15)^13+E(15)^11+E(15)^8-E(15)^7-E(15)^2)/2,
(E(15)^14-E(15)^11+2*E(15)^4-2*E(15))/2],[ER(5),0,0]]);

CHEVIE.AddData("CartanMat","G27",function()
  return CHEVIE.RawData("GeneratingCoRoots","G27")*
  TransposedMat(CHEVIE.RawData("GeneratingRoots","G27"));
 end);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G27",[1/2,1/2,1/2]);

CHEVIE.AddData("Size","G27", 2160);

CHEVIE.AddData("ReflectionDegrees","G27",[6,12,30]);

CHEVIE.AddData("NrConjugacyClasses","G27", 34);

CHEVIE.AddData("ParabolicRepresentatives","G27",# repr. of conj. classes
[[],[1],[1,2],[1,3],[2,3],[1,8],[1..3]]);

CHEVIE.AddData("ClassNames","G27",
 [".","2","12","c2","23","132","c","2c2c","13","3232",#10
  "2cc","ccc","23z","132132","cc",#15
  "13z","2ccc","32zzzz","cc21323","zcc",#20
  "12z","1z","3232zz","2323z","1zz",#25
  "zzcccc","cccc","zcccc","32zzz","z",#30
  "zzzzz","zz","zzzz","zzz"]);

CHEVIE.AddData("WordsClassRepresentatives","G27",
List(CHEVIE.RawData("ClassNames","G27"),
 x->Replace(x,".",[],"1",[1],"2",[2],"3",[3],"c",[1,2,3],"z",
 [1,2,3,1,2,3,1,2,3,1,2,3,1,2,3])));

CHEVIE.AddData("PowerMaps","G27",
 [,[1,1,3,8,10,14,15,4,9,1,22,4,23,26,27,9,22,23,
   27, 26, 3, 32, 33, 32, 33, 14, 15, 8, 10, 32, 33, 33, 32, 1 ],
  [ 1, 2, 1, 8, 5, 12, 12, 4, 1, 10, 29, 28, 29, 4, 4, 34, 5, 5, 28, 28, 34,
      10, 10, 2, 2, 8, 8, 12, 29, 34, 34, 1, 1, 34 ],,
  [ 1, 2, 3, 1, 5, 31, 30, 1, 9, 10, 13, 34, 11, 33, 32, 16, 18, 17, 31, 30,
      21, 23, 22, 25, 24, 32, 33, 34, 29, 31, 30, 33, 32, 34 ],,
  [ 1, 2, 3, 8, 5, 19, 20, 4, 9, 10, 11, 28, 13, 27, 26, 16, 17, 18, 6, 7,
      21, 22, 23, 24, 25, 15, 14, 12, 29, 30, 31, 32, 33, 34 ],,,,
  [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 10, 13, 12, 11, 15, 14, 16, 18, 17, 20, 19,
      21, 23, 22, 25, 24, 27, 26, 28, 29, 31, 30, 33, 32, 34 ],,
  [ 1, 2, 3, 8, 5, 19, 20, 4, 9, 10, 11, 28, 13, 27, 26, 16, 17, 18, 6, 7,
      21, 22, 23, 24, 25, 15, 14, 12, 29, 30, 31, 32, 33, 34 ],,,,
  [ 1, 2, 3, 8, 5, 20, 19, 4, 9, 10, 13, 28, 11, 26, 27, 16, 18, 17, 7, 6,
      21, 23, 22, 25, 24, 14, 15, 12, 29, 31, 30, 33, 32, 34 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ],,,,
  [ 1, 2, 3, 8, 5, 20, 19, 4, 9, 10, 13, 28, 11, 26, 27, 16, 18, 17, 7, 6,
      21, 23, 22, 25, 24, 14, 15, 12, 29, 31, 30, 33, 32, 34 ],,,,,,
  [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 10, 13, 12, 11, 15, 14, 16, 18, 17, 20, 19,
      21, 23, 22, 25, 24, 27, 26, 28, 29, 31, 30, 33, 32, 34 ] ]);

CHEVIE.AddData("ClassInfo","G27",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G27"),
    classnames:=CHEVIE.RawData("ClassNames","G27"),
    classparams:=CHEVIE.RawData("ClassNames","G27"),
    orders:=[1,2,3,5,4,30,30,5,3,2,12,10,12,15,15,6,12,12,30,30,6,6,6,6,6,15,
     15,10,4,6,6,3,3,2],
    classes:=[1,45,120,72,90,72,72,72,120,45,90,72,90,72,72,120,90,90,
      72,72,120,45,45,45,45,72,72,72,90,1,1,1,1,1]));

CHEVIE.AddData("CharInfo","G27",function()local res;
  res:=rec(charparams:=[[1,0],[1,45],[3,7],[3,22],[3,1],[3,16],[3,5,1],[3,20,1],
  [3,5,2],[3,20,2],[5,6,2],[5,6,1],[5,15,2],[5,15,1],[6,19],[6,4],[6,17],[6,2],
  [8,6],[8,9,1],[8,12],[8,9,2],[9,6],[9,9],[9,13],[9,4],[9,11],[9,8],[10,12],
  [10,3],[15,7],[15,10],[15,5],[15,8]],
# The labelling is determined as follows:
# phi{5,6}' and phi{5,15}' occur with multiplicity one in the induced
# of identity from the parabolic A2 given by [1,3]
# for the other pairs the character with the smallest degree of the fakedegree
# is labelled with ', the other with ''
  extRefl:=[1,5,10,2]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,
    3,3,3,1,1,1,1,1,1];
  return res;
end);

CHEVIE.AddData("CycPolSchurElements","G27",
[ [1,0,2,2,2,3,3,3,4,5,6,6,6,10,12,15,30],
  [1,-45,2,2,2,3,3,3,4,5,6,6,6,10,12,15,30],
  [-2*ER(-15)*E(3),-1,2,2,2,1/3,1/3,1/3,1/5,4/5,5/6,5/6,5/6,1/10,9/10,2/15,
    8/15,7/30,13/30],
  [2*ER(-15)*E(3)^2,-16,2,2,2,2/3,2/3,2/3,1/5,4/5,1/6,1/6,1/6,1/10,9/10,7/15,
    13/15,17/30,23/30],
  [2*ER(-15)*E(3),-1,2,2,2,1/3,1/3,1/3,2/5,3/5,5/6,5/6,5/6,3/10,7/10,11/15,
    14/15,1/30,19/30],
  [-2*ER(-15)*E(3)^2,-16,2,2,2,2/3,2/3,2/3,2/5,3/5,1/6,1/6,1/6,3/10,7/10,1/15,
    4/15,11/30,29/30],
  [2*ER(-15)*E(3)^2,-1,2,2,2,2/3,2/3,2/3,1/5,4/5,1/6,1/6,1/6,1/10,9/10,7/15,
    13/15,17/30,23/30],
  [-2*ER(-15)*E(3),-16,2,2,2,1/3,1/3,1/3,1/5,4/5,5/6,5/6,5/6,1/10,9/10,2/15,
    8/15,7/30,13/30],
  [-2*ER(-15)*E(3)^2,-1,2,2,2,2/3,2/3,2/3,2/5,3/5,1/6,1/6,1/6,3/10,7/10,1/15,
    4/15,11/30,29/30],
  [2*ER(-15)*E(3),-16,2,2,2,1/3,1/3,1/3,2/5,3/5,5/6,5/6,5/6,3/10,7/10,11/15,
    14/15,1/30,19/30], [2,-3,2,2,2,3,3,3,6,6,6], [2,-3,2,2,2,3,3,3,6,6,6],
  [2,-12,2,2,2,3,3,3,6,6,6], [2,-12,2,2,2,3,3,3,6,6,6],
  [3-ER(-3),-16,2,2/3,2/3,2/3,4,5,1/6,5/12,11/12,1/15,4/15,7/15,13/15],
  [3+ER(-3),-1,2,1/3,1/3,1/3,4,5,5/6,1/12,7/12,2/15,8/15,11/15,14/15],
  [3+ER(-3),-16,2,1/3,1/3,1/3,4,5,5/6,1/12,7/12,2/15,8/15,11/15,14/15],
  [3-ER(-3),-1,2,2/3,2/3,2/3,4,5,1/6,5/12,11/12,1/15,4/15,7/15,13/15],
  [5+ER(5),-6,3,3,3,2/5,3/5,1/15,4/15,11/15,14/15],
  [5+ER(5),-6,3,3,3,2/5,3/5,1/15,4/15,11/15,14/15],
  [5-ER(5),-6,3,3,3,1/5,4/5,2/15,7/15,8/15,13/15],
  [5-ER(5),-6,3,3,3,1/5,4/5,2/15,7/15,8/15,13/15], [3,-4,2,2,2,4,5,10],
  [3,-9,2,2,2,4,5,10], [3,-9,2,2,2,4,5,10], [3,-4,2,2,2,4,5,10],
  [3,-9,2,2,2,4,5,10], [3,-4,2,2,2,4,5,10], [2,-12,2,3,3,3,4,6,12],
  [2,-3,2,3,3,3,4,6,12],
  [(3+ER(-3))/2,-5,2,2,2,2/3,2/3,2/3,4,1/6,1/6,1/6,5/12,11/12],
  [(3-ER(-3))/2,-8,2,2,2,1/3,1/3,1/3,4,5/6,5/6,5/6,1/12,7/12],
  [(3-ER(-3))/2,-5,2,2,2,1/3,1/3,1/3,4,5/6,5/6,5/6,1/12,7/12],
  [(3+ER(-3))/2,-8,2,2,2,2/3,2/3,2/3,4,1/6,1/6,1/6,5/12,11/12]]);

# description of fake degrees by powers of q
CHEVIE.AddData("factors","G27",
[[1,0],[1,45],[1,7,1,13,1,25],[1,22,1,28,1,40],[1,1,1,19,1,25],[1,16,1,34,1,
40],[1,5,1,17,1,23],[1,20,1,32,1,38],[1,5,1,11,1,29],[1,20,1,26,1,44],[1,6,1,
12,1,18,1,24,1,30],[1,6,1,12,1,18,1,24,1,30],[1,15,1,21,1,27,1,33,1,39],[1,15,
1,21,1,27,1,33,1,39],[1,19,2,25,1,31,1,37,1,43],[1,4,2,10,1,16,1,22,1,28],[1,
17,1,23,1,29,2,35,1,41],[1,2,1,8,1,14,2,20,1,26],[1,6,1,12,1,18,2,24,2,30,1,
36],[1,9,2,15,2,21,1,27,1,33,1,39],[2,12,2,18,1,24,2,30,1,36],[1,9,2,15,1,21,
2,27,2,33],[1,6,2,12,2,18,2,24,1,30,1,36],[1,9,1,15,2,21,2,27,2,33,1,39],[2,
13,2,19,1,25,2,31,2,37],[1,4,1,10,2,16,2,22,2,28,1,34],[1,11,2,17,2,23,2,29,1,
35,1,41],[2,8,2,14,1,20,2,26,2,32],[1,12,2,18,2,24,2,30,2,36,1,42],[1,3,2,9,2,
15,2,21,2,27,1,33],[2,7,3,13,3,19,3,25,3,31,1,37],[2,10,3,16,3,22,3,28,3,34,1,
40],[1,5,3,11,3,17,3,23,3,29,2,35],[1,8,3,14,3,20,3,26,3,32,2,38]]);

# Computed JM feb. 2008
CHEVIE.AddData("HeckeCharTable","G27",function(para,root)
  local tbl,r,p,q,f1,f3,f11,f12,f15,f19,f23,f29,f31;
  q:=-para[1][1]/para[1][2];r:=para[1][1];p:=para[1][2];
  tbl:=rec(
  identifier:="H(G27)",
  size:=2160, order:=2160,
  powermap:=CHEVIE.RawData("PowerMaps","G27"));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","G27"));
  f1:=r->List(tbl.classtext,x->r^Length(x));
  f3:=function(r,p,j,d)return
[3, p+2*r, p*r+r^2, (-1+j*(1-d)/2)*p*r^3+(-2+(1-d)*(1+j))/2*p^2*r^2, r^2, #5
-p*r^2+(-1+j-d-j*d)/2*p^2*r, ((1-d)*j/2)*p*r^2,
(3/2-3/2*j+1/2*d+1/2*d*j)*p^2*r^6+(1-j+d+j*d)*p^3*r^5+(j/2+d+j*d/2)*p^4*r^4,
p*r+r^2,-2*p^2*r^2+r^4, -j*p^2*r^5, ((1+d)/2)*p^3*r^6, j^2*p^5*r^12,
(j/2+d+j*d/2)*r^2*p^4+(1-j+d+j*d)*p^3*r^3+3*r^4*p^2+(2+j-j*d)*r^5*p,
((1+d)*j^2/2)*p^2*r^4, j^2*p^5*r^12+j^2*p^6*r^11,#16
((1+d)/2)*p^3*r^7+(1/2+j+d/2)*p^4*r^6, j^2*p^20*r^42,
((-1+d)*j^2/2)*p^3*r^8+j^2*p^5*r^6,
((1+d)*j/2)*p^7*r^14,j^2*p^5*r^12+j^2*p^6*r^11,2*j^2*p^5*r^11+j^2*p^6*r^10,
j*p^10*r^24-2*j*p^12*r^22,j^2*p^5*r^14-2*j^2*p^7*r^12,2*j*p^10*r^21+j*p^11*r^20,
((1-d)*j^2/2)*p^14*r^28,((1-d)*j/2)*p^4*r^8,
((1-d)/2)*p^9*r^18,p^15*r^32,3*j^2*p^5*r^10,3*j*p^25*r^50,
3*j*p^10*r^20,3*j^2*p^20*r^40,3*p^15*r^30];end;
  f11:=function(r,p)return
  [5,2*p+3*r,2*p*r+r^2,-p*r^3-p^2*r^2,2*p*r+r^2,0,0,p^2*r^6+2*p^3*r^5+p^4*r^4,
p*r+p^2+2*r^2,r^4, p^3*r^4,0,p^6*r^11+2*p^7*r^10,
0,0,2*p^6*r^11+p^7*r^10+p^8*r^9,-p^4*r^6,
p^24*r^38+2*p^25*r^37,-p^4*r^7+p^6*r^5,0,p^6*r^11+2*p^7*r^10,
3*p^6*r^10+2*p^7*r^9,p^12*r^22,p^6*r^13,3*p^12*r^19+2*p^13*r^18,0,0,0,
p^18*r^29+2*p^19*r^28,5*p^6*r^9,5*p^30*r^45,5*p^12*r^18,5*p^24*r^36,
5*p^18*r^27];end;
  f12:=function(r,p)return
  [5,2*p+3*r,p*r+p^2+2*r^2,-p*r^3-p^2*r^2,2*p*r+r^2,0,0,
p^2*r^6+2*p^3*r^5+p^4*r^4,2*p*r+r^2,r^4,p^3*r^4,0,p^6*r^11+2*p^7*r^10,
0,0,p^6*r^11+2*p^7*r^10,-p^4*r^6,
p^24*r^38+2*p^25*r^37,-p^4*r^7+p^6*r^5,0,2*p^6*r^11+p^7*r^10+p^8*r^9,
3*p^6*r^10+2*p^7*r^9,p^12*r^22,p^6*r^13,3*p^12*r^19+2*p^13*r^18,0,0,0,
p^18*r^29+2*p^19*r^28,5*p^6*r^9,5*p^30*r^45,5*p^12*r^18,5*p^24*r^36,
5*p^18*r^27];end;
  f15:=function(r,p,j)return
  [6,4*p+2*r,2*p*r+2*p^2,j^2*p^2*r^2+(2*j^2+j)*p^3*r,2*p*r+2*p^2,
j^2*p*r^2,-j*p^2*r,j*p^4*r^4-2*j^2*p^5*r^3-(3*j^2+2*j)*p^6*r^2,
2*p*r+2*p^2,2*p^4,0,-p^6*r^3,
-2*j^2*p^11*r^6-2*j^2*p^12*r^5,j*p^2*r^4-2*j^2*p^3*r^3+2*p^4*r^2-2*j*p^5*r,
j^2*p^4*r^2,-2*j^2*p^11*r^6-2*j^2*p^12*r^5,
-p^6*r^4-p^7*r^3,2*j^2*p^41*r^21+2*j^2*p^42*r^20,
-2*j^2*p^6*r^5+j^2*p^8*r^3,-j*p^14*r^7,
-2*j^2*p^11*r^6-2*j^2*p^12*r^5,-2*j^2*p^10*r^6-4*j^2*p^11*r^5,
2*j*p^24*r^10,-2*j^2*p^14*r^5,2*j*p^20*r^11+4*j*p^21*r^10,
j^2*p^28*r^14,j*p^8*r^4,-p^18*r^9,-2*p^31*r^16-2*p^32*r^15,
-6*j^2*p^10*r^5,-6*j*p^50*r^25,6*j*p^20*r^10,6*j^2*p^40*r^20,
-6*p^30*r^15];end;
  f19:=function(x,y,d,sgn)local v;v:=sgn*GetRoot(-x*y,2);return 
[8,4*x+4*y,3*x*y+x^2+y^2,-(1+d)/2*v*x*y^2-(1+d)/2*v*x^2*y-x*y^3+
(-3+d)/2*x^2*y^2-x^3*y,2*x*y+x^2+y^2,-(1+d)/2*v*x*y-x*y^2-x^2*y-x^3-y^3,
-(1+d)/2*v*x*y,x^2*y^6+(1-d)/2*x^3*y^5-(1+3*d)/2*x^4*y^4
+(1-d)/2*x^5*y^3+x^6*y^2,3*x*y+x^2+y^2,-2*x^2*y^2+x^4+y^4,0,(1-d)/2*v*x^4*y^4,
-v*x^7*y^9-2*v*x^8*y^8-v*x^9*y^7,(3+d)*v*x^2*y^3+(3+d)*v*x^3*y^2+
2*x*y^5+3*x^2*y^4+(7+d)/2*x^3*y^3+3*x^4*y^2+2*x^5*y+x^6+y^6,(-1+d)/2*x^3*y^3,
-v*x^7*y^9-3*v*x^8*y^8-v*x^9*y^7,(1-d)/2*v*x^4*y^5+(1-d)/2*v*x^5*y^4,
x^30*y^32+2*x^31*y^31+x^32*y^30,-v*x^3*y^7+(3+d)/2*v*x^5*y^5-v*x^7*y^3,
(1-d)/2*v*x^10*y^10,-v*x^7*y^9-3*v*x^8*y^8-v*x^9*y^7,-4*v*x^7*y^8-4*v*x^8*y^7,
-x^15*y^19+2*x^17*y^17-x^19*y^15,-v*x^7*y^11+2*v*x^9*y^9-v*x^11*y^7,
-4*x^15*y^16-4*x^16*y^15,-(1+d)/2*x^21*y^21,(1+d)/2*x^6*y^6,
-(1+d)/2*v*x^13*y^13,v*x^22*y^24+2*v*x^23*y^23+v*x^24*y^22,-8*v*x^7*y^7,
-8*v*x^37*y^37,-8*x^15*y^15,8*x^30*y^30,8*v*x^22*y^22];
  end;
  f23:=function(r,p,j)local q;q:=GetRoot(-r/p,3)*j;
 return Zip([9,-4+5*q^3,1-3*q^3+2*q^6,q^5-2*q^6-q^8+q^9,1-2*q^3+2*q^6,
  -q^3-q^4+q^6,-q^5,q^10-2*q^11-2*q^12-2*q^13+2*q^14+q^16+q^18,1-3*q^3+2*q^6,
  1-2*q^6+2*q^12,q^11, -q^15, q^25-2*q^28+2*q^31,
  q^6+2*q^7+q^8-2*q^9-4*q^10+3*q^12+2*q^13-2*q^14-2*q^15,-q^10,
  q^25-3*q^28+2*q^31,q^15+q^17-q^18,
  q^100-2*q^103+2*q^106,q^13-2*q^19,-q^35,q^25-3*q^28+2*q^31,-4*q^25+5*q^28,
  q^50-2*q^56+2*q^62,q^25-2*q^31+2*q^37,-4*q^50+5*q^53,-q^70,-q^20,-q^45,
  q^75-2*q^78+2*q^81,9*q^25,9*q^125,9*q^50,9*q^100,9*q^75],tbl.classtext,
function(x,y)return x*(-p)^Length(y);end);end;
  f29:=function(r,p)local q;q:=-r/p;return Zip(
 [10,-6+4*q,3-3*q+q^2,2*q-2*q^2,2-2*q,-2*q+2*q^2,0,2*q^2-2*q^4,3-3*q+q^2,
2-4*q^2,0,0,2*q^6-2*q^7,-4*q+8*q^2-4*q^3,0,3*q^6-3*q^7+q^8,0,
2*q^24-2*q^25,-2*q^4+2*q^6,0,3*q^6-3*q^7+q^8,-6*q^6+4*q^7,2*q^12-4*q^14,
2*q^6-4*q^8,-6*q^12+4*q^13,0,0,0,2*q^18-2*q^19,10*q^6,10*q^30,10*q^12,
10*q^24,10*q^18],tbl.classtext,
function(x,y)return x*(-p)^Length(y);end);
  end;
 f31:=function(p,r,j)local q;q:=-r/p;return Zip(
 [15,-7+8*q,2-5*q+3*q^2,2*q^3-3*q^2+q,
 1-4*q+2*q^2,2*q^2-2*q+1-q^3,
 0, q^2+(3*j^2+j)*q^4+2*j*q^5+2*q^6,2-5*q+3*q^2,1-4*q^2+2*q^4,j*q^4,0,
-j^2*q^8+4*j^2*q^9-2*j^2*q^10,
1-2*q+(-4*j^2-2*j)*q^2+(8*j^2+4*j)*q^3+(-8*j^2-6*j)*q^4-4*q^5+q^6,
0,-2*j^2*q^8+5*j^2*q^9-3*j^2*q^10,-j*q^5,
j^2*q^32-4*j^2*q^33+2*j^2*q^34,
-2*j^2*q^4+3*j^2*q^6-j^2*q^8,0,-2*j^2*q^8+5*j^2*q^9-3*j^2*q^10,
7*j^2*q^8-8*j^2*q^9,j*q^16-4*j*q^18+2*j*q^20,-j^2*q^8+
4*j^2*q^10-2*j^2*q^12,-7*j*q^16+8*j*q^17,0,0,0,-q^24+
4*q^25-2*q^26,-15*j^2*q^8,-15*j*q^40,15*j*q^16,15*j^2*q^32, -15*q^24],
  tbl.classtext,
function(x,y)return x*(-p)^Length(y);end);
  end;
  tbl.irreducibles:=[f1(r),f1(p),
    f3(r,p,E(3),ER(5)),f3(p,r,E(3),ER(5)),
    f3(r,p,E(3),-ER(5)),f3(p,r,E(3),-ER(5)),
    f3(r,p,E(3)^2,ER(5)),f3(p,r,E(3)^2,ER(5)),
    f3(r,p,E(3)^2,-ER(5)),f3(p,r,E(3)^2,-ER(5)),
    f11(r,p),f12(r,p),f12(p,r),f11(p,r),
    f15(r,p,E(3)),f15(p,r,E(3)),f15(r,p,E(3)^2),f15(p,r,E(3)^2),
    f19(r,p,ER(5),1),f19(r,p,ER(5),-1),f19(r,p,-ER(5),1),f19(r,p,-ER(5),-1),
    f23(r,p,1),f23(p,r,1),f23(p,r,E(3)^2),
    f23(r,p,E(3)^2),f23(p,r,E(3)),f23(r,p,E(3)),
  f29(r,p),f29(p,r),
  f31(p,r,E(3)),f31(r,p,E(3)),f31(p,r,E(3)^2),f31(r,p,E(3)^2)]*q^0;
  tbl.centralizers:=List(tbl.classes,x->tbl.order/x);
  tbl.irredinfo:=List(CHEVIE.RawData("CharInfo","G27")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G27")(x,rec())));
  tbl.galomorphisms:=Group((4,8)(6,19)(7,20)(12,28)(14,27)(15,26),(6,7)
   (11,13)(14,15)(17,18)(19,20)(22,23)(24,25)(26,27)(30,31)(32,33));
  tbl := CHEVIE.compat.MakeCharacterTable(tbl);
# CHEVIE.compat.AdjustHeckeCharTable(tbl,para);
  return tbl;
end);

CHEVIE.AddData("CharTable","G27",function()
  return CHEVIE.RawData("HeckeCharTable","G27")([[1,-1],[1,-1],[1,-1]],[]);end);

CHEVIE.AddData("HeckeRepresentation","G27",function(para,root,i)
  local p,r,rep,f1,f3,f11,f12,f15,f19,f23,f29,f31;
  p:=para[1][2];r:=para[1][1];
  f1:=r->List([1..3],x->[[r]]);
  f3:=function(r,p,j,d)local c;c:=(2+j^2*(1-d))/2;
    return WGraph2Representation([[[1,2],[1,3],[2,3]],
    [[1,2,-2,p*r],[1,3,-c,p*r/c],[2,3,r,-p]]],[p,r])*p^0*r^0;end;

  f11:=function(r,p)return WGraph2Representation([[[1,2],[1,3],[1,3],[2],[2,3]],
[[1,2,p,0],[1,3,-p,r],[1,5,p,-r],[2,4,0,p],[2,5,p,-r],[3,4,r,-p],[3,5,p,0]]],
[p,r])*p^0*r^0;end;

 # obtained from f11 by the anti-automorphism of B(W)
 f12:=function(r,p)return WGraph2Representation([[[1,3],[1,2],[1,2],[3],[2,3]],
  [[1,2,0,r],[1,3,p,-r],[2,4,r,0],[3,4,-r,p],[1,5,-p,r],[2,5,-p,r],[3,5,0,r]]],
  [p,r])*p^0*r^0;end;

  f15:=function(x,y,j)return WGraph2Representation([[[1],[1],[2],[2],[3],[3]],
    [[1,4,x,-y],[1,5,x,-y],[2,3,y,-x],[2,6,j^2*x,-j*y],[3,5,2*y,0],
     [3,6,2*x,-y],[4,5,-j*y,0],[4,6,-j*x,0]]],[x,y])*x^0*r^0;end;

  f19:=function(x,y,d,sgn)local v;v:=-sgn*GetRoot(-x*y,2); 
   return [[[x,0,-y,0,0,0,v-y*(1+d)/2,0],[0,x+y,0,y,0,0,0,0],
    [0,0,y,0,0,0,0,0],[0,-x,0,0,0,0,0,0],[0,0,0,0,0,0,0,x],
    [0,0,v+x*(1+d)/2,0,0,x,x,0],[0,0,0,0,0,0,y,0],[0,0,0,0,-y,0,0,x+y]],
    [[x,0,-y,y,0,v,v,-y],[0,x,-x*(3+d)/2,x,0,0,0,0],[0,0,y,0,0,0,0,0],
    [0,0,0,y,0,0,0,0],[0,0,x,0,x,0,0,y],[0,0,0,0,0,x+y,y,0],[0,0,0,0,0,-x,0,0],
    [0,0,0,0,0,0,0,y]],[[0,0,-x,0,0,0,0,0],[0,x,0,x,0,0,-y*(3+d)/2,0],
    [y,0,x+y,0,0,0,0,0],[0,0,0,y,0,0,0,0],[0,0,0,0,y,0,0,0],[v,0,v,-y,v,x,x,0],
    [0,0,0,0,0,0,y,0],[0,0,0,0,-x,0,v,x]]]*x^0*y^0;end;

  f23:=function(p,r,e)local x,y;
   x:=e*GetRoot(r,3);y:=GetRoot(p,3);
   return WGraph2Representation([[[1],[1,2],[1,2],[1,3],[1,3],[2],[2,3],[2,3],
  [3]],[[1,2,0,x*y^2-x^2*y+x^3-y^3],[1,3,0,-x*y^2+x^2*y-x^3],[1,4,0,x*y^2-y^3],
  [1,8,-x^3*y^3,1],[2,5,y^2,-x^3*y],[2,7,-x^2*y^2,x*y],[3,4,-x*y^2,x^2*y],
  [3,5,-x*y+y^2,0],[3,6,x*y^2-y^3,0],[3,9,x^3,-y^3],[4,6,x^2*y-x^3,0],
  [4,7,-x^2*y^2,x*y],[4,9,-x^2*y+x^3,0],[5,6,x^3*y,-y^2],[5,7,0,x-y],
  [5,9,x^2*y^2-x^3*y,0],[6,7,0,-2*x*y+x^2+y^2],[6,8,0,1],[6,9,0,x*y^2-y^3],
  [7,9,2*x*y-y^2,0],[8,9,-1,0]]],[x^3,y^3])*x^0*y^0;
   end;

  f29:=function(x,y)return WGraph2Representation(
  [[[1,3],[1,2],[1,3],[1,2],[1,3],[1,2],[3],[2],[2,3],[2,3]],[[1,4,0,
  x*y+x^2+y^2],[1,6,0,x*y+x^2],[1,7,y,0],[1,9,-1,x*y],[1,10,x,0],[2,3,0,
  2*x^2+y^2],[2,5,0,x*y+x^2+y^2],[2,9,0,-x*y-y^2],[2,10,x,-y],[3,4,x,0],[3,6,x,
  -2*y],[3,7,2*x^2,0],[3,8,2*x,0],[3,9,0,-x],[3,10,x*y,-1],[4,5,-y,x],[4,7,x*y,
  -1],[4,8,x+y,0],[4,9,0,-y],[5,6,0,3*y],[5,7,x^2,0],[5,8,x,-y],[5,9,0,2*x],[5,
  10,0,2],[6,7,x*y,0],[6,8,x-y,0],[6,9,-x,y],[6,10,x*y+x^2,0],[7,8,1,-x*y],[7,9,
  0,y^2],[8,9,0,-x+2*y],[8,10,0,-1]]],[x,y])*x^0*y^0;
  end;

  f31:=function(r,p,j)return 
  [[[0,1,0,0,0,0,0,0,0,0,0,0,0,0,0],[-p*r,p+r,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,
p+r,0,0,0,j*p*r,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0],[0,0,0,0,
p,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,r/p,0,0,0,0,0,0],[0,0,-j^2,0,0,0,0,
0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,p,0,0,0,0,0,0,0],[0,0,0,0,0,-p^2,0,0,p+r,0,0,
0,0,0,0],[-p*r^3-p^2*r^2-r^4,p*r^2+p^2*r+r^3,p^2*r,-p*r^3-p^2*r^2-r^4,
j*p^2*r^2,p*r+p^2+r^2,j*p^2*r^2,r^2,(-p*r-p^2-r^2)/p,r,0,
-p*r^2-p^2*r-r^3,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,-r/p,0],[0,0,0,p*r,0,0,0,0,
0,0,0,p+r,0,0,0],[(-j^2-2*j)*p*r^3+(-2*j^2-3*j)*p^2*r^2+p^3*r,
(j^2+2*j)*p*r^2+(2*j^2+3*j)*p^2*r-p^3,-j^2*p*r^2-j^2*r^3,
-j*p*r^3+2*p^2*r^2-j^2*p^3*r,j^2*p*r^3+p^2*r^2+j^2*p^4-r^4,
j*p*r-p^2,-p*r^3-r^4,j*p*r+j*p^2,p-j*r,0,-j^2*p+r,
-j*p*r^2+2*p^2*r-j^2*p^3,r,(-j^2*p+r)/p,0],[0,0,0,0,0,0,0,0,0,0,p^2,
0,0,p+r,0],[p^2*r^3+(-2*j^2-j)*p^3*r^2,-p^2*r^2+(2*j^2+j)*p^3*r,
p*r^3+j^2*p^3*r,p^2*r^3+j^2*p^4*r,p^2*r^3-j^2*p^5-r^5,0,
j*p*r^4+p^3*r^2,p*r^2+j^2*p^3,0,0,p*r+r^2,p^2*r^2+j^2*p^4,0,
(p*r+r^2)/p,r]],[[0,0,0,-r,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,-1,0,0,0,0,0,0,0,
0,0],[0,0,p,0,0,0,0,0,0,0,0,0,0,0,0],[p,0,0,p+r,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,0,-r,0,0,0,0,0,0,0,0],[0,p*r,0,0,0,p+r,0,0,0,0,0,0,0,0,0],[0,0,0,0,p,0,
p+r,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0],[0,0,0,0,0,0,0,0,p+r,0,
0,p^2*r,0,0,0],[0,0,0,0,0,0,0,p*r,0,p+r,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
-r,0,0],[0,0,0,0,0,0,0,0,-1/p,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,p,0,p+r,0,0],
[j^2*p*r^4+j^2*p^2*r^3+j*p^3*r^2-p^4*r,-j^2*p*r^3-j^2*p^2*r^2,
0,j^2*p*r^4+j^2*p^2*r^3+j*p^3*r^2-p^4*r,
j^2*p*r^4-j*p^2*r^3-p^4*r,-j^2*p*r^2-j^2*p^2*r,
j^2*p*r^4-j*p^2*r^3-p^4*r,-j^2*p*r^2-j^2*p^2*r,-j^2*p^2-r^2,
-j^2*p*r-j^2*p^2,-j^2*p*r,-p*r^3-j^2*p^3*r,-j^2*p*r,r,0],
[p^2*r^3-j*p^3*r^2+j^2*p^4*r-r^5,r^4,0,
p^2*r^3-j*p^3*r^2+j^2*p^4*r-r^5,p^2*r^3-j*p^3*r^2+j^2*p^4*r-r^5,
r^3,p^2*r^3-j*p^3*r^2+j^2*p^4*r-r^5,r^3,0,r^2,r^2,0,r^2,0,r]],[[p,0,0,0,
0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0],[-r^2,r,r,p*r,-p^2,0,
j*r^2,1,0,0,0,p,0,0,0],[0,0,0,0,-r,0,0,0,0,0,0,0,0,0,0],[0,0,0,p,p+r,0,0,0,
0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0],[0,0,0,0,0,0,p,0,0,0,0,0,0,0,
0],[0,p*r,0,0,0,0,0,p+r,0,0,0,0,0,0,0],[-p*r^3+p^3*r-r^4,p*r^2+r^3,0,
-j^2*p^2*r^2-r^4,-p*r^3+(j^2+2*j)*p^2*r^2-p^3*r-r^4,r^2,
j*p*r^3+j*p^2*r^2+p^3*r,p*r+r^2,r,r,r,p*r^2+p^2*r,0,0,1],[0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-1],[0,0,0,0,0,p*r,0,0,0,0,p+r,0,0,0,0],[0,0,0,p*r+p^2,p*r+r^2,
0,0,0,0,0,0,p,0,0,0],[p^2*r^2-j*p^3*r+j^2*p^4-r^4,r^3,0,
p^2*r^2-j*p^3*r+j^2*p^4-r^4,p^2*r^2-j*p^3*r+j^2*p^4-r^4,r^2,
p^2*r^2-j*p^3*r+j^2*p^4-r^4,r^2,0,r,r,0,r,0,1],
[-2*p*r^4-p^2*r^3+(-2*j^2-j)*p^3*r^2-r^5,
2*p*r^3+p^2*r^2+j^2*p^3*r+r^4,0,-p*r^4+p^2*r^3+p^3*r^2+j^2*p^4*r-r^5,
-p*r^4+j*p^2*r^3+(j^2+2*j)*p^3*r^2-p^4*r-j^2*p^5-r^5,p*r^2+r^3,
j*p*r^4+j*p^2*r^3+p^3*r^2,2*p*r^2+p^2*r+j^2*p^3+r^3,0,r^2,p*r+r^2,
(-j^2-2*j)*p^2*r^2+p^3*r+j^2*p^4,0,r,r],
[0,0,0,0,0,0,0,0,0,p*r,0,0,0,0,p+r]]]*p^0*r^0;
   end;

  rep:=[[f1,r],[f1,p],
    [f3,p,r,E(3)^2,ER(5)],[f3,r,p,E(3)^2,ER(5)],[f3,p,r,E(3)^2,-ER(5)],
    [f3,r,p,E(3)^2,-ER(5)],[f3,p,r,E(3),ER(5)],[f3,r,p,E(3),ER(5)],
    [f3,p,r,E(3),-ER(5)],[f3,r,p,E(3),-ER(5)],
    [f11,p,r],[f12,p,r],[f12,r,p],[f11,r,p],
    [f15,r,p,E(3)],[f15,p,r,E(3)],[f15,r,p,E(3)^2],[f15,p,r,E(3)^2],
    [f19,r,p,ER(5),1],[f19,r,p,ER(5),-1],[f19,r,p,-ER(5),1],[f19,r,p,-ER(5),-1],
    [f23,p,r,1],[f23,r,p,1],[f23,r,p,E(3)^2],
    [f23,p,r,E(3)^2],[f23,r,p,E(3)],[f23,p,r,E(3)],
    [f29,p,r],[f29,r,p],
    [f31,r,p,E(3)],[f31,p,r,E(3)],[f31,r,p,E(3)^2],[f31,p,r,E(3)^2]];
    return ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]})+0*Product(para[1]);
end);

CHEVIE.families.Y6:=rec(name:="Y_6",
  fourierMat:=
  [[  -ER(5),  -ER(5),-2*ER(5),-2*ER(5),-5,-5],
   [  -ER(5),  -ER(5),-2*ER(5),-2*ER(5), 5, 5],
   [-2*ER(5),-2*ER(5),-5+ER(5), 5+ER(5), 0, 0],
   [-2*ER(5),-2*ER(5), 5+ER(5),-5+ER(5), 0, 0],
   [      -5,       5,       0,       0, 5,-5],
   [      -5,       5,       0,       0,-5, 5]]/10,
  eigenvalues:=[1,1,E(5)^3,E(5)^2,-1,1],
  special:=1,cospecial:=1);

CHEVIE.AddData("UnipotentCharacters","G27",function()
  return rec(harishChandra:=[
  rec(relativeType:=rec(series:="ST",indices:=[1..3],rank:=3,ST:=27),
      levi:=[],parameterExponents:=[1,1,1],
      charNumbers:=[1..34], eigenvalue:=1, cuspidalName:=""),
  rec(relativeType:=rec(series:="ST",indices:=[2],rank:=1,p:=6,q:=1),
      levi:=[1,8],
      parameterExponents:=[[ 5/2, 5, 0, 5/2, 0, 5 ]],
      charNumbers:=[ 56, 37, 79, 55, 77, 39 ],eigenvalue:=E(5)^2,
      cuspidalName:="I_2(5)[1,3]"),
  rec(relativeType:=rec(series:="ST",indices:=[2],rank:=1,p:=6,q:=1),
      levi:=[1,8],
      parameterExponents:=[[ 5/2, 5, 0, 5/2, 0, 5 ]],
      charNumbers:=[ 58, 38, 80, 57, 78, 40 ],eigenvalue:=E(5)^3,
      cuspidalName:="I_2(5)[1,2]"),
  rec(relativeType:=rec(series:="ST",indices:=[1],rank:=1,p:=6,q:=1),
      levi:=[2,3],
      parameterExponents:=[[ 4, 5, 0, 1, 0, 5 ]],
      charNumbers:=[ 47, 35, 76, 74, 75, 36 ],eigenvalue:=-1,
      cuspidalName:="B_2"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[65],eigenvalue:=E(4),cuspidalName:="G_{27}[i]",qEigen:=1/2),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[63],eigenvalue:=E(4),
      cuspidalName:="G_{27}^2[i]",qEigen:=1/2),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[64],eigenvalue:=-E(4),
      cuspidalName:="G_{27}[-i]",qEigen:=1/2),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[66],eigenvalue:=-E(4),
      cuspidalName:="G_{27}^2[-i]",qEigen:=1/2),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[83],eigenvalue:=E(3),cuspidalName:="G_{27}[\\zeta_3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[84],eigenvalue:=E(3),
      cuspidalName:="G_{27}^2[\\zeta_3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[85],eigenvalue:=E(3),
      cuspidalName:="G_{27}^3[\\zeta_3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[54],eigenvalue:=E(3),
      cuspidalName:="G_{27}^4[\\zeta_3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[67],eigenvalue:=E(3)^2,
      cuspidalName:="G_{27}[\\zeta_3^2]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[43],eigenvalue:=E(3)^2,
      cuspidalName:="G_{27}^2[\\zeta_3^2]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[44],eigenvalue:=E(3)^2,
      cuspidalName:="G_{27}^3[\\zeta_3^2]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[45],eigenvalue:=E(3)^2,
      cuspidalName:="G_{27}^4[\\zeta_3^2]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[86],eigenvalue:=-E(3),
      cuspidalName:="G_{27}[-\\zeta_3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[46],eigenvalue:=-E(3)^2,
      cuspidalName:="G_{27}^2[-\\zeta_3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[51],eigenvalue:=E(9),
      cuspidalName:="G_{27}[\\zeta_9]",qEigen:=1/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[53],eigenvalue:=E(9),
      cuspidalName:="G_{27}^2[\\zeta_9]",qEigen:=2/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[72],eigenvalue:=E(9)^2,
      cuspidalName:="G_{27}[\\zeta_9^2]",qEigen:=2/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[68],eigenvalue:=E(9)^2,
      cuspidalName:="G_{27}^2[E9^2]",qEigen:=1/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[50],eigenvalue:=E(9)^4,
      cuspidalName:="G_{27}[\\zeta_9^4]",qEigen:=1/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[49],eigenvalue:=E(9)^4,
      cuspidalName:="G_{27}^2[\\zeta_9^4]",qEigen:=2/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[70],eigenvalue:=E(9)^5,
      cuspidalName:="G_{27}[\\zeta_9^5]",qEigen:=1/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[69],eigenvalue:=E(9)^5,
      cuspidalName:="G_{27}^2[\\zeta_9^5]",qEigen:=2/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[52],eigenvalue:=E(9)^7,
      cuspidalName:="G_{27}[\\zeta_9^7]",qEigen:=2/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[48],eigenvalue:=E(9)^7,
      cuspidalName:="G_{27}^2[\\zeta_9^7]",qEigen:=1/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[73],eigenvalue:=E(9)^8,
      cuspidalName:="G_{27}[\\zeta_9^8]",qEigen:=2/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[71],eigenvalue:=E(9)^8,
      cuspidalName:="G_{27}^2[\\zeta_9^8]",qEigen:=1/3),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[41],eigenvalue:=E(15),
      cuspidalName:="G_{27}[\\zeta_{15}]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[42],eigenvalue:=E(15)^4,
      cuspidalName:="G_{27}[\\zeta_{15}^4]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[81],eigenvalue:=E(15)^11,
      cuspidalName:="G_{27}[\\zeta_{15}^{11}]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[82],eigenvalue:=E(15)^14,
      cuspidalName:="G_{27}[\\zeta_{15}^{14}]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[59],eigenvalue:=E(20)^17,
      cuspidalName:="G_{27}[\\zeta_{20}^{17}]",qEigen:=1/2),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[61],eigenvalue:=E(20)^13,
      cuspidalName:="G_{27}[\\zeta_{20}^{13}]",qEigen:=1/2),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0,qEigen:=1/2),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[60],eigenvalue:=E(20)^7,
      cuspidalName:="G_{27}[\\zeta_{20}^7]",qEigen:=1/2),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..3],parameterExponents:=[],
      charNumbers:=[62],eigenvalue:=E(20)^3,
      cuspidalName:="G_{27}[\\zeta_{20}^3]",qEigen:=1/2)],
  families:=[
    Family("C1",[1]),
 # family recognized JM 5/12/2005
    Family(CHEVIE.families.X(3)*Family("Y6"),
      [5,3,38,37,35,16,9,7,40,39,36,18,44,43,42,41,46,45],
      rec(signs:=[-1,1,1,1,1,1,-1,1,1,1,1,1,1,-1,1,1,1,1])),
    Family("C2",[ 30,11,12,47 ]),
    ComplexConjugate(Family("Z9",[23,49,48,28,53,51,26,52,50],
      rec(special:=7,cospecial:=1))),
    ComplexConjugate(Family(CHEVIE.families.X(3),[33,31,54])),
 # C2 changed to C'\"2 by Gunter 22/9/99
    Family(Family("C'\"2")*Family("C'#2"),
    [19,21,58,56,20,22,57,55,65,63,59,61,66,64,60,62],rec(cospecial:=5)),
    Family(CHEVIE.families.X(3),[34,32,67]),
    Family("Z9",[24,69,68,27,73,71,25,72,70],rec(cospecial:=4,
     signs:=[1,1,-1,1,1,-1,1,1,-1])),
    Family("C2",[29,13,14,74]),
 # family recognized JM 5/12/2005
    Family(ComplexConjugate(CHEVIE.families.X(3)*Family("Y6")),
    [ 6, 4, 77, 78, 75, 15, 10, 8, 79, 80, 76, 17, 84, 83, 81, 82, 86, 85 ],
    rec(signs:=[-1,1, 1, 1, 1, 1, -1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1 ])),
    Family("C1",[2])],
 a:=[0,45,1,16,1,16,1,16,1,16,3,3,12,12,16,1,16,1,6,6,6,6,4,9,9,4,9,4,12,3,5,8,
   5,8,1,1,1,1,1,1,1,1,1,1,1,1,3,4,4,4,4,4,4,5,6,6,6,6,6,6,6,6,6,6,6,6,8,9,9,9,
   9,9,9,12,16,16,16,16,16,16,16,16,16,16,16,16],
 A:=[0,45,29,44,29,44,29,44,29,44,33,33,42,42,44,29,44,29,39,39,39,39,36,41,41,
   36,41,36,42,33,37,40,37,40,29,29,29,29,29,29,29,29,29,29,29,29,33,36,36,36,
   36,36,36,37,39,39,39,39,39,39,39,39,39,39,39,39,40,41,41,41,41,41,41,42,44,
   44,44,44,44,44,44,44,44,44,44,44]);
end);

# If f is the first invariant, the next ones are
# g:=Det(Hessian(f))/81000 and bord(f,g)/388800
# cf Orlik-Terao and Wiman "Ueber eine einfache Gruppe von 360 ebenen
# Collineationen" Math. Ann. 47 (1895) 531--556
CHEVIE.AddData("Invariants","G27",[function(x,y,z) return
-90*x^2*y^2*z^2+180*x^2*y^3*z+30*x^2*y^4-135*x^2*z^4+135*y^2*z^4+90*x^4*y*z-
30*x^4*y^2+45*x^4*z^2+45*y^4*z^2+18*y^5*z+10*x^6-10*y^6-27*z^6;end,
function(x,y,z) return -2430*x^2*y^2*z^8-58320*x^2*y^3*z^7+3240*x^2*y^4*z^6
+5832*x^2*y^5*z^5-13500*x^2*y^6*z^4-17280*x^2*y^7*z^3+1530*x^2*y^8*z^2
-1260*x^2*y^9*z+756*x^2*y^10-4374*x^2*z^10+4374*y^2*z^10-29160*x^4*y*z^7
-3240*x^4*y^2*z^6-3240*x^4*y^3*z^5+20250*x^4*y^4*z^4+30240*x^4*y^5*z^3
-8460*x^4*y^6*z^2+3960*x^4*y^7*z+1410*x^4*y^8+1215*x^4*z^8+1215*y^4*z^8
-5832*y^5*z^7-3240*x^6*y*z^5-13500*x^6*y^2*z^4+900*x^6*y^4*z^2-2520*x^6*y^5*z
+760*x^6*y^6+1080*x^6*z^6-1080*y^6*z^6+648*y^7*z^5-10800*x^8*y*z^3
-3150*x^8*y^2*z^2-900*x^8*y^3*z-2550*x^8*y^4+3375*x^8*z^4+3375*y^8*z^4
-2160*y^9*z^3+900*x^10*y*z-300*x^10*y^2+450*x^10*z^2-486*y^10*z^2-180*y^11*z
-50*x^12-26*y^12+729*z^12;end,
function(x,y,z)return -60584274*x^2*y^2*z^26+7110680580*x^2*y^3*z^25-
972537030*x^2*y^4*z^24+18366600960*x^2*y^5*z^23+7702351560*x^2*y^6*z^22+
3613798800*x^2*y^7*z^21+63867398400*x^2*y^8*z^20+25404060780*x^2*y^9*z^19-
23662312110*x^2*y^10*z^18+33974432640*x^2*y^11*z^17+74567503665*x^2*y^12*z^16-
1602852300*x^2*y^13*z^15-79131761730*x^2*y^14*z^14+23244704460*x^2*y^15*z^13+
33918011685*x^2*y^16*z^12+4784806080*x^2*y^17*z^11+2685939750*x^2*y^18*z^10+
940546080*x^2*y^19*z^9+4795735815*x^2*y^20*z^8-843312060*x^2*y^21*z^7+
537689610*x^2*y^22*z^6-12222900*x^2*y^23*z^5+202639995*x^2*y^24*z^4-
26859060*x^2*y^25*z^3+11022960*x^2*y^26*z^2+863496*x^2*y^27*z+485980*x^2*y^28-
23914845*x^2*z^28+23914845*y^2*z^28+3555340290*x^4*y*z^25+
972537030*x^4*y^2*z^24-10203667200*x^4*y^3*z^23-11553527340*x^4*y^4*z^22-
6324147900*x^4*y^5*z^21+91174608450*x^4*y^6*z^20-79841333880*x^4*y^7*z^19-
130374287100*x^4*y^8*z^18-164209757760*x^4*y^9*z^17+12784633380*x^4*y^10*z^16-
186840221400*x^4*y^11*z^15-136349849070*x^4*y^12*z^14+
178537275900*x^4*y^13*z^13-47897530740*x^4*y^14*z^12+
91340084160*x^4*y^15*z^11+16409911500*x^4*y^16*z^10-17014048380*x^4*y^17*z^9-
14207274450*x^4*y^18*z^8-6976672560*x^4*y^19*z^7-1297518480*x^4*y^20*z^6+
772075800*x^4*y^21*z^5-513320220*x^4*y^22*z^4-303264000*x^4*y^23*z^3+
121971510*x^4*y^24*z^2+3392652*x^4*y^25*z+1049740*x^4*y^26+30292137*x^4*z^26+
30292137*y^4*z^26+711068058*y^5*z^25-10203667200*x^6*y*z^23+
7702351560*x^6*y^2*z^22+215298558900*x^6*y^4*z^20+50808121560*x^6*y^5*z^19+
22208328900*x^6*y^6*z^18+203846595840*x^6*y^7*z^17+13377058875*x^6*y^8*z^16-
364141404900*x^6*y^9*z^15+511501617990*x^6*y^10*z^14+
766953999900*x^6*y^11*z^13-11123417340*x^6*y^12*z^12+
76310262000*x^6*y^13*z^11-122977974600*x^6*y^14*z^10+74494157760*x^6*y^15*z^9-
37971611325*x^6*y^16*z^8-5211188460*x^6*y^17*z^7+40676316750*x^6*y^18*z^6-
4676283900*x^6*y^19*z^5+927121590*x^6*y^20*z^4+718713000*x^6*y^21*z^3+
624848160*x^6*y^22*z^2-37902000*x^6*y^23*z+16601900*x^6*y^24-
324179010*x^6*z^24+324179010*y^6*z^24+2040733440*y^7*z^23+
2258624250*x^8*y*z^21+1805423175*x^8*y^2*z^20+18145757700*x^8*y^3*z^19+
97061793750*x^8*y^4*z^18-50961648960*x^8*y^5*z^17-325540089450*x^8*y^6*z^16-
681614416800*x^8*y^7*z^15+17328257100*x^8*y^8*z^14+127345729500*x^8*y^9*z^13-
97421744790*x^8*y^10*z^12-32091600600*x^8*y^11*z^11+
171333978300*x^8*y^12*z^10-145036931400*x^8*y^13*z^9-6063336000*x^8*y^14*z^8+
56405568240*x^8*y^15*z^7-26667506475*x^8*y^16*z^6+14669703450*x^8*y^17*z^5+
6904294200*x^8*y^18*z^4-2415528000*x^8*y^19*z^3+473133210*x^8*y^20*z^2-
178922700*x^8*y^21*z-561700*x^8*y^22-1925587890*x^8*z^22-1925587890*y^8*z^22+
451724850*y^9*z^21-18145757700*x^10*y*z^19+36987309450*x^10*y^2*z^18-
56624054400*x^10*y^3*z^17+216134922375*x^10*y^4*z^16-
284886099540*x^10*y^5*z^15-539226829350*x^10*y^6*z^14-
561988359900*x^10*y^7*z^13+348456860550*x^10*y^8*z^12-
369114570000*x^10*y^9*z^11-135367042860*x^10*y^10*z^10+
139885574400*x^10*y^11*z^9-40396615650*x^10*y^12*z^8-
27645478200*x^10*y^13*z^7+69410938500*x^10*y^14*z^6-20828602440*x^10*y^15*z^5-
14036532075*x^10*y^16*z^4-3687846300*x^10*y^17*z^3-4739024400*x^10*y^18*z^2+
56859000*x^10*y^19*z-67904660*x^10*y^20+6935895540*x^10*z^20-
5476499505*y^10*z^20+3629151540*y^11*z^19+28312027200*x^12*y*z^17+
6784074000*x^12*y^2*z^16-18012569400*x^12*y^3*z^15+150212454750*x^12*y^4*z^14-
436654889100*x^12*y^5*z^13-308375820900*x^12*y^6*z^12+
67111740000*x^12*y^7*z^11-48098059200*x^12*y^8*z^10-63423243000*x^12*y^9*z^9-
77330627100*x^12*y^10*z^8-59739638400*x^12*y^11*z^7-
146804427000*x^12*y^12*z^6+24078124800*x^12*y^13*z^5-2059479000*x^12*y^14*z^4-
8104579200*x^12*y^15*z^3+1003240950*x^12*y^16*z^2-208780500*x^12*y^17*z+
244927100*x^12*y^18-421216200*x^12*z^18-1799616690*y^12*z^18+
5662405440*y^13*z^17-9714872700*x^14*y*z^15+75171017250*x^14*y^2*z^14-
101928415500*x^14*y^3*z^13+79496356500*x^14*y^4*z^12+
145124946000*x^14*y^5*z^11+12057125400*x^14*y^6*z^10-1354968000*x^14*y^7*z^9+
196238112750*x^14*y^8*z^8+34147413000*x^14*y^9*z^7+21473437500*x^14*y^10*z^6-
8402988600*x^14*y^11*z^5+16518208500*x^14*y^12*z^4+9946422000*x^14*y^13*z^3+
5621544000*x^14*y^14*z^2+333948000*x^14*y^15*z+368138300*x^14*y^16+
5787622125*x^14*z^16-3895724970*y^14*z^16+1565717040*y^15*z^15+
3145999500*x^16*y*z^13+2069539875*x^16*y^2*z^12+13626832500*x^16*y^3*z^11+
18097850250*x^16*y^4*z^10+21615457500*x^16*y^5*z^9-33570328500*x^16*y^6*z^8+
22659021000*x^16*y^7*z^7+14079369375*x^16*y^8*z^6+2785731750*x^16*y^9*z^5-
12712117500*x^16*y^10*z^4-587628000*x^16*y^11*z^3-742703250*x^16*y^12*z^2+
522877500*x^16*y^13*z-693500*x^16*y^14+2084484375*x^16*z^14-
1589391315*y^16*z^14+1343955240*y^17*z^13+3331530000*x^18*y*z^11-
10817570250*x^18*y^2*z^10-12456180000*x^18*y^3*z^9+6056926875*x^18*y^4*z^8-
8919679500*x^18*y^5*z^7+30806831250*x^18*y^6*z^6+2539309500*x^18*y^7*z^5+
8362423125*x^18*y^8*z^4+2216092500*x^18*y^9*z^3-2958846000*x^18*y^10*z^2-
229605000*x^18*y^11*z+153548500*x^18*y^12+2208232125*x^18*z^12-
1330486965*y^18*z^12-424030140*y^19*z^11+1953112500*x^20*y*z^9+
2267898750*x^20*y^2*z^8-3811050000*x^20*y^3*z^7-3666195000*x^20*y^4*z^6-
2054079000*x^20*y^5*z^5-3189487500*x^20*y^6*z^4+2598480000*x^20*y^7*z^3-
269568750*x^20*y^8*z^2-240157500*x^20*y^9*z+58590500*x^20*y^10+
234130500*x^20*z^10+571718250*y^20*z^10+396522540*y^21*z^9-
40297500*x^22*y*z^7+1609233750*x^22*y^2*z^6+744592500*x^22*y^3*z^5-
524306250*x^22*y^4*z^4-342495000*x^22*y^5*z^3+676740000*x^22*y^6*z^2-
13710000*x^22*y^7*z+49442500*x^22*y^8+217839375*x^22*z^8-36720540*y^22*z^8-
24685560*y^23*z^7-85151250*x^24*y*z^5+112050000*x^24*y^2*z^4+
179268750*x^24*y^4*z^2-3982500*x^24*y^5*z-14607500*x^24*y^6-64985625*x^24*z^6-
93184155*y^24*z^6-17528238*y^25*z^5-13162500*x^26*y*z^3-1950000*x^26*y^2*z^2-
4875000*x^26*y^3*z-3737500*x^26*y^4+6946875*x^26*z^4+1558260*y^26*z^4+
1654560*y^27*z^3-37500*x^28*y*z+12500*x^28*y^2-18750*x^28*z^2+341610*y^28*z^2+
32052*y^29*z+12500*x^30+1708*y^30+14348907*z^30;end]);

# the matrix of basic derivations (a matrix of polynomials in the invariants)
CHEVIE.AddData("BasicDerivations","G27",function()return function(x,y,z)return
[[6*x,12*y^2,30*z+13/3*x^3*y],
[12*y,-24*z,34/3*x*z-227/9*x^2*y^2-26/3*y^3-50/9*x^4*y-5/9*x^6],
[30*z,34/3*x*y*z-227/9*x^2*y^3+26/3*x^3*z-26/3*y^4-50/9*x^4*y^2
-5/9*x^6*y,403/27*x*y^4-55/3*y^2*z-3349/54*x^2*y*z
+5909/324*x^3*y^3-671/54*x^4*z+395/162*x^5*y^2-5/324*x^7*y-5/162*x^9]];
end;end);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","G27",function()return function(x,y,z)return
5832*x*y^2*z^2-1404*x*y^7-5508*x^2*y^4*z+11664*z^3+7776*x^3*y*z^2
-3078*x^3*y^6-198*x^4*y^3*z-1944*y^5*z+648*x^5*z^2-3271*x^5*y^5+954*x^6*y^2*z
-1094*x^7*y^4+198*x^8*y*z-204*x^9*y^3+18*x^10*z-20*x^11*y^2-x^13*y;
end;end);
