#############################################################################
##
#A  tbl/cmp8_15.g               CHEVIE library                    Jean MICHEL
##
#Y  Copyright (C) 1998-2005  The CHEVIE Team
##
##  This file contains  data about the complex reflection groups of type
##  G8 to G15 in the Shephard-Todd classification.
##
## The  data comes  from  the  paper of  G.Malle  ``Degres relatifs  des
## algebres de  Hecke cyclotomiques associees aux  groupes de reflexions
## complexes de dimension 2'',  in ``Finite reductive groups'', Progress
## in mathematics n0 141, Birkhauser 1997,  to which should be added the
## following info:
## -- The subalgebra H' is generated by:
##   G8: T3, T1 T3 T1^-1
##   G9: T1, T3
##  G10: T2, T3
##  G11, T1, T2, T3
##  G12: T1, T2 T1 T2^-1, T2^-1 T1 T2
##  G13: T3^2, T1, T2^-1 T1 T2
##  G14: T1, T2
##  G15: T1, T2, T3^2 
## --   There  is   a  misprint   in   the  relative   degrees  of   the
## 4-dimensional   characters  of   G11:  The   numerator  should   read
## -(x1x2)^9y1^10(y2y3)^5z1^6(z2z3z4)^4t^2  and in  the last  product in
## the denominator i should run in {2,3}.
##
## JM 10/2005: added matrices for the representations of the Hecke algebra.
##
CHEVIE.Revision("tbl/cmp8_15.g",
   "$Id: cmp8_15.g,v 1.5 2003/12/04 11:26:45 chevie Exp $");

# for the braid relations see Bessis-Bonnafe-Rouquier
CHEVIE.AddData("PrintDiagram","G8_15",function(arg)local ST,indices,title,f,s;
  ST:=arg[1];indices:=arg[2];title:=arg[3];
  Print(title," ");s:=String("",Length(title)-1);
  f:=function(arg)return IntListToString(indices{arg});end;
  if ST=8  then Print(f(1),"(4)--",f(2),"(4)\n");
  elif ST=9  then Print(f(1),"--6--",f(2),"(4)\n");
  elif ST=10 then Print(f(1),"(3)==",f(2),"(4)\n");
  elif ST=11 then Print(f(2),"(3)\n",s," /3\\\n",s,
     f(1),"---",f(3),"(4) ",f(1,2,3),"=",f(2,3,1),"=",f(3,1,2),"\n");
  elif ST=12 then Print(f(2),"\n",s," /4\\\n",s,
     f(1),"---",f(3)," ",f(1,2,3,1),"=",f(2,3,1,2),"=",f(3,1,2,3),"\n");
  elif ST=13 then Print(f(1),"\n",s," / \\\n",s,f(3),"---",f(2)," ",
    f(2,3,1,2),"=",f(3,1,2,3)," ",f(1,2,3,1,2),"=",f(3,1,2,3,1),"\n");
  elif ST=14 then Print(f(1),"--8--",f(2),"(3)\n");
  elif ST=15 then Print(f(1),"\n",s," /5\n",s,f(3),"\n",s," \\\n",s,"  ",
    f(2),"(3) ",f(1,2,3),"=",f(3,1,2)," ",f(2,3,1,2,1),"=",f(3,1,2,1,2),"\n");
  fi;
end);

CHEVIE.AddData("BraidRelations","G8_15",function(ST)
  if ST=8 then return [[[1,2,1],[2,1,2]]];
  elif ST=9 then return [[[1,2,1,2,1,2],[2,1,2,1,2,1]]];
  elif ST=10 then return [[[1,2,1,2],[2,1,2,1]]];
  elif ST=11 then return [[[1,2,3],[2,3,1]],[[1,2,3],[3,1,2]]];
  elif ST=12 then return [[[1,2,3,1],[2,3,1,2]],[[1,2,3,1],[3,1,2,3]]];
  elif ST=13 then return [[[3,1,2,3],[2,3,1,2]],[[1,2,3,1,2],[3,1,2,3,1]]];
  elif ST=14 then return [[[1,2,1,2,1,2,1,2],[2,1,2,1,2,1,2,1]]];
  elif ST=15 then return [[[3,1,2],[1,2,3]],[[2,3,1,2,1],[3,1,2,1,2]]];
  fi;
end);

CHEVIE.AddData("ReflectionName","G8_15",function(arg)local n,option;
  option:=arg[Length(arg)];n:=arg[1];
  if IsBound(option.TeX) then n:=SPrint("G_{",n,"}");else n:=SPrint("G",n);fi;
  if Length(arg)=3 then PrintToString(n,"(",Format(arg[2],option),")");fi;
  return n;end);

CHEVIE.AddData("Size","G8_15", function(n) local s;
  s := [ 96, 192, 288, 576, 48, 96, 144, 288 ];
  return s[n-7]; end);

CHEVIE.AddData("NrConjugacyClasses","G8_15", function(n) local l;
  l:=[16,32,48,96,8,16,24,48]; return l[n-7];
  end);

CHEVIE.AddData("paramclasses","G8_15",Concatenation(
      List([[1,24],[2,12],[3,24],[4,24],[5,12]],
	i->List([1..i[2]]-1,j->[i[1],j]))));

CHEVIE.AddData("paramchars","G8_15",
      Concatenation(Cartesian([1],[1..2],[1..3],[1..4]),
                    Cartesian([2],[1..2],[1..3],[1..6]),
                    Cartesian([3],[1..3],[1..2],[1..4]),
                    Cartesian([4],[1..4],[1..3])));

CHEVIE.AddData("GeneratingRoots","G8_15",function(n)local l;
  l:=[[[0,E(4)],[(E(4)+1)/2,(E(4)+1)/2]],
      [[(2-ER(2))/2,-1],[0,-E(4)+1]],
      [[0,(3-ER(-3))/2],[-1+ER(3),1]],
      [[(3+ER(6))/3,ER(6)*E(3)/6],[0,ER(-2)/2],
      [(3-ER(3))*(-E(4)+1)/6,-ER(-3)*(E(4)+1)/6]],
      [[ER(-2),-1-ER(-2)],[-ER(-2),-1+ER(-2)],[0,2]],
      [[0,1],[2-ER(2),ER(2)]/2,[1-ER(2),-E(4)]/(E(4)-1)],
      [[0,2],[-2*E(3)^2-1-ER(-2),-1]],
      [[E(24)^22-E(24)^19+2*E(24)^17+E(24)^16-E(24)^14+E(24)^8+E(24),
       -E(24)^16+E(24)^11-E(24)^8],[0,(3-ER(-3))/2],[-1+ER(3),1]]];
#     [[(3+ER(6))*(E(4)+1)/3,(-E(24)^17-2*E(24))/3],[0,E(12)^11],
#       [(3-ER(3))/3,ER(3)/3]]];
  return l[n-7];
end);

CHEVIE.AddData("GeneratingCoRoots","G8_15",function(n)local l;
  l:=[[[0,-E(4)-1],[-E(4),-E(4)]],
      [[1,(-2-ER(2))/2],[0,1]],
      [[0,1],[-ER(-3)*(E(4)+1)/6,(3+ER(3))*(-E(4)+1)/6]],
      [[1,(-2+ER(6))*E(3)^2],[0,ER(6)*E(3)^2],[1,1+ER(3)]],
      [[1/ER(-2),(-1+ER(-2))]/2,[-1/ER(-2),(-1-ER(-2))]/2,[0,1]],
      [[0,2],[1,1+ER(2)],[ER(-2),2+ER(2)]/(E(4)-1)],
      [[0,1],[1,-ER(-2)+1+2*E(3)^2]/2/E(3)],
      [[(-3*E(24)^19-E(24)^17-2*E(24)^16-3*E(24)^14-3*E(24)^11-E(24)^8+E(24))/6,
       (E(24)^17-E(24)^16-2*E(24)^8-E(24))/3],[0,1],[ER(3)/3,(3+ER(3))/3]]];
#     [[(-E(4)+1)/2,E(3)^2*(-2+ER(6))*(-E(4)+1)/2],[0,ER(3)],[1,1+ER(3)]]];
  return l[n-7];
end);

CHEVIE.AddData("CartanMat", "G8_15",function(n)
  return CHEVIE.RawData("GeneratingCoRoots","G8_15")(n)*
  TransposedMat(CHEVIE.RawData("GeneratingRoots","G8_15")(n));
  end);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G8_15",function(n)local l;
  l:=[[1/4,1/4], [1/2,1/4], [1/3,1/4], [1/2,1/3,1/4], [1/2,1/2,1/2],
  [1/2,1/2,1/2], [1/2,1/3], [1/2,1/3,1/2]];
  return l[n-7];
end);

CHEVIE.AddData("ReflectionCoDegrees","G8_15",function(n)local l;
  l:=[[0,4], [0,16], [0,12], [0,24], [0,10], [0,16], [0,18], [0,24]];
  return l[n-7];
end);

CHEVIE.AddData("ReflectionDegrees","G8_15",function(n)local l;
  l:=[[8,12], [8,24], [12,24], [24,24], [6,8], [8,12], [6,24], [12,24]];
  return l[n-7];
end);

CHEVIE.AddData("ParabolicRepresentatives","G8_15",# repr. of conj. classes
  function(n) local l;l:=[[]];
    Append(l,Filtered(CHEVIE.RawData("ClassInfo","G8_15")(n).classtext,
      x->Length(x)=1));
    Add(l,[1..Length(CHEVIE.RawData("GeneratingRoots","G8_15")(n))]);
    return l;
end);

CHEVIE.AddData("PowerMaps","G8_15",function(n)local l,res,i;
  l:=CHEVIE.RawData("ClassInfo","G8_15")(n).indexclasses;
  res:=[,[1,3,5,7,9,11,13,15,17,19,21,23,1,3,5,7,9,11,13,15,
    17,19,21,23,1,3,5,7,9,11,13,15,17,19,21,23,53,55,57,
    59,37,39,41,43,45,47,49,51,53,55,57,59,37,39,41,43,45,
    47,49,51,85,87,89,91,93,95,85,87,89,91,93,95,85,87,89,
    91,93,95,85,87,89,91,93,95,1,3,5,7,9,11,13,15,17,19,
    21,23],
    [1,4,7,10,13,16,19,22,1,4,7,10,13,16,19,22,1,4,7,10,
    13,16,19,22,25,28,31,34,25,28,31,34,25,28,31,34,1,4,
    7,10,13,16,19,22,1,4,7,10,13,16,19,22,1,4,7,10,13,
    16,19,22,79,82,61,64,67,70,73,76,79,82,61,64,67,70,73,
    76,79,82,61,64,67,70,73,76,85,88,91,94,85,88,91,94,85,
    88,91,94],,
    [1,6,11,16,21,2,7,12,17,22,3,8,13,18,23,4,9,14,19,24,
    5,10,15,20,25,30,35,28,33,26,31,36,29,34,27,32,53,58,
    39,44,49,54,59,40,45,50,55,60,41,46,51,56,37,42,47,52,
    57,38,43,48,61,66,71,76,81,62,67,72,77,82,63,68,73,78,
    83,64,69,74,79,84,65,70,75,80,85,90,95,88,93,86,91,96,
    89,94,87,92],,
    [1,8,15,22,5,12,19,2,9,16,23,6,13,20,3,10,17,24,7,14,
    21,4,11,18,25,32,27,34,29,36,31,26,33,28,35,30,37,44,
    51,58,41,48,55,38,45,52,59,42,49,56,39,46,53,60,43,50,
    57,40,47,54,79,62,69,76,83,66,73,80,63,70,77,84,67,74,
    81,64,71,78,61,68,75,82,65,72,85,92,87,94,89,96,91,86,
    93,88,95,90],,,,
    [1,12,23,10,21,8,19,6,17,4,15,2,13,24,11,22,9,20,7,18,
    5,16,3,14,25,36,35,34,33,32,31,30,29,28,27,26,53,40,
    51,38,49,60,47,58,45,56,43,54,41,52,39,50,37,48,59,46,
    57,44,55,42,79,66,77,64,75,62,73,84,71,82,69,80,67,78,
    65,76,63,74,61,72,83,70,81,68,85,96,95,94,93,92,91,90,
    89,88,87,86],,
    [1,14,3,16,5,18,7,20,9,22,11,24,13,2,15,4,17,6,19,8,
    21,10,23,12,25,26,27,28,29,30,31,32,33,34,35,36,37,50,
    39,52,41,54,43,56,45,58,47,60,49,38,51,40,53,42,55,44,
    57,46,59,48,61,74,63,76,65,78,67,80,69,82,71,84,73,62,
    75,64,77,66,79,68,81,70,83,72,85,86,87,88,89,90,91,92,
    93,94,95,96],,,,
    [1,18,11,4,21,14,7,24,17,10,3,20,13,6,23,16,9,2,19,12,
    5,22,15,8,25,30,35,28,33,26,31,36,29,34,27,32,53,46,
    39,56,49,42,59,52,45,38,55,48,41,58,51,44,37,54,47,40,
    57,50,43,60,61,78,71,64,81,74,67,84,77,70,63,80,73,66,
    83,76,69,62,79,72,65,82,75,68,85,90,95,88,93,86,91,96,
    89,94,87,92],,
    [1,20,15,10,5,24,19,14,9,4,23,18,13,8,3,22,17,12,7,2,
    21,16,11,6,25,32,27,34,29,36,31,26,33,28,35,30,37,56,
    51,46,41,60,55,50,45,40,59,54,49,44,39,58,53,48,43,38,
    57,52,47,42,79,74,69,64,83,78,73,68,63,82,77,72,67,62,
    81,76,71,66,61,80,75,70,65,84,85,92,87,94,89,96,91,86,
    93,88,95,90],,,,
    [1,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,
    6,5,4,3,2,25,36,35,34,33,32,31,30,29,28,27,26,53,52,
    51,50,49,48,47,46,45,44,43,42,41,40,39,38,37,60,59,58,
    57,56,55,54,79,78,77,76,75,74,73,72,71,70,69,68,67,66,
    65,64,63,62,61,84,83,82,81,80,85,96,95,94,93,92,91,90,
    89,88,87,86]];
  for i in [1..Length(res)] do
    if IsBound(res[i]) then
      res[i]:=List(res[i]{l},x->Position(l,x));
      if res[i]=[1..Length(l)] or res[i] in SublistUnbnd(res,[1..i-1]) then
         Unbind(res[i]);fi;
    fi;
  od;
  return res;
end);

CHEVIE.AddData("ClassInfo","G8_15",function(n)local res,p,g,m,f,digits;
  p:=CHEVIE.RawData("paramclasses","G8_15");
  res:=rec();
  g:=function(c,a,b)return c[2] mod a=b[c[1]];end;
  f:=function(class,z)local res,i;
    res:=[[],[1],[2],[3],[3,3]];res:=res[class[1]];
    for i in [1..class[2]] do Append(res,z);od;
    return res;
  end;
  if n=8 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],6,[0,3,2,0,0]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[3,1]),[2],[],[1,3,1],[2],[3],[1]));
    m:="121212";
  elif n=9 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],3,[0,0,2,0,0]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[3,1]),[2],[],[3],[2]));
    m:="212121";
  elif n=10 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],2,[0,1,0,0,0]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[2,3]),[1],[],[2],[1],[3],[2]));
    m:="1212";
  elif n=11 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],1,[0,0,0,0,0]));
    res.classtext:=List(p{res.indexclasses},x->f(x,[1,2,3]));
    m:="123";
  elif n=12 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],12,[0,0,8,3,6]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[1,2]),[3],[],[2,1,2,1,2],[2,3]));
    m:="123123123123";
  elif n=13 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],6,[0,0,2,3,0]));
    res.classtext:=List([[],"z","zz","zzz",[2],[2,'z'],[3,1,2],[3,1,2,'z'],
    [3,1,2,'z','z'],[3,1,2,'z','z','z'],[2,3,1,2,1],[2,3,1,2,1,'z'],
    [2,3,1,2,1,'z','z'],[2,3,1,2,1,'z','z','z'],[1],[1,'z']],x->Replace(x,
      "z",[1,2,3,1,2,3,1,2,3]));
  # The above only correct in the group
    m:="123123123";
  elif n=14 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],4,[0,0,0,3,2]));
    res.classtext:=List(p{res.indexclasses},x->Replace(f(x,[1,2]),[3],[]));
    m:="12121212";
  elif n=15 then
    res.indexclasses:=Filtered([1..Length(p)],i->g(p[i],2,[0,0,0,1,0]));
    res.classtext:=List(p{res.indexclasses},
      x->Replace(f(x,[1,2,3]),[3,3],[4],[3,1,2,3],[4,1,2],[4],[3]));
    m:="12312";
  fi;
  digits:="123";
  res.classnames:=List(res.classtext,function(x)local res; 
     res := String(Replace(digits{x},m,"z"));
     if Length(res) = 0 then res := "."; fi; 
     return res; 
  end);
  m:=[1,12,8,6,6];res.classes:=List(p{res.indexclasses},x->m[x[1]]);
  m:=[1,24,12,8,6,24,4,24,3,8,12,24,2,24,12,8,3,24,4,24,6,8,12,24,2,24,12,8,6,
      24,4,24,6,8,12,24,3,24,12,24,6,24,12,24,3,24,12,24,6,24,12,24,3,24,12,24,
      6,24,12,24,4,24,12,8,12,24,4,24,12,8,12,24,4,24,12,8,12,24,4,24,12,8,12,
      24,2,24,12,8,6,24,4,24,6,8,12,24];
  res.orders:=m{res.indexclasses};
  res.classparams:=res.classnames;
  return res;
end);

CHEVIE.AddData("CharInfo","G8_15",function(n)local res;
  res:=rec();
  if n=8 then
    res.charparams:=[[1,0],[1,6],[1,12],[1,18],[2,1],[2,4],
     [2,7,1],[2,7,2],[2,10],[2,13],[3,8],[3,6],[3,4],[3,2],[4,5],[4,3]];
    # The labelling is such that phi{2,7}' is complexconjugate from phi{2,1}
    res.extRefl:=[1,5,2];
    res.indexchars:=Concatenation([21..30],[81..84],[89,86]);
    res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2];
    res.a:=[0,6,6,6,1,1,1,6,6,6,6,2,2,2,3,3];
    res.A:=[0,18,18,18,11,11,11,18,18,18,18,14,14,14,15,15];
  elif n=9 then res.charparams:=
[[1,0],[1,6],[1,12,1],[1,18,1],[1,12,2],[1,18,2],[1,24],[1,30],[2,5],[2,4],[2,
7,1],[2,7,2],[2,10],[2,13],[2,1],[2,14],[2,17],[2,11,1],[2,11,2],[2,8],[3,8,1],
[3,6,1],[3,4],[3,2],[3,12],[3,10],[3,8,2],[3,6,2],[4,9],[4,7],[4,3],[4,5]];
    res.extRefl:=[1,15,6];
    res.indexchars:=Concatenation([1..4],[21..26],[57..59],
      [54,55,35,36,39,40,44],[77..85],[88,93,95]);
  elif n=10 then res.charparams:=
[[1,0],[1,6],[1,12],[1,18],[1,8],[1,14],[1,20],[1,26],[1,16],[1,22],[1,28],[1,
34],[2,9],[2,12],[2,15,1],[2,15,2],[2,18],[2,21],[2,5],[2,8],[2,11,1],[2,11,2],
[2,14],[2,17],[2,1],[2,4],[2,7,1],[2,7,2],[2,10],[2,13],[3,8,2],[3,14],[3,8,1],
[3,2],[3,16],[3,10,2],[3,4],[3,10,1],[3,12,2],[3,6,2],[3,12,1],[3,6,1],[4,9],
[4,11],[4,7],[4,3],[4,5],[4,13]];
    res.extRefl:=[1,25,6];
    res.indexchars:=Concatenation([13..42],[65..72],[77..79],[84..90]);
  elif n=11 then res.charparams:=
[[1,0],[1,6],[1,12,1],[1,18,1],[1,8],[1,14],[1,20,1],[1,26,1],[1,16],[1,22],[1,
28,1],[1,34,1],[1,12,2],[1,18,2],[1,24],[1,30],[1,20,2],[1,26,2],[1,32],[1,38],
[1,28,2],[1,34,2],[1,40],[1,46],[2,9],[2,12],[2,27,1],[2,27,2],[2,18],[2,33],
[2,5],[2,20],[2,11,1],[2,11,2],[2,14],[2,29],[2,1],[2,4],[2,7,1],[2,7,2],[2,
22],[2,25],[2,21,1],[2,24],[2,15,1],[2,15,2],[2,30],[2,21,2],[2,17,1],[2,8],[2,
23,1],[2,23,2],[2,26],[2,17,2],[2,13,1],[2,16],[2,19,1],[2,19,2],[2,10],[2,13,
2],[3,8,1],[3,14,1],[3,20,1],[3,2],[3,20,2],[3,26],[3,8,2],[3,14,2],[3,16,1],
[3,22,1],[3,4],[3,10,1],[3,28],[3,10,2],[3,16,2],[3,22,2],[3,24,1],[3,6,2],[3,
12,1],[3,18,1],[3,12,2],[3,18,2],[3,24,2],[3,6,1],[4,21],[4,23],[4,19],[4,3],
[4,5],[4,25],[4,9],[4,11],[4,7],[4,15],[4,17],[4,13]];
    res.extRefl:=[1,37,18];
    res.indexchars:=[1..96];
  elif n=12 then
    res.charparams:=[[1,0],[1,12],[2,1],[2,4],[2,5],[3,2],[3,6],[4,3]];
    res.extRefl:=[1,3,2];
    res.indexchars:=[1,13,25,26,30,61,65,85];
  elif n=13 then
    res.charparams:=[[1,0],[1,6],[1,12],[1,18],[2,7,1],[2,4],[2,1],[2,5],
       [2,10],[2,7,2],[3,4],[3,2],[3,8],[3,6],[4,3],[4,5]];
    res.extRefl:=[1,7,4];
    res.indexchars:=[1,2,13,14,37,26,27,28,29,30,61,62,65,66,85,86];
  elif n=14 then
    res.charparams:=[[1,0],[1,8],[1,16],[1,12],[1,20],[1,28],[2,15],[2,12],
      [2,9],[2,11],[2,8],[2,5],[2,7],[2,4],[2,1],[3,2],[3,8],[3,4],[3,10],
      [3,6,1],[3,6,2],[4,3],[4,5],[4,7]];
    res.extRefl:=[1,15,5];
# The labelling above is such that the character in a pair with the smallest
# degree of the fakedegree gets a ', the other a ''
    res.indexchars:=Concatenation([1,5,9,13,17,21,25,26],[30..33],[37..39],
      [62,65],[69,73,77,81],[85..87]);
    res.spetsRationality:=[1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,3,3,1,3,1,1,1];
    res.a:=[0,1,1,1,20,20,9,9,9,1,1,1,1,1,1,1,6,1,6,1,6,1,5,5];
    res.A:=[0,23,23,23,28,28,27,27,27,23,23,23,23,23,23,23,26,23,26,23,26,23,
      25,25];
  elif n=15 then res.charparams:=
 [[1,0],[1,6],[1,8],[1,14],[1,16],[1,22],[1,12],[1,18],[1,20],[1,26],[1,28],[1,
34],[2,9],[2,12],[2,15,1],[2,15,2],[2,18],[2,21],[2,5],[2,8],[2,11,2],[2,11,1],
[2,14],[2,17],[2,1],[2,4],[2,7,2],[2,7,1],[2,10],[2,13],[3,8,1],[3,2],[3,8,2],
[3,14],[3,4],[3,10,1],[3,16],[3,10,2],[3,12,1],[3,6,1],[3,12,2],[3,6,2],[4,9],
[4,11],[4,7],[4,3],[4,5],[4,13]];
    res.extRefl:=[1,25,10];
    res.indexchars:=Concatenation([3..6],[9,10],[15..18],[23..42],[61],[64..66],
      [71..74],[79..82],[85..90]);
  fi;
  res.b:=List(res.charparams,x->x[2]);
  return res;
end);

CHEVIE.AddData("factors","G8_15",function(n)local f;f:=
[[[1,0],[1,6],[1,12],[1,18],[1,1,1,5],[1,4,1,8],[1,7,1,11],[1,7,1,11],[1,10,1,
14],[1,13,1,17],[1,8,1,12,1,16],[1,6,1,10,1,14],[1,4,1,8,1,12],[1,2,1,6,1,10],
[1,5,2,9,1,13],[1,3,1,7,1,11,1,15]],[[1,0],[1,6],[1,12],[1,18],[1,12],[1,18],
[1,24],[1,30],[1,5,1,13],[1,4,1,20],[1,7,1,23],[1,7,1,23],[1,10,1,26],[1,13,1,
29],[1,1,1,17],[1,14,1,22],[1,17,1,25],[1,11,1,19],[1,11,1,19],[1,8,1,16],[1,
8,1,16,1,24],[1,6,1,14,1,22],[1,4,1,12,1,20],[1,2,1,10,1,18],[1,12,1,20,1,28],
[1,10,1,18,1,26],[1,8,1,16,1,24],[1,6,1,14,1,22],[2,9,1,17,1,25],[1,7,2,15,1,
23],[1,3,1,11,1,19,1,27],[1,5,1,13,2,21]],[[1,0],[1,6],[1,12],[1,18],[1,8],[1,
14],[1,20],[1,26],[1,16],[1,22],[1,28],[1,34],[1,9,1,21],[1,12,1,24],[1,15,1,
27],[1,15,1,27],[1,18,1,30],[1,21,1,33],[1,5,1,17],[1,8,1,20],[1,11,1,23],[1,
11,1,23],[1,14,1,26],[1,17,1,29],[1,1,1,13],[1,4,1,16],[1,7,1,19],[1,7,1,19],
[1,10,1,22],[1,13,1,25],[1,8,1,20,1,32],[2,14,1,26],[1,8,2,20],[1,2,1,14,1,
26],[2,16,1,28],[1,10,2,22],[1,4,1,16,1,28],[2,10,1,22],[1,12,2,24],[1,6,1,18,
1,30],[2,12,1,24],[1,6,2,18],[2,9,2,21],[2,11,2,23],[1,7,2,19,1,31],[1,3,2,15,
1,27],[1,5,2,17,1,29],[2,13,2,25]],[[1,0],[1,6],[1,12],[1,18],[1,8],[1,14],[1,
20],[1,26],[1,16],[1,22],[1,28],[1,34],[1,12],[1,18],[1,24],[1,30],[1,20],[1,
26],[1,32],[1,38],[1,28],[1,34],[1,40],[1,46],[1,9,1,33],[1,12,1,36],[2,27],
[2,27],[1,18,1,42],[2,33],[1,5,1,29],[2,20],[1,11,1,35],[1,11,1,35],[1,14,1,
38],[2,29],[1,1,1,25],[1,4,1,28],[1,7,1,31],[1,7,1,31],[2,22],[2,25],[2,21],
[2,24],[1,15,1,39],[1,15,1,39],[2,30],[1,21,1,45],[2,17],[1,8,1,32],[2,23],[2,
23],[2,26],[1,17,1,41],[2,13],[2,16],[2,19],[2,19],[1,10,1,34],[1,13,1,37],[1,
8,2,32],[2,14,1,38],[3,20],[1,2,2,26],[2,20,1,44],[3,26],[1,8,2,32],[2,14,1,
38],[2,16,1,40],[3,22],[1,4,2,28],[2,10,1,34],[3,28],[1,10,2,34],[2,16,1,40],
[3,22],[3,24],[1,6,2,30],[2,12,1,36],[3,18],[1,12,2,36],[2,18,1,42],[3,24],[1,
6,2,30],[4,21],[4,23],[3,19,1,43],[1,3,3,27],[1,5,3,29],[4,25],[2,9,2,33],[2,
11,2,35],[1,7,3,31],[3,15,1,39],[3,17,1,41],[2,13,2,37]],[[1,0],[1,12],[1,1,1,
11],[1,4,1,8],[1,5,1,7],[1,2,1,4,1,6],[1,6,1,8,1,10],[1,3,1,5,1,7,1,9]],[[1,
0],[1,6],[1,12],[1,18],[1,7,1,11],[1,4,1,8],[1,1,1,17],[1,5,1,13],[1,10,1,14],
[1,7,1,11],[1,4,1,8,1,12],[1,2,1,6,1,10],[1,8,1,12,1,16],[1,6,1,10,1,14],[1,3,
1,7,1,11,1,15],[1,5,2,9,1,13]],[[1,0],[1,8],[1,16],[1,12],[1,20],[1,28],[1,15,
1,21],[1,12,1,24],[1,9,1,27],[1,11,1,17],[1,8,1,20],[1,5,1,23],[1,7,1,13],[1,
4,1,16],[1,1,1,19],[1,2,1,14,1,20],[1,8,1,14,1,26],[1,4,1,10,1,22],[1,10,1,16,
1,22],[1,6,1,12,1,18],[1,6,1,18,1,24],[1,3,1,9,1,15,1,21],[1,5,1,11,1,17,1,
23],[1,7,1,13,1,19,1,25]],[[1,0],[1,6],[1,8],[1,14],[1,16],[1,22],[1,12],[1,
18],[1,20],[1,26],[1,28],[1,34],[1,9,1,33],[1,12,1,24],[1,15,1,27],[1,15,1,
27],[1,18,1,30],[2,21],[1,5,1,29],[1,8,1,20],[1,11,1,23],[1,11,1,23],[1,14,1,
26],[2,17],[1,1,1,25],[1,4,1,16],[1,7,1,19],[1,7,1,19],[1,10,1,22],[2,13],[1,
8,2,20],[1,2,1,14,1,26],[1,8,1,20,1,32],[2,14,1,26],[1,4,1,16,1,28],[2,10,1,
22],[2,16,1,28],[1,10,2,22],[2,12,1,24],[1,6,2,18],[1,12,2,24],[1,6,1,18,1,
30],[2,9,2,21],[2,11,2,23],[1,7,2,19,1,31],[1,3,2,15,1,27],[1,5,2,17,1,29],[2,
13,2,25]]];
  return f[n-7];
end);

# The data below was computed by Maria Chlouveraki
CHEVIE.AddData("SchurModels","G8_15",rec(
f1:=rec(
 vcyc:=[[[1,-1,0,0,0,0,0,0,0],1],[[0,0,1,-1,0,0,0,0,0],1],
  [[0,0,1,0,-1,0,0,0,0],1],[[0,0,0,0,0,1,-1,0,0],1],
  [[0,0,0,0,0,1,0,-1,0],1],
  [[0,0,0,0,0,1,0,0,-1],1],[[1,-1,1,-1,0,1,-1,0,0],1],
  [[1,-1,1,-1,0,1,0,-1,0],1],[[1,-1,1,-1,0,1,0,0,-1],1],
  [[1,-1,1,0,-1,1,-1,0,0],1],[[1,-1,1,0,-1,1,0,-1,0],1],
  [[1,-1,1,0,-1,1,0,0,-1],1],[[1,-1,2,-1,-1,2,-1,-1,0],1],
  [[1,-1,2,-1,-1,2,-1,0,-1],1],[[1,-1,2,-1,-1,2,0,-1,-1],1],
  [[2,-2,2,-1,-1,3,-1,-1,-1],1]]),
f2:=rec(coeff:=-2,factor:=[0,0,0,0,0,-1,1,0,0],root:=[1,1,1,1,0,1,1,0,0]/2,
 vcyc:=[[[0,0,1,0,-1,0,0,0,0],1],[[0,0,0,1,-1,0,0,0,0],1],
  [[0,0,0,0,0,1,0,-1,0],1],[[0,0,0,0,0,1,0,0,-1],1],[[0,0,0,0,0,0,1,-1,0],1],
  [[0,0,0,0,0,0,1,0,-1],1],[[0,0,1,0,-1,1,1,-1,-1],1],
  [[0,0,0,1,-1,1,1,-1,-1],1],[[-1,0,0,0,-1,0,0,-1,0,1],1],
  [[-1,0,0,0,-1,0,0,0,-1,1],1],[[0,-1,0,0,-1,0,0,-1,0,1],1],
  [[0,-1,0,0,-1,0,0,0,-1,1],1],[[-1,0,-1,0,0,0,-1,0,0,1],1],
  [[-1,0,0,-1,0,0,-1,0,0,1],1],[[0,-1,-1,0,0,0,-1,0,0,1],1],
   [[0,-1,0,-1,0,0,-1,0,0,1],1]]),
f3:=rec(coeff:=3,root:=[2,1,1,1,1,1,1,1,0]/3,
 vcyc:=[[[-1,1,0,0,0,0,0,0,0],1],[[0,0,0,0,0,0,1,0,-1],1],
   [[0,0,0,0,0,0,0,1,-1],1],[[0,0,0,0,0,1,0,0,-1],1],
   [[0,-1,-1,0,0,0,0,0,-1,1],1],[[0,-1,0,-1,0,0,0,0,-1,1],1],
   [[0,-1,0,0,-1,0,0,0,-1,1],1],[[1,0,1,0,0,1,0,0,0,-1],1],
   [[1,0,1,0,0,0,1,0,0,-1],1],[[1,0,1,0,0,0,0,1,0,-1],1],
   [[1,0,0,1,0,1,0,0,0,-1],1],[[1,0,0,1,0,0,1,0,0,-1],1],
   [[1,0,0,1,0,0,0,1,0,-1],1],[[1,0,0,0,1,1,0,0,0,-1],1],
   [[1,0,0,0,1,0,1,0,0,-1],1],[[1,0,0,0,1,0,0,1,0,-1],1]]),
f4:=rec(coeff:=-4,root:=[2,2,2,1,1,1,1,1,1]/4,
 vcyc:=[[[0,0,1,-1,0,0,0,0,0],1],[[0,0,1,0,-1,0,0,0,0],1],
   [[-1,0,-1,0,0,-1,0,0,0,1],1],[[0,-1,-1,0,0,-1,0,0,0,1],1],
   [[1,0,1,0,0,0,1,0,0,-1],1],[[1,0,1,0,0,0,0,1,0,-1],1],
   [[1,0,1,0,0,0,0,0,1,-1],1],[[0,1,1,0,0,0,1,0,0,-1],1],
   [[0,1,1,0,0,0,0,1,0,-1],1],[[0,1,1,0,0,0,0,0,1,-1],1],
   [[1,1,1,1,0,1,1,0,0,-2],1],[[1,1,1,1,0,1,0,1,0,-2],1],
   [[1,1,1,1,0,1,0,0,1,-2],1],[[1,1,1,0,1,1,1,0,0,-2],1],
   [[1,1,1,0,1,1,0,1,0,-2],1],[[1,1,1,0,1,1,0,0,1,-2],1]])));

CHEVIE.AddData("SchurData","G8_15",function(arg)
  return List(CHEVIE.RawData("paramchars","G8_15"),function(char)
  if char[1]=1 then return rec(name:="f1",
    order:=Concatenation([char[2],3-char[2],2+char[3]],
    2+Difference([1..3],[char[3]]),
    [5+char[4]],5+Difference([1..4],[char[4]])));
  elif char[1]=2 then return rec(name:="f2",
    order:=Concatenation([1,2],2+Difference([1..3],[char[3]]),[2+char[3]],
    5+Combinations([1..4],2)[char[4]],
    5+Difference([1..4],Combinations([1..4],2)[char[4]])),
    rootPower:=(-1)^char[2]);
  elif char[1]=3 then return rec(name:="f3",
    order:=Concatenation([char[3],3-char[3],3,4,5],
    5+Difference([1..4],[char[4]]),[5+char[4]]),
    rootPower:=E(3)^char[2]);
  elif char[1]=4 then return rec(name:="f4",
    order:=Concatenation([1,2,2+char[3]],
    2+Difference([1..3],[char[3]]),[6..9]),
    rootPower:=E(4)^char[2]);
  fi;
  end);
end);

CHEVIE.AddData("Generic","G8_15",11);

CHEVIE.AddData("GetParams","G8_15",function(n,para)local f;
  f:=function(p)p:=List(p,GetRoot);return Concatenation(p,-p);end;
  if   n=8  then return [[1,-1],[1,E(3),E(3)^2],para[1]];
  elif n=9  then return [para[1],[1,E(3),E(3)^2],para[2]];
  elif n=10 then return [[1,-1],para[1],para[2]];
  elif n=11 then return para;
  elif n=12 then return [para[1],[1,E(3),E(3)^2],[1,E(4),-1,E(4)^3]];
  elif n=13 then return [para[2],[1,E(3),E(3)^2],f(para[1])];
  elif n=14 then return [para[1],para[2],[1,E(4),-1,E(4)^3]];
  elif n=15 then return [para[1],para[2],f(para[3])]; 
  fi;
end);

CHEVIE.AddData("HeckeCharTable","G8_15",function(n,para,root)
  local X,Y,Z,c24,c23,res,GenericRow,classes,ci,ic,c,p;
  X:=CHEVIE.RawData("GetParams","G8_15")(n,para);Z:=X[3];Y:=X[2];X:=X[1];
  c:=0*Product(para,Product);
  c24:=Combinations([1..4],2); c23:=[[2,3],[1,3],[1,2]];
  GenericRow:=function(char)local l;
    if char[1]=1 then
      l:=[1,X[char[2]],Y[char[3]],Z[char[4]],Z[char[4]]^2];
      return List(classes,class->l[class[1]]*Product(l{[2..4]})^class[2])+c;
    fi;
    if char[1]=2 then l:=[[2],X,Y{c23[char[3]]},Z{c24[char[4]]}];
    elif char[1]=3 then 
      l:=[[3],X{[1,2,char[3]]},Y,Z{Difference([1..4],[char[4]])}];
    elif char[1]=4 then l:=[[4],X{[1,2,1,2]},Y{[1,2,3,char[3]]},Z];
    fi;
#     Print("char=",Position(CHEVIE.RawData("paramchars","G8_15"),char),"\n");
    Add(l,List(l[4],x->x^2));     
    return G4_22Helper(List(classes,class->Sum(l[class[1]])),
      List(classes,c->c[2]),Product(l{[2..4]},Product),char[1],char[2])+c;
  end;
  res:=rec(name:=SPrint("H(G",n,")"),ST:=n,
    parameter:=para,
    degrees:=CHEVIE.RawData("ReflectionDegrees","G8_15")(n),
    dim:=2,
    reflclasses:=[3],
    powermap:=CHEVIE.RawData("PowerMaps","G8_15")(n));
  Inherit(res,CHEVIE.RawData("ClassInfo","G8_15")(n));
  classes:=CHEVIE.RawData("paramclasses","G8_15"){res.indexclasses};
  res.size:=Product(res.degrees); res.order:=res.size;
  res.identifier:=res.name;
  res.centralizers:=List(res.classes,x->res.size/x);
  ci:=CHEVIE.RawData("CharInfo","G8_15")(n);
  res.irredinfo:=List(ci.charparams,x->
      rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G8_15")(n,x,rec())));
  res.indexchars:=G4_22Test(res,
     List(CHEVIE.RawData("paramchars","G8_15"),GenericRow),ci.indexchars);
  return CHEVIE.compat.MakeCharacterTable(res);
end);

CHEVIE.AddData("CharTable","G8_15",function(n)local para;
  para:=CHEVIE.RawData("EigenvaluesGeneratingReflections","G8_15")(n);
  para:=List(para,x->List([0..1/x-1],j->E(1/x)^j));
  return CHEVIE.RawData("HeckeCharTable","G8_15")(n,para,[]);
end);

CHEVIE.AddData("Rep4","G8_15",function(X,Y,Z,root)local r,r2,x1,x2,y1,y2,y3,a,b;
  x1:=X[1];x2:=X[2];y1:=Y[3];y2:=Y[1];y3:=Y[2];
  r:=GetRoot((x1*x2*y1)^2*y2*y3*Product(Z),4)*E(4)^root;
# r2:=GetRoot((x1*x2*y1)^2*y2*y3*Product(Z),2)*(-1)^root;
  r2:=r^2;
  a:=y2*x1*x2*y1*Product(Z)*Sum(Z,x->1/x)-r2*Sum(Z);
  b:=x1*x2*y1*Product(Z)*(y3+y2)-r2*Sum(Combinations(Z,2),Product);
  return [[[x1, 0,x1*a-x1*x2*y1*b/r,x1*(1+y1/y3)-r*Sum(Z,x->1/x)/y3],
	   [0, x1, 1/y1+1/y2, -x2/r^3],[ 0, 0, x2, 0],[ 0, 0, 0, x2]],
	  [[y3+y1,x1*y1*y2*a,y1*a,y1],[0,y1+y2,1/x1,0],[0,-x1*y1*y2,0,0],
	   [-y3,0,0,0]],
	  [[0,0,0,-r/(y3*x2)],[0,0,-r/(y2*x1*x2*y1),0],[0,r,0,1/r2],
	   [r/(x1*y1),-r*a,b,Sum(Z)]]];
end);

CHEVIE.AddData("HeckeRepresentation","G8_15",function(n,para,root,i)
  local X,Y,Z,rep,m,ci;
  X:=CHEVIE.RawData("GetParams","G8_15")(n,para);Z:=X[3];Y:=X[2];X:=X[1];
  rep:=function(char)
    if char[1]=1 then return [[[X[char[2]]]],[[Y[char[3]]]],[[Z[char[4]]]]];
    elif char[1]=2 then
      return CHEVIE.RawData("Rep2","G4_7")(X,Y{Difference([1..3],[char[3]])},
        Z{Combinations([1..4],2)[char[4]]},char[2]);
    elif char[1]=3 then
      return CHEVIE.RawData("Rep3","G4_7")
       (X{[char[3],3-char[3]]},Y,Z{Difference([1..4],[char[4]])},char[2]);
    else return CHEVIE.RawData("Rep4","G8_15")(X,
       Y{Concatenation(Difference([1..3],[char[3]]),[char[3]])},Z,char[2]);
    fi;
  end;
  ci:=G4_22FetchIndexChars(n,para)[i];
  m:=rep(CHEVIE.RawData("paramchars","G8_15")[ci])+0*Product(para,Product);
  if n=8 then return [m[3],m[1]*m[3]*m[1]^-1];
  elif n=9 then return m{[1,3]};
  elif n=10 then return m{[2,3]};
  elif n=11 then return m;
  elif n=12 then return [m[1],m[2]*m[1]*m[2]^-1,m[1]^m[2]];
  elif n=13 then return [m[3]^2,m[1],m[1]^m[2]];
  elif n=14 then return m{[1,2]};
  elif n=15 then return [m[1],m[2],m[3]^2];
  fi;
end);

CHEVIE.families.G14:=rec(fourierMat:=ER(-3)/24*
[[4,-4,4,-4,-4,-4,-4,-4,0,0,-4,-4,4,4,0,0,0,0],[-4,4,4,-4,4,4,4,4,0,0,-4,-4,4,
4,0,0,0,0],[4,4,4,4,-4,-4,4,4,0,0,-4,-4,-4,-4,0,0,0,0],[-4,-4,4,4,4,4,-4,-4,0,
0,-4,-4,-4,-4,0,0,0,0],[-4,4,-4,4,4*E(3)^2,4*E(3),4*E(3)^2,4*E(3),0,0,-2,-2,2,
2,2*ER(-3),-2*ER(-3),2*ER(-3),-2*ER(-3)],[-4,4,-4,4,4*E(3),4*E(3)^2,4*E(3),
4*E(3)^2,0,0,-2,-2,2,2,-2*ER(-3),2*ER(-3),-2*ER(-3),2*ER(-3)],[-4,4,4,-4,
4*E(3)^2,4*E(3),4*E(3)^2,4*E(3),0,0,2,2,-2,-2,-2*ER(-3),2*ER(-3),-2*ER(-3),
2*ER(-3)],[-4,4,4,-4,4*E(3),4*E(3)^2,4*E(3),4*E(3)^2,0,0,2,2,-2,-2,2*ER(-3),
-2*ER(-3),2*ER(-3),-2*ER(-3)],[0,0,0,0,0,0,0,0,0,0,2*ER(6),-2*ER(6),-2*ER(6),
2*ER(6),2*ER(6),-2*ER(6),-2*ER(6),2*ER(6)],[0,0,0,0,0,0,0,0,0,0,2*ER(6),
-2*ER(6),-2*ER(6),2*ER(6),-2*ER(6),2*ER(6),2*ER(6),-2*ER(6)],[-4,-4,-4,-4,-2,
-2,2,2,2*ER(6),2*ER(6),-2+ER(6),-2-ER(6),-2+ER(6),-2-ER(6),ER(6),ER(6),ER(6),
ER(6)],[-4,-4,-4,-4,-2,-2,2,2,-2*ER(6),-2*ER(6),-2-ER(6),-2+ER(6),-2-ER(6),
-2+ER(6),-ER(6),-ER(6),-ER(6),-ER(6)],[4,4,-4,-4,2,2,-2,-2,-2*ER(6),-2*ER(6),
-2+ER(6),-2-ER(6),-2+ER(6),-2-ER(6),ER(6),ER(6),ER(6),ER(6)],[4,4,-4,-4,2,2,
-2,-2,2*ER(6),2*ER(6),-2-ER(6),-2+ER(6),-2-ER(6),-2+ER(6),-ER(6),-ER(6),
-ER(6),-ER(6)],[0,0,0,0,2*ER(-3),-2*ER(-3),-2*ER(-3),2*ER(-3),2*ER(6),
-2*ER(6),ER(6),-ER(6),ER(6),-ER(6),(2+ER(-2))*ER(-3),(2+ER(-2))*ER(-3),
(-2+ER(-2))*ER(-3),(-2+ER(-2))*ER(-3)],[0,0,0,0,-2*ER(-3),2*ER(-3),2*ER(-3),
-2*ER(-3),-2*ER(6),2*ER(6),ER(6),-ER(6),ER(6),-ER(6),(2+ER(-2))*ER(-3),
(2+ER(-2))*ER(-3),(-2+ER(-2))*ER(-3),(-2+ER(-2))*ER(-3)],[0,0,0,0,2*ER(-3),
-2*ER(-3),-2*ER(-3),2*ER(-3),-2*ER(6),2*ER(6),ER(6),-ER(6),ER(6),-ER(6),
(-2+ER(-2))*ER(-3),(-2+ER(-2))*ER(-3),(2+ER(-2))*ER(-3),(2+ER(-2))*ER(-3)],[0,
0,0,0,-2*ER(-3),2*ER(-3),2*ER(-3),-2*ER(-3),2*ER(6),-2*ER(6),ER(6),-ER(6),
ER(6),-ER(6),(-2+ER(-2))*ER(-3),(-2+ER(-2))*ER(-3),(2+ER(-2))*ER(-3),
(2+ER(-2))*ER(-3)]],
eigenvalues:=[E(3)^2,E(3)^2,E(3)^2,-E(3)^2,1,1,1,1,E(8),E(8)^3,1,1,-1,-1,
 E(4),-E(4),-E(4),E(4)],
charLabels:=List([1..18],String),
special:=12,
cospecial:=12,
name:="X_{18}");

CHEVIE.AddData("UnipotentCharacters","G8_15",
function(n)local I,J,cuspidal;I:=E(4);J:=E(3);
  if n=8 then return rec( harishChandra:=[
  rec(relativeType:=rec(series:="ST",indices:=[1..2],rank:=2,ST:=8),
      levi:=[],parameterExponents:=[1,1],
      charNumbers:=[1,2,3,4,5,6,7,8,9,10,14,13,12,11,16,15],
      eigenvalue:=1, cuspidalName:=""),
  rec(relativeType:=rec(series:="ST",indices:=[2],rank:=1,p:=4,q:=1),
      levi:=[1], parameterExponents:=[[3,0,0,2]],
      charNumbers:=[17,27,25,22], eigenvalue:=-1, 
      cuspidalName:=ImprimitiveCuspidalName([[0],[0,1],[0,1],[]])),
  rec(relativeType:=rec(series:="ST",indices:=[2],rank:=1,p:=4,q:=1),
      levi:=[1], parameterExponents:=[[3,0,2,0]],
      charNumbers:=[18,29,21,30], eigenvalue:=-I, 
      cuspidalName:=ImprimitiveCuspidalName([[],[0,1],[0],[0,1]])),
  rec(relativeType:=rec(series:="ST",indices:=[2],rank:=1,p:=4,q:=1),
      levi:=[1], parameterExponents:=[[3,2,0,0]],
      charNumbers:=[19,20,26,28], eigenvalue:=-1, 
      cuspidalName:=ImprimitiveCuspidalName([[0],[],[0,1],[0,1]])),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..2], parameterExponents:=[],
      charNumbers:=[23], eigenvalue:=E(8)^3, qEigen:=1/2, 
      cuspidalName:="G_8[\\zeta_8^3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..2], parameterExponents:=[],
      charNumbers:=[24], eigenvalue:=E(8)^7, qEigen:=1/2, 
      cuspidalName:="G_8[\\zeta_8^7]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..2], parameterExponents:=[],
      charNumbers:=[31], eigenvalue:=1,  cuspidalName:="G_8[1]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..2], parameterExponents:=[],
      charNumbers:=[32], eigenvalue:=I,  cuspidalName:="G_8[i]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..2], parameterExponents:=[],
      charNumbers:=[33], eigenvalue:=I,  cuspidalName:="G_8^2[i]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..2], parameterExponents:=[],
      charNumbers:=[34], eigenvalue:=J,  cuspidalName:="G_8[\\zeta_3]"),
  rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
      levi:=[1..2], parameterExponents:=[],
      charNumbers:=[35], eigenvalue:=J^2,  cuspidalName:="G_8[\\zeta_3^2]")],
    families:=[
      Family("C1",[1]),
      Family(CHEVIE.families.X(4),[5,6,7,17,18,19],rec(signs:=[1,1,1,-1,-1,-1])),
      Family(CHEVIE.families.X(4),[11,12,13,20,21,22],rec(signs:=[1,1,1,-1,-1,-1])),
      Family("Z4",[23,15,24,16],rec(signs:=[-1,1,1,-1])),
      Family(rec( fourierMat:=
	[[-1,-1,3,-3*I,3*I,1,3,-3*I,-3*I,-3,3,3*I,3*I,1,-3*I,-3*I,4,4],
	 [-1,-1,3,3*I,-3*I,1,3,3*I,3*I,-3,3,-3*I,-3*I,1,3*I,3*I,4,4],
	 [3,3,3,-3,-3,3,3,3,-3,3,-3,-3,3,3,-3,3,0,0],
	 [-3*I,3*I,-3,3,3,3,3,3,-3,-3*I,-3*I,3*I,3*I,-3,3*I,3*I,0,0],
	 [3*I,-3*I,-3,3,3,3,3,3,-3,3*I,3*I,-3*I,-3*I,-3,-3*I,-3*I,0,0],
	 [1,1,3,3,3,-1,3,-3,3,-3,3,-3,3,-1,-3,3,-4,-4],
	 [3,3,3,3,3,3,3,-3,3,3,-3,3,-3,3,3,-3,0,0],
	 [-3*I,3*I,3,3,3,-3,-3,3,-3,-3*I,-3*I,-3*I,-3*I,3,-3*I,-3*I,0,0],
	 [-3*I,3*I,-3,-3,-3,3,3,-3,3,-3*I,-3*I,-3*I,-3*I,-3,-3*I,-3*I,0,0],
	 [-3,-3,3,-3*I,3*I,-3,3,-3*I,-3*I,3,-3,-3*I,-3*I,-3,3*I,3*I,0,0],
	 [3,3,-3,-3*I,3*I,3,-3,-3*I,-3*I,-3,3,-3*I,-3*I,3,3*I,3*I,0,0],
	 [3*I,-3*I,-3,3*I,-3*I,-3,3,-3*I,-3*I,-3*I,-3*I,-3,3,3,3,-3,0,0],
	 [3*I,-3*I,3,3*I,-3*I,3,-3,-3*I,-3*I,-3*I,-3*I,3,-3,-3,-3,3,0,0],
	 [1,1,3,-3,-3,-1,3,3,-3,-3,3,3,-3,-1,3,-3,-4,-4],
	 [-3*I,3*I,-3,3*I,-3*I,-3,3,-3*I,-3*I,3*I,3*I,3,-3,3,-3,3,0,0],
	 [-3*I,3*I,3,3*I,-3*I,3,-3,-3*I,-3*I,3*I,3*I,-3,3,-3,3,-3,0,0],
	 [4,4,0,0,0,-4,0,0,0,0,0,0,0,-4,0,0,-4,8],
	 [4,4,0,0,0,-4,0,0,0,0,0,0,0,-4,0,0,8,-4]]/12,
     eigenvalues:=[1,1,1,1,1,1,1,-1,-1,-1,-1,-I,-I,1,I,I,J,J^2],
     comment:="everything to explain", special:=1, cospecial:=2),
     [2,4,3,8,10,9,14,25,26,27,28,29,30,31,32,33,34,35],
     rec(signs:=[1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,-1,1,-1,-1]))],
   a:=[0,6,6,6,1,1,1,6,6,6,2,2,2,6,3,3,1,1,1,2,2,2,3,3,6,6,6,6,6,6,6,6,6,6,6],
   A:=[0,18,18,18,11,11,11,18,18,18,14,14,14,18,15,15,11,11,11,14,14,14,15,15,
       18,18,18,18,18,18,18,18,18,18,18]);
  elif n=14 then 
  cuspidal:=function(arg)local res,n;
    n:="G_{14}";
    if Length(arg)>2 and IsInt(arg[3]) then PrintToString(n,"^",arg[3]);fi;
    PrintToString(n,"[",FormatTeX(arg[2]),"]");
    res:=rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..6], parameterExponents:=[],
        charNumbers:=[arg[1]], eigenvalue:=arg[2], cuspidalName:=n);
    if Length(arg)>2 and not IsInt(arg[Length(arg)]) then
      res.qEigen:=arg[Length(arg)];fi;
    return res;
  end;
  return rec( harishChandra:=[
  rec(relativeType:=rec(series:="ST",indices:=[1..2],rank:=2,ST:=14),
      levi:=[],parameterExponents:=[1,1],charNumbers:=
        [1,2,3,4,5,6,8,7,9,12,11,10,15,14,13,16,20,18,21,17,19,22,23,24],
      eigenvalue:=1, cuspidalName:=""),
  rec(relativeType:=rec(series:="ST",indices:=[1],rank:=1,p:=6,q:=1),
      levi:=[2], parameterExponents:=[[ 3, 4, 4, 0, 4, 4 ]],
      charNumbers:=[ 66, 26, 27, 79, 28, 25 ], eigenvalue:=J^2, 
      cuspidalName:=ImprimitiveCuspidalName([[],[0,1],[0,1]])),
  cuspidal(34,1), cuspidal(35,1,2), cuspidal(29,-1), cuspidal(30,-1,2),
  cuspidal(31,-1,3), cuspidal(32,-1,4), cuspidal(33,-1,5), cuspidal(73,-1,6),
  cuspidal(74,-1,7), cuspidal(40,J), cuspidal(41,J,2), cuspidal(42,J,3),
  cuspidal(43,J,4), cuspidal(50,J,5), cuspidal(51,J,6), cuspidal(36,J^2),
  cuspidal(37,J^2,2), cuspidal(52,-J), cuspidal(53,-J,2), cuspidal(38,-J^2),
  cuspidal(39,-J^2,2), cuspidal(54,-I), cuspidal(55,-I,2), cuspidal(56,I,3),
  cuspidal(57,I,4), cuspidal(58,I), cuspidal(59,I,2), cuspidal(60,-I,3),
  cuspidal(61,-I,4), cuspidal(46,E(8)), cuspidal(47,E(8)^3,2),
  cuspidal(48,E(8)^3), cuspidal(49,E(8),2), cuspidal(69,E(9)^5,1/3),
  cuspidal(70,E(9)^5,2,2/3), cuspidal(71,E(9)^8,1/3), cuspidal(72,E(9)^8,2,2/3),
  cuspidal(67,E(9)^2,1/3), cuspidal(68,E(9)^2,2,2/3), cuspidal(62,E(12)),
  cuspidal(63,E(12)^7,2), cuspidal(64,E(12)^7), cuspidal(65,E(12),2),
  cuspidal(75,E(16)^5,1/2), cuspidal(77,E(16)^13,1/2),
  cuspidal(78,E(16)^15,1/2), cuspidal(76,E(16)^7,1/2),
  cuspidal(44,E(24)^11), cuspidal(45,E(24)^17)],
    families:=[
      Family("C1",[1]),
      Family(ComplexConjugate(CHEVIE.families.X(3))*Family("G14"),
       [26,37,28,39,14,3,34,18,46,48,15,13,30,29,59,60,
	 55,56,25,36,27,38,2,11,16,35,49,47,12,10,32,31,58,61,54,57,4,17,22,33,
	 41,40,43,42,44,45,51,50,53,52,64,65,62,63],
       rec(signs:=[-1,1,-1,1,-1,1,1,1,-1,-1,-1,-1,-1,1,-1,1,-1,1,-1,-1,-1,-1,
   -1,1,-1,-1,-1,-1,1,1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1],
       comment:="everything to explain"
	)),
      Family(CHEVIE.families.X(3),[23,24,66],rec(signs:=[1,1,-1])),
      Family("Z9",[19,70,67,20,72,71,21,68,69],rec(cospecial:=4)),
      Family(rec( fourierMat:=
        OnMatrices(
	[[      1,     1, 2,      1,      1,-ER(-2),-ER(-2),-ER(-2),-ER(-2)],
	 [      1,     1, 2,      1,      1, ER(-2), ER(-2), ER(-2), ER(-2)],
	 [      2,     2, 0,     -2,     -2,      0,      0,      0,      0],
	 [      1,     1,-2,      1,      1,-ER(-2), ER(-2),-ER(-2), ER(-2)],
	 [      1,     1,-2,      1,      1, ER(-2),-ER(-2), ER(-2),-ER(-2)],
	 [-ER(-2),ER(-2), 0,-ER(-2), ER(-2),      0,-2*E(4),      0, 2*E(4)],
	 [-ER(-2),ER(-2), 0, ER(-2),-ER(-2),-2*E(4),      0, 2*E(4),      0],
	 [-ER(-2),ER(-2), 0,-ER(-2), ER(-2),      0, 2*E(4),      0,-2*E(4)],
	 [-ER(-2),ER(-2), 0, ER(-2),-ER(-2), 2*E(4),      0,-2*E(4),0]]/4,
	 (4,5)),
       comment:="everything to explain",
       eigenvalues:=[1,1,1,-1,-1,E(16)^5,E(16)^7,-E(16)^5,-E(16)^7],
       qEigen:=[0,0,0,0,0,1/2,1/2,1/2,1/2],
       special:=2),
           [8,9,7,73,74,75,76,77,78]),
      Family(CHEVIE.families.X(3),[5,6,79],rec(signs:=[1,1,-1]))],
      a:=[0,1,1,1,20,20,9,9,9,1,1,1,1,1,1,1,1,1,6,6,6,1,5,5,1,1,1,1,1,1,1,1,1,
       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,6,6,
       6,6,6,6,9,9,9,9,9,9,20],
      A:=[0,23,23,23,28,28,27,27,27,23,23,23,23,23,23,23,23,23,26,26,26,23,25,
       25,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
       23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,25,26,26,26,26,26,
       26,27,27,27,27,27,27,28]);
  else
   return false;
  fi;
end);

CHEVIE.AddData("Invariants","G8_15",function(n)local i;
  i:=[[function(x1,x2) return 14*x1^4*x2^4+x1^8+x2^8;end,
    function(x1,x2) return -33*x1^4*x2^8-33*x1^8*x2^4+x1^12+x2^12;end],
   [function(x1,x2) return 56*x1^4*x2^4+16*x1^8+x2^8;end,
    function(x1,x2) return x1^4*x2^20-16*x1^8*x2^16+96*x1^12*x2^12
     -256*x1^16*x2^8+256*x1^20*x2^4;end],
   [function(x1,x2) return  x1^12-88*x1^9*x2^3-704*x1^3*x2^9-64*x2^12;end,
    function(x1,x2) return -512*x1^3*x2^21-1344*x1^6*x2^18-984*x1^9*x2^15
    -7*x1^12*x2^12+123*x1^15*x2^9-21*x1^18*x2^6+x1^21*x2^3;end],
   [function(x1,x2) return  x1^24+4048*x1^18*x2^6+20240*x1^15*x2^9+
    122544*x1^12*x2^12-161920*x1^9*x2^15+259072*x1^6*x2^18+4096*x2^24;end,
    function(x1,x2) return x1^21*x2^3-21*x1^18*x2^6+123*x1^15*x2^9
    -7*x1^12*x2^12-984*x1^9*x2^15-1344*x1^6*x2^18-512*x1^3*x2^21;end],
   [function(x1,x2) return x1^6+10*x1^4*x2^2-20*x1^2*x2^4-8*x2^6;end,
     function(x1,x2) return 3*x1^8-56*x1^6*x2^2-56*x1^4*x2^4-224*x1^2*x2^6 
       +48*x2^8;end],
   [function(x1,x2) return  14*x1^4*x2^4+x1^8+x2^8;end,
     function(x1,x2) return x1^2*x2^10-2*x1^6*x2^6+x1^10*x2^2;end],
   [function(x1,x2) return -5*x1^2*x2^4-5*x1^4*x2^2+x1^6+x2^6;end,
    function(x1,x2) return 81*x1^2*x2^22+198*x1^4*x2^20+1309*x1^6*x2^18
     +264*x1^8*x2^16+2706*x1^10*x2^14-9116*x1^12*x2^12+2706*x1^14*x2^10
     +264*x1^16*x2^8+1309*x1^18*x2^6+198*x1^20*x2^4+81*x1^22*x2^2;end],
   [function(x1,x2) return
     x1^12+40*x1^9*x2^3+384*x1^6*x2^6-320*x1^3*x2^9+64*x2^12;end,
    function(x1,x2) return  512*x1^3*x2^21+1344*x1^6*x2^18+984*x1^9*x2^15
     +7*x1^12*x2^12-123*x1^15*x2^9+21*x1^18*x2^6-x1^21*x2^3;end]];
  return i[n-7];
end);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","G8_15",function(n)local d;
  d:=[ function(t1,t2) return -t2^2+t1^3;end,
       function(t1,t2) return t1^3*t2-432*t2^2;end,
       function(t1,t2) return 256*t2^2+t1^2*t2;end,
       function(t1,t2) return 96*t1*t2^2-t1^2*t2+14080*t2^3;end,
       function(t1,t2) return t2^3-27*t1^4;end,
       function(t1,t2) return 108*t2^3-t1^3*t2;end,
       function(t1,t2) return 16*t2^2+27*t1^4*t2;end,
       function(t1,t2) return 256*t1*t2^2+t1^3*t2;end];
  return d[n-7];
end);
