#############################################################################
##
#A  dispatch.g               CHEVIE library                       Jean Michel
##
#Y  Copyright (C) 1992 - 2009  Lehrstuhl D fur Mathematik, RWTH Aachen,
#Y  University of St. Andrews, and  University Paris VII.
##
##   This file contains generic functions defined in the package 'chevie'
##   Jean Michel 7-9-96. Uniformized 4-99
##
##  Note: Inheritance diagram for Chevie reflection groups and cosets:
##
##          PermGroupOps
##              |          HasTypeOps
##          PermRootOps     /    . \   
##              |          /     . SpetsOps
##            ComplexGroupOps    .    |
##                     |         . CoxeterCosetOps
##                     |         .    
##                     |        AbsCoxOps  MatGroupOps
##                     |        /     \     |
##                 CoxeterGroupOps    GenCoxOps
##                                        |
##                                  AffineCoxeterGroupOps
##
##  AbsCox groups which happen to be finite inherit from HasType

Dispatcher:=function(name,a)local obj;
  obj:=a[1];
  if IsRec(obj) and IsBound(obj.operations) and IsBound(obj.operations.(name))
  then return ApplyFunc(obj.operations.(name),a);
  else Error(obj," has no method for ",name);
  fi;
end;
  
AttributeDispatcher:=function(name,fieldname,a)local obj;
  obj:=a[1];
  if not IsRec(obj) then Error(obj," has no method for ",name);fi;
  if not IsBound(obj.(fieldname)) then
    obj.(fieldname):=Dispatcher(name,a);
  fi;
  return obj.(fieldname);
end;

AdjointFundamentalGroup:=function(arg)return
  Dispatcher("AdjointFundamentalGroup",arg);end;

AlphaInvolution:=function(arg)return Dispatcher("AlphaInvolution",arg);end;

AltInvolution:=function(arg)return Dispatcher("AltInvolution",arg);end;

BetaInvolution:=function(arg)return Dispatcher("BetaInvolution",arg);end;

BraidRelations:=function(arg)return Dispatcher("BraidRelations",arg);end;

BrieskornNormalForm:=
  function(arg)return Dispatcher("BrieskornNormalForm",arg);end;

CharName:=function(arg)
  if Length(arg)=2 then Add(arg,rec());fi;
  return Dispatcher("CharName",arg);end;

ClassName:=function(arg)
  if Length(arg)=2 then Add(arg,rec());fi;
  return Dispatcher("ClassName",arg);end;

Coefficient:=function(arg)return Dispatcher("Coefficient",arg);end;

CoxeterElements:=function(arg)return Dispatcher("CoxeterElements",arg);end;

CoxeterLength:=function(arg)return Dispatcher("CoxeterLength",arg);end;

CoxeterWord:=function(arg)return Dispatcher("CoxeterWord",arg);end;

CoxeterWords:=function(arg)return Dispatcher("CoxeterWords",arg);end;

EltWord:=function(arg)return Dispatcher("EltWord",arg);end;

FakeDegrees:=function(arg)return Dispatcher("FakeDegrees",arg);end;

FirstLeftDescending:=
  function(arg)return Dispatcher("FirstLeftDescending",arg);end;

Fourier:=function(arg)return Dispatcher("Fourier",arg);end;

Frobenius:=function(arg)return Dispatcher("Frobenius",arg);end;

GenericOrder:=function(arg)return Dispatcher("GenericOrder",arg);end;

Hecke:=function(arg)return Dispatcher("Hecke",arg);end;

HeckeCharValues:=function(arg)return Dispatcher("HeckeCharValues",arg);end;

HeckeClassPolynomials:=
  function(arg)return Dispatcher("HeckeClassPolynomials",arg);end;

HeckeSubAlgebra:=function(arg)return Dispatcher("HeckeSubAlgebra",arg);end;

HighestPowerGenericDegrees:=
  function(arg)return Dispatcher("HighestPowerGenericDegrees",arg);end;

Invariants:=function(arg)return Dispatcher("Invariants",arg);end;

IsLeftDescending:=function(arg)return Dispatcher("IsLeftDescending",arg);end;

LeftDescentSet:=function(arg)return Dispatcher("LeftDescentSet",arg);end;

LowestPowerGenericDegrees:=
  function(arg)return Dispatcher("LowestPowerGenericDegrees",arg);end;

MatXPerm:=function(arg)return Dispatcher("MatXPerm",arg);end;

NrConjugacyClasses:=function(arg)return Dispatcher("NrConjugacyClasses",arg);end;

ParabolicRepresentatives:=function(arg)return
  Dispatcher("ParabolicRepresentatives",arg);end;

PermMatX:=function(arg)return Dispatcher("PermMatX",arg);end;

ReducedInRightCoset:=
  function(arg)return Dispatcher("ReducedInRightCoset",arg);end;

ReflectionCharValue:=
  function(arg)return Dispatcher("ReflectionCharValue",arg);end;

ReflectionLength:=
  function(arg)return Dispatcher("ReflectionLength",arg);end;

ReflectionSubgroup:=function(arg)return Dispatcher("ReflectionSubgroup",arg);end;

Reflections:=function(arg)return Dispatcher("Reflections",arg);end;

ReflectionEigenvalues:=
  function(arg)return Dispatcher("ReflectionEigenvalues",arg);end;

RelativeGroup:=function(arg)return Dispatcher("RelativeGroup",arg);end;

RelativeCoset:=function(arg)return Dispatcher("RelativeCoset",arg);end;

Representations:=function(arg)return Dispatcher("Representations",arg);end;

SchurElement:=function(arg)return Dispatcher("SchurElement",arg);end;

FactorizedSchurElement:=
  function(arg)return Dispatcher("FactorizedSchurElement",arg);end;

StandardParabolic:=function(arg)return Dispatcher("StandardParabolic",arg);end;

Variables:=function(arg)
  if IsList(arg[1]) then return Union(List(arg[1],Variables));fi;
  return Dispatcher("Variables",arg);end;

TorusOrder:=function(arg)return Dispatcher("TorusOrder",arg);end;

WGraph:=function(arg)return Dispatcher("WGraph",arg);end;

Valuation:=function(arg)
  if IsPolynomial(arg[1]) then return arg[1].valuation;
  else return Dispatcher("Valuation",arg);
  fi;end;

CharNumbers:=function(arg)
  return AttributeDispatcher("CharNumbers","charNumbers",arg);end;

ChevieCharInfo:=function(arg)
  return AttributeDispatcher("ChevieCharInfo","charInfo",arg);end;

ChevieClassInfo:=function(arg)
  return AttributeDispatcher("ChevieClassInfo","classInfo",arg);end;

FieldOfDefinition:=function(arg)
  return AttributeDispatcher("FieldOfDefinition","field",arg);end;

ReflectionDegrees:=function(arg)
  return AttributeDispatcher("ReflectionDegrees","degrees",arg);end;

ReflectionCoDegrees:=function(arg)return 
  AttributeDispatcher("ReflectionCoDegrees","codegrees",arg);end;

KLeftCellRepresentatives:=function(arg)return
  AttributeDispatcher("KLeftCellRepresentatives","cells0",arg);end;

SchurElements:=function(arg)
  return AttributeDispatcher("SchurElements","schurElements",arg);end;

FactorizedSchurElements:=function(arg)return 
  AttributeDispatcher("FactorizedSchurElements","factorizedSchurElements",arg);
end;

ReflectionName:=function(arg)local res;
   if Length(arg)=1 then Add(arg,rec());fi;
   if IsList(arg[1]) then 
     res:=List(arg[1],x->ReflectionName(x,arg[2]));
     if IsBound(arg[2].TeX) then return Join(res,"\\times ");
     else return Join(res,"x");
     fi;
   fi;
   return Dispatcher("ReflectionName",arg);
end;

PositionId:=function(W)local ci;
  if IsCharTable(W) then
    if not IsBound(W.positionId) then
      W.positionId:=Position(W.irreducibles,W.irreducibles[1]*0+1);
    fi;
    return W.positionId;
  elif IsGroup(W) then ci:=ChevieCharInfo(W);
    if not IsBound(ci.positionId) then 
      ci.positionId:=PositionId(CharTable(W));
    fi;
    return ci.positionId;
  else Error(W, " has no method for PositionId");
  fi;
end;

LowestPowerFakeDegrees:=function(W)local ci;
  ci:=ChevieCharInfo(W);
  if not IsBound(ci.b) then ci.b:=PermRootOps.LowestPowerFakeDegrees(W);fi;
  return ci.b;
end;

HighestPowerFakeDegrees:=function(W)local ci;
  ci:=ChevieCharInfo(W);
  if not IsBound(ci.B) then ci.B:=PermRootOps.HighestPowerFakeDegrees(W);fi;
  return ci.B;
end;

CharParams:=function(W)local ci;
  if IsRec(W) and IsBound(W.operations) and IsBound(W.operations.ChevieCharInfo)
  then ci:=ChevieCharInfo(W);
    if not IsBound(ci.charparams) then ci.charparams:=CharParams(CharTable(W));
    fi;
    return ci.charparams;
  elif IsCharTable(W) then
    if IsBound(W.irredinfo) and IsBound(W.irredinfo[1].charparam) then
      W.charparam:=List(W.irredinfo,x->x.charparam);
    else W.charparam:=[1..Length(W.irreducibles)];
    fi;
    return W.charparam;
  elif IsGroup(W) then return CharParams(CharTable(W));
  else Error(W, " has no method for CharParams");
  fi;
end;

CharNames:=function(arg)local W,option,res;
  W:=arg[1];
  if Length(arg)=2 then option:=arg[2];
  else option:=rec();
  fi;
  if option=rec() and IsRec(W) and IsBound(W.charNames) then
    return W.charNames;
  fi;
  if IsRec(W) and IsBound(W.operations) and IsBound(W.operations.CharNames) 
  then res:=W.operations.CharNames(W,option);
    if option=rec() then W.charNames:=res;fi;
    return res;
  elif IsGroup(W) then return CharNames(CharTable(W));
  else Error(W," has no method for CharNames");
  fi;
end;

AlmostCharNames:=function(arg)local W,option,res;
  W:=arg[1];
  if Length(arg)=2 then option:=arg[2];
  else option:=rec();
  fi;
  if IsRec(W) and IsBound(W.operations) and IsBound(W.operations.AlmostCharNames) then
   if not IsBound(option.TeX) and IsBound(W.almostCharNames) then return W.almostCharNames;fi;
   res:=W.operations.AlmostCharNames(W,option);
   if not IsBound(option.TeX) then W.almostCharNames:=res;fi;
   return res;
  else Error(W," has no method for AlmostCharNames");
  fi;
end;

#############################################################################
#F  ReflectionType( <W> )  . type of a Reflection group or Spets
##  
##  returns  a  list  of records (series:=,indices:=,rank:=) 
##  which  describe  irreducible components of W.
##
ReflectionType:=function(C)
  # dispatcher function, if not called with Cartan matrix:
  if IsRec(C) then return AttributeDispatcher("ReflectionType","type",[C]);
  else return FiniteCoxeterTypeFromCartanMat(C);
  fi;
end;
#############################################################################
##
#F  PrintDiagram(<type>) . . . . . . . .Prints diagram for a ReflectionType
#F  PrintDiagram(<W>) . Prints diagram of Coxeter Datum or Hecke algebra, etc...
##  
##  The first form allows  PrintDiagram(ReflectionType(<cartan matrix>));
##
PrintDiagram:=function(W)local t;
  if IsRec(W) then Dispatcher("PrintDiagram",[W]);return;fi;
  for t in W do PrintDiagram(t);od;
end;

Specialization:=function(H1,H2,f)
  if Group(H1)<>Group(H2) then 
    Error("Hecke algebras should be algebras for the same reflection group");fi;
  if ForAny([1..Length(H1.parameter)],i->ForAny([1,2],j->
      f(H1.parameter[i][j])<>H2.parameter[i][j])) then
    Error("f should send parameters of H1 to those of H2");fi;
  return t->t.operations.Specialization(t,H2,f);
end;
