#############################################################################
##
#A  complexr.g  CHEVIE library    Jean Michel, David Bessis and Gunter Malle
##
#A  $Id: complexr.g,v 1.4 1997/04/14 09:08:54 werner Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains preliminary support for complex reflection
##  group in the setting of the chevie package.
##       Jean Michel and David Bessis 20-9-96
##  
#############################################################################
#
# Complex reflection groups are groups G acting on a vector space V,
# and generated by pseudo-reflexions in V. They are represented by
# finding a set of 'roots' in V invariant by G and such that all
# reflections in G are reflections w.r.t. some roots.
#
# They are represented as PermRootGroups with the additional field:
#  .type -- the types of irreducible components
# a component of type is of the form
# ["ST",W.generatingReflections,n]  for G(n)
# and
# ["ST",W.generatingReflections,p,q]  for G(p,q,r)

ComplexGroupOps:=OperationsRecord("ComplexGroupOps",PermRootOps);
Inherit(ComplexGroupOps,HasTypeOps);

ComplexGroupOps.Size:= W->Product(ReflectionDegrees(W));

#############################################################################
#F  ComplexReflectionGroup( <args> )
## This function constructs an irreducible complex reflection group.
#  It has two forms:
#  ComplexReflectionGroup(d,p,n)  the general imprimitive group g(d,p,n)
#  ComplexReflectionGroup(ST) the exceptional roup of Shephard-Todd ST
#
ComplexReflectionGroup:=function(arg)local STnumber,res,p,q,r,type;
  if IsRec(arg[1]) and IsBound(arg[1].complexGroup) then
    return arg[1].complexGroup;
  fi;
  STnumber:=arg[1];
  if Length(arg)=3 then p:=arg[1];q:=arg[2];r:=arg[3];
# construct G(p,q,r) which is defined for p>1, q|p, r>0.
# for r=1 only value of q which makes sense is 1
    if not (r>0 and IsInt(p/q) and (r>1 or q=1)) then 
      Error("(p,q,r) must satisfy: p>1, q|p, r>0, and r=1 => q=1");
    fi;
    if p=2 and q=1 then return CoxeterGroup("B",r);
    elif p=2 and q=2 then return CoxeterGroup("D",r);
    elif p=1 and q=1 then return CoxeterGroup("A",r-1);
    elif r=2 and p=q then return CoxeterGroup("I",2,p);
    else type:=rec(series:="ST",p:=p,q:=q,rank:=r,operations:=ReflTypeOps);
      res:=rec(roots:=ShallowCopy(ReflTypeOps.GeneratingRoots(type)),
	 EigenvaluesGeneratingReflections:=ShallowCopy(
		 ReflTypeOps.EigenvaluesGeneratingReflections(type)));
    fi;
  elif STnumber in [23,28,30,35,36,37] then 
    type:=[["H",3],["F",4],["H",4],["E",6],["E",7],["E",8]];
    return ApplyFunc(CoxeterGroup,type[Position([23,28,30,35,36,37],STnumber)]);
  elif STnumber in Concatenation([4..22],[24..27],[29],[31..34]) then 
    type:=rec(series:="ST",ST:=STnumber, rank:=0, operations:=ReflTypeOps);
                                                          # enough to find data
    if STnumber in Concatenation([4..22],[24,27,33]) then
      res:=rec(roots:=ShallowCopy(ReflTypeOps.GeneratingRoots(type)),
	 simpleCoroots:=ShallowCopy(ReflTypeOps.GeneratingCoRoots(type)));
    else
      res:=rec(roots:=ShallowCopy(ReflTypeOps.GeneratingRoots(type)),
	 EigenvaluesGeneratingReflections:=ShallowCopy(
		 ReflTypeOps.EigenvaluesGeneratingReflections(type)));
    fi;
  else Error("parameter must be in the interval [4..37]\n");
  fi;
  type.rank:=Length(res.roots[1]);
  type.indices:=[1..Length(res.roots)];
  res.type:=[type];
  res:=PermRootGroup(res);
  res.name:=SPrint("ComplexReflectionGroup(",Join(arg),")");
  res.Nhyp:=Sum(ReflectionCoDegrees(type)+1);
  res.N:=Sum(ReflectionDegrees(type)-1);
  res.operations:=ComplexGroupOps;
  return res;
end;

ComplexGroupOps.\*:=function(W1,W2)local res,p,i,t;
  res:=PermRootOps.\*(W1,W2);
  if IsGroup(W2) then
  if IsBound(W1.ReflectionCoDegrees) and IsBound(W2.ReflectionCoDegrees) then
    res.ReflectionCoDegrees:=Concatenation(W1.ReflectionCoDegrees,W2.ReflectionCoDegrees);
  fi;
  if Size(W1)=1 then res.name:=W2.name;
  elif Size(W2)=1 then res.name:=W1.name;
  else res.name:=Concatenation(W1.name,"*",W2.name);
  fi;
  res.operations:=ComplexGroupOps;
  fi;
  return res;
end;

##########################################################################
##
#F  CycHeckeOps --- operations for Hecke algebras of classified groups
##
CycHeckeOps:=OperationsRecord("CycHeckeOps",AbsHeckeOps);

CycHeckeOps.CharTable:=function(H)local W,t,l,tbl;
  W:=Group(H);
  l:=List(ReflectionType(W),
    t->ReflTypeOps.HeckeCharTable(t,H.parameter{t.indices},
               SublistUnbnd(H.rootParameter,t.indices)));
  if ForAny(l,x->x=false) then return false;fi;
  if Length(l)>0 then tbl:=l[1];
    for t in l{[2..Length(l)]} do
      Unbind(tbl.powermap);Unbind(t.powermap); # fix a bug for table of H(FFE)
      tbl:=CharTableDirectProduct(tbl,t); 
      Unbind(tbl.fusionsource); Unbind(tbl.fusions);
    od;
  else tbl:=rec(size:=1,order:=1,centralizers:=[1],orders:=[1],
        identifier:="CoxeterGroup()",
        irreducibles:=[[1]],powermap:=[],operations:=CharTableOps);
  fi;
  tbl.parameter:=H.parameter; tbl.rootParameter:=H.rootParameter;
  if IsBound(W.cartan) then tbl.cartan:=W.cartan;fi;
  tbl.irredinfo:=List(CharParams(W),x->rec(charparam:=x,
                                           charname:=CharName(W,x)));
  Inherit(tbl,ChevieClassInfo(W));
  tbl.classnames:=List(tbl.classnames,n->String(Replace(n,"_","","\\tilde ","~")));
  tbl.operations.StringEntry := function(x)
    if x=0*x then return ".";else return Format(x);fi;end;
  if not IsBound(tbl.name) then tbl.name:=tbl.identifier;fi;
  return tbl;
end;

CycHeckeOps.Representations:=function(arg)local H,l,inds,t,rep;
  H:=arg[1]; 
  if IsBound(H.spets) then t:=ReflectionType(H.spets); 
  else t:=ReflectionType(Group(H)); 
  fi;
  l:=List(t,NrConjugacyClasses);
  if Length(arg)=2 then inds:=arg[2];else inds:=[1..Product(l)];fi;
  rep:=function(i)local ind,reps,tensorat,dims,res;
    ind:=CartesianAt(l,i);
    reps:=List([1..Length(t)],function(i)local h,indices;
      if IsBound(H.spets) then h:=Hecke(H);indices:=t[i].orbit[1].indices;
      else   h:=H;indices:=t[i].indices;
      fi;
      return ReflTypeOps.HeckeRepresentation(t[i],h.parameter{indices},
        SublistUnbnd(h.rootParameter,indices),ind[i]);
    end);
    if ForAny(reps,x->x=false) then return false;fi;
    if IsBound(H.unit) then reps:=reps*H.unit;fi;
    if Length(reps)=1 then return reps[1];fi;
    tensorat:=function(i,m,dims) # id(d1)tensor id(d2)..tensor(m) at i tensor..
      return List([1..Product(dims)],k->List([1..Product(dims)],
      function(l)local r,c;
	r:=CartesianAt(dims,k); c:=CartesianAt(dims,l);
	if ForAny([1..Length(dims)],j->r[j]<>c[j] and j<>i)then return 0*H.unit;
	else return m[r[i]][c[i]];fi;end));
    end;
    dims:=List(reps,x->Length(x[1]));res:=[];
    for i in [1..Length(t)] do
      res{t[i].indices}:=List(reps[i],m->tensorat(i,m,dims));
    od;
    return res;
  end;
  if IsList(inds) then return List(inds,rep);
  else return rep(inds);
  fi;
end;

CycHeckeOps.CharParams:=H->CharParams(Group(H));

############################################################################
##
#F  SchurElement( <H>, <p> )   Schur element of character with .charparam p
##
CycHeckeOps.SchurElement:=function(H,phi)local t;
  if not IsHeckeAlgebra(H) then Error("<H> should be a Hecke algebra");fi;
  t:=Zip(ReflectionType(Group(H)),phi,function(t,phi)
    return  CHEVIE.Data("SchurElement",t,phi,H.parameter{t.indices},
      SublistUnbnd(H.rootParameter,t.indices));
  end);
  if ForAny(t,x->x=false) then return false;else return Product(t);fi;
end;

CycHeckeOps.SchurElements:=H->List(CharParams(Group(H)),p->SchurElement(H,p));

CycHeckeOps.FactorizedSchurElement:=function(H,phi)local t;
  if not IsHeckeAlgebra(H) then Error("<H> should be a Hecke algebra");fi;
  t:=Zip(ReflectionType(Group(H)),phi,function(t,phi)
   return CHEVIE.Data("FactorizedSchurElement",t,phi,H.parameter{t.indices},
     SublistUnbnd(H.rootParameter,t.indices));
  end);
  if ForAny(t,x->x=false) then return false;else return Product(t);fi;
end;

CycHeckeOps.FactorizedSchurElements:=H->List(CharParams(Group(H)),
  p->FactorizedSchurElement(H,p));

# The function below, if a representation is known for hecke algebra H
# gives character values on element w of the Braid monoid, else returns false
CycHeckeOps.HeckeCharValues:=function(H,w)local p,W;
  W:=Group(H);
  p:=Position(ChevieClassInfo(W).classtext,w);
  if p<>false then return List(CharTable(H).irreducibles,x->x[p]);fi;
  if IsCoxeterGroup(W) then return HeckeCharValues(Basis(H,"T")(w));fi;
  return List(Representations(H),function(x)if x=false then return false;
   else return CharRepresentationWords(x,[W.rootRestriction{w}])[1];
   fi;end);
end;

CycHeckeOps.LowestPowerGenericDegrees:=H->List(SchurElements(H),
  function(x)if IsCyc(x) then return 0;else return -Valuation(x);fi;end);

CycHeckeOps.HighestPowerGenericDegrees:=function(H)local s;
  s:=SchurElements(H);return Degree(s[PositionId(Group(H))])-List(s,Degree);
end;

CyclicHeckeOps:=OperationsRecord("CyclicHeckeOps",CycHeckeOps);

# "T" basis for cyclic groups
CreateHeckeBasis("T",rec(T:=x->x,     # method to convert to T

\*:=function(x,y)local H,res,ops,W,temp,i,xi,temp1,j,e,pol,d;
  H:=Hecke(y);
  if not IsRec(x) or not IsBound(x.hecke) or not IsBound(x.elm) then 
  # assume x is a scalar by which to multiply y
    return HeckeElt(H,y.basis,y.elm,y.coeff*(x*H.unit));
  fi;
  if not IsIdentical(H,Hecke(x)) then 
    Error("not elements of the same algebra");
  fi;
  ops:=H.operations;
  pol:=Coefficients(Product(H.parameter[1],u->Mvp("xxx")-u),"xxx");
  d:=Length(pol)-1;
  if x.basis<>y.basis then return Basis(H,"T")(x)*Basis(H,"T")(y);
  elif x.basis="T" then 
    W:=Group(H);
    res:=HeckeElt(H,x.basis,[],[]);
    for i in [1..Length(x.elm)] do
      temp:=x.coeff[i]*y;
      xi:=x.elm[i];
      for i in [1..Length(xi)] do
	temp1:=HeckeElt(H,x.basis,[],[]);
	for j in [1..Length(temp.elm)] do
	  e:=Length(temp.elm[j]);
	  if e+1<d then
	    Add(temp1.elm,List([1..e+1],i->1));Add(temp1.coeff,temp.coeff[j]);
	  else
	    Append(temp1.elm,List([0..d-1],i->[1..i]*0+1));
	    Append(temp1.coeff,-pol{[1..d]}*temp.coeff[j]);
	  fi;
	od;
	temp:=temp1;
	CollectCoefficients(temp);
      od;
      res:=res+temp;
    od;
    return res;
  else return Basis(H,x.basis)(Basis(H,"T")(x)*Basis(H,"T")(y));
  fi;
end,

inverse:=function(h)local H,d,pol;
 if Length(h.elm)<>1 then Error("inverse implemented only for single T_w");fi;
  H:=Hecke(h);
  pol:=Coefficients(Product(H.parameter[1],u->Mvp("xxx")-u),"xxx");
  d:=Length(pol)-1;
  return h.coeff[1]^-1*Basis(H,"T")(List([0..d-1],i->[1..i]*0+1),
	    -pol{[2..d+1]}/pol[1])^Length(h.elm[1]);
end),
CyclicHeckeOps);

ComplexGroupOps.Hecke:=function(arg)local H;
  H:=ApplyFunc(PermRootOps.Hecke,arg);
  if IsCyclic(arg[1]) then H.operations:=CyclicHeckeOps;
  else H.operations:=CycHeckeOps;
  fi;
  return H;
end;

###########################################################################
##
#F HeckeCentralMonomials( <H> ) . . . . . . . . scalars of central element 
## . . . . . . . . . . . . . . . . . . . . .  on irreduciblerepresentations
##
## 'HeckeCentralMonomials'  computes  the  scalars  by  which  the center
## of the pure braid group (the square of the longest element  in the
## Iwahori-Hecke case) acts on  the irreducible representations of the 
## Iwahori-Hecke algebra. Cf. BrMi, 4.16 for the formula used

HeckeCentralMonomials:=function(H)local v,W;
  W:=Group(H);v:=List(HyperplaneOrbits(W),ShallowCopy);
  return List(CharTable(W).irreducibles,irr->Product(v,function(C)local q,m;
    q:=H.parameter[W.rootRestriction[C.s]];
    m:=List([0..C.e_s-1],j->(irr[1]+Sum([1..C.e_s-1],
                   l->irr[C.classno[l]]*E(C.e_s)^(-j*l)))/C.e_s);
    return E(irr[1])^(-C.N_s*m*[0..C.e_s-1])*
           Product([1..C.e_s],j->q[j]^(C.N_s*C.e_s*m[j]/irr[1]));
      end));
end;
