#############################################################################
##
#A  init.g            CHEVIE library / init file of the CHEVIE package.
## Meinolf Geck, Frank Luebeck, Gunter Malle, Jean Michel and G\"otz Pfeiffer.
##
#Y  Copyright (C) 1992 - 2015 Lehrstuhl D f\"ur Mathematik, RWTH Aachen,
#Y  Universitat Kaiserslautern, Germany and University Paris VII,  France.
## 
#  global variables
CHEVIE:=rec(version:="4 development of 29Feb2016",
  homepage:="http://webusers.imj-prg.fr/~jmichel/chevie",
  Cache:=rec(ReflectionSubgroups:=true),
  AUTO:=rec()
);

if not QUIET and BANNER then
  PrintPkgInit("chevie",CHEVIE.version);
# Print("    see ",CHEVIE.homepage,"\n");
  Print(
"    If you use this package in your work please cite the authors as follows:\n",
"(C) [Jean Michel] The development version of the CHEVIE package of GAP3\n",
"     Journal of algebra 435 (2015) 308--336\n",
"(C) [Meinolf Geck, Gerhard Hiss, Frank Luebeck, Gunter Malle, Goetz Pfeiffer]\n",
"     CHEVIE -- a system for computing and processing generic character tables\n",
"     Applicable Algebra in Engineering Comm. and Computing 7 (1996) 175--210\n");
fi;

if not IsBound(CHEVIEPATH) then CHEVIEPATH:=LOADED_PACKAGES.chevie;fi;

ReadChv:= function(name)
  if not ReadPath(CHEVIEPATH, name, ".g", "ReadChv") then
     Error("CHEVIE library file '", name, ".g ' must exist and be readable");
  fi;
end;

#############################################################################
##     AUTO section
##    
AUTO( ReadChv( "lib/classinv" ),
  CentreMultFunction, ClassInvariants, ConjugacyTestFunction,
  CycleStructurePermOrbits, FingerPrintFunction, PointsRepOrb,
  PositionClass, ShortClassListFunction);

AUTO(ReadChv("lib/complex"),
  Complex, ComplexConjugate, ComplexOps, Cyclotomic, IsComplex);

AUTO( ReadChv( "lib/cycpol" ),
  AsRootOfUnity, CycPol, CycPolOps, Valuation);

AUTO(ReadChv("lib/decimal"),
  DecimalOps, Exp, IsDecimal, Log, Pi, Rational, SetDecimalPrecision, evalf);

AUTO( ReadChv( "lib/symbol" ),
  Compositions,
  CycPolFakeDegreeSymbol, CycPolGenericDegreeSymbol, DefectSymbol,
  DifferencePartitions, Dominates, FullSymbol, HighestPowerFakeDegreeSymbol,
  HighestPowerGenericDegreeSymbol, IsReducedSymbol, LessSymbols,
  LowestPowerFakeDegreeSymbol, LowestPowerGenericDegreeSymbol,
  PartBeta, PartitionTupleToString, RankSymbol, ShiftBeta, StringSymbol,
  SymbolPartitionTuple, Symbols, SymbolsDefect, Tableaux, XSP);

AUTO( ReadChv( "lib/util" ),
  AbelianGenerators, ApplyWord, BraidRelation, CartesianAt,
  CharRepresentationWords, CheckRelation, ChevieIndeterminate, CollectBy,
  CollectCoefficients, DecomposeTensor, DetPerm, Dictionary, DifferenceMultiSet,
  EvalWords, EvalPolRoot, FastValue, FOrbit, FOrbits, GetRoot, GetWord,
  InductionTable, InductionTableOps, Inherit, InverseListsMap, Join,
  MinimalWordProperty, PointsAndRepresentativesOrbits, PositionCartesian,
  PositionDet, PositionSublist, Positions, PositionsProperty, Replace, 
  Rotations, SortBy, Split, SublistUnbnd, SymmetricDifference, TwoTree, Zip,
  Dtime, Stime);

AUTO( ReadChv( "lib/po" ),
  Chains, GcdPartitions, Hasse, Incidence, LcmPartitions, LinearExtension, 
  Partition, Poset, PosetOps, ReversedPoset, TransitiveClosure);

AUTO( ReadChv( "lib/matrix" ),
  BigCellDecomposition, BlocksMat, CoFactors, DecomposedMat, DiagonalMat,
  DistHelpedRepresentativeOperation, EigenvaluesMat, ExteriorPower,
  IndependentLines, IsDiagonalMat, IsLowerTriangularMat, IsNormalizing,
  KroneckerMatrix, MatStab, PermMatMat, ProportionalityCoefficient,
  OnMatrices, RepresentativeDiagonalConjugation, SchurFunctor, SymmetricPower);

AUTO( ReadChv( "lib/format" ),
  BracketIfNeeded, Format, FormatCoefficient, FormatCyclotomic, FormatGAP,
  FormatLaTeX, FormatMonomial, FormatPolynomial, FormatQuadratic,
  FormatQuotient, FormatTable, FormatTeX, IntListToString, PrintToString,
  SPrint, TeXStrip);

AUTO( ReadChv( "lib/matint" ),
  BaseIntMat, BaseIntersectionIntMats, ComplementIntMat, DeterminantIntMat,
  NullspaceIntMat, SolutionIntMat, SolutionNullspaceIntMat);

AUTO( ReadChv( "prg/abscox" ),
  AbsCoxOps, Bruhat, BruhatSmaller, CartanMatFromCoxeterMatrix,
  CoxeterHeckeAlgebraOps, CoxeterMatrix, CoxeterMatrixFromCartanMat,
  ForEachElement, IsCoxeterGroup, IsCoxeterWord, LongestCoxeterElement,
  LongestCoxeterWord, PermCosetsSubgroup, ReducedCoxeterWord ,
  ReducedRightCosetRepresentatives, RightDescentSet);

AUTO( ReadChv( "prg/abshecke" ), 
  AbsHeckeOps, CheckHeckeDefiningRelations, HeckeReflectionRepresentation,
  IsHeckeAlgebra); 

AUTO( ReadChv( "prg/affine" ), 
  Affine, AffineCoxeterGroupOps, AffineRootAction);

AUTO(ReadChv("prg/compatib"),
  BraidWords, CartanName, CartanType, CharHeckeRepresentation,
  CoxeterConjugacyClasses, CoxeterElementsLength, CoxeterWordReflections,
  DirectSumCartanMat, DirectSumMat, DoublePartitionToString,
  DoublePartitions, HeckeCharTable, HeckeCharTableDirectProduct,
  HeckeFusion, HeckePowermap, HeckeReducedChar, HeckeScalarProducts, 
  KLCoefficient, LeftCellRepresentation, 
  LongestWeylWord, ParametersCentralizers, PermBraid, PhiFactors,
  PermCoxeterWord, PermRepresentationRoots, PermWeylWord, PositionSgn,
  PrintDynkinDiagram, ReducedInCoxeterCoset, ReducedWeylWord, Rootsystem,
  SimpleLeftDivisors,
  SimpleReflexionMatrices, Weyl, WeylClassPolynomials, WeylConjugacyClasses,
  WeylCosetPermRepresentation, WeylElements, WeylLengthPerm, WeylMueMat,
  WeylReflections, WeylRightCosetRepresentatives, WeylWordPerm, WordBraid);

AUTO( ReadChv( "prg/complexr" ),
  ComplexGroupOps, ComplexReflectionGroup, CycHeckeOps, HeckeCentralMonomials);

AUTO( ReadChv( "prg/coset" ),
  CoxeterCoset, CoxeterCosetOps, CoxeterSubCoset, IsCoxeterCoset,
  TwistedPower, TwistingElements, Twistings);

AUTO( ReadChv( "prg/coxeter" ),
  AddComponentsCoxeterGroup , CartanMat, CoxeterGroup, CoxeterGroupOps,
  ElementWithInversions, ExtendedReflectionGroup,
  FiniteCoxeterTypeFromCartanMat, HighestShortRoot, IsExtendedGroup,
  IsomorphismType, MatYPerm, Inversions, OmegaSubgroup, ParseTypeFromArg,
  PermMatXCoxeterElement, PermMatY, RootsCartan, SimpleRootsSubsystem,
  WordsClassRepresentatives);

AUTO( ReadChv( "prg/dispatch" ),
  AdjointFundamentalGroup, AlmostCharNames, AlphaInvolution, AltInvolution, 
  AttributeDispatcher, BetaInvolution, BraidRelations, BrieskornNormalForm,
  CharName, CharNames, CharNumbers, CharParams, ChevieCharInfo, ChevieClassInfo,
  ClassName, Dispatcher, Coefficient, CoxeterElements, CoxeterLength,
  CoxeterWord, CoxeterWords, EltWord, FakeDegrees, FieldOfDefinition,
  FirstLeftDescending, Fourier, Frobenius, GenericOrder, Hecke, HeckeCharValues,
  HeckeClassPolynomials, HeckeSubAlgebra, HighestPowerFakeDegrees,
  HighestPowerGenericDegrees, Invariants, IsLeftDescending, 
  KLeftCellRepresentatives, LeftDescentSet,
  LowestPowerFakeDegrees, LowestPowerGenericDegrees, MatXPerm,
  NrConjugacyClasses, PermMatX, PositionId, PrintDiagram,
  ParabolicRepresentatives,
  ReducedInRightCoset, ReflectionCharValue, ReflectionCoDegrees,
  ReflectionDegrees, ReflectionEigenvalues, ReflectionLength, ReflectionName,
  ReflectionSubgroup, ReflectionType, Reflections, RelativeCoset,
  RelativeGroup, Representations, SchurElement, SchurElements,
  FactorizedSchurElement, FactorizedSchurElements, Specialization,
  StandardParabolic, TorusOrder, Valuation, Variables);

AUTO( ReadChv( "prg/garside" ), 
  AsFraction, AsWord, BipartiteDecomposition, Braid, BraidMonoid,
  CompleteGarsideRecord, DualBraid, DualBraidMonoid, EltBraid, GarsideAlpha,
  GarsideEltOps, GarsideOmega, GarsideWords, GoodCoxeterWord, 
  LeftDivisorsSimple, LeftGcd, LeftLcm, Presentation, ReversedWord, 
  RightGcd, RightLcm, ShrinkGarsideGeneratingSet);

AUTO(ReadChv("prg/conjbrai"),
  AtomicMaps, CentralizerGenerators, Endomorphisms, MinConjugating,
  CategoryByAtoms, ConjugacyCategory, ConjugacySet, PositiveSimpleConjugation,
  PreferredPrefix, RepresentativeConjugation, RepresentativeSC, ShowMaps);

AUTO( ReadChv( "prg/gencox" ),
  CoxeterGroupByCartanMatrix, CoxeterGroupByCoxeterMatrix,
  CoxeterGroupHyperoctaedralGroup, CoxeterGroupSymmetricGroup,
  GenCoxOps);

AUTO( ReadChv( "prg/hastype" ),
  FakeDegree, HasTypeOps, ReflectionGroup);

AUTO( ReadChv( "prg/hecke" ),
  CoxeterGroupOpsHecke, HeckeAlgebraOps, HeckeCharValuesGood, 
  HeckeScalarProduct, JInductionTable, PoincarePolynomial);

AUTO( ReadChv( "prg/heckeelt" ), 
  CreateHeckeBasis, HeckeEltOps); 

AUTO( ReadChv( "prg/hekcoset" ),
  CoxeterCosetOpsHecke, HeckeCosetOps);

AUTO( ReadChv( "prg/kl" ),
  CriticalPair, DualWGraph, KLMueMat, KazhdanLusztigCoefficient, 
  KazhdanLusztigMue, KazhdanLusztigPolynomial,
  LeftCells, LeftCellOps, RootParameter, WGraph, WGraphToRepresentation);

AUTO( ReadChv( "prg/permroot" ),
  AsReflection, HyperplaneOrbits, IsWordFor, PermRootGroup, PermRootOps,
  Reflection, ReflectionCharacter, ReflectionWord, jInductionTable);

AUTO( ReadChv( "prg/eigenspaces" ),
  GetRelativeAction, GetRelativeRoot,
  PositionRegularClass, RegularEigenvalues, RelativeDegrees, SplitLevis);

AUTO( ReadChv( "prg/refltype" ), 
  ReflTypeOps);

AUTO( ReadChv( "prg/semisimple" ),
  AlgebraicCentre, AlgebraicFundamentalGroup, IsIsolated, IsQuasiIsolated,
  Mod1, QuasiIsolatedRepresentatives, RootDatum, SemisimpleCentralizer,
  SemisimpleElement, SemisimpleElementOps, SemisimpleSubgroup);

AUTO( ReadChv( "prg/spets" ),
  GenericSign, IsSpets, PhiOnDiscriminant, 
  ReflectionCoset, Spets, SpetsOps, SubSpets);

AUTO( ReadChv( "prg/wclsinv" ),
  ComponentWordsPerm, ComponentWordsPermCoset, CoxeterClassParamCheckFunction,
  CoxeterCosetClassParamCheckFunction, CoxeterCosetOpsClassInvariants,
  CoxeterGroupOpsClassInvariants);

AUTO(ReadChv("tbl/cmplximp"),
  ImprimitiveCuspidalName);

AUTO(ReadChv("tbl/exceptio"),
  G4_22FetchIndexChars, G4_22Helper, G4_22Test, SimplifyCycDecomposition,
  VcycSchurElement, VFactorSchurElement, WGraph2Representation);

if not IsBound(InfoChevie) then InfoChevie:=Ignore;fi;
if not IsBound(InfoChevie2) then InfoChevie2:=Ignore;fi;
if not IsBound(ChevieErr) then ChevieErr:=Ignore;fi; # for non-fatal errors

RequirePackage("vkcurve");# Mvp requires VKcurve
RequirePackage("algebra");# AlgebraElement requires Algebra
RequirePackage("specht"); # MatrixDecompositionMatrix requires Specht

############################################################################
##
#F  CHEVIE.RawData( <f>, <type>)   . . . read function or data <f>
#F   for type <type> from file determined by CHEVIE.AUTO
##  
CHEVIE.RawData:=function(f,type)
  if IsBound(CHEVIE.(type)) and IsBound(CHEVIE.(type).(f))
  then return CHEVIE.(type).(f);
  fi;
  if not IsBound(CHEVIE.AUTO.(type)) then
    Error(type," not in CHEVIE tables");
  elif not IsBound(CHEVIE.AUTO.(type).(f)) then
    InfoChevie2("#I no stored data for ",type,".",f,"\n");
    return false;
  fi;
  ReadChv(CHEVIE.AUTO.(type).(f));
  if not IsBound(CHEVIE.(type)) or not IsBound(CHEVIE.(type).(f))
  then Error("error in chevie/auto.g ",type,".",f,"\n");
  fi;
  return CHEVIE.(type).(f);
end;

############################################################################
##
#F  CHEVIE.Field(<type>)   . . . returns the field of the CHEVIE record
##  where information about <type> is stored, plus extra arguments needed
##  
##  example: 
##  gap> CHEVIE.Field(rec(series:="B",rank:=2));
##  ["B",2]
##
CHEVIE.Field:=function(t)local field,orderphi,phi;
  if IsBound(t.orbit) then 
    phi:=t.twist;orderphi:=OrderPerm(t.twist);t:=t.orbit[1];
  else orderphi:=1;
  fi;
  field:=t.series;
  if field="I" then 
    if orderphi=2 then field:=SPrint(orderphi,field);fi;
    return [field,t.bond];
  elif field="ST" then 
    if IsBound(t.ST) then 
      if orderphi<>1 then return [SPrint(orderphi,"G",t.ST)]; # 2G5 and 2G7
      elif t.ST in [4..7] then return ["G4_7",t.ST];
      elif t.ST in [8..15] then return ["G8_15",t.ST];
      elif t.ST in [16..22] then return ["G16_22",t.ST];
      else return [SPrint("G",t.ST)];
      fi;
    elif orderphi<>1 then return ["timp",t.p,t.q,t.rank,phi];
    else return ["imp",t.p,t.q,t.rank];
    fi;
  elif orderphi=1 then 
    if field in ["A","B","D"] then return [field,t.rank];
    elif field in ["H","E","F","G"] then return [SPrint(field,t.rank)];
    fi;
  else field:=SPrint(orderphi,field);
    if field in ["2A","2D"] then return [field,t.rank];
    elif field="2B" then return ["2I",4];
    elif field="2G" then return ["2I",6];
    else return [SPrint(field,t.rank)]; # 2F4, 2E6, 3D4
    fi;
  fi;
end;

############################################################################
##
#F  CHEVIE.Data( <fname>, <type>,<extraargs>)   . . . general function
#F   to access information for irreducible types from libraries
##  
##  <fname> is the name of the function whose value is required, e.g. 
##  "CharParams" or "HeckeCharTable"
##
##  <type> is an element of the result of ReflectionType for
##  a CoxeterGroup, ComplexReflectionGroup, CoxeterCoset or Spets
##  
##  example: 
##  gap> CHEVIE.Data("CharParams",rec(series:="B",rank:=2));
##  [[[1,1],[ ]], [[1],[1]], [[],[1,1]], [[2],[]],[[],[2]]]
##
CHEVIE.Data:=function(arg)local f,t;
  t:=CHEVIE.Field(arg[2]);
  f:=CHEVIE.RawData(arg[1],t[1]);
  if IsFunc(f) then 
    return ApplyFunc(f,Concatenation(t{[2..Length(t)]},arg{[3..Length(arg)]}));
  fi;
  return f; # a variable
end;

CHEVIE.AddData:=function(name,types,data)local type;
  if not IsString(types[1]) then types:=[types];fi;
  for type in types do
    if not IsBound(CHEVIE.(type)) then
      InfoChevie2("#I cheviedata: creating type ",type,"\n");
      CHEVIE.(type):=rec();
    fi;
    InfoChevie2("#I adding CHEVIE.",type,".",name,"\n");
    CHEVIE.(type).(name):=data;
  od;
end;

CHEVIE.IndirectAddData:=function(f,types,fun)local t;
  for t in types do CHEVIE.AddData(f,t,fun(t));od;
end;

CHEVIE.AutoLoad:=function(flist,types,file)local f,t;
  for t in types do 
    if not IsBound(CHEVIE.AUTO.(t)) then CHEVIE.AUTO.(t):=rec();fi;
    for f in flist do CHEVIE.AUTO.(t).(f):=file;od;
  od;
end;

############################################################################
##
#F  CHEVIE.GetCached(parent,name,obj,hash) .. Function to maintain a cache
##  
##  GetCached tests if an object x in parent.(name) satisfies 
##   hash(x)=hash(obj) and if so returns x else adds obj to parent.(name)
##   and returns obj.
##  The cache is activated only if CHEVIE.Cache.(name)=true
##
CHEVIE.GetCached:=function(parent,name,obj,hash)local i;
  if not IsBound(CHEVIE.Cache.(name)) or not CHEVIE.Cache.(name) 
  then return obj;
  fi;
  if not IsBound(parent.(name)) then parent.(name):=[];fi;
  i:=hash(obj);i:=PositionProperty(parent.(name),x->hash(x)=i);
  if i=false then Add(parent.(name),obj);return obj;
  else return parent.(name)[i];
  fi;
end;

# Things we want always available 
#
ReadChv("lib/polycyc"); # Adds CyclotomicPolynomialOps
ReadChv("lib/classinv");
  # Adds PermGroupOps.PositionClass and PermGroupOps.FusionConjugacyClasses
ReadChv("auto"); # Tells in which files to find table data
ReadChv("unip/init");
ReadChv("contr/init");
ReadChv("tbl/compat3");
