#
#    The ANU Nilpotent Quotient Program (Version 1.1d, 18 May 1994)
#    Calculating a nilpotent quotient
#    Nilpotency class: 10
#
#    Calculating the abelian quotient ...
#    The abelian quotient has 3 generators
#        with the following exponents: 0 0 0
#
#    Calculating the class 2 quotient ...
#    Time spent on the integer matrix: 0 msec.
#    Maximal entry: 0
#    Layer 2 of the lower central series has 2 generators
#          with the following exponents: 0 0
#
#    Calculating the class 3 quotient ...
#    Time spent on the integer matrix: 0 msec.
#    Maximal entry: 0
#    Layer 3 of the lower central series has 3 generators
#          with the following exponents: 0 0 0
#
#    Calculating the class 4 quotient ...
#    Time spent on the integer matrix: 0 msec.
#    Maximal entry: 0
#    Layer 4 of the lower central series has 3 generators
#          with the following exponents: 0 2 0
#
#    Calculating the class 5 quotient ...
#    Time spent on the integer matrix: 0 msec.
#    Maximal entry: 3
#    Layer 5 of the lower central series has 4 generators
#          with the following exponents: 0 2 0 3
#
#    Calculating the class 6 quotient ...
#    Time spent on the integer matrix: 0 msec.
#    Maximal entry: 4
#    Layer 6 of the lower central series has 7 generators
#          with the following exponents: 3 2 2 0 0 3 3
#
#    Calculating the class 7 quotient ...
#    Time spent on the integer matrix: 4 msec.
#    Maximal entry: 7
#    Layer 7 of the lower central series has 11 generators
#          with the following exponents: 3 2 2 2 2 0 0 3 3 3 3
#
#    Calculating the class 8 quotient ...
#    Time spent on the integer matrix: 8 msec.
#    Maximal entry: 26
#    Layer 8 of the lower central series has 12 generators
#          with the following exponents: 3 2 2 2 2 2 0 3 3 3 3 3
#
#    Calculating the class 9 quotient ...
#    Time spent on the integer matrix: 28 msec.
#    Maximal entry: 2464
#    Layer 9 of the lower central series has 14 generators
#          with the following exponents: 3 3 2 2 2 5 0 3 3 3 3 3 3 3
#
#    Calculating the class 10 quotient ...
#    Time spent on the integer matrix: 52 msec.
#    Maximal entry: 7777938
#    Layer 10 of the lower central series has 18 generators
#          with the following exponents: 3 3 2 2 2 5 3 3 3 3 3 3 3 3 3 3 3 3
#


#    The epimorphism :
#    a|---> A
#    b|---> B
#    c|---> C


#    The nilpotent quotient :
    <A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,A1,B1,C1,D1,E1,F1,G1,H1,I1,J1,K1,L1,M1,N1,O1,P1,Q1,R1,S1,T1,U1,V1,W1,X1,Y1,Z1,A2,B2,C2,D2,E2,F2,G2,H2,I2,J2,K2,L2,M2,N2,O2,P2,Q2,R2,S2,T2,U2,V2,W2,X2,Y2
      |
        J^2 = K*L*M*N^-1*Q*W^2*X*Y*B1^-1*C1^-3*H1*I1*J1*O1^2*T1*V1*X1*Z1^-5*G2^2*H2*K2*M2^2*O2*P2*Q2*S2*T2*V2*X2,
        M^2 = N*P*Q*S^-1*X*I1*N1^-3*T1*W1*Y1*D2^2*I2^2*L2*M2^3*P2^2*Q2*S2^2*V2^2*X2^2,
        O^3 = R*T*Y*C1^-4*H1^2*N1^5*T1^2*W1*X1*Y1^3*Z1^-8*A2^2*G2*H2^2*O2*S2^2*V2*X2,
        P^3 = Q*W*X*B1^-1*C1^3*J1*M1*N1^-6*U1*Y1^4*A2^2*C2*D2*L2*M2^4*U2^2*Y2,
        Q^2 = S*W*X*B1^-1*Y1*J2*L2*M2^3*P2*Q2^2,
        R^2 = T*C1^-1*D1^2*H1*K1*N1^-1*O1^2*T1*W1*X1*Y1^2*Z1^-2*A2^2*H2^2*K2*M2^4*O2*S2^2*T2,
        U^3 = Z*C1*I1*N1^-4*T1^2*H2^2*L2*M2^3*P2^2*Q2*X2,
        V^3 = A1*F1*J1*Q1*R1^2*U1^2*C2^2*D2^2*E2^2*F2*I2*S2*T2*U2*V2*W2,
        W^3 = X*N1^3*A2^2*M2^2*P2^2*Q2,
        X^2 = B1*Y1*A2^2*M2^4,
        Y^2 = C1^3*H1*I1*N1^-6*O1*T1*Y1^4*Z1^3*A2^2*J2*M2^2*P2*T2^2,
        Z^2 = C1*N1^-1*O1^2*T1*Y1^2*A2^2*H2*L2*M2^4,
        A1^2 = F1*Q1*R1^2*U1*C2^2*D2^2*E2^2*F2*I2*S2*T2*U2*V2*W2,
        D1^3 = K1*N1*V1*Y1*H2^2*Q2,
        E1^3 = L1*P1*Z1*B2^2*K2*N2*Q2^2,
        F1^3 = M1*C2*D2^2*S2*U2^2*V2,
        G1^3,
        H1^3 = I1*K1*N1*O1^2*T1*V1*X1*Y1^3*Z1^4*A2^2*H2^2*K2*P2*Q2,
        I1^2 = N1^3*T1*V1*Y1^4*A2*H2*M2^4*P2^2,
        J1^2 = U1,
        K1^2 = N1*Y1^4*A2^2*H2*M2^2*P2^2*Q2,
        L1^2 = P1*X1*Z1^2*B2^2*N2,
        M1^2 = C2*D2^2*S2*U2^2*V2,
        O1^3 = Y1^4*J2*M2^3*P2*Q2^2,
        P1^3,
        Q1^3,
        R1^3,
        S1^3,
        T1^3 = V1*Y1^4*A2^2*H2*J2*Q2^2,
        U1^3,
        V1^2 = Y1^3*H2*J2*M2^4*P2,
        W1^2 = O2*S2^2,
        X1^2 = Z1*Q2^2,
        Y1^5 = Q2^2,
        A2^3 = M2^4,
        B2^3,
        C2^3,
        D2^3,
        E2^3,
        F2^3,
        G2^3,
        H2^3 = J2*M2^4*P2^2,
        I2^3,
        J2^2 = M2^3,
        K2^2,
        L2^2,
        M2^5,
        N2^3 = Q2,
        O2^3,
        P2^3,
        Q2^3,
        R2^3,
        S2^3,
        T2^3,
        U2^3,
        V2^3,
        W2^3,
        X2^3,
        Y2^3,
        B^A           =: B*D,
        B^(A^-1)      =  B*D^-1*F,
        C^A           =  C,
        C^(A^-1)      =  C,
        C^B           =: C*E,
        C^(B^-1)      =  C*E^-1*H,
        D^A           =: D*F,
        D^(A^-1)      =  D*F^-1,
        D^B           =  D,
        D^(B^-1)      =  D,
        D^C           =  D*G^-1*J*O*T^-1*U*A1*C1^2*F1*J1*K1*N1^-5*O1^2*Q1*R1^2*U1^2*V1*X1*Z1*C2^2*D2^2*E2^2*F2*G2*H2^2*I2*K2*M2^4*S2*T2^2*U2*V2*W2*Y2,
        D^(C^-1)      =  D*G*J*K^-1*L^-1*M*O^2*P^2*Q*R*S^-1*T^-1*U^2*V*W*X*Z*C1^-2*D1*H1*K1*M1*O1^2*Q1^2*R1*T1*U1*V1*W1*Y1*D2*E2*F2^2*G2*H2^2*I2*K2*M2*O2^2*P2*S2^2*T2*V2^2*W2^2*X2*Y2,
        E^A           =: E*G,
        E^(A^-1)      =  E*G^-1*I*Q*S^-1*W*X*D1^2*I1*J1*N1^-4*O1^2*U1*V1*W1*Y1*D2*H2*J2*L2*M2^3*O2*P2^2*Q2,
        E^B           =: E*H,
        E^(B^-1)      =  E*H^-1,
        E^C           =  E,
        E^(C^-1)      =  E,
        E^D           =  E*J*O*T^-1*U*V^2*C1^2*K1*N1^-5*O1^2*Q1*R1^2*V1*X1*Z1*C2*E2^2*F2*G2^2*H2^2*K2*M2^4*T2^2*U2^2*W2*Y2,
        E^(D^-1)      =  E*J*K^-1*L^-1*M*O^2*P^2*Q*S^-1*T^-1*U*V*W*X*Y*A1*C1^-1*E1*F1*H1*J1*N1^-3*Q1*R1^2*V1*W1*Y1^3*Z1^-2*C2^2*D2*E2^2*F2*G2*H2*I2^2*M2^2*N2^2*O2^2*P2^2*Q2^2*S2^2*T2*U2*V2*W2*Y2^2,
        F^A           =  F,
        F^(A^-1)      =  F,
        F^B           =  F,
        F^(B^-1)      =  F,
        F^C           =  F*I^-1*M*P*U*Y*Z*C1^-4*D1^2*H1^2*I1*J1*K1*L1*N1*P1*W1*X1*Y1^4*Z1^-7*B2^2*D2*H2*M2*N2*Q2*T2^2*X2*Y2,
        F^(C^-1)      =  F*I*M*N^-1*P*U^2*W*Y*C1^-4*D1*F1*I1*J1*K1*L1*N1^3*O1*P1*X1*Y1*Z1^-4*B2^2*C2*H2*I2^2*K2*L2*M2*N2*O2^2*Q2^2*S2*T2^2*U2^2*X2*Y2,
        F^D           =  F,
        F^(D^-1)      =  F,
        F^E           =  F*L^-1*R*Y*A1*C1^-1*D1^2*E1*F1^2*K1*L1*M1*N1^-1*O1^2*P1^2*Q1*R1^2*T1*U1^2*X1*Y1^2*Z1^-5*A2^2*B2^2*C2*E2^2*F2*H2^2*I2^2*K2*M2^4*N2*Q2*T2*U2^2*W2*X2^2*Y2,
        F^(E^-1)      =  F*L*R*T^-1*Y*A1*C1^-1*D1^2*E1^2*F1^2*H1*K1*M1*N1^-1*O1^2*P1^2*Q1^2*R1^2*T1*Y1^2*Z1^-5*A2^2*C2*E2^2*F2*H2^2*I2^2*M2^4*S2*V2*W2*X2^2*Y2^2,
        G^A           =: G*I,
        G^(A^-1)      =  G*I^-1*Q*W*X*B1^-1*D1*I1*K1*N1^-4*O1*T1^2*Y1^3*A2*H2*I2^2*J2*L2*M2^4*Q2^2,
        G^B           =: G*J,
        G^(B^-1)      =  G*J*K^-1*L^-1*M*O^2*P^2*Q*R*S^-1*T^-1*U^2*W*X*Z*C1^-2*D1*H1*K1*M1*O1^2*T1*U1*V1*W1*Y1*C2*D2*G2^2*H2^2*I2*K2*M2*O2^2*P2*S2^2*T2^2*U2^2*V2^2*X2*Y2,
        G^C           =  G,
        G^(C^-1)      =  G,
        G^D           =  G*L^-1*M*P^2*Q*R*S^-1*U*W*X*Z*C1^-4*D1*E1*H1*M1*N1^5*T1*U1*W1*Y1*Z1^-2*C2*D2*I2*K2*M2^2*N2^2*O2^2*P2*Q2*S2^2*T2*U2^2*V2^2*X2*Y2,
        G^(D^-1)      =  G*L*M*N^-1*Q*R*T^-1*U^2*W^2*X*Z*B1^-1*C1^-2*D1*E1^2*H1*I1*J1*L1*N1^-1*P1*T1^2*X1*Y1^3*Z1^-5*A2^2*B2^2*J2*M2*N2^2*O2*Q2*S2*V2*X2^2,
        G^E           =  G*V^2*A1*F1*G1^2*J1*M1*Q1^2*R1*U1^2*C2*D2*E2^2*F2*I2*S2^2*T2*V2^2*W2,
        G^(E^-1)      =  G*V*G1*Q1^2*R1*C2^2*G2^2*Y2^2,
        G^F           =  G*P*Z*C1^-1*I1*J1*M1*N1^-1*O1^2*P1^2*T1*W1*Y1^2*A2^2*B2^2*C2*H2*L2*M2^4*N2*S2*T2*U2^2*V2^2,
        G^(F^-1)      =  G*P^2*Q*S^-1*W*X*Z*C1^-3*I1*N1^2*O1^2*P1*T1*U1*W1*B2*H2*J2*M2*N2*O2^2*Q2^2*S2^2*T2^2*Y2^2,
        H^A           =: H*K,
        H^(A^-1)      =  H*K^-1*N*S^-1*B1*D2^2*S2^2*V2^2,
        H^B           =  H,
        H^(B^-1)      =  H,
        H^C           =  H,
        H^(C^-1)      =  H,
        H^D           =  H*O^2*R*T^-1*U^2*Y*Z*C1^-2*D1*H1^2*K1*O1*T1*X1*Z1^-5*A2^2*G2^2*H2*M2*P2*T2^2*V2^2*X2,
        H^(D^-1)      =  H*O*T^-1*U*C1^2*E1*K1*N1^-5*O1^2*V1*Z1*H2^2*M2^4*N2^2*T2,
        H^E           =  H,
        H^(E^-1)      =  H,
        H^F           =  H*T*U*Z*C1^-4*D1*E1^2*I1*K1*L1*N1^6*O1*T1^2*Y1^3*Z1^-4*A2*B2^2*H2*M2*N2*P2^2*Q2*T2^2*X2^2*Y2,
        H^(F^-1)      =  H*T^-1*U^2*C1^2*D1^2*E1*N1^-6*P1*X1*Y1^3*Z1*A2^2*B2*J2*K2*M2^3*P2^2*Q2*R2*T2*Y2^2,
        H^G           =  H*V*G1*Q1^2*R1*C2^2,
        H^(G^-1)      =  H*V^2*A1*F1*G1^2*J1*M1*Q1^2*R1*U1^2*C2*D2*E2^2*F2*I2*S2^2*T2*V2^2*W2,
        I^A           =  I*Q*W*D1*I1*K1*N1^-4*O1^2*T1^2*V1*Y1^4*I2^2*L2*M2*P2*Q2,
        I^(A^-1)      =  I*Q*S^-1*W*X*D1^2*I1*N1^-4*O1^2*V1*Y1*H2*I2*J2*M2^3*P2^2*Q2,
        I^B           =: I*L,
        I^(B^-1)      =  I*L^-1*T*U*Z*C1^-4*D1*I1*K1*N1^6*O1*T1^2*W1*Y1^3*A2*H2*M2*O2^2*P2^2*Q2*S2*T2^2*X2,
        I^C           =  I,
        I^(C^-1)      =  I,
        I^D           =  I*P*C1^-2*D1*H1*N1^2*P1^2*T1^2*V1*W1*Y1*Z1^-1*K2*M2*N2^2*O2*P2*Q2*S2^2*T2^2*Y2^2,
        I^(D^-1)      =  I*P^2*Q*S^-1*W*X*C1^-1*D1^2*H1*J1*M1*N1^-3*P1*T1^2*U1*V1*W1*Y1^4*Z1^-1*A2*B2^2*C2*J2*K2*L2*O2*P2^2*S2*T2*U2^2*V2^2,
        I^E           =  I*F1^2*J1*M1*R1^2*U1*W1*C2^2*D2^2*I2^2*O2*S2^2*U2^2*V2,
        I^(E^-1)      =  I*F1*J1*R1*U1*W1*C2^2*I2*O2*X2^2,
        I^F           =  I*W*K1*N1^-1*V1*Y1^4*A2^2*B2^2*H2*L2*M2^2*P2^2,
        I^(F^-1)      =  I*W^2*X*B1^-1*K1*N1^-3*V1*Y1^3*A2*B2*H2*L2*M2^2*Q2,
        I^G           =  I*J1*U1*W1*D2^2*I2*O2*S2,
        I^(G^-1)      =  I*J1*U1*W1*D2*I2^2*O2,
        I^H           =  I*F1^2*M1*R1^2*C2^2*D2^2*I2^2*U2^2*V2,
        I^(H^-1)      =  I*F1*R1*C2^2*I2*S2*X2^2,
        J^A           =: J*M,
        J^(A^-1)      =  J*M*N^-1*P^2*Q*W*X*B1^-1*C1^-3*I1*J1*M1*N1^3*T1*U1*V1*W1*Y1*A2^2*C2*D2*H2*I2*L2*M2^3*O2^2*S2*U2^2*X2*Y2^2,
        J^B           =  J*O^2*R*T^-1*U^2*Y*Z*C1^-2*D1*H1^2*K1*O1*T1*X1*Z1^-5*A2^2*G2*H2*M2*P2*T2^2*V2^2*X2*Y2,
        J^(B^-1)      =  J*O*T^-1*U*C1^2*K1*N1^-5*O1^2*V1*X1*Z1*G2*H2^2*K2*M2^4*T2*Y2,
        J^C           =  J,
        J^(C^-1)      =  J,
        J^D           =  J*R*T^-1*U^2*Y*E1^2*H1^2*L1*N1^-4*O1*P1*T1^2*W1*X1*Y1^4*Z1^-8*A2*B2^2*H2^2*N2^2*O2*P2^2*Q2^2*S2^2*T2^2*V2*X2,
        J^(D^-1)      =  J*R*U*Y*Z*C1^-4*D1*E1*H1^2*L1*N1^5*O1^2*P1*T1*V1*X1*Y1^3*Z1^-9*A2^2*B2^2*H2*J2*Q2^2*T2*V2^2*X2*Y2^2,
        J^E           =  J*V*G1*Q1^2*R1*C2^2,
        J^(E^-1)      =  J*V^2*A1*F1*G1^2*J1*M1*Q1^2*R1*U1^2*C2*D2*E2^2*F2*G2*I2*S2^2*T2*V2^2*W2*Y2,
        J^F           =  J*Y*C1^-1*D1^2*K1*L1*N1^-1*O1^2*P1^2*T1*Y1^2*Z1^-3*A2^2*B2*H2^2*L2*M2^4*N2*Q2^2*R2,
        J^(F^-1)      =  J*Y*C1^-2*D1*H1^2*K1*L1*O1*T1^2*V1*Y1^3*Z1^-7*H2*J2*L2*M2^2*P2*R2^2*T2,
        J^G           =  J*A1*F1*J1*M1*Q1*R1^2*U1^2*D2*E2^2*F2*I2*S2^2*T2*V2^2*W2,
        J^(G^-1)      =  J*A1*F1*J1*Q1*R1^2*U1^2*C2^2*D2^2*E2^2*F2*I2*S2*T2*U2*V2*W2,
        J^H           =  J*G1^2*S1^2*E2*F2^2*T2^2*U2,
        J^(H^-1)      =  J*G1*S1*E2^2*F2*T2*U2^2*Y2^2,
        J^I           =  J*J1*U1^2*W1*D2^2*O2*S2^2,
        J^(I^-1)      =  J*J1*W1*D2*O2*S2^2,
        K^A           =: K*N,
        K^(A^-1)      =  K*N^-1*S*B1^-1,
        K^B           =: K*O,
        K^(B^-1)      =  K*O^2*R*T^-2*Y*C1^2*D1*E1*H1^2*I1*N1^-9*O1^2*T1*X1*Y1^2*Z1^-4*A2^2*G2^2*N2^2*P2*V2^2*X2^2*Y2,
        K^C           =  K,
        K^(C^-1)      =  K,
        K^D           =  K*T^-1*U*C1^2*E1*K1*N1^-5*O1^2*V1*Z1*H2^2*M2^4*N2^2*T2^2*V2*Y2,
        K^(D^-1)      =  K*T*U^2*Z*C1^-4*E1^2*I1*K1*L1*N1^6*O1^2*P1*T1^2*X1*Y1^3*Z1^-5*B2^2*H2*K2*M2*N2^2*T2*V2^2*X2^2,
        K^E           =  K*V^2*A1*F1*G1^2*J1*M1*Q1^2*R1*U1^2*C2*D2*E2^2*F2*I2*S2^2*T2*V2^2*W2,
        K^(E^-1)      =  K*V*G1*Q1^2*R1*C2^2*G2^2*Y2^2,
        K^F           =  K*C1*D1*K1*N1^-4*O1*P1^2*V1*Y1^4*A2*B2^2*H2^2*N2*P2^2*Q2^2*T2^2,
        K^(F^-1)      =  K*C1^-1*D1^2*N1^2*O1^2*P1*Y1^4*B2*M2^3*P2^2*Q2^2*T2,
        K^G           =  K,
        K^(G^-1)      =  K,
        K^H           =  K*G1*Q1*R1^2*S1*C2,
        K^(H^-1)      =  K*G1^2*Q1^2*R1*S1^2*C2^2*Y2,
        K^I           =  K*D2*I2^2*S2,
        K^(I^-1)      =  K*D2^2*I2*S2^2,
        K^J           =  K*T2*V2,
        L^A           =: L*P,
        L^(A^-1)      =  L*P^2*Q*S^-1*W^2*X*C1^-3*J1*M1*N1^3*U1*V1*Y1^3*A2^2*C2*H2*J2*M2^2*Q2*S2^2*U2^2*V2^2*Y2^2,
        L^B           =  L*T*U*Z*C1^-4*D1*I1*K1*N1^6*O1*T1^2*W1*Y1^3*A2*H2*M2*O2^2*P2^2*Q2*S2*T2^2*X2,
        L^(B^-1)      =  L*T^-1*U^2*C1^2*D1^2*N1^-6*W1*Y1^3*A2^2*J2*M2^3*P2^2*T2*X2,
        L^C           =  L*J1*U1,
        L^(C^-1)      =  L*J1*U1,
        L^D           =  L*Y*C1^-1*D1^2*K1*N1^-1*O1^2*P1*T1*W1*X1*Y1^2*Z1^-4*A2^2*H2^2*M2^4*N2*O2*Q2*S2^2*T2^2*Y2^2,
        L^(D^-1)      =  L*Y*C1^-2*D1*H1^2*K1*O1*P1^2*T1^2*V1*W1*X1*Y1^3*Z1^-5*B2^2*H2*J2*M2^2*N2*O2*P2*R2*S2^2*T2^2*Y2,
        L^E           =  L*F1*R1*W1*C2^2*I2*O2,
        L^(E^-1)      =  L*F1^2*M1*R1^2*W1*C2^2*D2^2*I2^2*O2*S2^2*U2^2*V2*X2,
        L^F           =  L*H1*X1*Z1^-1*K2*Q2^2*R2^2,
        L^(F^-1)      =  L*H1^2*I1*K1*N1^-5*O1*T1*V1*Z1^-4*A2^2*H2^2*J2*M2^2*P2*Q2*R2,
        L^G           =  L*J1*U1^2*W1*D2*O2*S2,
        L^(G^-1)      =  L*J1*W1*D2^2*O2,
        L^H           =  L*Q1^2*E2^2*U2*V2,
        L^(H^-1)      =  L*Q1*E2*U2^2*V2^2,
        L^I           =  L*U1^2*S2^2,
        L^(I^-1)      =  L*U1*S2,
        L^J           =  L*W1*D2*O2*T2^2,
        L^K           =  L*D2^2*O2*S2*T2,
        L^(K^-1)      =  L*D2*O2^2*S2^2*T2^2,
        M^A           =: M*Q,
        M^(A^-1)      =  M*Q*S^-1*W^2*X*N1^-3*V1*Y1^4*A2^2*H2*J2*L2*M2^4*P2^2,
        M^B           =: M*R,
        M^(B^-1)      =  M*R*T^-1*C1*D1*E1*H1^2*I1*K1*N1^-6*O1^2*P1^2*W1*Y1^4*Z1^-3*A2*J2*M2^2*N2*O2*P2^2*Q2*S2^2*T2^2*Y2,
        M^C           =  M,
        M^(C^-1)      =  M,
        M^D           =  M*Y*Z*C1^-3*H1^2*L1*N1^3*O1^2*P1^2*T1*V1*X1*Z1^-7*H2*K2*M2^3*P2^2*Q2*R2*T2,
        M^(D^-1)      =  M*Y*Z*C1^-1*K1*L1*N1^-1*O1^2*T1*V1*X1*Y1^4*Z1^-3*A2^2*H2*J2*K2*L2*M2^2*N2*P2^2*Q2^2,
        M^E           =  M*A1*F1^2*M1*Q1*U1^2*W1*C2^2*D2*E2^2*F2*I2^2*O2*T2*V2^2*W2,
        M^(E^-1)      =  M*A1*Q1*R1*W1*D2^2*E2^2*F2*O2*S2*T2*U2*V2*W2*X2,
        M^F           =  M*I1*N1^-1*O1^2*Y1^2*A2^2*B2*H2*M2^4*N2^2*Q2^2,
        M^(F^-1)      =  M*I1*N1^-2*O1*T1^2*Y1^3*A2*B2^2*H2^2*J2*N2*P2,
        M^G           =  M*J1*M1*W1*C2*I2^2*O2*U2^2*V2,
        M^(G^-1)      =  M*J1*M1*U1^2*W1*C2*D2*I2*O2*U2^2*V2,
        M^H           =  M*R1^2*D2*F2^2*O2*T2*U2*V2,
        M^(H^-1)      =  M*R1*D2^2*F2*O2^2*T2^2*U2^2*V2^2,
        M^I           =  M*I2,
        M^(I^-1)      =  M*I2^2,
        M^J           =  M*W1*D2*L2*S2*V2,
        M^K           =  M*D2^2*O2^2*V2^2,
        M^(K^-1)      =  M*D2*O2*V2,
        M^L           =  M*O2^2*S2,
        M^(L^-1)      =  M*O2*S2^2,
        N^A           =: N*S,
        N^(A^-1)      =  N*S^-1*B1,
        N^B           =: N*T,
        N^(B^-1)      =  N*T^-1*E1^2*P1^2*Z1^2*B2*Q2*Y2,
        N^C           =  N,
        N^(C^-1)      =  N,
        N^D           =  N*C1^-2*K1*N1^4*O1*P1^2*V1*Y1^4*Z1*A2*B2*H2^2*M2^4*N2*P2*R2*T2,
        N^(D^-1)      =  N*C1^2*K1*N1^-5*O1^2*P1*V1*Z1*H2^2*M2^4*Q2^2*R2*T2^2,
        N^E           =  N*F1^2*M1*R1^2*C2^2*D2^2*I2^2*U2^2*V2,
        N^(E^-1)      =  N*F1*R1*C2^2*I2*S2*X2^2,
        N^F           =  N*N1*O1*Y1^4*A2*B2^2*J2*M2*P2^2*Q2^2,
        N^(F^-1)      =  N*N1^-1*O1^2*Y1^2*A2^2*B2*M2^4*Q2,
        N^G           =  N*D2^2*I2*S2^2,
        N^(G^-1)      =  N*D2*I2^2*S2,
        N^H           =  N*R1*C2*D2*F2*V2^2,
        N^(H^-1)      =  N*R1^2*C2^2*D2^2*F2^2*V2,
        N^I           =  N,
        N^(I^-1)      =  N,
        N^J           =  N*D2^2*O2^2*V2^2,
        N^K           =  N*D2*S2*V2,
        N^(K^-1)      =  N*D2^2*S2^2*V2^2,
        N^L           =  N*O2*S2^2,
        N^(L^-1)      =  N*O2^2*S2,
        N^M           =  N,
        O^A           =: O*U,
        O^(A^-1)      =  O*U^2*Z*C1^-2*D1*I1*N1^2*T1^2*V1*Y1*H2*M2*P2*Q2*X2^2,
        O^B           =  O*E1*X1*Z1^-1*K2*N2^2*Q2*Y2,
        O^(B^-1)      =  O*E1^2*L1*P1*Z1^-3*B2^2*N2^2*Q2^2*Y2^2,
        O^C           =: O*V,
        O^(C^-1)      =  O*V^2*A1*F1*J1*M1*Q1*R1^2*U1^2*D2*E2^2*F2*G2*I2*S2^2*T2*V2^2*W2,
        O^D           =  O*E1^2*L1*P1*Z1^-3*B2^2*N2^2*Q2^2*Y2^2,
        O^(D^-1)      =  O*E1*X1*Z1^-1*K2*N2^2*Q2*Y2,
        O^E           =  O*G1*Q1^2*R1*C2^2*G2,
        O^(E^-1)      =  O*G1^2*Q1*R1^2*C2*G2*Y2,
        O^F           =  O*P1*X1*B2^2*K2*Q2^2*R2*Y2^2,
        O^(F^-1)      =  O*P1^2*X1*Z1^-1*B2*K2*Q2^2*R2^2*Y2,
        O^G           =  O,
        O^(G^-1)      =  O,
        O^H           =  O*S1*E2*F2^2*T2^2*U2,
        O^(H^-1)      =  O*S1^2*E2^2*F2*T2*U2^2,
        O^I           =  O*D2^2*O2*S2,
        O^(I^-1)      =  O*D2*O2^2*S2^2,
        O^J           =  O*T2^2*V2^2,
        O^K           =  O*T2^2*V2^2,
        O^(K^-1)      =  O*T2*V2,
        O^L           =  O*T2^2,
        O^(L^-1)      =  O*T2,
        O^M           =  O*V2,
        O^N           =  O*V2^2,
        O^(N^-1)      =  O*V2,
        P^A           =: P*W,
        P^(A^-1)      =  P*W^2*X*B1^-1*N1^-3*V1*Y1*A2*H2*M2*P2*Q2,
        P^B           =  P*Y*C1^-1*D1^2*K1*N1^-1*O1^2*T1*W1*Y1^2*A2^2*H2^2*M2^4*O2*Q2^2*S2^2*T2^2,
        P^(B^-1)      =  P*Y*C1^-2*D1*H1^2*K1*O1*P1^2*T1^2*V1*W1*Y1^3*Z1^-7*H2*J2*M2^2*N2^2*O2*P2*S2^2*T2^2*Y2,
        P^C           =  P,
        P^(C^-1)      =  P,
        P^D           =  P*H1^2*K1*N1^-3*T1*Y1^3*Z1^-4*A2^2*B2*H2^2*K2*L2*M2*N2*P2*Q2*R2,
        P^(D^-1)      =  P*H1*I1*N1^-2*O1*V1*X1*Y1^2*Z1^-1*B2^2*J2*L2*M2*N2^2*Q2*R2^2,
        P^E           =  P*J1*U1^2*W1*O2,
        P^(E^-1)      =  P*J1*W1*O2*S2,
        P^F           =  P*T1*N2*Q2,
        P^(F^-1)      =  P*T1^2*V1*Y1^3*A2*H2*J2*M2^2*N2^2*Q2,
        P^G           =  P*U1*I2^2*L2*S2,
        P^(G^-1)      =  P*U1^2*I2*L2*S2^2,
        P^H           =  P*C2^2*D2*O2*T2^2*U2^2,
        P^(H^-1)      =  P*C2*D2^2*O2^2*T2*U2,
        P^I           =  P*I2^2,
        P^(I^-1)      =  P*I2,
        P^J           =  P*L2*O2^2*S2,
        P^K           =  P*O2*S2^2,
        P^(K^-1)      =  P*O2^2*S2,
        Q^A           =: Q*X,
        Q^(A^-1)      =  Q*X*B1^-1*V1*A2*H2*M2^2*P2*Q2^2,
        Q^B           =: Q*Y,
        Q^(B^-1)      =  Q*Y*C1^-3*H1^2*K1*N1*V1*Y1*Z1^-4*B2^2*H2^2*Q2*T2,
        Q^C           =  Q,
        Q^(C^-1)      =  Q,
        Q^D           =  Q*K1*N1^-2*O1*T1^2*V1*A2*H2^2*K2*M2*N2^2*Q2,
        Q^(D^-1)      =  Q*K1*N1*O1^2*T1*A2*H2*J2*K2*N2*P2*Q2^2,
        Q^E           =  Q*J1*U1^2*W1*O2,
        Q^(E^-1)      =  Q*J1*W1*O2*S2,
        Q^F           =  Q*V1*Y1^4*A2^2*M2^2*P2^2*Q2^2,
        Q^(F^-1)      =  Q*V1*Y1^3*A2*H2^2*M2^3*P2,
        Q^G           =  Q*I2*L2,
        Q^(G^-1)      =  Q*I2^2*L2,
        Q^H           =  Q*O2,
        Q^(H^-1)      =  Q*O2^2,
        Q^I           =  Q,
        Q^(I^-1)      =  Q,
        Q^J           =  Q*L2,
        Q^K           =  Q,
        Q^(K^-1)      =  Q,
        R^A           =: R*Z,
        R^(A^-1)      =  R*Z*C1^-1*K1*N1*O1*T1^2*V1*Y1^4*A2^2*L2*M2^2*P2*Q2,
        R^B           =  R*E1*P1^2*N2*Q2^2*Y2,
        R^(B^-1)      =  R*E1^2*L1*P1^2*X1*Z1^-4*B2^2*K2*Q2^2*Y2^2,
        R^C           =: R*A1,
        R^(C^-1)      =  R*A1*F1^2*M1*Q1^2*R1*U1^2*C2^2*E2*F2^2*I2^2*T2^2*U2*W2^2*X2^2,
        R^D           =  R*L1*Z1^-2*B2*N2^2*R2^2,
        R^(D^-1)      =  R*L1*P1^2*X1*Z1^-1*R2^2,
        R^E           =  R*Q1*R1*W1*D2^2*E2^2*F2*O2*S2*T2*U2*V2*W2*X2^2,
        R^(E^-1)      =  R*Q1^2*R1^2*W1*D2*E2*F2^2*O2*T2^2*U2^2*V2^2*W2^2*X2^2,
        R^F           =  R*X1*N2*R2,
        R^(F^-1)      =  R*X1*Z1^-1*N2^2*R2^2,
        R^G           =  R*D2^2*L2*S2^2,
        R^(G^-1)      =  R*D2*L2*S2,
        R^H           =  R*E2^2*T2*W2^2,
        R^(H^-1)      =  R*E2*T2^2*W2,
        R^I           =  R*O2*S2^2,
        R^(I^-1)      =  R*O2^2*S2,
        R^J           =  R*T2*V2^2,
        R^K           =  R*T2^2*V2,
        R^(K^-1)      =  R*T2*V2^2,
        S^A           =: S*B1,
        S^(A^-1)      =  S*B1^-1,
        S^B           =  S*C1^3*K1*N1^-2*V1*X1*Y1^2*Z1^4*A2*H2^2*J2*K2*M2*P2^2*T2^2,
        S^(B^-1)      =  S*C1^-3*K1*N1*V1*X1*Y1*Z1^4*H2^2*K2*T2,
        S^C           =  S,
        S^(C^-1)      =  S,
        S^D           =  S*N1^-3*O1^2*Y1^3*A2^2*J2*M2*P2*Q2^2,
        S^(D^-1)      =  S*N1^3*O1*Y1^3*A2*M2^4*P2*Q2,
        S^E           =  S,
        S^(E^-1)      =  S,
        S^F           =  S*Y1*A2*M2^4*P2*Q2^2,
        S^(F^-1)      =  S*Y1^4*A2^2*M2^2*P2^2*Q2^2,
        S^G           =  S,
        S^(G^-1)      =  S,
        S^H           =  S,
        S^(H^-1)      =  S,
        S^I           =  S,
        S^(I^-1)      =  S,
        S^J           =  S,
        S^K           =  S,
        S^(K^-1)      =  S,
        T^A           =: T*C1,
        T^(A^-1)      =  T*C1^-1*N1*Y1^4*M2*Q2,
        T^B           =  T*E1^2*P1^2*Z1^2*B2*Q2*Y2,
        T^(B^-1)      =  T*E1*L1*P1^2*X1*Z1^-6*B2*K2*N2*Y2^2,
        T^C           =  T*F1*Q1*R1^2*D2*E2^2*F2*I2*S2*T2*V2^2*W2,
        T^(C^-1)      =  T*F1^2*M1*Q1^2*R1*C2*D2*E2*F2^2*I2^2*T2^2*U2^2*V2^2*W2^2*X2,
        T^D           =  T*P1*X1*Z1^-3*B2^2*K2*N2^2*R2^2,
        T^(D^-1)      =  T*P1^2*X1*Z1^2*B2*K2*N2,
        T^E           =  T*Q1^2*R1^2*C2^2*D2^2*E2*F2^2*T2^2*V2*W2^2*X2,
        T^(E^-1)      =  T*Q1*R1*C2*D2*E2^2*F2*T2*V2^2*W2*X2,
        T^F           =  T*Z1*Q2*R2^2,
        T^(F^-1)      =  T*Z1^-1*Q2^2*R2,
        T^G           =  T*D2*O2,
        T^(G^-1)      =  T*D2^2*O2^2,
        T^H           =  T*E2*T2*U2*V2*W2,
        T^(H^-1)      =  T*E2^2*T2^2*U2^2*V2^2*W2^2,
        T^I           =  T*O2^2*S2,
        T^(I^-1)      =  T*O2*S2^2,
        T^J           =  T*T2^2*V2,
        T^K           =  T*T2*V2^2,
        T^(K^-1)      =  T*T2^2*V2,
        U^A           =: U*D1,
        U^(A^-1)      =  U*D1^2*K1*N1^-2*O1*V1*Y1^2*H2^2*J2*M2,
        U^B           =: U*E1,
        U^(B^-1)      =  U*E1^2*L1*P1*X1*Z1^-4*B2^2*K2*N2*Q2*R2,
        U^C           =  U*F1,
        U^(C^-1)      =  U*F1^2*M1*C2*D2^2*S2*U2^2*V2*X2,
        U^D           =  U*P1*X1*Z1^-1*K2*Y2,
        U^(D^-1)      =  U*P1^2*X1*K2*Q2*R2^2*Y2^2,
        U^E           =  U*R1*C2^2*O2*X2,
        U^(E^-1)      =  U*R1^2*C2*O2^2*X2,
        U^F           =  U*B2*N2^2,
        U^(F^-1)      =  U*B2^2*N2*Q2^2,
        U^G           =  U*D2*O2^2*S2^2,
        U^(G^-1)      =  U*D2^2*O2*S2,
        U^H           =  U*F2*T2*U2*V2^2,
        U^(H^-1)      =  U*F2^2*T2^2*U2^2*V2,
        U^I           =  U,
        U^(I^-1)      =  U,
        U^J           =  U*V2^2,
        U^K           =  U*V2,
        U^(K^-1)      =  U*V2^2,
        V^A           =: V*F1,
        V^(A^-1)      =  V*F1^2*M1*C2*D2^2*I2^2*U2^2*V2,
        V^B           =: V*G1,
        V^(B^-1)      =  V*G1^2*S1,
        V^C           =  V*G2,
        V^(C^-1)      =  V*G2^2,
        V^D           =  V*Q1^2*R1*C2^2*E2*F2^2*T2^2*U2*W2^2,
        V^(D^-1)      =  V*Q1*R1^2*C2*E2^2*F2*U2^2*V2^2*W2,
        V^E           =  V*G2^2,
        V^(E^-1)      =  V*G2,
        V^F           =  V*C2*D2*S2*U2^2,
        V^(F^-1)      =  V*C2^2*D2^2*S2^2*U2,
        V^G           =  V,
        V^(G^-1)      =  V,
        V^H           =  V*G2,
        V^(H^-1)      =  V*G2^2,
        V^I           =  V,
        V^(I^-1)      =  V,
        V^J           =  V,
        V^K           =  V,
        V^(K^-1)      =  V,
        W^A           =  W*V1*Y1^2*A2^2*H2*J2*M2^3*P2^2*Q2^2,
        W^(A^-1)      =  W*V1*A2*H2*M2^4*Q2^2,
        W^B           =: W*H1,
        W^(B^-1)      =  W*H1^2*I1*K1*N1^-5*O1*T1*V1*X1*Z1^-4*A2^2*B2*H2^2*J2*K2*M2^2*P2,
        W^C           =  W,
        W^(C^-1)      =  W,
        W^D           =  W*T1*N2,
        W^(D^-1)      =  W*T1^2*V1*Y1^3*A2*H2*J2*M2^2*N2^2*Q2^2,
        W^E           =  W*U1^2*S2^2,
        W^(E^-1)      =  W*U1*S2,
        W^F           =  W*H2,
        W^(F^-1)      =  W*H2^2*J2*M2^3*P2,
        W^G           =  W*I2^2,
        W^(G^-1)      =  W*I2,
        W^H           =  W*O2^2,
        W^(H^-1)      =  W*O2,
        X^A           =  X*V1*Y1*H2*J2*M2*P2*Q2^2,
        X^(A^-1)      =  X*V1*Y1*H2*M2^4*P2^2*Q2^2,
        X^B           =  X*I1*K1*N1*O1^2*T1*V1*X1*Y1^3*Z1*A2^2*H2^2*K2*P2*Q2^2,
        X^(B^-1)      =  X*I1*K1*N1^-5*O1*T1*V1*X1*Z1*A2^2*H2^2*J2*K2*M2^2*P2*Q2^2,
        X^C           =  X,
        X^(C^-1)      =  X,
        X^D           =  X*V1*Y1^4*A2^2*H2*J2*Q2^2,
        X^(D^-1)      =  X*V1*Y1^3*A2*H2*J2*M2^2,
        X^E           =  X,
        X^(E^-1)      =  X,
        X^F           =  X*J2*M2^4*P2^2,
        X^(F^-1)      =  X*J2*M2^3*P2,
        X^G           =  X,
        X^(G^-1)      =  X,
        X^H           =  X,
        X^(H^-1)      =  X,
        Y^A           =: Y*I1,
        Y^(A^-1)      =  Y*I1*N1^-3*T1^2*V1*Y1^4*M2^3*P2*Q2,
        Y^B           =  Y*X1*Z1^3*B2^2*K2*Q2,
        Y^(B^-1)      =  Y*X1*Z1^-4*B2*K2,
        Y^C           =: Y*J1,
        Y^(C^-1)      =  Y*J1*U1^2,
        Y^D           =  Y*X1*Z1^-2*K2*N2*Q2^2,
        Y^(D^-1)      =  Y*X1*Z1*K2*N2^2*Q2,
        Y^E           =  Y*W1*O2*S2,
        Y^(E^-1)      =  Y*W1*O2,
        Y^F           =  Y*K2*Q2^2,
        Y^(F^-1)      =  Y*K2*Q2,
        Y^G           =  Y*L2,
        Y^(G^-1)      =  Y*L2,
        Y^H           =  Y,
        Y^(H^-1)      =  Y,
        Z^A           =: Z*K1,
        Z^(A^-1)      =  Z*K1*N1^-1*Y1^4*A2*H2^2*J2*M2*Q2^2,
        Z^B           =: Z*L1,
        Z^(B^-1)      =  Z*L1*P1^2*X1*Z1^-3*B2*N2^2*R2,
        Z^C           =  Z*M1,
        Z^(C^-1)      =  Z*M1*C2^2*D2*S2^2*U2*V2^2,
        Z^D           =  Z*X1*Z1^-1*B2^2*R2^2,
        Z^(D^-1)      =  Z*X1*B2*Q2*R2,
        Z^E           =  Z*C2*D2^2*O2*U2^2*V2,
        Z^(E^-1)      =  Z*C2^2*D2*O2^2*U2*V2^2,
        Z^F           =  Z*N2^2*Q2,
        Z^(F^-1)      =  Z*N2*Q2,
        Z^G           =  Z*O2^2*S2,
        Z^(G^-1)      =  Z*O2*S2^2,
        Z^H           =  Z*T2*U2^2*V2^2,
        Z^(H^-1)      =  Z*T2^2*U2*V2,
        A1^A           =: A1*M1,
        A1^(A^-1)      =  A1*M1*C2^2*D2*S2*U2*V2^2,
        A1^B           =  A1*Q1^2*W1*E2^2*F2*T2^2*U2*V2^2*W2,
        A1^(B^-1)      =  A1*Q1*W1*E2^2*O2^2*S2*T2^2*U2^2*V2^2*W2,
        A1^C           =  A1*X2^2,
        A1^(C^-1)      =  A1*X2,
        A1^D           =  A1*C2^2*L2*T2^2*U2,
        A1^(D^-1)      =  A1*C2*L2*T2*U2^2,
        A1^E           =  A1*X2,
        A1^(E^-1)      =  A1*X2^2,
        A1^F           =  A1*S2^2,
        A1^(F^-1)      =  A1*S2,
        A1^G           =  A1,
        A1^(G^-1)      =  A1,
        A1^H           =  A1*X2^2,
        A1^(H^-1)      =  A1*X2,
        B1^A           =  B1,
        B1^(A^-1)      =  B1,
        B1^B           =  B1*N1^6*O1*Y1^3*Z1^3*J2*Q2,
        B1^(B^-1)      =  B1*N1^-6*O1^2*Y1^3*Z1^3*M2^4*P2^2*Q2^2,
        B1^C           =  B1,
        B1^(C^-1)      =  B1,
        B1^D           =  B1*Y1*A2*M2^3*Q2^2,
        B1^(D^-1)      =  B1*Y1^4*A2^2*M2^3*Q2^2,
        B1^E           =  B1,
        B1^(E^-1)      =  B1,
        B1^F           =  B1*M2*P2,
        B1^(F^-1)      =  B1*M2^4*P2^2,
        B1^G           =  B1,
        B1^(G^-1)      =  B1,
        B1^H           =  B1,
        B1^(H^-1)      =  B1,
        C1^A           =: C1*N1,
        C1^(A^-1)      =  C1*N1^-1*Y1*M2^4,
        C1^B           =  C1*P1*X1*Z1^3*B2^2*K2*N2^2,
        C1^(B^-1)      =  C1*P1^2*X1*Z1^-4*B2*K2*N2*R2,
        C1^C           =  C1*C2*D2^2*I2^2*S2^2*U2^2*V2,
        C1^(C^-1)      =  C1*C2^2*D2*I2*S2*U2*V2^2,
        C1^D           =  C1*Z1^-1*B2*N2*Q2*R2,
        C1^(D^-1)      =  C1*Z1*B2^2*N2^2*Q2*R2^2,
        C1^E           =  C1*C2^2*D2*O2*U2*V2^2,
        C1^(E^-1)      =  C1*C2*D2^2*O2^2*U2^2*V2,
        C1^F           =  C1*N2,
        C1^(F^-1)      =  C1*N2^2*Q2^2,
        C1^G           =  C1*O2*S2^2,
        C1^(G^-1)      =  C1*O2^2*S2,
        C1^H           =  C1*T2^2*U2*V2,
        C1^(H^-1)      =  C1*T2*U2^2*V2^2,
        D1^A           =: D1*O1,
        D1^(A^-1)      =  D1*O1^2*Y1*A2*J2*M2^4*P2*Q2^2,
        D1^B           =  D1*X1*K2*N2*Q2*Y2^2,
        D1^(B^-1)      =  D1*X1*Z1^-1*K2*N2^2*Q2^2*R2*Y2,
        D1^C           =  D1*I2^2*S2^2,
        D1^(C^-1)      =  D1*I2*S2,
        D1^D           =  D1*N2^2*Q2^2,
        D1^(D^-1)      =  D1*N2,
        D1^E           =  D1*O2,
        D1^(E^-1)      =  D1*O2^2,
        D1^F           =  D1*Q2,
        D1^(F^-1)      =  D1*Q2^2,
        D1^G           =  D1,
        D1^(G^-1)      =  D1,
        D1^H           =  D1,
        D1^(H^-1)      =  D1,
        E1^A           =: E1*P1,
        E1^(A^-1)      =  E1*P1^2*B2*Q2^2,
        E1^B           =  E1*R2,
        E1^(B^-1)      =  E1*R2^2,
        E1^C           =  E1*Q1*R1^2*C2*E2^2*F2*O2^2*T2*U2^2*W2,
        E1^(C^-1)      =  E1*Q1^2*R1*C2^2*E2*F2^2*O2*T2^2*U2*W2^2,
        E1^D           =  E1,
        E1^(D^-1)      =  E1,
        E1^E           =  E1*E2*F2^2*T2^2*U2*W2^2,
        E1^(E^-1)      =  E1*E2^2*F2*T2*U2^2*W2,
        E1^F           =  E1*R2,
        E1^(F^-1)      =  E1*R2^2,
        E1^G           =  E1*T2*V2,
        E1^(G^-1)      =  E1*T2^2*V2^2,
        E1^H           =  E1*W2,
        E1^(H^-1)      =  E1*W2^2,
        F1^A           =  F1*I2^2*S2^2,
        F1^(A^-1)      =  F1*I2*S2,
        F1^B           =: F1*Q1,
        F1^(B^-1)      =  F1*Q1^2*E2^2*F2^2*T2^2*V2^2,
        F1^C           =  F1*X2,
        F1^(C^-1)      =  F1*X2^2,
        F1^D           =  F1*C2*U2^2*V2^2,
        F1^(D^-1)      =  F1*C2^2*U2*V2,
        F1^E           =  F1*X2^2,
        F1^(E^-1)      =  F1*X2,
        F1^F           =  F1*S2,
        F1^(F^-1)      =  F1*S2^2,
        F1^G           =  F1,
        F1^(G^-1)      =  F1,
        F1^H           =  F1*X2,
        F1^(H^-1)      =  F1*X2^2,
        G1^A           =: G1*R1,
        G1^(A^-1)      =  G1*R1^2*D2,
        G1^B           =: G1*S1,
        G1^(B^-1)      =  G1*S1^2,
        G1^C           =  G1*G2^2,
        G1^(C^-1)      =  G1*G2,
        G1^D           =  G1*E2^2*F2*T2*U2^2*W2,
        G1^(D^-1)      =  G1*E2*F2^2*T2^2*U2*W2^2,
        G1^E           =  G1*G2^2*Y2,
        G1^(E^-1)      =  G1*G2*Y2^2,
        G1^F           =  G1*T2*U2*V2,
        G1^(F^-1)      =  G1*T2^2*U2^2*V2^2,
        G1^G           =  G1,
        G1^(G^-1)      =  G1,
        G1^H           =  G1*Y2,
        G1^(H^-1)      =  G1*Y2^2,
        H1^A           =: H1*T1,
        H1^(A^-1)      =  H1*T1^2*V1*Y1^3*A2*H2^2*J2*M2^2,
        H1^B           =  H1*Z1*B2,
        H1^(B^-1)      =  H1*Z1^-1*B2^2,
        H1^C           =: H1*U1,
        H1^(C^-1)      =  H1*U1^2,
        H1^D           =  H1*K2*N2^2,
        H1^(D^-1)      =  H1*K2*N2*Q2^2,
        H1^E           =  H1*S2,
        H1^(E^-1)      =  H1*S2^2,
        I1^A           =: I1*V1,
        I1^(A^-1)      =  I1*V1*Y1^2*H2^2*J2*M2^4*Q2,
        I1^B           =  I1*X1*Z1*N2*Q2,
        I1^(B^-1)      =  I1*X1*Z1^-2*N2^2*Q2^2,
        I1^C           =  I1*I2^2,
        I1^(C^-1)      =  I1*I2,
        I1^D           =  I1*K2*Q2^2,
        I1^(D^-1)      =  I1*K2*Q2,
        I1^E           =  I1,
        I1^(E^-1)      =  I1,
        J1^A           =  J1*I2^2,
        J1^(A^-1)      =  J1*I2,
        J1^B           =: J1*W1,
        J1^(B^-1)      =  J1*W1*O2^2*S2,
        J1^C           =  J1,
        J1^(C^-1)      =  J1,
        J1^D           =  J1*L2,
        J1^(D^-1)      =  J1*L2,
        J1^E           =  J1,
        J1^(E^-1)      =  J1,
        K1^A           =  K1*Y1^3*M2^2*P2*Q2^2,
        K1^(A^-1)      =  K1*Y1^2*M2*P2^2*Q2^2,
        K1^B           =: K1*X1,
        K1^(B^-1)      =  K1*X1*Z1^-1*Q2*R2,
        K1^C           =  K1*S2^2,
        K1^(C^-1)      =  K1*S2,
        K1^D           =  K1*N2^2*Q2,
        K1^(D^-1)      =  K1*N2*Q2,
        K1^E           =  K1*O2,
        K1^(E^-1)      =  K1*O2^2,
        L1^A           =  L1*B2^2*N2^2,
        L1^(A^-1)      =  L1*B2*N2*Q2,
        L1^B           =  L1*R2,
        L1^(B^-1)      =  L1*R2^2,
        L1^C           =  L1*C2^2*D2*O2^2*U2*V2^2,
        L1^(C^-1)      =  L1*C2*D2^2*O2*U2^2*V2,
        L1^D           =  L1*R2,
        L1^(D^-1)      =  L1*R2^2,
        L1^E           =  L1*T2*U2^2*V2^2,
        L1^(E^-1)      =  L1*T2^2*U2*V2,
        M1^A           =  M1*S2^2,
        M1^(A^-1)      =  M1*S2,
        M1^B           =  M1*T2*U2^2*V2^2,
        M1^(B^-1)      =  M1*T2^2*U2*V2,
        M1^C           =  M1,
        M1^(C^-1)      =  M1,
        M1^D           =  M1,
        M1^(D^-1)      =  M1,
        M1^E           =  M1,
        M1^(E^-1)      =  M1,
        N1^A           =: N1*Y1,
        N1^(A^-1)      =  N1*Y1^4*M2*Q2,
        N1^B           =: N1*Z1,
        N1^(B^-1)      =  N1*Z1^-1*R2^2,
        N1^C           =  N1*S2,
        N1^(C^-1)      =  N1*S2^2,
        N1^D           =  N1*N2,
        N1^(D^-1)      =  N1*N2^2*Q2^2,
        N1^E           =  N1*O2^2,
        N1^(E^-1)      =  N1*O2,
        O1^A           =: O1*A2,
        O1^(A^-1)      =  O1*A2^2*M2*P2,
        O1^B           =  O1,
        O1^(B^-1)      =  O1,
        O1^C           =  O1,
        O1^(C^-1)      =  O1,
        O1^D           =  O1*Q2^2,
        O1^(D^-1)      =  O1*Q2,
        O1^E           =  O1,
        O1^(E^-1)      =  O1,
        P1^A           =: P1*B2,
        P1^(A^-1)      =  P1*B2^2*Q2,
        P1^B           =  P1*R2,
        P1^(B^-1)      =  P1*R2^2,
        P1^C           =  P1*C2*D2^2*S2*U2^2*V2,
        P1^(C^-1)      =  P1*C2^2*D2*S2^2*U2*V2^2,
        P1^D           =  P1*R2^2,
        P1^(D^-1)      =  P1*R2,
        P1^E           =  P1*T2^2*U2*V2,
        P1^(E^-1)      =  P1*T2*U2^2*V2^2,
        Q1^A           =: Q1*C2,
        Q1^(A^-1)      =  Q1*C2^2*S2,
        Q1^B           =  Q1*E2^2*F2^2*T2^2*V2^2,
        Q1^(B^-1)      =  Q1*E2*F2*T2*V2,
        Q1^C           =  Q1*X2^2,
        Q1^(C^-1)      =  Q1*X2,
        Q1^D           =  Q1*U2*V2,
        Q1^(D^-1)      =  Q1*U2^2*V2^2,
        Q1^E           =  Q1*X2^2,
        Q1^(E^-1)      =  Q1*X2,
        R1^A           =: R1*D2,
        R1^(A^-1)      =  R1*D2^2,
        R1^B           =: R1*E2,
        R1^(B^-1)      =  R1*E2^2*W2^2,
        R1^C           =  R1*X2^2,
        R1^(C^-1)      =  R1*X2,
        R1^D           =  R1*T2^2*U2,
        R1^(D^-1)      =  R1*T2*U2^2,
        R1^E           =  R1*X2^2,
        R1^(E^-1)      =  R1*X2,
        S1^A           =: S1*F2,
        S1^(A^-1)      =  S1*F2^2*V2,
        S1^B           =  S1,
        S1^(B^-1)      =  S1,
        S1^C           =: S1*G2,
        S1^(C^-1)      =  S1*G2^2,
        S1^D           =  S1*W2^2,
        S1^(D^-1)      =  S1*W2,
        S1^E           =  S1*Y2,
        S1^(E^-1)      =  S1*Y2^2,
        T1^A           =: T1*H2,
        T1^(A^-1)      =  T1*H2^2*J2*M2^3*P2,
        T1^B           =  T1*K2*N2^2,
        T1^(B^-1)      =  T1*K2*N2*Q2^2,
        T1^C           =  T1*I2,
        T1^(C^-1)      =  T1*I2^2,
        U1^A           =: U1*I2,
        U1^(A^-1)      =  U1*I2^2,
        U1^B           =  U1*O2*S2^2,
        U1^(B^-1)      =  U1*O2^2*S2,
        U1^C           =  U1,
        U1^(C^-1)      =  U1,
        V1^A           =: V1*J2,
        V1^(A^-1)      =  V1*J2*M2^2,
        V1^B           =: V1*K2,
        V1^(B^-1)      =  V1*K2,
        V1^C           =  V1,
        V1^(C^-1)      =  V1,
        W1^A           =: W1*L2,
        W1^(A^-1)      =  W1*L2,
        W1^B           =  W1,
        W1^(B^-1)      =  W1,
        W1^C           =  W1,
        W1^(C^-1)      =  W1,
        X1^A           =  X1*N2^2*Q2,
        X1^(A^-1)      =  X1*N2*Q2,
        X1^B           =  X1*R2,
        X1^(B^-1)      =  X1*R2^2,
        X1^C           =  X1*O2^2,
        X1^(C^-1)      =  X1*O2,
        Y1^A           =: Y1*M2,
        Y1^(A^-1)      =  Y1*M2^4,
        Y1^B           =  Y1,
        Y1^(B^-1)      =  Y1,
        Y1^C           =  Y1,
        Y1^(C^-1)      =  Y1,
        Z1^A           =: Z1*N2,
        Z1^(A^-1)      =  Z1*N2^2*Q2^2,
        Z1^B           =  Z1*R2^2,
        Z1^(B^-1)      =  Z1*R2,
        Z1^C           =: Z1*O2,
        Z1^(C^-1)      =  Z1*O2^2,
        A2^A           =: A2*P2,
        A2^(A^-1)      =  A2*P2^2,
        A2^B           =  A2*Q2,
        A2^(B^-1)      =  A2*Q2^2,
        A2^C           =  A2,
        A2^(C^-1)      =  A2,
        B2^A           =: B2*Q2,
        B2^(A^-1)      =  B2*Q2^2,
        B2^B           =: B2*R2,
        B2^(B^-1)      =  B2*R2^2,
        B2^C           =  B2*S2,
        B2^(C^-1)      =  B2*S2^2,
        C2^A           =: C2*S2,
        C2^(A^-1)      =  C2*S2^2,
        C2^B           =  C2*U2*V2,
        C2^(B^-1)      =  C2*U2^2*V2^2,
        C2^C           =  C2,
        C2^(C^-1)      =  C2,
        D2^A           =  D2,
        D2^(A^-1)      =  D2,
        D2^B           =: D2*T2,
        D2^(B^-1)      =  D2*T2^2,
        D2^C           =  D2,
        D2^(C^-1)      =  D2,
        E2^A           =: E2*U2,
        E2^(A^-1)      =  E2*U2^2,
        E2^B           =  E2*W2^2,
        E2^(B^-1)      =  E2*W2,
        E2^C           =  E2*X2,
        E2^(C^-1)      =  E2*X2^2,
        F2^A           =: F2*V2,
        F2^(A^-1)      =  F2*V2^2,
        F2^B           =: F2*W2,
        F2^(B^-1)      =  F2*W2^2,
        F2^C           =  F2*X2,
        F2^(C^-1)      =  F2*X2^2,
        G2^A           =: G2*X2,
        G2^(A^-1)      =  G2*X2^2,
        G2^B           =: G2*Y2,
        G2^(B^-1)      =  G2*Y2^2,
        G2^C           =  G2,
        G2^(C^-1)      =  G2 >

#    Class : 10
#    Nr of generators of each class : 3 2 3 3 4 7 11 12 14 18

