
RequirePackage("matrix");

Print("\n");
G := Group([[Z(5)^3]]);
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

Print("\n");
ReadDataPkg( "matrix", "data", "a5xa5d25.gap" );
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

Print("\n");
m1 := [[Z(5)^2,Z(5)^2],[Z(5)^2,Z(5)]];
m2 := [[Z(5),Z(5)^2],[Z(5)*0,Z(5)^3]];
G := Group([m1,m2],m1^0);
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

Print("\n");
G1 := GL(3,4);
G2 := SP(4,4);
m1 := DiagonalMat_mtx(GF(4),G1.1,G2.1);
m2 := DiagonalMat_mtx(GF(4),G1.2,G2.2);
m1[4][1] := Z(4);;
m2[5][2] := Z(4)^0;;
G := Group([m1,m2],m1^0);
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

#Print("\n");
#ReadDataPkg( "matrix", "data", "l281.gap" );
#x := RecognizeMatrixGroup(G);
#SetPrintLevelFlag(x,2);
#DisplayMatRecord(x);

Print("\n");
G := ImprimitiveWreathProduct(GL(3,4),SymmetricGroup(3));
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

Print("\n");
ReadDataPkg( "matrix", "data", "a5d5.gap" );
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

Print("\n");
G1 := GL(2,3);
G2 := SU(3,3);
m1 := DiagonalMat_mtx(GF(3),G1.1,G2.1);
m2 := DiagonalMat_mtx(GF(3),G1.2,G2.2);
m1[3][1] := Z(3);
m2[4][2] := Z(3)^0;
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

Print("\n");
ReadDataPkg( "matrix", "data", "l217.gap" );
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);

Print("\n");
G := ImprimitiveWreathProduct(SL(4,5),SymmetricGroup(3));
x := RecognizeMatrixGroup(G);
SetPrintLevelFlag(x,2);
DisplayMatRecord(x);


# Construct SL(2, 5) wr S2
G := ImprimitiveWreathProduct( SL(2, 5), SymmetricGroup(2) );;
# Apply RecogniseMatrixGroup to G
x := RecogniseMatrixGroup( G );;
DisplayMatRecord( x );
DisplayMatRecord( x, 1 );
# G is imprimitive. The size is the size of the permutation group
# given by action of G on the blocks.
DisplayMatRecord( x, 2 );
# Now we are looking at the decomposition of the kernel of the action.
# Call this kernel K. The module for K splits into an irreducible
# submodule of dimension 2 and a quotient module of dimension 2. The
# restriction of K to the submodule contains SL(2, 5). Call this group K1.
DisplayMatRecord( x, 3 );
# We have now taken relations on K1 and evaluated them in K to get
# a group H. H is the kernel of the homomorphism from K to K1. The group 
# generated by the last 2x2 block on the diagonal of the matrices of H
# has an irreducible module and contains SL(2, 5). Call this group H1.
DisplayMatRecord( x, 4 );
# We have now taken relations on H1 and evaluated them in H to get the
# kernel of the homomorphism from H to H1. It is trivial.

# Construct the group SL(2, 3) x SP(4, 3)
G1 := SL(2, 3);;
G2 := SP(4, 3);;
m1 := DiagonalMat_mtx( GF(3), G1.1, G2.1 );;
m2 := DiagonalMat_mtx( GF(3), G1.2, G2.2 );;
# Put something in the bottom left hand corner to give us a p-group
m1[3][1] := Z(3)^0;;
m2[5][2] := Z(3);;
G := Group( [m1, m2], m1^0 );;
# Apply RecogniseMatrixGroup to G
x := RecogniseMatrixGroup( G );;
# Let us look at what we have found
DisplayMatRecord( x );
DisplayMatRecord( x, 1 );
# The module for G splits into an irreducible submodule of dimension
# 2 and a quotient module of dimension 4. The restriction of G to
# the submodule contains SL(2, 3). Call this group G1.
DisplayMatRecord( x, 2 );
# We have now taken relations on G1 and evaluated them in G to get 
# a group H, which is the kernel of the homomorphism from G to G1. 
# The group generated by the last 4x4 block on the diagonal of the 
# matrices of H  has an irreducible module and we have computed 
# a permutation representation on it. Call this group H1.
DisplayMatRecord( x, 3 );
# We have now taken relations on H1 and evaluated them in H to get the
# kernel of the homomorphism from H to H1. This kernel consists of lower
# uni-triangular matrices. It is a p-group of size 6561.

# Read in a 25-dimensional representation of a5xa5 over GF(7)
ReadDataPkg( "matrix", "data", "a5xa5d25.gap" );
# Test whether G is primitive
prim := IsPrimitive( G );;
# G is imprimitive. Get the permutation representation given by action
# of G on the blocks. Get the correspondence between the generators of
# G and the generators of the permutation group.
prim := prim[2];;
bs := BlockSystemFlag( prim );;
maps := MapsFlag (bs);
P := PermGroupFlag( bs );
# Apply ApproximateKernel
x := ApproximateKernel( G, P, 100, 30, maps );;
# Let us have a look at what we have found
DisplayMatRecord( x );
DisplayMatRecord( x, 1 );
# The kernel K splits into an irreducible submodule of dimension
# 5 and a quotient module of dimension 20. The restriction of K to the
# submodule is imprimitive. Call it K1. The size is the size of the
# permutation group given by action of K1 on the blocks. This 
# action is faithful.
DisplayMatRecord( x, 2 );
# We have taken relations on K1 and evaluated them in K to get the 
# kernel of the homomorphism from K to K1. This kernel is trivial. 
# K has 5 copies of K1 down the diagonal.  
