#############################################################################
##
#A  tbl/cmplxg31.g                 CHEVIE library                 Jean Michel
##
#Y  Copyright (C) 1998 - 2001  The CHEVIE Team
##
##  This file contains data about the complex reflection group
##  of type G31 in the Shephard-Todd classification.
##
CHEVIE.Revision("tbl/cmplxg31.g",
   "$Id: cmplxg31.g,v 1.5 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("PrintDiagram","G31",function(indices,title)local s;
  Print(title," ");s:=String("",Length(title));
  Print(indices[4]," - ",indices[2]," - ",indices[5],"\n",
        s,"  \\ /3\\ /\n",
	s,"   ",indices[1]," - ",indices[3],"     i.e. A_4 on ",
	IntListToString(indices{[1,4,2,5,3]})," plus ",
	IntListToString(indices{[1,2,3]}),"=",
	IntListToString(indices{[2,3,1]}),"=",
	IntListToString(indices{[3,1,2]}),"\n");
end);

CHEVIE.AddData("BraidRelations","G31",[[[1,4,1],[4,1,4]],[[2,4,2],[4,2,4]],
 [[5,3,5],[3,5,3]],[[2,5,2],[5,2,5]],[[1,2,3],[2,3,1]],[[2,3,1],[3,1,2]],
 [[1,5],[5,1]],[[3,4],[4,3]],[[5,4],[4,5]]]);

# For the data relative to this group see
# H.Maschke ``Ueber die quatern\"are, endliche, lineare Substitutionsgruppe der
# Borchardt'schen Moduln'', Math. Ann. 30 (1887) 496--515
#
# The group <T,U> described by Maschke where
# T:=[[ -1, 1,  E(4), -E(4)],   U:=[[ E(4),    0,  0,  0],
#     [  1, 1,  E(4),  E(4)],       [    0, E(4),  0,  0],
#     [ -1, 1, -E(4),  E(4)],       [    0,    0,  1,  0],
#     [  1, 1, -E(4), -E(4)]]/2;    [    0,    0,  0,  1]]/E(8);
# is *not* G31 which is in fact the group <T,U*E(8)>.

CHEVIE.AddData("GeneratingRoots","G31",
 [[E(4),0,0,0],[-1+E(4),-E(4)-1,0,0]/2,[1+E(4),-E(4)-1,0,0]/2,
                   [1,1,1,1]/2,[0,1+E(4),-E(4)-1,0]/2]);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G31",[1/2,1/2,1/2,1/2,1/2]);

CHEVIE.AddData("Size","G31", 46080);

CHEVIE.AddData("ReflectionCoDegrees","G31",[0,12,16,28]);

CHEVIE.AddData("ReflectionDegrees","G31",[8,12,20,24]);

CHEVIE.AddData("ParabolicRepresentatives","G31",# repr. of conj. classes
  function(s)local t;t:=[[[]],[[1]],[[1,4],[1,5],[1..3]],
    [[1,4,5],[2,4,5],[1..4]],[[1..5]]];
    return t[s+1];end);

CHEVIE.AddData("NrConjugacyClasses","G31", 59);

# class 33=ccc4 has square z45 in BW, which gives up to sign its eigenvalues.
# Adding the Schur relations this enables to determine H(W) character values.
# similarly class 24=ccc123 has square z123123 in BW.
# [14]-z->[41] [19]-z->[35]-z->[37]-z->[21]  [21]^2=[41]
CHEVIE.AddData("ClassNames","G31",
 [".","1","34","12","25","254","321","214","231","125", #10
  "354","124","c1c1c1","5314","1243","3241","c1","2121","53142","zc", # 20
  "41352","31314","c","ccc123","523523", #25
  "24z","142142","24zzz","c1c1","4124131", #30
  "354z","354zzz","ccc4","cccc","523524124", #35
  "313141314","253254214","cc","24zz","zzcc", #40
  "4135241352","124zz","ccc", "zccc", "1212124zz", #45
  "1243z","43z","c1c1c1c1","1243zz","1212z", #50
  "1z","1zzz", "12zz","123z", "123zz", #55
  "zcc","z","zzz","zz"]);

CHEVIE.AddData("WordsClassRepresentatives","G31",
 List(CHEVIE.RawData("ClassNames","G31"),x->Replace(x,".",[],"1",[1],"2",
  [2],"3",[3],"4",[4],"5",[5],"z","cccccc","c",[1,2,3,4,5])));

CHEVIE.AddData("ClassInfo","G31",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G31"),
    classnames:=CHEVIE.RawData("ClassNames","G31"),
    classparams:=CHEVIE.RawData("ClassNames","G31"),
    orders:=[1,2,2,4,3,4,4,8,4,6,6,8,20,12,8,8,20,2,12,24,12,4,24,8,4,
 12,4,12,10,4,12,12,8,6,12,2,12,12,6,12,6,8,8,8,8,8,4,5,8,4,4,4,4,4,4,3,4,4,2],
    classes:=[1,60,360,180,640,2880,30,720,30,1920,1920,720,2304,960,720,720,
 2304,30,960,1920,960,720,1920,1440,180,640,180,640,2304,360,1920,1920,2880,
 160,960,60,960,160,640,160,960,720,240,240,720,720,360,2304,720,30,60,60,180,
 30,30,160,1,1,1]));

CHEVIE.AddData("PowerMaps","G31",
 [,[1,1,1,18,5,3,18,27,18,5,5,25,29,34,25,27,29,1,41,40,
   41,18,38,50,18,39,18,39,48,18,39,39,47,56,41,1,41,34,
   5,34,56,25,57,58,27,27,59,48,25,59,59,59,18,18,18,56,59,59,1],
 [1,2,3,4,1,6,9,12,7,36,2,8,17,50,16,15,13,18,54,44,55,
   22,43,24,27,58,25,57,29,30,52,51,33,59,9,36,7,57,59,
   58,18,45,44,43,42,49,47,48,46,50,52,51,53,55,54,1,58,57,59],,
 [1,2,3,4,5,6,7,8,9,10,11,12,58,14,15,16,57,18,19,20,
   21,22,23,24,25,26,27,28,59,30,31,32,33,34,35,36,37,38,
   39,40,41,42,43,44,45,46,47,1,49,50,51,52,53,54,55,56,57,58,59],,
 [1,2,3,4,5,6,9,12,7,10,11,8,17,14,16,15,13,18,21,23,
   19,22,20,24,27,28,25,26,29,30,32,31,33,34,37,36,35,40,
   39,38,41,45,44,43,42,49,47,48,46,50,52,51,53,55,54,56,58,57,59],,,,
 [1,2,3,4,5,6,9,12,7,10,11,8,17,14,16,15,13,18,21,23,
   19,22,20,24,27,28,25,26,29,30,32,31,33,34,37,36,35,40,
   39,38,41,45,44,43,42,49,47,48,46,50,52,51,53,55,54,56,58,57,59],,
 [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
   21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
   39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59],,,,
 [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
   21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
   39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59],,
 [1,2,3,4,5,6,9,12,7,10,11,8,17,14,16,15,13,18,21,23,
   19,22,20,24,27,28,25,26,29,30,32,31,33,34,37,36,35,40,
   39,38,41,45,44,43,42,49,47,48,46,50,52,51,53,55,54,56,58,57,59],,,,
 [1,2,3,4,5,6,9,12,7,10,11,8,17,14,16,15,13,18,21,23,
   19,22,20,24,27,28,25,26,29,30,32,31,33,34,37,36,35,40,
   39,38,41,45,44,43,42,49,47,48,46,50,52,51,53,55,54,56,58,57,59]]);

CHEVIE.AddData("CharInfo","G31",function()local res;
  res:=rec(charparams:=[[1,0],[1,60],[4,37],[4,1],[4,31],[4,7],[5,12],[5,24],
  [5,40],[5,4],[6,14],[6,18],[9,28],[9,8],[10,24],[10,12],[10,30],[10,6],
  [10,26],[10,2],[15,20,1],[15,8,2],[15,8,1],[15,20,2],[16,16],
  [20,14],[20,13,2],[20,13,1],[20,19],[20,7],[20,5],[20,21],[20,3],
  [20,23],[24,6],[24,14],[30,16],[30,4],[30,10,2],[30,10,1],[36,10],
  [36,5],[36,17],[36,7],[36,15],[40,6],[40,18],[40,14],[40,10],[40,9],[40,13],
  [40,7],[40,15],[45,12,1],[45,8,1],[45,12,2],[45,8,2],[64,9],[64,11]],
# The labelling is fixed as follows:
#  phi{15,8}' , phi{15,20}' , phi{45,8}'' occur in phi{4,1} tensor phi{20,7}
# The fakedegree of phi{30,10}' begins q^50+q^46+...
#  phi{20,13}' is complex conjugate from phi{20,7}
#  phi{45,12}' is tensored by sign from phi{45,8}'
  extRefl:=[1,4,11,5,2]);
  res.b:=List(res.charparams,x->x[2]);
  return res;
end);

CHEVIE.AddData("cycpolfakedegrees","G31",
[[1,0],[1,60],[1,37,8,8,24],[1,1,8,24,32],[1,31,8,24,32],[1,7,8,8,24],[1,12,5,
10,20,24],[1,24,5,10,20,24],[1,40,5,10,20],[1,4,5,10,20],[[1,0,1,0,0,0,0,0,2,
0,0,0,0,0,1,0,1],14],[[1,0,0,0,1,0,2,0,1,0,0,0,1],18],[1,28,3,3,6,6,12,12,24],
[1,8,3,3,6,6,12,12,24],[1,24,5,10,16,20],[1,12,5,10,16,20],[1,30,5,10,16,20],
[1,6,5,10,16,20],[1,26,5,10,20,32],[1,2,5,10,20,32],[[1,0,1,0,-1,0,1,0,1],20,
5,10,20],[[1,0,1,0,-1,0,1,0,1],8,5,10,20],[[1,0,1,0,-1,0,1,0,1],8,5,10,20],
[[1,0,1,0,-1,0,1,0,1],20,5,10,20],[1,16,8,8,8,16,24],[1,14,5,8,8,10,20,24],[1,
13,5,8,8,10,20,24,24],[2,13,5,8,10,20,24],[2,19,5,8,10,20,24],[1,7,5,8,8,10,
20,24,24],[1,5,5,8,8,10,20,24],[1,21,5,8,10,16,20,24],[1,3,5,8,10,16,20,24],
[1,23,5,8,8,10,20,24],[[1,0,0,0,1,0,2,0,3,0,3,0,4,0,3,0,3,0,2,0,1,0,0,0,1],6],
[[1,0,3,0,2,0,4,0,4,0,4,0,2,0,3,0,1],14],[[1,0,0,0,1,0,2,0,1,0,0,0,1],16,5,10,
20],[[1,0,0,0,1,0,2,0,1,0,0,0,1],4,5,10,20],[[1,0,1,0,-1,0,1,0,1],10,5,10,16,
20],[[1,0,0,0,1,0,2,0,1,0,0,0,1],10,5,10,20],[1,10,3,3,6,6,8,8,12,12,24,24],
[1,5,3,3,6,6,8,8,12,12,24,24],[1,17,3,3,6,6,8,12,12,16,24],[1,7,3,3,6,6,8,12,
12,16,24],[1,15,3,3,6,6,8,8,12,12,24,24],[1,6,5,8,8,8,10,20,24],[1,18,5,8,8,8,
10,20,24],[[2,0,1,0,2,0,1,0,2],14,5,10,20],[[1,0,1,0,2,0,0,0,2,0,1,0,1],10,5,
10,20],[1,9,5,8,8,8,10,20,24],[1,13,5,8,8,10,16,20,24],[1,7,5,8,8,10,16,20,
24],[1,15,5,8,8,8,10,20,24],[1,12,3,3,5,6,6,10,12,12,20,24],[1,8,3,3,5,6,6,10,
12,12,20,24],[1,12,3,3,5,6,6,10,12,12,20,24],[1,8,3,3,5,6,6,10,12,12,20,24],
[[1,0,1,0,4,0,3,0,3,0,2,0,2],9,8,8,24],[[2,0,2,0,3,0,3,0,4,0,1,0,1],11,8,8,
24]]);

CHEVIE.AddData("SchurModels","G31",rec(
f1_0:=rec(coeff:=1,factor:=0,
vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,4,4,5,5,6,6,7,9,10,12,15]),
f4_1:=rec(coeff:=2,factor:=-3,
vcyc:=[1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,5,5,6,6,8,9,12,12,15,20],root:=1),
f5_4:=rec(coeff:=-1,factor:=-1,vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,4,4,5,6,6,9,12]),
f5_12:=rec(coeff:=1,factor:=-6,vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,4,4,6,6]),
f6_14:=rec(coeff:=30,factor:=-16,
vcyc:=[1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,6,15],root:=1),
f9_8:=rec(coeff:=-1,factor:=-3,vcyc:=[1,1,1,1,1,1,1,1,3,4,4,5,5,10]),
f10_12:=rec(coeff:=2,factor:=-4,vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,6,6]),
f10_2:=rec(coeff:=2,factor:=-4,
vcyc:=[1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,5,6,6,6,6,12,12,14,18],root:=1),
f15_8p:=rec(coeff:=3,factor:=-4,vcyc:=[1,1,1,1,1,1,1,1,3,4,4,9]),
f15_8s:=rec(coeff:=3,factor:=-4,vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,4,4]),
f16_16:=rec(coeff:=4,factor:=-8,vcyc:=[1,1,1,1,3,3,6,6,10]),
f20_14:=rec(coeff:=1,factor:=-10,vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,6,6]),
f20_7:=rec(coeff:=-2,factor:=-6,
vcyc:=[1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,6,6,7,8,9,12,12],root:=1),
f20_3:=rec(coeff:=-2,factor:=-13,
vcyc:=[1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,6,8,12,12,18],root:=1),
f24_6:=rec(coeff:=120,factor:=-16,
vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,6,6,6,6,10,10],root:=1),
f30_4:=rec(coeff:=6,factor:=-4,vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3,12]),
f30_10p:=rec(coeff:=6,factor:=-16,
vcyc:=[1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,9,10,10],root:=1),
f36_10:=rec(coeff:=5,factor:=-8,vcyc:=[1,1,1,1,1,1,1,1,3,3,3,3]),
f36_5:=rec(coeff:=-2,factor:=-10,
vcyc:=[1,1,1,1,2,2,2,2,2,2,2,2,6,8,10,10,14,20],root:=1),
f40_6:=rec(coeff:=2,factor:=-4,vcyc:=[1,1,1,1,3,3,4,4,6,6,12]),
f40_7:=rec(coeff:=2,factor:=-12,
vcyc:=[1,1,1,1,2,2,2,2,2,2,2,2,3,3,6,6,6,6,10,12,12],root:=1),
f40_10:=rec(coeff:=8,factor:=-16,
vcyc:=[2,2,2,2,2,2,2,2,6,6,6,6,10,10,12,12],root:=1),
f45_8p:=rec(coeff:=-1,factor:=-7,vcyc:=[1,1,1,1,1,1,1,1,3,4,4,5]),
f45_8s:=rec(coeff:=-1,factor:=-11,vcyc:=[1,1,1,1,1,1,1,1,4,4,7]),
f64_9:=rec(coeff:=4,factor:=-8,vcyc:=[4,4,6,6,10,12])));

CHEVIE.AddData("SchurData","G31",
[rec(name:="f1_0",order:=[1,2]),rec(name:="f1_0",order:=[2,1]),
 rec(name:="f4_1",order:=[2,1],rootPower:=0),
 rec(name:="f4_1",order:=[1,2],rootPower:=0),
 rec(name:="f4_1",order:=[2,1],rootPower:=1),
 rec(name:="f4_1",order:=[1,2],rootPower:=1),
 rec(name:="f5_12",order:=[1,2]),rec(name:="f5_12",order:=[2,1]),
 rec(name:="f5_4",order:=[2,1]),rec(name:="f5_4",order:=[1,2]),
 rec(name:="f6_14",order:=[1,2],rootPower:=0),
 rec(name:="f6_14",order:=[1,2],rootPower:=1),
 rec(name:="f9_8",order:=[2,1]),rec(name:="f9_8",order:=[1,2]),
 rec(name:="f10_12",order:=[2,1]),rec(name:="f10_12",order:=[1,2]),
 rec(name:="f10_2",order:=[2,1],rootPower:=0),
 rec(name:="f10_2",order:=[1,2],rootPower:=1),
 rec(name:="f10_2",order:=[2,1],rootPower:=1),
 rec(name:="f10_2",order:=[1,2],rootPower:=0),
 rec(name:="f15_8p",order:=[2,1]),rec(name:="f15_8p",order:=[1,2]),
 rec(name:="f15_8s",order:=[1,2]),rec(name:="f15_8s",order:=[2,1]),
 rec(name:="f16_16",order:=[1,2]),rec(name:="f20_14",order:=[1,2]),
 rec(name:="f20_3",order:=[2,1],rootPower:=1),
 rec(name:="f20_3",order:=[1,2],rootPower:=1),
 rec(name:="f20_3",order:=[2,1],rootPower:=0),
 rec(name:="f20_3",order:=[1,2],rootPower:=0),
 rec(name:="f20_7",order:=[1,2],rootPower:=1),
 rec(name:="f20_7",order:=[2,1],rootPower:=1),
 rec(name:="f20_7",order:=[1,2],rootPower:=0),
 rec(name:="f20_7",order:=[2,1],rootPower:=0),
 rec(name:="f24_6",order:=[1,2],rootPower:=0),
 rec(name:="f24_6",order:=[1,2],rootPower:=1),
 rec(name:="f30_4",order:=[2,1]),rec(name:="f30_4",order:=[1,2]),
 rec(name:="f30_10p",order:=[1,2],rootPower:=0),
 rec(name:="f30_10p",order:=[1,2],rootPower:=1),
 rec(name:="f36_10",order:=[1,2]),
 rec(name:="f36_5",order:=[1,2],rootPower:=0),
 rec(name:="f36_5",order:=[2,1],rootPower:=0),
 rec(name:="f36_5",order:=[1,2],rootPower:=1),
 rec(name:="f36_5",order:=[2,1],rootPower:=1),
 rec(name:="f40_6",order:=[1,2]),rec(name:="f40_6",order:=[2,1]),
 rec(name:="f40_10",order:=[1,2],rootPower:=1),
 rec(name:="f40_10",order:=[1,2],rootPower:=0),
 rec(name:="f40_7",order:=[1,2],rootPower:=1),
 rec(name:="f40_7",order:=[2,1],rootPower:=1),
 rec(name:="f40_7",order:=[1,2],rootPower:=0),
 rec(name:="f40_7",order:=[2,1],rootPower:=0),
 rec(name:="f45_8p",order:=[2,1]),rec(name:="f45_8p",order:=[1,2]),
 rec(name:="f45_8s",order:=[1,2]),rec(name:="f45_8s",order:=[2,1]),
 rec(name:="f64_9",order:=[1,2]),rec(name:="f64_9",order:=[1,2])]);

CHEVIE.AddData("FactorizedSchurElement","G31",function(p,para,root)
  local ci,data,r,q,res;
  ci:=Position(CHEVIE.RawData("CharInfo","G31")().charparams,p);
  data:=CHEVIE.RawData("SchurData","G31")[ci];
  r:=CHEVIE.RawData("SchurModels","G31").(data.name);
  q:=para[1]{data.order};q:=q[1]/q[2];
  if IsBound(r.root) then q:=GetRoot(q,2)*(-1)^data.rootPower;fi;
  res:=rec(factor:=Mvp(r.coeff*q^r.factor),
    vcyc:=List(r.vcyc,v->rec(monomial:=q,pol:=CycPol([1,0,v]))),
    operations:=FactorizedSchurElementsOps);
  return FactorizedSchurElementsOps.Simplify(res);
end);

CHEVIE.AddData("SchurElement","G31",function(p,para,root)local ci,data,r,q;
  ci:=Position(CHEVIE.RawData("CharInfo","G31")().charparams,p);
  data:=CHEVIE.RawData("SchurData","G31")[ci];
  r:=CHEVIE.RawData("SchurModels","G31").(data.name);
  q:=para[1]{data.order};q:=q[1]/q[2];
  if IsBound(r.root) then q:=GetRoot(q,2)*(-1)^data.rootPower;fi;
  return r.coeff*q^r.factor*Product(r.vcyc,
    x->Value(CyclotomicPolynomial(Cyclotomics,x),q));
end);

# Computed JM  2006, 2012; some columns contain  unknown entries
CHEVIE.AddData("HeckeCharTable","G31",function(para,root)
  local tbl,x,I,r,p,adj,f1,f6,f7,f9,f11,f14,f16,f17,f21,f23,f25,f26,f27,f31,
    f35,f37,f39,f41,f42,f46,f48,f50,f54,f56,f58;
  x:=GetRoot(-para[1][1]/para[1][2],2);I:=E(4);
  r:=para[1][1]; p:=para[1][2];
  tbl:=rec(
  identifier:="H(G31)",
  size:=46080, order:=46080,
  powermap:=CHEVIE.RawData("PowerMaps","G31"));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","G31"));
  adj:=function(p,x)return Zip(x,List(tbl.classtext,x->(-p)^Length(x)),
    function(x,y)return x*y;end);end;
  f1:=function(r)return List(tbl.classtext,x->r^Length(x));end;
f6:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[4,-1-3*v^2,2*v^2+2*v^4,-v-v^3+2*v^4,v^2+2*v^4,-v^4-v^6,1+3*v+3*v^2+4*v^3+
3*v^4+3*v^5-v^6,v^2+2*v^3+v^4+v^5-v^6,2*v^3-2*v^6,v^3+v^5-v^6,-2*v^4-v^6,v^5-
v^6,v^27,-v^5-v^7,-v^5+v^8,-v^3-2*v^4-3*v^5-3*v^6-3*v^7,v^9,v^2+v^6+2*v^8,-
v^5-v^6,0,v^6+2*v^7+3*v^8+3*v^9+v^10,-v^4-v^5-v^6-v^7-v^8-v^10,0,0,
2*v^7+v^10+v^12,-v^47-2*v^49,v^4+4*v^5+6*v^6+8*v^7+7*v^8+
6*v^9+3*v^10+v^12,-v^137-2*v^139,-v^18,-v^7-2*v^8-3*v^9-2*v^10-2*v^11-v^12-
v^14,2*v^49+v^51,2*v^139+v^141,0,-2*v^30,-v^12-3*v^13-v^14-2*v^15-v^16,v^9+
3*v^10+3*v^11+3*v^12+3*v^13+3*v^14+v^15-v^18,v^8+4*v^9+6*v^10+5*v^11+2*v^12-
3*v^13-4*v^14-5*v^15-2*v^16,2*v^15,v^92+2*v^94,2*v^105,v^12+8*v^13+18*v^14+
28*v^15+31*v^16+26*v^17+15*v^18+6*v^19+v^20,v^95-v^96,0,0,v^96+v^98-v^99-
v^104,v^50-v^53,-2*v^47-2*v^49,-v^36,-v^95+v^98,-v^47-v^51-2*v^53,v^45+3*v^47,
v^135+3*v^137,-v^91-v^93+2*v^94,-2*v^48+2*v^51,2*v^93-2*v^96,-2*v^60,-4*v^45,-
4*v^135,4*v^90]
);end;
f7:=function(r,p)local q;q:=-r/p;return adj(p,
[5,-2+3*q,1-2*q+2*q^2,1-2*q+2*q^2,-2*q+q^2,-q^2,-1-3*q^2+q^3,-q^2,-1-3*q^2+
q^3,q-q^2+q^3,q-q^2+q^3,-q^2,0,q^2+q^4,-q^3,-q^3,0,1+2*q^2+2*q^4,0,0,0,q^5,0,
q^9+q^11-q^12,2*q^3-q^4,-2*q^19+q^20,2*q^3-q^4,-2*q^55+q^56,0,-2*q^3-q^5,
q^19-q^20+q^21,q^55-q^56+q^57,q^9-2*q^10,2*q^12,q^5-q^6,-2*q^3+2*q^6+q^9,
q^5-q^6,2*q^6,-2*q^37+q^38,2*q^42,2*q^6,-q^38,-3*q^9,-3*q^27,
q^38-q^39+q^40-3*q^41+q^42,-q^21,q^18-2*q^19+2*q^20,0,-q^39,q^18+2*q^20+2*q^22,
-2*q^18+3*q^19,-2*q^54+3*q^55,q^36-2*q^37+2*q^38,-q^18-3*q^20+q^21,
-q^36-3*q^38+q^39,2*q^24,5*q^18,5*q^54,5*q^36]
);end;
f9:=function(r,p)local q;q:=-r/p;return adj(p,
[5,-4+q,3-2*q,3-2*q,3-q,-2+q,-2+3*q,-2+q,-2+3*q,-2+2*q,-2+2*q,-2+q,0,1-2*q,1-
2*q,1-2*q,0,3+2*q^2,q,q^7,q,-2-q^2,q,q^4,2-q^2,3*q^6-q^7,2-q^2,3*q^18-q^19,0,-1+
q+q^2,-2*q^6+2*q^7,-2*q^18+2*q^19,-q^3,-q^4,q^2,-2-q^3,q^2,-q^2,3*q^12-q^13,-
q^14,-q^2,-2*q^12+q^13,q^3,q^9,-2*q^12-q^13+2*q^14,q^6-2*q^7,3*q^6-2*q^7,0,
q^12-2*q^13,3*q^6+2*q^8,-4*q^6+q^7,-4*q^18+q^19,3*q^12-2*q^13,-2*q^6+3*q^7,-
2*q^12+3*q^13,-q^8,5*q^6,5*q^18,5*q^12]
);end;
f11:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[6,-3-3*v^2,1+4*v^2+v^4,1+2*v+2*v^3+v^4,1+2*v^2+v^4,-v^2-v^4,1-6*v+6*v^2-
8*v^3+6*v^4-6*v^5+v^6,-v+2*v^2-4*v^3+2*v^4-v^5,-1-4*v^3-v^6,-v-2*v^3-v^5,-
2*v^2-2*v^4,-v-v^5,v^18,2*v^3-v^4+2*v^5,v^3+v^5,-1+3*v-3*v^2+4*v^3-4*v^4+
4*v^5-3*v^6+3*v^7-v^8,v^6,1+2*v^2+2*v^6+v^8,-v^4+v^5-v^6,-v^35,-2*v^3+4*v^4-
5*v^5+4*v^6-2*v^7,-v^2+v^3-2*v^4+2*v^5-2*v^6+v^7-v^8,-v^5,-v^15-v^21,
v^2-2*v^5-2*v^7+v^10,v^30+2*v^32+v^34,3*v^2-6*v^3+8*v^4-12*v^5+
12*v^6-12*v^7+8*v^8-6*v^9+3*v^10,v^90+2*v^92+v^94,v^12,-v^2+2*v^3-2*v^4+3*v^5-
2*v^6+2*v^7-2*v^8+3*v^9-2*v^10+2*v^11-v^12,-2*v^32-2*v^34,-2*v^92-2*v^94,-
v^15-v^17,3*v^20,v^7-3*v^8+v^9-3*v^10+v^11,-v^3+3*v^4-3*v^5+3*v^6-3*v^7+3*v^8-
2*v^9+3*v^10-3*v^11+3*v^12-3*v^13+3*v^14-v^15,-v^4+3*v^5-2*v^6-3*v^7+7*v^8-
11*v^9+7*v^10-3*v^11-2*v^12+3*v^13-v^14,3*v^10,v^60+2*v^62+v^64,3*v^70,2*v^6-
6*v^7+12*v^8-16*v^9+19*v^10-16*v^11+12*v^12-6*v^13+2*v^14,-v^61-v^65,2*v^15,
2*v^45,v^65+2*v^66+2*v^68+v^69,v^33+v^35,v^30+4*v^32+v^34,v^24,v^63+v^65,v^30+
2*v^32+2*v^36+v^38,-3*v^30-3*v^32,-3*v^90-3*v^92,v^60+2*v^61+2*v^63+v^64,-
v^30-4*v^33-v^36,-v^60-4*v^63-v^66,3*v^40,6*v^30,6*v^90,6*v^60]
);end;
f14:=function(r,p)local q;q:=-r/p;return adj(p,
[9,-3+6*q,1-4*q+4*q^2,1-4*q+4*q^2,-3*q+3*q^2,-2*q^2+q^3,3*q-3*q^2+3*q^3,-
2*q^2+q^3,3*q-3*q^2+3*q^3,q-3*q^2+2*q^3,q-3*q^2+2*q^3,-2*q^2+q^3,-q^12,q^2-
2*q^3+q^4,q^2-q^3+q^4,q^2-q^3+q^4,-q^4,1+4*q^2+4*q^4,0,0,0,q^3+2*q^5,0,
q^11-q^12+q^13,
2*q^3-2*q^4+q^6,-3*q^21+3*q^22,2*q^3-2*q^4+q^6,-3*q^61+3*q^62,-q^8,3*q^4-q^5+
q^7,q^21-3*q^22+2*q^23,q^61-3*q^62+2*q^63,-q^10+2*q^11,0,0,-2*q^3+3*q^6+2*q^9,
0,0,-3*q^41+3*q^42,0,0,-2*q^42+q^43,3*q^10,3*q^30,q^42-q^43+q^44-5*q^45+
2*q^46+q^47,q^22-q^23+q^24,q^20-4*q^21+4*q^22,-q^16,q^42-q^43+q^44,q^20+
4*q^22+4*q^24,-3*q^20+6*q^21,-3*q^60+6*q^61,q^40-4*q^41+4*q^42,3*q^21-3*q^22+
3*q^23,3*q^41-3*q^42+3*q^43,0,9*q^20,9*q^60,9*q^40]
);end;
f16:=function(r,p)local q;q:=-r/p;return adj(p,
[10,-4+6*q,1-6*q+3*q^2,1-6*q+3*q^2,1-3*q+3*q^2,q-2*q^2+q^3,3*q-6*q^2+q^3,q-
2*q^2+q^3,3*q-6*q^2+q^3,2*q-4*q^2+q^3,2*q-4*q^2+q^3,q-2*q^2+q^3,0,3*q^2-2*q^3,
2*q^2-2*q^3,2*q^2-2*q^3,0,1+6*q^2+3*q^4,q^3,q^21,q^3,-q^2+2*q^3+q^5,q^3,-q^10-q^12,
-q^2-2*q^4+q^6,q^18-3*q^19+3*q^20,-q^2-2*q^4+q^6,q^54-3*q^55+3*q^56,0,-
q^3+q^4-q^5-q^6,2*q^19-4*q^20+q^21,2*q^55-4*q^56+q^57,q^9-q^10,q^12,q^5,-q^3+
2*q^6+q^9,q^5,q^6,q^36-3*q^37+3*q^38,q^42,q^6,q^37-2*q^38+q^39,-2*q^9,-2*q^27,
-q^37+2*q^38-4*q^41+2*q^42+q^43,2*q^20-2*q^21,q^18-6*q^19+3*q^20,0,2*q^38-
2*q^39,q^18+6*q^20+3*q^22,-4*q^18+6*q^19,-4*q^54+6*q^55,q^36-6*q^37+3*q^38,
3*q^19-6*q^20+q^21,3*q^37-6*q^38+q^39,q^24,10*q^18,10*q^54,10*q^36]
);end;
f17:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[10,-7-3*v^2,5+4*v^2+v^4,4-2*v+2*v^2-2*v^3,4+3*v^2,-2-2*v^2,-1+6*v+3*v^2+
8*v^3+6*v^4+6*v^5+2*v^6,-1+2*v+v^2+3*v^3+2*v^4+v^5,-3-3*v^2+4*v^3,-2+2*v-v^2+
2*v^3,-3-3*v^2-v^4,-1+v-v^2+v^3,0,1-2*v-2*v^3,1+v^2-2*v^3,-1-5*v-4*v^2-6*v^3-
4*v^4-3*v^5-v^6,0,4+2*v^2+2*v^4+2*v^6,-v^4-v^5-v^6,v^21,2+4*v+4*v^2+4*v^3+
2*v^4+v^5,-2-2*v^2-v^3-2*v^4-2*v^5-2*v^6-v^7,v^3,v^9+v^11,
1+v^2+2*v^3-v^4+2*v^5+v^6,4*v^18+3*v^20,1+2*v+6*v^2+10*v^3+11*v^4+
14*v^5+11*v^6+8*v^7+4*v^8+2*v^9+v^10,4*v^54+3*v^56,0,-1-v^2-3*v^3-3*v^4-6*v^5-
4*v^6-3*v^7-v^8,-3*v^18-3*v^20-v^22,-3*v^54-3*v^56-v^58,v^9+v^11,v^12,-v^3-
2*v^4-v^5-2*v^6-v^7,-2+2*v^3+3*v^4+6*v^5+8*v^6+6*v^7+6*v^8+2*v^9+3*v^10,-
2*v^2-3*v^3-2*v^4+5*v^6+9*v^7+8*v^8+6*v^9+2*v^10-v^12-v^13,v^6,4*v^36+3*v^38,
v^42,2+8*v+16*v^2+24*v^3+26*v^4+20*v^5+10*v^6-2*v^7-6*v^8-6*v^9-3*v^10,-v^36+
v^37-v^38+v^39,-2*v^9,-2*v^27,-v^36-v^37+2*v^38-v^39+3*v^40-v^41+v^42+v^44+
v^45,v^18+v^20-2*v^21,5*v^18+4*v^20+v^22,0,v^36+v^38-2*v^39,4*v^18+2*v^20+
2*v^22+2*v^24,-7*v^18-3*v^20,-7*v^54-3*v^56,4*v^36-2*v^37+2*v^38-2*v^39,-
3*v^18-3*v^20+4*v^21,-3*v^36-3*v^38+4*v^39,v^24,10*v^18,10*v^54,10*v^36]
);end;
f21:=function(r,p)local q;q:=-r/p;return adj(p,
[15,-9+6*q,5-8*q+2*q^2,4-2*q+q^2,4-5*q+q^2,-1+3*q-q^2,-12*q+9*q^2-4*q^3,-3*q+
3*q^2-q^3,-4-3*q^2,-1+q,-2+5*q-3*q^2,-1,0,-q^2,1,-1+9*q-9*q^2+3*q^3-q^4,0,4-
4*q+2*q^2-4*q^3+q^4,q-q^2-q^4,q^14,-6*q+8*q^2-3*q^3,-1+3*q-4*q^2+4*q^3-q^4,
q^2,-q^8,1-2*q+2*q^3+2*q^4,4*q^12-5*q^13+q^14,2-8*q+21*q^2-
20*q^3+11*q^4-4*q^5+q^6,4*q^36-5*q^37+q^38,0,-1+2*q-4*q^2+6*q^3-4*q^4+2*q^5,-
2*q^12+5*q^13-3*q^14,-2*q^36+5*q^37-3*q^38,-q^6,3*q^8,4*q^3-5*q^4,-1+6*q^2-
11*q^3+9*q^4-6*q^5+3*q^6-3*q^7,-q-q^2+8*q^4-9*q^5+3*q^6-q^8,3*q^4,4*q^24-
5*q^25+q^26,3*q^28,-4*q+20*q^2-32*q^3+24*q^4-12*q^5+q^6+2*q^7,-q^24,q^6,q^18,-
q^24+3*q^26-5*q^27+3*q^28-q^29,q^12,5*q^12-8*q^13+2*q^14,0,q^24,4*q^12-4*q^13+
2*q^14-4*q^15+q^16,-9*q^12+6*q^13,-9*q^36+6*q^37,4*q^24-2*q^25+q^26,-4*q^12-
3*q^14,-4*q^24-3*q^26,3*q^16,15*q^12,15*q^36,15*q^24]
);end;
f23:=function(r,p)local q;q:=-r/p;return adj(p,
[15,-6+9*q,3-6*q+6*q^2,-4*q+3*q^2,1-5*q+4*q^2,q-2*q^2+2*q^3,4-12*q+6*q^2-
3*q^3,1-3*q+2*q^2-q^3,-6*q^2+q^3,-q^2+q^3,-1+2*q-4*q^2+3*q^3,-q^2,0,-q^2,-q^3,
5*q-9*q^2+6*q^3-3*q^4,0,-4*q+4*q^2-4*q^3+3*q^4,q-q^2+q^3,-q^21,4*q^2-6*q^3+
5*q^4-2*q^5,q-4*q^2+4*q^3-3*q^4+q^5,-q^3,-q^12,-2*q^3+q^4,
q^18-5*q^19+4*q^20,1-4*q+13*q^2-20*q^3+18*q^4-10*q^5+q^6,q^54-5*q^55+4*q^56,0,
6*q^3-8*q^4+5*q^5,-q^18+2*q^19-4*q^20+3*q^21,-q^54+2*q^55-4*q^56+3*q^57,q^9,
3*q^12,5*q^5-4*q^6,-3*q^3+9*q^4-12*q^5+11*q^6-3*q^7+q^9,q^2-5*q^3+6*q^4-3*q^5+
q^6-q^7+2*q^8,3*q^6,q^36-5*q^37+4*q^38,3*q^42,2*q^3-14*q^5+28*q^6-28*q^7+
15*q^8-6*q^9+2*q^10,-q^38,-q^9,-q^27,2*q^38-2*q^39-4*q^41+3*q^42,-q^21,3*q^18-
6*q^19+6*q^20,0,-q^39,-4*q^19+4*q^20-4*q^21+3*q^22,-6*q^18+9*q^19,-6*q^54+
9*q^55,-4*q^37+3*q^38,-6*q^20+q^21,-6*q^38+q^39,3*q^24,15*q^18,15*q^54,
15*q^36]
);end;
f25:=function(r,p)local q;q:=-r/p;return adj(p,
[16,-8+8*q,4-8*q+4*q^2,4-8*q+4*q^2,2-6*q+2*q^2,2*q-2*q^2,-2+6*q-6*q^2+2*q^3,
2*q-2*q^2,-2+6*q-6*q^2+2*q^3,-1+4*q-4*q^2+q^3,-1+4*q-4*q^2+q^3,2*q-2*q^2,q^9,-
2*q+2*q^2-2*q^3,-q+2*q^2-q^3,-q+2*q^2-q^3,q^3,4+8*q^2+4*q^4,0,0,0,-1-q^2+q^3+
q^5,0,0,-2*q^2+4*q^3-2*q^4,2*q^15-6*q^16+2*q^17,-2*q^2+4*q^3-2*q^4,2*q^45-
6*q^46+2*q^47,q^6,q^2-3*q^3+3*q^4-q^5,-q^15+4*q^16-4*q^17+q^18,-q^45+4*q^46-
4*q^47+q^48,0,-2*q^10,-q^4+q^5,-1-5*q^3+5*q^6+q^9,-q^4+q^5,-2*q^5,2*q^30-
6*q^31+2*q^32,-2*q^35,-2*q^5,2*q^31-2*q^32,0,0,-2*q^31+6*q^32-2*q^33+2*q^34-
6*q^35+2*q^36,-q^16+2*q^17-q^18,4*q^15-8*q^16+4*q^17,q^12,-q^31+2*q^32-q^33,
4*q^15+8*q^17+4*q^19,-8*q^15+8*q^16,-8*q^45+8*q^46,4*q^30-8*q^31+4*q^32,-
2*q^15+6*q^16-6*q^17+2*q^18,-2*q^30+6*q^31-6*q^32+2*q^33,-2*q^20,16*q^15,
16*q^45,16*q^30]
);end;
f26:=function(r,p)local q;q:=-r/p;return adj(p,
[20,-10+10*q,4-12*q+4*q^2,2-8*q+2*q^2,4-6*q+4*q^2,-1+3*q-3*q^2+q^3,4-6*q+
6*q^2-4*q^3,1-q+q^2-q^3,6*q-6*q^2,3*q-3*q^2,-1+6*q-6*q^2+q^3,-1+q-q^2+q^3,0,
Unknown(),-q+2*q^2-q^3,-1+5*q-8*q^2+5*q^3-q^4,0,2-4*q+8*q^2-4*q^3+2*q^4,
Unknown(),0,Unknown(),2*q-6*q^2+6*q^3-2*q^4,0,0,1+q^2+q^4+q^6,-4*q^15+
6*q^16-4*q^17,3-6*q+15*q^2-20*q^3+15*q^4-6*q^5+3*q^6,-4*q^45+6*q^46-4*q^47,0,
q-2*q^2+7*q^3-7*q^4+2*q^5-q^6,q^15-6*q^16+6*q^17-q^18,q^45-6*q^46+6*q^47-q^48,
0,2*q^10,Unknown(),3*q^2-6*q^3+9*q^4-9*q^5+6*q^6-3*q^7,Unknown(),-
2*q^5,4*q^30-6*q^31+4*q^32,-2*q^35,Unknown(),-q^30+q^31-q^32+q^33,0,0,-q^30-
q^31+4*q^32-2*q^33+2*q^34-4*q^35+q^36+q^37,q^16-2*q^17+q^18,-4*q^15+12*q^16-
4*q^17,0,-q^31+2*q^32-q^33,-2*q^15+4*q^16-8*q^17+4*q^18-2*q^19,10*q^15-
10*q^16,10*q^45-10*q^46,2*q^30-8*q^31+2*q^32,-6*q^16+6*q^17,6*q^31-6*q^32,
2*q^20,-20*q^15,-20*q^45,20*q^30]
);end;
f27:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[20,-11-9*v^2,6+10*v^2+4*v^4,4+3*v+4*v^2+3*v^3+2*v^4,4+7*v^2+2*v^4,-1-3*v^2-
2*v^4,3-9*v+9*v^2-12*v^3+15*v^4-9*v^5+3*v^6,1-2*v+3*v^2-5*v^3+4*v^4-2*v^5+v^6,
-2-6*v^2-6*v^3-2*v^6,-1-2*v-v^2-3*v^3-v^4-v^5,-2-6*v^2-4*v^4-v^6,-v-v^2-v^3-
v^5,0,Unknown(),v^2+2*v^3+v^5,-3+5*v-7*v^2+7*v^3-11*v^4+6*v^5-7*v^6+3*v^7-v^8,
0,4+5*v^2+4*v^4+5*v^6+2*v^8,Unknown(),0,Unknown(),-1-3*v^2+v^3-5*v^4+3*v^5-
5*v^6+2*v^7-2*v^8,0,0,v^2-2*v^3+v^4-2*v^5-v^6-2*v^7+v^10,-4*v^27-
7*v^29-2*v^31,1-2*v+10*v^2-10*v^3+21*v^4-18*v^5+25*v^6-16*v^7+18*v^8-8*v^9+
6*v^10+v^12,-4*v^81-7*v^83-2*v^85,0,-v^2+3*v^3-5*v^4+6*v^5-8*v^6+4*v^7-5*v^8+
3*v^9-2*v^10+2*v^11-v^12,2*v^27+6*v^29+4*v^31+v^33,2*v^81+6*v^83+4*v^85+v^87,
0,-4*v^18,Unknown(),-1-2*v^3+6*v^4-6*v^5+11*v^6-6*v^7+12*v^8-3*v^9+
9*v^10-3*v^11+8*v^12-3*v^13+3*v^14-v^15,Unknown(),4*v^9,4*v^54+7*v^56+2*v^58,
4*v^63,Unknown(),-v^55-v^56-v^57-v^59,0,0,v^55+2*v^56+v^57+4*v^58+v^59+3*v^60+
5*v^62+3*v^64,-v^29-2*v^30-v^32,-6*v^27-10*v^29-4*v^31,0,v^56+2*v^57+v^59,-
4*v^27-5*v^29-4*v^31-5*v^33-2*v^35,11*v^27+9*v^29,11*v^81+9*v^83,4*v^54+
3*v^55+4*v^56+3*v^57+2*v^58,2*v^27+6*v^29+6*v^30+2*v^33,-2*v^54-6*v^56-6*v^57-
2*v^60,-4*v^36,-20*v^27,-20*v^81,20*v^54]
);end;
f31:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[20,-7-13*v^2,2+10*v^2+8*v^4,-v+4*v^2-v^3+6*v^4,1+6*v^2+7*v^4,-v^2-4*v^4-
3*v^6,5+3*v+15*v^2+4*v^3+9*v^4+3*v^5+v^6,1+v+4*v^2+v^3+3*v^4+v^5-v^6,2*v^3-
6*v^4-4*v^6,v^3-2*v^4+v^5-2*v^6,-3*v^2-7*v^4-4*v^6,v^3-v^4-2*v^6,0,Unknown(),-
v^5+2*v^6+v^8,-4*v^2-2*v^3-11*v^4-3*v^5-9*v^6-2*v^7-3*v^8,0,5*v^2+4*v^4+5*v^6+
6*v^8,Unknown(),0,Unknown(),-v^2-v^3-5*v^4-v^5-6*v^6-4*v^8-2*v^10,0,0,
v^6+v^8+2*v^9+2*v^10+2*v^12,-v^39-6*v^41-7*v^43,1+3*v^2+2*v^3+12*v^4+4*v^5+
27*v^6+6*v^7+27*v^8+4*v^9+13*v^10+2*v^11+3*v^12,-v^117-6*v^119-7*v^121,0,-
5*v^6-2*v^7-10*v^8-3*v^9-7*v^10-v^11-3*v^12-v^14,3*v^41+7*v^43+4*v^45,3*v^119+
7*v^121+4*v^123,0,2*v^26,Unknown(),3*v^6+6*v^8+v^9+15*v^10+3*v^11+
13*v^12+3*v^13+9*v^14+v^15-2*v^18,Unknown(),-2*v^13,v^78+6*v^80+7*v^82,-
2*v^91,Unknown(),v^81-v^82-2*v^84,0,0,2*v^82+v^83+4*v^84+2*v^86+3*v^88-v^89+
2*v^90-v^91-2*v^92,v^44-2*v^45-v^47,-2*v^39-10*v^41-8*v^43,0,-v^83+2*v^84+
v^86,-5*v^41-4*v^43-5*v^45-6*v^47,7*v^39+13*v^41,7*v^117+13*v^119,-v^79+
4*v^80-v^81+6*v^82,-2*v^42+6*v^43+4*v^45,2*v^81-6*v^82-4*v^84,2*v^52,-20*v^39,
-20*v^117,20*v^78]
);end;
f35:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[24,-12-12*v^2,6+12*v^2+6*v^4,2+4*v+4*v^2+4*v^3+2*v^4,4+8*v^2+4*v^4,-1-3*v^2-
3*v^4-v^6,7-12*v+21*v^2-16*v^3+21*v^4-12*v^5+7*v^6,2-3*v+6*v^2-6*v^3+6*v^4-
3*v^5+2*v^6,-1-3*v^2-8*v^3-3*v^4-v^6,-2*v-4*v^3-2*v^5,-2-6*v^2-6*v^4-2*v^6,-v-
2*v^3-v^5,-v^18,Unknown(),2*v^3+2*v^5,-3+5*v-12*v^2+9*v^3-18*v^4+9*v^5-12*v^6+
5*v^7-3*v^8,-v^6,2+8*v^2+4*v^4+8*v^6+2*v^8,Unknown(),v^35,Unknown(),-4*v^2+
2*v^3-8*v^4+4*v^5-8*v^6+2*v^7-4*v^8,v^5,-v^15-v^17-v^19-v^21,
v^2-2*v^3+2*v^4-2*v^5+2*v^6-2*v^7+2*v^8-2*v^9+v^10,
4*v^30+8*v^32+4*v^34,2-2*v+13*v^2-12*v^3+32*v^4-22*v^5+
42*v^6-22*v^7+32*v^8-12*v^9+13*v^10-2*v^11+2*v^12,4*v^90+8*v^92+4*v^94,-v^12,-
v^2+3*v^3-6*v^4+6*v^5-13*v^6+6*v^7-13*v^8+6*v^9-6*v^10+3*v^11-v^12,-2*v^30-
6*v^32-6*v^34-2*v^36,-2*v^90-6*v^92-6*v^94-2*v^96,-2*(v^17+v^15),3*v^20,
Unknown(),
-2*v^3+6*v^4-6*v^5+12*v^6-6*v^7+18*v^8-4*v^9+18*v^10-6*v^11+12*v^12-6*v^13+
6*v^14-2*v^15,Unknown(),3*v^10,4*v^60+8*v^62+4*v^64,3*v^70,Unknown(),-v^61-
2*v^63-v^65,4*v^15,4*v^45,v^61+v^62+v^63+3*v^64+4*v^66+4*v^68+3*v^70+v^71+
v^72+v^73,2*v^33+2*v^35,6*v^30+12*v^32+6*v^34,-v^24,2*v^63+2*v^65,2*v^30+
8*v^32+4*v^34+8*v^36+2*v^38,-12*v^30-12*v^32,-12*v^90-12*v^92,2*v^60+4*v^61+
4*v^62+4*v^63+2*v^64,-v^30-3*v^32-8*v^33-3*v^34-v^36,-v^60-3*v^62-8*v^63-
3*v^64-v^66,3*v^40,24*v^30,24*v^90,24*v^60]
);end;
f37:=function(r,p)local q;q:=-r/p;return adj(p,
[30,-18+12*q,11-14*q+5*q^2,7-6*q+q^2,8-10*q+2*q^2,-3+5*q-2*q^2,3-18*q+21*q^2-
8*q^3,1-5*q+6*q^2-2*q^3,-5+6*q-3*q^2,-2+2*q,-5+9*q-5*q^2+q^3,-1+q,0,Unknown(),
1-q,-4+15*q-18*q^2+8*q^3-q^4,0,7-8*q+6*q^2-8*q^3+q^4,Unknown(),-q^14,
Unknown(),-2+6*q-8*q^2+8*q^3-2*q^4,-q^2,-q^6-q^8,
1-2*q+q^2+2*q^4,8*q^12-10*q^13+2*q^14,
3-18*q+39*q^2-40*q^3+24*q^4-8*q^5+2*q^6,8*q^36-10*q^37+2*q^38,
0,-1+2*q-9*q^2+14*q^3-10*q^4+2*q^5,-5*q^12+9*q^13-5*q^14+q^15,-5*q^36+9*q^37-
5*q^38+q^39,q^7-q^6,-3*q^8,Unknown(),-2+9*q^2-22*q^3+21*q^4-15*q^5+6*q^6-
3*q^7,Unknown(),-3*q^4,8*q^24-10*q^25+2*q^26,-3*q^28,Unknown(),-q^24+q^25,
2*q^6,2*q^18,-q^24-3*q^25+7*q^26-5*q^27+5*q^28-3*q^29,q^12-q^13,11*q^12-
14*q^13+5*q^14,0,q^24-q^25,7*q^12-8*q^13+6*q^14-8*q^15+q^16,-18*q^12+12*q^13,-
18*q^36+12*q^37,7*q^24-6*q^25+q^26,-5*q^12+6*q^13-3*q^14,-5*q^24+6*q^25-
3*q^26,-3*q^16,30*q^12,30*q^36,30*q^24]
);end;
f39:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[30,-15-15*v^2,7+16*v^2+7*v^4,3+2*v+4*v^2+2*v^3+3*v^4,5+10*v^2+5*v^4,-1-4*v^2-
4*v^4-v^6,8-6*v+27*v^2-8*v^3+27*v^4-6*v^5+8*v^6,2-2*v+8*v^2-2*v^3+8*v^4-2*v^5+
2*v^6,-2-3*v^2-4*v^3-3*v^4-2*v^6,-v-2*v^3-v^5,-2-8*v^2-8*v^4-2*v^6,-2*v^3,0,
Unknown(),v^3+v^5,-4+2*v-15*v^2+5*v^3-22*v^4+5*v^5-15*v^6+2*v^7-4*v^8,0,3+
10*v^2+4*v^4+10*v^6+3*v^8,Unknown(),-v^35,Unknown(),-5*v^2+v^3-10*v^4+2*v^5-
10*v^6+v^7-5*v^8,-v^5,-v^17-v^19,2*v^2-2*v^3+2*v^4+2*v^6+2*v^8-2*v^9+2*v^10,
5*v^30+10*v^32+5*v^34,2-2*v+16*v^2-6*v^3+40*v^4-10*v^5+54*v^6-10*v^7+40*v^8-
6*v^9+16*v^10-2*v^11+2*v^12,5*v^90+10*v^92+5*v^94,0,-2*v^2+v^3-8*v^4+3*v^5-
15*v^6+4*v^7-15*v^8+3*v^9-8*v^10+v^11-2*v^12,-2*v^30-8*v^32-8*v^34-2*v^36,-
2*v^90-8*v^92-8*v^94-2*v^96,-(v^17+v^15),-3*v^20,Unknown(),-v^3+9*v^4-3*v^5+
15*v^6-3*v^7+21*v^8-2*v^9+21*v^10-3*v^11+15*v^12-3*v^13+9*v^14-v^15,Unknown(),
-3*v^10,5*v^60+10*v^62+5*v^64,-3*v^70,Unknown(),-2*v^63,2*v^15,2*v^45,v^61+
v^62+v^63+3*v^64-v^65+6*v^66+6*v^68-v^69+3*v^70+v^71+v^72+v^73,v^33+v^35,
7*v^30+16*v^32+7*v^34,0,v^63+v^65,3*v^30+10*v^32+4*v^34+10*v^36+3*v^38,-
15*v^30-15*v^32,-15*v^90-15*v^92,3*v^60+2*v^61+4*v^62+2*v^63+3*v^64,-2*v^30-
3*v^32-4*v^33-3*v^34-2*v^36,-2*v^60-3*v^62-4*v^63-3*v^64-2*v^66,-3*v^40,
30*v^30,30*v^90,30*v^60]
);end;
f41:=function(r,p)local q;q:=-r/p;return adj(p,
[36,-18+18*q,10-16*q+10*q^2,2-8*q+2*q^2,6-12*q+6*q^2,-2+4*q-4*q^2+2*q^3,12-
30*q+30*q^2-12*q^3,4-8*q+8*q^2-4*q^3,6*q-6*q^2,0,-4+8*q-8*q^2+4*q^3,0,-q^9,
Unknown(),0,-4+18*q-28*q^2+18*q^3-4*q^4,-q^3,2-12*q+8*q^2-12*q^3+2*q^4,
Unknown(),0,Unknown(),6*q-12*q^2+12*q^3-6*q^4,0,0,4*q^2-4*q^3+4*q^4,-
6*q^15+12*q^16-6*q^17,4-20*q+48*q^2-60*q^3+48*q^4-20*q^5+4*q^6,-6*q^45+
12*q^46-6*q^47,q^6,-8*q^2+22*q^3-22*q^4+8*q^5,4*q^15-8*q^16+8*q^17-4*q^18,
4*q^45-8*q^46+8*q^47-4*q^48,0,0,Unknown(),6*q^2-18*q^3+30*q^4-30*q^5+
18*q^6-6*q^7,Unknown(),0,6*q^30-12*q^31+6*q^32,0,Unknown(),0,0,0,-2*q^31+
6*q^32-4*q^33+4*q^34-6*q^35+2*q^36,0,-10*q^15+16*q^16-10*q^17,q^12,0,-2*q^15+
12*q^16-8*q^17+12*q^18-2*q^19,18*q^15-18*q^16,18*q^45-18*q^46,2*q^30-8*q^31+
2*q^32,-6*q^16+6*q^17,6*q^31-6*q^32,0,-36*q^15,-36*q^45,36*q^30]
);end;
f42:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[36,-15-21*v^2,6+18*v^2+12*v^4,2+3*v+8*v^2+3*v^3+8*v^4,3+12*v^2+9*v^4,-3*v^2-
6*v^4-3*v^6,9-9*v+21*v^2-12*v^3+21*v^4-9*v^5+3*v^6,2-2*v+7*v^2-4*v^3+5*v^4-
3*v^5+v^6,-6*v^2-6*v^3-6*v^4-6*v^6,-v-v^2-3*v^3-3*v^4-2*v^5-2*v^6,-1-7*v^2-
11*v^4-5*v^6,-2*v^3-2*v^4-v^5-v^6,-v^21,Unknown(),v^3+v^4+2*v^5+v^6+v^8,-2+
2*v-9*v^2+6*v^3-19*v^4+8*v^5-17*v^6+5*v^7-4*v^8,-v^7,2+9*v^2+8*v^4+9*v^6+
8*v^8,Unknown(),0,Unknown(),-3*v^2+v^3-9*v^4+3*v^5-10*v^6+2*v^7-6*v^8-2*v^10,
0,0,-2*v^3+2*v^4-2*v^7-2*v^9+3*v^10+v^12,-3*v^35-12*v^37-9*v^39,2-2*v+
10*v^2-6*v^3+27*v^4-14*v^5+46*v^6-18*v^7+43*v^8-12*v^9+19*v^10-2*v^11+3*v^12,-
3*v^105-12*v^107-9*v^109,v^14,v^3-4*v^4+3*v^5-11*v^6+5*v^7-14*v^8+6*v^9-
9*v^10+3*v^11-3*v^12-v^14,v^35+7*v^37+11*v^39+5*v^41,v^105+7*v^107+11*v^109+
5*v^111,0,0,Unknown(),-v^3+3*v^4-3*v^5+11*v^6-3*v^7+15*v^8-3*v^9+
24*v^10-6*v^11+21*v^12-6*v^13+12*v^14-2*v^15-2*v^18,Unknown(),0,3*v^70+
12*v^72+9*v^74,0,Unknown(),-2*v^73-2*v^74-v^75-v^76,0,0,v^71+v^72+v^73+4*v^74-
v^75+6*v^76+6*v^78+8*v^80+v^81+3*v^82+v^83-v^84,-v^38-v^39-2*v^40-v^41-v^43,-
6*v^35-18*v^37-12*v^39,v^28,v^73+v^74+2*v^75+v^76+v^78,-2*v^35-9*v^37-8*v^39-
9*v^41-8*v^43,15*v^35+21*v^37,15*v^105+21*v^107,2*v^70+3*v^71+8*v^72+3*v^73+
8*v^74,6*v^37+6*v^38+6*v^39+6*v^41,-6*v^72-6*v^73-6*v^74-6*v^76,0,-36*v^35,-
36*v^105,36*v^70]
);end;
f46:=function(r,p)local q;q:=-r/p;return adj(p,
[40,-16+24*q,6-20*q+14*q^2,2-12*q+10*q^2,3-13*q+11*q^2,3*q-7*q^2+4*q^3,8-18*q+
12*q^2-2*q^3,2-5*q+3*q^2,6*q-12*q^2+6*q^3,2*q-6*q^2+3*q^3,-1+7*q-13*q^2+6*q^3,
q-3*q^2+2*q^3,0,Unknown(),2*q^2-3*q^3+q^4,-1+8*q-16*q^2+13*q^3-4*q^4,0,2-8*q+
12*q^2-8*q^3+10*q^4,Unknown(),0,Unknown(),2*q-9*q^2+10*q^3-6*q^4+3*q^5,0,
0,q^2-q^4-2*q^5+2*q^6,-3*q^18+13*q^19-11*q^20,2-8*q+23*q^2-40*q^3+
37*q^4-18*q^5+4*q^6,-3*q^54+13*q^55-11*q^56,0,-2*q^2+9*q^3-13*q^4+8*q^5-3*q^6+
q^7,q^18-7*q^19+13*q^20-6*q^21,q^54-7*q^55+13*q^56-6*q^57,0,-2*q^12,
Unknown(),3*q^2-7*q^3+15*q^4-21*q^5+24*q^6-9*q^7+3*q^9,Unknown(),2*q^6,3*q^36-
13*q^37+11*q^38,2*q^42,Unknown(),q^37-3*q^38+2*q^39,0,0,-q^37+5*q^38-5*q^39+
5*q^40-11*q^41+5*q^42+2*q^43,-2*q^20+3*q^21-q^22,-6*q^18+20*q^19-14*q^20,0,
2*q^38-3*q^39+q^40,-2*q^18+8*q^19-12*q^20+8*q^21-10*q^22,16*q^18-24*q^19,
16*q^54-24*q^55,2*q^36-12*q^37+10*q^38,-6*q^19+12*q^20-6*q^21,6*q^37-12*q^38+
6*q^39,-2*q^24,-40*q^18,-40*q^54,40*q^36]
);end;
f48:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[40,-20-20*v^2,10+20*v^2+10*v^4,6-4*v+12*v^2-4*v^3+6*v^4,6+14*v^2+6*v^4,-1-
5*v^2-5*v^4-v^6,5+12*v+15*v^2+16*v^3+15*v^4+12*v^5+5*v^6,2+3*v+4*v^2+6*v^3+
4*v^4+3*v^5+2*v^6,-3-9*v^2+8*v^3-9*v^4-3*v^6,-1+2*v-4*v^2+4*v^3-4*v^4+2*v^5-
v^6,-3-10*v^2-10*v^4-3*v^6,v-2*v^2+2*v^3-2*v^4+v^5,0,Unknown(),v^2-2*v^3+
2*v^4-2*v^5+v^6,-3-5*v-11*v^2-9*v^3-16*v^4-9*v^5-11*v^6-5*v^7-3*v^8,0,6+8*v^2+
12*v^4+8*v^6+6*v^8,Unknown(),v^35,Unknown(),-1-4*v^2-2*v^3-9*v^4-4*v^5-9*v^6-
2*v^7-4*v^8-v^10,v^5,-v^15-v^17-v^19-v^21,
v^2+2*v^3+2*v^5-2*v^6+2*v^7+2*v^9+v^10,6*v^30+
14*v^32+6*v^34,2+2*v+13*v^2+12*v^3+30*v^4+22*v^5+38*v^6+22*v^7+30*v^8+12*v^9+
13*v^10+2*v^11+2*v^12,6*v^90+14*v^92+6*v^94,0,-v^2-3*v^3-5*v^4-6*v^5-10*v^6-
6*v^7-10*v^8-6*v^9-5*v^10-3*v^11-v^12,-3*v^30-10*v^32-10*v^34-3*v^36,-3*v^90-
10*v^92-10*v^94-3*v^96,-2*(v^17+v^15),v^20,Unknown(),-1+2*v^3+6*v^4+6*v^5+17*v^6+
6*v^7+18*v^8+4*v^9+18*v^10+6*v^11+17*v^12+6*v^13+6*v^14+2*v^15-v^18,Unknown(),
v^10,6*v^60+14*v^62+6*v^64,v^70,Unknown(),v^61-2*v^62+2*v^63-2*v^64+v^65,
4*v^15,4*v^45,-v^61+3*v^62-v^63+9*v^64+6*v^66+6*v^68+9*v^70-v^71+3*v^72-v^73,
v^32-2*v^33+2*v^34-2*v^35+v^36,10*v^30+20*v^32+10*v^34,0,v^62-2*v^63+2*v^64-
2*v^65+v^66,6*v^30+8*v^32+12*v^34+8*v^36+6*v^38,-20*v^30-20*v^32,-20*v^90-
20*v^92,6*v^60-4*v^61+12*v^62-4*v^63+6*v^64,-3*v^30-9*v^32+8*v^33-9*v^34-
3*v^36,-3*v^60-9*v^62+8*v^63-9*v^64-3*v^66,v^40,40*v^30,40*v^90,40*v^60]
);end;
f50:=function(r,p,sgn)local v;v:=sgn*GetRoot(r/p,2);return adj(p,
[40,-18-22*v^2,8+20*v^2+12*v^4,2-2*v+12*v^2-2*v^3+6*v^4,5+13*v^2+9*v^4,-1-
4*v^2-6*v^4-3*v^6,10+6*v+24*v^2+8*v^3+18*v^4+6*v^5+8*v^6,3+v+6*v^2+3*v^3+
5*v^4+2*v^5+2*v^6,-6*v^2+4*v^3-12*v^4-2*v^6,v-2*v^2+2*v^3-4*v^4+v^5-v^6,-2-
9*v^2-11*v^4-5*v^6,-v^2+v^3-2*v^4+v^5-v^6,0,Unknown(),-v^3+2*v^4-v^5+2*v^6,-2-
2*v-13*v^2-4*v^3-21*v^4-5*v^5-15*v^6-3*v^7-5*v^8,0,2+10*v^2+12*v^4+10*v^6+
6*v^8,Unknown(),0,Unknown(),-4*v^2-11*v^4-2*v^5-12*v^6-2*v^7-6*v^8-v^10,0,
0,2*v^3+v^4+3*v^6+2*v^7+2*v^8+v^10+v^12,5*v^33+13*v^35+9*v^37,3+2*v+
13*v^2+4*v^3+34*v^4+10*v^5+51*v^6+12*v^7+43*v^8+8*v^9+20*v^10+4*v^12,5*v^99+
13*v^101+9*v^103,0,-v^3-4*v^4-3*v^5-15*v^6-3*v^7-18*v^8-3*v^9-9*v^10-2*v^11-
2*v^12,-2*v^33-9*v^35-11*v^37-5*v^39,-2*v^99-9*v^101-11*v^103-5*v^105,
0,-2*v^22,Unknown(),v^3+3*v^4+3*v^5+13*v^6+3*v^7+21*v^8+2*v^9+27*v^10+
3*v^11+20*v^12+3*v^13+9*v^14+v^15-v^18,Unknown(),-2*v^11,5*v^66+13*v^68+
9*v^70,-2*v^77,Unknown(),-v^68+v^69-2*v^70+v^71-v^72,0,0,-v^67+2*v^68-v^69+
7*v^70+5*v^72+3*v^74+8*v^76+4*v^78-v^80,-v^36+2*v^37-v^38+2*v^39,8*v^33+
20*v^35+12*v^37,0,-v^69+2*v^70-v^71+2*v^72,2*v^33+10*v^35+12*v^37+10*v^39+
6*v^41,-18*v^33-22*v^35,-18*v^99-22*v^101,2*v^66-2*v^67+12*v^68-2*v^69+6*v^70,
-6*v^35+4*v^36-12*v^37-2*v^39,-6*v^68+4*v^69-12*v^70-2*v^72,-2*v^44,40*v^33,
40*v^99,40*v^66]
);end;
f54:=function(r,p)local q;q:=-r/p;return adj(p,
[45,-24+21*q,13-22*q+10*q^2,6-12*q+3*q^2,9-15*q+6*q^2,-3+6*q-5*q^2+q^3,9-27*q+
27*q^2-12*q^3,3-7*q+8*q^2-3*q^3,-3+9*q-9*q^2,-1+3*q-2*q^2,-5+12*q-10*q^2+
3*q^3,2*q-q^2,0,Unknown(),-q+2*q^2,-5+20*q-25*q^2+15*q^3-4*q^4,0,6-12*q+
12*q^2-12*q^3+3*q^4,Unknown(),0,Unknown(),-1+7*q-13*q^2+13*q^3-5*q^4,0,
q^7-q^8+q^9,-2*q-4*q^3+3*q^4,9*q^14-15*q^15+6*q^16,
3-22*q+51*q^2-62*q^3+42*q^4-
18*q^5+3*q^6,9*q^42-15*q^43+6*q^44,0,2*q-9*q^2+21*q^3-17*q^4+8*q^5,-5*q^14+
12*q^15-10*q^16+3*q^17,-5*q^42+12*q^43-10*q^44+3*q^45,
-2*q^8+q^7,0,Unknown(),-
1+9*q^2-24*q^3+30*q^4-27*q^5+16*q^6-6*q^7,Unknown(),0,9*q^28-15*q^29+6*q^30,0,
Unknown(),2*q^29-q^30,-3*q^7,-3*q^21,-4*q^29+10*q^30-6*q^31+4*q^32-6*q^33+
3*q^34,-q^15+2*q^16,13*q^14-22*q^15+10*q^16,0,-q^29+2*q^30,6*q^14-12*q^15+
12*q^16-12*q^17+3*q^18,-24*q^14+21*q^15,-24*q^42+21*q^43,6*q^28-12*q^29+
3*q^30,-3*q^14+9*q^15-9*q^16,-3*q^28+9*q^29-9*q^30,0,45*q^14,45*q^42,45*q^28]
);end;
f56:=function(r,p)local q;q:=-r/p;return adj(p,
[45,-24+21*q,12-24*q+9*q^2,7-10*q+4*q^2,9-15*q+6*q^2,-2+7*q-5*q^2+q^3,9-24*q+
33*q^2-9*q^3,2-8*q+8*q^2-3*q^3,-3+12*q-3*q^2+3*q^3,-1+3*q-2*q^2,-4+13*q-
11*q^2+2*q^3,-1+q-q^2,0,Unknown(),-2*q+q^2,-6+17*q-26*q^2+17*q^3-3*q^4,0,7-
12*q+10*q^2-12*q^3+4*q^4,Unknown(),0,Unknown(),-1+7*q-13*q^2+13*q^3-5*q^4,0,
q^7+q^9-q^10,1-2*q+3*q^2+q^4-2*q^5,9*q^14-15*q^15+6*q^16,4-22*q+50*q^2-62*q^3+
44*q^4-16*q^5+3*q^6,9*q^42-15*q^43+6*q^44,0,3*q-11*q^2+20*q^3-15*q^4+6*q^5-
2*q^6,-4*q^14+13*q^15-11*q^16+2*q^17,-4*q^42+13*q^43-11*q^44+2*q^45,-q^8+2*q^7,
0,Unknown(),-1+12*q^2-24*q^3+27*q^4-24*q^5+16*q^6-9*q^7,Unknown(),0,9*q^28-
15*q^29+6*q^30,0,Unknown(),-q^28+q^29-q^30,-3*q^7,-3*q^21,-q^28-3*q^29+7*q^30-
7*q^31+9*q^32-7*q^33+q^34,-2*q^15+q^16,12*q^14-24*q^15+9*q^16,0,-2*q^29+q^30,
7*q^14-12*q^15+10*q^16-12*q^17+4*q^18,-24*q^14+21*q^15,-24*q^42+21*q^43,
7*q^28-10*q^29+4*q^30,-3*q^14+12*q^15-3*q^16+3*q^17,-3*q^28+12*q^29-3*q^30+
3*q^31,0,45*q^14,45*q^42,45*q^28]
);end;
f58:=function(r,p,I)local q;q:=-r/p;return adj(p,
[64,-32+32*q,16-32*q+16*q^2,8-16*q+8*q^2,10-22*q+10*q^2,-2+8*q-8*q^2+2*q^3,12-
36*q+36*q^2-12*q^3,4-10*q+10*q^2-4*q^3,-4+12*q-12*q^2+4*q^3,-1+4*q-4*q^2+q^3,-
5+16*q-16*q^2+5*q^3,2*q-2*q^2,I*q^9,Unknown(),-q+2*q^2-q^3,-6+23*q-34*q^2+
23*q^3-6*q^4,-I*q^3,8-16*q+16*q^2-16*q^3+8*q^4,Unknown(),0,Unknown(),-1+
8*q-17*q^2+17*q^3-8*q^4+q^5,0,0,-2*q+2*q^2+2*q^4-2*q^5,10*I*q^15-
22*I*q^16+10*I*q^17,4-26*q+62*q^2-80*q^3+62*q^4-26*q^5+4*q^6,-
10*I*q^45+22*I*q^46-10*I*q^47,q^6,2*q-11*q^2+23*q^3-23*q^4+11*q^5-
2*q^6,-5*I*q^15+16*I*q^16-16*I*q^17+5*I*q^18,5*I*q^45-
16*I*q^46+16*I*q^47-5*I*q^48,0,-4*q^10,Unknown(),-1+12*q^2-
29*q^3+36*q^4-36*q^5+29*q^6-12*q^7+q^9,Unknown(),-4*I*q^5,-10*q^30+22*q^31-
10*q^32,4*I*q^35,Unknown(),-2*q^31+2*q^32,0,0,4*q^31-12*q^32+10*q^33-
10*q^34+12*q^35-4*q^36,-I*q^16+2*I*q^17-I*q^18,16*I*q^15-
32*I*q^16+16*I*q^17,-q^12,q^31-2*q^32+q^33,8*I*q^15-16*I*q^16+
16*I*q^17-16*I*q^18+8*I*q^19,-32*I*q^15+32*I*q^16,32*I*q^45-
32*I*q^46,-8*q^30+16*q^31-8*q^32,-4*I*q^15+12*I*q^16-12*I*q^17+
4*I*q^18,4*q^30-12*q^31+12*q^32-4*q^33,4*q^20,64*I*q^15,-64*I*q^45,-64*q^30]
);end;
  tbl.irreducibles:=
[f1(r),f1(p),
 f6(p,r,-1), f6(r,p,-1), f6(p,r,1), f6(r,p,1),
 f7(r,p),f7(p,r),f9(r,p),f9(p,r),f11(r,p,1),f11(r,p,-1),
 f14(p,r),f14(r,p),f16(p,r),f16(r,p),
 f17(r,p,1),f17(p,r,-1),f17(r,p,-1),f17(p,r,1),
 f21(r,p),f21(p,r),f23(r,p),f23(p,r),f25(r,p),f26(r,p),
 f27(r,p,1), f27(p,r,1), f27(r,p,-1), f27(p,r,-1),
 f31(r,p,1), f31(p,r,1), f31(r,p,-1), f31(p,r,-1),
 f35(r,p,1), f35(r,p,-1), f37(r,p), f37(p,r),
 f39(r,p,1), f39(r,p,-1), f41(r,p), 
 f42(r,p,1), f42(p,r,1), f42(r,p,-1), f42(p,r,-1), 
 f46(r,p), f46(p,r), f48(r,p,1), f48(r,p,-1),
 f50(r,p,1), f50(p,r,1), f50(r,p,-1), f50(p,r,-1), 
 f54(r,p), f54(p,r), f56(r,p), f56(p,r), f58(r,p,E(4)), f58(r,p,-E(4))];
  tbl.centralizers:=List(tbl.classes,x->tbl.order/x);
  tbl.irredinfo:=List(CHEVIE.RawData("CharInfo","G31")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G31")(x,rec())));
  tbl := CHEVIE.compat.MakeCharacterTable(tbl);
# CHEVIE.compat.AdjustHeckeCharTable(tbl,para);
  return tbl;
end);

CHEVIE.AddData("CharTable","G31",function()local res;
  res:=CHEVIE.RawData("HeckeCharTable","G31")(List([1..4],x->[1,-1]),[]);
  res.identifier:="G31"; res.name:="G31";
  res.galomorphisms:=Group( ( 7, 9)( 8,12)(13,17)(15,16)(19,21)(20,23)(25,27)(26,28)
    (31,32)(35,37)(38,40)(42,45)(43,44)(46,49)(51,52)(54,55)(57,58) );
  res.text:="origin: CharTable(H(G31))";
  res.irreducibles{[26..59]}{[14,19,21,35,37,41]}:=
[[2,0,0,0,0,-2],[0,0,0,0,0,0],[0,0,0,0,0,0],[0,0,0,0,0,0],[0,
0,0,0,0,0],[0,-E(4)-1,E(4)-1,-E(4)+1,E(4)+1,0],[0,E(4)+1,-E(4)+1,
E(4)-1,-E(4)-1,0],[0,E(4)-1,-E(4)-1,E(4)+1,-E(4)+1,0],[0,-E(4)+1,E(4)+1,
-E(4)-1,E(4)-1,0],[-1,-E(4),E(4),E(4),-E(4),1],[-1,E(4),-E(4),-E(4),
E(4),1],[1,1,1,1,1,1],[1,-1,-1,-1,-1,1],[1,E(4),-E(4),-E(4),
E(4),-1],[1,-E(4),E(4),E(4),-E(4),-1],[0,0,0,0,0,0],[0,0,0,0,0,0],
[0,0,0,0,0,0],[0,0,0,0,0,0],[0,0,0,0,0,0],[-2,0,0,0,0,2],[-2,
0,0,0,0,2],[1,E(4),-E(4),-E(4),E(4),-1],[1,-E(4),E(4),E(4),-E(4),
-1],[0,E(4)+1,-E(4)+1,E(4)-1,-E(4)-1,0],[0,-E(4)-1,E(4)-1,-E(4)+1,
E(4)+1,0],[0,-E(4)+1,E(4)+1,-E(4)-1,E(4)-1,0],[0,E(4)-1,-E(4)-1,
E(4)+1,-E(4)+1,0],[0,0,0,0,0,0],[0,0,0,0,0,0],[0,0,0,0,0,0],[0,
0,0,0,0,0],[0,0,0,0,0,0],[0,0,0,0,0,0]];
  return res;
end);

CHEVIE.AddData("HeckeRepresentation","G31",function(para,root,i)
  local x,y,rep,f1,f6,f7,f9,f11,f14,f16,f19,f21,f23,f25;
  x:=para[1][1];y:=para[1][2];
  f1:=x->[[[x]],[[x]],[[x]],[[x]],[[x]]];
  f6:=function(x,y,s)local v;v:=s*GetRoot(x*y);return
  [[[x,0,0,0],[0,-v+x+y,-v+x,v],[0,v-y,v,-v],[0,0,0,x]],[[x+y,v-x-y,-x,-v],
   [0,x,0,0],[y,v-x-y,0,-v],[0,0,0,x]],[[x+y,-x,-v,0],[y,0,-v,0],[0,0,x,0],
   [0,0,0,x]],[[x,0,0,0],[0,x,0,0],[0,0,x,0],[0,0,v,y]],[[y,-y,-y,0],[0,x,0,0],
   [0,0,x,0],[0,0,0,x]]]*x^0*y^0;
  end;
  f7:=function(r,p)return 
  [[[p,0,r^2,-r^2,-p^2],[0,p,-r,0,0],[0,0,r,0,0],[0,0,0,r,0],[0,0,0,0,r]],[[p,
p*r,0,0,-p^2],[0,r,0,0,0],[0,0,r,0,0],[0,0,r,p,0],[0,0,0,0,r]],[[p,p*r,
p*r+r^2,-r^2,0],[0,r,0,0,0],[0,0,r,0,0],[0,0,0,r,0],[0,0,r,0,p]],[[p+r,0,0,0,
-p*r],[0,r,0,0,0],[0,p,p+r,-r,0],[0,p,p,0,0],[1,0,0,0,0]],[[r,0,0,0,0],[-1,p,
0,0,p],[0,0,p+r,-r,-p],[0,0,p,0,-p],[0,0,0,0,r]]];end;
  f9:=function(r,p)return 
[[[p+r,0,0,0,r],[0,p,0,0,0],[0,0,p,0,0],[0,0,0,p,0],[-p,0,0,0,0]],[[p,0,0,r,
0],[0,p,0,-r,0],[0,0,p,r,0],[0,0,0,r,0],[0,0,0,-r,p]],[[p,0,0,0,0],[0,p+r,r,0,
0],[0,-p,0,0,0],[0,0,0,p,0],[0,0,0,0,p]],[[r,0,0,0,0],[0,p,0,0,0],[0,0,p,0,0],
[-p,0,0,p,0],[-r,0,0,0,p]],[[p,0,0,0,0],[0,p,p,0,0],[0,0,r,0,0],[0,0,-p,p,0],
[0,0,0,0,p]]];end;
  f11:=function(x,y,s)return List(f6(x,y,s),m->ExteriorPower(m,2)/x);end;
  f14:=function(r,p)return
[[[r,0,p-r,p-p^2*r^-1,0,-r+p^2*r^-1,r,-p+r,p],[0,r,p,r-p^2*r^-1,0,
-p^-1*r^2+p+p^2*r^-1,r,-p,p+r],[0,0,p,0,0,0,r,-p+r,0],[0,0,0,p,0,0,
-p^-1*r^2-r,0,-r],[0,0,0,0,r,-p^-1*r^2+r,-p^-1*r^2,0,0],[0,0,0,0,0,p,-r,0,0],
[0,0,0,0,0,0,r,0,0],[0,0,0,0,0,0,0,r,0],[0,0,0,0,0,0,0,0,r]],[[r,p-r,-p-r,
-r+p^2*r^-1,r,-p-p^2*r^-1,0,0,0],[0,p,-p-r,-r+p^2*r^-1,r,-p-p^2*r^-1,0,0,0],
[0,0,p,0,0,0,0,0,0],[0,0,r,r,0,0,0,0,0],[0,0,0,0,r,0,0,0,0],[0,0,0,0,0,r,0,0,
0],[0,0,0,0,0,0,r,0,0],[0,0,0,0,0,0,-r,p,0],[0,0,0,0,0,0,-r,p-r,r]],[[r,p-r,0,
p-r,r,0,p,0,p],[0,p,r,0,r,p+r,p^-1*r^2+p+r,-r,p+r],[0,0,r,0,0,0,0,0,0],[0,0,
-r,p,0,-p-r,0,r,-r],[0,0,0,0,r,0,p^-1*r^2,0,0],[0,0,0,0,0,r,r,0,0],[0,0,0,0,0,
0,p,0,0],[0,0,0,0,0,0,r,r,0],[0,0,0,0,0,0,-p,0,r]],[[p,0,0,0,0,0,0,0,0],[p,r,
0,0,0,0,0,0,0],[p,-p,r,-p,p,p,0,0,0],[0,p^-1*r^2,0,p^-1*r^2+r,-p^-1*r^2,
-p^-1*r^2,0,0,0],[p,p^-1*r^2-p,0,p^-1*r^2-p,-p^-1*r^2+p+r,-p^-1*r^2+p,0,0,0],
[0,r,0,r,-r,0,0,0,0],[0,p-r,0,p-r,r,0,p+r,0,p],[0,r,0,r,-r,-r,0,r,0],[-p,0,0,
0,-r,p^-1*r^2-r,-r,0,0]],[[r,0,0,0,0,0,0,0,0],[-p,p,0,0,0,0,0,0,0],[0,0,r,-p,
0,r,0,0,0],[0,0,0,p+r,0,-r,0,0,0],[-p,p-r,0,0,r,0,0,0,0],[0,0,0,p,0,0,0,0,0],
[0,0,0,0,0,0,p+r,0,p],[0,0,0,0,0,0,0,r,0],[0,0,0,0,0,0,-r,0,0]]];end;
  f16:=function(r,p)return
[[[r,0,0,0,0,0,0,0,0,0],[0,p,-r^2,0,r^2,0,0,0,0,0],[0,0,0,0,p,0,0,0,0,0],[0,0,
0,r,0,0,0,0,0,0],[0,0,-r,0,p+r,0,0,0,0,0],[0,0,0,0,0,r,0,0,0,0],[-r,0,0,0,0,
-p,p+r,r,-r,0],[0,0,0,0,0,p,-p,0,p,0],[-r,0,0,0,0,0,0,0,p,0],[-r,0,r,0,-p,0,0,
0,p-r,r]],[[0,0,p,0,-p,0,0,0,0,0],[r^2,p+r,0,0,0,0,0,0,-p*r,0],[-r,1,p+2*r,0,
-p-r,0,0,0,-r,0],[-p,0,0,0,0,0,p,p,-p,0],[0,1,r,0,0,0,0,0,-r,0],[-p,0,0,-r,0,
r,p,p,-p,0],[-p,0,0,-r,0,0,p+r,p,-p,0],[-r,1,p+r,0,-p-r,0,0,r,-r,0],[0,1,r,0,
-r,0,0,0,0,0],[-p,0,p,0,-r,0,0,0,-p+r,p]],[[r,0,0,0,0,0,0,0,0,0],[0,r,0,0,0,0,
0,0,0,0],[0,0,r,0,0,0,0,0,0,0],[0,0,0,p,-p,0,0,0,p,-p],[0,0,0,0,r,0,0,0,0,0],
[0,0,0,0,-p,p,0,0,p,-p],[0,0,0,0,0,0,p,0,0,-p],[r,0,-p,0,0,0,0,p,r,0],[0,0,0,
0,0,0,0,0,r,0],[0,0,0,0,0,0,0,0,0,r]],[[p+r,0,0,0,r,0,0,0,0,r],[0,p,
-p*r-p^2-r^2,0,0,0,0,0,0,0],[0,0,r,0,0,0,0,0,0,0],[0,0,0,r,0,0,0,0,0,0],[0,0,
-p,0,p,0,0,0,0,0],[0,0,0,0,0,r,0,0,0,0],[-p,0,0,-r,0,-p+r,p,p,-p,0],[0,0,0,0,
0,0,0,r,0,0],[-p,0,0,0,-r,0,0,0,r,-r],[-p,0,p,0,-p,0,0,0,0,0]],[[p+r,0,r,0,-r,
r,-r,-r,r,0],[0,r,0,0,0,0,0,0,0,0],[0,0,r,0,0,0,0,0,0,0],[0,0,0,r,0,0,0,0,0,
0],[0,0,0,0,r,0,0,0,0,0],[0,0,0,-p,0,p,0,0,0,0],[0,0,0,-p,0,p-r,r,0,0,0],[p,0,
r,0,0,0,0,0,p,0],[0,0,0,0,r,-r,r,0,p,0],[0,0,0,r,p,-r,r,0,0,p]]];end;
  f19:=function(x,y,v)local s;s:=v*GetRoot(x*y);return 
[[[y,0,0,0,0,0,0,0,0,0],[0,x+y,0,x,0,0,0,0,0,0],[0,0,y,0,0,0,0,0,0,0],[0,-y,0,
0,0,0,0,0,0,0],[0,0,0,0,y,0,0,0,0,0],[0,0,0,0,0,0,-1,0,0,0],[0,0,0,0,0,x*y,
x+y,0,0,0],[0,0,0,0,0,0,0,0,1,0],[0,0,0,0,0,0,0,-x*y,x+y,0],[0,-x*y-x^2,0,
-x*y-x^2,0,x*y+y^2,x+y,s*y,-s,y]],[[x,0,0,0,0,0,0,0,0,0],[y^2,y,0,0,0,0,0,0,0,
0],[-y,0,y,0,0,0,0,0,0,0],[-y^2,0,0,y,0,0,0,0,0,0],[y,0,0,0,y,0,0,0,0,0],
[-y^2,0,y^2,0,0,0,0,0,0,-1],[-s*x*y-s*x^2+y^3,0,s*x*y,0,s*x*y+s*y^2,0,0,-s*y,
y,s],[y^2,0,-x*y-x^2-y^2,0,-x*y-x^2,x+y,s/y,x+y,-s/y,1],[-s*x*y-s*x^2+y^3,0,
-s*y^2,0,0,s*y,0,0,y,s],[0,0,-x*y^2,0,0,x*y,0,0,0,x+y]],[[y,0,0,0,0,0,0,0,0,
0],[0,y,0,0,0,0,0,0,0,0],[0,0,0,0,-y,0,0,0,0,0],[0,0,0,y,0,0,0,0,0,0],[0,0,x,
0,x+y,0,0,0,0,0],[0,0,0,0,0,0,0,-y,0,0],[x^2*y+x^3,-x*y-x^2,-s*y^2-x^2*y,
-x*y-x^2,-x*y^2-x^2*y,x*y+y^2,x+y,x*y+y^2,-s,s-x],[0,0,0,0,0,x,0,x+y,0,0],
[x^2*y+x^3,-x*y-x^2,-s*x*y-s*x^2-s*y^2+x*y^2,-x*y-x^2,-s*x*y-s*x^2,s*x+s*y,x,
s*x+s*y,-s+y,s-x],[-s*x*y-s*x^2,s*x+s*y,-s*y^2,s*x+s*y,-y^3,0,-s,0,y,s]],[[0,
0,0,1,0,0,0,0,0,0],[0,y,0,0,0,0,0,0,0,0],[0,0,0,0,0,1,0,0,0,0],[-x*y,0,0,x+y,
0,0,0,0,0,0],[0,0,0,0,0,0,0,1,0,0],[0,0,-x*y,0,0,x+y,0,0,0,0],[0,0,0,0,0,0,y,
0,0,0],[0,0,0,0,-x*y,0,0,x+y,0,0],[0,0,0,0,0,0,0,0,y,0],[0,0,-y^3,0,0,y^2,0,0,
0,y]],[[0,0,y,0,0,0,0,0,0,0],[0,0,0,0,0,0,1,0,0,0],[-x,0,x+y,0,0,0,0,0,0,0],
[0,0,0,0,0,y,0,0,0,0],[0,0,0,0,y,0,0,0,0,0],[0,0,0,-x,0,x+y,0,0,0,0],[0,-x*y,
0,0,0,0,x+y,0,0,0],[0,0,0,0,0,0,0,y,0,0],[0,0,0,0,0,0,0,0,y,0],[-x*y^2,0,
x*y^2,0,0,0,0,0,0,y]]]*x^0*y^0;end;
  f21:=function(x,y)return
  [[[0,0,1,1,0,0,0,0,0,0,0,0,0,0,0],[0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,x+y,0,
0,0,0,0,0,0,0,0,0,0,0],[-x*y,-x,0,x+y,0,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,x+y,0,0,
0,0,0,-x*y^-1,0,0,0,0],[-x*y,-x,0,x,0,y,-1,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,x,0,
0,0,0,0,0,0,0],[0,0,-1,-1,0,0,0,0,0,0,0,-x^-1,0,0,0],[0,x+y,0,0,0,0,0,0,x+y,0,
-1-x*y^-1,0,0,-1,0],[x*y^3+x^2*y^2,x*y^2,-x^2*y+y^3,-x*y^2-x^2*y,x*y^2,0,y^2,
0,-x*y^2,y,y^2,0,0,y^2,0],[0,0,-y^2,0,y^2,0,0,0,0,0,0,0,0,0,0],[x^2*y,0,0,0,0,
0,0,x^2*y,0,0,0,x+y,0,0,0],[x*y-y^2,x+y,0,-x,-x,0,0,-y^2,x,0,-1,-x^-1*y,y,-1,
0],[0,0,0,0,-x*y-y^2,0,0,0,x*y,0,0,0,0,0,0],[x*y^4,0,-x*y^3,-x*y^3,0,0,0,0,0,
0,0,0,0,0,y]],[[x+y,0,0,0,0,0,0,x,0,0,0,0,0,0,0],[-x*y+y^2,0,-y,x-y,0,0,-1,
-x*y+y^2,0,0,0,0,-y,0,0],[0,0,0,0,y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,-y,0,0,0,y,
0,0,0,0,0,0],[0,0,-x,0,x+y,0,0,0,0,0,0,0,0,0,0],[x*y,0,0,0,0,y,0,x*y,0,0,0,0,
0,0,0],[x*y^2-y^3,x*y,x*y+y^2,-x^2+y^2,-x*y,0,x+y,x*y^2-y^3,x*y-y^2,0,0,0,y^2,
0,0],[-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,-x,-x,0,0,0,0,x+y,0,0,0,0,0,0],
[-x^3*y,x*y^2,x*y^2,x*y^2-x^2*y,0,0,x*y,-x^3*y,0,y,0,0,0,0,0],[-x*y^2+y^3,x^2,
x^2-y^2,-y^2,0,0,x,-x*y^2+y^3,y^2,0,x+y,x,-y^2,0,0],[-x*y^2+x^2*y,-x*y,0,x*y,
0,0,-y,-x*y^2+x^2*y,-x*y,0,-y,0,x*y,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,x,0,0],
[-x*y^2,-x^2,-x^2+y^2,-x^2,-x^2-y^2,0,-x,-x*y^2,x^2,0,-x,-x,x*y,y,0],[-x^4*y,
x^2*y^2,-x*y^3,-x*y^3-x^2*y^2-x^3*y+x^4,0,0,x*y^2+x^2*y-x^3,-x^4*y,
x*y^3+x^2*y^2,0,x*y^2+x^2*y,x*y^2+x^2*y,-x^2*y^2-x^3*y,0,y]],[[0,-1,0,0,0,0,0,
0,0,0,0,0,0,0,0],[x*y,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[x*y-x^2,x,x+y,-x,0,0,1,
x*y-x^2,0,0,1,0,-x,0,0],[-2*x*y,-x,x^-1*y^2,x,0,0,x^-1*y,-x*y,0,0,x^-1*y,0,x,
x^-1*y,0],[0,0,0,0,x+y,0,0,0,-x,0,0,0,0,0,0],[-x*y+y^2,-x,0,-y,-y,y,0,y^2,y,0,
0,0,-y,0,0],[-x^2*y,-x*y-x^2,-x*y,x^2,0,0,0,0,0,0,-y,0,x^2,0,0],[0,1,0,0,0,0,
0,0,0,0,x^-1,0,0,0,0],[0,0,0,0,y,0,0,0,0,0,0,0,0,0,0],[x*y^3,x*y^2,0,0,0,0,0,
0,0,y,0,0,0,0,0],[-x^2*y,0,0,0,0,0,0,-x^2*y,0,0,x+y,0,0,0,0],[x^2*y+x^3,-x^2,
-x^2,x*y,x*y,0,-x,x^2*y+x^3,-x*y,0,-2*x-y,y,x*y,0,0],[x*y,x,-x^-1*y^2,0,0,0,
-x^-1*y,0,0,0,0,0,0,-x^-1*y,0],[-x*y^2+x^2*y,0,x*y,x*y-x^2,0,0,x,-x*y^2+x^2*y,
0,0,0,0,x*y,x+y,0],[x*y^4-x^3*y^2,x*y^3+x^2*y^2+x^3*y+x^4,x^2*y^2+x^3*y+y^4,
-x*y^3-x^2*y^2-x^3*y,-x^2*y^2,0,x*y^2+x^2*y+y^3,-x^3*y^2-x^4*y,x^2*y^2,0,
2*x*y^2+2*x^2*y+y^3,0,-x^2*y^2-x^3*y,y^3,y]],[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0],[-y^2,0,y,y,
0,0,1,0,0,0,0,0,0,0,0],[x*y-y^2,x,0,y,y,-y,0,-y^2,-y,0,0,0,y,0,0],[0,0,0,0,0,
x+y,0,0,x,0,0,0,0,0,0],[0,0,x*y,0,0,0,x+y,0,0,0,0,0,0,0,0],[-x,0,0,0,0,0,0,y,
0,0,0,0,0,0,0],[0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0],[x*y^3,x*y^2,0,0,0,0,0,0,0,y,
0,0,0,0,0],[0,x*y,0,0,0,0,0,0,0,0,y,0,0,0,0],[-y^3,0,y^2,y^2,0,0,0,0,0,0,0,0,
0,0,-x^-1],[-x*y+y^2,0,-y,x-y,0,0,-1,-x*y+y^2,0,0,0,0,x,0,0],[-x^2*y,-x^2,y^2,
0,0,0,y,0,0,0,0,0,0,y,0],[0,0,-x^2*y^2,-x^2*y^2,0,0,0,0,0,0,0,x^2*y,0,0,x+y]],
[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[y^2,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,-y,
0,0,0,0,0,0,0,0,0,0,0],[0,0,x,x+y,0,0,0,0,0,0,0,0,0,0,0],[x*y+y^2,y,
x^-1*y^2-x,-x-y,y,0,x^-1*y,0,-y,x^-1,x^-1*y,0,0,x^-1*y,0],[-y^2,x,x+y,y,0,x,1,
0,0,0,0,0,0,0,0],[-y^3,0,y^2,y^2,0,0,y,0,0,0,0,0,0,0,0],[-x,0,0,0,0,0,0,y,0,0,
0,0,0,0,0],[0,-y,-x-y,-y,0,0,-1,0,x,0,0,0,0,0,0],[0,x^2*y,0,0,0,0,0,0,0,x+y,
-x^2,0,0,0,0],[y^3,y^2,0,0,0,0,0,0,0,x^-1*y,0,0,0,0,0],[0,0,x*y,x*y,0,0,0,0,0,
0,0,y,0,0,0],[-y^2,x,-x,-x,0,x,0,0,x,0,0,0,y,0,0],[-x*y^2,-2*x*y-y^2,-y^2,0,0,
0,-y,0,0,-1-x^-1*y,x+x^2*y^-1,0,0,x,0],[x*y^4,0,-x*y^3,-x*y^3,0,0,0,0,0,0,0,0,
0,0,y]]]*x^0*y^0;end;
  f23:=function(x,y)return
  [[[y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,1,0,-1,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,
0,0,0,0,0,0,0,0,0,0],[x^2,0,0,x,0,0,0,0,0,x,0,0,0,0,0],[0,0,-y,0,x+y,0,0,0,0,
0,0,0,0,0,0],[0,0,0,0,0,y,0,0,0,0,0,0,0,0,0],[0,x^2*y,0,0,0,x^2*y,x,x*y,0,0,0,
y,-y,-x*y,0],[-x*y,0,0,0,0,0,0,x,0,-y,0,0,0,0,0],[0,0,0,0,0,x*y,0,0,x,0,0,0,0,
-y,0],[0,0,0,0,0,0,0,0,0,y,0,0,0,0,0],[x^2,0,-x,0,x,-x*y,0,0,0,0,x,0,0,0,0],
[0,x^2*y,0,0,0,x^2*y,0,x*y,0,0,0,x+y,-y,-x*y,0],[-x^2*y,x^3,x^2,0,-x^2,x^2*y,
0,x^2,0,-x*y,0,x,0,-x*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,y,0],[x^2*y,x^2*y+x^3,0,
0,0,x^3,0,x*y+x^2,0,x*y,0,x+y,-x-y,-x^2,x]],[[0,-x,0,0,0,0,0,0,0,0,0,0,0,0,0],
[y,x+y,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x*y-x^2,-x*y-x^2,x,0,y,-y^2,0,0,0,0,0,0,0,
0,0],[0,0,0,x,0,0,0,-x,0,0,0,-1,0,0,0],[0,0,0,0,0,x*y,0,0,0,0,0,0,0,0,0],[0,0,
0,0,-1,x+y,0,0,0,0,0,0,0,0,0],[-x*y^2,0,0,-y^2,0,0,x+y,0,0,-y^2,0,0,0,0,0],[0,
0,0,0,0,0,0,y,0,0,0,0,0,0,0],[-x*y,-x*y,0,0,0,0,0,-y,x,0,-y,0,0,0,0],[0,x^2,0,
-x,0,0,x/y,x,0,0,0,1,0,0,0],[0,0,0,0,0,0,0,0,0,0,y,0,0,0,0],[0,0,0,0,0,0,0,0,
0,0,0,y,0,0,0],[-x^3,x^2*y,0,-x*y-x^2,(-x^2*y-x^3)/y,x^2*y+x^3,(x*y+x^2)/y,
x*y,0,-x*y-x^2,0,y,x,0,0],[x^2,0,0,x,x^2/y,-x^2,-x/y,0,0,x,0,0,0,x,0],
[-x*y^2-x^2*y+x^3,x^3,0,-x*y-y^2,-x*y,x*y^2,x+y,x^2,0,-x*y-y^2,x^2,0,0,0,x]],
[[0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,-x,0,0,0,0,0,0,0,0,0],[-x*y,0,x+y,
0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,y,0,0,0,0,0,0,0,0,0,0,0],[x^2,x*y+y^2,-x,0,x,
x*y+y^2,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,x+y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,y,0,
0,0,0,0,0,0,0],[0,x^2,0,0,0,x^2,0,x,0,0,0,0,-1,-x,0],[0,-2*x^2,-x,0,0,-x^2,0,
-x,0,0,-x,0,1,x,-1],[x^2,-x^2,-x,-y,0,-x^2,1,0,0,x,0,0,1,x,0],[0,x^2,0,0,0,
x^2,0,0,0,0,x,0,0,0,0],[0,0,0,x*y,0,0,-x,0,0,0,0,x,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,x+y,x*y,0],[0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0],[x^2*y,x^2*y,0,0,0,0,0,x*y,
x*y,0,x*y,0,0,0,x+y]],[[y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,
-1,0,0,0,0],[0,0,y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,y,0,0,0,0,0,0,0,0,0,0,0],
[x^2,0,-x,0,x,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,0,x,0,0,0,0,1,0,0,0,0],[0,-2*x^3,
-x^2,0,0,-x^3,x,-x^2,-x^2,0,-x^2,0,x,x^2,-x],[x^2,x^2,0,0,0,0,0,x,x,0,x,0,0,0,
0],[0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[-x*y,0,0,-y,0,0,0,0,0,x,0,0,0,0,0],[0,x*y,
0,0,0,0,0,0,0,0,x+y,0,0,0,0],[0,0,0,x*y,0,0,0,0,-x^2,0,0,x,0,0,0],[0,x^3,0,0,
0,x^3,0,x^2,0,0,0,0,0,-x^2,x],[x^2,x^2,0,0,0,0,0,0,x,0,x,0,0,x,0],[0,x^2*y,0,
0,0,x^2*y,0,x*y,0,0,0,0,-y,-x*y,x+y]],[[y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,0,0,-1,0,0,0,0,0,0,0],[0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0],[0,0,x,x+y,0,0,0,0,
0,0,0,0,0,0,0],[-x*y,0,0,-y,0,0,0,0,0,-y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0],[-x^2*y,0,0,-x*y,-x^2,x^2*y,x,0,0,-x*y,0,0,0,-x*y,0],[0,x*y,0,0,0,0,0,
x+y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,y,0,0,0,0,0,0],[x^2,0,-x,0,x,0,0,0,0,x+y,
0,0,0,0,0],[x^2,x^2,0,0,0,0,0,x,x,0,x,0,0,0,0],[-x^2*y,x^3,x^2,0,-x^2,x^2*y,0,
x^2,0,-x*y,0,x,0,-x*y,0],[0,x^2*y,0,0,0,x^2*y,0,x*y,0,0,0,0,x,-x*y,0],[0,0,0,
0,0,-x*y,0,0,0,0,0,0,0,x+y,0],[0,x^3,0,0,0,x^3,0,x^2,0,0,0,0,0,-x^2,x]]]*x^0*y^0;end;
  f25:=function(x,y)return
  [[[0,0,0,0,0,0,0,y,0,0,0,0,0,0,0,0],[0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0],[0,0,0,
0,0,y,0,-y,0,-y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0],[0,0,0,0,0,0,
0,0,0,0,0,-y,0,0,0,0],[0,x,0,0,0,x+y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,y,0],[-x,0,0,0,0,0,0,x+y,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,
0,-y,0,0],[x,x,x,0,0,0,0,0,0,x+y,0,0,0,0,0,0],[0,x,0,0,0,x,0,0,0,0,0,0,0,0,y,
y],[0,0,0,0,x,0,0,0,0,0,0,x+y,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,x+y,0,0,0],[0,
0,0,0,0,0,0,0,x,0,0,0,0,x+y,0,0],[0,0,0,0,0,0,-x,0,0,0,0,0,0,0,x+y,0],[0,x,0,
0,0,x,x,0,0,0,-x,0,0,0,0,x+y]],[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x+y,x,0,
0,0,0,0,0,0,0,0,0,0,0,0],[0,-y,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,x+y,x,0,0,
0,0,0,0,0,0,0,0,0],[0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,y,0,x,0,x,0,
0,0,0,0,0],[0,0,0,0,0,0,0,0,y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,-x,0,x+y,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,x,0,0,0,0,0,0],[-y,
x,x,-y,-y,0,0,x+y,0,x+y,y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,-y,0,0,0],[0,0,
0,0,0,0,0,0,0,0,0,x,x+y,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,x+y,x,0],[0,0,0,0,0,
0,0,0,0,0,0,0,0,-y,0,0],[0,x,x,0,0,0,0,x,0,x+y,0,y,y,y,y,y]],[[y,y,y,0,0,0,0,
0,0,0,0,0,0,0,0,0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,x,0,0,0,0,0,0,0,0,0,
0,0,0,0],[x,-y,0,x+y,x,0,0,0,0,0,0,0,0,0,0,0],[-y,0,-y,-y,0,0,0,0,0,0,0,0,0,0,
0,0],[0,0,0,0,0,x,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,y,y,0,0,0,-y,0,0,0,0,0],[0,
0,0,0,0,0,0,0,0,-y,0,0,0,0,0,0],[y,y,0,y,y,y,0,-y,y,-y,-y,0,0,0,0,0],[0,0,0,0,
0,0,0,x,0,x+y,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,x,0,0,0,0,0],[0,0,0,0,0,y,0,0,
0,-y,0,0,-y,0,0,0],[0,0,0,0,0,-y,0,-x,0,0,0,x,x+y,0,0,0],[0,x,x,0,0,0,0,x,0,
x+y,0,y,y,y,y,y],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y],[0,0,0,0,0,0,0,0,0,0,0,0,
0,0,x,x+y]],[[0,0,0,0,-y,0,0,0,0,0,0,0,0,0,0,0],[0,x,0,0,0,0,0,0,0,0,0,0,0,0,
0,0],[y,-x,y,y,y,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,x,0,0,0,0,0,0,0,0,0,0,0,0],[x,
0,0,0,x+y,0,0,0,0,0,0,0,0,0,0,0],[0,y,0,0,0,y,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,
0,x+y,x,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,-y,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,
x,0,0,0,0,0,0,0],[0,y,0,0,0,y,y,0,0,0,-y,0,0,0,0,0],[0,0,0,0,0,-x,0,x,0,x,x+y,
0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,-y,0],[0,0,0,0,0,0,-y,0,0,0,y,0,0,0,0,
-y],[y,0,0,y,y,0,0,-y,y,0,-y,y,y,y,y,y],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,x+y,0],
[0,0,0,0,0,-x,0,0,0,x,0,0,x,0,0,x+y]],[[x,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,x,
0,0,0,0,0,0,0,0,0,0,0,0,0,0],[-x,-x,y,0,0,0,0,0,0,0,0,0,0,0,0,0],[y,0,0,y,y,0,
0,0,0,0,0,0,0,0,0,0],[0,0,0,0,x,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,x,0,0,0,0,0,
0,0,0,0,0],[0,0,0,0,0,0,x,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,x,0,0,0,0,0,0,0,
0],[0,0,0,0,0,0,-y,-y,y,0,0,0,0,0,0,0],[0,0,0,0,0,-y,0,y,0,y,0,0,0,0,0,0],[0,
x,0,0,0,x,x,0,0,0,y,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,x,0,0,0,0],[0,0,0,0,0,0,
0,-y,0,0,0,y,y,0,0,0],[-x,0,0,0,0,0,0,x+y,0,0,0,0,0,y,y,0],[0,0,0,0,0,0,0,0,0,
0,0,0,0,0,x,0],[0,x,0,0,0,x,0,0,0,0,0,0,0,0,y,y]]]*x^0*y^0;
 end;
 rep:=[[f1,x],[f1,y],[f6,y,x,1], [f6,x,y,-1], [f6,y,x,-1], [f6,x,y,1],
     [f7,x,y],[f7,y,x],[f9,x,y],[f9,y,x],[f11,x,y,-1],[f11,x,y,1],
     [f14,y,x],[f14,x,y],[f16,y,x],[f16,x,y],[f19,x,y,1],[f19,y,x,1],
     [f19,x,y,-1],[f19,y,x,-1],[f21,x,y],[f21,y,x],[f23,x,y],[f23,y,x],
     [f25,x,y]];
  if IsBound(rep[i]) then 
    return ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]})+0*x*y;
  else return false;fi;
end);

CHEVIE.AddData("Representation","G31",function(i)local r,f,expand,LsToMat;
  r:=CHEVIE.RawData("HeckeRepresentation","G31")(List([1..5],i->[1,-1]),[],i);
  if r<>false then return r;fi;
  f:=i->CHEVIE.RawData("Representation","G31")(i);
  LsToMat:=function(m)local n;n:=[1..Length(m[1])];
   return List(m,ls->List(ls,
     function(i)local v;v:=n*0;v[AbsInt(i)]:=SignInt(i);return v;end));
  end;
  expand:=function(l,n)local res;res:=[1..n]*0;
    res{l{[1..Length(l)/2]}}:=l{[Length(l)/2+1..Length(l)]};return res;end;
  if i=26 then return LsToMat(
    [[-1,3,2,6,-7,4,-5,10,9,8,18,12,13,14,-15,17,16,11,-19,-20],
     [1,-6,4,3,16,-2,17,8,-9,10,-11,-12,14,13,15,5,7,-18,20,19],
     [15,16,-17,7,6,5,4,-8,12,-10,11,9,-13,-14,1,2,-3,18,19,20],
     [2,1,-3,9,5,6,12,8,4,13,-11,7,10,14,16,15,-17,19,18,-20],
     [1,2,3,10,-5,8,-7,6,13,4,17,-12,9,-14,19,18,11,16,15,20]]);
  elif i=27 then return Zip(f(3),f(7),KroneckerProduct);
  elif i=28 then return -f(27);
  elif i=29 then return ComplexConjugate(f(27));
  elif i=30 then return -f(29);
  elif i=31 then return Zip(f(3),f(9),KroneckerProduct);
  elif i=32 then return -f(31);
  elif i=33 then return ComplexConjugate(f(31));
  elif i=34 then return -f(33);
  elif i=35 then return -f(36);
  elif i=36 then return E(4)*List(
 [[[5,1],[6,1],[7,1],[8,-1],[1,-1],[2,-1],[3,-1],[4,1],[15,-1],[16,-1],[12,-1],
[11,1],[17,1],[18,1],[9,1],[10,1],[13,-1],[14,-1],[22,1],[21,1],[20,-1],[19,
-1],[24,1],[23,-1]],[[6,-1],[5,-1],[10,1],[11,-1],[2,1],[1,1],[16,-1],[12,1],
[19,1],[3,-1],[4,1],[8,-1],[20,1],[23,1],[22,1],[7,1],[21,-1],[24,-1],[9,-1],
[13,-1],[17,1],[15,-1],[14,-1],[18,1]],[[7,-1],[10,1],[5,-1],[12,1],[3,1],[16,
-1],[1,1],[11,1],[17,1],[2,-1],[8,-1],[4,-1],[15,1],[24,1],[13,-1],[6,1],[9,
-1],[23,1],[21,1],[22,-1],[19,-1],[20,1],[18,-1],[14,-1]],[[8,-1],[14,1],[13,
1],[9,1],[15,-1],[21,1],[11,1],[1,1],[4,-1],[24,1],[7,-1],[17,1],[3,-1],[2,
-1],[5,1],[19,1],[12,-1],[20,-1],[16,-1],[18,1],[6,-1],[23,-1],[22,1],[10,
-1]],[[8,-1],[8,19,1,-1],[8,13,1,-1],[5,1],[4,-1],[4,22,1,-1],[4,17,1,-1],[1,
1],[15,-1],[4,18,1,-1],[9,12,1,1],[11,15,-1,1],[1,3,1,1],[1,16,1,1],[9,1],[8,
14,1,-1],[5,7,1,1],[5,10,1,1],[1,2,1,1],[15,24,1,-1],[9,23,1,1],[5,6,1,1],[15,
21,1,-1],[9,20,1,1]]],x->List(x,y->expand(y,24)));
  elif i=37 then return List(
[[[2,1],[1,1],[5,1],[22,-1],[3,1],[9,1],[7,-1],[27,-1],[6,1],[16,1],[11,-1],
[17,1],[18,1],[19,1],[15,-1],[10,1],[12,1],[13,1],[14,1],[28,-1],[21,-1],[4,
-1],[23,-1],[29,1],[30,1],[26,-1],[8,-1],[20,-1],[24,1],[25,1]],[[3,1],[5,1],
[1,1],[6,1],[2,1],[4,1],[7,-1],[12,1],[22,1],[18,1],[11,-1],[8,1],[16,-1],[14,
-1],[23,1],[13,-1],[27,1],[10,1],[19,-1],[29,1],[23,26,-1,1],[9,1],[15,1],[28,
1],[25,-1],[15,21,1,1],[17,1],[24,1],[20,1],[30,-1]],[[1,-1],[2,-1],[3,-1],
[16,1],[5,-1],[13,1],[7,-1],[28,-1],[18,-1],[22,1],[11,-1],[24,1],[6,1],[25,
1],[23,-1],[4,1],[29,-1],[9,-1],[30,1],[27,1],[26,1],[10,1],[15,-1],[12,1],
[14,1],[21,1],[20,1],[8,-1],[17,-1],[19,1]],[[1,-1],[11,-1],[7,1],[4,-1],[5,
-1],[14,1],[3,1],[15,1],[18,24,1,-1],[26,1],[2,-1],[24,1],[25,1],[6,1],[8,1],
[16,-1],[14,30,-1,1],[9,12,1,1],[13,29,1,-1],[20,-1],[22,1],[21,1],[28,1],[12,
1],[13,1],[10,1],[27,-1],[23,1],[19,25,-1,1],[6,17,1,1]],[[4,1],[22,-1],[8,1],
[1,1],[27,-1],[12,1],[15,1],[3,1],[17,1],[10,-1],[21,1],[6,1],[25,1],[24,1],
[7,1],[16,-1],[9,1],[30,1],[29,1],[20,-1],[11,1],[2,-1],[23,-1],[14,1],[13,1],
[26,-1],[5,-1],[28,-1],[19,1],[18,1]]],x->List(x,y->expand(y,30)));
  elif i=38 then return -f(37);
  elif i=39 then return Zip(f(9),f(11),KroneckerProduct);
  elif i=40 then return -f(39);
  elif i=41 then return LsToMat(
[[2,1,6,7,8,3,4,5,-14,-15,12,11,18,-9,-10,-20,-21,13,22,-16,-17,19,-25,33,-23,
34,35,36,31,-32,29,-30,24,26,27,28],[-2,-1,-6,-5,-4,-3,8,7,10,9,13,-18,11,-15,
-14,19,23,-12,16,22,25,20,17,26,21,24,-29,30,-27,28,-35,36,-34,-33,-31,32],[3,
6,1,9,10,2,14,15,4,5,16,20,-19,7,8,11,21,22,-13,12,17,18,25,-28,23,30,29,-24,
27,26,35,34,36,32,31,33],[4,8,9,1,7,15,5,2,3,14,17,20,24,10,6,21,11,27,28,12,
16,29,26,13,30,23,18,19,22,25,36,34,35,32,33,31],[5,8,11,7,1,12,4,2,17,16,3,6,
18,21,20,10,9,13,23,15,14,-25,19,27,-22,28,24,26,-30,-29,32,31,35,36,33,34]]);
  elif i=42 then return Zip(f(3),f(13),KroneckerProduct);
  elif i=43 then return -f(42);
  elif i=44 then return ComplexConjugate(f(42));
  elif i=45 then return -f(44);
  elif i=46 then return List(
[[[2,1],[1,1],[39,-1],[7,1],[9,1],[10,1],[4,1],[8,1],[5,1],[6,1],[11,1],[12,
1],[15,1],[29,1],[13,1],[31,-1],[17,1],[18,1],[23,1],[24,1],[25,1],[22,1],[19,
1],[20,1],[21,1],[34,1],[35,1],[28,1],[14,1],[30,1],[16,-1],[37,1],[36,1],[26,
1],[27,1],[33,1],[32,1],[40,1],[3,-1],[38,1]],[[9,-1],[5,1],[10,1],[4,1],[2,
1],[39,1],[7,1],[30,-1],[1,-1],[3,1],[17,-1],[18,1],[13,1],[14,-1],[15,1],[26,
1],[11,-1],[12,1],[19,1],[32,-1],[27,1],[28,1],[23,1],[37,1],[35,1],[16,1],
[21,1],[22,1],[29,-1],[8,-1],[34,1],[20,-1],[29,33,-1,1],[31,1],[25,1],[14,36,
-1,1],[24,1],[38,1],[6,1],[40,1]],[[39,1],[3,1],[2,1],[4,-1],[10,-1],[9,1],[7,
-1],[11,1],[6,1],[5,-1],[8,1],[12,-1],[19,1],[14,1],[23,1],[24,1],[30,1],[18,
-1],[13,1],[31,1],[21,1],[12,22,1,1],[15,1],[16,1],[25,1],[37,-1],[27,1],[18,
28,1,1],[29,1],[17,1],[20,1],[34,1],[33,1],[32,1],[35,1],[36,1],[26,-1],[7,38,
1,1],[1,1],[4,40,1,1]],[[1,1],[8,1],[11,1],[12,1],[31,-1],[13,1],[7,1],[2,1],
[19,1],[20,1],[3,1],[4,1],[6,1],[21,1],[24,1],[23,1],[32,1],[18,1],[9,1],[10,
1],[14,1],[40,1],[16,1],[15,1],[36,1],[26,1],[27,-1],[28,1],[33,1],[34,1],[5,
-1],[17,1],[29,1],[30,1],[27,35,-1,1],[25,1],[37,1],[38,1],[39,1],[22,1]],[[7,
1],[4,1],[3,-1],[2,1],[5,1],[14,1],[1,1],[12,1],[9,1],[29,1],[11,-1],[8,1],
[21,1],[6,1],[25,1],[16,1],[11,17,1,1],[28,-1],[19,1],[33,1],[13,1],[30,1],
[23,1],[36,1],[15,1],[38,1],[27,1],[18,-1],[10,1],[22,1],[31,1],[3,32,1,1],
[20,1],[40,1],[35,1],[24,1],[37,39,1,-1],[26,1],[39,-1],[34,1]]],
  x->List(x,y->expand(y,40)));
  elif i=47 then return -f(46);
  elif i=48 then return E(4)*List(
[[[11,-1],[5,1],[12,-1],[6,37,-1,1],[2,-1],[4,32,1,1],[17,1],[18,1],[19,-1],
[20,1],[1,1],[3,1],[26,1],[21,-1],[28,-1],[22,38,1,1],[7,-1],[8,-1],[9,1],[10,
-1],[14,1],[16,31,-1,1],[30,1],[34,36,-1,1],[27,1],[13,-1],[25,-1],[15,1],[33,
39,1,1],[23,-1],[38,1],[37,-1],[35,-1],[24,40,1,1],[33,1],[40,1],[32,1],[31,
-1],[29,35,-1,1],[36,-1]],[[7,-1],[8,1],[9,-1],[34,-1],[18,1],[24,1],[1,1],[2,
-1],[3,1],[26,-1],[17,1],[19,1],[20,1],[28,-1],[21,1],[38,1],[11,-1],[5,-1],
[12,-1],[13,-1],[15,-1],[16,31,1,-1],[25,1],[6,-1],[23,-1],[10,1],[30,1],[14,
1],[33,1],[27,-1],[22,38,1,1],[36,1],[29,-1],[4,1],[33,39,1,1],[32,-1],[40,
-1],[16,-1],[29,35,1,-1],[37,1]],[[8,-1],[7,1],[14,1],[6,-1],[17,1],[4,1],[2,
-1],[1,1],[28,-1],[13,1],[18,1],[21,-1],[10,-1],[3,-1],[19,1],[29,-1],[5,-1],
[11,-1],[15,-1],[26,-1],[12,1],[39,-1],[27,1],[34,-1],[30,-1],[20,1],[23,-1],
[9,1],[16,1],[25,1],[35,-1],[37,1],[38,1],[24,1],[31,1],[40,-1],[32,-1],[33,
-1],[22,1],[36,1]],[[7,8,1,-1],[7,-1],[35,-1],[11,1],[32,1],[18,-1],[2,1],[1,
2,1,1],[20,23,1,-1],[38,-1],[4,-1],[26,1],[33,1],[31,-1],[29,-1],[19,1],[37,
1],[6,1],[16,-1],[21,1],[20,-1],[30,1],[9,21,1,1],[36,-1],[39,1],[12,-1],[12,
28,1,-1],[26,27,1,1],[15,1],[22,-1],[14,1],[5,-1],[13,-1],[40,-1],[3,1],[24,
1],[17,-1],[10,1],[25,-1],[34,1]],[[9,1],[21,1],[13,1],[16,1],[14,1],[22,-1],
[20,1],[23,1],[1,-1],[17,1],[19,1],[26,-1],[3,-1],[5,-1],[25,-1],[4,-1],[10,
-1],[30,1],[11,-1],[7,-1],[2,-1],[6,1],[8,-1],[34,36,1,-1],[15,1],[12,1],[28,
-1],[27,1],[39,1],[18,-1],[32,1],[31,-1],[35,1],[40,1],[33,-1],[24,40,1,1],
[38,1],[37,-1],[29,-1],[34,-1]]],x->List(x,y->expand(y,40)));
  elif i=49 then return -f(48);
  elif i=50 then return Zip(f(3),f(15),KroneckerProduct);
  elif i=51 then return -f(50);
  elif i=52 then return ComplexConjugate(f(50));
  elif i=53 then return -f(52);
  elif i=54 then return LsToMat(
  [[-1,-2,-3,11,5,-12,-7,-8,-9,10,4,-6,13,-15,-14,-23,19,-20,17,-18,27,26,
    -16,25,24,22,21,33,37,41,43,44,28,39,45,38,29,36,34,42,30,40,31,32,35],
   [-1,7,8,27,-5,43,2,3,9,-13,21,31,-10,15,14,44,41,42,-30,40,11,-38,32,33,
    -28,36,4,-25,-29,-19,12,23,24,-34,35,26,-37,-22,-39,20,17,18,6,16,45],
   [1,3,2,-4,-5,22,8,7,-9,13,-11,26,10,14,15,17,16,24,23,25,-21,6,19,18,20,
    12,-27,40,34,32,-36,30,-42,29,-45,-31,39,43,37,28,-44,-33,38,-41,-35],
   [14,16,17,4,11,10,18,24,27,6,5,12,22,1,-15,2,3,7,-19,-20,-21,13,-23,8,
    -25,26,9,37,30,29,35,34,41,32,31,45,28,43,40,39,33,44,38,42,36],
   [2,1,3,26,13,-6,-7,9,8,-10,22,-12,5,16,23,14,17,-18,19,-20,25,11,15,27,
    21,4,24,38,31,35,29,44,36,42,30,33,43,28,40,39,45,34,37,32,41]]);
  elif i=55 then return -f(54);
  elif i=56 then return -f(57);
  elif i=57 then return List(f(17),x->ExteriorPower(x,2));
  elif i=58 then return Zip(f(3),f(25),KroneckerProduct);
  elif i=59 then return ComplexConjugate(f(58));
  fi;
end);

# The following invariants differ from those suggested by Orlik-Terao p.285
# The first two are F8, F12 of Maschke but the third is the
# simpler (F20-F8*F12)/1296;  the fourth is still det(Hessian(F8))/265531392

CHEVIE.AddData("Invariants","G31",
[function(x,y,z,t)return 168*t^2*x^2*y^2*z^2+14*t^4*x^4+14*t^4*y^4+14*t^4*z^4
 +14*x^4*y^4+14*x^4*z^4+14*y^4*z^4+t^8+x^8+y^8+z^8;end,

 function(x,y,z,t)return 792*t^2*x^2*y^2*z^6+792*t^2*x^2*y^6*z^2+
792*t^2*x^6*y^2*z^2+330*t^4*x^4*y^4+330*t^4*x^4*z^4+330*t^4*y^4*z^4+
330*x^4*y^4*z^4-33*t^4*x^8-33*t^4*y^8-33*t^4*z^8-33*x^4*y^8-33*x^4*z^8-
33*y^4*z^8+792*t^6*x^2*y^2*z^2-33*t^8*x^4-33*t^8*y^4-33*t^8*z^4-33*x^8*y^4-
33*x^8*z^4-33*y^8*z^4+t^12+x^12+y^12+z^12;end,

 function(x,y,z,t)return
-t^2*x^2*y^2*z^14+t^2*x^2*y^6*z^10+t^2*x^2*y^10*z^6-t^2*x^2*y^14*z^2+
t^2*x^6*y^2*z^10+14*t^2*x^6*y^6*z^6+t^2*x^6*y^10*z^2+t^2*x^10*y^2*z^6+
t^2*x^10*y^6*z^2-t^2*x^14*y^2*z^2-13*t^4*x^4*y^4*z^8-13*t^4*x^4*y^8*z^4+
t^4*x^4*y^12+t^4*x^4*z^12+t^4*y^4*z^12+x^4*y^4*z^12-13*t^4*x^8*y^4*z^4-
2*t^4*x^8*y^8-2*t^4*x^8*z^8-2*t^4*y^8*z^8-2*x^4*y^8*z^8+t^4*x^12*y^4+
t^4*x^12*z^4+t^4*y^12*z^4+x^4*y^12*z^4+t^6*x^2*y^2*z^10+14*t^6*x^2*y^6*z^6+
t^6*x^2*y^10*z^2+14*t^6*x^6*y^2*z^6+14*t^6*x^6*y^6*z^2+t^6*x^10*y^2*z^2-
13*t^8*x^4*y^4*z^4-2*t^8*x^4*y^8-2*t^8*x^4*z^8-2*t^8*y^4*z^8-2*x^8*y^4*z^8-
2*t^8*x^8*y^4-2*t^8*x^8*z^4-2*t^8*y^8*z^4-2*x^8*y^8*z^4+t^10*x^2*y^2*z^6+
t^10*x^2*y^6*z^2+t^10*x^6*y^2*z^2+t^12*x^4*y^4+t^12*x^4*z^4+t^12*y^4*z^4+
x^12*y^4*z^4-t^14*x^2*y^2*z^2;end,

function(x,y,z,t)return
t^2*x^2*y^2*z^18-12*t^2*x^2*y^6*z^14+22*t^2*x^2*y^10*z^10-12*t^2*x^2*y^14*z^6+
t^2*x^2*y^18*z^2-12*t^2*x^6*y^2*z^14-52*t^2*x^6*y^6*z^10-52*t^2*x^6*y^10*z^6-
12*t^2*x^6*y^14*z^2+22*t^2*x^10*y^2*z^10-52*t^2*x^10*y^6*z^6+
22*t^2*x^10*y^10*z^2-12*t^2*x^14*y^2*z^6-12*t^2*x^14*y^6*z^2+t^2*x^18*y^2*z^2+
76*t^4*x^4*y^4*z^12+36*t^4*x^4*y^8*z^8+76*t^4*x^4*y^12*z^4+2*t^4*x^4*y^16+
2*t^4*x^4*z^16+2*t^4*y^4*z^16+2*x^4*y^4*z^16+36*t^4*x^8*y^4*z^8+
36*t^4*x^8*y^8*z^4-2*t^4*x^8*y^12-2*t^4*x^8*z^12-2*t^4*y^8*z^12-
2*x^4*y^8*z^12+76*t^4*x^12*y^4*z^4-2*t^4*x^12*y^8-2*t^4*x^12*z^8-
2*t^4*y^12*z^8-2*x^4*y^12*z^8+2*t^4*x^16*y^4+2*t^4*x^16*z^4+2*t^4*y^16*z^4+
2*x^4*y^16*z^4-12*t^6*x^2*y^2*z^14-52*t^6*x^2*y^6*z^10-52*t^6*x^2*y^10*z^6-
12*t^6*x^2*y^14*z^2-52*t^6*x^6*y^2*z^10-8*t^6*x^6*y^6*z^6-52*t^6*x^6*y^10*z^2-
52*t^6*x^10*y^2*z^6-52*t^6*x^10*y^6*z^2-12*t^6*x^14*y^2*z^2+
36*t^8*x^4*y^4*z^8+36*t^8*x^4*y^8*z^4-2*t^8*x^4*y^12-2*t^8*x^4*z^12-
2*t^8*y^4*z^12-2*x^8*y^4*z^12+36*t^8*x^8*y^4*z^4+36*t^8*x^8*y^8+
36*t^8*x^8*z^8+36*t^8*y^8*z^8+36*x^8*y^8*z^8-2*t^8*x^12*y^4-2*t^8*x^12*z^4-
2*t^8*y^12*z^4-2*x^8*y^12*z^4+22*t^10*x^2*y^2*z^10-52*t^10*x^2*y^6*z^6+
22*t^10*x^2*y^10*z^2-52*t^10*x^6*y^2*z^6-52*t^10*x^6*y^6*z^2+
22*t^10*x^10*y^2*z^2+76*t^12*x^4*y^4*z^4-2*t^12*x^4*y^8-2*t^12*x^4*z^8-
2*t^12*y^4*z^8-2*x^12*y^4*z^8-2*t^12*x^8*y^4-2*t^12*x^8*z^4-2*t^12*y^8*z^4-
2*x^12*y^8*z^4-12*t^14*x^2*y^2*z^6-12*t^14*x^2*y^6*z^2-12*t^14*x^6*y^2*z^2+
2*t^16*x^4*y^4+2*t^16*x^4*z^4+2*t^16*y^4*z^4+2*x^16*y^4*z^4+t^18*x^2*y^2*z^2;end
]);

# the matrix of basic derivations (a matrix of polynomials in the invariants)
CHEVIE.AddData("BasicDerivations","G31",function()return function(x,y,z,t)return
[[8*x,12*t*y,25920*z+88/5*x*y,24*t-1/135*y^2],
 [12*y,18*t*x^2-97200*z^2,-46656*t+12*y^2+72/5*x^3,-42*x*z-1/90*x^2*y],
 [25920*z+20*x*y,12*t*y^2-19440*x*z^2+18*t*x^3-46656*t^2,
   -264384/5*t*x+20736*y*z+148/5*x*y^2+72/5*x^4,
  144/5*t*y-18*x^2*z-1/135*y^3-1/90*x^3*y],
 [24*t,-42*t*x*z-60*y*z^2,-48/5*x^2*z,1/135*x*y*z+1/54*t*x^2+20*z^2]];
end;end);

# the discriminant as a polynomial in the invariants
# =det(BasicDerivations)/82944
CHEVIE.AddData("Discriminant","G31",function()return function(x,y,z,t)return
-3*t*x*y^4*z^2+43740000*x*y*z^5+48114000*t*x^2*z^4+61560*t*x^3*y*z^3+
16200*t*y^3*z^3+6*t*x^4*y^2*z^2-3*t*x^7*z^2+22680*t^2*x*y^2*z^2-
34992000*t^2*y*z^3+32400*x^2*y^2*z^4+23976*t^2*x^4*z^2-62985600*t^3*x*z^2-
15552*t^3*x^2*y*z-2*t^3*x^3*y^2+4*x^3*y^3*z^3+t^3*y^4+t^3*x^6-7776*t^4*y^2-
7776*t^4*x^3+15116544*t^5-2*y^5*z^3-1296*x^5*z^4+15746400000*z^6-2*x^6*y*z^3;
end;end);
