###############################################################################
##
##  g.g  GLISSANDO ver 1.0  Christof Noebauer   1995, 1996
##                                                       
##
##  
#############################################################################
##
#F  InnerAutomorphisms( <G> ) . . . . . create all innerauto's on a group <G> 
##  V1.0  24.2.95
##  Dispatcher function for computing all inner automorphisms on <G>.
##
InnerAutomorphisms := function( G )
  
  if IsGroup( G ) then
    if not IsBound( G.innerAutomorphisms ) then 
      G.innerAutomorphisms := G.operations.InnerAutomorphisms( G ); 
    fi;
  else
    Error( "Usage: InnerAutomorphisms( <G> ) where <G> must be a group" );
  fi;
  
  return G.innerAutomorphisms;
end;

#############################################################################
##
#F  SmallestGeneratingSystem(<G>) . . . smallest generating system of a group
##
SmallestGeneratingSystem := function ( G )
  local   gens,       # smallest generating system of <G>, result
          gen,        # one generator of <gens>
          elms,       # the list of elements sorted by decreasing order
          H;          # subgroup generated by <gens> so far

  if not IsGroup( G ) then
    Error( "Usage: SmallestGeneratingSystem( <G> ) where <G> must be a ",
           "group" );
  fi;
  # start with the empty generating system and the trivial subgroup
  gens := [];
  H := TrivialSubgroup( G );
  elms := Copy( Elements( G ) );
  if Size( elms ) = 1 then return elms; fi;
  Sort( elms, function( x, y ) return Order( G, x ) > Order( G, y ); end );

  # loop over the elements of <G> in their decreasing order
  for gen  in elms do

    # add the element not lying in the subgroup generated by the previous
    if not gen in H  then
      Add( gens, gen );
      H := Closure( H, gen );

      # it is important to know when to stop
      if Size( H ) = Size( G )  then
        return gens;
      fi;

    fi;

  od;

  # well we should never come here
  Error("panic, <G> not generated by its elements");
end;

#############################################################################
##
#F  IsIsomorphicGroup( <G>, <H> ) . . Check if two groups G, H are isomorphic
##  V0.2 3.10.94
##  this version works even with the error in GAP 3.2.
##  The return value is 'false' if G and H are not isomorphic and an
##  isomorphism between G and H if they are isomorphic.
##
IsIsomorphicGroup := function( G, H )
  
  local imageset, # all the poss. im's of the f's G.generators -> H.elements
        image,    # one fixed image in imageset
        h;        # help variable: an isomorphism candidate
  
  if not ( IsGroup( G ) and IsGroup( H ) ) then
    Error( "Usage: IsIsomorphicGroup( <G>, <H> ) where <G> and <H> both ",
           "must be\ngroups" );
  fi;
  if Size( G ) <> Size( H ) then return false; fi;

  # build all functions G.generators -> H.elements and consider them
  imageset := Tuples( Elements( H ), Length( G.generators ) );
  
  for image in imageset do  
    h := GroupHomomorphismByImages( G, H, G.generators, image );
    if IsGroupHomomorphism( h ) then
    # NOTE: this additional "if" may indeed seem a little awkward, but 
    # "IsGroupHomomorphism( h )" alone won't work in GAP 3.2. 
      if MappingOps.IsGroupHomomorphism( h ) then
        if IsBijection( h ) then 
          return h; 
        fi;
      fi;
    fi;
  od;
  return false;
end;
