#############################################################################
##
#A  tbl/cmplxg33.g                 CHEVIE library                Jean Michel
##
#Y  Copyright (C) 1998 - 2002  The CHEVIE Team
##
##  This file  contains data about  the complex reflection group  G33 in
##  the Shephard-Todd classification.
##
CHEVIE.Revision("tbl/cmplxg33.g",
   "$Id: cmplxg33.g,v 1.3 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("PrintDiagram","G33",function(indices,title)local s;
  Print(title," ");s:=String("",Length(title)-5);
  Print("    ",indices[3],"\n       /^\\\n",
	s,indices[1],"---",indices[2],"---",indices[4],"---",indices[5]," ",
	IntListToString(indices{[4,2,3,4,2,3]}),"=",
	IntListToString(indices{[3,4,2,3,4,2]}),"\n");
end);

CHEVIE.AddData("BraidRelations","G33",
  [[[1,2,1],[2,1,2]],[[3,2,3],[2,3,2]],[[4,2,4],[2,4,2]],[[4,3,4],[3,4,3]],
   [[4,5,4],[5,4,5]],[[1,3],[3,1]],[[1,4],[4,1]],[[1,5],[5,1]],[[2,5],[5,2]],
   [[3,5],[5,3]],[[4,2,3,4,2,3],[3,4,2,3,4,2]]]);

## of interest are the alternate presentations of the braid group:
CHEVIE.AddData("AltPres","G33",[rec(gens:=[[1],[2],[-4,3,4],[5,4,-5],[5]],
  rels:=[[[1,2,1],[2,1,2]],[[3,2,3],[2,3,2]],[[4,2,4],[2,4,2]],
   [[4,5,4],[5,4,5]],[[3,5,3],[5,3,5]],[[1,3],[3,1]],[[1,4],[4,1]],
   [[1,5],[5,1]],[[2,5],[5,2]],[[3,4],[4,3]],
   [[4,5,3,2,4,5,3,2,4],[2,4,5,3,2,4,5,3,2]]]),
   rec(gens:=[[1],[2],[3],[-3,-2,4,2,3],[5]],
  rels:=[[[4,2,4],[2,4,2]],[[4,5,4],[5,4,5]],[[4,3,4],[3,4,3]],
   [[4,1,4],[1,4,1]],[[3,2,3],[2,3,2]],[[1,2,1],[2,1,2]],[[1,3],[3,1]],
   [[3,5],[5,3]],[[1,5],[5,1]],[[2,5],[5,2]],[[1,2,3,4,1,2],[2,3,4,1,2,3]]])]);

# G33 is derived by  a non-orthogonal projection on coordinates 3
# and 4  from ReflectionSubGroup(G34,[1..5]). If  one replaces the  2 in
# the  5th  root  by  ER(2),  one  obtains  orthogonal  roots  (but  the
# definition field and invariants become worse).
# The  group thus  defined agrees  with Burkhardt,  Math. Annalen  38 pp
# 208--209 up to an interchange of x and z.

CHEVIE.AddData("GeneratingRoots","G33",
  [[ER(-3),-ER(-3),0,0,0],[0,ER(-3),0,0,-ER(-3)],[0,0,0,-ER(-3),ER(-3)],
   [0,0,0,(3+ER(-3))/2,(3-ER(-3))/2],[-1,-1,2,-1,-1]]);

CHEVIE.AddData("GeneratingCoRoots","G33",
  [[-ER(-3),ER(-3),0,0,0],[0,-ER(-3),0,0,ER(-3)],[0,0,0,ER(-3),-ER(-3)],
   [0,0,0,(3-ER(-3))/2,(3+ER(-3))/2],[-1,-1,1,-1,-1]]/3);

CHEVIE.AddData("CartanMat","G33",function()
  return CHEVIE.RawData("GeneratingCoRoots","G33")*
  TransposedMat(CHEVIE.RawData("GeneratingRoots","G33"));
 end);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G33",[1/2,1/2,1/2,1/2,1/2]);

CHEVIE.AddData("Size","G33", 51840);

CHEVIE.AddData("ReflectionDegrees","G33",[4,6,10,12,18]);

CHEVIE.AddData("NrConjugacyClasses","G33", 40);

CHEVIE.AddData("ParabolicRepresentatives","G33",# repr. of conj. classes
  function(s)local t;
    t:=[[[]],[[1]],[[1,2],[1,3]],[[1..3],[1,3,5],[1,3,4],[2..4]],
      [[1,2,3,5],[1,3,5,10],[1..4],[1,2,4,5]],[[1..5]]];
    return t[s+1];end);

CHEVIE.AddData("ClassNames","G33",
 [".","1","31","12","123","234","243","341","531","1245",
 "1234","1243","5123","ccccc","c","125z","342312","342342","432432",
 "c4213","5432412","3452412","3423412","2431243","34523412","52431243",
 "453423121","3124512342","5342312432","5423124321","423124123121",
 "3245124324524","32451243245124","23452412345241","z342342",
 "345243124532412","ccc","12z","1z","z"]);

CHEVIE.AddData("WordsClassRepresentatives","G33",
 List(CHEVIE.RawData("ClassNames","G33"),x->Replace(x,".",[],"1",[1],
   "2",[2],"3",[3],"4",[4],"5",[5],"z","ccccccccc","c",[5,4,2,1,3])));

CHEVIE.AddData("PowerMaps","G33",
 [ , [ 1, 1, 1, 4, 3, 18, 19, 4, 1, 10, 12, 11, 3, 12, 11, 4, 31, 19, 18, 10,
      33,34,31,31,34, 33, 31, 31, 39, 31, 31, 31, 19, 18, 19, 39, 18, 4,1,1],
  [ 1, 2, 3, 1, 5, 2, 2, 2, 9, 10, 18, 19, 13, 35, 37, 39, 3, 1, 1, 20, 36,
      36, 2, 2, 29, 29, 40, 39, 29, 39, 1, 9, 39, 39, 40, 36, 40, 40, 39, 40 ]
   ,, [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 1, 12, 11, 13, 15, 14, 16, 17, 19, 18, 40,
      22, 21,24,23,26,25,27,30,29,28,31,32, 34, 33, 37, 36, 35, 38, 39, 40 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21,22,23,24,25,26,27,28,29,30,31,32, 33, 34, 35, 36, 37, 38, 39, 40 ],,,,
  [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 10, 12, 11, 13, 15, 14, 16, 17, 19, 18, 20,
      22,21,24,23,26,25,27,30,29,28,31, 32, 34, 33, 37, 36, 35, 38, 39, 40 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21,22,23,24,25,26,27,28,29,30,31,32, 33, 34, 35, 36, 37, 38, 39, 40 ],,,,
  [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 10, 12, 11, 13, 15, 14, 16, 17, 19, 18, 20,
      22,21,24,23,26,25,27,30,29,28,31,32,34, 33, 37, 36, 35, 38, 39, 40 ] ]);

CHEVIE.AddData("ClassInfo","G33",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G33"),
    classnames:=CHEVIE.RawData("ClassNames","G33"),
    classparams:=CHEVIE.RawData("ClassNames","G33"),
    orders:=[1,2,2,3,4,6,6,6,2,5,9,9,4,18,18,6,6,3,3,
             10,12,12,6,6,12,12,6,6,4,6,3,6,6,6,6,4,6,6,2,2],
    classes:=[1,45,270,480,3240,360,360,1440,270,5184,2880,2880,3240,2880,
  2880, 1440, 2160, 40, 40, 5184, 2160, 2160, 720, 720, 2160, 2160, 240, 720,
  540, 720, 240, 2160, 360, 360, 40, 540, 40, 480, 45, 1 ]));

CHEVIE.AddData("CharInfo","G33",function()local res;
  res:=rec(charparams:=[[1,0],[1,45],[5,28],[5,1],[5,30],[5,3],[6,20],
    [6,5],[10,8,2],[10,17,2],[10,8,1],[10,17,1],[15,12],[15,9],
    [15,2],[15,23],[20,6],[20,15],[24,4],[24,19],[30,18],[30,3],[30,6],[30,15],
    [30,4],[30,13],[40,14,1],[40,5,1],[40,14,2],[40,5,2],[45,12],
    [45,9],[45,10],[45,7],[60,10],[60,7],[64,8],[64,9],[81,6],[81,11]],
# here the labelling is as follows: phi_10,8' has fake degree q^28+q^26+...,
# phi_40,5' has fake degree q^31+q^29+2q^27+...
# phi_10,8' tensored by sign is phi_10,17' and
# phi_40,5' tensored by sign is phi_40,14'
  extRefl:=[1,4,9,12,5,2]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,2,2,1,1];
  return res;
end);

CHEVIE.AddData("CycPolSchurElements","G33",
[ [1,0,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [1,-45,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [(3+ER(-3))/2,-28,2,2,2,2,2,3,3,3,4,4,6,6,6,1/9,4/9,7/9,1/12,7/12,5/18,11/18,
    17/18],
  [(3-ER(-3))/2,-1,2,2,2,2,2,3,3,3,4,4,6,6,6,2/9,5/9,8/9,5/12,11/12,1/18,7/18,
   13/18],
  [(3-ER(-3))/2,-28,2,2,2,2,2,3,3,3,4,4,6,6,6,2/9,5/9,8/9,5/12,11/12,1/18,7/18,
  13/18],
  [(3+ER(-3))/2,-1,2,2,2,2,2,3,3,3,4,4,6,6,6,1/9,4/9,7/9,1/12,7/12,5/18,11/18,
   17/18], [2,-18,2,2,2,2,2,3,3,3,5,6,6,6], [2,-3,2,2,2,2,2,3,3,3,5,6,6,6],
  [6*E(3)^2,-4,2,2,2,2,2,3,3,3,5/6,5/6,5/6,1/18,7/18,13/18],
  [6*E(3),-13,2,2,2,2,2,3,3,3,1/6,1/6,1/6,5/18,11/18,17/18],
  [6*E(3),-4,2,2,2,2,2,3,3,3,1/6,1/6,1/6,5/18,11/18,17/18],
  [6*E(3)^2,-13,2,2,2,2,2,3,3,3,5/6,5/6,5/6,1/18,7/18,13/18],
  [1,-12,2,2,2,2,2,3,3,3,4,4,6,6,6], [1,-9,2,2,2,2,2,3,3,3,4,4,6,6,6],
  [1,-2,2,2,2,2,2,3,3,3,4,4,6,6,6,12],
  [1,-23,2,2,2,2,2,3,3,3,4,4,6,6,6,12], [3,-4,2,2,2,2,2,3,3,3,6,6,6],
  [3,-13,2,2,2,2,2,3,3,3,6,6,6], [2,-3,2,3,3,3,4,4,5,6,12],
  [2,-18,2,3,3,3,4,4,5,6,12], [2,-18,2,2,2,2,2,3,3,3,6,6,6,10],
  [2,-3,2,2,2,2,2,3,3,3,6,6,6,10],
  [-6*E(3)^2,-4,2,2,2,2,2,1/3,1/3,1/3,6,6,6,2/9,5/9,8/9],
  [-6*E(3),-13,2,2,2,2,2,2/3,2/3,2/3,6,6,6,1/9,4/9,7/9],
  [-6*E(3),-4,2,2,2,2,2,2/3,2/3,2/3,6,6,6,1/9,4/9,7/9],
  [-6*E(3)^2,-13,2,2,2,2,2,1/3,1/3,1/3,6,6,6,2/9,5/9,8/9],
  [3-ER(-3),-13,2,3,3,3,4,4,5/6,2/9,5/9,8/9,1/12,7/12],
  [3+ER(-3),-4,2,3,3,3,4,4,1/6,1/9,4/9,7/9,5/12,11/12],
  [3+ER(-3),-13,2,3,3,3,4,4,1/6,1/9,4/9,7/9,5/12,11/12],
  [3-ER(-3),-4,2,3,3,3,4,4,5/6,2/9,5/9,8/9,1/12,7/12],
  [(3-ER(-3))/2,-10,2,2,2,2,2,1/3,1/3,1/3,4,4,5/6,5/6,5/6,1/12,7/12],
  [(3+ER(-3))/2,-7,2,2,2,2,2,2/3,2/3,2/3,4,4,1/6,1/6,1/6,5/12,11/12],
  [(3+ER(-3))/2,-10,2,2,2,2,2,2/3,2/3,2/3,4,4,1/6,1/6,1/6,5/12,11/12],
  [(3-ER(-3))/2,-7,2,2,2,2,2,1/3,1/3,1/3,4,4,5/6,5/6,5/6,1/12,7/12],
  [1,-10,2,2,2,2,2,3,3,3,6,6,6], [1,-7,2,2,2,2,2,3,3,3,6,6,6],
  [2,-8,3,3,3,5,9], [2,-8,3,3,3,5,9], [1,-6,2,2,2,2,2,4,4,5,10],
  [1,-11,2,2,2,2,2,4,4,5,10] ]
);

CHEVIE.AddData("sparseFakeDegrees","G33",
[[1,0],[1,45],[1,28,1,34,1,36,1,40,1,42],[1,1,1,7,1,9,1,13,1,15],[1,30,1,32,1,
36,1,38,1,44],[1,3,1,5,1,9,1,11,1,17],[1,20,1,26,1,28,1,32,1,34,1,40],[1,5,1,
11,1,13,1,17,1,19,1,25],[1,8,1,10,1,14,2,16,1,20,2,22,1,24,1,28],[1,17,1,19,1,
23,2,25,1,29,2,31,1,33,1,37],[1,8,1,12,2,14,1,16,2,20,1,22,1,26,1,28],[1,17,1,
21,2,23,1,25,2,29,1,31,1,35,1,37],[1,12,1,16,2,18,1,20,1,22,3,24,1,26,1,28,2,
30,1,32,1,36],[1,9,1,13,2,15,1,17,1,19,3,21,1,23,1,25,2,27,1,29,1,33],[1,2,1,
4,1,6,2,8,2,10,1,12,2,14,2,16,1,18,1,20,1,22],[1,23,1,25,1,27,2,29,2,31,1,33,
2,35,2,37,1,39,1,41,1,43],[1,6,1,8,1,10,2,12,2,14,2,16,2,18,2,20,2,22,2,24,1,
26,1,28,1,30],[1,15,1,17,1,19,2,21,2,23,2,25,2,27,2,29,2,31,2,33,1,35,1,37,1,
39],[1,4,2,6,1,8,2,10,4,12,2,14,2,16,4,18,2,20,1,22,2,24,1,26],[1,19,2,21,1,
23,2,25,4,27,2,29,2,31,4,33,2,35,1,37,2,39,1,41],[1,18,1,20,2,22,3,24,3,26,3,
28,4,30,3,32,3,34,3,36,2,38,1,40,1,42],[1,3,1,5,2,7,3,9,3,11,3,13,4,15,3,17,3,
19,3,21,2,23,1,25,1,27],[1,6,2,8,1,10,3,12,4,14,2,16,3,18,5,20,2,22,2,24,3,26,
1,28,1,32],[1,15,2,17,1,19,3,21,4,23,2,25,3,27,5,29,2,31,2,33,3,35,1,37,1,41],
[1,4,1,8,3,10,2,12,2,14,5,16,3,18,2,20,4,22,3,24,1,26,2,28,1,30],[1,13,1,17,3,
19,2,21,2,23,5,25,3,27,2,29,4,31,3,33,1,35,2,37,1,39],[1,14,2,16,1,18,3,20,5,
22,3,24,4,26,6,28,4,30,3,32,4,34,2,36,1,38,1,40],[1,5,2,7,1,9,3,11,5,13,3,15,
4,17,6,19,4,21,3,23,4,25,2,27,1,29,1,31],[1,14,1,16,2,18,4,20,3,22,4,24,6,26,
4,28,3,30,5,32,3,34,1,36,2,38,1,40],[1,5,1,7,2,9,4,11,3,13,4,15,6,17,4,19,3,
21,5,23,3,25,1,27,2,29,1,31],[2,12,2,14,2,16,5,18,5,20,3,22,6,24,6,26,3,28,4,
30,4,32,1,34,1,36,1,38],[2,9,2,11,2,13,5,15,5,17,3,19,6,21,6,23,3,25,4,27,4,
29,1,31,1,33,1,35],[1,10,1,12,1,14,4,16,4,18,3,20,6,22,6,24,3,26,5,28,5,30,2,
32,2,34,2,36],[1,7,1,9,1,11,4,13,4,15,3,17,6,19,6,21,3,23,5,25,5,27,2,29,2,31,
2,33],[1,10,2,12,2,14,4,16,6,18,5,20,6,22,8,24,6,26,5,28,6,30,4,32,2,34,2,36,
1,38],[1,7,2,9,2,11,4,13,6,15,5,17,6,19,8,21,6,23,5,25,6,27,4,29,2,31,2,33,1,
35],[1,8,1,10,2,12,5,14,5,16,5,18,8,20,8,22,5,24,7,26,7,28,3,30,3,32,3,34,1,
36],[1,9,3,11,3,13,3,15,7,17,7,19,5,21,8,23,8,25,5,27,5,29,5,31,2,33,1,35,1,
37],[1,6,2,8,4,10,5,12,7,14,8,16,9,18,9,20,9,22,8,24,7,26,5,28,4,30,2,32,1,
34],[1,11,2,13,4,15,5,17,7,19,8,21,9,23,9,25,9,27,8,29,7,31,5,33,4,35,2,37,1,
39]]);

# Computed JM may 2009
# Some columns contain only unknown entries
CHEVIE.AddData("HeckeCharTable","G33",function(para,root)
  local x,y,tbl,f1,f3,f7,f9,f13,f15,f17,f19,f21,f23,f27,f31,f35,f37,f39;
  x:=para[1][1]; y:=para[1][2];
  tbl:=rec(
  identifier:="H(G33)",
  size:=51840, order:=51840,
  powermap:=CHEVIE.RawData("PowerMaps","G33"));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","G33"));
  f1:=function(x)return
  [1,x,x^2,x^2,x^3,x^3,x^3,x^3,x^3,x^4,x^4,x^4,x^4,x^25,x^5,x^48,x^6,x^6,x^6,
x^9,x^7,x^7,x^7,x^7,x^8,x^8,x^9,x^10,x^10,x^10,x^12,x^13,x^14,x^14,x^51,x^15,
x^15,x^47,x^46,x^45];end;
  f3:=function(x,y,j)return  [5,x+4*y,2*x*y+3*y^2,x*y+3*y^2,x*y^2+2*y^3,
  -j^2*x*y^2+2*y^3,j*x^2*y+2*y^3,2*x*y^2+2*y^3,3*x*y^2+2*y^3,x*y^3+y^4,
  -j^2*x*y^3+y^4,j*x^2*y^2+y^4,2*x*y^3+y^4,-j*x^5*y^20,-j^2*x*y^4,
  2*x^9*y^39+2*x^10*y^38,j*x*y^5+j*x^2*y^4+y^6,3*j*x^2*y^4+2*y^6,-2*j^2*x*y^5+
j^2*x^4*y^2+2*y^6,0,j*x*y^6-j^2*x^2*y^5-j*x^3*y^4,j*x*y^6,
2*j*x^2*y^5+y^7,-2*j^2*x*y^6+x^2*y^5-j*x^3*y^4+j^2*x^4*y^3+y^7,
j*x^2*y^6,-2*j^2*x*y^7+2*x^2*y^6-2*j*x^3*y^5+j^2*x^4*y^4,
j*x*y^8+j^2*x^3*y^6,(j^2-j)*x^3*y^7,(-j^2-2*j)*x^2*y^8+
(j^2-j)*x^3*y^7+j^2*x^4*y^6,-j^2*x*y^9-2*j*x^2*y^8+
(j^2-j)*x^3*y^7+j^2*x^4*y^6,j^2*x^2*y^10-2*j*x^3*y^9+
j^2*x^4*y^8+y^12,(j^2-j)*x^2*y^11+(j^2-j)*x^3*y^10+
j*x^4*y^9-j^2*x^5*y^8,3*j^2*x^2*y^12-2*x^3*y^11+(-2*j^2+
j)*x^4*y^10+2*x^5*y^9+j^2*x^6*y^8,j^2*x^2*y^12-2*j*x^3*y^11,
2*x^9*y^42+3*j*x^11*y^40,(3*j^2+j)*x^2*y^13+(2*j^2+j)*x^3*y^12+
(-j^2+j)*x^4*y^11-j^2*x^5*y^10,(j^2-2*j)*x^3*y^12,3*x^9*y^38+
x^10*y^37,4*x^9*y^37+x^10*y^36,5*x^9*y^36];end;
  f7:=function(x,y)return 
[6,2*x+4*y,2*x*y+x^2+3*y^2,2*x*y+2*y^2,x*y^2+y^3,x*y^2,-x^2*y,x*y^2+x^2*y+2*y^3,
3*x*y^2+x^3+2*y^3,y^4,0,-x*y^3-x^2*y^2,x*y^3+y^4,0,0,2*x^15*y^33+x^16*y^32+
x^17*y^31,-x^2*y^4,-3*x^2*y^4,2*x*y^5-x^4*y^2,x^3*y^6,x^2*y^5+x^3*y^4-x^5*y^2,
x^2*y^5,-x^2*y^5,2*x*y^6+2*x^2*y^5+x^3*y^4-x^4*y^3-x^5*y^2,x^3*y^5,2*x*y^7+
3*x^2*y^6+3*x^3*y^5-x^4*y^4-2*x^5*y^3,x*y^8+2*x^3*y^6,-x^5*y^5,x^2*y^8-
x^4*y^6-2*x^5*y^5,x*y^9+x^2*y^8-x^4*y^6-2*x^5*y^5,-2*x^3*y^9-x^4*y^8-
2*x^5*y^7,-2*x^3*y^10-2*x^4*y^9-x^5*y^8+x^6*y^7+x^7*y^6,-2*x^3*y^11-x^4*y^10+
2*x^5*y^9+3*x^6*y^8-2*x^8*y^6+x^10*y^4,-x^4*y^10-2*x^5*y^9,-3*x^17*y^34,-
x^4*y^11+3*x^5*y^10+3*x^6*y^9+x^7*y^8,-3*x^5*y^10,2*x^15*y^32+2*x^16*y^31,
4*x^15*y^31+2*x^16*y^30,6*x^15*y^30];end;
  f9:=function(x,y,j)return 
  [10,6*x+4*y,6*x*y+3*x^2+y^2,3*x*y+3*x^2+y^2,x*y^2+2*x^2*y+x^3,
-j*x*y^2-2*j^2*x^2*y+x^3,2*j*x*y^2+j^2*x^2*y+x^3,2*x*y^2+4*x^2*y+
x^3,3*x*y^2+6*x^2*y+x^3,x^2*y^2+x^3*y,-j^2*x^3*y,j*x*y^3+(j^2+
2*j)*x^2*y^2+j^2*x^3*y,2*x^2*y^2+2*x^3*y,j^2*x^15*y^10,j*x^3*y^2,
2*x^28*y^20+4*x^29*y^19+x^30*y^18,-x^3*y^3+j*x^4*y^2+j*x^5*y,
3*j^2*x^2*y^4+6*j*x^4*y^2+x^6,-2*j*x*y^5+2*j^2*x^2*y^4+
j*x^4*y^2-4*j^2*x^5*y+x^6,0,-j^2*x^5*y^2,j*x^4*y^3,j^2*x^3*y^4+
j*x^4*y^3+2*j*x^5*y^2,(j^2-j)*x^2*y^5-2*j*x^3*y^4+
2*x^4*y^3-2*j^2*x^5*y^2-2*j^2*x^6*y,j*x^5*y^3,
(2*j^2-j)*x^3*y^5+(-2*j^2-5*j)*x^4*y^4+(-5*j^2-3*j)*x^5*y^3+
(-2*j^2+j)*x^6*y^2,x^5*y^4,-x^4*y^6+j^2*x^6*y^4+j^2*x^7*y^3,
(2*j^2+j)*x^5*y^5+(j^2-j)*x^6*y^4+j^2*x^7*y^3,-x^5*y^5+
2*j^2*x^6*y^4-2*j*x^7*y^3,-2*x^5*y^7-x^6*y^6-2*x^7*y^5+
j^2*x^8*y^4-2*j*x^9*y^3+j^2*x^10*y^2,x^5*y^8+2*j^2*x^7*y^6+
(2*j^2+j)*x^8*y^5+(j^2+2*j)*x^9*y^4-x^10*y^3,
-2*j^2*x^6*y^8-2*x^7*y^7+4*j^2*x^8*y^6-2*j*x^9*y^5+(-2*j^2+
j)*x^10*y^4,3*j^2*x^8*y^6-2*x^9*y^5,3*j^2*x^29*y^22+6*j*x^31*y^20+
x^33*y^18,2*x^7*y^8-j*x^8*y^7+2*j^2*x^9*y^6+
j*x^10*y^5-2*j^2*x^11*y^4,(5*j^2+2*j)*x^9*y^6,x^27*y^20+
3*x^28*y^19+3*x^29*y^18,4*x^27*y^19+6*x^28*y^18,10*x^27*y^18];end;
  f13:=function(x,y)return 
[15,7*x+8*y,8*x*y+3*x^2+4*y^2,5*x*y+2*x^2+3*y^2,2*x*y^2+2*x^2*y+
y^3,x*y^2+x^3,-x^2*y-y^3,5*x*y^2+3*x^2*y+x^3+y^3,6*x*y^2+6*x^2*y+x^3+2*y^3,
x*y^3+x^2*y^2,0,-x*y^3-x^2*y^2-x^3*y-y^4,2*x*y^3+2*x^2*y^2+x^3*y,0,0,
x^21*y^27+5*x^22*y^26+3*x^23*y^25+x^24*y^24,-x^2*y^4-x^3*y^3-x^4*y^2,-
3*x^2*y^4-8*x^3*y^3+x^6,2*x*y^5-6*x^3*y^3-x^4*y^2+2*x^6+y^6,0,
x*y^6+x^2*y^5+x^3*y^4+x^4*y^3,
0,-2*x^3*y^4-x^4*y^3,2*x*y^6+3*x^2*y^5-2*x^4*y^3-x^5*y^2+y^7,
0,2*x*y^7+3*x^2*y^6+2*x^3*y^5-x^4*y^4-2*x^5*y^3-x^6*y^2+y^8,
x^3*y^6+x^5*y^4+x^7*y^2,x^7*y^3,x^2*y^8+x^4*y^6-x^5*y^5+x^7*y^3+x^8*y^2,
-2*x^4*y^6-x^5*y^5+x^7*y^3+x^8*y^2,-x^4*y^8-2*x^5*y^7-x^6*y^6+3*x^8*y^4,
x^4*y^9+4*x^5*y^8+6*x^6*y^7+3*x^7*y^6+x^8*y^5,
x^2*y^12+2*x^3*y^11+3*x^4*y^10+6*x^5*y^9+9*x^6*y^8+4*x^7*y^7-x^8*y^6-2*x^9*y^5,
4*x^6*y^8+2*x^7*y^7,-3*x^23*y^28-8*x^24*y^27+x^27*y^24,
-x^4*y^11+x^5*y^10+4*x^6*y^9+5*x^7*y^8-2*x^8*y^7-3*x^9*y^6-x^10*y^5,6*x^7*y^8,
3*x^21*y^26+5*x^22*y^25+2*x^23*y^24,8*x^21*y^25+7*x^22*y^24,15*x^21*y^24];end;
  f15:=function(x,y)return [15,11*x+4*y,
6*x*y+8*x^2+y^2,4*x*y+7*x^2,3*x^2*y+4*x^3,2*x^2*y+3*x^3,-2*x*y^2+3*x^3,x*y^2+
5*x^2*y+5*x^3,3*x*y^2+6*x^2*y+6*x^3,2*x^3*y+2*x^4,x^3*y+x^4,-2*x^2*y^2-x^3*y+
x^4,x^2*y^2+3*x^3*y+3*x^4,0,0,x^34*y^14+5*x^35*y^13+5*x^36*y^12,-2*x^4*y^2-
x^5*y+x^6,-6*x^4*y^2+3*x^6,-2*x^2*y^4+4*x^5*y+3*x^6,0,-x^3*y^4+x^4*y^3+x^5*y^2,
-x^5*y^2,-3*x^5*y^2+x^7,-x^2*y^5-2*x^3*y^4+2*x^4*y^3+4*x^5*y^2+4*x^6*y+
x^7,-x^6*y^2,-x^3*y^5-2*x^4*y^4+3*x^5*y^3+7*x^6*y^2+4*x^7*y,-x^5*y^4+x^7*y^2,
-2*x^6*y^4,-x^5*y^5-3*x^6*y^4+x^7*y^3+2*x^8*y^2,
-x^5*y^5-3*x^6*y^4+2*x^8*y^2+2*x^9*y,-2*x^7*y^5-2*x^8*y^4-x^10*y^2+x^12,
2*x^7*y^6+2*x^8*y^5-2*x^9*y^4-4*x^10*y^3-2*x^11*y^2,
x^6*y^8-2*x^7*y^7-x^8*y^6+4*x^9*y^5+3*x^10*y^4-4*x^11*y^3-4*x^12*y^2,
-x^10*y^4-2*x^11*y^3,-6*x^37*y^14+3*x^39*y^12,
x^9*y^6+3*x^10*y^5-3*x^12*y^3-2*x^13*y^2,-3*x^11*y^4,
4*x^34*y^13+7*x^35*y^12,4*x^33*y^13+11*x^34*y^12,15*x^33*y^12];end;
  f17:=function(x,y)return [20,12*x+8*y,
8*x*y+8*x^2+4*y^2,7*x*y+5*x^2+y^2,x*y^2+3*x^2*y+2*x^3,2*x^2*y,-2*x*y^2-x^3-
y^3,3*x*y^2+5*x^2*y+4*x^3+y^3,6*x*y^2+6*x^2*y+6*x^3+2*y^3,x^3*y+x^4,-x^2*y^2,-
x*y^3-3*x^2*y^2-2*x^3*y-x^4,x*y^3+x^2*y^2+2*x^3*y+2*x^4,-x^15*y^10,-x^3*y^2,
x^27*y^21+3*x^28*y^20+5*x^29*y^19+4*x^30*y^18,-3*x^3*y^3-2*x^4*y^2,-8*x^3*y^3-
6*x^4*y^2,-2*x^2*y^4-6*x^3*y^3+4*x^5*y+x^6+y^6,0,x^4*y^3+2*x^5*y^2+x^6*y,0,-
x^3*y^4-3*x^4*y^3-x^5*y^2,-2*x^2*y^5-3*x^3*y^4+5*x^5*y^2+4*x^6*y+x^7,
0,-x^2*y^6-3*x^3*y^5-2*x^4*y^4+3*x^5*y^3+6*x^6*y^2+4*x^7*y+x^8,
x^3*y^6+2*x^5*y^4+2*x^7*y^2,x^4*y^6-x^6*y^4-x^7*y^3,x^3*y^7+x^4*y^6-2*x^5*y^5
-2*x^6*y^4+x^7*y^3+x^8*y^2,x^3*y^7+x^4*y^6-2*x^5*y^5-3*x^6*y^4-x^7*y^3+x^8*y^2,
x^6*y^6-4*x^7*y^5-2*x^8*y^4-2*x^9*y^3,2*x^6*y^7+4*x^7*y^6+3*x^8*y^5+2*x^9*y^4,
-2*x^6*y^8+5*x^8*y^6+8*x^9*y^5+6*x^10*y^4+4*x^11*y^3+x^12*y^2,2*x^9*y^5,
-8*x^30*y^21-6*x^31*y^20,-x^6*y^9-2*x^7*y^8+4*x^9*y^6+5*x^10*y^5+2*x^11*y^4,
2*x^9*y^6,
x^27*y^20+7*x^28*y^19+5*x^29*y^18,8*x^27*y^19+12*x^28*y^18,20*x^27*y^18];end;
  f19:=function(x,y)return [24,16*x+8*y,12*x*y+10*x^2+2*y^2,7*x*y+9*x^2+y^2,
  x*y^2+5*x^2*y+4*x^3,2*x^2*y+4*x^3,-2*x*y^2+3*x^3-y^3,3*x*y^2+9*x^2*y+5*x^3,
  6*x*y^2+12*x^2*y+6*x^3,x^2*y^2+3*x^3*y+x^4,x^3*y+x^4,-x*y^3-2*x^2*y^2-x^3*y,
  3*x^2*y^2+5*x^3*y+2*x^4,0,0,-3*x^31*y^17-9*x^32*y^16-5*x^33*y^15,
  -x^3*y^3-3*x^4*y^2-x^5*y+x^6,-8*x^3*y^3-6*x^4*y^2+4*x^6,
  -2*x^2*y^4-6*x^3*y^3+4*x^5*y+5*x^6+y^6,x^6*y^3,-x^2*y^5+x^4*y^3+x^5*y^2+x^6*y,
  0,-3*x^4*y^3-2*x^5*y^2+x^7,-x^2*y^5-2*x^3*y^4+5*x^5*y^2+4*x^6*y+2*x^7,0,
-2*x^3*y^5-2*x^4*y^4+4*x^5*y^3+7*x^6*y^2+4*x^7*y+x^8,-x^4*y^5+x^6*y^3,
-2*x^5*y^5-x^7*y^3-x^8*y^2,-x^4*y^6-3*x^5*y^5-3*x^6*y^4-x^7*y^3,
-x^4*y^6-3*x^5*y^5-3*x^6*y^4-2*x^7*y^3+x^8*y^2,
-x^6*y^6-2*x^7*y^5+x^8*y^4+2*x^9*y^3-x^10*y^2+x^12,
x^6*y^7+2*x^7*y^6-x^8*y^5-4*x^9*y^4-3*x^10*y^3-x^11*y^2,
x^4*y^10-2*x^7*y^7+x^8*y^6+4*x^9*y^5+x^10*y^4+x^12*y^2,-4*x^9*y^5-2*x^10*y^4,
8*x^33*y^18+6*x^34*y^17-4*x^36*y^15,
x^8*y^7+2*x^9*y^6+x^10*y^5+x^11*y^4+2*x^12*y^3+x^13*y^2,-6*x^10*y^5,
-x^30*y^17-7*x^31*y^16-9*x^32*y^15,-8*x^30*y^16-16*x^31*y^15,-24*x^30*y^15];end;
  f21:=function(x,y)return 
  [30,10*x+20*y,14*x*y+3*x^2+13*y^2,9*x*y+x^2+11*y^2,6*x*y^2+x^2*y+5*y^3,
3*x*y^2+4*y^3,-3*x^2*y-x^3+3*y^3,10*x*y^2+4*x^2*y+7*y^3,15*x*y^2+6*x^2*y+x^3+
8*y^3,3*x*y^3+x^2*y^2+2*y^4,x*y^3+y^4,-2*x*y^3-3*x^2*y^2-x^3*y,6*x*y^3+
3*x^2*y^2+3*y^4,0,0,7*x^15*y^33+10*x^16*y^32+4*x^17*y^31,
-x*y^5-4*x^2*y^4-x^3*y^3+y^6,-9*x^2*y^4-8*x^3*y^3+4*y^6,
6*x*y^5-6*x^3*y^3-3*x^4*y^2+x^6+5*y^6,0,x*y^6+2*x^2*y^5+2*x^3*y^4,-x^2*y^5,
-3*x^2*y^5-3*x^3*y^4+y^7,6*x*y^6+7*x^2*y^5+x^3*y^4-3*x^4*y^3-2*x^5*y^2+2*y^7,
-x^3*y^5,6*x*y^7+10*x^2*y^6+3*x^3*y^5-3*x^4*y^4-2*x^5*y^3+y^8,x*y^8+x^3*y^6+
x^5*y^4,-x^2*y^8-x^3*y^7+x^5*y^5,x^2*y^8+x^3*y^7-2*x^4*y^6+x^5*y^5+x^6*y^4,
x*y^9-2*x^3*y^7-2*x^4*y^6+x^5*y^5+x^6*y^4,-x^2*y^10-4*x^5*y^7-x^6*y^6+y^12,
-x^2*y^11-x^3*y^10+4*x^4*y^9+6*x^5*y^8+3*x^6*y^7,x^2*y^12+6*x^3*y^11+
12*x^4*y^10+6*x^5*y^9-4*x^6*y^8-2*x^7*y^7+2*x^8*y^6-2*x^10*y^4,x^4*y^10+
2*x^5*y^9,4*x^15*y^36-9*x^17*y^34-8*x^18*y^33,x^2*y^13+2*x^3*y^12+
4*x^4*y^11-3*x^6*y^9-2*x^7*y^8,3*x^5*y^10,11*x^15*y^32+9*x^16*y^31+x^17*y^30,
20*x^15*y^31+10*x^16*y^30,30*x^15*y^30];end;
  f23:=function(x,y,j)return 
[30,18*x+12*y,14*x*y+11*x^2+5*y^2,10*x*y+8*x^2+2*y^2,2*x*y^2+5*x^2*y+3*x^3,
-j*x*y^2+(-2*j^2-4*j)*x^2*y+x^3,(4*j^2+2*j)*x*y^2+j^2*x^2*y-y^3,5*x*y^2+
9*x^2*y+5*x^3+y^3,9*x*y^2+12*x^2*y+7*x^3+2*y^3,x^2*y^2+2*x^3*y+x^4,
-j*x^2*y^2-j*x^3*y,(2*j^2+j)*x*y^3+(4*j^2+2*j)*x^2*y^2+(3*j^2+2*j)*x^3*y-x^4,
x*y^3+3*x^2*y^2+4*x^3*y+2*x^4,0,0,x^27*y^21+5*x^28*y^20+9*x^29*y^19+
5*x^30*y^18,-x^3*y^3+(3*j^2+2*j)*x^4*y^2+j^2*x^5*y,3*j^2*x^2*y^4-8*x^3*y^3+
(12*j^2+6*j)*x^4*y^2+x^6,-2*j*x*y^5+(2*j^2+4*j)*x^2*y^4-6*x^3*y^3+j*x^4*y^2+
(-4*j^2-8*j)*x^5*y+2*x^6+y^6,0,(2*j^2+j)*x^2*y^5+(j^2+2*j)*x^3*y^4+(-j^2+
2*j)*x^4*y^3-2*j^2*x^5*y^2+x^6*y,j*x^4*y^3,-2*x^4*y^3+(3*j^2+j)*x^5*y^2,(j^2+
3*j)*x^2*y^5+(j^2+6*j)*x^3*y^4+(-3*j^2+2*j)*x^4*y^3+(-7*j^2-5*j)*x^5*y^2+
(-4*j^2-6*j)*x^6*y+x^7,j*x^5*y^3,-x^2*y^6+(7*j^2+6*j)*x^3*y^5+(10*j^2+
11*j)*x^4*y^4+(2*j^2+8*j)*x^5*y^3+(-6*j^2-j)*x^6*y^2+4*x^7*y+x^8,j*x^3*y^6+
(2*j^2+j)*x^5*y^4-x^7*y^2,(-j^2+j)*x^4*y^6,j*x^3*y^7+j*x^4*y^6+(4*j^2+
3*j)*x^5*y^5+(4*j^2+3*j)*x^6*y^4-x^7*y^3+x^8*y^2,j*x^3*y^7+j*x^4*y^6+(2*j^2+
j)*x^5*y^5+5*j^2*x^6*y^4+3*j^2*x^7*y^3+j^2*x^8*y^2,-2*j*x^5*y^7+(5*j^2+
j)*x^6*y^6+(4*j^2+2*j)*x^7*y^5+(2*j^2+3*j)*x^8*y^4+2*j*x^9*y^3+j*x^10*y^2,
j^2*x^5*y^8+2*j*x^6*y^7+(-5*j^2+5*j)*x^7*y^6+(-9*j^2+3*j)*x^8*y^5+(-5*j^2+
j)*x^9*y^4-j^2*x^10*y^3,-3*j^2*x^4*y^10+(-8*j^2-4*j)*x^5*y^9+
(-2*j^2-11*j)*x^6*y^8+(16*j^2-6*j)*x^7*y^7+(26*j^2+13*j)*x^8*y^6+(16*j^2+
20*j)*x^9*y^5+(4*j^2+10*j)*x^10*y^4-2*j^2*x^11*y^3+x^12*y^2,(-j^2+
4*j)*x^8*y^6+(-2*j^2+2*j)*x^9*y^5,3*j^2*x^29*y^22-8*x^30*y^21+(12*j^2+
6*j)*x^31*y^20+x^33*y^18,-j*x^6*y^9+(j^2-4*j)*x^7*y^8+(7*j^2-2*j)*x^8*y^7+
(10*j^2+2*j)*x^9*y^6+(8*j^2+4*j)*x^10*y^5+3*j^2*x^11*y^4+(j^2-j)*x^12*y^3,
(-3*j^2+6*j)*x^9*y^6,2*x^27*y^20+10*x^28*y^19+8*x^29*y^18,12*x^27*y^19+
18*x^28*y^18,30*x^27*y^18];
end;
  f27:=function(x,y,j)return 
[40,16*x+24*y,20*x*y+6*x^2+14*y^2,13*x*y+3*x^2+11*y^2,7*x*y^2+3*x^2*y+4*y^3,
4*x*y^2-2*j^2*x^2*y+2*y^3,2*j*x*y^2-4*x^2*y-x^3+y^3,13*x*y^2+7*x^2*y+x^3+
6*y^3,18*x*y^2+12*x^2*y+2*x^3+8*y^3,3*x*y^3+2*x^2*y^2+y^4,x*y^3-j^2*x^2*y^2,
(2*j^2+4*j)*x*y^3+(4*j^2+5*j)*x^2*y^2-2*x^3*y-y^4,6*x*y^3+5*x^2*y^2+x^3*y+
2*y^4,-j*x^10*y^15,-j^2*x^2*y^3,-6*x^18*y^30-13*x^19*y^29-7*x^20*y^28-
x^21*y^27,-x*y^5-3*x^2*y^4-2*x^3*y^3,-12*x^2*y^4-8*x^3*y^3+6*j*x^4*y^2+2*y^6,
8*x*y^5+2*j^2*x^2*y^4-6*x^3*y^3-4*x^4*y^2-4*j^2*x^5*y+x^6+3*y^6,0,x*y^6+(-
2*j^2-3*j)*x^2*y^5+(-2*j^2-3*j)*x^3*y^4-j*x^4*y^3+j^2*x^5*y^2,0,-3*x^2*y^5+
(3*j^2+2*j)*x^3*y^4+j*x^4*y^3,6*x*y^6+(-5*j^2-9*j)*x^2*y^5-5*j*x^3*y^4+(4*j^2+
j)*x^4*y^3-2*x^5*y^2+y^7,0,4*x*y^7+(-4*j^2-8*j)*x^2*y^6+(j^2-7*j)*x^3*y^5+
6*j^2*x^4*y^4+(5*j^2+3*j)*x^5*y^3-x^6*y^2+y^8,x^2*y^7-j*x^4*y^5-j^2*x^6*y^3,
j*x^3*y^7+j*x^4*y^6-2*j^2*x^6*y^4,x^2*y^8-j^2*x^3*y^7+(2*j^2+3*j)*x^4*y^6-
2*x^5*y^5-j^2*x^6*y^4-j^2*x^7*y^3,-j*x^2*y^8+(2*j^2+3*j)*x^3*y^7+(4*j^2+
5*j)*x^4*y^6+(2*j^2+3*j)*x^5*y^5-j^2*x^6*y^4-j^2*x^7*y^3,-x^2*y^10-3*x^4*y^8+
(4*j^2+6*j)*x^5*y^7+(2*j^2+6*j)*x^6*y^6+2*j*x^7*y^5,-j^2*x^3*y^10+(-5*j^2-
2*j)*x^4*y^9+(-10*j^2-7*j)*x^5*y^8+(-9*j^2-7*j)*x^6*y^7+2*x^7*y^6+j^2*x^8*y^5,
x^2*y^12+(-4*j^2-2*j)*x^3*y^11+(-9*j^2-2*j)*x^4*y^10-6*j^2*x^5*y^9+(j^2+
6*j)*x^6*y^8+(8*j^2+10*j)*x^7*y^7+(5*j^2+4*j)*x^8*y^6+j*x^10*y^4,-
4*j^2*x^5*y^9+(-4*j^2-2*j)*x^6*y^8,-2*x^18*y^33+12*x^20*y^31+8*x^21*y^30-
6*j*x^22*y^29,-x^3*y^12+(2*j^2+3*j)*x^4*y^11+(j^2+4*j)*x^5*y^10+(2*j^2+
4*j)*x^6*y^9+(5*j^2+3*j)*x^7*y^8+(4*j^2+j)*x^8*y^7+j^2*x^9*y^6,(-8*j^2-
2*j)*x^6*y^9,-11*x^18*y^29-13*x^19*y^28-3*x^20*y^27,-24*x^18*y^28-
16*x^19*y^27,-40*x^18*y^27];end;
  f31:=function(x,y,j)return 
[45,21*x+24*y,24*x*y+9*x^2+12*y^2,15*x*y+6*x^2+9*y^2,7*x*y^2+5*x^2*y+x^3+
2*y^3,(-j^2-4*j)*x*y^2+2*x^2*y+2*y^3,-2*x*y^2+(4*j^2+
j)*x^2*y-2*x^3,13*x*y^2+11*x^2*y+2*x^3+4*y^3,18*x*y^2+18*x^2*y+3*x^3+6*y^3,
2*x*y^3+3*x^2*y^2+x^3*y,-j*x*y^3-j*x^2*y^2,-3*x*y^3+(5*j^2+
3*j)*x^2*y^2+(4*j^2+2*j)*x^3*y-x^4-y^4,4*x*y^3+7*x^2*y^2+3*x^3*y+y^4,
0,0,4*x^21*y^27+13*x^22*y^26+11*x^23*y^25+2*x^24*y^24,j^2*x*y^5+(3*j^2+
2*j)*x^2*y^4-3*x^3*y^3-x^4*y^2,(12*j^2+3*j)*x^2*y^4-16*x^3*y^3-6*x^4*y^2+2*y^6,
(-2*j^2-8*j)*x*y^5-2*x^2*y^4-12*x^3*y^3+(j^2+4*j)*x^4*y^2+4*x^5*y+
2*x^6+4*y^6,0, -j^2*x^2*y^5-2*j^2*x^3*y^4-2*j^2*x^4*y^3, j*x^3*y^4,
2*j^2*x^2*y^5+(4*j^2+3*j)*x^3*y^4+(2*j^2+3*j)*x^4*y^3,
(-2*j^2-4*j)*x*y^6+3*x^2*y^5+(-j^2+
3*j)*x^3*y^4+(-2*j^2+4*j)*x^4*y^3-4*j^2*x^5*y^2+2*x^6*y+x^7+y^7,
j*x^4*y^4,
-x^2*y^6+(2*j^2+4*j)*x^3*y^5+(2*j^2+6*j)*x^4*y^4+4*j*x^5*y^3+j*x^6*y^2, 0,
-j^2*x^2*y^8-j^2*x^7*y^3, -2*x^4*y^6-3*x^5*y^5,
j^2*x^3*y^7+(4*j^2+2*j)*x^4*y^6+(5*j^2+2*j)*x^5*y^5+2*j^2*x^6*y^4,
j*x^2*y^10-2*j^2*x^3*y^9+(-2*j^2-j)*x^4*y^8+(4*j^2+
2*j)*x^5*y^7+(7*j^2+3*j)*x^6*y^6+(4*j^2+2*j)*x^7*y^5-x^8*y^4,
-2*j^2*x^4*y^9+(-7*j^2-j)*x^5*y^8+(-12*j^2-2*j)*x^6*y^7+
(-10*j^2-j)*x^7*y^6-3*j^2*x^8*y^5,
-2*j*x^3*y^11+(2*j^2-j)*x^4*y^10+(4*j^2+2*j)*x^5*y^9-6*x^6*y^8+(8*j^2+
4*j)*x^7*y^7+6*j^2*x^8*y^6+(2*j^2-4*j)*x^9*y^5+(-2*j^2-4*j)*x^10*y^4+2*x^11*y^3,
-3*j^2*x^6*y^8-6*j^2*x^7*y^7,
2*x^21*y^30+(12*j^2+3*j)*x^23*y^28-16*x^24*y^27-6*x^25*y^26,
2*j^2*x^4*y^11+(5*j^2-j)*x^5*y^10+(6*j^2-j)*x^6*y^9+(4*j^2-j)*x^7*y^8+
(5*j^2-j)*x^8*y^7+(4*j^2-j)*x^9*y^6+j^2*x^10*y^5, -9*j^2*x^7*y^8,
9*x^21*y^26+15*x^22*y^25+6*x^23*y^24,24*x^21*y^25+21*x^22*y^24,45*x^21*y^24];
end;
  f35:=function(x,y)return [60,28*x+32*y,28*x*y+14*x^2+18*y^2,
21*x*y+7*x^2+11*y^2,8*x*y^2+6*x^2*y+x^3+3*y^3,4*x*y^2+2*x^2*y,-2*x*y^2-
4*x^2*y-3*x^3-3*y^3,15*x*y^2+13*x^2*y+4*x^3+7*y^3,24*x*y^2+18*x^2*y+8*x^3+
10*y^3,2*x*y^3+2*x^2*y^2+x^3*y+y^4,0,-5*x*y^3-6*x^2*y^2-4*x^3*y-x^4-2*y^4,
6*x*y^3+6*x^2*y^2+3*x^3*y+x^4+2*y^4,0,0,7*x^21*y^27+15*x^22*y^26+13*x^23*y^25+
4*x^24*y^24,-3*x^2*y^4-5*x^3*y^3-x^4*y^2,-12*x^2*y^4-24*x^3*y^3-6*x^4*y^2,
8*x*y^5-2*x^2*y^4-18*x^3*y^3-4*x^4*y^2+4*x^5*y+3*x^6+3*y^6,0,
x^2*y^5+x^3*y^4-x^5*y^2-x^6*y,0,-x^2*y^5-5*x^3*y^4-3*x^4*y^3,
6*x*y^6+7*x^2*y^5-3*x^3*y^4-6*x^4*y^3+2*x^6*y+x^7+2*y^7,
0,2*x*y^7+x^2*y^6-7*x^3*y^5-16*x^4*y^4-13*x^5*y^3-4*x^6*y^2+y^8,
-x^3*y^6-2*x^5*y^4,x^4*y^6+x^5*y^5+x^7*y^3,-3*x^4*y^6-6*x^5*y^5-3*x^6*y^4,
-2*x^3*y^7-5*x^4*y^6-5*x^5*y^5-3*x^6*y^4,
-2*x^3*y^9-3*x^4*y^8-4*x^5*y^7-5*x^6*y^6-x^8*y^4,
2*x^4*y^9+8*x^5*y^8+10*x^6*y^7+7*x^7*y^6+x^8*y^5-x^9*y^4,
-3*x^4*y^10-6*x^5*y^9-11*x^6*y^8-16*x^7*y^7-10*x^8*y^6-2*x^9*y^5+3*x^10*y^4
  +2*x^11*y^3+x^12*y^2,4*x^6*y^8+2*x^7*y^7,
-12*x^23*y^28-24*x^24*y^27-6*x^25*y^26,
-x^4*y^11-3*x^5*y^10-5*x^6*y^9-6*x^7*y^8-5*x^8*y^7-3*x^9*y^6-x^10*y^5,
6*x^7*y^8,11*x^21*y^26+21*x^22*y^25+7*x^23*y^24,32*x^21*y^25+
28*x^22*y^24,60*x^21*y^24];end;
  f37:=function(x,y,s)local v;v:=s*GetRoot(-x*y,2);
  return [64,32*x+32*y,32*x*y+16*x^2+16*y^2,22*x*y+10*x^2+
10*y^2,8*x*y^2+8*x^2*y+2*x^3+2*y^3,4*x*y^2+4*x^2*y,-4*x*y^2-4*x^2*y-2*x^3-
2*y^3,16*x*y^2+16*x^2*y+5*x^3+5*y^3,24*x*y^2+24*x^2*y+8*x^3+8*y^3,2*x*y^3+
3*x^2*y^2+2*x^3*y,x^2*y^2,-5*x*y^3-7*x^2*y^2-5*x^3*y-x^4-y^4,5*x*y^3+
8*x^2*y^2+5*x^3*y+x^4+y^4,-v^25,-v^5,
-5*v^45*y^3+16*y*v^47+16*x*v^47-5*x^3*v^45,-2*x^2*y^4-4*x^3*y^3-2*x^4*y^2,
-12*x^2*y^4-16*x^3*y^3-12*x^4*y^2,8*x*y^5-4*x^2*y^4-12*x^3*y^3-4*x^4*y^2
+8*x^5*y+2*x^6+2*y^6,v^9,x^3*y^4+x^4*y^3,0,
-x^2*y^5-3*x^3*y^4-
3*x^4*y^3-x^5*y^2,4*x*y^6+3*x^2*y^5+3*x^5*y^2+4*x^6*y+x^7+y^7,
0,2*v*x^2*y^5+4*v*x^3*y^4+4*v*x^4*y^3+2*v*x^5*y^2-3*x^2*y^6-
7*x^3*y^5-8*x^4*y^4-7*x^5*y^3-3*x^6*y^2, 
2*v*x^3*y^5+2*v*x^5*y^3,-v*x^2*y^7-v*x^4*y^5-v*x^5*y^4-v*x^7*y^2,
-3*x^4*y^6-6*x^5*y^5-3*x^6*y^4,
v*x^3*y^6+v*x^4*y^5+v*x^5*y^4+v*x^6*y^3-3*x^4*y^6-6*x^5*y^5-3*x^6*y^4, 
-2*x^3*y^9-2*x^4*y^8-6*x^5*y^7-8*x^6*y^6-6*x^7*y^5-2*x^8*y^4-2*x^9*y^3,
-2*v*x^4*y^8-6*v*x^5*y^7-8*v*x^6*y^6-6*v*x^7*y^5-2*v*x^8*y^4+2*x^5*y^8
+5*x^6*y^7+5*x^7*y^6+2*x^8*y^5,
2*v*x^3*y^10+6*v*x^4*y^9+12*v*x^5*y^8+14*v*x^6*y^7+14*v*x^7*y^6+
12*v*x^8*y^5+6*v*x^9*y^4+2*v*x^10*y^3+2*x^3*y^11+4*x^4*y^10-2*x^5*y^9-
11*x^6*y^8-14*x^7*y^7-11*x^8*y^6-2*x^9*y^5+4*x^10*y^4+2*x^11*y^3,-4*v*x^6*y^7-
4*v*x^7*y^6,12*v*x^24*y^26+16*v*x^25*y^25+12*v*x^26*y^24,v*x^4*y^10+
4*v*x^5*y^9+7*v*x^6*y^8+8*v*x^7*y^7+7*v*x^8*y^6+4*v*x^9*y^5+v*x^10*y^4-x^6*y^9-
3*x^7*y^8-3*x^8*y^7-x^9*y^6,
8*v^15,-10*y^2*v^45+22*v^47-10*x^2*v^45,-32*y*v^45-32*x*v^45,-64*v^45];end;
  f39:=function(x,y)return [81,45*x+36*y,42*x*y+24*x^2+15*y^2,27*x*y+18*x^2+
9*y^2,8*x*y^2+13*x^2*y+5*x^3+y^3,3*x*y^2+6*x^2*y+3*x^3,-6*x*y^2-3*x^2*y-3*y^3,
18*x*y^2+24*x^2*y+9*x^3+3*y^3,27*x*y^2+36*x^2*y+12*x^3+6*y^3,x*y^3+5*x^2*y^2+
4*x^3*y+x^4,x^2*y^2+x^3*y,-5*x*y^3-8*x^2*y^2-6*x^3*y-2*x^4-y^4,4*x*y^3+
11*x^2*y^2+10*x^3*y+2*x^4,0,0,3*x^25*y^23+18*x^26*y^22+24*x^27*y^21+
9*x^28*y^20,-x^2*y^4-5*x^3*y^3-5*x^4*y^2-x^5*y,-9*x^2*y^4-24*x^3*y^3-
18*x^4*y^2+3*x^6,6*x*y^5-6*x^2*y^4-18*x^3*y^3-3*x^4*y^2+12*x^5*y+6*x^6+3*y^6,
x^5*y^4, -x*y^6-x^2*y^5+2*x^4*y^3+2*x^5*y^2, 0,
-3*x^3*y^4-6*x^4*y^3-3*x^5*y^2,2*x*y^6-
3*x^3*y^4+x^4*y^3+9*x^5*y^2+8*x^6*y+2*x^7+y^7,
0, -4*x^2*y^6-9*x^3*y^5-9*x^4*y^4-3*x^5*y^3+2*x^6*y^2+2*x^7*y+x^8, 0, 0, 
  -3*x^4*y^6-6*x^5*y^5-6*x^6*y^4, -2*x^4*y^6-6*x^5*y^5-6*x^6*y^4-2*x^7*y^3, 
-x^4*y^8-4*x^5*y^7-9*x^6*y^6-8*x^7*y^5-x^8*y^4-x^10*y^2,
 4*x^6*y^7+8*x^7*y^6+6*x^8*y^5+2*x^9*y^4, 
 x^2*y^12+2*x^3*y^11+5*x^4*y^10+4*x^5*y^9
  -6*x^6*y^8-16*x^7*y^7-20*x^8*y^6-12*x^9*y^5-2*x^10*y^4,
 0, -9*x^27*y^24-24*x^28*y^23-18*x^29*y^22+3*x^31*y^20, 
 x^6*y^9-3*x^7*y^8-6*x^8*y^7-7*x^9*y^6-3*x^10*y^5-x^11*y^4,
0,9*x^25*y^22+27*x^26*y^21+18*x^27*y^20,36*x^25*y^21+45*x^26*y^20,
81*x^25*y^20];end;
tbl.irreducibles:=
[f1(x),f1(y),f3(x,y,E(3)),f3(y,x,E(3)),f3(x,y,E(3)^2),f3(y,x,E(3)^2),
f7(x,y),f7(y,x),f9(x,y,E(3)),f9(y,x,E(3)),f9(x,y,E(3)^2),f9(y,x,E(3)^2),
f13(x,y),f13(y,x),f15(x,y),f15(y,x),f17(x,y),f17(y,x),f19(x,y),f19(y,x),
f21(x,y),f21(y,x),f23(x,y,E(3)),f23(y,x,E(3)),f23(x,y,E(3)^2),f23(y,x,E(3)^2),
f27(x,y,E(3)),f27(y,x,E(3)),f27(x,y,E(3)^2),f27(y,x,E(3)^2),
f31(x,y,E(3)),f31(y,x,E(3)),f31(x,y,E(3)^2),f31(y,x,E(3)^2),
f35(x,y),f35(y,x),f37(x,y,-1),f37(x,y,1),f39(x,y),f39(y,x)];
  tbl.centralizers:=List(tbl.classes,x->tbl.order/x);
  tbl.irredinfo:=List(CHEVIE.RawData("CharInfo","G33")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G33")(x,rec())));
  return CHEVIE.compat.MakeCharacterTable(tbl);
end);

CHEVIE.AddData("CharTable","G33",function()local res;
  res:=CHEVIE.RawData("HeckeCharTable","G33")(List([1..4],x->[1,-1]),[]);
  res.identifier:="G33"; res.name:="G33";
  res.powermap:=CHEVIE.RawData("PowerMaps","G33");
  res.galomorphisms:=Group((4,5)(6,7)(10,11)(12,13)(14,15)(16,17)(18,19)(20,21)
     (25,26)(28,29));
  res.text:="origin: HeckeCharTable";
  return res;
end);

CHEVIE.AddData("HeckeRepresentation","G33",function(para,root,i)
  local p,r,rep,f1,f5,f7,f10,f13,f15,f17,f19,f21,f23,f27,f31,f35,f37,f39,dec;
  dec:=function(d,l)local m,v,i,j,k;
    m:=List([1..5],i->List([1..d],y->[1..d]*0));
    for v in l do
      for k in v{[2..Length(v)]} do
	i:=QuoInt(k,d^2);k:=k mod d^2;j:=QuoInt(k,d);k:=k mod d;
	m[i+1][j+1][k+1]:=v[1];
      od;
    od;
    return m;
  end;
  p:=para[1][2];r:=para[1][1];
  f1:=r->List([1..5],x->[[r]]);
  f5:=function(x,y,j)return WGraph2Representation([[[2,3,4,5],[1,3,4,5],
   [1,2,4,5],[1,2,3,5],[1,2,3,4]],[[1,2,x,-y],[2,3,-j*y,j^2*x],[2,4,-y,x],
   [3,4,x,-y],[4,5,x,-y]]],[x,y])*y^0*x^0;
  end;
# For the usual presentation 7th rep. does not have a W-graph. Use AltPres[1]
  f7:=function(y,x)local rep;
    rep:=WGraph2Representation([[[1,5],[1,3,4],[2],[2,5],[3],[4]],
     [[1,2,-y,x],[1,4,-y,x],[2,3,-y,x],[2,5,-y,0],[2,6,-y,0],[3,4,0,-y],
     [4,5,-y,x],[4,6,-y,x]]],[x,y])*y^0*x^0;
    rep[4]:=rep[4]^rep[5];rep[3]:=rep[4]*rep[3]/rep[4];
  return rep;end;
  f10:=function(r,p,a) return List(f5(r,p,a),x->ExteriorPower(x,2)/r);end;
  f13:=function(x,y) return dec(15,[[-1,91,108,129,709,729,788],[-x,388,418,451,
483,635,676,969,986],[-y,190,226,258,290,371,520,629,650,656,659,761,868,897,
898,902,918,997,1104,1106],[-x*y,165,167,195,968],[-x^2,983,1088],[-y^2,886],
[-x^2*y,81,202,382,831,832,981,982,1056,1057],[-x^3,411,651],[-x-y,219,728],[-
x*y-y^2,218,368,1103],[-x*y^2-x^2*y,82,817],[-x*y^2-y^3,366,367,591,592],[-
x^2*y-x^3,201,381,1086,1087],[-x*y-x^2-y^2,211,213],[x,0,32,64,160,204,240,
272,304,321,337,384,386,399,409,410,414,416,433,466,498,546,562,604,671,691,
771,834,845,882,930,946,1011,1028,1044,1059,1076,1094,1124],[y,79,80,176,192,
205,208,224,353,385,417,449,450,482,537,578,594,657,658,675,835,890,896,899,
964,980,1060,1092,1108],[x*y,21,52,75,76,143,180,198,203,210,212,377,378,407,
408,435,436,437,438,737,802,813,826,828,833,1051,1053,1058],[x^2,456,487,681],
[y^2,351,352,576,577,586,588,646],[x^3,441,442,891],[x+y,96,112,144,174,199,
241,273,305,379,380,401,610,642,674,739,803,819,851,883,932,948,1012],[x*y+
x^2,196,383,398,413],[x*y+y^2,77,78,173,182],[x*y^2+x^2*y+x^3,216,
217]])*x^0*y^0;end;
  f15:=function(x,y) return dec(15,[[-x^-1*y^2,1002],[-x,331,388,418,943],[-y,
15,41,55,85,286,302,318,373,505,509,544,565,569,575,580,659,716,821,836,866,
878,1014,1019],[-x^2*y^-1,816],[-x^-1*y^2+y,116],[-x+y,818,958],[x^-1*y^2,
999],[x,16,32,48,64,80,96,112,128,144,208,224,225,226,289,305,321,337,353,358,
369,378,385,392,401,417,448,449,450,466,469,482,485,498,546,559,562,574,578,
594,625,626,642,658,675,691,707,723,726,739,741,755,758,819,835,867,883,892,
899,900,916,932,948,964,980,996,1012,1028,1033,1060,1076,1077],[y,0,57,131,
160,176,192,207,241,257,273,433,514,530,610,674,697,761,771,787,803,851,896,
989,1044,1092,1108,1124],[x^2*y^-1,756,891],[x^-1*y^2-y,27,912,974,1003],[x-y,
238,928,1018]])*x^0*y^0;end;
  f17:=function(x,y) return dec(20,[[-x^-2*y^3,880],[-x^-1*y^2,120,122,125,
1140,1142,1145,1580,1582,1585],[-x,45,140,142,145,151,316,396,402,466,481,569,
614,645,649,667,746,751,786,796,911,1049,1053,1107,1116,1196,1231,1232,1253,
1276,1291,1336,1352,1506,1516,1560,1565,1569,1573,1643,1706,1787,1884,1973],[-
y,271,382,385,460,462,465,551,716,825,831,833,1042,1087,1097,1146,1169,1311,
1322,1325,1387,1444,1586,1630,1634,1660,1690,1763,1786,1877,1967,1977],[-
x^2*y^-1,264,350,364,661,750,754,761,853,870,930,964,984,1208,1550],[-x^3*y^-
2,904],[-x-2*y,785,1505],[-x^-2*y^3-2*x^-1*y^2+2*x+x^2*y^-1,1120],[-x^-1*y^2-
y,822,1300],[-x-y,640,642,740,742,745,767,781,789,791,1106,1186,1308,1384,
1464,1501,1509,1511,1562],[-x-x^2*y^-1,1118,1471,1571],[-x^-1*y^2-x-3*y,780,
782,1500,1502],[-x^-2*y^3-x^-1*y^2-y,820],[-x^-1*y^2-x-y,1990],[-x-y-x^2*y^-1,
1304,1984],[-x^-3*y^4-x^-2*y^3+3*x+2*y+x^2*y^-1,1180],[-x^-1*y^2+x,1780,1782],
[-y+x^2*y^-1,1128],[-x^-1*y^2+x-y,1105,1785],[x^-1*y^2,384,388,391,1003,1062,
1324,1328,1331,1360],[x,21,126,147,189,251,252,273,290,294,300,302,305,315,
357,362,365,368,371,378,399,463,484,568,627,652,665,671,673,735,747,757,765,
778,795,799,821,937,962,965,968,971,982,985,988,991,998,1047,1048,1052,1058,
1090,1094,1111,1115,1193,1199,1242,1305,1313,1339,1345,1349,1490,1494,1515,
1519,1557,1567,1568,1572,1578,1603,1646,1762,1765,1768,1771,1789,1791,1804,
1851,1852,1881,1900,1902,1905,1915,1936,1953,1978,1993,1999],[y,0,24,63,84,
102,123,168,188,210,231,336,351,421,440,505,526,589,690,827,931,947,1020,1022,
1025,1086,1091,1136,1143,1168,1381,1385,1391,1393,1410,1424,1441,1473,1523,
1583,1640,1642,1645,1725,1747,1831,1971,1997],[x^2*y^-1,913,1553,1907,1920,
1922,1925,1931],[x^3*y^-2,804],[x^-2*y^3-y,380,1320],[x^-1*y^2+y,1080,1082,
1085,1123,1380,1382],[x+y,105,360,442,547,660,662,694,715,760,762,771,787,824,
884,960,980,1010,1031,1073,1117,1157,1178,1197,1240,1340,1342,1368,1389,1404,
1431,1452,1507,1536,1599,1663,1726,1760,1810,1894,1957],[x+x^2*y^-1,1109,1122,
1124,1125,1130,1131,1188,1244,1248,1411,1481,1492,1980,1982,1985],[x+y-x^3*y^-
2,1544],[x^-1*y^2+x+y,1184],[x^-1*y^2+x+x^2*y^-1,1991],[x+y+2*x^2*y^-1+x^3*y^-
2,1551],[x^-1*y^2+2*x+y+x^2*y^-1,1191],[2*x+y,1100,1102],[2*x+x^2*y^-1,1185],
[2*x+y+x^2*y^-1,1113,1182]])*x^0*y^0;end;
  f19:=function(x,y) return dec(24,[[-1,77,154,231,403,521,604,609,1676,1754,
1962,2249],[-x,579,628,1153,1232,1303,1370,1440,1441,1806,1858,1932,2524,2773,
2855],[-y,451,494,794,1574,1997,2002,2107,2201,2631],[-x*y,271,316,542,922,
972,1067,1118,2232,2240,2244,2276],[-x*y^2,1713],[-x*y^3,1688,1710],[-x^2,
2544,2846],[-y^2,1600,1697,1722],[-x^2*y,1044,1706],[-x^3,1106,1137,1144,1512,
1513,2837],[-y^3,1696],[-x^4,1116,1129,2835],[-x*y^3-2*x^2*y^2-2*x^3*y,1131],
[-x*y^3-2*x^2*y^2-2*x^3*y-x^4,1128],[-x-y,2592],[-x*y-x^2,1700],[-x*y^2-x^2*y,
1725],[-x*y^3-x^2*y^2,2280],[-x^2*y-x^3,1584,1585],[-x^2*y^2-x^3*y+x^4,1134],
[-x*y^3-x^2*y^2+x^3*y+x^4,1704,1705],[-x^2+y^2,1721],[1,109,179,197,298,398,
772,777,830,860,880,1442,2130,2230,2250,2251],[x,0,25,50,168,169,171,176,195,
200,294,300,400,447,450,500,525,550,575,603,701,751,768,769,776,901,951,1001,
1026,1051,1126,1151,1250,1252,1277,1296,1297,1299,1302,1304,1377,1402,1403,
1447,1452,1477,1505,1527,1538,1627,1702,1727,1752,1753,1826,1828,1903,1994,
2003,2053,2078,2103,2106,2121,2128,2155,2241,2253,2303,2354,2448,2451,2454,
2479,2549,2554,2579,2600,2604,2654,2677,2692,2697,2704,2729,2754,2775,2779,
2804,2829],[y,350,425,449,475,648,674,726,744,747,750,1101,1176,1202,1327,
1347,1427,1728,1778,1875,1896,1899,1902,1973,2024,2105,2304,2329,2379,2409,
2429,2472,2473,2475,2480,2504,2878],[x*y^-1,1554],[x*y,123,246,264,265,267,
272,369,437,442,792,793,1005,1010,1012,1048,1593,1653,2093,2098,2115,2118,
2169,2352,2353,2870],[x*y^2,1587,1590,1689],[x*y^3,1686],[x^2,441,566,1275,
1280,1368,1369,1466,1514,1539,1542,1995,1998,2000,2004,2042,2097,2568,2569,
2571,2576,2645,2688,2689,2696,2717,2764,2769,2808,2811],[y^2,1694,1698],
[x^2*y^-1,1545],[x^2*y,435,438,1014,1114,1591,1682,2091,2094,2737],[x^2*y^2,
1680,1681],[x^3,557,1113,1120,1130,2282,2285,2290,2643,2715,2785,2792],[y^3,
1720],[x^4,555,1105,1140,2288,2292],[x^2-y^2,1718],[x+y,125,250,275,325,375,
651,676,801,926,976,1076,1177,1352,1577,1602,1677,1878,1978,2028,2178,2203,
2278,2404,2629,2879],[x*y+x^2,1586,1724,2691,2740,2745,2765],[x*y^2+x^2*y,
1701],[x^2*y+x^3,2763,2784,2787],[x^2*y^2+x^3*y,1107],[x^2*y^2+x^3*y-x^4,
1110],[x^2*y^2+x^3*y+x^4,1104],[x^3*y+x^4+y^4,1707],[x*y^3+x^3*y+x^4+y^4,
1712],[x^3*y+2*x^4,2283,2286]])*x^0*y^0;end;
  f21:=function(x,y) return dec(30,[[-3*x*y^3-x^2*y^2+2*x^3*y-y^4,4387],[-
3*x*y^3+x^3*y-2*y^4,4386],[-3*x*y^2+x^2*y+2*x^3-y^3,4308],[-2*x^3*y^2-3*x^4*y-
x^5,768],[-2*x*y^4-2*x^2*y^3,4356],[-2*x*y-x^2,3394],[-2*x*y-x^2-y^2,3349],[-
2*x*y^3-x^2*y^2-y^4,4392],[-2*x*y^2-x^2*y+y^3,3933],[-2*x*y^5-x^2*y^4+
2*x^3*y^3+x^4*y^2,4326],[-2*x^2*y+y^3,4400],[-2*x*y^2+x^2*y+y^3,3950],[-
2*x^2*y^4+x^4*y^2+y^6,4429],[-1,716,901,1150,1612,1767,1804,2485,2547,2753,
3401,3700,3824,4160],[-x^-2,3238],[-x^-1*y,1366],[-x,254,378,571,878,883,890,
964,1051,1064,1252,1304,1364,1790,1861,1874,1951,2075,2253,2347,2414,2744,
3104,3203,3275,3590,4174,4190,4484],[-y,69,151,216,574,578,583,590,613,671,
1299,1353,1426,1502,1519,1992,2053,2117,2706,2733,3094,3119,3252,4474],[-x*y^-
1,1191,1311],[-x*y,120,570,588,631,996,1296,1302,1413,1703,2284,2295,2495,
2510,2742,2827,3090,3185,3846,4002,4089,4125,4470],[-x*y^2,1683,2280,2286,
2292,2581,2588,2593,3390,3396,3402,3483,3509,3934,4263,4265,4268,4273],[-
x*y^3,821,1756,4351],[-x*y^4,4329],[-x^2,683,888,1057,1246,1297,1357,1488,
1867,2076,2082,2300,2737,3096,3097,3102,3181,3194,3410,4094,4170,4188,4476,
4477,4482],[-y^2,488,493,500,1770,1776,1782,2431,4276,4298,4303,4376],[-
x^2*y^-1,4101,4171,4311],[-x^2*y,663,742,766,835,1234,1392,1694,3033,3365,
3473,4086,4092,4264],[-x^2*y^2,1230,1236,1651,1692,3453],[-x^2*y^3,1650,1668,
1769],[-x^2*y^4,3513],[-x^3,674,1250,2298,4087],[-y^3,4373],[-x^3*y,672,736,
755,770,1687,3441,3451,3464,4341],[-x^3*y^2,724,833,1742,1754,3526],[-x^3*y^3,
720,726],[-x^4,667],[-y^4,4369],[-x^4*y,740,2648,2653],[-x^4*y^2,811,824,3515,
3530],[-x^5,2660],[-x^6,2658],[-x^4*y^2-3*x^5*y-2*x^6,1638],[-x*y^2-2*x^2*y,
3397],[-x^2*y^4-2*x^3*y^3,1758],[-x^3*y-2*x^4,1248],[-x^4*y^2-2*x^5*y,738],[-
x^5*y^2-2*x^6*y,1717],[-x^2*y^4-2*x^3*y^3-3*x^4*y^2-3*x^5*y-x^6,1714],[-
x^2*y^5-2*x^3*y^4-2*x^4*y^3-3*x^5*y^2-x^6*y,1710],[-x^2*y^4-2*x^3*y^3-
2*x^4*y^2-x^5*y,1729],[-x^2*y^5-2*x^3*y^4-2*x^4*y^3-x^5*y^2,1716,1722],[-
x*y^2-2*x^2*y-x^3,3192],[-x^2*y^2-2*x^3*y-x^4,4330],[-x^2*y^3-2*x^3*y^2-x^4*y,
1755,3462,4427],[-x^2*y^4-2*x^3*y^3-x^4*y^2,825],[-x^2*y^5-2*x^3*y^4-x^4*y^3,
3522],[-x^3*y^2-2*x^4*y-x^5,3457],[-x^3*y^4-2*x^4*y^3-x^5*y^2,822],[-x^4*y^3-
2*x^5*y^2-x^6*y,817],[-x*y^5-2*x^2*y^4+x^3*y^3,4327],[-x*y^4-2*x^2*y^3+
x^3*y^2+x^4*y,4357],[-x^-1*y^2-y,1789],[-x-y,1764,1774,2749,2764,3353],[-x*y-
x^2,481,2767,2970,2976,3168,3199,3282,3344,3940],[-x*y-y^2,484,3333,4319],[-
x*y^2-x^2*y,480,1673,1699,2133,2508,3342,4289],[-x*y^2-y^3,4389],[-x*y^3-
x^2*y^2,4278,4352,4359],[-x*y^4-x^2*y^3,4362],[-x^2*y-x^3,679,1642,2134,3337],
[-x^2*y^2-x^3*y,754,2130,3469],[-x^2*y^3-x^3*y^2,750],[-x^3*y-x^4,1636,1721,
3454],[-x^3*y^2-x^4*y,1624,1733,3423,3450,3456,4448,4453,4460],[-x^3*y^3-
x^4*y^2,829,1620,1626,3514],[-x^3*y^4-x^4*y^3,3510,3516],[-x^4*y-x^5,1640],[-
x^4*y^2-x^5*y,4458],[-x^4*y^3-x^5*y^2,816],[-x*y^2-x^2*y-x^3,4384],[-x*y^2-
x^3-y^3,4381],[-x*y^3-x^2*y^2-x^3*y,753],[-x^2*y^4-x^3*y^3-x^5*y,1711],[-
x*y^3-x^3*y-x^4-y^4,4380],[-x*y-x^2+y^2,4292],[-x^3*y^3-x^4*y^2+x^5*y,1730],[-
x*y^2-x^2*y+2*x^3,3018],[-x*y^3-x^2*y^2+2*x^3*y,3498],[-x*y^6-x^2*y^5+
4*x^3*y^4+2*x^4*y^3,4428],[-x^-1*y^2+x,4406],[-x^-1*y^2+y,3956],[-x^-1*y^3+
y^2,3953],[-x+y,1291,1351,1775,2731,3023,3092,3099,3406,4472,4479],[-x*y+x^2,
2281,3005,3013,3020,3029,3391,3404,4085],[-x*y+y^2,3003,3503],[-x*y^2+x^2*y,
1685,3485,3493],[-x*y^2+y^3,3935,3938,3943,3959],[-x*y^3+y^4,4336],[-x*y^4+
x^3*y^2,4350],[-x*y^5+x^2*y^4,4320,4413,4415,4439],[-x*y^5+x^3*y^3,4332],[-
x^2+y^2,3019,3331,4304],[-x^2*y+x^3,665,1231],[-x^2*y+y^3,3499,4388],[-
x^2*y^2+y^4,4436],[-x^2*y^3+x^4*y,4442,4449],[-x^2*y^3+y^5,4433],[-x^3*y^2+
x^4*y,721,2645],[-x^3*y^2+x^5,1621],[-x^-1*y^2+x-y,4306],[-x^-1*y^3+x*y-y^2,
4403],[-x*y+x^2-y^2,4293,4295],[-x*y^4+x^2*y^3-x^3*y^2-x^4*y,4322,4334],[-
x*y^2+x^2*y+x^3,4280],[-x*y^5+x^3*y^3+x^4*y^2,4418,4423],[-x^2*y^3+x^3*y^2+
x^4*y,1745],[-x^-1*y^4+x*y^2+x^2*y-2*y^3,4399],[-x*y^4+x^2*y^3+x^4*y+x^5,
4321],[-x*y^5+x^2*y^4+x^3*y^3+2*x^4*y^2+x^5*y,4430],[-x*y^3+x^2*y^2+2*x^3*y+
x^4,4364],[-x*y^2+2*x^2*y,3500],[-x^-1*y^4+2*x*y^2-x^2*y,3949],[-x*y^3+
2*x^2*y^2-y^4,3937],[1,4,51,171,1083,1300,1306,2746,2914,3788,3973,4067],[x^-
2,3354],[x^-1,596,684,777,1276,2741,2752,2801,2872],[y^-1,3292],[x^-1*y,506,
593,1459,1786,4316],[x^-1*y^2,503],[x,187,272,410,884,1055,1070,1293,1310,
1370,1431,1501,1772,1784,1865,1880,2071,2078,2083,2166,2198,2320,2750,2880,
3078,3098,3103,3110,3274,3413,4090,4096,4172,4189,4478,4483,4490,4499],[y,93,
155,310,341,428,465,496,527,552,572,579,584,589,868,874,899,1022,1052,1117,
1241,1294,1298,1303,1334,1354,1365,1427,1504,1520,1644,1675,1702,1706,1773,
1799,1835,1862,1905,2028,2079,2141,2240,2296,2389,2451,2513,2606,2668,2699,
2734,2762,2948,2979,3010,3134,3165,3289,3329,3475,3491,3506,3537,3600,3631,
3662,3724,3755,3879,3941,4251,4282,4286,4344,4375,4437,4468],[x*y^-1,591],
[x*y,582,803,870,930,1208,1500,1518,1583,1696,1738,1920,2283,2491,2504,2572,
2634,3393,3419,3461,3903,4027,4084,4088,4093,4218],[x*y^2,731,1416,1422,1684,
2585,4080,4261,4274],[x*y^3,1669,1680,1686,3521,4353,4355],[x*y^5,4419],[x^2,
676,876,877,882,1068,1253,1308,1368,1777,1878,2294,3008,3108,3200,3277,4083,
4100,4488],[y^2,494,761,1290,1350,1356,1362,1419,1539,2435,2730,2736,4283,
4299],[x^2*y,664,773,1233,1700,3466,3488],[x^2*y^2,660,666,4354],[x^2*y^4,
1746,1752],[x^3,680,1244,2287,4098],[y^3,4279,4366],[x^3*y,743,751,764,1242,
3455,3470,3557],[x^3*y^2,723,826,1760,2644,3533,4431],[x^3*y^3,1739,2640],
[x^4,1237,1761],[x^4*y,734],[x^4*y^2,732,815,830,1719,3511,3524],[x^5,2654],
[x^5*y,727,2646,2652],[x^6,2647],[x*y^3-3*x^2*y^2+x^3*y+y^4,3948],[x*y-2*x^2,
3014],[x*y^2-2*x^2*y,3494],[x^2*y^4-2*x^4*y^2,1715],[x*y^3-2*x^2*y^2-3*x^3*y-
x^4,4370],[x*y^4-2*x^2*y^3-2*x^3*y^2-x^4*y,4323],[x*y^3-2*x^2*y^2-x^3*y,3480],
[x*y^4-2*x^3*y^2-x^4*y,4368],[1-x^-1*y,3011],[x^-1*y^3-y^2,3946],[x-y,872,879,
1295,1355,1771,2735,3016],[x*y-x^2,2285,3001,3002,3009,3395,4081],[x*y-y^2,
3496],[x*y^2-x^2*y,1681,3000,3481,3482,3489],[x*y^2-x^3,3006,3012],[x*y^2-y^3,
3939],[x*y^3-x^3*y,3492,4260,4358,4363],[x*y^4-x^2*y^3,4325,4340,4349],[x*y^4-
x^3*y^2,4328,4333],[x*y^4-y^5,4426],[x*y^6-x^2*y^5,4410],[x^2-y^2,3335,3409],
[x^2*y-x^3,661,1235],[x^2*y-y^3,4346,4382],[x^2*y^2-y^4,3942,4343],[x^2*y^3-
x^4*y,4469],[x^3*y^2-x^4*y,725,2641],[x^3*y^2-x^5,1625],[x*y^3-x^2*y^2-
2*x^3*y,3486],[x^2*y^3-x^3*y^2-2*x^4*y-x^5,1741],[x*y^3-x^2*y^2-y^4,3930],
[x*y^6-x^3*y^4-x^4*y^3,4422],[x*y^5-x^2*y^4-x^4*y^2-x^5*y,4411,4424],[x^-
1*y^3-x*y-x^2+2*y^2,4309],[x^-1*y^3-x*y+y^2,4396],[x*y-x^2+y^2,1788],[x*y^2-
x^2*y+y^3,4383,4385],[x*y^2-x^2*y+x^3-y^3,3931],[x*y^5-x^2*y^4+x^3*y^3+
x^4*y^2,4412],[1+x^-1*y,3352],[1+x*y^-1,3202],[x^-1*y^2+y,4313],[x+y,0,186,
248,279,372,403,651,682,775,806,931,962,993,1210,1396,1489,1551,1613,1737,
1924,1955,2172,2203,2265,2327,2358,2420,2575,2637,2886,2917,3041,3196,3258,
3346,3382,3444,3568,3599,3848,3910,4003,4034,4127,4220],[x+x^2*y^-1,501],[x*y+
x^2,1734,3184,3350],[x*y+y^2,482,489,576,577,1672,3162,3334],[x*y^2+x^2*y,
2145,2497,4262,4269],[x*y^2+y^3,486,487,3330,3336,4393,4409],[x*y^3+x^2*y^2,
2586,2592,4379],[x*y^4+x^2*y^3,1759],[x^2+x^3*y^-1,3288],[x^2*y+x^3,1249,
1751],[x^2*y^2+x^3*y,769,1732],[x^2*y^3+x^3*y^2,4444],[x^2*y^4+x^3*y^3,1713],
[x^3*y+x^4,1643],[x^3*y^2+x^4*y,739,756,1623,3421,4454],[x^3*y^3+x^4*y^2,814,
3529,4440],[x^3*y^4+x^4*y^3,810,3528],[x^4*y+x^5,1634],[x^4*y^2+x^5*y,1632,
4446,4447,4452],[x^5*y+x^6,1627],[x*y^5+x^2*y^4-3*x^3*y^3+x^5*y,4338],[x*y^2+
x^2*y-2*x^3,3007],[x*y^3+x^2*y^2-2*x^3*y,3487],[x*y^2+x^2*y-x^3,3408],
[x^3*y^3+x^4*y^2-x^5*y,1724],[x*y^3+x^2*y^2+x^3*y,4272],[x^2*y^4+x^3*y^3+
x^4*y^2,813,1740],[x^3*y^3+x^4*y^2+x^5*y,1747],[x*y+x^2+y^2+x^3*y^-1,4291],
[x*y^2+x^2*y+x^3+y^3,4290],[x*y+2*x^2,2748],[x^2*y^2+2*x^3*y,1698],[x^3*y+
2*x^4,678],[x*y^6+2*x^2*y^5-2*x^3*y^4-2*x^4*y^3-x^5*y^2,4417],[x*y+2*x^2-y^2,
4310],[x*y^3+2*x^2*y^2+x^3*y,765],[x^2*y^3+2*x^3*y^2+x^4*y,762],[x^2*y^4+
2*x^3*y^3+x^4*y^2,4425],[x^3*y^2+2*x^4*y+x^5,757,1639],[x^3*y^3+2*x^4*y^2+
x^5*y,1725],[x*y^4+2*x^2*y^3+2*x^3*y^2+x^4*y,1726],[x^2*y^3+2*x^3*y^2+2*x^4*y+
x^5,1744],[x^3*y^4+2*x^4*y^3+2*x^5*y^2+2*x^6*y,1728],[x*y^3+3*x^2*y^2+x^3*y,
4267],[x^3*y^3+3*x^4*y^2+x^5*y,1712],[x*y^2+3*x^2*y+2*x^3,3348],[2*x^2*y^2-
2*y^4,3936],[2*x^2*y-y^3,4394],[2*x*y^2-x^2*y-y^3,3932,3944],[2*x^2*y^3-x^4*y-
y^5,4339],[2*x*y+x^2,4294],[2*x*y^2+y^3,4302],[2*x^3*y^2+x^4*y,1743],[2*x*y^6+
x^2*y^5-2*x^3*y^4-2*x^4*y^3,4416],[2*x*y^3+2*x^2*y^2+x^3*y,4266],[2*x^2*y+
3*x^3+x^4*y^-1,3198],[2*x^3*y^2+3*x^4*y+x^5,3468],[2*x^4*y^3+3*x^5*y^2+x^6*y,
828],[3*x*y^3-2*x^3*y+y^4,4398],[3*x*y^2+x^2*y-x^3+y^3,4297],[3*x*y^2+2*y^3,
4296]])*x^0*y^0;end;
  f23:=function(x,y,j) return dec(30,[[-2*x*y^2-j^2*x^2*y+(-j^2+j)*x^3-y^3,
1074],[-1,710,930,1481,1668,1761,1983,2014,2075,2264,2310,2480,2757,2822,3222,
3844,4290],[-y,14,49,153,276,340,525,556,742,805,867,1330,1516,1703,2543,3006,
3039,3343,4090,4151,4214,4275,4337,4369,4381,4469],[-x*y,1981,2095,2101,2306,
2659],[-x*y^2,1891,1975,2191,2215],[-y^2,1299,3559],[-x^2*y,963],[-x*y^2-
2*x^2*y-x^3,967],[-x^3*y^2-2*x^4*y-x^5,2782,2784],[-1-x^-1*y,994],[-x*y-x^2,
102,1027,3084],[-x*y^2-x^2*y,2805,2874],[-x^2*y-x^3,968],[-x^3*y-x^4,2842,
2844],[-x*y-j*y^2,2870],[-x*y^2-j*x^2*y,1007],[-x*y-j^2*x^2-y^2,1284],[-x*y^2-
j^2*x^2*y-y^3,1134],[-x*y^2+j*y^3,1951],[x^-1,992],[x,62,95,124,189,217,248,
311,403,420,467,498,571,651,684,776,838,1024,1055,1086,1148,1214,1272,1365,
1400,1582,1616,1737,1862,2110,2141,2172,2203,2296,2358,2514,2637,2668,2699,
2700,2793,2855,2890,2917,2948,2981,3111,3134,3196,3258,3656,3662,3693,3755,
3786,3879,3916,3948,4003,4040,4072,4134,4195,4498],[y,1367,1427,1584,1644,
1831,2389,2575,2606,2900,3020,3140,3200,3320,3413],[x*y^-1,1183,3298],[x*y,
623,901,1249,1465,1558,1817,1896,1927,1959,2235,2422,2764,3077,3511,3623,
3728],[x^2,2006,2611],[y^2,1277,2089,2149,2365,2723],[x^2*y,1916,2216,2431,
2449],[y^3,1127,1969,2209],[x+y,0,31,155,279,341,372,527,558,713,744,806,837,
931,993,997,998,1303,1334,1489,1520,1551,1675,1706,1799,1800,1986,2017,2018,
2048,2079,2082,2114,2130,2234,2300,2420,2513,2824,3010,3041,3165,3227,3351,
3382,3444,3537,3568,3817,3847,3848,3972,4096,4158,4220,4282,4313,4344,4375,
4406,4499],[x*y+x^2,658,964,1962,2115,2147,2302,2364,2457,3118],[x*y+y^2,657,
2363,2458,3762,4259],[x*y^2+y^3,1868,3349,3667],[x^2+x^3*y^-1,3852],[x^2*y+
x^3,132,2812],[x^2*y^2+x^3*y,2835],[x^2*y+2*x^3+x^4*y^-1,3732],[x^2*y^2+
2*x^3*y+x^4,72,3672],[x^2*y^3+2*x^3*y^2+x^4*y,2775],[x*y^4+2*x^2*y^3+(-j^2-
2*j)*x^3*y^2-j*x^4*y-j^2*y^5,1879],[x*y^3+(-j^2-2*j)*x^2*y^2-2*j*x^3*y-j*x^4-
j^2*y^4,1939],[x*y+(-2*j^2-j)*x^2,2096],[x*y^2-j*x^2*y-x^3+y^3,1164],[x^2*y+
j^2*x^3,2963],[x^2*y+j*x^3,1014],[2*x*y+x^2+y^2,1928,3727],[-2*j*x*y-j*x^2-
j*y^2,1041],[-2*j*x*y^2-j*x^2*y-j*y^3,147,981,1948,3749],[-2*j*x*y^3-
j*x^2*y^2-j*y^4,87,1888,2839,3689],[-2*j*x*y^4-j*x^2*y^3-j*y^5,2779],[(-2*j^2-
j)*x^2*y^2+j^2*x^3*y+j^2*x^4,2843],[(-2*j^2-j)*x^2*y^3+2*j^2*x^3*y^2+
2*j^2*x^4*y,2783],[-j,3179,3290,3470],[-j*y,389,2753,2990,3050,3260,3385,3446,
3503,3560,3987],[-j*x^2,1104,1194,1727],[-j*y^2,2665,2689,3110],[-j*x^2*y,
1314,1547],[-j*x^2*y+y^3,1067],[-j*x*y^4-3*j*x^2*y^3+j^2*x^3*y^2+j*x^4*y-
j^2*x^5+y^5,977],[-j*x*y^2-2*j*x^2*y-j*x^3,148,1048,1947],[-j*x*y^3-
2*j*x^2*y^2-j*x^3*y,88,988,1887],[-j*x^2*y^2-2*j*x^3*y-j*x^4,89,3687],[-
j*x*y^3+(j^2-2*j)*x^2*y^2+(2*j^2+j)*x^3*y+j*x^4+y^4-j^2*x^5*y^-1,1037],[-j*x-
j*y,1161,3175,3236],[-j*x*y-j*x^2,268,1168,2067],[-j*x*y-j*y^2,179,267,2068,
3777,3869],[-j*x*y^2-j*y^3,2959],[-j*x^2*y-j*x^3,149,3747],[-j*x^2*y^2-
j*x^3*y,2789],[-j*x^2*y^3-j*x^3*y^2,2785],[-j*x*y^2-j*x^2*y-j*x^3,2059],[(j^2-
j)*x*y^2-j^2*x^2*y+j*x^3+j^2*y^3,1976],[-j^2,1777,3170,3380],[-j^2*y,2269,
2311,2438,2485,2546,3233,3443,4237],[-j^2*x*y,1734],[-j^2*x*y^2,1554],[-
j^2*x^2,2005],[-j^2*y^2,2161],[-j^2*x^2*y,1915,2933],[-j^2*y^3,2029],[-
j^2*x*y-j*x^2-j^2*y^2,1794],[-j^2*x*y-j^2*x^2,3592],[-j^2*x*y^2-j^2*x^2*y-
j*x^3,2036],[-j^2*x*y^3-j^2*x^2*y^2+(j^2-j)*x^3*y+j^2*x^4,1946],[-j^2*x*y^4-
j^2*x^2*y^3+(2*j^2-j)*x^3*y^2+j^2*x^4*y+j*x^5,1886],[-j^2*x*y^2-j^2*x^2*y-
j^2*y^3,2065],[j^2*x,882,2516,3472,3504,4422],[j^2*x*y,1801,1999,2119,2239,
2305,2425,2930,3083,3585],[j^2*x*y^2,1909,2011],[j^2*y^2,1764,1787],[j^2*x^3,
2066],[j^2*x*y+x^2,2810],[j^2*x*y^2+(-j^2-2*j)*x^2*y+j*y^3,2873],[j^2*x*y^2+
j^2*x^2*y-x^3-j^2*x^4*y^-1,1157],[j^2*x*y+j*x^2+j^2*y^2,2186],[j^2*x*y^2+
j*x^2*y+j^2*y^3,2035],[j^2*x*y^3+j*x^4+j*x^5*y^-1,1921],[j^2*x*y^4+j*x^4*y+
j*x^5,1861],[j*x,947,1487,1614,1674,1704,2061,3590,3831],[j*x*y,917,1097,1139,
1187,1217,1247,1337,1404,1464,1524,1757,2636,2903,3023,3203,3350,3533],
[j*x*y^2,1307,2455,2456,3113,3353],[j*x^4*y^-1,2041],[j*x*y^2+x^2*y,2813],
[j*x*y+x^2+j*y^2,2695],[j*x*y^3-2*j^2*x^2*y^2+j^2*x^4-j^2*y^4,2780],[j*x*y-
j^2*y^2,2993,3053,3263],[j*x*y-j^2*x^2-j^2*y^2,2960],[j*x*y^2-j^2*x^2*y-
j^2*y^3,2840],[j*x*y+j*x^2,1941,2039,2819,3741,3838],[j*x*y+j*y^2,2968],
[j*x*y^2+j*x^2*y,1049,1881,2815,2876,3681],[j*x*y^3+j*x^2*y^2,989],[j*x^2*y+
j*x^3,1949,3748],[j*x^3*y^2+j*x^4*y,2786],[j*x^2*y^2+j*x^3*y+j*x^4,1945],
[j*x^2*y^3+(2*j^2+j)*x^3*y^2-x^4*y+j*x^5,1885],[j*x^2*y^2+(j^2+2*j)*x^3*y-
j^2*x^4,1044],[j*x^2*y^3+(3*j^2+5*j)*x^3*y^2+j*x^4*y+(-2*j^2-j)*x^5,984],
[(2*j^2+j)*x*y-y^2,2071,2131,2366],[2*j*x*y^2+j*x^2*y+j*y^3,2848],[2*j*x*y^3+
j*x^2*y^2+j*y^4,2788]])*x^0*y^0;end;
  f27:=function(x,y,j) return dec(40,[[-3*x*y^2-3*x^2*y-x^3-y^3,3184],[-
3*x*y^4+(2*j^2+3*j)*x^2*y^3+j*x^3*y^2-y^5,3179],[-3*x*y^4+(3*j^2+4*j)*x^2*y^3+
(j^2+5*j)*x^3*y^2+3*j*x^4*y+j*x^5-y^5,3167],[-2*x*y^2-x^2*y,3723],[-2*x*y^2-
y^3,2761],[-2*x*y-x^2-y^2,3018,3144,4380,4386],[-2*x*y^2-x^2*y-y^3,3729,7827],
[-2*x*y^3-x^2*y^2-y^4,3139,7817,7972],[-2*x*y^3+j^2*x^2*y^2-j*x^3*y,7931],[-
2*x*y^4+j^2*x^2*y^3-j*x^3*y^2,7971],[-2*x*y^2+(j^2+2*j)*x^2*y+j*x^3-y^3,5527],
[-2*x*y^3+(j^2+2*j)*x^2*y^2+j*x^3*y-y^4,3172,7767],[-2*x*y^3+(j^2+
2*j)*x^2*y^2+2*j*x^3*y+j*x^4-y^4,3127],[-1,44,86,412,1031,1235,2302,2425,2752,
3287,3972,4639,5455,5492,5830,5852,6075,6614,6694,7187],[-x^-1,1981],[-y^-1,
2378],[-x^-1*y^4,3141],[-x^-1*y^5,3181],[-x,1047,1896,1924,2056,3240,3243,
3886,4008,4053,4055,4095,4178,4213,4673,4840,4842,4966,5207,5335,5571,5695,
5932,5988,7332,7711,7738,7864],[-y,80,219,300,457,460,549,587,628,1810,1961,
1962,2368,2648,3203,3386,3451,3607,4221,4294,4381,4929,5245,5485,5499,5734,
5747,5813,5822,6442,6566,6685,6691,6726,6935,7217,7422,7451,7588],[-x*y,640,
1598,2127,2332,2990,3112,3197,3640,3641,3642,3880,3881,3882,4045,4051,4088,
4091,4204,4216,4220,4226,4328,4330,4469,4667,4750,5300,5325,5331,5686,5804,
5939,5977,6147,6178,6232,6255,6927,7571,7693,7705,7709],[-x*y^2,728,980,986,
6048,6215,6222,6248,6920,7611,7616,7685,7728],[-x*y^3,6211,7925,7936],[-x^2,
4047,4207,4326,5327,5687,5811,5816,7016],[-y^2,732,972,2528,3032,4285,4543,
6069,6560,6720,6721,6722,7443,7832],[-x^2*y,1447,2443,6016],[-x^2*y^2,960,963,
1366,4566,6042,7766],[-x^2*y^3,1360,1362],[-y^3,7128,7815,7822,7991],[-
x^3*y^2,6281],[-y^4,1380],[-x*y^2-2*y^3,1328],[-x*y^2-2*x^2*y-x^3,4289,4369],
[-x*y^3-2*x^2*y^2-x^3*y,3020,3026],[-x*y^4-2*x^2*y^3-x^3*y^2,7966],[-x^2*y^3-
2*x^3*y^2-x^4*y,7929],[-x*y^3-2*x^2*y^2+j^2*x^3*y,6040],[-x-y,2772,2824,3034,
3118,3249,5544,5812],[-x*y-x^2,2984,3098,3198,4578,5979],[-x*y-y^2,1334,1347,
2764,2770,2812,3150,5817,5819,7784],[-x*y^2-x^2*y,1326,4361,4362,5643,5649,
5680,6046,6096,6246,6247,7699,7814],[-x*y^2-y^3,2819,3132,3769,7932,7934],[-
x*y^3-x^2*y^2,969,1320,1322,2979,3006,6240,7805,7819,7926],[-x*y^3-y^4,2801,
7974],[-x^2*y^2-x^3*y,1487,4580,4586,6080,7946],[-x*y-x^2-y^2,4300,4306,5805],
[-x*y^2-x^2*y-y^3,2682],[-x*y^3-x^2*y^2-j^2*x^3*y,4443],[-x*y^2-x^2*y+j*x^3,
5767,7847],[-x*y^2+x^2*y+x^3-y^3,3190],[-x*y^4-2*j*x^2*y^3-4*j*x^3*y^2-
3*j*x^4*y-j*x^5-y^5,3176],[-x*y-j*x^2,888],[-x*y^2-j*x^2*y,7648],[-x*y^4-
j*x^2*y^3,7801],[-x^2*y^3-j*x^3*y^2,6201],[-x*y^3-j*x^2*y^2-2*j*x^3*y-j*x^4-
y^4,3136],[-x*y^4-j*x^2*y^3-j*x^3*y^2-y^5,7965],[-x^2*y^3+(j^2-j)*x^3*y^2-
2*j*x^4*y+x^5,7880],[-x^2*y^2-j^2*x^3*y,4440],[-x*y^3-j^2*x^2*y^2-j^2*x^3*y,
4568],[-x*y^2+j^2*x^2*y,4202,4323,7901],[-x*y^3+j^2*x^2*y^2+(j^2-j)*x^3*y-
j*x^4,2976],[-x^2*y^3+2*j^2*x^3*y^2+(j^2-j)*x^4*y,4560],[-x*y+j*x^2,5980],[-
x*y^2+j*x^2*y,7700],[-x^3*y+j*x^4,7896],[-x*y^2+j*x^2*y+j*x^3,4083],[-x^2*y^2+
j*x^3*y+j*x^4,2967],[-x*y^2+j*x^2*y+j*x^3-y^3,2807],[-x*y^2+(2*j^2+j)*x^2*y,
4320],[-x*y^4+(2*j^2+j)*x^2*y^3-x^3*y^2,7800],[-x^2*y^3+(2*j^2+j)*x^3*y^2+
(j^2-j)*x^4*y+j^2*x^5,7882],[-x^2*y^3+(2*j^2+j)*x^3*y^2+j^2*x^4*y,4569,7881],
[-x^2*y^3+(2*j^2+j)*x^3*y^2+2*j^2*x^4*y+j^2*x^5,4562],[-x*y^4+(2*j^2+
j)*x^2*y^3+3*j^2*x^3*y^2+3*j^2*x^4*y+j^2*x^5,3002],[-x*y^4+(3*j^2+j)*x^2*y^3+
(3*j^2-j)*x^3*y^2+(j^2-j)*x^4*y,3000],[-x*y^2+(j^2+2*j)*x^2*y+j*x^3-y^3,7367],
[-x*y^4+(3*j^2+2*j)*x^2*y^3+(3*j^2+j)*x^3*y^2+j^2*x^4*y,3009],[1,84,292,652,
912,1559,1893,2053,2055,2098,2372,2553,2653,2665,2713,2791,2834,3119,3247,
3291,4438,5554,5612,6814],[x^-1,1741],[x^-1*y,2661],[x,328,492,697,765,820,
943,1094,1135,1173,1312,1641,1682,1960,2005,2047,2215,2647,2871,2953,3280,
3320,3490,3569,3888,4244,4800,4882,5011,5087,5163,5374,5577,5580,5815,5907,
6400,6481,6523,6646,6851,7013,7100,7261,7305,7549],[y,0,123,287,369,408,410,
451,659,738,861,895,902,908,984,1353,1394,1476,1517,1600,1601,1602,1768,1846,
1885,2045,2051,2174,2364,2379,2543,2584,2644,2656,2660,2666,2707,2789,3035,
3076,3158,3457,3460,3540,3692,3741,3774,3944,4102,4143,4225,4303,4471,4512,
4556,4594,4717,4841,5044,5128,5210,5333,5661,5702,5743,5784,5989,6072,6112,
6153,6358,6399,6564,6687,6728,6760,6763,6769,6805,6810,6903,7056,7153,7396,
7457,7460,7466,7630,7672,7794,7835,7917,7958,7999],[x*y,161,240,241,242,1265,
1430,2497,2620,2908,3403,4084,4100,4106,4208,4795,5416,5684,5806,5971,6013,
6015,6022,6025,6231,6925,6931,6936,6965,7005,7499,7577,7732],[x*y^2,724,967,
2806,3022,6005,6011,6229,6260,6266,7607,7724],[x*y^3,721,7811],[x^2,1040,1043,
3963,4056,5336,5691,5696,5807,5843,7007],[y^2,897,1343,2130,2165,2170,2524,
4461,4534,6055,6062,6262,7143,7374,7613,7615,7622,7625,7655,7662,7668,7831],
[x^2*y,1460,1466,3102,5780,5786,5920,6007,6051,6251,6309,7696,7860,7866],
[x^2*y^2,2966,6243],[x^2*y^3,3083],[y^3,2973,7124,7365,7605,7657,7829,7933,
7935,7942,7945,7992],[x^3*y,1440,1443,5763,7843],[y^4,7982],[x*y^2-x^2*y-x^3,
4363],[x*y^4-x^3*y^2-x^4*y+y^5,7920],[1+x*y^-1,2778],[x+y,164,246,779,1066,
1107,1148,1189,1271,1435,1599,1887,1928,1963,1969,2010,2338,2365,2370,2461,
2502,2625,2773,2785,2818,2912,2994,3115,3154,3199,3283,3289,3323,3487,3651,
3733,3815,3897,3980,3986,4020,4184,4266,4348,4389,4676,4758,4799,4964,5005,
5169,5292,5456,5538,5579,5692,5860,5866,6030,6235,6317,6482,6934,6974,7015,
7097,7302,7343,7507,7548,7587,7712,7753,7876],[x*y+x^2,846,1049,2767,3195,
3969,4096,4324,4584,5849,6052,6092,7539],[x*y+y^2,2361,2525,2530,2768,2780,
3030,3138,3409,5697,5699,6068,6095,6108,6184,7627,7796],[x*y^2+x^2*y,840,841,
842,2820,2826,3800,3803,3809,4444,4572,5540,5546,5642,5800,6045,6059,6099,
6256,7380,7386,7725,7730,7908,7909],[x*y^2+y^3,6057,6257,7125,7130,7617,7619,
7620,7943],[x*y^3+x^2*y^2,3126,4579,6219,6249,7786],[x*y^4+x^2*y^3,3089,4561],
[x^2*y^2+x^3*y,1449,1500,1506,2980,2986,5523,5769,6299,7849],[x^2*y^3+x^3*y^2,
7763,7883],[x^3*y+x^4,6291],[x^3*y^2+x^4*y,1483,2963],[x*y+x^2+y^2,5685],
[x*y^2+x^2*y+y^3,4540,4546],[x*y^3+x^2*y^2+x^3*y,4642,6122,7600],[x*y^3+
x^2*y^2-j*x^3*y-j*x^4,4567],[x*y^2+x^2*y-j^2*y^3,3721],[x*y^3+x^2*y^2-
j^2*x^3*y,4442,4522],[x*y^3+2*y^4,1321],[x*y^3+2*x^2*y^2+x^3*y,3140,3146,5529,
7369],[x*y^4+2*x^2*y^3+x^3*y^2,7769],[x^2*y^3+2*x^3*y^2+x^4*y,1489,2969],
[x*y^4+2*x^2*y^3-j*x^3*y^2+j^2*x^4*y,3166],[x*y^4+3*x^2*y^3+3*x^3*y^2+x^4*y,
3180,3186],[x+(-j^2-2*j)*y,2645],[x*y+(-j^2-2*j)*y^2,2641],[x*y^3+(-j^2-
2*j)*x^2*y^2,4441],[x*y^3+(-2*j^2-j)*x^2*y^2-2*j^2*x^3*y-j^2*x^4,2802],[x*y^3+
(-2*j^2-j)*x^2*y^2-j^2*x^3*y,2809,4570],[x^2*y^3+(-2*j^2-j)*x^3*y^2-j^2*x^4*y,
2960],[x*y^3+(-2*j^2-j)*x^2*y^2+(-j^2+j)*x^3*y+j*x^4,4565],[x-j*y,2650],
[x*y^3-j*x^2*y^2,6220],[x^2*y-j*x^3,7893,7895],[x^2*y^2-j*x^3*y,6300],[x*y^4-
j*x^2*y^3+y^5,3001],[x*y^2-j*x^2*y-j*x^3,4203],[x*y^3-j*x^2*y^2+j^2*x^3*y,
4564],[x*y^3-2*j^2*x^2*y^2+(-j^2+j)*x^3*y,2800],[x*y^2-j^2*x^2*y,7560],[x*y^3-
j^2*x^2*y^2-j^2*x^3*y,7927],[x*y^2-j^2*x^2*y+j*x^3,4082],[x*y+j*x^2,884],
[x*y^2+j*x^2*y,881,7644],[x*y^3+j*x^2*y^2,6041,7641],[x^2*y^2+j*x^3*y,7681],
[x^2*y^2+j*x^4,7891],[x*y^5+j*x^2*y^4-2*x^3*y^3-2*x^4*y^2-x^5*y+y^6,7960],
[x*y^2+j*x^2*y+j*x^3,1492],[2*x*y^3-x^3*y+y^4,7940],[2*x*y^2+x^2*y,6044,6244],
[2*x*y+x^2+y^2,3024,3110,3194],[2*x*y^2+x^2*y+y^3,3012,3178],[2*x*y^3+x^2*y^2+
y^4,3019,7983],[2*x*y^2+x^2*y+2*y^3,1324],[2*x*y^3+2*x^2*y^2,7780],[2*x*y^3+
2*x^2*y^2+x^3*y,7721],[2*x*y^3+(-j^2-2*j)*x^2*y^2-2*j*x^3*y-j*x^4+y^4,3007],
[2*x*y^3-j^2*x^2*y^2+j*x^3*y+y^4,7937],[3*x*y^3+4*x^2*y^2+2*x^3*y+y^4,4529],
[3*x*y^4+(-3*j^2-2*j)*x^2*y^3+(-j^2+j)*x^3*y^2+j*x^4*y+y^5,7977],[-3*j*x*y^2-
3*j*x^2*y-j*x^3+j^2*y^3,3015],[(-3*j^2-2*j)*x*y^4+2*x^2*y^3-x^3*y^2-x^4*y,
7980],[(-j^2-2*j)*x*y^2+x^2*y,4081],[(-j^2-2*j)*x*y+x^2-j*y^2,4379],[(-j^2-
2*j)*x*y^3+2*x^2*y^2+2*x^3*y-y^4,4520],[(-j^2-2*j)*x*y^4+2*x^2*y^3+(-j^2+
j)*x^3*y^2+j*x^4*y,3120],[(-j^2-2*j)*x*y^5+3*x^2*y^4-3*j^2*x^3*y^3+
2*j*x^4*y^2+j*x^5*y,3160],[(-j^2-2*j)*x*y^5+(-4*j^2-5*j)*x^2*y^4+4*x^3*y^3+
x^4*y^2,3169],[(-j^2-2*j)*x*y^4+(-2*j^2-3*j)*x^2*y^3+x^3*y^2,3129],[(-j^2-
2*j)*x*y^3+(-j^2-2*j)*x^2*y^2,7777],[(-j^2-2*j)*x*y^2+(-j^2-2*j)*x^2*y+y^3,
6245],[(-j^2-2*j)*x*y^2-2*j*x^2*y-j*x^3+2*y^3,2521],[(-j^2-2*j)*x*y^3-
2*j*x^2*y^2-j*x^3*y+2*y^4,7121],[-2*j*x*y^2-j*x^2*y+j^2*y^3,3028],[(-2*j^2-
j)*x*y^3+(-3*j^2-2*j)*x^2*y^2+2*x^3*y,4523],[(-2*j^2-j)*x^2*y^4-3*j^2*x^3*y^3-
4*j^2*x^4*y^2-3*j^2*x^5*y-j^2*x^6-y^6,3162],[(-2*j^2-j)*x^2*y^3-2*j^2*x^3*y^2-
2*j^2*x^4*y-j^2*x^5-y^5,3122],[(-2*j^2-j)*x*y^3-2*j^2*x^2*y^2-j^2*x^3*y+y^4,
3010],[(-2*j^2-j)*x*y-j^2*x^2+y^2,4367],[(-2*j^2-j)*x*y^3+(-2*j^2+j)*x^2*y^2+
(-j^2+2*j)*x^3*y+j*x^4+y^4,3005],[(-2*j^2-j)*x*y^3+(-j^2+j)*x^2*y^2+j*x^3*y,
3017],[-j,3285,3296,3855,6821],[-j*x,1045,1056,3071,3411,3773,3977,4309,5857],
[-j*y,2181,3781],[-j*x*y,2240,2243,2249,4340,4346,5928,5930,7567,7568,7570],[-
j*x*y^3,6241],[-j*x^2,2042,5200,5203,5209,5926,5967,5968,5970,7040,7524,7540],
[-j*y^2,4541,7381],[-j*x^2*y,1456,2120,2123,2129,4450,4456,5777,7690,7857],[-
j*x^2*y^2,3091,7602],[-j*x^3,5771,5802,7002,7851],[-j*x^3*y,6002],[-j*x*y+x^2,
3960,4085,4090,5840],[-j*x*y^2+x^2*y,4466],[-j*x^2+y^2,6680],[-j*x^2*y^3+
x^3*y^2+(-2*j^2-j)*x^4*y-j^2*x^5,2962],[-j*x*y^3+x^2*y^2-2*j^2*x^3*y-j^2*x^4,
7362],[-j*x*y^2+x^2*y-j^2*x^3,3048],[-j*x^2*y^2+(-j^2-2*j)*x^3*y,7771],[-
j*x*y^3+(-j^2-2*j)*x^2*y^2+x^3*y,7899],[-j*x*y^2-2*j*x^2*y-j*x^3,2816,4575,
5525,5536,6084,7376],[-j*x*y^3-2*j*x^2*y^2-j*x^3*y,7765,7776,7939,7988],[-
j*x*y^3-2*j*x^2*y^2-j*x^3*y-y^4,7989],[-j*x*y^3+(j^2-2*j)*x^2*y^2+j^2*x^3*y+
y^4,3004],[-j*x-j*y,644,2541,3405,3416,3735,3775,4308,4372,4388],[-j*x*y-
j*x^2,3062,3065,3727,3767,3840,3843,3849,4291,4299,4371,6683,7043],[-j*x*y-
j*y^2,7141],[-j*x*y^2-j*x^2*y,3057,3060,4537,4588,5537,7377,7892,7948,7949],[-
j*x*y^3-j*x^2*y^2,1377,2968,3096,7361],[-j*x^2*y-j*x^3,4200,4209,5531,5765,
5776,7845,7856],[-j*x^2*y^2-j*x^3*y,1496,7884,7973],[-j*x^3*y^2-j*x^4*y,1480,
3082],[-j*x*y-j*x^2+y^2,6801,6802],[-j*x*y^2-j*x^2*y+y^3,1457,2161,2162],[-
j*x*y^4-j*x^2*y^3+y^5,3123],[-j*x^2*y-j*x^3+y^3,7371],[-j*x^2*y^2-j*x^3*y+y^4,
7975],[-j*x*y^5-j*x^2*y^4+x^3*y^3+y^6,3163],[-j*x*y^2-j*x^2*y+(-j^2-2*j)*y^3,
4525],[-j*x*y^2-j*x^2*y-j*y^3,4536],[-j*x*y^2-j*x^2*y-j^2*y^3,3761],[-j*x*y^5-
j*x^2*y^4+(2*j^2+j)*x^3*y^3-2*x^4*y^2-x^5*y+y^6,7963],[-j*x*y^2+(j^2-j)*x^2*y+
j^2*x^3,3722],[-j*x*y^4+(j^2-j)*x^2*y^3+(2*j^2+j)*x^3*y^2-x^4*y+y^5,7923],[-
j*x^2*y-j^2*y^3,4445],[-j*x*y^4-j^2*x^2*y^3+(-2*j^2-j)*x^3*y^2+x^4*y,7967],[-
j*x*y^4-j^2*x^2*y^3-2*j^2*x^3*y^2-j^2*x^4*y,7970],[-j*x*y^2+j^2*x^2*y-x^3+y^3,
4283],[(j^2-j)*x*y^4+(3*j^2-2*j)*x^2*y^3+(2*j^2-j)*x^3*y^2+y^5,3168],[(j^2-
j)*x*y^3+(j^2-j)*x^2*y^2+y^4,3128],[(j^2-j)*x*y^2+(j^2-j)*x^2*y+j^2*x^3,3762],
[(j^2-j)*x*y^3+(j^2-j)*x^2*y^2+j^2*y^4,4521],[-2*j^2*x*y-j^2*x^2,4368,4370],[-
j^2,3250],[-j^2*x,3282,3964,4332,5844],[-j^2*y,647,852,854,867,3241,4383],[-
j^2*x*y,1512,3400,4339,5647,5940,5946,7580,7586],[-j^2*x*y^2,970,4447],[-
j^2*x*y^3,961,1441],[-j^2*x^2,1042,5986,6316],[-j^2*y^2,845,859,3730,3765,
3770,4454,4467],[-j^2*x^2*y,5764,5923,7563,7706,7844,7902,7905],[-j^2*x^2*y^2,
3097],[-j^2*x^3,5960,5963],[-j^2*x^3*y,1442,5760,6288,7680,7683,7840],[-
j^2*x*y^4-x^2*y^3-2*x^3*y^2-x^4*y,7986],[-j^2*x*y^4-x^2*y^3+2*j^2*x^3*y^2+
j^2*x^4*y,7964],[-j^2*x*y+y^2,2642],[-j^2*x*y^2+x^3,5640],[-j^2*x^2*y^2-
2*j^2*x^3*y-j^2*x^4,1484,5522],[-j^2*x^2*y^3-2*j^2*x^3*y^2-j^2*x^4*y,7762],[-
j^2*x*y-j^2*x^2,3402,4288,4290],[-j^2*x*y-j^2*y^2,4452,6252],[-j^2*x*y^2-
j^2*x^2*y,1444,1495,1508,3092,4524,5524,5929,6087,7364,7569],[-j^2*x*y^2-
j^2*y^3,6259],[-j^2*x*y^3-j^2*x^2*y^2,1364,3099,7764],[-j^2*x^2*y-j^2*x^3,
5969],[-j^2*x^2*y^2-j^2*x^3*y,2803,5520,7689,7928,7930],[-j^2*x^2*y^3-
j^2*x^3*y^2,7760],[-j^2*x^3*y-j^2*x^4,5762,7842],[-j^2*x*y-j^2*x^2+y^2,4287],
[-j^2*x*y^2-j^2*x^2*y+y^3,4531],[-j^2*x*y^3-j^2*x^2*y^2+x^3*y,3084],[-j^2*x*y-
j^2*x^2-j^2*y^2,3725],[-j^2*x*y^3+(-2*j^2+j)*x^2*y^2-j^2*x^3*y-y^4,3008],[-
j^2*x^2*y^2+(-j^2+j)*x^3*y+j*x^4,3011],[-j^2*x*y^3+j*x^2*y^2,7808],[-
j^2*x*y^4+j*x^2*y^3,1361],[-j^2*x^2*y+j*x^3,7684],[-j^2*x^2*y^2+j*x^3*y,4577,
6208],[-j^2*x^3*y+j*x^4,4571],[-j^2*x*y^5+j*x^2*y^4-3*x^3*y^3-3*x^4*y^2-x^5*y,
7969],[-j^2*x*y^5+(j^2+4*j)*x^2*y^4+(j^2+2*j)*x^3*y^3,7961],[j^2,1976,3290],
[j^2*x,1050,3242,3968,3970,5654,5848,5850],[j^2*y,660,666,863,3281,3410,4374,
4387],[j^2*x*y,643,1041,3816,5645,5651,5927],[j^2*x*y^2,4460,6250],[j^2*x*y^3,
7826],[j^2*x^2,7546],[j^2*y^2,3401,4365,4463],[j^2*x^2*y,1450,5768,5770,6060,
6066,6295,6302,7687,7848,7850],[j^2*x^2*y^2,962,6226],[j^2*x^2*y^3,7803],
[j^2*x^3,7520,7523],[j^2*x^3*y,6043,6284,6306],[j^2*x^3*y^2,3080,6200,6203],
[j^2*x^4*y,6280,6283],[j^2*x-y,3967,5847],[j^2*x*y^2-y^3,3760],[j^2*x*y^4+
x^2*y^3-2*j^2*x^3*y^2-j^2*x^4*y,7968],[j^2*x*y^4-3*j*x^2*y^3-3*j*x^3*y^2-
j*x^4*y-y^5,7979],[j^2*x^2*y^3+(2*j^2-2*j)*x^3*y^2+(j^2-2*j)*x^4*y-j*x^5,
3171],[j^2*x*y^2-j*x^2*y,2817,2982,3142],[j^2*x*y^3-j*x^2*y^2,1368,7804],
[j^2*x^2*y-j*x^3,2811,7688],[j^2*x^2*y^2-j*x^3*y,6204],[j^2*x^3*y-j*x^4,2971],
[j^2*x*y^3-j*x^2*y^2+j^2*x^3*y,7885],[j^2*x*y^2+(j^2-j)*x^2*y-j*x^3,2522],
[j^2*x*y^3+(j^2-j)*x^2*y^2-j*x^3*y,2977,7122],[j^2*x^2*y^2+(j^2-j)*x^3*y-
j*x^4,3131],[j^2*x^2*y^2+(j^2-j)*x^3*y-j*x^4+y^4,2965],[j^2*x*y^3-j^2*x^3*y,
4449],[j^2*x*y+j^2*x^2,4284],[j^2*x*y+j^2*y^2,649],[j^2*x*y^2+j^2*x^2*y,1448,
3720,4329,4528,5528,5530,6100,6106,7368,7370,7907],[j^2*x*y^3+j^2*x^2*y^2,
7768,7770],[j^2*x*y^4+j^2*x^2*y^3,7809],[j^2*x^2*y+j^2*x^3,7529],[j^2*x^2*y^2+
j^2*x^3*y,1488,1490,2970,3086,6049,6083,7906,7924],[j^2*x^2*y^3+j^2*x^3*y^2,
6209],[j^2*x^3*y+j^2*x^4,1486,7886],[j^2*x^3*y^2+j^2*x^4*y,4563,6289],
[j^2*x*y^2+j^2*x^2*y-x^3,7894],[j^2*x*y^2+j^2*x^2*y+y^3,2808],[j^2*x*y^3+
2*j^2*x^2*y^2+j^2*x^3*y,6089],[j^2*x^2*y^3+2*j^2*x^3*y^2+j^2*x^4*y,3003,7889],
[j^2*x*y^3+j*x^3*y,3088],[j^2*x*y^3+j*x^2*y^2+j*x^3*y,3090],[2*j^2*x*y^3+(j^2-
2*j)*x^2*y^2-j*x^3*y,3137],[2*j^2*x*y+j^2*x^2,4364],[2*j^2*x*y^2+2*j^2*x^2*y+
j^2*y^3,4530],[(-j^2+j)*x^2*y^2-j^2*x^3*y-y^4,7360],[(-j^2+j)*x*y^2+j*x^2*y-
j^2*y^3,3192],[j,3245,3256,3415,3988,5868,6701,7061],[j*x^-1*y,6277],[j*x,646,
3407,3971,5851],[j*y,648,650,4301],[j*x*y,1453,1469,4327,4549,5788,6803,7041,
7042,7389,7564,7868],[j*x*y^2,965,976,1445,2163],[j*x*y^3,7807,7810],[j*x^2,
5964,7527,7528,7530],[j*y^2,6269],[j*x^2*y,6047,6050,6922],[j*x^2*y^2,3087,
6207,6210],[j*x^2*y^3,3081],[j*x^3,4042,5322,5682],[j*x^3*y,6287,6290,7682],
[j*x*y-x^2,4210],[j*x*y^2-x^2*y-x^3+y^3,4280],[j*x*y^2-x^2*y-j^2*y^3,4459],
[j*x*y^2-x^2*y+j^2*x^3,3044],[j*x*y^3-x^2*y^2+j^2*x^3*y,3041],[j*x*y^4-
x^2*y^3+j^2*x^3*y^2,2961],[j*x*y^2-j^2*x^2*y,3095],[j*x*y^2-j^2*x^2*y-y^3,
2804],[j*x*y^3-j^2*x^2*y^2+x^3*y,7363],[j*x^2*y^2-j^2*x^3*y-j*x^4,7887],[j*x+
j*y,3072],[j*x*y+j*x^2,2640,2649,3731,3771,4297,4377,5775,5924,6681,6682,7373,
7855],[j*x*y+j*y^2,1455,1468,2828,2992,3068,3152,4548,5548,7388],[j*x*y^2+
j*x^2*y,1459,2523,4281,4282,4539,6088,6090,7379,7903],[j*x*y^2+j*y^3,1375,
1388,7788,7941],[j*x*y^3+j*x^2*y^2,7123],[j*x*y^3+j*y^4,7981],[j*x^2*y+j*x^3,
2760,2763,2769,4080,4089,6086],[j*x^2*y^2+j*x^3*y,1499,3085,6242,7888,7890,
7897],[j*x^3*y^2+j*x^4*y,7976],[j*x*y+j*x^2-y^2,2643],[j*x*y+j*x^2+j*y^2,
3776],[j*x*y^4+j*x^2*y^3+j*x^3*y^2,7922],[j*x*y^4+2*j*x^2*y^3+j*x^3*y^2,7921],
[j*x^2*y^2+2*j*x^3*y+j*x^4,4576],[j*x*y+(j^2+2*j)*y^2,3055],[j*x*y^3+(j^2+
2*j)*x^2*y^2,2964],[j*x*y^2+(j^2+2*j)*x^2*y-x^3,4360],[j*x*y^3+3*j*x^2*y^2+
3*j*x^3*y+j*x^4,3016],[j*x*y^5+(j^2+3*j)*x^2*y^4+(j^2+2*j)*x^3*y^3+
j^2*x^4*y^2+j^2*x^5*y,7962],[(2*j^2+j)*x*y^3-x^2*y^2,7820],[(2*j^2+j)*x*y^3+
(j^2-j)*x^2*y^2-2*j*x^3*y-j*x^4+j*y^4,3125],[(2*j^2+j)*x*y^2+(j^2-j)*x^2*y-
j*x^3-y^3,2805],[(2*j^2+j)*x*y^4+(2*j^2-j)*x^2*y^3+(j^2-3*j)*x^3*y^2-
3*j*x^4*y-j*x^5+j*y^5,3165],[(2*j^2+j)*x*y^2+j^2*x^2*y-y^3,2810],[(2*j^2+
j)*x*y^3+j^2*x^2*y^2-j*x^3*y,3182],[(2*j^2+j)*x*y^3+j^2*x^2*y^2+j*y^4,3130],
[(2*j^2+j)*x*y^4+3*j^2*x^2*y^3+j^2*x^3*y^2+j*y^5,3170],[(2*j^2+j)*x*y^2+
(2*j^2+j)*x^2*y-2*y^3,4527],[(3*j^2+j)*x*y^4+(3*j^2-j)*x^2*y^3+(j^2-
2*j)*x^3*y^2-j*x^4*y,3177],[2*j*x*y^2+(-j^2+j)*x^2*y+j*x^3+j*y^3,2975],
[2*j*x*y+j*x^2+j*y^2,2815,3736,5535,7375],[2*j*x*y^2+j*x^2*y+j*y^3,2988,7775],
[2*j*x*y^3+2*j*x^2*y^2-y^4,3124],[2*j*x*y^4+(-j^2+4*j)*x^2*y^3+(-2*j^2+
2*j)*x^3*y^2-j^2*x^4*y-y^5,3164],[(j^2+2*j)*x*y-x^2,4205],[(j^2+2*j)*x*y^2-
x^2*y,4201],[(j^2+2*j)*x*y^2+j*x^2*y-y^3,3763],[(j^2+2*j)*x*y^4+j*x^2*y^3+
(j^2+2*j)*y^5,3121],[(j^2+2*j)*x*y^5+2*j*x^2*y^4+(-j^2+j)*x^3*y^3+(j^2+
2*j)*y^6,3161],[3*j*x*y^2+j*x^2*y+2*j*y^3,3148],[(j^2+3*j)*x*y^2+2*j*x^2*y+
j*x^3+j*y^3,3135],[(-j^2+4*j)*x*y^3+(-j^2+3*j)*x^2*y^2+j*x^3*y+(-j^2+j)*y^4,
3188],[4*j*x*y^3+6*j*x^2*y^2+3*j*x^3*y+j*x^4-j^2*y^4,3175]])*x^0*y^0;end;
f31:=function(x,y,j) return dec(45,
[[-2*x^2*y^2-2*x^3*y+j^2*x^4,3809],[-2*x^2*y^2-x^3*y+j^2*x^4+y^4,3806],
[-2*x*y^5-j*x^2*y^4+j^2*x^4*y^2-3*j*x^5*y-j^2*x^6-y^6,3781],[-2*x*y^2+
(2*j^2-j)*x^2*y-2*j*x^3,1669],[-2*x*y^2+j*x^2*y+j*y^3,7765],[-1,11,57,1042,
1124,1166,1309,1528,1545,2960,3570,3772,4800,4892,4941,4986,5017,5110,6545,
6628,7374,7466,7595,8838,9436,9482,9849,9981,10033,10123],[-x,919,1175,1292,
1321,1413,2357,2440,2636,4047,5289,5750,5754,6025,6316,6712,6758,7104,7274,
7911,8097,10122],[-y,1843,3248,3346,3438,3529,4435,5606,6072,6891,7144,7775,
7779,8145,8328,8374,8512,8567,8651,8789,9379],[-x*y,587,954,1031,1740,1787,
1842,1917,1997,2007,2171,2262,4683,4730,4930,5903,6166,6258,6939,7778,7810,
7916,8963,9367,9374,9612,9970],[-x*y^2,7072,7079,9068,9115,9917,9927],[-x^2,
2116,4012,4019,4022,4141,4646,4936,6029,7103,7919,8062,8069,8072,9385,9976],
[-y^2,3128,3844,5883,7084],[-x^2*y,3676,6009,7090,7528,7899],[-x^3,1651,1692,
3649,4931,4934,5649,9383,9971,9974],[-x^3*y,1271,3297,3674,5998,7088,7527],
[-x^4,1646,1649],[-x*y-2*x^2,5753],[-x*y^3-2*x^2*y^2+(j^2-j)*x^3*y-j*x^4,
1670],[-x^2*y^3-2*x^3*y^2+(j^2-j)*x^4*y-j*x^5,1676],[-x*y^3-2*x^2*y^2+
j^2*x^3*y,7769],[-x^2*y^2-2*x^3*y+j^2*x^4,5744],[-x-y,1133,4437,4925,7433,
9965],[-x*y-x^2,1278,1640,3048,3309,3496,3818,4914,4915,4920,5919,7521,7895,
7947,9954,9955],[-x*y-y^2,1009,3878,4433,7935],[-x*y^2-x^2*y,997,1007,3654,
3655,3769,4928,9796,9968],[-x*y^2-y^3,7954],[-x^2*y-x^3,1265,1602,1628,1629,
1630,1635,3025,3494,7518,8037],[-x^2*y^2-x^3*y,1699,9794],[-x*y^4-x^4*y-j*x^5,
1260,3286,7516],[-x*y^2-x^2*y+j^2*x^3,3811],[-x*y^3-x^2*y^2+j^2*x^3*y,7766],
[-x^2*y^2-x^3*y+j^2*x^4,5741],[-x*y^3-x^2*y^2+j*x^4,3476],[-x*y^4-x^2*y^3+
j*x^4*y,9776],[-x^2*y+y^3,3478,3491],[-x^2*y^2+y^4,9778,9791],[-x*y^4+
x^3*y^2-j*x^5,3466],[-x*y^5+x^3*y^3-j*x^5*y,9766],[-x*y^4+x^3*y^2+2*j*x^4*y+
j*x^5,3791],[-x*y-j*x^2,1697],[-x*y-j*x^2-y^2,3765],[-x^3*y-j*x^4-y^4,1262,
10082],[-x^3*y^2-j*x^4*y-y^5,1802],
[-x*y^5-j*x^2*y^4-x^4*y^2-2*j*x^5*y-j^2*x^6,5716],[-x^2*y^2-j*x^3*y+y^4,3793],
[-x*y^3+(j^2-j)*x^2*y^2-2*j*x^3*y,7743],[-x^2*y^2+(j^2-j)*x^3*y-2*j*x^4,5718],
[-x*y^2+(j^2-j)*x^2*y-j*x^3,3740,5721],[-x-j^2*y,3815],[-x*y-j^2*y^2,7773],
[-x+j^2*y,1301],[-x*y+j^2*x^2,4932,9972,10098],[-x*y+j^2*y^2,7540],[-x*y^2+
j^2*x^2*y,1818,7771],[-x^2*y+j^2*x^3,5746,10096],[-x^2*y^2+j^2*x^3*y,1816],
[-x*y^5+j^2*x^2*y^4-x^3*y^3+(2*j^2+j)*x^4*y^2+(j^2-2*j)*x^5*y+x^6,1665],[-x*y+
j^2*x^2+y^2,3471],[-x*y^2+j^2*x^2*y+y^3,9771],[-x*y^2+j^2*x^2*y-j*x^3,1683,
3751],[-x^2*y^2+j^2*x^3*y-j*x^4,1681],[-x*y+j^2*x^2+j*y^2,1686],[-x*y+j*x^2,
9377],[-x*y^2+j*x^2*y,7082],[-x*y^3+j*x^3*y,3747],[-x*y^2+j*x^3-y^3,3470],
[-x*y^3+j*x^3*y-y^4,9770],[1,103,1043,1122,1257,1544,2523,2570,3569,3770,3774,
4199,4290,4451,6122,6214,6499,7238,8479,9213,9348,9967,10120],[x,459,460,465,
772,779,782,920,966,1012,1058,1087,1094,1097,1173,1196,1288,1334,1401,1426,
1564,1618,1704,1748,1794,2117,2412,2774,2866,2913,3003,3497,3589,3681,3817,
3911,4049,4142,4648,4946,5254,5282,5292,5752,5984,6028,6363,7087,7179,7547,
7628,7897,8053,8099,8101,8240,8286,8424,8607,8745,8875,9190,9388,9802,9986,
10124],[y,138,184,230,276,322,368,414,644,690,736,828,874,964,1026,1380,1472,
1702,1840,2025,2071,2209,2301,2484,2669,2715,2797,3037,3175,3208,3957,4003,
4050,4096,4510,4556,4602,4832,5154,5338,6075,6404,6450,6581,6800,6857,7041,
7172,7182,7317,7406,7450,7501,7731,7958,8007,8192,8698,9020,9296,9664,9710,
9756],[x*y,495,541,1844,1870,1968,2004,3620,5061,5198,5416,5508,5690,5902,
6672,6985,7093,7683,7858,7950,8926,9368,9369,9375,9524,9570,9797,9893,10077,
10104],[x*y^2,1015,1824,3720,3834,5789,5836,5918,7073,7074,7080,9924],[x^2,
908,1617,2115,2980,3495,4140,4647,6027,7086,8052],[y^2,3846,3895],[x^2*y,1021,
1273,3663,9795,10093],[x^2*y^2,1813],[x^3,3651,5652,9394],[x^3*y,1016,1019,
1272,3661,7099,7526],[x^2*y^2-y^4,7774],[x*y^4-x^3*y^2+j*x^5,3465],
[x*y^5-x^3*y^3+j*x^5*y,9765],[x+y,506,552,598,1132,1150,1152,1610,1887,1932,
1978,2024,2163,2255,2485,2807,3129,3221,3267,3359,3451,3543,3635,3727,3865,
4372,4418,4464,4694,4740,4924,5062,5200,5430,5522,5614,5706,5798,5844,5890,
6074,6167,6259,6397,6443,6673,6811,6903,6949,6995,7133,7225,7363,7409,7452,
7685,7777,7961,8045,8146,8330,8376,8514,8560,8652,8790,8928,8974,9066,9112,
9526,9572,9618,9894,9940,9966,10078],[x*y+x^2,1266,1608,1639,1703,3483,4912,
4922,5912,5922,7533,7896,7917,8043,9952,9962],[x*y+y^2,1010,1148,3036,3173,
3897,7448],[x*y^2+x^2*y,1000,1868,3652,3662,9783],[x*y^2+y^3,3893],[x*y^3+
x^2*y^2,1013],[x^2*y+x^3,1263,1627,1634,1637,3481,7520,7531],[x^2*y^2+x^3*y,
3814,5749,9781],[x*y^3+x^2*y^2-j*x^4,3477],[x*y^4+x^2*y^3-j*x^4*y,9777],
[x*y^2+x^2*y-j^2*x^3,1696,3761],[x*y^4+x^2*y^3+j^2*x^3*y^2-2*j*x^4*y,3792],
[x*y^2+x^2*y+j*x^3,3810,5745],[x*y^4+x^4*y+j*x^5,1261,5987,7515],[x*y^2+
2*x^2*y-j^2*x^3,3764],[x^2*y^2+2*x^3*y-j^2*x^4,1694],[x*y^3+
(-3*j^2-2*j)*x^2*y^2+(-2*j^2+j)*x^3*y+2*j*x^4,1668],[x*y-j*x^2,9370],
[x*y-j*y^2,7781],[x*y^2-j*x^2*y,7075],[x*y^4-j*x^3*y^2,7752],[x^2*y^3-j*x^4*y,
5727],[x*y^2-j*x^3+y^3,3468],[x*y^3-j*x^3*y+y^4,9768],[x*y-j*x^2+j^2*y^2,
3760],[x-j^2*y,7556],[x*y-j^2*x^2,3766,6018],[x*y-j^2*y^2,1285],
[x*y^2-j^2*x^2*y,1017],[x^2*y-j^2*x^3,6003],[x^3*y-j^2*x^4,6001],
[x*y-j^2*x^2-y^2,3469],[x*y^2-j^2*x^2*y-y^3,9769],[x*y^5-j^2*x^2*y^4+x^3*y^3+
x^4*y^2+2*j*x^5*y-x^6,5715],[x*y-j^2*x^2-j*y^2,3801],[x*y^2-j^2*x^2*y+j*x^3,
3798],[x*y^3-j^2*x^2*y^2+j*x^3*y,7756],[x^2*y^2-j^2*x^3*y+j*x^4,5731],[x+
j^2*y,1700,3317,3768],[x*y^3+(-j^2+j)*x^2*y^2+j*x^3*y,7745],[x^2*y^2+(-j^2+
j)*x^3*y+j*x^4,5720],[x*y^2+(-j^2+j)*x^2*y+2*j*x^3,3738],[x*y+j*x^2,3812,5747,
7908],[x^3*y^2+j*x^4*y,1677],[x^2*y^2+j*x^3*y-y^4,1678],[x^3*y+j*x^4+y^4,3287,
7517],[x*y^5+j*x^2*y^4+x^4*y^2+2*j*x^5*y+j^2*x^6,1666],[x^2*y^3+j*x^3*y^2+
j*x^4*y,7751],[2*x+y,3773],[2*x^3*y+x^4,3296],[2*x^2*y^2+x^3*y-j^2*x^4-y^4,
1691],[2*x*y^2+2*x^2*y,999],[2*x*y^2+(-2*j^2-j)*x^2*y-j*y^3,7747],
[2*x*y^2-j^2*x^2*y+y^3,7770],[2*x*y^5-j^2*x^2*y^4+x^3*y^3-j^2*x^4*y^2+
3*j*x^5*y-x^6+y^6,3780],[2*x^2*y^2-j^2*x^3*y+j*x^4,3796],[2*x*y^2+(-j^2+
j)*x^2*y+j*x^3,1671],[2*x*y^2+(-j^2+2*j)*x^2*y+2*j*x^3,3784],
[(-3*j^2-4*j)*x*y^2+(-2*j^2-j)*x^2*y-2*j*y^3,7754],[(-2*j^2-3*j)*x*y+2*x^2+
j^2*y^2,3289],[(-j^2-3*j)*x*y+2*x^2-j*y^2,10095],[(-j^2-3*j)*x*y^2+
2*x^2*y-j*y^3,1815],[(-j^2-2*j)*x*y+x^2,4919,9959],[(-j^2-2*j)*x*y^2+x^2*y,
1005],[(-j^2-2*j)*x*y+2*x^2,10089],[(-j^2-2*j)*x*y^2+2*x^2*y,1809],
[(-j^2-2*j)*x^2*y+2*x^3,5992],[(-j^2-2*j)*x*y^2+
(-2*j^2-j)*x^2*y-2*j^2*x^3-j*y^3,3787,3797],
[(-j^2-2*j)*x*y^4-j*x^2*y^3-j*x^3*y^2+(-2*j^2-j)*x^4*y+(-j^2+j)*x^5-j*y^5,
10081],[(-j^2-2*j)*x*y^5-j*x^2*y^4-j*x^3*y^3+(-2*j^2-j)*x^4*y^2+(-j^2+
j)*x^5*y-j*y^6,1801],[(-j^2-2*j)*x*y^2+(-j^2+j)*x^2*y+2*j*x^3,5719],
[-2*j*x*y^5+x^2*y^4-j*x^3*y^3+x^4*y^2-3*j^2*x^5*y+j*x^6-j*y^6,7875],
[-2*j*x*y^2+(-3*j^2-j)*x^2*y-2*j^2*x^3-j*y^3,7879],[-2*j*x*y-j*x^2+y^2,7529],
[(-2*j^2-j)*x*y^2+x^2*y-j^2*y^3,1283],[(-2*j^2-j)*x*y+x^2+j*y^2,7519],
[(-2*j^2-j)*x*y^2+(-2*j^2-j)*x^2*y-j*y^3,7757],[(-2*j^2-j)*x*y+
(-2*j^2-j)*x^2-j^2*y^2,1287],[(-2*j^2-j)*x*y-2*j^2*x^2,10086],
[(-2*j^2-j)*x*y^2-2*j^2*x^2*y,1806],[(-2*j^2-j)*x^2*y-2*j^2*x^3,5989],
[(-2*j^2-j)*x*y^2-j^2*x^2*y+y^3,3308],[(-2*j^2-j)*x*y-j^2*x^2-j*y^2,3744,
3750],[(-2*j^2-j)*x^2*y^2+(-j^2+2*j)*x^3*y+j*x^4-y^4,3785],[-j,1296,3307,3487,
9395,9396],[-j*x,6007,7912,9393],[-j*y,1025,4379,4424,4470,7100,7101,9787,
10100],[-j*x*y,1023,6004,7098,7768,7927,10088,10105],[-j*x*y^2,1808,1825],
[-j*x^2,1291,3808,5743,6006],[-j*y^2,1820],[-j*x^2*y,1764,10103],[-j*x^2*y^2,
1823,7753],[-j*x^3,1286,1289,1647,1695,7902],[-j*x^3*y,5638,5728],[-j*x-y,
3767],[-j*x*y^5-x^3*y^3-2*j*x^4*y^2-j^2*x^5*y-y^6,7741],[-j*x+y,9380],[-j*x*y+
x^2,10111],[-j*x*y+y^2,7085],[-j*x*y^2+x^2*y,1831],[-j*x^2*y+x^3,10109],
[-j*x^2*y^2+x^3*y,1829],[-j*x*y^2+x^2*y-j*x^3,1690],[-j*x*y^2+x^2*y-j^2*x^3,
1674,7893],[-j*x*y+x^2+j^2*y^2,3303,10090],[-j*x*y^2+x^2*y+j^2*y^3,1810],
[-j*x^2*y+x^3+j*y^3,10106],[-j*x^2*y^2+x^3*y+j*y^4,1826],[-j*x*y^2+
2*x^2*y-2*j^2*x^3,10083],[-j*x*y^3+2*x^2*y^2-2*j^2*x^3*y,1803],[-j*x^2*y^2+
2*x^3*y-2*j^2*x^4,5990],[-j*x*y^4+2*x^4*y-j^2*x^5+j^2*y^5,3285],[-j*x*y^2+
(-j^2-3*j)*x^2*y+2*x^3,5999],[-j*x*y^2+(-3*j^2-2*j)*x^2*y-2*j^2*x^3,3794],
[-j*x*y^5+(-j^2-2*j)*x^2*y^4-j*x^3*y^3-j*x^4*y^2+(-2*j^2-j)*x^5*y+(-j^2+
j)*x^6,5985],[-j*x*y^3-2*j*x^2*y^2+x^3*y-j^2*x^4,7891],[-j*x*y^3-2*j*x^2*y^2+
(-2*j^2-j)*x^3*y-j^2*x^4,7880],[-j*x*y^2+(-2*j^2-j)*x^2*y-2*j^2*x^3,5722,
5732],[-j*x-j*y,1280,3306,3327,3486,7534],[-j*x*y-j*x^2,1269,1270,1275,3472,
3482,3664,7522,7532],[-j*x*y-j*y^2,7934,9786],[-j*x*y^2-j*x^2*y,5631,9772,
9782],[-j*x*y^2-j*y^3,7748],[-j*x^2*y-j*x^3,3672],[-j*x^2*y^2-j*x^3*y,5628,
7909],[-j*x^3*y^2-j*x^4*y,5637],[-j*x*y^3-j*x^2*y^2+x^3*y-j*x^4,1688],
[-j*x*y^3-j*x^2*y^2+x^3*y-j^2*x^4-j*y^4,10092],[-j*x*y^4-j*x^2*y^3+
x^3*y^2-j^2*x^4*y-j*y^5,1812],[-j*x*y^4-j*x^2*y^3-j*x^3*y^2+x^4*y-j^2*x^5,
5996],[-j*x*y^5-j*x^2*y^4-j*x^4*y^2+x^5*y-j^2*x^6,5626],
[-j*x^2*y^3-j*x^3*y^2-2*j^2*x^4*y-j^2*x^5,7886],[-j*x*y^2-j*x^2*y-j^2*x^3,
7905],[-j*x*y^4-j*x^4*y-j^2*x^5,1667],[-j*x*y^5-j*x^2*y^4-j^2*x^5*y-j^2*x^6,
1575,8010],[-j*x*y-j^2*x^2,1838,7907],[-j*x*y^4-j^2*x^5,1586,8021],
[-j*x^3*y-j^2*x^4-j*y^4,3737],[-j*x*y^2-j^2*x^2*y-j^2*x^3,1675],
[-j*x*y^4-j^2*x^4*y-j^2*x^5-j*y^5,1577,8012],[-j*x*y^3+j*x^3*y-x^4,6011],
[-j*x^3*y^2+j*x^4*y+j*x^5,5726],[(j^2-j)*x*y^2+x^2*y-j^2*x^3,1680],
[(j^2-j)*x*y-2*j*x^2-y^2,3292,3302],[(j^2-j)*x*y-2*j*x^2+(j^2+2*j)*y^2,3739],
[(j^2-j)*x*y^2-j*x^2*y-y^3,7746],[(2*j^2-j)*x*y-2*j*x^2-y^2,3299],
[-2*j^2*x*y-x^2-j^2*y^2,3813],[-2*j^2*x*y^2-2*j^2*x^2*y+j*x^3-j^2*y^3,3314],
[-2*j^2*x*y-j^2*x^2,4909,9949],[-2*j^2*x*y^2-j^2*x^2*y,996],
[-2*j^2*x*y-j^2*x^2-j^2*y^2,7523],[-2*j^2*x*y^2-j^2*x^2*y+j*x^3-j^2*y^3,3311],
[-2*j^2*x*y+j*x^2+y^2,3300],[-2*j^2*x*y^2+2*j*x^2*y-x^3,7890],[-j^2,3320,3324,
3500,3508,3771,3775,7550],[-j^2*x,456,769,1084,1701,3485,3498,3507,3779,4937,
5737,6020,7548,9977],[-j^2*y,1611,3776,3823,4369,4414,4461,7762,8046,9800,
9808],[-j^2*x*y,1706,3759,5644,5734,7761,7782,9366,9785,9798,9807],
[-j^2*x*y^2,7071,7923],[-j^2*x^2,1685,1709,3473,4935,5736,5757,6017,9975,
10107],[-j^2*y^2,7759],[-j^2*x^2*y,1606,1689,1827,8041,9363,9373,9773],
[-j^2*x^2*y^2,1003,1760,7068,7078],[-j^2*x^3,462,776,913,1091,1579,1593,4008,
6015,8014,8028,8058],[-j^2*x^3*y,1601,1604,4916,8036,8039,9372,9956],
[-j^2*x^3*y^2,1002,7077],[-j^2*x^4,451,765,1080,1580,1591,8015,8026],
[-j^2*x*y-x^2,5748],[-j^2*x*y^3-x^3*y,3658,3671],[-j^2*x*y^2-x^2*y-x^3,7885],
[-j^2*x*y^2-x^2*y-j^2*y^3,3298],[-j^2*x^3*y-x^4-j^2*y^4,4907,9947],
[-j^2*x*y^2-x^2*y+j*x^3,5740],[-j^2*x+y,3802,9978],[-j^2*x*y+x^2,7545],
[-j^2*x*y+y^2,3310],[-j^2*x*y^2+x^3,3807],[-j^2*x*y^3+x^4,3648],[-j^2*x^2*y^3+
x^5,3657],[-j^2*x*y^5+x^2*y^4+x^3*y^3+2*j*x^4*y^2-x^5*y+y^6,7740],[-j^2*x-j*y,
1839,3318],[-j^2*x-j^2*y,3323,3680,3755,4244,4335],[-j^2*x*y-j^2*x^2,3665,
3822,4923,9963],[-j^2*x*y-j^2*y^2,1595,1724,3743,8030],[-j^2*x*y^2-j^2*x^2*y,
1585,5632,5639,8020],[-j^2*x^2*y-j^2*x^3,1624,1638,4910,4921,9950,9961],
[-j^2*x^2*y^2-j^2*x^3*y,993],[-j^2*x^3*y-j^2*x^4,1625,1636],
[-j^2*x^4*y-j^2*x^5,1631],[-j^2*x*y^4-j^2*x^4*y-x^5,4905,7877,9361,9945],
[-j^2*x*y^5-j^2*x^4*y^2-x^5*y,991,7066],[-j^2*x*y^5-j^2*x^2*y^4-x^5*y-x^6,
3645],[-j^2*x*y^3-j^2*x^2*y^2-x^3*y+j*x^4,5738],[-j^2*x*y^2-j^2*x^2*y+x^3,
5642,5742],[-j^2*x*y-j^2*x^2-j*y^2,3745],[-j^2*x*y^4-j^2*x^4*y+j*x^5,1622],
[-j^2*x^2*y^4-j^2*x^5*y+j*x^6,1620],[-j^2*x*y^3-j^2*x^2*y^2+j*x^3*y-j^2*x^4,
7898],[-j^2*x*y+j*x^2,3294],[-j^2*x*y^2+j*x^2*y,7758],[-j^2*x^2*y+j*x^3,5733],
[-j^2*x*y^2+j*x^2*y-x^3,5995,7884],[-j^2*x*y+j*x^2-j*y^2,3480],[-j^2*x*y^2+
j*x^2*y-j*y^3,9780],[-j^2*x*y+j*x^2-j^2*y^2,3316],[-j^2*x*y^2+j*x^2*y-j^2*x^3,
7900],[j^2,1295,3322,3757,10115],[j^2*x,1293,3484,3756,3777,3816,5751,5755,
10112],[j^2*y,1835,3754,7429,7776,7780],[j^2*x*y,1022,1832,3821,4233,4325,
5645,5756,7784,9364,9378,9784],[j^2*x*y^2,1713,3788,7069,7083,7764],[j^2*x^2,
455,768,918,1083,3312,3492,3800,3824,4009,5759,7903,8059,10110],[j^2*y^2,
3874],[j^2*x^2*y,1020,1830,4918,5633,5739,9365,9376,9792,9958],[j^2*x^2*y^2,
7070,7081],[j^2*x^3,916,1581,6012,8016],[j^2*x^3*y,4917,9371,9957],
[j^2*x^3*y^2,1001,7076],[j^2*x^4,902,1578,4016,5659,8013,8066],[j^2*x^5,4005,
8055],[j^2*x-y,10113],[j^2*x*y-x^2,1290],[j^2*x*y-y^2,1833],[j^2*x*y^3-x^4,
3650],[j^2*x^2*y^3-x^5,3656],[j^2*x*y^4-x^2*y^3-x^3*y^2-2*j*x^4*y+x^5-y^5,
3735],[j^2*x*y-x^2+j^2*y^2,3762],[j^2*x*y+x^2,1698],[j^2*x*y^2+x^2*y-j*x^3+
j^2*y^3,3758],[j^2*x*y+x^2+j^2*y^2,3315],[j^2*x^3*y+x^4+j^2*y^4,9362],
[j^2*x^3*y^2+x^4*y+j^2*y^5,992,7067],[j^2*x*y^2+(-j^2-2*j)*x^2*y+x^3,6002],
[j^2*x*y^2+(-j^2-2*j)*x^2*y+x^3+j^2*y^3,3290],[j^2*x*y^2+
(-2*j^2-j)*x^2*y-2*j^2*x^3,5729],[j^2*x*y-j*x^2,3753],[j^2*x*y-j*x^2+j*y^2,
3479],[j^2*x*y^2-j*x^2*y+j*y^3,9779],[j^2*x+j^2*y,3820],[j^2*x*y+j^2*x^2,1707,
4911,5735],[j^2*x*y+j^2*y^2,1268,7760],[j^2*x*y^2+j^2*x^2*y,1008,1592,1770,
3319,3804,5634,5635,5640,5723,8027],[j^2*x^2*y+j^2*x^3,1626,4908,9948],
[j^2*x^2*y^2+j^2*x^3*y,995,1006],[j^2*x^3*y+j^2*x^4,1623,1633],[j^2*x^4*y+
j^2*x^5,1632],[j^2*x*y^4+j^2*x^4*y+x^5,4906,9360,9946],[j^2*x*y^5+j^2*x^4*y^2+
x^5*y,990,7065],[j^2*x*y^5+j^2*x^2*y^4+x^5*y+x^6,3646],[j^2*x^2*y^4+
j^2*x^5*y-j*x^6,1621],[j^2*x*y^2+j^2*x^2*y+j*y^3,7750],[j^2*x+j*y,1687],
[j^2*x^4+j*y^4,1588,8023],[2*j^2*x*y^2+(-j^2-3*j)*x^2*y+2*x^3+j^2*y^3,7889],
[2*j^2*x*y^2+(-j^2-2*j)*x^2*y+2*x^3+j^2*y^3,7882,7892],[2*j^2*x*y^2-j*x^2*y+
x^3+j^2*y^3,3301],[2*j^2*x*y+j^2*x^2,9951],[2*j^2*x*y^2+j^2*x^2*y,994],
[(-2*j^2+j)*x*y^2+2*j*x^2*y+2*y^3,7744],[(-j^2+j)*x*y^3+j*x^2*y^2-x^3*y+j*x^4,
3803],[(-j^2+j)*x*y+j*x^2+y^2,3741],[j,3321,4940,7551,9980,10102],[j*x,1655,
3329,3688,3763,4237,4329,4938,7910,7914,10101],[j*y,1279,1822,3326,7439,
10099],[j*x*y,1717,1821,3490,6005],[j*x*y^2,9790],[j*x^2,1653,1693,3687,7546,
9387],[j*y^2,1819,3884],[j*x^2*y,3748,5643,5993,6010,7092],[j*x^3,7541,7544],
[j*x^3*y,5641,6008],[j*x*y^2-2*x^2*y+2*j^2*x^3,10085],[j*x*y^3-2*x^2*y^2+
2*j^2*x^3*y,1805],[j*x^2*y^2-2*x^3*y+2*j^2*x^4,5988],[j*x^2*y-x^3,6016],
[j*x^3*y-x^4,6014],[j*x*y^2-x^2*y+j*x^3,3805],[j*x*y+y^2,7772],[j*x*y^4+
x^3*y^2+2*j*x^4*y+j^2*x^5+y^5,3736],[j*x^2*y^2-j*x^3*y-j*x^4,3746],
[j*x*y^3-j*x^3*y-j^2*x^4,6019],[j*x*y^4+j^2*x^5,1587,8022],[j*x^3*y^2+
j^2*x^4*y,7887],[j*x^2*y+j^2*x^3-j*y^3,10114],[j*x^2*y^2+j^2*x^3*y-j*y^4,
1834],[j*x*y^2+j^2*x^2*y+j^2*x^3,5725],[j*x^3*y^2+j^2*x^4*y+j*y^5,7742],
[j*x*y^5+j^2*x^2*y^4+j*x^4*y^2+2*j^2*x^5*y+x^6,7876],[j*x+j*y,3305,7535],
[j*x*y+j*x^2,1267,1277,3295,3474,3475,3678,7524,7525,7530,7913],[j*x*y^2+
j*x^2*y,3488,5629,9774,9775],[j*x*y^3+j*x^2*y^2,9788],[j*x^2*y+j*x^3,3653],
[j*x^2*y^2+j*x^3*y,5630],[j*x^3*y^2+j*x^4*y,5636],[j*x*y^2+j*x^2*y-x^3,7906],
[j*x*y^3+j*x^2*y^2-x^3*y+j^2*x^4+j*y^4,10091],[j*x*y^4+j*x^2*y^3-x^3*y^2+
j^2*x^4*y+j*y^5,1811],[j*x*y^3+j*x^2*y^2+j^2*x^3*y,7888],[j*x*y^4+j*x^4*y+
j^2*x^5,3782,5627,5717],[j*x*y^5+j*x^2*y^4+j^2*x^5*y+j^2*x^6,1576,8011],
[j*x*y^4+j*x^2*y^3+j*x^3*y^2-x^4*y+j^2*x^5,5997],[j*x*y^5+j*x^2*y^4+
j*x^4*y^2-x^5*y+j^2*x^6,5625],[j*x*y^2+(2*j^2+j)*x^2*y+j^2*x^3,5724,5730],
[j*x*y^2+(2*j^2+j)*x^2*y+2*j^2*x^3,1672,1682],[j*x*y^3+2*j*x^2*y^2+
j*x^3*y-x^4,7901],[j*x*y^3+2*j*x^2*y^2+2*j*x^3*y-x^4,7904],[j*x*y^5+(j^2+
2*j)*x^2*y^4+j*x^3*y^3+j*x^4*y^2+(2*j^2+j)*x^5*y+(j^2-j)*x^6,5986],[j*x*y^3+
(j^2+2*j)*x^2*y^2+(3*j^2+j)*x^3*y+2*j^2*x^4,7878],[j*x*y^2+(3*j^2+2*j)*x^2*y+
2*j^2*x^3,1679],[j*x*y^2+(j^2+3*j)*x^2*y-2*x^3,6000],[j*x*y^2+(2*j^2+
3*j)*x^2*y-2*x^3,3288],[(2*j^2+j)*x^2*y-x^3,1276],[(2*j^2+j)*x*y-x^2-j*y^2,
1264],[(2*j^2+j)*x*y^2-x^2*y+j^2*y^3,7538],[(2*j^2+j)*x^2*y^2+
(j^2-2*j)*x^3*y-2*j*x^4+y^4,3783],[(2*j^2+j)*x*y^2+(j^2-2*j)*x^2*y-j*x^3,
3786],[(2*j^2+j)*x*y^2+j^2*x^2*y+j*y^3,7749],[(2*j^2+j)*x*y+2*j^2*x^2,10084],
[(2*j^2+j)*x*y^2+2*j^2*x^2*y,1804],[(2*j^2+j)*x^2*y+2*j^2*x^3,5991],[(2*j^2+
j)*x*y+2*j^2*x^2-j^2*y^2,3749],[(2*j^2+j)*x*y+2*j^2*x^2+j*y^2,3742,3752],
[(2*j^2+j)*x*y+(2*j^2+j)*x^2+j^2*y^2,7542],[2*j*x*y^2+j^2*x^2*y+j^2*x^3+j*y^3,
3790],[2*j*x*y+j*x^2-y^2,1274],[2*j*x*y^2+(2*j^2+j)*x^2*y+j^2*x^3,7881],[(j^2+
2*j)*x*y-2*x^2,10087],[(j^2+2*j)*x*y^2-2*x^2*y,1807],[(j^2+2*j)*x^2*y-2*x^3,
5994],[(j^2+2*j)*x*y^3-2*x^2*y^2+j*x^3*y+j*y^4,7763],[(j^2+2*j)*x*y-x^2,9960],
[(j^2+2*j)*x*y^2-x^2*y,1004],[(j^2+2*j)*x*y-x^2-j^2*y^2,3291,10097],[(j^2+
2*j)*x*y^2-x^2*y-j^2*y^3,1817],[(j^2+2*j)*x*y^2+j*y^3,7767],[(j^2+2*j)*x*y^4+
j*x^2*y^3+j*x^3*y^2+(2*j^2+j)*x^4*y+(j^2-j)*x^5+j*y^5,10080],[(j^2+2*j)*x*y^5+
j*x^2*y^4+j*x^3*y^3+(2*j^2+j)*x^4*y^2+(j^2-j)*x^5*y+j*y^6,1800],[(j^2+
2*j)*x*y^2+(2*j^2+j)*x^2*y+j^2*x^3+j*y^3,3789],[(j^2+2*j)*x*y^2+(3*j^2+
2*j)*x^2*y+j^2*x^3,3795],[(j^2+3*j)*x*y-2*x^2+j*y^2,10094],[(j^2+
3*j)*x*y^2-2*x^2*y+j*y^3,1814],[(4*j^2+3*j)*x*y^2+(2*j^2+j)*x^2*y+(j^2+
2*j)*y^3,7755],[-1/y,3412,5393,5484,9220],[-x/y,3010,9399],[-x^2/y,5665,9398],
[(-x*y-x^2)/y,3174],[1/y,9156,9247],[x/y,3084,3502,5575,9382],[x^2/y,9381],
[(x*y+x^2)/y,3055],[(-j*x*y-j^2*x^2)/y,10118],[-j^2*x^2/y,5664],[-j^2*x^3/y,
5663],[(-j^2*x-j*y)/y,10119],[(j*x*y+j^2*x^2)/y,6024],[(j*x^2*y+j^2*x^3)/y,
6023]])*x^0*y^0;end;
f35:=function(x,y) return dec(60,
[[-4*x*y^3-2*x^2*y^2-x^3*y-y^4,7146],[-3*x*y^2-2*x^2*y-x^3-2*y^3,9246],
[-3*x^2*y-2*x^3+y^3,13982],[-3*x*y^3+x^4,7086],[-2*y,9382],[-2*x*y,9202],
[-2*x*y^2,3584,6862],[-2*y^2,12802],[-2*x^2*y^2,16440],
[-2*x*y^4-5*x^2*y^3-5*x^3*y^2-3*x^4*y-x^5,10444],
[-2*x*y^3-3*x^2*y^2-3*x^3*y-x^4,7141],[-2*x*y^3-3*x^2*y^2-2*x^3*y-x^4+y^4,
3546],[-2*x*y^3-3*x^2*y^2-x^3*y,10445,17642,17645],[-2*x*y^2-2*y^3,17662],
[-2*x*y^3-2*x^2*y^2,3245],[-2*x*y^2-2*x^2*y-x^3,6605,10457],
[-2*x*y^2-2*x^2*y-x^3-y^3,12481],[-2*x*y^3-2*x^2*y^2-x^3*y-x^4,10458,10686,
17946],[-2*x*y-x^2,7154,7155],[-2*x*y-y^2,7182,14002],[-2*x*y^2-x^2*y,12785],
[-2*x*y^2-y^3,17648],[-2*x*y^3-y^4,12483],[-2*x^2*y-x^3,9182,9185],
[-2*x^2*y^2-x^3*y,6845],[-2*x*y^2-x^2*y-2*y^3,10462,12486],
[-2*x*y^3-x^2*y^2-x^3*y,3486],[-2*x*y^2-x^2*y-x^3-y^3,13626],
[-2*x*y^3-x^2*y^2-x^3*y-y^4,10746,17886],[-2*x*y^3-x^2*y^2+x^3*y+2*x^4,9240],
[-2*x*y+x^2,7122],[-2*x^2+y^2,14001],[-2*x^2*y+x^3,7117],[-2*x*y^3+x^2*y^2+
3*x^3*y+2*x^4,9243],[-2*x^2*y^3+2*x^3*y^2+x^4*y-x^5,7080],[-1,626,1425,3668,
3790,4829,5259,5802,6042,6045,6654,7451,7695,7939,8550,8738,9106,9298,9346,
9350,9417,10982,11232,11348,11421,11477,11605,11920,12022,13062,13794,14039,
14158,14219,15942],[-x,66,433,502,560,678,745,930,997,1060,1178,1722,1727,
2922,2925,3402,3407,3731,3907,4877,4944,4996,5131,5433,5785,5797,5800,5929,
6025,6037,6351,6413,6628,6641,6645,7048,7061,7203,7629,8000,8082,8087,8307,
9226,9237,9254,9273,9287,9295,9331,9377,9381,9383,9883,10121,10193,10376,
11955,12528,12575,12756,13110,13184,13610,13634,13635,13650,13653,13912,14014,
14036,14037,14262,14525,15067,15436,15493,15683,16040,16276,16277,16281,16283,
16536,16769,16837,17072,17217,17331,17388,17391,17608,17621],[-y,1282,2954,
2973,3347,3406,3417,4755,5294,5295,5310,5313,5322,5327,5846,5849,5852,6039,
6044,6522,6525,6988,7001,7006,7017,8477,8596,9259,9281,9290,9368,9384,9389,
9399,9750,10634,10662,10798,11768,12382,12510,12522,12530,12837,13302,13305,
14025,15128,15555,16282,16284,16488,16491,16492,16710,17142,17354,17373,
17741],[-x*y^-2,3974],[-x*y^-1,5794,9407],[-x*y,1262,1265,1280,1287,2048,2052,
2062,2064,2065,2069,2071,2075,2503,2504,2532,2536,2537,2541,2543,2919,2924,
2964,3086,3089,3092,3155,3156,3494,3495,3510,3513,3522,5304,5305,5317,5320,
5829,5830,5840,6011,6142,6144,6452,6505,6506,6517,6520,6897,6981,6983,7052,
7094,7095,7113,7127,7130,7170,7190,8587,8590,9188,9209,9219,9223,9252,9271,
9378,9926,9937,10106,10119,10289,10292,10468,10645,10651,10754,10755,10770,
10773,10792,11648,11652,11662,11664,11665,11669,11671,11675,11769,11771,12362,
12365,12380,12387,12517,12797,12801,12803,13285,13297,13300,13303,14012,14016,
14019,14023,15129,15131,16273,16278,16464,16469,16472,16475,16476,16479,16484,
16892,17125,17126,17137,17140,17408,17422,17612,17668,17894,17895,17910,17913,
17932],[-x*y^2,1686,2470,2886,3121,3140,3147,3182,3185,3187,3191,3193,3198,
3207,3257,3261,3263,3284,3310,3367,3371,3557,3572,3575,3583,6430,6613,6618,
6620,6627,6848,6869,6962,6965,6980,6987,7022,7025,7033,7038,7040,7047,7172,
8046,9300,9303,10629,12787,12798,12800,13271,16442,16445,16870,17582,17585,
17593,17598,17600,17607,17710],[-x*y^3,3253,3258,12480],[-x^2,1705,1717,1720,
2905,2917,3136,3137,3385,3397,3400,3573,5773,5778,6013,6136,6137,6141,6143,
7114,8065,8077,8080,9201,9203,9280,9370,10694,10695,10710,10713,10727,12497,
13644,14245,14257,14260,15561,15563,16270,17954,17955,17970,17973,17987],
[-y^2,864,1624,2486,3188,3202,3219,3297,3326,3368,3384,3386,5675,5766,6006,
6103,6446,6968,6982,6989,6999,7028,7042,8904,9302,9369,10052,10652,10664,
12788,12809,12864,14242,14944,16886,17263,17588,17602,17726],[-x^2*y,1263,
1689,2045,2047,2049,2053,2060,2522,2525,2527,2530,2891,2947,2953,3069,3070,
3080,3265,3271,3504,3505,3517,3520,5823,6133,6138,6493,6498,6611,6857,6861,
6863,7166,8049,8580,8583,9187,9191,9200,9207,9249,9740,9747,9905,9913,10090,
10091,10269,10764,11645,11647,11649,11653,11660,12363,12790,13273,13278,16700,
16707,17113,17118,17904],[-x^2*y^2,2460,2463,3249,3250,3300,3303,6420,6423,
6847,6858,6860,10749,16443,16860,16863,17340,17700,17703,17889],[-x^3,1693,
1698,2893,3127,3130,6130,8053,8058,9190,10483,10704,13633,13638,14233,14238,
15550,16263,17964],[-y^3,2521,6486,10464,10626,13266,17106],[-x^3*y,2523,3063,
6850,7020,10080,10083,10753,10758,17580,17893,17898],[-x^3*y^2,3244],[-x^4,
6123,10693,10698,15540,17953,17958],[-x*y^2-3*x^2*y-2*x^3,13985],[-x*y-2*x^2,
14003],[-x*y-2*y^2,6622],[-x*y^2-2*x^2*y,7177],[-x*y^2-2*y^3,3262],
[-x*y^3-2*x^2*y^2-2*x^3*y-x^4,3541],[-x*y^3-2*x^2*y^2-x^3*y,7081],
[-x*y^2-2*x^2*y-x^3-y^3,9241],[-x-y,6657,9255,9270,9282,12494,12495,12513,
12527,13662],[-x-x^2*y^-1,1994,9208,12814],[-x*y-x^2,1038,3141,3143,3554,3555,
3570,5424,6623,6635,7173,7174,7187,7192,7681,8526,9264,9265,9277,9365,10481,
10722,11464,12504,13645,13657,13660,15427,16262,16265,16267,17982],[-x*y-y^2,
2079,2084,2411,3142,3209,5602,5761,6608,6629,6639,7046,7049,7059,9311,9327,
9380,10497,10782,11679,11684,13988,14228,15371,16448,16462,17606,17609,17619,
17686,17697,17922],[-x*y^2-x^2*y,2067,3189,3200,3252,5764,6607,7031,7180,8101,
9006,10461,10463,10765,10777,10780,11667,11824,13991,16449,16460,16467,17591,
17661,17663,17905,17917,17920],[-x*y^2-x^3,3373,3378],[-x*y^2-y^3,3248,3269,
3279,10448,10469,17669,17679,17683],[-x*y^3-x^2*y^2,2040,3247,3260,3267,6964,
10447,11640,17647,17651,17660,17667],[-x^2-x^3*y^-1,1047,6874,15429],
[-x^2*y-x^3,3580,4501,4864,6122,6125,6127,8224,10705,10717,10720,11941,13086,
15542,15545,17965,17977,17980],[-x^2*y-y^3,9726,16686],[-x^2*y^2-x^3*y,7023,
7149,10741,17583,17650,17881],[-x^2*y^2-x^4,3123],[-x^3*y-x^4,15543],
[-x^3*y^2-x^5,7084],[-x*y^2-x^2*y-2*y^3,5286],[-x*y^2-x^2*y-x^3,3122,3125,
9364,10480,13621,16264],[-x*y^2-x^2*y-y^3,4741,5281,7030,8464,15541,17590],
[-x*y^3-x^2*y^2-x^3*y,2524,3481,12784],[-x*y^4-x^2*y^3-x^3*y^2,3544],
[-x^2*y^2-x^3*y-x^4,3124,6124,10681,17941],[-x^2*y^3-x^3*y^2-x^4*y,6844],
[-x*y^2-x^2*y-x^3-y^3,10479],[-x*y^3-x^2*y^2-x^3*y-x^4,12484],[-x*y-x^2+y^2,
3582,9362],[-x*y^2-x^2*y+y^3,12782],[-x*y^3-x^2*y^2+y^4,3242],[-x^2*y^2-x^3*y+
y^4,10442],[-x*y^4-x^2*y^3+x^3*y^2-x^5,7083],[-x*y^3-x^2*y^2+x^3*y+x^4,10460,
13620],[-x*y^3-x^2*y^2+x^3*y+y^4,10620],[-x*y^3-x^2*y^2+x^3*y+x^4+y^4,3363],
[-x*y^4-x^2*y^3+2*x^4*y,10740,17880],[-x*y+x^2,7110,7125,14009],[-x*y^2+x^2*y,
6973,6978,12793],[-x*y^2+x^3,3275,3370,6000,7027,17587],[-x*y^3+x^2*y^2,6480,
17100],[-x*y^3+x^3*y,5280,7151,13260,17653,17658],[-x^2*y+x^3,7120,9193,9198,
11760,13998,15120],[-x^2*y^2+x^3*y,6853],[-x^2*y^2+x^4,1680,2880,3360,8040,
14220],[-x^2*y^2+y^4,6963],[-x^2*y^3+x^5,7140],[-x^3+y^3,9363],[-x*y+x^2-y^2,
7185],[-x*y^2+x^2*y+x^3,3362,3365,3561,14225],[-x*y^3+x^2*y^2+x^3*y,3560],
[-x*y^3+x^3*y+x^4,1683,8043],[-x^2*y^3+x^3*y^2+x^4*y,3480],[-x*y^3+x^2*y^2+
x^3*y-x^4,6120],[-x^2*y^3+x^4*y+2*x^5,10680,17940],[-x*y^3+x^2*y^2+2*x^3*y+
x^4,13623],[-x^2*y^3+x^3*y^2+2*x^4*y+x^5,3543],[-x*y^4+x^2*y^3+2*x^3*y^2+
2*x^4*y,10743,17883],[-x*y^3+x^2*y^2+3*x^3*y+x^4+y^4,3542],[-x^2*y+2*x^3,
7105],[-x*y^3+2*x^2*y^2-x^4,7082],[-x*y^3+2*x^3*y+x^4,10453],[-x*y^4+
2*x^3*y^2+x^4*y,3483],[-x*y^4+2*x^3*y^2+x^4*y+x^5,7143],[-x*y^3+2*x^2*y^2+
3*x^3*y+x^4,3545],[-x^2*y^3+2*x^3*y^2+3*x^4*y+2*x^5,10683,17943],[1,1302,1305,
5808,5811,5812,5865,5871,6048,9299,9374,9375,9390,9402,9410,12402,12405,12534,
14034,14038,16274,16302],[x,1285,1286,1297,1300,1708,1726,1737,2054,2074,2501,
2928,2989,3105,3111,3172,3226,3233,3294,3355,3416,3538,3599,4759,5784,5789,
5792,5795,5796,5799,5804,5836,5843,5857,6017,6021,6134,6162,6467,6475,6648,
6653,7012,7016,7067,7068,7071,7073,7075,7134,7138,7194,7199,8068,8086,8097,
8481,8603,9194,9195,9210,9213,9222,9227,9268,9274,9296,9297,9329,9335,9339,
9343,9344,9385,9391,9396,9758,9762,9945,10128,10307,10311,10315,10494,10739,
11654,11674,11772,11776,11777,11781,11783,12385,12386,12397,12400,12508,12518,
12525,12526,12529,13301,13666,13677,13994,14013,14022,14027,14029,14033,14035,
14277,15132,15136,15137,15141,15143,15559,16285,16291,16474,16718,16722,16907,
16915,17145,17389,17415,17430,17450,17627,17628,17631,17633,17635,17694,17938,
17999],[y,0,122,183,305,361,787,1091,1209,1328,1512,1769,1815,1891,1952,2013,
2135,2196,2236,2299,2379,2417,2623,2684,2806,2867,3050,3194,3195,3210,3213,
3374,3375,3390,3477,3600,3844,4025,4149,4262,4332,4393,4515,4583,4641,4698,
5062,5186,5326,5337,5485,5552,5610,6022,6284,6578,6630,6642,6705,6772,6826,
6955,6974,6975,7002,7007,7015,7034,7035,7050,7053,7261,7322,7380,7505,7566,
7747,7810,8176,8237,8413,8786,8838,8969,9289,9293,9376,9404,9457,9579,9640,
9701,9824,10250,10429,10555,10612,10800,10861,11044,11105,11166,11719,12203,
12447,12638,12691,12794,12795,12810,12822,12827,12830,12929,12992,13308,13423,
13479,13545,13728,13846,13971,13999,14026,14028,14235,14239,14250,14258,14400,
14461,14583,14702,14766,14831,14888,15010,15198,15254,15315,15377,15627,15742,
15801,15864,15986,16108,16179,16230,16292,16304,16364,16413,16482,16595,16660,
17508,17572,17594,17595,17610,17613,17816,17866],[x*y^-1,267,1454,5734,6221,
8668,9167,12274,14649,17027],[x*y,1570,1702,1723,2723,2902,3146,3157,3160,
3204,3395,3396,3403,3526,3537,4081,4203,5301,5303,5360,5762,5765,5967,6005,
6020,6152,6164,6637,6854,6855,6870,6882,6887,6890,6985,6997,7000,7044,7137,
7193,7864,8062,8083,8108,8352,9022,9272,9275,9276,9283,9284,9505,9991,10636,
10637,10641,10643,10786,10797,10923,11289,11527,11831,12070,12140,12313,12523,
12524,12805,12811,12817,13218,13277,13281,13357,13628,13649,13659,13992,13997,
14089,14335,14396,16269,16465,16477,16480,16945,17366,17604,17926,17937],
[x*y^2,2041,2046,2529,2531,3277,3488,3506,3509,3516,3519,3566,3571,5287,5291,
5300,5307,6126,6482,6485,6500,6507,6610,6884,7152,9722,9725,9920,10633,10638,
10748,10769,10775,10776,10779,11641,11646,13265,13280,13287,16682,16685,17102,
17105,17120,17127,17402,17405,17888,17909,17915,17916,17919],[x*y^3,3184,
6960],[x^2,1273,1278,1701,1703,2897,2901,2969,2971,3076,3083,3097,3381,3383,
4752,5825,5827,5833,6010,6145,6151,6617,7036,7037,7118,7129,7135,7168,8061,
8063,8462,8470,8585,9204,9205,9217,9220,9373,9745,9757,9760,10097,10276,10726,
10736,10737,11762,11765,11767,11770,12373,12378,12505,12511,14015,14017,14020,
14241,14243,15122,15125,15127,15130,16705,16717,16720,17596,17597,17986,17996,
17997],[y^2,1266,2528,3255,3270,3282,3287,3290,3332,3525,3585,3590,4748,5288,
5309,5319,5323,6502,7004,8471,8589,9742,10642,10644,11761,12366,12824,13282,
15121,16266,16702,17122,17743,17744],[x^2*y,2885,2900,3129,3131,3133,3138,
3380,3387,3501,3569,3579,5290,5763,6129,6865,6871,6877,6967,6971,7103,7183,
9251,10630,10688,10712,10715,10716,10723,10724,10756,10757,13270,13627,13631,
13989,14240,16453,16458,17896,17897,17948,17972,17975,17976,17983,17984],
[x^2*y^2,1684,3487,3491,3500,3507,6483,7087,7158,8044,9720,9723,9900,9903,
14224,16680,16683,17103],[x^3,1690,2890,3065,3067,3073,4745,4747,4749,7111,
7165,8050,8460,8463,9733,9738,10267,11763,14230,15123,16693,16698],[y^3,3126,
4446,6602,16446],[x^3*y,7089,7091,10623,10687,10691,13984,17947,17951],
[x*y^2-2*x^3,13990],[x-y,9286],[x*y-x^2,7128],[x*y-y^2,3382,3389,3399,6986],
[x*y^2-x^2*y,1260,5293,5298,5820,12360],[x*y^2-x^3,3564,9253],[x*y^3-x^3*y,
10450],[x*y^4-x^3*y^2,3240],[x^2*y-x^3,7097,7101],[x^2*y^2-x^3*y,2520,3060,
3493,3498],[x^2*y^2-x^4,3558,9180],[x^3*y-x^4,3120,7090],
[x*y^4-x^2*y^3-2*x^3*y^2-x^4*y+y^5,17643],[x*y^2-x^2*y-x^3,3565,3577,7164],
[x*y^3-x^2*y^2-x^3*y,6842],[x*y^3-x^3*y-x^4,9183],[x*y-x^2+y^2,7188,17654],
[x*y^2-x^3+y^3,10484],[x*y^3-x^3*y+y^4,12783],[x*y^4-x^3*y^2+y^5,3243],
[x^2*y^2-x^3*y+x^4,7098],[x^2*y^2-x^3*y+2*x^4,7093],[x+y,366,793,854,1098,
1220,1342,1525,1586,1647,1830,2257,2318,2440,2562,2745,3162,3661,4027,4210,
4271,4454,4576,4637,5064,5308,5369,5491,5613,5674,5768,5782,5979,6101,6528,
6589,6614,6615,6633,6647,6650,6711,6833,7383,7444,7688,7749,8359,8420,8542,
8847,8908,9317,9340,9392,9397,9518,9823,10006,10067,10433,10616,10677,10799,
10922,11288,11471,11532,11715,12081,12142,12325,12537,12630,12813,12874,12935,
12996,13240,13362,13484,13850,13972,13995,14018,14030,14094,14266,14270,14338,
14399,14705,14827,14949,15193,15376,15620,15803,16169,16352,16596,16657,16962,
17267,17511,17755,17877],[x*y+x^2,3145,3597,4508,4871,5769,5780,5787,6002,
6624,6873,7178,7186,7189,7197,8169,8231,9318,9361,9440,9627,10478,10489,10493,
11948,12503,12515,13102,13641,13643,14004,14011],[x*y+y^2,2004,3254,3273,3392,
3404,4622,8167,9248,9257,9433,9618,10454,10455,10482,10487,12488,15548,17655,
17673,17682,17687],[x*y^2+x^2*y,2404,3264,3503,3548,5586,6969,7088,9267,10477,
10622,10625,10627,11709,12487,12498,12507,12620,13262,13640,13647,15364,17347,
17350,17351,17664,17665,17677,17680],[x*y^2+y^3,16441],[x*y^3+x^2*y^2,2044,
6600,10760,10767,11644,16444,17900,17907],[x^2*y^-1+x^3*y^-2,5414],[x^2*y+x^3,
1682,1685,2882,3563,4624,6003,7156,8042,8045,11701,12606,13630,14000,14222,
17401,17406,17675,17676],[x^2*y+y^3,3366,14226],[x^2*y^2+x^3*y,3490,3547,3567,
10467,10700,10707,10747,13263,17887,17960,17967],[x^3*y+x^4,2883,3550,6604,
7024,14223,17584],[x*y^2+x^2*y-x^3,9258,9360],[x*y^2+x^2*y-y^3,12482],[x*y^4+
x^2*y^3-x^4*y,6843],[x^2*y^2+x^3*y-y^4,5283],[x*y^2+x^2*y-x^3-y^3,16260],
[x*y^4+x^2*y^3-x^3*y^2-x^4*y,17640],[x*y+x^2+y^2,3586,9366,10470,10490,17670],
[x*y^2+x^2*y+x^3,6004,7171,9181,11764,12493,12500,15124],[x*y^2+x^2*y+y^3,
3181,3186,3361,6961,7021,7026,12781,14221,17581,17586],[x*y^3+x^2*y^2+x^3*y,
3551,6841,10624,13264],[x^2*y^2+x^3*y+x^4,2884,10084],[x^2*y^3+x^3*y^2+x^4*y,
10744,17884],[x*y^3+x^2*y^2+x^3*y+x^4,7150],[x*y^2+x^2*y+2*y^3,12786],[x*y+
2*x^2,9261,9263,10486,14005],[x*y+2*y^2,12502],[x*y^2+2*x^2*y,7119,7157,10702,
10761,10763,12491,17901,17903,17962],[x^2*y+2*x^3,10701,10703,17961,17963],
[x^2*y^2+2*x^3*y,10750,17890],[x^3*y+2*x^4,10690,17950],[x*y^3+
2*x^2*y^2-2*x^4,13980],[x*y^2+2*x^2*y+x^3,7109,7161,7175,10465],[x*y^3+
2*x^2*y^2+x^3*y,9244,10451],[x^2*y+2*x^3+y^3,9250],[x*y^2+2*x^2*y+x^3+y^3,
13981],[x*y^2+2*x^2*y+2*x^3,10471],[x*y^2+3*x^2*y+x^3,13622,13625],[x*y^3+
3*x^2*y^2+x^3*y,7167],[x*y^3+3*x^2*y^2+2*x^3*y,10742,10745,17882,17885],
[x^2*y^3+3*x^3*y^2+2*x^4*y,7144],[x*y^3+3*x^2*y^2+2*x^3*y+x^4,7160],[x*y^3+
4*x^2*y^2+3*x^3*y+2*x^4,7145],[2*x*y,9279],[2*x*y^2,3502],[2*y^2,5302],
[2*x^2*y,5760,7124,7184,10709,10719,17969,17979],[2*x^3,13993],[2*y^3,6966],
[2*x*y^3-2*x^3*y-2*x^4,13983],[2*x^2*y^2-x^4,3553],[2*x*y^4-x^2*y^3-x^3*y^2+
x^4*y+x^5,3540],[2*x+y,14010],[2*x*y+x^2,12804],[2*x*y+y^2,12519,13642],
[2*x*y^2+x^2*y,5282,5285,7148,9260],[2*x*y^2+y^3,10762,17902],[2*x^2*y+x^3,
6864,7115],[2*x^2*y^2+x^3*y,3482,7107],[2*x*y^3+x^2*y^2-x^3*y,12780],
[2*x^2*y^3+x^3*y^2-x^4*y,6840],[2*x*y+x^2+y^2,12509],[2*x*y^2+x^2*y+x^3,9186],
[2*x*y^3+x^2*y^2+x^3*y,6846],[2*x*y^3+x^2*y^2+y^4,3241,6603],[2*x^2*y^2+x^3*y+
x^4,7100,7153],[2*x*y^2+x^2*y+2*y^3,6606],[2*x*y^3+x^2*y^2+2*y^4,3246],
[2*x*y^3+x^2*y^2+2*x^3*y+x^4+2*y^4,17646],[2*x*y+2*y^2,9262],[2*x*y^2+2*x^2*y,
7179],[2*x^2*y+2*x^3,7163],[2*x*y^2+2*x^2*y-y^3,3562],[2*x*y^4+
2*x^2*y^3-x^4*y+y^5,10443],[2*x*y^2+2*x^2*y+x^3,12485],[2*x^2*y^2+2*x^3*y+x^4,
7147],[2*x*y^2+2*x^2*y+x^3+y^3,6601,9304],[2*x*y^3+2*x^2*y^2+x^3*y+y^4,10441,
17641],[2*x*y^2+3*x^2*y+x^3,7169],[2*x*y^2+3*x^2*y+2*x^3,9245],[2*x*y^4+
4*x^2*y^3+x^3*y^2-x^4*y,10440],[2*x^2*y^2+4*x^3*y+2*x^4,10682,10685,17942,
17945],[2*x*y^2+4*x^2*y+2*x^3-y^3,9242],[3*x*y^2,7102],[3*x^2*y^2,7085],
[3*x*y+y^2,9269],[3*x^2*y^2+x^3*y,3485],[3*x*y^3+2*x^2*y^2+2*x^3*y+x^4+2*y^4,
10446],[3*x*y^2+3*x^2*y+2*x^3+y^3,13986],[4*x*y^2+x^2*y+y^3,7162],[4*x^2*y^2+
3*x^3*y+x^4,7142]])*x^0*y^0;end;
f37:=function(x,y,s)local v;v:=s*GetRoot(-x*y,2);
return dec(64,
[[-5*x-2*y-5*x^2*y^-1-2*x^3*y^-2,6711],[-4*x-y-6*x^2*y^-1-4*x^3*y^-2-x^4*y^-3,
6263],[-4*x-y-4*x^2*y^-1-x^3*y^-2,6455],[-3*x-y-3*x^2*y^-1-x^3*y^-2,6253,6647,
7307],[-2*x-4*x^2*y^-1-2*x^3*y^-2,13343],[-2*x-3*x^2*y^-1-2*x^3*y^-2,19597],[-
2*x^2*y^-1-2*x^3*y^-2,9781],[-2*x-y-2*x^2*y^-1-2*x^3*y^-2-x^4*y^-3,9771,15117,
15501],[-2*x-y-v*x^2*y^-2-2*x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3-x^5*y^-4,14861],[-
2*x-y-v*x^2*y^-2-v*x^3*y^-3-2*x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3-2*x^5*y^-4-
x^6*y^-5,14413],[-2*x-y-x^2*y^-1,2876,3322,5466,6210,6445,6637,6701,6903,6967,
7223,7287,7479,7819,9758,9953,9954,11510,12196,12197,19254,19573],[v*x^2*y^-2+
4*v*x^3*y^-3+4*v*x^4*y^-4+v*x^5*y^-5-2*x^2*y^-1-6*x^3*y^-2-8*x^4*y^-3-
6*x^5*y^-4-2*x^6*y^-5,5198],[-x,177,243,393,909,3132,3196,3259,3662,4399,8132,
10671,10863,10927,11067,11191,12266,12942,16556,16688,16757,16907,17035,17165,
18861,19053,19117,19253,19510,19574,19765,19851,20044,20107,20235,20457],[-y,
129,324,712,826,1039,1233,1298,1622,1687,1948,2013,2337,2402,2467,2791,2856,
2921,3050,3440,3508,3925,3995,4940,5199,5456,5910,6168,6233,6301,6430,6623,
6691,6721,6885,7206,7274,7299,7426,7532,7597,7750,7918,7941,8019,8385,8580,
8711,9014,9148,9231,9618,9747,9812,9941,10071,10202,10851,11110,11432,11889,
11956,12221,12352,12869,13134,13455,13584,13910,13975,14556,14750,14881,15140,
15269,15655,15728,15787,15855,16109,16177,16349,16641,16706,16771,17011,17031,
17227,17338,17423,17745,17874,18068,18262,18393,18588,18782,18913,19107,19172,
19430,19560,19950,20082,20276,20307,20376],[-x^2*y^-1,4216,6199,8266,11277,
12430,12494,16456,16587],[-x-4*x^2*y^-1-7*x^3*y^-2-8*x^4*y^-3-7*x^5*y^-4-
4*x^6*y^-5-x^7*y^-6,5259],[-x-4*x^2*y^-1-7*x^3*y^-2-7*x^4*y^-3-4*x^5*y^-4-
x^6*y^-5,5387],[-x-3*x^2*y^-1-4*x^3*y^-2-4*x^4*y^-3-3*x^5*y^-4-x^6*y^-5,5579],
[-x-3*x^2*y^-1-4*x^3*y^-2-3*x^4*y^-3-x^5*y^-4,4108,5771],[-x-3*x^2*y^-1-
3*x^3*y^-2-x^4*y^-3,5357,5445,13279,14220],[-x^2*y^-1-3*x^3*y^-2-3*x^4*y^-3-
x^5*y^-4,4109,13707,17525],[-x-v*x^2*y^-2-v*x^3*y^-3-3*x^2*y^-1-4*x^3*y^-2-
3*x^4*y^-3-x^5*y^-4,5367],[-x+2*v*x^2*y^-2+2*v*x^3*y^-3-3*x^2*y^-1-4*x^3*y^-2-
3*x^4*y^-3-x^5*y^-4,17781],[-x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3-2*x^5*y^-4-x^6*y^-
5,17547],[-x-2*x^2*y^-1-2*x^3*y^-2-x^4*y^-3,14350,18507],[-x^2*y^-1-2*x^3*y^-
2-2*x^4*y^-3-x^5*y^-4,17675,17867],[-x-2*x^2*y^-1-x^3*y^-2,4143,5748,6070,
6071,6217,6731,8239,12360,13471,14604,14668,16429,16432,18891,18955],[-x^2*y^-
1-2*x^3*y^-2-x^4*y^-3,12,5300,5386,13838,13899,14155,16203,16398,18059,18251,
20299],[-x^3*y^-2-2*x^4*y^-3-x^5*y^-4,5110],[-x-y,3452,3834,6594,6658,6893,
6957,7022,7237,7469,7607,7992,8821,12021,12022,12521,12858,12920,12921,12985,
13004,16755,17291,19830,20277],[-x-x^2*y^-1,2161,2364,2620,3214,4207,4278,
4346,5079,5210,6132,6388,6518,6778,6844,9308,10479,10615,12537,12877,13599,
13727,13791,15052,15693,16496,16521,16843,18540,18669,18742,18933,18997,18998,
19147,19211,19531,19596,19723,20045,20109],[-x^2*y^-1-x^3*y^-2,59,4152,5358,
5620,5687,5897,6155,8139,9783,10318,12106,12366,13881,14074,14283,14348,16248,
17976,17979,18315,18379,20296,20363],[-x^3*y^-2-x^4*y^-3,5258],[-x-y-x^2*y^-1,
7288,11509,13069],[-x-x^2*y^-1-x^3*y^-2,15373],[-x-y-x^2*y^-1-x^3*y^-2,15757,
16013],[-x-x^2*y^-1-x^3*y^-2-x^4*y^-3,8075,9975],[-x-y-x^2*y^-1-x^3*y^-2-
x^4*y^-3,15629],[-x-y-x^2*y^-1-x^3*y^-2-x^4*y^-3-x^5*y^-4,14797],[-x+v*x^2*y^-
2+2*v*x^3*y^-3+v*x^4*y^-4-x^2*y^-1+x^3*y^-2+x^4*y^-3-x^5*y^-4-x^6*y^-5,13646],
[-x+v*x^2*y^-2+v*x^3*y^-3-x^2*y^-1-x^4*y^-3-x^5*y^-4,16395],[-x-2*v*x*y^-1-
4*v*x^2*y^-2-4*v*x^3*y^-3-4*v*x^4*y^-4-2*v*x^5*y^-5-2*x^2*y^-1-2*x^3*y^-2-
2*x^4*y^-3-2*x^5*y^-4-x^6*y^-5,13369,13497],[-x-2*v*x*y^-1-4*v*x^2*y^-2-
3*v*x^3*y^-3-3*v*x^4*y^-4-4*v*x^5*y^-5-2*v*x^6*y^-6-2*x^2*y^-1-2*x^3*y^-2-
2*x^4*y^-3-2*x^5*y^-4-2*x^6*y^-5-x^7*y^-6,13305],[-x-2*v*x*y^-1-2*v*x^2*y^-2-
2*x^2*y^-1-x^3*y^-2,8047,10250,12279,18440,20336],[-2*v*x^2*y^-2-2*v*x^3*y^-3-
x^2*y^-1-2*x^3*y^-2-x^4*y^-3,9263,9464,17453],[-x-2*v*x*y^-1-4*v*x^2*y^-2-
4*v*x^3*y^-3-2*v*x^4*y^-4-x^2*y^-1-x^4*y^-3-x^5*y^-4,13625],[-x-v*x*y^-1-
3*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4-4*x^2*y^-1-6*x^3*y^-2-4*x^4*y^-3-x^5*y^-
4,5499],[-x-v*x*y^-1-3*v*x^2*y^-2-4*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5-
3*x^2*y^-1-4*x^3*y^-2-4*x^4*y^-3-3*x^5*y^-4-x^6*y^-5,5107],[-x-v*x*y^-1-
3*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4-3*x^2*y^-1-4*x^3*y^-2-3*x^4*y^-3-x^5*y^-
4,5171,5299],[-x-v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3-3*x^2*y^-1-3*x^3*y^-2-
x^4*y^-3,5427],[-x-v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-v*x^4*y^-4-3*x^2*y^-1-
4*x^3*y^-2-3*x^4*y^-3-x^5*y^-4,5496],[-v*x^2*y^-2-v*x^3*y^-3-v*x^4*y^-4-
x^2*y^-1-3*x^3*y^-2-3*x^4*y^-3-x^5*y^-4,14029],[-x-v*x*y^-1-2*v*x^2*y^-2-
2*v*x^3*y^-3-v*x^4*y^-4-2*x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3-x^5*y^-4,13817],[-x-
v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3-2*x^2*y^-1-2*x^3*y^-2-x^4*y^-3,5619,8059],[-
v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4-x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3-x^5*y^-4,
17803],[-x-v*x*y^-1-v*x^2*y^-2-2*x^2*y^-1-x^3*y^-2,5811,12338,12621,15565],[-
v*x^2*y^-2-v*x^3*y^-3-x^2*y^-1-2*x^3*y^-2-x^4*y^-3,5189,12108,13835,17995],[-
x-v*x*y^-1-x^2*y^-1,265,2683,10683,12291,14968,16077],[-v*x^2*y^-2-x^2*y^-1-
x^3*y^-2,9738,14201,17928],[-x-v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3-x^2*y^-1-
x^3*y^-2-x^4*y^-3,14009],[-v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4-x^2*y^-1-x^3*y^-
2-x^4*y^-3-x^5*y^-4,9199,17389],[-x-v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-3-
v*x^4*y^-4-x^2*y^-1+x^3*y^-2-x^4*y^-3-x^5*y^-4,12302],[-v*x^2*y^-2-v*x^3*y^-3-
x^2*y^-1-x^3*y^-2-x^4*y^-3,13753],[-x-v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-v*x^4*y^-
4-x^2*y^-1-x^4*y^-3-x^5*y^-4,1276,17654],[-x+v*x*y^-1+3*v*x^2*y^-2+4*v*x^3*y^-
3+4*v*x^4*y^-4+3*v*x^5*y^-5+v*x^6*y^-6-5*x^2*y^-1-11*x^3*y^-2-14*x^4*y^-3-
11*x^5*y^-4-5*x^6*y^-5-x^7*y^-6,5131],[-x+v*x*y^-1+3*v*x^2*y^-2+3*v*x^3*y^-3+
2*v*x^4*y^-4+3*v*x^5*y^-5+3*v*x^6*y^-6+v*x^7*y^-7-5*x^2*y^-1-10*x^3*y^-2-
13*x^4*y^-3-13*x^5*y^-4-10*x^6*y^-5-5*x^7*y^-6-x^8*y^-7,5067],[-x+v*x*y^-1+
2*v*x^2*y^-2+v*x^3*y^-3-3*x^2*y^-1-3*x^3*y^-2-x^4*y^-3,5428],[v*x^2*y^-2+
3*v*x^3*y^-3+v*x^4*y^-4-x^2*y^-1-3*x^3*y^-2-3*x^4*y^-3-x^5*y^-4,12301],[-x+
v*x*y^-1+v*x^2*y^-2-2*x^2*y^-1-x^3*y^-2,5812,10423,18699],[v*x^2*y^-2+
v*x^3*y^-3-x^2*y^-1-2*x^3*y^-2-x^4*y^-3,13688],[v*x^3*y^-3+v*x^4*y^-4-x^3*y^-
2-2*x^4*y^-3-x^5*y^-4,5066],[-x+v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3-2*x^2*y^-1-
2*x^3*y^-2-x^4*y^-3,10039],[v*x^2*y^-2+2*v*x^3*y^-3+v*x^4*y^-4-x^2*y^-1-
2*x^3*y^-2-2*x^4*y^-3-x^5*y^-4,5130,17739],[v*x^2*y^-2+4*v*x^3*y^-3+
4*v*x^4*y^-4+v*x^5*y^-5-x^2*y^-1-2*x^3*y^-2-3*x^4*y^-3-2*x^5*y^-4-x^6*y^-5,
17419],[v*x^2*y^-2+4*v*x^3*y^-3+4*v*x^4*y^-4+v*x^5*y^-5-x^2*y^-1-2*x^3*y^-2-
2*x^4*y^-3-2*x^5*y^-4-x^6*y^-5,17483],[v*x^2*y^-2+4*v*x^3*y^-3+6*v*x^4*y^-4+
4*v*x^5*y^-5+v*x^6*y^-6-x^2*y^-1-2*x^3*y^-2-x^4*y^-3-x^5*y^-4-2*x^6*y^-5-
x^7*y^-6,17355],[-x+v*x*y^-1+v*x^2*y^-2-v*x^3*y^-3-v*x^4*y^-4+v*x^5*y^-5+
v*x^6*y^-6-x^2*y^-1-x^4*y^-3-x^6*y^-5-x^7*y^-6,13517],[-x+v*x*y^-1+4*v*x^2*y^-
2+4*v*x^3*y^-3+v*x^4*y^-4-x^2*y^-1-x^4*y^-3-x^5*y^-4,16206],[2*v*x^2*y^-2+
2*v*x^3*y^-3-x^2*y^-1-2*x^3*y^-2-x^4*y^-3,5643],[-x+2*v*x*y^-1+5*v*x^2*y^-2+
5*v*x^3*y^-3+2*v*x^4*y^-4-2*x^2*y^-1-x^3*y^-2-2*x^4*y^-3-x^5*y^-4,14221],[-x+
2*v*x*y^-1+3*v*x^2*y^-2+2*v*x^3*y^-3-x^2*y^-1-x^3*y^-2-x^4*y^-3,14669],
[2*v*x^2*y^-2+4*v*x^3*y^-3+2*v*x^4*y^-4-x^2*y^-1-x^3*y^-2-x^4*y^-3-x^5*y^-4,
13433],[x^-1*y^2,9072],[x,66,261,523,976,1107,1172,1405,1433,1498,1790,1822,
1887,2148,2213,2278,2539,2604,2669,2735,3125,3382,3724,4201,4276,4338,4476,
4537,4877,5073,5141,5373,5532,5664,5729,5986,6052,6119,6376,6507,6576,6833,
6965,7030,7099,7224,7630,7691,8259,8454,8648,9168,9366,9432,9497,9563,9693,
9887,10473,10669,10802,11274,11338,11385,11578,11660,12046,12158,12289,12617,
12792,13197,13266,13332,13721,13786,14115,14207,14246,14440,14636,14702,14836,
15094,15227,15289,15351,15352,15413,15484,15694,15950,16452,16517,16582,16842,
17360,17493,17559,17661,17690,17821,17982,18015,18210,18341,18535,18666,18731,
18863,18993,19383,19464,19528,19641,19657,19772,20043,20110],[y,582,846,3267,
3441,3826,3889,4939,5394,5783,6980,7108,7599,8773,8906,8970,9098,9141,10332,
10526,10722,10981,11114,11242,11458,12012,12676,13649,15529,16211,17096,17160,
17228,17288,19305,19433,19820,19888,20268],[x^2*y^-1,49,124,206,4235,16428,
16502,16588,16781],[x+y,130,325,585,633,715,780,910,1040,1235,1237,1300,1560,
1563,1625,1690,1950,2015,2080,2340,2405,2470,2795,2860,2865,2925,2990,3055,
3185,3314,3315,3445,3510,3575,3640,3835,3965,4030,4161,4291,4356,4486,4551,
4746,4811,4876,5138,5201,5202,5331,5460,5461,5463,5851,5916,6176,6241,6306,
6436,6532,6631,6696,6724,6788,6891,6894,6895,6959,7086,7214,7215,7216,7279,
7281,7471,7476,7541,7542,7606,7611,7671,7816,7945,7996,8191,8192,8387,8582,
8712,8714,8842,8907,8972,9037,9102,9232,9622,9752,9817,9947,9948,10077,10207,
10272,10666,10857,10858,10922,11117,11442,11500,11658,11832,11897,11900,11914,
11962,12027,12190,12222,12353,12418,12483,12743,12873,12938,13070,13133,13458,
13588,13913,13917,13978,13981,14173,14303,14563,14758,14888,15148,15278,15603,
15668,15733,15798,15863,15993,16123,16188,16644,16709,16774,16904,16969,17032,
17034,17229,17292,17294,17424,17619,17749,17879,17944,18074,18139,18269,18399,
18464,18594,18789,18857,18919,19049,19113,19114,19179,19184,19244,19248,19439,
19504,19564,19568,19569,19760,19848,19959,20024,20089,20090,20104,20284],[x+
x^2*y^-1,188,251,589,1149,3212,3789,4407,6213,6323,6387,6523,6587,6712,6793,
6859,6990,7054,7118,7821,10570,10956,11020,11342,12329,12472,13759,13823,
14713,15032,15051,15374,15563,16566,16568,18760,19598],[x^2*y^-1+x^3*y^-2,
5491,5575,5614,5756,5814,8078,8252,12429,12493,14008,14286,16442,16589],
[x^3*y^-2+x^4*y^-3,5063,5308],[x+y+x^2*y^-1,6340,8650,10474,11530,15758,16014,
16840,18665,19720],[x+x^2*y^-1+x^3*y^-2,3277,14521],[x^2*y^-1+x^3*y^-2+x^4*y^-
3,12365],[x+y+x^2*y^-1+x^3*y^-2,15630],[x+y+x^2*y^-1+x^3*y^-2+x^4*y^-3,14798],
[-v*x^3*y^-3+x^2*y^-1+x^3*y^-2+x^4*y^-3+x^5*y^-4,13837],[x+v*x^3*y^-3+
v*x^4*y^-4+x^2*y^-1+x^6*y^-5+x^7*y^-6,13645],[x+2*x^2*y^-1+x^3*y^-2,4215,5767,
5939,6075,6264,6411,6542,6732,6734,6798,7309,10508,13375,13503,14603,14667],
[x^2*y^-1+2*x^3*y^-2+x^4*y^-3,5166,5255,5294,5430,9528,13836,13902],[x^3*y^-2+
2*x^4*y^-3+x^5*y^-4,13323],[x+2*x^2*y^-1+x^3*y^-2+2*x^4*y^-3+x^5*y^-4,14349],
[x+2*x^2*y^-1+2*x^3*y^-2+x^4*y^-3,6350,9866,9930,12296,13311,18056,18120],
[x^2*y^-1+2*x^3*y^-2+2*x^4*y^-3+x^5*y^-4,9272,9400],[x+2*x^2*y^-1+2*x^3*y^-2+
2*x^4*y^-3+x^5*y^-4,9674,17864],[x^2*y^-1+2*x^3*y^-2+2*x^4*y^-3+2*x^5*y^-4+
x^6*y^-5,9208],[x-2*v*x^2*y^-2-5*v*x^3*y^-3-5*v*x^4*y^-4-2*v*x^5*y^-5+
2*x^2*y^-1+x^3*y^-2-x^4*y^-3+x^5*y^-4+2*x^6*y^-5+x^7*y^-6,9162,17352],[x-
2*v*x^2*y^-2-4*v*x^3*y^-3-2*v*x^4*y^-4+2*x^2*y^-1+x^3*y^-2+x^4*y^-3+2*x^5*y^-
4+x^6*y^-5,9226,17416],[x-2*v*x^2*y^-2-2*v*x^3*y^-3+2*x^2*y^-1+2*x^3*y^-2+
2*x^4*y^-3+x^5*y^-4,9418,17608],[x+3*x^2*y^-1+3*x^3*y^-2+x^4*y^-3,1393,5359,
5383,14219,17648,17772],[x^2*y^-1+3*x^3*y^-2+3*x^4*y^-3+x^5*y^-4,5102,9420,
9550,13516],[x^3*y^-2+3*x^4*y^-3+3*x^5*y^-4+x^6*y^-5,13259],[x+v*x^2*y^-2+
v*x^3*y^-3+3*x^2*y^-1+4*x^3*y^-2+3*x^4*y^-3+x^5*y^-4,5371,5449],[x-2*v*x*y^-1-
7*v*x^2*y^-2-10*v*x^3*y^-3-7*v*x^4*y^-4-2*v*x^5*y^-5+2*x^2*y^-1+2*x^5*y^-4+
x^6*y^-5,9290,17480],[x-2*v*x*y^-1-2*v*x^2*y^-2+2*x^2*y^-1+x^3*y^-2,14670],[-
2*v*x^2*y^-2-2*v*x^3*y^-3+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,13560,17653],[x-
2*v*x*y^-1-4*v*x^2*y^-2-2*v*x^3*y^-3+3*x^2*y^-1+3*x^3*y^-2+x^4*y^-3,14222],[x-
v*x*y^-1-3*v*x^2*y^-2-3*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5+x^2*y^-1+x^5*y^-4+
x^6*y^-5,16205],[x-v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3-2*v*x^4*y^-4-v*x^5*y^-5+
x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3+x^5*y^-4+x^6*y^-5,13518],[x-v*x*y^-1-
3*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4+2*x^2*y^-1+2*x^3*y^-2+2*x^4*y^-3+x^5*y^-
4,5902],[x-v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3+2*x^2*y^-1+2*x^3*y^-2+x^4*y^-3,
6286],[x-v*x*y^-1-v*x^2*y^-2+2*x^2*y^-1+x^3*y^-2,10122,10295,18312],[-
v*x^2*y^-2-v*x^3*y^-3+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,5127,5436],[x+v*x*y^-1+
x^2*y^-1,14777,18875,19067,19131],[v*x^3*y^-3+x^3*y^-2+x^4*y^-3,17611],[x+
v*x*y^-1+v*x^2*y^-2+v*x^3*y^-3+v*x^4*y^-4+x^2*y^-1+x^4*y^-3+x^5*y^-4,14,5060,
9194,16396,17385],[x+v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3+x^2*y^-1+x^3*y^-2+
x^4*y^-3,5124,8142,9258,12152,17449],[x+v*x*y^-1+v*x^2*y^-2+2*x^2*y^-1+x^3*y^-
2,333,2893,5442,6603,8045,10186,12170,14265,14585,16312,16377,18376,18683,
20360],[v*x^2*y^-2+v*x^3*y^-3+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,4110,5366],
[v*x^3*y^-3+v*x^4*y^-4+x^3*y^-2+2*x^4*y^-3+x^5*y^-4,9294],[x+v*x*y^-1+
v*x^2*y^-2+v*x^3*y^-3+2*x^2*y^-1+2*x^3*y^-2+x^4*y^-3,14137],[x+v*x*y^-1+
v*x^2*y^-2+v*x^4*y^-4+v*x^5*y^-5+2*x^2*y^-1+3*x^3*y^-2+3*x^4*y^-3+2*x^5*y^-4+
x^6*y^-5,16397],[x+v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3+2*x^2*y^-1+2*x^3*y^-2+
x^4*y^-3,10058,14072,18248],[v*x^2*y^-2+2*v*x^3*y^-3+v*x^4*y^-4+x^2*y^-1+
2*x^3*y^-2+2*x^4*y^-3+x^5*y^-4,5193],[x+v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+
v*x^4*y^-4+2*x^2*y^-1+2*x^3*y^-2+2*x^4*y^-3+x^5*y^-4,9482,17672],[x+v*x*y^-1+
2*v*x^2*y^-2+2*v*x^3*y^-3+2*v*x^4*y^-4+v*x^5*y^-5+2*x^2*y^-1+2*x^3*y^-2+
2*x^4*y^-3+2*x^5*y^-4+x^6*y^-5,9354,17544],[x+v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-
3+3*x^2*y^-1+3*x^3*y^-2+x^4*y^-3,4151,5485,6219,16443],[x+v*x*y^-1+3*v*x^2*y^-
2+3*v*x^3*y^-3+v*x^4*y^-4+3*x^2*y^-1+4*x^3*y^-2+3*x^4*y^-3+x^5*y^-4,4107],[x+
2*v*x*y^-1+4*v*x^2*y^-2+2*v*x^3*y^-3+x^2*y^-1+x^3*y^-2+x^4*y^-3,8055],
[2*v*x^2*y^-2+4*v*x^3*y^-3+4*v*x^4*y^-4+2*v*x^5*y^-5+x^2*y^-1+x^3*y^-2+x^5*y^-
4+x^6*y^-5,17403],[2*v*x^2*y^-2+2*v*x^3*y^-3+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,
1137,17516],[x+2*v*x*y^-1+4*v*x^2*y^-2+2*v*x^3*y^-3+2*x^2*y^-1+2*x^3*y^-2+
x^4*y^-3,9802,17992],[x+2*v*x*y^-1+5*v*x^2*y^-2+5*v*x^3*y^-3+2*v*x^4*y^-4+
2*x^2*y^-1+2*x^3*y^-2+2*x^4*y^-3+x^5*y^-4,9610,17800],[3*v*x^2*y^-2+
6*v*x^3*y^-3+3*v*x^4*y^-4+x^2*y^-1+x^3*y^-2+x^4*y^-3+x^5*y^-4,17467],[2*x+y+
x^2*y^-1,6446,6447,6510,6574,6639,6907,6966,6971,7159,7241,7304,7483,11018,
11402,13597,13725,13789,18736,18928,19208,19592],[2*x+y+2*x^2*y^-1+x^3*y^-2,
4100,8234,9764,9765,9959,10698,12203,13469,16425,18888],[2*x+y+2*x^2*y^-1+
2*x^3*y^-2+x^4*y^-3,13277,14862],[2*x+y+v*x^2*y^-2+2*x^2*y^-1+2*x^3*y^-2+
2*x^4*y^-3+x^5*y^-4,14414],[2*x+y-v*x*y^-1+2*x^2*y^-1+x^3*y^-2,15118],
[2*x^3*y^-2+2*x^4*y^-3,1549],[v*x^2*y^-2+v*x^3*y^-3+2*x^2*y^-1+4*x^3*y^-2+
2*x^4*y^-3,13624],[3*x+y+3*x^2*y^-1+x^3*y^-2,6062,6255,6459,6651,6715,10762,
13341,15502,18544,18952],[3*x+y+v*x*y^-1+v*x^2*y^-2+4*x^2*y^-1+3*x^3*y^-2+
x^4*y^-3,10314,18504],[3*x+2*y+2*x^2*y^-1,6703,18992],[4*x+y+6*x^2*y^-1+
4*x^3*y^-2+x^4*y^-3,6267],[-2*v*x*y^-1-4*v*x^2*y^-2-4*v*x^3*y^-3-2*v*x^4*y^-4-
x^2*y^-1-2*x^3*y^-2-x^4*y^-3,9546,17736],[-2*v*x*y^-1-4*v*x^2*y^-2-4*v*x^3*y^-
3-2*v*x^4*y^-4,16269],[-v*x^-1*y,12507],[-v,24,494,695,1536,2111,2951,3530,
3641,3704,4064,4123,4595,4682,4745,4814,4878,5003,5396,5786,5824,7367,8127,
8190,8777,10303,10337,10532,10727,10987,11895,12256,12678,12984,13068,13653,
14304,14367,15538,15865,16058,16411,18112,18495,20448],[-v*x*y^-1,115,3597,
7182,7246,8111,8376,10287,14019,15310,18477,19339,20400],[-v*x^2*y^-2,141,
5688],[-v*x^3*y^-3,1230,9333,17612,20301],[-v-2*x-y-2*v*x*y^-1-v*x^2*y^-2-
2*x^2*y^-1-x^3*y^-2,12538],[-v-2*x-y-v*x*y^-1-x^2*y^-1,2938,8565,11125,11126,
12665,15225,15609],[-v-2*x-y-v*x*y^-1-v*x^3*y^-3-v*x^4*y^-4-x^2*y^-1-x^3*y^-2-
2*x^4*y^-3-x^5*y^-4,12345],[-v-2*x-3*v*x*y^-1-3*v*x^2*y^-2-v*x^3*y^-3-
4*x^2*y^-1-2*x^3*y^-2,15181],[-v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4-2*x^3*y^-2-
2*x^4*y^-3,13432],[-v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-v*x^4*y^-4-2*x^2*y^-1-
4*x^3*y^-2-2*x^4*y^-3,13561],[-v-x-y,16121],[-v*x*y^-1-5*v*x^2*y^-2-
8*v*x^3*y^-3-8*v*x^4*y^-4-8*v*x^5*y^-5-5*v*x^6*y^-6-v*x^7*y^-7-x^2*y^-1-
2*x^3*y^-2-3*x^4*y^-3-3*x^5*y^-4-2*x^6*y^-5-x^7*y^-6,13262],[-v*x*y^-1-
5*v*x^2*y^-2-7*v*x^3*y^-3-7*v*x^4*y^-4-5*v*x^5*y^-5-v*x^6*y^-6-x^2*y^-1-
2*x^3*y^-2-3*x^4*y^-3-2*x^5*y^-4-x^6*y^-5,13326],[-v*x*y^-1-5*v*x^2*y^-2-
8*v*x^3*y^-3-8*v*x^4*y^-4-5*v*x^5*y^-5-v*x^6*y^-6-x^2*y^-1-x^3*y^-2-x^4*y^-3-
x^5*y^-4-x^6*y^-5,13454],[-v-x-3*v*x*y^-1-3*v*x^2*y^-2-v*x^3*y^-3-2*x^2*y^-1-
x^3*y^-2,6414],[-v*x*y^-1-3*v*x^2*y^-2-3*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5-
x^2*y^-1-x^3*y^-2-x^4*y^-3-x^5*y^-4,13774],[-v-x-2*v*x*y^-1-2*v*x^2*y^-2-
3*v*x^3*y^-3-2*v*x^4*y^-4-2*v*x^5*y^-5-v*x^6*y^-6-2*x^2*y^-1-x^3*y^-2-x^4*y^-
3-2*x^5*y^-4-x^6*y^-5,14093],[-v-x-2*v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-3-
2*v*x^4*y^-4-v*x^5*y^-5-2*x^2*y^-1-x^3*y^-2-2*x^4*y^-3-x^5*y^-4,14541],[-
v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4-x^2*y^-1-2*x^3*y^-2-x^4*y^-3,
18187],[-v-x-2*v*x*y^-1-v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4-2*x^2*y^-1-
2*x^3*y^-2-x^4*y^-3,14733,14925],[-v-x-2*v*x*y^-1-v*x^2*y^-2-x^2*y^-1,6862,
9438,9570,12133],[-v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3-x^2*y^-1-x^3*y^-2,6030,
8056,18571],[-v*x*y^-1-v*x^2*y^-2+3*v*x^3*y^-3+3*v*x^4*y^-4-v*x^5*y^-5-
v*x^6*y^-6-x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3-2*x^5*y^-4-x^6*y^-5,13390],[-v-x-
v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-x^2*y^-1-x^3*y^-2,15245],[-v-x-v*x*y^-1-
v*x^2*y^-2-v*x^3*y^-3-v*x^4*y^-4-v*x^5*y^-5-x^2*y^-1-x^3*y^-2-x^4*y^-3-x^5*y^-
4,14477],[-v+x+y,4616,11507,13006,16253],[-v+x+y-2*v*x*y^-1-v*x^2*y^-2+x^2*y^-
1+x^3*y^-2,12750,15054],[-v+x+y-v*x*y^-1+x^2*y^-1,12814],[-v*x*y^-1-
4*v*x^2*y^-2-6*v*x^3*y^-3-4*v*x^4*y^-4-v*x^5*y^-5+x^2*y^-1+3*x^3*y^-2+
3*x^4*y^-3+x^5*y^-4,13708],[-v+x-3*v*x*y^-1-6*v*x^2*y^-2-6*v*x^3*y^-3-
3*v*x^4*y^-4-v*x^5*y^-5+x^2*y^-1+x^4*y^-3+x^5*y^-4,5231,17520],[-v*x*y^-1-
3*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,5710,13900,
14156],[-v+x-3*v*x*y^-1-4*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4+3*x^2*y^-1+
3*x^3*y^-2+x^4*y^-3,6027],[-v*x*y^-1-3*v*x^2*y^-2-4*v*x^3*y^-3-3*v*x^4*y^-4-
v*x^5*y^-5+x^2*y^-1+3*x^3*y^-2+3*x^4*y^-3+x^5*y^-4,5129,5518],[-v+x-3*v*x*y^-
1-4*v*x^2*y^-2-4*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5+3*x^2*y^-1+4*x^3*y^-2+
3*x^4*y^-3+x^5*y^-4,5899],[-v*x*y^-1-3*v*x^2*y^-2-4*v*x^3*y^-3-4*v*x^4*y^-4-
3*v*x^5*y^-5-v*x^6*y^-6+x^2*y^-1+3*x^3*y^-2+4*x^4*y^-3+3*x^5*y^-4+x^6*y^-5,
5065],[-v+x-3*v*x*y^-1-3*v*x^2*y^-2-2*v*x^3*y^-3-3*v*x^4*y^-4-3*v*x^5*y^-5-
v*x^6*y^-6+3*x^2*y^-1+4*x^3*y^-2+4*x^4*y^-3+3*x^5*y^-4+x^6*y^-5,5515],[-v+x-
3*v*x*y^-1-4*v*x^2*y^-2-4*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5+4*x^2*y^-1+
6*x^3*y^-2+4*x^4*y^-3+x^5*y^-4,5707],[-v+x-2*v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-
3-v*x^4*y^-4+x^2*y^-1+x^3*y^-2+x^4*y^-3,12344],[-v*x*y^-1-2*v*x^2*y^-2-
v*x^3*y^-3+x^2*y^-1+x^3*y^-2,6094,14284],[-v+x-2*v*x*y^-1-2*v*x^2*y^-2-
v*x^3*y^-3+2*x^2*y^-1+x^3*y^-2,6475,16313],[-v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-
3-v*x^4*y^-4+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,5385,5966],[-v+x-2*v*x*y^-1-
2*v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4+2*x^2*y^-1+2*x^3*y^-2+x^4*y^-3,6283,
14073],[-v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-3-2*v*x^4*y^-4-v*x^5*y^-5+x^2*y^-1+
2*x^3*y^-2+2*x^4*y^-3+x^5*y^-4,5257,5390],[-v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-
3-2*v*x^4*y^-4-2*v*x^5*y^-5-v*x^6*y^-6+x^2*y^-1+2*x^3*y^-2+2*x^4*y^-3+
2*x^5*y^-4+x^6*y^-5,5262],[-v+x-2*v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-2*v*x^4*y^-4-
v*x^5*y^-5+2*x^2*y^-1+2*x^3*y^-2+2*x^4*y^-3+x^5*y^-4,5963],[-v+x-2*v*x*y^-1-
2*v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4+3*x^2*y^-1+3*x^3*y^-2+x^4*y^-3,6091],[-v+
x-v*x*y^-1,15224],[-v*x^2*y^-2-v*x^3*y^-3+x^3*y^-2,9463],[-v*x*y^-1-v*x^2*y^-
2+2*v*x^3*y^-3+5*v*x^4*y^-4+2*v*x^5*y^-5-v*x^6*y^-6-v*x^7*y^-7+x^2*y^-1+
x^3*y^-2-x^4*y^-3-x^5*y^-4+x^6*y^-5+x^7*y^-6,5070],[-v*x*y^-1-v*x^2*y^-2+
2*v*x^3*y^-3+2*v*x^4*y^-4-v*x^5*y^-5-v*x^6*y^-6+x^2*y^-1+x^3*y^-2+x^5*y^-4+
x^6*y^-5,5134],[-v+x-v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3+2*x^2*y^-1+x^3*y^-2,3953,
12213,20332],[-v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-v*x^4*y^-4+x^2*y^-1+2*x^3*y^-2+
x^4*y^-3,13816],[-v+2*x+y-3*v*x*y^-1-3*v*x^2*y^-2-v*x^3*y^-3+2*x^2*y^-1+
2*x^3*y^-2+x^4*y^-3,14606],[-v+2*x+y-v*x*y^-1+x^2*y^-1,7820,10954,19144],[-
v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3+2*x^2*y^-1+2*x^3*y^-2,20427],[-v*x*y^-1-
2*v*x^2*y^-2-2*v*x^3*y^-3-2*v*x^4*y^-4-2*v*x^5*y^-5-v*x^6*y^-6+2*x^2*y^-1+
4*x^3*y^-2+4*x^4*y^-3+4*x^5*y^-4+2*x^6*y^-5,13304],[-v*x*y^-1-2*v*x^2*y^-2-
2*v*x^3*y^-3-2*v*x^4*y^-4-v*x^5*y^-5+2*x^2*y^-1+5*x^3*y^-2+5*x^4*y^-3+
2*x^5*y^-4,13368],[-v*x*y^-1-v*x^2*y^-2-v*x^4*y^-4-v*x^5*y^-5+2*x^2*y^-1+
4*x^3*y^-2+4*x^4*y^-3+2*x^5*y^-4,13496],[-v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-
v*x^4*y^-4+2*x^2*y^-1+4*x^3*y^-2+2*x^4*y^-3,14030],[-v+3*x+y-2*v*x*y^-1-
v*x^2*y^-2+3*x^2*y^-1+x^3*y^-2,7308,10506,18696],[-v*x*y^-1-5*v*x^2*y^-2-
8*v*x^3*y^-3-5*v*x^4*y^-4-v*x^5*y^-5+x^3*y^-2+x^4*y^-3,13582],[-v*x^2*y^-2-
4*v*x^3*y^-3-4*v*x^4*y^-4-v*x^5*y^-5+x^4*y^-3,13709],[-v-4*v*x*y^-1-
7*v*x^2*y^-2-8*v*x^3*y^-3-7*v*x^4*y^-4-4*v*x^5*y^-5-v*x^6*y^-6-x^3*y^-2-
x^4*y^-3,5303],[-v*x*y^-1-4*v*x^2*y^-2-7*v*x^3*y^-3-8*v*x^4*y^-4-7*v*x^5*y^-5-
4*v*x^6*y^-6-v*x^7*y^-7,5068],[-v-4*v*x*y^-1-7*v*x^2*y^-2-7*v*x^3*y^-3-
4*v*x^4*y^-4-v*x^5*y^-5,5431],[-v*x*y^-1-4*v*x^2*y^-2-7*v*x^3*y^-3-7*v*x^4*y^-
4-4*v*x^5*y^-5-v*x^6*y^-6,5132,5196,13452,17805],[-v*x^2*y^-2-4*v*x^3*y^-3-
7*v*x^4*y^-4-7*v*x^5*y^-5-4*v*x^6*y^-6-v*x^7*y^-7,5069],[-v*x*y^-1-4*v*x^2*y^-
2-6*v*x^3*y^-3-4*v*x^4*y^-4-v*x^5*y^-5,5243,5452,13580,17997,18189],[-
v*x^2*y^-2-4*v*x^3*y^-3-6*v*x^4*y^-4-4*v*x^5*y^-5-v*x^6*y^-6,5133,5197],[-v-
3*v*x*y^-1-4*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4-2*x^2*y^-1-2*x^3*y^-2,5487,
17776],[-v*x*y^-1-3*v*x^2*y^-2-4*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5-2*x^3*y^-
2-2*x^4*y^-3,5240,5326],[-v*x*y^-1-3*v*x^2*y^-2-4*v*x^3*y^-3-4*v*x^4*y^-4-
3*v*x^5*y^-5-v*x^6*y^-6-x^3*y^-2-2*x^4*y^-3-x^5*y^-4,13324],[-v*x*y^-1-
3*v*x^2*y^-2-3*v*x^3*y^-3-2*v*x^4*y^-4-3*v*x^5*y^-5-3*v*x^6*y^-6-v*x^7*y^-7-
x^3*y^-2-3*x^4*y^-3-3*x^5*y^-4-x^6*y^-5,13260],[-v-3*v*x*y^-1-4*v*x^2*y^-2-
4*v*x^3*y^-3-4*v*x^4*y^-4-3*v*x^5*y^-5-v*x^6*y^-6,5101],[-v-3*v*x*y^-1-
4*v*x^2*y^-2-4*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5,5058,5165,5293,5623],[-v-
3*v*x*y^-1-4*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4,5122,5250,5421,5815,6222],[-
v*x*y^-1-3*v*x^2*y^-2-4*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5,13772,18253],[-
v*x^2*y^-2-3*v*x^3*y^-3-4*v*x^4*y^-4-3*v*x^5*y^-5-v*x^6*y^-6,972,9164,9166,
17358],[-v-3*v*x*y^-1-3*v*x^2*y^-2-3*v*x^3*y^-3-3*v*x^4*y^-4-3*v*x^5*y^-5-
3*v*x^6*y^-6-v*x^7*y^-7-2*x^3*y^-2-4*x^4*y^-3-2*x^5*y^-4,5111],[-v-3*v*x*y^-1-
3*v*x^2*y^-2-2*v*x^3*y^-3-3*v*x^4*y^-4-3*v*x^5*y^-5-v*x^6*y^-6-2*x^3*y^-2-
2*x^4*y^-3,5175],[-v-3*v*x*y^-1-3*v*x^2*y^-2-v*x^3*y^-3,5378,6670,14732],[-
v*x*y^-1-3*v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-4,1466,5836,9654,13964,13966,
16204,18381,18509,18573],[-v*x^2*y^-2-3*v*x^3*y^-3-3*v*x^4*y^-4-v*x^5*y^-5,
1036,1100,5453,9228,9230,9356,17422,17486],[-v*x^2*y^-2-3*v*x^3*y^-3-v*x^4*y^-
4,14157],[-v-2*v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4-2*x^2*y^-1-
2*x^3*y^-2,8202,16392],[-v-2*v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4,
5613],[-v*x*y^-1-2*v*x^2*y^-2-2*v*x^3*y^-3-2*v*x^4*y^-4-v*x^5*y^-5,1009,5582,
17388],[-v-2*v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3,5570,5805,6606,12410],[-v*x*y^-
1-2*v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4,1073,1201,5774,9327,9660,17452,17517,
17580,17850,17909],[-v*x^2*y^-2-2*v*x^3*y^-3-2*v*x^4*y^-4-v*x^5*y^-5,9358],[-
v-2*v*x*y^-1-v*x^2*y^-2,5076,5762,6926,7310,8231,8379,13600,15116,15180,
15244],[-v*x*y^-1-2*v*x^2*y^-2-v*x^3*y^-3,1329,1594,1658,1914,3962,5511,8054,
9451,9583,9782,9846,9852,10044,10102,12150,16268,17708,17773,18042,18101,
18234,18893],[-v*x^2*y^-2-2*v*x^3*y^-3-v*x^4*y^-4,1356,5180,5451,5837,9484,
9486,9676,17742],[-v*x^3*y^-3-2*v*x^4*y^-4-v*x^5*y^-5,974,17356],[-v-2*v*x*y^-
1-v*x^2*y^-2-v*x^3*y^-3-2*v*x^4*y^-4-v*x^5*y^-5,16333],[-v-v*x*y^-1,62,4426,
4471,4620,4622,4750,5140,5268,5594,7566,7822,8521,10017,10148,10407,10603,
12393,12550,12664,12793,13397,13920,13984,14962,15353,15608,15756,16763],[-
v*x*y^-1-v*x^2*y^-2,2042,4026,4168,5316,5678,5871,5959,6072,6478,9314,9450,
9775,9967,10230,10360,10364,12143,12214,14066,14990,17641,17965,18157,18160,
18554,18763,20333],[-v*x^2*y^-2-v*x^3*y^-3,1740,9467,9868,17931,18126],[-
v*x^3*y^-3-v*x^4*y^-4,1038,1102,5116,9205,17420,17484],[-v+y-v*x^-1*y,12379],
[-v-v*x*y^-1-v*x^2*y^-2,4558,7438,15033],[-v*x*y^-1-v*x^2*y^-2-v*x^3*y^-3-
v*x^4*y^-4,18123],[v*x^-1*y,8209,8942,9079,12440,12770,12970,15614],[v,131,
4666,7672,7735,7866,8322,8759,8887,11640,11703,11722,11829,11959,12087,12088,
13067,13523,15929,15992,16008,19912,20027,20216],[v*x*y^-1,6583,6775,6839,
8373,8439,9280,11147,13826,14471,14712,14986,15885,16307],[v*x^2*y^-2,1596,
4174,8248,17974,18165],[v*x^4*y^-4,1101],[v-2*x-y+3*v*x*y^-1+3*v*x^2*y^-2+
3*v*x^3*y^-3+v*x^4*y^-4-2*x^2*y^-1-2*x^3*y^-2-2*x^4*y^-3-x^5*y^-4,14605],
[v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3-2*x^2*y^-1-2*x^3*y^-2,1265,6158,17644,
20341],[v*x^2*y^-2+2*v*x^3*y^-3+v*x^4*y^-4-2*x^3*y^-2-2*x^4*y^-3,9336],
[v*x*y^-1+3*v*x^2*y^-2+4*v*x^3*y^-3+3*v*x^4*y^-4+v*x^5*y^-5-2*x^2*y^-1-
4*x^3*y^-2-4*x^4*y^-3-2*x^5*y^-4,5454],[v-x-y+v*x*y^-1-x^2*y^-1,13005],[v-x-y+
v*x*y^-1+v*x^2*y^-2-x^2*y^-1-x^3*y^-2,12813],[v-x-y+v*x*y^-1+v*x^2*y^-2+
v*x^3*y^-3-x^2*y^-1-x^3*y^-2-x^4*y^-3,12749],[v-x-y+2*v*x*y^-1+2*v*x^2*y^-2+
v*x^3*y^-3-x^2*y^-1-x^3*y^-2-x^4*y^-3,15053],[v-x+v*x*y^-1,15544,19320],
[v*x*y^-1+v*x^2*y^-2-x^2*y^-1,14264,14328,14393,14584,16376,18491],[v*x^2*y^-
2+v*x^3*y^-3-x^3*y^-2,5646],[v*x*y^-1+v*x^2*y^-2+v*x^3*y^-3+v*x^4*y^-4-x^2*y^-
1-2*x^3*y^-2-x^4*y^-3,1404,1742,3981,17782,18124],[v*x*y^-1+v*x^2*y^-2+
v*x^4*y^-4+v*x^5*y^-5-x^2*y^-1-x^3*y^-2-x^4*y^-3-x^5*y^-4,1148,17526],[v*x*y^-
1+v*x^2*y^-2+v*x^3*y^-3-x^2*y^-1-x^3*y^-2,13944],[v-x+2*v*x*y^-1+2*v*x^2*y^-2+
v*x^3*y^-3-2*x^2*y^-1-x^3*y^-2,12234,20424],[v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-
3+v*x^4*y^-4-x^2*y^-1-2*x^3*y^-2-x^4*y^-3,9655],[v-x+2*v*x*y^-1+v*x^2*y^-2-
x^2*y^-1,4427,12488,15179],[v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3-x^2*y^-1-x^3*y^-
2,5879,9847,14136,16267,18171,20347],[v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+
2*v*x^4*y^-4+v*x^5*y^-5-x^2*y^-1-x^3*y^-2-x^4*y^-3-x^5*y^-4,18125],[v*x*y^-1+
3*v*x^2*y^-2+3*v*x^3*y^-3+v*x^4*y^-4-x^2*y^-1-2*x^3*y^-2-x^4*y^-3,5835,17787],
[v*x*y^-1+3*v*x^2*y^-2+4*v*x^3*y^-3+3*v*x^4*y^-4+v*x^5*y^-5-x^2*y^-1-2*x^3*y^-
2-2*x^4*y^-3-x^5*y^-4,17531],[v-x+4*v*x*y^-1+9*v*x^2*y^-2+12*v*x^3*y^-3+
9*v*x^4*y^-4+4*v*x^5*y^-5+v*x^6*y^-6-3*x^2*y^-1-3*x^3*y^-2-3*x^4*y^-3-
3*x^5*y^-4-x^6*y^-5,5239],[v+x+y,326,2930,5266,5591,8517,10012,10142,10402,
10597,11116,12548,12808,13003,13393,14953],[v*x*y^-1+v*x^2*y^-2+v*x^6*y^-6+
v*x^7*y^-7+x^2*y^-1+x^3*y^-2-x^4*y^-3-x^5*y^-4+x^6*y^-5+x^7*y^-6,13389],[v+x+
v*x*y^-1+v*x^2*y^-2+x^2*y^-1,15246],[v*x*y^-1+v*x^2*y^-2+v*x^3*y^-3+v*x^4*y^-
4+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,5368],[v+x+v*x*y^-1+v*x^2*y^-2+v*x^3*y^-3+
v*x^4*y^-4+2*x^2*y^-1+2*x^3*y^-2+x^4*y^-3,14478],[v+x+v*x*y^-1+v*x^2*y^-2+
v*x^3*y^-3+3*x^2*y^-1+x^3*y^-2,14734],[v+x+2*v*x*y^-1+v*x^2*y^-2+x^2*y^-1,
6728,10551,15182],[v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3+x^2*y^-1+x^3*y^-2,16249,
16270,18443],[v+x+2*v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3+2*x^2*y^-1+x^3*y^-2,9445,
10378,14926,18568],[v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+v*x^4*y^-4+x^2*y^-1+
2*x^3*y^-2+x^4*y^-3,9591,13689],[v+x+2*v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+
v*x^4*y^-4+3*x^2*y^-1+3*x^3*y^-2+x^4*y^-3,14542],[v+x+2*v*x*y^-1+3*v*x^2*y^-2+
3*v*x^3*y^-3+2*v*x^4*y^-4+v*x^5*y^-5+3*x^2*y^-1+3*x^3*y^-2+3*x^4*y^-3+x^5*y^-
4,14094],[v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3+v*x^4*y^-4+2*v*x^5*y^-5+v*x^6*y^-6+
x^2*y^-1+4*x^3*y^-2+6*x^4*y^-3+4*x^5*y^-4+x^6*y^-5,9207],[v*x*y^-1+2*v*x^2*y^-
2+2*v*x^3*y^-3+2*v*x^4*y^-4+v*x^5*y^-5+x^2*y^-1+4*x^3*y^-2+4*x^4*y^-3+x^5*y^-
4,9335],[v*x*y^-1+2*v*x^2*y^-2+3*v*x^3*y^-3+2*v*x^4*y^-4+v*x^5*y^-5+x^2*y^-1+
4*x^3*y^-2+4*x^4*y^-3+x^5*y^-4,9271],[v+x+3*v*x*y^-1+4*v*x^2*y^-2+3*v*x^3*y^-
3+v*x^4*y^-4+2*x^2*y^-1+2*x^3*y^-2+x^4*y^-3,9994,18184],[v+2*x+y+v*x*y^-1+
x^2*y^-1,377,5074,12530,15545],[v+v*x^-1*y,9143],[v+v*x*y^-1,440,2810,4619,
4683,5143,6663,7160,7242,7354,7563,7883,8068,8225,8226,8371,8568,8695,9564,
10998,10999,11063,11064,11146,11383,11384,11515,11575,12126,12202,13565,16075,
19336,20393],[v*x*y^-1+v*x^2*y^-2,123,1586,2508,5082,6203,6391,8046,8119,9313,
9444,9575,9772,10167,10231,12139,12215,12427,13344,14520,18894,20411],
[v*x^2*y^-2+v*x^3*y^-3,1340,5172,5235,5514,14158,17718],[v*x^4*y^-4+v*x^5*y^-
5,973],[v+v*x*y^-1+v*x^3*y^-3+v*x^4*y^-4+x^2*y^-1+x^3*y^-2,8247],[v+v*x*y^-1+
v*x^2*y^-2,7371],[v+2*v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+v*x^4*y^-4+x^2*y^-1+
x^3*y^-2,16334],[v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+2*v*x^4*y^-4+v*x^5*y^-5+
x^3*y^-2+x^4*y^-3,5304],[v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+2*v*x^4*y^-4+
2*v*x^5*y^-5+v*x^6*y^-6+x^3*y^-2+2*x^4*y^-3+x^5*y^-4,5112],[v+2*v*x*y^-1+
v*x^2*y^-2,2362,2426,5828,6343,6794,6923,7435,8004,9962,10550,10614,10743,
10807,12138,12402,18153,20329],[v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3,1996,2124,
2188,5186,5381,6605,9911,10103,12151,12346,13280,14024,16332,18382,18510,
18574],[v*x^2*y^-2+2*v*x^3*y^-3+v*x^4*y^-4,1082,1084,1212,9270,9276,9340,
13710,17461,17462,17466,17530,17590],[v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3+
v*x^4*y^-4+2*v*x^5*y^-5+v*x^6*y^-6,13773],[v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3+
2*v*x^4*y^-4+v*x^5*y^-5,13965],[v+2*v*x*y^-1+2*v*x^2*y^-2+v*x^3*y^-3,5444,
5807,9578,10359,17769,18096],[v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+v*x^4*y^-4,
1868,5253,5432,9527,9719,18254],[v*x^2*y^-2+2*v*x^3*y^-3+2*v*x^4*y^-4+
v*x^5*y^-5,1020,17397,17398,17741],[v+2*v*x*y^-1+2*v*x^2*y^-2+2*v*x^3*y^-3+
v*x^4*y^-4,3964,5188,5615,9322,17513,17904,20342],[v*x*y^-1+2*v*x^2*y^-2+
2*v*x^3*y^-3+2*v*x^4*y^-4+v*x^5*y^-5,5176,9399],[v+2*v*x*y^-1+2*v*x^2*y^-2+
2*v*x^3*y^-3+2*v*x^4*y^-4+v*x^5*y^-5,5167,17456],[v+2*v*x*y^-1+2*v*x^2*y^-2+
2*v*x^3*y^-3+2*v*x^4*y^-4+2*v*x^5*y^-5+v*x^6*y^-6,5103,17392],[v+3*v*x*y^-1+
4*v*x^2*y^-2+3*v*x^3*y^-3+v*x^4*y^-4+x^2*y^-1+x^3*y^-2,5819],[v*x*y^-1+
3*v*x^2*y^-2+4*v*x^3*y^-3+4*v*x^4*y^-4+3*v*x^5*y^-5+v*x^6*y^-6+x^3*y^-2+
x^4*y^-3+x^5*y^-4,5195],[v+3*v*x*y^-1+5*v*x^2*y^-2+5*v*x^3*y^-3+3*v*x^4*y^-4+
v*x^5*y^-5+x^2*y^-1+2*x^3*y^-2+x^4*y^-3,5627],[v+3*v*x*y^-1+v*x^2*y^-2,14969],
[v*x*y^-1+3*v*x^2*y^-2+3*v*x^3*y^-3+2*v*x^4*y^-4+3*v*x^5*y^-5+3*v*x^6*y^-6+
v*x^7*y^-7+x^4*y^-3+x^5*y^-4,13325,13453],[v*x*y^-1+3*v*x^2*y^-2+3*v*x^3*y^-3+
3*v*x^4*y^-4+3*v*x^5*y^-5+v*x^6*y^-6+x^4*y^-3,13581],[v+3*v*x*y^-1+3*v*x^2*y^-
2+v*x^3*y^-3,1978,6604,6667,10166],[v*x*y^-1+3*v*x^2*y^-2+3*v*x^3*y^-3+
v*x^4*y^-4,1612,1804,5125,5229,6093,6221,6285,9592,17998,18190],[v*x^2*y^-2+
3*v*x^3*y^-3+3*v*x^4*y^-4+v*x^5*y^-5,1018,9206,9212,17402],[v*x*y^-1+
3*v*x^2*y^-2+4*v*x^3*y^-3+5*v*x^4*y^-4+5*v*x^5*y^-5+4*v*x^6*y^-6+3*v*x^7*y^-7+
v*x^8*y^-8+x^4*y^-3+x^5*y^-4+x^6*y^-5,13261],[v+3*v*x*y^-1+4*v*x^2*y^-2+
3*v*x^3*y^-3+v*x^4*y^-4,5423,6092,6284,17712],[v*x*y^-1+3*v*x^2*y^-2+
4*v*x^3*y^-3+3*v*x^4*y^-4+v*x^5*y^-5,1420,5061,5323,5965,17806],[v*x^2*y^-2+
3*v*x^3*y^-3+4*v*x^4*y^-4+3*v*x^5*y^-5+v*x^6*y^-6,17421,17485],[v+3*v*x*y^-1+
4*v*x^2*y^-2+4*v*x^3*y^-3+3*v*x^4*y^-4+v*x^5*y^-5,5295,5964,17584],[v*x^2*y^-
2+3*v*x^3*y^-3+5*v*x^4*y^-4+5*v*x^5*y^-5+3*v*x^6*y^-6+v*x^7*y^-7,17357],[v+
4*v*x*y^-1+7*v*x^2*y^-2+7*v*x^3*y^-3+4*v*x^4*y^-4+v*x^5*y^-5+x^2*y^-1+
2*x^3*y^-2+x^4*y^-3,5435,5495],[v+4*v*x*y^-1+8*v*x^2*y^-2+10*v*x^3*y^-3+
8*v*x^4*y^-4+4*v*x^5*y^-5+v*x^6*y^-6+x^2*y^-1+3*x^3*y^-2+3*x^4*y^-3+x^5*y^-4,
5179,5307],[v+4*v*x*y^-1+8*v*x^2*y^-2+11*v*x^3*y^-3+11*v*x^4*y^-4+8*v*x^5*y^-
5+4*v*x^6*y^-6+v*x^7*y^-7+x^2*y^-1+3*x^3*y^-2+4*x^4*y^-3+3*x^5*y^-4+x^6*y^-5,
5115],[v*x*y^-1+4*v*x^2*y^-2+4*v*x^3*y^-3+v*x^4*y^-4,8014],[v+4*v*x*y^-1+
6*v*x^2*y^-2+4*v*x^3*y^-3+v*x^4*y^-4,6220],[v*x*y^-1+4*v*x^2*y^-2+6*v*x^3*y^-
3+4*v*x^4*y^-4+v*x^5*y^-5,5709,5901],[v+4*v*x*y^-1+7*v*x^2*y^-2+7*v*x^3*y^-3+
4*v*x^4*y^-4+v*x^5*y^-5,5708,5900],[v*x*y^-1+4*v*x^2*y^-2+7*v*x^3*y^-3+
7*v*x^4*y^-4+4*v*x^5*y^-5+v*x^6*y^-6,5517],[v+4*v*x*y^-1+7*v*x^2*y^-2+
8*v*x^3*y^-3+7*v*x^4*y^-4+4*v*x^5*y^-5+v*x^6*y^-6,5516],[2*v-x+4*v*x*y^-1+
2*v*x^2*y^-2-x^2*y^-1,6987]])*x^0*y^0*v^0;end;
f39:=function(x,y) return dec(81,
[[-1,29,84,192,362,981,1157,1160,1233,1566,1583,1593,2707,3634,3782,3875,5819,
6074,6307,6972,9778,10334,13124,13453,14036,14039,15501,15946,17309,18024,
18350,18360,19183,19850,20661,20945,21209,21463,21703,22418,22562,22572,22883,
24349,24504,24792,24848,25705,27077,27080,27804,27902,28986,29772,30342,30430,
30511,31400],[1,337,999,1548,1557,1581,1595,3279,4444,5821,6305,6317,7215,
7278,10827,14440,14441,14444,15864,15866,15944,16394,16487,16497,16996,18348,
18362,20773,20904,21269,21319,22311,22798,23739,23795,26579,26584,27480,27483,
27643,27644,27647,30347,30349,30504,30528,31149,31152,31226],
[-9*x*y^4-5*x^2*y^3-x^3*y^2-y^5,12718],[-7*x*y^4-5*x^2*y^3-x^3*y^2,12717],
[-7*x*y^4-2*x^2*y^3+2*x^3*y^2-y^5,25839],[-7*x*y^3-x^2*y^2+x^3*y-x^4,19280],
[-7*x*y^4+4*x^3*y^2,19278],[-5*x*y^3-5*x^2*y^2-2*x^3*y-y^4,6172],
[-5*x^2*y^2-2*x^3*y,6241],[-4*x*y^3-5*x^2*y^2-x^3*y+x^4-y^4,18646],
[-4*x*y^2-3*x^2*y-x^3-2*y^3,26006],[-4*x*y^3-3*x^2*y^2-x^3*y-2*y^4,6167],
[-4*x*y^3-2*x^2*y^2+x^3*y-y^4,5752],[-3*y^3,6239],[-3*x*y^3-4*x^2*y^2-x^3*y,
19609],[-3*x*y^2-3*x^2*y,19132],[-3*x*y^3-3*x^2*y^2-x^3*y,31953],
[-3*x*y^3-3*x^2*y^2-y^4,19663],[-3*x*y^3-3*x^2*y^2-x^3*y-y^4,19616],
[-3*x*y^4-3*x^2*y^3+7*x^3*y^2+3*x^4*y,19606],[-3*x*y^2-2*y^3,15402],
[-3*x*y^3-2*x^2*y^2-x^3*y-2*y^4,26003],[-3*x*y^3-2*x^2*y^2-x^3*y-y^4,5456],
[-3*x*y^2-x^2*y,17587,30790],[-3*x^2*y^2-x^3*y,6328,15422],[-3*x*y-x^2-2*y^2,
11761],[-3*x*y^3-x^2*y^2+x^3*y-y^4,11098],[-3*x*y^4-x^2*y^3+5*x^3*y^2+x^4*y,
15394],[-3*x*y^2+x^3,6240],[-3*x*y^4+x^3*y^2-y^5,31915],
[-3*x*y^4+x^2*y^3+2*x^3*y^2-2*y^5,12231],[-3*x*y^4+x^2*y^3+2*x^3*y^2+y^5,
31914],[-3*x*y^4+x^2*y^3+3*x^3*y^2-2*y^5,12232],
[-3*x*y^4+5*x^2*y^3+2*x^3*y^2-3*y^5,12235],[-2*y,5760,23253],[-2*x*y,3443,
10166,15913,18323,18636,31550],[-2*x*y^2,1961,15405,17594,30797],[-2*y^2,5782,
5797],[-2*x^2*y,5789,21643],[-2*x^2*y^2,2042,6335,15400,25370,32407],[-2*y^3,
12262],[-2*x^3*y,18643,32411],[-2*x*y^3-4*x^2*y^2-8*x^3*y-2*x^4,19605],
[-2*x^2*y^2-4*x^3*y-x^4,19634],[-2*x^2*y^2-3*x^3*y,15393],
[-2*x*y^4-3*x^2*y^3-2*x^3*y^2,5427],[-2*x*y^2-3*x^2*y-x^3,6250],
[-2*x*y^3-3*x^2*y^2-x^3*y,25364],[-2*x*y^3-3*x^2*y^2-x^3*y-y^4,18144,19604],
[-2*x*y^4-3*x^2*y^3-x^3*y^2+2*x^4*y,19603],[-2*x*y^3-3*x^2*y^2+x^3*y,15397],
[-2*x*y^4-3*x^2*y^3+2*x^3*y^2+x^4*y+y^5,12721],[-2*x*y^2-2*x^2*y,15892,31269],
[-2*x*y^2-2*y^3,6192,9979,22519],[-2*x*y^3-2*x^2*y^2,5269,9983,19285,29650],
[-2*x*y^3-2*y^4,17577,30780],[-2*x*y^4-2*x^2*y^3,6318],[-2*x^2*y^2-2*x^3*y,
5771,18145,26017],[-2*x*y^3-2*x^2*y^2-3*x^3*y,19619],
[-2*x*y^3-2*x^2*y^2-2*x^3*y-x^4,19659],[-2*x*y-2*x^2-y^2,19656],
[-2*x*y^3-2*x^2*y^2-x^3*y,17597,30800],[-2*x^2*y^3-2*x^3*y^2-x^4*y,6338],
[-2*x*y^2-2*x^2*y-x^3-y^3,25115],[-2*x*y^3-2*x^2*y^2-x^3*y-y^4,6460],
[-2*x*y^2-2*x^2*y+x^3,19651],[-2*x*y^2-2*x^2*y+x^3-y^3,18667],
[-2*x*y^3-2*x^2*y^2+x^3*y+x^4,18641],[-2*x*y^4-2*x^2*y^3+3*x^3*y^2+x^4*y,
15390],[-2*x-y,19140],[-2*x*y-y^2,6198],[-2*x*y^2-x^2*y,6104,6348,17615,25389,
30818,31298],[-2*x*y^2-y^3,1717,6193,6208,19208,19213,32458],
[-2*x*y^3-x^2*y^2,6075,6320,6347,15392],[-2*x*y^3-y^4,31975,32439],
[-2*x^2*y-x^3,6266,30476],[-2*x^2*y^2-x^3*y,5852,6356,17435,19363,31306,
31917],[-2*x*y-x^2-2*y^2,21632],[-2*x*y^2-x^2*y-2*y^3,22522],
[-2*x*y^3-x^3*y-2*y^4,32402],[-2*x*y-x^2-y^2,2838,10789,11351,11356,11756,
16041,18498,22525,26007,30467,30472,31026],[-2*x*y^2-x^2*y-y^3,3809,3821,3868,
5184,5185,5188,5843,5848,15887,17426,17431,18497,18682,19617,19666,24068,
24073,25445,25450,30294,30295],[-2*x*y^3-x^2*y^2-y^4,6401,6413,6438],
[-2*x*y^4-x^2*y^3-y^5,26002],[-2*x*y^2-x^2*y-x^3-y^3,5457],
[-2*x*y^3-x^2*y^2-x^4+2*y^4,6185],[-2*x*y^2-x^2*y+x^3,19127],
[-2*x*y^2-x^2*y+y^3,5790,31972],[-2*x^2*y-x^3+y^3,11765],
[-2*x^2*y^2-x^3*y+x^4,31286],[-2*x^2*y^2-x^3*y+y^4,9964],
[-2*x^2*y^3-x^3*y^2+x^4*y,25373],[-2*x*y^2-x^2*y+x^3-y^3,19643],
[-2*x*y^3-x^2*y^2+3*x^3*y+x^4,16933],[-2*x*y^4-x^2*y^3+4*x^3*y^2+x^4*y,19525],
[-2*x*y^2+x^2*y,6254,15893],[-2*x*y^2+y^3,15886],[-2*x*y^3+y^4,31916],
[-2*x^2*y^2+x^3*y,25391],[-2*x*y^2+x^2*y-y^3,19614],[-2*x^2*y^3+3*x^4*y+x^5,
18650],[-2*x*y^3+3*x^2*y^2+x^3*y-y^4,5755],[-2*x*y^4+3*x^3*y^2+2*x^4*y-y^5,
25110],[-x^-2*y,8449],[-x^-1,9463,11550,14764,18128,22983,30048],[-x^-1*y,
7140,7386,7957,8367,10030,10835,11751,11807,12541,16845],[-x^-1*y^2,8679,8682,
11778,11795],[-x,907,2965,3446,3456,4248,4249,4348,4809,4814,5352,5415,5805,
5978,6279,6302,8046,10179,10254,10809,11141,13878,13945,14267,14272,14847,
15415,15468,15918,16006,16973,16983,17850,17937,18342,18477,18700,19007,19009,
19122,19158,19172,19178,19185,19187,19407,19424,19431,19546,19670,20739,21568,
21572,23776,23782,24126,24128,24827,24837,24846,24850,25278,25926,27148,28588,
28591,29109,31311,31314,31553,31563,32064,32199,32244],[-y,436,495,577,1002,
1003,1147,1150,1574,1580,1589,1603,1710,1719,1743,1757,1988,1998,3381,3534,
3700,3834,4113,4383,4430,4649,5310,5313,5769,5798,5807,5817,5887,6226,6243,
6264,6285,6306,6467,6562,6836,7324,7468,7706,7711,8782,8967,9105,9514,9932,
9969,10019,10025,10032,10034,10909,11464,11540,11715,11782,11850,11879,11881,
12470,12498,12516,12530,12536,12545,12548,12684,14026,14029,14192,14356,14421,
14425,14428,14456,14607,14624,14634,15011,15882,15903,15945,15947,16207,16210,
16217,16479,16480,16495,16651,16740,17083,17177,17202,17203,17213,17215,17221,
17223,17232,17236,17470,17621,17631,17650,17778,18213,18215,18277,18321,18325,
18336,18341,18697,19262,19768,19964,20660,20828,20833,20944,21491,21680,21682,
22144,22533,22537,22548,22559,22561,22567,22568,22569,22578,22582,23309,23376,
23421,23424,23428,24021,24024,24263,24273,24819,25503,25590,26080,26657,26825,
27039,27067,27070,27313,27471,27624,27628,27631,27659,27723,27726,28133,28440,
28497,28922,28925,28947,28975,29691,29694,29832,29861,29863,30125,30492,30493,
30514,30695,30824,30834,30853,31486,31832,31982,31994,32479,32721],[-x*y,1542,
1556,1723,1724,1727,2069,2079,2199,2837,2945,2973,3199,3407,3417,3421,3432,
3433,3445,3451,3452,3453,3462,3466,3929,4334,4343,4344,4351,4356,4818,5273,
5351,5354,5514,5792,6105,6273,6289,6362,6372,6391,7618,7696,7715,8678,8994,
9023,10014,10026,10130,10140,10144,10155,10156,10168,10174,10175,10176,10185,
10189,10249,10266,10786,10805,10971,10972,10987,11132,11147,11342,11588,11614,
11632,11758,11848,12275,12496,12525,12534,12537,12953,13936,15434,15437,15444,
15463,15754,15928,15986,16014,16040,16959,16960,16972,16978,16979,17822,17849,
17859,17877,17933,18156,18175,18185,18190,18195,18204,18208,18309,18313,18338,
18664,18692,18699,18701,18716,18719,18906,18995,19004,19005,19012,19017,19153,
19162,19168,19174,19175,19205,19371,19565,19568,19575,19620,19649,20737,20837,
20999,21559,21562,21755,22275,22528,22535,22718,23259,23278,23284,23288,23293,
23298,23307,23311,23790,24115,24179,24410,24825,25157,25277,25280,25422,25424,
25887,25904,25911,25916,27139,27227,27232,27461,27466,27473,27732,27760,28033,
28036,28043,28200,28203,28207,28565,28567,29118,29192,29626,29654,29830,30332,
31025,31309,31514,31524,31528,31539,31540,31552,31558,31559,31560,31569,31573,
31958,32053,32112,32113,32128,32217,32243,32444,32688,32691],[-x*y^2,1951,
1982,2040,2044,2055,2060,2089,3404,3431,3441,3459,3927,3969,4332,5348,5513,
6077,6088,6091,6107,6132,6168,6215,6269,6323,6333,6337,6349,6359,6367,6368,
6382,6457,8751,8992,10001,10002,10127,10154,10164,10182,12081,12513,12665,
12674,12693,12777,12781,12891,12982,12986,14583,14597,15169,15173,15409,15420,
15421,15439,15440,16958,16986,17042,17212,17584,17609,17820,18173,18649,18663,
18688,18993,19286,19551,19552,19570,19571,20899,21754,22558,23276,24177,24236,
24381,25141,25159,25274,25372,25411,25851,27459,27463,27713,27731,27741,28281,
28284,28542,28543,28553,28561,28562,28563,28570,28575,30058,30787,30812,31511,
31538,31548,31566,31964,32034,32240,32415,32686],[-x*y^3,1964,2064,3406,5305,
5429,5510,6379,6416,8749,10129,11137,12746,12756,12774,12973,13609,15160,
15419,15447,19316,19339,19550,19578,24016,25139,25167,28551,29686,31513,31921,
32238,32656],[-x*y^4,5508],[-x^2,911,1010,1552,2313,2316,4250,5059,5921,8284,
8285,8288,10811,11619,14276,15435,16965,18194,19138,19167,19176,19179,22474,
23736,24799,25395,26208,26211,28518,32250],[-y^2,1001,1578,1713,1732,1738,
1747,1753,1760,1959,1963,1974,1979,1985,1994,2008,4386,4405,4411,4420,4433,
5308,5325,5594,5597,5868,5869,5890,6225,6252,6256,6272,6297,6300,6426,6446,
8680,8699,8781,10000,10015,10021,10022,11128,11138,11148,11157,11161,11867,
11876,11877,11884,11889,12249,12278,12511,12520,12526,12532,12533,12765,12779,
13007,13047,13050,13075,14419,14438,14615,14621,14630,14644,15194,15895,15934,
15939,17174,17201,17211,17229,17451,17452,17473,17582,17592,17596,17608,17618,
17626,17627,17641,18202,18345,18473,18476,18639,18801,18848,19233,19234,19249,
19629,20657,21657,21658,21668,21676,21677,21678,21685,21690,22520,22547,22557,
22575,23280,24019,24036,24249,24254,24260,24269,24283,24953,24978,24979,25034,
25037,25116,25362,25492,26022,27622,27641,28946,28956,29689,29706,29849,29858,
29859,29866,29871,30063,30495,30785,30795,30799,30811,30821,30829,30830,30844,
31923,31961,31980,31986,31988,31991,32421,32690,32717],[-x^2*y,2061,2194,2311,
2328,2332,3412,3419,3949,4354,4381,5520,5974,6459,8022,8029,8275,8278,8687,
8761,9031,9976,9980,10135,10142,10973,11100,11114,11615,11936,11964,12487,
14593,14834,14839,15436,18642,18876,18905,19015,19155,19314,19315,19361,19366,
19397,19557,20659,21638,21730,21734,21873,21880,23260,24199,24786,24826,25390,
25412,26206,26223,26227,27217,27236,29027,29055,31304,31519,31526,32114,32436,
32437,32452],[-x^2*y^2,1702,2028,2032,2057,2188,2329,3442,6115,6325,6350,8788,
10003,10165,10246,11908,12076,12263,12640,12730,12886,12971,15158,17050,18184,
18799,19217,19291,19295,19553,21721,23287,25841,25846,25877,26224,27722,28282,
28301,28526,28999,31549,31931],[-x^2*y^3,12073,13081],[-x^3,8032,11621,16932,
18147,21883,32245],[-y^3,1730,1983,4403,5591,5871,11865,12127,12295,13006,
13046,13072,13074,14619,17454,17638,18470,18804,18823,18829,18838,18851,20655,
21666,24258,24950,24977,25031,26020,29847,30841,31960,32655],[-x^3*y,1741,
5459,5466,5515,8023,11947,14824,14843,18913,19524,21719,21874,25113,28280,
29038,31674,31703,32242],[-x^3*y^2,2308,5428,5512,13061,26203],[-x^4,18712],
[-y^4,5589,12071,12108,12749,18468,18821,21628,24948,25029],[-x^4*y,28289,
31711],[-y^5,12069],[-x*y^4-4*x^2*y^3+2*x^4*y,19602],[-x*y^3-3*x^2*y^2,18148],
[-x*y^3-3*y^4,12260],[-x^3*y^2-3*x^4*y,15410],[-x*y^4-3*x^3*y^2-6*x^4*y-2*x^5,
19622],[-x*y^4-3*x^2*y^3-3*x^3*y^2-x^4*y,31934],[-x*y^3-3*x^2*y^2-2*x^3*y,
4394,17030],[-x*y^4-3*x^2*y^3-2*x^3*y^2,18812],[-x^2*y^2-3*x^3*y-2*x^4,25616],
[-x^2*y^3-3*x^3*y^2-2*x^4*y,26021],[-x*y^3-3*x^2*y^2-x^3*y,19359,31924,31952],
[-x*y^3-3*x^2*y^2+x^3*y+x^4,23251],[-x*y^3-3*x^2*y^2+x^4+y^4,12475],
[-x*y^3-3*x^2*y^2+x^3*y+x^4+2*y^4,12478],[-x^-1*y^3-2*y^2,11784],[-x*y-2*y^2,
17607,19343,28919,30810],[-x*y^2-2*x^2*y,4412,15889,24790],[-x*y^2-2*y^3,
12261,17579,17606,30782,30809],[-x*y^3-2*x^2*y^2,18830,19360,32410,32414,
32417],[-x*y^3-2*y^4,12288],[-x*y^4-2*x^2*y^3,31954],[-x^2*y-2*x^3,19129],
[-x^2*y^2-2*x^3*y,15428],[-x^3*y^2-2*x^4*y,32420],
[-x*y^3-2*x^2*y^2-5*x^3*y-2*x^4,19640],[-x*y^3-2*x^2*y^2-4*x^3*y-x^4+y^4,
19612],[-x^2*y^3-2*x^3*y^2-3*x^4*y-x^5,19642],[-x*y^3-2*x^2*y^2-2*x^3*y-3*y^4,
6237],[-x*y-2*x^2-y^2,19646],[-x*y^2-2*x^2*y-x^3,3904,5812,17921,18326,24154,
29180],[-x*y^3-2*x^2*y^2-x^3*y,6169,20432,24077,25454,28451,32161],
[-x*y^4-2*x^2*y^3-x^3*y^2,28513],[-x^2*y^2-2*x^3*y-x^4,18488,19289,19294,
31995],[-x^2*y^3-2*x^3*y^2-x^4*y,5447],[-x*y^2-2*x^2*y+x^3-y^3,19652],
[-1-x^-1*y,5229,5232,10779,11798,11800],[-x^-1*y^2-y,5227,5244,10806,11505,
11531,11534,11559,11786,11796,11803,11808],[-x-y,344,3851,3861,4952,4957,
10810,11151,11376,11377,16141,16142,16145,21633,22288,26077,31469],[-x*y-x^2,
4223,4228,4781,4786,4793,4961,5815,10784,17904,17912,17939,18187,18193,18317,
18344,19124,19675,21229,21232,21239,24847,25925,29081,29086,29093,29163,29171,
29198,29254,29257,31115,31120,31489,32253,32257],[-x*y-y^2,1541,1553,1600,
2842,2849,2873,3837,3842,3848,3857,3871,3982,5436,5794,5800,5802,6221,6443,
6453,8683,9978,9982,11127,11140,11146,11506,11542,11806,12285,15912,16045,
16052,16076,16132,16454,16459,17233,18149,18308,18320,18499,19946,22279,22532,
22579,23252,24093,24094,24109,25470,25471,25486,26025,26054,26056,30224,30229,
30297,30323,30326,30351,31030,31037,31061,31467,31968,31987,32406,32424,32453,
32455,32469],[-x*y^2-x^2*y,2916,2917,2920,3463,3901,5278,5450,5453,5476,5486,
5523,5527,10186,10946,10951,11111,11837,11842,11910,11939,13854,15312,15319,
15957,15958,15961,16931,16943,17013,17020,17021,17026,17048,17092,17580,18201,
18205,19362,19388,19391,19416,19632,20450,23263,23308,23734,24095,24151,25156,
25405,25472,25922,28442,28469,29001,29030,29659,29819,29824,30233,30298,30334,
30783,31570,32087,32092,32164,32171],[-x*y^2-y^3,1946,1958,2005,2836,2855,
3846,3973,4390,5224,5439,5458,5808,6251,6429,6434,6449,11126,11154,11158,
12084,12088,12639,12668,12729,14582,14594,14641,15193,15878,16039,16058,17172,
17173,17176,17616,17634,18146,18183,19313,22518,24221,24233,24280,26031,26032,
26042,26050,26051,26052,26059,26064,30819,30837,31024,31043,31944,31945,31955,
31957,31963,31965,31978,32419,32450,32463,32689],[-x*y^3-x^2*y^2,2027,2039,
2086,3402,3403,4375,5265,5266,5791,6163,6357,6375,10125,10126,12079,12086,
12245,12637,12676,12724,12778,12976,15163,15404,17617,19523,19535,20173,23976,
23977,23980,25355,25842,25868,25871,25896,26011,26018,29646,29647,30820,31509,
31510,32158],[-x*y^3-x^4,5346,25272],[-x*y^3-y^4,6188,12238,12292,17578,18808,
19292,26040,30781,31971],[-x*y^4-x^2*y^3,5431,6319,12757,18793],[-x^2-y^2,
6245],[-x^2*y-x^3,992,3899,4232,4304,4309,5038,5602,5920,10793,11586,11594,
13864,18506,18965,18970,20415,22453,23507,24149,25042,25599,25606,25607,25612,
25634,28921,31124,31844,31849,31997,32170,32248,32255],[-x^2*y-y^3,4384,18676,
19637],[-x^2*y^2-x^3*y,2036,2063,5437,5465,5518,5525,5593,5914,5917,6321,
10206,10207,10210,10955,13855,19399,20170,21724,25033,25121,25126,25369,28285,
31267,31682,31687,32096],[-x^2*y^2-y^4,18640,18802],[-x^2*y^3-x^3*y^2,6358,
25879],[-x^3*y-x^4,5350,11603,25276,31853,31999],[-x^3*y^2-x^4*y,2269,2272,
26164,26167,31691],[-x^-1*y^3-x*y-2*y^2,11502,11503],[-x*y^2-x^2*y-2*y^3,
21629],[-x*y^3-x^2*y^2-2*x^3*y-x^4-y^4,19641],[-x*y-x^2-y^2,18672,18686],
[-x*y^2-x^2*y-x^3,5035,18693,22450,28517],[-x*y^2-x^2*y-y^3,6164,6440,6463,
9973,18689,19290,19621],[-x*y^3-x^2*y^2-x^3*y,5484,26012,28514],
[-x*y^3-x^2*y^2-y^4,12233],[-x^2*y^3-x^3*y^2-x^4*y,2045,5467,15430],
[-x*y^2-x^2*y-x^3-2*y^3,28917],[-x*y^2-x^2*y+x^3,16936,19645,31277],
[-x*y^2-x^2*y+y^3,19633],[-x*y^3-x^2*y^2+x^3*y,19528],[-x*y^3-x^2*y^2+y^4,
19631],[-x^2*y-x^3+y^3,19283],[-x*y^3-x^2*y^2+x^3*y+x^4,25920],
[-x*y^4-x^2*y^3+x^3*y^2+x^4*y,19318],[-x*y^3-x^2*y^2+2*x^3*y+x^4,16929],
[-x*y^4-x^2*y^3+2*x^3*y^2+x^4*y+y^5,19282],[-x*y^4-x^2*y^3+3*x^3*y^2+x^4*y,
19521],[-x+y,5795,18343],[-x*y+x^2,16970,16989,16993,25397],[-x*y+y^2,1549,
5786,5801,5809,6249,6274,10004,10023,10027,12515,12538,15888,15935,18316,
19202,25359],[-x*y^2+x^2*y,1714,2066,2075,12281,15431,15454,15879,19562,19585,
25388,25403],[-x*y^2+x^3,3824,5592,7210,16990,18666,19653,25032,31282],
[-x*y^2+y^3,1954,12266,12758,14590,31919],[-x*y^3+x^2*y^2,1705,12755,28541],
[-x*y^3+x^3*y,12636,12656,15451,19582,25367,26731,30052],[-x*y^4+x^2*y^3,
12271,32647],[-x^2+y^2,18322,19331,19333],[-x^2*y+y^3,5765,6253,10024,12267,
12535,19336,31295],[-x^2*y^2+x^3*y,15407,19534],[-x^2*y^2+x^4,18874],
[-x^2*y^2+y^4,19317],[-x^2*y^3+x^4*y,12880],[-x*y^2+x^2*y-2*y^3,12280,12490],
[-x^-1*y^4+x*y^2-y^3,12243],[-x*y^2+x^2*y-y^3,19533,32430,32451],
[-x*y^3+x^3*y-y^4,19310],[-x*y^4+x^2*y^3-x^4*y,6176],[-x*y^2+x^2*y+x^3,30314],
[-x*y^3+x^2*y^2+x^3*y,11097,30055],[-x*y^4+x^2*y^3+x^3*y^2,6322],
[-x^2*y^2+x^3*y+x^4,2284,26179],[-x^2*y^3+x^3*y^2+x^4*y,12883],
[-x^3*y^2+x^4*y+x^5,2288,26183],[-x*y^4+x^2*y^3+x^3*y^2-2*x^4*y-x^5,19298],
[-x*y^3+x^2*y^2+x^3*y-y^4,19281,25112],[-x*y^3+x^2*y^2+x^3*y+y^4,5751],
[-x*y^4+x^2*y^3+2*x^3*y^2,12737],[-x*y^4+x^2*y^3+3*x^3*y^2+x^4*y,15391,19522],
[-x*y^4+2*x^3*y^2,28516],[-x*y^2+2*x^2*y-2*y^3,32405],[-x*y^2+2*x^2*y+x^3,
19126],[-x*y^3+2*x^2*y^2+x^3*y,6166,6194],[-x*y^3+2*x^3*y+x^4,16930],
[-x^2*y^2+2*x^3*y+x^4,18668,19379],[-x^2*y^3+2*x^3*y^2+x^4*y,25859],
[-x*y^3+2*x^2*y^2+x^3*y-y^4,31943],[-x*y^3+2*x^3*y+x^4-y^4,23247],
[-x*y^2+2*x^2*y+x^3+y^3,6247],[-x*y^3+3*x^2*y^2+x^3*y-y^4,11101],
[-x*y^4+4*x^2*y^3+2*x^3*y^2-y^5,31918],[x^-2*y,8692],[x^-1,4986,4989,11555,
11557],[x^-1*y,4984,5001,7707,8688,8691,11543,11552,11553,11560,11565,17088,
17655,30129,30858],[x^-1*y^2,11541,12298,12985],[x,735,817,1066,1312,1394,
1640,1804,1886,2132,2193,2516,2649,3034,3116,4174,4217,4242,4243,4253,4255,
4261,4263,4272,4276,4341,4500,4756,4901,5153,5248,5793,6291,6310,6642,6725,
6889,7652,7868,8028,8201,9156,9265,9324,9594,9677,9841,10104,10497,10579,
10652,10755,10833,10836,11069,11139,11207,12219,12383,12480,12543,12629,12870,
13204,13368,13532,13778,13970,14106,14512,14676,15090,15251,15469,15664,15930,
16338,16891,16935,16985,16991,16998,17000,17397,17540,18206,18349,18355,18357,
18366,18369,18370,18495,18616,18942,19002,19108,19160,19170,19189,19383,19412,
19414,19672,19683,20008,20175,20257,20339,20421,20503,20585,20910,21702,21787,
21811,21879,22061,22224,22523,22635,23209,23316,23318,23616,23770,23865,23947,
24445,24685,24822,24931,25421,25440,25641,25644,25830,26244,26326,26408,26490,
26588,26897,27173,27385,27553,28373,28622,28704,28868,29442,29524,30180,30918,
31000,31319,31321,31599,31902,32285,32394,32535,32792],[y,328,653,656,678,679,
902,1137,1141,1144,1148,1172,1551,1570,1576,1585,1591,1598,1722,1728,1745,
1755,1968,1986,2000,2050,2296,2348,2894,3943,4005,4264,4346,4401,4418,4428,
5028,5031,5056,5084,5338,5494,5598,5655,5757,5778,5820,5822,5880,5904,6120,
6130,6150,6224,6232,6236,6284,6292,6293,6303,6311,6314,6396,6478,7214,7217,
7627,7697,7702,7709,8766,8857,9021,9049,10007,10010,10017,10169,10251,10803,
11159,11166,11168,11399,11563,11788,11794,11874,11891,11898,11903,11916,11941,
11973,12137,12301,12518,12528,12547,12689,12691,12711,12793,12957,13039,13121,
13614,14016,14020,14023,14027,14051,14431,14434,14589,14598,14622,14636,14844,
15226,15318,15418,15457,15853,15885,15894,15923,15932,16097,16156,16448,16458,
16462,16473,16474,16486,16492,16493,16494,16503,16507,16976,17052,17055,17058,
17121,17126,17208,17209,17224,17463,17487,17619,17622,17632,17633,17642,17878,
18352,18358,18365,18534,18780,18862,19190,19241,19251,19272,19354,19436,19588,
19669,19682,19939,20667,20824,20831,20903,21067,21070,21077,21569,21675,21692,
21704,21733,21897,22307,22443,22446,22471,22499,22554,22555,22570,23766,23783,
24029,24193,24261,24275,24439,24849,25013,25038,25095,25177,25341,25423,25488,
25669,25997,26029,26079,26191,26243,26736,26799,27057,27061,27064,27068,27092,
27228,27634,27637,27720,28294,28458,28760,28763,28785,28786,28950,29007,29032,
29064,29114,29196,29278,29719,29856,29873,29880,29885,30057,30120,30262,30335,
30344,30345,30352,30357,30461,30487,30499,30505,30516,30520,30822,30825,30835,
30836,30845,31082,31147,31164,31328,31492,31738,31984,32066,32428,32478,
32722],[x*y,244,975,982,1473,1759,1966,2067,2081,2192,2349,2432,2787,3438,
3439,3454,4214,4241,4251,4269,4582,5063,5082,5086,5555,5714,5803,5918,5943,
5944,6162,6204,6267,6278,6280,6286,6360,6363,6373,6374,6383,6554,7052,8049,
8050,9999,10161,10162,10177,10414,10940,10965,10966,10976,10978,10984,10986,
10995,10999,11109,11143,11156,11298,11641,11965,12273,12287,12510,12786,12885,
12948,13284,13620,13693,14835,15396,15411,15432,15446,15452,15459,15461,15581,
15917,16453,16460,16584,16966,16981,16987,16988,17018,17210,17585,17599,17709,
18177,18179,18180,18196,18648,18677,18878,18881,18903,18931,19131,19135,19146,
19147,19165,19166,19334,19400,19409,19410,19417,19422,19527,19542,19545,19563,
19577,19583,19590,19592,19636,19664,19671,19673,20090,20662,21549,21553,21556,
21584,21635,21653,21691,21729,21900,21901,22025,22478,22497,22501,23043,23144,
23282,23283,23297,23299,23305,23709,24738,24956,25179,25181,25209,25371,25400,
25442,25639,25656,25863,25892,25894,25984,26046,26103,27218,27223,27230,27470,
27475,27964,28290,28293,28560,28577,28589,28920,28949,29056,29342,29932,30355,
30459,30488,30600,30750,30788,30802,31307,31317,31329,31457,31545,31546,31561,
31979,32081,32106,32107,32117,32119,32125,32127,32136,32140,32284,32445],
[x*y^2,1708,2071,2077,2084,2189,2273,2298,2299,2305,2875,4377,5061,5554,5835,
5864,5915,5942,6171,6175,6191,6354,6355,6364,6370,6422,8048,8667,8671,8865,
8866,10937,10964,10974,10992,11107,11135,11380,11828,11833,11864,11909,11946,
12290,12753,12884,12972,12975,13003,13020,15207,15427,15442,15448,16078,16483,
17418,17447,18902,18912,19145,19173,19204,19207,19211,19214,19324,19398,19547,
19558,19573,19579,19580,19635,19660,20656,21547,21566,21665,21684,21899,22476,
25009,25168,25413,25880,25889,25890,25897,25902,25981,26044,26168,26193,26194,
26200,27216,27220,27709,27715,27716,28434,29000,29037,29810,29815,29846,31063,
31144,31428,32078,32105,32115,32133],[x*y^3,1948,2187,2270,5913,11907,12881,
12963,12998,15150,15185,15916,18795,19237,24223,25878,26014,26165,27706,28998,
32646,32681],[x*y^4,12070],[x^2,985,1577,7540,7786,8117,8527,11624,11643,
11647,16980,16992,17823,17852,18181,19152,19381,19485,19667,20905,23746,24789,
24824,25164,25407,25604,28587,29244,32162,32475],[y^2,650,677,1135,1154,1568,
1720,1736,1742,1751,1765,1981,1990,1996,2003,2342,3939,4001,4409,4415,4424,
4434,4437,4438,4981,5055,5756,5759,5770,5814,5837,5863,5875,5881,5892,5896,
6118,6126,6133,6203,6211,6222,6230,6296,6455,7211,7695,7699,8763,8778,8806,
8903,8993,9020,9030,9048,9993,9994,10006,10012,10013,11130,11133,11155,11838,
12078,12103,12116,12258,12265,12293,12300,12302,12493,12504,12505,12523,12524,
12687,12694,12699,12770,12772,12981,13115,13613,14014,14033,14592,14611,14617,
14626,14632,14639,15168,15834,16445,16472,16482,16500,17053,17056,17070,17130,
17420,17446,17458,17464,17475,17479,17613,17614,17623,17629,18657,18819,18836,
18846,19212,19216,19228,19238,19240,19246,19247,19248,19257,19261,19611,19930,
20818,20821,20900,21639,22470,23509,24012,24189,24231,24256,24265,24271,24278,
25415,25475,25498,26048,26075,26237,26735,26738,27055,27074,27714,27717,28436,
28439,28757,28784,29820,30056,30242,30270,30333,30517,30816,30817,30826,30832,
31296,31920,31938,31967,31983,32447,32474,32649,32664,32712],[x^2*y,976,2048,
2068,2074,2076,2085,2088,4252,4331,6182,6326,6340,8265,8269,8272,8300,9966,
10777,11110,12023,12638,12647,12652,13615,14618,14825,14830,14837,14924,15398,
15412,15413,15441,15453,16967,16968,17821,17901,18161,18182,18306,18448,18992,
19338,19342,19536,19564,19572,19584,20902,21720,21723,21751,21768,23250,23264,
23285,23737,24583,25140,25151,25170,25174,25861,26009,27460,27479,27705,28520,
28538,28576,28957,29160,29242,31279,31327,31701,32423,32460,32608],[x^2*y^2,
2306,4378,5062,6277,6406,6428,8263,8282,8867,10975,12107,12733,13044,13070,
13073,13098,13612,14823,14827,15429,19560,21711,21746,22477,25148,25392,25636,
26039,26201,28523,28550,28569,31700,31710,31728,32116,32239,32438,32650],
[x^2*y^3,5509,6399,12109,12960,12964,13000,13041,13042,15147,15151,15187,
18796,25393],[x^3,5025,5618,8057,8609,11596,16942,16946,17860,18157,21908,
22440,25058],[y^3,648,4413,5893,6114,6202,8750,8777,8787,8991,9992,10020,
12100,12102,12115,12250,12264,12289,12503,12531,12675,12748,12766,12767,12768,
12780,13099,13610,14609,15166,16447,17476,18827,18833,18842,18852,18855,18856,
19236,19254,19258,19308,19309,19319,19328,19341,20898,24096,24229,25386,26732,
28433,28755,30053,31977,32412,32648,32662],[x^3*y,2191,5023,11583,16969,18662,
19538,22438,25123,27742,28519],[x^3*y^2,2025,19561,21708,21712,21748,25150,
28269,28273],[y^4,8748,13080,13608,18831,28431,32645],[y^5,32643],
[x*y^3-3*x^2*y^2-x^3*y+2*y^4,9967],[x*y-2*y^2,6242],[x*y^3-2*x^2*y^2,12234],
[x*y^3-2*x^3*y,19532],[x*y^3-2*x^2*y^2-x^3*y,11846,29828],
[x*y^4-2*x^3*y^2-x^4*y,2268,26163],[x*y^3-2*x^2*y^2-x^3*y+y^4,9963],
[x^-1*y^3-x*y,9975],[x-y,6281,15920,18150,18347,18356],[x*y-x^2,19157,19180],
[x*y-y^2,5763,5810,6287,6301,15911,15926],[x*y^2-x^2*y,1543,1739,2062,4391,
15426,19607,25365],[x*y^2-x^3,16940,18673,19177,28918],[x*y^2-y^3,6298,12277,
15915,18661,21656,25384,31926],[x*y^3-x^2*y^2,2035,12248,12269,14584,18809,
25363],[x*y^3-x^3*y,2041,2297,6238,17011,23248,26192,32413],[x*y^4-x^3*y^2,
12980,15167],[x^2-y^2,5781,16941,19326,19350],[x^2*y-y^3,9974,12272,12274,
15890,25383,32431,32441,32449],[x^2*y^2-x^3*y,19559,25366,28528],[x^2*y^2-x^4,
5347,25273],[x^2*y^2-y^4,12720,26030],[x^2*y^3-x^3*y^2,18670],[x^2*y^3-x^4*y,
21728,25130,28532,32401],[x*y^3-x^2*y^2-3*x^3*y,32416],
[x*y^3-x^2*y^2-3*x^3*y-x^4,19117],[x*y^3-x^2*y^2-2*x^3*y,21647],
[x^2*y^3-x^3*y^2-2*x^4*y-x^5,31672],[x*y^2-x^2*y-x^3,18681,18690],
[x*y^3-x^2*y^2-x^3*y,1721,15876],[x^2*y^2-x^3*y-x^4,4313,18974],
[x*y^2-x^2*y-x^3+y^3,24059],[x*y^2-x^2*y+y^3,9970],[x*y^3-x^2*y^2+y^4,19198],
[x*y^3-x^3*y+y^4,31266],[1+x^-1*y,11793,16222,18371],[x^-1*y^2+y,11355],
[x^-1*y^3+y^2,12486],[x+y,246,738,820,1476,2214,2378,2460,2542,2624,2788,2858,
2861,2952,3280,3444,3849,3933,3936,4182,4510,4592,4838,4920,5166,5412,5576,
5740,5986,6560,6643,7053,7545,7791,7873,8037,8119,8283,8529,8611,9185,9267,
9349,9595,10087,10415,10661,10743,10816,10822,10824,10989,11071,11153,11235,
11317,11513,11518,11645,12055,12875,13286,13696,13860,13942,14270,14516,14680,
14926,15254,15582,15992,16061,16064,16320,16402,16566,16894,17386,17550,17714,
17960,18452,18698,18944,19026,19518,19600,20011,20093,20749,20752,20913,20917,
21268,21323,21699,21815,21979,22225,22278,22286,22313,22799,23045,23127,23291,
23537,23619,23701,24111,24183,24186,24422,24603,24767,25259,25833,25915,25992,
25995,26161,26900,27146,27392,27556,27966,28048,28212,28376,28540,29360,29934,
30075,30486,30590,30754,31046,31049,31246,31574,31656,32148,32230,32312,32558,
32640,32804],[x*y+x^2,2927,2932,4273,4737,5245,6723,7634,12903,13952,15797,
15940,15968,15973,16944,16948,17914,18367,20908,20915,23749,24442,24797,25154,
26076,27155,28584,29173,30073,30305,30310,32180,32183],[x*y+y^2,1555,2848,
2851,3819,3844,3853,3859,3866,3931,3972,3980,4007,4941,4942,4945,5454,5787,
5862,6201,6229,6268,6288,6441,6724,10775,10802,10830,11149,11350,11783,12479,
13881,13882,15339,15340,15906,15919,15925,15927,16051,16054,16126,16129,16157,
16504,17093,17098,17105,17183,17188,17445,19302,23502,23505,24062,24087,24088,
24098,24100,24106,24108,24117,24121,24181,24420,25464,25465,25477,25483,25485,
25494,26066,26078,30458,30513,31036,31039,31324,31956,32465,32477,32667],
[x*y^2+x^2*y,1540,3413,3418,3891,3917,3926,4212,4213,4216,4296,4322,4325,4350,
4387,4738,5060,5083,5268,5275,5276,5281,5303,5462,5463,10136,10141,10996,
11341,11622,12282,17012,17017,17023,17024,17192,17590,17905,18151,18155,18158,
18957,18983,18986,19011,19300,19321,19540,19544,19625,19628,20425,21727,22475,
22498,22538,23254,23258,23261,23992,24141,24167,24176,24955,25125,25145,25160,
25394,25396,25402,26027,26065,28444,29164,29649,29656,29657,29662,29684,30062,
30067,30496,30793,31104,31105,31108,31520,31525,31936,32137,32168,32173,32426,
32443,32464],[x*y^2+y^3,1703,1715,1740,1762,1960,4376,4388,4435,5834,5889,
6216,6411,6436,6451,6458,8668,9965,9977,11108,11829,11855,11858,11883,12283,
12488,12979,13880,14596,15338,15933,16139,16443,16444,17417,17472,17588,17593,
19329,21630,21659,24086,24114,24235,25491,25495,26013,26047,29811,29837,29840,
29865,30213,30214,30217,30791,30796,31268,31950,31951,31966,32446],
[x*y^3+x^2*y^2,1945,3811,5872,6170,6329,6334,10935,10936,10939,11117,11866,
12967,12970,12977,14581,15154,15157,15164,17010,17455,18637,18805,20416,21667,
24097,24220,24949,24952,25149,25410,25474,26058,28435,28515,28544,29848,32076,
32077,32080,32653,32660],[x*y^3+x^3*y,18647,25356],[x*y^3+y^4,6213,12719,
18669,18794,18806,18853,19201],[x*y^4+x^2*y^3,6403,12961,15148],[x*y^4+x^4*y,
12879],[x^2*y+x^3,1559,2936,3814,4780,5627,7213,10217,10222,11644,12901,13889,
15799,15977,18160,18481,18713,18718,19370,19375,19662,24806,25067,25609,29080,
32167,32195],[x^2*y+y^3,18665,19648],[x^2*y^2+x^3*y,3892,4297,4333,5440,6331,
11587,12514,12890,12895,14600,18164,18472,18711,18715,18958,18994,19335,21715,
21718,21725,23267,23996,24142,25120,25171,25596,25597,25850,25855,25921,26734,
30071,31678,31685,32659],[x^2*y^3+x^3*y^2,12089,21709,28270,28552,31675],
[x^3+y^3,7209],[x^3*y+x^4,2279,8039,10226,18877,19156,21890,26174,31837],
[x^3*y+y^4,26730,30051],[x^3*y^2+x^4*y,12899],
[x*y^4+x^2*y^3-2*x^3*y^2-3*x^4*y,18631],[x*y+x^2-y^2,11522],[x*y^2+x^2*y-x^3,
19638],[x*y^2+x^2*y-y^3,12291],[x*y^3+x^2*y^2-x^3*y,31270],[x*y^3+x^2*y^2-y^4,
17581,25382,30784],[x*y^3+x^2*y^2-x^3*y-x^4,3908,24158],
[x*y^4+x^2*y^3-x^4*y-y^5,32404],[x*y^2+x^2*y-x^3+y^3,18680],[x*y+x^2+y^2,
16122,18674,19658],[x*y^2+x^2*y+x^3,16939,19610,19665,25417],[x*y^2+x^2*y+y^3,
11749,12294,16120,19327,19661,23987,31922],[x*y^3+x^2*y^2+x^3*y,19531,32654],
[x*y^3+x^2*y^2+y^4,6409,26004,32403],[x^2*y^2+x^3*y+y^4,19307],
[x*y^2+x^2*y+x^3+y^3,3817],[x*y^4+x^2*y^3+x^3*y^2+x^4*y,32663],
[x^-1*y^3+x*y+2*y^2,11774,11777,11802],[x+2*y,3863],[x*y+2*y^2,6165,12489],
[x*y^2+2*x^2*y,5764,18307,32408],[x*y^2+2*y^3,5753,15905],[x*y^3+2*x^2*y^2,
12728,32457],[x*y^3+2*x^3*y,18633],[x*y^3+2*y^4,19197],[x*y^4+2*x^2*y^3,6196],
[x^2*y^3+2*x^3*y^2,2026],[x^3*y+2*x^4,19136],[x*y^2+2*x^2*y-y^3,12485],
[x*y^2+2*x^2*y+x^3,5204,15795,15937,19624],[x*y^3+2*x^2*y^2+x^3*y,3808,3888,
3889,4293,4294,5042,5438,5441,18954,18955,22457,24138,24139,25124],
[x*y^4+2*x^2*y^3+x^3*y^2,6400,25111,26041],[x^2*y^2+2*x^3*y+x^4,5609,13871,
25049],[x^-1*y^3+2*x*y+2*y^2,11748],[x*y^3+2*x^2*y^2+2*x^3*y,12494,26008],
[x*y^4+2*x^2*y^3+2*x^3*y^2,32440],[x*y^3+2*x^2*y^2+2*x^3*y+x^4,25414],
[x^-1*y^4+3*x*y^2+x^2*y+3*y^3,11745],[x*y^3+3*x^2*y^2+2*x^3*y,5285,29666],
[x*y^4+3*x^2*y^3+2*x^3*y^2+x^4*y+y^5,19279],[x*y^3+3*x^2*y^2+3*x^3*y,25117],
[x^2*y^2+4*x^3*y+x^4,19615],[x^-1*y^4+4*x*y^2+x^2*y+3*y^3,11746],
[x^2*y^3+4*x^3*y^2+2*x^4*y,25114],[x*y^4+4*x^2*y^3+2*x^3*y^2-x^4*y,25354],
[x*y^4+4*x^2*y^3+3*x^3*y^2-y^5,26005],[2*y,6246,11103,16484],[2*x*y,5788,6200,
19608],[2*x*y^2,1704,1718,12491,25399],[2*x*y^3,12241],[2*y^2,6283,12237,
15907,15922,19227],[2*x^2*y,15450,15914,19133,19581],[2*x^2*y^2,6173,12244],
[2*y^3,19199,19226],[2*x^3*y,15403],[2*x*y^3-3*x^2*y^2-x^3*y+y^4,15880],
[2*x*y^4-3*x^2*y^3-x^3*y^2+2*y^5,6160],[2*x^2*y-2*y^3,5780],
[2*x*y^3-2*x^3*y-x^4+y^4,24057],[2*x*y^3-2*x^2*y^2+x^4+2*y^4,12474],
[2*x*y^2-x^2*y,5768],[2*x*y^2-y^3,1711,5761],[2*x^2*y^3-x^4*y,6156],
[2*x*y^2-x^2*y-x^3,5754],[2*x^2*y^3-x^3*y^2-x^4*y,25353],
[2*x*y^3-x^2*y^2-x^3*y+2*y^4,12242],[2*x*y^2-x^2*y+y^3,12268],
[2*x*y^2-x^3+y^3,18671],[2*x*y^3-x^3*y+y^4,25435,25438],[2*x*y+x^2,6295],
[2*x*y+y^2,6210,11134,12723,19626,26049,32448],[2*x*y^2+x^2*y,6214,18310,
18660,18875,21688,25129,25404],[2*x*y^2+y^3,6206,12481,18694,25436,25463,
31305],[2*x*y^3+x^2*y^2,11830,18687,29812],[2*x*y^3+y^4,11827,29809],
[2*x^2*y+x^3,18471,19148],[2*x^2*y^2+x^3*y,28573],[2*x^2*y^3+x^3*y^2,2029],
[2*x*y^3+x^2*y^2-2*x^3*y,15401],[2*x^2*y^3+x^3*y^2-2*x^4*y,19541],
[2*x*y^2+x^2*y-x^3,18679],[2*x*y^2+x^2*y-y^3,12484],[2*x*y^3+x^2*y^2-x^3*y,
15406,19537],[2*x*y^3+x^2*y^2-y^4,18659],[2*x*y^4+x^2*y^3-x^3*y^2,12251],
[2*x^2*y+x^3-y^3,23249],[2*x*y^3+x^2*y^2-x^3*y-x^4+y^4,24061],[2*x*y+x^2+y^2,
5195,5200,18684,22295,23536,26073,32472],[2*x*y^2+x^2*y+y^3,3823,3989,5762,
6220,10774,11785,24118,30460],[2*x*y^3+x^2*y^2+y^4,5836,6415,17419,24058,
26033,31925,32432],[2*x*y^3+x^2*y^2+x^3*y+x^4,18873],
[2*x*y^3+x^2*y^2+x^3*y+y^4,6217],[2*x*y+2*y^2,19128,22529,22534,30485],
[2*x*y^2+2*x^2*y,5767,12512,16945,19118,19130,21634],[2*x*y^2+2*y^3,5861,6197,
6205,6207,12476,12722,17444],[2*x*y^3+2*x^2*y^2,17014],[2*x^2*y+2*x^3,19154],
[2*x^2*y^2+2*x^3*y,15896,16949,25127,25600],
[2*x*y^4+2*x^2*y^3-5*x^3*y^2-2*x^4*y,18634],[2*x*y^3+2*x^2*y^2-2*x^3*y-x^4,
19116],[2*x*y+2*x^2+y^2,19644],[2*x*y^2+2*x^2*y+y^3,10773,19654],
[2*x^2*y^2+2*x^3*y+x^4,31673],[2*x^2*y^3+2*x^3*y^2+x^4*y,31671],
[2*x*y^3+2*x^2*y^2+x^3*y+y^4,18644],[2*x*y^2+3*x^2*y,19123],
[2*x*y^3+3*x^2*y^2-y^4,21631],[2*x*y^4+3*x^2*y^3-x^3*y^2-2*x^4*y,18630],
[2*x*y^2+3*x^2*y-x^3+y^3,19639],[2*x*y^3+3*x^2*y^2+x^3*y,26062,31927,32461],
[2*x^2*y^2+3*x^3*y+x^4,32177],[2*x*y^3+4*x^2*y^2+2*x^3*y+x^4,5430],
[2*x*y^4+5*x^2*y^3-2*x^3*y^2-x^4*y,25357],[3*x*y^3-4*x^3*y-x^4,19120],
[3*x^2*y^2-y^4,32429],[3*x^2*y+x^3,6275],[3*x^2*y^2+x^3*y,6159],
[3*x*y+x^2+y^2,15414,25439],[3*x*y^2+x^2*y+y^3,30457],[3*x*y^3+x^2*y^2+y^4,
5833,11826,17416,29808],[3*x*y^2+2*x^2*y,12506],[3*x*y^2+2*y^3,6199],
[3*x*y^2+2*x^2*y+y^3,11113],[3*x*y^3+2*x^2*y^2+y^4,18691,31930],
[3*x*y^4+2*x^2*y^3+y^5,25843],[3*x*y^3+2*x^2*y^2+x^3*y+y^4,18632],
[3*x*y^2+3*x^2*y,12477],[3*x^2*y+3*x^3,19119],[3*x*y^2+3*x^2*y+x^3,6276],
[3*x*y^3+4*x^2*y^2-x^4,19613],[3*x*y^4+5*x^2*y^3+5*x^3*y^2+x^4*y+y^5,25840],
[4*x*y^3-2*x^3*y+y^4,25434],[4*x*y^3+x^2*y^2-x^3*y+2*y^4,12247],
[4*x*y^2+x^2*y+y^3,6161],[4*x*y^2+x^2*y+2*y^3,30456],[4*x*y^3+x^2*y^2+2*y^4,
5832,17415],[4*x*y^2+x^2*y+3*y^3,6187],[4*x*y^3+2*x^2*y^2-x^3*y+y^4,15877],
[4*x*y^3+3*x^2*y^2+x^3*y+y^4,6195],[5*x*y^2+x^2*y+3*y^3,6186],
[5*x*y^3+2*x^2*y^2+y^4,6158],[5*x*y^4+3*x^2*y^3-x^3*y^2+2*y^5,6157],
[5*x^2*y^2+5*x^3*y+x^4,6257],[5*x*y^4+6*x^2*y^3-2*x^3*y^2-x^4*y+x^5-y^5,
26001],[5*x*y^3+7*x^2*y^2+2*x^3*y-x^4+y^4,19618],[6*x*y^3-2*x^3*y+x^4-y^4,
21627],[6*x^2*y^3-x^3*y^2-2*x^4*y+x^5,28512],[9*x^2*y^3-3*x^4*y+x^5-2*y^5,
32400]])*x^0*y^0;end;
  rep:=[[f1,r],[f1,p],
  [f5,p,r,E(3)^2],[f5,r,p,E(3)^2],[f5,p,r,E(3)],[f5,r,p,E(3)],
  [f7,p,r],[f7,r,p],
  [f10,r,p,E(3)^2],[f10,p,r,E(3)^2],[f10,r,p,E(3)],[f10,p,r,E(3)],
  [f13,r,p],[f13,p,r],[f15,r,p],[f15,p,r],
  [f17,r,p],[f17,p,r],[f19,r,p],[f19,p,r],
  [f21,r,p],[f21,p,r],
  [f23,r,p,E(3)], [f23,p,r,E(3)], [f23,r,p,E(3)^2], [f23,p,r,E(3)^2],
  [f27,r,p,E(3)], [f27,p,r,E(3)], [f27,r,p,E(3)^2], [f27,p,r,E(3)^2],
  [f31,r,p,E(3)], [f31,p,r,E(3)], [f31,r,p,E(3)^2], [f31,p,r,E(3)^2],
  [f35,r,p],[f35,p,r],[f37,r,p,-1],[f37,r,p,1],[f39,p,r],[f39,r,p]];
  if IsBound(rep[i]) then 
    return ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]})+0*Product(para[1]);
  else return false;fi;
end);

CHEVIE.AddData("Representation","G33",i->
  CHEVIE.RawData("HeckeRepresentation","G33")(List([1..5],i->[1,-1]),[],i));

CHEVIE.AddData("UnipotentCharacters","G33",function()local J;J:=E(3);
 return rec(
  harishChandra:=[
  rec(relativeType:=rec(series:="ST",indices:=[1..5],rank:=5,ST:=33),
 levi:=[], parameterExponents:=[1,1,1,1,1],
       charNumbers:=[1..40], eigenvalue:=1, cuspidalName:=""),
   rec(relativeType:=rec(series:="ST",indices:=[1,5],rank:=2,ST:=4),
levi:=[2..4],
       parameterExponents:=[[3,0,0]],
       charNumbers:=[41,58,57,59,43,44,51],
       eigenvalue:=J, cuspidalName:="G_{3,3,3}[\\zeta_3]"),
   rec(relativeType:=rec(series:="ST",indices:=[1,5],rank:=2,ST:=4),
levi:=[2..4],
       parameterExponents:=[[3,3,0]],
       charNumbers:=[46,45,64,55,56,47,54],
       eigenvalue:=J^2, cuspidalName:="G_{3,3,3}[\\zeta_3^2]"),
   rec(relativeType:=rec(series:="ST",indices:=[4],rank:=1,p:=6,q:=1),
       levi:=[1,2,3,209],
       parameterExponents:=[[5,4,1,0,1,4]],
       charNumbers:=[42,49,60,63,61,48],
       eigenvalue:=-1, cuspidalName:="D_4"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[52], eigenvalue:=E(4), 
       cuspidalName:="G_{33}[i]",qEigen:=1/2),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[53], eigenvalue:=-E(4), 
       cuspidalName:="G_{33}[-i]",qEigen:=1/2),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[62], eigenvalue:=-J, 
       cuspidalName:="G_{33}[-\\zeta_3]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[50], eigenvalue:=-J^2, 
       cuspidalName:="G_{33}[-\\zeta_3^2]")],
  families:=[ Family("C1",[1]),
 Family(ComplexConjugate(CHEVIE.families.X(3)),[4,6,41],rec(signs:=[1,1,-1])),
 Family("C1",[15]),
 Family("C2",[22,8,19,42]),
 Family(ComplexConjugate(CHEVIE.families.X(6)),
  [25,30,17,28,23,45,48,43,50,9,47,44,11,49,46],
  rec(signs:=[1,1,1,1,1,-1,-1,-1,-1,-1,1,-1,1,1,-1])),
 Family("C1",[39]),
 Family("C1",[36]),
 Family(ComplexConjugate(CHEVIE.families.X(3)),[34,32,51],rec(signs:=[1,1,-1])),
 # changed Gunter 22/9/99 from C2 to C'\"2; and to C2h on 26.2.2003
 # and back 27.2.2003:
 Family("C'\"2",[37,38,52,53]),
 Family("C1",[14]),
 Family(CHEVIE.families.X(3),[33,31,54],rec(signs:=[1,1,-1])),
 Family("C1",[40]),
 Family("C1",[35]),
 Family("C1",[13]),
 Family(CHEVIE.families.X(6),[26,29,18,27,24,57,60,55,62,10,59,56,12,61,58],
  rec(signs:=[ 1, 1, 1, 1, 1, -1, -1, -1,-1, -1, 1, -1, 1, 1, -1 ])),
 Family("C2",[ 21,7,20,63]),
 Family("C1",[16]),
 Family(CHEVIE.families.X(3),[3,5,64],rec(signs:=[1,1,-1])),
 Family("C1",[2])],
 a:=[0,45,28,1,28,1,18,3,4,13,4,13,12,9,2,23,4,13,3,18,18,3,4,13,4,13,13,4,13,4,
  10,7,10,7,10,7,8,8,6,11,1,3,4,4,4,4,4,4,4,4,7,8,8,10,13,13,13,13,13,13,13,13,
  18,28],
 A:=[0,45,44,17,44,17,42,27,32,41,32,41,36,33,22,43,32,41,27,42,42,27,32,41,32,
  41,41,32,41,32,38,35,38,35,38,35,37,37,34,39,17,27,32,32,32,32,32,32,32,32,35,
  37,37,38,41,41,41,41,41,41,41,41,42,44],
 curtis:=[2,1,6,5,4,3,8,7,12,11,10,9,14,13,16,15,18,17,20,19,22,21,26,25,24,23,
   30,29,28,27,34,33,32,31,36,35,38,37,40,39,-64,63,-56,-55,-58,-57,-59,61,60,
   -62,-54,-53,-52,-51,-44,-43,-46,-45,-47,49,48,-50,42,-41]
 );
end);

# for the following see
# Burkhardt, Math. Annalen 38 pp 208--209
# and Orlik, Contemporary mathematics vol. 90 (1989) pp 223--226
# here we have interchanged the x and z of Burkhardt

CHEVIE.AddData("Invariants","G33",
[ function(x,y,z,t,u)local a1,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a4:=y*u*t*x;
    return z^4-8*a1*z+48*a4;end,
  function(x,y,z,t,u)local a1,a2,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a4:=y*u*t*x;
    return z^6+20*a1*z^3+96*a2-8*a1^2+360*a4*z^2;end,
  function(x,y,z,t,u)local a1,a2,a3,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a3:=-((y*u*t)^3+(u*t*x)^3+(y*t*x)^3+(y*u*x)^3);
    a4:=y*u*t*x;
    return -z^4*a2+(9*a3-a1*a2)*z+a4*(z^6-a1*z^3+6*a2-2*a1^2)+9*a4^2*z^2;end,
# Note: the 3rd invariant of degree 10 is Determinant(Hessian(J4))/63700992
  function(x,y,z,t,u)local a1,a2,a3,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a3:=-((y*u*t)^3+(u*t*x)^3+(y*t*x)^3+(y*u*x)^3);
    a4:=y*u*t*x;
    return 5*a2*z^6+(99*a3+a1*a2)*z^3+216*a4^3-36*a1*a3+24*a2^2-4*a1^2*a2+
    a4*(3*z^8+33*a1*z^5+(18*a2+30*a1^2)*z^2)+a4^2*(243*z^4+108*a1*z);end,
  function(x,y,z,t,u)local a1,a2,a3,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a3:=-((y*u*t)^3+(u*t*x)^3+(y*t*x)^3+(y*u*x)^3);
    a4:=y*u*t*x;
    return 4*a3*z^9+(54*a4^3+12*a1*a3-a2^2)*z^6+
    (162*a1*a4^3-18*a2*a3+12*a1^2*a3-2*a1*a2^2)*z^3+
    (27*a3^2-18*a1*a2*a3+4*a1^3*a3+4*a2^3-a1^2*a2^2)+
    a4*(6*a2*z^8+(54*a3+12*a1*a2)*z^5+(243*a4^3+54*a1*a3-36*a2^2+6*a1^2*a2)
     *z^2)+a4^2*(3*z^10+18*a1*z^7+(54*a2+27*a1^2)*z^4+
     (162*a3-54*a1*a2+12*a1^3)*z);end]);

CHEVIE.AddData("BasicDerivations","G33",function()return function(x,y,z,t,u)
return [[4*x,6*y*z,10*z-1/96*x*y,12*t-1/32*y^2,18*u-1/32*t*y],
[6*y,-5184*u+9*x^2*z,6*t-1/64*x^3,63*x*z-3/64*x^2*y,-3/64*t*x^2+180*z^2],
[10*z,6*t*z-9*u*x,-1/384*t*x+3/128*y*z,9/2*u-1/128*t*y+9/128*x^2*z,
3/64*u*y+9/32*x*z^2-1/32*t^2],[12*t,-27*u*y+63*x*z^2,
9/2*u+3/128*t*y-5/128*x^2*z,-15/128*x*y*z+9/128*t*x^2+90*z^2,
-21/64*t*x*z+9/64*u*x^2+27/32*y*z^2],[18*u,-27*t*u+180*z^3,
3/64*u*y-1/32*x*z^2,9/64*u*x^2-3/32*y*z^2,45/64*u*x*z-3/8*t*z^2]];
end;end);

# the discriminant as a polynomial in the invariants
# it is equal to Determinant(BasicDerivations)*262144/729
CHEVIE.AddData("Discriminant","G33",function()return function(x,y,z,t,u)
return 243302400*t*u*x*y*z^5-483072*t*u*x^2*y^2*z^4+144*t*u*x^3*y^3*z^3-
11520*u*x*y^3*z^5-108*t*x*y^4*z^5-72*t*u*y^5*z^3-14592*t*u*x^5*z^4-
47185920000*t*u*z^6-72*t*u*x^6*y*z^3-737280000*x*y*z^8-34560*t*u^2*x*y^3*z^2-
6635520*t*u^2*y^2*z^3-24*t*u^2*x^2*y^4*z+57360384*t*u^2*x^3*z^3-
186624*t*u^2*x^4*y*z^2+27*u*x^2*y^4*z^4+48*t*u^2*x^5*y^2*z+24576000*u*y^2*z^6+
270336000*t*x^2*z^7-24*t*u^2*x^8*z-3822059520*t*u^3*x*z^2-875520*t*x^3*y*z^6+
2654208*t*u^3*x^2*y*z+4608*t*u^3*y^4-4608*t*u^3*x^6-230400*t*y^3*z^6-
57753600*u*x^3*z^6+254803968*t*u^4*y+177408*u*x^4*y*z^5+216*t*x^4*y^2*z^5-
54*u*x^5*y^2*z^4-108*t*x^7*z^5+27*u*x^8*z^4+30*t^2*u*x*y^4*z^2-
65617920*t^2*u*x^2*z^4+107520*t^2*x*y^2*z^5+254720*t^2*u*x^3*y*z^3+
77056*t^2*u*y^3*z^3-60*t^2*u*x^4*y^2*z^2+21233664000*u^2*x*z^5+
36*u^2*x*y^5*z^2+65536000*t^2*y*z^6+30*t^2*u*x^7*z^2-2654208*t^2*u^2*x*y*z^2-
128286720*u^2*x^2*y*z^4+48384*t^2*u^2*x^2*y^2*z+5662310400*t^2*u^2*z^3-
8*t^2*u^2*x^3*y^3+4*t^2*u^2*y^5+25344*t^2*u^2*x^5*z+4*t^2*u^2*x^6*y+
1382400*x^2*y^2*z^7-1105920*t^2*u^3*y^2+231168*u^2*x^3*y^2*z^3+
1548288*t^2*u^3*x^3-1536*u^2*y^4*z^3-72*u^2*x^4*y^3*z^2+113664*t^2*x^4*z^5-
8448*u^2*x^6*z^3+36*u^2*x^7*y*z^2-29952*t^3*u*x*y^2*z^2-21626880*t^3*u*y*z^3+
17915904*u^3*x*y^2*z^2-2123366400*u^3*y*z^3-31488*t^3*u*x^4*z^2-
39321600*t^3*x*z^5+24576*t^3*x^2*y*z^4-7077888*t^3*u^2*x^2*z-4352*t^3*u^2*y^3-
3840*t^3*u^2*x^3*y-27648*u^3*x^2*y^3*z-113246208*t^3*u^3-8*t^3*x^3*y^2*z^3+
12*u^3*x^3*y^4-432*x^3*y^3*z^6-8626176*u^3*x^4*z^2+4*t^3*y^4*z^3+
27648*u^3*x^5*y*z-4*u^3*y^6-12*u^3*x^6*y^2+4*t^3*x^6*z^3+4*u^3*x^9+
10616832*t^4*u*x*z^2-6144*t^4*u*x^2*y*z+2*t^4*u*x^3*y^2-t^4*u*y^4-t^4*u*x^6+
1179648*t^4*u^2*y+764411904*u^4*x^2*z-4096*t^4*y^2*z^3-442368*u^4*y^3-
1327104*u^4*x^3*y-4096*t^4*x^3*z^3-12230590464*u^5+1024*t^5*u*y^2+
1024*t^5*u*x^3+1048576*t^5*z^3+216*y^5*z^6-55296*x^5*z^7-262144*t^6*u+
216*x^6*y*z^6+104857600000*z^9;
end;end);
