#!/bin/bash

if [ $SAGE_LOCAL"" = "" ]; then
    echo "Set the environment variable SAGE_LOCAL."
    exit 1
fi

#############################################################################
##
##  gap.sh                      GAP                          Martin Schoenert
##
##  This is a shell script for UNIX-like  operating systems that starts  GAP.
##  This is the place  where  to  make  all  the  necessary  customizations.
##  Copy/rename this file to a directory in your search path like '~/bin/gap'.
##  If you later move GAP to another location you must only change this file.
##

#############################################################################
##
##  GAP_DIR . . . . . . . . . . . . . . . . . . . . directory where GAP lives
##
##  Set 'GAP_DIR' to the name of the directory where you have installed  GAP,
##  i.e., the directory with the subdirectories  'lib',  'grp',  'doc',  etc.
##  The default is '/usr/local/lib/gap3-jm5'.
##  You have to change this unless you have installed  GAP in this  location.
##
#GAP_DIR=/usr/local/lib/gap3-jm5
GAP_DIR="$SAGE_LOCAL/gap3/latest"

#############################################################################
##
##  GAP_MEM . . . . . . . . . . . . . . . . . . . amount of initial workspace
##
##  Set 'GAP_MEM' to the amount of memory GAP shall use as initial workspace.
##  The default is 4 MByte, which is the minimal reasonable amount of memory.
##  You have to change it if you want  GAP to use a larger initial workspace.
##  If you are not going to run  GAP  in parallel with other programs you may
##  want to set this value close to the  amount of memory your  computer has.
##

ARCH=`getconf LONG_BIT`
if [[ "$ARCH" == '32' ]]; then
   GAP_MEM=512m
elif [[ "$ARCH" == '64' ]]; then
   GAP_MEM=1024m
fi

#############################################################################
##
##  GAP_PRG . . . . . . . . . . . . . . . . .  name of the executable program
##
##  Set 'GAP_PRG' to the name of the executable  program of the  GAP  kernel.
##  It should be (I thank Andrew Mathas for the MAC X86 executable):
##        gap.x86linux for linux X86
##        gap.x86linux64 for linux X86, 64 bit gap
##        gap.mac for Mac OSX on powerPC
##        gap.macx86 for Mac OSX on X86 
##
GAP_PRG=gap3

#############################################################################
##
##  GAP . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . run GAP
##
##  You  probably should  not change  this line,  which  finally starts  GAP.
##
exec $GAP_DIR/bin/$GAP_PRG -m $GAP_MEM -l $GAP_DIR/lib/ -h $GAP_DIR/doc/ $*
