#############################################################################
##
#A  Matrix package                                      Charles Leedham-Green
#A                                                      Eamonn O'Brien
##
#Y  Copyright (C)  1996,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
############################################################################
##
#F  InfoTensor1  (...)  . . . . . . . . . . . . . .  for debugging assistance
##
##
if not IsBound (InfoTensor1)  then InfoTensor1 := Ignore;  fi;
if not IsBound (InfoTensor)  then InfoTensor := Ignore;  fi;
###############################################################################
##
##  SetGFlag (<next>, <g>) . . . . . set the component g of record <next> to g
##
SetGFlag := function (next, g)
   next.g := g;
end;

###############################################################################
##
##  SetFactorsFlag (<next>,<factors>) . . set the component factors of record
## <next> to factors
##
SetFactorsFlag := function (next, factors)
   next.factors := factors;
end;

###############################################################################
##
##  GFlag (<next>) . . . . . . . . . . . return the component g of <next>
##
GFlag := function (next)
   if IsBound (next.g) = false then return "unknown"; fi;
   return next.g;
end;

###############################################################################
##
##  FactorsFlag (<next>) . . . . . . . . return the component factors of <next>
##
FactorsFlag := function (next)
   if IsBound (next.factors) = false then return "unknown"; fi;
   return next.factors;
end;

###############################################################################
# is the characteristic polynomial a u-th power, for u in L ?
#
ProcessElement := function (g, L)
   local f, factors, mults, i, y, u;

   f := CharacteristicPolynomial (g);
   factors := Collected (Factors (f));
   mults := List (factors, i -> i[2]);
   L := Filtered (L, u -> ForAll (mults, y -> y mod u = 0));

   return [factors, L];

end;

# decide if the matrix C is a u-projectivity for some u in DimList
# if Status is true, then CB is a tuple; first entry is the change
# of basis matrix which exhibits the tensor decomposition

IsProjectivity := function (G, C, DimList)
   local L, r, Record, NmrTries, K, g1, g2, g, i, h, N, R, 
         CB, Status, SumSpaces, Spaces, u, factors;

   CB := "undefined"; Status := false;

   InfoTensor1 ("#I List is now ", DimList, "\n");

   # if the matrix is scalar, do not test
   if IsScalar (C) then
      InfoTensor1 ("#I Matrix is scalar \n");
      return [Status, CB];
   fi;

   # is DimList a single integer?
   if IsInt (DimList) then 
      L := Set ([DimList]);
   else
      L := DimList;
   fi;

   # is the characteristic polynomial a u-th power, for u in L ?
   R := ProcessElement (C, L);
   factors := R[1]; L := R[2];
   if L = Set ([]) then return [Status, CB]; fi;

   # test a small number of elements in the F-algebra
   # generated by C and its G-conjugates
   r := rec ();
   SetGFlag (r, C);
   SetFactorsFlag (r, factors);
   Record := [r];
   NmrTries := 25;
   InfoTensor1 ("#I Before looking at random elements of algebra, List is ", L, "\n");

   K := 0;
   repeat
      # if so, we generate an element of the F-algebra and try again
      g1 := PseudoRandom (G);
      g2 := PseudoRandom (G);
      g := C^g1 + C^g2;

      # is the characteristic polynomial a u-th power, for u in L ?
      R := ProcessElement (g, L);
      factors := R[1]; L := R[2];
      if L = Set ([]) then return [Status, CB]; fi;
      r := rec ();
      SetGFlag (r, g);
      SetFactorsFlag (r, factors);
      Add (Record, r);

      K := K + 1;
   until K = NmrTries;

   InfoTensor1 ("#I After looking at random elements of algebra, List is ", L, "\n");

   # if the characteristic polynomial f of some g is not a power of an
   # irreducible polynomial, then compute kernel of an irreducible
   # factor to give a potential flat for FindPoint

   for i in [1..Length (Record)] do
      factors := FactorsFlag (Record[i]);
      if Length (factors) > 1 then
         g := GFlag (Record[i]);
         h := factors[1][1];
         N := NullSpace (Value (h, g), BaseRing (G));

         SumSpaces := [N];
         SumSpaces := DirectSumSpaces (G, SumSpaces);

         # now send potential flat to FindPoint
         for u in L do
            Spaces := Copy (SumSpaces);
            InfoTensor1 ("#I 1-- Now call FindPoint for u = ", u, "\n");
            R := FindPoint (G, Spaces, u);
            Status := R[1]; CB := R[2];
            InfoTensor1 ("#I Status is ", Status, "\n");
            if Status = true then return [Status, CB]; fi;
         od;

         return [Status, CB];
      fi; #factors > 1
   od; #Record 

   InfoTensor1 ("#W ** After ", NmrTries, " selections, have not found a suitable singular space \n");
   InfoTensor1 ("#W Conclusion: Group may preserve tensor decomposition over larger field\n");

   return ["unknown", CB];

end;

# decide whether any of the elements of prime order obtained from
# the element g of order o is a projectivity in a u-projective
# geometry for some u in L

ProjectivityTest := function (G, g, o, Elts, NmrProjective, L)

   local CB, primes, p, x, Result, R;

   CB := "undefined";
   primes := DistinctPrimes (o);
   for p in primes do
      x := g^QuoInt (o, p);
      if IsScalar (x) = false then
         if not x in Elts then
            Add (Elts, x);
            InfoTensor ("#I Call to IsProjectivity for p = ", p, "\n");
            R := IsProjectivity (G, x, L);
            Result := R[1]; CB := R[2];
            InfoTensor ("#I Result of call to IsProjectivity for p = ", 
                    p, " is ", Result, "\n");
            if Result = true then
               InfoTensor ("#I Found tensor product\n");
               return [Result, CB];
            fi;
            if Length (Elts) >= NmrProjective then 
               return [false, CB];
            fi;
         fi;
      fi;
   od;

   return [false, CB];

end;
