#A  BOUNDS FOR q = 3
##
##  Each entry [n][k] of one of the tables below contains
##  a bound (the first table contains lowerbounds, the   
##  second upperbounds) for a code with wordlength n and 
##  dimension k. Each entry contains one of the following
##  items:                                               
##                                                       
##  FOR LOWER- AND UPPERBOUNDSTABLE                      
##  [ 0, <d>, <ref> ]  from Brouwers table               
##                                                       
##  FOR LOWERBOUNDSTABLE                                 
##  empty        k= 0, 1, n or d= 2 or (k= 2 and q= 2)   
##  1            shortening a [ n + 1, k + 1 ] code      
##  2            puncturing a [ n + 1, k ] code          
##  3            extending a [ n - 1, k ] code           
##  [ 4, <dd> ]  constr. B, of a [ n+dd, k+dd-1, d ] code
##  [ 5, <k1> ]  an UUV-construction with a [ n / 2, k1 ]
##               and a [ n / 2, k - k1 ] code            
##  [ 6, <n1> ]  concatenation of a [ n1, k ] and a      
##               [ n - n1, k ] code                      
##  [ 7, <n1> ]  taking the residue of a [ n1, k + 1 ] code
##                                                       
##  FOR UPPERBOUNDSTABLE                                 
##  empty        Griesmer bound                          
##  11           shortening a [ n + 1, k + 1 ] code      
##  12           puncturing a [ n + 1, k ] code          
##  13           extending a [ n - 1, k ] code           
##  [ 14, <dd> ] constr. B, with dd = dual distance      


GUAVA_BOUNDS_TABLE[1][3] := [
#V   n = 1
[  ],
#V   n = 2
[  ],
#V   n = 3
[  ],
#V   n = 4
[ , [ 0, 3, "Ham" ] ],
#V   n = 5
[ , 3 ],
#V   n = 6
[ , [ 6, 2 ], [ 5, 2 ] ],
#V   n = 7
[ , [ 6, 3 ], 1, 2 ],
#V   n = 8
[ , [ 6, 4 ], 1, [ 5, 3 ], [ 5, 3 ] ],
#V   n = 9
[ , [ 6, 3 ], 1, 1, 1, 2 ],
#V   n = 10
[ , [ 6, 3 ], 2, 1, 1, 2, 1 ],
#V   n = 11
[ , [ 6, 4 ], 2, 1, 1, 2, 2, 1 ],
#V   n = 12
[ , [ 6, 4 ], 2, [ 5, 3 ], 1, [ 0, 6, "Gol" ], 2, [ 5, 5 ], 1 ],
#V   n = 13
[ , [ 6, 3 ], [ 0, 9, "BCH" ], 1, 2, 3, 2, 2, 1, [ 0, 3, "Ham" ] ],
#V   n = 14
[ , [ 6, 4 ], 3, 1, 2, 3, [ 0, 6, "QR" ], [ 0, 5, "KP" ], 1, 3 ],
#V   n = 15
[ , [ 6, 4 ], 3, 1, 2, [ 0, 7, "LiH" ], 3, 3, 1, 1, 2 ],
#V   n = 16
[ , [ 6, 4 ], [ 6, 3 ], 1, [ 0, 9, "HN" ], 3, 3, 1, 1, [ 5, 7 ], [ 5, 7 ], 
  [ 5, 7 ] ],
#V   n = 17
[ , [ 6, 4 ], [ 6, 4 ], 1, 3, 1, 1, 1, 1, 1, 1, [ 4, 27 ], 1 ],
#V   n = 18
[ , [ 6, 4 ], 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, [ 4, 30 ], 1 ],
#V   n = 19
[ , [ 6, 4 ], [ 6, 6 ], 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, [ 4, 33 ], 1 ],
#V   n = 20
[ , [ 6, 4 ], [ 7, 59 ], 1, [ 0, 12, "GH" ], 2, 2, 1, 1, 1, 1, 1, 1, 
  [ 5, 9 ], [ 4, 36 ], 1 ],
#V   n = 21
[ , [ 6, 4 ], [ 7, 63 ], 2, 3, 2, [ 0, 10, "KP" ], 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1 ],
#V   n = 22
[ , [ 6, 4 ], [ 6, 9 ], 2, 3, [ 0, 12, "KP" ], 3, 2, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 23
[ , [ 6, 4 ], 2, 2, 1, 3, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 24
[ , [ 6, 4 ], 2, 2, 1, 1, [ 5, 6 ], 2, 1, 1, 1, [ 0, 9, "QR" ], [ 5, 7 ], 
  [ 5, 8 ], 1, 1, 1, 1, [ 5, 11 ], 1 ],
#V   n = 25
[ , [ 6, 4 ], 2, 2, 1, 1, 1, 2, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 26
[ , [ 6, 4 ], [ 6, 13 ], 2, 2, 1, 1, 2, 1, 1, 1, 3, 1, 2, 2, [ 5, 10 ], 1, 1, 
  1, 2, [ 5, 11 ], [ 5, 12 ] ],
#V   n = 27
[ , [ 6, 4 ], [ 6, 13 ], [ 0, 18, "D3" ], 2, 1, 1, 2, 1, 1, 1, 3, 1, 2, 2, 1, 
  1, 1, 1, 2, 1, 1, 1 ],
#V   n = 28
[ , [ 6, 4 ], [ 6, 13 ], 3, 2, 2, 1, [ 0, 15, "KP" ], 2, 1, 1, 1, 1, 
  [ 0, 9, "KP" ], [ 0, 8, "BCH" ], [ 5, 10 ], [ 5, 10 ], 1, 1, 
  [ 0, 6, "KP" ], [ 5, 13 ], 1, [ 5, 13 ], 1 ],
#V   n = 29
[ , [ 6, 4 ], [ 6, 13 ], 3, [ 0, 18, "vE" ], 2, 1, 3, 2, 2, 1, 1, 1, 3, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1 ],
#V   n = 30
[ , [ 6, 4 ], [ 6, 13 ], 2, 3, 2, 2, 3, [ 0, 14, "GuB" ], [ 0, 13, "GuB" ], 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1 ],
#V   n = 31
[ , [ 6, 4 ], 1, 2, 3, [ 0, 18, "vE" ], 2, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 3, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 32
[ , [ 6, 4 ], [ 6, 13 ], [ 0, 21, "BZ" ], 2, 3, [ 0, 17, "GuB" ], 
  [ 0, 16, "KP" ], 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, [ 5, 12 ], 3, 1, 1, 1, 1, 
  [ 5, 15 ], [ 5, 15 ], [ 5, 15 ], 1 ],
#V   n = 33
[ , [ 6, 4 ], 1, 3, 2, 3, 3, 3, 2, [ 0, 15, "Gu" ], 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 34
[ , [ 6, 4 ], 1, 2, [ 0, 21, "vE" ], 2, 2, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 35
[ , [ 6, 4 ], 1, 2, 3, 2, [ 0, 19, "KP" ], 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1 ],
#V   n = 36
[ , [ 6, 4 ], 2, [ 0, 24, "D3" ], 2, [ 0, 21, "BZ" ], 3, 1, [ 0, 18, "KP" ], 
  1, 1, 1, 1, 1, 1, 1, 1, [ 0, 12, "Ple" ], 1, 1, 1, 1, 1, 1, 1, 
  [ 0, 6, "D3" ], 1, 1, 1, 1, 1, 1 ],
#V   n = 37
[ , [ 6, 4 ], 2, 3, 2, 3, 3, 2, 3, 1, 1, 2, 1, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 
  2, 1, 3, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 38
[ , [ 6, 4 ], 2, [ 7, 113 ], [ 0, 24, "BB" ], 2, 2, 2, 3, 1, 1, 2, 1, 1, 1, 
  1, 1, 3, 1, 2, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 39
[ , [ 6, 4 ], [ 6, 13 ], [ 7, 117 ], 3, 2, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 
  3, 1, 2, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 40
[ , [ 6, 4 ], [ 6, 13 ], [ 7, 121 ], 3, [ 0, 24, "BCH" ], 2, 2, 
  [ 0, 20, "GuB" ], 1, 1, [ 0, 18, "KP" ], 1, 1, 1, 1, 1, 1, 1, 
  [ 0, 12, "Hu" ], 1, 1, 1, [ 0, 9, "KP" ], 1, 2, 1, 1, 1, 2, 1, 1, 
  [ 5, 19 ], 1, 1, [ 0, 3, "Ham" ] ],
#V   n = 41
[ , [ 6, 4 ], [ 6, 13 ], [ 7, 122 ], 2, 3, 2, [ 0, 22, "KP" ], 3, 2, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, [ 0, 8, "BCH" ], 2, 1, 1, 
  [ 0, 6, "D1" ], 1, 1, [ 0, 5, "BCH" ], 1, 1, 3 ],
#V   n = 42
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, 3, [ 0, 24, "KP" ], 3, 2, 2, 2, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 2, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1 ],
#V   n = 43
[ , [ 6, 4 ], [ 6, 13 ], 2, [ 0, 27, "vE" ], 2, 3, 1, 2, 2, 2, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 3, [ 0, 8, "D1" ], 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 
  1 ],
#V   n = 44
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 8 ], 3, 2, 3, 1, 2, [ 0, 21, "Gu" ], 
  [ 0, 20, "Gu" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [ 5, 15 ], 3, 3, 1, 
  1, 3, 1, [ 5, 18 ], 3, 1, 1, 1, 1, 1, 1 ],
#V   n = 45
[ , [ 6, 4 ], [ 6, 13 ], [ 7, 130 ], [ 0, 28, "GH" ], [ 0, 27, "Ha" ], 
  [ 0, 25, "Gu" ], 1, [ 0, 24, "KP" ], 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 46
[ , [ 6, 4 ], [ 6, 7 ], [ 6, 10 ], 3, 3, 3, 2, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, [ 5, 16 ], [ 5, 16 ], 1, 1, 1, 1, 1, 1, [ 5, 19 ], 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 47
[ , [ 6, 4 ], [ 6, 8 ], 1, 2, 2, 2, 2, 3, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 48
[ , [ 6, 4 ], [ 6, 9 ], 1, 2, 2, 2, [ 0, 26, "KP" ], 3, 1, [ 0, 22, "Gu" ], 
  [ 0, 21, "Gu" ], [ 5, 12 ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 15, "Ple" ], 
  1, 1, 1, [ 5, 17 ], [ 5, 17 ], 1, 1, 1, [ 5, 19 ], 1, 1, [ 5, 20 ], 1, 1, 
  1, [ 5, 23 ], 1, 1, 1 ],
#V   n = 49
[ , [ 6, 4 ], 2, [ 6, 9 ], [ 0, 31, "BB" ], [ 0, 30, "GuB" ], 
  [ 0, 28, "GuB" ], 3, 2, 1, 3, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 50
[ , [ 6, 4 ], 2, [ 6, 10 ], 3, 3, 3, [ 0, 27, "Gu" ], [ 0, 26, "GuB" ], 1, 1, 
  2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, [ 5, 18 ], 1, 1, 1, 
  1, 1, 1, 1, [ 5, 21 ], 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 51
[ , [ 6, 4 ], 2, 2, 1, 2, 2, 3, 3, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 52
[ , [ 6, 4 ], [ 6, 13 ], 2, 1, 2, [ 0, 30, "CG" ], 2, [ 0, 27, "CG" ], 
  [ 0, 25, "CG" ], 1, [ 0, 24, "CG" ], [ 0, 22, "CG" ], 1, [ 0, 20, "CG" ], 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, [ 5, 21 ], 
  [ 5, 22 ], 1, [ 5, 22 ], 1, 1, 1, 1, 1, 1, [ 5, 25 ] ],
#V   n = 53
[ , [ 6, 4 ], [ 6, 13 ], 2, 1, 2, 3, 2, 3, 3, 2, 3, 3, 1, 3, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 54
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], 1, 2, 2, [ 0, 30, "GuB" ], 
  [ 0, 28, "GB1" ], 2, 2, 3, 3, 1, 3, [ 0, 20, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 23 ], 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 55
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], 1, 2, 2, 3, 3, 2, [ 0, 26, "Gu" ], 3, 3, 
  2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 56
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], 1, [ 0, 36, "Hi" ], [ 0, 33, "GuB" ], 3, 
  2, 2, 3, 3, 3, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 
  [ 5, 20 ], 1, [ 5, 21 ], 1, 1, 1, 1, [ 5, 21 ], [ 5, 22 ], [ 5, 23 ], 
  [ 5, 24 ], 1, 1, 1, [ 5, 27 ], 1, [ 0, 4, "Hi1" ], 1 ],
#V   n = 57
[ , [ 6, 4 ], [ 6, 9 ], 2, 1, 3, 3, 3, [ 0, 30, "BCH" ], [ 0, 29, "BCH" ], 3, 
  2, 3, [ 0, 22, "BZ" ], 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1 ],
#V   n = 58
[ , [ 6, 4 ], [ 6, 13 ], 2, [ 6, 20 ], 3, 3, 2, 3, 3, 2, 2, 1, 3, 1, 3, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, 1, 1, 1 ],
#V   n = 59
[ , [ 6, 4 ], [ 6, 7 ], [ 6, 27 ], 2, 3, 3, 2, 2, 3, 2, 2, 1, 2, 1, 2, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 60
[ , [ 6, 4 ], [ 6, 8 ], [ 6, 27 ], 2, 3, 2, 2, [ 0, 32, "GuB" ], 2, 
  [ 0, 29, "Gu" ], [ 0, 28, "Gu" ], 1, [ 0, 24, "BZ" ], 1, [ 0, 22, "BZ" ], 
  2, 1, 1, 1, [ 0, 20, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 18, "Ple" ], 1, 
  2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 61
[ , [ 6, 4 ], [ 6, 9 ], 2, [ 0, 39, "vE" ], 2, 2, 2, 3, [ 0, 31, "GB2" ], 3, 
  3, 1, 3, 1, 3, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 
  1, [ 0, 10, "D1" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 62
[ , [ 6, 4 ], 2, 2, 3, 2, 2, 2, 2, 3, 3, 3, 1, 2, 1, 1, 2, 2, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 63
[ , [ 6, 4 ], 2, [ 0, 42, "D3" ], 2, [ 0, 39, "GuB" ], 2, [ 0, 36, "GuB" ], 
  2, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 2, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 64
[ , [ 6, 4 ], 2, 3, 2, 3, 2, 3, 2, [ 0, 33, "BZ" ], 2, [ 0, 30, "BZ" ], 1, 
  [ 0, 27, "BZ" ], 1, 2, [ 0, 24, "BZ" ], [ 0, 22, "BZ" ], [ 5, 15 ], 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 1, [ 0, 18, "Be" ], 1, 1, 1, 1, 1, 
  [ 0, 12, "D1" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  [ 5, 31 ], [ 5, 31 ], [ 5, 31 ], 1 ],
#V   n = 65
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 25 ], [ 0, 42, "HN" ], 2, [ 0, 39, "Gu" ], 3, 
  [ 0, 36, "Gu" ], 3, 2, 3, 1, 3, 1, 2, 3, 3, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 66
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 26 ], 3, 2, 3, 3, 3, [ 0, 34, "Gu" ], 
  [ 0, 32, "Gu" ], 3, 1, 1, 1, 2, 3, 3, [ 5, 16 ], [ 5, 16 ], 3, 1, 1, 2, 1, 
  1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 67
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], 2, [ 0, 42, "Ha" ], 3, 2, 3, 3, 3, 1, 1, 
  1, 1, 2, 3, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 68
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 32 ], 2, 3, 2, 2, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 
  1, 1, [ 5, 17 ], [ 5, 17 ], 1, [ 0, 20, "BZ" ], 1, 1, 1, 1, 1, 3, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 69
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 32 ], [ 0, 45, "vEH" ], 3, 2, 2, 2, 1, 1, 1, 1, 
  1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 3, 1, 3, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 70
[ , [ 6, 4 ], [ 6, 9 ], 2, 3, 2, [ 0, 42, "Gu" ], 2, [ 0, 39, "GuB" ], 1, 1, 
  1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 3, 1, 3, 
  [ 0, 16, "D1" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 71
[ , [ 6, 4 ], [ 6, 13 ], 2, 3, 2, 3, 2, 3, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 72
[ , [ 6, 4 ], [ 6, 7 ], [ 0, 48, "D3" ], 2, [ 0, 45, "GB1" ], 3, 
  [ 0, 42, "Gu" ], 3, 1, 1, 1, 1, 1, 1, 2, 1, [ 0, 27, "BZ" ], [ 5, 18 ], 1, 
  1, [ 5, 18 ], 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, [ 5, 26 ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 73
[ , [ 6, 4 ], [ 6, 8 ], 3, 2, 3, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 2, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 3, [ 0, 18, "D1" ], 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 74
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 34 ], [ 0, 48, "vE" ], 3, 2, 3, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 2, 1, 2, 1, [ 5, 18 ], [ 0, 24, "D1" ], 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 75
[ , [ 6, 4 ], 2, [ 6, 35 ], 3, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 
  1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 76
[ , [ 6, 4 ], 2, [ 6, 36 ], 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  [ 0, 30, "BZ" ], 1, [ 0, 27, "BZ" ], 1, 1, 3, [ 0, 24, "BZ" ], 1, 1, 1, 1, 
  1, 1, 1, 1, 3, 1, [ 0, 18, "D1" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 77
[ , [ 6, 4 ], 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 3, 1, 1, 2, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 78
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 3, 1, 2, 
  1, 1, [ 0, 26, "BZ" ], 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 79
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1, 3, 1, 2, 
  1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 80
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 
  [ 0, 30, "BZ" ], 1, 1, 3, 1, 2, [ 5, 20 ], 1, 2, 1, 1, 1, 2, 1, 2, 
  [ 0, 20, "BCH" ], [ 5, 24 ], 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 
  1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, [ 5, 39 ], 1, 
  [ 5, 38 ], [ 5, 39 ] ],
#V   n = 81
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], [ 0, 54, "D3" ], 2, [ 0, 51, "BCH" ], 2, 
  1, 1, [ 0, 45, "BCH" ], 1, 1, 1, 1, 2, 1, [ 0, 32, "BZ" ], 1, 3, 1, 1, 1, 
  1, [ 0, 26, "BZ" ], 1, 1, [ 0, 24, "BCH" ], 1, 1, 1, [ 0, 23, "BCH" ], 2, 
  [ 0, 21, "BCH" ], 3, 1, 1, 1, 1, 1, 1, [ 0, 17, "BCH" ], 1, 1, 1, 
  [ 0, 15, "BCH" ], 1, 1, 1, [ 0, 14, "BCH" ], 1, 1, 1, [ 0, 12, "BCH" ], 1, 
  [ 0, 11, "BCH" ], 2, 1, 1, [ 0, 9, "BCH" ], 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, [ 0, 5, "BCH" ], 1, 1, 1, 1 ],
#V   n = 82
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], 3, 2, 3, [ 0, 48, "YCh" ], 1, 1, 3, 1, 1, 
  1, 1, [ 0, 42, "YCh" ], 1, 3, 1, 3, 1, 2, 1, 1, 3, 1, 2, 3, 1, 1, 1, 3, 
  [ 0, 22, "BCH" ], 3, 3, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 3, 1, 3, [ 0, 10, "BCH" ], 1, 1, 3, 1, 1, 1, 1, [ 0, 8, "BCH" ], 
  [ 5, 36 ], 1, 1, 1, 1, 1, 3, [ 5, 40 ], 1, 1, [ 5, 40 ], 1 ],
#V   n = 83
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 27 ], 3, 2, 3, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 2, 
  1, 2, 1, 2, 1, 1, 2, 1, 2, 3, 1, 2, 1, 3, 3, 3, 3, 1, 2, 1, 1, 1, 1, 3, 1, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 3, 3, 1, 1, 3, 1, 1, 1, 1, 3, 2, 1, 1, 
  1, 1, 2, 3, 1, 1, 1, 1, 1, 1 ],
#V   n = 84
[ , [ 6, 4 ], [ 6, 13 ], 2, 3, [ 0, 54, "Gu" ], 3, [ 0, 49, "Gu" ], 1, 1, 3, 
  1, 1, 1, 1, 3, 1, [ 0, 34, "BZ" ], 1, [ 0, 32, "BZ" ], 1, [ 0, 30, "BZ" ], 
  2, 1, [ 0, 28, "BZ" ], 1, [ 0, 26, "BZ" ], 3, 1, [ 0, 24, "BZ" ], 1, 3, 3, 
  3, 3, 1, [ 0, 20, "BZ" ], 1, 1, 1, 1, [ 0, 18, "D1" ], 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 3, 1, 3, 3, 1, 1, 3, 1, 1, 1, 1, 3, [ 0, 7, "BZ" ], 1, 1, 1, 1, 
  [ 0, 6, "D3" ], 3, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 85
[ , [ 6, 4 ], [ 6, 7 ], 2, 2, 3, 3, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 3, 1, 3, 1, 
  3, [ 0, 29, "XB" ], 1, 3, 1, 3, 1, 1, 3, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 3, 3, 1, 1, 3, 1, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 86
[ , [ 6, 4 ], [ 6, 8 ], [ 6, 27 ], 2, 3, 3, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 3, 
  2, 3, 1, 3, 3, 2, 3, 1, 3, 1, 1, 3, 1, 3, 3, 1, 1, 1, 3, 1, 1, 2, 1, 3, 1, 
  2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 87
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 27 ], [ 0, 57, "Liz" ], 3, 2, 3, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 3, 2, 3, 1, 3, 1, 2, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 
  1, 2, 1, 3, 1, 2, 1, 1, 2, 1, 1, 3, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 88
[ , [ 6, 4 ], 2, 2, 3, 2, [ 0, 53, "GuB" ], 2, 2, 1, [ 0, 46, "Gu" ], 2, 1, 
  1, 1, 3, 1, 1, 2, 3, 1, 2, 1, [ 0, 30, "BZ" ], 3, 1, [ 0, 28, "BZ" ], 1, 1, 
  [ 0, 26, "BZ" ], 1, 1, [ 0, 24, "BZ" ], 1, 1, 1, [ 0, 22, "BZ" ], 1, 1, 
  [ 0, 20, "BZ" ], 1, 3, 1, [ 0, 18, "D1" ], 1, 1, [ 0, 16, "BZ" ], 1, 1, 3, 
  1, 1, 1, 3, 1, 1, [ 0, 12, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 89
[ , [ 6, 4 ], 2, 2, 2, 2, 3, 2, 2, 1, 3, 2, 1, 1, 1, 3, 1, 1, 2, 2, 1, 
  [ 0, 32, "XB" ], 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 1, 
  3, 1, 3, 1, 1, 3, 1, 1, [ 0, 15, "D1" ], 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 90
[ , [ 6, 4 ], 2, [ 6, 27 ], 2, [ 0, 57, "Gu" ], 2, [ 0, 52, "GuB" ], 
  [ 6, 45 ], 1, 3, 2, 1, 1, 1, 3, 1, 1, [ 0, 36, "BZ" ], [ 0, 34, "BZ" ], 2, 
  3, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 1, 1, 2, 3, 1, 1, 
  3, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, [ 0, 10, "BZ" ], 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 91
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], [ 0, 60, "HN" ], 3, [ 0, 55, "GB1" ], 3, 
  2, 1, 3, [ 0, 45, "Gu" ], 1, 1, 1, 3, 1, 2, 3, 3, 2, 3, 1, 2, 1, 1, 2, 1, 
  1, 2, 1, 1, 2, 1, 1, 1, 3, 1, 1, 2, 1, 1, 2, 3, 1, 1, 1, 2, 1, 3, 
  [ 0, 15, "BCH" ], 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 92
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 26 ], 3, 3, 3, 2, 2, 1, 2, 3, [ 6, 13 ], 1, 1, 
  3, 1, 2, 3, 3, [ 0, 34, "BZ" ], 3, 1, [ 0, 32, "BZ" ], 1, 1, 
  [ 0, 30, "BZ" ], 1, 1, [ 0, 28, "BZ" ], 1, 1, [ 0, 26, "BZ" ], 1, 1, 1, 1, 
  1, 1, [ 0, 22, "BZ" ], 1, 1, [ 0, 20, "BZ" ], 3, 1, 1, 1, 2, 1, 1, 3, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 93
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], 3, 2, 3, 2, 2, 1, 2, 3, [ 6, 14 ], 2, 1, 
  3, 1, [ 0, 38, "XB" ], 3, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, [ 0, 18, "D1" ], 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 94
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 3, 1, 3, 
  3, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 2, 1, 1, 1, 3, 1, 1, 3, 
  1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 95
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 32 ], 2, 2, [ 6, 14 ], 2, 2, 1, 2, 2, 1, 2, 1, 
  3, 1, 3, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 
  1, 1, 2, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 96
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 32 ], [ 0, 63, "D3" ], 2, 2, [ 0, 57, "GB1" ], 
  2, 2, [ 0, 51, "Gu" ], [ 0, 48, "BZ" ], 1, [ 0, 45, "BZ" ], [ 6, 15 ], 3, 
  1, [ 0, 39, "BZ" ], 3, 1, [ 0, 36, "BZ" ], 1, 1, [ 0, 34, "BZ" ], 1, 1, 
  [ 0, 32, "BZ" ], 1, 1, [ 0, 30, "BZ" ], 1, 1, [ 0, 28, "BZ" ], 1, 1, 
  [ 0, 26, "BZ" ], 1, 1, 1, [ 0, 24, "BZ" ], 1, 1, [ 0, 22, "BZ" ], 1, 1, 
  [ 0, 20, "BZ" ], 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 47 ], 
  1, 1, 1, 1 ],
#V   n = 97
[ , [ 6, 4 ], [ 6, 13 ], 2, 3, 2, 2, 3, 2, 2, 3, 3, 1, 3, [ 6, 16 ], 3, 1, 3, 
  1, 2, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 
  1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 98
[ , [ 6, 4 ], [ 6, 7 ], 2, 2, [ 0, 63, "Gu" ], [ 0, 60, "GB1" ], 3, 2, 2, 3, 
  2, 1, 2, 1, [ 6, 16 ], 1, 2, 1, 2, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 99
[ , [ 6, 4 ], [ 6, 8 ], [ 6, 27 ], 2, 3, 3, 2, [ 0, 57, "GB1" ], 
  [ 0, 54, "Gu" ], [ 0, 52, "Gu" ], 2, 1, 2, 1, [ 6, 17 ], 1, 2, 1, 2, 2, 1, 
  1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 3, 1, 1, 2, 1, 1, 2, 1, 
  1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, [ 0, 9, "XB" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 100
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 27 ], [ 0, 66, "HN1" ], 3, 3, [ 0, 59, "Gu" ], 
  3, 3, 3, [ 0, 51, "BZ" ], 1, [ 0, 48, "BZ" ], 1, [ 0, 45, "BZ" ], 1, 
  [ 0, 42, "BZ" ], 1, [ 0, 39, "BZ" ], [ 0, 38, "BZ" ], 1, 1, [ 0, 36, "BZ" ],
  1, 1, [ 0, 34, "BZ" ], 1, 1, [ 0, 32, "BZ" ], 1, 1, [ 0, 30, "BZ" ], 1, 1, 
  [ 0, 28, "BZ" ], 1, 1, 1, 1, 1, 1, [ 0, 24, "BZ" ], 1, 1, [ 0, 22, "BZ" ], 
  1, 1, [ 0, 20, "BZ" ], 1, 1, 1, 1, [ 0, 18, "D1" ], 1, 1, 1, 
  [ 0, 16, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 12, "BZ" ], 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 101
[ , [ 6, 4 ], 2, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 1, 3, 1, 3, 1, 3, 3, 1, 1, 
  3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 102
[ , [ 6, 4 ], 2, 1, 2, 2, [ 6, 21 ], 3, 3, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 
  3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 2, 1, 1, 1, 3, 1, 1, 
  3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 103
[ , [ 6, 4 ], 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 1, 
  2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 
  2, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 104
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 32 ], [ 0, 69, "BCH" ], [ 0, 66, "BZ" ], 2, 
  [ 0, 61, "GB1" ], 2, [ 0, 57, "BZ" ], 2, [ 0, 54, "BZ" ], 1, 
  [ 0, 51, "BZ" ], 1, [ 0, 48, "BZ" ], 1, [ 0, 45, "BZ" ], 1, [ 0, 42, "BZ" ],
  [ 0, 40, "BZ" ], [ 0, 39, "BZ" ], 1, [ 0, 38, "BZ" ], 1, 1, [ 0, 36, "BZ" ],
  1, 1, [ 0, 34, "BZ" ], 1, 1, [ 0, 32, "BZ" ], 1, 1, [ 0, 30, "BZ" ], 1, 1, 
  [ 0, 28, "BZ" ], 1, 1, 1, [ 0, 26, "BZ" ], 1, 1, [ 0, 24, "BZ" ], 1, 1, 
  [ 0, 22, "BZ" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, [ 5, 51 ], 1 ],
#V   n = 105
[ , [ 6, 4 ], [ 6, 13 ], 1, 3, 3, [ 0, 64, "GB1" ], 3, 2, 3, 2, 3, 1, 3, 1, 
  3, 1, 3, 1, 3, 3, 3, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 
  1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 10, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 106
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, 2, 3, 1, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 
  1, 2, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  3, 1, 1, 3, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 107
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, 2, [ 6, 26 ], 1, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 
  1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 3, 
  1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 108
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], [ 0, 72, "D3" ], [ 0, 69, "GB1" ], 
  [ 6, 27 ], 2, [ 0, 63, "GB1" ], [ 0, 60, "BZ" ], [ 0, 58, "Gu" ], 
  [ 0, 57, "BZ" ], 1, [ 0, 54, "BZ" ], 1, [ 0, 51, "BZ" ], 1, [ 0, 48, "BZ" ],
  1, [ 0, 45, "BZ" ], 1, [ 0, 42, "BZ" ], 1, [ 0, 40, "BZ" ], 1, 1, 
  [ 0, 38, "BZ" ], 1, 1, [ 0, 36, "BZ" ], 1, 1, [ 0, 34, "BZ" ], 1, 1, 
  [ 0, 32, "BZ" ], 1, 1, [ 0, 30, "BZ" ], 1, 1, 1, 1, 1, 1, [ 0, 26, "BZ" ], 
  1, 1, [ 0, 24, "BZ" ], 1, 1, [ 0, 22, "BZ" ], 1, 1, 1, [ 0, 20, "BZ" ], 1, 
  1, 1, 1, [ 0, 18, "BZ" ], 1, 1, 1, [ 0, 16, "BZ" ], 1, 1, 1, 1, 1, 
  [ 0, 14, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 109
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 27 ], 3, 3, 2, 2, 3, 3, 3, 3, 1, 3, 1, 3, 1, 3, 
  1, 3, 1, 3, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 110
[ , [ 6, 4 ], [ 6, 13 ], 1, 3, 2, 2, [ 0, 65, "Gu" ], 3, 2, 1, 2, 1, 2, 1, 2, 
  1, 2, 1, 2, 1, 2, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 
  2, 1, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 2, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 111
[ , [ 6, 4 ], [ 6, 7 ], 1, 2, 2, 2, 3, 3, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 
  2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 
  1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 3, 1, 1, 2, 1, 1, 1, 2, 1, 1, 3, 
  1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 112
[ , [ 6, 4 ], [ 6, 8 ], 1, 2, [ 6, 56 ], [ 0, 69, "GuB" ], [ 0, 66, "BZ" ], 
  1, 2, 1, [ 0, 60, "BZ" ], 1, [ 0, 57, "BZ" ], 2, [ 0, 54, "BZ" ], 1, 
  [ 0, 51, "BZ" ], 1, [ 0, 48, "BZ" ], 1, [ 0, 45, "BZ" ], 1, [ 0, 42, "BZ" ],
  1, 1, [ 0, 40, "BZ" ], 1, 1, [ 0, 38, "BZ" ], 1, 1, [ 0, 36, "BZ" ], 1, 1, 
  [ 0, 34, "BZ" ], 1, 1, [ 0, 32, "BZ" ], 1, 1, [ 0, 30, "BZ" ], 2, 1, 1, 
  [ 0, 28, "BZ" ], 1, 1, [ 0, 26, "BZ" ], 1, 1, [ 0, 24, "BZ" ], 1, 1, 
  [ 0, 22, "BZ" ], 1, 1, 1, [ 0, 20, "BZ" ], 1, 3, 1, 1, [ 0, 18, "BZ" ], 1, 
  1, 1, [ 0, 16, "BZ" ], 1, 1, [ 0, 15, "BZ" ], 1, 1, [ 0, 14, "BZ" ], 1, 1, 
  1, 1, [ 0, 12, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, [ 0, 6, "BZ" ], 1, 1, 1, 1, [ 5, 55 ], [ 5, 54 ], [ 5, 55 ], 1, 1 ],
#V   n = 113
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 27 ], [ 0, 75, "HN1" ], [ 6, 56 ], 3, 3, 1, 2, 
  1, 3, 1, 3, 2, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 
  3, 1, 1, 3, 1, 1, 3, [ 0, 29, "XB" ], 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 
  1, 1, 1, 3, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1 ],
#V   n = 114
[ , [ 6, 4 ], 2, 1, 3, [ 6, 56 ], 3, 1, 1, 2, 2, 3, 1, 3, 2, 3, 1, 3, 1, 3, 
  1, 3, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 3, 1, 1, 
  3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, [ 5, 55 ], [ 5, 56 ], 1, 1, 1 ],
#V   n = 115
[ , [ 6, 4 ], 2, 1, 2, 2, 2, 1, 1, 2, 2, 3, 1, 1, 2, 2, 1, 3, 1, 3, 1, 3, 1, 
  3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, [ 0, 30, "XB" ], 
  1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, [ 0, 10, "BZ" ], 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 116
[ , [ 6, 4 ], 2, 1, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 
  2, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 
  3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, [ 5, 57 ], 1, 1, 1, 1 ],
#V   n = 117
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 27 ], [ 0, 78, "D3" ], 2, [ 0, 72, "Gu" ], 1, 
  1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 
  1, 1, 2, 1, 1, 2, 1, 1, 2, 3, 1, 1, 3, 1, 1, [ 0, 27, "XB" ], 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 118
[ , [ 6, 4 ], [ 6, 13 ], 1, 3, 2, 3, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 
  [ 0, 54, "XB" ], 1, [ 0, 51, "XB" ], 1, [ 0, 48, "XB" ], 1, [ 0, 45, "XB" ],
  1, 1, [ 0, 42, "XB" ], 1, 1, [ 0, 40, "XB" ], 1, 1, [ 0, 38, "XB" ], 1, 1, 
  [ 0, 36, "XB" ], 1, 1, [ 0, 34, "XB" ], 1, 1, [ 0, 32, "XB" ], 3, 1, 1, 
  [ 0, 29, "XB" ], 1, 1, 3, 1, 1, [ 0, 26, "XB" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 119
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 3, 1, 3, 
  1, 3, 1, 3, 2, 1, 3, 1, 1, 3, 1, 2, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 3, 1, 1, 
  3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 120
[ , [ 6, 4 ], [ 6, 13 ], 1, 2, [ 0, 78, "Gu" ], [ 0, 74, "Gu" ], 1, 1, 2, 2, 
  1, 1, 1, 2, 2, 1, 3, 1, 3, 1, 3, 1, 3, 2, 1, 3, 1, 1, 1, 1, 2, 3, 1, 1, 3, 
  1, 1, 3, 1, 1, 3, 2, 1, 1, [ 0, 30, "BZ" ], 1, 1, [ 0, 28, "BZ" ], 1, 1, 3, 
  1, 1, 1, 1, [ 0, 24, "BZ" ], 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, [ 5, 55 ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 121
[ , [ 6, 4 ], [ 6, 13 ], 1, [ 0, 81, "BCH" ], 3, 3, 1, 1, [ 0, 72, "YCh" ], 
  2, 1, 1, 1, [ 0, 63, "BCH" ], 2, 1, 3, 1, 3, 1, 3, 1, 3, [ 0, 44, "XB" ], 
  1, 3, 1, 1, 1, 1, 2, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, [ 0, 32, "XB" ], 1, 1, 
  3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, [ 0, 23, "BCH" ], 1, 1, 1, 1, 
  [ 0, 21, "BCH" ], 1, 1, 1, 1, [ 0, 18, "BCH" ], 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  [ 0, 14, "BCH" ], 1, 1, 1, 1, [ 0, 12, "BCH" ], 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, [ 0, 8, "BCH" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  [ 0, 3, "Ham" ] ],
#V   n = 122
[ , [ 6, 4 ], [ 6, 9 ], [ 6, 32 ], 3, 3, 3, 1, 1, 3, [ 0, 68, "BCH" ], 1, 1, 
  1, 3, [ 0, 62, "BCH" ], 1, 3, 1, 3, 1, 3, 1, 3, 3, 1, 3, 1, 1, 1, 1, 
  [ 0, 41, "NBC" ], 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, [ 5, 38 ], 1, 1, 3, 1, 1, 
  1, 1, [ 0, 17, "BCH" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  [ 0, 11, "NBC" ], 1, 1, 1, 1, 1, 2, 1, 1, 3, [ 5, 56 ], [ 5, 56 ], 
  [ 5, 56 ], 1, 1, 1, 1, 1, 1, 1, [ 0, 5, "GaS" ], 1, 1, 1, 3 ],
#V   n = 123
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 32 ], 3, 3, [ 6, 42 ], 2, 1, 3, 3, 1, 2, 1, 3, 
  3, 1, 3, 1, 3, 1, 3, 1, 1, 2, 1, 2, 1, 1, 2, 1, 3, 2, 1, 1, 2, 1, 1, 2, 1, 
  1, 2, 3, 1, 1, 3, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 2, 1, 1, 3, 2, 1, 1, 1, 3, 2, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, [ 0, 9, "XB" ], 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 3, 1 ],
#V   n = 124
[ , [ 6, 4 ], [ 6, 7 ], 2, 3, 2, 2, 2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 2, 1, 2, 1, 
  2, 1, 1, 2, 1, [ 0, 44, "BZ" ], 1, 1, [ 0, 42, "BZ" ], 1, 3, 
  [ 0, 40, "BZ" ], 1, 1, [ 0, 38, "BZ" ], 1, 1, [ 0, 36, "BZ" ], 1, 1, 
  [ 0, 34, "BZ" ], 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 2, 1, 3, 1, 2, 1, 1, 3, [ 0, 18, "BZ" ], 1, 1, 1, 3, [ 5, 45 ], 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 3, 
  [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, [ 5, 61 ] ],
#V   n = 125
[ , [ 6, 4 ], [ 6, 8 ], 2, 3, 2, 2, 2, 2, 3, 3, 1, 2, 1, 3, 3, 1, 2, 1, 2, 1, 
  2, 1, 1, 2, 1, 3, 1, 1, 3, 1, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 1, [ 0, 30, "BZ" ], 1, 1, [ 0, 28, "BZ" ], 1, 3, 1, 1, 1, 1, 1, 
  [ 0, 24, "BZ" ], 1, 1, [ 0, 22, "BZ" ], 1, 3, 1, [ 0, 20, "BZ" ], 1, 1, 3, 
  3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 3, 1, 1, 3, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 126
[ , [ 6, 4 ], [ 6, 9 ], [ 0, 84, "D3" ], [ 6, 5 ], [ 0, 81, "vEH" ], 
  [ 0, 78, "GB1" ], [ 0, 75, "GuB" ], [ 0, 73, "GB1" ], 3, 3, 1, 
  [ 0, 66, "BZ" ], 1, 3, 3, 1, [ 0, 57, "XB" ], 1, [ 0, 54, "BZ" ], 1, 
  [ 0, 51, "XB" ], 1, 1, [ 0, 48, "BZ" ], 1, 3, 1, 1, 3, 1, 3, 3, 1, 1, 3, 1, 
  1, 3, 1, 1, 3, 1, 1, 2, 1, 1, 1, 2, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 3, 1, 3, 1, 3, 1, 1, 3, 3, [ 5, 42 ], 1, 1, 3, 1, 1, 1, 2, 3, 1, 1, 1, 
  1, 3, [ 5, 50 ], 1, 1, 1, 1, 3, [ 5, 54 ], 1, 1, 1, 1, 3, 1, 1, 3, 
  [ 5, 56 ], [ 5, 56 ], [ 5, 58 ], [ 5, 58 ], [ 5, 58 ], [ 5, 58 ], 
  [ 5, 58 ], 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, [ 5, 62 ] ],
#V   n = 127
[ , [ 6, 4 ], 2, 3, [ 6, 6 ], 3, 3, 3, 3, 3, 3, 1, 3, 1, 3, 3, 2, 3, 2, 3, 2, 
  3, 1, 1, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 
  1, 1, 2, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 1, 3, 1, 3, 1, 1, 3, 
  3, 1, 1, 1, 3, 1, 1, 1, 2, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 3, 1, 1, 3, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 128
[ , [ 6, 4 ], 2, [ 6, 8 ], [ 6, 20 ], 3, 2, 2, 3, 3, 3, 1, 3, 1, 3, 3, 2, 3, 
  [ 0, 55, "BZ" ], 3, 2, 3, 1, 1, 3, 2, [ 0, 46, "BZ" ], 1, 1, 
  [ 0, 44, "BZ" ], 1, 1, [ 0, 42, "BZ" ], 1, 1, [ 0, 40, "BZ" ], 1, 1, 
  [ 0, 38, "BZ" ], [ 5, 32 ], 1, [ 0, 36, "BZ" ], 1, 1, [ 0, 34, "BZ" ], 3, 
  1, 1, [ 0, 32, "BZ" ], 3, 3, 1, 1, 2, 1, 1, 2, 3, 1, 1, [ 0, 25, "XB" ], 3, 
  1, 1, 2, 1, 1, 3, 1, [ 5, 38 ], 3, 3, [ 5, 43 ], [ 5, 43 ], [ 5, 43 ], 3, 
  3, 1, 1, [ 0, 16, "BZ" ], 3, [ 5, 48 ], [ 5, 45 ], [ 5, 46 ], [ 5, 47 ], 3, 
  [ 5, 51 ], [ 5, 51 ], [ 5, 51 ], 1, 1, 3, [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], 
  1, 1, 3, [ 5, 57 ], 1, 3, [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], 
  [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], 1, 3, [ 5, 59 ], 
  [ 5, 59 ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], 
  [ 5, 63 ], [ 5, 63 ], [ 5, 63 ] ],
#V   n = 129
[ , [ 6, 4 ], 2, [ 6, 9 ], [ 6, 8 ], 3, 2, 2, 2, 3, 3, 1, 3, 1, 3, 3, 2, 3, 
  3, 3, 2, 3, 3, 1, 3, 2, 3, 3, 1, 3, 3, 1, 3, 3, 1, 3, 3, 1, 3, 1, 1, 3, 3, 
  1, 3, 3, 3, 1, 3, 3, 3, 3, 1, 2, 3, 1, 2, 3, 3, 1, 3, 3, 3, 1, 2, 3, 1, 2, 
  1, 1, 3, 3, 1, 1, 1, 3, 3, 3, 1, 3, 3, 1, 2, 3, 1, 3, 1, 1, 1, 3, 1, 3, 1, 
  1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 2, 1 ],
#V   n = 130
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 10 ], [ 6, 49 ], [ 6, 10 ], [ 0, 81, "Gu" ], 
  [ 0, 78, "Gu" ], [ 0, 75, "GuB" ], 3, 3, 3, 3, 3, 3, 3, [ 0, 60, "BZ" ], 3, 
  3, 3, [ 0, 54, "BZ" ], [ 0, 52, "BZ" ], 3, 3, 3, [ 0, 48, "BZ" ], 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, [ 5, 32 ], [ 5, 32 ], 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, [ 0, 30, "BZ" ], 3, 3, [ 0, 28, "BZ" ], 3, 3, 3, 
  [ 0, 26, "BZ" ], 3, 3, 3, [ 0, 24, "BZ" ], 3, 3, [ 0, 22, "BZ" ], 3, 
  [ 5, 38 ], 3, 3, [ 5, 44 ], [ 5, 44 ], [ 5, 44 ], [ 5, 44 ], 3, 3, 3, 3, 3, 
  [ 5, 49 ], [ 5, 49 ], [ 5, 49 ], 3, 3, [ 5, 52 ], [ 5, 52 ], [ 5, 52 ], 
  [ 5, 52 ], 3, 3, [ 5, 56 ], [ 5, 56 ], [ 5, 56 ], [ 5, 56 ], [ 5, 56 ], 3, 
  [ 5, 56 ], [ 5, 56 ], 3, [ 5, 58 ], [ 5, 58 ], [ 5, 58 ], [ 5, 58 ], 
  [ 5, 58 ], [ 5, 58 ], [ 5, 60 ], [ 5, 60 ], [ 5, 60 ], [ 5, 60 ], 
  [ 5, 60 ], [ 5, 60 ], [ 5, 60 ], [ 5, 60 ], [ 5, 60 ], 3, 3, 3, 3, 
  [ 5, 64 ], [ 5, 64 ], [ 5, 64 ], [ 5, 64 ] ]];

GUAVA_BOUNDS_TABLE[2][3] := [
#V   n = 1
[  ],
#V   n = 2
[  ],
#V   n = 3
[  ],
#V   n = 4
[  ],
#V   n = 5
[ ,, [ 14, 3 ] ],
#V   n = 6
[ ,,, [ 14, 4 ] ],
#V   n = 7
[ ,,,, [ 14, 5 ] ],
#V   n = 8
[ ,,,,, [ 14, 6 ] ],
#V   n = 9
[ ,,,,,, [ 14, 7 ] ],
#V   n = 10
[ ,,,,,,, [ 14, 8 ] ],
#V   n = 11
[ ,,,,,, [ 14, 6 ],, [ 14, 9 ] ],
#V   n = 12
[ ,,, [ 14, 3 ],,, [ 14, 6 ], [ 14, 7 ],, [ 14, 10 ] ],
#V   n = 13
[ ,,, [ 14, 3 ], [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ],, [ 14, 11 ] ],
#V   n = 14
[ ,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], 
  [ 14, 9 ], [ 14, 12 ] ],
#V   n = 15
[ ,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], [ 0, 5, "vE" ], [ 0, 4, "vE" ], 
  [ 14, 9 ], [ 14, 10 ], [ 14, 10 ], [ 14, 13 ] ],
#V   n = 16
[ ,,,,, [ 0, 7, "vE" ], [ 0, 6, "vE" ], [ 14, 7 ], 11, 11, [ 14, 10 ], 
  [ 14, 11 ], [ 14, 11 ], [ 14, 14 ] ],
#V   n = 17
[ ,,,,, 12, 11, 11, [ 14, 8 ], 11, 11, [ 14, 11 ], [ 14, 12 ], [ 14, 12 ], 
  [ 14, 15 ] ],
#V   n = 18
[ ,,,,,, 12, 11, 11, [ 14, 9 ], 11, 11, [ 14, 12 ], [ 14, 13 ], [ 14, 13 ], 
  [ 14, 16 ] ],
#V   n = 19
[ ,,,,, [ 14, 4 ],, 12, 11, 11, [ 14, 10 ], 11, 11, [ 14, 13 ], [ 14, 14 ], 
  [ 14, 14 ], [ 14, 17 ] ],
#V   n = 20
[ ,,,,, [ 14, 4 ], [ 14, 5 ],, [ 14, 6 ], 11, 11, [ 14, 11 ], 11, 11, 
  [ 14, 14 ], [ 14, 15 ], [ 14, 15 ], [ 14, 18 ] ],
#V   n = 21
[ ,,, [ 0, 12, "HN" ],, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, [ 14, 7 ], 11, 11, 
  [ 14, 12 ], 11, 11, [ 0, 3, "Ga" ], [ 14, 16 ], [ 14, 16 ], [ 14, 19 ] ],
#V   n = 22
[ ,,, 12, 11,, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ],, 12, 11, 11, [ 14, 13 ], 11, 
  11, 11, [ 14, 17 ], [ 14, 17 ], [ 14, 20 ] ],
#V   n = 23
[ ,,, 12, [ 14, 3 ], 11,, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ],, [ 14, 9 ], 11, 
  11, [ 14, 14 ], 11, 11, 11, [ 14, 18 ], [ 14, 18 ], [ 14, 21 ] ],
#V   n = 24
[ ,,,, [ 14, 3 ], [ 14, 4 ], 11,, [ 14, 7 ], [ 14, 8 ], [ 14, 9 ],, 
  [ 14, 10 ], 11, 11, [ 14, 15 ], 11, 11, 11, [ 14, 19 ], [ 14, 19 ], 
  [ 14, 22 ] ],
#V   n = 25
[ ,,,,, [ 14, 4 ], [ 14, 5 ], 11,, [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], 
  [ 0, 8, "LP" ], [ 14, 11 ], 11, 11, [ 14, 16 ], 11, 11, 11, [ 14, 20 ], 
  [ 14, 20 ], [ 14, 23 ] ],
#V   n = 26
[ ,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 6 ], 11,, [ 14, 9 ], [ 14, 10 ], 
  [ 14, 11 ], 11, [ 14, 12 ], 11, 11, [ 14, 17 ], 11, 11, 11, [ 14, 21 ], 
  [ 14, 21 ], [ 14, 24 ] ],
#V   n = 27
[ ,,,, [ 14, 3 ], [ 14, 4 ],, [ 14, 6 ], [ 14, 6 ], 11,, [ 14, 10 ], 
  [ 14, 11 ], [ 14, 12 ], 11, [ 14, 13 ], 11, 11, [ 14, 18 ], 11, 11, 11, 
  [ 14, 22 ], [ 14, 22 ], [ 14, 25 ] ],
#V   n = 28
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ],, 12, [ 14, 7 ], 11,, [ 14, 11 ], 
  [ 14, 12 ], [ 14, 13 ], 11, [ 14, 12 ], [ 14, 12 ], 11, [ 14, 19 ], 11, 11, 
  11, [ 14, 23 ], [ 14, 23 ], [ 14, 26 ] ],
#V   n = 29
[ ,,,,, [ 0, 16, "vE" ], [ 14, 5 ], [ 14, 6 ], 12, 12, [ 14, 8 ], 11,, 
  [ 14, 12 ], [ 14, 13 ], [ 14, 14 ], 11, 11, [ 14, 13 ], 11, [ 14, 20 ], 11, 
  11, 11, [ 14, 24 ], [ 14, 24 ], [ 14, 27 ] ],
#V   n = 30
[ ,,,,, 12, 11, [ 14, 6 ], [ 14, 7 ], 12, 12, [ 14, 9 ], 11,, [ 14, 13 ], 
  [ 14, 14 ], [ 14, 15 ], 11, 11, [ 14, 14 ], 11, [ 14, 21 ], 11, 11, 11, 
  [ 14, 25 ], [ 14, 25 ], [ 14, 28 ] ],
#V   n = 31
[ ,,,, [ 14, 3 ],, 12, 11, [ 14, 7 ], [ 14, 8 ], [ 14, 7 ], [ 14, 8 ], 
  [ 14, 10 ], 11,, [ 14, 14 ], [ 14, 12 ], [ 14, 16 ], 11, [ 14, 15 ], 
  [ 14, 15 ], 11, [ 14, 16 ], 11, 11, 11, [ 14, 26 ], [ 14, 26 ], [ 14, 29 ] 
 ],
#V   n = 32
[ ,,,, [ 14, 3 ], [ 14, 4 ],, 12, 11, [ 14, 6 ], [ 14, 9 ], [ 14, 8 ], 
  [ 14, 9 ], [ 14, 11 ], 11,, [ 14, 12 ], 13, [ 14, 17 ], 11, [ 14, 16 ], 
  [ 14, 16 ], 11, 11, 11, 11, 11, [ 14, 27 ], [ 14, 27 ], [ 14, 30 ] ],
#V   n = 33
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ],, 12, 11, [ 14, 7 ], [ 14, 10 ], 
  [ 14, 9 ], [ 14, 10 ], [ 14, 12 ], 11, [ 14, 12 ], [ 0, 9, "LP" ], 13, 
  [ 14, 18 ], 11, [ 14, 17 ], [ 14, 17 ], 11, [ 14, 18 ], [ 0, 4, "BKn" ], 
  11, 11, [ 14, 28 ], [ 14, 28 ], [ 14, 31 ] ],
#V   n = 34
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, [ 14, 6 ], 11, [ 14, 8 ], 
  [ 14, 11 ], [ 14, 10 ], [ 14, 11 ], [ 14, 13 ], 11, 12, 11, [ 14, 15 ], 
  [ 14, 19 ], 11, [ 14, 18 ], [ 14, 18 ], 11, [ 14, 19 ], 11, 11, 11, 
  [ 14, 29 ], [ 14, 29 ], [ 14, 32 ] ],
#V   n = 35
[ ,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ],, [ 14, 7 ], 11, 
  [ 14, 9 ], [ 14, 12 ], [ 14, 11 ], [ 14, 12 ], [ 14, 14 ], 12, 12, 11, 
  [ 14, 16 ], [ 14, 20 ], 11, [ 14, 19 ], [ 14, 19 ], 11, [ 14, 20 ], 11, 11, 
  11, [ 14, 30 ], [ 14, 30 ], [ 14, 33 ] ],
#V   n = 36
[ ,,,, [ 14, 3 ], [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ],, [ 14, 8 ], 
  11, [ 14, 10 ], [ 14, 13 ], [ 14, 12 ], [ 14, 13 ], [ 14, 15 ], 12, 12, 11, 
  [ 14, 17 ], [ 14, 21 ], 11, [ 14, 20 ], [ 14, 20 ], 11, [ 14, 21 ], 11, 11, 
  11, [ 14, 31 ], [ 14, 31 ], [ 14, 34 ] ],
#V   n = 37
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], [ 14, 6 ], [ 14, 9 ], 
  [ 0, 17, "LP" ], [ 14, 9 ], 11, [ 14, 11 ], [ 14, 14 ], [ 14, 13 ], 
  [ 14, 14 ], [ 14, 16 ], 12, 12, 11, [ 14, 18 ], [ 14, 22 ], 11, [ 14, 21 ], 
  [ 14, 21 ], 11, [ 14, 22 ], 11, 11, 11, [ 14, 32 ], [ 14, 32 ], [ 14, 35 ] 
 ],
#V   n = 38
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 10 ], 
  11, [ 14, 9 ], 11, [ 14, 12 ], [ 14, 15 ], [ 14, 14 ], [ 14, 15 ], 
  [ 14, 17 ], 12, 12, 11, [ 14, 19 ], [ 14, 23 ], 11, [ 14, 22 ], [ 14, 22 ], 
  11, [ 14, 23 ], 11, 11, 11, [ 14, 33 ], [ 14, 33 ], [ 14, 36 ] ],
#V   n = 39
[ ,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], [ 14, 6 ], [ 14, 7 ], 
  [ 14, 8 ], [ 14, 11 ], 11, [ 14, 10 ], 11, [ 14, 13 ], [ 14, 16 ], 
  [ 14, 15 ], [ 14, 16 ], [ 14, 18 ], 12, 12, 11, [ 14, 20 ], [ 14, 24 ], 11, 
  [ 14, 23 ], [ 14, 23 ], 11, [ 14, 24 ], 11, 11, 11, [ 14, 34 ], [ 14, 34 ], 
  [ 14, 37 ] ],
#V   n = 40
[ ,,,, [ 14, 3 ], [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], [ 14, 7 ], 
  [ 14, 8 ], [ 14, 9 ], [ 14, 12 ], 11, [ 14, 11 ], 11, [ 14, 14 ], 
  [ 14, 17 ], [ 14, 16 ], [ 14, 17 ], [ 14, 19 ], 12, 12, 11, [ 14, 21 ], 
  [ 0, 8, "LP" ], 11, [ 14, 24 ], [ 14, 24 ], 11, [ 14, 25 ], 11, 11, 11, 
  [ 14, 35 ], [ 14, 35 ], [ 14, 38 ] ],
#V   n = 41
[ ,,,, [ 0, 25, "HN" ], [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], [ 14, 6 ], 
  [ 14, 9 ], [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], [ 14, 13 ], 11, [ 14, 12 ], 
  11, [ 14, 15 ], [ 14, 18 ], [ 14, 17 ], [ 14, 18 ], [ 14, 20 ], 12, 12, 11, 
  [ 14, 22 ], 11, 11, [ 14, 25 ], [ 14, 25 ], 11, [ 14, 26 ], 11, 11, 11, 
  [ 14, 27 ], [ 14, 36 ], [ 14, 39 ] ],
#V   n = 42
[ ,,,, 12, 11, [ 14, 5 ], [ 14, 6 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 10 ], 
  [ 14, 9 ], [ 14, 10 ], [ 14, 11 ], [ 14, 14 ], 11, [ 14, 13 ], 11, 
  [ 14, 16 ], [ 0, 14, "BKn" ], [ 14, 18 ], [ 14, 19 ], [ 14, 21 ], 12, 12, 
  11, [ 14, 23 ], 11, 11, [ 14, 26 ], [ 14, 26 ], 11, [ 14, 27 ], 11, 11, 11, 
  [ 14, 28 ], [ 14, 37 ], [ 14, 40 ] ],
#V   n = 43
[ ,,,,, 12, 11, [ 14, 6 ], [ 14, 7 ], [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], 
  [ 14, 11 ], [ 14, 10 ], [ 14, 11 ], [ 14, 12 ], [ 14, 15 ], 11, [ 14, 14 ], 
  11, [ 14, 17 ], 11, [ 14, 19 ], [ 14, 16 ], [ 14, 22 ], 12, 12, 11, 
  [ 14, 24 ], 11, 11, [ 14, 27 ], [ 14, 27 ], 11, [ 14, 28 ], 11, 11, 11, 
  [ 14, 29 ], [ 14, 38 ], [ 14, 41 ] ],
#V   n = 44
[ ,,,,,, 12, 11, [ 14, 7 ], [ 14, 8 ], [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], 
  [ 14, 12 ], [ 14, 11 ], [ 14, 12 ], [ 14, 13 ], [ 14, 16 ], 11, [ 14, 15 ], 
  11, [ 14, 18 ], 11, [ 14, 16 ], [ 14, 17 ], [ 14, 23 ], 12, 12, 11, 
  [ 14, 25 ], 11, 11, [ 14, 28 ], [ 14, 28 ], 11, [ 14, 29 ], 11, 11, 11, 
  [ 14, 30 ], [ 14, 39 ], [ 14, 42 ] ],
#V   n = 45
[ ,,,,,,, 12, 11, [ 14, 6 ], [ 14, 9 ], [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], 
  [ 14, 13 ], [ 14, 12 ], [ 14, 13 ], [ 14, 14 ], [ 14, 17 ], 11, [ 14, 16 ], 
  11, [ 14, 19 ], 11, 12, 11, [ 14, 24 ], 12, 12, 11, [ 14, 26 ], 11, 11, 
  [ 14, 29 ], [ 14, 29 ], 11, [ 14, 30 ], 11, 11, 11, [ 14, 31 ], [ 14, 40 ], 
  [ 14, 43 ] ],
#V   n = 46
[ ,,,,,,,, 12, 11, [ 14, 7 ], [ 14, 10 ], [ 14, 9 ], [ 14, 10 ], [ 14, 11 ], 
  [ 14, 14 ], [ 14, 13 ], [ 14, 14 ], [ 14, 15 ], [ 14, 18 ], 11, [ 14, 17 ], 
  11, [ 14, 20 ], 11, 11, 11, [ 14, 25 ], 12, 12, 11, [ 14, 27 ], 11, 11, 
  [ 14, 30 ], [ 14, 30 ], 11, [ 14, 31 ], 11, 11, 11, [ 14, 32 ], [ 14, 41 ], 
  [ 14, 44 ] ],
#V   n = 47
[ ,,,,,, [ 14, 4 ],,, [ 14, 6 ], 11, [ 14, 8 ], [ 0, 23, "BKn" ], [ 14, 10 ], 
  [ 14, 11 ], [ 14, 12 ], [ 0, 20, "LP" ], [ 14, 14 ], [ 14, 15 ], 
  [ 14, 16 ], [ 14, 19 ], 11, [ 14, 18 ], 11, [ 14, 21 ], 11, 11, 11, 
  [ 14, 26 ], 12, 12, 11, [ 14, 28 ], 11, 11, [ 14, 31 ], [ 14, 31 ], 11, 
  [ 14, 32 ], 11, 11, 11, [ 14, 33 ], [ 14, 42 ], [ 14, 45 ] ],
#V   n = 48
[ ,,,,,, [ 14, 4 ], [ 14, 5 ],, 12, [ 14, 7 ], 11, [ 14, 9 ], 11, [ 14, 11 ], 
  [ 14, 12 ], [ 14, 13 ], 11, [ 14, 15 ], [ 14, 16 ], [ 14, 17 ], [ 14, 20 ], 
  11, [ 14, 19 ], 11, [ 14, 22 ], 11, 11, [ 14, 21 ], [ 14, 27 ], 12, 12, 11, 
  [ 14, 29 ], 11, 11, [ 14, 32 ], [ 14, 32 ], 11, [ 14, 33 ], 11, 11, 11, 
  [ 14, 34 ], [ 14, 43 ], [ 14, 46 ] ],
#V   n = 49
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, 12, [ 14, 8 ], 11, [ 14, 10 ], 11, 
  [ 14, 12 ], [ 14, 13 ], [ 14, 14 ], 11, [ 14, 16 ], [ 14, 17 ], [ 14, 18 ], 
  [ 14, 21 ], 11, [ 14, 20 ], 11, [ 14, 23 ], 11, 12, [ 14, 22 ], [ 14, 28 ], 
  12, 12, 11, [ 14, 30 ], 11, 11, [ 14, 33 ], [ 14, 33 ], 11, [ 14, 34 ], 11, 
  11, 11, [ 14, 35 ], [ 14, 44 ], [ 14, 47 ] ],
#V   n = 50
[ ,,,,,,, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ],, 12, [ 14, 9 ], 11, [ 14, 11 ], 
  11, [ 14, 13 ], [ 14, 14 ], [ 14, 15 ], 11, [ 14, 17 ], [ 14, 18 ], 
  [ 14, 19 ], [ 14, 22 ], 11, [ 14, 21 ], [ 14, 18 ], [ 0, 14, "BKn" ], 11, 
  12, [ 14, 23 ], [ 14, 29 ], 12, 12, 11, [ 14, 31 ], 11, 11, [ 14, 34 ], 
  [ 14, 34 ], 11, [ 14, 35 ], 11, 11, 11, [ 14, 36 ], [ 14, 45 ], [ 14, 48 ] 
 ],
#V   n = 51
[ ,,,, [ 0, 32, "HHY" ],, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ],, 12, 
  [ 14, 10 ], 11, [ 14, 12 ], 11, [ 14, 14 ], [ 14, 15 ], [ 14, 16 ], 11, 
  [ 14, 18 ], [ 14, 19 ], [ 14, 20 ], [ 14, 23 ], 11, [ 14, 22 ], 12, 11, 11, 
  12, [ 14, 24 ], [ 14, 30 ], 12, 12, 11, [ 14, 32 ], 11, 11, [ 0, 6, "BKn" ],
  [ 14, 35 ], 11, [ 14, 36 ], 11, 11, 11, [ 14, 37 ], [ 14, 46 ], [ 14, 49 ] 
 ],
#V   n = 52
[ ,,,,, 11, [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], [ 14, 8 ], [ 14, 9 ],, 12, 
  [ 14, 11 ], 11, [ 14, 13 ], 11, [ 14, 15 ], [ 14, 16 ], [ 14, 17 ], 11, 
  [ 14, 19 ], [ 14, 20 ], [ 14, 21 ], [ 14, 24 ], 11, [ 14, 23 ], 12, 11, 11, 
  12, [ 14, 25 ], [ 14, 31 ], 12, 12, 11, [ 14, 33 ], 11, 12, 11, [ 14, 36 ], 
  11, [ 14, 37 ], 11, 11, 11, [ 14, 38 ], [ 14, 47 ], [ 14, 50 ] ],
#V   n = 53
[ ,,,,,, 11, [ 14, 5 ], [ 14, 6 ],, [ 14, 8 ], [ 14, 9 ], [ 14, 10 ],, 12, 
  [ 14, 12 ], 11, [ 14, 14 ], 11, [ 14, 16 ], [ 14, 17 ], [ 14, 18 ], 11, 
  [ 14, 20 ], [ 14, 21 ], [ 14, 22 ], [ 14, 25 ], 11, [ 14, 24 ], [ 14, 20 ], 
  11, 11, 12, [ 14, 26 ], [ 14, 32 ], 12, 12, 11, [ 0, 8, "BKn" ], 11, 12, 
  11, [ 14, 37 ], 11, [ 14, 38 ], 11, 11, 11, [ 14, 39 ], [ 14, 48 ], 
  [ 14, 51 ] ],
#V   n = 54
[ ,,,,,,, 11, [ 14, 6 ], [ 14, 7 ],, [ 14, 9 ], [ 14, 10 ], [ 14, 11 ],, 13, 
  [ 14, 13 ], 11, [ 14, 15 ], 11, [ 14, 17 ], [ 14, 18 ], [ 14, 19 ], 11, 
  [ 14, 21 ], [ 14, 17 ], [ 14, 23 ], [ 0, 17, "LP" ], 11, [ 14, 25 ], 12, 
  11, 11, [ 14, 23 ], [ 14, 27 ], [ 14, 33 ], 12, 12, 11, 11, 11, 12, 11, 
  [ 14, 38 ], 11, [ 14, 39 ], 11, 11, 11, [ 14, 40 ], [ 14, 49 ], [ 14, 52 ] 
 ],
#V   n = 55
[ ,,,,,, [ 14, 4 ],, 11, [ 14, 7 ], [ 14, 8 ], [ 0, 29, "LP" ], [ 14, 10 ], 
  [ 14, 8 ], [ 14, 12 ], [ 0, 26, "BKn" ], 13, [ 14, 14 ], 11, [ 14, 16 ], 
  11, [ 14, 18 ], [ 14, 19 ], [ 14, 20 ], 11, [ 14, 17 ], [ 14, 18 ], 
  [ 14, 24 ], 11, [ 0, 16, "BKn" ], [ 14, 26 ], 12, 11, 11, 12, [ 14, 28 ], 
  [ 14, 34 ], 12, 13, 11, 11, 11, 12, 11, [ 14, 39 ], 11, [ 14, 40 ], 11, 11, 
  11, [ 14, 41 ], [ 14, 50 ], [ 14, 53 ] ],
#V   n = 56
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 0, 32, "LP" ], 11, [ 14, 8 ], [ 14, 9 ], 11, 
  [ 14, 8 ], [ 14, 9 ], [ 14, 13 ], 11, 13, [ 14, 15 ], 11, [ 14, 17 ], 11, 
  [ 14, 19 ], [ 14, 20 ], [ 14, 21 ], 11, [ 14, 18 ], [ 14, 19 ], [ 14, 25 ], 
  11, 11, [ 14, 27 ], 12, 11, 11, [ 14, 25 ], [ 14, 29 ], [ 14, 35 ], 
  [ 0, 10, "LP" ], 13, 11, 11, 11, 12, 11, [ 14, 40 ], 11, [ 14, 41 ], 11, 
  11, 11, [ 14, 42 ], [ 14, 51 ], [ 14, 54 ] ],
#V   n = 57
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], 11, [ 0, 31, "BKn" ], [ 14, 9 ], 
  [ 14, 10 ], 11, [ 14, 9 ], 11, [ 14, 14 ], 11, 13, [ 14, 16 ], 11, 
  [ 14, 18 ], 11, [ 14, 20 ], [ 14, 16 ], [ 14, 22 ], 11, [ 14, 19 ], 
  [ 14, 20 ], [ 14, 26 ], 11, 11, [ 14, 28 ], [ 14, 24 ], 11, 11, 12, 
  [ 14, 30 ], 12, 11, 13, 11, 11, 11, 12, 11, [ 14, 41 ], 11, [ 0, 4, "BKn" ],
  11, [ 14, 36 ], 11, [ 14, 43 ], [ 14, 52 ], [ 14, 55 ] ],
#V   n = 58
[ ,,,,,, [ 0, 35, "BKn" ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], 11, 11, 
  [ 0, 30, "LP" ], [ 14, 11 ], 11, 11, [ 14, 11 ], [ 14, 15 ], 11, 13, 
  [ 14, 17 ], 11, [ 14, 19 ], 11, [ 14, 16 ], [ 14, 17 ], [ 14, 23 ], 11, 
  [ 14, 20 ], [ 14, 21 ], [ 14, 27 ], 11, 11, [ 14, 29 ], 12, 11, 11, 
  [ 14, 27 ], [ 14, 31 ], 12, 11, 13, 11, 11, 11, 12, 11, [ 14, 42 ], 12, 11, 
  11, [ 14, 37 ], 11, [ 14, 44 ], [ 14, 53 ], [ 14, 56 ] ],
#V   n = 59
[ ,,,,, [ 14, 3 ],, 11, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], 11, 11, 11, 
  [ 14, 12 ], 11, [ 14, 11 ], [ 14, 12 ], [ 14, 16 ], 11, 13, [ 14, 18 ], 11, 
  [ 0, 23, "BKn" ], 11, [ 14, 17 ], [ 14, 18 ], [ 14, 24 ], 11, [ 14, 21 ], 
  [ 14, 22 ], [ 14, 28 ], 11, 11, [ 14, 30 ], [ 14, 26 ], 11, 11, [ 14, 28 ], 
  [ 14, 32 ], 12, 11, 13, 11, 11, 11, 12, 11, [ 14, 43 ], 12, 11, 11, 
  [ 14, 38 ], 11, [ 14, 45 ], [ 14, 54 ], [ 14, 57 ] ],
#V   n = 60
[ ,,,,, [ 14, 3 ], [ 14, 4 ],, 11, [ 0, 34, "BKn" ], [ 0, 33, "BKn" ], 
  [ 14, 9 ], 11, 11, 11, [ 14, 13 ], 11, [ 14, 12 ], [ 14, 13 ], [ 14, 17 ], 
  11, [ 0, 25, "BKn" ], [ 14, 19 ], 12, 11, 11, [ 14, 18 ], [ 14, 19 ], 
  [ 14, 25 ], 11, [ 14, 22 ], [ 14, 23 ], [ 14, 29 ], 11, 11, [ 14, 31 ], 
  [ 14, 27 ], 11, 11, [ 0, 12, "BKn" ], [ 14, 33 ], 12, 11, 13, 11, 11, 11, 
  12, 11, [ 14, 44 ], 12, 11, 11, [ 14, 39 ], 11, [ 14, 46 ], [ 14, 55 ], 
  [ 14, 58 ] ],
#V   n = 61
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ],, 11, 11, 11, [ 14, 10 ], 11, 11, 11, 
  [ 0, 29, "BKn" ], 11, [ 14, 13 ], [ 14, 14 ], [ 14, 18 ], 11, 11, 
  [ 14, 20 ], [ 14, 16 ], 11, 11, [ 14, 19 ], [ 14, 20 ], [ 0, 20, "LP" ], 
  11, [ 14, 23 ], [ 14, 24 ], [ 14, 30 ], 11, 11, [ 14, 32 ], [ 14, 28 ], 11, 
  12, 11, [ 14, 34 ], 12, 11, 13, 11, 11, 11, [ 14, 33 ], 11, [ 14, 45 ], 12, 
  11, 11, [ 14, 40 ], 11, [ 14, 47 ], [ 14, 56 ], [ 14, 59 ] ],
#V   n = 62
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, 11, 11, 11, [ 0, 32, "BKn" ], 11, 
  11, 11, 11, 11, [ 14, 14 ], [ 14, 15 ], [ 14, 19 ], 11, 11, [ 14, 21 ], 
  [ 14, 17 ], 11, 11, [ 14, 20 ], [ 14, 21 ], 11, 11, [ 14, 24 ], [ 14, 25 ], 
  [ 14, 31 ], 11, 11, [ 14, 33 ], [ 14, 29 ], 11, 12, 11, [ 14, 35 ], 12, 11, 
  13, 11, 11, 11, [ 14, 34 ], 11, [ 14, 46 ], 12, 11, 11, [ 14, 41 ], 11, 
  [ 14, 48 ], [ 14, 57 ], [ 14, 60 ] ],
#V   n = 63
[ ,,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], [ 0, 35, "BKn" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, [ 14, 15 ], [ 14, 16 ], [ 14, 20 ], 11, 11, 
  [ 14, 22 ], [ 14, 18 ], 11, 11, [ 14, 21 ], [ 14, 22 ], 11, 11, [ 14, 25 ], 
  [ 14, 26 ], [ 14, 32 ], 11, 11, [ 14, 34 ], [ 14, 30 ], 11, 12, 11, 
  [ 14, 36 ], 12, 11, 13, 11, 11, 11, [ 14, 35 ], 11, [ 14, 47 ], 12, 11, 11, 
  [ 14, 42 ], 11, [ 14, 49 ], [ 14, 58 ], [ 14, 61 ] ],
#V   n = 64
[ ,,,,, [ 14, 3 ], [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], 11, 11, 11, 
  11, 11, [ 0, 31, "BKn" ], 11, 11, 11, 11, [ 14, 16 ], [ 14, 17 ], 
  [ 14, 21 ], 11, 11, [ 14, 23 ], [ 14, 19 ], 11, [ 0, 22, "BKn" ], 
  [ 14, 22 ], [ 14, 23 ], 11, 11, [ 14, 26 ], [ 14, 27 ], [ 14, 33 ], 
  [ 0, 16, "BKn" ], 11, [ 14, 35 ], [ 14, 31 ], 11, 12, 11, [ 14, 37 ], 12, 
  11, [ 14, 32 ], 11, 11, 11, [ 14, 36 ], 11, [ 14, 48 ], 12, 11, 11, 
  [ 14, 43 ], 11, [ 14, 50 ], [ 14, 59 ], [ 14, 62 ] ],
#V   n = 65
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], [ 14, 6 ], [ 14, 9 ], 
  11, [ 0, 34, "BKn" ], 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 17 ], 
  [ 14, 18 ], [ 14, 22 ], 11, 11, [ 14, 24 ], [ 14, 20 ], 11, 11, [ 14, 23 ], 
  [ 14, 24 ], 11, 11, [ 14, 27 ], [ 14, 28 ], 12, 11, 11, [ 0, 15, "BKn" ], 
  [ 0, 14, "BKn" ], 11, 12, 11, [ 14, 38 ], 12, 11, [ 14, 33 ], 11, 11, 11, 
  [ 14, 37 ], 11, [ 14, 49 ], 12, 11, 11, [ 14, 44 ], 11, [ 14, 51 ], 
  [ 14, 60 ], [ 14, 63 ] ],
#V   n = 66
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 10 ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 18 ], [ 14, 19 ], 
  [ 0, 26, "BKn" ], 11, 11, [ 14, 25 ], [ 14, 21 ], 11, 11, [ 14, 24 ], 
  [ 14, 25 ], 11, 11, [ 14, 28 ], [ 14, 29 ], 12, 11, 11, 11, 11, 11, 12, 11, 
  [ 14, 39 ], 12, 11, [ 14, 34 ], 11, 11, 11, [ 14, 38 ], 11, [ 14, 50 ], 12, 
  11, 11, [ 14, 45 ], 11, [ 14, 52 ], [ 14, 61 ], [ 14, 64 ] ],
#V   n = 67
[ ,,,,, [ 14, 3 ], [ 0, 41, "BKn" ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], 
  [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], [ 14, 11 ], 11, 11, [ 0, 33, "BKn" ], 11, 
  11, 11, 11, 11, 11, 11, [ 14, 19 ], [ 14, 20 ], 11, 11, 11, [ 14, 26 ], 
  [ 14, 22 ], 11, 11, [ 14, 25 ], [ 14, 26 ], 11, 11, [ 0, 18, "BKn" ], 
  [ 14, 30 ], 12, 11, 11, 11, 11, 11, 12, 11, [ 14, 40 ], 12, 11, [ 14, 34 ], 
  11, 11, 11, [ 14, 39 ], 11, [ 14, 51 ], 12, 11, 11, [ 14, 46 ], 11, 
  [ 14, 53 ], [ 14, 62 ], [ 14, 65 ] ],
#V   n = 68
[ ,,,,, [ 14, 3 ], [ 14, 4 ], 11, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], [ 14, 7 ], 
  [ 14, 8 ], [ 14, 9 ], [ 14, 12 ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 14, 20 ], [ 14, 21 ], 11, 11, 11, [ 14, 27 ], [ 14, 23 ], 11, 11, 
  [ 14, 26 ], [ 14, 27 ], 11, 12, 11, [ 14, 31 ], 12, 11, 11, 11, 11, 11, 12, 
  11, [ 14, 41 ], 12, 11, [ 14, 35 ], 11, 11, 11, [ 14, 40 ], 11, [ 14, 52 ], 
  12, 11, 11, [ 14, 47 ], 11, [ 14, 54 ], [ 14, 63 ], [ 14, 66 ] ],
#V   n = 69
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 11, [ 14, 7 ], [ 14, 6 ], [ 14, 9 ], 
  [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], [ 0, 35, "LP" ], 11, 11, 11, 
  [ 0, 32, "BKn" ], 11, 11, 11, 11, 11, 11, [ 14, 21 ], [ 14, 22 ], 11, 11, 
  11, [ 14, 28 ], [ 14, 24 ], 11, 11, [ 14, 27 ], [ 14, 28 ], 11, 12, 11, 
  [ 14, 32 ], 12, 11, 11, 11, 11, 11, 12, 11, [ 14, 42 ], [ 0, 10, "BKn" ], 
  11, [ 14, 36 ], [ 0, 8, "BKn" ], 11, 11, [ 14, 41 ], 11, [ 14, 53 ], 12, 
  11, 11, [ 14, 48 ], 11, [ 14, 55 ], [ 14, 64 ], [ 14, 67 ] ],
#V   n = 70
[ ,,,,, [ 0, 44, "vEH" ], [ 0, 43, "Da" ], [ 0, 42, "LP" ], [ 14, 6 ], 11, 
  [ 14, 6 ], [ 14, 7 ], [ 14, 10 ], [ 0, 37, "BKn" ], [ 14, 10 ], [ 14, 11 ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 22 ], [ 14, 23 ], 11, 11, 
  11, [ 14, 29 ], [ 14, 25 ], 11, 11, [ 0, 21, "LP" ], [ 14, 29 ], 11, 12, 
  11, [ 14, 33 ], 12, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 11, 
  [ 14, 42 ], 11, [ 14, 54 ], 12, 11, 11, [ 14, 49 ], 11, [ 14, 56 ], 
  [ 14, 65 ], [ 14, 68 ] ],
#V   n = 71
[ ,,,,,, 11, 11, 11, [ 14, 7 ], 11, [ 14, 7 ], [ 14, 8 ], 12, 11, [ 14, 11 ], 
  [ 14, 12 ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 23 ], 
  [ 14, 24 ], 11, 11, 11, [ 14, 30 ], [ 0, 23, "LP" ], 11, 11, 11, 
  [ 0, 20, "BKn" ], 11, 12, 11, [ 14, 34 ], 12, 11, 11, 11, 11, 11, 
  [ 0, 12, "BKn" ], 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 43 ], 11, 
  [ 14, 55 ], 12, 11, 11, [ 14, 50 ], 11, [ 14, 57 ], [ 14, 66 ], [ 14, 69 ] 
 ],
#V   n = 72
[ ,,,, [ 0, 46, "HN" ], [ 14, 3 ],, 11, 11, 11, [ 0, 41, "Da" ], 11, 
  [ 14, 8 ], [ 14, 9 ], 12, 11, [ 14, 12 ], [ 14, 13 ], 11, [ 0, 34, "BKn" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 24 ], [ 14, 25 ], 11, 
  [ 0, 25, "LP" ], 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, [ 14, 35 ], 12, 
  11, 11, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 39 ], 11, 11, 11, [ 14, 44 ], 
  11, [ 14, 56 ], 12, 11, 11, [ 14, 51 ], 11, [ 14, 58 ], [ 14, 67 ], 
  [ 14, 70 ] ],
#V   n = 73
[ ,,,, 12, 11, [ 14, 4 ], [ 0, 44, "LP" ], 11, 11, 11, 11, [ 0, 40, "LP" ], 
  [ 0, 39, "BKn" ], [ 14, 10 ], 12, 11, [ 14, 13 ], [ 14, 14 ], 11, 11, 11, 
  11, 11, 11, 11, 11, [ 0, 29, "BKn" ], 11, 11, [ 14, 25 ], [ 14, 26 ], 11, 
  11, 11, 12, 11, [ 0, 22, "LP" ], 11, 11, 11, 11, 12, 11, [ 14, 36 ], 12, 
  11, 11, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 40 ], 11, 11, 11, [ 14, 45 ], 
  11, [ 14, 57 ], 12, 11, 11, [ 14, 52 ], 11, [ 14, 59 ], [ 14, 68 ], 
  [ 14, 71 ] ],
#V   n = 74
[ ,,,,, [ 14, 3 ], 11, [ 14, 5 ], 11, 11, [ 0, 42, "Da" ], 11, 11, 11, 11, 
  [ 14, 11 ], 13, 11, [ 14, 14 ], [ 14, 15 ], 11, 11, [ 0, 33, "BKn" ], 11, 
  11, [ 0, 31, "BKn" ], 11, 12, 11, 11, 11, [ 14, 26 ], [ 14, 27 ], 11, 11, 
  11, 12, 11, 11, 11, 11, 11, 11, 12, 11, [ 14, 37 ], 12, 11, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, [ 14, 41 ], 11, 11, 11, [ 0, 6, "BKn" ], 11, 
  [ 14, 58 ], 12, 11, 11, [ 14, 53 ], 11, [ 14, 60 ], [ 14, 69 ], [ 14, 72 ] 
 ],
#V   n = 75
[ ,,,, [ 0, 48, "HN" ],, [ 14, 4 ], 11, [ 14, 6 ], 11, 12, 11, 11, 11, 11, 
  11, [ 0, 38, "Da" ], 13, 11, [ 14, 15 ], [ 14, 16 ], 11, 11, 11, 11, 11, 
  11, 11, 12, 11, 11, 11, [ 14, 27 ], [ 14, 28 ], 11, 11, 11, 12, 11, 11, 11, 
  11, 11, 11, 12, 11, [ 14, 38 ], 12, 11, 11, [ 0, 14, "BKn" ], 11, 12, 11, 
  11, 12, 11, 11, [ 14, 42 ], 11, 11, 12, 11, 11, [ 14, 59 ], 12, 11, 11, 
  [ 14, 54 ], 11, [ 14, 61 ], [ 14, 70 ], [ 14, 73 ] ],
#V   n = 76
[ ,,,, 12, 11, [ 0, 47, "Da" ], [ 0, 46, "BKn" ], 11, [ 14, 7 ], 11, 
  [ 14, 6 ], 11, [ 0, 41, "BKn" ], 11, 11, 11, 11, 13, 11, [ 14, 16 ], 
  [ 14, 17 ], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 28 ], 
  [ 14, 29 ], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 12, 11, [ 14, 39 ], 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 43 ], 11, 11, 12, 11, 11, 
  [ 14, 60 ], 12, 11, 11, [ 14, 55 ], 11, [ 14, 62 ], [ 14, 71 ], [ 14, 74 ] 
 ],
#V   n = 77
[ ,,,, 12, [ 14, 3 ], 11, 11, 11, 11, [ 0, 44, "BKn" ], 11, 12, 11, 11, 11, 
  11, 11, 11, 13, 11, [ 14, 17 ], [ 0, 35, "Da" ], 11, 11, 11, 11, 11, 11, 
  11, 13, 11, 11, 11, [ 14, 22 ], [ 14, 30 ], 11, 11, [ 0, 24, "LP" ], 13, 
  11, 11, 11, 11, 11, 11, 13, 11, [ 14, 40 ], 12, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, [ 14, 44 ], 11, 11, 12, 11, 11, [ 14, 61 ], [ 14, 46 ], 11, 11, 
  [ 14, 56 ], 11, [ 14, 63 ], [ 14, 72 ], [ 14, 75 ] ],
#V   n = 78
[ ,,,,, [ 14, 3 ], [ 14, 4 ], 11, 11, 11, [ 14, 6 ], 11, 11, [ 14, 8 ], 11, 
  11, [ 0, 40, "Da" ], 11, 11, 11, [ 0, 37, "LP" ], 11, 12, 11, 11, 11, 11, 
  11, 11, 11, [ 0, 30, "LP" ], [ 14, 20 ], 11, 11, [ 14, 22 ], [ 14, 23 ], 
  [ 0, 26, "LP" ], 11, 11, 11, 13, 11, 11, 11, 11, 11, [ 0, 19, "LP" ], 
  [ 0, 18, "LP" ], 11, [ 14, 41 ], [ 0, 16, "LP" ], 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, [ 14, 45 ], 11, 11, 12, 11, 11, [ 14, 62 ], [ 14, 47 ], 11, 
  11, [ 14, 57 ], 11, [ 14, 64 ], [ 14, 73 ], [ 14, 76 ] ],
#V   n = 79
[ ,,,,,, [ 14, 4 ], [ 14, 4 ], 11, 11, 11, [ 14, 7 ], 11, [ 0, 43, "BKn" ], 
  [ 0, 42, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 14 ], 11, 11, 11, 
  11, 11, 11, 11, 11, [ 14, 21 ], 11, [ 0, 28, "LP" ], [ 14, 23 ], 12, 11, 
  11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, [ 14, 46 ], 11, 11, 12, 11, 11, [ 14, 63 ], [ 14, 48 ], 
  11, 11, [ 14, 58 ], 11, [ 14, 65 ], [ 14, 74 ], [ 14, 77 ] ],
#V   n = 80
[ ,,,,, [ 14, 3 ],, 12, 11, 11, [ 0, 46, "BKn" ], 11, [ 14, 8 ], 11, 11, 11, 
  11, 11, 11, [ 0, 39, "Da" ], 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 32, "LP" ], 11, 11, 11, [ 14, 22 ], 11, 11, 13, [ 14, 25 ], 11, 11, 
  11, 11, 13, 11, 11, 11, [ 0, 20, "LP" ], 11, 11, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, [ 14, 47 ], 11, 11, 12, 11, 11, [ 14, 64 ], 
  12, 11, 11, [ 14, 59 ], 11, [ 14, 66 ], [ 14, 75 ], [ 14, 78 ] ],
#V   n = 81
[ ,,,,, [ 14, 3 ], [ 14, 4 ], 13, 11, [ 14, 6 ], 12, 11, 11, [ 14, 9 ], 11, 
  11, 11, [ 0, 41, "Da" ], 11, 11, 11, 11, 11, 11, 11, [ 14, 16 ], 11, 11, 
  11, 11, 11, 11, 11, 11, [ 14, 23 ], 11, 11, [ 14, 25 ], [ 14, 26 ], 11, 11, 
  11, 11, 13, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, [ 14, 48 ], 11, 11, 12, 11, 11, [ 14, 65 ], 12, 11, 11, 
  [ 14, 60 ], 11, [ 14, 67 ], [ 14, 76 ], [ 14, 79 ] ],
#V   n = 82
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 50, "BKn" ], 13, 12, [ 14, 7 ], [ 14, 6 ], 
  11, [ 0, 45, "Da" ], [ 0, 44, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 36, "Da" ], [ 14, 17 ], 11, [ 0, 34, "LP" ], 11, 11, 11, 11, 11, 
  11, [ 14, 24 ], 11, 11, [ 14, 26 ], [ 14, 27 ], 11, 11, 11, 11, 13, 11, 11, 
  12, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 49 ], 11, 11, 12, 11, 11, [ 14, 66 ], [ 14, 51 ], 11, 11, [ 14, 61 ], 
  11, [ 14, 68 ], [ 14, 77 ], [ 14, 80 ] ],
#V   n = 83
[ ,,,,, [ 0, 53, "LP" ], [ 14, 4 ], 12, 11, 13, [ 0, 48, "BKn" ], [ 14, 8 ], 
  13, 11, 11, 11, 11, 11, 11, 11, [ 0, 40, "Da" ], 11, 11, [ 0, 38, "Da" ], 
  11, 11, 11, [ 14, 18 ], 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 25 ], 11, 11, 
  [ 14, 27 ], [ 14, 28 ], 11, 11, 11, 11, [ 0, 23, "LP" ], 11, 11, 12, 11, 
  11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 50 ], 
  11, 11, 12, 11, 11, [ 14, 67 ], [ 14, 52 ], 11, 11, [ 14, 62 ], 11, 
  [ 14, 69 ], [ 14, 78 ], [ 14, 81 ] ],
#V   n = 84
[ ,,,,,, 11, 13, 12, 11, 12, 11, [ 0, 47, "LP" ], [ 14, 8 ], 11, 11, 11, 
  [ 0, 43, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 19 ], 11, 
  11, 11, 11, 11, 11, 11, 11, [ 14, 26 ], 11, 11, [ 14, 28 ], [ 14, 29 ], 11, 
  [ 0, 25, "LP" ], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 51 ], 11, 11, 12, 11, 11, 
  [ 14, 68 ], [ 14, 53 ], 11, 11, [ 14, 63 ], 11, [ 14, 70 ], [ 14, 79 ], 
  [ 14, 82 ] ],
#V   n = 85
[ ,,,,,,, [ 0, 52, "BKn" ], 13, 12, 11, 13, 11, 11, 13, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 20 ], 11, 11, [ 0, 33, "LP" ], 
  11, 11, [ 0, 31, "LP" ], 11, 11, [ 0, 29, "LP" ], 11, 11, [ 0, 27, "LP" ], 
  [ 14, 30 ], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 52 ], 11, 11, 12, 11, 11, 
  [ 14, 69 ], [ 14, 54 ], 11, 11, [ 14, 64 ], 11, [ 14, 71 ], [ 14, 80 ], 
  [ 14, 83 ] ],
#V   n = 86
[ ,,,,, [ 14, 3 ],, 12, 11, 13, [ 0, 50, "BKn" ], [ 0, 49, "Da" ], 13, 11, 
  [ 0, 46, "Da" ], 13, 11, 11, 11, 11, [ 0, 42, "Da" ], 11, 11, 11, 11, 11, 
  11, 11, 11, 11, [ 14, 21 ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 14, 31 ], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 53 ], 11, 11, 12, 11, 11, 
  [ 14, 70 ], [ 14, 55 ], 11, 11, [ 14, 65 ], 11, [ 14, 72 ], [ 14, 81 ], 
  [ 14, 84 ] ],
#V   n = 87
[ ,,,,, [ 14, 3 ], [ 14, 4 ],, 12, 11, 12, 11, 11, 13, 12, 11, 13, 
  [ 0, 45, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 35, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 14, 32 ], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, [ 0, 12, "sph" ], 11, 11, [ 0, 10, "sph" ], 11, 11, [ 14, 54 ], 
  11, 11, 12, 11, 11, [ 14, 71 ], [ 14, 56 ], 11, 11, [ 14, 66 ], 11, 
  [ 14, 73 ], [ 14, 82 ], [ 14, 85 ] ],
#V   n = 88
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ],, 12, 11, 13, 11, 11, 12, 12, 11, 13, 
  11, 11, 11, 11, 11, 11, 11, 11, [ 0, 39, "Da" ], 11, 11, [ 0, 37, "LP" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 33 ], 11, 
  11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 
  [ 0, 14, "sph" ], 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 55 ], 11, 11, 12, 
  11, 11, [ 14, 72 ], [ 14, 57 ], 11, 11, [ 14, 67 ], 11, [ 14, 74 ], 
  [ 14, 83 ], [ 14, 86 ] ],
#V   n = 89
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, [ 0, 52, "BKn" ], [ 0, 51, "BKn" ],
  13, 11, 11, 12, 12, 11, 13, 11, [ 0, 44, "Da" ], 11, 11, 11, 
  [ 0, 41, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 26, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  12, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  [ 14, 56 ], 11, 11, 12, 11, 11, [ 14, 73 ], [ 14, 58 ], 11, 11, [ 14, 68 ], 
  11, [ 14, 75 ], [ 14, 84 ], [ 14, 87 ] ],
#V   n = 90
[ ,,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], 12, 11, 11, 13, 
  [ 0, 49, "Da" ], 11, 12, 12, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, [ 14, 57 ], 11, 11, 12, 11, 11, [ 14, 74 ], 
  [ 14, 59 ], 11, 11, [ 14, 69 ], 11, [ 14, 76 ], [ 14, 85 ], [ 14, 88 ] ],
#V   n = 91
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 56, "BKn" ], [ 14, 6 ], [ 14, 7 ], 
  [ 14, 8 ], 13, 11, 11, 12, 11, 11, 13, 12, 11, 13, 11, 11, [ 0, 43, "Da" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 34, "LP" ], 11, 11, 
  [ 0, 32, "LP" ], 11, 11, 11, 11, 11, [ 0, 28, "LP" ], 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, [ 0, 8, "sph" ], 11, 11, 12, 11, 11, [ 14, 75 ], 
  [ 14, 60 ], 11, 11, [ 14, 70 ], 11, [ 14, 77 ], [ 14, 86 ], [ 14, 89 ] ],
#V   n = 92
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 11, [ 14, 7 ], [ 14, 6 ], 
  [ 0, 53, "Da" ], 13, 11, 11, 12, 11, [ 0, 48, "Da" ], 13, 12, 11, 
  [ 0, 45, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 36, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, [ 0, 16, "sph" ], 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  [ 14, 76 ], [ 14, 61 ], 11, 11, [ 14, 71 ], 11, [ 14, 78 ], [ 14, 87 ], 
  [ 14, 90 ] ],
#V   n = 93
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], 11, [ 14, 6 ], [ 14, 7 ], 11, 13, 
  [ 0, 51, "Da" ], 11, 12, 11, 11, 13, 12, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 40, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 30, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, [ 14, 77 ], [ 14, 62 ], 11, 11, [ 14, 72 ], 11, [ 14, 79 ], 
  [ 14, 88 ], [ 14, 91 ] ],
#V   n = 94
[ ,,,, [ 0, 61, "HN" ], [ 14, 3 ],, [ 0, 58, "BKn" ], [ 14, 6 ], [ 14, 7 ], 
  11, [ 14, 7 ], [ 14, 8 ], 11, 12, 11, 11, 13, 11, 11, 13, 13, 11, 11, 11, 
  11, 11, [ 0, 42, "Da" ], 11, 11, 11, 11, 11, [ 0, 38, "LP" ], 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 22, "sph" ], 11, 12, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 78 ], [ 14, 63 ], 11, 
  11, [ 14, 73 ], 11, [ 14, 80 ], [ 14, 89 ], [ 14, 92 ] ],
#V   n = 95
[ ,,,, 12, 11, [ 14, 4 ], 12, 11, [ 14, 7 ], [ 0, 56, "BKn" ], 
  [ 0, 55, "BKn" ], [ 14, 8 ], [ 14, 9 ], 11, 12, 11, [ 0, 50, "Da" ], 13, 
  11, 11, [ 0, 47, "Da" ], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 12, 11, 11, [ 0, 18, "sph" ], 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 79 ], 
  [ 14, 64 ], 11, 11, [ 14, 74 ], 11, [ 14, 81 ], [ 14, 90 ], [ 14, 93 ] ],
#V   n = 96
[ ,,,,, [ 14, 3 ], 11, [ 14, 5 ], 12, 11, [ 14, 6 ], 11, 11, [ 14, 9 ], 
  [ 0, 53, "Da" ], 11, 12, 11, 11, 13, 11, 11, 11, 13, 11, 11, 
  [ 0, 44, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, [ 14, 80 ], [ 14, 65 ], 11, 11, [ 14, 75 ], 11, 
  [ 14, 82 ], [ 14, 91 ], [ 14, 94 ] ],
#V   n = 97
[ ,,,,,, [ 14, 4 ], [ 0, 60, "BKn" ], [ 14, 6 ], 13, 11, [ 14, 7 ], 11, 11, 
  12, 11, 11, 13, 11, 11, [ 0, 49, "Da" ], 11, 11, 11, [ 0, 46, "Da" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, [ 14, 81 ], [ 14, 66 ], 11, 11, [ 14, 76 ], 11, [ 14, 83 ], 
  [ 14, 92 ], [ 14, 95 ] ],
#V   n = 98
[ ,,,,,, [ 0, 62, "BKn" ], [ 14, 4 ], 11, [ 0, 59, "LP" ], [ 0, 58, "BKn" ], 
  [ 0, 57, "BKn" ], [ 14, 8 ], 11, 11, 13, 11, [ 0, 52, "Da" ], 
  [ 0, 51, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, [ 0, 37, "LP" ], 11, 11, [ 0, 35, "LP" ], 11, 11, 
  [ 0, 33, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 82 ], [ 14, 67 ], 11, 11, 
  [ 14, 77 ], 11, [ 14, 84 ], [ 14, 93 ], [ 14, 96 ] ],
#V   n = 99
[ ,,,,, [ 14, 3 ],, 11, [ 14, 5 ], 11, 11, 11, 11, [ 14, 9 ], [ 0, 55, "Da" ],
  [ 0, 54, "Da" ], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 43, "LP" ], 11, 11, [ 0, 41, "LP" ], 11, 11, [ 0, 39, "LP" ], 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, [ 0, 20, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 83 ], 
  [ 14, 68 ], 11, 11, [ 14, 78 ], 11, [ 14, 85 ], [ 14, 94 ], [ 14, 97 ] ],
#V   n = 100
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 62, "BKn" ], 11, [ 14, 6 ], 11, 
  [ 0, 58, "BKn" ], 11, 11, 12, 11, 11, 13, 11, 11, 11, [ 0, 50, "Da" ], 11, 
  11, [ 0, 48, "Da" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 84 ], 
  [ 0, 4, "sph" ], 11, 11, [ 14, 79 ], 11, [ 14, 86 ], [ 14, 95 ], [ 14, 98 ] 
 ],
#V   n = 101
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 11, [ 0, 61, "LP" ], 
  [ 0, 60, "BKn" ], 12, 11, 11, 11, 13, 11, 11, [ 0, 53, "LP" ], 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 45, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  [ 14, 80 ], 11, [ 14, 87 ], [ 14, 96 ], [ 14, 99 ] ],
#V   n = 102
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], 11, 11, 11, 12, 11, [ 0, 57, "LP" ],
  [ 0, 56, "LP" ], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 47, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 81 ], 11, 
  [ 14, 88 ], [ 14, 97 ], [ 14, 100 ] ],
#V   n = 103
[ ,,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 4 ], [ 14, 7 ], 11, [ 0, 60, "BKn" ], 
  11, 12, 11, 11, 11, 13, 11, 11, 11, [ 0, 52, "LP" ], 11, 11, 11, 
  [ 0, 49, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 0, 14, "sph" ], 11, 11, [ 0, 12, "sph" ], 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, [ 14, 82 ], 11, [ 14, 89 ], [ 14, 98 ], 
  [ 14, 101 ] ],
#V   n = 104
[ ,,,,, [ 14, 3 ], [ 14, 4 ],, [ 14, 4 ], 11, [ 0, 62, "BKn" ], 12, 11, 11, 
  13, 11, 11, 11, [ 0, 55, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 42, "LP" ], 11, 11, [ 0, 40, "LP" ], 11, 
  11, [ 0, 38, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 22, "sph" ], 11, 12, 11, 11, 
  12, 11, 11, [ 0, 16, "sph" ], 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 83 ], 11, [ 14, 90 ], 
  [ 14, 99 ], [ 14, 102 ] ],
#V   n = 105
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], [ 14, 4 ], 11, [ 14, 6 ], 11, 12, 
  11, [ 0, 59, "BKn" ], [ 0, 58, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 51, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 44, "LP" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 36, "LP" ], 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 84 ], 11, [ 14, 91 ], 
  [ 14, 100 ], [ 14, 103 ] ],
#V   n = 106
[ ,,,,,, [ 14, 4 ], [ 0, 66, "BKn" ], [ 14, 6 ], 13, [ 14, 6 ], 
  [ 0, 62, "BKn" ], 11, 12, 11, 11, 11, 11, [ 0, 56, "LP" ], 11, 11, 
  [ 0, 54, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 11, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, [ 14, 85 ], 11, [ 14, 92 ], [ 14, 101 ], 
  [ 14, 104 ] ],
#V   n = 107
[ ,,,,, [ 14, 3 ],, 12, 11, [ 0, 65, "LP" ], [ 0, 64, "BKn" ], 12, 11, 11, 
  13, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 48, "LP" ], 11, 11, [ 0, 46, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 13, 12, 11, 11, 12, 11, 11, [ 0, 18, "sph" ], 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  [ 0, 6, "sph" ], 11, 11, 12, 11, 11, 11, [ 14, 86 ], 11, [ 14, 93 ], 
  [ 14, 102 ], [ 14, 105 ] ],
#V   n = 108
[ ,,,,, [ 14, 3 ], [ 14, 4 ], 13, [ 14, 4 ], 11, 11, 11, 12, 11, 
  [ 0, 61, "LP" ], [ 0, 60, "LP" ], 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 53, "LP" ], 11, 11, 11, [ 0, 50, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 24, "sph" ], 13, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  [ 0, 10, "sph" ], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 87 ], 11, [ 14, 94 ], [ 14, 103 ], [ 14, 106 ] ],
#V   n = 109
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 68, "BKn" ], [ 0, 67, "BKn" ], 13, 11, 
  [ 0, 64, "BKn" ], 11, 12, 11, 11, 11, 11, [ 0, 58, "LP" ], 11, 12, 11, 
  [ 0, 55, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 13, 12, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, [ 14, 88 ], 11, [ 14, 95 ], [ 14, 104 ], 
  [ 14, 107 ] ],
#V   n = 110
[ ,,,,,, [ 14, 4 ], 12, 11, 11, [ 0, 66, "BKn" ], 12, 11, 11, 13, 
  [ 0, 61, "LP" ], 11, 11, 12, 11, 11, 13, 11, 11, 11, 11, 11, 
  [ 0, 52, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 45, "LP" ], 11, 
  11, [ 0, 43, "LP" ], 11, 11, 11, 11, 11, [ 0, 39, "LP" ], 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 
  13, 12, 11, 11, [ 0, 20, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 89 ], 11, [ 14, 96 ], [ 14, 105 ], [ 14, 108 ] ],
#V   n = 111
[ ,,,,,, [ 0, 71, "BKn" ], 13, [ 14, 4 ], 11, 11, 11, 12, 11, [ 0, 63, "LP" ],
  12, 11, 11, 11, 12, 11, [ 0, 57, "LP" ], 13, 11, 11, [ 0, 54, "LP" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 12, 11, 13, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, [ 14, 90 ], 11, [ 14, 97 ], [ 14, 106 ], [ 14, 109 ] ],
#V   n = 112
[ ,,,,, [ 14, 3 ],, [ 0, 70, "LP" ], [ 0, 69, "LP" ], 13, 11, [ 0, 66, "LP" ],
  11, 13, 11, 11, 12, 11, [ 0, 60, "LP" ], 11, 12, 11, 11, 13, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, [ 0, 49, "LP" ], 11, 11, [ 0, 47, "LP" ], 11, 11, 
  11, 11, 11, 11, 11, 11, [ 0, 41, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 13, 
  12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 91 ], 11, 
  [ 14, 98 ], [ 14, 107 ], [ 14, 110 ] ],
#V   n = 113
[ ,,,,, [ 14, 3 ], [ 14, 4 ], 12, 11, 11, [ 0, 68, "LP" ], 12, 11, 
  [ 0, 65, "LP" ], [ 0, 64, "LP" ], [ 0, 63, "LP" ], 11, 12, 11, 11, 11, 13, 
  11, 11, 13, 11, 11, 11, [ 0, 53, "LP" ], 11, 11, [ 0, 51, "LP" ], 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 26, "sph" ], 11, 12, 11, 13, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 14, 92 ], 11, [ 14, 99 ], [ 14, 108 ], [ 14, 111 ] ],
#V   n = 114
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 13, 11, 11, 11, 13, 11, 11, 11, 11, 
  11, 13, 11, 11, [ 0, 59, "LP" ], [ 0, 58, "LP" ], 11, 11, [ 0, 56, "LP" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 13, [ 0, 22, "sph" ], 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 93 ], 11, [ 14, 100 ], 
  [ 14, 109 ], [ 14, 112 ] ],
#V   n = 115
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], [ 0, 71, "LP" ], 13, 11, [ 0, 68, "LP" ], 
  [ 0, 67, "LP" ], 13, 11, 11, 11, 11, [ 0, 62, "LP" ], [ 0, 61, "LP" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 46, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 94 ], 11, 
  [ 14, 101 ], [ 14, 110 ], [ 14, 113 ] ],
#V   n = 116
[ ,,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 4 ], 11, [ 0, 70, "LP" ], 12, 11, 11, 
  [ 0, 66, "LP" ], [ 0, 65, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 57, "LP" ], 11, 11, [ 0, 55, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 44, "LP" ], 11, 11, 11, 11, 11, 
  [ 0, 40, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, [ 14, 95 ], 11, [ 14, 102 ], [ 14, 111 ], 
  [ 14, 114 ] ],
#V   n = 117
[ ,,,,, [ 14, 3 ], [ 14, 4 ], 13, [ 14, 4 ], 12, 11, 11, 13, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, [ 0, 60, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, [ 0, 50, "LP" ], 11, 11, [ 0, 48, "LP" ], 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 96 ], 11, [ 14, 103 ], 
  [ 14, 112 ], [ 14, 115 ] ],
#V   n = 118
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 74, "LP" ], [ 0, 73, "LP" ], 13, 
  [ 14, 6 ], [ 0, 70, "LP" ], [ 0, 69, "LP" ], 13, 11, 11, 11, 11, 
  [ 0, 64, "LP" ], [ 0, 63, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 54, "LP" ], 11, 11, [ 0, 52, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 28, "sph" ], 11, 12, 11, 11, 
  [ 0, 24, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, [ 14, 97 ], 11, [ 14, 104 ], [ 14, 113 ], [ 14, 116 ] ],
#V   n = 119
[ ,,,,,, [ 14, 4 ], 12, 11, 11, [ 0, 72, "LP" ], 12, 11, 11, [ 0, 68, "LP" ], 
  [ 0, 67, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 59, "LP" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, [ 0, 42, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, [ 0, 16, "sph" ], 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, [ 0, 8, "sph" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, [ 14, 98 ], 11, [ 14, 105 ], [ 14, 114 ], [ 14, 117 ] ],
#V   n = 120
[ ,,,,, [ 14, 3 ],, 13, [ 14, 4 ], 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, [ 0, 62, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 0, 18, "sph" ], 
  11, 12, 11, 11, 11, [ 0, 14, "sph" ], 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 99 ], 11, [ 14, 106 ], 
  [ 14, 115 ], [ 14, 118 ] ],
#V   n = 121
[ ,,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 76, "LP" ], [ 0, 75, "LP" ], 13, 11, 
  [ 0, 72, "LP" ], [ 0, 71, "LP" ], 13, 11, 11, 11, 11, [ 0, 66, "LP" ], 
  [ 0, 65, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 58, "LP" ], 11, 11, 
  [ 0, 56, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 47, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 100 ], 11, [ 14, 107 ], [ 14, 116 ], [ 14, 119 ] ],
#V   n = 122
[ ,,,,, [ 14, 3 ], [ 14, 4 ], 12, 11, 11, [ 0, 74, "LP" ], 12, 11, 11, 
  [ 0, 70, "LP" ], [ 0, 69, "LP" ], [ 0, 68, "LP" ], 11, 11, 11, 11, 11, 11, 
  11, 11, [ 0, 61, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 51, "LP" ], 11, 11, [ 0, 49, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, [ 14, 101 ], [ 14, 81 ], [ 14, 108 ], 
  [ 14, 117 ], [ 14, 120 ] ],
#V   n = 123
[ ,,,,,, [ 14, 4 ], 13, 13, 11, 11, 11, 13, 11, 11, 11, 11, 11, 
  [ 0, 67, "LP" ], 11, 11, 11, [ 0, 64, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 53, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, [ 0, 26, "sph" ], 
  11, 12, 11, 11, 12, 11, 11, [ 0, 20, "sph" ], 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 14, 102 ], [ 14, 82 ], [ 14, 109 ], [ 14, 118 ], [ 14, 121 ] 
 ],
#V   n = 124
[ ,,,,,,, [ 0, 78, "LP" ], [ 0, 77, "LP" ], [ 0, 76, "LP" ], 11, 
  [ 0, 74, "LP" ], [ 0, 73, "LP" ], 13, 11, [ 0, 70, "LP" ], 11, 11, 11, 11, 
  [ 0, 66, "LP" ], 11, 11, 11, 11, 11, 11, 11, [ 0, 60, "LP" ], 11, 11, 11, 
  11, 11, 11, [ 0, 55, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 0, 12, "sph" ], 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 103 ], [ 14, 83 ], [ 14, 110 ], [ 14, 119 ], [ 14, 122 ] ],
#V   n = 125
[ ,,,,,,, 12, 11, 11, 11, 13, 11, 11, [ 0, 72, "LP" ], 12, 11, 11, 11, 11, 
  11, 11, [ 0, 65, "LP" ], 11, 11, [ 0, 63, "LP" ], [ 0, 62, "LP" ], 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 104 ], 
  [ 14, 84 ], [ 14, 111 ], [ 14, 120 ], [ 14, 123 ] ],
#V   n = 126
[ ,,,,,,, 13, 13, 11, 11, [ 0, 75, "LP" ], 13, 11, 11, 11, 12, 11, 
  [ 0, 69, "LP" ], [ 0, 68, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 59, "LP" ], 11, 11, [ 0, 57, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 11, [ 0, 22, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, [ 14, 105 ], [ 14, 85 ], [ 14, 112 ], [ 14, 121 ], 
  [ 14, 124 ] ],
#V   n = 127
[ ,,,,,,, [ 0, 80, "LP" ], [ 0, 79, "LP" ], [ 0, 78, "LP" ], 11, 12, 11, 13, 
  11, [ 0, 72, "LP" ], 11, 12, 11, 11, 11, 11, 11, 11, 11, [ 0, 64, "LP" ], 
  11, 11, 11, [ 0, 61, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 52, "LP" ], 11, 11, [ 0, 50, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 28, "sph" ], 11, 12, 11, 11, 12, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 106 ], 
  [ 14, 86 ], [ 14, 113 ], [ 14, 122 ], [ 14, 125 ] ],
#V   n = 128
[ ,,,,,,,, 11, 11, 11, 13, 13, 11, [ 0, 74, "LP" ], 12, 11, 11, 13, 11, 11, 
  11, [ 0, 67, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, [ 0, 54, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 48, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 32, "sph" ], 11, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, [ 14, 107 ], [ 14, 87 ], [ 14, 114 ], [ 14, 123 ], 
  [ 14, 126 ] ],
#V   n = 129
[ ,,,,,,, [ 14, 4 ],, 11, 11, [ 0, 77, "LP" ], [ 0, 76, "LP" ], 13, 11, 11, 
  12, 11, [ 0, 71, "LP" ], [ 0, 70, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 58, "LP" ], 11, 11, [ 0, 56, "LP" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 12, 12, 11, 11, 12, 11, 11, [ 0, 24, "sph" ], 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 14, 108 ], [ 14, 88 ], 
  [ 14, 115 ], [ 14, 124 ], [ 14, 127 ] ],
#V   n = 130
[ ,,,,,,, 12, 11, [ 0, 80, "LP" ], 11, 12, 11, 11, 12, [ 0, 74, "LP" ], 11, 
  12, 11, 11, 11, 11, 11, 11, 11, [ 0, 66, "LP" ], [ 0, 65, "LP" ], 11, 11, 
  [ 0, 63, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11 ]];