#############################################################################
##
#A  tbl/weylg2.g             CHEVIE library         Meinolf Geck, Jean Michel
##
#Y  Copyright (C) 1994 - 2001  The CHEVIE Team
##
##  This file contains the character table of the Hecke algebra of type G2.
##
CHEVIE.Revision("tbl/weylg2.g",
   "$Id: weylg2.g,v 1.5 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("CartanMat","G2",function(arg)local a,type;
  if Length(arg)>0 then type:=arg[1];else type:=1;fi;
  a:=[[2,-1],[-3,2]];
  a[1][2]:=-type;a[2][1]:=3/a[1][2];
  return a;
end);

CHEVIE.AddData("PrintDiagram","G2",function(indices,title,type)
  Print(title," ",indices[1]);
  if type=1 then Print(" >6> ");
  elif type=ER(3) then Print(" =6= ");
  else Print(" ?6? ");
  fi;
  Print(indices[2]," \n");
end);

CHEVIE.AddData("ReflectionName","G2",function(arg)local i,opt,type;
  if Length(arg)=1 then return "G(?)2"; fi;
  type:=arg[1]; opt:=arg[2];
  if type=1 then 
    if IsBound(opt.TeX) then return "G_2";
    elif IsBound(opt.arg) then return "\"G\",2";
    else return "G2";fi;
  elif type=ER(3) then 
    if IsBound(opt.TeX) then return "G_{\\hbox{sym}2}";
    elif IsBound(opt.arg) then return "\"Gsym\",2";
    else return "Gsym2";fi;
  elif IsBound(opt.TeX) then return SPrint("G(",Format(type^2/3,opt),")_2");
  elif IsBound(opt.arg) then return SPrint("\"G\",",2,",",Format(type^2/3,opt));
  else return SPrint("G(",Format(type^2/2),")2");
  fi;
end);

CHEVIE.AddData("ParabolicRepresentatives", "G2", 
  s->CHEVIE.RawData("ParabolicRepresentatives","imp")(6,6,2,s));

# in dim 3, as in Bourbaki
CHEVIE.AddData("GeneratingRoots", "G2", [ [ 1, -1, 0 ], [ -2, 1, 1 ] ]);

CHEVIE.AddData("HyperplaneRepresentatives","G2",[1,2]);

CHEVIE.AddData("FundamentalGroup","G2",[]);
CHEVIE.AddData("CenterSimplyConnected","G2",[]);

CHEVIE.AddData("Size", "G2", function(arg) return 12; end);

CHEVIE.AddData("ReflectionDegrees","G2",[2,6]);

CHEVIE.AddData("NrConjugacyClasses","G2",6);

CHEVIE.AddData("CharInfo","G2",function()local res;
  res:=rec(charparams:=[[1,0],[1,6],[1,3,1],[1,3,2],[2,1],[2,2]],
  extRefl:=[1,5,2],
  a:=[0,6,1,1,1,1],
  A:=[0,6,5,5,5,5]);
  res.b:=List(res.charparams,x->x[2]);
  # charnames in Spaltenstein's "Sous-groupes de Borel et classes unipotentes"
  res.spaltenstein:=["1","\\varepsilon","\\varepsilon_l","\\varepsilon_c","\\theta'","\\theta''"];
  return res;
  end
);

CHEVIE.AddData("WordsClassRepresentatives","G2",
  [[],[2],[1],[1,2],[1,2,1,2],[1,2,1,2,1,2]]);

CHEVIE.AddData("ClassNames","G2",
  ["A_0","\\tilde A_1","A_1","G_2","A_2","A_1+\\tilde A_1"]);

CHEVIE.AddData("ClassInfo","G2",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G2"),
    classnames:=CHEVIE.RawData("ClassNames","G2"),
    classparams:=CHEVIE.RawData("ClassNames","G2"),
    orders:=[1,2,2,6,3,2],
    classes:=[1,3,3,2,2,1]));

CHEVIE.AddData("PowerMaps","G2",[,[1,1,1,5,5,1], [1,2,3,6,1,6]]);

# description of fake degrees by powers of q
CHEVIE.AddData("sparseFakeDegrees","G2",[[1,0],[1,6],[1,3],[1,3],[1,1,1,5],[1,2,1,4]]);

#############################################################################
##
#F  CHEVIE.RawData("ClassParameter","G2")( <w> )    . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type G_2  as word in  standard
##  generators,  returns the classparam of its conjugacy class.
##
CHEVIE.AddData("generators","G2",[ (2,3)(4,5), (1,2)(3,4)(5,6) ]);

CHEVIE.AddData("ClassParameter","G2",w->CHEVIE.RawData("ClassNames","G2")
  [PositionProperty([[[]],[[2],[1,2,1],[2,1,2,1,2]],[[1],[2,1,2],[1,2,1,2,1]],
    [[2,1],[1,2]],[[2,1,2,1],[1,2,1,2]],[[1,2,1,2,1,2]]],x->w in x)]);

CHEVIE.AddData("HeckeCharTable","G2",function(para,sqrtpara)
  local u,v,tbl,f1,f2;
  u:=-para[1][1]/para[1][2];v:=-para[2][1]/para[2][2];
  f1:=function(u,v)return [1,v,u,v*u,v^2*u^2,v^3*u^3];end;
  f2:=function(u,v,eps)local squv;
    if IsBound(sqrtpara[1]) and IsBound(sqrtpara[2]) then
	 squv:=sqrtpara[1]*sqrtpara[2];
    elif u=v then squv:=u;
    else squv:=GetRoot(u*v,2,"CharTable(Hecke(G2))");
    fi;
    squv:=eps*squv;return [2,-1+v,u-1,-squv,-v*u,2*squv^3];end;
  tbl:=rec( identifier:="H(G2)", parameter:=[u,v], size:=12,
    powermap:=CHEVIE.RawData("PowerMaps","G2"),
    irreducibles:=
      [f1(u,v),f1(-1,-1),f1(-1,v),f1(u,-1),f2(u,v,-1),f2(u,v,1)]*u^0*v^0,
    irredinfo:=List(CHEVIE.RawData("CharInfo","G2")().charparams,x->
      rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G2")(x,rec()))));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","G2"));
  tbl.centralizers:=List(tbl.classes,x->tbl.size/x);
  tbl := CHEVIE.compat.MakeCharacterTable(tbl);
  CHEVIE.compat.AdjustHeckeCharTable(tbl,para);
  return tbl;
end);

CHEVIE.AddData("HeckeRepresentation","G2",function(para,sqrtpara,i)
  local u,v,squv; u:=-para[1][1]/para[1][2];v:=-para[2][1]/para[2][2];
  if i=1 then return [[[u]],[[v]]]*(u*v)^0;
  elif i=2 then return [[[-1]],[[-1]]]*(u*v)^0;
  elif i=3 then return [[[-1]],[[v]]]*(u*v)^0;
  elif i=4 then return [[[u]],[[-1]]]*(u*v)^0;
  else
    if IsBound(sqrtpara[1]) and IsBound(sqrtpara[2]) then
	 squv:=sqrtpara[1]*sqrtpara[2];
    elif u=v then squv:=u;
    else squv:=GetRoot(u*v,2,"Representation(Hecke(G2),[",i,"]");
    fi;
    if i=6 then squv:=-squv;fi;
    return [[[-1,1], [0,u]], [[v,0], [squv+u+v,-1]]]*(u*v)^0;
  fi;
 end);

CHEVIE.AddData("Representation","G2",function(i)local para;
  return CHEVIE.RawData("HeckeRepresentation","G2")([[1,-1],[1,-1]],[1,1],i);
end);

#############################################################################
##
#F  PoincarePolynomial(u,v) . . . . Poincare Polynomial for G2
##
##  Same as Schur element for the identity character, but does not
##  require squv to be given.
##
CHEVIE.AddData("PoincarePolynomial","G2",function(param)local u,v;
  u:=-param[1][1]/param[1][2]; v:=-param[2][1]/param[2][2];
  return (1+u)*(v+1)*((1+u*v)^2-u*v);
end);

CHEVIE.AddData("SchurElements","G2",
[ function(u,v)return(1+u)*(v+1)*(u^2*v^2+u*v+1);end,
  function(u,v)return(1+u)*(v+1)*(u^2*v^2+u*v+1)/u^3/v^3;end,
  function(u,v)return(u^2+v^2+u*v)*(1+u)*(v+1)/u^3;end,
  function(u,v)return(u^2+v^2+u*v)*(1+u)*(v+1)/v^3;end,
  function(u,v,squv)return 2*(u+squv+v)*(u*v-squv+1)/u/v;end,
  function(u,v,squv)return 2*(u-squv+v)*(u*v+squv+1)/u/v;end]);

CHEVIE.AddData("SchurModels","G2",rec(
  f1:=rec(vcyc:=[[[1,-1,0,0],1],[[0,0,1,-1],1],[[1,-1,1,-1],3]]),
  f2:=rec(coeff:=-2,root:=[1,-1,1,-1]/2,factor:=[-1,1,0,0],
    vcyc:=[[[0,0,0,0,1],3],[[0,0,-1,1,1],3]])));

CHEVIE.AddData("SchurData","G2",[
  rec(name:="f1",order:=[1,2,3,4]),rec(name:="f1",order:=[2,1,4,3]),
  rec(name:="f1",order:=[2,1,3,4]),rec(name:="f1",order:=[1,2,4,3]),
  rec(name:="f2",order:=[1,2,3,4],rootPower:=-1),
  rec(name:="f2",order:=[1,2,3,4],rootPower:=1)]);

#############################################################################
##
#F  SchurElement( <phi>, <para> ) . . . .  Schur elements for type G2
##
##  SchurElement returns the constant arising  from  the
##  Schur relations for  the  irreducible  character  <phi> of  the
##  Hecke of type G2 with parameters given by a list <para>.
##
##  The  parameters  given should be u, v, sqrt(u*v) where u and v are
##  the parameters for the Hecke algebra. If only one is given, the
##  values u, u, u are used. If two are given, the function knows how to
##  compute sqrt(u*v) only if u and v are equal or one is the cube of
##  the other one.
##
##  The  constant  corresponding  to  an  phi  is  defined  to be P/D where
##  P is the Poincare  polynomial and D  is the generic degree of  phi.
##
CHEVIE.AddData("SchurElement","G2",function(phi,param,sqrtparam)
  local u,v,squv,p;
  u:=-param[1][1]/param[1][2]; v:=-param[2][1]/param[2][2];
  p:=Position(CHEVIE.RawData("CharInfo","G2")().charparams,phi);
  if p<=4 then return CHEVIE.RawData("SchurElements","G2")[p](u,v);fi;
  if IsBound(sqrtparam[1]) and IsBound(sqrtparam[2]) then
       squv:=sqrtparam[1]*sqrtparam[2];
  else squv:=GetRoot(u*v,2,"SchurElement(Hecke(G2),",phi,")");
  fi;
  return CHEVIE.RawData("SchurElements","G2")[p](u,v,squv);
end);

CHEVIE.AddData("UnipotentCharacters","G2",function()
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="G",indices:=[1..2],rank:=2),
 levi:=[], parameterExponents:=[1,1],
        charNumbers:=[1..6], eigenvalue:=1, cuspidalName:=""),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..2], parameterExponents:=[],
	charNumbers:=[10], eigenvalue:=E(3)^2, cuspidalName:="G_2[\\zeta_3^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..2], parameterExponents:=[],
	charNumbers:=[7], eigenvalue:=-1, cuspidalName:="G_2[-1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..2], parameterExponents:=[],
	charNumbers:=[9], eigenvalue:=E(3), cuspidalName:="G_2[\\zeta_3]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..2], parameterExponents:=[],
	charNumbers:=[8], eigenvalue:=1, cuspidalName:="G_2[1]")],
  families:=[
    Family("S3",[5,6,4,3,8,7,9,10]),
    Family("C1",[1]),
    Family("C1",[2])],
  a:=[0,6,1,1,1,1,1,1,1,1],
  A:=[0,6,5,5,5,5,5,5,5,5],
  charSymbols:=[[[0],[0],[0],[0],[0],[2]],[[0,1],[0,1],[0,1],[0,1],[0,1],[1,2]],
    [[0],[0],[1],2,0],[[0],[0],[1],2,1],
    [[0],[0],[0],[0],[1],[1]],[[0],[0],[0],[1],[0],[1]],
    [[0,1],[0],[0,1],[],[0],[]],[[0,1],[0,1],[0],[],[],[0]],
    [[0,1],[0],[0],[0,1],[],[]],[[0,1],[0,1],[],[0],[0],[]]]);
end);

CHEVIE.AddData("Invariants","G2",
 [function(x,y)return -3*x*y+3*x^2+y^2;end,
  function(x,y)return x^2*y^4-6*x^3*y^3+13*x^4*y^2-12*x^5*y+4*x^6;end]);

CHEVIE.AddData("Discriminant","G2",function()return
  function(x,y)return 4*x^3*y-27*y^2;end;end);

# c is CartanType -- does not matter
CHEVIE.AddData("UnipotentClasses","G2",function(c,p)local uc,Z,c;
  if p=0 then p:=1;fi; Z:=n->ComplexReflectionGroup(n,1,1);
  uc:=rec(classes:=[
   rec(name:="1",succ:=["A1"],dynkin:=[0,0],balacarter:=[],
     red:=CoxeterGroup("G",2)),
   rec(name:="A_1",succ:=["~A1"],dynkin:=[1,0],balacarter:=[1],red:=Z(2)),
   rec(name:="\\tilde A_1",succ:=["G2(a1)"],dynkin:=[0,1],balacarter:=[2],
     red:=Z(2-(Gcd(p,3)-1)/2)),
   rec(name:="G_2(a_1)",succ:=["G2"],dynkin:=[2,0],balacarter:=[1,-2],
     Au:=CoxeterGroup("A",2-(Gcd(p,3)-1)/2)),
   rec(name:="G_2",succ:=[],dynkin:=[2,2],Au:=Z(Gcd(p,6)),balacarter:=[1,2])],
springerSeries:=[rec(relgroup:=CoxeterGroup("G",2),levi:="",Z:=[],
  locsys:=[[5,1],[1,1],[4,2],[2,1],[4,3],[3,1]]),
  rec(relgroup:=CoxeterGroup(),levi:=[1,2],Z:=[],locsys:=[[4,1]],
   parameter:=[8])]); # Fourier transform of 8th unip. character
  if p=2 then uc.springerSeries[1].locsys[1]:=[5,2];
    Add(uc.springerSeries,
      rec(relgroup:=CoxeterGroup(),levi:=[1,2],Z:=[],locsys:=[[5,1]]));
  elif p=3 then 
    Add(uc.classes,rec(name:="(\\tilde A_1)_3",
      succ:=["~A1"],dimBu:=3,red:=Z(2),Au:=CoxeterGroup()));
    Add(uc.classes[1].succ,"(~A1)3");
    uc.classes[3].dimBu:=2;Unbind(uc.classes[3].dynkin);
    uc.springerSeries[1].locsys{[3,5]}:=[[6,1],[4,2]];
    for c in [2,3] do Add(uc.springerSeries,
      rec(relgroup:=CoxeterGroup(),levi:=[1,2],Z:=[],locsys:=[[5,c]]));od;
  fi;
  uc.orderClasses:=List(uc.classes,c->List(c.succ,
    n->PositionProperty(uc.classes,c->UnipotentClassOps.Name(c)=n)));
  for c in uc.classes do Unbind(c.succ);
    if not IsBound(c.red) then c.red:=Z(1);fi;
    if not IsBound(c.Au) then c.Au:=Z(1);fi;
    c.AuAction:=ExtendedReflectionGroup(c.red,List(c.Au.generators,
        x->IdentityMat(c.red.rank)));
  od;
  return uc;
end);

CHEVIE.AddData("KLeftCellRepresentatives","G2",
[rec(character:=[1], duflo:=[1,2], reps:=""),
 rec(character:=[2], duflo:=[7,8], reps:=""),
 rec(character:=[3,5,6], duflo:=[5,8], reps:=[[6,10],[12,3]]),
 rec(character:=[4,5,6], duflo:=[7,3], reps:=[[5,10],[12,4]])]);
