#############################################################################
##
#A  tbl/weyle6.g           CHEVIE library         Meinolf Geck, Jean Michel
##
#Y  Copyright (C) 1994 - 2001  The CHEVIE Team
##
##  This file contains data for Coxeter groups of type E_6, their Hecke
##  algebra, unipotent classes and characters.
##
CHEVIE.AddData("ReflectionDegrees","E6",[2,5,6,8,9,12]);

CHEVIE.AddData("GeneratingRoots", "E6", function(arg) return
[ [1,-1,-1,-1,-1,-1,-1,1]/2,
  [1,1,0,0,0,0,0,0],
  [-1,1,0,0,0,0,0,0],
  [0,-1,1,0,0,0,0,0],
  [0,0,-1,1,0,0,0,0],
  [0,0,0,-1,1,0,0,0] ];
end);

CHEVIE.AddData("FundamentalGroup","E6",[(1,6,72)(2,3,5)]);
CHEVIE.AddData("CenterSimplyConnected","E6",[[1,0,2,0,1,2]/3]);

CHEVIE.AddData("NrConjugacyClasses", "E6", 25);

CHEVIE.AddData("WordsClassRepresentatives","E6",
  [ [ ], [ 3, 4, 3, 2, 4, 3, 5, 4, 3, 2, 4, 5 ], [ 1, 4 ],
  [ 1, 3, 1, 4, 3, 1, 2, 4, 5, 4, 3, 1, 2, 4, 3, 5, 6, 5, 4, 3, 2, 4, 5, 6 ],
  [ 1, 3 ], [ 1, 3, 5, 6 ], [ 3, 4, 3, 2, 4, 5 ], [ 1, 4, 3, 6 ],
  [ 1, 4, 3, 2 ], [ 1, 2, 3, 1, 5, 4, 6, 5, 4, 2, 3, 4 ], [ 3, 4, 2, 5 ],
  [ 1, 2, 3, 4, 2, 3, 4, 6, 5, 4, 2, 3, 4, 5 ], [ 1, 3, 2, 5 ],
  [ 1, 3, 4, 3, 2, 4, 5, 6 ], [ 1, 4, 6, 2, 3, 5 ], [ 1 ], [ 1, 4, 6 ],
  [ 1, 3, 4, 3, 2, 4, 3, 5, 4, 3, 2, 4, 5 ], [ 1, 4, 3 ], [ 1, 3, 2 ],
  [ 1, 3, 2, 5, 6 ], [ 1, 4, 6, 3, 5 ], [ 1, 3, 4, 2, 5 ],
  [ 1, 4, 3, 2, 6 ], [ 1, 4, 2, 5, 4, 2, 3 ] ]);

CHEVIE.AddData("ClassNames","E6",
  [ "A_0", "4A_1", "2A_1", "3A_2", "A_2", "2A_2", "D_4(a_1)",
  "A_3+A_1", "A_4", "E_6(a_2)", "D_4", "A_5+A_1", "A_2+2A_1",
  "E_6(a_1)", "E_6", "A_1", "3A_1", "A_3+2A_1", "A_3", "A_2+A_1",
  "2A_2+A_1", "A_5", "D_5", "A_4+A_1", "D_5(a_1)" ]);

CHEVIE.AddData("ClassInfo","E6",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","E6"),
    classnames:=CHEVIE.RawData("ClassNames","E6"),
    classparams:=CHEVIE.RawData("ClassNames","E6"),
    orders:=[1,2,2,3,3,3,4,4,5,6,6,6,6,9,12,2,2,4,4,6,6,6,8,10,12],
    classes:=[ 1, 45, 270, 80, 240, 480, 540, 3240, 5184,
    720, 1440, 1440, 2160, 5760, 4320, 36, 540, 540, 1620, 1440, 1440, 4320,
    6480, 5184, 4320 ]));

CHEVIE.AddData("ParabolicRepresentatives", "E6", 
function(s)local t;t:=[[[]],[[1]],[[1,2],[1,3]],[[1..3],[1,2,5],[1,3,4]],
   [[1..4],[1,2,3,5],[1,2,4,5],[1,3,5,6],[2..5]],
   [[1..5],[1,3,4,5,6],[1,2,3,4,6],[1,2,3,5,6]],[[1..6]]];
  return t[s+1];end);

CHEVIE.AddData("CharInfo","E6",function()local res;
  res:=rec(charparams:=[[1,0],[1,36],[10,9],[6,1],[6,25],[20,10],[15,5],
    [15,17],[15,4],[15,16],[20,2],[20,20],[24,6],[24,12],[30,3],[30,15],[60,8],
    [80,7],[90,8],[60,5],[60,11],[64,4],[64,13],[81,6],[81,10]],
  frame:=["1_p","1_p'", "10_s", "6_p", "6_p'", "20_s", "15_p", "15_p'", "15_q",
  "15_q'", "20_p", "20_p'", "24_p", "24_p'", "30_p", "30_p'", "60_s", "80_s",
  "90_s", "60_p", "60_p'", "64_p", "64_p'", "81_p", "81_p'" ],
  extRefl:=[1,4,7,6,8,5,2]);
  res.b:=List(res.charparams,x->x[2]);
  return res;
end);

CHEVIE.AddData("cyclestructure","E6",
  [ [  ], [ 36 ], [ 30 ], [ , 24 ], [ , 20 ],
  [ , 22 ], [ ,, 18 ], [ 5,, 15 ],
  [ ,,, 14 ], [ ,,,, 12 ], [ 6,,,, 10 ], [ 3,,,, 11 ], [ 6, 4,,, 8 ],
  [ ,,,,,,, 8 ], [ ,,,,,,,,,, 6 ],
  [ 21 ], [ 35 ], [ 6,, 15 ], [ 4,, 15 ],
  [ 3, 8,,, 6 ], [ 3, 10,,, 6 ], [ 2,,,, 11 ], [ ,,,,,, 9 ],
  [ 1,,, 6,,,,, 4 ], [ ,, 3,, 2,,,,,, 4 ] ]);

CHEVIE.AddData("generators","E6",
  [ ( 1,37)( 3, 7)( 9,12)(13,17)(15,18)(19,22)(21,23)(24,26)(25,27)(28,30)
  (31,33)(39,43)(45,48)(49,53)(51,54)(55,58)(57,59)(60,62)(61,63)(64,66)
  (67,69), ( 2,38)( 4, 8)
  ( 9,13)(10,14)(12,17)(15,19)(16,20)(18,22)(21,25)
  (23,27)(35,36)(40,44)(45,49)(46,50)(48,53)(51,55)(52,56)(54,58)(57,61)
  (59,63)(71,72), ( 1, 7)
  ( 3,39)( 4, 9)( 8,13)(10,15)(14,19)(16,21)(20,25)
  (26,29)(30,32)(33,34)(37,43)(40,45)(44,49)(46,51)(50,55)(52,57)(56,61)
  (62,65)(66,68)(69,70), ( 2, 8)
  ( 3, 9)( 4,40)( 5,10)( 7,12)(11,16)(19,24)
  (22,26)(25,28)(27,30)(34,35)(38,44)(39,45)(41,46)(43,48)(47,52)(55,60)
  (58,62)(61,64)(63,66)(70,71),
  ( 4,10)( 5,41)( 6,11)( 8,14)( 9,15)(12,18)
  (13,19)(17,22)(28,31)(30,33)(32,34)(40,46)(42,47)(44,50)(45,51)(48,54)
  (49,55)(53,58)(64,67)(66,69)
  (68,70), ( 5,11)( 6,42)(10,16)(14,20)(15,21)
  (18,23)(19,25)(22,27)
  (24,28)(26,30)(29,32)(41,47)(46,52)(50,56)(51,57)
  (54,59)(55,61)(58,63)(60,64)(62,66)(65,68) ]);

CHEVIE.AddData("CartanMat","E6",
  [[2,0,-1,0,0,0],[0,2,0,-1,0,0],[-1,0,2,-1,0,0],
   [0,-1,-1,2,-1,0], [0,0,0,-1,2,-1],[0,0,0,0,-1,2]]);

CHEVIE.AddData("PowerMaps","E6",
  [,[1,1,1,4,5,6,2,3,9,4,5,6,5,14,10,1,1,3,3,5,6,6,7,9,13],
  [1,2,3,1,1,1,7,8,9,2,2,2,3,4,7,16,17,18,19,16,16,17,23,24,18],,
  [1,2,3,4,5,6,7,8,1,10,11,12,13,14,15,16,17,18,19,20,21,22,23,16,25]]);

CHEVIE.AddData("vpolheckeirreducibles","E6",
  [[[[1],0],[[1],12],[[1],2],[[1],24],[[1],2],
   [[1],4],[[1],6],[[1],4],[[1],4],[[1],12],
   [[1],4],[[1],14],[[1],4],[[1],8],[[1],6],
   [[1],1],[[1],3],[[1],13],[[1],3],[[1],3],
   [[1],5],[[1],5],[[1],5],[[1],5],[[1],7]],
  [[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
   [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
   [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
   [[-1],0],[[-1],0],[[-1],0],[[-1],0],
   [[-1],0],[[-1],0],[[-1],0],[[-1],0],
   [[-1],0],[[-1],0]], [[[10],0],[[-6],6],[[3,-4,3],0],[[1],12],
      [[1,-4,1],0],[[1,0,2,0,1],0],[[2],3],
      [[-1,0,-1],1],[[],0],[[-3],6],[[],0],
      [[-1,2,-1],6],[[1,-1,2,-1,1],0],[[1],4],
      [[-1],3],[[-5,5],0],[[-2,3,-3,2],0],
      [[3,-3],6],[[1,-1],1],[[-1,2,-2,1],0],
      [[-1,0,-1,1,0,1],0],[[],0],[[],0],[[],0],
      [[],0]], [[[6],0],[[-4,0,0,2],9],[[-2,4],1],[[-3],20],
      [[-1,4],1],[[-2,2],3],[[2],6],[[-2,2],3],
      [[-1,2],3],[[1],10],[[-1,2],3],[[-2],11],
      [[-3,2],3],[[],0],[[-1],5],[[-1,5],0],
      [[-3,3],2],[[-3,0,0,1],10],[[-1,3],2],
      [[-2,3],2],[[-3,1],4],[[-1,1],4],[[-1,1],4],
      [[-2,1],4],[[1],7]], [[[6],0],[[2,0,0,-4],0],[[4,-2],0],[[-3],4],
      [[4,-1],0],[[2,-2],0],[[2],0],[[2,-2],0],
      [[2,-1],0],[[1],2],[[2,-1],0],[[-2],3],
      [[2,-3],0],[[],0],[[-1],1],[[-5,1],0],
      [[-3,3],0],[[-1,0,0,3],0],[[-3,1],0],
      [[-3,2],0],[[-1,3],0],[[-1,1],0],[[-1,1],0],
      [[-1,2],0],[[-1],0]], [[[20],0],[[-4,0,0,12,0,0,-4],3],[[4,-12,4],0],
      [[-7],12],[[4,-6,4],0],[[-2,6,-2],1],
      [[4],3],[[-2,4,-2],1],[[-1,2,-1],1],[[1],6],
      [[-1,0,-1],1],[[-2],7],[[-3,8,-3],1],
      [[-1],4],[[1],3],[[-10,10],0],
      [[-1,9,-9,1],0],[[-1,0,-3,3,0,1],4],
      [[-1,3,-3,1],0],[[-1,6,-6,1],0],[[-5,5],2],
      [[-1,1],2],[[],0],[[-2,2],2],[[-1,1],3]],
  [[[15],0],[[6,0,0,-8,0,0,1],6],[[1,-8,6],0],
      [[6],16],[[1,-4,6],0],[[3,-4,1],2],
      [[2,0,0,1],3],[[2,-4,1],2],[[1,-2,1],2],
      [[2],8],[[-2,1],3],[[1,0,1],8],[[4,-6,1],2],
      [[],0],[[],0],[[-5,10],0],[[3,-9,3],1],
      [[3,0,1,-3],7],[[1,-3,3],1],[[2,-6,3],1],
      [[5,-3],3],[[1,-1],3],[[-1],4],[[2,-2],3],
      [[1],4]], [[[15],0],[[1,0,0,-8,0,0,6],0],[[6,-8,1],0],
      [[6],8],[[6,-4,1],0],[[1,-4,3],0],
      [[1,0,0,2],0],[[1,-4,2],0],[[1,-2,1],0],
      [[2],4],[[1,-2],0],[[1,0,1],4],[[1,-6,4],0],
      [[],0],[[],0],[[-10,5],0],[[-3,9,-3],0],
      [[3,-1,0,-3],3],[[-3,3,-1],0],[[-3,6,-2],0],
      [[3,-5],1],[[1,-1],1],[[1],1],[[2,-2],1],
      [[-1],3]], [[[15],0],[[2,0,9,-4],6],[[2,-6,7],0],
      [[-3],16],[[-5,5],1],[[2,-2,3],2],[[2,-3],3],
      [[1,-2,2],2],[[-1,1],3],[[1],8],[[-1,-1],2],
      [[1],10],[[-1,2,-4,3],1],[[],0],[[-1],4],
      [[-5,10],0],[[-1,3,-6,5],0],[[4,-1],9],
      [[-3,2],2],[[2,-4,4],1],[[-1,1,-3,2],2],
      [[1],5],[[-1],3],[[-1,1],4],[[1,-1],4]],
  [[[15],0],[[-4,9,0,2],3],[[7,-6,2],0],
      [[-3],8],[[5,-5],0],[[3,-2,2],0],[[-3,2],2],
      [[2,-2,1],0],[[1,-1],0],[[1],4],[[-1,-1],1],
      [[1],4],[[3,-4,2,-1],0],[[],0],[[-1],2],
      [[-10,5],0],[[-5,6,-3,1],0],[[1,-4],3],
      [[-2,3],0],[[-4,4,-2],0],[[-2,3,-1,1],0],
      [[-1],0],[[1],2],[[-1,1],0],[[1,-1],2]],
  [[[20],0],[[9,-8,0,0,3],8],[[1,-8,11],0],
      [[2],18],[[-5,10],1],[[1,-6,4],2],
      [[-3,0,3],4],[[1,-5,4],2],[[-3,3],3],
      [[-2],9],[[-2,3],3],[[2,-1],10],[[3,-7,5],2],
      [[-1],6],[[],0],[[-5,15],0],[[3,-9,8],1],
      [[5,-4,0,0,1],9],[[-4,6],2],[[1,-7,7],1],
      [[3,-5,3],3],[[-2,1],4],[[-1,1],4],
      [[1,-3,2],3],[[-2,0,1],5]],
  [[[20],0],[[3,0,0,-8,9],0],[[11,-8,1],0],
      [[2],6],[[10,-5],0],[[4,-6,1],0],
      [[3,0,-3],0],[[4,-5,1],0],[[3,-3],0],
      [[-2],3],[[3,-2],0],[[-1,2],3],[[5,-7,3],0],
      [[-1],2],[[],0],[[-15,5],0],[[-8,9,-3],0],
      [[-1,0,0,4,-5],0],[[-6,4],0],[[-7,7,-1],0],
      [[-3,5,-3],0],[[-1,2],0],[[-1,1],0],
      [[-2,3,-1],0],[[-1,0,2],0]],
  [[[24],0],[[-2,0,9,0,0,0,1],6],[[4,-12,8],0],
      [[6],14],[[2,-8,6],0],[[1,0,5,-4,1],0],
      [[2,-3,0,1],3],[[-1,3,-3,1],1],[[1,-2],2],
      [[2],7],[[1,0,1],2],[[-2,1],8],
      [[-3,6,-5,2],1],[[],0],[[],0],[[-10,14],0],
      [[-1,9,-9,5],0],[[-2,0,2],7],[[2,-4,2],1],
      [[-1,4,-8,3],0],[[1,-3,4,-2,1],1],[[1],3],
      [[],0],[[-1,1,-1],2],[[1,-1],4]],
  [[[24],0],[[1,0,0,0,9,0,-2],0],[[8,-12,4],0],
      [[6],10],[[6,-8,2],0],[[1,-4,5,0,1],0],
      [[1,0,-3,2],0],[[1,-3,3,-1],0],[[-2,1],1],
      [[2],5],[[1,0,1],0],[[1,-2],5],
      [[2,-5,6,-3],0],[[],0],[[],0],[[-14,10],0],
      [[-5,9,-9,1],0],[[-2,0,2],4],[[-2,4,-2],0],
      [[-3,8,-4,1],0],[[-1,2,-4,3,-1],0],[[-1],2],
      [[],0],[[1,-1,1],1],[[1,-1],2]],
  [[[30],0],[[-8,0,9,-12,0,0,1],6],[[3,-14,13],0],
      [[3],16],[[1,-9,11],0],[[5,-6,4],2],
      [[-3,0,1],4],[[3,-6,3],2],[[1,-3,2],2],
      [[-1],8],[[1,-3,1],2],[[-1],8],
      [[-1,6,-10,4],1],[[],0],[[1],4],[[-10,20],0],
      [[-1,6,-15,8],0],[[-3,0,3,-4],7],[[1,-6,5],1],
      [[4,-10,7],1],[[-1,6,-6,2],2],[[1,-1,1],3],
      [[1,-1],3],[[2,-3,1],3],[[-1],5]],
  [[[30],0],[[1,0,0,-12,9,0,-8],0],[[13,-14,3],0],
      [[3],8],[[11,-9,1],0],[[4,-6,5],0],
      [[1,0,-3],0],[[3,-6,3],0],[[2,-3,1],0],
      [[-1],4],[[1,-3,1],0],[[-1],6],
      [[4,-10,6,-1],0],[[],0],[[1],2],[[-20,10],0],
      [[-8,15,-6,1],0],[[4,-3,0,3],3],[[-5,6,-1],0],
      [[-7,10,-4],0],[[-2,6,-6,1],0],[[-1,1,-1],0],
      [[1,-1],1],[[-1,3,-2],0],[[1],2]],
  [[[60],0],[[9,0,-6,0,9],4],[[16,-28,16],0],
      [[-3],12],[[8,-22,8],0],[[2,-6,8,-6,2],0],
      [[-3,10,-3],2],[[1,-4,6,-4,1],0],[[-1,2,-1],1],
      [[-3],6],[[],0],[[-1,2,-1],6],
      [[3,-10,12,-10,3],0],[[],0],[[1],3],
      [[-30,30],0],[[-9,21,-21,9],0],
      [[-1,0,5,-5,0,1],4],[[-1,7,-7,1],0],
      [[-5,14,-14,5],0],[[-1,5,-6,6,-5,1],0],[[],0],
      [[1,-1],2],[[1,-1,1,-1],1],[[-2,2],3]],
  [[[80],0],[[-4,9,0,-26,0,9,-4],3],[[20,-40,20],0],
      [[-10],12],[[12,-28,12],0],[[2,-8,14,-8,2],0],
      [[-3,6,-3],2],[[1,-6,10,-6,1],0],[[-2,4,-2],1],
      [[2],6],[[-1,4,-1],1],[[1,0,1],6],
      [[3,-13,20,-13,3],0],[[-1],4],[[],0],
      [[-40,40],0],[[-10,30,-30,10],0],[[8,-8],6],
      [[-2,10,-10,2],0],[[-6,20,-20,6],0],
      [[-1,5,-11,11,-5,1],0],[[-1,1],2],[[-1,1],2],
      [[1,-3,3,-1],1],[[-1,1],3]],
  [[[90],0],[[-8,9,0,-8,0,9,-8],3],[[21,-48,21],0],
      [[9],12],[[15,-30,15],0],[[1,-10,18,-10,1],0],
      [[-3,8,-3],2],[[1,-7,14,-7,1],0],[[-3,6,-3],1],
      [[-3],6],[[-2,4,-2],1],[[-1,2,-1],6],
      [[2,-15,26,-15,2],0],[[],0],[[-1],3],
      [[-45,45],0],[[-9,36,-36,9],0],
      [[-1,0,2,-2,0,1],4],[[-3,12,-12,3],0],
      [[-6,24,-24,6],0],[[5,-15,15,-5],1],[[-2,2],2],
      [[-1,1],2],[[1,-5,5,-1],1],[[-2,2],3]],
  [[[60],0],[[-14,0,18,-8],6],[[11,-28,21],0],
      [[6],14],[[4,-21,14],0],[[-4,7,-10,4],1],
      [[6,-6],3],[[-2,6,-7,3],1],[[2,-3,1],2],
      [[2],7],[[1,-2],2],[[1,-2],7],
      [[1,-6,13,-13,6],0],[[],0],[[],0],
      [[-25,35],0],[[-5,18,-24,13],0],
      [[3,-8,0,4,-1],6],[[4,-10,4],1],
      [[-2,11,-17,9],0],[[2,-5,8,-7,3],1],[[-1],4],
      [[],0],[[-1,2,-2,1],2],[[2,-1],4]],
  [[[60],0],[[-8,18,0,-14],3],[[21,-28,11],0],
      [[6],10],[[14,-21,4],0],[[4,-10,7,-4],0],
      [[-6,6],2],[[3,-7,6,-2],0],[[1,-3,2],0],
      [[2],5],[[-2,1],1],[[-2,1],6],
      [[6,-13,13,-6,1],0],[[],0],[[],0],
      [[-35,25],0],[[-13,24,-18,5],0],
      [[1,-4,0,8,-3],3],[[-4,10,-4],0],
      [[-9,17,-11,2],0],[[-3,7,-8,5,-2],0],[[1],1],
      [[],0],[[-1,2,-2,1],0],[[1,-2],2]],
  [[[64],0],[[-4,0,18,-16,0,0,2],6],[[8,-32,24],0],
      [[-8],15],[[4,-20,20],0],[[-2,10,-14,4],1],
      [[4,-6,0,2],3],[[-1,8,-11,4],1],[[3,-6,2],2],
      [[],0],[[2,-4,2],2],[[],0],
      [[-4,16,-18,6],1],[[1],5],[[],0],
      [[-24,40],0],[[-2,18,-30,14],0],[[-2,0,6,-4],7],
      [[4,-12,8],1],[[-1,10,-22,11],0],
      [[-6,12,-10,2],2],[[2,-2],3],[[1,-1],3],
      [[-1,5,-4,1],2],[[2,-2],4]],
  [[[64],0],[[2,0,0,-16,18,0,-4],0],[[24,-32,8],0],
      [[-8],9],[[20,-20,4],0],[[4,-14,10,-2],0],
      [[2,0,-6,4],0],[[4,-11,8,-1],0],[[2,-6,3],0],
      [[],0],[[2,-4,2],0],[[],0],
      [[6,-18,16,-4],0],[[1],3],[[],0],
      [[-40,24],0],[[-14,30,-18,2],0],[[4,-6,0,2],3],
      [[-8,12,-4],0],[[-11,22,-10,1],0],
      [[-2,10,-12,6],0],[[2,-2],1],[[1,-1],1],
      [[-1,4,-5,1],0],[[2,-2],2]],
  [[[81],0],[[9,0,-6,0,18,-12],4],[[15,-42,24],0],
      [[],0],[[9,-27,18],0],[[-6,15,-12,3],1],
      [[-3,6,-6],2],[[-4,11,-10,2],1],
      [[-1,5,-4,1],1],[[],0],[[3,-3],2],[[],0],
      [[1,-9,22,-18,4],0],[[],0],[[],0],
      [[-36,45],0],[[-6,27,-36,12],0],
      [[1,2,-2,-1,4,-1],5],[[-1,8,-13,5],0],
      [[-3,18,-24,9],0],[[2,-10,15,-8,1],1],
      [[-1,2,-1],2],[[1],3],[[-3,5,-3],2],
      [[-1,2,-1],3]],[[[81],0],[[-12,18,0,-6,0,9],3],[[24,-42,15],0],
      [[],0],[[18,-27,9],0],[[3,-12,15,-6],0],
      [[-6,6,-3],2],[[2,-10,11,-4],0],
      [[1,-4,5,-1],0],[[],0],[[-3,3],1],[[],0],
      [[4,-18,22,-9,1],0],[[],0],[[],0],
      [[-45,36],0],[[-12,36,-27,6],0],
      [[1,-4,1,2,-2,-1],3],[[-5,13,-8,1],0],
      [[-9,24,-18,3],0],[[-1,8,-15,10,-2],0],
      [[1,-2,1],1],[[-1],2],[[3,-5,3],1],
      [[1,-2,1],2]]]);

CHEVIE.AddData("CycPolSchurElements","E6",
  [[1,0,2,2,2,2,3,3,3,4,4,5,6,6,8,9,12],
  [1,-36,2,2,2,2,3,3,3,4,4,5,6,6,8,9,12], [3,-7,2,2,2,2,3,3,3,4,4],
  [1,-1,2,2,2,2,3,3,3,4,4,5,6,6,12], [1,-25,2,2,2,2,3,3,3,4,4,5,6,6,12],
  [6,-7,2,2,2,2,3,3,3,12], [2,-3,2,2,2,2,3,3,3,4,4,12],
  [2,-15,2,2,2,2,3,3,3,4,4,12], [2,-3,2,2,2,2,3,3,3,4,4,6,6],
  [2,-15,2,2,2,2,3,3,3,4,4,6,6], [1,-2,2,2,2,2,3,3,3,4,6,6,9],
  [1,-20,2,2,2,2,3,3,3,4,6,6,9], [1,-6,2,2,2,2,3,3,3,5,6,6],
  [1,-12,2,2,2,2,3,3,3,5,6,6], [2,-3,2,2,2,2,3,3,3,6,6,8],
  [2,-15,2,2,2,2,3,3,3,6,6,8], [2,-7,2,2,2,2,3,3,3,6,6],
  [6,-7,3,3,3,4,4,6,6], [3,-7,2,2,2,2,4,4,9],
  [1,-5,2,2,2,2,3,3,3,4,6,6], [1,-11,2,2,2,2,3,3,3,4,6,6],
  [1,-4,2,3,3,3,5,9], [1,-13,2,3,3,3,5,9], [1,-6,2,2,2,2,4,4,5,8],
  [1,-10,2,2,2,2,4,4,5,8]]);

CHEVIE.AddData("sparseFakeDegrees","E6",
[[1,0],[1,36],[1,9,1,13,1,15,1,16,1,17,1,19,1,20,1,21,1,23,1,27],[1,1,1,4,1,5,
1,7,1,8,1,11],[1,25,1,28,1,29,1,31,1,32,1,35],[1,10,1,12,2,13,1,14,3,16,2,17,
2,19,3,20,1,22,2,23,1,24,1,26],[1,5,1,6,1,8,2,9,1,11,3,12,1,13,2,15,1,16,1,18,
1,19],[1,17,1,18,1,20,2,21,1,23,3,24,1,25,2,27,1,28,1,30,1,31],[1,4,1,6,1,7,1,
8,2,10,1,11,1,12,1,13,2,14,1,16,1,17,1,18,1,20],[1,16,1,18,1,19,1,20,2,22,1,
23,1,24,1,25,2,26,1,28,1,29,1,30,1,32],[1,2,1,3,1,4,1,5,2,6,1,7,2,8,2,9,2,10,
1,11,2,12,1,13,1,14,1,15,1,16],[1,20,1,21,1,22,1,23,2,24,1,25,2,26,2,27,2,28,
1,29,2,30,1,31,1,32,1,33,1,34],[1,6,1,8,1,9,1,10,1,11,3,12,1,13,2,14,2,15,2,
16,1,17,3,18,1,19,1,20,1,21,1,22,1,24],[1,12,1,14,1,15,1,16,1,17,3,18,1,19,2,
20,2,21,2,22,1,23,3,24,1,25,1,26,1,27,1,28,1,30],[1,3,1,5,1,6,2,7,1,8,3,9,2,
10,3,11,2,12,3,13,2,14,3,15,1,16,2,17,1,18,1,19,1,21],[1,15,1,17,1,18,2,19,1,
20,3,21,2,22,3,23,2,24,3,25,2,26,3,27,1,28,2,29,1,30,1,31,1,33],[1,8,1,9,2,10,
1,11,3,12,3,13,4,14,3,15,6,16,4,17,4,18,4,19,6,20,3,21,4,22,3,23,3,24,1,25,2,
26,1,27,1,28],[1,7,1,9,2,10,3,11,2,12,6,13,4,14,5,15,6,16,8,17,4,18,8,19,6,20,
5,21,4,22,6,23,2,24,3,25,2,26,1,27,1,29],[1,8,2,9,1,10,3,11,4,12,4,13,5,14,8,
15,6,16,7,17,8,18,7,19,6,20,8,21,5,22,4,23,4,24,3,25,1,26,2,27,1,28],[1,5,1,6,
1,7,2,8,3,9,2,10,4,11,5,12,4,13,4,14,6,15,4,16,4,17,5,18,4,19,2,20,3,21,2,22,
1,23,1,24,1,25],[1,11,1,12,1,13,2,14,3,15,2,16,4,17,5,18,4,19,4,20,6,21,4,22,
4,23,5,24,4,25,2,26,3,27,2,28,1,29,1,30,1,31],[1,4,1,5,1,6,3,7,3,8,3,9,5,10,5,
11,4,12,6,13,6,14,4,15,5,16,5,17,3,18,3,19,3,20,1,21,1,22,1,23],[1,13,1,14,1,
15,3,16,3,17,3,18,5,19,5,20,4,21,6,22,6,23,4,24,5,25,5,26,3,27,3,28,3,29,1,30,
1,31,1,32],[1,6,1,7,2,8,2,9,4,10,4,11,5,12,5,13,7,14,6,15,7,16,6,17,7,18,5,19,
5,20,4,21,4,22,2,23,2,24,1,25,1,26],[1,10,1,11,2,12,2,13,4,14,4,15,5,16,5,17,
7,18,6,19,7,20,6,21,7,22,5,23,5,24,4,25,4,26,2,27,2,28,1,29,1,30]]);

#############################################################################
##
#F  CHEVIE.RawData("ClassParameter","E6")( <w> )   . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type E_6  as word in  standard
##  generators, returns the classname of its conjugacy class.
##
CHEVIE.AddData("ClassParameter","E6",function(w)
  if w=[] then return " ";fi;
  return CHEVIE.RawData("ClassNames","E6")
    [Position(CHEVIE.RawData("cyclestructure","E6"),
    CycleStructurePerm(Product(CHEVIE.RawData("generators","E6"){w})))];
end);

###########################################################################
##
#F HeckeCharTable( <v> ) character table of the Hecke algebra of type E6
##
CHEVIE.AddData("HeckeCharTable","E6",function(param,sqrtparam)local q,tbl;
  q:=-param[1][1]/param[1][2];
  tbl:=rec(
  identifier := "H(E6)",
  text := "origin: Meinolf Geck, April 1992",
  parameter:=param,rootparameter:=sqrtparam,
  cartan:=CHEVIE.RawData("CartanMat","E6"),
  size := 51840,
  powermap:=CHEVIE.RawData("PowerMaps","E6"),
  irreducibles:=List(CHEVIE.RawData("vpolheckeirreducibles","E6"),
                     i->List(i,j->ValuePol(j[1],q)*q^j[2])),
  irredinfo:=List(CHEVIE.RawData("CharInfo","E6")().charparams,x->
    rec(charparam:=x,charname:=CHEVIE.RawData("CharName","E6")(x,rec()))));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","E6"));
  tbl.centralizers := List(tbl.classes,x->tbl.size/x);
  tbl := CHEVIE.compat.MakeCharacterTable(tbl);
  CHEVIE.compat.AdjustHeckeCharTable(tbl,param);
  return tbl;
end);

## W-graphs Copyright (C) December 2002   (2002.12.08 version1.0)
## Hiroshi Naruse  rdcv1654@cc.okayama-u.ac.jp   Okayama Univ. Fac. of Edu.
##  The W-graphs were calculated in July 1998.
##  The  method of  getting irreducible  representations from  left cell
##  will be explained in a paper "W-graphs for type E_6" in preparation.
#
# see  the comments  before  WGraphToRepresentation for  the format.  An
# integer instead  of a  graph says that  the graph is  dual to  that of
# index specified by the integer.
CHEVIE.AddData("WGraphs","E6",[[[[]],[]], 1,
[[[4],[3,5],[1,2,5],[1,4,5],[1,4,6],[2,3,5],[2,3,6],[3,4,6],[1,2,4,6],[1,2,3,
5,6]],[[1,[[1,4,6,8,9],[2,4,6,8,10],[3,4,6,9,10],[4,5],[5,8,9,10],[6,7],[7,8,
9,10]]]]],
[[[1],[2],[3],[4],[5],[6]],[[1,[[1,3],[2,4],[3,4],[4,5],[5,6]]]]], 4,
[[[1,2,3],[1,2,4],[1,2,5],[1,2,6],[1,3,4],[1,3,5],[1,3,6],[1,4,5],[1,4,6],[1,
5,6],[2,3,4],[2,3,5],[2,3,6],[2,4,5],[2,4,6],[2,5,6],[3,4,5],[3,4,6],[3,5,6],
[4,5,6]],[[1,[[1,2],[2,3,11],[3,4,8,12],[4,9,13],[5,6],[6,7,8],[7,9],[8,9,17],
[9,10,18],[10,19],[11,12],[12,13,14,17],[13,15,18],[14,15],[15,16],[17,18],
[18,19],[19,20]]],[-1,[[1,5],[16,20]]]]],
[[[1,2],[1,3],[1,4],[1,5],[1,6],[2,3],[2,4],[2,5],[2,6],[3,4],[3,5],[3,6],[4,
5],[4,6],[5,6]],[[1,[[1,3,6],[2,3],[3,4,10],[4,5,11],[5,12],[6,7,10],[7,8],[8,
9,13],[9,14],[10,11],[11,12],[13,14],[14,15]]],[-1,[[11,13],[12,14]]]]], 7,
[[[2],[3],[4],1,[5],[1,4],[1,5],[3,5],[3,6],[4,6],[1,2,5],[1,2,6],[1,4,6],[2,
3,5],[2,3,6]],[[1,[[1,4,12,14],[2,6,9,14],[3,4,6,10,14],[4,8,13],[5,7,10,14],
[6,11,13],[7,8,11,13],[8,9,14],[9,13,15],[10,13,15],[11,12,14],[12,13,15],[14,
15]]]]], 9,
[[[1],[2],[3],1,[4],2,[5],1,[6],[1,2],[1,4],[1,5],[1,6],[2,3],[2,5],[2,6],[3,
5],[3,6],[4,6]],[[1,[[1,3,14],[2,6,11,17],[3,5,19],[4,12,15,18],[5,16,20],[6,
12,18,20],[7,8,12,15],[8,10,13],[9,16,18,20],[10,14],[11,12,15],[12,13],[13,
14,18],[14,19],[16,17],[17,20],[18,19],[19,20]]]]], 11,
[[[4],[1,4],[1,5],[1,6],[2,3],[2,5],[3,4],[3,5],1,[3,6],[4,5],[4,6],[1,2,3],
[1,2,4],[1,2,5],[1,2,6],[1,4,5],[1,4,6],[2,3,5],[2,3,6],[2,4,6],[2,5,6],[3,4,
6],[1,3,5,6]],[[1,[[1,7,11,14,17,19,21,23],[2,3,7,13,14],[3,4,9,15],[4,10,16],
[5,7,13,14,19],[6,11,19,21,22],[7,9],[8,17,19,23,24],[9,10,11,19],[10,12,20],
[11,12],[12,21,22],[14,15],[15,16,17,19],[16,18,20],[17,18],[18,23,24],[19,
20],[20,21,23]]]]], 13,
[[[2],[3],[4],1,[5],[1,2],[1,3],[1,4],1,[1,5],1,[1,6],[2,3],[2,4],[2,5],[2,6],
[3,4],[3,5],1,[3,6],1,[4,5],[4,6],1,[5,6],[1,2,5],[1,2,6],[1,4,6],[2,3,5],[2,
3,6]],[[1,[[1,4,27,29],[2,8,20,29],[3,4,8,23,29],[4,19,28],[5,10,23,29],[6,9,
13],[7,9],[8,26,28],[9,11,17],[10,19,26,28],[11,12,18],[12,21],[13,14,17],[14,
15],[15,16,22],[16,24],[17,18],[18,21,22],[19,20,29],[20,28,30],[21,24],[22,
24],[23,28,30],[24,25],[26,27,29],[27,28,30],[29,30]]],[[2,1],[[1,14],[2,7,
17],[3,14,17,22],[5,22,25],[8,9],[23,24],[26,6,11],[27,12],[29,13,15,18],[30,
16,21]]]]], 15,
[[[4],[1,4],1,[1,5],[2,3],[2,4],[2,5],[3,4],1,[3,5],2,[3,6],[4,5],1,[4,6],1,
[1,2,4],[1,2,5],2,[1,2,6],[1,3,5],[1,4,5],2,[1,4,6],3,[2,3,5],3,[2,3,6],2,[2,
4,6],[3,4,5],[3,4,6],2,[3,5,6],[1,2,3,5],1,[1,2,3,6],1,[1,2,4,5],[1,2,4,6],2,
[1,2,5,6],1,[1,3,4,6],[1,3,5,6],[1,4,5,6],[2,3,4,6],[2,3,5,6],1,[1,2,3,5,6]],
[[1,[[1,2,6,8,15,16,26,33,39,41,48,50,57],[2,9,18,24,25,30,45,51,54],[3,8,28,
44,48],[4,10,26,28,44,48,52,60],[5,9,18,31,37,45],[6,18,31,38],[7,14,20,31,38,
59],[8,32,40],[9,12,39,41,57],[10,11,14,32,40,59],[11,12,23,26,33,39,41,43,
60],[12,13,25,34,45],[13,29,41,46,57,58,60],[14,16,26,39,48],[15,17,25,34],
[16,30,38,40,42,49,56,59],[17,29,57,58],[18,21,50],[19,20,25,34,45,51,53],[20,
21,26,33,48,50,52,60],[21,22,24,31,45],[22,27,36,46,50,52,60],[23,24,45,54,
55],[24,26,27,39],[25,26,29],[26,30,56],[27,30,42,54,55,56],[28,30,40,47,49],
[29,30,51,53],[30,41,50,60],[31,33,36,39],[32,33,35,44,48],[33,34,37,45,59],
[34,57,58],[35,37,40,47,49,59],[36,37,38,42,59],[37,41,46,50,57,60],[38,50],
[39,42],[40,41],[41,42,54],[42,43],[43,55,56,59],[44,47],[45,46,60],[46,51,
54],[47,60],[48,49],[49,50,52],[50,51],[51,57],[52,56,59],[53,58,60],[55,60],
[59,60]]]]],
[[[4],[1,4],1,[1,5],[2,3],[2,4],[2,5],[3,4],1,[3,5],2,[3,6],[4,5],1,[4,6],1,
[1,2,3],[1,2,4],1,[1,2,5],3,[1,2,6],1,[1,3,4],[1,3,5],1,[1,3,6],[1,4,5],3,[1,
4,6],4,[1,5,6],[2,3,4],[2,3,5],4,[2,3,6],3,[2,4,5],[2,4,6],1,[2,5,6],[3,4,5],
1,[3,4,6],3,[3,5,6],1,[4,5,6],[1,2,3,5],1,[1,2,3,6],1,[1,2,4,5],[1,2,4,6],2,
[1,2,5,6],1,[1,3,4,6],[1,3,5,6],[1,4,5,6],[2,3,4,6],[2,3,5,6],1,[1,2,3,5,6]],
[[1,[[1,32,45,58,70],[2,9,19,31,34,65,71,74],[3,8,36,64,68],[4,10,36,64,68,
73],[5,9,19,43,65],[6,19,43,52],[7,14,43,52,78],[8,42,60],[9,12,55,77],[10,14,
42,60,78],[11,32,45,58,80],[12,13,34,44,65],[13,39,66,77,79],[14,16,55,68],
[15,17,34,44],[16,52,59,60,69,76,78],[17,39,77,79],[18,20,27],[19,23],[20,24,
41],[21,34,44,65,71,72],[22,32,45,70,80],[23,25,31,43,65],[24,26,33,46],[25,
37,50,66,73],[26,38,47],[27,28],[28,30,33],[29,31,65,74,75],[30,38],[31,37,
55],[32,35],[33,38,56],[34,39],[35,58,70,80],[36,60,67,69],[37,59,74,75,76],
[38,40,57],[39,71,72],[40,61],[41,46],[42,48,64,68],[43,50,55],[44,77,79],[45,
49],[46,47,51,56],[47,53,57],[48,60,67,69,78],[49,58,70,80],[50,52,59,78],[51,
53],[53,54],[54,63],[55,59],[56,57],[57,61],[59,62],[61,63],[62,75,76,78],[64,
67],[65,66],[66,71,74],[68,69],[69,73],[71,77],[72,79],[73,76,78]]],[[2,1],
[[3,20,27,33],[4,33,40],[5,18,41],[6,41,51],[7,51,54],[8,41,56],[9,27],[10,56,
61],[12,28,56],[13,30,57],[14,63],[15,51,56],[17,53,57,63],[19,20],[21,24],
[23,24],[25,26],[29,28],[31,33],[34,33],[36,38],[37,38],[39,38],[42,46],[43,
46],[44,46],[48,47],[50,47],[52,53],[55,56],[59,57],[60,57],[62,61],[64,18,24,
28],[66,18],[67,26,30],[68,24,51],[69,26,53],[71,20,26],[72,26,40],[73,54],
[74,27,30],[75,30,40],[76,40,63],[77,41,47],[79,47,54,61]]],[[3,1],[[1,2,6,8,
15,16,55,68,77],[11,10,12,29,55,62],[22,7,21,23,68,73],[32,4,14,31,34,76],[35,
2,16,36,37,39],[45,42,43,44,65,78],[49,5,48,50,66,77],[58,9,13,59,60,74],[70,
19,25,52,69,71],[80,4,13,25,65,67,72,75,78]]],[2,[[2,3],[4,21,29],[5,42],[7,
44],[8,9],[10,44],[12,42],[13,48,62],[14,15],[16,17],[19,68],[34,68],[36,71,
74],[39,69,76],[52,77],[60,77],[64,65],[66,67],[72,73],[78,79]]]]],
[[[1,4],1,[1,5],[2,3],[2,4],[2,5],[3,4],1,[3,5],1,[3,6],[4,5],1,[4,6],1,[1,2,
3],1,[1,2,4],2,[1,2,5],3,[1,2,6],2,[1,3,4],1,[1,3,5],2,[1,3,6],1,[1,4,5],3,[1,
4,6],4,[1,5,6],1,[2,3,4],1,[2,3,5],4,[2,3,6],3,[2,4,5],1,[2,4,6],2,[2,5,6],1,
[3,4,5],2,[3,4,6],3,[3,5,6],2,[4,5,6],1,[1,2,3,5],1,[1,2,3,6],1,[1,2,4,5],[1,
2,4,6],1,[1,2,5,6],1,[1,3,4,6],[1,3,5,6],[1,4,5,6],[2,3,4,6],[2,3,5,6],1],
[[-1,[[2,35,82],[3,31],[4,50],[8,9,88],[9,77],[11,79],[16,79],[17,76,79],[19,
80],[22,77],[24,76,80],[26,78,81],[28,30,85],[29,85],[34,85,86],[43,85],[45,
86,87],[58,80],[61,81],[62,84],[74,87],[79,82]]],[[-1,0],[[36,24],[42,26],[64,
49],[70,53],[74,63]]],[[1,0],[[21,38],[25,40],[51,65],[56,68],[62,75]]],[1,
[[1,7,18,29,36,43,76,80],[2,8,19,37,77,85],[3,10,22,36,43,45,76,80,84],[4,8,
17,19,47,48,77],[5,19,47,48,58,60],[6,12,48,52,58,60,62,90],[7,46,50,64,69],
[8,28,66],[9,11,30,35,50,52,65],[10,12,50,52,64,69,71,90],[11,33,39,54,68,72,
88,89],[12,15,66,74,80],[13,14,35,52,57,58,65],[14,39,59,61,68,75,88,89],[15,
60,67,69,81,87,90],[16,18,29],[17,20,28],[18,21,46,82],[19,23],[20,24,47,82],
[21,25,36,51],[22,35,52,82,83],[23,27,37,48,77],[24,26,38,49],[25,42,56,82,
83],[26,40,53,82,83],[27,41,55,79,84],[29,32],[30,33,38,76],[31,37,77,85,86],
[32,34,36],[33,40,78,85,86],[34,42],[35,39,80],[36,42,64],[37,41,66],[38,40,
65],[39,81,82,83,87],[40,44,68],[41,67,85,86,87],[42,45,70],[43,69,78,81,82],
[44,73,86,87],[45,71,83],[46,51,88],[47,49,88],[48,55,66],[49,53,58,65],[50,
54,76,80],[51,56,57,64],[52,88,89],[53,61,68,88,89],[54,69,78,81,90],[55,60,
67,90],[56,59,70,88,89],[57,59],[58,61],[59,63],[60,88],[61,62],[62,74,89],
[63,75,89],[64,70],[65,68],[66,67],[67,72],[68,73],[69,88],[70,71],[71,74,89],
[72,86,87,90],[73,75],[75,87],[76,78],[77,79],[79,85],[80,81],[81,84],[82,88],
[83,89],[84,87,90]]],[2,[[16,76],[21,76,80],[25,78,81],[32,76],[34,78],[44,
83],[57,80],[59,81],[63,84],[73,89]]]]],
[[[3],[4],2,[5],[1,2],[1,4],2,[1,5],1,[2,3],1,[2,4],[2,5],1,[2,6],[3,4],1,[3,
5],3,[3,6],1,[4,5],1,[4,6],2,[1,2,4],[1,2,5],2,[1,2,6],1,[1,3,5],[1,3,6],[1,4,
5],1,[1,4,6],3,[1,5,6],[2,3,5],2,[2,3,6],2,[2,4,6],[3,4,6],1,[3,5,6],[1,2,3,
5],[1,2,3,6],[1,2,4,6],[1,2,5,6],[2,3,5,6]],[[1,[[1,9,18,21,38,46,51,53,56],
[2,3,18,29,31,40,48],[3,4,8,14,19,26,28,39,47,54,58],[4,9,27,46,52,53],[5,22,
27,29,34,40,45,48,60],[6,7,12,31,34,36,56],[7,8,19,37,39,43],[8,9,18,31,40,42,
56],[9,33,39,43,58],[10,11,22,34,40,42,45,56],[11,23,33,37,39,43,59],[12,13,
14,19,47,49],[13,18,31,48,51,56],[14,16,31,52],[15,16,27,34,46,52,60],[16,17,
26,32,47],[17,30,35,51,52,60],[18,19,20,54],[19,21,53],[20,21,22,24,40,48,56],
[21,23,25,37,39,47],[22,23,26,47,54,55],[23,27,46,53,60],[24,25,44,50,54,55,
57],[25,38,41,51,53,60],[26,27,30,40],[27,28,39],[28,29,30,41,52,53,60],[29,
44,50,54,58],[30,44,54,55],[31,32,58],[32,34,35,40,48,56],[33,34,36,46,56],
[34,39,47,58,59],[35,44,50,57,58,59],[36,43,49,57,58,59],[37,38,56],[38,43,
57],[39,40,41],[40,44],[41,43,44,58,59],[42,43,44,54,57,58],[43,53],[44,45],
[45,55,59],[46,47,49],[47,48,51,56,60],[48,50],[49,51,52,53,60],[50,51,60],
[51,54,57,58],[52,58],[53,54],[55,60],[56,57],[59,60]]]]], 20,
[[[3],[4],1,[5],[1,2],1,[1,3],[1,4],3,[1,5],2,[1,6],1,[2,3],2,[2,4],1,[2,5],2,
[2,6],1,[3,4],2,[3,5],3,[3,6],2,[4,5],2,[4,6],3,[5,6],[1,2,3],[1,2,4],[1,2,5],
1,[1,2,6],1,[1,3,5],[1,3,6],[1,4,5],[1,4,6],1,[1,5,6],[2,3,5],1,[2,3,6],1,[2,
4,6],[2,5,6],[3,4,6],[3,5,6]],[[1,[[1,7,8,17,28,31,52,57,63],[2,3,8,21,28,37,
38,57,61,63],[3,20,27,29,39,43,46,53,58],[4,24,32,39,43,44,53,56,58],[5,10,19,
48,49],[6,11,18,45,46,47],[7,11,45],[8,11,46,47,53,55],[9,11,14,29,45,46],[10,
27,51,53,55],[11,12,28],[12,14,15,30,47],[13,32,47,51,53,55,56],[14,16,33,48],
[15,16,36,49],[16,34,50],[17,18,29,45,46,58],[18,21,28,57],[19,20,27,58,60],
[20,23,61],[21,22,46],[22,25,37,48,57],[23,24,26,39,58],[24,38,57,61,62],[25,
41,50,60],[26,42,59,61,62],[27,31,63],[28,29,30],[29,33],[30,33,36,38,57],[31,
32,35,51,53,58],[32,37,57,63,64],[33,34,39,58],[34,36,42,59],[35,52,54,59,63,
64],[36,40,60],[37,41,53],[38,39,40],[39,42],[40,42,61,62],[41,54,63,64],[42,
43,44],[43,54,59,61,63],[44,62],[46,48],[47,48,49,57],[48,50,53,58],[49,50,55,
60],[50,54,59],[51,52],[52,55],[53,54],[54,55,56],[55,63],[56,64],[57,58,60],
[58,59],[59,60],[60,61,63]]]]], 22,
[[[4],[1,2],[1,3],[1,4],2,[1,5],1,[2,3],1,[2,4],1,[2,5],1,[2,6],[3,4],2,[3,5],
3,[3,6],1,[4,5],2,[4,6],2,[5,6],[1,2,3],[1,2,4],1,[1,2,5],3,[1,2,6],2,[1,3,4],
[1,3,5],1,[1,3,6],1,[1,4,5],2,[1,4,6],4,[1,5,6],1,[2,3,4],[2,3,5],3,[2,3,6],3,
[2,4,5],[2,4,6],1,[2,5,6],[3,4,5],[3,4,6],2,[3,5,6],1,[4,5,6],[1,2,3,5],[1,2,
3,6],[1,2,4,6],[1,2,5,6],[2,3,5,6]],[[1,[[1,4,11,12,16,26,28,48,59,70,72,79],
[2,6,10,37,40],[3,5,45],[4,17,33,34,42,47,49,50,77],[5,18,36,51],[6,16,44,48,
51],[7,20,37,47,49,50,55,56,77],[8,22,36,44,48,51,80],[9,17,34,61,65,77],[10,
12,16,32,59,63],[11,34,61,67],[12,14,33,68],[13,25,37,61,67,81],[14,15,26,35,
59,69],[15,29,39,65],[16,21,42,73],[17,19,57,70,72],[18,58,73],[19,20,23,49,
60,77],[20,26,59,70,72,74,75],[21,22,24,43,44,48,59,70],[22,25,58,73,81],[23,
54,64,72,75,78],[24,45,46,52,65,71,73,81],[25,28,48,66,70],[26,29,49,76],[27,
30,49,60],[28,52,67,68,71,73,76,81],[29,54,72,75],[30,31,54,64],[31,56],[32,
33,42,77],[33,35,57],[34,38,79],[35,39,49,60,77],[36,40,58],[37,38,48,59,79,
80],[38,41,47,61,77],[39,54,64,78],[40,51,63,80],[41,53,62,78,79,80],[42,43],
[43,46,47,77],[44,45],[45,51],[46,53,78],[47,48,53,70],[48,52],[49,54],[50,53,
54,72,78,79],[51,52,73],[52,53,79,80],[53,55,71],[54,56],[55,74,80],[56,75],
[57,60],[58,63,66],[59,61,65,77,81],[60,64],[61,62,70],[62,65,67,71,81],[63,
68,73,81],[65,72,78,79],[66,68],[67,79],[68,69],[69,76,81],[70,71],[71,72,74],
[74,76,81],[77,78],[80,81]]]]], 24]);

CHEVIE.AddData("WGraph","E6",function(i)local gr;
 gr:=CHEVIE.RawData("WGraphs","E6");
 if IsInt(gr[i]) then return DualWGraph(6,gr[gr[i]]); else return gr[i]; fi;
end);

CHEVIE.AddData("HeckeRepresentation","E6",function(param,sqrtparam,i)local v;
 if not IsBound(sqrtparam[1]) then 
     v:=GetRoot(-param[1][1]/param[1][2],2,"Representation(Hecke(E6),[",i,"])");
 else v:=sqrtparam[1];
 fi;
 return -param[1][2]*WGraphToRepresentation(6,CHEVIE.RawData("WGraph","E6")(i),v);
end);

CHEVIE.AddData("Representation","E6",function(i)
  return CHEVIE.RawData("HeckeRepresentation","E6")
  ([[1,-1],[1,-1],[1,-1],[1,-1],[1,-1],[1,-1]],[1,1,1,1,1,1],i);end);

CHEVIE.AddData("DecompositionMatrix","E6",function(p)
  if p=2 then return [[Concatenation([1..21],[24,25]),
[[1,0,0,0,0],[1,0,0,0,0],[2,1,0,0,0],[0,0,1,0,0],[0,0,1,0,0],[0,1,2,0,0],
[1,0,0,1,0],[1,0,0,1,0],[1,1,1,0,0],[1,1,1,0,0],[0,0,1,1,0],[0,0,1,1,0],
[2,1,0,1,0],[2,1,0,1,0],[2,1,1,1,0],[2,1,1,1,0],[0,1,2,0,1],[0,2,4,0,1],
[2,1,2,2,1],[0,0,1,1,1],[0,0,1,1,1],[1,1,3,1,1],[1,1,3,1,1]]],
 [[22,23],[[1],[1]]]];
  elif p=3 then return [[[1..23],
[[1,0,0,0,0,0,0,0,0,0],[0,1,0,0,0,0,0,0,0,0],[0,0,1,1,0,0,0,0,0,0],
[1,0,1,0,0,0,0,0,0,0], [0,1,0,1,0,0,0,0,0,0], [0,0,0,0,1,1,0,0,0,0],
[0,0,1,0,1,0,0,0,0,0], [0,0,0,1,0,1,0,0,0,0], [0,1,0,0,0,0,1,0,0,0],
[1,0,0,0,0,0,0,1,0,0], [1,0,1,0,0,0,1,0,0,0], [0,1,0,1,0,0,0,1,0,0],
[0,0,0,0,0,1,1,0,0,0], [0,0,0,0,1,0,0,1,0,0], [0,0,1,0,0,0,0,0,1,0],
[0,0,0,1,0,0,0,0,0,1], [1,1,1,1,1,1,1,1,0,0], [0,0,1,1,1,1,0,0,1,1],
[0,0,0,0,2,2,0,0,1,1], [0,1,1,1,0,1,1,0,1,0], [1,0,1,1,1,0,0,1,0,1],
[0,0,1,0,1,1,1,0,1,0], [0,0,0,1,1,1,0,1,0,1]]]];
  elif p=5 then return [
[[1,13,25,23,5],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]],
[[2,14,24,22,4],[[1,0,0,0],[1,1,0,0],[0,1,1,0],[0,0,1,1],[0,0,0,1]]]];
  else return [];
  fi;
  end);

CHEVIE.AddData("UnipotentCharacters","E6",function()
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="E",indices:=[1..6],rank:=6),levi:=[],
      eigenvalue:=1,parameterExponents:=[1,1,1,1,1,1],cuspidalName:="",
      charNumbers:=[ 1 .. 25 ]),
    rec(relativeType:=rec(series:="A",indices:=[ 1, 6 ],rank:=2),levi:=[2..5],
      eigenvalue:=-1,parameterExponents:=[4,4], 
      cuspidalName:="D_4",charNumbers:=[ 27, 28, 26 ]),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),levi:=[1..6], 
      eigenvalue:=E(3),parameterExponents:=[], 
      cuspidalName:="E_6[\\zeta_3]",charNumbers:=[ 29 ]),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),levi:=[1..6],
      eigenvalue:=E(3)^2,parameterExponents:=[  ], 
      cuspidalName:="E_6[\\zeta_3^2]",charNumbers:=[ 30 ])],
  families:=[
    Family("C1",[ 1 ]),
    Family("C1",[ 2 ]),
    Family("C1",[ 4 ]),
    Family("C1",[ 5 ]),
    Family("C1",[ 11 ]),
    Family("C1",[ 12 ]),
    Family("C1",[ 13 ]),
    Family("C1",[ 14 ]),
    Family("C1",[ 20 ]),
    Family("C1",[ 21 ]),
    Family("C1",[ 22 ]),
    Family("C1",[ 23 ]),
    Family("C1",[ 24 ]),
    Family("C1",[ 25 ]),
    Family("C2",[ 15, 9, 7, 26 ]),
    Family("C2",[ 16, 10, 8, 27 ]),
    Family("S3",[ 18, 17, 3, 19, 6, 28, 29, 30 ])],
  a:=[0,36,7,1,25,7,3,15,3,15,2,20,6,12,3,15,7,7,7,5,11,4,13,6,10,3,15,7,7,7],
  A:=[0,36,29,11,35,29,21,33,21,33,16,34,24,30,21,33,29,29,
     29,25,31,23,32,26,30,21,33,29,29,29]);
end);

CHEVIE.AddData("Invariants","E6",function()local r;
 r:=CoxeterGroup("E",6).roots{[1..36]}*CartanMat("E",6); 
 return 
 [ function(arg)return Sum(r,a->(arg*a)^2);end,

 function(a,b,c,d,e,f)return
-a*b*c*d^2-a*c*d*e^2-a*c*e*f^2+b*d*e*f^2-c*d*e*f^2+a*b*c^2*d+a*c*d^2*e+
a*c*e^2*f-b*d*e^2*f+c*d*e^2*f+a*b^2*c*d-a*c^2*d*e-a*c^2*e*f+b*d^2*e*f-
c*d^2*e*f-a*b^2*c^2+a*c^2*e^2+a*c^2*f^2-b*d^2*f^2+c*d^2*f^2-a^2*b*c*d+
a^2*c*d*e+a^2*c*e*f-b^2*d*e*f+c^2*d*e*f+a^2*b*d^2-a^2*c*e^2-a^2*c*f^2+
a^2*d*e^2+a^2*e*f^2+b^2*d*f^2-b^2*e*f^2-c^2*d*f^2+c^2*e*f^2+a^2*b^2*c-
a^2*b^2*d-a^2*d^2*e-a^2*e^2*f+b^2*e^2*f-c^2*e^2*f;end,

 function(arg)return Sum(r,a->(arg*a)^6);end,
 function(arg)return Sum(r,a->(arg*a)^8);end,

 function(a,b,c,d,e,f)return
-a*b*c*d^6-a*c*d*e^6-a*c*e*f^6+b*d*e*f^6-c*d*e*f^6+3*a*b*c^2*d^5+
3*a*c*d^2*e^5+3*a*c*e^2*f^5-3*b*d*e^2*f^5+3*c*d*e^2*f^5-5*a*b*c^3*d^4-
5*a*c*d^3*e^4-5*a*c*e^3*f^4+5*b*d*e^3*f^4-5*c*d*e^3*f^4+5*a*b*c^4*d^3+
5*a*c*d^4*e^3+5*a*c*e^4*f^3-5*b*d*e^4*f^3+5*c*d*e^4*f^3-3*a*b*c^5*d^2-
3*a*c*d^5*e^2-3*a*c*e^5*f^2+3*b*d*e^5*f^2-3*c*d*e^5*f^2+a*b*c^6*d+a*c*d^6*e+
a*c*e^6*f-b*d*e^6*f+c*d*e^6*f+3*a*b^2*c*d^5-3*a*c^2*d*e^5-3*a*c^2*e*f^5+
3*b*d^2*e*f^5-3*c*d^2*e*f^5+(-15/2)*a*b^2*c^2*d^4+(15/2)*a*c^2*d^2*e^4+
(15/2)*a*c^2*e^2*f^4+(-15/2)*b*d^2*e^2*f^4+(15/2)*c*d^2*e^2*f^4+
10*a*b^2*c^3*d^3-10*a*c^2*d^3*e^3-10*a*c^2*e^3*f^3+10*b*d^2*e^3*f^3-
10*c*d^2*e^3*f^3+(-15/2)*a*b^2*c^4*d^2+(15/2)*a*c^2*d^4*e^2+
(15/2)*a*c^2*e^4*f^2+(-15/2)*b*d^2*e^4*f^2+(15/2)*c*d^2*e^4*f^2+3*a*b^2*c^5*d-
3*a*c^2*d^5*e-3*a*c^2*e^5*f+3*b*d^2*e^5*f-3*c*d^2*e^5*f-a*b^2*c^6+a*c^2*e^6+
a*c^2*f^6-b*d^2*f^6+c*d^2*f^6-5*a*b^3*c*d^4-5*a*c^3*d*e^4-5*a*c^3*e*f^4+
5*b*d^3*e*f^4-5*c*d^3*e*f^4+10*a*b^3*c^2*d^3+10*a*c^3*d^2*e^3+
10*a*c^3*e^2*f^3-10*b*d^3*e^2*f^3+10*c*d^3*e^2*f^3-10*a*b^3*c^3*d^2-
10*a*c^3*d^3*e^2-10*a*c^3*e^3*f^2+10*b*d^3*e^3*f^2-10*c*d^3*e^3*f^2+
5*a*b^3*c^4*d+5*a*c^3*d^4*e+5*a*c^3*e^4*f-5*b*d^3*e^4*f+5*c*d^3*e^4*f+
5*a*b^4*c*d^3-5*a*c^4*d*e^3-5*a*c^4*e*f^3+5*b*d^4*e*f^3-5*c*d^4*e*f^3+(-
15/2)*a*b^4*c^2*d^2+(15/2)*a*c^4*d^2*e^2+(15/2)*a*c^4*e^2*f^2+(-
15/2)*b*d^4*e^2*f^2+(15/2)*c*d^4*e^2*f^2+5*a*b^4*c^3*d-5*a*c^4*d^3*e-
5*a*c^4*e^3*f+5*b*d^4*e^3*f-5*c*d^4*e^3*f+(-5/2)*a*b^4*c^4+(5/2)*a*c^4*e^4+
(5/2)*a*c^4*f^4+(-5/2)*b*d^4*f^4+(5/2)*c*d^4*f^4-3*a*b^5*c*d^2-3*a*c^5*d*e^2-
3*a*c^5*e*f^2+3*b*d^5*e*f^2-3*c*d^5*e*f^2+3*a*b^5*c^2*d+3*a*c^5*d^2*e+
3*a*c^5*e^2*f-3*b*d^5*e^2*f+3*c*d^5*e^2*f+a*b^6*c*d-a*c^6*d*e-a*c^6*e*f+
b*d^6*e*f-c*d^6*e*f-a*b^6*c^2+a*c^6*e^2+a*c^6*f^2-b*d^6*f^2+c*d^6*f^2-
3*a^2*b*c*d^5+3*a^2*c*d*e^5+3*a^2*c*e*f^5-3*b^2*d*e*f^5+3*c^2*d*e*f^5+
(15/2)*a^2*b*c^2*d^4+(-15/2)*a^2*c*d^2*e^4+(-15/2)*a^2*c*e^2*f^4+
(15/2)*b^2*d*e^2*f^4+(-15/2)*c^2*d*e^2*f^4-10*a^2*b*c^3*d^3+10*a^2*c*d^3*e^3+
10*a^2*c*e^3*f^3-10*b^2*d*e^3*f^3+10*c^2*d*e^3*f^3+(15/2)*a^2*b*c^4*d^2+(-
15/2)*a^2*c*d^4*e^2+(-15/2)*a^2*c*e^4*f^2+(15/2)*b^2*d*e^4*f^2+(-
15/2)*c^2*d*e^4*f^2-3*a^2*b*c^5*d+3*a^2*c*d^5*e+3*a^2*c*e^5*f-3*b^2*d*e^5*f+
3*c^2*d*e^5*f+a^2*b*d^6-a^2*c*e^6-a^2*c*f^6+a^2*d*e^6+a^2*e*f^6+b^2*d*f^6-
b^2*e*f^6-c^2*d*f^6+c^2*e*f^6+(15/2)*a^2*b^2*c*d^4+(15/2)*a^2*c^2*d*e^4+
(15/2)*a^2*c^2*e*f^4+(-15/2)*b^2*d^2*e*f^4+(15/2)*c^2*d^2*e*f^4-
15*a^2*b^2*c^2*d^3-15*a^2*c^2*d^2*e^3-15*a^2*c^2*e^2*f^3+15*b^2*d^2*e^2*f^3-
15*c^2*d^2*e^2*f^3+15*a^2*b^2*c^3*d^2+15*a^2*c^2*d^3*e^2+15*a^2*c^2*e^3*f^2-
15*b^2*d^2*e^3*f^2+15*c^2*d^2*e^3*f^2+(-15/2)*a^2*b^2*c^4*d+(-
15/2)*a^2*c^2*d^4*e+(-15/2)*a^2*c^2*e^4*f+(15/2)*b^2*d^2*e^4*f+(-
15/2)*c^2*d^2*e^4*f+3*a^2*b^2*c^5-3*a^2*b^2*d^5-3*a^2*d^2*e^5-3*a^2*e^2*f^5+
3*b^2*e^2*f^5-3*c^2*e^2*f^5-10*a^2*b^3*c*d^3+10*a^2*c^3*d*e^3+
10*a^2*c^3*e*f^3-10*b^2*d^3*e*f^3+10*c^2*d^3*e*f^3+15*a^2*b^3*c^2*d^2-
15*a^2*c^3*d^2*e^2-15*a^2*c^3*e^2*f^2+15*b^2*d^3*e^2*f^2-15*c^2*d^3*e^2*f^2-
10*a^2*b^3*c^3*d+10*a^2*c^3*d^3*e+10*a^2*c^3*e^3*f-10*b^2*d^3*e^3*f+
10*c^2*d^3*e^3*f+5*a^2*b^3*d^4-5*a^2*c^3*e^4-5*a^2*c^3*f^4+5*a^2*d^3*e^4+
5*a^2*e^3*f^4+5*b^2*d^3*f^4-5*b^2*e^3*f^4-5*c^2*d^3*f^4+5*c^2*e^3*f^4+
(15/2)*a^2*b^4*c*d^2+(15/2)*a^2*c^4*d*e^2+(15/2)*a^2*c^4*e*f^2+(-
15/2)*b^2*d^4*e*f^2+(15/2)*c^2*d^4*e*f^2+(-15/2)*a^2*b^4*c^2*d+(-
15/2)*a^2*c^4*d^2*e+(-15/2)*a^2*c^4*e^2*f+(15/2)*b^2*d^4*e^2*f+(-
15/2)*c^2*d^4*e^2*f+5*a^2*b^4*c^3-5*a^2*b^4*d^3-5*a^2*d^4*e^3-5*a^2*e^4*f^3+
5*b^2*e^4*f^3-5*c^2*e^4*f^3-3*a^2*b^5*c*d+3*a^2*c^5*d*e+3*a^2*c^5*e*f-
3*b^2*d^5*e*f+3*c^2*d^5*e*f+3*a^2*b^5*d^2-3*a^2*c^5*e^2-3*a^2*c^5*f^2+
3*a^2*d^5*e^2+3*a^2*e^5*f^2+3*b^2*d^5*f^2-3*b^2*e^5*f^2-3*c^2*d^5*f^2+
3*c^2*e^5*f^2+a^2*b^6*c-a^2*b^6*d-a^2*d^6*e-a^2*e^6*f+b^2*e^6*f-c^2*e^6*f-
5*a^3*b*c*d^4-5*a^3*c*d*e^4-5*a^3*c*e*f^4+5*b^3*d*e*f^4-5*c^3*d*e*f^4+
10*a^3*b*c^2*d^3+10*a^3*c*d^2*e^3+10*a^3*c*e^2*f^3-10*b^3*d*e^2*f^3+
10*c^3*d*e^2*f^3-10*a^3*b*c^3*d^2-10*a^3*c*d^3*e^2-10*a^3*c*e^3*f^2+
10*b^3*d*e^3*f^2-10*c^3*d*e^3*f^2+5*a^3*b*c^4*d+5*a^3*c*d^4*e+5*a^3*c*e^4*f-
5*b^3*d*e^4*f+5*c^3*d*e^4*f+10*a^3*b^2*c*d^3-10*a^3*c^2*d*e^3-
10*a^3*c^2*e*f^3+10*b^3*d^2*e*f^3-10*c^3*d^2*e*f^3-15*a^3*b^2*c^2*d^2+
15*a^3*c^2*d^2*e^2+15*a^3*c^2*e^2*f^2-15*b^3*d^2*e^2*f^2+15*c^3*d^2*e^2*f^2+
10*a^3*b^2*c^3*d-10*a^3*c^2*d^3*e-10*a^3*c^2*e^3*f+10*b^3*d^2*e^3*f-
10*c^3*d^2*e^3*f-5*a^3*b^2*c^4+5*a^3*c^2*e^4+5*a^3*c^2*f^4-5*b^3*d^2*f^4+
5*c^3*d^2*f^4-10*a^3*b^3*c*d^2-10*a^3*c^3*d*e^2-10*a^3*c^3*e*f^2+
10*b^3*d^3*e*f^2-10*c^3*d^3*e*f^2+10*a^3*b^3*c^2*d+10*a^3*c^3*d^2*e+
10*a^3*c^3*e^2*f-10*b^3*d^3*e^2*f+10*c^3*d^3*e^2*f+5*a^3*b^4*c*d-
5*a^3*c^4*d*e-5*a^3*c^4*e*f+5*b^3*d^4*e*f-5*c^3*d^4*e*f-5*a^3*b^4*c^2+
5*a^3*c^4*e^2+5*a^3*c^4*f^2-5*b^3*d^4*f^2+5*c^3*d^4*f^2-5*a^4*b*c*d^3+
5*a^4*c*d*e^3+5*a^4*c*e*f^3-5*b^4*d*e*f^3+5*c^4*d*e*f^3+(15/2)*a^4*b*c^2*d^2+
(-15/2)*a^4*c*d^2*e^2+(-15/2)*a^4*c*e^2*f^2+(15/2)*b^4*d*e^2*f^2+(-
15/2)*c^4*d*e^2*f^2-5*a^4*b*c^3*d+5*a^4*c*d^3*e+5*a^4*c*e^3*f-5*b^4*d*e^3*f+
5*c^4*d*e^3*f+(5/2)*a^4*b*d^4+(-5/2)*a^4*c*e^4+(-5/2)*a^4*c*f^4+
(5/2)*a^4*d*e^4+(5/2)*a^4*e*f^4+(5/2)*b^4*d*f^4+(-5/2)*b^4*e*f^4+(-
5/2)*c^4*d*f^4+(5/2)*c^4*e*f^4+(15/2)*a^4*b^2*c*d^2+(15/2)*a^4*c^2*d*e^2+
(15/2)*a^4*c^2*e*f^2+(-15/2)*b^4*d^2*e*f^2+(15/2)*c^4*d^2*e*f^2+(-
15/2)*a^4*b^2*c^2*d+(-15/2)*a^4*c^2*d^2*e+(-15/2)*a^4*c^2*e^2*f+
(15/2)*b^4*d^2*e^2*f+(-15/2)*c^4*d^2*e^2*f+5*a^4*b^2*c^3-5*a^4*b^2*d^3-
5*a^4*d^2*e^3-5*a^4*e^2*f^3+5*b^4*e^2*f^3-5*c^4*e^2*f^3-5*a^4*b^3*c*d+
5*a^4*c^3*d*e+5*a^4*c^3*e*f-5*b^4*d^3*e*f+5*c^4*d^3*e*f+5*a^4*b^3*d^2-
5*a^4*c^3*e^2-5*a^4*c^3*f^2+5*a^4*d^3*e^2+5*a^4*e^3*f^2+5*b^4*d^3*f^2-
5*b^4*e^3*f^2-5*c^4*d^3*f^2+5*c^4*e^3*f^2+(5/2)*a^4*b^4*c+(-5/2)*a^4*b^4*d+(-
5/2)*a^4*d^4*e+(-5/2)*a^4*e^4*f+(5/2)*b^4*e^4*f+(-5/2)*c^4*e^4*f-
3*a^5*b*c*d^2-3*a^5*c*d*e^2-3*a^5*c*e*f^2+3*b^5*d*e*f^2-3*c^5*d*e*f^2+
3*a^5*b*c^2*d+3*a^5*c*d^2*e+3*a^5*c*e^2*f-3*b^5*d*e^2*f+3*c^5*d*e^2*f+
3*a^5*b^2*c*d-3*a^5*c^2*d*e-3*a^5*c^2*e*f+3*b^5*d^2*e*f-3*c^5*d^2*e*f-
3*a^5*b^2*c^2+3*a^5*c^2*e^2+3*a^5*c^2*f^2-3*b^5*d^2*f^2+3*c^5*d^2*f^2-
a^6*b*c*d+a^6*c*d*e+a^6*c*e*f-b^6*d*e*f+c^6*d*e*f+a^6*b*d^2-a^6*c*e^2-
a^6*c*f^2+a^6*d*e^2+a^6*e*f^2+b^6*d*f^2-b^6*e*f^2-c^6*d*f^2+c^6*e*f^2+
a^6*b^2*c-a^6*b^2*d-a^6*d^2*e-a^6*e^2*f+b^6*e^2*f-c^6*e^2*f;end,

 function(arg)return Sum(r,a->(arg*a)^12);end];
end);

CHEVIE.AddData("UnipotentClasses","E6",function(p)local uc,Z,c;
  if p=0 then p:=1;fi;
  Z:=n->ComplexReflectionGroup(n,1,1);
  uc:=rec(
# Partial ordering on unipotent classes --- courtesy of Hyohe Miyachi
orderPicture:=Concatenation(
"	E_6\n",
"	 |\n",
"      E_6(a_1)\n",
"	 |\n",
"	D_5\n",
"	 |\n",
"     E_6(a_3)\n",
"     /   |\n",
"  A_5    |\n",
"   |   D_5(a_1)\n",
"   |   /      \\\n",
"A_4+A_1        \\\n",
"   |           D_4\n",
"  A_4         /\n",
"     \\       /\n",
"      D_4(a_1)\n",
"	 |\n",
"      A_3+A_1\n",
"     /       \\\n",
"  A_3     2A_2+A_1\n",
"   |     /    |\n",
"  A_2+2A_1   2A_2\n",
"     \\       /\n",
"      A_2+A_1\n",
"	 |\n",
"	A_2\n",
"	 |\n",
"       3A_1\n",
"	 |\n",
"       2A_1\n",
"	 |\n",
"	A_1\n",
"	 |\n",
"	 1\n"),
classes:=[
rec(name:="E_6",succ:=[],dynkin:=[2,2,2,2,2,2],Au:=Z(3*Gcd(p,2)),
    balacarter:=[1..6]),
rec(name:="E_6(a_1)",succ:=["E6"],dynkin:=[2,2,2,0,2,2],Au:=Z(Gcd(3,p^2-1)),
    balacarter:=[1,2,3,-4,5,6]),
rec(name:="D_5",succ:=["E6(a1)"],dynkin:=[2,2,0,2,0,2],Au:=Z(Gcd(2,p)),
    balacarter:=[1..5],red:=Torus(1)),
rec(name:="E_6(a_3)",mizuno:="A_5{+}A_1",succ:=["D5"],dynkin:=[2,0,0,2,0,2],
    Au:=Z(Gcd(3,p^2-1)*2),balacarter:=[1,-2,-3,4,-5,6]),
rec(name:="A_5",succ:=["E6(a3)"],dynkin:=[2,1,1,0,1,2],Au:=Z(Gcd(3,p^2-1)),
    balacarter:=[1,3,4,5,6],red:=Z(2)),
rec(name:="D_5(a_1)",succ:=["E6(a3)"],dynkin:=[1,2,1,0,1,1],
    balacarter:=[1,2,3,-4,5],red:=Torus(1)),
rec(name:="A_4{+}A_1",succ:=["A5","D5(a1)"],dynkin:=[1,1,1,0,1,1],
    balacarter:=[1,2,3,4,6],red:=Torus(1)),
rec(name:="D_4",succ:=["D5(a1)"],dynkin:=[0,2,0,2,0,0],Au:=Z(Gcd(p,2)),
    balacarter:=[2,3,4,5],red:=CoxeterGroup("A",2)),
rec(name:="A_4",succ:=["A4+A1"],dynkin:=[2,2,0,0,0,2],
    balacarter:=[1,2,3,4],red:=Z(2)*Torus(1)),
rec(name:="D_4(a_1)",succ:=["D4","A4"],dynkin:=[0,0,0,2,0,0],
    Au:=CoxeterGroup("A",2),balacarter:=[2,3,-4,5],red:=Torus(2),
    AuAction:=ExtendedReflectionGroup(Torus(2),CoxeterGroup("A",2).matgens)),
rec(name:="A_3{+}A_1",succ:=["D4(a1)"],dynkin:=[0,1,1,0,1,0],
    balacarter:=[1,2,4,5],red:=Z(2)*Torus(1)),
rec(name:="A_3",succ:=["A3+A1"],dynkin:=[1,2,0,0,0,1],
    balacarter:=[1,3,4],red:=CoxeterGroup("B",2)*Torus(1)),
rec(name:="2A_2{+}A_1",succ:=["A3+A1"],dynkin:=[1,0,0,1,0,1],
    Au:=Z(Gcd(3,p^2-1)),balacarter:=[1,2,3,5,6],red:=Z(2)),
rec(name:="2A_2",succ:=["2A2+A1"],dynkin:=[2,0,0,0,0,2],Au:=Z(Gcd(3,p^2-1)),
    balacarter:=[1,3,5,6],red:=CoxeterGroup("G",2)),
rec(name:="A_2{+}2A_1",succ:=["A3","2A2+A1"],dynkin:=[0,0,1,0,1,0],
    balacarter:=[1,2,3,5],red:=Z(2)*Torus(1)),
rec(name:="A_2{+}A_1",succ:=["2A2","A2+2A1"],dynkin:=[1,1,0,0,0,1],
    balacarter:=[1,2,3],red:=CoxeterGroup("A",2)*Torus(1)),
rec(name:="A_2",succ:=["A2+A1"],dynkin:=[0,2,0,0,0,0],Au:=Z(2),
    balacarter:=[1,3],red:=CoxeterGroup("A",2,"A",2),
    AuAction:=ExtendedReflectionGroup(CoxeterGroup("A",2,"A",2),(1,3)(2,4))),
rec(name:="3A_1",succ:=["A2"],dynkin:=[0,0,0,1,0,0],
    balacarter:=[1,2,5],red:=CoxeterGroup("A",2,"A",1)),
rec(name:="2A_1",succ:=["3A1"],dynkin:=[1,0,0,0,0,1],
    balacarter:=[1,2],red:=CoxeterGroup("B",3)*Torus(1)),
rec(name:="A_1",succ:=["2A1"],dynkin:=[0,1,0,0,0,0],
    balacarter:=[1],red:=CoxeterGroup("A",5)),
rec(name:="1",succ:=["A1"],dynkin:=[0,0,0,0,0,0],balacarter:=[],
    red:=CoxeterGroup("E",6))],
  springerSeries:=[rec(levi:=[],relgroup:=CoxeterGroup("E",6),Z:=[1],
   locsys:=[[1,1],[21,1],[13,1],[2,1],[20,1],[10,1],[4,4],[17,1],[5,1],[18,1],
   [3,1],[19,1],[8,1],[14,1],[4,1],[17,2],[11,1],[10,3],[10,2],[7,1],[15,1],
   [6,1],[16,1],[9,1],[12,1]]),
# See Lusztig arxiv:1608.02223 for next case
  rec(levi:=[1,3,5,6],relgroup:=CoxeterGroup("G",2),Z:=[E(3)],
    locsys:=[[1,2],[14,2],[13,2],[2,2],[4,3],[5,2]]),
  rec(levi:=[1,3,5,6],relgroup:=CoxeterGroup("G",2),Z:=[E(3)^2],
    locsys:=[[1,3],[14,3],[13,3],[2,3],[4,5],[5,3]]),
  rec(relgroup:=CoxeterGroup(),levi:=[1..6],Z:=[E(3)],locsys:=[[4,2]]),
  rec(relgroup:=CoxeterGroup(),levi:=[1..6],Z:=[E(3)^2],locsys:=[[4,6]])]);
  if p=2 then Add(uc.springerSeries,
    rec(levi:=[2,3,4,5],relgroup:=CoxeterGroup("A",2),Z:=[1],
    locsys:=[[8,1],[3,1],[1,4]]));
    uc.springerSeries[1].locsys{[11,13]}:=[[3,2],[8,2]];
    uc.springerSeries[2].locsys[1]:=[1,3];
    uc.springerSeries[3].locsys[1]:=[1,5];
    for c in [2,6] do Add(uc.springerSeries,
      rec(relgroup:=CoxeterGroup(),levi:=[1..6],Z:=[E(3)^(1-c)],
        locsys:=[[1,c]]));od;
  elif p=3 then uc.springerSeries:=uc.springerSeries{[1]};
    uc.springerSeries[1].locsys{[7,15]}[2]:=[1,2];
    for c in [2,3] do Add(uc.springerSeries,
      rec(relgroup:=CoxeterGroup(),levi:=[1..6],Z:=[1],locsys:=[[1,c]]));od;
  fi;
  uc.orderClasses:=List(uc.classes,c->List(c.succ,
    n->PositionProperty(uc.classes,c->UnipotentClassOps.Name(c)=n)));
  for c in uc.classes do Unbind(c.succ);
    if not IsBound(c.red) then c.red:=Z(1);fi;
    if not IsBound(c.Au) then c.Au:=Z(1);fi;
    if not IsBound(c.AuAction) then
      c.AuAction:=ExtendedReflectionGroup(c.red,List(c.Au.generators,
        x->IdentityMat(c.red.rank)));
    fi;
  od;
return uc;end);

CHEVIE.AddData("KLeftCellRepresentatives","E6",
[rec(character:=[1], reps:=[], duflo:=[1,2,3,4,5,6]),
rec(character:=[2], reps:=[], duflo:=[42,38,41,40,39,37]),
rec(character:=[4], reps:=[], duflo:=[1,2,3,4,11,42]),
rec(character:=[5], reps:=[], duflo:=[23,53,42,41,40,39]),
rec(character:=[11], reps:=[], duflo:=[23,3,2,4,5,67]),
rec(character:=[12], reps:=[], duflo:=[36,39,38,40,41,42]),
rec(character:=[13], reps:=[], duflo:=[5,2,32,63,1,62]),
rec(character:=[14], reps:=[], duflo:=[34,38,39,13,60,42]),
rec(character:=[15,7], reps:=[[23,56,57,25,10,41]], duflo:=[1,2,3,16,42,41]),
rec(character:=[16,8], reps:=[[38,34,45,41,42,62]], duflo:=[1,65,21,42,41,40]),
rec(character:=[15,9], reps:=[[18,3,2,16,47,60],[33,2,3,4,64,6]],
duflo:=[18,3,2,16,67,24]),
rec(character:=[16,10], reps:=[[53,54,32,42,55,40],[32,54,57,38,40,24]],
duflo:=[41,38,34,57,37,60]),
rec(character:=[20], reps:=[], duflo:=[3,6,1,24,72,2]),
rec(character:=[21], reps:=[], duflo:=[37,42,33,41,40,38]),
rec(character:=[22], reps:=[], duflo:=[1,11,28,56,14,46]),
rec(character:=[23], reps:=[], duflo:=[1,42,43,32,71,38]),
rec(character:=[24], reps:=[], duflo:=[1,41,24,40,38,20]),
rec(character:=[25], reps:=[], duflo:=[50,25,22,4,66,51]),
rec(character:=[18,17,3], reps:=[[50,30,31,52,49,54],[17,23,5,70,3,20],
[32,55,53,52,20,18],[32,55,53,52,33,54],[5,2,6,63,1,3]],
duflo:=[21,19,17,72,20,18]),
rec(character:=[19,18,17], reps:=[[56,57,54,35,40,55],[28,62,45,47,23,19],
[9,25,22,55,66,8],[1,32,19,65,56,8],[45,62,56,36,55,59]],
duflo:=[20,26,9,40,70,23]),
rec(character:=[19,19,18,6],reps:=[[33,51,50,42,28,40],[59,15,33,41,40,61],
[69,44,35,51,42,25],[50,51,59,35,40,61]], duflo:=[33,8,9,40,55,42])]);
