#############################################################################
##
#A  tbl/cmplxg33.g                 CHEVIE library                Jean Michel
##
#Y  Copyright (C) 1998 - 2002  The CHEVIE Team
##
##  This file  contains data about  the complex reflection group  G33 in
##  the Shephard-Todd classification.
##
CHEVIE.Revision("tbl/cmplxg33.g",
   "$Id: cmplxg33.g,v 1.3 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("PrintDiagram","G33",function(indices,title)local s;
  Print(title," ");s:=String("",Length(title)-5);
  Print("    ",indices[3],"\n       /^\\\n",
	s,indices[1],"---",indices[2],"---",indices[4],"---",indices[5]," ",
	IntListToString(indices{[4,2,3,4,2,3]}),"=",
	IntListToString(indices{[3,4,2,3,4,2]}),"\n");
end);

CHEVIE.AddData("BraidRelations","G33",
  [[[1,2,1],[2,1,2]],[[3,2,3],[2,3,2]],[[4,2,4],[2,4,2]],[[4,3,4],[3,4,3]],
   [[4,5,4],[5,4,5]],[[1,3],[3,1]],[[1,4],[4,1]],[[1,5],[5,1]],[[2,5],[5,2]],
   [[3,5],[5,3]],[[4,2,3,4,2,3],[3,4,2,3,4,2]]]);

## of interest are the alternate presentations of the braid group:
CHEVIE.AddData("AltPres","G33",[rec(gens:=[[1],[2],[-4,3,4],[5,4,-5],[5]],
  rels:=[[[1,2,1],[2,1,2]],[[3,2,3],[2,3,2]],[[4,2,4],[2,4,2]],
   [[4,5,4],[5,4,5]],[[3,5,3],[5,3,5]],[[1,3],[3,1]],[[1,4],[4,1]],
   [[1,5],[5,1]],[[2,5],[5,2]],[[3,4],[4,3]],
   [[4,5,3,2,4,5,3,2,4],[2,4,5,3,2,4,5,3,2]]]),
   rec(gens:=[[1],[2],[3],[-3,-2,4,2,3],[5]],
  rels:=[[[4,2,4],[2,4,2]],[[4,5,4],[5,4,5]],[[4,3,4],[3,4,3]],
   [[4,1,4],[1,4,1]],[[3,2,3],[2,3,2]],[[1,2,1],[2,1,2]],[[1,3],[3,1]],
   [[3,5],[5,3]],[[1,5],[5,1]],[[2,5],[5,2]],[[1,2,3,4,1,2],[2,3,4,1,2,3]]])]);

# G33 is derived by  a non-orthogonal projection on coordinates 3
# and 4  from ReflectionSubGroup(G34,[1..5]). If  one replaces the  2 in
# the  5th  root  by  ER(2),  one  obtains  orthogonal  roots  (but  the
# definition field and invariants become worse).
# The  group thus  defined agrees  with Burkhardt,  Math. Annalen  38 pp
# 208--209 up to an interchange of x and z.

CHEVIE.AddData("GeneratingRoots","G33",
  [[ER(-3),-ER(-3),0,0,0],[0,ER(-3),0,0,-ER(-3)],[0,0,0,-ER(-3),ER(-3)],
   [0,0,0,(3+ER(-3))/2,(3-ER(-3))/2],[-1,-1,2,-1,-1]]);

CHEVIE.AddData("GeneratingCoRoots","G33",
  [[-ER(-3),ER(-3),0,0,0],[0,-ER(-3),0,0,ER(-3)],[0,0,0,ER(-3),-ER(-3)],
   [0,0,0,(3-ER(-3))/2,(3+ER(-3))/2],[-1,-1,1,-1,-1]]/3);

CHEVIE.AddData("CartanMat","G33",function()
  return CHEVIE.RawData("GeneratingCoRoots","G33")*
  TransposedMat(CHEVIE.RawData("GeneratingRoots","G33"));
 end);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G33",[1/2,1/2,1/2,1/2,1/2]);

CHEVIE.AddData("Size","G33", 51840);

CHEVIE.AddData("ReflectionDegrees","G33",[4,6,10,12,18]);

CHEVIE.AddData("NrConjugacyClasses","G33", 40);

CHEVIE.AddData("ParabolicRepresentatives","G33",# repr. of conj. classes
  function(s)local t;
    t:=[[[]],[[1]],[[1,2],[1,3]],[[1..3],[1,3,5],[1,3,4],[2..4]],
      [[1,2,3,5],[1,3,5,10],[1..4],[1,2,4,5]],[[1..5]]];
    return t[s+1];end);

CHEVIE.AddData("ClassNames","G33",
 [".","1","31","12","123","234","243","341","531","1245",
 "1234","1243","5123","ccccc","c","125z","342312","342342","432432",
 "c4213","5432412","3452412","3423412","2431243","34523412","52431243",
 "453423121","3124512342","5342312432","5423124321","423124123121",
 "3245124324524","32451243245124","23452412345241","z342342",
 "345243124532412","ccc","12z","1z","z"]);

CHEVIE.AddData("WordsClassRepresentatives","G33",
 List(CHEVIE.RawData("ClassNames","G33"),x->Replace(x,".",[],"1",[1],
   "2",[2],"3",[3],"4",[4],"5",[5],"z","ccccccccc","c",[5,4,2,1,3])));

CHEVIE.AddData("PowerMaps","G33",
 [ , [ 1, 1, 1, 4, 3, 18, 19, 4, 1, 10, 12, 11, 3, 12, 11, 4, 31, 19, 18, 10,
      33,34,31,31,34, 33, 31, 31, 39, 31, 31, 31, 19, 18, 19, 39, 18, 4,1,1],
  [ 1, 2, 3, 1, 5, 2, 2, 2, 9, 10, 18, 19, 13, 35, 37, 39, 3, 1, 1, 20, 36,
      36, 2, 2, 29, 29, 40, 39, 29, 39, 1, 9, 39, 39, 40, 36, 40, 40, 39, 40 ]
   ,, [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 1, 12, 11, 13, 15, 14, 16, 17, 19, 18, 40,
      22, 21,24,23,26,25,27,30,29,28,31,32, 34, 33, 37, 36, 35, 38, 39, 40 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21,22,23,24,25,26,27,28,29,30,31,32, 33, 34, 35, 36, 37, 38, 39, 40 ],,,,
  [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 10, 12, 11, 13, 15, 14, 16, 17, 19, 18, 20,
      22,21,24,23,26,25,27,30,29,28,31, 32, 34, 33, 37, 36, 35, 38, 39, 40 ],,
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21,22,23,24,25,26,27,28,29,30,31,32, 33, 34, 35, 36, 37, 38, 39, 40 ],,,,
  [ 1, 2, 3, 4, 5, 7, 6, 8, 9, 10, 12, 11, 13, 15, 14, 16, 17, 19, 18, 20,
      22,21,24,23,26,25,27,30,29,28,31,32,34, 33, 37, 36, 35, 38, 39, 40 ] ]);

CHEVIE.AddData("ClassInfo","G33",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G33"),
    classnames:=CHEVIE.RawData("ClassNames","G33"),
    classparams:=CHEVIE.RawData("ClassNames","G33"),
    orders:=[1,2,2,3,4,6,6,6,2,5,9,9,4,18,18,6,6,3,3,
             10,12,12,6,6,12,12,6,6,4,6,3,6,6,6,6,4,6,6,2,2],
    classes:=[1,45,270,480,3240,360,360,1440,270,5184,2880,2880,3240,2880,
  2880, 1440, 2160, 40, 40, 5184, 2160, 2160, 720, 720, 2160, 2160, 240, 720,
  540, 720, 240, 2160, 360, 360, 40, 540, 40, 480, 45, 1 ]));

CHEVIE.AddData("CharInfo","G33",function()local res;
  res:=rec(charparams:=[[1,0],[1,45],[5,28],[5,1],[5,30],[5,3],[6,20],
    [6,5],[10,8,2],[10,17,2],[10,8,1],[10,17,1],[15,12],[15,9],
    [15,2],[15,23],[20,6],[20,15],[24,4],[24,19],[30,18],[30,3],[30,6],[30,15],
    [30,4],[30,13],[40,14,1],[40,5,1],[40,14,2],[40,5,2],[45,12],
    [45,9],[45,10],[45,7],[60,10],[60,7],[64,8],[64,9],[81,6],[81,11]],
# here the labelling is as follows: phi_10,8' has fake degree q^28+q^26+...,
# phi_40,5' has fake degree q^31+q^29+2q^27+...
# phi_10,8' tensored by sign is phi_10,17' and
# phi_40,5' tensored by sign is phi_40,14'
  extRefl:=[1,4,9,12,5,2]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,2,2,1,1];
  return res;
end);

CHEVIE.AddData("CycPolSchurElements","G33",
[ [1,0,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [1,-45,2,2,2,2,2,3,3,3,4,4,5,6,6,6,9,10,12,18],
  [(3+ER(-3))/2,-28,2,2,2,2,2,3,3,3,4,4,6,6,6,1/9,4/9,7/9,1/12,7/12,5/18,11/18,
    17/18],
  [(3-ER(-3))/2,-1,2,2,2,2,2,3,3,3,4,4,6,6,6,2/9,5/9,8/9,5/12,11/12,1/18,7/18,
   13/18],
  [(3-ER(-3))/2,-28,2,2,2,2,2,3,3,3,4,4,6,6,6,2/9,5/9,8/9,5/12,11/12,1/18,7/18,
  13/18],
  [(3+ER(-3))/2,-1,2,2,2,2,2,3,3,3,4,4,6,6,6,1/9,4/9,7/9,1/12,7/12,5/18,11/18,
   17/18], [2,-18,2,2,2,2,2,3,3,3,5,6,6,6], [2,-3,2,2,2,2,2,3,3,3,5,6,6,6],
  [6*E(3)^2,-4,2,2,2,2,2,3,3,3,5/6,5/6,5/6,1/18,7/18,13/18],
  [6*E(3),-13,2,2,2,2,2,3,3,3,1/6,1/6,1/6,5/18,11/18,17/18],
  [6*E(3),-4,2,2,2,2,2,3,3,3,1/6,1/6,1/6,5/18,11/18,17/18],
  [6*E(3)^2,-13,2,2,2,2,2,3,3,3,5/6,5/6,5/6,1/18,7/18,13/18],
  [1,-12,2,2,2,2,2,3,3,3,4,4,6,6,6], [1,-9,2,2,2,2,2,3,3,3,4,4,6,6,6],
  [1,-2,2,2,2,2,2,3,3,3,4,4,6,6,6,12],
  [1,-23,2,2,2,2,2,3,3,3,4,4,6,6,6,12], [3,-4,2,2,2,2,2,3,3,3,6,6,6],
  [3,-13,2,2,2,2,2,3,3,3,6,6,6], [2,-3,2,3,3,3,4,4,5,6,12],
  [2,-18,2,3,3,3,4,4,5,6,12], [2,-18,2,2,2,2,2,3,3,3,6,6,6,10],
  [2,-3,2,2,2,2,2,3,3,3,6,6,6,10],
  [-6*E(3)^2,-4,2,2,2,2,2,1/3,1/3,1/3,6,6,6,2/9,5/9,8/9],
  [-6*E(3),-13,2,2,2,2,2,2/3,2/3,2/3,6,6,6,1/9,4/9,7/9],
  [-6*E(3),-4,2,2,2,2,2,2/3,2/3,2/3,6,6,6,1/9,4/9,7/9],
  [-6*E(3)^2,-13,2,2,2,2,2,1/3,1/3,1/3,6,6,6,2/9,5/9,8/9],
  [3-ER(-3),-13,2,3,3,3,4,4,5/6,2/9,5/9,8/9,1/12,7/12],
  [3+ER(-3),-4,2,3,3,3,4,4,1/6,1/9,4/9,7/9,5/12,11/12],
  [3+ER(-3),-13,2,3,3,3,4,4,1/6,1/9,4/9,7/9,5/12,11/12],
  [3-ER(-3),-4,2,3,3,3,4,4,5/6,2/9,5/9,8/9,1/12,7/12],
  [(3-ER(-3))/2,-10,2,2,2,2,2,1/3,1/3,1/3,4,4,5/6,5/6,5/6,1/12,7/12],
  [(3+ER(-3))/2,-7,2,2,2,2,2,2/3,2/3,2/3,4,4,1/6,1/6,1/6,5/12,11/12],
  [(3+ER(-3))/2,-10,2,2,2,2,2,2/3,2/3,2/3,4,4,1/6,1/6,1/6,5/12,11/12],
  [(3-ER(-3))/2,-7,2,2,2,2,2,1/3,1/3,1/3,4,4,5/6,5/6,5/6,1/12,7/12],
  [1,-10,2,2,2,2,2,3,3,3,6,6,6], [1,-7,2,2,2,2,2,3,3,3,6,6,6],
  [2,-8,3,3,3,5,9], [2,-8,3,3,3,5,9], [1,-6,2,2,2,2,2,4,4,5,10],
  [1,-11,2,2,2,2,2,4,4,5,10] ]
);

CHEVIE.AddData("sparseFakeDegrees","G33",
[[1,0],[1,45],[1,28,1,34,1,36,1,40,1,42],[1,1,1,7,1,9,1,13,1,15],[1,30,1,32,1,
36,1,38,1,44],[1,3,1,5,1,9,1,11,1,17],[1,20,1,26,1,28,1,32,1,34,1,40],[1,5,1,
11,1,13,1,17,1,19,1,25],[1,8,1,10,1,14,2,16,1,20,2,22,1,24,1,28],[1,17,1,19,1,
23,2,25,1,29,2,31,1,33,1,37],[1,8,1,12,2,14,1,16,2,20,1,22,1,26,1,28],[1,17,1,
21,2,23,1,25,2,29,1,31,1,35,1,37],[1,12,1,16,2,18,1,20,1,22,3,24,1,26,1,28,2,
30,1,32,1,36],[1,9,1,13,2,15,1,17,1,19,3,21,1,23,1,25,2,27,1,29,1,33],[1,2,1,
4,1,6,2,8,2,10,1,12,2,14,2,16,1,18,1,20,1,22],[1,23,1,25,1,27,2,29,2,31,1,33,
2,35,2,37,1,39,1,41,1,43],[1,6,1,8,1,10,2,12,2,14,2,16,2,18,2,20,2,22,2,24,1,
26,1,28,1,30],[1,15,1,17,1,19,2,21,2,23,2,25,2,27,2,29,2,31,2,33,1,35,1,37,1,
39],[1,4,2,6,1,8,2,10,4,12,2,14,2,16,4,18,2,20,1,22,2,24,1,26],[1,19,2,21,1,
23,2,25,4,27,2,29,2,31,4,33,2,35,1,37,2,39,1,41],[1,18,1,20,2,22,3,24,3,26,3,
28,4,30,3,32,3,34,3,36,2,38,1,40,1,42],[1,3,1,5,2,7,3,9,3,11,3,13,4,15,3,17,3,
19,3,21,2,23,1,25,1,27],[1,6,2,8,1,10,3,12,4,14,2,16,3,18,5,20,2,22,2,24,3,26,
1,28,1,32],[1,15,2,17,1,19,3,21,4,23,2,25,3,27,5,29,2,31,2,33,3,35,1,37,1,41],
[1,4,1,8,3,10,2,12,2,14,5,16,3,18,2,20,4,22,3,24,1,26,2,28,1,30],[1,13,1,17,3,
19,2,21,2,23,5,25,3,27,2,29,4,31,3,33,1,35,2,37,1,39],[1,14,2,16,1,18,3,20,5,
22,3,24,4,26,6,28,4,30,3,32,4,34,2,36,1,38,1,40],[1,5,2,7,1,9,3,11,5,13,3,15,
4,17,6,19,4,21,3,23,4,25,2,27,1,29,1,31],[1,14,1,16,2,18,4,20,3,22,4,24,6,26,
4,28,3,30,5,32,3,34,1,36,2,38,1,40],[1,5,1,7,2,9,4,11,3,13,4,15,6,17,4,19,3,
21,5,23,3,25,1,27,2,29,1,31],[2,12,2,14,2,16,5,18,5,20,3,22,6,24,6,26,3,28,4,
30,4,32,1,34,1,36,1,38],[2,9,2,11,2,13,5,15,5,17,3,19,6,21,6,23,3,25,4,27,4,
29,1,31,1,33,1,35],[1,10,1,12,1,14,4,16,4,18,3,20,6,22,6,24,3,26,5,28,5,30,2,
32,2,34,2,36],[1,7,1,9,1,11,4,13,4,15,3,17,6,19,6,21,3,23,5,25,5,27,2,29,2,31,
2,33],[1,10,2,12,2,14,4,16,6,18,5,20,6,22,8,24,6,26,5,28,6,30,4,32,2,34,2,36,
1,38],[1,7,2,9,2,11,4,13,6,15,5,17,6,19,8,21,6,23,5,25,6,27,4,29,2,31,2,33,1,
35],[1,8,1,10,2,12,5,14,5,16,5,18,8,20,8,22,5,24,7,26,7,28,3,30,3,32,3,34,1,
36],[1,9,3,11,3,13,3,15,7,17,7,19,5,21,8,23,8,25,5,27,5,29,5,31,2,33,1,35,1,
37],[1,6,2,8,4,10,5,12,7,14,8,16,9,18,9,20,9,22,8,24,7,26,5,28,4,30,2,32,1,
34],[1,11,2,13,4,15,5,17,7,19,8,21,9,23,9,25,9,27,8,29,7,31,5,33,4,35,2,37,1,
39]]);

# Computed JM may 2009
# Some columns contain only unknown entries
CHEVIE.AddData("HeckeCharTable","G33",function(para,root)
  local x,y,tbl,f1,f3,f7,f9,f13,f15,f17,f19,f21,f23,f27,f31,f35,f37,f39;
  x:=para[1][1]; y:=para[1][2];
  tbl:=rec(
  identifier:="H(G33)",
  size:=51840, order:=51840,
  powermap:=CHEVIE.RawData("PowerMaps","G33"));
  Inherit(tbl,CHEVIE.RawData("ClassInfo","G33"));
  f1:=function(x)return
  [1,x,x^2,x^2,x^3,x^3,x^3,x^3,x^3,x^4,x^4,x^4,x^4,x^25,x^5,x^48,x^6,x^6,x^6,
x^9,x^7,x^7,x^7,x^7,x^8,x^8,x^9,x^10,x^10,x^10,x^12,x^13,x^14,x^14,x^51,x^15,
x^15,x^47,x^46,x^45];end;
  f3:=function(x,y,j)return  [5,x+4*y,2*x*y+3*y^2,x*y+3*y^2,x*y^2+2*y^3,
  -j^2*x*y^2+2*y^3,j*x^2*y+2*y^3,2*x*y^2+2*y^3,3*x*y^2+2*y^3,x*y^3+y^4,
  -j^2*x*y^3+y^4,j*x^2*y^2+y^4,2*x*y^3+y^4,-j*x^5*y^20,-j^2*x*y^4,
  2*x^9*y^39+2*x^10*y^38,j*x*y^5+j*x^2*y^4+y^6,3*j*x^2*y^4+2*y^6,-2*j^2*x*y^5+
j^2*x^4*y^2+2*y^6,0,j*x*y^6-j^2*x^2*y^5-j*x^3*y^4,j*x*y^6,
2*j*x^2*y^5+y^7,-2*j^2*x*y^6+x^2*y^5-j*x^3*y^4+j^2*x^4*y^3+y^7,
j*x^2*y^6,-2*j^2*x*y^7+2*x^2*y^6-2*j*x^3*y^5+j^2*x^4*y^4,
j*x*y^8+j^2*x^3*y^6,(j^2-j)*x^3*y^7,(-j^2-2*j)*x^2*y^8+
(j^2-j)*x^3*y^7+j^2*x^4*y^6,-j^2*x*y^9-2*j*x^2*y^8+
(j^2-j)*x^3*y^7+j^2*x^4*y^6,j^2*x^2*y^10-2*j*x^3*y^9+
j^2*x^4*y^8+y^12,(j^2-j)*x^2*y^11+(j^2-j)*x^3*y^10+
j*x^4*y^9-j^2*x^5*y^8,3*j^2*x^2*y^12-2*x^3*y^11+(-2*j^2+
j)*x^4*y^10+2*x^5*y^9+j^2*x^6*y^8,j^2*x^2*y^12-2*j*x^3*y^11,
2*x^9*y^42+3*j*x^11*y^40,(3*j^2+j)*x^2*y^13+(2*j^2+j)*x^3*y^12+
(-j^2+j)*x^4*y^11-j^2*x^5*y^10,(j^2-2*j)*x^3*y^12,3*x^9*y^38+
x^10*y^37,4*x^9*y^37+x^10*y^36,5*x^9*y^36];end;
  f7:=function(x,y)return 
[6,2*x+4*y,2*x*y+x^2+3*y^2,2*x*y+2*y^2,x*y^2+y^3,x*y^2,-x^2*y,x*y^2+x^2*y+2*y^3,
3*x*y^2+x^3+2*y^3,y^4,0,-x*y^3-x^2*y^2,x*y^3+y^4,0,0,2*x^15*y^33+x^16*y^32+
x^17*y^31,-x^2*y^4,-3*x^2*y^4,2*x*y^5-x^4*y^2,x^3*y^6,x^2*y^5+x^3*y^4-x^5*y^2,
x^2*y^5,-x^2*y^5,2*x*y^6+2*x^2*y^5+x^3*y^4-x^4*y^3-x^5*y^2,x^3*y^5,2*x*y^7+
3*x^2*y^6+3*x^3*y^5-x^4*y^4-2*x^5*y^3,x*y^8+2*x^3*y^6,-x^5*y^5,x^2*y^8-
x^4*y^6-2*x^5*y^5,x*y^9+x^2*y^8-x^4*y^6-2*x^5*y^5,-2*x^3*y^9-x^4*y^8-
2*x^5*y^7,-2*x^3*y^10-2*x^4*y^9-x^5*y^8+x^6*y^7+x^7*y^6,-2*x^3*y^11-x^4*y^10+
2*x^5*y^9+3*x^6*y^8-2*x^8*y^6+x^10*y^4,-x^4*y^10-2*x^5*y^9,-3*x^17*y^34,-
x^4*y^11+3*x^5*y^10+3*x^6*y^9+x^7*y^8,-3*x^5*y^10,2*x^15*y^32+2*x^16*y^31,
4*x^15*y^31+2*x^16*y^30,6*x^15*y^30];end;
  f9:=function(x,y,j)return 
  [10,6*x+4*y,6*x*y+3*x^2+y^2,3*x*y+3*x^2+y^2,x*y^2+2*x^2*y+x^3,
-j*x*y^2-2*j^2*x^2*y+x^3,2*j*x*y^2+j^2*x^2*y+x^3,2*x*y^2+4*x^2*y+
x^3,3*x*y^2+6*x^2*y+x^3,x^2*y^2+x^3*y,-j^2*x^3*y,j*x*y^3+(j^2+
2*j)*x^2*y^2+j^2*x^3*y,2*x^2*y^2+2*x^3*y,j^2*x^15*y^10,j*x^3*y^2,
2*x^28*y^20+4*x^29*y^19+x^30*y^18,-x^3*y^3+j*x^4*y^2+j*x^5*y,
3*j^2*x^2*y^4+6*j*x^4*y^2+x^6,-2*j*x*y^5+2*j^2*x^2*y^4+
j*x^4*y^2-4*j^2*x^5*y+x^6,0,-j^2*x^5*y^2,j*x^4*y^3,j^2*x^3*y^4+
j*x^4*y^3+2*j*x^5*y^2,(j^2-j)*x^2*y^5-2*j*x^3*y^4+
2*x^4*y^3-2*j^2*x^5*y^2-2*j^2*x^6*y,j*x^5*y^3,
(2*j^2-j)*x^3*y^5+(-2*j^2-5*j)*x^4*y^4+(-5*j^2-3*j)*x^5*y^3+
(-2*j^2+j)*x^6*y^2,x^5*y^4,-x^4*y^6+j^2*x^6*y^4+j^2*x^7*y^3,
(2*j^2+j)*x^5*y^5+(j^2-j)*x^6*y^4+j^2*x^7*y^3,-x^5*y^5+
2*j^2*x^6*y^4-2*j*x^7*y^3,-2*x^5*y^7-x^6*y^6-2*x^7*y^5+
j^2*x^8*y^4-2*j*x^9*y^3+j^2*x^10*y^2,x^5*y^8+2*j^2*x^7*y^6+
(2*j^2+j)*x^8*y^5+(j^2+2*j)*x^9*y^4-x^10*y^3,
-2*j^2*x^6*y^8-2*x^7*y^7+4*j^2*x^8*y^6-2*j*x^9*y^5+(-2*j^2+
j)*x^10*y^4,3*j^2*x^8*y^6-2*x^9*y^5,3*j^2*x^29*y^22+6*j*x^31*y^20+
x^33*y^18,2*x^7*y^8-j*x^8*y^7+2*j^2*x^9*y^6+
j*x^10*y^5-2*j^2*x^11*y^4,(5*j^2+2*j)*x^9*y^6,x^27*y^20+
3*x^28*y^19+3*x^29*y^18,4*x^27*y^19+6*x^28*y^18,10*x^27*y^18];end;
  f13:=function(x,y)return 
[15,7*x+8*y,8*x*y+3*x^2+4*y^2,5*x*y+2*x^2+3*y^2,2*x*y^2+2*x^2*y+
y^3,x*y^2+x^3,-x^2*y-y^3,5*x*y^2+3*x^2*y+x^3+y^3,6*x*y^2+6*x^2*y+x^3+2*y^3,
x*y^3+x^2*y^2,0,-x*y^3-x^2*y^2-x^3*y-y^4,2*x*y^3+2*x^2*y^2+x^3*y,0,0,
x^21*y^27+5*x^22*y^26+3*x^23*y^25+x^24*y^24,-x^2*y^4-x^3*y^3-x^4*y^2,-
3*x^2*y^4-8*x^3*y^3+x^6,2*x*y^5-6*x^3*y^3-x^4*y^2+2*x^6+y^6,0,
x*y^6+x^2*y^5+x^3*y^4+x^4*y^3,
0,-2*x^3*y^4-x^4*y^3,2*x*y^6+3*x^2*y^5-2*x^4*y^3-x^5*y^2+y^7,
0,2*x*y^7+3*x^2*y^6+2*x^3*y^5-x^4*y^4-2*x^5*y^3-x^6*y^2+y^8,
x^3*y^6+x^5*y^4+x^7*y^2,x^7*y^3,x^2*y^8+x^4*y^6-x^5*y^5+x^7*y^3+x^8*y^2,
-2*x^4*y^6-x^5*y^5+x^7*y^3+x^8*y^2,-x^4*y^8-2*x^5*y^7-x^6*y^6+3*x^8*y^4,
x^4*y^9+4*x^5*y^8+6*x^6*y^7+3*x^7*y^6+x^8*y^5,
x^2*y^12+2*x^3*y^11+3*x^4*y^10+6*x^5*y^9+9*x^6*y^8+4*x^7*y^7-x^8*y^6-2*x^9*y^5,
4*x^6*y^8+2*x^7*y^7,-3*x^23*y^28-8*x^24*y^27+x^27*y^24,
-x^4*y^11+x^5*y^10+4*x^6*y^9+5*x^7*y^8-2*x^8*y^7-3*x^9*y^6-x^10*y^5,6*x^7*y^8,
3*x^21*y^26+5*x^22*y^25+2*x^23*y^24,8*x^21*y^25+7*x^22*y^24,15*x^21*y^24];end;
  f15:=function(x,y)return [15,11*x+4*y,
6*x*y+8*x^2+y^2,4*x*y+7*x^2,3*x^2*y+4*x^3,2*x^2*y+3*x^3,-2*x*y^2+3*x^3,x*y^2+
5*x^2*y+5*x^3,3*x*y^2+6*x^2*y+6*x^3,2*x^3*y+2*x^4,x^3*y+x^4,-2*x^2*y^2-x^3*y+
x^4,x^2*y^2+3*x^3*y+3*x^4,0,0,x^34*y^14+5*x^35*y^13+5*x^36*y^12,-2*x^4*y^2-
x^5*y+x^6,-6*x^4*y^2+3*x^6,-2*x^2*y^4+4*x^5*y+3*x^6,0,-x^3*y^4+x^4*y^3+x^5*y^2,
-x^5*y^2,-3*x^5*y^2+x^7,-x^2*y^5-2*x^3*y^4+2*x^4*y^3+4*x^5*y^2+4*x^6*y+
x^7,-x^6*y^2,-x^3*y^5-2*x^4*y^4+3*x^5*y^3+7*x^6*y^2+4*x^7*y,-x^5*y^4+x^7*y^2,
-2*x^6*y^4,-x^5*y^5-3*x^6*y^4+x^7*y^3+2*x^8*y^2,
-x^5*y^5-3*x^6*y^4+2*x^8*y^2+2*x^9*y,-2*x^7*y^5-2*x^8*y^4-x^10*y^2+x^12,
2*x^7*y^6+2*x^8*y^5-2*x^9*y^4-4*x^10*y^3-2*x^11*y^2,
x^6*y^8-2*x^7*y^7-x^8*y^6+4*x^9*y^5+3*x^10*y^4-4*x^11*y^3-4*x^12*y^2,
-x^10*y^4-2*x^11*y^3,-6*x^37*y^14+3*x^39*y^12,
x^9*y^6+3*x^10*y^5-3*x^12*y^3-2*x^13*y^2,-3*x^11*y^4,
4*x^34*y^13+7*x^35*y^12,4*x^33*y^13+11*x^34*y^12,15*x^33*y^12];end;
  f17:=function(x,y)return [20,12*x+8*y,
8*x*y+8*x^2+4*y^2,7*x*y+5*x^2+y^2,x*y^2+3*x^2*y+2*x^3,2*x^2*y,-2*x*y^2-x^3-
y^3,3*x*y^2+5*x^2*y+4*x^3+y^3,6*x*y^2+6*x^2*y+6*x^3+2*y^3,x^3*y+x^4,-x^2*y^2,-
x*y^3-3*x^2*y^2-2*x^3*y-x^4,x*y^3+x^2*y^2+2*x^3*y+2*x^4,-x^15*y^10,-x^3*y^2,
x^27*y^21+3*x^28*y^20+5*x^29*y^19+4*x^30*y^18,-3*x^3*y^3-2*x^4*y^2,-8*x^3*y^3-
6*x^4*y^2,-2*x^2*y^4-6*x^3*y^3+4*x^5*y+x^6+y^6,0,x^4*y^3+2*x^5*y^2+x^6*y,0,-
x^3*y^4-3*x^4*y^3-x^5*y^2,-2*x^2*y^5-3*x^3*y^4+5*x^5*y^2+4*x^6*y+x^7,
0,-x^2*y^6-3*x^3*y^5-2*x^4*y^4+3*x^5*y^3+6*x^6*y^2+4*x^7*y+x^8,
x^3*y^6+2*x^5*y^4+2*x^7*y^2,x^4*y^6-x^6*y^4-x^7*y^3,x^3*y^7+x^4*y^6-2*x^5*y^5
-2*x^6*y^4+x^7*y^3+x^8*y^2,x^3*y^7+x^4*y^6-2*x^5*y^5-3*x^6*y^4-x^7*y^3+x^8*y^2,
x^6*y^6-4*x^7*y^5-2*x^8*y^4-2*x^9*y^3,2*x^6*y^7+4*x^7*y^6+3*x^8*y^5+2*x^9*y^4,
-2*x^6*y^8+5*x^8*y^6+8*x^9*y^5+6*x^10*y^4+4*x^11*y^3+x^12*y^2,2*x^9*y^5,
-8*x^30*y^21-6*x^31*y^20,-x^6*y^9-2*x^7*y^8+4*x^9*y^6+5*x^10*y^5+2*x^11*y^4,
2*x^9*y^6,
x^27*y^20+7*x^28*y^19+5*x^29*y^18,8*x^27*y^19+12*x^28*y^18,20*x^27*y^18];end;
  f19:=function(x,y)return [24,16*x+8*y,12*x*y+10*x^2+2*y^2,7*x*y+9*x^2+y^2,
  x*y^2+5*x^2*y+4*x^3,2*x^2*y+4*x^3,-2*x*y^2+3*x^3-y^3,3*x*y^2+9*x^2*y+5*x^3,
  6*x*y^2+12*x^2*y+6*x^3,x^2*y^2+3*x^3*y+x^4,x^3*y+x^4,-x*y^3-2*x^2*y^2-x^3*y,
  3*x^2*y^2+5*x^3*y+2*x^4,0,0,-3*x^31*y^17-9*x^32*y^16-5*x^33*y^15,
  -x^3*y^3-3*x^4*y^2-x^5*y+x^6,-8*x^3*y^3-6*x^4*y^2+4*x^6,
  -2*x^2*y^4-6*x^3*y^3+4*x^5*y+5*x^6+y^6,x^6*y^3,-x^2*y^5+x^4*y^3+x^5*y^2+x^6*y,
  0,-3*x^4*y^3-2*x^5*y^2+x^7,-x^2*y^5-2*x^3*y^4+5*x^5*y^2+4*x^6*y+2*x^7,0,
-2*x^3*y^5-2*x^4*y^4+4*x^5*y^3+7*x^6*y^2+4*x^7*y+x^8,-x^4*y^5+x^6*y^3,
-2*x^5*y^5-x^7*y^3-x^8*y^2,-x^4*y^6-3*x^5*y^5-3*x^6*y^4-x^7*y^3,
-x^4*y^6-3*x^5*y^5-3*x^6*y^4-2*x^7*y^3+x^8*y^2,
-x^6*y^6-2*x^7*y^5+x^8*y^4+2*x^9*y^3-x^10*y^2+x^12,
x^6*y^7+2*x^7*y^6-x^8*y^5-4*x^9*y^4-3*x^10*y^3-x^11*y^2,
x^4*y^10-2*x^7*y^7+x^8*y^6+4*x^9*y^5+x^10*y^4+x^12*y^2,-4*x^9*y^5-2*x^10*y^4,
8*x^33*y^18+6*x^34*y^17-4*x^36*y^15,
x^8*y^7+2*x^9*y^6+x^10*y^5+x^11*y^4+2*x^12*y^3+x^13*y^2,-6*x^10*y^5,
-x^30*y^17-7*x^31*y^16-9*x^32*y^15,-8*x^30*y^16-16*x^31*y^15,-24*x^30*y^15];end;
  f21:=function(x,y)return 
  [30,10*x+20*y,14*x*y+3*x^2+13*y^2,9*x*y+x^2+11*y^2,6*x*y^2+x^2*y+5*y^3,
3*x*y^2+4*y^3,-3*x^2*y-x^3+3*y^3,10*x*y^2+4*x^2*y+7*y^3,15*x*y^2+6*x^2*y+x^3+
8*y^3,3*x*y^3+x^2*y^2+2*y^4,x*y^3+y^4,-2*x*y^3-3*x^2*y^2-x^3*y,6*x*y^3+
3*x^2*y^2+3*y^4,0,0,7*x^15*y^33+10*x^16*y^32+4*x^17*y^31,
-x*y^5-4*x^2*y^4-x^3*y^3+y^6,-9*x^2*y^4-8*x^3*y^3+4*y^6,
6*x*y^5-6*x^3*y^3-3*x^4*y^2+x^6+5*y^6,0,x*y^6+2*x^2*y^5+2*x^3*y^4,-x^2*y^5,
-3*x^2*y^5-3*x^3*y^4+y^7,6*x*y^6+7*x^2*y^5+x^3*y^4-3*x^4*y^3-2*x^5*y^2+2*y^7,
-x^3*y^5,6*x*y^7+10*x^2*y^6+3*x^3*y^5-3*x^4*y^4-2*x^5*y^3+y^8,x*y^8+x^3*y^6+
x^5*y^4,-x^2*y^8-x^3*y^7+x^5*y^5,x^2*y^8+x^3*y^7-2*x^4*y^6+x^5*y^5+x^6*y^4,
x*y^9-2*x^3*y^7-2*x^4*y^6+x^5*y^5+x^6*y^4,-x^2*y^10-4*x^5*y^7-x^6*y^6+y^12,
-x^2*y^11-x^3*y^10+4*x^4*y^9+6*x^5*y^8+3*x^6*y^7,x^2*y^12+6*x^3*y^11+
12*x^4*y^10+6*x^5*y^9-4*x^6*y^8-2*x^7*y^7+2*x^8*y^6-2*x^10*y^4,x^4*y^10+
2*x^5*y^9,4*x^15*y^36-9*x^17*y^34-8*x^18*y^33,x^2*y^13+2*x^3*y^12+
4*x^4*y^11-3*x^6*y^9-2*x^7*y^8,3*x^5*y^10,11*x^15*y^32+9*x^16*y^31+x^17*y^30,
20*x^15*y^31+10*x^16*y^30,30*x^15*y^30];end;
  f23:=function(x,y,j)return 
[30,18*x+12*y,14*x*y+11*x^2+5*y^2,10*x*y+8*x^2+2*y^2,2*x*y^2+5*x^2*y+3*x^3,
-j*x*y^2+(-2*j^2-4*j)*x^2*y+x^3,(4*j^2+2*j)*x*y^2+j^2*x^2*y-y^3,5*x*y^2+
9*x^2*y+5*x^3+y^3,9*x*y^2+12*x^2*y+7*x^3+2*y^3,x^2*y^2+2*x^3*y+x^4,
-j*x^2*y^2-j*x^3*y,(2*j^2+j)*x*y^3+(4*j^2+2*j)*x^2*y^2+(3*j^2+2*j)*x^3*y-x^4,
x*y^3+3*x^2*y^2+4*x^3*y+2*x^4,0,0,x^27*y^21+5*x^28*y^20+9*x^29*y^19+
5*x^30*y^18,-x^3*y^3+(3*j^2+2*j)*x^4*y^2+j^2*x^5*y,3*j^2*x^2*y^4-8*x^3*y^3+
(12*j^2+6*j)*x^4*y^2+x^6,-2*j*x*y^5+(2*j^2+4*j)*x^2*y^4-6*x^3*y^3+j*x^4*y^2+
(-4*j^2-8*j)*x^5*y+2*x^6+y^6,0,(2*j^2+j)*x^2*y^5+(j^2+2*j)*x^3*y^4+(-j^2+
2*j)*x^4*y^3-2*j^2*x^5*y^2+x^6*y,j*x^4*y^3,-2*x^4*y^3+(3*j^2+j)*x^5*y^2,(j^2+
3*j)*x^2*y^5+(j^2+6*j)*x^3*y^4+(-3*j^2+2*j)*x^4*y^3+(-7*j^2-5*j)*x^5*y^2+
(-4*j^2-6*j)*x^6*y+x^7,j*x^5*y^3,-x^2*y^6+(7*j^2+6*j)*x^3*y^5+(10*j^2+
11*j)*x^4*y^4+(2*j^2+8*j)*x^5*y^3+(-6*j^2-j)*x^6*y^2+4*x^7*y+x^8,j*x^3*y^6+
(2*j^2+j)*x^5*y^4-x^7*y^2,(-j^2+j)*x^4*y^6,j*x^3*y^7+j*x^4*y^6+(4*j^2+
3*j)*x^5*y^5+(4*j^2+3*j)*x^6*y^4-x^7*y^3+x^8*y^2,j*x^3*y^7+j*x^4*y^6+(2*j^2+
j)*x^5*y^5+5*j^2*x^6*y^4+3*j^2*x^7*y^3+j^2*x^8*y^2,-2*j*x^5*y^7+(5*j^2+
j)*x^6*y^6+(4*j^2+2*j)*x^7*y^5+(2*j^2+3*j)*x^8*y^4+2*j*x^9*y^3+j*x^10*y^2,
j^2*x^5*y^8+2*j*x^6*y^7+(-5*j^2+5*j)*x^7*y^6+(-9*j^2+3*j)*x^8*y^5+(-5*j^2+
j)*x^9*y^4-j^2*x^10*y^3,-3*j^2*x^4*y^10+(-8*j^2-4*j)*x^5*y^9+
(-2*j^2-11*j)*x^6*y^8+(16*j^2-6*j)*x^7*y^7+(26*j^2+13*j)*x^8*y^6+(16*j^2+
20*j)*x^9*y^5+(4*j^2+10*j)*x^10*y^4-2*j^2*x^11*y^3+x^12*y^2,(-j^2+
4*j)*x^8*y^6+(-2*j^2+2*j)*x^9*y^5,3*j^2*x^29*y^22-8*x^30*y^21+(12*j^2+
6*j)*x^31*y^20+x^33*y^18,-j*x^6*y^9+(j^2-4*j)*x^7*y^8+(7*j^2-2*j)*x^8*y^7+
(10*j^2+2*j)*x^9*y^6+(8*j^2+4*j)*x^10*y^5+3*j^2*x^11*y^4+(j^2-j)*x^12*y^3,
(-3*j^2+6*j)*x^9*y^6,2*x^27*y^20+10*x^28*y^19+8*x^29*y^18,12*x^27*y^19+
18*x^28*y^18,30*x^27*y^18];
end;
  f27:=function(x,y,j)return 
[40,16*x+24*y,20*x*y+6*x^2+14*y^2,13*x*y+3*x^2+11*y^2,7*x*y^2+3*x^2*y+4*y^3,
4*x*y^2-2*j^2*x^2*y+2*y^3,2*j*x*y^2-4*x^2*y-x^3+y^3,13*x*y^2+7*x^2*y+x^3+
6*y^3,18*x*y^2+12*x^2*y+2*x^3+8*y^3,3*x*y^3+2*x^2*y^2+y^4,x*y^3-j^2*x^2*y^2,
(2*j^2+4*j)*x*y^3+(4*j^2+5*j)*x^2*y^2-2*x^3*y-y^4,6*x*y^3+5*x^2*y^2+x^3*y+
2*y^4,-j*x^10*y^15,-j^2*x^2*y^3,-6*x^18*y^30-13*x^19*y^29-7*x^20*y^28-
x^21*y^27,-x*y^5-3*x^2*y^4-2*x^3*y^3,-12*x^2*y^4-8*x^3*y^3+6*j*x^4*y^2+2*y^6,
8*x*y^5+2*j^2*x^2*y^4-6*x^3*y^3-4*x^4*y^2-4*j^2*x^5*y+x^6+3*y^6,0,x*y^6+(-
2*j^2-3*j)*x^2*y^5+(-2*j^2-3*j)*x^3*y^4-j*x^4*y^3+j^2*x^5*y^2,0,-3*x^2*y^5+
(3*j^2+2*j)*x^3*y^4+j*x^4*y^3,6*x*y^6+(-5*j^2-9*j)*x^2*y^5-5*j*x^3*y^4+(4*j^2+
j)*x^4*y^3-2*x^5*y^2+y^7,0,4*x*y^7+(-4*j^2-8*j)*x^2*y^6+(j^2-7*j)*x^3*y^5+
6*j^2*x^4*y^4+(5*j^2+3*j)*x^5*y^3-x^6*y^2+y^8,x^2*y^7-j*x^4*y^5-j^2*x^6*y^3,
j*x^3*y^7+j*x^4*y^6-2*j^2*x^6*y^4,x^2*y^8-j^2*x^3*y^7+(2*j^2+3*j)*x^4*y^6-
2*x^5*y^5-j^2*x^6*y^4-j^2*x^7*y^3,-j*x^2*y^8+(2*j^2+3*j)*x^3*y^7+(4*j^2+
5*j)*x^4*y^6+(2*j^2+3*j)*x^5*y^5-j^2*x^6*y^4-j^2*x^7*y^3,-x^2*y^10-3*x^4*y^8+
(4*j^2+6*j)*x^5*y^7+(2*j^2+6*j)*x^6*y^6+2*j*x^7*y^5,-j^2*x^3*y^10+(-5*j^2-
2*j)*x^4*y^9+(-10*j^2-7*j)*x^5*y^8+(-9*j^2-7*j)*x^6*y^7+2*x^7*y^6+j^2*x^8*y^5,
x^2*y^12+(-4*j^2-2*j)*x^3*y^11+(-9*j^2-2*j)*x^4*y^10-6*j^2*x^5*y^9+(j^2+
6*j)*x^6*y^8+(8*j^2+10*j)*x^7*y^7+(5*j^2+4*j)*x^8*y^6+j*x^10*y^4,-
4*j^2*x^5*y^9+(-4*j^2-2*j)*x^6*y^8,-2*x^18*y^33+12*x^20*y^31+8*x^21*y^30-
6*j*x^22*y^29,-x^3*y^12+(2*j^2+3*j)*x^4*y^11+(j^2+4*j)*x^5*y^10+(2*j^2+
4*j)*x^6*y^9+(5*j^2+3*j)*x^7*y^8+(4*j^2+j)*x^8*y^7+j^2*x^9*y^6,(-8*j^2-
2*j)*x^6*y^9,-11*x^18*y^29-13*x^19*y^28-3*x^20*y^27,-24*x^18*y^28-
16*x^19*y^27,-40*x^18*y^27];end;
  f31:=function(x,y,j)return 
[45,21*x+24*y,24*x*y+9*x^2+12*y^2,15*x*y+6*x^2+9*y^2,7*x*y^2+5*x^2*y+x^3+
2*y^3,(-j^2-4*j)*x*y^2+2*x^2*y+2*y^3,-2*x*y^2+(4*j^2+
j)*x^2*y-2*x^3,13*x*y^2+11*x^2*y+2*x^3+4*y^3,18*x*y^2+18*x^2*y+3*x^3+6*y^3,
2*x*y^3+3*x^2*y^2+x^3*y,-j*x*y^3-j*x^2*y^2,-3*x*y^3+(5*j^2+
3*j)*x^2*y^2+(4*j^2+2*j)*x^3*y-x^4-y^4,4*x*y^3+7*x^2*y^2+3*x^3*y+y^4,
0,0,4*x^21*y^27+13*x^22*y^26+11*x^23*y^25+2*x^24*y^24,j^2*x*y^5+(3*j^2+
2*j)*x^2*y^4-3*x^3*y^3-x^4*y^2,(12*j^2+
3*j)*x^2*y^4-16*x^3*y^3-6*x^4*y^2+2*y^6,
(-2*j^2-8*j)*x*y^5-2*x^2*y^4-12*x^3*y^3+(j^2+4*j)*x^4*y^2+4*x^5*y+
2*x^6+4*y^6,0,Unknown(),Unknown(),2*j^2*x^2*y^5+(4*j^2+3*j)*x^3*y^4+
(2*j^2+3*j)*x^4*y^3,(-2*j^2-4*j)*x*y^6+3*x^2*y^5+(-j^2+
3*j)*x^3*y^4+(-2*j^2+4*j)*x^4*y^3-4*j^2*x^5*y^2+2*x^6*y+x^7+y^7,
Unknown(),Unknown(),Unknown(),Unknown(),Unknown(),Unknown(),
j*x^2*y^10-2*j^2*x^3*y^9+(-2*j^2-j)*x^4*y^8+(4*j^2+
2*j)*x^5*y^7+(7*j^2+3*j)*x^6*y^6+(4*j^2+2*j)*x^7*y^5-x^8*y^4,
Unknown(),Unknown(),Unknown(),Unknown(),Unknown(),-9*j^2*x^7*y^8,
9*x^21*y^26+15*x^22*y^25+6*x^23*y^24,24*x^21*y^25+21*x^22*y^24,45*x^21*y^24];
end;
  f35:=function(x,y)return [60,28*x+32*y,28*x*y+14*x^2+18*y^2,
21*x*y+7*x^2+11*y^2,8*x*y^2+6*x^2*y+x^3+3*y^3,4*x*y^2+2*x^2*y,-2*x*y^2-
4*x^2*y-3*x^3-3*y^3,15*x*y^2+13*x^2*y+4*x^3+7*y^3,24*x*y^2+18*x^2*y+8*x^3+
10*y^3,2*x*y^3+2*x^2*y^2+x^3*y+y^4,0,-5*x*y^3-6*x^2*y^2-4*x^3*y-x^4-2*y^4,
6*x*y^3+6*x^2*y^2+3*x^3*y+x^4+2*y^4,0,0,7*x^21*y^27+15*x^22*y^26+13*x^23*y^25+
4*x^24*y^24,-3*x^2*y^4-5*x^3*y^3-x^4*y^2,-12*x^2*y^4-24*x^3*y^3-6*x^4*y^2,
8*x*y^5-2*x^2*y^4-18*x^3*y^3-4*x^4*y^2+4*x^5*y+3*x^6+3*y^6,0,Unknown(),
Unknown(),-x^2*y^5-5*x^3*y^4-3*x^4*y^3,6*x*y^6+7*x^2*y^5-3*x^3*y^4-
6*x^4*y^3+2*x^6*y+x^7+2*y^7,Unknown(),Unknown(),Unknown(),
Unknown(),Unknown(),Unknown(),-2*x^3*y^9-3*x^4*y^8-4*x^5*y^7-
5*x^6*y^6-x^8*y^4,Unknown(),Unknown(),Unknown(),Unknown(),
Unknown(),6*x^7*y^8,11*x^21*y^26+21*x^22*y^25+7*x^23*y^24,32*x^21*y^25+
28*x^22*y^24,60*x^21*y^24];end;
  f37:=function(x,y,s)local v;v:=s*GetRoot(-x*y,2);
  return [64,32*x+32*y,32*x*y+16*x^2+16*y^2,22*x*y+10*x^2+
10*y^2,8*x*y^2+8*x^2*y+2*x^3+2*y^3,4*x*y^2+4*x^2*y,-4*x*y^2-4*x^2*y-2*x^3-
2*y^3,16*x*y^2+16*x^2*y+5*x^3+5*y^3,24*x*y^2+24*x^2*y+8*x^3+8*y^3,2*x*y^3+
3*x^2*y^2+2*x^3*y,x^2*y^2,-5*x*y^3-7*x^2*y^2-5*x^3*y-x^4-y^4,5*x*y^3+
8*x^2*y^2+5*x^3*y+x^4+y^4,-v^25,-v^5,
-5*v^45*y^3+16*y*v^47+16*x*v^47-5*x^3*v^45,-2*x^2*y^4-4*x^3*y^3-2*x^4*y^2,
-12*x^2*y^4-16*x^3*y^3-12*x^4*y^2,8*x*y^5-4*x^2*y^4-12*x^3*y^3-4*x^4*y^2
+8*x^5*y+2*x^6+2*y^6,v^9,Unknown(),Unknown(),-x^2*y^5-3*x^3*y^4-
3*x^4*y^3-x^5*y^2,4*x*y^6+3*x^2*y^5+3*x^5*y^2+4*x^6*y+x^7+y^7,Unknown(),
Unknown(),Unknown(),Unknown(),Unknown(),Unknown(),-
2*x^3*y^9-2*x^4*y^8-6*x^5*y^7-8*x^6*y^6-6*x^7*y^5-2*x^8*y^4-2*x^9*y^3,
Unknown(),Unknown(),Unknown(),Unknown(),Unknown(),
8*v^15,-10*y^2*v^45+22*v^47-10*x^2*v^45,-32*y*v^45-32*x*v^45,-64*v^45];end;
  f39:=function(x,y)return [81,45*x+36*y,42*x*y+24*x^2+15*y^2,27*x*y+18*x^2+
9*y^2,8*x*y^2+13*x^2*y+5*x^3+y^3,3*x*y^2+6*x^2*y+3*x^3,-6*x*y^2-3*x^2*y-3*y^3,
18*x*y^2+24*x^2*y+9*x^3+3*y^3,27*x*y^2+36*x^2*y+12*x^3+6*y^3,x*y^3+5*x^2*y^2+
4*x^3*y+x^4,x^2*y^2+x^3*y,-5*x*y^3-8*x^2*y^2-6*x^3*y-2*x^4-y^4,4*x*y^3+
11*x^2*y^2+10*x^3*y+2*x^4,0,0,3*x^25*y^23+18*x^26*y^22+24*x^27*y^21+
9*x^28*y^20,-x^2*y^4-5*x^3*y^3-5*x^4*y^2-x^5*y,-9*x^2*y^4-24*x^3*y^3-
18*x^4*y^2+3*x^6,6*x*y^5-6*x^2*y^4-18*x^3*y^3-3*x^4*y^2+12*x^5*y+6*x^6+3*y^6,
x^5*y^4,Unknown(),Unknown(),-3*x^3*y^4-6*x^4*y^3-3*x^5*y^2,2*x*y^6-
3*x^3*y^4+x^4*y^3+9*x^5*y^2+8*x^6*y+2*x^7+y^7,Unknown(),Unknown(),
Unknown(),Unknown(),Unknown(),Unknown(),-x^4*y^8-4*x^5*y^7-
9*x^6*y^6-8*x^7*y^5-x^8*y^4-x^10*y^2,Unknown(),Unknown(),
Unknown(),Unknown(),Unknown(),0,9*x^25*y^22+27*x^26*y^21+
18*x^27*y^20,36*x^25*y^21+45*x^26*y^20,81*x^25*y^20];end;
tbl.irreducibles:=
[f1(x),f1(y),f3(x,y,E(3)),f3(y,x,E(3)),f3(x,y,E(3)^2),f3(y,x,E(3)^2),
f7(x,y),f7(y,x),f9(x,y,E(3)),f9(y,x,E(3)),f9(x,y,E(3)^2),f9(y,x,E(3)^2),
f13(x,y),f13(y,x),f15(x,y),f15(y,x),f17(x,y),f17(y,x),f19(x,y),f19(y,x),
f21(x,y),f21(y,x),f23(x,y,E(3)),f23(y,x,E(3)),f23(x,y,E(3)^2),f23(y,x,E(3)^2),
f27(x,y,E(3)),f27(y,x,E(3)),f27(x,y,E(3)^2),f27(y,x,E(3)^2),
f31(x,y,E(3)),f31(y,x,E(3)),f31(x,y,E(3)^2),f31(y,x,E(3)^2),
f35(x,y),f35(y,x),f37(x,y,-1),f37(x,y,1),f39(x,y),f39(y,x)];
  tbl.centralizers:=List(tbl.classes,x->tbl.order/x);
  tbl.irredinfo:=List(CHEVIE.RawData("CharInfo","G33")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G33")(x,rec())));
  return CHEVIE.compat.MakeCharacterTable(tbl);
end);

CHEVIE.AddData("CharTable","G33",function()local res;
  res:=CHEVIE.RawData("HeckeCharTable","G33")(List([1..4],x->[1,-1]),[]);
  res.identifier:="G33"; res.name:="G33";
  res.powermap:=CHEVIE.RawData("PowerMaps","G33");
  res.irreducibles{[31..40]}{Concatenation([21,22],[25..30],[32..36])}:=
[[E(3)^2,E(3),E(3),E(3)^2,0,0,1,0,0,3*E(3),3*E(3)^2,-9*E(3),1],[-E(3)^2,-E(3),
E(3),E(3)^2,0,0,1,0,0,3*E(3),3*E(3)^2,9*E(3),-1],[E(3),E(3)^2,E(3)^2,E(3),0,0,
1,0,0,3*E(3)^2,3*E(3),-9*E(3)^2,1],[-E(3),-E(3)^2,E(3)^2,E(3),0,0,1,0,0,
3*E(3)^2,3*E(3),9*E(3)^2,-1],[0,0,0,0,-3,-1,0,-1,1,2,2,6,0],[0,0,0,0,3,-1,0,
-1,-1,2,2,-6,0],[0,0,0,0,4,0,0,0,0,0,0,-8,0],[0,0,0,0,-4,0,0,0,0,0,0,8,0],[0,
0,0,0,0,0,-3,0,0,0,0,0,-3],[0,0,0,0,0,0,-3,0,0,0,0,0,3]];
  res.galomorphisms:=Group((4,5)(6,7)(10,11)(12,13)(14,15)(16,17)(18,19)(20,21)
     (25,26)(28,29));
  res.text:="origin: HeckeCharTable";
  return res;
end);

CHEVIE.AddData("HeckeRepresentation","G33",function(para,root,i)
  local p,r,rep,f1,f5,f7,f10,f13,f15,f17,f19,f21,f23,f27,dec;
  dec:=function(d,l)local m,v,i,j,k;
    m:=List([1..5],i->List([1..d],y->[1..d]*0));
    for v in l do
      for k in v{[2..Length(v)]} do
	i:=QuoInt(k,d^2);k:=k mod d^2;j:=QuoInt(k,d);k:=k mod d;
	m[i+1][j+1][k+1]:=v[1];
      od;
    od;
    return m;
  end;
  p:=para[1][2];r:=para[1][1];
  f1:=r->List([1..5],x->[[r]]);
  f5:=function(x,y,j)return WGraph2Representation([[[2,3,4,5],[1,3,4,5],
   [1,2,4,5],[1,2,3,5],[1,2,3,4]],[[1,2,x,-y],[2,3,-j*y,j^2*x],[2,4,-y,x],
   [3,4,x,-y],[4,5,x,-y]]],[x,y])*y^0*x^0;
  end;
# For the usual presentation 7th rep. does not have a W-graph. Use AltPres[1]
  f7:=function(y,x)local rep;
    rep:=WGraph2Representation([[[1,5],[1,3,4],[2],[2,5],[3],[4]],
     [[1,2,-y,x],[1,4,-y,x],[2,3,-y,x],[2,5,-y,0],[2,6,-y,0],[3,4,0,-y],
     [4,5,-y,x],[4,6,-y,x]]],[x,y])*y^0*x^0;
    rep[4]:=rep[4]^rep[5];rep[3]:=rep[4]*rep[3]/rep[4];
  return rep;end;
  f10:=function(r,p,a) return List(f5(r,p,a),x->ExteriorPower(x,2)/r);end;
  f13:=function(x,y) return dec(15,[[-1,91,108,129,709,729,788],[-x,388,418,451,
483,635,676,969,986],[-y,190,226,258,290,371,520,629,650,656,659,761,868,897,
898,902,918,997,1104,1106],[-x*y,165,167,195,968],[-x^2,983,1088],[-y^2,886],
[-x^2*y,81,202,382,831,832,981,982,1056,1057],[-x^3,411,651],[-x-y,219,728],[-
x*y-y^2,218,368,1103],[-x*y^2-x^2*y,82,817],[-x*y^2-y^3,366,367,591,592],[-
x^2*y-x^3,201,381,1086,1087],[-x*y-x^2-y^2,211,213],[x,0,32,64,160,204,240,
272,304,321,337,384,386,399,409,410,414,416,433,466,498,546,562,604,671,691,
771,834,845,882,930,946,1011,1028,1044,1059,1076,1094,1124],[y,79,80,176,192,
205,208,224,353,385,417,449,450,482,537,578,594,657,658,675,835,890,896,899,
964,980,1060,1092,1108],[x*y,21,52,75,76,143,180,198,203,210,212,377,378,407,
408,435,436,437,438,737,802,813,826,828,833,1051,1053,1058],[x^2,456,487,681],
[y^2,351,352,576,577,586,588,646],[x^3,441,442,891],[x+y,96,112,144,174,199,
241,273,305,379,380,401,610,642,674,739,803,819,851,883,932,948,1012],[x*y+
x^2,196,383,398,413],[x*y+y^2,77,78,173,182],[x*y^2+x^2*y+x^3,216,
217]])*x^0*y^0;end;
  f15:=function(x,y) return dec(15,[[-x^-1*y^2,1002],[-x,331,388,418,943],[-y,
15,41,55,85,286,302,318,373,505,509,544,565,569,575,580,659,716,821,836,866,
878,1014,1019],[-x^2*y^-1,816],[-x^-1*y^2+y,116],[-x+y,818,958],[x^-1*y^2,
999],[x,16,32,48,64,80,96,112,128,144,208,224,225,226,289,305,321,337,353,358,
369,378,385,392,401,417,448,449,450,466,469,482,485,498,546,559,562,574,578,
594,625,626,642,658,675,691,707,723,726,739,741,755,758,819,835,867,883,892,
899,900,916,932,948,964,980,996,1012,1028,1033,1060,1076,1077],[y,0,57,131,
160,176,192,207,241,257,273,433,514,530,610,674,697,761,771,787,803,851,896,
989,1044,1092,1108,1124],[x^2*y^-1,756,891],[x^-1*y^2-y,27,912,974,1003],[x-y,
238,928,1018]])*x^0*y^0;end;
  f17:=function(x,y) return dec(20,[[-x^-2*y^3,880],[-x^-1*y^2,120,122,125,
1140,1142,1145,1580,1582,1585],[-x,45,140,142,145,151,316,396,402,466,481,569,
614,645,649,667,746,751,786,796,911,1049,1053,1107,1116,1196,1231,1232,1253,
1276,1291,1336,1352,1506,1516,1560,1565,1569,1573,1643,1706,1787,1884,1973],[-
y,271,382,385,460,462,465,551,716,825,831,833,1042,1087,1097,1146,1169,1311,
1322,1325,1387,1444,1586,1630,1634,1660,1690,1763,1786,1877,1967,1977],[-
x^2*y^-1,264,350,364,661,750,754,761,853,870,930,964,984,1208,1550],[-x^3*y^-
2,904],[-x-2*y,785,1505],[-x^-2*y^3-2*x^-1*y^2+2*x+x^2*y^-1,1120],[-x^-1*y^2-
y,822,1300],[-x-y,640,642,740,742,745,767,781,789,791,1106,1186,1308,1384,
1464,1501,1509,1511,1562],[-x-x^2*y^-1,1118,1471,1571],[-x^-1*y^2-x-3*y,780,
782,1500,1502],[-x^-2*y^3-x^-1*y^2-y,820],[-x^-1*y^2-x-y,1990],[-x-y-x^2*y^-1,
1304,1984],[-x^-3*y^4-x^-2*y^3+3*x+2*y+x^2*y^-1,1180],[-x^-1*y^2+x,1780,1782],
[-y+x^2*y^-1,1128],[-x^-1*y^2+x-y,1105,1785],[x^-1*y^2,384,388,391,1003,1062,
1324,1328,1331,1360],[x,21,126,147,189,251,252,273,290,294,300,302,305,315,
357,362,365,368,371,378,399,463,484,568,627,652,665,671,673,735,747,757,765,
778,795,799,821,937,962,965,968,971,982,985,988,991,998,1047,1048,1052,1058,
1090,1094,1111,1115,1193,1199,1242,1305,1313,1339,1345,1349,1490,1494,1515,
1519,1557,1567,1568,1572,1578,1603,1646,1762,1765,1768,1771,1789,1791,1804,
1851,1852,1881,1900,1902,1905,1915,1936,1953,1978,1993,1999],[y,0,24,63,84,
102,123,168,188,210,231,336,351,421,440,505,526,589,690,827,931,947,1020,1022,
1025,1086,1091,1136,1143,1168,1381,1385,1391,1393,1410,1424,1441,1473,1523,
1583,1640,1642,1645,1725,1747,1831,1971,1997],[x^2*y^-1,913,1553,1907,1920,
1922,1925,1931],[x^3*y^-2,804],[x^-2*y^3-y,380,1320],[x^-1*y^2+y,1080,1082,
1085,1123,1380,1382],[x+y,105,360,442,547,660,662,694,715,760,762,771,787,824,
884,960,980,1010,1031,1073,1117,1157,1178,1197,1240,1340,1342,1368,1389,1404,
1431,1452,1507,1536,1599,1663,1726,1760,1810,1894,1957],[x+x^2*y^-1,1109,1122,
1124,1125,1130,1131,1188,1244,1248,1411,1481,1492,1980,1982,1985],[x+y-x^3*y^-
2,1544],[x^-1*y^2+x+y,1184],[x^-1*y^2+x+x^2*y^-1,1991],[x+y+2*x^2*y^-1+x^3*y^-
2,1551],[x^-1*y^2+2*x+y+x^2*y^-1,1191],[2*x+y,1100,1102],[2*x+x^2*y^-1,1185],
[2*x+y+x^2*y^-1,1113,1182]])*x^0*y^0;end;
  f19:=function(x,y) return dec(24,[[-1,77,154,231,403,521,604,609,1676,1754,
1962,2249],[-x,579,628,1153,1232,1303,1370,1440,1441,1806,1858,1932,2524,2773,
2855],[-y,451,494,794,1574,1997,2002,2107,2201,2631],[-x*y,271,316,542,922,
972,1067,1118,2232,2240,2244,2276],[-x*y^2,1713],[-x*y^3,1688,1710],[-x^2,
2544,2846],[-y^2,1600,1697,1722],[-x^2*y,1044,1706],[-x^3,1106,1137,1144,1512,
1513,2837],[-y^3,1696],[-x^4,1116,1129,2835],[-x*y^3-2*x^2*y^2-2*x^3*y,1131],
[-x*y^3-2*x^2*y^2-2*x^3*y-x^4,1128],[-x-y,2592],[-x*y-x^2,1700],[-x*y^2-x^2*y,
1725],[-x*y^3-x^2*y^2,2280],[-x^2*y-x^3,1584,1585],[-x^2*y^2-x^3*y+x^4,1134],
[-x*y^3-x^2*y^2+x^3*y+x^4,1704,1705],[-x^2+y^2,1721],[1,109,179,197,298,398,
772,777,830,860,880,1442,2130,2230,2250,2251],[x,0,25,50,168,169,171,176,195,
200,294,300,400,447,450,500,525,550,575,603,701,751,768,769,776,901,951,1001,
1026,1051,1126,1151,1250,1252,1277,1296,1297,1299,1302,1304,1377,1402,1403,
1447,1452,1477,1505,1527,1538,1627,1702,1727,1752,1753,1826,1828,1903,1994,
2003,2053,2078,2103,2106,2121,2128,2155,2241,2253,2303,2354,2448,2451,2454,
2479,2549,2554,2579,2600,2604,2654,2677,2692,2697,2704,2729,2754,2775,2779,
2804,2829],[y,350,425,449,475,648,674,726,744,747,750,1101,1176,1202,1327,
1347,1427,1728,1778,1875,1896,1899,1902,1973,2024,2105,2304,2329,2379,2409,
2429,2472,2473,2475,2480,2504,2878],[x*y^-1,1554],[x*y,123,246,264,265,267,
272,369,437,442,792,793,1005,1010,1012,1048,1593,1653,2093,2098,2115,2118,
2169,2352,2353,2870],[x*y^2,1587,1590,1689],[x*y^3,1686],[x^2,441,566,1275,
1280,1368,1369,1466,1514,1539,1542,1995,1998,2000,2004,2042,2097,2568,2569,
2571,2576,2645,2688,2689,2696,2717,2764,2769,2808,2811],[y^2,1694,1698],
[x^2*y^-1,1545],[x^2*y,435,438,1014,1114,1591,1682,2091,2094,2737],[x^2*y^2,
1680,1681],[x^3,557,1113,1120,1130,2282,2285,2290,2643,2715,2785,2792],[y^3,
1720],[x^4,555,1105,1140,2288,2292],[x^2-y^2,1718],[x+y,125,250,275,325,375,
651,676,801,926,976,1076,1177,1352,1577,1602,1677,1878,1978,2028,2178,2203,
2278,2404,2629,2879],[x*y+x^2,1586,1724,2691,2740,2745,2765],[x*y^2+x^2*y,
1701],[x^2*y+x^3,2763,2784,2787],[x^2*y^2+x^3*y,1107],[x^2*y^2+x^3*y-x^4,
1110],[x^2*y^2+x^3*y+x^4,1104],[x^3*y+x^4+y^4,1707],[x*y^3+x^3*y+x^4+y^4,
1712],[x^3*y+2*x^4,2283,2286]])*x^0*y^0;end;
  f21:=function(x,y) return dec(30,[[-3*x*y^3-x^2*y^2+2*x^3*y-y^4,4387],[-
3*x*y^3+x^3*y-2*y^4,4386],[-3*x*y^2+x^2*y+2*x^3-y^3,4308],[-2*x^3*y^2-3*x^4*y-
x^5,768],[-2*x*y^4-2*x^2*y^3,4356],[-2*x*y-x^2,3394],[-2*x*y-x^2-y^2,3349],[-
2*x*y^3-x^2*y^2-y^4,4392],[-2*x*y^2-x^2*y+y^3,3933],[-2*x*y^5-x^2*y^4+
2*x^3*y^3+x^4*y^2,4326],[-2*x^2*y+y^3,4400],[-2*x*y^2+x^2*y+y^3,3950],[-
2*x^2*y^4+x^4*y^2+y^6,4429],[-1,716,901,1150,1612,1767,1804,2485,2547,2753,
3401,3700,3824,4160],[-x^-2,3238],[-x^-1*y,1366],[-x,254,378,571,878,883,890,
964,1051,1064,1252,1304,1364,1790,1861,1874,1951,2075,2253,2347,2414,2744,
3104,3203,3275,3590,4174,4190,4484],[-y,69,151,216,574,578,583,590,613,671,
1299,1353,1426,1502,1519,1992,2053,2117,2706,2733,3094,3119,3252,4474],[-x*y^-
1,1191,1311],[-x*y,120,570,588,631,996,1296,1302,1413,1703,2284,2295,2495,
2510,2742,2827,3090,3185,3846,4002,4089,4125,4470],[-x*y^2,1683,2280,2286,
2292,2581,2588,2593,3390,3396,3402,3483,3509,3934,4263,4265,4268,4273],[-
x*y^3,821,1756,4351],[-x*y^4,4329],[-x^2,683,888,1057,1246,1297,1357,1488,
1867,2076,2082,2300,2737,3096,3097,3102,3181,3194,3410,4094,4170,4188,4476,
4477,4482],[-y^2,488,493,500,1770,1776,1782,2431,4276,4298,4303,4376],[-
x^2*y^-1,4101,4171,4311],[-x^2*y,663,742,766,835,1234,1392,1694,3033,3365,
3473,4086,4092,4264],[-x^2*y^2,1230,1236,1651,1692,3453],[-x^2*y^3,1650,1668,
1769],[-x^2*y^4,3513],[-x^3,674,1250,2298,4087],[-y^3,4373],[-x^3*y,672,736,
755,770,1687,3441,3451,3464,4341],[-x^3*y^2,724,833,1742,1754,3526],[-x^3*y^3,
720,726],[-x^4,667],[-y^4,4369],[-x^4*y,740,2648,2653],[-x^4*y^2,811,824,3515,
3530],[-x^5,2660],[-x^6,2658],[-x^4*y^2-3*x^5*y-2*x^6,1638],[-x*y^2-2*x^2*y,
3397],[-x^2*y^4-2*x^3*y^3,1758],[-x^3*y-2*x^4,1248],[-x^4*y^2-2*x^5*y,738],[-
x^5*y^2-2*x^6*y,1717],[-x^2*y^4-2*x^3*y^3-3*x^4*y^2-3*x^5*y-x^6,1714],[-
x^2*y^5-2*x^3*y^4-2*x^4*y^3-3*x^5*y^2-x^6*y,1710],[-x^2*y^4-2*x^3*y^3-
2*x^4*y^2-x^5*y,1729],[-x^2*y^5-2*x^3*y^4-2*x^4*y^3-x^5*y^2,1716,1722],[-
x*y^2-2*x^2*y-x^3,3192],[-x^2*y^2-2*x^3*y-x^4,4330],[-x^2*y^3-2*x^3*y^2-x^4*y,
1755,3462,4427],[-x^2*y^4-2*x^3*y^3-x^4*y^2,825],[-x^2*y^5-2*x^3*y^4-x^4*y^3,
3522],[-x^3*y^2-2*x^4*y-x^5,3457],[-x^3*y^4-2*x^4*y^3-x^5*y^2,822],[-x^4*y^3-
2*x^5*y^2-x^6*y,817],[-x*y^5-2*x^2*y^4+x^3*y^3,4327],[-x*y^4-2*x^2*y^3+
x^3*y^2+x^4*y,4357],[-x^-1*y^2-y,1789],[-x-y,1764,1774,2749,2764,3353],[-x*y-
x^2,481,2767,2970,2976,3168,3199,3282,3344,3940],[-x*y-y^2,484,3333,4319],[-
x*y^2-x^2*y,480,1673,1699,2133,2508,3342,4289],[-x*y^2-y^3,4389],[-x*y^3-
x^2*y^2,4278,4352,4359],[-x*y^4-x^2*y^3,4362],[-x^2*y-x^3,679,1642,2134,3337],
[-x^2*y^2-x^3*y,754,2130,3469],[-x^2*y^3-x^3*y^2,750],[-x^3*y-x^4,1636,1721,
3454],[-x^3*y^2-x^4*y,1624,1733,3423,3450,3456,4448,4453,4460],[-x^3*y^3-
x^4*y^2,829,1620,1626,3514],[-x^3*y^4-x^4*y^3,3510,3516],[-x^4*y-x^5,1640],[-
x^4*y^2-x^5*y,4458],[-x^4*y^3-x^5*y^2,816],[-x*y^2-x^2*y-x^3,4384],[-x*y^2-
x^3-y^3,4381],[-x*y^3-x^2*y^2-x^3*y,753],[-x^2*y^4-x^3*y^3-x^5*y,1711],[-
x*y^3-x^3*y-x^4-y^4,4380],[-x*y-x^2+y^2,4292],[-x^3*y^3-x^4*y^2+x^5*y,1730],[-
x*y^2-x^2*y+2*x^3,3018],[-x*y^3-x^2*y^2+2*x^3*y,3498],[-x*y^6-x^2*y^5+
4*x^3*y^4+2*x^4*y^3,4428],[-x^-1*y^2+x,4406],[-x^-1*y^2+y,3956],[-x^-1*y^3+
y^2,3953],[-x+y,1291,1351,1775,2731,3023,3092,3099,3406,4472,4479],[-x*y+x^2,
2281,3005,3013,3020,3029,3391,3404,4085],[-x*y+y^2,3003,3503],[-x*y^2+x^2*y,
1685,3485,3493],[-x*y^2+y^3,3935,3938,3943,3959],[-x*y^3+y^4,4336],[-x*y^4+
x^3*y^2,4350],[-x*y^5+x^2*y^4,4320,4413,4415,4439],[-x*y^5+x^3*y^3,4332],[-
x^2+y^2,3019,3331,4304],[-x^2*y+x^3,665,1231],[-x^2*y+y^3,3499,4388],[-
x^2*y^2+y^4,4436],[-x^2*y^3+x^4*y,4442,4449],[-x^2*y^3+y^5,4433],[-x^3*y^2+
x^4*y,721,2645],[-x^3*y^2+x^5,1621],[-x^-1*y^2+x-y,4306],[-x^-1*y^3+x*y-y^2,
4403],[-x*y+x^2-y^2,4293,4295],[-x*y^4+x^2*y^3-x^3*y^2-x^4*y,4322,4334],[-
x*y^2+x^2*y+x^3,4280],[-x*y^5+x^3*y^3+x^4*y^2,4418,4423],[-x^2*y^3+x^3*y^2+
x^4*y,1745],[-x^-1*y^4+x*y^2+x^2*y-2*y^3,4399],[-x*y^4+x^2*y^3+x^4*y+x^5,
4321],[-x*y^5+x^2*y^4+x^3*y^3+2*x^4*y^2+x^5*y,4430],[-x*y^3+x^2*y^2+2*x^3*y+
x^4,4364],[-x*y^2+2*x^2*y,3500],[-x^-1*y^4+2*x*y^2-x^2*y,3949],[-x*y^3+
2*x^2*y^2-y^4,3937],[1,4,51,171,1083,1300,1306,2746,2914,3788,3973,4067],[x^-
2,3354],[x^-1,596,684,777,1276,2741,2752,2801,2872],[y^-1,3292],[x^-1*y,506,
593,1459,1786,4316],[x^-1*y^2,503],[x,187,272,410,884,1055,1070,1293,1310,
1370,1431,1501,1772,1784,1865,1880,2071,2078,2083,2166,2198,2320,2750,2880,
3078,3098,3103,3110,3274,3413,4090,4096,4172,4189,4478,4483,4490,4499],[y,93,
155,310,341,428,465,496,527,552,572,579,584,589,868,874,899,1022,1052,1117,
1241,1294,1298,1303,1334,1354,1365,1427,1504,1520,1644,1675,1702,1706,1773,
1799,1835,1862,1905,2028,2079,2141,2240,2296,2389,2451,2513,2606,2668,2699,
2734,2762,2948,2979,3010,3134,3165,3289,3329,3475,3491,3506,3537,3600,3631,
3662,3724,3755,3879,3941,4251,4282,4286,4344,4375,4437,4468],[x*y^-1,591],
[x*y,582,803,870,930,1208,1500,1518,1583,1696,1738,1920,2283,2491,2504,2572,
2634,3393,3419,3461,3903,4027,4084,4088,4093,4218],[x*y^2,731,1416,1422,1684,
2585,4080,4261,4274],[x*y^3,1669,1680,1686,3521,4353,4355],[x*y^5,4419],[x^2,
676,876,877,882,1068,1253,1308,1368,1777,1878,2294,3008,3108,3200,3277,4083,
4100,4488],[y^2,494,761,1290,1350,1356,1362,1419,1539,2435,2730,2736,4283,
4299],[x^2*y,664,773,1233,1700,3466,3488],[x^2*y^2,660,666,4354],[x^2*y^4,
1746,1752],[x^3,680,1244,2287,4098],[y^3,4279,4366],[x^3*y,743,751,764,1242,
3455,3470,3557],[x^3*y^2,723,826,1760,2644,3533,4431],[x^3*y^3,1739,2640],
[x^4,1237,1761],[x^4*y,734],[x^4*y^2,732,815,830,1719,3511,3524],[x^5,2654],
[x^5*y,727,2646,2652],[x^6,2647],[x*y^3-3*x^2*y^2+x^3*y+y^4,3948],[x*y-2*x^2,
3014],[x*y^2-2*x^2*y,3494],[x^2*y^4-2*x^4*y^2,1715],[x*y^3-2*x^2*y^2-3*x^3*y-
x^4,4370],[x*y^4-2*x^2*y^3-2*x^3*y^2-x^4*y,4323],[x*y^3-2*x^2*y^2-x^3*y,3480],
[x*y^4-2*x^3*y^2-x^4*y,4368],[1-x^-1*y,3011],[x^-1*y^3-y^2,3946],[x-y,872,879,
1295,1355,1771,2735,3016],[x*y-x^2,2285,3001,3002,3009,3395,4081],[x*y-y^2,
3496],[x*y^2-x^2*y,1681,3000,3481,3482,3489],[x*y^2-x^3,3006,3012],[x*y^2-y^3,
3939],[x*y^3-x^3*y,3492,4260,4358,4363],[x*y^4-x^2*y^3,4325,4340,4349],[x*y^4-
x^3*y^2,4328,4333],[x*y^4-y^5,4426],[x*y^6-x^2*y^5,4410],[x^2-y^2,3335,3409],
[x^2*y-x^3,661,1235],[x^2*y-y^3,4346,4382],[x^2*y^2-y^4,3942,4343],[x^2*y^3-
x^4*y,4469],[x^3*y^2-x^4*y,725,2641],[x^3*y^2-x^5,1625],[x*y^3-x^2*y^2-
2*x^3*y,3486],[x^2*y^3-x^3*y^2-2*x^4*y-x^5,1741],[x*y^3-x^2*y^2-y^4,3930],
[x*y^6-x^3*y^4-x^4*y^3,4422],[x*y^5-x^2*y^4-x^4*y^2-x^5*y,4411,4424],[x^-
1*y^3-x*y-x^2+2*y^2,4309],[x^-1*y^3-x*y+y^2,4396],[x*y-x^2+y^2,1788],[x*y^2-
x^2*y+y^3,4383,4385],[x*y^2-x^2*y+x^3-y^3,3931],[x*y^5-x^2*y^4+x^3*y^3+
x^4*y^2,4412],[1+x^-1*y,3352],[1+x*y^-1,3202],[x^-1*y^2+y,4313],[x+y,0,186,
248,279,372,403,651,682,775,806,931,962,993,1210,1396,1489,1551,1613,1737,
1924,1955,2172,2203,2265,2327,2358,2420,2575,2637,2886,2917,3041,3196,3258,
3346,3382,3444,3568,3599,3848,3910,4003,4034,4127,4220],[x+x^2*y^-1,501],[x*y+
x^2,1734,3184,3350],[x*y+y^2,482,489,576,577,1672,3162,3334],[x*y^2+x^2*y,
2145,2497,4262,4269],[x*y^2+y^3,486,487,3330,3336,4393,4409],[x*y^3+x^2*y^2,
2586,2592,4379],[x*y^4+x^2*y^3,1759],[x^2+x^3*y^-1,3288],[x^2*y+x^3,1249,
1751],[x^2*y^2+x^3*y,769,1732],[x^2*y^3+x^3*y^2,4444],[x^2*y^4+x^3*y^3,1713],
[x^3*y+x^4,1643],[x^3*y^2+x^4*y,739,756,1623,3421,4454],[x^3*y^3+x^4*y^2,814,
3529,4440],[x^3*y^4+x^4*y^3,810,3528],[x^4*y+x^5,1634],[x^4*y^2+x^5*y,1632,
4446,4447,4452],[x^5*y+x^6,1627],[x*y^5+x^2*y^4-3*x^3*y^3+x^5*y,4338],[x*y^2+
x^2*y-2*x^3,3007],[x*y^3+x^2*y^2-2*x^3*y,3487],[x*y^2+x^2*y-x^3,3408],
[x^3*y^3+x^4*y^2-x^5*y,1724],[x*y^3+x^2*y^2+x^3*y,4272],[x^2*y^4+x^3*y^3+
x^4*y^2,813,1740],[x^3*y^3+x^4*y^2+x^5*y,1747],[x*y+x^2+y^2+x^3*y^-1,4291],
[x*y^2+x^2*y+x^3+y^3,4290],[x*y+2*x^2,2748],[x^2*y^2+2*x^3*y,1698],[x^3*y+
2*x^4,678],[x*y^6+2*x^2*y^5-2*x^3*y^4-2*x^4*y^3-x^5*y^2,4417],[x*y+2*x^2-y^2,
4310],[x*y^3+2*x^2*y^2+x^3*y,765],[x^2*y^3+2*x^3*y^2+x^4*y,762],[x^2*y^4+
2*x^3*y^3+x^4*y^2,4425],[x^3*y^2+2*x^4*y+x^5,757,1639],[x^3*y^3+2*x^4*y^2+
x^5*y,1725],[x*y^4+2*x^2*y^3+2*x^3*y^2+x^4*y,1726],[x^2*y^3+2*x^3*y^2+2*x^4*y+
x^5,1744],[x^3*y^4+2*x^4*y^3+2*x^5*y^2+2*x^6*y,1728],[x*y^3+3*x^2*y^2+x^3*y,
4267],[x^3*y^3+3*x^4*y^2+x^5*y,1712],[x*y^2+3*x^2*y+2*x^3,3348],[2*x^2*y^2-
2*y^4,3936],[2*x^2*y-y^3,4394],[2*x*y^2-x^2*y-y^3,3932,3944],[2*x^2*y^3-x^4*y-
y^5,4339],[2*x*y+x^2,4294],[2*x*y^2+y^3,4302],[2*x^3*y^2+x^4*y,1743],[2*x*y^6+
x^2*y^5-2*x^3*y^4-2*x^4*y^3,4416],[2*x*y^3+2*x^2*y^2+x^3*y,4266],[2*x^2*y+
3*x^3+x^4*y^-1,3198],[2*x^3*y^2+3*x^4*y+x^5,3468],[2*x^4*y^3+3*x^5*y^2+x^6*y,
828],[3*x*y^3-2*x^3*y+y^4,4398],[3*x*y^2+x^2*y-x^3+y^3,4297],[3*x*y^2+2*y^3,
4296]])*x^0*y^0;end;
  f23:=function(x,y,j) return dec(30,[[-2*x*y^2-j^2*x^2*y+(-j^2+j)*x^3-y^3,
1074],[-1,710,930,1481,1668,1761,1983,2014,2075,2264,2310,2480,2757,2822,3222,
3844,4290],[-y,14,49,153,276,340,525,556,742,805,867,1330,1516,1703,2543,3006,
3039,3343,4090,4151,4214,4275,4337,4369,4381,4469],[-x*y,1981,2095,2101,2306,
2659],[-x*y^2,1891,1975,2191,2215],[-y^2,1299,3559],[-x^2*y,963],[-x*y^2-
2*x^2*y-x^3,967],[-x^3*y^2-2*x^4*y-x^5,2782,2784],[-1-x^-1*y,994],[-x*y-x^2,
102,1027,3084],[-x*y^2-x^2*y,2805,2874],[-x^2*y-x^3,968],[-x^3*y-x^4,2842,
2844],[-x*y-j*y^2,2870],[-x*y^2-j*x^2*y,1007],[-x*y-j^2*x^2-y^2,1284],[-x*y^2-
j^2*x^2*y-y^3,1134],[-x*y^2+j*y^3,1951],[x^-1,992],[x,62,95,124,189,217,248,
311,403,420,467,498,571,651,684,776,838,1024,1055,1086,1148,1214,1272,1365,
1400,1582,1616,1737,1862,2110,2141,2172,2203,2296,2358,2514,2637,2668,2699,
2700,2793,2855,2890,2917,2948,2981,3111,3134,3196,3258,3656,3662,3693,3755,
3786,3879,3916,3948,4003,4040,4072,4134,4195,4498],[y,1367,1427,1584,1644,
1831,2389,2575,2606,2900,3020,3140,3200,3320,3413],[x*y^-1,1183,3298],[x*y,
623,901,1249,1465,1558,1817,1896,1927,1959,2235,2422,2764,3077,3511,3623,
3728],[x^2,2006,2611],[y^2,1277,2089,2149,2365,2723],[x^2*y,1916,2216,2431,
2449],[y^3,1127,1969,2209],[x+y,0,31,155,279,341,372,527,558,713,744,806,837,
931,993,997,998,1303,1334,1489,1520,1551,1675,1706,1799,1800,1986,2017,2018,
2048,2079,2082,2114,2130,2234,2300,2420,2513,2824,3010,3041,3165,3227,3351,
3382,3444,3537,3568,3817,3847,3848,3972,4096,4158,4220,4282,4313,4344,4375,
4406,4499],[x*y+x^2,658,964,1962,2115,2147,2302,2364,2457,3118],[x*y+y^2,657,
2363,2458,3762,4259],[x*y^2+y^3,1868,3349,3667],[x^2+x^3*y^-1,3852],[x^2*y+
x^3,132,2812],[x^2*y^2+x^3*y,2835],[x^2*y+2*x^3+x^4*y^-1,3732],[x^2*y^2+
2*x^3*y+x^4,72,3672],[x^2*y^3+2*x^3*y^2+x^4*y,2775],[x*y^4+2*x^2*y^3+(-j^2-
2*j)*x^3*y^2-j*x^4*y-j^2*y^5,1879],[x*y^3+(-j^2-2*j)*x^2*y^2-2*j*x^3*y-j*x^4-
j^2*y^4,1939],[x*y+(-2*j^2-j)*x^2,2096],[x*y^2-j*x^2*y-x^3+y^3,1164],[x^2*y+
j^2*x^3,2963],[x^2*y+j*x^3,1014],[2*x*y+x^2+y^2,1928,3727],[-2*j*x*y-j*x^2-
j*y^2,1041],[-2*j*x*y^2-j*x^2*y-j*y^3,147,981,1948,3749],[-2*j*x*y^3-
j*x^2*y^2-j*y^4,87,1888,2839,3689],[-2*j*x*y^4-j*x^2*y^3-j*y^5,2779],[(-2*j^2-
j)*x^2*y^2+j^2*x^3*y+j^2*x^4,2843],[(-2*j^2-j)*x^2*y^3+2*j^2*x^3*y^2+
2*j^2*x^4*y,2783],[-j,3179,3290,3470],[-j*y,389,2753,2990,3050,3260,3385,3446,
3503,3560,3987],[-j*x^2,1104,1194,1727],[-j*y^2,2665,2689,3110],[-j*x^2*y,
1314,1547],[-j*x^2*y+y^3,1067],[-j*x*y^4-3*j*x^2*y^3+j^2*x^3*y^2+j*x^4*y-
j^2*x^5+y^5,977],[-j*x*y^2-2*j*x^2*y-j*x^3,148,1048,1947],[-j*x*y^3-
2*j*x^2*y^2-j*x^3*y,88,988,1887],[-j*x^2*y^2-2*j*x^3*y-j*x^4,89,3687],[-
j*x*y^3+(j^2-2*j)*x^2*y^2+(2*j^2+j)*x^3*y+j*x^4+y^4-j^2*x^5*y^-1,1037],[-j*x-
j*y,1161,3175,3236],[-j*x*y-j*x^2,268,1168,2067],[-j*x*y-j*y^2,179,267,2068,
3777,3869],[-j*x*y^2-j*y^3,2959],[-j*x^2*y-j*x^3,149,3747],[-j*x^2*y^2-
j*x^3*y,2789],[-j*x^2*y^3-j*x^3*y^2,2785],[-j*x*y^2-j*x^2*y-j*x^3,2059],[(j^2-
j)*x*y^2-j^2*x^2*y+j*x^3+j^2*y^3,1976],[-j^2,1777,3170,3380],[-j^2*y,2269,
2311,2438,2485,2546,3233,3443,4237],[-j^2*x*y,1734],[-j^2*x*y^2,1554],[-
j^2*x^2,2005],[-j^2*y^2,2161],[-j^2*x^2*y,1915,2933],[-j^2*y^3,2029],[-
j^2*x*y-j*x^2-j^2*y^2,1794],[-j^2*x*y-j^2*x^2,3592],[-j^2*x*y^2-j^2*x^2*y-
j*x^3,2036],[-j^2*x*y^3-j^2*x^2*y^2+(j^2-j)*x^3*y+j^2*x^4,1946],[-j^2*x*y^4-
j^2*x^2*y^3+(2*j^2-j)*x^3*y^2+j^2*x^4*y+j*x^5,1886],[-j^2*x*y^2-j^2*x^2*y-
j^2*y^3,2065],[j^2*x,882,2516,3472,3504,4422],[j^2*x*y,1801,1999,2119,2239,
2305,2425,2930,3083,3585],[j^2*x*y^2,1909,2011],[j^2*y^2,1764,1787],[j^2*x^3,
2066],[j^2*x*y+x^2,2810],[j^2*x*y^2+(-j^2-2*j)*x^2*y+j*y^3,2873],[j^2*x*y^2+
j^2*x^2*y-x^3-j^2*x^4*y^-1,1157],[j^2*x*y+j*x^2+j^2*y^2,2186],[j^2*x*y^2+
j*x^2*y+j^2*y^3,2035],[j^2*x*y^3+j*x^4+j*x^5*y^-1,1921],[j^2*x*y^4+j*x^4*y+
j*x^5,1861],[j*x,947,1487,1614,1674,1704,2061,3590,3831],[j*x*y,917,1097,1139,
1187,1217,1247,1337,1404,1464,1524,1757,2636,2903,3023,3203,3350,3533],
[j*x*y^2,1307,2455,2456,3113,3353],[j*x^4*y^-1,2041],[j*x*y^2+x^2*y,2813],
[j*x*y+x^2+j*y^2,2695],[j*x*y^3-2*j^2*x^2*y^2+j^2*x^4-j^2*y^4,2780],[j*x*y-
j^2*y^2,2993,3053,3263],[j*x*y-j^2*x^2-j^2*y^2,2960],[j*x*y^2-j^2*x^2*y-
j^2*y^3,2840],[j*x*y+j*x^2,1941,2039,2819,3741,3838],[j*x*y+j*y^2,2968],
[j*x*y^2+j*x^2*y,1049,1881,2815,2876,3681],[j*x*y^3+j*x^2*y^2,989],[j*x^2*y+
j*x^3,1949,3748],[j*x^3*y^2+j*x^4*y,2786],[j*x^2*y^2+j*x^3*y+j*x^4,1945],
[j*x^2*y^3+(2*j^2+j)*x^3*y^2-x^4*y+j*x^5,1885],[j*x^2*y^2+(j^2+2*j)*x^3*y-
j^2*x^4,1044],[j*x^2*y^3+(3*j^2+5*j)*x^3*y^2+j*x^4*y+(-2*j^2-j)*x^5,984],
[(2*j^2+j)*x*y-y^2,2071,2131,2366],[2*j*x*y^2+j*x^2*y+j*y^3,2848],[2*j*x*y^3+
j*x^2*y^2+j*y^4,2788]])*x^0*y^0;end;
  f27:=function(x,y,j) return dec(40,[[-3*x*y^2-3*x^2*y-x^3-y^3,3184],[-
3*x*y^4+(2*j^2+3*j)*x^2*y^3+j*x^3*y^2-y^5,3179],[-3*x*y^4+(3*j^2+4*j)*x^2*y^3+
(j^2+5*j)*x^3*y^2+3*j*x^4*y+j*x^5-y^5,3167],[-2*x*y^2-x^2*y,3723],[-2*x*y^2-
y^3,2761],[-2*x*y-x^2-y^2,3018,3144,4380,4386],[-2*x*y^2-x^2*y-y^3,3729,7827],
[-2*x*y^3-x^2*y^2-y^4,3139,7817,7972],[-2*x*y^3+j^2*x^2*y^2-j*x^3*y,7931],[-
2*x*y^4+j^2*x^2*y^3-j*x^3*y^2,7971],[-2*x*y^2+(j^2+2*j)*x^2*y+j*x^3-y^3,5527],
[-2*x*y^3+(j^2+2*j)*x^2*y^2+j*x^3*y-y^4,3172,7767],[-2*x*y^3+(j^2+
2*j)*x^2*y^2+2*j*x^3*y+j*x^4-y^4,3127],[-1,44,86,412,1031,1235,2302,2425,2752,
3287,3972,4639,5455,5492,5830,5852,6075,6614,6694,7187],[-x^-1,1981],[-y^-1,
2378],[-x^-1*y^4,3141],[-x^-1*y^5,3181],[-x,1047,1896,1924,2056,3240,3243,
3886,4008,4053,4055,4095,4178,4213,4673,4840,4842,4966,5207,5335,5571,5695,
5932,5988,7332,7711,7738,7864],[-y,80,219,300,457,460,549,587,628,1810,1961,
1962,2368,2648,3203,3386,3451,3607,4221,4294,4381,4929,5245,5485,5499,5734,
5747,5813,5822,6442,6566,6685,6691,6726,6935,7217,7422,7451,7588],[-x*y,640,
1598,2127,2332,2990,3112,3197,3640,3641,3642,3880,3881,3882,4045,4051,4088,
4091,4204,4216,4220,4226,4328,4330,4469,4667,4750,5300,5325,5331,5686,5804,
5939,5977,6147,6178,6232,6255,6927,7571,7693,7705,7709],[-x*y^2,728,980,986,
6048,6215,6222,6248,6920,7611,7616,7685,7728],[-x*y^3,6211,7925,7936],[-x^2,
4047,4207,4326,5327,5687,5811,5816,7016],[-y^2,732,972,2528,3032,4285,4543,
6069,6560,6720,6721,6722,7443,7832],[-x^2*y,1447,2443,6016],[-x^2*y^2,960,963,
1366,4566,6042,7766],[-x^2*y^3,1360,1362],[-y^3,7128,7815,7822,7991],[-
x^3*y^2,6281],[-y^4,1380],[-x*y^2-2*y^3,1328],[-x*y^2-2*x^2*y-x^3,4289,4369],
[-x*y^3-2*x^2*y^2-x^3*y,3020,3026],[-x*y^4-2*x^2*y^3-x^3*y^2,7966],[-x^2*y^3-
2*x^3*y^2-x^4*y,7929],[-x*y^3-2*x^2*y^2+j^2*x^3*y,6040],[-x-y,2772,2824,3034,
3118,3249,5544,5812],[-x*y-x^2,2984,3098,3198,4578,5979],[-x*y-y^2,1334,1347,
2764,2770,2812,3150,5817,5819,7784],[-x*y^2-x^2*y,1326,4361,4362,5643,5649,
5680,6046,6096,6246,6247,7699,7814],[-x*y^2-y^3,2819,3132,3769,7932,7934],[-
x*y^3-x^2*y^2,969,1320,1322,2979,3006,6240,7805,7819,7926],[-x*y^3-y^4,2801,
7974],[-x^2*y^2-x^3*y,1487,4580,4586,6080,7946],[-x*y-x^2-y^2,4300,4306,5805],
[-x*y^2-x^2*y-y^3,2682],[-x*y^3-x^2*y^2-j^2*x^3*y,4443],[-x*y^2-x^2*y+j*x^3,
5767,7847],[-x*y^2+x^2*y+x^3-y^3,3190],[-x*y^4-2*j*x^2*y^3-4*j*x^3*y^2-
3*j*x^4*y-j*x^5-y^5,3176],[-x*y-j*x^2,888],[-x*y^2-j*x^2*y,7648],[-x*y^4-
j*x^2*y^3,7801],[-x^2*y^3-j*x^3*y^2,6201],[-x*y^3-j*x^2*y^2-2*j*x^3*y-j*x^4-
y^4,3136],[-x*y^4-j*x^2*y^3-j*x^3*y^2-y^5,7965],[-x^2*y^3+(j^2-j)*x^3*y^2-
2*j*x^4*y+x^5,7880],[-x^2*y^2-j^2*x^3*y,4440],[-x*y^3-j^2*x^2*y^2-j^2*x^3*y,
4568],[-x*y^2+j^2*x^2*y,4202,4323,7901],[-x*y^3+j^2*x^2*y^2+(j^2-j)*x^3*y-
j*x^4,2976],[-x^2*y^3+2*j^2*x^3*y^2+(j^2-j)*x^4*y,4560],[-x*y+j*x^2,5980],[-
x*y^2+j*x^2*y,7700],[-x^3*y+j*x^4,7896],[-x*y^2+j*x^2*y+j*x^3,4083],[-x^2*y^2+
j*x^3*y+j*x^4,2967],[-x*y^2+j*x^2*y+j*x^3-y^3,2807],[-x*y^2+(2*j^2+j)*x^2*y,
4320],[-x*y^4+(2*j^2+j)*x^2*y^3-x^3*y^2,7800],[-x^2*y^3+(2*j^2+j)*x^3*y^2+
(j^2-j)*x^4*y+j^2*x^5,7882],[-x^2*y^3+(2*j^2+j)*x^3*y^2+j^2*x^4*y,4569,7881],
[-x^2*y^3+(2*j^2+j)*x^3*y^2+2*j^2*x^4*y+j^2*x^5,4562],[-x*y^4+(2*j^2+
j)*x^2*y^3+3*j^2*x^3*y^2+3*j^2*x^4*y+j^2*x^5,3002],[-x*y^4+(3*j^2+j)*x^2*y^3+
(3*j^2-j)*x^3*y^2+(j^2-j)*x^4*y,3000],[-x*y^2+(j^2+2*j)*x^2*y+j*x^3-y^3,7367],
[-x*y^4+(3*j^2+2*j)*x^2*y^3+(3*j^2+j)*x^3*y^2+j^2*x^4*y,3009],[1,84,292,652,
912,1559,1893,2053,2055,2098,2372,2553,2653,2665,2713,2791,2834,3119,3247,
3291,4438,5554,5612,6814],[x^-1,1741],[x^-1*y,2661],[x,328,492,697,765,820,
943,1094,1135,1173,1312,1641,1682,1960,2005,2047,2215,2647,2871,2953,3280,
3320,3490,3569,3888,4244,4800,4882,5011,5087,5163,5374,5577,5580,5815,5907,
6400,6481,6523,6646,6851,7013,7100,7261,7305,7549],[y,0,123,287,369,408,410,
451,659,738,861,895,902,908,984,1353,1394,1476,1517,1600,1601,1602,1768,1846,
1885,2045,2051,2174,2364,2379,2543,2584,2644,2656,2660,2666,2707,2789,3035,
3076,3158,3457,3460,3540,3692,3741,3774,3944,4102,4143,4225,4303,4471,4512,
4556,4594,4717,4841,5044,5128,5210,5333,5661,5702,5743,5784,5989,6072,6112,
6153,6358,6399,6564,6687,6728,6760,6763,6769,6805,6810,6903,7056,7153,7396,
7457,7460,7466,7630,7672,7794,7835,7917,7958,7999],[x*y,161,240,241,242,1265,
1430,2497,2620,2908,3403,4084,4100,4106,4208,4795,5416,5684,5806,5971,6013,
6015,6022,6025,6231,6925,6931,6936,6965,7005,7499,7577,7732],[x*y^2,724,967,
2806,3022,6005,6011,6229,6260,6266,7607,7724],[x*y^3,721,7811],[x^2,1040,1043,
3963,4056,5336,5691,5696,5807,5843,7007],[y^2,897,1343,2130,2165,2170,2524,
4461,4534,6055,6062,6262,7143,7374,7613,7615,7622,7625,7655,7662,7668,7831],
[x^2*y,1460,1466,3102,5780,5786,5920,6007,6051,6251,6309,7696,7860,7866],
[x^2*y^2,2966,6243],[x^2*y^3,3083],[y^3,2973,7124,7365,7605,7657,7829,7933,
7935,7942,7945,7992],[x^3*y,1440,1443,5763,7843],[y^4,7982],[x*y^2-x^2*y-x^3,
4363],[x*y^4-x^3*y^2-x^4*y+y^5,7920],[1+x*y^-1,2778],[x+y,164,246,779,1066,
1107,1148,1189,1271,1435,1599,1887,1928,1963,1969,2010,2338,2365,2370,2461,
2502,2625,2773,2785,2818,2912,2994,3115,3154,3199,3283,3289,3323,3487,3651,
3733,3815,3897,3980,3986,4020,4184,4266,4348,4389,4676,4758,4799,4964,5005,
5169,5292,5456,5538,5579,5692,5860,5866,6030,6235,6317,6482,6934,6974,7015,
7097,7302,7343,7507,7548,7587,7712,7753,7876],[x*y+x^2,846,1049,2767,3195,
3969,4096,4324,4584,5849,6052,6092,7539],[x*y+y^2,2361,2525,2530,2768,2780,
3030,3138,3409,5697,5699,6068,6095,6108,6184,7627,7796],[x*y^2+x^2*y,840,841,
842,2820,2826,3800,3803,3809,4444,4572,5540,5546,5642,5800,6045,6059,6099,
6256,7380,7386,7725,7730,7908,7909],[x*y^2+y^3,6057,6257,7125,7130,7617,7619,
7620,7943],[x*y^3+x^2*y^2,3126,4579,6219,6249,7786],[x*y^4+x^2*y^3,3089,4561],
[x^2*y^2+x^3*y,1449,1500,1506,2980,2986,5523,5769,6299,7849],[x^2*y^3+x^3*y^2,
7763,7883],[x^3*y+x^4,6291],[x^3*y^2+x^4*y,1483,2963],[x*y+x^2+y^2,5685],
[x*y^2+x^2*y+y^3,4540,4546],[x*y^3+x^2*y^2+x^3*y,4642,6122,7600],[x*y^3+
x^2*y^2-j*x^3*y-j*x^4,4567],[x*y^2+x^2*y-j^2*y^3,3721],[x*y^3+x^2*y^2-
j^2*x^3*y,4442,4522],[x*y^3+2*y^4,1321],[x*y^3+2*x^2*y^2+x^3*y,3140,3146,5529,
7369],[x*y^4+2*x^2*y^3+x^3*y^2,7769],[x^2*y^3+2*x^3*y^2+x^4*y,1489,2969],
[x*y^4+2*x^2*y^3-j*x^3*y^2+j^2*x^4*y,3166],[x*y^4+3*x^2*y^3+3*x^3*y^2+x^4*y,
3180,3186],[x+(-j^2-2*j)*y,2645],[x*y+(-j^2-2*j)*y^2,2641],[x*y^3+(-j^2-
2*j)*x^2*y^2,4441],[x*y^3+(-2*j^2-j)*x^2*y^2-2*j^2*x^3*y-j^2*x^4,2802],[x*y^3+
(-2*j^2-j)*x^2*y^2-j^2*x^3*y,2809,4570],[x^2*y^3+(-2*j^2-j)*x^3*y^2-j^2*x^4*y,
2960],[x*y^3+(-2*j^2-j)*x^2*y^2+(-j^2+j)*x^3*y+j*x^4,4565],[x-j*y,2650],
[x*y^3-j*x^2*y^2,6220],[x^2*y-j*x^3,7893,7895],[x^2*y^2-j*x^3*y,6300],[x*y^4-
j*x^2*y^3+y^5,3001],[x*y^2-j*x^2*y-j*x^3,4203],[x*y^3-j*x^2*y^2+j^2*x^3*y,
4564],[x*y^3-2*j^2*x^2*y^2+(-j^2+j)*x^3*y,2800],[x*y^2-j^2*x^2*y,7560],[x*y^3-
j^2*x^2*y^2-j^2*x^3*y,7927],[x*y^2-j^2*x^2*y+j*x^3,4082],[x*y+j*x^2,884],
[x*y^2+j*x^2*y,881,7644],[x*y^3+j*x^2*y^2,6041,7641],[x^2*y^2+j*x^3*y,7681],
[x^2*y^2+j*x^4,7891],[x*y^5+j*x^2*y^4-2*x^3*y^3-2*x^4*y^2-x^5*y+y^6,7960],
[x*y^2+j*x^2*y+j*x^3,1492],[2*x*y^3-x^3*y+y^4,7940],[2*x*y^2+x^2*y,6044,6244],
[2*x*y+x^2+y^2,3024,3110,3194],[2*x*y^2+x^2*y+y^3,3012,3178],[2*x*y^3+x^2*y^2+
y^4,3019,7983],[2*x*y^2+x^2*y+2*y^3,1324],[2*x*y^3+2*x^2*y^2,7780],[2*x*y^3+
2*x^2*y^2+x^3*y,7721],[2*x*y^3+(-j^2-2*j)*x^2*y^2-2*j*x^3*y-j*x^4+y^4,3007],
[2*x*y^3-j^2*x^2*y^2+j*x^3*y+y^4,7937],[3*x*y^3+4*x^2*y^2+2*x^3*y+y^4,4529],
[3*x*y^4+(-3*j^2-2*j)*x^2*y^3+(-j^2+j)*x^3*y^2+j*x^4*y+y^5,7977],[-3*j*x*y^2-
3*j*x^2*y-j*x^3+j^2*y^3,3015],[(-3*j^2-2*j)*x*y^4+2*x^2*y^3-x^3*y^2-x^4*y,
7980],[(-j^2-2*j)*x*y^2+x^2*y,4081],[(-j^2-2*j)*x*y+x^2-j*y^2,4379],[(-j^2-
2*j)*x*y^3+2*x^2*y^2+2*x^3*y-y^4,4520],[(-j^2-2*j)*x*y^4+2*x^2*y^3+(-j^2+
j)*x^3*y^2+j*x^4*y,3120],[(-j^2-2*j)*x*y^5+3*x^2*y^4-3*j^2*x^3*y^3+
2*j*x^4*y^2+j*x^5*y,3160],[(-j^2-2*j)*x*y^5+(-4*j^2-5*j)*x^2*y^4+4*x^3*y^3+
x^4*y^2,3169],[(-j^2-2*j)*x*y^4+(-2*j^2-3*j)*x^2*y^3+x^3*y^2,3129],[(-j^2-
2*j)*x*y^3+(-j^2-2*j)*x^2*y^2,7777],[(-j^2-2*j)*x*y^2+(-j^2-2*j)*x^2*y+y^3,
6245],[(-j^2-2*j)*x*y^2-2*j*x^2*y-j*x^3+2*y^3,2521],[(-j^2-2*j)*x*y^3-
2*j*x^2*y^2-j*x^3*y+2*y^4,7121],[-2*j*x*y^2-j*x^2*y+j^2*y^3,3028],[(-2*j^2-
j)*x*y^3+(-3*j^2-2*j)*x^2*y^2+2*x^3*y,4523],[(-2*j^2-j)*x^2*y^4-3*j^2*x^3*y^3-
4*j^2*x^4*y^2-3*j^2*x^5*y-j^2*x^6-y^6,3162],[(-2*j^2-j)*x^2*y^3-2*j^2*x^3*y^2-
2*j^2*x^4*y-j^2*x^5-y^5,3122],[(-2*j^2-j)*x*y^3-2*j^2*x^2*y^2-j^2*x^3*y+y^4,
3010],[(-2*j^2-j)*x*y-j^2*x^2+y^2,4367],[(-2*j^2-j)*x*y^3+(-2*j^2+j)*x^2*y^2+
(-j^2+2*j)*x^3*y+j*x^4+y^4,3005],[(-2*j^2-j)*x*y^3+(-j^2+j)*x^2*y^2+j*x^3*y,
3017],[-j,3285,3296,3855,6821],[-j*x,1045,1056,3071,3411,3773,3977,4309,5857],
[-j*y,2181,3781],[-j*x*y,2240,2243,2249,4340,4346,5928,5930,7567,7568,7570],[-
j*x*y^3,6241],[-j*x^2,2042,5200,5203,5209,5926,5967,5968,5970,7040,7524,7540],
[-j*y^2,4541,7381],[-j*x^2*y,1456,2120,2123,2129,4450,4456,5777,7690,7857],[-
j*x^2*y^2,3091,7602],[-j*x^3,5771,5802,7002,7851],[-j*x^3*y,6002],[-j*x*y+x^2,
3960,4085,4090,5840],[-j*x*y^2+x^2*y,4466],[-j*x^2+y^2,6680],[-j*x^2*y^3+
x^3*y^2+(-2*j^2-j)*x^4*y-j^2*x^5,2962],[-j*x*y^3+x^2*y^2-2*j^2*x^3*y-j^2*x^4,
7362],[-j*x*y^2+x^2*y-j^2*x^3,3048],[-j*x^2*y^2+(-j^2-2*j)*x^3*y,7771],[-
j*x*y^3+(-j^2-2*j)*x^2*y^2+x^3*y,7899],[-j*x*y^2-2*j*x^2*y-j*x^3,2816,4575,
5525,5536,6084,7376],[-j*x*y^3-2*j*x^2*y^2-j*x^3*y,7765,7776,7939,7988],[-
j*x*y^3-2*j*x^2*y^2-j*x^3*y-y^4,7989],[-j*x*y^3+(j^2-2*j)*x^2*y^2+j^2*x^3*y+
y^4,3004],[-j*x-j*y,644,2541,3405,3416,3735,3775,4308,4372,4388],[-j*x*y-
j*x^2,3062,3065,3727,3767,3840,3843,3849,4291,4299,4371,6683,7043],[-j*x*y-
j*y^2,7141],[-j*x*y^2-j*x^2*y,3057,3060,4537,4588,5537,7377,7892,7948,7949],[-
j*x*y^3-j*x^2*y^2,1377,2968,3096,7361],[-j*x^2*y-j*x^3,4200,4209,5531,5765,
5776,7845,7856],[-j*x^2*y^2-j*x^3*y,1496,7884,7973],[-j*x^3*y^2-j*x^4*y,1480,
3082],[-j*x*y-j*x^2+y^2,6801,6802],[-j*x*y^2-j*x^2*y+y^3,1457,2161,2162],[-
j*x*y^4-j*x^2*y^3+y^5,3123],[-j*x^2*y-j*x^3+y^3,7371],[-j*x^2*y^2-j*x^3*y+y^4,
7975],[-j*x*y^5-j*x^2*y^4+x^3*y^3+y^6,3163],[-j*x*y^2-j*x^2*y+(-j^2-2*j)*y^3,
4525],[-j*x*y^2-j*x^2*y-j*y^3,4536],[-j*x*y^2-j*x^2*y-j^2*y^3,3761],[-j*x*y^5-
j*x^2*y^4+(2*j^2+j)*x^3*y^3-2*x^4*y^2-x^5*y+y^6,7963],[-j*x*y^2+(j^2-j)*x^2*y+
j^2*x^3,3722],[-j*x*y^4+(j^2-j)*x^2*y^3+(2*j^2+j)*x^3*y^2-x^4*y+y^5,7923],[-
j*x^2*y-j^2*y^3,4445],[-j*x*y^4-j^2*x^2*y^3+(-2*j^2-j)*x^3*y^2+x^4*y,7967],[-
j*x*y^4-j^2*x^2*y^3-2*j^2*x^3*y^2-j^2*x^4*y,7970],[-j*x*y^2+j^2*x^2*y-x^3+y^3,
4283],[(j^2-j)*x*y^4+(3*j^2-2*j)*x^2*y^3+(2*j^2-j)*x^3*y^2+y^5,3168],[(j^2-
j)*x*y^3+(j^2-j)*x^2*y^2+y^4,3128],[(j^2-j)*x*y^2+(j^2-j)*x^2*y+j^2*x^3,3762],
[(j^2-j)*x*y^3+(j^2-j)*x^2*y^2+j^2*y^4,4521],[-2*j^2*x*y-j^2*x^2,4368,4370],[-
j^2,3250],[-j^2*x,3282,3964,4332,5844],[-j^2*y,647,852,854,867,3241,4383],[-
j^2*x*y,1512,3400,4339,5647,5940,5946,7580,7586],[-j^2*x*y^2,970,4447],[-
j^2*x*y^3,961,1441],[-j^2*x^2,1042,5986,6316],[-j^2*y^2,845,859,3730,3765,
3770,4454,4467],[-j^2*x^2*y,5764,5923,7563,7706,7844,7902,7905],[-j^2*x^2*y^2,
3097],[-j^2*x^3,5960,5963],[-j^2*x^3*y,1442,5760,6288,7680,7683,7840],[-
j^2*x*y^4-x^2*y^3-2*x^3*y^2-x^4*y,7986],[-j^2*x*y^4-x^2*y^3+2*j^2*x^3*y^2+
j^2*x^4*y,7964],[-j^2*x*y+y^2,2642],[-j^2*x*y^2+x^3,5640],[-j^2*x^2*y^2-
2*j^2*x^3*y-j^2*x^4,1484,5522],[-j^2*x^2*y^3-2*j^2*x^3*y^2-j^2*x^4*y,7762],[-
j^2*x*y-j^2*x^2,3402,4288,4290],[-j^2*x*y-j^2*y^2,4452,6252],[-j^2*x*y^2-
j^2*x^2*y,1444,1495,1508,3092,4524,5524,5929,6087,7364,7569],[-j^2*x*y^2-
j^2*y^3,6259],[-j^2*x*y^3-j^2*x^2*y^2,1364,3099,7764],[-j^2*x^2*y-j^2*x^3,
5969],[-j^2*x^2*y^2-j^2*x^3*y,2803,5520,7689,7928,7930],[-j^2*x^2*y^3-
j^2*x^3*y^2,7760],[-j^2*x^3*y-j^2*x^4,5762,7842],[-j^2*x*y-j^2*x^2+y^2,4287],
[-j^2*x*y^2-j^2*x^2*y+y^3,4531],[-j^2*x*y^3-j^2*x^2*y^2+x^3*y,3084],[-j^2*x*y-
j^2*x^2-j^2*y^2,3725],[-j^2*x*y^3+(-2*j^2+j)*x^2*y^2-j^2*x^3*y-y^4,3008],[-
j^2*x^2*y^2+(-j^2+j)*x^3*y+j*x^4,3011],[-j^2*x*y^3+j*x^2*y^2,7808],[-
j^2*x*y^4+j*x^2*y^3,1361],[-j^2*x^2*y+j*x^3,7684],[-j^2*x^2*y^2+j*x^3*y,4577,
6208],[-j^2*x^3*y+j*x^4,4571],[-j^2*x*y^5+j*x^2*y^4-3*x^3*y^3-3*x^4*y^2-x^5*y,
7969],[-j^2*x*y^5+(j^2+4*j)*x^2*y^4+(j^2+2*j)*x^3*y^3,7961],[j^2,1976,3290],
[j^2*x,1050,3242,3968,3970,5654,5848,5850],[j^2*y,660,666,863,3281,3410,4374,
4387],[j^2*x*y,643,1041,3816,5645,5651,5927],[j^2*x*y^2,4460,6250],[j^2*x*y^3,
7826],[j^2*x^2,7546],[j^2*y^2,3401,4365,4463],[j^2*x^2*y,1450,5768,5770,6060,
6066,6295,6302,7687,7848,7850],[j^2*x^2*y^2,962,6226],[j^2*x^2*y^3,7803],
[j^2*x^3,7520,7523],[j^2*x^3*y,6043,6284,6306],[j^2*x^3*y^2,3080,6200,6203],
[j^2*x^4*y,6280,6283],[j^2*x-y,3967,5847],[j^2*x*y^2-y^3,3760],[j^2*x*y^4+
x^2*y^3-2*j^2*x^3*y^2-j^2*x^4*y,7968],[j^2*x*y^4-3*j*x^2*y^3-3*j*x^3*y^2-
j*x^4*y-y^5,7979],[j^2*x^2*y^3+(2*j^2-2*j)*x^3*y^2+(j^2-2*j)*x^4*y-j*x^5,
3171],[j^2*x*y^2-j*x^2*y,2817,2982,3142],[j^2*x*y^3-j*x^2*y^2,1368,7804],
[j^2*x^2*y-j*x^3,2811,7688],[j^2*x^2*y^2-j*x^3*y,6204],[j^2*x^3*y-j*x^4,2971],
[j^2*x*y^3-j*x^2*y^2+j^2*x^3*y,7885],[j^2*x*y^2+(j^2-j)*x^2*y-j*x^3,2522],
[j^2*x*y^3+(j^2-j)*x^2*y^2-j*x^3*y,2977,7122],[j^2*x^2*y^2+(j^2-j)*x^3*y-
j*x^4,3131],[j^2*x^2*y^2+(j^2-j)*x^3*y-j*x^4+y^4,2965],[j^2*x*y^3-j^2*x^3*y,
4449],[j^2*x*y+j^2*x^2,4284],[j^2*x*y+j^2*y^2,649],[j^2*x*y^2+j^2*x^2*y,1448,
3720,4329,4528,5528,5530,6100,6106,7368,7370,7907],[j^2*x*y^3+j^2*x^2*y^2,
7768,7770],[j^2*x*y^4+j^2*x^2*y^3,7809],[j^2*x^2*y+j^2*x^3,7529],[j^2*x^2*y^2+
j^2*x^3*y,1488,1490,2970,3086,6049,6083,7906,7924],[j^2*x^2*y^3+j^2*x^3*y^2,
6209],[j^2*x^3*y+j^2*x^4,1486,7886],[j^2*x^3*y^2+j^2*x^4*y,4563,6289],
[j^2*x*y^2+j^2*x^2*y-x^3,7894],[j^2*x*y^2+j^2*x^2*y+y^3,2808],[j^2*x*y^3+
2*j^2*x^2*y^2+j^2*x^3*y,6089],[j^2*x^2*y^3+2*j^2*x^3*y^2+j^2*x^4*y,3003,7889],
[j^2*x*y^3+j*x^3*y,3088],[j^2*x*y^3+j*x^2*y^2+j*x^3*y,3090],[2*j^2*x*y^3+(j^2-
2*j)*x^2*y^2-j*x^3*y,3137],[2*j^2*x*y+j^2*x^2,4364],[2*j^2*x*y^2+2*j^2*x^2*y+
j^2*y^3,4530],[(-j^2+j)*x^2*y^2-j^2*x^3*y-y^4,7360],[(-j^2+j)*x*y^2+j*x^2*y-
j^2*y^3,3192],[j,3245,3256,3415,3988,5868,6701,7061],[j*x^-1*y,6277],[j*x,646,
3407,3971,5851],[j*y,648,650,4301],[j*x*y,1453,1469,4327,4549,5788,6803,7041,
7042,7389,7564,7868],[j*x*y^2,965,976,1445,2163],[j*x*y^3,7807,7810],[j*x^2,
5964,7527,7528,7530],[j*y^2,6269],[j*x^2*y,6047,6050,6922],[j*x^2*y^2,3087,
6207,6210],[j*x^2*y^3,3081],[j*x^3,4042,5322,5682],[j*x^3*y,6287,6290,7682],
[j*x*y-x^2,4210],[j*x*y^2-x^2*y-x^3+y^3,4280],[j*x*y^2-x^2*y-j^2*y^3,4459],
[j*x*y^2-x^2*y+j^2*x^3,3044],[j*x*y^3-x^2*y^2+j^2*x^3*y,3041],[j*x*y^4-
x^2*y^3+j^2*x^3*y^2,2961],[j*x*y^2-j^2*x^2*y,3095],[j*x*y^2-j^2*x^2*y-y^3,
2804],[j*x*y^3-j^2*x^2*y^2+x^3*y,7363],[j*x^2*y^2-j^2*x^3*y-j*x^4,7887],[j*x+
j*y,3072],[j*x*y+j*x^2,2640,2649,3731,3771,4297,4377,5775,5924,6681,6682,7373,
7855],[j*x*y+j*y^2,1455,1468,2828,2992,3068,3152,4548,5548,7388],[j*x*y^2+
j*x^2*y,1459,2523,4281,4282,4539,6088,6090,7379,7903],[j*x*y^2+j*y^3,1375,
1388,7788,7941],[j*x*y^3+j*x^2*y^2,7123],[j*x*y^3+j*y^4,7981],[j*x^2*y+j*x^3,
2760,2763,2769,4080,4089,6086],[j*x^2*y^2+j*x^3*y,1499,3085,6242,7888,7890,
7897],[j*x^3*y^2+j*x^4*y,7976],[j*x*y+j*x^2-y^2,2643],[j*x*y+j*x^2+j*y^2,
3776],[j*x*y^4+j*x^2*y^3+j*x^3*y^2,7922],[j*x*y^4+2*j*x^2*y^3+j*x^3*y^2,7921],
[j*x^2*y^2+2*j*x^3*y+j*x^4,4576],[j*x*y+(j^2+2*j)*y^2,3055],[j*x*y^3+(j^2+
2*j)*x^2*y^2,2964],[j*x*y^2+(j^2+2*j)*x^2*y-x^3,4360],[j*x*y^3+3*j*x^2*y^2+
3*j*x^3*y+j*x^4,3016],[j*x*y^5+(j^2+3*j)*x^2*y^4+(j^2+2*j)*x^3*y^3+
j^2*x^4*y^2+j^2*x^5*y,7962],[(2*j^2+j)*x*y^3-x^2*y^2,7820],[(2*j^2+j)*x*y^3+
(j^2-j)*x^2*y^2-2*j*x^3*y-j*x^4+j*y^4,3125],[(2*j^2+j)*x*y^2+(j^2-j)*x^2*y-
j*x^3-y^3,2805],[(2*j^2+j)*x*y^4+(2*j^2-j)*x^2*y^3+(j^2-3*j)*x^3*y^2-
3*j*x^4*y-j*x^5+j*y^5,3165],[(2*j^2+j)*x*y^2+j^2*x^2*y-y^3,2810],[(2*j^2+
j)*x*y^3+j^2*x^2*y^2-j*x^3*y,3182],[(2*j^2+j)*x*y^3+j^2*x^2*y^2+j*y^4,3130],
[(2*j^2+j)*x*y^4+3*j^2*x^2*y^3+j^2*x^3*y^2+j*y^5,3170],[(2*j^2+j)*x*y^2+
(2*j^2+j)*x^2*y-2*y^3,4527],[(3*j^2+j)*x*y^4+(3*j^2-j)*x^2*y^3+(j^2-
2*j)*x^3*y^2-j*x^4*y,3177],[2*j*x*y^2+(-j^2+j)*x^2*y+j*x^3+j*y^3,2975],
[2*j*x*y+j*x^2+j*y^2,2815,3736,5535,7375],[2*j*x*y^2+j*x^2*y+j*y^3,2988,7775],
[2*j*x*y^3+2*j*x^2*y^2-y^4,3124],[2*j*x*y^4+(-j^2+4*j)*x^2*y^3+(-2*j^2+
2*j)*x^3*y^2-j^2*x^4*y-y^5,3164],[(j^2+2*j)*x*y-x^2,4205],[(j^2+2*j)*x*y^2-
x^2*y,4201],[(j^2+2*j)*x*y^2+j*x^2*y-y^3,3763],[(j^2+2*j)*x*y^4+j*x^2*y^3+
(j^2+2*j)*y^5,3121],[(j^2+2*j)*x*y^5+2*j*x^2*y^4+(-j^2+j)*x^3*y^3+(j^2+
2*j)*y^6,3161],[3*j*x*y^2+j*x^2*y+2*j*y^3,3148],[(j^2+3*j)*x*y^2+2*j*x^2*y+
j*x^3+j*y^3,3135],[(-j^2+4*j)*x*y^3+(-j^2+3*j)*x^2*y^2+j*x^3*y+(-j^2+j)*y^4,
3188],[4*j*x*y^3+6*j*x^2*y^2+3*j*x^3*y+j*x^4-j^2*y^4,3175]])*x^0*y^0;end;
  rep:=[[f1,r],[f1,p],
  [f5,p,r,E(3)^2],[f5,r,p,E(3)^2],[f5,p,r,E(3)],[f5,r,p,E(3)],
  [f7,p,r],[f7,r,p],
  [f10,r,p,E(3)^2],[f10,p,r,E(3)^2],[f10,r,p,E(3)],[f10,p,r,E(3)],
  [f13,r,p],[f13,p,r],[f15,r,p],[f15,p,r],
  [f17,r,p],[f17,p,r],[f19,r,p],[f19,p,r],
  [f21,r,p],[f21,p,r],
  [f23,r,p,E(3)], [f23,p,r,E(3)], [f23,r,p,E(3)^2], [f23,p,r,E(3)^2],
  [f27,r,p,E(3)], [f27,p,r,E(3)], [f27,r,p,E(3)^2], [f27,p,r,E(3)^2]];
  if IsBound(rep[i]) then 
    return ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]})+0*Product(para[1]);
  else return false;fi;
end);

CHEVIE.AddData("Representation","G33",function(i)local r,f,expand;
  r:=CHEVIE.RawData("HeckeRepresentation","G33")(List([1..5],i->[1,-1]),[],i);
  if r<>false then return r;fi;
  f:=i->CHEVIE.RawData("Representation","G33")(i);
  expand:=function(l,n)local res;res:=[1..n]*0;res{l[1]}:=l[2];return res;end;
  if i=31 then return List(f(9),x->ExteriorPower(x,2));
  elif i=32 then return -f(31);
  elif i=33 then return ComplexConjugate(f(31));
  elif i=34 then return -f(33);
  elif i=35 then return List(
[[[[1,17],[-1,-1]],[[2,5],[-1,-1]],[[3,34],[-1,-1]],[[4,41],[-1,-1]],[[5],
[1]],[[12],[1]],[[13],[1]],[[8,16],[-1,-1]],[[14],[1]],[[10,36],[-1,-1]],[[32,
40],[-1,-1]],[[6],[1]],[[7],[1]],[[9],[1]],[[15,53],[-1,-1]],[[16],[1]],[[17],
[1]],[[28],[1]],[[29],[1]],[[21],[1]],[[20],[1]],[[22,50],[-1,-1]],[[30],[1]],
[[31],[1]],[[5,7,13,16,17,18,20,21,25,28,34,36,41,49,50,53,58,59],[1,-1,-1,1,
1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1]],[[32],[1]],[[27,49],[-1,-1]],[[18],[1]],
[[19],[1]],[[23],[1]],[[24],[1]],[[26],[1]],[[42],[1]],[[34],[1]],[[43],[1]],
[[36],[1]],[[37,59],[-1,-1]],[[44],[1]],[[39,58],[-1,-1]],[[11,26],[-1,-1]],
[[41],[1]],[[33],[1]],[[35],[1]],[[38],[1]],[[9,14,17,26,32,35,41,42,43,45,48,
50,54,55,57,59],[-1,-1,-1,-1,-1,-1,-1,1,-1,-1,-1,-1,-1,1,-1,-1]],[[5,7,11,13,
16,17,20,21,23,30,32,33,34,40,42,46,48,51,52,54],[-1,1,-1,1,-1,-1,1,1,-1,-1,1,
-1,-1,1,-1,-1,1,1,1,1]],[[2,4,5,7,8,14,15,16,20,22,23,24,26,28,32,33,34,35,39,
42,43,45,48,53,54,55,58,60],[-1,-1,-1,1,-1,1,-1,-1,1,-1,-1,-1,1,1,1,-1,-1,1,
-1,-1,1,1,1,-1,1,-1,-1,1]],[[54],[1]],[[49],[1]],[[50],[1]],[[52],[1]],[[51],
[1]],[[53],[1]],[[48],[1]],[[33,57],[-1,-1]],[[9,14,17,23,24,30,31,34,56,59],
[1,1,1,1,1,1,1,1,-1,1]],[[42,55],[-1,-1]],[[58],[1]],[[59],[1]],[[2,4,8,13,14,
15,17,18,21,22,30,31,34,39,45,47,55,59],[-1,-1,-1,-1,1,-1,1,-1,-1,-1,1,1,1,-1,
1,1,-1,1]]],[[[6,9],[-1,-1]],[[5],[1]],[[19,24],[-1,-1]],[[7,48],[-1,-1]],
[[2],[1]],[[1,17],[-1,-1]],[[4,41],[-1,-1]],[[16],[1]],[[17],[1]],[[10],[1]],
[[18],[1]],[[12,14],[-1,-1]],[[13,54],[-1,-1]],[[14],[1]],[[20,51],[-1,-1]],
[[8],[1]],[[9],[1]],[[11],[1]],[[3,34],[-1,-1]],[[15,53],[-1,-1]],[[21,52],
[-1,-1]],[[33],[1]],[[23],[1]],[[34],[1]],[[8,10,11,14,15,16,18,20,22,23,25,
32,33,39,41,42,45,46,48,51,52,54,55,59],[-1,-1,-1,1,-1,-1,-1,1,-1,-1,-1,1,-1,
-1,1,-1,1,-1,1,1,1,1,-1,1]],[[35],[1]],[[27],[1]],[[2,4,5,7,8,9,15,16,17,20,
22,23,24,28,33,34,39,41,50,53,57,58,59,60],[1,1,1,-1,1,1,1,1,1,-1,1,1,1,-1,1,
1,1,1,1,1,1,1,1,-1]],[[29,31],[-1,-1]],[[9,14,17,23,24,30,31,34,59],[-1,-1,-1,
-1,-1,-1,-1,-1,-1]],[[31],[1]],[[45],[1]],[[22],[1]],[[24],[1]],[[26],[1]],
[[10,36],[-1,-1]],[[37,59],[-1,-1]],[[23,38],[-1,-1]],[[46],[1]],[[47],[1]],
[[48],[1]],[[55],[1]],[[9,14,17,26,32,35,41,42,43,45,48,50,54,55,57,59],[-1,
-1,-1,-1,-1,-1,-1,1,-1,-1,-1,-1,-1,1,-1,-1]],[[56],[1]],[[32],[1]],[[39],[1]],
[[40],[1]],[[41],[1]],[[27,49],[-1,-1]],[[57],[1]],[[53],[1]],[[52],[1]],
[[51],[1]],[[54],[1]],[[42],[1]],[[44],[1]],[[50],[1]],[[46,60],[-1,-1]],
[[59],[1]],[[39,58],[-1,-1]]],[[[2],[1]],[[1],[1]],[[8],[1]],[[4,41],[-1,-1]],
[[17],[1]],[[6],[1]],[[21],[1]],[[3],[1]],[[6,9],[-1,-1]],[[22],[1]],[[23],
[1]],[[12],[1]],[[20],[1]],[[12,14],[-1,-1]],[[15,53],[-1,-1]],[[34],[1]],
[[5],[1]],[[18],[1]],[[19],[1]],[[13],[1]],[[7],[1]],[[10],[1]],[[11],[1]],
[[19,24],[-1,-1]],[[37],[1]],[[38],[1]],[[39],[1]],[[28],[1]],[[29],[1]],[[32,
40],[-1,-1]],[[29,31],[-1,-1]],[[44],[1]],[[33],[1]],[[16],[1]],[[18,35],[-1,
-1]],[[50],[1]],[[25],[1]],[[26],[1]],[[27],[1]],[[30,44],[-1,-1]],[[41],[1]],
[[42],[1]],[[28,43],[-1,-1]],[[32],[1]],[[3,8,10,11,12,13,16,18,20,22,23,25,
32,33,34,37,41,42,44,45,46,48,51,52,54],[1,1,1,1,1,-1,1,1,-1,1,1,1,-1,1,1,1,
-1,1,-1,-1,1,-1,-1,-1,-1]],[[46],[1]],[[1,2,5,7,17,21,25,27,28,29,32,36,37,39,
41,42,44,47,49,50,58],[1,1,1,-1,1,-1,-1,1,-1,1,1,1,-1,1,1,-1,1,-1,1,1,1]],
[[52],[1]],[[58],[1]],[[36],[1]],[[54],[1]],[[48],[1]],[[53],[1]],[[51],[1]],
[[42,55],[-1,-1]],[[12,13,19,20,25,37,42,46,51,54,56],[-1,1,-1,1,-1,-1,-1,-1,
1,1,-1]],[[33,57],[-1,-1]],[[49],[1]],[[5,7,13,16,17,18,20,21,28,34,36,41,49,
50,53,58,59],[-1,1,1,-1,-1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1]],[[46,60],[-1,
-1]]],[[[4,41],[-1,-1]],[[2,5],[-1,-1]],[[10],[1]],[[1,17],[-1,-1]],[[5],[1]],
[[11,26],[-1,-1]],[[18],[1]],[[25],[1]],[[26],[1]],[[3],[1]],[[6,9],[-1,-1]],
[[40],[1]],[[28],[1]],[[32],[1]],[[27,49],[-1,-1]],[[5,7,13,16,17,18,20,21,28,
34,36,41,49,50,53,58,59],[-1,1,1,-1,-1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1]],
[[41],[1]],[[7],[1]],[[24],[1]],[[20],[1]],[[21],[1]],[[37],[1]],[[38],[1]],
[[19],[1]],[[8],[1]],[[9],[1]],[[15,53],[-1,-1]],[[13],[1]],[[31],[1]],[[44],
[1]],[[29],[1]],[[14],[1]],[[33,57],[-1,-1]],[[36],[1]],[[48],[1]],[[34],[1]],
[[22],[1]],[[23],[1]],[[39,58],[-1,-1]],[[12],[1]],[[17],[1]],[[55],[1]],
[[54],[1]],[[30],[1]],[[45],[1]],[[3,6,7,8,9,10,11,14,17,18,21,22,23,25,32,35,
37,38,41,42,43,45,46,48,49,50,53,54,55,57,58,59],[-1,1,-1,-1,1,-1,-1,1,1,-1,
-1,-1,-1,-1,1,1,-1,-1,1,-1,1,1,-1,1,1,1,1,1,-1,1,1,1]],[[45,47],[-1,-1]],
[[35],[1]],[[53],[1]],[[59],[1]],[[20,51],[-1,-1]],[[21,52],[-1,-1]],[[49],
[1]],[[43],[1]],[[42],[1]],[[3,10,23,29,31,34,35,36,38,45,48,56,57],[1,1,1,1,
1,1,-1,1,1,-1,-1,-1,-1]],[[57],[1]],[[58],[1]],[[50],[1]],[[1,4,8,14,15,17,19,
20,21,22,23,24,25,27,32,35,37,38,42,43,45,48,49,54,55,60],[-1,1,1,-1,1,-1,1,
-1,1,1,1,1,1,-1,-1,-1,1,1,1,-1,-1,-1,-1,-1,1,-1]]],[[[3],[1]],[[8],[1]],[[1],
[1]],[[15],[1]],[[16],[1]],[[19],[1]],[[20],[1]],[[2],[1]],[[24],[1]],[[27],
[1]],[[11],[1]],[[29],[1]],[[21],[1]],[[31],[1]],[[4],[1]],[[5],[1]],[[34],
[1]],[[18],[1]],[[6],[1]],[[7],[1]],[[13],[1]],[[39],[1]],[[23],[1]],[[9],
[1]],[[5,7,13,16,17,18,20,21,25,28,34,36,41,49,50,53,58,59],[1,-1,-1,1,1,-1,
-1,-1,-1,-1,1,1,1,1,1,1,1,1]],[[11,26],[-1,-1]],[[10],[1]],[[28],[1]],[[12],
[1]],[[30],[1]],[[14],[1]],[[40],[1]],[[46],[1]],[[17],[1]],[[18,35],[-1,-1]],
[[49],[1]],[[37,59],[-1,-1]],[[23,38],[-1,-1]],[[22],[1]],[[32],[1]],[[53],
[1]],[[5,7,11,13,16,17,20,21,23,30,32,33,34,40,42,46,48,51,52,54],[-1,1,-1,1,
-1,-1,1,1,-1,-1,1,-1,-1,1,-1,-1,1,1,1,1]],[[28,43],[-1,-1]],[[30,44],[-1,-1]],
[[47],[1]],[[33],[1]],[[45],[1]],[[51],[1]],[[36],[1]],[[58],[1]],[[48],[1]],
[[54],[1]],[[41],[1]],[[52],[1]],[[2,4,8,13,14,15,17,18,21,22,30,31,34,39,45,
47,55,59],[-1,-1,-1,-1,1,-1,1,-1,-1,-1,1,1,1,-1,1,1,-1,1]],[[9,14,17,23,24,30,
31,34,56,59],[1,1,1,1,1,1,1,1,-1,1]],[[46,60],[-1,-1]],[[50],[1]],[[59],[1]],
[[33,57],[-1,-1]]]],x->List(x,y->expand(y,60)));
  elif i=36 then return -f(35);
  elif i=37 then return List(
[[[[2,21,45,47,50,52,53],[-1,1,1,1,2,1,-1]],[[1,4,45,53],[-1,1,1,-1]],[[7,20,
53],[1,1,-1]],[[21,47,50,52],[1,1,2,1]],[[8,21,41,47,52],[1,1,1,1,1]],[[9,21,
29,41,45,50,52,57],[-1,1,1,1,1,2,2,1]],[[3,20,53],[1,-1,1]],[[4,5,41,45,50],
[-1,1,1,1,2]],[[6,14,41,50,60,63],[-1,1,1,1,1,1]],[[4,15,20,21,41,45,48,50,
53],[-1,1,-1,1,1,1,1,1,1]],[[16,45],[1,-1]],[[17,29,41,45,60,63],[1,-1,-1,-1,
1,1]],[[18,41,50,52],[-1,-1,1,1]],[[21,29,41,45,50,52,57,60,63],[1,1,2,2,1,2,
1,-1,-1]],[[10,20,41,45,47,48,50,52,53],[1,1,-1,-1,1,-1,1,1,-1]],[[11,45],[1,
1]],[[12,29,41,45,60,63],[1,1,1,1,-1,-1]],[[13,41,45,50,52],[-1,1,1,1,1]],
[[14,29,41,50,60,62,63],[1,-1,1,1,1,-1,1]],[[20],[1]],[[20,30,45,50,52,53],
[-1,1,-2,-1,-1,1]],[[32,41],[1,1]],[[14,21,33,45,48,52,63],[-1,1,1,1,1,1,-1]],
[[34],[1]],[[25,29,41,45,52,60,63],[-1,1,1,2,1,-1,-1]],[[35,50,52],[-1,1,1]],
[[21,36,47,50,52,54,57,63],[1,-1,1,1,1,-1,1,-1]],[[4,21,37,40,41,45,48,50],
[-1,1,-1,1,1,1,1,2]],[[29,41,45],[1,2,1]],[[20,21,45,50,52,53],[1,1,2,1,1,
-1]],[[38,50],[1,-1]],[[22,41,45],[1,1,1]],[[23,29,40,45,48,50,52,54,57,63],
[1,1,-1,1,-1,1,1,-1,1,-1]],[[24],[1]],[[26,50,52],[-1,1,1]],[[4,14,20,27,29,
30,50,53,54,63],[1,1,1,-1,-1,-1,-1,-1,1,1]],[[28,41,45,47,48,54],[-1,1,1,-1,1,
1]],[[31,50],[1,1]],[[14,29,45,46,60,63],[-1,1,-1,1,-1,-1]],[[52,54],[1,1]],
[[41,45],[-1,-1]],[[4,20,30,45,50,53,64],[-1,-1,1,-1,1,1,1]],[[29,41,43,45,50,
52],[1,1,-1,1,1,1]],[[20,44,52,53],[-1,-1,-1,1]],[[45],[1]],[[21,39,45,50,52,
57],[1,1,2,1,2,1]],[[4,20,30,45,50,53],[1,1,-1,2,-1,-1]],[[20,21,30,41,45,48,
50,52,53],[1,1,-1,2,3,1,1,1,-1]],[[20,21,40,45,47,50,55],[1,1,1,-1,1,1,-1]],
[[50],[1]],[[21,47,50,52,56,57,60],[1,1,1,1,-1,1,1]],[[52],[1]],[[53],[1]],
[[40,52],[1,-1]],[[4,20,45,49,50,54],[1,1,-1,-1,-1,1]],[[4,14,20,29,30,40,50,
51,52,53,54,60,63],[1,1,1,-1,-1,1,-1,-1,-1,-1,1,1,2]],[[14,20,29,30,45,52,53,
60,63],[1,1,-1,-1,1,-1,-1,1,1]],[[4,14,21,29,40,41,45,47,48,50,52,54,57,58,60,
63],[1,1,3,-1,1,1,1,1,1,3,3,1,1,-1,1,1]],[[45,50,53,59],[1,-1,1,-1]],[[40,45,
54,63],[1,-1,1,1]],[[20,40,45,54,61],[1,1,-2,1,-1]],[[19,21,41,50,52,57],[-1,
1,-1,2,2,1]],[[40,45,54,60],[-1,1,-1,1]],[[42,45,47],[1,-1,1]]],[[[3,4,38,40,
49,50],[-1,-1,1,1,1,1]],[[4,10,37,40],[-1,1,-1,1]],[[1,38,40,49,50,61],[-1,1,
1,1,1,-1]],[[61],[1]],[[11,34,40,54],[1,1,1,1]],[[12,26,27,34,38,40,62,63],[1,
1,1,1,1,1,-1,-1]],[[15,37,38,40,49,64],[1,1,-1,-1,-1,1]],[[22,34,37,38,40,50,
55],[-1,1,1,1,-1,1,1]],[[23,27,34,35,64],[1,-1,1,1,1]],[[2,34,35,38,61],[1,1,
-1,1,1]],[[5,37,38,40,54],[1,-1,1,1,1]],[[6,26,27,34,35,37],[1,-1,-1,-1,1,
-1]],[[24,34,35],[-1,-1,1]],[[25,26,27,34,35,38,40,50,62,63,64],[-1,1,1,2,-1,
1,1,-1,-1,-1,-1]],[[7,34,35,49,64],[1,-1,1,1,-1]],[[32,37,38,40,64],[-1,1,-1,
-1,-1]],[[27,33,34,35,64],[1,-1,1,-1,-1]],[[34,37,41],[1,1,1]],[[19,27,34,35,
37,38,40,62,64],[-1,-1,1,1,2,-1,-1,1,1]],[[20,49,64],[-1,1,-1]],[[4,35,38,40,
42,49,50,55,61,64],[1,1,-1,-1,-1,-1,-1,-1,1,1]],[[8,28,34],[-1,1,1]],[[9,27,
35,37,38,40,62,63,64],[1,1,-1,-2,2,2,-1,-1,-1]],[[13,37,38,40],[-1,-1,1,1]],
[[14,26,27,34,35,37,38,40,50,64],[-1,1,1,1,-1,2,-1,-1,-1,-1]],[[26],[1]],[[27,
35,37,38,40,62,63],[1,1,-1,1,1,-1,-1]],[[34,35,38,50,55],[1,-1,2,1,1]],[[26,
34,35,37,43],[1,2,-1,1,-1]],[[4,38,40,44,49,64],[-1,1,1,1,1,-1]],[[45],[1]],
[[16,34,35,64],[-1,1,-1,-1]],[[17,27,35,62,63,64],[-1,1,1,-1,-1,-1]],[[35,37,
38,40],[1,1,-1,-1]],[[35],[1]],[[4,26,27,28,38,40,49,57,61,62],[-1,-1,-1,1,-2,
1,1,-1,-1,1]],[[34,35,38,40],[1,-1,1,1]],[[38],[1]],[[27,35,37,38,40,51,55,58,
61,62,64],[1,-1,-2,1,1,-1,-1,1,1,-1,-1]],[[40],[1]],[[18,34,37],[1,-1,-1]],
[[4,21,28,35,37,40,49,61,64],[1,-1,-1,1,1,-2,-1,1,1]],[[26,29,34,37,38,40],[1,
-1,1,2,-1,-1]],[[30,38,40,49,61,64],[1,-1,-1,-1,1,1]],[[31],[1]],[[46,50,51,
63,64],[-1,-1,1,-1,-2]],[[4,35,38,40,47,49,61,64],[-1,-1,-1,1,-1,1,-1,-1]],
[[4,26,28,34,35,37,38,40,48,49,50,55,61,64],[-1,1,1,2,-2,1,1,1,-1,1,1,1,-1,
-1]],[[49],[1]],[[50],[1]],[[35,37,38,40,51,62,63],[1,-1,1,1,1,-1,-1]],[[26,
50,52],[1,-1,-1]],[[38,50,59],[-1,-1,-1]],[[35,40,54],[-1,-1,-1]],[[28,37,38,
40,50],[1,-1,-1,1,-1]],[[4,26,27,28,38,51,55,56,61,62,64],[-1,-1,-2,1,-2,1,1,
-1,-1,1,1]],[[4,26,27,36,37,38,49,50,55,61,62],[-1,-1,-1,-1,1,-1,1,1,1,-1,1]],
[[4,27,28,34,35,37,39,40,50,51,63,64],[-1,-1,1,1,1,-1,1,2,-1,1,-1,1]],[[38,50,
53],[-1,-1,-1]],[[27,37,38,40,60,62,64],[-1,1,-1,-1,-1,1,1]],[[4],[1]],[[34,
35,63],[-1,2,-1]],[[35,37,38,40,62],[1,-1,1,1,-1]],[[64],[1]]],[[[4,16,24,32,
38,40,64],[-1,1,1,1,2,1,1]],[[2],[1]],[[3],[1]],[[1,16,24,32,38,40,64],[-1,1,
1,1,2,1,1]],[[5,16,24,32,40,45,64],[-1,1,1,1,1,-1,1]],[[16,24,38,40,41,62],[2,
1,2,2,1,-1]],[[3,20,24,34,45],[-1,1,-1,-1,1]],[[2,8,38,41,53],[-1,-1,2,-2,
-1]],[[12,16,19,29,36,38,42],[1,1,-1,1,1,1,1]],[[2,3,10,16,24,34,37,38,41,64],
[-1,-1,-1,1,1,-1,1,1,-1,1]],[[11,24,41,45],[-1,1,1,-1]],[[12],[1]],[[16,26,38,
40,41],[1,-1,1,1,1]],[[11,12,16,24,27,38,40,54,63,64],[1,-1,2,1,-1,1,2,1,1,
1]],[[3,15,24,32,34,37,38,40,41,45],[1,-1,1,1,2,-1,1,1,1,-1]],[[16,34,41],[-1,
1,-1]],[[12,60,63],[-1,1,1]],[[16,35,38,40],[1,-1,1,1]],[[9,12,16,29,36,38,
42],[-1,1,1,1,1,1,1]],[[3,7,24,34,45],[1,1,1,1,-1]],[[3,21,38,40,41,42,55],
[-1,-1,-1,-1,1,1,1]],[[42,45,47],[1,-1,1]],[[16,23,24,29,34,36,37,40,42,64],
[1,-1,1,-1,-1,-1,1,1,-1,1]],[[24],[1]],[[11,12,24,34,40,41,54,63],[1,-1,-1,1,
1,-1,1,1]],[[13,16,38,40,41],[-1,1,1,1,1]],[[14,24,25,32,38,40,41],[-1,2,1,1,
1,1,1]],[[2,16,34,37,38,41,42,48,52,53,64],[-1,1,-1,1,2,-2,-1,-1,1,-1,1]],
[[29],[1]],[[3,11,16,24,34,38,40,41,49,54,64],[1,1,1,1,1,1,1,-1,-1,1,1]],[[38,
50],[-1,1]],[[41,64],[-1,1]],[[16,24,25,33,34,37,38,40,52,63,64],[-1,1,1,-1,1,
-1,1,1,-1,1,-1]],[[34],[1]],[[16,18,38,40],[1,-1,1,1]],[[2,3,16,36,38,41,42,
45,53,55],[1,1,1,1,-1,1,1,-1,1,-1]],[[16,32,34,37,64],[2,-1,-1,1,1]],[[38],
[1]],[[11,12,24,36,41,45,54,56],[-1,-1,1,-1,2,-1,-1,1]],[[16,34,40,41],[2,-1,
1,1]],[[41],[1]],[[2,3,16,34,38,45,53,55],[-1,-1,1,-1,1,1,-1,1]],[[16,24,29,
34,38,40,43],[1,-1,1,1,1,1,-1]],[[3,11,34,40,45,54,61],[-1,-1,-1,-1,1,-1,1]],
[[45],[1]],[[11,16,24,34,38,40,41,51,54,63,64],[1,1,1,1,1,2,-1,-1,1,1,1]],[[2,
3,16,22,34,38,53,55],[1,1,-1,1,1,-1,1,-1]],[[3,11,16,28,37,38,40,41,45,54,55,
64],[1,1,1,-1,1,1,1,-2,-1,1,-1,1]],[[3,24,30,32,34,38,52],[1,1,-1,1,1,1,1]],
[[31,38],[1,1]],[[12,16,24,25,32,38,40,41,46],[1,1,2,1,1,1,1,1,-1]],[[11,16,
40,54],[1,1,1,1]],[[53],[1]],[[11,16,24,40,41,45,52],[1,-1,-1,-1,-1,1,1]],[[2,
3,16,38,41,42,45,53],[1,1,1,-1,1,1,-1,1]],[[2,3,12,24,36,38,39,40,41,42,52,53,
55],[1,1,1,-1,1,-1,1,-1,-1,1,1,1,-1]],[[3,12,16,34,36,40,41,55,57],[1,1,-1,1,
1,-1,-2,-1,-1]],[[2,11,12,16,24,32,34,36,37,38,40,41,42,52,53,54,58,64],[1,1,
1,5,2,1,-1,1,1,3,3,1,1,1,1,1,-1,2]],[[38,45,53,59],[-1,1,1,-1]],[[16,17,24,25,
52],[1,1,-1,-1,1]],[[3,16,41,44,45,52],[1,1,1,1,-1,1]],[[6,16,24,38,40,41],
[-1,2,1,2,2,1]],[[12,16,24,25,52],[1,-1,1,1,-1]],[[32,41],[1,1]]],[[[5,30,35,
38,44,45,50],[-1,1,1,-1,1,-1,1]],[[8,38,41,45,50],[1,-1,1,1,-1]],[[13,38,45,
54],[1,-1,-1,1]],[[4,30,35,44,50],[-1,1,1,1,1]],[[1,30,35,44,59],[-1,1,1,1,
-1]],[[14,17,30,35,44],[-1,1,1,2,1]],[[18,38,41,45,54],[-1,1,-1,1,-1]],[[2,41,
45,50,59],[1,-1,-2,2,1]],[[9],[1]],[[28,30,32,38,44,45,50],[-1,1,1,1,1,-1,1]],
[[24,41],[-1,1]],[[17,29,41],[-1,1,1]],[[3,35,44],[1,1,1]],[[6,17,30,35,44],
[-1,1,1,2,1]],[[32,35,37,38,45,54],[-1,1,1,-1,-1,1]],[[34,41],[-1,-1]],[[17],
[1]],[[7,35,41,44],[-1,1,-1,1]],[[9,17,39,41],[1,-1,1,-2]],[[40,45,54],[1,-1,
1]],[[21,35,38,44,45,54],[1,-1,1,-1,1,-1]],[[22],[1]],[[9,23,30,32,35,41,44],
[-1,-1,1,1,1,2,1]],[[11,41],[-1,1]],[[17,35,41,43],[1,1,-2,-1]],[[35,52],[1,
-1]],[[30,32,35,41,44,51],[1,-1,1,1,1,-1]],[[10,30,32,44,45,50,59],[-1,1,1,1,
-2,2,1]],[[12,17,41],[1,1,-1]],[[30,35,38,44,45,54],[1,1,-1,1,-1,1]],[[50,53,
59],[-1,1,-1]],[[32],[1]],[[17,32,33,35,61],[1,-1,-1,1,-1]],[[16,41],[-1,-1]],
[[35],[1]],[[9,17,21,22,38,44,45,50,54,56,59,61],[1,-1,-1,1,-1,1,1,-2,1,-1,-1,
1]],[[15,32,44],[1,1,1]],[[45,50,59],[-1,1,1]],[[9,17,19,41],[-1,1,1,2]],[[20,
35,44,45,50,59],[1,1,1,1,-1,-1]],[[41],[1]],[[21,22,38,41,42,50,54],[1,-1,1,
-1,-1,1,-1]],[[17,25,35,41],[1,-1,1,-2]],[[35,38,45,54],[-1,1,1,-1]],[[45],
[1]],[[30,35,44,62],[1,2,1,-1]],[[21,38,45,47,50,54],[-1,-1,1,-1,-1,1]],[[21,
22,30,32,35,38,41,44,45,48,50,54],[-1,1,1,1,1,-1,-1,1,-2,-1,1,1]],[[30,32,45,
49,50,54,59,61],[1,-1,-1,-1,1,1,1,1]],[[50],[1]],[[27,30,32,35,41,44],[-1,1,
-1,1,1,1]],[[26,35],[-1,1]],[[31,38,45],[1,1,1]],[[35,44,50,59],[-1,-1,1,1]],
[[22,41,45,50,55,61],[1,1,1,-1,-1,1]],[[9,17,21,22,35,36,38,45,50,61],[1,-1,
-1,1,-1,-1,-1,1,-1,1]],[[9,17,21,35,38,41,45,54,57],[1,-1,-1,-1,-1,-1,-1,1,
-1]],[[9,17,22,30,35,41,44,45,58,61],[1,-1,1,3,3,1,3,1,-1,1]],[[38,45,50],[1,
1,-1]],[[41,61,63],[-1,1,1]],[[61],[1]],[[30,35,44,46],[1,2,1,-1]],[[41,60,
61],[1,1,-1]],[[32,64],[-1,-1]]],[[[5,6,34,35,41],[1,-1,-1,2,-1]],[[9,19,34],
[-1,1,-1]],[[12,41],[1,-1]],[[5,35,62],[1,2,-1]],[[5],[1]],[[1,5,34,35,41],
[-1,1,-1,2,-1]],[[11,16,17,41],[-1,-1,1,1]],[[19,21,34,35,41,57],[-1,1,-1,2,
-1,1]],[[2,16,35,47],[-1,-1,1,1]],[[5,19,23,34,35,41],[1,-1,-1,-1,1,-1]],[[11,
34,41],[1,1,-1]],[[3,34],[1,1]],[[31,35],[1,1]],[[5,16,30,34,35,41,52],[1,1,
-1,-2,1,-1,1]],[[11,16,33,34,35,63],[1,1,-1,1,1,1]],[[16,34,41],[1,-1,1]],[[7,
11,16,34],[1,1,1,-1]],[[34,35,38],[-1,1,-1]],[[16,35,41,47],[-1,1,1,1]],[[11,
16,60,63],[1,1,1,1]],[[8,16,34,35,41,47,57],[1,-1,2,-1,1,1,-1]],[[11,42,47],
[1,1,1]],[[5,10,16,34,41,47],[1,-1,1,-1,-2,-1]],[[41,45],[-1,-1]],[[16,34,41,
44,52],[1,-2,1,1,1]],[[35,50],[1,-1]],[[5,35,40,41,49,61],[1,1,-1,-1,-1,1]],
[[5,19,28,34,35,41,47,54,57],[1,-1,-1,-1,2,-2,-1,1,1]],[[34,53],[-1,1]],[[5,
14,16,34,35,41,52],[1,-1,1,-2,1,-1,1]],[[13,35],[1,-1]],[[16,34,64],[1,-1,1]],
[[15,16,34,35,40,54,61],[-1,1,-1,1,-1,-1,1]],[[41],[1]],[[35],[1]],[[11,19,35,
40,41,47,55],[1,1,-1,1,2,1,-1]],[[34,37,40,41],[-1,-1,1,-1]],[[18,35,41],[-1,
1,-1]],[[11,16,34,39,41,52,57],[2,1,1,-1,-1,-1,-1]],[[40],[1]],[[34],[1]],
[[11,16,19,22,34,35],[-1,-1,-1,1,1,1]],[[34,35,41,59],[-1,1,1,1]],[[16,25,41,
52],[-1,1,1,-1]],[[24,34],[-1,-1]],[[5,16,34,35,46,52],[1,2,-2,1,-1,1]],[[16,
19,34,35,41],[1,1,-2,-1,1]],[[5,16,34,35,41,48,52,57],[1,1,-3,1,-1,-1,1,1]],
[[5,11,27,34,35,54,63],[1,1,-1,1,1,1,1]],[[26,35],[-1,1]],[[5,35,41,51,61,63],
[1,1,-1,-1,1,1]],[[52],[1]],[[29,41],[1,1]],[[54],[1]],[[11,19,34,35,36,40,41,
47],[1,1,1,-1,-1,1,1,1]],[[16,19,35,40,41,47,54,56,57],[-1,1,-1,1,2,1,1,-1,
1]],[[34,41,57],[-1,1,1]],[[5,16,19,34,35,40,47,52,54,58],[3,-1,1,-1,3,1,1,1,
1,-1]],[[34,35,41,43],[-1,-1,1,1]],[[16,20,34,40,41,54,61],[-1,1,1,1,1,1,-1]],
[[11,34,40,54,63],[1,2,1,1,1]],[[4,5,35],[-1,1,2]],[[11,34,40,41,54,61],[-1,
-1,-1,-1,-1,1]],[[16,32,34],[-1,1,1]]]],x->List(x,y->expand(y,64)));
  elif i=38 then return -f(37);
  elif i=39 then return List(
[[[[2],[1]],[[1],[1]],[[6],[1]],[[7],[1]],[[8],[1]],[[3],[1]],[[4],[1]],[[5],
[1]],[[16],[1]],[[17],[1]],[[18],[1]],[[19],[1]],[[20],[1]],[[21],[1]],[[22],
[1]],[[9],[1]],[[10],[1]],[[11],[1]],[[12],[1]],[[13],[1]],[[14],[1]],[[15],
[1]],[[30],[1]],[[24],[1]],[[31],[1]],[[32],[1]],[[33],[1]],[[34],[1]],[[35],
[1]],[[23],[1]],[[25],[1]],[[26],[1]],[[27],[1]],[[28],[1]],[[29],[1]],[[36],
[1]],[[46],[1]],[[47],[1]],[[39],[1]],[[24,40,41],[-1,-1,-1]],[[41],[1]],
[[48],[1]],[[49],[1]],[[50],[1]],[[15,60,73],[-1,-1,1]],[[37],[1]],[[38],[1]],
[[42],[1]],[[43],[1]],[[44],[1]],[[58],[1]],[[59],[1]],[[53],[1]],[[60],[1]],
[[55],[1]],[[61],[1]],[[57,76,81],[-1,1,1]],[[51],[1]],[[52],[1]],[[54],[1]],
[[56],[1]],[[64],[1]],[[66],[1]],[[62],[1]],[[65],[1]],[[63],[1]],[[67],[1]],
[[69],[1]],[[68],[1]],[[71],[1]],[[70],[1]],[[53,65,72],[1,1,-1]],[[22,45,54],
[1,1,1]],[[74],[1]],[[77],[1]],[[76],[1]],[[75],[1]],[[39,78,79],[-1,-1,-1]],
[[79],[1]],[[80],[1]],[[81],[1]]],[[[3],[1]],[[68],[-1]],[[1],[1]],[[9],[1]],
[[10],[1]],[[69],[-1]],[[23],[1]],[[22,45,54],[-1,-1,-1]],[[4],[1]],[[5],[1]],
[[11],[1]],[[24],[1]],[[25],[1]],[[14],[1]],[[26],[1]],[[30],[1]],[[73],[-1]],
[[36],[1]],[[19],[1]],[[37],[1]],[[74],[-1]],[[38],[1]],[[7],[1]],[[12],[1]],
[[13],[1]],[[15],[1]],[[39],[1]],[[40],[1]],[[41],[1]],[[16],[1]],[[46],[1]],
[[47],[1]],[[33],[1]],[[19,34,35],[-1,-1,-1]],[[35],[1]],[[18],[1]],[[20],
[1]],[[22],[1]],[[27],[1]],[[28],[1]],[[29],[1]],[[70],[-1]],[[78],[1]],[[79],
[1]],[[51],[1]],[[31],[1]],[[32],[1]],[[59],[1]],[[33,49,50],[-1,-1,-1]],
[[50],[1]],[[45],[1]],[[71],[-1]],[[72],[-1]],[[8,38,51],[-1,-1,-1]],[[56],
[1]],[[55],[1]],[[81],[-1]],[[10,32,62],[-1,-1,-1]],[[48],[1]],[[64],[1]],
[[61],[1]],[[5,47,58],[-1,-1,-1]],[[63],[1]],[[60],[1]],[[65],[1]],[[67],[1]],
[[66],[1]],[[2],[-1]],[[6],[-1]],[[42],[-1]],[[52],[-1]],[[53],[-1]],[[17],
[-1]],[[21],[-1]],[[75],[1]],[[76],[1]],[[80],[1]],[[43],[1]],[[44],[1]],
[[77],[1]],[[57],[-1]]],[[[1],[1]],[[2],[1]],[[11],[1]],[[12],[1]],[[5],[1]],
[[18],[1]],[[19],[1]],[[8],[1]],[[27],[1]],[[14],[1]],[[3],[1]],[[4],[1]],
[[28],[1]],[[10],[1]],[[29],[1]],[[33],[1]],[[21],[1]],[[6],[1]],[[7],[1]],
[[34],[1]],[[17],[1]],[[35],[1]],[[23],[1]],[[39],[1]],[[43],[1]],[[44],[1]],
[[9],[1]],[[13],[1]],[[15],[1]],[[30],[1]],[[49],[1]],[[50],[1]],[[16],[1]],
[[20],[1]],[[22],[1]],[[53],[1]],[[23,37,38],[-1,-1,-1]],[[38],[1]],[[24],
[1]],[[78],[1]],[[79],[1]],[[60,63,64],[-1,-1,-1]],[[25],[1]],[[26],[1]],[[35,
48,59,61,75],[-1,1,1,1,1]],[[30,46,47],[-1,-1,-1]],[[47],[1]],[[54,62,66],[-1,
-1,-1]],[[31],[1]],[[32],[1]],[[51],[1]],[[63],[1]],[[36],[1]],[[48,59,61],
[-1,-1,-1]],[[55,70,71],[-1,1,1]],[[64],[1]],[[57],[1]],[[58],[1]],[[66],[1]],
[[42,52,56],[-1,-1,-1]],[[62],[1]],[[61],[1]],[[52],[1]],[[56],[1]],[[36,68,
69],[-1,1,1]],[[59],[1]],[[5,8,38,47,51,58,67],[1,1,1,1,1,1,-1]],[[53,65,72],
[1,1,-1]],[[72],[1]],[[70],[1]],[[71],[1]],[[69],[1]],[[77],[1]],[[80],[1]],
[[22,45,54],[1,1,1]],[[81],[1]],[[73],[1]],[[40],[1]],[[41],[1]],[[74],[1]],
[[76],[1]]],[[[4],[1]],[[7],[1]],[[13],[1]],[[1],[1]],[[14],[1]],[[20],[1]],
[[2],[1]],[[21],[1]],[[25],[1]],[[10],[1]],[[15],[1]],[[12],[1]],[[3],[1]],
[[5],[1]],[[11],[1]],[[31],[1]],[[17],[1]],[[22],[1]],[[19],[1]],[[6],[1]],
[[8],[1]],[[18],[1]],[[42],[1]],[[76],[-1]],[[9],[1]],[[26],[1]],[[45],[1]],
[[29],[1]],[[28],[1]],[[48],[1]],[[16],[1]],[[32],[1]],[[15,60,73],[-1,-1,1]],
[[35],[1]],[[34],[1]],[[55],[1]],[[52],[1]],[[56],[1]],[[79],[1]],[[57],[1]],
[[81],[-1]],[[23],[1]],[[35,48,59,61,75],[-1,1,1,1,1]],[[51],[1]],[[27],[1]],
[[59],[1]],[[61],[1]],[[30],[1]],[[29,42,52,56,77],[-1,1,1,1,1]],[[58],[1]],
[[44],[1]],[[37],[1]],[[65],[1]],[[66],[1]],[[36],[1]],[[38],[1]],[[40],[1]],
[[50],[1]],[[46],[1]],[[63],[1]],[[47],[1]],[[62],[1]],[[60],[1]],[[64],[1]],
[[53],[1]],[[54],[1]],[[55,74,79],[-1,1,-1]],[[70],[1]],[[71],[1]],[[68],[1]],
[[69],[1]],[[72],[1]],[[11,33,63],[1,1,1]],[[36,39,67],[1,1,1]],[[30,34,43,46,
47],[-1,1,1,-1,-1]],[[24],[-1]],[[23,28,37,38,49],[-1,1,-1,-1,1]],[[78],[1]],
[[39],[1]],[[10,17,26,32,36,41,55,62,64,68,69,70,71,80,81],[1,1,1,1,-1,1,-1,1,
1,1,1,1,1,-1,-1]],[[41],[-1]]],[[[5],[1]],[[8],[1]],[[10],[1]],[[15],[1]],
[[1],[1]],[[17],[1]],[[22],[1]],[[2],[1]],[[26],[1]],[[3],[1]],[[14],[1]],
[[29],[1]],[[13],[1]],[[11],[1]],[[4],[1]],[[32],[1]],[[6],[1]],[[21],[1]],
[[35],[1]],[[20],[1]],[[18],[1]],[[7],[1]],[[38],[1]],[[41],[1]],[[25],[1]],
[[9],[1]],[[44],[1]],[[28],[1]],[[12],[1]],[[47],[1]],[[31],[1]],[[16],[1]],
[[50],[1]],[[34],[1]],[[19],[1]],[[74],[-1]],[[37],[1]],[[23],[1]],[[79],[1]],
[[40],[1]],[[24],[1]],[[54],[1]],[[43],[1]],[[27],[1]],[[7,42,68],[-1,-1,1]],
[[46],[1]],[[30],[1]],[[60],[1]],[[49],[1]],[[33],[1]],[[2,23,70],[-1,-1,1]],
[[62],[1]],[[80],[-1]],[[42],[1]],[[67],[1]],[[66],[1]],[[1,2,4,6,7,8,12,15,
16,17,18,19,20,21,22,29,30,31,32,33,34,35,40,42,48,49,50,52,54,56,57,58,60,62,
66,69,71,72,73,77,78],[-1,1,-1,1,1,1,-1,-1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,-1,1,
-1,1,1,1,1,1,-1,1,-1,1,1,1,1,1,1,1,-1]],[[1,30,71],[-1,-1,1]],[[64],[1]],
[[48],[1]],[[63],[1]],[[52],[1]],[[61],[1]],[[59],[1]],[[75,77,80],[1,1,1]],
[[56],[1]],[[55],[1]],[[22,45,54],[1,1,1]],[[73],[1]],[[8,38,51],[1,1,1]],[[5,
47,58],[1,1,1]],[[77],[1]],[[69],[1]],[[36],[-1]],[[53,65,72],[1,1,-1]],[[11,
13,14,18,20,21,25,27,31,33,36,37,39,44,46,50,55,56,61,63,65,66,67,74,75,76,77,
79,80],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,-1,1,1,1]],[[72],
[1]],[[78],[1]],[[39],[1]],[[53],[-1]],[[3,5,6,8,9,10,16,17,22,23,24,26,28,30,
32,34,36,37,41,43,45,46,49,51,52,53,54,55,58,59,62,64,67,68,69,70,71,73,74,80,
81],[1,1,1,1,1,1,1,1,1,-1,1,1,1,-1,1,1,-1,-1,1,1,1,-1,1,1,1,1,1,-1,1,1,1,1,-1,
1,1,1,1,1,1,-1,-1]]]],x->List(x,y->expand(y,81)));
  elif i=40 then return -f(39);
  fi;
end);

CHEVIE.AddData("UnipotentCharacters","G33",function()local J;J:=E(3);
 return rec(
  harishChandra:=[
  rec(relativeType:=rec(series:="ST",indices:=[1..5],rank:=5,ST:=33),
 levi:=[], parameterExponents:=[1,1,1,1,1],
       charNumbers:=[1..40], eigenvalue:=1, cuspidalName:=""),
   rec(relativeType:=rec(series:="ST",indices:=[1,5],rank:=2,ST:=4),
levi:=[2..4],
       parameterExponents:=[[3,0,0]],
       charNumbers:=[41,58,57,59,43,44,51],
       eigenvalue:=J, cuspidalName:="G_{3,3,3}[\\zeta_3]"),
   rec(relativeType:=rec(series:="ST",indices:=[1,5],rank:=2,ST:=4),
levi:=[2..4],
       parameterExponents:=[[3,3,0]],
       charNumbers:=[46,45,64,55,56,47,54],
       eigenvalue:=J^2, cuspidalName:="G_{3,3,3}[\\zeta_3^2]"),
   rec(relativeType:=rec(series:="ST",indices:=[4],rank:=1,p:=6,q:=1),
       levi:=[1,2,3,209],
       parameterExponents:=[[5,4,1,0,1,4]],
       charNumbers:=[42,49,60,63,61,48],
       eigenvalue:=-1, cuspidalName:="D_4"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[52], eigenvalue:=E(4), 
       cuspidalName:="G_{33}[i]",qEigen:=1/2),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[53], eigenvalue:=-E(4), 
       cuspidalName:="G_{33}[-i]",qEigen:=1/2),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[62], eigenvalue:=-J, 
       cuspidalName:="G_{33}[-\\zeta_3]"),
   rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
levi:=[1..5], parameterExponents:=[],
       charNumbers:=[50], eigenvalue:=-J^2, 
       cuspidalName:="G_{33}[-\\zeta_3^2]")],
  families:=[ Family("C1",[1]),
 Family(ComplexConjugate(CHEVIE.families.X(3)),[4,6,41],rec(signs:=[1,1,-1])),
 Family("C1",[15]),
 Family("C2",[22,8,19,42]),
 Family(ComplexConjugate(CHEVIE.families.X(6)),
  [25,30,17,28,23,45,48,43,50,9,47,44,11,49,46],
  rec(signs:=[1,1,1,1,1,-1,-1,-1,-1,-1,1,-1,1,1,-1])),
 Family("C1",[39]),
 Family("C1",[36]),
 Family(ComplexConjugate(CHEVIE.families.X(3)),[34,32,51],rec(signs:=[1,1,-1])),
 # changed Gunter 22/9/99 from C2 to C'\"2; and to C2h on 26.2.2003
 # and back 27.2.2003:
 Family("C'\"2",[37,38,52,53]),
 Family("C1",[14]),
 Family(CHEVIE.families.X(3),[33,31,54],rec(signs:=[1,1,-1])),
 Family("C1",[40]),
 Family("C1",[35]),
 Family("C1",[13]),
 Family(CHEVIE.families.X(6),[26,29,18,27,24,57,60,55,62,10,59,56,12,61,58],
  rec(signs:=[ 1, 1, 1, 1, 1, -1, -1, -1,-1, -1, 1, -1, 1, 1, -1 ])),
 Family("C2",[ 21,7,20,63]),
 Family("C1",[16]),
 Family(CHEVIE.families.X(3),[3,5,64],rec(signs:=[1,1,-1])),
 Family("C1",[2])],
 a:=[0,45,28,1,28,1,18,3,4,13,4,13,12,9,2,23,4,13,3,18,18,3,4,13,4,13,13,4,13,4,
  10,7,10,7,10,7,8,8,6,11,1,3,4,4,4,4,4,4,4,4,7,8,8,10,13,13,13,13,13,13,13,13,
  18,28],
 A:=[0,45,44,17,44,17,42,27,32,41,32,41,36,33,22,43,32,41,27,42,42,27,32,41,32,
  41,41,32,41,32,38,35,38,35,38,35,37,37,34,39,17,27,32,32,32,32,32,32,32,32,35,
  37,37,38,41,41,41,41,41,41,41,41,42,44],
 curtis:=[2,1,6,5,4,3,8,7,12,11,10,9,14,13,16,15,18,17,20,19,22,21,26,25,24,23,
   30,29,28,27,34,33,32,31,36,35,38,37,40,39,-64,63,-56,-55,-58,-57,-59,61,60,
   -62,-54,-53,-52,-51,-44,-43,-46,-45,-47,49,48,-50,42,-41]
 );
end);

# for the following see
# Burkhardt, Math. Annalen 38 pp 208--209
# and Orlik, Contemporary mathematics vol. 90 (1989) pp 223--226
# here we have interchanged the x and z of Burkhardt

CHEVIE.AddData("Invariants","G33",
[ function(x,y,z,t,u)local a1,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a4:=y*u*t*x;
    return z^4-8*a1*z+48*a4;end,
  function(x,y,z,t,u)local a1,a2,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a4:=y*u*t*x;
    return z^6+20*a1*z^3+96*a2-8*a1^2+360*a4*z^2;end,
  function(x,y,z,t,u)local a1,a2,a3,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a3:=-((y*u*t)^3+(u*t*x)^3+(y*t*x)^3+(y*u*x)^3);
    a4:=y*u*t*x;
    return -z^4*a2+(9*a3-a1*a2)*z+a4*(z^6-a1*z^3+6*a2-2*a1^2)+9*a4^2*z^2;end,
# Note: the 3rd invariant of degree 10 is Determinant(Hessian(J4))/63700992
  function(x,y,z,t,u)local a1,a2,a3,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a3:=-((y*u*t)^3+(u*t*x)^3+(y*t*x)^3+(y*u*x)^3);
    a4:=y*u*t*x;
    return 5*a2*z^6+(99*a3+a1*a2)*z^3+216*a4^3-36*a1*a3+24*a2^2-4*a1^2*a2+
    a4*(3*z^8+33*a1*z^5+(18*a2+30*a1^2)*z^2)+a4^2*(243*z^4+108*a1*z);end,
  function(x,y,z,t,u)local a1,a2,a3,a4;
    a1:=-(y^3+u^3+t^3+x^3);
    a2:=(y*u)^3+(y*t)^3+(y*x)^3+(u*t)^3+(u*x)^3+(t*x)^3;
    a3:=-((y*u*t)^3+(u*t*x)^3+(y*t*x)^3+(y*u*x)^3);
    a4:=y*u*t*x;
    return 4*a3*z^9+(54*a4^3+12*a1*a3-a2^2)*z^6+
    (162*a1*a4^3-18*a2*a3+12*a1^2*a3-2*a1*a2^2)*z^3+
    (27*a3^2-18*a1*a2*a3+4*a1^3*a3+4*a2^3-a1^2*a2^2)+
    a4*(6*a2*z^8+(54*a3+12*a1*a2)*z^5+(243*a4^3+54*a1*a3-36*a2^2+6*a1^2*a2)
     *z^2)+a4^2*(3*z^10+18*a1*z^7+(54*a2+27*a1^2)*z^4+
     (162*a3-54*a1*a2+12*a1^3)*z);end]);

CHEVIE.AddData("BasicDerivations","G33",function()return function(x,y,z,t,u)
return [[4*x,6*y*z,10*z-1/96*x*y,12*t-1/32*y^2,18*u-1/32*t*y],
[6*y,-5184*u+9*x^2*z,6*t-1/64*x^3,63*x*z-3/64*x^2*y,-3/64*t*x^2+180*z^2],
[10*z,6*t*z-9*u*x,-1/384*t*x+3/128*y*z,9/2*u-1/128*t*y+9/128*x^2*z,
3/64*u*y+9/32*x*z^2-1/32*t^2],[12*t,-27*u*y+63*x*z^2,
9/2*u+3/128*t*y-5/128*x^2*z,-15/128*x*y*z+9/128*t*x^2+90*z^2,
-21/64*t*x*z+9/64*u*x^2+27/32*y*z^2],[18*u,-27*t*u+180*z^3,
3/64*u*y-1/32*x*z^2,9/64*u*x^2-3/32*y*z^2,45/64*u*x*z-3/8*t*z^2]];
end;end);

# the discriminant as a polynomial in the invariants
# it is equal to Determinant(BasicDerivations)*262144/729
CHEVIE.AddData("Discriminant","G33",function()return function(x,y,z,t,u)
return 243302400*t*u*x*y*z^5-483072*t*u*x^2*y^2*z^4+144*t*u*x^3*y^3*z^3-
11520*u*x*y^3*z^5-108*t*x*y^4*z^5-72*t*u*y^5*z^3-14592*t*u*x^5*z^4-
47185920000*t*u*z^6-72*t*u*x^6*y*z^3-737280000*x*y*z^8-34560*t*u^2*x*y^3*z^2-
6635520*t*u^2*y^2*z^3-24*t*u^2*x^2*y^4*z+57360384*t*u^2*x^3*z^3-
186624*t*u^2*x^4*y*z^2+27*u*x^2*y^4*z^4+48*t*u^2*x^5*y^2*z+24576000*u*y^2*z^6+
270336000*t*x^2*z^7-24*t*u^2*x^8*z-3822059520*t*u^3*x*z^2-875520*t*x^3*y*z^6+
2654208*t*u^3*x^2*y*z+4608*t*u^3*y^4-4608*t*u^3*x^6-230400*t*y^3*z^6-
57753600*u*x^3*z^6+254803968*t*u^4*y+177408*u*x^4*y*z^5+216*t*x^4*y^2*z^5-
54*u*x^5*y^2*z^4-108*t*x^7*z^5+27*u*x^8*z^4+30*t^2*u*x*y^4*z^2-
65617920*t^2*u*x^2*z^4+107520*t^2*x*y^2*z^5+254720*t^2*u*x^3*y*z^3+
77056*t^2*u*y^3*z^3-60*t^2*u*x^4*y^2*z^2+21233664000*u^2*x*z^5+
36*u^2*x*y^5*z^2+65536000*t^2*y*z^6+30*t^2*u*x^7*z^2-2654208*t^2*u^2*x*y*z^2-
128286720*u^2*x^2*y*z^4+48384*t^2*u^2*x^2*y^2*z+5662310400*t^2*u^2*z^3-
8*t^2*u^2*x^3*y^3+4*t^2*u^2*y^5+25344*t^2*u^2*x^5*z+4*t^2*u^2*x^6*y+
1382400*x^2*y^2*z^7-1105920*t^2*u^3*y^2+231168*u^2*x^3*y^2*z^3+
1548288*t^2*u^3*x^3-1536*u^2*y^4*z^3-72*u^2*x^4*y^3*z^2+113664*t^2*x^4*z^5-
8448*u^2*x^6*z^3+36*u^2*x^7*y*z^2-29952*t^3*u*x*y^2*z^2-21626880*t^3*u*y*z^3+
17915904*u^3*x*y^2*z^2-2123366400*u^3*y*z^3-31488*t^3*u*x^4*z^2-
39321600*t^3*x*z^5+24576*t^3*x^2*y*z^4-7077888*t^3*u^2*x^2*z-4352*t^3*u^2*y^3-
3840*t^3*u^2*x^3*y-27648*u^3*x^2*y^3*z-113246208*t^3*u^3-8*t^3*x^3*y^2*z^3+
12*u^3*x^3*y^4-432*x^3*y^3*z^6-8626176*u^3*x^4*z^2+4*t^3*y^4*z^3+
27648*u^3*x^5*y*z-4*u^3*y^6-12*u^3*x^6*y^2+4*t^3*x^6*z^3+4*u^3*x^9+
10616832*t^4*u*x*z^2-6144*t^4*u*x^2*y*z+2*t^4*u*x^3*y^2-t^4*u*y^4-t^4*u*x^6+
1179648*t^4*u^2*y+764411904*u^4*x^2*z-4096*t^4*y^2*z^3-442368*u^4*y^3-
1327104*u^4*x^3*y-4096*t^4*x^3*z^3-12230590464*u^5+1024*t^5*u*y^2+
1024*t^5*u*x^3+1048576*t^5*z^3+216*y^5*z^6-55296*x^5*z^7-262144*t^6*u+
216*x^6*y*z^6+104857600000*z^9;
end;end);
