#############################################################################
##
#A  tbl/cmplxg26.g       CHEVIE library          Gunter Malle and Jean Michel
##
#Y  Copyright (C) 1998 - 2001  The CHEVIE Team
##
##  This file contains data about the complex reflection group
##  of type G26 in the Shephard-Todd classification.
##
CHEVIE.Revision("tbl/cmplxg26.g",
   "$Id: cmplxg26.g,v 1.6 2003/12/04 11:26:45 chevie Exp $");

CHEVIE.AddData("PrintDiagram","G26",function(indices,title)
  Print(title," ",indices[1],"==(3)",indices[2],"--(3)",indices[3],"\n");
end);

CHEVIE.AddData("GeneratingRoots","G26",[[0,1,-1],[0,0,1],-E(4)/ER(3)*[1,1,1]]);

CHEVIE.AddData("HyperplaneRepresentatives","G26",[1,2]);

CHEVIE.AddData("EigenvaluesGeneratingReflections","G26",[1/2,1/3,1/3]);

CHEVIE.AddData("BraidRelations","G26",[[[1,2,1,2],[2,1,2,1]],
  [[1,3],[3,1]],[[2,3,2],[3,2,3]]]);

CHEVIE.AddData("ReflectionName","G26",function(arg)local i,TeX,type;
  if Length(arg)=1 then return "G26"; fi;
  type:=arg[1]; TeX:=IsBound(arg[2].TeX);
  if type=1 then if TeX then return "G_{26}";else return "G26";fi;
  elif TeX then return SPrint("G(",Format(type),")_{26}");
  else return SPrint("G(",Format(type),")26");
  fi;
end);

CHEVIE.AddData("Size","G26", 1296);

CHEVIE.AddData("ReflectionDegrees","G26",[6,12,18]);

CHEVIE.AddData("NrConjugacyClasses","G26", 48);

CHEVIE.AddData("ParabolicRepresentatives","G26",# repr. of conj. classes
function(s)local t;t:=[[[]],[[1],[2]],[[1,2],[1,3],[2,3]],[[1..3]]];
  return t[s+1];end);

CHEVIE.AddData("ClassNames","G26",
[".","1","212","c3c3","212c22c3","12","1212","12121212","c32","1212z",
 "c32c32","1212zzz","12z","c","cc","z","zc","zcc","zz","zzz","zzzz","zzzzz",
 "13","13z","13zz","133","c1223","2","21212","2323c","2z","2zz","2zzz","22",
 "c12122","3322","23","23z","23zz","232323","232323z","232323zz","323",
 "c121","c12","c3c3c3","323zzzz","c3"]);

CHEVIE.AddData("WordsClassRepresentatives","G26",
 List(CHEVIE.RawData("ClassNames","G26"),x->Replace(x,".",[],"1",[1],"2",[2],
   "3",[3],"c",[1,2,3],"z",[1,2,3,1,2,3,1,2,3])));

CHEVIE.AddData("PowerMaps","G26",
 [,[1,1,8,19,21,7,8,7,11,28,32,8,11,15,17,19,15,17,21,1,19,
  21,34,7,11,28,32,34,29,29,7,11,34,28,32,34,28,32,8,1,19,21,40,42,4,40,42,4],
 [1,2,2,40,2,2,1,1,20,20,1,20,40,16,19,20,21,22,1,20,1,20,2,40,2,2,40,1,1,20,
  20,1,20,1,20,40,40,2,40,40,2,40,43,46,43,46,43,46],,
 [1,2,6,42,41,3,8,7,35,33,32,31,27,18,17,22,15,14,21,20,19,16,26,39,38,23,13,
  34,29,30,12,11,10,28,9,37,36,25,24,40,5,4,43,48,47,46,45,44],,
 [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
  29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48],,,,
 [1,2,6,42,41,3,8,7,35,33,32,31,27,18,17,22,15,14,21,20,19,16,26,39,38,23,13,34,
  29,30,12,11,10,28,9,37,36,25,24,40,5,4,43,48,47,46,45,44],,
 [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
  29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48],,,,
 [1,2,6,42,41,3,8,7,35,33,32,31,27,18,17,22,15,14,21,20,19,16,26,39,38,23,13,
  34,29,30,12,11,10,28,9,37,36,25,24,40,5,4,43,48,47,46,45,44]]);

CHEVIE.AddData("ClassInfo","G26",
  rec(classtext:=CHEVIE.RawData("WordsClassRepresentatives","G26"),
    classnames:=CHEVIE.RawData("ClassNames","G26"),
    classparams:=CHEVIE.RawData("ClassNames","G26"),
    orders:=[1,2,6,6,6,6,3,3,6,6,3,6,6,18,9,6,9,18,3,2,3,6,6,6,6,6,6,3,
  3,6,6,3,6,3,6,6,6,6,6,2,6,6,4,12,12,4,12,12],
    classes:=[1,9,36,9,9,36,12,12,12,12,12,12,36,72,72,1,72,72,1,1,1,1,36,36,
      36,36,36,12,24,24,12,12,12,12,12,36,36,36,36,9,9,9,54,54,54,54,54,54]));

CHEVIE.AddData("CharInfo","G26",function()local res;
  res:=rec(charparams:=
 [[1,0],[1,9],[1,33],[1,21],[1,24],[1,12],[2,24],[2,15],[2,12],[2,3],[2,18],
  [2,9],[3,6],[3,15],[3,8,2],[3,5,2],[3,8,1],[3,5,1],[3,20],[3,17],[3,16,2],
  [3,13,2],[3,4],[3,1],[3,16,1],[3,13,1],[6,8,2],[6,11,2],[6,8,1],[6,11,1],
  [6,2],[6,5],[6,4,2],[6,7,2],[6,10],[6,13],[6,4,1],[6,7,1],[8,6,1],[8,3],
  [8,9,2],[8,12],[8,6,2],[8,9,1],[9,8],[9,5],[9,10],[9,7]],
# The labelling is as follows:
# The fakedegrees of phi{8,6}' and phi{8,9}' are monic.
# The complex conjugate of phi{3,8}' is phi{3,4}
# The complex conjugate of phi{3,5}' is phi{3,1}
# The complex conjugate of phi{3,16}' is phi{3,20}
# The complex conjugate of phi{3,13}' is phi{3,17}
# The complex conjugate of phi{6,8}' is phi{6,10}
# The complex conjugate of phi{6,11}' is phi{6,13}
# The complex conjugate of phi{6,4}' is phi{6,2}
# The complex conjugate of phi{6,7}' is phi{6,5}
  extRefl:=[1,24,15,4]);
  res.b:=List(res.charparams,x->x[2]);
  res.spetsRationality:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1];
  return res;
end);

CHEVIE.AddData("HeckeCharTable","G26",function(para,root)
  local r,p,u,v,w,f10,f23,f36,f31,f62,f83,f97,res,c;
  c:=Product(para,Product)^0;
  res:=rec(size:=1296,order:=1296,identifier:="G26",name:="G26",
   powermap:=CHEVIE.RawData("PowerMaps","G26"),
   parameter:=para{[1,2]}, dim:=3,
   irredinfo:=List(CHEVIE.RawData("CharInfo","G26")().charparams,x->
     rec(charparam:=x,charname:=CHEVIE.RawData("CharName","G26")(x,rec()))));
  Inherit(res,CHEVIE.RawData("ClassInfo","G26"));
  res.centralizers:=List(res.classes,x->res.order/x);
  f10:=function(r,u) return [1,r,r*u^2,r^2*u^6,r^3*u^9,r*u,r^2*u^2,r^4*u^4,
  r*u^4,r^5*u^8,r^2*u^8,r^11*u^20,r^4*u^7,r*u^2,r^2*u^4,r^3*u^6,r^4*u^8,
  r^5*u^10,r^6*u^12,r^9*u^18,r^12*u^24,r^15*u^30,r*u,r^4*u^7,r^7*u^13,r*u^2,
  r^2*u^5,u,r^2*u^3,r*u^6,r^3*u^7,r^6*u^13,r^9*u^19,u^2,r^3*u^5,u^4,u^2,
  r^3*u^8,r^6*u^14,u^6,r^3*u^12,r^6*u^18,u^3,r^3*u^3,r^2*u^3,r^3*u^9,r^12*u^27,
  r*u^3]*c;end;
  f23:=function(r,p,u,v,w) return [2,2*r,r*(u^2+v^2),-2*r^2*u^3*v^3,
  r^3*u^3*v^3*(u+v)*(v^2-u*v+u^2),r*(u+v),r^2*(u^2+v^2),r^4*(u^4+v^4),
  -r*u*v*(u^2+v^2),-u^3*v^3*r^5*(u^2+v^2),r^2*u^2*v^2*(u^4+v^4),
  -u^9*v^9*r^11*(u^2+v^2),-u^3*r^4*v^3*(u+v),r*u*v,-r^2*u^2*v^2,-2*r^3*u^3*v^3,
  -r^4*u^4*v^4,r^5*u^5*v^5,2*r^6*u^6*v^6,-2*r^9*u^9*v^9,2*r^12*u^12*v^12,
  -2*r^15*u^15*v^15,r*(u+v),-u^3*r^4*v^3*(u+v),u^6*r^7*v^6*(u+v),r*(u^2+v^2),
  -u^2*r^2*v^2*(u+v),u+v,r^2*(u+v)*(v^2-u*v+u^2),-2*r*u^3*v^3,
  -u^3*v^3*r^3*(u+v),u^6*r^6*v^6*(u+v),-u^9*r^9*v^9*(u+v),u^2+v^2,
  -u^2*r^3*v^2*(u+v),-u*v*(u^2+v^2),u*v,-r^3*u^4*v^4,r^6*u^7*v^7,-2*u^3*v^3,
  2*r^3*u^6*v^6, -2*r^6*u^9*v^9, 0, 0, 0, 0, 0, 0]*c;end;
  f36:=function(r,p,u,v,w) return [3,3*r,r*(u^2+v^2+w^2),3*r^2*u^2*v^2*w^2,
  r^3*u*v*w*(w^3*v^3+w^3*u^3+u^3*v^3), r*(u+v+w),
  r^2*(u^2+v^2+w^2), r^4*(u^4+v^4+w^4), r*(u^2*v^2+u^2*w^2+v^2*w^2),
  u^2*r^5*v^2*w^2*(u^2+v^2+w^2), r^2*(u^4*v^4+u^4*w^4+v^4*w^4),
  u^6*v^6*r^11*w^6*(u^2+v^2+w^2),u^2*r^4*v^2*w^2*(u+v+w),0,0,3*r^3*u^2*v^2*w^2,
  0,0,3*r^6*u^4*v^4*w^4,3*r^9*u^6*v^6*w^6,3*r^12*u^8*v^8*w^8,
  3*r^15*u^10*v^10*w^10,r*(u+v+w),u^2*r^4*v^2*w^2*(u+v+w),
  u^4*r^7*v^4*w^4*(u+v+w), r*(u^2+v^2+w^2), u*v*r^2*w*(v*w+u*v+u*w), u+v+w,
  r^2*(u^3+v^3+w^3), 3*r*u^2*v^2*w^2, u^2*r^3*v^2*w^2*(u+v+w),
  u^4*r^6*v^4*w^4*(u+v+w), u^6*r^9*v^6*w^6*(u+v+w), u^2+v^2+w^2,
  u*v*r^3*w*(v*w+u*v+u*w), u^2*v^2+u^2*w^2+v^2*w^2, 0, 0, 0, 3*u^2*v^2*w^2,
  3*r^3*u^4*v^4*w^4, 3*r^6*u^6*v^6*w^6, -u*v*w, -r^3*u*v*w, -r^2*u*v*w,
  -r^3*u^3*v^3*w^3, -r^12*u^9*v^9*w^9, -r*u*v*w]*c;end;
  f31:=function(r,p,u,v,w)return [3,p+2*r,u*(-p*v-r*v+r*u),
   u^4*v^2*r*(2*p+r), p^2*r*u^5*v^4, u*r, u*r*(r*u-2*p*v),
   r^2*u^2*(2*p^2*v^2+r^2*u^2), -u^2*v*(-p*v+2*r*u), u^5*r^3*v^2*p*(r*u-2*p*v),
   u^4*v^2*(p^2*v^2+2*r^2*u^2), u^13*r^7*v^6*p^3*(r*u-2*p*v), p*r^3*u^5*v^2,
   0, 0, 3*p*r^2*u^4*v^2, 0, 0, 3*p^2*r^4*u^8*v^4, 3*p^3*r^6*u^12*v^6,
   3*p^4*r^8*u^16*v^8, 3*p^5*r^10*u^20*v^10, p*u+r*u+r*v, 
   u^4*r^2*v^2*p*(p*u+r*u+r*v),u^8*r^4*v^4*p^2*(p*u+r*u+r*v),p*u^2+r*u^2+r*v^2,
   u^3*r*v*(p*v+r*v+p*u), 2*u+v, r*u*(-p*v^2-p*u*v+r*u^2),
   -u^3*v*(r*v^2-p*u*v+r*u^2), u^4*r^2*v^2*p*(2*u+v), u^8*r^4*v^4*p^2*(2*u+v),
   u^12*p^3*r^6*v^6*(2*u+v),2*u^2+v^2,u^3*p*r^2*v*(2*v+u),u*(-v^3-u^2*v+u^3),
   u*(u+v), u^5*r^2*v^2*p*(u+v), u^9*r^4*v^4*p^2*(u+v), u^3*(-2*v^3+u^3),
   u^7*v^2*r^2*p*(-2*v^3+u^3), u^11*v^4*r^4*p^2*(-2*v^3+u^3), u^3, p*r^2*u*v^2,
   -p*r*u^2*v, -r^3*u^6*v^3, p^4*r^8*u^19*v^8,-u^2*r*v]*c;end;
  f62:=function(r,p,u,v,w)return[6,2*p+4*r,-p*u*v-p*u*w-r*u*v-r*u*w+r*u^2+r*v^2,
  -2*u^3*v^2*r*w*(2*p+r), u^3*p^2*r*v*w^2*(u+v)*(v^2-u*v+u^2),
  r*(u+v), r*(-2*p*u*v-2*p*u*w+r*u^2+r*v^2),
  r^2*(2*p^2*u^2*v^2+2*p^2*u^2*w^2+u^4*r^2+v^4*r^2),
  -u*(p*v^2*w-2*r*u*v*w-2*u*r*v^2+u^2*p*w),
  -r^3*u^3*v^2*p*w*(-2*p*u*v-2*p*u*w+r*u^2+r*v^2),
  u^2*(p^2*v^4*w^2+2*r^2*u^2*v^2*w^2+2*u^2*r^2*v^4+u^4*p^2*w^2),
  -u^9*v^6*r^7*p^3*w^3*(-2*p*u*v-2*p*u*w+r*u^2+r*v^2), -u^3*p*r^3*v^2*w*(u+v),
  0, 0, -6*p*r^2*u^3*v^2*w, 0, 0, 6*p^2*r^4*u^6*v^4*w^2,-6*p^3*r^6*u^9*v^6*w^3,
  6*p^4*r^8*u^12*v^8*w^4, -6*p^5*r^10*u^15*v^10*w^5, p*u+p*v+2*r*u+r*v+r*w,
  -u^3*p*r^2*v^2*w*(p*u+p*v+2*r*u+r*v+r*w),
  u^6*r^4*v^4*p^2*w^2*(p*u+p*v+2*r*u+r*v+r*w), p*u^2+p*v^2+2*r*u^2+r*v^2+r*w^2,
  -u^2*r*v*(v*r*w+p*u*v+2*v*p*w+r*u*w+p*u*w), 3*u+2*v+w,
  r*(-u*p*v^2-p*u*w^2-p*u^2*v-u^2*p*w+r*u^3+r*v^3),
  u^2*v*(v*r*w^2+r*v^2*w-2*v*p*u*w+r*u^2*w+u^2*r*v),
  -u^3*p*r^2*v^2*w*(3*u+2*v+w), u^6*r^4*v^4*p^2*w^2*(3*u+2*v+w),
  -u^9*p^3*r^6*v^6*w^3*(3*u+2*v+w), 3*u^2+2*v^2+w^2,
  -u^2*p*r^2*v*(3*v*w+u*v+2*u*w),(u^2+v^2)*(u^2-u*v+w^2), u*(u+v),
  -u^4*p*r^2*v^2*w*(u+v), u^7*r^4*v^4*p^2*w^2*(u+v),u^2*(3*v^2*w^2-2*u*v^3+u^4),
  -p*r^2*u^5*v^2*w*(3*v^2*w^2-2*u*v^3+u^4),
  p^2*r^4*u^8*v^4*w^2*(3*v^2*w^2-2*u*v^3+u^4), u*(-v*w+u^2), v*r^2*p*(-v*w+u^2),
  0, 0, u^13*v^8*p^4*r^8*w^4*(-v*w+u^2), 0]*c;end;
  f83:=function(r,p,u,v,w,eps)local s; s:=eps*GetRoot(-r*p*v*w,2);
    return [8, 4*p+4*r, (p+r)*(-u*v-u*w-v*w+u^2), -4*u^3*v*s*w*(p+r),
   -u^3*v^3*w^3*(p+r)*(p^2-p*r+r^2), u*(p+r),
   -2*p*r*u*v-2*p*r*u*w-2*p*r*v*w+p^2*u^2+r^2*u^2,
   2*p^2*r^2*u^2*v^2+2*p^2*r^2*u^2*w^2+2*p^2*r^2*v^2*w^2+p^4*u^4+r^4*u^4,
   s*u*(-r^2*v*w-p^2*v*w+2*p*r*u*v+2*p*r*u*w+2*u^2*p*r)/p/r,
   -u^3*v*p*r*s*w*(-2*p*r*u*v-2*p*r*u*w-2*p*r*v*w+p^2*u^2+r^2*u^2), -
   u^2*v*w*(r^4*v^2*w^2+2*p^2*r^2*u^2*w^2+2*p^2*r^2*u^2*v^2+2*p^2*r^2*u^4+
    p^4*v^2*w^2)/p/r,
   u^9*v^4*r^4*p^4*s*w^4*(-2*p*r*u*v-2*p*r*u*w-2*p*r*v*w+p^2*u^2+r^2*u^2),
   -u^4*v*r*p*s*w*(p+r), -s*u, p*r*u^2*v*w, -8*p*r*s*u^3*v*w,
   -p^2*r^2*u^4*v^2*w^2, -p^2*r^2*s*u^5*v^2*w^2, -8*p^3*r^3*u^6*v^3*w^3,
   8*p^4*r^4*s*u^9*v^4*w^4, 8*p^6*r^6*u^12*v^6*w^6, -8*p^7*r^7*s*u^15*v^7*w^7,
   (p+r)*(w+v+2*u), -u^3*r*v*p*s*w*(p+r)*(w+v+2*u),
   -u^6*v^3*r^3*p^3*w^3*(p+r)*(w+v+2*u), (w^2+v^2+2*u^2)*(p+r),
   -u^2*(p+r)*s*(2*v*w+u*v+u*w), 4*u+2*v+2*w,
   -p*r*u*v^2-p*r*u*w^2-p*r*v*w^2-p*r*u^2*v-p*r*u^2*w-p*r*v^2*w+p^2*u^3+r^2*u^3,
   u^2*s*(-r^2*u*v*w-p^2*u*v*w+p*r*v*w^2+p*r*v^2*w+p*r*u*v^2+p*r*u*w^2+
    p*r*u^2*v+p*r*u^2*w)/p/r, -2*u^3*p*r*s*v*w*(w+v+2*u),
    -2*u^6*p^3*r^3*v^3*w^3*(w+v+2*u), 2*u^9*p^4*r^4*s*v^4*w^4*(w+v+2*u),
    4*u^2+2*v^2+2*w^2, -2*u^2*p*r*s*(2*v*w+u*v+u*w),
   -u*v^3-u*w^3+u^2*v^2+u^2*w^2+v^2*w^2-u^3*v-u^3*w+u^4,
    u*(u+v+w),
    -u^4*p*r*s*v*w*(u+v+w), -u^7*p^3*r^3*v^3*w^3*(u+v+w),
    u^2*(3*v^2*w^2-2*u*v^3-2*u*w^3+u^4),
    -p*r*s*u^5*v*w*(3*v^2*w^2-2*u*v^3-2*u*w^3+u^4),
    -p^3*r^3*u^8*v^3*w^3*(3*v^2*w^2-2*u*v^3-2*u*w^3+u^4), u*(-v*w+u^2),
    p*r*s*(-v*w+u^2), 0, 0, u^13*v^6*p^6*r^6*w^6*(-v*w+u^2), 0]*c;end;
  f97:=function(r,p,u,v,w,j) return [9, 3*p+6*r,
  -p*u*v-p*u*w-v*p*w-r*u*v-r*u*w-v*r*w+r*u^2+r*v^2+r*w^2,
  3*r*u^2*v^2*j^2*w^2*(2*p+r), r*u*v*p^2*j*w*(w^3*v^3+w^3*u^3+u^3*v^3),
  r*(u+v+w),
  r*(-2*p*u*v-2*p*u*w-2*v*p*w+r*u^2+r*v^2+r*w^2),
  r^2*(2*p^2*u^2*v^2+2*p^2*u^2*w^2+2*p^2*v^2*w^2+u^4*r^2+v^4*r^2+r^2*w^4),
  j^2*(-2*r*u*v*w^2-2*r*u*v^2*w-2*r*u^2*v*w+p*u^2*v^2+p*u^2*w^2+p*v^2*w^2),
  u^2*v^2*r^3*j^2*p*w^2*(-2*p*u*v-2*p*u*w-2*v*p*w+r*u^2+r*v^2+r*w^2),
  j*(2*r^2*u^2*v^2*w^4+2*r^2*u^2*v^4*w^2+2*r^2*u^4*v^2*w^2+p^2*u^4*v^4+
   p^2*u^4*w^4+p^2*v^4*w^4),
  u^6*v^6*r^7*p^3*w^6*(-2*p*u*v-2*p*u*w-2*v*p*w+r*u^2+r*v^2+r*w^2),
  u^2*j^2*p*r^3*v^2*w^2*(u+v+w), 0, 0, 9*j^2*p*r^2*u^2*v^2*w^2, 0, 0,
  9*j*p^2*r^4*u^4*v^4*w^4, 9*p^3*r^6*u^6*v^6*w^6, 9*j^2*p^4*r^8*u^8*v^8*w^8,
  9*j*p^5*r^10*u^10*v^10*w^10, (p+2*r)*(u+v+w),
  u^2*r^2*v^2*j^2*p*w^2*(p+2*r)*(u+v+w), u^4*r^4*v^4*j*p^2*w^4*(p+2*r)*(u+v+w),
  (u^2+v^2+w^2)*(p+2*r), u*(2*p+r)*r*v*j^2*w*(v*w+u*v+u*w), 3*u+3*v+3*w,
  r*(-u*p*v^2-p*u*w^2-p*v*w^2-p*u^2*v-u^2*p*w-p*v^2*w+r*u^3+r*v^3+r*w^3),
  -u*v*j^2*w*(v*r*w^2+w^2*r*u+r*v^2*w-3*v*p*u*w+r*u^2*w+u*r*v^2+u^2*r*v),
  3*u^2*j^2*p*r^2*v^2*w^2*(u+v+w), 3*u^4*j*p^2*r^4*v^4*w^4*(u+v+w),
  3*u^6*p^3*r^6*v^6*w^6*(u+v+w), 3*u^2+3*v^2+3*w^2,
  3*u*v*r^2*p*j^2*w*(v*w+u*v+u*w),
  -u*v^3-u*w^3-v*w^3+u^2*v^2+u^2*w^2+v^2*w^2-u^3*v-u^3*w-v^3*w,
  v*w+u*v+u*w, u^2*j^2*p*r^2*v^2*w^2*(v*w+u*v+u*w),
  u^4*j*p^2*r^4*v^4*w^4*(v*w+u*v+u*w),
  3*u^2*v^2*w^2-2*u^3*v^3-2*w^3*u^3-2*w^3*v^3, 
  -j^2*p*r^2*u^2*v^2*w^2*(-3*u^2*v^2*w^2+2*u^3*v^3+2*w^3*u^3+2*w^3*v^3),
  -j*p^2*r^4*u^4*v^4*w^4*(-3*u^2*v^2*w^2+2*u^3*v^3+2*w^3*u^3+2*w^3*v^3),
  -u*v*w, -j^2*p*r^2*u*v*w, j*p*r*u*v*w, r^3*u^3*v^3*w^3,
  -j^2*p^4*r^8*u^9*v^9*w^9, j*r*u*v*w]*c;end;
  r:=para[1][1]; p:=para[1][2]; u:=para[2][1]; v:=para[2][2]; w:=para[2][3];
  res.irreducibles:=
 [f10(r,u), f10(p,u), f10(p,w), f10(p,v), f10(r,w), f10(r,v),
  f23(p,r,v,w,u), f23(r,p,v,w,u), f23(p,r,u,v,w),
  f23(r,p,u,v,w), f23(p,r,u,w,v), f23(r,p,u,w,v),
  f36(r,p,u,v,w), f36(p,r,u,v,w),
  f31(p,r,v,u,w), f31(r,p,v,u,w), f31(p,r,u,w,v),
  f31(r,p,u,w,v), f31(p,r,w,v,u), f31(r,p,w,v,u),
  f31(p,r,w,u,v), f31(r,p,w,u,v), f31(p,r,u,v,w),
  f31(r,p,u,v,w), f31(p,r,v,w,u), f31(r,p,v,w,u),
  f62(r,p,w,u,v), f62(p,r,w,u,v), f62(r,p,v,w,u),
  f62(p,r,v,w,u), f62(r,p,u,v,w), f62(p,r,u,v,w),
  f62(r,p,v,u,w), f62(p,r,v,u,w), f62(r,p,w,v,u),
  f62(p,r,w,v,u), f62(r,p,u,w,v), f62(p,r,u,w,v),
  f83(r,p,u,v,w,1), f83(r,p,u,v,w,-1), f83(r,p,w,v,u,-1),
  f83(r,p,w,v,u,1), f83(r,p,v,u,w,1), f83(r,p,v,u,w,-1),
  f97(p,r,u,v,w,E(3)^2), f97(r,p,u,v,w,E(3)^2),
  f97(p,r,u,v,w,E(3)), f97(r,p,u,v,w,E(3))];
  return CHEVIE.compat.MakeCharacterTable(res);
end);

CHEVIE.AddData("CharTable","G26",function()
  return CHEVIE.RawData("HeckeCharTable","G26")(
                                 [[1,-1],[1,E(3),E(3)^2],[1,E(3),E(3)^2]],[]);
end);

# description of fake degrees by powers of q
CHEVIE.AddData("sparseFakeDegrees","G26",
[[1,0],[1,9],[1,33],[1,21],[1,24],[1,12],[1,24,1,30],[1,15,1,21],[1,12,1,18],
[1,3,1,9],[1,18,1,24],[1,9,1,15],[1,6,1,12,1,18],[1,15,1,21,1,27],[1,8,1,14,1,
20],[1,5,1,11,1,17],[1,8,1,14,1,20],[1,5,1,11,1,17],[1,20,1,26,1,32],[1,17,1,
23,1,29],[1,16,1,22,1,28],[1,13,1,19,1,25],[1,4,1,10,1,16],[1,1,1,7,1,13],[1,
16,1,22,1,28],[1,13,1,19,1,25],[1,8,2,14,2,20,1,26],[1,11,2,17,2,23,1,29],[1,
8,2,14,2,20,1,26],[1,11,2,17,2,23,1,29],[1,2,2,8,2,14,1,20],[1,5,2,11,2,17,1,
23],[1,4,2,10,2,16,1,22],[1,7,2,13,2,19,1,25],[1,10,2,16,2,22,1,28],[1,13,2,
19,2,25,1,31],[1,4,2,10,2,16,1,22],[1,7,2,13,2,19,1,25],[2,6,3,12,2,18,1,24],
[1,3,2,9,3,15,2,21],[1,9,2,15,3,21,2,27],[2,12,3,18,2,24,1,30],[1,6,2,12,3,18,
2,24],[2,9,3,15,2,21,1,27],[1,8,3,14,3,20,2,26],[1,5,3,11,3,17,2,23],[2,10,3,
16,3,22,1,28],[2,7,3,13,3,19,1,25]]);

# The data below was computed by Maria Chlouveraki
CHEVIE.AddData("SchurModels","G26",rec(
f1_0:=rec(coeff:=-1,
 vcyc:=[[[1,-1,0,0,0],1],[[0,0,1,-1,0],1],[[0,0,1,0,-1],1],[[1,-1,1,-1,0],2],
   [[1,-1,1,0,-1],2],[[1,-1,2,-2,0],1],[[1,-1,2,0,-2],1],[[1,-1,3,-2,-1],2],
   [[1,-1,3,-1,-2],2],[[1,-1,2,-1,-1],6],[[0,0,2,-1,-1],2],[[0,0,1,-1,0],6],
   [[0,0,1,0,-1],6]]),
f2_3:=rec(factor:=[0,0,-1,1,0],
 vcyc:=[[[1,-1,0,0,0],1],[[0,0,1,0,-1],1],[[0,0,0,1,-1],1],[[1,-1,1,0,-1],1],
   [[1,-1,0,1,-1],1],[[1,-1,1,0,-1],2],[[1,-1,0,1,-1],2],[[1,-1,1,-1,0],2],
   [[1,-1,-1,1,0],2],[[1,-1,1,1,-2],6],[[0,0,1,1,-2],2],[[0,0,1,-1,0],6]]),
f3_1:=rec(coeff:=-1,
 vcyc:=[[[-1,1,0,0,0],1],[[0,0,1,-1,0],1],[[0,0,1,0,-1],1],[[0,0,1,0,-1],2],
   [[0,0,0,1,-1],1],[[0,0,1,1,-2],2],[[0,0,2,-1,-1],2],[[0,0,1,0,-1],6],
   [[1,-1,1,0,-1],2],[[1,-1,-1,1,0],2],[[1,-1,2,-2,0],1],[[1,-1,2,1,-3],2]]),
f3_6:=rec(coeff:=-1,
 vcyc:=[[[1,-1,0,0,0],1],[[1,-1,0,0,0],3],[[1,-1,1,-1,0],2],[[1,-1,1,0,-1],2],
   [[1,-1,-1,1,0],2],[[1,-1,0,1,-1],2],[[1,-1,-1,0,1],2],[[1,-1,0,-1,1],2],
   [[0,0,1,1,-2],2],[[0,0,1,-2,1],2],[[0,0,-2,1,1],2]]),
f6_2:=rec(
 vcyc:=[[[1,-1,0,0,0],1],[[0,0,-1,1,0],1],[[0,0,1,0,-1],1],[[0,0,0,1,-1],1],
   [[0,0,-1,0,1],2],[[0,0,1,0,-1],6],[[0,0,1,-2,1],2],[[1,-1,0,1,-1],1],
   [[-1,1,1,0,-1],2],[[1,-1,0,1,-1],2],[[1,-1,3,-2,-1],2]]),
f8_3:=rec(coeff:=2,root:=[1,1,0,1,1]/2,rootCoeff:=-1,
 vcyc:=[[[0,0,1,-1,0],1],[[0,0,1,0,-1],1],[[-1,1,0,-1,1],2],[[-1,1,0,1,-1],2],
   [[0,-1,1,0,-2,1],2],[[0,-1,1,-2,0,1],2],[[0,-1,-1,-1,1,1],1],
   [[0,-1,-1,1,-1,1],1],[[0,-1,1,-1,-1,1],3],[[-1,0,1,-1,-1,1],3]]),
f9_7:=rec(rootUnity:=E(3),
 vcyc:=[[[0,0,0,0,0,2],1],[[0,0,1,-1,0],6],[[0,0,-1,0,1],6],[[0,0,0,1,-1],6],
   [[1,-1,-2,1,1,1],2],[[1,-1,1,-2,1,1],2],[[1,-1,1,1,-2,1],2],
   [[-1,1,0,0,0],1],[[1,-1,0,0,0,1],1]])));

CHEVIE.AddData("SchurData","G26",[
  rec(name:="f1_0",order:=[1,2,3,4,5]), rec(name:="f1_0",order:=[2,1,3,4,5]), 
  rec(name:="f1_0",order:=[2,1,5,4,3]), rec(name:="f1_0",order:=[2,1,4,3,5]),
  rec(name:="f1_0",order:=[1,2,5,4,3]), rec(name:="f1_0",order:=[1,2,4,3,5]), 
  rec(name:="f2_3",order:=[2,1,4,5,3]), rec(name:="f2_3",order:=[1,2,4,5,3]),
  rec(name:="f2_3",order:=[2,1,3,4,5]), rec(name:="f2_3",order:=[1,2,3,4,5]),
  rec(name:="f2_3",order:=[2,1,3,5,4]), rec(name:="f2_3",order:=[1,2,3,5,4]),
  rec(name:="f3_6",order:=[1,2,3,4,5]), rec(name:="f3_6",order:=[2,1,3,4,5]), 
  rec(name:="f3_1",order:=[2,1,4,3,5]), rec(name:="f3_1",order:=[1,2,4,3,5]),
  rec(name:="f3_1",order:=[2,1,3,5,4]), rec(name:="f3_1",order:=[1,2,3,5,4]),
  rec(name:="f3_1",order:=[2,1,5,4,3]), rec(name:="f3_1",order:=[1,2,5,4,3]),
  rec(name:="f3_1",order:=[2,1,5,3,4]), rec(name:="f3_1",order:=[1,2,5,3,4]),
  rec(name:="f3_1",order:=[2,1,3,4,5]), rec(name:="f3_1",order:=[1,2,3,4,5]),
  rec(name:="f3_1",order:=[2,1,4,5,3]), rec(name:="f3_1",order:=[1,2,4,5,3]), 
  rec(name:="f6_2",order:=[1,2,5,3,4]), rec(name:="f6_2",order:=[2,1,5,3,4]),
  rec(name:="f6_2",order:=[1,2,4,5,3]), rec(name:="f6_2",order:=[2,1,4,5,3]),
  rec(name:="f6_2",order:=[1,2,3,4,5]), rec(name:="f6_2",order:=[2,1,3,4,5]),
  rec(name:="f6_2",order:=[1,2,4,3,5]), rec(name:="f6_2",order:=[2,1,4,3,5]),
  rec(name:="f6_2",order:=[1,2,5,4,3]), rec(name:="f6_2",order:=[2,1,5,4,3]),
  rec(name:="f6_2",order:=[1,2,3,5,4]), rec(name:="f6_2",order:=[2,1,3,5,4]),
  rec(name:="f8_3",order:=[1,2,3,4,5],rootPower:=-1), 
  rec(name:="f8_3",order:=[1,2,3,4,5],rootPower:=1),
  rec(name:="f8_3",order:=[1,2,5,4,3],rootPower:=1),
  rec(name:="f8_3",order:=[1,2,5,4,3],rootPower:=-1),
  rec(name:="f8_3",order:=[1,2,4,3,5],rootPower:=-1),
  rec(name:="f8_3",order:=[1,2,4,3,5],rootPower:=1), #44
  rec(name:="f9_7",order:=[2,1,3,4,5],rootUnityPower:=2),
  rec(name:="f9_7",order:=[1,2,3,4,5],rootUnityPower:=2),
  rec(name:="f9_7",order:=[2,1,3,4,5],rootUnityPower:=1),
  rec(name:="f9_7",order:=[1,2,3,4,5],rootUnityPower:=1)]);

CHEVIE.AddData("HeckeRepresentation","G26",function(para,root,i)
  local x,y,u,v,w,f10,f23,f31,f36,f6,f8,f9,rep;
  x:=para[1][1];y:=para[1][2];
  u:=para[2][1];v:=para[2][2];w:=para[2][3];
  f10:=function(x,u)return [[[x]],[[u]],[[u]]];end;
  f23:=function(x,u,v) return 
    [[[x,0],[0,x]],[[u,0],[-u,v]],[[v,v],[0,u]]];end;
  f36:=x->[[[x,0,0],[0,x,0],[0,0,x]],[[w,0,0],[u*w+v^2,v,0],[v,1,u]],
           [[u,-1,v],[0,v,-u*w-v^2],[0,0,w]]];
  f31:=function(x,y,u,v)return [[[y,0,0],[0,y,-u*y-v*x],[0,0,x]],
   [[v,v,0],[0,u,0],[0,1,v]],[[u,0,0],[-u,v,0],[0,0,v]]];end;
  f6:=function(r,p,u,v,w)return
  [[[r,0,0,0,0,0],[0,r,0,0,0,r*u*w+p*w^2],[0,0,r,0,p*w+r*u,-p*w-r*u],[0,0,0,r,
p*w^2-r*v^2,r*v*w+r*v^2],[0,0,0,0,p,0],[0,0,0,0,0,p]],[[w,-1,v,0,0,0],[0,v,
-u*w-v^2,0,0,0],[0,0,u,0,0,0],[0,0,-v*w-v^2,v,0,0],[0,0,0,-w^-1,w,0],[0,0,1,
-w^-1,0,w]],[[u,0,0,0,0,0],[u*w+v^2,v,0,0,0,0],[v,1,w,0,0,0],[v*w,0,0,w,0,
v*w^2],[0,0,0,0,w,v],[0,0,0,0,0,v]]];end;
  f8:=function(r,p,u,v,w,sgn)local s; s:=sgn*GetRoot(-p*r*v*w); return
[[[p,0,0,0,0,0,0,0],[0,p,0,0,0,0,0,0],[0,0,p,0,0,0,0,0],[0,0,0,p,0,0,0,0],[0,
0,-p,0,r,0,0,0],[0,-p*u^2*v^-1*w^-1,p*u*v^-1-p*u*w^-1,0,0,r,0,0],[0,0,p+
p*u*v^-1,-p+s*v^-1,0,0,r,0],[p*u*v^-1+s*u*v^-1*w^-1,0,p+s*v^-1+s*u*v^-2+
p*u*v^-1-r*u*v^-1+s*u*v^-1*w^-1,0,0,0,0,r]],[[u,0,0,0,0,0,0,0],[u^-1*w^2+v,w,
0,0,p^-2*r*s-u^-2*v*w^2-p^-1*s-p^-1*s*u^-2*w^2-p^-1*s*u^-1*v^-1*w^2-p^-1*s*u^-
1*v-p^-1*s*u^-1*w+p^-1*r*u^-1*v*w+p^-1*r*u^-1*w^2+2*p^-1*r*w-u^-1*v*w,u^-
2*v*w^2+p^-1*r*u^-1*v*w,0,-u^-2*v*w^2-p^-1*s*u^-1*v],[w,u,v,0,-p^-1*s-p^-
1*s*u^-1*w-p^-1*s*v^-1*w+p^-1*r*u+p^-1*r*w-u^-1*v*w,u^-1*v*w,0,-u^-1*v*w],[0,
0,0,v,0,-p^-1*s,p^-1*s+v,-v],[0,0,0,0,u,0,0,0],[0,0,0,0,0,u,0,0],[0,0,0,0,p^-
1*s*u*v^-1+r^-1*s*u*v^-1-u+w+u*v^-1*w-u^2*v^-1,-w,w,0],[0,0,0,0,0,0,0,u]],[[v,
-u,w,p^-1*s,0,0,0,0],[0,w,-u^-1*w^2-v,-p^-1*s*u^-1*w+u^-1*v*w,0,0,0,0],[0,0,u,
0,0,0,0,0],[0,0,0,u,0,0,0,0],[0,0,0,0,u,0,0,0],[0,0,0,0,0,w,u,0],[0,0,0,0,0,0,
u,0],[0,0,0,u,p^-1*s-p^-1*r*u-p^-1*s*u^2*v^-2+p^-1*r*u^2*v^-1-p^-1*s*u^2*v^-
1*w^-1+v,p^-1*s+w,u,v]]];end;
  f9:=function(r,p,u,v,w,j)return [[[p,0,0,0,0,0,0,0,0],[0,p,0,0,0,0,0,0,0],
  [0,0,p,0,0,0,0,0,0],[0,0,0,p,0,0,0,0,0],
  [-j^2*p*u,j^2*p*u^-1*v,-j^2*p*u^-1*v^2+j*p*v+r*w,r*u^-1*w,r,j*w,0,1,0],
  [0,0,0,0,0,p,0,0,0],[0,-p*u-j^2*p*v,-j*p*u*v-r*u*w+j^2*p*v^2,-r*w,0,0,r,-u,0],
  [0,0,0,0,0,0,0,p,0],[0,0,-j*p*u+r*u,r,0,0,0,0,r]],[[w,0,0,0,0,0,0,0,0],
  [u*w+v^2,v,0,0,v,0,u^-1*v,0,0],[v,1,u,0,1,0,u^-1,0,j^2],
  [0,0,0,u,-u,0,0,0,-j^2*u-v],[0,0,0,0,w,0,0,0,0],
  [-j^2*p*v-j^2*r*u+j*r*v-j*p*u*v*w^-1+j^2*p*v^2*w^-1,0,0,0,
   -j^2*r,v,-j^2*r*u^-1,0,0],[0,0,0,0,0,0,w,0,0],
  [-j*p*u*v-j^2*p*v*w-j^2*r*u*w-r*v*w+j^2*p*v^2,p*u+j^2*p*v-r*w,0,0,0,
   v*w,p,u,r*u^-1*v*w+j*p*u^-1*v^2-p*v],[0,0,0,0,0,0,-1,0,v]],
 [[u,-1,v,0,0,0,0,0,0],[0,v,-u*w-v^2,-w,0,0,0,0,0],[0,0,w,0,0,0,0,0,0],
  [0,0,0,w,0,0,0,0,0],[0,0,0,w,u,0,-j^2-u^-1*v,0,-u^-1*v*w-j^2*w],
  [0,0,j^2*r*u,0,0,u,0,-u*w^-1,0],[0,0,0,0,0,0,v,0,v*w],
  [0,0,j^2*p*u^-1*v^2*w+p*u*w+j^2*p*v*w-j^2*p*v^2-r*w^2,
   j^2*p*u^-1*v*w-r*u^-1*w^2+p*w,0,0,0,v,0],[0,0,0,0,0,0,0,0,w]]];end;
  rep:=[[f10,x,u],[f10,y,u],[f10,y,w],[f10,y,v],[f10,x,w],[f10,x,v],
    [f23,y,v,w],[f23,x,v,w],[f23,y,u,v],[f23,x,u,v],[f23,y,u,w],[f23,x,u,w],
    [f36,x],[f36,y],[f31,x,y,u,v],[f31,y,x,u,v],[f31,x,y,w,u],[f31,y,x,w,u],
    [f31,x,y,v,w],[f31,y,x,v,w],[f31,x,y,u,w],[f31,y,x,u,w],[f31,x,y,v,u],
    [f31,y,x,v,u],[f31,x,y,w,v],[f31,y,x,w,v],
    [f6,x,y,v,u,w], [f6,y,x,v,u,w], [f6,x,y,u,w,v], [f6,y,x,u,w,v],
    [f6,x,y,w,v,u], [f6,y,x,w,v,u], [f6,x,y,w,u,v], [f6,y,x,w,u,v], 
    [f6,x,y,u,v,w], [f6,y,x,u,v,w], [f6,x,y,v,w,u], [f6,y,x,v,w,u],
    [f8,x,y,u,v,w,-1],[f8,x,y,u,v,w,1],[f8,x,y,w,v,u,1],
    [f8,x,y,w,v,u,-1],[f8,x,y,v,u,w,-1], [f8,x,y,v,u,w,1],
    [f9,x,y,u,v,w,E(3)^2],[f9,y,x,u,v,w,E(3)^2],
    [f9,x,y,u,v,w,E(3)],[f9,y,x,u,v,w,E(3)]];
  if IsBound(rep[i]) then return
    ApplyFunc(rep[i][1],rep[i]{[2..Length(rep[i])]})+0*Product(para,Product);
  else return false;fi;
end);

CHEVIE.AddData("UnipotentCharacters","G26",function()
  local i3,J;J:=E(3);i3:=ER(-3);
  return rec(
  harishChandra:=[
    rec(relativeType:=rec(series:="ST",indices:=[1..3],rank:=3,ST:=26),
        levi:=[],parameterExponents:=[1,1,1],
        charNumbers:=[1..48], eigenvalue:=1, cuspidalName:=""),
#   rec(relativeType:=rec(series:="ST",indices:=[1,69,65],rank:=2,p:=6,q:=2),
    rec(relativeType:=rec(series:="ST",indices:=[1,3,13],rank:=2,p:=6,q:=2),
        levi:=[2],
        parameterExponents:=[[0,2,2],3,1],
	charNumbers:=[102,68,71,66,53,70,60,67,54,103,69,72,99,59,98,65,50,49],
	eigenvalue:=J^2,
	cuspidalName:=ImprimitiveCuspidalName([[],[0,1],[0,1]])),
    rec(relativeType:=rec(series:="ST",indices:=[1],rank:=1,p:=6,q:=1),
        levi:=[2..3],
        parameterExponents:=[[ 3, 4, 3, 0, 3, 4 ]],
        charNumbers:=[ 73, 61, 74, 104, 75, 62 ], eigenvalue:=-1,
	cuspidalName:="G_4"),
    rec(relativeType:=rec(series:="ST",indices:=[3],rank:=1,p:=6,q:=1),
        levi:=[1..2],
        parameterExponents:=[[4,3,1,1,0,1]],
        charNumbers:=[51,55,76,81,100,78],
	eigenvalue:=J,
	cuspidalName:=ImprimitiveCuspidalName([[0],[],[0,1,2]])),
    rec(relativeType:=rec(series:="ST",indices:=[3],rank:=1,p:=6,q:=1),
        levi:=[1..2],
        parameterExponents:=[[4,1,0,1,1,3]],
        charNumbers:=[52,79,101,80,77,56],
	eigenvalue:=J,
	cuspidalName:=ImprimitiveCuspidalName([[0],[0,1,2],[]])),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[92], eigenvalue:=1, cuspidalName:="G_{26}[1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[93], eigenvalue:=1, cuspidalName:="G_{26}^2[1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[94], eigenvalue:=1, cuspidalName:="G_{26}^3[1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[82], eigenvalue:=-1, cuspidalName:="G_{26}[-1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[83], eigenvalue:=-1, cuspidalName:="G_{26}^2[-1]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[88], eigenvalue:=E(3), cuspidalName:="G_{26}[\\zeta_3]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[89], eigenvalue:=E(3),cuspidalName:="G_{26}^2[\\zeta_3]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[64], eigenvalue:=E(3)^2, 
	cuspidalName:="G_{26}[\\zeta_{3}^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[84], eigenvalue:=E(3)^2, 
	cuspidalName:="G_{26}^2[\\zeta_3^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[85], eigenvalue:=E(3)^2, 
	cuspidalName:="G_{26}^3[\\zeta_3^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[90], eigenvalue:=-E(3), 
	cuspidalName:="G_{26}[-\\zeta_3]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[91], eigenvalue:=-E(3), 
	cuspidalName:="G_{26}^2[-\\zeta_3]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[63], eigenvalue:=-E(3)^2, 
	cuspidalName:="G_{26}[-\\zeta_{3}^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[86], eigenvalue:=-E(3)^2, 
	cuspidalName:="G_{26}^2[-\\zeta_3^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[87], eigenvalue:=-E(3)^2, 
	cuspidalName:="G_{26}^3[-\\zeta_3^2]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[57], eigenvalue:=E(4), 
	cuspidalName:="G_{26}[i]",qEigen:=1/2),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[58], eigenvalue:=-E(4), 
	cuspidalName:="G_{26}[-i]",qEigen:=1/2),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[95], eigenvalue:=E(9)^8, 
	cuspidalName:="G_{26}[\\zeta_9^8]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[96], eigenvalue:=E(9)^5, 
	cuspidalName:="G_{26}[\\zeta_9^5]"),
    rec(relativeType:=rec(series:="A",indices:=[],rank:=0),
        levi:=[1..3],parameterExponents:=[],
        charNumbers:=[97], eigenvalue:=E(9)^2, 
	cuspidalName:="G_{26}[\\zeta_9^2]")
  ],
  families:=[
   Family("C1",[1]),
   Family(CHEVIE.families.QZ(3),[2,18,24,12,51,49,10,50,52],
     rec(signs:=[1,1,1,-1,-1,1,-1,-1,-1],special:=3,cospecial:=2)),
   Family(CHEVIE.families.QZ(3),[13,17,23,37,56,53,31,54,55],
     rec(signs:=[1,-1,-1,1,-1,-1,1,1,-1],special:=7,cospecial:=4)),
  ## Changed from C'\"2 to C2h by Gunter on 26.2.2003, and back on 27.2.2003:
   Family("C'\"2",[ 40, 39, 57, 58 ]),
   Family(Family("C2")*CHEVIE.families.X(3),
     [ 33, 27, 59, 22, 16, 60, 48, 46, 64, 61, 62, 63 ],
     rec(signs:=[ 1, 1, -1, -1, -1, -1, 1, 1, 1, -1, -1, 1 ])),
   Family(CHEVIE.families.X(3),[32,38,65],rec(signs:=[1,1,-1])),
   Family(rec( fourierMat:=
[[-ER(-3),ER(-3),-9*E(3)^2,-9*E(3),9,9,9,(3-ER(-3))*3,(3+ER(-3))*3,
(3-ER(-3))*3/2,(3+ER(-3))*3/2,(3-ER(-3))*3/2,(3+ER(-3))*3/2,ER(-3),-ER(-3),
ER(-3)*2,-ER(-3)*2,(-3+ER(-3))*3,(3+ER(-3))*3,ER(-3)*6,(3+ER(-3))*3/2,
(-3+ER(-3))*3/2,9*E(3),-9*E(3)^2,9,9*E(3)^2,9*E(3),-9*E(3),-9*E(3)^2,
(-3-ER(-3))*3/2,(-3+ER(-3))*3/2,(3+ER(-3))*3,(3-ER(-3))*3,-9,-9,
(3+ER(-3))*3/2,(-3+ER(-3))*3/2,9*E(3),-9*E(3)^2,(3+ER(-3))*3/2,
(-3+ER(-3))*3/2,9*E(3),9*E(3)^2,ER(-3)*2,ER(-3),ER(-3),ER(-3)*6,ER(-3)*6,
ER(-3)*6],[ER(-3),-ER(-3),-9*E(3),-9*E(3)^2,9,9,9,(3+ER(-3))*3,(3-ER(-3))*3,
(3+ER(-3))*3/2,(3-ER(-3))*3/2,(3+ER(-3))*3/2,(3-ER(-3))*3/2,-ER(-3),ER(-3),
-ER(-3)*2,ER(-3)*2,(-3-ER(-3))*3,(3-ER(-3))*3,-ER(-3)*6,(3-ER(-3))*3/2,
(-3-ER(-3))*3/2,9*E(3)^2,-9*E(3),9,9*E(3),9*E(3)^2,-9*E(3)^2,-9*E(3),
(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,(3-ER(-3))*3,(3+ER(-3))*3,-9,-9,
(3-ER(-3))*3/2,(-3-ER(-3))*3/2,9*E(3)^2,-9*E(3),(3-ER(-3))*3/2,
(-3-ER(-3))*3/2,9*E(3)^2,9*E(3),-ER(-3)*2,-ER(-3),-ER(-3),-ER(-3)*6,-ER(-3)*6,
-ER(-3)*6],[-9*E(3)^2,-9*E(3),9,9,-9,-9*E(3),-9*E(3)^2,0,0,-9,-9,9,9,-9,-9,0,
0,0,0,0,-9*E(3),9*E(3)^2,-9*E(3),9*E(3)^2,9,9,9,9*E(3)^2,9*E(3),9*E(3)^2,
9*E(3),0,0,-9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3)^2,
-9*E(3),9*E(3)^2,9*E(3),0,9*E(3),-9*E(3)^2,0,0,0],[-9*E(3),-9*E(3)^2,9,9,-9,
-9*E(3)^2,-9*E(3),0,0,-9,-9,9,9,-9,-9,0,0,0,0,0,-9*E(3)^2,9*E(3),-9*E(3)^2,
9*E(3),9,9,9,9*E(3),9*E(3)^2,9*E(3),9*E(3)^2,0,0,-9*E(3)^2,-9*E(3),9*E(3)^2,
-9*E(3),9*E(3)^2,-9*E(3),9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,0,9*E(3)^2,-9*E(3),
0,0,0],[9,9,-9,-9,9,9,9,0,0,9,9,-9,-9,9,9,0,0,0,0,0,9,-9,9,-9,-9,-9,-9,-9,-9,
-9,-9,0,0,9,9,-9,9,-9,9,-9,9,-9,-9,0,-9,9,0,0,0],[9,9,-9*E(3),-9*E(3)^2,9,9,9,
0,0,9*E(3),9*E(3)^2,-9*E(3),-9*E(3)^2,9,9,0,0,0,0,0,9*E(3)^2,-9*E(3),9*E(3)^2,
-9*E(3),-9,-9*E(3),-9*E(3)^2,-9*E(3)^2,-9*E(3),-9*E(3)^2,-9*E(3),0,0,9,9,
-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,-9*E(3),0,-9,9,0,
0,0],[9,9,-9*E(3)^2,-9*E(3),9,9,9,0,0,9*E(3)^2,9*E(3),-9*E(3)^2,-9*E(3),9,9,0,
0,0,0,0,9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,-9,-9*E(3)^2,-9*E(3),-9*E(3),
-9*E(3)^2,-9*E(3),-9*E(3)^2,0,0,9,9,-9*E(3),9*E(3)^2,-9*E(3),9*E(3)^2,-9*E(3),
9*E(3)^2,-9*E(3),-9*E(3)^2,0,-9,9,0,0,0],[(3-ER(-3))*3,(3+ER(-3))*3,0,0,0,0,0,
18,18,0,0,0,0,-ER(-3)*6,ER(-3)*6,(-3-ER(-3))*3,(-3+ER(-3))*3,-18*E(3)^2,
18*E(3),0,0,0,0,0,0,0,0,0,0,0,0,18*E(3)^2,18*E(3),0,0,0,0,0,0,0,0,0,0,
ER(-3)*6,(3+ER(-3))*3,(-3+ER(-3))*3,0,0,0],[(3+ER(-3))*3,(3-ER(-3))*3,0,0,0,0,
0,18,18,0,0,0,0,ER(-3)*6,-ER(-3)*6,(-3+ER(-3))*3,(-3-ER(-3))*3,-18*E(3),
18*E(3)^2,0,0,0,0,0,0,0,0,0,0,0,0,18*E(3),18*E(3)^2,0,0,0,0,0,0,0,0,0,0,
-ER(-3)*6,(3-ER(-3))*3,(-3-ER(-3))*3,0,0,0],[(3-ER(-3))*3/2,(3+ER(-3))*3/2,-9,
-9,9,9*E(3),9*E(3)^2,0,0,9,9,9,9,-ER(-3)*3,ER(-3)*3,(3+ER(-3))*3,(3-ER(-3))*3,
0,0,0,9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9,9,9,-9*E(3)^2,-9*E(3),-9*E(3)^2,
-9*E(3),0,0,-9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3)^2,
-9*E(3),9*E(3)^2,9*E(3),-ER(-3)*6,(3+ER(-3))*3/2,(-3+ER(-3))*3/2,0,0,0],
[(3+ER(-3))*3/2,(3-ER(-3))*3/2,-9,-9,9,9*E(3)^2,9*E(3),0,0,9,9,9,9,ER(-3)*3,
-ER(-3)*3,(3-ER(-3))*3,(3+ER(-3))*3,0,0,0,9*E(3)^2,-9*E(3),9*E(3)^2,-9*E(3),9,
9,9,-9*E(3),-9*E(3)^2,-9*E(3),-9*E(3)^2,0,0,-9*E(3)^2,-9*E(3),9*E(3)^2,
-9*E(3),9*E(3)^2,-9*E(3),9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,ER(-3)*6,
(3-ER(-3))*3/2,(-3-ER(-3))*3/2,0,0,0],[(3-ER(-3))*3/2,(3+ER(-3))*3/2,9,9,-9,
-9*E(3),-9*E(3)^2,0,0,9,9,9,9,-ER(-3)*3,ER(-3)*3,(3+ER(-3))*3,(3-ER(-3))*3,0,
0,0,9*E(3),-9*E(3)^2,-9*E(3),9*E(3)^2,-9,-9,-9,9*E(3)^2,9*E(3),-9*E(3)^2,
-9*E(3),0,0,9*E(3),9*E(3)^2,9*E(3),-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3)^2,
-9*E(3),-9*E(3)^2,-9*E(3),-ER(-3)*6,(3+ER(-3))*3/2,(-3+ER(-3))*3/2,0,0,0],
[(3+ER(-3))*3/2,(3-ER(-3))*3/2,9,9,-9,-9*E(3)^2,-9*E(3),0,0,9,9,9,9,ER(-3)*3,
-ER(-3)*3,(3-ER(-3))*3,(3+ER(-3))*3,0,0,0,9*E(3)^2,-9*E(3),-9*E(3)^2,9*E(3),
-9,-9,-9,9*E(3),9*E(3)^2,-9*E(3),-9*E(3)^2,0,0,9*E(3)^2,9*E(3),9*E(3)^2,
-9*E(3),-9*E(3)^2,9*E(3),9*E(3),-9*E(3)^2,-9*E(3),-9*E(3)^2,ER(-3)*6,
(3-ER(-3))*3/2,(-3-ER(-3))*3/2,0,0,0],[ER(-3),-ER(-3),-9,-9,9,9,9,-ER(-3)*6,
ER(-3)*6,-ER(-3)*3,ER(-3)*3,-ER(-3)*3,ER(-3)*3,-ER(-3),ER(-3),-ER(-3)*2,
ER(-3)*2,ER(-3)*6,ER(-3)*6,-ER(-3)*6,ER(-3)*3,ER(-3)*3,9,-9,9,9,9,-9,-9,
-ER(-3)*3,ER(-3)*3,ER(-3)*6,-ER(-3)*6,-9,-9,ER(-3)*3,ER(-3)*3,9,-9,ER(-3)*3,
ER(-3)*3,9,9,-ER(-3)*2,-ER(-3),-ER(-3),-ER(-3)*6,-ER(-3)*6,-ER(-3)*6],
[-ER(-3),ER(-3),-9,-9,9,9,9,ER(-3)*6,-ER(-3)*6,ER(-3)*3,-ER(-3)*3,ER(-3)*3,
-ER(-3)*3,ER(-3),-ER(-3),ER(-3)*2,-ER(-3)*2,-ER(-3)*6,-ER(-3)*6,ER(-3)*6,
-ER(-3)*3,-ER(-3)*3,9,-9,9,9,9,-9,-9,ER(-3)*3,-ER(-3)*3,-ER(-3)*6,ER(-3)*6,-9,
-9,-ER(-3)*3,-ER(-3)*3,9,-9,-ER(-3)*3,-ER(-3)*3,9,9,ER(-3)*2,ER(-3),ER(-3),
ER(-3)*6,ER(-3)*6,ER(-3)*6],[ER(-3)*2,-ER(-3)*2,0,0,0,0,0,(-3-ER(-3))*3,
(-3+ER(-3))*3,(3+ER(-3))*3,(3-ER(-3))*3,(3+ER(-3))*3,(3-ER(-3))*3,-ER(-3)*2,
ER(-3)*2,-ER(-3)*4,ER(-3)*4,(3+ER(-3))*3,(-3+ER(-3))*3,-ER(-3)*12,
(3-ER(-3))*3,(-3-ER(-3))*3,0,0,0,0,0,0,0,(-3+ER(-3))*3,(-3-ER(-3))*3,
(-3+ER(-3))*3,(-3-ER(-3))*3,0,0,(3-ER(-3))*3,(-3-ER(-3))*3,0,0,(3-ER(-3))*3,
(-3-ER(-3))*3,0,0,-ER(-3)*4,-ER(-3)*2,-ER(-3)*2,ER(-3)*6,ER(-3)*6,ER(-3)*6],
[-ER(-3)*2,ER(-3)*2,0,0,0,0,0,(-3+ER(-3))*3,(-3-ER(-3))*3,(3-ER(-3))*3,
(3+ER(-3))*3,(3-ER(-3))*3,(3+ER(-3))*3,ER(-3)*2,-ER(-3)*2,ER(-3)*4,-ER(-3)*4,
(3-ER(-3))*3,(-3-ER(-3))*3,ER(-3)*12,(3+ER(-3))*3,(-3+ER(-3))*3,0,0,0,0,0,0,0,
(-3-ER(-3))*3,(-3+ER(-3))*3,(-3-ER(-3))*3,(-3+ER(-3))*3,0,0,(3+ER(-3))*3,
(-3+ER(-3))*3,0,0,(3+ER(-3))*3,(-3+ER(-3))*3,0,0,ER(-3)*4,ER(-3)*2,ER(-3)*2,
-ER(-3)*6,-ER(-3)*6,-ER(-3)*6],[(-3+ER(-3))*3,(-3-ER(-3))*3,0,0,0,0,0,
-18*E(3)^2,-18*E(3),0,0,0,0,ER(-3)*6,-ER(-3)*6,(3+ER(-3))*3,(3-ER(-3))*3,
18*E(3),-18*E(3)^2,0,0,0,0,0,0,0,0,0,0,0,0,-18,-18,0,0,0,0,0,0,0,0,0,0,
-ER(-3)*6,(-3-ER(-3))*3,(3-ER(-3))*3,0,0,0],[(3+ER(-3))*3,(3-ER(-3))*3,0,0,0,
0,0,18*E(3),18*E(3)^2,0,0,0,0,ER(-3)*6,-ER(-3)*6,(-3+ER(-3))*3,(-3-ER(-3))*3,
-18*E(3)^2,18*E(3),0,0,0,0,0,0,0,0,0,0,0,0,18,18,0,0,0,0,0,0,0,0,0,0,
-ER(-3)*6,(3-ER(-3))*3,(-3-ER(-3))*3,0,0,0],[ER(-3)*6,-ER(-3)*6,0,0,0,0,0,0,0,
0,0,0,0,-ER(-3)*6,ER(-3)*6,-ER(-3)*12,ER(-3)*12,0,0,ER(-3)*18,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-ER(-3)*12,-ER(-3)*6,-ER(-3)*6,0,0,0],
[(3+ER(-3))*3/2,(3-ER(-3))*3/2,-9*E(3),-9*E(3)^2,9,9*E(3)^2,9*E(3),0,0,9*E(3),
9*E(3)^2,9*E(3),9*E(3)^2,ER(-3)*3,-ER(-3)*3,(3-ER(-3))*3,(3+ER(-3))*3,0,0,0,
9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9,9*E(3),9*E(3)^2,-9,-9,-9,-9,0,0,-9*E(3)^2,
-9*E(3),9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,9,-9,9,9,ER(-3)*6,(3-ER(-3))*3/2,
(-3-ER(-3))*3/2,0,0,0],[(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,9*E(3)^2,9*E(3),-9,
-9*E(3),-9*E(3)^2,0,0,-9*E(3)^2,-9*E(3),-9*E(3)^2,-9*E(3),ER(-3)*3,-ER(-3)*3,
(-3-ER(-3))*3,(-3+ER(-3))*3,0,0,0,-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3),-9,
-9*E(3)^2,-9*E(3),9,9,9,9,0,0,9*E(3),9*E(3)^2,-9*E(3)^2,9*E(3),-9*E(3)^2,
9*E(3),-9,9,-9,-9,ER(-3)*6,(-3-ER(-3))*3/2,(3-ER(-3))*3/2,0,0,0],[9*E(3),
9*E(3)^2,-9*E(3),-9*E(3)^2,9,9*E(3)^2,9*E(3),0,0,9*E(3),9*E(3)^2,-9*E(3),
-9*E(3)^2,9,9,0,0,0,0,0,9*E(3),-9*E(3)^2,9*E(3),-9*E(3)^2,-9,-9*E(3),
-9*E(3)^2,-9,-9,-9,-9,0,0,9*E(3)^2,9*E(3),-9*E(3),9*E(3)^2,-9*E(3),9*E(3)^2,
-9,9,-9,-9,0,-9*E(3)^2,9*E(3),0,0,0],[-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),-9,
-9*E(3),-9*E(3)^2,0,0,-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),-9,-9,0,0,0,0,0,
-9*E(3)^2,9*E(3),-9*E(3)^2,9*E(3),9,9*E(3)^2,9*E(3),9,9,9,9,0,0,-9*E(3),
-9*E(3)^2,9*E(3)^2,-9*E(3),9*E(3)^2,-9*E(3),9,-9,9,9,0,9*E(3),-9*E(3)^2,0,0,
0],[9,9,9,9,-9,-9,-9,0,0,9,9,-9,-9,9,9,0,0,0,0,0,9,-9,-9,9,9,9,9,9,9,-9,-9,0,
0,-9,-9,-9,9,9,-9,-9,9,9,9,0,-9,9,0,0,0],[9*E(3)^2,9*E(3),9,9,-9,-9*E(3),
-9*E(3)^2,0,0,9,9,-9,-9,9,9,0,0,0,0,0,9*E(3),-9*E(3)^2,-9*E(3),9*E(3)^2,9,9,9,
9*E(3)^2,9*E(3),-9*E(3)^2,-9*E(3),0,0,-9*E(3),-9*E(3)^2,-9*E(3),9*E(3)^2,
9*E(3),-9*E(3)^2,-9*E(3)^2,9*E(3),9*E(3)^2,9*E(3),0,-9*E(3),9*E(3)^2,0,0,0],
[9*E(3),9*E(3)^2,9,9,-9,-9*E(3)^2,-9*E(3),0,0,9,9,-9,-9,9,9,0,0,0,0,0,
9*E(3)^2,-9*E(3),-9*E(3)^2,9*E(3),9,9,9,9*E(3),9*E(3)^2,-9*E(3),-9*E(3)^2,0,0,
-9*E(3)^2,-9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,-9*E(3),-9*E(3),9*E(3)^2,9*E(3),
9*E(3)^2,0,-9*E(3)^2,9*E(3),0,0,0],[-9*E(3),-9*E(3)^2,9*E(3)^2,9*E(3),-9,
-9*E(3)^2,-9*E(3),0,0,-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),-9,-9,0,0,0,0,0,-9,9,
-9,9,9,9*E(3)^2,9*E(3),9*E(3)^2,9*E(3),9*E(3)^2,9*E(3),0,0,-9*E(3)^2,-9*E(3),
9,-9,9,-9,9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),0,9*E(3)^2,-9*E(3),0,0,0],
[-9*E(3)^2,-9*E(3),9*E(3),9*E(3)^2,-9,-9*E(3),-9*E(3)^2,0,0,-9*E(3),-9*E(3)^2,
9*E(3),9*E(3)^2,-9,-9,0,0,0,0,0,-9,9,-9,9,9,9*E(3),9*E(3)^2,9*E(3),9*E(3)^2,
9*E(3),9*E(3)^2,0,0,-9*E(3),-9*E(3)^2,9,-9,9,-9,9*E(3),-9*E(3)^2,9*E(3),
9*E(3)^2,0,9*E(3),-9*E(3)^2,0,0,0],[(-3-ER(-3))*3/2,(-3+ER(-3))*3/2,9*E(3)^2,
9*E(3),-9,-9*E(3)^2,-9*E(3),0,0,-9*E(3)^2,-9*E(3),-9*E(3)^2,-9*E(3),-ER(-3)*3,
ER(-3)*3,(-3+ER(-3))*3,(-3-ER(-3))*3,0,0,0,-9,9,-9,9,-9,-9*E(3)^2,-9*E(3),
9*E(3)^2,9*E(3),9*E(3)^2,9*E(3),0,0,9*E(3)^2,9*E(3),-9,9,-9,9,-9*E(3)^2,
9*E(3),-9*E(3)^2,-9*E(3),-ER(-3)*6,(-3+ER(-3))*3/2,(3+ER(-3))*3/2,0,0,0],
[(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,9*E(3),9*E(3)^2,-9,-9*E(3),-9*E(3)^2,0,0,
-9*E(3),-9*E(3)^2,-9*E(3),-9*E(3)^2,ER(-3)*3,-ER(-3)*3,(-3-ER(-3))*3,
(-3+ER(-3))*3,0,0,0,-9,9,-9,9,-9,-9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,9*E(3),
9*E(3)^2,0,0,9*E(3),9*E(3)^2,-9,9,-9,9,-9*E(3),9*E(3)^2,-9*E(3),-9*E(3)^2,
ER(-3)*6,(-3-ER(-3))*3/2,(3-ER(-3))*3/2,0,0,0],[(3+ER(-3))*3,(3-ER(-3))*3,0,0,
0,0,0,18*E(3)^2,18*E(3),0,0,0,0,ER(-3)*6,-ER(-3)*6,(-3+ER(-3))*3,
(-3-ER(-3))*3,-18,18,0,0,0,0,0,0,0,0,0,0,0,0,18*E(3)^2,18*E(3),0,0,0,0,0,0,0,
0,0,0,-ER(-3)*6,(3-ER(-3))*3,(-3-ER(-3))*3,0,0,0],[(3-ER(-3))*3,(3+ER(-3))*3,
0,0,0,0,0,18*E(3),18*E(3)^2,0,0,0,0,-ER(-3)*6,ER(-3)*6,(-3-ER(-3))*3,
(-3+ER(-3))*3,-18,18,0,0,0,0,0,0,0,0,0,0,0,0,18*E(3),18*E(3)^2,0,0,0,0,0,0,0,
0,0,0,ER(-3)*6,(3+ER(-3))*3,(-3+ER(-3))*3,0,0,0],[-9,-9,-9*E(3),-9*E(3)^2,9,9,
9,0,0,-9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,-9,-9,0,0,0,0,0,-9*E(3)^2,9*E(3),
9*E(3)^2,-9*E(3),-9,-9*E(3),-9*E(3)^2,-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),0,0,9,
9,9*E(3)^2,-9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,-9*E(3),-9*E(3)^2,-9*E(3),0,9,-9,
0,0,0],[-9,-9,-9*E(3)^2,-9*E(3),9,9,9,0,0,-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),
-9,-9,0,0,0,0,0,-9*E(3),9*E(3)^2,9*E(3),-9*E(3)^2,-9,-9*E(3)^2,-9*E(3),
-9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,0,0,9,9,9*E(3),-9*E(3)^2,-9*E(3),9*E(3)^2,
9*E(3),-9*E(3)^2,-9*E(3),-9*E(3)^2,0,9,-9,0,0,0],[(3+ER(-3))*3/2,
(3-ER(-3))*3/2,9*E(3),9*E(3)^2,-9,-9*E(3)^2,-9*E(3),0,0,9*E(3),9*E(3)^2,
9*E(3),9*E(3)^2,ER(-3)*3,-ER(-3)*3,(3-ER(-3))*3,(3+ER(-3))*3,0,0,0,9*E(3),
-9*E(3)^2,-9*E(3),9*E(3)^2,-9,-9*E(3),-9*E(3)^2,9,9,-9,-9,0,0,9*E(3)^2,9*E(3),
9*E(3),-9*E(3)^2,-9*E(3),9*E(3)^2,9,-9,-9,-9,ER(-3)*6,(3-ER(-3))*3/2,
(-3-ER(-3))*3/2,0,0,0],[(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,-9*E(3)^2,-9*E(3),9,
9*E(3),9*E(3)^2,0,0,-9*E(3)^2,-9*E(3),-9*E(3)^2,-9*E(3),ER(-3)*3,-ER(-3)*3,
(-3-ER(-3))*3,(-3+ER(-3))*3,0,0,0,-9*E(3)^2,9*E(3),9*E(3)^2,-9*E(3),9,
9*E(3)^2,9*E(3),-9,-9,9,9,0,0,-9*E(3),-9*E(3)^2,-9*E(3)^2,9*E(3),9*E(3)^2,
-9*E(3),-9,9,9,9,ER(-3)*6,(-3-ER(-3))*3/2,(3-ER(-3))*3/2,0,0,0],[9*E(3),
9*E(3)^2,9*E(3),9*E(3)^2,-9,-9*E(3)^2,-9*E(3),0,0,9*E(3),9*E(3)^2,-9*E(3),
-9*E(3)^2,9,9,0,0,0,0,0,9*E(3),-9*E(3)^2,-9*E(3),9*E(3)^2,9,9*E(3),9*E(3)^2,9,
9,-9,-9,0,0,-9*E(3)^2,-9*E(3),-9*E(3),9*E(3)^2,9*E(3),-9*E(3)^2,-9,9,9,9,0,
-9*E(3)^2,9*E(3),0,0,0],[-9*E(3)^2,-9*E(3),-9*E(3)^2,-9*E(3),9,9*E(3),
9*E(3)^2,0,0,-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),-9,-9,0,0,0,0,0,-9*E(3)^2,
9*E(3),9*E(3)^2,-9*E(3),-9,-9*E(3)^2,-9*E(3),-9,-9,9,9,0,0,9*E(3),9*E(3)^2,
9*E(3)^2,-9*E(3),-9*E(3)^2,9*E(3),9,-9,-9,-9,0,9*E(3),-9*E(3)^2,0,0,0],
[(3+ER(-3))*3/2,(3-ER(-3))*3/2,9*E(3)^2,9*E(3),-9,-9*E(3)^2,-9*E(3),0,0,
9*E(3)^2,9*E(3),9*E(3)^2,9*E(3),ER(-3)*3,-ER(-3)*3,(3-ER(-3))*3,(3+ER(-3))*3,
0,0,0,9,-9,-9,9,-9,-9*E(3)^2,-9*E(3),9*E(3)^2,9*E(3),-9*E(3)^2,-9*E(3),0,0,
9*E(3)^2,9*E(3),9,-9,-9,9,9*E(3)^2,-9*E(3),-9*E(3)^2,-9*E(3),ER(-3)*6,
(3-ER(-3))*3/2,(-3-ER(-3))*3/2,0,0,0],[(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,
-9*E(3),-9*E(3)^2,9,9*E(3),9*E(3)^2,0,0,-9*E(3),-9*E(3)^2,-9*E(3),-9*E(3)^2,
ER(-3)*3,-ER(-3)*3,(-3-ER(-3))*3,(-3+ER(-3))*3,0,0,0,-9,9,9,-9,9,9*E(3),
9*E(3)^2,-9*E(3),-9*E(3)^2,9*E(3),9*E(3)^2,0,0,-9*E(3),-9*E(3)^2,-9,9,9,-9,
-9*E(3),9*E(3)^2,9*E(3),9*E(3)^2,ER(-3)*6,(-3-ER(-3))*3/2,(3-ER(-3))*3/2,0,0,
0],[9*E(3),9*E(3)^2,9*E(3)^2,9*E(3),-9,-9*E(3)^2,-9*E(3),0,0,9*E(3)^2,9*E(3),
-9*E(3)^2,-9*E(3),9,9,0,0,0,0,0,9,-9,-9,9,9,9*E(3)^2,9*E(3),9*E(3)^2,9*E(3),
-9*E(3)^2,-9*E(3),0,0,-9*E(3)^2,-9*E(3),-9,9,9,-9,-9*E(3)^2,9*E(3),9*E(3)^2,
9*E(3),0,-9*E(3)^2,9*E(3),0,0,0],[9*E(3)^2,9*E(3),9*E(3),9*E(3)^2,-9,-9*E(3),
-9*E(3)^2,0,0,9*E(3),9*E(3)^2,-9*E(3),-9*E(3)^2,9,9,0,0,0,0,0,9,-9,-9,9,9,
9*E(3),9*E(3)^2,9*E(3),9*E(3)^2,-9*E(3),-9*E(3)^2,0,0,-9*E(3),-9*E(3)^2,-9,9,
9,-9,-9*E(3),9*E(3)^2,9*E(3),9*E(3)^2,0,-9*E(3),9*E(3)^2,0,0,0],[ER(-3)*2,
-ER(-3)*2,0,0,0,0,0,ER(-3)*6,-ER(-3)*6,-ER(-3)*6,ER(-3)*6,-ER(-3)*6,ER(-3)*6,
-ER(-3)*2,ER(-3)*2,-ER(-3)*4,ER(-3)*4,-ER(-3)*6,-ER(-3)*6,-ER(-3)*12,ER(-3)*6,
ER(-3)*6,0,0,0,0,0,0,0,-ER(-3)*6,ER(-3)*6,-ER(-3)*6,ER(-3)*6,0,0,ER(-3)*6,
ER(-3)*6,0,0,ER(-3)*6,ER(-3)*6,0,0,-ER(-3)*4,-ER(-3)*2,-ER(-3)*2,ER(-3)*6,
ER(-3)*6,ER(-3)*6],[ER(-3),-ER(-3),9*E(3),9*E(3)^2,-9,-9,-9,(3+ER(-3))*3,
(3-ER(-3))*3,(3+ER(-3))*3/2,(3-ER(-3))*3/2,(3+ER(-3))*3/2,(3-ER(-3))*3/2,
-ER(-3),ER(-3),-ER(-3)*2,ER(-3)*2,(-3-ER(-3))*3,(3-ER(-3))*3,-ER(-3)*6,
(3-ER(-3))*3/2,(-3-ER(-3))*3/2,-9*E(3)^2,9*E(3),-9,-9*E(3),-9*E(3)^2,9*E(3)^2,
9*E(3),(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,(3-ER(-3))*3,(3+ER(-3))*3,9,9,
(3-ER(-3))*3/2,(-3-ER(-3))*3/2,-9*E(3)^2,9*E(3),(3-ER(-3))*3/2,
(-3-ER(-3))*3/2,-9*E(3)^2,-9*E(3),-ER(-3)*2,-ER(-3),-ER(-3),-ER(-3)*6,
-ER(-3)*6,-ER(-3)*6],[ER(-3),-ER(-3),-9*E(3)^2,-9*E(3),9,9,9,(-3+ER(-3))*3,
(-3-ER(-3))*3,(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,(-3+ER(-3))*3/2,(-3-ER(-3))*3/2,
-ER(-3),ER(-3),-ER(-3)*2,ER(-3)*2,(3-ER(-3))*3,(-3-ER(-3))*3,-ER(-3)*6,
(-3-ER(-3))*3/2,(3-ER(-3))*3/2,9*E(3),-9*E(3)^2,9,9*E(3)^2,9*E(3),-9*E(3),
-9*E(3)^2,(3+ER(-3))*3/2,(3-ER(-3))*3/2,(-3-ER(-3))*3,(-3+ER(-3))*3,-9,-9,
(-3-ER(-3))*3/2,(3-ER(-3))*3/2,9*E(3),-9*E(3)^2,(-3-ER(-3))*3/2,
(3-ER(-3))*3/2,9*E(3),9*E(3)^2,-ER(-3)*2,-ER(-3),-ER(-3),-ER(-3)*6,-ER(-3)*6,
-ER(-3)*6],[ER(-3)*6,-ER(-3)*6,0,0,0,0,0,0,0,0,0,0,0,-ER(-3)*6,ER(-3)*6,
ER(-3)*6,-ER(-3)*6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
ER(-3)*6,-ER(-3)*6,-ER(-3)*6,18*E(9)^7-18*E(9)^2,-18*E(9)^5+18*E(9)^4,
-18*E(9)^7+18*E(9)^5-18*E(9)^4+18*E(9)^2],[ER(-3)*6,-ER(-3)*6,0,0,0,0,0,0,0,0,
0,0,0,-ER(-3)*6,ER(-3)*6,ER(-3)*6,-ER(-3)*6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,ER(-3)*6,-ER(-3)*6,-ER(-3)*6,-18*E(9)^5+18*E(9)^4,
-18*E(9)^7+18*E(9)^5-18*E(9)^4+18*E(9)^2,18*E(9)^7-18*E(9)^2],[ER(-3)*6,
-ER(-3)*6,0,0,0,0,0,0,0,0,0,0,0,-ER(-3)*6,ER(-3)*6,ER(-3)*6,-ER(-3)*6,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,ER(-3)*6,-ER(-3)*6,-ER(-3)*6,
-18*E(9)^7+18*E(9)^5-18*E(9)^4+18*E(9)^2,18*E(9)^7-18*E(9)^2,
-18*E(9)^5+18*E(9)^4]]/54,
 eigenvalues:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,E(3)^2,E(3)^2,E(3)^2,E(3)^2,
  E(3)^2,E(3)^2,E(3)^2,-1,-1,-1,E(3),E(3),E(3),E(3),E(3),E(3),-1,-1,E(3)^2,
  E(3)^2,-E(3)^2,-E(3)^2,E(3),E(3),-E(3),-E(3),1,1,1,E(9)^8,E(9)^5,E(9)^2],
       comment:="everything to explain",
	special:=1,cospecial:=2),
  [43,42,28,34,8,41,44,29,35,15,21,45,47,6,5,11,9,66,67,68,69,70,71,72,73,74,
   75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97],
   rec(signs:=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   -1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,-1,-1,-1])),
  Family(CHEVIE.families.QZ(3),[14,36,30,20,100,98,26,99,101],
    rec(signs:=[1,1,1,-1,-1,1,-1,-1,-1],special:=3,cospecial:=2)),
  Family(CHEVIE.families.X(3),[25,19,102],rec(signs:=[1,1,-1])),
  Family("X5",[4,7,104,103,3],rec(signs:=[1,1,-1,-1,1]))],
 a:=[0,1,21,21,6,6,21,6,6,1,6,1,2,11,6,4,2,1,16,11,6,4,2,1,16,11,4,6,6,11,2,5,4,
   6,6,11,2,5,3,3,6,6,6,6,6,4,6,4,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,5,6,6,6,6,6,6,
   6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,11,11,11,11,16,21,21],
 A:=[0,17,33,33,30,30,33,30,30,17,30,17,22,31,30,26,22,17,32,31,30,26,22,17,32,
   31,26,30,30,31,22,25,26,30,30,31,22,25,24,24,30,30,30,30,30,26,30,26,17,17,
   17,17,22,22,22,22,24,24,26,26,26,26,26,26,25,30,30,30,30,30,30,30,30,30,30,
   30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,31,31,31,
   31,32,33,33]);
end);

CHEVIE.AddData("Invariants","G26",
 [function(x1,x2,x3)
   return -10*x1^3*x2^3-10*x1^3*x3^3-10*x2^3*x3^3+x1^6+x2^6+x3^6;end,
  function(x1,x2,x3) return 2*x1^3*x2^3*x3^6+2*x1^3*x2^6*x3^3+x1^3*x2^9
   +x1^3*x3^9+x2^3*x3^9+2*x1^6*x2^3*x3^3-4*x1^6*x2^6-4*x1^6*x3^6-4*x2^6*x3^6
   +x1^9*x2^3+x1^9*x3^3+x2^9*x3^3;end,
  function(x1,x2,x3) return -2*x1^3*x2^3*x3^12+2*x1^3*x2^6*x3^9
   +2*x1^3*x2^9*x3^6-2*x1^3*x2^12*x3^3+2*x1^6*x2^3*x3^9-6*x1^6*x2^6*x3^6
   +2*x1^6*x2^9*x3^3+x1^6*x2^12+x1^6*x3^12+x2^6*x3^12+2*x1^9*x2^3*x3^6
   +2*x1^9*x2^6*x3^3-2*x1^9*x2^9-2*x1^9*x3^9-2*x2^9*x3^9-2*x1^12*x2^3*x3^3
   +x1^12*x2^6+x1^12*x3^6+x2^12*x3^6;end]
);

# the discriminant as a polynomial in the invariants
CHEVIE.AddData("Discriminant","G26",function()return function(t1,t2,t3)
  return 36*t1*t2*t3^2-t1^2*t2^2*t3+108*t3^3-32*t2^3*t3+t1^3*t3^2;
end;end);
