/*=============================================================================

    This file is part of FLINT.

    FLINT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    FLINT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FLINT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

=============================================================================*/
/******************************************************************************

    Copyright (C) 2010 Sebastian Pancratz

******************************************************************************/

#include <mpir.h>
#include "flint.h"
#include "fmpz.h"
#include "fmpz_poly.h"

void
_fmpz_poly_content(fmpz_t res, const fmpz * poly, long len)
{
    fmpz_zero(res);
    while (len--)
        fmpz_gcd(res, res, poly + len);
}

void
fmpz_poly_content(fmpz_t res, const fmpz_poly_t poly)
{
    fmpz_t t;
    fmpz_init(t);
    _fmpz_poly_content(t, poly->coeffs, poly->length);
    fmpz_swap(res, t);
    fmpz_clear(t);
}
