/*=============================================================================

    This file is part of FLINT.

    FLINT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    FLINT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FLINT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

=============================================================================*/
/******************************************************************************

    Copyright (C) 2011 Sebastian Pancratz

******************************************************************************/

#include <mpir.h>
#include "flint.h"
#include "fmpz.h"
#include "fmpz_mat.h"
#include "fmpq.h"
#include "fmpq_mat.h"

void fmpq_mat_transpose(fmpq_mat_t rop, const fmpq_mat_t op)
{
    long i, j;

    if (rop == op)
    {
        for (i = 0; i < rop->r; i++)
            for (j = 0; j < i; j++)
                fmpq_swap(fmpq_mat_entry(rop, i, j), 
                          fmpq_mat_entry(rop, j, i));
    }
    else
    {
        for (i = 0; i < rop->r; i++)
            for (j = 0; j < rop->c; j++)
                fmpq_set(fmpq_mat_entry(rop, i, j), 
                         fmpq_mat_entry(op, j, i));
    }
}

