#ifndef CoCoA_SparsePolyOps_H
#define CoCoA_SparsePolyOps_H

//   Copyright (c)  2017  John Abbott,  Anna M. Bigatti

//   This file is part of the source of CoCoALib, the CoCoA Library.

//   CoCoALib is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.

//   CoCoALib is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.

//   You should have received a copy of the GNU General Public License
//   along with CoCoALib.  If not, see <http://www.gnu.org/licenses/>.
//   -------------------------------------------------------------------------

#include "CoCoA/ring.H"


namespace CoCoA
{

  class ConstRefPPMonoidElem;

  RingElem CoeffHeight(ConstRefRingElem f);

  bool IsPalindromic(ConstRefRingElem f); // univariate only
  RingElem reverse(ConstRefRingElem f); // univariate only
  RingElem reverse(ConstRefRingElem f, ConstRefPPMonoidElem t);

  RingElem graeffe(ConstRefRingElem f);
  RingElem graeffe3(ConstRefRingElem f);

} // end of namespace CoCoA



// RCS header/log in the next few lines
// $Header: /Volumes/Home_1/cocoa/cvs-repository/CoCoALib-0.99/include/CoCoA/SparsePolyOps.H,v 1.2 2017/09/25 14:22:43 abbott Exp $
// $Log: SparsePolyOps.H,v $
// Revision 1.2  2017/09/25 14:22:43  abbott
// Summary: Added CoeffHeight
//
// Revision 1.1  2017/09/14 16:23:43  abbott
// Summary: Added graeffe, graeffe3
//
//

#endif
