#ifndef CoCoA_SparsePolyOps_ideal_H
#define CoCoA_SparsePolyOps_ideal_H

//   Copyright (c)  2017-2018  John Abbott,  Anna M. Bigatti

//   This file is part of the source of CoCoALib, the CoCoA Library.

//   CoCoALib is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.

//   CoCoALib is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.

//   You should have received a copy of the GNU General Public License
//   along with CoCoALib.  If not, see <http://www.gnu.org/licenses/>.
//   -------------------------------------------------------------------------

#include "CoCoA/PolyRing.H"
#include "CoCoA/MatrixForOrdering.H"

#include <vector>

namespace CoCoA
{

  class ideal;     // fwd decl -- defined in ideal.H
  class RingElem;  // fwd decl -- defined in ring.H
  class PPMonoidElem;  // fwd decl -- defined in PPMonoid.H
  
  //-- Special functions on ideals owned by SparsePolyRing ----------
  //-- defined in SparsePolyOps-ideal.C

  bool IsZeroDim(const ideal& I);
  bool IsHomog(const ideal& I);
  const std::vector<RingElem>& GBasis(const ideal& I);
  std::vector<RingElem> GBasisSelfSatCore(const ideal& I);
  std::vector<RingElem> GBasisRealSolveCore(const ideal& I);
  const std::vector<RingElem>& GBasisTimeout(const ideal& I, double TimeLimit);
  const std::vector<RingElem>& ReducedGBasis(const ideal& I);
  const std::vector<RingElem>& MinGens(const ideal& I);
  std::vector<ideal> PrimaryDecomposition(const ideal& I);
  ideal LT(const ideal& I);
  ideal LF(const ideal& I);
  ideal homog(const ideal& I, ConstRefRingElem x);
  ideal IdealOfGBasis(const ideal& I);
  ideal IdealOfMinGens(const ideal& I);
  std::vector<PPMonoidElem> QuotientBasis(const ideal& I);
  std::vector<PPMonoidElem> QuotientBasisSorted(const ideal& I);
  bool HasGBasis(const ideal& I);
  bool AreGensMonomial(const ideal& I);
  bool AreGensSqFreeMonomial(const ideal& I);
  void SetGBasisAsGens(const ideal& I);
  RingElem DenSigma(const ideal& I);
  bool IsSigmaGoodPrime(const BigInt& p, const ideal& I);
  bool IsSigmaGoodPrime(const long p, const ideal& I);

  bool IsRadical_0dim(const ideal& I); // will be IsRadical
  ideal radical_0dim(const ideal& I); // will be radical

  bool IsPrimary(const ideal& I);

} // end of namespace CoCoA



// RCS header/log in the next few lines
// $Header: /Volumes/Home_1/cocoa/cvs-repository/CoCoALib-0.99/include/CoCoA/SparsePolyOps-ideal.H,v 1.4 2018/04/06 15:42:26 bigatti Exp $
// $Log: SparsePolyOps-ideal.H,v $
// Revision 1.4  2018/04/06 15:42:26  bigatti
// -- copyright year
//
// Revision 1.3  2018/03/20 15:37:28  bigatti
// -- changed Radical0dim --> radical_0dim (etc)
//
// Revision 1.2  2018/03/20 11:14:12  bigatti
// -- added IsSigmaGoodPrime, DenSigma, Radical0dim, IsRadical0dim, IsPrimary
//
// Revision 1.1  2018/03/15 14:56:54  bigatti
// -- from SparsePolyRing.H
//

#endif
