/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.charcode.CharacterSet;
import com.icl.saxon.charcode.CharacterSetFactory;
import com.icl.saxon.output.ProxyEmitter;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class CDATAFilter
extends ProxyEmitter {
    private StringBuffer buffer = new StringBuffer();
    private Stack stack = new Stack();
    private int[] nameList;
    private CharacterSet characterSet;
    private boolean disableEscaping = false;

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        this.flush(this.buffer);
        this.stack.push(new Integer(n & 0xFFFFF));
        super.startElement(n, attributes, nArray, n2);
    }

    public void endElement(int n) throws TransformerException {
        this.flush(this.buffer);
        this.stack.pop();
        super.endElement(n);
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
        this.flush(this.buffer);
        super.processingInstruction(string, string2);
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        this.buffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws TransformerException {
        this.buffer.append(cArray, n, n2);
    }

    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        this.flush(this.buffer);
        super.comment(cArray, n, n2);
    }

    public void setEscaping(boolean bl) throws TransformerException {
        boolean bl2;
        if (this.stack.isEmpty()) {
            bl2 = false;
        } else {
            int n = (Integer)this.stack.peek();
            bl2 = this.isCDATA(n);
        }
        if (!bl2) {
            this.flush(this.buffer);
            this.disableEscaping = !bl;
            super.setEscaping(bl);
        } else if (!bl) {
            this.flush(this.buffer);
            this.disableEscaping = true;
            super.setEscaping(false);
        } else {
            this.flush(this.buffer);
            this.disableEscaping = false;
            super.setEscaping(true);
        }
    }

    public void flush(StringBuffer stringBuffer) throws TransformerException {
        int n;
        boolean bl;
        int n2 = stringBuffer.length();
        if (n2 == 0) {
            return;
        }
        if (this.stack.isEmpty()) {
            bl = false;
        } else {
            n = (Integer)this.stack.peek();
            bl = this.isCDATA(n);
        }
        if (bl & !this.disableEscaping) {
            char[] cArray;
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                if (!this.characterSet.inCharset(stringBuffer.charAt(n3))) {
                    cArray = new char[n3 - n];
                    stringBuffer.getChars(n, n3, cArray, 0);
                    this.flushCDATA(cArray, n3 - n);
                    super.setEscaping(true);
                    char[] cArray2 = new char[]{stringBuffer.charAt(n3)};
                    super.characters(cArray2, 0, 1);
                    super.setEscaping(false);
                    n = n3 + 1;
                }
                ++n3;
            }
            cArray = new char[n2 - n];
            stringBuffer.getChars(n, n2, cArray, 0);
            this.flushCDATA(cArray, n2 - n);
        } else {
            char[] cArray = new char[n2];
            stringBuffer.getChars(0, n2, cArray, 0);
            super.characters(cArray, 0, n2);
        }
        stringBuffer.setLength(0);
    }

    private void flushCDATA(char[] cArray, int n) throws TransformerException {
        super.setEscaping(false);
        super.characters("<![CDATA[".toCharArray(), 0, 9);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n - 2) {
            if (cArray[n2] == ']' && cArray[n2 + 1] == ']' && cArray[n2 + 2] == '>') {
                super.characters(cArray, n3, n2 + 2 - n3);
                super.characters("]]><![CDATA[".toCharArray(), 0, 12);
                n3 = n2 + 2;
            }
            ++n2;
        }
        super.characters(cArray, n3, n - n3);
        super.characters("]]>".toCharArray(), 0, 3);
        super.setEscaping(true);
    }

    public void setOutputProperties(Properties properties) {
        this.nameList = this.getCdataElements(properties);
        this.characterSet = CharacterSetFactory.getCharacterSet(properties);
        super.setOutputProperties(properties);
    }

    public boolean isCDATA(int n) {
        int n2 = 0;
        while (n2 < this.nameList.length) {
            if (this.nameList[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int[] getCdataElements(Properties properties) {
        Object object;
        String string = properties.getProperty("cdata-section-elements");
        if (string == null) {
            return new int[0];
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            ++n;
        }
        object = new int[n];
        n = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string);
        while (stringTokenizer2.hasMoreTokens()) {
            String string2 = stringTokenizer2.nextToken();
            object[n++] = this.getFingerprintForExpandedName(string2);
        }
        return object;
    }

    private int getFingerprintForExpandedName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("No closing '}' in parameter name");
            }
            string3 = string.substring(1, n);
            if (n == string.length()) {
                throw new IllegalArgumentException("Missing local part in parameter name");
            }
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.namePool.allocate("", string3, string2);
    }
}

