// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_MISC_JSON_HH
#define AWALI_MISC_JSON_HH

#include<iostream>
#include<sstream>

namespace awali { namespace sttc {

  std::ostream& tabs(std::ostream& o, int n) {
    for(int i=0; i<n; i++)
      o << "  ";
    return o;
  }

  std::ostream& js_formate(std::ostream& o, std::istream& i) {
    int depth=0;
    char c;
    bool inopen=false;
    bool instring=false;
    while(! i.eof()) {
      i.get(c);
      switch(c) {
      case '\n': case '\t': break;
      case '{':
      if(!instring) {
	inopen=true;
	if(depth>0)
	  o << std::endl;
	tabs(o,depth++);
      }
	o << '{';
	break;
      case '}':
      if(!instring) {
	--depth;
	if(depth<0)
	  return o;
	if(!inopen){
	  o << std::endl;
	  tabs(o,depth);
	}
	inopen=false;
      }
	o << '}';
	break;
      case '"' :
	instring=!instring;
      default :
	o << c;
      }
    }
    return o;
  }

  void check(std::istream& i, char e) {
    static char buffer[]="parser . <> .";
    buffer[7]=e;
    char c;
    do {
      i>>c;
    }while(c==' ' || c== '\n' || c== '\t');
    //std::cerr << c << '&' << std::endl;
    if(c!=e){
      buffer[12]=c;
      throw std::runtime_error(buffer);
    }
  }

  char peek(std::istream& i) {
    char c;
    while(1) {
      c=i.peek();
      if(c!=' ' && c!= '\n' && c!= '\t')
	return c;
      i.get(c);
    }
  }


  std::string parsestring(std::istream& i) {
    char c;
    i >> c;
    if(c!='"')
      throw std::runtime_error("parser \"");
    std::ostringstream o;
    while(true) {
      i.get(c);
      if(c=='"')
	break;
      o << c;
      if(c=='\\') {
	i.get(c);
	o << c;
      }
    }
    //std::cout << '>' << o.str() << '<' << std::endl;
    return o.str();
  }

  char parsecst(std::istream& i) {
    std::string s;
    int l;
    switch(i.peek()) {
    case 'n' : case 't': l=4; break;
    case 'f' : l=5; break;
    default:
      throw std::runtime_error("parser cst");
    }
    for(int n=0; n<l; ++n) {
      char c;
      i.get(c) ;
      s.append(1,c);
    }
    if(s!="true" && s!="none"  && s!="null" && s!= "false")
      throw std::runtime_error("parser cst");
    return s[0];
  }

  int parseint(std::istream& i) {
    int x;
    i >> x;
    return x;
  }

  std::string get_first_attr(std::istream& i) {
    check(i, '{');
    std::string attr = parsestring(i);
    check(i, ':');
    return attr;
  }

  void parseignore(std::istream& i) {
    switch(peek(i)) {
    case '"':
      parsestring(i);
      if(peek(i)!=':')
	return;
      check(i,':');
      parseignore(i);
      return;
    case '{':
      check(i,'{');
      while(peek(i)!='}')
	parseignore(i);
      check(i,'}');
      return;
    case '[' :
      check(i,'[');
      while(1) {
	parseignore(i);
	if(peek(i)!=',')
	  break;
	check(i,',');
      }
      check(i,']');
      return;
    case 't': case 'n' : case 'f':
      parsecst(i);
      return;
    default :
      throw std::runtime_error("Parse ignore");
    }
  }

}}//end of ns awali::stc

#endif 		//AWALI_MISC_JSON_HH

