// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_SINGLE_HISTORY_HH
# define AWALI_SINGLE_HISTORY_HH

# include <deque>
# include <iostream>
# include <map>
# include <utility>

#include <awali/sttc/ctx/context.hh>
#include <awali/sttc/ctx/traits.hh>
#include <awali/sttc/misc/map.hh> // has
#include <awali/sttc/history/history.hh>
# include <stdexcept>

namespace awali {
  namespace sttc {

    /*------------------------------.
      | single_history<Aut, Autb>.  |
      `------------------------------*/
    /// \tparam Aut   the automaton type
    /// \tparam Autb  the origin automaton type
    template <typename Autb>
    class single_history : public history_base
    {
    public:
      history_kind_t get_nature() const
      {
        return history_kind_t::SINGLE;
      }

      single_history(const Autb& from) : from_(from)
      {}

      std::ostream&
      print_state_name(state_t s, std::ostream& o,
                       const std::string& fmt) const
      {
	from_->print_state_history(origins_[s],o,fmt);
        return o;
      }


      /// A map from result state to original state.
      using origins_t = std::map<state_t, state_t>;

      const origins_t& origins() const
      {
	return origins_;
      }

      bool has_history(state_t s) const {
	return (origins_.find(s)!=origins_.end());
      }

      bool remove_history(state_t s) {
	return origins_.erase(s);
      };

      void
      add_state(state_t s,const state_t& sb)
      {
        origins_[s] = sb;
      }

      /// Origin automaton, supplied at construction time.
      Autb from_;

      state_t get_state(state_t s) {
	return origins_[s];
      }

      std::vector<state_t> get_state_set(state_t s) {
	throw std::runtime_error("Origin state set not available");
      }

      mutable origins_t origins_;
    };
  }
}//end of ns awali::stc

#endif // !AWALI_SINGLE_HISTORY_HH
