// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_STANDARD_CC
#define DYN_MODULES_STANDARD_CC

#include <iostream>
#include <unordered_map>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/core/abstract-ratexp.hh>
#include <awali/dyn/loading/handler.hh>

#include <awali/dyn/modules/standard.hh>

namespace awali { namespace dyn {
  bool is_standard(automaton_t aut) {
    return loading::call<bool, &is_standard>("is_standard", "standard", aut);
  }

  automaton_t standard(automaton_t aut) {
    return loading::call<automaton_t, &standard>("standard", "standard", aut);
  }

  void standard_here(automaton_t aut) {
    loading::call<void, &standard_here>("standard_here", "standard", aut);
  }

  automaton_t concatenate(automaton_t aut, automaton_t aut2) {
    return loading::call2<automaton_t, automaton_t, &concatenate>("concatenate", "standard", aut, aut2);
  }

  void concatenate_here(automaton_t aut, automaton_t aut2) {
    loading::call2<void, automaton_t, &concatenate_here>("concatenate_here", "standard", aut, aut2);
  }

  automaton_t sum(automaton_t aut, automaton_t aut2) {
    return loading::call2<automaton_t, automaton_t, &sum>("sum", "standard", aut, aut2);
  }

  void sum_here(automaton_t aut, automaton_t aut2) {
    loading::call2<void, automaton_t, &sum_here>("sum_here", "standard", aut, aut2);
  }

  automaton_t star(automaton_t aut) {
    return loading::call<automaton_t, &star>("star", "standard", aut);
  }

  void star_here(automaton_t aut) {
    loading::call<void, &star_here>("star_here", "standard", aut);
  }

    automaton_t standard(ratexp_t exp) {
    std::string stat_ctx = exp->get_context()->sname();
    typedef automaton_t (*bridge_t)(ratexp_t);
    static std::unordered_map<std::string, bridge_t> bridges;
    auto it = bridges.find(stat_ctx);
    if(it == bridges.end()) {
      auto bridge = (bridge_t) loading::get_handler("standard_of", "standard", stat_ctx);
      bridges.emplace(stat_ctx, bridge);
      return bridge(exp);
    }
    else
      return it->second(exp);
  }

}}//end of ns awali::dyn


#endif
