// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_PRODUCT_CC
#define DYN_MODULES_PRODUCT_CC

#include <unordered_map>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/loading/handler.hh>

#include <awali/dyn/modules/product.hh>

namespace awali { namespace dyn {

    automaton_t product(automaton_t aut1, automaton_t aut2, bool keep_history) {
      return loading::call_mixte2<automaton_t, bool, &product>("product", "product", aut1, aut2, keep_history);
  }

  automaton_t shuffle(automaton_t aut1, automaton_t aut2, bool keep_history) {
    return loading::call_mixte2<automaton_t, bool, &shuffle>("shuffle", "product", aut1, aut2, keep_history);
  }

  automaton_t infiltration(automaton_t aut1, automaton_t aut2, bool keep_history) {
    return loading::call_mixte2<automaton_t, bool, &infiltration>("infiltration", "product", aut1, aut2, keep_history);
  }

  automaton_t Union(automaton_t aut1, automaton_t aut2) {
    return loading::call_mixte<automaton_t, &Union>("Union", "product", aut1, aut2);
  }

}}//end of ns awali::dyn

#endif
