// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_DETERMINIZE_HH
#define DYN_DETERMINIZE_HH

#include <awali/dyn/core/automaton.hh>

//This module must not be used with zmin or zmax...
//Only for lal automata

namespace awali { namespace dyn {

  //Boolean automata only
  automaton_t determinize(automaton_t aut, bool history = true);
  automaton_t complement(automaton_t aut);
  void complement_here(automaton_t aut);
  automaton_t complete(automaton_t aut);
  void complete_here(automaton_t aut);

  //Automata over fields or z only
  automaton_t reduce(automaton_t aut);
  automaton_t left_reduce(automaton_t aut);

  bool is_deterministic(automaton_t aut);
  bool is_complete(automaton_t aut);
  bool is_ambiguous(automaton_t aut);

}}//end of ns awali::dyn

#endif
