// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_AUTOMATON_CC
#define DYN_MODULES_AUTOMATON_CC

#include <iostream>
#include <unordered_map>

#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/loading/handler.hh>
#include <awali/dyn/core/context-description.hh>

#include <awali/dyn/modules/automaton.hh>

namespace awali {
  namespace dyn {

    automaton_t copy(automaton_t aut) {
      return loading::call<automaton_t, &copy>("copy","automaton",aut);
    }

    automaton_t support(automaton_t aut) {
      return loading::call<automaton_t, &support>("support","automaton",aut);
    }

    automaton_t characteristic(automaton_t aut, std::string semiring) {
      std::string stat_ctx = aut->get_context()->labelname()+"_"+tostring(weightset(semiring),false);
      typedef automaton_t (*bridge_t)(automaton_t);
      static std::unordered_map<std::string, bridge_t> bridges;
      auto it = bridges.find(stat_ctx);
      if(it == bridges.end()) {
	auto bridge = (bridge_t) loading::get_handler("characteristic", "automaton", stat_ctx);
	bridges.emplace(stat_ctx, bridge);
	return bridge(aut);
      }
      else
	return it->second(aut);
      return aut;
    }

    //state_t add_state(automaton_t aut, std::string s) {
      //return loading::call2<state_t, std::string, &add_state>("add_state","automaton",aut, s);
    //}

    bool are_isomorphic(automaton_t aut1, automaton_t aut2) {
      return loading::call2<bool, automaton_t, &are_isomorphic>("are_isomorphic", "automaton",aut1, aut2);
    }
    automaton_t left_mult(automaton_t aut, weight_t w) {
      return loading::call2<automaton_t, weight_t, &left_mult>("left_mult", "automaton", aut,w);
    }

    void left_mult_here(automaton_t aut, weight_t w) {
      loading::call2<void, weight_t, &left_mult_here>("left_mult_here", "automaton", aut,w);
    }

    automaton_t right_mult(automaton_t aut, weight_t w) {
      return loading::call2<automaton_t, weight_t, &right_mult>("right_mult", "automaton", aut,w);
    }

    void right_mult_here(automaton_t aut, weight_t w) {
      loading::call2<void, weight_t, &right_mult_here>("right_mult_here", "automaton", aut,w);
    }

  }
}//end of ns awali::dyn

#endif
