// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_MAKEDIR_HH
#define AWALI_MAKEDIR_HH

#include<string>
#include<vector>

namespace awali { namespace dyn {

  namespace loading {
    std::vector<std::string> get_lib_directory();
    std::vector<std::string> get_dynlib_directory();
    std::vector<std::string> get_share_directory();
    std::vector<std::string> get_include_directory();
    std::vector<std::string> get_compilation_directory(std::string lname);
//     std::string get_source_directory();
//     std::string get_awali_directory();
    std::vector<std::string> get_dyn_config_hh_directory();
    int make_awali_dir();

    struct file_loc_t {
      std::string dir;
      std::string name;
      std::string ext;
      std::string desc;
    };

    std::vector<file_loc_t> example_automata();
  }

}}//end of ns awali::dyn

#endif
