// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_DYN_LOADING_HANDLER_CC
#define AWALI_DYN_LOADING_HANDLER_CC

#include <awali/dyn/loading/handler.hh>

namespace awali { namespace dyn {
  namespace loading {

    /* This function returns a pointer on the function 'name' of the library
       corresponding to the 'context'.
       If the library does not exist or does contain this function,
       make_library is called.
    */

    void* get_handler(const std::string name, const std::string group, const std::string& static_context) {
      make_awali_dir();
      std::string p(libname(static_context,group)+".so");

      std::string local = get_lib_directory()[0]+"/"+p;
      std::string global = get_lib_directory()[1]+"/"+p;
      auto handle = dlopen(local.c_str(), RTLD_NOW);
      if (handle==nullptr) {
        handle =dlopen(global.c_str(), RTLD_NOW);
        if (handle==nullptr) {
          make_library(group, static_context);
          handle = dlopen(local.c_str(), RTLD_NOW);
          if(handle==nullptr)
            throw std::runtime_error(std::string("dlopen failed after compilation: ") + dlerror());
        }
      }


//         char* msg = dlerror();
//         if (msg!= nullptr)
//           std::cerr << "error msg: " << msg << std::endl;
//         else
//           std::cerr << "no error msg" << std::endl;



//       std::cerr << "Open : " << name << " - " <<  handle << " - ";
//       char* msg = dlerror();
//       if (msg!= nullptr)
//         std::cerr << msg;
//       std::cerr << " - " << std::endl;
      auto bridge =  dlsym(handle, name.c_str());
      if (bridge==nullptr)
        throw std::runtime_error(std::string("dlsym failed: ") + dlerror());

//       std::cerr << bridge << " - ";
//       msg = dlerror();
//       if (msg!= nullptr)
//         std::cerr << msg;
//       std::cerr << " - " << std::endl;
      return bridge;
    }

    void* get_handler(const std::string name, const std::string group,
		      const std::string& static_context1,
                      const std::string& static_context2) {
      make_awali_dir();
      std::string p(libname(static_context1+"_"+static_context2,group)+".so");

      std::string local = get_lib_directory()[0]+"/"+p;
      std::string global = get_lib_directory()[1]+"/"+p;
      auto handle = dlopen(local.c_str(), RTLD_NOW);
      if (handle==nullptr) {
        handle = dlopen(global.c_str(), RTLD_NOW);
        if (handle==nullptr) {
          make_library(group, static_context1, static_context2);
          handle = dlopen(local.c_str(), RTLD_NOW);
          if(handle==nullptr)
            throw std::runtime_error(std::string("dlopen failed after compilation: ") + dlerror());
        }
      }
      // load the symbol
      // reset errors
      //   std::cerr << "Open : " << name << std::endl;
      auto bridge =  dlsym(handle, name.c_str());
      if (bridge==nullptr) {
        throw std::runtime_error(std::string("dlsym failed: ") + dlerror());
      }
      return bridge;
    }

    void* get_handler(const std::string name, const std::string& static_context) {
      return get_handler(name, name, static_context);
    }
  }//end of ns loading
}}//end of ns awali::dyn

#endif
