// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_RATEXP_HH
#define DYN_RATEXP_HH

#include<memory>
#include<vector>
#include<iostream>
#include <awali/dyn/core/any.hh>
#include <awali/dyn/core/abstract-context.hh>

namespace awali { namespace dyn {

  using label_t = any_t;
  using weight_t = any_t;

  enum class ExpKind {
    ZERO, ONE, ATOM, SUM, PROD, STAR
      };

  struct abstract_ratexp_t;
  using ratexp_t = std::shared_ptr<abstract_ratexp_t>;

  struct abstract_ratexp_t {

    virtual std::vector<label_t> alphabet() const = 0;
    virtual context_t get_context() const = 0;

    virtual std::ostream& print(std::ostream&) const = 0;
    virtual std::ostream& json(std::ostream&) const = 0;

    virtual ratexp_t lmul(weight_t) const =0;
    virtual ratexp_t rmul(weight_t) const =0;
    virtual ratexp_t add(ratexp_t) const =0;
    virtual ratexp_t mult(ratexp_t) const =0;
    virtual ratexp_t star() const =0;

    virtual unsigned arity() const =0;
    virtual const std::vector<ratexp_t>& children() const =0;

    virtual ExpKind get_kind() const =0;
    virtual weight_t lweight() const =0;
    virtual weight_t rweight() const =0;
    virtual label_t value() const =0;

    virtual ~abstract_ratexp_t() {}
  };


  ratexp_t operator+(ratexp_t e1, ratexp_t e2);
  ratexp_t operator*(ratexp_t e1, ratexp_t e2);
  std::ostream& operator<<(std::ostream& o, ratexp_t e);

}}//end of ns awali::dyn

#endif
