// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_RATEXP_HH
#define DYN_MODULES_RATEXP_HH

#include <iostream>
#include <set>
#include <unordered_map>
#include <awali/dyn/core/abstract-ratexp.hh>
#include <awali/dyn/loading/handler.hh>
#include <awali/dyn/core/context-description.hh>

namespace awali {
  namespace dyn {

    ratexp_t make_ratexp(const std::string& exp, const std::string& sr);
    ratexp_t make_ratexp(const std::string& exp);

    ratexp_t aut_to_exp(automaton_t aut);
    automaton_t lift(automaton_t aut);
    ratexp_t expand(ratexp_t exp);
    ratexp_t star_normal_form(ratexp_t exp);
    unsigned star_height(ratexp_t exp);
    bool is_valid(ratexp_t exp);
    weight_t constant_term(ratexp_t exp);
    
  }
}//end of ns awali::dyn

#endif
