// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/sttc/algos/min_quotient.hh>
#include <awali/sttc/algos/is-quotient.hh>
#include <awali/sttc/algos/is-congruence.hh>
#include <awali/sttc/algos/merge.hh>
#include <awali/dyn/bridge-sttc/explicit-automaton.cc>
#include<stdexcept>

#include<set-types.hh>


namespace awali {

  extern "C" dyn::automaton_t min_quotient(dyn::automaton_t aut, param_t dir) {
      auto a=dyn::get_stc_automaton<context_t>(aut);
      return dyn::make_automaton(sttc::min_quotient(a,dir));
  }

  extern "C" dyn::automaton_t min_quotient_det(dyn::automaton_t aut, param_t dir) {
      auto a=dyn::get_stc_automaton<context_t>(aut);
      return dyn::make_automaton(sttc::min_quotient_det(a,dir));
  }

  extern "C" dyn::automaton_t merge(dyn::automaton_t aut, std::vector<std::vector<dyn::state_t>>& equiv) {
    auto a=dyn::get_stc_automaton<context_t>(aut);
    return dyn::make_automaton(sttc::merge(a, equiv));
  }

  extern "C" bool is_congruence(dyn::automaton_t aut, std::vector<std::vector<dyn::state_t>>& equiv) {
    auto a=dyn::get_stc_automaton<context_t>(aut);
    return sttc::is_congruence(a, equiv);
  }

  extern "C" bool is_quotient(dyn::automaton_t aut1, dyn::automaton_t aut2) {
      auto a1=dyn::get_stc_automaton<context_t>(aut1);
      auto a2=dyn::get_stc_automaton<context_t>(aut2);
      return sttc::is_quotient(a1, a2);
  }

}

